{"vars":[{"containerName":"","name":"vars","kind":2,"line":105},{"containerName":"","name":"Carp","line":107,"kind":2},{"name":"$ID","containerName":null,"line":112,"kind":13},{"name":"Version","containerName":"Bio::Root","kind":2,"line":112},{"containerName":null,"name":"$DEBUG","kind":13,"line":113},{"line":114,"kind":13,"containerName":null,"name":"$VERBOSITY"},{"line":117,"children":[{"line":118,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"containerName":"new","definition":"my","name":"@args","localvar":"my","kind":13,"line":119},{"line":120,"kind":13,"containerName":"new","name":"$ENV"},{"kind":12,"line":124,"name":"new","containerName":"new"},{"kind":13,"line":124,"containerName":"new","name":"@args"}],"kind":12,"range":{"start":{"line":117,"character":0},"end":{"line":125,"character":9999}},"containerName":"main::","definition":"sub","name":"new"},{"name":"carp","line":121,"kind":12},{"line":124,"kind":12,"name":"Bio","containerName":"Root::Root"},{"name":"_initialize","range":{"end":{"line":131,"character":9999},"start":{"character":0,"line":128}},"kind":12,"children":[{"containerName":"_initialize","name":"$self","definition":"my","localvar":"my","kind":13,"line":129},{"kind":13,"line":129,"name":"@args","containerName":"_initialize"}],"line":128,"definition":"sub","containerName":"main::","signature":{"documentation":" for backwards compatibility","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"detail":"($self,@args)"},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"throw","line":147,"kind":13},{"name":"$string","containerName":"throw","kind":13,"line":147},{"localvar":"my","containerName":"throw","definition":"my","name":"$std","line":149,"kind":13},{"name":"$self","containerName":"throw","kind":13,"line":149},{"kind":12,"line":149,"name":"stack_trace_dump","containerName":"throw"},{"localvar":"my","containerName":"throw","definition":"my","name":"$out","line":151,"kind":13},{"kind":13,"line":152,"name":"$string","containerName":"throw"},{"line":152,"kind":13,"containerName":"throw","name":"$std"},{"name":"$out","containerName":"throw","kind":13,"line":153}],"line":146,"definition":"sub","containerName":"main::","signature":{"label":"throw($self,$string)","documentation":"1;\n# $Id: RootI.pm 16090 2009-09-15 21:57:56Z cjfields $\n#\n# BioPerl module for Bio::Root::RootI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n# \n# This was refactored to have chained calls to new instead\n# of chained calls to _initialize\n#\n# added debug and deprecated methods --Jason Stajich 2001-10-12\n# \n\n=head1 NAME\n\nBio::Root::RootI - Abstract interface to root object code\n\n=head1 SYNOPSIS\n\n  # any bioperl or bioperl compliant object is a RootI \n  # compliant object\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Using throw_not_implemented() within a RootI-based interface module:\n\n  package Foo;\n  use base qw(Bio::Root::RootI);\n\n  sub foo {\n      my $self = shift;\n      $self->throw_not_implemented;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is just a set of methods which do not assume B<anything> about the object\nthey are on. The methods provide the ability to throw exceptions with nice\nstack traces.\n\nThis is what should be inherited by all Bioperl compliant interfaces, even\nif they are exotic XS/CORBA/Other perl systems.\n\n=head2 Using throw_not_implemented()\n\nThe method L<throw_not_implemented()|throw_not_implemented> should be\ncalled by all methods within interface modules that extend RootI so\nthat if an implementation fails to override them, an exception will be\nthrown.\n\nFor example, say there is an interface module called C<FooI> that\nprovides a method called C<foo()>. Since this method is considered\nabstract within FooI and should be implemented by any module claiming to\nimplement C<FooI>, the C<FooI::foo()> method should consist of the\nfollowing:\n\n    sub foo {\n    \tmy $self = shift;\n    \t$self->throw_not_implemented;\n    }\n\nSo, if an implementer of C<FooI> forgets to implement C<foo()>\nand a user of the implementation calls C<foo()>, a\nL<Bio::Exception::NotImplemented> exception will result.\n\nUnfortunately, failure to implement a method can only be determined at\nrun time (i.e., you can't verify that an implementation is complete by\nrunning C<perl -wc> on it). So it should be standard practice for a test\nof an implementation to check each method and verify that it doesn't\nthrow a L<Bio::Exception::NotImplemented>.\n\n=head1 CONTACT\n\nFunctions originally from Steve Chervitz. Refactored by Ewan\nBirney. Re-refactored by Lincoln Stein. Added to by Sendu Bala.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Root::RootI;\n\nuse vars qw($DEBUG $ID $VERBOSITY);\nuse strict;\nuse Carp 'confess','carp';\n\nuse Bio::Root::Version;\n\nBEGIN { \n    $ID        = 'Bio::Root::RootI';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n}\n\nsub new {\n  my $class = shift;\n  my @args = @_;\n  unless ( $ENV{'BIOPERLDEBUG'} ) {\n      carp(\"Use of new in Bio::Root::RootI is deprecated.  Please use Bio::Root::Root instead\");\n  }\n  eval \"require Bio::Root::Root\";\n  return Bio::Root::Root->new(@args);\n}\n\n# for backwards compatibility\nsub _initialize {\n    my($self,@args) = @_;\n    return 1;\n}\n\n\n=head2 throw\n\n Title   : throw\n Usage   : $obj->throw(\"throwing exception message\")\n Function: Throws an exception, which, if not caught with an eval brace\n           will provide a nice stack trace to STDERR with the message\n Returns : nothing\n Args    : A string giving a descriptive error message","parameters":[{"label":"$self"},{"label":"$string"}]},"detail":"($self,$string)","name":"throw","range":{"end":{"line":155,"character":9999},"start":{"line":146,"character":0}}},{"name":"warn","range":{"end":{"line":192,"character":9999},"start":{"line":172,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$string)","signature":{"documentation":"1;\n# $Id: RootI.pm 16090 2009-09-15 21:57:56Z cjfields $\n#\n# BioPerl module for Bio::Root::RootI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n# \n# This was refactored to have chained calls to new instead\n# of chained calls to _initialize\n#\n# added debug and deprecated methods --Jason Stajich 2001-10-12\n# \n\n=head1 NAME\n\nBio::Root::RootI - Abstract interface to root object code\n\n=head1 SYNOPSIS\n\n  # any bioperl or bioperl compliant object is a RootI \n  # compliant object\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Using throw_not_implemented() within a RootI-based interface module:\n\n  package Foo;\n  use base qw(Bio::Root::RootI);\n\n  sub foo {\n      my $self = shift;\n      $self->throw_not_implemented;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is just a set of methods which do not assume B<anything> about the object\nthey are on. The methods provide the ability to throw exceptions with nice\nstack traces.\n\nThis is what should be inherited by all Bioperl compliant interfaces, even\nif they are exotic XS/CORBA/Other perl systems.\n\n=head2 Using throw_not_implemented()\n\nThe method L<throw_not_implemented()|throw_not_implemented> should be\ncalled by all methods within interface modules that extend RootI so\nthat if an implementation fails to override them, an exception will be\nthrown.\n\nFor example, say there is an interface module called C<FooI> that\nprovides a method called C<foo()>. Since this method is considered\nabstract within FooI and should be implemented by any module claiming to\nimplement C<FooI>, the C<FooI::foo()> method should consist of the\nfollowing:\n\n    sub foo {\n    \tmy $self = shift;\n    \t$self->throw_not_implemented;\n    }\n\nSo, if an implementer of C<FooI> forgets to implement C<foo()>\nand a user of the implementation calls C<foo()>, a\nL<Bio::Exception::NotImplemented> exception will result.\n\nUnfortunately, failure to implement a method can only be determined at\nrun time (i.e., you can't verify that an implementation is complete by\nrunning C<perl -wc> on it). So it should be standard practice for a test\nof an implementation to check each method and verify that it doesn't\nthrow a L<Bio::Exception::NotImplemented>.\n\n=head1 CONTACT\n\nFunctions originally from Steve Chervitz. Refactored by Ewan\nBirney. Re-refactored by Lincoln Stein. Added to by Sendu Bala.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Root::RootI;\n\nuse vars qw($DEBUG $ID $VERBOSITY);\nuse strict;\nuse Carp 'confess','carp';\n\nuse Bio::Root::Version;\n\nBEGIN { \n    $ID        = 'Bio::Root::RootI';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n}\n\nsub new {\n  my $class = shift;\n  my @args = @_;\n  unless ( $ENV{'BIOPERLDEBUG'} ) {\n      carp(\"Use of new in Bio::Root::RootI is deprecated.  Please use Bio::Root::Root instead\");\n  }\n  eval \"require Bio::Root::Root\";\n  return Bio::Root::Root->new(@args);\n}\n\n# for backwards compatibility\nsub _initialize {\n    my($self,@args) = @_;\n    return 1;\n}\n\n\n=head2 throw\n\n Title   : throw\n Usage   : $obj->throw(\"throwing exception message\")\n Function: Throws an exception, which, if not caught with an eval brace\n           will provide a nice stack trace to STDERR with the message\n Returns : nothing\n Args    : A string giving a descriptive error message\n\n\n\nsub throw{\n   my ($self,$string) = @_;\n\n   my $std = $self->stack_trace_dump();\n\n   my $out = \"\\n-------------------- EXCEPTION --------------------\\n\".\n       \"MSG: \".$string.\"\\n\".$std.\"-------------------------------------------\\n\";\n   die $out;\n\n}\n\n=head2 warn\n\n Title   : warn\n Usage   : $object->warn(\"Warning message\");\n Function: Places a warning. What happens now is down to the\n           verbosity of the object  (value of $obj->verbose) \n            verbosity 0 or not set => small warning\n            verbosity -1 => no warning\n            verbosity 1 => warning with stack trace\n            verbosity 2 => converts warnings into throw\n Returns : n/a\n Args    : string (the warning message)","parameters":[{"label":"$self"},{"label":"$string"}],"label":"warn($self,$string)"},"kind":12,"line":172,"children":[{"containerName":"warn","name":"$self","definition":"my","localvar":"my","kind":13,"line":173},{"name":"$string","containerName":"warn","line":173,"kind":13},{"localvar":"my","definition":"my","name":"$verbose","containerName":"warn","line":175,"kind":13},{"containerName":"warn","name":"$self","line":175,"kind":13},{"line":175,"kind":12,"containerName":"warn","name":"verbose"},{"definition":"my","name":"$header","containerName":"warn","localvar":"my","kind":13,"line":177},{"definition":"my","name":"$footer","containerName":"warn","localvar":"my","kind":13,"line":178},{"line":180,"kind":13,"name":"$verbose","containerName":"warn"},{"name":"$self","containerName":"warn","line":181,"kind":13},{"line":181,"kind":12,"name":"throw","containerName":"warn"},{"containerName":"warn","name":"$string","kind":13,"line":181},{"kind":13,"line":183,"containerName":"warn","name":"$verbose"},{"containerName":"warn","name":"$verbose","line":186,"kind":13},{"line":187,"kind":13,"name":"$header","containerName":"warn"},{"line":187,"kind":13,"name":"$string","containerName":"warn"},{"name":"$self","containerName":"warn","line":187,"kind":13},{"name":"stack_trace_dump","containerName":"warn","kind":12,"line":187},{"name":"$footer","containerName":"warn","line":187,"kind":13},{"line":191,"kind":13,"containerName":"warn","name":"$header"},{"kind":13,"line":191,"name":"$string","containerName":"warn"},{"name":"$footer","containerName":"warn","line":191,"kind":13}]},{"containerName":"warn","name":"CORE","line":187,"kind":12},{"containerName":"warn","name":"CORE","kind":12,"line":191},{"containerName":"main::","definition":"sub","name":"deprecated","range":{"end":{"line":267,"character":9999},"start":{"character":0,"line":244}},"kind":12,"line":244,"children":[{"kind":13,"line":245,"containerName":"deprecated","definition":"my","name":"$self","localvar":"my"},{"name":"$msg","definition":"my","containerName":"deprecated","localvar":"my","kind":13,"line":246},{"kind":13,"line":246,"containerName":"deprecated","name":"$version"},{"containerName":"deprecated","name":"$warn_version","line":246,"kind":13},{"line":246,"kind":13,"name":"$throw_version","containerName":"deprecated"},{"name":"$self","containerName":"deprecated","line":247,"kind":13},{"containerName":"deprecated","name":"_rearrange","kind":12,"line":247},{"kind":13,"line":248,"name":"$version","containerName":"deprecated"},{"containerName":"deprecated","name":"$throw_version","line":248,"kind":13},{"kind":13,"line":249,"definition":"my","name":"$v","containerName":"deprecated","localvar":"my"},{"line":249,"kind":13,"containerName":"deprecated","name":"$warn_version"},{"containerName":"deprecated","name":"$version","kind":13,"line":249},{"containerName":"deprecated","name":"$v","kind":13,"line":250},{"kind":13,"line":251,"containerName":"deprecated","name":"$self"},{"name":"throw","containerName":"deprecated","line":251,"kind":12},{"containerName":"deprecated","name":"$v","kind":13,"line":252},{"kind":13,"line":252,"containerName":"deprecated","name":"$v"},{"line":254,"kind":13,"name":"$warn_version","containerName":"deprecated"},{"kind":13,"line":254,"name":"$Bio","containerName":"deprecated"},{"name":"$warn_version","containerName":"deprecated","kind":13,"line":254},{"name":"$msg","containerName":"deprecated","kind":13,"line":257},{"name":"$version","containerName":"deprecated","kind":13,"line":259},{"name":"$msg","containerName":"deprecated","kind":13,"line":260},{"containerName":"deprecated","name":"$Bio","line":261,"kind":13},{"name":"$version","containerName":"deprecated","kind":13,"line":261},{"name":"$self","containerName":"deprecated","kind":13,"line":262},{"kind":12,"line":262,"name":"throw","containerName":"deprecated"},{"name":"$msg","containerName":"deprecated","line":262,"kind":13},{"line":266,"kind":13,"containerName":"deprecated","name":"$self"},{"kind":12,"line":266,"name":"warn","containerName":"deprecated"},{"kind":13,"line":266,"name":"$msg","containerName":"deprecated"}]},{"containerName":"Version::VERSION","name":"Root","kind":12,"line":254},{"name":"Root","containerName":"Version::VERSION","kind":12,"line":261},{"kind":12,"line":281,"children":[{"line":282,"kind":13,"localvar":"my","containerName":"stack_trace_dump","definition":"my","name":"$self"},{"line":284,"kind":13,"localvar":"my","containerName":"stack_trace_dump","name":"@stack","definition":"my"},{"kind":13,"line":284,"name":"$self","containerName":"stack_trace_dump"},{"containerName":"stack_trace_dump","name":"stack_trace","line":284,"kind":12},{"name":"@stack","containerName":"stack_trace_dump","kind":13,"line":286},{"containerName":"stack_trace_dump","name":"@stack","line":287,"kind":13},{"kind":13,"line":288,"containerName":"stack_trace_dump","name":"@stack"},{"name":"$out","definition":"my","containerName":"stack_trace_dump","localvar":"my","kind":13,"line":290},{"kind":13,"line":291,"containerName":"stack_trace_dump","definition":"my","name":"$module","localvar":"my"},{"name":"$function","containerName":"stack_trace_dump","line":291,"kind":13},{"line":291,"kind":13,"containerName":"stack_trace_dump","name":"$file"},{"name":"$position","containerName":"stack_trace_dump","line":291,"kind":13},{"localvar":"my","definition":"my","name":"$stack","containerName":"stack_trace_dump","line":294,"kind":13},{"name":"@stack","containerName":"stack_trace_dump","kind":13,"line":294},{"kind":13,"line":295,"name":"$module","containerName":"stack_trace_dump"},{"name":"$file","containerName":"stack_trace_dump","line":295,"kind":13},{"name":"$position","containerName":"stack_trace_dump","line":295,"kind":13},{"name":"$function","containerName":"stack_trace_dump","line":295,"kind":13},{"line":295,"kind":13,"name":"$stack","containerName":"stack_trace_dump"},{"containerName":"stack_trace_dump","name":"$out","kind":13,"line":296}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: RootI.pm 16090 2009-09-15 21:57:56Z cjfields $\n#\n# BioPerl module for Bio::Root::RootI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n# \n# This was refactored to have chained calls to new instead\n# of chained calls to _initialize\n#\n# added debug and deprecated methods --Jason Stajich 2001-10-12\n# \n\n=head1 NAME\n\nBio::Root::RootI - Abstract interface to root object code\n\n=head1 SYNOPSIS\n\n  # any bioperl or bioperl compliant object is a RootI \n  # compliant object\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Using throw_not_implemented() within a RootI-based interface module:\n\n  package Foo;\n  use base qw(Bio::Root::RootI);\n\n  sub foo {\n      my $self = shift;\n      $self->throw_not_implemented;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is just a set of methods which do not assume B<anything> about the object\nthey are on. The methods provide the ability to throw exceptions with nice\nstack traces.\n\nThis is what should be inherited by all Bioperl compliant interfaces, even\nif they are exotic XS/CORBA/Other perl systems.\n\n=head2 Using throw_not_implemented()\n\nThe method L<throw_not_implemented()|throw_not_implemented> should be\ncalled by all methods within interface modules that extend RootI so\nthat if an implementation fails to override them, an exception will be\nthrown.\n\nFor example, say there is an interface module called C<FooI> that\nprovides a method called C<foo()>. Since this method is considered\nabstract within FooI and should be implemented by any module claiming to\nimplement C<FooI>, the C<FooI::foo()> method should consist of the\nfollowing:\n\n    sub foo {\n    \tmy $self = shift;\n    \t$self->throw_not_implemented;\n    }\n\nSo, if an implementer of C<FooI> forgets to implement C<foo()>\nand a user of the implementation calls C<foo()>, a\nL<Bio::Exception::NotImplemented> exception will result.\n\nUnfortunately, failure to implement a method can only be determined at\nrun time (i.e., you can't verify that an implementation is complete by\nrunning C<perl -wc> on it). So it should be standard practice for a test\nof an implementation to check each method and verify that it doesn't\nthrow a L<Bio::Exception::NotImplemented>.\n\n=head1 CONTACT\n\nFunctions originally from Steve Chervitz. Refactored by Ewan\nBirney. Re-refactored by Lincoln Stein. Added to by Sendu Bala.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Root::RootI;\n\nuse vars qw($DEBUG $ID $VERBOSITY);\nuse strict;\nuse Carp 'confess','carp';\n\nuse Bio::Root::Version;\n\nBEGIN { \n    $ID        = 'Bio::Root::RootI';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n}\n\nsub new {\n  my $class = shift;\n  my @args = @_;\n  unless ( $ENV{'BIOPERLDEBUG'} ) {\n      carp(\"Use of new in Bio::Root::RootI is deprecated.  Please use Bio::Root::Root instead\");\n  }\n  eval \"require Bio::Root::Root\";\n  return Bio::Root::Root->new(@args);\n}\n\n# for backwards compatibility\nsub _initialize {\n    my($self,@args) = @_;\n    return 1;\n}\n\n\n=head2 throw\n\n Title   : throw\n Usage   : $obj->throw(\"throwing exception message\")\n Function: Throws an exception, which, if not caught with an eval brace\n           will provide a nice stack trace to STDERR with the message\n Returns : nothing\n Args    : A string giving a descriptive error message\n\n\n\nsub throw{\n   my ($self,$string) = @_;\n\n   my $std = $self->stack_trace_dump();\n\n   my $out = \"\\n-------------------- EXCEPTION --------------------\\n\".\n       \"MSG: \".$string.\"\\n\".$std.\"-------------------------------------------\\n\";\n   die $out;\n\n}\n\n=head2 warn\n\n Title   : warn\n Usage   : $object->warn(\"Warning message\");\n Function: Places a warning. What happens now is down to the\n           verbosity of the object  (value of $obj->verbose) \n            verbosity 0 or not set => small warning\n            verbosity -1 => no warning\n            verbosity 1 => warning with stack trace\n            verbosity 2 => converts warnings into throw\n Returns : n/a\n Args    : string (the warning message)\n\n\nsub warn {\n    my ($self,$string) = @_;\n    \n    my $verbose = $self->verbose;\n    \n    my $header = \"\\n--------------------- WARNING ---------------------\\nMSG: \";\n    my $footer =   \"---------------------------------------------------\\n\";\n    \n    if ($verbose >= 2) {\n        $self->throw($string);\n    }\n    elsif ($verbose <= -1) {\n        return;\n    }\n    elsif ($verbose == 1) {\n        CORE::warn $header, $string, \"\\n\", $self->stack_trace_dump, $footer;\n        return;\n    }    \n    \n    CORE::warn $header, $string, \"\\n\", $footer;\n}\n\n=head2 deprecated\n\n Title   : deprecated\n Usage   : $obj->deprecated(\"Method X is deprecated\");\n           $obj->deprecated(\"Method X is deprecated\", 1.007);\n           $obj->deprecated(-message => \"Method X is deprecated\");\n           $obj->deprecated(-message => \"Method X is deprecated\",\n                            -version => 1.007);\n Function: Prints a message about deprecation unless verbose is < 0\n           (which means be quiet)\n Returns : none\n Args    : Message string to print to STDERR\n           Version of BioPerl where use of the method results in an exception\n Notes   : The method can be called two ways, either by positional arguments:\n           \n           $obj->deprecated('This module is deprecated', 1.006);\n           \n           or by named arguments:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -version => 1.006  # throw if $VERSION is >= this version\n                );\n\n           or timed to go off at a certain point:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -warn_version    => 1.006 # warn if $VERSION is >= this version\n                -throw_version   => 1.007 # throw if $VERSION is >= this version\n                );\n           \n           Using the last two named argument versions is suggested and will\n           likely be the only supported way of calling this method in the future\n           Yes, we see the irony of deprecating that particular usage of\n           deprecated().\n           \n           The main difference between usage of the two named argument versions\n           is that by designating a 'warn_version' one indicates the\n           functionality is officially deprecated beginning in a future version\n           of BioPerl (so warnings are issued only after that point), whereas\n           setting either 'version' or 'throw_version' (synonyms) converts the\n           deprecation warning to an exception.\n           \n           For proper comparisons one must use a version in lines with the\n           current versioning scheme for Perl and BioPerl, (i.e. where 1.006000\n           indicates v1.6.0, 5.010000 for v5.10.0, etc.).\n\n\nsub deprecated{\n    my ($self) = shift;\n    my ($msg, $version, $warn_version, $throw_version) =\n        $self->_rearrange([qw(MESSAGE VERSION WARN_VERSION THROW_VERSION)], @_);    \n    $version ||= $throw_version;\n    for my $v ($warn_version, $version) {\n        next unless defined $v;\n        $self->throw('Version must be numerical, such as 1.006000 for v1.6.0, not '.\n                     $v) unless $v =~ /^\\d+\\.\\d+$/;\n    }\n    return if ($warn_version && $Bio::Root::Version::VERSION < $warn_version);\n    # below default insinuates we're deprecating a method and not a full module\n    # but it's the most common use case\n    $msg ||= \"Use of \".(caller(1))[3].\"() is deprecated\";\n    # delegate to either warn or throw based on whether a version is given\n    if ($version) {\n        $msg .= \"\\nTo be removed in $version\";\n        if ($Bio::Root::Version::VERSION >= $version) {\n            $self->throw($msg)\n        } \n    }\n    # passing this on to warn() should deal properly with verbosity issues\n    $self->warn($msg);\n}\n\n=head2 stack_trace_dump\n\n Title   : stack_trace_dump\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"}],"label":"stack_trace_dump($self)"},"name":"stack_trace_dump","range":{"start":{"line":281,"character":0},"end":{"character":9999,"line":297}}},{"kind":13,"line":299,"containerName":null,"name":"$out"},{"range":{"start":{"line":315,"character":0},"end":{"character":9999,"line":331}},"name":"stack_trace","children":[{"line":316,"kind":13,"localvar":"my","containerName":"stack_trace","name":"$self","definition":"my"},{"line":318,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":"stack_trace"},{"line":319,"kind":13,"localvar":"my","containerName":"stack_trace","name":"@out","definition":"my"},{"localvar":"my","containerName":"stack_trace","name":"$prev","definition":"my","line":320,"kind":13},{"kind":13,"line":321,"containerName":"stack_trace","name":"@call","definition":"my","localvar":"my"},{"containerName":"stack_trace","name":"$i","line":321,"kind":13},{"name":"$prev","containerName":"stack_trace","kind":13,"line":324},{"line":324,"kind":13,"containerName":"stack_trace","name":"$call"},{"containerName":"stack_trace","name":"@out","kind":13,"line":325},{"containerName":"stack_trace","name":"$prev","line":325,"kind":13},{"containerName":"stack_trace","name":"$prev","kind":13,"line":326},{"kind":13,"line":326,"containerName":"stack_trace","name":"@call"},{"containerName":"stack_trace","name":"$prev","line":328,"kind":13},{"kind":13,"line":329,"containerName":"stack_trace","name":"@out"},{"line":329,"kind":13,"name":"$prev","containerName":"stack_trace"},{"kind":13,"line":330,"containerName":"stack_trace","name":"@out"}],"line":315,"kind":12,"signature":{"label":"stack_trace($self)","documentation":"1;\n# $Id: RootI.pm 16090 2009-09-15 21:57:56Z cjfields $\n#\n# BioPerl module for Bio::Root::RootI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n# \n# This was refactored to have chained calls to new instead\n# of chained calls to _initialize\n#\n# added debug and deprecated methods --Jason Stajich 2001-10-12\n# \n\n=head1 NAME\n\nBio::Root::RootI - Abstract interface to root object code\n\n=head1 SYNOPSIS\n\n  # any bioperl or bioperl compliant object is a RootI \n  # compliant object\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Using throw_not_implemented() within a RootI-based interface module:\n\n  package Foo;\n  use base qw(Bio::Root::RootI);\n\n  sub foo {\n      my $self = shift;\n      $self->throw_not_implemented;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is just a set of methods which do not assume B<anything> about the object\nthey are on. The methods provide the ability to throw exceptions with nice\nstack traces.\n\nThis is what should be inherited by all Bioperl compliant interfaces, even\nif they are exotic XS/CORBA/Other perl systems.\n\n=head2 Using throw_not_implemented()\n\nThe method L<throw_not_implemented()|throw_not_implemented> should be\ncalled by all methods within interface modules that extend RootI so\nthat if an implementation fails to override them, an exception will be\nthrown.\n\nFor example, say there is an interface module called C<FooI> that\nprovides a method called C<foo()>. Since this method is considered\nabstract within FooI and should be implemented by any module claiming to\nimplement C<FooI>, the C<FooI::foo()> method should consist of the\nfollowing:\n\n    sub foo {\n    \tmy $self = shift;\n    \t$self->throw_not_implemented;\n    }\n\nSo, if an implementer of C<FooI> forgets to implement C<foo()>\nand a user of the implementation calls C<foo()>, a\nL<Bio::Exception::NotImplemented> exception will result.\n\nUnfortunately, failure to implement a method can only be determined at\nrun time (i.e., you can't verify that an implementation is complete by\nrunning C<perl -wc> on it). So it should be standard practice for a test\nof an implementation to check each method and verify that it doesn't\nthrow a L<Bio::Exception::NotImplemented>.\n\n=head1 CONTACT\n\nFunctions originally from Steve Chervitz. Refactored by Ewan\nBirney. Re-refactored by Lincoln Stein. Added to by Sendu Bala.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Root::RootI;\n\nuse vars qw($DEBUG $ID $VERBOSITY);\nuse strict;\nuse Carp 'confess','carp';\n\nuse Bio::Root::Version;\n\nBEGIN { \n    $ID        = 'Bio::Root::RootI';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n}\n\nsub new {\n  my $class = shift;\n  my @args = @_;\n  unless ( $ENV{'BIOPERLDEBUG'} ) {\n      carp(\"Use of new in Bio::Root::RootI is deprecated.  Please use Bio::Root::Root instead\");\n  }\n  eval \"require Bio::Root::Root\";\n  return Bio::Root::Root->new(@args);\n}\n\n# for backwards compatibility\nsub _initialize {\n    my($self,@args) = @_;\n    return 1;\n}\n\n\n=head2 throw\n\n Title   : throw\n Usage   : $obj->throw(\"throwing exception message\")\n Function: Throws an exception, which, if not caught with an eval brace\n           will provide a nice stack trace to STDERR with the message\n Returns : nothing\n Args    : A string giving a descriptive error message\n\n\n\nsub throw{\n   my ($self,$string) = @_;\n\n   my $std = $self->stack_trace_dump();\n\n   my $out = \"\\n-------------------- EXCEPTION --------------------\\n\".\n       \"MSG: \".$string.\"\\n\".$std.\"-------------------------------------------\\n\";\n   die $out;\n\n}\n\n=head2 warn\n\n Title   : warn\n Usage   : $object->warn(\"Warning message\");\n Function: Places a warning. What happens now is down to the\n           verbosity of the object  (value of $obj->verbose) \n            verbosity 0 or not set => small warning\n            verbosity -1 => no warning\n            verbosity 1 => warning with stack trace\n            verbosity 2 => converts warnings into throw\n Returns : n/a\n Args    : string (the warning message)\n\n\nsub warn {\n    my ($self,$string) = @_;\n    \n    my $verbose = $self->verbose;\n    \n    my $header = \"\\n--------------------- WARNING ---------------------\\nMSG: \";\n    my $footer =   \"---------------------------------------------------\\n\";\n    \n    if ($verbose >= 2) {\n        $self->throw($string);\n    }\n    elsif ($verbose <= -1) {\n        return;\n    }\n    elsif ($verbose == 1) {\n        CORE::warn $header, $string, \"\\n\", $self->stack_trace_dump, $footer;\n        return;\n    }    \n    \n    CORE::warn $header, $string, \"\\n\", $footer;\n}\n\n=head2 deprecated\n\n Title   : deprecated\n Usage   : $obj->deprecated(\"Method X is deprecated\");\n           $obj->deprecated(\"Method X is deprecated\", 1.007);\n           $obj->deprecated(-message => \"Method X is deprecated\");\n           $obj->deprecated(-message => \"Method X is deprecated\",\n                            -version => 1.007);\n Function: Prints a message about deprecation unless verbose is < 0\n           (which means be quiet)\n Returns : none\n Args    : Message string to print to STDERR\n           Version of BioPerl where use of the method results in an exception\n Notes   : The method can be called two ways, either by positional arguments:\n           \n           $obj->deprecated('This module is deprecated', 1.006);\n           \n           or by named arguments:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -version => 1.006  # throw if $VERSION is >= this version\n                );\n\n           or timed to go off at a certain point:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -warn_version    => 1.006 # warn if $VERSION is >= this version\n                -throw_version   => 1.007 # throw if $VERSION is >= this version\n                );\n           \n           Using the last two named argument versions is suggested and will\n           likely be the only supported way of calling this method in the future\n           Yes, we see the irony of deprecating that particular usage of\n           deprecated().\n           \n           The main difference between usage of the two named argument versions\n           is that by designating a 'warn_version' one indicates the\n           functionality is officially deprecated beginning in a future version\n           of BioPerl (so warnings are issued only after that point), whereas\n           setting either 'version' or 'throw_version' (synonyms) converts the\n           deprecation warning to an exception.\n           \n           For proper comparisons one must use a version in lines with the\n           current versioning scheme for Perl and BioPerl, (i.e. where 1.006000\n           indicates v1.6.0, 5.010000 for v5.10.0, etc.).\n\n\nsub deprecated{\n    my ($self) = shift;\n    my ($msg, $version, $warn_version, $throw_version) =\n        $self->_rearrange([qw(MESSAGE VERSION WARN_VERSION THROW_VERSION)], @_);    \n    $version ||= $throw_version;\n    for my $v ($warn_version, $version) {\n        next unless defined $v;\n        $self->throw('Version must be numerical, such as 1.006000 for v1.6.0, not '.\n                     $v) unless $v =~ /^\\d+\\.\\d+$/;\n    }\n    return if ($warn_version && $Bio::Root::Version::VERSION < $warn_version);\n    # below default insinuates we're deprecating a method and not a full module\n    # but it's the most common use case\n    $msg ||= \"Use of \".(caller(1))[3].\"() is deprecated\";\n    # delegate to either warn or throw based on whether a version is given\n    if ($version) {\n        $msg .= \"\\nTo be removed in $version\";\n        if ($Bio::Root::Version::VERSION >= $version) {\n            $self->throw($msg)\n        } \n    }\n    # passing this on to warn() should deal properly with verbosity issues\n    $self->warn($msg);\n}\n\n=head2 stack_trace_dump\n\n Title   : stack_trace_dump\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub stack_trace_dump{\n   my ($self) = @_;\n\n   my @stack = $self->stack_trace();\n\n   shift @stack;\n   shift @stack;\n   shift @stack;\n\n   my $out;\n   my ($module,$function,$file,$position);\n   \n\n   foreach my $stack ( @stack) {\n       ($module,$file,$position,$function) = @{$stack};\n       $out .= \"STACK $function $file:$position\\n\";\n   }\n\n   return $out;\n}\n\n\n=head2 stack_trace\n\n Title   : stack_trace\n Usage   : @stack_array_ref= $self->stack_trace\n Function: gives an array to a reference of arrays with stack trace info\n           each coming from the caller(stack_number) call\n Returns : array containing a reference of arrays\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::"},{"containerName":"main::","name":"_rearrange","definition":"sub","range":{"start":{"character":0,"line":404},"end":{"line":417,"character":9999}},"kind":12,"line":404,"children":[{"line":405,"kind":13,"localvar":"my","name":"$dummy","definition":"my","containerName":"_rearrange"},{"kind":13,"line":406,"definition":"my","name":"$order","containerName":"_rearrange","localvar":"my"},{"kind":13,"line":409,"containerName":"_rearrange","name":"%2"},{"kind":13,"line":410,"containerName":"_rearrange","definition":"my","name":"%param","localvar":"my"},{"localvar":"my","definition":"my","name":"$key","containerName":"_rearrange","line":412,"kind":13},{"line":413,"kind":13,"name":"$param","containerName":"_rearrange"},{"kind":13,"line":413,"name":"$key","containerName":"_rearrange"},{"containerName":"_rearrange","name":"$order","kind":13,"line":415},{"containerName":"_rearrange","name":"@param","line":416,"kind":13},{"containerName":"_rearrange","name":"$order","line":416,"kind":13}]},{"name":"_set_from_args","range":{"start":{"character":0,"line":497},"end":{"line":521,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$args,@own_args)","signature":{"label":"_set_from_args($self,$args,@own_args)","parameters":[{"label":"$self"},{"label":"$args"},{"label":"@own_args"}],"documentation":"1;\n# $Id: RootI.pm 16090 2009-09-15 21:57:56Z cjfields $\n#\n# BioPerl module for Bio::Root::RootI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n# \n# This was refactored to have chained calls to new instead\n# of chained calls to _initialize\n#\n# added debug and deprecated methods --Jason Stajich 2001-10-12\n# \n\n=head1 NAME\n\nBio::Root::RootI - Abstract interface to root object code\n\n=head1 SYNOPSIS\n\n  # any bioperl or bioperl compliant object is a RootI \n  # compliant object\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Using throw_not_implemented() within a RootI-based interface module:\n\n  package Foo;\n  use base qw(Bio::Root::RootI);\n\n  sub foo {\n      my $self = shift;\n      $self->throw_not_implemented;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is just a set of methods which do not assume B<anything> about the object\nthey are on. The methods provide the ability to throw exceptions with nice\nstack traces.\n\nThis is what should be inherited by all Bioperl compliant interfaces, even\nif they are exotic XS/CORBA/Other perl systems.\n\n=head2 Using throw_not_implemented()\n\nThe method L<throw_not_implemented()|throw_not_implemented> should be\ncalled by all methods within interface modules that extend RootI so\nthat if an implementation fails to override them, an exception will be\nthrown.\n\nFor example, say there is an interface module called C<FooI> that\nprovides a method called C<foo()>. Since this method is considered\nabstract within FooI and should be implemented by any module claiming to\nimplement C<FooI>, the C<FooI::foo()> method should consist of the\nfollowing:\n\n    sub foo {\n    \tmy $self = shift;\n    \t$self->throw_not_implemented;\n    }\n\nSo, if an implementer of C<FooI> forgets to implement C<foo()>\nand a user of the implementation calls C<foo()>, a\nL<Bio::Exception::NotImplemented> exception will result.\n\nUnfortunately, failure to implement a method can only be determined at\nrun time (i.e., you can't verify that an implementation is complete by\nrunning C<perl -wc> on it). So it should be standard practice for a test\nof an implementation to check each method and verify that it doesn't\nthrow a L<Bio::Exception::NotImplemented>.\n\n=head1 CONTACT\n\nFunctions originally from Steve Chervitz. Refactored by Ewan\nBirney. Re-refactored by Lincoln Stein. Added to by Sendu Bala.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Root::RootI;\n\nuse vars qw($DEBUG $ID $VERBOSITY);\nuse strict;\nuse Carp 'confess','carp';\n\nuse Bio::Root::Version;\n\nBEGIN { \n    $ID        = 'Bio::Root::RootI';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n}\n\nsub new {\n  my $class = shift;\n  my @args = @_;\n  unless ( $ENV{'BIOPERLDEBUG'} ) {\n      carp(\"Use of new in Bio::Root::RootI is deprecated.  Please use Bio::Root::Root instead\");\n  }\n  eval \"require Bio::Root::Root\";\n  return Bio::Root::Root->new(@args);\n}\n\n# for backwards compatibility\nsub _initialize {\n    my($self,@args) = @_;\n    return 1;\n}\n\n\n=head2 throw\n\n Title   : throw\n Usage   : $obj->throw(\"throwing exception message\")\n Function: Throws an exception, which, if not caught with an eval brace\n           will provide a nice stack trace to STDERR with the message\n Returns : nothing\n Args    : A string giving a descriptive error message\n\n\n\nsub throw{\n   my ($self,$string) = @_;\n\n   my $std = $self->stack_trace_dump();\n\n   my $out = \"\\n-------------------- EXCEPTION --------------------\\n\".\n       \"MSG: \".$string.\"\\n\".$std.\"-------------------------------------------\\n\";\n   die $out;\n\n}\n\n=head2 warn\n\n Title   : warn\n Usage   : $object->warn(\"Warning message\");\n Function: Places a warning. What happens now is down to the\n           verbosity of the object  (value of $obj->verbose) \n            verbosity 0 or not set => small warning\n            verbosity -1 => no warning\n            verbosity 1 => warning with stack trace\n            verbosity 2 => converts warnings into throw\n Returns : n/a\n Args    : string (the warning message)\n\n\nsub warn {\n    my ($self,$string) = @_;\n    \n    my $verbose = $self->verbose;\n    \n    my $header = \"\\n--------------------- WARNING ---------------------\\nMSG: \";\n    my $footer =   \"---------------------------------------------------\\n\";\n    \n    if ($verbose >= 2) {\n        $self->throw($string);\n    }\n    elsif ($verbose <= -1) {\n        return;\n    }\n    elsif ($verbose == 1) {\n        CORE::warn $header, $string, \"\\n\", $self->stack_trace_dump, $footer;\n        return;\n    }    \n    \n    CORE::warn $header, $string, \"\\n\", $footer;\n}\n\n=head2 deprecated\n\n Title   : deprecated\n Usage   : $obj->deprecated(\"Method X is deprecated\");\n           $obj->deprecated(\"Method X is deprecated\", 1.007);\n           $obj->deprecated(-message => \"Method X is deprecated\");\n           $obj->deprecated(-message => \"Method X is deprecated\",\n                            -version => 1.007);\n Function: Prints a message about deprecation unless verbose is < 0\n           (which means be quiet)\n Returns : none\n Args    : Message string to print to STDERR\n           Version of BioPerl where use of the method results in an exception\n Notes   : The method can be called two ways, either by positional arguments:\n           \n           $obj->deprecated('This module is deprecated', 1.006);\n           \n           or by named arguments:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -version => 1.006  # throw if $VERSION is >= this version\n                );\n\n           or timed to go off at a certain point:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -warn_version    => 1.006 # warn if $VERSION is >= this version\n                -throw_version   => 1.007 # throw if $VERSION is >= this version\n                );\n           \n           Using the last two named argument versions is suggested and will\n           likely be the only supported way of calling this method in the future\n           Yes, we see the irony of deprecating that particular usage of\n           deprecated().\n           \n           The main difference between usage of the two named argument versions\n           is that by designating a 'warn_version' one indicates the\n           functionality is officially deprecated beginning in a future version\n           of BioPerl (so warnings are issued only after that point), whereas\n           setting either 'version' or 'throw_version' (synonyms) converts the\n           deprecation warning to an exception.\n           \n           For proper comparisons one must use a version in lines with the\n           current versioning scheme for Perl and BioPerl, (i.e. where 1.006000\n           indicates v1.6.0, 5.010000 for v5.10.0, etc.).\n\n\nsub deprecated{\n    my ($self) = shift;\n    my ($msg, $version, $warn_version, $throw_version) =\n        $self->_rearrange([qw(MESSAGE VERSION WARN_VERSION THROW_VERSION)], @_);    \n    $version ||= $throw_version;\n    for my $v ($warn_version, $version) {\n        next unless defined $v;\n        $self->throw('Version must be numerical, such as 1.006000 for v1.6.0, not '.\n                     $v) unless $v =~ /^\\d+\\.\\d+$/;\n    }\n    return if ($warn_version && $Bio::Root::Version::VERSION < $warn_version);\n    # below default insinuates we're deprecating a method and not a full module\n    # but it's the most common use case\n    $msg ||= \"Use of \".(caller(1))[3].\"() is deprecated\";\n    # delegate to either warn or throw based on whether a version is given\n    if ($version) {\n        $msg .= \"\\nTo be removed in $version\";\n        if ($Bio::Root::Version::VERSION >= $version) {\n            $self->throw($msg)\n        } \n    }\n    # passing this on to warn() should deal properly with verbosity issues\n    $self->warn($msg);\n}\n\n=head2 stack_trace_dump\n\n Title   : stack_trace_dump\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub stack_trace_dump{\n   my ($self) = @_;\n\n   my @stack = $self->stack_trace();\n\n   shift @stack;\n   shift @stack;\n   shift @stack;\n\n   my $out;\n   my ($module,$function,$file,$position);\n   \n\n   foreach my $stack ( @stack) {\n       ($module,$file,$position,$function) = @{$stack};\n       $out .= \"STACK $function $file:$position\\n\";\n   }\n\n   return $out;\n}\n\n\n=head2 stack_trace\n\n Title   : stack_trace\n Usage   : @stack_array_ref= $self->stack_trace\n Function: gives an array to a reference of arrays with stack trace info\n           each coming from the caller(stack_number) call\n Returns : array containing a reference of arrays\n Args    : none\n\n\n\nsub stack_trace{\n   my ($self) = @_;\n\n   my $i = 0;\n   my @out = ();\n   my $prev = [];\n   while( my @call = caller($i++)) {\n       # major annoyance that caller puts caller context as\n       # function name. Hence some monkeying around...\n       $prev->[3] = $call[3];\n       push(@out,$prev);\n       $prev = \\@call;\n   }\n   $prev->[3] = 'toplevel';\n   push(@out,$prev);\n   return @out;\n}\n\n\n=head2 _rearrange\n\n Usage     : $object->_rearrange( array_ref, list_of_arguments)\n Purpose   : Rearranges named parameters to requested order.\n Example   : $self->_rearrange([qw(SEQUENCE ID DESC)],@param);\n           : Where @param = (-sequence => $s,\n\t       :                 -desc     => $d,\n\t       :                 -id       => $i);\n Returns   : @params - an array of parameters in the requested order.\n           : The above example would return ($s, $i, $d).\n           : Unspecified parameters will return undef. For example, if\n           :        @param = (-sequence => $s);\n           : the above _rearrange call would return ($s, undef, undef)\n Argument  : $order : a reference to an array which describes the desired\n           :          order of the named parameters.\n           : @param : an array of parameters, either as a list (in\n           :          which case the function simply returns the list),\n           :          or as an associative array with hyphenated tags\n           :          (in which case the function sorts the values \n           :          according to @{$order} and returns that new array.)\n\t       :\t      The tags can be upper, lower, or mixed case\n           :          but they must start with a hyphen (at least the\n           :          first one should be hyphenated.)\n Source    : This function was taken from CGI.pm, written by Dr. Lincoln\n           : Stein, and adapted for use in Bio::Seq by Richard Resnick and\n           : then adapted for use in Bio::Root::Object.pm by Steve Chervitz,\n           : then migrated into Bio::Root::RootI.pm by Ewan Birney.\n Comments  :\n           : Uppercase tags are the norm, \n           : (SAC)\n           : This method may not be appropriate for method calls that are\n           : within in an inner loop if efficiency is a concern.\n           :\n           : Parameters can be specified using any of these formats:\n           :  @param = (-name=>'me', -color=>'blue');\n           :  @param = (-NAME=>'me', -COLOR=>'blue');\n           :  @param = (-Name=>'me', -Color=>'blue');\n           :  @param = ('me', 'blue');\n           : A leading hyphenated argument is used by this function to \n           : indicate that named parameters are being used.\n           : Therefore, the ('me', 'blue') list will be returned as-is.\n           :\n\t       : Note that Perl will confuse unquoted, hyphenated tags as \n           : function calls if there is a function of the same name \n           : in the current namespace:\n           :    -name => 'foo' is interpreted as -&name => 'foo'\n\t       :\n           : For ultimate safety, put single quotes around the tag:\n\t       : ('-name'=>'me', '-color' =>'blue');\n           : This can be a bit cumbersome and I find not as readable\n           : as using all uppercase, which is also fairly safe:\n\t       : (-NAME=>'me', -COLOR =>'blue');\n\t       :\n           : Personal note (SAC): I have found all uppercase tags to\n           : be more managable: it involves less single-quoting,\n           : the key names stand out better, and there are no method naming \n           : conflicts.\n           : The drawbacks are that it's not as easy to type as lowercase,\n           : and lots of uppercase can be hard to read.\n           :\n           : Regardless of the style, it greatly helps to line\n\t       : the parameters up vertically for long/complex lists.\n           :\n           : Note that if @param is a single string that happens to start with\n           : a dash, it will be treated as a hash key and probably fail to\n           : match anything in the array_ref, so not be returned as normally\n           : happens when @param is a simple list and not an associative array.\n\n\nsub _rearrange {\n    my $dummy = shift;\n    my $order = shift;\n    \n    return @_ unless (substr($_[0]||'',0,1) eq '-');\n    push @_,undef unless $#_ %2;\n    my %param;\n    while( @_ ) {\n\t(my $key = shift) =~ tr/a-z\\055/A-Z/d; #deletes all dashes!\n\t$param{$key} = shift;\n    }\n    map { $_ = uc($_) } @$order; # for bug #1343, but is there perf hit here?\n    return @param{@$order};\n}\n\n=head2 _set_from_args\n\n Usage     : $object->_set_from_args(\\%args, -methods => \\@methods)\n Purpose   : Takes a hash of user-supplied args whose keys match method names,\n           : and calls the method supplying it the corresponding value.\n Example   : $self->_set_from_args(\\%args, -methods => [qw(sequence id desc)]);\n           : Where %args = (-sequence    => $s,\n\t       :                -description => $d,\n\t       :                -ID          => $i);\n           :\n           : the above _set_from_args calls the following methods:\n           : $self->sequence($s);\n           : $self->id($i);\n           : ( $self->description($i) is not called because 'description' wasn't\n           :   one of the given methods )\n Argument  : \\%args | \\@args : a hash ref or associative array ref of arguments\n           :                   where keys are any-case strings corresponding to\n           :                   method names but optionally prefixed with\n           :                   hyphens, and values are the values the method\n           :                   should be supplied. If keys contain internal\n           :                   hyphens (eg. to separate multi-word args) they\n           :                   are converted to underscores, since method names\n           :                   cannot contain dashes.\n           : -methods => []  : (optional) only call methods with names in this\n           :                   array ref. Can instead supply a hash ref where\n           :                   keys are method names (of real existing methods\n           :                   unless -create is in effect) and values are array\n           :                   refs of synonyms to allow access to the method\n           :                   using synonyms. If there is only one synonym it\n           :                   can be supplied as a string instead of a single-\n           :                   element array ref\n           : -force => bool  : (optional, default 0) call methods that don't\n           :                   seem to exist, ie. let AUTOLOAD handle them\n           : -create => bool : (optional, default 0) when a method doesn't\n           :                   exist, create it as a simple getter/setter\n           :                   (combined with -methods it would create all the\n           :                   supplied methods that didn't exist, even if not\n           :                   mentioned in the supplied %args)\n           : -code => '' | {}: (optional) when creating methods use the supplied\n           :                   code (a string which will be evaulated as a sub).\n           :                   The default code is a simple get/setter.\n           :                   Alternatively you can supply a hash ref where\n           :                   the keys are method names and the values are\n           :                   code strings. The variable '$method' will be\n           :                   available at evaluation time, so can be used in\n           :                   your code strings. Beware that the strict pragma\n           :                   will be in effect.\n           : -case_sensitive => bool : require case sensitivity on the part of\n           :                           user (ie. a() and A() are two different\n           :                           methods and the user must be careful\n           :                           which they use).\n Comments  :\n           : The \\%args argument will usually be the args received during new()\n           : from the user. The user is allowed to get the case wrong, include\n           : 0 or more than one hyphens as a prefix, and to include hyphens as\n           : multi-word arg separators: '--an-arg' => 1, -an_arg => 1 and\n           : An_Arg => 1 are all equivalent, calling an_arg(1). However, in\n           : documentation users should only be told to use the standard form\n           : -an_arg to avoid confusion. A possible exception to this is a\n           : wrapper module where '--an-arg' is what the user is used to\n           : supplying to the program being wrapped.\n           :\n           : Another issue with wrapper modules is that there may be an\n           : argument that has meaning both to Bioperl and to the program, eg.\n           : -verbose. The recommended way of dealing with this is to leave\n           : -verbose to set the Bioperl verbosity whilst requesting users use\n           : an invented -program_verbose (or similar) to set the program\n           : verbosity. This can be resolved back with\n           : Bio::Tools::Run::WrapperBase's _setparams() method and code along\n           : the lines of:\n           : my %methods = map { $_ => $_ } @LIST_OF_ALL_ALLOWED_PROGRAM_ARGS\n           : delete $methods{'verbose'};\n           : $methods{'program_verbose'} = 'verbose';\n           : my $param_string = $self->_setparams(-methods => \\%methods);\n           : system(\"$exe $param_string\");"},"kind":12,"line":497,"children":[{"definition":"my","name":"$self","containerName":"_set_from_args","localvar":"my","kind":13,"line":498},{"containerName":"_set_from_args","name":"$args","kind":13,"line":498},{"line":498,"kind":13,"name":"@own_args","containerName":"_set_from_args"},{"line":499,"kind":13,"name":"$self","containerName":"_set_from_args"},{"line":499,"kind":12,"name":"throw","containerName":"_set_from_args"},{"containerName":"_set_from_args","name":"$args","kind":13,"line":499},{"containerName":"_set_from_args","definition":"my","name":"$methods","localvar":"my","kind":13,"line":501},{"containerName":"_set_from_args","name":"$force","line":501,"kind":13},{"containerName":"_set_from_args","name":"$create","kind":13,"line":501},{"line":501,"kind":13,"name":"$code","containerName":"_set_from_args"},{"line":501,"kind":13,"containerName":"_set_from_args","name":"$case"},{"name":"@own_args","containerName":"_set_from_args","line":502,"kind":13},{"kind":13,"line":503,"name":"$methods","containerName":"_set_from_args"},{"name":"$force","containerName":"_set_from_args","line":503,"kind":13},{"containerName":"_set_from_args","name":"$create","line":503,"kind":13},{"line":503,"kind":13,"containerName":"_set_from_args","name":"$code"},{"containerName":"_set_from_args","name":"$case","kind":13,"line":503},{"line":504,"kind":13,"name":"$self","containerName":"_set_from_args"},{"containerName":"_set_from_args","name":"_rearrange","line":504,"kind":12},{"name":"@own_args","containerName":"_set_from_args","line":508,"kind":13},{"containerName":"_set_from_args","name":"$default_code","definition":"my","localvar":"my","kind":13,"line":510},{"definition":"my","name":"%method_names","containerName":"_set_from_args","localvar":"my","kind":13,"line":514},{"name":"%syns","definition":"my","containerName":"_set_from_args","localvar":"my","kind":13,"line":515},{"line":516,"kind":13,"containerName":"_set_from_args","name":"$methods"},{"line":517,"kind":13,"localvar":"my","name":"@names","definition":"my","containerName":"_set_from_args"},{"line":518,"kind":13,"containerName":"_set_from_args","name":"$methods"},{"name":"@names","containerName":"_set_from_args","line":519,"kind":13},{"name":"$methods","containerName":"_set_from_args","line":519,"kind":13},{"line":520,"kind":13,"name":"%syns","containerName":"_set_from_args"},{"name":"$methods","containerName":"_set_from_args","kind":13,"line":520}]},{"line":523,"kind":13,"containerName":null,"name":"@names"},{"containerName":null,"name":"$methods","kind":13,"line":523},{"line":524,"kind":13,"name":"%syns","containerName":null},{"name":"@names","containerName":null,"line":524,"kind":13},{"line":526,"kind":13,"containerName":null,"name":"%method_names"},{"name":"$case","containerName":null,"line":526,"kind":13},{"kind":13,"line":526,"name":"@names","containerName":null},{"containerName":null,"name":"%orig_args","definition":"my","localvar":"my","kind":13,"line":530},{"kind":13,"line":530,"containerName":null,"name":"$args"},{"containerName":null,"name":"$args","line":530,"kind":13},{"kind":13,"line":530,"name":"$args","containerName":null},{"kind":13,"line":531,"definition":"my","name":"%args","containerName":null,"localvar":"my"},{"localvar":"my","name":"$method","definition":"my","containerName":null,"line":532,"kind":13},{"line":532,"kind":13,"name":"$value","containerName":null},{"kind":13,"line":532,"containerName":null,"name":"%orig_args"},{"kind":13,"line":533,"name":"$method","containerName":null},{"name":"$method","containerName":null,"line":534,"kind":13},{"name":"%args","containerName":null,"line":535,"kind":13},{"line":535,"kind":13,"name":"$method","containerName":null},{"name":"$value","containerName":null,"kind":13,"line":535},{"line":539,"kind":13,"name":"%create","containerName":null},{"name":"%methods","containerName":null,"line":540,"kind":13},{"line":541,"kind":13,"containerName":null,"name":"%syns"},{"kind":13,"line":541,"containerName":null,"name":"$case"},{"containerName":null,"name":"%args","kind":13,"line":541},{"localvar":"my","name":"$method","definition":"my","containerName":null,"line":544,"kind":13},{"name":"%syns","containerName":null,"line":544,"kind":13},{"line":545,"kind":13,"containerName":null,"name":"$self"},{"line":545,"kind":12,"containerName":"main::","name":"can"},{"line":545,"kind":13,"containerName":null,"name":"$method"},{"kind":13,"line":547,"containerName":null,"name":"$string","definition":"my","localvar":"my"},{"containerName":null,"name":"$code","kind":13,"line":547},{"containerName":null,"name":"$default_code","kind":13,"line":547},{"name":"$code","containerName":null,"kind":13,"line":548},{"containerName":null,"name":"%code","line":548,"kind":13},{"line":549,"kind":13,"name":"$string","containerName":null},{"name":"%code","containerName":null,"kind":13,"line":549},{"containerName":null,"name":"$method","line":549,"kind":13},{"containerName":null,"name":"$default_code","kind":13,"line":549},{"localvar":"my","definition":"my","name":"$sub","containerName":null,"line":552,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":553},{"name":"throw","containerName":"main::","kind":12,"line":553},{"line":555,"kind":12,"name":"strict"},{"line":556,"kind":13,"name":"$self","containerName":null},{"kind":13,"line":556,"containerName":null,"name":"$method"},{"kind":13,"line":556,"name":"$sub","containerName":null},{"localvar":"my","containerName":null,"name":"$method","definition":"my","line":561,"kind":13},{"line":561,"kind":13,"containerName":null,"name":"$syn_ref"},{"kind":13,"line":561,"name":"%syns","containerName":null},{"kind":13,"line":562,"definition":"my","name":"$method_ref","containerName":null,"localvar":"my"},{"line":562,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"can","line":562,"kind":12},{"kind":13,"line":562,"containerName":null,"name":"$method"},{"definition":"my","name":"$syn","containerName":null,"localvar":"my","kind":13,"line":564},{"name":"ref","kind":12,"line":564},{"kind":13,"line":564,"name":"$syn_ref","containerName":null},{"containerName":null,"name":"@syn_ref","line":564,"kind":13},{"containerName":null,"name":"%syn_ref","kind":13,"line":564},{"containerName":null,"name":"$syn","line":565,"kind":13},{"line":565,"kind":13,"containerName":null,"name":"$method"},{"line":566,"kind":13,"containerName":null,"name":"%method_names"},{"name":"$case","containerName":null,"kind":13,"line":566},{"line":566,"kind":13,"name":"$syn","containerName":null},{"name":"$syn","containerName":null,"kind":13,"line":566},{"line":566,"kind":13,"containerName":null,"name":"$syn"},{"kind":13,"line":567,"name":"$self","containerName":null},{"name":"can","containerName":"main::","kind":12,"line":567},{"name":"$syn","containerName":null,"kind":13,"line":567},{"line":568,"kind":12,"name":"strict"},{"line":569,"kind":13,"containerName":null,"name":"$self"},{"line":569,"kind":13,"name":"$syn","containerName":null},{"name":"$method_ref","containerName":null,"kind":13,"line":569},{"kind":13,"line":574,"name":"$method","definition":"my","containerName":null,"localvar":"my"},{"name":"$value","containerName":null,"line":574,"kind":13},{"line":574,"kind":13,"name":"%args","containerName":null},{"containerName":null,"name":"$method","line":575,"kind":13},{"line":575,"kind":13,"name":"%method_names","containerName":null},{"name":"$case","containerName":null,"line":575,"kind":13},{"containerName":null,"name":"$method","line":575,"kind":13},{"kind":13,"line":575,"containerName":null,"name":"$method"},{"name":"$methods","containerName":null,"line":575,"kind":13},{"name":"$method","containerName":null,"line":575,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":576},{"containerName":"main::","name":"can","line":576,"kind":12},{"name":"$method","containerName":null,"kind":13,"line":576},{"line":576,"kind":13,"containerName":null,"name":"$force"},{"containerName":null,"name":"$self","kind":13,"line":577},{"line":577,"kind":13,"name":"$method","containerName":null},{"line":577,"kind":13,"containerName":null,"name":"$value"},{"range":{"start":{"line":582,"character":0},"end":{"character":9999,"line":635}},"name":"_rearrange_old","detail":"($self,$order,@param)","signature":{"parameters":[{"label":"$self"},{"label":"$order"},{"label":"@param"}],"documentation":"----------------'","label":"_rearrange_old($self,$order,@param)"},"containerName":"main::","definition":"sub","line":582,"children":[{"localvar":"my","containerName":"_rearrange_old","definition":"my","name":"$self","line":584,"kind":13},{"name":"$order","containerName":"_rearrange_old","kind":13,"line":584},{"kind":13,"line":584,"containerName":"_rearrange_old","name":"@param"},{"line":604,"kind":13,"containerName":"_rearrange_old","name":"@param"},{"containerName":"_rearrange_old","name":"$param","kind":13,"line":604},{"line":604,"kind":13,"name":"$param","containerName":"_rearrange_old"},{"kind":13,"line":613,"definition":"my","name":"$i","containerName":"_rearrange_old","localvar":"my"},{"line":613,"kind":13,"name":"$i","containerName":"_rearrange_old"},{"line":613,"kind":13,"name":"@param","containerName":"_rearrange_old"},{"line":613,"kind":13,"containerName":"_rearrange_old","name":"$i"},{"line":614,"kind":13,"name":"$param","containerName":"_rearrange_old"},{"name":"$i","containerName":"_rearrange_old","kind":13,"line":614},{"name":"$param","containerName":"_rearrange_old","line":615,"kind":13},{"name":"$i","containerName":"_rearrange_old","line":615,"kind":13},{"line":620,"kind":13,"localvar":"my","name":"%param","definition":"my","containerName":"_rearrange_old"},{"containerName":"_rearrange_old","name":"@param","kind":13,"line":620},{"name":"@param","containerName":"_rearrange_old","line":635,"kind":13},{"line":635,"kind":13,"containerName":"_rearrange_old","name":"$order"}],"kind":12},{"name":"param","kind":12,"line":604},{"name":"_register_for_cleanup","range":{"end":{"line":662,"character":9999},"start":{"character":0,"line":659}},"containerName":"main::","definition":"sub","detail":"($self,$method)","signature":{"parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# $Id: RootI.pm 16090 2009-09-15 21:57:56Z cjfields $\n#\n# BioPerl module for Bio::Root::RootI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n# \n# This was refactored to have chained calls to new instead\n# of chained calls to _initialize\n#\n# added debug and deprecated methods --Jason Stajich 2001-10-12\n# \n\n=head1 NAME\n\nBio::Root::RootI - Abstract interface to root object code\n\n=head1 SYNOPSIS\n\n  # any bioperl or bioperl compliant object is a RootI \n  # compliant object\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Using throw_not_implemented() within a RootI-based interface module:\n\n  package Foo;\n  use base qw(Bio::Root::RootI);\n\n  sub foo {\n      my $self = shift;\n      $self->throw_not_implemented;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is just a set of methods which do not assume B<anything> about the object\nthey are on. The methods provide the ability to throw exceptions with nice\nstack traces.\n\nThis is what should be inherited by all Bioperl compliant interfaces, even\nif they are exotic XS/CORBA/Other perl systems.\n\n=head2 Using throw_not_implemented()\n\nThe method L<throw_not_implemented()|throw_not_implemented> should be\ncalled by all methods within interface modules that extend RootI so\nthat if an implementation fails to override them, an exception will be\nthrown.\n\nFor example, say there is an interface module called C<FooI> that\nprovides a method called C<foo()>. Since this method is considered\nabstract within FooI and should be implemented by any module claiming to\nimplement C<FooI>, the C<FooI::foo()> method should consist of the\nfollowing:\n\n    sub foo {\n    \tmy $self = shift;\n    \t$self->throw_not_implemented;\n    }\n\nSo, if an implementer of C<FooI> forgets to implement C<foo()>\nand a user of the implementation calls C<foo()>, a\nL<Bio::Exception::NotImplemented> exception will result.\n\nUnfortunately, failure to implement a method can only be determined at\nrun time (i.e., you can't verify that an implementation is complete by\nrunning C<perl -wc> on it). So it should be standard practice for a test\nof an implementation to check each method and verify that it doesn't\nthrow a L<Bio::Exception::NotImplemented>.\n\n=head1 CONTACT\n\nFunctions originally from Steve Chervitz. Refactored by Ewan\nBirney. Re-refactored by Lincoln Stein. Added to by Sendu Bala.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Root::RootI;\n\nuse vars qw($DEBUG $ID $VERBOSITY);\nuse strict;\nuse Carp 'confess','carp';\n\nuse Bio::Root::Version;\n\nBEGIN { \n    $ID        = 'Bio::Root::RootI';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n}\n\nsub new {\n  my $class = shift;\n  my @args = @_;\n  unless ( $ENV{'BIOPERLDEBUG'} ) {\n      carp(\"Use of new in Bio::Root::RootI is deprecated.  Please use Bio::Root::Root instead\");\n  }\n  eval \"require Bio::Root::Root\";\n  return Bio::Root::Root->new(@args);\n}\n\n# for backwards compatibility\nsub _initialize {\n    my($self,@args) = @_;\n    return 1;\n}\n\n\n=head2 throw\n\n Title   : throw\n Usage   : $obj->throw(\"throwing exception message\")\n Function: Throws an exception, which, if not caught with an eval brace\n           will provide a nice stack trace to STDERR with the message\n Returns : nothing\n Args    : A string giving a descriptive error message\n\n\n\nsub throw{\n   my ($self,$string) = @_;\n\n   my $std = $self->stack_trace_dump();\n\n   my $out = \"\\n-------------------- EXCEPTION --------------------\\n\".\n       \"MSG: \".$string.\"\\n\".$std.\"-------------------------------------------\\n\";\n   die $out;\n\n}\n\n=head2 warn\n\n Title   : warn\n Usage   : $object->warn(\"Warning message\");\n Function: Places a warning. What happens now is down to the\n           verbosity of the object  (value of $obj->verbose) \n            verbosity 0 or not set => small warning\n            verbosity -1 => no warning\n            verbosity 1 => warning with stack trace\n            verbosity 2 => converts warnings into throw\n Returns : n/a\n Args    : string (the warning message)\n\n\nsub warn {\n    my ($self,$string) = @_;\n    \n    my $verbose = $self->verbose;\n    \n    my $header = \"\\n--------------------- WARNING ---------------------\\nMSG: \";\n    my $footer =   \"---------------------------------------------------\\n\";\n    \n    if ($verbose >= 2) {\n        $self->throw($string);\n    }\n    elsif ($verbose <= -1) {\n        return;\n    }\n    elsif ($verbose == 1) {\n        CORE::warn $header, $string, \"\\n\", $self->stack_trace_dump, $footer;\n        return;\n    }    \n    \n    CORE::warn $header, $string, \"\\n\", $footer;\n}\n\n=head2 deprecated\n\n Title   : deprecated\n Usage   : $obj->deprecated(\"Method X is deprecated\");\n           $obj->deprecated(\"Method X is deprecated\", 1.007);\n           $obj->deprecated(-message => \"Method X is deprecated\");\n           $obj->deprecated(-message => \"Method X is deprecated\",\n                            -version => 1.007);\n Function: Prints a message about deprecation unless verbose is < 0\n           (which means be quiet)\n Returns : none\n Args    : Message string to print to STDERR\n           Version of BioPerl where use of the method results in an exception\n Notes   : The method can be called two ways, either by positional arguments:\n           \n           $obj->deprecated('This module is deprecated', 1.006);\n           \n           or by named arguments:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -version => 1.006  # throw if $VERSION is >= this version\n                );\n\n           or timed to go off at a certain point:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -warn_version    => 1.006 # warn if $VERSION is >= this version\n                -throw_version   => 1.007 # throw if $VERSION is >= this version\n                );\n           \n           Using the last two named argument versions is suggested and will\n           likely be the only supported way of calling this method in the future\n           Yes, we see the irony of deprecating that particular usage of\n           deprecated().\n           \n           The main difference between usage of the two named argument versions\n           is that by designating a 'warn_version' one indicates the\n           functionality is officially deprecated beginning in a future version\n           of BioPerl (so warnings are issued only after that point), whereas\n           setting either 'version' or 'throw_version' (synonyms) converts the\n           deprecation warning to an exception.\n           \n           For proper comparisons one must use a version in lines with the\n           current versioning scheme for Perl and BioPerl, (i.e. where 1.006000\n           indicates v1.6.0, 5.010000 for v5.10.0, etc.).\n\n\nsub deprecated{\n    my ($self) = shift;\n    my ($msg, $version, $warn_version, $throw_version) =\n        $self->_rearrange([qw(MESSAGE VERSION WARN_VERSION THROW_VERSION)], @_);    \n    $version ||= $throw_version;\n    for my $v ($warn_version, $version) {\n        next unless defined $v;\n        $self->throw('Version must be numerical, such as 1.006000 for v1.6.0, not '.\n                     $v) unless $v =~ /^\\d+\\.\\d+$/;\n    }\n    return if ($warn_version && $Bio::Root::Version::VERSION < $warn_version);\n    # below default insinuates we're deprecating a method and not a full module\n    # but it's the most common use case\n    $msg ||= \"Use of \".(caller(1))[3].\"() is deprecated\";\n    # delegate to either warn or throw based on whether a version is given\n    if ($version) {\n        $msg .= \"\\nTo be removed in $version\";\n        if ($Bio::Root::Version::VERSION >= $version) {\n            $self->throw($msg)\n        } \n    }\n    # passing this on to warn() should deal properly with verbosity issues\n    $self->warn($msg);\n}\n\n=head2 stack_trace_dump\n\n Title   : stack_trace_dump\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub stack_trace_dump{\n   my ($self) = @_;\n\n   my @stack = $self->stack_trace();\n\n   shift @stack;\n   shift @stack;\n   shift @stack;\n\n   my $out;\n   my ($module,$function,$file,$position);\n   \n\n   foreach my $stack ( @stack) {\n       ($module,$file,$position,$function) = @{$stack};\n       $out .= \"STACK $function $file:$position\\n\";\n   }\n\n   return $out;\n}\n\n\n=head2 stack_trace\n\n Title   : stack_trace\n Usage   : @stack_array_ref= $self->stack_trace\n Function: gives an array to a reference of arrays with stack trace info\n           each coming from the caller(stack_number) call\n Returns : array containing a reference of arrays\n Args    : none\n\n\n\nsub stack_trace{\n   my ($self) = @_;\n\n   my $i = 0;\n   my @out = ();\n   my $prev = [];\n   while( my @call = caller($i++)) {\n       # major annoyance that caller puts caller context as\n       # function name. Hence some monkeying around...\n       $prev->[3] = $call[3];\n       push(@out,$prev);\n       $prev = \\@call;\n   }\n   $prev->[3] = 'toplevel';\n   push(@out,$prev);\n   return @out;\n}\n\n\n=head2 _rearrange\n\n Usage     : $object->_rearrange( array_ref, list_of_arguments)\n Purpose   : Rearranges named parameters to requested order.\n Example   : $self->_rearrange([qw(SEQUENCE ID DESC)],@param);\n           : Where @param = (-sequence => $s,\n\t       :                 -desc     => $d,\n\t       :                 -id       => $i);\n Returns   : @params - an array of parameters in the requested order.\n           : The above example would return ($s, $i, $d).\n           : Unspecified parameters will return undef. For example, if\n           :        @param = (-sequence => $s);\n           : the above _rearrange call would return ($s, undef, undef)\n Argument  : $order : a reference to an array which describes the desired\n           :          order of the named parameters.\n           : @param : an array of parameters, either as a list (in\n           :          which case the function simply returns the list),\n           :          or as an associative array with hyphenated tags\n           :          (in which case the function sorts the values \n           :          according to @{$order} and returns that new array.)\n\t       :\t      The tags can be upper, lower, or mixed case\n           :          but they must start with a hyphen (at least the\n           :          first one should be hyphenated.)\n Source    : This function was taken from CGI.pm, written by Dr. Lincoln\n           : Stein, and adapted for use in Bio::Seq by Richard Resnick and\n           : then adapted for use in Bio::Root::Object.pm by Steve Chervitz,\n           : then migrated into Bio::Root::RootI.pm by Ewan Birney.\n Comments  :\n           : Uppercase tags are the norm, \n           : (SAC)\n           : This method may not be appropriate for method calls that are\n           : within in an inner loop if efficiency is a concern.\n           :\n           : Parameters can be specified using any of these formats:\n           :  @param = (-name=>'me', -color=>'blue');\n           :  @param = (-NAME=>'me', -COLOR=>'blue');\n           :  @param = (-Name=>'me', -Color=>'blue');\n           :  @param = ('me', 'blue');\n           : A leading hyphenated argument is used by this function to \n           : indicate that named parameters are being used.\n           : Therefore, the ('me', 'blue') list will be returned as-is.\n           :\n\t       : Note that Perl will confuse unquoted, hyphenated tags as \n           : function calls if there is a function of the same name \n           : in the current namespace:\n           :    -name => 'foo' is interpreted as -&name => 'foo'\n\t       :\n           : For ultimate safety, put single quotes around the tag:\n\t       : ('-name'=>'me', '-color' =>'blue');\n           : This can be a bit cumbersome and I find not as readable\n           : as using all uppercase, which is also fairly safe:\n\t       : (-NAME=>'me', -COLOR =>'blue');\n\t       :\n           : Personal note (SAC): I have found all uppercase tags to\n           : be more managable: it involves less single-quoting,\n           : the key names stand out better, and there are no method naming \n           : conflicts.\n           : The drawbacks are that it's not as easy to type as lowercase,\n           : and lots of uppercase can be hard to read.\n           :\n           : Regardless of the style, it greatly helps to line\n\t       : the parameters up vertically for long/complex lists.\n           :\n           : Note that if @param is a single string that happens to start with\n           : a dash, it will be treated as a hash key and probably fail to\n           : match anything in the array_ref, so not be returned as normally\n           : happens when @param is a simple list and not an associative array.\n\n\nsub _rearrange {\n    my $dummy = shift;\n    my $order = shift;\n    \n    return @_ unless (substr($_[0]||'',0,1) eq '-');\n    push @_,undef unless $#_ %2;\n    my %param;\n    while( @_ ) {\n\t(my $key = shift) =~ tr/a-z\\055/A-Z/d; #deletes all dashes!\n\t$param{$key} = shift;\n    }\n    map { $_ = uc($_) } @$order; # for bug #1343, but is there perf hit here?\n    return @param{@$order};\n}\n\n=head2 _set_from_args\n\n Usage     : $object->_set_from_args(\\%args, -methods => \\@methods)\n Purpose   : Takes a hash of user-supplied args whose keys match method names,\n           : and calls the method supplying it the corresponding value.\n Example   : $self->_set_from_args(\\%args, -methods => [qw(sequence id desc)]);\n           : Where %args = (-sequence    => $s,\n\t       :                -description => $d,\n\t       :                -ID          => $i);\n           :\n           : the above _set_from_args calls the following methods:\n           : $self->sequence($s);\n           : $self->id($i);\n           : ( $self->description($i) is not called because 'description' wasn't\n           :   one of the given methods )\n Argument  : \\%args | \\@args : a hash ref or associative array ref of arguments\n           :                   where keys are any-case strings corresponding to\n           :                   method names but optionally prefixed with\n           :                   hyphens, and values are the values the method\n           :                   should be supplied. If keys contain internal\n           :                   hyphens (eg. to separate multi-word args) they\n           :                   are converted to underscores, since method names\n           :                   cannot contain dashes.\n           : -methods => []  : (optional) only call methods with names in this\n           :                   array ref. Can instead supply a hash ref where\n           :                   keys are method names (of real existing methods\n           :                   unless -create is in effect) and values are array\n           :                   refs of synonyms to allow access to the method\n           :                   using synonyms. If there is only one synonym it\n           :                   can be supplied as a string instead of a single-\n           :                   element array ref\n           : -force => bool  : (optional, default 0) call methods that don't\n           :                   seem to exist, ie. let AUTOLOAD handle them\n           : -create => bool : (optional, default 0) when a method doesn't\n           :                   exist, create it as a simple getter/setter\n           :                   (combined with -methods it would create all the\n           :                   supplied methods that didn't exist, even if not\n           :                   mentioned in the supplied %args)\n           : -code => '' | {}: (optional) when creating methods use the supplied\n           :                   code (a string which will be evaulated as a sub).\n           :                   The default code is a simple get/setter.\n           :                   Alternatively you can supply a hash ref where\n           :                   the keys are method names and the values are\n           :                   code strings. The variable '$method' will be\n           :                   available at evaluation time, so can be used in\n           :                   your code strings. Beware that the strict pragma\n           :                   will be in effect.\n           : -case_sensitive => bool : require case sensitivity on the part of\n           :                           user (ie. a() and A() are two different\n           :                           methods and the user must be careful\n           :                           which they use).\n Comments  :\n           : The \\%args argument will usually be the args received during new()\n           : from the user. The user is allowed to get the case wrong, include\n           : 0 or more than one hyphens as a prefix, and to include hyphens as\n           : multi-word arg separators: '--an-arg' => 1, -an_arg => 1 and\n           : An_Arg => 1 are all equivalent, calling an_arg(1). However, in\n           : documentation users should only be told to use the standard form\n           : -an_arg to avoid confusion. A possible exception to this is a\n           : wrapper module where '--an-arg' is what the user is used to\n           : supplying to the program being wrapped.\n           :\n           : Another issue with wrapper modules is that there may be an\n           : argument that has meaning both to Bioperl and to the program, eg.\n           : -verbose. The recommended way of dealing with this is to leave\n           : -verbose to set the Bioperl verbosity whilst requesting users use\n           : an invented -program_verbose (or similar) to set the program\n           : verbosity. This can be resolved back with\n           : Bio::Tools::Run::WrapperBase's _setparams() method and code along\n           : the lines of:\n           : my %methods = map { $_ => $_ } @LIST_OF_ALL_ALLOWED_PROGRAM_ARGS\n           : delete $methods{'verbose'};\n           : $methods{'program_verbose'} = 'verbose';\n           : my $param_string = $self->_setparams(-methods => \\%methods);\n           : system(\"$exe $param_string\");\n\n\nsub _set_from_args {\n    my ($self, $args, @own_args) = @_;\n    $self->throw(\"a hash/array ref of arguments must be supplied\") unless ref($args);\n    \n    my ($methods, $force, $create, $code, $case);\n    if (@own_args) {\n        ($methods, $force, $create, $code, $case) =\n            $self->_rearrange([qw(METHODS\n                                  FORCE\n                                  CREATE\n                                  CODE\n                                  CASE_SENSITIVE)], @own_args);\n    }\n    my $default_code = 'my $self = shift;\n                        if (@_) { $self->{\\'_\\'.$method} = shift }\n                        return $self->{\\'_\\'.$method};';\n    \n    my %method_names = ();\n    my %syns = ();\n    if ($methods) {\n        my @names;\n        if (ref($methods) eq 'HASH') {\n            @names = keys %{$methods};\n            %syns = %{$methods};\n        }\n        else {\n            @names = @{$methods};\n            %syns = map { $_ => $_ } @names;\n        }\n        %method_names = map { $case ? $_ : lc($_) => $_ } @names;\n    }\n    \n    # deal with hyphens\n    my %orig_args = ref($args) eq 'HASH' ? %{$args} : @{$args};\n    my %args;\n    while (my ($method, $value) = each %orig_args) {\n        $method =~ s/^-+//;\n        $method =~ s/-/_/g;\n        $args{$method} = $value;\n    }\n    \n    # create non-existing methods on request\n    if ($create) {\n        unless ($methods) {\n            %syns = map { $_ => $case ? $_ : lc($_) } keys %args;\n        }\n        \n        foreach my $method (keys %syns) {\n            $self->can($method) && next;\n            \n            my $string = $code || $default_code;\n            if (ref($code) && ref($code) eq 'HASH') {\n                $string = $code->{$method} || $default_code;\n            }\n            \n            my $sub = eval \"sub { $string }\";\n            $self->throw(\"Compilation error for $method : $@\") if $@;\n            \n            no strict 'refs';\n            *{ref($self).'::'.$method} = $sub;\n        }\n    }\n    \n    # create synonyms of existing methods\n    while (my ($method, $syn_ref) = each %syns) {\n        my $method_ref = $self->can($method) || next;\n        \n        foreach my $syn (@{ ref($syn_ref) ? $syn_ref : [$syn_ref] }) {\n            next if $syn eq $method;\n            $method_names{$case ? $syn : lc($syn)} = $syn;\n            next if $self->can($syn);\n            no strict 'refs';\n            *{ref($self).'::'.$syn} = $method_ref;\n        }\n    }\n    \n    # set values for methods\n    while (my ($method, $value) = each %args) {\n        $method = $method_names{$case ? $method : lc($method)} || ($methods ? next : $method);\n        $self->can($method) || next unless $force;\n        $self->$method($value);\n    }\n}\n\n#----------------'\nsub _rearrange_old {\n#----------------\n    my($self,$order,@param) = @_;\n    \n    # JGRG -- This is wrong, because we don't want\n    # to assign empty string to anything, and this\n    # code is actually returning an array 1 less\n    # than the length of @param:\n\n    ## If there are no parameters, we simply wish to return\n    ## an empty array which is the size of the @{$order} array.\n    #return ('') x $#{$order} unless @param;\n    \n    # ...all we need to do is return an empty array:\n    # return unless @param;\n    \n    # If we've got parameters, we need to check to see whether\n    # they are named or simply listed. If they are listed, we\n    # can just return them. \n\n    # The mod test fixes bug where a single string parameter beginning with '-' gets lost.\n    # This tends to happen in error messages such as: $obj->throw(\"-id not defined\")\n    return @param unless (defined($param[0]) && $param[0]=~/^-/o && ($#param % 2));\n\n    # Tester\n#    print \"\\n_rearrange() named parameters:\\n\";\n#    my $i; for ($i=0;$i<@param;$i+=2) { printf \"%20s => %s\\n\", $param[$i],$param[$i+1]; }; <STDIN>;\n\n    # Now we've got to do some work on the named parameters.\n    # The next few lines strip out the '-' characters which\n    # preceed the keys, and capitalizes them.\n    for (my $i=0;$i<@param;$i+=2) {\n\t$param[$i]=~s/^\\-//;\n\t$param[$i]=~tr/a-z/A-Z/;\n    }\n    \n    # Now we'll convert the @params variable into an associative array.\n    # local($^W) = 0;  # prevent \"odd number of elements\" warning with -w.\n    my(%param) = @param;\n    \n    # my(@return_array);\n    \n    # What we intend to do is loop through the @{$order} variable,\n    # and for each value, we use that as a key into our associative\n    # array, pushing the value at that key onto our return array.\n    # my($key);\n    \n    #foreach (@{$order}) {\n\t# my($value) = $param{$key};\n\t# delete $param{$key};\n\t#push(@return_array,$param{$_});\n    #}\n\n    return @param{@{$order}};\n    \n#    print \"\\n_rearrange() after processing:\\n\";\n#    my $i; for ($i=0;$i<@return_array;$i++) { printf \"%20s => %s\\n\", ${$order}[$i], $return_array[$i]; } <STDIN>;\n\n    # return @return_array;\n}\n\n=head2 _register_for_cleanup\n\n Title   : _register_for_cleanup\n Usage   : -- internal --\n Function: Register a method to be called at DESTROY time. This is useful\n           and sometimes essential in the case of multiple inheritance for\n           classes coming second in the sequence of inheritance.\n Returns : \n Args    : a code reference\n\nThe code reference will be invoked with the object as the first\nargument, as per a method.  You may register an unlimited number of\ncleanup methods.","label":"_register_for_cleanup($self,$method)"},"kind":12,"line":659,"children":[{"kind":13,"line":660,"name":"$self","definition":"my","containerName":"_register_for_cleanup","localvar":"my"},{"kind":13,"line":660,"containerName":"_register_for_cleanup","name":"$method"},{"containerName":"_register_for_cleanup","name":"$self","line":661,"kind":13},{"kind":12,"line":661,"name":"throw_not_implemented","containerName":"_register_for_cleanup"}]},{"definition":"sub","containerName":"main::","signature":{"label":"_unregister_for_cleanup($self,$method)","parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# $Id: RootI.pm 16090 2009-09-15 21:57:56Z cjfields $\n#\n# BioPerl module for Bio::Root::RootI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n# \n# This was refactored to have chained calls to new instead\n# of chained calls to _initialize\n#\n# added debug and deprecated methods --Jason Stajich 2001-10-12\n# \n\n=head1 NAME\n\nBio::Root::RootI - Abstract interface to root object code\n\n=head1 SYNOPSIS\n\n  # any bioperl or bioperl compliant object is a RootI \n  # compliant object\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Using throw_not_implemented() within a RootI-based interface module:\n\n  package Foo;\n  use base qw(Bio::Root::RootI);\n\n  sub foo {\n      my $self = shift;\n      $self->throw_not_implemented;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is just a set of methods which do not assume B<anything> about the object\nthey are on. The methods provide the ability to throw exceptions with nice\nstack traces.\n\nThis is what should be inherited by all Bioperl compliant interfaces, even\nif they are exotic XS/CORBA/Other perl systems.\n\n=head2 Using throw_not_implemented()\n\nThe method L<throw_not_implemented()|throw_not_implemented> should be\ncalled by all methods within interface modules that extend RootI so\nthat if an implementation fails to override them, an exception will be\nthrown.\n\nFor example, say there is an interface module called C<FooI> that\nprovides a method called C<foo()>. Since this method is considered\nabstract within FooI and should be implemented by any module claiming to\nimplement C<FooI>, the C<FooI::foo()> method should consist of the\nfollowing:\n\n    sub foo {\n    \tmy $self = shift;\n    \t$self->throw_not_implemented;\n    }\n\nSo, if an implementer of C<FooI> forgets to implement C<foo()>\nand a user of the implementation calls C<foo()>, a\nL<Bio::Exception::NotImplemented> exception will result.\n\nUnfortunately, failure to implement a method can only be determined at\nrun time (i.e., you can't verify that an implementation is complete by\nrunning C<perl -wc> on it). So it should be standard practice for a test\nof an implementation to check each method and verify that it doesn't\nthrow a L<Bio::Exception::NotImplemented>.\n\n=head1 CONTACT\n\nFunctions originally from Steve Chervitz. Refactored by Ewan\nBirney. Re-refactored by Lincoln Stein. Added to by Sendu Bala.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Root::RootI;\n\nuse vars qw($DEBUG $ID $VERBOSITY);\nuse strict;\nuse Carp 'confess','carp';\n\nuse Bio::Root::Version;\n\nBEGIN { \n    $ID        = 'Bio::Root::RootI';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n}\n\nsub new {\n  my $class = shift;\n  my @args = @_;\n  unless ( $ENV{'BIOPERLDEBUG'} ) {\n      carp(\"Use of new in Bio::Root::RootI is deprecated.  Please use Bio::Root::Root instead\");\n  }\n  eval \"require Bio::Root::Root\";\n  return Bio::Root::Root->new(@args);\n}\n\n# for backwards compatibility\nsub _initialize {\n    my($self,@args) = @_;\n    return 1;\n}\n\n\n=head2 throw\n\n Title   : throw\n Usage   : $obj->throw(\"throwing exception message\")\n Function: Throws an exception, which, if not caught with an eval brace\n           will provide a nice stack trace to STDERR with the message\n Returns : nothing\n Args    : A string giving a descriptive error message\n\n\n\nsub throw{\n   my ($self,$string) = @_;\n\n   my $std = $self->stack_trace_dump();\n\n   my $out = \"\\n-------------------- EXCEPTION --------------------\\n\".\n       \"MSG: \".$string.\"\\n\".$std.\"-------------------------------------------\\n\";\n   die $out;\n\n}\n\n=head2 warn\n\n Title   : warn\n Usage   : $object->warn(\"Warning message\");\n Function: Places a warning. What happens now is down to the\n           verbosity of the object  (value of $obj->verbose) \n            verbosity 0 or not set => small warning\n            verbosity -1 => no warning\n            verbosity 1 => warning with stack trace\n            verbosity 2 => converts warnings into throw\n Returns : n/a\n Args    : string (the warning message)\n\n\nsub warn {\n    my ($self,$string) = @_;\n    \n    my $verbose = $self->verbose;\n    \n    my $header = \"\\n--------------------- WARNING ---------------------\\nMSG: \";\n    my $footer =   \"---------------------------------------------------\\n\";\n    \n    if ($verbose >= 2) {\n        $self->throw($string);\n    }\n    elsif ($verbose <= -1) {\n        return;\n    }\n    elsif ($verbose == 1) {\n        CORE::warn $header, $string, \"\\n\", $self->stack_trace_dump, $footer;\n        return;\n    }    \n    \n    CORE::warn $header, $string, \"\\n\", $footer;\n}\n\n=head2 deprecated\n\n Title   : deprecated\n Usage   : $obj->deprecated(\"Method X is deprecated\");\n           $obj->deprecated(\"Method X is deprecated\", 1.007);\n           $obj->deprecated(-message => \"Method X is deprecated\");\n           $obj->deprecated(-message => \"Method X is deprecated\",\n                            -version => 1.007);\n Function: Prints a message about deprecation unless verbose is < 0\n           (which means be quiet)\n Returns : none\n Args    : Message string to print to STDERR\n           Version of BioPerl where use of the method results in an exception\n Notes   : The method can be called two ways, either by positional arguments:\n           \n           $obj->deprecated('This module is deprecated', 1.006);\n           \n           or by named arguments:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -version => 1.006  # throw if $VERSION is >= this version\n                );\n\n           or timed to go off at a certain point:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -warn_version    => 1.006 # warn if $VERSION is >= this version\n                -throw_version   => 1.007 # throw if $VERSION is >= this version\n                );\n           \n           Using the last two named argument versions is suggested and will\n           likely be the only supported way of calling this method in the future\n           Yes, we see the irony of deprecating that particular usage of\n           deprecated().\n           \n           The main difference between usage of the two named argument versions\n           is that by designating a 'warn_version' one indicates the\n           functionality is officially deprecated beginning in a future version\n           of BioPerl (so warnings are issued only after that point), whereas\n           setting either 'version' or 'throw_version' (synonyms) converts the\n           deprecation warning to an exception.\n           \n           For proper comparisons one must use a version in lines with the\n           current versioning scheme for Perl and BioPerl, (i.e. where 1.006000\n           indicates v1.6.0, 5.010000 for v5.10.0, etc.).\n\n\nsub deprecated{\n    my ($self) = shift;\n    my ($msg, $version, $warn_version, $throw_version) =\n        $self->_rearrange([qw(MESSAGE VERSION WARN_VERSION THROW_VERSION)], @_);    \n    $version ||= $throw_version;\n    for my $v ($warn_version, $version) {\n        next unless defined $v;\n        $self->throw('Version must be numerical, such as 1.006000 for v1.6.0, not '.\n                     $v) unless $v =~ /^\\d+\\.\\d+$/;\n    }\n    return if ($warn_version && $Bio::Root::Version::VERSION < $warn_version);\n    # below default insinuates we're deprecating a method and not a full module\n    # but it's the most common use case\n    $msg ||= \"Use of \".(caller(1))[3].\"() is deprecated\";\n    # delegate to either warn or throw based on whether a version is given\n    if ($version) {\n        $msg .= \"\\nTo be removed in $version\";\n        if ($Bio::Root::Version::VERSION >= $version) {\n            $self->throw($msg)\n        } \n    }\n    # passing this on to warn() should deal properly with verbosity issues\n    $self->warn($msg);\n}\n\n=head2 stack_trace_dump\n\n Title   : stack_trace_dump\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub stack_trace_dump{\n   my ($self) = @_;\n\n   my @stack = $self->stack_trace();\n\n   shift @stack;\n   shift @stack;\n   shift @stack;\n\n   my $out;\n   my ($module,$function,$file,$position);\n   \n\n   foreach my $stack ( @stack) {\n       ($module,$file,$position,$function) = @{$stack};\n       $out .= \"STACK $function $file:$position\\n\";\n   }\n\n   return $out;\n}\n\n\n=head2 stack_trace\n\n Title   : stack_trace\n Usage   : @stack_array_ref= $self->stack_trace\n Function: gives an array to a reference of arrays with stack trace info\n           each coming from the caller(stack_number) call\n Returns : array containing a reference of arrays\n Args    : none\n\n\n\nsub stack_trace{\n   my ($self) = @_;\n\n   my $i = 0;\n   my @out = ();\n   my $prev = [];\n   while( my @call = caller($i++)) {\n       # major annoyance that caller puts caller context as\n       # function name. Hence some monkeying around...\n       $prev->[3] = $call[3];\n       push(@out,$prev);\n       $prev = \\@call;\n   }\n   $prev->[3] = 'toplevel';\n   push(@out,$prev);\n   return @out;\n}\n\n\n=head2 _rearrange\n\n Usage     : $object->_rearrange( array_ref, list_of_arguments)\n Purpose   : Rearranges named parameters to requested order.\n Example   : $self->_rearrange([qw(SEQUENCE ID DESC)],@param);\n           : Where @param = (-sequence => $s,\n\t       :                 -desc     => $d,\n\t       :                 -id       => $i);\n Returns   : @params - an array of parameters in the requested order.\n           : The above example would return ($s, $i, $d).\n           : Unspecified parameters will return undef. For example, if\n           :        @param = (-sequence => $s);\n           : the above _rearrange call would return ($s, undef, undef)\n Argument  : $order : a reference to an array which describes the desired\n           :          order of the named parameters.\n           : @param : an array of parameters, either as a list (in\n           :          which case the function simply returns the list),\n           :          or as an associative array with hyphenated tags\n           :          (in which case the function sorts the values \n           :          according to @{$order} and returns that new array.)\n\t       :\t      The tags can be upper, lower, or mixed case\n           :          but they must start with a hyphen (at least the\n           :          first one should be hyphenated.)\n Source    : This function was taken from CGI.pm, written by Dr. Lincoln\n           : Stein, and adapted for use in Bio::Seq by Richard Resnick and\n           : then adapted for use in Bio::Root::Object.pm by Steve Chervitz,\n           : then migrated into Bio::Root::RootI.pm by Ewan Birney.\n Comments  :\n           : Uppercase tags are the norm, \n           : (SAC)\n           : This method may not be appropriate for method calls that are\n           : within in an inner loop if efficiency is a concern.\n           :\n           : Parameters can be specified using any of these formats:\n           :  @param = (-name=>'me', -color=>'blue');\n           :  @param = (-NAME=>'me', -COLOR=>'blue');\n           :  @param = (-Name=>'me', -Color=>'blue');\n           :  @param = ('me', 'blue');\n           : A leading hyphenated argument is used by this function to \n           : indicate that named parameters are being used.\n           : Therefore, the ('me', 'blue') list will be returned as-is.\n           :\n\t       : Note that Perl will confuse unquoted, hyphenated tags as \n           : function calls if there is a function of the same name \n           : in the current namespace:\n           :    -name => 'foo' is interpreted as -&name => 'foo'\n\t       :\n           : For ultimate safety, put single quotes around the tag:\n\t       : ('-name'=>'me', '-color' =>'blue');\n           : This can be a bit cumbersome and I find not as readable\n           : as using all uppercase, which is also fairly safe:\n\t       : (-NAME=>'me', -COLOR =>'blue');\n\t       :\n           : Personal note (SAC): I have found all uppercase tags to\n           : be more managable: it involves less single-quoting,\n           : the key names stand out better, and there are no method naming \n           : conflicts.\n           : The drawbacks are that it's not as easy to type as lowercase,\n           : and lots of uppercase can be hard to read.\n           :\n           : Regardless of the style, it greatly helps to line\n\t       : the parameters up vertically for long/complex lists.\n           :\n           : Note that if @param is a single string that happens to start with\n           : a dash, it will be treated as a hash key and probably fail to\n           : match anything in the array_ref, so not be returned as normally\n           : happens when @param is a simple list and not an associative array.\n\n\nsub _rearrange {\n    my $dummy = shift;\n    my $order = shift;\n    \n    return @_ unless (substr($_[0]||'',0,1) eq '-');\n    push @_,undef unless $#_ %2;\n    my %param;\n    while( @_ ) {\n\t(my $key = shift) =~ tr/a-z\\055/A-Z/d; #deletes all dashes!\n\t$param{$key} = shift;\n    }\n    map { $_ = uc($_) } @$order; # for bug #1343, but is there perf hit here?\n    return @param{@$order};\n}\n\n=head2 _set_from_args\n\n Usage     : $object->_set_from_args(\\%args, -methods => \\@methods)\n Purpose   : Takes a hash of user-supplied args whose keys match method names,\n           : and calls the method supplying it the corresponding value.\n Example   : $self->_set_from_args(\\%args, -methods => [qw(sequence id desc)]);\n           : Where %args = (-sequence    => $s,\n\t       :                -description => $d,\n\t       :                -ID          => $i);\n           :\n           : the above _set_from_args calls the following methods:\n           : $self->sequence($s);\n           : $self->id($i);\n           : ( $self->description($i) is not called because 'description' wasn't\n           :   one of the given methods )\n Argument  : \\%args | \\@args : a hash ref or associative array ref of arguments\n           :                   where keys are any-case strings corresponding to\n           :                   method names but optionally prefixed with\n           :                   hyphens, and values are the values the method\n           :                   should be supplied. If keys contain internal\n           :                   hyphens (eg. to separate multi-word args) they\n           :                   are converted to underscores, since method names\n           :                   cannot contain dashes.\n           : -methods => []  : (optional) only call methods with names in this\n           :                   array ref. Can instead supply a hash ref where\n           :                   keys are method names (of real existing methods\n           :                   unless -create is in effect) and values are array\n           :                   refs of synonyms to allow access to the method\n           :                   using synonyms. If there is only one synonym it\n           :                   can be supplied as a string instead of a single-\n           :                   element array ref\n           : -force => bool  : (optional, default 0) call methods that don't\n           :                   seem to exist, ie. let AUTOLOAD handle them\n           : -create => bool : (optional, default 0) when a method doesn't\n           :                   exist, create it as a simple getter/setter\n           :                   (combined with -methods it would create all the\n           :                   supplied methods that didn't exist, even if not\n           :                   mentioned in the supplied %args)\n           : -code => '' | {}: (optional) when creating methods use the supplied\n           :                   code (a string which will be evaulated as a sub).\n           :                   The default code is a simple get/setter.\n           :                   Alternatively you can supply a hash ref where\n           :                   the keys are method names and the values are\n           :                   code strings. The variable '$method' will be\n           :                   available at evaluation time, so can be used in\n           :                   your code strings. Beware that the strict pragma\n           :                   will be in effect.\n           : -case_sensitive => bool : require case sensitivity on the part of\n           :                           user (ie. a() and A() are two different\n           :                           methods and the user must be careful\n           :                           which they use).\n Comments  :\n           : The \\%args argument will usually be the args received during new()\n           : from the user. The user is allowed to get the case wrong, include\n           : 0 or more than one hyphens as a prefix, and to include hyphens as\n           : multi-word arg separators: '--an-arg' => 1, -an_arg => 1 and\n           : An_Arg => 1 are all equivalent, calling an_arg(1). However, in\n           : documentation users should only be told to use the standard form\n           : -an_arg to avoid confusion. A possible exception to this is a\n           : wrapper module where '--an-arg' is what the user is used to\n           : supplying to the program being wrapped.\n           :\n           : Another issue with wrapper modules is that there may be an\n           : argument that has meaning both to Bioperl and to the program, eg.\n           : -verbose. The recommended way of dealing with this is to leave\n           : -verbose to set the Bioperl verbosity whilst requesting users use\n           : an invented -program_verbose (or similar) to set the program\n           : verbosity. This can be resolved back with\n           : Bio::Tools::Run::WrapperBase's _setparams() method and code along\n           : the lines of:\n           : my %methods = map { $_ => $_ } @LIST_OF_ALL_ALLOWED_PROGRAM_ARGS\n           : delete $methods{'verbose'};\n           : $methods{'program_verbose'} = 'verbose';\n           : my $param_string = $self->_setparams(-methods => \\%methods);\n           : system(\"$exe $param_string\");\n\n\nsub _set_from_args {\n    my ($self, $args, @own_args) = @_;\n    $self->throw(\"a hash/array ref of arguments must be supplied\") unless ref($args);\n    \n    my ($methods, $force, $create, $code, $case);\n    if (@own_args) {\n        ($methods, $force, $create, $code, $case) =\n            $self->_rearrange([qw(METHODS\n                                  FORCE\n                                  CREATE\n                                  CODE\n                                  CASE_SENSITIVE)], @own_args);\n    }\n    my $default_code = 'my $self = shift;\n                        if (@_) { $self->{\\'_\\'.$method} = shift }\n                        return $self->{\\'_\\'.$method};';\n    \n    my %method_names = ();\n    my %syns = ();\n    if ($methods) {\n        my @names;\n        if (ref($methods) eq 'HASH') {\n            @names = keys %{$methods};\n            %syns = %{$methods};\n        }\n        else {\n            @names = @{$methods};\n            %syns = map { $_ => $_ } @names;\n        }\n        %method_names = map { $case ? $_ : lc($_) => $_ } @names;\n    }\n    \n    # deal with hyphens\n    my %orig_args = ref($args) eq 'HASH' ? %{$args} : @{$args};\n    my %args;\n    while (my ($method, $value) = each %orig_args) {\n        $method =~ s/^-+//;\n        $method =~ s/-/_/g;\n        $args{$method} = $value;\n    }\n    \n    # create non-existing methods on request\n    if ($create) {\n        unless ($methods) {\n            %syns = map { $_ => $case ? $_ : lc($_) } keys %args;\n        }\n        \n        foreach my $method (keys %syns) {\n            $self->can($method) && next;\n            \n            my $string = $code || $default_code;\n            if (ref($code) && ref($code) eq 'HASH') {\n                $string = $code->{$method} || $default_code;\n            }\n            \n            my $sub = eval \"sub { $string }\";\n            $self->throw(\"Compilation error for $method : $@\") if $@;\n            \n            no strict 'refs';\n            *{ref($self).'::'.$method} = $sub;\n        }\n    }\n    \n    # create synonyms of existing methods\n    while (my ($method, $syn_ref) = each %syns) {\n        my $method_ref = $self->can($method) || next;\n        \n        foreach my $syn (@{ ref($syn_ref) ? $syn_ref : [$syn_ref] }) {\n            next if $syn eq $method;\n            $method_names{$case ? $syn : lc($syn)} = $syn;\n            next if $self->can($syn);\n            no strict 'refs';\n            *{ref($self).'::'.$syn} = $method_ref;\n        }\n    }\n    \n    # set values for methods\n    while (my ($method, $value) = each %args) {\n        $method = $method_names{$case ? $method : lc($method)} || ($methods ? next : $method);\n        $self->can($method) || next unless $force;\n        $self->$method($value);\n    }\n}\n\n#----------------'\nsub _rearrange_old {\n#----------------\n    my($self,$order,@param) = @_;\n    \n    # JGRG -- This is wrong, because we don't want\n    # to assign empty string to anything, and this\n    # code is actually returning an array 1 less\n    # than the length of @param:\n\n    ## If there are no parameters, we simply wish to return\n    ## an empty array which is the size of the @{$order} array.\n    #return ('') x $#{$order} unless @param;\n    \n    # ...all we need to do is return an empty array:\n    # return unless @param;\n    \n    # If we've got parameters, we need to check to see whether\n    # they are named or simply listed. If they are listed, we\n    # can just return them. \n\n    # The mod test fixes bug where a single string parameter beginning with '-' gets lost.\n    # This tends to happen in error messages such as: $obj->throw(\"-id not defined\")\n    return @param unless (defined($param[0]) && $param[0]=~/^-/o && ($#param % 2));\n\n    # Tester\n#    print \"\\n_rearrange() named parameters:\\n\";\n#    my $i; for ($i=0;$i<@param;$i+=2) { printf \"%20s => %s\\n\", $param[$i],$param[$i+1]; }; <STDIN>;\n\n    # Now we've got to do some work on the named parameters.\n    # The next few lines strip out the '-' characters which\n    # preceed the keys, and capitalizes them.\n    for (my $i=0;$i<@param;$i+=2) {\n\t$param[$i]=~s/^\\-//;\n\t$param[$i]=~tr/a-z/A-Z/;\n    }\n    \n    # Now we'll convert the @params variable into an associative array.\n    # local($^W) = 0;  # prevent \"odd number of elements\" warning with -w.\n    my(%param) = @param;\n    \n    # my(@return_array);\n    \n    # What we intend to do is loop through the @{$order} variable,\n    # and for each value, we use that as a key into our associative\n    # array, pushing the value at that key onto our return array.\n    # my($key);\n    \n    #foreach (@{$order}) {\n\t# my($value) = $param{$key};\n\t# delete $param{$key};\n\t#push(@return_array,$param{$_});\n    #}\n\n    return @param{@{$order}};\n    \n#    print \"\\n_rearrange() after processing:\\n\";\n#    my $i; for ($i=0;$i<@return_array;$i++) { printf \"%20s => %s\\n\", ${$order}[$i], $return_array[$i]; } <STDIN>;\n\n    # return @return_array;\n}\n\n=head2 _register_for_cleanup\n\n Title   : _register_for_cleanup\n Usage   : -- internal --\n Function: Register a method to be called at DESTROY time. This is useful\n           and sometimes essential in the case of multiple inheritance for\n           classes coming second in the sequence of inheritance.\n Returns : \n Args    : a code reference\n\nThe code reference will be invoked with the object as the first\nargument, as per a method.  You may register an unlimited number of\ncleanup methods.\n\n\nsub _register_for_cleanup {\n  my ($self,$method) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 _unregister_for_cleanup\n\n Title   : _unregister_for_cleanup\n Usage   : -- internal --\n Function: Remove a method that has previously been registered to be called\n           at DESTROY time.  If called with a method to be called at DESTROY time.\n           Has no effect if the code reference has not previously been registered.\n Returns : nothing\n Args    : a code reference"},"detail":"($self,$method)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_unregister_for_cleanup","line":677,"kind":13},{"name":"$method","containerName":"_unregister_for_cleanup","kind":13,"line":677},{"name":"$self","containerName":"_unregister_for_cleanup","kind":13,"line":678},{"containerName":"_unregister_for_cleanup","name":"throw_not_implemented","line":678,"kind":12}],"line":676,"name":"_unregister_for_cleanup","range":{"start":{"character":0,"line":676},"end":{"character":9999,"line":679}}},{"line":691,"children":[{"containerName":"_cleanup_methods","name":"$self","definition":"my","localvar":"my","kind":13,"line":692},{"containerName":"_cleanup_methods","name":"$ENV","kind":13,"line":693},{"line":693,"kind":13,"containerName":"_cleanup_methods","name":"$self"},{"kind":12,"line":693,"name":"verbose","containerName":"_cleanup_methods"}],"kind":12,"range":{"start":{"line":691,"character":0},"end":{"character":9999,"line":697}},"containerName":"main::","name":"_cleanup_methods","definition":"sub"},{"line":694,"kind":12,"name":"carp"},{"containerName":"main::","definition":"sub","name":"throw_not_implemented","range":{"start":{"line":727,"character":0},"end":{"line":744,"character":9999}},"kind":12,"line":727,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"throw_not_implemented","line":728,"kind":13},{"line":736,"kind":13,"localvar":"my","containerName":"throw_not_implemented","definition":"my","name":"$message"},{"kind":13,"line":736,"name":"$self","containerName":"throw_not_implemented"},{"kind":12,"line":736,"containerName":"throw_not_implemented","name":"_not_implemented_msg"},{"line":738,"kind":13,"containerName":"throw_not_implemented","name":"$self"},{"name":"can","containerName":"throw_not_implemented","line":738,"kind":12},{"line":739,"kind":13,"containerName":"throw_not_implemented","name":"$self"},{"line":739,"kind":12,"name":"throw","containerName":"throw_not_implemented"},{"name":"$message","containerName":"throw_not_implemented","kind":13,"line":739},{"line":742,"kind":13,"containerName":"throw_not_implemented","name":"$message"}]},{"line":742,"kind":12,"name":"confess"},{"range":{"end":{"line":777,"character":9999},"start":{"character":0,"line":769}},"containerName":"main::","name":"warn_not_implemented","definition":"sub","line":769,"children":[{"containerName":"warn_not_implemented","name":"$self","definition":"my","localvar":"my","kind":13,"line":770},{"definition":"my","name":"$message","containerName":"warn_not_implemented","localvar":"my","kind":13,"line":771},{"name":"$self","containerName":"warn_not_implemented","line":771,"kind":13},{"containerName":"warn_not_implemented","name":"_not_implemented_msg","line":771,"kind":12},{"line":772,"kind":13,"name":"$self","containerName":"warn_not_implemented"},{"kind":12,"line":772,"containerName":"warn_not_implemented","name":"can"},{"kind":13,"line":773,"name":"$self","containerName":"warn_not_implemented"},{"name":"warn","containerName":"warn_not_implemented","kind":12,"line":773},{"name":"$message","containerName":"warn_not_implemented","line":773,"kind":13},{"line":775,"kind":13,"name":"$message","containerName":"warn_not_implemented"}],"kind":12},{"name":"carp","kind":12,"line":775},{"name":"_not_implemented_msg","definition":"sub","containerName":"main::","range":{"end":{"line":789,"character":9999},"start":{"character":0,"line":780}},"kind":12,"children":[{"containerName":"_not_implemented_msg","definition":"my","name":"$self","localvar":"my","kind":13,"line":781},{"line":782,"kind":13,"localvar":"my","containerName":"_not_implemented_msg","definition":"my","name":"$package"},{"containerName":"_not_implemented_msg","name":"$self","kind":13,"line":782},{"containerName":"_not_implemented_msg","definition":"my","name":"$meth","localvar":"my","kind":13,"line":783},{"localvar":"my","containerName":"_not_implemented_msg","name":"$msg","definition":"my","line":784,"kind":13},{"kind":13,"line":788,"containerName":"_not_implemented_msg","name":"$msg"}],"line":780}],"version":5}