{"vars":[{"containerName":"","name":"vars","line":79,"kind":2},{"containerName":"","name":"base","line":89,"kind":2},{"containerName":"main::","definition":"sub","name":"read","range":{"end":{"line":230,"character":9999},"start":{"line":101,"character":0}},"kind":12,"line":101,"children":[{"line":102,"kind":13,"localvar":"my","containerName":"read","name":"$self","definition":"my"},{"definition":"my","name":"$renzs","containerName":"read","localvar":"my","kind":13,"line":104},{"kind":12,"line":104,"name":"new","containerName":"read"},{"line":107,"kind":13,"localvar":"my","containerName":"read","definition":"my","name":"$entry"},{"containerName":"read","name":"$self","line":107,"kind":13},{"kind":12,"line":107,"name":"_readline","containerName":"read"},{"name":"$self","containerName":"read","kind":13,"line":108},{"containerName":"read","name":"debug","line":108,"kind":12},{"localvar":"my","name":"$name","definition":"my","containerName":"read","line":113,"kind":13},{"kind":13,"line":113,"name":"$entry","containerName":"read"},{"kind":13,"line":114,"definition":"my","name":"$site","containerName":"read","localvar":"my"},{"kind":13,"line":114,"name":"$entry","containerName":"read"},{"name":"$name","containerName":"read","line":115,"kind":13},{"containerName":"read","name":"$site","line":115,"kind":13},{"definition":"my","name":"@sequences","containerName":"read","localvar":"my","kind":13,"line":125},{"containerName":"read","name":"$site","kind":13,"line":126},{"name":"@sequences","containerName":"read","kind":13,"line":127},{"name":"$site","containerName":"read","line":127,"kind":13},{"containerName":"read","name":"$self","kind":13,"line":128},{"name":"debug","containerName":"read","kind":12,"line":128},{"kind":13,"line":128,"name":"@sequences","containerName":"read"},{"kind":13,"line":129,"containerName":"read","name":"$site"},{"kind":13,"line":129,"name":"@sequences","containerName":"read"},{"containerName":"read","definition":"my","name":"$seq","localvar":"my","kind":13,"line":132},{"kind":13,"line":132,"name":"$cut","containerName":"read"},{"containerName":"read","name":"$site","line":132,"kind":13},{"name":"$self","containerName":"read","line":133,"kind":13},{"line":133,"kind":12,"name":"debug","containerName":"read"},{"containerName":"read","name":"$seq","kind":13,"line":134},{"kind":13,"line":135,"name":"$self","containerName":"read"},{"line":135,"kind":12,"name":"warn","containerName":"read"},{"containerName":"read","name":"$self","line":135,"kind":13},{"name":"verbose","containerName":"read","kind":12,"line":135},{"name":"$seq","containerName":"read","kind":13,"line":140},{"line":141,"kind":13,"name":"$self","containerName":"read"},{"name":"throw","containerName":"read","kind":12,"line":141},{"kind":13,"line":143,"containerName":"read","definition":"my","name":"$re","localvar":"my"},{"line":144,"kind":13,"containerName":"read","name":"$cut"},{"kind":13,"line":145,"name":"$re","containerName":"read"},{"name":"new","containerName":"read","line":145,"kind":12},{"kind":13,"line":145,"name":"$name","containerName":"read"},{"name":"$seq","containerName":"read","kind":13,"line":145},{"kind":13,"line":148,"containerName":"read","name":"$cut"},{"name":"$self","containerName":"read","line":149,"kind":13},{"name":"throw","containerName":"read","kind":12,"line":149},{"name":"$re","containerName":"read","kind":13,"line":152},{"line":152,"kind":12,"name":"new","containerName":"read"},{"line":152,"kind":13,"containerName":"read","name":"$name"},{"line":153,"kind":13,"name":"$cut","containerName":"read"},{"kind":13,"line":155,"containerName":"read","name":"$seq"},{"line":157,"kind":13,"containerName":"read","name":"$renzs"},{"kind":12,"line":157,"name":"enzymes","containerName":"read"},{"containerName":"read","name":"$re","line":157,"kind":13},{"localvar":"my","name":"$prototype","definition":"my","containerName":"read","line":162,"kind":13},{"kind":13,"line":162,"name":"$entry","containerName":"read"},{"containerName":"read","name":"$prototype","line":164,"kind":13},{"containerName":"read","name":"$re","kind":13,"line":167},{"containerName":"read","name":"is_prototype","kind":12,"line":167},{"line":169,"kind":13,"name":"$re","containerName":"read"},{"containerName":"read","name":"is_prototype","kind":12,"line":169},{"localvar":"my","containerName":"read","definition":"my","name":"$meth","line":176,"kind":13},{"line":176,"kind":13,"name":"$entry","containerName":"read"},{"kind":13,"line":177,"containerName":"read","name":"@meths","definition":"my","localvar":"my"},{"containerName":"read","name":"$meth","kind":13,"line":178},{"containerName":"read","name":"$meth","kind":13,"line":181},{"line":183,"kind":13,"containerName":"read","name":"$re"},{"containerName":"read","name":"methylation_sites","line":183,"kind":12},{"line":183,"kind":13,"name":"$self","containerName":"read"},{"name":"_meth","containerName":"read","line":183,"kind":12},{"line":183,"kind":13,"name":"$re","containerName":"read"},{"line":184,"kind":13,"containerName":"read","name":"$self"},{"line":184,"kind":12,"containerName":"read","name":"_meth"},{"name":"$re","containerName":"read","kind":13,"line":184},{"name":"$meth","containerName":"read","line":186,"kind":13},{"containerName":"read","name":"$re","kind":13,"line":188},{"containerName":"read","name":"methylation_sites","kind":12,"line":188},{"name":"$self","containerName":"read","kind":13,"line":188},{"containerName":"read","name":"_meth","kind":12,"line":188},{"containerName":"read","name":"$re","kind":13,"line":188},{"name":"@meths","containerName":"read","line":189,"kind":13},{"line":189,"kind":13,"name":"$meth","containerName":"read"},{"containerName":"read","name":"$meth","line":190,"kind":13},{"containerName":"read","name":"@meths","line":190,"kind":13},{"kind":13,"line":192,"name":"$self","containerName":"read"},{"kind":12,"line":192,"name":"warn","containerName":"read"},{"kind":13,"line":192,"name":"$self","containerName":"read"},{"containerName":"read","name":"verbose","kind":12,"line":192},{"line":199,"kind":13,"localvar":"my","containerName":"read","name":"$microbe","definition":"my"},{"line":199,"kind":13,"name":"$entry","containerName":"read"},{"kind":13,"line":200,"containerName":"read","name":"$re"},{"line":200,"kind":12,"containerName":"read","name":"microbe"},{"kind":13,"line":200,"containerName":"read","name":"$microbe"},{"containerName":"read","name":"$microbe","line":200,"kind":13},{"localvar":"my","definition":"my","name":"$vendors","containerName":"read","line":211,"kind":13},{"containerName":"read","name":"$entry","kind":13,"line":211},{"kind":13,"line":212,"name":"$re","containerName":"read"},{"line":212,"kind":12,"containerName":"read","name":"vendors"},{"kind":13,"line":212,"containerName":"read","name":"$vendors"},{"name":"$vendors","containerName":"read","kind":13,"line":212},{"containerName":"read","name":"$self","kind":13,"line":223},{"line":223,"kind":12,"containerName":"read","name":"warn"},{"line":224,"kind":13,"name":"@sequences","containerName":"read"},{"line":229,"kind":13,"name":"$renzs","containerName":"read"}]},{"name":"Bio","containerName":"Restriction::EnzymeCollection","line":104,"kind":12},{"line":145,"kind":12,"containerName":"Restriction::Enzyme","name":"Bio"},{"name":"Bio","containerName":"Restriction::Enzyme","line":152,"kind":12},{"range":{"start":{"line":244,"character":0},"end":{"character":9999,"line":247}},"name":"write","children":[{"line":245,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"write"},{"kind":13,"line":245,"name":"@h","containerName":"write"},{"name":"$self","containerName":"write","line":246,"kind":13},{"line":246,"kind":12,"containerName":"write","name":"throw_not_implemented"}],"line":244,"kind":12,"signature":{"documentation":"1;\n# $Id: bairoch.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Restriction::IO::withrefm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rob Edwards <redwards@utmem.edu>\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Restriction::IO::bairoch - bairoch enzyme set\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::Restriction::IO class.\n\n=head1 DESCRIPTION\n\nThis is the most complete format of the REBASE files, and basically\nincludes all the data on each of the restriction enzymes.\n\nThis parser is for the Bairoch format (aka MacVector, Vector NTI, PC/Gene \n(Bairoch) format), REBASE format #19\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRob Edwards, redwards@utmem.edu\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Restriction::IO::bairoch;\n\nuse vars qw(%WITH_REFM_FIELD);\nuse strict;\n\nuse Bio::Restriction::Enzyme;\nuse Bio::Restriction::Enzyme::MultiCut;\nuse Bio::Restriction::Enzyme::MultiSite;\nuse Bio::Restriction::EnzymeCollection;\n\nuse Data::Dumper;\n\nuse base qw(Bio::Restriction::IO::base);\n\n=head2 read\n\n Title   : read\n Usage   : $renzs = $stream->read\n Function: reads all the restrction enzymes from the stream\n Returns : a Bio::Restriction::Restriction object\n Args    : none\n\n\nsub read {\n    my $self = shift;\n\n    my $renzs = Bio::Restriction::EnzymeCollection->new(-empty => 1);\n\n    local $/ = '//';\n    while (defined(my $entry=$self->_readline()) ) {\n        $self->debug(\"|$entry|\\n\");\n\n        #\n        # Minimal information\n        #\n        my ($name) = $entry =~ /ID\\s+(\\S+)/;\n        my ($site) = $entry =~ /RS\\s+([^\\n]+)/;\n        next unless ($name && $site);\n       \n        # the standard sequence format for these guys is:\n        # GATC, 2;\n        # or, for enzymes that cut more than once\n        # GATC, 2; GTAC, 2; \n\n        # there are a couple of sequences that have multiple\n        # recognition sites. \n\n        my @sequences;\n        if ($site =~ /\\;/) {\n            @sequences = split /\\;/, $site;\n            $self->debug(@sequences,\"\\n\");\n            $site=shift @sequences;\n        }\n        \n        my ($seq, $cut)=split /,\\s+/, $site;\n        $self->debug(\"SITE: |$site| GAVE: |$seq| and |$cut|\\n\");\n        if ($seq eq '?') {\n           $self->warn(\"$name: no site. Skipping\") if $self->verbose > 1;\n           next;\n        }\n        \n            # this is mainly an error check to make sure that I am adding what I think I am!\t\n        if ($seq !~ /[NGATC]/i) {\n          $self->throw(\"Sequence $name has weird sequence: |$seq|\");\n        }\n        my $re;\n        if ($cut eq \"?\") {\n              $re = Bio::Restriction::Enzyme->new(-name=>$name, -seq => $seq);\n        }\n        else {\n               if ($cut !~ /^-?\\d+$/) {\n             $self->throw(\"Cut site from $name is weird: |$cut|\\n\");\n               }\n        \n               $re = Bio::Restriction::Enzyme->new(-name=>$name,\n                                                  -cut => $cut,\n                                                  -seq => $seq\n                                                  );\n        }\n        $renzs->enzymes($re);\n\n        #\n        # prototype / isoschizomers\n        #\n        my ($prototype) = $entry =~ /PT\\s+([^\\n]+)/;\n\n        if ($prototype) {\n            #$re->isoschizomers(split /\\,/, $isoschizomers);\n            #NOTE: Need to add a method so that we can add isoschosomers to enzymes that may not exist!\n\t    $re->is_prototype(0);\n        } else {\n            $re->is_prototype(1);\n        }\n\n        #\n        # methylation\n        #\n\n        my ($meth) = $entry =~ /MS\\s+([^\\n]+)/;\n        my @meths;\n        if ($meth) {\n            # this can be either X(Y) or X(Y),X2(Y2)\n            # where X is the base and y is the type of methylation\n            if ( $meth =~ /(\\S+)\\((\\d+)\\),(\\S+)\\((\\d+)\\)/ ) { # two msites per site\n                #my ($p1, $m1, $p2, $m2) = ($1, $2, $3, $4);\n                $re->methylation_sites($self->_meth($re,$1, $2),\n                                       $self->_meth($re,$3,$4));\n            }\n            elsif ($meth =~ /(\\S+)\\((\\d+)\\)/ ) { # one msite per site or more sites\n                #print Dumper $meth;\n                $re->methylation_sites( $self->_meth($re,$1,$2) );\n                @meths = split /, /, $meth;\n                $meth=shift @meths;\n            } else {\n                $self->warn(\"Unknown methylation format [$meth]\") if $self->verbose >0;\n            }\n        }\n\n        #\n        # microbe\n        #\n        my ($microbe) = $entry =~ /OS\\s+([^\\n]+)/;\n        $re->microbe($microbe) if $microbe;\n\n        #\n        # source\n        #\n        #my ($source) = $entry =~ /<6>([^\\n]+)/;\n        #$re->source($source) if $source;\n\n        #\n        # vendors\n        #\n        my ($vendors) = $entry =~ /CR\\s+([^\\n]+)/;\n        $re->vendors(split /,\\s*/, $vendors) if $vendors;\n\n        #\n        # references\n        #\n        #my ($refs) = $entry =~ /<8>(.+)/s;\n        #$re->references(map {split /\\n+/} $refs) if $refs;\n\n        #\n        # create special types of Enzymes\n        #\n        $self->warn(\"Current issues with multisite enzymes using bairoch format\\n\".\n                    \"Recommend using itype2 or withrefm formats for now\") if @sequences;\n        #$self->_make_multisites($renzs, $re, \\@sequences, \\@meths) if @sequences;\n\n    }\n\n    return $renzs;\n}\n\n\n=head2 write\n\n Title   : write\n Usage   : $stream->write($renzs)\n Function: writes restriction enzymes into the stream\n Returns : 1 for success and 0 for error\n Args    : a Bio::Restriction::Enzyme\n           or a Bio::Restriction::EnzymeCollection object","parameters":[{"label":"$self"},{"label":"@h"}],"label":"write($self,@h)"},"detail":"($self,@h)","definition":"sub","containerName":"main::"}],"version":5}