{"version":5,"vars":[{"kind":2,"line":128,"name":"base","containerName":""},{"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"seq","line":150,"kind":13},{"containerName":"seq","name":"$self","line":151,"kind":13},{"containerName":"seq","name":"throw_not_implemented","line":151,"kind":12}],"line":149,"definition":"sub","containerName":"main::","signature":{"label":"seq($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n    # If you are a newcomer to bioperl, you might want to start with\n    # Bio::Seq documentation.\n\n    # Test if this is a seq object\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # Accessors\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id();       # for human display\n    $id        = $obj->primary_id();       # unique id for this object,\n                                           # implementation defined\n    $unique_key= $obj->accession_number(); # unique biological id\n\n\n    # Object manipulation\n    eval {\n\t   $rev = $obj->revcom();\n    };\n    if( $@ ) {\n\t   $obj->throw(\"Could not reverse complement. \".\n\t\t    \"Probably not DNA. Actual exception\\n$@\\n\");\n    }\n\n    $trunc = $obj->trunc(12,50);\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers-only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in L<Bio::PrimarySeq>. If you just want to\nuse L<Bio::PrimarySeq> objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\nThis interface defines what bioperl considers necessary to \"be\" a\nsequence, without providing an implementation of this, an\nimplementation is provided in L<Bio::PrimarySeq>. If you want to provide\na Bio::PrimarySeq-compliant object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inherit\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but implementations are suggested to\n           keep an open mind about case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual"},"detail":"($self)","name":"seq","range":{"start":{"character":0,"line":149},"end":{"character":9999,"line":152}}},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"subseq($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n    # If you are a newcomer to bioperl, you might want to start with\n    # Bio::Seq documentation.\n\n    # Test if this is a seq object\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # Accessors\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id();       # for human display\n    $id        = $obj->primary_id();       # unique id for this object,\n                                           # implementation defined\n    $unique_key= $obj->accession_number(); # unique biological id\n\n\n    # Object manipulation\n    eval {\n\t   $rev = $obj->revcom();\n    };\n    if( $@ ) {\n\t   $obj->throw(\"Could not reverse complement. \".\n\t\t    \"Probably not DNA. Actual exception\\n$@\\n\");\n    }\n\n    $trunc = $obj->trunc(12,50);\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers-only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in L<Bio::PrimarySeq>. If you just want to\nuse L<Bio::PrimarySeq> objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\nThis interface defines what bioperl considers necessary to \"be\" a\nsequence, without providing an implementation of this, an\nimplementation is provided in L<Bio::PrimarySeq>. If you want to provide\na Bio::PrimarySeq-compliant object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inherit\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but implementations are suggested to\n           keep an open mind about case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, i.e. 1-2 are the first two\n           bases of the sequence.\n\n           Start cannot be larger than end but can be equal.\n\n Returns : A string\n Args    :\n Status  : Virtual"},"kind":12,"line":170,"children":[{"kind":13,"line":171,"name":"$self","definition":"my","containerName":"subseq","localvar":"my"},{"containerName":"subseq","name":"$self","kind":13,"line":172},{"line":172,"kind":12,"name":"throw_not_implemented","containerName":"subseq"}],"name":"subseq","range":{"end":{"character":9999,"line":173},"start":{"character":0,"line":170}}},{"detail":"($self)","signature":{"label":"display_id($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n    # If you are a newcomer to bioperl, you might want to start with\n    # Bio::Seq documentation.\n\n    # Test if this is a seq object\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # Accessors\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id();       # for human display\n    $id        = $obj->primary_id();       # unique id for this object,\n                                           # implementation defined\n    $unique_key= $obj->accession_number(); # unique biological id\n\n\n    # Object manipulation\n    eval {\n\t   $rev = $obj->revcom();\n    };\n    if( $@ ) {\n\t   $obj->throw(\"Could not reverse complement. \".\n\t\t    \"Probably not DNA. Actual exception\\n$@\\n\");\n    }\n\n    $trunc = $obj->trunc(12,50);\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers-only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in L<Bio::PrimarySeq>. If you just want to\nuse L<Bio::PrimarySeq> objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\nThis interface defines what bioperl considers necessary to \"be\" a\nsequence, without providing an implementation of this, an\nimplementation is provided in L<Bio::PrimarySeq>. If you want to provide\na Bio::PrimarySeq-compliant object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inherit\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but implementations are suggested to\n           keep an open mind about case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, i.e. 1-2 are the first two\n           bases of the sequence.\n\n           Start cannot be larger than end but can be equal.\n\n Returns : A string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, also known as the common name of the Sequence\n           object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience reasons.\n Returns : A string\n Args    : None\n Status  : Virtual"},"containerName":"main::","definition":"sub","line":202,"children":[{"kind":13,"line":203,"containerName":"display_id","name":"$self","definition":"my","localvar":"my"},{"line":204,"kind":13,"containerName":"display_id","name":"$self"},{"kind":12,"line":204,"name":"throw_not_implemented","containerName":"display_id"}],"kind":12,"range":{"end":{"character":9999,"line":205},"start":{"line":202,"character":0}},"name":"display_id"},{"range":{"end":{"character":9999,"line":231},"start":{"line":228,"character":0}},"name":"accession_number","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n    # If you are a newcomer to bioperl, you might want to start with\n    # Bio::Seq documentation.\n\n    # Test if this is a seq object\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # Accessors\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id();       # for human display\n    $id        = $obj->primary_id();       # unique id for this object,\n                                           # implementation defined\n    $unique_key= $obj->accession_number(); # unique biological id\n\n\n    # Object manipulation\n    eval {\n\t   $rev = $obj->revcom();\n    };\n    if( $@ ) {\n\t   $obj->throw(\"Could not reverse complement. \".\n\t\t    \"Probably not DNA. Actual exception\\n$@\\n\");\n    }\n\n    $trunc = $obj->trunc(12,50);\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers-only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in L<Bio::PrimarySeq>. If you just want to\nuse L<Bio::PrimarySeq> objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\nThis interface defines what bioperl considers necessary to \"be\" a\nsequence, without providing an implementation of this, an\nimplementation is provided in L<Bio::PrimarySeq>. If you want to provide\na Bio::PrimarySeq-compliant object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inherit\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but implementations are suggested to\n           keep an open mind about case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, i.e. 1-2 are the first two\n           bases of the sequence.\n\n           Start cannot be larger than end but can be equal.\n\n Returns : A string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, also known as the common name of the Sequence\n           object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience reasons.\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual","label":"accession_number($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":229,"name":"$self","definition":"my","containerName":"accession_number","localvar":"my"},{"line":229,"kind":13,"name":"@args","containerName":"accession_number"},{"containerName":"accession_number","name":"$self","kind":13,"line":230},{"kind":12,"line":230,"name":"throw_not_implemented","containerName":"accession_number"}],"line":228,"kind":12},{"name":"primary_id","range":{"start":{"line":254,"character":0},"end":{"character":9999,"line":257}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: PrimarySeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n    # If you are a newcomer to bioperl, you might want to start with\n    # Bio::Seq documentation.\n\n    # Test if this is a seq object\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # Accessors\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id();       # for human display\n    $id        = $obj->primary_id();       # unique id for this object,\n                                           # implementation defined\n    $unique_key= $obj->accession_number(); # unique biological id\n\n\n    # Object manipulation\n    eval {\n\t   $rev = $obj->revcom();\n    };\n    if( $@ ) {\n\t   $obj->throw(\"Could not reverse complement. \".\n\t\t    \"Probably not DNA. Actual exception\\n$@\\n\");\n    }\n\n    $trunc = $obj->trunc(12,50);\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers-only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in L<Bio::PrimarySeq>. If you just want to\nuse L<Bio::PrimarySeq> objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\nThis interface defines what bioperl considers necessary to \"be\" a\nsequence, without providing an implementation of this, an\nimplementation is provided in L<Bio::PrimarySeq>. If you want to provide\na Bio::PrimarySeq-compliant object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inherit\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but implementations are suggested to\n           keep an open mind about case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, i.e. 1-2 are the first two\n           bases of the sequence.\n\n           Start cannot be larger than end but can be equal.\n\n Returns : A string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, also known as the common name of the Sequence\n           object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience reasons.\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n Returns : A string\n Args    : None\n Status  : Virtual","parameters":[{"label":"$self"},{"label":"@args"}],"label":"primary_id($self,@args)"},"detail":"($self,@args)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"primary_id","line":255,"kind":13},{"name":"@args","containerName":"primary_id","kind":13,"line":255},{"name":"$self","containerName":"primary_id","line":256,"kind":13},{"kind":12,"line":256,"containerName":"primary_id","name":"throw_not_implemented"}],"line":254},{"range":{"start":{"line":283,"character":0},"end":{"line":289,"character":9999}},"name":"can_call_new","line":283,"children":[{"line":284,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"can_call_new"},{"containerName":"can_call_new","name":"@args","kind":13,"line":284}],"kind":12,"detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: PrimarySeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n    # If you are a newcomer to bioperl, you might want to start with\n    # Bio::Seq documentation.\n\n    # Test if this is a seq object\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # Accessors\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id();       # for human display\n    $id        = $obj->primary_id();       # unique id for this object,\n                                           # implementation defined\n    $unique_key= $obj->accession_number(); # unique biological id\n\n\n    # Object manipulation\n    eval {\n\t   $rev = $obj->revcom();\n    };\n    if( $@ ) {\n\t   $obj->throw(\"Could not reverse complement. \".\n\t\t    \"Probably not DNA. Actual exception\\n$@\\n\");\n    }\n\n    $trunc = $obj->trunc(12,50);\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers-only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in L<Bio::PrimarySeq>. If you just want to\nuse L<Bio::PrimarySeq> objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\nThis interface defines what bioperl considers necessary to \"be\" a\nsequence, without providing an implementation of this, an\nimplementation is provided in L<Bio::PrimarySeq>. If you want to provide\na Bio::PrimarySeq-compliant object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inherit\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but implementations are suggested to\n           keep an open mind about case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, i.e. 1-2 are the first two\n           bases of the sequence.\n\n           Start cannot be larger than end but can be equal.\n\n Returns : A string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, also known as the common name of the Sequence\n           object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience reasons.\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: Can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Returns : 1 or 0\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"can_call_new($self,@args)"},"containerName":"main::","definition":"sub"},{"children":[{"kind":13,"line":311,"containerName":"alphabet","definition":"my","name":"$self","localvar":"my"},{"containerName":"alphabet","name":"$self","kind":13,"line":312},{"containerName":"alphabet","name":"throw_not_implemented","kind":12,"line":312}],"line":310,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n    # If you are a newcomer to bioperl, you might want to start with\n    # Bio::Seq documentation.\n\n    # Test if this is a seq object\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # Accessors\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id();       # for human display\n    $id        = $obj->primary_id();       # unique id for this object,\n                                           # implementation defined\n    $unique_key= $obj->accession_number(); # unique biological id\n\n\n    # Object manipulation\n    eval {\n\t   $rev = $obj->revcom();\n    };\n    if( $@ ) {\n\t   $obj->throw(\"Could not reverse complement. \".\n\t\t    \"Probably not DNA. Actual exception\\n$@\\n\");\n    }\n\n    $trunc = $obj->trunc(12,50);\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers-only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in L<Bio::PrimarySeq>. If you just want to\nuse L<Bio::PrimarySeq> objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\nThis interface defines what bioperl considers necessary to \"be\" a\nsequence, without providing an implementation of this, an\nimplementation is provided in L<Bio::PrimarySeq>. If you want to provide\na Bio::PrimarySeq-compliant object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inherit\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but implementations are suggested to\n           keep an open mind about case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, i.e. 1-2 are the first two\n           bases of the sequence.\n\n           Start cannot be larger than end but can be equal.\n\n Returns : A string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, also known as the common name of the Sequence\n           object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience reasons.\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: Can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called \"type\" because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : A string either 'dna','rna','protein'. NB - the object must\n           make a call of the alphabet, if there is no alphabet specified it\n           has to guess.\n Args    : None\n Status  : Virtual","label":"alphabet($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":313},"start":{"character":0,"line":310}},"name":"alphabet"},{"children":[{"kind":13,"line":323,"containerName":"moltype","name":"$self","definition":"my","localvar":"my"},{"containerName":"moltype","name":"@args","line":323,"kind":13},{"containerName":"moltype","name":"$self","line":325,"kind":13},{"containerName":"moltype","name":"warn","line":325,"kind":12},{"line":326,"kind":13,"containerName":"moltype","name":"$self"},{"containerName":"moltype","name":"alphabet","kind":12,"line":326},{"containerName":"moltype","name":"@args","line":326,"kind":13}],"line":322,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n    # If you are a newcomer to bioperl, you might want to start with\n    # Bio::Seq documentation.\n\n    # Test if this is a seq object\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # Accessors\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id();       # for human display\n    $id        = $obj->primary_id();       # unique id for this object,\n                                           # implementation defined\n    $unique_key= $obj->accession_number(); # unique biological id\n\n\n    # Object manipulation\n    eval {\n\t   $rev = $obj->revcom();\n    };\n    if( $@ ) {\n\t   $obj->throw(\"Could not reverse complement. \".\n\t\t    \"Probably not DNA. Actual exception\\n$@\\n\");\n    }\n\n    $trunc = $obj->trunc(12,50);\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers-only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in L<Bio::PrimarySeq>. If you just want to\nuse L<Bio::PrimarySeq> objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\nThis interface defines what bioperl considers necessary to \"be\" a\nsequence, without providing an implementation of this, an\nimplementation is provided in L<Bio::PrimarySeq>. If you want to provide\na Bio::PrimarySeq-compliant object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inherit\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but implementations are suggested to\n           keep an open mind about case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, i.e. 1-2 are the first two\n           bases of the sequence.\n\n           Start cannot be larger than end but can be equal.\n\n Returns : A string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, also known as the common name of the Sequence\n           object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience reasons.\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: Can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called \"type\" because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : A string either 'dna','rna','protein'. NB - the object must\n           make a call of the alphabet, if there is no alphabet specified it\n           has to guess.\n Args    : None\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 moltype\n\n Title   : moltype\n Usage   : Deprecated. Use alphabet() instead.","label":"moltype($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"start":{"line":322,"character":0},"end":{"character":9999,"line":327}},"name":"moltype"},{"line":373,"children":[{"line":374,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"revcom"},{"localvar":"my","containerName":"revcom","name":"$t","definition":"my","line":378,"kind":13},{"containerName":"revcom","name":"$self","line":378,"kind":13},{"containerName":"revcom","name":"alphabet","kind":12,"line":378},{"kind":13,"line":380,"name":"$t","containerName":"revcom"},{"kind":13,"line":381,"containerName":"revcom","name":"$self"},{"containerName":"revcom","name":"throw","kind":12,"line":381},{"kind":13,"line":384,"containerName":"revcom","name":"$t"},{"kind":13,"line":384,"name":"$t","containerName":"revcom"},{"line":385,"kind":13,"name":"$self","containerName":"revcom"},{"kind":12,"line":385,"containerName":"revcom","name":"can"},{"containerName":"revcom","name":"$self","kind":13,"line":386},{"kind":12,"line":386,"name":"warn","containerName":"revcom"},{"kind":13,"line":396,"name":"$str","definition":"my","containerName":"revcom","localvar":"my"},{"kind":13,"line":396,"name":"$self","containerName":"revcom"},{"kind":12,"line":396,"name":"seq","containerName":"revcom"},{"name":"$t","containerName":"revcom","kind":13,"line":400},{"kind":13,"line":401,"name":"$str","containerName":"revcom"},{"line":406,"kind":13,"name":"$str","containerName":"revcom"},{"kind":13,"line":407,"definition":"my","name":"$revseq","containerName":"revcom","localvar":"my"},{"kind":13,"line":407,"containerName":"revcom","name":"$str"},{"line":409,"kind":13,"containerName":"revcom","name":"$t"},{"line":410,"kind":13,"containerName":"revcom","name":"$revseq"},{"localvar":"my","name":"$seqclass","definition":"my","containerName":"revcom","line":413,"kind":13},{"kind":13,"line":414,"containerName":"revcom","name":"$self"},{"kind":12,"line":414,"name":"can_call_new","containerName":"revcom"},{"kind":13,"line":415,"containerName":"revcom","name":"$seqclass"},{"kind":13,"line":415,"containerName":"revcom","name":"$self"},{"kind":13,"line":417,"containerName":"revcom","name":"$seqclass"},{"name":"$self","containerName":"revcom","line":418,"kind":13},{"containerName":"revcom","name":"_attempt_to_load_Seq","line":418,"kind":12},{"line":420,"kind":13,"localvar":"my","containerName":"revcom","name":"$out","definition":"my"},{"line":420,"kind":13,"name":"$seqclass","containerName":"revcom"},{"kind":12,"line":420,"containerName":"revcom","name":"new"},{"line":420,"kind":13,"containerName":"revcom","name":"$revseq"},{"name":"$self","containerName":"revcom","line":421,"kind":13},{"line":421,"kind":12,"name":"is_circular","containerName":"revcom"},{"kind":13,"line":422,"name":"$self","containerName":"revcom"},{"name":"display_id","containerName":"revcom","line":422,"kind":12},{"containerName":"revcom","name":"$self","kind":13,"line":423},{"kind":12,"line":423,"containerName":"revcom","name":"accession_number"},{"kind":13,"line":424,"name":"$self","containerName":"revcom"},{"line":424,"kind":12,"name":"alphabet","containerName":"revcom"},{"line":425,"kind":13,"name":"$self","containerName":"revcom"},{"name":"desc","containerName":"revcom","line":425,"kind":12},{"containerName":"revcom","name":"$self","kind":13,"line":426},{"name":"verbose","containerName":"revcom","line":427,"kind":12},{"line":428,"kind":13,"containerName":"revcom","name":"$out"}],"kind":12,"detail":"($self)","signature":{"documentation":"1;\n# $Id: PrimarySeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n    # If you are a newcomer to bioperl, you might want to start with\n    # Bio::Seq documentation.\n\n    # Test if this is a seq object\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # Accessors\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id();       # for human display\n    $id        = $obj->primary_id();       # unique id for this object,\n                                           # implementation defined\n    $unique_key= $obj->accession_number(); # unique biological id\n\n\n    # Object manipulation\n    eval {\n\t   $rev = $obj->revcom();\n    };\n    if( $@ ) {\n\t   $obj->throw(\"Could not reverse complement. \".\n\t\t    \"Probably not DNA. Actual exception\\n$@\\n\");\n    }\n\n    $trunc = $obj->trunc(12,50);\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers-only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in L<Bio::PrimarySeq>. If you just want to\nuse L<Bio::PrimarySeq> objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\nThis interface defines what bioperl considers necessary to \"be\" a\nsequence, without providing an implementation of this, an\nimplementation is provided in L<Bio::PrimarySeq>. If you want to provide\na Bio::PrimarySeq-compliant object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inherit\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but implementations are suggested to\n           keep an open mind about case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, i.e. 1-2 are the first two\n           bases of the sequence.\n\n           Start cannot be larger than end but can be equal.\n\n Returns : A string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, also known as the common name of the Sequence\n           object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience reasons.\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: Can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called \"type\" because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : A string either 'dna','rna','protein'. NB - the object must\n           make a call of the alphabet, if there is no alphabet specified it\n           has to guess.\n Args    : None\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 moltype\n\n Title   : moltype\n Usage   : Deprecated. Use alphabet() instead.\n\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nThe revcom(), trunc(), and translate() methods create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\".\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensionsj.\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : None","parameters":[{"label":"$self"}],"label":"revcom($self)"},"containerName":"main::","definition":"sub","range":{"start":{"line":373,"character":0},"end":{"character":9999,"line":430}},"name":"revcom"},{"line":409,"kind":12,"containerName":"reverse","name":"CORE"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n    # If you are a newcomer to bioperl, you might want to start with\n    # Bio::Seq documentation.\n\n    # Test if this is a seq object\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # Accessors\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id();       # for human display\n    $id        = $obj->primary_id();       # unique id for this object,\n                                           # implementation defined\n    $unique_key= $obj->accession_number(); # unique biological id\n\n\n    # Object manipulation\n    eval {\n\t   $rev = $obj->revcom();\n    };\n    if( $@ ) {\n\t   $obj->throw(\"Could not reverse complement. \".\n\t\t    \"Probably not DNA. Actual exception\\n$@\\n\");\n    }\n\n    $trunc = $obj->trunc(12,50);\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers-only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in L<Bio::PrimarySeq>. If you just want to\nuse L<Bio::PrimarySeq> objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\nThis interface defines what bioperl considers necessary to \"be\" a\nsequence, without providing an implementation of this, an\nimplementation is provided in L<Bio::PrimarySeq>. If you want to provide\na Bio::PrimarySeq-compliant object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inherit\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but implementations are suggested to\n           keep an open mind about case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, i.e. 1-2 are the first two\n           bases of the sequence.\n\n           Start cannot be larger than end but can be equal.\n\n Returns : A string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, also known as the common name of the Sequence\n           object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience reasons.\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: Can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called \"type\" because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : A string either 'dna','rna','protein'. NB - the object must\n           make a call of the alphabet, if there is no alphabet specified it\n           has to guess.\n Args    : None\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 moltype\n\n Title   : moltype\n Usage   : Deprecated. Use alphabet() instead.\n\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nThe revcom(), trunc(), and translate() methods create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\".\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensionsj.\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : None\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(\"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-is_circular'  => $self->is_circular,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc(),\n                             '-verbose' => $self->verbose\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence.\n Returns : A fresh Bio::PrimarySeqI implementing object.\n Args    : Two integers denoting first and last base of the sub-sequence.","label":"trunc($self,$start,$end)"},"detail":"($self,$start,$end)","kind":12,"children":[{"kind":13,"line":444,"containerName":"trunc","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":444,"name":"$start","containerName":"trunc"},{"containerName":"trunc","name":"$end","line":444,"kind":13},{"line":446,"kind":13,"localvar":"my","definition":"my","name":"$str","containerName":"trunc"},{"containerName":"trunc","name":"$start","line":447,"kind":13},{"containerName":"trunc","name":"$start","line":447,"kind":13},{"line":448,"kind":13,"containerName":"trunc","name":"$start"},{"kind":12,"line":448,"name":"isa","containerName":"trunc"},{"kind":13,"line":449,"name":"$str","containerName":"trunc"},{"line":449,"kind":13,"name":"$self","containerName":"trunc"},{"containerName":"trunc","name":"subseq","kind":12,"line":449},{"line":449,"kind":13,"containerName":"trunc","name":"$start"},{"containerName":"trunc","name":"$end","line":450,"kind":13},{"kind":13,"line":451,"name":"$self","containerName":"trunc"},{"containerName":"trunc","name":"throw","line":451,"kind":12},{"line":452,"kind":13,"containerName":"trunc","name":"$end"},{"containerName":"trunc","name":"$start","kind":13,"line":452},{"kind":13,"line":453,"containerName":"trunc","definition":"my","name":"$msg","localvar":"my"},{"line":456,"kind":13,"name":"$self","containerName":"trunc"},{"containerName":"trunc","name":"throw","line":456,"kind":12},{"line":456,"kind":13,"containerName":"trunc","name":"$msg"},{"containerName":"trunc","name":"$str","line":458,"kind":13},{"containerName":"trunc","name":"$self","kind":13,"line":458},{"containerName":"trunc","name":"subseq","kind":12,"line":458},{"kind":13,"line":458,"name":"$start","containerName":"trunc"},{"containerName":"trunc","name":"$end","kind":13,"line":458},{"line":461,"kind":13,"localvar":"my","name":"$seqclass","definition":"my","containerName":"trunc"},{"kind":13,"line":462,"name":"$self","containerName":"trunc"},{"kind":12,"line":462,"containerName":"trunc","name":"can_call_new"},{"kind":13,"line":463,"name":"$seqclass","containerName":"trunc"},{"line":463,"kind":13,"name":"$self","containerName":"trunc"},{"kind":13,"line":465,"containerName":"trunc","name":"$seqclass"},{"kind":13,"line":466,"name":"$self","containerName":"trunc"},{"containerName":"trunc","name":"_attempt_to_load_Seq","kind":12,"line":466},{"name":"$out","definition":"my","containerName":"trunc","localvar":"my","kind":13,"line":469},{"kind":13,"line":469,"containerName":"trunc","name":"$seqclass"},{"name":"new","containerName":"trunc","kind":12,"line":469},{"containerName":"trunc","name":"$str","kind":13,"line":469},{"line":470,"kind":13,"containerName":"trunc","name":"$self"},{"name":"display_id","containerName":"trunc","line":470,"kind":12},{"kind":13,"line":471,"containerName":"trunc","name":"$self"},{"containerName":"trunc","name":"accession_number","kind":12,"line":471},{"kind":13,"line":472,"name":"$self","containerName":"trunc"},{"name":"alphabet","containerName":"trunc","line":472,"kind":12},{"line":473,"kind":13,"containerName":"trunc","name":"$self"},{"containerName":"trunc","name":"desc","kind":12,"line":473},{"containerName":"trunc","name":"$self","kind":13,"line":474},{"containerName":"trunc","name":"verbose","line":475,"kind":12},{"line":476,"kind":13,"containerName":"trunc","name":"$out"}],"line":443,"name":"trunc","range":{"end":{"line":477,"character":9999},"start":{"line":443,"character":0}}},{"range":{"start":{"line":550,"character":0},"end":{"line":670,"character":9999}},"name":"translate","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n    # If you are a newcomer to bioperl, you might want to start with\n    # Bio::Seq documentation.\n\n    # Test if this is a seq object\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # Accessors\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id();       # for human display\n    $id        = $obj->primary_id();       # unique id for this object,\n                                           # implementation defined\n    $unique_key= $obj->accession_number(); # unique biological id\n\n\n    # Object manipulation\n    eval {\n\t   $rev = $obj->revcom();\n    };\n    if( $@ ) {\n\t   $obj->throw(\"Could not reverse complement. \".\n\t\t    \"Probably not DNA. Actual exception\\n$@\\n\");\n    }\n\n    $trunc = $obj->trunc(12,50);\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers-only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in L<Bio::PrimarySeq>. If you just want to\nuse L<Bio::PrimarySeq> objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\nThis interface defines what bioperl considers necessary to \"be\" a\nsequence, without providing an implementation of this, an\nimplementation is provided in L<Bio::PrimarySeq>. If you want to provide\na Bio::PrimarySeq-compliant object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inherit\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but implementations are suggested to\n           keep an open mind about case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, i.e. 1-2 are the first two\n           bases of the sequence.\n\n           Start cannot be larger than end but can be equal.\n\n Returns : A string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, also known as the common name of the Sequence\n           object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience reasons.\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: Can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called \"type\" because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : A string either 'dna','rna','protein'. NB - the object must\n           make a call of the alphabet, if there is no alphabet specified it\n           has to guess.\n Args    : None\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 moltype\n\n Title   : moltype\n Usage   : Deprecated. Use alphabet() instead.\n\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nThe revcom(), trunc(), and translate() methods create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\".\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensionsj.\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : None\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(\"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-is_circular'  => $self->is_circular,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc(),\n                             '-verbose' => $self->verbose\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence.\n Returns : A fresh Bio::PrimarySeqI implementing object.\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc{\n   my ($self,$start,$end) = @_;\n\n   my $str;\n   if( defined $start && ref($start) &&\n       $start->isa('Bio::LocationI') ) {\n       $str = $self->subseq($start); # start is a location actually\n   } elsif( !$end ) {\n       $self->throw(\"trunc start,end -- there was no end for $start\");\n   } elsif( $end < $start ) {\n       my $msg = \"start [$start] is greater than end [$end]. \\n\".\n\t   \"If you want to truncated and reverse complement, \\n\".\n\t       \"you must call trunc followed by revcom. Sorry.\";\n       $self->throw($msg);\n   } else {\n       $str = $self->subseq($start,$end);\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n\n   my $out = $seqclass->new( '-seq' => $str,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc(),\n                             '-verbose' => $self->verbose\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate\n\n Title   : translate\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n\n           Or if you expect a complete coding sequence (CDS) translation,\n           with inititator at the beginning and terminator at the end:\n\n           $protein_seq_obj = $cds_seq_obj->translate(-complete => 1);\n\n           Or if you want translate() to find the first initiation\n           codon and return the corresponding protein:\n\n           $protein_seq_obj = $cds_seq_obj->translate(-orf => 1);\n\n Function: Provides the translation of the DNA sequence using full\n           IUPAC ambiguities in DNA/RNA and amino acid codes.\n\n           The complete CDS translation is identical to EMBL/TREMBL\n           database translation. Note that the trailing terminator\n           character is removed before returning the translated protein\n           object.\n\n           Note: if you set $dna_seq_obj->verbose(1) you will get a\n           warning if the first codon is not a valid initiator.\n\n Returns : A Bio::PrimarySeqI implementing object\n Args    : -terminator    - character for terminator        default is *\n           -unknown       - character for unknown           default is X\n           -frame         - frame                           default is 0\n           -codontable_id - codon table id                  default is 1\n           -complete      - complete CDS expected           default is 0\n           -throw         - throw exception if not complete default is 0\n           -orf           - find 1st ORF                    default is 0\n           -start         - alternative initiation codon\n           -codontable    - Bio::Tools::CodonTable object\n\t\t   -offset        - offset for fuzzy locations      default is 0\n\n Notes   : The -start argument only applies when -orf is set to 1. By default\n           all initiation codons found in the given codon table are used\n           but when \"start\" is set to some codon this codon will be used\n           exclusively as the initiation codon. Note that the default codon\n           table (NCBI \"Standard\") has 3 initiation codons!\n\n           By default translate() translates termination codons to\n           the some character (default is *), both internal and trailing\n           codons. Setting \"-complete\" to 1 tells translate() to remove\n           the trailing character.\n\n\t\t   -offset is used for seqfeatures which contain the the \\codon_start\n\t\t   tag and can be set to 1, 2, or 3.  This is the offset by which the\n\t\t   sequence translation starts relative to the first base of the\n\t\t   feature\n\nFor details on codon tables used by translate() see L<Bio::Tools::CodonTable>.\n\n           Deprecated argument set (v. 1.5.1 and prior versions)\n           where each argument is an element in an array:\n\n           1: character for terminator (optional), defaults to '*'.\n           2: character for unknown amino acid (optional), defaults to 'X'.\n           3: frame (optional), valid values are 0, 1, 2, defaults to 0.\n           4: codon table id (optional), defaults to 1.\n           5: complete coding sequence expected, defaults to 0 (false).\n           6: boolean, throw exception if not complete coding sequence\n              (true), defaults to warning (false)\n           7: codontable, a custom Bio::Tools::CodonTable object (optional).","label":"translate($self,@args)"},"containerName":"main::","definition":"sub","line":550,"children":[{"containerName":"translate","definition":"my","name":"$self","localvar":"my","kind":13,"line":551},{"line":551,"kind":13,"containerName":"translate","name":"@args"},{"line":552,"kind":13,"localvar":"my","containerName":"translate","definition":"my","name":"$terminator"},{"line":552,"kind":13,"containerName":"translate","name":"$unknown"},{"name":"$frame","containerName":"translate","kind":13,"line":552},{"kind":13,"line":552,"name":"$codonTableId","containerName":"translate"},{"line":552,"kind":13,"name":"$complete","containerName":"translate"},{"name":"$throw","containerName":"translate","line":552,"kind":13},{"name":"$codonTable","containerName":"translate","line":553,"kind":13},{"line":553,"kind":13,"name":"$orf","containerName":"translate"},{"name":"$start_codon","containerName":"translate","kind":13,"line":553},{"line":553,"kind":13,"containerName":"translate","name":"$offset"},{"name":"$args","containerName":"translate","line":556,"kind":13},{"containerName":"translate","name":"$args","kind":13,"line":556},{"name":"$terminator","containerName":"translate","kind":13,"line":557},{"line":557,"kind":13,"containerName":"translate","name":"$unknown"},{"containerName":"translate","name":"$frame","line":557,"kind":13},{"name":"$codonTableId","containerName":"translate","kind":13,"line":557},{"kind":13,"line":557,"containerName":"translate","name":"$complete"},{"name":"$throw","containerName":"translate","kind":13,"line":557},{"kind":13,"line":558,"name":"$codonTable","containerName":"translate"},{"line":558,"kind":13,"containerName":"translate","name":"$orf"},{"kind":13,"line":558,"name":"$start_codon","containerName":"translate"},{"kind":13,"line":558,"containerName":"translate","name":"$offset"},{"line":559,"kind":13,"containerName":"translate","name":"$self"},{"name":"_rearrange","containerName":"translate","kind":12,"line":559},{"kind":13,"line":568,"name":"@args","containerName":"translate"},{"containerName":"translate","name":"$terminator","kind":13,"line":571},{"line":571,"kind":13,"containerName":"translate","name":"$unknown"},{"containerName":"translate","name":"$frame","kind":13,"line":571},{"line":571,"kind":13,"name":"$codonTableId","containerName":"translate"},{"line":572,"kind":13,"name":"$complete","containerName":"translate"},{"kind":13,"line":572,"name":"$throw","containerName":"translate"},{"line":572,"kind":13,"name":"$codonTable","containerName":"translate"},{"name":"$offset","containerName":"translate","line":572,"kind":13},{"line":572,"kind":13,"name":"@args","containerName":"translate"},{"name":"$terminator","containerName":"translate","kind":13,"line":576},{"line":576,"kind":13,"containerName":"translate","name":"$terminator"},{"name":"$terminator","containerName":"translate","kind":13,"line":576},{"containerName":"translate","name":"$unknown","kind":13,"line":577},{"line":577,"kind":13,"name":"$unknown","containerName":"translate"},{"line":577,"kind":13,"containerName":"translate","name":"$unknown"},{"containerName":"translate","name":"$frame","kind":13,"line":578},{"line":578,"kind":13,"name":"$frame","containerName":"translate"},{"kind":13,"line":578,"containerName":"translate","name":"$frame"},{"containerName":"translate","name":"$codonTableId","kind":13,"line":579},{"name":"$codonTableId","containerName":"translate","line":579,"kind":13},{"name":"$codonTableId","containerName":"translate","kind":13,"line":579},{"kind":13,"line":582,"name":"$codonTable","containerName":"translate"},{"name":"$self","containerName":"translate","line":583,"kind":13},{"name":"throw","containerName":"translate","line":583,"kind":12},{"name":"$codonTable","containerName":"translate","line":583,"kind":13},{"name":"$codonTable","containerName":"translate","line":584,"kind":13},{"name":"isa","containerName":"translate","kind":12,"line":584},{"containerName":"translate","name":"$codonTable","kind":13,"line":586},{"kind":12,"line":586,"name":"new","containerName":"translate"},{"name":"$codonTableId","containerName":"translate","line":586,"kind":13},{"kind":13,"line":590,"name":"$self","containerName":"translate"},{"name":"throw","containerName":"translate","line":590,"kind":12},{"kind":13,"line":591,"name":"$self","containerName":"translate"},{"containerName":"translate","name":"alphabet","line":591,"kind":12},{"name":"$start_codon","containerName":"translate","kind":13,"line":594},{"containerName":"translate","name":"$self","line":595,"kind":13},{"containerName":"translate","name":"throw","line":595,"kind":12},{"name":"$start_codon","containerName":"translate","kind":13,"line":596},{"localvar":"my","name":"$seq","definition":"my","containerName":"translate","line":599,"kind":13},{"kind":13,"line":601,"containerName":"translate","name":"$offset"},{"kind":13,"line":602,"name":"$self","containerName":"translate"},{"line":602,"kind":12,"containerName":"translate","name":"throw"},{"kind":13,"line":603,"containerName":"translate","name":"$offset"},{"definition":"my","name":"$start","containerName":"translate","localvar":"my","kind":13,"line":604},{"line":604,"kind":13,"name":"$end","containerName":"translate"},{"containerName":"translate","name":"$offset","line":604,"kind":13},{"kind":13,"line":604,"containerName":"translate","name":"$self"},{"line":604,"kind":12,"name":"length","containerName":"translate"},{"kind":13,"line":605,"name":"$seq","containerName":"translate"},{"containerName":"translate","name":"$self","line":605,"kind":13},{"containerName":"translate","name":"subseq","line":605,"kind":12},{"kind":13,"line":605,"name":"$start","containerName":"translate"},{"kind":13,"line":605,"name":"$end","containerName":"translate"},{"name":"$seq","containerName":"translate","line":607,"kind":13},{"containerName":"translate","name":"$self","line":607,"kind":13},{"kind":12,"line":607,"containerName":"translate","name":"seq"},{"containerName":"translate","name":"$orf","kind":13,"line":611},{"name":"$seq","containerName":"translate","line":612,"kind":13},{"name":"$self","containerName":"translate","kind":13,"line":612},{"line":612,"kind":12,"name":"_find_orf","containerName":"translate"},{"containerName":"translate","name":"$seq","line":612,"kind":13},{"containerName":"translate","name":"$codonTable","line":612,"kind":13},{"line":612,"kind":13,"containerName":"translate","name":"$start_codon"},{"kind":13,"line":615,"name":"$self","containerName":"translate"},{"name":"throw","containerName":"translate","line":615,"kind":12},{"containerName":"translate","name":"$frame","line":616,"kind":13},{"line":616,"kind":13,"name":"$frame","containerName":"translate"},{"name":"$frame","containerName":"translate","kind":13,"line":616},{"kind":13,"line":617,"containerName":"translate","name":"$seq"},{"line":617,"kind":13,"name":"$seq","containerName":"translate"},{"containerName":"translate","name":"$frame","kind":13,"line":617},{"localvar":"my","containerName":"translate","name":"$output","definition":"my","line":621,"kind":13},{"line":621,"kind":13,"containerName":"translate","name":"$codonTable"},{"line":621,"kind":12,"name":"translate","containerName":"translate"},{"name":"$seq","containerName":"translate","kind":13,"line":621},{"name":"$output","containerName":"translate","kind":13,"line":623},{"line":624,"kind":13,"name":"$output","containerName":"translate"},{"line":627,"kind":13,"name":"$complete","containerName":"translate"},{"definition":"my","name":"$id","containerName":"translate","localvar":"my","kind":13,"line":628},{"containerName":"translate","name":"$self","line":628,"kind":13},{"containerName":"translate","name":"display_id","kind":12,"line":628},{"line":630,"kind":13,"name":"$output","containerName":"translate"},{"containerName":"translate","name":"$terminator","kind":13,"line":630},{"name":"$output","containerName":"translate","line":631,"kind":13},{"containerName":"translate","name":"$throw","kind":13,"line":633},{"kind":13,"line":633,"name":"$self","containerName":"translate"},{"line":633,"kind":12,"name":"throw","containerName":"translate"},{"kind":13,"line":634,"name":"$self","containerName":"translate"},{"kind":12,"line":634,"containerName":"translate","name":"warn"},{"line":637,"kind":13,"name":"$output","containerName":"translate"},{"name":"$throw","containerName":"translate","line":638,"kind":13},{"name":"$self","containerName":"translate","kind":13,"line":638},{"line":638,"kind":12,"containerName":"translate","name":"throw"},{"containerName":"translate","name":"$self","kind":13,"line":639},{"name":"warn","containerName":"translate","kind":12,"line":639},{"name":"$output","containerName":"translate","line":642,"kind":13},{"name":"$codonTable","containerName":"translate","kind":13,"line":643},{"containerName":"translate","name":"is_start_codon","kind":12,"line":643},{"line":643,"kind":13,"containerName":"translate","name":"$seq"},{"name":"$output","containerName":"translate","line":644,"kind":13},{"line":644,"kind":13,"name":"$output","containerName":"translate"},{"containerName":"translate","name":"$throw","line":645,"kind":13},{"name":"$self","containerName":"translate","line":646,"kind":13},{"containerName":"translate","name":"throw","line":646,"kind":12},{"name":"$self","containerName":"translate","kind":13,"line":648},{"kind":12,"line":648,"containerName":"translate","name":"warn"},{"localvar":"my","name":"$seqclass","definition":"my","containerName":"translate","line":653,"kind":13},{"containerName":"translate","name":"$self","kind":13,"line":654},{"line":654,"kind":12,"name":"can_call_new","containerName":"translate"},{"name":"$seqclass","containerName":"translate","kind":13,"line":655},{"name":"$self","containerName":"translate","line":655,"kind":13},{"name":"$seqclass","containerName":"translate","line":657,"kind":13},{"containerName":"translate","name":"$self","kind":13,"line":658},{"line":658,"kind":12,"containerName":"translate","name":"_attempt_to_load_Seq"},{"kind":13,"line":660,"definition":"my","name":"$out","containerName":"translate","localvar":"my"},{"name":"$seqclass","containerName":"translate","line":660,"kind":13},{"kind":12,"line":660,"containerName":"translate","name":"new"},{"containerName":"translate","name":"$output","line":660,"kind":13},{"name":"$self","containerName":"translate","line":661,"kind":13},{"line":661,"kind":12,"name":"display_id","containerName":"translate"},{"name":"$self","containerName":"translate","kind":13,"line":662},{"line":662,"kind":12,"name":"accession_number","containerName":"translate"},{"line":665,"kind":13,"name":"$self","containerName":"translate"},{"line":665,"kind":12,"containerName":"translate","name":"desc"},{"name":"$self","containerName":"translate","kind":13,"line":667},{"line":668,"kind":12,"containerName":"translate","name":"verbose"},{"name":"$out","containerName":"translate","kind":13,"line":669}],"kind":12},{"name":"Bio","containerName":"Tools::CodonTable","kind":12,"line":586},{"range":{"start":{"line":683,"character":0},"end":{"character":9999,"line":687}},"name":"id","children":[{"containerName":"id","name":"$self","definition":"my","localvar":"my","kind":13,"line":684},{"line":686,"kind":13,"containerName":"id","name":"$self"},{"line":686,"kind":12,"name":"display_id","containerName":"id"}],"line":683,"kind":12,"signature":{"label":"id($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n    # If you are a newcomer to bioperl, you might want to start with\n    # Bio::Seq documentation.\n\n    # Test if this is a seq object\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # Accessors\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id();       # for human display\n    $id        = $obj->primary_id();       # unique id for this object,\n                                           # implementation defined\n    $unique_key= $obj->accession_number(); # unique biological id\n\n\n    # Object manipulation\n    eval {\n\t   $rev = $obj->revcom();\n    };\n    if( $@ ) {\n\t   $obj->throw(\"Could not reverse complement. \".\n\t\t    \"Probably not DNA. Actual exception\\n$@\\n\");\n    }\n\n    $trunc = $obj->trunc(12,50);\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers-only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in L<Bio::PrimarySeq>. If you just want to\nuse L<Bio::PrimarySeq> objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\nThis interface defines what bioperl considers necessary to \"be\" a\nsequence, without providing an implementation of this, an\nimplementation is provided in L<Bio::PrimarySeq>. If you want to provide\na Bio::PrimarySeq-compliant object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inherit\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but implementations are suggested to\n           keep an open mind about case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, i.e. 1-2 are the first two\n           bases of the sequence.\n\n           Start cannot be larger than end but can be equal.\n\n Returns : A string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, also known as the common name of the Sequence\n           object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience reasons.\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: Can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called \"type\" because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : A string either 'dna','rna','protein'. NB - the object must\n           make a call of the alphabet, if there is no alphabet specified it\n           has to guess.\n Args    : None\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 moltype\n\n Title   : moltype\n Usage   : Deprecated. Use alphabet() instead.\n\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nThe revcom(), trunc(), and translate() methods create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\".\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensionsj.\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : None\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(\"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-is_circular'  => $self->is_circular,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc(),\n                             '-verbose' => $self->verbose\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence.\n Returns : A fresh Bio::PrimarySeqI implementing object.\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc{\n   my ($self,$start,$end) = @_;\n\n   my $str;\n   if( defined $start && ref($start) &&\n       $start->isa('Bio::LocationI') ) {\n       $str = $self->subseq($start); # start is a location actually\n   } elsif( !$end ) {\n       $self->throw(\"trunc start,end -- there was no end for $start\");\n   } elsif( $end < $start ) {\n       my $msg = \"start [$start] is greater than end [$end]. \\n\".\n\t   \"If you want to truncated and reverse complement, \\n\".\n\t       \"you must call trunc followed by revcom. Sorry.\";\n       $self->throw($msg);\n   } else {\n       $str = $self->subseq($start,$end);\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n\n   my $out = $seqclass->new( '-seq' => $str,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc(),\n                             '-verbose' => $self->verbose\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate\n\n Title   : translate\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n\n           Or if you expect a complete coding sequence (CDS) translation,\n           with inititator at the beginning and terminator at the end:\n\n           $protein_seq_obj = $cds_seq_obj->translate(-complete => 1);\n\n           Or if you want translate() to find the first initiation\n           codon and return the corresponding protein:\n\n           $protein_seq_obj = $cds_seq_obj->translate(-orf => 1);\n\n Function: Provides the translation of the DNA sequence using full\n           IUPAC ambiguities in DNA/RNA and amino acid codes.\n\n           The complete CDS translation is identical to EMBL/TREMBL\n           database translation. Note that the trailing terminator\n           character is removed before returning the translated protein\n           object.\n\n           Note: if you set $dna_seq_obj->verbose(1) you will get a\n           warning if the first codon is not a valid initiator.\n\n Returns : A Bio::PrimarySeqI implementing object\n Args    : -terminator    - character for terminator        default is *\n           -unknown       - character for unknown           default is X\n           -frame         - frame                           default is 0\n           -codontable_id - codon table id                  default is 1\n           -complete      - complete CDS expected           default is 0\n           -throw         - throw exception if not complete default is 0\n           -orf           - find 1st ORF                    default is 0\n           -start         - alternative initiation codon\n           -codontable    - Bio::Tools::CodonTable object\n\t\t   -offset        - offset for fuzzy locations      default is 0\n\n Notes   : The -start argument only applies when -orf is set to 1. By default\n           all initiation codons found in the given codon table are used\n           but when \"start\" is set to some codon this codon will be used\n           exclusively as the initiation codon. Note that the default codon\n           table (NCBI \"Standard\") has 3 initiation codons!\n\n           By default translate() translates termination codons to\n           the some character (default is *), both internal and trailing\n           codons. Setting \"-complete\" to 1 tells translate() to remove\n           the trailing character.\n\n\t\t   -offset is used for seqfeatures which contain the the \\codon_start\n\t\t   tag and can be set to 1, 2, or 3.  This is the offset by which the\n\t\t   sequence translation starts relative to the first base of the\n\t\t   feature\n\nFor details on codon tables used by translate() see L<Bio::Tools::CodonTable>.\n\n           Deprecated argument set (v. 1.5.1 and prior versions)\n           where each argument is an element in an array:\n\n           1: character for terminator (optional), defaults to '*'.\n           2: character for unknown amino acid (optional), defaults to 'X'.\n           3: frame (optional), valid values are 0, 1, 2, defaults to 0.\n           4: codon table id (optional), defaults to 1.\n           5: complete coding sequence expected, defaults to 0 (false).\n           6: boolean, throw exception if not complete coding sequence\n              (true), defaults to warning (false)\n           7: codontable, a custom Bio::Tools::CodonTable object (optional).\n\n\nsub translate {\n\t my ($self,@args) = @_;\n\t my ($terminator, $unknown, $frame, $codonTableId, $complete, $throw,\n\t\t  $codonTable, $orf, $start_codon, $offset);\n\n\t ## new API with named parameters, post 1.5.1\n\t if ($args[0] && $args[0] =~ /^-[A-Z]+/i) {\n\t\t ($terminator, $unknown, $frame, $codonTableId, $complete, $throw,\n\t\t  $codonTable, $orf, $start_codon, $offset) =\n\t\t\t $self->_rearrange([qw(TERMINATOR\n\t\t\t\t\t\t\t\tUNKNOWN\n\t\t\t\t\t\t\t\tFRAME\n\t\t\t\t\t\t\t\tCODONTABLE_ID\n\t\t\t\t\t\t\t\tCOMPLETE\n\t\t\t\t\t\t\t\tTHROW\n\t\t\t\t\t\t\t\tCODONTABLE\n\t\t\t\t\t\t\t\tORF\n\t\t\t\t\t\t\t\tSTART\n\t\t\t\t\t\t\t\tOFFSET)], @args);\n\t ## old API, 1.5.1 and preceding versions\n\t } else {\n\t\t ($terminator, $unknown, $frame, $codonTableId,\n\t\t  $complete, $throw, $codonTable, $offset) = @args;\n\t }\n\n    ## Initialize termination codon, unknown codon, codon table id, frame\n    $terminator = '*'    unless (defined($terminator) and $terminator ne '');\n    $unknown = \"X\"       unless (defined($unknown) and $unknown ne '');\n    $frame = 0           unless (defined($frame) and $frame ne '');\n    $codonTableId = 1    unless (defined($codonTableId) and $codonTableId ne '');\n\n    ## Get a CodonTable, error if custom CodonTable is invalid\n    if ($codonTable) {\n\t\t $self->throw(\"Need a Bio::Tools::CodonTable object, not \". $codonTable)\n\t\t\tunless $codonTable->isa('Bio::Tools::CodonTable');\n    } else {\n\t\t $codonTable = Bio::Tools::CodonTable->new( -id => $codonTableId);\n\t }\n\n    ## Error if alphabet is \"protein\"\n    $self->throw(\"Can't translate an amino acid sequence.\") if\n\t\t($self->alphabet =~ /protein/i);\n\n    ## Error if -start parameter isn't a valid codon\n\t if ($start_codon) {\n\t\t $self->throw(\"Invalid start codon: $start_codon.\") if\n\t\t\t( $start_codon !~ /^[A-Z]{3}$/i );\n\t }\n\t \n\t my $seq;\n\t \n\t if ($offset) {\n\t\t$self->throw(\"Offset must be 1, 2, or 3.\") if\n\t\t    ( $offset !~ /^[123]$/ );\n\t\tmy ($start, $end) = ($offset, $self->length);\n\t\t($seq) = $self->subseq($start, $end);\n\t } else {\n\t\t($seq) = $self->seq();\n\t }\n\n    ## ignore frame if an ORF is supposed to be found\n\t if ($orf) {\n\t\t $seq = $self->_find_orf($seq,$codonTable,$start_codon);\n\t } else {\n\t ## use frame, error if frame is not 0, 1 or 2\n\t\t $self->throw(\"Valid values for frame are 0, 1, or 2, not $frame.\")\n\t\t\tunless ($frame == 0 or $frame == 1 or $frame == 2);\n\t\t $seq = substr($seq,$frame);\n    }\n\n    ## Translate it\n    my $output = $codonTable->translate($seq);\n    # Use user-input terminator/unknown\n    $output =~ s/\\*/$terminator/g;\n    $output =~ s/X/$unknown/g;\n\n    ## Only if we are expecting to translate a complete coding region\n    if ($complete) {\n\t\t my $id = $self->display_id;\n\t\t # remove the terminator character\n\t\t if( substr($output,-1,1) eq $terminator ) {\n\t\t\t chop $output;\n\t\t } else {\n\t\t\t $throw && $self->throw(\"Seq [$id]: Not using a valid terminator codon!\");\n\t\t\t $self->warn(\"Seq [$id]: Not using a valid terminator codon!\");\n\t\t }\n\t\t # test if there are terminator characters inside the protein sequence!\n\t\t if ($output =~ /\\*/) {\n\t\t\t $throw && $self->throw(\"Seq [$id]: Terminator codon inside CDS!\");\n\t\t\t $self->warn(\"Seq [$id]: Terminator codon inside CDS!\");\n\t\t }\n\t\t # if the initiator codon is not ATG, the amino acid needs to be changed to M\n\t\t if ( substr($output,0,1) ne 'M' ) {\n\t\t\t if ($codonTable->is_start_codon(substr($seq, 0, 3)) ) {\n\t\t\t\t $output = 'M'. substr($output,1);\n\t\t\t }\telsif ($throw) {\n\t\t\t\t $self->throw(\"Seq [$id]: Not using a valid initiator codon!\");\n\t\t\t } else {\n\t\t\t\t $self->warn(\"Seq [$id]: Not using a valid initiator codon!\");\n\t\t\t }\n\t\t }\n    }\n\n    my $seqclass;\n    if ($self->can_call_new()) {\n\t\t $seqclass = ref($self);\n    } else {\n\t\t $seqclass = 'Bio::PrimarySeq';\n\t\t $self->_attempt_to_load_Seq();\n    }\n    my $out = $seqclass->new( '-seq' => $output,\n\t\t\t\t\t\t\t\t\t\t'-display_id'  => $self->display_id,\n\t\t\t\t\t\t\t\t\t\t'-accession_number' => $self->accession_number,\n\t\t\t\t\t\t\t\t\t\t# is there anything wrong with retaining the\n\t\t\t\t\t\t\t\t\t\t# description?\n\t\t\t\t\t\t\t\t\t\t'-desc' => $self->desc(),\n\t\t\t\t\t\t\t\t\t\t'-alphabet' => 'protein',\n                              '-verbose' => $self->verbose\n\t\t\t      );\n    return $out;\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: ID of the sequence. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Returns : A string.\n Args    :"},"detail":"($self)","definition":"sub","containerName":"main::"},{"name":"length","range":{"end":{"line":703,"character":9999},"start":{"line":700,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"length($self)","documentation":"1;\n# $Id: PrimarySeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n    # If you are a newcomer to bioperl, you might want to start with\n    # Bio::Seq documentation.\n\n    # Test if this is a seq object\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # Accessors\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id();       # for human display\n    $id        = $obj->primary_id();       # unique id for this object,\n                                           # implementation defined\n    $unique_key= $obj->accession_number(); # unique biological id\n\n\n    # Object manipulation\n    eval {\n\t   $rev = $obj->revcom();\n    };\n    if( $@ ) {\n\t   $obj->throw(\"Could not reverse complement. \".\n\t\t    \"Probably not DNA. Actual exception\\n$@\\n\");\n    }\n\n    $trunc = $obj->trunc(12,50);\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers-only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in L<Bio::PrimarySeq>. If you just want to\nuse L<Bio::PrimarySeq> objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\nThis interface defines what bioperl considers necessary to \"be\" a\nsequence, without providing an implementation of this, an\nimplementation is provided in L<Bio::PrimarySeq>. If you want to provide\na Bio::PrimarySeq-compliant object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inherit\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but implementations are suggested to\n           keep an open mind about case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, i.e. 1-2 are the first two\n           bases of the sequence.\n\n           Start cannot be larger than end but can be equal.\n\n Returns : A string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, also known as the common name of the Sequence\n           object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience reasons.\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: Can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called \"type\" because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : A string either 'dna','rna','protein'. NB - the object must\n           make a call of the alphabet, if there is no alphabet specified it\n           has to guess.\n Args    : None\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 moltype\n\n Title   : moltype\n Usage   : Deprecated. Use alphabet() instead.\n\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nThe revcom(), trunc(), and translate() methods create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\".\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensionsj.\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : None\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(\"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-is_circular'  => $self->is_circular,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc(),\n                             '-verbose' => $self->verbose\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence.\n Returns : A fresh Bio::PrimarySeqI implementing object.\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc{\n   my ($self,$start,$end) = @_;\n\n   my $str;\n   if( defined $start && ref($start) &&\n       $start->isa('Bio::LocationI') ) {\n       $str = $self->subseq($start); # start is a location actually\n   } elsif( !$end ) {\n       $self->throw(\"trunc start,end -- there was no end for $start\");\n   } elsif( $end < $start ) {\n       my $msg = \"start [$start] is greater than end [$end]. \\n\".\n\t   \"If you want to truncated and reverse complement, \\n\".\n\t       \"you must call trunc followed by revcom. Sorry.\";\n       $self->throw($msg);\n   } else {\n       $str = $self->subseq($start,$end);\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n\n   my $out = $seqclass->new( '-seq' => $str,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc(),\n                             '-verbose' => $self->verbose\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate\n\n Title   : translate\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n\n           Or if you expect a complete coding sequence (CDS) translation,\n           with inititator at the beginning and terminator at the end:\n\n           $protein_seq_obj = $cds_seq_obj->translate(-complete => 1);\n\n           Or if you want translate() to find the first initiation\n           codon and return the corresponding protein:\n\n           $protein_seq_obj = $cds_seq_obj->translate(-orf => 1);\n\n Function: Provides the translation of the DNA sequence using full\n           IUPAC ambiguities in DNA/RNA and amino acid codes.\n\n           The complete CDS translation is identical to EMBL/TREMBL\n           database translation. Note that the trailing terminator\n           character is removed before returning the translated protein\n           object.\n\n           Note: if you set $dna_seq_obj->verbose(1) you will get a\n           warning if the first codon is not a valid initiator.\n\n Returns : A Bio::PrimarySeqI implementing object\n Args    : -terminator    - character for terminator        default is *\n           -unknown       - character for unknown           default is X\n           -frame         - frame                           default is 0\n           -codontable_id - codon table id                  default is 1\n           -complete      - complete CDS expected           default is 0\n           -throw         - throw exception if not complete default is 0\n           -orf           - find 1st ORF                    default is 0\n           -start         - alternative initiation codon\n           -codontable    - Bio::Tools::CodonTable object\n\t\t   -offset        - offset for fuzzy locations      default is 0\n\n Notes   : The -start argument only applies when -orf is set to 1. By default\n           all initiation codons found in the given codon table are used\n           but when \"start\" is set to some codon this codon will be used\n           exclusively as the initiation codon. Note that the default codon\n           table (NCBI \"Standard\") has 3 initiation codons!\n\n           By default translate() translates termination codons to\n           the some character (default is *), both internal and trailing\n           codons. Setting \"-complete\" to 1 tells translate() to remove\n           the trailing character.\n\n\t\t   -offset is used for seqfeatures which contain the the \\codon_start\n\t\t   tag and can be set to 1, 2, or 3.  This is the offset by which the\n\t\t   sequence translation starts relative to the first base of the\n\t\t   feature\n\nFor details on codon tables used by translate() see L<Bio::Tools::CodonTable>.\n\n           Deprecated argument set (v. 1.5.1 and prior versions)\n           where each argument is an element in an array:\n\n           1: character for terminator (optional), defaults to '*'.\n           2: character for unknown amino acid (optional), defaults to 'X'.\n           3: frame (optional), valid values are 0, 1, 2, defaults to 0.\n           4: codon table id (optional), defaults to 1.\n           5: complete coding sequence expected, defaults to 0 (false).\n           6: boolean, throw exception if not complete coding sequence\n              (true), defaults to warning (false)\n           7: codontable, a custom Bio::Tools::CodonTable object (optional).\n\n\nsub translate {\n\t my ($self,@args) = @_;\n\t my ($terminator, $unknown, $frame, $codonTableId, $complete, $throw,\n\t\t  $codonTable, $orf, $start_codon, $offset);\n\n\t ## new API with named parameters, post 1.5.1\n\t if ($args[0] && $args[0] =~ /^-[A-Z]+/i) {\n\t\t ($terminator, $unknown, $frame, $codonTableId, $complete, $throw,\n\t\t  $codonTable, $orf, $start_codon, $offset) =\n\t\t\t $self->_rearrange([qw(TERMINATOR\n\t\t\t\t\t\t\t\tUNKNOWN\n\t\t\t\t\t\t\t\tFRAME\n\t\t\t\t\t\t\t\tCODONTABLE_ID\n\t\t\t\t\t\t\t\tCOMPLETE\n\t\t\t\t\t\t\t\tTHROW\n\t\t\t\t\t\t\t\tCODONTABLE\n\t\t\t\t\t\t\t\tORF\n\t\t\t\t\t\t\t\tSTART\n\t\t\t\t\t\t\t\tOFFSET)], @args);\n\t ## old API, 1.5.1 and preceding versions\n\t } else {\n\t\t ($terminator, $unknown, $frame, $codonTableId,\n\t\t  $complete, $throw, $codonTable, $offset) = @args;\n\t }\n\n    ## Initialize termination codon, unknown codon, codon table id, frame\n    $terminator = '*'    unless (defined($terminator) and $terminator ne '');\n    $unknown = \"X\"       unless (defined($unknown) and $unknown ne '');\n    $frame = 0           unless (defined($frame) and $frame ne '');\n    $codonTableId = 1    unless (defined($codonTableId) and $codonTableId ne '');\n\n    ## Get a CodonTable, error if custom CodonTable is invalid\n    if ($codonTable) {\n\t\t $self->throw(\"Need a Bio::Tools::CodonTable object, not \". $codonTable)\n\t\t\tunless $codonTable->isa('Bio::Tools::CodonTable');\n    } else {\n\t\t $codonTable = Bio::Tools::CodonTable->new( -id => $codonTableId);\n\t }\n\n    ## Error if alphabet is \"protein\"\n    $self->throw(\"Can't translate an amino acid sequence.\") if\n\t\t($self->alphabet =~ /protein/i);\n\n    ## Error if -start parameter isn't a valid codon\n\t if ($start_codon) {\n\t\t $self->throw(\"Invalid start codon: $start_codon.\") if\n\t\t\t( $start_codon !~ /^[A-Z]{3}$/i );\n\t }\n\t \n\t my $seq;\n\t \n\t if ($offset) {\n\t\t$self->throw(\"Offset must be 1, 2, or 3.\") if\n\t\t    ( $offset !~ /^[123]$/ );\n\t\tmy ($start, $end) = ($offset, $self->length);\n\t\t($seq) = $self->subseq($start, $end);\n\t } else {\n\t\t($seq) = $self->seq();\n\t }\n\n    ## ignore frame if an ORF is supposed to be found\n\t if ($orf) {\n\t\t $seq = $self->_find_orf($seq,$codonTable,$start_codon);\n\t } else {\n\t ## use frame, error if frame is not 0, 1 or 2\n\t\t $self->throw(\"Valid values for frame are 0, 1, or 2, not $frame.\")\n\t\t\tunless ($frame == 0 or $frame == 1 or $frame == 2);\n\t\t $seq = substr($seq,$frame);\n    }\n\n    ## Translate it\n    my $output = $codonTable->translate($seq);\n    # Use user-input terminator/unknown\n    $output =~ s/\\*/$terminator/g;\n    $output =~ s/X/$unknown/g;\n\n    ## Only if we are expecting to translate a complete coding region\n    if ($complete) {\n\t\t my $id = $self->display_id;\n\t\t # remove the terminator character\n\t\t if( substr($output,-1,1) eq $terminator ) {\n\t\t\t chop $output;\n\t\t } else {\n\t\t\t $throw && $self->throw(\"Seq [$id]: Not using a valid terminator codon!\");\n\t\t\t $self->warn(\"Seq [$id]: Not using a valid terminator codon!\");\n\t\t }\n\t\t # test if there are terminator characters inside the protein sequence!\n\t\t if ($output =~ /\\*/) {\n\t\t\t $throw && $self->throw(\"Seq [$id]: Terminator codon inside CDS!\");\n\t\t\t $self->warn(\"Seq [$id]: Terminator codon inside CDS!\");\n\t\t }\n\t\t # if the initiator codon is not ATG, the amino acid needs to be changed to M\n\t\t if ( substr($output,0,1) ne 'M' ) {\n\t\t\t if ($codonTable->is_start_codon(substr($seq, 0, 3)) ) {\n\t\t\t\t $output = 'M'. substr($output,1);\n\t\t\t }\telsif ($throw) {\n\t\t\t\t $self->throw(\"Seq [$id]: Not using a valid initiator codon!\");\n\t\t\t } else {\n\t\t\t\t $self->warn(\"Seq [$id]: Not using a valid initiator codon!\");\n\t\t\t }\n\t\t }\n    }\n\n    my $seqclass;\n    if ($self->can_call_new()) {\n\t\t $seqclass = ref($self);\n    } else {\n\t\t $seqclass = 'Bio::PrimarySeq';\n\t\t $self->_attempt_to_load_Seq();\n    }\n    my $out = $seqclass->new( '-seq' => $output,\n\t\t\t\t\t\t\t\t\t\t'-display_id'  => $self->display_id,\n\t\t\t\t\t\t\t\t\t\t'-accession_number' => $self->accession_number,\n\t\t\t\t\t\t\t\t\t\t# is there anything wrong with retaining the\n\t\t\t\t\t\t\t\t\t\t# description?\n\t\t\t\t\t\t\t\t\t\t'-desc' => $self->desc(),\n\t\t\t\t\t\t\t\t\t\t'-alphabet' => 'protein',\n                              '-verbose' => $self->verbose\n\t\t\t      );\n    return $out;\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: ID of the sequence. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Returns : A string.\n Args    :\n\n\nsub  id {\n   my ($self)= @_;\n\n   return $self->display_id();\n}\n\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length()\n Function:\n Returns : Integer representing the length of the sequence.\n Args    :","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"line":701,"kind":13,"localvar":"my","containerName":"length","name":"$self","definition":"my"},{"containerName":"length","name":"$self","kind":13,"line":702},{"kind":12,"line":702,"containerName":"length","name":"throw_not_implemented"}],"line":700},{"containerName":"main::","name":"desc","definition":"sub","range":{"start":{"character":0,"line":716},"end":{"character":9999,"line":718}},"kind":12,"line":716,"children":[{"kind":12,"line":717,"containerName":"desc","name":"throw_not_implemented"}]},{"children":[{"containerName":"is_circular","name":"throw_not_implemented","line":732,"kind":12}],"line":731,"kind":12,"range":{"end":{"line":733,"character":9999},"start":{"character":0,"line":731}},"definition":"sub","name":"is_circular","containerName":"main::"},{"name":"_find_orf","range":{"end":{"character":9999,"line":781},"start":{"character":0,"line":753}},"kind":12,"children":[{"line":754,"kind":13,"localvar":"my","containerName":"_find_orf","definition":"my","name":"$self"},{"kind":13,"line":754,"containerName":"_find_orf","name":"$sequence"},{"kind":13,"line":754,"name":"$codonTable","containerName":"_find_orf"},{"name":"$start_codon","containerName":"_find_orf","line":754,"kind":13},{"containerName":"_find_orf","name":"$sequence","line":757,"kind":13},{"line":758,"kind":13,"localvar":"my","containerName":"_find_orf","name":"$codon","definition":"my"},{"line":758,"kind":13,"name":"$sequence","containerName":"_find_orf"},{"containerName":"_find_orf","name":"$start_codon","line":759,"kind":13},{"containerName":"_find_orf","name":"$codon","kind":13,"line":760},{"kind":13,"line":762,"name":"$codonTable","containerName":"_find_orf"},{"kind":12,"line":762,"containerName":"_find_orf","name":"is_start_codon"},{"line":762,"kind":13,"containerName":"_find_orf","name":"$codon"},{"containerName":"_find_orf","name":"$sequence","kind":13,"line":764},{"kind":13,"line":764,"name":"$sequence","containerName":"_find_orf"},{"line":766,"kind":13,"containerName":"_find_orf","name":"$sequence"},{"localvar":"my","definition":"my","name":"$len","containerName":"_find_orf","line":769,"kind":13},{"name":"$sequence","containerName":"_find_orf","line":769,"kind":13},{"kind":13,"line":770,"definition":"my","name":"$offset","containerName":"_find_orf","localvar":"my"},{"line":771,"kind":13,"containerName":"_find_orf","name":"$offset"},{"kind":13,"line":771,"containerName":"_find_orf","name":"$len"},{"localvar":"my","definition":"my","name":"$codon","containerName":"_find_orf","line":772,"kind":13},{"name":"$sequence","containerName":"_find_orf","kind":13,"line":772},{"line":772,"kind":13,"containerName":"_find_orf","name":"$offset"},{"containerName":"_find_orf","name":"$codonTable","kind":13,"line":773},{"line":773,"kind":12,"name":"is_ter_codon","containerName":"_find_orf"},{"kind":13,"line":773,"containerName":"_find_orf","name":"$codon"},{"line":774,"kind":13,"containerName":"_find_orf","name":"$sequence"},{"containerName":"_find_orf","name":"$sequence","line":774,"kind":13},{"line":774,"kind":13,"name":"$offset","containerName":"_find_orf"},{"kind":13,"line":775,"containerName":"_find_orf","name":"$sequence"},{"line":777,"kind":13,"containerName":"_find_orf","name":"$offset"},{"line":779,"kind":13,"name":"$self","containerName":"_find_orf"},{"kind":12,"line":779,"containerName":"_find_orf","name":"warn"},{"line":780,"kind":13,"name":"$sequence","containerName":"_find_orf"}],"line":753,"definition":"sub","containerName":"main::","signature":{"label":"_find_orf($self,$sequence,$codonTable,$start_codon)","documentation":"1;\n# $Id: PrimarySeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n    # If you are a newcomer to bioperl, you might want to start with\n    # Bio::Seq documentation.\n\n    # Test if this is a seq object\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # Accessors\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id();       # for human display\n    $id        = $obj->primary_id();       # unique id for this object,\n                                           # implementation defined\n    $unique_key= $obj->accession_number(); # unique biological id\n\n\n    # Object manipulation\n    eval {\n\t   $rev = $obj->revcom();\n    };\n    if( $@ ) {\n\t   $obj->throw(\"Could not reverse complement. \".\n\t\t    \"Probably not DNA. Actual exception\\n$@\\n\");\n    }\n\n    $trunc = $obj->trunc(12,50);\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers-only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in L<Bio::PrimarySeq>. If you just want to\nuse L<Bio::PrimarySeq> objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\nThis interface defines what bioperl considers necessary to \"be\" a\nsequence, without providing an implementation of this, an\nimplementation is provided in L<Bio::PrimarySeq>. If you want to provide\na Bio::PrimarySeq-compliant object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inherit\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but implementations are suggested to\n           keep an open mind about case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, i.e. 1-2 are the first two\n           bases of the sequence.\n\n           Start cannot be larger than end but can be equal.\n\n Returns : A string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, also known as the common name of the Sequence\n           object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience reasons.\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: Can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called \"type\" because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : A string either 'dna','rna','protein'. NB - the object must\n           make a call of the alphabet, if there is no alphabet specified it\n           has to guess.\n Args    : None\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 moltype\n\n Title   : moltype\n Usage   : Deprecated. Use alphabet() instead.\n\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nThe revcom(), trunc(), and translate() methods create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\".\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensionsj.\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : None\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(\"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-is_circular'  => $self->is_circular,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc(),\n                             '-verbose' => $self->verbose\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence.\n Returns : A fresh Bio::PrimarySeqI implementing object.\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc{\n   my ($self,$start,$end) = @_;\n\n   my $str;\n   if( defined $start && ref($start) &&\n       $start->isa('Bio::LocationI') ) {\n       $str = $self->subseq($start); # start is a location actually\n   } elsif( !$end ) {\n       $self->throw(\"trunc start,end -- there was no end for $start\");\n   } elsif( $end < $start ) {\n       my $msg = \"start [$start] is greater than end [$end]. \\n\".\n\t   \"If you want to truncated and reverse complement, \\n\".\n\t       \"you must call trunc followed by revcom. Sorry.\";\n       $self->throw($msg);\n   } else {\n       $str = $self->subseq($start,$end);\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n\n   my $out = $seqclass->new( '-seq' => $str,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc(),\n                             '-verbose' => $self->verbose\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate\n\n Title   : translate\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n\n           Or if you expect a complete coding sequence (CDS) translation,\n           with inititator at the beginning and terminator at the end:\n\n           $protein_seq_obj = $cds_seq_obj->translate(-complete => 1);\n\n           Or if you want translate() to find the first initiation\n           codon and return the corresponding protein:\n\n           $protein_seq_obj = $cds_seq_obj->translate(-orf => 1);\n\n Function: Provides the translation of the DNA sequence using full\n           IUPAC ambiguities in DNA/RNA and amino acid codes.\n\n           The complete CDS translation is identical to EMBL/TREMBL\n           database translation. Note that the trailing terminator\n           character is removed before returning the translated protein\n           object.\n\n           Note: if you set $dna_seq_obj->verbose(1) you will get a\n           warning if the first codon is not a valid initiator.\n\n Returns : A Bio::PrimarySeqI implementing object\n Args    : -terminator    - character for terminator        default is *\n           -unknown       - character for unknown           default is X\n           -frame         - frame                           default is 0\n           -codontable_id - codon table id                  default is 1\n           -complete      - complete CDS expected           default is 0\n           -throw         - throw exception if not complete default is 0\n           -orf           - find 1st ORF                    default is 0\n           -start         - alternative initiation codon\n           -codontable    - Bio::Tools::CodonTable object\n\t\t   -offset        - offset for fuzzy locations      default is 0\n\n Notes   : The -start argument only applies when -orf is set to 1. By default\n           all initiation codons found in the given codon table are used\n           but when \"start\" is set to some codon this codon will be used\n           exclusively as the initiation codon. Note that the default codon\n           table (NCBI \"Standard\") has 3 initiation codons!\n\n           By default translate() translates termination codons to\n           the some character (default is *), both internal and trailing\n           codons. Setting \"-complete\" to 1 tells translate() to remove\n           the trailing character.\n\n\t\t   -offset is used for seqfeatures which contain the the \\codon_start\n\t\t   tag and can be set to 1, 2, or 3.  This is the offset by which the\n\t\t   sequence translation starts relative to the first base of the\n\t\t   feature\n\nFor details on codon tables used by translate() see L<Bio::Tools::CodonTable>.\n\n           Deprecated argument set (v. 1.5.1 and prior versions)\n           where each argument is an element in an array:\n\n           1: character for terminator (optional), defaults to '*'.\n           2: character for unknown amino acid (optional), defaults to 'X'.\n           3: frame (optional), valid values are 0, 1, 2, defaults to 0.\n           4: codon table id (optional), defaults to 1.\n           5: complete coding sequence expected, defaults to 0 (false).\n           6: boolean, throw exception if not complete coding sequence\n              (true), defaults to warning (false)\n           7: codontable, a custom Bio::Tools::CodonTable object (optional).\n\n\nsub translate {\n\t my ($self,@args) = @_;\n\t my ($terminator, $unknown, $frame, $codonTableId, $complete, $throw,\n\t\t  $codonTable, $orf, $start_codon, $offset);\n\n\t ## new API with named parameters, post 1.5.1\n\t if ($args[0] && $args[0] =~ /^-[A-Z]+/i) {\n\t\t ($terminator, $unknown, $frame, $codonTableId, $complete, $throw,\n\t\t  $codonTable, $orf, $start_codon, $offset) =\n\t\t\t $self->_rearrange([qw(TERMINATOR\n\t\t\t\t\t\t\t\tUNKNOWN\n\t\t\t\t\t\t\t\tFRAME\n\t\t\t\t\t\t\t\tCODONTABLE_ID\n\t\t\t\t\t\t\t\tCOMPLETE\n\t\t\t\t\t\t\t\tTHROW\n\t\t\t\t\t\t\t\tCODONTABLE\n\t\t\t\t\t\t\t\tORF\n\t\t\t\t\t\t\t\tSTART\n\t\t\t\t\t\t\t\tOFFSET)], @args);\n\t ## old API, 1.5.1 and preceding versions\n\t } else {\n\t\t ($terminator, $unknown, $frame, $codonTableId,\n\t\t  $complete, $throw, $codonTable, $offset) = @args;\n\t }\n\n    ## Initialize termination codon, unknown codon, codon table id, frame\n    $terminator = '*'    unless (defined($terminator) and $terminator ne '');\n    $unknown = \"X\"       unless (defined($unknown) and $unknown ne '');\n    $frame = 0           unless (defined($frame) and $frame ne '');\n    $codonTableId = 1    unless (defined($codonTableId) and $codonTableId ne '');\n\n    ## Get a CodonTable, error if custom CodonTable is invalid\n    if ($codonTable) {\n\t\t $self->throw(\"Need a Bio::Tools::CodonTable object, not \". $codonTable)\n\t\t\tunless $codonTable->isa('Bio::Tools::CodonTable');\n    } else {\n\t\t $codonTable = Bio::Tools::CodonTable->new( -id => $codonTableId);\n\t }\n\n    ## Error if alphabet is \"protein\"\n    $self->throw(\"Can't translate an amino acid sequence.\") if\n\t\t($self->alphabet =~ /protein/i);\n\n    ## Error if -start parameter isn't a valid codon\n\t if ($start_codon) {\n\t\t $self->throw(\"Invalid start codon: $start_codon.\") if\n\t\t\t( $start_codon !~ /^[A-Z]{3}$/i );\n\t }\n\t \n\t my $seq;\n\t \n\t if ($offset) {\n\t\t$self->throw(\"Offset must be 1, 2, or 3.\") if\n\t\t    ( $offset !~ /^[123]$/ );\n\t\tmy ($start, $end) = ($offset, $self->length);\n\t\t($seq) = $self->subseq($start, $end);\n\t } else {\n\t\t($seq) = $self->seq();\n\t }\n\n    ## ignore frame if an ORF is supposed to be found\n\t if ($orf) {\n\t\t $seq = $self->_find_orf($seq,$codonTable,$start_codon);\n\t } else {\n\t ## use frame, error if frame is not 0, 1 or 2\n\t\t $self->throw(\"Valid values for frame are 0, 1, or 2, not $frame.\")\n\t\t\tunless ($frame == 0 or $frame == 1 or $frame == 2);\n\t\t $seq = substr($seq,$frame);\n    }\n\n    ## Translate it\n    my $output = $codonTable->translate($seq);\n    # Use user-input terminator/unknown\n    $output =~ s/\\*/$terminator/g;\n    $output =~ s/X/$unknown/g;\n\n    ## Only if we are expecting to translate a complete coding region\n    if ($complete) {\n\t\t my $id = $self->display_id;\n\t\t # remove the terminator character\n\t\t if( substr($output,-1,1) eq $terminator ) {\n\t\t\t chop $output;\n\t\t } else {\n\t\t\t $throw && $self->throw(\"Seq [$id]: Not using a valid terminator codon!\");\n\t\t\t $self->warn(\"Seq [$id]: Not using a valid terminator codon!\");\n\t\t }\n\t\t # test if there are terminator characters inside the protein sequence!\n\t\t if ($output =~ /\\*/) {\n\t\t\t $throw && $self->throw(\"Seq [$id]: Terminator codon inside CDS!\");\n\t\t\t $self->warn(\"Seq [$id]: Terminator codon inside CDS!\");\n\t\t }\n\t\t # if the initiator codon is not ATG, the amino acid needs to be changed to M\n\t\t if ( substr($output,0,1) ne 'M' ) {\n\t\t\t if ($codonTable->is_start_codon(substr($seq, 0, 3)) ) {\n\t\t\t\t $output = 'M'. substr($output,1);\n\t\t\t }\telsif ($throw) {\n\t\t\t\t $self->throw(\"Seq [$id]: Not using a valid initiator codon!\");\n\t\t\t } else {\n\t\t\t\t $self->warn(\"Seq [$id]: Not using a valid initiator codon!\");\n\t\t\t }\n\t\t }\n    }\n\n    my $seqclass;\n    if ($self->can_call_new()) {\n\t\t $seqclass = ref($self);\n    } else {\n\t\t $seqclass = 'Bio::PrimarySeq';\n\t\t $self->_attempt_to_load_Seq();\n    }\n    my $out = $seqclass->new( '-seq' => $output,\n\t\t\t\t\t\t\t\t\t\t'-display_id'  => $self->display_id,\n\t\t\t\t\t\t\t\t\t\t'-accession_number' => $self->accession_number,\n\t\t\t\t\t\t\t\t\t\t# is there anything wrong with retaining the\n\t\t\t\t\t\t\t\t\t\t# description?\n\t\t\t\t\t\t\t\t\t\t'-desc' => $self->desc(),\n\t\t\t\t\t\t\t\t\t\t'-alphabet' => 'protein',\n                              '-verbose' => $self->verbose\n\t\t\t      );\n    return $out;\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: ID of the sequence. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Returns : A string.\n Args    :\n\n\nsub  id {\n   my ($self)= @_;\n\n   return $self->display_id();\n}\n\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length()\n Function:\n Returns : Integer representing the length of the sequence.\n Args    :\n\n\nsub  length {\n   my ($self)= @_;\n   $self->throw_not_implemented();\n}\n\n=head2 desc\n\n Title   : desc\n Usage   : $seq->desc($newval);\n           $description = $seq->desc();\n Function: Get/set description text for a seq object\n Returns : Value of desc\n Args    : newvalue (optional)\n\n\nsub desc {\n   shift->throw_not_implemented();\n}\n\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none\n\n\nsub is_circular{\n    shift->throw_not_implemented;\n}\n\n=head1 Private functions\n\nThese are some private functions for the PrimarySeqI interface. You do not\nneed to implement these functions\n\n=head2 _find_orf\n\n Title   : _find_orf\n Usage   :\n Function: Finds ORF starting at 1st initiation codon in nucleotide sequence.\n           The ORF is not required to have a termination codon.\n Example :\n Returns : A nucleotide sequence or nothing, if no initiation codon is found.\n Args    : Nucleotide sequence, CodonTable object, alternative initiation\n           codon (optional).","parameters":[{"label":"$self"},{"label":"$sequence"},{"label":"$codonTable"},{"label":"$start_codon"}]},"detail":"($self,$sequence,$codonTable,$start_codon)"},{"name":"CORE","containerName":"length","kind":12,"line":769},{"range":{"end":{"character":9999,"line":817},"start":{"character":0,"line":795}},"name":"_attempt_to_load_Seq","signature":{"label":"_attempt_to_load_Seq($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PrimarySeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PrimarySeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeqI - Interface definition for a Bio::PrimarySeq\n\n=head1 SYNOPSIS\n\n    # Bio::PrimarySeqI is the interface class for sequences.\n    # If you are a newcomer to bioperl, you might want to start with\n    # Bio::Seq documentation.\n\n    # Test if this is a seq object\n    $obj->isa(\"Bio::PrimarySeqI\") ||\n      $obj->throw(\"$obj does not implement the Bio::PrimarySeqI interface\");\n\n    # Accessors\n    $string    = $obj->seq();\n    $substring = $obj->subseq(12,50);\n    $display   = $obj->display_id();       # for human display\n    $id        = $obj->primary_id();       # unique id for this object,\n                                           # implementation defined\n    $unique_key= $obj->accession_number(); # unique biological id\n\n\n    # Object manipulation\n    eval {\n\t   $rev = $obj->revcom();\n    };\n    if( $@ ) {\n\t   $obj->throw(\"Could not reverse complement. \".\n\t\t    \"Probably not DNA. Actual exception\\n$@\\n\");\n    }\n\n    $trunc = $obj->trunc(12,50);\n    # $rev and $trunc are Bio::PrimarySeqI compliant objects\n\n\n=head1 DESCRIPTION\n\nThis object defines an abstract interface to basic sequence\ninformation - for most users of the package the documentation (and\nmethods) in this class are not useful - this is a developers-only\nclass which defines what methods have to be implmented by other Perl\nobjects to comply to the Bio::PrimarySeqI interface. Go \"perldoc\nBio::Seq\" or \"man Bio::Seq\" for more information on the main class for\nsequences.\n\nPrimarySeq is an object just for the sequence and its name(s), nothing\nmore. Seq is the larger object complete with features. There is a pure\nperl implementation of this in L<Bio::PrimarySeq>. If you just want to\nuse L<Bio::PrimarySeq> objects, then please read that module first. This\nmodule defines the interface, and is of more interest to people who\nwant to wrap their own Perl Objects/RDBs/FileSystems etc in way that\nthey \"are\" bioperl sequence objects, even though it is not using Perl\nto store the sequence etc.\n\nThis interface defines what bioperl considers necessary to \"be\" a\nsequence, without providing an implementation of this, an\nimplementation is provided in L<Bio::PrimarySeq>. If you want to provide\na Bio::PrimarySeq-compliant object which in fact wraps another\nobject/database/out-of-perl experience, then this is the correct thing\nto wrap, generally by providing a wrapper class which would inherit\nfrom your object and this Bio::PrimarySeqI interface. The wrapper class\nthen would have methods lists in the \"Implementation Specific\nFunctions\" which would provide these methods for your object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeqI;\nuse strict;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 seq\n\n Title   : seq\n Usage   : $string = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but implementations are suggested to\n           keep an open mind about case (some users... want mixed case!)\n Returns : A scalar\n Status  : Virtual\n\n\nsub seq {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: Returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, i.e. 1-2 are the first two\n           bases of the sequence.\n\n           Start cannot be larger than end but can be equal.\n\n Returns : A string\n Args    :\n Status  : Virtual\n\n\nsub subseq{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: Returns the display id, also known as the common name of the Sequence\n           object.\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information. Bioperl does not use any\n           embedded information in the ID field, and people are\n           encouraged to use other mechanisms (accession field for\n           example, or extending the sequence object) to solve this.\n\n           Notice that $seq->id() maps to this function, mainly for\n           legacy/convenience reasons.\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub display_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should return\n           \"unknown\".\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub accession_number {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no accession number, this method should\n           return a stringified memory location.\n\n Returns : A string\n Args    : None\n Status  : Virtual\n\n\n\nsub primary_id {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   : if( $obj->can_call_new ) {\n             $newobj = $obj->new( %param );\n\t }\n Function: Can_call_new returns 1 or 0 depending\n           on whether an implementation allows new\n           constructor to be called. If a new constructor\n           is allowed, then it should take the followed hashed\n           constructor list.\n\n           $myobject->new( -seq => $sequence_as_string,\n\t\t\t   -display_id  => $id\n\t\t\t   -accession_number => $accession\n\t\t\t   -alphabet => 'dna',\n\t\t\t   );\n Returns : 1 or 0\n Args    :\n\n\n\nsub can_call_new{\n   my ($self,@args) = @_;\n\n   # we default to 0 here\n\n   return 0;\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called \"type\" because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : A string either 'dna','rna','protein'. NB - the object must\n           make a call of the alphabet, if there is no alphabet specified it\n           has to guess.\n Args    : None\n Status  : Virtual\n\n\n\nsub alphabet{\n    my ( $self ) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 moltype\n\n Title   : moltype\n Usage   : Deprecated. Use alphabet() instead.\n\n\nsub moltype{\n   my ($self,@args) = @_;\n\n   $self->warn(\"moltype: pre v1.0 method. Calling alphabet() instead...\");\n   $self->alphabet(@args);\n}\n\n\n=head1 Optional Implementation Functions\n\nThe following functions rely on the above functions. An\nimplementing class does not need to provide these functions, as they\nwill be provided by this class, but is free to override these\nfunctions.\n\nThe revcom(), trunc(), and translate() methods create new sequence\nobjects. They will call new() on the class of the sequence object\ninstance passed as argument, unless can_call_new() returns FALSE. In\nthe latter case a Bio::PrimarySeq object will be created. Implementors\nwhich really want to control how objects are created (eg, for object\npersistence over a database, or objects in a CORBA framework), they\nare encouraged to override these methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::PrimarySeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\".\n\n           The id is the same id as the original sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensionsj.\n\n           To do an inplace edit of an object you can go:\n\n           $seq = $seq->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::PrimarySeqI object\n Args    : None\n\n\n\nsub revcom{\n   my ($self) = @_;\n\n\n   # check the type is good first.\n   my $t = $self->alphabet;\n\n   if( $t eq 'protein' ) {\n       $self->throw(\"Sequence is a protein. Cannot revcom\");\n   }\n\n   if( $t ne 'dna' && $t ne 'rna' ) {\n       if( $self->can('warn') ) {\n\t   $self->warn(\"Sequence is not dna or rna, but [$t]. \".\n\t\t       \"Attempting to revcom, but unsure if this is right\");\n       } else {\n\t   warn(\"[$self] Sequence is not dna or rna, but [$t]. \".\n\t\t\"Attempting to revcom, but unsure if this is right\");\n       }\n   }\n\n   # yank out the sequence string\n\n   my $str = $self->seq();\n\n   # if is RNA - map to DNA then map back\n\n   if( $t eq 'rna' ) {\n       $str =~ tr/uU/tT/;\n   }\n\n   # revcom etc...\n\n   $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n   my $revseq = CORE::reverse $str;\n\n   if( $t eq 'rna' ) {\n       $revseq =~ tr/tT/uU/;\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n   my $out = $seqclass->new( '-seq' => $revseq,\n\t\t\t     '-is_circular'  => $self->is_circular,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc(),\n                             '-verbose' => $self->verbose\n\t\t\t     );\n   return $out;\n\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence.\n Returns : A fresh Bio::PrimarySeqI implementing object.\n Args    : Two integers denoting first and last base of the sub-sequence.\n\n\n\nsub trunc{\n   my ($self,$start,$end) = @_;\n\n   my $str;\n   if( defined $start && ref($start) &&\n       $start->isa('Bio::LocationI') ) {\n       $str = $self->subseq($start); # start is a location actually\n   } elsif( !$end ) {\n       $self->throw(\"trunc start,end -- there was no end for $start\");\n   } elsif( $end < $start ) {\n       my $msg = \"start [$start] is greater than end [$end]. \\n\".\n\t   \"If you want to truncated and reverse complement, \\n\".\n\t       \"you must call trunc followed by revcom. Sorry.\";\n       $self->throw($msg);\n   } else {\n       $str = $self->subseq($start,$end);\n   }\n\n   my $seqclass;\n   if($self->can_call_new()) {\n       $seqclass = ref($self);\n   } else {\n       $seqclass = 'Bio::PrimarySeq';\n       $self->_attempt_to_load_Seq();\n   }\n\n   my $out = $seqclass->new( '-seq' => $str,\n\t\t\t     '-display_id'  => $self->display_id,\n\t\t\t     '-accession_number' => $self->accession_number,\n\t\t\t     '-alphabet' => $self->alphabet,\n\t\t\t     '-desc' => $self->desc(),\n                             '-verbose' => $self->verbose\n\t\t\t     );\n   return $out;\n}\n\n\n=head2 translate\n\n Title   : translate\n Usage   : $protein_seq_obj = $dna_seq_obj->translate\n\n           Or if you expect a complete coding sequence (CDS) translation,\n           with inititator at the beginning and terminator at the end:\n\n           $protein_seq_obj = $cds_seq_obj->translate(-complete => 1);\n\n           Or if you want translate() to find the first initiation\n           codon and return the corresponding protein:\n\n           $protein_seq_obj = $cds_seq_obj->translate(-orf => 1);\n\n Function: Provides the translation of the DNA sequence using full\n           IUPAC ambiguities in DNA/RNA and amino acid codes.\n\n           The complete CDS translation is identical to EMBL/TREMBL\n           database translation. Note that the trailing terminator\n           character is removed before returning the translated protein\n           object.\n\n           Note: if you set $dna_seq_obj->verbose(1) you will get a\n           warning if the first codon is not a valid initiator.\n\n Returns : A Bio::PrimarySeqI implementing object\n Args    : -terminator    - character for terminator        default is *\n           -unknown       - character for unknown           default is X\n           -frame         - frame                           default is 0\n           -codontable_id - codon table id                  default is 1\n           -complete      - complete CDS expected           default is 0\n           -throw         - throw exception if not complete default is 0\n           -orf           - find 1st ORF                    default is 0\n           -start         - alternative initiation codon\n           -codontable    - Bio::Tools::CodonTable object\n\t\t   -offset        - offset for fuzzy locations      default is 0\n\n Notes   : The -start argument only applies when -orf is set to 1. By default\n           all initiation codons found in the given codon table are used\n           but when \"start\" is set to some codon this codon will be used\n           exclusively as the initiation codon. Note that the default codon\n           table (NCBI \"Standard\") has 3 initiation codons!\n\n           By default translate() translates termination codons to\n           the some character (default is *), both internal and trailing\n           codons. Setting \"-complete\" to 1 tells translate() to remove\n           the trailing character.\n\n\t\t   -offset is used for seqfeatures which contain the the \\codon_start\n\t\t   tag and can be set to 1, 2, or 3.  This is the offset by which the\n\t\t   sequence translation starts relative to the first base of the\n\t\t   feature\n\nFor details on codon tables used by translate() see L<Bio::Tools::CodonTable>.\n\n           Deprecated argument set (v. 1.5.1 and prior versions)\n           where each argument is an element in an array:\n\n           1: character for terminator (optional), defaults to '*'.\n           2: character for unknown amino acid (optional), defaults to 'X'.\n           3: frame (optional), valid values are 0, 1, 2, defaults to 0.\n           4: codon table id (optional), defaults to 1.\n           5: complete coding sequence expected, defaults to 0 (false).\n           6: boolean, throw exception if not complete coding sequence\n              (true), defaults to warning (false)\n           7: codontable, a custom Bio::Tools::CodonTable object (optional).\n\n\nsub translate {\n\t my ($self,@args) = @_;\n\t my ($terminator, $unknown, $frame, $codonTableId, $complete, $throw,\n\t\t  $codonTable, $orf, $start_codon, $offset);\n\n\t ## new API with named parameters, post 1.5.1\n\t if ($args[0] && $args[0] =~ /^-[A-Z]+/i) {\n\t\t ($terminator, $unknown, $frame, $codonTableId, $complete, $throw,\n\t\t  $codonTable, $orf, $start_codon, $offset) =\n\t\t\t $self->_rearrange([qw(TERMINATOR\n\t\t\t\t\t\t\t\tUNKNOWN\n\t\t\t\t\t\t\t\tFRAME\n\t\t\t\t\t\t\t\tCODONTABLE_ID\n\t\t\t\t\t\t\t\tCOMPLETE\n\t\t\t\t\t\t\t\tTHROW\n\t\t\t\t\t\t\t\tCODONTABLE\n\t\t\t\t\t\t\t\tORF\n\t\t\t\t\t\t\t\tSTART\n\t\t\t\t\t\t\t\tOFFSET)], @args);\n\t ## old API, 1.5.1 and preceding versions\n\t } else {\n\t\t ($terminator, $unknown, $frame, $codonTableId,\n\t\t  $complete, $throw, $codonTable, $offset) = @args;\n\t }\n\n    ## Initialize termination codon, unknown codon, codon table id, frame\n    $terminator = '*'    unless (defined($terminator) and $terminator ne '');\n    $unknown = \"X\"       unless (defined($unknown) and $unknown ne '');\n    $frame = 0           unless (defined($frame) and $frame ne '');\n    $codonTableId = 1    unless (defined($codonTableId) and $codonTableId ne '');\n\n    ## Get a CodonTable, error if custom CodonTable is invalid\n    if ($codonTable) {\n\t\t $self->throw(\"Need a Bio::Tools::CodonTable object, not \". $codonTable)\n\t\t\tunless $codonTable->isa('Bio::Tools::CodonTable');\n    } else {\n\t\t $codonTable = Bio::Tools::CodonTable->new( -id => $codonTableId);\n\t }\n\n    ## Error if alphabet is \"protein\"\n    $self->throw(\"Can't translate an amino acid sequence.\") if\n\t\t($self->alphabet =~ /protein/i);\n\n    ## Error if -start parameter isn't a valid codon\n\t if ($start_codon) {\n\t\t $self->throw(\"Invalid start codon: $start_codon.\") if\n\t\t\t( $start_codon !~ /^[A-Z]{3}$/i );\n\t }\n\t \n\t my $seq;\n\t \n\t if ($offset) {\n\t\t$self->throw(\"Offset must be 1, 2, or 3.\") if\n\t\t    ( $offset !~ /^[123]$/ );\n\t\tmy ($start, $end) = ($offset, $self->length);\n\t\t($seq) = $self->subseq($start, $end);\n\t } else {\n\t\t($seq) = $self->seq();\n\t }\n\n    ## ignore frame if an ORF is supposed to be found\n\t if ($orf) {\n\t\t $seq = $self->_find_orf($seq,$codonTable,$start_codon);\n\t } else {\n\t ## use frame, error if frame is not 0, 1 or 2\n\t\t $self->throw(\"Valid values for frame are 0, 1, or 2, not $frame.\")\n\t\t\tunless ($frame == 0 or $frame == 1 or $frame == 2);\n\t\t $seq = substr($seq,$frame);\n    }\n\n    ## Translate it\n    my $output = $codonTable->translate($seq);\n    # Use user-input terminator/unknown\n    $output =~ s/\\*/$terminator/g;\n    $output =~ s/X/$unknown/g;\n\n    ## Only if we are expecting to translate a complete coding region\n    if ($complete) {\n\t\t my $id = $self->display_id;\n\t\t # remove the terminator character\n\t\t if( substr($output,-1,1) eq $terminator ) {\n\t\t\t chop $output;\n\t\t } else {\n\t\t\t $throw && $self->throw(\"Seq [$id]: Not using a valid terminator codon!\");\n\t\t\t $self->warn(\"Seq [$id]: Not using a valid terminator codon!\");\n\t\t }\n\t\t # test if there are terminator characters inside the protein sequence!\n\t\t if ($output =~ /\\*/) {\n\t\t\t $throw && $self->throw(\"Seq [$id]: Terminator codon inside CDS!\");\n\t\t\t $self->warn(\"Seq [$id]: Terminator codon inside CDS!\");\n\t\t }\n\t\t # if the initiator codon is not ATG, the amino acid needs to be changed to M\n\t\t if ( substr($output,0,1) ne 'M' ) {\n\t\t\t if ($codonTable->is_start_codon(substr($seq, 0, 3)) ) {\n\t\t\t\t $output = 'M'. substr($output,1);\n\t\t\t }\telsif ($throw) {\n\t\t\t\t $self->throw(\"Seq [$id]: Not using a valid initiator codon!\");\n\t\t\t } else {\n\t\t\t\t $self->warn(\"Seq [$id]: Not using a valid initiator codon!\");\n\t\t\t }\n\t\t }\n    }\n\n    my $seqclass;\n    if ($self->can_call_new()) {\n\t\t $seqclass = ref($self);\n    } else {\n\t\t $seqclass = 'Bio::PrimarySeq';\n\t\t $self->_attempt_to_load_Seq();\n    }\n    my $out = $seqclass->new( '-seq' => $output,\n\t\t\t\t\t\t\t\t\t\t'-display_id'  => $self->display_id,\n\t\t\t\t\t\t\t\t\t\t'-accession_number' => $self->accession_number,\n\t\t\t\t\t\t\t\t\t\t# is there anything wrong with retaining the\n\t\t\t\t\t\t\t\t\t\t# description?\n\t\t\t\t\t\t\t\t\t\t'-desc' => $self->desc(),\n\t\t\t\t\t\t\t\t\t\t'-alphabet' => 'protein',\n                              '-verbose' => $self->verbose\n\t\t\t      );\n    return $out;\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: ID of the sequence. This should normally be (and actually is in\n           the implementation provided here) just a synonym for display_id().\n Returns : A string.\n Args    :\n\n\nsub  id {\n   my ($self)= @_;\n\n   return $self->display_id();\n}\n\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length()\n Function:\n Returns : Integer representing the length of the sequence.\n Args    :\n\n\nsub  length {\n   my ($self)= @_;\n   $self->throw_not_implemented();\n}\n\n=head2 desc\n\n Title   : desc\n Usage   : $seq->desc($newval);\n           $description = $seq->desc();\n Function: Get/set description text for a seq object\n Returns : Value of desc\n Args    : newvalue (optional)\n\n\nsub desc {\n   shift->throw_not_implemented();\n}\n\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none\n\n\nsub is_circular{\n    shift->throw_not_implemented;\n}\n\n=head1 Private functions\n\nThese are some private functions for the PrimarySeqI interface. You do not\nneed to implement these functions\n\n=head2 _find_orf\n\n Title   : _find_orf\n Usage   :\n Function: Finds ORF starting at 1st initiation codon in nucleotide sequence.\n           The ORF is not required to have a termination codon.\n Example :\n Returns : A nucleotide sequence or nothing, if no initiation codon is found.\n Args    : Nucleotide sequence, CodonTable object, alternative initiation\n           codon (optional).\n\n\nsub _find_orf {\n\tmy ($self,$sequence,$codonTable,$start_codon) = @_;\n\n\t# find initiation codon and remove leading sequence\n\twhile ($sequence) {\n\t\tmy $codon = substr($sequence,0,3);\n\t\tif ($start_codon) {\n\t\t\tlast if ( $codon =~ /$start_codon/i );\n\t\t} else {\n\t\t\tlast if ($codonTable->is_start_codon($codon));\n\t\t}\n\t\t$sequence = substr($sequence,1);\n\t}\n\treturn unless $sequence;\n\n\t# find termination codon and remove trailing sequence\n\tmy $len = CORE::length($sequence);\n\tmy $offset = 3;\n\twhile ($offset < $len) {\n\t\tmy $codon = substr($sequence,$offset,3);\n\t\tif ( $codonTable->is_ter_codon($codon) ){\n\t\t\t$sequence = substr($sequence, 0, $offset + 3);\n\t\t\treturn $sequence;\n\t\t}\n\t\t$offset += 3;\n\t}\n\t$self->warn(\"No termination codon found, will translate - sequence:\\n$sequence\");\n\t$sequence;\n}\n\n=head2 _attempt_to_load_Seq\n\n Title   : _attempt_to_load_Seq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"_attempt_to_load_Seq","definition":"my","name":"$self","line":796,"kind":13},{"kind":13,"line":798,"containerName":"_attempt_to_load_Seq","name":"$main"},{"name":"$text","definition":"my","containerName":"_attempt_to_load_Seq","localvar":"my","kind":13,"line":805},{"kind":13,"line":811,"name":"$self","containerName":"_attempt_to_load_Seq"},{"name":"throw","containerName":"_attempt_to_load_Seq","line":811,"kind":12}],"line":795,"kind":12},{"line":804,"kind":12,"containerName":"PrimarySeq","name":"Bio"}]}