{"vars":[{"name":"in_label","definition":1,"containerName":"main::","kind":14,"line":173},{"line":173,"kind":12,"name":"strict","containerName":""},{"kind":12,"line":174,"name":"out_label"},{"name":"non_syn","line":175,"kind":12},{"name":"syn","line":176,"kind":12},{"name":"default_codon_table","kind":12,"line":177},{"kind":2,"line":181,"containerName":"Bio::MolEvol::CodonModel::List","name":"Util"},{"line":183,"kind":2,"containerName":"","name":"base"},{"containerName":"main::","definition":"our","name":"$codon_table","line":184,"kind":13},{"name":"default_codon_table","line":184,"kind":12},{"name":"%has_twotailed","definition":"our","containerName":"main::","line":185,"kind":13},{"name":"Text","containerName":"NSP::Measures::Fisher2::twotailed","kind":12,"line":188},{"containerName":null,"name":"%has_twotailed","kind":13,"line":188},{"containerName":null,"name":"$has_twotailed","kind":13,"line":189},{"name":"fu_and_li_D","range":{"end":{"character":9999,"line":260},"start":{"character":0,"line":226}},"containerName":"main::","definition":"sub","detail":"($self,$ingroup,$outgroup)","signature":{"label":"fu_and_li_D($self,$ingroup,$outgroup)","documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals","parameters":[{"label":"$self"},{"label":"$ingroup"},{"label":"$outgroup"}]},"kind":12,"line":226,"children":[{"localvar":"my","containerName":"fu_and_li_D","definition":"my","name":"$self","line":227,"kind":13},{"name":"$ingroup","containerName":"fu_and_li_D","line":227,"kind":13},{"containerName":"fu_and_li_D","name":"$outgroup","line":227,"kind":13},{"containerName":"fu_and_li_D","definition":"my","name":"$seg_sites","localvar":"my","kind":13,"line":229},{"line":229,"kind":13,"name":"$n","containerName":"fu_and_li_D"},{"kind":13,"line":229,"containerName":"fu_and_li_D","name":"$ancestral"},{"line":229,"kind":13,"name":"$derived","containerName":"fu_and_li_D"},{"containerName":"fu_and_li_D","name":"$ingroup","kind":13,"line":230},{"name":"$n","containerName":"fu_and_li_D","kind":13,"line":231},{"containerName":"fu_and_li_D","name":"$ingroup","kind":13,"line":231},{"line":233,"kind":13,"containerName":"fu_and_li_D","name":"$seg_sites"},{"kind":13,"line":233,"name":"$self","containerName":"fu_and_li_D"},{"kind":12,"line":233,"containerName":"fu_and_li_D","name":"segregating_sites_count"},{"line":233,"kind":13,"name":"$ingroup","containerName":"fu_and_li_D"},{"name":"$ingroup","containerName":"fu_and_li_D","kind":13,"line":234},{"line":235,"kind":13,"containerName":"fu_and_li_D","name":"$ingroup"},{"containerName":"fu_and_li_D","name":"isa","kind":12,"line":235},{"name":"$n","containerName":"fu_and_li_D","kind":13,"line":236},{"containerName":"fu_and_li_D","name":"$ingroup","line":236,"kind":13},{"line":236,"kind":12,"name":"get_number_individuals","containerName":"fu_and_li_D"},{"line":237,"kind":13,"name":"$seg_sites","containerName":"fu_and_li_D"},{"containerName":"fu_and_li_D","name":"$self","kind":13,"line":237},{"containerName":"fu_and_li_D","name":"segregating_sites_count","line":237,"kind":12},{"name":"$ingroup","containerName":"fu_and_li_D","line":237,"kind":13},{"kind":13,"line":239,"containerName":"fu_and_li_D","name":"$self"},{"name":"throw","containerName":"fu_and_li_D","line":239,"kind":12},{"kind":13,"line":243,"containerName":"fu_and_li_D","name":"$seg_sites"},{"name":"$self","containerName":"fu_and_li_D","kind":13,"line":244},{"kind":12,"line":244,"name":"warn","containerName":"fu_and_li_D"},{"containerName":"fu_and_li_D","name":"$outgroup","line":248,"kind":13},{"kind":13,"line":249,"containerName":"fu_and_li_D","name":"$self"},{"line":249,"kind":12,"containerName":"fu_and_li_D","name":"warn"},{"kind":13,"line":251,"containerName":"fu_and_li_D","name":"$outgroup"},{"kind":13,"line":252,"name":"$ancestral","containerName":"fu_and_li_D"},{"name":"$derived","containerName":"fu_and_li_D","line":252,"kind":13},{"containerName":"fu_and_li_D","name":"$self","kind":13,"line":252},{"containerName":"fu_and_li_D","name":"derived_mutations","kind":12,"line":252},{"name":"$ingroup","containerName":"fu_and_li_D","line":252,"kind":13},{"name":"$outgroup","containerName":"fu_and_li_D","line":252,"kind":13},{"name":"$ancestral","containerName":"fu_and_li_D","line":253,"kind":13},{"kind":13,"line":253,"containerName":"fu_and_li_D","name":"$ancestral"},{"name":"$ancestral","containerName":"fu_and_li_D","line":255,"kind":13},{"name":"$outgroup","containerName":"fu_and_li_D","line":255,"kind":13},{"name":"$self","containerName":"fu_and_li_D","line":258,"kind":13},{"kind":12,"line":258,"name":"fu_and_li_D_counts","containerName":"fu_and_li_D"},{"kind":13,"line":258,"containerName":"fu_and_li_D","name":"$n"},{"kind":13,"line":258,"name":"$seg_sites","containerName":"fu_and_li_D"},{"kind":13,"line":259,"containerName":"fu_and_li_D","name":"$ancestral"},{"name":"$derived","containerName":"fu_and_li_D","kind":13,"line":259}]},{"line":277,"children":[{"line":278,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"fu_and_li_D_counts"},{"containerName":"fu_and_li_D_counts","name":"$n","line":278,"kind":13},{"name":"$seg_sites","containerName":"fu_and_li_D_counts","line":278,"kind":13},{"line":278,"kind":13,"name":"$external_mut","containerName":"fu_and_li_D_counts"},{"line":279,"kind":13,"localvar":"my","name":"$a_n","definition":"my","containerName":"fu_and_li_D_counts"},{"localvar":"my","containerName":"fu_and_li_D_counts","name":"$k","definition":"my","line":280,"kind":13},{"kind":13,"line":280,"name":"$k","containerName":"fu_and_li_D_counts"},{"containerName":"fu_and_li_D_counts","name":"$n","line":280,"kind":13},{"kind":13,"line":280,"containerName":"fu_and_li_D_counts","name":"$k"},{"name":"$a_n","containerName":"fu_and_li_D_counts","line":281,"kind":13},{"kind":13,"line":281,"name":"$k","containerName":"fu_and_li_D_counts"},{"localvar":"my","containerName":"fu_and_li_D_counts","definition":"my","name":"$b","line":283,"kind":13},{"line":284,"kind":13,"localvar":"my","containerName":"fu_and_li_D_counts","name":"$k","definition":"my"},{"containerName":"fu_and_li_D_counts","name":"$k","kind":13,"line":284},{"containerName":"fu_and_li_D_counts","name":"$n","kind":13,"line":284},{"name":"$k","containerName":"fu_and_li_D_counts","line":284,"kind":13},{"line":285,"kind":13,"containerName":"fu_and_li_D_counts","name":"$b"},{"line":285,"kind":13,"containerName":"fu_and_li_D_counts","name":"$k"},{"line":288,"kind":13,"localvar":"my","definition":"my","name":"$c","containerName":"fu_and_li_D_counts"},{"containerName":"fu_and_li_D_counts","name":"$n","kind":13,"line":288},{"line":288,"kind":13,"name":"$a_n","containerName":"fu_and_li_D_counts"},{"kind":13,"line":288,"name":"$n","containerName":"fu_and_li_D_counts"},{"name":"$n","containerName":"fu_and_li_D_counts","line":289,"kind":13},{"name":"$n","containerName":"fu_and_li_D_counts","line":289,"kind":13},{"definition":"my","name":"$v","containerName":"fu_and_li_D_counts","localvar":"my","kind":13,"line":291},{"kind":13,"line":291,"name":"$a_n","containerName":"fu_and_li_D_counts"},{"containerName":"fu_and_li_D_counts","name":"$b","kind":13,"line":291},{"line":291,"kind":13,"name":"$a_n","containerName":"fu_and_li_D_counts"},{"containerName":"fu_and_li_D_counts","name":"$c","kind":13,"line":292},{"line":292,"kind":13,"name":"$n","containerName":"fu_and_li_D_counts"},{"line":293,"kind":13,"containerName":"fu_and_li_D_counts","name":"$n"},{"containerName":"fu_and_li_D_counts","name":"$u","definition":"my","localvar":"my","kind":13,"line":295},{"name":"$a_n","containerName":"fu_and_li_D_counts","kind":13,"line":295},{"containerName":"fu_and_li_D_counts","name":"$v","kind":13,"line":295},{"kind":13,"line":297,"containerName":"fu_and_li_D_counts","name":"$seg_sites"},{"containerName":"fu_and_li_D_counts","name":"$a_n","line":297,"kind":13},{"kind":13,"line":297,"name":"$external_mut","containerName":"fu_and_li_D_counts"},{"line":298,"kind":13,"name":"$u","containerName":"fu_and_li_D_counts"},{"kind":13,"line":298,"containerName":"fu_and_li_D_counts","name":"$seg_sites"},{"line":298,"kind":13,"containerName":"fu_and_li_D_counts","name":"$v"},{"containerName":"fu_and_li_D_counts","name":"$seg_sites","line":298,"kind":13},{"line":298,"kind":13,"name":"$seg_sites","containerName":"fu_and_li_D_counts"}],"kind":12,"detail":"($self,$n,$seg_sites,$external_mut)","signature":{"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)","parameters":[{"label":"$self"},{"label":"$n"},{"label":"$seg_sites"},{"label":"$external_mut"}],"label":"fu_and_li_D_counts($self,$n,$seg_sites,$external_mut)"},"containerName":"main::","definition":"sub","range":{"start":{"line":277,"character":0},"end":{"line":300,"character":9999}},"name":"fu_and_li_D_counts"},{"line":319,"children":[{"kind":13,"line":320,"containerName":"fu_and_li_D_star","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":320,"containerName":"fu_and_li_D_star","name":"$individuals"},{"localvar":"my","name":"$seg_sites","definition":"my","containerName":"fu_and_li_D_star","line":322,"kind":13},{"name":"$n","containerName":"fu_and_li_D_star","kind":13,"line":322},{"containerName":"fu_and_li_D_star","name":"$singletons","kind":13,"line":322},{"name":"$individuals","containerName":"fu_and_li_D_star","kind":13,"line":323},{"name":"$n","containerName":"fu_and_li_D_star","kind":13,"line":324},{"kind":13,"line":324,"name":"$individuals","containerName":"fu_and_li_D_star"},{"kind":13,"line":325,"name":"$seg_sites","containerName":"fu_and_li_D_star"},{"kind":13,"line":325,"name":"$self","containerName":"fu_and_li_D_star"},{"kind":12,"line":325,"name":"segregating_sites_count","containerName":"fu_and_li_D_star"},{"name":"$individuals","containerName":"fu_and_li_D_star","line":325,"kind":13},{"kind":13,"line":326,"containerName":"fu_and_li_D_star","name":"$singletons"},{"name":"$self","containerName":"fu_and_li_D_star","line":326,"kind":13},{"line":326,"kind":12,"name":"singleton_count","containerName":"fu_and_li_D_star"},{"name":"$individuals","containerName":"fu_and_li_D_star","kind":13,"line":326},{"containerName":"fu_and_li_D_star","name":"$individuals","kind":13,"line":327},{"line":328,"kind":13,"containerName":"fu_and_li_D_star","name":"$individuals"},{"kind":12,"line":328,"containerName":"fu_and_li_D_star","name":"isa"},{"kind":13,"line":329,"containerName":"fu_and_li_D_star","name":"$pop","definition":"my","localvar":"my"},{"name":"$individuals","containerName":"fu_and_li_D_star","line":329,"kind":13},{"line":330,"kind":13,"containerName":"fu_and_li_D_star","name":"$n"},{"kind":13,"line":330,"containerName":"fu_and_li_D_star","name":"$pop"},{"name":"get_number_individuals","containerName":"fu_and_li_D_star","kind":12,"line":330},{"line":331,"kind":13,"name":"$seg_sites","containerName":"fu_and_li_D_star"},{"line":331,"kind":13,"containerName":"fu_and_li_D_star","name":"$self"},{"line":331,"kind":12,"name":"segregating_sites_count","containerName":"fu_and_li_D_star"},{"kind":13,"line":331,"name":"$pop","containerName":"fu_and_li_D_star"},{"kind":13,"line":332,"name":"$singletons","containerName":"fu_and_li_D_star"},{"name":"$self","containerName":"fu_and_li_D_star","line":332,"kind":13},{"containerName":"fu_and_li_D_star","name":"singleton_count","line":332,"kind":12},{"containerName":"fu_and_li_D_star","name":"$pop","line":332,"kind":13},{"line":334,"kind":13,"name":"$self","containerName":"fu_and_li_D_star"},{"kind":12,"line":334,"name":"throw","containerName":"fu_and_li_D_star"},{"name":"$self","containerName":"fu_and_li_D_star","line":338,"kind":13},{"kind":12,"line":338,"containerName":"fu_and_li_D_star","name":"fu_and_li_D_star_counts"},{"line":338,"kind":13,"containerName":"fu_and_li_D_star","name":"$n"},{"line":338,"kind":13,"containerName":"fu_and_li_D_star","name":"$seg_sites"},{"containerName":"fu_and_li_D_star","name":"$singletons","line":338,"kind":13}],"kind":12,"detail":"($self,$individuals)","signature":{"label":"fu_and_li_D_star($self,$individuals)","parameters":[{"label":"$self"},{"label":"$individuals"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n'\n fu_and_li_D*"},"containerName":"main::","definition":"sub","range":{"end":{"line":339,"character":9999},"start":{"line":319,"character":0}},"name":"fu_and_li_D_star"},{"kind":12,"children":[{"containerName":"fu_and_li_D_star_counts","definition":"my","name":"$self","localvar":"my","kind":13,"line":358},{"line":358,"kind":13,"name":"$n","containerName":"fu_and_li_D_star_counts"},{"containerName":"fu_and_li_D_star_counts","name":"$seg_sites","kind":13,"line":358},{"name":"$singletons","containerName":"fu_and_li_D_star_counts","kind":13,"line":358},{"line":359,"kind":13,"localvar":"my","definition":"my","name":"$a_n","containerName":"fu_and_li_D_star_counts"},{"kind":13,"line":360,"containerName":"fu_and_li_D_star_counts","name":"$k","definition":"my","localvar":"my"},{"kind":13,"line":360,"containerName":"fu_and_li_D_star_counts","name":"$k"},{"containerName":"fu_and_li_D_star_counts","name":"$n","line":360,"kind":13},{"kind":13,"line":360,"name":"$k","containerName":"fu_and_li_D_star_counts"},{"containerName":"fu_and_li_D_star_counts","name":"$a_n","line":361,"kind":13},{"name":"$k","containerName":"fu_and_li_D_star_counts","line":361,"kind":13},{"definition":"my","name":"$a1","containerName":"fu_and_li_D_star_counts","localvar":"my","kind":13,"line":364},{"kind":13,"line":364,"name":"$a_n","containerName":"fu_and_li_D_star_counts"},{"name":"$n","containerName":"fu_and_li_D_star_counts","line":364,"kind":13},{"localvar":"my","containerName":"fu_and_li_D_star_counts","definition":"my","name":"$b","line":366,"kind":13},{"localvar":"my","name":"$k","definition":"my","containerName":"fu_and_li_D_star_counts","line":367,"kind":13},{"kind":13,"line":367,"containerName":"fu_and_li_D_star_counts","name":"$k"},{"line":367,"kind":13,"name":"$n","containerName":"fu_and_li_D_star_counts"},{"line":367,"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$k"},{"name":"$b","containerName":"fu_and_li_D_star_counts","line":368,"kind":13},{"line":368,"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$k"},{"localvar":"my","definition":"my","name":"$c","containerName":"fu_and_li_D_star_counts","line":371,"kind":13},{"line":371,"kind":13,"name":"$n","containerName":"fu_and_li_D_star_counts"},{"name":"$a_n","containerName":"fu_and_li_D_star_counts","kind":13,"line":371},{"kind":13,"line":371,"containerName":"fu_and_li_D_star_counts","name":"$n"},{"kind":13,"line":372,"name":"$n","containerName":"fu_and_li_D_star_counts"},{"name":"$n","containerName":"fu_and_li_D_star_counts","line":372,"kind":13},{"kind":13,"line":374,"name":"$d","definition":"my","containerName":"fu_and_li_D_star_counts","localvar":"my"},{"containerName":"fu_and_li_D_star_counts","name":"$c","line":374,"kind":13},{"line":374,"kind":13,"name":"$n","containerName":"fu_and_li_D_star_counts"},{"kind":13,"line":374,"name":"$n","containerName":"fu_and_li_D_star_counts"},{"line":375,"kind":13,"name":"$n","containerName":"fu_and_li_D_star_counts"},{"kind":13,"line":376,"name":"$a1","containerName":"fu_and_li_D_star_counts"},{"name":"$n","containerName":"fu_and_li_D_star_counts","kind":13,"line":376},{"containerName":"fu_and_li_D_star_counts","name":"$n","line":377,"kind":13},{"kind":13,"line":379,"containerName":"fu_and_li_D_star_counts","definition":"my","name":"$v_star","localvar":"my"},{"name":"$n","containerName":"fu_and_li_D_star_counts","line":379,"kind":13},{"containerName":"fu_and_li_D_star_counts","name":"$n","kind":13,"line":379},{"kind":13,"line":379,"containerName":"fu_and_li_D_star_counts","name":"$b"},{"name":"$a_n","containerName":"fu_and_li_D_star_counts","kind":13,"line":379},{"containerName":"fu_and_li_D_star_counts","name":"$d","line":379,"kind":13},{"line":380,"kind":13,"name":"$n","containerName":"fu_and_li_D_star_counts"},{"containerName":"fu_and_li_D_star_counts","name":"$a_n","line":380,"kind":13},{"containerName":"fu_and_li_D_star_counts","name":"$a_n","line":380,"kind":13},{"name":"$n","containerName":"fu_and_li_D_star_counts","line":380,"kind":13},{"containerName":"fu_and_li_D_star_counts","name":"$a_n","kind":13,"line":381},{"line":381,"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$b"},{"kind":13,"line":383,"containerName":"fu_and_li_D_star_counts","definition":"my","name":"$u_star","localvar":"my"},{"containerName":"fu_and_li_D_star_counts","name":"$n","line":383,"kind":13},{"containerName":"fu_and_li_D_star_counts","name":"$n","kind":13,"line":383},{"name":"$a_n","containerName":"fu_and_li_D_star_counts","kind":13,"line":384},{"line":384,"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$n"},{"containerName":"fu_and_li_D_star_counts","name":"$n","kind":13,"line":385},{"name":"$v_star","containerName":"fu_and_li_D_star_counts","line":385,"kind":13},{"line":388,"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$n"},{"kind":13,"line":388,"name":"$n","containerName":"fu_and_li_D_star_counts"},{"containerName":"fu_and_li_D_star_counts","name":"$seg_sites","kind":13,"line":388},{"containerName":"fu_and_li_D_star_counts","name":"$a_n","kind":13,"line":389},{"kind":13,"line":389,"containerName":"fu_and_li_D_star_counts","name":"$singletons"},{"name":"$u_star","containerName":"fu_and_li_D_star_counts","line":390,"kind":13},{"line":390,"kind":13,"containerName":"fu_and_li_D_star_counts","name":"$seg_sites"},{"kind":13,"line":390,"containerName":"fu_and_li_D_star_counts","name":"$v_star"},{"containerName":"fu_and_li_D_star_counts","name":"$seg_sites","line":390,"kind":13},{"name":"$seg_sites","containerName":"fu_and_li_D_star_counts","line":390,"kind":13}],"line":357,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$n"},{"label":"$seg_sites"},{"label":"$singletons"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)","label":"fu_and_li_D_star_counts($self,$n,$seg_sites,$singletons)"},"detail":"($self,$n,$seg_sites,$singletons)","name":"fu_and_li_D_star_counts","range":{"start":{"line":357,"character":0},"end":{"character":9999,"line":391}}},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"fu_and_li_F","line":410,"kind":13},{"containerName":"fu_and_li_F","name":"$ingroup","line":410,"kind":13},{"name":"$outgroup","containerName":"fu_and_li_F","kind":13,"line":410},{"line":411,"kind":13,"localvar":"my","containerName":"fu_and_li_F","name":"$seg_sites","definition":"my"},{"containerName":"fu_and_li_F","name":"$pi","kind":13,"line":411},{"name":"$n","containerName":"fu_and_li_F","kind":13,"line":411},{"kind":13,"line":411,"containerName":"fu_and_li_F","name":"$external"},{"name":"$internal","containerName":"fu_and_li_F","line":411,"kind":13},{"line":412,"kind":13,"name":"$ingroup","containerName":"fu_and_li_F"},{"line":413,"kind":13,"name":"$n","containerName":"fu_and_li_F"},{"kind":13,"line":413,"containerName":"fu_and_li_F","name":"$ingroup"},{"line":415,"kind":13,"containerName":"fu_and_li_F","name":"$pi"},{"kind":13,"line":415,"name":"$self","containerName":"fu_and_li_F"},{"name":"pi","containerName":"fu_and_li_F","line":415,"kind":12},{"kind":13,"line":415,"containerName":"fu_and_li_F","name":"$ingroup"},{"containerName":"fu_and_li_F","name":"$seg_sites","kind":13,"line":416},{"name":"$self","containerName":"fu_and_li_F","kind":13,"line":416},{"name":"segregating_sites_count","containerName":"fu_and_li_F","line":416,"kind":12},{"name":"$ingroup","containerName":"fu_and_li_F","kind":13,"line":416},{"line":417,"kind":13,"name":"$ingroup","containerName":"fu_and_li_F"},{"line":418,"kind":13,"name":"$ingroup","containerName":"fu_and_li_F"},{"kind":12,"line":418,"name":"isa","containerName":"fu_and_li_F"},{"kind":13,"line":419,"containerName":"fu_and_li_F","name":"$n"},{"name":"$ingroup","containerName":"fu_and_li_F","kind":13,"line":419},{"line":419,"kind":12,"containerName":"fu_and_li_F","name":"get_number_individuals"},{"containerName":"fu_and_li_F","name":"$pi","kind":13,"line":420},{"line":420,"kind":13,"containerName":"fu_and_li_F","name":"$self"},{"containerName":"fu_and_li_F","name":"pi","line":420,"kind":12},{"containerName":"fu_and_li_F","name":"$ingroup","kind":13,"line":420},{"line":421,"kind":13,"name":"$seg_sites","containerName":"fu_and_li_F"},{"containerName":"fu_and_li_F","name":"$self","kind":13,"line":421},{"name":"segregating_sites_count","containerName":"fu_and_li_F","line":421,"kind":12},{"name":"$ingroup","containerName":"fu_and_li_F","line":421,"kind":13},{"kind":13,"line":423,"name":"$self","containerName":"fu_and_li_F"},{"containerName":"fu_and_li_F","name":"throw","line":423,"kind":12},{"containerName":"fu_and_li_F","name":"$outgroup","kind":13,"line":427},{"containerName":"fu_and_li_F","name":"$self","kind":13,"line":428},{"kind":12,"line":428,"containerName":"fu_and_li_F","name":"warn"},{"name":"$outgroup","containerName":"fu_and_li_F","kind":13,"line":430},{"containerName":"fu_and_li_F","name":"$external","line":431,"kind":13},{"kind":13,"line":431,"name":"$internal","containerName":"fu_and_li_F"},{"containerName":"fu_and_li_F","name":"$self","kind":13,"line":431},{"line":431,"kind":12,"containerName":"fu_and_li_F","name":"derived_mutations"},{"containerName":"fu_and_li_F","name":"$ingroup","kind":13,"line":431},{"name":"$outgroup","containerName":"fu_and_li_F","line":431,"kind":13},{"name":"$external","containerName":"fu_and_li_F","kind":13,"line":433},{"name":"$outgroup","containerName":"fu_and_li_F","kind":13,"line":433},{"containerName":"fu_and_li_F","name":"$self","kind":13,"line":435},{"kind":12,"line":435,"containerName":"fu_and_li_F","name":"fu_and_li_F_counts"},{"kind":13,"line":435,"containerName":"fu_and_li_F","name":"$n"},{"kind":13,"line":435,"name":"$pi","containerName":"fu_and_li_F"},{"kind":13,"line":435,"containerName":"fu_and_li_F","name":"$seg_sites"},{"kind":13,"line":435,"containerName":"fu_and_li_F","name":"$external"}],"line":409,"definition":"sub","containerName":"main::","signature":{"label":"fu_and_li_F($self,$ingroup,$outgroup)","documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n'","parameters":[{"label":"$self"},{"label":"$ingroup"},{"label":"$outgroup"}]},"detail":"($self,$ingroup,$outgroup)","name":"fu_and_li_F","range":{"start":{"character":0,"line":409},"end":{"character":9999,"line":436}}},{"line":455,"children":[{"containerName":"fu_and_li_F_counts","definition":"my","name":"$self","localvar":"my","kind":13,"line":456},{"line":456,"kind":13,"name":"$n","containerName":"fu_and_li_F_counts"},{"line":456,"kind":13,"name":"$pi","containerName":"fu_and_li_F_counts"},{"kind":13,"line":456,"containerName":"fu_and_li_F_counts","name":"$seg_sites"},{"kind":13,"line":456,"containerName":"fu_and_li_F_counts","name":"$external"},{"localvar":"my","containerName":"fu_and_li_F_counts","name":"$a_n","definition":"my","line":457,"kind":13},{"containerName":"fu_and_li_F_counts","name":"$k","definition":"my","localvar":"my","kind":13,"line":458},{"kind":13,"line":458,"containerName":"fu_and_li_F_counts","name":"$k"},{"containerName":"fu_and_li_F_counts","name":"$n","kind":13,"line":458},{"line":458,"kind":13,"name":"$k","containerName":"fu_and_li_F_counts"},{"line":459,"kind":13,"name":"$a_n","containerName":"fu_and_li_F_counts"},{"containerName":"fu_and_li_F_counts","name":"$k","kind":13,"line":459},{"kind":13,"line":462,"containerName":"fu_and_li_F_counts","definition":"my","name":"$a1","localvar":"my"},{"containerName":"fu_and_li_F_counts","name":"$a_n","kind":13,"line":462},{"containerName":"fu_and_li_F_counts","name":"$n","kind":13,"line":462},{"kind":13,"line":464,"containerName":"fu_and_li_F_counts","definition":"my","name":"$b","localvar":"my"},{"name":"$k","definition":"my","containerName":"fu_and_li_F_counts","localvar":"my","kind":13,"line":465},{"line":465,"kind":13,"containerName":"fu_and_li_F_counts","name":"$k"},{"line":465,"kind":13,"containerName":"fu_and_li_F_counts","name":"$n"},{"name":"$k","containerName":"fu_and_li_F_counts","line":465,"kind":13},{"line":466,"kind":13,"name":"$b","containerName":"fu_and_li_F_counts"},{"line":466,"kind":13,"containerName":"fu_and_li_F_counts","name":"$k"},{"localvar":"my","name":"$c","definition":"my","containerName":"fu_and_li_F_counts","line":469,"kind":13},{"kind":13,"line":469,"containerName":"fu_and_li_F_counts","name":"$n"},{"name":"$a_n","containerName":"fu_and_li_F_counts","line":469,"kind":13},{"kind":13,"line":469,"name":"$n","containerName":"fu_and_li_F_counts"},{"kind":13,"line":470,"name":"$n","containerName":"fu_and_li_F_counts"},{"containerName":"fu_and_li_F_counts","name":"$n","line":470,"kind":13},{"line":472,"kind":13,"localvar":"my","containerName":"fu_and_li_F_counts","definition":"my","name":"$v_F"},{"kind":13,"line":472,"name":"$c","containerName":"fu_and_li_F_counts"},{"kind":13,"line":472,"name":"$n","containerName":"fu_and_li_F_counts"},{"line":472,"kind":13,"name":"$n","containerName":"fu_and_li_F_counts"},{"containerName":"fu_and_li_F_counts","name":"$n","line":473,"kind":13},{"name":"$n","containerName":"fu_and_li_F_counts","line":473,"kind":13},{"containerName":"fu_and_li_F_counts","name":"$n","kind":13,"line":474},{"name":"$a_n","containerName":"fu_and_li_F_counts","line":474,"kind":13},{"name":"$b","containerName":"fu_and_li_F_counts","line":474,"kind":13},{"name":"$u_F","definition":"my","containerName":"fu_and_li_F_counts","localvar":"my","kind":13,"line":476},{"containerName":"fu_and_li_F_counts","name":"$n","kind":13,"line":476},{"name":"$n","containerName":"fu_and_li_F_counts","kind":13,"line":476},{"name":"$n","containerName":"fu_and_li_F_counts","line":477,"kind":13},{"kind":13,"line":477,"containerName":"fu_and_li_F_counts","name":"$n"},{"kind":13,"line":478,"name":"$a1","containerName":"fu_and_li_F_counts"},{"kind":13,"line":478,"name":"$n","containerName":"fu_and_li_F_counts"},{"line":478,"kind":13,"containerName":"fu_and_li_F_counts","name":"$n"},{"kind":13,"line":479,"name":"$a_n","containerName":"fu_and_li_F_counts"},{"name":"$v_F","containerName":"fu_and_li_F_counts","kind":13,"line":479},{"localvar":"my","containerName":"fu_and_li_F_counts","definition":"my","name":"$F","line":482,"kind":13},{"kind":13,"line":482,"name":"$pi","containerName":"fu_and_li_F_counts"},{"line":482,"kind":13,"name":"$external","containerName":"fu_and_li_F_counts"},{"containerName":"fu_and_li_F_counts","name":"$u_F","kind":13,"line":482},{"line":482,"kind":13,"containerName":"fu_and_li_F_counts","name":"$seg_sites"},{"kind":13,"line":483,"name":"$v_F","containerName":"fu_and_li_F_counts"},{"name":"$seg_sites","containerName":"fu_and_li_F_counts","line":483,"kind":13},{"name":"$F","containerName":"fu_and_li_F_counts","kind":13,"line":485}],"kind":12,"detail":"($self,$n,$pi,$seg_sites,$external)","signature":{"label":"fu_and_li_F_counts($self,$n,$pi,$seg_sites,$external)","documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)","parameters":[{"label":"$self"},{"label":"$n"},{"label":"$pi"},{"label":"$seg_sites"},{"label":"$external"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":455},"end":{"character":9999,"line":486}},"name":"fu_and_li_F_counts"},{"name":"fu_and_li_F_star","range":{"start":{"line":503,"character":0},"end":{"character":9999,"line":528}},"kind":12,"children":[{"kind":13,"line":504,"name":"$self","definition":"my","containerName":"fu_and_li_F_star","localvar":"my"},{"kind":13,"line":504,"containerName":"fu_and_li_F_star","name":"$individuals"},{"name":"$seg_sites","definition":"my","containerName":"fu_and_li_F_star","localvar":"my","kind":13,"line":506},{"kind":13,"line":506,"name":"$pi","containerName":"fu_and_li_F_star"},{"name":"$n","containerName":"fu_and_li_F_star","kind":13,"line":506},{"containerName":"fu_and_li_F_star","name":"$singletons","kind":13,"line":506},{"line":507,"kind":13,"name":"$individuals","containerName":"fu_and_li_F_star"},{"containerName":"fu_and_li_F_star","name":"$n","line":508,"kind":13},{"kind":13,"line":508,"name":"$individuals","containerName":"fu_and_li_F_star"},{"containerName":"fu_and_li_F_star","name":"$pi","line":510,"kind":13},{"kind":13,"line":510,"name":"$self","containerName":"fu_and_li_F_star"},{"line":510,"kind":12,"name":"pi","containerName":"fu_and_li_F_star"},{"kind":13,"line":510,"containerName":"fu_and_li_F_star","name":"$individuals"},{"line":511,"kind":13,"name":"$seg_sites","containerName":"fu_and_li_F_star"},{"containerName":"fu_and_li_F_star","name":"$self","kind":13,"line":511},{"containerName":"fu_and_li_F_star","name":"segregating_sites_count","kind":12,"line":511},{"name":"$individuals","containerName":"fu_and_li_F_star","kind":13,"line":511},{"kind":13,"line":512,"name":"$singletons","containerName":"fu_and_li_F_star"},{"line":512,"kind":13,"name":"$self","containerName":"fu_and_li_F_star"},{"line":512,"kind":12,"containerName":"fu_and_li_F_star","name":"singleton_count"},{"name":"$individuals","containerName":"fu_and_li_F_star","kind":13,"line":512},{"kind":13,"line":513,"containerName":"fu_and_li_F_star","name":"$individuals"},{"containerName":"fu_and_li_F_star","name":"$individuals","line":514,"kind":13},{"kind":12,"line":514,"name":"isa","containerName":"fu_and_li_F_star"},{"containerName":"fu_and_li_F_star","name":"$pop","definition":"my","localvar":"my","kind":13,"line":515},{"containerName":"fu_and_li_F_star","name":"$individuals","line":515,"kind":13},{"containerName":"fu_and_li_F_star","name":"$n","kind":13,"line":516},{"line":516,"kind":13,"name":"$pop","containerName":"fu_and_li_F_star"},{"containerName":"fu_and_li_F_star","name":"get_number_individuals","line":516,"kind":12},{"containerName":"fu_and_li_F_star","name":"$pi","kind":13,"line":517},{"name":"$self","containerName":"fu_and_li_F_star","kind":13,"line":517},{"line":517,"kind":12,"name":"pi","containerName":"fu_and_li_F_star"},{"containerName":"fu_and_li_F_star","name":"$pop","line":517,"kind":13},{"kind":13,"line":518,"containerName":"fu_and_li_F_star","name":"$seg_sites"},{"kind":13,"line":518,"name":"$self","containerName":"fu_and_li_F_star"},{"line":518,"kind":12,"containerName":"fu_and_li_F_star","name":"segregating_sites_count"},{"kind":13,"line":518,"name":"$pop","containerName":"fu_and_li_F_star"},{"containerName":"fu_and_li_F_star","name":"$singletons","line":519,"kind":13},{"line":519,"kind":13,"name":"$self","containerName":"fu_and_li_F_star"},{"line":519,"kind":12,"containerName":"fu_and_li_F_star","name":"singleton_count"},{"name":"$pop","containerName":"fu_and_li_F_star","kind":13,"line":519},{"kind":13,"line":521,"containerName":"fu_and_li_F_star","name":"$self"},{"line":521,"kind":12,"containerName":"fu_and_li_F_star","name":"throw"},{"kind":13,"line":524,"name":"$self","containerName":"fu_and_li_F_star"},{"kind":12,"line":524,"containerName":"fu_and_li_F_star","name":"fu_and_li_F_star_counts"},{"name":"$n","containerName":"fu_and_li_F_star","kind":13,"line":524},{"kind":13,"line":525,"name":"$pi","containerName":"fu_and_li_F_star"},{"line":526,"kind":13,"name":"$seg_sites","containerName":"fu_and_li_F_star"},{"name":"$singletons","containerName":"fu_and_li_F_star","line":527,"kind":13}],"line":503,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$individuals"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n' keep my emacs happy","label":"fu_and_li_F_star($self,$individuals)"},"detail":"($self,$individuals)"},{"kind":12,"children":[{"containerName":"fu_and_li_F_star_counts","definition":"my","name":"$self","localvar":"my","kind":13,"line":548},{"name":"$n","containerName":"fu_and_li_F_star_counts","line":548,"kind":13},{"containerName":"fu_and_li_F_star_counts","name":"$pi","kind":13,"line":548},{"line":548,"kind":13,"name":"$seg_sites","containerName":"fu_and_li_F_star_counts"},{"kind":13,"line":548,"containerName":"fu_and_li_F_star_counts","name":"$singletons"},{"kind":13,"line":549,"name":"$n","containerName":"fu_and_li_F_star_counts"},{"containerName":"fu_and_li_F_star_counts","name":"$self","kind":13,"line":550},{"kind":12,"line":550,"name":"warn","containerName":"fu_and_li_F_star_counts"},{"kind":13,"line":553,"containerName":"fu_and_li_F_star_counts","name":"$n"},{"kind":13,"line":557,"containerName":"fu_and_li_F_star_counts","name":"$a_n","definition":"my","localvar":"my"},{"name":"$b","definition":"my","containerName":"fu_and_li_F_star_counts","localvar":"my","kind":13,"line":560},{"line":561,"kind":13,"localvar":"my","containerName":"fu_and_li_F_star_counts","name":"$k","definition":"my"},{"line":561,"kind":13,"name":"$k","containerName":"fu_and_li_F_star_counts"},{"containerName":"fu_and_li_F_star_counts","name":"$n","kind":13,"line":561},{"line":561,"kind":13,"containerName":"fu_and_li_F_star_counts","name":"$k"},{"line":562,"kind":13,"name":"$b","containerName":"fu_and_li_F_star_counts"},{"line":562,"kind":13,"name":"$k","containerName":"fu_and_li_F_star_counts"},{"containerName":"fu_and_li_F_star_counts","name":"$a_n","line":563,"kind":13},{"containerName":"fu_and_li_F_star_counts","name":"$k","line":563,"kind":13},{"kind":13,"line":565,"name":"$a1","definition":"my","containerName":"fu_and_li_F_star_counts","localvar":"my"},{"name":"$a_n","containerName":"fu_and_li_F_star_counts","kind":13,"line":565},{"containerName":"fu_and_li_F_star_counts","name":"$n","line":565,"kind":13},{"localvar":"my","containerName":"fu_and_li_F_star_counts","name":"$v_F_star","definition":"my","line":570,"kind":13},{"kind":13,"line":570,"containerName":"fu_and_li_F_star_counts","name":"$n"},{"line":570,"kind":13,"containerName":"fu_and_li_F_star_counts","name":"$n"},{"line":570,"kind":13,"name":"$n","containerName":"fu_and_li_F_star_counts"},{"containerName":"fu_and_li_F_star_counts","name":"$n","line":571,"kind":13},{"kind":13,"line":571,"name":"$n","containerName":"fu_and_li_F_star_counts"},{"line":572,"kind":13,"name":"$n","containerName":"fu_and_li_F_star_counts"},{"line":572,"kind":13,"containerName":"fu_and_li_F_star_counts","name":"$a_n"},{"line":572,"kind":13,"name":"$n","containerName":"fu_and_li_F_star_counts"},{"containerName":"fu_and_li_F_star_counts","name":"$b","kind":13,"line":573},{"containerName":"fu_and_li_F_star_counts","name":"$n","kind":13,"line":573},{"kind":13,"line":574,"name":"$a_n","containerName":"fu_and_li_F_star_counts"},{"name":"$b","containerName":"fu_and_li_F_star_counts","kind":13,"line":574},{"line":576,"kind":13,"localvar":"my","definition":"my","name":"$u_F_star","containerName":"fu_and_li_F_star_counts"},{"name":"$n","containerName":"fu_and_li_F_star_counts","kind":13,"line":576},{"name":"$n","containerName":"fu_and_li_F_star_counts","kind":13,"line":576},{"line":576,"kind":13,"name":"$n","containerName":"fu_and_li_F_star_counts"},{"name":"$a1","containerName":"fu_and_li_F_star_counts","line":576,"kind":13},{"line":577,"kind":13,"name":"$n","containerName":"fu_and_li_F_star_counts"},{"line":577,"kind":13,"containerName":"fu_and_li_F_star_counts","name":"$n"},{"containerName":"fu_and_li_F_star_counts","name":"$a_n","kind":13,"line":577},{"kind":13,"line":577,"name":"$v_F_star","containerName":"fu_and_li_F_star_counts"},{"localvar":"my","containerName":"fu_and_li_F_star_counts","definition":"my","name":"$F_star","line":580,"kind":13},{"line":580,"kind":13,"name":"$pi","containerName":"fu_and_li_F_star_counts"},{"containerName":"fu_and_li_F_star_counts","name":"$singletons","kind":13,"line":580},{"kind":13,"line":580,"name":"$n","containerName":"fu_and_li_F_star_counts"},{"line":580,"kind":13,"name":"$n","containerName":"fu_and_li_F_star_counts"},{"line":581,"kind":13,"containerName":"fu_and_li_F_star_counts","name":"$u_F_star"},{"name":"$seg_sites","containerName":"fu_and_li_F_star_counts","kind":13,"line":581},{"name":"$v_F_star","containerName":"fu_and_li_F_star_counts","kind":13,"line":581},{"line":581,"kind":13,"containerName":"fu_and_li_F_star_counts","name":"$seg_sites"},{"name":"$F_star","containerName":"fu_and_li_F_star_counts","kind":13,"line":582}],"line":547,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)","parameters":[{"label":"$self"},{"label":"$n"},{"label":"$pi"},{"label":"$seg_sites"},{"label":"$singletons"}],"label":"fu_and_li_F_star_counts($self,$n,$pi,$seg_sites,$singletons)"},"detail":"($self,$n,$pi,$seg_sites,$singletons)","name":"fu_and_li_F_star_counts","range":{"start":{"character":0,"line":547},"end":{"character":9999,"line":583}}},{"signature":{"label":"tajima_D($self,$individuals)","parameters":[{"label":"$self"},{"label":"$individuals"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n'"},"detail":"($self,$individuals)","definition":"sub","containerName":"main::","children":[{"containerName":"tajima_D","name":"$self","definition":"my","localvar":"my","kind":13,"line":601},{"name":"$individuals","containerName":"tajima_D","kind":13,"line":601},{"kind":13,"line":602,"name":"$seg_sites","definition":"my","containerName":"tajima_D","localvar":"my"},{"line":602,"kind":13,"containerName":"tajima_D","name":"$pi"},{"name":"$n","containerName":"tajima_D","kind":13,"line":602},{"kind":13,"line":604,"containerName":"tajima_D","name":"$individuals"},{"line":605,"kind":13,"name":"$n","containerName":"tajima_D"},{"name":"$individuals","containerName":"tajima_D","line":605,"kind":13},{"line":607,"kind":13,"containerName":"tajima_D","name":"$pi"},{"kind":13,"line":607,"name":"$self","containerName":"tajima_D"},{"containerName":"tajima_D","name":"pi","kind":12,"line":607},{"containerName":"tajima_D","name":"$individuals","line":607,"kind":13},{"kind":13,"line":608,"name":"$seg_sites","containerName":"tajima_D"},{"line":608,"kind":13,"containerName":"tajima_D","name":"$self"},{"containerName":"tajima_D","name":"segregating_sites_count","kind":12,"line":608},{"kind":13,"line":608,"containerName":"tajima_D","name":"$individuals"},{"containerName":"tajima_D","name":"$individuals","kind":13,"line":610},{"kind":13,"line":611,"containerName":"tajima_D","name":"$individuals"},{"containerName":"tajima_D","name":"isa","kind":12,"line":611},{"kind":13,"line":612,"name":"$pop","definition":"my","containerName":"tajima_D","localvar":"my"},{"line":612,"kind":13,"name":"$individuals","containerName":"tajima_D"},{"containerName":"tajima_D","name":"$n","kind":13,"line":613},{"line":613,"kind":13,"containerName":"tajima_D","name":"$pop"},{"kind":12,"line":613,"containerName":"tajima_D","name":"get_number_individuals"},{"kind":13,"line":614,"containerName":"tajima_D","name":"$pi"},{"name":"$self","containerName":"tajima_D","kind":13,"line":614},{"name":"pi","containerName":"tajima_D","kind":12,"line":614},{"containerName":"tajima_D","name":"$pop","kind":13,"line":614},{"name":"$seg_sites","containerName":"tajima_D","kind":13,"line":615},{"containerName":"tajima_D","name":"$self","line":615,"kind":13},{"kind":12,"line":615,"containerName":"tajima_D","name":"segregating_sites_count"},{"name":"$pop","containerName":"tajima_D","line":615,"kind":13},{"line":617,"kind":13,"containerName":"tajima_D","name":"$self"},{"name":"throw","containerName":"tajima_D","kind":12,"line":617},{"name":"$self","containerName":"tajima_D","kind":13,"line":620},{"containerName":"tajima_D","name":"tajima_D_counts","kind":12,"line":620},{"line":620,"kind":13,"name":"$n","containerName":"tajima_D"},{"containerName":"tajima_D","name":"$seg_sites","kind":13,"line":620},{"name":"$pi","containerName":"tajima_D","kind":13,"line":620}],"line":600,"kind":12,"range":{"end":{"line":621,"character":9999},"start":{"line":600,"character":0}},"name":"tajima_D"},{"kind":12,"line":638,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"tajima_D_counts","line":639,"kind":13},{"containerName":"tajima_D_counts","name":"$n","kind":13,"line":639},{"name":"$seg_sites","containerName":"tajima_D_counts","kind":13,"line":639},{"line":639,"kind":13,"containerName":"tajima_D_counts","name":"$pi"},{"definition":"my","name":"$a1","containerName":"tajima_D_counts","localvar":"my","kind":13,"line":640},{"line":641,"kind":13,"localvar":"my","name":"$k","definition":"my","containerName":"tajima_D_counts"},{"line":641,"kind":13,"containerName":"tajima_D_counts","name":"$k"},{"line":641,"kind":13,"name":"$n","containerName":"tajima_D_counts"},{"name":"$k","containerName":"tajima_D_counts","line":641,"kind":13},{"line":642,"kind":13,"containerName":"tajima_D_counts","name":"$a1"},{"line":642,"kind":13,"containerName":"tajima_D_counts","name":"$k"},{"line":645,"kind":13,"localvar":"my","containerName":"tajima_D_counts","name":"$a2","definition":"my"},{"localvar":"my","name":"$k","definition":"my","containerName":"tajima_D_counts","line":646,"kind":13},{"line":646,"kind":13,"name":"$k","containerName":"tajima_D_counts"},{"containerName":"tajima_D_counts","name":"$n","line":646,"kind":13},{"kind":13,"line":646,"name":"$k","containerName":"tajima_D_counts"},{"containerName":"tajima_D_counts","name":"$a2","kind":13,"line":647},{"line":647,"kind":13,"name":"$k","containerName":"tajima_D_counts"},{"kind":13,"line":650,"containerName":"tajima_D_counts","name":"$b1","definition":"my","localvar":"my"},{"kind":13,"line":650,"containerName":"tajima_D_counts","name":"$n"},{"name":"$n","containerName":"tajima_D_counts","line":650,"kind":13},{"localvar":"my","containerName":"tajima_D_counts","definition":"my","name":"$b2","line":651,"kind":13},{"kind":13,"line":651,"containerName":"tajima_D_counts","name":"$n"},{"name":"$n","containerName":"tajima_D_counts","kind":13,"line":651},{"name":"$n","containerName":"tajima_D_counts","line":652,"kind":13},{"kind":13,"line":652,"name":"$n","containerName":"tajima_D_counts"},{"line":653,"kind":13,"localvar":"my","containerName":"tajima_D_counts","definition":"my","name":"$c1"},{"containerName":"tajima_D_counts","name":"$b1","kind":13,"line":653},{"kind":13,"line":653,"containerName":"tajima_D_counts","name":"$a1"},{"kind":13,"line":654,"name":"$c2","definition":"my","containerName":"tajima_D_counts","localvar":"my"},{"line":654,"kind":13,"name":"$b2","containerName":"tajima_D_counts"},{"containerName":"tajima_D_counts","name":"$n","kind":13,"line":654},{"containerName":"tajima_D_counts","name":"$a1","line":655,"kind":13},{"name":"$n","containerName":"tajima_D_counts","line":655,"kind":13},{"line":655,"kind":13,"containerName":"tajima_D_counts","name":"$a2"},{"name":"$a1","containerName":"tajima_D_counts","line":655,"kind":13},{"line":656,"kind":13,"localvar":"my","containerName":"tajima_D_counts","definition":"my","name":"$e1"},{"kind":13,"line":656,"containerName":"tajima_D_counts","name":"$c1"},{"name":"$a1","containerName":"tajima_D_counts","line":656,"kind":13},{"localvar":"my","name":"$e2","definition":"my","containerName":"tajima_D_counts","line":657,"kind":13},{"kind":13,"line":657,"name":"$c2","containerName":"tajima_D_counts"},{"containerName":"tajima_D_counts","name":"$a1","line":657,"kind":13},{"kind":13,"line":657,"containerName":"tajima_D_counts","name":"$a2"},{"kind":13,"line":659,"definition":"my","name":"$denom","containerName":"tajima_D_counts","localvar":"my"},{"containerName":"tajima_D_counts","name":"$e1","kind":13,"line":659},{"name":"$seg_sites","containerName":"tajima_D_counts","line":659,"kind":13},{"containerName":"tajima_D_counts","name":"$e2","line":659,"kind":13},{"containerName":"tajima_D_counts","name":"$seg_sites","kind":13,"line":659},{"kind":13,"line":659,"containerName":"tajima_D_counts","name":"$seg_sites"},{"containerName":"tajima_D_counts","name":"$denom","kind":13,"line":660},{"kind":13,"line":661,"containerName":"tajima_D_counts","name":"$D","definition":"my","localvar":"my"},{"line":661,"kind":13,"containerName":"tajima_D_counts","name":"$pi"},{"containerName":"tajima_D_counts","name":"$seg_sites","line":661,"kind":13},{"kind":13,"line":661,"name":"$a1","containerName":"tajima_D_counts"},{"containerName":"tajima_D_counts","name":"$denom","kind":13,"line":661},{"containerName":"tajima_D_counts","name":"$D","line":662,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$n,$seg_sites,$pi)","signature":{"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n'","parameters":[{"label":"$self"},{"label":"$n"},{"label":"$seg_sites"},{"label":"$pi"}],"label":"tajima_D_counts($self,$n,$seg_sites,$pi)"},"name":"tajima_D_counts","range":{"end":{"character":9999,"line":663},"start":{"line":638,"character":0}}},{"name":"pi","range":{"end":{"line":755,"character":9999},"start":{"character":0,"line":687}},"kind":12,"line":687,"children":[{"localvar":"my","containerName":"pi","name":"$self","definition":"my","line":688,"kind":13},{"name":"$individuals","containerName":"pi","kind":13,"line":688},{"line":688,"kind":13,"name":"$numsites","containerName":"pi"},{"kind":13,"line":689,"definition":"my","name":"%data","containerName":"pi","localvar":"my"},{"name":"%marker_total","containerName":"pi","kind":13,"line":689},{"containerName":"pi","name":"@marker_names","line":689,"kind":13},{"line":689,"kind":13,"containerName":"pi","name":"$n"},{"line":691,"kind":13,"name":"$individuals","containerName":"pi"},{"containerName":"pi","name":"@marker_names","kind":13,"line":693},{"kind":13,"line":693,"name":"$individuals","containerName":"pi"},{"line":693,"kind":12,"name":"get_marker_names","containerName":"pi"},{"name":"$n","containerName":"pi","kind":13,"line":694},{"kind":13,"line":694,"name":"$individuals","containerName":"pi"},{"kind":13,"line":697,"definition":"my","name":"$ind","containerName":"pi","localvar":"my"},{"containerName":"pi","name":"$individuals","line":697,"kind":13},{"kind":13,"line":698,"name":"$ind","containerName":"pi"},{"line":698,"kind":12,"name":"isa","containerName":"pi"},{"kind":13,"line":699,"containerName":"pi","name":"$self"},{"line":699,"kind":12,"containerName":"pi","name":"warn"},{"name":"$ind","containerName":"pi","line":699,"kind":13},{"definition":"my","name":"$m","containerName":"pi","localvar":"my","kind":13,"line":702},{"name":"@marker_names","containerName":"pi","line":702,"kind":13},{"localvar":"my","containerName":"pi","definition":"my","name":"$allele","line":703,"kind":13},{"name":"get_Alleles","containerName":"pi","kind":12,"line":703},{"name":"$ind","containerName":"pi","line":704,"kind":13},{"line":704,"kind":12,"name":"get_Genotypes","containerName":"pi"},{"name":"$m","containerName":"pi","line":704,"kind":13},{"kind":13,"line":705,"name":"$data","containerName":"pi"},{"containerName":"pi","name":"$m","line":705,"kind":13},{"containerName":"pi","name":"$allele","line":705,"kind":13},{"containerName":"pi","name":"$marker_total","kind":13,"line":706},{"kind":13,"line":706,"name":"$m","containerName":"pi"},{"containerName":"pi","name":"$individuals","kind":13,"line":716},{"name":"$individuals","containerName":"pi","kind":13,"line":717},{"line":717,"kind":12,"containerName":"pi","name":"isa"},{"kind":13,"line":718,"name":"$pop","definition":"my","containerName":"pi","localvar":"my"},{"name":"$individuals","containerName":"pi","kind":13,"line":718},{"kind":13,"line":719,"containerName":"pi","name":"$n"},{"containerName":"pi","name":"$pop","line":719,"kind":13},{"name":"get_number_individuals","containerName":"pi","kind":12,"line":719},{"kind":13,"line":720,"containerName":"pi","definition":"my","name":"$marker","localvar":"my"},{"containerName":"pi","name":"$pop","line":720,"kind":13},{"line":720,"kind":12,"containerName":"pi","name":"get_Markers"},{"kind":13,"line":721,"containerName":"pi","name":"@marker_names"},{"name":"$marker","containerName":"pi","kind":13,"line":721},{"line":721,"kind":12,"name":"name","containerName":"pi"},{"localvar":"my","definition":"my","name":"@genotypes","containerName":"pi","line":723,"kind":13},{"containerName":"pi","name":"$pop","line":723,"kind":13},{"containerName":"pi","name":"get_Genotypes","kind":12,"line":723},{"containerName":"pi","name":"$marker","line":723,"kind":13},{"name":"name","containerName":"pi","kind":12,"line":723},{"line":724,"kind":13,"localvar":"my","name":"$al","definition":"my","containerName":"pi"},{"line":724,"kind":12,"containerName":"pi","name":"get_Alleles"},{"kind":13,"line":724,"containerName":"pi","name":"@genotypes"},{"name":"$data","containerName":"pi","line":725,"kind":13},{"kind":13,"line":725,"name":"$marker","containerName":"pi"},{"containerName":"pi","name":"name","kind":12,"line":725},{"name":"$al","containerName":"pi","kind":13,"line":725},{"name":"$marker_total","containerName":"pi","kind":13,"line":726},{"containerName":"pi","name":"$marker","line":726,"kind":13},{"kind":12,"line":726,"containerName":"pi","name":"name"},{"name":"$self","containerName":"pi","line":730,"kind":13},{"kind":12,"line":730,"containerName":"pi","name":"throw"},{"kind":13,"line":735,"containerName":"pi","name":"$diffcount","definition":"my","localvar":"my"},{"line":735,"kind":13,"containerName":"pi","name":"$totalcompare"},{"kind":13,"line":736,"containerName":"pi","definition":"my","name":"$pi","localvar":"my"},{"localvar":"my","name":"$marker","definition":"my","containerName":"pi","line":737,"kind":13},{"line":737,"kind":13,"containerName":"pi","name":"$markerdat"},{"name":"%data","containerName":"pi","line":737,"kind":13},{"kind":13,"line":738,"definition":"my","name":"$sampsize","containerName":"pi","localvar":"my"},{"kind":13,"line":738,"containerName":"pi","name":"$marker_total"},{"containerName":"pi","name":"$marker","kind":13,"line":738},{"line":739,"kind":13,"localvar":"my","containerName":"pi","name":"$ssh","definition":"my"},{"line":740,"kind":13,"localvar":"my","definition":"my","name":"@alleles","containerName":"pi"},{"kind":13,"line":740,"name":"$markerdat","containerName":"pi"},{"kind":13,"line":741,"containerName":"pi","name":"$sampsize"},{"kind":13,"line":742,"containerName":"pi","definition":"my","name":"$denom","localvar":"my"},{"containerName":"pi","name":"$sampsize","line":742,"kind":13},{"name":"$sampsize","containerName":"pi","line":742,"kind":13},{"definition":"my","name":"$al","containerName":"pi","localvar":"my","kind":13,"line":743},{"kind":13,"line":743,"containerName":"pi","name":"@alleles"},{"name":"$ssh","containerName":"pi","line":744,"kind":13},{"kind":13,"line":744,"containerName":"pi","name":"$markerdat"},{"name":"$al","containerName":"pi","kind":13,"line":744},{"containerName":"pi","name":"$markerdat","line":744,"kind":13},{"kind":13,"line":744,"name":"$al","containerName":"pi"},{"name":"$denom","containerName":"pi","kind":13,"line":744},{"containerName":"pi","name":"$pi","line":746,"kind":13},{"containerName":"pi","name":"$ssh","kind":13,"line":746},{"kind":13,"line":749,"containerName":"pi","name":"$self"},{"line":749,"kind":12,"name":"debug","containerName":"pi"},{"kind":13,"line":750,"name":"$numsites","containerName":"pi"},{"containerName":"pi","name":"$pi","line":751,"kind":13},{"containerName":"pi","name":"$numsites","line":751,"kind":13},{"name":"$pi","containerName":"pi","kind":13,"line":753}],"containerName":"main::","definition":"sub","detail":"($self,$individuals,$numsites)","signature":{"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.","parameters":[{"label":"$self"},{"label":"$individuals"},{"label":"$numsites"}],"label":"pi($self,$individuals,$numsites)"}},{"children":[{"name":"$self","definition":"my","containerName":"theta","localvar":"my","kind":13,"line":783},{"kind":13,"line":784,"containerName":"theta","definition":"my","name":"$n","localvar":"my"},{"kind":13,"line":784,"name":"$seg_sites","containerName":"theta"},{"containerName":"theta","name":"$totalsites","line":784,"kind":13},{"line":785,"kind":13,"name":"$n","containerName":"theta"},{"kind":13,"line":786,"containerName":"theta","name":"$samps","definition":"my","localvar":"my"},{"kind":13,"line":786,"containerName":"theta","name":"$n"},{"line":787,"kind":13,"containerName":"theta","name":"$totalsites"},{"name":"$seg_sites","containerName":"theta","line":787,"kind":13},{"kind":13,"line":788,"name":"%data","definition":"my","containerName":"theta","localvar":"my"},{"localvar":"my","name":"@marker_names","definition":"my","containerName":"theta","line":789,"kind":13},{"name":"$samps","containerName":"theta","line":789,"kind":13},{"line":789,"kind":12,"name":"get_marker_names","containerName":"theta"},{"name":"$seg_sites","containerName":"theta","line":791,"kind":13},{"line":791,"kind":13,"name":"$self","containerName":"theta"},{"line":791,"kind":12,"containerName":"theta","name":"segregating_sites_count"},{"kind":13,"line":791,"containerName":"theta","name":"$samps"},{"name":"$n","containerName":"theta","line":792,"kind":13},{"containerName":"theta","name":"$samps","kind":13,"line":792},{"name":"$n","containerName":"theta","kind":13,"line":794},{"line":795,"kind":13,"name":"$n","containerName":"theta"},{"name":"isa","containerName":"theta","kind":12,"line":795},{"definition":"my","name":"$pop","containerName":"theta","localvar":"my","kind":13,"line":797},{"containerName":"theta","name":"$n","line":797,"kind":13},{"line":798,"kind":13,"name":"$totalsites","containerName":"theta"},{"kind":13,"line":798,"containerName":"theta","name":"$seg_sites"},{"name":"$n","containerName":"theta","kind":13,"line":799},{"line":799,"kind":13,"containerName":"theta","name":"$pop"},{"kind":12,"line":799,"name":"haploid_population","containerName":"theta"},{"line":799,"kind":12,"containerName":"theta","name":"get_number_individuals"},{"name":"$seg_sites","containerName":"theta","kind":13,"line":800},{"name":"$self","containerName":"theta","line":800,"kind":13},{"containerName":"theta","name":"segregating_sites_count","kind":12,"line":800},{"containerName":"theta","name":"$pop","kind":13,"line":800},{"line":802,"kind":13,"localvar":"my","name":"$a1","definition":"my","containerName":"theta"},{"kind":13,"line":803,"containerName":"theta","name":"$k","definition":"my","localvar":"my"},{"containerName":"theta","name":"$k","kind":13,"line":803},{"line":803,"kind":13,"containerName":"theta","name":"$n"},{"containerName":"theta","name":"$k","kind":13,"line":803},{"name":"$a1","containerName":"theta","kind":13,"line":804},{"containerName":"theta","name":"$k","line":804,"kind":13},{"name":"$totalsites","containerName":"theta","kind":13,"line":806},{"name":"$seg_sites","containerName":"theta","line":807,"kind":13},{"name":"$totalsites","containerName":"theta","line":807,"kind":13},{"name":"$a1","containerName":"theta","kind":13,"line":809},{"line":812,"kind":13,"containerName":"theta","name":"$seg_sites"},{"name":"$a1","containerName":"theta","line":812,"kind":13}],"line":782,"kind":12,"signature":{"label":"theta($n,$seg_sites,$totalsites)","documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.\n\n\nsub pi {\n    my ($self,$individuals,$numsites) = @_;\n    my (%data,%marker_total,@marker_names,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t# one possible argument is an arrayref of Bio::PopGen::IndividualI objs\n\t@marker_names = $individuals->[0]->get_marker_names;\n\t$n = scalar @$individuals;\n\n\t# Here we are calculating the allele frequencies\n\tforeach my $ind ( @$individuals ) {\n\t    if( ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t\t$self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($ind).\"\\n\");\n\t\treturn 0;\n\t    }\n\t    foreach my $m ( @marker_names ) {\n\t\tforeach my $allele (map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t    $data{$m}->{$allele}++;\n\t\t    $marker_total{$m}++;\n\t\t}\n\t    }\n\t}\n#\twhile( my ($marker,$count) =  each %marker_total ) {\n#\t    foreach my $c ( values %{$data{$marker}} ) {\n#\t\t$c /= $count;\n#\t    }\n#\t}\n\t# %data will contain allele frequencies for each marker, allele\n    } elsif( ref($individuals) &&\n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\tforeach my $marker( $pop->get_Markers ) {\n\t    push @marker_names, $marker->name;\n\t    #$data{$marker->name} = {$marker->get_Allele_Frequencies};\n\t    my @genotypes = $pop->get_Genotypes(-marker => $marker->name);\n\t    for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t      $data{$marker->name}->{$al}++;\n\t      $marker_total{$marker->name}++;\n\t   }\n\t}\n    } else {\n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI to pi\");\n    }\n    # based on Kevin Thornton's code:\n    # http://molpopgen.org/software/libsequence/doc/html/PolySNP_8cc-source.html#l00152\n    # For now we assume that all individuals have the same markers\n    my ($diffcount,$totalcompare) = (0,0);\n    my $pi = 0;\n    while ( my ($marker,$markerdat) = each %data ) {\n      my $sampsize = $marker_total{$marker};\n      my $ssh = 0;\n      my @alleles = keys %$markerdat;\n      if ( $sampsize > 1 ) {\n\tmy $denom = $sampsize * ($sampsize - 1.0);\n\tforeach my $al ( @alleles ) {\n\t  $ssh += ($markerdat->{$al} * ($markerdat->{$al} - 1)) / $denom;\n\t}\n\t$pi += 1.0 - $ssh;\n      }\n    }\n    $self->debug( \"pi=$pi\\n\");\n    if( $numsites ) {\n\treturn $pi / $numsites;\n    } else {\n\treturn $pi;\n    }\n}\n\n\n=head2 theta\n\n Title   : theta\n Usage   : my $theta = Bio::PopGen::Statistics->theta($sampsize,$segsites);\n Function: Calculates Watterson's theta from the sample size \n           and the number of segregating sites.\n           Providing the third parameter, total number of sites will\n           return theta per site.\n           This is also known as K-hat = K / a_n   \n Returns : decimal number \n Args    : sample size (integer),\n           num segregating sites (integer)\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an arrayref of the L<Bio::PopGen::IndividualI> objects\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an L<Bio::PopGen::PopulationI> object\n           total sites (integer)[optional]\n\n'","parameters":[{"label":"$n"},{"label":"$seg_sites"},{"label":"$totalsites"}]},"detail":"($n,$seg_sites,$totalsites)","definition":"sub","containerName":"main::","range":{"end":{"line":813,"character":9999},"start":{"character":0,"line":782}},"name":"theta"},{"range":{"end":{"line":870,"character":9999},"start":{"line":828,"character":0}},"name":"singleton_count","detail":"($self,$individuals)","signature":{"label":"singleton_count($self,$individuals)","documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.\n\n\nsub pi {\n    my ($self,$individuals,$numsites) = @_;\n    my (%data,%marker_total,@marker_names,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t# one possible argument is an arrayref of Bio::PopGen::IndividualI objs\n\t@marker_names = $individuals->[0]->get_marker_names;\n\t$n = scalar @$individuals;\n\n\t# Here we are calculating the allele frequencies\n\tforeach my $ind ( @$individuals ) {\n\t    if( ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t\t$self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($ind).\"\\n\");\n\t\treturn 0;\n\t    }\n\t    foreach my $m ( @marker_names ) {\n\t\tforeach my $allele (map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t    $data{$m}->{$allele}++;\n\t\t    $marker_total{$m}++;\n\t\t}\n\t    }\n\t}\n#\twhile( my ($marker,$count) =  each %marker_total ) {\n#\t    foreach my $c ( values %{$data{$marker}} ) {\n#\t\t$c /= $count;\n#\t    }\n#\t}\n\t# %data will contain allele frequencies for each marker, allele\n    } elsif( ref($individuals) &&\n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\tforeach my $marker( $pop->get_Markers ) {\n\t    push @marker_names, $marker->name;\n\t    #$data{$marker->name} = {$marker->get_Allele_Frequencies};\n\t    my @genotypes = $pop->get_Genotypes(-marker => $marker->name);\n\t    for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t      $data{$marker->name}->{$al}++;\n\t      $marker_total{$marker->name}++;\n\t   }\n\t}\n    } else {\n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI to pi\");\n    }\n    # based on Kevin Thornton's code:\n    # http://molpopgen.org/software/libsequence/doc/html/PolySNP_8cc-source.html#l00152\n    # For now we assume that all individuals have the same markers\n    my ($diffcount,$totalcompare) = (0,0);\n    my $pi = 0;\n    while ( my ($marker,$markerdat) = each %data ) {\n      my $sampsize = $marker_total{$marker};\n      my $ssh = 0;\n      my @alleles = keys %$markerdat;\n      if ( $sampsize > 1 ) {\n\tmy $denom = $sampsize * ($sampsize - 1.0);\n\tforeach my $al ( @alleles ) {\n\t  $ssh += ($markerdat->{$al} * ($markerdat->{$al} - 1)) / $denom;\n\t}\n\t$pi += 1.0 - $ssh;\n      }\n    }\n    $self->debug( \"pi=$pi\\n\");\n    if( $numsites ) {\n\treturn $pi / $numsites;\n    } else {\n\treturn $pi;\n    }\n}\n\n\n=head2 theta\n\n Title   : theta\n Usage   : my $theta = Bio::PopGen::Statistics->theta($sampsize,$segsites);\n Function: Calculates Watterson's theta from the sample size \n           and the number of segregating sites.\n           Providing the third parameter, total number of sites will\n           return theta per site.\n           This is also known as K-hat = K / a_n   \n Returns : decimal number \n Args    : sample size (integer),\n           num segregating sites (integer)\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an arrayref of the L<Bio::PopGen::IndividualI> objects\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an L<Bio::PopGen::PopulationI> object\n           total sites (integer)[optional]\n\n\n#'\n\nsub theta {\n    my $self = shift;\n    my ( $n, $seg_sites,$totalsites) = @_;\n    if( ref($n) =~ /ARRAY/i ) {\n\tmy $samps = $n;\n\t$totalsites = $seg_sites; # only 2 arguments if one is an array\n\tmy %data;\n\tmy @marker_names = $samps->[0]->get_marker_names;\n\t# we need to calculate number of polymorphic sites\n\t$seg_sites = $self->segregating_sites_count($samps);\n\t$n = scalar @$samps;\n\n    } elsif(ref($n) &&\n\t    $n->isa('Bio::PopGen::PopulationI') ) {\n\t# This will handle the case when we pass in a PopulationI object\n\tmy $pop = $n;\n\t$totalsites = $seg_sites; # shift the arguments over by one\n\t$n = $pop->haploid_population->get_number_individuals;\n\t$seg_sites = $self->segregating_sites_count($pop);\n    }\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }    \n    if( $totalsites ) { # 0 and undef are the same can't divide by them\n\t$seg_sites /= $totalsites;\n    }\n    if( $a1 == 0 ) { \n\treturn 0;\n    } \n    return $seg_sites / $a1;\n}\n\n=head2 singleton_count\n\n Title   : singleton_count\n Usage   : my ($singletons) = Bio::PopGen::Statistics->singleton_count(\\@inds)\n Function: Calculate the number of mutations/alleles which only occur once in\n           a list of individuals for all sites/markers\n Returns : (integer) number of alleles which only occur once (integer)\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object","parameters":[{"label":"$self"},{"label":"$individuals"}]},"containerName":"main::","definition":"sub","line":828,"children":[{"definition":"my","name":"$self","containerName":"singleton_count","localvar":"my","kind":13,"line":829},{"containerName":"singleton_count","name":"$individuals","kind":13,"line":829},{"containerName":"singleton_count","definition":"my","name":"@inds","localvar":"my","kind":13,"line":831},{"line":832,"kind":13,"name":"$individuals","containerName":"singleton_count"},{"line":833,"kind":13,"name":"@inds","containerName":"singleton_count"},{"containerName":"singleton_count","name":"$individuals","line":833,"kind":13},{"kind":13,"line":834,"containerName":"singleton_count","name":"$individuals"},{"kind":13,"line":835,"name":"$individuals","containerName":"singleton_count"},{"containerName":"singleton_count","name":"isa","kind":12,"line":835},{"kind":13,"line":836,"containerName":"singleton_count","definition":"my","name":"$pop","localvar":"my"},{"containerName":"singleton_count","name":"$individuals","kind":13,"line":836},{"line":837,"kind":13,"containerName":"singleton_count","name":"@inds"},{"kind":13,"line":837,"containerName":"singleton_count","name":"$pop"},{"kind":12,"line":837,"name":"get_Individuals","containerName":"singleton_count"},{"containerName":"singleton_count","name":"@inds","line":838,"kind":13},{"name":"$self","containerName":"singleton_count","line":839,"kind":13},{"containerName":"singleton_count","name":"warn","line":839,"kind":12},{"line":843,"kind":13,"containerName":"singleton_count","name":"$self"},{"containerName":"singleton_count","name":"warn","line":843,"kind":12},{"kind":13,"line":848,"containerName":"singleton_count","definition":"my","name":"$singleton_allele_ct","localvar":"my"},{"containerName":"singleton_count","name":"%sites","line":848,"kind":13},{"name":"$n","definition":"my","containerName":"singleton_count","localvar":"my","kind":13,"line":851},{"containerName":"singleton_count","name":"@inds","kind":13,"line":851},{"containerName":"singleton_count","name":"$n","line":852,"kind":13},{"kind":12,"line":852,"containerName":"singleton_count","name":"isa"},{"kind":13,"line":853,"name":"$self","containerName":"singleton_count"},{"name":"warn","containerName":"singleton_count","kind":12,"line":853},{"containerName":"singleton_count","name":"$n","line":853,"kind":13},{"localvar":"my","containerName":"singleton_count","definition":"my","name":"$g","line":856,"kind":13},{"containerName":"singleton_count","name":"$n","kind":13,"line":856},{"containerName":"singleton_count","name":"get_Genotypes","kind":12,"line":856},{"containerName":"singleton_count","name":"$nm","definition":"my","localvar":"my","kind":13,"line":857},{"kind":13,"line":857,"name":"@alleles","containerName":"singleton_count"},{"containerName":"singleton_count","name":"$g","line":857,"kind":13},{"containerName":"singleton_count","name":"marker_name","kind":12,"line":857},{"containerName":"singleton_count","name":"$g","line":857,"kind":13},{"line":857,"kind":12,"containerName":"singleton_count","name":"get_Alleles"},{"localvar":"my","name":"$allele","definition":"my","containerName":"singleton_count","line":858,"kind":13},{"line":858,"kind":13,"name":"@alleles","containerName":"singleton_count"},{"containerName":"singleton_count","name":"$sites","kind":13,"line":859},{"containerName":"singleton_count","name":"$nm","line":859,"kind":13},{"name":"$allele","containerName":"singleton_count","line":859,"kind":13},{"kind":13,"line":863,"definition":"my","name":"$site","containerName":"singleton_count","localvar":"my"},{"kind":13,"line":863,"name":"%sites","containerName":"singleton_count"},{"line":864,"kind":13,"localvar":"my","containerName":"singleton_count","definition":"my","name":"$allelect"},{"name":"$site","containerName":"singleton_count","line":864,"kind":13},{"line":866,"kind":13,"containerName":"singleton_count","name":"$singleton_allele_ct"},{"name":"$allelect","containerName":"singleton_count","kind":13,"line":866},{"kind":13,"line":869,"name":"$singleton_allele_ct","containerName":"singleton_count"}],"kind":12},{"range":{"start":{"line":894,"character":0},"end":{"line":927,"character":9999}},"name":"segregating_sites_count","signature":{"label":"segregating_sites_count($self,$individuals)","documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.\n\n\nsub pi {\n    my ($self,$individuals,$numsites) = @_;\n    my (%data,%marker_total,@marker_names,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t# one possible argument is an arrayref of Bio::PopGen::IndividualI objs\n\t@marker_names = $individuals->[0]->get_marker_names;\n\t$n = scalar @$individuals;\n\n\t# Here we are calculating the allele frequencies\n\tforeach my $ind ( @$individuals ) {\n\t    if( ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t\t$self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($ind).\"\\n\");\n\t\treturn 0;\n\t    }\n\t    foreach my $m ( @marker_names ) {\n\t\tforeach my $allele (map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t    $data{$m}->{$allele}++;\n\t\t    $marker_total{$m}++;\n\t\t}\n\t    }\n\t}\n#\twhile( my ($marker,$count) =  each %marker_total ) {\n#\t    foreach my $c ( values %{$data{$marker}} ) {\n#\t\t$c /= $count;\n#\t    }\n#\t}\n\t# %data will contain allele frequencies for each marker, allele\n    } elsif( ref($individuals) &&\n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\tforeach my $marker( $pop->get_Markers ) {\n\t    push @marker_names, $marker->name;\n\t    #$data{$marker->name} = {$marker->get_Allele_Frequencies};\n\t    my @genotypes = $pop->get_Genotypes(-marker => $marker->name);\n\t    for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t      $data{$marker->name}->{$al}++;\n\t      $marker_total{$marker->name}++;\n\t   }\n\t}\n    } else {\n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI to pi\");\n    }\n    # based on Kevin Thornton's code:\n    # http://molpopgen.org/software/libsequence/doc/html/PolySNP_8cc-source.html#l00152\n    # For now we assume that all individuals have the same markers\n    my ($diffcount,$totalcompare) = (0,0);\n    my $pi = 0;\n    while ( my ($marker,$markerdat) = each %data ) {\n      my $sampsize = $marker_total{$marker};\n      my $ssh = 0;\n      my @alleles = keys %$markerdat;\n      if ( $sampsize > 1 ) {\n\tmy $denom = $sampsize * ($sampsize - 1.0);\n\tforeach my $al ( @alleles ) {\n\t  $ssh += ($markerdat->{$al} * ($markerdat->{$al} - 1)) / $denom;\n\t}\n\t$pi += 1.0 - $ssh;\n      }\n    }\n    $self->debug( \"pi=$pi\\n\");\n    if( $numsites ) {\n\treturn $pi / $numsites;\n    } else {\n\treturn $pi;\n    }\n}\n\n\n=head2 theta\n\n Title   : theta\n Usage   : my $theta = Bio::PopGen::Statistics->theta($sampsize,$segsites);\n Function: Calculates Watterson's theta from the sample size \n           and the number of segregating sites.\n           Providing the third parameter, total number of sites will\n           return theta per site.\n           This is also known as K-hat = K / a_n   \n Returns : decimal number \n Args    : sample size (integer),\n           num segregating sites (integer)\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an arrayref of the L<Bio::PopGen::IndividualI> objects\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an L<Bio::PopGen::PopulationI> object\n           total sites (integer)[optional]\n\n\n#'\n\nsub theta {\n    my $self = shift;\n    my ( $n, $seg_sites,$totalsites) = @_;\n    if( ref($n) =~ /ARRAY/i ) {\n\tmy $samps = $n;\n\t$totalsites = $seg_sites; # only 2 arguments if one is an array\n\tmy %data;\n\tmy @marker_names = $samps->[0]->get_marker_names;\n\t# we need to calculate number of polymorphic sites\n\t$seg_sites = $self->segregating_sites_count($samps);\n\t$n = scalar @$samps;\n\n    } elsif(ref($n) &&\n\t    $n->isa('Bio::PopGen::PopulationI') ) {\n\t# This will handle the case when we pass in a PopulationI object\n\tmy $pop = $n;\n\t$totalsites = $seg_sites; # shift the arguments over by one\n\t$n = $pop->haploid_population->get_number_individuals;\n\t$seg_sites = $self->segregating_sites_count($pop);\n    }\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }    \n    if( $totalsites ) { # 0 and undef are the same can't divide by them\n\t$seg_sites /= $totalsites;\n    }\n    if( $a1 == 0 ) { \n\treturn 0;\n    } \n    return $seg_sites / $a1;\n}\n\n=head2 singleton_count\n\n Title   : singleton_count\n Usage   : my ($singletons) = Bio::PopGen::Statistics->singleton_count(\\@inds)\n Function: Calculate the number of mutations/alleles which only occur once in\n           a list of individuals for all sites/markers\n Returns : (integer) number of alleles which only occur once (integer)\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\nsub singleton_count {\n    my ($self,$individuals) = @_;\n\n    my @inds;\n    if( ref($individuals) =~ /ARRAY/ ) {\n\t@inds = @$individuals;\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t@inds = $pop->get_Individuals();\n\tunless( @inds ) { \n\t    $self->warn(\"Need to provide a population which has individuals loaded, not just a population with allele frequencies\");\n\t    return 0;\n\t}\n    } else {\n\t$self->warn(\"Expected either a PopulationI object or an arrayref of IndividualI objects\");\n\treturn 0;\n    }\n    # find number of sites where a particular allele is only seen once\n\n    my ($singleton_allele_ct,%sites) = (0);\n    # first collect all the alleles into a hash structure\n    \n    foreach my $n ( @inds ) {\n\tif( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t    return 0;\n\t}\n\tforeach my $g ( $n->get_Genotypes ) {\n\t    my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t    foreach my $allele (@alleles ) {\n\t\t$sites{$nm}->{$allele}++;\n\t    }\n\t}\n    }\n    foreach my $site ( values %sites ) { # don't really care what the name is\n\tforeach my $allelect ( values %$site ) { # \n            # find the sites which have an allele with only 1 copy\n \t    $singleton_allele_ct++ if( $allelect == 1 );\n\t}\n    }\n    return $singleton_allele_ct;\n}\n\n# Yes I know that singleton_count and segregating_sites_count are\n# basically processing the same data so calling them both is\n# redundant, something I want to fix later but want to make things\n# correct and simple first\n\n=head2 segregating_sites_count\n\n Title   : segregating_sites_count\n Usage   : my $segsites = Bio::PopGen::Statistics->segregating_sites_count\n Function: Gets the number of segregating sites (number of polymorphic sites)\n Returns : (integer) number of segregating sites\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects \n           OR\n           L<Bio::PopGen::PopulationI> object\n\n perhaps we'll change this in the future\n to return the actual segregating sites\n so one can use this to pull in the names of those sites.\n Would be trivial if it is useful.","parameters":[{"label":"$self"},{"label":"$individuals"}]},"detail":"($self,$individuals)","definition":"sub","containerName":"main::","children":[{"line":895,"kind":13,"localvar":"my","containerName":"segregating_sites_count","definition":"my","name":"$self"},{"name":"$individuals","containerName":"segregating_sites_count","kind":13,"line":895},{"kind":13,"line":896,"containerName":"segregating_sites_count","name":"$type","definition":"my","localvar":"my"},{"containerName":"segregating_sites_count","name":"$individuals","line":896,"kind":13},{"kind":13,"line":897,"definition":"my","name":"$seg_sites","containerName":"segregating_sites_count","localvar":"my"},{"name":"$type","containerName":"segregating_sites_count","kind":13,"line":898},{"line":899,"kind":13,"localvar":"my","containerName":"segregating_sites_count","definition":"my","name":"%sites"},{"line":900,"kind":13,"localvar":"my","containerName":"segregating_sites_count","definition":"my","name":"$n"},{"name":"$individuals","containerName":"segregating_sites_count","kind":13,"line":900},{"name":"$n","containerName":"segregating_sites_count","line":901,"kind":13},{"name":"isa","containerName":"segregating_sites_count","kind":12,"line":901},{"name":"$self","containerName":"segregating_sites_count","line":902,"kind":13},{"line":902,"kind":12,"name":"warn","containerName":"segregating_sites_count"},{"line":902,"kind":13,"name":"$n","containerName":"segregating_sites_count"},{"kind":13,"line":905,"containerName":"segregating_sites_count","name":"$g","definition":"my","localvar":"my"},{"line":905,"kind":13,"containerName":"segregating_sites_count","name":"$n"},{"name":"get_Genotypes","containerName":"segregating_sites_count","kind":12,"line":905},{"localvar":"my","name":"$nm","definition":"my","containerName":"segregating_sites_count","line":906,"kind":13},{"containerName":"segregating_sites_count","name":"@alleles","kind":13,"line":906},{"containerName":"segregating_sites_count","name":"$g","line":906,"kind":13},{"kind":12,"line":906,"name":"marker_name","containerName":"segregating_sites_count"},{"kind":13,"line":906,"containerName":"segregating_sites_count","name":"$g"},{"containerName":"segregating_sites_count","name":"get_Alleles","kind":12,"line":906},{"kind":13,"line":907,"containerName":"segregating_sites_count","name":"$allele","definition":"my","localvar":"my"},{"name":"@alleles","containerName":"segregating_sites_count","kind":13,"line":907},{"line":908,"kind":13,"containerName":"segregating_sites_count","name":"$sites"},{"name":"$nm","containerName":"segregating_sites_count","line":908,"kind":13},{"line":908,"kind":13,"containerName":"segregating_sites_count","name":"$allele"},{"kind":13,"line":912,"containerName":"segregating_sites_count","definition":"my","name":"$site","localvar":"my"},{"kind":13,"line":912,"containerName":"segregating_sites_count","name":"%sites"},{"name":"$seg_sites","containerName":"segregating_sites_count","kind":13,"line":915},{"line":915,"kind":13,"name":"$site","containerName":"segregating_sites_count"},{"kind":13,"line":917,"name":"$type","containerName":"segregating_sites_count"},{"line":917,"kind":13,"containerName":"segregating_sites_count","name":"$individuals"},{"kind":12,"line":917,"name":"isa","containerName":"segregating_sites_count"},{"containerName":"segregating_sites_count","definition":"my","name":"$marker","localvar":"my","kind":13,"line":918},{"containerName":"segregating_sites_count","name":"$individuals","kind":13,"line":918},{"kind":12,"line":918,"containerName":"segregating_sites_count","name":"haploid_population"},{"line":918,"kind":12,"name":"get_Markers","containerName":"segregating_sites_count"},{"localvar":"my","containerName":"segregating_sites_count","name":"@alleles","definition":"my","line":919,"kind":13},{"kind":13,"line":919,"name":"$marker","containerName":"segregating_sites_count"},{"line":919,"kind":12,"name":"get_Alleles","containerName":"segregating_sites_count"},{"containerName":"segregating_sites_count","name":"$seg_sites","line":920,"kind":13},{"name":"@alleles","containerName":"segregating_sites_count","line":920,"kind":13},{"name":"$self","containerName":"segregating_sites_count","kind":13,"line":923},{"kind":12,"line":923,"containerName":"segregating_sites_count","name":"warn"},{"containerName":"segregating_sites_count","name":"$seg_sites","kind":13,"line":926}],"line":894,"kind":12},{"range":{"start":{"character":0,"line":946},"end":{"character":9999,"line":955}},"name":"heterozygosity","line":946,"children":[{"line":947,"kind":13,"localvar":"my","containerName":"heterozygosity","definition":"my","name":"$self"},{"line":947,"kind":13,"name":"$samp_size","containerName":"heterozygosity"},{"kind":13,"line":947,"containerName":"heterozygosity","name":"$freq1"},{"name":"$freq2","containerName":"heterozygosity","kind":13,"line":947},{"kind":13,"line":948,"name":"$freq2","containerName":"heterozygosity"},{"kind":13,"line":948,"containerName":"heterozygosity","name":"$freq2"},{"containerName":"heterozygosity","name":"$freq1","line":948,"kind":13},{"containerName":"heterozygosity","name":"$freq1","kind":13,"line":949},{"containerName":"heterozygosity","name":"$freq2","line":949,"kind":13},{"kind":13,"line":950,"name":"$self","containerName":"heterozygosity"},{"name":"warn","containerName":"heterozygosity","kind":12,"line":950},{"kind":13,"line":952,"definition":"my","name":"$sum","containerName":"heterozygosity","localvar":"my"},{"name":"$freq1","containerName":"heterozygosity","line":952,"kind":13},{"name":"$freq2","containerName":"heterozygosity","line":952,"kind":13},{"localvar":"my","containerName":"heterozygosity","name":"$h","definition":"my","line":953,"kind":13},{"line":953,"kind":13,"name":"$samp_size","containerName":"heterozygosity"},{"containerName":"heterozygosity","name":"$sum","kind":13,"line":953},{"name":"$samp_size","containerName":"heterozygosity","line":953,"kind":13},{"containerName":"heterozygosity","name":"$h","kind":13,"line":954}],"kind":12,"detail":"($self,$samp_size,$freq1,$freq2)","signature":{"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.\n\n\nsub pi {\n    my ($self,$individuals,$numsites) = @_;\n    my (%data,%marker_total,@marker_names,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t# one possible argument is an arrayref of Bio::PopGen::IndividualI objs\n\t@marker_names = $individuals->[0]->get_marker_names;\n\t$n = scalar @$individuals;\n\n\t# Here we are calculating the allele frequencies\n\tforeach my $ind ( @$individuals ) {\n\t    if( ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t\t$self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($ind).\"\\n\");\n\t\treturn 0;\n\t    }\n\t    foreach my $m ( @marker_names ) {\n\t\tforeach my $allele (map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t    $data{$m}->{$allele}++;\n\t\t    $marker_total{$m}++;\n\t\t}\n\t    }\n\t}\n#\twhile( my ($marker,$count) =  each %marker_total ) {\n#\t    foreach my $c ( values %{$data{$marker}} ) {\n#\t\t$c /= $count;\n#\t    }\n#\t}\n\t# %data will contain allele frequencies for each marker, allele\n    } elsif( ref($individuals) &&\n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\tforeach my $marker( $pop->get_Markers ) {\n\t    push @marker_names, $marker->name;\n\t    #$data{$marker->name} = {$marker->get_Allele_Frequencies};\n\t    my @genotypes = $pop->get_Genotypes(-marker => $marker->name);\n\t    for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t      $data{$marker->name}->{$al}++;\n\t      $marker_total{$marker->name}++;\n\t   }\n\t}\n    } else {\n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI to pi\");\n    }\n    # based on Kevin Thornton's code:\n    # http://molpopgen.org/software/libsequence/doc/html/PolySNP_8cc-source.html#l00152\n    # For now we assume that all individuals have the same markers\n    my ($diffcount,$totalcompare) = (0,0);\n    my $pi = 0;\n    while ( my ($marker,$markerdat) = each %data ) {\n      my $sampsize = $marker_total{$marker};\n      my $ssh = 0;\n      my @alleles = keys %$markerdat;\n      if ( $sampsize > 1 ) {\n\tmy $denom = $sampsize * ($sampsize - 1.0);\n\tforeach my $al ( @alleles ) {\n\t  $ssh += ($markerdat->{$al} * ($markerdat->{$al} - 1)) / $denom;\n\t}\n\t$pi += 1.0 - $ssh;\n      }\n    }\n    $self->debug( \"pi=$pi\\n\");\n    if( $numsites ) {\n\treturn $pi / $numsites;\n    } else {\n\treturn $pi;\n    }\n}\n\n\n=head2 theta\n\n Title   : theta\n Usage   : my $theta = Bio::PopGen::Statistics->theta($sampsize,$segsites);\n Function: Calculates Watterson's theta from the sample size \n           and the number of segregating sites.\n           Providing the third parameter, total number of sites will\n           return theta per site.\n           This is also known as K-hat = K / a_n   \n Returns : decimal number \n Args    : sample size (integer),\n           num segregating sites (integer)\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an arrayref of the L<Bio::PopGen::IndividualI> objects\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an L<Bio::PopGen::PopulationI> object\n           total sites (integer)[optional]\n\n\n#'\n\nsub theta {\n    my $self = shift;\n    my ( $n, $seg_sites,$totalsites) = @_;\n    if( ref($n) =~ /ARRAY/i ) {\n\tmy $samps = $n;\n\t$totalsites = $seg_sites; # only 2 arguments if one is an array\n\tmy %data;\n\tmy @marker_names = $samps->[0]->get_marker_names;\n\t# we need to calculate number of polymorphic sites\n\t$seg_sites = $self->segregating_sites_count($samps);\n\t$n = scalar @$samps;\n\n    } elsif(ref($n) &&\n\t    $n->isa('Bio::PopGen::PopulationI') ) {\n\t# This will handle the case when we pass in a PopulationI object\n\tmy $pop = $n;\n\t$totalsites = $seg_sites; # shift the arguments over by one\n\t$n = $pop->haploid_population->get_number_individuals;\n\t$seg_sites = $self->segregating_sites_count($pop);\n    }\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }    \n    if( $totalsites ) { # 0 and undef are the same can't divide by them\n\t$seg_sites /= $totalsites;\n    }\n    if( $a1 == 0 ) { \n\treturn 0;\n    } \n    return $seg_sites / $a1;\n}\n\n=head2 singleton_count\n\n Title   : singleton_count\n Usage   : my ($singletons) = Bio::PopGen::Statistics->singleton_count(\\@inds)\n Function: Calculate the number of mutations/alleles which only occur once in\n           a list of individuals for all sites/markers\n Returns : (integer) number of alleles which only occur once (integer)\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\nsub singleton_count {\n    my ($self,$individuals) = @_;\n\n    my @inds;\n    if( ref($individuals) =~ /ARRAY/ ) {\n\t@inds = @$individuals;\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t@inds = $pop->get_Individuals();\n\tunless( @inds ) { \n\t    $self->warn(\"Need to provide a population which has individuals loaded, not just a population with allele frequencies\");\n\t    return 0;\n\t}\n    } else {\n\t$self->warn(\"Expected either a PopulationI object or an arrayref of IndividualI objects\");\n\treturn 0;\n    }\n    # find number of sites where a particular allele is only seen once\n\n    my ($singleton_allele_ct,%sites) = (0);\n    # first collect all the alleles into a hash structure\n    \n    foreach my $n ( @inds ) {\n\tif( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t    return 0;\n\t}\n\tforeach my $g ( $n->get_Genotypes ) {\n\t    my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t    foreach my $allele (@alleles ) {\n\t\t$sites{$nm}->{$allele}++;\n\t    }\n\t}\n    }\n    foreach my $site ( values %sites ) { # don't really care what the name is\n\tforeach my $allelect ( values %$site ) { # \n            # find the sites which have an allele with only 1 copy\n \t    $singleton_allele_ct++ if( $allelect == 1 );\n\t}\n    }\n    return $singleton_allele_ct;\n}\n\n# Yes I know that singleton_count and segregating_sites_count are\n# basically processing the same data so calling them both is\n# redundant, something I want to fix later but want to make things\n# correct and simple first\n\n=head2 segregating_sites_count\n\n Title   : segregating_sites_count\n Usage   : my $segsites = Bio::PopGen::Statistics->segregating_sites_count\n Function: Gets the number of segregating sites (number of polymorphic sites)\n Returns : (integer) number of segregating sites\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects \n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n# perhaps we'll change this in the future \n# to return the actual segregating sites\n# so one can use this to pull in the names of those sites.\n# Would be trivial if it is useful.\n\nsub segregating_sites_count {\n   my ($self,$individuals) = @_;\n   my $type = ref($individuals);\n   my $seg_sites = 0;\n   if( $type =~ /ARRAY/i ) {\n       my %sites;\n       foreach my $n ( @$individuals ) {\n\t   if( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t       $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t       return 0;\n\t   }\n\t   foreach my $g ( $n->get_Genotypes ) {\n\t       my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t       foreach my $allele (@alleles ) {\n\t\t   $sites{$nm}->{$allele}++;\n\t       }\n\t   }\n       }\n       foreach my $site ( values %sites ) { # use values b/c we don't \n\t                                    # really care what the name is\n\t   # find the sites which >1 allele\n\t   $seg_sites++ if( keys %$site > 1 );\n       }\n   } elsif( $type && $individuals->isa('Bio::PopGen::PopulationI') ) {\n       foreach my $marker ( $individuals->haploid_population->get_Markers ) {  \n\t   my @alleles = $marker->get_Alleles;\t    \n\t   $seg_sites++ if ( scalar @alleles > 1 );\n       }\n   } else { \n       $self->warn(\"segregating_sites_count expects either a PopulationI object or a list of IndividualI objects\");\n       return 0;\n   } \n   return $seg_sites;\n}\n\n\n=head2 heterozygosity\n\n Title   : heterozygosity\n Usage   : my $het = Bio::PopGen::Statistics->heterozygosity($sampsize,$freq1);\n Function: Calculate the heterozgosity for a sample set for a set of alleles\n Returns : decimal number\n Args    : sample size (integer)\n           frequency of one allele (fraction - must be less than 1)\n           [optional] frequency of another allele - this is only needed\n                      in a non-binary allele system\n\nNote     : p^2 + 2pq + q^2","parameters":[{"label":"$self"},{"label":"$samp_size"},{"label":"$freq1"},{"label":"$freq2"}],"label":"heterozygosity($self,$samp_size,$freq1,$freq2)"},"containerName":"main::","definition":"sub"},{"range":{"start":{"line":974,"character":0},"end":{"character":9999,"line":1065}},"name":"derived_mutations","children":[{"localvar":"my","containerName":"derived_mutations","name":"$self","definition":"my","line":975,"kind":13},{"line":975,"kind":13,"containerName":"derived_mutations","name":"$ingroup"},{"containerName":"derived_mutations","name":"$outgroup","kind":13,"line":975},{"definition":"my","name":"%indata","containerName":"derived_mutations","localvar":"my","kind":13,"line":976},{"line":976,"kind":13,"name":"%outdata","containerName":"derived_mutations"},{"kind":13,"line":976,"name":"@marker_names","containerName":"derived_mutations"},{"kind":13,"line":980,"name":"$itype","definition":"my","containerName":"derived_mutations","localvar":"my"},{"line":980,"kind":13,"name":"$otype","containerName":"derived_mutations"},{"kind":13,"line":980,"containerName":"derived_mutations","name":"$ingroup"},{"kind":13,"line":980,"name":"$outgroup","containerName":"derived_mutations"},{"name":"$outgroup","containerName":"derived_mutations","line":982,"kind":13},{"kind":13,"line":982,"name":"$otype","containerName":"derived_mutations"},{"containerName":"derived_mutations","name":"$ingroup","kind":13,"line":987},{"kind":13,"line":988,"name":"$ingroup","containerName":"derived_mutations"},{"name":"$ingroup","containerName":"derived_mutations","kind":13,"line":989},{"name":"isa","containerName":"derived_mutations","line":989,"kind":12},{"name":"$self","containerName":"derived_mutations","line":990,"kind":13},{"kind":12,"line":990,"name":"warn","containerName":"derived_mutations"},{"name":"@marker_names","containerName":"derived_mutations","kind":13,"line":995},{"name":"$ingroup","containerName":"derived_mutations","kind":13,"line":995},{"containerName":"derived_mutations","name":"get_marker_names","line":995,"kind":12},{"kind":13,"line":996,"containerName":"derived_mutations","definition":"my","name":"$ind","localvar":"my"},{"line":996,"kind":13,"name":"$ingroup","containerName":"derived_mutations"},{"localvar":"my","name":"$m","definition":"my","containerName":"derived_mutations","line":997,"kind":13},{"kind":13,"line":997,"name":"@marker_names","containerName":"derived_mutations"},{"kind":13,"line":998,"containerName":"derived_mutations","definition":"my","name":"$allele","localvar":"my"},{"kind":12,"line":998,"containerName":"derived_mutations","name":"get_Alleles"},{"line":999,"kind":13,"containerName":"derived_mutations","name":"$ind"},{"kind":12,"line":999,"name":"get_Genotypes","containerName":"derived_mutations"},{"name":"$m","containerName":"derived_mutations","line":999,"kind":13},{"name":"$indata","containerName":"derived_mutations","line":1000,"kind":13},{"containerName":"derived_mutations","name":"$m","line":1000,"kind":13},{"line":1000,"kind":13,"name":"$allele","containerName":"derived_mutations"},{"containerName":"derived_mutations","name":"$ingroup","kind":13,"line":1004},{"containerName":"derived_mutations","name":"$ingroup","kind":13,"line":1004},{"kind":12,"line":1004,"containerName":"derived_mutations","name":"isa"},{"kind":13,"line":1005,"containerName":"derived_mutations","name":"@marker_names"},{"line":1005,"kind":13,"containerName":"derived_mutations","name":"$ingroup"},{"containerName":"derived_mutations","name":"get_marker_names","kind":12,"line":1005},{"localvar":"my","containerName":"derived_mutations","definition":"my","name":"$ind","line":1006,"kind":13},{"containerName":"derived_mutations","name":"$ingroup","line":1006,"kind":13},{"containerName":"derived_mutations","name":"haploid_population","line":1006,"kind":12},{"name":"get_Individuals","containerName":"derived_mutations","kind":12,"line":1006},{"line":1007,"kind":13,"localvar":"my","containerName":"derived_mutations","name":"$m","definition":"my"},{"name":"@marker_names","containerName":"derived_mutations","line":1007,"kind":13},{"definition":"my","name":"$allele","containerName":"derived_mutations","localvar":"my","kind":13,"line":1008},{"name":"get_Alleles","containerName":"derived_mutations","line":1008,"kind":12},{"kind":13,"line":1009,"name":"$ind","containerName":"derived_mutations"},{"line":1009,"kind":12,"name":"get_Genotypes","containerName":"derived_mutations"},{"line":1009,"kind":13,"containerName":"derived_mutations","name":"$m"},{"kind":13,"line":1010,"name":"$indata","containerName":"derived_mutations"},{"name":"$m","containerName":"derived_mutations","line":1010,"kind":13},{"containerName":"derived_mutations","name":"$allele","line":1010,"kind":13},{"line":1015,"kind":13,"containerName":"derived_mutations","name":"$self"},{"line":1015,"kind":12,"name":"warn","containerName":"derived_mutations"},{"line":1019,"kind":13,"name":"$otype","containerName":"derived_mutations"},{"name":"$outgroup","containerName":"derived_mutations","line":1020,"kind":13},{"name":"$outgroup","containerName":"derived_mutations","line":1021,"kind":13},{"name":"isa","containerName":"derived_mutations","line":1021,"kind":12},{"containerName":"derived_mutations","name":"$self","line":1022,"kind":13},{"kind":12,"line":1022,"name":"warn","containerName":"derived_mutations"},{"kind":13,"line":1025,"containerName":"derived_mutations","definition":"my","name":"$ind","localvar":"my"},{"kind":13,"line":1025,"containerName":"derived_mutations","name":"$outgroup"},{"line":1026,"kind":13,"localvar":"my","containerName":"derived_mutations","name":"$m","definition":"my"},{"kind":13,"line":1026,"containerName":"derived_mutations","name":"@marker_names"},{"localvar":"my","containerName":"derived_mutations","definition":"my","name":"$allele","line":1027,"kind":13},{"kind":12,"line":1027,"name":"get_Alleles","containerName":"derived_mutations"},{"containerName":"derived_mutations","name":"$ind","line":1028,"kind":13},{"line":1028,"kind":12,"containerName":"derived_mutations","name":"get_Genotypes"},{"containerName":"derived_mutations","name":"$m","line":1028,"kind":13},{"containerName":"derived_mutations","name":"$outdata","kind":13,"line":1029},{"line":1029,"kind":13,"name":"$m","containerName":"derived_mutations"},{"name":"$allele","containerName":"derived_mutations","line":1029,"kind":13},{"name":"$otype","containerName":"derived_mutations","kind":13,"line":1034},{"name":"isa","containerName":"derived_mutations","kind":12,"line":1034},{"definition":"my","name":"$ind","containerName":"derived_mutations","localvar":"my","kind":13,"line":1035},{"containerName":"derived_mutations","name":"$outgroup","line":1035,"kind":13},{"line":1035,"kind":12,"containerName":"derived_mutations","name":"haploid_population"},{"containerName":"derived_mutations","name":"get_Individuals","kind":12,"line":1035},{"kind":13,"line":1036,"definition":"my","name":"$m","containerName":"derived_mutations","localvar":"my"},{"name":"@marker_names","containerName":"derived_mutations","line":1036,"kind":13},{"name":"$allele","definition":"my","containerName":"derived_mutations","localvar":"my","kind":13,"line":1037},{"containerName":"derived_mutations","name":"get_Alleles","kind":12,"line":1037},{"kind":13,"line":1038,"containerName":"derived_mutations","name":"$ind"},{"line":1038,"kind":12,"name":"get_Genotypes","containerName":"derived_mutations"},{"containerName":"derived_mutations","name":"$m","line":1038,"kind":13},{"containerName":"derived_mutations","name":"$outdata","line":1039,"kind":13},{"kind":13,"line":1039,"containerName":"derived_mutations","name":"$m"},{"name":"$allele","containerName":"derived_mutations","kind":13,"line":1039},{"containerName":"derived_mutations","name":"$self","line":1044,"kind":13},{"name":"warn","containerName":"derived_mutations","line":1044,"kind":12},{"containerName":"derived_mutations","definition":"my","name":"$internal","localvar":"my","kind":13,"line":1062},{"kind":13,"line":1062,"name":"$external","containerName":"derived_mutations"},{"localvar":"my","containerName":"derived_mutations","definition":"my","name":"$marker","line":1063,"kind":13},{"name":"@marker_names","containerName":"derived_mutations","kind":13,"line":1063},{"kind":13,"line":1064,"definition":"my","name":"@outalleles","containerName":"derived_mutations","localvar":"my"},{"name":"$outdata","containerName":"derived_mutations","kind":13,"line":1064},{"line":1064,"kind":13,"name":"$marker","containerName":"derived_mutations"},{"kind":13,"line":1065,"containerName":"derived_mutations","definition":"my","name":"@in_alleles","localvar":"my"},{"name":"$indata","containerName":"derived_mutations","kind":13,"line":1065},{"kind":13,"line":1065,"name":"$marker","containerName":"derived_mutations"}],"line":974,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$ingroup"},{"label":"$outgroup"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.\n\n\nsub pi {\n    my ($self,$individuals,$numsites) = @_;\n    my (%data,%marker_total,@marker_names,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t# one possible argument is an arrayref of Bio::PopGen::IndividualI objs\n\t@marker_names = $individuals->[0]->get_marker_names;\n\t$n = scalar @$individuals;\n\n\t# Here we are calculating the allele frequencies\n\tforeach my $ind ( @$individuals ) {\n\t    if( ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t\t$self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($ind).\"\\n\");\n\t\treturn 0;\n\t    }\n\t    foreach my $m ( @marker_names ) {\n\t\tforeach my $allele (map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t    $data{$m}->{$allele}++;\n\t\t    $marker_total{$m}++;\n\t\t}\n\t    }\n\t}\n#\twhile( my ($marker,$count) =  each %marker_total ) {\n#\t    foreach my $c ( values %{$data{$marker}} ) {\n#\t\t$c /= $count;\n#\t    }\n#\t}\n\t# %data will contain allele frequencies for each marker, allele\n    } elsif( ref($individuals) &&\n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\tforeach my $marker( $pop->get_Markers ) {\n\t    push @marker_names, $marker->name;\n\t    #$data{$marker->name} = {$marker->get_Allele_Frequencies};\n\t    my @genotypes = $pop->get_Genotypes(-marker => $marker->name);\n\t    for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t      $data{$marker->name}->{$al}++;\n\t      $marker_total{$marker->name}++;\n\t   }\n\t}\n    } else {\n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI to pi\");\n    }\n    # based on Kevin Thornton's code:\n    # http://molpopgen.org/software/libsequence/doc/html/PolySNP_8cc-source.html#l00152\n    # For now we assume that all individuals have the same markers\n    my ($diffcount,$totalcompare) = (0,0);\n    my $pi = 0;\n    while ( my ($marker,$markerdat) = each %data ) {\n      my $sampsize = $marker_total{$marker};\n      my $ssh = 0;\n      my @alleles = keys %$markerdat;\n      if ( $sampsize > 1 ) {\n\tmy $denom = $sampsize * ($sampsize - 1.0);\n\tforeach my $al ( @alleles ) {\n\t  $ssh += ($markerdat->{$al} * ($markerdat->{$al} - 1)) / $denom;\n\t}\n\t$pi += 1.0 - $ssh;\n      }\n    }\n    $self->debug( \"pi=$pi\\n\");\n    if( $numsites ) {\n\treturn $pi / $numsites;\n    } else {\n\treturn $pi;\n    }\n}\n\n\n=head2 theta\n\n Title   : theta\n Usage   : my $theta = Bio::PopGen::Statistics->theta($sampsize,$segsites);\n Function: Calculates Watterson's theta from the sample size \n           and the number of segregating sites.\n           Providing the third parameter, total number of sites will\n           return theta per site.\n           This is also known as K-hat = K / a_n   \n Returns : decimal number \n Args    : sample size (integer),\n           num segregating sites (integer)\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an arrayref of the L<Bio::PopGen::IndividualI> objects\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an L<Bio::PopGen::PopulationI> object\n           total sites (integer)[optional]\n\n\n#'\n\nsub theta {\n    my $self = shift;\n    my ( $n, $seg_sites,$totalsites) = @_;\n    if( ref($n) =~ /ARRAY/i ) {\n\tmy $samps = $n;\n\t$totalsites = $seg_sites; # only 2 arguments if one is an array\n\tmy %data;\n\tmy @marker_names = $samps->[0]->get_marker_names;\n\t# we need to calculate number of polymorphic sites\n\t$seg_sites = $self->segregating_sites_count($samps);\n\t$n = scalar @$samps;\n\n    } elsif(ref($n) &&\n\t    $n->isa('Bio::PopGen::PopulationI') ) {\n\t# This will handle the case when we pass in a PopulationI object\n\tmy $pop = $n;\n\t$totalsites = $seg_sites; # shift the arguments over by one\n\t$n = $pop->haploid_population->get_number_individuals;\n\t$seg_sites = $self->segregating_sites_count($pop);\n    }\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }    \n    if( $totalsites ) { # 0 and undef are the same can't divide by them\n\t$seg_sites /= $totalsites;\n    }\n    if( $a1 == 0 ) { \n\treturn 0;\n    } \n    return $seg_sites / $a1;\n}\n\n=head2 singleton_count\n\n Title   : singleton_count\n Usage   : my ($singletons) = Bio::PopGen::Statistics->singleton_count(\\@inds)\n Function: Calculate the number of mutations/alleles which only occur once in\n           a list of individuals for all sites/markers\n Returns : (integer) number of alleles which only occur once (integer)\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\nsub singleton_count {\n    my ($self,$individuals) = @_;\n\n    my @inds;\n    if( ref($individuals) =~ /ARRAY/ ) {\n\t@inds = @$individuals;\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t@inds = $pop->get_Individuals();\n\tunless( @inds ) { \n\t    $self->warn(\"Need to provide a population which has individuals loaded, not just a population with allele frequencies\");\n\t    return 0;\n\t}\n    } else {\n\t$self->warn(\"Expected either a PopulationI object or an arrayref of IndividualI objects\");\n\treturn 0;\n    }\n    # find number of sites where a particular allele is only seen once\n\n    my ($singleton_allele_ct,%sites) = (0);\n    # first collect all the alleles into a hash structure\n    \n    foreach my $n ( @inds ) {\n\tif( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t    return 0;\n\t}\n\tforeach my $g ( $n->get_Genotypes ) {\n\t    my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t    foreach my $allele (@alleles ) {\n\t\t$sites{$nm}->{$allele}++;\n\t    }\n\t}\n    }\n    foreach my $site ( values %sites ) { # don't really care what the name is\n\tforeach my $allelect ( values %$site ) { # \n            # find the sites which have an allele with only 1 copy\n \t    $singleton_allele_ct++ if( $allelect == 1 );\n\t}\n    }\n    return $singleton_allele_ct;\n}\n\n# Yes I know that singleton_count and segregating_sites_count are\n# basically processing the same data so calling them both is\n# redundant, something I want to fix later but want to make things\n# correct and simple first\n\n=head2 segregating_sites_count\n\n Title   : segregating_sites_count\n Usage   : my $segsites = Bio::PopGen::Statistics->segregating_sites_count\n Function: Gets the number of segregating sites (number of polymorphic sites)\n Returns : (integer) number of segregating sites\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects \n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n# perhaps we'll change this in the future \n# to return the actual segregating sites\n# so one can use this to pull in the names of those sites.\n# Would be trivial if it is useful.\n\nsub segregating_sites_count {\n   my ($self,$individuals) = @_;\n   my $type = ref($individuals);\n   my $seg_sites = 0;\n   if( $type =~ /ARRAY/i ) {\n       my %sites;\n       foreach my $n ( @$individuals ) {\n\t   if( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t       $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t       return 0;\n\t   }\n\t   foreach my $g ( $n->get_Genotypes ) {\n\t       my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t       foreach my $allele (@alleles ) {\n\t\t   $sites{$nm}->{$allele}++;\n\t       }\n\t   }\n       }\n       foreach my $site ( values %sites ) { # use values b/c we don't \n\t                                    # really care what the name is\n\t   # find the sites which >1 allele\n\t   $seg_sites++ if( keys %$site > 1 );\n       }\n   } elsif( $type && $individuals->isa('Bio::PopGen::PopulationI') ) {\n       foreach my $marker ( $individuals->haploid_population->get_Markers ) {  \n\t   my @alleles = $marker->get_Alleles;\t    \n\t   $seg_sites++ if ( scalar @alleles > 1 );\n       }\n   } else { \n       $self->warn(\"segregating_sites_count expects either a PopulationI object or a list of IndividualI objects\");\n       return 0;\n   } \n   return $seg_sites;\n}\n\n\n=head2 heterozygosity\n\n Title   : heterozygosity\n Usage   : my $het = Bio::PopGen::Statistics->heterozygosity($sampsize,$freq1);\n Function: Calculate the heterozgosity for a sample set for a set of alleles\n Returns : decimal number\n Args    : sample size (integer)\n           frequency of one allele (fraction - must be less than 1)\n           [optional] frequency of another allele - this is only needed\n                      in a non-binary allele system\n\nNote     : p^2 + 2pq + q^2\n\n\n\nsub heterozygosity {\n    my ($self,$samp_size, $freq1,$freq2) = @_;\n    if( ! $freq2 ) { $freq2 = 1 - $freq1 }\n    if( $freq1 > 1 || $freq2 > 1 ) { \n\t$self->warn(\"heterozygosity expects frequencies to be less than 1\");\n    }\n    my $sum = ($freq1**2) + (($freq2)**2);\n    my $h = ( $samp_size*(1- $sum) ) / ($samp_size - 1) ;\n    return $h;\n}\n\n\n=head2 derived_mutations\n\n Title   : derived_mutations\n Usage   : my $ext = Bio::PopGen::Statistics->derived_mutations($ingroup,$outgroup);\n Function: Calculate the number of alleles or (mutations) which are ancestral\n           and the number which are derived (occurred only on the tips)\n Returns : array of 2 items - number of external and internal derived \n           mutation\n Args    : ingroup - L<Bio::PopGen::IndividualI>s arrayref OR \n                     L<Bio::PopGen::PopulationI>\n           outgroup- L<Bio::PopGen::IndividualI>s arrayref OR \n                     L<Bio::PopGen::PopulationI> OR\n                     a single L<Bio::PopGen::IndividualI>","label":"derived_mutations($self,$ingroup,$outgroup)"},"detail":"($self,$ingroup,$outgroup)","definition":"sub","containerName":"main::"},{"containerName":null,"name":"@outalleles","line":1066,"kind":13},{"kind":13,"line":1066,"containerName":null,"name":"@in_alleles"},{"kind":13,"line":1067,"containerName":null,"definition":"my","name":"$allele","localvar":"my"},{"name":"@in_alleles","containerName":null,"kind":13,"line":1067},{"kind":13,"line":1068,"containerName":null,"name":"%outdata"},{"name":"%marker","containerName":null,"line":1068,"kind":13},{"name":"%allele","containerName":null,"kind":13,"line":1068},{"containerName":null,"name":"%indata","line":1069,"kind":13},{"containerName":null,"name":"%marker","kind":13,"line":1069},{"name":"%allele","containerName":null,"kind":13,"line":1069},{"containerName":null,"name":"%external","line":1070,"kind":13},{"containerName":null,"name":"$internal","line":1072,"kind":13},{"containerName":null,"name":"$external","line":1077,"kind":13},{"kind":13,"line":1077,"containerName":null,"name":"$internal"},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"composite_LD","localvar":"my","kind":13,"line":1101},{"line":1101,"kind":13,"containerName":"composite_LD","name":"$pop"},{"line":1102,"kind":13,"name":"$pop","containerName":"composite_LD"},{"line":1103,"kind":13,"name":"$pop","containerName":"composite_LD"},{"line":1103,"kind":13,"name":"$pop","containerName":"composite_LD"},{"containerName":"composite_LD","name":"isa","line":1103,"kind":12},{"containerName":"composite_LD","name":"$pop","kind":13,"line":1104},{"name":"new","containerName":"composite_LD","line":1104,"kind":12},{"name":"$self","containerName":"composite_LD","kind":13,"line":1106},{"line":1106,"kind":12,"name":"warn","containerName":"composite_LD"},{"line":1109,"kind":13,"name":"$pop","containerName":"composite_LD"},{"name":"$pop","containerName":"composite_LD","line":1109,"kind":13},{"kind":12,"line":1109,"name":"isa","containerName":"composite_LD"},{"name":"$self","containerName":"composite_LD","kind":13,"line":1110},{"containerName":"composite_LD","name":"warn","line":1110,"kind":12},{"line":1114,"kind":13,"localvar":"my","containerName":"composite_LD","name":"@marker_names","definition":"my"},{"kind":13,"line":1114,"containerName":"composite_LD","name":"$pop"},{"containerName":"composite_LD","name":"get_marker_names","line":1114,"kind":12},{"localvar":"my","definition":"my","name":"@inds","containerName":"composite_LD","line":1115,"kind":13},{"kind":13,"line":1115,"name":"$pop","containerName":"composite_LD"},{"containerName":"composite_LD","name":"get_Individuals","line":1115,"kind":12},{"kind":13,"line":1116,"name":"$num_inds","definition":"my","containerName":"composite_LD","localvar":"my"},{"name":"@inds","containerName":"composite_LD","kind":13,"line":1116},{"kind":13,"line":1117,"name":"%lookup","definition":"my","containerName":"composite_LD","localvar":"my"},{"localvar":"my","containerName":"composite_LD","name":"$marker_name","definition":"my","line":1121,"kind":13},{"name":"@marker_names","containerName":"composite_LD","kind":13,"line":1121},{"localvar":"my","containerName":"composite_LD","name":"%allelef","definition":"my","line":1122,"kind":13},{"containerName":"composite_LD","definition":"my","name":"$ind","localvar":"my","kind":13,"line":1124},{"containerName":"composite_LD","name":"@inds","kind":13,"line":1124},{"definition":"my","name":"$genotype","containerName":"composite_LD","localvar":"my","kind":13,"line":1125},{"name":"$ind","containerName":"composite_LD","kind":13,"line":1125},{"containerName":"composite_LD","name":"get_Genotypes","line":1125,"kind":12},{"line":1125,"kind":13,"containerName":"composite_LD","name":"$marker_name"},{"kind":13,"line":1126,"name":"$genotype","containerName":"composite_LD"},{"line":1127,"kind":13,"name":"$self","containerName":"composite_LD"},{"line":1127,"kind":12,"name":"warn","containerName":"composite_LD"},{"containerName":"composite_LD","name":"$ind","line":1127,"kind":13},{"kind":12,"line":1127,"name":"unique_id","containerName":"composite_LD"},{"definition":"my","name":"@alleles","containerName":"composite_LD","localvar":"my","kind":13,"line":1130},{"kind":13,"line":1130,"containerName":"composite_LD","name":"$genotype"},{"containerName":"composite_LD","name":"get_Alleles","line":1130,"kind":12},{"containerName":"composite_LD","name":"@alleles","kind":13,"line":1131},{"localvar":"my","name":"$genostr","definition":"my","containerName":"composite_LD","line":1132,"kind":13},{"line":1132,"kind":13,"name":"@alleles","containerName":"composite_LD"},{"line":1133,"kind":13,"name":"$allelef","containerName":"composite_LD"},{"line":1133,"kind":13,"containerName":"composite_LD","name":"$alleles"},{"line":1134,"kind":13,"name":"$allelef","containerName":"composite_LD"},{"name":"$alleles","containerName":"composite_LD","line":1134,"kind":13},{"localvar":"my","name":"@alleles","definition":"my","containerName":"composite_LD","line":1139,"kind":13},{"kind":13,"line":1139,"containerName":"composite_LD","name":"%allelef"},{"localvar":"my","name":"$allele_count","definition":"my","containerName":"composite_LD","line":1140,"kind":13},{"line":1140,"kind":13,"containerName":"composite_LD","name":"@alleles"},{"kind":13,"line":1142,"name":"$allele_count","containerName":"composite_LD"},{"containerName":"composite_LD","name":"$self","line":1144,"kind":13},{"line":1144,"kind":12,"containerName":"composite_LD","name":"warn"},{"name":"@alleles","containerName":"composite_LD","kind":13,"line":1144},{"kind":13,"line":1144,"name":"$allele_count","containerName":"composite_LD"},{"name":"$alleles","containerName":"composite_LD","kind":13,"line":1150},{"line":1151,"kind":13,"containerName":"composite_LD","name":"$alleles"},{"containerName":"composite_LD","name":"$self","kind":13,"line":1152},{"name":"warn","containerName":"composite_LD","line":1152,"kind":12},{"name":"$self","containerName":"composite_LD","kind":13,"line":1159},{"line":1159,"kind":12,"name":"debug","containerName":"composite_LD"},{"containerName":"composite_LD","name":"$lookup","kind":13,"line":1160},{"line":1160,"kind":13,"containerName":"composite_LD","name":"$marker_name"},{"kind":13,"line":1160,"containerName":"composite_LD","name":"$alleles"},{"name":"$lookup","containerName":"composite_LD","kind":13,"line":1161},{"containerName":"composite_LD","name":"$marker_name","kind":13,"line":1161},{"containerName":"composite_LD","name":"$alleles","line":1161,"kind":13},{"containerName":"composite_LD","name":"@marker_names","line":1164,"kind":13},{"kind":13,"line":1164,"containerName":"composite_LD","name":"%lookup"},{"line":1165,"kind":13,"localvar":"my","containerName":"composite_LD","name":"$site_count","definition":"my"},{"name":"@marker_names","containerName":"composite_LD","kind":13,"line":1165},{"containerName":"composite_LD","name":"%stats_for_sites","definition":"my","localvar":"my","kind":13,"line":1167},{"definition":"my","name":"$i","containerName":"composite_LD","localvar":"my","kind":13,"line":1173},{"containerName":"composite_LD","name":"$i","line":1173,"kind":13},{"containerName":"composite_LD","name":"$site_count","line":1173,"kind":13},{"containerName":"composite_LD","name":"$i","kind":13,"line":1173},{"localvar":"my","definition":"my","name":"$site1","containerName":"composite_LD","line":1174,"kind":13},{"kind":13,"line":1174,"name":"$marker_names","containerName":"composite_LD"},{"kind":13,"line":1174,"containerName":"composite_LD","name":"$i"},{"name":"$j","definition":"my","containerName":"composite_LD","localvar":"my","kind":13,"line":1176},{"containerName":"composite_LD","name":"$i","line":1176,"kind":13},{"kind":13,"line":1176,"name":"$j","containerName":"composite_LD"},{"kind":13,"line":1176,"name":"$site_count","containerName":"composite_LD"},{"containerName":"composite_LD","name":"$j","line":1176,"kind":13},{"containerName":"composite_LD","name":"%genotypes","definition":"my","localvar":"my","kind":13,"line":1177},{"containerName":"composite_LD","name":"%total_genotype_count","kind":13,"line":1177},{"containerName":"composite_LD","name":"$total_pairwisegeno_count","kind":13,"line":1177},{"line":1178,"kind":13,"name":"%pairwise_genotypes","containerName":"composite_LD"},{"localvar":"my","containerName":"composite_LD","definition":"my","name":"$site2","line":1180,"kind":13},{"kind":13,"line":1180,"name":"$marker_names","containerName":"composite_LD"},{"name":"$j","containerName":"composite_LD","line":1180,"kind":13},{"localvar":"my","containerName":"composite_LD","name":"%allele_count","definition":"my","line":1181,"kind":13},{"containerName":"composite_LD","name":"%allele_freqs","kind":13,"line":1181},{"kind":13,"line":1182,"containerName":"composite_LD","definition":"my","name":"$ind","localvar":"my"},{"containerName":"composite_LD","name":"@inds","kind":13,"line":1182},{"line":1184,"kind":13,"localvar":"my","name":"$genotype1","definition":"my","containerName":"composite_LD"},{"kind":13,"line":1184,"name":"$ind","containerName":"composite_LD"},{"containerName":"composite_LD","name":"get_Genotypes","line":1184,"kind":12},{"containerName":"composite_LD","name":"$site1","kind":13,"line":1184},{"kind":13,"line":1185,"name":"@alleles1","definition":"my","containerName":"composite_LD","localvar":"my"},{"line":1185,"kind":13,"name":"$genotype1","containerName":"composite_LD"},{"line":1185,"kind":12,"containerName":"composite_LD","name":"get_Alleles"},{"name":"@alleles1","containerName":"composite_LD","kind":13,"line":1191},{"line":1192,"kind":13,"localvar":"my","containerName":"composite_LD","definition":"my","name":"$genostr1"},{"containerName":"composite_LD","name":"@alleles1","line":1192,"kind":13},{"line":1195,"kind":13,"localvar":"my","definition":"my","name":"$genotype2","containerName":"composite_LD"},{"name":"$ind","containerName":"composite_LD","kind":13,"line":1195},{"line":1195,"kind":12,"containerName":"composite_LD","name":"get_Genotypes"},{"kind":13,"line":1195,"containerName":"composite_LD","name":"$site2"},{"containerName":"composite_LD","name":"@alleles2","definition":"my","localvar":"my","kind":13,"line":1196},{"kind":13,"line":1196,"containerName":"composite_LD","name":"$genotype2"},{"line":1196,"kind":12,"name":"get_Alleles","containerName":"composite_LD"},{"line":1197,"kind":13,"localvar":"my","name":"$genostr2","definition":"my","containerName":"composite_LD"},{"name":"@alleles2","containerName":"composite_LD","line":1197,"kind":13},{"kind":13,"line":1199,"containerName":"composite_LD","name":"@alleles2"},{"name":"@alleles1","containerName":"composite_LD","kind":13,"line":1200},{"line":1201,"kind":13,"name":"$allele_count","containerName":"composite_LD"},{"containerName":"composite_LD","name":"$site1","line":1201,"kind":13},{"kind":13,"line":1202,"containerName":"composite_LD","name":"$allele_freqs"},{"kind":13,"line":1202,"containerName":"composite_LD","name":"$site1"},{"kind":13,"line":1204,"name":"$genotypes","containerName":"composite_LD"},{"kind":13,"line":1204,"name":"$site1","containerName":"composite_LD"},{"containerName":"composite_LD","name":"$genostr1","kind":13,"line":1204},{"name":"$total_genotype_count","containerName":"composite_LD","kind":13,"line":1205},{"kind":13,"line":1205,"containerName":"composite_LD","name":"$site1"},{"containerName":"composite_LD","name":"@alleles2","line":1207,"kind":13},{"containerName":"composite_LD","name":"$allele_count","line":1208,"kind":13},{"line":1208,"kind":13,"name":"$site2","containerName":"composite_LD"},{"kind":13,"line":1209,"containerName":"composite_LD","name":"$allele_freqs"},{"line":1209,"kind":13,"name":"$site2","containerName":"composite_LD"},{"kind":13,"line":1211,"name":"$genotypes","containerName":"composite_LD"},{"name":"$site2","containerName":"composite_LD","kind":13,"line":1211},{"line":1211,"kind":13,"name":"$genostr2","containerName":"composite_LD"},{"name":"$total_genotype_count","containerName":"composite_LD","kind":13,"line":1212},{"kind":13,"line":1212,"containerName":"composite_LD","name":"$site2"},{"containerName":"composite_LD","name":"$pairwise_genotypes","line":1216,"kind":13},{"containerName":"composite_LD","name":"$total_pairwisegeno_count","kind":13,"line":1218},{"line":1220,"kind":13,"localvar":"my","definition":"my","name":"$site","containerName":"composite_LD"},{"containerName":"composite_LD","name":"%allele_freqs","kind":13,"line":1220},{"localvar":"my","containerName":"composite_LD","definition":"my","name":"$al","line":1221,"kind":13},{"line":1221,"kind":13,"containerName":"composite_LD","name":"$allele_freqs"},{"line":1221,"kind":13,"name":"$site","containerName":"composite_LD"},{"kind":13,"line":1222,"containerName":"composite_LD","name":"$allele_freqs"},{"kind":13,"line":1222,"containerName":"composite_LD","name":"$site"},{"name":"$al","containerName":"composite_LD","line":1222,"kind":13},{"name":"$allele_count","containerName":"composite_LD","line":1222,"kind":13},{"name":"$site","containerName":"composite_LD","kind":13,"line":1222},{"localvar":"my","name":"$n","definition":"my","containerName":"composite_LD","line":1225,"kind":13},{"name":"$total_pairwisegeno_count","containerName":"composite_LD","kind":13,"line":1225},{"name":"$allele1_site1","definition":"my","containerName":"composite_LD","localvar":"my","kind":13,"line":1227},{"containerName":"composite_LD","name":"$lookup","kind":13,"line":1227},{"name":"$site1","containerName":"composite_LD","kind":13,"line":1227},{"localvar":"my","name":"$allele1_site2","definition":"my","containerName":"composite_LD","line":1228,"kind":13},{"line":1228,"kind":13,"containerName":"composite_LD","name":"$lookup"},{"containerName":"composite_LD","name":"$site2","kind":13,"line":1228},{"kind":13,"line":1229,"name":"$allele2_site1","definition":"my","containerName":"composite_LD","localvar":"my"},{"kind":13,"line":1229,"name":"$lookup","containerName":"composite_LD"},{"containerName":"composite_LD","name":"$site1","line":1229,"kind":13},{"localvar":"my","definition":"my","name":"$allele2_site2","containerName":"composite_LD","line":1230,"kind":13},{"kind":13,"line":1230,"containerName":"composite_LD","name":"$lookup"},{"line":1230,"kind":13,"containerName":"composite_LD","name":"$site2"},{"localvar":"my","name":"$N1genostr","definition":"my","containerName":"composite_LD","line":1232,"kind":13},{"kind":13,"line":1232,"containerName":"composite_LD","name":"$allele1_site1"},{"containerName":"composite_LD","name":"$allele1_site1","kind":13,"line":1232},{"containerName":"composite_LD","name":"$allele1_site2","line":1233,"kind":13},{"kind":13,"line":1233,"containerName":"composite_LD","name":"$allele1_site2"},{"line":1234,"kind":13,"name":"$self","containerName":"composite_LD"},{"containerName":"composite_LD","name":"debug","kind":12,"line":1234},{"line":1236,"kind":13,"localvar":"my","containerName":"composite_LD","definition":"my","name":"$N2genostr"},{"containerName":"composite_LD","name":"$allele1_site1","kind":13,"line":1236},{"name":"$allele1_site1","containerName":"composite_LD","kind":13,"line":1236},{"kind":13,"line":1237,"name":"$allele1_site2","containerName":"composite_LD"},{"containerName":"composite_LD","name":"$allele2_site2","kind":13,"line":1237},{"name":"$self","containerName":"composite_LD","line":1238,"kind":13},{"containerName":"composite_LD","name":"debug","kind":12,"line":1238},{"localvar":"my","containerName":"composite_LD","name":"$N4genostr","definition":"my","line":1240,"kind":13},{"containerName":"composite_LD","name":"$allele1_site1","line":1240,"kind":13},{"kind":13,"line":1240,"containerName":"composite_LD","name":"$allele2_site1"},{"name":"$allele1_site2","containerName":"composite_LD","kind":13,"line":1241},{"line":1241,"kind":13,"containerName":"composite_LD","name":"$allele1_site2"},{"line":1242,"kind":13,"containerName":"composite_LD","name":"$self"},{"name":"debug","containerName":"composite_LD","line":1242,"kind":12},{"localvar":"my","definition":"my","name":"$N5genostr","containerName":"composite_LD","line":1244,"kind":13},{"line":1244,"kind":13,"name":"$allele1_site1","containerName":"composite_LD"},{"line":1244,"kind":13,"name":"$allele2_site1","containerName":"composite_LD"},{"kind":13,"line":1245,"containerName":"composite_LD","name":"$allele1_site2"},{"kind":13,"line":1245,"containerName":"composite_LD","name":"$allele2_site2"},{"name":"$self","containerName":"composite_LD","kind":13,"line":1246},{"name":"debug","containerName":"composite_LD","line":1246,"kind":12},{"containerName":"composite_LD","name":"$n1","definition":"my","localvar":"my","kind":13,"line":1248},{"containerName":"composite_LD","name":"$pairwise_genotypes","kind":13,"line":1248},{"name":"$N1genostr","containerName":"composite_LD","line":1248,"kind":13},{"line":1250,"kind":13,"localvar":"my","containerName":"composite_LD","name":"$n2","definition":"my"},{"name":"$pairwise_genotypes","containerName":"composite_LD","kind":13,"line":1250},{"containerName":"composite_LD","name":"$N2genostr","line":1250,"kind":13},{"kind":13,"line":1252,"containerName":"composite_LD","name":"$n4","definition":"my","localvar":"my"},{"containerName":"composite_LD","name":"$pairwise_genotypes","line":1252,"kind":13},{"kind":13,"line":1252,"name":"$N4genostr","containerName":"composite_LD"},{"localvar":"my","containerName":"composite_LD","name":"$n5","definition":"my","line":1254,"kind":13},{"line":1254,"kind":13,"name":"$pairwise_genotypes","containerName":"composite_LD"},{"name":"$N5genostr","containerName":"composite_LD","line":1254,"kind":13},{"kind":13,"line":1256,"containerName":"composite_LD","definition":"my","name":"$homozA_site1","localvar":"my"},{"name":"$allele1_site1","containerName":"composite_LD","line":1256,"kind":13},{"line":1256,"kind":13,"name":"$allele1_site1","containerName":"composite_LD"},{"line":1257,"kind":13,"localvar":"my","containerName":"composite_LD","name":"$homozB_site2","definition":"my"},{"name":"$allele1_site2","containerName":"composite_LD","kind":13,"line":1257},{"name":"$allele1_site2","containerName":"composite_LD","line":1257,"kind":13},{"definition":"my","name":"$p_AA","containerName":"composite_LD","localvar":"my","kind":13,"line":1258},{"line":1258,"kind":13,"containerName":"composite_LD","name":"$genotypes"},{"containerName":"composite_LD","name":"$site1","line":1258,"kind":13},{"line":1258,"kind":13,"name":"$homozA_site1","containerName":"composite_LD"},{"line":1258,"kind":13,"containerName":"composite_LD","name":"$n"},{"line":1259,"kind":13,"localvar":"my","definition":"my","name":"$p_BB","containerName":"composite_LD"},{"line":1259,"kind":13,"name":"$genotypes","containerName":"composite_LD"},{"line":1259,"kind":13,"name":"$site2","containerName":"composite_LD"},{"line":1259,"kind":13,"containerName":"composite_LD","name":"$homozB_site2"},{"kind":13,"line":1259,"containerName":"composite_LD","name":"$n"},{"localvar":"my","containerName":"composite_LD","name":"$p_A","definition":"my","line":1260,"kind":13},{"containerName":"composite_LD","name":"$allele_freqs","line":1260,"kind":13},{"line":1260,"kind":13,"name":"$site1","containerName":"composite_LD"},{"kind":13,"line":1260,"containerName":"composite_LD","name":"$allele1_site1"},{"line":1261,"kind":13,"localvar":"my","name":"$p_a","definition":"my","containerName":"composite_LD"},{"containerName":"composite_LD","name":"$p_A","kind":13,"line":1261},{"kind":13,"line":1263,"definition":"my","name":"$p_B","containerName":"composite_LD","localvar":"my"},{"name":"$allele_freqs","containerName":"composite_LD","kind":13,"line":1263},{"kind":13,"line":1263,"containerName":"composite_LD","name":"$site2"},{"kind":13,"line":1263,"containerName":"composite_LD","name":"$allele1_site2"},{"kind":13,"line":1264,"definition":"my","name":"$p_b","containerName":"composite_LD","localvar":"my"},{"name":"$p_B","containerName":"composite_LD","line":1264,"kind":13},{"localvar":"my","name":"$pi_A","definition":"my","containerName":"composite_LD","line":1267,"kind":13},{"containerName":"composite_LD","name":"$p_A","line":1267,"kind":13},{"name":"$p_a","containerName":"composite_LD","kind":13,"line":1267},{"name":"$pi_B","definition":"my","containerName":"composite_LD","localvar":"my","kind":13,"line":1268},{"name":"$p_B","containerName":"composite_LD","kind":13,"line":1268},{"kind":13,"line":1268,"name":"$p_b","containerName":"composite_LD"},{"line":1271,"kind":13,"localvar":"my","containerName":"composite_LD","definition":"my","name":"$D_A"},{"kind":13,"line":1271,"name":"$p_AA","containerName":"composite_LD"},{"kind":13,"line":1271,"name":"$p_A","containerName":"composite_LD"},{"line":1272,"kind":13,"localvar":"my","definition":"my","name":"$D_B","containerName":"composite_LD"},{"containerName":"composite_LD","name":"$p_BB","line":1272,"kind":13},{"name":"$p_B","containerName":"composite_LD","kind":13,"line":1272},{"kind":13,"line":1273,"definition":"my","name":"$n_AB","containerName":"composite_LD","localvar":"my"},{"name":"$n1","containerName":"composite_LD","line":1273,"kind":13},{"containerName":"composite_LD","name":"$n2","line":1273,"kind":13},{"kind":13,"line":1273,"containerName":"composite_LD","name":"$n4"},{"name":"$n5","containerName":"composite_LD","kind":13,"line":1273},{"kind":13,"line":1274,"name":"$self","containerName":"composite_LD"},{"name":"debug","containerName":"composite_LD","kind":12,"line":1274},{"line":1276,"kind":13,"localvar":"my","containerName":"composite_LD","name":"$delta_AB","definition":"my"},{"containerName":"composite_LD","name":"$n","kind":13,"line":1276},{"name":"$n_AB","containerName":"composite_LD","line":1276,"kind":13},{"containerName":"composite_LD","name":"$p_A","kind":13,"line":1276},{"kind":13,"line":1276,"name":"$p_B","containerName":"composite_LD"},{"line":1277,"kind":13,"name":"$self","containerName":"composite_LD"},{"kind":12,"line":1277,"name":"debug","containerName":"composite_LD"},{"name":"$self","containerName":"composite_LD","kind":13,"line":1278},{"name":"debug","containerName":"composite_LD","kind":12,"line":1278},{"kind":13,"line":1279,"containerName":"composite_LD","name":"$n"},{"name":"$delta_AB","containerName":"composite_LD","line":1279,"kind":13},{"name":"$pi_A","containerName":"composite_LD","kind":13,"line":1279},{"line":1279,"kind":13,"name":"$D_A","containerName":"composite_LD"},{"containerName":"composite_LD","name":"$pi_B","line":1279,"kind":13},{"line":1279,"kind":13,"containerName":"composite_LD","name":"$D_B"},{"kind":13,"line":1281,"name":"$chisquared","definition":"my","containerName":"composite_LD","localvar":"my"},{"kind":13,"line":1282,"name":"$chisquared","containerName":"composite_LD"},{"line":1282,"kind":13,"name":"$n","containerName":"composite_LD"},{"name":"$delta_AB","containerName":"composite_LD","line":1282,"kind":13},{"name":"$pi_A","containerName":"composite_LD","kind":13,"line":1283},{"name":"$D_A","containerName":"composite_LD","line":1283,"kind":13},{"kind":13,"line":1283,"name":"$pi_B","containerName":"composite_LD"},{"kind":13,"line":1283,"name":"$D_B","containerName":"composite_LD"},{"kind":13,"line":1286,"containerName":"composite_LD","name":"$self"},{"line":1286,"kind":12,"name":"debug","containerName":"composite_LD"},{"line":1290,"kind":13,"containerName":"composite_LD","name":"$stats_for_sites"},{"containerName":"composite_LD","name":"$site1","kind":13,"line":1290},{"kind":13,"line":1290,"containerName":"composite_LD","name":"$site2"},{"kind":13,"line":1290,"containerName":"composite_LD","name":"$delta_AB"},{"kind":13,"line":1290,"name":"$chisquared","containerName":"composite_LD"}],"line":1100,"definition":"sub","containerName":"main::","signature":{"label":"composite_LD($self,$pop)","parameters":[{"label":"$self"},{"label":"$pop"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.\n\n\nsub pi {\n    my ($self,$individuals,$numsites) = @_;\n    my (%data,%marker_total,@marker_names,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t# one possible argument is an arrayref of Bio::PopGen::IndividualI objs\n\t@marker_names = $individuals->[0]->get_marker_names;\n\t$n = scalar @$individuals;\n\n\t# Here we are calculating the allele frequencies\n\tforeach my $ind ( @$individuals ) {\n\t    if( ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t\t$self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($ind).\"\\n\");\n\t\treturn 0;\n\t    }\n\t    foreach my $m ( @marker_names ) {\n\t\tforeach my $allele (map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t    $data{$m}->{$allele}++;\n\t\t    $marker_total{$m}++;\n\t\t}\n\t    }\n\t}\n#\twhile( my ($marker,$count) =  each %marker_total ) {\n#\t    foreach my $c ( values %{$data{$marker}} ) {\n#\t\t$c /= $count;\n#\t    }\n#\t}\n\t# %data will contain allele frequencies for each marker, allele\n    } elsif( ref($individuals) &&\n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\tforeach my $marker( $pop->get_Markers ) {\n\t    push @marker_names, $marker->name;\n\t    #$data{$marker->name} = {$marker->get_Allele_Frequencies};\n\t    my @genotypes = $pop->get_Genotypes(-marker => $marker->name);\n\t    for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t      $data{$marker->name}->{$al}++;\n\t      $marker_total{$marker->name}++;\n\t   }\n\t}\n    } else {\n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI to pi\");\n    }\n    # based on Kevin Thornton's code:\n    # http://molpopgen.org/software/libsequence/doc/html/PolySNP_8cc-source.html#l00152\n    # For now we assume that all individuals have the same markers\n    my ($diffcount,$totalcompare) = (0,0);\n    my $pi = 0;\n    while ( my ($marker,$markerdat) = each %data ) {\n      my $sampsize = $marker_total{$marker};\n      my $ssh = 0;\n      my @alleles = keys %$markerdat;\n      if ( $sampsize > 1 ) {\n\tmy $denom = $sampsize * ($sampsize - 1.0);\n\tforeach my $al ( @alleles ) {\n\t  $ssh += ($markerdat->{$al} * ($markerdat->{$al} - 1)) / $denom;\n\t}\n\t$pi += 1.0 - $ssh;\n      }\n    }\n    $self->debug( \"pi=$pi\\n\");\n    if( $numsites ) {\n\treturn $pi / $numsites;\n    } else {\n\treturn $pi;\n    }\n}\n\n\n=head2 theta\n\n Title   : theta\n Usage   : my $theta = Bio::PopGen::Statistics->theta($sampsize,$segsites);\n Function: Calculates Watterson's theta from the sample size \n           and the number of segregating sites.\n           Providing the third parameter, total number of sites will\n           return theta per site.\n           This is also known as K-hat = K / a_n   \n Returns : decimal number \n Args    : sample size (integer),\n           num segregating sites (integer)\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an arrayref of the L<Bio::PopGen::IndividualI> objects\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an L<Bio::PopGen::PopulationI> object\n           total sites (integer)[optional]\n\n\n#'\n\nsub theta {\n    my $self = shift;\n    my ( $n, $seg_sites,$totalsites) = @_;\n    if( ref($n) =~ /ARRAY/i ) {\n\tmy $samps = $n;\n\t$totalsites = $seg_sites; # only 2 arguments if one is an array\n\tmy %data;\n\tmy @marker_names = $samps->[0]->get_marker_names;\n\t# we need to calculate number of polymorphic sites\n\t$seg_sites = $self->segregating_sites_count($samps);\n\t$n = scalar @$samps;\n\n    } elsif(ref($n) &&\n\t    $n->isa('Bio::PopGen::PopulationI') ) {\n\t# This will handle the case when we pass in a PopulationI object\n\tmy $pop = $n;\n\t$totalsites = $seg_sites; # shift the arguments over by one\n\t$n = $pop->haploid_population->get_number_individuals;\n\t$seg_sites = $self->segregating_sites_count($pop);\n    }\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }    \n    if( $totalsites ) { # 0 and undef are the same can't divide by them\n\t$seg_sites /= $totalsites;\n    }\n    if( $a1 == 0 ) { \n\treturn 0;\n    } \n    return $seg_sites / $a1;\n}\n\n=head2 singleton_count\n\n Title   : singleton_count\n Usage   : my ($singletons) = Bio::PopGen::Statistics->singleton_count(\\@inds)\n Function: Calculate the number of mutations/alleles which only occur once in\n           a list of individuals for all sites/markers\n Returns : (integer) number of alleles which only occur once (integer)\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\nsub singleton_count {\n    my ($self,$individuals) = @_;\n\n    my @inds;\n    if( ref($individuals) =~ /ARRAY/ ) {\n\t@inds = @$individuals;\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t@inds = $pop->get_Individuals();\n\tunless( @inds ) { \n\t    $self->warn(\"Need to provide a population which has individuals loaded, not just a population with allele frequencies\");\n\t    return 0;\n\t}\n    } else {\n\t$self->warn(\"Expected either a PopulationI object or an arrayref of IndividualI objects\");\n\treturn 0;\n    }\n    # find number of sites where a particular allele is only seen once\n\n    my ($singleton_allele_ct,%sites) = (0);\n    # first collect all the alleles into a hash structure\n    \n    foreach my $n ( @inds ) {\n\tif( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t    return 0;\n\t}\n\tforeach my $g ( $n->get_Genotypes ) {\n\t    my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t    foreach my $allele (@alleles ) {\n\t\t$sites{$nm}->{$allele}++;\n\t    }\n\t}\n    }\n    foreach my $site ( values %sites ) { # don't really care what the name is\n\tforeach my $allelect ( values %$site ) { # \n            # find the sites which have an allele with only 1 copy\n \t    $singleton_allele_ct++ if( $allelect == 1 );\n\t}\n    }\n    return $singleton_allele_ct;\n}\n\n# Yes I know that singleton_count and segregating_sites_count are\n# basically processing the same data so calling them both is\n# redundant, something I want to fix later but want to make things\n# correct and simple first\n\n=head2 segregating_sites_count\n\n Title   : segregating_sites_count\n Usage   : my $segsites = Bio::PopGen::Statistics->segregating_sites_count\n Function: Gets the number of segregating sites (number of polymorphic sites)\n Returns : (integer) number of segregating sites\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects \n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n# perhaps we'll change this in the future \n# to return the actual segregating sites\n# so one can use this to pull in the names of those sites.\n# Would be trivial if it is useful.\n\nsub segregating_sites_count {\n   my ($self,$individuals) = @_;\n   my $type = ref($individuals);\n   my $seg_sites = 0;\n   if( $type =~ /ARRAY/i ) {\n       my %sites;\n       foreach my $n ( @$individuals ) {\n\t   if( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t       $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t       return 0;\n\t   }\n\t   foreach my $g ( $n->get_Genotypes ) {\n\t       my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t       foreach my $allele (@alleles ) {\n\t\t   $sites{$nm}->{$allele}++;\n\t       }\n\t   }\n       }\n       foreach my $site ( values %sites ) { # use values b/c we don't \n\t                                    # really care what the name is\n\t   # find the sites which >1 allele\n\t   $seg_sites++ if( keys %$site > 1 );\n       }\n   } elsif( $type && $individuals->isa('Bio::PopGen::PopulationI') ) {\n       foreach my $marker ( $individuals->haploid_population->get_Markers ) {  \n\t   my @alleles = $marker->get_Alleles;\t    \n\t   $seg_sites++ if ( scalar @alleles > 1 );\n       }\n   } else { \n       $self->warn(\"segregating_sites_count expects either a PopulationI object or a list of IndividualI objects\");\n       return 0;\n   } \n   return $seg_sites;\n}\n\n\n=head2 heterozygosity\n\n Title   : heterozygosity\n Usage   : my $het = Bio::PopGen::Statistics->heterozygosity($sampsize,$freq1);\n Function: Calculate the heterozgosity for a sample set for a set of alleles\n Returns : decimal number\n Args    : sample size (integer)\n           frequency of one allele (fraction - must be less than 1)\n           [optional] frequency of another allele - this is only needed\n                      in a non-binary allele system\n\nNote     : p^2 + 2pq + q^2\n\n\n\nsub heterozygosity {\n    my ($self,$samp_size, $freq1,$freq2) = @_;\n    if( ! $freq2 ) { $freq2 = 1 - $freq1 }\n    if( $freq1 > 1 || $freq2 > 1 ) { \n\t$self->warn(\"heterozygosity expects frequencies to be less than 1\");\n    }\n    my $sum = ($freq1**2) + (($freq2)**2);\n    my $h = ( $samp_size*(1- $sum) ) / ($samp_size - 1) ;\n    return $h;\n}\n\n\n=head2 derived_mutations\n\n Title   : derived_mutations\n Usage   : my $ext = Bio::PopGen::Statistics->derived_mutations($ingroup,$outgroup);\n Function: Calculate the number of alleles or (mutations) which are ancestral\n           and the number which are derived (occurred only on the tips)\n Returns : array of 2 items - number of external and internal derived \n           mutation\n Args    : ingroup - L<Bio::PopGen::IndividualI>s arrayref OR \n                     L<Bio::PopGen::PopulationI>\n           outgroup- L<Bio::PopGen::IndividualI>s arrayref OR \n                     L<Bio::PopGen::PopulationI> OR\n                     a single L<Bio::PopGen::IndividualI>\n\n\nsub derived_mutations {\n   my ($self,$ingroup,$outgroup) = @_;\n   my (%indata,%outdata,@marker_names);\n\n   # basically we have to do some type checking\n   # if that perl were typed...\n   my ($itype,$otype) = (ref($ingroup),ref($outgroup));\n\n   return $outgroup unless( $otype ); # we expect arrayrefs or objects, nums\n                                      # are already the value we \n                                      # are searching for\n   # pick apart the ingroup\n   # get the data\n   if( ref($ingroup) =~ /ARRAY/i ) {\n       if( ! ref($ingroup->[0]) ||\n\t   ! $ingroup->[0]->isa('Bio::PopGen::IndividualI') ) {\n\t   $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects or a Population for ingroup in external_mutations\");\n\t   return 0;\n       }\n       # we assume that all individuals have the same markers \n       # i.e. that they are aligned\n       @marker_names = $ingroup->[0]->get_marker_names;\n       for my $ind ( @$ingroup ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles }\n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $indata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\t   \n   } elsif( ref($ingroup) && $ingroup->isa('Bio::PopGen::PopulationI') ) {\n       @marker_names = $ingroup->get_marker_names;\n       for my $ind ( $ingroup->haploid_population->get_Individuals() ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $indata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   } else { \n       $self->warn(\"Need an arrayref of Bio::PopGen::IndividualI objs or a Bio::PopGen::Population for ingroup in external_mutations\");\n       return 0;\n   }\n    \n   if( $otype =~ /ARRAY/i ) {\n       if( ! ref($outgroup->[0]) ||\n\t   ! $outgroup->[0]->isa('Bio::PopGen::IndividualI') ) {\n\t   $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects or a Population for outgroup in external_mutations\");\n\t   return 0;\n       }\n       for my $ind ( @$outgroup ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles }\n\t\t\t\t$ind->get_Genotypes($m) ) {\n\t\t   $outdata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   \n   } elsif( $otype->isa('Bio::PopGen::PopulationI') ) {\n       for my $ind ( $outgroup->haploid_population->get_Individuals() ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $outdata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   } else {\n       $self->warn(\"Need an arrayref of Bio::PopGen::IndividualI objs or a Bio::PopGen::Population for outgroup in external_mutations\");\n       return 0;\n   }\n   \n   # derived mutations are defined as \n   # \n   # ingroup  (G A T)\n   # outgroup (A)\n   # derived mutations are G and T, A is the external mutation\n   \n   # ingroup  (A T)\n   # outgroup (C)\n   # derived mutations A,T no external/ancestral mutations\n   \n   # ingroup  (G A T)\n   # outgroup (A T)\n   # cannot determine\n  \n   my ($internal,$external);\n   foreach my $marker ( @marker_names ) {\n       my @outalleles = keys %{$outdata{$marker}};\n       my @in_alleles = keys %{$indata{$marker}};\n       next if( @outalleles > 1 || @in_alleles == 1);\n       for my $allele ( @in_alleles ) {\n\t   if( ! exists $outdata{$marker}->{$allele} ) { \n\t       if( $indata{$marker}->{$allele} == 1 ) { \n\t\t   $external++;\n\t       } else { \n\t\t   $internal++;\n\t       }\n\t   }\n       }\n   }\n   return ($external, $internal);\n}\n\n\n=head2 composite_LD\n\n Title   : composite_LD\n Usage   : %matrix = Bio::PopGen::Statistics->composite_LD($population);\n Function: Calculate the Linkage Disequilibrium \n           This is for calculating LD for unphased data. \n           Other methods will be appropriate for phased haplotype data.\n\n Returns : Hash of Hashes - first key is site 1,second key is site 2\n           and value is LD for those two sites.\n           my $LDarrayref = $matrix{$site1}->{$site2};\n           my ($ldval, $chisquared) = @$LDarrayref;\n Args    : L<Bio::PopGen::PopulationI> or arrayref of \n           L<Bio::PopGen::IndividualI>s \n Reference: Weir B.S. (1996) \"Genetic Data Analysis II\", \n                      Sinauer, Sunderlanm MA."},"detail":"($self,$pop)","name":"composite_LD","range":{"start":{"line":1100,"character":0},"end":{"character":9999,"line":1292}}},{"containerName":"PopGen::Population","name":"Bio","line":1104,"kind":12},{"kind":13,"line":1293,"containerName":null,"name":"%stats_for_sites"},{"name":"mcdonald_kreitman","range":{"end":{"line":1410,"character":9999},"start":{"line":1316,"character":0}},"kind":12,"line":1316,"children":[{"kind":13,"line":1317,"containerName":"mcdonald_kreitman","name":"$self","definition":"my","localvar":"my"},{"name":"@args","containerName":"mcdonald_kreitman","kind":13,"line":1317},{"line":1318,"kind":13,"localvar":"my","name":"$ingroup","definition":"my","containerName":"mcdonald_kreitman"},{"containerName":"mcdonald_kreitman","name":"$outgroup","line":1318,"kind":13},{"kind":13,"line":1318,"name":"$polarized","containerName":"mcdonald_kreitman"},{"name":"$self","containerName":"mcdonald_kreitman","line":1319,"kind":13},{"name":"_rearrange","containerName":"mcdonald_kreitman","line":1319,"kind":12},{"name":"@args","containerName":"mcdonald_kreitman","line":1319,"kind":13},{"containerName":"mcdonald_kreitman","name":"$verbose","definition":"my","localvar":"my","kind":13,"line":1320},{"name":"$self","containerName":"mcdonald_kreitman","kind":13,"line":1320},{"name":"verbose","containerName":"mcdonald_kreitman","line":1320,"kind":12},{"localvar":"my","containerName":"mcdonald_kreitman","name":"$outgroup_count","definition":"my","line":1321,"kind":13},{"line":1322,"kind":13,"localvar":"my","containerName":"mcdonald_kreitman","name":"$gapchar","definition":"my"},{"name":"$outgroup","containerName":"mcdonald_kreitman","line":1323,"kind":13},{"kind":13,"line":1324,"containerName":"mcdonald_kreitman","name":"$outgroup_count"},{"name":"$outgroup","containerName":"mcdonald_kreitman","kind":13,"line":1324},{"line":1325,"kind":13,"containerName":"mcdonald_kreitman","name":"$outgroup"},{"containerName":"mcdonald_kreitman","name":"$outgroup_count","kind":13,"line":1326},{"kind":13,"line":1326,"name":"$outgroup","containerName":"mcdonald_kreitman"},{"kind":12,"line":1326,"containerName":"mcdonald_kreitman","name":"get_number_individuals"},{"kind":13,"line":1328,"containerName":"mcdonald_kreitman","name":"$self"},{"line":1328,"kind":12,"containerName":"mcdonald_kreitman","name":"throw"},{"kind":13,"line":1331,"name":"$polarized","containerName":"mcdonald_kreitman"},{"kind":13,"line":1332,"containerName":"mcdonald_kreitman","name":"$outgroup_count"},{"line":1333,"kind":13,"containerName":"mcdonald_kreitman","name":"$self"},{"line":1333,"kind":12,"name":"throw","containerName":"mcdonald_kreitman"},{"kind":13,"line":1335,"name":"$outgroup_count","containerName":"mcdonald_kreitman"},{"containerName":"mcdonald_kreitman","name":"$self","kind":13,"line":1336},{"containerName":"mcdonald_kreitman","name":"warn","kind":12,"line":1336},{"containerName":"mcdonald_kreitman","name":"$outgroup_count","line":1336,"kind":13},{"name":"$outgroup_count","containerName":"mcdonald_kreitman","line":1337,"kind":13},{"line":1338,"kind":13,"containerName":"mcdonald_kreitman","name":"$self"},{"line":1338,"kind":12,"name":"throw","containerName":"mcdonald_kreitman"},{"kind":13,"line":1341,"containerName":"mcdonald_kreitman","definition":"my","name":"$codon_path","localvar":"my"},{"containerName":"mcdonald_kreitman","name":"codon_path","line":1341,"kind":12},{"definition":"my","name":"%marker_names","containerName":"mcdonald_kreitman","localvar":"my","kind":13,"line":1343},{"containerName":"mcdonald_kreitman","name":"%unique","kind":13,"line":1343},{"kind":13,"line":1343,"containerName":"mcdonald_kreitman","name":"@inds"},{"line":1344,"kind":13,"localvar":"my","containerName":"mcdonald_kreitman","definition":"my","name":"$p"},{"name":"$ingroup","containerName":"mcdonald_kreitman","kind":13,"line":1344},{"name":"$outgroup","containerName":"mcdonald_kreitman","line":1344,"kind":13},{"kind":13,"line":1345,"name":"$p","containerName":"mcdonald_kreitman"},{"containerName":"mcdonald_kreitman","name":"@inds","kind":13,"line":1346},{"containerName":"mcdonald_kreitman","name":"$p","kind":13,"line":1346},{"kind":13,"line":1348,"containerName":"mcdonald_kreitman","name":"@inds"},{"kind":13,"line":1348,"containerName":"mcdonald_kreitman","name":"$p"},{"kind":12,"line":1348,"name":"get_Individuals","containerName":"mcdonald_kreitman"},{"name":"$i","definition":"my","containerName":"mcdonald_kreitman","localvar":"my","kind":13,"line":1351},{"containerName":"mcdonald_kreitman","name":"@inds","kind":13,"line":1351},{"line":1352,"kind":13,"name":"$unique","containerName":"mcdonald_kreitman"},{"name":"$i","containerName":"mcdonald_kreitman","line":1352,"kind":13},{"kind":12,"line":1352,"containerName":"mcdonald_kreitman","name":"unique_id"},{"containerName":"mcdonald_kreitman","name":"$self","kind":13,"line":1353},{"kind":12,"line":1353,"containerName":"mcdonald_kreitman","name":"warn"},{"containerName":"mcdonald_kreitman","name":"$i","line":1353,"kind":13},{"kind":12,"line":1353,"name":"unique_id","containerName":"mcdonald_kreitman"},{"localvar":"my","name":"$n","definition":"my","containerName":"mcdonald_kreitman","line":1355,"kind":13},{"containerName":"mcdonald_kreitman","name":"$i","line":1355,"kind":13},{"containerName":"mcdonald_kreitman","name":"get_marker_names","line":1355,"kind":12},{"kind":13,"line":1356,"name":"$marker_names","containerName":"mcdonald_kreitman"},{"containerName":"mcdonald_kreitman","name":"$n","kind":13,"line":1356},{"kind":13,"line":1360,"name":"@marker_names","definition":"my","containerName":"mcdonald_kreitman","localvar":"my"},{"line":1360,"kind":13,"name":"%marker_names","containerName":"mcdonald_kreitman"},{"line":1361,"kind":13,"name":"$marker_names","containerName":"mcdonald_kreitman"},{"line":1364,"kind":13,"name":"@marker_names","containerName":"mcdonald_kreitman"},{"line":1365,"kind":13,"containerName":"mcdonald_kreitman","name":"$a"},{"containerName":"mcdonald_kreitman","name":"$b","line":1365,"kind":13},{"line":1366,"kind":13,"name":"@marker_names","containerName":"mcdonald_kreitman"},{"kind":13,"line":1370,"containerName":"mcdonald_kreitman","name":"$num_inds","definition":"my","localvar":"my"},{"kind":13,"line":1370,"containerName":"mcdonald_kreitman","name":"@inds"},{"localvar":"my","containerName":"mcdonald_kreitman","name":"%vals","definition":"my","line":1371,"kind":13},{"line":1371,"kind":13,"name":"$ingroup","containerName":"mcdonald_kreitman"},{"containerName":"mcdonald_kreitman","name":"$outgroup","line":1372,"kind":13},{"containerName":"mcdonald_kreitman","definition":"my","name":"$table","localvar":"my","kind":13,"line":1376},{"line":1376,"kind":12,"name":"new","containerName":"mcdonald_kreitman"},{"line":1376,"kind":13,"name":"$codon_table","containerName":"mcdonald_kreitman"},{"localvar":"my","definition":"my","name":"@vt","containerName":"mcdonald_kreitman","line":1377,"kind":13},{"line":1378,"kind":13,"localvar":"my","name":"%changes","definition":"my","containerName":"mcdonald_kreitman"},{"line":1379,"kind":13,"localvar":"my","containerName":"mcdonald_kreitman","name":"%status","definition":"my"},{"kind":13,"line":1380,"containerName":"mcdonald_kreitman","definition":"my","name":"%two_by_two","localvar":"my"},{"localvar":"my","name":"$codon","definition":"my","containerName":"mcdonald_kreitman","line":1385,"kind":13},{"name":"@marker_names","containerName":"mcdonald_kreitman","line":1385,"kind":13},{"kind":13,"line":1386,"containerName":"mcdonald_kreitman","definition":"my","name":"%codonvals","localvar":"my"},{"containerName":"mcdonald_kreitman","name":"%all_alleles","definition":"my","localvar":"my","kind":13,"line":1387},{"line":1388,"kind":13,"localvar":"my","name":"$t","definition":"my","containerName":"mcdonald_kreitman"},{"containerName":"mcdonald_kreitman","name":"@vt","kind":13,"line":1388},{"definition":"my","name":"$outcount","containerName":"mcdonald_kreitman","localvar":"my","kind":13,"line":1389},{"localvar":"my","definition":"my","name":"$ind","containerName":"mcdonald_kreitman","line":1390,"kind":13},{"name":"$vals","containerName":"mcdonald_kreitman","kind":13,"line":1390},{"name":"$t","containerName":"mcdonald_kreitman","line":1390,"kind":13},{"containerName":"mcdonald_kreitman","name":"@alleles","definition":"my","localvar":"my","kind":13,"line":1391},{"kind":13,"line":1391,"containerName":"mcdonald_kreitman","name":"$ind"},{"kind":12,"line":1391,"containerName":"mcdonald_kreitman","name":"get_Genotypes"},{"line":1391,"kind":13,"containerName":"mcdonald_kreitman","name":"$codon"},{"name":"get_Alleles","containerName":"mcdonald_kreitman","line":1391,"kind":12},{"kind":13,"line":1392,"name":"@alleles","containerName":"mcdonald_kreitman"},{"name":"$allele","definition":"my","containerName":"mcdonald_kreitman","localvar":"my","kind":13,"line":1396},{"kind":13,"line":1396,"name":"@alleles","containerName":"mcdonald_kreitman"},{"line":1397,"kind":13,"containerName":"mcdonald_kreitman","name":"$all_alleles"},{"name":"$ind","containerName":"mcdonald_kreitman","line":1397,"kind":13},{"name":"unique_id","containerName":"mcdonald_kreitman","line":1397,"kind":12},{"kind":13,"line":1397,"containerName":"mcdonald_kreitman","name":"$allele"},{"line":1398,"kind":13,"localvar":"my","definition":"my","name":"$AA","containerName":"mcdonald_kreitman"},{"containerName":"mcdonald_kreitman","name":"$table","line":1398,"kind":13},{"name":"translate","containerName":"mcdonald_kreitman","line":1398,"kind":12},{"name":"$allele","containerName":"mcdonald_kreitman","line":1398,"kind":13},{"containerName":"mcdonald_kreitman","name":"$AA","kind":13,"line":1399},{"kind":13,"line":1399,"name":"$AA","containerName":"mcdonald_kreitman"},{"kind":13,"line":1399,"containerName":"mcdonald_kreitman","name":"$allele"},{"kind":13,"line":1401,"definition":"my","name":"$label","containerName":"mcdonald_kreitman","localvar":"my"},{"line":1401,"kind":13,"name":"$t","containerName":"mcdonald_kreitman"},{"name":"$t","containerName":"mcdonald_kreitman","line":1402,"kind":13},{"line":1403,"kind":13,"containerName":"mcdonald_kreitman","name":"$label"},{"name":"$t","containerName":"mcdonald_kreitman","line":1403,"kind":13},{"name":"$outcount","containerName":"mcdonald_kreitman","line":1403,"kind":13},{"name":"$codonvals","containerName":"mcdonald_kreitman","line":1405,"kind":13},{"line":1405,"kind":13,"containerName":"mcdonald_kreitman","name":"$label"},{"kind":13,"line":1405,"containerName":"mcdonald_kreitman","name":"$allele"},{"containerName":"mcdonald_kreitman","name":"$codonvals","line":1406,"kind":13},{"kind":13,"line":1406,"containerName":"mcdonald_kreitman","name":"$allele"},{"line":1410,"kind":13,"localvar":"my","name":"$total","definition":"my","containerName":"mcdonald_kreitman"},{"line":1410,"kind":13,"containerName":"mcdonald_kreitman","name":"$codonvals"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.\n\n\nsub pi {\n    my ($self,$individuals,$numsites) = @_;\n    my (%data,%marker_total,@marker_names,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t# one possible argument is an arrayref of Bio::PopGen::IndividualI objs\n\t@marker_names = $individuals->[0]->get_marker_names;\n\t$n = scalar @$individuals;\n\n\t# Here we are calculating the allele frequencies\n\tforeach my $ind ( @$individuals ) {\n\t    if( ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t\t$self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($ind).\"\\n\");\n\t\treturn 0;\n\t    }\n\t    foreach my $m ( @marker_names ) {\n\t\tforeach my $allele (map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t    $data{$m}->{$allele}++;\n\t\t    $marker_total{$m}++;\n\t\t}\n\t    }\n\t}\n#\twhile( my ($marker,$count) =  each %marker_total ) {\n#\t    foreach my $c ( values %{$data{$marker}} ) {\n#\t\t$c /= $count;\n#\t    }\n#\t}\n\t# %data will contain allele frequencies for each marker, allele\n    } elsif( ref($individuals) &&\n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\tforeach my $marker( $pop->get_Markers ) {\n\t    push @marker_names, $marker->name;\n\t    #$data{$marker->name} = {$marker->get_Allele_Frequencies};\n\t    my @genotypes = $pop->get_Genotypes(-marker => $marker->name);\n\t    for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t      $data{$marker->name}->{$al}++;\n\t      $marker_total{$marker->name}++;\n\t   }\n\t}\n    } else {\n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI to pi\");\n    }\n    # based on Kevin Thornton's code:\n    # http://molpopgen.org/software/libsequence/doc/html/PolySNP_8cc-source.html#l00152\n    # For now we assume that all individuals have the same markers\n    my ($diffcount,$totalcompare) = (0,0);\n    my $pi = 0;\n    while ( my ($marker,$markerdat) = each %data ) {\n      my $sampsize = $marker_total{$marker};\n      my $ssh = 0;\n      my @alleles = keys %$markerdat;\n      if ( $sampsize > 1 ) {\n\tmy $denom = $sampsize * ($sampsize - 1.0);\n\tforeach my $al ( @alleles ) {\n\t  $ssh += ($markerdat->{$al} * ($markerdat->{$al} - 1)) / $denom;\n\t}\n\t$pi += 1.0 - $ssh;\n      }\n    }\n    $self->debug( \"pi=$pi\\n\");\n    if( $numsites ) {\n\treturn $pi / $numsites;\n    } else {\n\treturn $pi;\n    }\n}\n\n\n=head2 theta\n\n Title   : theta\n Usage   : my $theta = Bio::PopGen::Statistics->theta($sampsize,$segsites);\n Function: Calculates Watterson's theta from the sample size \n           and the number of segregating sites.\n           Providing the third parameter, total number of sites will\n           return theta per site.\n           This is also known as K-hat = K / a_n   \n Returns : decimal number \n Args    : sample size (integer),\n           num segregating sites (integer)\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an arrayref of the L<Bio::PopGen::IndividualI> objects\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an L<Bio::PopGen::PopulationI> object\n           total sites (integer)[optional]\n\n\n#'\n\nsub theta {\n    my $self = shift;\n    my ( $n, $seg_sites,$totalsites) = @_;\n    if( ref($n) =~ /ARRAY/i ) {\n\tmy $samps = $n;\n\t$totalsites = $seg_sites; # only 2 arguments if one is an array\n\tmy %data;\n\tmy @marker_names = $samps->[0]->get_marker_names;\n\t# we need to calculate number of polymorphic sites\n\t$seg_sites = $self->segregating_sites_count($samps);\n\t$n = scalar @$samps;\n\n    } elsif(ref($n) &&\n\t    $n->isa('Bio::PopGen::PopulationI') ) {\n\t# This will handle the case when we pass in a PopulationI object\n\tmy $pop = $n;\n\t$totalsites = $seg_sites; # shift the arguments over by one\n\t$n = $pop->haploid_population->get_number_individuals;\n\t$seg_sites = $self->segregating_sites_count($pop);\n    }\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }    \n    if( $totalsites ) { # 0 and undef are the same can't divide by them\n\t$seg_sites /= $totalsites;\n    }\n    if( $a1 == 0 ) { \n\treturn 0;\n    } \n    return $seg_sites / $a1;\n}\n\n=head2 singleton_count\n\n Title   : singleton_count\n Usage   : my ($singletons) = Bio::PopGen::Statistics->singleton_count(\\@inds)\n Function: Calculate the number of mutations/alleles which only occur once in\n           a list of individuals for all sites/markers\n Returns : (integer) number of alleles which only occur once (integer)\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\nsub singleton_count {\n    my ($self,$individuals) = @_;\n\n    my @inds;\n    if( ref($individuals) =~ /ARRAY/ ) {\n\t@inds = @$individuals;\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t@inds = $pop->get_Individuals();\n\tunless( @inds ) { \n\t    $self->warn(\"Need to provide a population which has individuals loaded, not just a population with allele frequencies\");\n\t    return 0;\n\t}\n    } else {\n\t$self->warn(\"Expected either a PopulationI object or an arrayref of IndividualI objects\");\n\treturn 0;\n    }\n    # find number of sites where a particular allele is only seen once\n\n    my ($singleton_allele_ct,%sites) = (0);\n    # first collect all the alleles into a hash structure\n    \n    foreach my $n ( @inds ) {\n\tif( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t    return 0;\n\t}\n\tforeach my $g ( $n->get_Genotypes ) {\n\t    my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t    foreach my $allele (@alleles ) {\n\t\t$sites{$nm}->{$allele}++;\n\t    }\n\t}\n    }\n    foreach my $site ( values %sites ) { # don't really care what the name is\n\tforeach my $allelect ( values %$site ) { # \n            # find the sites which have an allele with only 1 copy\n \t    $singleton_allele_ct++ if( $allelect == 1 );\n\t}\n    }\n    return $singleton_allele_ct;\n}\n\n# Yes I know that singleton_count and segregating_sites_count are\n# basically processing the same data so calling them both is\n# redundant, something I want to fix later but want to make things\n# correct and simple first\n\n=head2 segregating_sites_count\n\n Title   : segregating_sites_count\n Usage   : my $segsites = Bio::PopGen::Statistics->segregating_sites_count\n Function: Gets the number of segregating sites (number of polymorphic sites)\n Returns : (integer) number of segregating sites\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects \n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n# perhaps we'll change this in the future \n# to return the actual segregating sites\n# so one can use this to pull in the names of those sites.\n# Would be trivial if it is useful.\n\nsub segregating_sites_count {\n   my ($self,$individuals) = @_;\n   my $type = ref($individuals);\n   my $seg_sites = 0;\n   if( $type =~ /ARRAY/i ) {\n       my %sites;\n       foreach my $n ( @$individuals ) {\n\t   if( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t       $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t       return 0;\n\t   }\n\t   foreach my $g ( $n->get_Genotypes ) {\n\t       my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t       foreach my $allele (@alleles ) {\n\t\t   $sites{$nm}->{$allele}++;\n\t       }\n\t   }\n       }\n       foreach my $site ( values %sites ) { # use values b/c we don't \n\t                                    # really care what the name is\n\t   # find the sites which >1 allele\n\t   $seg_sites++ if( keys %$site > 1 );\n       }\n   } elsif( $type && $individuals->isa('Bio::PopGen::PopulationI') ) {\n       foreach my $marker ( $individuals->haploid_population->get_Markers ) {  \n\t   my @alleles = $marker->get_Alleles;\t    \n\t   $seg_sites++ if ( scalar @alleles > 1 );\n       }\n   } else { \n       $self->warn(\"segregating_sites_count expects either a PopulationI object or a list of IndividualI objects\");\n       return 0;\n   } \n   return $seg_sites;\n}\n\n\n=head2 heterozygosity\n\n Title   : heterozygosity\n Usage   : my $het = Bio::PopGen::Statistics->heterozygosity($sampsize,$freq1);\n Function: Calculate the heterozgosity for a sample set for a set of alleles\n Returns : decimal number\n Args    : sample size (integer)\n           frequency of one allele (fraction - must be less than 1)\n           [optional] frequency of another allele - this is only needed\n                      in a non-binary allele system\n\nNote     : p^2 + 2pq + q^2\n\n\n\nsub heterozygosity {\n    my ($self,$samp_size, $freq1,$freq2) = @_;\n    if( ! $freq2 ) { $freq2 = 1 - $freq1 }\n    if( $freq1 > 1 || $freq2 > 1 ) { \n\t$self->warn(\"heterozygosity expects frequencies to be less than 1\");\n    }\n    my $sum = ($freq1**2) + (($freq2)**2);\n    my $h = ( $samp_size*(1- $sum) ) / ($samp_size - 1) ;\n    return $h;\n}\n\n\n=head2 derived_mutations\n\n Title   : derived_mutations\n Usage   : my $ext = Bio::PopGen::Statistics->derived_mutations($ingroup,$outgroup);\n Function: Calculate the number of alleles or (mutations) which are ancestral\n           and the number which are derived (occurred only on the tips)\n Returns : array of 2 items - number of external and internal derived \n           mutation\n Args    : ingroup - L<Bio::PopGen::IndividualI>s arrayref OR \n                     L<Bio::PopGen::PopulationI>\n           outgroup- L<Bio::PopGen::IndividualI>s arrayref OR \n                     L<Bio::PopGen::PopulationI> OR\n                     a single L<Bio::PopGen::IndividualI>\n\n\nsub derived_mutations {\n   my ($self,$ingroup,$outgroup) = @_;\n   my (%indata,%outdata,@marker_names);\n\n   # basically we have to do some type checking\n   # if that perl were typed...\n   my ($itype,$otype) = (ref($ingroup),ref($outgroup));\n\n   return $outgroup unless( $otype ); # we expect arrayrefs or objects, nums\n                                      # are already the value we \n                                      # are searching for\n   # pick apart the ingroup\n   # get the data\n   if( ref($ingroup) =~ /ARRAY/i ) {\n       if( ! ref($ingroup->[0]) ||\n\t   ! $ingroup->[0]->isa('Bio::PopGen::IndividualI') ) {\n\t   $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects or a Population for ingroup in external_mutations\");\n\t   return 0;\n       }\n       # we assume that all individuals have the same markers \n       # i.e. that they are aligned\n       @marker_names = $ingroup->[0]->get_marker_names;\n       for my $ind ( @$ingroup ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles }\n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $indata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\t   \n   } elsif( ref($ingroup) && $ingroup->isa('Bio::PopGen::PopulationI') ) {\n       @marker_names = $ingroup->get_marker_names;\n       for my $ind ( $ingroup->haploid_population->get_Individuals() ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $indata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   } else { \n       $self->warn(\"Need an arrayref of Bio::PopGen::IndividualI objs or a Bio::PopGen::Population for ingroup in external_mutations\");\n       return 0;\n   }\n    \n   if( $otype =~ /ARRAY/i ) {\n       if( ! ref($outgroup->[0]) ||\n\t   ! $outgroup->[0]->isa('Bio::PopGen::IndividualI') ) {\n\t   $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects or a Population for outgroup in external_mutations\");\n\t   return 0;\n       }\n       for my $ind ( @$outgroup ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles }\n\t\t\t\t$ind->get_Genotypes($m) ) {\n\t\t   $outdata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   \n   } elsif( $otype->isa('Bio::PopGen::PopulationI') ) {\n       for my $ind ( $outgroup->haploid_population->get_Individuals() ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $outdata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   } else {\n       $self->warn(\"Need an arrayref of Bio::PopGen::IndividualI objs or a Bio::PopGen::Population for outgroup in external_mutations\");\n       return 0;\n   }\n   \n   # derived mutations are defined as \n   # \n   # ingroup  (G A T)\n   # outgroup (A)\n   # derived mutations are G and T, A is the external mutation\n   \n   # ingroup  (A T)\n   # outgroup (C)\n   # derived mutations A,T no external/ancestral mutations\n   \n   # ingroup  (G A T)\n   # outgroup (A T)\n   # cannot determine\n  \n   my ($internal,$external);\n   foreach my $marker ( @marker_names ) {\n       my @outalleles = keys %{$outdata{$marker}};\n       my @in_alleles = keys %{$indata{$marker}};\n       next if( @outalleles > 1 || @in_alleles == 1);\n       for my $allele ( @in_alleles ) {\n\t   if( ! exists $outdata{$marker}->{$allele} ) { \n\t       if( $indata{$marker}->{$allele} == 1 ) { \n\t\t   $external++;\n\t       } else { \n\t\t   $internal++;\n\t       }\n\t   }\n       }\n   }\n   return ($external, $internal);\n}\n\n\n=head2 composite_LD\n\n Title   : composite_LD\n Usage   : %matrix = Bio::PopGen::Statistics->composite_LD($population);\n Function: Calculate the Linkage Disequilibrium \n           This is for calculating LD for unphased data. \n           Other methods will be appropriate for phased haplotype data.\n\n Returns : Hash of Hashes - first key is site 1,second key is site 2\n           and value is LD for those two sites.\n           my $LDarrayref = $matrix{$site1}->{$site2};\n           my ($ldval, $chisquared) = @$LDarrayref;\n Args    : L<Bio::PopGen::PopulationI> or arrayref of \n           L<Bio::PopGen::IndividualI>s \n Reference: Weir B.S. (1996) \"Genetic Data Analysis II\", \n                      Sinauer, Sunderlanm MA.\n\n\nsub composite_LD {\n    my ($self,$pop) = @_;\n    if( ref($pop) =~ /ARRAY/i ) {\n\tif( ref($pop->[0]) && $pop->[0]->isa('Bio::PopGen::IndividualI') ) {\n\t    $pop = Bio::PopGen::Population->new(-individuals => @$pop);\n\t} else { \n\t    $self->warn(\"composite_LD expects a Bio::PopGen::PopulationI or an arrayref of Bio::PopGen::IndividualI objects\");\n\t    return ();\n\t}\n    } elsif( ! ref($pop) || ! $pop->isa('Bio::PopGen::PopulationI') ) {\n\t$self->warn(\"composite_LD expects a Bio::PopGen::PopulationI or an arrayref of Bio::PopGen::IndividualI objects\");\n\treturn ();\n    }\n\n    my @marker_names = $pop->get_marker_names;\n    my @inds = $pop->get_Individuals;\n    my $num_inds = scalar @inds;\n    my (%lookup);\n    # calculate allele frequencies for each marker from the population\n    # use the built-in get_Marker to get the allele freqs\n    # we still need to calculate the genotype frequencies\n    foreach my $marker_name ( @marker_names ) {\t\n\tmy(%allelef);\n\n\tforeach my $ind ( @inds ) {\n\t    my ($genotype) = $ind->get_Genotypes(-marker => $marker_name);\n\t    if( ! defined $genotype ) { \n\t\t$self->warn(\"no genotype for marker $marker_name for individual \". $ind->unique_id. \"\\n\");\n\t\tnext;\n\t    }\n\t    my @alleles  = sort $genotype->get_Alleles;\n\t    next if( scalar @alleles != 2);\n\t    my $genostr  = join(',', @alleles);\n            $allelef{$alleles[0]}++;\n            $allelef{$alleles[1]}++;\n\t}\n\n\t# we should check for cases where there > 2 alleles or\n\t# only 1 allele and throw out those markers.\n\tmy @alleles      = sort keys %allelef;\n\tmy $allele_count = scalar @alleles;\n\t# test if site is polymorphic\n\tif( $allele_count != 2) { \n\t    # only really warn if we're seeing multi-allele\n\t    $self->warn(\"Skipping $marker_name because it has $allele_count alleles (\".join(',',@alleles).\"), \\ncomposite_LD will currently only work for biallelic markers\") if $allele_count > 2;\n\t    next;\t\t# skip this marker\n\t}\n\n\t# Need to do something here to detect alleles which aren't \n\t# a single character\n\tif( length($alleles[0]) != 1 ||\n\t    length($alleles[1]) != 1 ) {\n\t    $self->warn(\"An individual has an allele which is not a single base, this is currently not supported in composite_LD - consider recoding the allele as a single character\");\n\t    next;\n\t}\n\n\t# fix the call for allele 1 (A or B) and \n\t# allele 2 (a or b) in terms of how we'll do the \n\t# N square from Weir p.126\n\t$self->debug( \"$alleles[0] is 1, $alleles[1] is 2 for $marker_name\\n\");\n\t$lookup{$marker_name}->{'1'} = $alleles[0];\n\t$lookup{$marker_name}->{'2'} = $alleles[1];\n    }\n\n    @marker_names = sort keys %lookup;\n    my $site_count   = scalar @marker_names;\n    # where the final data will be stored\n    my %stats_for_sites;\n\n    # standard way of generating pairwise combos\n    # LD is done by comparing all the pairwise site (marker)\n    # combinations and keeping track of the genotype and \n    # pairwise genotype (ie genotypes of the 2 sites) frequencies\n    for( my $i = 0; $i < $site_count - 1; $i++ ) {\n\tmy $site1 = $marker_names[$i];\n\n\tfor( my $j = $i+1; $j < $site_count ; $j++) { \t \n\t    my (%genotypes, %total_genotype_count,$total_pairwisegeno_count,\n\t\t%pairwise_genotypes);\n\t \n\t    my $site2 = $marker_names[$j];\n\t    my (%allele_count,%allele_freqs) = (0,0);\n\t    foreach my $ind ( @inds ) {\n\t\t# build string of genotype at site 1\n\t\tmy ($genotype1) = $ind->get_Genotypes(-marker => $site1);\n\t\tmy @alleles1  = sort $genotype1->get_Alleles;\n\n                # if an individual has only one available allele\n\t\t# (has a blank or N for one of the chromosomes)\n\t\t# we don't want to use it in our calculation\n\n\t\tnext unless( scalar @alleles1 == 2);\n\t\tmy $genostr1  = join(',', @alleles1);\n\n\t\t# build string of genotype at site 2\n\t\tmy ($genotype2) = $ind->get_Genotypes(-marker => $site2);\n\t\tmy @alleles2  = sort $genotype2->get_Alleles;\n\t\tmy $genostr2  = join(',', @alleles2);\n\t\t\n\t\tnext unless( scalar @alleles2 == 2);\n\t\tfor (@alleles1) {\n\t\t    $allele_count{$site1}++;\n\t\t    $allele_freqs{$site1}->{$_}++;\n\t\t}\n\t\t$genotypes{$site1}->{$genostr1}++;\n\t\t$total_genotype_count{$site1}++;\n\n\t\tfor (@alleles2) {\n\t\t    $allele_count{$site2}++;\n\t\t    $allele_freqs{$site2}->{$_}++;\n\t\t}\n\t\t$genotypes{$site2}->{$genostr2}++;\n\t\t$total_genotype_count{$site2}++;\n\n\t\t# We are using the $site1,$site2 to signify\n\t\t# a unique key\n\t\t$pairwise_genotypes{\"$genostr1,$genostr2\"}++;\n\t\t# some individuals \n\t\t$total_pairwisegeno_count++;\n\t    }\n\t    for my $site ( %allele_freqs ) {\n\t\tfor my $al ( keys %{ $allele_freqs{$site} } ) {\n\t\t    $allele_freqs{$site}->{$al} /= $allele_count{$site};\n\t\t}\n\t    }\n\t    my $n = $total_pairwisegeno_count;\t# number of pairs of comparisons\n\t    # 'A' and 'B' are two loci or in our case site1 and site2  \n\t    my $allele1_site1 = $lookup{$site1}->{'1'};\t# this is the BigA allele\n\t    my $allele1_site2 = $lookup{$site2}->{'1'};\t# this is the BigB allele\n\t    my $allele2_site1 = $lookup{$site1}->{'2'};\t# this is the LittleA allele\n\t    my $allele2_site2 = $lookup{$site2}->{'2'};\t# this is the LittleB allele\n\t    # AABB\n\t    my $N1genostr = join(\",\",( $allele1_site1, $allele1_site1,\n\t\t\t\t       $allele1_site2, $allele1_site2));\n\t    $self->debug(\" [$site1,$site2](AABB) N1genostr=$N1genostr\\n\");\n\t    # AABb\n\t    my $N2genostr = join(\",\",( $allele1_site1, $allele1_site1,\n\t\t\t\t       $allele1_site2, $allele2_site2));\n\t    $self->debug(\" [$site1,$site2](AABb) N2genostr=$N2genostr\\n\");\n\t    # AaBB\n\t    my $N4genostr = join(\",\",( $allele1_site1, $allele2_site1,\n\t\t\t\t       $allele1_site2, $allele1_site2));\n\t    $self->debug(\" [$site1,$site2](AaBB) N4genostr=$N4genostr\\n\");\n\t    # AaBb\n\t    my $N5genostr = join(\",\",( $allele1_site1, $allele2_site1,\n\t\t\t\t       $allele1_site2, $allele2_site2));\n\t    $self->debug(\" [$site1,$site2](AaBb) N5genostr=$N5genostr\\n\");\n\t    # count of AABB in \n\t    my $n1 = $pairwise_genotypes{$N1genostr} || 0;\n\t    # count of AABb in \n\t    my $n2 = $pairwise_genotypes{$N2genostr} || 0;\n\t    # count of AaBB in \n\t    my $n4 = $pairwise_genotypes{$N4genostr} || 0;\n\t    # count of AaBb in \n\t    my $n5 = $pairwise_genotypes{$N5genostr} || 0;\n\n\t    my $homozA_site1 = join(\",\", ($allele1_site1,$allele1_site1));\n\t    my $homozB_site2 = join(\",\", ($allele1_site2,$allele1_site2));\n\t    my $p_AA = ($genotypes{$site1}->{$homozA_site1} || 0) / $n;\n\t    my $p_BB = ($genotypes{$site2}->{$homozB_site2} || 0) / $n;\n\t    my $p_A  = $allele_freqs{$site1}->{$allele1_site1} || 0;\t# an individual allele freq\n\t    my $p_a  =  1 - $p_A;\n\n\t    my $p_B  = $allele_freqs{$site2}->{$allele1_site2} || 0;\t# an individual allele freq\n\t    my $p_b  =  1 - $p_B;\n\n\t    # variance of allele frequencies\n\t    my $pi_A = $p_A * $p_a;\n\t    my $pi_B = $p_B * $p_b;\n\n\t    # hardy weinberg\n\t    my $D_A  = $p_AA - $p_A**2;\n\t    my $D_B  = $p_BB - $p_B**2;\n\t    my $n_AB = 2*$n1 + $n2 + $n4 + 0.5 * $n5;\n\t    $self->debug(\"n_AB=$n_AB -- n1=$n1, n2=$n2 n4=$n4 n5=$n5\\n\");\n\n\t    my $delta_AB = (1 / $n ) * ( $n_AB ) - ( 2 * $p_A * $p_B );\n\t    $self->debug(\"delta_AB=$delta_AB -- n=$n, n_AB=$n_AB p_A=$p_A, p_B=$p_B\\n\");\n\t    $self->debug(sprintf(\" (%d * %.4f) / ( %.2f + %.2f) * ( %.2f + %.2f) \\n\",\n\t\t\t\t $n,$delta_AB**2, $pi_A, $D_A, $pi_B, $D_B));\n\t    \n\t    my $chisquared;\n\t    eval { $chisquared = ( $n * ($delta_AB**2) ) / \n\t\t       ( ( $pi_A + $D_A) * ( $pi_B + $D_B) );\n\t       };\n\t    if( $@ ) {\n\t\t$self->debug(\"Skipping the site because the denom is 0.\\nsite1=$site1, site2=$site2 : pi_A=$pi_A, pi_B=$pi_B D_A=$D_A, D_B=$D_B\\n\");\n\t\tnext;\n\t    }\n\t    # this will be an upper triangular matrix\n\t    $stats_for_sites{$site1}->{$site2} = [$delta_AB,$chisquared];\n\t}\n    }\n    return %stats_for_sites;\n}\n\n=head2 mcdonald_kreitman\n\n Title   : mcdonald_kreitman\n Usage   : $Fstat = mcdonald_kreitman($ingroup, $outgroup);\n Function: Calculates McDonald-Kreitman statistic based on a set of ingroup\n           individuals and an outgroup by computing the number of \n           differences at synonymous and non-synonymous sites\n           for intraspecific comparisons and with the outgroup \n Returns : 2x2 table, followed by a hash reference indicating any \n           warning messages about the status of the alleles or codons \n Args    : -ingroup    => L<Bio::PopGen::Population> object or \n                          arrayref of L<Bio::PopGen::Individual>s \n           -outgroup   => L<Bio::PopGen::Population> object or \n                          arrayef of L<Bio::PopGen::Individual>s\n           -polarized  => Boolean, to indicate if this should be \n                          a polarized test. Must provide two individuals \n                          as outgroups.","label":"mcdonald_kreitman($self,@args)"}},{"name":"UNIVERSAL","containerName":"isa","line":1325,"kind":12},{"line":1341,"kind":12,"containerName":"MolEvol::CodonModel","name":"Bio"},{"line":1376,"kind":12,"containerName":"Tools::CodonTable","name":"Bio"},{"name":"all","line":1406,"kind":12},{"name":"sum","line":1410,"kind":12},{"containerName":null,"name":"$total","kind":13,"line":1411},{"kind":13,"line":1411,"name":"$total","containerName":null},{"kind":13,"line":1414,"containerName":null,"name":"%codonvals"},{"name":"all","line":1414,"kind":12},{"localvar":"my","containerName":null,"name":"$outcodon","definition":"my","line":1418,"kind":13},{"kind":13,"line":1418,"name":"%codonvals","containerName":null},{"containerName":null,"name":"%outcodon","line":1419,"kind":13},{"containerName":null,"name":"%status","line":1420,"kind":13},{"containerName":null,"definition":"my","name":"$out_AA","localvar":"my","kind":13,"line":1423},{"name":"$table","containerName":null,"line":1423,"kind":13},{"kind":12,"line":1423,"name":"translate","containerName":"main::"},{"containerName":null,"name":"$outcodon","kind":13,"line":1423},{"line":1424,"kind":13,"localvar":"my","containerName":null,"name":"$outcodon2","definition":"my"},{"line":1424,"kind":13,"containerName":null,"name":"%codonvals"},{"kind":13,"line":1425,"name":"$polarized","containerName":null},{"kind":13,"line":1425,"name":"$outcodon","containerName":null},{"name":"$outcodon2","containerName":null,"line":1425,"kind":13},{"name":"$out_AA","containerName":null,"line":1426,"kind":13},{"containerName":null,"name":"%out_AA","kind":13,"line":1426},{"containerName":null,"name":"%verbose","kind":13,"line":1430},{"kind":13,"line":1431,"name":"$self","containerName":null},{"containerName":"main::","name":"debug","kind":12,"line":1431},{"line":1433,"kind":13,"containerName":null,"name":"%status"},{"localvar":"my","name":"@ingroup_codons","definition":"my","containerName":null,"line":1446,"kind":13},{"containerName":null,"name":"%codonvals","line":1446,"kind":13},{"line":1447,"kind":13,"localvar":"my","containerName":null,"name":"$diff_from_out","definition":"my"},{"name":"%codonvals","containerName":null,"kind":13,"line":1447},{"line":1447,"kind":13,"name":"$outcodon","containerName":null},{"containerName":null,"name":"%verbose","kind":13,"line":1449},{"containerName":null,"name":"$self","line":1450,"kind":13},{"name":"debug","containerName":"main::","line":1450,"kind":12},{"containerName":null,"name":"@ingroup_codons","kind":13,"line":1450},{"containerName":null,"name":"%codonvals","kind":13,"line":1451},{"line":1451,"kind":12,"name":"outgroup1"},{"localvar":"my","containerName":null,"definition":"my","name":"$ind","line":1454,"kind":13},{"line":1454,"kind":13,"containerName":null,"name":"%all_alleles"},{"containerName":null,"name":"$self","kind":13,"line":1455},{"name":"debug","containerName":"main::","line":1455,"kind":12},{"containerName":null,"name":"%diff_from_out","line":1460,"kind":13},{"name":"@ingroup_codons","containerName":null,"line":1461,"kind":13},{"containerName":null,"name":"%outcodon","line":1463,"kind":13},{"containerName":null,"name":"%status","line":1464,"kind":13},{"containerName":null,"name":"@ingroup_codons","line":1466,"kind":13},{"name":"%status","containerName":null,"line":1467,"kind":13},{"localvar":"my","containerName":null,"definition":"my","name":"$path","line":1470,"kind":13},{"kind":13,"line":1470,"containerName":null,"name":"%codon_path"},{"containerName":null,"name":"@ingroup_codons","line":1470,"kind":13},{"line":1470,"kind":13,"name":"$outcodon","containerName":null},{"containerName":null,"name":"%two_by_two","line":1471,"kind":13},{"name":"fixed_N","line":1471,"kind":12},{"kind":13,"line":1471,"name":"@path","containerName":null},{"name":"%two_by_two","containerName":null,"kind":13,"line":1472},{"line":1472,"kind":12,"name":"fixed_S"},{"name":"@path","containerName":null,"kind":13,"line":1472},{"kind":13,"line":1473,"name":"%verbose","containerName":null},{"kind":13,"line":1474,"name":"$self","containerName":null},{"kind":12,"line":1474,"containerName":"main::","name":"debug"},{"name":"$self","containerName":null,"line":1475,"kind":13},{"name":"debug","containerName":"main::","kind":12,"line":1475},{"containerName":null,"name":"$path","kind":13,"line":1475},{"kind":13,"line":1476,"name":"$self","containerName":null},{"containerName":"main::","name":"debug","kind":12,"line":1477},{"name":"$codon","containerName":null,"kind":13,"line":1477},{"line":1477,"kind":13,"containerName":null,"name":"@ingroup_codons"},{"kind":13,"line":1477,"containerName":null,"name":"$outcodon"},{"kind":13,"line":1477,"name":"$out_AA","containerName":null},{"name":"%path","containerName":null,"line":1478,"kind":13},{"name":"%two_by_two","containerName":null,"kind":13,"line":1478},{"localvar":"my","containerName":null,"definition":"my","name":"$Ndiff","line":1484,"kind":13},{"containerName":null,"name":"$Sdiff","kind":13,"line":1484},{"containerName":null,"name":"$c","definition":"my","localvar":"my","kind":13,"line":1485},{"containerName":null,"name":"@ingroup_codons","kind":13,"line":1485},{"containerName":null,"name":"$c","line":1486,"kind":13},{"kind":13,"line":1486,"containerName":null,"name":"$outcodon"},{"kind":13,"line":1487,"containerName":null,"definition":"my","name":"$path","localvar":"my"},{"line":1487,"kind":13,"name":"%codon_path","containerName":null},{"name":"$c","containerName":null,"kind":13,"line":1487},{"containerName":null,"name":"$outcodon","kind":13,"line":1487},{"line":1488,"kind":13,"localvar":"my","name":"$tNdiff","definition":"my","containerName":null},{"line":1488,"kind":13,"containerName":null,"name":"$tSdiff"},{"line":1488,"kind":13,"containerName":null,"name":"$path"},{"kind":13,"line":1489,"containerName":null,"name":"@path"},{"name":"$Ndiff","containerName":null,"kind":13,"line":1489},{"containerName":null,"name":"$tNdiff","line":1490,"kind":13},{"line":1490,"kind":13,"containerName":null,"name":"$Ndiff"},{"kind":13,"line":1491,"containerName":null,"name":"$tSdiff"},{"name":"%Sdiff","containerName":null,"line":1491,"kind":13},{"kind":13,"line":1492,"containerName":null,"name":"$Ndiff"},{"name":"$Sdiff","containerName":null,"line":1492,"kind":13},{"containerName":null,"name":"$tNdiff","line":1492,"kind":13},{"kind":13,"line":1492,"containerName":null,"name":"$tSdiff"},{"line":1495,"kind":13,"name":"%two_by_two","containerName":null},{"name":"fixed_N","kind":12,"line":1495},{"kind":13,"line":1495,"containerName":null,"name":"$Ndiff"},{"line":1496,"kind":13,"containerName":null,"name":"%two_by_two"},{"line":1496,"kind":12,"name":"fixed_S"},{"line":1496,"kind":13,"name":"$Sdiff","containerName":null},{"kind":13,"line":1497,"name":"@ingroup_codons","containerName":null},{"containerName":null,"name":"%status","kind":13,"line":1498},{"containerName":null,"definition":"my","name":"$path","localvar":"my","kind":13,"line":1501},{"kind":13,"line":1501,"containerName":null,"name":"%codon_path"},{"name":"@ingroup_codons","containerName":null,"line":1501,"kind":13},{"kind":13,"line":1503,"containerName":null,"name":"%two_by_two"},{"name":"poly_N","line":1503,"kind":12},{"name":"@path","containerName":null,"kind":13,"line":1503},{"containerName":null,"name":"%two_by_two","kind":13,"line":1504},{"name":"poly_S","line":1504,"kind":12},{"containerName":null,"name":"@path","line":1504,"kind":13},{"kind":13,"line":1505,"containerName":null,"name":"%verbose"},{"name":"$self","containerName":null,"line":1506,"kind":13},{"name":"debug","containerName":"main::","line":1506,"kind":12},{"line":1506,"kind":13,"name":"$codon","containerName":null},{"name":"@ingroup_codons","containerName":null,"line":1506,"kind":13},{"name":"$outcodon","containerName":null,"line":1506,"kind":13},{"kind":13,"line":1506,"name":"$out_AA","containerName":null},{"name":"%path","containerName":null,"kind":13,"line":1506},{"line":1506,"kind":13,"name":"%two_by_two","containerName":null},{"containerName":null,"name":"%unq","definition":"my","localvar":"my","kind":13,"line":1511},{"line":1511,"kind":13,"name":"@ingroup_codons","containerName":null},{"line":1512,"kind":13,"name":"%unq","containerName":null},{"containerName":null,"name":"$outcodon","line":1512,"kind":13},{"containerName":null,"definition":"my","name":"@unique_codons","localvar":"my","kind":13,"line":1513},{"containerName":null,"name":"%unq","line":1513,"kind":13},{"localvar":"my","containerName":null,"definition":"my","name":"$Ndiff","line":1518,"kind":13},{"name":"$Sdiff","containerName":null,"kind":13,"line":1518},{"containerName":null,"name":"$c","definition":"my","localvar":"my","kind":13,"line":1519},{"kind":13,"line":1519,"containerName":null,"name":"@unique_codons"},{"kind":13,"line":1520,"name":"$path","definition":"my","containerName":null,"localvar":"my"},{"name":"%codon_path","containerName":null,"line":1520,"kind":13},{"line":1520,"kind":13,"name":"$c","containerName":null},{"line":1520,"kind":13,"containerName":null,"name":"$outcodon"},{"containerName":null,"name":"%path","line":1521,"kind":13},{"name":"$c","containerName":null,"line":1522,"kind":13},{"name":"$outcodon","containerName":null,"line":1522,"kind":13},{"localvar":"my","definition":"my","name":"$tNdiff","containerName":null,"line":1524,"kind":13},{"line":1524,"kind":13,"containerName":null,"name":"$tSdiff"},{"containerName":null,"name":"$path","line":1524,"kind":13},{"line":1525,"kind":13,"name":"@path","containerName":null},{"kind":13,"line":1525,"name":"$Ndiff","containerName":null},{"line":1526,"kind":13,"name":"$tNdiff","containerName":null},{"containerName":null,"name":"$Ndiff","line":1526,"kind":13},{"containerName":null,"name":"$tSdiff","kind":13,"line":1527},{"kind":13,"line":1527,"containerName":null,"name":"%Sdiff"},{"containerName":null,"name":"$Ndiff","kind":13,"line":1528},{"line":1528,"kind":13,"name":"$Sdiff","containerName":null},{"containerName":null,"name":"$tNdiff","kind":13,"line":1528},{"name":"$tSdiff","containerName":null,"kind":13,"line":1528},{"kind":13,"line":1532,"containerName":null,"name":"@unique_codons"},{"containerName":null,"definition":"my","name":"$path","localvar":"my","kind":13,"line":1533},{"kind":13,"line":1533,"containerName":null,"name":"%codon_path"},{"containerName":null,"name":"@unique_codons","kind":13,"line":1533},{"kind":13,"line":1534,"containerName":null,"name":"%path"},{"line":1535,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":1535,"name":"throw","containerName":"main::"},{"line":1537,"kind":13,"name":"$Ndiff","containerName":null},{"line":1537,"kind":13,"name":"@path","containerName":null},{"containerName":null,"name":"$Sdiff","line":1538,"kind":13},{"containerName":null,"name":"@path","kind":13,"line":1538},{"name":"%two_by_two","containerName":null,"line":1540,"kind":13},{"kind":12,"line":1540,"name":"poly_N"},{"kind":13,"line":1540,"containerName":null,"name":"$Ndiff"},{"name":"%two_by_two","containerName":null,"kind":13,"line":1541},{"name":"poly_S","line":1541,"kind":12},{"line":1541,"kind":13,"name":"$Sdiff","containerName":null},{"line":1542,"kind":13,"name":"%verbose","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":1543},{"containerName":"main::","name":"debug","line":1543,"kind":12},{"line":1543,"kind":13,"name":"$codon","containerName":null},{"kind":13,"line":1543,"containerName":null,"name":"@ingroup_codons"},{"containerName":null,"name":"$outcodon","line":1543,"kind":13},{"containerName":null,"name":"$out_AA","line":1543,"kind":13},{"kind":13,"line":1544,"name":"$Ndiff","containerName":null},{"line":1544,"kind":13,"name":"%Sdiff","containerName":null},{"containerName":null,"name":"%two_by_two","kind":13,"line":1544},{"line":1550,"kind":13,"containerName":null,"name":"%two_by_two"},{"kind":13,"line":1551,"containerName":null,"name":"%two_by_two"},{"kind":13,"line":1552,"containerName":null,"name":"%two_by_two"},{"name":"%two_by_two","containerName":null,"kind":13,"line":1553},{"name":"%status","containerName":null,"kind":13,"line":1554},{"line":1578,"children":[{"containerName":"mcdonald_kreitman_counts","name":"$self","definition":"my","localvar":"my","kind":13,"line":1579},{"kind":13,"line":1579,"containerName":"mcdonald_kreitman_counts","name":"$Npoly"},{"line":1579,"kind":13,"containerName":"mcdonald_kreitman_counts","name":"$Nfix"},{"kind":13,"line":1579,"containerName":"mcdonald_kreitman_counts","name":"$Spoly"},{"line":1579,"kind":13,"name":"$Sfix","containerName":"mcdonald_kreitman_counts"},{"kind":13,"line":1580,"name":"$has_twotailed","containerName":"mcdonald_kreitman_counts"},{"line":1582,"kind":13,"containerName":"mcdonald_kreitman_counts","name":"$Npoly"},{"name":"$Npoly","containerName":"mcdonald_kreitman_counts","line":1583,"kind":13},{"line":1583,"kind":13,"containerName":"mcdonald_kreitman_counts","name":"$Spoly"},{"name":"$Npoly","containerName":"mcdonald_kreitman_counts","kind":13,"line":1584},{"line":1584,"kind":13,"name":"$Nfix","containerName":"mcdonald_kreitman_counts"},{"line":1585,"kind":13,"name":"$Npoly","containerName":"mcdonald_kreitman_counts"},{"line":1585,"kind":13,"containerName":"mcdonald_kreitman_counts","name":"$Nfix"},{"name":"$Spoly","containerName":"mcdonald_kreitman_counts","kind":13,"line":1585},{"line":1585,"kind":13,"containerName":"mcdonald_kreitman_counts","name":"$Sfix"},{"containerName":"mcdonald_kreitman_counts","name":"$self","kind":13,"line":1587},{"containerName":"mcdonald_kreitman_counts","name":"warn","kind":12,"line":1587}],"kind":12,"detail":"($self,$Npoly,$Nfix,$Spoly,$Sfix)","signature":{"parameters":[{"label":"$self"},{"label":"$Npoly"},{"label":"$Nfix"},{"label":"$Spoly"},{"label":"$Sfix"}],"documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Statistics - Population Genetics statistical tests  \n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Statistics;\n  use Bio::AlignIO;\n  use Bio::PopGen::IO;\n  use Bio::PopGen::Simulation::Coalescent;\n\n  my $sim = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 12);\n\n  my $tree = $sim->next_tree;\n\n  $sim->add_Mutations($tree,20);\n\n  my $stats = Bio::PopGen::Statistics->new();\n  my $individuals = [ $tree->get_leaf_nodes];\n  my $pi = $stats->pi($individuals);\n  my $D  = $stats->tajima_D($individuals);\n\n  # Alternatively to do this on input data from\n  # See the tests in t/PopGen.t for more examples\n  my $parser = Bio::PopGen::IO->new(-format => 'prettybase',\n                                   -file   => 't/data/popstats.prettybase');\n  my $pop = $parser->next_population;\n  # Note that you can also call the stats as a class method if you like\n  # the only reason to instantiate it (as above) is if you want\n  # to set the verbosity for debugging\n  $pi     = Bio::PopGen::Statistics->pi($pop);\n  $theta  = Bio::PopGen::Statistics->theta($pop);\n\n  # Pi and Theta also take additional arguments,\n  # see the documentation for more information\n\n  use Bio::PopGen::Utilities;\n  use Bio::AlignIO;\n\n  my $in = Bio::AlignIO->new(-file   => 't/data/t7.aln',\n                            -format => 'clustalw');\n  my $aln = $in->next_aln;\n  # get a population, each sequence is an individual and \n  # for the default case, every site which is not monomorphic\n  # is a 'marker'.  Each individual will have a 'genotype' for the\n  # site which will be the specific base in the alignment at that\n  # site\n\n  my $pop = Bio::PopGen::Utilities->aln_to_population(-alignment => $aln);\n\n\n=head1 DESCRIPTION\n\nThis object is intended to provide implementations some standard\npopulation genetics statistics about alleles in populations.\n\nThis module was previously named Bio::Tree::Statistics.\n\nThis object is a place to accumulate routines for calculating various\nstatistics from the coalescent simulation, marker/allele, or from\naligned sequence data given that you can calculate alleles, number of\nsegregating sites.\n\nCurrently implemented:\n Fu and Li's D    (fu_and_li_D)\n Fu and Li's D*   (fu_and_li_D_star)\n Fu and Li's F    (fu_and_li_F)\n Fu and Li's F*   (fu_and_li_F_star)\n Tajima's D       (tajima_D)\n Watterson's theta (theta)\n pi               (pi) - number of pairwise differences\n composite_LD     (composite_LD)\n McDonald-Kreitman (mcdonald_kreitman or MK)\n\nCount based methods also exist in case you have already calculated the\nkey statistics (seg sites, num individuals, etc) and just want to\ncompute the statistic.\n\nIn all cases where a the method expects an arrayref of\nL<Bio::PopGen::IndividualI> objects and L<Bio::PopGen::PopulationI>\nobject will also work.\n\n=head2 REFERENCES\n\nFu Y.X and Li W.H. (1993) \"Statistical Tests of Neutrality of\nMutations.\" Genetics 133:693-709.\n\nFu Y.X. (1996) \"New Statistical Tests of Neutrality for DNA samples\nfrom a Population.\" Genetics 143:557-570.\n\nMcDonald J, Kreitman M.\n\nTajima F. (1989) \"Statistical method for testing the neutral mutation\nhypothesis by DNA polymorphism.\" Genetics 123:585-595.\n\n\n=head2 CITING THIS WORK\n\nPlease see this reference for use of this implementation.\n\nStajich JE and Hahn MW \"Disentangling the Effects of Demography and Selection in Human History.\" (2005) Mol Biol Evol 22(1):63-73. \n\nIf you use these Bio::PopGen modules please cite the Bioperl\npublication (see FAQ) and the above reference.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\nMcDonald-Kreitman implementation based on work by Alisha Holloway at\nUC Davis.\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Statistics;\nuse strict;\nuse constant { \n    in_label => 'ingroup',\n    out_label => 'outgroup',\n    non_syn   => 'non_synonymous',\n    syn       => 'synonymous',\n    default_codon_table => 1, # Standard Codon table\n};\n\nuse Bio::MolEvol::CodonModel;\nuse List::Util qw(sum);\n\nuse base qw(Bio::Root::Root);\nour $codon_table => default_codon_table;\nour $has_twotailed => 0;\nBEGIN {\n    eval { require Text::NSP::Measures::2D::Fisher2::twotailed };\n    if( $@ ) { $has_twotailed = 0; }\n    else { $has_twotailed = 1; }\n}\n\n\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Statistics->new();\n Function: Builds a new Bio::PopGen::Statistics object \n Returns : an instance of Bio::PopGen::Statistics\n Args    : none\n\n\n\n\n=head2 fu_and_li_D\n\n Title   : fu_and_li_D\n Usage   : my $D = $statistics->fu_and_li_D(\\@ingroup,\\@outgroup);\n\t    OR\n\t   my $D = $statistics->fu_and_li_D(\\@ingroup,$extmutations);\n Function: Fu and Li D statistic for a list of individuals\n           given an outgroup and the number of external mutations\n           (either provided or calculated from list of outgroup individuals)\n Returns : decimal\n Args    : $individuals - array reference which contains ingroup individuals \n           (L<Bio::PopGen::Individual> or derived classes)\n           $extmutations - number of external mutations OR\n           arrayref of outgroup individuals\n\n\nsub fu_and_li_D { \n    my ($self,$ingroup,$outgroup) = @_;\n\n    my ($seg_sites,$n,$ancestral,$derived) = (0,0,0,0);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D\");\n\treturn 0;\n    }\n    \n    if( $seg_sites <= 0 ) { \n\t$self->warn(\"mutation total was not > 0, cannot calculate a Fu and Li D\");\n\treturn 0;\n    }\n\n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($ancestral,$derived) = $self->derived_mutations($ingroup,$outgroup);\n\t$ancestral = 0 unless defined $ancestral;\n    } else { \n\t$ancestral = $outgroup;\n    }\n   \n    return $self->fu_and_li_D_counts($n,$seg_sites,\n\t\t\t\t     $ancestral,$derived);\n}\n\n=head2 fu_and_li_D_counts\n\n Title   : fu_li_D_counts\n Usage   : my $D = $statistics->fu_and_li_D_counts($samps,$sites,\n                                                   $external);\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           number of external mutations (n_e)\n\n\n\nsub fu_and_li_D_counts {\n    my ($self,$n,$seg_sites, $external_mut) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v = 1 + ( ( $a_n**2 / ( $b + $a_n**2 ) ) * \n\t\t  ( $c - ( ( $n + 1) /\n\t\t\t   ( $n - 1) ) ));\n    \n    my $u = $a_n - 1 - $v;\n\n    ($seg_sites - $a_n * $external_mut) / \n\tsqrt( ($u * $seg_sites) + ($v * $seg_sites*$seg_sites));\n    \n}\n\n\n=head2 fu_and_li_D_star\n\n Title   : fu_and_li_D_star\n Usage   : my $D = $statistics->fu_an_li_D_star(\\@individuals);\n Function: Fu and Li's D* statistic for a set of samples\n            Without an outgroup\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#'\n# fu_and_li_D*\n\nsub fu_and_li_D_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_D_star\");\n\treturn 0;\n    }\n\n    return $self->fu_and_li_D_star_counts($n,$seg_sites, $singletons);\n}\n\n=head2 fu_and_li_D_star_counts\n\n Title   : fu_li_D_star_counts\n Usage   : my $D = $statistics->fu_and_li_D_star_counts($samps,$sites,\n                                                        $singletons);\n\n Function: Fu and Li D statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           singletons (n_s)\n\n\n\nsub fu_and_li_D_star_counts {\n    my ($self,$n,$seg_sites, $singletons) = @_;\n    my $a_n;\n    for(my $k = 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + 1 / $n;\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n        $b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) /\n                  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $d = $c + ($n -2) / ($n - 1)**2 +\n\t2 / ($n -1) * \n\t( 1.5 - ( (2*$a1 - 3) / ($n -2) ) - \n\t  1 / $n ); \n    \n    my $v_star = ( ( ($n/($n-1) )**2)*$b + (($a_n**2)*$d) -\n\t\t (2*( ($n*$a_n*($a_n+1)) )/(($n-1)**2)) )  /\n\t\t   (($a_n**2) + $b);\n\n    my $u_star = ( ($n/($n-1))*\n\t\t   ($a_n - ($n/\n\t\t\t  ($n-1)))) - $v_star;\n\n\n    return (($n / ($n - 1)) * $seg_sites - \n\t    $a_n * $singletons) / \n\t    sqrt( ($u_star * $seg_sites) + ($v_star * $seg_sites*$seg_sites));\n}\n\n\n=head2 fu_and_li_F\n\n Title   : fu_and_li_F\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F(\\@ingroup,$ext_muts);\n Function: Calculate Fu and Li's F on an ingroup with either the set of \n           outgroup individuals, or the number of external mutations\n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR a L<Bio::PopGen::PopulationI> object\n           number of external mutations OR list of individuals for the outgroup\n\n\n#'\n\nsub fu_and_li_F {\n    my ($self,$ingroup,$outgroup) = @_;\n    my ($seg_sites,$pi,$n,$external,$internal);\n    if( ref($ingroup) =~ /ARRAY/i ) {\n\t$n = scalar @$ingroup;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($ingroup);  \n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } elsif( ref($ingroup) && \n\t     $ingroup->isa('Bio::PopGen::PopulationI')) {\n\t$n = $ingroup->get_number_individuals;\n\t$pi          = $self->pi($ingroup);\n\t$seg_sites   = $self->segregating_sites_count($ingroup);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to Fu and Li's F\");\n\treturn 0;\n    }\n    \n    if( ! defined $outgroup ) {\n\t$self->warn(\"Need to provide either an array ref to the outgroup individuals or the number of external mutations\");\n\treturn 0;\n    } elsif( ref($outgroup) ) {\n\t($external,$internal) = $self->derived_mutations($ingroup,$outgroup);\n    } else { \n\t$external = $outgroup;\n    }\n    $self->fu_and_li_F_counts($n,$pi,$seg_sites,$external);\n}\n\n=head2 fu_and_li_F_counts\n\n Title   : fu_li_F_counts\n Usage   : my $F = $statistics->fu_and_li_F_counts($samps,$pi,\n                                                   $sites,\n                                                   $external);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           external mutations (n_e)\n\n\n\nsub fu_and_li_F_counts {\n    my ($self,$n,$pi,$seg_sites, $external) = @_;\n    my $a_n = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a_n += ( 1 / $k );\n    }\n\n    my $a1 = $a_n + (1 / $n );\n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += ( 1 / $k**2 );\n    }\n\n    my $c = 2 * ( ( ( $n * $a_n ) - (2 * ( $n -1 ))) / \n\t\t  ( ( $n - 1) * ( $n - 2 ) ) );\n\n    my $v_F = ( $c + ( (2*(($n**2)+$n+3)) / \n\t\t       ( (9*$n)*($n-1) ) ) -\n\t\t(2/($n-1)) ) / ( ($a_n**2)+$b );\n\n    my $u_F = ( 1 + ( ($n+1)/(3*($n-1)) )-\n\t\t( 4*( ($n+1)/(($n-1)**2) ))*\n\t\t($a1 - ((2*$n)/($n+1))) ) /\n\t\t$a_n - $v_F;\n\n    # warn(\"$v_F vf $u_F uf n = $n\\n\");\n    my $F = ($pi - $external) / ( sqrt( ($u_F*$seg_sites) +\n\t\t\t\t\t($v_F*($seg_sites**2)) ) );\n\n    return $F;\n}\n\n=head2 fu_and_li_F_star\n\n Title   : fu_and_li_F_star\n Usage   : my $F = Bio::PopGen::Statistics->fu_and_li_F_star(\\@ingroup);\n Function: Calculate Fu and Li's F* on an ingroup without an outgroup\n           It uses count of singleton alleles instead \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects for the ingroup\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n#' keep my emacs happy\n\nsub fu_and_li_F_star {\n    my ($self,$individuals) = @_;\n\n    my ($seg_sites,$pi,$n,$singletons);\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites   = $self->segregating_sites_count($individuals);\n\t$singletons  = $self->singleton_count($individuals);\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites   = $self->segregating_sites_count($pop);\n\t$singletons  = $self->singleton_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to fu_and_li_F_star\");\n\treturn 0;\n    }\n    return $self->fu_and_li_F_star_counts($n,\n\t\t\t\t\t  $pi,\n\t\t\t\t\t  $seg_sites,\n\t\t\t\t\t  $singletons);\n} \n\n=head2 fu_and_li_F_star_counts\n\n Title   : fu_li_F_star_counts\n Usage   : my $F = $statistics->fu_and_li_F_star_counts($samps,\n                                                   $pi,$sites,\n                                                   $singletons);\n Function: Fu and Li F statistic for the raw counts of the number\n           of samples, sites, external and internal mutations\n Returns : decimal number\n Args    : number of samples (N)\n           average pairwise differences (pi)\n           number of segregating sites (n)\n           singleton  mutations (n_s)\n\n\n\nsub fu_and_li_F_star_counts {\n    my ($self,$n,$pi,$seg_sites, $singletons) = @_;\n    if( $n <= 1 ) {\n\t$self->warn(\"N must be > 1\\n\");\n\treturn;\n    }\n    if( $n == 2) { \n\treturn 0;\n    } \n\n    my $a_n = 0;\n    \n\n    my $b = 0;\n    for(my $k= 1; $k < $n; $k++ ) {\n\t$b += (1 / ($k**2));\n\t$a_n += ( 1 / $k );     # Eq (2)\n    }\n    my $a1 = $a_n + (1 / $n );\n\n    # warn(\"a_n is $a_n a1 is $a1 n is $n b is $b\\n\");\n\n    # From Simonsen et al (1995) instead of Fu and Li 1993\n    my $v_F_star = ( (( 2 * $n ** 3 + 110 * $n**2 - (255 * $n) + 153)/\n\t\t      (9 * ($n ** 2) * ( $n - 1))) +\n\t\t     ((2 * ($n - 1) * $a_n ) / $n ** 2) -\n\t\t     (8 * $b / $n) ) / \n\t\t     ( ($a_n ** 2) + $b );\n    \n    my $u_F_star = ((( (4* ($n**2)) + (19 * $n) + 3 - (12 * ($n + 1)* $a1)) /\n\t\t    (3 * $n * ( $n - 1))) / $a_n) - $v_F_star;\n\n    # warn(\"vf* = $v_F_star uf* = $u_F_star n = $n\\n\");\n    my $F_star = ( $pi - ($singletons*( ( $n-1) / $n)) ) /\n\tsqrt ( $u_F_star*$seg_sites + $v_F_star*$seg_sites**2);\n    return $F_star;\n}\n\n=head2 tajima_D\n\n Title   : tajima_D\n Usage   : my $D = Bio::PopGen::Statistics->tajima_D(\\@samples);\n Function: Calculate Tajima's D on a set of samples \n Returns : decimal number\n Args    : array ref of L<Bio::PopGen::IndividualI> objects\n           OR \n           L<Bio::PopGen::PopulationI> object\n\n\n\n#'\n\nsub tajima_D {\n    my ($self,$individuals) = @_;\n    my ($seg_sites,$pi,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t$n = scalar @$individuals;\n\t# pi - all pairwise differences \n\t$pi          = $self->pi($individuals);  \n\t$seg_sites = $self->segregating_sites_count($individuals);\n\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI')) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\t$pi          = $self->pi($pop);\n\t$seg_sites = $self->segregating_sites_count($pop);\n    } else { \n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI OR a Bio::PopGen::PopulationI object to tajima_D\");\n\treturn 0;\n    }\n    $self->tajima_D_counts($n,$seg_sites,$pi);\n}\n\n=head2 tajima_D_counts\n\n Title   : tajima_D_counts\n Usage   : my $D = $statistics->tajima_D_counts($samps,$sites,$pi);\n Function: Tajima's D statistic for the raw counts of the number\n           of samples, sites, and avg pairwise distances (pi)\n Returns : decimal number\n Args    : number of samples (N)\n           number of segregating sites (n)\n           average pairwise differences (pi)\n\n\n#'\n\nsub tajima_D_counts {\n    my ($self,$n,$seg_sites,$pi) = @_;\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }\n\n     my $a2 = 0;\n     for(my $k= 1; $k < $n; $k++ ) {\n\t $a2 += ( 1 / $k**2 );\n     }\n    \n    my $b1 = ( $n + 1 ) / ( 3* ( $n - 1) );\n    my $b2 = ( 2 * ( $n ** 2 + $n + 3) ) / \n\t     ( ( 9 * $n) * ( $n - 1) );\n    my $c1 = $b1 - ( 1 / $a1 );\n    my $c2 = $b2 - ( ( $n + 2 ) /\n\t\t     ( $a1 * $n))+( $a2 / $a1 ** 2);\n    my $e1 = $c1 / $a1;\n    my $e2 = $c2 / ( $a1**2 + $a2 );\n    \n    my $denom = sqrt ( ($e1 * $seg_sites) + (( $e2 * $seg_sites) * ( $seg_sites - 1)));\n    return if $denom == 0;\n    my $D = ( $pi - ( $seg_sites / $a1 ) ) / $denom;\n    return $D;\n}\n\n\n=head2 pi\n\n Title   : pi\n Usage   : my $pi = Bio::PopGen::Statistics->pi(\\@inds)\n Function: Calculate pi (average number of pairwise differences) given\n           a list of individuals which have the same number of markers\n           (also called sites) as available from the get_Genotypes()\n           call in L<Bio::PopGen::IndividualI>\n Returns : decimal number\n Args    : Arg1= array ref of L<Bio::PopGen::IndividualI> objects\n             which have markers/mutations.  We expect all individuals to\n             have a marker - we will deal with missing data as a special case.\n           OR\n           Arg1= L<Bio::PopGen::PopulationI> object.  In the event that\n                 only allele frequency data is available, storing it in\n                 Population object will make this available.\n           num sites [optional], an optional second argument (integer)\n             which is the number of sites, then pi returned is pi/site.\n\n\nsub pi {\n    my ($self,$individuals,$numsites) = @_;\n    my (%data,%marker_total,@marker_names,$n);\n\n    if( ref($individuals) =~ /ARRAY/i ) {\n\t# one possible argument is an arrayref of Bio::PopGen::IndividualI objs\n\t@marker_names = $individuals->[0]->get_marker_names;\n\t$n = scalar @$individuals;\n\n\t# Here we are calculating the allele frequencies\n\tforeach my $ind ( @$individuals ) {\n\t    if( ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t\t$self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($ind).\"\\n\");\n\t\treturn 0;\n\t    }\n\t    foreach my $m ( @marker_names ) {\n\t\tforeach my $allele (map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t    $data{$m}->{$allele}++;\n\t\t    $marker_total{$m}++;\n\t\t}\n\t    }\n\t}\n#\twhile( my ($marker,$count) =  each %marker_total ) {\n#\t    foreach my $c ( values %{$data{$marker}} ) {\n#\t\t$c /= $count;\n#\t    }\n#\t}\n\t# %data will contain allele frequencies for each marker, allele\n    } elsif( ref($individuals) &&\n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t$n = $pop->get_number_individuals;\n\tforeach my $marker( $pop->get_Markers ) {\n\t    push @marker_names, $marker->name;\n\t    #$data{$marker->name} = {$marker->get_Allele_Frequencies};\n\t    my @genotypes = $pop->get_Genotypes(-marker => $marker->name);\n\t    for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t      $data{$marker->name}->{$al}++;\n\t      $marker_total{$marker->name}++;\n\t   }\n\t}\n    } else {\n\t$self->throw(\"expected an array reference of a list of Bio::PopGen::IndividualI to pi\");\n    }\n    # based on Kevin Thornton's code:\n    # http://molpopgen.org/software/libsequence/doc/html/PolySNP_8cc-source.html#l00152\n    # For now we assume that all individuals have the same markers\n    my ($diffcount,$totalcompare) = (0,0);\n    my $pi = 0;\n    while ( my ($marker,$markerdat) = each %data ) {\n      my $sampsize = $marker_total{$marker};\n      my $ssh = 0;\n      my @alleles = keys %$markerdat;\n      if ( $sampsize > 1 ) {\n\tmy $denom = $sampsize * ($sampsize - 1.0);\n\tforeach my $al ( @alleles ) {\n\t  $ssh += ($markerdat->{$al} * ($markerdat->{$al} - 1)) / $denom;\n\t}\n\t$pi += 1.0 - $ssh;\n      }\n    }\n    $self->debug( \"pi=$pi\\n\");\n    if( $numsites ) {\n\treturn $pi / $numsites;\n    } else {\n\treturn $pi;\n    }\n}\n\n\n=head2 theta\n\n Title   : theta\n Usage   : my $theta = Bio::PopGen::Statistics->theta($sampsize,$segsites);\n Function: Calculates Watterson's theta from the sample size \n           and the number of segregating sites.\n           Providing the third parameter, total number of sites will\n           return theta per site.\n           This is also known as K-hat = K / a_n   \n Returns : decimal number \n Args    : sample size (integer),\n           num segregating sites (integer)\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an arrayref of the L<Bio::PopGen::IndividualI> objects\n           total sites (integer) [optional] (to calculate theta per site)\n           OR\n           provide an L<Bio::PopGen::PopulationI> object\n           total sites (integer)[optional]\n\n\n#'\n\nsub theta {\n    my $self = shift;\n    my ( $n, $seg_sites,$totalsites) = @_;\n    if( ref($n) =~ /ARRAY/i ) {\n\tmy $samps = $n;\n\t$totalsites = $seg_sites; # only 2 arguments if one is an array\n\tmy %data;\n\tmy @marker_names = $samps->[0]->get_marker_names;\n\t# we need to calculate number of polymorphic sites\n\t$seg_sites = $self->segregating_sites_count($samps);\n\t$n = scalar @$samps;\n\n    } elsif(ref($n) &&\n\t    $n->isa('Bio::PopGen::PopulationI') ) {\n\t# This will handle the case when we pass in a PopulationI object\n\tmy $pop = $n;\n\t$totalsites = $seg_sites; # shift the arguments over by one\n\t$n = $pop->haploid_population->get_number_individuals;\n\t$seg_sites = $self->segregating_sites_count($pop);\n    }\n    my $a1 = 0; \n    for(my $k= 1; $k < $n; $k++ ) {\n\t$a1 += ( 1 / $k );\n    }    \n    if( $totalsites ) { # 0 and undef are the same can't divide by them\n\t$seg_sites /= $totalsites;\n    }\n    if( $a1 == 0 ) { \n\treturn 0;\n    } \n    return $seg_sites / $a1;\n}\n\n=head2 singleton_count\n\n Title   : singleton_count\n Usage   : my ($singletons) = Bio::PopGen::Statistics->singleton_count(\\@inds)\n Function: Calculate the number of mutations/alleles which only occur once in\n           a list of individuals for all sites/markers\n Returns : (integer) number of alleles which only occur once (integer)\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects\n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\nsub singleton_count {\n    my ($self,$individuals) = @_;\n\n    my @inds;\n    if( ref($individuals) =~ /ARRAY/ ) {\n\t@inds = @$individuals;\n    } elsif( ref($individuals) && \n\t     $individuals->isa('Bio::PopGen::PopulationI') ) {\n\tmy $pop = $individuals;\n\t@inds = $pop->get_Individuals();\n\tunless( @inds ) { \n\t    $self->warn(\"Need to provide a population which has individuals loaded, not just a population with allele frequencies\");\n\t    return 0;\n\t}\n    } else {\n\t$self->warn(\"Expected either a PopulationI object or an arrayref of IndividualI objects\");\n\treturn 0;\n    }\n    # find number of sites where a particular allele is only seen once\n\n    my ($singleton_allele_ct,%sites) = (0);\n    # first collect all the alleles into a hash structure\n    \n    foreach my $n ( @inds ) {\n\tif( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t    return 0;\n\t}\n\tforeach my $g ( $n->get_Genotypes ) {\n\t    my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t    foreach my $allele (@alleles ) {\n\t\t$sites{$nm}->{$allele}++;\n\t    }\n\t}\n    }\n    foreach my $site ( values %sites ) { # don't really care what the name is\n\tforeach my $allelect ( values %$site ) { # \n            # find the sites which have an allele with only 1 copy\n \t    $singleton_allele_ct++ if( $allelect == 1 );\n\t}\n    }\n    return $singleton_allele_ct;\n}\n\n# Yes I know that singleton_count and segregating_sites_count are\n# basically processing the same data so calling them both is\n# redundant, something I want to fix later but want to make things\n# correct and simple first\n\n=head2 segregating_sites_count\n\n Title   : segregating_sites_count\n Usage   : my $segsites = Bio::PopGen::Statistics->segregating_sites_count\n Function: Gets the number of segregating sites (number of polymorphic sites)\n Returns : (integer) number of segregating sites\n Args    : arrayref of L<Bio::PopGen::IndividualI> objects \n           OR\n           L<Bio::PopGen::PopulationI> object\n\n\n# perhaps we'll change this in the future \n# to return the actual segregating sites\n# so one can use this to pull in the names of those sites.\n# Would be trivial if it is useful.\n\nsub segregating_sites_count {\n   my ($self,$individuals) = @_;\n   my $type = ref($individuals);\n   my $seg_sites = 0;\n   if( $type =~ /ARRAY/i ) {\n       my %sites;\n       foreach my $n ( @$individuals ) {\n\t   if( ! $n->isa('Bio::PopGen::IndividualI') ) {\n\t       $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects, this is a \".ref($n).\"\\n\");\n\t       return 0;\n\t   }\n\t   foreach my $g ( $n->get_Genotypes ) {\n\t       my ($nm,@alleles) = ($g->marker_name, $g->get_Alleles);\n\t       foreach my $allele (@alleles ) {\n\t\t   $sites{$nm}->{$allele}++;\n\t       }\n\t   }\n       }\n       foreach my $site ( values %sites ) { # use values b/c we don't \n\t                                    # really care what the name is\n\t   # find the sites which >1 allele\n\t   $seg_sites++ if( keys %$site > 1 );\n       }\n   } elsif( $type && $individuals->isa('Bio::PopGen::PopulationI') ) {\n       foreach my $marker ( $individuals->haploid_population->get_Markers ) {  \n\t   my @alleles = $marker->get_Alleles;\t    \n\t   $seg_sites++ if ( scalar @alleles > 1 );\n       }\n   } else { \n       $self->warn(\"segregating_sites_count expects either a PopulationI object or a list of IndividualI objects\");\n       return 0;\n   } \n   return $seg_sites;\n}\n\n\n=head2 heterozygosity\n\n Title   : heterozygosity\n Usage   : my $het = Bio::PopGen::Statistics->heterozygosity($sampsize,$freq1);\n Function: Calculate the heterozgosity for a sample set for a set of alleles\n Returns : decimal number\n Args    : sample size (integer)\n           frequency of one allele (fraction - must be less than 1)\n           [optional] frequency of another allele - this is only needed\n                      in a non-binary allele system\n\nNote     : p^2 + 2pq + q^2\n\n\n\nsub heterozygosity {\n    my ($self,$samp_size, $freq1,$freq2) = @_;\n    if( ! $freq2 ) { $freq2 = 1 - $freq1 }\n    if( $freq1 > 1 || $freq2 > 1 ) { \n\t$self->warn(\"heterozygosity expects frequencies to be less than 1\");\n    }\n    my $sum = ($freq1**2) + (($freq2)**2);\n    my $h = ( $samp_size*(1- $sum) ) / ($samp_size - 1) ;\n    return $h;\n}\n\n\n=head2 derived_mutations\n\n Title   : derived_mutations\n Usage   : my $ext = Bio::PopGen::Statistics->derived_mutations($ingroup,$outgroup);\n Function: Calculate the number of alleles or (mutations) which are ancestral\n           and the number which are derived (occurred only on the tips)\n Returns : array of 2 items - number of external and internal derived \n           mutation\n Args    : ingroup - L<Bio::PopGen::IndividualI>s arrayref OR \n                     L<Bio::PopGen::PopulationI>\n           outgroup- L<Bio::PopGen::IndividualI>s arrayref OR \n                     L<Bio::PopGen::PopulationI> OR\n                     a single L<Bio::PopGen::IndividualI>\n\n\nsub derived_mutations {\n   my ($self,$ingroup,$outgroup) = @_;\n   my (%indata,%outdata,@marker_names);\n\n   # basically we have to do some type checking\n   # if that perl were typed...\n   my ($itype,$otype) = (ref($ingroup),ref($outgroup));\n\n   return $outgroup unless( $otype ); # we expect arrayrefs or objects, nums\n                                      # are already the value we \n                                      # are searching for\n   # pick apart the ingroup\n   # get the data\n   if( ref($ingroup) =~ /ARRAY/i ) {\n       if( ! ref($ingroup->[0]) ||\n\t   ! $ingroup->[0]->isa('Bio::PopGen::IndividualI') ) {\n\t   $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects or a Population for ingroup in external_mutations\");\n\t   return 0;\n       }\n       # we assume that all individuals have the same markers \n       # i.e. that they are aligned\n       @marker_names = $ingroup->[0]->get_marker_names;\n       for my $ind ( @$ingroup ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles }\n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $indata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\t   \n   } elsif( ref($ingroup) && $ingroup->isa('Bio::PopGen::PopulationI') ) {\n       @marker_names = $ingroup->get_marker_names;\n       for my $ind ( $ingroup->haploid_population->get_Individuals() ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $indata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   } else { \n       $self->warn(\"Need an arrayref of Bio::PopGen::IndividualI objs or a Bio::PopGen::Population for ingroup in external_mutations\");\n       return 0;\n   }\n    \n   if( $otype =~ /ARRAY/i ) {\n       if( ! ref($outgroup->[0]) ||\n\t   ! $outgroup->[0]->isa('Bio::PopGen::IndividualI') ) {\n\t   $self->warn(\"Expected an arrayref of Bio::PopGen::IndividualI objects or a Population for outgroup in external_mutations\");\n\t   return 0;\n       }\n       for my $ind ( @$outgroup ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles }\n\t\t\t\t$ind->get_Genotypes($m) ) {\n\t\t   $outdata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   \n   } elsif( $otype->isa('Bio::PopGen::PopulationI') ) {\n       for my $ind ( $outgroup->haploid_population->get_Individuals() ) {\n\t   for my $m ( @marker_names ) {\n\t       for my $allele ( map { $_->get_Alleles} \n\t\t\t\t    $ind->get_Genotypes($m) ) {\n\t\t   $outdata{$m}->{$allele}++;\n\t       }\n\t   }\n       }\n   } else {\n       $self->warn(\"Need an arrayref of Bio::PopGen::IndividualI objs or a Bio::PopGen::Population for outgroup in external_mutations\");\n       return 0;\n   }\n   \n   # derived mutations are defined as \n   # \n   # ingroup  (G A T)\n   # outgroup (A)\n   # derived mutations are G and T, A is the external mutation\n   \n   # ingroup  (A T)\n   # outgroup (C)\n   # derived mutations A,T no external/ancestral mutations\n   \n   # ingroup  (G A T)\n   # outgroup (A T)\n   # cannot determine\n  \n   my ($internal,$external);\n   foreach my $marker ( @marker_names ) {\n       my @outalleles = keys %{$outdata{$marker}};\n       my @in_alleles = keys %{$indata{$marker}};\n       next if( @outalleles > 1 || @in_alleles == 1);\n       for my $allele ( @in_alleles ) {\n\t   if( ! exists $outdata{$marker}->{$allele} ) { \n\t       if( $indata{$marker}->{$allele} == 1 ) { \n\t\t   $external++;\n\t       } else { \n\t\t   $internal++;\n\t       }\n\t   }\n       }\n   }\n   return ($external, $internal);\n}\n\n\n=head2 composite_LD\n\n Title   : composite_LD\n Usage   : %matrix = Bio::PopGen::Statistics->composite_LD($population);\n Function: Calculate the Linkage Disequilibrium \n           This is for calculating LD for unphased data. \n           Other methods will be appropriate for phased haplotype data.\n\n Returns : Hash of Hashes - first key is site 1,second key is site 2\n           and value is LD for those two sites.\n           my $LDarrayref = $matrix{$site1}->{$site2};\n           my ($ldval, $chisquared) = @$LDarrayref;\n Args    : L<Bio::PopGen::PopulationI> or arrayref of \n           L<Bio::PopGen::IndividualI>s \n Reference: Weir B.S. (1996) \"Genetic Data Analysis II\", \n                      Sinauer, Sunderlanm MA.\n\n\nsub composite_LD {\n    my ($self,$pop) = @_;\n    if( ref($pop) =~ /ARRAY/i ) {\n\tif( ref($pop->[0]) && $pop->[0]->isa('Bio::PopGen::IndividualI') ) {\n\t    $pop = Bio::PopGen::Population->new(-individuals => @$pop);\n\t} else { \n\t    $self->warn(\"composite_LD expects a Bio::PopGen::PopulationI or an arrayref of Bio::PopGen::IndividualI objects\");\n\t    return ();\n\t}\n    } elsif( ! ref($pop) || ! $pop->isa('Bio::PopGen::PopulationI') ) {\n\t$self->warn(\"composite_LD expects a Bio::PopGen::PopulationI or an arrayref of Bio::PopGen::IndividualI objects\");\n\treturn ();\n    }\n\n    my @marker_names = $pop->get_marker_names;\n    my @inds = $pop->get_Individuals;\n    my $num_inds = scalar @inds;\n    my (%lookup);\n    # calculate allele frequencies for each marker from the population\n    # use the built-in get_Marker to get the allele freqs\n    # we still need to calculate the genotype frequencies\n    foreach my $marker_name ( @marker_names ) {\t\n\tmy(%allelef);\n\n\tforeach my $ind ( @inds ) {\n\t    my ($genotype) = $ind->get_Genotypes(-marker => $marker_name);\n\t    if( ! defined $genotype ) { \n\t\t$self->warn(\"no genotype for marker $marker_name for individual \". $ind->unique_id. \"\\n\");\n\t\tnext;\n\t    }\n\t    my @alleles  = sort $genotype->get_Alleles;\n\t    next if( scalar @alleles != 2);\n\t    my $genostr  = join(',', @alleles);\n            $allelef{$alleles[0]}++;\n            $allelef{$alleles[1]}++;\n\t}\n\n\t# we should check for cases where there > 2 alleles or\n\t# only 1 allele and throw out those markers.\n\tmy @alleles      = sort keys %allelef;\n\tmy $allele_count = scalar @alleles;\n\t# test if site is polymorphic\n\tif( $allele_count != 2) { \n\t    # only really warn if we're seeing multi-allele\n\t    $self->warn(\"Skipping $marker_name because it has $allele_count alleles (\".join(',',@alleles).\"), \\ncomposite_LD will currently only work for biallelic markers\") if $allele_count > 2;\n\t    next;\t\t# skip this marker\n\t}\n\n\t# Need to do something here to detect alleles which aren't \n\t# a single character\n\tif( length($alleles[0]) != 1 ||\n\t    length($alleles[1]) != 1 ) {\n\t    $self->warn(\"An individual has an allele which is not a single base, this is currently not supported in composite_LD - consider recoding the allele as a single character\");\n\t    next;\n\t}\n\n\t# fix the call for allele 1 (A or B) and \n\t# allele 2 (a or b) in terms of how we'll do the \n\t# N square from Weir p.126\n\t$self->debug( \"$alleles[0] is 1, $alleles[1] is 2 for $marker_name\\n\");\n\t$lookup{$marker_name}->{'1'} = $alleles[0];\n\t$lookup{$marker_name}->{'2'} = $alleles[1];\n    }\n\n    @marker_names = sort keys %lookup;\n    my $site_count   = scalar @marker_names;\n    # where the final data will be stored\n    my %stats_for_sites;\n\n    # standard way of generating pairwise combos\n    # LD is done by comparing all the pairwise site (marker)\n    # combinations and keeping track of the genotype and \n    # pairwise genotype (ie genotypes of the 2 sites) frequencies\n    for( my $i = 0; $i < $site_count - 1; $i++ ) {\n\tmy $site1 = $marker_names[$i];\n\n\tfor( my $j = $i+1; $j < $site_count ; $j++) { \t \n\t    my (%genotypes, %total_genotype_count,$total_pairwisegeno_count,\n\t\t%pairwise_genotypes);\n\t \n\t    my $site2 = $marker_names[$j];\n\t    my (%allele_count,%allele_freqs) = (0,0);\n\t    foreach my $ind ( @inds ) {\n\t\t# build string of genotype at site 1\n\t\tmy ($genotype1) = $ind->get_Genotypes(-marker => $site1);\n\t\tmy @alleles1  = sort $genotype1->get_Alleles;\n\n                # if an individual has only one available allele\n\t\t# (has a blank or N for one of the chromosomes)\n\t\t# we don't want to use it in our calculation\n\n\t\tnext unless( scalar @alleles1 == 2);\n\t\tmy $genostr1  = join(',', @alleles1);\n\n\t\t# build string of genotype at site 2\n\t\tmy ($genotype2) = $ind->get_Genotypes(-marker => $site2);\n\t\tmy @alleles2  = sort $genotype2->get_Alleles;\n\t\tmy $genostr2  = join(',', @alleles2);\n\t\t\n\t\tnext unless( scalar @alleles2 == 2);\n\t\tfor (@alleles1) {\n\t\t    $allele_count{$site1}++;\n\t\t    $allele_freqs{$site1}->{$_}++;\n\t\t}\n\t\t$genotypes{$site1}->{$genostr1}++;\n\t\t$total_genotype_count{$site1}++;\n\n\t\tfor (@alleles2) {\n\t\t    $allele_count{$site2}++;\n\t\t    $allele_freqs{$site2}->{$_}++;\n\t\t}\n\t\t$genotypes{$site2}->{$genostr2}++;\n\t\t$total_genotype_count{$site2}++;\n\n\t\t# We are using the $site1,$site2 to signify\n\t\t# a unique key\n\t\t$pairwise_genotypes{\"$genostr1,$genostr2\"}++;\n\t\t# some individuals \n\t\t$total_pairwisegeno_count++;\n\t    }\n\t    for my $site ( %allele_freqs ) {\n\t\tfor my $al ( keys %{ $allele_freqs{$site} } ) {\n\t\t    $allele_freqs{$site}->{$al} /= $allele_count{$site};\n\t\t}\n\t    }\n\t    my $n = $total_pairwisegeno_count;\t# number of pairs of comparisons\n\t    # 'A' and 'B' are two loci or in our case site1 and site2  \n\t    my $allele1_site1 = $lookup{$site1}->{'1'};\t# this is the BigA allele\n\t    my $allele1_site2 = $lookup{$site2}->{'1'};\t# this is the BigB allele\n\t    my $allele2_site1 = $lookup{$site1}->{'2'};\t# this is the LittleA allele\n\t    my $allele2_site2 = $lookup{$site2}->{'2'};\t# this is the LittleB allele\n\t    # AABB\n\t    my $N1genostr = join(\",\",( $allele1_site1, $allele1_site1,\n\t\t\t\t       $allele1_site2, $allele1_site2));\n\t    $self->debug(\" [$site1,$site2](AABB) N1genostr=$N1genostr\\n\");\n\t    # AABb\n\t    my $N2genostr = join(\",\",( $allele1_site1, $allele1_site1,\n\t\t\t\t       $allele1_site2, $allele2_site2));\n\t    $self->debug(\" [$site1,$site2](AABb) N2genostr=$N2genostr\\n\");\n\t    # AaBB\n\t    my $N4genostr = join(\",\",( $allele1_site1, $allele2_site1,\n\t\t\t\t       $allele1_site2, $allele1_site2));\n\t    $self->debug(\" [$site1,$site2](AaBB) N4genostr=$N4genostr\\n\");\n\t    # AaBb\n\t    my $N5genostr = join(\",\",( $allele1_site1, $allele2_site1,\n\t\t\t\t       $allele1_site2, $allele2_site2));\n\t    $self->debug(\" [$site1,$site2](AaBb) N5genostr=$N5genostr\\n\");\n\t    # count of AABB in \n\t    my $n1 = $pairwise_genotypes{$N1genostr} || 0;\n\t    # count of AABb in \n\t    my $n2 = $pairwise_genotypes{$N2genostr} || 0;\n\t    # count of AaBB in \n\t    my $n4 = $pairwise_genotypes{$N4genostr} || 0;\n\t    # count of AaBb in \n\t    my $n5 = $pairwise_genotypes{$N5genostr} || 0;\n\n\t    my $homozA_site1 = join(\",\", ($allele1_site1,$allele1_site1));\n\t    my $homozB_site2 = join(\",\", ($allele1_site2,$allele1_site2));\n\t    my $p_AA = ($genotypes{$site1}->{$homozA_site1} || 0) / $n;\n\t    my $p_BB = ($genotypes{$site2}->{$homozB_site2} || 0) / $n;\n\t    my $p_A  = $allele_freqs{$site1}->{$allele1_site1} || 0;\t# an individual allele freq\n\t    my $p_a  =  1 - $p_A;\n\n\t    my $p_B  = $allele_freqs{$site2}->{$allele1_site2} || 0;\t# an individual allele freq\n\t    my $p_b  =  1 - $p_B;\n\n\t    # variance of allele frequencies\n\t    my $pi_A = $p_A * $p_a;\n\t    my $pi_B = $p_B * $p_b;\n\n\t    # hardy weinberg\n\t    my $D_A  = $p_AA - $p_A**2;\n\t    my $D_B  = $p_BB - $p_B**2;\n\t    my $n_AB = 2*$n1 + $n2 + $n4 + 0.5 * $n5;\n\t    $self->debug(\"n_AB=$n_AB -- n1=$n1, n2=$n2 n4=$n4 n5=$n5\\n\");\n\n\t    my $delta_AB = (1 / $n ) * ( $n_AB ) - ( 2 * $p_A * $p_B );\n\t    $self->debug(\"delta_AB=$delta_AB -- n=$n, n_AB=$n_AB p_A=$p_A, p_B=$p_B\\n\");\n\t    $self->debug(sprintf(\" (%d * %.4f) / ( %.2f + %.2f) * ( %.2f + %.2f) \\n\",\n\t\t\t\t $n,$delta_AB**2, $pi_A, $D_A, $pi_B, $D_B));\n\t    \n\t    my $chisquared;\n\t    eval { $chisquared = ( $n * ($delta_AB**2) ) / \n\t\t       ( ( $pi_A + $D_A) * ( $pi_B + $D_B) );\n\t       };\n\t    if( $@ ) {\n\t\t$self->debug(\"Skipping the site because the denom is 0.\\nsite1=$site1, site2=$site2 : pi_A=$pi_A, pi_B=$pi_B D_A=$D_A, D_B=$D_B\\n\");\n\t\tnext;\n\t    }\n\t    # this will be an upper triangular matrix\n\t    $stats_for_sites{$site1}->{$site2} = [$delta_AB,$chisquared];\n\t}\n    }\n    return %stats_for_sites;\n}\n\n=head2 mcdonald_kreitman\n\n Title   : mcdonald_kreitman\n Usage   : $Fstat = mcdonald_kreitman($ingroup, $outgroup);\n Function: Calculates McDonald-Kreitman statistic based on a set of ingroup\n           individuals and an outgroup by computing the number of \n           differences at synonymous and non-synonymous sites\n           for intraspecific comparisons and with the outgroup \n Returns : 2x2 table, followed by a hash reference indicating any \n           warning messages about the status of the alleles or codons \n Args    : -ingroup    => L<Bio::PopGen::Population> object or \n                          arrayref of L<Bio::PopGen::Individual>s \n           -outgroup   => L<Bio::PopGen::Population> object or \n                          arrayef of L<Bio::PopGen::Individual>s\n           -polarized  => Boolean, to indicate if this should be \n                          a polarized test. Must provide two individuals \n                          as outgroups.\n\n\nsub mcdonald_kreitman {\n    my ($self,@args) = @_;\n    my ($ingroup, $outgroup,$polarized) = \n\t$self->_rearrange([qw(INGROUP OUTGROUP POLARIZED)],@args);\n    my $verbose = $self->verbose;\n    my $outgroup_count;\n    my $gapchar = '\\-';\n    if( ref($outgroup) =~ /ARRAY/i ) {\n\t$outgroup_count = scalar @$outgroup;\n    } elsif( UNIVERSAL::isa($outgroup,'Bio::PopGen::PopulationI') ) {\n\t$outgroup_count = $outgroup->get_number_individuals;\n    } else {\n\t$self->throw(\"Expected an ArrayRef of Individuals OR a Bio::PopGen::PopulationI\");\n    }\n\t\n    if( $polarized ) {\n\tif( $outgroup_count < 2 ) {\n\t    $self->throw(\"Need 2 outgroups with polarized option\\n\");\n\t}\n    } elsif( $outgroup_count > 1 ) {\n\t$self->warn(sprintf(\"%s outgroup sequences provided, but only first will be used\",$outgroup_count ));\n    } elsif( $outgroup_count == 0 ) {\n\t$self->throw(\"No outgroup sequence provided\");\n    }\n    \n    my $codon_path = Bio::MolEvol::CodonModel->codon_path;\n    \n    my (%marker_names,%unique,@inds);\n    for my $p ( $ingroup, $outgroup)  {\n\tif( ref($p) =~ /ARRAY/i ) {\n\t    push @inds, @$p;\n\t} else {\n\t    push @inds, $p->get_Individuals;\n\t}\n    }\n    for my $i ( @inds ) {\n\tif( $unique{$i->unique_id}++ ) {\n\t    $self->warn(\"Individual \". $i->unique_id. \" is seen more than once in the ingroup or outgroup set\\n\");\n\t}\n\tfor my $n ( $i->get_marker_names ) {\n\t    $marker_names{$n}++;\n\t}\n    }\n\n    my @marker_names = keys %marker_names;\n    if( $marker_names[0] =~ /^(Site|Codon)/ ) {\n\t# sort by site or codon number and do it in \n\t# a schwartzian transformation baby!\n\t@marker_names = map { $_->[1] } \n\tsort { $a->[0] <=> $b->[0] }\n\tmap { [$_ =~ /^(?:Codon|Site)-(\\d+)/, $_] } @marker_names;\n    }\n\n\n    my $num_inds = scalar @inds;\n    my %vals = ( 'ingroup'  => $ingroup,\n\t\t 'outgroup' => $outgroup,\t\t \n\t\t );\n\n    # Make the Codon Table type a parameter!\n    my $table = Bio::Tools::CodonTable->new(-id => $codon_table);\n    my @vt = qw(outgroup ingroup);\n    my %changes;\n    my %status;\n    my %two_by_two = ( 'fixed_N' => 0,\n\t\t       'fixed_S' => 0,\n\t\t       'poly_N'  => 0,\n\t\t       'poly_S'  => 0);\n\n    for my $codon ( @marker_names ) {\n\tmy (%codonvals);\n\tmy %all_alleles;\n\tfor my $t ( @vt ) {\n\t    my $outcount = 1;\n\t    for my $ind ( @{$vals{$t}} ) {\n\t\tmy @alleles = $ind->get_Genotypes($codon)->get_Alleles;\n\t\tif( @alleles > 1 ) {\n\t\t    die;\n#\t\t  warn(\"$codon $codon saw \", scalar @alleles, \" for ind \", $ind->unique_id, \"\\n\");\n\t\t} else {\n\t\t    my ($allele) = shift @alleles;\n\t\t    $all_alleles{$ind->unique_id} = $allele;\n\t\t    my $AA = $table->translate($allele);\n\t\t    next if( $AA eq 'X' || $AA eq '*' || $allele =~ /N/i);\n\n\t\t    my $label = $t;\n\t\t    if( $t eq 'outgroup' ) {\n\t\t\t$label = $t.$outcount++;\n\t\t    }\n\t\t    $codonvals{$label}->{$allele}++;\n\t\t    $codonvals{all}->{$allele}++;\n\t\t}\n\t    }\n\t}\n\tmy $total = sum ( values %{$codonvals{'ingroup'}} );\n\tnext if( $total && $total < 2 ); # skip sites with < alleles\n\t# process all the seen alleles (codons) \n\t# this is a vertical slide through the alignment\n\tif( keys %{$codonvals{all}} <= 1 ) {\n\t    # no changes or no VALID codons - monomorphic\n\t} else { \n\t    # grab only the first outgroup codon (what to do with rest?)\n\t    my ($outcodon) = keys %{$codonvals{'outgroup1'}};\n            if( ! $outcodon ) { \n\t\t$status{\"no outgroup codon $codon\"}++;\n\t\tnext;\n\t    }\n\t    my $out_AA = $table->translate($outcodon);\n\t    my ($outcodon2) = keys %{$codonvals{'outgroup2'}};\n\t    if( ($polarized && ($outcodon ne $outcodon2)) ||\n\t\t$out_AA eq 'X' || $out_AA eq '*' ) {\n\t\t# skip if outgroup codons are different \n\t\t# (when polarized option is on)\n\t\t# or skip if the outcodon is STOP or 'NNN'\n\t\tif( $verbose > 0 ) {\n\t\t    $self->debug(\"skipping $out_AA and $outcodon $outcodon2\\n\");\n\t\t}\n\t\t$status{'outgroup codons different'}++;\n\t\tnext;\n\t    }\n\n\t    # check if ingroup is actually different from outgroup -\n\t    # if there are the same number of alleles when considering\n\t    # ALL or just the ingroup, then there is nothing new seen\n\t    # in the outgroup so it must be a shared allele (codon)\n\n\t    # so we just count how many total alleles were seen\n\t    # if this is the same as the number of alleles seen for just \n\t    # the ingroup then the outgroup presents no new information\n\n\t    my @ingroup_codons = keys %{$codonvals{'ingroup'}};\n\t    my $diff_from_out = ! exists $codonvals{'ingroup'}->{$outcodon};\n\n\t    if( $verbose > 0 ) {\n\t\t$self->debug(\"alleles are in: \", join(\",\", @ingroup_codons),\n\t\t\t     \" out: \", join(\",\", keys %{$codonvals{outgroup1}}),\n\t\t\t     \" diff_from_out=$diff_from_out\\n\");\n\n\t\tfor my $ind ( sort keys %all_alleles ) {\n\t\t    $self->debug( \"$ind\\t$all_alleles{$ind}\\n\");\n\t\t}\n\t    }\n\t    # are all the ingroup alleles the same and diferent from outgroup?\n\t    # fixed differences between species\n\t    if( $diff_from_out ) {\n\t\tif( scalar @ingroup_codons == 1 ) { \n\t\t    # fixed differences\n\t\t    if( $outcodon =~ /^$gapchar/ ) {\n\t\t\t$status{'outgroup codons with gaps'}++;\n\t\t\tnext;\n\t\t    } elsif( $ingroup_codons[0] =~ /$gapchar/) {\n\t\t\t$status{'ingroup codons with gaps'}++;\n\t\t\tnext;\n\t\t    }\n\t\t    my $path = $codon_path->{uc $ingroup_codons[0].$outcodon};\n\t\t    $two_by_two{fixed_N} += $path->[0];\n\t\t    $two_by_two{fixed_S} += $path->[1];\n\t\t    if( $verbose > 0 ) {\n\t\t\t$self->debug(\"ingroup is @ingroup_codons outcodon is $outcodon\\n\");\n\t\t\t$self->debug(\"path is \",join(\",\",@$path),\"\\n\");\n\t\t\t$self->debug\n\t\t\t    (sprintf(\"%-15s fixeddiff - %s;%s(%s) %d,%d\\tNfix=%d Sfix=%d Npoly=%d Spoly=%s\\n\",$codon,$ingroup_codons[0], $outcodon,$out_AA,\n\t\t\t\t     @$path, map { $two_by_two{$_} } \n\t\t\t\t     qw(fixed_N fixed_S poly_N poly_S)));\n\t\t    }\n\t\t} else { \n\t\t    # polymorphic and all are different from outgroup\n\t\t    # Here we find the minimum number of NS subst\n\t\t    my ($Ndiff,$Sdiff) = (3,0);\t# most different path\n\t\t    for my $c ( @ingroup_codons ) {\n\t\t\tnext if( $c =~ /$gapchar/ || $outcodon =~ /$gapchar/);\n\t\t\tmy $path = $codon_path->{uc $c.$outcodon};\n\t\t\tmy ($tNdiff,$tSdiff) = @$path;\n\t\t\tif( $path->[0] < $Ndiff ||\n\t\t\t    ($tNdiff == $Ndiff &&\n\t\t\t     $tSdiff  <= $Sdiff)) {\n\t\t\t    ($Ndiff,$Sdiff) = ($tNdiff,$tSdiff);\n\t\t\t}\n\t\t    }\n\t\t    $two_by_two{fixed_N} += $Ndiff;\n\t\t    $two_by_two{fixed_S} += $Sdiff;\n\t            if( @ingroup_codons > 2 ) { \n\t\t\t$status{\"more than 2 ingroup codons $codon\"}++;\n\t\t\twarn(\"more than 2 ingroup codons (@ingroup_codons)\\n\");\t\n\t\t    } else {\n\t\t    \tmy $path = $codon_path->{uc join('',@ingroup_codons)};\n\n\t\t    \t$two_by_two{poly_N} += $path->[0];\n\t\t    \t$two_by_two{poly_S} += $path->[1];\n\t\t    \tif( $verbose > 0 ) {\n\t\t\t    $self->debug(sprintf(\"%-15s polysite_all - %s;%s(%s) %d,%d\\tNfix=%d Sfix=%d Npoly=%d Spoly=%s\\n\",$codon,join(',',@ingroup_codons), $outcodon,$out_AA,@$path, map { $two_by_two{$_} } qw(fixed_N fixed_S poly_N poly_S)));\n\t\t\t}\n\t\t    } \n\t\t} \n\t    } else {\n\t\tmy %unq = map { $_ => 1 } @ingroup_codons;\n\t\tdelete $unq{$outcodon};\n\t\tmy @unique_codons = keys %unq;\n\n\t\t# calc path for diff add to poly\n\t\t# Here we find the minimum number of subst bw\n\t\t# codons\n\t\tmy ($Ndiff,$Sdiff) = (3,0); # most different path\n\t\tfor my $c ( @unique_codons ) {\n\t\t    my $path = $codon_path->{uc $c.$outcodon };\n\t\t    if( ! defined $path ) {\n\t\t\tdie \" cannot get path for \", $c.$outcodon, \"\\n\";\n\t\t    }\n\t\t    my ($tNdiff,$tSdiff) = @$path;\n\t\t    if( $path->[0] < $Ndiff ||\n\t\t\t($tNdiff == $Ndiff &&\n\t\t\t $tSdiff  <= $Sdiff)) {\n\t\t\t($Ndiff,$Sdiff) = ($tNdiff,$tSdiff);\n\t\t    }\n\t\t}\n\n\t\tif( @unique_codons == 2 ) {\n\t\t    my $path = $codon_path->{uc join('',@unique_codons)};\n\t\t    if( ! defined $path ) {\n\t\t\t$self->throw(\"no path for @unique_codons\\n\");\n\t\t    }\n\t\t    $Ndiff += $path->[0];\n\t\t    $Sdiff += $path->[1];\n\t\t}\n\t\t$two_by_two{poly_N} += $Ndiff;\n\t\t$two_by_two{poly_S} += $Sdiff;\n\t\tif( $verbose > 0 ) {\n\t\t    $self->debug(sprintf(\"%-15s polysite - %s;%s(%s) %d,%d\\tNfix=%d Sfix=%d Npoly=%d Spoly=%s\\n\",$codon,join(',',@ingroup_codons), $outcodon,$out_AA,\n\t\t\t\t\t $Ndiff, $Sdiff, map { $two_by_two{$_} } \n\t\t\t\t\t qw(fixed_N fixed_S poly_N poly_S)));\n\t\t}\n\t    }\n\t}\t    \n    }\n    return ( $two_by_two{'poly_N'},\n\t     $two_by_two{'fixed_N'},\n\t     $two_by_two{'poly_S'},\n\t     $two_by_two{'fixed_S'},\n\t     {%status});\n    \n}\n\n*MK = \\&mcdonald_kreitman;\n\n\n=head2 mcdonald_kreitman_counts\n\n Title   : mcdonald_kreitman_counts\n Usage   : my $MK = $statistics->mcdonald_kreitman_counts(\n\n             N_poly -> integer of count of non-syn polymorphism\n             N_fix  -> integer of count of non-syn fixed substitutions\n             S_poly -> integer of count of syn polymorphism\n             S_fix  -> integer of count of syn fixed substitutions\n\t\t\t\t\t\t\t  );\n Function:\n Returns : decimal number\n Args    : ","label":"mcdonald_kreitman_counts($self,$Npoly,$Nfix,$Spoly,$Sfix)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":1590},"start":{"character":0,"line":1578}},"name":"mcdonald_kreitman_counts"},{"name":"Text","containerName":"NSP::Measures::Fisher2::twotailed::calculateStatistic","line":1582,"kind":12},{"name":"n11","line":1582,"kind":12},{"name":"n1p","line":1583,"kind":12},{"kind":12,"line":1584,"name":"np1"},{"name":"npp","line":1585,"kind":12}],"version":5}