{"vars":[{"containerName":"","name":"vars","kind":2,"line":100},{"kind":13,"line":103,"containerName":null,"name":"$PRECISION_DIGITS"},{"line":103,"kind":2,"containerName":"","name":"strict"},{"line":109,"kind":2,"containerName":"","name":"base"},{"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Coalescent.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::Coalescent\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::Coalescent - A Coalescent simulation factory\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::Simulation::Coalescent;\n    my @taxonnames = qw(SpeciesA SpeciesB SpeciesC SpeciesD);\n    my $sim1 = Bio::PopGen::Simulation::Coalescent->new(-samples => \\@taxonnames);\n\n    my $tree = $sim1->next_tree;\n\n    # add 20 mutations randomly to the tree\n    $sim1->add_Mutations($tree,20);\n\n    # or for anonymous samples\n\n    my $sim2 = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 6,\n\t\t\t\t\t\t\t -maxcount => 50);\n    my $tree2 = $sim2->next_tree;\n    # add 20 mutations randomly to the tree\n    $sim2->add_Mutations($tree2,20);\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount\ntimes with branch lengths and provides the ability to randomly add\nmutations onto the tree with a probabilty proportional to the branch\nlengths.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York.\n\nThis module was previously named Bio::Tree::RandomTree\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::Coalescent;\nuse vars qw($PRECISION_DIGITS);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n\nuse Bio::Tree::AlleleNode;\nuse Bio::PopGen::Genotype;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::Coalescent->new();\n Function: Builds a new Bio::PopGen::Simulation::Coalescent object \n Returns : an instance of Bio::PopGen::Simulation::Coalescent\n Args    : -samples => arrayref of sample names\n           OR\n           -sample_size=> number of samples (samps will get a systematic name)\n           -maxcount   => [optional] maximum number of trees to provide"},"detail":"($class,@args)","kind":12,"children":[{"kind":13,"line":126,"containerName":"new","name":"$class","definition":"my","localvar":"my"},{"containerName":"new","name":"@args","kind":13,"line":126},{"kind":13,"line":127,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"containerName":"new","name":"$class","kind":13,"line":127},{"line":127,"kind":13,"containerName":"new","name":"@args"},{"line":129,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"$self","line":130,"kind":13},{"containerName":"new","name":"$maxcount","definition":"my","localvar":"my","kind":13,"line":131},{"name":"$samps","containerName":"new","kind":13,"line":131},{"name":"$samplesize","containerName":"new","line":131,"kind":13},{"name":"$self","containerName":"new","line":131,"kind":13},{"name":"_rearrange","containerName":"new","line":131,"kind":12},{"name":"@args","containerName":"new","kind":13,"line":134},{"kind":13,"line":135,"name":"@samples","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$samps","line":137,"kind":13},{"kind":13,"line":138,"containerName":"new","name":"$samplesize"},{"name":"$samplesize","containerName":"new","kind":13,"line":138},{"containerName":"new","name":"$self","line":139,"kind":13},{"containerName":"new","name":"throw","kind":12,"line":139},{"kind":13,"line":141,"name":"$samplesize","containerName":"new"},{"name":"@samples","containerName":"new","line":141,"kind":13},{"kind":13,"line":143,"name":"$samps","containerName":"new"},{"name":"$self","containerName":"new","line":144,"kind":13},{"line":144,"kind":12,"containerName":"new","name":"throw"},{"line":146,"kind":13,"containerName":"new","name":"@samples"},{"containerName":"new","name":"$samps","kind":13,"line":146},{"containerName":"new","name":"$self","line":149,"kind":13},{"line":149,"kind":12,"containerName":"new","name":"samples"},{"containerName":"new","name":"@samples","line":149,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":150},{"name":"sample_size","containerName":"new","kind":12,"line":150},{"containerName":"new","name":"@samples","kind":13,"line":150},{"line":151,"kind":13,"name":"$maxcount","containerName":"new"},{"line":151,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":151,"name":"maxcount","containerName":"new"},{"name":"$maxcount","containerName":"new","line":151,"kind":13},{"line":152,"kind":13,"name":"$self","containerName":"new"}],"line":125,"name":"new","range":{"start":{"character":0,"line":125},"end":{"character":9999,"line":153}}},{"line":127,"kind":12,"name":"SUPER","containerName":"new"},{"line":168,"children":[{"line":169,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"next_tree"},{"containerName":"next_tree","name":"$self","kind":13,"line":173},{"name":"maxcount","containerName":"next_tree","line":173,"kind":12},{"line":174,"kind":13,"containerName":"next_tree","name":"$self"},{"name":"$self","containerName":"next_tree","kind":13,"line":174},{"name":"maxcount","containerName":"next_tree","kind":12,"line":174},{"localvar":"my","containerName":"next_tree","definition":"my","name":"$size","line":175,"kind":13},{"kind":13,"line":175,"containerName":"next_tree","name":"$self"},{"containerName":"next_tree","name":"sample_size","kind":12,"line":175},{"line":177,"kind":13,"localvar":"my","containerName":"next_tree","definition":"my","name":"$in"},{"localvar":"my","name":"@tree","definition":"my","containerName":"next_tree","line":178,"kind":13},{"line":179,"kind":13,"localvar":"my","containerName":"next_tree","definition":"my","name":"@list"},{"name":"$in","containerName":"next_tree","line":181,"kind":13},{"containerName":"next_tree","name":"$in","line":181,"kind":13},{"kind":13,"line":181,"name":"$size","containerName":"next_tree"},{"name":"$in","containerName":"next_tree","line":181,"kind":13},{"kind":13,"line":182,"containerName":"next_tree","name":"@tree"},{"containerName":"next_tree","name":"$in","line":192,"kind":13},{"kind":13,"line":192,"containerName":"next_tree","name":"$in"},{"containerName":"next_tree","name":"$size","line":192,"kind":13},{"name":"$in","containerName":"next_tree","kind":13,"line":192},{"kind":13,"line":193,"name":"$tree","containerName":"next_tree"},{"kind":13,"line":193,"containerName":"next_tree","name":"$in"},{"kind":13,"line":194,"containerName":"next_tree","name":"$tree"},{"line":194,"kind":13,"name":"$in","containerName":"next_tree"},{"containerName":"next_tree","name":"$tree","kind":13,"line":195},{"containerName":"next_tree","name":"$in","kind":13,"line":195},{"containerName":"next_tree","name":"@list","kind":13,"line":196},{"name":"$in","containerName":"next_tree","line":196,"kind":13},{"localvar":"my","definition":"my","name":"$t","containerName":"next_tree","line":199,"kind":13},{"containerName":"next_tree","name":"$in","kind":13,"line":201},{"line":201,"kind":13,"name":"$size","containerName":"next_tree"},{"kind":13,"line":201,"name":"$in","containerName":"next_tree"},{"containerName":"next_tree","name":"$in","kind":13,"line":201},{"line":202,"kind":13,"name":"$t","containerName":"next_tree"},{"containerName":"next_tree","name":"$self","line":202,"kind":13},{"containerName":"next_tree","name":"random","line":202,"kind":12},{"line":202,"kind":13,"containerName":"next_tree","name":"$in"},{"kind":13,"line":202,"containerName":"next_tree","name":"$in"},{"name":"$tree","containerName":"next_tree","kind":13,"line":203},{"name":"$size","containerName":"next_tree","kind":13,"line":203},{"line":203,"kind":13,"containerName":"next_tree","name":"$in"},{"containerName":"next_tree","name":"$t","kind":13,"line":203},{"containerName":"next_tree","name":"$in","kind":13,"line":206},{"line":206,"kind":13,"containerName":"next_tree","name":"$size"},{"containerName":"next_tree","name":"$in","kind":13,"line":206},{"name":"$in","containerName":"next_tree","line":206,"kind":13},{"localvar":"my","definition":"my","name":"$pick","containerName":"next_tree","line":207,"kind":13},{"containerName":"next_tree","name":"$self","kind":13,"line":207},{"kind":12,"line":207,"containerName":"next_tree","name":"random"},{"line":207,"kind":13,"containerName":"next_tree","name":"$in"},{"containerName":"next_tree","definition":"my","name":"$nodeindex","localvar":"my","kind":13,"line":208},{"kind":13,"line":208,"name":"$list","containerName":"next_tree"},{"line":208,"kind":13,"name":"$pick","containerName":"next_tree"},{"kind":13,"line":209,"containerName":"next_tree","name":"$swap","definition":"my","localvar":"my"},{"containerName":"next_tree","name":"$size","kind":13,"line":209},{"line":209,"kind":13,"name":"$in","containerName":"next_tree"},{"name":"$tree","containerName":"next_tree","kind":13,"line":210},{"kind":13,"line":210,"name":"$swap","containerName":"next_tree"},{"kind":13,"line":210,"containerName":"next_tree","name":"$nodeindex"},{"containerName":"next_tree","name":"$list","line":211,"kind":13},{"containerName":"next_tree","name":"$pick","kind":13,"line":211},{"kind":13,"line":211,"name":"$list","containerName":"next_tree"},{"name":"$in","containerName":"next_tree","line":211,"kind":13},{"line":212,"kind":13,"name":"$pick","containerName":"next_tree"},{"containerName":"next_tree","name":"$in","kind":13,"line":212},{"kind":13,"line":213,"containerName":"next_tree","name":"$nodeindex"},{"name":"$list","containerName":"next_tree","line":213,"kind":13},{"containerName":"next_tree","name":"$pick","kind":13,"line":213},{"name":"$tree","containerName":"next_tree","kind":13,"line":214},{"containerName":"next_tree","name":"$swap","line":214,"kind":13},{"containerName":"next_tree","name":"$nodeindex","line":214,"kind":13},{"line":215,"kind":13,"name":"$list","containerName":"next_tree"},{"containerName":"next_tree","name":"$pick","line":215,"kind":13},{"line":215,"kind":13,"name":"$swap","containerName":"next_tree"},{"containerName":"next_tree","name":"@nodes","definition":"my","localvar":"my","kind":13,"line":219},{"localvar":"my","containerName":"next_tree","definition":"my","name":"$n","line":220,"kind":13},{"name":"@tree","containerName":"next_tree","line":220,"kind":13},{"containerName":"next_tree","name":"@nodes","line":221,"kind":13},{"kind":12,"line":222,"containerName":"next_tree","name":"new"},{"containerName":"next_tree","name":"$n","line":222,"kind":13},{"containerName":"next_tree","name":"$n","line":223,"kind":13},{"line":225,"kind":13,"localvar":"my","containerName":"next_tree","name":"$ct","definition":"my"},{"name":"$node","definition":"my","containerName":"next_tree","localvar":"my","kind":13,"line":226},{"name":"@nodes","containerName":"next_tree","line":226,"kind":13},{"localvar":"my","name":"$n","definition":"my","containerName":"next_tree","line":227,"kind":13},{"kind":13,"line":227,"containerName":"next_tree","name":"$tree"},{"line":227,"kind":13,"containerName":"next_tree","name":"$ct"},{"containerName":"next_tree","name":"$n","kind":13,"line":228},{"containerName":"next_tree","name":"$node","kind":13,"line":229},{"kind":12,"line":229,"name":"add_Descendent","containerName":"next_tree"},{"kind":13,"line":229,"containerName":"next_tree","name":"$nodes"},{"kind":13,"line":229,"containerName":"next_tree","name":"$n"},{"name":"$n","containerName":"next_tree","line":231,"kind":13},{"name":"$node","containerName":"next_tree","kind":13,"line":232},{"name":"add_Descendent","containerName":"next_tree","kind":12,"line":232},{"kind":13,"line":232,"name":"$nodes","containerName":"next_tree"},{"name":"$n","containerName":"next_tree","line":232,"kind":13},{"line":235,"kind":13,"localvar":"my","definition":"my","name":"$T","containerName":"next_tree"},{"containerName":"next_tree","name":"new","kind":12,"line":235},{"name":"@nodes","containerName":"next_tree","kind":13,"line":235},{"line":236,"kind":13,"containerName":"next_tree","name":"$T"}],"kind":12,"detail":"($self)","signature":{"label":"next_tree($self)","documentation":"1;\n# $Id: Coalescent.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::Coalescent\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::Coalescent - A Coalescent simulation factory\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::Simulation::Coalescent;\n    my @taxonnames = qw(SpeciesA SpeciesB SpeciesC SpeciesD);\n    my $sim1 = Bio::PopGen::Simulation::Coalescent->new(-samples => \\@taxonnames);\n\n    my $tree = $sim1->next_tree;\n\n    # add 20 mutations randomly to the tree\n    $sim1->add_Mutations($tree,20);\n\n    # or for anonymous samples\n\n    my $sim2 = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 6,\n\t\t\t\t\t\t\t -maxcount => 50);\n    my $tree2 = $sim2->next_tree;\n    # add 20 mutations randomly to the tree\n    $sim2->add_Mutations($tree2,20);\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount\ntimes with branch lengths and provides the ability to randomly add\nmutations onto the tree with a probabilty proportional to the branch\nlengths.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York.\n\nThis module was previously named Bio::Tree::RandomTree\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::Coalescent;\nuse vars qw($PRECISION_DIGITS);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n\nuse Bio::Tree::AlleleNode;\nuse Bio::PopGen::Genotype;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::Coalescent->new();\n Function: Builds a new Bio::PopGen::Simulation::Coalescent object \n Returns : an instance of Bio::PopGen::Simulation::Coalescent\n Args    : -samples => arrayref of sample names\n           OR\n           -sample_size=> number of samples (samps will get a systematic name)\n           -maxcount   => [optional] maximum number of trees to provide\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($maxcount, $samps,$samplesize ) = $self->_rearrange([qw(MAXCOUNT\n\t\t\t\t\t\t\t       SAMPLES\n\t\t\t\t\t\t\t       SAMPLE_SIZE)],\n\t\t\t\t\t\t\t   @args);\n   my @samples;\n   \n   if( ! defined $samps ) { \n       if( ! defined $samplesize || $samplesize <= 0 ) { \n\t   $self->throw(\"Must specify a valid samplesize if parameter -SAMPLE is not specified (sampsize is $samplesize)\");\n       }\n       foreach ( 1..$samplesize ) { push @samples, \"Samp$_\"; }      \n   } else { \n       if( ref($samps) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -SAMPLES, did you forget a leading '\\\\'?\");\n       }\n       @samples = @$samps;\n   }\n   \n   $self->samples(\\@samples);\n   $self->sample_size(scalar @samples);\n   defined $maxcount && $self->maxcount($maxcount);   \n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n Returns : Bio::Tree::TreeI object\n Args    : none","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","range":{"start":{"line":168,"character":0},"end":{"character":9999,"line":237}},"name":"next_tree"},{"name":"Bio","containerName":"Tree::AlleleNode","line":222,"kind":12},{"line":235,"kind":12,"name":"Bio","containerName":"Tree::Tree"},{"name":"add_Mutations","range":{"start":{"line":254,"character":0},"end":{"character":9999,"line":324}},"kind":12,"children":[{"containerName":"add_Mutations","definition":"my","name":"$self","localvar":"my","kind":13,"line":255},{"name":"$tree","containerName":"add_Mutations","line":255,"kind":13},{"containerName":"add_Mutations","name":"$nummut","line":255,"kind":13},{"line":255,"kind":13,"name":"$precision","containerName":"add_Mutations"},{"containerName":"add_Mutations","name":"$precision","line":256,"kind":13},{"line":256,"kind":13,"name":"$PRECISION_DIGITS","containerName":"add_Mutations"},{"containerName":"add_Mutations","name":"$precision","kind":13,"line":257},{"containerName":"add_Mutations","name":"$precision","line":257,"kind":13},{"kind":13,"line":259,"name":"@branches","definition":"my","containerName":"add_Mutations","localvar":"my"},{"containerName":"add_Mutations","name":"@lens","definition":"my","localvar":"my","kind":13,"line":260},{"localvar":"my","name":"$branchlen","definition":"my","containerName":"add_Mutations","line":261,"kind":13},{"line":262,"kind":13,"localvar":"my","name":"$last","definition":"my","containerName":"add_Mutations"},{"kind":13,"line":263,"definition":"my","name":"@nodes","containerName":"add_Mutations","localvar":"my"},{"containerName":"add_Mutations","name":"$tree","line":263,"kind":13},{"name":"get_nodes","containerName":"add_Mutations","line":263,"kind":12},{"line":264,"kind":13,"localvar":"my","containerName":"add_Mutations","name":"$i","definition":"my"},{"kind":13,"line":273,"definition":"my","name":"$node","containerName":"add_Mutations","localvar":"my"},{"name":"@nodes","containerName":"add_Mutations","line":273,"kind":13},{"line":274,"kind":13,"name":"$node","containerName":"add_Mutations"},{"line":274,"kind":12,"containerName":"add_Mutations","name":"ancestor"},{"containerName":"add_Mutations","name":"$len","definition":"my","localvar":"my","kind":13,"line":275},{"line":275,"kind":13,"name":"$node","containerName":"add_Mutations"},{"name":"ancestor","containerName":"add_Mutations","kind":12,"line":275},{"kind":12,"line":275,"containerName":"add_Mutations","name":"branch_length"},{"line":276,"kind":13,"name":"$node","containerName":"add_Mutations"},{"containerName":"add_Mutations","name":"branch_length","line":276,"kind":12},{"containerName":"add_Mutations","name":"$precision","kind":13,"line":276},{"name":"$len","containerName":"add_Mutations","kind":13,"line":277},{"line":278,"kind":13,"localvar":"my","definition":"my","name":"$j","containerName":"add_Mutations"},{"kind":13,"line":278,"name":"$j","containerName":"add_Mutations"},{"containerName":"add_Mutations","name":"$len","line":278,"kind":13},{"containerName":"add_Mutations","name":"$j","line":278,"kind":13},{"containerName":"add_Mutations","name":"@branches","line":279,"kind":13},{"line":279,"kind":13,"containerName":"add_Mutations","name":"$i"},{"line":281,"kind":13,"containerName":"add_Mutations","name":"$last"},{"line":281,"kind":13,"containerName":"add_Mutations","name":"$len"},{"containerName":"add_Mutations","name":"$branchlen","line":283,"kind":13},{"line":283,"kind":13,"containerName":"add_Mutations","name":"$len"},{"kind":13,"line":285,"containerName":"add_Mutations","name":"$node"},{"containerName":"add_Mutations","name":"isa","kind":12,"line":285},{"containerName":"add_Mutations","name":"$node","line":286,"kind":13},{"line":290,"kind":13,"containerName":"add_Mutations","name":"$node"},{"name":"reset_Genotypes","containerName":"add_Mutations","kind":12,"line":290},{"kind":13,"line":291,"name":"$i","containerName":"add_Mutations"},{"name":"$self","containerName":"add_Mutations","kind":13,"line":294},{"name":"throw","containerName":"add_Mutations","line":294,"kind":12},{"containerName":"add_Mutations","name":"$branchlen","kind":13,"line":295},{"containerName":"add_Mutations","name":"$last","line":295,"kind":13},{"kind":13,"line":296,"definition":"my","name":"@mutations","containerName":"add_Mutations","localvar":"my"},{"kind":13,"line":297,"containerName":"add_Mutations","definition":"my","name":"$j","localvar":"my"},{"line":297,"kind":13,"name":"$j","containerName":"add_Mutations"},{"kind":13,"line":297,"containerName":"add_Mutations","name":"$nummut"},{"line":297,"kind":13,"name":"$j","containerName":"add_Mutations"},{"localvar":"my","containerName":"add_Mutations","name":"$index","definition":"my","line":298,"kind":13},{"name":"$branchlen","containerName":"add_Mutations","kind":13,"line":298},{"line":299,"kind":13,"localvar":"my","containerName":"add_Mutations","definition":"my","name":"$branch"},{"line":299,"kind":13,"name":"$branches","containerName":"add_Mutations"},{"containerName":"add_Mutations","name":"$index","kind":13,"line":299},{"kind":13,"line":303,"containerName":"add_Mutations","name":"$g","definition":"my","localvar":"my"},{"name":"new","containerName":"add_Mutations","line":303,"kind":12},{"containerName":"add_Mutations","name":"$nodes","kind":13,"line":305},{"kind":13,"line":305,"name":"$branch","containerName":"add_Mutations"},{"name":"add_Genotype","containerName":"add_Mutations","kind":12,"line":305},{"line":305,"kind":13,"containerName":"add_Mutations","name":"$g"},{"kind":13,"line":306,"name":"@mutations","containerName":"add_Mutations"},{"kind":13,"line":309,"containerName":"add_Mutations","definition":"my","name":"$child","localvar":"my"},{"containerName":"add_Mutations","name":"$nodes","kind":13,"line":309},{"containerName":"add_Mutations","name":"$branch","kind":13,"line":309},{"line":309,"kind":12,"containerName":"add_Mutations","name":"get_all_Descendents"},{"line":310,"kind":13,"name":"$child","containerName":"add_Mutations"},{"kind":12,"line":310,"containerName":"add_Mutations","name":"add_Genotype"},{"containerName":"add_Mutations","name":"$g","line":310,"kind":13},{"kind":13,"line":315,"definition":"my","name":"$node","containerName":"add_Mutations","localvar":"my"},{"kind":13,"line":315,"name":"@nodes","containerName":"add_Mutations"},{"definition":"my","name":"$m","containerName":"add_Mutations","localvar":"my","kind":13,"line":316},{"kind":13,"line":316,"containerName":"add_Mutations","name":"@mutations"},{"name":"$node","containerName":"add_Mutations","line":317,"kind":13},{"containerName":"add_Mutations","name":"has_Marker","line":317,"kind":12},{"containerName":"add_Mutations","name":"$m","line":317,"kind":13},{"localvar":"my","name":"$emptyg","definition":"my","containerName":"add_Mutations","line":318,"kind":13},{"kind":12,"line":318,"containerName":"add_Mutations","name":"new"},{"line":318,"kind":13,"name":"$m","containerName":"add_Mutations"},{"kind":13,"line":320,"name":"$node","containerName":"add_Mutations"},{"containerName":"add_Mutations","name":"add_Genotype","line":320,"kind":12},{"containerName":"add_Mutations","name":"$emptyg","line":320,"kind":13}],"line":254,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$tree"},{"label":"$nummut"},{"label":"$precision"}],"documentation":"1;\n# $Id: Coalescent.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::Coalescent\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::Coalescent - A Coalescent simulation factory\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::Simulation::Coalescent;\n    my @taxonnames = qw(SpeciesA SpeciesB SpeciesC SpeciesD);\n    my $sim1 = Bio::PopGen::Simulation::Coalescent->new(-samples => \\@taxonnames);\n\n    my $tree = $sim1->next_tree;\n\n    # add 20 mutations randomly to the tree\n    $sim1->add_Mutations($tree,20);\n\n    # or for anonymous samples\n\n    my $sim2 = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 6,\n\t\t\t\t\t\t\t -maxcount => 50);\n    my $tree2 = $sim2->next_tree;\n    # add 20 mutations randomly to the tree\n    $sim2->add_Mutations($tree2,20);\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount\ntimes with branch lengths and provides the ability to randomly add\nmutations onto the tree with a probabilty proportional to the branch\nlengths.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York.\n\nThis module was previously named Bio::Tree::RandomTree\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::Coalescent;\nuse vars qw($PRECISION_DIGITS);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n\nuse Bio::Tree::AlleleNode;\nuse Bio::PopGen::Genotype;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::Coalescent->new();\n Function: Builds a new Bio::PopGen::Simulation::Coalescent object \n Returns : an instance of Bio::PopGen::Simulation::Coalescent\n Args    : -samples => arrayref of sample names\n           OR\n           -sample_size=> number of samples (samps will get a systematic name)\n           -maxcount   => [optional] maximum number of trees to provide\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($maxcount, $samps,$samplesize ) = $self->_rearrange([qw(MAXCOUNT\n\t\t\t\t\t\t\t       SAMPLES\n\t\t\t\t\t\t\t       SAMPLE_SIZE)],\n\t\t\t\t\t\t\t   @args);\n   my @samples;\n   \n   if( ! defined $samps ) { \n       if( ! defined $samplesize || $samplesize <= 0 ) { \n\t   $self->throw(\"Must specify a valid samplesize if parameter -SAMPLE is not specified (sampsize is $samplesize)\");\n       }\n       foreach ( 1..$samplesize ) { push @samples, \"Samp$_\"; }      \n   } else { \n       if( ref($samps) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -SAMPLES, did you forget a leading '\\\\'?\");\n       }\n       @samples = @$samps;\n   }\n   \n   $self->samples(\\@samples);\n   $self->sample_size(scalar @samples);\n   defined $maxcount && $self->maxcount($maxcount);   \n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   # If maxcount is set to something non-zero then next tree will\n   # continue to return valid trees until maxcount is reached\n   # otherwise will always return trees \n   return if( $self->maxcount &&\n\t      $self->{'_treecounter'}++ >= $self->maxcount );\n   my $size = $self->sample_size;\n   \n   my $in;\n   my @tree = ();\n   my @list = ();\n   \n   for($in=0;$in < 2*$size -1; $in++ ) { \n       push @tree, { 'nodenum' => \"Node$in\" };\n   }\n   # in C we would have 2 arrays\n   # an array of nodes (tree)\n   # and array of pointers to these nodes (list)\n   # and we just shuffle the list items to do the \n   # tree topology generation\n   # instead in perl, we will have a list of hashes (nodes) called @tree\n   # and a list of integers representing the indexes in tree called @list\n\n   for($in=0;$in < $size;$in++)  {\n       $tree[$in]->{'time'} = 0;\n       $tree[$in]->{'desc1'} = undef;\n       $tree[$in]->{'desc2'} = undef;\n       push @list, $in;\n   }\n\n   my $t=0;\n   # generate times for the nodes\n   for($in = $size; $in > 1; $in-- ) {\n\t$t+= -2.0 * log(1 - $self->random(1)) / ( $in * ($in-1) );    \n\t$tree[2 * $size - $in]->{'time'} =$t;\n    }\n   # topology generation\n   for ($in = $size; $in > 1; $in-- ) {\n       my $pick = int $self->random($in);    \n       my $nodeindex = $list[$pick];       \n       my $swap = 2 * $size - $in;       \n       $tree[$swap]->{'desc1'} = $nodeindex;\t\n       $list[$pick] = $list[$in-1];       \n       $pick = int rand($in - 1);    \n       $nodeindex = $list[$pick];\n       $tree[$swap]->{'desc2'} = $nodeindex;\t\n       $list[$pick] = $swap;\n   }\n   # Let's convert the hashes into nodes\n\n   my @nodes = ();   \n   foreach my $n ( @tree ) { \n       push @nodes, \n\t   Bio::Tree::AlleleNode->new(-id => $n->{'nodenum'},\n\t\t\t\t     -branch_length => $n->{'time'});\n   }\n   my $ct = 0;\n   foreach my $node ( @nodes ) { \n       my $n = $tree[$ct++];\n       if( defined $n->{'desc1'} ) {\n\t   $node->add_Descendent($nodes[$n->{'desc1'}]);\n       }\n       if( defined $n->{'desc2'} ) { \n\t   $node->add_Descendent($nodes[$n->{'desc2'}]);\n       }\n   }   \n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n=head2 add_Mutations\n\n Title   : add_Mutations\n Usage   : $factory->add_Mutations($tree, $mutcount);\n Function: Adds mutations to a tree via a random process weighted by \n           branch length (it is a poisson distribution \n\t\t\t  as part of a coalescent process) \n Returns : none\n Args    : $tree - Bio::Tree::TreeI \n           $nummut - number of mutations\n           $precision - optional # of digits for precision","label":"add_Mutations($self,$tree,$nummut,$precision)"},"detail":"($self,$tree,$nummut,$precision)"},{"kind":12,"line":303,"containerName":"PopGen::Genotype","name":"Bio"},{"kind":12,"line":318,"containerName":"PopGen::Genotype","name":"Bio"},{"signature":{"label":"maxcount($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Coalescent.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::Coalescent\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::Coalescent - A Coalescent simulation factory\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::Simulation::Coalescent;\n    my @taxonnames = qw(SpeciesA SpeciesB SpeciesC SpeciesD);\n    my $sim1 = Bio::PopGen::Simulation::Coalescent->new(-samples => \\@taxonnames);\n\n    my $tree = $sim1->next_tree;\n\n    # add 20 mutations randomly to the tree\n    $sim1->add_Mutations($tree,20);\n\n    # or for anonymous samples\n\n    my $sim2 = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 6,\n\t\t\t\t\t\t\t -maxcount => 50);\n    my $tree2 = $sim2->next_tree;\n    # add 20 mutations randomly to the tree\n    $sim2->add_Mutations($tree2,20);\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount\ntimes with branch lengths and provides the ability to randomly add\nmutations onto the tree with a probabilty proportional to the branch\nlengths.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York.\n\nThis module was previously named Bio::Tree::RandomTree\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::Coalescent;\nuse vars qw($PRECISION_DIGITS);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n\nuse Bio::Tree::AlleleNode;\nuse Bio::PopGen::Genotype;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::Coalescent->new();\n Function: Builds a new Bio::PopGen::Simulation::Coalescent object \n Returns : an instance of Bio::PopGen::Simulation::Coalescent\n Args    : -samples => arrayref of sample names\n           OR\n           -sample_size=> number of samples (samps will get a systematic name)\n           -maxcount   => [optional] maximum number of trees to provide\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($maxcount, $samps,$samplesize ) = $self->_rearrange([qw(MAXCOUNT\n\t\t\t\t\t\t\t       SAMPLES\n\t\t\t\t\t\t\t       SAMPLE_SIZE)],\n\t\t\t\t\t\t\t   @args);\n   my @samples;\n   \n   if( ! defined $samps ) { \n       if( ! defined $samplesize || $samplesize <= 0 ) { \n\t   $self->throw(\"Must specify a valid samplesize if parameter -SAMPLE is not specified (sampsize is $samplesize)\");\n       }\n       foreach ( 1..$samplesize ) { push @samples, \"Samp$_\"; }      \n   } else { \n       if( ref($samps) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -SAMPLES, did you forget a leading '\\\\'?\");\n       }\n       @samples = @$samps;\n   }\n   \n   $self->samples(\\@samples);\n   $self->sample_size(scalar @samples);\n   defined $maxcount && $self->maxcount($maxcount);   \n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   # If maxcount is set to something non-zero then next tree will\n   # continue to return valid trees until maxcount is reached\n   # otherwise will always return trees \n   return if( $self->maxcount &&\n\t      $self->{'_treecounter'}++ >= $self->maxcount );\n   my $size = $self->sample_size;\n   \n   my $in;\n   my @tree = ();\n   my @list = ();\n   \n   for($in=0;$in < 2*$size -1; $in++ ) { \n       push @tree, { 'nodenum' => \"Node$in\" };\n   }\n   # in C we would have 2 arrays\n   # an array of nodes (tree)\n   # and array of pointers to these nodes (list)\n   # and we just shuffle the list items to do the \n   # tree topology generation\n   # instead in perl, we will have a list of hashes (nodes) called @tree\n   # and a list of integers representing the indexes in tree called @list\n\n   for($in=0;$in < $size;$in++)  {\n       $tree[$in]->{'time'} = 0;\n       $tree[$in]->{'desc1'} = undef;\n       $tree[$in]->{'desc2'} = undef;\n       push @list, $in;\n   }\n\n   my $t=0;\n   # generate times for the nodes\n   for($in = $size; $in > 1; $in-- ) {\n\t$t+= -2.0 * log(1 - $self->random(1)) / ( $in * ($in-1) );    \n\t$tree[2 * $size - $in]->{'time'} =$t;\n    }\n   # topology generation\n   for ($in = $size; $in > 1; $in-- ) {\n       my $pick = int $self->random($in);    \n       my $nodeindex = $list[$pick];       \n       my $swap = 2 * $size - $in;       \n       $tree[$swap]->{'desc1'} = $nodeindex;\t\n       $list[$pick] = $list[$in-1];       \n       $pick = int rand($in - 1);    \n       $nodeindex = $list[$pick];\n       $tree[$swap]->{'desc2'} = $nodeindex;\t\n       $list[$pick] = $swap;\n   }\n   # Let's convert the hashes into nodes\n\n   my @nodes = ();   \n   foreach my $n ( @tree ) { \n       push @nodes, \n\t   Bio::Tree::AlleleNode->new(-id => $n->{'nodenum'},\n\t\t\t\t     -branch_length => $n->{'time'});\n   }\n   my $ct = 0;\n   foreach my $node ( @nodes ) { \n       my $n = $tree[$ct++];\n       if( defined $n->{'desc1'} ) {\n\t   $node->add_Descendent($nodes[$n->{'desc1'}]);\n       }\n       if( defined $n->{'desc2'} ) { \n\t   $node->add_Descendent($nodes[$n->{'desc2'}]);\n       }\n   }   \n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n=head2 add_Mutations\n\n Title   : add_Mutations\n Usage   : $factory->add_Mutations($tree, $mutcount);\n Function: Adds mutations to a tree via a random process weighted by \n           branch length (it is a poisson distribution \n\t\t\t  as part of a coalescent process) \n Returns : none\n Args    : $tree - Bio::Tree::TreeI \n           $nummut - number of mutations\n           $precision - optional # of digits for precision\n\n\n\nsub add_Mutations{\n   my ($self,$tree, $nummut,$precision) = @_;\n   $precision ||= $PRECISION_DIGITS;\n   $precision = 10**$precision;\n\n   my @branches;\n   my @lens;\n   my $branchlen = 0;\n   my $last = 0;\n   my @nodes = $tree->get_nodes();\n   my $i = 0;\n\n   # Jason's somewhat simplistics way of doing a poission\n   # distribution for a fixed number of mutations\n   # build an array and put the node number in a slot\n   # representing the branch to put a mutation on\n   # but weight the number of slots per branch by the \n   # length of the branch ( ancestor's time - node time)\n   \n   foreach my $node ( @nodes ) {\n       if( $node->ancestor ) { \n\t   my $len = int ( ($node->ancestor->branch_length - \n\t\t\t    $node->branch_length) * $precision);\n\t   if ( $len > 0 ) {\n\t       for( my $j =0;$j < $len;$j++) {\n\t\t   push @branches, $i;\n\t       }\n\t       $last += $len;\n\t   }\n\t   $branchlen += $len;\n       }\n       if( ! $node->isa('Bio::Tree::AlleleNode') ) {\n\t   bless $node, 'Bio::Tree::AlleleNode'; # rebless it to the right node\n       } \n       # This let's us reset the stored genotypes so we can keep reusing the \n       # same tree topology, but throw down mutations multiple times\n       $node->reset_Genotypes;\n       $i++;\n   }\n   # sanity check\n   $self->throw(\"branch len is $branchlen arraylen is $last\")\n        unless ( $branchlen == $last );\n   my @mutations;\n   for( my $j = 0; $j < $nummut; $j++)  {\n       my $index = int(rand($branchlen));\n       my $branch = $branches[$index];\n\n       # We're using an infinite sites model so every new\n       # mutation is a new site\n       my $g = Bio::PopGen::Genotype->new(-marker_name  => \"Mutation$j\",\n\t\t\t\t\t -alleles => [1]);\n       $nodes[$branch]->add_Genotype($g);\n       push @mutations, \"Mutation$j\";\n       # Let's add this mutation to all the children (push it down\n       # the branches to the tips)\n       foreach my $child ( $nodes[$branch]->get_all_Descendents ) {\n\t   $child->add_Genotype($g);\n       }\n   }\n   # Insure that everyone who doesn't have the mutation\n   # has the ancestral state, which is '0'\n   foreach my $node ( @nodes ) {\n       foreach my $m ( @mutations ) {\n\t   if( ! $node->has_Marker($m) ) {\n\t       my $emptyg = Bio::PopGen::Genotype->new(-marker_name => $m,\n\t\t\t\t\t\t      -alleles     => [0]);\n\t       $node->add_Genotype($emptyg);\n\t   }\n       }\n   }\n}\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"maxcount","line":338,"kind":13},{"line":338,"kind":13,"name":"$value","containerName":"maxcount"},{"kind":13,"line":339,"name":"$value","containerName":"maxcount"},{"kind":13,"line":340,"name":"$value","containerName":"maxcount"},{"kind":13,"line":341,"containerName":"maxcount","name":"$self"},{"kind":13,"line":343,"containerName":"maxcount","name":"$self"},{"containerName":"maxcount","name":"warn","kind":12,"line":343},{"line":344,"kind":13,"name":"$self","containerName":"maxcount"},{"line":347,"kind":13,"containerName":"maxcount","name":"$self"}],"line":337,"kind":12,"range":{"start":{"line":337,"character":0},"end":{"line":348,"character":9999}},"name":"maxcount"},{"range":{"start":{"character":0,"line":362},"end":{"line":373,"character":9999}},"name":"samples","line":362,"children":[{"line":363,"kind":13,"localvar":"my","containerName":"samples","definition":"my","name":"$self"},{"name":"$value","containerName":"samples","kind":13,"line":363},{"line":364,"kind":13,"containerName":"samples","name":"$value"},{"line":365,"kind":13,"containerName":"samples","name":"$value"},{"name":"$self","containerName":"samples","kind":13,"line":366},{"containerName":"samples","name":"warn","line":366,"kind":12},{"name":"$value","containerName":"samples","line":367,"kind":13},{"line":369,"kind":13,"containerName":"samples","name":"$self"},{"containerName":"samples","name":"$value","line":369,"kind":13},{"kind":13,"line":371,"name":"$self","containerName":"samples"}],"kind":12,"detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Coalescent.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::Coalescent\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::Coalescent - A Coalescent simulation factory\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::Simulation::Coalescent;\n    my @taxonnames = qw(SpeciesA SpeciesB SpeciesC SpeciesD);\n    my $sim1 = Bio::PopGen::Simulation::Coalescent->new(-samples => \\@taxonnames);\n\n    my $tree = $sim1->next_tree;\n\n    # add 20 mutations randomly to the tree\n    $sim1->add_Mutations($tree,20);\n\n    # or for anonymous samples\n\n    my $sim2 = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 6,\n\t\t\t\t\t\t\t -maxcount => 50);\n    my $tree2 = $sim2->next_tree;\n    # add 20 mutations randomly to the tree\n    $sim2->add_Mutations($tree2,20);\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount\ntimes with branch lengths and provides the ability to randomly add\nmutations onto the tree with a probabilty proportional to the branch\nlengths.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York.\n\nThis module was previously named Bio::Tree::RandomTree\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::Coalescent;\nuse vars qw($PRECISION_DIGITS);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n\nuse Bio::Tree::AlleleNode;\nuse Bio::PopGen::Genotype;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::Coalescent->new();\n Function: Builds a new Bio::PopGen::Simulation::Coalescent object \n Returns : an instance of Bio::PopGen::Simulation::Coalescent\n Args    : -samples => arrayref of sample names\n           OR\n           -sample_size=> number of samples (samps will get a systematic name)\n           -maxcount   => [optional] maximum number of trees to provide\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($maxcount, $samps,$samplesize ) = $self->_rearrange([qw(MAXCOUNT\n\t\t\t\t\t\t\t       SAMPLES\n\t\t\t\t\t\t\t       SAMPLE_SIZE)],\n\t\t\t\t\t\t\t   @args);\n   my @samples;\n   \n   if( ! defined $samps ) { \n       if( ! defined $samplesize || $samplesize <= 0 ) { \n\t   $self->throw(\"Must specify a valid samplesize if parameter -SAMPLE is not specified (sampsize is $samplesize)\");\n       }\n       foreach ( 1..$samplesize ) { push @samples, \"Samp$_\"; }      \n   } else { \n       if( ref($samps) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -SAMPLES, did you forget a leading '\\\\'?\");\n       }\n       @samples = @$samps;\n   }\n   \n   $self->samples(\\@samples);\n   $self->sample_size(scalar @samples);\n   defined $maxcount && $self->maxcount($maxcount);   \n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   # If maxcount is set to something non-zero then next tree will\n   # continue to return valid trees until maxcount is reached\n   # otherwise will always return trees \n   return if( $self->maxcount &&\n\t      $self->{'_treecounter'}++ >= $self->maxcount );\n   my $size = $self->sample_size;\n   \n   my $in;\n   my @tree = ();\n   my @list = ();\n   \n   for($in=0;$in < 2*$size -1; $in++ ) { \n       push @tree, { 'nodenum' => \"Node$in\" };\n   }\n   # in C we would have 2 arrays\n   # an array of nodes (tree)\n   # and array of pointers to these nodes (list)\n   # and we just shuffle the list items to do the \n   # tree topology generation\n   # instead in perl, we will have a list of hashes (nodes) called @tree\n   # and a list of integers representing the indexes in tree called @list\n\n   for($in=0;$in < $size;$in++)  {\n       $tree[$in]->{'time'} = 0;\n       $tree[$in]->{'desc1'} = undef;\n       $tree[$in]->{'desc2'} = undef;\n       push @list, $in;\n   }\n\n   my $t=0;\n   # generate times for the nodes\n   for($in = $size; $in > 1; $in-- ) {\n\t$t+= -2.0 * log(1 - $self->random(1)) / ( $in * ($in-1) );    \n\t$tree[2 * $size - $in]->{'time'} =$t;\n    }\n   # topology generation\n   for ($in = $size; $in > 1; $in-- ) {\n       my $pick = int $self->random($in);    \n       my $nodeindex = $list[$pick];       \n       my $swap = 2 * $size - $in;       \n       $tree[$swap]->{'desc1'} = $nodeindex;\t\n       $list[$pick] = $list[$in-1];       \n       $pick = int rand($in - 1);    \n       $nodeindex = $list[$pick];\n       $tree[$swap]->{'desc2'} = $nodeindex;\t\n       $list[$pick] = $swap;\n   }\n   # Let's convert the hashes into nodes\n\n   my @nodes = ();   \n   foreach my $n ( @tree ) { \n       push @nodes, \n\t   Bio::Tree::AlleleNode->new(-id => $n->{'nodenum'},\n\t\t\t\t     -branch_length => $n->{'time'});\n   }\n   my $ct = 0;\n   foreach my $node ( @nodes ) { \n       my $n = $tree[$ct++];\n       if( defined $n->{'desc1'} ) {\n\t   $node->add_Descendent($nodes[$n->{'desc1'}]);\n       }\n       if( defined $n->{'desc2'} ) { \n\t   $node->add_Descendent($nodes[$n->{'desc2'}]);\n       }\n   }   \n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n=head2 add_Mutations\n\n Title   : add_Mutations\n Usage   : $factory->add_Mutations($tree, $mutcount);\n Function: Adds mutations to a tree via a random process weighted by \n           branch length (it is a poisson distribution \n\t\t\t  as part of a coalescent process) \n Returns : none\n Args    : $tree - Bio::Tree::TreeI \n           $nummut - number of mutations\n           $precision - optional # of digits for precision\n\n\n\nsub add_Mutations{\n   my ($self,$tree, $nummut,$precision) = @_;\n   $precision ||= $PRECISION_DIGITS;\n   $precision = 10**$precision;\n\n   my @branches;\n   my @lens;\n   my $branchlen = 0;\n   my $last = 0;\n   my @nodes = $tree->get_nodes();\n   my $i = 0;\n\n   # Jason's somewhat simplistics way of doing a poission\n   # distribution for a fixed number of mutations\n   # build an array and put the node number in a slot\n   # representing the branch to put a mutation on\n   # but weight the number of slots per branch by the \n   # length of the branch ( ancestor's time - node time)\n   \n   foreach my $node ( @nodes ) {\n       if( $node->ancestor ) { \n\t   my $len = int ( ($node->ancestor->branch_length - \n\t\t\t    $node->branch_length) * $precision);\n\t   if ( $len > 0 ) {\n\t       for( my $j =0;$j < $len;$j++) {\n\t\t   push @branches, $i;\n\t       }\n\t       $last += $len;\n\t   }\n\t   $branchlen += $len;\n       }\n       if( ! $node->isa('Bio::Tree::AlleleNode') ) {\n\t   bless $node, 'Bio::Tree::AlleleNode'; # rebless it to the right node\n       } \n       # This let's us reset the stored genotypes so we can keep reusing the \n       # same tree topology, but throw down mutations multiple times\n       $node->reset_Genotypes;\n       $i++;\n   }\n   # sanity check\n   $self->throw(\"branch len is $branchlen arraylen is $last\")\n        unless ( $branchlen == $last );\n   my @mutations;\n   for( my $j = 0; $j < $nummut; $j++)  {\n       my $index = int(rand($branchlen));\n       my $branch = $branches[$index];\n\n       # We're using an infinite sites model so every new\n       # mutation is a new site\n       my $g = Bio::PopGen::Genotype->new(-marker_name  => \"Mutation$j\",\n\t\t\t\t\t -alleles => [1]);\n       $nodes[$branch]->add_Genotype($g);\n       push @mutations, \"Mutation$j\";\n       # Let's add this mutation to all the children (push it down\n       # the branches to the tips)\n       foreach my $child ( $nodes[$branch]->get_all_Descendents ) {\n\t   $child->add_Genotype($g);\n       }\n   }\n   # Insure that everyone who doesn't have the mutation\n   # has the ancestral state, which is '0'\n   foreach my $node ( @nodes ) {\n       foreach my $m ( @mutations ) {\n\t   if( ! $node->has_Marker($m) ) {\n\t       my $emptyg = Bio::PopGen::Genotype->new(-marker_name => $m,\n\t\t\t\t\t\t      -alleles     => [0]);\n\t       $node->add_Genotype($emptyg);\n\t   }\n       }\n   }\n}\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)\n\n\n\nsub maxcount{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( $value =~ /^(\\d+)/ ) { \n\t   $self->{'maxcount'} = $1;\n       } else { \n\t   $self->warn(\"Must specify a valid Positive integer to maxcount\");\n\t   $self->{'maxcount'} = 0;\n       }\n  }\n   return $self->{'_maxcount'};\n}\n\n=head2 samples\n\n Title   : samples\n Usage   : $obj->samples($newval)\n Function: \n Example : \n Returns : value of samples\n Args    : newvalue (optional)","label":"samples($self,$value)"},"containerName":"main::","definition":"sub"},{"range":{"start":{"line":387,"character":0},"end":{"character":9999,"line":394}},"name":"sample_size","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Coalescent.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::Coalescent\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::Coalescent - A Coalescent simulation factory\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::Simulation::Coalescent;\n    my @taxonnames = qw(SpeciesA SpeciesB SpeciesC SpeciesD);\n    my $sim1 = Bio::PopGen::Simulation::Coalescent->new(-samples => \\@taxonnames);\n\n    my $tree = $sim1->next_tree;\n\n    # add 20 mutations randomly to the tree\n    $sim1->add_Mutations($tree,20);\n\n    # or for anonymous samples\n\n    my $sim2 = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 6,\n\t\t\t\t\t\t\t -maxcount => 50);\n    my $tree2 = $sim2->next_tree;\n    # add 20 mutations randomly to the tree\n    $sim2->add_Mutations($tree2,20);\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount\ntimes with branch lengths and provides the ability to randomly add\nmutations onto the tree with a probabilty proportional to the branch\nlengths.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York.\n\nThis module was previously named Bio::Tree::RandomTree\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::Coalescent;\nuse vars qw($PRECISION_DIGITS);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n\nuse Bio::Tree::AlleleNode;\nuse Bio::PopGen::Genotype;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::Coalescent->new();\n Function: Builds a new Bio::PopGen::Simulation::Coalescent object \n Returns : an instance of Bio::PopGen::Simulation::Coalescent\n Args    : -samples => arrayref of sample names\n           OR\n           -sample_size=> number of samples (samps will get a systematic name)\n           -maxcount   => [optional] maximum number of trees to provide\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($maxcount, $samps,$samplesize ) = $self->_rearrange([qw(MAXCOUNT\n\t\t\t\t\t\t\t       SAMPLES\n\t\t\t\t\t\t\t       SAMPLE_SIZE)],\n\t\t\t\t\t\t\t   @args);\n   my @samples;\n   \n   if( ! defined $samps ) { \n       if( ! defined $samplesize || $samplesize <= 0 ) { \n\t   $self->throw(\"Must specify a valid samplesize if parameter -SAMPLE is not specified (sampsize is $samplesize)\");\n       }\n       foreach ( 1..$samplesize ) { push @samples, \"Samp$_\"; }      \n   } else { \n       if( ref($samps) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -SAMPLES, did you forget a leading '\\\\'?\");\n       }\n       @samples = @$samps;\n   }\n   \n   $self->samples(\\@samples);\n   $self->sample_size(scalar @samples);\n   defined $maxcount && $self->maxcount($maxcount);   \n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   # If maxcount is set to something non-zero then next tree will\n   # continue to return valid trees until maxcount is reached\n   # otherwise will always return trees \n   return if( $self->maxcount &&\n\t      $self->{'_treecounter'}++ >= $self->maxcount );\n   my $size = $self->sample_size;\n   \n   my $in;\n   my @tree = ();\n   my @list = ();\n   \n   for($in=0;$in < 2*$size -1; $in++ ) { \n       push @tree, { 'nodenum' => \"Node$in\" };\n   }\n   # in C we would have 2 arrays\n   # an array of nodes (tree)\n   # and array of pointers to these nodes (list)\n   # and we just shuffle the list items to do the \n   # tree topology generation\n   # instead in perl, we will have a list of hashes (nodes) called @tree\n   # and a list of integers representing the indexes in tree called @list\n\n   for($in=0;$in < $size;$in++)  {\n       $tree[$in]->{'time'} = 0;\n       $tree[$in]->{'desc1'} = undef;\n       $tree[$in]->{'desc2'} = undef;\n       push @list, $in;\n   }\n\n   my $t=0;\n   # generate times for the nodes\n   for($in = $size; $in > 1; $in-- ) {\n\t$t+= -2.0 * log(1 - $self->random(1)) / ( $in * ($in-1) );    \n\t$tree[2 * $size - $in]->{'time'} =$t;\n    }\n   # topology generation\n   for ($in = $size; $in > 1; $in-- ) {\n       my $pick = int $self->random($in);    \n       my $nodeindex = $list[$pick];       \n       my $swap = 2 * $size - $in;       \n       $tree[$swap]->{'desc1'} = $nodeindex;\t\n       $list[$pick] = $list[$in-1];       \n       $pick = int rand($in - 1);    \n       $nodeindex = $list[$pick];\n       $tree[$swap]->{'desc2'} = $nodeindex;\t\n       $list[$pick] = $swap;\n   }\n   # Let's convert the hashes into nodes\n\n   my @nodes = ();   \n   foreach my $n ( @tree ) { \n       push @nodes, \n\t   Bio::Tree::AlleleNode->new(-id => $n->{'nodenum'},\n\t\t\t\t     -branch_length => $n->{'time'});\n   }\n   my $ct = 0;\n   foreach my $node ( @nodes ) { \n       my $n = $tree[$ct++];\n       if( defined $n->{'desc1'} ) {\n\t   $node->add_Descendent($nodes[$n->{'desc1'}]);\n       }\n       if( defined $n->{'desc2'} ) { \n\t   $node->add_Descendent($nodes[$n->{'desc2'}]);\n       }\n   }   \n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n=head2 add_Mutations\n\n Title   : add_Mutations\n Usage   : $factory->add_Mutations($tree, $mutcount);\n Function: Adds mutations to a tree via a random process weighted by \n           branch length (it is a poisson distribution \n\t\t\t  as part of a coalescent process) \n Returns : none\n Args    : $tree - Bio::Tree::TreeI \n           $nummut - number of mutations\n           $precision - optional # of digits for precision\n\n\n\nsub add_Mutations{\n   my ($self,$tree, $nummut,$precision) = @_;\n   $precision ||= $PRECISION_DIGITS;\n   $precision = 10**$precision;\n\n   my @branches;\n   my @lens;\n   my $branchlen = 0;\n   my $last = 0;\n   my @nodes = $tree->get_nodes();\n   my $i = 0;\n\n   # Jason's somewhat simplistics way of doing a poission\n   # distribution for a fixed number of mutations\n   # build an array and put the node number in a slot\n   # representing the branch to put a mutation on\n   # but weight the number of slots per branch by the \n   # length of the branch ( ancestor's time - node time)\n   \n   foreach my $node ( @nodes ) {\n       if( $node->ancestor ) { \n\t   my $len = int ( ($node->ancestor->branch_length - \n\t\t\t    $node->branch_length) * $precision);\n\t   if ( $len > 0 ) {\n\t       for( my $j =0;$j < $len;$j++) {\n\t\t   push @branches, $i;\n\t       }\n\t       $last += $len;\n\t   }\n\t   $branchlen += $len;\n       }\n       if( ! $node->isa('Bio::Tree::AlleleNode') ) {\n\t   bless $node, 'Bio::Tree::AlleleNode'; # rebless it to the right node\n       } \n       # This let's us reset the stored genotypes so we can keep reusing the \n       # same tree topology, but throw down mutations multiple times\n       $node->reset_Genotypes;\n       $i++;\n   }\n   # sanity check\n   $self->throw(\"branch len is $branchlen arraylen is $last\")\n        unless ( $branchlen == $last );\n   my @mutations;\n   for( my $j = 0; $j < $nummut; $j++)  {\n       my $index = int(rand($branchlen));\n       my $branch = $branches[$index];\n\n       # We're using an infinite sites model so every new\n       # mutation is a new site\n       my $g = Bio::PopGen::Genotype->new(-marker_name  => \"Mutation$j\",\n\t\t\t\t\t -alleles => [1]);\n       $nodes[$branch]->add_Genotype($g);\n       push @mutations, \"Mutation$j\";\n       # Let's add this mutation to all the children (push it down\n       # the branches to the tips)\n       foreach my $child ( $nodes[$branch]->get_all_Descendents ) {\n\t   $child->add_Genotype($g);\n       }\n   }\n   # Insure that everyone who doesn't have the mutation\n   # has the ancestral state, which is '0'\n   foreach my $node ( @nodes ) {\n       foreach my $m ( @mutations ) {\n\t   if( ! $node->has_Marker($m) ) {\n\t       my $emptyg = Bio::PopGen::Genotype->new(-marker_name => $m,\n\t\t\t\t\t\t      -alleles     => [0]);\n\t       $node->add_Genotype($emptyg);\n\t   }\n       }\n   }\n}\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)\n\n\n\nsub maxcount{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( $value =~ /^(\\d+)/ ) { \n\t   $self->{'maxcount'} = $1;\n       } else { \n\t   $self->warn(\"Must specify a valid Positive integer to maxcount\");\n\t   $self->{'maxcount'} = 0;\n       }\n  }\n   return $self->{'_maxcount'};\n}\n\n=head2 samples\n\n Title   : samples\n Usage   : $obj->samples($newval)\n Function: \n Example : \n Returns : value of samples\n Args    : newvalue (optional)\n\n\n\nsub samples{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( ref($value) !~ /ARRAY/i ) { \n\t   $self->warn(\"Must specify a valid array ref to the method 'samples'\");\n\t   $value = [];\n       } \n      $self->{'samples'} = $value;\n    }\n    return $self->{'samples'};\n\n}\n\n=head2 sample_size\n\n Title   : sample_size\n Usage   : $obj->sample_size($newval)\n Function: \n Example : \n Returns : value of sample_size\n Args    : newvalue (optional)","label":"sample_size($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"sample_size","localvar":"my","kind":13,"line":388},{"line":388,"kind":13,"containerName":"sample_size","name":"$value"},{"name":"$value","containerName":"sample_size","kind":13,"line":389},{"containerName":"sample_size","name":"$self","line":390,"kind":13},{"containerName":"sample_size","name":"$value","line":390,"kind":13},{"line":392,"kind":13,"name":"$self","containerName":"sample_size"}],"line":387,"kind":12},{"range":{"start":{"line":409,"character":0},"end":{"line":412,"character":9999}},"name":"random","line":409,"children":[{"localvar":"my","containerName":"random","name":"$self","definition":"my","line":410,"kind":13},{"name":"$max","containerName":"random","line":410,"kind":13},{"containerName":"random","name":"$max","line":411,"kind":13}],"kind":12,"detail":"($self,$max)","signature":{"label":"random($self,$max)","documentation":"1;\n# $Id: Coalescent.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Simulation::Coalescent\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Simulation::Coalescent - A Coalescent simulation factory\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::Simulation::Coalescent;\n    my @taxonnames = qw(SpeciesA SpeciesB SpeciesC SpeciesD);\n    my $sim1 = Bio::PopGen::Simulation::Coalescent->new(-samples => \\@taxonnames);\n\n    my $tree = $sim1->next_tree;\n\n    # add 20 mutations randomly to the tree\n    $sim1->add_Mutations($tree,20);\n\n    # or for anonymous samples\n\n    my $sim2 = Bio::PopGen::Simulation::Coalescent->new( -sample_size => 6,\n\t\t\t\t\t\t\t -maxcount => 50);\n    my $tree2 = $sim2->next_tree;\n    # add 20 mutations randomly to the tree\n    $sim2->add_Mutations($tree2,20);\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount\ntimes with branch lengths and provides the ability to randomly add\nmutations onto the tree with a probabilty proportional to the branch\nlengths.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York.\n\nThis module was previously named Bio::Tree::RandomTree\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Matthew Hahn\n\nEmail jason-at-bioperl-dot-org\nEmail matthew-dot-hahn-at-duke-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Simulation::Coalescent;\nuse vars qw($PRECISION_DIGITS);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n\nuse Bio::Tree::AlleleNode;\nuse Bio::PopGen::Genotype;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Simulation::Coalescent->new();\n Function: Builds a new Bio::PopGen::Simulation::Coalescent object \n Returns : an instance of Bio::PopGen::Simulation::Coalescent\n Args    : -samples => arrayref of sample names\n           OR\n           -sample_size=> number of samples (samps will get a systematic name)\n           -maxcount   => [optional] maximum number of trees to provide\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($maxcount, $samps,$samplesize ) = $self->_rearrange([qw(MAXCOUNT\n\t\t\t\t\t\t\t       SAMPLES\n\t\t\t\t\t\t\t       SAMPLE_SIZE)],\n\t\t\t\t\t\t\t   @args);\n   my @samples;\n   \n   if( ! defined $samps ) { \n       if( ! defined $samplesize || $samplesize <= 0 ) { \n\t   $self->throw(\"Must specify a valid samplesize if parameter -SAMPLE is not specified (sampsize is $samplesize)\");\n       }\n       foreach ( 1..$samplesize ) { push @samples, \"Samp$_\"; }      \n   } else { \n       if( ref($samps) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -SAMPLES, did you forget a leading '\\\\'?\");\n       }\n       @samples = @$samps;\n   }\n   \n   $self->samples(\\@samples);\n   $self->sample_size(scalar @samples);\n   defined $maxcount && $self->maxcount($maxcount);   \n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   # If maxcount is set to something non-zero then next tree will\n   # continue to return valid trees until maxcount is reached\n   # otherwise will always return trees \n   return if( $self->maxcount &&\n\t      $self->{'_treecounter'}++ >= $self->maxcount );\n   my $size = $self->sample_size;\n   \n   my $in;\n   my @tree = ();\n   my @list = ();\n   \n   for($in=0;$in < 2*$size -1; $in++ ) { \n       push @tree, { 'nodenum' => \"Node$in\" };\n   }\n   # in C we would have 2 arrays\n   # an array of nodes (tree)\n   # and array of pointers to these nodes (list)\n   # and we just shuffle the list items to do the \n   # tree topology generation\n   # instead in perl, we will have a list of hashes (nodes) called @tree\n   # and a list of integers representing the indexes in tree called @list\n\n   for($in=0;$in < $size;$in++)  {\n       $tree[$in]->{'time'} = 0;\n       $tree[$in]->{'desc1'} = undef;\n       $tree[$in]->{'desc2'} = undef;\n       push @list, $in;\n   }\n\n   my $t=0;\n   # generate times for the nodes\n   for($in = $size; $in > 1; $in-- ) {\n\t$t+= -2.0 * log(1 - $self->random(1)) / ( $in * ($in-1) );    \n\t$tree[2 * $size - $in]->{'time'} =$t;\n    }\n   # topology generation\n   for ($in = $size; $in > 1; $in-- ) {\n       my $pick = int $self->random($in);    \n       my $nodeindex = $list[$pick];       \n       my $swap = 2 * $size - $in;       \n       $tree[$swap]->{'desc1'} = $nodeindex;\t\n       $list[$pick] = $list[$in-1];       \n       $pick = int rand($in - 1);    \n       $nodeindex = $list[$pick];\n       $tree[$swap]->{'desc2'} = $nodeindex;\t\n       $list[$pick] = $swap;\n   }\n   # Let's convert the hashes into nodes\n\n   my @nodes = ();   \n   foreach my $n ( @tree ) { \n       push @nodes, \n\t   Bio::Tree::AlleleNode->new(-id => $n->{'nodenum'},\n\t\t\t\t     -branch_length => $n->{'time'});\n   }\n   my $ct = 0;\n   foreach my $node ( @nodes ) { \n       my $n = $tree[$ct++];\n       if( defined $n->{'desc1'} ) {\n\t   $node->add_Descendent($nodes[$n->{'desc1'}]);\n       }\n       if( defined $n->{'desc2'} ) { \n\t   $node->add_Descendent($nodes[$n->{'desc2'}]);\n       }\n   }   \n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n=head2 add_Mutations\n\n Title   : add_Mutations\n Usage   : $factory->add_Mutations($tree, $mutcount);\n Function: Adds mutations to a tree via a random process weighted by \n           branch length (it is a poisson distribution \n\t\t\t  as part of a coalescent process) \n Returns : none\n Args    : $tree - Bio::Tree::TreeI \n           $nummut - number of mutations\n           $precision - optional # of digits for precision\n\n\n\nsub add_Mutations{\n   my ($self,$tree, $nummut,$precision) = @_;\n   $precision ||= $PRECISION_DIGITS;\n   $precision = 10**$precision;\n\n   my @branches;\n   my @lens;\n   my $branchlen = 0;\n   my $last = 0;\n   my @nodes = $tree->get_nodes();\n   my $i = 0;\n\n   # Jason's somewhat simplistics way of doing a poission\n   # distribution for a fixed number of mutations\n   # build an array and put the node number in a slot\n   # representing the branch to put a mutation on\n   # but weight the number of slots per branch by the \n   # length of the branch ( ancestor's time - node time)\n   \n   foreach my $node ( @nodes ) {\n       if( $node->ancestor ) { \n\t   my $len = int ( ($node->ancestor->branch_length - \n\t\t\t    $node->branch_length) * $precision);\n\t   if ( $len > 0 ) {\n\t       for( my $j =0;$j < $len;$j++) {\n\t\t   push @branches, $i;\n\t       }\n\t       $last += $len;\n\t   }\n\t   $branchlen += $len;\n       }\n       if( ! $node->isa('Bio::Tree::AlleleNode') ) {\n\t   bless $node, 'Bio::Tree::AlleleNode'; # rebless it to the right node\n       } \n       # This let's us reset the stored genotypes so we can keep reusing the \n       # same tree topology, but throw down mutations multiple times\n       $node->reset_Genotypes;\n       $i++;\n   }\n   # sanity check\n   $self->throw(\"branch len is $branchlen arraylen is $last\")\n        unless ( $branchlen == $last );\n   my @mutations;\n   for( my $j = 0; $j < $nummut; $j++)  {\n       my $index = int(rand($branchlen));\n       my $branch = $branches[$index];\n\n       # We're using an infinite sites model so every new\n       # mutation is a new site\n       my $g = Bio::PopGen::Genotype->new(-marker_name  => \"Mutation$j\",\n\t\t\t\t\t -alleles => [1]);\n       $nodes[$branch]->add_Genotype($g);\n       push @mutations, \"Mutation$j\";\n       # Let's add this mutation to all the children (push it down\n       # the branches to the tips)\n       foreach my $child ( $nodes[$branch]->get_all_Descendents ) {\n\t   $child->add_Genotype($g);\n       }\n   }\n   # Insure that everyone who doesn't have the mutation\n   # has the ancestral state, which is '0'\n   foreach my $node ( @nodes ) {\n       foreach my $m ( @mutations ) {\n\t   if( ! $node->has_Marker($m) ) {\n\t       my $emptyg = Bio::PopGen::Genotype->new(-marker_name => $m,\n\t\t\t\t\t\t      -alleles     => [0]);\n\t       $node->add_Genotype($emptyg);\n\t   }\n       }\n   }\n}\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)\n\n\n\nsub maxcount{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( $value =~ /^(\\d+)/ ) { \n\t   $self->{'maxcount'} = $1;\n       } else { \n\t   $self->warn(\"Must specify a valid Positive integer to maxcount\");\n\t   $self->{'maxcount'} = 0;\n       }\n  }\n   return $self->{'_maxcount'};\n}\n\n=head2 samples\n\n Title   : samples\n Usage   : $obj->samples($newval)\n Function: \n Example : \n Returns : value of samples\n Args    : newvalue (optional)\n\n\n\nsub samples{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( ref($value) !~ /ARRAY/i ) { \n\t   $self->warn(\"Must specify a valid array ref to the method 'samples'\");\n\t   $value = [];\n       } \n      $self->{'samples'} = $value;\n    }\n    return $self->{'samples'};\n\n}\n\n=head2 sample_size\n\n Title   : sample_size\n Usage   : $obj->sample_size($newval)\n Function: \n Example : \n Returns : value of sample_size\n Args    : newvalue (optional)\n\n\n\nsub sample_size{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'sample_size'} = $value;\n    }\n    return $self->{'sample_size'};\n\n}\n\n=head2 random\n\n Title   : random\n Usage   : my $rfloat = $node->random($size)\n Function: Generates a random number between 0 and $size\n           This is abstracted so that someone can override and provide their\n           own special RNG.  This is expected to be a uniform RNG.\n Returns : Floating point random\n Args    : $maximum size for random number (defaults to 1)","parameters":[{"label":"$self"},{"label":"$max"}]},"containerName":"main::","definition":"sub"}],"version":5}