{"vars":[{"kind":2,"line":85,"containerName":"","name":"base"},{"detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: PopStats.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::PopStats\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::PopStats - A collection of methods for calculating\nstatistics about a population or sets of populations\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::PopStats;\n  my $stats = Bio::PopGen::PopStats->new(); # add -haploid => 1 \n                                           # to process haploid data\n\n=head1 DESCRIPTION\n\nCalculate various population structure statistics, most notably Wright's Fst.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::PopStats;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::PopStats->new();\n Function: Builds a new Bio::PopGen::PopStats object \n Returns : an instance of Bio::PopGen::PopStats\n Args    : -haploid => 1 (if want to use haploid calculations)","label":"new($class,@args)"},"containerName":"main::","definition":"sub","line":98,"children":[{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":99},{"containerName":"new","name":"@args","line":99,"kind":13},{"line":101,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"line":101,"kind":13,"containerName":"new","name":"$class"},{"containerName":"new","name":"@args","kind":13,"line":101},{"containerName":"new","definition":"my","name":"$haploid","localvar":"my","kind":13,"line":102},{"name":"$self","containerName":"new","line":102,"kind":13},{"line":102,"kind":12,"containerName":"new","name":"_rearrange"},{"line":102,"kind":13,"name":"@args","containerName":"new"},{"name":"$haploid","containerName":"new","kind":13,"line":103},{"containerName":"new","name":"$self","line":103,"kind":13},{"name":"haploid_status","containerName":"new","line":103,"kind":12},{"containerName":"new","name":"$self","kind":13,"line":104}],"kind":12,"range":{"start":{"character":0,"line":98},"end":{"character":9999,"line":105}},"name":"new"},{"containerName":"new","name":"SUPER","line":101,"kind":12},{"line":120,"children":[{"line":121,"kind":13,"localvar":"my","containerName":"haploid_status","definition":"my","name":"$self"},{"name":"$self","containerName":"haploid_status","line":122,"kind":13},{"line":123,"kind":13,"containerName":"haploid_status","name":"$self"}],"kind":12,"range":{"end":{"line":124,"character":9999},"start":{"character":0,"line":120}},"containerName":"main::","name":"haploid_status","definition":"sub"},{"range":{"start":{"line":144,"character":0},"end":{"character":9999,"line":287}},"name":"Fst","children":[{"localvar":"my","containerName":"Fst","name":"$self","definition":"my","line":145,"kind":13},{"line":145,"kind":13,"containerName":"Fst","name":"$populations"},{"line":145,"kind":13,"containerName":"Fst","name":"$markernames"},{"kind":13,"line":147,"containerName":"Fst","name":"$populations"},{"name":"$populations","containerName":"Fst","line":148,"kind":13},{"name":"$self","containerName":"Fst","kind":13,"line":149},{"containerName":"Fst","name":"warn","line":149,"kind":12},{"line":151,"kind":13,"name":"$markernames","containerName":"Fst"},{"name":"$markernames","containerName":"Fst","kind":13,"line":152},{"name":"$self","containerName":"Fst","kind":13,"line":153},{"containerName":"Fst","name":"warn","kind":12,"line":153},{"localvar":"my","definition":"my","name":"$num_sub_pops","containerName":"Fst","line":156,"kind":13},{"name":"$populations","containerName":"Fst","kind":13,"line":156},{"containerName":"Fst","name":"$num_sub_pops","kind":13,"line":158},{"kind":13,"line":159,"name":"$self","containerName":"Fst"},{"line":159,"kind":12,"name":"warn","containerName":"Fst"},{"name":"$Fst","definition":"my","containerName":"Fst","localvar":"my","kind":13,"line":166},{"name":"$TS_sub1","definition":"my","containerName":"Fst","localvar":"my","kind":13,"line":167},{"kind":13,"line":167,"name":"$TS_sub2","containerName":"Fst"},{"line":169,"kind":13,"localvar":"my","name":"$marker","definition":"my","containerName":"Fst"},{"name":"$markernames","containerName":"Fst","kind":13,"line":169},{"containerName":"Fst","name":"%allAlleles","definition":"my","localvar":"my","kind":13,"line":171},{"kind":13,"line":172,"name":"$allele","definition":"my","containerName":"Fst","localvar":"my"},{"kind":12,"line":172,"containerName":"Fst","name":"get_Alleles"},{"kind":12,"line":173,"name":"get_Genotypes","containerName":"Fst"},{"containerName":"Fst","name":"$marker","kind":13,"line":173},{"name":"$populations","containerName":"Fst","kind":13,"line":173},{"name":"$allAlleles","containerName":"Fst","kind":13,"line":174},{"name":"$allele","containerName":"Fst","kind":13,"line":174},{"kind":13,"line":176,"name":"@alleles","definition":"my","containerName":"Fst","localvar":"my"},{"line":176,"kind":13,"name":"%allAlleles","containerName":"Fst"},{"line":178,"kind":13,"localvar":"my","name":"$allele_name","definition":"my","containerName":"Fst"},{"kind":13,"line":178,"containerName":"Fst","name":"@alleles"},{"containerName":"Fst","name":"$avg_samp_size","definition":"my","localvar":"my","kind":13,"line":179},{"line":180,"kind":13,"localvar":"my","name":"$avg_allele_freq","definition":"my","containerName":"Fst"},{"containerName":"Fst","definition":"my","name":"$total_samples_squared","localvar":"my","kind":13,"line":182},{"localvar":"my","containerName":"Fst","name":"$sum_heterozygote","definition":"my","line":183,"kind":13},{"localvar":"my","definition":"my","name":"@marker_freqs","containerName":"Fst","line":185,"kind":13},{"definition":"my","name":"$pop","containerName":"Fst","localvar":"my","kind":13,"line":191},{"containerName":"Fst","name":"$populations","kind":13,"line":191},{"kind":13,"line":192,"name":"$s","definition":"my","containerName":"Fst","localvar":"my"},{"kind":13,"line":192,"name":"$pop","containerName":"Fst"},{"kind":12,"line":192,"containerName":"Fst","name":"get_number_individuals"},{"line":192,"kind":13,"containerName":"Fst","name":"$marker"},{"name":"$avg_samp_size","containerName":"Fst","line":194,"kind":13},{"name":"$s","containerName":"Fst","line":194,"kind":13},{"line":195,"kind":13,"containerName":"Fst","name":"$total_samples_squared"},{"name":"$s","containerName":"Fst","line":195,"kind":13},{"kind":13,"line":197,"name":"$markerobj","definition":"my","containerName":"Fst","localvar":"my"},{"containerName":"Fst","name":"$pop","kind":13,"line":197},{"containerName":"Fst","name":"get_Marker","kind":12,"line":197},{"kind":13,"line":197,"name":"$marker","containerName":"Fst"},{"containerName":"Fst","name":"$markerobj","line":198,"kind":13},{"name":"$self","containerName":"Fst","line":199,"kind":13},{"kind":12,"line":199,"name":"warn","containerName":"Fst"},{"line":200,"kind":13,"name":"$pop","containerName":"Fst"},{"kind":12,"line":200,"name":"name","containerName":"Fst"},{"localvar":"my","containerName":"Fst","definition":"my","name":"$freq_homozygotes","line":204,"kind":13},{"name":"$pop","containerName":"Fst","line":205,"kind":13},{"name":"get_Frequency_Homozygotes","containerName":"Fst","line":205,"kind":12},{"containerName":"Fst","name":"$marker","line":205,"kind":13},{"kind":13,"line":205,"name":"$allele_name","containerName":"Fst"},{"containerName":"Fst","name":"%af","definition":"my","localvar":"my","kind":13,"line":206},{"name":"$markerobj","containerName":"Fst","line":206,"kind":13},{"line":206,"kind":12,"containerName":"Fst","name":"get_Allele_Frequencies"},{"kind":13,"line":207,"containerName":"Fst","name":"$all_freq","definition":"my","localvar":"my"},{"containerName":"Fst","name":"$af","kind":13,"line":207},{"kind":13,"line":207,"name":"$allele_name","containerName":"Fst"},{"kind":13,"line":209,"name":"$avg_allele_freq","containerName":"Fst"},{"containerName":"Fst","name":"$s","kind":13,"line":209},{"kind":13,"line":209,"containerName":"Fst","name":"$all_freq"},{"line":210,"kind":13,"name":"$sum_heterozygote","containerName":"Fst"},{"line":210,"kind":13,"containerName":"Fst","name":"$s"},{"line":210,"kind":13,"containerName":"Fst","name":"$all_freq"},{"kind":13,"line":210,"containerName":"Fst","name":"$freq_homozygotes"},{"kind":13,"line":212,"containerName":"Fst","name":"@marker_freqs"},{"kind":13,"line":212,"containerName":"Fst","name":"%af"},{"line":214,"kind":13,"localvar":"my","name":"$total_samples","definition":"my","containerName":"Fst"},{"line":214,"kind":13,"name":"$avg_samp_size","containerName":"Fst"},{"kind":13,"line":215,"containerName":"Fst","name":"$avg_samp_size"},{"line":215,"kind":13,"containerName":"Fst","name":"$num_sub_pops"},{"name":"$avg_allele_freq","containerName":"Fst","kind":13,"line":216},{"line":216,"kind":13,"name":"$total_samples","containerName":"Fst"},{"line":219,"kind":13,"localvar":"my","containerName":"Fst","name":"$adj_samp_size","definition":"my"},{"line":219,"kind":13,"name":"$num_sub_pops","containerName":"Fst"},{"kind":13,"line":220,"name":"$total_samples","containerName":"Fst"},{"containerName":"Fst","name":"$total_samples_squared","kind":13,"line":220},{"kind":13,"line":220,"name":"$total_samples","containerName":"Fst"},{"kind":13,"line":222,"definition":"my","name":"$variance","containerName":"Fst","localvar":"my"},{"localvar":"my","containerName":"Fst","name":"$sum_variance","definition":"my","line":223,"kind":13},{"containerName":"Fst","definition":"my","name":"$i","localvar":"my","kind":13,"line":224},{"localvar":"my","name":"$pop","definition":"my","containerName":"Fst","line":225,"kind":13},{"containerName":"Fst","name":"$populations","line":225,"kind":13},{"name":"$s","definition":"my","containerName":"Fst","localvar":"my","kind":13,"line":226},{"containerName":"Fst","name":"$pop","line":226,"kind":13},{"line":226,"kind":12,"containerName":"Fst","name":"get_number_individuals"},{"kind":13,"line":226,"name":"$marker","containerName":"Fst"},{"line":227,"kind":13,"localvar":"my","name":"%af","definition":"my","containerName":"Fst"},{"containerName":"Fst","name":"$marker_freqs","line":227,"kind":13},{"line":227,"kind":13,"name":"$i","containerName":"Fst"},{"name":"$sum_variance","containerName":"Fst","kind":13,"line":228},{"line":228,"kind":13,"containerName":"Fst","name":"$s"},{"containerName":"Fst","name":"$af","kind":13,"line":228},{"kind":13,"line":228,"name":"$allele_name","containerName":"Fst"},{"containerName":"Fst","name":"$avg_allele_freq","kind":13,"line":229},{"containerName":"Fst","name":"$variance","line":231,"kind":13},{"line":231,"kind":13,"containerName":"Fst","name":"$num_sub_pops"},{"line":231,"kind":13,"containerName":"Fst","name":"$avg_samp_size"},{"line":231,"kind":13,"containerName":"Fst","name":"$sum_variance"},{"definition":"my","name":"$freq_heterozygote","containerName":"Fst","localvar":"my","kind":13,"line":234},{"kind":13,"line":234,"containerName":"Fst","name":"$sum_heterozygote"},{"containerName":"Fst","name":"$total_samples","line":234,"kind":13},{"name":"$self","containerName":"Fst","kind":13,"line":236},{"kind":12,"line":236,"name":"haploid_status","containerName":"Fst"},{"localvar":"my","containerName":"Fst","name":"$T_sub1","definition":"my","line":239,"kind":13},{"line":239,"kind":13,"name":"$variance","containerName":"Fst"},{"name":"$avg_samp_size","containerName":"Fst","line":240,"kind":13},{"containerName":"Fst","name":"$avg_allele_freq","kind":13,"line":241},{"line":241,"kind":13,"containerName":"Fst","name":"$avg_allele_freq"},{"kind":13,"line":242,"containerName":"Fst","name":"$num_sub_pops"},{"name":"$num_sub_pops","containerName":"Fst","line":242,"kind":13},{"containerName":"Fst","name":"$variance","kind":13,"line":242},{"name":"$T_sub2","definition":"my","containerName":"Fst","localvar":"my","kind":13,"line":243},{"name":"$adj_samp_size","containerName":"Fst","kind":13,"line":243},{"line":243,"kind":13,"containerName":"Fst","name":"$avg_samp_size"},{"name":"$avg_allele_freq","containerName":"Fst","kind":13,"line":244},{"line":244,"kind":13,"containerName":"Fst","name":"$avg_allele_freq"},{"name":"$num_sub_pops","containerName":"Fst","line":245,"kind":13},{"line":246,"kind":13,"containerName":"Fst","name":"$avg_samp_size"},{"line":246,"kind":13,"name":"$adj_samp_size","containerName":"Fst"},{"name":"$avg_samp_size","containerName":"Fst","kind":13,"line":247},{"kind":13,"line":248,"name":"$variance","containerName":"Fst"},{"name":"$num_sub_pops","containerName":"Fst","line":248,"kind":13},{"line":255,"kind":13,"containerName":"Fst","name":"$TS_sub1"},{"line":255,"kind":13,"containerName":"Fst","name":"$T_sub1"},{"name":"$TS_sub2","containerName":"Fst","kind":13,"line":256},{"line":256,"kind":13,"name":"$T_sub2","containerName":"Fst"},{"kind":13,"line":259,"name":"$S_sub1","definition":"my","containerName":"Fst","localvar":"my"},{"name":"$variance","containerName":"Fst","line":259,"kind":13},{"name":"$avg_samp_size","containerName":"Fst","line":259,"kind":13},{"containerName":"Fst","name":"$avg_allele_freq","line":260,"kind":13},{"line":261,"kind":13,"containerName":"Fst","name":"$avg_allele_freq"},{"kind":13,"line":262,"containerName":"Fst","name":"$num_sub_pops"},{"containerName":"Fst","name":"$num_sub_pops","line":262,"kind":13},{"line":263,"kind":13,"containerName":"Fst","name":"$variance"},{"name":"$freq_heterozygote","containerName":"Fst","line":263,"kind":13},{"line":264,"kind":13,"localvar":"my","containerName":"Fst","name":"$S_sub2","definition":"my"},{"line":264,"kind":13,"containerName":"Fst","name":"$avg_allele_freq"},{"line":264,"kind":13,"name":"$avg_allele_freq","containerName":"Fst"},{"kind":13,"line":265,"containerName":"Fst","name":"$avg_samp_size"},{"name":"$num_sub_pops","containerName":"Fst","kind":13,"line":265},{"containerName":"Fst","name":"$avg_samp_size","line":265,"kind":13},{"name":"$num_sub_pops","containerName":"Fst","line":266,"kind":13},{"kind":13,"line":266,"name":"$avg_samp_size","containerName":"Fst"},{"name":"$adj_samp_size","containerName":"Fst","kind":13,"line":266},{"containerName":"Fst","name":"$avg_samp_size","line":267,"kind":13},{"containerName":"Fst","name":"$avg_allele_freq","line":267,"kind":13},{"containerName":"Fst","name":"$avg_allele_freq","kind":13,"line":268},{"name":"$avg_samp_size","containerName":"Fst","kind":13,"line":269},{"line":269,"kind":13,"containerName":"Fst","name":"$avg_samp_size"},{"name":"$num_sub_pops","containerName":"Fst","line":270,"kind":13},{"line":271,"kind":13,"name":"$avg_samp_size","containerName":"Fst"},{"name":"$adj_samp_size","containerName":"Fst","kind":13,"line":272},{"kind":13,"line":272,"containerName":"Fst","name":"$variance"},{"name":"$num_sub_pops","containerName":"Fst","kind":13,"line":273},{"line":273,"kind":13,"name":"$avg_samp_size","containerName":"Fst"},{"name":"$adj_samp_size","containerName":"Fst","kind":13,"line":273},{"line":274,"kind":13,"name":"$avg_samp_size","containerName":"Fst"},{"name":"$adj_samp_size","containerName":"Fst","kind":13,"line":274},{"name":"$freq_heterozygote","containerName":"Fst","line":275,"kind":13},{"containerName":"Fst","name":"$S_sub3","definition":"my","localvar":"my","kind":13,"line":277},{"kind":13,"line":277,"name":"$adj_samp_size","containerName":"Fst"},{"line":277,"kind":13,"containerName":"Fst","name":"$avg_samp_size"},{"name":"$freq_heterozygote","containerName":"Fst","kind":13,"line":278},{"containerName":"Fst","name":"$TS_sub1","kind":13,"line":283},{"containerName":"Fst","name":"$S_sub1","kind":13,"line":283},{"line":284,"kind":13,"containerName":"Fst","name":"$TS_sub2"},{"name":"$S_sub2","containerName":"Fst","kind":13,"line":284}],"line":144,"kind":12,"signature":{"label":"Fst($self,$populations,$markernames)","documentation":"1;\n# $Id: PopStats.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::PopStats\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::PopStats - A collection of methods for calculating\nstatistics about a population or sets of populations\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::PopStats;\n  my $stats = Bio::PopGen::PopStats->new(); # add -haploid => 1 \n                                           # to process haploid data\n\n=head1 DESCRIPTION\n\nCalculate various population structure statistics, most notably Wright's Fst.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::PopStats;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::PopStats->new();\n Function: Builds a new Bio::PopGen::PopStats object \n Returns : an instance of Bio::PopGen::PopStats\n Args    : -haploid => 1 (if want to use haploid calculations)\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($haploid) = $self->_rearrange([qw(HAPLOID)],@args);\n  if( $haploid ) { $self->haploid_status(1) }\n  return $self;\n}\n\n\n=head2 haploid_status\n\n Title   : haploid_status\n Usage   : $obj->haploid_status($newval)\n Function: Boolean value for whether or not to do haploid \n           or diploid calculations, where appropriate\n Returns : Boolean\n Args    : on set, new boolean value optional)\n\n\n\nsub haploid_status{\n    my $self = shift;\n    return $self->{'haploid_status'} = shift if @_;\n    return $self->{'haploid_status'};\n}\n\n\n# Implementation provided my Matthew Hahn, massaged by Jason Stajich\n\n=head2 Fst\n\n Title   : Fst\n Usage   : my $fst = $stats->Fst(\\@populations,\\@markernames)\n Function: Calculate Wright's Fst based on a set of sub-populations\n           and specific markers\n Returns : Fst value (a value between 0 and 1)\n Args    : Arrayref of populations to process\n           Arrayref of marker names to process\n Note    : Based on diploid method in Weir BS, Genetics Data Analysis II, 1996\n           page 178.\n\n' make emacs happy here","parameters":[{"label":"$self"},{"label":"$populations"},{"label":"$markernames"}]},"detail":"($self,$populations,$markernames)","definition":"sub","containerName":"main::"},{"containerName":null,"name":"$Fst","kind":13,"line":291},{"name":"$TS_sub1","containerName":null,"line":291,"kind":13},{"kind":13,"line":291,"name":"$TS_sub2","containerName":null},{"name":"$Fst","containerName":null,"kind":13,"line":293}],"version":5}