{"version":5,"vars":[{"containerName":"","name":"vars","kind":2,"line":90},{"kind":13,"line":92,"name":"$UniqueCounter","containerName":null},{"line":94,"kind":2,"containerName":"","name":"base"},{"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Marker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Marker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Marker - A genetic marker which one uses to generate genotypes\n\n=head1 SYNOPSIS\n\n  my $name = $marker->name();            # marker name\n  my $description = $marker->description(); # description\n  my $type = $marker->type();            # coded type of the marker\n  my $unique_id = $marker->unique_id;    # optional unique ID\n  my @alleles = $marker->get_Alleles();  # the known alleles\n  my %allele_freqs = $marker->get_Allele_Frequencies(); # keys are marker names\n                                         # vals are frequencies\n                                         # may change to handle multiple populations\n\n=head1 DESCRIPTION\n\nThis object will not contain genotype information pertaining to an\nindividual, but rather population level statistics and descriptive\ninformation about a marker.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Marker;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse vars qw($UniqueCounter);\n\n$UniqueCounter = 0;\n\nuse base qw(Bio::Root::Root Bio::PopGen::MarkerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Marker->new();\n Function: Builds a new Bio::PopGen::Marker object \n Returns : an instance of Bio::PopGen::Marker\n Args    : -name          => [string] marker name\n           -description   => [string] marker description\n           -type          => [string] marker type\n           -unique_id     => [string/int] unique id\n           -allele_freq   => [hash ref] allele frequencies "},"detail":"($class,@args)","kind":12,"children":[{"line":111,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"new"},{"kind":13,"line":111,"name":"@args","containerName":"new"},{"localvar":"my","name":"$self","definition":"my","containerName":"new","line":113,"kind":13},{"kind":13,"line":113,"containerName":"new","name":"$class"},{"name":"@args","containerName":"new","kind":13,"line":113},{"containerName":"new","name":"$name","definition":"my","localvar":"my","kind":13,"line":114},{"line":114,"kind":13,"name":"$desc","containerName":"new"},{"name":"$type","containerName":"new","kind":13,"line":114},{"kind":13,"line":114,"name":"$uid","containerName":"new"},{"line":114,"kind":13,"name":"$af","containerName":"new"},{"line":114,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"_rearrange","line":114,"kind":12},{"containerName":"new","name":"@args","kind":13,"line":118},{"kind":13,"line":119,"name":"$self","containerName":"new"},{"kind":13,"line":120,"name":"$uid","containerName":"new"},{"name":"$uid","containerName":"new","kind":13,"line":121},{"kind":13,"line":121,"name":"$UniqueCounter","containerName":"new"},{"kind":13,"line":123,"name":"$name","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":124},{"kind":12,"line":124,"containerName":"new","name":"name"},{"kind":13,"line":124,"containerName":"new","name":"$name"},{"containerName":"new","name":"$self","kind":13,"line":126},{"name":"throw","containerName":"new","kind":12,"line":126},{"line":128,"kind":13,"name":"$desc","containerName":"new"},{"name":"$self","containerName":"new","line":128,"kind":13},{"name":"description","containerName":"new","kind":12,"line":128},{"containerName":"new","name":"$desc","kind":13,"line":128},{"line":129,"kind":13,"containerName":"new","name":"$type"},{"kind":13,"line":129,"containerName":"new","name":"$self"},{"kind":12,"line":129,"name":"type","containerName":"new"},{"name":"$type","containerName":"new","kind":13,"line":129},{"containerName":"new","name":"$self","line":130,"kind":13},{"kind":12,"line":130,"name":"unique_id","containerName":"new"},{"containerName":"new","name":"$uid","line":130,"kind":13},{"kind":13,"line":131,"name":"$af","containerName":"new"},{"kind":13,"line":132,"name":"$af","containerName":"new"},{"containerName":"new","name":"$self","line":133,"kind":13},{"containerName":"new","name":"warn","kind":12,"line":133},{"containerName":"new","name":"$allele","definition":"my","localvar":"my","kind":13,"line":135},{"kind":13,"line":135,"containerName":"new","name":"$af"},{"line":136,"kind":13,"name":"$self","containerName":"new"},{"name":"add_Allele_Frequency","containerName":"new","line":136,"kind":12},{"containerName":"new","name":"$allele","kind":13,"line":136},{"line":136,"kind":13,"name":"$af","containerName":"new"},{"kind":13,"line":136,"containerName":"new","name":"$allele"},{"name":"$self","containerName":"new","line":140,"kind":13}],"line":110,"name":"new","range":{"end":{"line":141,"character":9999},"start":{"line":110,"character":0}}},{"name":"SUPER","containerName":"new","kind":12,"line":113},{"containerName":"main::","definition":"sub","name":"name","range":{"start":{"line":154,"character":0},"end":{"line":159,"character":9999}},"kind":12,"line":154,"children":[{"kind":13,"line":155,"name":"$self","definition":"my","containerName":"name","localvar":"my"},{"name":"$self","containerName":"name","kind":13,"line":157},{"containerName":"name","name":"$self","line":158,"kind":13}]},{"children":[{"localvar":"my","containerName":"description","definition":"my","name":"$self","line":174,"kind":13},{"name":"$self","containerName":"description","line":176,"kind":13},{"line":177,"kind":13,"name":"$self","containerName":"description"}],"line":173,"kind":12,"range":{"start":{"character":0,"line":173},"end":{"line":178,"character":9999}},"name":"description","definition":"sub","containerName":"main::"},{"kind":12,"children":[{"kind":13,"line":192,"containerName":"type","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"type","line":194,"kind":13},{"line":195,"kind":13,"name":"$self","containerName":"type"}],"line":191,"definition":"sub","name":"type","containerName":"main::","range":{"start":{"character":0,"line":191},"end":{"line":196,"character":9999}}},{"line":210,"children":[{"localvar":"my","containerName":"unique_id","definition":"my","name":"$self","line":211,"kind":13},{"name":"$self","containerName":"unique_id","line":213,"kind":13},{"name":"$self","containerName":"unique_id","line":214,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":210},"end":{"character":9999,"line":215}},"containerName":"main::","name":"unique_id","definition":"sub"},{"kind":12,"children":[{"line":229,"kind":13,"localvar":"my","containerName":"annotation","name":"$self","definition":"my"},{"name":"$arg","containerName":"annotation","kind":13,"line":229},{"kind":13,"line":230,"containerName":"annotation","name":"$self"},{"line":230,"kind":13,"name":"$arg","containerName":"annotation"},{"line":231,"kind":13,"name":"$self","containerName":"annotation"},{"name":"throw","containerName":"annotation","line":231,"kind":12},{"line":232,"kind":13,"containerName":"annotation","name":"$arg"},{"kind":13,"line":232,"name":"$arg","containerName":"annotation"},{"name":"isa","containerName":"annotation","kind":12,"line":232},{"containerName":"annotation","name":"$self","line":233,"kind":13},{"line":233,"kind":13,"name":"$arg","containerName":"annotation"}],"line":228,"definition":"sub","containerName":"main::","signature":{"label":"annotation($self,$arg)","documentation":"1;\n# $Id: Marker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Marker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Marker - A genetic marker which one uses to generate genotypes\n\n=head1 SYNOPSIS\n\n  my $name = $marker->name();            # marker name\n  my $description = $marker->description(); # description\n  my $type = $marker->type();            # coded type of the marker\n  my $unique_id = $marker->unique_id;    # optional unique ID\n  my @alleles = $marker->get_Alleles();  # the known alleles\n  my %allele_freqs = $marker->get_Allele_Frequencies(); # keys are marker names\n                                         # vals are frequencies\n                                         # may change to handle multiple populations\n\n=head1 DESCRIPTION\n\nThis object will not contain genotype information pertaining to an\nindividual, but rather population level statistics and descriptive\ninformation about a marker.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Marker;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse vars qw($UniqueCounter);\n\n$UniqueCounter = 0;\n\nuse base qw(Bio::Root::Root Bio::PopGen::MarkerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Marker->new();\n Function: Builds a new Bio::PopGen::Marker object \n Returns : an instance of Bio::PopGen::Marker\n Args    : -name          => [string] marker name\n           -description   => [string] marker description\n           -type          => [string] marker type\n           -unique_id     => [string/int] unique id\n           -allele_freq   => [hash ref] allele frequencies \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($name,$desc,$type,$uid,$af) = $self->_rearrange([qw(NAME\n\t\t\t\t\t\t\t  DESCRIPTION\n\t\t\t\t\t\t\t  TYPE\n\t\t\t\t\t\t\t  UNIQUE_ID\n\t\t\t\t\t\t\t  ALLELE_FREQ)],@args);\n  $self->{'_allele_freqs'} = {};\n  if( ! defined $uid ) {\n      $uid = $UniqueCounter++;\n  }\n  if( defined $name) {\n      $self->name($name);\n  } else { \n      $self->throw(\"Must provide a name when initializing a Marker\");\n  }\n  defined $desc && $self->description($desc);\n  defined $type && $self->type($type);\n  $self->unique_id($uid);\n  if( defined $af) {\n      if( ref($af) !~ /HASH/i ) {\n\t  $self->warn(\"Must provide valid Hash reference for allele_freq method\");\n      } else { \n\t  foreach my $allele ( keys %$af ) {\n\t      $self->add_Allele_Frequency($allele, $af->{$allele});\n\t  }\n      }\n  }\n  return $self;\n}\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $marker->name();\n Function: Get the name of the marker\n Returns : string representing the name of the marker\n Args    : [optional] name\n\n\n\nsub name{\n    my $self = shift;\n\n    return $self->{'_name'} = shift if @_;\n    return $self->{'_name'};\n}\n\n\n=head2 description\n\n Title   : description\n Usage   : my $desc = $marker->description\n Function: Get the marker description free text\n Returns : string\n Args    : [optional] string\n\n\n\nsub description{\n    my $self = shift;\n\n    return $self->{'_description'} = shift if @_;\n    return $self->{'_description'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $marker->type;\n Function: Get coded string for marker type\n Returns : string\n Args    : [optional] string\n\n\n\nsub type{\n    my $self = shift;\n\n    return $self->{'_type'} = shift if @_;\n    return $self->{'_type'};\n}\n\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $marker->unique_id;\n Function: Get the unique marker ID\n Returns : unique ID string\n Args    : [optional ] string\n\n\n\nsub unique_id{\n    my $self = shift;\n\n    return $self->{'_uniqueid'} = shift if @_;\n    return $self->{'_uniqueid'};\n}\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $marker->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this marker\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object","parameters":[{"label":"$self"},{"label":"$arg"}]},"detail":"($self,$arg)","name":"annotation","range":{"end":{"character":9999,"line":234},"start":{"line":228,"character":0}}},{"kind":12,"line":230,"name":"_annotation"},{"line":233,"kind":12,"name":"_annotation"},{"range":{"end":{"line":250,"character":9999},"start":{"character":0,"line":246}},"name":"get_Alleles","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"get_Alleles","localvar":"my","kind":13,"line":247},{"kind":13,"line":248,"name":"@numeric","definition":"my","containerName":"get_Alleles","localvar":"my"},{"line":248,"kind":13,"containerName":"get_Alleles","name":"@alpha"},{"line":250,"kind":13,"name":"$self","containerName":"get_Alleles"}],"line":246,"kind":12},{"line":251,"kind":13,"name":"@alpha","containerName":null},{"kind":13,"line":252,"name":"@numeric","containerName":null},{"kind":13,"line":254,"containerName":null,"name":"@numeric"},{"containerName":null,"name":"$b","line":254,"kind":13},{"kind":13,"line":254,"containerName":null,"name":"$a"},{"name":"@numeric","containerName":null,"line":254,"kind":13},{"kind":13,"line":255,"name":"@alpha","containerName":null},{"name":"$b","containerName":null,"line":255,"kind":13},{"kind":13,"line":255,"name":"$a","containerName":null},{"line":255,"kind":13,"containerName":null,"name":"@alpha"},{"containerName":null,"name":"@numeric","line":256,"kind":13},{"kind":13,"line":256,"containerName":null,"name":"@alpha"},{"range":{"start":{"line":274,"character":0},"end":{"character":9999,"line":275}},"name":"get_Allele_Frequencies","definition":"sub","containerName":"main::","children":[],"line":274,"kind":12},{"range":{"end":{"line":293,"character":9999},"start":{"character":0,"line":290}},"name":"add_Allele_Frequency","detail":"($self,$allele,$freq)","signature":{"label":"add_Allele_Frequency($self,$allele,$freq)","documentation":"1;\n# $Id: Marker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Marker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Marker - A genetic marker which one uses to generate genotypes\n\n=head1 SYNOPSIS\n\n  my $name = $marker->name();            # marker name\n  my $description = $marker->description(); # description\n  my $type = $marker->type();            # coded type of the marker\n  my $unique_id = $marker->unique_id;    # optional unique ID\n  my @alleles = $marker->get_Alleles();  # the known alleles\n  my %allele_freqs = $marker->get_Allele_Frequencies(); # keys are marker names\n                                         # vals are frequencies\n                                         # may change to handle multiple populations\n\n=head1 DESCRIPTION\n\nThis object will not contain genotype information pertaining to an\nindividual, but rather population level statistics and descriptive\ninformation about a marker.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Marker;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse vars qw($UniqueCounter);\n\n$UniqueCounter = 0;\n\nuse base qw(Bio::Root::Root Bio::PopGen::MarkerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Marker->new();\n Function: Builds a new Bio::PopGen::Marker object \n Returns : an instance of Bio::PopGen::Marker\n Args    : -name          => [string] marker name\n           -description   => [string] marker description\n           -type          => [string] marker type\n           -unique_id     => [string/int] unique id\n           -allele_freq   => [hash ref] allele frequencies \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($name,$desc,$type,$uid,$af) = $self->_rearrange([qw(NAME\n\t\t\t\t\t\t\t  DESCRIPTION\n\t\t\t\t\t\t\t  TYPE\n\t\t\t\t\t\t\t  UNIQUE_ID\n\t\t\t\t\t\t\t  ALLELE_FREQ)],@args);\n  $self->{'_allele_freqs'} = {};\n  if( ! defined $uid ) {\n      $uid = $UniqueCounter++;\n  }\n  if( defined $name) {\n      $self->name($name);\n  } else { \n      $self->throw(\"Must provide a name when initializing a Marker\");\n  }\n  defined $desc && $self->description($desc);\n  defined $type && $self->type($type);\n  $self->unique_id($uid);\n  if( defined $af) {\n      if( ref($af) !~ /HASH/i ) {\n\t  $self->warn(\"Must provide valid Hash reference for allele_freq method\");\n      } else { \n\t  foreach my $allele ( keys %$af ) {\n\t      $self->add_Allele_Frequency($allele, $af->{$allele});\n\t  }\n      }\n  }\n  return $self;\n}\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $marker->name();\n Function: Get the name of the marker\n Returns : string representing the name of the marker\n Args    : [optional] name\n\n\n\nsub name{\n    my $self = shift;\n\n    return $self->{'_name'} = shift if @_;\n    return $self->{'_name'};\n}\n\n\n=head2 description\n\n Title   : description\n Usage   : my $desc = $marker->description\n Function: Get the marker description free text\n Returns : string\n Args    : [optional] string\n\n\n\nsub description{\n    my $self = shift;\n\n    return $self->{'_description'} = shift if @_;\n    return $self->{'_description'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $marker->type;\n Function: Get coded string for marker type\n Returns : string\n Args    : [optional] string\n\n\n\nsub type{\n    my $self = shift;\n\n    return $self->{'_type'} = shift if @_;\n    return $self->{'_type'};\n}\n\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $marker->unique_id;\n Function: Get the unique marker ID\n Returns : unique ID string\n Args    : [optional ] string\n\n\n\nsub unique_id{\n    my $self = shift;\n\n    return $self->{'_uniqueid'} = shift if @_;\n    return $self->{'_uniqueid'};\n}\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $marker->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this marker\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 get_Alleles\n\n Title   : get_Alleles\n Usage   : my @alleles = $marker->get_Alleles();\n Function: Get the available marker alleles\n Returns : Array of strings\n Args    : none\n\n\nsub get_Alleles{\n    my $self = shift;\n    my (@numeric,@alpha);\n\n    for ( keys %{$self->{'_allele_freqs'}} ) {\n\tif( /[^\\d\\.\\-e]/ ) { push @alpha, $_ }\n\telse { push @numeric, $_ }\n    }\n    @numeric = sort { $b <=> $a } @numeric;\n    @alpha   = sort { $b cmp $a } @alpha;\n    return @numeric,@alpha;\n}\n\n\n=head2 get_Allele_Frequencies\n\n Title   : get_Allele_Frequencies\n Usage   : my %allele_freqs = $marker->get_Allele_Frequencies;\n Function: Get the alleles and their frequency (set relative to\n           a given population - you may want to create different\n           markers with the same name for different populations\n           with this current implementation\n Returns : Associative array where keys are the names of the alleles\n Args    : none\n\n\n\nsub get_Allele_Frequencies{\n   return %{$_[0]->{'_allele_freqs'}};\n}\n\n=head2 add_Allele_Frequency\n\n Title   : add_Allele_Frequency\n Usage   : $marker->add_Allele_Frequency($allele,$freq)\n Function: Adds an allele frequency\n Returns : None\n Args    : $allele - allele name\n           $freq   - frequency value","parameters":[{"label":"$self"},{"label":"$allele"},{"label":"$freq"}]},"containerName":"main::","definition":"sub","line":290,"children":[{"kind":13,"line":291,"name":"$self","definition":"my","containerName":"add_Allele_Frequency","localvar":"my"},{"kind":13,"line":291,"name":"$allele","containerName":"add_Allele_Frequency"},{"name":"$freq","containerName":"add_Allele_Frequency","line":291,"kind":13},{"containerName":"add_Allele_Frequency","name":"$self","kind":13,"line":292},{"kind":13,"line":292,"containerName":"add_Allele_Frequency","name":"$allele"},{"name":"$freq","containerName":"add_Allele_Frequency","line":292,"kind":13}],"kind":12},{"name":"reset_alleles","range":{"start":{"line":306,"character":0},"end":{"line":309,"character":9999}},"kind":12,"line":306,"children":[{"containerName":"reset_alleles","name":"$self","definition":"my","localvar":"my","kind":13,"line":307},{"containerName":"reset_alleles","name":"$self","kind":13,"line":308}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"reset_alleles($self)","documentation":"1;\n# $Id: Marker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Marker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Marker - A genetic marker which one uses to generate genotypes\n\n=head1 SYNOPSIS\n\n  my $name = $marker->name();            # marker name\n  my $description = $marker->description(); # description\n  my $type = $marker->type();            # coded type of the marker\n  my $unique_id = $marker->unique_id;    # optional unique ID\n  my @alleles = $marker->get_Alleles();  # the known alleles\n  my %allele_freqs = $marker->get_Allele_Frequencies(); # keys are marker names\n                                         # vals are frequencies\n                                         # may change to handle multiple populations\n\n=head1 DESCRIPTION\n\nThis object will not contain genotype information pertaining to an\nindividual, but rather population level statistics and descriptive\ninformation about a marker.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Marker;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse vars qw($UniqueCounter);\n\n$UniqueCounter = 0;\n\nuse base qw(Bio::Root::Root Bio::PopGen::MarkerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Marker->new();\n Function: Builds a new Bio::PopGen::Marker object \n Returns : an instance of Bio::PopGen::Marker\n Args    : -name          => [string] marker name\n           -description   => [string] marker description\n           -type          => [string] marker type\n           -unique_id     => [string/int] unique id\n           -allele_freq   => [hash ref] allele frequencies \n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($name,$desc,$type,$uid,$af) = $self->_rearrange([qw(NAME\n\t\t\t\t\t\t\t  DESCRIPTION\n\t\t\t\t\t\t\t  TYPE\n\t\t\t\t\t\t\t  UNIQUE_ID\n\t\t\t\t\t\t\t  ALLELE_FREQ)],@args);\n  $self->{'_allele_freqs'} = {};\n  if( ! defined $uid ) {\n      $uid = $UniqueCounter++;\n  }\n  if( defined $name) {\n      $self->name($name);\n  } else { \n      $self->throw(\"Must provide a name when initializing a Marker\");\n  }\n  defined $desc && $self->description($desc);\n  defined $type && $self->type($type);\n  $self->unique_id($uid);\n  if( defined $af) {\n      if( ref($af) !~ /HASH/i ) {\n\t  $self->warn(\"Must provide valid Hash reference for allele_freq method\");\n      } else { \n\t  foreach my $allele ( keys %$af ) {\n\t      $self->add_Allele_Frequency($allele, $af->{$allele});\n\t  }\n      }\n  }\n  return $self;\n}\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $marker->name();\n Function: Get the name of the marker\n Returns : string representing the name of the marker\n Args    : [optional] name\n\n\n\nsub name{\n    my $self = shift;\n\n    return $self->{'_name'} = shift if @_;\n    return $self->{'_name'};\n}\n\n\n=head2 description\n\n Title   : description\n Usage   : my $desc = $marker->description\n Function: Get the marker description free text\n Returns : string\n Args    : [optional] string\n\n\n\nsub description{\n    my $self = shift;\n\n    return $self->{'_description'} = shift if @_;\n    return $self->{'_description'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $marker->type;\n Function: Get coded string for marker type\n Returns : string\n Args    : [optional] string\n\n\n\nsub type{\n    my $self = shift;\n\n    return $self->{'_type'} = shift if @_;\n    return $self->{'_type'};\n}\n\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $marker->unique_id;\n Function: Get the unique marker ID\n Returns : unique ID string\n Args    : [optional ] string\n\n\n\nsub unique_id{\n    my $self = shift;\n\n    return $self->{'_uniqueid'} = shift if @_;\n    return $self->{'_uniqueid'};\n}\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $marker->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this marker\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 get_Alleles\n\n Title   : get_Alleles\n Usage   : my @alleles = $marker->get_Alleles();\n Function: Get the available marker alleles\n Returns : Array of strings\n Args    : none\n\n\nsub get_Alleles{\n    my $self = shift;\n    my (@numeric,@alpha);\n\n    for ( keys %{$self->{'_allele_freqs'}} ) {\n\tif( /[^\\d\\.\\-e]/ ) { push @alpha, $_ }\n\telse { push @numeric, $_ }\n    }\n    @numeric = sort { $b <=> $a } @numeric;\n    @alpha   = sort { $b cmp $a } @alpha;\n    return @numeric,@alpha;\n}\n\n\n=head2 get_Allele_Frequencies\n\n Title   : get_Allele_Frequencies\n Usage   : my %allele_freqs = $marker->get_Allele_Frequencies;\n Function: Get the alleles and their frequency (set relative to\n           a given population - you may want to create different\n           markers with the same name for different populations\n           with this current implementation\n Returns : Associative array where keys are the names of the alleles\n Args    : none\n\n\n\nsub get_Allele_Frequencies{\n   return %{$_[0]->{'_allele_freqs'}};\n}\n\n=head2 add_Allele_Frequency\n\n Title   : add_Allele_Frequency\n Usage   : $marker->add_Allele_Frequency($allele,$freq)\n Function: Adds an allele frequency\n Returns : None\n Args    : $allele - allele name\n           $freq   - frequency value\n\n\n\nsub add_Allele_Frequency{\n   my ($self,$allele,$freq) = @_;\n   $self->{'_allele_freqs'}->{$allele} = $freq;\n}\n\n=head2 reset_alleles\n\n Title   : reset_alleles\n Usage   : $marker->reset_alleles();\n Function: Reset the alleles for a marker\n Returns : None\n Args    : None","parameters":[{"label":"$self"}]}}]}