{"version":5,"vars":[{"containerName":"","name":"vars","line":90,"kind":2},{"line":93,"kind":2,"name":"strict","containerName":""},{"kind":13,"line":93,"name":"$FieldDelim","containerName":null},{"kind":13,"line":93,"name":"$AlleleDelim","containerName":null},{"name":"$NoHeader","containerName":null,"kind":13,"line":93},{"name":"base","containerName":"","line":102,"kind":2},{"range":{"end":{"character":9999,"line":137},"start":{"character":0,"line":119}},"name":"_initialize","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: phase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::phase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::phase - A parser for Phase format data\n\n=head1 SYNOPSIS\n\n# Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'phase',\n                               -file   => 'data.phase');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing phase data.\n\nPHASE is defined in http://www.stat.washington.edu/stephens/instruct2.1.pdf\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::phase;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,","label":"_initialize($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":121,"definition":"my","name":"$self","containerName":"_initialize","localvar":"my"},{"name":"@args","containerName":"_initialize","kind":13,"line":121},{"containerName":"_initialize","name":"$Bio","kind":13,"line":123},{"line":125,"kind":13,"localvar":"my","containerName":"_initialize","definition":"my","name":"$fieldsep"},{"name":"$all_sep","containerName":"_initialize","line":125,"kind":13},{"containerName":"_initialize","name":"$noheader","kind":13,"line":126},{"kind":13,"line":126,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"_rearrange","kind":12,"line":126},{"line":128,"kind":13,"name":"@args","containerName":"_initialize"},{"name":"$self","containerName":"_initialize","kind":13,"line":130},{"name":"flag","containerName":"_initialize","line":130,"kind":12},{"kind":13,"line":130,"containerName":"_initialize","name":"$noheader"},{"name":"$noheader","containerName":"_initialize","line":130,"kind":13},{"line":130,"kind":13,"containerName":"_initialize","name":"$NoHeader"},{"containerName":"_initialize","name":"$self","kind":13,"line":131},{"name":"flag","containerName":"_initialize","line":131,"kind":12},{"containerName":"_initialize","name":"$fieldsep","line":131,"kind":13},{"name":"$fieldsep","containerName":"_initialize","kind":13,"line":131},{"containerName":"_initialize","name":"$FieldDelim","line":131,"kind":13},{"containerName":"_initialize","name":"$self","line":132,"kind":13},{"name":"flag","containerName":"_initialize","line":132,"kind":12},{"kind":13,"line":132,"name":"$all_sep","containerName":"_initialize"},{"name":"$all_sep","containerName":"_initialize","line":132,"kind":13},{"line":132,"kind":13,"containerName":"_initialize","name":"$AlleleDelim"},{"kind":13,"line":134,"containerName":"_initialize","name":"$self"}],"line":119,"kind":12},{"containerName":"Genotype::BlankAlleles","name":"PopGen","kind":12,"line":123},{"definition":"sub","name":"flag","containerName":"main::","range":{"end":{"line":161,"character":9999},"start":{"line":152,"character":0}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"flag","line":154,"kind":13},{"definition":"my","name":"$fieldname","containerName":"flag","localvar":"my","kind":13,"line":155},{"line":156,"kind":13,"containerName":"flag","name":"$fieldname"},{"name":"$self","containerName":"flag","kind":13,"line":158},{"name":"$fieldname","containerName":"flag","kind":13,"line":158},{"name":"$self","containerName":"flag","line":159,"kind":13},{"kind":13,"line":159,"containerName":"flag","name":"$fieldname"}],"line":152},{"range":{"end":{"character":9999,"line":232},"start":{"character":0,"line":174}},"name":"next_individual","line":174,"children":[{"name":"$self","definition":"my","containerName":"next_individual","localvar":"my","kind":13,"line":175},{"line":177,"kind":13,"localvar":"my","definition":"my","name":"$sam","containerName":"next_individual"},{"line":177,"kind":13,"containerName":"next_individual","name":"@marker_results"},{"containerName":"next_individual","name":"$number_of_ids","kind":13,"line":177},{"containerName":"next_individual","name":"$number_of_markers","kind":13,"line":177},{"containerName":"next_individual","name":"$marker_positions","kind":13,"line":178},{"name":"$micro_snp","containerName":"next_individual","kind":13,"line":178},{"containerName":"next_individual","name":"$self","line":180,"kind":13},{"line":180,"kind":12,"containerName":"next_individual","name":"_readline"},{"kind":13,"line":186,"name":"$self","containerName":"next_individual"},{"kind":12,"line":186,"containerName":"next_individual","name":"flag"},{"line":186,"kind":13,"containerName":"next_individual","name":"$self"},{"line":191,"kind":13,"name":"$self","containerName":"next_individual"},{"containerName":"next_individual","name":"$self","line":192,"kind":13},{"line":192,"kind":12,"containerName":"next_individual","name":"flag"},{"kind":13,"line":194,"name":"$self","containerName":"next_individual"},{"containerName":"next_individual","name":"$self","line":195,"kind":13},{"kind":12,"line":195,"containerName":"next_individual","name":"next_individual"},{"line":196,"kind":13,"name":"$self","containerName":"next_individual"},{"containerName":"next_individual","name":"$self","line":197,"kind":13},{"kind":12,"line":197,"containerName":"next_individual","name":"flag"},{"line":199,"kind":13,"name":"$self","containerName":"next_individual"},{"kind":13,"line":200,"containerName":"next_individual","name":"$self"},{"containerName":"next_individual","name":"next_individual","line":200,"kind":12},{"line":201,"kind":13,"containerName":"next_individual","name":"$self"},{"kind":13,"line":202,"containerName":"next_individual","name":"$self"},{"kind":12,"line":202,"name":"flag","containerName":"next_individual"},{"kind":13,"line":204,"containerName":"next_individual","name":"$self"},{"name":"$self","containerName":"next_individual","line":205,"kind":13},{"containerName":"next_individual","name":"next_individual","kind":12,"line":205},{"name":"$self","containerName":"next_individual","line":206,"kind":13},{"name":"$self","containerName":"next_individual","line":207,"kind":13},{"kind":12,"line":207,"containerName":"next_individual","name":"flag"},{"kind":13,"line":209,"containerName":"next_individual","name":"$self"},{"name":"$self","containerName":"next_individual","line":210,"kind":13},{"kind":12,"line":210,"containerName":"next_individual","name":"next_individual"},{"name":"$self","containerName":"next_individual","line":212,"kind":13},{"kind":13,"line":214,"name":"$self","containerName":"next_individual"},{"name":"$self","containerName":"next_individual","kind":13,"line":215},{"name":"next_individual","containerName":"next_individual","kind":12,"line":215},{"containerName":"next_individual","name":"$self","kind":13,"line":218},{"line":221,"kind":13,"containerName":"next_individual","name":"$self"},{"kind":13,"line":222,"containerName":"next_individual","name":"$self"},{"name":"flag","containerName":"next_individual","kind":12,"line":222},{"containerName":"next_individual","name":"$i","definition":"my","localvar":"my","kind":13,"line":224},{"containerName":"next_individual","name":"$self","line":224,"kind":13},{"line":226,"kind":13,"name":"$self","containerName":"next_individual"},{"name":"$self","containerName":"next_individual","kind":13,"line":227},{"containerName":"next_individual","name":"$i","kind":13,"line":227},{"containerName":"next_individual","name":"$self","line":228,"kind":13},{"name":"flag","containerName":"next_individual","kind":12,"line":228},{"line":229,"kind":13,"name":"$self","containerName":"next_individual"},{"line":229,"kind":13,"containerName":"next_individual","name":"$i"},{"containerName":"next_individual","name":"$self","line":231,"kind":13}],"kind":12,"detail":"($self)","signature":{"label":"next_individual($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: phase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::phase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::phase - A parser for Phase format data\n\n=head1 SYNOPSIS\n\n# Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'phase',\n                               -file   => 'data.phase');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing phase data.\n\nPHASE is defined in http://www.stat.washington.edu/stephens/instruct2.1.pdf\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::phase;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n\n\n\n\nsub _initialize  {\n\n    my($self, @args) = @_;\n\n    $Bio::PopGen::Genotype::BlankAlleles='';\n\n    my ($fieldsep,$all_sep, \n\t$noheader) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t   ALLELE_DELIMITER\n\t\t\t\t\t   NO_HEADER)],@args);\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n\n    $self->{'_header'} = undef;\n    return 1;\n\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag  {\n\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n\n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n\n}\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none"},"containerName":"main::","definition":"sub"},{"name":"%self","containerName":null,"line":234,"kind":13},{"kind":13,"line":235,"containerName":null,"name":"%self"},{"name":"$self","containerName":null,"kind":13,"line":235},{"line":235,"kind":12,"containerName":"main::","name":"flag"},{"line":236,"kind":13,"containerName":null,"name":"%self"},{"name":"$self","containerName":null,"line":237,"kind":13},{"line":237,"kind":12,"name":"next_individual","containerName":"main::"},{"line":241,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$i"},{"kind":13,"line":242,"containerName":null,"definition":"my","name":"$m","localvar":"my"},{"line":242,"kind":13,"containerName":null,"name":"%self"},{"name":"$m","containerName":null,"kind":13,"line":243},{"kind":13,"line":244,"containerName":null,"name":"$m"},{"kind":13,"line":245,"containerName":null,"name":"$markername","definition":"my","localvar":"my"},{"kind":13,"line":246,"containerName":null,"name":"%self"},{"name":"$markername","containerName":null,"kind":13,"line":247},{"line":247,"kind":13,"containerName":null,"name":"%self"},{"name":"%i","containerName":null,"kind":13,"line":247},{"kind":13,"line":249,"name":"$markername","containerName":null},{"kind":13,"line":251,"name":"$self","containerName":null},{"line":251,"kind":12,"name":"debug","containerName":"main::"},{"localvar":"my","definition":"my","name":"@alleles","containerName":null,"line":252,"kind":13},{"line":252,"kind":13,"containerName":null,"name":"$self"},{"line":252,"kind":12,"name":"flag","containerName":"main::"},{"containerName":null,"name":"$m","kind":13,"line":252},{"name":"$m","containerName":null,"line":254,"kind":13},{"line":254,"kind":12,"name":"Bio","containerName":"PopGen::Genotype"},{"name":"new","containerName":"main::","line":254,"kind":12},{"line":254,"kind":13,"containerName":null,"name":"@alleles"},{"name":"$markername","containerName":null,"kind":13,"line":255},{"line":256,"kind":13,"containerName":null,"name":"%self"},{"name":"$i","containerName":null,"line":257,"kind":13},{"containerName":"PopGen::Individual","name":"Bio","line":259,"kind":12},{"name":"new","containerName":"main::","kind":12,"line":259},{"containerName":null,"name":"%self","kind":13,"line":259},{"containerName":null,"name":"%self","line":260,"kind":13},{"line":265,"kind":13,"name":"%self","containerName":null},{"kind":13,"line":265,"name":"$self","containerName":null},{"name":"flag","containerName":"main::","line":265,"kind":12},{"kind":13,"line":266,"containerName":null,"name":"$self"},{"kind":12,"line":266,"name":"next_individual","containerName":"main::"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_population($self)","documentation":"1;\n# $Id: phase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::phase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::phase - A parser for Phase format data\n\n=head1 SYNOPSIS\n\n# Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'phase',\n                               -file   => 'data.phase');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing phase data.\n\nPHASE is defined in http://www.stat.washington.edu/stephens/instruct2.1.pdf\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::phase;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n\n\n\n\nsub _initialize  {\n\n    my($self, @args) = @_;\n\n    $Bio::PopGen::Genotype::BlankAlleles='';\n\n    my ($fieldsep,$all_sep, \n\t$noheader) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t   ALLELE_DELIMITER\n\t\t\t\t\t   NO_HEADER)],@args);\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n\n    $self->{'_header'} = undef;\n    return 1;\n\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag  {\n\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n\n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n\n}\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none\n\n\n\nsub next_individual  {\n    my ($self) = @_;\n\n    my ($sam,@marker_results,$number_of_ids,$number_of_markers,\n\t$marker_positions,$micro_snp);\n\n    while( defined( $_ = $self->_readline) ) {\n\tnext if( /^\\s+$/ || ! length($_) );\n\tlast;\n    }\n    \n    return unless defined $_; \n    if( $self->flag('no_header') || defined $self->{'_header'} ) {\n\n\t####### sometimes there is some marker info at the start of a phase input file\n\t####### we collect it in the next few lines if there is. Should this info be held in a marker object?\n\n\tif(!$self->{'_count'} && /^\\s*\\d+$/){\n\t    $self->flag('number_of_ids',$_);\n\t    #print \"number_of_ids : $number_of_ids\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 1 && /^\\s*\\d+$/){\n\t    $self->flag('number_of_markers',$_);\n\t    #print \"number_of_markers : $number_of_markers\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 2 && /^\\s*P\\s\\d/){\n\t    $self->flag('marker_positions',$_);\n\t    #print \"marker_position : $marker_positions\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 3 && /^\\s*(M|S)+\\s*$/i){\n\t    $self->flag('micro_snp',$_);\n\t    #print \"microsat or snp : $micro_snp\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif(/^\\s*\\#/){\n\t    ($self->{'_sam'}) = /^\\s*\\#(.+)/;\n\t    #print \"sample : $self->{'_sam'}\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} else {\n\t    chomp $_;\n\t    if( $self->{'_row1'} ) {\n\t\t# if we are looking at the 2nd row of alleles for this id\n\n\t\t@{$self->{'_second_row'}} = \n\t\t    split($self->flag('field_delimiter'),$_);\n\n\t\tfor my $i(0 .. $#{$self->{'_first_row'}}){\n\n\t\t    push(@{$self->{'_marker_results'}},\n\t\t\t $self->{'_first_row'}->[$i].\n\t\t\t $self->flag('field_delimiter').\n\t\t\t $self->{'_second_row'}->[$i]);\n\t\t}\n\t\t$self->{'_row1'} = 0;\n\t    } else {\n\t\t# if we are looking at the first row of alleles for this id\n\t\t@{$self->{'_marker_results'}} = ();\n\t\t@{$self->{'_first_row'}} = split($self->flag('field_delimiter'),$_);\n\t\t$self->{'_row1'} = 1;\n\t\treturn $self->next_individual;\n\t    }\n\t}\n\n\tmy $i = 1;\n\tforeach my $m ( @{$self->{'_marker_results'}} ) {\n\t    $m =~ s/^\\s+//;\n\t    $m =~ s/\\s+$//;\n\t    my $markername;\n\t    if( defined $self->{'_header'} ) {\n\t\t$markername = $self->{'_header'}->[$i] || \"Marker$i\";\n\t    } else { \n\t\t$markername = \"Marker$i\";\n\t    }\n\t    $self->debug( \"markername is $markername alleles are $m\\n\");\n\t    my @alleles = split($self->flag('allele_delimiter'), $m);\t\n\n\t    $m = Bio::PopGen::Genotype->new(-alleles      =>\\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $self->{'_sam'}); \n\t    $i++; \n\t}\n\treturn Bio::PopGen::Individual->new(-unique_id => $self->{'_sam'},\n\t\t\t\t\t   -genotypes =>\\@{$self->{'_marker_results'}},\n\t\t\t\t\t   );\n\n    } else {\n\tchomp;\n\t$self->{'_header'} = [split($self->flag('field_delimiter'),$_)];\n\treturn $self->next_individual; # rerun loop again\n    }\n    return;\n}\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : L<Bio::PopGen::PopulationI> object\n Args    : none\n Note    : Many implementation will not implement this","parameters":[{"label":"$self"}]},"kind":12,"line":282,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"next_population","line":283,"kind":13},{"kind":13,"line":284,"definition":"my","name":"@inds","containerName":"next_population","localvar":"my"},{"line":285,"kind":13,"localvar":"my","name":"$ind","definition":"my","containerName":"next_population"},{"line":285,"kind":13,"name":"$self","containerName":"next_population"},{"name":"next_individual","containerName":"next_population","line":285,"kind":12},{"name":"@inds","containerName":"next_population","line":286,"kind":13},{"kind":13,"line":286,"containerName":"next_population","name":"$ind"},{"line":288,"kind":12,"name":"new","containerName":"next_population"},{"containerName":"next_population","name":"@inds","line":288,"kind":13}],"name":"next_population","range":{"end":{"character":9999,"line":289},"start":{"line":282,"character":0}}},{"kind":12,"line":288,"containerName":"PopGen::Population","name":"Bio"},{"range":{"start":{"line":302,"character":0},"end":{"line":333,"character":9999}},"name":"write_individual","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"write_individual","line":303,"kind":13},{"containerName":"write_individual","name":"@inds","line":303,"kind":13},{"localvar":"my","containerName":"write_individual","name":"$fielddelim","definition":"my","line":304,"kind":13},{"line":304,"kind":13,"containerName":"write_individual","name":"$self"},{"containerName":"write_individual","name":"flag","line":304,"kind":12},{"localvar":"my","containerName":"write_individual","definition":"my","name":"$alleledelim","line":305,"kind":13},{"containerName":"write_individual","name":"$self","line":305,"kind":13},{"line":305,"kind":12,"name":"flag","containerName":"write_individual"},{"name":"$ind","definition":"my","containerName":"write_individual","localvar":"my","kind":13,"line":307},{"containerName":"write_individual","name":"@inds","line":307,"kind":13},{"line":308,"kind":13,"containerName":"write_individual","name":"$ind"},{"kind":13,"line":308,"name":"$ind","containerName":"write_individual"},{"containerName":"write_individual","name":"isa","kind":12,"line":308},{"line":309,"kind":13,"name":"$self","containerName":"write_individual"},{"containerName":"write_individual","name":"warn","line":309,"kind":12},{"localvar":"my","containerName":"write_individual","name":"@marker_names","definition":"my","line":314,"kind":13},{"containerName":"write_individual","name":"$ind","line":314,"kind":13},{"line":314,"kind":12,"name":"get_marker_names","containerName":"write_individual"},{"name":"$self","containerName":"write_individual","kind":13,"line":315},{"name":"flag","containerName":"write_individual","kind":12,"line":315},{"name":"$self","containerName":"write_individual","kind":13,"line":316},{"name":"flag","containerName":"write_individual","kind":12,"line":316},{"line":317,"kind":13,"containerName":"write_individual","name":"$self"},{"containerName":"write_individual","name":"_print","kind":12,"line":317},{"kind":13,"line":317,"name":"$fielddelim","containerName":"write_individual"},{"containerName":"write_individual","name":"@marker_names","line":317,"kind":13},{"name":"$self","containerName":"write_individual","kind":13,"line":318},{"line":318,"kind":12,"containerName":"write_individual","name":"flag"},{"line":321,"kind":13,"localvar":"my","containerName":"write_individual","definition":"my","name":"@row1"},{"line":321,"kind":13,"containerName":"write_individual","name":"@row2"},{"kind":13,"line":323,"containerName":"write_individual","name":"@marker_names"},{"localvar":"my","containerName":"write_individual","definition":"my","name":"$geno","line":324,"kind":13},{"line":324,"kind":13,"containerName":"write_individual","name":"$ind"},{"kind":12,"line":324,"containerName":"write_individual","name":"get_Genotypes"},{"line":325,"kind":13,"localvar":"my","containerName":"write_individual","definition":"my","name":"@alleles"},{"name":"$geno","containerName":"write_individual","line":325,"kind":13},{"line":325,"kind":12,"containerName":"write_individual","name":"get_Alleles"},{"line":326,"kind":13,"containerName":"write_individual","name":"@row1"},{"kind":13,"line":326,"name":"$alleles","containerName":"write_individual"},{"kind":13,"line":327,"name":"@row2","containerName":"write_individual"},{"name":"$alleles","containerName":"write_individual","kind":13,"line":327},{"containerName":"write_individual","name":"$self","line":329,"kind":13},{"kind":12,"line":329,"name":"_print","containerName":"write_individual"},{"kind":13,"line":329,"name":"$ind","containerName":"write_individual"},{"line":329,"kind":12,"containerName":"write_individual","name":"unique_id"},{"line":330,"kind":13,"name":"$fielddelim","containerName":"write_individual"},{"name":"@row1","containerName":"write_individual","line":330,"kind":13},{"containerName":"write_individual","name":"$fielddelim","line":331,"kind":13},{"kind":13,"line":331,"containerName":"write_individual","name":"@row2"}],"line":302,"kind":12,"signature":{"label":"write_individual($self,@inds)","documentation":"1;\n# $Id: phase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::phase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::phase - A parser for Phase format data\n\n=head1 SYNOPSIS\n\n# Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'phase',\n                               -file   => 'data.phase');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing phase data.\n\nPHASE is defined in http://www.stat.washington.edu/stephens/instruct2.1.pdf\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::phase;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n\n\n\n\nsub _initialize  {\n\n    my($self, @args) = @_;\n\n    $Bio::PopGen::Genotype::BlankAlleles='';\n\n    my ($fieldsep,$all_sep, \n\t$noheader) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t   ALLELE_DELIMITER\n\t\t\t\t\t   NO_HEADER)],@args);\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n\n    $self->{'_header'} = undef;\n    return 1;\n\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag  {\n\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n\n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n\n}\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none\n\n\n\nsub next_individual  {\n    my ($self) = @_;\n\n    my ($sam,@marker_results,$number_of_ids,$number_of_markers,\n\t$marker_positions,$micro_snp);\n\n    while( defined( $_ = $self->_readline) ) {\n\tnext if( /^\\s+$/ || ! length($_) );\n\tlast;\n    }\n    \n    return unless defined $_; \n    if( $self->flag('no_header') || defined $self->{'_header'} ) {\n\n\t####### sometimes there is some marker info at the start of a phase input file\n\t####### we collect it in the next few lines if there is. Should this info be held in a marker object?\n\n\tif(!$self->{'_count'} && /^\\s*\\d+$/){\n\t    $self->flag('number_of_ids',$_);\n\t    #print \"number_of_ids : $number_of_ids\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 1 && /^\\s*\\d+$/){\n\t    $self->flag('number_of_markers',$_);\n\t    #print \"number_of_markers : $number_of_markers\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 2 && /^\\s*P\\s\\d/){\n\t    $self->flag('marker_positions',$_);\n\t    #print \"marker_position : $marker_positions\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 3 && /^\\s*(M|S)+\\s*$/i){\n\t    $self->flag('micro_snp',$_);\n\t    #print \"microsat or snp : $micro_snp\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif(/^\\s*\\#/){\n\t    ($self->{'_sam'}) = /^\\s*\\#(.+)/;\n\t    #print \"sample : $self->{'_sam'}\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} else {\n\t    chomp $_;\n\t    if( $self->{'_row1'} ) {\n\t\t# if we are looking at the 2nd row of alleles for this id\n\n\t\t@{$self->{'_second_row'}} = \n\t\t    split($self->flag('field_delimiter'),$_);\n\n\t\tfor my $i(0 .. $#{$self->{'_first_row'}}){\n\n\t\t    push(@{$self->{'_marker_results'}},\n\t\t\t $self->{'_first_row'}->[$i].\n\t\t\t $self->flag('field_delimiter').\n\t\t\t $self->{'_second_row'}->[$i]);\n\t\t}\n\t\t$self->{'_row1'} = 0;\n\t    } else {\n\t\t# if we are looking at the first row of alleles for this id\n\t\t@{$self->{'_marker_results'}} = ();\n\t\t@{$self->{'_first_row'}} = split($self->flag('field_delimiter'),$_);\n\t\t$self->{'_row1'} = 1;\n\t\treturn $self->next_individual;\n\t    }\n\t}\n\n\tmy $i = 1;\n\tforeach my $m ( @{$self->{'_marker_results'}} ) {\n\t    $m =~ s/^\\s+//;\n\t    $m =~ s/\\s+$//;\n\t    my $markername;\n\t    if( defined $self->{'_header'} ) {\n\t\t$markername = $self->{'_header'}->[$i] || \"Marker$i\";\n\t    } else { \n\t\t$markername = \"Marker$i\";\n\t    }\n\t    $self->debug( \"markername is $markername alleles are $m\\n\");\n\t    my @alleles = split($self->flag('allele_delimiter'), $m);\t\n\n\t    $m = Bio::PopGen::Genotype->new(-alleles      =>\\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $self->{'_sam'}); \n\t    $i++; \n\t}\n\treturn Bio::PopGen::Individual->new(-unique_id => $self->{'_sam'},\n\t\t\t\t\t   -genotypes =>\\@{$self->{'_marker_results'}},\n\t\t\t\t\t   );\n\n    } else {\n\tchomp;\n\t$self->{'_header'} = [split($self->flag('field_delimiter'),$_)];\n\treturn $self->next_individual; # rerun loop again\n    }\n    return;\n}\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : L<Bio::PopGen::PopulationI> object\n Args    : none\n Note    : Many implementation will not implement this\n\n\nsub next_population{\n    my ($self) = @_;\n    my @inds;\n    while( my $ind = $self->next_individual ) {\n\tpush @inds, $ind;\n    }\n    Bio::PopGen::Population->new(-individuals => \\@inds);\n}\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)","parameters":[{"label":"$self"},{"label":"@inds"}]},"detail":"($self,@inds)","definition":"sub","containerName":"main::"},{"name":"write_population","range":{"end":{"character":9999,"line":379},"start":{"character":0,"line":347}},"kind":12,"line":347,"children":[{"localvar":"my","containerName":"write_population","name":"$self","definition":"my","line":348,"kind":13},{"containerName":"write_population","name":"@pops","kind":13,"line":348},{"line":349,"kind":13,"localvar":"my","containerName":"write_population","name":"$fielddelim","definition":"my"},{"kind":13,"line":349,"containerName":"write_population","name":"$self"},{"name":"flag","containerName":"write_population","kind":12,"line":349},{"line":350,"kind":13,"localvar":"my","containerName":"write_population","name":"$alleledelim","definition":"my"},{"kind":13,"line":350,"name":"$self","containerName":"write_population"},{"name":"flag","containerName":"write_population","line":350,"kind":12},{"line":352,"kind":13,"localvar":"my","name":"$pop","definition":"my","containerName":"write_population"},{"name":"@pops","containerName":"write_population","kind":13,"line":352},{"containerName":"write_population","name":"$pop","kind":13,"line":353},{"name":"$pop","containerName":"write_population","line":353,"kind":13},{"containerName":"write_population","name":"isa","line":353,"kind":12},{"name":"$self","containerName":"write_population","kind":13,"line":354},{"containerName":"write_population","name":"warn","kind":12,"line":354},{"name":"@marker_names","definition":"my","containerName":"write_population","localvar":"my","kind":13,"line":359},{"name":"$pop","containerName":"write_population","line":359,"kind":13},{"containerName":"write_population","name":"get_marker_names","line":359,"kind":12},{"line":360,"kind":13,"name":"$self","containerName":"write_population"},{"kind":12,"line":360,"name":"flag","containerName":"write_population"},{"name":"$self","containerName":"write_population","kind":13,"line":361},{"name":"flag","containerName":"write_population","kind":12,"line":361},{"name":"$self","containerName":"write_population","line":362,"kind":13},{"kind":12,"line":362,"containerName":"write_population","name":"_print"},{"name":"$fielddelim","containerName":"write_population","kind":13,"line":362},{"containerName":"write_population","name":"@marker_names","line":362,"kind":13},{"name":"$self","containerName":"write_population","kind":13,"line":364},{"kind":12,"line":364,"name":"flag","containerName":"write_population"},{"localvar":"my","containerName":"write_population","name":"$ind","definition":"my","line":366,"kind":13},{"kind":13,"line":366,"containerName":"write_population","name":"$pop"},{"containerName":"write_population","name":"get_Individuals","kind":12,"line":366},{"line":367,"kind":13,"localvar":"my","containerName":"write_population","name":"@row1","definition":"my"},{"containerName":"write_population","name":"@row2","kind":13,"line":367},{"name":"@marker_names","containerName":"write_population","kind":13,"line":368},{"name":"$geno","definition":"my","containerName":"write_population","localvar":"my","kind":13,"line":369},{"kind":13,"line":369,"name":"$ind","containerName":"write_population"},{"containerName":"write_population","name":"get_Genotypes","kind":12,"line":369},{"localvar":"my","name":"@alleles","definition":"my","containerName":"write_population","line":370,"kind":13},{"line":370,"kind":13,"containerName":"write_population","name":"$geno"},{"containerName":"write_population","name":"get_Alleles","kind":12,"line":370},{"line":371,"kind":13,"containerName":"write_population","name":"@row1"},{"containerName":"write_population","name":"$alleles","line":371,"kind":13},{"containerName":"write_population","name":"@row2","kind":13,"line":372},{"kind":13,"line":372,"containerName":"write_population","name":"$alleles"},{"name":"$self","containerName":"write_population","line":374,"kind":13},{"containerName":"write_population","name":"_print","kind":12,"line":374},{"name":"$ind","containerName":"write_population","line":374,"kind":13},{"line":374,"kind":12,"name":"unique_id","containerName":"write_population"},{"containerName":"write_population","name":"$fielddelim","line":375,"kind":13},{"kind":13,"line":375,"containerName":"write_population","name":"@row1"},{"name":"$fielddelim","containerName":"write_population","line":376,"kind":13},{"kind":13,"line":376,"name":"@row2","containerName":"write_population"}],"containerName":"main::","definition":"sub","detail":"($self,@pops)","signature":{"documentation":"1;\n# $Id: phase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::phase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::phase - A parser for Phase format data\n\n=head1 SYNOPSIS\n\n# Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'phase',\n                               -file   => 'data.phase');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing phase data.\n\nPHASE is defined in http://www.stat.washington.edu/stephens/instruct2.1.pdf\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::phase;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader) =( ',', '\\s+',0);\n\n\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n\n\n\n\nsub _initialize  {\n\n    my($self, @args) = @_;\n\n    $Bio::PopGen::Genotype::BlankAlleles='';\n\n    my ($fieldsep,$all_sep, \n\t$noheader) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t   ALLELE_DELIMITER\n\t\t\t\t\t   NO_HEADER)],@args);\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n\n    $self->{'_header'} = undef;\n    return 1;\n\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag  {\n\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n\n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n\n}\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none\n\n\n\nsub next_individual  {\n    my ($self) = @_;\n\n    my ($sam,@marker_results,$number_of_ids,$number_of_markers,\n\t$marker_positions,$micro_snp);\n\n    while( defined( $_ = $self->_readline) ) {\n\tnext if( /^\\s+$/ || ! length($_) );\n\tlast;\n    }\n    \n    return unless defined $_; \n    if( $self->flag('no_header') || defined $self->{'_header'} ) {\n\n\t####### sometimes there is some marker info at the start of a phase input file\n\t####### we collect it in the next few lines if there is. Should this info be held in a marker object?\n\n\tif(!$self->{'_count'} && /^\\s*\\d+$/){\n\t    $self->flag('number_of_ids',$_);\n\t    #print \"number_of_ids : $number_of_ids\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 1 && /^\\s*\\d+$/){\n\t    $self->flag('number_of_markers',$_);\n\t    #print \"number_of_markers : $number_of_markers\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 2 && /^\\s*P\\s\\d/){\n\t    $self->flag('marker_positions',$_);\n\t    #print \"marker_position : $marker_positions\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif($self->{'_count'} == 3 && /^\\s*(M|S)+\\s*$/i){\n\t    $self->flag('micro_snp',$_);\n\t    #print \"microsat or snp : $micro_snp\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} elsif(/^\\s*\\#/){\n\t    ($self->{'_sam'}) = /^\\s*\\#(.+)/;\n\t    #print \"sample : $self->{'_sam'}\\n\";\n\t    $self->{'_count'}++;\n\t    return $self->next_individual;\n\t} else {\n\t    chomp $_;\n\t    if( $self->{'_row1'} ) {\n\t\t# if we are looking at the 2nd row of alleles for this id\n\n\t\t@{$self->{'_second_row'}} = \n\t\t    split($self->flag('field_delimiter'),$_);\n\n\t\tfor my $i(0 .. $#{$self->{'_first_row'}}){\n\n\t\t    push(@{$self->{'_marker_results'}},\n\t\t\t $self->{'_first_row'}->[$i].\n\t\t\t $self->flag('field_delimiter').\n\t\t\t $self->{'_second_row'}->[$i]);\n\t\t}\n\t\t$self->{'_row1'} = 0;\n\t    } else {\n\t\t# if we are looking at the first row of alleles for this id\n\t\t@{$self->{'_marker_results'}} = ();\n\t\t@{$self->{'_first_row'}} = split($self->flag('field_delimiter'),$_);\n\t\t$self->{'_row1'} = 1;\n\t\treturn $self->next_individual;\n\t    }\n\t}\n\n\tmy $i = 1;\n\tforeach my $m ( @{$self->{'_marker_results'}} ) {\n\t    $m =~ s/^\\s+//;\n\t    $m =~ s/\\s+$//;\n\t    my $markername;\n\t    if( defined $self->{'_header'} ) {\n\t\t$markername = $self->{'_header'}->[$i] || \"Marker$i\";\n\t    } else { \n\t\t$markername = \"Marker$i\";\n\t    }\n\t    $self->debug( \"markername is $markername alleles are $m\\n\");\n\t    my @alleles = split($self->flag('allele_delimiter'), $m);\t\n\n\t    $m = Bio::PopGen::Genotype->new(-alleles      =>\\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $self->{'_sam'}); \n\t    $i++; \n\t}\n\treturn Bio::PopGen::Individual->new(-unique_id => $self->{'_sam'},\n\t\t\t\t\t   -genotypes =>\\@{$self->{'_marker_results'}},\n\t\t\t\t\t   );\n\n    } else {\n\tchomp;\n\t$self->{'_header'} = [split($self->flag('field_delimiter'),$_)];\n\treturn $self->next_individual; # rerun loop again\n    }\n    return;\n}\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : L<Bio::PopGen::PopulationI> object\n Args    : none\n Note    : Many implementation will not implement this\n\n\nsub next_population{\n    my ($self) = @_;\n    my @inds;\n    while( my $ind = $self->next_individual ) {\n\tpush @inds, $ind;\n    }\n    Bio::PopGen::Population->new(-individuals => \\@inds);\n}\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)\n\n\n\nsub write_individual {\n    my ($self,@inds) = @_;\n    my $fielddelim  = $self->flag('field_delimiter');\n    my $alleledelim = $self->flag('allele_delimiter');\n\n    foreach my $ind ( @inds ) {\n\tif (! ref($ind) || ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Cannot write an object that is not a Bio::PopGen::IndividualI object ($ind)\");\n\t    next;\n\t}\n\t# we'll go ahead and sort these until\n\t# we have a better way to insure a consistent order\n\tmy @marker_names = sort $ind->get_marker_names;\n\tif( ! $self->flag('no_header') && \n\t    ! $self->flag('header_written') ) {\n\t    $self->_print(join($fielddelim, ('SAM', @marker_names)), \"\\n\");\n\t    $self->flag('header_written',1);\n\t}\n\n\tmy(@row1,@row2);\n\n\tfor (@marker_names){\n\t    my $geno = $ind->get_Genotypes(-marker => $_);\n\t    my @alleles = $geno->get_Alleles();\n\t    push(@row1,$alleles[0]);\n\t    push(@row2,$alleles[1]);\n\t}\n\t$self->_print(\"#\",$ind->unique_id,\"\\n\",\n\t\t      join($fielddelim,@row1),\"\\n\",\n\t\t      join($fielddelim,@row2),\"\\n\");\n    }\n}\n\n=head2 write_population\n\n Title   : write_population\n Usage   : $popgenio->write_population($pop);\n Function: Write a population out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)\n Note    : Many implementation will not implement this","parameters":[{"label":"$self"},{"label":"@pops"}],"label":"write_population($self,@pops)"}}]}