{"vars":[{"kind":2,"line":86,"name":"vars","containerName":""},{"name":"strict","containerName":"","line":89,"kind":2},{"kind":13,"line":89,"containerName":null,"name":"$FieldDelim"},{"containerName":null,"name":"$AlleleDelim","kind":13,"line":89},{"containerName":null,"name":"$NoHeader","line":89,"kind":13},{"kind":13,"line":89,"containerName":null,"name":"$StartingCol"},{"containerName":"","name":"base","kind":2,"line":95},{"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: hapmap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::hapmap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::hapmap - A parser for HapMap output data\n\n=head1 SYNOPSIS\n\n  # Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'hapmap',\n                               -file   => 'data.hapmap');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing hapmap data.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::IO::hapmap;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader $StartingCol);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader,$StartingCol) =( '\\s+','',0,11);\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n           -starting_column => 11","label":"_initialize($self,@args)"},"kind":12,"line":113,"children":[{"kind":13,"line":115,"containerName":"_initialize","name":"$self","definition":"my","localvar":"my"},{"name":"@args","containerName":"_initialize","line":115,"kind":13},{"containerName":"_initialize","name":"$Bio","line":117,"kind":13},{"kind":13,"line":119,"definition":"my","name":"$fieldsep","containerName":"_initialize","localvar":"my"},{"containerName":"_initialize","name":"$all_sep","line":119,"kind":13},{"line":120,"kind":13,"containerName":"_initialize","name":"$noheader"},{"kind":13,"line":120,"containerName":"_initialize","name":"$start_col"},{"name":"$self","containerName":"_initialize","line":120,"kind":13},{"containerName":"_initialize","name":"_rearrange","kind":12,"line":120},{"containerName":"_initialize","name":"@args","line":124,"kind":13},{"containerName":"_initialize","name":"$self","line":126,"kind":13},{"line":126,"kind":12,"containerName":"_initialize","name":"flag"},{"kind":13,"line":126,"containerName":"_initialize","name":"$noheader"},{"name":"$noheader","containerName":"_initialize","kind":13,"line":126},{"kind":13,"line":126,"name":"$NoHeader","containerName":"_initialize"},{"line":127,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"flag","containerName":"_initialize","kind":12,"line":127},{"line":127,"kind":13,"name":"$fieldsep","containerName":"_initialize"},{"name":"$fieldsep","containerName":"_initialize","kind":13,"line":127},{"containerName":"_initialize","name":"$FieldDelim","kind":13,"line":127},{"kind":13,"line":128,"containerName":"_initialize","name":"$self"},{"kind":12,"line":128,"name":"flag","containerName":"_initialize"},{"name":"$all_sep","containerName":"_initialize","line":128,"kind":13},{"line":128,"kind":13,"containerName":"_initialize","name":"$all_sep"},{"line":128,"kind":13,"containerName":"_initialize","name":"$AlleleDelim"},{"name":"$self","containerName":"_initialize","kind":13,"line":129},{"name":"starting_column","containerName":"_initialize","line":129,"kind":12},{"name":"$start_col","containerName":"_initialize","line":129,"kind":13},{"line":129,"kind":13,"containerName":"_initialize","name":"$start_col"},{"name":"$StartingCol","containerName":"_initialize","line":129,"kind":13},{"name":"$self","containerName":"_initialize","line":131,"kind":13}],"name":"_initialize","range":{"start":{"character":0,"line":113},"end":{"character":9999,"line":134}}},{"containerName":"Genotype::BlankAlleles","name":"PopGen","line":117,"kind":12},{"range":{"start":{"character":0,"line":148},"end":{"character":9999,"line":156}},"containerName":"main::","name":"flag","definition":"sub","line":148,"children":[{"line":150,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"flag"},{"localvar":"my","name":"$fieldname","definition":"my","containerName":"flag","line":151,"kind":13},{"name":"$fieldname","containerName":"flag","line":152,"kind":13},{"containerName":"flag","name":"$self","line":153,"kind":13},{"containerName":"flag","name":"$fieldname","kind":13,"line":153},{"line":154,"kind":13,"containerName":"flag","name":"$self"},{"name":"$fieldname","containerName":"flag","line":154,"kind":13}],"kind":12},{"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_pivot($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"line":159,"kind":13,"localvar":"my","containerName":"_pivot","definition":"my","name":"$self"},{"containerName":"_pivot","definition":"my","name":"@cols","localvar":"my","kind":13,"line":161},{"name":"@rows","containerName":"_pivot","line":161,"kind":13},{"kind":13,"line":161,"name":"@idheader","containerName":"_pivot"},{"containerName":"_pivot","name":"$self","kind":13,"line":162},{"name":"_readline","containerName":"_pivot","line":162,"kind":12},{"line":166,"kind":13,"name":"@idheader","containerName":"_pivot"},{"name":"$self","containerName":"_pivot","kind":13,"line":166},{"kind":12,"line":166,"name":"flag","containerName":"_pivot"},{"name":"@cols","containerName":"_pivot","kind":13,"line":168},{"kind":13,"line":168,"containerName":"_pivot","name":"$self"},{"line":168,"kind":12,"name":"flag","containerName":"_pivot"},{"definition":"my","name":"$startingcol","containerName":"_pivot","localvar":"my","kind":13,"line":171},{"line":171,"kind":13,"containerName":"_pivot","name":"$self"},{"line":171,"kind":12,"containerName":"_pivot","name":"starting_column"},{"line":173,"kind":13,"containerName":"_pivot","name":"$self"},{"line":173,"kind":13,"containerName":"_pivot","name":"@cols"},{"line":174,"kind":13,"localvar":"my","containerName":"_pivot","definition":"my","name":"$n"},{"name":"$startingcol","containerName":"_pivot","kind":13,"line":174},{"name":"$cols","containerName":"_pivot","kind":13,"line":174}],"line":158,"kind":12,"range":{"start":{"character":0,"line":158},"end":{"line":174,"character":9999}},"name":"_pivot"},{"kind":13,"line":175,"name":"@column","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"@idheader","kind":13,"line":175},{"kind":13,"line":175,"name":"%n","containerName":null},{"line":176,"kind":13,"containerName":null,"name":"$n"},{"containerName":null,"name":"@cols","line":176,"kind":13},{"containerName":null,"name":"@rows","line":177,"kind":13},{"name":"$column","containerName":null,"kind":13,"line":177},{"containerName":null,"name":"%self","kind":13,"line":179},{"name":"@rows","containerName":null,"line":179,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":180},{"name":"next_individual","range":{"end":{"line":241,"character":9999},"start":{"character":0,"line":196}},"kind":12,"line":196,"children":[{"localvar":"my","containerName":"next_individual","name":"$self","definition":"my","line":197,"kind":13},{"containerName":"next_individual","name":"$self","kind":13,"line":198},{"kind":13,"line":201,"containerName":"next_individual","name":"$self"},{"name":"_pivot","containerName":"next_individual","line":201,"kind":12},{"line":204,"kind":13,"name":"$self","containerName":"next_individual"},{"line":204,"kind":13,"name":"$self","containerName":"next_individual"},{"kind":13,"line":213,"definition":"my","name":"$samp","containerName":"next_individual","localvar":"my"},{"line":213,"kind":13,"name":"@marker_results","containerName":"next_individual"},{"line":213,"kind":13,"name":"$_","containerName":"next_individual"},{"kind":13,"line":216,"name":"$i","definition":"my","containerName":"next_individual","localvar":"my"},{"kind":13,"line":217,"definition":"my","name":"$m","containerName":"next_individual","localvar":"my"},{"kind":13,"line":217,"name":"@marker_results","containerName":"next_individual"},{"line":218,"kind":13,"containerName":"next_individual","name":"$m"},{"line":219,"kind":13,"containerName":"next_individual","name":"$m"},{"line":220,"kind":13,"localvar":"my","containerName":"next_individual","name":"$markername","definition":"my"},{"name":"$self","containerName":"next_individual","kind":13,"line":221},{"line":222,"kind":13,"name":"$markername","containerName":"next_individual"},{"containerName":"next_individual","name":"$self","line":222,"kind":13},{"containerName":"next_individual","name":"$i","kind":13,"line":222},{"kind":13,"line":224,"containerName":"next_individual","name":"$markername"},{"localvar":"my","containerName":"next_individual","definition":"my","name":"@alleles","line":227,"kind":13},{"kind":13,"line":227,"containerName":"next_individual","name":"$self"},{"containerName":"next_individual","name":"flag","line":227,"kind":12},{"line":227,"kind":13,"containerName":"next_individual","name":"$m"},{"containerName":"next_individual","name":"@alleles","kind":13,"line":228},{"line":229,"kind":13,"name":"$self","containerName":"next_individual"},{"line":229,"kind":12,"containerName":"next_individual","name":"warn"},{"kind":13,"line":231,"containerName":"next_individual","name":"$m"},{"name":"new","containerName":"next_individual","kind":12,"line":231},{"name":"@alleles","containerName":"next_individual","kind":13,"line":231},{"containerName":"next_individual","name":"$markername","kind":13,"line":232},{"containerName":"next_individual","name":"$samp","kind":13,"line":233},{"containerName":"next_individual","name":"$i","kind":13,"line":235},{"containerName":"next_individual","name":"$samp","kind":13,"line":238},{"containerName":"next_individual","name":"@marker_results","kind":13,"line":239}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_individual($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: hapmap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::hapmap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::hapmap - A parser for HapMap output data\n\n=head1 SYNOPSIS\n\n  # Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'hapmap',\n                               -file   => 'data.hapmap');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing hapmap data.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::IO::hapmap;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader $StartingCol);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader,$StartingCol) =( '\\s+','',0,11);\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n           -starting_column => 11\n\n\n\nsub _initialize  {\n\n    my($self, @args) = @_;\n\n    $Bio::PopGen::Genotype::BlankAlleles='';\n\n    my ($fieldsep,$all_sep, \n\t$noheader, $start_col) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t\t       ALLELE_DELIMITER\n\t\t\t\t\t\t       NO_HEADER\n\t\t\t\t\t\t       STARTING_COLUMN)],\n\t\t\t\t\t\t   @args);\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n    $self->starting_column(defined $start_col ? $start_col : $StartingCol );\n\n    $self->{'_header'} = undef;\n    return 1;\n\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\nsub flag  {\n\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n\n}\n\nsub _pivot {\n    my ($self) = @_;\n\n    my (@cols,@rows,@idheader);\n    while ($_ = $self->_readline){\n\tchomp($_);\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\tif( /^rs\\#\\s+alleles\\s+chrom\\s+pos\\s+strand/ ) {\n\t    @idheader = split $self->flag('field_delimiter');\n\t} else { \n\t    push @cols, [split $self->flag('field_delimiter')];\n\t}\n    }\n    my $startingcol = $self->starting_column;\n\n    $self->{'_header'} = [ map { $_->[0] } @cols];\n    for my $n ($startingcol.. $#{ $cols[ 0 ]}) { \n\tmy $column = [ $idheader[$n],\n\t\t       map{ $_->[ $n ] } @cols ];\t\n\tpush (@rows, $column); \n    }\n    $self->{'_pivot'} = [@rows];\n    $self->{'_i'} = 0;\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : A Bio::PopGen::IndividualI object\n Args    : none\n\nSee L<Bio::PopGen::IndividualI>"}},{"name":"Bio","containerName":"PopGen::Genotype","line":231,"kind":12},{"name":"new","kind":12,"line":238},{"line":238,"kind":12,"containerName":"PopGen::Individual","name":"Bio"},{"kind":12,"line":256,"children":[{"name":"$self","definition":"my","containerName":"next_population","localvar":"my","kind":13,"line":257},{"kind":13,"line":258,"name":"@inds","definition":"my","containerName":"next_population","localvar":"my"},{"kind":13,"line":259,"containerName":"next_population","definition":"my","name":"$ind","localvar":"my"},{"kind":13,"line":259,"name":"$self","containerName":"next_population"},{"name":"next_individual","containerName":"next_population","line":259,"kind":12},{"containerName":"next_population","name":"@inds","kind":13,"line":260},{"line":260,"kind":13,"name":"$ind","containerName":"next_population"},{"kind":12,"line":262,"containerName":"next_population","name":"new"},{"line":262,"kind":13,"name":"@inds","containerName":"next_population"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_population($self)","documentation":"1;\n# $Id: hapmap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::hapmap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::hapmap - A parser for HapMap output data\n\n=head1 SYNOPSIS\n\n  # Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'hapmap',\n                               -file   => 'data.hapmap');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing hapmap data.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::IO::hapmap;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader $StartingCol);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader,$StartingCol) =( '\\s+','',0,11);\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n           -starting_column => 11\n\n\n\nsub _initialize  {\n\n    my($self, @args) = @_;\n\n    $Bio::PopGen::Genotype::BlankAlleles='';\n\n    my ($fieldsep,$all_sep, \n\t$noheader, $start_col) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t\t       ALLELE_DELIMITER\n\t\t\t\t\t\t       NO_HEADER\n\t\t\t\t\t\t       STARTING_COLUMN)],\n\t\t\t\t\t\t   @args);\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n    $self->starting_column(defined $start_col ? $start_col : $StartingCol );\n\n    $self->{'_header'} = undef;\n    return 1;\n\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\nsub flag  {\n\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n\n}\n\nsub _pivot {\n    my ($self) = @_;\n\n    my (@cols,@rows,@idheader);\n    while ($_ = $self->_readline){\n\tchomp($_);\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\tif( /^rs\\#\\s+alleles\\s+chrom\\s+pos\\s+strand/ ) {\n\t    @idheader = split $self->flag('field_delimiter');\n\t} else { \n\t    push @cols, [split $self->flag('field_delimiter')];\n\t}\n    }\n    my $startingcol = $self->starting_column;\n\n    $self->{'_header'} = [ map { $_->[0] } @cols];\n    for my $n ($startingcol.. $#{ $cols[ 0 ]}) { \n\tmy $column = [ $idheader[$n],\n\t\t       map{ $_->[ $n ] } @cols ];\t\n\tpush (@rows, $column); \n    }\n    $self->{'_pivot'} = [@rows];\n    $self->{'_i'} = 0;\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : A Bio::PopGen::IndividualI object\n Args    : none\n\nSee L<Bio::PopGen::IndividualI>\n\n\nsub next_individual  {\n    my ($self) = @_;\n    unless($self->{'_pivot'}){\n\t#if it's the first time then pivot the table and store.\n\t#Lines will now be read from the stored pivot version of the input file\n\t$self->_pivot;\n    }\n\n    $_ = $self->{'_pivot'}->[$self->{'_i'}++];\n\n    return unless defined $_;\n\n    # Store all the marker related info. Now that the pivot has taken\n    # place this is in the first few lines of the file Maybe this\n    # should be put in a marker object. Doesn't seem to fit too well\n    # though\n\n    my ($samp,@marker_results) = @$_;\n\n    # at some point use all this info\n    my $i = 1;\n    foreach my $m ( @marker_results ) {\n\t$m =~ s/^\\s+//;\n\t$m =~ s/\\s+$//;\n\tmy $markername;\n\tif( defined $self->{'_header'} ) {\n\t    $markername = $self->{'_header'}->[$i-1];\n\t} else { \n\t    $markername = \"Marker$i\";\n\t}\n\n\tmy @alleles = split($self->flag('allele_delimiter'), $m);\n\tif( @alleles != 2 ) { \n\t    $self->warn(\"$m for $samp\\n\");\n\t} else { \n\t    $m = Bio::PopGen::Genotype->new(-alleles      => \\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $samp);\n\t}\n\t$i++; \n    }\n\n    return new Bio::PopGen::Individual(-unique_id => $samp,\n\t\t\t\t       -genotypes => \\@marker_results);\n\n}\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : Bio::PopGen::PopulationI object\n Args    : none\n Note    : Many implementation will not implement this\n\nSee L<Bio::PopGen::PopulationI>","parameters":[{"label":"$self"}]},"name":"next_population","range":{"end":{"line":263,"character":9999},"start":{"line":256,"character":0}}},{"kind":12,"line":262,"containerName":"PopGen::Population","name":"Bio"},{"range":{"start":{"line":278,"character":0},"end":{"character":9999,"line":285}},"name":"write_individual","signature":{"label":"write_individual($self,@inds)","parameters":[{"label":"$self"},{"label":"@inds"}],"documentation":"1;\n# $Id: hapmap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::hapmap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::hapmap - A parser for HapMap output data\n\n=head1 SYNOPSIS\n\n  # Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'hapmap',\n                               -file   => 'data.hapmap');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing hapmap data.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::IO::hapmap;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader $StartingCol);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader,$StartingCol) =( '\\s+','',0,11);\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n           -starting_column => 11\n\n\n\nsub _initialize  {\n\n    my($self, @args) = @_;\n\n    $Bio::PopGen::Genotype::BlankAlleles='';\n\n    my ($fieldsep,$all_sep, \n\t$noheader, $start_col) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t\t       ALLELE_DELIMITER\n\t\t\t\t\t\t       NO_HEADER\n\t\t\t\t\t\t       STARTING_COLUMN)],\n\t\t\t\t\t\t   @args);\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n    $self->starting_column(defined $start_col ? $start_col : $StartingCol );\n\n    $self->{'_header'} = undef;\n    return 1;\n\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\nsub flag  {\n\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n\n}\n\nsub _pivot {\n    my ($self) = @_;\n\n    my (@cols,@rows,@idheader);\n    while ($_ = $self->_readline){\n\tchomp($_);\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\tif( /^rs\\#\\s+alleles\\s+chrom\\s+pos\\s+strand/ ) {\n\t    @idheader = split $self->flag('field_delimiter');\n\t} else { \n\t    push @cols, [split $self->flag('field_delimiter')];\n\t}\n    }\n    my $startingcol = $self->starting_column;\n\n    $self->{'_header'} = [ map { $_->[0] } @cols];\n    for my $n ($startingcol.. $#{ $cols[ 0 ]}) { \n\tmy $column = [ $idheader[$n],\n\t\t       map{ $_->[ $n ] } @cols ];\t\n\tpush (@rows, $column); \n    }\n    $self->{'_pivot'} = [@rows];\n    $self->{'_i'} = 0;\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : A Bio::PopGen::IndividualI object\n Args    : none\n\nSee L<Bio::PopGen::IndividualI>\n\n\nsub next_individual  {\n    my ($self) = @_;\n    unless($self->{'_pivot'}){\n\t#if it's the first time then pivot the table and store.\n\t#Lines will now be read from the stored pivot version of the input file\n\t$self->_pivot;\n    }\n\n    $_ = $self->{'_pivot'}->[$self->{'_i'}++];\n\n    return unless defined $_;\n\n    # Store all the marker related info. Now that the pivot has taken\n    # place this is in the first few lines of the file Maybe this\n    # should be put in a marker object. Doesn't seem to fit too well\n    # though\n\n    my ($samp,@marker_results) = @$_;\n\n    # at some point use all this info\n    my $i = 1;\n    foreach my $m ( @marker_results ) {\n\t$m =~ s/^\\s+//;\n\t$m =~ s/\\s+$//;\n\tmy $markername;\n\tif( defined $self->{'_header'} ) {\n\t    $markername = $self->{'_header'}->[$i-1];\n\t} else { \n\t    $markername = \"Marker$i\";\n\t}\n\n\tmy @alleles = split($self->flag('allele_delimiter'), $m);\n\tif( @alleles != 2 ) { \n\t    $self->warn(\"$m for $samp\\n\");\n\t} else { \n\t    $m = Bio::PopGen::Genotype->new(-alleles      => \\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $samp);\n\t}\n\t$i++; \n    }\n\n    return new Bio::PopGen::Individual(-unique_id => $samp,\n\t\t\t\t       -genotypes => \\@marker_results);\n\n}\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : Bio::PopGen::PopulationI object\n Args    : none\n Note    : Many implementation will not implement this\n\nSee L<Bio::PopGen::PopulationI>\n\n\nsub next_population {\n    my ($self) = @_;\n    my @inds;\n    while( my $ind = $self->next_individual ) {\n\tpush @inds, $ind;\n    }\n    Bio::PopGen::Population->new(-individuals => \\@inds);\n}\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the file format\n           NOT SUPPORTED  BY hapmap format\n Returns : none\n Args    : Bio::PopGen::PopulationI object(s)\n\nSee L<Bio::PopGen::PopulationI>"},"detail":"($self,@inds)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":279,"name":"$self","definition":"my","containerName":"write_individual","localvar":"my"},{"name":"@inds","containerName":"write_individual","kind":13,"line":279},{"name":"$self","containerName":"write_individual","kind":13,"line":284},{"line":284,"kind":12,"containerName":"write_individual","name":"throw_not_implemented"}],"line":278,"kind":12},{"range":{"end":{"line":304,"character":9999},"start":{"character":0,"line":301}},"name":"write_population","children":[{"kind":13,"line":302,"name":"$self","definition":"my","containerName":"write_population","localvar":"my"},{"line":302,"kind":13,"containerName":"write_population","name":"@inds"},{"kind":13,"line":303,"containerName":"write_population","name":"$self"},{"kind":12,"line":303,"containerName":"write_population","name":"throw_not_implemented"}],"line":301,"kind":12,"signature":{"label":"write_population($self,@inds)","documentation":"1;\n# $Id: hapmap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::hapmap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rich Dobson <r.j.dobson-at-qmul.ac.uk>\n#\n# Copyright Rich Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::hapmap - A parser for HapMap output data\n\n=head1 SYNOPSIS\n\n  # Do not use directly, use through the Bio::PopGen::IO driver\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'hapmap',\n                               -file   => 'data.hapmap');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n=head1 DESCRIPTION\n\nA driver module for Bio::PopGen::IO for parsing hapmap data.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Rich Dobson\n\nEmail r.j.dobson-at-qmul.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::IO::hapmap;\nuse vars qw($FieldDelim $AlleleDelim $NoHeader $StartingCol);\nuse strict;\n\n($FieldDelim,$AlleleDelim,$NoHeader,$StartingCol) =( '\\s+','',0,11);\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::hapmap->new();\n Function: Builds a new Bio::PopGen::IO::hapmap object \n Returns : an instance of Bio::PopGen::IO::hapmap\n Args    : [optional, these are the current defaults] \n           -field_delimiter => ','\n           -allele_delimiter=> '\\s+'\n           -no_header       => 0,\n           -starting_column => 11\n\n\n\nsub _initialize  {\n\n    my($self, @args) = @_;\n\n    $Bio::PopGen::Genotype::BlankAlleles='';\n\n    my ($fieldsep,$all_sep, \n\t$noheader, $start_col) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t\t       ALLELE_DELIMITER\n\t\t\t\t\t\t       NO_HEADER\n\t\t\t\t\t\t       STARTING_COLUMN)],\n\t\t\t\t\t\t   @args);\n\n    $self->flag('no_header', defined $noheader ? $noheader : $NoHeader);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->flag('allele_delimiter',defined $all_sep ? $all_sep : $AlleleDelim);\n    $self->starting_column(defined $start_col ? $start_col : $StartingCol );\n\n    $self->{'_header'} = undef;\n    return 1;\n\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'no_header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\nsub flag  {\n\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n\n}\n\nsub _pivot {\n    my ($self) = @_;\n\n    my (@cols,@rows,@idheader);\n    while ($_ = $self->_readline){\n\tchomp($_);\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\tif( /^rs\\#\\s+alleles\\s+chrom\\s+pos\\s+strand/ ) {\n\t    @idheader = split $self->flag('field_delimiter');\n\t} else { \n\t    push @cols, [split $self->flag('field_delimiter')];\n\t}\n    }\n    my $startingcol = $self->starting_column;\n\n    $self->{'_header'} = [ map { $_->[0] } @cols];\n    for my $n ($startingcol.. $#{ $cols[ 0 ]}) { \n\tmy $column = [ $idheader[$n],\n\t\t       map{ $_->[ $n ] } @cols ];\t\n\tpush (@rows, $column); \n    }\n    $self->{'_pivot'} = [@rows];\n    $self->{'_i'} = 0;\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : A Bio::PopGen::IndividualI object\n Args    : none\n\nSee L<Bio::PopGen::IndividualI>\n\n\nsub next_individual  {\n    my ($self) = @_;\n    unless($self->{'_pivot'}){\n\t#if it's the first time then pivot the table and store.\n\t#Lines will now be read from the stored pivot version of the input file\n\t$self->_pivot;\n    }\n\n    $_ = $self->{'_pivot'}->[$self->{'_i'}++];\n\n    return unless defined $_;\n\n    # Store all the marker related info. Now that the pivot has taken\n    # place this is in the first few lines of the file Maybe this\n    # should be put in a marker object. Doesn't seem to fit too well\n    # though\n\n    my ($samp,@marker_results) = @$_;\n\n    # at some point use all this info\n    my $i = 1;\n    foreach my $m ( @marker_results ) {\n\t$m =~ s/^\\s+//;\n\t$m =~ s/\\s+$//;\n\tmy $markername;\n\tif( defined $self->{'_header'} ) {\n\t    $markername = $self->{'_header'}->[$i-1];\n\t} else { \n\t    $markername = \"Marker$i\";\n\t}\n\n\tmy @alleles = split($self->flag('allele_delimiter'), $m);\n\tif( @alleles != 2 ) { \n\t    $self->warn(\"$m for $samp\\n\");\n\t} else { \n\t    $m = Bio::PopGen::Genotype->new(-alleles      => \\@alleles,\n\t\t\t\t\t   -marker_name  => $markername,\n\t\t\t\t\t   -individual_id=> $samp);\n\t}\n\t$i++; \n    }\n\n    return new Bio::PopGen::Individual(-unique_id => $samp,\n\t\t\t\t       -genotypes => \\@marker_results);\n\n}\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : Bio::PopGen::PopulationI object\n Args    : none\n Note    : Many implementation will not implement this\n\nSee L<Bio::PopGen::PopulationI>\n\n\nsub next_population {\n    my ($self) = @_;\n    my @inds;\n    while( my $ind = $self->next_individual ) {\n\tpush @inds, $ind;\n    }\n    Bio::PopGen::Population->new(-individuals => \\@inds);\n}\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the file format\n           NOT SUPPORTED  BY hapmap format\n Returns : none\n Args    : Bio::PopGen::PopulationI object(s)\n\nSee L<Bio::PopGen::PopulationI>\n\n\nsub write_individual {\n    my ($self,@inds) = @_;\n\n    # data from hapmap is output, not input, so \n    # we don't need a method for writing and input file\n\n    $self->throw_not_implemented();\n}\n\n=head2 write_population\n\n Title   : write_population\n Usage   : $popgenio->write_population($pop);\n Function: Write a population out in the file format\n           NOT SUPPORTED  BY hapmap format\n Returns : none\n Args    : Bio::PopGen::PopulationI object(s)\n Note    : Many implementation will not implement this\n\nSee L<Bio::PopGen::PopulationI>","parameters":[{"label":"$self"},{"label":"@inds"}]},"detail":"($self,@inds)","definition":"sub","containerName":"main::"},{"children":[{"localvar":"my","containerName":"starting_column","name":"$self","definition":"my","line":319,"kind":13},{"name":"$self","containerName":"starting_column","line":321,"kind":13},{"name":"$self","containerName":"starting_column","line":322,"kind":13}],"line":318,"kind":12,"range":{"start":{"line":318,"character":0},"end":{"line":323,"character":9999}},"name":"starting_column","definition":"sub","containerName":"main::"}],"version":5}