{"vars":[{"kind":2,"line":310,"name":"Storable","containerName":""},{"line":312,"kind":2,"name":"vars","containerName":""},{"line":316,"kind":2,"containerName":"","name":"base"},{"localvar":"my","containerName":null,"definition":"my","name":"$USAGE","line":318,"kind":13},{"range":{"start":{"line":339,"character":0},"end":{"character":9999,"line":377}},"name":"new","children":[{"kind":13,"line":340,"definition":"my","name":"$class","containerName":"new","localvar":"my"},{"line":340,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":342,"definition":"my","name":"$self","containerName":"new","localvar":"my"},{"name":"$class","containerName":"new","kind":13,"line":342},{"kind":13,"line":342,"containerName":"new","name":"@args"},{"line":343,"kind":13,"localvar":"my","name":"$haplotype_block","definition":"my","containerName":"new"},{"kind":13,"line":344,"containerName":"new","name":"$snp_ids"},{"containerName":"new","name":"$pattern_freq","line":345,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":345},{"name":"_rearrange","containerName":"new","line":345,"kind":12},{"name":"@args","containerName":"new","kind":13,"line":347},{"name":"$haplotype_block","containerName":"new","kind":13,"line":349},{"kind":13,"line":350,"name":"$self","containerName":"new"},{"containerName":"new","name":"haplotype_block","line":350,"kind":12},{"kind":13,"line":350,"containerName":"new","name":"$haplotype_block"},{"kind":13,"line":353,"containerName":"new","name":"$self"},{"containerName":"new","name":"throw","kind":12,"line":353},{"containerName":"new","name":"$snp_ids","line":356,"kind":13},{"line":357,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"snp_ids","kind":12,"line":357},{"name":"$snp_ids","containerName":"new","line":357,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":360},{"name":"throw","containerName":"new","kind":12,"line":360},{"line":363,"kind":13,"containerName":"new","name":"$pattern_freq"},{"name":"$self","containerName":"new","kind":13,"line":364},{"name":"pattern_freq","containerName":"new","line":364,"kind":12},{"containerName":"new","name":"$pattern_freq","line":364,"kind":13},{"name":"$self","containerName":"new","line":367,"kind":13},{"kind":12,"line":367,"containerName":"new","name":"throw"},{"kind":13,"line":372,"containerName":"new","name":"$self"},{"kind":13,"line":374,"name":"$self","containerName":"new"},{"line":376,"kind":13,"name":"$self","containerName":"new"}],"line":339,"kind":12,"signature":{"documentation":"1;\n# module Bio::PopGen::HtSNP.pm\n# cared by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n#\n\n=head1 NAME\n\nBio::PopGen::HtSNP.pm- Select htSNP from a haplotype set\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::HtSNP;\n\n    my $obj = Bio::PopGen::HtSNP->new($hap,$snp,$pop);\n\n=head1 DESCRIPTION\n\nSelect the minimal set of SNP that contains the full information about\nthe haplotype without redundancies.\n\nTake as input the followin values:\n\n=over 4\n\n* - the haplotype block (array of array).\n\n* - the snp id (array).\n\n* - family information and frequency (array of array).\n\n\nThe final haplotype is generated in a numerical format and the SNP's\nsets can be retrieve from the module.\n\nB<considerations:>\n\n\n- If you force to include a family with indetermination, the SNP's\nwith indetermination will be removed from the analysis, so consider\nbefore to place your data set what do you really want to do.\n\n- If two families have the same information (identical haplotype), one\nof them will be removed and the removed files will be stored classify\nas removed.\n\n- Only are accepted for calculation A, C, G, T and - (as deletion) and\ntheir combinations. Any other value as n or ? will be considered as\ndegenerations due to lack of information.\n\n=head2 RATIONALE\n\nOn a haplotype set is expected that some of the SNP and their\nvariations contribute in the same way to the haplotype. Eliminating\nredundancies will produce a minimal set of SNP's that can be used as\ninput for a taging selection process. On the process SNP's with the\nsame variation are clustered on the same group.\n\nThe idea is that because the tagging haplotype process is\nexponential. All redundant information we could eliminate on the\ntagging process will help to find a quick result.\n\n=head2 CONSTRUCTORS\n\n  my $obj = Bio::PopGen::HtSNP->new\n    (-haplotype_block => \\@haplotype_patterns,\n     -snp_ids         => \\@snp_ids,\n     -pattern_freq    => \\@pattern_name_and_freq);\n\nwhere  $hap, $snp and $pop are in the format:\n\n  my $hap = [\n             'acgt',\n             'agtc',\n             'cgtc'\n            ];                     # haplotype patterns' id\n\n  my $snp = [qw/s1 s2 s3 s4/];     # snps' Id's\n\n  my $pop = [\n             [qw/ uno    0.20/],\n             [qw/ dos    0.20/],\n             [qw/ tres   0.15/],\n            ];                     # haplotype_pattern_id    Frequency\n\n=head2 OBJECT METHODS\n\n    See Below for more detailed summaries.\n\n\n=head1 DETAILS\n\n=head2 How the process is working with one example\n\nLet's begin with one general example of the code.\n\nInput haplotype:\n\n  acgtcca-t\n  cggtagtgc\n  cccccgtgc\n  cgctcgtgc\n\nThe first thing to to is to B<split the haplotype> into characters.\n\n  a       c       g       t       c       c       a       -       t\n  c       g       g       t       a       g       t       g       c\n  c       c       c       c       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n\nNow we have to B<convert> the haplotype to B<Upercase>. This\nwill produce the same SNP if we have input a or A.\n\n  A       C       G       T       C       C       A       -       T\n  C       G       G       T       A       G       T       G       C\n  C       C       C       C       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n\nThe program admit as values any combination of ACTG and - (deletions).\nThe haplotype is B<converted to number>, considering the first variation\nas zero and the alternate value as 1 (see expanded description below).\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n\nOnce we have the haplotype converted to numbers we have to generate the\nsnp type information for the haplotype.\n\n\nB<SNP code = SUM ( value * multiplicity ^ position );>\n\n    where:\n      SUM is the sum of the values for the SNP\n      value is the SNP number code (0 [generally for the mayor allele],\n                                    1 [for the minor allele].\n      position is the position on the block.\n\nFor this example the code is:\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n ------------------------------------------------------------------\n  14      10      12      4       2       14      14      14      14\n\n  14 = 0*2^0 + 1*2^1 + 1*2^2 + 1*2^3\n  12 = 0*2^0 + 1*2^1 + 0*2^2 + 1*2^3\n  ....\n\nOnce we have the families classify. We will B<take> just the SNP's B<not\nredundant>.\n\n  14      10      12      4       2\n\nThis information will be B<passed to the tag module> is you want to tag\nthe htSNP.\n\nWhatever it happens to one SNPs of a class will happen to a SNP of\nthe same class. Therefore you don't need to scan redundancies\n\n=head2 Working with fuzzy data.\n\nThis module is designed to work with fuzzy data. As the source of the\nhaplotype is diverse. The program assume that some haplotypes can be\ngenerated using different values. If there is any indetermination (? or n)\nor any other degenerated value or invalid. The program will take away\nThis SNP and will leave that for a further analysis.\n\nOn a complex situation:\n\n  a       c       g       t       ?       c       a       c       t\n  a       c       g       t       ?       c       a       -       t\n  c       g       ?       t       a       g       ?       g       c\n  c       a       c       t       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n  c       g       g       t       a       g       ?       g       c\n  a       c       ?       t       ?       c       a       c       t\n\nOn this haplotype everything is happening. We have a multialelic variance.\nWe have indeterminations. We have deletions and we have even one SNP\nwhich is not a real SNP.\n\nThe buiding process will be the same on this situation.\n\nConvert the haplotype to uppercase.\n\n  A       C       G       T       ?       C       A       C       T\n  A       C       G       T       ?       C       A       -       T\n  C       G       ?       T       A       G       ?       G       C\n  C       A       C       T       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n  C       G       G       T       A       G       ?       G       C\n  A       C       ?       T       ?       C       A       C       T\n\nAll columns that present indeterminations will be removed from the analysis\non this Step.\n\nhapotype after remove columns:\n\n  A       C       T       C       C       T\n  A       C       T       C       -       T\n  C       G       T       G       G       C\n  C       A       T       G       G       C\n  C       G       T       G       G       C\n  C       G       T       G       G       C\n  A       C       T       C       C       T\n\nAll changes made on the haplotype matrix, will be also made on the SNP list.\n\n  snp_id_1 snp_id_2 snp_id_4 snp_id_6 snp_id_8 snp_id_9\n\nnow the SNP that is not one SNP will be removed from the analysis.\nSNP with Id snp_id_4 (the one with all T's).\n\n\nbecause of the removing. Some of the families will become the same and will\nbe clustered. A posteriori analysis will diference these families.\nbut because of the indetermination can not be distinguish.\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n  C       G       G       G       C\n  C       G       G       G       C\n  A       C       C       C       T\n\nThe result of the mergering will go like:\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n\nOnce again the changes made on the families and we merge the frequency (I<to be\nimplemented>)\n\nBefore to convert the haplotype into numbers we consider how many variations\nwe have on the set. On this case the variations are 3.\n\nThe control code will use on this situation base three as mutiplicity\n\n  0       0       0       0       0\n  0       0       0       1       0\n  1       1       1       2       1\n  1       2       1       2       1\n -----------------------------------\n  36      63      36      75      36\n\nAnd the minimal set for this combination is\n\n  0       0       0\n  0       0       1\n  1       1       2\n  1       2       2\n\nB<NOTE:> this second example is a remote example an on normal conditions. This\nconditions makes no sense, but as the haplotypes, can come from many sources\nwe have to be ready for all kind of combinations.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PopGen::HtSNP;\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse vars qw ();\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = 'Usage:\n\n    Bio::PopGen::HtSNP->new(-haplotype_block -ids -pattern_freq)\n\n';\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Usage   : $obj-> Bio::PopGen::HtSNP->new(-haplotype_block\n                                          -snp_ids\n                                          -pattern_freq)\n Returns : self hash\n Args    : input haplotype (array of array)\n           snp_ids         (array)\n           pop_freq        (array of array)\n Status  : public","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::"},{"name":"SUPER","containerName":"new","kind":12,"line":342},{"kind":12,"line":372,"name":"_check_input"},{"name":"_do_it","line":374,"kind":12},{"line":390,"children":[{"line":391,"kind":13,"localvar":"my","containerName":"haplotype_block","name":"$self","definition":"my"},{"containerName":"haplotype_block","name":"$self","kind":13,"line":392},{"line":393,"kind":13,"name":"$self","containerName":"haplotype_block"}],"kind":12,"range":{"start":{"character":0,"line":390},"end":{"character":9999,"line":394}},"containerName":"main::","name":"haplotype_block","definition":"sub"},{"containerName":"main::","name":"snp_ids","definition":"sub","range":{"end":{"character":9999,"line":411},"start":{"character":0,"line":407}},"kind":12,"line":407,"children":[{"kind":13,"line":408,"name":"$self","definition":"my","containerName":"snp_ids","localvar":"my"},{"containerName":"snp_ids","name":"$self","line":409,"kind":13},{"line":410,"kind":13,"containerName":"snp_ids","name":"$self"}]},{"children":[{"containerName":"pattern_freq","name":"$self","definition":"my","localvar":"my","kind":13,"line":426},{"kind":13,"line":427,"name":"$self","containerName":"pattern_freq"},{"line":428,"kind":13,"containerName":"pattern_freq","name":"$self"}],"line":425,"kind":12,"range":{"end":{"character":9999,"line":429},"start":{"line":425,"character":0}},"definition":"sub","name":"pattern_freq","containerName":"main::"},{"name":"_check_input","definition":"sub","containerName":"main::","range":{"end":{"line":451,"character":9999},"start":{"character":0,"line":443}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_check_input","line":446,"kind":13},{"line":448,"kind":13,"name":"$self","containerName":"_check_input"},{"name":"$self","containerName":"_check_input","line":449,"kind":13}],"line":443},{"name":"_haplotype_length_error","line":448,"kind":12},{"name":"_population_error","line":449,"kind":12},{"kind":12,"line":467,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_haplotype_length_error","line":470,"kind":13},{"kind":13,"line":472,"name":"$input_block","definition":"my","containerName":"_haplotype_length_error","localvar":"my"},{"containerName":"_haplotype_length_error","name":"$self","kind":13,"line":472},{"name":"haplotype_block","containerName":"_haplotype_length_error","line":472,"kind":12},{"line":473,"kind":13,"localvar":"my","name":"$snp_ids","definition":"my","containerName":"_haplotype_length_error"},{"line":473,"kind":13,"containerName":"_haplotype_length_error","name":"$self"},{"containerName":"_haplotype_length_error","name":"snp_ids","kind":12,"line":473},{"localvar":"my","containerName":"_haplotype_length_error","name":"$different_haplotype_length","definition":"my","line":479,"kind":13},{"line":486,"kind":13,"localvar":"my","definition":"my","name":"$snp_number","containerName":"_haplotype_length_error"},{"kind":13,"line":487,"name":"$number_of_families","definition":"my","containerName":"_haplotype_length_error","localvar":"my"},{"line":487,"kind":13,"containerName":"_haplotype_length_error","name":"$input_block"},{"line":488,"kind":13,"localvar":"my","name":"$h","definition":"my","containerName":"_haplotype_length_error"},{"containerName":"_haplotype_length_error","name":"$h","kind":13,"line":497},{"line":497,"kind":13,"containerName":"_haplotype_length_error","name":"$h"},{"kind":13,"line":497,"name":"$input_block","containerName":"_haplotype_length_error"},{"kind":13,"line":497,"containerName":"_haplotype_length_error","name":"$h"},{"line":498,"kind":13,"containerName":"_haplotype_length_error","name":"$input_block"},{"line":498,"kind":13,"containerName":"_haplotype_length_error","name":"$h"},{"kind":13,"line":498,"name":"$snp_number","containerName":"_haplotype_length_error"},{"containerName":"_haplotype_length_error","name":"$different_haplotype_length","kind":13,"line":499},{"containerName":"_haplotype_length_error","name":"$different_haplotype_length","line":505,"kind":13},{"line":506,"kind":13,"name":"$self","containerName":"_haplotype_length_error"},{"name":"throw","containerName":"_haplotype_length_error","line":506,"kind":12},{"line":507,"kind":13,"containerName":"_haplotype_length_error","name":"$h"},{"kind":13,"line":508,"containerName":"_haplotype_length_error","name":"$input_block"},{"name":"$h","containerName":"_haplotype_length_error","kind":13,"line":508},{"name":"$input_block","containerName":"_haplotype_length_error","kind":13,"line":509},{"line":509,"kind":13,"name":"$h","containerName":"_haplotype_length_error"}],"containerName":"main::","name":"_haplotype_length_error","definition":"sub","range":{"start":{"character":0,"line":467},"end":{"character":9999,"line":511}}},{"children":[{"kind":13,"line":531,"name":"$self","definition":"my","containerName":"_population_error","localvar":"my"},{"name":"$input_block","definition":"my","containerName":"_population_error","localvar":"my","kind":13,"line":533},{"line":533,"kind":13,"containerName":"_population_error","name":"$self"},{"kind":12,"line":533,"containerName":"_population_error","name":"haplotype_block"},{"line":534,"kind":13,"localvar":"my","name":"$pop_freq","definition":"my","containerName":"_population_error"},{"kind":13,"line":534,"containerName":"_population_error","name":"$self"},{"containerName":"_population_error","name":"pattern_freq","kind":12,"line":534},{"kind":13,"line":539,"definition":"my","name":"$pop_freq_elements_error","containerName":"_population_error","localvar":"my"},{"kind":13,"line":545,"containerName":"_population_error","definition":"my","name":"$number_of_families","localvar":"my"},{"kind":13,"line":545,"containerName":"_population_error","name":"$input_block"},{"line":547,"kind":13,"localvar":"my","containerName":"_population_error","definition":"my","name":"$pf"},{"definition":"my","name":"$frequency","containerName":"_population_error","localvar":"my","kind":13,"line":548},{"localvar":"my","definition":"my","name":"$p_f_length","containerName":"_population_error","line":549,"kind":13},{"containerName":"_population_error","name":"$pf","line":562,"kind":13},{"name":"$pf","containerName":"_population_error","kind":13,"line":562},{"kind":13,"line":562,"name":"$pop_freq","containerName":"_population_error"},{"name":"$pf","containerName":"_population_error","line":562,"kind":13},{"kind":13,"line":563,"name":"$frequency","containerName":"_population_error"},{"containerName":"_population_error","name":"$pop_freq","line":563,"kind":13},{"containerName":"_population_error","name":"$pf","kind":13,"line":563},{"kind":13,"line":565,"containerName":"_population_error","name":"$pop_freq"},{"containerName":"_population_error","name":"$pf","kind":13,"line":565},{"containerName":"_population_error","name":"$p_f_length","line":566,"kind":13},{"kind":13,"line":566,"name":"$pop_freq","containerName":"_population_error"},{"name":"$pf","containerName":"_population_error","line":566,"kind":13},{"name":"$pop_freq_elements_error","containerName":"_population_error","kind":13,"line":567}],"line":528,"kind":12,"range":{"start":{"line":528,"character":0},"end":{"line":569,"character":9999}},"name":"_population_error","definition":"sub","containerName":"main::"},{"line":578,"kind":13,"name":"%frequency","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":579},{"name":"warn","containerName":"main::","line":579,"kind":12},{"kind":13,"line":583,"containerName":null,"name":"%pop_freq_elements_error"},{"containerName":null,"name":"$self","line":584,"kind":13},{"line":584,"kind":12,"containerName":"main::","name":"throw"},{"line":585,"kind":13,"containerName":null,"name":"$pf"},{"name":"$pf","containerName":null,"kind":13,"line":595},{"line":595,"kind":13,"containerName":null,"name":"%number_of_families"},{"line":596,"kind":13,"containerName":null,"name":"$self"},{"line":596,"kind":12,"containerName":"main::","name":"throw"},{"children":[{"line":618,"kind":13,"localvar":"my","containerName":"_do_it","name":"$self","definition":"my"},{"name":"$self","containerName":"_do_it","kind":13,"line":621},{"line":622,"kind":13,"name":"$self","containerName":"_do_it"},{"line":622,"kind":13,"containerName":"_do_it","name":"$self"},{"kind":12,"line":622,"name":"pattern_freq","containerName":"_do_it"},{"name":"$self","containerName":"_do_it","line":623,"kind":13},{"name":"$self","containerName":"_do_it","kind":13,"line":624},{"kind":13,"line":625,"containerName":"_do_it","name":"$self"},{"line":626,"kind":13,"name":"$self","containerName":"_do_it"},{"name":"$self","containerName":"_do_it","kind":13,"line":627},{"containerName":"_do_it","name":"$self","kind":13,"line":628},{"name":"$self","containerName":"_do_it","kind":13,"line":629},{"line":633,"kind":13,"containerName":"_do_it","name":"$self"},{"line":633,"kind":13,"name":"$self","containerName":"_do_it"},{"containerName":"_do_it","name":"snp_ids","line":633,"kind":12},{"kind":13,"line":634,"containerName":"_do_it","name":"$self"},{"kind":13,"line":635,"name":"$self","containerName":"_do_it"},{"name":"$self","containerName":"_do_it","kind":13,"line":638},{"name":"$self","containerName":"_do_it","kind":13,"line":642},{"name":"$self","containerName":"_do_it","kind":13,"line":648},{"line":656,"kind":13,"name":"$self","containerName":"_do_it"},{"name":"$self","containerName":"_do_it","kind":13,"line":672},{"localvar":"my","definition":"my","name":"@tmp","containerName":"_do_it","line":696,"kind":13},{"line":696,"kind":13,"containerName":"_do_it","name":"$a"},{"kind":13,"line":696,"containerName":"_do_it","name":"$b"},{"name":"$self","containerName":"_do_it","line":697,"kind":13}],"line":615,"kind":12,"range":{"start":{"line":615,"character":0},"end":{"line":697,"character":9999}},"definition":"sub","name":"_do_it","containerName":"main::"},{"name":"dclone","line":622,"kind":12},{"name":"snp_type","kind":12,"line":633},{"name":"useful_snp","line":633,"kind":12},{"kind":12,"line":633,"name":"dclone"},{"name":"snp_type","line":634,"kind":12},{"line":634,"kind":12,"name":"deg_snp"},{"kind":12,"line":635,"name":"snp_type"},{"kind":12,"line":635,"name":"silent_snp"},{"kind":12,"line":638,"name":"_split_haplo"},{"line":642,"kind":12,"name":"_to_upper_case"},{"kind":12,"line":642,"name":"w_hap"},{"kind":12,"line":648,"name":"_remove_deg"},{"line":656,"kind":12,"name":"_rem_silent_snp"},{"name":"_find_deg_pattern","line":672,"kind":12},{"line":697,"kind":12,"name":"deg_pattern"},{"kind":12,"line":702,"name":"tmp"},{"containerName":null,"name":"%self","kind":13,"line":702},{"kind":12,"line":702,"name":"w_hap"},{"kind":12,"line":703,"name":"_keep_these_patterns"},{"name":"%self","containerName":null,"line":703,"kind":13},{"line":703,"kind":12,"name":"w_hap"},{"containerName":null,"name":"@tmp","kind":13,"line":703},{"kind":12,"line":704,"name":"_keep_these_patterns"},{"containerName":null,"name":"%self","kind":13,"line":704},{"name":"w_pop_freq","kind":12,"line":704},{"kind":13,"line":704,"name":"@tmp","containerName":null},{"name":"_alleles_number","line":720,"kind":12},{"name":"$self","containerName":null,"line":720,"kind":13},{"name":"_convert_to_numbers","kind":12,"line":739},{"line":739,"kind":13,"containerName":null,"name":"$self"},{"name":"_snp_type_code","kind":12,"line":747},{"containerName":null,"name":"$self","kind":13,"line":747},{"name":"_htSNP","kind":12,"line":754},{"kind":13,"line":754,"containerName":null,"name":"$self"},{"line":765,"kind":12,"name":"_snp_and_code_summary"},{"kind":13,"line":765,"name":"$self","containerName":null},{"kind":12,"line":780,"children":[{"definition":"my","name":"$self","containerName":"input_block","localvar":"my","kind":13,"line":783},{"kind":13,"line":784,"containerName":"input_block","name":"$self"}],"containerName":"main::","definition":"sub","name":"input_block","range":{"end":{"character":9999,"line":785},"start":{"line":780,"character":0}}},{"line":784,"kind":12,"name":"input_block"},{"range":{"end":{"character":9999,"line":803},"start":{"line":799,"character":0}},"containerName":"main::","definition":"sub","name":"hap_length","line":799,"children":[{"name":"$self","definition":"my","containerName":"hap_length","localvar":"my","kind":13,"line":802},{"containerName":"hap_length","name":"$self","line":803,"kind":13}],"kind":12},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"pop_freq","line":822,"kind":13},{"name":"$self","containerName":"pop_freq","line":823,"kind":13}],"line":819,"kind":12,"range":{"end":{"line":824,"character":9999},"start":{"line":819,"character":0}},"definition":"sub","name":"pop_freq","containerName":"main::"},{"line":823,"kind":12,"name":"pop_freq"},{"kind":12,"line":840,"children":[{"kind":13,"line":842,"name":"$self","definition":"my","containerName":"deg_snp","localvar":"my"},{"containerName":"deg_snp","name":"$self","line":843,"kind":13}],"containerName":"main::","definition":"sub","name":"deg_snp","range":{"start":{"character":0,"line":840},"end":{"character":9999,"line":844}}},{"name":"snp_type","kind":12,"line":843},{"kind":12,"line":843,"name":"deg_snp"},{"children":[{"containerName":"snp_type","name":"$self","definition":"my","localvar":"my","kind":13,"line":862},{"kind":13,"line":863,"name":"$self","containerName":"snp_type"}],"line":860,"kind":12,"range":{"end":{"line":864,"character":9999},"start":{"character":0,"line":860}},"name":"snp_type","definition":"sub","containerName":"main::"},{"line":863,"kind":12,"name":"snp_type"},{"kind":12,"line":881,"children":[{"localvar":"my","containerName":"silent_snp","name":"$self","definition":"my","line":883,"kind":13},{"containerName":"silent_snp","name":"$self","kind":13,"line":884}],"containerName":"main::","name":"silent_snp","definition":"sub","range":{"end":{"character":9999,"line":885},"start":{"character":0,"line":881}}},{"name":"snp_type","kind":12,"line":884},{"line":884,"kind":12,"name":"silent_snp"},{"range":{"end":{"line":907,"character":9999},"start":{"line":903,"character":0}},"containerName":"main::","name":"useful_snp","definition":"sub","line":903,"children":[{"kind":13,"line":905,"containerName":"useful_snp","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"useful_snp","kind":13,"line":906}],"kind":12},{"name":"snp_type","line":906,"kind":12},{"line":906,"kind":12,"name":"useful_snp"},{"range":{"start":{"line":925,"character":0},"end":{"line":929,"character":9999}},"definition":"sub","name":"ht_type","containerName":"main::","children":[{"kind":13,"line":927,"definition":"my","name":"$self","containerName":"ht_type","localvar":"my"},{"name":"$self","containerName":"ht_type","line":928,"kind":13}],"line":925,"kind":12},{"kind":12,"line":928,"name":"ht_type"},{"line":946,"children":[{"kind":13,"line":948,"name":"$self","definition":"my","containerName":"ht_set","localvar":"my"},{"name":"$self","containerName":"ht_set","line":949,"kind":13}],"kind":12,"range":{"end":{"line":950,"character":9999},"start":{"character":0,"line":946}},"containerName":"main::","definition":"sub","name":"ht_set"},{"name":"w_hap","kind":12,"line":949},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"snp_type_code","line":968,"kind":13},{"kind":13,"line":969,"containerName":"snp_type_code","name":"$self"}],"line":966,"kind":12,"range":{"end":{"line":970,"character":9999},"start":{"character":0,"line":966}},"name":"snp_type_code","definition":"sub","containerName":"main::"},{"name":"snp_type_code","kind":12,"line":969},{"range":{"start":{"line":988,"character":0},"end":{"line":992,"character":9999}},"definition":"sub","name":"snp_and_code","containerName":"main::","children":[{"containerName":"snp_and_code","name":"$self","definition":"my","localvar":"my","kind":13,"line":990},{"kind":13,"line":991,"name":"$self","containerName":"snp_and_code"}],"line":988,"kind":12},{"children":[{"localvar":"my","containerName":"deg_pattern","definition":"my","name":"$self","line":1012,"kind":13},{"containerName":"deg_pattern","name":"$self","kind":13,"line":1014}],"line":1010,"kind":12,"range":{"start":{"character":0,"line":1010},"end":{"line":1015,"character":9999}},"definition":"sub","name":"deg_pattern","containerName":"main::"},{"range":{"start":{"line":1031,"character":0},"end":{"character":9999,"line":1035}},"containerName":"main::","name":"split_hap","definition":"sub","line":1031,"children":[{"kind":13,"line":1033,"definition":"my","name":"$self","containerName":"split_hap","localvar":"my"},{"containerName":"split_hap","name":"$self","kind":13,"line":1034}],"kind":12},{"range":{"start":{"line":1049,"character":0},"end":{"line":1062,"character":9999}},"containerName":"main::","definition":"sub","name":"_split_haplo","line":1049,"children":[{"definition":"my","name":"$self","containerName":"_split_haplo","localvar":"my","kind":13,"line":1051},{"containerName":"_split_haplo","name":"$in","definition":"my","localvar":"my","kind":13,"line":1053},{"name":"$self","containerName":"_split_haplo","kind":13,"line":1053},{"line":1054,"kind":13,"localvar":"my","containerName":"_split_haplo","definition":"my","name":"$out"},{"containerName":"_split_haplo","name":"$self","kind":13,"line":1054},{"containerName":"_split_haplo","name":"$in","kind":13,"line":1057},{"name":"$out","containerName":"_split_haplo","kind":13,"line":1058},{"line":1061,"kind":13,"containerName":"_split_haplo","name":"$self"},{"name":"$out","containerName":"_split_haplo","kind":13,"line":1061}],"kind":12},{"name":"dclone","line":1061,"kind":12},{"kind":12,"children":[{"localvar":"my","containerName":"_to_upper_case","definition":"my","name":"$arr","line":1082,"kind":13},{"containerName":"_to_upper_case","name":"$aref","definition":"my","localvar":"my","kind":13,"line":1084},{"name":"$arr","containerName":"_to_upper_case","kind":13,"line":1084},{"localvar":"my","definition":"my","name":"$value","containerName":"_to_upper_case","line":1085,"kind":13},{"containerName":"_to_upper_case","name":"$aref","kind":13,"line":1085},{"line":1086,"kind":13,"name":"$value","containerName":"_to_upper_case"},{"name":"$value","containerName":"_to_upper_case","kind":13,"line":1086}],"line":1080,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# module Bio::PopGen::HtSNP.pm\n# cared by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n#\n\n=head1 NAME\n\nBio::PopGen::HtSNP.pm- Select htSNP from a haplotype set\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::HtSNP;\n\n    my $obj = Bio::PopGen::HtSNP->new($hap,$snp,$pop);\n\n=head1 DESCRIPTION\n\nSelect the minimal set of SNP that contains the full information about\nthe haplotype without redundancies.\n\nTake as input the followin values:\n\n=over 4\n\n* - the haplotype block (array of array).\n\n* - the snp id (array).\n\n* - family information and frequency (array of array).\n\n\nThe final haplotype is generated in a numerical format and the SNP's\nsets can be retrieve from the module.\n\nB<considerations:>\n\n\n- If you force to include a family with indetermination, the SNP's\nwith indetermination will be removed from the analysis, so consider\nbefore to place your data set what do you really want to do.\n\n- If two families have the same information (identical haplotype), one\nof them will be removed and the removed files will be stored classify\nas removed.\n\n- Only are accepted for calculation A, C, G, T and - (as deletion) and\ntheir combinations. Any other value as n or ? will be considered as\ndegenerations due to lack of information.\n\n=head2 RATIONALE\n\nOn a haplotype set is expected that some of the SNP and their\nvariations contribute in the same way to the haplotype. Eliminating\nredundancies will produce a minimal set of SNP's that can be used as\ninput for a taging selection process. On the process SNP's with the\nsame variation are clustered on the same group.\n\nThe idea is that because the tagging haplotype process is\nexponential. All redundant information we could eliminate on the\ntagging process will help to find a quick result.\n\n=head2 CONSTRUCTORS\n\n  my $obj = Bio::PopGen::HtSNP->new\n    (-haplotype_block => \\@haplotype_patterns,\n     -snp_ids         => \\@snp_ids,\n     -pattern_freq    => \\@pattern_name_and_freq);\n\nwhere  $hap, $snp and $pop are in the format:\n\n  my $hap = [\n             'acgt',\n             'agtc',\n             'cgtc'\n            ];                     # haplotype patterns' id\n\n  my $snp = [qw/s1 s2 s3 s4/];     # snps' Id's\n\n  my $pop = [\n             [qw/ uno    0.20/],\n             [qw/ dos    0.20/],\n             [qw/ tres   0.15/],\n            ];                     # haplotype_pattern_id    Frequency\n\n=head2 OBJECT METHODS\n\n    See Below for more detailed summaries.\n\n\n=head1 DETAILS\n\n=head2 How the process is working with one example\n\nLet's begin with one general example of the code.\n\nInput haplotype:\n\n  acgtcca-t\n  cggtagtgc\n  cccccgtgc\n  cgctcgtgc\n\nThe first thing to to is to B<split the haplotype> into characters.\n\n  a       c       g       t       c       c       a       -       t\n  c       g       g       t       a       g       t       g       c\n  c       c       c       c       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n\nNow we have to B<convert> the haplotype to B<Upercase>. This\nwill produce the same SNP if we have input a or A.\n\n  A       C       G       T       C       C       A       -       T\n  C       G       G       T       A       G       T       G       C\n  C       C       C       C       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n\nThe program admit as values any combination of ACTG and - (deletions).\nThe haplotype is B<converted to number>, considering the first variation\nas zero and the alternate value as 1 (see expanded description below).\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n\nOnce we have the haplotype converted to numbers we have to generate the\nsnp type information for the haplotype.\n\n\nB<SNP code = SUM ( value * multiplicity ^ position );>\n\n    where:\n      SUM is the sum of the values for the SNP\n      value is the SNP number code (0 [generally for the mayor allele],\n                                    1 [for the minor allele].\n      position is the position on the block.\n\nFor this example the code is:\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n ------------------------------------------------------------------\n  14      10      12      4       2       14      14      14      14\n\n  14 = 0*2^0 + 1*2^1 + 1*2^2 + 1*2^3\n  12 = 0*2^0 + 1*2^1 + 0*2^2 + 1*2^3\n  ....\n\nOnce we have the families classify. We will B<take> just the SNP's B<not\nredundant>.\n\n  14      10      12      4       2\n\nThis information will be B<passed to the tag module> is you want to tag\nthe htSNP.\n\nWhatever it happens to one SNPs of a class will happen to a SNP of\nthe same class. Therefore you don't need to scan redundancies\n\n=head2 Working with fuzzy data.\n\nThis module is designed to work with fuzzy data. As the source of the\nhaplotype is diverse. The program assume that some haplotypes can be\ngenerated using different values. If there is any indetermination (? or n)\nor any other degenerated value or invalid. The program will take away\nThis SNP and will leave that for a further analysis.\n\nOn a complex situation:\n\n  a       c       g       t       ?       c       a       c       t\n  a       c       g       t       ?       c       a       -       t\n  c       g       ?       t       a       g       ?       g       c\n  c       a       c       t       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n  c       g       g       t       a       g       ?       g       c\n  a       c       ?       t       ?       c       a       c       t\n\nOn this haplotype everything is happening. We have a multialelic variance.\nWe have indeterminations. We have deletions and we have even one SNP\nwhich is not a real SNP.\n\nThe buiding process will be the same on this situation.\n\nConvert the haplotype to uppercase.\n\n  A       C       G       T       ?       C       A       C       T\n  A       C       G       T       ?       C       A       -       T\n  C       G       ?       T       A       G       ?       G       C\n  C       A       C       T       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n  C       G       G       T       A       G       ?       G       C\n  A       C       ?       T       ?       C       A       C       T\n\nAll columns that present indeterminations will be removed from the analysis\non this Step.\n\nhapotype after remove columns:\n\n  A       C       T       C       C       T\n  A       C       T       C       -       T\n  C       G       T       G       G       C\n  C       A       T       G       G       C\n  C       G       T       G       G       C\n  C       G       T       G       G       C\n  A       C       T       C       C       T\n\nAll changes made on the haplotype matrix, will be also made on the SNP list.\n\n  snp_id_1 snp_id_2 snp_id_4 snp_id_6 snp_id_8 snp_id_9\n\nnow the SNP that is not one SNP will be removed from the analysis.\nSNP with Id snp_id_4 (the one with all T's).\n\n\nbecause of the removing. Some of the families will become the same and will\nbe clustered. A posteriori analysis will diference these families.\nbut because of the indetermination can not be distinguish.\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n  C       G       G       G       C\n  C       G       G       G       C\n  A       C       C       C       T\n\nThe result of the mergering will go like:\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n\nOnce again the changes made on the families and we merge the frequency (I<to be\nimplemented>)\n\nBefore to convert the haplotype into numbers we consider how many variations\nwe have on the set. On this case the variations are 3.\n\nThe control code will use on this situation base three as mutiplicity\n\n  0       0       0       0       0\n  0       0       0       1       0\n  1       1       1       2       1\n  1       2       1       2       1\n -----------------------------------\n  36      63      36      75      36\n\nAnd the minimal set for this combination is\n\n  0       0       0\n  0       0       1\n  1       1       2\n  1       2       2\n\nB<NOTE:> this second example is a remote example an on normal conditions. This\nconditions makes no sense, but as the haplotypes, can come from many sources\nwe have to be ready for all kind of combinations.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PopGen::HtSNP;\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse vars qw ();\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = 'Usage:\n\n    Bio::PopGen::HtSNP->new(-haplotype_block -ids -pattern_freq)\n\n';\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Usage   : $obj-> Bio::PopGen::HtSNP->new(-haplotype_block\n                                          -snp_ids\n                                          -pattern_freq)\n Returns : self hash\n Args    : input haplotype (array of array)\n           snp_ids         (array)\n           pop_freq        (array of array)\n Status  : public\n\n\nsub new {\n    my($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($haplotype_block,\n        $snp_ids,\n        $pattern_freq    ) = $self->_rearrange([qw(HAPLOTYPE_BLOCK \n                                                   SNP_IDS\n                                                   PATTERN_FREQ)],@args);\n\n    if ($haplotype_block){\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"Haplotype block has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($snp_ids){\n        $self->snp_ids($snp_ids);\n    }\n    else{\n        $self->throw(\"Array with ids has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($pattern_freq){\n        $self->pattern_freq($pattern_freq);\n    }\n    else{\n        $self->throw(\"Array with pattern id and frequency has not been defined.\n                      \\n$USAGE\");\n    }\n\n    # if the input values are not well formed complained and exit.\n    _check_input($self);\n\n    _do_it($self);\n\n    return $self;\n}\n\n=head2 haplotype_block \n\n Title   : haplotype_block \n Usage   : my $haplotype_block = $HtSNP->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array \n Args    : reference of array with haplotype pattern \n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n=head2 snp_ids \n\n Title   : snp_ids \n Usage   : my $snp_ids = $HtSNP->$snp_ids();\n Function: Get the ids for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\n\nsub snp_ids{\n    my ($self) =shift;\n    return $self->{'_snp_ids'} = shift if @_;\n    return $self->{'_snp_ids'};\n}\n\n\n=head2 pattern_freq\n\n Title   : pattern_freq\n Usage   : my $pattern_freq = $HtSNP->pattern_freq();\n Function: Get the pattern id and frequency  for a haplotype\n           tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\nsub pattern_freq{\n    my ($self) =shift;\n    return $self->{'_pattern_freq'} = shift if @_;\n    return $self->{'_pattern_freq'};\n}\n\n=head2 _check_input\n\n Title   : _check_input\n Usage   : _check_input($self)\n Function: check for errors on the input\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _check_input{\n#------------------------\n\n    my $self = shift;\n\n    _haplotype_length_error($self);\n    _population_error($self);\n\n}\n\n=head2 _haplotype_length_error\n\n Title   : _haplotype_length_error\n Usage   : _haplotype_length_error($self)\n Function: check if the haplotype length is the same that the one on the\n           SNP id list. If not break and exit\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _haplotype_length_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $snp_ids     = $self->snp_ids();\n\n\n    #############################\n    # define error list\n    #############################\n    my $different_haplotype_length = 0;\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n\n    my $snp_number         = scalar @$snp_ids;\n    my $number_of_families = scalar @$input_block;\n    my $h                  = 0; # haplotype position\n\n\n    ############################\n    # haplotype length\n    #\n    # if the length differs from the number of ids\n    ############################\n\n    for ($h=0; $h<$#$input_block+1 ; $h++){\n        if (length $input_block->[$h]  != $snp_number){\n            $different_haplotype_length = 1;\n            last;\n        }\n    }\n\n    # haploytypes does not have the same length\n    if ($different_haplotype_length){\n       $self->throw(\"The number of snp ids is $snp_number and \".\n            \"the length of the family (\". ($h+1) .\") [\".\n             $input_block->[$h].\"] is \".\n             length $input_block->[$h], \"\\n\");\n    }\n}\n\n=head2 _population_error\n\n\n Title   : _population_error\n Usage   : _population_error($self)\n Function: use input_block and pop_freq test if the number of elements\n           match. If doesn't break and quit.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _population_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $pop_freq    = $self->pattern_freq();\n\n    #############################\n    # define error list\n    #############################\n    my $pop_freq_elements_error    = 0;  # matrix bad formed\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n    my $number_of_families = scalar @$input_block;\n\n    my $pf         = 0; # number of elements on population frequency\n    my $frequency  = 0; # population frequency\n    my $p_f_length = 0;\n\n    # check if the pop_freq array is well formed and if the number\n    # of elements fit with the number of families\n\n    #############################\n    # check population frequency\n    #\n    # - population frequency matrix need to be well formed\n    # - get the frequency\n    # - calculate number of families on pop_freq\n    #############################\n\n    for  ($pf=0; $pf<$#$pop_freq+1; $pf++){\n        $frequency += $pop_freq->[$pf]->[1];\n\n        if ( scalar @{$pop_freq->[$pf]} !=2){\n            $p_f_length = scalar @{$pop_freq->[$pf]};\n            $pop_freq_elements_error = 1;\n            last;\n        }\n    }\n\n    ###########################\n    ## error processing\n    ###########################\n\n\n    # The frequency shouldn't be greater than 1\n    if ($frequency >1) {\n        $self->warn(\"The frequency for this set is $frequency (greater than 1)\\n\");\n    }\n\n    # the haplotype matix is not well formed\n    if ($pop_freq_elements_error){\n        $self->throw(\"the frequency matrix is not well formed\\n\".\n             \"\\nThe number of elements for pattern \".($pf+1).\" is \".\n             \"$p_f_length\\n\".\n             \"It should be 2 for pattern \\\"@{$pop_freq->[$pf]}\\\"\\n\".\n             \"\\nFormat should be:\\n\".\n             \"haplotype_id\\t frequency\\n\"\n            );\n    }\n\n    # the size does not fit on pop_freq array\n    #  with the one in haplotype (input_block)\n    if ($pf != $number_of_families) {\n        $self->throw(\"The number of patterns on frequency array ($pf)\\n\".\n             \"does not fit with the number of haplotype patterns on \\n\". \n             \"haplotype array ($number_of_families)\\n\");\n    }\n}\n\n=head2 _do_it\n\n\n Title   : _do_it\n Usage   : _do_it($self)\n Function: Process the input generating the results.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _do_it{\n#------------------------\n\n    my $self = shift;\n\n    # first we are goinf to define here all variables we are going to use\n    $self -> {'w_hap'}          = [];\n    $self -> {'w_pop_freq'}     = dclone ( $self ->pattern_freq() );\n    $self -> {'deg_pattern'}    = {};\n    $self -> {'snp_type'}       = {};  # type of snp on the set. see below\n    $self -> {'alleles_number'} = 0;   # number of variations (biallelic,...)\n    $self -> {'snp_type_code'}  = [];\n    $self -> {'ht_type'}        = [];  # store the snp type used on the htSet\n    $self -> {'split_hap'}      = [];\n    $self -> {'snp_and_code'}   = [];\n\n\n    # we classify the SNP under snp_type\n    $self->{snp_type}->{useful_snp} = dclone ( $self ->snp_ids() );\n    $self->{snp_type}->{deg_snp}    = []; # deg snp\n    $self->{snp_type}->{silent_snp} = []; # not a real snp\n\n    # split the haplotype\n    _split_haplo ($self);\n\n    # first we convert to upper case the haplotype\n    # to make A the same as a for comparison\n    _to_upper_case( $self -> {w_hap} );\n\n    #######################################################\n    # check if any SNP has indetermination. If any SNP has\n    # indetermination this value will be removed.\n    #######################################################\n    _remove_deg ( $self );\n\n    #######################################################\n    # depending of the families you use some SNPs can be\n    # silent. This silent SNP's are not used on the\n    # creation of tags and has to be skipped from the\n    # analysis.\n    #######################################################\n    _rem_silent_snp ( $self );\n\n    #######################################################\n    # for the remaining SNP's we have to check if two\n    # families have the same value. If this is true, the families\n    # will produce the same result and therefore we will not find\n    # any pattern. So, the redundant families need to be take\n    # away from the analysis. But also considered for a further\n    # run.\n    #\n    # When we talk about a normal haplotype blocks this situation\n    # makes no sense but if we remove one of the snp because the\n    # degeneration two families can became the same.\n    # these families may be analised on a second round\n    #######################################################\n\n    _find_deg_pattern ( $self );\n\n    #################################################################\n    # if the pattern list length is different to the lenght of the w_hap\n    # we can tell that tow columns have been considered as the same one\n    # and therefore we have to start to remove the values.\n    # remove all columns with degeneration\n    #\n    # For this calculation we don't use the pattern frequency.\n    # All patterns are the same, This selection makes\n    # sense when you have different frequency.\n    #\n    # Note: on this version we don't classify the haplotype by frequency\n    # but if you need to do it. This is the place to do it!!!!\n    #\n    # In reality you don't need to sort the values because you will remove\n    # the values according to their values.\n    #\n    # But as comes from a hash, the order could be different and as a\n    # consequence the code generate on every run of the same set could\n    # differ. That is not important. In fact, does not matter but could\n    # confuse people.\n    #################################################################\n\n    my @tmp =sort { $a <=> $b}\n         keys %{$self -> {deg_pattern}}; # just count the families\n\n    # if the size of the list is different to the size of the degenerated\n    # family. There is degeneration. And the redundancies will be\n    # removed.\n    if($#tmp != $#{$self -> { w_hap } } ){\n        _keep_these_patterns($self->{w_hap}, \\@tmp);\n        _keep_these_patterns($self->{w_pop_freq}, \\@tmp);\n    }\n\n    #################################################################\n    # the steps made before about removing snp and cluster families\n    # are just needed pre-process the haplotype before.\n    #\n    # Now is when the fun starts.\n    #\n    #\n    # once we have the this minimal matrix, we have to calculate the\n    # max multipliticy for the values. The max number of alleles found\n    # on the set. A normal haplotype is biallelic but we can not\n    # reject multiple variations.\n    ##################################################################\n\n    _alleles_number ( $self );\n\n    ##################################################################\n    # Now we have to convert the haplotype into number\n    #\n    # A       C       C       -       T\n    # C       A       G       G       C\n    # A       C       C       C       T\n    # C       G       G       G       C\n    #\n    # one haplotype like this transformed into number produce this result\n    #\n    # 0       0       0       0       0\n    # 1       1       1       1       1\n    # 0       0       0       2       0\n    # 1       2       1       1       1\n    #\n    ##################################################################\n\n    _convert_to_numbers( $self );\n\n    ###################################################################\n    # The next step is to calculate the type of the SNP.\n    # This process is made based on the position of the SNP, the value\n    # and its multiplicity.\n    ###################################################################\n\n    _snp_type_code( $self );\n\n    ###################################################################\n    # now we have all information we need to calculate the haplotype\n    # tagging SNP htSNP\n    ###################################################################\n\n    _htSNP( $self );\n\n    ###################################################################\n    # patch:\n    #\n    # all SNP have a code. but if the SNP is not used this code must\n    # be zero in case of silent SNP. This looks not to informative\n    # because all the information is already there. But this method\n    # compile the full set.\n    ###################################################################\n\n    _snp_and_code_summary( $self );\n}\n\n=head2 input_block\n\n Title   : input_block\n Usage   : $obj->input_block()\n Function: returns input block\n Returns : reference to array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n\n    my $self = shift;\n    return $self -> {input_block};\n}\n\n=head2 hap_length\n\n Title   : hap_length\n Usage   : $obj->hap_length()\n Function: get numbers of SNP on the haplotype\n Returns : scalar\n Args    : none\n Status  : public\n\n\n#------------------------\nsub hap_length{\n#------------------------\n\n    my $self = shift;\n    return scalar @{$self -> {'_snp_ids'}};\n}\n\n\n=head2 pop_freq\n\n Title   : pop_freq\n Usage   : $obj->pop_freq()\n Function: returns population frequency\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub pop_freq{\n#------------------------\n\n    my $self = shift;\n    return $self -> {pop_freq}\n}\n\n\n=head2 deg_snp\n\n\n Title   : deg_snp\n Usage   : $obj->deg_snp()\n Function: returns snp_removes due to indetermination on their values\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{deg_snp};\n}\n\n\n=head2 snp_type\n\n\n Title   : snp_type\n Usage   : $obj->snp_type()\n Function: returns hash with SNP type\n Returns : reference to hash\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type};\n}\n\n\n=head2 silent_snp\n\n\n Title   : silent_snp\n Usage   : $obj->silent_snp()\n Function: some SNP's are silent (not contibuting to the haplotype)\n           and are not considering for this analysis\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub silent_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{silent_snp};\n}\n\n\n=head2 useful_snp\n\n\n Title   : useful_snp\n Usage   : $obj->useful_snp()\n Function: returns list of SNP's that are can be used as htSNP. Some\n           of them can produce the same information. But this is\n           not considered here.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub useful_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{useful_snp};\n}\n\n\n=head2 ht_type\n\n\n Title   : ht_type\n Usage   : $obj->ht_type()\n Function: every useful SNP has a numeric code dependending of its\n           value and position. For a better description see\n           description of the module.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_type{\n#------------------------\n    my $self = shift;\n    return $self -> {ht_type};\n}\n=head2 ht_set\n\n\n Title   : ht_set\n Usage   : $obj->ht_set()\n Function: returns the minimal haplotype in numerical format. This\n           haplotype contains the maximal information about the\n           haplotype variations but with no redundancies. It's the\n           minimal set that describes the haplotype.\n Returns : reference to an array of arrays\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_set{\n#------------------------\n    my $self = shift;\n    return $self -> {w_hap};\n}\n\n=head2 snp_type_code\n\n\n Title   : snp_type_code\n Usage   : $obj->snp_type_code()\n Function: returns the numeric code of the SNPs that need to be\n           tagged that correspond to the SNP's considered in ht_set.\n Returns : reference to an array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type_code{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type_code};\n}\n\n=head2 snp_and_code\n\n\n Title   : snp_and_code\n Usage   : $obj->snp_and_code()\n Function: Returns the full list of SNP's and the code associate to\n           them. If the SNP belongs to the group useful_snp it keep\n           this code. If the SNP is silent the code is 0. And if the\n           SNP is degenerated the code is -1.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_and_code{\n#------------------------\n    my $self = shift;\n    return $self -> {'snp_and_code'};\n}\n\n=head2 deg_pattern\n\n\n Title   : deg_pattern\n Usage   : $obj->deg_pattern()\n Function: Returns the a list with the degenerated haplotype.\n           Sometimes due to degeneration some haplotypes looks\n           the same and if we don't remove them it won't find\n           any tag.\n Returns : reference to a hash of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_pattern{\n#------------------------\n    my $self = shift;\n\n    return $self -> {'deg_pattern'};\n}\n\n=head2 split_hap\n\n\n Title   : split_hap\n Usage   : $obj->split_hap()\n Function: simple representation of the haplotype base by base\n           Same information that input haplotype but base based.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub split_hap{\n#------------------------\n    my $self = shift;\n    return $self -> {'split_hap'};\n}\n\n=head2 _split_haplo\n\n Title   : _split_haplo\n Usage   : _split_haplo($self)\n Function: Take a haplotype and split it into bases\n Returns : self\n Args    : none\n Status  : internal\n\n\n#------------------------\nsub _split_haplo {\n#------------------------\n    my $self = shift;\n\n    my $in  = $self ->{'_haplotype_block'};\n    my $out = $self ->{'w_hap'};\n\n    # split every haplotype and store the result into $out\n    foreach (@$in){\n        push @$out, [split (//,$_)];\n    }\n\n    $self -> {'split_hap'} = dclone ($out);\n}\n\n# internal method to convert the haplotype to uppercase\n\n\n=head2 _to_upper_case\n\n\n Title   : _to_upper_case\n Usage   : _to_upper_case()\n Function: make SNP or in-dels Upper case\n Returns : self\n Args    : an AoA ref\n Status  : private","parameters":[{"label":"$arr"}],"label":"_to_upper_case($arr)"},"detail":"($arr)","name":"_to_upper_case","range":{"end":{"line":1088,"character":9999},"start":{"character":0,"line":1080}}},{"line":1106,"children":[{"kind":13,"line":1108,"containerName":"_remove_deg","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":1110,"containerName":"_remove_deg","definition":"my","name":"$hap","localvar":"my"},{"kind":13,"line":1110,"containerName":"_remove_deg","name":"$self"},{"containerName":"_remove_deg","definition":"my","name":"$snp","localvar":"my","kind":13,"line":1111},{"line":1111,"kind":13,"name":"$self","containerName":"_remove_deg"},{"line":1112,"kind":13,"localvar":"my","name":"$deg_snp","definition":"my","containerName":"_remove_deg"},{"line":1112,"kind":13,"containerName":"_remove_deg","name":"$self"},{"name":"$rem","definition":"my","containerName":"_remove_deg","localvar":"my","kind":13,"line":1114},{"line":1117,"kind":13,"containerName":"_remove_deg","name":"$rem"},{"name":"$hap","containerName":"_remove_deg","line":1117,"kind":13},{"containerName":"_remove_deg","name":"$rem","line":1117,"kind":13},{"containerName":"_remove_deg","name":"$rem","line":1119,"kind":13},{"name":"$hap","containerName":"_remove_deg","line":1122,"kind":13},{"kind":13,"line":1122,"containerName":"_remove_deg","name":"$rem"},{"containerName":"_remove_deg","name":"$snp","line":1125,"kind":13},{"name":"$deg_snp","containerName":"_remove_deg","line":1125,"kind":13},{"line":1125,"kind":13,"containerName":"_remove_deg","name":"$rem"}],"kind":12,"range":{"end":{"line":1127,"character":9999},"start":{"character":0,"line":1106}},"containerName":"main::","name":"_remove_deg","definition":"sub"},{"kind":12,"line":1110,"name":"w_hap"},{"name":"snp_type","kind":12,"line":1111},{"name":"useful_snp","kind":12,"line":1111},{"line":1112,"kind":12,"name":"snp_type"},{"line":1112,"kind":12,"name":"deg_snp"},{"line":1117,"kind":12,"name":"_find_indet"},{"name":"_remove_col","line":1122,"kind":12},{"line":1125,"kind":12,"name":"_remove_snp_id"},{"containerName":"main::","name":"_rem_silent_snp","definition":"sub","range":{"start":{"character":0,"line":1145},"end":{"character":9999,"line":1166}},"kind":12,"line":1145,"children":[{"line":1147,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_rem_silent_snp"},{"containerName":"_rem_silent_snp","name":"$hap","definition":"my","localvar":"my","kind":13,"line":1149},{"kind":13,"line":1149,"name":"$self","containerName":"_rem_silent_snp"},{"kind":13,"line":1150,"definition":"my","name":"$snp","containerName":"_rem_silent_snp","localvar":"my"},{"line":1150,"kind":13,"name":"$self","containerName":"_rem_silent_snp"},{"localvar":"my","containerName":"_rem_silent_snp","name":"$silent_snp","definition":"my","line":1151,"kind":13},{"containerName":"_rem_silent_snp","name":"$self","line":1151,"kind":13},{"definition":"my","name":"$rem","containerName":"_rem_silent_snp","localvar":"my","kind":13,"line":1153},{"name":"$rem","containerName":"_rem_silent_snp","kind":13,"line":1156},{"line":1156,"kind":13,"containerName":"_rem_silent_snp","name":"$hap"},{"line":1158,"kind":13,"containerName":"_rem_silent_snp","name":"$rem"},{"name":"$hap","containerName":"_rem_silent_snp","kind":13,"line":1161},{"name":"$rem","containerName":"_rem_silent_snp","line":1161,"kind":13},{"containerName":"_rem_silent_snp","name":"$snp","kind":13,"line":1164},{"kind":13,"line":1164,"containerName":"_rem_silent_snp","name":"$silent_snp"},{"kind":13,"line":1164,"containerName":"_rem_silent_snp","name":"$rem"}]},{"name":"w_hap","line":1149,"kind":12},{"line":1150,"kind":12,"name":"snp_type"},{"kind":12,"line":1150,"name":"useful_snp"},{"kind":12,"line":1151,"name":"snp_type"},{"name":"silent_snp","line":1151,"kind":12},{"kind":12,"line":1156,"name":"_find_silent_snps"},{"kind":12,"line":1161,"name":"_remove_col"},{"name":"_remove_snp_id","kind":12,"line":1164},{"definition":"sub","containerName":"main::","signature":{"label":"_find_silent_snps($arr)","parameters":[{"label":"$arr"}],"documentation":"1;\n# module Bio::PopGen::HtSNP.pm\n# cared by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n#\n\n=head1 NAME\n\nBio::PopGen::HtSNP.pm- Select htSNP from a haplotype set\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::HtSNP;\n\n    my $obj = Bio::PopGen::HtSNP->new($hap,$snp,$pop);\n\n=head1 DESCRIPTION\n\nSelect the minimal set of SNP that contains the full information about\nthe haplotype without redundancies.\n\nTake as input the followin values:\n\n=over 4\n\n* - the haplotype block (array of array).\n\n* - the snp id (array).\n\n* - family information and frequency (array of array).\n\n\nThe final haplotype is generated in a numerical format and the SNP's\nsets can be retrieve from the module.\n\nB<considerations:>\n\n\n- If you force to include a family with indetermination, the SNP's\nwith indetermination will be removed from the analysis, so consider\nbefore to place your data set what do you really want to do.\n\n- If two families have the same information (identical haplotype), one\nof them will be removed and the removed files will be stored classify\nas removed.\n\n- Only are accepted for calculation A, C, G, T and - (as deletion) and\ntheir combinations. Any other value as n or ? will be considered as\ndegenerations due to lack of information.\n\n=head2 RATIONALE\n\nOn a haplotype set is expected that some of the SNP and their\nvariations contribute in the same way to the haplotype. Eliminating\nredundancies will produce a minimal set of SNP's that can be used as\ninput for a taging selection process. On the process SNP's with the\nsame variation are clustered on the same group.\n\nThe idea is that because the tagging haplotype process is\nexponential. All redundant information we could eliminate on the\ntagging process will help to find a quick result.\n\n=head2 CONSTRUCTORS\n\n  my $obj = Bio::PopGen::HtSNP->new\n    (-haplotype_block => \\@haplotype_patterns,\n     -snp_ids         => \\@snp_ids,\n     -pattern_freq    => \\@pattern_name_and_freq);\n\nwhere  $hap, $snp and $pop are in the format:\n\n  my $hap = [\n             'acgt',\n             'agtc',\n             'cgtc'\n            ];                     # haplotype patterns' id\n\n  my $snp = [qw/s1 s2 s3 s4/];     # snps' Id's\n\n  my $pop = [\n             [qw/ uno    0.20/],\n             [qw/ dos    0.20/],\n             [qw/ tres   0.15/],\n            ];                     # haplotype_pattern_id    Frequency\n\n=head2 OBJECT METHODS\n\n    See Below for more detailed summaries.\n\n\n=head1 DETAILS\n\n=head2 How the process is working with one example\n\nLet's begin with one general example of the code.\n\nInput haplotype:\n\n  acgtcca-t\n  cggtagtgc\n  cccccgtgc\n  cgctcgtgc\n\nThe first thing to to is to B<split the haplotype> into characters.\n\n  a       c       g       t       c       c       a       -       t\n  c       g       g       t       a       g       t       g       c\n  c       c       c       c       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n\nNow we have to B<convert> the haplotype to B<Upercase>. This\nwill produce the same SNP if we have input a or A.\n\n  A       C       G       T       C       C       A       -       T\n  C       G       G       T       A       G       T       G       C\n  C       C       C       C       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n\nThe program admit as values any combination of ACTG and - (deletions).\nThe haplotype is B<converted to number>, considering the first variation\nas zero and the alternate value as 1 (see expanded description below).\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n\nOnce we have the haplotype converted to numbers we have to generate the\nsnp type information for the haplotype.\n\n\nB<SNP code = SUM ( value * multiplicity ^ position );>\n\n    where:\n      SUM is the sum of the values for the SNP\n      value is the SNP number code (0 [generally for the mayor allele],\n                                    1 [for the minor allele].\n      position is the position on the block.\n\nFor this example the code is:\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n ------------------------------------------------------------------\n  14      10      12      4       2       14      14      14      14\n\n  14 = 0*2^0 + 1*2^1 + 1*2^2 + 1*2^3\n  12 = 0*2^0 + 1*2^1 + 0*2^2 + 1*2^3\n  ....\n\nOnce we have the families classify. We will B<take> just the SNP's B<not\nredundant>.\n\n  14      10      12      4       2\n\nThis information will be B<passed to the tag module> is you want to tag\nthe htSNP.\n\nWhatever it happens to one SNPs of a class will happen to a SNP of\nthe same class. Therefore you don't need to scan redundancies\n\n=head2 Working with fuzzy data.\n\nThis module is designed to work with fuzzy data. As the source of the\nhaplotype is diverse. The program assume that some haplotypes can be\ngenerated using different values. If there is any indetermination (? or n)\nor any other degenerated value or invalid. The program will take away\nThis SNP and will leave that for a further analysis.\n\nOn a complex situation:\n\n  a       c       g       t       ?       c       a       c       t\n  a       c       g       t       ?       c       a       -       t\n  c       g       ?       t       a       g       ?       g       c\n  c       a       c       t       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n  c       g       g       t       a       g       ?       g       c\n  a       c       ?       t       ?       c       a       c       t\n\nOn this haplotype everything is happening. We have a multialelic variance.\nWe have indeterminations. We have deletions and we have even one SNP\nwhich is not a real SNP.\n\nThe buiding process will be the same on this situation.\n\nConvert the haplotype to uppercase.\n\n  A       C       G       T       ?       C       A       C       T\n  A       C       G       T       ?       C       A       -       T\n  C       G       ?       T       A       G       ?       G       C\n  C       A       C       T       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n  C       G       G       T       A       G       ?       G       C\n  A       C       ?       T       ?       C       A       C       T\n\nAll columns that present indeterminations will be removed from the analysis\non this Step.\n\nhapotype after remove columns:\n\n  A       C       T       C       C       T\n  A       C       T       C       -       T\n  C       G       T       G       G       C\n  C       A       T       G       G       C\n  C       G       T       G       G       C\n  C       G       T       G       G       C\n  A       C       T       C       C       T\n\nAll changes made on the haplotype matrix, will be also made on the SNP list.\n\n  snp_id_1 snp_id_2 snp_id_4 snp_id_6 snp_id_8 snp_id_9\n\nnow the SNP that is not one SNP will be removed from the analysis.\nSNP with Id snp_id_4 (the one with all T's).\n\n\nbecause of the removing. Some of the families will become the same and will\nbe clustered. A posteriori analysis will diference these families.\nbut because of the indetermination can not be distinguish.\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n  C       G       G       G       C\n  C       G       G       G       C\n  A       C       C       C       T\n\nThe result of the mergering will go like:\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n\nOnce again the changes made on the families and we merge the frequency (I<to be\nimplemented>)\n\nBefore to convert the haplotype into numbers we consider how many variations\nwe have on the set. On this case the variations are 3.\n\nThe control code will use on this situation base three as mutiplicity\n\n  0       0       0       0       0\n  0       0       0       1       0\n  1       1       1       2       1\n  1       2       1       2       1\n -----------------------------------\n  36      63      36      75      36\n\nAnd the minimal set for this combination is\n\n  0       0       0\n  0       0       1\n  1       1       2\n  1       2       2\n\nB<NOTE:> this second example is a remote example an on normal conditions. This\nconditions makes no sense, but as the haplotypes, can come from many sources\nwe have to be ready for all kind of combinations.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PopGen::HtSNP;\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse vars qw ();\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = 'Usage:\n\n    Bio::PopGen::HtSNP->new(-haplotype_block -ids -pattern_freq)\n\n';\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Usage   : $obj-> Bio::PopGen::HtSNP->new(-haplotype_block\n                                          -snp_ids\n                                          -pattern_freq)\n Returns : self hash\n Args    : input haplotype (array of array)\n           snp_ids         (array)\n           pop_freq        (array of array)\n Status  : public\n\n\nsub new {\n    my($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($haplotype_block,\n        $snp_ids,\n        $pattern_freq    ) = $self->_rearrange([qw(HAPLOTYPE_BLOCK \n                                                   SNP_IDS\n                                                   PATTERN_FREQ)],@args);\n\n    if ($haplotype_block){\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"Haplotype block has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($snp_ids){\n        $self->snp_ids($snp_ids);\n    }\n    else{\n        $self->throw(\"Array with ids has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($pattern_freq){\n        $self->pattern_freq($pattern_freq);\n    }\n    else{\n        $self->throw(\"Array with pattern id and frequency has not been defined.\n                      \\n$USAGE\");\n    }\n\n    # if the input values are not well formed complained and exit.\n    _check_input($self);\n\n    _do_it($self);\n\n    return $self;\n}\n\n=head2 haplotype_block \n\n Title   : haplotype_block \n Usage   : my $haplotype_block = $HtSNP->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array \n Args    : reference of array with haplotype pattern \n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n=head2 snp_ids \n\n Title   : snp_ids \n Usage   : my $snp_ids = $HtSNP->$snp_ids();\n Function: Get the ids for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\n\nsub snp_ids{\n    my ($self) =shift;\n    return $self->{'_snp_ids'} = shift if @_;\n    return $self->{'_snp_ids'};\n}\n\n\n=head2 pattern_freq\n\n Title   : pattern_freq\n Usage   : my $pattern_freq = $HtSNP->pattern_freq();\n Function: Get the pattern id and frequency  for a haplotype\n           tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\nsub pattern_freq{\n    my ($self) =shift;\n    return $self->{'_pattern_freq'} = shift if @_;\n    return $self->{'_pattern_freq'};\n}\n\n=head2 _check_input\n\n Title   : _check_input\n Usage   : _check_input($self)\n Function: check for errors on the input\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _check_input{\n#------------------------\n\n    my $self = shift;\n\n    _haplotype_length_error($self);\n    _population_error($self);\n\n}\n\n=head2 _haplotype_length_error\n\n Title   : _haplotype_length_error\n Usage   : _haplotype_length_error($self)\n Function: check if the haplotype length is the same that the one on the\n           SNP id list. If not break and exit\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _haplotype_length_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $snp_ids     = $self->snp_ids();\n\n\n    #############################\n    # define error list\n    #############################\n    my $different_haplotype_length = 0;\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n\n    my $snp_number         = scalar @$snp_ids;\n    my $number_of_families = scalar @$input_block;\n    my $h                  = 0; # haplotype position\n\n\n    ############################\n    # haplotype length\n    #\n    # if the length differs from the number of ids\n    ############################\n\n    for ($h=0; $h<$#$input_block+1 ; $h++){\n        if (length $input_block->[$h]  != $snp_number){\n            $different_haplotype_length = 1;\n            last;\n        }\n    }\n\n    # haploytypes does not have the same length\n    if ($different_haplotype_length){\n       $self->throw(\"The number of snp ids is $snp_number and \".\n            \"the length of the family (\". ($h+1) .\") [\".\n             $input_block->[$h].\"] is \".\n             length $input_block->[$h], \"\\n\");\n    }\n}\n\n=head2 _population_error\n\n\n Title   : _population_error\n Usage   : _population_error($self)\n Function: use input_block and pop_freq test if the number of elements\n           match. If doesn't break and quit.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _population_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $pop_freq    = $self->pattern_freq();\n\n    #############################\n    # define error list\n    #############################\n    my $pop_freq_elements_error    = 0;  # matrix bad formed\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n    my $number_of_families = scalar @$input_block;\n\n    my $pf         = 0; # number of elements on population frequency\n    my $frequency  = 0; # population frequency\n    my $p_f_length = 0;\n\n    # check if the pop_freq array is well formed and if the number\n    # of elements fit with the number of families\n\n    #############################\n    # check population frequency\n    #\n    # - population frequency matrix need to be well formed\n    # - get the frequency\n    # - calculate number of families on pop_freq\n    #############################\n\n    for  ($pf=0; $pf<$#$pop_freq+1; $pf++){\n        $frequency += $pop_freq->[$pf]->[1];\n\n        if ( scalar @{$pop_freq->[$pf]} !=2){\n            $p_f_length = scalar @{$pop_freq->[$pf]};\n            $pop_freq_elements_error = 1;\n            last;\n        }\n    }\n\n    ###########################\n    ## error processing\n    ###########################\n\n\n    # The frequency shouldn't be greater than 1\n    if ($frequency >1) {\n        $self->warn(\"The frequency for this set is $frequency (greater than 1)\\n\");\n    }\n\n    # the haplotype matix is not well formed\n    if ($pop_freq_elements_error){\n        $self->throw(\"the frequency matrix is not well formed\\n\".\n             \"\\nThe number of elements for pattern \".($pf+1).\" is \".\n             \"$p_f_length\\n\".\n             \"It should be 2 for pattern \\\"@{$pop_freq->[$pf]}\\\"\\n\".\n             \"\\nFormat should be:\\n\".\n             \"haplotype_id\\t frequency\\n\"\n            );\n    }\n\n    # the size does not fit on pop_freq array\n    #  with the one in haplotype (input_block)\n    if ($pf != $number_of_families) {\n        $self->throw(\"The number of patterns on frequency array ($pf)\\n\".\n             \"does not fit with the number of haplotype patterns on \\n\". \n             \"haplotype array ($number_of_families)\\n\");\n    }\n}\n\n=head2 _do_it\n\n\n Title   : _do_it\n Usage   : _do_it($self)\n Function: Process the input generating the results.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _do_it{\n#------------------------\n\n    my $self = shift;\n\n    # first we are goinf to define here all variables we are going to use\n    $self -> {'w_hap'}          = [];\n    $self -> {'w_pop_freq'}     = dclone ( $self ->pattern_freq() );\n    $self -> {'deg_pattern'}    = {};\n    $self -> {'snp_type'}       = {};  # type of snp on the set. see below\n    $self -> {'alleles_number'} = 0;   # number of variations (biallelic,...)\n    $self -> {'snp_type_code'}  = [];\n    $self -> {'ht_type'}        = [];  # store the snp type used on the htSet\n    $self -> {'split_hap'}      = [];\n    $self -> {'snp_and_code'}   = [];\n\n\n    # we classify the SNP under snp_type\n    $self->{snp_type}->{useful_snp} = dclone ( $self ->snp_ids() );\n    $self->{snp_type}->{deg_snp}    = []; # deg snp\n    $self->{snp_type}->{silent_snp} = []; # not a real snp\n\n    # split the haplotype\n    _split_haplo ($self);\n\n    # first we convert to upper case the haplotype\n    # to make A the same as a for comparison\n    _to_upper_case( $self -> {w_hap} );\n\n    #######################################################\n    # check if any SNP has indetermination. If any SNP has\n    # indetermination this value will be removed.\n    #######################################################\n    _remove_deg ( $self );\n\n    #######################################################\n    # depending of the families you use some SNPs can be\n    # silent. This silent SNP's are not used on the\n    # creation of tags and has to be skipped from the\n    # analysis.\n    #######################################################\n    _rem_silent_snp ( $self );\n\n    #######################################################\n    # for the remaining SNP's we have to check if two\n    # families have the same value. If this is true, the families\n    # will produce the same result and therefore we will not find\n    # any pattern. So, the redundant families need to be take\n    # away from the analysis. But also considered for a further\n    # run.\n    #\n    # When we talk about a normal haplotype blocks this situation\n    # makes no sense but if we remove one of the snp because the\n    # degeneration two families can became the same.\n    # these families may be analised on a second round\n    #######################################################\n\n    _find_deg_pattern ( $self );\n\n    #################################################################\n    # if the pattern list length is different to the lenght of the w_hap\n    # we can tell that tow columns have been considered as the same one\n    # and therefore we have to start to remove the values.\n    # remove all columns with degeneration\n    #\n    # For this calculation we don't use the pattern frequency.\n    # All patterns are the same, This selection makes\n    # sense when you have different frequency.\n    #\n    # Note: on this version we don't classify the haplotype by frequency\n    # but if you need to do it. This is the place to do it!!!!\n    #\n    # In reality you don't need to sort the values because you will remove\n    # the values according to their values.\n    #\n    # But as comes from a hash, the order could be different and as a\n    # consequence the code generate on every run of the same set could\n    # differ. That is not important. In fact, does not matter but could\n    # confuse people.\n    #################################################################\n\n    my @tmp =sort { $a <=> $b}\n         keys %{$self -> {deg_pattern}}; # just count the families\n\n    # if the size of the list is different to the size of the degenerated\n    # family. There is degeneration. And the redundancies will be\n    # removed.\n    if($#tmp != $#{$self -> { w_hap } } ){\n        _keep_these_patterns($self->{w_hap}, \\@tmp);\n        _keep_these_patterns($self->{w_pop_freq}, \\@tmp);\n    }\n\n    #################################################################\n    # the steps made before about removing snp and cluster families\n    # are just needed pre-process the haplotype before.\n    #\n    # Now is when the fun starts.\n    #\n    #\n    # once we have the this minimal matrix, we have to calculate the\n    # max multipliticy for the values. The max number of alleles found\n    # on the set. A normal haplotype is biallelic but we can not\n    # reject multiple variations.\n    ##################################################################\n\n    _alleles_number ( $self );\n\n    ##################################################################\n    # Now we have to convert the haplotype into number\n    #\n    # A       C       C       -       T\n    # C       A       G       G       C\n    # A       C       C       C       T\n    # C       G       G       G       C\n    #\n    # one haplotype like this transformed into number produce this result\n    #\n    # 0       0       0       0       0\n    # 1       1       1       1       1\n    # 0       0       0       2       0\n    # 1       2       1       1       1\n    #\n    ##################################################################\n\n    _convert_to_numbers( $self );\n\n    ###################################################################\n    # The next step is to calculate the type of the SNP.\n    # This process is made based on the position of the SNP, the value\n    # and its multiplicity.\n    ###################################################################\n\n    _snp_type_code( $self );\n\n    ###################################################################\n    # now we have all information we need to calculate the haplotype\n    # tagging SNP htSNP\n    ###################################################################\n\n    _htSNP( $self );\n\n    ###################################################################\n    # patch:\n    #\n    # all SNP have a code. but if the SNP is not used this code must\n    # be zero in case of silent SNP. This looks not to informative\n    # because all the information is already there. But this method\n    # compile the full set.\n    ###################################################################\n\n    _snp_and_code_summary( $self );\n}\n\n=head2 input_block\n\n Title   : input_block\n Usage   : $obj->input_block()\n Function: returns input block\n Returns : reference to array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n\n    my $self = shift;\n    return $self -> {input_block};\n}\n\n=head2 hap_length\n\n Title   : hap_length\n Usage   : $obj->hap_length()\n Function: get numbers of SNP on the haplotype\n Returns : scalar\n Args    : none\n Status  : public\n\n\n#------------------------\nsub hap_length{\n#------------------------\n\n    my $self = shift;\n    return scalar @{$self -> {'_snp_ids'}};\n}\n\n\n=head2 pop_freq\n\n Title   : pop_freq\n Usage   : $obj->pop_freq()\n Function: returns population frequency\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub pop_freq{\n#------------------------\n\n    my $self = shift;\n    return $self -> {pop_freq}\n}\n\n\n=head2 deg_snp\n\n\n Title   : deg_snp\n Usage   : $obj->deg_snp()\n Function: returns snp_removes due to indetermination on their values\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{deg_snp};\n}\n\n\n=head2 snp_type\n\n\n Title   : snp_type\n Usage   : $obj->snp_type()\n Function: returns hash with SNP type\n Returns : reference to hash\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type};\n}\n\n\n=head2 silent_snp\n\n\n Title   : silent_snp\n Usage   : $obj->silent_snp()\n Function: some SNP's are silent (not contibuting to the haplotype)\n           and are not considering for this analysis\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub silent_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{silent_snp};\n}\n\n\n=head2 useful_snp\n\n\n Title   : useful_snp\n Usage   : $obj->useful_snp()\n Function: returns list of SNP's that are can be used as htSNP. Some\n           of them can produce the same information. But this is\n           not considered here.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub useful_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{useful_snp};\n}\n\n\n=head2 ht_type\n\n\n Title   : ht_type\n Usage   : $obj->ht_type()\n Function: every useful SNP has a numeric code dependending of its\n           value and position. For a better description see\n           description of the module.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_type{\n#------------------------\n    my $self = shift;\n    return $self -> {ht_type};\n}\n=head2 ht_set\n\n\n Title   : ht_set\n Usage   : $obj->ht_set()\n Function: returns the minimal haplotype in numerical format. This\n           haplotype contains the maximal information about the\n           haplotype variations but with no redundancies. It's the\n           minimal set that describes the haplotype.\n Returns : reference to an array of arrays\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_set{\n#------------------------\n    my $self = shift;\n    return $self -> {w_hap};\n}\n\n=head2 snp_type_code\n\n\n Title   : snp_type_code\n Usage   : $obj->snp_type_code()\n Function: returns the numeric code of the SNPs that need to be\n           tagged that correspond to the SNP's considered in ht_set.\n Returns : reference to an array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type_code{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type_code};\n}\n\n=head2 snp_and_code\n\n\n Title   : snp_and_code\n Usage   : $obj->snp_and_code()\n Function: Returns the full list of SNP's and the code associate to\n           them. If the SNP belongs to the group useful_snp it keep\n           this code. If the SNP is silent the code is 0. And if the\n           SNP is degenerated the code is -1.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_and_code{\n#------------------------\n    my $self = shift;\n    return $self -> {'snp_and_code'};\n}\n\n=head2 deg_pattern\n\n\n Title   : deg_pattern\n Usage   : $obj->deg_pattern()\n Function: Returns the a list with the degenerated haplotype.\n           Sometimes due to degeneration some haplotypes looks\n           the same and if we don't remove them it won't find\n           any tag.\n Returns : reference to a hash of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_pattern{\n#------------------------\n    my $self = shift;\n\n    return $self -> {'deg_pattern'};\n}\n\n=head2 split_hap\n\n\n Title   : split_hap\n Usage   : $obj->split_hap()\n Function: simple representation of the haplotype base by base\n           Same information that input haplotype but base based.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub split_hap{\n#------------------------\n    my $self = shift;\n    return $self -> {'split_hap'};\n}\n\n=head2 _split_haplo\n\n Title   : _split_haplo\n Usage   : _split_haplo($self)\n Function: Take a haplotype and split it into bases\n Returns : self\n Args    : none\n Status  : internal\n\n\n#------------------------\nsub _split_haplo {\n#------------------------\n    my $self = shift;\n\n    my $in  = $self ->{'_haplotype_block'};\n    my $out = $self ->{'w_hap'};\n\n    # split every haplotype and store the result into $out\n    foreach (@$in){\n        push @$out, [split (//,$_)];\n    }\n\n    $self -> {'split_hap'} = dclone ($out);\n}\n\n# internal method to convert the haplotype to uppercase\n\n\n=head2 _to_upper_case\n\n\n Title   : _to_upper_case\n Usage   : _to_upper_case()\n Function: make SNP or in-dels Upper case\n Returns : self\n Args    : an AoA ref\n Status  : private\n\n\n#------------------------\nsub _to_upper_case {\n#------------------------\n    my ($arr) =@_;\n\n    foreach my $aref (@$arr){\n        foreach my $value (@{$aref} ){\n            $value = uc $value;\n        }\n    }\n}\n\n\n=head2 _remove_deg\n\n\n Title   : _remove_deg\n Usage   : _remove_deg()\n Function: when have a indetermination or strange value this SNP\n           is removed\n Returns : haplotype family set and degeneration list\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _remove_deg {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $deg_snp     = $self->{snp_type}->{deg_snp};\n\n    my $rem = [];  # take the position of the array to be removed\n\n    # first we work on the columns we have void values\n    $rem = _find_indet($hap,$rem);  # find degenerated columns\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem); # remove list\n\n        # now remove the values from SNP id\n        _remove_snp_id($snp,$deg_snp,$rem); # remove list\n    }\n}\n\n\n=head2 _rem_silent_snp\n\n\n Title   : _rem_silent_snp\n Usage   : _rem_silent_snp()\n Function: there is the remote possibilty that one SNP won't be a\n           real SNP on this situation we have to remove this SNP,\n           otherwise the program won't find any tag\n Returns : nonthing\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _rem_silent_snp {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $silent_snp  = $self->{snp_type}->{silent_snp};\n\n    my $rem = [];   # store the positions to be removed\n\n    #find columns with no variation on the SNP, Real snp?\n    $rem = _find_silent_snps($hap);\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem);\n\n        # remove the values from SNP id\n        _remove_snp_id($snp,$silent_snp,$rem);\n    }\n}\n\n\n=head2 _find_silent_snps\n\n\n Title   : _find_silent_snps\n Usage   :\n Function: list of snps that are not SNPs. All values for that\n           SNPs on the set is the same one. Look stupid but can\n           happend and if this happend you will not find any tag\n Returns : nothing\n Args    :\n Status  :"},"detail":"($arr)","kind":12,"children":[{"line":1186,"kind":13,"localvar":"my","containerName":"_find_silent_snps","definition":"my","name":"$arr"},{"line":1188,"kind":13,"localvar":"my","containerName":"_find_silent_snps","definition":"my","name":"$list"},{"kind":13,"line":1192,"containerName":"_find_silent_snps","definition":"my","name":"$colsn","localvar":"my"},{"name":"$arr","containerName":"_find_silent_snps","line":1192,"kind":13}],"line":1184,"name":"_find_silent_snps","range":{"end":{"line":1192,"character":9999},"start":{"line":1184,"character":0}}},{"line":1194,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":null},{"line":1194,"kind":13,"containerName":null,"name":"$i"},{"kind":13,"line":1194,"containerName":null,"name":"$colsn"},{"name":"%i","containerName":null,"line":1194,"kind":13},{"kind":13,"line":1195,"definition":"my","name":"$different","containerName":null,"localvar":"my"},{"localvar":"my","containerName":null,"name":"$r","definition":"my","line":1197,"kind":13},{"name":"%arr","containerName":null,"kind":13,"line":1197},{"name":"@arr","containerName":null,"kind":13,"line":1198},{"line":1198,"kind":13,"containerName":null,"name":"$i"},{"containerName":null,"name":"@arr","kind":13,"line":1198},{"name":"@r","containerName":null,"line":1198,"kind":13},{"containerName":null,"name":"%i","kind":13,"line":1198},{"name":"$different","containerName":null,"kind":13,"line":1199},{"kind":13,"line":1204,"name":"%different","containerName":null},{"line":1205,"kind":13,"name":"$list","containerName":null},{"containerName":null,"name":"$i","line":1205,"kind":13},{"kind":13,"line":1209,"name":"$list","containerName":null},{"kind":12,"line":1227,"children":[{"kind":13,"line":1229,"containerName":"_find_indet","definition":"my","name":"$arr","localvar":"my"},{"containerName":"_find_indet","name":"$list","line":1229,"kind":13},{"line":1231,"kind":13,"localvar":"my","containerName":"_find_indet","name":"$i","definition":"my"},{"kind":13,"line":1231,"name":"$arr","containerName":"_find_indet"},{"containerName":"_find_indet","definition":"my","name":"$j","localvar":"my","kind":13,"line":1232},{"name":"$arr","containerName":"_find_indet","line":1232,"kind":13},{"containerName":"_find_indet","name":"$i","kind":13,"line":1232},{"name":"$arr","containerName":"_find_indet","kind":13,"line":1233},{"containerName":"_find_indet","name":"$i","kind":13,"line":1233},{"line":1233,"kind":13,"containerName":"_find_indet","name":"$j"},{"line":1234,"kind":13,"name":"$list","containerName":"_find_indet"},{"kind":13,"line":1235,"name":"$list","containerName":"_find_indet"},{"containerName":"_find_indet","name":"$j","line":1235,"kind":13},{"line":1238,"kind":13,"localvar":"my","containerName":"_find_indet","definition":"my","name":"$found"},{"localvar":"my","containerName":"_find_indet","name":"$k","definition":"my","line":1239,"kind":13},{"name":"$list","containerName":"_find_indet","kind":13,"line":1239},{"name":"$found","containerName":"_find_indet","line":1240,"kind":13},{"kind":13,"line":1240,"containerName":"_find_indet","name":"$list"},{"line":1240,"kind":13,"name":"$k","containerName":"_find_indet"},{"line":1240,"kind":13,"name":"$j","containerName":"_find_indet"},{"line":1241,"kind":13,"containerName":"_find_indet","name":"$found"},{"kind":13,"line":1243,"containerName":"_find_indet","name":"$found"},{"name":"$list","containerName":"_find_indet","kind":13,"line":1244},{"kind":13,"line":1244,"containerName":"_find_indet","name":"$j"}],"containerName":"main::","definition":"sub","detail":"($arr,$list)","signature":{"label":"_find_indet($arr,$list)","documentation":"1;\n# module Bio::PopGen::HtSNP.pm\n# cared by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n#\n\n=head1 NAME\n\nBio::PopGen::HtSNP.pm- Select htSNP from a haplotype set\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::HtSNP;\n\n    my $obj = Bio::PopGen::HtSNP->new($hap,$snp,$pop);\n\n=head1 DESCRIPTION\n\nSelect the minimal set of SNP that contains the full information about\nthe haplotype without redundancies.\n\nTake as input the followin values:\n\n=over 4\n\n* - the haplotype block (array of array).\n\n* - the snp id (array).\n\n* - family information and frequency (array of array).\n\n\nThe final haplotype is generated in a numerical format and the SNP's\nsets can be retrieve from the module.\n\nB<considerations:>\n\n\n- If you force to include a family with indetermination, the SNP's\nwith indetermination will be removed from the analysis, so consider\nbefore to place your data set what do you really want to do.\n\n- If two families have the same information (identical haplotype), one\nof them will be removed and the removed files will be stored classify\nas removed.\n\n- Only are accepted for calculation A, C, G, T and - (as deletion) and\ntheir combinations. Any other value as n or ? will be considered as\ndegenerations due to lack of information.\n\n=head2 RATIONALE\n\nOn a haplotype set is expected that some of the SNP and their\nvariations contribute in the same way to the haplotype. Eliminating\nredundancies will produce a minimal set of SNP's that can be used as\ninput for a taging selection process. On the process SNP's with the\nsame variation are clustered on the same group.\n\nThe idea is that because the tagging haplotype process is\nexponential. All redundant information we could eliminate on the\ntagging process will help to find a quick result.\n\n=head2 CONSTRUCTORS\n\n  my $obj = Bio::PopGen::HtSNP->new\n    (-haplotype_block => \\@haplotype_patterns,\n     -snp_ids         => \\@snp_ids,\n     -pattern_freq    => \\@pattern_name_and_freq);\n\nwhere  $hap, $snp and $pop are in the format:\n\n  my $hap = [\n             'acgt',\n             'agtc',\n             'cgtc'\n            ];                     # haplotype patterns' id\n\n  my $snp = [qw/s1 s2 s3 s4/];     # snps' Id's\n\n  my $pop = [\n             [qw/ uno    0.20/],\n             [qw/ dos    0.20/],\n             [qw/ tres   0.15/],\n            ];                     # haplotype_pattern_id    Frequency\n\n=head2 OBJECT METHODS\n\n    See Below for more detailed summaries.\n\n\n=head1 DETAILS\n\n=head2 How the process is working with one example\n\nLet's begin with one general example of the code.\n\nInput haplotype:\n\n  acgtcca-t\n  cggtagtgc\n  cccccgtgc\n  cgctcgtgc\n\nThe first thing to to is to B<split the haplotype> into characters.\n\n  a       c       g       t       c       c       a       -       t\n  c       g       g       t       a       g       t       g       c\n  c       c       c       c       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n\nNow we have to B<convert> the haplotype to B<Upercase>. This\nwill produce the same SNP if we have input a or A.\n\n  A       C       G       T       C       C       A       -       T\n  C       G       G       T       A       G       T       G       C\n  C       C       C       C       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n\nThe program admit as values any combination of ACTG and - (deletions).\nThe haplotype is B<converted to number>, considering the first variation\nas zero and the alternate value as 1 (see expanded description below).\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n\nOnce we have the haplotype converted to numbers we have to generate the\nsnp type information for the haplotype.\n\n\nB<SNP code = SUM ( value * multiplicity ^ position );>\n\n    where:\n      SUM is the sum of the values for the SNP\n      value is the SNP number code (0 [generally for the mayor allele],\n                                    1 [for the minor allele].\n      position is the position on the block.\n\nFor this example the code is:\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n ------------------------------------------------------------------\n  14      10      12      4       2       14      14      14      14\n\n  14 = 0*2^0 + 1*2^1 + 1*2^2 + 1*2^3\n  12 = 0*2^0 + 1*2^1 + 0*2^2 + 1*2^3\n  ....\n\nOnce we have the families classify. We will B<take> just the SNP's B<not\nredundant>.\n\n  14      10      12      4       2\n\nThis information will be B<passed to the tag module> is you want to tag\nthe htSNP.\n\nWhatever it happens to one SNPs of a class will happen to a SNP of\nthe same class. Therefore you don't need to scan redundancies\n\n=head2 Working with fuzzy data.\n\nThis module is designed to work with fuzzy data. As the source of the\nhaplotype is diverse. The program assume that some haplotypes can be\ngenerated using different values. If there is any indetermination (? or n)\nor any other degenerated value or invalid. The program will take away\nThis SNP and will leave that for a further analysis.\n\nOn a complex situation:\n\n  a       c       g       t       ?       c       a       c       t\n  a       c       g       t       ?       c       a       -       t\n  c       g       ?       t       a       g       ?       g       c\n  c       a       c       t       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n  c       g       g       t       a       g       ?       g       c\n  a       c       ?       t       ?       c       a       c       t\n\nOn this haplotype everything is happening. We have a multialelic variance.\nWe have indeterminations. We have deletions and we have even one SNP\nwhich is not a real SNP.\n\nThe buiding process will be the same on this situation.\n\nConvert the haplotype to uppercase.\n\n  A       C       G       T       ?       C       A       C       T\n  A       C       G       T       ?       C       A       -       T\n  C       G       ?       T       A       G       ?       G       C\n  C       A       C       T       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n  C       G       G       T       A       G       ?       G       C\n  A       C       ?       T       ?       C       A       C       T\n\nAll columns that present indeterminations will be removed from the analysis\non this Step.\n\nhapotype after remove columns:\n\n  A       C       T       C       C       T\n  A       C       T       C       -       T\n  C       G       T       G       G       C\n  C       A       T       G       G       C\n  C       G       T       G       G       C\n  C       G       T       G       G       C\n  A       C       T       C       C       T\n\nAll changes made on the haplotype matrix, will be also made on the SNP list.\n\n  snp_id_1 snp_id_2 snp_id_4 snp_id_6 snp_id_8 snp_id_9\n\nnow the SNP that is not one SNP will be removed from the analysis.\nSNP with Id snp_id_4 (the one with all T's).\n\n\nbecause of the removing. Some of the families will become the same and will\nbe clustered. A posteriori analysis will diference these families.\nbut because of the indetermination can not be distinguish.\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n  C       G       G       G       C\n  C       G       G       G       C\n  A       C       C       C       T\n\nThe result of the mergering will go like:\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n\nOnce again the changes made on the families and we merge the frequency (I<to be\nimplemented>)\n\nBefore to convert the haplotype into numbers we consider how many variations\nwe have on the set. On this case the variations are 3.\n\nThe control code will use on this situation base three as mutiplicity\n\n  0       0       0       0       0\n  0       0       0       1       0\n  1       1       1       2       1\n  1       2       1       2       1\n -----------------------------------\n  36      63      36      75      36\n\nAnd the minimal set for this combination is\n\n  0       0       0\n  0       0       1\n  1       1       2\n  1       2       2\n\nB<NOTE:> this second example is a remote example an on normal conditions. This\nconditions makes no sense, but as the haplotypes, can come from many sources\nwe have to be ready for all kind of combinations.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PopGen::HtSNP;\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse vars qw ();\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = 'Usage:\n\n    Bio::PopGen::HtSNP->new(-haplotype_block -ids -pattern_freq)\n\n';\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Usage   : $obj-> Bio::PopGen::HtSNP->new(-haplotype_block\n                                          -snp_ids\n                                          -pattern_freq)\n Returns : self hash\n Args    : input haplotype (array of array)\n           snp_ids         (array)\n           pop_freq        (array of array)\n Status  : public\n\n\nsub new {\n    my($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($haplotype_block,\n        $snp_ids,\n        $pattern_freq    ) = $self->_rearrange([qw(HAPLOTYPE_BLOCK \n                                                   SNP_IDS\n                                                   PATTERN_FREQ)],@args);\n\n    if ($haplotype_block){\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"Haplotype block has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($snp_ids){\n        $self->snp_ids($snp_ids);\n    }\n    else{\n        $self->throw(\"Array with ids has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($pattern_freq){\n        $self->pattern_freq($pattern_freq);\n    }\n    else{\n        $self->throw(\"Array with pattern id and frequency has not been defined.\n                      \\n$USAGE\");\n    }\n\n    # if the input values are not well formed complained and exit.\n    _check_input($self);\n\n    _do_it($self);\n\n    return $self;\n}\n\n=head2 haplotype_block \n\n Title   : haplotype_block \n Usage   : my $haplotype_block = $HtSNP->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array \n Args    : reference of array with haplotype pattern \n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n=head2 snp_ids \n\n Title   : snp_ids \n Usage   : my $snp_ids = $HtSNP->$snp_ids();\n Function: Get the ids for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\n\nsub snp_ids{\n    my ($self) =shift;\n    return $self->{'_snp_ids'} = shift if @_;\n    return $self->{'_snp_ids'};\n}\n\n\n=head2 pattern_freq\n\n Title   : pattern_freq\n Usage   : my $pattern_freq = $HtSNP->pattern_freq();\n Function: Get the pattern id and frequency  for a haplotype\n           tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\nsub pattern_freq{\n    my ($self) =shift;\n    return $self->{'_pattern_freq'} = shift if @_;\n    return $self->{'_pattern_freq'};\n}\n\n=head2 _check_input\n\n Title   : _check_input\n Usage   : _check_input($self)\n Function: check for errors on the input\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _check_input{\n#------------------------\n\n    my $self = shift;\n\n    _haplotype_length_error($self);\n    _population_error($self);\n\n}\n\n=head2 _haplotype_length_error\n\n Title   : _haplotype_length_error\n Usage   : _haplotype_length_error($self)\n Function: check if the haplotype length is the same that the one on the\n           SNP id list. If not break and exit\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _haplotype_length_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $snp_ids     = $self->snp_ids();\n\n\n    #############################\n    # define error list\n    #############################\n    my $different_haplotype_length = 0;\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n\n    my $snp_number         = scalar @$snp_ids;\n    my $number_of_families = scalar @$input_block;\n    my $h                  = 0; # haplotype position\n\n\n    ############################\n    # haplotype length\n    #\n    # if the length differs from the number of ids\n    ############################\n\n    for ($h=0; $h<$#$input_block+1 ; $h++){\n        if (length $input_block->[$h]  != $snp_number){\n            $different_haplotype_length = 1;\n            last;\n        }\n    }\n\n    # haploytypes does not have the same length\n    if ($different_haplotype_length){\n       $self->throw(\"The number of snp ids is $snp_number and \".\n            \"the length of the family (\". ($h+1) .\") [\".\n             $input_block->[$h].\"] is \".\n             length $input_block->[$h], \"\\n\");\n    }\n}\n\n=head2 _population_error\n\n\n Title   : _population_error\n Usage   : _population_error($self)\n Function: use input_block and pop_freq test if the number of elements\n           match. If doesn't break and quit.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _population_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $pop_freq    = $self->pattern_freq();\n\n    #############################\n    # define error list\n    #############################\n    my $pop_freq_elements_error    = 0;  # matrix bad formed\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n    my $number_of_families = scalar @$input_block;\n\n    my $pf         = 0; # number of elements on population frequency\n    my $frequency  = 0; # population frequency\n    my $p_f_length = 0;\n\n    # check if the pop_freq array is well formed and if the number\n    # of elements fit with the number of families\n\n    #############################\n    # check population frequency\n    #\n    # - population frequency matrix need to be well formed\n    # - get the frequency\n    # - calculate number of families on pop_freq\n    #############################\n\n    for  ($pf=0; $pf<$#$pop_freq+1; $pf++){\n        $frequency += $pop_freq->[$pf]->[1];\n\n        if ( scalar @{$pop_freq->[$pf]} !=2){\n            $p_f_length = scalar @{$pop_freq->[$pf]};\n            $pop_freq_elements_error = 1;\n            last;\n        }\n    }\n\n    ###########################\n    ## error processing\n    ###########################\n\n\n    # The frequency shouldn't be greater than 1\n    if ($frequency >1) {\n        $self->warn(\"The frequency for this set is $frequency (greater than 1)\\n\");\n    }\n\n    # the haplotype matix is not well formed\n    if ($pop_freq_elements_error){\n        $self->throw(\"the frequency matrix is not well formed\\n\".\n             \"\\nThe number of elements for pattern \".($pf+1).\" is \".\n             \"$p_f_length\\n\".\n             \"It should be 2 for pattern \\\"@{$pop_freq->[$pf]}\\\"\\n\".\n             \"\\nFormat should be:\\n\".\n             \"haplotype_id\\t frequency\\n\"\n            );\n    }\n\n    # the size does not fit on pop_freq array\n    #  with the one in haplotype (input_block)\n    if ($pf != $number_of_families) {\n        $self->throw(\"The number of patterns on frequency array ($pf)\\n\".\n             \"does not fit with the number of haplotype patterns on \\n\". \n             \"haplotype array ($number_of_families)\\n\");\n    }\n}\n\n=head2 _do_it\n\n\n Title   : _do_it\n Usage   : _do_it($self)\n Function: Process the input generating the results.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _do_it{\n#------------------------\n\n    my $self = shift;\n\n    # first we are goinf to define here all variables we are going to use\n    $self -> {'w_hap'}          = [];\n    $self -> {'w_pop_freq'}     = dclone ( $self ->pattern_freq() );\n    $self -> {'deg_pattern'}    = {};\n    $self -> {'snp_type'}       = {};  # type of snp on the set. see below\n    $self -> {'alleles_number'} = 0;   # number of variations (biallelic,...)\n    $self -> {'snp_type_code'}  = [];\n    $self -> {'ht_type'}        = [];  # store the snp type used on the htSet\n    $self -> {'split_hap'}      = [];\n    $self -> {'snp_and_code'}   = [];\n\n\n    # we classify the SNP under snp_type\n    $self->{snp_type}->{useful_snp} = dclone ( $self ->snp_ids() );\n    $self->{snp_type}->{deg_snp}    = []; # deg snp\n    $self->{snp_type}->{silent_snp} = []; # not a real snp\n\n    # split the haplotype\n    _split_haplo ($self);\n\n    # first we convert to upper case the haplotype\n    # to make A the same as a for comparison\n    _to_upper_case( $self -> {w_hap} );\n\n    #######################################################\n    # check if any SNP has indetermination. If any SNP has\n    # indetermination this value will be removed.\n    #######################################################\n    _remove_deg ( $self );\n\n    #######################################################\n    # depending of the families you use some SNPs can be\n    # silent. This silent SNP's are not used on the\n    # creation of tags and has to be skipped from the\n    # analysis.\n    #######################################################\n    _rem_silent_snp ( $self );\n\n    #######################################################\n    # for the remaining SNP's we have to check if two\n    # families have the same value. If this is true, the families\n    # will produce the same result and therefore we will not find\n    # any pattern. So, the redundant families need to be take\n    # away from the analysis. But also considered for a further\n    # run.\n    #\n    # When we talk about a normal haplotype blocks this situation\n    # makes no sense but if we remove one of the snp because the\n    # degeneration two families can became the same.\n    # these families may be analised on a second round\n    #######################################################\n\n    _find_deg_pattern ( $self );\n\n    #################################################################\n    # if the pattern list length is different to the lenght of the w_hap\n    # we can tell that tow columns have been considered as the same one\n    # and therefore we have to start to remove the values.\n    # remove all columns with degeneration\n    #\n    # For this calculation we don't use the pattern frequency.\n    # All patterns are the same, This selection makes\n    # sense when you have different frequency.\n    #\n    # Note: on this version we don't classify the haplotype by frequency\n    # but if you need to do it. This is the place to do it!!!!\n    #\n    # In reality you don't need to sort the values because you will remove\n    # the values according to their values.\n    #\n    # But as comes from a hash, the order could be different and as a\n    # consequence the code generate on every run of the same set could\n    # differ. That is not important. In fact, does not matter but could\n    # confuse people.\n    #################################################################\n\n    my @tmp =sort { $a <=> $b}\n         keys %{$self -> {deg_pattern}}; # just count the families\n\n    # if the size of the list is different to the size of the degenerated\n    # family. There is degeneration. And the redundancies will be\n    # removed.\n    if($#tmp != $#{$self -> { w_hap } } ){\n        _keep_these_patterns($self->{w_hap}, \\@tmp);\n        _keep_these_patterns($self->{w_pop_freq}, \\@tmp);\n    }\n\n    #################################################################\n    # the steps made before about removing snp and cluster families\n    # are just needed pre-process the haplotype before.\n    #\n    # Now is when the fun starts.\n    #\n    #\n    # once we have the this minimal matrix, we have to calculate the\n    # max multipliticy for the values. The max number of alleles found\n    # on the set. A normal haplotype is biallelic but we can not\n    # reject multiple variations.\n    ##################################################################\n\n    _alleles_number ( $self );\n\n    ##################################################################\n    # Now we have to convert the haplotype into number\n    #\n    # A       C       C       -       T\n    # C       A       G       G       C\n    # A       C       C       C       T\n    # C       G       G       G       C\n    #\n    # one haplotype like this transformed into number produce this result\n    #\n    # 0       0       0       0       0\n    # 1       1       1       1       1\n    # 0       0       0       2       0\n    # 1       2       1       1       1\n    #\n    ##################################################################\n\n    _convert_to_numbers( $self );\n\n    ###################################################################\n    # The next step is to calculate the type of the SNP.\n    # This process is made based on the position of the SNP, the value\n    # and its multiplicity.\n    ###################################################################\n\n    _snp_type_code( $self );\n\n    ###################################################################\n    # now we have all information we need to calculate the haplotype\n    # tagging SNP htSNP\n    ###################################################################\n\n    _htSNP( $self );\n\n    ###################################################################\n    # patch:\n    #\n    # all SNP have a code. but if the SNP is not used this code must\n    # be zero in case of silent SNP. This looks not to informative\n    # because all the information is already there. But this method\n    # compile the full set.\n    ###################################################################\n\n    _snp_and_code_summary( $self );\n}\n\n=head2 input_block\n\n Title   : input_block\n Usage   : $obj->input_block()\n Function: returns input block\n Returns : reference to array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n\n    my $self = shift;\n    return $self -> {input_block};\n}\n\n=head2 hap_length\n\n Title   : hap_length\n Usage   : $obj->hap_length()\n Function: get numbers of SNP on the haplotype\n Returns : scalar\n Args    : none\n Status  : public\n\n\n#------------------------\nsub hap_length{\n#------------------------\n\n    my $self = shift;\n    return scalar @{$self -> {'_snp_ids'}};\n}\n\n\n=head2 pop_freq\n\n Title   : pop_freq\n Usage   : $obj->pop_freq()\n Function: returns population frequency\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub pop_freq{\n#------------------------\n\n    my $self = shift;\n    return $self -> {pop_freq}\n}\n\n\n=head2 deg_snp\n\n\n Title   : deg_snp\n Usage   : $obj->deg_snp()\n Function: returns snp_removes due to indetermination on their values\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{deg_snp};\n}\n\n\n=head2 snp_type\n\n\n Title   : snp_type\n Usage   : $obj->snp_type()\n Function: returns hash with SNP type\n Returns : reference to hash\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type};\n}\n\n\n=head2 silent_snp\n\n\n Title   : silent_snp\n Usage   : $obj->silent_snp()\n Function: some SNP's are silent (not contibuting to the haplotype)\n           and are not considering for this analysis\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub silent_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{silent_snp};\n}\n\n\n=head2 useful_snp\n\n\n Title   : useful_snp\n Usage   : $obj->useful_snp()\n Function: returns list of SNP's that are can be used as htSNP. Some\n           of them can produce the same information. But this is\n           not considered here.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub useful_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{useful_snp};\n}\n\n\n=head2 ht_type\n\n\n Title   : ht_type\n Usage   : $obj->ht_type()\n Function: every useful SNP has a numeric code dependending of its\n           value and position. For a better description see\n           description of the module.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_type{\n#------------------------\n    my $self = shift;\n    return $self -> {ht_type};\n}\n=head2 ht_set\n\n\n Title   : ht_set\n Usage   : $obj->ht_set()\n Function: returns the minimal haplotype in numerical format. This\n           haplotype contains the maximal information about the\n           haplotype variations but with no redundancies. It's the\n           minimal set that describes the haplotype.\n Returns : reference to an array of arrays\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_set{\n#------------------------\n    my $self = shift;\n    return $self -> {w_hap};\n}\n\n=head2 snp_type_code\n\n\n Title   : snp_type_code\n Usage   : $obj->snp_type_code()\n Function: returns the numeric code of the SNPs that need to be\n           tagged that correspond to the SNP's considered in ht_set.\n Returns : reference to an array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type_code{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type_code};\n}\n\n=head2 snp_and_code\n\n\n Title   : snp_and_code\n Usage   : $obj->snp_and_code()\n Function: Returns the full list of SNP's and the code associate to\n           them. If the SNP belongs to the group useful_snp it keep\n           this code. If the SNP is silent the code is 0. And if the\n           SNP is degenerated the code is -1.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_and_code{\n#------------------------\n    my $self = shift;\n    return $self -> {'snp_and_code'};\n}\n\n=head2 deg_pattern\n\n\n Title   : deg_pattern\n Usage   : $obj->deg_pattern()\n Function: Returns the a list with the degenerated haplotype.\n           Sometimes due to degeneration some haplotypes looks\n           the same and if we don't remove them it won't find\n           any tag.\n Returns : reference to a hash of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_pattern{\n#------------------------\n    my $self = shift;\n\n    return $self -> {'deg_pattern'};\n}\n\n=head2 split_hap\n\n\n Title   : split_hap\n Usage   : $obj->split_hap()\n Function: simple representation of the haplotype base by base\n           Same information that input haplotype but base based.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub split_hap{\n#------------------------\n    my $self = shift;\n    return $self -> {'split_hap'};\n}\n\n=head2 _split_haplo\n\n Title   : _split_haplo\n Usage   : _split_haplo($self)\n Function: Take a haplotype and split it into bases\n Returns : self\n Args    : none\n Status  : internal\n\n\n#------------------------\nsub _split_haplo {\n#------------------------\n    my $self = shift;\n\n    my $in  = $self ->{'_haplotype_block'};\n    my $out = $self ->{'w_hap'};\n\n    # split every haplotype and store the result into $out\n    foreach (@$in){\n        push @$out, [split (//,$_)];\n    }\n\n    $self -> {'split_hap'} = dclone ($out);\n}\n\n# internal method to convert the haplotype to uppercase\n\n\n=head2 _to_upper_case\n\n\n Title   : _to_upper_case\n Usage   : _to_upper_case()\n Function: make SNP or in-dels Upper case\n Returns : self\n Args    : an AoA ref\n Status  : private\n\n\n#------------------------\nsub _to_upper_case {\n#------------------------\n    my ($arr) =@_;\n\n    foreach my $aref (@$arr){\n        foreach my $value (@{$aref} ){\n            $value = uc $value;\n        }\n    }\n}\n\n\n=head2 _remove_deg\n\n\n Title   : _remove_deg\n Usage   : _remove_deg()\n Function: when have a indetermination or strange value this SNP\n           is removed\n Returns : haplotype family set and degeneration list\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _remove_deg {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $deg_snp     = $self->{snp_type}->{deg_snp};\n\n    my $rem = [];  # take the position of the array to be removed\n\n    # first we work on the columns we have void values\n    $rem = _find_indet($hap,$rem);  # find degenerated columns\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem); # remove list\n\n        # now remove the values from SNP id\n        _remove_snp_id($snp,$deg_snp,$rem); # remove list\n    }\n}\n\n\n=head2 _rem_silent_snp\n\n\n Title   : _rem_silent_snp\n Usage   : _rem_silent_snp()\n Function: there is the remote possibilty that one SNP won't be a\n           real SNP on this situation we have to remove this SNP,\n           otherwise the program won't find any tag\n Returns : nonthing\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _rem_silent_snp {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $silent_snp  = $self->{snp_type}->{silent_snp};\n\n    my $rem = [];   # store the positions to be removed\n\n    #find columns with no variation on the SNP, Real snp?\n    $rem = _find_silent_snps($hap);\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem);\n\n        # remove the values from SNP id\n        _remove_snp_id($snp,$silent_snp,$rem);\n    }\n}\n\n\n=head2 _find_silent_snps\n\n\n Title   : _find_silent_snps\n Usage   :\n Function: list of snps that are not SNPs. All values for that\n           SNPs on the set is the same one. Look stupid but can\n           happend and if this happend you will not find any tag\n Returns : nothing\n Args    :\n Status  :\n\n\n#------------------------\nsub _find_silent_snps{\n#------------------------\n    my ($arr)=@_;\n\n    my $list =[]; # no snp list;\n\n    # determine the number of snp by the length of the first row.\n    # we assume that the matrix is squared.\n    my $colsn= @{$arr->[0]};\n\n    for (my $i=0;$i<$colsn;$i++){\n        my $different =0;  # check degeneration\n\n        for my $r (1..$#$arr){\n            if($arr->[0][$i] ne $arr->[$r][$i]){\n                $different =1;\n                last;\n            }\n        }\n\n        if(!$different){\n            push (@$list, $i);\n        }\n    }\n\n    return $list;\n}\n\n\n=head2 _find_indet\n\n\n Title   : _find_indet\n Usage   :\n Function: find column (SNP) with invalid or degenerated values\n           and store this values into the second parameter suplied.\n Returns : nothing\n Args    : ref to AoA and ref to an array\n Status  : internal","parameters":[{"label":"$arr"},{"label":"$list"}]},"name":"_find_indet","range":{"start":{"character":0,"line":1227},"end":{"line":1249,"character":9999}}},{"line":1251,"kind":13,"containerName":null,"name":"%list"},{"name":"$a","containerName":null,"kind":13,"line":1251},{"kind":13,"line":1251,"name":"$b","containerName":null},{"containerName":null,"name":"$list","line":1251,"kind":13},{"name":"$list","containerName":null,"line":1253,"kind":13},{"name":"_remove_col","range":{"start":{"line":1269,"character":0},"end":{"character":9999,"line":1276}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$arr"},{"label":"$rem"}],"documentation":"1;\n# module Bio::PopGen::HtSNP.pm\n# cared by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n#\n\n=head1 NAME\n\nBio::PopGen::HtSNP.pm- Select htSNP from a haplotype set\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::HtSNP;\n\n    my $obj = Bio::PopGen::HtSNP->new($hap,$snp,$pop);\n\n=head1 DESCRIPTION\n\nSelect the minimal set of SNP that contains the full information about\nthe haplotype without redundancies.\n\nTake as input the followin values:\n\n=over 4\n\n* - the haplotype block (array of array).\n\n* - the snp id (array).\n\n* - family information and frequency (array of array).\n\n\nThe final haplotype is generated in a numerical format and the SNP's\nsets can be retrieve from the module.\n\nB<considerations:>\n\n\n- If you force to include a family with indetermination, the SNP's\nwith indetermination will be removed from the analysis, so consider\nbefore to place your data set what do you really want to do.\n\n- If two families have the same information (identical haplotype), one\nof them will be removed and the removed files will be stored classify\nas removed.\n\n- Only are accepted for calculation A, C, G, T and - (as deletion) and\ntheir combinations. Any other value as n or ? will be considered as\ndegenerations due to lack of information.\n\n=head2 RATIONALE\n\nOn a haplotype set is expected that some of the SNP and their\nvariations contribute in the same way to the haplotype. Eliminating\nredundancies will produce a minimal set of SNP's that can be used as\ninput for a taging selection process. On the process SNP's with the\nsame variation are clustered on the same group.\n\nThe idea is that because the tagging haplotype process is\nexponential. All redundant information we could eliminate on the\ntagging process will help to find a quick result.\n\n=head2 CONSTRUCTORS\n\n  my $obj = Bio::PopGen::HtSNP->new\n    (-haplotype_block => \\@haplotype_patterns,\n     -snp_ids         => \\@snp_ids,\n     -pattern_freq    => \\@pattern_name_and_freq);\n\nwhere  $hap, $snp and $pop are in the format:\n\n  my $hap = [\n             'acgt',\n             'agtc',\n             'cgtc'\n            ];                     # haplotype patterns' id\n\n  my $snp = [qw/s1 s2 s3 s4/];     # snps' Id's\n\n  my $pop = [\n             [qw/ uno    0.20/],\n             [qw/ dos    0.20/],\n             [qw/ tres   0.15/],\n            ];                     # haplotype_pattern_id    Frequency\n\n=head2 OBJECT METHODS\n\n    See Below for more detailed summaries.\n\n\n=head1 DETAILS\n\n=head2 How the process is working with one example\n\nLet's begin with one general example of the code.\n\nInput haplotype:\n\n  acgtcca-t\n  cggtagtgc\n  cccccgtgc\n  cgctcgtgc\n\nThe first thing to to is to B<split the haplotype> into characters.\n\n  a       c       g       t       c       c       a       -       t\n  c       g       g       t       a       g       t       g       c\n  c       c       c       c       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n\nNow we have to B<convert> the haplotype to B<Upercase>. This\nwill produce the same SNP if we have input a or A.\n\n  A       C       G       T       C       C       A       -       T\n  C       G       G       T       A       G       T       G       C\n  C       C       C       C       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n\nThe program admit as values any combination of ACTG and - (deletions).\nThe haplotype is B<converted to number>, considering the first variation\nas zero and the alternate value as 1 (see expanded description below).\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n\nOnce we have the haplotype converted to numbers we have to generate the\nsnp type information for the haplotype.\n\n\nB<SNP code = SUM ( value * multiplicity ^ position );>\n\n    where:\n      SUM is the sum of the values for the SNP\n      value is the SNP number code (0 [generally for the mayor allele],\n                                    1 [for the minor allele].\n      position is the position on the block.\n\nFor this example the code is:\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n ------------------------------------------------------------------\n  14      10      12      4       2       14      14      14      14\n\n  14 = 0*2^0 + 1*2^1 + 1*2^2 + 1*2^3\n  12 = 0*2^0 + 1*2^1 + 0*2^2 + 1*2^3\n  ....\n\nOnce we have the families classify. We will B<take> just the SNP's B<not\nredundant>.\n\n  14      10      12      4       2\n\nThis information will be B<passed to the tag module> is you want to tag\nthe htSNP.\n\nWhatever it happens to one SNPs of a class will happen to a SNP of\nthe same class. Therefore you don't need to scan redundancies\n\n=head2 Working with fuzzy data.\n\nThis module is designed to work with fuzzy data. As the source of the\nhaplotype is diverse. The program assume that some haplotypes can be\ngenerated using different values. If there is any indetermination (? or n)\nor any other degenerated value or invalid. The program will take away\nThis SNP and will leave that for a further analysis.\n\nOn a complex situation:\n\n  a       c       g       t       ?       c       a       c       t\n  a       c       g       t       ?       c       a       -       t\n  c       g       ?       t       a       g       ?       g       c\n  c       a       c       t       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n  c       g       g       t       a       g       ?       g       c\n  a       c       ?       t       ?       c       a       c       t\n\nOn this haplotype everything is happening. We have a multialelic variance.\nWe have indeterminations. We have deletions and we have even one SNP\nwhich is not a real SNP.\n\nThe buiding process will be the same on this situation.\n\nConvert the haplotype to uppercase.\n\n  A       C       G       T       ?       C       A       C       T\n  A       C       G       T       ?       C       A       -       T\n  C       G       ?       T       A       G       ?       G       C\n  C       A       C       T       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n  C       G       G       T       A       G       ?       G       C\n  A       C       ?       T       ?       C       A       C       T\n\nAll columns that present indeterminations will be removed from the analysis\non this Step.\n\nhapotype after remove columns:\n\n  A       C       T       C       C       T\n  A       C       T       C       -       T\n  C       G       T       G       G       C\n  C       A       T       G       G       C\n  C       G       T       G       G       C\n  C       G       T       G       G       C\n  A       C       T       C       C       T\n\nAll changes made on the haplotype matrix, will be also made on the SNP list.\n\n  snp_id_1 snp_id_2 snp_id_4 snp_id_6 snp_id_8 snp_id_9\n\nnow the SNP that is not one SNP will be removed from the analysis.\nSNP with Id snp_id_4 (the one with all T's).\n\n\nbecause of the removing. Some of the families will become the same and will\nbe clustered. A posteriori analysis will diference these families.\nbut because of the indetermination can not be distinguish.\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n  C       G       G       G       C\n  C       G       G       G       C\n  A       C       C       C       T\n\nThe result of the mergering will go like:\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n\nOnce again the changes made on the families and we merge the frequency (I<to be\nimplemented>)\n\nBefore to convert the haplotype into numbers we consider how many variations\nwe have on the set. On this case the variations are 3.\n\nThe control code will use on this situation base three as mutiplicity\n\n  0       0       0       0       0\n  0       0       0       1       0\n  1       1       1       2       1\n  1       2       1       2       1\n -----------------------------------\n  36      63      36      75      36\n\nAnd the minimal set for this combination is\n\n  0       0       0\n  0       0       1\n  1       1       2\n  1       2       2\n\nB<NOTE:> this second example is a remote example an on normal conditions. This\nconditions makes no sense, but as the haplotypes, can come from many sources\nwe have to be ready for all kind of combinations.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PopGen::HtSNP;\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse vars qw ();\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = 'Usage:\n\n    Bio::PopGen::HtSNP->new(-haplotype_block -ids -pattern_freq)\n\n';\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Usage   : $obj-> Bio::PopGen::HtSNP->new(-haplotype_block\n                                          -snp_ids\n                                          -pattern_freq)\n Returns : self hash\n Args    : input haplotype (array of array)\n           snp_ids         (array)\n           pop_freq        (array of array)\n Status  : public\n\n\nsub new {\n    my($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($haplotype_block,\n        $snp_ids,\n        $pattern_freq    ) = $self->_rearrange([qw(HAPLOTYPE_BLOCK \n                                                   SNP_IDS\n                                                   PATTERN_FREQ)],@args);\n\n    if ($haplotype_block){\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"Haplotype block has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($snp_ids){\n        $self->snp_ids($snp_ids);\n    }\n    else{\n        $self->throw(\"Array with ids has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($pattern_freq){\n        $self->pattern_freq($pattern_freq);\n    }\n    else{\n        $self->throw(\"Array with pattern id and frequency has not been defined.\n                      \\n$USAGE\");\n    }\n\n    # if the input values are not well formed complained and exit.\n    _check_input($self);\n\n    _do_it($self);\n\n    return $self;\n}\n\n=head2 haplotype_block \n\n Title   : haplotype_block \n Usage   : my $haplotype_block = $HtSNP->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array \n Args    : reference of array with haplotype pattern \n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n=head2 snp_ids \n\n Title   : snp_ids \n Usage   : my $snp_ids = $HtSNP->$snp_ids();\n Function: Get the ids for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\n\nsub snp_ids{\n    my ($self) =shift;\n    return $self->{'_snp_ids'} = shift if @_;\n    return $self->{'_snp_ids'};\n}\n\n\n=head2 pattern_freq\n\n Title   : pattern_freq\n Usage   : my $pattern_freq = $HtSNP->pattern_freq();\n Function: Get the pattern id and frequency  for a haplotype\n           tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\nsub pattern_freq{\n    my ($self) =shift;\n    return $self->{'_pattern_freq'} = shift if @_;\n    return $self->{'_pattern_freq'};\n}\n\n=head2 _check_input\n\n Title   : _check_input\n Usage   : _check_input($self)\n Function: check for errors on the input\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _check_input{\n#------------------------\n\n    my $self = shift;\n\n    _haplotype_length_error($self);\n    _population_error($self);\n\n}\n\n=head2 _haplotype_length_error\n\n Title   : _haplotype_length_error\n Usage   : _haplotype_length_error($self)\n Function: check if the haplotype length is the same that the one on the\n           SNP id list. If not break and exit\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _haplotype_length_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $snp_ids     = $self->snp_ids();\n\n\n    #############################\n    # define error list\n    #############################\n    my $different_haplotype_length = 0;\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n\n    my $snp_number         = scalar @$snp_ids;\n    my $number_of_families = scalar @$input_block;\n    my $h                  = 0; # haplotype position\n\n\n    ############################\n    # haplotype length\n    #\n    # if the length differs from the number of ids\n    ############################\n\n    for ($h=0; $h<$#$input_block+1 ; $h++){\n        if (length $input_block->[$h]  != $snp_number){\n            $different_haplotype_length = 1;\n            last;\n        }\n    }\n\n    # haploytypes does not have the same length\n    if ($different_haplotype_length){\n       $self->throw(\"The number of snp ids is $snp_number and \".\n            \"the length of the family (\". ($h+1) .\") [\".\n             $input_block->[$h].\"] is \".\n             length $input_block->[$h], \"\\n\");\n    }\n}\n\n=head2 _population_error\n\n\n Title   : _population_error\n Usage   : _population_error($self)\n Function: use input_block and pop_freq test if the number of elements\n           match. If doesn't break and quit.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _population_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $pop_freq    = $self->pattern_freq();\n\n    #############################\n    # define error list\n    #############################\n    my $pop_freq_elements_error    = 0;  # matrix bad formed\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n    my $number_of_families = scalar @$input_block;\n\n    my $pf         = 0; # number of elements on population frequency\n    my $frequency  = 0; # population frequency\n    my $p_f_length = 0;\n\n    # check if the pop_freq array is well formed and if the number\n    # of elements fit with the number of families\n\n    #############################\n    # check population frequency\n    #\n    # - population frequency matrix need to be well formed\n    # - get the frequency\n    # - calculate number of families on pop_freq\n    #############################\n\n    for  ($pf=0; $pf<$#$pop_freq+1; $pf++){\n        $frequency += $pop_freq->[$pf]->[1];\n\n        if ( scalar @{$pop_freq->[$pf]} !=2){\n            $p_f_length = scalar @{$pop_freq->[$pf]};\n            $pop_freq_elements_error = 1;\n            last;\n        }\n    }\n\n    ###########################\n    ## error processing\n    ###########################\n\n\n    # The frequency shouldn't be greater than 1\n    if ($frequency >1) {\n        $self->warn(\"The frequency for this set is $frequency (greater than 1)\\n\");\n    }\n\n    # the haplotype matix is not well formed\n    if ($pop_freq_elements_error){\n        $self->throw(\"the frequency matrix is not well formed\\n\".\n             \"\\nThe number of elements for pattern \".($pf+1).\" is \".\n             \"$p_f_length\\n\".\n             \"It should be 2 for pattern \\\"@{$pop_freq->[$pf]}\\\"\\n\".\n             \"\\nFormat should be:\\n\".\n             \"haplotype_id\\t frequency\\n\"\n            );\n    }\n\n    # the size does not fit on pop_freq array\n    #  with the one in haplotype (input_block)\n    if ($pf != $number_of_families) {\n        $self->throw(\"The number of patterns on frequency array ($pf)\\n\".\n             \"does not fit with the number of haplotype patterns on \\n\". \n             \"haplotype array ($number_of_families)\\n\");\n    }\n}\n\n=head2 _do_it\n\n\n Title   : _do_it\n Usage   : _do_it($self)\n Function: Process the input generating the results.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _do_it{\n#------------------------\n\n    my $self = shift;\n\n    # first we are goinf to define here all variables we are going to use\n    $self -> {'w_hap'}          = [];\n    $self -> {'w_pop_freq'}     = dclone ( $self ->pattern_freq() );\n    $self -> {'deg_pattern'}    = {};\n    $self -> {'snp_type'}       = {};  # type of snp on the set. see below\n    $self -> {'alleles_number'} = 0;   # number of variations (biallelic,...)\n    $self -> {'snp_type_code'}  = [];\n    $self -> {'ht_type'}        = [];  # store the snp type used on the htSet\n    $self -> {'split_hap'}      = [];\n    $self -> {'snp_and_code'}   = [];\n\n\n    # we classify the SNP under snp_type\n    $self->{snp_type}->{useful_snp} = dclone ( $self ->snp_ids() );\n    $self->{snp_type}->{deg_snp}    = []; # deg snp\n    $self->{snp_type}->{silent_snp} = []; # not a real snp\n\n    # split the haplotype\n    _split_haplo ($self);\n\n    # first we convert to upper case the haplotype\n    # to make A the same as a for comparison\n    _to_upper_case( $self -> {w_hap} );\n\n    #######################################################\n    # check if any SNP has indetermination. If any SNP has\n    # indetermination this value will be removed.\n    #######################################################\n    _remove_deg ( $self );\n\n    #######################################################\n    # depending of the families you use some SNPs can be\n    # silent. This silent SNP's are not used on the\n    # creation of tags and has to be skipped from the\n    # analysis.\n    #######################################################\n    _rem_silent_snp ( $self );\n\n    #######################################################\n    # for the remaining SNP's we have to check if two\n    # families have the same value. If this is true, the families\n    # will produce the same result and therefore we will not find\n    # any pattern. So, the redundant families need to be take\n    # away from the analysis. But also considered for a further\n    # run.\n    #\n    # When we talk about a normal haplotype blocks this situation\n    # makes no sense but if we remove one of the snp because the\n    # degeneration two families can became the same.\n    # these families may be analised on a second round\n    #######################################################\n\n    _find_deg_pattern ( $self );\n\n    #################################################################\n    # if the pattern list length is different to the lenght of the w_hap\n    # we can tell that tow columns have been considered as the same one\n    # and therefore we have to start to remove the values.\n    # remove all columns with degeneration\n    #\n    # For this calculation we don't use the pattern frequency.\n    # All patterns are the same, This selection makes\n    # sense when you have different frequency.\n    #\n    # Note: on this version we don't classify the haplotype by frequency\n    # but if you need to do it. This is the place to do it!!!!\n    #\n    # In reality you don't need to sort the values because you will remove\n    # the values according to their values.\n    #\n    # But as comes from a hash, the order could be different and as a\n    # consequence the code generate on every run of the same set could\n    # differ. That is not important. In fact, does not matter but could\n    # confuse people.\n    #################################################################\n\n    my @tmp =sort { $a <=> $b}\n         keys %{$self -> {deg_pattern}}; # just count the families\n\n    # if the size of the list is different to the size of the degenerated\n    # family. There is degeneration. And the redundancies will be\n    # removed.\n    if($#tmp != $#{$self -> { w_hap } } ){\n        _keep_these_patterns($self->{w_hap}, \\@tmp);\n        _keep_these_patterns($self->{w_pop_freq}, \\@tmp);\n    }\n\n    #################################################################\n    # the steps made before about removing snp and cluster families\n    # are just needed pre-process the haplotype before.\n    #\n    # Now is when the fun starts.\n    #\n    #\n    # once we have the this minimal matrix, we have to calculate the\n    # max multipliticy for the values. The max number of alleles found\n    # on the set. A normal haplotype is biallelic but we can not\n    # reject multiple variations.\n    ##################################################################\n\n    _alleles_number ( $self );\n\n    ##################################################################\n    # Now we have to convert the haplotype into number\n    #\n    # A       C       C       -       T\n    # C       A       G       G       C\n    # A       C       C       C       T\n    # C       G       G       G       C\n    #\n    # one haplotype like this transformed into number produce this result\n    #\n    # 0       0       0       0       0\n    # 1       1       1       1       1\n    # 0       0       0       2       0\n    # 1       2       1       1       1\n    #\n    ##################################################################\n\n    _convert_to_numbers( $self );\n\n    ###################################################################\n    # The next step is to calculate the type of the SNP.\n    # This process is made based on the position of the SNP, the value\n    # and its multiplicity.\n    ###################################################################\n\n    _snp_type_code( $self );\n\n    ###################################################################\n    # now we have all information we need to calculate the haplotype\n    # tagging SNP htSNP\n    ###################################################################\n\n    _htSNP( $self );\n\n    ###################################################################\n    # patch:\n    #\n    # all SNP have a code. but if the SNP is not used this code must\n    # be zero in case of silent SNP. This looks not to informative\n    # because all the information is already there. But this method\n    # compile the full set.\n    ###################################################################\n\n    _snp_and_code_summary( $self );\n}\n\n=head2 input_block\n\n Title   : input_block\n Usage   : $obj->input_block()\n Function: returns input block\n Returns : reference to array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n\n    my $self = shift;\n    return $self -> {input_block};\n}\n\n=head2 hap_length\n\n Title   : hap_length\n Usage   : $obj->hap_length()\n Function: get numbers of SNP on the haplotype\n Returns : scalar\n Args    : none\n Status  : public\n\n\n#------------------------\nsub hap_length{\n#------------------------\n\n    my $self = shift;\n    return scalar @{$self -> {'_snp_ids'}};\n}\n\n\n=head2 pop_freq\n\n Title   : pop_freq\n Usage   : $obj->pop_freq()\n Function: returns population frequency\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub pop_freq{\n#------------------------\n\n    my $self = shift;\n    return $self -> {pop_freq}\n}\n\n\n=head2 deg_snp\n\n\n Title   : deg_snp\n Usage   : $obj->deg_snp()\n Function: returns snp_removes due to indetermination on their values\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{deg_snp};\n}\n\n\n=head2 snp_type\n\n\n Title   : snp_type\n Usage   : $obj->snp_type()\n Function: returns hash with SNP type\n Returns : reference to hash\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type};\n}\n\n\n=head2 silent_snp\n\n\n Title   : silent_snp\n Usage   : $obj->silent_snp()\n Function: some SNP's are silent (not contibuting to the haplotype)\n           and are not considering for this analysis\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub silent_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{silent_snp};\n}\n\n\n=head2 useful_snp\n\n\n Title   : useful_snp\n Usage   : $obj->useful_snp()\n Function: returns list of SNP's that are can be used as htSNP. Some\n           of them can produce the same information. But this is\n           not considered here.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub useful_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{useful_snp};\n}\n\n\n=head2 ht_type\n\n\n Title   : ht_type\n Usage   : $obj->ht_type()\n Function: every useful SNP has a numeric code dependending of its\n           value and position. For a better description see\n           description of the module.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_type{\n#------------------------\n    my $self = shift;\n    return $self -> {ht_type};\n}\n=head2 ht_set\n\n\n Title   : ht_set\n Usage   : $obj->ht_set()\n Function: returns the minimal haplotype in numerical format. This\n           haplotype contains the maximal information about the\n           haplotype variations but with no redundancies. It's the\n           minimal set that describes the haplotype.\n Returns : reference to an array of arrays\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_set{\n#------------------------\n    my $self = shift;\n    return $self -> {w_hap};\n}\n\n=head2 snp_type_code\n\n\n Title   : snp_type_code\n Usage   : $obj->snp_type_code()\n Function: returns the numeric code of the SNPs that need to be\n           tagged that correspond to the SNP's considered in ht_set.\n Returns : reference to an array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type_code{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type_code};\n}\n\n=head2 snp_and_code\n\n\n Title   : snp_and_code\n Usage   : $obj->snp_and_code()\n Function: Returns the full list of SNP's and the code associate to\n           them. If the SNP belongs to the group useful_snp it keep\n           this code. If the SNP is silent the code is 0. And if the\n           SNP is degenerated the code is -1.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_and_code{\n#------------------------\n    my $self = shift;\n    return $self -> {'snp_and_code'};\n}\n\n=head2 deg_pattern\n\n\n Title   : deg_pattern\n Usage   : $obj->deg_pattern()\n Function: Returns the a list with the degenerated haplotype.\n           Sometimes due to degeneration some haplotypes looks\n           the same and if we don't remove them it won't find\n           any tag.\n Returns : reference to a hash of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_pattern{\n#------------------------\n    my $self = shift;\n\n    return $self -> {'deg_pattern'};\n}\n\n=head2 split_hap\n\n\n Title   : split_hap\n Usage   : $obj->split_hap()\n Function: simple representation of the haplotype base by base\n           Same information that input haplotype but base based.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub split_hap{\n#------------------------\n    my $self = shift;\n    return $self -> {'split_hap'};\n}\n\n=head2 _split_haplo\n\n Title   : _split_haplo\n Usage   : _split_haplo($self)\n Function: Take a haplotype and split it into bases\n Returns : self\n Args    : none\n Status  : internal\n\n\n#------------------------\nsub _split_haplo {\n#------------------------\n    my $self = shift;\n\n    my $in  = $self ->{'_haplotype_block'};\n    my $out = $self ->{'w_hap'};\n\n    # split every haplotype and store the result into $out\n    foreach (@$in){\n        push @$out, [split (//,$_)];\n    }\n\n    $self -> {'split_hap'} = dclone ($out);\n}\n\n# internal method to convert the haplotype to uppercase\n\n\n=head2 _to_upper_case\n\n\n Title   : _to_upper_case\n Usage   : _to_upper_case()\n Function: make SNP or in-dels Upper case\n Returns : self\n Args    : an AoA ref\n Status  : private\n\n\n#------------------------\nsub _to_upper_case {\n#------------------------\n    my ($arr) =@_;\n\n    foreach my $aref (@$arr){\n        foreach my $value (@{$aref} ){\n            $value = uc $value;\n        }\n    }\n}\n\n\n=head2 _remove_deg\n\n\n Title   : _remove_deg\n Usage   : _remove_deg()\n Function: when have a indetermination or strange value this SNP\n           is removed\n Returns : haplotype family set and degeneration list\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _remove_deg {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $deg_snp     = $self->{snp_type}->{deg_snp};\n\n    my $rem = [];  # take the position of the array to be removed\n\n    # first we work on the columns we have void values\n    $rem = _find_indet($hap,$rem);  # find degenerated columns\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem); # remove list\n\n        # now remove the values from SNP id\n        _remove_snp_id($snp,$deg_snp,$rem); # remove list\n    }\n}\n\n\n=head2 _rem_silent_snp\n\n\n Title   : _rem_silent_snp\n Usage   : _rem_silent_snp()\n Function: there is the remote possibilty that one SNP won't be a\n           real SNP on this situation we have to remove this SNP,\n           otherwise the program won't find any tag\n Returns : nonthing\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _rem_silent_snp {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $silent_snp  = $self->{snp_type}->{silent_snp};\n\n    my $rem = [];   # store the positions to be removed\n\n    #find columns with no variation on the SNP, Real snp?\n    $rem = _find_silent_snps($hap);\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem);\n\n        # remove the values from SNP id\n        _remove_snp_id($snp,$silent_snp,$rem);\n    }\n}\n\n\n=head2 _find_silent_snps\n\n\n Title   : _find_silent_snps\n Usage   :\n Function: list of snps that are not SNPs. All values for that\n           SNPs on the set is the same one. Look stupid but can\n           happend and if this happend you will not find any tag\n Returns : nothing\n Args    :\n Status  :\n\n\n#------------------------\nsub _find_silent_snps{\n#------------------------\n    my ($arr)=@_;\n\n    my $list =[]; # no snp list;\n\n    # determine the number of snp by the length of the first row.\n    # we assume that the matrix is squared.\n    my $colsn= @{$arr->[0]};\n\n    for (my $i=0;$i<$colsn;$i++){\n        my $different =0;  # check degeneration\n\n        for my $r (1..$#$arr){\n            if($arr->[0][$i] ne $arr->[$r][$i]){\n                $different =1;\n                last;\n            }\n        }\n\n        if(!$different){\n            push (@$list, $i);\n        }\n    }\n\n    return $list;\n}\n\n\n=head2 _find_indet\n\n\n Title   : _find_indet\n Usage   :\n Function: find column (SNP) with invalid or degenerated values\n           and store this values into the second parameter suplied.\n Returns : nothing\n Args    : ref to AoA and ref to an array\n Status  : internal\n\n\n#------------------------\nsub _find_indet{\n#------------------------\n    my ($arr, $list)=@_;\n\n    foreach my $i(0..$#$arr){\n        foreach my $j(0..$#{$arr->[$i]}){\n            unless ($arr->[$i][$j] =~ /[ACTG-]/){\n                if ($#$list<0){\n                    push(@$list,$j);\n                }\n                else{\n                    my $found =0;   # check if already exist the value\n                    foreach my $k(0..$#$list){\n                        $found =1 if ($list->[$k] eq $j);\n                        last if ($found);\n                    }\n                    if(!$found){\n                        push(@$list,$j);\n                    }\n                }\n            }\n        }\n    }\n\n    @$list = sort { $a <=> $b} @$list;\n\n    return $list;\n}\n\n=head2 _remove_col\n\n Title   : _remove_col\n Usage   :\n Function: remove columns contained on the second array from\n           the first arr\n Returns : nothing\n Args    : array of array reference and array reference\n Status  : internal","label":"_remove_col($arr,$rem)"},"detail":"($arr,$rem)","kind":12,"children":[{"kind":13,"line":1271,"containerName":"_remove_col","definition":"my","name":"$arr","localvar":"my"},{"name":"$rem","containerName":"_remove_col","line":1271,"kind":13},{"line":1273,"kind":13,"localvar":"my","containerName":"_remove_col","definition":"my","name":"$col"},{"kind":13,"line":1273,"containerName":"_remove_col","name":"$rem"},{"containerName":"_remove_col","name":"$_","line":1274,"kind":13},{"kind":13,"line":1274,"containerName":"_remove_col","name":"$col"},{"name":"$arr","containerName":"_remove_col","kind":13,"line":1274}],"line":1269},{"name":"_remove_snp_id","range":{"end":{"line":1297,"character":9999},"start":{"character":0,"line":1292}},"kind":12,"line":1292,"children":[{"line":1294,"kind":13,"localvar":"my","name":"$arr","definition":"my","containerName":"_remove_snp_id"},{"name":"$removed","containerName":"_remove_snp_id","line":1294,"kind":13},{"name":"$rem_list","containerName":"_remove_snp_id","kind":13,"line":1294},{"line":1296,"kind":13,"containerName":"_remove_snp_id","name":"$removed"},{"kind":13,"line":1296,"name":"$arr","containerName":"_remove_snp_id"},{"line":1296,"kind":13,"name":"$rem_list","containerName":"_remove_snp_id"}],"containerName":"main::","definition":"sub","detail":"($arr,$removed,$rem_list)","signature":{"documentation":"1;\n# module Bio::PopGen::HtSNP.pm\n# cared by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n#\n\n=head1 NAME\n\nBio::PopGen::HtSNP.pm- Select htSNP from a haplotype set\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::HtSNP;\n\n    my $obj = Bio::PopGen::HtSNP->new($hap,$snp,$pop);\n\n=head1 DESCRIPTION\n\nSelect the minimal set of SNP that contains the full information about\nthe haplotype without redundancies.\n\nTake as input the followin values:\n\n=over 4\n\n* - the haplotype block (array of array).\n\n* - the snp id (array).\n\n* - family information and frequency (array of array).\n\n\nThe final haplotype is generated in a numerical format and the SNP's\nsets can be retrieve from the module.\n\nB<considerations:>\n\n\n- If you force to include a family with indetermination, the SNP's\nwith indetermination will be removed from the analysis, so consider\nbefore to place your data set what do you really want to do.\n\n- If two families have the same information (identical haplotype), one\nof them will be removed and the removed files will be stored classify\nas removed.\n\n- Only are accepted for calculation A, C, G, T and - (as deletion) and\ntheir combinations. Any other value as n or ? will be considered as\ndegenerations due to lack of information.\n\n=head2 RATIONALE\n\nOn a haplotype set is expected that some of the SNP and their\nvariations contribute in the same way to the haplotype. Eliminating\nredundancies will produce a minimal set of SNP's that can be used as\ninput for a taging selection process. On the process SNP's with the\nsame variation are clustered on the same group.\n\nThe idea is that because the tagging haplotype process is\nexponential. All redundant information we could eliminate on the\ntagging process will help to find a quick result.\n\n=head2 CONSTRUCTORS\n\n  my $obj = Bio::PopGen::HtSNP->new\n    (-haplotype_block => \\@haplotype_patterns,\n     -snp_ids         => \\@snp_ids,\n     -pattern_freq    => \\@pattern_name_and_freq);\n\nwhere  $hap, $snp and $pop are in the format:\n\n  my $hap = [\n             'acgt',\n             'agtc',\n             'cgtc'\n            ];                     # haplotype patterns' id\n\n  my $snp = [qw/s1 s2 s3 s4/];     # snps' Id's\n\n  my $pop = [\n             [qw/ uno    0.20/],\n             [qw/ dos    0.20/],\n             [qw/ tres   0.15/],\n            ];                     # haplotype_pattern_id    Frequency\n\n=head2 OBJECT METHODS\n\n    See Below for more detailed summaries.\n\n\n=head1 DETAILS\n\n=head2 How the process is working with one example\n\nLet's begin with one general example of the code.\n\nInput haplotype:\n\n  acgtcca-t\n  cggtagtgc\n  cccccgtgc\n  cgctcgtgc\n\nThe first thing to to is to B<split the haplotype> into characters.\n\n  a       c       g       t       c       c       a       -       t\n  c       g       g       t       a       g       t       g       c\n  c       c       c       c       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n\nNow we have to B<convert> the haplotype to B<Upercase>. This\nwill produce the same SNP if we have input a or A.\n\n  A       C       G       T       C       C       A       -       T\n  C       G       G       T       A       G       T       G       C\n  C       C       C       C       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n\nThe program admit as values any combination of ACTG and - (deletions).\nThe haplotype is B<converted to number>, considering the first variation\nas zero and the alternate value as 1 (see expanded description below).\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n\nOnce we have the haplotype converted to numbers we have to generate the\nsnp type information for the haplotype.\n\n\nB<SNP code = SUM ( value * multiplicity ^ position );>\n\n    where:\n      SUM is the sum of the values for the SNP\n      value is the SNP number code (0 [generally for the mayor allele],\n                                    1 [for the minor allele].\n      position is the position on the block.\n\nFor this example the code is:\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n ------------------------------------------------------------------\n  14      10      12      4       2       14      14      14      14\n\n  14 = 0*2^0 + 1*2^1 + 1*2^2 + 1*2^3\n  12 = 0*2^0 + 1*2^1 + 0*2^2 + 1*2^3\n  ....\n\nOnce we have the families classify. We will B<take> just the SNP's B<not\nredundant>.\n\n  14      10      12      4       2\n\nThis information will be B<passed to the tag module> is you want to tag\nthe htSNP.\n\nWhatever it happens to one SNPs of a class will happen to a SNP of\nthe same class. Therefore you don't need to scan redundancies\n\n=head2 Working with fuzzy data.\n\nThis module is designed to work with fuzzy data. As the source of the\nhaplotype is diverse. The program assume that some haplotypes can be\ngenerated using different values. If there is any indetermination (? or n)\nor any other degenerated value or invalid. The program will take away\nThis SNP and will leave that for a further analysis.\n\nOn a complex situation:\n\n  a       c       g       t       ?       c       a       c       t\n  a       c       g       t       ?       c       a       -       t\n  c       g       ?       t       a       g       ?       g       c\n  c       a       c       t       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n  c       g       g       t       a       g       ?       g       c\n  a       c       ?       t       ?       c       a       c       t\n\nOn this haplotype everything is happening. We have a multialelic variance.\nWe have indeterminations. We have deletions and we have even one SNP\nwhich is not a real SNP.\n\nThe buiding process will be the same on this situation.\n\nConvert the haplotype to uppercase.\n\n  A       C       G       T       ?       C       A       C       T\n  A       C       G       T       ?       C       A       -       T\n  C       G       ?       T       A       G       ?       G       C\n  C       A       C       T       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n  C       G       G       T       A       G       ?       G       C\n  A       C       ?       T       ?       C       A       C       T\n\nAll columns that present indeterminations will be removed from the analysis\non this Step.\n\nhapotype after remove columns:\n\n  A       C       T       C       C       T\n  A       C       T       C       -       T\n  C       G       T       G       G       C\n  C       A       T       G       G       C\n  C       G       T       G       G       C\n  C       G       T       G       G       C\n  A       C       T       C       C       T\n\nAll changes made on the haplotype matrix, will be also made on the SNP list.\n\n  snp_id_1 snp_id_2 snp_id_4 snp_id_6 snp_id_8 snp_id_9\n\nnow the SNP that is not one SNP will be removed from the analysis.\nSNP with Id snp_id_4 (the one with all T's).\n\n\nbecause of the removing. Some of the families will become the same and will\nbe clustered. A posteriori analysis will diference these families.\nbut because of the indetermination can not be distinguish.\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n  C       G       G       G       C\n  C       G       G       G       C\n  A       C       C       C       T\n\nThe result of the mergering will go like:\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n\nOnce again the changes made on the families and we merge the frequency (I<to be\nimplemented>)\n\nBefore to convert the haplotype into numbers we consider how many variations\nwe have on the set. On this case the variations are 3.\n\nThe control code will use on this situation base three as mutiplicity\n\n  0       0       0       0       0\n  0       0       0       1       0\n  1       1       1       2       1\n  1       2       1       2       1\n -----------------------------------\n  36      63      36      75      36\n\nAnd the minimal set for this combination is\n\n  0       0       0\n  0       0       1\n  1       1       2\n  1       2       2\n\nB<NOTE:> this second example is a remote example an on normal conditions. This\nconditions makes no sense, but as the haplotypes, can come from many sources\nwe have to be ready for all kind of combinations.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PopGen::HtSNP;\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse vars qw ();\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = 'Usage:\n\n    Bio::PopGen::HtSNP->new(-haplotype_block -ids -pattern_freq)\n\n';\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Usage   : $obj-> Bio::PopGen::HtSNP->new(-haplotype_block\n                                          -snp_ids\n                                          -pattern_freq)\n Returns : self hash\n Args    : input haplotype (array of array)\n           snp_ids         (array)\n           pop_freq        (array of array)\n Status  : public\n\n\nsub new {\n    my($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($haplotype_block,\n        $snp_ids,\n        $pattern_freq    ) = $self->_rearrange([qw(HAPLOTYPE_BLOCK \n                                                   SNP_IDS\n                                                   PATTERN_FREQ)],@args);\n\n    if ($haplotype_block){\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"Haplotype block has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($snp_ids){\n        $self->snp_ids($snp_ids);\n    }\n    else{\n        $self->throw(\"Array with ids has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($pattern_freq){\n        $self->pattern_freq($pattern_freq);\n    }\n    else{\n        $self->throw(\"Array with pattern id and frequency has not been defined.\n                      \\n$USAGE\");\n    }\n\n    # if the input values are not well formed complained and exit.\n    _check_input($self);\n\n    _do_it($self);\n\n    return $self;\n}\n\n=head2 haplotype_block \n\n Title   : haplotype_block \n Usage   : my $haplotype_block = $HtSNP->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array \n Args    : reference of array with haplotype pattern \n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n=head2 snp_ids \n\n Title   : snp_ids \n Usage   : my $snp_ids = $HtSNP->$snp_ids();\n Function: Get the ids for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\n\nsub snp_ids{\n    my ($self) =shift;\n    return $self->{'_snp_ids'} = shift if @_;\n    return $self->{'_snp_ids'};\n}\n\n\n=head2 pattern_freq\n\n Title   : pattern_freq\n Usage   : my $pattern_freq = $HtSNP->pattern_freq();\n Function: Get the pattern id and frequency  for a haplotype\n           tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\nsub pattern_freq{\n    my ($self) =shift;\n    return $self->{'_pattern_freq'} = shift if @_;\n    return $self->{'_pattern_freq'};\n}\n\n=head2 _check_input\n\n Title   : _check_input\n Usage   : _check_input($self)\n Function: check for errors on the input\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _check_input{\n#------------------------\n\n    my $self = shift;\n\n    _haplotype_length_error($self);\n    _population_error($self);\n\n}\n\n=head2 _haplotype_length_error\n\n Title   : _haplotype_length_error\n Usage   : _haplotype_length_error($self)\n Function: check if the haplotype length is the same that the one on the\n           SNP id list. If not break and exit\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _haplotype_length_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $snp_ids     = $self->snp_ids();\n\n\n    #############################\n    # define error list\n    #############################\n    my $different_haplotype_length = 0;\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n\n    my $snp_number         = scalar @$snp_ids;\n    my $number_of_families = scalar @$input_block;\n    my $h                  = 0; # haplotype position\n\n\n    ############################\n    # haplotype length\n    #\n    # if the length differs from the number of ids\n    ############################\n\n    for ($h=0; $h<$#$input_block+1 ; $h++){\n        if (length $input_block->[$h]  != $snp_number){\n            $different_haplotype_length = 1;\n            last;\n        }\n    }\n\n    # haploytypes does not have the same length\n    if ($different_haplotype_length){\n       $self->throw(\"The number of snp ids is $snp_number and \".\n            \"the length of the family (\". ($h+1) .\") [\".\n             $input_block->[$h].\"] is \".\n             length $input_block->[$h], \"\\n\");\n    }\n}\n\n=head2 _population_error\n\n\n Title   : _population_error\n Usage   : _population_error($self)\n Function: use input_block and pop_freq test if the number of elements\n           match. If doesn't break and quit.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _population_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $pop_freq    = $self->pattern_freq();\n\n    #############################\n    # define error list\n    #############################\n    my $pop_freq_elements_error    = 0;  # matrix bad formed\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n    my $number_of_families = scalar @$input_block;\n\n    my $pf         = 0; # number of elements on population frequency\n    my $frequency  = 0; # population frequency\n    my $p_f_length = 0;\n\n    # check if the pop_freq array is well formed and if the number\n    # of elements fit with the number of families\n\n    #############################\n    # check population frequency\n    #\n    # - population frequency matrix need to be well formed\n    # - get the frequency\n    # - calculate number of families on pop_freq\n    #############################\n\n    for  ($pf=0; $pf<$#$pop_freq+1; $pf++){\n        $frequency += $pop_freq->[$pf]->[1];\n\n        if ( scalar @{$pop_freq->[$pf]} !=2){\n            $p_f_length = scalar @{$pop_freq->[$pf]};\n            $pop_freq_elements_error = 1;\n            last;\n        }\n    }\n\n    ###########################\n    ## error processing\n    ###########################\n\n\n    # The frequency shouldn't be greater than 1\n    if ($frequency >1) {\n        $self->warn(\"The frequency for this set is $frequency (greater than 1)\\n\");\n    }\n\n    # the haplotype matix is not well formed\n    if ($pop_freq_elements_error){\n        $self->throw(\"the frequency matrix is not well formed\\n\".\n             \"\\nThe number of elements for pattern \".($pf+1).\" is \".\n             \"$p_f_length\\n\".\n             \"It should be 2 for pattern \\\"@{$pop_freq->[$pf]}\\\"\\n\".\n             \"\\nFormat should be:\\n\".\n             \"haplotype_id\\t frequency\\n\"\n            );\n    }\n\n    # the size does not fit on pop_freq array\n    #  with the one in haplotype (input_block)\n    if ($pf != $number_of_families) {\n        $self->throw(\"The number of patterns on frequency array ($pf)\\n\".\n             \"does not fit with the number of haplotype patterns on \\n\". \n             \"haplotype array ($number_of_families)\\n\");\n    }\n}\n\n=head2 _do_it\n\n\n Title   : _do_it\n Usage   : _do_it($self)\n Function: Process the input generating the results.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _do_it{\n#------------------------\n\n    my $self = shift;\n\n    # first we are goinf to define here all variables we are going to use\n    $self -> {'w_hap'}          = [];\n    $self -> {'w_pop_freq'}     = dclone ( $self ->pattern_freq() );\n    $self -> {'deg_pattern'}    = {};\n    $self -> {'snp_type'}       = {};  # type of snp on the set. see below\n    $self -> {'alleles_number'} = 0;   # number of variations (biallelic,...)\n    $self -> {'snp_type_code'}  = [];\n    $self -> {'ht_type'}        = [];  # store the snp type used on the htSet\n    $self -> {'split_hap'}      = [];\n    $self -> {'snp_and_code'}   = [];\n\n\n    # we classify the SNP under snp_type\n    $self->{snp_type}->{useful_snp} = dclone ( $self ->snp_ids() );\n    $self->{snp_type}->{deg_snp}    = []; # deg snp\n    $self->{snp_type}->{silent_snp} = []; # not a real snp\n\n    # split the haplotype\n    _split_haplo ($self);\n\n    # first we convert to upper case the haplotype\n    # to make A the same as a for comparison\n    _to_upper_case( $self -> {w_hap} );\n\n    #######################################################\n    # check if any SNP has indetermination. If any SNP has\n    # indetermination this value will be removed.\n    #######################################################\n    _remove_deg ( $self );\n\n    #######################################################\n    # depending of the families you use some SNPs can be\n    # silent. This silent SNP's are not used on the\n    # creation of tags and has to be skipped from the\n    # analysis.\n    #######################################################\n    _rem_silent_snp ( $self );\n\n    #######################################################\n    # for the remaining SNP's we have to check if two\n    # families have the same value. If this is true, the families\n    # will produce the same result and therefore we will not find\n    # any pattern. So, the redundant families need to be take\n    # away from the analysis. But also considered for a further\n    # run.\n    #\n    # When we talk about a normal haplotype blocks this situation\n    # makes no sense but if we remove one of the snp because the\n    # degeneration two families can became the same.\n    # these families may be analised on a second round\n    #######################################################\n\n    _find_deg_pattern ( $self );\n\n    #################################################################\n    # if the pattern list length is different to the lenght of the w_hap\n    # we can tell that tow columns have been considered as the same one\n    # and therefore we have to start to remove the values.\n    # remove all columns with degeneration\n    #\n    # For this calculation we don't use the pattern frequency.\n    # All patterns are the same, This selection makes\n    # sense when you have different frequency.\n    #\n    # Note: on this version we don't classify the haplotype by frequency\n    # but if you need to do it. This is the place to do it!!!!\n    #\n    # In reality you don't need to sort the values because you will remove\n    # the values according to their values.\n    #\n    # But as comes from a hash, the order could be different and as a\n    # consequence the code generate on every run of the same set could\n    # differ. That is not important. In fact, does not matter but could\n    # confuse people.\n    #################################################################\n\n    my @tmp =sort { $a <=> $b}\n         keys %{$self -> {deg_pattern}}; # just count the families\n\n    # if the size of the list is different to the size of the degenerated\n    # family. There is degeneration. And the redundancies will be\n    # removed.\n    if($#tmp != $#{$self -> { w_hap } } ){\n        _keep_these_patterns($self->{w_hap}, \\@tmp);\n        _keep_these_patterns($self->{w_pop_freq}, \\@tmp);\n    }\n\n    #################################################################\n    # the steps made before about removing snp and cluster families\n    # are just needed pre-process the haplotype before.\n    #\n    # Now is when the fun starts.\n    #\n    #\n    # once we have the this minimal matrix, we have to calculate the\n    # max multipliticy for the values. The max number of alleles found\n    # on the set. A normal haplotype is biallelic but we can not\n    # reject multiple variations.\n    ##################################################################\n\n    _alleles_number ( $self );\n\n    ##################################################################\n    # Now we have to convert the haplotype into number\n    #\n    # A       C       C       -       T\n    # C       A       G       G       C\n    # A       C       C       C       T\n    # C       G       G       G       C\n    #\n    # one haplotype like this transformed into number produce this result\n    #\n    # 0       0       0       0       0\n    # 1       1       1       1       1\n    # 0       0       0       2       0\n    # 1       2       1       1       1\n    #\n    ##################################################################\n\n    _convert_to_numbers( $self );\n\n    ###################################################################\n    # The next step is to calculate the type of the SNP.\n    # This process is made based on the position of the SNP, the value\n    # and its multiplicity.\n    ###################################################################\n\n    _snp_type_code( $self );\n\n    ###################################################################\n    # now we have all information we need to calculate the haplotype\n    # tagging SNP htSNP\n    ###################################################################\n\n    _htSNP( $self );\n\n    ###################################################################\n    # patch:\n    #\n    # all SNP have a code. but if the SNP is not used this code must\n    # be zero in case of silent SNP. This looks not to informative\n    # because all the information is already there. But this method\n    # compile the full set.\n    ###################################################################\n\n    _snp_and_code_summary( $self );\n}\n\n=head2 input_block\n\n Title   : input_block\n Usage   : $obj->input_block()\n Function: returns input block\n Returns : reference to array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n\n    my $self = shift;\n    return $self -> {input_block};\n}\n\n=head2 hap_length\n\n Title   : hap_length\n Usage   : $obj->hap_length()\n Function: get numbers of SNP on the haplotype\n Returns : scalar\n Args    : none\n Status  : public\n\n\n#------------------------\nsub hap_length{\n#------------------------\n\n    my $self = shift;\n    return scalar @{$self -> {'_snp_ids'}};\n}\n\n\n=head2 pop_freq\n\n Title   : pop_freq\n Usage   : $obj->pop_freq()\n Function: returns population frequency\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub pop_freq{\n#------------------------\n\n    my $self = shift;\n    return $self -> {pop_freq}\n}\n\n\n=head2 deg_snp\n\n\n Title   : deg_snp\n Usage   : $obj->deg_snp()\n Function: returns snp_removes due to indetermination on their values\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{deg_snp};\n}\n\n\n=head2 snp_type\n\n\n Title   : snp_type\n Usage   : $obj->snp_type()\n Function: returns hash with SNP type\n Returns : reference to hash\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type};\n}\n\n\n=head2 silent_snp\n\n\n Title   : silent_snp\n Usage   : $obj->silent_snp()\n Function: some SNP's are silent (not contibuting to the haplotype)\n           and are not considering for this analysis\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub silent_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{silent_snp};\n}\n\n\n=head2 useful_snp\n\n\n Title   : useful_snp\n Usage   : $obj->useful_snp()\n Function: returns list of SNP's that are can be used as htSNP. Some\n           of them can produce the same information. But this is\n           not considered here.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub useful_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{useful_snp};\n}\n\n\n=head2 ht_type\n\n\n Title   : ht_type\n Usage   : $obj->ht_type()\n Function: every useful SNP has a numeric code dependending of its\n           value and position. For a better description see\n           description of the module.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_type{\n#------------------------\n    my $self = shift;\n    return $self -> {ht_type};\n}\n=head2 ht_set\n\n\n Title   : ht_set\n Usage   : $obj->ht_set()\n Function: returns the minimal haplotype in numerical format. This\n           haplotype contains the maximal information about the\n           haplotype variations but with no redundancies. It's the\n           minimal set that describes the haplotype.\n Returns : reference to an array of arrays\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_set{\n#------------------------\n    my $self = shift;\n    return $self -> {w_hap};\n}\n\n=head2 snp_type_code\n\n\n Title   : snp_type_code\n Usage   : $obj->snp_type_code()\n Function: returns the numeric code of the SNPs that need to be\n           tagged that correspond to the SNP's considered in ht_set.\n Returns : reference to an array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type_code{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type_code};\n}\n\n=head2 snp_and_code\n\n\n Title   : snp_and_code\n Usage   : $obj->snp_and_code()\n Function: Returns the full list of SNP's and the code associate to\n           them. If the SNP belongs to the group useful_snp it keep\n           this code. If the SNP is silent the code is 0. And if the\n           SNP is degenerated the code is -1.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_and_code{\n#------------------------\n    my $self = shift;\n    return $self -> {'snp_and_code'};\n}\n\n=head2 deg_pattern\n\n\n Title   : deg_pattern\n Usage   : $obj->deg_pattern()\n Function: Returns the a list with the degenerated haplotype.\n           Sometimes due to degeneration some haplotypes looks\n           the same and if we don't remove them it won't find\n           any tag.\n Returns : reference to a hash of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_pattern{\n#------------------------\n    my $self = shift;\n\n    return $self -> {'deg_pattern'};\n}\n\n=head2 split_hap\n\n\n Title   : split_hap\n Usage   : $obj->split_hap()\n Function: simple representation of the haplotype base by base\n           Same information that input haplotype but base based.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub split_hap{\n#------------------------\n    my $self = shift;\n    return $self -> {'split_hap'};\n}\n\n=head2 _split_haplo\n\n Title   : _split_haplo\n Usage   : _split_haplo($self)\n Function: Take a haplotype and split it into bases\n Returns : self\n Args    : none\n Status  : internal\n\n\n#------------------------\nsub _split_haplo {\n#------------------------\n    my $self = shift;\n\n    my $in  = $self ->{'_haplotype_block'};\n    my $out = $self ->{'w_hap'};\n\n    # split every haplotype and store the result into $out\n    foreach (@$in){\n        push @$out, [split (//,$_)];\n    }\n\n    $self -> {'split_hap'} = dclone ($out);\n}\n\n# internal method to convert the haplotype to uppercase\n\n\n=head2 _to_upper_case\n\n\n Title   : _to_upper_case\n Usage   : _to_upper_case()\n Function: make SNP or in-dels Upper case\n Returns : self\n Args    : an AoA ref\n Status  : private\n\n\n#------------------------\nsub _to_upper_case {\n#------------------------\n    my ($arr) =@_;\n\n    foreach my $aref (@$arr){\n        foreach my $value (@{$aref} ){\n            $value = uc $value;\n        }\n    }\n}\n\n\n=head2 _remove_deg\n\n\n Title   : _remove_deg\n Usage   : _remove_deg()\n Function: when have a indetermination or strange value this SNP\n           is removed\n Returns : haplotype family set and degeneration list\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _remove_deg {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $deg_snp     = $self->{snp_type}->{deg_snp};\n\n    my $rem = [];  # take the position of the array to be removed\n\n    # first we work on the columns we have void values\n    $rem = _find_indet($hap,$rem);  # find degenerated columns\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem); # remove list\n\n        # now remove the values from SNP id\n        _remove_snp_id($snp,$deg_snp,$rem); # remove list\n    }\n}\n\n\n=head2 _rem_silent_snp\n\n\n Title   : _rem_silent_snp\n Usage   : _rem_silent_snp()\n Function: there is the remote possibilty that one SNP won't be a\n           real SNP on this situation we have to remove this SNP,\n           otherwise the program won't find any tag\n Returns : nonthing\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _rem_silent_snp {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $silent_snp  = $self->{snp_type}->{silent_snp};\n\n    my $rem = [];   # store the positions to be removed\n\n    #find columns with no variation on the SNP, Real snp?\n    $rem = _find_silent_snps($hap);\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem);\n\n        # remove the values from SNP id\n        _remove_snp_id($snp,$silent_snp,$rem);\n    }\n}\n\n\n=head2 _find_silent_snps\n\n\n Title   : _find_silent_snps\n Usage   :\n Function: list of snps that are not SNPs. All values for that\n           SNPs on the set is the same one. Look stupid but can\n           happend and if this happend you will not find any tag\n Returns : nothing\n Args    :\n Status  :\n\n\n#------------------------\nsub _find_silent_snps{\n#------------------------\n    my ($arr)=@_;\n\n    my $list =[]; # no snp list;\n\n    # determine the number of snp by the length of the first row.\n    # we assume that the matrix is squared.\n    my $colsn= @{$arr->[0]};\n\n    for (my $i=0;$i<$colsn;$i++){\n        my $different =0;  # check degeneration\n\n        for my $r (1..$#$arr){\n            if($arr->[0][$i] ne $arr->[$r][$i]){\n                $different =1;\n                last;\n            }\n        }\n\n        if(!$different){\n            push (@$list, $i);\n        }\n    }\n\n    return $list;\n}\n\n\n=head2 _find_indet\n\n\n Title   : _find_indet\n Usage   :\n Function: find column (SNP) with invalid or degenerated values\n           and store this values into the second parameter suplied.\n Returns : nothing\n Args    : ref to AoA and ref to an array\n Status  : internal\n\n\n#------------------------\nsub _find_indet{\n#------------------------\n    my ($arr, $list)=@_;\n\n    foreach my $i(0..$#$arr){\n        foreach my $j(0..$#{$arr->[$i]}){\n            unless ($arr->[$i][$j] =~ /[ACTG-]/){\n                if ($#$list<0){\n                    push(@$list,$j);\n                }\n                else{\n                    my $found =0;   # check if already exist the value\n                    foreach my $k(0..$#$list){\n                        $found =1 if ($list->[$k] eq $j);\n                        last if ($found);\n                    }\n                    if(!$found){\n                        push(@$list,$j);\n                    }\n                }\n            }\n        }\n    }\n\n    @$list = sort { $a <=> $b} @$list;\n\n    return $list;\n}\n\n=head2 _remove_col\n\n Title   : _remove_col\n Usage   :\n Function: remove columns contained on the second array from\n           the first arr\n Returns : nothing\n Args    : array of array reference and array reference\n Status  : internal\n\n\n#------------------------\nsub _remove_col{\n#------------------------\n    my ($arr,$rem)=@_;\n\n    foreach my $col (reverse @$rem){\n        splice @$_, $col, 1 for @$arr;\n    }\n}\n\n\n=head2 _remove_snp_id\n\n Title   : _remove_snp_id\n Usage   :\n Function: remove columns contained on the second array from\n           the first arr\n Returns : nothing\n Args    : array of array reference and array reference\n Status  : internal","parameters":[{"label":"$arr"},{"label":"$removed"},{"label":"$rem_list"}],"label":"_remove_snp_id($arr,$removed,$rem_list)"}},{"children":[{"containerName":"_find_deg_pattern","definition":"my","name":"$self","localvar":"my","kind":13,"line":1314},{"kind":13,"line":1316,"name":"$arr","definition":"my","containerName":"_find_deg_pattern","localvar":"my"},{"containerName":"_find_deg_pattern","name":"$self","kind":13,"line":1316},{"line":1317,"kind":13,"localvar":"my","definition":"my","name":"$list","containerName":"_find_deg_pattern"},{"name":"$self","containerName":"_find_deg_pattern","line":1317,"kind":13},{"line":1320,"kind":13,"localvar":"my","containerName":"_find_deg_pattern","name":"$i","definition":"my"},{"kind":13,"line":1320,"containerName":"_find_deg_pattern","name":"$arr"},{"line":1322,"kind":13,"name":"$list","containerName":"_find_deg_pattern"},{"kind":13,"line":1322,"containerName":"_find_deg_pattern","name":"$i"},{"name":"$list","containerName":"_find_deg_pattern","line":1323,"kind":13},{"containerName":"_find_deg_pattern","name":"$i","kind":13,"line":1323},{"containerName":"_find_deg_pattern","name":"$i","kind":13,"line":1323},{"kind":13,"line":1326,"name":"$j","definition":"my","containerName":"_find_deg_pattern","localvar":"my"},{"containerName":"_find_deg_pattern","name":"$i","kind":13,"line":1326},{"line":1326,"kind":13,"name":"$arr","containerName":"_find_deg_pattern"},{"line":1327,"kind":13,"localvar":"my","definition":"my","name":"$comp","containerName":"_find_deg_pattern"},{"kind":13,"line":1327,"name":"$arr","containerName":"_find_deg_pattern"},{"kind":13,"line":1327,"containerName":"_find_deg_pattern","name":"$i"},{"containerName":"_find_deg_pattern","name":"$arr","line":1327,"kind":13},{"containerName":"_find_deg_pattern","name":"$j","line":1327,"kind":13},{"line":1329,"kind":13,"name":"$comp","containerName":"_find_deg_pattern"},{"line":1332,"kind":13,"localvar":"my","definition":"my","name":"$key","containerName":"_find_deg_pattern"},{"name":"$list","containerName":"_find_deg_pattern","kind":13,"line":1332},{"name":"$i","containerName":"_find_deg_pattern","line":1332,"kind":13},{"kind":13,"line":1334,"name":"$list","containerName":"_find_deg_pattern"},{"kind":13,"line":1334,"containerName":"_find_deg_pattern","name":"$key"},{"containerName":"_find_deg_pattern","name":"$j","line":1334,"kind":13}],"line":1312,"kind":12,"range":{"end":{"line":1339,"character":9999},"start":{"line":1312,"character":0}},"name":"_find_deg_pattern","definition":"sub","containerName":"main::"},{"name":"w_hap","kind":12,"line":1316},{"line":1322,"kind":12,"name":"_is_on_hash"},{"line":1327,"kind":12,"name":"compare_arrays"},{"name":"_key_for_value","kind":12,"line":1332},{"children":[{"line":1346,"kind":13,"localvar":"my","containerName":"_key_for_value","name":"$hash","definition":"my"},{"containerName":"_key_for_value","name":"$value","kind":13,"line":1346},{"kind":13,"line":1348,"name":"$key","definition":"my","containerName":"_key_for_value","localvar":"my"},{"containerName":"_key_for_value","name":"$hash","line":1348,"kind":13},{"line":1349,"kind":13,"containerName":"_key_for_value","name":"$hash"},{"name":"$key","containerName":"_key_for_value","line":1349,"kind":13},{"name":"$value","containerName":"_key_for_value","kind":13,"line":1349},{"name":"$key","containerName":"_key_for_value","line":1350,"kind":13}],"line":1344,"kind":12,"signature":{"label":"_key_for_value($hash,$value)","parameters":[{"label":"$hash"},{"label":"$value"}],"documentation":""},"detail":"($hash,$value)","definition":"sub","containerName":"main::","range":{"start":{"line":1344,"character":0},"end":{"line":1352,"character":9999}},"name":"_key_for_value"},{"name":"_is_there","line":1349,"kind":12},{"name":"_is_on_hash","range":{"start":{"character":0,"line":1356},"end":{"line":1364,"character":9999}},"kind":12,"line":1356,"children":[{"localvar":"my","name":"$hash","definition":"my","containerName":"_is_on_hash","line":1358,"kind":13},{"containerName":"_is_on_hash","name":"$value","line":1358,"kind":13},{"definition":"my","name":"$key","containerName":"_is_on_hash","localvar":"my","kind":13,"line":1360},{"containerName":"_is_on_hash","name":"$hash","kind":13,"line":1360},{"containerName":"_is_on_hash","name":"$hash","kind":13,"line":1361},{"name":"$key","containerName":"_is_on_hash","line":1361,"kind":13},{"kind":13,"line":1361,"name":"$value","containerName":"_is_on_hash"}],"containerName":"main::","definition":"sub","detail":"($hash,$value)","signature":{"parameters":[{"label":"$hash"},{"label":"$value"}],"documentation":"","label":"_is_on_hash($hash,$value)"}},{"line":1361,"kind":12,"name":"_is_there"},{"range":{"end":{"character":9999,"line":1378},"start":{"line":1368,"character":0}},"name":"_is_there","signature":{"documentation":"","parameters":[{"label":"$arr"},{"label":"$value"}],"label":"_is_there($arr,$value)"},"detail":"($arr,$value)","definition":"sub","containerName":"main::","children":[{"containerName":"_is_there","name":"$arr","definition":"my","localvar":"my","kind":13,"line":1371},{"name":"$value","containerName":"_is_there","line":1371,"kind":13},{"definition":"my","name":"$el","containerName":"_is_there","localvar":"my","kind":13,"line":1373},{"containerName":"_is_there","name":"$arr","kind":13,"line":1373},{"containerName":"_is_there","name":"$el","line":1374,"kind":13}],"line":1368,"kind":12},{"kind":12,"line":1374,"name":"value"},{"children":[{"definition":"my","name":"$arr","containerName":"_keep_these_patterns","localvar":"my","kind":13,"line":1397},{"line":1397,"kind":13,"name":"$list","containerName":"_keep_these_patterns"},{"localvar":"my","containerName":"_keep_these_patterns","name":"@outValues","definition":"my","line":1402,"kind":13},{"kind":13,"line":1404,"definition":"my","name":"$k","containerName":"_keep_these_patterns","localvar":"my"},{"kind":13,"line":1404,"containerName":"_keep_these_patterns","name":"$list"},{"name":"@outValues","containerName":"_keep_these_patterns","kind":13,"line":1405},{"containerName":"_keep_these_patterns","name":"$arr","kind":13,"line":1405},{"name":"$k","containerName":"_keep_these_patterns","line":1405,"kind":13},{"line":1409,"kind":13,"name":"$arr","containerName":"_keep_these_patterns"},{"name":"@outValues","containerName":"_keep_these_patterns","line":1409,"kind":13}],"line":1395,"kind":12,"signature":{"documentation":"1;\n# module Bio::PopGen::HtSNP.pm\n# cared by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n#\n\n=head1 NAME\n\nBio::PopGen::HtSNP.pm- Select htSNP from a haplotype set\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::HtSNP;\n\n    my $obj = Bio::PopGen::HtSNP->new($hap,$snp,$pop);\n\n=head1 DESCRIPTION\n\nSelect the minimal set of SNP that contains the full information about\nthe haplotype without redundancies.\n\nTake as input the followin values:\n\n=over 4\n\n* - the haplotype block (array of array).\n\n* - the snp id (array).\n\n* - family information and frequency (array of array).\n\n\nThe final haplotype is generated in a numerical format and the SNP's\nsets can be retrieve from the module.\n\nB<considerations:>\n\n\n- If you force to include a family with indetermination, the SNP's\nwith indetermination will be removed from the analysis, so consider\nbefore to place your data set what do you really want to do.\n\n- If two families have the same information (identical haplotype), one\nof them will be removed and the removed files will be stored classify\nas removed.\n\n- Only are accepted for calculation A, C, G, T and - (as deletion) and\ntheir combinations. Any other value as n or ? will be considered as\ndegenerations due to lack of information.\n\n=head2 RATIONALE\n\nOn a haplotype set is expected that some of the SNP and their\nvariations contribute in the same way to the haplotype. Eliminating\nredundancies will produce a minimal set of SNP's that can be used as\ninput for a taging selection process. On the process SNP's with the\nsame variation are clustered on the same group.\n\nThe idea is that because the tagging haplotype process is\nexponential. All redundant information we could eliminate on the\ntagging process will help to find a quick result.\n\n=head2 CONSTRUCTORS\n\n  my $obj = Bio::PopGen::HtSNP->new\n    (-haplotype_block => \\@haplotype_patterns,\n     -snp_ids         => \\@snp_ids,\n     -pattern_freq    => \\@pattern_name_and_freq);\n\nwhere  $hap, $snp and $pop are in the format:\n\n  my $hap = [\n             'acgt',\n             'agtc',\n             'cgtc'\n            ];                     # haplotype patterns' id\n\n  my $snp = [qw/s1 s2 s3 s4/];     # snps' Id's\n\n  my $pop = [\n             [qw/ uno    0.20/],\n             [qw/ dos    0.20/],\n             [qw/ tres   0.15/],\n            ];                     # haplotype_pattern_id    Frequency\n\n=head2 OBJECT METHODS\n\n    See Below for more detailed summaries.\n\n\n=head1 DETAILS\n\n=head2 How the process is working with one example\n\nLet's begin with one general example of the code.\n\nInput haplotype:\n\n  acgtcca-t\n  cggtagtgc\n  cccccgtgc\n  cgctcgtgc\n\nThe first thing to to is to B<split the haplotype> into characters.\n\n  a       c       g       t       c       c       a       -       t\n  c       g       g       t       a       g       t       g       c\n  c       c       c       c       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n\nNow we have to B<convert> the haplotype to B<Upercase>. This\nwill produce the same SNP if we have input a or A.\n\n  A       C       G       T       C       C       A       -       T\n  C       G       G       T       A       G       T       G       C\n  C       C       C       C       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n\nThe program admit as values any combination of ACTG and - (deletions).\nThe haplotype is B<converted to number>, considering the first variation\nas zero and the alternate value as 1 (see expanded description below).\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n\nOnce we have the haplotype converted to numbers we have to generate the\nsnp type information for the haplotype.\n\n\nB<SNP code = SUM ( value * multiplicity ^ position );>\n\n    where:\n      SUM is the sum of the values for the SNP\n      value is the SNP number code (0 [generally for the mayor allele],\n                                    1 [for the minor allele].\n      position is the position on the block.\n\nFor this example the code is:\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n ------------------------------------------------------------------\n  14      10      12      4       2       14      14      14      14\n\n  14 = 0*2^0 + 1*2^1 + 1*2^2 + 1*2^3\n  12 = 0*2^0 + 1*2^1 + 0*2^2 + 1*2^3\n  ....\n\nOnce we have the families classify. We will B<take> just the SNP's B<not\nredundant>.\n\n  14      10      12      4       2\n\nThis information will be B<passed to the tag module> is you want to tag\nthe htSNP.\n\nWhatever it happens to one SNPs of a class will happen to a SNP of\nthe same class. Therefore you don't need to scan redundancies\n\n=head2 Working with fuzzy data.\n\nThis module is designed to work with fuzzy data. As the source of the\nhaplotype is diverse. The program assume that some haplotypes can be\ngenerated using different values. If there is any indetermination (? or n)\nor any other degenerated value or invalid. The program will take away\nThis SNP and will leave that for a further analysis.\n\nOn a complex situation:\n\n  a       c       g       t       ?       c       a       c       t\n  a       c       g       t       ?       c       a       -       t\n  c       g       ?       t       a       g       ?       g       c\n  c       a       c       t       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n  c       g       g       t       a       g       ?       g       c\n  a       c       ?       t       ?       c       a       c       t\n\nOn this haplotype everything is happening. We have a multialelic variance.\nWe have indeterminations. We have deletions and we have even one SNP\nwhich is not a real SNP.\n\nThe buiding process will be the same on this situation.\n\nConvert the haplotype to uppercase.\n\n  A       C       G       T       ?       C       A       C       T\n  A       C       G       T       ?       C       A       -       T\n  C       G       ?       T       A       G       ?       G       C\n  C       A       C       T       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n  C       G       G       T       A       G       ?       G       C\n  A       C       ?       T       ?       C       A       C       T\n\nAll columns that present indeterminations will be removed from the analysis\non this Step.\n\nhapotype after remove columns:\n\n  A       C       T       C       C       T\n  A       C       T       C       -       T\n  C       G       T       G       G       C\n  C       A       T       G       G       C\n  C       G       T       G       G       C\n  C       G       T       G       G       C\n  A       C       T       C       C       T\n\nAll changes made on the haplotype matrix, will be also made on the SNP list.\n\n  snp_id_1 snp_id_2 snp_id_4 snp_id_6 snp_id_8 snp_id_9\n\nnow the SNP that is not one SNP will be removed from the analysis.\nSNP with Id snp_id_4 (the one with all T's).\n\n\nbecause of the removing. Some of the families will become the same and will\nbe clustered. A posteriori analysis will diference these families.\nbut because of the indetermination can not be distinguish.\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n  C       G       G       G       C\n  C       G       G       G       C\n  A       C       C       C       T\n\nThe result of the mergering will go like:\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n\nOnce again the changes made on the families and we merge the frequency (I<to be\nimplemented>)\n\nBefore to convert the haplotype into numbers we consider how many variations\nwe have on the set. On this case the variations are 3.\n\nThe control code will use on this situation base three as mutiplicity\n\n  0       0       0       0       0\n  0       0       0       1       0\n  1       1       1       2       1\n  1       2       1       2       1\n -----------------------------------\n  36      63      36      75      36\n\nAnd the minimal set for this combination is\n\n  0       0       0\n  0       0       1\n  1       1       2\n  1       2       2\n\nB<NOTE:> this second example is a remote example an on normal conditions. This\nconditions makes no sense, but as the haplotypes, can come from many sources\nwe have to be ready for all kind of combinations.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PopGen::HtSNP;\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse vars qw ();\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = 'Usage:\n\n    Bio::PopGen::HtSNP->new(-haplotype_block -ids -pattern_freq)\n\n';\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Usage   : $obj-> Bio::PopGen::HtSNP->new(-haplotype_block\n                                          -snp_ids\n                                          -pattern_freq)\n Returns : self hash\n Args    : input haplotype (array of array)\n           snp_ids         (array)\n           pop_freq        (array of array)\n Status  : public\n\n\nsub new {\n    my($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($haplotype_block,\n        $snp_ids,\n        $pattern_freq    ) = $self->_rearrange([qw(HAPLOTYPE_BLOCK \n                                                   SNP_IDS\n                                                   PATTERN_FREQ)],@args);\n\n    if ($haplotype_block){\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"Haplotype block has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($snp_ids){\n        $self->snp_ids($snp_ids);\n    }\n    else{\n        $self->throw(\"Array with ids has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($pattern_freq){\n        $self->pattern_freq($pattern_freq);\n    }\n    else{\n        $self->throw(\"Array with pattern id and frequency has not been defined.\n                      \\n$USAGE\");\n    }\n\n    # if the input values are not well formed complained and exit.\n    _check_input($self);\n\n    _do_it($self);\n\n    return $self;\n}\n\n=head2 haplotype_block \n\n Title   : haplotype_block \n Usage   : my $haplotype_block = $HtSNP->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array \n Args    : reference of array with haplotype pattern \n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n=head2 snp_ids \n\n Title   : snp_ids \n Usage   : my $snp_ids = $HtSNP->$snp_ids();\n Function: Get the ids for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\n\nsub snp_ids{\n    my ($self) =shift;\n    return $self->{'_snp_ids'} = shift if @_;\n    return $self->{'_snp_ids'};\n}\n\n\n=head2 pattern_freq\n\n Title   : pattern_freq\n Usage   : my $pattern_freq = $HtSNP->pattern_freq();\n Function: Get the pattern id and frequency  for a haplotype\n           tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\nsub pattern_freq{\n    my ($self) =shift;\n    return $self->{'_pattern_freq'} = shift if @_;\n    return $self->{'_pattern_freq'};\n}\n\n=head2 _check_input\n\n Title   : _check_input\n Usage   : _check_input($self)\n Function: check for errors on the input\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _check_input{\n#------------------------\n\n    my $self = shift;\n\n    _haplotype_length_error($self);\n    _population_error($self);\n\n}\n\n=head2 _haplotype_length_error\n\n Title   : _haplotype_length_error\n Usage   : _haplotype_length_error($self)\n Function: check if the haplotype length is the same that the one on the\n           SNP id list. If not break and exit\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _haplotype_length_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $snp_ids     = $self->snp_ids();\n\n\n    #############################\n    # define error list\n    #############################\n    my $different_haplotype_length = 0;\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n\n    my $snp_number         = scalar @$snp_ids;\n    my $number_of_families = scalar @$input_block;\n    my $h                  = 0; # haplotype position\n\n\n    ############################\n    # haplotype length\n    #\n    # if the length differs from the number of ids\n    ############################\n\n    for ($h=0; $h<$#$input_block+1 ; $h++){\n        if (length $input_block->[$h]  != $snp_number){\n            $different_haplotype_length = 1;\n            last;\n        }\n    }\n\n    # haploytypes does not have the same length\n    if ($different_haplotype_length){\n       $self->throw(\"The number of snp ids is $snp_number and \".\n            \"the length of the family (\". ($h+1) .\") [\".\n             $input_block->[$h].\"] is \".\n             length $input_block->[$h], \"\\n\");\n    }\n}\n\n=head2 _population_error\n\n\n Title   : _population_error\n Usage   : _population_error($self)\n Function: use input_block and pop_freq test if the number of elements\n           match. If doesn't break and quit.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _population_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $pop_freq    = $self->pattern_freq();\n\n    #############################\n    # define error list\n    #############################\n    my $pop_freq_elements_error    = 0;  # matrix bad formed\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n    my $number_of_families = scalar @$input_block;\n\n    my $pf         = 0; # number of elements on population frequency\n    my $frequency  = 0; # population frequency\n    my $p_f_length = 0;\n\n    # check if the pop_freq array is well formed and if the number\n    # of elements fit with the number of families\n\n    #############################\n    # check population frequency\n    #\n    # - population frequency matrix need to be well formed\n    # - get the frequency\n    # - calculate number of families on pop_freq\n    #############################\n\n    for  ($pf=0; $pf<$#$pop_freq+1; $pf++){\n        $frequency += $pop_freq->[$pf]->[1];\n\n        if ( scalar @{$pop_freq->[$pf]} !=2){\n            $p_f_length = scalar @{$pop_freq->[$pf]};\n            $pop_freq_elements_error = 1;\n            last;\n        }\n    }\n\n    ###########################\n    ## error processing\n    ###########################\n\n\n    # The frequency shouldn't be greater than 1\n    if ($frequency >1) {\n        $self->warn(\"The frequency for this set is $frequency (greater than 1)\\n\");\n    }\n\n    # the haplotype matix is not well formed\n    if ($pop_freq_elements_error){\n        $self->throw(\"the frequency matrix is not well formed\\n\".\n             \"\\nThe number of elements for pattern \".($pf+1).\" is \".\n             \"$p_f_length\\n\".\n             \"It should be 2 for pattern \\\"@{$pop_freq->[$pf]}\\\"\\n\".\n             \"\\nFormat should be:\\n\".\n             \"haplotype_id\\t frequency\\n\"\n            );\n    }\n\n    # the size does not fit on pop_freq array\n    #  with the one in haplotype (input_block)\n    if ($pf != $number_of_families) {\n        $self->throw(\"The number of patterns on frequency array ($pf)\\n\".\n             \"does not fit with the number of haplotype patterns on \\n\". \n             \"haplotype array ($number_of_families)\\n\");\n    }\n}\n\n=head2 _do_it\n\n\n Title   : _do_it\n Usage   : _do_it($self)\n Function: Process the input generating the results.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _do_it{\n#------------------------\n\n    my $self = shift;\n\n    # first we are goinf to define here all variables we are going to use\n    $self -> {'w_hap'}          = [];\n    $self -> {'w_pop_freq'}     = dclone ( $self ->pattern_freq() );\n    $self -> {'deg_pattern'}    = {};\n    $self -> {'snp_type'}       = {};  # type of snp on the set. see below\n    $self -> {'alleles_number'} = 0;   # number of variations (biallelic,...)\n    $self -> {'snp_type_code'}  = [];\n    $self -> {'ht_type'}        = [];  # store the snp type used on the htSet\n    $self -> {'split_hap'}      = [];\n    $self -> {'snp_and_code'}   = [];\n\n\n    # we classify the SNP under snp_type\n    $self->{snp_type}->{useful_snp} = dclone ( $self ->snp_ids() );\n    $self->{snp_type}->{deg_snp}    = []; # deg snp\n    $self->{snp_type}->{silent_snp} = []; # not a real snp\n\n    # split the haplotype\n    _split_haplo ($self);\n\n    # first we convert to upper case the haplotype\n    # to make A the same as a for comparison\n    _to_upper_case( $self -> {w_hap} );\n\n    #######################################################\n    # check if any SNP has indetermination. If any SNP has\n    # indetermination this value will be removed.\n    #######################################################\n    _remove_deg ( $self );\n\n    #######################################################\n    # depending of the families you use some SNPs can be\n    # silent. This silent SNP's are not used on the\n    # creation of tags and has to be skipped from the\n    # analysis.\n    #######################################################\n    _rem_silent_snp ( $self );\n\n    #######################################################\n    # for the remaining SNP's we have to check if two\n    # families have the same value. If this is true, the families\n    # will produce the same result and therefore we will not find\n    # any pattern. So, the redundant families need to be take\n    # away from the analysis. But also considered for a further\n    # run.\n    #\n    # When we talk about a normal haplotype blocks this situation\n    # makes no sense but if we remove one of the snp because the\n    # degeneration two families can became the same.\n    # these families may be analised on a second round\n    #######################################################\n\n    _find_deg_pattern ( $self );\n\n    #################################################################\n    # if the pattern list length is different to the lenght of the w_hap\n    # we can tell that tow columns have been considered as the same one\n    # and therefore we have to start to remove the values.\n    # remove all columns with degeneration\n    #\n    # For this calculation we don't use the pattern frequency.\n    # All patterns are the same, This selection makes\n    # sense when you have different frequency.\n    #\n    # Note: on this version we don't classify the haplotype by frequency\n    # but if you need to do it. This is the place to do it!!!!\n    #\n    # In reality you don't need to sort the values because you will remove\n    # the values according to their values.\n    #\n    # But as comes from a hash, the order could be different and as a\n    # consequence the code generate on every run of the same set could\n    # differ. That is not important. In fact, does not matter but could\n    # confuse people.\n    #################################################################\n\n    my @tmp =sort { $a <=> $b}\n         keys %{$self -> {deg_pattern}}; # just count the families\n\n    # if the size of the list is different to the size of the degenerated\n    # family. There is degeneration. And the redundancies will be\n    # removed.\n    if($#tmp != $#{$self -> { w_hap } } ){\n        _keep_these_patterns($self->{w_hap}, \\@tmp);\n        _keep_these_patterns($self->{w_pop_freq}, \\@tmp);\n    }\n\n    #################################################################\n    # the steps made before about removing snp and cluster families\n    # are just needed pre-process the haplotype before.\n    #\n    # Now is when the fun starts.\n    #\n    #\n    # once we have the this minimal matrix, we have to calculate the\n    # max multipliticy for the values. The max number of alleles found\n    # on the set. A normal haplotype is biallelic but we can not\n    # reject multiple variations.\n    ##################################################################\n\n    _alleles_number ( $self );\n\n    ##################################################################\n    # Now we have to convert the haplotype into number\n    #\n    # A       C       C       -       T\n    # C       A       G       G       C\n    # A       C       C       C       T\n    # C       G       G       G       C\n    #\n    # one haplotype like this transformed into number produce this result\n    #\n    # 0       0       0       0       0\n    # 1       1       1       1       1\n    # 0       0       0       2       0\n    # 1       2       1       1       1\n    #\n    ##################################################################\n\n    _convert_to_numbers( $self );\n\n    ###################################################################\n    # The next step is to calculate the type of the SNP.\n    # This process is made based on the position of the SNP, the value\n    # and its multiplicity.\n    ###################################################################\n\n    _snp_type_code( $self );\n\n    ###################################################################\n    # now we have all information we need to calculate the haplotype\n    # tagging SNP htSNP\n    ###################################################################\n\n    _htSNP( $self );\n\n    ###################################################################\n    # patch:\n    #\n    # all SNP have a code. but if the SNP is not used this code must\n    # be zero in case of silent SNP. This looks not to informative\n    # because all the information is already there. But this method\n    # compile the full set.\n    ###################################################################\n\n    _snp_and_code_summary( $self );\n}\n\n=head2 input_block\n\n Title   : input_block\n Usage   : $obj->input_block()\n Function: returns input block\n Returns : reference to array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n\n    my $self = shift;\n    return $self -> {input_block};\n}\n\n=head2 hap_length\n\n Title   : hap_length\n Usage   : $obj->hap_length()\n Function: get numbers of SNP on the haplotype\n Returns : scalar\n Args    : none\n Status  : public\n\n\n#------------------------\nsub hap_length{\n#------------------------\n\n    my $self = shift;\n    return scalar @{$self -> {'_snp_ids'}};\n}\n\n\n=head2 pop_freq\n\n Title   : pop_freq\n Usage   : $obj->pop_freq()\n Function: returns population frequency\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub pop_freq{\n#------------------------\n\n    my $self = shift;\n    return $self -> {pop_freq}\n}\n\n\n=head2 deg_snp\n\n\n Title   : deg_snp\n Usage   : $obj->deg_snp()\n Function: returns snp_removes due to indetermination on their values\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{deg_snp};\n}\n\n\n=head2 snp_type\n\n\n Title   : snp_type\n Usage   : $obj->snp_type()\n Function: returns hash with SNP type\n Returns : reference to hash\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type};\n}\n\n\n=head2 silent_snp\n\n\n Title   : silent_snp\n Usage   : $obj->silent_snp()\n Function: some SNP's are silent (not contibuting to the haplotype)\n           and are not considering for this analysis\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub silent_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{silent_snp};\n}\n\n\n=head2 useful_snp\n\n\n Title   : useful_snp\n Usage   : $obj->useful_snp()\n Function: returns list of SNP's that are can be used as htSNP. Some\n           of them can produce the same information. But this is\n           not considered here.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub useful_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{useful_snp};\n}\n\n\n=head2 ht_type\n\n\n Title   : ht_type\n Usage   : $obj->ht_type()\n Function: every useful SNP has a numeric code dependending of its\n           value and position. For a better description see\n           description of the module.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_type{\n#------------------------\n    my $self = shift;\n    return $self -> {ht_type};\n}\n=head2 ht_set\n\n\n Title   : ht_set\n Usage   : $obj->ht_set()\n Function: returns the minimal haplotype in numerical format. This\n           haplotype contains the maximal information about the\n           haplotype variations but with no redundancies. It's the\n           minimal set that describes the haplotype.\n Returns : reference to an array of arrays\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_set{\n#------------------------\n    my $self = shift;\n    return $self -> {w_hap};\n}\n\n=head2 snp_type_code\n\n\n Title   : snp_type_code\n Usage   : $obj->snp_type_code()\n Function: returns the numeric code of the SNPs that need to be\n           tagged that correspond to the SNP's considered in ht_set.\n Returns : reference to an array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type_code{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type_code};\n}\n\n=head2 snp_and_code\n\n\n Title   : snp_and_code\n Usage   : $obj->snp_and_code()\n Function: Returns the full list of SNP's and the code associate to\n           them. If the SNP belongs to the group useful_snp it keep\n           this code. If the SNP is silent the code is 0. And if the\n           SNP is degenerated the code is -1.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_and_code{\n#------------------------\n    my $self = shift;\n    return $self -> {'snp_and_code'};\n}\n\n=head2 deg_pattern\n\n\n Title   : deg_pattern\n Usage   : $obj->deg_pattern()\n Function: Returns the a list with the degenerated haplotype.\n           Sometimes due to degeneration some haplotypes looks\n           the same and if we don't remove them it won't find\n           any tag.\n Returns : reference to a hash of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_pattern{\n#------------------------\n    my $self = shift;\n\n    return $self -> {'deg_pattern'};\n}\n\n=head2 split_hap\n\n\n Title   : split_hap\n Usage   : $obj->split_hap()\n Function: simple representation of the haplotype base by base\n           Same information that input haplotype but base based.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub split_hap{\n#------------------------\n    my $self = shift;\n    return $self -> {'split_hap'};\n}\n\n=head2 _split_haplo\n\n Title   : _split_haplo\n Usage   : _split_haplo($self)\n Function: Take a haplotype and split it into bases\n Returns : self\n Args    : none\n Status  : internal\n\n\n#------------------------\nsub _split_haplo {\n#------------------------\n    my $self = shift;\n\n    my $in  = $self ->{'_haplotype_block'};\n    my $out = $self ->{'w_hap'};\n\n    # split every haplotype and store the result into $out\n    foreach (@$in){\n        push @$out, [split (//,$_)];\n    }\n\n    $self -> {'split_hap'} = dclone ($out);\n}\n\n# internal method to convert the haplotype to uppercase\n\n\n=head2 _to_upper_case\n\n\n Title   : _to_upper_case\n Usage   : _to_upper_case()\n Function: make SNP or in-dels Upper case\n Returns : self\n Args    : an AoA ref\n Status  : private\n\n\n#------------------------\nsub _to_upper_case {\n#------------------------\n    my ($arr) =@_;\n\n    foreach my $aref (@$arr){\n        foreach my $value (@{$aref} ){\n            $value = uc $value;\n        }\n    }\n}\n\n\n=head2 _remove_deg\n\n\n Title   : _remove_deg\n Usage   : _remove_deg()\n Function: when have a indetermination or strange value this SNP\n           is removed\n Returns : haplotype family set and degeneration list\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _remove_deg {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $deg_snp     = $self->{snp_type}->{deg_snp};\n\n    my $rem = [];  # take the position of the array to be removed\n\n    # first we work on the columns we have void values\n    $rem = _find_indet($hap,$rem);  # find degenerated columns\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem); # remove list\n\n        # now remove the values from SNP id\n        _remove_snp_id($snp,$deg_snp,$rem); # remove list\n    }\n}\n\n\n=head2 _rem_silent_snp\n\n\n Title   : _rem_silent_snp\n Usage   : _rem_silent_snp()\n Function: there is the remote possibilty that one SNP won't be a\n           real SNP on this situation we have to remove this SNP,\n           otherwise the program won't find any tag\n Returns : nonthing\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _rem_silent_snp {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $silent_snp  = $self->{snp_type}->{silent_snp};\n\n    my $rem = [];   # store the positions to be removed\n\n    #find columns with no variation on the SNP, Real snp?\n    $rem = _find_silent_snps($hap);\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem);\n\n        # remove the values from SNP id\n        _remove_snp_id($snp,$silent_snp,$rem);\n    }\n}\n\n\n=head2 _find_silent_snps\n\n\n Title   : _find_silent_snps\n Usage   :\n Function: list of snps that are not SNPs. All values for that\n           SNPs on the set is the same one. Look stupid but can\n           happend and if this happend you will not find any tag\n Returns : nothing\n Args    :\n Status  :\n\n\n#------------------------\nsub _find_silent_snps{\n#------------------------\n    my ($arr)=@_;\n\n    my $list =[]; # no snp list;\n\n    # determine the number of snp by the length of the first row.\n    # we assume that the matrix is squared.\n    my $colsn= @{$arr->[0]};\n\n    for (my $i=0;$i<$colsn;$i++){\n        my $different =0;  # check degeneration\n\n        for my $r (1..$#$arr){\n            if($arr->[0][$i] ne $arr->[$r][$i]){\n                $different =1;\n                last;\n            }\n        }\n\n        if(!$different){\n            push (@$list, $i);\n        }\n    }\n\n    return $list;\n}\n\n\n=head2 _find_indet\n\n\n Title   : _find_indet\n Usage   :\n Function: find column (SNP) with invalid or degenerated values\n           and store this values into the second parameter suplied.\n Returns : nothing\n Args    : ref to AoA and ref to an array\n Status  : internal\n\n\n#------------------------\nsub _find_indet{\n#------------------------\n    my ($arr, $list)=@_;\n\n    foreach my $i(0..$#$arr){\n        foreach my $j(0..$#{$arr->[$i]}){\n            unless ($arr->[$i][$j] =~ /[ACTG-]/){\n                if ($#$list<0){\n                    push(@$list,$j);\n                }\n                else{\n                    my $found =0;   # check if already exist the value\n                    foreach my $k(0..$#$list){\n                        $found =1 if ($list->[$k] eq $j);\n                        last if ($found);\n                    }\n                    if(!$found){\n                        push(@$list,$j);\n                    }\n                }\n            }\n        }\n    }\n\n    @$list = sort { $a <=> $b} @$list;\n\n    return $list;\n}\n\n=head2 _remove_col\n\n Title   : _remove_col\n Usage   :\n Function: remove columns contained on the second array from\n           the first arr\n Returns : nothing\n Args    : array of array reference and array reference\n Status  : internal\n\n\n#------------------------\nsub _remove_col{\n#------------------------\n    my ($arr,$rem)=@_;\n\n    foreach my $col (reverse @$rem){\n        splice @$_, $col, 1 for @$arr;\n    }\n}\n\n\n=head2 _remove_snp_id\n\n Title   : _remove_snp_id\n Usage   :\n Function: remove columns contained on the second array from\n           the first arr\n Returns : nothing\n Args    : array of array reference and array reference\n Status  : internal\n\n\n#------------------------\nsub _remove_snp_id{\n#------------------------\n    my ($arr,$removed,$rem_list)=@_;\n\n    push @$removed, splice @$arr, $_, 1 foreach reverse @$rem_list;\n}\n\n\n=head2 _find_deg_pattern\n\n Title   : _find_deg_pattern\n Usage   :\n Function: create a list with the degenerated patterns\n Returns : @array\n Args    : a ref to AoA\n Status  : public\n\n\n#------------------------\nsub _find_deg_pattern{\n#------------------------\n    my $self  = shift;\n\n    my $arr   = $self ->{w_hap};          # the working haplotype\n    my $list  = $self ->{'deg_pattern'};  # degenerated patterns \n\n    # we have to check all elements\n    foreach my $i(0..$#$arr){\n        # is the element has not been used create a key\n        unless  ( _is_on_hash ($list,\\$i) ) {\n            $list->{$i}=[$i];\n        };\n\n        foreach my $j($i+1..$#$arr){\n            my $comp = compare_arrays($arr->[$i],$arr->[$j]);\n\n            if($comp){\n                # as we have no elements we push this into the list\n                # check for the first element\n                my $key = _key_for_value($list,\\$i);\n\n                push (@{$list->{$key}},$j);\n\n                last;\n            }\n        }\n    }\n\n}\n\n#------------------------\nsub _key_for_value{\n#------------------------\n    my($hash,$value)=@_;\n\n    foreach my $key (keys %$hash){\n        if( _is_there(\\@{$hash->{$key}},$value)){\n            return $key;\n        }\n    }\n}\n\n#------------------------\nsub _is_on_hash{\n#------------------------\n    my($hash,$value)=@_;\n\n    foreach my $key (keys %$hash){\n        if( _is_there(\\@{$hash->{$key}},$value)){\n            return 1;\n        }\n    }\n}\n\n#------------------------\nsub _is_there{\n#------------------------\n\n    my($arr,$value)=@_;\n\n    foreach my $el (@$arr){\n        if ($el eq $$value){\n            return 1;\n        }\n    }\n}\n\n\n=head2 _keep_these_patterns\n\n\n Title   : _keep_these_patterns\n Usage   :\n Function: this is a basic approach, take a LoL and a list,\n           keep just the columns included on the list\n Returns : nothing\n Args    : an AoA and an array\n Status  : public","parameters":[{"label":"$arr"},{"label":"$list"}],"label":"_keep_these_patterns($arr,$list)"},"detail":"($arr,$list)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":1395},"end":{"line":1409,"character":9999}},"name":"_keep_these_patterns"},{"kind":12,"line":1409,"name":"dclone"},{"line":1428,"children":[{"line":1430,"kind":13,"localvar":"my","containerName":"compare_arrays","definition":"my","name":"$first"},{"name":"$second","containerName":"compare_arrays","line":1430,"kind":13},{"kind":13,"line":1431,"containerName":"compare_arrays","name":"$first"},{"name":"$second","containerName":"compare_arrays","kind":13,"line":1431},{"definition":"my","name":"$i","containerName":"compare_arrays","localvar":"my","kind":13,"line":1432},{"kind":13,"line":1432,"containerName":"compare_arrays","name":"$i"},{"name":"$first","containerName":"compare_arrays","line":1432,"kind":13},{"name":"$i","containerName":"compare_arrays","kind":13,"line":1432},{"name":"$first","containerName":"compare_arrays","line":1433,"kind":13},{"containerName":"compare_arrays","name":"$i","line":1433,"kind":13},{"name":"$second","containerName":"compare_arrays","line":1433,"kind":13},{"name":"$i","containerName":"compare_arrays","kind":13,"line":1433}],"kind":12,"detail":"($first,$second)","signature":{"parameters":[{"label":"$first"},{"label":"$second"}],"documentation":"1;\n# module Bio::PopGen::HtSNP.pm\n# cared by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n#\n\n=head1 NAME\n\nBio::PopGen::HtSNP.pm- Select htSNP from a haplotype set\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::HtSNP;\n\n    my $obj = Bio::PopGen::HtSNP->new($hap,$snp,$pop);\n\n=head1 DESCRIPTION\n\nSelect the minimal set of SNP that contains the full information about\nthe haplotype without redundancies.\n\nTake as input the followin values:\n\n=over 4\n\n* - the haplotype block (array of array).\n\n* - the snp id (array).\n\n* - family information and frequency (array of array).\n\n\nThe final haplotype is generated in a numerical format and the SNP's\nsets can be retrieve from the module.\n\nB<considerations:>\n\n\n- If you force to include a family with indetermination, the SNP's\nwith indetermination will be removed from the analysis, so consider\nbefore to place your data set what do you really want to do.\n\n- If two families have the same information (identical haplotype), one\nof them will be removed and the removed files will be stored classify\nas removed.\n\n- Only are accepted for calculation A, C, G, T and - (as deletion) and\ntheir combinations. Any other value as n or ? will be considered as\ndegenerations due to lack of information.\n\n=head2 RATIONALE\n\nOn a haplotype set is expected that some of the SNP and their\nvariations contribute in the same way to the haplotype. Eliminating\nredundancies will produce a minimal set of SNP's that can be used as\ninput for a taging selection process. On the process SNP's with the\nsame variation are clustered on the same group.\n\nThe idea is that because the tagging haplotype process is\nexponential. All redundant information we could eliminate on the\ntagging process will help to find a quick result.\n\n=head2 CONSTRUCTORS\n\n  my $obj = Bio::PopGen::HtSNP->new\n    (-haplotype_block => \\@haplotype_patterns,\n     -snp_ids         => \\@snp_ids,\n     -pattern_freq    => \\@pattern_name_and_freq);\n\nwhere  $hap, $snp and $pop are in the format:\n\n  my $hap = [\n             'acgt',\n             'agtc',\n             'cgtc'\n            ];                     # haplotype patterns' id\n\n  my $snp = [qw/s1 s2 s3 s4/];     # snps' Id's\n\n  my $pop = [\n             [qw/ uno    0.20/],\n             [qw/ dos    0.20/],\n             [qw/ tres   0.15/],\n            ];                     # haplotype_pattern_id    Frequency\n\n=head2 OBJECT METHODS\n\n    See Below for more detailed summaries.\n\n\n=head1 DETAILS\n\n=head2 How the process is working with one example\n\nLet's begin with one general example of the code.\n\nInput haplotype:\n\n  acgtcca-t\n  cggtagtgc\n  cccccgtgc\n  cgctcgtgc\n\nThe first thing to to is to B<split the haplotype> into characters.\n\n  a       c       g       t       c       c       a       -       t\n  c       g       g       t       a       g       t       g       c\n  c       c       c       c       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n\nNow we have to B<convert> the haplotype to B<Upercase>. This\nwill produce the same SNP if we have input a or A.\n\n  A       C       G       T       C       C       A       -       T\n  C       G       G       T       A       G       T       G       C\n  C       C       C       C       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n\nThe program admit as values any combination of ACTG and - (deletions).\nThe haplotype is B<converted to number>, considering the first variation\nas zero and the alternate value as 1 (see expanded description below).\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n\nOnce we have the haplotype converted to numbers we have to generate the\nsnp type information for the haplotype.\n\n\nB<SNP code = SUM ( value * multiplicity ^ position );>\n\n    where:\n      SUM is the sum of the values for the SNP\n      value is the SNP number code (0 [generally for the mayor allele],\n                                    1 [for the minor allele].\n      position is the position on the block.\n\nFor this example the code is:\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n ------------------------------------------------------------------\n  14      10      12      4       2       14      14      14      14\n\n  14 = 0*2^0 + 1*2^1 + 1*2^2 + 1*2^3\n  12 = 0*2^0 + 1*2^1 + 0*2^2 + 1*2^3\n  ....\n\nOnce we have the families classify. We will B<take> just the SNP's B<not\nredundant>.\n\n  14      10      12      4       2\n\nThis information will be B<passed to the tag module> is you want to tag\nthe htSNP.\n\nWhatever it happens to one SNPs of a class will happen to a SNP of\nthe same class. Therefore you don't need to scan redundancies\n\n=head2 Working with fuzzy data.\n\nThis module is designed to work with fuzzy data. As the source of the\nhaplotype is diverse. The program assume that some haplotypes can be\ngenerated using different values. If there is any indetermination (? or n)\nor any other degenerated value or invalid. The program will take away\nThis SNP and will leave that for a further analysis.\n\nOn a complex situation:\n\n  a       c       g       t       ?       c       a       c       t\n  a       c       g       t       ?       c       a       -       t\n  c       g       ?       t       a       g       ?       g       c\n  c       a       c       t       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n  c       g       g       t       a       g       ?       g       c\n  a       c       ?       t       ?       c       a       c       t\n\nOn this haplotype everything is happening. We have a multialelic variance.\nWe have indeterminations. We have deletions and we have even one SNP\nwhich is not a real SNP.\n\nThe buiding process will be the same on this situation.\n\nConvert the haplotype to uppercase.\n\n  A       C       G       T       ?       C       A       C       T\n  A       C       G       T       ?       C       A       -       T\n  C       G       ?       T       A       G       ?       G       C\n  C       A       C       T       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n  C       G       G       T       A       G       ?       G       C\n  A       C       ?       T       ?       C       A       C       T\n\nAll columns that present indeterminations will be removed from the analysis\non this Step.\n\nhapotype after remove columns:\n\n  A       C       T       C       C       T\n  A       C       T       C       -       T\n  C       G       T       G       G       C\n  C       A       T       G       G       C\n  C       G       T       G       G       C\n  C       G       T       G       G       C\n  A       C       T       C       C       T\n\nAll changes made on the haplotype matrix, will be also made on the SNP list.\n\n  snp_id_1 snp_id_2 snp_id_4 snp_id_6 snp_id_8 snp_id_9\n\nnow the SNP that is not one SNP will be removed from the analysis.\nSNP with Id snp_id_4 (the one with all T's).\n\n\nbecause of the removing. Some of the families will become the same and will\nbe clustered. A posteriori analysis will diference these families.\nbut because of the indetermination can not be distinguish.\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n  C       G       G       G       C\n  C       G       G       G       C\n  A       C       C       C       T\n\nThe result of the mergering will go like:\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n\nOnce again the changes made on the families and we merge the frequency (I<to be\nimplemented>)\n\nBefore to convert the haplotype into numbers we consider how many variations\nwe have on the set. On this case the variations are 3.\n\nThe control code will use on this situation base three as mutiplicity\n\n  0       0       0       0       0\n  0       0       0       1       0\n  1       1       1       2       1\n  1       2       1       2       1\n -----------------------------------\n  36      63      36      75      36\n\nAnd the minimal set for this combination is\n\n  0       0       0\n  0       0       1\n  1       1       2\n  1       2       2\n\nB<NOTE:> this second example is a remote example an on normal conditions. This\nconditions makes no sense, but as the haplotypes, can come from many sources\nwe have to be ready for all kind of combinations.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PopGen::HtSNP;\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse vars qw ();\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = 'Usage:\n\n    Bio::PopGen::HtSNP->new(-haplotype_block -ids -pattern_freq)\n\n';\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Usage   : $obj-> Bio::PopGen::HtSNP->new(-haplotype_block\n                                          -snp_ids\n                                          -pattern_freq)\n Returns : self hash\n Args    : input haplotype (array of array)\n           snp_ids         (array)\n           pop_freq        (array of array)\n Status  : public\n\n\nsub new {\n    my($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($haplotype_block,\n        $snp_ids,\n        $pattern_freq    ) = $self->_rearrange([qw(HAPLOTYPE_BLOCK \n                                                   SNP_IDS\n                                                   PATTERN_FREQ)],@args);\n\n    if ($haplotype_block){\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"Haplotype block has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($snp_ids){\n        $self->snp_ids($snp_ids);\n    }\n    else{\n        $self->throw(\"Array with ids has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($pattern_freq){\n        $self->pattern_freq($pattern_freq);\n    }\n    else{\n        $self->throw(\"Array with pattern id and frequency has not been defined.\n                      \\n$USAGE\");\n    }\n\n    # if the input values are not well formed complained and exit.\n    _check_input($self);\n\n    _do_it($self);\n\n    return $self;\n}\n\n=head2 haplotype_block \n\n Title   : haplotype_block \n Usage   : my $haplotype_block = $HtSNP->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array \n Args    : reference of array with haplotype pattern \n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n=head2 snp_ids \n\n Title   : snp_ids \n Usage   : my $snp_ids = $HtSNP->$snp_ids();\n Function: Get the ids for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\n\nsub snp_ids{\n    my ($self) =shift;\n    return $self->{'_snp_ids'} = shift if @_;\n    return $self->{'_snp_ids'};\n}\n\n\n=head2 pattern_freq\n\n Title   : pattern_freq\n Usage   : my $pattern_freq = $HtSNP->pattern_freq();\n Function: Get the pattern id and frequency  for a haplotype\n           tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\nsub pattern_freq{\n    my ($self) =shift;\n    return $self->{'_pattern_freq'} = shift if @_;\n    return $self->{'_pattern_freq'};\n}\n\n=head2 _check_input\n\n Title   : _check_input\n Usage   : _check_input($self)\n Function: check for errors on the input\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _check_input{\n#------------------------\n\n    my $self = shift;\n\n    _haplotype_length_error($self);\n    _population_error($self);\n\n}\n\n=head2 _haplotype_length_error\n\n Title   : _haplotype_length_error\n Usage   : _haplotype_length_error($self)\n Function: check if the haplotype length is the same that the one on the\n           SNP id list. If not break and exit\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _haplotype_length_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $snp_ids     = $self->snp_ids();\n\n\n    #############################\n    # define error list\n    #############################\n    my $different_haplotype_length = 0;\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n\n    my $snp_number         = scalar @$snp_ids;\n    my $number_of_families = scalar @$input_block;\n    my $h                  = 0; # haplotype position\n\n\n    ############################\n    # haplotype length\n    #\n    # if the length differs from the number of ids\n    ############################\n\n    for ($h=0; $h<$#$input_block+1 ; $h++){\n        if (length $input_block->[$h]  != $snp_number){\n            $different_haplotype_length = 1;\n            last;\n        }\n    }\n\n    # haploytypes does not have the same length\n    if ($different_haplotype_length){\n       $self->throw(\"The number of snp ids is $snp_number and \".\n            \"the length of the family (\". ($h+1) .\") [\".\n             $input_block->[$h].\"] is \".\n             length $input_block->[$h], \"\\n\");\n    }\n}\n\n=head2 _population_error\n\n\n Title   : _population_error\n Usage   : _population_error($self)\n Function: use input_block and pop_freq test if the number of elements\n           match. If doesn't break and quit.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _population_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $pop_freq    = $self->pattern_freq();\n\n    #############################\n    # define error list\n    #############################\n    my $pop_freq_elements_error    = 0;  # matrix bad formed\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n    my $number_of_families = scalar @$input_block;\n\n    my $pf         = 0; # number of elements on population frequency\n    my $frequency  = 0; # population frequency\n    my $p_f_length = 0;\n\n    # check if the pop_freq array is well formed and if the number\n    # of elements fit with the number of families\n\n    #############################\n    # check population frequency\n    #\n    # - population frequency matrix need to be well formed\n    # - get the frequency\n    # - calculate number of families on pop_freq\n    #############################\n\n    for  ($pf=0; $pf<$#$pop_freq+1; $pf++){\n        $frequency += $pop_freq->[$pf]->[1];\n\n        if ( scalar @{$pop_freq->[$pf]} !=2){\n            $p_f_length = scalar @{$pop_freq->[$pf]};\n            $pop_freq_elements_error = 1;\n            last;\n        }\n    }\n\n    ###########################\n    ## error processing\n    ###########################\n\n\n    # The frequency shouldn't be greater than 1\n    if ($frequency >1) {\n        $self->warn(\"The frequency for this set is $frequency (greater than 1)\\n\");\n    }\n\n    # the haplotype matix is not well formed\n    if ($pop_freq_elements_error){\n        $self->throw(\"the frequency matrix is not well formed\\n\".\n             \"\\nThe number of elements for pattern \".($pf+1).\" is \".\n             \"$p_f_length\\n\".\n             \"It should be 2 for pattern \\\"@{$pop_freq->[$pf]}\\\"\\n\".\n             \"\\nFormat should be:\\n\".\n             \"haplotype_id\\t frequency\\n\"\n            );\n    }\n\n    # the size does not fit on pop_freq array\n    #  with the one in haplotype (input_block)\n    if ($pf != $number_of_families) {\n        $self->throw(\"The number of patterns on frequency array ($pf)\\n\".\n             \"does not fit with the number of haplotype patterns on \\n\". \n             \"haplotype array ($number_of_families)\\n\");\n    }\n}\n\n=head2 _do_it\n\n\n Title   : _do_it\n Usage   : _do_it($self)\n Function: Process the input generating the results.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _do_it{\n#------------------------\n\n    my $self = shift;\n\n    # first we are goinf to define here all variables we are going to use\n    $self -> {'w_hap'}          = [];\n    $self -> {'w_pop_freq'}     = dclone ( $self ->pattern_freq() );\n    $self -> {'deg_pattern'}    = {};\n    $self -> {'snp_type'}       = {};  # type of snp on the set. see below\n    $self -> {'alleles_number'} = 0;   # number of variations (biallelic,...)\n    $self -> {'snp_type_code'}  = [];\n    $self -> {'ht_type'}        = [];  # store the snp type used on the htSet\n    $self -> {'split_hap'}      = [];\n    $self -> {'snp_and_code'}   = [];\n\n\n    # we classify the SNP under snp_type\n    $self->{snp_type}->{useful_snp} = dclone ( $self ->snp_ids() );\n    $self->{snp_type}->{deg_snp}    = []; # deg snp\n    $self->{snp_type}->{silent_snp} = []; # not a real snp\n\n    # split the haplotype\n    _split_haplo ($self);\n\n    # first we convert to upper case the haplotype\n    # to make A the same as a for comparison\n    _to_upper_case( $self -> {w_hap} );\n\n    #######################################################\n    # check if any SNP has indetermination. If any SNP has\n    # indetermination this value will be removed.\n    #######################################################\n    _remove_deg ( $self );\n\n    #######################################################\n    # depending of the families you use some SNPs can be\n    # silent. This silent SNP's are not used on the\n    # creation of tags and has to be skipped from the\n    # analysis.\n    #######################################################\n    _rem_silent_snp ( $self );\n\n    #######################################################\n    # for the remaining SNP's we have to check if two\n    # families have the same value. If this is true, the families\n    # will produce the same result and therefore we will not find\n    # any pattern. So, the redundant families need to be take\n    # away from the analysis. But also considered for a further\n    # run.\n    #\n    # When we talk about a normal haplotype blocks this situation\n    # makes no sense but if we remove one of the snp because the\n    # degeneration two families can became the same.\n    # these families may be analised on a second round\n    #######################################################\n\n    _find_deg_pattern ( $self );\n\n    #################################################################\n    # if the pattern list length is different to the lenght of the w_hap\n    # we can tell that tow columns have been considered as the same one\n    # and therefore we have to start to remove the values.\n    # remove all columns with degeneration\n    #\n    # For this calculation we don't use the pattern frequency.\n    # All patterns are the same, This selection makes\n    # sense when you have different frequency.\n    #\n    # Note: on this version we don't classify the haplotype by frequency\n    # but if you need to do it. This is the place to do it!!!!\n    #\n    # In reality you don't need to sort the values because you will remove\n    # the values according to their values.\n    #\n    # But as comes from a hash, the order could be different and as a\n    # consequence the code generate on every run of the same set could\n    # differ. That is not important. In fact, does not matter but could\n    # confuse people.\n    #################################################################\n\n    my @tmp =sort { $a <=> $b}\n         keys %{$self -> {deg_pattern}}; # just count the families\n\n    # if the size of the list is different to the size of the degenerated\n    # family. There is degeneration. And the redundancies will be\n    # removed.\n    if($#tmp != $#{$self -> { w_hap } } ){\n        _keep_these_patterns($self->{w_hap}, \\@tmp);\n        _keep_these_patterns($self->{w_pop_freq}, \\@tmp);\n    }\n\n    #################################################################\n    # the steps made before about removing snp and cluster families\n    # are just needed pre-process the haplotype before.\n    #\n    # Now is when the fun starts.\n    #\n    #\n    # once we have the this minimal matrix, we have to calculate the\n    # max multipliticy for the values. The max number of alleles found\n    # on the set. A normal haplotype is biallelic but we can not\n    # reject multiple variations.\n    ##################################################################\n\n    _alleles_number ( $self );\n\n    ##################################################################\n    # Now we have to convert the haplotype into number\n    #\n    # A       C       C       -       T\n    # C       A       G       G       C\n    # A       C       C       C       T\n    # C       G       G       G       C\n    #\n    # one haplotype like this transformed into number produce this result\n    #\n    # 0       0       0       0       0\n    # 1       1       1       1       1\n    # 0       0       0       2       0\n    # 1       2       1       1       1\n    #\n    ##################################################################\n\n    _convert_to_numbers( $self );\n\n    ###################################################################\n    # The next step is to calculate the type of the SNP.\n    # This process is made based on the position of the SNP, the value\n    # and its multiplicity.\n    ###################################################################\n\n    _snp_type_code( $self );\n\n    ###################################################################\n    # now we have all information we need to calculate the haplotype\n    # tagging SNP htSNP\n    ###################################################################\n\n    _htSNP( $self );\n\n    ###################################################################\n    # patch:\n    #\n    # all SNP have a code. but if the SNP is not used this code must\n    # be zero in case of silent SNP. This looks not to informative\n    # because all the information is already there. But this method\n    # compile the full set.\n    ###################################################################\n\n    _snp_and_code_summary( $self );\n}\n\n=head2 input_block\n\n Title   : input_block\n Usage   : $obj->input_block()\n Function: returns input block\n Returns : reference to array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n\n    my $self = shift;\n    return $self -> {input_block};\n}\n\n=head2 hap_length\n\n Title   : hap_length\n Usage   : $obj->hap_length()\n Function: get numbers of SNP on the haplotype\n Returns : scalar\n Args    : none\n Status  : public\n\n\n#------------------------\nsub hap_length{\n#------------------------\n\n    my $self = shift;\n    return scalar @{$self -> {'_snp_ids'}};\n}\n\n\n=head2 pop_freq\n\n Title   : pop_freq\n Usage   : $obj->pop_freq()\n Function: returns population frequency\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub pop_freq{\n#------------------------\n\n    my $self = shift;\n    return $self -> {pop_freq}\n}\n\n\n=head2 deg_snp\n\n\n Title   : deg_snp\n Usage   : $obj->deg_snp()\n Function: returns snp_removes due to indetermination on their values\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{deg_snp};\n}\n\n\n=head2 snp_type\n\n\n Title   : snp_type\n Usage   : $obj->snp_type()\n Function: returns hash with SNP type\n Returns : reference to hash\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type};\n}\n\n\n=head2 silent_snp\n\n\n Title   : silent_snp\n Usage   : $obj->silent_snp()\n Function: some SNP's are silent (not contibuting to the haplotype)\n           and are not considering for this analysis\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub silent_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{silent_snp};\n}\n\n\n=head2 useful_snp\n\n\n Title   : useful_snp\n Usage   : $obj->useful_snp()\n Function: returns list of SNP's that are can be used as htSNP. Some\n           of them can produce the same information. But this is\n           not considered here.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub useful_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{useful_snp};\n}\n\n\n=head2 ht_type\n\n\n Title   : ht_type\n Usage   : $obj->ht_type()\n Function: every useful SNP has a numeric code dependending of its\n           value and position. For a better description see\n           description of the module.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_type{\n#------------------------\n    my $self = shift;\n    return $self -> {ht_type};\n}\n=head2 ht_set\n\n\n Title   : ht_set\n Usage   : $obj->ht_set()\n Function: returns the minimal haplotype in numerical format. This\n           haplotype contains the maximal information about the\n           haplotype variations but with no redundancies. It's the\n           minimal set that describes the haplotype.\n Returns : reference to an array of arrays\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_set{\n#------------------------\n    my $self = shift;\n    return $self -> {w_hap};\n}\n\n=head2 snp_type_code\n\n\n Title   : snp_type_code\n Usage   : $obj->snp_type_code()\n Function: returns the numeric code of the SNPs that need to be\n           tagged that correspond to the SNP's considered in ht_set.\n Returns : reference to an array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type_code{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type_code};\n}\n\n=head2 snp_and_code\n\n\n Title   : snp_and_code\n Usage   : $obj->snp_and_code()\n Function: Returns the full list of SNP's and the code associate to\n           them. If the SNP belongs to the group useful_snp it keep\n           this code. If the SNP is silent the code is 0. And if the\n           SNP is degenerated the code is -1.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_and_code{\n#------------------------\n    my $self = shift;\n    return $self -> {'snp_and_code'};\n}\n\n=head2 deg_pattern\n\n\n Title   : deg_pattern\n Usage   : $obj->deg_pattern()\n Function: Returns the a list with the degenerated haplotype.\n           Sometimes due to degeneration some haplotypes looks\n           the same and if we don't remove them it won't find\n           any tag.\n Returns : reference to a hash of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_pattern{\n#------------------------\n    my $self = shift;\n\n    return $self -> {'deg_pattern'};\n}\n\n=head2 split_hap\n\n\n Title   : split_hap\n Usage   : $obj->split_hap()\n Function: simple representation of the haplotype base by base\n           Same information that input haplotype but base based.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub split_hap{\n#------------------------\n    my $self = shift;\n    return $self -> {'split_hap'};\n}\n\n=head2 _split_haplo\n\n Title   : _split_haplo\n Usage   : _split_haplo($self)\n Function: Take a haplotype and split it into bases\n Returns : self\n Args    : none\n Status  : internal\n\n\n#------------------------\nsub _split_haplo {\n#------------------------\n    my $self = shift;\n\n    my $in  = $self ->{'_haplotype_block'};\n    my $out = $self ->{'w_hap'};\n\n    # split every haplotype and store the result into $out\n    foreach (@$in){\n        push @$out, [split (//,$_)];\n    }\n\n    $self -> {'split_hap'} = dclone ($out);\n}\n\n# internal method to convert the haplotype to uppercase\n\n\n=head2 _to_upper_case\n\n\n Title   : _to_upper_case\n Usage   : _to_upper_case()\n Function: make SNP or in-dels Upper case\n Returns : self\n Args    : an AoA ref\n Status  : private\n\n\n#------------------------\nsub _to_upper_case {\n#------------------------\n    my ($arr) =@_;\n\n    foreach my $aref (@$arr){\n        foreach my $value (@{$aref} ){\n            $value = uc $value;\n        }\n    }\n}\n\n\n=head2 _remove_deg\n\n\n Title   : _remove_deg\n Usage   : _remove_deg()\n Function: when have a indetermination or strange value this SNP\n           is removed\n Returns : haplotype family set and degeneration list\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _remove_deg {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $deg_snp     = $self->{snp_type}->{deg_snp};\n\n    my $rem = [];  # take the position of the array to be removed\n\n    # first we work on the columns we have void values\n    $rem = _find_indet($hap,$rem);  # find degenerated columns\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem); # remove list\n\n        # now remove the values from SNP id\n        _remove_snp_id($snp,$deg_snp,$rem); # remove list\n    }\n}\n\n\n=head2 _rem_silent_snp\n\n\n Title   : _rem_silent_snp\n Usage   : _rem_silent_snp()\n Function: there is the remote possibilty that one SNP won't be a\n           real SNP on this situation we have to remove this SNP,\n           otherwise the program won't find any tag\n Returns : nonthing\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _rem_silent_snp {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $silent_snp  = $self->{snp_type}->{silent_snp};\n\n    my $rem = [];   # store the positions to be removed\n\n    #find columns with no variation on the SNP, Real snp?\n    $rem = _find_silent_snps($hap);\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem);\n\n        # remove the values from SNP id\n        _remove_snp_id($snp,$silent_snp,$rem);\n    }\n}\n\n\n=head2 _find_silent_snps\n\n\n Title   : _find_silent_snps\n Usage   :\n Function: list of snps that are not SNPs. All values for that\n           SNPs on the set is the same one. Look stupid but can\n           happend and if this happend you will not find any tag\n Returns : nothing\n Args    :\n Status  :\n\n\n#------------------------\nsub _find_silent_snps{\n#------------------------\n    my ($arr)=@_;\n\n    my $list =[]; # no snp list;\n\n    # determine the number of snp by the length of the first row.\n    # we assume that the matrix is squared.\n    my $colsn= @{$arr->[0]};\n\n    for (my $i=0;$i<$colsn;$i++){\n        my $different =0;  # check degeneration\n\n        for my $r (1..$#$arr){\n            if($arr->[0][$i] ne $arr->[$r][$i]){\n                $different =1;\n                last;\n            }\n        }\n\n        if(!$different){\n            push (@$list, $i);\n        }\n    }\n\n    return $list;\n}\n\n\n=head2 _find_indet\n\n\n Title   : _find_indet\n Usage   :\n Function: find column (SNP) with invalid or degenerated values\n           and store this values into the second parameter suplied.\n Returns : nothing\n Args    : ref to AoA and ref to an array\n Status  : internal\n\n\n#------------------------\nsub _find_indet{\n#------------------------\n    my ($arr, $list)=@_;\n\n    foreach my $i(0..$#$arr){\n        foreach my $j(0..$#{$arr->[$i]}){\n            unless ($arr->[$i][$j] =~ /[ACTG-]/){\n                if ($#$list<0){\n                    push(@$list,$j);\n                }\n                else{\n                    my $found =0;   # check if already exist the value\n                    foreach my $k(0..$#$list){\n                        $found =1 if ($list->[$k] eq $j);\n                        last if ($found);\n                    }\n                    if(!$found){\n                        push(@$list,$j);\n                    }\n                }\n            }\n        }\n    }\n\n    @$list = sort { $a <=> $b} @$list;\n\n    return $list;\n}\n\n=head2 _remove_col\n\n Title   : _remove_col\n Usage   :\n Function: remove columns contained on the second array from\n           the first arr\n Returns : nothing\n Args    : array of array reference and array reference\n Status  : internal\n\n\n#------------------------\nsub _remove_col{\n#------------------------\n    my ($arr,$rem)=@_;\n\n    foreach my $col (reverse @$rem){\n        splice @$_, $col, 1 for @$arr;\n    }\n}\n\n\n=head2 _remove_snp_id\n\n Title   : _remove_snp_id\n Usage   :\n Function: remove columns contained on the second array from\n           the first arr\n Returns : nothing\n Args    : array of array reference and array reference\n Status  : internal\n\n\n#------------------------\nsub _remove_snp_id{\n#------------------------\n    my ($arr,$removed,$rem_list)=@_;\n\n    push @$removed, splice @$arr, $_, 1 foreach reverse @$rem_list;\n}\n\n\n=head2 _find_deg_pattern\n\n Title   : _find_deg_pattern\n Usage   :\n Function: create a list with the degenerated patterns\n Returns : @array\n Args    : a ref to AoA\n Status  : public\n\n\n#------------------------\nsub _find_deg_pattern{\n#------------------------\n    my $self  = shift;\n\n    my $arr   = $self ->{w_hap};          # the working haplotype\n    my $list  = $self ->{'deg_pattern'};  # degenerated patterns \n\n    # we have to check all elements\n    foreach my $i(0..$#$arr){\n        # is the element has not been used create a key\n        unless  ( _is_on_hash ($list,\\$i) ) {\n            $list->{$i}=[$i];\n        };\n\n        foreach my $j($i+1..$#$arr){\n            my $comp = compare_arrays($arr->[$i],$arr->[$j]);\n\n            if($comp){\n                # as we have no elements we push this into the list\n                # check for the first element\n                my $key = _key_for_value($list,\\$i);\n\n                push (@{$list->{$key}},$j);\n\n                last;\n            }\n        }\n    }\n\n}\n\n#------------------------\nsub _key_for_value{\n#------------------------\n    my($hash,$value)=@_;\n\n    foreach my $key (keys %$hash){\n        if( _is_there(\\@{$hash->{$key}},$value)){\n            return $key;\n        }\n    }\n}\n\n#------------------------\nsub _is_on_hash{\n#------------------------\n    my($hash,$value)=@_;\n\n    foreach my $key (keys %$hash){\n        if( _is_there(\\@{$hash->{$key}},$value)){\n            return 1;\n        }\n    }\n}\n\n#------------------------\nsub _is_there{\n#------------------------\n\n    my($arr,$value)=@_;\n\n    foreach my $el (@$arr){\n        if ($el eq $$value){\n            return 1;\n        }\n    }\n}\n\n\n=head2 _keep_these_patterns\n\n\n Title   : _keep_these_patterns\n Usage   :\n Function: this is a basic approach, take a LoL and a list,\n           keep just the columns included on the list\n Returns : nothing\n Args    : an AoA and an array\n Status  : public\n\n\n#------------------------\nsub _keep_these_patterns{\n#------------------------\n    my ($arr,$list)=@_;\n\n    # by now we just take one of the repetitions but you can weight\n    # the values by frequency\n\n    my @outValues=();\n\n    foreach my $k (@$list){\n        push @outValues, $arr->[$k];\n    }\n\n    #make arr to hold the new values\n    @$arr= @{dclone(\\@outValues)};\n\n}\n\n\n=head2 compare_arrays\n\n\n Title   : compare_arrays\n Usage   :\n Function: take two arrays and compare their values\n Returns : 1 if the two values are the same\n           0 if the values are different\n Args    : an AoA and an array\n Status  : public","label":"compare_arrays($first,$second)"},"containerName":"main::","definition":"sub","range":{"end":{"line":1436,"character":9999},"start":{"character":0,"line":1428}},"name":"compare_arrays"},{"kind":12,"children":[{"localvar":"my","containerName":"_convert_to_numbers","definition":"my","name":"$self","line":1455,"kind":13},{"localvar":"my","name":"$hap_ref","definition":"my","containerName":"_convert_to_numbers","line":1457,"kind":13},{"containerName":"_convert_to_numbers","name":"$self","kind":13,"line":1457},{"localvar":"my","containerName":"_convert_to_numbers","definition":"my","name":"$mm","line":1458,"kind":13},{"name":"$self","containerName":"_convert_to_numbers","line":1458,"kind":13},{"kind":13,"line":1463,"definition":"my","name":"$length","containerName":"_convert_to_numbers","localvar":"my"},{"kind":13,"line":1463,"containerName":"_convert_to_numbers","name":"$hap_ref"}],"line":1453,"name":"_convert_to_numbers","definition":"sub","containerName":"main::","range":{"start":{"line":1453,"character":0},"end":{"character":9999,"line":1463}}},{"line":1457,"kind":12,"name":"w_hap"},{"line":1458,"kind":12,"name":"alleles_number"},{"name":"$c","definition":"my","containerName":null,"localvar":"my","kind":13,"line":1465},{"line":1465,"kind":13,"containerName":null,"name":"$c"},{"line":1465,"kind":13,"name":"$length","containerName":null},{"name":"%c","containerName":null,"kind":13,"line":1465},{"line":1467,"kind":13,"localvar":"my","name":"@al","definition":"my","containerName":null},{"containerName":null,"name":"$r","definition":"my","localvar":"my","kind":13,"line":1469},{"line":1469,"kind":13,"name":"%hap_ref","containerName":null},{"name":"@al","containerName":null,"line":1471,"kind":13},{"kind":13,"line":1471,"containerName":null,"name":"@hap_ref"},{"line":1471,"kind":13,"name":"@r","containerName":null},{"containerName":null,"name":"$c","kind":13,"line":1471},{"kind":13,"line":1472,"containerName":null,"name":"@al"},{"line":1472,"kind":13,"containerName":null,"name":"@hap_ref"},{"kind":13,"line":1472,"name":"@r","containerName":null},{"line":1472,"kind":13,"name":"$c","containerName":null},{"kind":13,"line":1474,"containerName":null,"name":"@hap_ref"},{"kind":13,"line":1474,"name":"@r","containerName":null},{"line":1474,"kind":13,"containerName":null,"name":"$c"},{"kind":12,"line":1474,"name":"get_position"},{"containerName":null,"name":"@al","line":1474,"kind":13},{"containerName":null,"name":"@hap_ref","line":1474,"kind":13},{"line":1474,"kind":13,"containerName":null,"name":"@r"},{"kind":13,"line":1474,"name":"$c","containerName":null},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"_snp_type_code","localvar":"my","kind":13,"line":1514},{"definition":"my","name":"$hap","containerName":"_snp_type_code","localvar":"my","kind":13,"line":1516},{"kind":13,"line":1516,"name":"$self","containerName":"_snp_type_code"},{"localvar":"my","containerName":"_snp_type_code","name":"$arr","definition":"my","line":1517,"kind":13},{"name":"$self","containerName":"_snp_type_code","line":1517,"kind":13},{"line":1518,"kind":13,"localvar":"my","containerName":"_snp_type_code","name":"$al","definition":"my"},{"name":"$self","containerName":"_snp_type_code","line":1518,"kind":13},{"name":"$length","definition":"my","containerName":"_snp_type_code","localvar":"my","kind":13,"line":1520},{"containerName":"_snp_type_code","name":"$hap","line":1520,"kind":13}],"line":1512,"definition":"sub","name":"_snp_type_code","containerName":"main::","range":{"end":{"character":9999,"line":1520},"start":{"line":1512,"character":0}}},{"name":"w_hap","kind":12,"line":1516},{"name":"snp_type_code","kind":12,"line":1517},{"name":"alleles_number","line":1518,"kind":12},{"kind":13,"line":1522,"containerName":null,"name":"$c","definition":"my","localvar":"my"},{"kind":13,"line":1522,"name":"$c","containerName":null},{"kind":13,"line":1522,"containerName":null,"name":"$length"},{"name":"%c","containerName":null,"kind":13,"line":1522},{"line":1523,"kind":13,"localvar":"my","containerName":null,"name":"$r","definition":"my"},{"line":1523,"kind":13,"name":"%hap","containerName":null},{"line":1524,"kind":13,"containerName":null,"name":"@arr"},{"containerName":null,"name":"$c","kind":13,"line":1524},{"containerName":null,"name":"@hap","line":1524,"kind":13},{"containerName":null,"name":"@r","kind":13,"line":1524},{"kind":13,"line":1524,"containerName":null,"name":"$c"},{"line":1524,"kind":13,"containerName":null,"name":"$al"},{"containerName":null,"name":"$r","kind":13,"line":1524},{"containerName":"main::","definition":"sub","detail":"($array,$value)","signature":{"label":"get_position($array,$value)","documentation":" return the position of an element in one array\n The element is always present on the array","parameters":[{"label":"$array"},{"label":"$value"}]},"kind":12,"line":1535,"children":[{"kind":13,"line":1538,"containerName":"get_position","name":"$array","definition":"my","localvar":"my"},{"name":"$value","containerName":"get_position","kind":13,"line":1538},{"line":1540,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":"get_position"},{"kind":13,"line":1540,"name":"$array","containerName":"get_position"},{"line":1541,"kind":13,"containerName":"get_position","name":"$array"},{"containerName":"get_position","name":"$i","kind":13,"line":1541},{"containerName":"get_position","name":"$i","line":1542,"kind":13}],"name":"get_position","range":{"end":{"character":9999,"line":1546},"start":{"character":0,"line":1535}}},{"kind":12,"line":1541,"name":"value"},{"range":{"end":{"line":1571,"character":9999},"start":{"character":0,"line":1564}},"containerName":"main::","definition":"sub","name":"_alleles_number","line":1564,"children":[{"containerName":"_alleles_number","name":"$self","definition":"my","localvar":"my","kind":13,"line":1567},{"line":1569,"kind":13,"localvar":"my","name":"$hap_ref","definition":"my","containerName":"_alleles_number"},{"kind":13,"line":1569,"containerName":"_alleles_number","name":"$self"},{"containerName":"_alleles_number","name":"$length","definition":"my","localvar":"my","kind":13,"line":1571},{"line":1571,"kind":13,"name":"$hap_ref","containerName":"_alleles_number"}],"kind":12},{"name":"w_hap","kind":12,"line":1569},{"kind":13,"line":1573,"definition":"my","name":"$c","containerName":null,"localvar":"my"},{"containerName":null,"name":"$c","kind":13,"line":1573},{"name":"$length","containerName":null,"line":1573,"kind":13},{"containerName":null,"name":"%c","line":1573,"kind":13},{"localvar":"my","containerName":null,"definition":"my","name":"%alleles","line":1575,"kind":13},{"line":1577,"kind":13,"localvar":"my","containerName":null,"name":"$r","definition":"my"},{"containerName":null,"name":"%hap_ref","line":1577,"kind":13},{"kind":13,"line":1578,"name":"%alleles","containerName":null},{"name":"@hap_ref","containerName":null,"kind":13,"line":1578},{"line":1578,"kind":13,"containerName":null,"name":"@r"},{"containerName":null,"name":"$c","line":1578,"kind":13},{"containerName":null,"name":"%self","line":1583,"kind":13},{"name":"alleles_number","line":1583,"kind":12},{"name":"%alleles","containerName":null,"kind":13,"line":1583},{"name":"%self","containerName":null,"line":1584,"kind":13},{"line":1584,"kind":12,"name":"alleles_number"},{"line":1584,"kind":13,"name":"%alleles","containerName":null},{"range":{"start":{"character":0,"line":1604},"end":{"line":1635,"character":9999}},"name":"_htSNP","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_htSNP","localvar":"my","kind":13,"line":1606},{"containerName":"_htSNP","definition":"my","name":"$hap","localvar":"my","kind":13,"line":1608},{"name":"$self","containerName":"_htSNP","kind":13,"line":1608},{"line":1609,"kind":13,"localvar":"my","containerName":"_htSNP","definition":"my","name":"$type"},{"line":1609,"kind":13,"containerName":"_htSNP","name":"$self"},{"localvar":"my","name":"$set","definition":"my","containerName":"_htSNP","line":1610,"kind":13},{"kind":13,"line":1610,"name":"$self","containerName":"_htSNP"},{"kind":13,"line":1611,"name":"$out","definition":"my","containerName":"_htSNP","localvar":"my"},{"localvar":"my","containerName":"_htSNP","name":"$nc","definition":"my","line":1613,"kind":13},{"kind":13,"line":1616,"containerName":"_htSNP","name":"$c","definition":"my","localvar":"my"},{"kind":13,"line":1616,"name":"$type","containerName":"_htSNP"},{"kind":13,"line":1618,"containerName":"_htSNP","definition":"my","name":"$exist","localvar":"my"},{"containerName":"_htSNP","name":"$set","line":1621,"kind":13},{"containerName":"_htSNP","name":"$type","line":1621,"kind":13},{"containerName":"_htSNP","name":"$c","kind":13,"line":1621},{"name":"$set","containerName":"_htSNP","kind":13,"line":1622},{"containerName":"_htSNP","name":"$type","line":1622,"kind":13},{"name":"$c","containerName":"_htSNP","kind":13,"line":1622},{"kind":13,"line":1624,"containerName":"_htSNP","name":"$exist"},{"containerName":"_htSNP","name":"$r","definition":"my","localvar":"my","kind":13,"line":1626},{"kind":13,"line":1626,"name":"$hap","containerName":"_htSNP"},{"name":"$out","containerName":"_htSNP","kind":13,"line":1628},{"name":"$r","containerName":"_htSNP","kind":13,"line":1628},{"line":1628,"kind":13,"containerName":"_htSNP","name":"$nc"},{"name":"$hap","containerName":"_htSNP","kind":13,"line":1628},{"line":1628,"kind":13,"containerName":"_htSNP","name":"$r"},{"containerName":"_htSNP","name":"$c","kind":13,"line":1628},{"kind":13,"line":1632,"name":"$exist","containerName":"_htSNP"},{"line":1632,"kind":13,"containerName":"_htSNP","name":"$nc"},{"containerName":"_htSNP","name":"$hap","line":1635,"kind":13},{"line":1635,"kind":13,"containerName":"_htSNP","name":"$out"}],"line":1604,"kind":12},{"name":"dclone","kind":12,"line":1635},{"range":{"end":{"character":9999,"line":1696},"start":{"character":0,"line":1658}},"containerName":"main::","definition":"sub","name":"_snp_and_code_summary","line":1658,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_snp_and_code_summary","line":1660,"kind":13},{"localvar":"my","containerName":"_snp_and_code_summary","name":"$snp_type_code","definition":"my","line":1662,"kind":13},{"line":1662,"kind":13,"name":"$self","containerName":"_snp_and_code_summary"},{"kind":13,"line":1663,"containerName":"_snp_and_code_summary","definition":"my","name":"$useful_snp","localvar":"my"},{"kind":13,"line":1663,"name":"$self","containerName":"_snp_and_code_summary"},{"name":"$silent_snp","definition":"my","containerName":"_snp_and_code_summary","localvar":"my","kind":13,"line":1664},{"name":"$self","containerName":"_snp_and_code_summary","line":1664,"kind":13},{"kind":13,"line":1665,"definition":"my","name":"$deg_snp","containerName":"_snp_and_code_summary","localvar":"my"},{"containerName":"_snp_and_code_summary","name":"$self","kind":13,"line":1665},{"localvar":"my","containerName":"_snp_and_code_summary","name":"$snp_ids","definition":"my","line":1666,"kind":13},{"containerName":"_snp_and_code_summary","name":"$self","kind":13,"line":1666},{"line":1666,"kind":12,"name":"snp_ids","containerName":"_snp_and_code_summary"},{"kind":13,"line":1667,"containerName":"_snp_and_code_summary","name":"$snp_and_code","definition":"my","localvar":"my"},{"kind":13,"line":1667,"containerName":"_snp_and_code_summary","name":"$self"},{"line":1672,"kind":13,"localvar":"my","containerName":"_snp_and_code_summary","definition":"my","name":"$i"},{"line":1672,"kind":13,"containerName":"_snp_and_code_summary","name":"$snp_ids"},{"kind":13,"line":1675,"definition":"my","name":"$value","containerName":"_snp_and_code_summary","localvar":"my"},{"name":"$j","definition":"my","containerName":"_snp_and_code_summary","localvar":"my","kind":13,"line":1678},{"line":1678,"kind":13,"name":"$useful_snp","containerName":"_snp_and_code_summary"},{"containerName":"_snp_and_code_summary","name":"$snp_ids","line":1679,"kind":13},{"name":"$i","containerName":"_snp_and_code_summary","line":1679,"kind":13},{"line":1679,"kind":13,"containerName":"_snp_and_code_summary","name":"$useful_snp"},{"name":"$j","containerName":"_snp_and_code_summary","line":1679,"kind":13},{"kind":13,"line":1680,"name":"$value","containerName":"_snp_and_code_summary"},{"name":"$snp_type_code","containerName":"_snp_and_code_summary","line":1680,"kind":13},{"kind":13,"line":1680,"name":"$j","containerName":"_snp_and_code_summary"},{"localvar":"my","containerName":"_snp_and_code_summary","name":"$j","definition":"my","line":1686,"kind":13},{"kind":13,"line":1686,"containerName":"_snp_and_code_summary","name":"$deg_snp"},{"line":1687,"kind":13,"containerName":"_snp_and_code_summary","name":"$snp_ids"},{"line":1687,"kind":13,"name":"$i","containerName":"_snp_and_code_summary"},{"kind":13,"line":1687,"containerName":"_snp_and_code_summary","name":"$deg_snp"},{"kind":13,"line":1687,"name":"$j","containerName":"_snp_and_code_summary"},{"kind":13,"line":1688,"containerName":"_snp_and_code_summary","name":"$value"},{"kind":13,"line":1693,"name":"$snp_ids","containerName":"_snp_and_code_summary"},{"containerName":"_snp_and_code_summary","name":"$i","kind":13,"line":1693},{"containerName":"_snp_and_code_summary","name":"$value","kind":13,"line":1693}],"kind":12}],"version":5}