{"vars":[{"kind":2,"line":64,"name":"base","containerName":""},{"kind":12,"children":[{"kind":13,"line":101,"definition":"my","name":"$pkg","containerName":"new","localvar":"my"},{"name":"@args","containerName":"new","kind":13,"line":101},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":103},{"line":103,"kind":13,"containerName":"new","name":"$pkg"},{"line":103,"kind":13,"name":"@args","containerName":"new"},{"name":"$leavesR","definition":"my","containerName":"new","localvar":"my","kind":13,"line":105},{"name":"$numleaves","containerName":"new","line":105,"kind":13},{"kind":13,"line":105,"name":"$numhybrids","containerName":"new"},{"containerName":"new","name":"$norepeat","kind":13,"line":105},{"kind":13,"line":106,"containerName":"new","name":"$self"},{"line":106,"kind":12,"name":"_rearrange","containerName":"new"},{"kind":13,"line":109,"containerName":"new","name":"@args"},{"kind":13,"line":110,"containerName":"new","name":"@leaves","definition":"my","localvar":"my"},{"kind":13,"line":111,"name":"$leavesR","containerName":"new"},{"containerName":"new","name":"$numleaves","line":111,"kind":13},{"name":"@leaves","containerName":"new","line":112,"kind":13},{"containerName":"new","name":"$numleaves","line":112,"kind":13},{"line":113,"kind":13,"containerName":"new","name":"$leavesR"},{"line":113,"kind":13,"name":"@leaves","containerName":"new"},{"kind":13,"line":115,"containerName":"new","name":"$leavesR"},{"containerName":"new","name":"$self","kind":13,"line":116},{"containerName":"new","name":"throw","line":116,"kind":12},{"line":118,"kind":13,"containerName":"new","name":"$norepeat"},{"name":"$self","containerName":"new","kind":13,"line":120},{"kind":13,"line":120,"containerName":"new","name":"@leaves"},{"name":"$self","containerName":"new","line":121,"kind":13},{"line":121,"kind":13,"name":"$numleaves","containerName":"new"},{"containerName":"new","name":"$self","line":122,"kind":13},{"containerName":"new","name":"$numhybrids","kind":13,"line":122},{"line":122,"kind":13,"containerName":"new","name":"$numhybrids"},{"line":123,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"$norepeat","line":123,"kind":13},{"kind":13,"line":124,"name":"$self","containerName":"new"},{"name":"$self","containerName":"new","line":125,"kind":13},{"kind":12,"line":125,"containerName":"new","name":"new"},{"name":"@leaves","containerName":"new","kind":13,"line":125},{"kind":13,"line":126,"containerName":"new","name":"$self"},{"containerName":"new","name":"$pkg","line":126,"kind":13}],"line":100,"definition":"sub","containerName":"main::","signature":{"label":"new($pkg,@args)","parameters":[{"label":"$pkg"},{"label":"@args"}],"documentation":"1;\n# $Id: RandomFactory.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::RandomFactory - Module to generate random\nPhylogenetic Networks\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::RandomFactory;\n\n # Will generate at random all the 66 binary tree-child phylogenetic\n # networks with 3 leaves\n\n my $factory=Bio::PhyloNetwork::RandomFactory->new(-numleaves=>3,-norepeat=>1);\n\n my @nets;\n\n for (my $i=0; $i<66; $i++) {\n   my $net=$factory->next_network();\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nBuilds a random (binary tree-child) phylogenetic network each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::RandomFactory;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\nuse Math::Random;\nuse Bio::Tree::RandomFactory;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::RandomFactory();\n Function: Creates a new Bio::PhyloNetwork::RandomFactory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n           -numhybrids => integer [optional]\n           -norepeat => boolean [optional]\n\nReturns a Bio::PhyloNetwork::RandomFactory object. Such an object will create\nrandom binary tree-child phylogenetic networks each time next_network\nis called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\nIf the parameter -numhybrids=E<gt>$numhybrids is given, then the generated\nnetworks will have exactly $numhybrids hybrid nodes. Note that, necessarily,\n$numhybrids E<lt> $numleaves. Otherwise, the number of hybrid nodes will be chosen\nat random for each call of next_network.\n\nIf the parameter -norepeat=E<gt>1 is given, then successive calls of next_network\nwill give non-isomorphic networks."},"detail":"($pkg,@args)","name":"new","range":{"start":{"line":100,"character":0},"end":{"line":127,"character":9999}}},{"line":101,"kind":2,"containerName":"Bio::PhyloNetwork::Math::Random::Bio::Tree","name":"RandomFactory"},{"containerName":"new","name":"SUPER","line":103,"kind":12},{"name":"leaves","kind":12,"line":120},{"name":"numleaves","line":121,"kind":12},{"name":"numhybrids","line":122,"kind":12},{"line":123,"kind":12,"name":"norepeat"},{"kind":12,"line":124,"name":"found"},{"line":125,"kind":12,"name":"tree_factory"},{"line":125,"kind":12,"containerName":"Tree::RandomFactory","name":"Bio"},{"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: RandomFactory.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::RandomFactory - Module to generate random\nPhylogenetic Networks\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::RandomFactory;\n\n # Will generate at random all the 66 binary tree-child phylogenetic\n # networks with 3 leaves\n\n my $factory=Bio::PhyloNetwork::RandomFactory->new(-numleaves=>3,-norepeat=>1);\n\n my @nets;\n\n for (my $i=0; $i<66; $i++) {\n   my $net=$factory->next_network();\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nBuilds a random (binary tree-child) phylogenetic network each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::RandomFactory;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\nuse Math::Random;\nuse Bio::Tree::RandomFactory;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::RandomFactory();\n Function: Creates a new Bio::PhyloNetwork::RandomFactory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n           -numhybrids => integer [optional]\n           -norepeat => boolean [optional]\n\nReturns a Bio::PhyloNetwork::RandomFactory object. Such an object will create\nrandom binary tree-child phylogenetic networks each time next_network\nis called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\nIf the parameter -numhybrids=E<gt>$numhybrids is given, then the generated\nnetworks will have exactly $numhybrids hybrid nodes. Note that, necessarily,\n$numhybrids E<lt> $numleaves. Otherwise, the number of hybrid nodes will be chosen\nat random for each call of next_network.\n\nIf the parameter -norepeat=E<gt>1 is given, then successive calls of next_network\nwill give non-isomorphic networks.\n\n\nsub new {\n  my ($pkg,@args)=@_;\n\n  my $self=$pkg->SUPER::new(@args);\n\n  my ($leavesR,$numleaves,$numhybrids,$norepeat)=\n    $self->_rearrange([qw(LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  NUMHYBRIDS\n\t\t\t  NOREPEAT)],@args);\n  my @leaves;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  if (! defined $leavesR) {\n    $self->throw(\"No leaves set neither numleaves given\");\n  }\n  $norepeat ||= 0;\n\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{numhybrids}=$numhybrids if defined $numhybrids;\n  $self->{norepeat}=$norepeat;\n  $self->{found}=[];\n  $self->{tree_factory}=Bio::Tree::RandomFactory->new(-taxa => \\@leaves);\n  bless($self,$pkg);\n}\n\n=head2 next_network\n\n Title   : next_network\n Usage   : my $net=$factory->next_network()\n Function: returns a random network\n Returns : Bio::PhyloNetwork\n Args    : none","label":"next_network($self)"},"containerName":"main::","definition":"sub","line":139,"children":[{"kind":13,"line":140,"containerName":"next_network","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":142,"containerName":"next_network","name":"$numleaves","definition":"my","localvar":"my"},{"containerName":"next_network","name":"$self","line":142,"kind":13},{"containerName":"next_network","name":"@found","definition":"my","localvar":"my","kind":13,"line":143},{"name":"$self","containerName":"next_network","kind":13,"line":143}],"kind":12,"range":{"start":{"line":139,"character":0},"end":{"line":143,"character":9999}},"name":"next_network"},{"line":142,"kind":12,"name":"numleaves"},{"line":143,"kind":12,"name":"found"},{"line":144,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$numhybrids"},{"name":"START","line":145,"kind":12},{"containerName":null,"name":"%self","line":146,"kind":13},{"kind":12,"line":146,"name":"numhybrids"},{"line":147,"kind":13,"containerName":null,"name":"$numhybrids"},{"name":"%numleaves","containerName":null,"kind":13,"line":147},{"line":150,"kind":13,"containerName":null,"name":"$numhybrids"},{"containerName":null,"name":"%self","kind":13,"line":150},{"name":"numhybrids","line":150,"kind":12},{"containerName":null,"definition":"my","name":"$tf","localvar":"my","kind":13,"line":152},{"line":152,"kind":13,"name":"%self","containerName":null},{"kind":12,"line":152,"name":"tree_factory"},{"line":153,"kind":13,"localvar":"my","containerName":null,"name":"$tree","definition":"my"},{"kind":13,"line":153,"name":"$tf","containerName":null},{"kind":12,"line":153,"containerName":"main::","name":"next_tree"},{"kind":13,"line":154,"containerName":null,"name":"$net","definition":"my","localvar":"my"},{"kind":12,"line":154,"name":"Bio","containerName":"PhyloNetwork"},{"name":"new","containerName":"main::","line":154,"kind":12},{"name":"$tree","containerName":null,"kind":13,"line":154},{"localvar":"my","name":"$i","definition":"my","containerName":null,"line":155,"kind":13},{"name":"$i","containerName":null,"line":155,"kind":13},{"name":"$numhybrids","containerName":null,"line":155,"kind":13},{"kind":13,"line":155,"name":"%i","containerName":null},{"containerName":null,"name":"$net","kind":13,"line":156},{"name":"random_attack","kind":12,"line":156},{"kind":13,"line":156,"containerName":null,"name":"$net"},{"containerName":null,"name":"$i","line":156,"kind":13},{"containerName":null,"name":"%self","line":158,"kind":13},{"name":"norepeat","line":158,"kind":12},{"line":159,"kind":13,"localvar":"my","name":"$ant","definition":"my","containerName":null},{"kind":13,"line":159,"containerName":null,"name":"@found"},{"name":"START","kind":12,"line":160},{"name":"$net","containerName":null,"kind":13,"line":160},{"name":"is_mu_isomorphic","containerName":"main::","kind":12,"line":160},{"line":160,"kind":13,"containerName":null,"name":"$ant"},{"line":162,"kind":13,"containerName":null,"name":"@found"},{"name":"$net","containerName":null,"line":162,"kind":13},{"kind":13,"line":163,"name":"%self","containerName":null},{"line":163,"kind":12,"name":"found"},{"containerName":null,"name":"@found","kind":13,"line":163},{"kind":13,"line":165,"containerName":null,"name":"$net"},{"range":{"start":{"character":0,"line":168},"end":{"line":183,"character":9999}},"name":"random_attack","signature":{"parameters":[{"label":"$net"},{"label":"$lbl"}],"documentation":"","label":"random_attack($net,$lbl)"},"detail":"($net,$lbl)","definition":"sub","containerName":"main::","children":[{"name":"$net","definition":"my","containerName":"random_attack","localvar":"my","kind":13,"line":169},{"containerName":"random_attack","name":"$lbl","kind":13,"line":169},{"localvar":"my","name":"$graph","definition":"my","containerName":"random_attack","line":171,"kind":13},{"line":171,"kind":13,"name":"$net","containerName":"random_attack"},{"kind":13,"line":172,"containerName":"random_attack","name":"$u1","definition":"my","localvar":"my"},{"containerName":"random_attack","name":"$v1","line":172,"kind":13},{"containerName":"random_attack","name":"$u2","line":172,"kind":13},{"line":172,"kind":13,"name":"$v2","containerName":"random_attack"},{"line":174,"kind":13,"localvar":"my","containerName":"random_attack","definition":"my","name":"$e1"},{"kind":13,"line":174,"containerName":"random_attack","name":"$graph"},{"name":"random_edge","containerName":"random_attack","line":174,"kind":12},{"kind":13,"line":175,"name":"$e2","definition":"my","containerName":"random_attack","localvar":"my"},{"containerName":"random_attack","name":"$graph","line":175,"kind":13},{"containerName":"random_attack","name":"random_edge","line":175,"kind":12},{"kind":13,"line":176,"name":"$u1","containerName":"random_attack"},{"line":176,"kind":13,"name":"$e1","containerName":"random_attack"},{"containerName":"random_attack","name":"$v1","line":177,"kind":13},{"name":"$e1","containerName":"random_attack","line":177,"kind":13},{"kind":13,"line":178,"containerName":"random_attack","name":"$u2"},{"name":"$e2","containerName":"random_attack","kind":13,"line":178},{"kind":13,"line":179,"name":"$v2","containerName":"random_attack"},{"line":179,"kind":13,"containerName":"random_attack","name":"$e2"},{"containerName":"random_attack","name":"$net","kind":13,"line":180},{"line":180,"kind":12,"containerName":"random_attack","name":"is_attackable"},{"line":180,"kind":13,"name":"$u1","containerName":"random_attack"},{"kind":13,"line":180,"containerName":"random_attack","name":"$v1"},{"name":"$u2","containerName":"random_attack","line":180,"kind":13},{"name":"$v2","containerName":"random_attack","line":180,"kind":13},{"line":180,"kind":13,"containerName":"random_attack","name":"$lbl"},{"name":"$net","containerName":"random_attack","line":181,"kind":13},{"name":"do_attack","containerName":"random_attack","line":181,"kind":12},{"containerName":"random_attack","name":"$u1","line":181,"kind":13},{"kind":13,"line":181,"containerName":"random_attack","name":"$v1"},{"containerName":"random_attack","name":"$u2","line":181,"kind":13},{"kind":13,"line":181,"name":"$v2","containerName":"random_attack"},{"name":"$lbl","containerName":"random_attack","kind":13,"line":181},{"containerName":"random_attack","name":"$net","line":182,"kind":13}],"line":168,"kind":12},{"name":"graph","line":171,"kind":12}],"version":5}