{"vars":[{"kind":2,"line":62,"name":"base","containerName":""},{"range":{"end":{"line":123,"character":9999},"start":{"line":85,"character":0}},"name":"new","line":85,"children":[{"kind":13,"line":86,"name":"$pkg","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"@args","line":86,"kind":13},{"localvar":"my","containerName":"new","definition":"my","name":"$self","line":88,"kind":13},{"kind":13,"line":88,"name":"$pkg","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":88},{"line":90,"kind":13,"localvar":"my","containerName":"new","name":"$net","definition":"my"},{"kind":13,"line":90,"containerName":"new","name":"$short_labels"},{"line":91,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"_rearrange","kind":12,"line":91},{"kind":13,"line":92,"containerName":"new","name":"@args"},{"line":93,"kind":13,"name":"$short_labels","containerName":"new"},{"kind":13,"line":94,"containerName":"new","name":"$short_labels"},{"line":96,"kind":13,"localvar":"my","definition":"my","name":"$gv","containerName":"new"},{"name":"new","containerName":"new","kind":12,"line":96},{"kind":13,"line":97,"definition":"my","name":"$nodePN_to_nodeGV","containerName":"new","localvar":"my"},{"localvar":"my","containerName":"new","definition":"my","name":"@nodes","line":98,"kind":13},{"name":"$net","containerName":"new","kind":13,"line":98},{"containerName":"new","name":"nodes","kind":12,"line":98},{"localvar":"my","name":"$node","definition":"my","containerName":"new","line":99,"kind":13},{"line":99,"kind":13,"name":"@nodes","containerName":"new"},{"kind":13,"line":103,"containerName":"new","name":"$labelnodeint","definition":"my","localvar":"my"},{"line":103,"kind":13,"containerName":"new","name":"$net"},{"name":"$node","containerName":"new","kind":13,"line":103},{"definition":"my","name":"$labelnode","containerName":"new","localvar":"my","kind":13,"line":105},{"containerName":"new","name":"$short_labels","line":105,"kind":13},{"kind":13,"line":105,"name":"$labelnodeint","containerName":"new"},{"name":"$labelnodeint","containerName":"new","line":105,"kind":13},{"kind":13,"line":106,"name":"$nodeGV","definition":"my","containerName":"new","localvar":"my"},{"line":107,"kind":13,"containerName":"new","name":"$gv"},{"kind":12,"line":107,"containerName":"new","name":"add_node"},{"name":"$labelnode","containerName":"new","line":108,"kind":13},{"name":"$net","containerName":"new","line":109,"kind":13},{"name":"is_tree_node","containerName":"new","kind":12,"line":109},{"containerName":"new","name":"$node","line":109,"kind":13},{"containerName":"new","name":"$nodePN_to_nodeGV","line":110,"kind":13},{"containerName":"new","name":"$node","line":110,"kind":13},{"containerName":"new","name":"$nodeGV","line":110,"kind":13},{"line":112,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"@edges"},{"containerName":"new","name":"$net","line":112,"kind":13},{"kind":12,"line":112,"name":"edges","containerName":"new"},{"containerName":"new","definition":"my","name":"$edge","localvar":"my","kind":13,"line":113},{"line":113,"kind":13,"containerName":"new","name":"@edges"},{"name":"$node1","definition":"my","containerName":"new","localvar":"my","kind":13,"line":114},{"line":114,"kind":13,"name":"$edge","containerName":"new"},{"line":116,"kind":13,"localvar":"my","definition":"my","name":"$node2","containerName":"new"},{"containerName":"new","name":"$edge","kind":13,"line":116},{"line":118,"kind":13,"name":"$gv","containerName":"new"},{"kind":12,"line":118,"containerName":"new","name":"add_edge"},{"kind":13,"line":118,"containerName":"new","name":"$nodePN_to_nodeGV"},{"line":118,"kind":13,"containerName":"new","name":"$node1"},{"name":"$nodePN_to_nodeGV","containerName":"new","line":118,"kind":13},{"line":118,"kind":13,"containerName":"new","name":"$node2"},{"line":120,"kind":13,"name":"$self","containerName":"new"},{"kind":13,"line":120,"containerName":"new","name":"$gv"},{"name":"$self","containerName":"new","kind":13,"line":121},{"containerName":"new","name":"$nodePN_to_nodeGV","kind":13,"line":121},{"line":122,"kind":13,"name":"$self","containerName":"new"},{"kind":13,"line":122,"containerName":"new","name":"$pkg"}],"kind":12,"detail":"($pkg,@args)","signature":{"label":"new($pkg,@args)","documentation":"1;\n# $Id: GraphViz.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::GraphViz\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::GraphViz - Interface between PhyloNetwork and GraphViz\n\n=head1 SYNOPSIS\n\n  use Bio::PhyloNetwork;\n  use Bio::PhyloNetwork::GraphViz;\n\n  my $net=Bio::PhyloNetwork->new(\n      -eNewick=>'((H1,(H1,(H2,l))),H2)t0; (some long label)H1; (\"quoted label\")H2;'\n  );\n\n  my $gv=Bio::PhyloNetwork::GraphViz->new(-net=>$net,-short_labels=>1);\n\n  foreach my $u ($net->nodes()) {\n      print \"$u:\".$gv->nodePN_to_nodeGV->{$u}.\"\\n\";\n  }\n\n  print $gv->as_text;\n\n  open PS, \"> net.ps\";\n  print PS $gv->as_ps;\n  close PS;\n\n=head1 DESCRIPTION\n\nThis is a module to create GraphViz objects representing phylogenetic networks.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>, L<GraphViz>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::GraphViz;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root GraphViz);\n\nuse Bio::PhyloNetwork;\n\n=head2 new\n\n Title   : new\n Usage   : my $graphv = new Bio::PhyloNetwork::GraphViz();\n Function: Creates a new Bio::PhyloNetwork::GraphViz object\n Returns : Bio::PhyloNetwork::GraphViz\n Args    : -net => Bio::PhyloNetwork object\n           -short_labels => boolean (optional)\n\nReturns a Bio::PhyloNetwork::GraphViz object, which is an extension of\na GraphViz object. The GraphViz object is a representation of the\nphylogenetic network given. The extra information the created object\nholds is a hash table with keys the nodes of the PhyloNetwork object\nand values the nodes of the GraphViz object. If the optional argument\n-short_labels=E<gt>1 is given, the labels of the nodes in GraphViz are\nshortened to a maximum of 3 letters.","parameters":[{"label":"$pkg"},{"label":"@args"}]},"containerName":"main::","definition":"sub"},{"line":86,"kind":2,"containerName":"Bio","name":"PhyloNetwork"},{"kind":12,"line":88,"name":"SUPER","containerName":"new"},{"kind":12,"line":96,"name":"GraphViz"},{"name":"labels","line":103,"kind":12},{"kind":12,"line":105,"name":"find_short_label"},{"name":"find_label","line":105,"kind":12},{"line":108,"kind":12,"name":"label"},{"line":109,"kind":12,"name":"shape"},{"line":121,"kind":12,"name":"nodePN_to_nodeGV"},{"detail":"($str)","signature":{"label":"find_short_label($str)","documentation":"sub generate_name {\n  my ($var)=@_;\n  if ($var =~ /\\D/) {\n    print \"$var contains a number.\\b\";\n    return $var;\n  }\n  return \"N$var\";\n}","parameters":[{"label":"$str"}]},"containerName":"main::","definition":"sub","line":134,"children":[{"kind":13,"line":135,"definition":"my","name":"$str","containerName":"find_short_label","localvar":"my"},{"containerName":"find_short_label","name":"$str","kind":13,"line":136}],"kind":12,"range":{"end":{"line":137,"character":9999},"start":{"line":134,"character":0}},"name":"find_short_label"},{"kind":12,"line":136,"name":"find_label"},{"kind":12,"line":139,"children":[{"localvar":"my","containerName":"find_label","name":"$str","definition":"my","line":140,"kind":13},{"containerName":"find_label","name":"$str","kind":13,"line":141},{"kind":13,"line":142,"name":"$str","containerName":"find_label"}],"containerName":"main::","definition":"sub","detail":"($str)","signature":{"documentation":"","parameters":[{"label":"$str"}],"label":"find_label($str)"},"name":"find_label","range":{"end":{"line":143,"character":9999},"start":{"character":0,"line":139}}},{"range":{"start":{"line":157,"character":0},"end":{"line":160,"character":9999}},"name":"nodePN_to_nodeGV","detail":"($self)","signature":{"label":"nodePN_to_nodeGV($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GraphViz.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::GraphViz\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::GraphViz - Interface between PhyloNetwork and GraphViz\n\n=head1 SYNOPSIS\n\n  use Bio::PhyloNetwork;\n  use Bio::PhyloNetwork::GraphViz;\n\n  my $net=Bio::PhyloNetwork->new(\n      -eNewick=>'((H1,(H1,(H2,l))),H2)t0; (some long label)H1; (\"quoted label\")H2;'\n  );\n\n  my $gv=Bio::PhyloNetwork::GraphViz->new(-net=>$net,-short_labels=>1);\n\n  foreach my $u ($net->nodes()) {\n      print \"$u:\".$gv->nodePN_to_nodeGV->{$u}.\"\\n\";\n  }\n\n  print $gv->as_text;\n\n  open PS, \"> net.ps\";\n  print PS $gv->as_ps;\n  close PS;\n\n=head1 DESCRIPTION\n\nThis is a module to create GraphViz objects representing phylogenetic networks.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>, L<GraphViz>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::GraphViz;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root GraphViz);\n\nuse Bio::PhyloNetwork;\n\n=head2 new\n\n Title   : new\n Usage   : my $graphv = new Bio::PhyloNetwork::GraphViz();\n Function: Creates a new Bio::PhyloNetwork::GraphViz object\n Returns : Bio::PhyloNetwork::GraphViz\n Args    : -net => Bio::PhyloNetwork object\n           -short_labels => boolean (optional)\n\nReturns a Bio::PhyloNetwork::GraphViz object, which is an extension of\na GraphViz object. The GraphViz object is a representation of the\nphylogenetic network given. The extra information the created object\nholds is a hash table with keys the nodes of the PhyloNetwork object\nand values the nodes of the GraphViz object. If the optional argument\n-short_labels=E<gt>1 is given, the labels of the nodes in GraphViz are\nshortened to a maximum of 3 letters.\n\n\nsub new {\n  my ($pkg,@args)=@_;\n\n  my $self=$pkg->SUPER::new(@args);\n\n  my ($net,$short_labels)=\n    $self->_rearrange([qw(NET\n\t\t\t  SHORT_LABELS)],@args);\n  if (! defined $short_labels) {\n    $short_labels=0;\n  }\n  my $gv=GraphViz->new();\n  my $nodePN_to_nodeGV={};\n  my @nodes=$net->nodes();\n  foreach my $node (@nodes) {\n#    my $namenode=generate_name($node);\n#    $names->{$node}=$namenode;\n    ###\n    my $labelnodeint=$net->{labels}->{$node};\n    ###\n    my $labelnode=($short_labels ? find_short_label($labelnodeint) : find_label($labelnodeint));\n    my $nodeGV=\n      $gv->add_node(#$namenode,\n\t\t    label=>$labelnode,\n\t\t    shape=>($net->is_tree_node($node) ? 'circle' : 'box'));\n    $nodePN_to_nodeGV->{$node}=$nodeGV;\n  }\n  my @edges=$net->edges();\n  foreach my $edge (@edges) {\n    my $node1=$edge->[0];\n#    my $namenode1=generate_name($node1);\n    my $node2=$edge->[1];\n#    my $namenode2=generate_name($node2);\n    $gv->add_edge($nodePN_to_nodeGV->{$node1},$nodePN_to_nodeGV->{$node2});\n  }\n  $self=$gv;\n  $self->{nodePN_to_nodeGV}=$nodePN_to_nodeGV;\n  bless($self,$pkg);\n}\n\n#sub generate_name {\n#  my ($var)=@_;\n#  if ($var =~ /\\D/) {\n#    print \"$var contains a number.\\b\";\n#    return $var;\n#  }\n#  return \"N$var\";\n#}\n\nsub find_short_label {\n  my ($str)=@_;\n  return substr(find_label($str),0,3);\n}\n\nsub find_label {\n  my ($str)=@_;\n  $str =~ tr/A-Za-z0-9//cd;\n  return $str;\n}\n\n=head2 nodePN_to_nodeGV\n\n Title   : nodePN_to_nodeGV\n Usage   : my $hashR=$graphv->nodePN_to_nodeGV()\n Function: returns (a reference to) a hash holding the translation between\n           nodes of the Bio::PhyloNetwork object and nodes of the GraphViz\n           object\n Returns : reference to hash\n Args    : none"},"containerName":"main::","definition":"sub","line":157,"children":[{"definition":"my","name":"$self","containerName":"nodePN_to_nodeGV","localvar":"my","kind":13,"line":158},{"containerName":"nodePN_to_nodeGV","name":"$self","line":159,"kind":13}],"kind":12},{"kind":12,"line":159,"name":"nodePN_to_nodeGV"}],"version":5}