{"vars":[{"kind":2,"line":112,"containerName":"","name":"base"},{"children":[{"kind":13,"line":135,"containerName":"new","name":"$class","definition":"my","localvar":"my"},{"kind":13,"line":135,"containerName":"new","name":"@args"},{"name":"$self","definition":"my","containerName":"new","localvar":"my","kind":13,"line":137},{"name":"$class","containerName":"new","kind":13,"line":137},{"containerName":"new","name":"@args","kind":13,"line":137},{"line":139,"kind":13,"localvar":"my","containerName":"new","name":"$name","definition":"my"},{"kind":13,"line":139,"containerName":"new","name":"$desc"},{"kind":13,"line":139,"name":"$species","containerName":"new"},{"kind":13,"line":139,"name":"$type","containerName":"new"},{"containerName":"new","name":"$comment","line":139,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":140},{"kind":12,"line":140,"name":"_rearrange","containerName":"new"},{"kind":13,"line":144,"containerName":"new","name":"@args"},{"kind":13,"line":146,"name":"$self","containerName":"new"},{"containerName":"new","name":"init","kind":12,"line":146},{"containerName":"new","name":"$name","line":148,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":148},{"kind":12,"line":148,"containerName":"new","name":"name"},{"name":"$name","containerName":"new","line":148,"kind":13},{"kind":13,"line":149,"containerName":"new","name":"$desc"},{"line":149,"kind":13,"containerName":"new","name":"$self"},{"line":149,"kind":12,"name":"description","containerName":"new"},{"kind":13,"line":149,"containerName":"new","name":"$desc"},{"name":"$species","containerName":"new","kind":13,"line":150},{"kind":13,"line":150,"name":"$self","containerName":"new"},{"kind":12,"line":150,"name":"species","containerName":"new"},{"line":150,"kind":13,"name":"$species","containerName":"new"},{"kind":13,"line":151,"containerName":"new","name":"$type"},{"name":"$self","containerName":"new","line":151,"kind":13},{"containerName":"new","name":"type","line":151,"kind":12},{"line":151,"kind":13,"containerName":"new","name":"$type"},{"kind":13,"line":152,"containerName":"new","name":"$comment"},{"kind":13,"line":152,"containerName":"new","name":"$self"},{"kind":12,"line":152,"name":"comment","containerName":"new"},{"line":152,"kind":13,"containerName":"new","name":"$comment"},{"line":154,"kind":13,"name":"$self","containerName":"new"}],"line":133,"kind":12,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Correlate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Correlate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Correlate - Representation of a correlating phenotype in a given species\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Correlate;\n\n  $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                        -description => \"mouse correlate of human phenotype MIM 605865\",\n                                        -species     => $mouse,\n                                        -type        => \"homolog\",\n                                        -comment     => \"type=homolog is putative\" );\n\n  print $co->name();\n  print $co->description();\n  print $co->species()->binomial();\n  print $co->type();\n  print $co->comment();\n\n  print $co->to_string();\n\n=head1 DESCRIPTION\n\nThis class models correlating phenotypes.\nIts creation was inspired by the OMIM database where many human phenotypes\nhave a correlating mouse phenotype. Therefore, this class is intended\nto be used together with a phenotype class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Correlate;\nuse strict;\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                                 -description => \"mouse correlate of human phenotype MIM 605865\",\n                                                 -species     => $mouse,\n                                                 -type        => \"homolog\",\n                                                 -comment     => \"type=homolog is putative\" );                      \n Function: Creates a new Correlate object.\n Returns : A new Correlate object.\n Args    : -name        => a name or id\n           -description => a description\n           -species     => the species of this correlating phenotype [Bio::Species]\n           -type        => the type of correlation\n           -comment     => a comment","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":156},"start":{"line":133,"character":0}},"name":"new"},{"containerName":"new","name":"SUPER","kind":12,"line":137},{"name":"init","range":{"start":{"line":171,"character":0},"end":{"character":9999,"line":183}},"kind":12,"line":171,"children":[{"line":173,"kind":13,"localvar":"my","containerName":"init","name":"$self","definition":"my"},{"line":175,"kind":13,"name":"$self","containerName":"init"},{"name":"name","containerName":"init","kind":12,"line":175},{"kind":13,"line":176,"name":"$self","containerName":"init"},{"kind":12,"line":176,"name":"description","containerName":"init"},{"localvar":"my","containerName":"init","definition":"my","name":"$species","line":177,"kind":13},{"containerName":"init","name":"new","kind":12,"line":177},{"kind":13,"line":178,"containerName":"init","name":"$species"},{"containerName":"init","name":"classification","line":178,"kind":12},{"name":"$self","containerName":"init","line":179,"kind":13},{"line":179,"kind":12,"name":"species","containerName":"init"},{"containerName":"init","name":"$species","line":179,"kind":13},{"name":"$self","containerName":"init","kind":13,"line":180},{"line":180,"kind":12,"containerName":"init","name":"type"},{"line":181,"kind":13,"name":"$self","containerName":"init"},{"name":"comment","containerName":"init","line":181,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Correlate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Correlate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Correlate - Representation of a correlating phenotype in a given species\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Correlate;\n\n  $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                        -description => \"mouse correlate of human phenotype MIM 605865\",\n                                        -species     => $mouse,\n                                        -type        => \"homolog\",\n                                        -comment     => \"type=homolog is putative\" );\n\n  print $co->name();\n  print $co->description();\n  print $co->species()->binomial();\n  print $co->type();\n  print $co->comment();\n\n  print $co->to_string();\n\n=head1 DESCRIPTION\n\nThis class models correlating phenotypes.\nIts creation was inspired by the OMIM database where many human phenotypes\nhave a correlating mouse phenotype. Therefore, this class is intended\nto be used together with a phenotype class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Correlate;\nuse strict;\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                                 -description => \"mouse correlate of human phenotype MIM 605865\",\n                                                 -species     => $mouse,\n                                                 -type        => \"homolog\",\n                                                 -comment     => \"type=homolog is putative\" );                      \n Function: Creates a new Correlate object.\n Returns : A new Correlate object.\n Args    : -name        => a name or id\n           -description => a description\n           -species     => the species of this correlating phenotype [Bio::Species]\n           -type        => the type of correlation\n           -comment     => a comment\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n \n    my ( $name, $desc, $species, $type, $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES\n                               TYPE\n                               COMMENT ) ], @args );\n                         \n    $self->init();                     \n   \n    $name    && $self->name( $name );\n    $desc    && $self->description( $desc );\n    $species && $self->species( $species );\n    $type    && $self->type( $type );\n    $comment && $self->comment( $comment );\n   \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $co->init();   \n Function: Initializes this Correlate to all \"\".\n Returns : \n Args    :","label":"init($self)"}},{"containerName":"Species","name":"Bio","line":177,"kind":12},{"name":"name","range":{"end":{"character":9999,"line":209},"start":{"character":0,"line":200}},"kind":12,"line":200,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"name","line":201,"kind":13},{"containerName":"name","name":"$value","line":201,"kind":13},{"containerName":"name","name":"$value","kind":13,"line":203},{"kind":13,"line":204,"name":"$self","containerName":"name"},{"kind":13,"line":204,"name":"$value","containerName":"name"},{"kind":13,"line":207,"name":"$self","containerName":"name"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Correlate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Correlate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Correlate - Representation of a correlating phenotype in a given species\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Correlate;\n\n  $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                        -description => \"mouse correlate of human phenotype MIM 605865\",\n                                        -species     => $mouse,\n                                        -type        => \"homolog\",\n                                        -comment     => \"type=homolog is putative\" );\n\n  print $co->name();\n  print $co->description();\n  print $co->species()->binomial();\n  print $co->type();\n  print $co->comment();\n\n  print $co->to_string();\n\n=head1 DESCRIPTION\n\nThis class models correlating phenotypes.\nIts creation was inspired by the OMIM database where many human phenotypes\nhave a correlating mouse phenotype. Therefore, this class is intended\nto be used together with a phenotype class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Correlate;\nuse strict;\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                                 -description => \"mouse correlate of human phenotype MIM 605865\",\n                                                 -species     => $mouse,\n                                                 -type        => \"homolog\",\n                                                 -comment     => \"type=homolog is putative\" );                      \n Function: Creates a new Correlate object.\n Returns : A new Correlate object.\n Args    : -name        => a name or id\n           -description => a description\n           -species     => the species of this correlating phenotype [Bio::Species]\n           -type        => the type of correlation\n           -comment     => a comment\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n \n    my ( $name, $desc, $species, $type, $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES\n                               TYPE\n                               COMMENT ) ], @args );\n                         \n    $self->init();                     \n   \n    $name    && $self->name( $name );\n    $desc    && $self->description( $desc );\n    $species && $self->species( $species );\n    $type    && $self->type( $type );\n    $comment && $self->comment( $comment );\n   \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $co->init();   \n Function: Initializes this Correlate to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( species Undetermined ) );\n    $self->species( $species );\n    $self->type( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $co->name( \"4(Tas1r3)\" );\n           or\n           print $co->name();\n Function: Set/get for the name or id of this Correlate.\n Returns : The name or id of this Correlate.\n Args    : The name or id of this Correlate (optional).","label":"name($self,$value)"}},{"range":{"start":{"character":0,"line":226},"end":{"character":9999,"line":235}},"name":"description","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Correlate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Correlate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Correlate - Representation of a correlating phenotype in a given species\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Correlate;\n\n  $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                        -description => \"mouse correlate of human phenotype MIM 605865\",\n                                        -species     => $mouse,\n                                        -type        => \"homolog\",\n                                        -comment     => \"type=homolog is putative\" );\n\n  print $co->name();\n  print $co->description();\n  print $co->species()->binomial();\n  print $co->type();\n  print $co->comment();\n\n  print $co->to_string();\n\n=head1 DESCRIPTION\n\nThis class models correlating phenotypes.\nIts creation was inspired by the OMIM database where many human phenotypes\nhave a correlating mouse phenotype. Therefore, this class is intended\nto be used together with a phenotype class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Correlate;\nuse strict;\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                                 -description => \"mouse correlate of human phenotype MIM 605865\",\n                                                 -species     => $mouse,\n                                                 -type        => \"homolog\",\n                                                 -comment     => \"type=homolog is putative\" );                      \n Function: Creates a new Correlate object.\n Returns : A new Correlate object.\n Args    : -name        => a name or id\n           -description => a description\n           -species     => the species of this correlating phenotype [Bio::Species]\n           -type        => the type of correlation\n           -comment     => a comment\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n \n    my ( $name, $desc, $species, $type, $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES\n                               TYPE\n                               COMMENT ) ], @args );\n                         \n    $self->init();                     \n   \n    $name    && $self->name( $name );\n    $desc    && $self->description( $desc );\n    $species && $self->species( $species );\n    $type    && $self->type( $type );\n    $comment && $self->comment( $comment );\n   \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $co->init();   \n Function: Initializes this Correlate to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( species Undetermined ) );\n    $self->species( $species );\n    $self->type( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $co->name( \"4(Tas1r3)\" );\n           or\n           print $co->name();\n Function: Set/get for the name or id of this Correlate.\n Returns : The name or id of this Correlate.\n Args    : The name or id of this Correlate (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $co->description( \"mouse correlate of human phenotype MIM 03923\" );\n           or\n           print $co->description();\n Function: Set/get for the description of this Correlate.\n Returns : A description of this Correlate.\n Args    : A description of this Correlate (optional).","label":"description($self,$value)"},"containerName":"main::","definition":"sub","line":226,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"description","line":227,"kind":13},{"name":"$value","containerName":"description","line":227,"kind":13},{"containerName":"description","name":"$value","kind":13,"line":229},{"line":230,"kind":13,"name":"$self","containerName":"description"},{"kind":13,"line":230,"containerName":"description","name":"$value"},{"line":233,"kind":13,"name":"$self","containerName":"description"}],"kind":12},{"line":252,"children":[{"localvar":"my","containerName":"species","definition":"my","name":"$self","line":254,"kind":13},{"kind":13,"line":254,"name":"$value","containerName":"species"},{"kind":13,"line":256,"containerName":"species","name":"$value"},{"containerName":"species","name":"$self","kind":13,"line":257},{"containerName":"species","name":"_check_ref_type","kind":12,"line":257},{"containerName":"species","name":"$value","kind":13,"line":257},{"kind":13,"line":258,"containerName":"species","name":"$self"},{"kind":13,"line":258,"containerName":"species","name":"$value"},{"line":261,"kind":13,"name":"$self","containerName":"species"}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Correlate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Correlate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Correlate - Representation of a correlating phenotype in a given species\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Correlate;\n\n  $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                        -description => \"mouse correlate of human phenotype MIM 605865\",\n                                        -species     => $mouse,\n                                        -type        => \"homolog\",\n                                        -comment     => \"type=homolog is putative\" );\n\n  print $co->name();\n  print $co->description();\n  print $co->species()->binomial();\n  print $co->type();\n  print $co->comment();\n\n  print $co->to_string();\n\n=head1 DESCRIPTION\n\nThis class models correlating phenotypes.\nIts creation was inspired by the OMIM database where many human phenotypes\nhave a correlating mouse phenotype. Therefore, this class is intended\nto be used together with a phenotype class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Correlate;\nuse strict;\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                                 -description => \"mouse correlate of human phenotype MIM 605865\",\n                                                 -species     => $mouse,\n                                                 -type        => \"homolog\",\n                                                 -comment     => \"type=homolog is putative\" );                      \n Function: Creates a new Correlate object.\n Returns : A new Correlate object.\n Args    : -name        => a name or id\n           -description => a description\n           -species     => the species of this correlating phenotype [Bio::Species]\n           -type        => the type of correlation\n           -comment     => a comment\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n \n    my ( $name, $desc, $species, $type, $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES\n                               TYPE\n                               COMMENT ) ], @args );\n                         \n    $self->init();                     \n   \n    $name    && $self->name( $name );\n    $desc    && $self->description( $desc );\n    $species && $self->species( $species );\n    $type    && $self->type( $type );\n    $comment && $self->comment( $comment );\n   \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $co->init();   \n Function: Initializes this Correlate to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( species Undetermined ) );\n    $self->species( $species );\n    $self->type( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $co->name( \"4(Tas1r3)\" );\n           or\n           print $co->name();\n Function: Set/get for the name or id of this Correlate.\n Returns : The name or id of this Correlate.\n Args    : The name or id of this Correlate (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $co->description( \"mouse correlate of human phenotype MIM 03923\" );\n           or\n           print $co->description();\n Function: Set/get for the description of this Correlate.\n Returns : A description of this Correlate.\n Args    : A description of this Correlate (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $co->species( $species );\n           or\n           $species = $co->species();\n Function: Set/get for the species of this Correlate.\n Returns : The Bio::Species of this Correlate [Bio::Species].\n Args    : The Bio::Species of this Correlate [Bio::Species] (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"species($self,$value)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":252},"end":{"line":263,"character":9999}},"name":"species"},{"signature":{"label":"type($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Correlate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Correlate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Correlate - Representation of a correlating phenotype in a given species\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Correlate;\n\n  $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                        -description => \"mouse correlate of human phenotype MIM 605865\",\n                                        -species     => $mouse,\n                                        -type        => \"homolog\",\n                                        -comment     => \"type=homolog is putative\" );\n\n  print $co->name();\n  print $co->description();\n  print $co->species()->binomial();\n  print $co->type();\n  print $co->comment();\n\n  print $co->to_string();\n\n=head1 DESCRIPTION\n\nThis class models correlating phenotypes.\nIts creation was inspired by the OMIM database where many human phenotypes\nhave a correlating mouse phenotype. Therefore, this class is intended\nto be used together with a phenotype class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Correlate;\nuse strict;\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                                 -description => \"mouse correlate of human phenotype MIM 605865\",\n                                                 -species     => $mouse,\n                                                 -type        => \"homolog\",\n                                                 -comment     => \"type=homolog is putative\" );                      \n Function: Creates a new Correlate object.\n Returns : A new Correlate object.\n Args    : -name        => a name or id\n           -description => a description\n           -species     => the species of this correlating phenotype [Bio::Species]\n           -type        => the type of correlation\n           -comment     => a comment\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n \n    my ( $name, $desc, $species, $type, $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES\n                               TYPE\n                               COMMENT ) ], @args );\n                         \n    $self->init();                     \n   \n    $name    && $self->name( $name );\n    $desc    && $self->description( $desc );\n    $species && $self->species( $species );\n    $type    && $self->type( $type );\n    $comment && $self->comment( $comment );\n   \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $co->init();   \n Function: Initializes this Correlate to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( species Undetermined ) );\n    $self->species( $species );\n    $self->type( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $co->name( \"4(Tas1r3)\" );\n           or\n           print $co->name();\n Function: Set/get for the name or id of this Correlate.\n Returns : The name or id of this Correlate.\n Args    : The name or id of this Correlate (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $co->description( \"mouse correlate of human phenotype MIM 03923\" );\n           or\n           print $co->description();\n Function: Set/get for the description of this Correlate.\n Returns : A description of this Correlate.\n Args    : A description of this Correlate (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $co->species( $species );\n           or\n           $species = $co->species();\n Function: Set/get for the species of this Correlate.\n Returns : The Bio::Species of this Correlate [Bio::Species].\n Args    : The Bio::Species of this Correlate [Bio::Species] (optional).\n\n\nsub species {\n\n    my ( $self, $value )  = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n    \n    return $self->{ \"_species\" };\n    \n} # species\n\n\n\n\n=head2 type\n\n Title   : type\n Usage   : $co->type( \"homolog\" );\n           or\n           print $co->type();\n Function: Set/get for the type of this Correlate.\n Returns : The type of this Correlate.\n Args    : The type of this Correlate (optional)."},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":281,"definition":"my","name":"$self","containerName":"type","localvar":"my"},{"containerName":"type","name":"$value","line":281,"kind":13},{"containerName":"type","name":"$value","kind":13,"line":283},{"containerName":"type","name":"$self","line":284,"kind":13},{"line":284,"kind":13,"containerName":"type","name":"$value"},{"containerName":"type","name":"$self","kind":13,"line":287}],"line":280,"kind":12,"range":{"start":{"line":280,"character":0},"end":{"line":289,"character":9999}},"name":"type"},{"signature":{"documentation":"1;\n# $Id: Correlate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Correlate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Correlate - Representation of a correlating phenotype in a given species\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Correlate;\n\n  $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                        -description => \"mouse correlate of human phenotype MIM 605865\",\n                                        -species     => $mouse,\n                                        -type        => \"homolog\",\n                                        -comment     => \"type=homolog is putative\" );\n\n  print $co->name();\n  print $co->description();\n  print $co->species()->binomial();\n  print $co->type();\n  print $co->comment();\n\n  print $co->to_string();\n\n=head1 DESCRIPTION\n\nThis class models correlating phenotypes.\nIts creation was inspired by the OMIM database where many human phenotypes\nhave a correlating mouse phenotype. Therefore, this class is intended\nto be used together with a phenotype class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Correlate;\nuse strict;\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                                 -description => \"mouse correlate of human phenotype MIM 605865\",\n                                                 -species     => $mouse,\n                                                 -type        => \"homolog\",\n                                                 -comment     => \"type=homolog is putative\" );                      \n Function: Creates a new Correlate object.\n Returns : A new Correlate object.\n Args    : -name        => a name or id\n           -description => a description\n           -species     => the species of this correlating phenotype [Bio::Species]\n           -type        => the type of correlation\n           -comment     => a comment\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n \n    my ( $name, $desc, $species, $type, $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES\n                               TYPE\n                               COMMENT ) ], @args );\n                         \n    $self->init();                     \n   \n    $name    && $self->name( $name );\n    $desc    && $self->description( $desc );\n    $species && $self->species( $species );\n    $type    && $self->type( $type );\n    $comment && $self->comment( $comment );\n   \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $co->init();   \n Function: Initializes this Correlate to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( species Undetermined ) );\n    $self->species( $species );\n    $self->type( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $co->name( \"4(Tas1r3)\" );\n           or\n           print $co->name();\n Function: Set/get for the name or id of this Correlate.\n Returns : The name or id of this Correlate.\n Args    : The name or id of this Correlate (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $co->description( \"mouse correlate of human phenotype MIM 03923\" );\n           or\n           print $co->description();\n Function: Set/get for the description of this Correlate.\n Returns : A description of this Correlate.\n Args    : A description of this Correlate (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $co->species( $species );\n           or\n           $species = $co->species();\n Function: Set/get for the species of this Correlate.\n Returns : The Bio::Species of this Correlate [Bio::Species].\n Args    : The Bio::Species of this Correlate [Bio::Species] (optional).\n\n\nsub species {\n\n    my ( $self, $value )  = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n    \n    return $self->{ \"_species\" };\n    \n} # species\n\n\n\n\n=head2 type\n\n Title   : type\n Usage   : $co->type( \"homolog\" );\n           or\n           print $co->type();\n Function: Set/get for the type of this Correlate.\n Returns : The type of this Correlate.\n Args    : The type of this Correlate (optional).\n\n\nsub type {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_type\" } = $value;\n    }\n\n    return $self->{ \"_type\" };\n\n} # type\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $co->comment( \"doubtful\" );\n           or \n           print $co->comment();\n Function: Set/get for an arbitrary comment about this Correlate.\n Returns : A comment.\n Args    : A comment (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"comment($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":307,"definition":"my","name":"$self","containerName":"comment","localvar":"my"},{"kind":13,"line":307,"name":"$value","containerName":"comment"},{"name":"$value","containerName":"comment","kind":13,"line":309},{"kind":13,"line":310,"containerName":"comment","name":"$self"},{"line":310,"kind":13,"name":"$value","containerName":"comment"},{"kind":13,"line":313,"name":"$self","containerName":"comment"}],"line":306,"kind":12,"range":{"start":{"character":0,"line":306},"end":{"line":315,"character":9999}},"name":"comment"},{"children":[{"kind":13,"line":331,"name":"$self","definition":"my","containerName":"to_string","localvar":"my"},{"kind":13,"line":333,"definition":"my","name":"$s","containerName":"to_string","localvar":"my"},{"containerName":"to_string","name":"$s","line":335,"kind":13},{"kind":13,"line":336,"name":"$s","containerName":"to_string"},{"name":"$self","containerName":"to_string","kind":13,"line":336},{"name":"name","containerName":"to_string","line":336,"kind":12},{"name":"$s","containerName":"to_string","kind":13,"line":337},{"containerName":"to_string","name":"$s","kind":13,"line":338},{"kind":13,"line":338,"containerName":"to_string","name":"$self"},{"containerName":"to_string","name":"description","line":338,"kind":12},{"line":339,"kind":13,"containerName":"to_string","name":"$s"},{"line":340,"kind":13,"name":"$s","containerName":"to_string"},{"containerName":"to_string","name":"$self","kind":13,"line":340},{"name":"species","containerName":"to_string","kind":12,"line":340},{"kind":12,"line":340,"name":"binomial","containerName":"to_string"},{"kind":13,"line":341,"name":"$s","containerName":"to_string"},{"containerName":"to_string","name":"$s","kind":13,"line":342},{"containerName":"to_string","name":"$self","line":342,"kind":13},{"containerName":"to_string","name":"type","kind":12,"line":342},{"name":"$s","containerName":"to_string","line":343,"kind":13},{"containerName":"to_string","name":"$s","line":344,"kind":13},{"line":344,"kind":13,"containerName":"to_string","name":"$self"},{"kind":12,"line":344,"name":"comment","containerName":"to_string"},{"line":346,"kind":13,"name":"$s","containerName":"to_string"}],"line":329,"kind":12,"signature":{"label":"to_string($self)","documentation":"1;\n# $Id: Correlate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Correlate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Correlate - Representation of a correlating phenotype in a given species\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Correlate;\n\n  $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                        -description => \"mouse correlate of human phenotype MIM 605865\",\n                                        -species     => $mouse,\n                                        -type        => \"homolog\",\n                                        -comment     => \"type=homolog is putative\" );\n\n  print $co->name();\n  print $co->description();\n  print $co->species()->binomial();\n  print $co->type();\n  print $co->comment();\n\n  print $co->to_string();\n\n=head1 DESCRIPTION\n\nThis class models correlating phenotypes.\nIts creation was inspired by the OMIM database where many human phenotypes\nhave a correlating mouse phenotype. Therefore, this class is intended\nto be used together with a phenotype class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Correlate;\nuse strict;\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : $co = Bio::Phenotype::Correlate->new( -name        => \"4(Tas1r3)\",\n                                                 -description => \"mouse correlate of human phenotype MIM 605865\",\n                                                 -species     => $mouse,\n                                                 -type        => \"homolog\",\n                                                 -comment     => \"type=homolog is putative\" );                      \n Function: Creates a new Correlate object.\n Returns : A new Correlate object.\n Args    : -name        => a name or id\n           -description => a description\n           -species     => the species of this correlating phenotype [Bio::Species]\n           -type        => the type of correlation\n           -comment     => a comment\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n \n    my ( $name, $desc, $species, $type, $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES\n                               TYPE\n                               COMMENT ) ], @args );\n                         \n    $self->init();                     \n   \n    $name    && $self->name( $name );\n    $desc    && $self->description( $desc );\n    $species && $self->species( $species );\n    $type    && $self->type( $type );\n    $comment && $self->comment( $comment );\n   \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $co->init();   \n Function: Initializes this Correlate to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( species Undetermined ) );\n    $self->species( $species );\n    $self->type( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $co->name( \"4(Tas1r3)\" );\n           or\n           print $co->name();\n Function: Set/get for the name or id of this Correlate.\n Returns : The name or id of this Correlate.\n Args    : The name or id of this Correlate (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $co->description( \"mouse correlate of human phenotype MIM 03923\" );\n           or\n           print $co->description();\n Function: Set/get for the description of this Correlate.\n Returns : A description of this Correlate.\n Args    : A description of this Correlate (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $co->species( $species );\n           or\n           $species = $co->species();\n Function: Set/get for the species of this Correlate.\n Returns : The Bio::Species of this Correlate [Bio::Species].\n Args    : The Bio::Species of this Correlate [Bio::Species] (optional).\n\n\nsub species {\n\n    my ( $self, $value )  = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n    \n    return $self->{ \"_species\" };\n    \n} # species\n\n\n\n\n=head2 type\n\n Title   : type\n Usage   : $co->type( \"homolog\" );\n           or\n           print $co->type();\n Function: Set/get for the type of this Correlate.\n Returns : The type of this Correlate.\n Args    : The type of this Correlate (optional).\n\n\nsub type {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_type\" } = $value;\n    }\n\n    return $self->{ \"_type\" };\n\n} # type\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $co->comment( \"doubtful\" );\n           or \n           print $co->comment();\n Function: Set/get for an arbitrary comment about this Correlate.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_comment\" } = $value;\n    }\n   \n    return $self->{ \"_comment\" };\n    \n} # comment\n\n\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $co->to_string();\n Function: To string method for Correlate objects.\n Returns : A string representations of this Correlate.\n Args    :","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":329},"end":{"character":9999,"line":348}},"name":"to_string"},{"containerName":"main::","definition":"sub","detail":"($self,$value,$expected_class)","signature":{"label":"_check_ref_type($self,$value,$expected_class)","parameters":[{"label":"$self"},{"label":"$value"},{"label":"$expected_class"}],"documentation":" Title   : _check_ref_type\n Function: Checks for the correct type.\n Returns :\n Args    : The value to be checked, the expected class."},"kind":12,"line":357,"children":[{"definition":"my","name":"$self","containerName":"_check_ref_type","localvar":"my","kind":13,"line":358},{"line":358,"kind":13,"containerName":"_check_ref_type","name":"$value"},{"name":"$expected_class","containerName":"_check_ref_type","line":358,"kind":13},{"containerName":"_check_ref_type","name":"$value","line":360,"kind":13},{"name":"$self","containerName":"_check_ref_type","line":361,"kind":13},{"containerName":"_check_ref_type","name":"throw","kind":12,"line":361},{"name":"$value","containerName":"_check_ref_type","kind":13,"line":364},{"kind":13,"line":365,"name":"$self","containerName":"_check_ref_type"},{"kind":12,"line":365,"containerName":"_check_ref_type","name":"throw"},{"containerName":"_check_ref_type","name":"$value","kind":13,"line":368},{"containerName":"_check_ref_type","name":"isa","line":368,"kind":12},{"name":"$expected_class","containerName":"_check_ref_type","kind":13,"line":368},{"kind":13,"line":369,"name":"$self","containerName":"_check_ref_type"},{"line":369,"kind":12,"containerName":"_check_ref_type","name":"throw"},{"kind":13,"line":369,"containerName":"_check_ref_type","name":"$value"}],"name":"_check_ref_type","range":{"end":{"line":372,"character":9999},"start":{"line":357,"character":0}}}],"version":5}