{"version":5,"vars":[{"line":111,"kind":14,"containerName":"main::","definition":1,"name":"TRUE"},{"containerName":"Data::Dumper::File::Basename::Bio::Root::IO::Bio::Ontology::OBOEngine::Bio::Ontology::Ontology::Bio::Ontology::TermFactory","name":"strict","line":111,"kind":12},{"line":112,"kind":14,"name":"FALSE","definition":1,"containerName":"main::"},{"line":115,"kind":2,"name":"base","containerName":""},{"signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: simplehierarchy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::OntologyIO::simplehierarchy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day, allenday@ucla.edu\n#\n# (c) Allen Day, allenday@ucla.edu, 2003.\n# (c) Department of Human Genetics, UCLA Medical School, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::simplehierarchy - a base class parser for simple hierarchy-by-indentation\n                  type formats\n\n=head1 SYNOPSIS\n\n  use Bio::OntologyIO;\n\n  # do not use directly -- use via Bio::OntologyIO\n  my $parser = Bio::OntologyIO->new\n        ( -format        => \"simplehierarchy\",\n          -file          => \"pathology_terms.csv\",\n          -indent_string => \",\",\n          -ontology_name => \"eVOC\",\n          -term_factory  => $fact,\n        );\n\n  my $ontology = $parser->next_ontology();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.  This class is nearly identical to\nOntologyIO::dagflat, see L<Bio::OntologyIO::dagflat> for details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nAllen Day\n\nEmail: allenday@ucla.edu\n\n=head2 CONTRIBUTOR\n\nChristian Zmasek\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage  Bio::OntologyIO::simplehierarchy;\n\nuse strict;\n\nuse Data::Dumper;\nuse File::Basename;\nuse Bio::Root::IO;\nuse Bio::Ontology::OBOEngine;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::TermFactory;\n\nuse constant TRUE         => 1;\nuse constant FALSE        => 0;\n\n\nuse base qw(Bio::OntologyIO);\n\n\n=head2 new\n\n Title   : new\n Usage   : see SYNOPSIS\n Function: Creates a new simplehierarchy parser.\n Returns : A new simplehierarchy parser object, implementing Bio::OntologyIO.\n Args    : -files         => a single ontology flat file holding the\n                             term relationships, or an array ref holding\n                             the file names\n           -file          => if there is only a single flat file, it may\n                             also be specified via the -file parameter\n           -ontology_name => the name of the ontology, defaults to\n                             \"Gene Ontology\"\n           -file_is_root  => Boolean indicating whether a virtual root\n                             term is to be added, the name of which will\n                             be derived from the file name. Default is false.\n                             Enabling this allows to parse multiple input\n                             files into the same ontology and still have\n                             separately rooted.\n           -engine        => the L<Bio::Ontology::OntologyEngineI> object\n                             to be reused (will be created otherwise); note\n                             that every L<Bio::Ontology::OntologyI> will\n                             qualify as well since that one inherits from the\n                             former.\n           -indent_string => the string used to indent hierarchical\n                             levels in the file.\n\n                             For a file like this:\n\n                             term0\n                               subterm1A\n                                 subterm2A\n                               subterm1B\n                               subterm1C\n\n                             indent_string would be \"  \".  Defaults to\n                             one space (\" \").\n           -comment_char  => Allows specification of a regular\n                             expression string to indicate a comment line.\n                             Currently defaults to \"[\\|\\-]\".\n                             Note: this is not yet implemented.\n\nSee L<Bio::OntologyIO>.\n\n in reality, we let OntologyIO::new do the instantiation, and override\n _initialize for all initialization work","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":167,"name":"$self","definition":"my","containerName":"_initialize","localvar":"my"},{"containerName":"_initialize","name":"@args","kind":13,"line":167},{"kind":13,"line":168,"containerName":"_initialize","name":"$self"},{"name":"@args","containerName":"_initialize","line":168,"kind":13},{"kind":13,"line":170,"containerName":"_initialize","name":"$indent","definition":"my","localvar":"my"},{"kind":13,"line":170,"containerName":"_initialize","name":"$files"},{"kind":13,"line":170,"containerName":"_initialize","name":"$fileisroot"},{"containerName":"_initialize","name":"$name","kind":13,"line":170},{"containerName":"_initialize","name":"$eng","line":170,"kind":13},{"kind":13,"line":171,"containerName":"_initialize","name":"$self"},{"name":"_rearrange","containerName":"_initialize","kind":12,"line":171},{"containerName":"_initialize","name":"@args","line":176,"kind":13},{"kind":13,"line":178,"name":"$self","containerName":"_initialize"},{"name":"_done","containerName":"_initialize","line":178,"kind":12},{"name":"$self","containerName":"_initialize","kind":13,"line":179},{"containerName":"_initialize","name":"_not_first_record","kind":12,"line":179},{"kind":13,"line":180,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"_term","line":180,"kind":12},{"containerName":"_initialize","name":"$self","line":181,"kind":13},{"kind":12,"line":181,"name":"file_is_root","containerName":"_initialize"},{"line":181,"kind":13,"containerName":"_initialize","name":"$fileisroot"},{"line":181,"kind":13,"containerName":"_initialize","name":"$fileisroot"},{"name":"$indent","containerName":"_initialize","kind":13,"line":182},{"kind":13,"line":182,"name":"$indent","containerName":"_initialize"},{"name":"$indent","containerName":"_initialize","line":184,"kind":13},{"kind":13,"line":184,"name":"$indent","containerName":"_initialize"},{"name":"$indent","containerName":"_initialize","line":185,"kind":13},{"kind":13,"line":186,"name":"$indent","containerName":"_initialize"},{"name":"$self","containerName":"_initialize","kind":13,"line":188},{"line":188,"kind":12,"containerName":"_initialize","name":"indent_string"},{"containerName":"_initialize","name":"$indent","line":188,"kind":13},{"line":189,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"$eng","kind":13,"line":192},{"containerName":"_initialize","name":"new","kind":12,"line":192},{"kind":13,"line":192,"containerName":"_initialize","name":"$eng"},{"name":"$eng","containerName":"_initialize","line":193,"kind":13},{"kind":12,"line":193,"containerName":"_initialize","name":"isa"},{"line":194,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"ontology_name","line":194,"kind":12},{"kind":13,"line":194,"name":"$eng","containerName":"_initialize"},{"line":194,"kind":12,"name":"name","containerName":"_initialize"},{"name":"$eng","containerName":"_initialize","kind":13,"line":195},{"line":195,"kind":13,"containerName":"_initialize","name":"$eng"},{"line":195,"kind":12,"name":"engine","containerName":"_initialize"},{"line":195,"kind":13,"name":"$eng","containerName":"_initialize"},{"containerName":"_initialize","name":"can","kind":12,"line":195},{"kind":13,"line":197,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"_ont_engine","line":197,"kind":12},{"line":197,"kind":13,"containerName":"_initialize","name":"$eng"},{"kind":13,"line":200,"name":"$self","containerName":"_initialize"},{"line":200,"kind":13,"name":"$files","containerName":"_initialize"},{"containerName":"_initialize","name":"$files","line":200,"kind":13},{"line":200,"kind":13,"name":"$files","containerName":"_initialize"},{"kind":13,"line":200,"name":"$files","containerName":"_initialize"},{"kind":13,"line":203,"name":"$self","containerName":"_initialize"},{"line":203,"kind":12,"name":"ontology_name","containerName":"_initialize"},{"line":203,"kind":13,"name":"$name","containerName":"_initialize"},{"name":"$name","containerName":"_initialize","line":203,"kind":13}],"line":166,"kind":12,"range":{"start":{"line":166,"character":0},"end":{"character":9999,"line":205}},"name":"_initialize"},{"containerName":"_initialize","name":"SUPER","kind":12,"line":168},{"line":178,"kind":12,"name":"FALSE"},{"kind":12,"line":179,"name":"FALSE"},{"containerName":"Ontology::OBOEngine","name":"Bio","kind":12,"line":192},{"name":"_flat_files","kind":12,"line":200},{"kind":12,"line":218,"children":[{"localvar":"my","containerName":"ontology_name","definition":"my","name":"$self","line":219,"kind":13},{"containerName":"ontology_name","name":"$self","line":221,"kind":13},{"kind":13,"line":222,"name":"$self","containerName":"ontology_name"}],"containerName":"main::","definition":"sub","name":"ontology_name","range":{"start":{"character":0,"line":218},"end":{"line":223,"character":9999}}},{"kind":12,"line":242,"children":[{"definition":"my","name":"$self","containerName":"parse","localvar":"my","kind":13,"line":243},{"line":246,"kind":13,"containerName":"parse","name":"$self"},{"line":246,"kind":12,"name":"term_factory","containerName":"parse"},{"containerName":"parse","name":"new","kind":12,"line":246},{"containerName":"parse","name":"$self","kind":13,"line":248},{"kind":12,"line":248,"name":"term_factory","containerName":"parse"},{"containerName":"parse","name":"$ont","definition":"my","localvar":"my","kind":13,"line":251},{"line":251,"kind":12,"containerName":"parse","name":"new"},{"line":251,"kind":13,"name":"$self","containerName":"parse"},{"line":251,"kind":12,"name":"ontology_name","containerName":"parse"},{"kind":13,"line":252,"name":"$self","containerName":"parse"},{"containerName":"parse","name":"_ont_engine","line":252,"kind":12},{"line":255,"kind":13,"name":"$self","containerName":"parse"},{"name":"_part_of_relationship","containerName":"parse","line":255,"kind":12},{"name":"$self","containerName":"parse","kind":13,"line":256},{"containerName":"parse","name":"_is_a_relationship","line":256,"kind":12},{"name":"$self","containerName":"parse","kind":13,"line":257},{"line":257,"kind":12,"name":"_related_to_relationship","containerName":"parse"},{"name":"ontology","containerName":"parse","kind":12,"line":258},{"line":258,"kind":13,"name":"$ont","containerName":"parse"},{"kind":13,"line":262,"containerName":"parse","name":"$self"},{"name":"_fh","containerName":"parse","kind":12,"line":262},{"name":"$self","containerName":"parse","line":263,"kind":13},{"kind":12,"line":263,"name":"_initialize_io","containerName":"parse"},{"line":263,"kind":13,"name":"$self","containerName":"parse"},{"kind":12,"line":263,"name":"_flat_files","containerName":"parse"}],"containerName":"main::","name":"parse","definition":"sub","range":{"end":{"line":264,"character":9999},"start":{"character":0,"line":242}}},{"name":"Bio","containerName":"Ontology::TermFactory","kind":12,"line":246},{"containerName":"Ontology::Ontology","name":"Bio","line":251,"kind":12},{"name":"$self","containerName":null,"line":266,"kind":13},{"kind":12,"line":266,"containerName":"main::","name":"_fh"},{"line":267,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"_parse_flat_file","kind":12,"line":267},{"line":267,"kind":13,"name":"$ont","containerName":null},{"line":269,"kind":13,"name":"$self","containerName":null},{"name":"_flat_files","containerName":"main::","kind":12,"line":269},{"kind":13,"line":270,"name":"$self","containerName":null},{"containerName":"main::","name":"close","line":270,"kind":12},{"name":"$self","containerName":null,"line":273,"kind":13},{"line":273,"kind":12,"containerName":"main::","name":"_virtual_root"},{"kind":13,"line":275,"containerName":null,"name":"$self"},{"kind":12,"line":275,"containerName":"main::","name":"_initialize_io"},{"name":"$self","containerName":null,"kind":13,"line":275},{"name":"_flat_files","containerName":"main::","kind":12,"line":275},{"kind":13,"line":280,"containerName":null,"name":"$self"},{"line":280,"kind":12,"containerName":"main::","name":"_add_ontology"},{"line":280,"kind":13,"name":"$ont","containerName":null},{"line":282,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":282,"name":"_ont_engine","containerName":"main::"},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"next_ontology","line":299,"kind":13},{"containerName":"next_ontology","name":"$self","kind":13,"line":302},{"kind":12,"line":302,"name":"parse","containerName":"next_ontology"},{"kind":13,"line":302,"containerName":"next_ontology","name":"$self"},{"line":304,"kind":13,"containerName":"next_ontology","name":"$self"}],"line":298,"definition":"sub","name":"next_ontology","containerName":"main::","range":{"end":{"character":9999,"line":304},"start":{"line":298,"character":0}}},{"name":"%self","containerName":null,"line":304,"kind":13},{"containerName":"main::","name":"_flat_files","definition":"sub","range":{"end":{"character":9999,"line":329},"start":{"character":0,"line":324}},"kind":12,"line":324,"children":[{"containerName":"_flat_files","name":"$self","definition":"my","localvar":"my","kind":13,"line":325},{"containerName":"_flat_files","name":"$self","line":327,"kind":13},{"name":"$self","containerName":"_flat_files","line":327,"kind":13},{"containerName":"_flat_files","name":"$self","line":328,"kind":13}]},{"kind":12,"line":327,"name":"_flat_files"},{"kind":12,"line":327,"name":"_flat_files"},{"line":328,"kind":12,"name":"_flat_files"},{"line":347,"children":[{"localvar":"my","containerName":"_defs_io","name":"$self","definition":"my","line":348,"kind":13},{"name":"$self","containerName":"_defs_io","line":350,"kind":13},{"name":"$self","containerName":"_defs_io","line":351,"kind":13}],"kind":12,"range":{"end":{"character":9999,"line":352},"start":{"line":347,"character":0}},"containerName":"main::","name":"_defs_io","definition":"sub"},{"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_add_ontology","line":355,"kind":13},{"line":356,"kind":13,"name":"$self","containerName":"_add_ontology"},{"line":356,"kind":13,"containerName":"_add_ontology","name":"$self"},{"containerName":"_add_ontology","name":"$ont","definition":"my","localvar":"my","kind":13,"line":357},{"kind":13,"line":358,"containerName":"_add_ontology","name":"$self"},{"line":358,"kind":12,"containerName":"_add_ontology","name":"throw"},{"kind":13,"line":358,"containerName":"_add_ontology","name":"$ont"},{"kind":13,"line":359,"containerName":"_add_ontology","name":"$ont"},{"kind":13,"line":359,"containerName":"_add_ontology","name":"$ont"},{"line":359,"kind":12,"containerName":"_add_ontology","name":"isa"},{"name":"$self","containerName":"_add_ontology","line":360,"kind":13},{"kind":13,"line":360,"containerName":"_add_ontology","name":"$ont"}],"line":354,"kind":12,"range":{"start":{"character":0,"line":354},"end":{"line":361,"character":9999}},"definition":"sub","name":"_add_ontology","containerName":"main::"},{"range":{"end":{"line":372,"character":9999},"start":{"character":0,"line":365}},"name":"_add_term","line":365,"children":[{"line":366,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_add_term"},{"line":366,"kind":13,"name":"$term","containerName":"_add_term"},{"name":"$ont","containerName":"_add_term","line":366,"kind":13},{"line":368,"kind":13,"containerName":"_add_term","name":"$term"},{"containerName":"_add_term","name":"ontology","kind":12,"line":368},{"kind":13,"line":368,"name":"$ont","containerName":"_add_term"},{"name":"$ont","containerName":"_add_term","line":368,"kind":13},{"name":"$term","containerName":"_add_term","line":368,"kind":13},{"kind":12,"line":368,"containerName":"_add_term","name":"ontology"},{"containerName":"_add_term","name":"$self","line":369,"kind":13},{"line":369,"kind":12,"name":"_ont_engine","containerName":"_add_term"},{"kind":12,"line":369,"containerName":"_add_term","name":"add_term"},{"containerName":"_add_term","name":"$term","line":369,"kind":13}],"kind":12,"detail":"($self,$term,$ont)","signature":{"parameters":[{"label":"$self"},{"label":"$term"},{"label":"$ont"}],"documentation":" This simply delegates. See SimpleGOEngine.","label":"_add_term($self,$term,$ont)"},"containerName":"main::","definition":"sub"},{"name":"_part_of_relationship","range":{"start":{"character":0,"line":375},"end":{"line":380,"character":9999}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$term"}],"documentation":" This simply delegates. See SimpleGOEngine","label":"_part_of_relationship($self,$term)"},"detail":"($self,$term)","kind":12,"children":[{"localvar":"my","containerName":"_part_of_relationship","definition":"my","name":"$self","line":376,"kind":13},{"line":376,"kind":13,"containerName":"_part_of_relationship","name":"$term"},{"kind":13,"line":378,"containerName":"_part_of_relationship","name":"$self"},{"name":"_ont_engine","containerName":"_part_of_relationship","line":378,"kind":12},{"kind":12,"line":378,"name":"part_of_relationship","containerName":"_part_of_relationship"}],"line":375},{"range":{"start":{"character":0,"line":385},"end":{"line":390,"character":9999}},"name":"_is_a_relationship","children":[{"kind":13,"line":386,"name":"$self","definition":"my","containerName":"_is_a_relationship","localvar":"my"},{"containerName":"_is_a_relationship","name":"$term","kind":13,"line":386},{"name":"$self","containerName":"_is_a_relationship","kind":13,"line":388},{"containerName":"_is_a_relationship","name":"_ont_engine","kind":12,"line":388},{"line":388,"kind":12,"name":"is_a_relationship","containerName":"_is_a_relationship"}],"line":385,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$term"}],"documentation":" This simply delegates. See SimpleGOEngine","label":"_is_a_relationship($self,$term)"},"detail":"($self,$term)","definition":"sub","containerName":"main::"},{"name":"_related_to_relationship","range":{"end":{"character":9999,"line":399},"start":{"line":394,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$term)","signature":{"label":"_related_to_relationship($self,$term)","documentation":" This simply delegates. See SimpleGOEngine","parameters":[{"label":"$self"},{"label":"$term"}]},"kind":12,"line":394,"children":[{"line":395,"kind":13,"localvar":"my","containerName":"_related_to_relationship","definition":"my","name":"$self"},{"kind":13,"line":395,"name":"$term","containerName":"_related_to_relationship"},{"name":"$self","containerName":"_related_to_relationship","kind":13,"line":397},{"line":397,"kind":12,"containerName":"_related_to_relationship","name":"_ont_engine"},{"kind":12,"line":397,"name":"related_to_relationship","containerName":"_related_to_relationship"}]},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"_add_relationship","localvar":"my","kind":13,"line":404},{"kind":13,"line":404,"name":"$parent","containerName":"_add_relationship"},{"kind":13,"line":404,"containerName":"_add_relationship","name":"$child"},{"kind":13,"line":404,"containerName":"_add_relationship","name":"$type"},{"name":"$ont","containerName":"_add_relationship","kind":13,"line":404},{"kind":13,"line":408,"containerName":"_add_relationship","name":"$self"},{"kind":12,"line":408,"name":"_ont_engine","containerName":"_add_relationship"},{"kind":12,"line":408,"containerName":"_add_relationship","name":"add_relationship"},{"kind":13,"line":408,"containerName":"_add_relationship","name":"$child"},{"containerName":"_add_relationship","name":"$type","kind":13,"line":408},{"name":"$parent","containerName":"_add_relationship","line":408,"kind":13},{"line":408,"kind":13,"name":"$ont","containerName":"_add_relationship"}],"line":403,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$parent"},{"label":"$child"},{"label":"$type"},{"label":"$ont"}],"documentation":" This simply delegates. See SimpleGOEngine","label":"_add_relationship($self,$parent,$child,$type,$ont)"},"detail":"($self,$parent,$child,$type,$ont)","name":"_add_relationship","range":{"start":{"line":403,"character":0},"end":{"line":411,"character":9999}}},{"children":[{"containerName":"_has_term","name":"$self","definition":"my","localvar":"my","kind":13,"line":416},{"containerName":"_has_term","name":"$term","kind":13,"line":416},{"kind":13,"line":418,"containerName":"_has_term","name":"$term"},{"containerName":"_has_term","name":"$self","line":418,"kind":13},{"containerName":"_has_term","name":"ontology_name","kind":12,"line":418},{"name":"$term","containerName":"_has_term","line":419,"kind":13},{"kind":13,"line":419,"containerName":"_has_term","name":"$term"},{"line":419,"kind":13,"containerName":"_has_term","name":"$self"},{"name":"ontology_name","containerName":"_has_term","kind":12,"line":419},{"name":"$self","containerName":"_has_term","line":420,"kind":13},{"name":"_ont_engine","containerName":"_has_term","line":420,"kind":12},{"name":"has_term","containerName":"_has_term","line":420,"kind":12},{"kind":13,"line":420,"name":"$term","containerName":"_has_term"}],"line":415,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$term"}],"documentation":" This simply delegates. See SimpleGOEngine","label":"_has_term($self,$term)"},"detail":"($self,$term)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":415},"end":{"character":9999,"line":422}},"name":"_has_term"},{"children":[{"containerName":"_get_terms","name":"$self","definition":"my","localvar":"my","kind":13,"line":427},{"containerName":"_get_terms","definition":"my","name":"@args","localvar":"my","kind":13,"line":428},{"line":431,"kind":13,"containerName":"_get_terms","name":"@args"},{"containerName":"_get_terms","name":"$args","line":432,"kind":13},{"name":"$self","containerName":"_get_terms","line":432,"kind":13},{"kind":12,"line":432,"name":"ontology_name","containerName":"_get_terms"},{"kind":13,"line":432,"containerName":"_get_terms","name":"$args"},{"line":433,"kind":13,"name":"$args","containerName":"_get_terms"},{"name":"$self","containerName":"_get_terms","kind":13,"line":433},{"containerName":"_get_terms","name":"ontology_name","line":433,"kind":12},{"name":"$self","containerName":"_get_terms","line":435,"kind":13},{"name":"_ont_engine","containerName":"_get_terms","line":435,"kind":12},{"containerName":"_get_terms","name":"get_terms","line":435,"kind":12},{"containerName":"_get_terms","name":"@args","kind":13,"line":435}],"line":426,"kind":12,"range":{"start":{"line":426,"character":0},"end":{"character":9999,"line":436}},"name":"_get_terms","definition":"sub","containerName":"main::"},{"kind":12,"children":[{"kind":13,"line":441,"definition":"my","name":"$self","containerName":"_parse_flat_file","localvar":"my"},{"localvar":"my","containerName":"_parse_flat_file","name":"$ont","definition":"my","line":442,"kind":13},{"containerName":"_parse_flat_file","name":"@stack","definition":"my","localvar":"my","kind":13,"line":444},{"localvar":"my","definition":"my","name":"$prev_indent","containerName":"_parse_flat_file","line":445,"kind":13},{"containerName":"_parse_flat_file","definition":"my","name":"$parent","localvar":"my","kind":13,"line":446},{"containerName":"_parse_flat_file","definition":"my","name":"$prev_term","localvar":"my","kind":13,"line":447},{"localvar":"my","name":"$indent_string","definition":"my","containerName":"_parse_flat_file","line":449,"kind":13},{"name":"$self","containerName":"_parse_flat_file","line":449,"kind":13},{"line":449,"kind":12,"containerName":"_parse_flat_file","name":"indent_string"},{"line":452,"kind":13,"localvar":"my","containerName":"_parse_flat_file","definition":"my","name":"$line"},{"containerName":"_parse_flat_file","name":"$self","line":452,"kind":13},{"line":452,"kind":12,"name":"_readline","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$line","kind":13,"line":453},{"line":457,"kind":13,"localvar":"my","name":"$current_term","definition":"my","containerName":"_parse_flat_file"},{"name":"$line","containerName":"_parse_flat_file","line":457,"kind":13},{"line":458,"kind":13,"localvar":"my","name":"$current_indent","definition":"my","containerName":"_parse_flat_file"},{"name":"$self","containerName":"_parse_flat_file","line":458,"kind":13},{"kind":12,"line":458,"name":"_count_indents","containerName":"_parse_flat_file"},{"line":458,"kind":13,"containerName":"_parse_flat_file","name":"$line"},{"name":"$current_term","containerName":"_parse_flat_file","kind":13,"line":459},{"name":"$current_term","containerName":"_parse_flat_file","kind":13,"line":461},{"line":463,"kind":13,"containerName":"_parse_flat_file","name":"$current_term"},{"localvar":"my","definition":"my","name":"$syn","containerName":"_parse_flat_file","line":465,"kind":13},{"kind":13,"line":465,"name":"$current_term","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$self","kind":13,"line":467},{"containerName":"_parse_flat_file","name":"_has_term","line":467,"kind":12},{"name":"$current_term","containerName":"_parse_flat_file","line":467,"kind":13},{"containerName":"_parse_flat_file","name":"$term","definition":"my","localvar":"my","kind":13,"line":468},{"name":"$self","containerName":"_parse_flat_file","kind":13,"line":468},{"kind":12,"line":468,"name":"_create_ont_entry","containerName":"_parse_flat_file"},{"kind":13,"line":468,"name":"$current_term","containerName":"_parse_flat_file"},{"line":470,"kind":13,"containerName":"_parse_flat_file","name":"$term"},{"kind":12,"line":470,"containerName":"_parse_flat_file","name":"add_synonym"},{"line":470,"kind":13,"containerName":"_parse_flat_file","name":"$syn"},{"name":"$syn","containerName":"_parse_flat_file","kind":13,"line":470},{"line":472,"kind":13,"name":"$self","containerName":"_parse_flat_file"},{"line":472,"kind":12,"containerName":"_parse_flat_file","name":"_add_term"},{"name":"$term","containerName":"_parse_flat_file","line":472,"kind":13},{"line":472,"kind":13,"containerName":"_parse_flat_file","name":"$ont"},{"containerName":"_parse_flat_file","name":"$current_indent","line":475,"kind":13},{"containerName":"_parse_flat_file","name":"$self","line":477,"kind":13},{"kind":12,"line":477,"name":"_virtual_root","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$self","line":478,"kind":13},{"name":"_add_relationship","containerName":"_parse_flat_file","line":478,"kind":12},{"containerName":"_parse_flat_file","name":"$self","line":478,"kind":13},{"name":"_virtual_root","containerName":"_parse_flat_file","line":478,"kind":12},{"containerName":"_parse_flat_file","name":"$term","line":479,"kind":13},{"line":480,"kind":13,"name":"$self","containerName":"_parse_flat_file"},{"kind":12,"line":480,"name":"_is_a_relationship","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$ont","kind":13,"line":481},{"line":483,"kind":13,"containerName":"_parse_flat_file","name":"$prev_indent"},{"line":483,"kind":13,"name":"$current_indent","containerName":"_parse_flat_file"},{"line":484,"kind":13,"name":"$prev_term","containerName":"_parse_flat_file"},{"line":484,"kind":13,"name":"$current_term","containerName":"_parse_flat_file"},{"line":485,"kind":13,"name":"@stack","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$current_term","line":485,"kind":13},{"line":493,"kind":13,"containerName":"_parse_flat_file","name":"$current_indent"},{"containerName":"_parse_flat_file","name":"$prev_indent","line":493,"kind":13},{"name":"$current_indent","containerName":"_parse_flat_file","kind":13,"line":494},{"name":"$prev_indent","containerName":"_parse_flat_file","kind":13,"line":494},{"containerName":"_parse_flat_file","name":"@stack","line":495,"kind":13},{"line":495,"kind":13,"name":"$prev_term","containerName":"_parse_flat_file"},{"kind":13,"line":496,"containerName":"_parse_flat_file","name":"$current_indent"},{"kind":13,"line":496,"name":"$prev_indent","containerName":"_parse_flat_file"},{"kind":13,"line":497,"containerName":"_parse_flat_file","definition":"my","name":"$n","localvar":"my"},{"line":497,"kind":13,"containerName":"_parse_flat_file","name":"$prev_indent"},{"name":"$current_indent","containerName":"_parse_flat_file","kind":13,"line":497},{"definition":"my","name":"$i","containerName":"_parse_flat_file","localvar":"my","kind":13,"line":498},{"line":498,"kind":13,"containerName":"_parse_flat_file","name":"$i"},{"containerName":"_parse_flat_file","name":"$n","line":498,"kind":13},{"kind":13,"line":498,"containerName":"_parse_flat_file","name":"$i"},{"containerName":"_parse_flat_file","name":"@stack","line":499,"kind":13},{"containerName":"_parse_flat_file","name":"$self","line":502,"kind":13},{"containerName":"_parse_flat_file","name":"throw","line":502,"kind":12},{"name":"$self","containerName":"_parse_flat_file","line":505,"kind":13},{"containerName":"_parse_flat_file","name":"file","line":505,"kind":12},{"line":509,"kind":13,"name":"$parent","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$stack","line":509,"kind":13},{"kind":13,"line":511,"containerName":"_parse_flat_file","name":"$parent"},{"kind":13,"line":511,"containerName":"_parse_flat_file","name":"$current_term"},{"containerName":"_parse_flat_file","name":"$self","line":512,"kind":13},{"kind":12,"line":512,"name":"_add_relationship","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$self","kind":13,"line":512},{"name":"_get_terms","containerName":"_parse_flat_file","kind":12,"line":512},{"kind":13,"line":512,"containerName":"_parse_flat_file","name":"$parent"},{"containerName":"_parse_flat_file","name":"$self","kind":13,"line":513},{"line":513,"kind":12,"name":"_get_terms","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$current_term","line":513,"kind":13},{"name":"$self","containerName":"_parse_flat_file","kind":13,"line":514},{"containerName":"_parse_flat_file","name":"_is_a_relationship","kind":12,"line":514},{"line":515,"kind":13,"containerName":"_parse_flat_file","name":"$ont"},{"line":518,"kind":13,"name":"$prev_indent","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$current_indent","kind":13,"line":518},{"name":"$prev_term","containerName":"_parse_flat_file","line":519,"kind":13},{"line":519,"kind":13,"name":"$current_term","containerName":"_parse_flat_file"},{"containerName":"_parse_flat_file","name":"$ont","line":521,"kind":13}],"line":440,"definition":"sub","name":"_parse_flat_file","containerName":"main::","range":{"end":{"line":522,"character":9999},"start":{"line":440,"character":0}}},{"containerName":"main::","definition":"sub","detail":"($self,$line)","signature":{"label":"_get_first_termid($self,$line)","documentation":" Parses the 1st term id number out of line.","parameters":[{"label":"$self"},{"label":"$line"}]},"kind":12,"line":527,"children":[{"definition":"my","name":"$self","containerName":"_get_first_termid","localvar":"my","kind":13,"line":528},{"kind":13,"line":528,"containerName":"_get_first_termid","name":"$line"},{"kind":13,"line":530,"containerName":"_get_first_termid","name":"$line"},{"name":"$self","containerName":"_get_first_termid","kind":13,"line":534},{"line":534,"kind":12,"name":"throw","containerName":"_get_first_termid"}],"name":"_get_first_termid","range":{"end":{"character":9999,"line":537},"start":{"line":527,"character":0}}},{"children":[{"line":541,"kind":13,"localvar":"my","containerName":"_count_indents","name":"$self","definition":"my"},{"line":541,"kind":13,"name":"$line","containerName":"_count_indents"},{"localvar":"my","definition":"my","name":"$indent","containerName":"_count_indents","line":543,"kind":13},{"name":"$self","containerName":"_count_indents","kind":13,"line":543},{"containerName":"_count_indents","name":"indent_string","line":543,"kind":12},{"kind":13,"line":545,"name":"$line","containerName":"_count_indents"},{"name":"$indent","containerName":"_count_indents","kind":13,"line":546}],"line":540,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$line"}],"documentation":" Counts the indents at the beginning of a line in the relationships files","label":"_count_indents($self,$line)"},"detail":"($self,$line)","definition":"sub","containerName":"main::","range":{"end":{"line":551,"character":9999},"start":{"character":0,"line":540}},"name":"_count_indents"},{"line":555,"children":[{"name":"$self","definition":"my","containerName":"_ont_engine","localvar":"my","kind":13,"line":556},{"kind":13,"line":556,"name":"$value","containerName":"_ont_engine"},{"name":"$value","containerName":"_ont_engine","kind":13,"line":558},{"containerName":"_ont_engine","name":"$self","kind":13,"line":559},{"kind":13,"line":559,"name":"$value","containerName":"_ont_engine"},{"line":562,"kind":13,"name":"$self","containerName":"_ont_engine"}],"kind":12,"detail":"($self,$value)","signature":{"documentation":" Holds the GO engine to be parsed into","parameters":[{"label":"$self"},{"label":"$value"}],"label":"_ont_engine($self,$value)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":555},"end":{"line":563,"character":9999}},"name":"_ont_engine"},{"name":"_create_ont_entry","range":{"end":{"line":576,"character":9999},"start":{"line":568,"character":0}},"kind":12,"children":[{"kind":13,"line":569,"containerName":"_create_ont_entry","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":569,"containerName":"_create_ont_entry","name":"$name"},{"name":"$termid","containerName":"_create_ont_entry","kind":13,"line":569},{"kind":13,"line":571,"containerName":"_create_ont_entry","definition":"my","name":"$term","localvar":"my"},{"line":571,"kind":13,"containerName":"_create_ont_entry","name":"$self"},{"line":571,"kind":12,"containerName":"_create_ont_entry","name":"term_factory"},{"kind":12,"line":571,"containerName":"_create_ont_entry","name":"create_object"},{"line":571,"kind":13,"containerName":"_create_ont_entry","name":"$name"},{"name":"$termid","containerName":"_create_ont_entry","kind":13,"line":572},{"name":"$term","containerName":"_create_ont_entry","line":574,"kind":13}],"line":568,"definition":"sub","containerName":"main::","signature":{"label":"_create_ont_entry($self,$name,$termid)","documentation":" Used to create ontology terms.\n Arguments: name, id","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$termid"}]},"detail":"($self,$name,$termid)"},{"name":"_not_first_record","range":{"start":{"line":580,"character":0},"end":{"character":9999,"line":591}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_not_first_record","line":581,"kind":13},{"name":"$value","containerName":"_not_first_record","kind":13,"line":581},{"kind":13,"line":583,"name":"$value","containerName":"_not_first_record"},{"kind":13,"line":584,"containerName":"_not_first_record","name":"$value"},{"containerName":"_not_first_record","name":"$value","line":584,"kind":13},{"line":585,"kind":13,"name":"$self","containerName":"_not_first_record"},{"line":585,"kind":12,"containerName":"_not_first_record","name":"throw"},{"kind":13,"line":587,"name":"$self","containerName":"_not_first_record"},{"line":587,"kind":13,"containerName":"_not_first_record","name":"$value"},{"kind":13,"line":590,"name":"$self","containerName":"_not_first_record"}],"line":580,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":" Holds whether first record or not","label":"_not_first_record($self,$value)"},"detail":"($self,$value)"},{"line":584,"kind":12,"name":"FALSE"},{"name":"TRUE","kind":12,"line":584},{"name":"TRUE","kind":12,"line":585},{"name":"FALSE","line":585,"kind":12},{"name":"_done","range":{"end":{"character":9999,"line":608},"start":{"character":0,"line":596}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"_done($self,$value)","documentation":" Holds whether done or not","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"line":596,"children":[{"localvar":"my","containerName":"_done","name":"$self","definition":"my","line":597,"kind":13},{"line":597,"kind":13,"containerName":"_done","name":"$value"},{"kind":13,"line":599,"name":"$value","containerName":"_done"},{"name":"$value","containerName":"_done","kind":13,"line":600},{"containerName":"_done","name":"$value","kind":13,"line":600},{"name":"$self","containerName":"_done","line":601,"kind":13},{"containerName":"_done","name":"throw","kind":12,"line":601},{"containerName":"_done","name":"$self","line":604,"kind":13},{"line":604,"kind":13,"name":"$value","containerName":"_done"},{"kind":13,"line":607,"name":"$self","containerName":"_done"}]},{"name":"FALSE","kind":12,"line":600},{"name":"TRUE","kind":12,"line":600},{"name":"TRUE","kind":12,"line":602},{"kind":12,"line":602,"name":"FALSE"},{"range":{"end":{"character":9999,"line":620},"start":{"character":0,"line":612}},"name":"_term","signature":{"label":"_term($self,$value)","documentation":" Holds a term.","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"_term","localvar":"my","kind":13,"line":613},{"name":"$value","containerName":"_term","kind":13,"line":613},{"line":615,"kind":13,"name":"$value","containerName":"_term"},{"line":616,"kind":13,"containerName":"_term","name":"$self"},{"containerName":"_term","name":"$value","line":616,"kind":13},{"kind":13,"line":619,"containerName":"_term","name":"$self"}],"line":612,"kind":12},{"range":{"end":{"line":638,"character":9999},"start":{"line":633,"character":0}},"definition":"sub","name":"indent_string","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"indent_string","line":634,"kind":13},{"containerName":"indent_string","name":"$self","line":636,"kind":13},{"line":637,"kind":13,"containerName":"indent_string","name":"$self"}],"line":633,"kind":12},{"line":657,"children":[{"definition":"my","name":"$self","containerName":"file_is_root","localvar":"my","kind":13,"line":658},{"containerName":"file_is_root","name":"$self","kind":13,"line":660},{"containerName":"file_is_root","name":"$self","line":661,"kind":13}],"kind":12,"range":{"start":{"line":657,"character":0},"end":{"line":662,"character":9999}},"containerName":"main::","name":"file_is_root","definition":"sub"},{"range":{"end":{"character":9999,"line":694},"start":{"character":0,"line":675}},"name":"_virtual_root","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_virtual_root","line":676,"kind":13},{"containerName":"_virtual_root","name":"$self","kind":13,"line":678},{"line":682,"kind":13,"containerName":"_virtual_root","name":"$self"},{"containerName":"_virtual_root","name":"file_is_root","line":682,"kind":12},{"line":682,"kind":13,"containerName":"_virtual_root","name":"$self"},{"line":682,"kind":12,"containerName":"_virtual_root","name":"file"},{"containerName":"_virtual_root","name":"$self","kind":13,"line":685},{"line":686,"kind":13,"localvar":"my","name":"$rt","definition":"my","containerName":"_virtual_root"},{"containerName":"_virtual_root","name":"$self","kind":13,"line":686},{"line":686,"kind":12,"name":"file","containerName":"_virtual_root"},{"line":687,"kind":13,"containerName":"_virtual_root","name":"$rt"},{"name":"$rt","containerName":"_virtual_root","kind":13,"line":688},{"name":"$self","containerName":"_virtual_root","line":688,"kind":13},{"line":688,"kind":12,"containerName":"_virtual_root","name":"_create_ont_entry"},{"containerName":"_virtual_root","name":"$rt","kind":13,"line":688},{"line":689,"kind":13,"name":"$self","containerName":"_virtual_root"},{"kind":12,"line":689,"name":"_add_term","containerName":"_virtual_root"},{"kind":13,"line":689,"containerName":"_virtual_root","name":"$rt"},{"kind":13,"line":689,"name":"$self","containerName":"_virtual_root"},{"name":"ontology_name","containerName":"_virtual_root","kind":12,"line":689},{"containerName":"_virtual_root","name":"$self","line":690,"kind":13},{"line":690,"kind":13,"name":"$rt","containerName":"_virtual_root"},{"kind":13,"line":693,"name":"$self","containerName":"_virtual_root"}],"line":675,"kind":12},{"line":686,"kind":12,"name":"fileparse"}]}