{"vars":[{"kind":2,"line":90,"containerName":"","name":"base"},{"range":{"start":{"character":0,"line":103},"end":{"line":118,"character":9999}},"name":"new","children":[{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":104,"kind":13},{"name":"@args","containerName":"new","line":104,"kind":13},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":105,"kind":13},{"containerName":"new","name":"$class","line":105,"kind":13},{"name":"@args","containerName":"new","line":105,"kind":13},{"kind":13,"line":108,"name":"$self","containerName":"new"},{"kind":12,"line":108,"containerName":"new","name":"_term_store"},{"kind":13,"line":109,"containerName":"new","name":"$self"},{"name":"_relationship_store","containerName":"new","line":109,"kind":12},{"line":110,"kind":13,"containerName":"new","name":"$self"},{"name":"_inverted_relationship_store","containerName":"new","line":110,"kind":12},{"kind":13,"line":111,"containerName":"new","name":"$self"},{"containerName":"new","name":"_relationship_type_store","kind":12,"line":111},{"name":"$self","containerName":"new","line":112,"kind":13},{"name":"_instantiated_terms_store","containerName":"new","kind":12,"line":112},{"line":115,"kind":13,"containerName":"new","name":"$self"},{"line":115,"kind":12,"containerName":"new","name":"relationship_factory"},{"name":"new","containerName":"new","kind":12,"line":115},{"name":"$self","containerName":"new","kind":13,"line":117}],"line":103,"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :","label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::"},{"containerName":"new","name":"SUPER","kind":12,"line":105},{"containerName":"Ontology::RelationshipFactory","name":"Bio","line":115,"kind":12},{"range":{"end":{"character":9999,"line":138},"start":{"line":131,"character":0}},"name":"_instantiated_terms_store","detail":"($self,$value)","signature":{"label":"_instantiated_terms_store($self,$value)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","line":131,"children":[{"line":132,"kind":13,"localvar":"my","containerName":"_instantiated_terms_store","definition":"my","name":"$self"},{"name":"$value","containerName":"_instantiated_terms_store","line":132,"kind":13},{"kind":13,"line":134,"name":"$value","containerName":"_instantiated_terms_store"},{"name":"$self","containerName":"_instantiated_terms_store","line":135,"kind":13},{"containerName":"_instantiated_terms_store","name":"$value","kind":13,"line":135},{"containerName":"_instantiated_terms_store","name":"$self","line":137,"kind":13}],"kind":12},{"name":"mark_instantiated","range":{"end":{"line":165,"character":9999},"start":{"line":155,"character":0}},"kind":12,"children":[{"containerName":"mark_instantiated","name":"$self","definition":"my","localvar":"my","kind":13,"line":156},{"name":"@terms","containerName":"mark_instantiated","kind":13,"line":156},{"definition":"my","name":"$term","containerName":"mark_instantiated","localvar":"my","kind":13,"line":158},{"line":158,"kind":13,"containerName":"mark_instantiated","name":"@terms"},{"line":159,"kind":13,"name":"$self","containerName":"mark_instantiated"},{"line":159,"kind":12,"containerName":"mark_instantiated","name":"throw"},{"line":159,"kind":13,"name":"$term","containerName":"mark_instantiated"},{"containerName":"mark_instantiated","name":"identifier","kind":12,"line":159},{"kind":13,"line":160,"containerName":"mark_instantiated","name":"$self"},{"kind":12,"line":160,"name":"_term_store","containerName":"mark_instantiated"},{"containerName":"mark_instantiated","name":"$term","line":160,"kind":13},{"kind":12,"line":160,"containerName":"mark_instantiated","name":"identifier"},{"containerName":"mark_instantiated","name":"$self","kind":13,"line":161},{"kind":12,"line":161,"containerName":"mark_instantiated","name":"_instantiated_terms_store"},{"kind":13,"line":161,"name":"$term","containerName":"mark_instantiated"},{"kind":12,"line":161,"containerName":"mark_instantiated","name":"identifier"},{"line":164,"kind":13,"name":"@terms","containerName":"mark_instantiated"}],"line":155,"definition":"sub","containerName":"main::","signature":{"label":"mark_instantiated($self,@terms)","parameters":[{"label":"$self"},{"label":"@terms"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI."},"detail":"($self,@terms)"},{"range":{"end":{"line":190,"character":9999},"start":{"character":0,"line":179}},"name":"mark_uninstantiated","detail":"($self,@terms)","signature":{"label":"mark_uninstantiated($self,@terms)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.","parameters":[{"label":"$self"},{"label":"@terms"}]},"containerName":"main::","definition":"sub","line":179,"children":[{"line":180,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"mark_uninstantiated"},{"line":180,"kind":13,"name":"@terms","containerName":"mark_uninstantiated"},{"line":182,"kind":13,"localvar":"my","definition":"my","name":"$term","containerName":"mark_uninstantiated"},{"kind":13,"line":182,"containerName":"mark_uninstantiated","name":"@terms"},{"kind":13,"line":183,"containerName":"mark_uninstantiated","name":"$self"},{"containerName":"mark_uninstantiated","name":"throw","line":183,"kind":12},{"kind":13,"line":183,"name":"$term","containerName":"mark_uninstantiated"},{"kind":12,"line":183,"containerName":"mark_uninstantiated","name":"identifier"},{"kind":13,"line":184,"containerName":"mark_uninstantiated","name":"$self"},{"line":184,"kind":12,"name":"_term_store","containerName":"mark_uninstantiated"},{"containerName":"mark_uninstantiated","name":"$term","kind":13,"line":184},{"name":"identifier","containerName":"mark_uninstantiated","kind":12,"line":184},{"containerName":"mark_uninstantiated","name":"$self","kind":13,"line":185},{"containerName":"mark_uninstantiated","name":"_instantiated_terms_store","line":185,"kind":12},{"containerName":"mark_uninstantiated","name":"$term","line":185,"kind":13},{"name":"identifier","containerName":"mark_uninstantiated","line":185,"kind":12},{"containerName":"mark_uninstantiated","name":"$self","line":186,"kind":13},{"name":"_instantiated_terms_store","containerName":"mark_uninstantiated","line":186,"kind":12},{"line":186,"kind":13,"containerName":"mark_uninstantiated","name":"$term"},{"kind":12,"line":186,"name":"identifier","containerName":"mark_uninstantiated"},{"containerName":"mark_uninstantiated","name":"@terms","line":189,"kind":13}],"kind":12},{"range":{"end":{"character":9999,"line":216},"start":{"character":0,"line":203}},"name":"_term_store","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects","label":"_term_store($self,$value)"},"containerName":"main::","definition":"sub","line":203,"children":[{"line":204,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_term_store"},{"name":"$value","containerName":"_term_store","kind":13,"line":204},{"kind":13,"line":206,"name":"$value","containerName":"_term_store"},{"name":"$self","containerName":"_term_store","kind":13,"line":207},{"name":"$self","containerName":"_term_store","kind":13,"line":208},{"containerName":"_term_store","name":"throw","line":208,"kind":12},{"name":"$self","containerName":"_term_store","line":211,"kind":13},{"containerName":"_term_store","name":"$value","line":211,"kind":13},{"line":215,"kind":13,"name":"$self","containerName":"_term_store"}],"kind":12},{"name":"add_term","range":{"end":{"line":243,"character":9999},"start":{"character":0,"line":230}},"kind":12,"line":230,"children":[{"line":231,"kind":13,"localvar":"my","containerName":"add_term","name":"$self","definition":"my"},{"containerName":"add_term","name":"$term","kind":13,"line":231},{"definition":"my","name":"$term_store","containerName":"add_term","localvar":"my","kind":13,"line":232},{"line":232,"kind":13,"containerName":"add_term","name":"$self"},{"line":232,"kind":12,"name":"_term_store","containerName":"add_term"},{"name":"$term_store","containerName":"add_term","line":234,"kind":13},{"containerName":"add_term","name":"$term","kind":13,"line":234},{"line":234,"kind":12,"containerName":"add_term","name":"identifier"},{"kind":13,"line":235,"name":"$self","containerName":"add_term"},{"name":"throw","containerName":"add_term","line":235,"kind":12},{"line":235,"kind":13,"name":"$term","containerName":"add_term"},{"line":235,"kind":12,"name":"identifier","containerName":"add_term"},{"containerName":"add_term","name":"$term_store","line":238,"kind":13},{"line":238,"kind":13,"containerName":"add_term","name":"$term"},{"kind":12,"line":238,"containerName":"add_term","name":"identifier"},{"containerName":"add_term","name":"$term","line":238,"kind":13},{"kind":13,"line":239,"name":"$self","containerName":"add_term"},{"line":239,"kind":12,"name":"_instantiated_terms_store","containerName":"add_term"},{"kind":13,"line":239,"containerName":"add_term","name":"$term"},{"containerName":"add_term","name":"identifier","kind":12,"line":239},{"line":242,"kind":13,"containerName":"add_term","name":"$term"}],"containerName":"main::","definition":"sub","detail":"($self,$term)","signature":{"label":"add_term($self,$term)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.","parameters":[{"label":"$self"},{"label":"$term"}]}},{"detail":"($self,@ids)","signature":{"label":"get_term_by_identifier($self,@ids)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings","parameters":[{"label":"$self"},{"label":"@ids"}]},"containerName":"main::","definition":"sub","line":257,"children":[{"line":258,"kind":13,"localvar":"my","containerName":"get_term_by_identifier","definition":"my","name":"$self"},{"line":258,"kind":13,"name":"@ids","containerName":"get_term_by_identifier"},{"definition":"my","name":"@ans","containerName":"get_term_by_identifier","localvar":"my","kind":13,"line":259},{"localvar":"my","containerName":"get_term_by_identifier","name":"$id","definition":"my","line":261,"kind":13},{"name":"@ids","containerName":"get_term_by_identifier","kind":13,"line":261},{"definition":"my","name":"$term","containerName":"get_term_by_identifier","localvar":"my","kind":13,"line":262},{"containerName":"get_term_by_identifier","name":"$self","kind":13,"line":262},{"name":"_term_store","containerName":"get_term_by_identifier","kind":12,"line":262},{"kind":13,"line":262,"name":"$id","containerName":"get_term_by_identifier"},{"line":263,"kind":13,"name":"@ans","containerName":"get_term_by_identifier"},{"line":263,"kind":13,"containerName":"get_term_by_identifier","name":"$term"},{"containerName":"get_term_by_identifier","name":"$term","kind":13,"line":263},{"line":266,"kind":13,"containerName":"get_term_by_identifier","name":"@ans"}],"kind":12,"range":{"end":{"character":9999,"line":267},"start":{"line":257,"character":0}},"name":"get_term_by_identifier"},{"children":[{"line":281,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_get_number_rels"},{"kind":13,"line":282,"definition":"my","name":"$num_rels","containerName":"_get_number_rels","localvar":"my"},{"definition":"my","name":"$entry","containerName":"_get_number_rels","localvar":"my","kind":13,"line":284},{"kind":13,"line":284,"name":"$self","containerName":"_get_number_rels"},{"containerName":"_get_number_rels","name":"_relationship_store","line":284,"kind":12},{"kind":13,"line":285,"containerName":"_get_number_rels","name":"$num_rels"},{"name":"$entry","containerName":"_get_number_rels","line":285,"kind":13},{"name":"$num_rels","containerName":"_get_number_rels","line":287,"kind":13}],"line":280,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","label":"_get_number_rels($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":288},"start":{"character":0,"line":280}},"name":"_get_number_rels"},{"name":"_get_number_terms","range":{"start":{"line":301,"character":0},"end":{"line":304,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"_get_number_terms($self)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"}]},"kind":12,"line":301,"children":[{"name":"$self","definition":"my","containerName":"_get_number_terms","localvar":"my","kind":13,"line":302},{"containerName":"_get_number_terms","name":"$self","line":304,"kind":13},{"name":"_filter_unmarked","containerName":"_get_number_terms","line":304,"kind":12},{"name":"$self","containerName":"_get_number_terms","kind":13,"line":304},{"line":304,"kind":12,"name":"_term_store","containerName":"_get_number_terms"}]},{"range":{"end":{"character":9999,"line":332},"start":{"character":0,"line":319}},"name":"_relationship_store","line":319,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_relationship_store","line":320,"kind":13},{"name":"$value","containerName":"_relationship_store","kind":13,"line":320},{"line":322,"kind":13,"containerName":"_relationship_store","name":"$value"},{"name":"$self","containerName":"_relationship_store","kind":13,"line":323},{"containerName":"_relationship_store","name":"$self","line":324,"kind":13},{"containerName":"_relationship_store","name":"throw","line":324,"kind":12},{"line":327,"kind":13,"containerName":"_relationship_store","name":"$self"},{"line":327,"kind":13,"name":"$value","containerName":"_relationship_store"},{"containerName":"_relationship_store","name":"$self","kind":13,"line":331}],"kind":12,"detail":"($self,$value)","signature":{"label":"_relationship_store($self,$value)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub"},{"detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects","label":"_inverted_relationship_store($self,$value)"},"containerName":"main::","definition":"sub","line":345,"children":[{"localvar":"my","containerName":"_inverted_relationship_store","definition":"my","name":"$self","line":346,"kind":13},{"containerName":"_inverted_relationship_store","name":"$value","kind":13,"line":346},{"name":"$value","containerName":"_inverted_relationship_store","kind":13,"line":348},{"containerName":"_inverted_relationship_store","name":"$self","line":349,"kind":13},{"name":"$self","containerName":"_inverted_relationship_store","kind":13,"line":350},{"name":"throw","containerName":"_inverted_relationship_store","line":350,"kind":12},{"containerName":"_inverted_relationship_store","name":"$self","line":353,"kind":13},{"line":353,"kind":13,"containerName":"_inverted_relationship_store","name":"$value"},{"name":"$self","containerName":"_inverted_relationship_store","kind":13,"line":357}],"kind":12,"range":{"start":{"character":0,"line":345},"end":{"character":9999,"line":358}},"name":"_inverted_relationship_store"},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects","parameters":[{"label":"$self"},{"label":"$value"}],"label":"_relationship_type_store($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"localvar":"my","containerName":"_relationship_type_store","name":"$self","definition":"my","line":372,"kind":13},{"containerName":"_relationship_type_store","name":"$value","line":372,"kind":13},{"name":"$value","containerName":"_relationship_type_store","line":374,"kind":13},{"containerName":"_relationship_type_store","name":"$self","line":375,"kind":13},{"line":376,"kind":13,"name":"$self","containerName":"_relationship_type_store"},{"name":"throw","containerName":"_relationship_type_store","line":376,"kind":12},{"name":"$self","containerName":"_relationship_type_store","line":379,"kind":13},{"kind":13,"line":379,"containerName":"_relationship_type_store","name":"$value"},{"line":383,"kind":13,"containerName":"_relationship_type_store","name":"$self"}],"line":371,"name":"_relationship_type_store","range":{"start":{"character":0,"line":371},"end":{"line":384,"character":9999}}},{"name":"_add_relationship_simple","range":{"start":{"character":0,"line":397},"end":{"line":420,"character":9999}},"kind":12,"line":397,"children":[{"kind":13,"line":398,"name":"$self","definition":"my","containerName":"_add_relationship_simple","localvar":"my"},{"line":398,"kind":13,"containerName":"_add_relationship_simple","name":"$store"},{"name":"$rel","containerName":"_add_relationship_simple","kind":13,"line":398},{"line":398,"kind":13,"containerName":"_add_relationship_simple","name":"$inverted"},{"line":399,"kind":13,"localvar":"my","definition":"my","name":"$parent_id","containerName":"_add_relationship_simple"},{"definition":"my","name":"$child_id","containerName":"_add_relationship_simple","localvar":"my","kind":13,"line":400},{"name":"$inverted","containerName":"_add_relationship_simple","kind":13,"line":402},{"kind":13,"line":403,"containerName":"_add_relationship_simple","name":"$parent_id"},{"name":"$rel","containerName":"_add_relationship_simple","line":403,"kind":13},{"line":403,"kind":12,"name":"subject_term","containerName":"_add_relationship_simple"},{"containerName":"_add_relationship_simple","name":"identifier","kind":12,"line":403},{"containerName":"_add_relationship_simple","name":"$child_id","kind":13,"line":404},{"containerName":"_add_relationship_simple","name":"$rel","line":404,"kind":13},{"name":"object_term","containerName":"_add_relationship_simple","kind":12,"line":404},{"name":"identifier","containerName":"_add_relationship_simple","kind":12,"line":404},{"name":"$parent_id","containerName":"_add_relationship_simple","kind":13,"line":407},{"line":407,"kind":13,"containerName":"_add_relationship_simple","name":"$rel"},{"kind":12,"line":407,"name":"object_term","containerName":"_add_relationship_simple"},{"kind":12,"line":407,"name":"identifier","containerName":"_add_relationship_simple"},{"line":408,"kind":13,"name":"$child_id","containerName":"_add_relationship_simple"},{"line":408,"kind":13,"containerName":"_add_relationship_simple","name":"$rel"},{"name":"subject_term","containerName":"_add_relationship_simple","line":408,"kind":12},{"line":408,"kind":12,"name":"identifier","containerName":"_add_relationship_simple"},{"line":410,"kind":13,"name":"$store","containerName":"_add_relationship_simple"},{"line":410,"kind":13,"name":"$parent_id","containerName":"_add_relationship_simple"},{"name":"$store","containerName":"_add_relationship_simple","kind":13,"line":410},{"kind":13,"line":410,"containerName":"_add_relationship_simple","name":"$parent_id"},{"kind":13,"line":410,"name":"$child_id","containerName":"_add_relationship_simple"},{"containerName":"_add_relationship_simple","name":"$store","line":411,"kind":13},{"kind":13,"line":411,"containerName":"_add_relationship_simple","name":"$parent_id"},{"line":411,"kind":13,"containerName":"_add_relationship_simple","name":"$child_id"},{"line":411,"kind":12,"name":"name","containerName":"_add_relationship_simple"},{"line":411,"kind":13,"containerName":"_add_relationship_simple","name":"$rel"},{"name":"predicate_term","containerName":"_add_relationship_simple","line":411,"kind":12},{"line":411,"kind":12,"containerName":"_add_relationship_simple","name":"name"},{"line":412,"kind":13,"containerName":"_add_relationship_simple","name":"$self"},{"name":"throw","containerName":"_add_relationship_simple","line":412,"kind":12},{"name":"$rel","containerName":"_add_relationship_simple","line":412,"kind":13},{"name":"predicate_term","containerName":"_add_relationship_simple","line":412,"kind":12},{"name":"$parent_id","containerName":"_add_relationship_simple","kind":13,"line":413},{"line":413,"kind":13,"name":"$child_id","containerName":"_add_relationship_simple"},{"name":"$store","containerName":"_add_relationship_simple","kind":13,"line":415},{"kind":13,"line":415,"name":"$parent_id","containerName":"_add_relationship_simple"},{"kind":13,"line":415,"name":"$child_id","containerName":"_add_relationship_simple"},{"kind":13,"line":418,"name":"$store","containerName":"_add_relationship_simple"},{"line":418,"kind":13,"name":"$parent_id","containerName":"_add_relationship_simple"},{"containerName":"_add_relationship_simple","name":"$child_id","kind":13,"line":418},{"containerName":"_add_relationship_simple","name":"$rel","kind":13,"line":418},{"kind":12,"line":418,"containerName":"_add_relationship_simple","name":"predicate_term"}],"containerName":"main::","definition":"sub","detail":"($self,$store,$rel,$inverted)","signature":{"label":"_add_relationship_simple($self,$store,$rel,$inverted)","parameters":[{"label":"$self"},{"label":"$store"},{"label":"$rel"},{"label":"$inverted"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :"}},{"kind":12,"line":412,"name":"Dumper"},{"line":415,"kind":12,"name":"Dumper"},{"name":"add_relationship","range":{"start":{"character":0,"line":433},"end":{"character":9999,"line":444}},"kind":12,"line":433,"children":[{"kind":13,"line":434,"name":"$self","definition":"my","containerName":"add_relationship","localvar":"my"},{"kind":13,"line":434,"name":"$rel","containerName":"add_relationship"},{"line":436,"kind":13,"containerName":"add_relationship","name":"$self"},{"name":"_add_relationship_simple","containerName":"add_relationship","line":436,"kind":12},{"containerName":"add_relationship","name":"$self","line":436,"kind":13},{"kind":12,"line":436,"containerName":"add_relationship","name":"_relationship_store"},{"containerName":"add_relationship","name":"$rel","kind":13,"line":437},{"containerName":"add_relationship","name":"$self","kind":13,"line":438},{"line":438,"kind":12,"name":"_add_relationship_simple","containerName":"add_relationship"},{"containerName":"add_relationship","name":"$self","kind":13,"line":438},{"containerName":"add_relationship","name":"_inverted_relationship_store","kind":12,"line":438},{"containerName":"add_relationship","name":"$rel","line":439,"kind":13},{"kind":13,"line":440,"containerName":"add_relationship","name":"$self"},{"name":"_relationship_type_store","containerName":"add_relationship","kind":12,"line":440},{"kind":13,"line":441,"containerName":"add_relationship","name":"$self"},{"kind":12,"line":441,"containerName":"add_relationship","name":"_unique_termid"},{"containerName":"add_relationship","name":"$rel","kind":13,"line":441},{"line":441,"kind":12,"name":"predicate_term","containerName":"add_relationship"},{"name":"$rel","containerName":"add_relationship","line":441,"kind":13},{"line":441,"kind":12,"name":"predicate_term","containerName":"add_relationship"},{"containerName":"add_relationship","name":"$rel","line":443,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$rel)","signature":{"parameters":[{"label":"$self"},{"label":"$rel"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.","label":"add_relationship($self,$rel)"}},{"name":"get_relationships","definition":"sub","containerName":"main::","range":{"start":{"line":457,"character":0},"end":{"character":9999,"line":468}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"get_relationships","localvar":"my","kind":13,"line":458},{"containerName":"get_relationships","name":"$term","definition":"my","localvar":"my","kind":13,"line":459},{"definition":"my","name":"@rels","containerName":"get_relationships","localvar":"my","kind":13,"line":460},{"name":"$store","definition":"my","containerName":"get_relationships","localvar":"my","kind":13,"line":461},{"containerName":"get_relationships","name":"$self","line":461,"kind":13},{"line":461,"kind":12,"containerName":"get_relationships","name":"_relationship_store"},{"localvar":"my","definition":"my","name":"$relfact","containerName":"get_relationships","line":462,"kind":13},{"containerName":"get_relationships","name":"$self","line":462,"kind":13},{"line":462,"kind":12,"name":"relationship_factory","containerName":"get_relationships"},{"name":"@parent_ids","definition":"my","containerName":"get_relationships","localvar":"my","kind":13,"line":464},{"line":464,"kind":13,"name":"$term","containerName":"get_relationships"},{"kind":12,"line":466,"containerName":"get_relationships","name":"identifier"},{"line":466,"kind":13,"containerName":"get_relationships","name":"$self"},{"containerName":"get_relationships","name":"get_parent_terms","kind":12,"line":466},{"containerName":"get_relationships","name":"$term","kind":13,"line":466},{"kind":13,"line":468,"containerName":"get_relationships","name":"$store"}],"line":457},{"line":470,"kind":13,"containerName":null,"name":"@parent_ids"},{"line":470,"kind":13,"containerName":null,"name":"$term"},{"line":470,"kind":12,"containerName":"main::","name":"identifier"},{"kind":13,"line":470,"containerName":null,"name":"$term"},{"line":472,"kind":13,"localvar":"my","containerName":null,"name":"$parent_id","definition":"my"},{"name":"@parent_ids","containerName":null,"kind":13,"line":472},{"name":"$parent_entry","definition":"my","containerName":null,"localvar":"my","kind":13,"line":473},{"kind":13,"line":473,"name":"%store","containerName":null},{"name":"$parent_id","containerName":null,"line":473,"kind":13},{"kind":13,"line":477,"name":"$term","containerName":null},{"containerName":null,"name":"$parent_id","kind":13,"line":477},{"containerName":null,"name":"$term","line":477,"kind":13},{"line":477,"kind":12,"containerName":"main::","name":"identifier"},{"line":478,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@parent_terms"},{"kind":13,"line":478,"containerName":null,"name":"$self"},{"name":"get_term_by_identifier","containerName":"main::","kind":12,"line":478},{"containerName":null,"name":"$parent_id","kind":13,"line":478},{"line":479,"kind":13,"localvar":"my","definition":"my","name":"$parent_term","containerName":null},{"line":479,"kind":13,"containerName":null,"name":"@parent_terms"},{"containerName":null,"name":"@rels","line":480,"kind":13},{"line":481,"kind":13,"name":"$relfact","containerName":null},{"containerName":"main::","name":"create_object","kind":12,"line":481},{"line":481,"kind":13,"name":"$parent_term","containerName":null},{"name":"$term","containerName":null,"kind":13,"line":482},{"containerName":null,"name":"%parent_entry","kind":13,"line":484},{"containerName":null,"name":"$term","kind":13,"line":484},{"line":484,"kind":12,"containerName":"main::","name":"identifier"},{"containerName":null,"name":"$term","kind":13,"line":485},{"kind":12,"line":485,"name":"ontology","containerName":"main::"},{"name":"@parent_terms","definition":"my","containerName":null,"localvar":"my","kind":13,"line":492},{"containerName":null,"name":"$term","kind":13,"line":492},{"kind":13,"line":493,"name":"$term","containerName":null},{"kind":13,"line":493,"containerName":null,"name":"$self"},{"kind":12,"line":493,"name":"get_term_by_identifier","containerName":"main::"},{"kind":13,"line":493,"name":"$parent_id","containerName":null},{"kind":13,"line":494,"containerName":null,"definition":"my","name":"$child_id","localvar":"my"},{"kind":13,"line":494,"name":"%parent_entry","containerName":null},{"localvar":"my","containerName":null,"name":"$rel_info","definition":"my","line":495,"kind":13},{"kind":13,"line":495,"name":"%parent_entry","containerName":null},{"containerName":null,"name":"$child_id","line":495,"kind":13},{"kind":13,"line":496,"definition":"my","name":"$subj_term","containerName":null,"localvar":"my"},{"kind":13,"line":496,"containerName":null,"name":"$self"},{"kind":12,"line":496,"name":"get_term_by_identifier","containerName":"main::"},{"name":"$child_id","containerName":null,"kind":13,"line":496},{"containerName":null,"definition":"my","name":"$parent_term","localvar":"my","kind":13,"line":498},{"containerName":null,"name":"@parent_terms","line":498,"kind":13},{"line":499,"kind":13,"name":"@rels","containerName":null},{"kind":13,"line":500,"containerName":null,"name":"$relfact"},{"line":500,"kind":12,"containerName":"main::","name":"create_object"},{"name":"$parent_term","containerName":null,"line":500,"kind":13},{"line":501,"kind":13,"containerName":null,"name":"$subj_term"},{"line":502,"kind":13,"name":"$rel_info","containerName":null},{"name":"$parent_term","containerName":null,"line":503,"kind":13},{"containerName":"main::","name":"ontology","line":504,"kind":12},{"kind":13,"line":511,"name":"@rels","containerName":null},{"line":525,"children":[{"line":526,"kind":12,"containerName":"get_all_relationships","name":"get_relationships"}],"kind":12,"range":{"end":{"line":527,"character":9999},"start":{"character":0,"line":525}},"containerName":"main::","name":"get_all_relationships","definition":"sub"},{"range":{"end":{"character":9999,"line":543},"start":{"line":540,"character":0}},"name":"get_predicate_terms","signature":{"label":"get_predicate_terms($self)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"get_predicate_terms","localvar":"my","kind":13,"line":541},{"name":"$self","containerName":"get_predicate_terms","kind":13,"line":543},{"kind":12,"line":543,"name":"_relationship_type_store","containerName":"get_predicate_terms"}],"line":540,"kind":12},{"name":"_is_rel_type","range":{"start":{"line":557,"character":0},"end":{"character":9999,"line":569}},"containerName":"main::","definition":"sub","detail":"($self,$term,@rel_types)","signature":{"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"$term"},{"label":"@rel_types"}],"label":"_is_rel_type($self,$term,@rel_types)"},"kind":12,"line":557,"children":[{"containerName":"_is_rel_type","name":"$self","definition":"my","localvar":"my","kind":13,"line":558},{"line":558,"kind":13,"name":"$term","containerName":"_is_rel_type"},{"containerName":"_is_rel_type","name":"@rel_types","kind":13,"line":558},{"containerName":"_is_rel_type","name":"$rel_type","definition":"my","localvar":"my","kind":13,"line":560},{"kind":13,"line":560,"name":"@rel_types","containerName":"_is_rel_type"},{"containerName":"_is_rel_type","name":"$rel_type","kind":13,"line":561},{"kind":12,"line":561,"name":"identifier","containerName":"_is_rel_type"},{"line":561,"kind":13,"name":"$term","containerName":"_is_rel_type"},{"line":561,"kind":12,"name":"identifier","containerName":"_is_rel_type"},{"kind":13,"line":562,"name":"$rel_type","containerName":"_is_rel_type"},{"kind":12,"line":562,"name":"identifier","containerName":"_is_rel_type"},{"line":562,"kind":13,"name":"$term","containerName":"_is_rel_type"},{"line":562,"kind":12,"name":"identifier","containerName":"_is_rel_type"},{"containerName":"_is_rel_type","name":"$rel_type","line":564,"kind":13},{"containerName":"_is_rel_type","name":"name","line":564,"kind":12},{"kind":13,"line":564,"containerName":"_is_rel_type","name":"$term"},{"name":"name","containerName":"_is_rel_type","kind":12,"line":564}]},{"kind":12,"line":582,"children":[{"kind":13,"line":583,"definition":"my","name":"$self","containerName":"_typed_traversal","localvar":"my"},{"name":"$rel_store","containerName":"_typed_traversal","kind":13,"line":583},{"kind":13,"line":583,"containerName":"_typed_traversal","name":"$level"},{"line":583,"kind":13,"name":"$term_id","containerName":"_typed_traversal"},{"kind":13,"line":583,"name":"@rel_types","containerName":"_typed_traversal"},{"line":584,"kind":13,"name":"$rel_store","containerName":"_typed_traversal"},{"containerName":"_typed_traversal","name":"$term_id","kind":13,"line":584},{"localvar":"my","containerName":"_typed_traversal","name":"%parent_entry","definition":"my","line":585,"kind":13},{"kind":13,"line":585,"name":"$rel_store","containerName":"_typed_traversal"},{"name":"$term_id","containerName":"_typed_traversal","line":585,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$rel_store,$level,$term_id,@rel_types)","signature":{"label":"_typed_traversal($self,$rel_store,$level,$term_id,@rel_types)","parameters":[{"label":"$self"},{"label":"$rel_store"},{"label":"$level"},{"label":"$term_id"},{"label":"@rel_types"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :"},"name":"_typed_traversal","range":{"end":{"character":9999,"line":585},"start":{"line":582,"character":0}}},{"line":586,"kind":13,"localvar":"my","containerName":null,"name":"@children","definition":"my"},{"line":586,"kind":13,"containerName":null,"name":"%parent_entry"},{"line":588,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@ans"},{"line":590,"kind":13,"containerName":null,"name":"@rel_types"},{"kind":13,"line":591,"name":"@ans","containerName":null},{"line":593,"kind":13,"localvar":"my","containerName":null,"name":"$child_id","definition":"my"},{"kind":13,"line":593,"name":"@children","containerName":null},{"containerName":null,"name":"@ans","line":594,"kind":13},{"line":595,"kind":13,"containerName":null,"name":"$child_id"},{"line":595,"kind":13,"containerName":null,"name":"$self"},{"name":"_is_rel_type","containerName":"main::","kind":12,"line":595},{"containerName":null,"name":"%rel_store","kind":13,"line":595},{"kind":13,"line":595,"name":"%term_id","containerName":null},{"line":595,"kind":13,"containerName":null,"name":"$child_id"},{"line":596,"kind":13,"name":"@rel_types","containerName":null},{"containerName":null,"name":"@ans","kind":13,"line":600},{"name":"@children","containerName":null,"line":600,"kind":13},{"containerName":null,"name":"%level","kind":13,"line":602},{"localvar":"my","name":"@ans1","definition":"my","containerName":null,"line":603,"kind":13},{"name":"$child_id","definition":"my","containerName":null,"localvar":"my","kind":13,"line":605},{"kind":13,"line":605,"containerName":null,"name":"@ans"},{"name":"@ans1","containerName":null,"line":606,"kind":13},{"name":"$self","containerName":null,"line":606,"kind":13},{"name":"_typed_traversal","containerName":"main::","kind":12,"line":606},{"line":606,"kind":13,"name":"$rel_store","containerName":null},{"name":"$level","containerName":null,"kind":13,"line":607},{"name":"$child_id","containerName":null,"line":607,"kind":13},{"kind":13,"line":607,"name":"@rel_types","containerName":null},{"kind":13,"line":608,"name":"%rel_store","containerName":null},{"line":608,"kind":13,"name":"$child_id","containerName":null},{"containerName":null,"name":"@ans","line":610,"kind":13},{"kind":13,"line":610,"containerName":null,"name":"@ans1"},{"name":"@ans","containerName":null,"kind":13,"line":613},{"name":"get_child_terms","range":{"start":{"line":633,"character":0},"end":{"character":9999,"line":645}},"containerName":"main::","definition":"sub","detail":"($self,$term,@relationship_types)","signature":{"parameters":[{"label":"$self"},{"label":"$term"},{"label":"@relationship_types"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.","label":"get_child_terms($self,$term,@relationship_types)"},"kind":12,"line":633,"children":[{"name":"$self","definition":"my","containerName":"get_child_terms","localvar":"my","kind":13,"line":634},{"containerName":"get_child_terms","name":"$term","kind":13,"line":634},{"containerName":"get_child_terms","name":"@relationship_types","line":634,"kind":13},{"name":"$self","containerName":"get_child_terms","kind":13,"line":636},{"line":636,"kind":12,"containerName":"get_child_terms","name":"throw"},{"containerName":"get_child_terms","name":"$term","line":637,"kind":13},{"containerName":"get_child_terms","name":"$term","kind":13,"line":637},{"kind":12,"line":637,"containerName":"get_child_terms","name":"isa"},{"line":639,"kind":13,"containerName":"get_child_terms","name":"$self"},{"kind":12,"line":639,"containerName":"get_child_terms","name":"_filter_unmarked"},{"line":640,"kind":13,"containerName":"get_child_terms","name":"$self"},{"name":"get_term_by_identifier","containerName":"get_child_terms","line":640,"kind":12},{"name":"$self","containerName":"get_child_terms","kind":13,"line":641},{"kind":12,"line":641,"containerName":"get_child_terms","name":"_typed_traversal"},{"name":"$self","containerName":"get_child_terms","line":641,"kind":13},{"kind":12,"line":641,"name":"_relationship_store","containerName":"get_child_terms"},{"containerName":"get_child_terms","name":"$term","line":643,"kind":13},{"containerName":"get_child_terms","name":"identifier","line":643,"kind":12},{"name":"@relationship_types","containerName":"get_child_terms","kind":13,"line":644}]},{"name":"get_descendant_terms","range":{"start":{"character":0,"line":664},"end":{"character":9999,"line":677}},"definition":"sub","containerName":"main::","signature":{"label":"get_descendant_terms($self,$term,@relationship_types)","parameters":[{"label":"$self"},{"label":"$term"},{"label":"@relationship_types"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms."},"detail":"($self,$term,@relationship_types)","kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"get_descendant_terms","line":665,"kind":13},{"kind":13,"line":665,"name":"$term","containerName":"get_descendant_terms"},{"line":665,"kind":13,"name":"@relationship_types","containerName":"get_descendant_terms"},{"containerName":"get_descendant_terms","name":"$self","line":667,"kind":13},{"name":"throw","containerName":"get_descendant_terms","kind":12,"line":667},{"containerName":"get_descendant_terms","name":"$term","kind":13,"line":668},{"containerName":"get_descendant_terms","name":"$term","line":668,"kind":13},{"name":"isa","containerName":"get_descendant_terms","line":668,"kind":12},{"line":670,"kind":13,"containerName":"get_descendant_terms","name":"$self"},{"name":"_filter_unmarked","containerName":"get_descendant_terms","line":670,"kind":12},{"kind":13,"line":671,"containerName":"get_descendant_terms","name":"$self"},{"name":"_filter_repeated","containerName":"get_descendant_terms","kind":12,"line":671},{"kind":13,"line":672,"name":"$self","containerName":"get_descendant_terms"},{"containerName":"get_descendant_terms","name":"get_term_by_identifier","kind":12,"line":672},{"name":"$self","containerName":"get_descendant_terms","line":673,"kind":13},{"kind":12,"line":673,"containerName":"get_descendant_terms","name":"_typed_traversal"},{"kind":13,"line":673,"containerName":"get_descendant_terms","name":"$self"},{"line":673,"kind":12,"name":"_relationship_store","containerName":"get_descendant_terms"},{"name":"$term","containerName":"get_descendant_terms","line":675,"kind":13},{"containerName":"get_descendant_terms","name":"identifier","line":675,"kind":12},{"name":"@relationship_types","containerName":"get_descendant_terms","kind":13,"line":676}],"line":664},{"detail":"($self,$term,@relationship_types)","signature":{"label":"get_parent_terms($self,$term,@relationship_types)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.","parameters":[{"label":"$self"},{"label":"$term"},{"label":"@relationship_types"}]},"containerName":"main::","definition":"sub","line":696,"children":[{"kind":13,"line":697,"name":"$self","definition":"my","containerName":"get_parent_terms","localvar":"my"},{"kind":13,"line":697,"name":"$term","containerName":"get_parent_terms"},{"name":"@relationship_types","containerName":"get_parent_terms","kind":13,"line":697},{"name":"$self","containerName":"get_parent_terms","kind":13,"line":698},{"line":698,"kind":12,"name":"throw","containerName":"get_parent_terms"},{"kind":13,"line":698,"containerName":"get_parent_terms","name":"$term"},{"containerName":"get_parent_terms","name":"$self","kind":13,"line":700},{"containerName":"get_parent_terms","name":"_filter_unmarked","kind":12,"line":700},{"name":"$self","containerName":"get_parent_terms","line":701,"kind":13},{"name":"get_term_by_identifier","containerName":"get_parent_terms","line":701,"kind":12},{"containerName":"get_parent_terms","name":"$self","line":702,"kind":13},{"name":"_typed_traversal","containerName":"get_parent_terms","kind":12,"line":702},{"name":"$self","containerName":"get_parent_terms","kind":13,"line":702},{"line":702,"kind":12,"name":"_inverted_relationship_store","containerName":"get_parent_terms"},{"kind":13,"line":704,"containerName":"get_parent_terms","name":"$term"},{"name":"identifier","containerName":"get_parent_terms","line":704,"kind":12},{"name":"@relationship_types","containerName":"get_parent_terms","line":705,"kind":13}],"kind":12,"range":{"end":{"character":9999,"line":706},"start":{"line":696,"character":0}},"name":"get_parent_terms"},{"range":{"end":{"line":736,"character":9999},"start":{"line":725,"character":0}},"name":"get_ancestor_terms","line":725,"children":[{"containerName":"get_ancestor_terms","name":"$self","definition":"my","localvar":"my","kind":13,"line":726},{"kind":13,"line":726,"name":"$term","containerName":"get_ancestor_terms"},{"name":"@relationship_types","containerName":"get_ancestor_terms","kind":13,"line":726},{"line":727,"kind":13,"name":"$self","containerName":"get_ancestor_terms"},{"kind":12,"line":727,"containerName":"get_ancestor_terms","name":"throw"},{"containerName":"get_ancestor_terms","name":"$term","kind":13,"line":727},{"name":"$self","containerName":"get_ancestor_terms","line":729,"kind":13},{"name":"_filter_unmarked","containerName":"get_ancestor_terms","kind":12,"line":729},{"containerName":"get_ancestor_terms","name":"$self","line":730,"kind":13},{"name":"_filter_repeated","containerName":"get_ancestor_terms","kind":12,"line":730},{"line":731,"kind":13,"containerName":"get_ancestor_terms","name":"$self"},{"kind":12,"line":731,"containerName":"get_ancestor_terms","name":"get_term_by_identifier"},{"kind":13,"line":732,"containerName":"get_ancestor_terms","name":"$self"},{"line":732,"kind":12,"name":"_typed_traversal","containerName":"get_ancestor_terms"},{"kind":13,"line":732,"name":"$self","containerName":"get_ancestor_terms"},{"line":732,"kind":12,"containerName":"get_ancestor_terms","name":"_inverted_relationship_store"},{"containerName":"get_ancestor_terms","name":"$term","line":734,"kind":13},{"name":"identifier","containerName":"get_ancestor_terms","kind":12,"line":734},{"kind":13,"line":735,"name":"@relationship_types","containerName":"get_ancestor_terms"}],"kind":12,"detail":"($self,$term,@relationship_types)","signature":{"label":"get_ancestor_terms($self,$term,@relationship_types)","parameters":[{"label":"$self"},{"label":"$term"},{"label":"@relationship_types"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms."},"containerName":"main::","definition":"sub"},{"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_leaf_terms","line":750,"kind":13},{"name":"@leaf_terms","definition":"my","containerName":"get_leaf_terms","localvar":"my","kind":13,"line":751},{"line":753,"kind":13,"localvar":"my","containerName":"get_leaf_terms","definition":"my","name":"$term"},{"line":753,"kind":13,"name":"$self","containerName":"get_leaf_terms"},{"containerName":"get_leaf_terms","name":"_term_store","line":753,"kind":12}],"line":749,"definition":"sub","containerName":"main::","signature":{"label":"get_leaf_terms($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms.\n\n\nsub get_ancestor_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->_filter_repeated(\n               $self->get_term_by_identifier(\n                  $self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t  0,\n\t\t\t\t\t  $term->identifier,\n\t\t\t\t\t  @relationship_types) ) ) );\n}\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : get_leaf_terms(): TermI\n Function: Retrieves all leaf terms from the ontology. Leaf term is a term w/o descendants.\n Example : @leaf_terms = $obj->get_leaf_terms()\n Returns : Array of TermI objects.\n Args    :"},"detail":"($self)","name":"get_leaf_terms","range":{"end":{"line":753,"character":9999},"start":{"line":749,"character":0}}},{"kind":13,"line":754,"containerName":null,"name":"@leaf_terms"},{"line":755,"kind":13,"name":"$term","containerName":null},{"name":"$self","containerName":null,"kind":13,"line":755},{"containerName":"main::","name":"_relationship_store","kind":12,"line":755},{"name":"$term","containerName":null,"kind":13,"line":755},{"containerName":"main::","name":"identifier","line":755,"kind":12},{"line":756,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":756,"containerName":"main::","name":"_instantiated_terms_store"},{"kind":13,"line":756,"name":"$term","containerName":null},{"line":756,"kind":12,"containerName":"main::","name":"identifier"},{"kind":13,"line":759,"name":"@leaf_terms","containerName":null},{"kind":12,"line":773,"children":[{"containerName":"get_root_terms","name":"$self","definition":"my","localvar":"my","kind":13,"line":774},{"containerName":"get_root_terms","definition":"my","name":"@root_terms","localvar":"my","kind":13,"line":775},{"localvar":"my","containerName":"get_root_terms","definition":"my","name":"$term","line":777,"kind":13},{"containerName":"get_root_terms","name":"$self","line":777,"kind":13},{"name":"_term_store","containerName":"get_root_terms","line":777,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms.\n\n\nsub get_ancestor_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->_filter_repeated(\n               $self->get_term_by_identifier(\n                  $self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t  0,\n\t\t\t\t\t  $term->identifier,\n\t\t\t\t\t  @relationship_types) ) ) );\n}\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : get_leaf_terms(): TermI\n Function: Retrieves all leaf terms from the ontology. Leaf term is a term w/o descendants.\n Example : @leaf_terms = $obj->get_leaf_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_leaf_terms{\n  my ($self) = @_;\n  my @leaf_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n\t  push @leaf_terms, $term\n\t\t if !defined $self->_relationship_store->{$term->identifier} &&\n\t\t\tdefined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @leaf_terms;\n}\n\n=head2 get_root_terms\n\n Title   : get_root_terms\n Usage   : get_root_terms(): TermI\n Function: Retrieves all root terms from the ontology. Root term is a term w/o descendants.\n Example : @root_terms = $obj->get_root_terms()\n Returns : Array of TermI objects.\n Args    :","parameters":[{"label":"$self"}],"label":"get_root_terms($self)"},"name":"get_root_terms","range":{"end":{"line":777,"character":9999},"start":{"line":773,"character":0}}},{"name":"@root_terms","containerName":null,"line":778,"kind":13},{"name":"$term","containerName":null,"line":779,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":779},{"containerName":"main::","name":"_inverted_relationship_store","kind":12,"line":779},{"line":779,"kind":13,"name":"$term","containerName":null},{"line":779,"kind":12,"name":"identifier","containerName":"main::"},{"containerName":null,"name":"$self","kind":13,"line":780},{"name":"_instantiated_terms_store","containerName":"main::","kind":12,"line":780},{"containerName":null,"name":"$term","kind":13,"line":780},{"name":"identifier","containerName":"main::","kind":12,"line":780},{"containerName":null,"name":"@root_terms","kind":13,"line":783},{"range":{"start":{"line":797,"character":0},"end":{"line":806,"character":9999}},"name":"_filter_repeated","line":797,"children":[{"localvar":"my","containerName":"_filter_repeated","definition":"my","name":"$self","line":798,"kind":13},{"name":"@args","containerName":"_filter_repeated","kind":13,"line":798},{"name":"%h","definition":"my","containerName":"_filter_repeated","localvar":"my","kind":13,"line":799},{"containerName":"_filter_repeated","name":"$element","definition":"my","localvar":"my","kind":13,"line":801},{"line":801,"kind":13,"name":"@args","containerName":"_filter_repeated"},{"containerName":"_filter_repeated","name":"$h","kind":13,"line":802},{"name":"$element","containerName":"_filter_repeated","line":802,"kind":13},{"containerName":"_filter_repeated","name":"identifier","line":802,"kind":12},{"line":802,"kind":13,"name":"$element","containerName":"_filter_repeated"},{"containerName":"_filter_repeated","name":"$h","line":802,"kind":13},{"line":802,"kind":13,"name":"$element","containerName":"_filter_repeated"},{"kind":12,"line":802,"name":"identifier","containerName":"_filter_repeated"},{"kind":13,"line":805,"containerName":"_filter_repeated","name":"%h"}],"kind":12,"detail":"($self,@args)","signature":{"label":"_filter_repeated($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms.\n\n\nsub get_ancestor_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->_filter_repeated(\n               $self->get_term_by_identifier(\n                  $self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t  0,\n\t\t\t\t\t  $term->identifier,\n\t\t\t\t\t  @relationship_types) ) ) );\n}\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : get_leaf_terms(): TermI\n Function: Retrieves all leaf terms from the ontology. Leaf term is a term w/o descendants.\n Example : @leaf_terms = $obj->get_leaf_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_leaf_terms{\n  my ($self) = @_;\n  my @leaf_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n\t  push @leaf_terms, $term\n\t\t if !defined $self->_relationship_store->{$term->identifier} &&\n\t\t\tdefined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @leaf_terms;\n}\n\n=head2 get_root_terms\n\n Title   : get_root_terms\n Usage   : get_root_terms(): TermI\n Function: Retrieves all root terms from the ontology. Root term is a term w/o descendants.\n Example : @root_terms = $obj->get_root_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_root_terms{\n  my ($self) = @_;\n  my @root_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n    push @root_terms, $term\n      if !defined $self->_inverted_relationship_store->{$term->identifier} &&\n\t\t  defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @root_terms;\n}\n\n=head2 _filter_repeated\n\n Title   : _filter_repeated\n Usage   : @lst = $self->_filter_repeated(@old_lst);\n Function: Removes repeated terms\n Example :\n Returns : List of unique TermI objects\n Args    : List of TermI objects"},"containerName":"main::","definition":"sub"},{"name":"get_all_terms","range":{"end":{"line":822,"character":9999},"start":{"line":819,"character":0}},"kind":12,"line":819,"children":[{"line":820,"kind":13,"localvar":"my","containerName":"get_all_terms","name":"$self","definition":"my"},{"line":822,"kind":13,"containerName":"get_all_terms","name":"$self"},{"name":"_filter_unmarked","containerName":"get_all_terms","kind":12,"line":822},{"name":"$self","containerName":"get_all_terms","kind":13,"line":822},{"line":822,"kind":12,"name":"_term_store","containerName":"get_all_terms"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms.\n\n\nsub get_ancestor_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->_filter_repeated(\n               $self->get_term_by_identifier(\n                  $self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t  0,\n\t\t\t\t\t  $term->identifier,\n\t\t\t\t\t  @relationship_types) ) ) );\n}\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : get_leaf_terms(): TermI\n Function: Retrieves all leaf terms from the ontology. Leaf term is a term w/o descendants.\n Example : @leaf_terms = $obj->get_leaf_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_leaf_terms{\n  my ($self) = @_;\n  my @leaf_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n\t  push @leaf_terms, $term\n\t\t if !defined $self->_relationship_store->{$term->identifier} &&\n\t\t\tdefined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @leaf_terms;\n}\n\n=head2 get_root_terms\n\n Title   : get_root_terms\n Usage   : get_root_terms(): TermI\n Function: Retrieves all root terms from the ontology. Root term is a term w/o descendants.\n Example : @root_terms = $obj->get_root_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_root_terms{\n  my ($self) = @_;\n  my @root_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n    push @root_terms, $term\n      if !defined $self->_inverted_relationship_store->{$term->identifier} &&\n\t\t  defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @root_terms;\n}\n\n=head2 _filter_repeated\n\n Title   : _filter_repeated\n Usage   : @lst = $self->_filter_repeated(@old_lst);\n Function: Removes repeated terms\n Example :\n Returns : List of unique TermI objects\n Args    : List of TermI objects\n\n\nsub _filter_repeated{\n  my ($self, @args) = @_;\n  my %h;\n\n  foreach my $element (@args) {\n    $h{$element->identifier} = $element if !defined $h{$element->identifier};\n  }\n\n  return values %h;\n}\n\n=head2 get_all_terms\n\n Title   : get_all_terms\n Usage   : get_all_terms(): TermI\n Function: Retrieves all terms currently stored in the ontology.\n Example : @all_terms = $obj->get_all_terms()\n Returns : Array of TermI objects.\n Args    :","label":"get_all_terms($self)"}},{"range":{"end":{"character":9999,"line":859},"start":{"character":0,"line":844}},"name":"find_terms","detail":"($self,@args)","signature":{"label":"find_terms($self,@args)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms.\n\n\nsub get_ancestor_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->_filter_repeated(\n               $self->get_term_by_identifier(\n                  $self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t  0,\n\t\t\t\t\t  $term->identifier,\n\t\t\t\t\t  @relationship_types) ) ) );\n}\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : get_leaf_terms(): TermI\n Function: Retrieves all leaf terms from the ontology. Leaf term is a term w/o descendants.\n Example : @leaf_terms = $obj->get_leaf_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_leaf_terms{\n  my ($self) = @_;\n  my @leaf_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n\t  push @leaf_terms, $term\n\t\t if !defined $self->_relationship_store->{$term->identifier} &&\n\t\t\tdefined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @leaf_terms;\n}\n\n=head2 get_root_terms\n\n Title   : get_root_terms\n Usage   : get_root_terms(): TermI\n Function: Retrieves all root terms from the ontology. Root term is a term w/o descendants.\n Example : @root_terms = $obj->get_root_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_root_terms{\n  my ($self) = @_;\n  my @root_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n    push @root_terms, $term\n      if !defined $self->_inverted_relationship_store->{$term->identifier} &&\n\t\t  defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @root_terms;\n}\n\n=head2 _filter_repeated\n\n Title   : _filter_repeated\n Usage   : @lst = $self->_filter_repeated(@old_lst);\n Function: Removes repeated terms\n Example :\n Returns : List of unique TermI objects\n Args    : List of TermI objects\n\n\nsub _filter_repeated{\n  my ($self, @args) = @_;\n  my %h;\n\n  foreach my $element (@args) {\n    $h{$element->identifier} = $element if !defined $h{$element->identifier};\n  }\n\n  return values %h;\n}\n\n=head2 get_all_terms\n\n Title   : get_all_terms\n Usage   : get_all_terms(): TermI\n Function: Retrieves all terms currently stored in the ontology.\n Example : @all_terms = $obj->get_all_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_all_terms{\n  my ($self) = @_;\n\n  return $self->_filter_unmarked( values %{$self->_term_store} );\n}\n\n=head2 find_terms\n\n Title   : find_terms\n Usage   : ($term) = $oe->find_terms(-identifier => \"SO:0000263\");\n Function: Find term instances matching queries for their attributes.\n\n           This implementation can efficiently resolve queries by\n           identifier.\n\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : Named parameters. The following parameters should be recognized\n           by any implementations:\n\n              -identifier    query by the given identifier\n              -name          query by the given name","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","definition":"sub","line":844,"children":[{"name":"$self","definition":"my","containerName":"find_terms","localvar":"my","kind":13,"line":845},{"kind":13,"line":845,"containerName":"find_terms","name":"@args"},{"name":"@terms","definition":"my","containerName":"find_terms","localvar":"my","kind":13,"line":846},{"kind":13,"line":848,"definition":"my","name":"$id","containerName":"find_terms","localvar":"my"},{"line":848,"kind":13,"name":"$name","containerName":"find_terms"},{"kind":13,"line":848,"containerName":"find_terms","name":"$self"},{"containerName":"find_terms","name":"_rearrange","kind":12,"line":848},{"name":"@args","containerName":"find_terms","line":848,"kind":13},{"line":850,"kind":13,"name":"$id","containerName":"find_terms"},{"name":"@terms","containerName":"find_terms","line":851,"kind":13},{"kind":13,"line":851,"name":"$self","containerName":"find_terms"},{"name":"get_term_by_identifier","containerName":"find_terms","kind":12,"line":851},{"containerName":"find_terms","name":"$id","kind":13,"line":851},{"line":853,"kind":13,"name":"@terms","containerName":"find_terms"},{"name":"$self","containerName":"find_terms","line":853,"kind":13},{"containerName":"find_terms","name":"get_all_terms","kind":12,"line":853},{"line":855,"kind":13,"containerName":"find_terms","name":"$name"},{"kind":13,"line":856,"containerName":"find_terms","name":"@terms"},{"name":"name","containerName":"find_terms","kind":12,"line":856},{"containerName":"find_terms","name":"$name","kind":13,"line":856},{"containerName":"find_terms","name":"@terms","kind":13,"line":856},{"containerName":"find_terms","name":"@terms","line":858,"kind":13}],"kind":12},{"kind":12,"line":876,"children":[{"line":877,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"relationship_factory"},{"line":879,"kind":13,"name":"$self","containerName":"relationship_factory"},{"containerName":"relationship_factory","name":"$self","kind":13,"line":880}],"containerName":"main::","definition":"sub","name":"relationship_factory","range":{"end":{"character":9999,"line":881},"start":{"character":0,"line":876}}},{"range":{"end":{"line":910,"character":9999},"start":{"character":0,"line":901}},"containerName":"main::","name":"term_factory","definition":"sub","line":901,"children":[{"line":902,"kind":13,"localvar":"my","containerName":"term_factory","name":"$self","definition":"my"},{"line":905,"kind":13,"name":"$self","containerName":"term_factory"},{"name":"warn","containerName":"term_factory","line":905,"kind":12},{"kind":13,"line":905,"name":"$self","containerName":"term_factory"},{"containerName":"term_factory","name":"$self","line":907,"kind":13},{"kind":13,"line":909,"name":"$self","containerName":"term_factory"}],"kind":12},{"line":923,"children":[{"localvar":"my","containerName":"_filter_unmarked","definition":"my","name":"$self","line":924,"kind":13},{"line":924,"kind":13,"name":"@terms","containerName":"_filter_unmarked"},{"localvar":"my","containerName":"_filter_unmarked","definition":"my","name":"@filtered_terms","line":925,"kind":13},{"name":"@terms","containerName":"_filter_unmarked","kind":13,"line":927},{"kind":13,"line":928,"name":"$term","definition":"my","containerName":"_filter_unmarked","localvar":"my"},{"containerName":"_filter_unmarked","name":"@terms","kind":13,"line":928},{"containerName":"_filter_unmarked","name":"@filtered_terms","kind":13,"line":929},{"line":930,"kind":13,"name":"$term","containerName":"_filter_unmarked"},{"name":"$self","containerName":"_filter_unmarked","line":930,"kind":13},{"containerName":"_filter_unmarked","name":"_instantiated_terms_store","line":930,"kind":12},{"containerName":"_filter_unmarked","name":"$term","kind":13,"line":930},{"containerName":"_filter_unmarked","name":"identifier","kind":12,"line":930},{"name":"@filtered_terms","containerName":"_filter_unmarked","kind":13,"line":934}],"kind":12,"detail":"($self,@terms)","signature":{"label":"_filter_unmarked($self,@terms)","parameters":[{"label":"$self"},{"label":"@terms"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms.\n\n\nsub get_ancestor_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->_filter_repeated(\n               $self->get_term_by_identifier(\n                  $self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t  0,\n\t\t\t\t\t  $term->identifier,\n\t\t\t\t\t  @relationship_types) ) ) );\n}\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : get_leaf_terms(): TermI\n Function: Retrieves all leaf terms from the ontology. Leaf term is a term w/o descendants.\n Example : @leaf_terms = $obj->get_leaf_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_leaf_terms{\n  my ($self) = @_;\n  my @leaf_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n\t  push @leaf_terms, $term\n\t\t if !defined $self->_relationship_store->{$term->identifier} &&\n\t\t\tdefined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @leaf_terms;\n}\n\n=head2 get_root_terms\n\n Title   : get_root_terms\n Usage   : get_root_terms(): TermI\n Function: Retrieves all root terms from the ontology. Root term is a term w/o descendants.\n Example : @root_terms = $obj->get_root_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_root_terms{\n  my ($self) = @_;\n  my @root_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n    push @root_terms, $term\n      if !defined $self->_inverted_relationship_store->{$term->identifier} &&\n\t\t  defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @root_terms;\n}\n\n=head2 _filter_repeated\n\n Title   : _filter_repeated\n Usage   : @lst = $self->_filter_repeated(@old_lst);\n Function: Removes repeated terms\n Example :\n Returns : List of unique TermI objects\n Args    : List of TermI objects\n\n\nsub _filter_repeated{\n  my ($self, @args) = @_;\n  my %h;\n\n  foreach my $element (@args) {\n    $h{$element->identifier} = $element if !defined $h{$element->identifier};\n  }\n\n  return values %h;\n}\n\n=head2 get_all_terms\n\n Title   : get_all_terms\n Usage   : get_all_terms(): TermI\n Function: Retrieves all terms currently stored in the ontology.\n Example : @all_terms = $obj->get_all_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_all_terms{\n  my ($self) = @_;\n\n  return $self->_filter_unmarked( values %{$self->_term_store} );\n}\n\n=head2 find_terms\n\n Title   : find_terms\n Usage   : ($term) = $oe->find_terms(-identifier => \"SO:0000263\");\n Function: Find term instances matching queries for their attributes.\n\n           This implementation can efficiently resolve queries by\n           identifier.\n\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : Named parameters. The following parameters should be recognized\n           by any implementations:\n\n              -identifier    query by the given identifier\n              -name          query by the given name\n\n\nsub find_terms{\n    my ($self,@args) = @_;\n    my @terms;\n\n    my ($id,$name) = $self->_rearrange([qw(IDENTIFIER NAME)],@args);\n\n    if(defined($id)) {\n\t\t @terms = $self->get_term_by_identifier($id);\n    } else {\n\t\t @terms = $self->get_all_terms();\n    }\n    if(defined($name)) {\n\t\t @terms = grep { $_->name() eq $name; } @terms;\n    }\n    return @terms;\n}\n\n\n=head2 relationship_factory\n\n Title   : relationship_factory\n Usage   : $fact = $obj->relationship_factory()\n Function: Get/set the object factory to be used when relationship\n           objects are created by the implementation on-the-fly.\n\n Example : \n Returns : value of relationship_factory (a Bio::Factory::ObjectFactoryI\n           compliant object)\n Args    : on set, a Bio::Factory::ObjectFactoryI compliant object\n\n\nsub relationship_factory{\n    my $self = shift;\n\n    return $self->{'relationship_factory'} = shift if @_;\n    return $self->{'relationship_factory'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $fact = $obj->term_factory()\n Function: Get/set the object factory to be used when term objects are\n           created by the implementation on-the-fly.\n\n           Note that this ontology engine implementation does not\n           create term objects on the fly, and therefore setting this\n           attribute is meaningless.\n\n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactoryI\n           compliant object)\n Args    : on set, a Bio::Factory::ObjectFactoryI compliant object\n\n\nsub term_factory{\n    my $self = shift;\n\n    if(@_) {\n\t\t $self->warn(\"setting term factory, but \".ref($self).\n\t\t\t\t\t\t \" does not create terms on-the-fly\");\n\t\t return $self->{'term_factory'} = shift;\n    }\n    return $self->{'term_factory'};\n}\n\n=head2 _filter_unmarked\n\n Title   : _filter_unmarked\n Usage   : _filter_unmarked(TermI terms): TermI\n Function: Removes the uninstantiated terms from the list of terms\n Example :\n Returns : array of fully instantiated TermI objects\n Args    : array of TermI objects"},"containerName":"main::","definition":"sub","range":{"start":{"line":923,"character":0},"end":{"line":935,"character":9999}},"name":"_filter_unmarked"},{"range":{"end":{"character":9999,"line":962},"start":{"line":950,"character":0}},"name":"remove_term_by_id","children":[{"line":951,"kind":13,"localvar":"my","containerName":"remove_term_by_id","definition":"my","name":"$self"},{"name":"$id","containerName":"remove_term_by_id","kind":13,"line":951},{"kind":13,"line":953,"containerName":"remove_term_by_id","name":"$self"},{"kind":12,"line":953,"name":"get_term_by_identifier","containerName":"remove_term_by_id"},{"line":953,"kind":13,"name":"$id","containerName":"remove_term_by_id"},{"line":954,"kind":13,"localvar":"my","name":"$term","definition":"my","containerName":"remove_term_by_id"},{"kind":13,"line":954,"containerName":"remove_term_by_id","name":"$self"},{"line":954,"kind":13,"name":"$id","containerName":"remove_term_by_id"},{"kind":13,"line":955,"name":"$self","containerName":"remove_term_by_id"},{"line":955,"kind":13,"containerName":"remove_term_by_id","name":"$id"},{"containerName":"remove_term_by_id","name":"$term","line":956,"kind":13},{"containerName":"remove_term_by_id","name":"$self","kind":13,"line":959},{"kind":12,"line":959,"containerName":"remove_term_by_id","name":"warn"}],"line":950,"kind":12,"signature":{"label":"remove_term_by_id($self,$id)","documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms.\n\n\nsub get_ancestor_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->_filter_repeated(\n               $self->get_term_by_identifier(\n                  $self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t  0,\n\t\t\t\t\t  $term->identifier,\n\t\t\t\t\t  @relationship_types) ) ) );\n}\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : get_leaf_terms(): TermI\n Function: Retrieves all leaf terms from the ontology. Leaf term is a term w/o descendants.\n Example : @leaf_terms = $obj->get_leaf_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_leaf_terms{\n  my ($self) = @_;\n  my @leaf_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n\t  push @leaf_terms, $term\n\t\t if !defined $self->_relationship_store->{$term->identifier} &&\n\t\t\tdefined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @leaf_terms;\n}\n\n=head2 get_root_terms\n\n Title   : get_root_terms\n Usage   : get_root_terms(): TermI\n Function: Retrieves all root terms from the ontology. Root term is a term w/o descendants.\n Example : @root_terms = $obj->get_root_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_root_terms{\n  my ($self) = @_;\n  my @root_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n    push @root_terms, $term\n      if !defined $self->_inverted_relationship_store->{$term->identifier} &&\n\t\t  defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @root_terms;\n}\n\n=head2 _filter_repeated\n\n Title   : _filter_repeated\n Usage   : @lst = $self->_filter_repeated(@old_lst);\n Function: Removes repeated terms\n Example :\n Returns : List of unique TermI objects\n Args    : List of TermI objects\n\n\nsub _filter_repeated{\n  my ($self, @args) = @_;\n  my %h;\n\n  foreach my $element (@args) {\n    $h{$element->identifier} = $element if !defined $h{$element->identifier};\n  }\n\n  return values %h;\n}\n\n=head2 get_all_terms\n\n Title   : get_all_terms\n Usage   : get_all_terms(): TermI\n Function: Retrieves all terms currently stored in the ontology.\n Example : @all_terms = $obj->get_all_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_all_terms{\n  my ($self) = @_;\n\n  return $self->_filter_unmarked( values %{$self->_term_store} );\n}\n\n=head2 find_terms\n\n Title   : find_terms\n Usage   : ($term) = $oe->find_terms(-identifier => \"SO:0000263\");\n Function: Find term instances matching queries for their attributes.\n\n           This implementation can efficiently resolve queries by\n           identifier.\n\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : Named parameters. The following parameters should be recognized\n           by any implementations:\n\n              -identifier    query by the given identifier\n              -name          query by the given name\n\n\nsub find_terms{\n    my ($self,@args) = @_;\n    my @terms;\n\n    my ($id,$name) = $self->_rearrange([qw(IDENTIFIER NAME)],@args);\n\n    if(defined($id)) {\n\t\t @terms = $self->get_term_by_identifier($id);\n    } else {\n\t\t @terms = $self->get_all_terms();\n    }\n    if(defined($name)) {\n\t\t @terms = grep { $_->name() eq $name; } @terms;\n    }\n    return @terms;\n}\n\n\n=head2 relationship_factory\n\n Title   : relationship_factory\n Usage   : $fact = $obj->relationship_factory()\n Function: Get/set the object factory to be used when relationship\n           objects are created by the implementation on-the-fly.\n\n Example : \n Returns : value of relationship_factory (a Bio::Factory::ObjectFactoryI\n           compliant object)\n Args    : on set, a Bio::Factory::ObjectFactoryI compliant object\n\n\nsub relationship_factory{\n    my $self = shift;\n\n    return $self->{'relationship_factory'} = shift if @_;\n    return $self->{'relationship_factory'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $fact = $obj->term_factory()\n Function: Get/set the object factory to be used when term objects are\n           created by the implementation on-the-fly.\n\n           Note that this ontology engine implementation does not\n           create term objects on the fly, and therefore setting this\n           attribute is meaningless.\n\n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactoryI\n           compliant object)\n Args    : on set, a Bio::Factory::ObjectFactoryI compliant object\n\n\nsub term_factory{\n    my $self = shift;\n\n    if(@_) {\n\t\t $self->warn(\"setting term factory, but \".ref($self).\n\t\t\t\t\t\t \" does not create terms on-the-fly\");\n\t\t return $self->{'term_factory'} = shift;\n    }\n    return $self->{'term_factory'};\n}\n\n=head2 _filter_unmarked\n\n Title   : _filter_unmarked\n Usage   : _filter_unmarked(TermI terms): TermI\n Function: Removes the uninstantiated terms from the list of terms\n Example :\n Returns : array of fully instantiated TermI objects\n Args    : array of TermI objects\n\n\nsub _filter_unmarked{\n  my ($self, @terms) = @_;\n  my @filtered_terms = ();\n\n  if ( scalar(@terms) >= 1) {\n    foreach my $term (@terms) {\n      push @filtered_terms, $term\n\tif defined $self->_instantiated_terms_store->{$term->identifier};\n    }\n  }\n\n  return @filtered_terms;\n}\n\n=head2 remove_term_by_id\n\n Title   : remove_term_by_id\n Usage   : remove_term_by_id(String id): TermI\n Function: Removes TermI object from the ontology engine using the\n           string id as an identifier. Current implementation does not\n           enforce consistency of the relationships using that term.\n Example : $term = $soe->remove_term_by_id($id);\n Returns : Object of class TermI or undef if not found.\n Args    : The string identifier of a term.","parameters":[{"label":"$self"},{"label":"$id"}]},"detail":"($self,$id)","definition":"sub","containerName":"main::"},{"name":"_term_store","kind":12,"line":954},{"name":"_term_store","kind":12,"line":955},{"definition":"sub","containerName":"main::","signature":{"label":"to_string($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: SimpleOntologyEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::SimpleOntologyEngine\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::SimpleOntologyEngine - Implementation of OntologyEngineI interface\n\n=head1 SYNOPSIS\n\n  my $soe = Bio::Ontology::SimpleOntologyEngine->new;\n\n=head1 DESCRIPTION\n\nThis is a \"simple\" implementation of Bio::Ontology::OntologyEngineI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::SimpleOntologyEngine;\nuse strict;\nuse Carp;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n=head2 new\n\n Title   : new\n Usage   : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Function: Initializes the ontology engine.\n Example : $soe = Bio::Ontology::SimpleOntologyEngine->new;\n Returns : Object of class SimpleOntologyEngine.\n Args    :\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n#   my %param = @args;\n\n  $self->_term_store( {} );\n  $self->_relationship_store( {} );\n  $self->_inverted_relationship_store( {} );\n  $self->_relationship_type_store( {} );\n  $self->_instantiated_terms_store( {} );\n\n  # set defaults for the factories\n  $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n\t\t\t\t     -type => \"Bio::Ontology::Relationship\"));\n  return $self;\n}\n\n=head2 _instantiated_terms_store\n\n Title   : _instantiated_terms_store\n Usage   : $obj->_instantiated_terms_store($newval)\n Function:\n Example :\n Returns : hash\n Args    : empty hash\n\n\nsub _instantiated_terms_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\t$self->{'_instantiated_terms_store'} = $value;\n\t}\n\treturn $self->{'_instantiated_terms_store'};\n}\n\n=head2 mark_instantiated\n\n Title   : mark_instantiated\n Usage   : $self->mark_instantiated(TermI terms): TermI\n Function: Marks TermI objects as fully instantiated,\n           allowing for proper counting of the number of terms in the term store.\n           The TermI objects has to be already stored in the term store in order\n           to be marked.\n Example : $self->mark_instantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store.\n Args    : array of objects of class TermI.\n\n\nsub mark_instantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n\t  $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n\t\t if !defined $self->_term_store->{$term->identifier};\n\t  $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return @terms;\n}\n\n=head2 mark_uninstantiated\n\n Title   : mark_uninstantiated\n Usage   : $self->mark_uninstantiated(TermI terms): TermI\n Function: Marks TermI objects as not fully instantiated,\n Example : $self->mark_uninstantiated($term);\n Returns : its argument or throws an exception if a term is not\n           in the term store(if the term is not marked it does nothing).\n Args    : array of objects of class TermI.\n\n\nsub mark_uninstantiated{\n  my ($self, @terms) = @_;\n\n  foreach my $term (@terms) {\n    $self->throw( \"term \".$term->identifier.\" not in the term store\\n\" )\n      if !defined $self->_term_store->{$term->identifier};\n    delete $self->_instantiated_terms_store->{$term->identifier}\n      if defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @terms;\n}\n\n=head2 _term_store\n\n Title   : term_store\n Usage   : $obj->_term_store($newval)\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _term_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'_term_store'}) {\n      $self->throw(\"_term_store already defined\\n\");\n    }\n    else {\n      $self->{'_term_store'} = $value;\n    }\n  }\n\n  return $self->{'_term_store'};\n}\n\n=head2 add_term\n\n Title   : add_term\n Usage   : add_term(TermI term): TermI\n Function: Adds TermI object to the ontology engine term store.\n Marks the term fully instantiated by default.\n Example : $soe->add_term($term)\n Returns : its argument.\n Args    : object of class TermI.\n\n\nsub add_term{\n  my ($self, $term) = @_;\n  my $term_store = $self->_term_store;\n\n  if ( defined $term_store -> {$term->identifier}) {\n    $self->throw( \"term \".$term->identifier.\" already defined\\n\" );\n  }\n  else {\n    $term_store->{$term->identifier} = $term;\n    $self->_instantiated_terms_store->{$term->identifier} = 1;\n  }\n\n  return $term;\n}\n\n=head2 get_term_by_identifier\n\n Title   : get_term_by_identifier\n Usage   : get_term_by_identifier(String id): TermI\n Function: Retrieves terms from the term store by their identifier\n           field, or an empty list if not there.\n Example : $term = $soe->get_term_by_identifier(\"IPR000001\");\n Returns : An array of zero or more Bio::Ontology::TermI objects.\n Args    : An array of identifier strings\n\n\nsub get_term_by_identifier{\n  my ($self, @ids) = @_;\n  my @ans = ();\n\n  foreach my $id (@ids) {\n      my $term = $self->_term_store->{$id};\n      push @ans, $term if defined $term;\n  }\n\n  return @ans;\n}\n\n=head2 _get_number_rels\n\n Title   : get_number_rels\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_rels{\n  my ($self) = @_;\n  my $num_rels = 0;\n\n  foreach my $entry ($self->_relationship_store) {\n    $num_rels += scalar keys %$entry;\n  }\n  return $num_rels;\n}\n\n=head2 _get_number_terms\n\n Title   : _get_number_terms\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _get_number_terms{\n  my ($self) = @_;\n\n  return scalar $self->_filter_unmarked( values %{$self->_term_store} );\n\n}\n\n=head2 _relationship_store\n\n Title   : _storerelationship_store\n Usage   : $obj->relationship_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _relationship_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_store'}) {\n\t\t  $self->throw(\"_relationship_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_store'};\n}\n\n=head2 _inverted_relationship_store\n\n Title   : _inverted_relationship_store\n Usage   :\n Function:\n Example :\n Returns : reference to an array of Bio::Ontology::TermI objects\n Args    : reference to an array of Bio::Ontology::TermI objects\n\n\nsub _inverted_relationship_store{\n\tmy ($self, $value) = @_;\n\n\tif( defined $value) {\n\t\tif ( defined $self->{'_inverted_relationship_store'}) {\n\t\t\t$self->throw(\"_inverted_relationship_store already defined\\n\");\n\t\t}\n\t\telse {\n\t\t\t$self->{'_inverted_relationship_store'} = $value;\n\t\t}\n\t}\n\n  return $self->{'_inverted_relationship_store'};\n}\n\n=head2 _relationship_type_store\n\n Title   : _relationship_type_store\n Usage   : $obj->_relationship_type_store($newval)\n Function: \n Example : \n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    : reference to an array of Bio::Ontology::RelationshipType objects\n\n\nsub _relationship_type_store{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n\t  if ( defined $self->{'_relationship_type_store'}) {\n\t\t  $self->throw(\"_relationship_type_store already defined\\n\");\n\t  }\n\t  else {\n\t\t  $self->{'_relationship_type_store'} = $value;\n\t  }\n  }\n\n  return $self->{'_relationship_type_store'};\n}\n\n=head2 _add_relationship_simple\n\n Title   : _add_relationship_simple\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _add_relationship_simple{\n   my ($self, $store, $rel, $inverted) = @_;\n   my $parent_id;\n   my $child_id;\n\n   if ($inverted) {\n\t\t$parent_id = $rel->subject_term->identifier;\n\t\t$child_id = $rel->object_term->identifier;\n   }\n   else {\n\t\t$parent_id = $rel->object_term->identifier;\n\t\t$child_id = $rel->subject_term->identifier;\n   }\n   if(defined $store->{$parent_id} && (defined $store->{$parent_id}->{$child_id}) &&\n      ($store->{$parent_id}->{$child_id}->name != $rel->predicate_term->name)){\n\t\t$self->throw(\"relationship \".Dumper($rel->predicate_term).\n\t\t\t\t\t\t \" between \".$parent_id.\" and \".$child_id.\n\t\t\t\t\t\t \" already defined as \".\n\t\t\t\t\t\t Dumper($store->{$parent_id}->{$child_id}).\"\\n\");\n   }\n   else {\n\t\t$store->{$parent_id}->{$child_id} = $rel->predicate_term;\n   }\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : add_relationship(RelationshipI relationship): RelationshipI\n Function: Adds a relationship object to the ontology engine.\n Example :\n Returns : Its argument.\n Args    : A RelationshipI object.\n\n\nsub add_relationship{\n   my ($self, $rel) = @_;\n\n   $self->_add_relationship_simple($self->_relationship_store,\n\t\t\t\t   $rel, 0);\n   $self->_add_relationship_simple($self->_inverted_relationship_store,\n\t\t\t\t   $rel, 1);\n   $self->_relationship_type_store->{\n       $self->_unique_termid($rel->predicate_term)} = $rel->predicate_term;\n\n   return $rel;\n}\n\n=head2 get_relationships\n\n Title   : get_relationships\n Usage   : get_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_relationships{\n    my $self = shift;\n    my $term = shift;\n    my @rels;\n    my $store = $self->_relationship_store;\n    my $relfact = $self->relationship_factory(); \n\n    my @parent_ids = $term ?\n\t\t# if a term is supplied then only get the term's parents\n\t\t(map { $_->identifier(); } $self->get_parent_terms($term)) :\n\t\t  # otherwise use all parent ids\n\t\t  (keys %{$store});\n    # add the term as a parent too if one is supplied\n    push(@parent_ids,$term->identifier) if $term;\n    \n    foreach my $parent_id (@parent_ids) {\n\t\t my $parent_entry = $store->{$parent_id};\n\n\t\t # if a term is supplied, add a relationship for the parent to the term\n\t\t # except if the parent is the term itself (we added that one before)\n\t\t if($term && ($parent_id ne $term->identifier())) {\n\t\t\t my @parent_terms = $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t push(@rels,\n\t\t\t\t\t\t$relfact->create_object(-object_term    => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term   => $term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term =>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t$parent_entry->{$term->identifier},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology => $term->ontology())\n\t\t\t\t\t  );\n\t\t\t }\n\t\t \n\t\t } else {\n\t\t\t # otherwise, i.e., no term supplied, or the parent equals the\n\t\t\t # supplied term\n\t\t\t my @parent_terms = $term ?\n\t\t\t\t($term) : $self->get_term_by_identifier($parent_id);\n\t\t\t foreach my $child_id (keys %$parent_entry) {\n\t\t\t\t my $rel_info = $parent_entry->{$child_id};\n\t\t\t\t my ($subj_term) = $self->get_term_by_identifier($child_id);\n\n\t\t\t\t foreach my $parent_term (@parent_terms) {\n\t\t\t\t\t push(@rels,\n\t\t\t\t\t\t\t$relfact->create_object(-object_term  => $parent_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-subject_term => $subj_term,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-predicate_term => $rel_info,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-ontology =>$parent_term->ontology\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t  )\n\t\t\t\t\t\t  );\n\t\t\t\t }\n\t\t\t }\n\t\t }\n    }\n\n    return @rels;\n}\n\n=head2 get_all_relationships\n\n Title   : get_all_relationships\n Usage   : get_all_relationships(): RelationshipI\n Function: Retrieves all relationship objects.\n Example :\n Returns : Array of RelationshipI objects\n Args    :\n\n\nsub get_all_relationships{\n    return shift->get_relationships();\n}\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : get_predicate_terms(): TermI\n Function: Retrives all relationship types stored in the engine\n Example :\n Returns : reference to an array of Bio::Ontology::RelationshipType objects\n Args    :\n\n\nsub get_predicate_terms{\n  my ($self) = @_;\n\n  return values %{$self->_relationship_type_store};\n}\n\n=head2 _is_rel_type\n\n Title   : _is_rel_type\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\nsub _is_rel_type{\n  my ($self, $term, @rel_types) = @_;\n\n  foreach my $rel_type (@rel_types) {\n\t  if($rel_type->identifier || $term->identifier) {\n\t\t  return 1 if $rel_type->identifier eq $term->identifier;\n\t  } else {\n\t\t  return 1 if $rel_type->name eq $term->name;\n\t  }\n  }\n\n  return 0;\n}\n\n=head2 _typed_traversal\n\n Title   : _typed_traversal\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\nsub _typed_traversal{\n\tmy ($self, $rel_store, $level, $term_id, @rel_types) = @_;\n\treturn if !defined($rel_store->{$term_id});\n\tmy %parent_entry = %{$rel_store->{$term_id}};\n\tmy @children = keys %parent_entry;\n\n\tmy @ans;\n\n\tif (@rel_types > 0) {\n\t\t@ans = ();\n\n\t\tforeach my $child_id (@children) {\n\t\t\tpush @ans, $child_id\n\t\t\t  if $self->_is_rel_type( $rel_store->{$term_id}->{$child_id},\n\t\t\t\t\t\t\t\t\t\t\t  @rel_types);\n\t\t}\n\t}\n\telse {\n\t\t@ans = @children;\n\t}\n\tif ($level < 1) {\n\t\tmy @ans1 = ();\n\n\t\tforeach my $child_id (@ans) {\n\t\t\tpush @ans1, $self->_typed_traversal($rel_store,\n\t\t\t\t\t\t\t\t$level - 1, $child_id, @rel_types)\n\t\t\t  if defined $rel_store->{$child_id};\n\t\t}\n\t\tpush @ans, @ans1;\n\t}\n\n  return @ans;\n}\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : get_child_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all child terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_child_terms is a special\n           case of get_descendant_terms, limiting the search to the\n           direct descendants.\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_child_terms{\n\tmy ($self, $term, @relationship_types) = @_;\n\n\t$self->throw(\"must provide TermI compliant object\") \n\t  unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n\treturn $self->_filter_unmarked(\n\t\t\t\t\t\t\t\t\t\t\t $self->get_term_by_identifier(\n\t\t\t\t\t\t$self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t   1,\n\t\t\t\t\t   $term->identifier,\n\t\t\t\t\t   @relationship_types) ) );\n}\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : get_descendant_terms(TermI term, TermI rel_types): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all descendant terms of a given term, that\n           satisfy a relationship among those that are specified in\n           the second argument or undef otherwise. Uses\n           _typed_traversal to find all descendants.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of \n           relationship type terms.\n\n\nsub get_descendant_terms{\n  my ($self, $term, @relationship_types) = @_;\n\n  $self->throw(\"must provide TermI compliant object\") \n      unless defined($term) && $term->isa(\"Bio::Ontology::TermI\");\n\n  return $self->_filter_unmarked(\n\t     $self->_filter_repeated(\n\t         $self->get_term_by_identifier(\n\t\t     $self->_typed_traversal($self->_relationship_store,\n\t\t\t\t\t     0,\n\t\t\t\t\t     $term->identifier,\n\t\t\t\t\t     @relationship_types) ) ) );\n}\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : get_parent_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all parent terms of a given term, that satisfy a\n           relationship among those that are specified in the second\n           argument or undef otherwise. get_parent_terms is a special\n           case of get_ancestor_terms, limiting the search to the\n           direct ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list of relationship type terms.\n\n\nsub get_parent_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->get_term_by_identifier(\n\t\t$self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t1,\n\t\t\t\t\t$term->identifier,\n\t\t\t\t\t@relationship_types) ) );\n}\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : get_ancestor_terms(TermI term, TermI predicate_terms): TermI\n           get_child_terms(TermI term, RelationshipType predicate_terms): TermI\n Function: Retrieves all ancestor terms of a given term, that satisfy\n           a relationship among those that are specified in the second\n           argument or undef otherwise. Uses _typed_traversal to find\n           all ancestors.\n\n Example :\n Returns : Array of TermI objects.\n Args    : First argument is the term of interest, second is the list\n           of relationship type terms.\n\n\nsub get_ancestor_terms{\n  my ($self, $term, @relationship_types) = @_;\n  $self->throw(\"term must be a valid object, not undef\") unless defined $term;\n\n  return $self->_filter_unmarked(\n\t    $self->_filter_repeated(\n               $self->get_term_by_identifier(\n                  $self->_typed_traversal($self->_inverted_relationship_store,\n\t\t\t\t\t  0,\n\t\t\t\t\t  $term->identifier,\n\t\t\t\t\t  @relationship_types) ) ) );\n}\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : get_leaf_terms(): TermI\n Function: Retrieves all leaf terms from the ontology. Leaf term is a term w/o descendants.\n Example : @leaf_terms = $obj->get_leaf_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_leaf_terms{\n  my ($self) = @_;\n  my @leaf_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n\t  push @leaf_terms, $term\n\t\t if !defined $self->_relationship_store->{$term->identifier} &&\n\t\t\tdefined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @leaf_terms;\n}\n\n=head2 get_root_terms\n\n Title   : get_root_terms\n Usage   : get_root_terms(): TermI\n Function: Retrieves all root terms from the ontology. Root term is a term w/o descendants.\n Example : @root_terms = $obj->get_root_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_root_terms{\n  my ($self) = @_;\n  my @root_terms;\n\n  foreach my $term (values %{$self->_term_store}) {\n    push @root_terms, $term\n      if !defined $self->_inverted_relationship_store->{$term->identifier} &&\n\t\t  defined $self->_instantiated_terms_store->{$term->identifier};\n  }\n\n  return @root_terms;\n}\n\n=head2 _filter_repeated\n\n Title   : _filter_repeated\n Usage   : @lst = $self->_filter_repeated(@old_lst);\n Function: Removes repeated terms\n Example :\n Returns : List of unique TermI objects\n Args    : List of TermI objects\n\n\nsub _filter_repeated{\n  my ($self, @args) = @_;\n  my %h;\n\n  foreach my $element (@args) {\n    $h{$element->identifier} = $element if !defined $h{$element->identifier};\n  }\n\n  return values %h;\n}\n\n=head2 get_all_terms\n\n Title   : get_all_terms\n Usage   : get_all_terms(): TermI\n Function: Retrieves all terms currently stored in the ontology.\n Example : @all_terms = $obj->get_all_terms()\n Returns : Array of TermI objects.\n Args    :\n\n\nsub get_all_terms{\n  my ($self) = @_;\n\n  return $self->_filter_unmarked( values %{$self->_term_store} );\n}\n\n=head2 find_terms\n\n Title   : find_terms\n Usage   : ($term) = $oe->find_terms(-identifier => \"SO:0000263\");\n Function: Find term instances matching queries for their attributes.\n\n           This implementation can efficiently resolve queries by\n           identifier.\n\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : Named parameters. The following parameters should be recognized\n           by any implementations:\n\n              -identifier    query by the given identifier\n              -name          query by the given name\n\n\nsub find_terms{\n    my ($self,@args) = @_;\n    my @terms;\n\n    my ($id,$name) = $self->_rearrange([qw(IDENTIFIER NAME)],@args);\n\n    if(defined($id)) {\n\t\t @terms = $self->get_term_by_identifier($id);\n    } else {\n\t\t @terms = $self->get_all_terms();\n    }\n    if(defined($name)) {\n\t\t @terms = grep { $_->name() eq $name; } @terms;\n    }\n    return @terms;\n}\n\n\n=head2 relationship_factory\n\n Title   : relationship_factory\n Usage   : $fact = $obj->relationship_factory()\n Function: Get/set the object factory to be used when relationship\n           objects are created by the implementation on-the-fly.\n\n Example : \n Returns : value of relationship_factory (a Bio::Factory::ObjectFactoryI\n           compliant object)\n Args    : on set, a Bio::Factory::ObjectFactoryI compliant object\n\n\nsub relationship_factory{\n    my $self = shift;\n\n    return $self->{'relationship_factory'} = shift if @_;\n    return $self->{'relationship_factory'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $fact = $obj->term_factory()\n Function: Get/set the object factory to be used when term objects are\n           created by the implementation on-the-fly.\n\n           Note that this ontology engine implementation does not\n           create term objects on the fly, and therefore setting this\n           attribute is meaningless.\n\n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactoryI\n           compliant object)\n Args    : on set, a Bio::Factory::ObjectFactoryI compliant object\n\n\nsub term_factory{\n    my $self = shift;\n\n    if(@_) {\n\t\t $self->warn(\"setting term factory, but \".ref($self).\n\t\t\t\t\t\t \" does not create terms on-the-fly\");\n\t\t return $self->{'term_factory'} = shift;\n    }\n    return $self->{'term_factory'};\n}\n\n=head2 _filter_unmarked\n\n Title   : _filter_unmarked\n Usage   : _filter_unmarked(TermI terms): TermI\n Function: Removes the uninstantiated terms from the list of terms\n Example :\n Returns : array of fully instantiated TermI objects\n Args    : array of TermI objects\n\n\nsub _filter_unmarked{\n  my ($self, @terms) = @_;\n  my @filtered_terms = ();\n\n  if ( scalar(@terms) >= 1) {\n    foreach my $term (@terms) {\n      push @filtered_terms, $term\n\tif defined $self->_instantiated_terms_store->{$term->identifier};\n    }\n  }\n\n  return @filtered_terms;\n}\n\n=head2 remove_term_by_id\n\n Title   : remove_term_by_id\n Usage   : remove_term_by_id(String id): TermI\n Function: Removes TermI object from the ontology engine using the\n           string id as an identifier. Current implementation does not\n           enforce consistency of the relationships using that term.\n Example : $term = $soe->remove_term_by_id($id);\n Returns : Object of class TermI or undef if not found.\n Args    : The string identifier of a term.\n\n\nsub remove_term_by_id{\n  my ($self, $id) = @_;\n\n  if ( $self->get_term_by_identifier($id) ) {\n\t  my $term = $self->{_term_store}->{$id};\n\t  delete $self->{_term_store}->{$id};\n\t  return $term;\n  }\n  else {\n\t  $self->warn(\"Term with id '$id' is not in the term store\");\n\t  return;\n  }\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : print $sv->to_string();\n Function: Currently returns formatted string containing the number of\n           terms and number of relationships from the ontology engine.\n Example : print $sv->to_string();\n Returns :\n Args    :"},"detail":"($self)","kind":12,"children":[{"kind":13,"line":977,"definition":"my","name":"$self","containerName":"to_string","localvar":"my"},{"definition":"my","name":"$s","containerName":"to_string","localvar":"my","kind":13,"line":978},{"line":980,"kind":13,"containerName":"to_string","name":"$s"},{"kind":13,"line":981,"containerName":"to_string","name":"$s"},{"containerName":"to_string","name":"$self","line":981,"kind":13},{"containerName":"to_string","name":"get_all_terms","kind":12,"line":981},{"containerName":"to_string","name":"$s","line":982,"kind":13},{"kind":13,"line":983,"containerName":"to_string","name":"$s"},{"kind":13,"line":983,"name":"$self","containerName":"to_string"},{"line":983,"kind":12,"name":"_get_number_rels","containerName":"to_string"},{"kind":13,"line":985,"name":"$s","containerName":"to_string"}],"line":976,"name":"to_string","range":{"start":{"line":976,"character":0},"end":{"line":986,"character":9999}}},{"range":{"end":{"line":1020,"character":9999},"start":{"line":1008,"character":0}},"containerName":"main::","definition":"sub","name":"_unique_termid","line":1008,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_unique_termid","line":1009,"kind":13},{"definition":"my","name":"$term","containerName":"_unique_termid","localvar":"my","kind":13,"line":1010},{"line":1012,"kind":13,"containerName":"_unique_termid","name":"$term"},{"name":"identifier","containerName":"_unique_termid","line":1012,"kind":12},{"line":1012,"kind":13,"name":"$term","containerName":"_unique_termid"},{"line":1012,"kind":12,"name":"identifier","containerName":"_unique_termid"},{"name":"$id","definition":"my","containerName":"_unique_termid","localvar":"my","kind":13,"line":1013},{"containerName":"_unique_termid","name":"$term","kind":13,"line":1013},{"name":"ontology","containerName":"_unique_termid","line":1013,"kind":12},{"name":"name","containerName":"_unique_termid","kind":12,"line":1013},{"name":"$term","containerName":"_unique_termid","line":1013,"kind":13},{"name":"ontology","containerName":"_unique_termid","line":1013,"kind":12},{"line":1014,"kind":13,"name":"$id","containerName":"_unique_termid"},{"name":"$id","containerName":"_unique_termid","line":1015,"kind":13},{"line":1017,"kind":13,"name":"$id","containerName":"_unique_termid"},{"containerName":"_unique_termid","name":"$id","line":1019,"kind":13},{"name":"$term","containerName":"_unique_termid","line":1019,"kind":13},{"kind":12,"line":1019,"name":"name","containerName":"_unique_termid"}],"kind":12}],"version":5}