{"version":5,"vars":[{"definition":1,"name":"PART_OF","containerName":"main::","kind":14,"line":99},{"kind":12,"line":99,"name":"strict","containerName":""},{"containerName":"main::","name":"RELATED_TO","definition":1,"line":100,"kind":14},{"kind":14,"line":101,"containerName":"main::","name":"IS_A","definition":1},{"containerName":"main::","definition":1,"name":"CONTAINS","line":102,"kind":14},{"line":103,"kind":14,"containerName":"main::","definition":1,"name":"FOUND_IN"},{"line":104,"kind":14,"definition":1,"name":"REGULATES","containerName":"main::"},{"name":"POSITIVELY_REGULATES","definition":1,"containerName":"main::","line":105,"kind":14},{"kind":14,"line":106,"definition":1,"name":"NEGATIVELY_REGULATES","containerName":"main::"},{"name":"base","containerName":"","line":109,"kind":2},{"localvar":"my","containerName":null,"name":"%term_name_map","definition":"my","line":115,"kind":13},{"name":"get_instance","range":{"start":{"character":0,"line":134},"end":{"line":167,"character":9999}},"kind":12,"line":134,"children":[{"kind":13,"line":135,"name":"$class","definition":"my","containerName":"get_instance","localvar":"my"},{"name":"$name","containerName":"get_instance","kind":13,"line":135},{"containerName":"get_instance","name":"$ont","kind":13,"line":135},{"kind":13,"line":137,"containerName":"get_instance","name":"$class"},{"kind":12,"line":137,"name":"throw","containerName":"get_instance"},{"containerName":"get_instance","name":"$name","line":137,"kind":13},{"line":140,"kind":13,"localvar":"my","containerName":"get_instance","definition":"my","name":"$reltype"},{"name":"$term_name_map","containerName":"get_instance","kind":13,"line":140},{"name":"$name","containerName":"get_instance","kind":13,"line":140},{"line":142,"kind":13,"containerName":"get_instance","name":"$reltype"},{"line":144,"kind":13,"containerName":"get_instance","name":"$ont"},{"kind":13,"line":144,"containerName":"get_instance","name":"$reltype"},{"kind":12,"line":144,"containerName":"get_instance","name":"ontology"},{"containerName":"get_instance","name":"$ont","line":145,"kind":13},{"name":"name","containerName":"get_instance","kind":12,"line":145},{"line":145,"kind":13,"containerName":"get_instance","name":"$reltype"},{"name":"ontology","containerName":"get_instance","kind":12,"line":145},{"containerName":"get_instance","name":"name","kind":12,"line":145},{"name":"$reltype","containerName":"get_instance","line":146,"kind":13},{"line":146,"kind":12,"name":"ontology","containerName":"get_instance"},{"line":146,"kind":13,"name":"$ont","containerName":"get_instance"},{"line":148,"kind":13,"containerName":"get_instance","name":"$reltype"},{"name":"$reltype","containerName":"get_instance","kind":13,"line":162},{"kind":13,"line":162,"containerName":"get_instance","name":"$class"},{"line":162,"kind":12,"name":"new","containerName":"get_instance"},{"containerName":"get_instance","name":"$name","kind":13,"line":162},{"kind":13,"line":163,"name":"$ont","containerName":"get_instance"},{"line":165,"kind":13,"name":"$term_name_map","containerName":"get_instance"},{"name":"$name","containerName":"get_instance","line":165,"kind":13},{"name":"$reltype","containerName":"get_instance","kind":13,"line":165},{"line":166,"kind":13,"containerName":"get_instance","name":"$reltype"}],"containerName":"main::","definition":"sub","detail":"($class,$name,$ont)","signature":{"parameters":[{"label":"$class"},{"label":"$name"},{"label":"$ont"}],"documentation":"1;\n# $Id: RelationshipType.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::RelationshipType  \n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::RelationshipType  - a relationship type for an ontology\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis class can be used to model various types of relationships\n(such as \"IS_A\", \"PART_OF\", \"CONTAINS\", \"FOUND_IN\", \"RELATED_TO\").\n\nThis class extends L<Bio::Ontology::Term>, so it essentially is-a\nL<Bio::Ontology::TermI>. In addition, all methods are overridden such\nas to make the object immutable.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::RelationshipType;\nuse strict;\n\n\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant IS_A       => \"IS_A\";\nuse constant CONTAINS   => \"CONTAINS\";\nuse constant FOUND_IN   => \"FOUND_IN\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Ontology::Term);\n\n\n#\n# cache for terms\n#\nmy %term_name_map = ();\n\n\n=head2 get_instance\n\n Title   : get_instance\n Usage   : $IS_A       = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n           $PART_OF    = Bio::Ontology::RelationshipType->get_instance( \"PART_OF\" );\n           $RELATED_TO = Bio::Ontology::RelationshipType->get_instance( \"RELATED_TO\" );\n           $CONTAINS   = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n           $FOUND_IN   = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n Function: Factory method to create instances of RelationshipType\n Returns : [Bio::Ontology::RelationshipType]\n Args    : \"IS_A\" or \"PART_OF\" or \"CONTAINS\" or \"FOUND_IN\" or \n           \"RELATED_TO\" [scalar]\n           the ontology [Bio::Ontology::OntologyI] (optional)","label":"get_instance($class,$name,$ont)"}},{"kind":12,"line":180,"children":[{"line":181,"kind":13,"localvar":"my","containerName":"init","definition":"my","name":"$self"},{"name":"$self","containerName":"init","kind":13,"line":183}],"containerName":"main::","name":"init","definition":"sub","range":{"end":{"line":186,"character":9999},"start":{"character":0,"line":180}}},{"containerName":"init","name":"SUPER","line":183,"kind":12},{"definition":"sub","containerName":"main::","signature":{"label":"equals($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: RelationshipType.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::RelationshipType  \n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::RelationshipType  - a relationship type for an ontology\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis class can be used to model various types of relationships\n(such as \"IS_A\", \"PART_OF\", \"CONTAINS\", \"FOUND_IN\", \"RELATED_TO\").\n\nThis class extends L<Bio::Ontology::Term>, so it essentially is-a\nL<Bio::Ontology::TermI>. In addition, all methods are overridden such\nas to make the object immutable.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::RelationshipType;\nuse strict;\n\n\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant IS_A       => \"IS_A\";\nuse constant CONTAINS   => \"CONTAINS\";\nuse constant FOUND_IN   => \"FOUND_IN\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Ontology::Term);\n\n\n#\n# cache for terms\n#\nmy %term_name_map = ();\n\n\n=head2 get_instance\n\n Title   : get_instance\n Usage   : $IS_A       = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n           $PART_OF    = Bio::Ontology::RelationshipType->get_instance( \"PART_OF\" );\n           $RELATED_TO = Bio::Ontology::RelationshipType->get_instance( \"RELATED_TO\" );\n           $CONTAINS   = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n           $FOUND_IN   = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n Function: Factory method to create instances of RelationshipType\n Returns : [Bio::Ontology::RelationshipType]\n Args    : \"IS_A\" or \"PART_OF\" or \"CONTAINS\" or \"FOUND_IN\" or \n           \"RELATED_TO\" [scalar]\n           the ontology [Bio::Ontology::OntologyI] (optional)\n\n\nsub get_instance {\n    my ( $class, $name, $ont ) = @_;\n\n    $class->throw(\"must provide predicate name\") unless $name;\n\n    # is one in the cache?\n    my $reltype = $term_name_map{$name};\n\n    if($reltype &&\n       # check whether ontologies match\n       (($ont && $reltype->ontology() &&\n\t ($ont->name() eq $reltype->ontology->name())) ||\n\t(! ($reltype->ontology() || $ont)))) {\n\t# we're done, return cached type\n\treturn $reltype;\n    }\n    # valid relationship type?\n\n#\n#see the cell ontology.  this code is too strict, even for dag-edit files. -allen\n#\n#    if ( ! (($name eq IS_A) || ($name eq PART_OF) ||\n#\t    ($name eq CONTAINS) || ( $name eq FOUND_IN ))) {\n#        my $msg = \"Found unknown type of relationship: [\" . $name . \"]\\n\";\n#        $msg .= \"Known types are: [\" . IS_A . \"], [\" . PART_OF . \"], [\" . CONTAINS . \"], [\" . FOUND_IN . \"]\";\n#        $class->throw( $msg );\n#    }\n    # if we get here we need to create the rel.type\n    $reltype = $class->new(-name     => $name,\n\t\t\t   -ontology => $ont);\n    # cache it (FIXME possibly overrides one from another ontology)\n    $term_name_map{$name} = $reltype;\n    return $reltype;\n} # get_instance\n\n\n=head2 init\n\n Title   : init()\n Usage   : $type->init();\n Function: Initializes this to all undef and empty lists.\n Returns :\n Args    :\n\n\nsub init {\n    my $self = shift;\n\n    $self->SUPER::init();\n\n    # at this point we don't really need to do anything special for us\n} # init\n\n\n=head2 equals\n\n Title   : equals\n Usage   : if ( $type->equals( $other_type ) ) { ...\n Function: Compares this type to another one, based on string \"eq\" of\n           the \"identifier\" field, if at least one of the two types has\n           the identifier set, or string eq of the name otherwise.\n Returns : true or false\n Args    : [Bio::Ontology::RelationshipType]"},"detail":"($self,$type)","kind":12,"children":[{"line":202,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"equals"},{"name":"$type","containerName":"equals","kind":13,"line":202},{"kind":13,"line":204,"containerName":"equals","name":"$self"},{"line":204,"kind":12,"containerName":"equals","name":"_check_class"},{"kind":13,"line":204,"name":"$type","containerName":"equals"},{"name":"$self","containerName":"equals","line":206,"kind":13},{"kind":12,"line":206,"containerName":"equals","name":"identifier"},{"line":206,"kind":13,"containerName":"equals","name":"$type"},{"line":206,"kind":12,"containerName":"equals","name":"identifier"},{"kind":13,"line":207,"containerName":"equals","name":"$self"},{"containerName":"equals","name":"warn","kind":12,"line":207},{"kind":13,"line":212,"name":"$self","containerName":"equals"},{"kind":12,"line":212,"containerName":"equals","name":"identifier"},{"line":212,"kind":13,"containerName":"equals","name":"$type"},{"name":"identifier","containerName":"equals","line":212,"kind":12},{"line":213,"kind":13,"name":"$self","containerName":"equals"},{"kind":12,"line":213,"name":"identifier","containerName":"equals"},{"containerName":"equals","name":"$type","kind":13,"line":213},{"name":"identifier","containerName":"equals","kind":12,"line":213},{"line":214,"kind":13,"containerName":"equals","name":"$self"},{"containerName":"equals","name":"name","kind":12,"line":214},{"line":214,"kind":13,"name":"$type","containerName":"equals"},{"line":214,"kind":12,"name":"name","containerName":"equals"}],"line":201,"name":"equals","range":{"end":{"line":216,"character":9999},"start":{"line":201,"character":0}}},{"line":231,"children":[{"line":232,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"identifier"},{"line":233,"kind":13,"localvar":"my","containerName":"identifier","definition":"my","name":"$ret"},{"containerName":"identifier","name":"$self","kind":13,"line":233},{"kind":13,"line":235,"containerName":"identifier","name":"$self"},{"containerName":"identifier","name":"throw","line":235,"kind":12},{"kind":13,"line":235,"name":"$self","containerName":"identifier"},{"name":"veto_change","containerName":"identifier","line":235,"kind":12},{"line":235,"kind":13,"name":"$ret","containerName":"identifier"},{"containerName":"identifier","name":"$ret","line":236,"kind":13},{"line":236,"kind":13,"name":"$ret","containerName":"identifier"},{"containerName":"identifier","name":"$ret","kind":13,"line":237},{"kind":13,"line":237,"containerName":"identifier","name":"$self"},{"line":239,"kind":13,"name":"$ret","containerName":"identifier"}],"kind":12,"range":{"start":{"character":0,"line":231},"end":{"line":240,"character":9999}},"containerName":"main::","definition":"sub","name":"identifier"},{"name":"SUPER","containerName":"identifier","line":233,"kind":12},{"kind":12,"line":237,"containerName":"identifier","name":"SUPER"},{"line":255,"children":[{"line":256,"kind":13,"localvar":"my","containerName":"name","definition":"my","name":"$self"},{"kind":13,"line":257,"name":"$ret","definition":"my","containerName":"name","localvar":"my"},{"name":"$self","containerName":"name","kind":13,"line":257},{"containerName":"name","name":"$self","kind":13,"line":259},{"name":"throw","containerName":"name","kind":12,"line":259},{"containerName":"name","name":"$self","line":259,"kind":13},{"kind":12,"line":259,"containerName":"name","name":"veto_change"},{"containerName":"name","name":"$ret","line":259,"kind":13},{"containerName":"name","name":"$ret","line":260,"kind":13},{"containerName":"name","name":"$ret","line":260,"kind":13},{"line":261,"kind":13,"containerName":"name","name":"$ret"},{"line":261,"kind":13,"containerName":"name","name":"$self"},{"containerName":"name","name":"$ret","line":263,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":255},"end":{"character":9999,"line":264}},"containerName":"main::","name":"name","definition":"sub"},{"containerName":"name","name":"SUPER","line":257,"kind":12},{"containerName":"name","name":"SUPER","line":261,"kind":12},{"line":282,"children":[{"kind":13,"line":283,"definition":"my","name":"$self","containerName":"definition","localvar":"my"},{"definition":"my","name":"$ret","containerName":"definition","localvar":"my","kind":13,"line":284},{"name":"$self","containerName":"definition","kind":13,"line":284},{"containerName":"definition","name":"$self","kind":13,"line":286},{"containerName":"definition","name":"veto_change","kind":12,"line":286},{"line":286,"kind":13,"name":"$ret","containerName":"definition"},{"line":287,"kind":13,"containerName":"definition","name":"$ret"},{"name":"$ret","containerName":"definition","line":287,"kind":13},{"containerName":"definition","name":"$ret","line":288,"kind":13},{"name":"$self","containerName":"definition","line":288,"kind":13},{"line":291,"kind":13,"name":"$ret","containerName":"definition"},{"line":291,"kind":13,"name":"$ret","containerName":"definition"},{"line":292,"kind":13,"containerName":"definition","name":"$self"},{"line":292,"kind":12,"name":"name","containerName":"definition"},{"line":292,"kind":13,"containerName":"definition","name":"$self"},{"name":"name","containerName":"definition","line":292,"kind":12}],"kind":12,"range":{"start":{"character":0,"line":282},"end":{"character":9999,"line":293}},"containerName":"main::","name":"definition","definition":"sub"},{"kind":12,"line":284,"name":"SUPER","containerName":"definition"},{"line":288,"kind":12,"containerName":"definition","name":"SUPER"},{"line":309,"children":[{"line":310,"kind":13,"localvar":"my","containerName":"ontology","name":"$self","definition":"my"},{"kind":13,"line":311,"containerName":"ontology","definition":"my","name":"$ret","localvar":"my"},{"containerName":"ontology","name":"$self","kind":13,"line":311},{"localvar":"my","definition":"my","name":"$ont","containerName":"ontology","line":313,"kind":13},{"kind":13,"line":314,"name":"$ret","containerName":"ontology"},{"line":315,"kind":13,"containerName":"ontology","name":"$self"},{"line":315,"kind":12,"name":"throw","containerName":"ontology"},{"containerName":"ontology","name":"$self","kind":13,"line":315},{"line":315,"kind":12,"containerName":"ontology","name":"veto_change"},{"kind":13,"line":315,"containerName":"ontology","name":"$ret"},{"line":315,"kind":12,"name":"name","containerName":"ontology"},{"kind":13,"line":316,"containerName":"ontology","name":"$ont"},{"kind":13,"line":316,"containerName":"ontology","name":"$ont"},{"name":"name","containerName":"ontology","line":316,"kind":12},{"name":"$ont","containerName":"ontology","line":316,"kind":13},{"containerName":"ontology","name":"$ont","line":317,"kind":13},{"containerName":"ontology","name":"$ont","line":317,"kind":13},{"line":317,"kind":12,"name":"name","containerName":"ontology"},{"kind":13,"line":317,"name":"$ret","containerName":"ontology"},{"kind":12,"line":317,"containerName":"ontology","name":"name"},{"kind":13,"line":319,"containerName":"ontology","name":"$ret"},{"containerName":"ontology","name":"$self","line":319,"kind":13},{"line":319,"kind":13,"name":"$ont","containerName":"ontology"},{"kind":13,"line":321,"containerName":"ontology","name":"$ret"}],"kind":12,"range":{"end":{"line":322,"character":9999},"start":{"character":0,"line":309}},"containerName":"main::","name":"ontology","definition":"sub"},{"kind":12,"line":311,"name":"SUPER","containerName":"ontology"},{"name":"SUPER","containerName":"ontology","line":319,"kind":12},{"kind":12,"line":338,"children":[{"kind":13,"line":339,"containerName":"version","name":"$self","definition":"my","localvar":"my"},{"line":340,"kind":13,"localvar":"my","containerName":"version","definition":"my","name":"$ret"},{"containerName":"version","name":"$self","line":340,"kind":13},{"name":"$self","containerName":"version","line":342,"kind":13},{"kind":12,"line":342,"name":"throw","containerName":"version"},{"line":342,"kind":13,"name":"$self","containerName":"version"},{"name":"veto_change","containerName":"version","line":342,"kind":12},{"line":342,"kind":13,"name":"$ret","containerName":"version"},{"line":343,"kind":13,"containerName":"version","name":"$ret"},{"kind":13,"line":343,"name":"$ret","containerName":"version"},{"containerName":"version","name":"$ret","kind":13,"line":344},{"kind":13,"line":344,"name":"$self","containerName":"version"},{"line":346,"kind":13,"name":"$ret","containerName":"version"}],"containerName":"main::","definition":"sub","name":"version","range":{"end":{"character":9999,"line":347},"start":{"line":338,"character":0}}},{"line":340,"kind":12,"name":"SUPER","containerName":"version"},{"kind":12,"line":344,"name":"SUPER","containerName":"version"},{"containerName":"main::","name":"is_obsolete","definition":"sub","range":{"start":{"character":0,"line":363},"end":{"line":372,"character":9999}},"kind":12,"line":363,"children":[{"localvar":"my","containerName":"is_obsolete","definition":"my","name":"$self","line":364,"kind":13},{"line":365,"kind":13,"localvar":"my","definition":"my","name":"$ret","containerName":"is_obsolete"},{"containerName":"is_obsolete","name":"$self","line":365,"kind":13},{"name":"$self","containerName":"is_obsolete","kind":13,"line":367},{"line":367,"kind":12,"name":"throw","containerName":"is_obsolete"},{"name":"$self","containerName":"is_obsolete","line":367,"kind":13},{"kind":12,"line":367,"containerName":"is_obsolete","name":"veto_change"},{"line":367,"kind":13,"containerName":"is_obsolete","name":"$ret"},{"line":368,"kind":13,"containerName":"is_obsolete","name":"$ret"},{"containerName":"is_obsolete","name":"$ret","line":368,"kind":13},{"kind":13,"line":369,"name":"$ret","containerName":"is_obsolete"},{"containerName":"is_obsolete","name":"$self","line":369,"kind":13},{"line":371,"kind":13,"name":"$ret","containerName":"is_obsolete"}]},{"name":"SUPER","containerName":"is_obsolete","line":365,"kind":12},{"containerName":"is_obsolete","name":"SUPER","line":369,"kind":12},{"name":"comment","definition":"sub","containerName":"main::","range":{"end":{"line":396,"character":9999},"start":{"character":0,"line":387}},"kind":12,"children":[{"containerName":"comment","definition":"my","name":"$self","localvar":"my","kind":13,"line":388},{"kind":13,"line":389,"name":"$ret","definition":"my","containerName":"comment","localvar":"my"},{"name":"$self","containerName":"comment","kind":13,"line":389},{"name":"$self","containerName":"comment","line":391,"kind":13},{"name":"throw","containerName":"comment","line":391,"kind":12},{"name":"$self","containerName":"comment","kind":13,"line":391},{"containerName":"comment","name":"veto_change","line":391,"kind":12},{"kind":13,"line":391,"containerName":"comment","name":"$ret"},{"containerName":"comment","name":"$ret","line":392,"kind":13},{"kind":13,"line":392,"name":"$ret","containerName":"comment"},{"kind":13,"line":393,"containerName":"comment","name":"$ret"},{"line":393,"kind":13,"containerName":"comment","name":"$self"},{"containerName":"comment","name":"$ret","kind":13,"line":395}],"line":387},{"line":389,"kind":12,"name":"SUPER","containerName":"comment"},{"kind":12,"line":393,"containerName":"comment","name":"SUPER"},{"detail":"($self,$value,$expected_class)","signature":{"label":"_check_class($self,$value,$expected_class)","documentation":"1;\n# $Id: RelationshipType.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::RelationshipType  \n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::RelationshipType  - a relationship type for an ontology\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis class can be used to model various types of relationships\n(such as \"IS_A\", \"PART_OF\", \"CONTAINS\", \"FOUND_IN\", \"RELATED_TO\").\n\nThis class extends L<Bio::Ontology::Term>, so it essentially is-a\nL<Bio::Ontology::TermI>. In addition, all methods are overridden such\nas to make the object immutable.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::RelationshipType;\nuse strict;\n\n\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant IS_A       => \"IS_A\";\nuse constant CONTAINS   => \"CONTAINS\";\nuse constant FOUND_IN   => \"FOUND_IN\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Ontology::Term);\n\n\n#\n# cache for terms\n#\nmy %term_name_map = ();\n\n\n=head2 get_instance\n\n Title   : get_instance\n Usage   : $IS_A       = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n           $PART_OF    = Bio::Ontology::RelationshipType->get_instance( \"PART_OF\" );\n           $RELATED_TO = Bio::Ontology::RelationshipType->get_instance( \"RELATED_TO\" );\n           $CONTAINS   = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n           $FOUND_IN   = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n Function: Factory method to create instances of RelationshipType\n Returns : [Bio::Ontology::RelationshipType]\n Args    : \"IS_A\" or \"PART_OF\" or \"CONTAINS\" or \"FOUND_IN\" or \n           \"RELATED_TO\" [scalar]\n           the ontology [Bio::Ontology::OntologyI] (optional)\n\n\nsub get_instance {\n    my ( $class, $name, $ont ) = @_;\n\n    $class->throw(\"must provide predicate name\") unless $name;\n\n    # is one in the cache?\n    my $reltype = $term_name_map{$name};\n\n    if($reltype &&\n       # check whether ontologies match\n       (($ont && $reltype->ontology() &&\n\t ($ont->name() eq $reltype->ontology->name())) ||\n\t(! ($reltype->ontology() || $ont)))) {\n\t# we're done, return cached type\n\treturn $reltype;\n    }\n    # valid relationship type?\n\n#\n#see the cell ontology.  this code is too strict, even for dag-edit files. -allen\n#\n#    if ( ! (($name eq IS_A) || ($name eq PART_OF) ||\n#\t    ($name eq CONTAINS) || ( $name eq FOUND_IN ))) {\n#        my $msg = \"Found unknown type of relationship: [\" . $name . \"]\\n\";\n#        $msg .= \"Known types are: [\" . IS_A . \"], [\" . PART_OF . \"], [\" . CONTAINS . \"], [\" . FOUND_IN . \"]\";\n#        $class->throw( $msg );\n#    }\n    # if we get here we need to create the rel.type\n    $reltype = $class->new(-name     => $name,\n\t\t\t   -ontology => $ont);\n    # cache it (FIXME possibly overrides one from another ontology)\n    $term_name_map{$name} = $reltype;\n    return $reltype;\n} # get_instance\n\n\n=head2 init\n\n Title   : init()\n Usage   : $type->init();\n Function: Initializes this to all undef and empty lists.\n Returns :\n Args    :\n\n\nsub init {\n    my $self = shift;\n\n    $self->SUPER::init();\n\n    # at this point we don't really need to do anything special for us\n} # init\n\n\n=head2 equals\n\n Title   : equals\n Usage   : if ( $type->equals( $other_type ) ) { ...\n Function: Compares this type to another one, based on string \"eq\" of\n           the \"identifier\" field, if at least one of the two types has\n           the identifier set, or string eq of the name otherwise.\n Returns : true or false\n Args    : [Bio::Ontology::RelationshipType]\n\n\nsub equals {\n    my( $self, $type ) = @_;\n\n    $self->_check_class( $type, \"Bio::Ontology::RelationshipType\" );\n\n    if ( $self->identifier() xor $type->identifier() ) {\n        $self->warn(\"comparing relationship types when only \".\n\t\t    \"one has an identifier will always return false\" );\n    }\n\n    return\n \t($self->identifier() || $type->identifier()) ?\n\t$self->identifier() eq $type->identifier() :\n\t$self->name() eq $type->name();\n\t\n} # equals\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"IS_A\" );\n           or\n           print $term->identifier();\n Function: Set/get for the immutable identifier of this Type.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n    my $ret = $self->SUPER::identifier();\n    if(@_) {\n\t$self->throw($self->veto_change(\"identifier\",$ret,$_[0]))\n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::identifier(@_);\n    }\n    return $ret;\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"is a type\" );\n           or\n           print $term->name();\n Function: Set/get for the immutable name of this Type.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n    my $ret = $self->SUPER::name();\n    if(@_) {\n\t$self->throw($self->veto_change(\"name\",$ret,$_[0]))\n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::name(@_);\n    }\n    return $ret;\n} # name\n\n\n\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"\" );\n           or\n           print $term->definition();\n Function: Set/get for the immutable definition of this Type.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n    my $ret = $self->SUPER::definition();\n    if(@_) {\n\t$self->veto_change(\"definition\",$ret,$_[0]) \n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::definition(@_);\n    }\n    # let's be nice and return something readable here\n    return $ret if $ret;\n    return $self->name().\" relationship predicate (type)\" if $self->name();\n} # definition\n\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $term->ontology( $top );\n           or\n           $top = $term->ontology();\n Function: Set/get for the ontology this relationship type lives in.\n Returns : The ontology [Bio::Ontology::OntologyI].\n Args    : On set, the ontology [Bio::Ontology::OntologyI] (optional).\n\n\nsub ontology {\n    my $self = shift;\n    my $ret = $self->SUPER::ontology();\n    if(@_) {\n\tmy $ont = shift;\n\tif($ret) {\n\t    $self->throw($self->veto_change(\"ontology\",$ret->name,\n\t\t\t\t\t    $ont ? $ont->name : $ont))\n\t\tunless $ont && ($ont->name() eq $ret->name());\n\t}\n\t$ret = $self->SUPER::ontology($ont,@_);\n    }\n    return $ret;\n} # category\n\n\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for immutable version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n    my $ret = $self->SUPER::version();\n    if(@_) {\n\t$self->throw($self->veto_change(\"version\",$ret,$_[0]))\n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::version(@_);\n    }\n    return $ret;\n} # version\n\n\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the immutable obsoleteness of this Type.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete {\n    my $self = shift;\n    my $ret = $self->SUPER::is_obsolete();\n    if(@_) {\n\t$self->throw($self->veto_change(\"is_obsolete\",$ret,$_[0]))\n\t    if $ret && ($ret != $_[0]);\n\t$ret = $self->SUPER::is_obsolete(@_);\n    }\n    return $ret;\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary immutable comment about this Type.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment {\n    my $self = shift;\n    my $ret = $self->SUPER::comment();\n    if(@_) {\n\t$self->throw($self->veto_change(\"comment\",$ret,$_[0]))\n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::comment(@_);\n    }\n    return $ret;\n} # comment\n\n=head1 Private methods \n\nMay be overridden in a derived class, but should never be called from\noutside.","parameters":[{"label":"$self"},{"label":"$value"},{"label":"$expected_class"}]},"containerName":"main::","definition":"sub","line":405,"children":[{"containerName":"_check_class","name":"$self","definition":"my","localvar":"my","kind":13,"line":406},{"line":406,"kind":13,"name":"$value","containerName":"_check_class"},{"name":"$expected_class","containerName":"_check_class","kind":13,"line":406},{"kind":13,"line":408,"containerName":"_check_class","name":"$value"},{"kind":13,"line":409,"name":"$self","containerName":"_check_class"},{"containerName":"_check_class","name":"throw","kind":12,"line":409},{"containerName":"_check_class","name":"$value","kind":13,"line":411},{"containerName":"_check_class","name":"$self","kind":13,"line":412},{"name":"throw","containerName":"_check_class","line":412,"kind":12},{"containerName":"_check_class","name":"$value","line":414,"kind":13},{"containerName":"_check_class","name":"isa","line":414,"kind":12},{"containerName":"_check_class","name":"$expected_class","kind":13,"line":414},{"line":415,"kind":13,"containerName":"_check_class","name":"$self"},{"name":"throw","containerName":"_check_class","kind":12,"line":415},{"line":415,"kind":13,"name":"$value","containerName":"_check_class"}],"kind":12,"range":{"end":{"line":418,"character":9999},"start":{"character":0,"line":405}},"name":"_check_class"},{"definition":"sub","containerName":"main::","signature":{"label":"veto_change($self,$attr,$old,$new)","parameters":[{"label":"$self"},{"label":"$attr"},{"label":"$old"},{"label":"$new"}],"documentation":"1;\n# $Id: RelationshipType.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::RelationshipType  \n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::RelationshipType  - a relationship type for an ontology\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis class can be used to model various types of relationships\n(such as \"IS_A\", \"PART_OF\", \"CONTAINS\", \"FOUND_IN\", \"RELATED_TO\").\n\nThis class extends L<Bio::Ontology::Term>, so it essentially is-a\nL<Bio::Ontology::TermI>. In addition, all methods are overridden such\nas to make the object immutable.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::RelationshipType;\nuse strict;\n\n\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant IS_A       => \"IS_A\";\nuse constant CONTAINS   => \"CONTAINS\";\nuse constant FOUND_IN   => \"FOUND_IN\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Ontology::Term);\n\n\n#\n# cache for terms\n#\nmy %term_name_map = ();\n\n\n=head2 get_instance\n\n Title   : get_instance\n Usage   : $IS_A       = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n           $PART_OF    = Bio::Ontology::RelationshipType->get_instance( \"PART_OF\" );\n           $RELATED_TO = Bio::Ontology::RelationshipType->get_instance( \"RELATED_TO\" );\n           $CONTAINS   = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n           $FOUND_IN   = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n Function: Factory method to create instances of RelationshipType\n Returns : [Bio::Ontology::RelationshipType]\n Args    : \"IS_A\" or \"PART_OF\" or \"CONTAINS\" or \"FOUND_IN\" or \n           \"RELATED_TO\" [scalar]\n           the ontology [Bio::Ontology::OntologyI] (optional)\n\n\nsub get_instance {\n    my ( $class, $name, $ont ) = @_;\n\n    $class->throw(\"must provide predicate name\") unless $name;\n\n    # is one in the cache?\n    my $reltype = $term_name_map{$name};\n\n    if($reltype &&\n       # check whether ontologies match\n       (($ont && $reltype->ontology() &&\n\t ($ont->name() eq $reltype->ontology->name())) ||\n\t(! ($reltype->ontology() || $ont)))) {\n\t# we're done, return cached type\n\treturn $reltype;\n    }\n    # valid relationship type?\n\n#\n#see the cell ontology.  this code is too strict, even for dag-edit files. -allen\n#\n#    if ( ! (($name eq IS_A) || ($name eq PART_OF) ||\n#\t    ($name eq CONTAINS) || ( $name eq FOUND_IN ))) {\n#        my $msg = \"Found unknown type of relationship: [\" . $name . \"]\\n\";\n#        $msg .= \"Known types are: [\" . IS_A . \"], [\" . PART_OF . \"], [\" . CONTAINS . \"], [\" . FOUND_IN . \"]\";\n#        $class->throw( $msg );\n#    }\n    # if we get here we need to create the rel.type\n    $reltype = $class->new(-name     => $name,\n\t\t\t   -ontology => $ont);\n    # cache it (FIXME possibly overrides one from another ontology)\n    $term_name_map{$name} = $reltype;\n    return $reltype;\n} # get_instance\n\n\n=head2 init\n\n Title   : init()\n Usage   : $type->init();\n Function: Initializes this to all undef and empty lists.\n Returns :\n Args    :\n\n\nsub init {\n    my $self = shift;\n\n    $self->SUPER::init();\n\n    # at this point we don't really need to do anything special for us\n} # init\n\n\n=head2 equals\n\n Title   : equals\n Usage   : if ( $type->equals( $other_type ) ) { ...\n Function: Compares this type to another one, based on string \"eq\" of\n           the \"identifier\" field, if at least one of the two types has\n           the identifier set, or string eq of the name otherwise.\n Returns : true or false\n Args    : [Bio::Ontology::RelationshipType]\n\n\nsub equals {\n    my( $self, $type ) = @_;\n\n    $self->_check_class( $type, \"Bio::Ontology::RelationshipType\" );\n\n    if ( $self->identifier() xor $type->identifier() ) {\n        $self->warn(\"comparing relationship types when only \".\n\t\t    \"one has an identifier will always return false\" );\n    }\n\n    return\n \t($self->identifier() || $type->identifier()) ?\n\t$self->identifier() eq $type->identifier() :\n\t$self->name() eq $type->name();\n\t\n} # equals\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"IS_A\" );\n           or\n           print $term->identifier();\n Function: Set/get for the immutable identifier of this Type.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n    my $ret = $self->SUPER::identifier();\n    if(@_) {\n\t$self->throw($self->veto_change(\"identifier\",$ret,$_[0]))\n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::identifier(@_);\n    }\n    return $ret;\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"is a type\" );\n           or\n           print $term->name();\n Function: Set/get for the immutable name of this Type.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n    my $ret = $self->SUPER::name();\n    if(@_) {\n\t$self->throw($self->veto_change(\"name\",$ret,$_[0]))\n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::name(@_);\n    }\n    return $ret;\n} # name\n\n\n\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"\" );\n           or\n           print $term->definition();\n Function: Set/get for the immutable definition of this Type.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n    my $ret = $self->SUPER::definition();\n    if(@_) {\n\t$self->veto_change(\"definition\",$ret,$_[0]) \n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::definition(@_);\n    }\n    # let's be nice and return something readable here\n    return $ret if $ret;\n    return $self->name().\" relationship predicate (type)\" if $self->name();\n} # definition\n\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $term->ontology( $top );\n           or\n           $top = $term->ontology();\n Function: Set/get for the ontology this relationship type lives in.\n Returns : The ontology [Bio::Ontology::OntologyI].\n Args    : On set, the ontology [Bio::Ontology::OntologyI] (optional).\n\n\nsub ontology {\n    my $self = shift;\n    my $ret = $self->SUPER::ontology();\n    if(@_) {\n\tmy $ont = shift;\n\tif($ret) {\n\t    $self->throw($self->veto_change(\"ontology\",$ret->name,\n\t\t\t\t\t    $ont ? $ont->name : $ont))\n\t\tunless $ont && ($ont->name() eq $ret->name());\n\t}\n\t$ret = $self->SUPER::ontology($ont,@_);\n    }\n    return $ret;\n} # category\n\n\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for immutable version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n    my $ret = $self->SUPER::version();\n    if(@_) {\n\t$self->throw($self->veto_change(\"version\",$ret,$_[0]))\n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::version(@_);\n    }\n    return $ret;\n} # version\n\n\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the immutable obsoleteness of this Type.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete {\n    my $self = shift;\n    my $ret = $self->SUPER::is_obsolete();\n    if(@_) {\n\t$self->throw($self->veto_change(\"is_obsolete\",$ret,$_[0]))\n\t    if $ret && ($ret != $_[0]);\n\t$ret = $self->SUPER::is_obsolete(@_);\n    }\n    return $ret;\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary immutable comment about this Type.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment {\n    my $self = shift;\n    my $ret = $self->SUPER::comment();\n    if(@_) {\n\t$self->throw($self->veto_change(\"comment\",$ret,$_[0]))\n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::comment(@_);\n    }\n    return $ret;\n} # comment\n\n=head1 Private methods \n\nMay be overridden in a derived class, but should never be called from\noutside.\n\n\nsub _check_class {\n    my ( $self, $value, $expected_class ) = @_;\n\n    if ( ! defined( $value ) ) {\n        $self->throw( \"Found [undef] where [$expected_class] expected\" );\n    }\n    elsif ( ! ref( $value ) ) {\n        $self->throw( \"Found [scalar] where [$expected_class] expected\" );\n    }\n    elsif ( ! $value->isa( $expected_class ) ) {\n        $self->throw( \"Found [\" . ref( $value ) . \"] where [$expected_class] expected\" );\n    }\n\n} # _check_type\n\n=head2 veto_change\n\n Title   : veto_change\n Usage   :\n Function: Called if an attribute is changed. Setting an attribute is\n           considered a change if it had a value before and the attempt\n           to set it would change the value.\n\n           This method returns the message to be printed in the exception.\n\n Example :\n Returns : A string\n Args    : The name of the attribute that was attempted to change.\n           Optionally, the old value and the new value for reporting\n           purposes only."},"detail":"($self,$attr,$old,$new)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"veto_change","line":439,"kind":13},{"line":439,"kind":13,"name":"$attr","containerName":"veto_change"},{"name":"$old","containerName":"veto_change","line":439,"kind":13},{"containerName":"veto_change","name":"$new","kind":13,"line":439},{"containerName":"veto_change","name":"$changetype","definition":"my","localvar":"my","kind":13,"line":441},{"kind":13,"line":441,"containerName":"veto_change","name":"$old"},{"name":"$new","containerName":"veto_change","kind":13,"line":441},{"line":442,"kind":13,"localvar":"my","definition":"my","name":"$msg","containerName":"veto_change"},{"containerName":"veto_change","name":"$self","line":442,"kind":13},{"kind":13,"line":444,"containerName":"veto_change","name":"$msg"},{"line":444,"kind":13,"containerName":"veto_change","name":"$old"},{"kind":13,"line":444,"name":"$new","containerName":"veto_change"},{"containerName":"veto_change","name":"$msg","line":445,"kind":13}],"line":438,"name":"veto_change","range":{"end":{"character":9999,"line":446},"start":{"character":0,"line":438}}}]}