{"version":5,"vars":[{"kind":2,"line":91,"containerName":"","name":"base"},{"range":{"end":{"line":128,"character":9999},"start":{"line":114,"character":0}},"name":"new","line":114,"children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":116},{"kind":13,"line":116,"containerName":"new","name":"@args"},{"name":"$self","definition":"my","containerName":"new","localvar":"my","kind":13,"line":118},{"containerName":"new","name":"$class","line":118,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":118},{"line":120,"kind":13,"localvar":"my","definition":"my","name":"$distance","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":121},{"kind":12,"line":121,"name":"_rearrange","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":122},{"name":"$distance","containerName":"new","kind":13,"line":124},{"name":"$self","containerName":"new","line":124,"kind":13},{"containerName":"new","name":"distance","kind":12,"line":124},{"line":124,"kind":13,"containerName":"new","name":"$distance"},{"line":126,"kind":13,"containerName":"new","name":"$self"}],"kind":12,"detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Path.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Path\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net> \n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Path - a path for an ontology term graph\n\n=head1 SYNOPSIS\n\n  $path = Bio::Ontology::Path->new( -identifier     => \"16847\",\n                                    -subject_term   => $subj,\n                                    -object_term    => $obj,\n                                    -predicate_term => $pred,\n                                    -distance       => 3 );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::PathI.\n\nEssiantially this is a very thin extension of\nL<Bio::Ontology::Relationship>. It basically adds a method distance().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Hilmar Lapp <hlapp@gmx.net>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Path;\nuse strict;\n\nuse base qw(Bio::Ontology::Relationship Bio::Ontology::PathI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Path->new(-identifier   => \"16847\",\n                                           -subject_term => $subject,\n                                           -object_term  => $object,\n                                           -predicate_term => $type );\n                                           -distance     => 3 );\n Function: Creates a new Bio::Ontology::Path.\n Returns : A new Bio::Ontology::Path object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]\n           -distance       => the distance between subject and object","parameters":[{"label":"$class"},{"label":"@args"}]},"containerName":"main::","definition":"sub"},{"containerName":"new","name":"SUPER","line":118,"kind":12},{"name":"init","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":148},"start":{"line":142,"character":0}},"kind":12,"children":[{"containerName":"init","definition":"my","name":"$self","localvar":"my","kind":13,"line":143},{"kind":13,"line":145,"containerName":"init","name":"$self"},{"name":"$self","containerName":"init","kind":13,"line":146}],"line":142},{"line":145,"kind":12,"containerName":"init","name":"SUPER"},{"kind":12,"line":169,"children":[{"definition":"my","name":"$self","containerName":"distance","localvar":"my","kind":13,"line":170},{"line":172,"kind":13,"name":"$self","containerName":"distance"},{"name":"$self","containerName":"distance","line":173,"kind":13}],"containerName":"main::","name":"distance","definition":"sub","range":{"start":{"character":0,"line":169},"end":{"line":174,"character":9999}}},{"kind":12,"children":[{"line":187,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"to_string"},{"line":189,"kind":13,"localvar":"my","definition":"my","name":"$s","containerName":"to_string"},{"name":"$self","containerName":"to_string","kind":13,"line":189},{"containerName":"to_string","name":"$s","kind":13,"line":190},{"containerName":"to_string","name":"$s","kind":13,"line":191},{"name":"$self","containerName":"to_string","kind":13,"line":191},{"containerName":"to_string","name":"distance","kind":12,"line":191},{"name":"$self","containerName":"to_string","kind":13,"line":191},{"line":191,"kind":12,"containerName":"to_string","name":"distance"},{"containerName":"to_string","name":"$s","line":192,"kind":13},{"containerName":"to_string","name":"$s","line":194,"kind":13}],"line":186,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Path.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Path\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net> \n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Path - a path for an ontology term graph\n\n=head1 SYNOPSIS\n\n  $path = Bio::Ontology::Path->new( -identifier     => \"16847\",\n                                    -subject_term   => $subj,\n                                    -object_term    => $obj,\n                                    -predicate_term => $pred,\n                                    -distance       => 3 );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::PathI.\n\nEssiantially this is a very thin extension of\nL<Bio::Ontology::Relationship>. It basically adds a method distance().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Hilmar Lapp <hlapp@gmx.net>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Path;\nuse strict;\n\nuse base qw(Bio::Ontology::Relationship Bio::Ontology::PathI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Path->new(-identifier   => \"16847\",\n                                           -subject_term => $subject,\n                                           -object_term  => $object,\n                                           -predicate_term => $type );\n                                           -distance     => 3 );\n Function: Creates a new Bio::Ontology::Path.\n Returns : A new Bio::Ontology::Path object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]\n           -distance       => the distance between subject and object\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $distance ) = \n\t$self->_rearrange( [qw( DISTANCE)\n\t\t\t    ], @args );\n   \n    $distance      && $self->distance($distance);\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $rel->init();   \n Function: Initializes this Path to all undef.\n Returns : \n Args    :\n\n\nsub init {\n    my $self = shift;\n    \n    $self->SUPER::init(@_);\n    $self->{ \"_distance\" } = undef;\n   \n} # init\n\n\n=head2 distance\n\n Title   : distance\n Usage   : $obj->distance($newval)\n Function: Get/set the distance between the two terms connected\n           by this path.\n\n           Note that modifying the distance may not be meaningful. The\n           implementation here is not connected to any graph engine,\n           so changing an existing value may simply render the\n           attribute's value wrong.\n\n Example : \n Returns : value of distance (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub distance{\n    my $self = shift;\n\n    return $self->{'_distance'} = shift if @_;\n    return $self->{'_distance'};\n}\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $rel->to_string();\n Function: to_string method for Path.\n Returns : A string representation of this Path.\n Args    :","parameters":[{"label":"$self"}],"label":"to_string($self)"},"detail":"($self)","name":"to_string","range":{"start":{"line":186,"character":0},"end":{"character":9999,"line":196}}},{"line":189,"kind":12,"containerName":"to_string","name":"SUPER"}]}