{"vars":[{"containerName":"","name":"base","line":118,"kind":2},{"children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":142},{"kind":13,"line":142,"containerName":"new","name":"@args"},{"line":144,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"containerName":"new","name":"$class","kind":13,"line":144},{"line":144,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"line":145,"containerName":"new","name":"$name","definition":"my","localvar":"my"},{"kind":13,"line":145,"name":"$auth","containerName":"new"},{"kind":13,"line":145,"containerName":"new","name":"$def"},{"containerName":"new","name":"$id","line":145,"kind":13},{"name":"$engine","containerName":"new","line":145,"kind":13},{"kind":13,"line":146,"name":"$self","containerName":"new"},{"kind":12,"line":146,"containerName":"new","name":"_rearrange"},{"containerName":"new","name":"@args","kind":13,"line":152},{"kind":13,"line":153,"containerName":"new","name":"$name"},{"containerName":"new","name":"$self","line":153,"kind":13},{"name":"name","containerName":"new","line":153,"kind":12},{"name":"$name","containerName":"new","line":153,"kind":13},{"kind":13,"line":154,"name":"$auth","containerName":"new"},{"containerName":"new","name":"$self","line":154,"kind":13},{"line":154,"kind":12,"containerName":"new","name":"authority"},{"line":154,"kind":13,"name":"$auth","containerName":"new"},{"kind":13,"line":155,"containerName":"new","name":"$def"},{"kind":13,"line":155,"containerName":"new","name":"$self"},{"line":155,"kind":12,"containerName":"new","name":"definition"},{"containerName":"new","name":"$def","line":155,"kind":13},{"kind":13,"line":156,"containerName":"new","name":"$id"},{"kind":13,"line":156,"name":"$self","containerName":"new"},{"line":156,"kind":12,"containerName":"new","name":"identifier"},{"containerName":"new","name":"$id","kind":13,"line":156},{"line":157,"kind":13,"name":"$engine","containerName":"new"},{"kind":13,"line":157,"name":"$self","containerName":"new"},{"kind":12,"line":157,"containerName":"new","name":"engine"},{"containerName":"new","name":"$engine","line":157,"kind":13},{"name":"$self","containerName":"new","line":159,"kind":13}],"line":141,"kind":12,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Ontology.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Ontology\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Ontology - standard implementation of an Ontology\n\n=head1 SYNOPSIS\n\n    use Bio::Ontology::Ontology;\n    use Bio::Ontology::Term;\n\n    # create ontology object\n    my $ont = Bio::Ontology::Ontology->new(-name => \"OBF\");\n\n    # add terms, relationships ...\n    my $bp = Bio::Ontology::Term->new(-identifier => '02', -name => \"Bioperl\");\n    my $obf = Bio::Ontology::Term->new(-identifier => '01', -name => \"OBF\");\n    my $partof = Bio::Ontology::RelationshipType->get_instance(\"PART_OF\");\n    $ont->add_term($bp);\n    $ont->add_term($obf);\n    $ont->add_relationship($bp, $obf, $partof);\n\n    # then query\n    my @terms = $ont->get_root_terms(); # \"OBF\"\n    my @desc = $ont->get_descendant_terms($terms[0], $partof); # \"Bioperl\"\n    # ... see methods for other ways to query\n\n    # for advanced users, you can re-use the query engine outside of an\n    # ontology to let one instance manage multiple ontologies\n    my $ont2 = Bio::Ontology::Ontology->new(-name => \"Foundations\",\n                                            -engine => $ont->engine());\n\n\n=head1 DESCRIPTION\n\nThis is a no-frills implementation of L<Bio::Ontology::OntologyI>.\n\nThe query functions are implemented by delegation to an\nOntologyEngineI implementation.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Ontology;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n#use Bio::Ontology::SimpleOntologyEngine; # loaded dynamically now!\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Ontology::Ontology->new();\n Function: Builds a new Bio::Ontology::Ontology object\n Returns : an instance of Bio::Ontology::Ontology\n Args    : any number of named arguments. The following names will be\n           recognized by this module:\n\n            -name         the name of the ontology\n            -authority    the name of the authority for the ontology\n            -identifier   an identifier for the ontology, if any\n            -engine       the Bio::Ontology::OntologyEngineI\n                          implementation that this instance should use;\n                          default is Bio::Ontology::SimpleOntologyEngine\n\n            See the corresponding get/set methods for further documentation\n            on individual properties."},"detail":"($class,@args)","definition":"sub","containerName":"main::","range":{"start":{"line":141,"character":0},"end":{"character":9999,"line":160}},"name":"new"},{"containerName":"new","name":"SUPER","kind":12,"line":144},{"name":"name","definition":"sub","containerName":"main::","range":{"start":{"line":178,"character":0},"end":{"line":183,"character":9999}},"kind":12,"children":[{"kind":13,"line":179,"name":"$self","definition":"my","containerName":"name","localvar":"my"},{"kind":13,"line":181,"containerName":"name","name":"$self"},{"containerName":"name","name":"$self","kind":13,"line":182}],"line":178},{"name":"authority","definition":"sub","containerName":"main::","range":{"start":{"line":205,"character":0},"end":{"character":9999,"line":210}},"kind":12,"children":[{"containerName":"authority","name":"$self","definition":"my","localvar":"my","kind":13,"line":206},{"kind":13,"line":208,"name":"$self","containerName":"authority"},{"line":209,"kind":13,"name":"$self","containerName":"authority"}],"line":205},{"kind":12,"children":[{"localvar":"my","containerName":"definition","name":"$self","definition":"my","line":225,"kind":13},{"containerName":"definition","name":"$self","kind":13,"line":227},{"kind":13,"line":228,"name":"$self","containerName":"definition"}],"line":224,"name":"definition","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":229},"start":{"character":0,"line":224}}},{"containerName":"main::","name":"identifier","definition":"sub","range":{"start":{"line":250,"character":0},"end":{"line":263,"character":9999}},"kind":12,"line":250,"children":[{"line":251,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"identifier"},{"line":254,"kind":13,"name":"$self","containerName":"identifier"},{"kind":12,"line":254,"containerName":"identifier","name":"throw"},{"name":"$self","containerName":"identifier","kind":13,"line":254},{"line":255,"kind":13,"name":"$self","containerName":"identifier"},{"localvar":"my","name":"$id","definition":"my","containerName":"identifier","line":256,"kind":13},{"kind":13,"line":257,"containerName":"identifier","name":"$self"},{"containerName":"identifier","name":"$id","kind":13,"line":257},{"containerName":"identifier","name":"$id","line":257,"kind":13},{"name":"$self","containerName":"identifier","kind":13,"line":259},{"kind":13,"line":260,"containerName":"identifier","name":"$self"},{"containerName":"identifier","name":"$self","kind":13,"line":262}]},{"name":"close","definition":"sub","containerName":"main::","range":{"start":{"line":281,"character":0},"end":{"line":290,"character":9999}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"close","localvar":"my","kind":13,"line":282},{"definition":"my","name":"$store","containerName":"close","localvar":"my","kind":13,"line":285},{"kind":12,"line":285,"name":"get_instance","containerName":"close"},{"line":286,"kind":13,"name":"$store","containerName":"close"},{"containerName":"close","name":"remove_ontology","line":286,"kind":12},{"kind":13,"line":286,"containerName":"close","name":"$self"},{"name":"$self","containerName":"close","kind":13,"line":288},{"containerName":"close","name":"engine","kind":12,"line":288}],"line":281},{"name":"Bio","containerName":"Ontology::OntologyStore","kind":12,"line":285},{"kind":12,"line":311,"children":[{"line":312,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"engine"},{"kind":13,"line":315,"containerName":"engine","definition":"my","name":"$engine","localvar":"my"},{"line":316,"kind":13,"containerName":"engine","name":"$engine"},{"name":"$engine","containerName":"engine","kind":13,"line":317},{"containerName":"engine","name":"$engine","kind":13,"line":318},{"name":"isa","containerName":"engine","line":318,"kind":12},{"name":"$self","containerName":"engine","kind":13,"line":319},{"name":"throw","containerName":"engine","line":319,"kind":12},{"line":319,"kind":13,"name":"$engine","containerName":"engine"},{"name":"$self","containerName":"engine","line":322,"kind":13},{"line":322,"kind":13,"containerName":"engine","name":"$engine"},{"containerName":"engine","name":"$self","kind":13,"line":323},{"line":330,"kind":13,"name":"$self","containerName":"engine"},{"containerName":"engine","name":"throw","kind":12,"line":330},{"kind":13,"line":335,"containerName":"engine","name":"$self"},{"name":"new","containerName":"engine","line":335,"kind":12},{"name":"$self","containerName":"engine","kind":13,"line":337}],"containerName":"main::","name":"engine","definition":"sub","range":{"start":{"line":311,"character":0},"end":{"character":9999,"line":338}}},{"line":329,"kind":12,"name":"Bio","containerName":"Ontology::SimpleOntologyEngine"},{"line":335,"kind":12,"containerName":"Ontology::SimpleOntologyEngine","name":"Bio"},{"kind":12,"children":[{"kind":13,"line":362,"containerName":"add_term","name":"$self","definition":"my","localvar":"my"},{"localvar":"my","containerName":"add_term","name":"$term","definition":"my","line":363,"kind":13},{"line":366,"kind":13,"name":"$term","containerName":"add_term"},{"containerName":"add_term","name":"ontology","line":366,"kind":12},{"line":366,"kind":13,"name":"$self","containerName":"add_term"},{"containerName":"add_term","name":"$term","line":366,"kind":13},{"kind":13,"line":366,"name":"$term","containerName":"add_term"},{"kind":12,"line":366,"containerName":"add_term","name":"ontology"},{"line":367,"kind":13,"containerName":"add_term","name":"$self"},{"name":"engine","containerName":"add_term","line":367,"kind":12},{"name":"add_term","containerName":"add_term","line":367,"kind":12},{"name":"$term","containerName":"add_term","line":367,"kind":13}],"line":361,"name":"add_term","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":368},"start":{"character":0,"line":361}}},{"line":383,"children":[{"definition":"my","name":"$self","containerName":"add_relationship","localvar":"my","kind":13,"line":384},{"line":385,"kind":13,"localvar":"my","containerName":"add_relationship","definition":"my","name":"$rel"},{"containerName":"add_relationship","name":"$rel","kind":13,"line":387},{"line":387,"kind":13,"name":"$rel","containerName":"add_relationship"},{"signature":{"parameters":[{"label":"$predicate"},{"label":"$object"}],"documentation":"","label":"isa($predicate,$object)"},"detail":"($predicate,$object)","containerName":"add_relationship","line":387,"kind":12,"range":{"start":{}},"name":"isa"},{"kind":13,"line":389,"containerName":"add_relationship","name":"$predicate","definition":"my","localvar":"my"},{"containerName":"add_relationship","name":"$object","line":389,"kind":13},{"name":"$rel","containerName":"add_relationship","line":390,"kind":13},{"containerName":"add_relationship","name":"new","kind":12,"line":390},{"kind":13,"line":391,"name":"$rel","containerName":"add_relationship"},{"name":"$object","containerName":"add_relationship","line":392,"kind":13},{"name":"$predicate","containerName":"add_relationship","line":393,"kind":13},{"containerName":"add_relationship","name":"$self","line":394,"kind":13},{"kind":13,"line":398,"name":"$rel","containerName":"add_relationship"},{"kind":12,"line":398,"name":"ontology","containerName":"add_relationship"},{"name":"$self","containerName":"add_relationship","kind":13,"line":398},{"containerName":"add_relationship","name":"$rel","line":398,"kind":13},{"containerName":"add_relationship","name":"ontology","line":398,"kind":12},{"kind":13,"line":399,"name":"$self","containerName":"add_relationship"},{"line":399,"kind":12,"name":"engine","containerName":"add_relationship"},{"kind":12,"line":399,"containerName":"add_relationship","name":"add_relationship"},{"containerName":"add_relationship","name":"$rel","line":399,"kind":13}],"kind":12,"range":{"start":{"line":383,"character":0},"end":{"character":9999,"line":400}},"containerName":"main::","definition":"sub","name":"add_relationship"},{"containerName":"Ontology::Relationship","name":"Bio","kind":12,"line":390},{"range":{"start":{"line":414,"character":0},"end":{"line":417,"character":9999}},"containerName":"main::","name":"get_relationship_type","definition":"sub","line":414,"children":[{"containerName":"get_relationship_type","name":"$self","definition":"my","localvar":"my","kind":13,"line":415},{"kind":13,"line":416,"containerName":"get_relationship_type","name":"$self"},{"kind":12,"line":416,"name":"engine","containerName":"get_relationship_type"},{"containerName":"get_relationship_type","name":"get_relationship_type","kind":12,"line":416}],"kind":12},{"range":{"start":{"line":432,"character":0},"end":{"line":447,"character":9999}},"name":"get_relationships","definition":"sub","containerName":"main::","children":[{"line":433,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"get_relationships"},{"localvar":"my","containerName":"get_relationships","name":"$term","definition":"my","line":434,"kind":13},{"kind":13,"line":435,"containerName":"get_relationships","name":"$term"},{"name":"$self","containerName":"get_relationships","line":437,"kind":13},{"kind":12,"line":437,"containerName":"get_relationships","name":"engine"},{"kind":12,"line":437,"name":"get_relationships","containerName":"get_relationships"},{"line":437,"kind":13,"name":"$term","containerName":"get_relationships"},{"line":440,"kind":13,"localvar":"my","definition":"my","name":"$ont","containerName":"get_relationships"},{"containerName":"get_relationships","name":"ontology","kind":12,"line":440},{"containerName":"get_relationships","name":"$ont","kind":13,"line":445},{"line":445,"kind":13,"containerName":"get_relationships","name":"$self"},{"containerName":"get_relationships","name":"$ont","kind":13,"line":445},{"line":445,"kind":12,"name":"name","containerName":"get_relationships"},{"name":"$self","containerName":"get_relationships","kind":13,"line":445},{"name":"name","containerName":"get_relationships","line":445,"kind":12},{"containerName":"get_relationships","name":"$self","line":446,"kind":13},{"containerName":"get_relationships","name":"engine","kind":12,"line":446},{"name":"get_relationships","containerName":"get_relationships","kind":12,"line":446}],"line":432,"kind":12},{"line":461,"children":[{"line":462,"kind":13,"localvar":"my","containerName":"get_predicate_terms","definition":"my","name":"$self"},{"kind":12,"line":465,"name":"ontology","containerName":"get_predicate_terms"},{"line":465,"kind":12,"containerName":"get_predicate_terms","name":"ontology"},{"name":"name","containerName":"get_predicate_terms","kind":12,"line":465},{"name":"$self","containerName":"get_predicate_terms","line":465,"kind":13},{"containerName":"get_predicate_terms","name":"name","kind":12,"line":465},{"containerName":"get_predicate_terms","name":"$self","kind":13,"line":466},{"line":466,"kind":12,"containerName":"get_predicate_terms","name":"engine"},{"kind":12,"line":466,"name":"get_predicate_terms","containerName":"get_predicate_terms"}],"kind":12,"range":{"end":{"line":467,"character":9999},"start":{"line":461,"character":0}},"containerName":"main::","name":"get_predicate_terms","definition":"sub"},{"kind":12,"children":[{"kind":12,"line":494,"name":"engine","containerName":"get_child_terms"},{"line":494,"kind":12,"containerName":"get_child_terms","name":"get_child_terms"}],"line":493,"definition":"sub","name":"get_child_terms","containerName":"main::","range":{"end":{"line":495,"character":9999},"start":{"line":493,"character":0}}},{"range":{"start":{"character":0,"line":519},"end":{"line":521,"character":9999}},"containerName":"main::","name":"get_descendant_terms","definition":"sub","line":519,"children":[{"kind":12,"line":520,"name":"engine","containerName":"get_descendant_terms"},{"name":"get_descendant_terms","containerName":"get_descendant_terms","kind":12,"line":520}],"kind":12},{"children":[{"line":548,"kind":12,"containerName":"get_parent_terms","name":"engine"},{"kind":12,"line":548,"name":"get_parent_terms","containerName":"get_parent_terms"}],"line":547,"kind":12,"range":{"end":{"character":9999,"line":549},"start":{"character":0,"line":547}},"name":"get_parent_terms","definition":"sub","containerName":"main::"},{"range":{"end":{"character":9999,"line":575},"start":{"character":0,"line":573}},"name":"get_ancestor_terms","definition":"sub","containerName":"main::","children":[{"containerName":"get_ancestor_terms","name":"engine","line":574,"kind":12},{"containerName":"get_ancestor_terms","name":"get_ancestor_terms","kind":12,"line":574}],"line":573,"kind":12},{"children":[{"localvar":"my","containerName":"get_leaf_terms","name":"$self","definition":"my","line":591,"kind":13},{"localvar":"my","name":"$ont","definition":"my","containerName":"get_leaf_terms","line":592,"kind":13},{"containerName":"get_leaf_terms","name":"ontology","kind":12,"line":592},{"kind":13,"line":597,"containerName":"get_leaf_terms","name":"$ont"},{"name":"$self","containerName":"get_leaf_terms","kind":13,"line":597},{"kind":13,"line":597,"name":"$ont","containerName":"get_leaf_terms"},{"kind":12,"line":597,"name":"name","containerName":"get_leaf_terms"},{"containerName":"get_leaf_terms","name":"$self","line":597,"kind":13},{"containerName":"get_leaf_terms","name":"name","line":597,"kind":12},{"containerName":"get_leaf_terms","name":"$self","kind":13,"line":598},{"kind":12,"line":598,"containerName":"get_leaf_terms","name":"engine"},{"containerName":"get_leaf_terms","name":"get_leaf_terms","line":598,"kind":12}],"line":590,"kind":12,"range":{"start":{"line":590,"character":0},"end":{"line":599,"character":9999}},"definition":"sub","name":"get_leaf_terms","containerName":"main::"},{"kind":12,"line":614,"children":[{"definition":"my","name":"$self","containerName":"get_root_terms","localvar":"my","kind":13,"line":615},{"line":616,"kind":13,"localvar":"my","containerName":"get_root_terms","name":"$ont","definition":"my"},{"containerName":"get_root_terms","name":"ontology","line":616,"kind":12},{"line":621,"kind":13,"name":"$ont","containerName":"get_root_terms"},{"line":621,"kind":13,"name":"$self","containerName":"get_root_terms"},{"kind":13,"line":621,"name":"$ont","containerName":"get_root_terms"},{"name":"name","containerName":"get_root_terms","kind":12,"line":621},{"name":"$self","containerName":"get_root_terms","line":621,"kind":13},{"kind":12,"line":621,"name":"name","containerName":"get_root_terms"},{"containerName":"get_root_terms","name":"$self","kind":13,"line":622},{"kind":12,"line":622,"containerName":"get_root_terms","name":"engine"},{"containerName":"get_root_terms","name":"get_root_terms","line":622,"kind":12}],"containerName":"main::","name":"get_root_terms","definition":"sub","range":{"start":{"line":614,"character":0},"end":{"line":623,"character":9999}}},{"kind":12,"children":[{"localvar":"my","containerName":"get_all_terms","definition":"my","name":"$self","line":642,"kind":13},{"containerName":"get_all_terms","name":"$ont","definition":"my","localvar":"my","kind":13,"line":643},{"name":"ontology","containerName":"get_all_terms","kind":12,"line":643},{"name":"$ont","containerName":"get_all_terms","kind":13,"line":648},{"containerName":"get_all_terms","name":"$self","line":648,"kind":13},{"containerName":"get_all_terms","name":"$ont","line":648,"kind":13},{"containerName":"get_all_terms","name":"name","kind":12,"line":648},{"containerName":"get_all_terms","name":"$self","kind":13,"line":648},{"kind":12,"line":648,"containerName":"get_all_terms","name":"name"},{"containerName":"get_all_terms","name":"$self","kind":13,"line":649},{"name":"engine","containerName":"get_all_terms","kind":12,"line":649},{"containerName":"get_all_terms","name":"get_all_terms","line":649,"kind":12}],"line":641,"definition":"sub","name":"get_all_terms","containerName":"main::","range":{"end":{"line":650,"character":9999},"start":{"line":641,"character":0}}},{"kind":12,"children":[{"containerName":"find_terms","name":"$self","definition":"my","localvar":"my","kind":13,"line":674},{"line":675,"kind":12,"name":"ontology","containerName":"find_terms"},{"containerName":"find_terms","name":"name","kind":12,"line":675},{"line":675,"kind":13,"name":"$self","containerName":"find_terms"},{"name":"name","containerName":"find_terms","kind":12,"line":675},{"containerName":"find_terms","name":"$self","line":676,"kind":13},{"containerName":"find_terms","name":"engine","line":676,"kind":12},{"kind":12,"line":676,"containerName":"find_terms","name":"find_terms"}],"line":673,"name":"find_terms","definition":"sub","containerName":"main::","range":{"start":{"line":673,"character":0},"end":{"character":9999,"line":677}}},{"kind":12,"children":[{"kind":13,"line":692,"name":"$self","definition":"my","containerName":"find_identical_terms","localvar":"my"},{"line":693,"kind":12,"containerName":"find_identical_terms","name":"ontology"},{"name":"name","containerName":"find_identical_terms","kind":12,"line":693},{"line":693,"kind":13,"containerName":"find_identical_terms","name":"$self"},{"kind":12,"line":693,"name":"name","containerName":"find_identical_terms"},{"containerName":"find_identical_terms","name":"$self","kind":13,"line":694},{"kind":12,"line":694,"name":"engine","containerName":"find_identical_terms"},{"name":"find_identical_terms","containerName":"find_identical_terms","kind":12,"line":694}],"line":691,"name":"find_identical_terms","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":691},"end":{"character":9999,"line":695}}},{"kind":12,"line":710,"children":[{"containerName":"find_similar_terms","name":"$self","definition":"my","localvar":"my","kind":13,"line":711},{"containerName":"find_similar_terms","name":"ontology","kind":12,"line":712},{"line":712,"kind":12,"containerName":"find_similar_terms","name":"name"},{"containerName":"find_similar_terms","name":"$self","line":712,"kind":13},{"line":712,"kind":12,"containerName":"find_similar_terms","name":"name"},{"kind":13,"line":713,"name":"$self","containerName":"find_similar_terms"},{"containerName":"find_similar_terms","name":"engine","line":713,"kind":12},{"name":"find_similar_terms","containerName":"find_similar_terms","kind":12,"line":713}],"containerName":"main::","name":"find_similar_terms","definition":"sub","range":{"start":{"line":710,"character":0},"end":{"line":714,"character":9999}}},{"containerName":"main::","name":"find_identically_named_terms","definition":"sub","range":{"start":{"character":0,"line":728},"end":{"line":732,"character":9999}},"kind":12,"line":728,"children":[{"localvar":"my","containerName":"find_identically_named_terms","name":"$self","definition":"my","line":729,"kind":13},{"kind":12,"line":730,"name":"ontology","containerName":"find_identically_named_terms"},{"containerName":"find_identically_named_terms","name":"name","line":730,"kind":12},{"kind":13,"line":730,"containerName":"find_identically_named_terms","name":"$self"},{"name":"name","containerName":"find_identically_named_terms","line":731,"kind":12},{"containerName":"find_identically_named_terms","name":"$self","line":731,"kind":13},{"kind":12,"line":731,"containerName":"find_identically_named_terms","name":"engine"},{"containerName":"find_identically_named_terms","name":"find_identically_named_terms","line":731,"kind":12}]},{"name":"relationship_factory","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":753},"end":{"character":9999,"line":755}},"kind":12,"children":[{"containerName":"relationship_factory","name":"engine","line":754,"kind":12},{"name":"relationship_factory","containerName":"relationship_factory","kind":12,"line":754}],"line":753},{"range":{"end":{"character":9999,"line":774},"start":{"character":0,"line":772}},"containerName":"main::","name":"term_factory","definition":"sub","line":772,"children":[{"line":773,"kind":12,"name":"engine","containerName":"term_factory"},{"line":773,"kind":12,"name":"term_factory","containerName":"term_factory"}],"kind":12},{"containerName":"main::","definition":"sub","name":"annotation","range":{"start":{"line":794,"character":0},"end":{"line":798,"character":9999}},"kind":12,"line":794,"children":[{"line":795,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"annotation"},{"line":796,"kind":13,"name":"$self","containerName":"annotation"},{"line":797,"kind":13,"name":"$self","containerName":"annotation"}]}],"version":5}