{"version":5,"vars":[{"kind":2,"line":61,"containerName":"","name":"base"},{"kind":13,"line":64,"containerName":null,"name":"@Bio"},{"line":64,"kind":12,"name":"Matrix","containerName":"PSM::PsmHeader::MASTHEADER"},{"line":66,"kind":13,"containerName":null,"name":"@Bio"},{"kind":12,"line":66,"containerName":"PSM::PsmHeader::MEMEHEADER","name":"Matrix"},{"containerName":null,"name":"@Bio","kind":13,"line":67},{"containerName":"PSM::PsmHeader::TRANSFACHEADER","name":"Matrix","kind":12,"line":67},{"kind":13,"line":68,"name":"@Bio","containerName":null},{"kind":12,"line":68,"name":"Matrix","containerName":"PSM::PsmHeader::PSIBLASTHEADER"},{"name":"@Bio","containerName":null,"kind":13,"line":69},{"containerName":"PSM::PsmHeader::ALLHEADER","name":"Matrix","kind":12,"line":69},{"name":"new","range":{"start":{"line":91,"character":0},"end":{"character":9999,"line":95}},"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: PsmHeader.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::PsmHeader - PSM mast parser implementation\n\n=head1 SYNOPSIS\n\n  # See Bio::Matrix::PSM::IO for detailed documentation on how to use\n  # PSM parsers\n\n=head1 DESCRIPTION\n\nParser for mast. This driver unlike meme or transfac for example is\ndedicated more to PSM sequence matches\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::PsmHeader;\n\nuse Bio::Matrix::PSM::InstanceSite;\n\nuse strict;\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::PsmHeaderI);\n\n#These define what structures within the\n@Bio::Matrix::PSM::PsmHeader::MASTHEADER=qw(html version release seq hid \n\t\t\t\t\t    length instances unstructured);\n@Bio::Matrix::PSM::PsmHeader::MEMEHEADER=qw(html version release hid weight length unstructured);\n@Bio::Matrix::PSM::PsmHeader::TRANSFACHEADER=qw(unstructured version release);\n@Bio::Matrix::PSM::PsmHeader::PSIBLASTHEADER=qw(seq width ic);\n@Bio::Matrix::PSM::PsmHeader::ALLHEADER=qw(header release type version html \n\t\t\t\t\t   release weight length id \n\t\t\t\t\t   seq instances unstructured);\n\n=head2 new\n\n Title   : new\n Usage   : my $header= Bio::Matrix::PSM::PsmHeader->new(-seq=>\\%seq, \n\t\t\t\t\t\t       -mid=>\\%mid, \n\t\t\t\t\t\t       -width=>\\%width,\n                                                       -instances=>\\%instances,\n\t\t\t\t\t\t       -header=>\\@header,\n\t\t\t\t\t\t       -type=>'mast');\n Function: Creates a new Bio::Matrix::PSM::PsmHeader object\n Throws  :\n Example :\n Returns :  Bio::Matrix::PSM::PsmHeader object\n Args    :  hash"},"detail":"($class,@args)","kind":12,"children":[{"kind":13,"line":92,"name":"$class","definition":"my","containerName":"new","localvar":"my"},{"name":"@args","containerName":"new","line":92,"kind":13},{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":93,"kind":13},{"name":"$class","containerName":"new","line":93,"kind":13},{"line":93,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":94,"name":"$self","containerName":"new"}],"line":91},{"line":93,"kind":12,"name":"SUPER","containerName":"new"},{"definition":"sub","name":"_initialize","containerName":"main::","range":{"end":{"line":103,"character":9999},"start":{"line":98,"character":0}},"kind":12,"children":[{"line":99,"kind":13,"localvar":"my","containerName":"_initialize","definition":"my","name":"$self"},{"kind":13,"line":100,"containerName":"_initialize","name":"$type","definition":"my","localvar":"my"},{"line":100,"kind":13,"containerName":"_initialize","name":"$self"},{"line":101,"kind":13,"name":"$type","containerName":"_initialize"},{"kind":13,"line":102,"name":"$self","containerName":"_initialize"},{"line":102,"kind":13,"containerName":"_initialize","name":"$type"},{"kind":13,"line":103,"containerName":"_initialize","definition":"my","name":"$dat","localvar":"my"},{"name":"$self","containerName":"_initialize","kind":13,"line":103}],"line":98},{"kind":12,"line":102,"name":"_type"},{"name":"unstructured","kind":12,"line":103},{"containerName":null,"name":"$dat","kind":13,"line":104},{"line":104,"kind":13,"containerName":null,"name":"%dat"},{"containerName":null,"name":"%self","line":105,"kind":13},{"line":105,"kind":12,"name":"version"},{"line":105,"kind":13,"name":"@dat","containerName":null},{"kind":13,"line":106,"containerName":null,"name":"%self"},{"line":106,"kind":12,"name":"version"},{"line":107,"kind":13,"containerName":null,"name":"%self"},{"name":"version","line":107,"kind":12},{"name":"$dat","containerName":null,"line":109,"kind":13},{"name":"%dat","containerName":null,"kind":13,"line":109},{"line":110,"kind":13,"localvar":"my","containerName":null,"name":"$rel","definition":"my"},{"line":110,"kind":13,"containerName":null,"name":"@dat"},{"containerName":null,"name":"$rel","line":111,"kind":13},{"kind":13,"line":112,"containerName":null,"name":"$rel"},{"line":113,"kind":13,"name":"%rel","containerName":null},{"containerName":null,"name":"$time","definition":"my","localvar":"my","kind":13,"line":114},{"line":114,"kind":13,"containerName":null,"name":"@rel"},{"kind":13,"line":115,"containerName":null,"name":"$dat","definition":"my","localvar":"my"},{"name":"@rel","containerName":null,"line":115,"kind":13},{"kind":13,"line":116,"containerName":null,"name":"%self"},{"kind":12,"line":116,"name":"release"},{"name":"%self","containerName":null,"kind":13,"line":118},{"kind":12,"line":118,"name":"release"},{"line":118,"kind":13,"containerName":null,"name":"$rel"},{"containerName":null,"name":"$self","line":120,"kind":13},{"line":137,"children":[{"line":138,"kind":13,"localvar":"my","containerName":"seq","name":"$self","definition":"my"},{"kind":13,"line":139,"name":"$self","containerName":"seq"},{"containerName":"seq","name":"_check","kind":12,"line":139},{"containerName":"seq","name":"$self","line":140,"kind":13}],"kind":12,"range":{"end":{"character":9999,"line":140},"start":{"line":137,"character":0}},"containerName":"main::","definition":"sub","name":"seq"},{"name":"seq","kind":12,"line":140},{"name":"hid","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":156},"end":{"line":159,"character":9999}},"kind":12,"children":[{"line":157,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"hid"},{"line":158,"kind":13,"containerName":"hid","name":"$self"},{"containerName":"hid","name":"_check","line":158,"kind":12},{"line":159,"kind":13,"localvar":"my","containerName":"hid","definition":"my","name":"@header"},{"containerName":"hid","name":"$self","line":159,"kind":13}],"line":156},{"name":"hid","line":159,"kind":12},{"kind":13,"line":160,"name":"@header","containerName":null},{"line":177,"children":[{"line":178,"kind":13,"localvar":"my","containerName":"length","name":"$self","definition":"my"},{"kind":13,"line":179,"containerName":"length","name":"$self"},{"containerName":"length","name":"_check","kind":12,"line":179},{"line":180,"kind":13,"name":"$self","containerName":"length"}],"kind":12,"range":{"end":{"character":9999,"line":181},"start":{"character":0,"line":177}},"containerName":"main::","definition":"sub","name":"length"},{"name":"length","line":180,"kind":12},{"kind":12,"children":[{"line":197,"kind":13,"localvar":"my","containerName":"instances","definition":"my","name":"$self"},{"line":198,"kind":13,"name":"$self","containerName":"instances"},{"kind":12,"line":198,"name":"_check","containerName":"instances"},{"line":199,"kind":13,"containerName":"instances","name":"$self"}],"line":196,"definition":"sub","name":"instances","containerName":"main::","range":{"end":{"character":9999,"line":199},"start":{"character":0,"line":196}}},{"line":199,"kind":12,"name":"instances"},{"definition":"sub","name":"weight","containerName":"main::","range":{"start":{"line":216,"character":0},"end":{"character":9999,"line":219}},"kind":12,"children":[{"line":217,"kind":13,"localvar":"my","containerName":"weight","definition":"my","name":"$self"},{"name":"$self","containerName":"weight","kind":13,"line":218},{"line":218,"kind":12,"name":"_check","containerName":"weight"},{"line":219,"kind":13,"name":"$self","containerName":"weight"}],"line":216},{"line":219,"kind":12,"name":"weight"},{"containerName":"main::","name":"unstructured","definition":"sub","range":{"start":{"character":0,"line":237},"end":{"character":9999,"line":239}},"kind":12,"line":237,"children":[{"line":238,"kind":13,"localvar":"my","containerName":"unstructured","definition":"my","name":"$self"},{"kind":13,"line":239,"name":"$self","containerName":"unstructured"}]},{"name":"unstructured","kind":12,"line":239},{"range":{"start":{"character":0,"line":255},"end":{"character":9999,"line":258}},"definition":"sub","name":"version","containerName":"main::","children":[{"localvar":"my","containerName":"version","definition":"my","name":"$self","line":256,"kind":13},{"name":"$self","containerName":"version","line":257,"kind":13}],"line":255,"kind":12},{"name":"version","kind":12,"line":257},{"children":[{"name":"$self","definition":"my","containerName":"release","localvar":"my","kind":13,"line":274},{"line":275,"kind":13,"containerName":"release","name":"$self"}],"line":273,"kind":12,"range":{"end":{"character":9999,"line":276},"start":{"character":0,"line":273}},"name":"release","definition":"sub","containerName":"main::"},{"name":"release","kind":12,"line":275},{"kind":12,"line":291,"children":[{"kind":13,"line":292,"name":"$self","definition":"my","containerName":"_check","localvar":"my"},{"name":"$method","containerName":"_check","line":292,"kind":13},{"line":293,"kind":13,"localvar":"my","containerName":"_check","definition":"my","name":"$type"},{"containerName":"_check","name":"$self","kind":13,"line":293},{"line":294,"kind":13,"name":"$type","containerName":"_check"},{"containerName":"_check","name":"@Bio","kind":13,"line":296},{"kind":13,"line":297,"name":"$type","containerName":"_check"},{"name":"@Bio","containerName":"_check","line":299,"kind":13},{"containerName":"_check","name":"$type","kind":13,"line":300},{"kind":13,"line":302,"containerName":"_check","name":"@Bio"},{"kind":13,"line":303,"containerName":"_check","name":"$type"},{"line":305,"kind":13,"name":"@Bio","containerName":"_check"}],"containerName":"main::","definition":"sub","detail":"($self,$method)","signature":{"documentation":"1;\n# $Id: PsmHeader.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::PsmHeader - PSM mast parser implementation\n\n=head1 SYNOPSIS\n\n  # See Bio::Matrix::PSM::IO for detailed documentation on how to use\n  # PSM parsers\n\n=head1 DESCRIPTION\n\nParser for mast. This driver unlike meme or transfac for example is\ndedicated more to PSM sequence matches\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::PsmHeader;\n\nuse Bio::Matrix::PSM::InstanceSite;\n\nuse strict;\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::PsmHeaderI);\n\n#These define what structures within the\n@Bio::Matrix::PSM::PsmHeader::MASTHEADER=qw(html version release seq hid \n\t\t\t\t\t    length instances unstructured);\n@Bio::Matrix::PSM::PsmHeader::MEMEHEADER=qw(html version release hid weight length unstructured);\n@Bio::Matrix::PSM::PsmHeader::TRANSFACHEADER=qw(unstructured version release);\n@Bio::Matrix::PSM::PsmHeader::PSIBLASTHEADER=qw(seq width ic);\n@Bio::Matrix::PSM::PsmHeader::ALLHEADER=qw(header release type version html \n\t\t\t\t\t   release weight length id \n\t\t\t\t\t   seq instances unstructured);\n\n=head2 new\n\n Title   : new\n Usage   : my $header= Bio::Matrix::PSM::PsmHeader->new(-seq=>\\%seq, \n\t\t\t\t\t\t       -mid=>\\%mid, \n\t\t\t\t\t\t       -width=>\\%width,\n                                                       -instances=>\\%instances,\n\t\t\t\t\t\t       -header=>\\@header,\n\t\t\t\t\t\t       -type=>'mast');\n Function: Creates a new Bio::Matrix::PSM::PsmHeader object\n Throws  :\n Example :\n Returns :  Bio::Matrix::PSM::PsmHeader object\n Args    :  hash\n\n\n\nsub new {\n    my ($class,@args)=@_;\n    my $self = $class->SUPER::new(@args);\n    return $self;\n}\n\n#parse version/release info here from the unstructured array\nsub _initialize {\n    my $self = shift;\n    my $type=ref($self);\n    $type=~s/\\w+:://g;\n    $self->{_type} = $type;\n    my $dat=join(\" \",grep(/version|release/i,@{$self->{unstructured}}));\n    if ($dat && ($dat=~/version\\b/i)) {\n\t$self->{version}=substr($dat,$+[0]+1);\n\t$self->{version}=~s/\\s.+[^\\d\\.\\:\\/]//g;\n\t$self->{version}=~s/^\\D//;\n    }\n    if ($dat && ($dat=~/release\\b/i)) {\n\tmy $rel=substr($dat,$+[0]+1);\n\t$rel=~s/[^\\d\\.\\:\\/\\-]//g;\n\t$rel=~s/^\\D//;\n\tif ($rel=~/\\d\\d:\\d\\d:\\d\\d/) { #Reformat if time is available too\n\t    my $time=substr($rel,$-[0]+1);\n\t    my $dat= substr($rel,0,$-[0]);\n\t    $self->{release}=\"$dat $time\";\n\t}\n\telse {  $self->{release}=$rel; }\n    }\n    return $self;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : my %seq= $header->seq();\n Function: Returns the sequence data as a hash, indexed by a sequence ID (motif id or accession number)\n           In case the input data is a motif it would return the consenus seq for each of them (mast).\n Throws  :\n Example :\n Returns :   hash\n Args    :\n\n\n\nsub seq {\n    my $self = shift;\n    return () unless ($self->_check('seq'));\n    return %{$self->{seq}};\n}\n\n=head2 hid\n\n Title   : hid\n Usage   : my @hid= $header->hid();\n Function: Returns array with the motif ids\n Throws  :\n Example :\n Returns :   array\n Args    :\n\n\n\nsub hid {\n    my $self = shift;\n    return unless ($self->_check('hid'));\n    my @header=@{$self->{hid}};\n    return @header;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my %length= $header->length();\n Function: Returns the length of the input sequence or motifs as a hash, indexed\n           by a sequence ID (motif id or accession number)\n Throws  :\n Example :\n Returns :  hash\n Args    :\n\n\n\nsub length {\n     my $self = shift;\n     return unless ($self->_check('length'));\n    return $self->{length};\n}\n\n=head2 instances\n\n Title   : instances\n Usage   : my %instances= $header->instances();\n Function: Returns the info about the input data, contained in the header\n Throws  :\n Example :\n Returns : hash\n Args    :\n\n\n\nsub instances {\n      my $self = shift;\n      return unless ($self->_check('instances'));\n      return %{$self->{instances}};\n}\n\n=head2 weight\n\n Title   : weight\n Usage   : my %weights= $header->weight();\n Function: Returns the weights of the input sequence as a hash, indexed\n           by a sequence ID\n Throws  :\n Example :\n Returns :  hash\n Args    :\n\n\n\nsub weight {\n    my $self = shift;\n    return () unless ($self->_check('weight'));\n    return %{$self->{weight}};\n}\n\n\n=head2 unstuctured\n\n Title   : unstuctured\n Usage   : my @unstructured= $header->unstuctured();\n Function: Returns the unstructured data in the header as an array, one line per\n           array element, all control symbols are removed with \\W\n Throws  :\n Example :\n Returns :  array\n Args    :\n\n\n\nsub unstructured {\n    my $self = shift;\n    return @{$self->{unstructured}};\n}\n\n=head2 version\n\n Title   : version\n Usage   : my $version= $header->version;\n Function: Returns the version of the file being parsed if such exists\n Throws  :\n Example :\n Returns :  string\n Args    :\n\n\n\nsub version {\n    my $self = shift;\n    return $self->{version};\n}\n\n=head2 release\n\n Title   : release\n Usage   : my $release= $header->release;\n Function: Returns the release of the file being parsed if such exists\n Throws  :\n Example :\n Returns :  string\n Args    :\n\n\n\nsub release {\n    my $self = shift;\n    return $self->{release};\n}\n\n=head2 _check\n\n Title   : _check\n Usage   : if ($self->_check('weights') { #do something} else {return 0;}\n Function: Checks if the method called is aplicable to the file format\n Throws  :\n Example :\n Returns :  boolean\n Args    :  string","parameters":[{"label":"$self"},{"label":"$method"}],"label":"_check($self,$method)"},"name":"_check","range":{"start":{"line":291,"character":0},"end":{"character":9999,"line":308}}},{"line":296,"kind":12,"containerName":"PSM::PsmHeader::MEMEHEADER","name":"Matrix"},{"name":"Matrix","containerName":"PSM::PsmHeader::MASTHEADER","line":299,"kind":12},{"kind":12,"line":302,"containerName":"PSM::PsmHeader::TRANSFACHEADER","name":"Matrix"},{"containerName":"PSM::PsmHeader::PSIBLASTHEADER","name":"Matrix","kind":12,"line":305}]}