{"version":5,"vars":[{"kind":2,"line":63,"containerName":"","name":"base"},{"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"documentation":"#---------------------------------------------------------\n# $Id: transfac.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO::transfac - PSM transfac parser\n\n=head1 SYNOPSIS\n\nSee Bio::Matrix::PSM::IO for documentation\n\n=head1 DESCRIPTION\n\n#\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO::transfac;\nuse Bio::Matrix::PSM::Psm;\nuse Bio::Root::Root;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::DBLink;\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::PsmHeader Bio::Matrix::PSM::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'transfac', \n\t\t\t\t\t\t -file=>$file);\n Function: Associates a file with the appropriate parser\n Throws  :\n Example :\n Args    :\n Returns : \"Bio::Matrix::PSM::$format\"->new(@args);","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"kind":12,"line":78,"children":[{"kind":13,"line":79,"containerName":"new","definition":"my","name":"$class","localvar":"my"},{"line":79,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","name":"$line","definition":"my","containerName":"new","line":80,"kind":13},{"localvar":"my","name":"$self","definition":"my","containerName":"new","line":81,"kind":13},{"containerName":"new","name":"$class","kind":13,"line":81},{"line":81,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","name":"$file","definition":"my","containerName":"new","line":82,"kind":13},{"kind":13,"line":82,"containerName":"new","name":"$self"},{"kind":12,"line":82,"name":"_rearrange","containerName":"new"},{"kind":13,"line":82,"containerName":"new","name":"@args"},{"kind":13,"line":83,"containerName":"new","name":"$self"},{"containerName":"new","name":"_initialize_io","kind":12,"line":83},{"kind":13,"line":83,"name":"@args","containerName":"new"},{"name":"$line","containerName":"new","kind":13,"line":86},{"kind":13,"line":86,"name":"$self","containerName":"new"},{"kind":12,"line":86,"containerName":"new","name":"_readline"},{"containerName":"new","name":"$line","kind":13,"line":87},{"name":"$self","containerName":"new","line":88,"kind":13},{"containerName":"new","name":"$line","kind":13,"line":88},{"containerName":"new","name":"$line","kind":13,"line":88}],"name":"new","range":{"end":{"character":9999,"line":88},"start":{"character":0,"line":78}}},{"line":81,"kind":12,"name":"SUPER","containerName":"new"},{"kind":12,"line":88,"name":"unstructured"},{"kind":13,"line":88,"containerName":null,"name":"$line"},{"name":"$line","containerName":null,"kind":13,"line":88},{"name":"$self","containerName":null,"kind":13,"line":89},{"line":89,"kind":12,"name":"_initialize","containerName":"main::"},{"name":"$self","containerName":null,"line":90,"kind":13},{"containerName":"main::","definition":"sub","name":"next_psm","range":{"end":{"line":147,"character":9999},"start":{"line":106,"character":0}},"kind":12,"line":106,"children":[{"line":107,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"next_psm"},{"containerName":"next_psm","name":"$line","definition":"my","localvar":"my","kind":13,"line":108},{"containerName":"next_psm","name":"$self","kind":13,"line":109},{"line":110,"kind":13,"localvar":"my","containerName":"next_psm","name":"@a","definition":"my"},{"kind":13,"line":110,"name":"@c","containerName":"next_psm"},{"kind":13,"line":110,"name":"@g","containerName":"next_psm"},{"name":"@t","containerName":"next_psm","line":110,"kind":13},{"line":110,"kind":13,"name":"$id","containerName":"next_psm"},{"containerName":"next_psm","name":"$tr1","line":110,"kind":13},{"containerName":"next_psm","name":"@refs","kind":13,"line":110},{"line":110,"kind":13,"containerName":"next_psm","name":"$accn"},{"kind":13,"line":110,"name":"$bf","containerName":"next_psm"},{"kind":13,"line":110,"containerName":"next_psm","name":"$sites"},{"definition":"my","name":"$i","containerName":"next_psm","localvar":"my","kind":13,"line":111},{"name":"$line","containerName":"next_psm","kind":13,"line":112},{"kind":13,"line":112,"containerName":"next_psm","name":"$self"},{"containerName":"next_psm","name":"_readline","line":112,"kind":12},{"containerName":"next_psm","name":"$line","kind":13,"line":113},{"name":"$line","containerName":"next_psm","line":114,"kind":13},{"kind":13,"line":115,"containerName":"next_psm","name":"$a"},{"containerName":"next_psm","name":"$i","kind":13,"line":115},{"line":115,"kind":13,"name":"$c","containerName":"next_psm"},{"kind":13,"line":115,"name":"$i","containerName":"next_psm"},{"line":115,"kind":13,"name":"$g","containerName":"next_psm"},{"kind":13,"line":115,"containerName":"next_psm","name":"$i"},{"kind":13,"line":115,"name":"$t","containerName":"next_psm"},{"line":115,"kind":13,"name":"$i","containerName":"next_psm"},{"containerName":"next_psm","name":"$line","line":115,"kind":13},{"name":"$i","containerName":"next_psm","kind":13,"line":116},{"containerName":"next_psm","name":"$tr1","kind":13,"line":118},{"kind":13,"line":118,"containerName":"next_psm","name":"$accn"},{"containerName":"next_psm","name":"$line","kind":13,"line":118},{"name":"$line","containerName":"next_psm","line":118,"kind":13},{"line":119,"kind":13,"containerName":"next_psm","name":"$tr1"},{"containerName":"next_psm","name":"$bf","line":119,"kind":13},{"containerName":"next_psm","name":"$line","kind":13,"line":119},{"containerName":"next_psm","name":"$line","line":119,"kind":13},{"line":120,"kind":13,"containerName":"next_psm","name":"$tr1"},{"kind":13,"line":120,"containerName":"next_psm","name":"$id"},{"kind":13,"line":120,"containerName":"next_psm","name":"$line"},{"name":"$line","containerName":"next_psm","line":120,"kind":13},{"containerName":"next_psm","name":"$line","kind":13,"line":121},{"name":"$i","containerName":"next_psm","line":121,"kind":13},{"name":"$id","containerName":"next_psm","kind":13,"line":123},{"kind":13,"line":123,"containerName":"next_psm","name":"$accn"},{"containerName":"next_psm","name":"$self","line":124,"kind":13},{"name":"$line","containerName":"next_psm","line":127,"kind":13},{"line":127,"kind":13,"name":"$self","containerName":"next_psm"},{"containerName":"next_psm","name":"_readline","kind":12,"line":127},{"containerName":"next_psm","name":"$line","kind":13,"line":128},{"localvar":"my","definition":"my","name":"$tr1","containerName":"next_psm","line":129,"kind":13},{"name":"$ba","containerName":"next_psm","kind":13,"line":129},{"kind":13,"line":129,"containerName":"next_psm","name":"$line"},{"kind":13,"line":130,"containerName":"next_psm","name":"$sites"},{"kind":13,"line":130,"name":"$ba","containerName":"next_psm"},{"name":"$line","containerName":"next_psm","kind":13,"line":132},{"kind":13,"line":135,"name":"$ref","definition":"my","containerName":"next_psm","localvar":"my"},{"kind":13,"line":135,"name":"$self","containerName":"next_psm"},{"kind":13,"line":136,"containerName":"next_psm","name":"@refs"},{"line":137,"kind":13,"containerName":"next_psm","name":"$ref"},{"kind":13,"line":138,"containerName":"next_psm","name":"$line"},{"kind":13,"line":141,"containerName":"next_psm","name":"%matrix","definition":"my","localvar":"my"},{"kind":13,"line":141,"containerName":"next_psm","name":"$self"},{"name":"@a","containerName":"next_psm","line":141,"kind":13},{"kind":13,"line":141,"name":"@c","containerName":"next_psm"},{"line":141,"kind":13,"name":"@g","containerName":"next_psm"},{"name":"@t","containerName":"next_psm","line":141,"kind":13},{"kind":13,"line":141,"containerName":"next_psm","name":"$id"},{"line":141,"kind":13,"containerName":"next_psm","name":"$accn"},{"kind":13,"line":142,"name":"$matrix","containerName":"next_psm"},{"kind":13,"line":142,"containerName":"next_psm","name":"$sites"},{"containerName":"next_psm","name":"$sites","kind":13,"line":142},{"name":"$matrix","containerName":"next_psm","kind":13,"line":143},{"containerName":"next_psm","name":"@a","kind":13,"line":143},{"containerName":"next_psm","definition":"my","name":"$psm","localvar":"my","kind":13,"line":144},{"kind":12,"line":144,"containerName":"next_psm","name":"new"},{"kind":13,"line":144,"containerName":"next_psm","name":"%matrix"},{"localvar":"my","definition":"my","name":"$ref","containerName":"next_psm","line":145,"kind":13},{"kind":13,"line":145,"containerName":"next_psm","name":"@refs"},{"kind":13,"line":145,"name":"$psm","containerName":"next_psm"},{"kind":12,"line":145,"name":"add_Annotation","containerName":"next_psm"},{"line":145,"kind":13,"containerName":"next_psm","name":"$ref"},{"name":"$psm","containerName":"next_psm","kind":13,"line":146}]},{"kind":12,"line":109,"name":"end"},{"kind":12,"line":115,"name":"_parse_matrix"},{"kind":12,"line":124,"name":"end"},{"name":"_parse_ref","line":135,"kind":12},{"name":"_make_matrix","kind":12,"line":141},{"kind":12,"line":144,"name":"Bio","containerName":"Matrix::PSM::Psm"},{"range":{"end":{"line":166,"character":9999},"start":{"line":161,"character":0}},"containerName":"main::","definition":"sub","name":"_parse_matrix","line":161,"children":[{"line":162,"kind":13,"localvar":"my","containerName":"_parse_matrix","definition":"my","name":"$line"},{"line":163,"kind":13,"containerName":"_parse_matrix","name":"$line"},{"definition":"my","name":"$tr","containerName":"_parse_matrix","localvar":"my","kind":13,"line":164},{"kind":13,"line":164,"containerName":"_parse_matrix","name":"$a"},{"name":"$c","containerName":"_parse_matrix","line":164,"kind":13},{"containerName":"_parse_matrix","name":"$g","kind":13,"line":164},{"line":164,"kind":13,"name":"$t","containerName":"_parse_matrix"},{"containerName":"_parse_matrix","name":"$line","kind":13,"line":164},{"kind":13,"line":165,"containerName":"_parse_matrix","name":"$a"},{"containerName":"_parse_matrix","name":"$c","line":165,"kind":13},{"name":"$g","containerName":"_parse_matrix","line":165,"kind":13},{"name":"$t","containerName":"_parse_matrix","kind":13,"line":165}],"kind":12},{"children":[{"kind":13,"line":183,"containerName":"_make_matrix","definition":"my","name":"$a","localvar":"my"},{"line":183,"kind":13,"name":"$c","containerName":"_make_matrix"},{"line":183,"kind":13,"name":"$g","containerName":"_make_matrix"},{"line":183,"kind":13,"containerName":"_make_matrix","name":"$t"},{"name":"@fa","containerName":"_make_matrix","line":183,"kind":13},{"line":183,"kind":13,"containerName":"_make_matrix","name":"@fc"},{"kind":13,"line":183,"containerName":"_make_matrix","name":"@fg"},{"containerName":"_make_matrix","name":"@ft","kind":13,"line":183},{"line":183,"kind":13,"name":"@a","containerName":"_make_matrix"},{"line":183,"kind":13,"containerName":"_make_matrix","name":"@c"},{"kind":13,"line":183,"containerName":"_make_matrix","name":"@g"},{"kind":13,"line":183,"name":"@t","containerName":"_make_matrix"},{"line":184,"kind":13,"localvar":"my","definition":"my","name":"$ave","containerName":"_make_matrix"},{"localvar":"my","containerName":"_make_matrix","definition":"my","name":"$self","line":185,"kind":13},{"name":"$cA","containerName":"_make_matrix","kind":13,"line":185},{"containerName":"_make_matrix","name":"$cC","kind":13,"line":185},{"kind":13,"line":185,"containerName":"_make_matrix","name":"$cG"},{"name":"$cT","containerName":"_make_matrix","line":185,"kind":13},{"name":"$id","containerName":"_make_matrix","line":185,"kind":13},{"line":185,"kind":13,"containerName":"_make_matrix","name":"$accn"},{"definition":"my","name":"$i","containerName":"_make_matrix","localvar":"my","kind":13,"line":187},{"line":187,"kind":13,"name":"$i","containerName":"_make_matrix"},{"line":187,"kind":13,"name":"$cA","containerName":"_make_matrix"}],"line":182,"kind":12,"signature":{"label":"_make_matrix($self,$cA,$cC,$cG,$cT,$id,$accn)","documentation":"#---------------------------------------------------------\n# $Id: transfac.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO::transfac - PSM transfac parser\n\n=head1 SYNOPSIS\n\nSee Bio::Matrix::PSM::IO for documentation\n\n=head1 DESCRIPTION\n\n#\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO::transfac;\nuse Bio::Matrix::PSM::Psm;\nuse Bio::Root::Root;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::DBLink;\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::PsmHeader Bio::Matrix::PSM::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'transfac', \n\t\t\t\t\t\t -file=>$file);\n Function: Associates a file with the appropriate parser\n Throws  :\n Example :\n Args    :\n Returns : \"Bio::Matrix::PSM::$format\"->new(@args);\n\n\nsub new {\n    my ($class,@args)=@_;\n    my $line;\n    my $self = $class->SUPER::new(@args);\n    my ($file)=$self->_rearrange(['FILE'], @args);\n    $self->_initialize_io(@args) || warn \"Did you intend to use STDIN?\"; #Read only for now\n    #Remove header\n    do {\n\t$line=$self->_readline;\n\tchomp $line;\n\tpush @{$self->{unstructured}},$line if (length($line)>2); } until ($line =~ m{^//}) || (!defined($line)); #Unstructured header\n    $self->_initialize;\n    return $self;\n}\n\n\n=head2 next_psm\n\n Title   : next_psm\n Usage   : my $psm=$psmIO->next_psm();\n Function: Reads the next PSM from the input file, associated with this object\n Throws  : Upon finding a line, defining the matrix, where one or more positions\n            are not defined, see _make_matrix\n Returns : Bio::Matrix::PSM::Psm object\n Args    : none\n\n\nsub next_psm {\n    my $self=shift;\n    my $line;\n    return if ($self->{end});\n    my (@a,@c,@g,@t, $id, $tr1, @refs,$accn, $bf, $sites);\n    my $i=0;\n    while (defined( $line=$self->_readline)) {\n\tchomp($line);\n\tif ($line=~/^\\d{2}/) {\t#Begining of the frequency data\n\t    ($a[$i],$c[$i],$g[$i],$t[$i])=_parse_matrix($line);\n\t    $i++;\n\t}\n\t($tr1,$accn)=split(/\\s{2}/,$line) if ($line=~/^AC\\s/);\n\t($tr1,$bf)=split(/\\s{2}/,$line) if ($line=~/^BF\\s/);\n\t($tr1,$id)=split(/\\s{2}/,$line) if ($line=~/^ID\\s/);\n\tlast if (($line=~/^XX/) && ($i>0));\n    }\n    if (!(defined($id) && defined($accn))) {\n\t$self->{end}=1;\n\treturn;\n    }\n    while (defined( $line=$self->_readline)) {\t#How many sites?\n\tif ($line=~/^BA\\s/) {\n\t    my ($tr1,$ba)=split(/\\s{2}/,$line);\n\t    ($sites)=split(/\\s/,$ba);\n\t}\n   if ($line=~/^RN/) { #Adding a reference as Bio::Annotation object (self)\n    # not interested in RN line itself, since has only transfac-specific\n    # reference id? - no push back of line\n    my $ref=_parse_ref($self);\n    push @refs,$ref\n  }\n\tlast if ($line=~m{^//});\n    }\n    # We have the frequencies, let's create a SiteMatrix object\n    my %matrix = &_make_matrix($self,\\@a,\\@c,\\@g,\\@t,$id, $accn);\n    $matrix{-sites}=$sites if ($sites);\n    $matrix{-width}=@a;\n    my $psm=Bio::Matrix::PSM::Psm->new(%matrix);\n    foreach my $ref (@refs) { $psm->add_Annotation('reference',$ref); }\n    return $psm;\n}\n\n=head2 _parseMatrix\n\n Title   : _parseMatrix\n Usage   :\n Function: Parses a line\n Throws  :\n Example :  Internal stuff\n Returns :  array (frequencies for A,C,G,T in this order).\n Args    :  string\n\n\nsub _parse_matrix {\n    my $line=shift;\n    $line=~s/\\s+/,/g;\n    my ($tr,$a,$c,$g,$t)=split(/,/,$line);\n    return $a,$c,$g,$t;\n}\n\n\n=head2 _make_matrix\n\n Title   : _make_matrix\n Usage   :\n Function:\n Throws  :  If a position is undefined, for example if you have line like this\n            in the file you are parsing: 08  4,7,,9\n Example :  Internal stuff\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$cA"},{"label":"$cC"},{"label":"$cG"},{"label":"$cT"},{"label":"$id"},{"label":"$accn"}]},"detail":"($self,$cA,$cC,$cG,$cT,$id,$accn)","definition":"sub","containerName":"main::","range":{"end":{"line":187,"character":9999},"start":{"character":0,"line":182}},"name":"_make_matrix"},{"name":"%i","containerName":null,"kind":13,"line":187},{"line":190,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":190,"name":"throw","containerName":"main::"},{"containerName":null,"name":"$i","line":190,"kind":13},{"name":"$cA","containerName":null,"kind":13,"line":190},{"containerName":null,"name":"$cG","line":190,"kind":13},{"name":"$cC","containerName":null,"line":190,"kind":13},{"line":190,"kind":13,"containerName":null,"name":"$cT"},{"line":192,"kind":13,"containerName":null,"name":"@cA"},{"line":192,"kind":13,"containerName":null,"name":"$i"},{"containerName":null,"name":"@cC","line":192,"kind":13},{"kind":13,"line":192,"containerName":null,"name":"$i"},{"name":"@cG","containerName":null,"line":193,"kind":13},{"kind":13,"line":193,"name":"$i","containerName":null},{"containerName":null,"name":"@cT","line":193,"kind":13},{"containerName":null,"name":"%i","line":193,"kind":13},{"containerName":null,"name":"@a","line":194,"kind":13},{"name":"$ave","containerName":null,"line":194,"kind":13},{"kind":13,"line":195,"containerName":null,"name":"@c"},{"line":195,"kind":13,"containerName":null,"name":"$ave"},{"line":196,"kind":13,"name":"@g","containerName":null},{"name":"$ave","containerName":null,"line":196,"kind":13},{"containerName":null,"name":"@t","line":197,"kind":13},{"name":"%ave","containerName":null,"kind":13,"line":197},{"name":"@a","containerName":null,"kind":13,"line":200},{"line":200,"kind":13,"containerName":null,"name":"@cA"},{"containerName":null,"name":"$i","line":200,"kind":13},{"containerName":null,"name":"@c","line":201,"kind":13},{"line":201,"kind":13,"containerName":null,"name":"@cC"},{"containerName":null,"name":"$i","kind":13,"line":201},{"kind":13,"line":202,"name":"@g","containerName":null},{"kind":13,"line":202,"name":"@cG","containerName":null},{"name":"$i","containerName":null,"kind":13,"line":202},{"line":203,"kind":13,"name":"@t","containerName":null},{"line":203,"kind":13,"name":"@cT","containerName":null},{"kind":13,"line":203,"containerName":null,"name":"$i"},{"line":204,"kind":13,"name":"$ave","containerName":null},{"line":204,"kind":13,"name":"@cA","containerName":null},{"containerName":null,"name":"$i","kind":13,"line":204},{"name":"@cC","containerName":null,"kind":13,"line":204},{"kind":13,"line":204,"containerName":null,"name":"$i"},{"line":205,"kind":13,"name":"@cG","containerName":null},{"kind":13,"line":205,"name":"$i","containerName":null},{"line":205,"kind":13,"name":"@cT","containerName":null},{"containerName":null,"name":"$i","kind":13,"line":205},{"kind":13,"line":205,"containerName":null,"name":"$ave"},{"localvar":"my","containerName":null,"name":"$i","definition":"my","line":209,"kind":13},{"kind":13,"line":209,"name":"$i","containerName":null},{"line":209,"kind":13,"name":"@a","containerName":null},{"line":209,"kind":13,"name":"%i","containerName":null},{"containerName":null,"name":"$zero","definition":"my","localvar":"my","kind":13,"line":210},{"containerName":null,"name":"@a","kind":13,"line":210},{"kind":13,"line":210,"containerName":null,"name":"$i"},{"name":"@c","containerName":null,"line":210,"kind":13},{"containerName":null,"name":"$i","kind":13,"line":210},{"kind":13,"line":210,"containerName":null,"name":"@g"},{"name":"$i","containerName":null,"line":210,"kind":13},{"containerName":null,"name":"@t","line":210,"kind":13},{"kind":13,"line":210,"name":"$i","containerName":null},{"kind":13,"line":211,"containerName":null,"name":"$zero"},{"kind":13,"line":212,"containerName":null,"name":"@fa"},{"name":"@a","containerName":null,"kind":13,"line":212},{"kind":13,"line":212,"containerName":null,"name":"$i"},{"name":"@fc","containerName":null,"line":213,"kind":13},{"name":"@c","containerName":null,"kind":13,"line":213},{"line":213,"kind":13,"containerName":null,"name":"$i"},{"kind":13,"line":214,"name":"@fg","containerName":null},{"line":214,"kind":13,"name":"@g","containerName":null},{"kind":13,"line":214,"containerName":null,"name":"$i"},{"containerName":null,"name":"@ft","line":215,"kind":13},{"containerName":null,"name":"@t","line":215,"kind":13},{"containerName":null,"name":"$i","line":215,"kind":13},{"line":217,"kind":13,"name":"@fa","containerName":null},{"containerName":null,"name":"@fc","kind":13,"line":217},{"name":"@fg","containerName":null,"kind":13,"line":217},{"line":217,"kind":13,"name":"@ft","containerName":null},{"containerName":null,"name":"$id","line":217,"kind":13},{"kind":13,"line":217,"name":"$accn","containerName":null},{"range":{"end":{"character":9999,"line":258},"start":{"character":0,"line":220}},"definition":"sub","name":"_parse_ref","containerName":"main::","children":[{"containerName":"_parse_ref","name":"$self","definition":"my","localvar":"my","kind":13,"line":221},{"containerName":"_parse_ref","definition":"my","name":"$authors","localvar":"my","kind":13,"line":222},{"kind":13,"line":222,"name":"$title","containerName":"_parse_ref"},{"containerName":"_parse_ref","name":"$loc","line":222,"kind":13},{"containerName":"_parse_ref","name":"@refs","kind":13,"line":222},{"kind":13,"line":222,"containerName":"_parse_ref","name":"$tr"},{"line":222,"kind":13,"name":"$db","containerName":"_parse_ref"},{"name":"$dbid","containerName":"_parse_ref","line":222,"kind":13},{"line":223,"kind":13,"localvar":"my","containerName":"_parse_ref","definition":"my","name":"$refline"},{"line":223,"kind":13,"containerName":"_parse_ref","name":"$self"},{"containerName":"_parse_ref","name":"_readline","kind":12,"line":223},{"containerName":"_parse_ref","name":"$refline","kind":13,"line":224},{"line":225,"kind":13,"localvar":"my","definition":"my","name":"$field","containerName":"_parse_ref"},{"kind":13,"line":225,"containerName":"_parse_ref","name":"$arg"},{"kind":13,"line":225,"name":"$refline","containerName":"_parse_ref"},{"name":"$field","containerName":"_parse_ref","kind":13,"line":226},{"line":227,"kind":13,"name":"$field","containerName":"_parse_ref"},{"line":229,"kind":13,"name":"$field","containerName":"_parse_ref"},{"line":230,"kind":13,"containerName":"_parse_ref","name":"$refline"},{"line":231,"kind":13,"name":"$tr","containerName":"_parse_ref"},{"containerName":"_parse_ref","name":"$db","kind":13,"line":231},{"line":231,"kind":13,"containerName":"_parse_ref","name":"$dbid"},{"containerName":"_parse_ref","name":"$refline","line":231,"kind":13},{"containerName":"_parse_ref","name":"$field","line":234,"kind":13},{"kind":13,"line":235,"name":"$title","containerName":"_parse_ref"},{"line":235,"kind":13,"name":"$arg","containerName":"_parse_ref"},{"containerName":"_parse_ref","name":"$field","line":238,"kind":13},{"kind":13,"line":239,"name":"$authors","containerName":"_parse_ref"},{"containerName":"_parse_ref","name":"$arg","kind":13,"line":239},{"line":242,"kind":13,"name":"$field","containerName":"_parse_ref"},{"line":243,"kind":13,"name":"$loc","containerName":"_parse_ref"},{"containerName":"_parse_ref","name":"$arg","line":243,"kind":13},{"localvar":"my","containerName":"_parse_ref","name":"$reference","definition":"my","line":248,"kind":13},{"name":"new","containerName":"_parse_ref","line":248,"kind":12},{"containerName":"_parse_ref","name":"$authors","line":248,"kind":13},{"line":248,"kind":13,"containerName":"_parse_ref","name":"$title"},{"name":"$loc","containerName":"_parse_ref","kind":13,"line":249},{"name":"$db","containerName":"_parse_ref","kind":13,"line":250},{"line":252,"kind":13,"name":"$reference","containerName":"_parse_ref"},{"name":"medline","containerName":"_parse_ref","line":252,"kind":12},{"line":252,"kind":13,"name":"$dbid","containerName":"_parse_ref"},{"name":"$dbid","containerName":"_parse_ref","line":254,"kind":13},{"kind":13,"line":255,"containerName":"_parse_ref","name":"$reference"},{"name":"pubmed","containerName":"_parse_ref","kind":12,"line":255},{"line":255,"kind":13,"containerName":"_parse_ref","name":"$dbid"},{"containerName":"_parse_ref","name":"$reference","line":257,"kind":13}],"line":220,"kind":12},{"name":"REF","line":228,"kind":12},{"name":"REF","kind":12,"line":232},{"line":236,"kind":12,"name":"REF"},{"kind":12,"line":240,"name":"REF"},{"line":244,"kind":12,"name":"REF"},{"containerName":"Annotation::Reference","name":"Bio","line":248,"kind":12},{"definition":"sub","name":"DESTROY","containerName":"main::","range":{"start":{"character":0,"line":260},"end":{"line":263,"character":9999}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"DESTROY","localvar":"my","kind":13,"line":261},{"name":"$self","containerName":"DESTROY","line":262,"kind":13},{"name":"close","containerName":"DESTROY","kind":12,"line":262}],"line":260}]}