{"version":5,"vars":[{"line":69,"kind":2,"name":"base","containerName":""},{"range":{"end":{"line":158,"character":9999},"start":{"character":0,"line":88}},"name":"new","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: mast.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO::mast - PSM mast parser implementation\n\n=head1 SYNOPSIS\n\nSee Bio::Matrix::PSM::IO for detailed documentation on how to \nuse PSM parsers\n\n=head1 DESCRIPTION\n\nParser for mast. This driver unlike meme or transfac for example is\ndedicated more to PSM sequence matches, than to PSM themselves.\n\n=head1 TO DO\n\nSection III should be parsed too, otherwise no real sequence is\navailable, so we supply 'NNNNN....' as a seq which is not right.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO::mast;\nuse Bio::Matrix::PSM::InstanceSite;\nuse Bio::Matrix::PSM::Psm;\nuse Bio::Root::Root;\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::PsmHeader Bio::Matrix::PSM::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'mast', \n\t\t\t\t\t\t                               -file=>$file);\n Function: Associates a file with the appropriate parser\n Throws  : Throws if the file passed is in HTML format or if \n           some criteria for the file\n           format are not met.\n Example :\n Returns : psm object, associated with a file with matrix file\n Args    : hash\n return  : \"Bio::Matrix::PSM::$format\"->new(@args);","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":89,"definition":"my","name":"$class","containerName":"new","localvar":"my"},{"name":"@args","containerName":"new","line":89,"kind":13},{"kind":13,"line":90,"definition":"my","name":"$self","containerName":"new","localvar":"my"},{"kind":13,"line":90,"name":"$class","containerName":"new"},{"kind":13,"line":90,"name":"@args","containerName":"new"},{"kind":13,"line":91,"definition":"my","name":"%instances","containerName":"new","localvar":"my"},{"kind":13,"line":91,"name":"@header","containerName":"new"},{"line":91,"kind":13,"containerName":"new","name":"$n"},{"line":92,"kind":13,"localvar":"my","definition":"my","name":"$file","containerName":"new"},{"kind":13,"line":92,"containerName":"new","name":"$self"},{"line":92,"kind":12,"name":"_rearrange","containerName":"new"},{"containerName":"new","name":"@args","line":92,"kind":13},{"containerName":"new","name":"$self","line":93,"kind":13},{"kind":13,"line":93,"containerName":"new","name":"$file"},{"name":"$self","containerName":"new","kind":13,"line":94},{"name":"$self","containerName":"new","kind":13,"line":95},{"kind":12,"line":95,"name":"_initialize_io","containerName":"new"},{"name":"@args","containerName":"new","line":95,"kind":13},{"line":96,"kind":13,"name":"$self","containerName":"new"},{"line":97,"kind":13,"name":"$self","containerName":"new"},{"name":"$self","containerName":"new","line":98,"kind":13},{"kind":13,"line":98,"containerName":"new","name":"$file"},{"kind":13,"line":99,"containerName":"new","definition":"my","name":"$buf","localvar":"my"},{"line":99,"kind":13,"containerName":"new","name":"$self"},{"name":"_readline","containerName":"new","kind":12,"line":99},{"containerName":"new","name":"$self","kind":13,"line":100},{"containerName":"new","name":"throw","line":100,"kind":12},{"kind":13,"line":100,"name":"$buf","containerName":"new"},{"name":"$buf","containerName":"new","kind":13,"line":102},{"name":"$self","containerName":"new","kind":13,"line":102},{"containerName":"new","name":"_readline","line":102,"kind":12},{"line":103,"kind":13,"containerName":"new","name":"$buf"},{"containerName":"new","name":"$buf","line":104,"kind":13},{"containerName":"new","name":"$buf","kind":13,"line":105},{"line":105,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":105,"containerName":"new","name":"_readline"},{"line":106,"kind":13,"name":"$buf","containerName":"new"},{"line":107,"kind":13,"containerName":"new","name":"$buf"},{"kind":13,"line":108,"containerName":"new","name":"$buf"},{"line":109,"kind":13,"containerName":"new","name":"$n"},{"line":109,"kind":13,"name":"$self","containerName":"new"},{"line":109,"kind":13,"name":"$self","containerName":"new"},{"line":109,"kind":13,"name":"$buf","containerName":"new"},{"name":"$self","containerName":"new","line":110,"kind":13},{"line":112,"kind":13,"name":"$buf","containerName":"new"},{"kind":13,"line":113,"containerName":"new","name":"$buf"},{"line":114,"kind":13,"containerName":"new","name":"$buf"},{"kind":13,"line":115,"name":"$n","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":115},{"line":115,"kind":13,"name":"$self","containerName":"new"},{"line":115,"kind":13,"containerName":"new","name":"$buf"},{"kind":13,"line":116,"containerName":"new","name":"$self"},{"kind":13,"line":120,"containerName":"new","name":"$self"},{"kind":13,"line":120,"containerName":"new","name":"$self"},{"name":"$self","containerName":"new","line":121,"kind":13},{"kind":13,"line":122,"name":"$self","containerName":"new"},{"line":125,"kind":13,"containerName":"new","name":"$buf"},{"line":126,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"_readline","kind":12,"line":126},{"containerName":"new","name":"$buf","kind":13,"line":127},{"containerName":"new","name":"$self","line":127,"kind":13},{"name":"_readline","containerName":"new","line":127,"kind":12},{"line":128,"kind":13,"containerName":"new","name":"$buf"},{"name":"$buf","containerName":"new","kind":13,"line":129},{"name":"$buf","containerName":"new","kind":13,"line":130},{"containerName":"new","definition":"my","name":"$id","localvar":"my","kind":13,"line":131},{"name":"$width","containerName":"new","kind":13,"line":131},{"containerName":"new","name":"$seq","line":131,"kind":13},{"containerName":"new","name":"$buf","line":131,"kind":13},{"containerName":"new","name":"$self","line":132,"kind":13},{"containerName":"new","name":"$id","line":132,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":133},{"line":133,"kind":13,"containerName":"new","name":"$id"},{"name":"$width","containerName":"new","line":133,"kind":13},{"kind":13,"line":134,"containerName":"new","name":"$self"},{"kind":13,"line":134,"containerName":"new","name":"$id"},{"kind":13,"line":134,"containerName":"new","name":"$seq"},{"name":"$buf","containerName":"new","kind":13,"line":138},{"kind":13,"line":139,"containerName":"new","name":"$self"},{"kind":12,"line":139,"name":"_readline","containerName":"new"},{"containerName":"new","name":"$self","line":140,"kind":13},{"line":140,"kind":12,"containerName":"new","name":"_readline"},{"name":"$self","containerName":"new","kind":13,"line":141},{"kind":12,"line":141,"containerName":"new","name":"_readline"},{"containerName":"new","name":"%instances","line":142,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":142},{"kind":13,"line":143,"name":"$self","containerName":"new"},{"kind":13,"line":143,"containerName":"new","name":"%instances"},{"line":144,"kind":13,"name":"%instances","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":145},{"line":145,"kind":12,"containerName":"new","name":"warn"},{"name":"$self","containerName":"new","kind":13,"line":146},{"kind":13,"line":150,"name":"$buf","containerName":"new"},{"name":"$self","containerName":"new","line":151,"kind":13},{"containerName":"new","name":"_readline","line":151,"kind":12},{"kind":13,"line":152,"containerName":"new","name":"$self"},{"name":"_readline","containerName":"new","line":152,"kind":12},{"name":"$self","containerName":"new","kind":13,"line":153},{"containerName":"new","name":"_readline","line":153,"kind":12},{"line":156,"kind":13,"name":"$buf","containerName":"new"},{"name":"@header","containerName":"new","line":157,"kind":13},{"name":"$buf","containerName":"new","kind":13,"line":157},{"kind":13,"line":157,"containerName":"new","name":"$buf"},{"kind":13,"line":157,"containerName":"new","name":"$buf"}],"line":88,"kind":12},{"containerName":"new","name":"SUPER","kind":12,"line":90},{"name":"file","kind":12,"line":93},{"kind":12,"line":94,"name":"_factor"},{"line":96,"kind":12,"name":"_end"},{"line":97,"kind":12,"name":"hid"},{"line":109,"kind":12,"name":"_dbname"},{"name":"_dbtype","kind":12,"line":109},{"line":110,"kind":12,"name":"_dbtype"},{"name":"_mrsc","line":115,"kind":12},{"name":"_msrctype","kind":12,"line":115},{"line":116,"kind":12,"name":"_msrctype"},{"name":"_msrctype","kind":12,"line":120},{"name":"_dbtype","kind":12,"line":120},{"name":"_factor","kind":12,"line":121},{"kind":12,"line":122,"name":"_mixquery"},{"name":"hid","line":132,"kind":12},{"kind":12,"line":133,"name":"length"},{"name":"seq","kind":12,"line":134},{"name":"_get_genes","kind":12,"line":142},{"name":"instances","kind":12,"line":143},{"line":159,"kind":13,"name":"$self","containerName":null},{"line":159,"kind":12,"containerName":"main::","name":"throw"},{"containerName":null,"name":"%instances","line":159,"kind":13},{"kind":13,"line":160,"containerName":null,"name":"$self"},{"line":160,"kind":12,"name":"warn","containerName":"main::"},{"name":"@header","containerName":null,"line":160,"kind":13},{"kind":13,"line":162,"name":"%self","containerName":null},{"name":"unstructured","line":162,"kind":12},{"line":162,"kind":13,"containerName":null,"name":"@header"},{"kind":13,"line":163,"name":"$self","containerName":null},{"containerName":"main::","name":"_initialize","line":163,"kind":12},{"containerName":null,"name":"$self","line":164,"kind":13},{"definition":"sub","name":"_get_genes","containerName":"main::","range":{"end":{"character":9999,"line":194},"start":{"character":0,"line":170}},"kind":12,"children":[{"containerName":"_get_genes","name":"$self","definition":"my","localvar":"my","kind":13,"line":171},{"kind":13,"line":172,"definition":"my","name":"%llid","containerName":"_get_genes","localvar":"my"},{"containerName":"_get_genes","name":"$ok","definition":"my","localvar":"my","kind":13,"line":173},{"kind":13,"line":174,"containerName":"_get_genes","name":"$i","definition":"my","localvar":"my"},{"containerName":"_get_genes","name":"%instances","definition":"my","localvar":"my","kind":13,"line":175},{"line":176,"kind":13,"localvar":"my","definition":"my","name":"$line","containerName":"_get_genes"},{"containerName":"_get_genes","name":"$self","kind":13,"line":176},{"containerName":"_get_genes","name":"_readline","line":176,"kind":12},{"kind":13,"line":177,"containerName":"_get_genes","name":"$line"},{"containerName":"_get_genes","name":"$line","line":178,"kind":13},{"containerName":"_get_genes","name":"$i","kind":13,"line":179},{"name":"$line","containerName":"_get_genes","line":180,"kind":13},{"containerName":"_get_genes","name":"$line","kind":13,"line":181},{"kind":13,"line":182,"containerName":"_get_genes","name":"$id","definition":"my","localvar":"my"},{"kind":13,"line":182,"name":"$key","containerName":"_get_genes"},{"containerName":"_get_genes","name":"$eval","kind":13,"line":182},{"line":182,"kind":13,"containerName":"_get_genes","name":"$len"},{"name":"$line","containerName":"_get_genes","kind":13,"line":182},{"containerName":"_get_genes","name":"$len","kind":13,"line":183},{"line":187,"kind":13,"containerName":"_get_genes","name":"$instances"},{"name":"$id","containerName":"_get_genes","kind":13,"line":187},{"containerName":"_get_genes","name":"new","line":187,"kind":12},{"name":"$id","containerName":"_get_genes","line":187,"kind":13},{"containerName":"_get_genes","name":"$key","line":188,"kind":13},{"name":"$eval","containerName":"_get_genes","kind":13,"line":189},{"name":"$len","containerName":"_get_genes","line":190,"kind":13},{"line":193,"kind":13,"name":"%instances","containerName":"_get_genes"}],"line":170},{"kind":12,"line":187,"containerName":"Matrix::PSM::InstanceSite","name":"Bio"},{"containerName":"main::","name":"next_psm","definition":"sub","range":{"end":{"line":215,"character":9999},"start":{"character":0,"line":211}},"kind":12,"line":211,"children":[{"definition":"my","name":"$self","containerName":"next_psm","localvar":"my","kind":13,"line":212},{"containerName":"next_psm","name":"$self","line":213,"kind":13},{"localvar":"my","containerName":"next_psm","definition":"my","name":"@lmotifsm","line":214,"kind":13},{"line":214,"kind":13,"name":"%index","containerName":"next_psm"},{"name":"$eval","containerName":"next_psm","kind":13,"line":214},{"containerName":"next_psm","name":"$scheme","kind":13,"line":214},{"containerName":"next_psm","name":"$sid","kind":13,"line":214},{"name":"%index","containerName":"next_psm","kind":13,"line":215},{"containerName":"next_psm","name":"$self","kind":13,"line":215}]},{"name":"_end","line":213,"kind":12},{"name":"length","kind":12,"line":215},{"definition":"my","name":"@instances","containerName":null,"localvar":"my","kind":13,"line":216},{"kind":13,"line":216,"containerName":null,"name":"%instances"},{"definition":"my","name":"$line","containerName":null,"localvar":"my","kind":13,"line":217},{"line":217,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"_readline","line":217,"kind":12},{"kind":13,"line":218,"containerName":null,"name":"$line"},{"line":219,"kind":13,"containerName":null,"name":"%line"},{"name":"%self","containerName":null,"kind":13,"line":220},{"name":"_end","kind":12,"line":220},{"line":224,"kind":13,"name":"%line","containerName":null},{"containerName":null,"name":"$sid","line":225,"kind":13},{"containerName":null,"name":"$eval","line":225,"kind":13},{"containerName":null,"name":"$scheme","kind":13,"line":225},{"kind":13,"line":225,"name":"%line","containerName":null},{"kind":13,"line":228,"name":"$scheme","containerName":null},{"kind":13,"line":228,"containerName":null,"name":"$line"},{"line":229,"kind":13,"name":"$line","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":229},{"line":229,"kind":12,"name":"_readline","containerName":"main::"},{"kind":13,"line":230,"containerName":null,"name":"$line"},{"containerName":null,"name":"$line","kind":13,"line":231},{"localvar":"my","containerName":null,"name":"$pos","definition":"my","line":232,"kind":13},{"kind":13,"line":233,"containerName":null,"name":"$scheme"},{"kind":13,"line":234,"name":"$scheme","containerName":null},{"line":235,"kind":13,"localvar":"my","definition":"my","name":"@motifs","containerName":null},{"name":"$scheme","containerName":null,"line":235,"kind":13},{"line":236,"kind":13,"containerName":null,"name":"@motifs"},{"line":237,"kind":13,"localvar":"my","containerName":null,"name":"$next","definition":"my"},{"containerName":null,"name":"@motifs","kind":13,"line":237},{"containerName":null,"name":"%next","line":238,"kind":13},{"name":"@motifs","containerName":null,"kind":13,"line":239},{"line":240,"kind":13,"containerName":null,"name":"$pos"},{"name":"$next","containerName":null,"kind":13,"line":240},{"line":243,"kind":13,"localvar":"my","containerName":null,"name":"$id","definition":"my"},{"containerName":null,"name":"$next","kind":13,"line":243},{"localvar":"my","containerName":null,"name":"$score","definition":"my","line":244,"kind":13},{"containerName":null,"name":"$id","kind":13,"line":244},{"kind":13,"line":245,"name":"$frame","definition":"my","containerName":null,"localvar":"my"},{"localvar":"my","containerName":null,"definition":"my","name":"$strand","line":246,"kind":13},{"name":"$id","containerName":null,"kind":13,"line":246},{"containerName":null,"name":"%self","kind":13,"line":247},{"name":"_mixquery","kind":12,"line":247},{"name":"$frame","containerName":null,"line":248,"kind":13},{"line":248,"kind":13,"name":"$id","containerName":null},{"line":249,"kind":13,"containerName":null,"name":"$frame"},{"containerName":null,"name":"$id","kind":13,"line":249},{"line":250,"kind":13,"name":"$frame","containerName":null},{"line":250,"kind":13,"containerName":null,"name":"$id"},{"line":252,"kind":13,"name":"$id","containerName":null},{"containerName":null,"name":"@s","definition":"my","localvar":"my","kind":13,"line":254},{"containerName":null,"definition":"my","name":"$width","localvar":"my","kind":13,"line":255},{"name":"%index","containerName":null,"line":255,"kind":13},{"name":"$id","containerName":null,"kind":13,"line":255},{"definition":"my","name":"$seq","containerName":null,"localvar":"my","kind":13,"line":257},{"containerName":null,"name":"$width","line":257,"kind":13},{"kind":13,"line":257,"name":"%self","containerName":null},{"name":"_factor","kind":12,"line":257},{"kind":13,"line":258,"name":"$instance","definition":"my","containerName":null,"localvar":"my"},{"line":258,"kind":12,"containerName":"Matrix::PSM::InstanceSite","name":"Bio"},{"kind":12,"line":258,"name":"new","containerName":"main::"},{"name":"$id","containerName":null,"kind":13,"line":260},{"containerName":null,"name":"$sid","kind":13,"line":261},{"line":263,"kind":13,"name":"$score","containerName":null},{"kind":13,"line":264,"containerName":null,"name":"$seq"},{"containerName":null,"name":"$pos","kind":13,"line":266},{"name":"$strand","containerName":null,"line":267,"kind":13},{"name":"$instance","containerName":null,"line":268,"kind":13},{"kind":12,"line":268,"name":"frame","containerName":"main::"},{"line":268,"kind":13,"name":"$frame","containerName":null},{"line":268,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"line":268,"name":"_mixquery"},{"name":"@instances","containerName":null,"line":269,"kind":13},{"line":269,"kind":13,"containerName":null,"name":"$instance"},{"kind":13,"line":270,"containerName":null,"name":"$pos"},{"kind":13,"line":270,"name":"%index","containerName":null},{"containerName":null,"name":"$id","kind":13,"line":270},{"line":270,"kind":13,"name":"%self","containerName":null},{"line":270,"kind":12,"name":"_factor"},{"localvar":"my","containerName":null,"name":"$psm","definition":"my","line":272,"kind":13},{"name":"Bio","containerName":"Matrix::PSM::Psm","line":272,"kind":12},{"kind":12,"line":272,"containerName":"main::","name":"new"},{"kind":13,"line":272,"containerName":null,"name":"@instances"},{"name":"$eval","containerName":null,"kind":13,"line":273},{"containerName":null,"name":"$sid","line":274,"kind":13},{"line":275,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"_pushback","kind":12,"line":275},{"line":275,"kind":13,"name":"$line","containerName":null},{"name":"$psm","containerName":null,"kind":13,"line":276},{"definition":"sub","containerName":"main::","signature":{"label":"write_psm($self,$matrix)","documentation":"1;\n# $Id: mast.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO::mast - PSM mast parser implementation\n\n=head1 SYNOPSIS\n\nSee Bio::Matrix::PSM::IO for detailed documentation on how to \nuse PSM parsers\n\n=head1 DESCRIPTION\n\nParser for mast. This driver unlike meme or transfac for example is\ndedicated more to PSM sequence matches, than to PSM themselves.\n\n=head1 TO DO\n\nSection III should be parsed too, otherwise no real sequence is\navailable, so we supply 'NNNNN....' as a seq which is not right.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO::mast;\nuse Bio::Matrix::PSM::InstanceSite;\nuse Bio::Matrix::PSM::Psm;\nuse Bio::Root::Root;\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::PsmHeader Bio::Matrix::PSM::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'mast', \n\t\t\t\t\t\t                               -file=>$file);\n Function: Associates a file with the appropriate parser\n Throws  : Throws if the file passed is in HTML format or if \n           some criteria for the file\n           format are not met.\n Example :\n Returns : psm object, associated with a file with matrix file\n Args    : hash\n return  : \"Bio::Matrix::PSM::$format\"->new(@args);\n\n\n\nsub new {\n    my($class, @args)=@_;\n    my $self = $class->SUPER::new(@args);\n    my (%instances,@header,$n);\n    my ($file)=$self->_rearrange(['FILE'], @args);\n    $self->{file} = $file;\n    $self->{_factor}=1;\n    $self->_initialize_io(@args) || warn \"Did you intend to use STDIN?\"; #Read only for now\n    $self->{_end}=0;\n    undef $self->{hid};\n    return $self if ($file=~/^>/);#Just writing\n    my $buf=$self->_readline;\n\t$self->throw('Cannot parse HTML format yet') if ($buf =~/^<HTML>/); \n    # this should probably be moved to its own function\n    while ( defined($buf=$self->_readline)) {\n\tchomp($buf);\n\tif ($buf=~/DATABASE AND MOTIFS/) {\n\t\twhile ($buf=$self->_readline) {\n\t\t\tif ($buf=~/DATABASE/) {\n\t\t\t\t\t$buf=~s/^[\\s\\t]+//;\n\t\t\t\t\tchomp $buf;\n\t\t\t\t\t($n,$self->{_dbname},$self->{_dbtype})=split(/\\s/,$buf);\n\t\t\t\t\t$self->{_dbtype}=~s/[\\(\\)]//g;\n\t\t\t}\n\t\t\tif ($buf=~/MOTIFS/) {\n\t\t\t\t\t$buf=~s/^[\\s\\t]+//;\n\t\t\t\t\tchomp $buf;\n\t\t\t\t\t($n,$self->{_mrsc},$self->{_msrctype})=split(/\\s/,$buf);\n\t\t\t\t\t$self->{_msrctype}=~s/[\\(\\)]//g;\n\t\t\t\t\tlast;\n\t\t\t}\n\t\t}\n\t\tif ($self->{_msrctype} ne $self->{_dbtype}) {#Assume we have protein motifs, nuc DB (not handling opp.)\n\t\t\t$self->{_factor}=3;\n\t\t\t$self->{_mixquery}=1;\n\t\t}\n\t}\n\tif ($buf=~m/MOTIF WIDTH BEST POSSIBLE MATCH/) {\n\t    $self->_readline;\n\t    while (defined($buf=$self->_readline)) {\n\t\tlast if ($buf!~/\\w/);\n\t\t$buf=~s/\\t+//g;\n\t\t$buf=~s/^\\s+//g;\n\t\tmy ($id,$width,$seq)=split(/\\s+/,$buf);\n\t\tpush @{$self->{hid}},$id;\n\t\t$self->{length}->{$id}=$width;\n\t\t$self->{seq}->{$id}=$seq;\n\t    }\n\t    next;\n\t}\n\tif ($buf=~m/section i:/i) {\n\t    $self->_readline;\n\t    $self->_readline;\n\t    $self->_readline;\n\t    %instances=_get_genes($self);\n\t    $self->{instances}=\\%instances;\n      \tif (!(%instances)) {\n        \t$self->warn (\"Your MAST analysis did not find any matches satisfying the current threshold.\\nSee MAST documentation for more information.\\n\");\n        \treturn $self; #The header might be useful so we return the object, not undef\n      \t}\n\t    next;\n\t}\n\tif ($buf=~m/section ii:/i) {\n\t    $self->_readline;\n\t    $self->_readline;\n\t    $self->_readline;\n\t    last;\n\t}\n\t$buf=~s/[\\t+\\s+]/ /g;\n\tpush @header,$buf unless (($buf=~/\\*{10,}/)||($buf!~/\\w/));\n    }\n    $self->throw('Could not read Section I, probably wrong format, make sure it is not HTML, giving up...') if !(%instances);\n    $self->warn( \"This file might be an unreadable version, proceed with caution!\\n\") if (!grep(/\\s+MAST\\s+version\\s+3/,@header));\n\n    $self->{unstructured} = \\@header;\n    $self->_initialize;\n    return $self;\n}\n\n\n# Get the file header and put store it as a hash, which later we'll use to create\n# the header for each Psm. See Bio::Matrix::PSM::PsmI for header function.\nsub _get_genes {\n\tmy $self=shift;\n\tmy %llid;\n\tmy $ok=0;\n\tmy $i=0;\n\tmy %instances;\n\twhile (my $line=$self->_readline) {\n\t\tlast if ($line=~/^[\\s\\t*]/); # Well, ids can be nearly anything...???\n\t\tchomp($line);\n\t\t$i++;\n\t\tnext if ($line eq '');\n\t\t$line=~s/\\s+/,/g;\n\t\tmy ($id,$key,$eval,$len)=split(/,/,$line);\n\t\tunless ($len) {\n\t\t\twarn \"Malformed data found: $line\\n\";\n\t\t\tnext;\n\t\t}\n\t\t$instances{$id}=Bio::Matrix::PSM::InstanceSite->new(-id=>$id,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  -desc=>$key,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  -score=>$eval, \n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  -width=>$len,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  -seq=>'ACGT');\n\t}\n\treturn %instances;\n}\n\n\n=head2 next_psm\n\n Title   : next_psm\n Usage   : my $psm=$psmIO->next_psm();\n Function: Reads the next PSM from the input file, associated with this object\n Throws  : Throws if there ara format violations in the input file (checking is not\n            very strict with all drivers).\n Example :\n Returns : Bio::Matrix::PSM::Psm object\n Args    : none\n\n\n\nsub next_psm {\n    my $self=shift;\n    return if ($self->{_end}==1);\n    my (@lmotifsm,%index,$eval,$scheme,$sid);\n    %index= %{$self->{length}};\n    my (@instances,%instances);\n    my $line=$self->_readline;\n    $line=~s/[\\t\\n]//;\n    if ($line =~ /\\*{10,}/) { #Endo of Section II if we do only section II\n        $self->{_end}=1;\n        return ;\n    }\n    do {\n\tif ($line!~/^\\s/) {\n\t    ($sid,$eval,$scheme)=split(/\\s+/,$line,3);\n\t}\n\telse\n\t{ $scheme .=$line; }\n\t$line=$self->_readline;\n\t$line=~s/[\\t\\n]//;\n    } until ($line!~/^\\s/);\n    my $pos=1;\n    $scheme=~s/\\s+//g;\n    $scheme=~s/\\n//g;\n    my @motifs=split(/_/,$scheme);\n    while (@motifs) {\n\tmy $next=shift(@motifs);\n\tif (!($next=~/\\D/)) {\n\t    last if (!@motifs);\n\t    $pos+=$next;\n\t    next;\n\t}\n        my $id=$next;\n\tmy $score= $id=~m/\\[/ ? 'strong' : 'weak' ;\n\tmy $frame;\n\tmy $strand = $id =~ m/\\-\\d/ ? -1 : 1 ;\n\tif ($self->{_mixquery}) {\n\t\t$frame = 0 if $id =~ m/\\d+a/ ;\n\t\t$frame = 1 if $id =~ m/\\d+b/ ;\n\t\t$frame = 2 if $id =~ m/\\d+c/ ;\n\t}\n\t$id=~s/\\D+//g;\n\n\tmy @s;\n\tmy $width=$index{$id};\n    #We don't know the sequence, but we know the length\n\tmy $seq='N' x ($width*$self->{_factor}); #Future version will have to parse Section tree nad get the real seq\n\tmy $instance=Bio::Matrix::PSM::InstanceSite->new \n\t    ( -id=>\"$id\\@$sid\", \n\t      -mid=>$id, \n\t      -accession_number=>$sid,\n\t      -desc=>\"Motif $id occurrance in $sid\",\n\t      -score=>$score, \n\t      -seq=>$seq,\n\t\t  -alphabet => 'dna', \n\t      -start=>$pos,\n\t      -strand=>$strand);\n\t  $instance->frame($frame) if ($self->{_mixquery});\n\tpush @instances,$instance;\n\t$pos+=$index{$id}*$self->{_factor};\n    }\n    my $psm= Bio::Matrix::PSM::Psm->new(-instances=> \\@instances, \n\t\t\t\t\t-e_val    => $eval, \n\t\t\t\t\t-id       => $sid);\n    $self->_pushback($line);\n    return $psm;\n}\n\n\n=head2 write_psm\n\n Title   : write_psm\n Usage   : #Get SiteMatrix object somehow (see Bio::Matrix::PSM::SiteMatrix)\n            my $matrix=$psmin->next_matrix;\n            #Create the stream\n            my $psmio=new(-file=>\">psms.mast\",-format=>'mast');\n            $psmio->write_psm($matrix);\n            #Will warn if only PFM data is contained in $matrix, recalculate the PWM\n            #based on normal distribution (A=>0.25, C=>0.25, etc)\n Function: writes pwm in mast format\n Throws  :\n Example : \n Args    : SiteMatrix object\n Returns : ","parameters":[{"label":"$self"},{"label":"$matrix"}]},"detail":"($self,$matrix)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"write_psm","line":299,"kind":13},{"kind":13,"line":299,"containerName":"write_psm","name":"$matrix"},{"line":301,"kind":13,"localvar":"my","containerName":"write_psm","name":"$w","definition":"my"},{"line":301,"kind":13,"name":"$matrix","containerName":"write_psm"},{"kind":12,"line":301,"containerName":"write_psm","name":"width"},{"definition":"my","name":"$header","containerName":"write_psm","localvar":"my","kind":13,"line":302},{"kind":13,"line":303,"name":"$self","containerName":"write_psm"},{"containerName":"write_psm","name":"_print","kind":12,"line":303},{"line":303,"kind":13,"name":"$header","containerName":"write_psm"},{"containerName":"write_psm","name":"$matrix","line":304,"kind":13},{"kind":12,"line":304,"name":"get_logs_array","containerName":"write_psm"},{"name":"$matrix","containerName":"write_psm","line":306,"kind":13},{"kind":12,"line":306,"name":"calc_weight","containerName":"write_psm"},{"localvar":"my","name":"%h","definition":"my","containerName":"write_psm","line":308,"kind":13},{"kind":13,"line":308,"containerName":"write_psm","name":"$matrix"},{"name":"next_pos","containerName":"write_psm","line":308,"kind":12},{"name":"$self","containerName":"write_psm","line":309,"kind":13},{"kind":12,"line":309,"containerName":"write_psm","name":"_print"},{"name":"$h","containerName":"write_psm","line":309,"kind":13},{"line":309,"kind":13,"containerName":"write_psm","name":"$h"},{"containerName":"write_psm","name":"$h","kind":13,"line":309},{"kind":13,"line":309,"containerName":"write_psm","name":"$h"}],"line":298,"name":"write_psm","range":{"end":{"line":311,"character":9999},"start":{"character":0,"line":298}}},{"line":309,"kind":12,"name":"lA"},{"line":309,"kind":12,"name":"lC"},{"kind":12,"line":309,"name":"lG"},{"name":"lT","kind":12,"line":309}]}