{"version":5,"vars":[{"name":"base","containerName":"","line":86,"kind":2},{"range":{"start":{"line":100,"character":0},"end":{"line":135,"character":9999}},"name":"next_map","detail":"($self)","signature":{"label":"next_map($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: mapmaker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::MapIO::mapmaker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO::mapmaker - A Mapmaker Map reader\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is accessed through the Bio::MapIO system \n\n    use Bio::MapIO;\n    my $mapio = Bio::MapIO->new(-format => \"mapmaker\",\n\t\t\t                      -file   => \"mapfile.map\");\n    while ( my $map = $mapio->next_map ) {  # get each map\n\t    foreach my $marker ( $map->each_element ) {\n\t       # loop through the markers associated with the map\n\t    }\n    }\n\n=head1 DESCRIPTION\n\nThis object contains code for parsing and processing Mapmaker output\nand creating L<Bio::Map::MapI> objects from it.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::MapIO::mapmaker;\nuse strict;\n\nuse Bio::Map::SimpleMap;\nuse Bio::Map::LinkagePosition;\nuse Bio::Map::Marker;\n\nuse base qw(Bio::MapIO);\n\n=head2 next_map\n\n Title   : next_map\n Usage   : my $map = $factory->next_map;\n Function: Get one or more map objects from the Mapmaker input\n Returns : Bio::Map::MapI\n Args    : none\n\nSee L<Bio::Map::MapI>"},"containerName":"main::","definition":"sub","line":100,"children":[{"containerName":"next_map","definition":"my","name":"$self","localvar":"my","kind":13,"line":101},{"line":102,"kind":13,"localvar":"my","name":"$map","definition":"my","containerName":"next_map"},{"kind":12,"line":102,"containerName":"next_map","name":"new"},{"containerName":"next_map","definition":"my","name":"$in_map","localvar":"my","kind":13,"line":110},{"line":110,"kind":13,"name":"$runningDistance","containerName":"next_map"},{"line":112,"kind":13,"name":"$self","containerName":"next_map"},{"kind":12,"line":112,"containerName":"next_map","name":"_readline"},{"containerName":"next_map","name":"$in_map","line":114,"kind":13},{"line":117,"kind":13,"name":"$in_map","containerName":"next_map"},{"containerName":"next_map","name":"$number","definition":"my","localvar":"my","kind":13,"line":120},{"line":120,"kind":13,"containerName":"next_map","name":"$name"},{"name":"$distance","containerName":"next_map","kind":13,"line":120},{"containerName":"next_map","name":"$runningDistance","kind":13,"line":121},{"name":"$distance","containerName":"next_map","line":121,"kind":13},{"line":121,"kind":13,"containerName":"next_map","name":"$distance"},{"containerName":"next_map","name":"$runningDistance","line":122,"kind":13},{"line":122,"kind":13,"containerName":"next_map","name":"$runningDistance"},{"name":"$distance","containerName":"next_map","kind":13,"line":122},{"kind":13,"line":124,"definition":"my","name":"$pos","containerName":"next_map","localvar":"my"},{"kind":12,"line":124,"containerName":"next_map","name":"new"},{"kind":13,"line":124,"containerName":"next_map","name":"$number"},{"line":125,"kind":13,"name":"$map","containerName":"next_map"},{"kind":13,"line":126,"name":"$runningDistance","containerName":"next_map"},{"definition":"my","name":"$marker","containerName":"next_map","localvar":"my","kind":13,"line":127},{"containerName":"next_map","name":"new","kind":12,"line":127},{"line":127,"kind":13,"name":"$name","containerName":"next_map"},{"containerName":"next_map","name":"$pos","line":128,"kind":13},{"kind":13,"line":130,"name":"$distance","containerName":"next_map"},{"kind":13,"line":131,"containerName":"next_map","name":"$in_map"},{"containerName":"next_map","name":"$map","line":132,"kind":13}],"kind":12},{"containerName":"Map::SimpleMap","name":"Bio","kind":12,"line":102},{"name":"Bio","containerName":"Map::LinkagePosition","kind":12,"line":124},{"containerName":"Map::Marker","name":"Bio","kind":12,"line":127},{"kind":12,"line":147,"children":[{"line":148,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"write_map"},{"name":"@args","containerName":"write_map","kind":13,"line":148},{"kind":13,"line":149,"name":"$self","containerName":"write_map"},{"kind":12,"line":149,"name":"throw_not_implemented","containerName":"write_map"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"write_map($self,@args)","documentation":"1;\n# $Id: mapmaker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::MapIO::mapmaker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO::mapmaker - A Mapmaker Map reader\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is accessed through the Bio::MapIO system \n\n    use Bio::MapIO;\n    my $mapio = Bio::MapIO->new(-format => \"mapmaker\",\n\t\t\t                      -file   => \"mapfile.map\");\n    while ( my $map = $mapio->next_map ) {  # get each map\n\t    foreach my $marker ( $map->each_element ) {\n\t       # loop through the markers associated with the map\n\t    }\n    }\n\n=head1 DESCRIPTION\n\nThis object contains code for parsing and processing Mapmaker output\nand creating L<Bio::Map::MapI> objects from it.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::MapIO::mapmaker;\nuse strict;\n\nuse Bio::Map::SimpleMap;\nuse Bio::Map::LinkagePosition;\nuse Bio::Map::Marker;\n\nuse base qw(Bio::MapIO);\n\n=head2 next_map\n\n Title   : next_map\n Usage   : my $map = $factory->next_map;\n Function: Get one or more map objects from the Mapmaker input\n Returns : Bio::Map::MapI\n Args    : none\n\nSee L<Bio::Map::MapI>\n\n\nsub next_map{\n   my ($self) = @_;\n   my $map = Bio::Map::SimpleMap->new(-name  => '',\n\t\t\t\t\t\t\t\t\t\t\t\t  -units => 'cM',\n\t\t\t\t\t\t\t\t\t\t\t\t  -type  => 'Genetic');\n\n\t# Mapmaker input can be free-form, like the result of a copy-paste\n\t# from a terminal, with no particular format before or after the \n\t# map data. The $in_map variable is a flag that's set to 1 when \n\t# we're reading map data lines and set back to 0 when we're finished.\n   my ($in_map,$runningDistance);\n\n   while ( defined ($_ = $self->_readline()) ) {\n\t\tif ( /^\\s+Markers\\s+Distance/ ) {\n\t\t\t$in_map = 1;\n\t\t\tnext;\n\t\t} \n\t\tnext unless $in_map;\n \n\t\ts/ +/\\t/;\n\t\tmy ($number,$name,$distance) = split;\n\t\t$runningDistance += $distance unless ($distance =~ /-+/);\n\t\t$runningDistance = '0.0' if ($runningDistance == 0 || $distance =~ /-+/);\n\n\t\tmy $pos = Bio::Map::LinkagePosition->new(-order => $number,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t -map   => $map,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t -value => $runningDistance );\n\t\tmy $marker = Bio::Map::Marker->new(-name     => $name,\n\t\t\t\t\t\t\t\t\t\t\t\t\t -position => $pos );\n\t\t\n\t\tif ($distance =~ /-+/) { # last marker\n\t\t\t$in_map = 0;\n\t\t\treturn $map;\n\t\t}  \n\t}\n}\n\n=head2 write_map\n\n Title   : write_map\n Usage   : $factory->write_map($map);\n Function: Write a map out through the factory\n Returns : none\n Args    : Bio::Map::MapI","parameters":[{"label":"$self"},{"label":"@args"}]},"name":"write_map","range":{"start":{"line":147,"character":0},"end":{"character":9999,"line":150}}}]}