{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":83},{"range":{"end":{"character":9999,"line":121},"start":{"line":96,"character":0}},"name":"new","detail":"($caller,@args)","signature":{"label":"new($caller,@args)","documentation":"1;\n# $Id: MapIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::MapIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO - A Map Factory object\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n    my $mapio = Bio::MapIO->new(-format => \"mapmaker\",\n\t\t\t       -file   => \"mapfile.map\");\n\n    while( my $map = $mapio->next_map ) { \n\t# get each map\n\tforeach my $marker ( $map->each_element ) {\n\t    # loop through the markers associated with the map\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis is the Factory object for reading Maps from a data stream or file.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::MapIO;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Factory::MapFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::MapIO->new();\n Function: Builds a new Bio::MapIO object \n Returns : Bio::MapIO\n Args    :","parameters":[{"label":"$caller"},{"label":"@args"}]},"containerName":"main::","definition":"sub","line":96,"children":[{"localvar":"my","definition":"my","name":"$caller","containerName":"new","line":97,"kind":13},{"line":97,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":99},{"line":99,"kind":13,"name":"$caller","containerName":"new"},{"containerName":"new","name":"$caller","kind":13,"line":99},{"containerName":"new","name":"$class","line":103,"kind":13},{"kind":13,"line":104,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"name":"$class","containerName":"new","kind":13,"line":104},{"containerName":"new","name":"@args","kind":13,"line":104},{"kind":13,"line":105,"name":"$self","containerName":"new"},{"kind":12,"line":105,"name":"_initialize","containerName":"new"},{"kind":13,"line":105,"name":"@args","containerName":"new"},{"kind":13,"line":106,"containerName":"new","name":"$self"},{"localvar":"my","containerName":"new","definition":"my","name":"%param","line":109,"kind":13},{"line":109,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"@param","line":110,"kind":13},{"kind":13,"line":110,"containerName":"new","name":"%param"},{"name":"%param","containerName":"new","line":110,"kind":13},{"kind":13,"line":111,"name":"$format","definition":"my","containerName":"new","localvar":"my"},{"name":"$param","containerName":"new","kind":13,"line":111},{"kind":13,"line":112,"name":"$class","containerName":"new"},{"containerName":"new","name":"_guess_format","kind":12,"line":112},{"containerName":"new","name":"$param","kind":13,"line":112},{"kind":13,"line":112,"containerName":"new","name":"$ARGV"},{"kind":13,"line":114,"name":"$format","containerName":"new"},{"line":117,"kind":13,"name":"$class","containerName":"new"},{"name":"_load_format_module","containerName":"new","line":117,"kind":12},{"containerName":"new","name":"$format","line":117,"kind":13},{"line":118,"kind":12,"name":"new","containerName":"new"},{"kind":13,"line":118,"containerName":"new","name":"@args"}],"kind":12},{"containerName":"new","name":"SUPER","line":104,"kind":12},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$handler"}],"documentation":"1;\n# $Id: MapIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::MapIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO - A Map Factory object\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n    my $mapio = Bio::MapIO->new(-format => \"mapmaker\",\n\t\t\t       -file   => \"mapfile.map\");\n\n    while( my $map = $mapio->next_map ) { \n\t# get each map\n\tforeach my $marker ( $map->each_element ) {\n\t    # loop through the markers associated with the map\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis is the Factory object for reading Maps from a data stream or file.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::MapIO;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Factory::MapFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::MapIO->new();\n Function: Builds a new Bio::MapIO object \n Returns : Bio::MapIO\n Args    :\n\n\n\nsub new {\n  my($caller,@args) = @_;\n\n  my $class = ref($caller) || $caller;\n  \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::MapIO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\t\n\t$self->_initialize(@args);\n\treturn $self;\n    } else { \n\t\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} || \n\t    $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n\t\t'mapmaker';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::MapIO::$format\"->new(@args);\n    }\n\n}\n\n=head2 Bio::Factory::MapFactoryI methods\n\n\n=head2 next_map\n\n Title   : next_tree\n Usage   : my $map = $factory->next_map;\n Function: Get a map from the factory\n Returns : L<Bio::Map::MapI>\n Args    : none\n\n\n=head2 write_map\n\n Title   : write_tree\n Usage   : $factory->write_map($map);\n Function: Write a map out through the factory\n Returns : none\n Args    : L<Bio::Map::MapI>\n\n\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : L<Bio::Event::EventHandlerI>","label":"attach_EventHandler($self,$handler)"},"detail":"($self,$handler)","kind":12,"children":[{"localvar":"my","containerName":"attach_EventHandler","definition":"my","name":"$self","line":158,"kind":13},{"name":"$handler","containerName":"attach_EventHandler","kind":13,"line":158},{"kind":13,"line":159,"name":"$handler","containerName":"attach_EventHandler"},{"line":160,"kind":13,"name":"$handler","containerName":"attach_EventHandler"},{"name":"isa","containerName":"attach_EventHandler","kind":12,"line":160},{"containerName":"attach_EventHandler","name":"$self","line":161,"kind":13},{"line":161,"kind":12,"containerName":"attach_EventHandler","name":"warn"},{"name":"$handler","containerName":"attach_EventHandler","kind":13,"line":161},{"containerName":"attach_EventHandler","name":"$self","kind":13,"line":163},{"line":163,"kind":13,"name":"$handler","containerName":"attach_EventHandler"}],"line":157,"name":"attach_EventHandler","range":{"start":{"line":157,"character":0},"end":{"character":9999,"line":165}}},{"name":"_eventHandler","range":{"start":{"character":0,"line":178},"end":{"character":9999,"line":181}},"kind":12,"line":178,"children":[{"name":"$self","definition":"my","containerName":"_eventHandler","localvar":"my","kind":13,"line":179},{"name":"$self","containerName":"_eventHandler","line":180,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: MapIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::MapIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO - A Map Factory object\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n    my $mapio = Bio::MapIO->new(-format => \"mapmaker\",\n\t\t\t       -file   => \"mapfile.map\");\n\n    while( my $map = $mapio->next_map ) { \n\t# get each map\n\tforeach my $marker ( $map->each_element ) {\n\t    # loop through the markers associated with the map\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis is the Factory object for reading Maps from a data stream or file.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::MapIO;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Factory::MapFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::MapIO->new();\n Function: Builds a new Bio::MapIO object \n Returns : Bio::MapIO\n Args    :\n\n\n\nsub new {\n  my($caller,@args) = @_;\n\n  my $class = ref($caller) || $caller;\n  \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::MapIO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\t\n\t$self->_initialize(@args);\n\treturn $self;\n    } else { \n\t\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} || \n\t    $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n\t\t'mapmaker';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::MapIO::$format\"->new(@args);\n    }\n\n}\n\n=head2 Bio::Factory::MapFactoryI methods\n\n\n=head2 next_map\n\n Title   : next_tree\n Usage   : my $map = $factory->next_map;\n Function: Get a map from the factory\n Returns : L<Bio::Map::MapI>\n Args    : none\n\n\n=head2 write_map\n\n Title   : write_tree\n Usage   : $factory->write_map($map);\n Function: Write a map out through the factory\n Returns : none\n Args    : L<Bio::Map::MapI>\n\n\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : L<Bio::Event::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::Event::EventHandlerI') ) {\n\t$self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::Event::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : L<Bio::Event::EventHandlerI>\n Args    : none","label":"_eventHandler($self)"}},{"name":"_initialize","range":{"end":{"line":190,"character":9999},"start":{"line":183,"character":0}},"kind":12,"line":183,"children":[{"containerName":"_initialize","name":"$self","definition":"my","localvar":"my","kind":13,"line":184},{"containerName":"_initialize","name":"@args","line":184,"kind":13},{"containerName":"_initialize","name":"$self","line":185,"kind":13},{"line":188,"kind":13,"name":"$self","containerName":"_initialize"},{"line":188,"kind":12,"name":"_initialize_io","containerName":"_initialize"},{"line":188,"kind":13,"name":"@args","containerName":"_initialize"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"}},{"definition":"sub","containerName":"main::","signature":{"label":"_load_format_module($self,$format)","documentation":"1;\n# $Id: MapIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::MapIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO - A Map Factory object\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n    my $mapio = Bio::MapIO->new(-format => \"mapmaker\",\n\t\t\t       -file   => \"mapfile.map\");\n\n    while( my $map = $mapio->next_map ) { \n\t# get each map\n\tforeach my $marker ( $map->each_element ) {\n\t    # loop through the markers associated with the map\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis is the Factory object for reading Maps from a data stream or file.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::MapIO;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Factory::MapFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::MapIO->new();\n Function: Builds a new Bio::MapIO object \n Returns : Bio::MapIO\n Args    :\n\n\n\nsub new {\n  my($caller,@args) = @_;\n\n  my $class = ref($caller) || $caller;\n  \n  # or do we want to call SUPER on an object if $caller is an\n  # object?\n  if( $class =~ /Bio::MapIO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\t\n\t$self->_initialize(@args);\n\treturn $self;\n    } else { \n\t\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} || \n\t    $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n\t\t'mapmaker';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::MapIO::$format\"->new(@args);\n    }\n\n}\n\n=head2 Bio::Factory::MapFactoryI methods\n\n\n=head2 next_map\n\n Title   : next_tree\n Usage   : my $map = $factory->next_map;\n Function: Get a map from the factory\n Returns : L<Bio::Map::MapI>\n Args    : none\n\n\n=head2 write_map\n\n Title   : write_tree\n Usage   : $factory->write_map($map);\n Function: Write a map out through the factory\n Returns : none\n Args    : L<Bio::Map::MapI>\n\n\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : L<Bio::Event::EventHandlerI>\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::Event::EventHandlerI') ) {\n\t$self->warn(\"Ignoring request to attatch handler \".ref($handler). ' because it is not a Bio::Event::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : L<Bio::Event::EventHandlerI>\n Args    : none\n\n\n\nsub _eventHandler{\n   my ($self) = @_;\n   return $self->{'_handler'};\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n    $self->{'_handler'} = undef;\n    \n    # initialize the IO part\n    $self->_initialize_io(@args);\n#    $self->attach_EventHandler(Bio::MapIO::MapEventBuilder->new());\n}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL MapIO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$format"}]},"detail":"($self,$format)","kind":12,"children":[{"kind":13,"line":204,"definition":"my","name":"$self","containerName":"_load_format_module","localvar":"my"},{"line":204,"kind":13,"containerName":"_load_format_module","name":"$format"},{"kind":13,"line":205,"definition":"my","name":"$module","containerName":"_load_format_module","localvar":"my"},{"kind":13,"line":205,"name":"$format","containerName":"_load_format_module"},{"line":206,"kind":13,"localvar":"my","containerName":"_load_format_module","definition":"my","name":"$ok"},{"name":"$ok","containerName":"_load_format_module","kind":13,"line":208},{"line":208,"kind":13,"name":"$self","containerName":"_load_format_module"},{"name":"_load_module","containerName":"_load_format_module","line":208,"kind":12},{"containerName":"_load_format_module","name":"$module","line":208,"kind":13},{"containerName":"_load_format_module","name":"$ok","line":219,"kind":13}],"line":203,"name":"_load_format_module","range":{"end":{"character":9999,"line":220},"start":{"line":203,"character":0}}},{"kind":12,"children":[{"kind":13,"line":235,"name":"$class","definition":"my","containerName":"_guess_format","localvar":"my"}],"line":234,"name":"_guess_format","definition":"sub","containerName":"main::","range":{"start":{"line":234,"character":0},"end":{"character":9999,"line":239}}},{"children":[{"definition":"my","name":"$self","containerName":"DESTROY","localvar":"my","kind":13,"line":242},{"containerName":"DESTROY","name":"$self","line":244,"kind":13},{"containerName":"DESTROY","name":"close","kind":12,"line":244}],"line":241,"kind":12,"range":{"start":{"character":0,"line":241},"end":{"line":245,"character":9999}},"definition":"sub","name":"DESTROY","containerName":"main::"}]}