{"vars":[{"kind":2,"line":135,"name":"vars","containerName":""},{"containerName":"","name":"base","line":143,"kind":2},{"line":144,"kind":13,"name":"$MAPCOUNT","containerName":null},{"name":"version","range":{"start":{"line":161,"character":0},"end":{"line":167,"character":9999}},"kind":12,"children":[{"localvar":"my","containerName":"version","name":"$self","definition":"my","line":162,"kind":13},{"containerName":"version","name":"$value","line":162,"kind":13},{"kind":13,"line":163,"name":"$value","containerName":"version"},{"line":164,"kind":13,"name":"$self","containerName":"version"},{"name":"$value","containerName":"version","kind":13,"line":164},{"kind":13,"line":166,"containerName":"version","name":"$self"}],"line":161,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set","label":"version($self,$value)"},"detail":"($self,$value)"},{"line":179,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"modification_user","line":180,"kind":13},{"containerName":"modification_user","name":"$value","line":180,"kind":13},{"containerName":"modification_user","name":"$value","kind":13,"line":181},{"name":"$self","containerName":"modification_user","kind":13,"line":182},{"line":182,"kind":13,"containerName":"modification_user","name":"$value"},{"containerName":"modification_user","name":"$self","line":184,"kind":13}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set","parameters":[{"label":"$self"},{"label":"$value"}],"label":"modification_user($self,$value)"},"containerName":"main::","definition":"sub","range":{"end":{"line":185,"character":9999},"start":{"character":0,"line":179}},"name":"modification_user"},{"signature":{"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set","parameters":[{"label":"$self"},{"label":"$value"}],"label":"group_type($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"group_type","definition":"my","name":"$self","line":199,"kind":13},{"line":199,"kind":13,"name":"$value","containerName":"group_type"},{"kind":13,"line":200,"containerName":"group_type","name":"$value"},{"name":"$self","containerName":"group_type","kind":13,"line":201},{"containerName":"group_type","name":"$value","line":201,"kind":13},{"name":"$self","containerName":"group_type","kind":13,"line":203}],"line":198,"kind":12,"range":{"end":{"line":204,"character":9999},"start":{"character":0,"line":198}},"name":"group_type"},{"name":"group_abbr","range":{"start":{"character":0,"line":217},"end":{"line":223,"character":9999}},"kind":12,"line":217,"children":[{"kind":13,"line":218,"name":"$self","definition":"my","containerName":"group_abbr","localvar":"my"},{"containerName":"group_abbr","name":"$value","kind":13,"line":218},{"containerName":"group_abbr","name":"$value","kind":13,"line":219},{"kind":13,"line":220,"containerName":"group_abbr","name":"$self"},{"kind":13,"line":220,"containerName":"group_abbr","name":"$value"},{"containerName":"group_abbr","name":"$self","line":222,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"group_abbr($self,$value)","documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set","parameters":[{"label":"$self"},{"label":"$value"}]}},{"range":{"start":{"line":235,"character":0},"end":{"character":9999,"line":241}},"name":"core_exists","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set","label":"core_exists($self,$value)"},"containerName":"main::","definition":"sub","line":235,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"core_exists","line":236,"kind":13},{"name":"$value","containerName":"core_exists","line":236,"kind":13},{"containerName":"core_exists","name":"$value","line":237,"kind":13},{"name":"$self","containerName":"core_exists","kind":13,"line":238},{"name":"$value","containerName":"core_exists","line":238,"kind":13},{"containerName":"core_exists","name":"$self","kind":13,"line":240}],"kind":12},{"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none","label":"each_cloneid($self)"},"containerName":"main::","definition":"sub","line":253,"children":[{"kind":13,"line":254,"containerName":"each_cloneid","name":"$self","definition":"my","localvar":"my"},{"containerName":"each_cloneid","name":"$self","line":255,"kind":13}],"kind":12,"range":{"end":{"line":255,"character":9999},"start":{"character":0,"line":253}},"name":"each_cloneid"},{"range":{"start":{"character":0,"line":268},"end":{"line":278,"character":9999}},"name":"get_cloneobj","signature":{"parameters":[{"label":"$self"},{"label":"$clone"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name","label":"get_cloneobj($self,$clone)"},"detail":"($self,$clone)","definition":"sub","containerName":"main::","children":[{"line":269,"kind":13,"localvar":"my","containerName":"get_cloneobj","name":"$self","definition":"my"},{"containerName":"get_cloneobj","name":"$clone","kind":13,"line":269},{"kind":13,"line":271,"name":"$clone","containerName":"get_cloneobj"},{"line":272,"kind":13,"containerName":"get_cloneobj","name":"$clone"},{"line":273,"kind":13,"name":"$self","containerName":"get_cloneobj"},{"name":"$clone","containerName":"get_cloneobj","kind":13,"line":273},{"localvar":"my","name":"$type","definition":"my","containerName":"get_cloneobj","line":275,"kind":13},{"name":"$contig","containerName":"get_cloneobj","line":275,"kind":13},{"line":275,"kind":13,"containerName":"get_cloneobj","name":"$bands"},{"name":"$gel","containerName":"get_cloneobj","kind":13,"line":275},{"kind":13,"line":275,"name":"$group","containerName":"get_cloneobj"},{"containerName":"get_cloneobj","name":"$remark","line":275,"kind":13},{"line":275,"kind":13,"name":"$fp_number","containerName":"get_cloneobj"},{"kind":13,"line":276,"name":"$sequence_type","definition":"my","containerName":"get_cloneobj","localvar":"my"},{"kind":13,"line":276,"name":"$sequence_status","containerName":"get_cloneobj"},{"line":276,"kind":13,"name":"$fpc_remark","containerName":"get_cloneobj"},{"kind":13,"line":276,"name":"@amatch","containerName":"get_cloneobj"},{"line":276,"kind":13,"name":"@pmatch","containerName":"get_cloneobj"},{"kind":13,"line":276,"containerName":"get_cloneobj","name":"@ematch"},{"line":277,"kind":13,"name":"$startrange","containerName":"get_cloneobj"},{"line":277,"kind":13,"name":"$endrange","containerName":"get_cloneobj"},{"localvar":"my","name":"%clones","definition":"my","containerName":"get_cloneobj","line":278,"kind":13},{"containerName":"get_cloneobj","name":"$self","kind":13,"line":278},{"name":"$clone","containerName":"get_cloneobj","line":278,"kind":13}],"line":268,"kind":12},{"containerName":null,"name":"@markers","definition":"my","localvar":"my","kind":13,"line":279},{"line":281,"kind":13,"containerName":null,"name":"%clones"},{"containerName":null,"name":"%clones","line":282,"kind":13},{"line":285,"kind":13,"name":"$type","containerName":null},{"name":"%clones","containerName":null,"line":285,"kind":13},{"name":"%clones","containerName":null,"line":285,"kind":13},{"line":286,"kind":13,"name":"@markers","containerName":null},{"kind":13,"line":286,"name":"%clones","containerName":null},{"line":286,"kind":13,"name":"%clones","containerName":null},{"containerName":null,"name":"$contig","kind":13,"line":287},{"kind":13,"line":287,"containerName":null,"name":"%clones"},{"kind":13,"line":287,"name":"%clones","containerName":null},{"name":"$bands","containerName":null,"kind":13,"line":288},{"containerName":null,"name":"%clones","kind":13,"line":288},{"containerName":null,"name":"%clones","line":288,"kind":13},{"kind":13,"line":289,"containerName":null,"name":"$gel"},{"name":"%clones","containerName":null,"kind":13,"line":289},{"line":289,"kind":13,"containerName":null,"name":"%clones"},{"containerName":null,"name":"$group","kind":13,"line":290},{"kind":13,"line":290,"name":"%clones","containerName":null},{"kind":13,"line":290,"name":"%clones","containerName":null},{"containerName":null,"name":"$remark","line":291,"kind":13},{"containerName":null,"name":"%clones","line":291,"kind":13},{"name":"%clones","containerName":null,"kind":13,"line":291},{"line":293,"kind":13,"name":"$fp_number","containerName":null},{"containerName":null,"name":"%clones","kind":13,"line":293},{"name":"%clones","containerName":null,"line":293,"kind":13},{"line":294,"kind":13,"containerName":null,"name":"$fpc_remark"},{"line":294,"kind":13,"containerName":null,"name":"%clones"},{"name":"%clones","containerName":null,"kind":13,"line":294},{"kind":13,"line":296,"name":"$sequence_type","containerName":null},{"line":296,"kind":13,"name":"%clones","containerName":null},{"line":297,"kind":13,"name":"%clones","containerName":null},{"name":"$sequence_status","containerName":null,"line":298,"kind":13},{"containerName":null,"name":"%clones","kind":13,"line":298},{"line":299,"kind":13,"name":"%clones","containerName":null},{"name":"@amatch","containerName":null,"kind":13,"line":301},{"name":"%clones","containerName":null,"kind":13,"line":301},{"name":"%clones","containerName":null,"line":301,"kind":13},{"line":302,"kind":13,"name":"@ematch","containerName":null},{"kind":13,"line":302,"containerName":null,"name":"%clones"},{"line":302,"kind":13,"containerName":null,"name":"%clones"},{"line":303,"kind":13,"containerName":null,"name":"@pmatch"},{"name":"%clones","containerName":null,"line":303,"kind":13},{"containerName":null,"name":"%clones","line":303,"kind":13},{"containerName":null,"name":"$startrange","line":305,"kind":13},{"kind":13,"line":305,"name":"%clones","containerName":null},{"name":"%clones","containerName":null,"kind":13,"line":306},{"kind":13,"line":307,"name":"$endrange","containerName":null},{"line":307,"kind":13,"name":"%clones","containerName":null},{"containerName":null,"name":"%clones","kind":13,"line":308},{"line":311,"kind":13,"localvar":"my","name":"%cloneobj","definition":"my","containerName":null},{"kind":12,"line":312,"name":"_name"},{"line":312,"kind":13,"name":"$clone","containerName":null},{"line":313,"kind":12,"name":"_markers"},{"containerName":null,"name":"@markers","kind":13,"line":313},{"name":"_contig","kind":12,"line":314},{"kind":13,"line":314,"name":"$contig","containerName":null},{"name":"_type","line":315,"kind":12},{"containerName":null,"name":"$type","line":315,"kind":13},{"line":316,"kind":12,"name":"_bands"},{"kind":13,"line":316,"name":"$bands","containerName":null},{"name":"_gel","line":317,"kind":12},{"line":317,"kind":13,"containerName":null,"name":"$gel"},{"kind":12,"line":318,"name":"_group"},{"line":318,"kind":13,"name":"$group","containerName":null},{"name":"_remark","kind":12,"line":319},{"kind":13,"line":319,"containerName":null,"name":"$remark"},{"kind":12,"line":320,"name":"_fpnumber"},{"kind":13,"line":320,"name":"$fp_number","containerName":null},{"name":"_sequencetype","line":321,"kind":12},{"containerName":null,"name":"$sequence_type","line":321,"kind":13},{"name":"_sequencestatus","line":322,"kind":12},{"kind":13,"line":322,"name":"$sequence_status","containerName":null},{"line":323,"kind":12,"name":"_fpcremark"},{"line":323,"kind":13,"name":"$fpc_remark","containerName":null},{"name":"_matche","line":324,"kind":12},{"line":324,"kind":13,"name":"@ematch","containerName":null},{"name":"_matcha","line":325,"kind":12},{"kind":13,"line":325,"containerName":null,"name":"@amatch"},{"name":"_matchp","kind":12,"line":326},{"line":326,"kind":13,"name":"@pmatch","containerName":null},{"name":"_range","line":327,"kind":12},{"containerName":"Range","name":"Bio","line":327,"kind":12},{"line":327,"kind":12,"name":"new","containerName":"main::"},{"name":"$startrange","containerName":null,"kind":13,"line":327},{"kind":13,"line":328,"containerName":null,"name":"$endrange"},{"line":331,"kind":13,"name":"%self","containerName":null},{"name":"%clone","containerName":null,"kind":13,"line":331},{"containerName":null,"name":"$cloneobj","kind":13,"line":331},{"line":332,"kind":13,"containerName":null,"name":"$cloneobj"},{"range":{"end":{"character":9999,"line":347},"start":{"character":0,"line":345}},"name":"each_markerid","detail":"($self)","signature":{"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none","parameters":[{"label":"$self"}],"label":"each_markerid($self)"},"containerName":"main::","definition":"sub","line":345,"children":[{"line":346,"kind":13,"localvar":"my","containerName":"each_markerid","definition":"my","name":"$self"},{"containerName":"each_markerid","name":"$self","line":347,"kind":13}],"kind":12},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"get_markerobj","line":361,"kind":13},{"name":"$marker","containerName":"get_markerobj","kind":13,"line":361},{"kind":13,"line":363,"containerName":"get_markerobj","name":"$marker"},{"kind":13,"line":364,"name":"$marker","containerName":"get_markerobj"},{"containerName":"get_markerobj","name":"$self","kind":13,"line":365},{"kind":13,"line":365,"name":"$marker","containerName":"get_markerobj"},{"name":"$global","definition":"my","containerName":"get_markerobj","localvar":"my","kind":13,"line":367},{"kind":13,"line":367,"containerName":"get_markerobj","name":"$framework"},{"line":367,"kind":13,"containerName":"get_markerobj","name":"$group"},{"name":"$anchor","containerName":"get_markerobj","line":367,"kind":13},{"containerName":"get_markerobj","name":"$remark","kind":13,"line":367},{"kind":13,"line":367,"name":"$type","containerName":"get_markerobj"},{"kind":13,"line":367,"containerName":"get_markerobj","name":"$linkage"},{"containerName":"get_markerobj","name":"$subgroup","line":367,"kind":13},{"kind":13,"line":368,"containerName":"get_markerobj","name":"%mkr","definition":"my","localvar":"my"},{"kind":13,"line":368,"containerName":"get_markerobj","name":"$self"},{"kind":13,"line":368,"containerName":"get_markerobj","name":"$marker"}],"line":360,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name","parameters":[{"label":"$self"},{"label":"$marker"}],"label":"get_markerobj($self,$marker)"},"detail":"($self,$marker)","name":"get_markerobj","range":{"start":{"character":0,"line":360},"end":{"line":368,"character":9999}}},{"name":"%mkr","containerName":null,"kind":13,"line":370},{"name":"%mkr","containerName":null,"kind":13,"line":370},{"kind":13,"line":372,"containerName":null,"name":"$type"},{"line":372,"kind":13,"name":"%mkr","containerName":null},{"line":372,"kind":13,"containerName":null,"name":"%mkr"},{"kind":13,"line":373,"name":"$global","containerName":null},{"containerName":null,"name":"%mkr","kind":13,"line":373},{"kind":13,"line":373,"containerName":null,"name":"%mkr"},{"line":374,"kind":13,"containerName":null,"name":"$framework"},{"containerName":null,"name":"%mkr","kind":13,"line":374},{"line":374,"kind":13,"containerName":null,"name":"%mkr"},{"kind":13,"line":375,"containerName":null,"name":"$anchor"},{"kind":13,"line":375,"name":"%mkr","containerName":null},{"name":"%mkr","containerName":null,"kind":13,"line":375},{"containerName":null,"name":"$group","line":376,"kind":13},{"kind":13,"line":376,"containerName":null,"name":"%mkr"},{"kind":13,"line":376,"name":"%mkr","containerName":null},{"containerName":null,"name":"$subgroup","kind":13,"line":377},{"kind":13,"line":377,"containerName":null,"name":"%mkr"},{"name":"%mkr","containerName":null,"line":377,"kind":13},{"name":"$remark","containerName":null,"line":378,"kind":13},{"containerName":null,"name":"%mkr","kind":13,"line":378},{"name":"%mkr","containerName":null,"line":378,"kind":13},{"localvar":"my","containerName":null,"definition":"my","name":"%clones","line":380,"kind":13},{"line":380,"kind":13,"containerName":null,"name":"%mkr"},{"containerName":null,"definition":"my","name":"%contigs","localvar":"my","kind":13,"line":381},{"kind":13,"line":381,"containerName":null,"name":"%mkr"},{"kind":13,"line":383,"definition":"my","name":"%markerpos","containerName":null,"localvar":"my"},{"kind":13,"line":383,"containerName":null,"name":"%mkr"},{"containerName":null,"name":"%mkr","line":383,"kind":13},{"containerName":null,"definition":"my","name":"%markerobj","localvar":"my","kind":13,"line":386},{"kind":12,"line":387,"name":"_name"},{"name":"$marker","containerName":null,"kind":13,"line":387},{"kind":12,"line":388,"name":"_type"},{"containerName":null,"name":"$type","line":388,"kind":13},{"line":389,"kind":12,"name":"_global"},{"name":"$global","containerName":null,"line":389,"kind":13},{"line":390,"kind":12,"name":"_frame"},{"containerName":null,"name":"$framework","kind":13,"line":390},{"name":"_group","kind":12,"line":391},{"name":"$group","containerName":null,"kind":13,"line":391},{"kind":12,"line":392,"name":"_subgroup"},{"kind":13,"line":392,"containerName":null,"name":"$subgroup"},{"name":"_anchor","line":393,"kind":12},{"kind":13,"line":393,"containerName":null,"name":"$anchor"},{"name":"_remark","line":394,"kind":12},{"containerName":null,"name":"$remark","line":394,"kind":13},{"name":"_clones","line":395,"kind":12},{"name":"%clones","containerName":null,"kind":13,"line":395},{"kind":12,"line":396,"name":"_contigs"},{"kind":13,"line":396,"name":"%contigs","containerName":null},{"name":"_position","kind":12,"line":397},{"name":"%markerpos","containerName":null,"line":397,"kind":13},{"kind":13,"line":400,"containerName":null,"name":"%self"},{"kind":13,"line":400,"containerName":null,"name":"%marker"},{"kind":13,"line":400,"containerName":null,"name":"$markerobj"},{"name":"$markerobj","containerName":null,"line":401,"kind":13},{"definition":"sub","containerName":"main::","signature":{"label":"each_contigid($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none"},"detail":"($self)","kind":12,"children":[{"line":415,"kind":13,"localvar":"my","containerName":"each_contigid","name":"$self","definition":"my"},{"containerName":"each_contigid","name":"$self","line":416,"kind":13}],"line":414,"name":"each_contigid","range":{"start":{"character":0,"line":414},"end":{"character":9999,"line":416}}},{"detail":"($self,$contig)","signature":{"label":"get_contigobj($self,$contig)","parameters":[{"label":"$self"},{"label":"$contig"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number"},"containerName":"main::","definition":"sub","line":429,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"get_contigobj","line":430,"kind":13},{"name":"$contig","containerName":"get_contigobj","line":430,"kind":13},{"containerName":"get_contigobj","name":"$contig","kind":13,"line":432},{"kind":13,"line":433,"containerName":"get_contigobj","name":"$contig"},{"name":"$self","containerName":"get_contigobj","kind":13,"line":434},{"line":434,"kind":13,"containerName":"get_contigobj","name":"$contig"},{"line":436,"kind":13,"localvar":"my","containerName":"get_contigobj","definition":"my","name":"$group"},{"name":"$anchor","containerName":"get_contigobj","kind":13,"line":436},{"line":436,"kind":13,"containerName":"get_contigobj","name":"$uremark"},{"containerName":"get_contigobj","name":"$tremark","kind":13,"line":436},{"kind":13,"line":436,"containerName":"get_contigobj","name":"$cremark"},{"name":"$startrange","containerName":"get_contigobj","kind":13,"line":436},{"kind":13,"line":436,"name":"$endrange","containerName":"get_contigobj"},{"kind":13,"line":437,"name":"$linkage","containerName":"get_contigobj"},{"containerName":"get_contigobj","name":"$subgroup","kind":13,"line":437},{"localvar":"my","containerName":"get_contigobj","name":"%ctg","definition":"my","line":438,"kind":13},{"containerName":"get_contigobj","name":"$self","line":438,"kind":13},{"kind":13,"line":438,"name":"$contig","containerName":"get_contigobj"}],"kind":12,"range":{"end":{"line":438,"character":9999},"start":{"line":429,"character":0}},"name":"get_contigobj"},{"definition":"my","name":"%position","containerName":null,"localvar":"my","kind":13,"line":439},{"kind":13,"line":439,"containerName":null,"name":"%pos"},{"name":"%ctg","containerName":null,"line":441,"kind":13},{"line":441,"kind":13,"containerName":null,"name":"%ctg"},{"line":443,"kind":13,"containerName":null,"name":"$group"},{"line":443,"kind":13,"name":"%ctg","containerName":null},{"containerName":null,"name":"%ctg","line":443,"kind":13},{"line":444,"kind":13,"containerName":null,"name":"$subgroup"},{"kind":13,"line":444,"containerName":null,"name":"%ctg"},{"name":"%ctg","containerName":null,"line":444,"kind":13},{"line":445,"kind":13,"name":"$anchor","containerName":null},{"line":445,"kind":13,"containerName":null,"name":"%ctg"},{"line":445,"kind":13,"name":"%ctg","containerName":null},{"name":"$cremark","containerName":null,"line":446,"kind":13},{"kind":13,"line":446,"containerName":null,"name":"%ctg"},{"line":446,"kind":13,"containerName":null,"name":"%ctg"},{"containerName":null,"name":"$uremark","kind":13,"line":447},{"line":447,"kind":13,"name":"%ctg","containerName":null},{"name":"%ctg","containerName":null,"line":447,"kind":13},{"line":448,"kind":13,"name":"$tremark","containerName":null},{"containerName":null,"name":"%ctg","line":448,"kind":13},{"kind":13,"line":448,"containerName":null,"name":"%ctg"},{"kind":13,"line":450,"name":"$startrange","containerName":null},{"line":450,"kind":13,"containerName":null,"name":"%ctg"},{"line":451,"kind":13,"containerName":null,"name":"%ctg"},{"kind":13,"line":452,"name":"$endrange","containerName":null},{"containerName":null,"name":"%ctg","line":452,"kind":13},{"name":"%ctg","containerName":null,"line":453,"kind":13},{"line":455,"kind":13,"localvar":"my","containerName":null,"name":"%clones","definition":"my"},{"line":455,"kind":13,"containerName":null,"name":"%ctg"},{"kind":13,"line":455,"containerName":null,"name":"%ctg"},{"definition":"my","name":"%markers","containerName":null,"localvar":"my","kind":13,"line":456},{"name":"%ctg","containerName":null,"line":456,"kind":13},{"kind":13,"line":456,"containerName":null,"name":"%ctg"},{"localvar":"my","containerName":null,"name":"$pos","definition":"my","line":458,"kind":13},{"name":"%ctg","containerName":null,"kind":13,"line":458},{"localvar":"my","containerName":null,"name":"%contigobj","definition":"my","line":461,"kind":13},{"line":462,"kind":12,"name":"_group"},{"name":"$group","containerName":null,"kind":13,"line":462},{"name":"_subgroup","line":463,"kind":12},{"line":463,"kind":13,"containerName":null,"name":"$subgroup"},{"name":"_anchor","kind":12,"line":464},{"line":464,"kind":13,"containerName":null,"name":"$anchor"},{"kind":12,"line":465,"name":"_markers"},{"containerName":null,"name":"%markers","kind":13,"line":465},{"name":"_clones","line":466,"kind":12},{"containerName":null,"name":"%clones","line":466,"kind":13},{"line":467,"kind":12,"name":"_name"},{"containerName":null,"name":"$contig","kind":13,"line":467},{"name":"_cremark","line":468,"kind":12},{"name":"$cremark","containerName":null,"line":468,"kind":13},{"name":"_uremark","line":469,"kind":12},{"name":"$uremark","containerName":null,"line":469,"kind":13},{"line":470,"kind":12,"name":"_tremark"},{"line":470,"kind":13,"containerName":null,"name":"$tremark"},{"kind":12,"line":471,"name":"_position"},{"line":471,"kind":13,"containerName":null,"name":"$pos"},{"name":"_range","line":472,"kind":12},{"name":"Bio","containerName":"Range","line":472,"kind":12},{"kind":12,"line":472,"name":"new","containerName":"main::"},{"line":472,"kind":13,"name":"$startrange","containerName":null},{"containerName":null,"name":"$endrange","kind":13,"line":473},{"kind":13,"line":476,"name":"%self","containerName":null},{"line":476,"kind":13,"name":"%contig","containerName":null},{"name":"$contigobj","containerName":null,"kind":13,"line":476},{"name":"$contigobj","containerName":null,"kind":13,"line":477},{"detail":"($self,$cloneA,$cloneB,$tol)","signature":{"label":"matching_bands($self,$cloneA,$cloneB,$tol)","documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]","parameters":[{"label":"$self"},{"label":"$cloneA"},{"label":"$cloneB"},{"label":"$tol"}]},"containerName":"main::","definition":"sub","line":492,"children":[{"name":"$self","definition":"my","containerName":"matching_bands","localvar":"my","kind":13,"line":493},{"line":493,"kind":13,"name":"$cloneA","containerName":"matching_bands"},{"line":493,"kind":13,"name":"$cloneB","containerName":"matching_bands"},{"line":493,"kind":13,"containerName":"matching_bands","name":"$tol"},{"kind":13,"line":494,"containerName":"matching_bands","definition":"my","name":"$lstart","localvar":"my"},{"kind":13,"line":494,"name":"$kband","containerName":"matching_bands"},{"line":494,"kind":13,"containerName":"matching_bands","name":"$match"},{"kind":13,"line":494,"name":"$diff","containerName":"matching_bands"},{"kind":13,"line":494,"containerName":"matching_bands","name":"$i"},{"name":"$j","containerName":"matching_bands","line":494,"kind":13},{"containerName":"matching_bands","name":"$cloneA","line":496,"kind":13},{"containerName":"matching_bands","name":"$cloneB","kind":13,"line":496},{"containerName":"matching_bands","name":"$self","kind":13,"line":497},{"containerName":"matching_bands","name":"core_exists","kind":12,"line":497},{"containerName":"matching_bands","name":"$tol","kind":13,"line":499},{"line":499,"kind":13,"name":"$tol","containerName":"matching_bands"},{"line":501,"kind":13,"localvar":"my","name":"%_clones","definition":"my","containerName":"matching_bands"},{"containerName":"matching_bands","name":"$self","kind":13,"line":501}],"kind":12,"range":{"end":{"line":501,"character":9999},"start":{"character":0,"line":492}},"name":"matching_bands"},{"line":503,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@bandsA"},{"containerName":null,"name":"%_clones","line":503,"kind":13},{"line":503,"kind":13,"containerName":null,"name":"%cloneA"},{"localvar":"my","name":"@bandsB","definition":"my","containerName":null,"line":504,"kind":13},{"containerName":null,"name":"%_clones","kind":13,"line":504},{"name":"%cloneB","containerName":null,"line":504,"kind":13},{"name":"$match","containerName":null,"line":506,"kind":13},{"line":507,"kind":13,"name":"$lstart","containerName":null},{"kind":13,"line":509,"name":"$i","containerName":null},{"line":509,"kind":13,"name":"$i","containerName":null},{"line":509,"kind":13,"name":"@bandsA","containerName":null},{"name":"%i","containerName":null,"line":509,"kind":13},{"name":"$kband","containerName":null,"kind":13,"line":510},{"kind":13,"line":510,"name":"@bandsA","containerName":null},{"kind":13,"line":510,"containerName":null,"name":"$i"},{"kind":13,"line":511,"containerName":null,"name":"$j"},{"line":511,"kind":13,"containerName":null,"name":"$lstart"},{"name":"$j","containerName":null,"kind":13,"line":511},{"line":511,"kind":13,"containerName":null,"name":"@bandsB"},{"name":"%j","containerName":null,"line":511,"kind":13},{"containerName":null,"name":"$diff","kind":13,"line":512},{"line":512,"kind":13,"name":"$kband","containerName":null},{"name":"@bandsB","containerName":null,"line":512,"kind":13},{"line":512,"kind":13,"name":"$j","containerName":null},{"kind":13,"line":513,"containerName":null,"name":"$diff"},{"name":"%tol","containerName":null,"kind":13,"line":513},{"name":"$match","containerName":null,"line":514,"kind":13},{"name":"$lstart","containerName":null,"line":515,"kind":13},{"name":"$j","containerName":null,"kind":13,"line":515},{"line":518,"kind":13,"containerName":null,"name":"%diff"},{"kind":13,"line":519,"name":"$lstart","containerName":null},{"containerName":null,"name":"$j","kind":13,"line":519},{"line":524,"kind":13,"containerName":null,"name":"$match"},{"range":{"start":{"character":0,"line":540},"end":{"character":9999,"line":546}},"name":"coincidence_score","signature":{"parameters":[{"label":"$self"},{"label":"$cloneA"},{"label":"$cloneB"},{"label":"$tol"},{"label":"$gellen"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]\n\n\nsub matching_bands {\n    my($self,$cloneA,$cloneB,$tol) = @_;\n    my($lstart,$kband,$match,$diff,$i,$j);\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    $tol = 7 if (!defined($tol));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @bandsA = @{$_clones{$cloneA}{'bands'}};\n    my @bandsB = @{$_clones{$cloneB}{'bands'}};\n\n    $match  = 0;\n    $lstart = 0;\n\n    for ($i=0; $i<scalar(@bandsA);$i++) {\n\t$kband = $bandsA[$i];\n\tfor ($j = $lstart; $j<scalar(@bandsB); $j++) {\n\t    $diff = $kband - $bandsB[$j];\n\t    if (abs($diff)  <= $tol ) {\n\t\t$match++;\n\t\t$lstart = $j+1;\n\t\tlast;\n\t    }\n\t    elsif ($diff < 0) {\n\t\t$lstart = $j;\n\t\tlast;\n\t    }\n\t}\n    }\n    return $match;\n}\n\n=head2 coincidence_score\n\n Title   : coincidence_score\n Usage   : $self->coincidence_score('cloneA','cloneB'[,$tol,$gellen]);\n Function: given two clones [,tolerence and gellen], this method calculates\n           the Sulston Coincidence score.\n           (this method is ported directly from FPC)\n Returns : scalar representing the Sulston coincidence score.\n Args    : names of the clones ('cloneA', 'cloneB')\n           [Default tol=7 gellen=3300.0]","label":"coincidence_score($self,$cloneA,$cloneB,$tol,$gellen)"},"detail":"($self,$cloneA,$cloneB,$tol,$gellen)","definition":"sub","containerName":"main::","children":[{"containerName":"coincidence_score","name":"$self","definition":"my","localvar":"my","kind":13,"line":541},{"name":"$cloneA","containerName":"coincidence_score","kind":13,"line":541},{"name":"$cloneB","containerName":"coincidence_score","kind":13,"line":541},{"containerName":"coincidence_score","name":"$tol","kind":13,"line":541},{"name":"$gellen","containerName":"coincidence_score","kind":13,"line":541},{"kind":13,"line":543,"name":"$cloneA","containerName":"coincidence_score"},{"containerName":"coincidence_score","name":"$cloneB","line":543,"kind":13},{"containerName":"coincidence_score","name":"$self","line":544,"kind":13},{"name":"core_exists","containerName":"coincidence_score","kind":12,"line":544},{"kind":13,"line":546,"containerName":"coincidence_score","definition":"my","name":"%_clones","localvar":"my"},{"name":"$self","containerName":"coincidence_score","kind":13,"line":546}],"line":540,"kind":12},{"name":"$numbandsA","definition":"my","containerName":null,"localvar":"my","kind":13,"line":548},{"kind":13,"line":548,"name":"%_clones","containerName":null},{"containerName":null,"name":"%cloneA","kind":13,"line":548},{"kind":13,"line":549,"name":"$numbandsB","definition":"my","containerName":null,"localvar":"my"},{"name":"%_clones","containerName":null,"kind":13,"line":549},{"kind":13,"line":549,"containerName":null,"name":"%cloneB"},{"line":551,"kind":13,"localvar":"my","containerName":null,"name":"$nL","definition":"my"},{"line":551,"kind":13,"name":"$nH","containerName":null},{"line":551,"kind":13,"containerName":null,"name":"$m"},{"kind":13,"line":551,"containerName":null,"name":"$i"},{"line":551,"kind":13,"containerName":null,"name":"$psmn"},{"containerName":null,"name":"$pp","line":551,"kind":13},{"name":"$pa","containerName":null,"kind":13,"line":551},{"name":"$pb","containerName":null,"line":551,"kind":13},{"containerName":null,"name":"$t","line":551,"kind":13},{"name":"$c","containerName":null,"kind":13,"line":551},{"kind":13,"line":551,"name":"$a","containerName":null},{"kind":13,"line":551,"containerName":null,"name":"$n"},{"name":"@logfact","definition":"my","containerName":null,"localvar":"my","kind":13,"line":552},{"kind":13,"line":553,"containerName":null,"name":"$score","definition":"my","localvar":"my"},{"containerName":null,"name":"$gellen","kind":13,"line":555},{"line":555,"kind":13,"containerName":null,"name":"$gellen"},{"containerName":null,"name":"$tol","kind":13,"line":556},{"containerName":null,"name":"$tol","line":556,"kind":13},{"line":558,"kind":13,"containerName":null,"name":"$numbandsA"},{"kind":13,"line":558,"name":"%numbandsB","containerName":null},{"name":"$nH","containerName":null,"line":559,"kind":13},{"kind":13,"line":559,"containerName":null,"name":"$numbandsA"},{"kind":13,"line":560,"name":"$nL","containerName":null},{"line":560,"kind":13,"containerName":null,"name":"%numbandsB"},{"kind":13,"line":563,"name":"$nH","containerName":null},{"kind":13,"line":563,"containerName":null,"name":"$numbandsB"},{"name":"$nL","containerName":null,"line":564,"kind":13},{"line":564,"kind":13,"name":"$numbandsA","containerName":null},{"kind":13,"line":567,"name":"$m","containerName":null},{"containerName":null,"name":"$self","line":567,"kind":13},{"containerName":"main::","name":"matching_bands","kind":12,"line":567},{"containerName":null,"name":"$cloneA","kind":13,"line":567},{"containerName":null,"name":"$cloneB","line":567,"kind":13},{"kind":13,"line":567,"name":"$tol","containerName":null},{"kind":13,"line":569,"containerName":null,"name":"@logfact"},{"name":"@logfact","containerName":null,"kind":13,"line":570},{"containerName":null,"name":"$i","kind":13,"line":571},{"containerName":null,"name":"$i","line":571,"kind":13},{"containerName":null,"name":"$nL","kind":13,"line":571},{"line":571,"kind":13,"name":"%i","containerName":null},{"kind":13,"line":572,"name":"@logfact","containerName":null},{"kind":13,"line":572,"name":"$i","containerName":null},{"line":572,"kind":13,"name":"@logfact","containerName":null},{"containerName":null,"name":"$i","kind":13,"line":572},{"name":"$i","containerName":null,"line":572,"kind":13},{"containerName":null,"name":"$psmn","kind":13,"line":575},{"line":575,"kind":13,"containerName":null,"name":"$tol"},{"containerName":null,"name":"$gellen","kind":13,"line":575},{"name":"$pp","containerName":null,"kind":13,"line":577},{"name":"$psmn","containerName":null,"kind":13,"line":577},{"kind":13,"line":577,"name":"$nH","containerName":null},{"line":578,"kind":13,"name":"$pa","containerName":null},{"containerName":null,"name":"$pp","line":578,"kind":13},{"name":"$pb","containerName":null,"line":579,"kind":13},{"containerName":null,"name":"$pp","line":579,"kind":13},{"name":"$t","containerName":null,"line":580,"kind":13},{"line":582,"kind":13,"name":"$n","containerName":null},{"line":582,"kind":13,"name":"$m","containerName":null},{"containerName":null,"name":"$n","line":582,"kind":13},{"kind":13,"line":582,"name":"$nL","containerName":null},{"containerName":null,"name":"%n","kind":13,"line":582},{"name":"$c","containerName":null,"kind":13,"line":583},{"containerName":null,"name":"@logfact","kind":13,"line":583},{"line":583,"kind":13,"containerName":null,"name":"$nL"},{"kind":13,"line":583,"containerName":null,"name":"@logfact"},{"kind":13,"line":583,"name":"$nL","containerName":null},{"kind":13,"line":583,"name":"$n","containerName":null},{"line":583,"kind":13,"name":"@logfact","containerName":null},{"line":583,"kind":13,"containerName":null,"name":"$n"},{"line":584,"kind":13,"name":"$a","containerName":null},{"kind":13,"line":584,"containerName":null,"name":"$c"},{"kind":13,"line":584,"containerName":null,"name":"$n"},{"line":584,"kind":13,"name":"$pb","containerName":null},{"containerName":null,"name":"$nL","kind":13,"line":584},{"name":"$n","containerName":null,"kind":13,"line":584},{"kind":13,"line":584,"name":"$pa","containerName":null},{"containerName":null,"name":"$t","kind":13,"line":585},{"kind":13,"line":585,"name":"$a","containerName":null},{"line":588,"kind":13,"containerName":null,"name":"$score"},{"name":"$t","containerName":null,"line":588,"kind":13},{"line":589,"kind":13,"name":"$score","containerName":null},{"children":[{"containerName":"print_contiglist","name":"$self","definition":"my","localvar":"my","kind":13,"line":605},{"containerName":"print_contiglist","name":"$showall","line":605,"kind":13},{"kind":13,"line":606,"definition":"my","name":"$pos","containerName":"print_contiglist","localvar":"my"},{"name":"$showall","containerName":"print_contiglist","kind":13,"line":608},{"line":608,"kind":13,"containerName":"print_contiglist","name":"$showall"},{"definition":"my","name":"%_contigs","containerName":"print_contiglist","localvar":"my","kind":13,"line":609},{"kind":13,"line":609,"containerName":"print_contiglist","name":"$self"}],"line":604,"kind":12,"signature":{"label":"print_contiglist($self,$showall)","documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]\n\n\nsub matching_bands {\n    my($self,$cloneA,$cloneB,$tol) = @_;\n    my($lstart,$kband,$match,$diff,$i,$j);\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    $tol = 7 if (!defined($tol));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @bandsA = @{$_clones{$cloneA}{'bands'}};\n    my @bandsB = @{$_clones{$cloneB}{'bands'}};\n\n    $match  = 0;\n    $lstart = 0;\n\n    for ($i=0; $i<scalar(@bandsA);$i++) {\n\t$kband = $bandsA[$i];\n\tfor ($j = $lstart; $j<scalar(@bandsB); $j++) {\n\t    $diff = $kband - $bandsB[$j];\n\t    if (abs($diff)  <= $tol ) {\n\t\t$match++;\n\t\t$lstart = $j+1;\n\t\tlast;\n\t    }\n\t    elsif ($diff < 0) {\n\t\t$lstart = $j;\n\t\tlast;\n\t    }\n\t}\n    }\n    return $match;\n}\n\n=head2 coincidence_score\n\n Title   : coincidence_score\n Usage   : $self->coincidence_score('cloneA','cloneB'[,$tol,$gellen]);\n Function: given two clones [,tolerence and gellen], this method calculates\n           the Sulston Coincidence score.\n           (this method is ported directly from FPC)\n Returns : scalar representing the Sulston coincidence score.\n Args    : names of the clones ('cloneA', 'cloneB')\n           [Default tol=7 gellen=3300.0]\n\n\nsub coincidence_score {\n    my($self,$cloneA,$cloneB,$tol,$gellen) = @_;\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $numbandsA = scalar(@{$_clones{$cloneA}{'bands'}});\n    my $numbandsB = scalar(@{$_clones{$cloneB}{'bands'}});\n\n    my ($nL,$nH,$m,$i,$psmn,$pp,$pa,$pb,$t,$c,$a,$n);\n    my @logfact;\n    my $score;\n\n    $gellen = 3300.0 if (!defined($gellen));\n    $tol    = 7      if (!defined($tol));\n\n    if ($numbandsA > $numbandsB) {\n\t$nH = $numbandsA;\n\t$nL = $numbandsB;\n    }\n    else {\n\t$nH = $numbandsB;\n\t$nL = $numbandsA;\n    }\n\n    $m = $self->matching_bands($cloneA, $cloneB,$tol);\n\n    $logfact[0] = 0.0;\n    $logfact[1] = 0.0;\n    for ($i=2; $i<=$nL; $i++) {\n\t$logfact[$i] = $logfact[$i - 1] + log($i);\n    }\n\n    $psmn = 1.0 - ((2*$tol)/$gellen);\n\n    $pp = $psmn ** $nH;\n    $pa = log($pp);\n    $pb = log(1 - $pp);\n    $t  = 1e-37;\n\n    for ($n = $m; $n <= $nL; $n++)  {\n\t$c = $logfact[$nL] - $logfact[$nL - $n] - $logfact[$n];\n\t$a = exp($c + ($n * $pb) + (($nL - $n) * $pa));\n\t$t += $a;\n    }\n\n    $score = sprintf(\"%.e\",$t);\n    return $score;\n}\n\n=head2 print_contiglist\n\n Title   : print_contiglist\n Usage   : $map->print_contiglist([showall]); #[Default 0]\n Function: prints the list of contigs, markers that hit the contig, the\n           global position and whether the marker is a placement (P) or\n           a Framework (F) marker.\n Returns : none\n Args    : [showall] [Default 0], 1 includes all the discrepant markers","parameters":[{"label":"$self"},{"label":"$showall"}]},"detail":"($self,$showall)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":604},"end":{"line":609,"character":9999}},"name":"print_contiglist"},{"line":610,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"%_markers"},{"name":"%self","containerName":null,"kind":13,"line":610},{"containerName":null,"definition":"my","name":"%_clones","localvar":"my","kind":13,"line":611},{"line":611,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":613,"name":"@contigs","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"$self","line":613,"kind":13},{"line":613,"kind":12,"name":"each_contigid","containerName":"main::"},{"containerName":null,"name":"@sortedcontigs","definition":"my","localvar":"my","kind":13,"line":614},{"kind":13,"line":614,"name":"$a","containerName":null},{"line":614,"kind":13,"containerName":null,"name":"$b"},{"line":614,"kind":13,"containerName":null,"name":"@contigs"},{"line":617,"kind":13,"localvar":"my","containerName":null,"name":"$contig","definition":"my"},{"kind":13,"line":617,"name":"@sortedcontigs","containerName":null},{"line":618,"kind":13,"localvar":"my","containerName":null,"name":"%list","definition":"my"},{"localvar":"my","name":"%alist","definition":"my","containerName":null,"line":619,"kind":13},{"line":621,"kind":13,"localvar":"my","definition":"my","name":"$ctgAnchor","containerName":null},{"line":621,"kind":13,"name":"%_contigs","containerName":null},{"line":621,"kind":13,"containerName":null,"name":"%contig"},{"localvar":"my","definition":"my","name":"$ctgGroup","containerName":null,"line":622,"kind":13},{"line":622,"kind":13,"containerName":null,"name":"%_contigs"},{"containerName":null,"name":"%contig","line":622,"kind":13},{"line":624,"kind":13,"localvar":"my","containerName":null,"name":"@mkr","definition":"my"},{"containerName":null,"name":"%_contigs","line":624,"kind":13},{"name":"%contig","containerName":null,"kind":13,"line":624},{"kind":13,"line":626,"containerName":null,"definition":"my","name":"$marker","localvar":"my"},{"kind":13,"line":626,"name":"@mkr","containerName":null},{"kind":13,"line":627,"definition":"my","name":"$mrkGroup","containerName":null,"localvar":"my"},{"line":627,"kind":13,"name":"%_markers","containerName":null},{"name":"%marker","containerName":null,"kind":13,"line":627},{"line":628,"kind":13,"localvar":"my","containerName":null,"name":"$mrkGlobal","definition":"my"},{"name":"%_markers","containerName":null,"line":628,"kind":13},{"name":"%marker","containerName":null,"line":628,"kind":13},{"line":629,"kind":13,"localvar":"my","name":"$mrkFramework","definition":"my","containerName":null},{"containerName":null,"name":"%_markers","line":629,"kind":13},{"line":629,"kind":13,"name":"%marker","containerName":null},{"localvar":"my","name":"$mrkAnchor","definition":"my","containerName":null,"line":630,"kind":13},{"line":630,"kind":13,"name":"%_markers","containerName":null},{"line":630,"kind":13,"containerName":null,"name":"%marker"},{"name":"$ctgGroup","containerName":null,"kind":13,"line":632},{"line":632,"kind":13,"containerName":null,"name":"%ctgGroup"},{"name":"$mrkGroup","containerName":null,"kind":13,"line":633},{"line":633,"kind":13,"containerName":null,"name":"%ctgGroup"},{"name":"%mrkFramework","containerName":null,"kind":13,"line":634},{"name":"$pos","containerName":null,"line":635,"kind":13},{"name":"%mrkGlobal","containerName":null,"kind":13,"line":635},{"name":"$pos","containerName":null,"line":638,"kind":13},{"containerName":null,"name":"$mrkGlobal","line":638,"kind":13},{"kind":13,"line":640,"name":"%list","containerName":null},{"name":"$marker","containerName":null,"kind":13,"line":640},{"name":"$pos","containerName":null,"kind":13,"line":640},{"kind":13,"line":642,"containerName":null,"name":"%showall"},{"containerName":null,"name":"$chr","definition":"my","localvar":"my","kind":13,"line":643},{"kind":13,"line":643,"name":"$self","containerName":null},{"kind":12,"line":643,"containerName":"main::","name":"group_abbr"},{"line":643,"kind":13,"name":"$mrkGroup","containerName":null},{"kind":13,"line":644,"name":"%alist","containerName":null},{"containerName":null,"name":"$marker","line":644,"kind":13},{"name":"$chr","containerName":null,"line":644,"kind":13},{"line":647,"kind":13,"containerName":null,"name":"$showall"},{"line":647,"kind":13,"name":"%ctgGroup","containerName":null},{"kind":13,"line":648,"name":"$chr","definition":"my","containerName":null,"localvar":"my"},{"name":"$self","containerName":null,"kind":13,"line":648},{"line":648,"kind":12,"name":"group_abbr","containerName":"main::"},{"line":648,"kind":13,"containerName":null,"name":"$mrkGroup"},{"name":"%alist","containerName":null,"line":649,"kind":13},{"line":649,"kind":13,"name":"$marker","containerName":null},{"containerName":null,"name":"$chr","line":649,"kind":13},{"line":653,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$chr"},{"containerName":null,"name":"$ctgGroup","kind":13,"line":653},{"name":"$chr","containerName":null,"kind":13,"line":654},{"containerName":null,"name":"$self","kind":13,"line":654},{"containerName":"main::","name":"group_abbr","kind":12,"line":654},{"kind":13,"line":654,"containerName":null,"name":"$ctgGroup"},{"name":"$ctgGroup","containerName":null,"kind":13,"line":654},{"containerName":null,"name":"%showall","kind":13,"line":656},{"line":658,"kind":13,"containerName":null,"name":"$chr"},{"name":"%_contigs","containerName":null,"kind":13,"line":659},{"name":"%contig","containerName":null,"line":659,"kind":13},{"name":"$ctgGroup","containerName":null,"line":661,"kind":13},{"name":"%ctgGroup","containerName":null,"kind":13,"line":661},{"line":662,"kind":13,"name":"$contig","containerName":null},{"containerName":null,"name":"$chr","kind":13,"line":662},{"kind":13,"line":665,"containerName":null,"name":"$k","definition":"my","localvar":"my"},{"name":"$v","containerName":null,"kind":13,"line":665},{"name":"%list","containerName":null,"line":665,"kind":13},{"name":"$showall","containerName":null,"line":669,"kind":13},{"kind":13,"line":669,"name":"$ctgGroup","containerName":null},{"line":670,"kind":13,"containerName":null,"name":"$ctgGroup"},{"containerName":null,"name":"%showall","line":672,"kind":13},{"kind":13,"line":673,"containerName":null,"definition":"my","name":"$k","localvar":"my"},{"line":673,"kind":13,"containerName":null,"name":"$v"},{"line":673,"kind":13,"name":"%alist","containerName":null},{"range":{"start":{"character":0,"line":692},"end":{"line":695,"character":9999}},"name":"print_markerlist","detail":"($self)","signature":{"label":"print_markerlist($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]\n\n\nsub matching_bands {\n    my($self,$cloneA,$cloneB,$tol) = @_;\n    my($lstart,$kband,$match,$diff,$i,$j);\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    $tol = 7 if (!defined($tol));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @bandsA = @{$_clones{$cloneA}{'bands'}};\n    my @bandsB = @{$_clones{$cloneB}{'bands'}};\n\n    $match  = 0;\n    $lstart = 0;\n\n    for ($i=0; $i<scalar(@bandsA);$i++) {\n\t$kband = $bandsA[$i];\n\tfor ($j = $lstart; $j<scalar(@bandsB); $j++) {\n\t    $diff = $kband - $bandsB[$j];\n\t    if (abs($diff)  <= $tol ) {\n\t\t$match++;\n\t\t$lstart = $j+1;\n\t\tlast;\n\t    }\n\t    elsif ($diff < 0) {\n\t\t$lstart = $j;\n\t\tlast;\n\t    }\n\t}\n    }\n    return $match;\n}\n\n=head2 coincidence_score\n\n Title   : coincidence_score\n Usage   : $self->coincidence_score('cloneA','cloneB'[,$tol,$gellen]);\n Function: given two clones [,tolerence and gellen], this method calculates\n           the Sulston Coincidence score.\n           (this method is ported directly from FPC)\n Returns : scalar representing the Sulston coincidence score.\n Args    : names of the clones ('cloneA', 'cloneB')\n           [Default tol=7 gellen=3300.0]\n\n\nsub coincidence_score {\n    my($self,$cloneA,$cloneB,$tol,$gellen) = @_;\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $numbandsA = scalar(@{$_clones{$cloneA}{'bands'}});\n    my $numbandsB = scalar(@{$_clones{$cloneB}{'bands'}});\n\n    my ($nL,$nH,$m,$i,$psmn,$pp,$pa,$pb,$t,$c,$a,$n);\n    my @logfact;\n    my $score;\n\n    $gellen = 3300.0 if (!defined($gellen));\n    $tol    = 7      if (!defined($tol));\n\n    if ($numbandsA > $numbandsB) {\n\t$nH = $numbandsA;\n\t$nL = $numbandsB;\n    }\n    else {\n\t$nH = $numbandsB;\n\t$nL = $numbandsA;\n    }\n\n    $m = $self->matching_bands($cloneA, $cloneB,$tol);\n\n    $logfact[0] = 0.0;\n    $logfact[1] = 0.0;\n    for ($i=2; $i<=$nL; $i++) {\n\t$logfact[$i] = $logfact[$i - 1] + log($i);\n    }\n\n    $psmn = 1.0 - ((2*$tol)/$gellen);\n\n    $pp = $psmn ** $nH;\n    $pa = log($pp);\n    $pb = log(1 - $pp);\n    $t  = 1e-37;\n\n    for ($n = $m; $n <= $nL; $n++)  {\n\t$c = $logfact[$nL] - $logfact[$nL - $n] - $logfact[$n];\n\t$a = exp($c + ($n * $pb) + (($nL - $n) * $pa));\n\t$t += $a;\n    }\n\n    $score = sprintf(\"%.e\",$t);\n    return $score;\n}\n\n=head2 print_contiglist\n\n Title   : print_contiglist\n Usage   : $map->print_contiglist([showall]); #[Default 0]\n Function: prints the list of contigs, markers that hit the contig, the\n           global position and whether the marker is a placement (P) or\n           a Framework (F) marker.\n Returns : none\n Args    : [showall] [Default 0], 1 includes all the discrepant markers\n\n\nsub print_contiglist{\n    my ($self,$showall) = @_;\n    my $pos;\n\n    $showall = 0 if (!defined($showall));\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n\n    print \"\\n\\nContig List\\n\\n\";\n    foreach my $contig (@sortedcontigs) {\n        my %list;\n\tmy %alist;\n\t\n\tmy $ctgAnchor  = $_contigs{$contig}{'anchor'};\n\tmy $ctgGroup   = $_contigs{$contig}{'group'};\t\n\t\n\tmy @mkr = keys ( %{$_contigs{$contig}{'markers'}} );\n\t\n\tforeach my $marker (@mkr)  {\t\n\t    my $mrkGroup       = $_markers{$marker}{'group'};\n\t    my $mrkGlobal      = $_markers{$marker}{'global'};\n\t    my $mrkFramework   = $_markers{$marker}{'framework'};\n\t    my $mrkAnchor      = $_markers{$marker}{'anchor'}; \t    \t\n\n\t    if($ctgGroup =~ /\\d+|\\w/ && $ctgGroup != 0)  {\t\t\n\t\tif ($mrkGroup eq $ctgGroup) {\n\t\t    if ($mrkFramework == 0)  {\t\t\n\t\t\t$pos = $mrkGlobal.\"P\";\n\t\t    }\n\t\t    else {\n\t\t\t$pos = $mrkGlobal.\"F\";\n\t\t    }\t\t\n\t\t    $list{$marker} = $pos;\n\t\t}\n\t\telsif ($showall == 1) {\t\t\t\n\t\t    my $chr = $self->group_abbr().$mrkGroup;\n\t\t    $alist{$marker} = $chr;\n\t\t} \t\n\t    }\n\t    elsif ($showall == 1 &&  $ctgGroup !~ /\\d+/) {\n\t\tmy $chr = $self->group_abbr().$mrkGroup;\n\t\t$alist{$marker} = $chr;\n\t    }\n\t}\n\t\n\tmy $chr = $ctgGroup;\n\t$chr = $self->group_abbr().$ctgGroup if ($ctgGroup =~ /\\d+|\\w/);\n\t\n\tif ($showall == 1 ) {\n\t   \t\n\t    print \"   ctg$contig  \", $chr, \"  \"\n\t\tif ($_contigs{$contig}{'group'} !~ /\\d+|\\w/);  \t\t\n        }\n\telsif ($ctgGroup =~ /\\d+|\\w/ && $ctgGroup ne 0){\n\t        print \"   ctg\",$contig, \"  \",$chr, \"  \";\n\t}  \t\n\t\n\twhile (my ($k,$v) = each %list) {\n            print \"$k/$v  \";\t\t\n\t}\n\t\n\tprint \"\\n\" if ($showall == 0 && $ctgGroup =~ /\\d+|\\w/ &&\n\t\t       $ctgGroup ne 0 );\n\t\n\tif ($showall == 1) {\n            while (my ($k,$v) = each %alist) {\n\t\tprint \"$k/$v  \";\t\t\n            }  \t\t\n\t    print \"\\n\";\n        }\n    }\n}\n\n=head2 print_markerlist\n\n Title    : print_markerlist\n Usage    : $map->print_markerlist();\n Function : prints the marker list; contig and corresponding number of\n            clones for each marker.\n Returns  : none\n Args     : none"},"containerName":"main::","definition":"sub","line":692,"children":[{"localvar":"my","containerName":"print_markerlist","name":"$self","definition":"my","line":693,"kind":13},{"containerName":"print_markerlist","name":"%_contigs","definition":"my","localvar":"my","kind":13,"line":695},{"line":695,"kind":13,"containerName":"print_markerlist","name":"$self"}],"kind":12},{"kind":13,"line":696,"name":"%_markers","definition":"my","containerName":null,"localvar":"my"},{"name":"%self","containerName":null,"kind":13,"line":696},{"localvar":"my","definition":"my","name":"%_clones","containerName":null,"line":697,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":697},{"localvar":"my","containerName":null,"definition":"my","name":"$marker","line":701,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":701},{"line":701,"kind":12,"name":"each_markerid","containerName":"main::"},{"name":"$marker","containerName":null,"kind":13,"line":702},{"line":704,"kind":13,"localvar":"my","definition":"my","name":"%list","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"%mclones","line":705,"kind":13},{"containerName":null,"name":"%_markers","kind":13,"line":705},{"containerName":null,"name":"%marker","line":705,"kind":13},{"definition":"my","name":"$clone","containerName":null,"localvar":"my","kind":13,"line":707},{"name":"%mclones","containerName":null,"line":707,"kind":13},{"line":708,"kind":13,"name":"%_clones","containerName":null},{"line":708,"kind":13,"containerName":null,"name":"%clone"},{"kind":13,"line":709,"name":"$ctg","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"%_clones","kind":13,"line":709},{"line":709,"kind":13,"name":"%clone","containerName":null},{"kind":13,"line":711,"name":"%list","containerName":null},{"line":711,"kind":13,"containerName":null,"name":"%ctg"},{"name":"$clonehits","definition":"my","containerName":null,"localvar":"my","kind":13,"line":712},{"containerName":null,"name":"%list","line":712,"kind":13},{"kind":13,"line":712,"containerName":null,"name":"$ctg"},{"name":"$clonehits","containerName":null,"line":713,"kind":13},{"line":714,"kind":13,"containerName":null,"name":"%list"},{"line":714,"kind":13,"name":"$ctg","containerName":null},{"kind":13,"line":714,"containerName":null,"name":"%clonehits"},{"line":717,"kind":13,"containerName":null,"name":"%list"},{"kind":13,"line":717,"containerName":null,"name":"$ctg"},{"line":721,"kind":13,"localvar":"my","name":"$k","definition":"my","containerName":null},{"name":"$v","containerName":null,"line":721,"kind":13},{"kind":13,"line":721,"name":"%list","containerName":null},{"name":"print_gffstyle","range":{"start":{"line":739,"character":0},"end":{"line":744,"character":9999}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$style"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]\n\n\nsub matching_bands {\n    my($self,$cloneA,$cloneB,$tol) = @_;\n    my($lstart,$kband,$match,$diff,$i,$j);\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    $tol = 7 if (!defined($tol));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @bandsA = @{$_clones{$cloneA}{'bands'}};\n    my @bandsB = @{$_clones{$cloneB}{'bands'}};\n\n    $match  = 0;\n    $lstart = 0;\n\n    for ($i=0; $i<scalar(@bandsA);$i++) {\n\t$kband = $bandsA[$i];\n\tfor ($j = $lstart; $j<scalar(@bandsB); $j++) {\n\t    $diff = $kband - $bandsB[$j];\n\t    if (abs($diff)  <= $tol ) {\n\t\t$match++;\n\t\t$lstart = $j+1;\n\t\tlast;\n\t    }\n\t    elsif ($diff < 0) {\n\t\t$lstart = $j;\n\t\tlast;\n\t    }\n\t}\n    }\n    return $match;\n}\n\n=head2 coincidence_score\n\n Title   : coincidence_score\n Usage   : $self->coincidence_score('cloneA','cloneB'[,$tol,$gellen]);\n Function: given two clones [,tolerence and gellen], this method calculates\n           the Sulston Coincidence score.\n           (this method is ported directly from FPC)\n Returns : scalar representing the Sulston coincidence score.\n Args    : names of the clones ('cloneA', 'cloneB')\n           [Default tol=7 gellen=3300.0]\n\n\nsub coincidence_score {\n    my($self,$cloneA,$cloneB,$tol,$gellen) = @_;\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $numbandsA = scalar(@{$_clones{$cloneA}{'bands'}});\n    my $numbandsB = scalar(@{$_clones{$cloneB}{'bands'}});\n\n    my ($nL,$nH,$m,$i,$psmn,$pp,$pa,$pb,$t,$c,$a,$n);\n    my @logfact;\n    my $score;\n\n    $gellen = 3300.0 if (!defined($gellen));\n    $tol    = 7      if (!defined($tol));\n\n    if ($numbandsA > $numbandsB) {\n\t$nH = $numbandsA;\n\t$nL = $numbandsB;\n    }\n    else {\n\t$nH = $numbandsB;\n\t$nL = $numbandsA;\n    }\n\n    $m = $self->matching_bands($cloneA, $cloneB,$tol);\n\n    $logfact[0] = 0.0;\n    $logfact[1] = 0.0;\n    for ($i=2; $i<=$nL; $i++) {\n\t$logfact[$i] = $logfact[$i - 1] + log($i);\n    }\n\n    $psmn = 1.0 - ((2*$tol)/$gellen);\n\n    $pp = $psmn ** $nH;\n    $pa = log($pp);\n    $pb = log(1 - $pp);\n    $t  = 1e-37;\n\n    for ($n = $m; $n <= $nL; $n++)  {\n\t$c = $logfact[$nL] - $logfact[$nL - $n] - $logfact[$n];\n\t$a = exp($c + ($n * $pb) + (($nL - $n) * $pa));\n\t$t += $a;\n    }\n\n    $score = sprintf(\"%.e\",$t);\n    return $score;\n}\n\n=head2 print_contiglist\n\n Title   : print_contiglist\n Usage   : $map->print_contiglist([showall]); #[Default 0]\n Function: prints the list of contigs, markers that hit the contig, the\n           global position and whether the marker is a placement (P) or\n           a Framework (F) marker.\n Returns : none\n Args    : [showall] [Default 0], 1 includes all the discrepant markers\n\n\nsub print_contiglist{\n    my ($self,$showall) = @_;\n    my $pos;\n\n    $showall = 0 if (!defined($showall));\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n\n    print \"\\n\\nContig List\\n\\n\";\n    foreach my $contig (@sortedcontigs) {\n        my %list;\n\tmy %alist;\n\t\n\tmy $ctgAnchor  = $_contigs{$contig}{'anchor'};\n\tmy $ctgGroup   = $_contigs{$contig}{'group'};\t\n\t\n\tmy @mkr = keys ( %{$_contigs{$contig}{'markers'}} );\n\t\n\tforeach my $marker (@mkr)  {\t\n\t    my $mrkGroup       = $_markers{$marker}{'group'};\n\t    my $mrkGlobal      = $_markers{$marker}{'global'};\n\t    my $mrkFramework   = $_markers{$marker}{'framework'};\n\t    my $mrkAnchor      = $_markers{$marker}{'anchor'}; \t    \t\n\n\t    if($ctgGroup =~ /\\d+|\\w/ && $ctgGroup != 0)  {\t\t\n\t\tif ($mrkGroup eq $ctgGroup) {\n\t\t    if ($mrkFramework == 0)  {\t\t\n\t\t\t$pos = $mrkGlobal.\"P\";\n\t\t    }\n\t\t    else {\n\t\t\t$pos = $mrkGlobal.\"F\";\n\t\t    }\t\t\n\t\t    $list{$marker} = $pos;\n\t\t}\n\t\telsif ($showall == 1) {\t\t\t\n\t\t    my $chr = $self->group_abbr().$mrkGroup;\n\t\t    $alist{$marker} = $chr;\n\t\t} \t\n\t    }\n\t    elsif ($showall == 1 &&  $ctgGroup !~ /\\d+/) {\n\t\tmy $chr = $self->group_abbr().$mrkGroup;\n\t\t$alist{$marker} = $chr;\n\t    }\n\t}\n\t\n\tmy $chr = $ctgGroup;\n\t$chr = $self->group_abbr().$ctgGroup if ($ctgGroup =~ /\\d+|\\w/);\n\t\n\tif ($showall == 1 ) {\n\t   \t\n\t    print \"   ctg$contig  \", $chr, \"  \"\n\t\tif ($_contigs{$contig}{'group'} !~ /\\d+|\\w/);  \t\t\n        }\n\telsif ($ctgGroup =~ /\\d+|\\w/ && $ctgGroup ne 0){\n\t        print \"   ctg\",$contig, \"  \",$chr, \"  \";\n\t}  \t\n\t\n\twhile (my ($k,$v) = each %list) {\n            print \"$k/$v  \";\t\t\n\t}\n\t\n\tprint \"\\n\" if ($showall == 0 && $ctgGroup =~ /\\d+|\\w/ &&\n\t\t       $ctgGroup ne 0 );\n\t\n\tif ($showall == 1) {\n            while (my ($k,$v) = each %alist) {\n\t\tprint \"$k/$v  \";\t\t\n            }  \t\t\n\t    print \"\\n\";\n        }\n    }\n}\n\n=head2 print_markerlist\n\n Title    : print_markerlist\n Usage    : $map->print_markerlist();\n Function : prints the marker list; contig and corresponding number of\n            clones for each marker.\n Returns  : none\n Args     : none\n\n\nsub print_markerlist {\n    my ($self) = @_;\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    print \"Marker List\\n\\n\";\n\n    foreach my $marker ($self->each_markerid()) {\n        print \"  \",$marker, \"  \";\n\t\n\tmy %list;\n\tmy %mclones = %{$_markers{$marker}{'clones'}};\n\t\n\tforeach my $clone (%mclones) {\n\t    if (exists($_clones{$clone}{'contig'}) ) {\n\t\tmy $ctg = $_clones{$clone}{'contig'};\n\t\t\n\t\tif (exists($list{$ctg})) {\n\t\t    my $clonehits = $list{$ctg};\n\t\t    $clonehits++;\n\t\t    $list{$ctg} = $clonehits;\n\t\t}\n\t\telse {\n\t\t    $list{$ctg} = 1;\n\t\t}\n\t    }\n\t}\n\twhile (my ($k,$v) = each %list) {\n\t    print \"$k/$v  \";\n        }\n        print \"\\n\";\n    }\n}\n\n=head2 print_gffstyle\n\n Title    : print_gffstyle\n Usage    : $map->print_gffstyle([style]);\n Function : prints GFF; either Contigwise (default) or Groupwise\n Returns  : none\n Args     : [style] default = 0 contigwise, else\n                              1 groupwise (chromosome-wise).","label":"print_gffstyle($self,$style)"},"detail":"($self,$style)","kind":12,"children":[{"localvar":"my","containerName":"print_gffstyle","name":"$self","definition":"my","line":740,"kind":13},{"kind":13,"line":740,"name":"$style","containerName":"print_gffstyle"},{"containerName":"print_gffstyle","name":"$style","line":742,"kind":13},{"name":"$style","containerName":"print_gffstyle","line":742,"kind":13},{"kind":13,"line":744,"containerName":"print_gffstyle","definition":"my","name":"%_contigs","localvar":"my"},{"containerName":"print_gffstyle","name":"$self","kind":13,"line":744}],"line":739},{"containerName":null,"name":"%_markers","definition":"my","localvar":"my","kind":13,"line":745},{"containerName":null,"name":"%self","line":745,"kind":13},{"line":746,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"%_clones"},{"kind":13,"line":746,"name":"%self","containerName":null},{"localvar":"my","containerName":null,"name":"$i","definition":"my","line":748,"kind":13},{"containerName":null,"definition":"my","name":"$depth","localvar":"my","kind":13,"line":749},{"line":749,"kind":13,"containerName":null,"name":"$save_depth"},{"kind":13,"line":750,"definition":"my","name":"$x","containerName":null,"localvar":"my"},{"name":"$y","containerName":null,"line":750,"kind":13},{"line":751,"kind":13,"localvar":"my","definition":"my","name":"@stack","containerName":null},{"line":752,"kind":13,"localvar":"my","name":"$k","definition":"my","containerName":null},{"containerName":null,"name":"$j","kind":13,"line":752},{"kind":13,"line":752,"containerName":null,"name":"$s"},{"kind":13,"line":753,"containerName":null,"name":"$pos","definition":"my","localvar":"my"},{"kind":13,"line":754,"definition":"my","name":"$contig","containerName":null,"localvar":"my"},{"localvar":"my","containerName":null,"name":"@contigs","definition":"my","line":758,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":758},{"line":758,"kind":12,"containerName":"main::","name":"each_contigid"},{"name":"@sortedcontigs","definition":"my","containerName":null,"localvar":"my","kind":13,"line":759},{"kind":13,"line":759,"containerName":null,"name":"$a"},{"name":"$b","containerName":null,"line":759,"kind":13},{"name":"@contigs","containerName":null,"line":759,"kind":13},{"line":760,"kind":13,"localvar":"my","name":"$offset","definition":"my","containerName":null},{"localvar":"my","containerName":null,"name":"%gffclones","definition":"my","line":761,"kind":13},{"kind":13,"line":762,"name":"%gffcontigs","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":763,"name":"%gffmarkers","definition":"my","containerName":null,"localvar":"my"},{"localvar":"my","containerName":null,"name":"$basepair","definition":"my","line":764,"kind":13},{"kind":13,"line":766,"containerName":null,"definition":"my","name":"$contig","localvar":"my"},{"containerName":null,"name":"@sortedcontigs","kind":13,"line":766},{"containerName":null,"name":"%_contigs","kind":13,"line":767},{"name":"%contig","containerName":null,"kind":13,"line":767},{"name":"$offset","containerName":null,"line":768,"kind":13},{"containerName":null,"name":"%_contigs","line":768,"kind":13},{"line":768,"kind":13,"containerName":null,"name":"%contig"},{"containerName":null,"name":"%offset","line":770,"kind":13},{"kind":13,"line":771,"name":"$offset","containerName":null},{"name":"$offset","containerName":null,"line":771,"kind":13},{"containerName":null,"name":"%gffcontigs","kind":13,"line":772},{"line":772,"kind":13,"name":"%contig","containerName":null},{"name":"%gffcontigs","containerName":null,"line":773,"kind":13},{"kind":13,"line":773,"containerName":null,"name":"%contig"},{"containerName":null,"name":"%_contigs","kind":13,"line":774},{"containerName":null,"name":"%contig","kind":13,"line":774},{"line":775,"kind":13,"name":"$offset","containerName":null},{"kind":13,"line":775,"containerName":null,"name":"%basepair"},{"containerName":null,"name":"$offset","kind":13,"line":778},{"containerName":null,"name":"%gffcontigs","line":779,"kind":13},{"kind":13,"line":779,"containerName":null,"name":"%contig"},{"name":"%_contigs","containerName":null,"line":780,"kind":13},{"kind":13,"line":780,"containerName":null,"name":"%contig"},{"kind":13,"line":780,"name":"$basepair","containerName":null},{"line":781,"kind":13,"name":"%gffcontigs","containerName":null},{"kind":13,"line":781,"containerName":null,"name":"%contig"},{"name":"%_contigs","containerName":null,"kind":13,"line":782},{"containerName":null,"name":"%contig","kind":13,"line":782},{"kind":13,"line":782,"name":"%basepair","containerName":null},{"line":786,"kind":13,"containerName":null,"name":"%gffcontigs"},{"name":"%contig","containerName":null,"kind":13,"line":786},{"kind":13,"line":787,"name":"%gffcontigs","containerName":null},{"name":"%contig","containerName":null,"kind":13,"line":787},{"kind":13,"line":790,"definition":"my","name":"@clones","containerName":null,"localvar":"my"},{"containerName":null,"name":"%_contigs","kind":13,"line":790},{"name":"%contig","containerName":null,"line":790,"kind":13},{"line":791,"kind":13,"localvar":"my","name":"$clone","definition":"my","containerName":null},{"line":791,"kind":13,"name":"@clones","containerName":null},{"kind":13,"line":792,"containerName":null,"name":"%_clones"},{"containerName":null,"name":"%clone","line":792,"kind":13},{"line":793,"kind":13,"localvar":"my","name":"$gffclone","definition":"my","containerName":null},{"containerName":null,"name":"$clone","line":793,"kind":13},{"line":795,"kind":13,"name":"$gffclone","containerName":null},{"name":"%gffclones","containerName":null,"kind":13,"line":797},{"containerName":null,"name":"%gffclone","kind":13,"line":797},{"line":798,"kind":13,"name":"%_clones","containerName":null},{"name":"%clone","containerName":null,"line":798,"kind":13},{"name":"$offset","containerName":null,"line":798,"kind":13},{"kind":13,"line":799,"containerName":null,"name":"$basepair"},{"containerName":null,"name":"%gffclones","line":801,"kind":13},{"containerName":null,"name":"%gffclone","kind":13,"line":801},{"name":"%_clones","containerName":null,"line":802,"kind":13},{"containerName":null,"name":"%clone","kind":13,"line":802},{"line":803,"kind":13,"containerName":null,"name":"$offset"},{"containerName":null,"name":"$basepair","line":803,"kind":13},{"containerName":null,"name":"%contig","kind":13,"line":806},{"line":807,"kind":13,"localvar":"my","name":"%markers","definition":"my","containerName":null},{"line":807,"kind":13,"containerName":null,"name":"%_clones"},{"line":807,"kind":13,"containerName":null,"name":"%clone"},{"line":808,"kind":13,"containerName":null,"name":"%_clones"},{"kind":13,"line":808,"name":"%clone","containerName":null},{"localvar":"my","name":"$k","definition":"my","containerName":null,"line":810,"kind":13},{"line":810,"kind":13,"name":"$v","containerName":null},{"kind":13,"line":810,"name":"%markers","containerName":null},{"name":"%gffmarkers","containerName":null,"kind":13,"line":811},{"kind":13,"line":811,"containerName":null,"name":"%contig"},{"kind":13,"line":811,"name":"$k","containerName":null},{"kind":13,"line":812,"name":"%_clones","containerName":null},{"containerName":null,"name":"%clone","line":812,"kind":13},{"line":813,"kind":13,"name":"%_clones","containerName":null},{"line":813,"kind":13,"containerName":null,"name":"%clone"},{"kind":13,"line":814,"name":"$basepair","containerName":null},{"kind":13,"line":819,"name":"%contig","containerName":null},{"kind":13,"line":820,"definition":"my","name":"%markers","containerName":null,"localvar":"my"},{"line":820,"kind":13,"containerName":null,"name":"%_contigs"},{"containerName":null,"name":"%contig","kind":13,"line":820},{"kind":13,"line":821,"containerName":null,"name":"%_contigs"},{"containerName":null,"name":"%contig","kind":13,"line":821},{"localvar":"my","definition":"my","name":"$k","containerName":null,"line":823,"kind":13},{"kind":13,"line":823,"name":"$v","containerName":null},{"line":823,"kind":13,"containerName":null,"name":"%markers"},{"name":"%gffmarkers","containerName":null,"kind":13,"line":824},{"name":"%contig","containerName":null,"kind":13,"line":824},{"containerName":null,"name":"$k","kind":13,"line":824},{"kind":13,"line":824,"containerName":null,"name":"$v"},{"kind":13,"line":824,"containerName":null,"name":"$offset"},{"containerName":null,"name":"$basepair","line":824,"kind":13},{"line":829,"kind":13,"containerName":null,"name":"%style"},{"localvar":"my","name":"$contig","definition":"my","containerName":null,"line":830,"kind":13},{"name":"@sortedcontigs","containerName":null,"line":830,"kind":13},{"kind":13,"line":832,"containerName":null,"name":"%_contigs"},{"kind":13,"line":832,"name":"%contig","containerName":null},{"kind":13,"line":834,"containerName":null,"name":"%gffcontigs"},{"name":"%contig","containerName":null,"line":834,"kind":13},{"containerName":null,"name":"%gffcontigs","line":835,"kind":13},{"containerName":null,"name":"%contig","kind":13,"line":835},{"kind":13,"line":840,"definition":"my","name":"@clones","containerName":null,"localvar":"my"},{"name":"%_contigs","containerName":null,"kind":13,"line":840},{"containerName":null,"name":"%contig","line":840,"kind":13},{"kind":13,"line":842,"containerName":null,"definition":"my","name":"$clone","localvar":"my"},{"name":"@clones","containerName":null,"kind":13,"line":842},{"kind":13,"line":843,"name":"%_clones","containerName":null},{"line":843,"kind":13,"name":"%clone","containerName":null},{"line":846,"kind":13,"localvar":"my","name":"$type","definition":"my","containerName":null},{"kind":13,"line":846,"containerName":null,"name":"%_clones"},{"line":846,"kind":13,"containerName":null,"name":"%clone"},{"line":848,"kind":13,"name":"%clone","containerName":null},{"line":849,"kind":13,"containerName":null,"name":"$clone"},{"line":850,"kind":13,"name":"$type","containerName":null},{"containerName":null,"name":"%gffclones","kind":13,"line":852},{"containerName":null,"name":"%clone","kind":13,"line":852},{"kind":13,"line":853,"containerName":null,"name":"%gffclones"},{"kind":13,"line":853,"containerName":null,"name":"%clone"},{"kind":13,"line":856,"containerName":null,"name":"@markers","definition":"my","localvar":"my"},{"line":856,"kind":13,"name":"%_clones","containerName":null},{"kind":13,"line":856,"name":"%clone","containerName":null},{"line":857,"kind":13,"name":"@markers","containerName":null},{"definition":"my","name":"$mkr","containerName":null,"localvar":"my","kind":13,"line":859},{"name":"@markers","containerName":null,"kind":13,"line":859},{"kind":13,"line":860,"containerName":null,"name":"%_markers"},{"containerName":null,"name":"%mkr","kind":13,"line":860},{"containerName":null,"name":"%_markers","kind":13,"line":861},{"kind":13,"line":861,"containerName":null,"name":"%mkr"},{"name":"%_markers","containerName":null,"line":862,"kind":13},{"kind":13,"line":862,"name":"%mkr","containerName":null},{"kind":13,"line":868,"containerName":null,"name":"%_clones"},{"name":"%clone","containerName":null,"line":868,"kind":13},{"containerName":null,"name":"%_clones","kind":13,"line":869},{"name":"%clone","containerName":null,"line":869,"kind":13},{"name":"%_contigs","containerName":null,"line":874,"kind":13},{"line":874,"kind":13,"containerName":null,"name":"%contig"},{"containerName":null,"definition":"my","name":"%list","localvar":"my","kind":13,"line":875},{"line":875,"kind":13,"name":"%_contigs","containerName":null},{"name":"%contig","containerName":null,"kind":13,"line":875},{"localvar":"my","name":"$k","definition":"my","containerName":null,"line":877,"kind":13},{"line":877,"kind":13,"containerName":null,"name":"$v"},{"kind":13,"line":877,"name":"%list","containerName":null},{"name":"$contig","containerName":null,"line":878,"kind":13},{"definition":"my","name":"$position","containerName":null,"localvar":"my","kind":13,"line":879},{"line":879,"kind":13,"containerName":null,"name":"%gffmarkers"},{"name":"%contig","containerName":null,"kind":13,"line":879},{"name":"$k","containerName":null,"kind":13,"line":879},{"localvar":"my","name":"$type","definition":"my","containerName":null,"line":881,"kind":13},{"name":"$type","containerName":null,"line":883,"kind":13},{"kind":13,"line":884,"containerName":null,"name":"%_markers"},{"kind":13,"line":884,"containerName":null,"name":"%k"},{"line":886,"kind":13,"containerName":null,"name":"%_markers"},{"name":"%k","containerName":null,"line":886,"kind":13},{"name":"$type","containerName":null,"kind":13,"line":887},{"containerName":null,"name":"%_markers","kind":13,"line":888},{"containerName":null,"name":"%k","line":888,"kind":13},{"line":890,"kind":13,"name":"$type","containerName":null},{"containerName":null,"name":"%_markers","line":891,"kind":13},{"kind":13,"line":891,"name":"%k","containerName":null},{"line":894,"kind":13,"name":"$position","containerName":null},{"kind":13,"line":894,"containerName":null,"name":"$position"},{"line":897,"kind":13,"localvar":"my","name":"@clonelist","definition":"my","containerName":null},{"line":898,"kind":13,"localvar":"my","definition":"my","name":"@clones","containerName":null},{"name":"%_markers","containerName":null,"line":898,"kind":13},{"name":"%k","containerName":null,"line":898,"kind":13},{"kind":13,"line":900,"name":"$cl","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":900,"name":"@clones","containerName":null},{"name":"@clonelist","containerName":null,"kind":13,"line":901},{"kind":13,"line":901,"containerName":null,"name":"$cl"},{"line":902,"kind":13,"containerName":null,"name":"%_clones"},{"kind":13,"line":902,"containerName":null,"name":"%cl"},{"kind":13,"line":902,"containerName":null,"name":"$contig"},{"name":"@clonelist","containerName":null,"line":906,"kind":13},{"kind":13,"line":913,"containerName":null,"definition":"my","name":"%_groups","localvar":"my"},{"localvar":"my","containerName":null,"definition":"my","name":"$margin","line":914,"kind":13},{"containerName":null,"name":"$basepair","line":914,"kind":13},{"kind":13,"line":915,"containerName":null,"name":"$displacement","definition":"my","localvar":"my"},{"line":916,"kind":13,"localvar":"my","definition":"my","name":"@grouplist","containerName":null},{"localvar":"my","containerName":null,"name":"$contig","definition":"my","line":918,"kind":13},{"kind":13,"line":918,"name":"@sortedcontigs","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"$recordchr","line":919,"kind":13},{"localvar":"my","containerName":null,"definition":"my","name":"$chr","line":920,"kind":13},{"kind":13,"line":920,"name":"%_contigs","containerName":null},{"line":920,"kind":13,"name":"%contig","containerName":null},{"name":"$chr","containerName":null,"kind":13,"line":921},{"line":921,"kind":13,"name":"$chr","containerName":null},{"containerName":null,"name":"%recordchr","kind":13,"line":923},{"name":"group","line":923,"kind":12},{"containerName":null,"name":"$chr","kind":13,"line":923},{"kind":13,"line":924,"containerName":null,"name":"%recordchr"},{"line":924,"kind":12,"name":"contig"},{"line":924,"kind":13,"name":"$contig","containerName":null},{"name":"%recordchr","containerName":null,"line":925,"kind":13},{"line":925,"kind":12,"name":"position"},{"name":"%_contigs","containerName":null,"line":925,"kind":13},{"name":"%contig","containerName":null,"kind":13,"line":925},{"line":927,"kind":13,"name":"@grouplist","containerName":null},{"kind":13,"line":927,"name":"$recordchr","containerName":null},{"kind":13,"line":930,"name":"@chr","definition":"my","containerName":null,"localvar":"my"},{"line":930,"kind":13,"name":"%_groups","containerName":null},{"line":931,"kind":13,"localvar":"my","containerName":null,"name":"@sortedchr","definition":"my"},{"kind":13,"line":933,"name":"$self","containerName":null},{"line":933,"kind":12,"name":"group_type","containerName":"main::"},{"name":"@sortedchr","containerName":null,"line":934,"kind":13},{"line":934,"kind":13,"containerName":null,"name":"%a"},{"containerName":null,"name":"%b","line":934,"kind":13},{"containerName":null,"name":"%a","kind":13,"line":936},{"containerName":null,"name":"%b","line":936,"kind":13},{"kind":13,"line":937,"containerName":null,"name":"@grouplist"},{"containerName":null,"name":"@sortedchr","line":940,"kind":13},{"line":940,"kind":13,"containerName":null,"name":"%a"},{"containerName":null,"name":"%b","line":940,"kind":13},{"kind":13,"line":942,"name":"%a","containerName":null},{"containerName":null,"name":"%b","kind":13,"line":942},{"containerName":null,"name":"@grouplist","kind":13,"line":943},{"line":945,"kind":13,"localvar":"my","containerName":null,"name":"$lastchr","definition":"my"},{"line":946,"kind":13,"localvar":"my","containerName":null,"name":"$chrend","definition":"my"},{"containerName":null,"definition":"my","name":"$chr","localvar":"my","kind":13,"line":948},{"kind":13,"line":948,"containerName":null,"name":"@sortedchr"},{"name":"$chrname","definition":"my","containerName":null,"localvar":"my","kind":13,"line":949},{"kind":13,"line":949,"name":"$self","containerName":null},{"kind":12,"line":949,"containerName":"main::","name":"group_abbr"},{"name":"%chr","containerName":null,"kind":13,"line":949},{"line":951,"kind":13,"name":"$lastchr","containerName":null},{"containerName":null,"name":"%chr","kind":13,"line":951},{"kind":13,"line":951,"containerName":null,"name":"%lastchr"},{"kind":13,"line":952,"containerName":null,"name":"$lastchr"},{"containerName":null,"name":"%chr","kind":13,"line":952},{"line":952,"kind":13,"name":"$lastchr","containerName":null},{"containerName":null,"name":"$displacement","kind":13,"line":953},{"kind":13,"line":956,"name":"$ctgcount","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":957,"containerName":null,"definition":"my","name":"$prevchr","localvar":"my"},{"name":"$chrend","containerName":null,"line":958,"kind":13},{"kind":13,"line":960,"containerName":null,"name":"%chr"},{"kind":12,"line":960,"name":"contig"},{"localvar":"my","containerName":null,"name":"$ch","definition":"my","line":961,"kind":13},{"name":"@sortedchr","containerName":null,"kind":13,"line":961},{"kind":13,"line":962,"containerName":null,"name":"%ch"},{"kind":13,"line":962,"containerName":null,"name":"%chr"},{"containerName":null,"name":"%ch","line":963,"kind":13},{"localvar":"my","containerName":null,"definition":"my","name":"$ctg","line":964,"kind":13},{"line":964,"kind":13,"name":"%ch","containerName":null},{"line":965,"kind":13,"name":"%ch","containerName":null},{"kind":13,"line":967,"name":"$chrend","containerName":null},{"kind":13,"line":967,"containerName":null,"name":"%gffcontigs"},{"containerName":null,"name":"%ctg","kind":13,"line":967},{"containerName":null,"name":"$ctgcount","line":968,"kind":13},{"containerName":null,"name":"$chrend","line":972,"kind":13},{"line":972,"kind":13,"containerName":null,"name":"$ctgcount"},{"line":972,"kind":13,"name":"%margin","containerName":null},{"containerName":null,"name":"$chrend","kind":13,"line":975},{"name":"%gffcontigs","containerName":null,"kind":13,"line":975},{"kind":13,"line":978,"containerName":null,"name":"$chrname"},{"kind":13,"line":978,"containerName":null,"name":"$self"},{"containerName":"main::","name":"group_abbr","kind":12,"line":978},{"kind":13,"line":979,"containerName":null,"name":"%chr"},{"kind":13,"line":981,"name":"$chrname","containerName":null},{"line":986,"kind":13,"name":"$chrname","containerName":null},{"line":989,"kind":13,"name":"%chr","containerName":null},{"name":"$lastchr","containerName":null,"line":989,"kind":13},{"containerName":null,"name":"%chr","line":989,"kind":13},{"containerName":null,"name":"$lastchr","kind":13,"line":991},{"containerName":null,"name":"%chr","line":991,"kind":13},{"name":"$lastchr","containerName":null,"line":992,"kind":13},{"containerName":null,"name":"%chr","kind":13,"line":992},{"line":994,"kind":13,"localvar":"my","name":"$contig","definition":"my","containerName":null},{"name":"%chr","containerName":null,"kind":13,"line":994},{"containerName":null,"name":"%_contigs","kind":13,"line":996},{"name":"%contig","containerName":null,"line":996,"kind":13},{"kind":13,"line":998,"containerName":null,"name":"$chrname"},{"name":"%gffcontigs","containerName":null,"kind":13,"line":999},{"name":"%contig","containerName":null,"kind":13,"line":999},{"name":"$displacement","containerName":null,"line":999,"kind":13},{"name":"%gffcontigs","containerName":null,"line":1000,"kind":13},{"line":1000,"kind":13,"containerName":null,"name":"%contig"},{"name":"$displacement","containerName":null,"kind":13,"line":1000},{"name":"@clones","definition":"my","containerName":null,"localvar":"my","kind":13,"line":1005},{"containerName":null,"name":"%_contigs","line":1005,"kind":13},{"name":"%contig","containerName":null,"line":1005,"kind":13},{"localvar":"my","name":"$clone","definition":"my","containerName":null,"line":1006,"kind":13},{"containerName":null,"name":"@clones","kind":13,"line":1006},{"containerName":null,"name":"%_clones","kind":13,"line":1007},{"line":1007,"kind":13,"containerName":null,"name":"%clone"},{"name":"$chrname","containerName":null,"line":1008,"kind":13},{"localvar":"my","definition":"my","name":"$type","containerName":null,"line":1009,"kind":13},{"name":"%_clones","containerName":null,"kind":13,"line":1009},{"name":"%clone","containerName":null,"kind":13,"line":1009},{"kind":13,"line":1011,"containerName":null,"name":"%clone"},{"name":"$clone","containerName":null,"line":1012,"kind":13},{"name":"$type","containerName":null,"line":1013,"kind":13},{"name":"%gffclones","containerName":null,"line":1016,"kind":13},{"containerName":null,"name":"%clone","kind":13,"line":1016},{"name":"$displacement","containerName":null,"line":1017,"kind":13},{"kind":13,"line":1017,"containerName":null,"name":"%gffclones"},{"name":"%clone","containerName":null,"kind":13,"line":1017},{"containerName":null,"name":"$displacement","kind":13,"line":1018},{"kind":13,"line":1021,"definition":"my","name":"@markers","containerName":null,"localvar":"my"},{"containerName":null,"name":"%_clones","line":1021,"kind":13},{"containerName":null,"name":"%clone","kind":13,"line":1021},{"containerName":null,"name":"@markers","line":1022,"kind":13},{"containerName":null,"definition":"my","name":"$mkr","localvar":"my","kind":13,"line":1024},{"name":"@markers","containerName":null,"line":1024,"kind":13},{"containerName":null,"name":"%_markers","kind":13,"line":1025},{"line":1025,"kind":13,"containerName":null,"name":"%mkr"},{"containerName":null,"name":"%_markers","line":1026,"kind":13},{"containerName":null,"name":"%mkr","line":1026,"kind":13},{"name":"%_markers","containerName":null,"line":1027,"kind":13},{"line":1027,"kind":13,"containerName":null,"name":"%mkr"},{"kind":13,"line":1033,"containerName":null,"name":"%_clones"},{"line":1033,"kind":13,"containerName":null,"name":"%clone"},{"kind":13,"line":1034,"containerName":null,"name":"%_clones"},{"containerName":null,"name":"%clone","line":1034,"kind":13},{"name":"%_contigs","containerName":null,"line":1039,"kind":13},{"name":"%contig","containerName":null,"kind":13,"line":1039},{"kind":13,"line":1040,"containerName":null,"name":"%list","definition":"my","localvar":"my"},{"name":"%_contigs","containerName":null,"line":1040,"kind":13},{"name":"%contig","containerName":null,"kind":13,"line":1040},{"containerName":null,"definition":"my","name":"$k","localvar":"my","kind":13,"line":1042},{"line":1042,"kind":13,"containerName":null,"name":"$v"},{"line":1042,"kind":13,"name":"%list","containerName":null},{"containerName":null,"name":"$chrname","line":1043,"kind":13},{"line":1044,"kind":13,"localvar":"my","name":"$type","definition":"my","containerName":null},{"name":"$type","containerName":null,"line":1046,"kind":13},{"containerName":null,"name":"%_markers","line":1047,"kind":13},{"containerName":null,"name":"%k","kind":13,"line":1047},{"kind":13,"line":1049,"containerName":null,"name":"%_markers"},{"name":"%k","containerName":null,"line":1049,"kind":13},{"line":1050,"kind":13,"name":"$type","containerName":null},{"line":1051,"kind":13,"containerName":null,"name":"%_markers"},{"kind":13,"line":1051,"containerName":null,"name":"%k"},{"name":"$type","containerName":null,"kind":13,"line":1053},{"name":"%_markers","containerName":null,"kind":13,"line":1054},{"kind":13,"line":1054,"name":"%k","containerName":null},{"name":"%gffmarkers","containerName":null,"kind":13,"line":1057},{"containerName":null,"name":"%contig","kind":13,"line":1057},{"kind":13,"line":1057,"containerName":null,"name":"$k"},{"containerName":null,"name":"$displacement","line":1058,"kind":13},{"line":1058,"kind":13,"containerName":null,"name":"%gffmarkers"},{"line":1058,"kind":13,"containerName":null,"name":"%contig"},{"name":"$k","containerName":null,"line":1058,"kind":13},{"line":1059,"kind":13,"name":"$displacement","containerName":null},{"line":1062,"kind":13,"localvar":"my","name":"@clonelist","definition":"my","containerName":null},{"line":1063,"kind":13,"localvar":"my","containerName":null,"name":"@clones","definition":"my"},{"containerName":null,"name":"%_markers","line":1063,"kind":13},{"line":1063,"kind":13,"name":"%k","containerName":null},{"localvar":"my","definition":"my","name":"$cl","containerName":null,"line":1065,"kind":13},{"name":"@clones","containerName":null,"line":1065,"kind":13},{"kind":13,"line":1066,"containerName":null,"name":"@clonelist"},{"kind":13,"line":1066,"name":"$cl","containerName":null},{"containerName":null,"name":"%_clones","line":1067,"kind":13},{"kind":13,"line":1067,"name":"%cl","containerName":null},{"kind":13,"line":1067,"containerName":null,"name":"$contig"},{"containerName":null,"name":"@clonelist","kind":13,"line":1072},{"name":"$displacement","containerName":null,"line":1075,"kind":13},{"kind":13,"line":1075,"containerName":null,"name":"$margin"},{"containerName":null,"name":"%gffcontigs","kind":13,"line":1075},{"kind":13,"line":1075,"name":"%contig","containerName":null},{"name":"_calc_markerposition","range":{"end":{"line":1092,"character":9999},"start":{"line":1090,"character":0}},"kind":12,"line":1090,"children":[{"localvar":"my","containerName":"_calc_markerposition","name":"$self","definition":"my","line":1091,"kind":13},{"localvar":"my","name":"%_contigs","definition":"my","containerName":"_calc_markerposition","line":1092,"kind":13},{"name":"$self","containerName":"_calc_markerposition","line":1092,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]\n\n\nsub matching_bands {\n    my($self,$cloneA,$cloneB,$tol) = @_;\n    my($lstart,$kband,$match,$diff,$i,$j);\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    $tol = 7 if (!defined($tol));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @bandsA = @{$_clones{$cloneA}{'bands'}};\n    my @bandsB = @{$_clones{$cloneB}{'bands'}};\n\n    $match  = 0;\n    $lstart = 0;\n\n    for ($i=0; $i<scalar(@bandsA);$i++) {\n\t$kband = $bandsA[$i];\n\tfor ($j = $lstart; $j<scalar(@bandsB); $j++) {\n\t    $diff = $kband - $bandsB[$j];\n\t    if (abs($diff)  <= $tol ) {\n\t\t$match++;\n\t\t$lstart = $j+1;\n\t\tlast;\n\t    }\n\t    elsif ($diff < 0) {\n\t\t$lstart = $j;\n\t\tlast;\n\t    }\n\t}\n    }\n    return $match;\n}\n\n=head2 coincidence_score\n\n Title   : coincidence_score\n Usage   : $self->coincidence_score('cloneA','cloneB'[,$tol,$gellen]);\n Function: given two clones [,tolerence and gellen], this method calculates\n           the Sulston Coincidence score.\n           (this method is ported directly from FPC)\n Returns : scalar representing the Sulston coincidence score.\n Args    : names of the clones ('cloneA', 'cloneB')\n           [Default tol=7 gellen=3300.0]\n\n\nsub coincidence_score {\n    my($self,$cloneA,$cloneB,$tol,$gellen) = @_;\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $numbandsA = scalar(@{$_clones{$cloneA}{'bands'}});\n    my $numbandsB = scalar(@{$_clones{$cloneB}{'bands'}});\n\n    my ($nL,$nH,$m,$i,$psmn,$pp,$pa,$pb,$t,$c,$a,$n);\n    my @logfact;\n    my $score;\n\n    $gellen = 3300.0 if (!defined($gellen));\n    $tol    = 7      if (!defined($tol));\n\n    if ($numbandsA > $numbandsB) {\n\t$nH = $numbandsA;\n\t$nL = $numbandsB;\n    }\n    else {\n\t$nH = $numbandsB;\n\t$nL = $numbandsA;\n    }\n\n    $m = $self->matching_bands($cloneA, $cloneB,$tol);\n\n    $logfact[0] = 0.0;\n    $logfact[1] = 0.0;\n    for ($i=2; $i<=$nL; $i++) {\n\t$logfact[$i] = $logfact[$i - 1] + log($i);\n    }\n\n    $psmn = 1.0 - ((2*$tol)/$gellen);\n\n    $pp = $psmn ** $nH;\n    $pa = log($pp);\n    $pb = log(1 - $pp);\n    $t  = 1e-37;\n\n    for ($n = $m; $n <= $nL; $n++)  {\n\t$c = $logfact[$nL] - $logfact[$nL - $n] - $logfact[$n];\n\t$a = exp($c + ($n * $pb) + (($nL - $n) * $pa));\n\t$t += $a;\n    }\n\n    $score = sprintf(\"%.e\",$t);\n    return $score;\n}\n\n=head2 print_contiglist\n\n Title   : print_contiglist\n Usage   : $map->print_contiglist([showall]); #[Default 0]\n Function: prints the list of contigs, markers that hit the contig, the\n           global position and whether the marker is a placement (P) or\n           a Framework (F) marker.\n Returns : none\n Args    : [showall] [Default 0], 1 includes all the discrepant markers\n\n\nsub print_contiglist{\n    my ($self,$showall) = @_;\n    my $pos;\n\n    $showall = 0 if (!defined($showall));\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n\n    print \"\\n\\nContig List\\n\\n\";\n    foreach my $contig (@sortedcontigs) {\n        my %list;\n\tmy %alist;\n\t\n\tmy $ctgAnchor  = $_contigs{$contig}{'anchor'};\n\tmy $ctgGroup   = $_contigs{$contig}{'group'};\t\n\t\n\tmy @mkr = keys ( %{$_contigs{$contig}{'markers'}} );\n\t\n\tforeach my $marker (@mkr)  {\t\n\t    my $mrkGroup       = $_markers{$marker}{'group'};\n\t    my $mrkGlobal      = $_markers{$marker}{'global'};\n\t    my $mrkFramework   = $_markers{$marker}{'framework'};\n\t    my $mrkAnchor      = $_markers{$marker}{'anchor'}; \t    \t\n\n\t    if($ctgGroup =~ /\\d+|\\w/ && $ctgGroup != 0)  {\t\t\n\t\tif ($mrkGroup eq $ctgGroup) {\n\t\t    if ($mrkFramework == 0)  {\t\t\n\t\t\t$pos = $mrkGlobal.\"P\";\n\t\t    }\n\t\t    else {\n\t\t\t$pos = $mrkGlobal.\"F\";\n\t\t    }\t\t\n\t\t    $list{$marker} = $pos;\n\t\t}\n\t\telsif ($showall == 1) {\t\t\t\n\t\t    my $chr = $self->group_abbr().$mrkGroup;\n\t\t    $alist{$marker} = $chr;\n\t\t} \t\n\t    }\n\t    elsif ($showall == 1 &&  $ctgGroup !~ /\\d+/) {\n\t\tmy $chr = $self->group_abbr().$mrkGroup;\n\t\t$alist{$marker} = $chr;\n\t    }\n\t}\n\t\n\tmy $chr = $ctgGroup;\n\t$chr = $self->group_abbr().$ctgGroup if ($ctgGroup =~ /\\d+|\\w/);\n\t\n\tif ($showall == 1 ) {\n\t   \t\n\t    print \"   ctg$contig  \", $chr, \"  \"\n\t\tif ($_contigs{$contig}{'group'} !~ /\\d+|\\w/);  \t\t\n        }\n\telsif ($ctgGroup =~ /\\d+|\\w/ && $ctgGroup ne 0){\n\t        print \"   ctg\",$contig, \"  \",$chr, \"  \";\n\t}  \t\n\t\n\twhile (my ($k,$v) = each %list) {\n            print \"$k/$v  \";\t\t\n\t}\n\t\n\tprint \"\\n\" if ($showall == 0 && $ctgGroup =~ /\\d+|\\w/ &&\n\t\t       $ctgGroup ne 0 );\n\t\n\tif ($showall == 1) {\n            while (my ($k,$v) = each %alist) {\n\t\tprint \"$k/$v  \";\t\t\n            }  \t\t\n\t    print \"\\n\";\n        }\n    }\n}\n\n=head2 print_markerlist\n\n Title    : print_markerlist\n Usage    : $map->print_markerlist();\n Function : prints the marker list; contig and corresponding number of\n            clones for each marker.\n Returns  : none\n Args     : none\n\n\nsub print_markerlist {\n    my ($self) = @_;\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    print \"Marker List\\n\\n\";\n\n    foreach my $marker ($self->each_markerid()) {\n        print \"  \",$marker, \"  \";\n\t\n\tmy %list;\n\tmy %mclones = %{$_markers{$marker}{'clones'}};\n\t\n\tforeach my $clone (%mclones) {\n\t    if (exists($_clones{$clone}{'contig'}) ) {\n\t\tmy $ctg = $_clones{$clone}{'contig'};\n\t\t\n\t\tif (exists($list{$ctg})) {\n\t\t    my $clonehits = $list{$ctg};\n\t\t    $clonehits++;\n\t\t    $list{$ctg} = $clonehits;\n\t\t}\n\t\telse {\n\t\t    $list{$ctg} = 1;\n\t\t}\n\t    }\n\t}\n\twhile (my ($k,$v) = each %list) {\n\t    print \"$k/$v  \";\n        }\n        print \"\\n\";\n    }\n}\n\n=head2 print_gffstyle\n\n Title    : print_gffstyle\n Usage    : $map->print_gffstyle([style]);\n Function : prints GFF; either Contigwise (default) or Groupwise\n Returns  : none\n Args     : [style] default = 0 contigwise, else\n                              1 groupwise (chromosome-wise).\n\n\nsub print_gffstyle {\n    my ($self,$style) = @_;\n\n    $style = 0 if(!defined($style));\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $i;\n    my ($depth, $save_depth);\n    my ($x, $y);\n    my @stack;\n    my ($k, $j, $s);\n    my $pos;\n    my $contig;\n\n    # Calculate the position for the marker in the contig\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n    my $offset = 0;\n    my %gffclones;\n    my %gffcontigs;\n    my %gffmarkers;\n    my $basepair = 4096;\n\n    foreach my $contig (@sortedcontigs) {\n        if($_contigs{$contig}{'range'} ) {\t\n\t    $offset =  $_contigs{$contig}{'range'}{'start'};\t\n\t\n\t    if ($offset <= 0){\n\t        $offset = $offset * -1;\t\n\t\t$gffcontigs{$contig}{'start'} = 1;\n\t\t$gffcontigs{$contig}{'end'}   =\n\t\t    ($_contigs{$contig}{'range'}{'end'} +\n\t\t     $offset ) * $basepair + 1;\t\t\t\t\n\t    }\n\t    else {\n\t        $offset = 0;\n\t\t$gffcontigs{$contig}{'start'} =\n\t\t    $_contigs{$contig}{'range'}{'start'} * $basepair;\n\t\t$gffcontigs{$contig}{'end'}   =\n\t\t    $_contigs{$contig}{'range'}{'end'} * $basepair;\n\t    }\t    \t\t\n\t}\n\telse {\n\t    $gffcontigs{$contig}{'start'} = 1;\n            $gffcontigs{$contig}{'end'}   = 1;\t\t\n\t} \t\n\t\n\tmy @clones  =  keys %{$_contigs{$contig}{'clones'}};\t\n\tforeach my $clone (@clones) {\n\t    if(exists ($_clones{$clone}{'range'}) ) {\n\t        my $gffclone = $clone;\n\t\t\n\t\t$gffclone =~ s/sd1$//;\n\t\t\n\t\t$gffclones{$gffclone}{'start'} =\n\t\t    (($_clones{$clone}{'range'}{'start'} + $offset) *\n\t\t     $basepair + 1);\n\n\t\t$gffclones{$gffclone}{'end'}   =\n\t\t    (($_clones{$clone}{'range'}{'end'}\n\t\t      + $offset) * $basepair + 1);\n\t    }\n\t\n\t    if(!$contig) {\t\n\t        my %markers = %{$_clones{$clone}{'markers'}}\n\t\tif (exists($_clones{$clone}{'markers'}));\n\n\t        while (my ($k,$v) = each %markers) {\n\t\t    $gffmarkers{$contig}{$k} =\n\t\t    ( ( $_clones{$clone}{'range'}{'start'} +\n\t\t\t$_clones{$clone}{'range'}{'end'} ) / 2 ) *\n\t\t\t$basepair + 1 ;\n\t\t}\t\n\t    }\n\t}\t\n\t\n\tif($contig) {\n\t    my %markers = %{$_contigs{$contig}{'markers'}}\n\t        if (exists($_contigs{$contig}{'markers'}));\n\n\t    while (my ($k,$v) = each %markers) {\n\t        $gffmarkers{$contig}{$k} = ($v + $offset) * $basepair + 1;\n\t    }\n\t}\n    }\n\n    if (!$style) {\n\tforeach my $contig (@sortedcontigs) {\n\t   \t\n\t    if(exists ($_contigs{$contig}{'range'} )  ) {\t\n\t\tprint join(\"\\t\",\"ctg$contig\",\"assembly\",\"contig\",\n\t\t\t   $gffcontigs{$contig}{'start'},\n\t\t\t   $gffcontigs{$contig}{'end'},\".\",\".\",\".\",\n\t\t\t   \"Sequence \\\"ctg$contig\\\"; Name \\\"ctg$contig\\\"\\n\"\n                          );\n\t    }\n\t\n\t    my @clones = (keys %{$_contigs{$contig}{'clones'}} );\n\t\n\t    foreach my $clone (@clones) {\n\t\tif(exists ($_clones{$clone}{'range'}) ) {\t\n\t\t    print join(\"\\t\",\"ctg$contig\",\"FPC\");\n\t\t\n\t\t    my $type = $_clones{$clone}{'type'};\n\t\t\n\t\t    if($clone =~ /sd1$/) {\n\t\t\t$clone =~ s/sd1$//;\n   \t\t        $type  = \"sequenced\";\n\t\t    }\t\t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffclones{$clone}{'start'},\n\t\t\t\t$gffclones{$clone}{'end'},\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$clone\\\"; Name \\\"$clone\\\"\");\n\n\t\t    my @markers = keys %{$_clones{$clone}{'markers'}};\n\t\t    print \"; Marker_hit\" if (scalar(@markers));\n\t\t\n\t\t    foreach my $mkr(@markers) {\n\t\t\tif (exists($_markers{$mkr}{'framework'})) {\n\t\t\t    print \" \\\"$mkr \",$_markers{$mkr}{'group'},\" \",\n\t\t\t\t   $_markers{$mkr}{'global'},\"\\\"\";\n\t\t\t}\n\t\t\telse {\n\t\t\t    print \" \\\"$mkr 0 0\\\"\";\n\t\t\t}\n\t\t    }\t\n\t\t    print \"; Contig_hit \\\"\",$_clones{$clone}{'contig'},\"\\\" \"\n\t\t        if (defined($_clones{$clone}{'contig'}));\n\t\t}\n\t\tprint \"\\n\";\n\t    }\n\t\n\t    if (exists ($_contigs{$contig}{'markers'}) ) {\t\n\t\tmy %list = %{$_contigs{$contig}{'markers'}};\n\t\t\n\t\twhile (my ($k,$v) = each %list) {\n\t\t    print \"ctg\", $contig, \"\\tFPC\\t\";\n\t\t    my $position = $gffmarkers{$contig}{$k};\n\t\t\n\t\t    my $type = \"marker\";\n\t\t\n\t\t    $type = \"electronicmarker\"\n\t\t         if ($_markers{$k}{'type'} eq \"eMRK\");\n\t\t\n\t\t    if( exists($_markers{$k}{'framework'})) {\n\t\t\t$type = \"frameworkmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 1);\n\t\t\t\n\t\t\t$type = \"placementmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 0);\n\t\t    }\t\n\t\t\n\t\t    print join (\"\\t\",\"$type\",$position,$position,\".\",\".\",\n                                \".\",\"$type \\\"$k\\\"; Name \\\"$k\\\"\");\n\t\t\n\t            my @clonelist;\n\t\t    my @clones  = keys %{$_markers{$k}{'clones'}};\n\t\t\n\t\t    foreach my $cl (@clones) {\n\t\t\tpush (@clonelist, $cl)\n\t\t\t    if($_clones{$cl}{'contig'} == $contig);\n\t\t    }\n\t\t\n\t\t    $\" = \" \";\n\t\t    print(\"; Contig_hit \\\"ctg$contig - \",scalar(@clonelist),\n\t\t\t  \"\\\" (@clonelist)\\n\");\n\t\t}\n\t    }  \t\t   \t\n\t}\n    }\n    else {\n\tmy %_groups;\n\tmy $margin       = 2 * $basepair;\n\tmy $displacement = 0;\n\tmy @grouplist;\n\t\n\tforeach my $contig (@sortedcontigs) {\n\t    my $recordchr;\n            my $chr = $_contigs{$contig}{'group'};\t\t\n\t    $chr = 0 if ($chr !~ /\\d+|\\w+/);\n\t\n            $recordchr->{group}      = $chr;\n\t    $recordchr->{contig}     = $contig;\n\t    $recordchr->{position}   = $_contigs{$contig}{'position'};\n\n\t    push @grouplist, $recordchr;\t\n\t}\n\t\n\tmy @chr       = keys (%{$_groups{'group'}});\n\tmy @sortedchr;\n\t\n\tif ($self->group_type eq 'Chromosome') {\n\t    @sortedchr = sort { $a->{'group'} <=> $b->{'group'}\n\t\t\t\t               ||\n\t\t\t\t$a->{'contig'} <=> $b->{'contig'}\n                              } @grouplist;\n\t}\n\telse {\n\t    @sortedchr = sort { $a->{'group'}  cmp $b->{'group'} \t\n\t\t\t\t                ||\n\t\t\t\t$a->{'contig'} cmp $b->{'contig'}\n                              } @grouplist;\n\t}\n\tmy $lastchr   = -1;\n\tmy $chrend    = 0;\n\n\tforeach my $chr (@sortedchr) {\n\t    my $chrname = $self->group_abbr().$chr->{'group'};\t\n\t\n\t    if ($lastchr eq -1 || $chr->{'group'} ne $lastchr ) {\n\t\t$lastchr = $chr->{'group'} if ($lastchr eq -1);\t\t\n\t\t$displacement = 0;\t\n\t\t\n\t\t# caluclate the end position of the contig\t\t\n\t\tmy $ctgcount = 0;\n\t\tmy $prevchr  = 0;\t\t\n\t\t$chrend = 0;\n\t\t\n\t\tif ($chr->{contig} != 0) {\t\t\n\t\t    foreach my $ch (@sortedchr) {\n\t\t\tif ($ch->{'group'} eq $chr->{'group'}) {\n\t\t\t    if($ch->{'contig'} != 0) {\t\n\t\t\t\tmy $ctg  = $ch->{'contig'}\n\t\t\t\t    if($ch->{'contig'} != 0);\n\n\t\t\t\t$chrend += $gffcontigs{$ctg}->{'end'};\n\t\t\t\t++$ctgcount;\n\t\t\t    }\t\t\t    \t\n\t\t\t}\n\t\t    }\t\n\t\t    $chrend += ($ctgcount-1) * $margin;\n\t\t}\n\t\telse {\n\t\t    $chrend  = $gffcontigs{'0'}->{'end'};\n\t\t}\n\t\t\n\t\t$chrname    = $self->group_abbr().\"ctg0\"\n\t\tif ($chr->{'contig'} == 0);\n\t\t\n\t\tprint join (\"\\t\", $chrname,\"assembly\",\"Chromosome\",1,\n\t\t\t    \"$chrend\",\".\",\".\",\".\",\n\t\t\t    \"Sequence \\\"$chrname\\\"; Name \\\"$chrname\\\"\\n\");\n\t    }\n\t\n\t    print join (\"\\t\", $chrname,\"assembly\",\"Chromosome\",1,\n\t\t\t\"$chrend\",\".\",\".\",\".\",\n\t\t\t\"Sequence \\\"$chrname\\\"; Name \\\"$chrname\\\"\\n\")\n\t        if ($chr->{'group'} ne $lastchr && $chr->{'group'} eq 0 );\n\t\n\t    $lastchr = $chr->{'group'};\n\t    $lastchr = -1 if ($chr->{'contig'} == 0);\t\n\t\n\t    my $contig = $chr->{'contig'};\n\t    \t\n\t    if(exists ($_contigs{$contig}{'range'} )  ) {\n\t\t\n\t\tprint join (\"\\t\",$chrname, \"FPC\",\"contig\",\n\t\t\t    $gffcontigs{$contig}{'start'}+$displacement,\n\t\t            $gffcontigs{$contig}{'end'}+$displacement,\n\t\t\t    \".\",\".\",\".\",\n\t\t\t    \"contig \\\"ctg$contig\\\"; Name \\\"ctg$contig\\\"\\n\");\n\t    }\n\t\n\t    my @clones = (keys %{$_contigs{$contig}{'clones'}} );\n\t    foreach my $clone (@clones) {\n\t\tif(exists ($_clones{$clone}{'range'}) ) {\t\n\t\t    print join (\"\\t\",$chrname,\"FPC\");\n\t\t    my $type = $_clones{$clone}{'type'};\n\t\t\n\t\t    if ($clone =~ /sd1$/) {\n\t\t\t$clone =~ s/sd1$//;\n\t\t\t$type  = \"sequenced\";\n\t\t    }\n\t\t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffclones{$clone}{'start'}\n\t\t\t\t+$displacement,$gffclones{$clone}{'end'}\n\t\t\t\t+$displacement,\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$clone\\\"; Name \\\"$clone\\\"\");\n\t\t\n\t\t    my @markers = keys %{$_clones{$clone}{'markers'}};\n\t\t    print \"; Marker_hit\" if (scalar(@markers));\n\t\t    \t\t\n\t\t    foreach my $mkr(@markers) {\n\t\t\tif (exists($_markers{$mkr}{'framework'})) {\n\t\t\t    print \" \\\"$mkr \",$_markers{$mkr}{'group'},\" \",\n\t\t\t\t   $_markers{$mkr}{'global'},\"\\\"\";\n\t\t\t}\n\t\t\telse {\n\t\t\t    print (\" \\\"$mkr 0 0\\\"\");\n\t\t\t}\n\t\t    }\t\n\t\t    print \"; Contig_hit \\\"\",$_clones{$clone}{'contig'},\"\\\" \"\n\t\t        if (defined($_clones{$clone}{'contig'}));\n\t\t}\n\t\tprint \"\\n\";\n\t    }\n\t\n\t    if (exists ($_contigs{$contig}{'markers'}) ) {\t\n\t\tmy %list = %{$_contigs{$contig}{'markers'}};\n\t\t\n\t\twhile (my ($k,$v) = each %list) {\n\t\t    print join (\"\\t\",$chrname,\"FPC\");\n\t\t    my $type = \"marker\";\n\t\t\n\t\t    $type = \"electronicmarker\"\n\t\t        if ($_markers{$k}{'type'} eq \"eMRK\");\n\t\t\n\t\t    if( exists($_markers{$k}{'framework'})) {\n\t\t\t$type = \"frameworkmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 1);\n\t\t\t\n\t\t\t$type = \"placementmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 0);\t\n\t\t    }\t\n\t\t    \t\t    \t\t    \t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffmarkers{$contig}{$k}\n\t\t\t\t+ $displacement,$gffmarkers{$contig}{$k}\n\t\t\t\t+ $displacement,\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$k\\\"; Name \\\"$k\\\"\");\n\n\t\t    my @clonelist;\n\t\t    my @clones  = keys %{$_markers{$k}{'clones'}};\n\t\t\n\t\t    foreach my $cl (@clones) {\n\t\t\tpush (@clonelist, $cl)\n\t\t\t    if($_clones{$cl}{'contig'} == $contig);\n\t\t    }\n\t\t\n\t\t    $\" = \" \";\t\t\n\t\t    print(\"; Contig_hit \\\"ctg$contig - \",\n\t\t\t  scalar(@clonelist),\"\\\" (@clonelist)\\n\");\n\t\t}\n\t    }\n\t    $displacement += $margin + $gffcontigs{$contig}{'end'};\n\t}\n    }\n}\n\n=head2 _calc_markerposition\n\n Title   : _calc_markerposition\n Usage   : $map->_calc_markerposition();\n Function: Calculates the position of the marker in the contig\n Returns : none\n Args    : none","parameters":[{"label":"$self"}],"label":"_calc_markerposition($self)"}},{"kind":13,"line":1093,"containerName":null,"name":"%_markers","definition":"my","localvar":"my"},{"line":1093,"kind":13,"name":"%self","containerName":null},{"kind":13,"line":1094,"containerName":null,"name":"%_clones","definition":"my","localvar":"my"},{"kind":13,"line":1094,"containerName":null,"name":"%self"},{"containerName":null,"name":"$i","definition":"my","localvar":"my","kind":13,"line":1096},{"name":"$depth","definition":"my","containerName":null,"localvar":"my","kind":13,"line":1097},{"containerName":null,"name":"$save_depth","kind":13,"line":1097},{"definition":"my","name":"$x","containerName":null,"localvar":"my","kind":13,"line":1098},{"kind":13,"line":1098,"name":"$y","containerName":null},{"kind":13,"line":1099,"containerName":null,"definition":"my","name":"@stack","localvar":"my"},{"containerName":null,"name":"$k","definition":"my","localvar":"my","kind":13,"line":1100},{"containerName":null,"name":"$j","line":1100,"kind":13},{"line":1100,"kind":13,"name":"$s","containerName":null},{"localvar":"my","containerName":null,"name":"$pos","definition":"my","line":1101,"kind":13},{"kind":13,"line":1102,"name":"$contig","definition":"my","containerName":null,"localvar":"my"},{"line":1106,"kind":13,"localvar":"my","containerName":null,"name":"@contigs","definition":"my"},{"name":"$self","containerName":null,"line":1106,"kind":13},{"containerName":"main::","name":"each_contigid","kind":12,"line":1106},{"localvar":"my","containerName":null,"definition":"my","name":"@sortedcontigs","line":1107,"kind":13},{"containerName":null,"name":"$a","kind":13,"line":1107},{"name":"$b","containerName":null,"kind":13,"line":1107},{"kind":13,"line":1107,"name":"@contigs","containerName":null},{"kind":13,"line":1108,"definition":"my","name":"$offset","containerName":null,"localvar":"my"},{"line":1109,"kind":13,"localvar":"my","name":"%gffclones","definition":"my","containerName":null},{"localvar":"my","definition":"my","name":"%gffcontigs","containerName":null,"line":1110,"kind":13},{"definition":"my","name":"$marker","containerName":null,"localvar":"my","kind":13,"line":1112},{"containerName":null,"name":"$self","line":1112,"kind":13},{"line":1112,"kind":12,"name":"each_markerid","containerName":"main::"},{"line":1113,"kind":13,"localvar":"my","containerName":null,"name":"@ctgmarker","definition":"my"},{"line":1113,"kind":13,"containerName":null,"name":"@sortedctgmarker"},{"containerName":null,"name":"@clones","definition":"my","localvar":"my","kind":13,"line":1115},{"containerName":null,"name":"%_markers","line":1115,"kind":13},{"line":1115,"kind":13,"containerName":null,"name":"%marker"},{"kind":13,"line":1116,"containerName":null,"name":"%_markers"},{"containerName":null,"name":"%marker","line":1116,"kind":13},{"containerName":null,"definition":"my","name":"$clone","localvar":"my","kind":13,"line":1118},{"kind":13,"line":1118,"containerName":null,"name":"@clones"},{"kind":13,"line":1119,"definition":"my","name":"$record","containerName":null,"localvar":"my"},{"line":1120,"kind":13,"name":"%record","containerName":null},{"kind":12,"line":1120,"name":"contig"},{"containerName":null,"name":"%_clones","line":1120,"kind":13},{"name":"%clone","containerName":null,"line":1120,"kind":13},{"containerName":null,"name":"%record","kind":13,"line":1121},{"kind":12,"line":1121,"name":"start"},{"containerName":null,"name":"%_clones","kind":13,"line":1121},{"name":"%clone","containerName":null,"line":1121,"kind":13},{"kind":13,"line":1122,"containerName":null,"name":"%record"},{"name":"end","kind":12,"line":1122},{"name":"%_clones","containerName":null,"line":1122,"kind":13},{"line":1122,"kind":13,"containerName":null,"name":"%clone"},{"name":"@ctgmarker","containerName":null,"kind":13,"line":1123},{"line":1123,"kind":13,"containerName":null,"name":"$record"},{"containerName":null,"name":"@sortedctgmarker","kind":13,"line":1127},{"containerName":null,"name":"%a","kind":13,"line":1127},{"line":1127,"kind":13,"containerName":null,"name":"%b"},{"name":"%b","containerName":null,"kind":13,"line":1129},{"name":"%a","containerName":null,"kind":13,"line":1129},{"line":1130,"kind":13,"name":"@ctgmarker","containerName":null},{"line":1132,"kind":13,"localvar":"my","containerName":null,"name":"$ctg","definition":"my"},{"containerName":null,"name":"$i","line":1134,"kind":13},{"kind":13,"line":1134,"containerName":null,"name":"$i"},{"line":1134,"kind":13,"name":"@sortedctgmarker","containerName":null},{"line":1134,"kind":13,"name":"%i","containerName":null},{"line":1135,"kind":13,"name":"$ctg","containerName":null},{"line":1135,"kind":13,"name":"@sortedctgmarker","containerName":null},{"name":"%i","containerName":null,"kind":13,"line":1135},{"containerName":null,"name":"%ctg","line":1136,"kind":13},{"containerName":null,"name":"$ctg","line":1137,"kind":13},{"name":"@sortedctgmarker","containerName":null,"line":1137,"kind":13},{"line":1137,"kind":13,"containerName":null,"name":"%i"},{"name":"$depth","containerName":null,"line":1140,"kind":13},{"line":1140,"kind":13,"containerName":null,"name":"%save_depth"},{"name":"$pos","containerName":null,"kind":13,"line":1141},{"containerName":null,"name":"$x","line":1141,"kind":13},{"containerName":null,"name":"$y","line":1141,"kind":13},{"containerName":null,"name":"%_contigs","kind":13,"line":1142},{"line":1142,"kind":13,"name":"%ctg","containerName":null},{"name":"$marker","containerName":null,"line":1142,"kind":13},{"kind":13,"line":1142,"name":"$pos","containerName":null},{"name":"%_markers","containerName":null,"kind":13,"line":1143},{"name":"%marker","containerName":null,"kind":13,"line":1143},{"containerName":null,"name":"$ctg","kind":13,"line":1143},{"name":"$pos","containerName":null,"kind":13,"line":1143},{"line":1147,"kind":13,"name":"$ctg","containerName":null},{"containerName":null,"name":"@sortedctgmarker","kind":13,"line":1147},{"line":1147,"kind":13,"name":"%i","containerName":null},{"kind":13,"line":1148,"name":"$x","containerName":null},{"line":1148,"kind":13,"containerName":null,"name":"@sortedctgmarker"},{"kind":13,"line":1148,"name":"%i","containerName":null},{"kind":13,"line":1149,"containerName":null,"name":"$y"},{"containerName":null,"name":"@sortedctgmarker","kind":13,"line":1149},{"line":1149,"kind":13,"containerName":null,"name":"%i"},{"name":"@stack","containerName":null,"line":1150,"kind":13},{"name":"$y","containerName":null,"line":1150,"kind":13},{"line":1152,"kind":13,"name":"$pos","containerName":null},{"name":"$x","containerName":null,"line":1152,"kind":13},{"name":"$y","containerName":null,"kind":13,"line":1152},{"line":1153,"kind":13,"containerName":null,"name":"%_contigs"},{"name":"%ctg","containerName":null,"line":1153,"kind":13},{"name":"$marker","containerName":null,"line":1153,"kind":13},{"line":1153,"kind":13,"name":"$pos","containerName":null},{"line":1154,"kind":13,"containerName":null,"name":"%_markers"},{"kind":13,"line":1154,"name":"%marker","containerName":null},{"containerName":null,"name":"$ctg","kind":13,"line":1154},{"containerName":null,"name":"$pos","kind":13,"line":1154},{"name":"$depth","containerName":null,"line":1156,"kind":13},{"name":"$save_depth","containerName":null,"kind":13,"line":1156},{"containerName":null,"name":"@sortedctgmarker","line":1158,"kind":13},{"containerName":null,"name":"$i","kind":13,"line":1158},{"line":1158,"kind":13,"containerName":null,"name":"%y"},{"line":1159,"kind":13,"name":"@stack","containerName":null},{"line":1159,"kind":13,"name":"$depth","containerName":null},{"name":"@sortedctgmarker","containerName":null,"kind":13,"line":1159},{"containerName":null,"name":"%i","line":1159,"kind":13},{"kind":13,"line":1161,"containerName":null,"name":"$x"},{"containerName":null,"name":"@sortedctgmarker","line":1161,"kind":13},{"name":"%i","containerName":null,"kind":13,"line":1161},{"line":1162,"kind":13,"name":"$x","containerName":null},{"containerName":null,"name":"@sortedctgmarker","kind":13,"line":1162},{"kind":13,"line":1162,"containerName":null,"name":"%i"},{"kind":13,"line":1165,"containerName":null,"name":"$y"},{"name":"@sortedctgmarker","containerName":null,"kind":13,"line":1165},{"containerName":null,"name":"%i","line":1165,"kind":13},{"kind":13,"line":1166,"containerName":null,"name":"$y"},{"containerName":null,"name":"@sortedctgmarker","kind":13,"line":1166},{"name":"%i","containerName":null,"line":1166,"kind":13},{"kind":13,"line":1170,"containerName":null,"name":"$depth"},{"kind":13,"line":1170,"name":"%save_depth","containerName":null},{"line":1171,"kind":13,"name":"$save_depth","containerName":null},{"containerName":null,"name":"$depth","line":1171,"kind":13},{"name":"$pos","containerName":null,"line":1172,"kind":13},{"containerName":null,"name":"$x","kind":13,"line":1172},{"name":"$y","containerName":null,"kind":13,"line":1172},{"kind":13,"line":1173,"name":"%_contigs","containerName":null},{"kind":13,"line":1173,"containerName":null,"name":"%ctg"},{"containerName":null,"name":"$marker","kind":13,"line":1173},{"name":"$pos","containerName":null,"kind":13,"line":1173},{"name":"%_markers","containerName":null,"line":1174,"kind":13},{"containerName":null,"name":"%marker","kind":13,"line":1174},{"kind":13,"line":1174,"containerName":null,"name":"$ctg"},{"name":"$pos","containerName":null,"kind":13,"line":1174},{"kind":13,"line":1177,"name":"$x","containerName":null},{"containerName":null,"name":"@sortedctgmarker","kind":13,"line":1177},{"containerName":null,"name":"%i","kind":13,"line":1177},{"line":1178,"kind":13,"containerName":null,"name":"$y"},{"containerName":null,"name":"@sortedctgmarker","line":1178,"kind":13},{"name":"%i","containerName":null,"line":1178,"kind":13},{"name":"@stack","containerName":null,"line":1179,"kind":13},{"name":"$depth","containerName":null,"line":1179,"kind":13},{"containerName":null,"name":"$y","line":1179,"kind":13},{"containerName":null,"name":"$j","line":1181,"kind":13},{"line":1181,"kind":13,"containerName":null,"name":"$k"},{"line":1181,"kind":13,"containerName":null,"name":"$s"},{"name":"$s","containerName":null,"kind":13,"line":1181},{"name":"$depth","containerName":null,"line":1181,"kind":13},{"kind":13,"line":1181,"containerName":null,"name":"%s"},{"line":1182,"kind":13,"containerName":null,"name":"@stack"},{"name":"$s","containerName":null,"line":1182,"kind":13},{"line":1182,"kind":13,"containerName":null,"name":"%x"},{"line":1183,"kind":13,"name":"@stack","containerName":null},{"line":1183,"kind":13,"containerName":null,"name":"$s"},{"line":1184,"kind":13,"name":"$j","containerName":null},{"line":1184,"kind":13,"containerName":null,"name":"$s"},{"containerName":null,"name":"%j","line":1184,"kind":13},{"containerName":null,"name":"$k","kind":13,"line":1187},{"containerName":null,"name":"$y","line":1189,"kind":13},{"kind":13,"line":1189,"name":"@stack","containerName":null},{"name":"$s","containerName":null,"kind":13,"line":1189},{"name":"$y","containerName":null,"line":1189,"kind":13},{"containerName":null,"name":"@stack","line":1189,"kind":13},{"line":1189,"kind":13,"containerName":null,"name":"$s"},{"kind":13,"line":1190,"containerName":null,"name":"@stack"},{"name":"%j","containerName":null,"kind":13,"line":1190},{"name":"@stack","containerName":null,"line":1191,"kind":13},{"containerName":null,"name":"$j","kind":13,"line":1191},{"kind":13,"line":1191,"name":"@stack","containerName":null},{"line":1191,"kind":13,"containerName":null,"name":"$s"},{"containerName":null,"name":"@stack","line":1192,"kind":13},{"line":1192,"kind":13,"containerName":null,"name":"$s"},{"containerName":null,"name":"@stack","line":1193,"kind":13},{"line":1193,"kind":13,"containerName":null,"name":"%j"},{"line":1193,"kind":13,"containerName":null,"name":"%j"},{"line":1196,"kind":13,"containerName":null,"name":"$j"},{"kind":13,"line":1196,"containerName":null,"name":"$s"},{"kind":13,"line":1199,"name":"$depth","containerName":null},{"containerName":null,"name":"$k","kind":13,"line":1199},{"kind":13,"line":1202,"name":"$depth","containerName":null},{"kind":13,"line":1202,"containerName":null,"name":"%save_depth"},{"kind":13,"line":1203,"containerName":null,"name":"$pos"},{"name":"$x","containerName":null,"kind":13,"line":1203},{"line":1203,"kind":13,"name":"$y","containerName":null},{"name":"%_contigs","containerName":null,"kind":13,"line":1204},{"line":1204,"kind":13,"containerName":null,"name":"%ctg"},{"name":"$marker","containerName":null,"kind":13,"line":1204},{"name":"$pos","containerName":null,"line":1204,"kind":13},{"containerName":null,"name":"%_markers","kind":13,"line":1205},{"line":1205,"kind":13,"containerName":null,"name":"%marker"},{"name":"$ctg","containerName":null,"kind":13,"line":1205},{"containerName":null,"name":"$pos","kind":13,"line":1205},{"range":{"end":{"character":9999,"line":1224},"start":{"character":0,"line":1221}},"name":"_calc_contigposition","signature":{"label":"_calc_contigposition($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]\n\n\nsub matching_bands {\n    my($self,$cloneA,$cloneB,$tol) = @_;\n    my($lstart,$kband,$match,$diff,$i,$j);\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    $tol = 7 if (!defined($tol));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @bandsA = @{$_clones{$cloneA}{'bands'}};\n    my @bandsB = @{$_clones{$cloneB}{'bands'}};\n\n    $match  = 0;\n    $lstart = 0;\n\n    for ($i=0; $i<scalar(@bandsA);$i++) {\n\t$kband = $bandsA[$i];\n\tfor ($j = $lstart; $j<scalar(@bandsB); $j++) {\n\t    $diff = $kband - $bandsB[$j];\n\t    if (abs($diff)  <= $tol ) {\n\t\t$match++;\n\t\t$lstart = $j+1;\n\t\tlast;\n\t    }\n\t    elsif ($diff < 0) {\n\t\t$lstart = $j;\n\t\tlast;\n\t    }\n\t}\n    }\n    return $match;\n}\n\n=head2 coincidence_score\n\n Title   : coincidence_score\n Usage   : $self->coincidence_score('cloneA','cloneB'[,$tol,$gellen]);\n Function: given two clones [,tolerence and gellen], this method calculates\n           the Sulston Coincidence score.\n           (this method is ported directly from FPC)\n Returns : scalar representing the Sulston coincidence score.\n Args    : names of the clones ('cloneA', 'cloneB')\n           [Default tol=7 gellen=3300.0]\n\n\nsub coincidence_score {\n    my($self,$cloneA,$cloneB,$tol,$gellen) = @_;\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $numbandsA = scalar(@{$_clones{$cloneA}{'bands'}});\n    my $numbandsB = scalar(@{$_clones{$cloneB}{'bands'}});\n\n    my ($nL,$nH,$m,$i,$psmn,$pp,$pa,$pb,$t,$c,$a,$n);\n    my @logfact;\n    my $score;\n\n    $gellen = 3300.0 if (!defined($gellen));\n    $tol    = 7      if (!defined($tol));\n\n    if ($numbandsA > $numbandsB) {\n\t$nH = $numbandsA;\n\t$nL = $numbandsB;\n    }\n    else {\n\t$nH = $numbandsB;\n\t$nL = $numbandsA;\n    }\n\n    $m = $self->matching_bands($cloneA, $cloneB,$tol);\n\n    $logfact[0] = 0.0;\n    $logfact[1] = 0.0;\n    for ($i=2; $i<=$nL; $i++) {\n\t$logfact[$i] = $logfact[$i - 1] + log($i);\n    }\n\n    $psmn = 1.0 - ((2*$tol)/$gellen);\n\n    $pp = $psmn ** $nH;\n    $pa = log($pp);\n    $pb = log(1 - $pp);\n    $t  = 1e-37;\n\n    for ($n = $m; $n <= $nL; $n++)  {\n\t$c = $logfact[$nL] - $logfact[$nL - $n] - $logfact[$n];\n\t$a = exp($c + ($n * $pb) + (($nL - $n) * $pa));\n\t$t += $a;\n    }\n\n    $score = sprintf(\"%.e\",$t);\n    return $score;\n}\n\n=head2 print_contiglist\n\n Title   : print_contiglist\n Usage   : $map->print_contiglist([showall]); #[Default 0]\n Function: prints the list of contigs, markers that hit the contig, the\n           global position and whether the marker is a placement (P) or\n           a Framework (F) marker.\n Returns : none\n Args    : [showall] [Default 0], 1 includes all the discrepant markers\n\n\nsub print_contiglist{\n    my ($self,$showall) = @_;\n    my $pos;\n\n    $showall = 0 if (!defined($showall));\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n\n    print \"\\n\\nContig List\\n\\n\";\n    foreach my $contig (@sortedcontigs) {\n        my %list;\n\tmy %alist;\n\t\n\tmy $ctgAnchor  = $_contigs{$contig}{'anchor'};\n\tmy $ctgGroup   = $_contigs{$contig}{'group'};\t\n\t\n\tmy @mkr = keys ( %{$_contigs{$contig}{'markers'}} );\n\t\n\tforeach my $marker (@mkr)  {\t\n\t    my $mrkGroup       = $_markers{$marker}{'group'};\n\t    my $mrkGlobal      = $_markers{$marker}{'global'};\n\t    my $mrkFramework   = $_markers{$marker}{'framework'};\n\t    my $mrkAnchor      = $_markers{$marker}{'anchor'}; \t    \t\n\n\t    if($ctgGroup =~ /\\d+|\\w/ && $ctgGroup != 0)  {\t\t\n\t\tif ($mrkGroup eq $ctgGroup) {\n\t\t    if ($mrkFramework == 0)  {\t\t\n\t\t\t$pos = $mrkGlobal.\"P\";\n\t\t    }\n\t\t    else {\n\t\t\t$pos = $mrkGlobal.\"F\";\n\t\t    }\t\t\n\t\t    $list{$marker} = $pos;\n\t\t}\n\t\telsif ($showall == 1) {\t\t\t\n\t\t    my $chr = $self->group_abbr().$mrkGroup;\n\t\t    $alist{$marker} = $chr;\n\t\t} \t\n\t    }\n\t    elsif ($showall == 1 &&  $ctgGroup !~ /\\d+/) {\n\t\tmy $chr = $self->group_abbr().$mrkGroup;\n\t\t$alist{$marker} = $chr;\n\t    }\n\t}\n\t\n\tmy $chr = $ctgGroup;\n\t$chr = $self->group_abbr().$ctgGroup if ($ctgGroup =~ /\\d+|\\w/);\n\t\n\tif ($showall == 1 ) {\n\t   \t\n\t    print \"   ctg$contig  \", $chr, \"  \"\n\t\tif ($_contigs{$contig}{'group'} !~ /\\d+|\\w/);  \t\t\n        }\n\telsif ($ctgGroup =~ /\\d+|\\w/ && $ctgGroup ne 0){\n\t        print \"   ctg\",$contig, \"  \",$chr, \"  \";\n\t}  \t\n\t\n\twhile (my ($k,$v) = each %list) {\n            print \"$k/$v  \";\t\t\n\t}\n\t\n\tprint \"\\n\" if ($showall == 0 && $ctgGroup =~ /\\d+|\\w/ &&\n\t\t       $ctgGroup ne 0 );\n\t\n\tif ($showall == 1) {\n            while (my ($k,$v) = each %alist) {\n\t\tprint \"$k/$v  \";\t\t\n            }  \t\t\n\t    print \"\\n\";\n        }\n    }\n}\n\n=head2 print_markerlist\n\n Title    : print_markerlist\n Usage    : $map->print_markerlist();\n Function : prints the marker list; contig and corresponding number of\n            clones for each marker.\n Returns  : none\n Args     : none\n\n\nsub print_markerlist {\n    my ($self) = @_;\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    print \"Marker List\\n\\n\";\n\n    foreach my $marker ($self->each_markerid()) {\n        print \"  \",$marker, \"  \";\n\t\n\tmy %list;\n\tmy %mclones = %{$_markers{$marker}{'clones'}};\n\t\n\tforeach my $clone (%mclones) {\n\t    if (exists($_clones{$clone}{'contig'}) ) {\n\t\tmy $ctg = $_clones{$clone}{'contig'};\n\t\t\n\t\tif (exists($list{$ctg})) {\n\t\t    my $clonehits = $list{$ctg};\n\t\t    $clonehits++;\n\t\t    $list{$ctg} = $clonehits;\n\t\t}\n\t\telse {\n\t\t    $list{$ctg} = 1;\n\t\t}\n\t    }\n\t}\n\twhile (my ($k,$v) = each %list) {\n\t    print \"$k/$v  \";\n        }\n        print \"\\n\";\n    }\n}\n\n=head2 print_gffstyle\n\n Title    : print_gffstyle\n Usage    : $map->print_gffstyle([style]);\n Function : prints GFF; either Contigwise (default) or Groupwise\n Returns  : none\n Args     : [style] default = 0 contigwise, else\n                              1 groupwise (chromosome-wise).\n\n\nsub print_gffstyle {\n    my ($self,$style) = @_;\n\n    $style = 0 if(!defined($style));\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $i;\n    my ($depth, $save_depth);\n    my ($x, $y);\n    my @stack;\n    my ($k, $j, $s);\n    my $pos;\n    my $contig;\n\n    # Calculate the position for the marker in the contig\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n    my $offset = 0;\n    my %gffclones;\n    my %gffcontigs;\n    my %gffmarkers;\n    my $basepair = 4096;\n\n    foreach my $contig (@sortedcontigs) {\n        if($_contigs{$contig}{'range'} ) {\t\n\t    $offset =  $_contigs{$contig}{'range'}{'start'};\t\n\t\n\t    if ($offset <= 0){\n\t        $offset = $offset * -1;\t\n\t\t$gffcontigs{$contig}{'start'} = 1;\n\t\t$gffcontigs{$contig}{'end'}   =\n\t\t    ($_contigs{$contig}{'range'}{'end'} +\n\t\t     $offset ) * $basepair + 1;\t\t\t\t\n\t    }\n\t    else {\n\t        $offset = 0;\n\t\t$gffcontigs{$contig}{'start'} =\n\t\t    $_contigs{$contig}{'range'}{'start'} * $basepair;\n\t\t$gffcontigs{$contig}{'end'}   =\n\t\t    $_contigs{$contig}{'range'}{'end'} * $basepair;\n\t    }\t    \t\t\n\t}\n\telse {\n\t    $gffcontigs{$contig}{'start'} = 1;\n            $gffcontigs{$contig}{'end'}   = 1;\t\t\n\t} \t\n\t\n\tmy @clones  =  keys %{$_contigs{$contig}{'clones'}};\t\n\tforeach my $clone (@clones) {\n\t    if(exists ($_clones{$clone}{'range'}) ) {\n\t        my $gffclone = $clone;\n\t\t\n\t\t$gffclone =~ s/sd1$//;\n\t\t\n\t\t$gffclones{$gffclone}{'start'} =\n\t\t    (($_clones{$clone}{'range'}{'start'} + $offset) *\n\t\t     $basepair + 1);\n\n\t\t$gffclones{$gffclone}{'end'}   =\n\t\t    (($_clones{$clone}{'range'}{'end'}\n\t\t      + $offset) * $basepair + 1);\n\t    }\n\t\n\t    if(!$contig) {\t\n\t        my %markers = %{$_clones{$clone}{'markers'}}\n\t\tif (exists($_clones{$clone}{'markers'}));\n\n\t        while (my ($k,$v) = each %markers) {\n\t\t    $gffmarkers{$contig}{$k} =\n\t\t    ( ( $_clones{$clone}{'range'}{'start'} +\n\t\t\t$_clones{$clone}{'range'}{'end'} ) / 2 ) *\n\t\t\t$basepair + 1 ;\n\t\t}\t\n\t    }\n\t}\t\n\t\n\tif($contig) {\n\t    my %markers = %{$_contigs{$contig}{'markers'}}\n\t        if (exists($_contigs{$contig}{'markers'}));\n\n\t    while (my ($k,$v) = each %markers) {\n\t        $gffmarkers{$contig}{$k} = ($v + $offset) * $basepair + 1;\n\t    }\n\t}\n    }\n\n    if (!$style) {\n\tforeach my $contig (@sortedcontigs) {\n\t   \t\n\t    if(exists ($_contigs{$contig}{'range'} )  ) {\t\n\t\tprint join(\"\\t\",\"ctg$contig\",\"assembly\",\"contig\",\n\t\t\t   $gffcontigs{$contig}{'start'},\n\t\t\t   $gffcontigs{$contig}{'end'},\".\",\".\",\".\",\n\t\t\t   \"Sequence \\\"ctg$contig\\\"; Name \\\"ctg$contig\\\"\\n\"\n                          );\n\t    }\n\t\n\t    my @clones = (keys %{$_contigs{$contig}{'clones'}} );\n\t\n\t    foreach my $clone (@clones) {\n\t\tif(exists ($_clones{$clone}{'range'}) ) {\t\n\t\t    print join(\"\\t\",\"ctg$contig\",\"FPC\");\n\t\t\n\t\t    my $type = $_clones{$clone}{'type'};\n\t\t\n\t\t    if($clone =~ /sd1$/) {\n\t\t\t$clone =~ s/sd1$//;\n   \t\t        $type  = \"sequenced\";\n\t\t    }\t\t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffclones{$clone}{'start'},\n\t\t\t\t$gffclones{$clone}{'end'},\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$clone\\\"; Name \\\"$clone\\\"\");\n\n\t\t    my @markers = keys %{$_clones{$clone}{'markers'}};\n\t\t    print \"; Marker_hit\" if (scalar(@markers));\n\t\t\n\t\t    foreach my $mkr(@markers) {\n\t\t\tif (exists($_markers{$mkr}{'framework'})) {\n\t\t\t    print \" \\\"$mkr \",$_markers{$mkr}{'group'},\" \",\n\t\t\t\t   $_markers{$mkr}{'global'},\"\\\"\";\n\t\t\t}\n\t\t\telse {\n\t\t\t    print \" \\\"$mkr 0 0\\\"\";\n\t\t\t}\n\t\t    }\t\n\t\t    print \"; Contig_hit \\\"\",$_clones{$clone}{'contig'},\"\\\" \"\n\t\t        if (defined($_clones{$clone}{'contig'}));\n\t\t}\n\t\tprint \"\\n\";\n\t    }\n\t\n\t    if (exists ($_contigs{$contig}{'markers'}) ) {\t\n\t\tmy %list = %{$_contigs{$contig}{'markers'}};\n\t\t\n\t\twhile (my ($k,$v) = each %list) {\n\t\t    print \"ctg\", $contig, \"\\tFPC\\t\";\n\t\t    my $position = $gffmarkers{$contig}{$k};\n\t\t\n\t\t    my $type = \"marker\";\n\t\t\n\t\t    $type = \"electronicmarker\"\n\t\t         if ($_markers{$k}{'type'} eq \"eMRK\");\n\t\t\n\t\t    if( exists($_markers{$k}{'framework'})) {\n\t\t\t$type = \"frameworkmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 1);\n\t\t\t\n\t\t\t$type = \"placementmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 0);\n\t\t    }\t\n\t\t\n\t\t    print join (\"\\t\",\"$type\",$position,$position,\".\",\".\",\n                                \".\",\"$type \\\"$k\\\"; Name \\\"$k\\\"\");\n\t\t\n\t            my @clonelist;\n\t\t    my @clones  = keys %{$_markers{$k}{'clones'}};\n\t\t\n\t\t    foreach my $cl (@clones) {\n\t\t\tpush (@clonelist, $cl)\n\t\t\t    if($_clones{$cl}{'contig'} == $contig);\n\t\t    }\n\t\t\n\t\t    $\" = \" \";\n\t\t    print(\"; Contig_hit \\\"ctg$contig - \",scalar(@clonelist),\n\t\t\t  \"\\\" (@clonelist)\\n\");\n\t\t}\n\t    }  \t\t   \t\n\t}\n    }\n    else {\n\tmy %_groups;\n\tmy $margin       = 2 * $basepair;\n\tmy $displacement = 0;\n\tmy @grouplist;\n\t\n\tforeach my $contig (@sortedcontigs) {\n\t    my $recordchr;\n            my $chr = $_contigs{$contig}{'group'};\t\t\n\t    $chr = 0 if ($chr !~ /\\d+|\\w+/);\n\t\n            $recordchr->{group}      = $chr;\n\t    $recordchr->{contig}     = $contig;\n\t    $recordchr->{position}   = $_contigs{$contig}{'position'};\n\n\t    push @grouplist, $recordchr;\t\n\t}\n\t\n\tmy @chr       = keys (%{$_groups{'group'}});\n\tmy @sortedchr;\n\t\n\tif ($self->group_type eq 'Chromosome') {\n\t    @sortedchr = sort { $a->{'group'} <=> $b->{'group'}\n\t\t\t\t               ||\n\t\t\t\t$a->{'contig'} <=> $b->{'contig'}\n                              } @grouplist;\n\t}\n\telse {\n\t    @sortedchr = sort { $a->{'group'}  cmp $b->{'group'} \t\n\t\t\t\t                ||\n\t\t\t\t$a->{'contig'} cmp $b->{'contig'}\n                              } @grouplist;\n\t}\n\tmy $lastchr   = -1;\n\tmy $chrend    = 0;\n\n\tforeach my $chr (@sortedchr) {\n\t    my $chrname = $self->group_abbr().$chr->{'group'};\t\n\t\n\t    if ($lastchr eq -1 || $chr->{'group'} ne $lastchr ) {\n\t\t$lastchr = $chr->{'group'} if ($lastchr eq -1);\t\t\n\t\t$displacement = 0;\t\n\t\t\n\t\t# caluclate the end position of the contig\t\t\n\t\tmy $ctgcount = 0;\n\t\tmy $prevchr  = 0;\t\t\n\t\t$chrend = 0;\n\t\t\n\t\tif ($chr->{contig} != 0) {\t\t\n\t\t    foreach my $ch (@sortedchr) {\n\t\t\tif ($ch->{'group'} eq $chr->{'group'}) {\n\t\t\t    if($ch->{'contig'} != 0) {\t\n\t\t\t\tmy $ctg  = $ch->{'contig'}\n\t\t\t\t    if($ch->{'contig'} != 0);\n\n\t\t\t\t$chrend += $gffcontigs{$ctg}->{'end'};\n\t\t\t\t++$ctgcount;\n\t\t\t    }\t\t\t    \t\n\t\t\t}\n\t\t    }\t\n\t\t    $chrend += ($ctgcount-1) * $margin;\n\t\t}\n\t\telse {\n\t\t    $chrend  = $gffcontigs{'0'}->{'end'};\n\t\t}\n\t\t\n\t\t$chrname    = $self->group_abbr().\"ctg0\"\n\t\tif ($chr->{'contig'} == 0);\n\t\t\n\t\tprint join (\"\\t\", $chrname,\"assembly\",\"Chromosome\",1,\n\t\t\t    \"$chrend\",\".\",\".\",\".\",\n\t\t\t    \"Sequence \\\"$chrname\\\"; Name \\\"$chrname\\\"\\n\");\n\t    }\n\t\n\t    print join (\"\\t\", $chrname,\"assembly\",\"Chromosome\",1,\n\t\t\t\"$chrend\",\".\",\".\",\".\",\n\t\t\t\"Sequence \\\"$chrname\\\"; Name \\\"$chrname\\\"\\n\")\n\t        if ($chr->{'group'} ne $lastchr && $chr->{'group'} eq 0 );\n\t\n\t    $lastchr = $chr->{'group'};\n\t    $lastchr = -1 if ($chr->{'contig'} == 0);\t\n\t\n\t    my $contig = $chr->{'contig'};\n\t    \t\n\t    if(exists ($_contigs{$contig}{'range'} )  ) {\n\t\t\n\t\tprint join (\"\\t\",$chrname, \"FPC\",\"contig\",\n\t\t\t    $gffcontigs{$contig}{'start'}+$displacement,\n\t\t            $gffcontigs{$contig}{'end'}+$displacement,\n\t\t\t    \".\",\".\",\".\",\n\t\t\t    \"contig \\\"ctg$contig\\\"; Name \\\"ctg$contig\\\"\\n\");\n\t    }\n\t\n\t    my @clones = (keys %{$_contigs{$contig}{'clones'}} );\n\t    foreach my $clone (@clones) {\n\t\tif(exists ($_clones{$clone}{'range'}) ) {\t\n\t\t    print join (\"\\t\",$chrname,\"FPC\");\n\t\t    my $type = $_clones{$clone}{'type'};\n\t\t\n\t\t    if ($clone =~ /sd1$/) {\n\t\t\t$clone =~ s/sd1$//;\n\t\t\t$type  = \"sequenced\";\n\t\t    }\n\t\t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffclones{$clone}{'start'}\n\t\t\t\t+$displacement,$gffclones{$clone}{'end'}\n\t\t\t\t+$displacement,\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$clone\\\"; Name \\\"$clone\\\"\");\n\t\t\n\t\t    my @markers = keys %{$_clones{$clone}{'markers'}};\n\t\t    print \"; Marker_hit\" if (scalar(@markers));\n\t\t    \t\t\n\t\t    foreach my $mkr(@markers) {\n\t\t\tif (exists($_markers{$mkr}{'framework'})) {\n\t\t\t    print \" \\\"$mkr \",$_markers{$mkr}{'group'},\" \",\n\t\t\t\t   $_markers{$mkr}{'global'},\"\\\"\";\n\t\t\t}\n\t\t\telse {\n\t\t\t    print (\" \\\"$mkr 0 0\\\"\");\n\t\t\t}\n\t\t    }\t\n\t\t    print \"; Contig_hit \\\"\",$_clones{$clone}{'contig'},\"\\\" \"\n\t\t        if (defined($_clones{$clone}{'contig'}));\n\t\t}\n\t\tprint \"\\n\";\n\t    }\n\t\n\t    if (exists ($_contigs{$contig}{'markers'}) ) {\t\n\t\tmy %list = %{$_contigs{$contig}{'markers'}};\n\t\t\n\t\twhile (my ($k,$v) = each %list) {\n\t\t    print join (\"\\t\",$chrname,\"FPC\");\n\t\t    my $type = \"marker\";\n\t\t\n\t\t    $type = \"electronicmarker\"\n\t\t        if ($_markers{$k}{'type'} eq \"eMRK\");\n\t\t\n\t\t    if( exists($_markers{$k}{'framework'})) {\n\t\t\t$type = \"frameworkmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 1);\n\t\t\t\n\t\t\t$type = \"placementmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 0);\t\n\t\t    }\t\n\t\t    \t\t    \t\t    \t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffmarkers{$contig}{$k}\n\t\t\t\t+ $displacement,$gffmarkers{$contig}{$k}\n\t\t\t\t+ $displacement,\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$k\\\"; Name \\\"$k\\\"\");\n\n\t\t    my @clonelist;\n\t\t    my @clones  = keys %{$_markers{$k}{'clones'}};\n\t\t\n\t\t    foreach my $cl (@clones) {\n\t\t\tpush (@clonelist, $cl)\n\t\t\t    if($_clones{$cl}{'contig'} == $contig);\n\t\t    }\n\t\t\n\t\t    $\" = \" \";\t\t\n\t\t    print(\"; Contig_hit \\\"ctg$contig - \",\n\t\t\t  scalar(@clonelist),\"\\\" (@clonelist)\\n\");\n\t\t}\n\t    }\n\t    $displacement += $margin + $gffcontigs{$contig}{'end'};\n\t}\n    }\n}\n\n=head2 _calc_markerposition\n\n Title   : _calc_markerposition\n Usage   : $map->_calc_markerposition();\n Function: Calculates the position of the marker in the contig\n Returns : none\n Args    : none\n\n\nsub _calc_markerposition {\n    my ($self) = @_;\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $i;\n    my ($depth, $save_depth);\n    my ($x, $y);\n    my @stack;\n    my ($k, $j, $s);\n    my $pos;\n    my $contig;\n\n    # Calculate the position for the marker in the contig\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n    my $offset;\n    my %gffclones;\n    my %gffcontigs;\n\n    foreach my $marker ($self->each_markerid()) {\n        my (@ctgmarker, @sortedctgmarker);\n\t\n\tmy @clones = (keys %{$_markers{$marker}{'clones'}})\n\t    if (exists ($_markers{$marker}{'clones'} ));\n\t\n        foreach my $clone (@clones) {\n\t    my $record;\n\t    $record->{contig} = $_clones{$clone}{'contig'};\t\t\n\t    $record->{start}  = $_clones{$clone}{'range'}{'start'};\n\t    $record->{end}    = $_clones{$clone}{'range'}{'end'};\n\t    push @ctgmarker,$record;\n\t}\n\t\n\t# sorting by contig and left position\n\t@sortedctgmarker = sort { $a->{'contig'} <=> $b->{'contig'}\n\t\t\t\t                  ||\n\t\t\t\t  $b->{'start'}  <=> $a->{'start'}\n\t\t\t        } @ctgmarker;\n\t\t\t\t\n\tmy $ctg = -1;\n\t\n\tfor ($i=0; $i < scalar(@sortedctgmarker); $i++) {\n\t    if ($ctg != $sortedctgmarker[$i]->{'contig'}) {\n\t\tif ($ctg == -1) {\n\t\t    $ctg = $sortedctgmarker[$i]->{'contig'};\n\t\t}\n\t\telse  {\t\n\t\t    if ($depth > $save_depth){\n\t\t\t$pos = ($x + $y) >> 1;\n\t\t\t$_contigs{$ctg}{'markers'}{$marker}      = $pos;\n\t\t\t$_markers{$marker}{'posincontig'}{$ctg}  = $pos;\n\t\t    }\n\t\t}\n\t\t\n\t\t$ctg      = $sortedctgmarker[$i]->{'contig'};\n\t\t$x        = $sortedctgmarker[$i]->{'start'};\n\t\t$y        = $sortedctgmarker[$i]->{'end'};\n\t\t$stack[0] = $y;\n\t\t\n\t\t$pos = ($x + $y) >> 1;\n\t\t$_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t$_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t\t\n\t\t$depth = $save_depth = 1;\n\t    }\n\t    elsif ($sortedctgmarker[$i] <= $y) {\n\t\t$stack[$depth++] = $sortedctgmarker[$i]->{'end'};\n\t\t# MAX\n\t\tif ($x < $sortedctgmarker[$i]->{'start'} ) {\n\t\t    $x = $sortedctgmarker[$i]->{'start'};\n\t\t}\n\t\t# MIN\n\t\tif ($y > $sortedctgmarker[$i]->{'end'}) {\n\t\t    $y = $sortedctgmarker[$i]->{'end'};\n\t\t}\t\n\t    }\n\t    else {\n\t\tif ($depth > $save_depth) {\n\t\t    $save_depth = $depth;\n\t\t    $pos = ($x + $y) >> 1;\n\t\t    $_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t    $_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t\t}\n\t\t\n\t\t$x               = $sortedctgmarker[$i]->{'start'};\n\t\t$y               = $sortedctgmarker[$i]->{'end'};\n\t\t$stack[$depth++] = $y;\n\t\t\n\t\tfor($j=-1, $k=0, $s=0; $s<$depth; $s++) {\n\t\t    if ($stack[$s] <$x) {\n\t\t\t$stack[$s] = -1;\n\t\t\t$j = $s if ($j == -1);\n\t\t    }\n\t\t    else {\n\t\t\t$k++;\n\t\t\t# MIN\n\t\t\t$y = $stack[$s] if ($y > $stack[$s]);\n\t\t\tif ($stack[$j] == -1) {\n\t\t\t    $stack[$j] = $stack[$s];\n\t\t\t    $stack[$s] = -1;\n\t\t\t    while ($stack[$j] != -1) {$j++;}\n\t\t\t}\n\t\t\telse {\n\t\t\t    $j = $s;\n\t\t\t}\n\t\t    }\n\t\t    $depth = $k;\n\t\t}\t\n\t    }\n\t    if ($depth > $save_depth) {\n\t\t$pos = ($x + $y) >> 1;\n\t\t$_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t$_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t    }\n\t}\t\n    }\n}\n\n=head2 _calc_contigposition\n\n Title   : _calc_contigposition\n Usage   : $map->_calc_contigposition();\n Function: calculates the position of the contig in the group\n Returns : none\n Args    : none"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":1222,"containerName":"_calc_contigposition","name":"$self","definition":"my","localvar":"my"},{"localvar":"my","definition":"my","name":"%_contigs","containerName":"_calc_contigposition","line":1224,"kind":13},{"kind":13,"line":1224,"name":"$self","containerName":"_calc_contigposition"}],"line":1221,"kind":12},{"localvar":"my","containerName":null,"definition":"my","name":"%_markers","line":1225,"kind":13},{"kind":13,"line":1225,"containerName":null,"name":"%self"},{"kind":13,"line":1226,"definition":"my","name":"%_clones","containerName":null,"localvar":"my"},{"name":"%self","containerName":null,"kind":13,"line":1226},{"kind":13,"line":1228,"name":"@contigs","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"$self","kind":13,"line":1228},{"kind":12,"line":1228,"name":"each_contigid","containerName":"main::"},{"containerName":null,"definition":"my","name":"@sortedcontigs","localvar":"my","kind":13,"line":1229},{"containerName":null,"name":"$a","kind":13,"line":1229},{"containerName":null,"name":"$b","line":1229,"kind":13},{"name":"@contigs","containerName":null,"kind":13,"line":1229},{"localvar":"my","definition":"my","name":"$contig","containerName":null,"line":1231,"kind":13},{"name":"@sortedcontigs","containerName":null,"line":1231,"kind":13},{"kind":13,"line":1232,"name":"$position","definition":"my","containerName":null,"localvar":"my"},{"line":1233,"kind":13,"localvar":"my","definition":"my","name":"$group","containerName":null},{"line":1235,"kind":13,"name":"%_contigs","containerName":null},{"name":"%contig","containerName":null,"line":1235,"kind":13},{"containerName":null,"definition":"my","name":"%weightedmarkers","localvar":"my","kind":13,"line":1237},{"kind":13,"line":1238,"name":"@mkrs","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"%_contigs","line":1238,"kind":13},{"name":"%contig","containerName":null,"line":1238,"kind":13},{"kind":13,"line":1239,"name":"%_contigs","containerName":null},{"containerName":null,"name":"%contig","kind":13,"line":1239},{"name":"$chr","definition":"my","containerName":null,"localvar":"my","kind":13,"line":1241},{"line":1241,"kind":13,"name":"%_contigs","containerName":null},{"containerName":null,"name":"%contig","line":1241,"kind":13},{"name":"$chr","containerName":null,"line":1242,"kind":13},{"containerName":null,"name":"%_contigs","kind":13,"line":1242},{"line":1242,"kind":13,"containerName":null,"name":"%contig"},{"localvar":"my","containerName":null,"definition":"my","name":"$mkr","line":1244,"kind":13},{"containerName":null,"name":"@mkrs","line":1244,"kind":13},{"line":1245,"kind":13,"containerName":null,"name":"%_markers"},{"kind":13,"line":1245,"containerName":null,"name":"%mkr"},{"line":1246,"kind":13,"name":"%_markers","containerName":null},{"kind":13,"line":1246,"containerName":null,"name":"%mkr"},{"name":"%chr","containerName":null,"line":1246,"kind":13},{"definition":"my","name":"@mkrclones","containerName":null,"localvar":"my","kind":13,"line":1247},{"kind":13,"line":1247,"name":"%_markers","containerName":null},{"name":"%mkr","containerName":null,"line":1247,"kind":13},{"containerName":null,"name":"$clonescount","definition":"my","localvar":"my","kind":13,"line":1248},{"line":1249,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$clone"},{"containerName":null,"name":"@mkrclones","kind":13,"line":1249},{"name":"$clonescount","containerName":null,"kind":13,"line":1251},{"line":1251,"kind":13,"name":"%_clones","containerName":null},{"containerName":null,"name":"%clone","kind":13,"line":1251},{"name":"$contig","containerName":null,"line":1251,"kind":13},{"name":"%weightedmarkers","containerName":null,"line":1253,"kind":13},{"name":"%_markers","containerName":null,"line":1253,"kind":13},{"name":"%mkr","containerName":null,"kind":13,"line":1253},{"kind":13,"line":1254,"containerName":null,"name":"$clonescount"},{"line":1259,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$weightedctgsum"},{"kind":13,"line":1260,"name":"$totalhits","definition":"my","containerName":null,"localvar":"my"},{"line":1262,"kind":13,"localvar":"my","definition":"my","name":"$mpos","containerName":null},{"containerName":null,"name":"$hits","line":1262,"kind":13},{"name":"%weightedmarkers","containerName":null,"kind":13,"line":1262},{"containerName":null,"name":"$weightedctgsum","line":1263,"kind":13},{"containerName":null,"name":"$mpos","kind":13,"line":1263},{"kind":13,"line":1263,"containerName":null,"name":"$hits"},{"line":1264,"kind":13,"name":"$totalhits","containerName":null},{"kind":13,"line":1264,"containerName":null,"name":"$hits"},{"name":"$position","containerName":null,"line":1267,"kind":13},{"line":1267,"kind":13,"name":"$weightedctgsum","containerName":null},{"containerName":null,"name":"$totalhits","kind":13,"line":1267},{"name":"$totalhits","containerName":null,"line":1268,"kind":13},{"kind":13,"line":1270,"containerName":null,"name":"%_contigs"},{"line":1270,"kind":13,"containerName":null,"name":"%contig"},{"name":"$position","containerName":null,"line":1270,"kind":13},{"kind":12,"children":[{"kind":13,"line":1286,"containerName":"_calc_contiggroup","definition":"my","name":"$self","localvar":"my"},{"localvar":"my","name":"%_contig","definition":"my","containerName":"_calc_contiggroup","line":1287,"kind":13},{"kind":13,"line":1287,"name":"$self","containerName":"_calc_contiggroup"}],"line":1285,"definition":"sub","containerName":"main::","signature":{"label":"_calc_contiggroup($self)","documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]\n\n\nsub matching_bands {\n    my($self,$cloneA,$cloneB,$tol) = @_;\n    my($lstart,$kband,$match,$diff,$i,$j);\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    $tol = 7 if (!defined($tol));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @bandsA = @{$_clones{$cloneA}{'bands'}};\n    my @bandsB = @{$_clones{$cloneB}{'bands'}};\n\n    $match  = 0;\n    $lstart = 0;\n\n    for ($i=0; $i<scalar(@bandsA);$i++) {\n\t$kband = $bandsA[$i];\n\tfor ($j = $lstart; $j<scalar(@bandsB); $j++) {\n\t    $diff = $kband - $bandsB[$j];\n\t    if (abs($diff)  <= $tol ) {\n\t\t$match++;\n\t\t$lstart = $j+1;\n\t\tlast;\n\t    }\n\t    elsif ($diff < 0) {\n\t\t$lstart = $j;\n\t\tlast;\n\t    }\n\t}\n    }\n    return $match;\n}\n\n=head2 coincidence_score\n\n Title   : coincidence_score\n Usage   : $self->coincidence_score('cloneA','cloneB'[,$tol,$gellen]);\n Function: given two clones [,tolerence and gellen], this method calculates\n           the Sulston Coincidence score.\n           (this method is ported directly from FPC)\n Returns : scalar representing the Sulston coincidence score.\n Args    : names of the clones ('cloneA', 'cloneB')\n           [Default tol=7 gellen=3300.0]\n\n\nsub coincidence_score {\n    my($self,$cloneA,$cloneB,$tol,$gellen) = @_;\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $numbandsA = scalar(@{$_clones{$cloneA}{'bands'}});\n    my $numbandsB = scalar(@{$_clones{$cloneB}{'bands'}});\n\n    my ($nL,$nH,$m,$i,$psmn,$pp,$pa,$pb,$t,$c,$a,$n);\n    my @logfact;\n    my $score;\n\n    $gellen = 3300.0 if (!defined($gellen));\n    $tol    = 7      if (!defined($tol));\n\n    if ($numbandsA > $numbandsB) {\n\t$nH = $numbandsA;\n\t$nL = $numbandsB;\n    }\n    else {\n\t$nH = $numbandsB;\n\t$nL = $numbandsA;\n    }\n\n    $m = $self->matching_bands($cloneA, $cloneB,$tol);\n\n    $logfact[0] = 0.0;\n    $logfact[1] = 0.0;\n    for ($i=2; $i<=$nL; $i++) {\n\t$logfact[$i] = $logfact[$i - 1] + log($i);\n    }\n\n    $psmn = 1.0 - ((2*$tol)/$gellen);\n\n    $pp = $psmn ** $nH;\n    $pa = log($pp);\n    $pb = log(1 - $pp);\n    $t  = 1e-37;\n\n    for ($n = $m; $n <= $nL; $n++)  {\n\t$c = $logfact[$nL] - $logfact[$nL - $n] - $logfact[$n];\n\t$a = exp($c + ($n * $pb) + (($nL - $n) * $pa));\n\t$t += $a;\n    }\n\n    $score = sprintf(\"%.e\",$t);\n    return $score;\n}\n\n=head2 print_contiglist\n\n Title   : print_contiglist\n Usage   : $map->print_contiglist([showall]); #[Default 0]\n Function: prints the list of contigs, markers that hit the contig, the\n           global position and whether the marker is a placement (P) or\n           a Framework (F) marker.\n Returns : none\n Args    : [showall] [Default 0], 1 includes all the discrepant markers\n\n\nsub print_contiglist{\n    my ($self,$showall) = @_;\n    my $pos;\n\n    $showall = 0 if (!defined($showall));\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n\n    print \"\\n\\nContig List\\n\\n\";\n    foreach my $contig (@sortedcontigs) {\n        my %list;\n\tmy %alist;\n\t\n\tmy $ctgAnchor  = $_contigs{$contig}{'anchor'};\n\tmy $ctgGroup   = $_contigs{$contig}{'group'};\t\n\t\n\tmy @mkr = keys ( %{$_contigs{$contig}{'markers'}} );\n\t\n\tforeach my $marker (@mkr)  {\t\n\t    my $mrkGroup       = $_markers{$marker}{'group'};\n\t    my $mrkGlobal      = $_markers{$marker}{'global'};\n\t    my $mrkFramework   = $_markers{$marker}{'framework'};\n\t    my $mrkAnchor      = $_markers{$marker}{'anchor'}; \t    \t\n\n\t    if($ctgGroup =~ /\\d+|\\w/ && $ctgGroup != 0)  {\t\t\n\t\tif ($mrkGroup eq $ctgGroup) {\n\t\t    if ($mrkFramework == 0)  {\t\t\n\t\t\t$pos = $mrkGlobal.\"P\";\n\t\t    }\n\t\t    else {\n\t\t\t$pos = $mrkGlobal.\"F\";\n\t\t    }\t\t\n\t\t    $list{$marker} = $pos;\n\t\t}\n\t\telsif ($showall == 1) {\t\t\t\n\t\t    my $chr = $self->group_abbr().$mrkGroup;\n\t\t    $alist{$marker} = $chr;\n\t\t} \t\n\t    }\n\t    elsif ($showall == 1 &&  $ctgGroup !~ /\\d+/) {\n\t\tmy $chr = $self->group_abbr().$mrkGroup;\n\t\t$alist{$marker} = $chr;\n\t    }\n\t}\n\t\n\tmy $chr = $ctgGroup;\n\t$chr = $self->group_abbr().$ctgGroup if ($ctgGroup =~ /\\d+|\\w/);\n\t\n\tif ($showall == 1 ) {\n\t   \t\n\t    print \"   ctg$contig  \", $chr, \"  \"\n\t\tif ($_contigs{$contig}{'group'} !~ /\\d+|\\w/);  \t\t\n        }\n\telsif ($ctgGroup =~ /\\d+|\\w/ && $ctgGroup ne 0){\n\t        print \"   ctg\",$contig, \"  \",$chr, \"  \";\n\t}  \t\n\t\n\twhile (my ($k,$v) = each %list) {\n            print \"$k/$v  \";\t\t\n\t}\n\t\n\tprint \"\\n\" if ($showall == 0 && $ctgGroup =~ /\\d+|\\w/ &&\n\t\t       $ctgGroup ne 0 );\n\t\n\tif ($showall == 1) {\n            while (my ($k,$v) = each %alist) {\n\t\tprint \"$k/$v  \";\t\t\n            }  \t\t\n\t    print \"\\n\";\n        }\n    }\n}\n\n=head2 print_markerlist\n\n Title    : print_markerlist\n Usage    : $map->print_markerlist();\n Function : prints the marker list; contig and corresponding number of\n            clones for each marker.\n Returns  : none\n Args     : none\n\n\nsub print_markerlist {\n    my ($self) = @_;\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    print \"Marker List\\n\\n\";\n\n    foreach my $marker ($self->each_markerid()) {\n        print \"  \",$marker, \"  \";\n\t\n\tmy %list;\n\tmy %mclones = %{$_markers{$marker}{'clones'}};\n\t\n\tforeach my $clone (%mclones) {\n\t    if (exists($_clones{$clone}{'contig'}) ) {\n\t\tmy $ctg = $_clones{$clone}{'contig'};\n\t\t\n\t\tif (exists($list{$ctg})) {\n\t\t    my $clonehits = $list{$ctg};\n\t\t    $clonehits++;\n\t\t    $list{$ctg} = $clonehits;\n\t\t}\n\t\telse {\n\t\t    $list{$ctg} = 1;\n\t\t}\n\t    }\n\t}\n\twhile (my ($k,$v) = each %list) {\n\t    print \"$k/$v  \";\n        }\n        print \"\\n\";\n    }\n}\n\n=head2 print_gffstyle\n\n Title    : print_gffstyle\n Usage    : $map->print_gffstyle([style]);\n Function : prints GFF; either Contigwise (default) or Groupwise\n Returns  : none\n Args     : [style] default = 0 contigwise, else\n                              1 groupwise (chromosome-wise).\n\n\nsub print_gffstyle {\n    my ($self,$style) = @_;\n\n    $style = 0 if(!defined($style));\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $i;\n    my ($depth, $save_depth);\n    my ($x, $y);\n    my @stack;\n    my ($k, $j, $s);\n    my $pos;\n    my $contig;\n\n    # Calculate the position for the marker in the contig\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n    my $offset = 0;\n    my %gffclones;\n    my %gffcontigs;\n    my %gffmarkers;\n    my $basepair = 4096;\n\n    foreach my $contig (@sortedcontigs) {\n        if($_contigs{$contig}{'range'} ) {\t\n\t    $offset =  $_contigs{$contig}{'range'}{'start'};\t\n\t\n\t    if ($offset <= 0){\n\t        $offset = $offset * -1;\t\n\t\t$gffcontigs{$contig}{'start'} = 1;\n\t\t$gffcontigs{$contig}{'end'}   =\n\t\t    ($_contigs{$contig}{'range'}{'end'} +\n\t\t     $offset ) * $basepair + 1;\t\t\t\t\n\t    }\n\t    else {\n\t        $offset = 0;\n\t\t$gffcontigs{$contig}{'start'} =\n\t\t    $_contigs{$contig}{'range'}{'start'} * $basepair;\n\t\t$gffcontigs{$contig}{'end'}   =\n\t\t    $_contigs{$contig}{'range'}{'end'} * $basepair;\n\t    }\t    \t\t\n\t}\n\telse {\n\t    $gffcontigs{$contig}{'start'} = 1;\n            $gffcontigs{$contig}{'end'}   = 1;\t\t\n\t} \t\n\t\n\tmy @clones  =  keys %{$_contigs{$contig}{'clones'}};\t\n\tforeach my $clone (@clones) {\n\t    if(exists ($_clones{$clone}{'range'}) ) {\n\t        my $gffclone = $clone;\n\t\t\n\t\t$gffclone =~ s/sd1$//;\n\t\t\n\t\t$gffclones{$gffclone}{'start'} =\n\t\t    (($_clones{$clone}{'range'}{'start'} + $offset) *\n\t\t     $basepair + 1);\n\n\t\t$gffclones{$gffclone}{'end'}   =\n\t\t    (($_clones{$clone}{'range'}{'end'}\n\t\t      + $offset) * $basepair + 1);\n\t    }\n\t\n\t    if(!$contig) {\t\n\t        my %markers = %{$_clones{$clone}{'markers'}}\n\t\tif (exists($_clones{$clone}{'markers'}));\n\n\t        while (my ($k,$v) = each %markers) {\n\t\t    $gffmarkers{$contig}{$k} =\n\t\t    ( ( $_clones{$clone}{'range'}{'start'} +\n\t\t\t$_clones{$clone}{'range'}{'end'} ) / 2 ) *\n\t\t\t$basepair + 1 ;\n\t\t}\t\n\t    }\n\t}\t\n\t\n\tif($contig) {\n\t    my %markers = %{$_contigs{$contig}{'markers'}}\n\t        if (exists($_contigs{$contig}{'markers'}));\n\n\t    while (my ($k,$v) = each %markers) {\n\t        $gffmarkers{$contig}{$k} = ($v + $offset) * $basepair + 1;\n\t    }\n\t}\n    }\n\n    if (!$style) {\n\tforeach my $contig (@sortedcontigs) {\n\t   \t\n\t    if(exists ($_contigs{$contig}{'range'} )  ) {\t\n\t\tprint join(\"\\t\",\"ctg$contig\",\"assembly\",\"contig\",\n\t\t\t   $gffcontigs{$contig}{'start'},\n\t\t\t   $gffcontigs{$contig}{'end'},\".\",\".\",\".\",\n\t\t\t   \"Sequence \\\"ctg$contig\\\"; Name \\\"ctg$contig\\\"\\n\"\n                          );\n\t    }\n\t\n\t    my @clones = (keys %{$_contigs{$contig}{'clones'}} );\n\t\n\t    foreach my $clone (@clones) {\n\t\tif(exists ($_clones{$clone}{'range'}) ) {\t\n\t\t    print join(\"\\t\",\"ctg$contig\",\"FPC\");\n\t\t\n\t\t    my $type = $_clones{$clone}{'type'};\n\t\t\n\t\t    if($clone =~ /sd1$/) {\n\t\t\t$clone =~ s/sd1$//;\n   \t\t        $type  = \"sequenced\";\n\t\t    }\t\t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffclones{$clone}{'start'},\n\t\t\t\t$gffclones{$clone}{'end'},\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$clone\\\"; Name \\\"$clone\\\"\");\n\n\t\t    my @markers = keys %{$_clones{$clone}{'markers'}};\n\t\t    print \"; Marker_hit\" if (scalar(@markers));\n\t\t\n\t\t    foreach my $mkr(@markers) {\n\t\t\tif (exists($_markers{$mkr}{'framework'})) {\n\t\t\t    print \" \\\"$mkr \",$_markers{$mkr}{'group'},\" \",\n\t\t\t\t   $_markers{$mkr}{'global'},\"\\\"\";\n\t\t\t}\n\t\t\telse {\n\t\t\t    print \" \\\"$mkr 0 0\\\"\";\n\t\t\t}\n\t\t    }\t\n\t\t    print \"; Contig_hit \\\"\",$_clones{$clone}{'contig'},\"\\\" \"\n\t\t        if (defined($_clones{$clone}{'contig'}));\n\t\t}\n\t\tprint \"\\n\";\n\t    }\n\t\n\t    if (exists ($_contigs{$contig}{'markers'}) ) {\t\n\t\tmy %list = %{$_contigs{$contig}{'markers'}};\n\t\t\n\t\twhile (my ($k,$v) = each %list) {\n\t\t    print \"ctg\", $contig, \"\\tFPC\\t\";\n\t\t    my $position = $gffmarkers{$contig}{$k};\n\t\t\n\t\t    my $type = \"marker\";\n\t\t\n\t\t    $type = \"electronicmarker\"\n\t\t         if ($_markers{$k}{'type'} eq \"eMRK\");\n\t\t\n\t\t    if( exists($_markers{$k}{'framework'})) {\n\t\t\t$type = \"frameworkmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 1);\n\t\t\t\n\t\t\t$type = \"placementmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 0);\n\t\t    }\t\n\t\t\n\t\t    print join (\"\\t\",\"$type\",$position,$position,\".\",\".\",\n                                \".\",\"$type \\\"$k\\\"; Name \\\"$k\\\"\");\n\t\t\n\t            my @clonelist;\n\t\t    my @clones  = keys %{$_markers{$k}{'clones'}};\n\t\t\n\t\t    foreach my $cl (@clones) {\n\t\t\tpush (@clonelist, $cl)\n\t\t\t    if($_clones{$cl}{'contig'} == $contig);\n\t\t    }\n\t\t\n\t\t    $\" = \" \";\n\t\t    print(\"; Contig_hit \\\"ctg$contig - \",scalar(@clonelist),\n\t\t\t  \"\\\" (@clonelist)\\n\");\n\t\t}\n\t    }  \t\t   \t\n\t}\n    }\n    else {\n\tmy %_groups;\n\tmy $margin       = 2 * $basepair;\n\tmy $displacement = 0;\n\tmy @grouplist;\n\t\n\tforeach my $contig (@sortedcontigs) {\n\t    my $recordchr;\n            my $chr = $_contigs{$contig}{'group'};\t\t\n\t    $chr = 0 if ($chr !~ /\\d+|\\w+/);\n\t\n            $recordchr->{group}      = $chr;\n\t    $recordchr->{contig}     = $contig;\n\t    $recordchr->{position}   = $_contigs{$contig}{'position'};\n\n\t    push @grouplist, $recordchr;\t\n\t}\n\t\n\tmy @chr       = keys (%{$_groups{'group'}});\n\tmy @sortedchr;\n\t\n\tif ($self->group_type eq 'Chromosome') {\n\t    @sortedchr = sort { $a->{'group'} <=> $b->{'group'}\n\t\t\t\t               ||\n\t\t\t\t$a->{'contig'} <=> $b->{'contig'}\n                              } @grouplist;\n\t}\n\telse {\n\t    @sortedchr = sort { $a->{'group'}  cmp $b->{'group'} \t\n\t\t\t\t                ||\n\t\t\t\t$a->{'contig'} cmp $b->{'contig'}\n                              } @grouplist;\n\t}\n\tmy $lastchr   = -1;\n\tmy $chrend    = 0;\n\n\tforeach my $chr (@sortedchr) {\n\t    my $chrname = $self->group_abbr().$chr->{'group'};\t\n\t\n\t    if ($lastchr eq -1 || $chr->{'group'} ne $lastchr ) {\n\t\t$lastchr = $chr->{'group'} if ($lastchr eq -1);\t\t\n\t\t$displacement = 0;\t\n\t\t\n\t\t# caluclate the end position of the contig\t\t\n\t\tmy $ctgcount = 0;\n\t\tmy $prevchr  = 0;\t\t\n\t\t$chrend = 0;\n\t\t\n\t\tif ($chr->{contig} != 0) {\t\t\n\t\t    foreach my $ch (@sortedchr) {\n\t\t\tif ($ch->{'group'} eq $chr->{'group'}) {\n\t\t\t    if($ch->{'contig'} != 0) {\t\n\t\t\t\tmy $ctg  = $ch->{'contig'}\n\t\t\t\t    if($ch->{'contig'} != 0);\n\n\t\t\t\t$chrend += $gffcontigs{$ctg}->{'end'};\n\t\t\t\t++$ctgcount;\n\t\t\t    }\t\t\t    \t\n\t\t\t}\n\t\t    }\t\n\t\t    $chrend += ($ctgcount-1) * $margin;\n\t\t}\n\t\telse {\n\t\t    $chrend  = $gffcontigs{'0'}->{'end'};\n\t\t}\n\t\t\n\t\t$chrname    = $self->group_abbr().\"ctg0\"\n\t\tif ($chr->{'contig'} == 0);\n\t\t\n\t\tprint join (\"\\t\", $chrname,\"assembly\",\"Chromosome\",1,\n\t\t\t    \"$chrend\",\".\",\".\",\".\",\n\t\t\t    \"Sequence \\\"$chrname\\\"; Name \\\"$chrname\\\"\\n\");\n\t    }\n\t\n\t    print join (\"\\t\", $chrname,\"assembly\",\"Chromosome\",1,\n\t\t\t\"$chrend\",\".\",\".\",\".\",\n\t\t\t\"Sequence \\\"$chrname\\\"; Name \\\"$chrname\\\"\\n\")\n\t        if ($chr->{'group'} ne $lastchr && $chr->{'group'} eq 0 );\n\t\n\t    $lastchr = $chr->{'group'};\n\t    $lastchr = -1 if ($chr->{'contig'} == 0);\t\n\t\n\t    my $contig = $chr->{'contig'};\n\t    \t\n\t    if(exists ($_contigs{$contig}{'range'} )  ) {\n\t\t\n\t\tprint join (\"\\t\",$chrname, \"FPC\",\"contig\",\n\t\t\t    $gffcontigs{$contig}{'start'}+$displacement,\n\t\t            $gffcontigs{$contig}{'end'}+$displacement,\n\t\t\t    \".\",\".\",\".\",\n\t\t\t    \"contig \\\"ctg$contig\\\"; Name \\\"ctg$contig\\\"\\n\");\n\t    }\n\t\n\t    my @clones = (keys %{$_contigs{$contig}{'clones'}} );\n\t    foreach my $clone (@clones) {\n\t\tif(exists ($_clones{$clone}{'range'}) ) {\t\n\t\t    print join (\"\\t\",$chrname,\"FPC\");\n\t\t    my $type = $_clones{$clone}{'type'};\n\t\t\n\t\t    if ($clone =~ /sd1$/) {\n\t\t\t$clone =~ s/sd1$//;\n\t\t\t$type  = \"sequenced\";\n\t\t    }\n\t\t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffclones{$clone}{'start'}\n\t\t\t\t+$displacement,$gffclones{$clone}{'end'}\n\t\t\t\t+$displacement,\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$clone\\\"; Name \\\"$clone\\\"\");\n\t\t\n\t\t    my @markers = keys %{$_clones{$clone}{'markers'}};\n\t\t    print \"; Marker_hit\" if (scalar(@markers));\n\t\t    \t\t\n\t\t    foreach my $mkr(@markers) {\n\t\t\tif (exists($_markers{$mkr}{'framework'})) {\n\t\t\t    print \" \\\"$mkr \",$_markers{$mkr}{'group'},\" \",\n\t\t\t\t   $_markers{$mkr}{'global'},\"\\\"\";\n\t\t\t}\n\t\t\telse {\n\t\t\t    print (\" \\\"$mkr 0 0\\\"\");\n\t\t\t}\n\t\t    }\t\n\t\t    print \"; Contig_hit \\\"\",$_clones{$clone}{'contig'},\"\\\" \"\n\t\t        if (defined($_clones{$clone}{'contig'}));\n\t\t}\n\t\tprint \"\\n\";\n\t    }\n\t\n\t    if (exists ($_contigs{$contig}{'markers'}) ) {\t\n\t\tmy %list = %{$_contigs{$contig}{'markers'}};\n\t\t\n\t\twhile (my ($k,$v) = each %list) {\n\t\t    print join (\"\\t\",$chrname,\"FPC\");\n\t\t    my $type = \"marker\";\n\t\t\n\t\t    $type = \"electronicmarker\"\n\t\t        if ($_markers{$k}{'type'} eq \"eMRK\");\n\t\t\n\t\t    if( exists($_markers{$k}{'framework'})) {\n\t\t\t$type = \"frameworkmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 1);\n\t\t\t\n\t\t\t$type = \"placementmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 0);\t\n\t\t    }\t\n\t\t    \t\t    \t\t    \t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffmarkers{$contig}{$k}\n\t\t\t\t+ $displacement,$gffmarkers{$contig}{$k}\n\t\t\t\t+ $displacement,\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$k\\\"; Name \\\"$k\\\"\");\n\n\t\t    my @clonelist;\n\t\t    my @clones  = keys %{$_markers{$k}{'clones'}};\n\t\t\n\t\t    foreach my $cl (@clones) {\n\t\t\tpush (@clonelist, $cl)\n\t\t\t    if($_clones{$cl}{'contig'} == $contig);\n\t\t    }\n\t\t\n\t\t    $\" = \" \";\t\t\n\t\t    print(\"; Contig_hit \\\"ctg$contig - \",\n\t\t\t  scalar(@clonelist),\"\\\" (@clonelist)\\n\");\n\t\t}\n\t    }\n\t    $displacement += $margin + $gffcontigs{$contig}{'end'};\n\t}\n    }\n}\n\n=head2 _calc_markerposition\n\n Title   : _calc_markerposition\n Usage   : $map->_calc_markerposition();\n Function: Calculates the position of the marker in the contig\n Returns : none\n Args    : none\n\n\nsub _calc_markerposition {\n    my ($self) = @_;\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $i;\n    my ($depth, $save_depth);\n    my ($x, $y);\n    my @stack;\n    my ($k, $j, $s);\n    my $pos;\n    my $contig;\n\n    # Calculate the position for the marker in the contig\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n    my $offset;\n    my %gffclones;\n    my %gffcontigs;\n\n    foreach my $marker ($self->each_markerid()) {\n        my (@ctgmarker, @sortedctgmarker);\n\t\n\tmy @clones = (keys %{$_markers{$marker}{'clones'}})\n\t    if (exists ($_markers{$marker}{'clones'} ));\n\t\n        foreach my $clone (@clones) {\n\t    my $record;\n\t    $record->{contig} = $_clones{$clone}{'contig'};\t\t\n\t    $record->{start}  = $_clones{$clone}{'range'}{'start'};\n\t    $record->{end}    = $_clones{$clone}{'range'}{'end'};\n\t    push @ctgmarker,$record;\n\t}\n\t\n\t# sorting by contig and left position\n\t@sortedctgmarker = sort { $a->{'contig'} <=> $b->{'contig'}\n\t\t\t\t                  ||\n\t\t\t\t  $b->{'start'}  <=> $a->{'start'}\n\t\t\t        } @ctgmarker;\n\t\t\t\t\n\tmy $ctg = -1;\n\t\n\tfor ($i=0; $i < scalar(@sortedctgmarker); $i++) {\n\t    if ($ctg != $sortedctgmarker[$i]->{'contig'}) {\n\t\tif ($ctg == -1) {\n\t\t    $ctg = $sortedctgmarker[$i]->{'contig'};\n\t\t}\n\t\telse  {\t\n\t\t    if ($depth > $save_depth){\n\t\t\t$pos = ($x + $y) >> 1;\n\t\t\t$_contigs{$ctg}{'markers'}{$marker}      = $pos;\n\t\t\t$_markers{$marker}{'posincontig'}{$ctg}  = $pos;\n\t\t    }\n\t\t}\n\t\t\n\t\t$ctg      = $sortedctgmarker[$i]->{'contig'};\n\t\t$x        = $sortedctgmarker[$i]->{'start'};\n\t\t$y        = $sortedctgmarker[$i]->{'end'};\n\t\t$stack[0] = $y;\n\t\t\n\t\t$pos = ($x + $y) >> 1;\n\t\t$_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t$_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t\t\n\t\t$depth = $save_depth = 1;\n\t    }\n\t    elsif ($sortedctgmarker[$i] <= $y) {\n\t\t$stack[$depth++] = $sortedctgmarker[$i]->{'end'};\n\t\t# MAX\n\t\tif ($x < $sortedctgmarker[$i]->{'start'} ) {\n\t\t    $x = $sortedctgmarker[$i]->{'start'};\n\t\t}\n\t\t# MIN\n\t\tif ($y > $sortedctgmarker[$i]->{'end'}) {\n\t\t    $y = $sortedctgmarker[$i]->{'end'};\n\t\t}\t\n\t    }\n\t    else {\n\t\tif ($depth > $save_depth) {\n\t\t    $save_depth = $depth;\n\t\t    $pos = ($x + $y) >> 1;\n\t\t    $_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t    $_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t\t}\n\t\t\n\t\t$x               = $sortedctgmarker[$i]->{'start'};\n\t\t$y               = $sortedctgmarker[$i]->{'end'};\n\t\t$stack[$depth++] = $y;\n\t\t\n\t\tfor($j=-1, $k=0, $s=0; $s<$depth; $s++) {\n\t\t    if ($stack[$s] <$x) {\n\t\t\t$stack[$s] = -1;\n\t\t\t$j = $s if ($j == -1);\n\t\t    }\n\t\t    else {\n\t\t\t$k++;\n\t\t\t# MIN\n\t\t\t$y = $stack[$s] if ($y > $stack[$s]);\n\t\t\tif ($stack[$j] == -1) {\n\t\t\t    $stack[$j] = $stack[$s];\n\t\t\t    $stack[$s] = -1;\n\t\t\t    while ($stack[$j] != -1) {$j++;}\n\t\t\t}\n\t\t\telse {\n\t\t\t    $j = $s;\n\t\t\t}\n\t\t    }\n\t\t    $depth = $k;\n\t\t}\t\n\t    }\n\t    if ($depth > $save_depth) {\n\t\t$pos = ($x + $y) >> 1;\n\t\t$_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t$_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t    }\n\t}\t\n    }\n}\n\n=head2 _calc_contigposition\n\n Title   : _calc_contigposition\n Usage   : $map->_calc_contigposition();\n Function: calculates the position of the contig in the group\n Returns : none\n Args    : none\n\n\nsub _calc_contigposition{\n    my ($self) = @_;\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n\n    foreach my $contig (@sortedcontigs) {\n\t\tmy $position = 0;\n\tmy $group;\n\t\n\tif (exists($_contigs{$contig}{'group'}) ) {\t\t\n\t\n\t    my %weightedmarkers;\n\t    my @mkrs = keys (%{$_contigs{$contig}{'markers'}})\n\t        if (exists($_contigs{$contig}{'markers'})) ;\n\n\t    my $chr = $_contigs{$contig}{'group'};\n\t    $chr = 0 if ($_contigs{$contig}{'group'} =~ /\\?/);\t\n\n\t    foreach my $mkr (@mkrs) {\n\t\tif (exists($_markers{$mkr}{'group'})) {\n\t\t    if ( $_markers{$mkr}{'group'} == $chr ) {\n\t\t\tmy @mkrclones = keys( %{$_markers{$mkr}{'clones'}});\n\t\t\tmy $clonescount = 0;\n\t\t\tforeach my $clone (@mkrclones) {\n\t\t\t    ++$clonescount\n\t\t\t        if ($_clones{$clone}{'contig'} == $contig);\n\t\t\t}\n\t\t\t$weightedmarkers{$_markers{$mkr}{'global'}} =\n\t\t\t    $clonescount;\t\t\t\n\t\t    }\n\t\t}\n\t    }\n\t\n\t    my $weightedctgsum = 0;\n\t    my $totalhits      = 0;\n\n\t    while (my ($mpos,$hits) = each %weightedmarkers) {\n\t\t$weightedctgsum += ($mpos * $hits);\n\t\t$totalhits      += $hits;\n\t    }\n\t\n\t    $position = sprintf(\"%.2f\",$weightedctgsum / $totalhits)\n\t        if ($totalhits != 0);\t\n\t\n\t    $_contigs{$contig}{'position'} = $position;\t\n\t}\n    }\n}\n\n=head2 _calc_contiggroup\n\n Title   : _calc_contiggroup\n Usage   : $map->_calc_contiggroup();\n Function: calculates the group of the contig\n Returns : none\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","name":"_calc_contiggroup","range":{"end":{"line":1287,"character":9999},"start":{"character":0,"line":1285}}},{"localvar":"my","name":"@contigs","definition":"my","containerName":null,"line":1288,"kind":13},{"containerName":null,"name":"$self","line":1288,"kind":13},{"name":"each_contigid","containerName":"main::","kind":12,"line":1288},{"containerName":null,"name":"$ctg","definition":"my","localvar":"my","kind":13,"line":1290},{"containerName":null,"name":"@contigs","kind":13,"line":1290},{"localvar":"my","definition":"my","name":"$chr","containerName":null,"line":1291,"kind":13},{"kind":12,"line":1291,"name":"floor"},{"containerName":null,"name":"$ctg","line":1291,"kind":13},{"name":"%_contig","containerName":null,"line":1292,"kind":13},{"kind":13,"line":1292,"containerName":null,"name":"%ctg"},{"name":"$chr","containerName":null,"kind":13,"line":1292},{"kind":12,"line":1311,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_setCloneRef","line":1312,"kind":13},{"kind":13,"line":1312,"containerName":"_setCloneRef","name":"$ref"},{"name":"$self","containerName":"_setCloneRef","kind":13,"line":1313}],"containerName":"main::","definition":"sub","detail":"($self,$ref)","signature":{"label":"_setCloneRef($self,$ref)","parameters":[{"label":"$self"},{"label":"$ref"}],"documentation":"1;\n# $Id: Physical.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Physical\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Physical - A class for handling a Physical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    use Bio::MapIO;\n\n    # accquire a Bio::Map::Physical using Bio::MapIO::fpc\n    my $mapio = Bio::MapIO->new(-format => \"fpc\",-file => \"rice.fpc\",\n                               -readcor => 0);\n\n    my $physical = $mapio->next_map();\n\n    # get all the markers ids\n    foreach my $marker ( $physical->each_markerid() ) {\n      print \"Marker $marker\\n\";\n\n      # acquire the marker object using Bio::Map::FPCMarker\n      my $markerobj = $physical->get_markerobj($marker);\n\n      # get all the clones hit by this marker\n      foreach my $clone ($markerobj->each_cloneid() ) {\n          print \" +++$clone\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis class is basically a continer class for a collection of Contig maps and\nother physical map information.\n\nBio::Map::Physical has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\nThis class also has some methods with specific functionalities:\n\n  print_gffstyle()     : Generates GFF; either Contigwise[Default] or\n                         Groupwise\n\n  print_contiglist()   : Prints the list of Contigs, markers that hit the\n                         contig, the global position and whether the marker\n                         is a placement (<P>) or a Framework (<F>) marker.\n\n  print_markerlist()   : Prints the markers list; contig and corresponding\n                         number of clones.\n\n  matching_bands()     : Given two clones [and tolerence], this method\n                         calculates how many matching bands do they have.\n\n  coincidence_score()  : Given two clones [,tolerence and gellen], this\n                         method calculates the Sulston Coincidence score.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Physical;\nuse vars qw($MAPCOUNT);\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 version\n\n Title   : version\n Usage   : my $version = $map->version();\n Function: Get/set the version of the program used to\n           generate this map\n Returns : scalar representing the version\n Args    : none to get, OR string to set\n\n\nsub version {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n=head2 modification_user\n\n Title   : modification_user\n Usage   : my $modification_user = $map->modification_user();\n Function: Get/set the name of the user who last modified this map\n Returns : scalar representing the username\n Args    : none to get, OR string to set\n\n\nsub modification_user {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_modification_user'} = $value;\n    }\n    return $self->{'_modification_user'};\n}\n\n=head2 group_type\n\n Title   : group_type\n Usage   : $map->group_type($grptype);\n\t       my $grptype = $map->group_type();\n Function: Get/set the group type of this map\n Returns : scalar representing the group type\n Args    : none to get, OR string to set\n\n\nsub group_type {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_grouptype'} = $value;\n    }\n    return $self->{'_grouptype'};\n}\n\n=head2 group_abbr\n\n Title   : group_abbr\n Usage   : $map->group_abbr($grpabbr);\n\t       my $grpabbr = $map->group_abbr();\n Function: get/set the group abbrev of this map\n Returns : string representing the group abbrev\n Args    : none to get, OR string to set\n\n\nsub group_abbr {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_groupabbr'} = $value;\n    }\n    return $self->{'_groupabbr'};\n}\n\n=head2 core_exists\n\n Title   : core_exists\n Usage   : my $core_exists = $map->core_exists();\n Function: Get/set if the FPC file is accompanied by COR file\n Returns : boolean\n Args    : none to get, OR 1|0 to set\n\n\nsub core_exists {\n    my ($self,$value) = @_;\n    if (defined($value)) {\n\t$self->{'_corexists'} = $value ? 1 : 0;\n    }\n    return $self->{'_corexists'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones = $map->each_cloneid();\n Function: returns an array of clone names\n Returns : list of clone names\n Args    : none\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return keys %{$self->{'_clones'}};\n}\n\n=head2 get_cloneobj\n\n Title   : get_cloneobj\n Usage   : my $cloneobj = $map->get_cloneobj('CLONEA');\n Function: returns an object of the clone given in the argument\n Returns : object of the clone\n Args    : scalar representing the clone name\n\n\nsub get_cloneobj {\n    my ($self,$clone) = @_;\n\n    return 0     if(!defined($clone));\n    return if($clone eq \"\");\n    return if(!exists($self->{'_clones'}{$clone}));\n\n    my ($type,$contig,$bands,$gel,$group,$remark,$fp_number);\n    my ($sequence_type,$sequence_status,$fpc_remark,@amatch,@pmatch,@ematch,\n        $startrange,$endrange);\n    my %clones = %{$self->{'_clones'}{$clone}};\n    my @markers;\n\n    if (ref($clones{'clone'}) eq 'Bio::Map::Clone') {\n\treturn $clones{'clone'};\n    }\n\n    $type    = $clones{'type'}              if (exists($clones{'type'}));\n    @markers = (keys %{$clones{'markers'}}) if (exists($clones{'markers'}));\n    $contig  =  $clones{'contig'}           if (exists($clones{'contig'}));\n    $bands   =  $clones{'bands'}            if (exists($clones{'bands'}));\n    $gel     =  $clones{'gel'}              if (exists($clones{'gel'}));\n    $group   =  $clones{'group'}            if (exists($clones{'group'}));\n    $remark  =  $clones{'remark'}           if (exists($clones{'remark'}));\n\n    $fp_number  =  $clones{'fp_number'}  if (exists($clones{'fp_number'}));\n    $fpc_remark =  $clones{'fpc_remark'} if (exists($clones{'fpc_remark'}));\n\n    $sequence_type   =  $clones{'sequence_type'}\n        if (exists($clones{'sequence_type'}));\n    $sequence_status =  $clones{'sequence_status'}\n        if (exists($clones{'sequence_status'} ));\n\n    @amatch  =  (keys %{$clones{'matcha'}})  if (exists($clones{'matcha'}));\n    @ematch  =  (keys %{$clones{'matche'}})  if (exists($clones{'matche'}));\n    @pmatch  =  (keys %{$clones{'matchp'}})  if (exists($clones{'matchp'}));\n\n    $startrange =  $clones{'range'}{'start'}\n        if (exists($clones{'range'}{'start'}));\n    $endrange   =  $clones{'range'}{'end'}\n        if (exists($clones{'range'}{'end'}));\n\n    #*** why doesn't it call Bio::Map::Clone->new ? Seems dangerous...\n    my $cloneobj = bless( {\n\t_name       => $clone,\n\t_markers    => \\@markers,\n\t_contig     => $contig,\n\t_type       => $type,\n\t_bands      => $bands,\n\t_gel        => $gel,\n\t_group      => $group,\n\t_remark     => $remark,\n\t_fpnumber   => $fp_number,\n\t_sequencetype   => $sequence_type,\n\t_sequencestatus => $sequence_status,\n\t_fpcremark      => $fpc_remark,\n\t_matche     => \\@ematch, \t\t\n\t_matcha     => \\@amatch,\n\t_matchp     => \\@pmatch,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end   => $endrange),\t\n    }, 'Bio::Map::Clone'); \t\t\n\n    $self->{'_clones'}{$clone}{'clone'} = $cloneobj;\n    return $cloneobj;\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: returns list of marker names\n Returns : list of marker names\n Args    : none\n\n\nsub each_markerid {\n   my ($self) = @_;\n   return keys (%{$self->{'_markers'}});\n}\n\n=head2 get_markerobj\n\n Title   : get_markerobj\n Usage   : my $markerobj = $map->get_markerobj('MARKERA');\n Function: returns an object of the marker given in the argument\n Returns : object of the marker\n Args    : scalar representing the marker name\n\n\nsub get_markerobj {\n    my ($self,$marker) = @_;\n\n    return 0 if(!defined($marker));\n    return if($marker eq \"\");\n    return if(!exists($self->{'_markers'}{$marker}));\n\n    my ($global,$framework,$group,$anchor,$remark,$type,$linkage,$subgroup);\n    my %mkr = %{$self->{'_markers'}{$marker}};\n\n    return $mkr{'marker'} if (ref($mkr{'marker'}) eq 'Bio::Map::FPCMarker');\n\n    $type       = $mkr{'type'}       if(exists($mkr{'type'}));\n    $global     = $mkr{'global'}     if(exists($mkr{'global'} ));\n    $framework  = $mkr{'framework'}  if(exists($mkr{'framework'}));\n    $anchor     = $mkr{'anchor'}     if(exists($mkr{'anchor'}));\n    $group      = $mkr{'group'}      if(exists($mkr{'group'}));\n    $subgroup   =  $mkr{'subgroup'}  if(exists($mkr{'subgroup'}));\n    $remark     =  $mkr{'remark'}    if(exists($mkr{'remark'}));\n\n    my %clones  = %{$mkr{'clones'}};\n    my %contigs = %{$mkr{'contigs'}};\n\n    my %markerpos = %{$mkr{'posincontig'}} if(exists($mkr{'posincontig'}));\n\n    #*** why doesn't it call Bio::Map::FPCMarker->new ? Seems dangerous...\n    my $markerobj = bless( {\n\t_name    => $marker,\n\t_type    => $type,\n\t_global  => $global,\n\t_frame   => $framework,\n    _group   => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n    _remark     => $remark,\n\t_clones     => \\%clones,\n\t_contigs    => \\%contigs,\n\t_position   => \\%markerpos,\t\n    }, 'Bio::Map::FPCMarker');\n\n    $self->{'_markers'}{$marker}{'marker'} = $markerobj;\n    return $markerobj;\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: returns a list of contigs (numbers)\n Returns : list of contigs\n Args    : none\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return keys (%{$self->{'_contigs'}});\n}\n\n=head2 get_contigobj\n\n Title   : get_contigobj\n Usage   : my $contigobj = $map->get_contigobj('CONTIG1');\n Function: returns an object of the contig given in the argument\n Returns : object of the contig\n Args    : scalar representing the contig number\n\n\nsub get_contigobj {\n    my ($self,$contig) = @_;\n\n    return 0     if(!defined($contig));\n    return if($contig eq \"\");\n    return if(!exists($self->{'_contigs'}{$contig}));\n\n    my ($group,$anchor,$uremark,$tremark,$cremark,$startrange,$endrange,\n\t$linkage,$subgroup);\n    my %ctg = %{$self->{'_contigs'}{$contig}};\n    my (%position, %pos);\n\n    return $ctg{'contig'} if (ref($ctg{'contig'}) eq 'Bio::Map::Contig');\n\n    $group        =  $ctg{'group'}        if (exists($ctg{'group'}));\n    $subgroup     =  $ctg{'subgroup'}     if (exists($ctg{'subgroup'}));\n    $anchor       =  $ctg{'anchor'}       if (exists($ctg{'anchor'}));\n    $cremark      =  $ctg{'chr_remark'}   if (exists($ctg{'chr_remark'}));\n    $uremark      =  $ctg{'usr_remark'}   if (exists($ctg{'usr_remark'}));\n    $tremark      =  $ctg{'trace_remark'} if (exists($ctg{'trace_remark'}));\n\n    $startrange =  $ctg{'range'}{'start'}\n        if (exists($ctg{'range'}{'start'}));\n    $endrange   =  $ctg{'range'}{'end'}\n        if (exists($ctg{'range'}{'end'}));\n\n    my %clones    =  %{$ctg{'clones'}}     if (exists($ctg{'clones'}));\n    my %markers   =  %{$ctg{'markers'}}    if (exists($ctg{'markers'}));\n\n    my $pos       =  $ctg{'position'};\n\n    #*** why doesn't it call Bio::Map::Contig->new ? Seems dangerous...\n    my $contigobj = bless( {\n\t_group      => $group,\n\t_subgroup   => $subgroup,\n\t_anchor     => $anchor,\n\t_markers    => \\%markers,\n\t_clones     => \\%clones,\n\t_name       => $contig,\n\t_cremark    => $cremark,\n\t_uremark    => $uremark,\n\t_tremark    => $tremark,\n\t_position   => $pos,\n\t_range      => Bio::Range->new(-start => $startrange,\n\t\t\t\t       -end => $endrange),\t\n    }, 'Bio::Map::Contig');\n\n    $self->{'_contigs'}{$contig}{'contig'} = $contigobj;\n    return $contigobj;\n}\n\n=head2 matching_bands\n\n Title   : matching_bands\n Usage   : $self->matching_bands('cloneA','cloneB',[$tol]);\n Function: given two clones [and tolerence], this method calculates how many\n           matching bands do they have.\n           (this method is ported directly from FPC)\n Returns : scalar representing the number of matching bands\n Args    : names of the clones ('cloneA', 'cloneB') [Default tolerence=7]\n\n\nsub matching_bands {\n    my($self,$cloneA,$cloneB,$tol) = @_;\n    my($lstart,$kband,$match,$diff,$i,$j);\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    $tol = 7 if (!defined($tol));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @bandsA = @{$_clones{$cloneA}{'bands'}};\n    my @bandsB = @{$_clones{$cloneB}{'bands'}};\n\n    $match  = 0;\n    $lstart = 0;\n\n    for ($i=0; $i<scalar(@bandsA);$i++) {\n\t$kband = $bandsA[$i];\n\tfor ($j = $lstart; $j<scalar(@bandsB); $j++) {\n\t    $diff = $kband - $bandsB[$j];\n\t    if (abs($diff)  <= $tol ) {\n\t\t$match++;\n\t\t$lstart = $j+1;\n\t\tlast;\n\t    }\n\t    elsif ($diff < 0) {\n\t\t$lstart = $j;\n\t\tlast;\n\t    }\n\t}\n    }\n    return $match;\n}\n\n=head2 coincidence_score\n\n Title   : coincidence_score\n Usage   : $self->coincidence_score('cloneA','cloneB'[,$tol,$gellen]);\n Function: given two clones [,tolerence and gellen], this method calculates\n           the Sulston Coincidence score.\n           (this method is ported directly from FPC)\n Returns : scalar representing the Sulston coincidence score.\n Args    : names of the clones ('cloneA', 'cloneB')\n           [Default tol=7 gellen=3300.0]\n\n\nsub coincidence_score {\n    my($self,$cloneA,$cloneB,$tol,$gellen) = @_;\n\n    return 0 if(!defined($cloneA) || !defined($cloneB) ||\n\t\t!($self->core_exists()));\n\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $numbandsA = scalar(@{$_clones{$cloneA}{'bands'}});\n    my $numbandsB = scalar(@{$_clones{$cloneB}{'bands'}});\n\n    my ($nL,$nH,$m,$i,$psmn,$pp,$pa,$pb,$t,$c,$a,$n);\n    my @logfact;\n    my $score;\n\n    $gellen = 3300.0 if (!defined($gellen));\n    $tol    = 7      if (!defined($tol));\n\n    if ($numbandsA > $numbandsB) {\n\t$nH = $numbandsA;\n\t$nL = $numbandsB;\n    }\n    else {\n\t$nH = $numbandsB;\n\t$nL = $numbandsA;\n    }\n\n    $m = $self->matching_bands($cloneA, $cloneB,$tol);\n\n    $logfact[0] = 0.0;\n    $logfact[1] = 0.0;\n    for ($i=2; $i<=$nL; $i++) {\n\t$logfact[$i] = $logfact[$i - 1] + log($i);\n    }\n\n    $psmn = 1.0 - ((2*$tol)/$gellen);\n\n    $pp = $psmn ** $nH;\n    $pa = log($pp);\n    $pb = log(1 - $pp);\n    $t  = 1e-37;\n\n    for ($n = $m; $n <= $nL; $n++)  {\n\t$c = $logfact[$nL] - $logfact[$nL - $n] - $logfact[$n];\n\t$a = exp($c + ($n * $pb) + (($nL - $n) * $pa));\n\t$t += $a;\n    }\n\n    $score = sprintf(\"%.e\",$t);\n    return $score;\n}\n\n=head2 print_contiglist\n\n Title   : print_contiglist\n Usage   : $map->print_contiglist([showall]); #[Default 0]\n Function: prints the list of contigs, markers that hit the contig, the\n           global position and whether the marker is a placement (P) or\n           a Framework (F) marker.\n Returns : none\n Args    : [showall] [Default 0], 1 includes all the discrepant markers\n\n\nsub print_contiglist{\n    my ($self,$showall) = @_;\n    my $pos;\n\n    $showall = 0 if (!defined($showall));\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n\n    print \"\\n\\nContig List\\n\\n\";\n    foreach my $contig (@sortedcontigs) {\n        my %list;\n\tmy %alist;\n\t\n\tmy $ctgAnchor  = $_contigs{$contig}{'anchor'};\n\tmy $ctgGroup   = $_contigs{$contig}{'group'};\t\n\t\n\tmy @mkr = keys ( %{$_contigs{$contig}{'markers'}} );\n\t\n\tforeach my $marker (@mkr)  {\t\n\t    my $mrkGroup       = $_markers{$marker}{'group'};\n\t    my $mrkGlobal      = $_markers{$marker}{'global'};\n\t    my $mrkFramework   = $_markers{$marker}{'framework'};\n\t    my $mrkAnchor      = $_markers{$marker}{'anchor'}; \t    \t\n\n\t    if($ctgGroup =~ /\\d+|\\w/ && $ctgGroup != 0)  {\t\t\n\t\tif ($mrkGroup eq $ctgGroup) {\n\t\t    if ($mrkFramework == 0)  {\t\t\n\t\t\t$pos = $mrkGlobal.\"P\";\n\t\t    }\n\t\t    else {\n\t\t\t$pos = $mrkGlobal.\"F\";\n\t\t    }\t\t\n\t\t    $list{$marker} = $pos;\n\t\t}\n\t\telsif ($showall == 1) {\t\t\t\n\t\t    my $chr = $self->group_abbr().$mrkGroup;\n\t\t    $alist{$marker} = $chr;\n\t\t} \t\n\t    }\n\t    elsif ($showall == 1 &&  $ctgGroup !~ /\\d+/) {\n\t\tmy $chr = $self->group_abbr().$mrkGroup;\n\t\t$alist{$marker} = $chr;\n\t    }\n\t}\n\t\n\tmy $chr = $ctgGroup;\n\t$chr = $self->group_abbr().$ctgGroup if ($ctgGroup =~ /\\d+|\\w/);\n\t\n\tif ($showall == 1 ) {\n\t   \t\n\t    print \"   ctg$contig  \", $chr, \"  \"\n\t\tif ($_contigs{$contig}{'group'} !~ /\\d+|\\w/);  \t\t\n        }\n\telsif ($ctgGroup =~ /\\d+|\\w/ && $ctgGroup ne 0){\n\t        print \"   ctg\",$contig, \"  \",$chr, \"  \";\n\t}  \t\n\t\n\twhile (my ($k,$v) = each %list) {\n            print \"$k/$v  \";\t\t\n\t}\n\t\n\tprint \"\\n\" if ($showall == 0 && $ctgGroup =~ /\\d+|\\w/ &&\n\t\t       $ctgGroup ne 0 );\n\t\n\tif ($showall == 1) {\n            while (my ($k,$v) = each %alist) {\n\t\tprint \"$k/$v  \";\t\t\n            }  \t\t\n\t    print \"\\n\";\n        }\n    }\n}\n\n=head2 print_markerlist\n\n Title    : print_markerlist\n Usage    : $map->print_markerlist();\n Function : prints the marker list; contig and corresponding number of\n            clones for each marker.\n Returns  : none\n Args     : none\n\n\nsub print_markerlist {\n    my ($self) = @_;\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    print \"Marker List\\n\\n\";\n\n    foreach my $marker ($self->each_markerid()) {\n        print \"  \",$marker, \"  \";\n\t\n\tmy %list;\n\tmy %mclones = %{$_markers{$marker}{'clones'}};\n\t\n\tforeach my $clone (%mclones) {\n\t    if (exists($_clones{$clone}{'contig'}) ) {\n\t\tmy $ctg = $_clones{$clone}{'contig'};\n\t\t\n\t\tif (exists($list{$ctg})) {\n\t\t    my $clonehits = $list{$ctg};\n\t\t    $clonehits++;\n\t\t    $list{$ctg} = $clonehits;\n\t\t}\n\t\telse {\n\t\t    $list{$ctg} = 1;\n\t\t}\n\t    }\n\t}\n\twhile (my ($k,$v) = each %list) {\n\t    print \"$k/$v  \";\n        }\n        print \"\\n\";\n    }\n}\n\n=head2 print_gffstyle\n\n Title    : print_gffstyle\n Usage    : $map->print_gffstyle([style]);\n Function : prints GFF; either Contigwise (default) or Groupwise\n Returns  : none\n Args     : [style] default = 0 contigwise, else\n                              1 groupwise (chromosome-wise).\n\n\nsub print_gffstyle {\n    my ($self,$style) = @_;\n\n    $style = 0 if(!defined($style));\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $i;\n    my ($depth, $save_depth);\n    my ($x, $y);\n    my @stack;\n    my ($k, $j, $s);\n    my $pos;\n    my $contig;\n\n    # Calculate the position for the marker in the contig\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n    my $offset = 0;\n    my %gffclones;\n    my %gffcontigs;\n    my %gffmarkers;\n    my $basepair = 4096;\n\n    foreach my $contig (@sortedcontigs) {\n        if($_contigs{$contig}{'range'} ) {\t\n\t    $offset =  $_contigs{$contig}{'range'}{'start'};\t\n\t\n\t    if ($offset <= 0){\n\t        $offset = $offset * -1;\t\n\t\t$gffcontigs{$contig}{'start'} = 1;\n\t\t$gffcontigs{$contig}{'end'}   =\n\t\t    ($_contigs{$contig}{'range'}{'end'} +\n\t\t     $offset ) * $basepair + 1;\t\t\t\t\n\t    }\n\t    else {\n\t        $offset = 0;\n\t\t$gffcontigs{$contig}{'start'} =\n\t\t    $_contigs{$contig}{'range'}{'start'} * $basepair;\n\t\t$gffcontigs{$contig}{'end'}   =\n\t\t    $_contigs{$contig}{'range'}{'end'} * $basepair;\n\t    }\t    \t\t\n\t}\n\telse {\n\t    $gffcontigs{$contig}{'start'} = 1;\n            $gffcontigs{$contig}{'end'}   = 1;\t\t\n\t} \t\n\t\n\tmy @clones  =  keys %{$_contigs{$contig}{'clones'}};\t\n\tforeach my $clone (@clones) {\n\t    if(exists ($_clones{$clone}{'range'}) ) {\n\t        my $gffclone = $clone;\n\t\t\n\t\t$gffclone =~ s/sd1$//;\n\t\t\n\t\t$gffclones{$gffclone}{'start'} =\n\t\t    (($_clones{$clone}{'range'}{'start'} + $offset) *\n\t\t     $basepair + 1);\n\n\t\t$gffclones{$gffclone}{'end'}   =\n\t\t    (($_clones{$clone}{'range'}{'end'}\n\t\t      + $offset) * $basepair + 1);\n\t    }\n\t\n\t    if(!$contig) {\t\n\t        my %markers = %{$_clones{$clone}{'markers'}}\n\t\tif (exists($_clones{$clone}{'markers'}));\n\n\t        while (my ($k,$v) = each %markers) {\n\t\t    $gffmarkers{$contig}{$k} =\n\t\t    ( ( $_clones{$clone}{'range'}{'start'} +\n\t\t\t$_clones{$clone}{'range'}{'end'} ) / 2 ) *\n\t\t\t$basepair + 1 ;\n\t\t}\t\n\t    }\n\t}\t\n\t\n\tif($contig) {\n\t    my %markers = %{$_contigs{$contig}{'markers'}}\n\t        if (exists($_contigs{$contig}{'markers'}));\n\n\t    while (my ($k,$v) = each %markers) {\n\t        $gffmarkers{$contig}{$k} = ($v + $offset) * $basepair + 1;\n\t    }\n\t}\n    }\n\n    if (!$style) {\n\tforeach my $contig (@sortedcontigs) {\n\t   \t\n\t    if(exists ($_contigs{$contig}{'range'} )  ) {\t\n\t\tprint join(\"\\t\",\"ctg$contig\",\"assembly\",\"contig\",\n\t\t\t   $gffcontigs{$contig}{'start'},\n\t\t\t   $gffcontigs{$contig}{'end'},\".\",\".\",\".\",\n\t\t\t   \"Sequence \\\"ctg$contig\\\"; Name \\\"ctg$contig\\\"\\n\"\n                          );\n\t    }\n\t\n\t    my @clones = (keys %{$_contigs{$contig}{'clones'}} );\n\t\n\t    foreach my $clone (@clones) {\n\t\tif(exists ($_clones{$clone}{'range'}) ) {\t\n\t\t    print join(\"\\t\",\"ctg$contig\",\"FPC\");\n\t\t\n\t\t    my $type = $_clones{$clone}{'type'};\n\t\t\n\t\t    if($clone =~ /sd1$/) {\n\t\t\t$clone =~ s/sd1$//;\n   \t\t        $type  = \"sequenced\";\n\t\t    }\t\t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffclones{$clone}{'start'},\n\t\t\t\t$gffclones{$clone}{'end'},\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$clone\\\"; Name \\\"$clone\\\"\");\n\n\t\t    my @markers = keys %{$_clones{$clone}{'markers'}};\n\t\t    print \"; Marker_hit\" if (scalar(@markers));\n\t\t\n\t\t    foreach my $mkr(@markers) {\n\t\t\tif (exists($_markers{$mkr}{'framework'})) {\n\t\t\t    print \" \\\"$mkr \",$_markers{$mkr}{'group'},\" \",\n\t\t\t\t   $_markers{$mkr}{'global'},\"\\\"\";\n\t\t\t}\n\t\t\telse {\n\t\t\t    print \" \\\"$mkr 0 0\\\"\";\n\t\t\t}\n\t\t    }\t\n\t\t    print \"; Contig_hit \\\"\",$_clones{$clone}{'contig'},\"\\\" \"\n\t\t        if (defined($_clones{$clone}{'contig'}));\n\t\t}\n\t\tprint \"\\n\";\n\t    }\n\t\n\t    if (exists ($_contigs{$contig}{'markers'}) ) {\t\n\t\tmy %list = %{$_contigs{$contig}{'markers'}};\n\t\t\n\t\twhile (my ($k,$v) = each %list) {\n\t\t    print \"ctg\", $contig, \"\\tFPC\\t\";\n\t\t    my $position = $gffmarkers{$contig}{$k};\n\t\t\n\t\t    my $type = \"marker\";\n\t\t\n\t\t    $type = \"electronicmarker\"\n\t\t         if ($_markers{$k}{'type'} eq \"eMRK\");\n\t\t\n\t\t    if( exists($_markers{$k}{'framework'})) {\n\t\t\t$type = \"frameworkmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 1);\n\t\t\t\n\t\t\t$type = \"placementmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 0);\n\t\t    }\t\n\t\t\n\t\t    print join (\"\\t\",\"$type\",$position,$position,\".\",\".\",\n                                \".\",\"$type \\\"$k\\\"; Name \\\"$k\\\"\");\n\t\t\n\t            my @clonelist;\n\t\t    my @clones  = keys %{$_markers{$k}{'clones'}};\n\t\t\n\t\t    foreach my $cl (@clones) {\n\t\t\tpush (@clonelist, $cl)\n\t\t\t    if($_clones{$cl}{'contig'} == $contig);\n\t\t    }\n\t\t\n\t\t    $\" = \" \";\n\t\t    print(\"; Contig_hit \\\"ctg$contig - \",scalar(@clonelist),\n\t\t\t  \"\\\" (@clonelist)\\n\");\n\t\t}\n\t    }  \t\t   \t\n\t}\n    }\n    else {\n\tmy %_groups;\n\tmy $margin       = 2 * $basepair;\n\tmy $displacement = 0;\n\tmy @grouplist;\n\t\n\tforeach my $contig (@sortedcontigs) {\n\t    my $recordchr;\n            my $chr = $_contigs{$contig}{'group'};\t\t\n\t    $chr = 0 if ($chr !~ /\\d+|\\w+/);\n\t\n            $recordchr->{group}      = $chr;\n\t    $recordchr->{contig}     = $contig;\n\t    $recordchr->{position}   = $_contigs{$contig}{'position'};\n\n\t    push @grouplist, $recordchr;\t\n\t}\n\t\n\tmy @chr       = keys (%{$_groups{'group'}});\n\tmy @sortedchr;\n\t\n\tif ($self->group_type eq 'Chromosome') {\n\t    @sortedchr = sort { $a->{'group'} <=> $b->{'group'}\n\t\t\t\t               ||\n\t\t\t\t$a->{'contig'} <=> $b->{'contig'}\n                              } @grouplist;\n\t}\n\telse {\n\t    @sortedchr = sort { $a->{'group'}  cmp $b->{'group'} \t\n\t\t\t\t                ||\n\t\t\t\t$a->{'contig'} cmp $b->{'contig'}\n                              } @grouplist;\n\t}\n\tmy $lastchr   = -1;\n\tmy $chrend    = 0;\n\n\tforeach my $chr (@sortedchr) {\n\t    my $chrname = $self->group_abbr().$chr->{'group'};\t\n\t\n\t    if ($lastchr eq -1 || $chr->{'group'} ne $lastchr ) {\n\t\t$lastchr = $chr->{'group'} if ($lastchr eq -1);\t\t\n\t\t$displacement = 0;\t\n\t\t\n\t\t# caluclate the end position of the contig\t\t\n\t\tmy $ctgcount = 0;\n\t\tmy $prevchr  = 0;\t\t\n\t\t$chrend = 0;\n\t\t\n\t\tif ($chr->{contig} != 0) {\t\t\n\t\t    foreach my $ch (@sortedchr) {\n\t\t\tif ($ch->{'group'} eq $chr->{'group'}) {\n\t\t\t    if($ch->{'contig'} != 0) {\t\n\t\t\t\tmy $ctg  = $ch->{'contig'}\n\t\t\t\t    if($ch->{'contig'} != 0);\n\n\t\t\t\t$chrend += $gffcontigs{$ctg}->{'end'};\n\t\t\t\t++$ctgcount;\n\t\t\t    }\t\t\t    \t\n\t\t\t}\n\t\t    }\t\n\t\t    $chrend += ($ctgcount-1) * $margin;\n\t\t}\n\t\telse {\n\t\t    $chrend  = $gffcontigs{'0'}->{'end'};\n\t\t}\n\t\t\n\t\t$chrname    = $self->group_abbr().\"ctg0\"\n\t\tif ($chr->{'contig'} == 0);\n\t\t\n\t\tprint join (\"\\t\", $chrname,\"assembly\",\"Chromosome\",1,\n\t\t\t    \"$chrend\",\".\",\".\",\".\",\n\t\t\t    \"Sequence \\\"$chrname\\\"; Name \\\"$chrname\\\"\\n\");\n\t    }\n\t\n\t    print join (\"\\t\", $chrname,\"assembly\",\"Chromosome\",1,\n\t\t\t\"$chrend\",\".\",\".\",\".\",\n\t\t\t\"Sequence \\\"$chrname\\\"; Name \\\"$chrname\\\"\\n\")\n\t        if ($chr->{'group'} ne $lastchr && $chr->{'group'} eq 0 );\n\t\n\t    $lastchr = $chr->{'group'};\n\t    $lastchr = -1 if ($chr->{'contig'} == 0);\t\n\t\n\t    my $contig = $chr->{'contig'};\n\t    \t\n\t    if(exists ($_contigs{$contig}{'range'} )  ) {\n\t\t\n\t\tprint join (\"\\t\",$chrname, \"FPC\",\"contig\",\n\t\t\t    $gffcontigs{$contig}{'start'}+$displacement,\n\t\t            $gffcontigs{$contig}{'end'}+$displacement,\n\t\t\t    \".\",\".\",\".\",\n\t\t\t    \"contig \\\"ctg$contig\\\"; Name \\\"ctg$contig\\\"\\n\");\n\t    }\n\t\n\t    my @clones = (keys %{$_contigs{$contig}{'clones'}} );\n\t    foreach my $clone (@clones) {\n\t\tif(exists ($_clones{$clone}{'range'}) ) {\t\n\t\t    print join (\"\\t\",$chrname,\"FPC\");\n\t\t    my $type = $_clones{$clone}{'type'};\n\t\t\n\t\t    if ($clone =~ /sd1$/) {\n\t\t\t$clone =~ s/sd1$//;\n\t\t\t$type  = \"sequenced\";\n\t\t    }\n\t\t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffclones{$clone}{'start'}\n\t\t\t\t+$displacement,$gffclones{$clone}{'end'}\n\t\t\t\t+$displacement,\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$clone\\\"; Name \\\"$clone\\\"\");\n\t\t\n\t\t    my @markers = keys %{$_clones{$clone}{'markers'}};\n\t\t    print \"; Marker_hit\" if (scalar(@markers));\n\t\t    \t\t\n\t\t    foreach my $mkr(@markers) {\n\t\t\tif (exists($_markers{$mkr}{'framework'})) {\n\t\t\t    print \" \\\"$mkr \",$_markers{$mkr}{'group'},\" \",\n\t\t\t\t   $_markers{$mkr}{'global'},\"\\\"\";\n\t\t\t}\n\t\t\telse {\n\t\t\t    print (\" \\\"$mkr 0 0\\\"\");\n\t\t\t}\n\t\t    }\t\n\t\t    print \"; Contig_hit \\\"\",$_clones{$clone}{'contig'},\"\\\" \"\n\t\t        if (defined($_clones{$clone}{'contig'}));\n\t\t}\n\t\tprint \"\\n\";\n\t    }\n\t\n\t    if (exists ($_contigs{$contig}{'markers'}) ) {\t\n\t\tmy %list = %{$_contigs{$contig}{'markers'}};\n\t\t\n\t\twhile (my ($k,$v) = each %list) {\n\t\t    print join (\"\\t\",$chrname,\"FPC\");\n\t\t    my $type = \"marker\";\n\t\t\n\t\t    $type = \"electronicmarker\"\n\t\t        if ($_markers{$k}{'type'} eq \"eMRK\");\n\t\t\n\t\t    if( exists($_markers{$k}{'framework'})) {\n\t\t\t$type = \"frameworkmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 1);\n\t\t\t\n\t\t\t$type = \"placementmarker\"\n\t\t\t    if($_markers{$k}{'framework'} == 0);\t\n\t\t    }\t\n\t\t    \t\t    \t\t    \t\n\t\t    print join (\"\\t\",\"\\t$type\",$gffmarkers{$contig}{$k}\n\t\t\t\t+ $displacement,$gffmarkers{$contig}{$k}\n\t\t\t\t+ $displacement,\".\",\".\",\".\",\n\t\t\t\t\"$type \\\"$k\\\"; Name \\\"$k\\\"\");\n\n\t\t    my @clonelist;\n\t\t    my @clones  = keys %{$_markers{$k}{'clones'}};\n\t\t\n\t\t    foreach my $cl (@clones) {\n\t\t\tpush (@clonelist, $cl)\n\t\t\t    if($_clones{$cl}{'contig'} == $contig);\n\t\t    }\n\t\t\n\t\t    $\" = \" \";\t\t\n\t\t    print(\"; Contig_hit \\\"ctg$contig - \",\n\t\t\t  scalar(@clonelist),\"\\\" (@clonelist)\\n\");\n\t\t}\n\t    }\n\t    $displacement += $margin + $gffcontigs{$contig}{'end'};\n\t}\n    }\n}\n\n=head2 _calc_markerposition\n\n Title   : _calc_markerposition\n Usage   : $map->_calc_markerposition();\n Function: Calculates the position of the marker in the contig\n Returns : none\n Args    : none\n\n\nsub _calc_markerposition {\n    my ($self) = @_;\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my $i;\n    my ($depth, $save_depth);\n    my ($x, $y);\n    my @stack;\n    my ($k, $j, $s);\n    my $pos;\n    my $contig;\n\n    # Calculate the position for the marker in the contig\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n    my $offset;\n    my %gffclones;\n    my %gffcontigs;\n\n    foreach my $marker ($self->each_markerid()) {\n        my (@ctgmarker, @sortedctgmarker);\n\t\n\tmy @clones = (keys %{$_markers{$marker}{'clones'}})\n\t    if (exists ($_markers{$marker}{'clones'} ));\n\t\n        foreach my $clone (@clones) {\n\t    my $record;\n\t    $record->{contig} = $_clones{$clone}{'contig'};\t\t\n\t    $record->{start}  = $_clones{$clone}{'range'}{'start'};\n\t    $record->{end}    = $_clones{$clone}{'range'}{'end'};\n\t    push @ctgmarker,$record;\n\t}\n\t\n\t# sorting by contig and left position\n\t@sortedctgmarker = sort { $a->{'contig'} <=> $b->{'contig'}\n\t\t\t\t                  ||\n\t\t\t\t  $b->{'start'}  <=> $a->{'start'}\n\t\t\t        } @ctgmarker;\n\t\t\t\t\n\tmy $ctg = -1;\n\t\n\tfor ($i=0; $i < scalar(@sortedctgmarker); $i++) {\n\t    if ($ctg != $sortedctgmarker[$i]->{'contig'}) {\n\t\tif ($ctg == -1) {\n\t\t    $ctg = $sortedctgmarker[$i]->{'contig'};\n\t\t}\n\t\telse  {\t\n\t\t    if ($depth > $save_depth){\n\t\t\t$pos = ($x + $y) >> 1;\n\t\t\t$_contigs{$ctg}{'markers'}{$marker}      = $pos;\n\t\t\t$_markers{$marker}{'posincontig'}{$ctg}  = $pos;\n\t\t    }\n\t\t}\n\t\t\n\t\t$ctg      = $sortedctgmarker[$i]->{'contig'};\n\t\t$x        = $sortedctgmarker[$i]->{'start'};\n\t\t$y        = $sortedctgmarker[$i]->{'end'};\n\t\t$stack[0] = $y;\n\t\t\n\t\t$pos = ($x + $y) >> 1;\n\t\t$_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t$_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t\t\n\t\t$depth = $save_depth = 1;\n\t    }\n\t    elsif ($sortedctgmarker[$i] <= $y) {\n\t\t$stack[$depth++] = $sortedctgmarker[$i]->{'end'};\n\t\t# MAX\n\t\tif ($x < $sortedctgmarker[$i]->{'start'} ) {\n\t\t    $x = $sortedctgmarker[$i]->{'start'};\n\t\t}\n\t\t# MIN\n\t\tif ($y > $sortedctgmarker[$i]->{'end'}) {\n\t\t    $y = $sortedctgmarker[$i]->{'end'};\n\t\t}\t\n\t    }\n\t    else {\n\t\tif ($depth > $save_depth) {\n\t\t    $save_depth = $depth;\n\t\t    $pos = ($x + $y) >> 1;\n\t\t    $_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t    $_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t\t}\n\t\t\n\t\t$x               = $sortedctgmarker[$i]->{'start'};\n\t\t$y               = $sortedctgmarker[$i]->{'end'};\n\t\t$stack[$depth++] = $y;\n\t\t\n\t\tfor($j=-1, $k=0, $s=0; $s<$depth; $s++) {\n\t\t    if ($stack[$s] <$x) {\n\t\t\t$stack[$s] = -1;\n\t\t\t$j = $s if ($j == -1);\n\t\t    }\n\t\t    else {\n\t\t\t$k++;\n\t\t\t# MIN\n\t\t\t$y = $stack[$s] if ($y > $stack[$s]);\n\t\t\tif ($stack[$j] == -1) {\n\t\t\t    $stack[$j] = $stack[$s];\n\t\t\t    $stack[$s] = -1;\n\t\t\t    while ($stack[$j] != -1) {$j++;}\n\t\t\t}\n\t\t\telse {\n\t\t\t    $j = $s;\n\t\t\t}\n\t\t    }\n\t\t    $depth = $k;\n\t\t}\t\n\t    }\n\t    if ($depth > $save_depth) {\n\t\t$pos = ($x + $y) >> 1;\n\t\t$_contigs{$ctg}{'markers'}{$marker}     = $pos;\n\t\t$_markers{$marker}{'posincontig'}{$ctg} = $pos;\n\t    }\n\t}\t\n    }\n}\n\n=head2 _calc_contigposition\n\n Title   : _calc_contigposition\n Usage   : $map->_calc_contigposition();\n Function: calculates the position of the contig in the group\n Returns : none\n Args    : none\n\n\nsub _calc_contigposition{\n    my ($self) = @_;\n\n    my %_contigs = %{$self->{'_contigs'}};\n    my %_markers = %{$self->{'_markers'}};\n    my %_clones  = %{$self->{'_clones'}};\n\n    my @contigs       = $self->each_contigid();\n    my @sortedcontigs = sort {$a <=> $b } @contigs;\n\n    foreach my $contig (@sortedcontigs) {\n\t\tmy $position = 0;\n\tmy $group;\n\t\n\tif (exists($_contigs{$contig}{'group'}) ) {\t\t\n\t\n\t    my %weightedmarkers;\n\t    my @mkrs = keys (%{$_contigs{$contig}{'markers'}})\n\t        if (exists($_contigs{$contig}{'markers'})) ;\n\n\t    my $chr = $_contigs{$contig}{'group'};\n\t    $chr = 0 if ($_contigs{$contig}{'group'} =~ /\\?/);\t\n\n\t    foreach my $mkr (@mkrs) {\n\t\tif (exists($_markers{$mkr}{'group'})) {\n\t\t    if ( $_markers{$mkr}{'group'} == $chr ) {\n\t\t\tmy @mkrclones = keys( %{$_markers{$mkr}{'clones'}});\n\t\t\tmy $clonescount = 0;\n\t\t\tforeach my $clone (@mkrclones) {\n\t\t\t    ++$clonescount\n\t\t\t        if ($_clones{$clone}{'contig'} == $contig);\n\t\t\t}\n\t\t\t$weightedmarkers{$_markers{$mkr}{'global'}} =\n\t\t\t    $clonescount;\t\t\t\n\t\t    }\n\t\t}\n\t    }\n\t\n\t    my $weightedctgsum = 0;\n\t    my $totalhits      = 0;\n\n\t    while (my ($mpos,$hits) = each %weightedmarkers) {\n\t\t$weightedctgsum += ($mpos * $hits);\n\t\t$totalhits      += $hits;\n\t    }\n\t\n\t    $position = sprintf(\"%.2f\",$weightedctgsum / $totalhits)\n\t        if ($totalhits != 0);\t\n\t\n\t    $_contigs{$contig}{'position'} = $position;\t\n\t}\n    }\n}\n\n=head2 _calc_contiggroup\n\n Title   : _calc_contiggroup\n Usage   : $map->_calc_contiggroup();\n Function: calculates the group of the contig\n Returns : none\n Args    : none\n\n\nsub _calc_contiggroup {\n    my ($self)  = @_;\n    my %_contig = %{$self->{'_contigs'}};\n    my @contigs = $self->each_contigid();\n\n    foreach my $ctg (@contigs) {\n        my $chr = floor($ctg/1000);\n\t\t$_contig{$ctg}{'group'} = $chr;\n    }\n}\n\n=head2 _setI<E<lt>TypeE<gt>>Ref\n\n Title   : _set<Type>Ref\n Usage   : These are used for initializing the reference of the hash in\n           Bio::MapIO (fpc.pm) to the corresponding hash in Bio::Map\n           (physical.pm). Should be used only from Bio::MapIO System.\n               $map->setCloneRef(\\%_clones);\n               $map->setMarkerRef(\\%_markers);\n               $map->setContigRef(\\%_contigs);\n Function: sets the hash references to the corresponding hashes\n Returns : none\n Args    : reference of the hash."},"name":"_setCloneRef","range":{"start":{"line":1311,"character":0},"end":{"line":1313,"character":9999}}},{"line":1313,"kind":13,"name":"$ref","containerName":null},{"name":"_setMarkerRef","range":{"end":{"character":9999,"line":1318},"start":{"character":0,"line":1316}},"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$ref"}],"label":"_setMarkerRef($self,$ref)"},"detail":"($self,$ref)","kind":12,"children":[{"kind":13,"line":1317,"containerName":"_setMarkerRef","name":"$self","definition":"my","localvar":"my"},{"line":1317,"kind":13,"name":"$ref","containerName":"_setMarkerRef"},{"containerName":"_setMarkerRef","name":"$self","kind":13,"line":1318}],"line":1316},{"name":"$ref","containerName":null,"line":1318,"kind":13},{"kind":12,"line":1321,"children":[{"containerName":"_setContigRef","definition":"my","name":"$self","localvar":"my","kind":13,"line":1322},{"kind":13,"line":1322,"name":"$ref","containerName":"_setContigRef"},{"line":1323,"kind":13,"name":"$self","containerName":"_setContigRef"}],"containerName":"main::","definition":"sub","detail":"($self,$ref)","signature":{"label":"_setContigRef($self,$ref)","parameters":[{"label":"$self"},{"label":"$ref"}],"documentation":""},"name":"_setContigRef","range":{"end":{"character":9999,"line":1323},"start":{"character":0,"line":1321}}},{"line":1323,"kind":13,"containerName":null,"name":"$ref"}],"version":5}