{"version":5,"vars":[{"kind":2,"line":101,"containerName":"","name":"base"},{"kind":12,"children":[{"line":114,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":114},{"localvar":"my","name":"$self","definition":"my","containerName":"new","line":115,"kind":13},{"kind":13,"line":115,"containerName":"new","name":"$class"},{"name":"@args","containerName":"new","line":115,"kind":13},{"definition":"my","name":"$order","containerName":"new","localvar":"my","kind":13,"line":117},{"kind":13,"line":117,"name":"$self","containerName":"new"},{"kind":12,"line":117,"containerName":"new","name":"_rearrange"},{"kind":13,"line":117,"containerName":"new","name":"@args"},{"kind":13,"line":118,"containerName":"new","name":"$order"},{"containerName":"new","name":"$self","kind":13,"line":118},{"line":118,"kind":12,"name":"order","containerName":"new"},{"kind":13,"line":118,"containerName":"new","name":"$order"},{"name":"$self","containerName":"new","kind":13,"line":120}],"line":113,"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# BioPerl module for Bio::Map::OrderedPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::OrderedPosition - Abstracts the notion of a member\n\tof an ordered list of markers. Each marker is a certain distance\n\tfrom the one in the ordered list before it.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::OrderedPosition;\n\t# the first marker in the sequence\n    my $position = Bio::Map::OrderedPosition->new(-order => 1,\n\t\t\t-positions => [ [ $map, 22.3] ] );\n\t# the second marker in the sequence, 15.6 units from the fist one\n    my $position2 = Bio::Map::OrderedPosition->new(-order => 2,\n\t\t\t-positions => [ [ $map, 37.9] ] );\n\t# the third marker in the sequence, coincidental with the second\n\t# marker\n    my $position3 = Bio::Map::OrderedPosition->new(-order => 3,\n                        -posititions => [ [ $map, 37.9]] );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface and the\nPosition object handles the specific values of a position.\nOrderedPosition is intended to be slightly more specific then Position\nbut only specific enough for a parser from the MarkerIO subsystem to\ncreate and then pass to a client application to bless into the proper\ntype. For an example of how this is intended to work, see the\nMapmaker.pm.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in.\n\nSe Bio::Map::Position for additional information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nJason Stajich, jason@bioperl.org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::OrderedPosition;\nuse strict;\n\n\nuse base qw(Bio::Map::Position);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::OrderedPosition->new();\n Function: Builds a new Bio::Map::OrderedPosition object \n Returns : Bio::Map::OrderedPosition\n Args    : -order : The order of this position"},"detail":"($class,@args)","name":"new","range":{"start":{"line":113,"character":0},"end":{"line":121,"character":9999}}},{"line":115,"kind":12,"containerName":"new","name":"SUPER"},{"kind":12,"line":134,"children":[{"containerName":"order","name":"$self","definition":"my","localvar":"my","kind":13,"line":135},{"name":"$order","containerName":"order","kind":13,"line":135},{"containerName":"order","name":"$order","line":136,"kind":13},{"name":"$self","containerName":"order","line":137,"kind":13},{"line":137,"kind":13,"containerName":"order","name":"$order"},{"containerName":"order","name":"$self","line":139,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$order)","signature":{"documentation":"1;\n# BioPerl module for Bio::Map::OrderedPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::OrderedPosition - Abstracts the notion of a member\n\tof an ordered list of markers. Each marker is a certain distance\n\tfrom the one in the ordered list before it.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::OrderedPosition;\n\t# the first marker in the sequence\n    my $position = Bio::Map::OrderedPosition->new(-order => 1,\n\t\t\t-positions => [ [ $map, 22.3] ] );\n\t# the second marker in the sequence, 15.6 units from the fist one\n    my $position2 = Bio::Map::OrderedPosition->new(-order => 2,\n\t\t\t-positions => [ [ $map, 37.9] ] );\n\t# the third marker in the sequence, coincidental with the second\n\t# marker\n    my $position3 = Bio::Map::OrderedPosition->new(-order => 3,\n                        -posititions => [ [ $map, 37.9]] );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface and the\nPosition object handles the specific values of a position.\nOrderedPosition is intended to be slightly more specific then Position\nbut only specific enough for a parser from the MarkerIO subsystem to\ncreate and then pass to a client application to bless into the proper\ntype. For an example of how this is intended to work, see the\nMapmaker.pm.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in.\n\nSe Bio::Map::Position for additional information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nJason Stajich, jason@bioperl.org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::OrderedPosition;\nuse strict;\n\n\nuse base qw(Bio::Map::Position);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::OrderedPosition->new();\n Function: Builds a new Bio::Map::OrderedPosition object \n Returns : Bio::Map::OrderedPosition\n Args    : -order : The order of this position\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($order) = $self->_rearrange([qw(ORDER)], @args);\n    $order && $self->order($order);\n    \n    return $self;\n}\n\n=head2 order\n\n Title   : order\n Usage   : $o_position->order($new_order);\n           my $order = $o_position->order();\n Function: Get/set the order position of this position in a map.\n Returns : int, the order of this position\n Args    : none to get, OR int to set","parameters":[{"label":"$self"},{"label":"$order"}],"label":"order($self,$order)"},"name":"order","range":{"end":{"line":140,"character":9999},"start":{"character":0,"line":134}}},{"children":[{"localvar":"my","containerName":"sortable","name":"$self","definition":"my","line":156,"kind":13},{"name":"$self","containerName":"sortable","line":157,"kind":13},{"name":"order","containerName":"sortable","line":157,"kind":12}],"line":155,"kind":12,"range":{"start":{"character":0,"line":155},"end":{"line":158,"character":9999}},"definition":"sub","name":"sortable","containerName":"main::"},{"kind":12,"line":170,"children":[{"localvar":"my","containerName":"equals","definition":"my","name":"$self","line":171,"kind":13},{"containerName":"equals","name":"$compare","line":171,"kind":13},{"name":"$compare","containerName":"equals","line":172,"kind":13},{"name":"$compare","containerName":"equals","line":172,"kind":13},{"kind":12,"line":172,"containerName":"equals","name":"isa"},{"line":173,"kind":13,"containerName":"equals","name":"$compare"},{"kind":12,"line":173,"containerName":"equals","name":"order"},{"kind":13,"line":173,"name":"$self","containerName":"equals"},{"line":173,"kind":12,"containerName":"equals","name":"order"}],"containerName":"main::","definition":"sub","detail":"($self,$compare)","signature":{"label":"equals($self,$compare)","parameters":[{"label":"$self"},{"label":"$compare"}],"documentation":"1;\n# BioPerl module for Bio::Map::OrderedPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::OrderedPosition - Abstracts the notion of a member\n\tof an ordered list of markers. Each marker is a certain distance\n\tfrom the one in the ordered list before it.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::OrderedPosition;\n\t# the first marker in the sequence\n    my $position = Bio::Map::OrderedPosition->new(-order => 1,\n\t\t\t-positions => [ [ $map, 22.3] ] );\n\t# the second marker in the sequence, 15.6 units from the fist one\n    my $position2 = Bio::Map::OrderedPosition->new(-order => 2,\n\t\t\t-positions => [ [ $map, 37.9] ] );\n\t# the third marker in the sequence, coincidental with the second\n\t# marker\n    my $position3 = Bio::Map::OrderedPosition->new(-order => 3,\n                        -posititions => [ [ $map, 37.9]] );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface and the\nPosition object handles the specific values of a position.\nOrderedPosition is intended to be slightly more specific then Position\nbut only specific enough for a parser from the MarkerIO subsystem to\ncreate and then pass to a client application to bless into the proper\ntype. For an example of how this is intended to work, see the\nMapmaker.pm.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in.\n\nSe Bio::Map::Position for additional information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nJason Stajich, jason@bioperl.org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::OrderedPosition;\nuse strict;\n\n\nuse base qw(Bio::Map::Position);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::OrderedPosition->new();\n Function: Builds a new Bio::Map::OrderedPosition object \n Returns : Bio::Map::OrderedPosition\n Args    : -order : The order of this position\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($order) = $self->_rearrange([qw(ORDER)], @args);\n    $order && $self->order($order);\n    \n    return $self;\n}\n\n=head2 order\n\n Title   : order\n Usage   : $o_position->order($new_order);\n           my $order = $o_position->order();\n Function: Get/set the order position of this position in a map.\n Returns : int, the order of this position\n Args    : none to get, OR int to set\n\n\nsub order {\n    my ($self, $order) = @_;\n    if ($order) {\n        $self->{'_order'} = $order;\n    }\n    return $self->{'_order'} || return;\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    return $self->order;\n}\n\n=head2 equals\n\n Title   : equals\n Usage   : if ($mappable->equals($mapable2)) {...}\n Function: Test if a position is equal to another position.\n Returns : boolean\n Args    : Bio::Map::PositionI"},"name":"equals","range":{"start":{"line":170,"character":0},"end":{"line":174,"character":9999}}},{"signature":{"label":"less_than($self,$compare)","parameters":[{"label":"$self"},{"label":"$compare"}],"documentation":"1;\n# BioPerl module for Bio::Map::OrderedPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::OrderedPosition - Abstracts the notion of a member\n\tof an ordered list of markers. Each marker is a certain distance\n\tfrom the one in the ordered list before it.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::OrderedPosition;\n\t# the first marker in the sequence\n    my $position = Bio::Map::OrderedPosition->new(-order => 1,\n\t\t\t-positions => [ [ $map, 22.3] ] );\n\t# the second marker in the sequence, 15.6 units from the fist one\n    my $position2 = Bio::Map::OrderedPosition->new(-order => 2,\n\t\t\t-positions => [ [ $map, 37.9] ] );\n\t# the third marker in the sequence, coincidental with the second\n\t# marker\n    my $position3 = Bio::Map::OrderedPosition->new(-order => 3,\n                        -posititions => [ [ $map, 37.9]] );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface and the\nPosition object handles the specific values of a position.\nOrderedPosition is intended to be slightly more specific then Position\nbut only specific enough for a parser from the MarkerIO subsystem to\ncreate and then pass to a client application to bless into the proper\ntype. For an example of how this is intended to work, see the\nMapmaker.pm.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in.\n\nSe Bio::Map::Position for additional information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nJason Stajich, jason@bioperl.org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::OrderedPosition;\nuse strict;\n\n\nuse base qw(Bio::Map::Position);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::OrderedPosition->new();\n Function: Builds a new Bio::Map::OrderedPosition object \n Returns : Bio::Map::OrderedPosition\n Args    : -order : The order of this position\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($order) = $self->_rearrange([qw(ORDER)], @args);\n    $order && $self->order($order);\n    \n    return $self;\n}\n\n=head2 order\n\n Title   : order\n Usage   : $o_position->order($new_order);\n           my $order = $o_position->order();\n Function: Get/set the order position of this position in a map.\n Returns : int, the order of this position\n Args    : none to get, OR int to set\n\n\nsub order {\n    my ($self, $order) = @_;\n    if ($order) {\n        $self->{'_order'} = $order;\n    }\n    return $self->{'_order'} || return;\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    return $self->order;\n}\n\n=head2 equals\n\n Title   : equals\n Usage   : if ($mappable->equals($mapable2)) {...}\n Function: Test if a position is equal to another position.\n Returns : boolean\n Args    : Bio::Map::PositionI\n\n\nsub equals {\n   my ($self,$compare) = @_;\n   return 0 if (! defined $compare || ! $compare->isa('Bio::Map::OrderedPosition'));\n   return ($compare->order == $self->order);\n}\n\n# admittedly these aren't really the best comparisons in the world\n# but it is a first pass we'll need to refine the algorithm or not \n# provide general comparisions and require these to be implemented\n# by objects closer to the specific type of data\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($mappable->less_than($m2)) {...}\n Function: Tests if a position is less than another position\n           It is assumed that 2 positions are in the same map.\n Returns : boolean\n Args    : Bio::Map::PositionI"},"detail":"($self,$compare)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"less_than","line":193,"kind":13},{"containerName":"less_than","name":"$compare","kind":13,"line":193},{"containerName":"less_than","name":"$compare","line":194,"kind":13},{"line":194,"kind":13,"name":"$compare","containerName":"less_than"},{"kind":12,"line":194,"containerName":"less_than","name":"isa"},{"line":195,"kind":13,"name":"$compare","containerName":"less_than"},{"kind":12,"line":195,"containerName":"less_than","name":"order"},{"name":"$self","containerName":"less_than","line":195,"kind":13},{"containerName":"less_than","name":"order","kind":12,"line":195}],"line":192,"kind":12,"range":{"end":{"character":9999,"line":196},"start":{"character":0,"line":192}},"name":"less_than"},{"line":209,"children":[{"localvar":"my","containerName":"greater_than","name":"$self","definition":"my","line":210,"kind":13},{"line":210,"kind":13,"name":"$compare","containerName":"greater_than"},{"name":"$compare","containerName":"greater_than","line":211,"kind":13},{"line":211,"kind":13,"containerName":"greater_than","name":"$compare"},{"containerName":"greater_than","name":"isa","line":211,"kind":12},{"kind":13,"line":212,"containerName":"greater_than","name":"$compare"},{"containerName":"greater_than","name":"order","kind":12,"line":212},{"line":212,"kind":13,"name":"$self","containerName":"greater_than"},{"kind":12,"line":212,"containerName":"greater_than","name":"order"}],"kind":12,"detail":"($self,$compare)","signature":{"label":"greater_than($self,$compare)","documentation":"1;\n# BioPerl module for Bio::Map::OrderedPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::OrderedPosition - Abstracts the notion of a member\n\tof an ordered list of markers. Each marker is a certain distance\n\tfrom the one in the ordered list before it.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::OrderedPosition;\n\t# the first marker in the sequence\n    my $position = Bio::Map::OrderedPosition->new(-order => 1,\n\t\t\t-positions => [ [ $map, 22.3] ] );\n\t# the second marker in the sequence, 15.6 units from the fist one\n    my $position2 = Bio::Map::OrderedPosition->new(-order => 2,\n\t\t\t-positions => [ [ $map, 37.9] ] );\n\t# the third marker in the sequence, coincidental with the second\n\t# marker\n    my $position3 = Bio::Map::OrderedPosition->new(-order => 3,\n                        -posititions => [ [ $map, 37.9]] );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface and the\nPosition object handles the specific values of a position.\nOrderedPosition is intended to be slightly more specific then Position\nbut only specific enough for a parser from the MarkerIO subsystem to\ncreate and then pass to a client application to bless into the proper\ntype. For an example of how this is intended to work, see the\nMapmaker.pm.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in.\n\nSe Bio::Map::Position for additional information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nJason Stajich, jason@bioperl.org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::OrderedPosition;\nuse strict;\n\n\nuse base qw(Bio::Map::Position);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::OrderedPosition->new();\n Function: Builds a new Bio::Map::OrderedPosition object \n Returns : Bio::Map::OrderedPosition\n Args    : -order : The order of this position\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($order) = $self->_rearrange([qw(ORDER)], @args);\n    $order && $self->order($order);\n    \n    return $self;\n}\n\n=head2 order\n\n Title   : order\n Usage   : $o_position->order($new_order);\n           my $order = $o_position->order();\n Function: Get/set the order position of this position in a map.\n Returns : int, the order of this position\n Args    : none to get, OR int to set\n\n\nsub order {\n    my ($self, $order) = @_;\n    if ($order) {\n        $self->{'_order'} = $order;\n    }\n    return $self->{'_order'} || return;\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    return $self->order;\n}\n\n=head2 equals\n\n Title   : equals\n Usage   : if ($mappable->equals($mapable2)) {...}\n Function: Test if a position is equal to another position.\n Returns : boolean\n Args    : Bio::Map::PositionI\n\n\nsub equals {\n   my ($self,$compare) = @_;\n   return 0 if (! defined $compare || ! $compare->isa('Bio::Map::OrderedPosition'));\n   return ($compare->order == $self->order);\n}\n\n# admittedly these aren't really the best comparisons in the world\n# but it is a first pass we'll need to refine the algorithm or not \n# provide general comparisions and require these to be implemented\n# by objects closer to the specific type of data\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($mappable->less_than($m2)) {...}\n Function: Tests if a position is less than another position\n           It is assumed that 2 positions are in the same map.\n Returns : boolean\n Args    : Bio::Map::PositionI\n\n\nsub less_than {\n   my ($self,$compare) = @_;\n   return 0 if (! defined $compare || ! $compare->isa('Bio::Map::OrderedPosition'));\n   return ($compare->order < $self->order);\n}\n\n=head2 greater_than\n\n Title   : greater_than\n Usage   : if ($mappable->greater_than($m2)) {...}\n Function: Tests if position is greater than another position.\n           It is assumed that 2 positions are in the same map.\n Returns : boolean\n Args    : Bio::Map::PositionI","parameters":[{"label":"$self"},{"label":"$compare"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":209},"end":{"character":9999,"line":213}},"name":"greater_than"}]}