{"version":5,"vars":[{"containerName":"","name":"base","line":92,"kind":2},{"name":"new","range":{"start":{"line":126,"character":0},"end":{"line":147,"character":9999}},"kind":12,"children":[{"line":127,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$class"},{"containerName":"new","name":"@args","line":127,"kind":13},{"kind":13,"line":128,"containerName":"new","definition":"my","name":"$self","localvar":"my"},{"name":"$class","containerName":"new","kind":13,"line":128},{"kind":13,"line":128,"name":"@args","containerName":"new"},{"line":129,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$map"},{"name":"$position","containerName":"new","kind":13,"line":129},{"line":129,"kind":13,"name":"$sequence","containerName":"new"},{"name":"$motif","containerName":"new","kind":13,"line":129},{"name":"$repeats","containerName":"new","line":129,"kind":13},{"line":129,"kind":13,"containerName":"new","name":"$start"},{"name":"$self","containerName":"new","line":130,"kind":13},{"containerName":"new","name":"_rearrange","line":130,"kind":12},{"containerName":"new","name":"@args","line":136,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":137},{"kind":12,"line":137,"name":"name","containerName":"new"},{"kind":13,"line":138,"name":"$self","containerName":"new"},{"containerName":"new","name":"name","line":138,"kind":12},{"kind":13,"line":140,"name":"$map","containerName":"new"},{"kind":13,"line":140,"name":"$self","containerName":"new"},{"kind":12,"line":140,"name":"map","containerName":"new"},{"containerName":"new","name":"$map","kind":13,"line":140},{"containerName":"new","name":"$position","line":141,"kind":13},{"name":"$self","containerName":"new","line":141,"kind":13},{"line":141,"kind":12,"containerName":"new","name":"position"},{"containerName":"new","name":"$position","kind":13,"line":141},{"line":142,"kind":13,"name":"$sequence","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":142},{"kind":12,"line":142,"name":"sequence","containerName":"new"},{"kind":13,"line":142,"containerName":"new","name":"$sequence"},{"containerName":"new","name":"$self","kind":13,"line":143},{"containerName":"new","name":"motif","line":143,"kind":12},{"name":"$motif","containerName":"new","kind":13,"line":143},{"kind":13,"line":143,"containerName":"new","name":"$motif"},{"name":"$repeats","containerName":"new","kind":13,"line":144},{"containerName":"new","name":"$self","line":144,"kind":13},{"kind":12,"line":144,"name":"repeats","containerName":"new"},{"name":"$repeats","containerName":"new","line":144,"kind":13},{"line":145,"kind":13,"name":"$start","containerName":"new"},{"line":145,"kind":13,"containerName":"new","name":"$self"},{"line":145,"kind":12,"containerName":"new","name":"repeat_start_position"},{"containerName":"new","name":"$start","line":145,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":146}],"line":126,"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","documentation":"1;\n# BioPerl module for Bio::Map::Microsatellite\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Microsatellite - An object representing a Microsatellite marker.\n\n=head1 SYNOPSIS\n\n  $o_usat = Bio::Map::Microsatellite->new\n      (-name=>'Chad Super Marker 2',\n       -sequence => 'gctgactgatcatatatatatatatatatatatatatatatcgcgatcgtga',\n       -motif => 'at',\n       -repeats => 15,\n       -repeat_start_position => 11\n       );\n\n  $sequence_before_usat = $o_usat->get_leading_flank();\n  $sequence_after_usat = $o_usat->get_trailing_flank();\n\n\n=head1 DESCRIPTION\n\nThis object handles the notion of an Microsatellite. This microsatellite can\nbe placed on a (linear) Map or used on its own.  If this Microsatellites\nwill be used in a mapping context (it doesn't have to, you know) it can have\nmultiple positions in a map. For information about a Microsatellite's position\nin a map one must query the associate PositionI object which is accessible\nthrough the position() method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Microsatellite;\nuse strict;\n\nuse base qw(Bio::Map::Marker);\n\n=head2 new\n\n Title   : new\n Usage   : $o_usat = \n Function: Builds a new Bio::Map::Microsatellite object\n Returns : Bio::Map::Microsatellite\n Args    :\n\t-name    => name of this microsatellite (optional, string,\n\t\tdefault 'Unknown microsatellite')\n        -positions => position(s) for this marker in maps[optional],\n                An array reference of tuples (array refs themselves)\n                Each tuple conatins a Bio::Map::MapI-inherited object and a \n\t\tBio::Map::PositionI-inherited obj, no default)\n\t-sequence => the sequence of this microsatellite (optional,\n\t\t scalar, no default)\n\t-motif => the repeat motif of this microsatellite (optional,\n\t\t scalar, no default)\n\t-repeats => the number of motif repeats for this microsatellite\n\t\t(optional, scalar, no default)\n\t-repeat_start_position => the starting position of the\n\t\tmicrosatellite in this sequence. The first base of the\n\t\tsequence is position \"1\". (optional, scalar, no default)\n\n Note    : Creating a Bio::Map::Microsatellite object with no position\n\tmight be useful for microsatellite people wanting to embrace\n\tand extend this module. <raising hand> Me! Me! Me!\n\t- using repeat_start_position will trigger a mechinism to\n\tcalculate a value for repeat_end_position. ","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)"},{"name":"SUPER","containerName":"new","line":128,"kind":12},{"name":"motif","range":{"start":{"line":161,"character":0},"end":{"line":167,"character":9999}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$motif"}],"documentation":"1;\n# BioPerl module for Bio::Map::Microsatellite\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Microsatellite - An object representing a Microsatellite marker.\n\n=head1 SYNOPSIS\n\n  $o_usat = Bio::Map::Microsatellite->new\n      (-name=>'Chad Super Marker 2',\n       -sequence => 'gctgactgatcatatatatatatatatatatatatatatatcgcgatcgtga',\n       -motif => 'at',\n       -repeats => 15,\n       -repeat_start_position => 11\n       );\n\n  $sequence_before_usat = $o_usat->get_leading_flank();\n  $sequence_after_usat = $o_usat->get_trailing_flank();\n\n\n=head1 DESCRIPTION\n\nThis object handles the notion of an Microsatellite. This microsatellite can\nbe placed on a (linear) Map or used on its own.  If this Microsatellites\nwill be used in a mapping context (it doesn't have to, you know) it can have\nmultiple positions in a map. For information about a Microsatellite's position\nin a map one must query the associate PositionI object which is accessible\nthrough the position() method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Microsatellite;\nuse strict;\n\nuse base qw(Bio::Map::Marker);\n\n=head2 new\n\n Title   : new\n Usage   : $o_usat = \n Function: Builds a new Bio::Map::Microsatellite object\n Returns : Bio::Map::Microsatellite\n Args    :\n\t-name    => name of this microsatellite (optional, string,\n\t\tdefault 'Unknown microsatellite')\n        -positions => position(s) for this marker in maps[optional],\n                An array reference of tuples (array refs themselves)\n                Each tuple conatins a Bio::Map::MapI-inherited object and a \n\t\tBio::Map::PositionI-inherited obj, no default)\n\t-sequence => the sequence of this microsatellite (optional,\n\t\t scalar, no default)\n\t-motif => the repeat motif of this microsatellite (optional,\n\t\t scalar, no default)\n\t-repeats => the number of motif repeats for this microsatellite\n\t\t(optional, scalar, no default)\n\t-repeat_start_position => the starting position of the\n\t\tmicrosatellite in this sequence. The first base of the\n\t\tsequence is position \"1\". (optional, scalar, no default)\n\n Note    : Creating a Bio::Map::Microsatellite object with no position\n\tmight be useful for microsatellite people wanting to embrace\n\tand extend this module. <raising hand> Me! Me! Me!\n\t- using repeat_start_position will trigger a mechinism to\n\tcalculate a value for repeat_end_position. \n\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($map, $position, $sequence, $motif, $repeats, $start) = \n\t$self->_rearrange([qw(MAP\n\t\t\t      POSITION\n\t\t\t      SEQUENCE \n\t\t\t      MOTIF \n\t\t\t      REPEATS \n\t\t\t      REPEAT_START_POSITION\n\t\t\t      )], @args);\n    if( ! $self->name ) { \n\t$self->name('Unnamed microsatellite');\n    }\n    $map && $self->map($map);\n    $position && $self->position($position);\n    $sequence && $self->sequence($sequence);\n    $self->motif(defined $motif ? $motif : 'Unknown motif'); \n    $repeats && $self->repeats($repeats);\n    $start && $self->repeat_start_position($start);\n    return $self;\n}\n\n=head2 motif\n\n Title   : motif\n Usage   : $o_usat->motif($new_motif);\n\t       my $motif = $o_usat->motif();\n Function: Get/Set the repeat motif for this Microsatellite.\n Returns : A scalar representing the current repeat motif of this\n\t       Microsatellite.\n Args    : none to get, OR string to set","label":"motif($self,$motif)"},"detail":"($self,$motif)","kind":12,"children":[{"line":162,"kind":13,"localvar":"my","containerName":"motif","name":"$self","definition":"my"},{"containerName":"motif","name":"$motif","kind":13,"line":162},{"line":163,"kind":13,"name":"$motif","containerName":"motif"},{"kind":13,"line":164,"containerName":"motif","name":"$self"},{"name":"$motif","containerName":"motif","line":164,"kind":13},{"containerName":"motif","name":"$self","line":166,"kind":13}],"line":161},{"kind":12,"children":[{"line":182,"kind":13,"localvar":"my","containerName":"sequence","name":"$self","definition":"my"},{"containerName":"sequence","name":"$sequence","line":182,"kind":13},{"name":"$sequence","containerName":"sequence","kind":13,"line":183},{"containerName":"sequence","name":"$self","line":184,"kind":13},{"kind":13,"line":184,"containerName":"sequence","name":"$sequence"},{"line":186,"kind":13,"containerName":"sequence","name":"$self"}],"line":181,"definition":"sub","containerName":"main::","signature":{"label":"sequence($self,$sequence)","parameters":[{"label":"$self"},{"label":"$sequence"}],"documentation":"1;\n# BioPerl module for Bio::Map::Microsatellite\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Microsatellite - An object representing a Microsatellite marker.\n\n=head1 SYNOPSIS\n\n  $o_usat = Bio::Map::Microsatellite->new\n      (-name=>'Chad Super Marker 2',\n       -sequence => 'gctgactgatcatatatatatatatatatatatatatatatcgcgatcgtga',\n       -motif => 'at',\n       -repeats => 15,\n       -repeat_start_position => 11\n       );\n\n  $sequence_before_usat = $o_usat->get_leading_flank();\n  $sequence_after_usat = $o_usat->get_trailing_flank();\n\n\n=head1 DESCRIPTION\n\nThis object handles the notion of an Microsatellite. This microsatellite can\nbe placed on a (linear) Map or used on its own.  If this Microsatellites\nwill be used in a mapping context (it doesn't have to, you know) it can have\nmultiple positions in a map. For information about a Microsatellite's position\nin a map one must query the associate PositionI object which is accessible\nthrough the position() method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Microsatellite;\nuse strict;\n\nuse base qw(Bio::Map::Marker);\n\n=head2 new\n\n Title   : new\n Usage   : $o_usat = \n Function: Builds a new Bio::Map::Microsatellite object\n Returns : Bio::Map::Microsatellite\n Args    :\n\t-name    => name of this microsatellite (optional, string,\n\t\tdefault 'Unknown microsatellite')\n        -positions => position(s) for this marker in maps[optional],\n                An array reference of tuples (array refs themselves)\n                Each tuple conatins a Bio::Map::MapI-inherited object and a \n\t\tBio::Map::PositionI-inherited obj, no default)\n\t-sequence => the sequence of this microsatellite (optional,\n\t\t scalar, no default)\n\t-motif => the repeat motif of this microsatellite (optional,\n\t\t scalar, no default)\n\t-repeats => the number of motif repeats for this microsatellite\n\t\t(optional, scalar, no default)\n\t-repeat_start_position => the starting position of the\n\t\tmicrosatellite in this sequence. The first base of the\n\t\tsequence is position \"1\". (optional, scalar, no default)\n\n Note    : Creating a Bio::Map::Microsatellite object with no position\n\tmight be useful for microsatellite people wanting to embrace\n\tand extend this module. <raising hand> Me! Me! Me!\n\t- using repeat_start_position will trigger a mechinism to\n\tcalculate a value for repeat_end_position. \n\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($map, $position, $sequence, $motif, $repeats, $start) = \n\t$self->_rearrange([qw(MAP\n\t\t\t      POSITION\n\t\t\t      SEQUENCE \n\t\t\t      MOTIF \n\t\t\t      REPEATS \n\t\t\t      REPEAT_START_POSITION\n\t\t\t      )], @args);\n    if( ! $self->name ) { \n\t$self->name('Unnamed microsatellite');\n    }\n    $map && $self->map($map);\n    $position && $self->position($position);\n    $sequence && $self->sequence($sequence);\n    $self->motif(defined $motif ? $motif : 'Unknown motif'); \n    $repeats && $self->repeats($repeats);\n    $start && $self->repeat_start_position($start);\n    return $self;\n}\n\n=head2 motif\n\n Title   : motif\n Usage   : $o_usat->motif($new_motif);\n\t       my $motif = $o_usat->motif();\n Function: Get/Set the repeat motif for this Microsatellite.\n Returns : A scalar representing the current repeat motif of this\n\t       Microsatellite.\n Args    : none to get, OR string to set\n\n\nsub motif {\n\tmy ($self,$motif) = @_;\n\tif ($motif) {\n\t\t$self->{'_motif'} = $motif;\n\t}\n\treturn $self->{'_motif'};\t\n}\n\n=head2 sequence\n\n Title   : sequence\n Usage   : $o_usat->sequence($new_sequence);\n\t       my $sequence = $o_usat->sequence();\n Function: Get/Set the sequence for this Microsatellite.\n Returns : A scalar representing the current sequence of this\n\t       Microsatellite.\n Args    : none to get, OR string to set"},"detail":"($self,$sequence)","name":"sequence","range":{"end":{"character":9999,"line":187},"start":{"character":0,"line":181}}},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"repeats","localvar":"my","kind":13,"line":202},{"line":202,"kind":13,"name":"$repeats","containerName":"repeats"},{"line":203,"kind":13,"containerName":"repeats","name":"$repeats"},{"kind":13,"line":204,"name":"$self","containerName":"repeats"},{"kind":13,"line":204,"containerName":"repeats","name":"$repeats"},{"containerName":"repeats","name":"$self","line":206,"kind":13}],"line":201,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$repeats"}],"documentation":"1;\n# BioPerl module for Bio::Map::Microsatellite\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Microsatellite - An object representing a Microsatellite marker.\n\n=head1 SYNOPSIS\n\n  $o_usat = Bio::Map::Microsatellite->new\n      (-name=>'Chad Super Marker 2',\n       -sequence => 'gctgactgatcatatatatatatatatatatatatatatatcgcgatcgtga',\n       -motif => 'at',\n       -repeats => 15,\n       -repeat_start_position => 11\n       );\n\n  $sequence_before_usat = $o_usat->get_leading_flank();\n  $sequence_after_usat = $o_usat->get_trailing_flank();\n\n\n=head1 DESCRIPTION\n\nThis object handles the notion of an Microsatellite. This microsatellite can\nbe placed on a (linear) Map or used on its own.  If this Microsatellites\nwill be used in a mapping context (it doesn't have to, you know) it can have\nmultiple positions in a map. For information about a Microsatellite's position\nin a map one must query the associate PositionI object which is accessible\nthrough the position() method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Microsatellite;\nuse strict;\n\nuse base qw(Bio::Map::Marker);\n\n=head2 new\n\n Title   : new\n Usage   : $o_usat = \n Function: Builds a new Bio::Map::Microsatellite object\n Returns : Bio::Map::Microsatellite\n Args    :\n\t-name    => name of this microsatellite (optional, string,\n\t\tdefault 'Unknown microsatellite')\n        -positions => position(s) for this marker in maps[optional],\n                An array reference of tuples (array refs themselves)\n                Each tuple conatins a Bio::Map::MapI-inherited object and a \n\t\tBio::Map::PositionI-inherited obj, no default)\n\t-sequence => the sequence of this microsatellite (optional,\n\t\t scalar, no default)\n\t-motif => the repeat motif of this microsatellite (optional,\n\t\t scalar, no default)\n\t-repeats => the number of motif repeats for this microsatellite\n\t\t(optional, scalar, no default)\n\t-repeat_start_position => the starting position of the\n\t\tmicrosatellite in this sequence. The first base of the\n\t\tsequence is position \"1\". (optional, scalar, no default)\n\n Note    : Creating a Bio::Map::Microsatellite object with no position\n\tmight be useful for microsatellite people wanting to embrace\n\tand extend this module. <raising hand> Me! Me! Me!\n\t- using repeat_start_position will trigger a mechinism to\n\tcalculate a value for repeat_end_position. \n\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($map, $position, $sequence, $motif, $repeats, $start) = \n\t$self->_rearrange([qw(MAP\n\t\t\t      POSITION\n\t\t\t      SEQUENCE \n\t\t\t      MOTIF \n\t\t\t      REPEATS \n\t\t\t      REPEAT_START_POSITION\n\t\t\t      )], @args);\n    if( ! $self->name ) { \n\t$self->name('Unnamed microsatellite');\n    }\n    $map && $self->map($map);\n    $position && $self->position($position);\n    $sequence && $self->sequence($sequence);\n    $self->motif(defined $motif ? $motif : 'Unknown motif'); \n    $repeats && $self->repeats($repeats);\n    $start && $self->repeat_start_position($start);\n    return $self;\n}\n\n=head2 motif\n\n Title   : motif\n Usage   : $o_usat->motif($new_motif);\n\t       my $motif = $o_usat->motif();\n Function: Get/Set the repeat motif for this Microsatellite.\n Returns : A scalar representing the current repeat motif of this\n\t       Microsatellite.\n Args    : none to get, OR string to set\n\n\nsub motif {\n\tmy ($self,$motif) = @_;\n\tif ($motif) {\n\t\t$self->{'_motif'} = $motif;\n\t}\n\treturn $self->{'_motif'};\t\n}\n\n=head2 sequence\n\n Title   : sequence\n Usage   : $o_usat->sequence($new_sequence);\n\t       my $sequence = $o_usat->sequence();\n Function: Get/Set the sequence for this Microsatellite.\n Returns : A scalar representing the current sequence of this\n\t       Microsatellite.\n Args    : none to get, OR string to set\n\n\nsub sequence {\n\tmy ($self,$sequence) = @_;\n\tif ($sequence) {\n\t\t$self->{'_sequence'} = $sequence;\n\t}\n\treturn $self->{'_sequence'};\t\n}\n\n=head2 repeats\n\n Title   : repeats\n Usage   : $o_usat->repeats($new_repeats);\n\t       my $repeats = $o_usat->repeats()\n Function: Get/Set the repeat repeats for this Microsatellite.\n Returns : A scalar representing the current number of repeats of this\n\t       Microsatellite.\n Args    : none to get, OR int to set","label":"repeats($self,$repeats)"},"detail":"($self,$repeats)","name":"repeats","range":{"start":{"line":201,"character":0},"end":{"line":207,"character":9999}}},{"children":[{"line":227,"kind":13,"localvar":"my","containerName":"repeat_start_position","name":"$self","definition":"my"},{"line":227,"kind":13,"containerName":"repeat_start_position","name":"$repeat_start_position"},{"kind":13,"line":228,"containerName":"repeat_start_position","name":"$repeat_start_position"},{"containerName":"repeat_start_position","name":"$self","line":229,"kind":13},{"line":229,"kind":13,"containerName":"repeat_start_position","name":"$repeat_start_position"},{"containerName":"repeat_start_position","name":"$self","kind":13,"line":230},{"containerName":"repeat_start_position","name":"repeat_end_position","line":230,"kind":12},{"name":"$self","containerName":"repeat_start_position","kind":13,"line":232}],"line":226,"kind":12,"signature":{"label":"repeat_start_position($self,$repeat_start_position)","parameters":[{"label":"$self"},{"label":"$repeat_start_position"}],"documentation":"1;\n# BioPerl module for Bio::Map::Microsatellite\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Microsatellite - An object representing a Microsatellite marker.\n\n=head1 SYNOPSIS\n\n  $o_usat = Bio::Map::Microsatellite->new\n      (-name=>'Chad Super Marker 2',\n       -sequence => 'gctgactgatcatatatatatatatatatatatatatatatcgcgatcgtga',\n       -motif => 'at',\n       -repeats => 15,\n       -repeat_start_position => 11\n       );\n\n  $sequence_before_usat = $o_usat->get_leading_flank();\n  $sequence_after_usat = $o_usat->get_trailing_flank();\n\n\n=head1 DESCRIPTION\n\nThis object handles the notion of an Microsatellite. This microsatellite can\nbe placed on a (linear) Map or used on its own.  If this Microsatellites\nwill be used in a mapping context (it doesn't have to, you know) it can have\nmultiple positions in a map. For information about a Microsatellite's position\nin a map one must query the associate PositionI object which is accessible\nthrough the position() method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Microsatellite;\nuse strict;\n\nuse base qw(Bio::Map::Marker);\n\n=head2 new\n\n Title   : new\n Usage   : $o_usat = \n Function: Builds a new Bio::Map::Microsatellite object\n Returns : Bio::Map::Microsatellite\n Args    :\n\t-name    => name of this microsatellite (optional, string,\n\t\tdefault 'Unknown microsatellite')\n        -positions => position(s) for this marker in maps[optional],\n                An array reference of tuples (array refs themselves)\n                Each tuple conatins a Bio::Map::MapI-inherited object and a \n\t\tBio::Map::PositionI-inherited obj, no default)\n\t-sequence => the sequence of this microsatellite (optional,\n\t\t scalar, no default)\n\t-motif => the repeat motif of this microsatellite (optional,\n\t\t scalar, no default)\n\t-repeats => the number of motif repeats for this microsatellite\n\t\t(optional, scalar, no default)\n\t-repeat_start_position => the starting position of the\n\t\tmicrosatellite in this sequence. The first base of the\n\t\tsequence is position \"1\". (optional, scalar, no default)\n\n Note    : Creating a Bio::Map::Microsatellite object with no position\n\tmight be useful for microsatellite people wanting to embrace\n\tand extend this module. <raising hand> Me! Me! Me!\n\t- using repeat_start_position will trigger a mechinism to\n\tcalculate a value for repeat_end_position. \n\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($map, $position, $sequence, $motif, $repeats, $start) = \n\t$self->_rearrange([qw(MAP\n\t\t\t      POSITION\n\t\t\t      SEQUENCE \n\t\t\t      MOTIF \n\t\t\t      REPEATS \n\t\t\t      REPEAT_START_POSITION\n\t\t\t      )], @args);\n    if( ! $self->name ) { \n\t$self->name('Unnamed microsatellite');\n    }\n    $map && $self->map($map);\n    $position && $self->position($position);\n    $sequence && $self->sequence($sequence);\n    $self->motif(defined $motif ? $motif : 'Unknown motif'); \n    $repeats && $self->repeats($repeats);\n    $start && $self->repeat_start_position($start);\n    return $self;\n}\n\n=head2 motif\n\n Title   : motif\n Usage   : $o_usat->motif($new_motif);\n\t       my $motif = $o_usat->motif();\n Function: Get/Set the repeat motif for this Microsatellite.\n Returns : A scalar representing the current repeat motif of this\n\t       Microsatellite.\n Args    : none to get, OR string to set\n\n\nsub motif {\n\tmy ($self,$motif) = @_;\n\tif ($motif) {\n\t\t$self->{'_motif'} = $motif;\n\t}\n\treturn $self->{'_motif'};\t\n}\n\n=head2 sequence\n\n Title   : sequence\n Usage   : $o_usat->sequence($new_sequence);\n\t       my $sequence = $o_usat->sequence();\n Function: Get/Set the sequence for this Microsatellite.\n Returns : A scalar representing the current sequence of this\n\t       Microsatellite.\n Args    : none to get, OR string to set\n\n\nsub sequence {\n\tmy ($self,$sequence) = @_;\n\tif ($sequence) {\n\t\t$self->{'_sequence'} = $sequence;\n\t}\n\treturn $self->{'_sequence'};\t\n}\n\n=head2 repeats\n\n Title   : repeats\n Usage   : $o_usat->repeats($new_repeats);\n\t       my $repeats = $o_usat->repeats()\n Function: Get/Set the repeat repeats for this Microsatellite.\n Returns : A scalar representing the current number of repeats of this\n\t       Microsatellite.\n Args    : none to get, OR int to set\n\n\nsub repeats {\n\tmy ($self,$repeats) = @_;\n\tif ($repeats) {\n\t\t$self->{'_repeats'} = $repeats;\n\t}\n\treturn $self->{'_repeats'};\t\n}\n\n=head2 repeat_start_position\n\n Title   : repeat_start_position\n Usage   : $o_usat->repeat_start_position($new_repeat_start_position);\n\t       my $repeat_start_position = $o_usat->repeat_start_position();\n Function: Get/Set the repeat repeat_start_position for this\n\t       Microsatellite\n Returns : A scalar representing the repeat start position for this \n\t       Microsatellite.\n Args    : none to get, OR string to set\n\t       This method will also try to set the repeat end position. This\n\t       depends on having information for the motif and the number of\n\t       repeats. If you want to use methods like get_trailing_flank or\n\t       get_leading flank, be careful to include the right information."},"detail":"($self,$repeat_start_position)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":226},"end":{"character":9999,"line":233}},"name":"repeat_start_position"},{"name":"repeat_end_position","range":{"start":{"line":259,"character":0},"end":{"line":272,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"repeat_end_position($self,$caller)","documentation":"1;\n# BioPerl module for Bio::Map::Microsatellite\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Microsatellite - An object representing a Microsatellite marker.\n\n=head1 SYNOPSIS\n\n  $o_usat = Bio::Map::Microsatellite->new\n      (-name=>'Chad Super Marker 2',\n       -sequence => 'gctgactgatcatatatatatatatatatatatatatatatcgcgatcgtga',\n       -motif => 'at',\n       -repeats => 15,\n       -repeat_start_position => 11\n       );\n\n  $sequence_before_usat = $o_usat->get_leading_flank();\n  $sequence_after_usat = $o_usat->get_trailing_flank();\n\n\n=head1 DESCRIPTION\n\nThis object handles the notion of an Microsatellite. This microsatellite can\nbe placed on a (linear) Map or used on its own.  If this Microsatellites\nwill be used in a mapping context (it doesn't have to, you know) it can have\nmultiple positions in a map. For information about a Microsatellite's position\nin a map one must query the associate PositionI object which is accessible\nthrough the position() method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Microsatellite;\nuse strict;\n\nuse base qw(Bio::Map::Marker);\n\n=head2 new\n\n Title   : new\n Usage   : $o_usat = \n Function: Builds a new Bio::Map::Microsatellite object\n Returns : Bio::Map::Microsatellite\n Args    :\n\t-name    => name of this microsatellite (optional, string,\n\t\tdefault 'Unknown microsatellite')\n        -positions => position(s) for this marker in maps[optional],\n                An array reference of tuples (array refs themselves)\n                Each tuple conatins a Bio::Map::MapI-inherited object and a \n\t\tBio::Map::PositionI-inherited obj, no default)\n\t-sequence => the sequence of this microsatellite (optional,\n\t\t scalar, no default)\n\t-motif => the repeat motif of this microsatellite (optional,\n\t\t scalar, no default)\n\t-repeats => the number of motif repeats for this microsatellite\n\t\t(optional, scalar, no default)\n\t-repeat_start_position => the starting position of the\n\t\tmicrosatellite in this sequence. The first base of the\n\t\tsequence is position \"1\". (optional, scalar, no default)\n\n Note    : Creating a Bio::Map::Microsatellite object with no position\n\tmight be useful for microsatellite people wanting to embrace\n\tand extend this module. <raising hand> Me! Me! Me!\n\t- using repeat_start_position will trigger a mechinism to\n\tcalculate a value for repeat_end_position. \n\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($map, $position, $sequence, $motif, $repeats, $start) = \n\t$self->_rearrange([qw(MAP\n\t\t\t      POSITION\n\t\t\t      SEQUENCE \n\t\t\t      MOTIF \n\t\t\t      REPEATS \n\t\t\t      REPEAT_START_POSITION\n\t\t\t      )], @args);\n    if( ! $self->name ) { \n\t$self->name('Unnamed microsatellite');\n    }\n    $map && $self->map($map);\n    $position && $self->position($position);\n    $sequence && $self->sequence($sequence);\n    $self->motif(defined $motif ? $motif : 'Unknown motif'); \n    $repeats && $self->repeats($repeats);\n    $start && $self->repeat_start_position($start);\n    return $self;\n}\n\n=head2 motif\n\n Title   : motif\n Usage   : $o_usat->motif($new_motif);\n\t       my $motif = $o_usat->motif();\n Function: Get/Set the repeat motif for this Microsatellite.\n Returns : A scalar representing the current repeat motif of this\n\t       Microsatellite.\n Args    : none to get, OR string to set\n\n\nsub motif {\n\tmy ($self,$motif) = @_;\n\tif ($motif) {\n\t\t$self->{'_motif'} = $motif;\n\t}\n\treturn $self->{'_motif'};\t\n}\n\n=head2 sequence\n\n Title   : sequence\n Usage   : $o_usat->sequence($new_sequence);\n\t       my $sequence = $o_usat->sequence();\n Function: Get/Set the sequence for this Microsatellite.\n Returns : A scalar representing the current sequence of this\n\t       Microsatellite.\n Args    : none to get, OR string to set\n\n\nsub sequence {\n\tmy ($self,$sequence) = @_;\n\tif ($sequence) {\n\t\t$self->{'_sequence'} = $sequence;\n\t}\n\treturn $self->{'_sequence'};\t\n}\n\n=head2 repeats\n\n Title   : repeats\n Usage   : $o_usat->repeats($new_repeats);\n\t       my $repeats = $o_usat->repeats()\n Function: Get/Set the repeat repeats for this Microsatellite.\n Returns : A scalar representing the current number of repeats of this\n\t       Microsatellite.\n Args    : none to get, OR int to set\n\n\nsub repeats {\n\tmy ($self,$repeats) = @_;\n\tif ($repeats) {\n\t\t$self->{'_repeats'} = $repeats;\n\t}\n\treturn $self->{'_repeats'};\t\n}\n\n=head2 repeat_start_position\n\n Title   : repeat_start_position\n Usage   : $o_usat->repeat_start_position($new_repeat_start_position);\n\t       my $repeat_start_position = $o_usat->repeat_start_position();\n Function: Get/Set the repeat repeat_start_position for this\n\t       Microsatellite\n Returns : A scalar representing the repeat start position for this \n\t       Microsatellite.\n Args    : none to get, OR string to set\n\t       This method will also try to set the repeat end position. This\n\t       depends on having information for the motif and the number of\n\t       repeats. If you want to use methods like get_trailing_flank or\n\t       get_leading flank, be careful to include the right information.\n\n\nsub repeat_start_position {\n\tmy ($self,$repeat_start_position) = @_;\n\tif ($repeat_start_position) {\n\t\t$self->{'_repeat_start_position'} = $repeat_start_position;\n\t\t$self->repeat_end_position(\"set\");\n\t}\n\treturn $self->{'_repeat_start_position'};\t\n}\n\n=head2 repeat_end_position\n\n Title   : repeat_end_position\n Usage   : $o_usat->repeat_end_position(\"set\");\n\t       $o_usat->repeat_end_position($value);\n\t       $current_repeat_end_position = $o_usat->repeat_end_position();\n Function: Get/set the end position of the repeat in this sequence.\n Returns : A scalar representing the base index of the end of the\n\t       repeat in this Microsatellite. The first base in the sequence\n\t       is base 1.\n Args    : A scalar representing a value, the string \"set\", or no\n\t       argument (see Notes).\n Notes   : If you do not provide an argument to this method, the current\n           end position of the repeat in this Microsatellite will be\n           returned (a scalar).\n           If you provide the string \"set\" to this method it will set the\n           end position based on the start position, the length of the\n           motif, and the number of repeats.\n           If you specify a value the current end position of the repeat\n           will be set to that value. This is a really bad idea. Don't do\n           it.","parameters":[{"label":"$self"},{"label":"$caller"}]},"detail":"($self,$caller)","kind":12,"children":[{"kind":13,"line":260,"containerName":"repeat_end_position","name":"$self","definition":"my","localvar":"my"},{"line":260,"kind":13,"name":"$caller","containerName":"repeat_end_position"},{"kind":13,"line":261,"containerName":"repeat_end_position","name":"$caller"},{"name":"$caller","containerName":"repeat_end_position","kind":13,"line":262},{"kind":13,"line":263,"name":"$self","containerName":"repeat_end_position"},{"kind":13,"line":264,"containerName":"repeat_end_position","name":"$self"},{"line":265,"kind":13,"name":"$self","containerName":"repeat_end_position"},{"line":265,"kind":12,"name":"motif","containerName":"repeat_end_position"},{"kind":13,"line":265,"name":"$self","containerName":"repeat_end_position"},{"kind":12,"line":265,"containerName":"repeat_end_position","name":"repeats"},{"line":267,"kind":13,"name":"$caller","containerName":"repeat_end_position"},{"line":268,"kind":13,"containerName":"repeat_end_position","name":"$self"},{"line":268,"kind":13,"containerName":"repeat_end_position","name":"$caller"},{"kind":13,"line":271,"containerName":"repeat_end_position","name":"$self"}],"line":259},{"children":[{"containerName":"equals","name":"$self","definition":"my","localvar":"my","kind":13,"line":285},{"line":285,"kind":13,"name":"@args","containerName":"equals"},{"kind":13,"line":286,"containerName":"equals","name":"$self"},{"line":286,"kind":12,"name":"throw_not_implemented","containerName":"equals"}],"line":284,"kind":12,"signature":{"label":"equals($self,@args)","documentation":"1;\n# BioPerl module for Bio::Map::Microsatellite\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Microsatellite - An object representing a Microsatellite marker.\n\n=head1 SYNOPSIS\n\n  $o_usat = Bio::Map::Microsatellite->new\n      (-name=>'Chad Super Marker 2',\n       -sequence => 'gctgactgatcatatatatatatatatatatatatatatatcgcgatcgtga',\n       -motif => 'at',\n       -repeats => 15,\n       -repeat_start_position => 11\n       );\n\n  $sequence_before_usat = $o_usat->get_leading_flank();\n  $sequence_after_usat = $o_usat->get_trailing_flank();\n\n\n=head1 DESCRIPTION\n\nThis object handles the notion of an Microsatellite. This microsatellite can\nbe placed on a (linear) Map or used on its own.  If this Microsatellites\nwill be used in a mapping context (it doesn't have to, you know) it can have\nmultiple positions in a map. For information about a Microsatellite's position\nin a map one must query the associate PositionI object which is accessible\nthrough the position() method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Microsatellite;\nuse strict;\n\nuse base qw(Bio::Map::Marker);\n\n=head2 new\n\n Title   : new\n Usage   : $o_usat = \n Function: Builds a new Bio::Map::Microsatellite object\n Returns : Bio::Map::Microsatellite\n Args    :\n\t-name    => name of this microsatellite (optional, string,\n\t\tdefault 'Unknown microsatellite')\n        -positions => position(s) for this marker in maps[optional],\n                An array reference of tuples (array refs themselves)\n                Each tuple conatins a Bio::Map::MapI-inherited object and a \n\t\tBio::Map::PositionI-inherited obj, no default)\n\t-sequence => the sequence of this microsatellite (optional,\n\t\t scalar, no default)\n\t-motif => the repeat motif of this microsatellite (optional,\n\t\t scalar, no default)\n\t-repeats => the number of motif repeats for this microsatellite\n\t\t(optional, scalar, no default)\n\t-repeat_start_position => the starting position of the\n\t\tmicrosatellite in this sequence. The first base of the\n\t\tsequence is position \"1\". (optional, scalar, no default)\n\n Note    : Creating a Bio::Map::Microsatellite object with no position\n\tmight be useful for microsatellite people wanting to embrace\n\tand extend this module. <raising hand> Me! Me! Me!\n\t- using repeat_start_position will trigger a mechinism to\n\tcalculate a value for repeat_end_position. \n\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($map, $position, $sequence, $motif, $repeats, $start) = \n\t$self->_rearrange([qw(MAP\n\t\t\t      POSITION\n\t\t\t      SEQUENCE \n\t\t\t      MOTIF \n\t\t\t      REPEATS \n\t\t\t      REPEAT_START_POSITION\n\t\t\t      )], @args);\n    if( ! $self->name ) { \n\t$self->name('Unnamed microsatellite');\n    }\n    $map && $self->map($map);\n    $position && $self->position($position);\n    $sequence && $self->sequence($sequence);\n    $self->motif(defined $motif ? $motif : 'Unknown motif'); \n    $repeats && $self->repeats($repeats);\n    $start && $self->repeat_start_position($start);\n    return $self;\n}\n\n=head2 motif\n\n Title   : motif\n Usage   : $o_usat->motif($new_motif);\n\t       my $motif = $o_usat->motif();\n Function: Get/Set the repeat motif for this Microsatellite.\n Returns : A scalar representing the current repeat motif of this\n\t       Microsatellite.\n Args    : none to get, OR string to set\n\n\nsub motif {\n\tmy ($self,$motif) = @_;\n\tif ($motif) {\n\t\t$self->{'_motif'} = $motif;\n\t}\n\treturn $self->{'_motif'};\t\n}\n\n=head2 sequence\n\n Title   : sequence\n Usage   : $o_usat->sequence($new_sequence);\n\t       my $sequence = $o_usat->sequence();\n Function: Get/Set the sequence for this Microsatellite.\n Returns : A scalar representing the current sequence of this\n\t       Microsatellite.\n Args    : none to get, OR string to set\n\n\nsub sequence {\n\tmy ($self,$sequence) = @_;\n\tif ($sequence) {\n\t\t$self->{'_sequence'} = $sequence;\n\t}\n\treturn $self->{'_sequence'};\t\n}\n\n=head2 repeats\n\n Title   : repeats\n Usage   : $o_usat->repeats($new_repeats);\n\t       my $repeats = $o_usat->repeats()\n Function: Get/Set the repeat repeats for this Microsatellite.\n Returns : A scalar representing the current number of repeats of this\n\t       Microsatellite.\n Args    : none to get, OR int to set\n\n\nsub repeats {\n\tmy ($self,$repeats) = @_;\n\tif ($repeats) {\n\t\t$self->{'_repeats'} = $repeats;\n\t}\n\treturn $self->{'_repeats'};\t\n}\n\n=head2 repeat_start_position\n\n Title   : repeat_start_position\n Usage   : $o_usat->repeat_start_position($new_repeat_start_position);\n\t       my $repeat_start_position = $o_usat->repeat_start_position();\n Function: Get/Set the repeat repeat_start_position for this\n\t       Microsatellite\n Returns : A scalar representing the repeat start position for this \n\t       Microsatellite.\n Args    : none to get, OR string to set\n\t       This method will also try to set the repeat end position. This\n\t       depends on having information for the motif and the number of\n\t       repeats. If you want to use methods like get_trailing_flank or\n\t       get_leading flank, be careful to include the right information.\n\n\nsub repeat_start_position {\n\tmy ($self,$repeat_start_position) = @_;\n\tif ($repeat_start_position) {\n\t\t$self->{'_repeat_start_position'} = $repeat_start_position;\n\t\t$self->repeat_end_position(\"set\");\n\t}\n\treturn $self->{'_repeat_start_position'};\t\n}\n\n=head2 repeat_end_position\n\n Title   : repeat_end_position\n Usage   : $o_usat->repeat_end_position(\"set\");\n\t       $o_usat->repeat_end_position($value);\n\t       $current_repeat_end_position = $o_usat->repeat_end_position();\n Function: Get/set the end position of the repeat in this sequence.\n Returns : A scalar representing the base index of the end of the\n\t       repeat in this Microsatellite. The first base in the sequence\n\t       is base 1.\n Args    : A scalar representing a value, the string \"set\", or no\n\t       argument (see Notes).\n Notes   : If you do not provide an argument to this method, the current\n           end position of the repeat in this Microsatellite will be\n           returned (a scalar).\n           If you provide the string \"set\" to this method it will set the\n           end position based on the start position, the length of the\n           motif, and the number of repeats.\n           If you specify a value the current end position of the repeat\n           will be set to that value. This is a really bad idea. Don't do\n           it.\n\n\nsub repeat_end_position {\n    my ($self,$caller) = @_;\n    if( defined $caller ) { \n\tif ($caller eq \"set\") {\n\t    $self->{'_repeat_end_position'} = \n\t\t$self->{'_repeat_start_position'} + \n\t\t    (length($self->motif()) * $self->repeats());\n\t}\n\telsif ($caller) {\n\t    $self->{'_repeat_end_position'} = $caller;\n\t}\n    }\n    return $self->{'_repeat_end_position'};\n}\n\n=head2 equals\n\n Title   : equals\n Usage   : if ($mappable->equals($mapable2)) {...}\n Function: Test if a position is equal to another position\n Returns : boolean\n Args    : Bio::Map::MappableI","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"end":{"line":287,"character":9999},"start":{"character":0,"line":284}},"name":"equals"},{"range":{"end":{"line":302,"character":9999},"start":{"character":0,"line":299}},"name":"less_than","line":299,"children":[{"localvar":"my","containerName":"less_than","definition":"my","name":"$self","line":300,"kind":13},{"kind":13,"line":300,"containerName":"less_than","name":"@args"},{"kind":13,"line":301,"name":"$self","containerName":"less_than"},{"kind":12,"line":301,"containerName":"less_than","name":"throw_not_implemented"}],"kind":12,"detail":"($self,@args)","signature":{"documentation":"1;\n# BioPerl module for Bio::Map::Microsatellite\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Microsatellite - An object representing a Microsatellite marker.\n\n=head1 SYNOPSIS\n\n  $o_usat = Bio::Map::Microsatellite->new\n      (-name=>'Chad Super Marker 2',\n       -sequence => 'gctgactgatcatatatatatatatatatatatatatatatcgcgatcgtga',\n       -motif => 'at',\n       -repeats => 15,\n       -repeat_start_position => 11\n       );\n\n  $sequence_before_usat = $o_usat->get_leading_flank();\n  $sequence_after_usat = $o_usat->get_trailing_flank();\n\n\n=head1 DESCRIPTION\n\nThis object handles the notion of an Microsatellite. This microsatellite can\nbe placed on a (linear) Map or used on its own.  If this Microsatellites\nwill be used in a mapping context (it doesn't have to, you know) it can have\nmultiple positions in a map. For information about a Microsatellite's position\nin a map one must query the associate PositionI object which is accessible\nthrough the position() method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Microsatellite;\nuse strict;\n\nuse base qw(Bio::Map::Marker);\n\n=head2 new\n\n Title   : new\n Usage   : $o_usat = \n Function: Builds a new Bio::Map::Microsatellite object\n Returns : Bio::Map::Microsatellite\n Args    :\n\t-name    => name of this microsatellite (optional, string,\n\t\tdefault 'Unknown microsatellite')\n        -positions => position(s) for this marker in maps[optional],\n                An array reference of tuples (array refs themselves)\n                Each tuple conatins a Bio::Map::MapI-inherited object and a \n\t\tBio::Map::PositionI-inherited obj, no default)\n\t-sequence => the sequence of this microsatellite (optional,\n\t\t scalar, no default)\n\t-motif => the repeat motif of this microsatellite (optional,\n\t\t scalar, no default)\n\t-repeats => the number of motif repeats for this microsatellite\n\t\t(optional, scalar, no default)\n\t-repeat_start_position => the starting position of the\n\t\tmicrosatellite in this sequence. The first base of the\n\t\tsequence is position \"1\". (optional, scalar, no default)\n\n Note    : Creating a Bio::Map::Microsatellite object with no position\n\tmight be useful for microsatellite people wanting to embrace\n\tand extend this module. <raising hand> Me! Me! Me!\n\t- using repeat_start_position will trigger a mechinism to\n\tcalculate a value for repeat_end_position. \n\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($map, $position, $sequence, $motif, $repeats, $start) = \n\t$self->_rearrange([qw(MAP\n\t\t\t      POSITION\n\t\t\t      SEQUENCE \n\t\t\t      MOTIF \n\t\t\t      REPEATS \n\t\t\t      REPEAT_START_POSITION\n\t\t\t      )], @args);\n    if( ! $self->name ) { \n\t$self->name('Unnamed microsatellite');\n    }\n    $map && $self->map($map);\n    $position && $self->position($position);\n    $sequence && $self->sequence($sequence);\n    $self->motif(defined $motif ? $motif : 'Unknown motif'); \n    $repeats && $self->repeats($repeats);\n    $start && $self->repeat_start_position($start);\n    return $self;\n}\n\n=head2 motif\n\n Title   : motif\n Usage   : $o_usat->motif($new_motif);\n\t       my $motif = $o_usat->motif();\n Function: Get/Set the repeat motif for this Microsatellite.\n Returns : A scalar representing the current repeat motif of this\n\t       Microsatellite.\n Args    : none to get, OR string to set\n\n\nsub motif {\n\tmy ($self,$motif) = @_;\n\tif ($motif) {\n\t\t$self->{'_motif'} = $motif;\n\t}\n\treturn $self->{'_motif'};\t\n}\n\n=head2 sequence\n\n Title   : sequence\n Usage   : $o_usat->sequence($new_sequence);\n\t       my $sequence = $o_usat->sequence();\n Function: Get/Set the sequence for this Microsatellite.\n Returns : A scalar representing the current sequence of this\n\t       Microsatellite.\n Args    : none to get, OR string to set\n\n\nsub sequence {\n\tmy ($self,$sequence) = @_;\n\tif ($sequence) {\n\t\t$self->{'_sequence'} = $sequence;\n\t}\n\treturn $self->{'_sequence'};\t\n}\n\n=head2 repeats\n\n Title   : repeats\n Usage   : $o_usat->repeats($new_repeats);\n\t       my $repeats = $o_usat->repeats()\n Function: Get/Set the repeat repeats for this Microsatellite.\n Returns : A scalar representing the current number of repeats of this\n\t       Microsatellite.\n Args    : none to get, OR int to set\n\n\nsub repeats {\n\tmy ($self,$repeats) = @_;\n\tif ($repeats) {\n\t\t$self->{'_repeats'} = $repeats;\n\t}\n\treturn $self->{'_repeats'};\t\n}\n\n=head2 repeat_start_position\n\n Title   : repeat_start_position\n Usage   : $o_usat->repeat_start_position($new_repeat_start_position);\n\t       my $repeat_start_position = $o_usat->repeat_start_position();\n Function: Get/Set the repeat repeat_start_position for this\n\t       Microsatellite\n Returns : A scalar representing the repeat start position for this \n\t       Microsatellite.\n Args    : none to get, OR string to set\n\t       This method will also try to set the repeat end position. This\n\t       depends on having information for the motif and the number of\n\t       repeats. If you want to use methods like get_trailing_flank or\n\t       get_leading flank, be careful to include the right information.\n\n\nsub repeat_start_position {\n\tmy ($self,$repeat_start_position) = @_;\n\tif ($repeat_start_position) {\n\t\t$self->{'_repeat_start_position'} = $repeat_start_position;\n\t\t$self->repeat_end_position(\"set\");\n\t}\n\treturn $self->{'_repeat_start_position'};\t\n}\n\n=head2 repeat_end_position\n\n Title   : repeat_end_position\n Usage   : $o_usat->repeat_end_position(\"set\");\n\t       $o_usat->repeat_end_position($value);\n\t       $current_repeat_end_position = $o_usat->repeat_end_position();\n Function: Get/set the end position of the repeat in this sequence.\n Returns : A scalar representing the base index of the end of the\n\t       repeat in this Microsatellite. The first base in the sequence\n\t       is base 1.\n Args    : A scalar representing a value, the string \"set\", or no\n\t       argument (see Notes).\n Notes   : If you do not provide an argument to this method, the current\n           end position of the repeat in this Microsatellite will be\n           returned (a scalar).\n           If you provide the string \"set\" to this method it will set the\n           end position based on the start position, the length of the\n           motif, and the number of repeats.\n           If you specify a value the current end position of the repeat\n           will be set to that value. This is a really bad idea. Don't do\n           it.\n\n\nsub repeat_end_position {\n    my ($self,$caller) = @_;\n    if( defined $caller ) { \n\tif ($caller eq \"set\") {\n\t    $self->{'_repeat_end_position'} = \n\t\t$self->{'_repeat_start_position'} + \n\t\t    (length($self->motif()) * $self->repeats());\n\t}\n\telsif ($caller) {\n\t    $self->{'_repeat_end_position'} = $caller;\n\t}\n    }\n    return $self->{'_repeat_end_position'};\n}\n\n=head2 equals\n\n Title   : equals\n Usage   : if ($mappable->equals($mapable2)) {...}\n Function: Test if a position is equal to another position\n Returns : boolean\n Args    : Bio::Map::MappableI\n\n\nsub equals {\n\tmy ($self,@args) = @_;\n\t$self->throw_not_implemented();\n}\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($mappable->less_than($m2)) {...}\n Function: Tests if a position is less than another position\n Returns : boolean\n Args    : Bio::Map::MappableI","parameters":[{"label":"$self"},{"label":"@args"}],"label":"less_than($self,@args)"},"containerName":"main::","definition":"sub"},{"kind":12,"line":314,"children":[{"kind":13,"line":315,"containerName":"greater_than","definition":"my","name":"$self","localvar":"my"},{"line":315,"kind":13,"name":"@args","containerName":"greater_than"},{"name":"$self","containerName":"greater_than","kind":13,"line":316},{"line":316,"kind":12,"containerName":"greater_than","name":"throw_not_implemented"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"greater_than($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# BioPerl module for Bio::Map::Microsatellite\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Microsatellite - An object representing a Microsatellite marker.\n\n=head1 SYNOPSIS\n\n  $o_usat = Bio::Map::Microsatellite->new\n      (-name=>'Chad Super Marker 2',\n       -sequence => 'gctgactgatcatatatatatatatatatatatatatatatcgcgatcgtga',\n       -motif => 'at',\n       -repeats => 15,\n       -repeat_start_position => 11\n       );\n\n  $sequence_before_usat = $o_usat->get_leading_flank();\n  $sequence_after_usat = $o_usat->get_trailing_flank();\n\n\n=head1 DESCRIPTION\n\nThis object handles the notion of an Microsatellite. This microsatellite can\nbe placed on a (linear) Map or used on its own.  If this Microsatellites\nwill be used in a mapping context (it doesn't have to, you know) it can have\nmultiple positions in a map. For information about a Microsatellite's position\nin a map one must query the associate PositionI object which is accessible\nthrough the position() method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Microsatellite;\nuse strict;\n\nuse base qw(Bio::Map::Marker);\n\n=head2 new\n\n Title   : new\n Usage   : $o_usat = \n Function: Builds a new Bio::Map::Microsatellite object\n Returns : Bio::Map::Microsatellite\n Args    :\n\t-name    => name of this microsatellite (optional, string,\n\t\tdefault 'Unknown microsatellite')\n        -positions => position(s) for this marker in maps[optional],\n                An array reference of tuples (array refs themselves)\n                Each tuple conatins a Bio::Map::MapI-inherited object and a \n\t\tBio::Map::PositionI-inherited obj, no default)\n\t-sequence => the sequence of this microsatellite (optional,\n\t\t scalar, no default)\n\t-motif => the repeat motif of this microsatellite (optional,\n\t\t scalar, no default)\n\t-repeats => the number of motif repeats for this microsatellite\n\t\t(optional, scalar, no default)\n\t-repeat_start_position => the starting position of the\n\t\tmicrosatellite in this sequence. The first base of the\n\t\tsequence is position \"1\". (optional, scalar, no default)\n\n Note    : Creating a Bio::Map::Microsatellite object with no position\n\tmight be useful for microsatellite people wanting to embrace\n\tand extend this module. <raising hand> Me! Me! Me!\n\t- using repeat_start_position will trigger a mechinism to\n\tcalculate a value for repeat_end_position. \n\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($map, $position, $sequence, $motif, $repeats, $start) = \n\t$self->_rearrange([qw(MAP\n\t\t\t      POSITION\n\t\t\t      SEQUENCE \n\t\t\t      MOTIF \n\t\t\t      REPEATS \n\t\t\t      REPEAT_START_POSITION\n\t\t\t      )], @args);\n    if( ! $self->name ) { \n\t$self->name('Unnamed microsatellite');\n    }\n    $map && $self->map($map);\n    $position && $self->position($position);\n    $sequence && $self->sequence($sequence);\n    $self->motif(defined $motif ? $motif : 'Unknown motif'); \n    $repeats && $self->repeats($repeats);\n    $start && $self->repeat_start_position($start);\n    return $self;\n}\n\n=head2 motif\n\n Title   : motif\n Usage   : $o_usat->motif($new_motif);\n\t       my $motif = $o_usat->motif();\n Function: Get/Set the repeat motif for this Microsatellite.\n Returns : A scalar representing the current repeat motif of this\n\t       Microsatellite.\n Args    : none to get, OR string to set\n\n\nsub motif {\n\tmy ($self,$motif) = @_;\n\tif ($motif) {\n\t\t$self->{'_motif'} = $motif;\n\t}\n\treturn $self->{'_motif'};\t\n}\n\n=head2 sequence\n\n Title   : sequence\n Usage   : $o_usat->sequence($new_sequence);\n\t       my $sequence = $o_usat->sequence();\n Function: Get/Set the sequence for this Microsatellite.\n Returns : A scalar representing the current sequence of this\n\t       Microsatellite.\n Args    : none to get, OR string to set\n\n\nsub sequence {\n\tmy ($self,$sequence) = @_;\n\tif ($sequence) {\n\t\t$self->{'_sequence'} = $sequence;\n\t}\n\treturn $self->{'_sequence'};\t\n}\n\n=head2 repeats\n\n Title   : repeats\n Usage   : $o_usat->repeats($new_repeats);\n\t       my $repeats = $o_usat->repeats()\n Function: Get/Set the repeat repeats for this Microsatellite.\n Returns : A scalar representing the current number of repeats of this\n\t       Microsatellite.\n Args    : none to get, OR int to set\n\n\nsub repeats {\n\tmy ($self,$repeats) = @_;\n\tif ($repeats) {\n\t\t$self->{'_repeats'} = $repeats;\n\t}\n\treturn $self->{'_repeats'};\t\n}\n\n=head2 repeat_start_position\n\n Title   : repeat_start_position\n Usage   : $o_usat->repeat_start_position($new_repeat_start_position);\n\t       my $repeat_start_position = $o_usat->repeat_start_position();\n Function: Get/Set the repeat repeat_start_position for this\n\t       Microsatellite\n Returns : A scalar representing the repeat start position for this \n\t       Microsatellite.\n Args    : none to get, OR string to set\n\t       This method will also try to set the repeat end position. This\n\t       depends on having information for the motif and the number of\n\t       repeats. If you want to use methods like get_trailing_flank or\n\t       get_leading flank, be careful to include the right information.\n\n\nsub repeat_start_position {\n\tmy ($self,$repeat_start_position) = @_;\n\tif ($repeat_start_position) {\n\t\t$self->{'_repeat_start_position'} = $repeat_start_position;\n\t\t$self->repeat_end_position(\"set\");\n\t}\n\treturn $self->{'_repeat_start_position'};\t\n}\n\n=head2 repeat_end_position\n\n Title   : repeat_end_position\n Usage   : $o_usat->repeat_end_position(\"set\");\n\t       $o_usat->repeat_end_position($value);\n\t       $current_repeat_end_position = $o_usat->repeat_end_position();\n Function: Get/set the end position of the repeat in this sequence.\n Returns : A scalar representing the base index of the end of the\n\t       repeat in this Microsatellite. The first base in the sequence\n\t       is base 1.\n Args    : A scalar representing a value, the string \"set\", or no\n\t       argument (see Notes).\n Notes   : If you do not provide an argument to this method, the current\n           end position of the repeat in this Microsatellite will be\n           returned (a scalar).\n           If you provide the string \"set\" to this method it will set the\n           end position based on the start position, the length of the\n           motif, and the number of repeats.\n           If you specify a value the current end position of the repeat\n           will be set to that value. This is a really bad idea. Don't do\n           it.\n\n\nsub repeat_end_position {\n    my ($self,$caller) = @_;\n    if( defined $caller ) { \n\tif ($caller eq \"set\") {\n\t    $self->{'_repeat_end_position'} = \n\t\t$self->{'_repeat_start_position'} + \n\t\t    (length($self->motif()) * $self->repeats());\n\t}\n\telsif ($caller) {\n\t    $self->{'_repeat_end_position'} = $caller;\n\t}\n    }\n    return $self->{'_repeat_end_position'};\n}\n\n=head2 equals\n\n Title   : equals\n Usage   : if ($mappable->equals($mapable2)) {...}\n Function: Test if a position is equal to another position\n Returns : boolean\n Args    : Bio::Map::MappableI\n\n\nsub equals {\n\tmy ($self,@args) = @_;\n\t$self->throw_not_implemented();\n}\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($mappable->less_than($m2)) {...}\n Function: Tests if a position is less than another position\n Returns : boolean\n Args    : Bio::Map::MappableI\n\n\nsub less_than {\n\tmy ($self,@args) = @_;\n        $self->throw_not_implemented();\n}\n\n=head2 greater_than\n\n Title   : greater_than\n Usage   : if ($mappable->greater_than($m2)) {...}\n Function: Tests if position is greater than another position\n Returns : boolean\n Args    : Bio::Map::MappableI"},"name":"greater_than","range":{"start":{"line":314,"character":0},"end":{"line":317,"character":9999}}},{"kind":12,"line":329,"children":[{"line":330,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"get_leading_flank"},{"line":331,"kind":13,"name":"$self","containerName":"get_leading_flank"},{"line":331,"kind":12,"containerName":"get_leading_flank","name":"sequence"},{"name":"$self","containerName":"get_leading_flank","kind":13,"line":331},{"kind":12,"line":331,"name":"repeat_start_position","containerName":"get_leading_flank"}],"containerName":"main::","definition":"sub","name":"get_leading_flank","range":{"start":{"character":0,"line":329},"end":{"character":9999,"line":332}}},{"children":[{"line":345,"kind":13,"localvar":"my","containerName":"get_trailing_flank","name":"$self","definition":"my"},{"name":"$self","containerName":"get_trailing_flank","line":346,"kind":13},{"containerName":"get_trailing_flank","name":"sequence","kind":12,"line":346},{"kind":13,"line":346,"containerName":"get_trailing_flank","name":"$self"},{"name":"repeat_end_position","containerName":"get_trailing_flank","line":346,"kind":12}],"line":344,"kind":12,"range":{"start":{"line":344,"character":0},"end":{"line":347,"character":9999}},"definition":"sub","name":"get_trailing_flank","containerName":"main::"}]}