{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":94},{"range":{"start":{"line":107,"character":0},"end":{"line":116,"character":9999}},"name":"new","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Mappable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Mappable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Mappable - An object representing a generic map element\nthat can have multiple locations in several maps.\n\n=head1 SYNOPSIS\n\n  # a map element in two different positions on the same map\n  $map1 = Bio::Map::SimpleMap->new();\n  $position1 = Bio::Map::Position->new(-map => $map1, -value => 100);\n  $position2 = Bio::Map::Position->new(-map => $map1, -value => 200);\n  $mappable = Bio::Map::Mappable->new(-positions => [$position1, $position2] );\n\n  # add another position on a different map\n  $map2 = Bio::Map::SimpleMap->new();\n  $position3 = Bio::Map::Position->new(-map => $map2, $value => 50);\n  $mappable->add_position($position3);\n\n  # get all the places our map element is found, on a particular map of interest\n  foreach $pos ($mappable->get_positions($map1)) {\n     print $pos->value, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a generic map element. Mappables are\nentities with one or more positions on one or more maps.\n\nThis object is a pure perl implementation of L<Bio::Map::MappableI>. That\ninterface implements some of its own methods so check the docs there for\nthose.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Mappable;\nuse strict;\nuse Bio::Map::Relative;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $mappable = Bio::Map::Mappable->new();\n Function: Builds a new Bio::Map::Mappable object\n Returns : Bio::Map::Mappable\n Args    : -name => string : name of the mappable element\n           -id   => string : id of the mappable element"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":108,"definition":"my","name":"$class","containerName":"new","localvar":"my"},{"kind":13,"line":108,"name":"@args","containerName":"new"},{"localvar":"my","name":"$self","definition":"my","containerName":"new","line":109,"kind":13},{"containerName":"new","name":"$class","line":109,"kind":13},{"line":109,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"line":111,"containerName":"new","definition":"my","name":"$name","localvar":"my"},{"containerName":"new","name":"$id","kind":13,"line":111},{"containerName":"new","name":"$self","kind":13,"line":111},{"line":111,"kind":12,"name":"_rearrange","containerName":"new"},{"line":111,"kind":13,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","line":112,"kind":13},{"line":112,"kind":12,"name":"name","containerName":"new"},{"line":112,"kind":13,"containerName":"new","name":"$name"},{"containerName":"new","name":"$name","line":112,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":113},{"name":"id","containerName":"new","line":113,"kind":12},{"kind":13,"line":113,"containerName":"new","name":"$id"},{"kind":13,"line":113,"name":"$id","containerName":"new"},{"containerName":"new","name":"$self","line":115,"kind":13}],"line":107,"kind":12},{"line":109,"kind":12,"containerName":"new","name":"SUPER"},{"line":130,"children":[{"line":131,"kind":13,"localvar":"my","containerName":"name","definition":"my","name":"$self"},{"name":"$self","containerName":"name","line":132,"kind":13},{"line":133,"kind":13,"containerName":"name","name":"$self"}],"kind":12,"range":{"end":{"line":134,"character":9999},"start":{"character":0,"line":130}},"containerName":"main::","name":"name","definition":"sub"},{"name":"_name","kind":12,"line":132},{"name":"_name","line":133,"kind":12},{"containerName":"main::","definition":"sub","name":"id","range":{"start":{"character":0,"line":148},"end":{"line":152,"character":9999}},"kind":12,"line":148,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"id","line":149,"kind":13},{"name":"$self","containerName":"id","line":150,"kind":13},{"kind":13,"line":151,"containerName":"id","name":"$self"}]},{"name":"_id","kind":12,"line":150},{"kind":12,"line":151,"name":"_id"},{"name":"in_map","range":{"end":{"character":9999,"line":175},"start":{"line":164,"character":0}},"kind":12,"line":164,"children":[{"line":165,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"in_map"},{"containerName":"in_map","name":"$query_map","line":165,"kind":13},{"containerName":"in_map","name":"$self","line":166,"kind":13},{"kind":12,"line":166,"name":"throw","containerName":"in_map"},{"line":166,"kind":13,"containerName":"in_map","name":"$query_map"},{"kind":13,"line":167,"containerName":"in_map","name":"$self"},{"line":167,"kind":12,"name":"throw","containerName":"in_map"},{"containerName":"in_map","name":"$query_map","kind":13,"line":167},{"line":168,"kind":13,"containerName":"in_map","name":"$self"},{"containerName":"in_map","name":"throw","kind":12,"line":168},{"line":168,"kind":13,"containerName":"in_map","name":"$query_map"},{"containerName":"in_map","name":"isa","line":168,"kind":12},{"definition":"my","name":"$map","containerName":"in_map","localvar":"my","kind":13,"line":170},{"name":"$self","containerName":"in_map","line":170,"kind":13},{"kind":12,"line":170,"name":"known_maps","containerName":"in_map"},{"line":171,"kind":13,"name":"$map","containerName":"in_map"},{"name":"$query_map","containerName":"in_map","kind":13,"line":171}],"containerName":"main::","definition":"sub","detail":"($self,$query_map)","signature":{"parameters":[{"label":"$self"},{"label":"$query_map"}],"documentation":"1;\n# $Id: Mappable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Mappable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Mappable - An object representing a generic map element\nthat can have multiple locations in several maps.\n\n=head1 SYNOPSIS\n\n  # a map element in two different positions on the same map\n  $map1 = Bio::Map::SimpleMap->new();\n  $position1 = Bio::Map::Position->new(-map => $map1, -value => 100);\n  $position2 = Bio::Map::Position->new(-map => $map1, -value => 200);\n  $mappable = Bio::Map::Mappable->new(-positions => [$position1, $position2] );\n\n  # add another position on a different map\n  $map2 = Bio::Map::SimpleMap->new();\n  $position3 = Bio::Map::Position->new(-map => $map2, $value => 50);\n  $mappable->add_position($position3);\n\n  # get all the places our map element is found, on a particular map of interest\n  foreach $pos ($mappable->get_positions($map1)) {\n     print $pos->value, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a generic map element. Mappables are\nentities with one or more positions on one or more maps.\n\nThis object is a pure perl implementation of L<Bio::Map::MappableI>. That\ninterface implements some of its own methods so check the docs there for\nthose.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Mappable;\nuse strict;\nuse Bio::Map::Relative;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $mappable = Bio::Map::Mappable->new();\n Function: Builds a new Bio::Map::Mappable object\n Returns : Bio::Map::Mappable\n Args    : -name => string : name of the mappable element\n           -id   => string : id of the mappable element\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($name, $id) = $self->_rearrange([qw(NAME ID)], @args);\n    $self->name($name) if $name;\n    $self->id($id) if $id;\n    \n    return $self;\n}\n\n=head2 name\n\n Title   : name\n Usage   : $mappable->name($new_name);\n\t       my $name = $mappable->name();\n Function: Get/Set the name for this Mappable\n Returns : A scalar representing the current name of this Mappable\n Args    : none to get\n           string to set\n\n\nsub name {\n    my $self = shift;\n    if (@_) { $self->{_name} = shift }\n    return $self->{_name} || '';\n}\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $mappable->id();\n           $mappable->id($new_id);\n Function: Get/Set the id for this Mappable.\n Returns : A scalar representing the current id of this Mappable\n Args    : none to get\n           string to set\n\n\nsub id {\n    my $self = shift;\n    if (@_) { $self->{_id} = shift }\n    return $self->{_id} || return;\n}\n\n=head2 in_map\n\n Title   : in_map\n Usage   : if ($mappable->in_map($map)) {...}\n Function: Tests if this mappable is found on a specific map\n Returns : boolean\n Args    : L<Bio::Map::MapI>","label":"in_map($self,$query_map)"}},{"line":200,"children":[{"kind":13,"line":201,"definition":"my","name":"$self","containerName":"equals","localvar":"my"},{"line":202,"kind":13,"name":"$self","containerName":"equals"},{"kind":12,"line":202,"name":"_compare","containerName":"equals"}],"kind":12,"range":{"end":{"line":203,"character":9999},"start":{"character":0,"line":200}},"containerName":"main::","name":"equals","definition":"sub"},{"children":[{"containerName":"less_than","definition":"my","name":"$self","localvar":"my","kind":13,"line":225},{"line":226,"kind":13,"name":"$self","containerName":"less_than"},{"kind":12,"line":226,"name":"_compare","containerName":"less_than"}],"line":224,"kind":12,"range":{"end":{"character":9999,"line":227},"start":{"character":0,"line":224}},"definition":"sub","name":"less_than","containerName":"main::"},{"range":{"start":{"character":0,"line":248},"end":{"line":251,"character":9999}},"name":"greater_than","definition":"sub","containerName":"main::","children":[{"line":249,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"greater_than"},{"kind":13,"line":250,"containerName":"greater_than","name":"$self"},{"kind":12,"line":250,"name":"_compare","containerName":"greater_than"}],"line":248,"kind":12},{"kind":12,"line":272,"children":[{"definition":"my","name":"$self","containerName":"overlaps","localvar":"my","kind":13,"line":273},{"line":274,"kind":13,"name":"$self","containerName":"overlaps"},{"containerName":"overlaps","name":"_compare","kind":12,"line":274}],"containerName":"main::","definition":"sub","name":"overlaps","range":{"end":{"line":275,"character":9999},"start":{"character":0,"line":272}}},{"kind":12,"children":[{"localvar":"my","containerName":"contains","name":"$self","definition":"my","line":297,"kind":13},{"kind":13,"line":298,"containerName":"contains","name":"$self"},{"containerName":"contains","name":"_compare","kind":12,"line":298}],"line":296,"definition":"sub","name":"contains","containerName":"main::","range":{"start":{"line":296,"character":0},"end":{"character":9999,"line":299}}},{"children":[{"containerName":"overlapping_groups","definition":"my","name":"$self","localvar":"my","kind":13,"line":347},{"line":348,"kind":13,"name":"$self","containerName":"overlapping_groups"},{"name":"_compare","containerName":"overlapping_groups","kind":12,"line":348}],"line":346,"kind":12,"range":{"end":{"character":9999,"line":349},"start":{"line":346,"character":0}},"definition":"sub","name":"overlapping_groups","containerName":"main::"},{"kind":12,"children":[{"localvar":"my","containerName":"disconnected_intersections","name":"$self","definition":"my","line":400,"kind":13},{"name":"$self","containerName":"disconnected_intersections","kind":13,"line":401},{"line":401,"kind":12,"name":"_compare","containerName":"disconnected_intersections"}],"line":399,"name":"disconnected_intersections","definition":"sub","containerName":"main::","range":{"start":{"line":399,"character":0},"end":{"character":9999,"line":402}}},{"definition":"sub","name":"disconnected_unions","containerName":"main::","range":{"end":{"character":9999,"line":454},"start":{"line":451,"character":0}},"kind":12,"children":[{"line":452,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"disconnected_unions"},{"kind":13,"line":453,"name":"$self","containerName":"disconnected_unions"},{"line":453,"kind":12,"containerName":"disconnected_unions","name":"_compare"}],"line":451},{"range":{"end":{"character":9999,"line":462},"start":{"line":458,"character":0}},"name":"_compare","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_compare","line":459,"kind":13},{"containerName":"_compare","name":"$method","kind":13,"line":459},{"containerName":"_compare","name":"$input","line":459,"kind":13},{"name":"@extra_args","containerName":"_compare","line":459,"kind":13},{"kind":13,"line":460,"name":"$self","containerName":"_compare"},{"containerName":"_compare","name":"throw","line":460,"kind":12},{"kind":13,"line":460,"name":"$input","containerName":"_compare"},{"kind":13,"line":461,"containerName":"_compare","name":"$self"},{"containerName":"_compare","name":"throw","kind":12,"line":461},{"line":461,"kind":13,"containerName":"_compare","name":"@extra_args"},{"kind":13,"line":462,"definition":"my","name":"@compares","containerName":"_compare","localvar":"my"},{"containerName":"_compare","name":"$input","line":462,"kind":13},{"name":"$input","containerName":"_compare","line":462,"kind":13}],"line":458,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$method"},{"label":"$input"},{"label":"@extra_args"}],"documentation":" do a RangeI-related comparison by calling the corresponding PositionI method\n on all the requested Positions of our Mappables","label":"_compare($self,$method,$input,@extra_args)"},"detail":"($self,$method,$input,@extra_args)","definition":"sub","containerName":"main::"},{"name":"$input","containerName":null,"kind":13,"line":462},{"containerName":null,"definition":"my","name":"%args","localvar":"my","kind":13,"line":464},{"name":"@extra_args","containerName":null,"line":467,"kind":13},{"line":468,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$map"},{"containerName":null,"name":"%args","line":468,"kind":13},{"line":469,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$rel"},{"containerName":null,"name":"%args","line":469,"kind":13},{"line":470,"kind":13,"localvar":"my","definition":"my","name":"$overlap","containerName":null},{"containerName":null,"name":"%args","kind":13,"line":470},{"containerName":null,"name":"$min_pos_num","definition":"my","localvar":"my","kind":13,"line":471},{"containerName":null,"name":"%args","kind":13,"line":471},{"line":472,"kind":13,"localvar":"my","definition":"my","name":"$min_pables_num","containerName":null},{"containerName":null,"name":"%args","line":472,"kind":13},{"containerName":null,"name":"%args","line":473,"kind":13},{"kind":13,"line":474,"containerName":null,"definition":"my","name":"$mn","localvar":"my"},{"containerName":null,"name":"@compares","line":474,"kind":13},{"line":474,"kind":13,"name":"$self","containerName":null},{"kind":13,"line":474,"name":"%args","containerName":null},{"line":475,"kind":13,"containerName":null,"name":"$mn"},{"line":475,"kind":13,"name":"%min_pables_num","containerName":null},{"line":476,"kind":13,"name":"$min_pables_num","containerName":null},{"line":476,"kind":13,"name":"$mn","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"$min_map_num","line":479,"kind":13},{"containerName":null,"name":"%args","line":479,"kind":13},{"name":"%args","containerName":null,"kind":13,"line":480},{"line":481,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"%known_maps"},{"kind":13,"line":482,"definition":"my","name":"$pable","containerName":null,"localvar":"my"},{"kind":13,"line":482,"containerName":null,"name":"@compares"},{"containerName":null,"name":"$self","kind":13,"line":482},{"name":"%self","containerName":null,"line":482,"kind":13},{"kind":13,"line":483,"definition":"my","name":"$known","containerName":null,"localvar":"my"},{"line":483,"kind":13,"containerName":null,"name":"$pable"},{"line":483,"kind":12,"name":"known_maps","containerName":"main::"},{"name":"%known_maps","containerName":null,"kind":13,"line":484},{"kind":13,"line":484,"containerName":null,"name":"$known"},{"kind":12,"line":484,"containerName":"main::","name":"unique_id"},{"kind":13,"line":487,"definition":"my","name":"$mn","containerName":null,"localvar":"my"},{"name":"%known_maps","containerName":null,"kind":13,"line":487},{"containerName":null,"name":"%args","line":487,"kind":13},{"name":"$mn","containerName":null,"line":488,"kind":13},{"line":488,"kind":13,"containerName":null,"name":"%min_map_num"},{"name":"$min_map_num","containerName":null,"line":489,"kind":13},{"name":"$mn","containerName":null,"line":489,"kind":13},{"line":492,"kind":13,"localvar":"my","name":"%required","definition":"my","containerName":null},{"line":492,"kind":13,"containerName":null,"name":"%args"},{"name":"%args","containerName":null,"line":492,"kind":13},{"name":"@mine","definition":"my","containerName":null,"localvar":"my","kind":13,"line":493},{"line":493,"kind":13,"containerName":null,"name":"@yours"},{"kind":13,"line":495,"name":"%self","containerName":null},{"containerName":null,"name":"@mine","line":496,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":496},{"containerName":"main::","name":"get_positions","line":496,"kind":12},{"line":496,"kind":13,"name":"$map","containerName":null},{"line":497,"kind":13,"containerName":null,"name":"%args"},{"name":"@mine","containerName":null,"line":498,"kind":13},{"name":"%required","containerName":null,"kind":13,"line":499},{"name":"$self","containerName":null,"line":499,"kind":13},{"name":"@required","definition":"my","containerName":null,"localvar":"my","kind":13,"line":502},{"line":502,"kind":13,"name":"%required","containerName":null},{"kind":13,"line":504,"name":"$compare","definition":"my","containerName":null,"localvar":"my"},{"line":504,"kind":13,"containerName":null,"name":"@compares"},{"containerName":null,"name":"$compare","kind":13,"line":505},{"kind":12,"line":505,"containerName":"main::","name":"isa"},{"name":"@yours","containerName":null,"line":506,"kind":13},{"containerName":null,"name":"$compare","kind":13,"line":506},{"kind":13,"line":508,"containerName":null,"name":"$compare"},{"containerName":"main::","name":"isa","kind":12,"line":508},{"name":"@yours","containerName":null,"kind":13,"line":509},{"line":509,"kind":13,"name":"$compare","containerName":null},{"name":"get_positions","containerName":"main::","kind":12,"line":509},{"line":509,"kind":13,"containerName":null,"name":"%map"},{"kind":13,"line":512,"containerName":null,"name":"$self"},{"name":"throw","containerName":"main::","kind":12,"line":512},{"line":515,"kind":13,"name":"@yours","containerName":null},{"name":"@ok","definition":"my","containerName":null,"localvar":"my","kind":13,"line":517},{"name":"SWITCH","line":518,"kind":12},{"name":"%method","containerName":null,"kind":13,"line":518},{"containerName":null,"name":"@mine","line":520,"kind":13},{"kind":13,"line":521,"containerName":null,"definition":"my","name":"$my_pos","localvar":"my"},{"name":"@mine","containerName":null,"kind":13,"line":521},{"localvar":"my","containerName":null,"name":"$your_pos","definition":"my","line":522,"kind":13},{"name":"@yours","containerName":null,"line":522,"kind":13},{"containerName":null,"name":"$my_pos","line":523,"kind":13},{"containerName":null,"name":"$method","kind":13,"line":523},{"containerName":null,"name":"$your_pos","line":523,"kind":13},{"containerName":null,"name":"%rel","kind":13,"line":523},{"kind":13,"line":524,"name":"@ok","containerName":null},{"name":"$my_pos","containerName":null,"line":524,"kind":13},{"kind":12,"line":529,"name":"SWITCH"},{"kind":13,"line":532,"name":"@mine","containerName":null},{"kind":13,"line":533,"containerName":null,"name":"%method"},{"kind":13,"line":534,"name":"@mine","containerName":null},{"containerName":null,"name":"@b","line":535,"kind":13},{"name":"@a","containerName":null,"kind":13,"line":535},{"name":"end","containerName":"main::","line":536,"kind":12},{"name":"absolute_relative","containerName":"main::","line":536,"kind":12},{"line":537,"kind":13,"name":"@mine","containerName":null},{"containerName":null,"name":"@yours","kind":13,"line":538},{"containerName":null,"name":"@b","line":539,"kind":13},{"containerName":null,"name":"@a","line":539,"kind":13},{"name":"end","containerName":"main::","kind":12,"line":540},{"name":"absolute_relative","containerName":"main::","kind":12,"line":540},{"line":541,"kind":13,"name":"@yours","containerName":null},{"line":543,"kind":13,"localvar":"my","definition":"my","name":"$test_pos","containerName":null},{"containerName":null,"name":"@yours","line":543,"kind":13},{"line":545,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$my_pos"},{"containerName":null,"name":"@mine","line":545,"kind":13},{"kind":13,"line":546,"name":"$my_pos","containerName":null},{"kind":13,"line":546,"name":"$method","containerName":null},{"containerName":null,"name":"$test_pos","kind":13,"line":546},{"containerName":null,"name":"%rel","kind":13,"line":546},{"containerName":null,"name":"@ok","kind":13,"line":547},{"line":547,"kind":13,"name":"%my_pos","containerName":null},{"containerName":null,"name":"%method","line":554,"kind":13},{"line":555,"kind":13,"containerName":null,"name":"@ok"},{"kind":13,"line":556,"name":"@a","containerName":null},{"containerName":null,"name":"@b","line":556,"kind":13},{"line":557,"kind":12,"containerName":"main::","name":"sortable"},{"kind":13,"line":558,"name":"@ok","containerName":null},{"name":"SWITCH","line":561,"kind":12},{"line":564,"kind":13,"localvar":"my","name":"@positions","definition":"my","containerName":null},{"name":"@mine","containerName":null,"line":564,"kind":13},{"kind":13,"line":564,"containerName":null,"name":"@yours"},{"localvar":"my","containerName":null,"name":"$start_pos","definition":"my","line":565,"kind":13},{"kind":13,"line":565,"containerName":null,"name":"@positions"},{"kind":13,"line":567,"containerName":null,"definition":"my","name":"$dr_able","localvar":"my"},{"line":567,"kind":13,"name":"$start_pos","containerName":null},{"kind":12,"line":567,"containerName":"main::","name":"disconnected_ranges"},{"line":567,"kind":13,"containerName":null,"name":"@positions"},{"name":"$rel","containerName":null,"kind":13,"line":567},{"name":"$overlap","containerName":null,"kind":13,"line":567},{"localvar":"my","definition":"my","name":"@disconnected_ranges","containerName":null,"line":568,"kind":13},{"line":568,"kind":13,"name":"$dr_able","containerName":null},{"containerName":"main::","name":"get_positions","kind":12,"line":568},{"localvar":"my","containerName":null,"name":"%all_groups","definition":"my","line":575,"kind":13},{"line":576,"kind":13,"localvar":"my","definition":"my","name":"%done_ranges","containerName":null},{"localvar":"my","containerName":null,"name":"$i","definition":"my","line":577,"kind":13},{"kind":12,"line":577,"name":"disconnected_ranges"},{"name":"$range","definition":"my","containerName":null,"localvar":"my","kind":13,"line":578},{"containerName":null,"name":"@disconnected_ranges","kind":13,"line":578},{"kind":13,"line":578,"name":"$i","containerName":null},{"kind":13,"line":579,"name":"$range_string","definition":"my","containerName":null,"localvar":"my"},{"name":"$range","containerName":null,"kind":13,"line":579},{"line":579,"kind":12,"containerName":"main::","name":"toString"},{"name":"%done_ranges","containerName":null,"line":580,"kind":13},{"name":"$range_string","containerName":null,"line":580,"kind":13},{"line":581,"kind":13,"containerName":null,"name":"%done_ranges"},{"line":581,"kind":13,"containerName":null,"name":"$range_string"},{"line":583,"kind":13,"localvar":"my","definition":"my","name":"$pos","containerName":null},{"line":583,"kind":13,"name":"$start_pos","containerName":null},{"containerName":null,"name":"@positions","kind":13,"line":583},{"kind":13,"line":584,"containerName":null,"name":"$pos"},{"kind":12,"line":584,"containerName":"main::","name":"overlaps"},{"containerName":null,"name":"$range","kind":13,"line":584},{"containerName":null,"name":"%rel","kind":13,"line":584},{"name":"%all_groups","containerName":null,"kind":13,"line":585},{"containerName":null,"name":"%range_string","kind":13,"line":585},{"name":"$pos","containerName":null,"kind":13,"line":585},{"line":585,"kind":13,"containerName":null,"name":"$pos"},{"localvar":"my","containerName":null,"name":"$pos","definition":"my","line":598,"kind":13},{"name":"@disconnected_ranges","containerName":null,"kind":13,"line":598},{"kind":13,"line":599,"containerName":null,"definition":"my","name":"$map","localvar":"my"},{"kind":13,"line":599,"name":"$pos","containerName":null},{"name":"map","containerName":"main::","kind":12,"line":599},{"line":600,"kind":13,"containerName":null,"name":"$map"},{"line":600,"kind":12,"name":"purge_positions","containerName":"main::"},{"containerName":null,"name":"$pos","line":600,"kind":13},{"kind":13,"line":603,"containerName":null,"name":"@groups","definition":"my","localvar":"my"},{"kind":12,"line":604,"name":"GROUPS"},{"localvar":"my","containerName":null,"name":"$group_range","definition":"my","line":604,"kind":13},{"kind":13,"line":604,"containerName":null,"name":"%all_groups"},{"line":605,"kind":13,"localvar":"my","containerName":null,"name":"$group","definition":"my"},{"kind":13,"line":605,"name":"%all_groups","containerName":null},{"containerName":null,"name":"$group_range","kind":13,"line":605},{"localvar":"my","containerName":null,"name":"@group","definition":"my","line":606,"kind":13},{"line":606,"kind":13,"name":"$group","containerName":null},{"containerName":null,"name":"@group","line":609,"kind":13},{"line":609,"kind":13,"containerName":null,"name":"$min_pos_num"},{"containerName":null,"name":"@group","line":610,"kind":13},{"kind":13,"line":610,"containerName":null,"name":"$min_pables_num"},{"name":"@group","containerName":null,"kind":13,"line":611},{"name":"$min_map_num","containerName":null,"line":611,"kind":13},{"containerName":null,"name":"%mappables","definition":"my","localvar":"my","kind":13,"line":613},{"line":614,"kind":13,"localvar":"my","definition":"my","name":"$pos","containerName":null},{"name":"@group","containerName":null,"kind":13,"line":614},{"line":615,"kind":13,"localvar":"my","name":"$mappable","definition":"my","containerName":null},{"containerName":null,"name":"$pos","kind":13,"line":615},{"line":615,"kind":12,"containerName":"main::","name":"element"},{"line":616,"kind":13,"name":"%mappables","containerName":null},{"line":616,"kind":13,"name":"$mappable","containerName":null},{"name":"%mappables","containerName":null,"line":618,"kind":13},{"kind":13,"line":618,"containerName":null,"name":"$min_pables_num"},{"line":620,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"%maps"},{"kind":13,"line":621,"containerName":null,"definition":"my","name":"$pos","localvar":"my"},{"line":621,"kind":13,"name":"@group","containerName":null},{"containerName":null,"definition":"my","name":"$map","localvar":"my","kind":13,"line":622},{"containerName":null,"name":"$pos","kind":13,"line":622},{"kind":12,"line":622,"name":"map","containerName":"main::"},{"line":623,"kind":13,"containerName":null,"name":"%maps"},{"name":"$map","containerName":null,"kind":13,"line":623},{"name":"unique_id","containerName":"main::","kind":12,"line":623},{"containerName":null,"name":"%maps","kind":13,"line":625},{"line":625,"kind":13,"containerName":null,"name":"$min_map_num"},{"name":"$required","definition":"my","containerName":null,"localvar":"my","kind":13,"line":627},{"name":"@required","containerName":null,"line":627,"kind":13},{"line":628,"kind":13,"containerName":null,"name":"%mappables"},{"containerName":null,"name":"$required","kind":13,"line":628},{"name":"GROUPS","kind":12,"line":628},{"kind":13,"line":631,"containerName":null,"name":"@sorted","definition":"my","localvar":"my"},{"kind":13,"line":632,"containerName":null,"name":"@a"},{"kind":13,"line":632,"containerName":null,"name":"@b"},{"containerName":"main::","name":"sortable","line":633,"kind":12},{"kind":13,"line":634,"name":"@group","containerName":null},{"containerName":null,"name":"@groups","kind":13,"line":635},{"line":635,"kind":13,"containerName":null,"name":"@sorted"},{"kind":13,"line":638,"name":"%method","containerName":null},{"kind":13,"line":639,"name":"@groups","containerName":null},{"localvar":"my","containerName":null,"name":"$group","definition":"my","line":642,"kind":13},{"name":"@groups","containerName":null,"line":642,"kind":13},{"localvar":"my","name":"$start_pos","definition":"my","containerName":null,"line":643,"kind":13},{"kind":13,"line":643,"name":"$group","containerName":null},{"name":"%group","containerName":null,"line":645,"kind":13},{"line":648,"kind":13,"name":"@ok","containerName":null},{"name":"Bio","containerName":"Map::Position","line":648,"kind":12},{"line":648,"kind":12,"name":"new","containerName":"main::"},{"kind":13,"line":648,"containerName":null,"name":"$start_pos"},{"name":"map","containerName":"main::","kind":12,"line":648},{"containerName":null,"name":"$start_pos","line":649,"kind":13},{"containerName":"main::","name":"start","line":649,"kind":12},{"containerName":null,"name":"$start_pos","line":650,"kind":13},{"line":650,"kind":12,"name":"end","containerName":"main::"},{"line":653,"kind":13,"localvar":"my","containerName":null,"name":"@rel_arg","definition":"my"},{"kind":13,"line":653,"name":"$method","containerName":null},{"kind":13,"line":653,"name":"$rel","containerName":null},{"name":"$rel","containerName":null,"line":653,"kind":13},{"kind":13,"line":654,"containerName":null,"definition":"my","name":"$result","localvar":"my"},{"kind":13,"line":654,"name":"$start_pos","containerName":null},{"containerName":null,"name":"$method","line":654,"kind":13},{"name":"$group","containerName":null,"kind":13,"line":654},{"line":654,"kind":13,"containerName":null,"name":"@rel_arg"},{"containerName":null,"name":"@ok","line":655,"kind":13},{"containerName":null,"name":"$result","line":655,"kind":13},{"containerName":"main::","name":"get_positions","kind":12,"line":655},{"containerName":null,"definition":"my","name":"$result","localvar":"my","kind":13,"line":660},{"name":"$self","containerName":null,"line":660,"kind":13},{"line":660,"kind":12,"name":"new","containerName":"main::"},{"line":661,"kind":13,"name":"$result","containerName":null},{"kind":12,"line":661,"name":"add_position","containerName":"main::"},{"line":661,"kind":13,"name":"@ok","containerName":null},{"line":661,"kind":13,"containerName":null,"name":"@ok"},{"line":663,"kind":13,"name":"$result","containerName":null},{"name":"SWITCH","line":666,"kind":12},{"name":"$self","containerName":null,"kind":13,"line":669},{"kind":12,"line":669,"name":"throw","containerName":"main::"},{"name":"@ok","containerName":null,"kind":13,"line":672},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"tuple","line":688,"kind":13},{"line":689,"kind":13,"name":"$self","containerName":"tuple"},{"containerName":"tuple","name":"warn","kind":12,"line":689}],"line":687,"kind":12,"range":{"end":{"line":690,"character":9999},"start":{"character":0,"line":687}},"definition":"sub","name":"tuple","containerName":"main::"},{"range":{"end":{"character":9999,"line":709},"start":{"line":705,"character":0}},"containerName":"main::","name":"annotation","definition":"sub","line":705,"children":[{"kind":13,"line":706,"definition":"my","name":"$self","containerName":"annotation","localvar":"my"},{"containerName":"annotation","name":"$self","kind":13,"line":707},{"containerName":"annotation","name":"$self","kind":13,"line":708}],"kind":12},{"name":"_annotation","kind":12,"line":707},{"name":"_annotation","line":708,"kind":12}]}