{"version":5,"vars":[{"containerName":"","name":"base","kind":2,"line":107},{"name":"cytorange","range":{"end":{"line":363,"character":9999},"start":{"character":0,"line":155}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: CytoPosition.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::CytoPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::CytoPosition - Marker class with cytogenetic band storing attributes\n\n=head1 SYNOPSIS\n\n  $m1 = Bio::Map::CytoPosition->new ( '-id' => 'A1',\n\t\t\t\t       '-value' => '2q1-3'\n\t\t\t\t\t     );\n  $m2 = Bio::Map::CytoPosition->new ( '-id' => 'A2',\n\t\t\t\t       '-value' => '2q2'\n\t\t\t\t\t     );\n\n  if ($m1->cytorange->overlaps($m2->cytorange)) {\n      print \"Makers overlap\\n\";\n  }\n\n\n=head1 DESCRIPTION\n\nCytoPosition is marker (Bio::Map::MarkerI compliant) with a location in a\ncytogenetic map. See L<Bio::Map::MarkerI> for more information.\n\nCytogenetic locations are names of bands visible in stained mitotic\neucaryotic chromosomes. The naming follows strict rules which are\nconsistant at least in higher vertebates, e.g. mammals. The chromosome\nname preceds the band names.\n\nThe shorter arm of the chromosome is called 'p' ('petit') and usually\ndrawn pointing up. The lower arm is called 'q' ('queue'). The bands\nare named from the region separting these, a centromere (cen), towards\nthe tips or telomeric regions (ter) counting from 1 upwards. Depending\nof the resolution used the bands are identified with one or more\ndigit. The first digit determines the major band and subsequent digits\nsub bands: p1 band can be divided into subbands p11, p12 and 13 and\np11 can furter be divided into subbands p11.1 and p11.2. The dot after\nsecond digit makes it easier to read the values. A region between ands\nis given from the centromere outwards towards the telomere (e.g. 2p2-5\nor 3p21-35) or from a band in the p arm to a band in the q arm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::CytoPosition;\n\nuse strict;\nuse integer;\nuse Bio::Range;\n\nuse base qw(Bio::Map::Position);\n\n=head2 cytorange\n\n Title   : cytorange\n Usage   : my $range = $obj->cytorange();\n Function:\n            Converts cytogenetic location set by value method into\n            an integer range. The chromosome number determines the\n            \"millions\" in the values.  Human X and Y chromosome\n            symbols are represented by values 100 and 101.\n\n            The localization within chromosomes are converted into\n            values between the range of 0 and 200,000:\n\n            pter                    cen                       qter\n            |------------------------|-------------------------|\n            0                     100,000                   200,000\n\n            The values between -100,000 through 0 for centromere to\n            100,000 would have reflected the band numbering better but\n            use of positive integers was choosen since the\n            transformation is very easy. These values are not metric.\n\n            Each band defines a range in a chromosome. A band string\n            is converted into a range by padding it with lower and and\n            higher end digits (for q arm: '0' and '9') to the length\n            of five. The arm and chromosome values are added to these:\n            e.g. 21000 & 21999 (band 21) + 100,000 (q arm) + 2,000,000\n            (chromosome 2) => 2q21 : 2,121,000 .. 2,121,999. Note that\n            this notation breaks down if there is a band or a subband\n            using digit 9 in its name!  This is not the case in human\n            karyotype.\n\n            The full algorithm used for bands:\n\n            if arm is 'q' then\n               pad char for start is '0', for end '9'\n               range is chromosome + 100,000 + padded range start or end\n            elsif arm is 'p' then\n               pad char for start is '9', for end '0'\n               range is chromosome + 100,000 - padded range start or end\n\n Returns : Bio::Range object or undef\n Args    : none","parameters":[{"label":"$self"}],"label":"cytorange($self)"},"kind":12,"line":155,"children":[{"name":"$self","definition":"my","containerName":"cytorange","localvar":"my","kind":13,"line":156},{"kind":13,"line":157,"containerName":"cytorange","definition":"my","name":"$chr","localvar":"my"},{"name":"$r","containerName":"cytorange","kind":13,"line":157},{"line":157,"kind":13,"name":"$band","containerName":"cytorange"},{"containerName":"cytorange","name":"$band2","kind":13,"line":157},{"kind":13,"line":157,"name":"$arm","containerName":"cytorange"},{"kind":13,"line":157,"containerName":"cytorange","name":"$arm2"},{"containerName":"cytorange","name":"$lc","kind":13,"line":157},{"kind":13,"line":157,"containerName":"cytorange","name":"$uc"},{"kind":13,"line":157,"containerName":"cytorange","name":"$lcchar"},{"line":157,"kind":13,"containerName":"cytorange","name":"$ucchar"},{"line":159,"kind":13,"name":"$r","containerName":"cytorange"},{"containerName":"cytorange","name":"$self","kind":13,"line":159},{"kind":13,"line":160,"name":"$self","containerName":"cytorange"},{"name":"$self","containerName":"cytorange","kind":13,"line":163},{"name":"warn","containerName":"cytorange","kind":12,"line":163},{"containerName":"cytorange","name":"$self","line":163,"kind":13},{"containerName":"cytorange","name":"$r","line":164,"kind":13},{"line":166,"kind":13,"containerName":"cytorange","name":"$chr"},{"kind":13,"line":167,"containerName":"cytorange","name":"$self"},{"name":"chr","containerName":"cytorange","line":167,"kind":12},{"name":"$chr","containerName":"cytorange","line":167,"kind":13},{"kind":13,"line":169,"containerName":"cytorange","name":"$chr"},{"containerName":"cytorange","name":"$chr","kind":13,"line":169},{"name":"$chr","containerName":"cytorange","kind":13,"line":170},{"containerName":"cytorange","name":"$chr","kind":13,"line":170},{"line":171,"kind":13,"name":"$chr","containerName":"cytorange"},{"kind":13,"line":173,"name":"$r","containerName":"cytorange"},{"line":173,"kind":12,"name":"new","containerName":"cytorange"},{"containerName":"cytorange","name":"$band","line":175,"kind":13},{"kind":13,"line":177,"containerName":"cytorange","name":"$self"},{"line":177,"kind":12,"containerName":"cytorange","name":"throw"},{"containerName":"cytorange","name":"$band","kind":13,"line":178},{"kind":13,"line":179,"name":"$band","containerName":"cytorange"},{"name":"$arm2","containerName":"cytorange","kind":13,"line":182},{"kind":13,"line":183,"containerName":"cytorange","name":"$arm2"},{"line":184,"kind":13,"containerName":"cytorange","name":"$band2"},{"name":"$band2","containerName":"cytorange","line":185,"kind":13},{"kind":13,"line":189,"containerName":"cytorange","name":"$band"},{"containerName":"cytorange","name":"$arm2","kind":13,"line":189},{"line":189,"kind":13,"name":"$arm2","containerName":"cytorange"},{"kind":13,"line":189,"name":"$arm2","containerName":"cytorange"},{"line":190,"kind":13,"name":"$lc","containerName":"cytorange"},{"kind":13,"line":190,"containerName":"cytorange","name":"$lcchar"},{"kind":13,"line":191,"name":"$uc","containerName":"cytorange"},{"line":191,"kind":13,"name":"$ucchar","containerName":"cytorange"},{"line":193,"kind":13,"name":"$band","containerName":"cytorange"},{"kind":13,"line":193,"containerName":"cytorange","name":"$arm2"},{"line":193,"kind":13,"containerName":"cytorange","name":"$arm2"},{"name":"$lc","containerName":"cytorange","line":194,"kind":13},{"containerName":"cytorange","name":"$lcchar","line":194,"kind":13},{"containerName":"cytorange","name":"$uc","kind":13,"line":195},{"line":195,"kind":13,"name":"$ucchar","containerName":"cytorange"},{"line":197,"kind":13,"containerName":"cytorange","name":"$band"},{"containerName":"cytorange","name":"$arm2","line":197,"kind":13},{"line":198,"kind":13,"name":"$uc","containerName":"cytorange"},{"kind":13,"line":198,"name":"$ucchar","containerName":"cytorange"},{"name":"$arm2","containerName":"cytorange","line":200,"kind":13},{"name":"$band","containerName":"cytorange","line":201,"kind":13},{"kind":13,"line":201,"name":"$band2","containerName":"cytorange"},{"containerName":"cytorange","name":"$lc","kind":13,"line":202},{"name":"$lcchar","containerName":"cytorange","line":202,"kind":13},{"containerName":"cytorange","name":"$uc","line":203,"kind":13},{"kind":13,"line":203,"name":"$ucchar","containerName":"cytorange"},{"kind":13,"line":205,"containerName":"cytorange","name":"$lc"},{"containerName":"cytorange","name":"$lcchar","line":205,"kind":13},{"name":"$uc","containerName":"cytorange","line":206,"kind":13},{"containerName":"cytorange","name":"$ucchar","kind":13,"line":206},{"name":"$arm2","containerName":"cytorange","kind":13,"line":209},{"name":"$band","containerName":"cytorange","line":210,"kind":13},{"kind":13,"line":210,"name":"$band2","containerName":"cytorange"},{"kind":13,"line":211,"name":"$lc","containerName":"cytorange"},{"containerName":"cytorange","name":"$lcchar","line":211,"kind":13},{"line":212,"kind":13,"name":"$uc","containerName":"cytorange"},{"containerName":"cytorange","name":"$ucchar","line":212,"kind":13},{"name":"$lc","containerName":"cytorange","kind":13,"line":214},{"containerName":"cytorange","name":"$lcchar","line":214,"kind":13},{"line":215,"kind":13,"containerName":"cytorange","name":"$uc"},{"name":"$ucchar","containerName":"cytorange","line":215,"kind":13},{"kind":13,"line":219,"name":"$self","containerName":"cytorange"},{"name":"throw","containerName":"cytorange","line":219,"kind":12},{"name":"$arm2","containerName":"cytorange","kind":13,"line":223},{"line":223,"kind":13,"name":"$arm2","containerName":"cytorange"},{"kind":13,"line":223,"name":"$arm2","containerName":"cytorange"},{"line":223,"kind":13,"name":"$arm2","containerName":"cytorange"},{"name":"$r","containerName":"cytorange","kind":13,"line":224},{"containerName":"cytorange","name":"$uc","line":224,"kind":13},{"name":"$band2","containerName":"cytorange","line":224,"kind":13},{"kind":13,"line":224,"containerName":"cytorange","name":"$ucchar"},{"line":224,"kind":13,"name":"$chr","containerName":"cytorange"},{"line":226,"kind":13,"containerName":"cytorange","name":"$r"},{"containerName":"cytorange","name":"end","kind":12,"line":226},{"containerName":"cytorange","name":"$chr","kind":13,"line":226},{"line":229,"kind":13,"containerName":"cytorange","name":"$r"},{"containerName":"cytorange","name":"$lc","kind":13,"line":229},{"name":"$chr","containerName":"cytorange","kind":13,"line":229},{"name":"$r","containerName":"cytorange","line":232,"kind":13},{"kind":13,"line":232,"containerName":"cytorange","name":"$lc"},{"containerName":"cytorange","name":"$band","line":232,"kind":13},{"kind":13,"line":232,"name":"$lcchar","containerName":"cytorange"},{"kind":13,"line":232,"name":"$chr","containerName":"cytorange"},{"line":234,"kind":13,"name":"$r","containerName":"cytorange"},{"containerName":"cytorange","name":"$lc","line":234,"kind":13},{"containerName":"cytorange","name":"$band","kind":13,"line":234},{"containerName":"cytorange","name":"$lcchar","kind":13,"line":234},{"name":"$chr","containerName":"cytorange","line":234,"kind":13},{"containerName":"cytorange","name":"$r","line":238,"kind":13},{"name":"$uc","containerName":"cytorange","line":238,"kind":13},{"line":238,"kind":13,"name":"$band2","containerName":"cytorange"},{"name":"$ucchar","containerName":"cytorange","kind":13,"line":238},{"containerName":"cytorange","name":"$chr","kind":13,"line":238},{"line":240,"kind":13,"containerName":"cytorange","name":"$r"},{"line":240,"kind":13,"name":"$lc","containerName":"cytorange"},{"name":"$chr","containerName":"cytorange","line":240,"kind":13},{"name":"$r","containerName":"cytorange","line":244,"kind":13},{"containerName":"cytorange","name":"$lc","kind":13,"line":244},{"name":"$chr","containerName":"cytorange","kind":13,"line":244},{"kind":13,"line":246,"containerName":"cytorange","name":"$r"},{"kind":13,"line":246,"containerName":"cytorange","name":"$lc"},{"kind":13,"line":246,"containerName":"cytorange","name":"$band"},{"containerName":"cytorange","name":"$lcchar","line":246,"kind":13},{"line":246,"kind":13,"containerName":"cytorange","name":"$chr"},{"name":"$r","containerName":"cytorange","kind":13,"line":249},{"line":249,"kind":13,"name":"$lc","containerName":"cytorange"},{"kind":13,"line":249,"containerName":"cytorange","name":"$band"},{"line":249,"kind":13,"containerName":"cytorange","name":"$lcchar"},{"containerName":"cytorange","name":"$chr","kind":13,"line":249},{"line":260,"kind":13,"containerName":"cytorange","name":"$r"},{"name":"end","containerName":"cytorange","kind":12,"line":260},{"containerName":"cytorange","name":"$chr","line":260,"kind":13},{"kind":13,"line":263,"name":"$r","containerName":"cytorange"},{"line":263,"kind":12,"containerName":"cytorange","name":"start"},{"kind":13,"line":263,"containerName":"cytorange","name":"$chr"},{"containerName":"cytorange","name":"$r","kind":13,"line":265},{"kind":12,"line":265,"containerName":"cytorange","name":"start"},{"containerName":"cytorange","name":"$band","line":265,"kind":13},{"containerName":"cytorange","name":"$chr","kind":13,"line":265},{"containerName":"cytorange","name":"$self","line":269,"kind":13},{"containerName":"cytorange","name":"throw","line":269,"kind":12},{"line":271,"kind":13,"containerName":"cytorange","name":"$self"},{"containerName":"cytorange","name":"throw","kind":12,"line":271},{"kind":13,"line":275,"name":"$r","containerName":"cytorange"},{"containerName":"cytorange","name":"end","line":275,"kind":12},{"line":275,"kind":13,"containerName":"cytorange","name":"$chr"},{"name":"$r","containerName":"cytorange","kind":13,"line":277},{"name":"start","containerName":"cytorange","line":277,"kind":12},{"kind":13,"line":277,"containerName":"cytorange","name":"$band"},{"containerName":"cytorange","name":"$chr","kind":13,"line":277},{"line":280,"kind":13,"name":"$r","containerName":"cytorange"},{"line":280,"kind":12,"name":"start","containerName":"cytorange"},{"line":280,"kind":13,"containerName":"cytorange","name":"$band"},{"containerName":"cytorange","name":"$chr","line":280,"kind":13},{"line":283,"kind":13,"containerName":"cytorange","name":"$r"},{"kind":12,"line":283,"name":"start","containerName":"cytorange"},{"containerName":"cytorange","name":"$chr","line":283,"kind":13},{"containerName":"cytorange","name":"$r","line":288,"kind":13},{"name":"start","containerName":"cytorange","kind":12,"line":288},{"line":288,"kind":13,"name":"$chr","containerName":"cytorange"},{"containerName":"cytorange","name":"$r","kind":13,"line":290},{"line":290,"kind":12,"name":"end","containerName":"cytorange"},{"containerName":"cytorange","name":"$band","kind":13,"line":290},{"line":290,"kind":13,"name":"$chr","containerName":"cytorange"},{"containerName":"cytorange","name":"$r","kind":13,"line":293},{"name":"end","containerName":"cytorange","line":293,"kind":12},{"kind":13,"line":293,"name":"$band","containerName":"cytorange"},{"kind":13,"line":293,"containerName":"cytorange","name":"$chr"},{"line":296,"kind":13,"name":"$r","containerName":"cytorange"},{"name":"end","containerName":"cytorange","line":296,"kind":12},{"name":"$chr","containerName":"cytorange","kind":13,"line":296},{"containerName":"cytorange","name":"$self","kind":13,"line":299},{"kind":12,"line":299,"containerName":"cytorange","name":"throw"},{"containerName":"cytorange","name":"$r","line":308,"kind":13},{"kind":12,"line":308,"containerName":"cytorange","name":"new"},{"containerName":"cytorange","name":"$chr","kind":13,"line":308},{"line":309,"kind":13,"name":"$chr","containerName":"cytorange"},{"kind":13,"line":312,"containerName":"cytorange","name":"$r"},{"name":"new","containerName":"cytorange","kind":12,"line":312},{"kind":13,"line":312,"name":"$band","containerName":"cytorange"},{"name":"$chr","containerName":"cytorange","kind":13,"line":312},{"kind":13,"line":313,"name":"$band","containerName":"cytorange"},{"kind":13,"line":313,"name":"$chr","containerName":"cytorange"},{"name":"$r","containerName":"cytorange","line":318,"kind":13},{"line":318,"kind":12,"name":"new","containerName":"cytorange"},{"line":318,"kind":13,"name":"$chr","containerName":"cytorange"},{"name":"$chr","containerName":"cytorange","kind":13,"line":319},{"kind":13,"line":322,"containerName":"cytorange","name":"$r"},{"containerName":"cytorange","name":"new","line":322,"kind":12},{"kind":13,"line":322,"name":"$band","containerName":"cytorange"},{"kind":13,"line":322,"containerName":"cytorange","name":"$chr"},{"line":323,"kind":13,"containerName":"cytorange","name":"$band"},{"containerName":"cytorange","name":"$chr","line":323,"kind":13},{"name":"$self","containerName":"cytorange","kind":13,"line":327},{"name":"throw","containerName":"cytorange","kind":12,"line":327},{"name":"$r","containerName":"cytorange","kind":13,"line":335},{"containerName":"cytorange","name":"new","kind":12,"line":335},{"name":"$chr","containerName":"cytorange","line":335,"kind":13},{"name":"$chr","containerName":"cytorange","line":337,"kind":13},{"name":"$r","containerName":"cytorange","kind":13,"line":340},{"containerName":"cytorange","name":"new","line":340,"kind":12},{"kind":13,"line":340,"name":"$chr","containerName":"cytorange"},{"name":"$chr","containerName":"cytorange","kind":13,"line":342},{"containerName":"cytorange","name":"$r","kind":13,"line":344},{"kind":12,"line":344,"containerName":"cytorange","name":"new"},{"line":344,"kind":13,"name":"$chr","containerName":"cytorange"},{"kind":13,"line":346,"name":"$chr","containerName":"cytorange"},{"name":"$r","containerName":"cytorange","line":353,"kind":13},{"name":"new","containerName":"cytorange","kind":12,"line":353},{"kind":13,"line":353,"name":"$chr","containerName":"cytorange"},{"containerName":"cytorange","name":"$chr","kind":13,"line":355},{"line":358,"kind":13,"name":"$r","containerName":"cytorange"},{"line":359,"kind":13,"name":"$self","containerName":"cytorange"},{"kind":12,"line":359,"containerName":"cytorange","name":"start"},{"kind":13,"line":359,"name":"$r","containerName":"cytorange"},{"line":359,"kind":12,"containerName":"cytorange","name":"start"},{"name":"$self","containerName":"cytorange","kind":13,"line":360},{"line":360,"kind":12,"name":"end","containerName":"cytorange"},{"name":"$r","containerName":"cytorange","kind":13,"line":360},{"line":360,"kind":12,"name":"end","containerName":"cytorange"},{"kind":13,"line":362,"containerName":"cytorange","name":"$r"}]},{"name":"_value","line":159,"kind":12},{"kind":12,"line":160,"name":"_value"},{"name":"_value","kind":12,"line":163},{"kind":12,"line":173,"name":"Bio","containerName":"Range"},{"name":"_pad","kind":12,"line":201},{"name":"_pad","kind":12,"line":201},{"name":"_pad","line":210,"kind":12},{"line":210,"kind":12,"name":"_pad"},{"name":"_pad","line":224,"kind":12},{"line":232,"kind":12,"name":"_pad"},{"line":234,"kind":12,"name":"_pad"},{"name":"_pad","line":238,"kind":12},{"name":"_pad","line":246,"kind":12},{"name":"_pad","kind":12,"line":249},{"kind":12,"line":265,"name":"_pad"},{"name":"_pad","kind":12,"line":277},{"kind":12,"line":280,"name":"_pad"},{"line":290,"kind":12,"name":"_pad"},{"name":"_pad","kind":12,"line":293},{"line":308,"kind":12,"containerName":"Range","name":"Bio"},{"containerName":"Range","name":"Bio","line":312,"kind":12},{"name":"_pad","kind":12,"line":312},{"name":"_pad","line":313,"kind":12},{"kind":12,"line":318,"name":"Bio","containerName":"Range"},{"name":"Bio","containerName":"Range","kind":12,"line":322},{"name":"_pad","line":322,"kind":12},{"line":323,"kind":12,"name":"_pad"},{"containerName":"Range","name":"Bio","line":335,"kind":12},{"containerName":"Range","name":"Bio","kind":12,"line":340},{"kind":12,"line":344,"name":"Bio","containerName":"Range"},{"containerName":"Range","name":"Bio","kind":12,"line":353},{"containerName":"main::","definition":"sub","detail":"($string,$len,$pad_char)","signature":{"label":"_pad($string,$len,$pad_char)","documentation":"","parameters":[{"label":"$string"},{"label":"$len"},{"label":"$pad_char"}]},"kind":12,"line":366,"children":[{"line":367,"kind":13,"localvar":"my","containerName":"_pad","name":"$string","definition":"my"},{"kind":13,"line":367,"name":"$len","containerName":"_pad"},{"containerName":"_pad","name":"$pad_char","line":367,"kind":13},{"containerName":"_pad","name":"throw","line":368,"kind":12},{"kind":13,"line":369,"containerName":"_pad","name":"$len"},{"name":"throw","containerName":"_pad","line":370,"kind":12},{"name":"$pad_char","containerName":"_pad","kind":13,"line":371},{"containerName":"_pad","name":"$string","line":372,"kind":13},{"line":373,"kind":13,"name":"$string","containerName":"_pad"},{"kind":13,"line":373,"name":"$pad_char","containerName":"_pad"},{"name":"$len","containerName":"_pad","line":373,"kind":13},{"kind":13,"line":373,"name":"$string","containerName":"_pad"}],"name":"_pad","range":{"start":{"character":0,"line":366},"end":{"line":374,"character":9999}}},{"detail":"($self,$value)","signature":{"label":"range2value($self,$value)","documentation":"1;\n# $Id: CytoPosition.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::CytoPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::CytoPosition - Marker class with cytogenetic band storing attributes\n\n=head1 SYNOPSIS\n\n  $m1 = Bio::Map::CytoPosition->new ( '-id' => 'A1',\n\t\t\t\t       '-value' => '2q1-3'\n\t\t\t\t\t     );\n  $m2 = Bio::Map::CytoPosition->new ( '-id' => 'A2',\n\t\t\t\t       '-value' => '2q2'\n\t\t\t\t\t     );\n\n  if ($m1->cytorange->overlaps($m2->cytorange)) {\n      print \"Makers overlap\\n\";\n  }\n\n\n=head1 DESCRIPTION\n\nCytoPosition is marker (Bio::Map::MarkerI compliant) with a location in a\ncytogenetic map. See L<Bio::Map::MarkerI> for more information.\n\nCytogenetic locations are names of bands visible in stained mitotic\neucaryotic chromosomes. The naming follows strict rules which are\nconsistant at least in higher vertebates, e.g. mammals. The chromosome\nname preceds the band names.\n\nThe shorter arm of the chromosome is called 'p' ('petit') and usually\ndrawn pointing up. The lower arm is called 'q' ('queue'). The bands\nare named from the region separting these, a centromere (cen), towards\nthe tips or telomeric regions (ter) counting from 1 upwards. Depending\nof the resolution used the bands are identified with one or more\ndigit. The first digit determines the major band and subsequent digits\nsub bands: p1 band can be divided into subbands p11, p12 and 13 and\np11 can furter be divided into subbands p11.1 and p11.2. The dot after\nsecond digit makes it easier to read the values. A region between ands\nis given from the centromere outwards towards the telomere (e.g. 2p2-5\nor 3p21-35) or from a band in the p arm to a band in the q arm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::CytoPosition;\n\nuse strict;\nuse integer;\nuse Bio::Range;\n\nuse base qw(Bio::Map::Position);\n\n=head2 cytorange\n\n Title   : cytorange\n Usage   : my $range = $obj->cytorange();\n Function:\n            Converts cytogenetic location set by value method into\n            an integer range. The chromosome number determines the\n            \"millions\" in the values.  Human X and Y chromosome\n            symbols are represented by values 100 and 101.\n\n            The localization within chromosomes are converted into\n            values between the range of 0 and 200,000:\n\n            pter                    cen                       qter\n            |------------------------|-------------------------|\n            0                     100,000                   200,000\n\n            The values between -100,000 through 0 for centromere to\n            100,000 would have reflected the band numbering better but\n            use of positive integers was choosen since the\n            transformation is very easy. These values are not metric.\n\n            Each band defines a range in a chromosome. A band string\n            is converted into a range by padding it with lower and and\n            higher end digits (for q arm: '0' and '9') to the length\n            of five. The arm and chromosome values are added to these:\n            e.g. 21000 & 21999 (band 21) + 100,000 (q arm) + 2,000,000\n            (chromosome 2) => 2q21 : 2,121,000 .. 2,121,999. Note that\n            this notation breaks down if there is a band or a subband\n            using digit 9 in its name!  This is not the case in human\n            karyotype.\n\n            The full algorithm used for bands:\n\n            if arm is 'q' then\n               pad char for start is '0', for end '9'\n               range is chromosome + 100,000 + padded range start or end\n            elsif arm is 'p' then\n               pad char for start is '9', for end '0'\n               range is chromosome + 100,000 - padded range start or end\n\n Returns : Bio::Range object or undef\n Args    : none\n\n\nsub cytorange {\n    my ($self) = @_;\n    my ($chr, $r, $band, $band2, $arm, $arm2, $lc, $uc, $lcchar, $ucchar);\n\n    return $r if not defined $self->{_value}; # returns undef\n    $self->{_value} =~\n\t#  -----1-----  --------2---------   -----3-----     -------4-------   ---6---\n\tm/([XY]|[0-9]+)(cen|qcen|pcen|[pq])?(ter|[.0-9]+)?-?([pq]?(cen|ter)?)?([.0-9]+)?/;\n    $self->warn(\"Not a valid value: \". $self->{_value}), return $r\n\tif not defined $1 ; # returns undef\n\n    $chr = uc $1;\n    $self->chr($chr);\n\n    $chr = 100 if $chr eq 'X';\n    $chr = 101 if $chr eq 'Y';\n    $chr *= 1000000;\n\n    $r = Bio::Range->new();\n\n    $band = '';\n    if (defined $3 ) {\n\t$2 || $self->throw(\"$& does not make sense: 'arm' or 'cen' missing\");\n\t$band = $3;\n\t$band =~ tr/\\.//d;\n    }\n    if (defined $6 ) {\n\t$arm2 = $4;\n\t$arm2 = $2 if $4 eq ''; # it is not necessary to repeat the arm [p|q]\n\t$band2 = $6;\n\t$band2 =~ tr/\\.//d;\n    \n\t#find the correct order\n    #print STDERR \"-|$&|----2|$2|-----3|$band|---4|$4|--------arm2|$arm2|-------------\\n\";\n\tif ($band ne '' and (defined $arm2 and $2 ne $arm2 and $arm2 eq 'q') ) {\n\t    $lc = 'start'; $lcchar = '9';\n\t    $uc = 'end'; $ucchar = '9';\n\t}\n\telsif ($band ne 'ter' and $2 ne $arm2 and $arm2 eq 'p') {\n\t    $lc = 'end'; $lcchar = '9';\n\t    $uc = 'start'; $ucchar = '9';\n\t}\n\telsif ($band eq 'ter' and  $arm2 eq 'p') {\n\t    $uc = 'start'; $ucchar = '9';\n\t} # $2 eq $arm2\n\telsif ($arm2 eq 'q') {\n\t    if (_pad($band, 5, '0') < _pad($band2, 5, '0')) {\n\t\t$lc = 'start'; $lcchar = '0';\n\t\t$uc = 'end'; $ucchar = '9';\n\t    } else {\n\t\t$lc = 'end'; $lcchar = '9';\n\t\t$uc = 'start'; $ucchar = '0';\t\t\n\t    }\n\t}\n\telsif ($arm2 eq 'p') {\n\t    if (_pad($band, 5, '0') < _pad($band2, 5, '0')) {\n\t\t$lc = 'end'; $lcchar = '0';\n\t\t$uc = 'start'; $ucchar = '9';\n\t    } else {\n\t\t$lc = 'start'; $lcchar = '9';\n\t\t$uc = 'end'; $ucchar = '0';\t\t\n\t    }\n\t}\n\telse {\n\t    $self->throw(\"How did you end up here? $&\");\n\t}\n\n\t#print STDERR \"-------$arm2--------$band2---------$ucchar--------------\\n\";\n\tif ( (defined $arm2 and $arm2 eq 'p') or (defined $arm2 and $arm2 eq 'p') ) {\n\t    $r->$uc(-(_pad($band2, 5, $ucchar)) + 100000 + $chr );\n\t    if (defined $3 and $3 eq 'ter') {\n\t\t$r->end(200000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' or $2 eq 'qcen' or $2 eq 'pcen'){\n\t\t$r->$lc(100000 + $chr);\n\t    } \n\t    elsif ($2 eq 'q') {\n\t\t$r->$lc(_pad($band, 5, $lcchar) + 100000 + $chr );\n\t    } else {\n\t\t$r->$lc(-(_pad($band, 5, $lcchar)) + 100000 + $chr );\n\t    }\n\t} else { #if:$arm2=q e.g. 9p22-q32\n\t    #print STDERR \"-------$arm2--------$band2---------$ucchar--------------\\n\";\n\t    $r->$uc(_pad($band2, 5, $ucchar) +  100000 + $chr);\n\t    if ($2 eq 'cen' or $2 eq 'pcen') {\n\t\t$r->$lc(100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'p') {\n\t\tif ($3 eq 'ter') {\n\t\t    $r->$lc(200000 + $chr);\n\t\t} else {\n\t\t    $r->$lc(-(_pad($band, 5, $lcchar)) + 100000 + $chr);\n\t\t}\n\t    } else { #$2.==q\n\t\t$r->$lc(_pad($band, 5, $lcchar) + 100000 + $chr);\n\t    }\n\t}\n    }\n    #\n    # e.g. 10p22.1-cen\n    #\n    elsif (defined $4 and $4 ne '') {\n\t#print STDERR \"$4-----$&----\\n\";\n\tif ($4 eq 'cen' || $4 eq 'qcen' || $4 eq 'pcen') { # e.g. 10p22.1-cen;\n\t    # '10pcen-qter' does not really make sense but lets have it in anyway\n\t    $r->end(100000 + $chr);\n\t    if ($2 eq 'p') {\n\t\tif ($3 eq 'ter') {\n\t\t    $r->start($chr);\n\t\t} else {\n\t\t    $r->start(_pad($band, 5, '9') + $chr);\n\t\t}\n\t    }\n\t    elsif ($2 eq 'cen') {\n\t\t$self->throw(\"'cen-cen' does not make sense: $&\");\n\t    } else {\n\t\t$self->throw(\"Only order p-cen is valid: $&\");\n\t    }\n\t}\n\telsif ($4 eq 'qter' || $4 eq 'ter') { # e.g. 10p22.1-qter, 1p21-qter, 10pcen-qter, 7q34-qter\n\t    $r->end(200000 + $chr);\n\t    if ($2 eq 'p'){\n\t\t$r->start(-(_pad($band, 5, '9')) + 100000 + $chr); #??? OK?\n\t    }\n\t    elsif ($2 eq 'q') {\n\t\t$r->start(_pad($band, 5, '0') + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' || $2 eq 'qcen' || $2 eq 'pcen' ) {\n\t\t$r->start(100000 + $chr);\n\t    }\n\t}\n\telsif ($4 eq 'pter' ) {\n\t    #print STDERR \"$2,$3--$4-----$&----\\n\";\n\t    $r->start( $chr);\n\t     if ($2 eq 'p'){\n\t\t$r->end(-(_pad($band, 5, '0')) + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'q') {\n\t\t$r->end(_pad($band, 5, '9') + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' || $2 eq 'qcen' || $2 eq 'pcen' ) {\n\t\t$r->end(100000 + $chr);\n\t    }\n\t} else { # -p or -q at the end of the range\n\t    $self->throw(\"lone '$4' in $& does not make sense\");\n\t}\n    }\n    #\n    #  e.g 10p22.1, 10pter\n    #\n    elsif (defined $3 ) {\n\tif ($2 eq 'p') {\n\t    if ($3 eq 'ter') { # e.g. 10pter\n\t\t$r = Bio::Range->new('-start' => $chr,\n\t\t\t\t    '-end' => $chr,\n\t\t\t\t    );\n\t    } else { # e.g 10p22.1\n\t\t$r = Bio::Range->new('-start' => -(_pad($band, 5, '9')) + 100000 + $chr,\n\t\t\t\t    '-end' => -(_pad($band, 5, '0')) + 100000 + $chr,\n\t\t\t\t    );\n\t    }\n\t} elsif ($2 eq 'q') {\n\t    if ($3 eq 'ter') { # e.g. 10qter\n\t\t$r = Bio::Range->new('-start' => 200000 + $chr,\n\t\t\t\t    '-end' => 200000 + $chr,\n\t\t\t\t    );\n\t    } else { # e.g 10q22.1\n\t\t$r = Bio::Range->new('-start' => _pad($band, 5, '0') + 100000 + $chr,\n\t\t\t\t    '-end' => _pad($band, 5, '9') + 100000 + $chr,\n\t\t\t\t    );\n\t    }\n\t} else { # e.g. 10qcen1.1 !\n\t    $self->throw(\"'cen' in $& does not make sense\");\n\t}\n    }\n    #\n    # e.g. 10p\n    #\n    elsif (defined $2 ) { # e.g. 10p\n\tif ($2 eq 'p' ) {\n\t    $r = Bio::Range->new('-start' => $chr,\n\t\t\t\t'-end' => 100000  + $chr\n\t\t\t\t);\n\t}\n\telsif ($2 eq 'q' )  {\n\t    $r = Bio::Range->new('-start' => 100000 + $chr,\n\t\t\t\t'-end' => 200000 + $chr\n\t\t\t\t);\n\t} else { # $2 eq 'cen' || 'qcen'\n\t    $r = Bio::Range->new('-start' => 100000 + $chr,\n\t\t\t\t'-end' => 100000 + $chr\n\t\t\t\t);\n\t}\n    }\n    #\n    # chr only, e.g. X\n    #\n    else {\n\t$r = Bio::Range->new('-start' => $chr,\n\t\t\t    '-end' => 200000 + $chr\n\t\t\t    );\n    }\n    \n    if ($r) {\n        $self->start($r->start);\n        $self->end($r->end);\n    }\n    return $r;\n}\n\n\nsub _pad {\n    my ($string, $len, $pad_char) = @_;\n    __PACKAGE__->throw(\"function _pad needs a positive integer length, not [$len]\") \n\tunless $len =~ /^\\+?\\d+$/;\n    __PACKAGE__->throw(\"function _pad needs a single character pad_char, not [$pad_char]\") \n\tunless length $pad_char == 1;\n    $string ||= '';\n    return $string . $pad_char x ( $len - length( $string ) );\n}\n\n=head2 range2value\n\n Title   : range2value\n Usage   : my $value = $obj->range2value($range);\n Function: Sets and returns the value string based on start and end values of\n           the Bio::Range object passes as an argument.\n Returns : string or false\n Args    : Bio::Range object","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","line":387,"children":[{"line":388,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"range2value"},{"kind":13,"line":388,"containerName":"range2value","name":"$value"},{"containerName":"range2value","name":"$value","line":389,"kind":13},{"containerName":"range2value","name":"$value","kind":13,"line":390},{"line":390,"kind":12,"name":"isa","containerName":"range2value"},{"name":"$self","containerName":"range2value","kind":13,"line":391},{"name":"throw","containerName":"range2value","line":391,"kind":12},{"kind":13,"line":394,"name":"$value","containerName":"range2value"},{"line":394,"kind":12,"name":"start","containerName":"range2value"},{"name":"$self","containerName":"range2value","line":395,"kind":13},{"name":"throw","containerName":"range2value","kind":12,"line":395},{"containerName":"range2value","name":"$value","kind":13,"line":398},{"containerName":"range2value","name":"end","kind":12,"line":398},{"name":"$self","containerName":"range2value","line":399,"kind":13},{"name":"throw","containerName":"range2value","line":399,"kind":12},{"name":"$value","containerName":"range2value","kind":13,"line":402},{"name":"start","containerName":"range2value","line":402,"kind":12},{"containerName":"range2value","name":"$self","kind":13,"line":403},{"kind":12,"line":403,"containerName":"range2value","name":"throw"},{"kind":13,"line":403,"name":"$value","containerName":"range2value"},{"name":"start","containerName":"range2value","line":403,"kind":12},{"name":"$value","containerName":"range2value","line":406,"kind":13},{"containerName":"range2value","name":"end","line":406,"kind":12},{"kind":13,"line":407,"name":"$self","containerName":"range2value"},{"kind":12,"line":407,"containerName":"range2value","name":"throw"},{"kind":13,"line":407,"name":"$value","containerName":"range2value"},{"containerName":"range2value","name":"end","kind":12,"line":407},{"kind":13,"line":411,"name":"$chr","definition":"my","containerName":"range2value","localvar":"my"},{"kind":13,"line":411,"name":"$arm","containerName":"range2value"},{"name":"$band","containerName":"range2value","line":411,"kind":13},{"kind":13,"line":411,"containerName":"range2value","name":"$value"},{"kind":12,"line":411,"containerName":"range2value","name":"start"},{"name":"$chr2","definition":"my","containerName":"range2value","localvar":"my","kind":13,"line":412},{"name":"$arm2","containerName":"range2value","kind":13,"line":412},{"name":"$band2","containerName":"range2value","kind":13,"line":412},{"containerName":"range2value","name":"$value","line":412,"kind":13},{"kind":12,"line":412,"name":"end","containerName":"range2value"},{"containerName":"range2value","name":"$chrS","definition":"my","localvar":"my","kind":13,"line":414},{"line":414,"kind":13,"name":"$armS","containerName":"range2value"},{"line":414,"kind":13,"containerName":"range2value","name":"$bandS"},{"line":414,"kind":13,"name":"$arm2S","containerName":"range2value"},{"line":414,"kind":13,"name":"$band2S","containerName":"range2value"},{"kind":13,"line":414,"containerName":"range2value","name":"$sep"},{"line":419,"kind":13,"containerName":"range2value","name":"$chr"},{"line":420,"kind":13,"name":"$chrS","containerName":"range2value"},{"line":422,"kind":13,"containerName":"range2value","name":"$chr"},{"kind":13,"line":423,"containerName":"range2value","name":"$chrS"},{"kind":13,"line":425,"name":"$chrS","containerName":"range2value"},{"name":"$chr","containerName":"range2value","kind":13,"line":425},{"name":"$arm","containerName":"range2value","line":427,"kind":13},{"kind":13,"line":427,"containerName":"range2value","name":"$arm2"},{"containerName":"range2value","name":"$band","line":427,"kind":13},{"containerName":"range2value","name":"$band2","line":427,"kind":13},{"kind":13,"line":431,"containerName":"range2value","name":"$arm"},{"line":431,"kind":13,"containerName":"range2value","name":"$arm2"},{"kind":13,"line":432,"name":"$arm","containerName":"range2value"},{"line":433,"kind":13,"containerName":"range2value","name":"$armS"},{"containerName":"range2value","name":"$bandS","kind":13,"line":435},{"name":"$band","containerName":"range2value","line":435,"kind":13},{"line":438,"kind":13,"name":"$arm","containerName":"range2value"},{"containerName":"range2value","name":"$armS","line":439,"kind":13},{"name":"$bandS","containerName":"range2value","kind":13,"line":440},{"line":440,"kind":13,"name":"$band","containerName":"range2value"},{"line":442,"kind":13,"containerName":"range2value","name":"$armS"},{"containerName":"range2value","name":"$armS","kind":13,"line":444},{"containerName":"range2value","name":"$band","line":444,"kind":13},{"kind":13,"line":447,"name":"$arm","containerName":"range2value"},{"line":448,"kind":13,"name":"$armS","containerName":"range2value"},{"line":449,"kind":13,"name":"$arm2S","containerName":"range2value"},{"line":450,"kind":13,"containerName":"range2value","name":"$arm2S"},{"containerName":"range2value","name":"$band","line":450,"kind":13},{"containerName":"range2value","name":"$band2","kind":13,"line":450},{"containerName":"range2value","name":"$armS","kind":13,"line":452},{"name":"$arm2S","containerName":"range2value","kind":13,"line":453},{"kind":13,"line":454,"name":"$arm2S","containerName":"range2value"},{"containerName":"range2value","name":"$arm2","kind":13,"line":454},{"line":454,"kind":13,"containerName":"range2value","name":"$band"},{"containerName":"range2value","name":"$band2","line":454,"kind":13},{"containerName":"range2value","name":"$band","line":457,"kind":13},{"containerName":"range2value","name":"$band2","kind":13,"line":457},{"kind":13,"line":458,"name":"$c","definition":"my","containerName":"range2value","localvar":"my"},{"containerName":"range2value","name":"$bandS","kind":13,"line":462},{"name":"$armS","containerName":"range2value","line":463,"kind":13},{"containerName":"range2value","name":"$band","line":464,"kind":13},{"containerName":"range2value","name":"$band","kind":13,"line":464},{"line":465,"kind":13,"name":"$c","containerName":"range2value"},{"line":467,"kind":13,"containerName":"range2value","name":"$c"},{"kind":13,"line":469,"containerName":"range2value","name":"$band"},{"name":"$bandS","containerName":"range2value","line":470,"kind":13},{"name":"$band","containerName":"range2value","kind":13,"line":470},{"containerName":"range2value","name":"$bandS","line":471,"kind":13},{"kind":13,"line":471,"name":"$band","containerName":"range2value"},{"name":"$band","containerName":"range2value","line":471,"kind":13},{"name":"$band","containerName":"range2value","kind":13,"line":471},{"kind":13,"line":473,"name":"$band2","containerName":"range2value"},{"name":"$arm2","containerName":"range2value","kind":13,"line":477},{"name":"$arm2S","containerName":"range2value","line":478,"kind":13},{"line":479,"kind":13,"containerName":"range2value","name":"$band2"},{"name":"$band2","containerName":"range2value","line":479,"kind":13},{"containerName":"range2value","name":"$c","kind":13,"line":480},{"containerName":"range2value","name":"$arm2S","line":482,"kind":13},{"kind":13,"line":483,"name":"$c","containerName":"range2value"},{"line":485,"kind":13,"name":"$band2","containerName":"range2value"},{"line":486,"kind":13,"name":"$arm2","containerName":"range2value"},{"name":"$arm2S","containerName":"range2value","kind":13,"line":487},{"line":488,"kind":13,"containerName":"range2value","name":"$band2S"},{"containerName":"range2value","name":"$band2S","line":490,"kind":13},{"kind":13,"line":494,"containerName":"range2value","name":"$band"},{"containerName":"range2value","name":"$band2","line":494,"kind":13},{"line":494,"kind":13,"name":"$arm","containerName":"range2value"},{"kind":13,"line":494,"name":"$arm2","containerName":"range2value"},{"line":496,"kind":13,"name":"$band2","containerName":"range2value"},{"containerName":"range2value","name":"$band2S","kind":13,"line":497},{"line":497,"kind":13,"containerName":"range2value","name":"$band2"},{"kind":13,"line":498,"containerName":"range2value","name":"$band2S"},{"containerName":"range2value","name":"$band2","line":498,"kind":13},{"name":"$band2","containerName":"range2value","kind":13,"line":498},{"name":"$band2","containerName":"range2value","kind":13,"line":498},{"containerName":"range2value","name":"$armS","line":502,"kind":13},{"name":"$arm2S","containerName":"range2value","kind":13,"line":502},{"kind":13,"line":503,"definition":"my","name":"$tmp","containerName":"range2value","localvar":"my"},{"kind":13,"line":503,"containerName":"range2value","name":"$band2S"},{"containerName":"range2value","name":"$band2S","line":504,"kind":13},{"name":"$bandS","containerName":"range2value","line":504,"kind":13},{"name":"$bandS","containerName":"range2value","kind":13,"line":505},{"name":"$tmp","containerName":"range2value","line":505,"kind":13},{"name":"$band2S","containerName":"range2value","kind":13,"line":507},{"containerName":"range2value","name":"$bandS","kind":13,"line":507},{"kind":13,"line":507,"containerName":"range2value","name":"$band2S"},{"name":"$armS","containerName":"range2value","line":508,"kind":13},{"name":"$bandS","containerName":"range2value","line":508,"kind":13},{"name":"$arm2S","containerName":"range2value","kind":13,"line":509},{"line":509,"kind":13,"containerName":"range2value","name":"$armS"},{"containerName":"range2value","name":"$arm2S","line":509,"kind":13},{"kind":13,"line":509,"containerName":"range2value","name":"$band2S"},{"line":510,"kind":13,"containerName":"range2value","name":"$sep"},{"containerName":"range2value","name":"$arm2S","kind":13,"line":510},{"line":510,"kind":13,"containerName":"range2value","name":"$band2S"},{"name":"$self","containerName":"range2value","line":511,"kind":13},{"containerName":"range2value","name":"value","kind":12,"line":511},{"kind":13,"line":511,"name":"$chrS","containerName":"range2value"},{"name":"$armS","containerName":"range2value","kind":13,"line":511},{"containerName":"range2value","name":"$bandS","kind":13,"line":511},{"containerName":"range2value","name":"$sep","kind":13,"line":511},{"containerName":"range2value","name":"$arm2S","kind":13,"line":511},{"line":511,"kind":13,"name":"$band2S","containerName":"range2value"},{"name":"$self","containerName":"range2value","line":513,"kind":13},{"line":513,"kind":12,"containerName":"range2value","name":"value"}],"kind":12,"range":{"start":{"character":0,"line":387},"end":{"line":514,"character":9999}},"name":"range2value"},{"name":"LOC","line":415,"kind":12},{"name":"LOC","kind":12,"line":427},{"name":"LOC","line":457,"kind":12},{"kind":12,"line":473,"name":"LOC"},{"kind":12,"line":492,"name":"LOC"},{"name":"LOC","kind":12,"line":494},{"name":"value","range":{"start":{"character":0,"line":526},"end":{"character":9999,"line":533}},"kind":12,"children":[{"kind":13,"line":527,"containerName":"value","definition":"my","name":"$self","localvar":"my"},{"containerName":"value","name":"$value","line":527,"kind":13},{"containerName":"value","name":"$value","line":528,"kind":13},{"kind":13,"line":529,"name":"$self","containerName":"value"},{"name":"$value","containerName":"value","kind":13,"line":529},{"line":530,"kind":13,"name":"$self","containerName":"value"},{"line":530,"kind":12,"name":"cytorange","containerName":"value"},{"line":532,"kind":13,"containerName":"value","name":"$self"}],"line":526,"definition":"sub","containerName":"main::","signature":{"label":"value($self,$value)","documentation":"1;\n# $Id: CytoPosition.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::CytoPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::CytoPosition - Marker class with cytogenetic band storing attributes\n\n=head1 SYNOPSIS\n\n  $m1 = Bio::Map::CytoPosition->new ( '-id' => 'A1',\n\t\t\t\t       '-value' => '2q1-3'\n\t\t\t\t\t     );\n  $m2 = Bio::Map::CytoPosition->new ( '-id' => 'A2',\n\t\t\t\t       '-value' => '2q2'\n\t\t\t\t\t     );\n\n  if ($m1->cytorange->overlaps($m2->cytorange)) {\n      print \"Makers overlap\\n\";\n  }\n\n\n=head1 DESCRIPTION\n\nCytoPosition is marker (Bio::Map::MarkerI compliant) with a location in a\ncytogenetic map. See L<Bio::Map::MarkerI> for more information.\n\nCytogenetic locations are names of bands visible in stained mitotic\neucaryotic chromosomes. The naming follows strict rules which are\nconsistant at least in higher vertebates, e.g. mammals. The chromosome\nname preceds the band names.\n\nThe shorter arm of the chromosome is called 'p' ('petit') and usually\ndrawn pointing up. The lower arm is called 'q' ('queue'). The bands\nare named from the region separting these, a centromere (cen), towards\nthe tips or telomeric regions (ter) counting from 1 upwards. Depending\nof the resolution used the bands are identified with one or more\ndigit. The first digit determines the major band and subsequent digits\nsub bands: p1 band can be divided into subbands p11, p12 and 13 and\np11 can furter be divided into subbands p11.1 and p11.2. The dot after\nsecond digit makes it easier to read the values. A region between ands\nis given from the centromere outwards towards the telomere (e.g. 2p2-5\nor 3p21-35) or from a band in the p arm to a band in the q arm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::CytoPosition;\n\nuse strict;\nuse integer;\nuse Bio::Range;\n\nuse base qw(Bio::Map::Position);\n\n=head2 cytorange\n\n Title   : cytorange\n Usage   : my $range = $obj->cytorange();\n Function:\n            Converts cytogenetic location set by value method into\n            an integer range. The chromosome number determines the\n            \"millions\" in the values.  Human X and Y chromosome\n            symbols are represented by values 100 and 101.\n\n            The localization within chromosomes are converted into\n            values between the range of 0 and 200,000:\n\n            pter                    cen                       qter\n            |------------------------|-------------------------|\n            0                     100,000                   200,000\n\n            The values between -100,000 through 0 for centromere to\n            100,000 would have reflected the band numbering better but\n            use of positive integers was choosen since the\n            transformation is very easy. These values are not metric.\n\n            Each band defines a range in a chromosome. A band string\n            is converted into a range by padding it with lower and and\n            higher end digits (for q arm: '0' and '9') to the length\n            of five. The arm and chromosome values are added to these:\n            e.g. 21000 & 21999 (band 21) + 100,000 (q arm) + 2,000,000\n            (chromosome 2) => 2q21 : 2,121,000 .. 2,121,999. Note that\n            this notation breaks down if there is a band or a subband\n            using digit 9 in its name!  This is not the case in human\n            karyotype.\n\n            The full algorithm used for bands:\n\n            if arm is 'q' then\n               pad char for start is '0', for end '9'\n               range is chromosome + 100,000 + padded range start or end\n            elsif arm is 'p' then\n               pad char for start is '9', for end '0'\n               range is chromosome + 100,000 - padded range start or end\n\n Returns : Bio::Range object or undef\n Args    : none\n\n\nsub cytorange {\n    my ($self) = @_;\n    my ($chr, $r, $band, $band2, $arm, $arm2, $lc, $uc, $lcchar, $ucchar);\n\n    return $r if not defined $self->{_value}; # returns undef\n    $self->{_value} =~\n\t#  -----1-----  --------2---------   -----3-----     -------4-------   ---6---\n\tm/([XY]|[0-9]+)(cen|qcen|pcen|[pq])?(ter|[.0-9]+)?-?([pq]?(cen|ter)?)?([.0-9]+)?/;\n    $self->warn(\"Not a valid value: \". $self->{_value}), return $r\n\tif not defined $1 ; # returns undef\n\n    $chr = uc $1;\n    $self->chr($chr);\n\n    $chr = 100 if $chr eq 'X';\n    $chr = 101 if $chr eq 'Y';\n    $chr *= 1000000;\n\n    $r = Bio::Range->new();\n\n    $band = '';\n    if (defined $3 ) {\n\t$2 || $self->throw(\"$& does not make sense: 'arm' or 'cen' missing\");\n\t$band = $3;\n\t$band =~ tr/\\.//d;\n    }\n    if (defined $6 ) {\n\t$arm2 = $4;\n\t$arm2 = $2 if $4 eq ''; # it is not necessary to repeat the arm [p|q]\n\t$band2 = $6;\n\t$band2 =~ tr/\\.//d;\n    \n\t#find the correct order\n    #print STDERR \"-|$&|----2|$2|-----3|$band|---4|$4|--------arm2|$arm2|-------------\\n\";\n\tif ($band ne '' and (defined $arm2 and $2 ne $arm2 and $arm2 eq 'q') ) {\n\t    $lc = 'start'; $lcchar = '9';\n\t    $uc = 'end'; $ucchar = '9';\n\t}\n\telsif ($band ne 'ter' and $2 ne $arm2 and $arm2 eq 'p') {\n\t    $lc = 'end'; $lcchar = '9';\n\t    $uc = 'start'; $ucchar = '9';\n\t}\n\telsif ($band eq 'ter' and  $arm2 eq 'p') {\n\t    $uc = 'start'; $ucchar = '9';\n\t} # $2 eq $arm2\n\telsif ($arm2 eq 'q') {\n\t    if (_pad($band, 5, '0') < _pad($band2, 5, '0')) {\n\t\t$lc = 'start'; $lcchar = '0';\n\t\t$uc = 'end'; $ucchar = '9';\n\t    } else {\n\t\t$lc = 'end'; $lcchar = '9';\n\t\t$uc = 'start'; $ucchar = '0';\t\t\n\t    }\n\t}\n\telsif ($arm2 eq 'p') {\n\t    if (_pad($band, 5, '0') < _pad($band2, 5, '0')) {\n\t\t$lc = 'end'; $lcchar = '0';\n\t\t$uc = 'start'; $ucchar = '9';\n\t    } else {\n\t\t$lc = 'start'; $lcchar = '9';\n\t\t$uc = 'end'; $ucchar = '0';\t\t\n\t    }\n\t}\n\telse {\n\t    $self->throw(\"How did you end up here? $&\");\n\t}\n\n\t#print STDERR \"-------$arm2--------$band2---------$ucchar--------------\\n\";\n\tif ( (defined $arm2 and $arm2 eq 'p') or (defined $arm2 and $arm2 eq 'p') ) {\n\t    $r->$uc(-(_pad($band2, 5, $ucchar)) + 100000 + $chr );\n\t    if (defined $3 and $3 eq 'ter') {\n\t\t$r->end(200000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' or $2 eq 'qcen' or $2 eq 'pcen'){\n\t\t$r->$lc(100000 + $chr);\n\t    } \n\t    elsif ($2 eq 'q') {\n\t\t$r->$lc(_pad($band, 5, $lcchar) + 100000 + $chr );\n\t    } else {\n\t\t$r->$lc(-(_pad($band, 5, $lcchar)) + 100000 + $chr );\n\t    }\n\t} else { #if:$arm2=q e.g. 9p22-q32\n\t    #print STDERR \"-------$arm2--------$band2---------$ucchar--------------\\n\";\n\t    $r->$uc(_pad($band2, 5, $ucchar) +  100000 + $chr);\n\t    if ($2 eq 'cen' or $2 eq 'pcen') {\n\t\t$r->$lc(100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'p') {\n\t\tif ($3 eq 'ter') {\n\t\t    $r->$lc(200000 + $chr);\n\t\t} else {\n\t\t    $r->$lc(-(_pad($band, 5, $lcchar)) + 100000 + $chr);\n\t\t}\n\t    } else { #$2.==q\n\t\t$r->$lc(_pad($band, 5, $lcchar) + 100000 + $chr);\n\t    }\n\t}\n    }\n    #\n    # e.g. 10p22.1-cen\n    #\n    elsif (defined $4 and $4 ne '') {\n\t#print STDERR \"$4-----$&----\\n\";\n\tif ($4 eq 'cen' || $4 eq 'qcen' || $4 eq 'pcen') { # e.g. 10p22.1-cen;\n\t    # '10pcen-qter' does not really make sense but lets have it in anyway\n\t    $r->end(100000 + $chr);\n\t    if ($2 eq 'p') {\n\t\tif ($3 eq 'ter') {\n\t\t    $r->start($chr);\n\t\t} else {\n\t\t    $r->start(_pad($band, 5, '9') + $chr);\n\t\t}\n\t    }\n\t    elsif ($2 eq 'cen') {\n\t\t$self->throw(\"'cen-cen' does not make sense: $&\");\n\t    } else {\n\t\t$self->throw(\"Only order p-cen is valid: $&\");\n\t    }\n\t}\n\telsif ($4 eq 'qter' || $4 eq 'ter') { # e.g. 10p22.1-qter, 1p21-qter, 10pcen-qter, 7q34-qter\n\t    $r->end(200000 + $chr);\n\t    if ($2 eq 'p'){\n\t\t$r->start(-(_pad($band, 5, '9')) + 100000 + $chr); #??? OK?\n\t    }\n\t    elsif ($2 eq 'q') {\n\t\t$r->start(_pad($band, 5, '0') + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' || $2 eq 'qcen' || $2 eq 'pcen' ) {\n\t\t$r->start(100000 + $chr);\n\t    }\n\t}\n\telsif ($4 eq 'pter' ) {\n\t    #print STDERR \"$2,$3--$4-----$&----\\n\";\n\t    $r->start( $chr);\n\t     if ($2 eq 'p'){\n\t\t$r->end(-(_pad($band, 5, '0')) + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'q') {\n\t\t$r->end(_pad($band, 5, '9') + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' || $2 eq 'qcen' || $2 eq 'pcen' ) {\n\t\t$r->end(100000 + $chr);\n\t    }\n\t} else { # -p or -q at the end of the range\n\t    $self->throw(\"lone '$4' in $& does not make sense\");\n\t}\n    }\n    #\n    #  e.g 10p22.1, 10pter\n    #\n    elsif (defined $3 ) {\n\tif ($2 eq 'p') {\n\t    if ($3 eq 'ter') { # e.g. 10pter\n\t\t$r = Bio::Range->new('-start' => $chr,\n\t\t\t\t    '-end' => $chr,\n\t\t\t\t    );\n\t    } else { # e.g 10p22.1\n\t\t$r = Bio::Range->new('-start' => -(_pad($band, 5, '9')) + 100000 + $chr,\n\t\t\t\t    '-end' => -(_pad($band, 5, '0')) + 100000 + $chr,\n\t\t\t\t    );\n\t    }\n\t} elsif ($2 eq 'q') {\n\t    if ($3 eq 'ter') { # e.g. 10qter\n\t\t$r = Bio::Range->new('-start' => 200000 + $chr,\n\t\t\t\t    '-end' => 200000 + $chr,\n\t\t\t\t    );\n\t    } else { # e.g 10q22.1\n\t\t$r = Bio::Range->new('-start' => _pad($band, 5, '0') + 100000 + $chr,\n\t\t\t\t    '-end' => _pad($band, 5, '9') + 100000 + $chr,\n\t\t\t\t    );\n\t    }\n\t} else { # e.g. 10qcen1.1 !\n\t    $self->throw(\"'cen' in $& does not make sense\");\n\t}\n    }\n    #\n    # e.g. 10p\n    #\n    elsif (defined $2 ) { # e.g. 10p\n\tif ($2 eq 'p' ) {\n\t    $r = Bio::Range->new('-start' => $chr,\n\t\t\t\t'-end' => 100000  + $chr\n\t\t\t\t);\n\t}\n\telsif ($2 eq 'q' )  {\n\t    $r = Bio::Range->new('-start' => 100000 + $chr,\n\t\t\t\t'-end' => 200000 + $chr\n\t\t\t\t);\n\t} else { # $2 eq 'cen' || 'qcen'\n\t    $r = Bio::Range->new('-start' => 100000 + $chr,\n\t\t\t\t'-end' => 100000 + $chr\n\t\t\t\t);\n\t}\n    }\n    #\n    # chr only, e.g. X\n    #\n    else {\n\t$r = Bio::Range->new('-start' => $chr,\n\t\t\t    '-end' => 200000 + $chr\n\t\t\t    );\n    }\n    \n    if ($r) {\n        $self->start($r->start);\n        $self->end($r->end);\n    }\n    return $r;\n}\n\n\nsub _pad {\n    my ($string, $len, $pad_char) = @_;\n    __PACKAGE__->throw(\"function _pad needs a positive integer length, not [$len]\") \n\tunless $len =~ /^\\+?\\d+$/;\n    __PACKAGE__->throw(\"function _pad needs a single character pad_char, not [$pad_char]\") \n\tunless length $pad_char == 1;\n    $string ||= '';\n    return $string . $pad_char x ( $len - length( $string ) );\n}\n\n=head2 range2value\n\n Title   : range2value\n Usage   : my $value = $obj->range2value($range);\n Function: Sets and returns the value string based on start and end values of\n           the Bio::Range object passes as an argument.\n Returns : string or false\n Args    : Bio::Range object\n\n\nsub range2value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif( ! $value->isa('Bio::Range') ) {\n\t    $self->throw(\"Is not a Bio::Range object but a [$value]\");\n\t    return;\n\t}\n\tif( ! $value->start ) {\n\t    $self->throw(\"Start is not defined in [$value]\");\n\t    return;\n\t}\n\tif( ! $value->end ) {\n\t    $self->throw(\"End is not defined in [$value]\");\n\t    return;\n\t}\n\tif( $value->start < 100000 ) {\n\t    $self->throw(\"Start value has to be in millions, not \". $value->start);\n\t    return;\n\t}\n\tif( $value->end < 100000 ) {\n\t    $self->throw(\"End value has to be in millions, not \". $value->end);\n\t    return;\n\t}\n\n\tmy ($chr, $arm, $band) = $value->start =~ /(\\d+)(\\d)(\\d{5})/;\t\n\tmy ($chr2, $arm2, $band2) = $value->end =~ /(\\d+)(\\d)(\\d{5})/;\t\n\n\tmy ($chrS, $armS, $bandS, $arm2S, $band2S, $sep) = ('', '', '', '', '', '' );\n      LOC: {\n\t  #\n\t  # chromosome\n\t  #\n\t  if ($chr == 100) {\n\t      $chrS = 'X';\n\t  }\n\t  elsif ($chr == 100) {\n\t      $chrS = 'Y';\n\t  } else {\n\t      $chrS = $chr;\n\t  }\n\t  last LOC if  $arm == 0 and $arm2 == 2 and $band == 0 and $band2 == 0 ;\n\t  #\n\t  # arm\n\t  #\n\t  if ($arm == $arm2 ) {\n\t      if ($arm == 0) {\n\t\t  $armS = 'p';\n\t\t  #$armS = 'pter' if $band == 0 and $band2 == 0;\n\t\t  $bandS = 'ter' if $band == 0;\n\t\t  #$arm2S = 'p'; #?\n\t      }\n\t      elsif ($arm == 2) {\n\t\t  $armS = 'q';\n\t\t  $bandS = 'ter' if $band == 0;\n\t      } else {\n\t\t  $armS = 'q';\n\t\t  #$arm2S = 'q'; #?\n\t\t  $armS = 'cen',  if $band == 0;# and $band2 == 0;\n\t      }\n\t  } else {\n\t      if ($arm == 0) {\n\t\t  $armS = 'p';\n\t\t  $arm2S = 'q';\n\t\t  $arm2S = '' if $band == 0 and $band2 == 0;\n\t      } else {\n\t\t  $armS = 'q';\n\t\t  $arm2S = 'p';\n\t\t  $arm2S = '' if $arm2 == 2 and $band == 0 and $band2 == 0;\n\t      }\n\t  }\n\t  last LOC if $band == $band2 ;\n\t  my $c;\n\t  #\n\t  # first band (ter is hadled with the arm)\n\t  #\n\t  if ($bandS ne 'ter') {\n\t      if ($armS eq 'p') {\n\t\t  $band = 100000 - $band;\n\t\t  $c = '9';\n\t      } else {\n\t\t  $c = '0';\n\t      }\n\t      $band =~ s/$c+$//; \n\t      $bandS = $band;\n\t      $bandS = substr($band, 0, 2). '.'. substr($band, 2) if length $band > 2;\n\t  }\n\t  last LOC unless $band2;\n\t  #\n\t  # second band\n\t  #\n\t  if ($arm2 == 0) {\n\t      $arm2S = 'p';\n\t      $band2 = 100000 - $band2;\n\t      $c = '0';\n\t  } else { # 1 or 2\n\t      $arm2S = 'q';\n\t      $c = '9';\n\t  }\n\t  if ($band2 == 0) {\n\t      if ($arm2 == 1) {\n\t\t  $arm2S = 'p';\n\t\t  $band2S = 'cen';\n\t      } else {\n\t\t  $band2S = 'ter';\n\t      }\n\t      last LOC;\n\t  }\n\t  last LOC if $band eq $band2 and $arm == $arm2;\n\n\t  $band2 =~ s/$c+$//; \n\t  $band2S = $band2;\n\t  $band2S = substr($band2, 0, 2). '.'. substr($band2, 2) if length $band2 > 2;\n\n      } # end of LOC:\n\n\tif ($armS eq 'p' and $arm2S eq 'p') {\n\t    my $tmp = $band2S;\n\t    $band2S = $bandS;\n\t    $bandS = $tmp;\n\t}\n\t$band2S = '' if $bandS eq $band2S ;\n\t$armS = '' if $bandS eq 'cen';\n\t$arm2S = '' if $armS eq $arm2S and $band2S ne 'ter';\n\t$sep = '-' if $arm2S || $band2S;\n\t$self->value( $chrS. $armS. $bandS. $sep. $arm2S. $band2S);\n    }\n   return $self->value;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : none to get, OR scalar to set","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)"},{"kind":12,"children":[{"line":547,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"numeric"},{"name":"$self","containerName":"numeric","kind":13,"line":548},{"name":"start","containerName":"numeric","line":548,"kind":12}],"line":546,"definition":"sub","name":"numeric","containerName":"main::","range":{"start":{"character":0,"line":546},"end":{"character":9999,"line":549}}},{"containerName":"main::","definition":"sub","detail":"($self,$chr)","signature":{"label":"chr($self,$chr)","parameters":[{"label":"$self"},{"label":"$chr"}],"documentation":"1;\n# $Id: CytoPosition.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::CytoPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::CytoPosition - Marker class with cytogenetic band storing attributes\n\n=head1 SYNOPSIS\n\n  $m1 = Bio::Map::CytoPosition->new ( '-id' => 'A1',\n\t\t\t\t       '-value' => '2q1-3'\n\t\t\t\t\t     );\n  $m2 = Bio::Map::CytoPosition->new ( '-id' => 'A2',\n\t\t\t\t       '-value' => '2q2'\n\t\t\t\t\t     );\n\n  if ($m1->cytorange->overlaps($m2->cytorange)) {\n      print \"Makers overlap\\n\";\n  }\n\n\n=head1 DESCRIPTION\n\nCytoPosition is marker (Bio::Map::MarkerI compliant) with a location in a\ncytogenetic map. See L<Bio::Map::MarkerI> for more information.\n\nCytogenetic locations are names of bands visible in stained mitotic\neucaryotic chromosomes. The naming follows strict rules which are\nconsistant at least in higher vertebates, e.g. mammals. The chromosome\nname preceds the band names.\n\nThe shorter arm of the chromosome is called 'p' ('petit') and usually\ndrawn pointing up. The lower arm is called 'q' ('queue'). The bands\nare named from the region separting these, a centromere (cen), towards\nthe tips or telomeric regions (ter) counting from 1 upwards. Depending\nof the resolution used the bands are identified with one or more\ndigit. The first digit determines the major band and subsequent digits\nsub bands: p1 band can be divided into subbands p11, p12 and 13 and\np11 can furter be divided into subbands p11.1 and p11.2. The dot after\nsecond digit makes it easier to read the values. A region between ands\nis given from the centromere outwards towards the telomere (e.g. 2p2-5\nor 3p21-35) or from a band in the p arm to a band in the q arm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::CytoPosition;\n\nuse strict;\nuse integer;\nuse Bio::Range;\n\nuse base qw(Bio::Map::Position);\n\n=head2 cytorange\n\n Title   : cytorange\n Usage   : my $range = $obj->cytorange();\n Function:\n            Converts cytogenetic location set by value method into\n            an integer range. The chromosome number determines the\n            \"millions\" in the values.  Human X and Y chromosome\n            symbols are represented by values 100 and 101.\n\n            The localization within chromosomes are converted into\n            values between the range of 0 and 200,000:\n\n            pter                    cen                       qter\n            |------------------------|-------------------------|\n            0                     100,000                   200,000\n\n            The values between -100,000 through 0 for centromere to\n            100,000 would have reflected the band numbering better but\n            use of positive integers was choosen since the\n            transformation is very easy. These values are not metric.\n\n            Each band defines a range in a chromosome. A band string\n            is converted into a range by padding it with lower and and\n            higher end digits (for q arm: '0' and '9') to the length\n            of five. The arm and chromosome values are added to these:\n            e.g. 21000 & 21999 (band 21) + 100,000 (q arm) + 2,000,000\n            (chromosome 2) => 2q21 : 2,121,000 .. 2,121,999. Note that\n            this notation breaks down if there is a band or a subband\n            using digit 9 in its name!  This is not the case in human\n            karyotype.\n\n            The full algorithm used for bands:\n\n            if arm is 'q' then\n               pad char for start is '0', for end '9'\n               range is chromosome + 100,000 + padded range start or end\n            elsif arm is 'p' then\n               pad char for start is '9', for end '0'\n               range is chromosome + 100,000 - padded range start or end\n\n Returns : Bio::Range object or undef\n Args    : none\n\n\nsub cytorange {\n    my ($self) = @_;\n    my ($chr, $r, $band, $band2, $arm, $arm2, $lc, $uc, $lcchar, $ucchar);\n\n    return $r if not defined $self->{_value}; # returns undef\n    $self->{_value} =~\n\t#  -----1-----  --------2---------   -----3-----     -------4-------   ---6---\n\tm/([XY]|[0-9]+)(cen|qcen|pcen|[pq])?(ter|[.0-9]+)?-?([pq]?(cen|ter)?)?([.0-9]+)?/;\n    $self->warn(\"Not a valid value: \". $self->{_value}), return $r\n\tif not defined $1 ; # returns undef\n\n    $chr = uc $1;\n    $self->chr($chr);\n\n    $chr = 100 if $chr eq 'X';\n    $chr = 101 if $chr eq 'Y';\n    $chr *= 1000000;\n\n    $r = Bio::Range->new();\n\n    $band = '';\n    if (defined $3 ) {\n\t$2 || $self->throw(\"$& does not make sense: 'arm' or 'cen' missing\");\n\t$band = $3;\n\t$band =~ tr/\\.//d;\n    }\n    if (defined $6 ) {\n\t$arm2 = $4;\n\t$arm2 = $2 if $4 eq ''; # it is not necessary to repeat the arm [p|q]\n\t$band2 = $6;\n\t$band2 =~ tr/\\.//d;\n    \n\t#find the correct order\n    #print STDERR \"-|$&|----2|$2|-----3|$band|---4|$4|--------arm2|$arm2|-------------\\n\";\n\tif ($band ne '' and (defined $arm2 and $2 ne $arm2 and $arm2 eq 'q') ) {\n\t    $lc = 'start'; $lcchar = '9';\n\t    $uc = 'end'; $ucchar = '9';\n\t}\n\telsif ($band ne 'ter' and $2 ne $arm2 and $arm2 eq 'p') {\n\t    $lc = 'end'; $lcchar = '9';\n\t    $uc = 'start'; $ucchar = '9';\n\t}\n\telsif ($band eq 'ter' and  $arm2 eq 'p') {\n\t    $uc = 'start'; $ucchar = '9';\n\t} # $2 eq $arm2\n\telsif ($arm2 eq 'q') {\n\t    if (_pad($band, 5, '0') < _pad($band2, 5, '0')) {\n\t\t$lc = 'start'; $lcchar = '0';\n\t\t$uc = 'end'; $ucchar = '9';\n\t    } else {\n\t\t$lc = 'end'; $lcchar = '9';\n\t\t$uc = 'start'; $ucchar = '0';\t\t\n\t    }\n\t}\n\telsif ($arm2 eq 'p') {\n\t    if (_pad($band, 5, '0') < _pad($band2, 5, '0')) {\n\t\t$lc = 'end'; $lcchar = '0';\n\t\t$uc = 'start'; $ucchar = '9';\n\t    } else {\n\t\t$lc = 'start'; $lcchar = '9';\n\t\t$uc = 'end'; $ucchar = '0';\t\t\n\t    }\n\t}\n\telse {\n\t    $self->throw(\"How did you end up here? $&\");\n\t}\n\n\t#print STDERR \"-------$arm2--------$band2---------$ucchar--------------\\n\";\n\tif ( (defined $arm2 and $arm2 eq 'p') or (defined $arm2 and $arm2 eq 'p') ) {\n\t    $r->$uc(-(_pad($band2, 5, $ucchar)) + 100000 + $chr );\n\t    if (defined $3 and $3 eq 'ter') {\n\t\t$r->end(200000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' or $2 eq 'qcen' or $2 eq 'pcen'){\n\t\t$r->$lc(100000 + $chr);\n\t    } \n\t    elsif ($2 eq 'q') {\n\t\t$r->$lc(_pad($band, 5, $lcchar) + 100000 + $chr );\n\t    } else {\n\t\t$r->$lc(-(_pad($band, 5, $lcchar)) + 100000 + $chr );\n\t    }\n\t} else { #if:$arm2=q e.g. 9p22-q32\n\t    #print STDERR \"-------$arm2--------$band2---------$ucchar--------------\\n\";\n\t    $r->$uc(_pad($band2, 5, $ucchar) +  100000 + $chr);\n\t    if ($2 eq 'cen' or $2 eq 'pcen') {\n\t\t$r->$lc(100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'p') {\n\t\tif ($3 eq 'ter') {\n\t\t    $r->$lc(200000 + $chr);\n\t\t} else {\n\t\t    $r->$lc(-(_pad($band, 5, $lcchar)) + 100000 + $chr);\n\t\t}\n\t    } else { #$2.==q\n\t\t$r->$lc(_pad($band, 5, $lcchar) + 100000 + $chr);\n\t    }\n\t}\n    }\n    #\n    # e.g. 10p22.1-cen\n    #\n    elsif (defined $4 and $4 ne '') {\n\t#print STDERR \"$4-----$&----\\n\";\n\tif ($4 eq 'cen' || $4 eq 'qcen' || $4 eq 'pcen') { # e.g. 10p22.1-cen;\n\t    # '10pcen-qter' does not really make sense but lets have it in anyway\n\t    $r->end(100000 + $chr);\n\t    if ($2 eq 'p') {\n\t\tif ($3 eq 'ter') {\n\t\t    $r->start($chr);\n\t\t} else {\n\t\t    $r->start(_pad($band, 5, '9') + $chr);\n\t\t}\n\t    }\n\t    elsif ($2 eq 'cen') {\n\t\t$self->throw(\"'cen-cen' does not make sense: $&\");\n\t    } else {\n\t\t$self->throw(\"Only order p-cen is valid: $&\");\n\t    }\n\t}\n\telsif ($4 eq 'qter' || $4 eq 'ter') { # e.g. 10p22.1-qter, 1p21-qter, 10pcen-qter, 7q34-qter\n\t    $r->end(200000 + $chr);\n\t    if ($2 eq 'p'){\n\t\t$r->start(-(_pad($band, 5, '9')) + 100000 + $chr); #??? OK?\n\t    }\n\t    elsif ($2 eq 'q') {\n\t\t$r->start(_pad($band, 5, '0') + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' || $2 eq 'qcen' || $2 eq 'pcen' ) {\n\t\t$r->start(100000 + $chr);\n\t    }\n\t}\n\telsif ($4 eq 'pter' ) {\n\t    #print STDERR \"$2,$3--$4-----$&----\\n\";\n\t    $r->start( $chr);\n\t     if ($2 eq 'p'){\n\t\t$r->end(-(_pad($band, 5, '0')) + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'q') {\n\t\t$r->end(_pad($band, 5, '9') + 100000 + $chr);\n\t    }\n\t    elsif ($2 eq 'cen' || $2 eq 'qcen' || $2 eq 'pcen' ) {\n\t\t$r->end(100000 + $chr);\n\t    }\n\t} else { # -p or -q at the end of the range\n\t    $self->throw(\"lone '$4' in $& does not make sense\");\n\t}\n    }\n    #\n    #  e.g 10p22.1, 10pter\n    #\n    elsif (defined $3 ) {\n\tif ($2 eq 'p') {\n\t    if ($3 eq 'ter') { # e.g. 10pter\n\t\t$r = Bio::Range->new('-start' => $chr,\n\t\t\t\t    '-end' => $chr,\n\t\t\t\t    );\n\t    } else { # e.g 10p22.1\n\t\t$r = Bio::Range->new('-start' => -(_pad($band, 5, '9')) + 100000 + $chr,\n\t\t\t\t    '-end' => -(_pad($band, 5, '0')) + 100000 + $chr,\n\t\t\t\t    );\n\t    }\n\t} elsif ($2 eq 'q') {\n\t    if ($3 eq 'ter') { # e.g. 10qter\n\t\t$r = Bio::Range->new('-start' => 200000 + $chr,\n\t\t\t\t    '-end' => 200000 + $chr,\n\t\t\t\t    );\n\t    } else { # e.g 10q22.1\n\t\t$r = Bio::Range->new('-start' => _pad($band, 5, '0') + 100000 + $chr,\n\t\t\t\t    '-end' => _pad($band, 5, '9') + 100000 + $chr,\n\t\t\t\t    );\n\t    }\n\t} else { # e.g. 10qcen1.1 !\n\t    $self->throw(\"'cen' in $& does not make sense\");\n\t}\n    }\n    #\n    # e.g. 10p\n    #\n    elsif (defined $2 ) { # e.g. 10p\n\tif ($2 eq 'p' ) {\n\t    $r = Bio::Range->new('-start' => $chr,\n\t\t\t\t'-end' => 100000  + $chr\n\t\t\t\t);\n\t}\n\telsif ($2 eq 'q' )  {\n\t    $r = Bio::Range->new('-start' => 100000 + $chr,\n\t\t\t\t'-end' => 200000 + $chr\n\t\t\t\t);\n\t} else { # $2 eq 'cen' || 'qcen'\n\t    $r = Bio::Range->new('-start' => 100000 + $chr,\n\t\t\t\t'-end' => 100000 + $chr\n\t\t\t\t);\n\t}\n    }\n    #\n    # chr only, e.g. X\n    #\n    else {\n\t$r = Bio::Range->new('-start' => $chr,\n\t\t\t    '-end' => 200000 + $chr\n\t\t\t    );\n    }\n    \n    if ($r) {\n        $self->start($r->start);\n        $self->end($r->end);\n    }\n    return $r;\n}\n\n\nsub _pad {\n    my ($string, $len, $pad_char) = @_;\n    __PACKAGE__->throw(\"function _pad needs a positive integer length, not [$len]\") \n\tunless $len =~ /^\\+?\\d+$/;\n    __PACKAGE__->throw(\"function _pad needs a single character pad_char, not [$pad_char]\") \n\tunless length $pad_char == 1;\n    $string ||= '';\n    return $string . $pad_char x ( $len - length( $string ) );\n}\n\n=head2 range2value\n\n Title   : range2value\n Usage   : my $value = $obj->range2value($range);\n Function: Sets and returns the value string based on start and end values of\n           the Bio::Range object passes as an argument.\n Returns : string or false\n Args    : Bio::Range object\n\n\nsub range2value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif( ! $value->isa('Bio::Range') ) {\n\t    $self->throw(\"Is not a Bio::Range object but a [$value]\");\n\t    return;\n\t}\n\tif( ! $value->start ) {\n\t    $self->throw(\"Start is not defined in [$value]\");\n\t    return;\n\t}\n\tif( ! $value->end ) {\n\t    $self->throw(\"End is not defined in [$value]\");\n\t    return;\n\t}\n\tif( $value->start < 100000 ) {\n\t    $self->throw(\"Start value has to be in millions, not \". $value->start);\n\t    return;\n\t}\n\tif( $value->end < 100000 ) {\n\t    $self->throw(\"End value has to be in millions, not \". $value->end);\n\t    return;\n\t}\n\n\tmy ($chr, $arm, $band) = $value->start =~ /(\\d+)(\\d)(\\d{5})/;\t\n\tmy ($chr2, $arm2, $band2) = $value->end =~ /(\\d+)(\\d)(\\d{5})/;\t\n\n\tmy ($chrS, $armS, $bandS, $arm2S, $band2S, $sep) = ('', '', '', '', '', '' );\n      LOC: {\n\t  #\n\t  # chromosome\n\t  #\n\t  if ($chr == 100) {\n\t      $chrS = 'X';\n\t  }\n\t  elsif ($chr == 100) {\n\t      $chrS = 'Y';\n\t  } else {\n\t      $chrS = $chr;\n\t  }\n\t  last LOC if  $arm == 0 and $arm2 == 2 and $band == 0 and $band2 == 0 ;\n\t  #\n\t  # arm\n\t  #\n\t  if ($arm == $arm2 ) {\n\t      if ($arm == 0) {\n\t\t  $armS = 'p';\n\t\t  #$armS = 'pter' if $band == 0 and $band2 == 0;\n\t\t  $bandS = 'ter' if $band == 0;\n\t\t  #$arm2S = 'p'; #?\n\t      }\n\t      elsif ($arm == 2) {\n\t\t  $armS = 'q';\n\t\t  $bandS = 'ter' if $band == 0;\n\t      } else {\n\t\t  $armS = 'q';\n\t\t  #$arm2S = 'q'; #?\n\t\t  $armS = 'cen',  if $band == 0;# and $band2 == 0;\n\t      }\n\t  } else {\n\t      if ($arm == 0) {\n\t\t  $armS = 'p';\n\t\t  $arm2S = 'q';\n\t\t  $arm2S = '' if $band == 0 and $band2 == 0;\n\t      } else {\n\t\t  $armS = 'q';\n\t\t  $arm2S = 'p';\n\t\t  $arm2S = '' if $arm2 == 2 and $band == 0 and $band2 == 0;\n\t      }\n\t  }\n\t  last LOC if $band == $band2 ;\n\t  my $c;\n\t  #\n\t  # first band (ter is hadled with the arm)\n\t  #\n\t  if ($bandS ne 'ter') {\n\t      if ($armS eq 'p') {\n\t\t  $band = 100000 - $band;\n\t\t  $c = '9';\n\t      } else {\n\t\t  $c = '0';\n\t      }\n\t      $band =~ s/$c+$//; \n\t      $bandS = $band;\n\t      $bandS = substr($band, 0, 2). '.'. substr($band, 2) if length $band > 2;\n\t  }\n\t  last LOC unless $band2;\n\t  #\n\t  # second band\n\t  #\n\t  if ($arm2 == 0) {\n\t      $arm2S = 'p';\n\t      $band2 = 100000 - $band2;\n\t      $c = '0';\n\t  } else { # 1 or 2\n\t      $arm2S = 'q';\n\t      $c = '9';\n\t  }\n\t  if ($band2 == 0) {\n\t      if ($arm2 == 1) {\n\t\t  $arm2S = 'p';\n\t\t  $band2S = 'cen';\n\t      } else {\n\t\t  $band2S = 'ter';\n\t      }\n\t      last LOC;\n\t  }\n\t  last LOC if $band eq $band2 and $arm == $arm2;\n\n\t  $band2 =~ s/$c+$//; \n\t  $band2S = $band2;\n\t  $band2S = substr($band2, 0, 2). '.'. substr($band2, 2) if length $band2 > 2;\n\n      } # end of LOC:\n\n\tif ($armS eq 'p' and $arm2S eq 'p') {\n\t    my $tmp = $band2S;\n\t    $band2S = $bandS;\n\t    $bandS = $tmp;\n\t}\n\t$band2S = '' if $bandS eq $band2S ;\n\t$armS = '' if $bandS eq 'cen';\n\t$arm2S = '' if $armS eq $arm2S and $band2S ne 'ter';\n\t$sep = '-' if $arm2S || $band2S;\n\t$self->value( $chrS. $armS. $bandS. $sep. $arm2S. $band2S);\n    }\n   return $self->value;\n}\n\n=head2 value\n\n Title   : value\n Usage   : my $pos = $position->value;\n Function: Get/Set the value for this postion\n Returns : scalar, value\n Args    : none to get, OR scalar to set\n\n\nsub value {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_value'} = $value;\n       $self->cytorange;\n   }\n   return $self->{'_value'};\n}\n\n=head2 numeric\n\n Title   : numeric\n Usage   : my $num = $position->numeric;\n Function: Read-only method that is guarantied to return a numeric \n           representation of the start of this position.\n Returns : int (the start of the range)\n Args    : optional Bio::RangeI object \n\n\nsub numeric {\n   my $self = shift;\n   return $self->start(@_);\n}\n\n=head2 chr\n\n Title   : chr\n Usage   : my $mychr = $position->chr();\n Function: Get/Set method for the chromosome string of the location.\n Returns : chromosome value\n Args    : none to get, OR scalar to set"},"kind":12,"line":561,"children":[{"line":562,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"chr"},{"line":562,"kind":13,"name":"$chr","containerName":"chr"},{"line":563,"kind":13,"name":"$chr","containerName":"chr"},{"kind":13,"line":564,"name":"$self","containerName":"chr"},{"name":"$chr","containerName":"chr","line":564,"kind":13},{"line":566,"kind":13,"name":"$self","containerName":"chr"}],"name":"chr","range":{"start":{"character":0,"line":561},"end":{"character":9999,"line":567}}}]}