{"version":5,"vars":[{"kind":2,"line":114,"containerName":"","name":"vars"},{"line":121,"kind":2,"name":"base","containerName":""},{"kind":13,"line":122,"name":"$MAPCOUNT","containerName":null},{"range":{"end":{"character":9999,"line":185},"start":{"character":0,"line":160}},"name":"new","detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Contig\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Contig - A MapI implementation handling the contigs of a\nPhysical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    # get the contig object of $contig from the Bio::Map::Physical\n    my $ctgobj = $physical->get_contigobj($contig);\n\n    # acquire all the markers that lie in this contig\n    foreach my $marker ($ctgobj->each_markerid()) {\n\tprint \"   +++$marker\\n\";\n    }\n\n    # find the group of this contig\n    print \"Group: \",$ctgobj->group(),\"\\n\";\n\n    # find the range of this contig\n    print \"RANGE: start:\",$ctgobj->range()->start(),\"\\tend: \",\n           $ctgobj->range()->end(),\"\\n\";\n\n    # find the position of this contig in $group (chromosome)\n    print \"Position in Group $group\",\" = \",$ctgobj->position($group),\"\\n\";\n\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::Map::MapI.  It handles the\nessential storage of name, species, type, and units as well as in\nmemory representation of the elements of a map.\n\nBio::Map::Contig has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Contig;\nuse vars qw($MAPCOUNT);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Range;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::Contig->new\n                      (\n\t\t       -name    => $name,\n\t\t       -chr_remark   => $cremark,\n\t\t       -user_remark  => $uremark,\n\t\t       -trace_remark => $tremark,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -markers => \\%markers,\n\t\t       -clones  => \\%clones,\n\t\t       -position => $pos\n\t\t       -range    => Bio::Range->new(-start =>$s,-end=>$e),\n\t\t       );\n\n Function: Initialize a new Bio::Map::Contig object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::Contig> object\n Args    : ( -name    => name string,\n\t     -chr_remark   => chr remark string,\n\t     -user_remark  => userremark string,\n\t     -trace_remark => tremark string,\n\t     -group   => group string,\n\t     -subgroup=> subgroup string,\n\t     -anchor  => boolean if this is anchored or not,\n\t     -markers => hashref of contained markers,\n\t     -clones  => hashref of contained clones,\n\t     -position => position\n\t     -range    => L<Bio::Range>","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","definition":"sub","line":160,"children":[{"line":161,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"line":161,"kind":13,"name":"@args","containerName":"new"},{"line":162,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"containerName":"new","name":"$class","kind":13,"line":162},{"name":"@args","containerName":"new","kind":13,"line":162},{"kind":13,"line":164,"containerName":"new","name":"$name","definition":"my","localvar":"my"},{"containerName":"new","name":"$cremark","line":164,"kind":13},{"line":164,"kind":13,"name":"$uremark","containerName":"new"},{"name":"$tremark","containerName":"new","line":164,"kind":13},{"kind":13,"line":165,"name":"$group","containerName":"new"},{"line":165,"kind":13,"name":"$subgroup","containerName":"new"},{"line":165,"kind":13,"containerName":"new","name":"$anchor"},{"kind":13,"line":165,"name":"$markers","containerName":"new"},{"kind":13,"line":165,"containerName":"new","name":"$clones"},{"kind":13,"line":166,"name":"$position","containerName":"new"},{"containerName":"new","name":"$range","line":166,"kind":13},{"containerName":"new","name":"$self","line":166,"kind":13},{"line":166,"kind":12,"name":"_rearrange","containerName":"new"},{"containerName":"new","name":"@args","line":169,"kind":13},{"line":171,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":171,"containerName":"new","name":"name"},{"name":"$name","containerName":"new","kind":13,"line":171},{"name":"$name","containerName":"new","kind":13,"line":171},{"containerName":"new","name":"$self","line":172,"kind":13},{"kind":12,"line":172,"containerName":"new","name":"chr_remark"},{"line":172,"kind":13,"name":"$cremark","containerName":"new"},{"line":172,"kind":13,"containerName":"new","name":"$cremark"},{"name":"$self","containerName":"new","kind":13,"line":173},{"containerName":"new","name":"user_remark","line":173,"kind":12},{"kind":13,"line":173,"name":"$uremark","containerName":"new"},{"name":"$uremark","containerName":"new","kind":13,"line":173},{"kind":13,"line":174,"name":"$self","containerName":"new"},{"containerName":"new","name":"trace_remark","line":174,"kind":12},{"line":174,"kind":13,"containerName":"new","name":"$tremark"},{"name":"$tremark","containerName":"new","line":174,"kind":13},{"line":175,"kind":13,"containerName":"new","name":"$self"},{"line":175,"kind":12,"containerName":"new","name":"group"},{"kind":13,"line":175,"name":"$group","containerName":"new"},{"containerName":"new","name":"$group","kind":13,"line":175},{"line":176,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":176,"name":"subgroup","containerName":"new"},{"kind":13,"line":176,"containerName":"new","name":"$group"},{"name":"$subgroup","containerName":"new","kind":13,"line":176},{"name":"$self","containerName":"new","line":177,"kind":13},{"containerName":"new","name":"anchor","kind":12,"line":177},{"name":"$anchor","containerName":"new","kind":13,"line":177},{"name":"$anchor","containerName":"new","kind":13,"line":177},{"line":179,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":179,"name":"set_markers","containerName":"new"},{"line":179,"kind":13,"name":"$markers","containerName":"new"},{"containerName":"new","name":"$markers","line":179,"kind":13},{"kind":13,"line":180,"containerName":"new","name":"$self"},{"name":"set_clones","containerName":"new","kind":12,"line":180},{"containerName":"new","name":"$clones","line":180,"kind":13},{"name":"$clones","containerName":"new","line":180,"kind":13},{"kind":13,"line":181,"containerName":"new","name":"$self"},{"name":"range","containerName":"new","kind":12,"line":181},{"containerName":"new","name":"$range","kind":13,"line":181},{"line":181,"kind":13,"containerName":"new","name":"$range"},{"name":"$self","containerName":"new","kind":13,"line":182},{"containerName":"new","name":"position","line":182,"kind":12},{"line":182,"kind":13,"containerName":"new","name":"$position"},{"line":182,"kind":13,"name":"$position","containerName":"new"},{"line":184,"kind":13,"containerName":"new","name":"$self"}],"kind":12},{"name":"SUPER","containerName":"new","kind":12,"line":162},{"containerName":"main::","name":"chr_remark","definition":"sub","range":{"start":{"line":203,"character":0},"end":{"character":9999,"line":207}},"kind":12,"line":203,"children":[{"line":204,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"chr_remark"},{"kind":13,"line":205,"name":"$self","containerName":"chr_remark"},{"line":206,"kind":13,"containerName":"chr_remark","name":"$self"},{"kind":13,"line":206,"containerName":"chr_remark","name":"$self"}]},{"range":{"end":{"line":223,"character":9999},"start":{"line":219,"character":0}},"containerName":"main::","name":"user_remark","definition":"sub","line":219,"children":[{"line":220,"kind":13,"localvar":"my","containerName":"user_remark","definition":"my","name":"$self"},{"containerName":"user_remark","name":"$self","line":221,"kind":13},{"name":"$self","containerName":"user_remark","kind":13,"line":222},{"line":222,"kind":13,"containerName":"user_remark","name":"$self"}],"kind":12},{"line":235,"children":[{"kind":13,"line":236,"name":"$self","definition":"my","containerName":"trace_remark","localvar":"my"},{"line":237,"kind":13,"name":"$self","containerName":"trace_remark"},{"name":"$self","containerName":"trace_remark","kind":13,"line":238},{"kind":13,"line":238,"containerName":"trace_remark","name":"$self"}],"kind":12,"range":{"end":{"character":9999,"line":239},"start":{"character":0,"line":235}},"containerName":"main::","definition":"sub","name":"trace_remark"},{"children":[{"line":255,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"range"},{"kind":13,"line":256,"name":"$self","containerName":"range"},{"containerName":"range","name":"$self","kind":13,"line":257}],"line":254,"kind":12,"range":{"end":{"line":258,"character":9999},"start":{"line":254,"character":0}},"name":"range","definition":"sub","containerName":"main::"},{"name":"position","definition":"sub","containerName":"main::","range":{"end":{"line":274,"character":9999},"start":{"line":270,"character":0}},"kind":12,"children":[{"containerName":"position","definition":"my","name":"$self","localvar":"my","kind":13,"line":271},{"name":"$self","containerName":"position","kind":13,"line":272},{"kind":13,"line":273,"name":"$self","containerName":"position"}],"line":270},{"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"anchor","line":287,"kind":13},{"containerName":"anchor","name":"$self","line":288,"kind":13},{"line":289,"kind":13,"containerName":"anchor","name":"$self"}],"line":286,"kind":12,"range":{"start":{"character":0,"line":286},"end":{"line":290,"character":9999}},"definition":"sub","name":"anchor","containerName":"main::"},{"kind":12,"children":[{"line":305,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"group"},{"kind":13,"line":306,"containerName":"group","name":"$self"},{"containerName":"group","name":"$self","kind":13,"line":307}],"line":304,"definition":"sub","name":"group","containerName":"main::","range":{"start":{"character":0,"line":304},"end":{"character":9999,"line":308}}},{"name":"subgroup","range":{"start":{"line":323,"character":0},"end":{"line":327,"character":9999}},"kind":12,"children":[{"kind":13,"line":324,"definition":"my","name":"$self","containerName":"subgroup","localvar":"my"},{"containerName":"subgroup","name":"$self","line":325,"kind":13},{"name":"$self","containerName":"subgroup","line":326,"kind":13}],"line":323,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Contig\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Contig - A MapI implementation handling the contigs of a\nPhysical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    # get the contig object of $contig from the Bio::Map::Physical\n    my $ctgobj = $physical->get_contigobj($contig);\n\n    # acquire all the markers that lie in this contig\n    foreach my $marker ($ctgobj->each_markerid()) {\n\tprint \"   +++$marker\\n\";\n    }\n\n    # find the group of this contig\n    print \"Group: \",$ctgobj->group(),\"\\n\";\n\n    # find the range of this contig\n    print \"RANGE: start:\",$ctgobj->range()->start(),\"\\tend: \",\n           $ctgobj->range()->end(),\"\\n\";\n\n    # find the position of this contig in $group (chromosome)\n    print \"Position in Group $group\",\" = \",$ctgobj->position($group),\"\\n\";\n\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::Map::MapI.  It handles the\nessential storage of name, species, type, and units as well as in\nmemory representation of the elements of a map.\n\nBio::Map::Contig has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Contig;\nuse vars qw($MAPCOUNT);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Range;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::Contig->new\n                      (\n\t\t       -name    => $name,\n\t\t       -chr_remark   => $cremark,\n\t\t       -user_remark  => $uremark,\n\t\t       -trace_remark => $tremark,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -markers => \\%markers,\n\t\t       -clones  => \\%clones,\n\t\t       -position => $pos\n\t\t       -range    => Bio::Range->new(-start =>$s,-end=>$e),\n\t\t       );\n\n Function: Initialize a new Bio::Map::Contig object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::Contig> object\n Args    : ( -name    => name string,\n\t     -chr_remark   => chr remark string,\n\t     -user_remark  => userremark string,\n\t     -trace_remark => tremark string,\n\t     -group   => group string,\n\t     -subgroup=> subgroup string,\n\t     -anchor  => boolean if this is anchored or not,\n\t     -markers => hashref of contained markers,\n\t     -clones  => hashref of contained clones,\n\t     -position => position\n\t     -range    => L<Bio::Range>\n\n\nsub new {\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n\n   my ($name,$cremark,$uremark,$tremark,\n       $group,$subgroup, $anchor,$markers, $clones,\n       $position,$range) = $self->_rearrange([qw(NAME CHR_REMARK USER_REMARK\n\t\t\t\t\t\t TRACE_REMARK GROUP SUBGROUP\n\t\t\t\t\t\t ANCHOR MARKERS CLONES\n\t\t\t\t\t\t POSITION RANGE)],@args);\n\n   $self->name($name)                  if defined $name;\n   $self->chr_remark($cremark)         if defined $cremark;\n   $self->user_remark($uremark)        if defined $uremark;\n   $self->trace_remark($tremark)       if defined $tremark;\n   $self->group($group)                if defined $group;\n   $self->subgroup($group)             if defined $subgroup;\n   $self->anchor($anchor)              if defined $anchor;\n\n   $self->set_markers($markers)        if defined $markers;\n   $self->set_clones($clones)          if defined $clones;\n   $self->range($range)                if defined $range;\n   $self->position($position)          if defined $position;\n\n   return $self;\n}\n\n=head2 Modifier methods\n\nAll methods present in L<Bio::Map::SimpleMap> are implemented by this class.\nMost of the methods are inherited from SimpleMap.  The following methods\nhave been modified to reflect the needs of physical maps.\n\n=head2 chr_remark\n\n Title   : chr_remark\n Usage   : my $chrremark = $contigobj->chr_remark();\n Function: Get/set the group remark for this contig\n Returns : scalar representing the current group_remark of this contig\n Args    : none to get, OR string to set\n\n\nsub chr_remark {\n    my ($self) = shift;\n    $self->{'_cremark'} = shift if @_;\n    return defined $self->{'_cremark'} ? $self->{'_cremark'} : '';\n}\n\n=head2 user_remark\n\n Title   : user_remark\n Usage   : my $userremark = $contigobj->user_remark();\n Function: Get/set the user remark for this contig\n Returns : scalar representing the current user_remark of this contig\n Args    : none to get, OR string to set\n\n\nsub user_remark {\n    my ($self) = shift;\n    $self->{'_uremark'} = shift if @_;\n    return defined $self->{'_uremark'} ? $self->{'_uremark'} : '';\n}\n\n=head2 trace_remark\n\n Title   : trace_remark\n Usage   : my $traceremark = $contigobj->trace_remark();\n Function: Get/set the trace remark for this contig\n Returns : scalar representing the current trace_remark of this contig\n Args    : none to get, OR string to set\n\n\nsub trace_remark {\n    my ($self) = shift;\n    $self->{'_tremark'} = shift if @_;\n    return defined $self->{'_tremark'} ? $self->{'_tremark'} : '';\n}\n\n=head2 range\n\n Title   : range\n Usage   : my $range = $contigobj->range();\n Function: Get/set the range for this Contig\n Returns : Bio::Range representing the current range of this contig,\n           start and end of the contig can be thus found using:\n           my $start = $contigobj->range()->start();\n           my $end   = $contigobj->range()->end();\n Args    : none to get, OR Bio::Range to set\n\n\nsub range {\n    my ($self) = shift;\n    return $self->{'_range'} = shift if @_;\n    return $self->{'_range'};\n}\n\n=head2 position\n\n Title   : position\n Usage   : $ctgpos = $contigobj->position();\n Function: Get/set the position of the contig in the group\n Returns : scalar representing the position of the contig in the group\n Args    : none to get, OR string to set\n\n\nsub position {\n    my ($self) = shift;\n    $self->{'_position'} = shift if @_;\n    return $self->{'_position'} || 0;\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : $ctganchor = $contig->anchor();\n Function: Get/set the anchor value for this Contig (True | False)\n Returns : scalar representing the anchor (1 | 0) for this contig\n Args    : none to get, OR string to set\n\n\nsub anchor {\n    my ($self) = shift;\n    return $self->{'_anchor'} = shift if @_;\n    return $self->{'_anchor'};\n}\n\n=head2 group\n\n Title   : group\n Usage   : $groupno = $contigobj->group();\n Function: Get/set the group number for this contig.\n           This is a generic term, used for Linkage-Groups as well as for\n           Chromosomes. \n Returns : scalar representing the group number of this contig\n Args    : none\n\n\nsub group {\n    my ($self) = shift;\n    $self->{'_group'} = shift if @_;\n    return $self->{'_group'} || 0;\n}\n\n=head2 subgroup\n\n Title   : subgroup\n Usage   : $subgroup = $contig->subgroup();\t\n Function: Get/set the subgroup for this contig. This is a generic term:\n           subgroup here could represent subgroup of a Chromosome or of a\n           Linkage Group. The user must take care of which subgroup he/she is\n           querying for.\t\n Returns : A scalar representing the subgroup of this contig\n Args    : none","parameters":[{"label":"$self"}],"label":"subgroup($self)"},"detail":"($self)"},{"definition":"sub","containerName":"main::","signature":{"label":"each_cloneid($self)","documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Contig\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Contig - A MapI implementation handling the contigs of a\nPhysical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    # get the contig object of $contig from the Bio::Map::Physical\n    my $ctgobj = $physical->get_contigobj($contig);\n\n    # acquire all the markers that lie in this contig\n    foreach my $marker ($ctgobj->each_markerid()) {\n\tprint \"   +++$marker\\n\";\n    }\n\n    # find the group of this contig\n    print \"Group: \",$ctgobj->group(),\"\\n\";\n\n    # find the range of this contig\n    print \"RANGE: start:\",$ctgobj->range()->start(),\"\\tend: \",\n           $ctgobj->range()->end(),\"\\n\";\n\n    # find the position of this contig in $group (chromosome)\n    print \"Position in Group $group\",\" = \",$ctgobj->position($group),\"\\n\";\n\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::Map::MapI.  It handles the\nessential storage of name, species, type, and units as well as in\nmemory representation of the elements of a map.\n\nBio::Map::Contig has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Contig;\nuse vars qw($MAPCOUNT);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Range;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::Contig->new\n                      (\n\t\t       -name    => $name,\n\t\t       -chr_remark   => $cremark,\n\t\t       -user_remark  => $uremark,\n\t\t       -trace_remark => $tremark,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -markers => \\%markers,\n\t\t       -clones  => \\%clones,\n\t\t       -position => $pos\n\t\t       -range    => Bio::Range->new(-start =>$s,-end=>$e),\n\t\t       );\n\n Function: Initialize a new Bio::Map::Contig object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::Contig> object\n Args    : ( -name    => name string,\n\t     -chr_remark   => chr remark string,\n\t     -user_remark  => userremark string,\n\t     -trace_remark => tremark string,\n\t     -group   => group string,\n\t     -subgroup=> subgroup string,\n\t     -anchor  => boolean if this is anchored or not,\n\t     -markers => hashref of contained markers,\n\t     -clones  => hashref of contained clones,\n\t     -position => position\n\t     -range    => L<Bio::Range>\n\n\nsub new {\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n\n   my ($name,$cremark,$uremark,$tremark,\n       $group,$subgroup, $anchor,$markers, $clones,\n       $position,$range) = $self->_rearrange([qw(NAME CHR_REMARK USER_REMARK\n\t\t\t\t\t\t TRACE_REMARK GROUP SUBGROUP\n\t\t\t\t\t\t ANCHOR MARKERS CLONES\n\t\t\t\t\t\t POSITION RANGE)],@args);\n\n   $self->name($name)                  if defined $name;\n   $self->chr_remark($cremark)         if defined $cremark;\n   $self->user_remark($uremark)        if defined $uremark;\n   $self->trace_remark($tremark)       if defined $tremark;\n   $self->group($group)                if defined $group;\n   $self->subgroup($group)             if defined $subgroup;\n   $self->anchor($anchor)              if defined $anchor;\n\n   $self->set_markers($markers)        if defined $markers;\n   $self->set_clones($clones)          if defined $clones;\n   $self->range($range)                if defined $range;\n   $self->position($position)          if defined $position;\n\n   return $self;\n}\n\n=head2 Modifier methods\n\nAll methods present in L<Bio::Map::SimpleMap> are implemented by this class.\nMost of the methods are inherited from SimpleMap.  The following methods\nhave been modified to reflect the needs of physical maps.\n\n=head2 chr_remark\n\n Title   : chr_remark\n Usage   : my $chrremark = $contigobj->chr_remark();\n Function: Get/set the group remark for this contig\n Returns : scalar representing the current group_remark of this contig\n Args    : none to get, OR string to set\n\n\nsub chr_remark {\n    my ($self) = shift;\n    $self->{'_cremark'} = shift if @_;\n    return defined $self->{'_cremark'} ? $self->{'_cremark'} : '';\n}\n\n=head2 user_remark\n\n Title   : user_remark\n Usage   : my $userremark = $contigobj->user_remark();\n Function: Get/set the user remark for this contig\n Returns : scalar representing the current user_remark of this contig\n Args    : none to get, OR string to set\n\n\nsub user_remark {\n    my ($self) = shift;\n    $self->{'_uremark'} = shift if @_;\n    return defined $self->{'_uremark'} ? $self->{'_uremark'} : '';\n}\n\n=head2 trace_remark\n\n Title   : trace_remark\n Usage   : my $traceremark = $contigobj->trace_remark();\n Function: Get/set the trace remark for this contig\n Returns : scalar representing the current trace_remark of this contig\n Args    : none to get, OR string to set\n\n\nsub trace_remark {\n    my ($self) = shift;\n    $self->{'_tremark'} = shift if @_;\n    return defined $self->{'_tremark'} ? $self->{'_tremark'} : '';\n}\n\n=head2 range\n\n Title   : range\n Usage   : my $range = $contigobj->range();\n Function: Get/set the range for this Contig\n Returns : Bio::Range representing the current range of this contig,\n           start and end of the contig can be thus found using:\n           my $start = $contigobj->range()->start();\n           my $end   = $contigobj->range()->end();\n Args    : none to get, OR Bio::Range to set\n\n\nsub range {\n    my ($self) = shift;\n    return $self->{'_range'} = shift if @_;\n    return $self->{'_range'};\n}\n\n=head2 position\n\n Title   : position\n Usage   : $ctgpos = $contigobj->position();\n Function: Get/set the position of the contig in the group\n Returns : scalar representing the position of the contig in the group\n Args    : none to get, OR string to set\n\n\nsub position {\n    my ($self) = shift;\n    $self->{'_position'} = shift if @_;\n    return $self->{'_position'} || 0;\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : $ctganchor = $contig->anchor();\n Function: Get/set the anchor value for this Contig (True | False)\n Returns : scalar representing the anchor (1 | 0) for this contig\n Args    : none to get, OR string to set\n\n\nsub anchor {\n    my ($self) = shift;\n    return $self->{'_anchor'} = shift if @_;\n    return $self->{'_anchor'};\n}\n\n=head2 group\n\n Title   : group\n Usage   : $groupno = $contigobj->group();\n Function: Get/set the group number for this contig.\n           This is a generic term, used for Linkage-Groups as well as for\n           Chromosomes. \n Returns : scalar representing the group number of this contig\n Args    : none\n\n\nsub group {\n    my ($self) = shift;\n    $self->{'_group'} = shift if @_;\n    return $self->{'_group'} || 0;\n}\n\n=head2 subgroup\n\n Title   : subgroup\n Usage   : $subgroup = $contig->subgroup();\t\n Function: Get/set the subgroup for this contig. This is a generic term:\n           subgroup here could represent subgroup of a Chromosome or of a\n           Linkage Group. The user must take care of which subgroup he/she is\n           querying for.\t\n Returns : A scalar representing the subgroup of this contig\n Args    : none\n\n\nsub subgroup {\n    my ($self) = @_;\n    return $self->{'_subgroup'} = shift if @_;\n    return $self->{'_subgroup'} || 0;\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones  = $map->each_cloneid();\n Function: retrieves all the clone ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_clones method ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"line":343,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"each_cloneid"},{"containerName":"each_cloneid","name":"$self","line":344,"kind":13},{"line":344,"kind":12,"containerName":"each_cloneid","name":"_each_element"}],"line":342,"name":"each_cloneid","range":{"end":{"character":9999,"line":345},"start":{"character":0,"line":342}}},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Contig\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Contig - A MapI implementation handling the contigs of a\nPhysical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    # get the contig object of $contig from the Bio::Map::Physical\n    my $ctgobj = $physical->get_contigobj($contig);\n\n    # acquire all the markers that lie in this contig\n    foreach my $marker ($ctgobj->each_markerid()) {\n\tprint \"   +++$marker\\n\";\n    }\n\n    # find the group of this contig\n    print \"Group: \",$ctgobj->group(),\"\\n\";\n\n    # find the range of this contig\n    print \"RANGE: start:\",$ctgobj->range()->start(),\"\\tend: \",\n           $ctgobj->range()->end(),\"\\n\";\n\n    # find the position of this contig in $group (chromosome)\n    print \"Position in Group $group\",\" = \",$ctgobj->position($group),\"\\n\";\n\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::Map::MapI.  It handles the\nessential storage of name, species, type, and units as well as in\nmemory representation of the elements of a map.\n\nBio::Map::Contig has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Contig;\nuse vars qw($MAPCOUNT);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Range;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::Contig->new\n                      (\n\t\t       -name    => $name,\n\t\t       -chr_remark   => $cremark,\n\t\t       -user_remark  => $uremark,\n\t\t       -trace_remark => $tremark,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -markers => \\%markers,\n\t\t       -clones  => \\%clones,\n\t\t       -position => $pos\n\t\t       -range    => Bio::Range->new(-start =>$s,-end=>$e),\n\t\t       );\n\n Function: Initialize a new Bio::Map::Contig object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::Contig> object\n Args    : ( -name    => name string,\n\t     -chr_remark   => chr remark string,\n\t     -user_remark  => userremark string,\n\t     -trace_remark => tremark string,\n\t     -group   => group string,\n\t     -subgroup=> subgroup string,\n\t     -anchor  => boolean if this is anchored or not,\n\t     -markers => hashref of contained markers,\n\t     -clones  => hashref of contained clones,\n\t     -position => position\n\t     -range    => L<Bio::Range>\n\n\nsub new {\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n\n   my ($name,$cremark,$uremark,$tremark,\n       $group,$subgroup, $anchor,$markers, $clones,\n       $position,$range) = $self->_rearrange([qw(NAME CHR_REMARK USER_REMARK\n\t\t\t\t\t\t TRACE_REMARK GROUP SUBGROUP\n\t\t\t\t\t\t ANCHOR MARKERS CLONES\n\t\t\t\t\t\t POSITION RANGE)],@args);\n\n   $self->name($name)                  if defined $name;\n   $self->chr_remark($cremark)         if defined $cremark;\n   $self->user_remark($uremark)        if defined $uremark;\n   $self->trace_remark($tremark)       if defined $tremark;\n   $self->group($group)                if defined $group;\n   $self->subgroup($group)             if defined $subgroup;\n   $self->anchor($anchor)              if defined $anchor;\n\n   $self->set_markers($markers)        if defined $markers;\n   $self->set_clones($clones)          if defined $clones;\n   $self->range($range)                if defined $range;\n   $self->position($position)          if defined $position;\n\n   return $self;\n}\n\n=head2 Modifier methods\n\nAll methods present in L<Bio::Map::SimpleMap> are implemented by this class.\nMost of the methods are inherited from SimpleMap.  The following methods\nhave been modified to reflect the needs of physical maps.\n\n=head2 chr_remark\n\n Title   : chr_remark\n Usage   : my $chrremark = $contigobj->chr_remark();\n Function: Get/set the group remark for this contig\n Returns : scalar representing the current group_remark of this contig\n Args    : none to get, OR string to set\n\n\nsub chr_remark {\n    my ($self) = shift;\n    $self->{'_cremark'} = shift if @_;\n    return defined $self->{'_cremark'} ? $self->{'_cremark'} : '';\n}\n\n=head2 user_remark\n\n Title   : user_remark\n Usage   : my $userremark = $contigobj->user_remark();\n Function: Get/set the user remark for this contig\n Returns : scalar representing the current user_remark of this contig\n Args    : none to get, OR string to set\n\n\nsub user_remark {\n    my ($self) = shift;\n    $self->{'_uremark'} = shift if @_;\n    return defined $self->{'_uremark'} ? $self->{'_uremark'} : '';\n}\n\n=head2 trace_remark\n\n Title   : trace_remark\n Usage   : my $traceremark = $contigobj->trace_remark();\n Function: Get/set the trace remark for this contig\n Returns : scalar representing the current trace_remark of this contig\n Args    : none to get, OR string to set\n\n\nsub trace_remark {\n    my ($self) = shift;\n    $self->{'_tremark'} = shift if @_;\n    return defined $self->{'_tremark'} ? $self->{'_tremark'} : '';\n}\n\n=head2 range\n\n Title   : range\n Usage   : my $range = $contigobj->range();\n Function: Get/set the range for this Contig\n Returns : Bio::Range representing the current range of this contig,\n           start and end of the contig can be thus found using:\n           my $start = $contigobj->range()->start();\n           my $end   = $contigobj->range()->end();\n Args    : none to get, OR Bio::Range to set\n\n\nsub range {\n    my ($self) = shift;\n    return $self->{'_range'} = shift if @_;\n    return $self->{'_range'};\n}\n\n=head2 position\n\n Title   : position\n Usage   : $ctgpos = $contigobj->position();\n Function: Get/set the position of the contig in the group\n Returns : scalar representing the position of the contig in the group\n Args    : none to get, OR string to set\n\n\nsub position {\n    my ($self) = shift;\n    $self->{'_position'} = shift if @_;\n    return $self->{'_position'} || 0;\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : $ctganchor = $contig->anchor();\n Function: Get/set the anchor value for this Contig (True | False)\n Returns : scalar representing the anchor (1 | 0) for this contig\n Args    : none to get, OR string to set\n\n\nsub anchor {\n    my ($self) = shift;\n    return $self->{'_anchor'} = shift if @_;\n    return $self->{'_anchor'};\n}\n\n=head2 group\n\n Title   : group\n Usage   : $groupno = $contigobj->group();\n Function: Get/set the group number for this contig.\n           This is a generic term, used for Linkage-Groups as well as for\n           Chromosomes. \n Returns : scalar representing the group number of this contig\n Args    : none\n\n\nsub group {\n    my ($self) = shift;\n    $self->{'_group'} = shift if @_;\n    return $self->{'_group'} || 0;\n}\n\n=head2 subgroup\n\n Title   : subgroup\n Usage   : $subgroup = $contig->subgroup();\t\n Function: Get/set the subgroup for this contig. This is a generic term:\n           subgroup here could represent subgroup of a Chromosome or of a\n           Linkage Group. The user must take care of which subgroup he/she is\n           querying for.\t\n Returns : A scalar representing the subgroup of this contig\n Args    : none\n\n\nsub subgroup {\n    my ($self) = @_;\n    return $self->{'_subgroup'} = shift if @_;\n    return $self->{'_subgroup'} || 0;\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones  = $map->each_cloneid();\n Function: retrieves all the clone ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_clones method ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return $self->_each_element('clones');\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: retrieves all the marker ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_markers method ***\n *** It has nothing to do with actual Bio::Map::MarkerI objects ***","label":"each_markerid($self)"},"detail":"($self)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"each_markerid","localvar":"my","kind":13,"line":361},{"line":362,"kind":13,"containerName":"each_markerid","name":"$self"},{"line":362,"kind":12,"containerName":"each_markerid","name":"_each_element"}],"line":360,"name":"each_markerid","range":{"start":{"character":0,"line":360},"end":{"character":9999,"line":363}}},{"containerName":"main::","definition":"sub","detail":"($self,$type)","signature":{"label":"_each_element($self,$type)","documentation":"","parameters":[{"label":"$self"},{"label":"$type"}]},"kind":12,"line":365,"children":[{"containerName":"_each_element","name":"$self","definition":"my","localvar":"my","kind":13,"line":366},{"kind":13,"line":366,"containerName":"_each_element","name":"$type"},{"kind":13,"line":367,"containerName":"_each_element","name":"$type"},{"name":"$type","containerName":"_each_element","kind":13,"line":367},{"line":368,"kind":13,"containerName":"_each_element","name":"$type"},{"containerName":"_each_element","name":"$self","line":369,"kind":13},{"line":369,"kind":13,"containerName":"_each_element","name":"$type"}],"name":"_each_element","range":{"start":{"character":0,"line":365},"end":{"line":369,"character":9999}}},{"detail":"($self,$clones)","signature":{"label":"set_clones($self,$clones)","documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Contig\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Contig - A MapI implementation handling the contigs of a\nPhysical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    # get the contig object of $contig from the Bio::Map::Physical\n    my $ctgobj = $physical->get_contigobj($contig);\n\n    # acquire all the markers that lie in this contig\n    foreach my $marker ($ctgobj->each_markerid()) {\n\tprint \"   +++$marker\\n\";\n    }\n\n    # find the group of this contig\n    print \"Group: \",$ctgobj->group(),\"\\n\";\n\n    # find the range of this contig\n    print \"RANGE: start:\",$ctgobj->range()->start(),\"\\tend: \",\n           $ctgobj->range()->end(),\"\\n\";\n\n    # find the position of this contig in $group (chromosome)\n    print \"Position in Group $group\",\" = \",$ctgobj->position($group),\"\\n\";\n\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::Map::MapI.  It handles the\nessential storage of name, species, type, and units as well as in\nmemory representation of the elements of a map.\n\nBio::Map::Contig has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Contig;\nuse vars qw($MAPCOUNT);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Range;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::Contig->new\n                      (\n\t\t       -name    => $name,\n\t\t       -chr_remark   => $cremark,\n\t\t       -user_remark  => $uremark,\n\t\t       -trace_remark => $tremark,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -markers => \\%markers,\n\t\t       -clones  => \\%clones,\n\t\t       -position => $pos\n\t\t       -range    => Bio::Range->new(-start =>$s,-end=>$e),\n\t\t       );\n\n Function: Initialize a new Bio::Map::Contig object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::Contig> object\n Args    : ( -name    => name string,\n\t     -chr_remark   => chr remark string,\n\t     -user_remark  => userremark string,\n\t     -trace_remark => tremark string,\n\t     -group   => group string,\n\t     -subgroup=> subgroup string,\n\t     -anchor  => boolean if this is anchored or not,\n\t     -markers => hashref of contained markers,\n\t     -clones  => hashref of contained clones,\n\t     -position => position\n\t     -range    => L<Bio::Range>\n\n\nsub new {\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n\n   my ($name,$cremark,$uremark,$tremark,\n       $group,$subgroup, $anchor,$markers, $clones,\n       $position,$range) = $self->_rearrange([qw(NAME CHR_REMARK USER_REMARK\n\t\t\t\t\t\t TRACE_REMARK GROUP SUBGROUP\n\t\t\t\t\t\t ANCHOR MARKERS CLONES\n\t\t\t\t\t\t POSITION RANGE)],@args);\n\n   $self->name($name)                  if defined $name;\n   $self->chr_remark($cremark)         if defined $cremark;\n   $self->user_remark($uremark)        if defined $uremark;\n   $self->trace_remark($tremark)       if defined $tremark;\n   $self->group($group)                if defined $group;\n   $self->subgroup($group)             if defined $subgroup;\n   $self->anchor($anchor)              if defined $anchor;\n\n   $self->set_markers($markers)        if defined $markers;\n   $self->set_clones($clones)          if defined $clones;\n   $self->range($range)                if defined $range;\n   $self->position($position)          if defined $position;\n\n   return $self;\n}\n\n=head2 Modifier methods\n\nAll methods present in L<Bio::Map::SimpleMap> are implemented by this class.\nMost of the methods are inherited from SimpleMap.  The following methods\nhave been modified to reflect the needs of physical maps.\n\n=head2 chr_remark\n\n Title   : chr_remark\n Usage   : my $chrremark = $contigobj->chr_remark();\n Function: Get/set the group remark for this contig\n Returns : scalar representing the current group_remark of this contig\n Args    : none to get, OR string to set\n\n\nsub chr_remark {\n    my ($self) = shift;\n    $self->{'_cremark'} = shift if @_;\n    return defined $self->{'_cremark'} ? $self->{'_cremark'} : '';\n}\n\n=head2 user_remark\n\n Title   : user_remark\n Usage   : my $userremark = $contigobj->user_remark();\n Function: Get/set the user remark for this contig\n Returns : scalar representing the current user_remark of this contig\n Args    : none to get, OR string to set\n\n\nsub user_remark {\n    my ($self) = shift;\n    $self->{'_uremark'} = shift if @_;\n    return defined $self->{'_uremark'} ? $self->{'_uremark'} : '';\n}\n\n=head2 trace_remark\n\n Title   : trace_remark\n Usage   : my $traceremark = $contigobj->trace_remark();\n Function: Get/set the trace remark for this contig\n Returns : scalar representing the current trace_remark of this contig\n Args    : none to get, OR string to set\n\n\nsub trace_remark {\n    my ($self) = shift;\n    $self->{'_tremark'} = shift if @_;\n    return defined $self->{'_tremark'} ? $self->{'_tremark'} : '';\n}\n\n=head2 range\n\n Title   : range\n Usage   : my $range = $contigobj->range();\n Function: Get/set the range for this Contig\n Returns : Bio::Range representing the current range of this contig,\n           start and end of the contig can be thus found using:\n           my $start = $contigobj->range()->start();\n           my $end   = $contigobj->range()->end();\n Args    : none to get, OR Bio::Range to set\n\n\nsub range {\n    my ($self) = shift;\n    return $self->{'_range'} = shift if @_;\n    return $self->{'_range'};\n}\n\n=head2 position\n\n Title   : position\n Usage   : $ctgpos = $contigobj->position();\n Function: Get/set the position of the contig in the group\n Returns : scalar representing the position of the contig in the group\n Args    : none to get, OR string to set\n\n\nsub position {\n    my ($self) = shift;\n    $self->{'_position'} = shift if @_;\n    return $self->{'_position'} || 0;\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : $ctganchor = $contig->anchor();\n Function: Get/set the anchor value for this Contig (True | False)\n Returns : scalar representing the anchor (1 | 0) for this contig\n Args    : none to get, OR string to set\n\n\nsub anchor {\n    my ($self) = shift;\n    return $self->{'_anchor'} = shift if @_;\n    return $self->{'_anchor'};\n}\n\n=head2 group\n\n Title   : group\n Usage   : $groupno = $contigobj->group();\n Function: Get/set the group number for this contig.\n           This is a generic term, used for Linkage-Groups as well as for\n           Chromosomes. \n Returns : scalar representing the group number of this contig\n Args    : none\n\n\nsub group {\n    my ($self) = shift;\n    $self->{'_group'} = shift if @_;\n    return $self->{'_group'} || 0;\n}\n\n=head2 subgroup\n\n Title   : subgroup\n Usage   : $subgroup = $contig->subgroup();\t\n Function: Get/set the subgroup for this contig. This is a generic term:\n           subgroup here could represent subgroup of a Chromosome or of a\n           Linkage Group. The user must take care of which subgroup he/she is\n           querying for.\t\n Returns : A scalar representing the subgroup of this contig\n Args    : none\n\n\nsub subgroup {\n    my ($self) = @_;\n    return $self->{'_subgroup'} = shift if @_;\n    return $self->{'_subgroup'} || 0;\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones  = $map->each_cloneid();\n Function: retrieves all the clone ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_clones method ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return $self->_each_element('clones');\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: retrieves all the marker ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_markers method ***\n *** It has nothing to do with actual Bio::Map::MarkerI objects ***\n\n\nsub each_markerid {\n    my ($self) = @_;\n    return $self->_each_element('markers');\n}\n\nsub _each_element {\n    my ($self, $type) = @_;\n    $type = 'clones' if (!defined($type));\n    $type = lc(\"_$type\");\n    return keys %{$self->{$type} || {}};\n}\n\n=head2 set_clones\n\n Title   : set_clones\n Usage   : $marker->set_clones(\\%clones)\n Function: Set the clones hashref\n Returns : None\n Args    : Hashref of clone ids\n\n *** This only sets a hash of ids ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***","parameters":[{"label":"$self"},{"label":"$clones"}]},"containerName":"main::","definition":"sub","line":385,"children":[{"definition":"my","name":"$self","containerName":"set_clones","localvar":"my","kind":13,"line":386},{"kind":13,"line":386,"containerName":"set_clones","name":"$clones"},{"name":"$clones","containerName":"set_clones","line":387,"kind":13},{"line":387,"kind":13,"containerName":"set_clones","name":"$clones"},{"kind":13,"line":388,"containerName":"set_clones","name":"$self"},{"line":388,"kind":13,"name":"$clones","containerName":"set_clones"}],"kind":12,"range":{"end":{"line":390,"character":9999},"start":{"character":0,"line":385}},"name":"set_clones"},{"line":405,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"set_markers","line":406,"kind":13},{"line":406,"kind":13,"containerName":"set_markers","name":"$markers"},{"line":407,"kind":13,"containerName":"set_markers","name":"$markers"},{"kind":13,"line":407,"name":"$markers","containerName":"set_markers"},{"line":408,"kind":13,"containerName":"set_markers","name":"$self"},{"name":"$markers","containerName":"set_markers","line":408,"kind":13}],"kind":12,"detail":"($self,$markers)","signature":{"label":"set_markers($self,$markers)","parameters":[{"label":"$self"},{"label":"$markers"}],"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Contig\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Contig - A MapI implementation handling the contigs of a\nPhysical Map (such as FPC)\n\n=head1 SYNOPSIS\n\n    # get the contig object of $contig from the Bio::Map::Physical\n    my $ctgobj = $physical->get_contigobj($contig);\n\n    # acquire all the markers that lie in this contig\n    foreach my $marker ($ctgobj->each_markerid()) {\n\tprint \"   +++$marker\\n\";\n    }\n\n    # find the group of this contig\n    print \"Group: \",$ctgobj->group(),\"\\n\";\n\n    # find the range of this contig\n    print \"RANGE: start:\",$ctgobj->range()->start(),\"\\tend: \",\n           $ctgobj->range()->end(),\"\\n\";\n\n    # find the position of this contig in $group (chromosome)\n    print \"Position in Group $group\",\" = \",$ctgobj->position($group),\"\\n\";\n\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::Map::MapI.  It handles the\nessential storage of name, species, type, and units as well as in\nmemory representation of the elements of a map.\n\nBio::Map::Contig has been tailored to work for FPC physical maps, but\ncould probably be used for others as well (with the appropriate MapIO\nmodule).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Contig;\nuse vars qw($MAPCOUNT);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Range;\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::Contig->new\n                      (\n\t\t       -name    => $name,\n\t\t       -chr_remark   => $cremark,\n\t\t       -user_remark  => $uremark,\n\t\t       -trace_remark => $tremark,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -markers => \\%markers,\n\t\t       -clones  => \\%clones,\n\t\t       -position => $pos\n\t\t       -range    => Bio::Range->new(-start =>$s,-end=>$e),\n\t\t       );\n\n Function: Initialize a new Bio::Map::Contig object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::Contig> object\n Args    : ( -name    => name string,\n\t     -chr_remark   => chr remark string,\n\t     -user_remark  => userremark string,\n\t     -trace_remark => tremark string,\n\t     -group   => group string,\n\t     -subgroup=> subgroup string,\n\t     -anchor  => boolean if this is anchored or not,\n\t     -markers => hashref of contained markers,\n\t     -clones  => hashref of contained clones,\n\t     -position => position\n\t     -range    => L<Bio::Range>\n\n\nsub new {\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n\n   my ($name,$cremark,$uremark,$tremark,\n       $group,$subgroup, $anchor,$markers, $clones,\n       $position,$range) = $self->_rearrange([qw(NAME CHR_REMARK USER_REMARK\n\t\t\t\t\t\t TRACE_REMARK GROUP SUBGROUP\n\t\t\t\t\t\t ANCHOR MARKERS CLONES\n\t\t\t\t\t\t POSITION RANGE)],@args);\n\n   $self->name($name)                  if defined $name;\n   $self->chr_remark($cremark)         if defined $cremark;\n   $self->user_remark($uremark)        if defined $uremark;\n   $self->trace_remark($tremark)       if defined $tremark;\n   $self->group($group)                if defined $group;\n   $self->subgroup($group)             if defined $subgroup;\n   $self->anchor($anchor)              if defined $anchor;\n\n   $self->set_markers($markers)        if defined $markers;\n   $self->set_clones($clones)          if defined $clones;\n   $self->range($range)                if defined $range;\n   $self->position($position)          if defined $position;\n\n   return $self;\n}\n\n=head2 Modifier methods\n\nAll methods present in L<Bio::Map::SimpleMap> are implemented by this class.\nMost of the methods are inherited from SimpleMap.  The following methods\nhave been modified to reflect the needs of physical maps.\n\n=head2 chr_remark\n\n Title   : chr_remark\n Usage   : my $chrremark = $contigobj->chr_remark();\n Function: Get/set the group remark for this contig\n Returns : scalar representing the current group_remark of this contig\n Args    : none to get, OR string to set\n\n\nsub chr_remark {\n    my ($self) = shift;\n    $self->{'_cremark'} = shift if @_;\n    return defined $self->{'_cremark'} ? $self->{'_cremark'} : '';\n}\n\n=head2 user_remark\n\n Title   : user_remark\n Usage   : my $userremark = $contigobj->user_remark();\n Function: Get/set the user remark for this contig\n Returns : scalar representing the current user_remark of this contig\n Args    : none to get, OR string to set\n\n\nsub user_remark {\n    my ($self) = shift;\n    $self->{'_uremark'} = shift if @_;\n    return defined $self->{'_uremark'} ? $self->{'_uremark'} : '';\n}\n\n=head2 trace_remark\n\n Title   : trace_remark\n Usage   : my $traceremark = $contigobj->trace_remark();\n Function: Get/set the trace remark for this contig\n Returns : scalar representing the current trace_remark of this contig\n Args    : none to get, OR string to set\n\n\nsub trace_remark {\n    my ($self) = shift;\n    $self->{'_tremark'} = shift if @_;\n    return defined $self->{'_tremark'} ? $self->{'_tremark'} : '';\n}\n\n=head2 range\n\n Title   : range\n Usage   : my $range = $contigobj->range();\n Function: Get/set the range for this Contig\n Returns : Bio::Range representing the current range of this contig,\n           start and end of the contig can be thus found using:\n           my $start = $contigobj->range()->start();\n           my $end   = $contigobj->range()->end();\n Args    : none to get, OR Bio::Range to set\n\n\nsub range {\n    my ($self) = shift;\n    return $self->{'_range'} = shift if @_;\n    return $self->{'_range'};\n}\n\n=head2 position\n\n Title   : position\n Usage   : $ctgpos = $contigobj->position();\n Function: Get/set the position of the contig in the group\n Returns : scalar representing the position of the contig in the group\n Args    : none to get, OR string to set\n\n\nsub position {\n    my ($self) = shift;\n    $self->{'_position'} = shift if @_;\n    return $self->{'_position'} || 0;\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : $ctganchor = $contig->anchor();\n Function: Get/set the anchor value for this Contig (True | False)\n Returns : scalar representing the anchor (1 | 0) for this contig\n Args    : none to get, OR string to set\n\n\nsub anchor {\n    my ($self) = shift;\n    return $self->{'_anchor'} = shift if @_;\n    return $self->{'_anchor'};\n}\n\n=head2 group\n\n Title   : group\n Usage   : $groupno = $contigobj->group();\n Function: Get/set the group number for this contig.\n           This is a generic term, used for Linkage-Groups as well as for\n           Chromosomes. \n Returns : scalar representing the group number of this contig\n Args    : none\n\n\nsub group {\n    my ($self) = shift;\n    $self->{'_group'} = shift if @_;\n    return $self->{'_group'} || 0;\n}\n\n=head2 subgroup\n\n Title   : subgroup\n Usage   : $subgroup = $contig->subgroup();\t\n Function: Get/set the subgroup for this contig. This is a generic term:\n           subgroup here could represent subgroup of a Chromosome or of a\n           Linkage Group. The user must take care of which subgroup he/she is\n           querying for.\t\n Returns : A scalar representing the subgroup of this contig\n Args    : none\n\n\nsub subgroup {\n    my ($self) = @_;\n    return $self->{'_subgroup'} = shift if @_;\n    return $self->{'_subgroup'} || 0;\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones  = $map->each_cloneid();\n Function: retrieves all the clone ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_clones method ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return $self->_each_element('clones');\n}\n\n=head2 each_markerid\n\n Title   : each_markerid\n Usage   : my @markers = $map->each_markerid();\n Function: retrieves all the marker ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_markers method ***\n *** It has nothing to do with actual Bio::Map::MarkerI objects ***\n\n\nsub each_markerid {\n    my ($self) = @_;\n    return $self->_each_element('markers');\n}\n\nsub _each_element {\n    my ($self, $type) = @_;\n    $type = 'clones' if (!defined($type));\n    $type = lc(\"_$type\");\n    return keys %{$self->{$type} || {}};\n}\n\n=head2 set_clones\n\n Title   : set_clones\n Usage   : $marker->set_clones(\\%clones)\n Function: Set the clones hashref\n Returns : None\n Args    : Hashref of clone ids\n\n *** This only sets a hash of ids ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***\n\n\nsub set_clones {\n   my ($self,$clones) = @_;\n   if( defined $clones && ref($clones) =~ /HASH/ ) {\n       $self->{'_clones'} = $clones;\n   }\n}\n\n=head2 set_markers\n\n Title   : markers\n Usage   : $obj->set_markers($newval)\n Function: Set list of Markers (hashref)\n Returns : None\n Args    : Hashref of marker ids\n\n *** This only sets a hash of ids ***\n *** It has nothing to do with actual Bio::Map::MarkerI objects ***"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":410},"start":{"line":405,"character":0}},"name":"set_markers"}]}