{"vars":[{"line":86,"kind":2,"containerName":"","name":"base"},{"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: CoordinatePolicyI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::CoordinatePolicyI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#          and Jason Stajich <jason@bioperl.org>\n#\n# Copyright Hilmar Lapp, Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::CoordinatePolicyI - Abstract interface for objects implementing\na certain policy of computing integer-valued coordinates of a Location\n\n=head1 SYNOPSIS\n\n    # get a location, e.g., from a SeqFeature\n    $location = $feature->location();\n    # examine its coordinate computation policy\n    print \"Location of feature \", $feature->primary_tag(), \" employs a \",\n          ref($location->coordinate_policy()), \n          \" instance for coordinate computation\\n\";\n    # change the policy, e.g. because the user chose to do so\n    $location->coordinate_policy(Bio::Location::NarrowestCoordPolicy->new());\n\n=head1 DESCRIPTION\n\nObjects implementing this interface are used by Bio::LocationI\nimplementing objects to determine integer-valued coordinates when\nasked for it. While this may seem trivial for simple locations, there\nare different ways to do it for fuzzy or compound (split)\nlocations. Classes implementing this interface implement a certain\npolicy, like 'always widest range', 'always smallest range', 'mean for\nBETWEEN locations', etc. By installing a different policy object in a\nLocation object, the behaviour of coordinate computation can be changed\non-the-fly, and with a single line of code client-side.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Jason Stajich\n\nEmail hlapp@gmx.net, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::CoordinatePolicyI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $policy->start($location);\n  Function: Get the integer-valued start coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object.","label":"start($self)"},"containerName":"main::","definition":"sub","line":99,"children":[{"line":100,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"start"},{"name":"$self","containerName":"start","line":101,"kind":13},{"containerName":"start","name":"throw_not_implemented","line":101,"kind":12}],"kind":12,"range":{"end":{"character":9999,"line":102},"start":{"character":0,"line":99}},"name":"start"},{"range":{"end":{"line":118,"character":9999},"start":{"character":0,"line":115}},"name":"end","line":115,"children":[{"localvar":"my","containerName":"end","name":"$self","definition":"my","line":116,"kind":13},{"name":"$self","containerName":"end","kind":13,"line":117},{"name":"throw_not_implemented","containerName":"end","line":117,"kind":12}],"kind":12,"detail":"($self)","signature":{"documentation":"1;\n# $Id: CoordinatePolicyI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::CoordinatePolicyI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#          and Jason Stajich <jason@bioperl.org>\n#\n# Copyright Hilmar Lapp, Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::CoordinatePolicyI - Abstract interface for objects implementing\na certain policy of computing integer-valued coordinates of a Location\n\n=head1 SYNOPSIS\n\n    # get a location, e.g., from a SeqFeature\n    $location = $feature->location();\n    # examine its coordinate computation policy\n    print \"Location of feature \", $feature->primary_tag(), \" employs a \",\n          ref($location->coordinate_policy()), \n          \" instance for coordinate computation\\n\";\n    # change the policy, e.g. because the user chose to do so\n    $location->coordinate_policy(Bio::Location::NarrowestCoordPolicy->new());\n\n=head1 DESCRIPTION\n\nObjects implementing this interface are used by Bio::LocationI\nimplementing objects to determine integer-valued coordinates when\nasked for it. While this may seem trivial for simple locations, there\nare different ways to do it for fuzzy or compound (split)\nlocations. Classes implementing this interface implement a certain\npolicy, like 'always widest range', 'always smallest range', 'mean for\nBETWEEN locations', etc. By installing a different policy object in a\nLocation object, the behaviour of coordinate computation can be changed\non-the-fly, and with a single line of code client-side.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Jason Stajich\n\nEmail hlapp@gmx.net, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::CoordinatePolicyI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $policy->start($location);\n  Function: Get the integer-valued start coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object.\n\n\nsub start {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $policy->end($location);\n  Function: Get the integer-valued end coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object.","parameters":[{"label":"$self"}],"label":"end($self)"},"containerName":"main::","definition":"sub"}],"version":5}