{"vars":[{"line":81,"kind":2,"containerName":"","name":"base"},{"name":"$coord_policy","definition":"our","containerName":"main::","kind":13,"line":83},{"kind":12,"line":83,"containerName":"Location::WidestCoordPolicy","name":"Bio"},{"line":83,"kind":12,"containerName":"main::","name":"new"},{"detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""},"containerName":"main::","definition":"sub","line":85,"children":[{"localvar":"my","containerName":"new","definition":"my","name":"$class","line":86,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":86},{"kind":13,"line":87,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"line":95,"kind":13,"containerName":"new","name":"$class"},{"containerName":"new","name":"$class","kind":13,"line":95},{"name":"$class","containerName":"new","line":95,"kind":13},{"line":96,"kind":12,"containerName":"new","name":"_load_module"},{"line":96,"kind":13,"containerName":"new","name":"$class"},{"name":"throw","containerName":"new","kind":12,"line":99},{"containerName":"new","name":"$self","line":101,"kind":13},{"kind":13,"line":101,"containerName":"new","name":"$class"},{"localvar":"my","containerName":"new","name":"$v","definition":"my","line":103,"kind":13},{"name":"$start","containerName":"new","kind":13,"line":103},{"name":"$end","containerName":"new","kind":13,"line":103},{"kind":13,"line":103,"name":"$strand","containerName":"new"},{"containerName":"new","name":"$seqid","line":103,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":103},{"line":103,"kind":12,"name":"_rearrange","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":107},{"name":"$v","containerName":"new","kind":13,"line":108},{"kind":13,"line":108,"name":"$self","containerName":"new"},{"line":108,"kind":12,"containerName":"new","name":"verbose"},{"kind":13,"line":108,"containerName":"new","name":"$v"},{"containerName":"new","name":"$strand","line":109,"kind":13},{"containerName":"new","name":"$self","line":109,"kind":13},{"containerName":"new","name":"strand","line":109,"kind":12},{"name":"$strand","containerName":"new","line":109,"kind":13},{"name":"$start","containerName":"new","line":111,"kind":13},{"kind":13,"line":111,"name":"$self","containerName":"new"},{"containerName":"new","name":"start","line":111,"kind":12},{"line":111,"kind":13,"containerName":"new","name":"$start"},{"name":"$end","containerName":"new","line":112,"kind":13},{"line":112,"kind":13,"name":"$self","containerName":"new"},{"line":112,"kind":12,"name":"end","containerName":"new"},{"name":"$end","containerName":"new","line":112,"kind":13},{"name":"$self","containerName":"new","line":113,"kind":13},{"kind":12,"line":113,"containerName":"new","name":"start"},{"name":"$self","containerName":"new","kind":13,"line":113},{"kind":12,"line":113,"name":"end","containerName":"new"},{"name":"$self","containerName":"new","line":114,"kind":13},{"line":114,"kind":12,"name":"start","containerName":"new"},{"name":"$self","containerName":"new","line":114,"kind":13},{"name":"end","containerName":"new","kind":12,"line":114},{"kind":13,"line":114,"name":"$self","containerName":"new"},{"name":"strand","containerName":"new","line":114,"kind":12},{"line":115,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"warn","kind":12,"line":115},{"containerName":"new","name":"$self","line":118,"kind":13},{"name":"strand","containerName":"new","kind":12,"line":118},{"localvar":"my","containerName":"new","name":"$e","definition":"my","line":119,"kind":13},{"line":119,"kind":13,"containerName":"new","name":"$self"},{"name":"end","containerName":"new","kind":12,"line":119},{"line":120,"kind":13,"localvar":"my","containerName":"new","name":"$s","definition":"my"},{"containerName":"new","name":"$self","kind":13,"line":120},{"kind":12,"line":120,"name":"start","containerName":"new"},{"line":121,"kind":13,"name":"$self","containerName":"new"},{"name":"start","containerName":"new","kind":12,"line":121},{"kind":13,"line":121,"containerName":"new","name":"$e"},{"line":122,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":122,"name":"end","containerName":"new"},{"kind":13,"line":122,"containerName":"new","name":"$s"},{"name":"$seqid","containerName":"new","line":124,"kind":13},{"containerName":"new","name":"$self","line":124,"kind":13},{"line":124,"kind":12,"name":"seq_id","containerName":"new"},{"line":124,"kind":13,"containerName":"new","name":"$seqid"},{"name":"$self","containerName":"new","line":126,"kind":13}],"kind":12,"range":{"end":{"character":9999,"line":127},"start":{"line":85,"character":0}},"name":"new"},{"containerName":"Root::Root","name":"Bio","line":96,"kind":12},{"kind":12,"line":99,"containerName":"Root::Root","name":"Bio"},{"range":{"end":{"line":144,"character":9999},"start":{"line":140,"character":0}},"name":"start","signature":{"documentation":"1;\n# $Id: Atomic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Atomic\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Atomic - Implementation of a Atomic Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Atomic;\n\n    my $location = Bio::Location::Atomic->new(-start => 1, -end => 100,\n\t\t\t\t\t     -strand => 1 );\n\n    if( $location->strand == -1 ) {\n\tprintf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n\tprintf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage simple location\ninformation on a Sequence.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Atomic;\nuse strict;\n\nuse Bio::Location::WidestCoordPolicy;\n\nuse base qw(Bio::Root::Root Bio::LocationI);\n\nour $coord_policy = Bio::Location::WidestCoordPolicy->new();\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = {};\n    # This is for the case when we've done something like this\n    # get a 2 features from somewhere (like Bio::Tools::GFF)\n    # Do\n    # my $location = $f1->location->union($f2->location);\n    # We get an error without the following code which \n    # explictly loads the Bio::Location::Simple class\n    eval {\n\t($class) = ref($class) if ref($class);\n\tBio::Root::Root->_load_module($class);\n      };\n    if ( $@ ) {\n\tBio::Root::Root->throw(\"$class cannot be found\\nException $@\");\n      }\n    bless $self,$class;\n\n    my ($v,$start,$end,$strand,$seqid) = $self->_rearrange([qw(VERBOSE\n\t\t\t\t\t\t\t       START\n\t\t\t\t\t\t\t       END\n\t\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t\t       SEQ_ID)],@args);\n    defined $v && $self->verbose($v);\n    defined $strand && $self->strand($strand);\n\n    defined $start  && $self->start($start);\n    defined $end    && $self->end($end);\n    if( defined $self->start && defined $self->end &&\n\t$self->start > $self->end && $self->strand != -1 ) {\n\t$self->warn(\"When building a location, start ($start) is expected to be less than end ($end), \".\n\t\t    \"however it was not. Switching start and end and setting strand to -1\");\n\n\t$self->strand(-1);\n\tmy $e = $self->end;\n\tmy $s = $self->start;\n\t$self->start($e);\n\t$self->end($s);\n    }\n    $seqid          && $self->seq_id($seqid);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"start($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"line":141,"kind":13,"localvar":"my","containerName":"start","definition":"my","name":"$self"},{"containerName":"start","name":"$value","line":141,"kind":13},{"name":"$self","containerName":"start","kind":13,"line":142},{"name":"min_start","containerName":"start","line":142,"kind":12},{"containerName":"start","name":"$value","kind":13,"line":142},{"line":142,"kind":13,"name":"$value","containerName":"start"},{"kind":13,"line":143,"containerName":"start","name":"$self"}],"line":140,"kind":12},{"containerName":"start","name":"SUPER","line":143,"kind":12},{"children":[{"kind":13,"line":158,"name":"$self","definition":"my","containerName":"end","localvar":"my"},{"containerName":"end","name":"$value","line":158,"kind":13},{"name":"$self","containerName":"end","line":160,"kind":13},{"name":"min_end","containerName":"end","line":160,"kind":12},{"kind":13,"line":160,"containerName":"end","name":"$value"},{"kind":13,"line":160,"name":"$value","containerName":"end"},{"name":"$self","containerName":"end","kind":13,"line":161}],"line":157,"kind":12,"signature":{"label":"end($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Atomic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Atomic\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Atomic - Implementation of a Atomic Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Atomic;\n\n    my $location = Bio::Location::Atomic->new(-start => 1, -end => 100,\n\t\t\t\t\t     -strand => 1 );\n\n    if( $location->strand == -1 ) {\n\tprintf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n\tprintf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage simple location\ninformation on a Sequence.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Atomic;\nuse strict;\n\nuse Bio::Location::WidestCoordPolicy;\n\nuse base qw(Bio::Root::Root Bio::LocationI);\n\nour $coord_policy = Bio::Location::WidestCoordPolicy->new();\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = {};\n    # This is for the case when we've done something like this\n    # get a 2 features from somewhere (like Bio::Tools::GFF)\n    # Do\n    # my $location = $f1->location->union($f2->location);\n    # We get an error without the following code which \n    # explictly loads the Bio::Location::Simple class\n    eval {\n\t($class) = ref($class) if ref($class);\n\tBio::Root::Root->_load_module($class);\n      };\n    if ( $@ ) {\n\tBio::Root::Root->throw(\"$class cannot be found\\nException $@\");\n      }\n    bless $self,$class;\n\n    my ($v,$start,$end,$strand,$seqid) = $self->_rearrange([qw(VERBOSE\n\t\t\t\t\t\t\t       START\n\t\t\t\t\t\t\t       END\n\t\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t\t       SEQ_ID)],@args);\n    defined $v && $self->verbose($v);\n    defined $strand && $self->strand($strand);\n\n    defined $start  && $self->start($start);\n    defined $end    && $self->end($end);\n    if( defined $self->start && defined $self->end &&\n\t$self->start > $self->end && $self->strand != -1 ) {\n\t$self->warn(\"When building a location, start ($start) is expected to be less than end ($end), \".\n\t\t    \"however it was not. Switching start and end and setting strand to -1\");\n\n\t$self->strand(-1);\n\tmy $e = $self->end;\n\tmy $s = $self->start;\n\t$self->start($e);\n\t$self->end($s);\n    }\n    $seqid          && $self->seq_id($seqid);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n  $self->min_start($value) if( defined $value );\n  return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":157},"end":{"character":9999,"line":162}},"name":"end"},{"kind":12,"line":161,"name":"SUPER","containerName":"end"},{"line":175,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"strand","line":176,"kind":13},{"kind":13,"line":179,"definition":"my","name":"$value","containerName":"strand","localvar":"my"},{"line":180,"kind":13,"name":"$value","containerName":"strand"},{"name":"$value","containerName":"strand","line":181,"kind":13},{"line":181,"kind":13,"containerName":"strand","name":"$value"},{"kind":13,"line":182,"containerName":"strand","name":"$value"},{"line":182,"kind":13,"containerName":"strand","name":"$value"},{"kind":13,"line":183,"containerName":"strand","name":"$value"},{"kind":13,"line":183,"name":"$value","containerName":"strand"},{"name":"$value","containerName":"strand","kind":13,"line":184},{"containerName":"strand","name":"$value","line":184,"kind":13},{"containerName":"strand","name":"$value","line":184,"kind":13},{"containerName":"strand","name":"$self","kind":13,"line":185},{"kind":12,"line":185,"name":"throw","containerName":"strand"},{"line":187,"kind":13,"name":"$self","containerName":"strand"},{"containerName":"strand","name":"$value","line":187,"kind":13},{"kind":13,"line":191,"containerName":"strand","name":"$self"}],"kind":12,"range":{"start":{"line":175,"character":0},"end":{"character":9999,"line":193}},"containerName":"main::","definition":"sub","name":"strand"},{"children":[{"line":207,"kind":13,"localvar":"my","containerName":"flip_strand","name":"$self","definition":"my"},{"line":208,"kind":13,"name":"$self","containerName":"flip_strand"},{"line":208,"kind":12,"containerName":"flip_strand","name":"strand"},{"kind":13,"line":208,"name":"$self","containerName":"flip_strand"},{"containerName":"flip_strand","name":"strand","line":208,"kind":12}],"line":206,"kind":12,"range":{"start":{"line":206,"character":0},"end":{"character":9999,"line":209}},"definition":"sub","name":"flip_strand","containerName":"main::"},{"definition":"sub","containerName":"main::","signature":{"label":"seq_id($self,$seqid)","parameters":[{"label":"$self"},{"label":"$seqid"}],"documentation":"1;\n# $Id: Atomic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Atomic\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Atomic - Implementation of a Atomic Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Atomic;\n\n    my $location = Bio::Location::Atomic->new(-start => 1, -end => 100,\n\t\t\t\t\t     -strand => 1 );\n\n    if( $location->strand == -1 ) {\n\tprintf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n\tprintf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage simple location\ninformation on a Sequence.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Atomic;\nuse strict;\n\nuse Bio::Location::WidestCoordPolicy;\n\nuse base qw(Bio::Root::Root Bio::LocationI);\n\nour $coord_policy = Bio::Location::WidestCoordPolicy->new();\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = {};\n    # This is for the case when we've done something like this\n    # get a 2 features from somewhere (like Bio::Tools::GFF)\n    # Do\n    # my $location = $f1->location->union($f2->location);\n    # We get an error without the following code which \n    # explictly loads the Bio::Location::Simple class\n    eval {\n\t($class) = ref($class) if ref($class);\n\tBio::Root::Root->_load_module($class);\n      };\n    if ( $@ ) {\n\tBio::Root::Root->throw(\"$class cannot be found\\nException $@\");\n      }\n    bless $self,$class;\n\n    my ($v,$start,$end,$strand,$seqid) = $self->_rearrange([qw(VERBOSE\n\t\t\t\t\t\t\t       START\n\t\t\t\t\t\t\t       END\n\t\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t\t       SEQ_ID)],@args);\n    defined $v && $self->verbose($v);\n    defined $strand && $self->strand($strand);\n\n    defined $start  && $self->start($start);\n    defined $end    && $self->end($end);\n    if( defined $self->start && defined $self->end &&\n\t$self->start > $self->end && $self->strand != -1 ) {\n\t$self->warn(\"When building a location, start ($start) is expected to be less than end ($end), \".\n\t\t    \"however it was not. Switching start and end and setting strand to -1\");\n\n\t$self->strand(-1);\n\tmy $e = $self->end;\n\tmy $s = $self->start;\n\t$self->start($e);\n\t$self->end($s);\n    }\n    $seqid          && $self->seq_id($seqid);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n  $self->min_start($value) if( defined $value );\n  return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n\n\nsub end {\n  my ($self, $value) = @_;\n\n  $self->min_end($value) if( defined $value );\n  return $self->SUPER::end();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandidness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\nsub strand {\n  my $self = shift;\n\n  if ( @_ ) {\n       my $value = shift;\n       if ( defined($value) ) {\n\t   if ( $value eq '+' ) { $value = 1; }\n\t   elsif ( $value eq '-' ) { $value = -1; }\n\t   elsif ( $value eq '.' ) { $value = 0; }\n\t   elsif ( $value != -1 && $value != 1 && $value != 0 ) {\n\t       $self->throw(\"$value is not a valid strand info\");\n\t   }\n           $self->{'_strand'} = $value;\n       }\n  }\n  # do not pretend the strand has been set if in fact it wasn't\n  return $self->{'_strand'};\n  #return $self->{'_strand'} || 0;\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set"},"detail":"($self,$seqid)","kind":12,"children":[{"kind":13,"line":224,"name":"$self","definition":"my","containerName":"seq_id","localvar":"my"},{"containerName":"seq_id","name":"$seqid","kind":13,"line":224},{"kind":13,"line":225,"containerName":"seq_id","name":"$seqid"},{"name":"$self","containerName":"seq_id","kind":13,"line":226},{"name":"$seqid","containerName":"seq_id","kind":13,"line":226},{"kind":13,"line":228,"containerName":"seq_id","name":"$self"}],"line":223,"name":"seq_id","range":{"start":{"character":0,"line":223},"end":{"line":229,"character":9999}}},{"name":"length","range":{"start":{"character":0,"line":243},"end":{"line":246,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"length($self)","documentation":"1;\n# $Id: Atomic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Atomic\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Atomic - Implementation of a Atomic Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Atomic;\n\n    my $location = Bio::Location::Atomic->new(-start => 1, -end => 100,\n\t\t\t\t\t     -strand => 1 );\n\n    if( $location->strand == -1 ) {\n\tprintf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n\tprintf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage simple location\ninformation on a Sequence.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Atomic;\nuse strict;\n\nuse Bio::Location::WidestCoordPolicy;\n\nuse base qw(Bio::Root::Root Bio::LocationI);\n\nour $coord_policy = Bio::Location::WidestCoordPolicy->new();\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = {};\n    # This is for the case when we've done something like this\n    # get a 2 features from somewhere (like Bio::Tools::GFF)\n    # Do\n    # my $location = $f1->location->union($f2->location);\n    # We get an error without the following code which \n    # explictly loads the Bio::Location::Simple class\n    eval {\n\t($class) = ref($class) if ref($class);\n\tBio::Root::Root->_load_module($class);\n      };\n    if ( $@ ) {\n\tBio::Root::Root->throw(\"$class cannot be found\\nException $@\");\n      }\n    bless $self,$class;\n\n    my ($v,$start,$end,$strand,$seqid) = $self->_rearrange([qw(VERBOSE\n\t\t\t\t\t\t\t       START\n\t\t\t\t\t\t\t       END\n\t\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t\t       SEQ_ID)],@args);\n    defined $v && $self->verbose($v);\n    defined $strand && $self->strand($strand);\n\n    defined $start  && $self->start($start);\n    defined $end    && $self->end($end);\n    if( defined $self->start && defined $self->end &&\n\t$self->start > $self->end && $self->strand != -1 ) {\n\t$self->warn(\"When building a location, start ($start) is expected to be less than end ($end), \".\n\t\t    \"however it was not. Switching start and end and setting strand to -1\");\n\n\t$self->strand(-1);\n\tmy $e = $self->end;\n\tmy $s = $self->start;\n\t$self->start($e);\n\t$self->end($s);\n    }\n    $seqid          && $self->seq_id($seqid);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n  $self->min_start($value) if( defined $value );\n  return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n\n\nsub end {\n  my ($self, $value) = @_;\n\n  $self->min_end($value) if( defined $value );\n  return $self->SUPER::end();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandidness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\nsub strand {\n  my $self = shift;\n\n  if ( @_ ) {\n       my $value = shift;\n       if ( defined($value) ) {\n\t   if ( $value eq '+' ) { $value = 1; }\n\t   elsif ( $value eq '-' ) { $value = -1; }\n\t   elsif ( $value eq '.' ) { $value = 0; }\n\t   elsif ( $value != -1 && $value != 1 && $value != 0 ) {\n\t       $self->throw(\"$value is not a valid strand info\");\n\t   }\n           $self->{'_strand'} = $value;\n       }\n  }\n  # do not pretend the strand has been set if in fact it wasn't\n  return $self->{'_strand'};\n  #return $self->{'_strand'} || 0;\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n    if( defined $seqid ) {\n\t$self->{'_seqid'} = $seqid;\n    }\n    return $self->{'_seqid'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $loc->length();\n Function: get the length in the coordinate space this location spans\n Example :\n Returns : an integer\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"line":244,"kind":13,"localvar":"my","containerName":"length","definition":"my","name":"$self"},{"name":"$self","containerName":"length","line":245,"kind":13},{"kind":12,"line":245,"containerName":"length","name":"end"},{"line":245,"kind":13,"containerName":"length","name":"$self"},{"line":245,"kind":12,"containerName":"length","name":"start"}],"line":243},{"range":{"start":{"character":0,"line":258},"end":{"character":9999,"line":265}},"name":"min_start","line":258,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"min_start","line":259,"kind":13},{"name":"$value","containerName":"min_start","kind":13,"line":259},{"line":261,"kind":13,"containerName":"min_start","name":"$value"},{"line":262,"kind":13,"containerName":"min_start","name":"$self"},{"kind":13,"line":262,"name":"$value","containerName":"min_start"},{"kind":13,"line":264,"containerName":"min_start","name":"$self"}],"kind":12,"detail":"($self,$value)","signature":{"label":"min_start($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Atomic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Atomic\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Atomic - Implementation of a Atomic Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Atomic;\n\n    my $location = Bio::Location::Atomic->new(-start => 1, -end => 100,\n\t\t\t\t\t     -strand => 1 );\n\n    if( $location->strand == -1 ) {\n\tprintf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n\tprintf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage simple location\ninformation on a Sequence.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Atomic;\nuse strict;\n\nuse Bio::Location::WidestCoordPolicy;\n\nuse base qw(Bio::Root::Root Bio::LocationI);\n\nour $coord_policy = Bio::Location::WidestCoordPolicy->new();\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = {};\n    # This is for the case when we've done something like this\n    # get a 2 features from somewhere (like Bio::Tools::GFF)\n    # Do\n    # my $location = $f1->location->union($f2->location);\n    # We get an error without the following code which \n    # explictly loads the Bio::Location::Simple class\n    eval {\n\t($class) = ref($class) if ref($class);\n\tBio::Root::Root->_load_module($class);\n      };\n    if ( $@ ) {\n\tBio::Root::Root->throw(\"$class cannot be found\\nException $@\");\n      }\n    bless $self,$class;\n\n    my ($v,$start,$end,$strand,$seqid) = $self->_rearrange([qw(VERBOSE\n\t\t\t\t\t\t\t       START\n\t\t\t\t\t\t\t       END\n\t\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t\t       SEQ_ID)],@args);\n    defined $v && $self->verbose($v);\n    defined $strand && $self->strand($strand);\n\n    defined $start  && $self->start($start);\n    defined $end    && $self->end($end);\n    if( defined $self->start && defined $self->end &&\n\t$self->start > $self->end && $self->strand != -1 ) {\n\t$self->warn(\"When building a location, start ($start) is expected to be less than end ($end), \".\n\t\t    \"however it was not. Switching start and end and setting strand to -1\");\n\n\t$self->strand(-1);\n\tmy $e = $self->end;\n\tmy $s = $self->start;\n\t$self->start($e);\n\t$self->end($s);\n    }\n    $seqid          && $self->seq_id($seqid);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n  $self->min_start($value) if( defined $value );\n  return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n\n\nsub end {\n  my ($self, $value) = @_;\n\n  $self->min_end($value) if( defined $value );\n  return $self->SUPER::end();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandidness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\nsub strand {\n  my $self = shift;\n\n  if ( @_ ) {\n       my $value = shift;\n       if ( defined($value) ) {\n\t   if ( $value eq '+' ) { $value = 1; }\n\t   elsif ( $value eq '-' ) { $value = -1; }\n\t   elsif ( $value eq '.' ) { $value = 0; }\n\t   elsif ( $value != -1 && $value != 1 && $value != 0 ) {\n\t       $self->throw(\"$value is not a valid strand info\");\n\t   }\n           $self->{'_strand'} = $value;\n       }\n  }\n  # do not pretend the strand has been set if in fact it wasn't\n  return $self->{'_strand'};\n  #return $self->{'_strand'} || 0;\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n    if( defined $seqid ) {\n\t$self->{'_seqid'} = $seqid;\n    }\n    return $self->{'_seqid'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $loc->length();\n Function: get the length in the coordinate space this location spans\n Example :\n Returns : an integer\n Args    : none\n\n\n\nsub length {\n   my ($self) = @_;\n   return abs($self->end() - $self->start()) + 1;\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting location of feature startpoint   \n  Returns : integer or undef if no minimum starting point.\n  Args    : none"},"containerName":"main::","definition":"sub"},{"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"max_start($self,@args)","documentation":"1;\n# $Id: Atomic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Atomic\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Atomic - Implementation of a Atomic Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Atomic;\n\n    my $location = Bio::Location::Atomic->new(-start => 1, -end => 100,\n\t\t\t\t\t     -strand => 1 );\n\n    if( $location->strand == -1 ) {\n\tprintf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n\tprintf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage simple location\ninformation on a Sequence.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Atomic;\nuse strict;\n\nuse Bio::Location::WidestCoordPolicy;\n\nuse base qw(Bio::Root::Root Bio::LocationI);\n\nour $coord_policy = Bio::Location::WidestCoordPolicy->new();\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = {};\n    # This is for the case when we've done something like this\n    # get a 2 features from somewhere (like Bio::Tools::GFF)\n    # Do\n    # my $location = $f1->location->union($f2->location);\n    # We get an error without the following code which \n    # explictly loads the Bio::Location::Simple class\n    eval {\n\t($class) = ref($class) if ref($class);\n\tBio::Root::Root->_load_module($class);\n      };\n    if ( $@ ) {\n\tBio::Root::Root->throw(\"$class cannot be found\\nException $@\");\n      }\n    bless $self,$class;\n\n    my ($v,$start,$end,$strand,$seqid) = $self->_rearrange([qw(VERBOSE\n\t\t\t\t\t\t\t       START\n\t\t\t\t\t\t\t       END\n\t\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t\t       SEQ_ID)],@args);\n    defined $v && $self->verbose($v);\n    defined $strand && $self->strand($strand);\n\n    defined $start  && $self->start($start);\n    defined $end    && $self->end($end);\n    if( defined $self->start && defined $self->end &&\n\t$self->start > $self->end && $self->strand != -1 ) {\n\t$self->warn(\"When building a location, start ($start) is expected to be less than end ($end), \".\n\t\t    \"however it was not. Switching start and end and setting strand to -1\");\n\n\t$self->strand(-1);\n\tmy $e = $self->end;\n\tmy $s = $self->start;\n\t$self->start($e);\n\t$self->end($s);\n    }\n    $seqid          && $self->seq_id($seqid);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n  $self->min_start($value) if( defined $value );\n  return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n\n\nsub end {\n  my ($self, $value) = @_;\n\n  $self->min_end($value) if( defined $value );\n  return $self->SUPER::end();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandidness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\nsub strand {\n  my $self = shift;\n\n  if ( @_ ) {\n       my $value = shift;\n       if ( defined($value) ) {\n\t   if ( $value eq '+' ) { $value = 1; }\n\t   elsif ( $value eq '-' ) { $value = -1; }\n\t   elsif ( $value eq '.' ) { $value = 0; }\n\t   elsif ( $value != -1 && $value != 1 && $value != 0 ) {\n\t       $self->throw(\"$value is not a valid strand info\");\n\t   }\n           $self->{'_strand'} = $value;\n       }\n  }\n  # do not pretend the strand has been set if in fact it wasn't\n  return $self->{'_strand'};\n  #return $self->{'_strand'} || 0;\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n    if( defined $seqid ) {\n\t$self->{'_seqid'} = $seqid;\n    }\n    return $self->{'_seqid'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $loc->length();\n Function: get the length in the coordinate space this location spans\n Example :\n Returns : an integer\n Args    : none\n\n\n\nsub length {\n   my ($self) = @_;\n   return abs($self->end() - $self->start()) + 1;\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting location of feature startpoint   \n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my ($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_start'} = $value;\n    }\n    return $self->{'_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint.\n\n            In this implementation this is exactly the same as min_start().\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"kind":12,"line":280,"children":[{"definition":"my","name":"$self","containerName":"max_start","localvar":"my","kind":13,"line":281},{"name":"@args","containerName":"max_start","line":281,"kind":13},{"line":282,"kind":13,"containerName":"max_start","name":"$self"},{"containerName":"max_start","name":"min_start","kind":12,"line":282},{"containerName":"max_start","name":"@args","line":282,"kind":13}],"name":"max_start","range":{"start":{"character":0,"line":280},"end":{"character":9999,"line":283}}},{"range":{"start":{"line":299,"character":0},"end":{"character":9999,"line":302}},"name":"start_pos_type","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"start_pos_type","line":300,"kind":13}],"line":299,"kind":12,"signature":{"documentation":"1;\n# $Id: Atomic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Atomic\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Atomic - Implementation of a Atomic Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Atomic;\n\n    my $location = Bio::Location::Atomic->new(-start => 1, -end => 100,\n\t\t\t\t\t     -strand => 1 );\n\n    if( $location->strand == -1 ) {\n\tprintf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n\tprintf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage simple location\ninformation on a Sequence.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Atomic;\nuse strict;\n\nuse Bio::Location::WidestCoordPolicy;\n\nuse base qw(Bio::Root::Root Bio::LocationI);\n\nour $coord_policy = Bio::Location::WidestCoordPolicy->new();\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = {};\n    # This is for the case when we've done something like this\n    # get a 2 features from somewhere (like Bio::Tools::GFF)\n    # Do\n    # my $location = $f1->location->union($f2->location);\n    # We get an error without the following code which \n    # explictly loads the Bio::Location::Simple class\n    eval {\n\t($class) = ref($class) if ref($class);\n\tBio::Root::Root->_load_module($class);\n      };\n    if ( $@ ) {\n\tBio::Root::Root->throw(\"$class cannot be found\\nException $@\");\n      }\n    bless $self,$class;\n\n    my ($v,$start,$end,$strand,$seqid) = $self->_rearrange([qw(VERBOSE\n\t\t\t\t\t\t\t       START\n\t\t\t\t\t\t\t       END\n\t\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t\t       SEQ_ID)],@args);\n    defined $v && $self->verbose($v);\n    defined $strand && $self->strand($strand);\n\n    defined $start  && $self->start($start);\n    defined $end    && $self->end($end);\n    if( defined $self->start && defined $self->end &&\n\t$self->start > $self->end && $self->strand != -1 ) {\n\t$self->warn(\"When building a location, start ($start) is expected to be less than end ($end), \".\n\t\t    \"however it was not. Switching start and end and setting strand to -1\");\n\n\t$self->strand(-1);\n\tmy $e = $self->end;\n\tmy $s = $self->start;\n\t$self->start($e);\n\t$self->end($s);\n    }\n    $seqid          && $self->seq_id($seqid);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n  $self->min_start($value) if( defined $value );\n  return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n\n\nsub end {\n  my ($self, $value) = @_;\n\n  $self->min_end($value) if( defined $value );\n  return $self->SUPER::end();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandidness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\nsub strand {\n  my $self = shift;\n\n  if ( @_ ) {\n       my $value = shift;\n       if ( defined($value) ) {\n\t   if ( $value eq '+' ) { $value = 1; }\n\t   elsif ( $value eq '-' ) { $value = -1; }\n\t   elsif ( $value eq '.' ) { $value = 0; }\n\t   elsif ( $value != -1 && $value != 1 && $value != 0 ) {\n\t       $self->throw(\"$value is not a valid strand info\");\n\t   }\n           $self->{'_strand'} = $value;\n       }\n  }\n  # do not pretend the strand has been set if in fact it wasn't\n  return $self->{'_strand'};\n  #return $self->{'_strand'} || 0;\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n    if( defined $seqid ) {\n\t$self->{'_seqid'} = $seqid;\n    }\n    return $self->{'_seqid'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $loc->length();\n Function: get the length in the coordinate space this location spans\n Example :\n Returns : an integer\n Args    : none\n\n\n\nsub length {\n   my ($self) = @_;\n   return abs($self->end() - $self->start()) + 1;\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting location of feature startpoint   \n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my ($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_start'} = $value;\n    }\n    return $self->{'_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint.\n\n            In this implementation this is exactly the same as min_start().\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,@args) = @_;\n    return $self->min_start(@args);\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^).\n\n            In this implementation this will always be 'EXACT'.\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none","parameters":[{"label":"$self"}],"label":"start_pos_type($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"range":{"start":{"character":0,"line":314},"end":{"line":321,"character":9999}},"name":"min_end","detail":"($self,$value)","signature":{"label":"min_end($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Atomic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Atomic\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Atomic - Implementation of a Atomic Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Atomic;\n\n    my $location = Bio::Location::Atomic->new(-start => 1, -end => 100,\n\t\t\t\t\t     -strand => 1 );\n\n    if( $location->strand == -1 ) {\n\tprintf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n\tprintf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage simple location\ninformation on a Sequence.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Atomic;\nuse strict;\n\nuse Bio::Location::WidestCoordPolicy;\n\nuse base qw(Bio::Root::Root Bio::LocationI);\n\nour $coord_policy = Bio::Location::WidestCoordPolicy->new();\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = {};\n    # This is for the case when we've done something like this\n    # get a 2 features from somewhere (like Bio::Tools::GFF)\n    # Do\n    # my $location = $f1->location->union($f2->location);\n    # We get an error without the following code which \n    # explictly loads the Bio::Location::Simple class\n    eval {\n\t($class) = ref($class) if ref($class);\n\tBio::Root::Root->_load_module($class);\n      };\n    if ( $@ ) {\n\tBio::Root::Root->throw(\"$class cannot be found\\nException $@\");\n      }\n    bless $self,$class;\n\n    my ($v,$start,$end,$strand,$seqid) = $self->_rearrange([qw(VERBOSE\n\t\t\t\t\t\t\t       START\n\t\t\t\t\t\t\t       END\n\t\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t\t       SEQ_ID)],@args);\n    defined $v && $self->verbose($v);\n    defined $strand && $self->strand($strand);\n\n    defined $start  && $self->start($start);\n    defined $end    && $self->end($end);\n    if( defined $self->start && defined $self->end &&\n\t$self->start > $self->end && $self->strand != -1 ) {\n\t$self->warn(\"When building a location, start ($start) is expected to be less than end ($end), \".\n\t\t    \"however it was not. Switching start and end and setting strand to -1\");\n\n\t$self->strand(-1);\n\tmy $e = $self->end;\n\tmy $s = $self->start;\n\t$self->start($e);\n\t$self->end($s);\n    }\n    $seqid          && $self->seq_id($seqid);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n  $self->min_start($value) if( defined $value );\n  return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n\n\nsub end {\n  my ($self, $value) = @_;\n\n  $self->min_end($value) if( defined $value );\n  return $self->SUPER::end();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandidness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\nsub strand {\n  my $self = shift;\n\n  if ( @_ ) {\n       my $value = shift;\n       if ( defined($value) ) {\n\t   if ( $value eq '+' ) { $value = 1; }\n\t   elsif ( $value eq '-' ) { $value = -1; }\n\t   elsif ( $value eq '.' ) { $value = 0; }\n\t   elsif ( $value != -1 && $value != 1 && $value != 0 ) {\n\t       $self->throw(\"$value is not a valid strand info\");\n\t   }\n           $self->{'_strand'} = $value;\n       }\n  }\n  # do not pretend the strand has been set if in fact it wasn't\n  return $self->{'_strand'};\n  #return $self->{'_strand'} || 0;\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n    if( defined $seqid ) {\n\t$self->{'_seqid'} = $seqid;\n    }\n    return $self->{'_seqid'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $loc->length();\n Function: get the length in the coordinate space this location spans\n Example :\n Returns : an integer\n Args    : none\n\n\n\nsub length {\n   my ($self) = @_;\n   return abs($self->end() - $self->start()) + 1;\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting location of feature startpoint   \n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my ($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_start'} = $value;\n    }\n    return $self->{'_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint.\n\n            In this implementation this is exactly the same as min_start().\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,@args) = @_;\n    return $self->min_start(@args);\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^).\n\n            In this implementation this will always be 'EXACT'.\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my($self) = @_;\n    return 'EXACT';\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none"},"containerName":"main::","definition":"sub","line":314,"children":[{"line":315,"kind":13,"localvar":"my","containerName":"min_end","name":"$self","definition":"my"},{"containerName":"min_end","name":"$value","kind":13,"line":315},{"line":317,"kind":13,"containerName":"min_end","name":"$value"},{"line":318,"kind":13,"containerName":"min_end","name":"$self"},{"line":318,"kind":13,"name":"$value","containerName":"min_end"},{"containerName":"min_end","name":"$self","kind":13,"line":320}],"kind":12},{"kind":12,"line":336,"children":[{"containerName":"max_end","name":"$self","definition":"my","localvar":"my","kind":13,"line":337},{"name":"@args","containerName":"max_end","kind":13,"line":337},{"line":338,"kind":13,"containerName":"max_end","name":"$self"},{"containerName":"max_end","name":"min_end","line":338,"kind":12},{"containerName":"max_end","name":"@args","kind":13,"line":338}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: Atomic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Atomic\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Atomic - Implementation of a Atomic Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Atomic;\n\n    my $location = Bio::Location::Atomic->new(-start => 1, -end => 100,\n\t\t\t\t\t     -strand => 1 );\n\n    if( $location->strand == -1 ) {\n\tprintf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n\tprintf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage simple location\ninformation on a Sequence.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Atomic;\nuse strict;\n\nuse Bio::Location::WidestCoordPolicy;\n\nuse base qw(Bio::Root::Root Bio::LocationI);\n\nour $coord_policy = Bio::Location::WidestCoordPolicy->new();\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = {};\n    # This is for the case when we've done something like this\n    # get a 2 features from somewhere (like Bio::Tools::GFF)\n    # Do\n    # my $location = $f1->location->union($f2->location);\n    # We get an error without the following code which \n    # explictly loads the Bio::Location::Simple class\n    eval {\n\t($class) = ref($class) if ref($class);\n\tBio::Root::Root->_load_module($class);\n      };\n    if ( $@ ) {\n\tBio::Root::Root->throw(\"$class cannot be found\\nException $@\");\n      }\n    bless $self,$class;\n\n    my ($v,$start,$end,$strand,$seqid) = $self->_rearrange([qw(VERBOSE\n\t\t\t\t\t\t\t       START\n\t\t\t\t\t\t\t       END\n\t\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t\t       SEQ_ID)],@args);\n    defined $v && $self->verbose($v);\n    defined $strand && $self->strand($strand);\n\n    defined $start  && $self->start($start);\n    defined $end    && $self->end($end);\n    if( defined $self->start && defined $self->end &&\n\t$self->start > $self->end && $self->strand != -1 ) {\n\t$self->warn(\"When building a location, start ($start) is expected to be less than end ($end), \".\n\t\t    \"however it was not. Switching start and end and setting strand to -1\");\n\n\t$self->strand(-1);\n\tmy $e = $self->end;\n\tmy $s = $self->start;\n\t$self->start($e);\n\t$self->end($s);\n    }\n    $seqid          && $self->seq_id($seqid);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n  $self->min_start($value) if( defined $value );\n  return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n\n\nsub end {\n  my ($self, $value) = @_;\n\n  $self->min_end($value) if( defined $value );\n  return $self->SUPER::end();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandidness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\nsub strand {\n  my $self = shift;\n\n  if ( @_ ) {\n       my $value = shift;\n       if ( defined($value) ) {\n\t   if ( $value eq '+' ) { $value = 1; }\n\t   elsif ( $value eq '-' ) { $value = -1; }\n\t   elsif ( $value eq '.' ) { $value = 0; }\n\t   elsif ( $value != -1 && $value != 1 && $value != 0 ) {\n\t       $self->throw(\"$value is not a valid strand info\");\n\t   }\n           $self->{'_strand'} = $value;\n       }\n  }\n  # do not pretend the strand has been set if in fact it wasn't\n  return $self->{'_strand'};\n  #return $self->{'_strand'} || 0;\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n    if( defined $seqid ) {\n\t$self->{'_seqid'} = $seqid;\n    }\n    return $self->{'_seqid'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $loc->length();\n Function: get the length in the coordinate space this location spans\n Example :\n Returns : an integer\n Args    : none\n\n\n\nsub length {\n   my ($self) = @_;\n   return abs($self->end() - $self->start()) + 1;\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting location of feature startpoint   \n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my ($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_start'} = $value;\n    }\n    return $self->{'_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint.\n\n            In this implementation this is exactly the same as min_start().\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,@args) = @_;\n    return $self->min_start(@args);\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^).\n\n            In this implementation this will always be 'EXACT'.\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my($self) = @_;\n    return 'EXACT';\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_end'} = $value;\n    }\n    return $self->{'_end'};\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending location of feature endpoint \n\n            In this implementation this is exactly the same as min_end().\n\n  Returns : integer or undef if no maximum ending point.\n  Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"max_end($self,@args)"},"name":"max_end","range":{"start":{"character":0,"line":336},"end":{"line":339,"character":9999}}},{"range":{"start":{"character":0,"line":355},"end":{"line":358,"character":9999}},"name":"end_pos_type","detail":"($self)","signature":{"label":"end_pos_type($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Atomic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Atomic\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Atomic - Implementation of a Atomic Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Atomic;\n\n    my $location = Bio::Location::Atomic->new(-start => 1, -end => 100,\n\t\t\t\t\t     -strand => 1 );\n\n    if( $location->strand == -1 ) {\n\tprintf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n\tprintf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage simple location\ninformation on a Sequence.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Atomic;\nuse strict;\n\nuse Bio::Location::WidestCoordPolicy;\n\nuse base qw(Bio::Root::Root Bio::LocationI);\n\nour $coord_policy = Bio::Location::WidestCoordPolicy->new();\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = {};\n    # This is for the case when we've done something like this\n    # get a 2 features from somewhere (like Bio::Tools::GFF)\n    # Do\n    # my $location = $f1->location->union($f2->location);\n    # We get an error without the following code which \n    # explictly loads the Bio::Location::Simple class\n    eval {\n\t($class) = ref($class) if ref($class);\n\tBio::Root::Root->_load_module($class);\n      };\n    if ( $@ ) {\n\tBio::Root::Root->throw(\"$class cannot be found\\nException $@\");\n      }\n    bless $self,$class;\n\n    my ($v,$start,$end,$strand,$seqid) = $self->_rearrange([qw(VERBOSE\n\t\t\t\t\t\t\t       START\n\t\t\t\t\t\t\t       END\n\t\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t\t       SEQ_ID)],@args);\n    defined $v && $self->verbose($v);\n    defined $strand && $self->strand($strand);\n\n    defined $start  && $self->start($start);\n    defined $end    && $self->end($end);\n    if( defined $self->start && defined $self->end &&\n\t$self->start > $self->end && $self->strand != -1 ) {\n\t$self->warn(\"When building a location, start ($start) is expected to be less than end ($end), \".\n\t\t    \"however it was not. Switching start and end and setting strand to -1\");\n\n\t$self->strand(-1);\n\tmy $e = $self->end;\n\tmy $s = $self->start;\n\t$self->start($e);\n\t$self->end($s);\n    }\n    $seqid          && $self->seq_id($seqid);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n  $self->min_start($value) if( defined $value );\n  return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n\n\nsub end {\n  my ($self, $value) = @_;\n\n  $self->min_end($value) if( defined $value );\n  return $self->SUPER::end();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandidness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\nsub strand {\n  my $self = shift;\n\n  if ( @_ ) {\n       my $value = shift;\n       if ( defined($value) ) {\n\t   if ( $value eq '+' ) { $value = 1; }\n\t   elsif ( $value eq '-' ) { $value = -1; }\n\t   elsif ( $value eq '.' ) { $value = 0; }\n\t   elsif ( $value != -1 && $value != 1 && $value != 0 ) {\n\t       $self->throw(\"$value is not a valid strand info\");\n\t   }\n           $self->{'_strand'} = $value;\n       }\n  }\n  # do not pretend the strand has been set if in fact it wasn't\n  return $self->{'_strand'};\n  #return $self->{'_strand'} || 0;\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n    if( defined $seqid ) {\n\t$self->{'_seqid'} = $seqid;\n    }\n    return $self->{'_seqid'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $loc->length();\n Function: get the length in the coordinate space this location spans\n Example :\n Returns : an integer\n Args    : none\n\n\n\nsub length {\n   my ($self) = @_;\n   return abs($self->end() - $self->start()) + 1;\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting location of feature startpoint   \n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my ($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_start'} = $value;\n    }\n    return $self->{'_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint.\n\n            In this implementation this is exactly the same as min_start().\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,@args) = @_;\n    return $self->min_start(@args);\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^).\n\n            In this implementation this will always be 'EXACT'.\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my($self) = @_;\n    return 'EXACT';\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_end'} = $value;\n    }\n    return $self->{'_end'};\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending location of feature endpoint \n\n            In this implementation this is exactly the same as min_end().\n\n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\nsub max_end {\n    my($self,@args) = @_;\n    return $self->min_end(@args);\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position type (ie <,>, ^) \n\n            In this implementation this will always be 'EXACT'.\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none"},"containerName":"main::","definition":"sub","line":355,"children":[{"localvar":"my","containerName":"end_pos_type","definition":"my","name":"$self","line":356,"kind":13}],"kind":12},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"location_type($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Atomic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Atomic\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Atomic - Implementation of a Atomic Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Atomic;\n\n    my $location = Bio::Location::Atomic->new(-start => 1, -end => 100,\n\t\t\t\t\t     -strand => 1 );\n\n    if( $location->strand == -1 ) {\n\tprintf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n\tprintf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage simple location\ninformation on a Sequence.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Atomic;\nuse strict;\n\nuse Bio::Location::WidestCoordPolicy;\n\nuse base qw(Bio::Root::Root Bio::LocationI);\n\nour $coord_policy = Bio::Location::WidestCoordPolicy->new();\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = {};\n    # This is for the case when we've done something like this\n    # get a 2 features from somewhere (like Bio::Tools::GFF)\n    # Do\n    # my $location = $f1->location->union($f2->location);\n    # We get an error without the following code which \n    # explictly loads the Bio::Location::Simple class\n    eval {\n\t($class) = ref($class) if ref($class);\n\tBio::Root::Root->_load_module($class);\n      };\n    if ( $@ ) {\n\tBio::Root::Root->throw(\"$class cannot be found\\nException $@\");\n      }\n    bless $self,$class;\n\n    my ($v,$start,$end,$strand,$seqid) = $self->_rearrange([qw(VERBOSE\n\t\t\t\t\t\t\t       START\n\t\t\t\t\t\t\t       END\n\t\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t\t       SEQ_ID)],@args);\n    defined $v && $self->verbose($v);\n    defined $strand && $self->strand($strand);\n\n    defined $start  && $self->start($start);\n    defined $end    && $self->end($end);\n    if( defined $self->start && defined $self->end &&\n\t$self->start > $self->end && $self->strand != -1 ) {\n\t$self->warn(\"When building a location, start ($start) is expected to be less than end ($end), \".\n\t\t    \"however it was not. Switching start and end and setting strand to -1\");\n\n\t$self->strand(-1);\n\tmy $e = $self->end;\n\tmy $s = $self->start;\n\t$self->start($e);\n\t$self->end($s);\n    }\n    $seqid          && $self->seq_id($seqid);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n  $self->min_start($value) if( defined $value );\n  return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n\n\nsub end {\n  my ($self, $value) = @_;\n\n  $self->min_end($value) if( defined $value );\n  return $self->SUPER::end();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandidness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\nsub strand {\n  my $self = shift;\n\n  if ( @_ ) {\n       my $value = shift;\n       if ( defined($value) ) {\n\t   if ( $value eq '+' ) { $value = 1; }\n\t   elsif ( $value eq '-' ) { $value = -1; }\n\t   elsif ( $value eq '.' ) { $value = 0; }\n\t   elsif ( $value != -1 && $value != 1 && $value != 0 ) {\n\t       $self->throw(\"$value is not a valid strand info\");\n\t   }\n           $self->{'_strand'} = $value;\n       }\n  }\n  # do not pretend the strand has been set if in fact it wasn't\n  return $self->{'_strand'};\n  #return $self->{'_strand'} || 0;\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n    if( defined $seqid ) {\n\t$self->{'_seqid'} = $seqid;\n    }\n    return $self->{'_seqid'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $loc->length();\n Function: get the length in the coordinate space this location spans\n Example :\n Returns : an integer\n Args    : none\n\n\n\nsub length {\n   my ($self) = @_;\n   return abs($self->end() - $self->start()) + 1;\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting location of feature startpoint   \n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my ($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_start'} = $value;\n    }\n    return $self->{'_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint.\n\n            In this implementation this is exactly the same as min_start().\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,@args) = @_;\n    return $self->min_start(@args);\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^).\n\n            In this implementation this will always be 'EXACT'.\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my($self) = @_;\n    return 'EXACT';\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_end'} = $value;\n    }\n    return $self->{'_end'};\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending location of feature endpoint \n\n            In this implementation this is exactly the same as min_end().\n\n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\nsub max_end {\n    my($self,@args) = @_;\n    return $self->min_end(@args);\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position type (ie <,>, ^) \n\n            In this implementation this will always be 'EXACT'.\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub end_pos_type {\n    my($self) = @_;\n    return 'EXACT';\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none"},"kind":12,"line":370,"children":[{"kind":13,"line":371,"definition":"my","name":"$self","containerName":"location_type","localvar":"my"}],"name":"location_type","range":{"start":{"character":0,"line":370},"end":{"character":9999,"line":373}}},{"range":{"end":{"line":394,"character":9999},"start":{"character":0,"line":386}},"containerName":"main::","definition":"sub","name":"is_remote","line":386,"children":[{"name":"$self","definition":"my","containerName":"is_remote","localvar":"my","kind":13,"line":387},{"containerName":"is_remote","definition":"my","name":"$value","localvar":"my","kind":13,"line":389},{"line":390,"kind":13,"name":"$self","containerName":"is_remote"},{"kind":13,"line":390,"containerName":"is_remote","name":"$value"},{"line":392,"kind":13,"containerName":"is_remote","name":"$self"}],"kind":12},{"name":"each_Location","range":{"start":{"character":0,"line":410},"end":{"character":9999,"line":413}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Atomic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Atomic\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Atomic - Implementation of a Atomic Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Atomic;\n\n    my $location = Bio::Location::Atomic->new(-start => 1, -end => 100,\n\t\t\t\t\t     -strand => 1 );\n\n    if( $location->strand == -1 ) {\n\tprintf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n\tprintf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage simple location\ninformation on a Sequence.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Atomic;\nuse strict;\n\nuse Bio::Location::WidestCoordPolicy;\n\nuse base qw(Bio::Root::Root Bio::LocationI);\n\nour $coord_policy = Bio::Location::WidestCoordPolicy->new();\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = {};\n    # This is for the case when we've done something like this\n    # get a 2 features from somewhere (like Bio::Tools::GFF)\n    # Do\n    # my $location = $f1->location->union($f2->location);\n    # We get an error without the following code which \n    # explictly loads the Bio::Location::Simple class\n    eval {\n\t($class) = ref($class) if ref($class);\n\tBio::Root::Root->_load_module($class);\n      };\n    if ( $@ ) {\n\tBio::Root::Root->throw(\"$class cannot be found\\nException $@\");\n      }\n    bless $self,$class;\n\n    my ($v,$start,$end,$strand,$seqid) = $self->_rearrange([qw(VERBOSE\n\t\t\t\t\t\t\t       START\n\t\t\t\t\t\t\t       END\n\t\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t\t       SEQ_ID)],@args);\n    defined $v && $self->verbose($v);\n    defined $strand && $self->strand($strand);\n\n    defined $start  && $self->start($start);\n    defined $end    && $self->end($end);\n    if( defined $self->start && defined $self->end &&\n\t$self->start > $self->end && $self->strand != -1 ) {\n\t$self->warn(\"When building a location, start ($start) is expected to be less than end ($end), \".\n\t\t    \"however it was not. Switching start and end and setting strand to -1\");\n\n\t$self->strand(-1);\n\tmy $e = $self->end;\n\tmy $s = $self->start;\n\t$self->start($e);\n\t$self->end($s);\n    }\n    $seqid          && $self->seq_id($seqid);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n  $self->min_start($value) if( defined $value );\n  return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n\n\nsub end {\n  my ($self, $value) = @_;\n\n  $self->min_end($value) if( defined $value );\n  return $self->SUPER::end();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandidness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\nsub strand {\n  my $self = shift;\n\n  if ( @_ ) {\n       my $value = shift;\n       if ( defined($value) ) {\n\t   if ( $value eq '+' ) { $value = 1; }\n\t   elsif ( $value eq '-' ) { $value = -1; }\n\t   elsif ( $value eq '.' ) { $value = 0; }\n\t   elsif ( $value != -1 && $value != 1 && $value != 0 ) {\n\t       $self->throw(\"$value is not a valid strand info\");\n\t   }\n           $self->{'_strand'} = $value;\n       }\n  }\n  # do not pretend the strand has been set if in fact it wasn't\n  return $self->{'_strand'};\n  #return $self->{'_strand'} || 0;\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n    if( defined $seqid ) {\n\t$self->{'_seqid'} = $seqid;\n    }\n    return $self->{'_seqid'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $loc->length();\n Function: get the length in the coordinate space this location spans\n Example :\n Returns : an integer\n Args    : none\n\n\n\nsub length {\n   my ($self) = @_;\n   return abs($self->end() - $self->start()) + 1;\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting location of feature startpoint   \n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my ($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_start'} = $value;\n    }\n    return $self->{'_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint.\n\n            In this implementation this is exactly the same as min_start().\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,@args) = @_;\n    return $self->min_start(@args);\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^).\n\n            In this implementation this will always be 'EXACT'.\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my($self) = @_;\n    return 'EXACT';\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_end'} = $value;\n    }\n    return $self->{'_end'};\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending location of feature endpoint \n\n            In this implementation this is exactly the same as min_end().\n\n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\nsub max_end {\n    my($self,@args) = @_;\n    return $self->min_end(@args);\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position type (ie <,>, ^) \n\n            In this implementation this will always be 'EXACT'.\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub end_pos_type {\n    my($self) = @_;\n    return 'EXACT';\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none\n\n\nsub location_type {\n    my ($self) = @_;\n    return 'EXACT';\n}\n\n=head2 is_remote\n\n Title   : is_remote\n Usage   : $self->is_remote($newval)\n Function: Getset for is_remote value\n Returns : value of is_remote\n Args    : newvalue (optional)\n\n\n\nsub is_remote {\n   my $self = shift;\n   if( @_ ) {\n       my $value = shift;\n       $self->{'is_remote'} = $value;\n   }\n   return $self->{'is_remote'};\n\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects - for\n           Simple locations, the return value is just itself.\n Args    : ","label":"each_Location($self)"},"detail":"($self)","kind":12,"children":[{"kind":13,"line":411,"containerName":"each_Location","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":412,"containerName":"each_Location","name":"$self"}],"line":410},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"to_FTstring($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Atomic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Atomic\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Atomic - Implementation of a Atomic Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Atomic;\n\n    my $location = Bio::Location::Atomic->new(-start => 1, -end => 100,\n\t\t\t\t\t     -strand => 1 );\n\n    if( $location->strand == -1 ) {\n\tprintf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n\tprintf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage simple location\ninformation on a Sequence.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Atomic;\nuse strict;\n\nuse Bio::Location::WidestCoordPolicy;\n\nuse base qw(Bio::Root::Root Bio::LocationI);\n\nour $coord_policy = Bio::Location::WidestCoordPolicy->new();\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = {};\n    # This is for the case when we've done something like this\n    # get a 2 features from somewhere (like Bio::Tools::GFF)\n    # Do\n    # my $location = $f1->location->union($f2->location);\n    # We get an error without the following code which \n    # explictly loads the Bio::Location::Simple class\n    eval {\n\t($class) = ref($class) if ref($class);\n\tBio::Root::Root->_load_module($class);\n      };\n    if ( $@ ) {\n\tBio::Root::Root->throw(\"$class cannot be found\\nException $@\");\n      }\n    bless $self,$class;\n\n    my ($v,$start,$end,$strand,$seqid) = $self->_rearrange([qw(VERBOSE\n\t\t\t\t\t\t\t       START\n\t\t\t\t\t\t\t       END\n\t\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t\t       SEQ_ID)],@args);\n    defined $v && $self->verbose($v);\n    defined $strand && $self->strand($strand);\n\n    defined $start  && $self->start($start);\n    defined $end    && $self->end($end);\n    if( defined $self->start && defined $self->end &&\n\t$self->start > $self->end && $self->strand != -1 ) {\n\t$self->warn(\"When building a location, start ($start) is expected to be less than end ($end), \".\n\t\t    \"however it was not. Switching start and end and setting strand to -1\");\n\n\t$self->strand(-1);\n\tmy $e = $self->end;\n\tmy $s = $self->start;\n\t$self->start($e);\n\t$self->end($s);\n    }\n    $seqid          && $self->seq_id($seqid);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n  $self->min_start($value) if( defined $value );\n  return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n\n\nsub end {\n  my ($self, $value) = @_;\n\n  $self->min_end($value) if( defined $value );\n  return $self->SUPER::end();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandidness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\nsub strand {\n  my $self = shift;\n\n  if ( @_ ) {\n       my $value = shift;\n       if ( defined($value) ) {\n\t   if ( $value eq '+' ) { $value = 1; }\n\t   elsif ( $value eq '-' ) { $value = -1; }\n\t   elsif ( $value eq '.' ) { $value = 0; }\n\t   elsif ( $value != -1 && $value != 1 && $value != 0 ) {\n\t       $self->throw(\"$value is not a valid strand info\");\n\t   }\n           $self->{'_strand'} = $value;\n       }\n  }\n  # do not pretend the strand has been set if in fact it wasn't\n  return $self->{'_strand'};\n  #return $self->{'_strand'} || 0;\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n    if( defined $seqid ) {\n\t$self->{'_seqid'} = $seqid;\n    }\n    return $self->{'_seqid'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $loc->length();\n Function: get the length in the coordinate space this location spans\n Example :\n Returns : an integer\n Args    : none\n\n\n\nsub length {\n   my ($self) = @_;\n   return abs($self->end() - $self->start()) + 1;\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting location of feature startpoint   \n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my ($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_start'} = $value;\n    }\n    return $self->{'_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint.\n\n            In this implementation this is exactly the same as min_start().\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,@args) = @_;\n    return $self->min_start(@args);\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^).\n\n            In this implementation this will always be 'EXACT'.\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my($self) = @_;\n    return 'EXACT';\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_end'} = $value;\n    }\n    return $self->{'_end'};\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending location of feature endpoint \n\n            In this implementation this is exactly the same as min_end().\n\n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\nsub max_end {\n    my($self,@args) = @_;\n    return $self->min_end(@args);\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position type (ie <,>, ^) \n\n            In this implementation this will always be 'EXACT'.\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub end_pos_type {\n    my($self) = @_;\n    return 'EXACT';\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none\n\n\nsub location_type {\n    my ($self) = @_;\n    return 'EXACT';\n}\n\n=head2 is_remote\n\n Title   : is_remote\n Usage   : $self->is_remote($newval)\n Function: Getset for is_remote value\n Returns : value of is_remote\n Args    : newvalue (optional)\n\n\n\nsub is_remote {\n   my $self = shift;\n   if( @_ ) {\n       my $value = shift;\n       $self->{'is_remote'} = $value;\n   }\n   return $self->{'is_remote'};\n\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects - for\n           Simple locations, the return value is just itself.\n Args    : \n\n\nsub each_Location {\n   my ($self) = @_;\n   return ($self);\n}\n\n=head2 to_FTstring\n\n  Title   : to_FTstring\n  Usage   : my $locstr = $location->to_FTstring()\n  Function: returns the FeatureTable string of this location\n  Returns : string\n  Args    : none"},"kind":12,"line":425,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"to_FTstring","line":426,"kind":13},{"kind":13,"line":427,"name":"$self","containerName":"to_FTstring"},{"line":427,"kind":12,"containerName":"to_FTstring","name":"start"},{"kind":13,"line":427,"name":"$self","containerName":"to_FTstring"},{"name":"end","containerName":"to_FTstring","kind":12,"line":427},{"name":"$self","containerName":"to_FTstring","kind":13,"line":428},{"line":428,"kind":12,"containerName":"to_FTstring","name":"start"},{"line":430,"kind":13,"localvar":"my","containerName":"to_FTstring","definition":"my","name":"$str"},{"kind":13,"line":430,"containerName":"to_FTstring","name":"$self"},{"name":"start","containerName":"to_FTstring","kind":12,"line":430},{"name":"$self","containerName":"to_FTstring","kind":13,"line":430},{"containerName":"to_FTstring","name":"end","kind":12,"line":430},{"containerName":"to_FTstring","name":"$self","line":431,"kind":13},{"name":"strand","containerName":"to_FTstring","line":431,"kind":12},{"kind":13,"line":432,"name":"$str","containerName":"to_FTstring"},{"kind":13,"line":432,"name":"$str","containerName":"to_FTstring"},{"containerName":"to_FTstring","name":"$str","kind":13,"line":434}],"name":"to_FTstring","range":{"start":{"character":0,"line":425},"end":{"line":435,"character":9999}}},{"range":{"start":{"line":448,"character":0},"end":{"line":452,"character":9999}},"name":"valid_Location","line":448,"children":[{"definition":"my","name":"$self","containerName":"valid_Location","localvar":"my","kind":13,"line":449},{"name":"$self","containerName":"valid_Location","line":450,"kind":13},{"line":450,"kind":13,"containerName":"valid_Location","name":"$self"}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Atomic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Atomic\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Atomic - Implementation of a Atomic Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Atomic;\n\n    my $location = Bio::Location::Atomic->new(-start => 1, -end => 100,\n\t\t\t\t\t     -strand => 1 );\n\n    if( $location->strand == -1 ) {\n\tprintf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n\tprintf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage simple location\ninformation on a Sequence.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Atomic;\nuse strict;\n\nuse Bio::Location::WidestCoordPolicy;\n\nuse base qw(Bio::Root::Root Bio::LocationI);\n\nour $coord_policy = Bio::Location::WidestCoordPolicy->new();\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = {};\n    # This is for the case when we've done something like this\n    # get a 2 features from somewhere (like Bio::Tools::GFF)\n    # Do\n    # my $location = $f1->location->union($f2->location);\n    # We get an error without the following code which \n    # explictly loads the Bio::Location::Simple class\n    eval {\n\t($class) = ref($class) if ref($class);\n\tBio::Root::Root->_load_module($class);\n      };\n    if ( $@ ) {\n\tBio::Root::Root->throw(\"$class cannot be found\\nException $@\");\n      }\n    bless $self,$class;\n\n    my ($v,$start,$end,$strand,$seqid) = $self->_rearrange([qw(VERBOSE\n\t\t\t\t\t\t\t       START\n\t\t\t\t\t\t\t       END\n\t\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t\t       SEQ_ID)],@args);\n    defined $v && $self->verbose($v);\n    defined $strand && $self->strand($strand);\n\n    defined $start  && $self->start($start);\n    defined $end    && $self->end($end);\n    if( defined $self->start && defined $self->end &&\n\t$self->start > $self->end && $self->strand != -1 ) {\n\t$self->warn(\"When building a location, start ($start) is expected to be less than end ($end), \".\n\t\t    \"however it was not. Switching start and end and setting strand to -1\");\n\n\t$self->strand(-1);\n\tmy $e = $self->end;\n\tmy $s = $self->start;\n\t$self->start($e);\n\t$self->end($s);\n    }\n    $seqid          && $self->seq_id($seqid);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n  $self->min_start($value) if( defined $value );\n  return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n\n\nsub end {\n  my ($self, $value) = @_;\n\n  $self->min_end($value) if( defined $value );\n  return $self->SUPER::end();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandidness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\nsub strand {\n  my $self = shift;\n\n  if ( @_ ) {\n       my $value = shift;\n       if ( defined($value) ) {\n\t   if ( $value eq '+' ) { $value = 1; }\n\t   elsif ( $value eq '-' ) { $value = -1; }\n\t   elsif ( $value eq '.' ) { $value = 0; }\n\t   elsif ( $value != -1 && $value != 1 && $value != 0 ) {\n\t       $self->throw(\"$value is not a valid strand info\");\n\t   }\n           $self->{'_strand'} = $value;\n       }\n  }\n  # do not pretend the strand has been set if in fact it wasn't\n  return $self->{'_strand'};\n  #return $self->{'_strand'} || 0;\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n    if( defined $seqid ) {\n\t$self->{'_seqid'} = $seqid;\n    }\n    return $self->{'_seqid'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $loc->length();\n Function: get the length in the coordinate space this location spans\n Example :\n Returns : an integer\n Args    : none\n\n\n\nsub length {\n   my ($self) = @_;\n   return abs($self->end() - $self->start()) + 1;\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting location of feature startpoint   \n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my ($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_start'} = $value;\n    }\n    return $self->{'_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint.\n\n            In this implementation this is exactly the same as min_start().\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,@args) = @_;\n    return $self->min_start(@args);\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^).\n\n            In this implementation this will always be 'EXACT'.\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my($self) = @_;\n    return 'EXACT';\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_end'} = $value;\n    }\n    return $self->{'_end'};\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending location of feature endpoint \n\n            In this implementation this is exactly the same as min_end().\n\n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\nsub max_end {\n    my($self,@args) = @_;\n    return $self->min_end(@args);\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position type (ie <,>, ^) \n\n            In this implementation this will always be 'EXACT'.\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub end_pos_type {\n    my($self) = @_;\n    return 'EXACT';\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none\n\n\nsub location_type {\n    my ($self) = @_;\n    return 'EXACT';\n}\n\n=head2 is_remote\n\n Title   : is_remote\n Usage   : $self->is_remote($newval)\n Function: Getset for is_remote value\n Returns : value of is_remote\n Args    : newvalue (optional)\n\n\n\nsub is_remote {\n   my $self = shift;\n   if( @_ ) {\n       my $value = shift;\n       $self->{'is_remote'} = $value;\n   }\n   return $self->{'is_remote'};\n\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects - for\n           Simple locations, the return value is just itself.\n Args    : \n\n\nsub each_Location {\n   my ($self) = @_;\n   return ($self);\n}\n\n=head2 to_FTstring\n\n  Title   : to_FTstring\n  Usage   : my $locstr = $location->to_FTstring()\n  Function: returns the FeatureTable string of this location\n  Returns : string\n  Args    : none\n\n\nsub to_FTstring { \n    my($self) = @_;\n    if( $self->start == $self->end ) {\n\treturn $self->start;\n    }\n    my $str = $self->start . \"..\" . $self->end;\n    if( $self->strand == -1 ) {\n\t$str = sprintf(\"complement(%s)\", $str);\n    }\n    return $str;\n}\n\n=head2 valid_Location\n\n Title   : valid_Location\n Usage   : if ($location->valid_location) {...};\n Function: boolean method to determine whether location is considered valid\n           (has minimum requirements for Simple implementation)\n Returns : Boolean value: true if location is valid, false otherwise\n Args    : none","label":"valid_Location($self)"},"containerName":"main::","definition":"sub"},{"definition":"sub","containerName":"main::","signature":{"label":"coordinate_policy($self,$policy)","parameters":[{"label":"$self"},{"label":"$policy"}],"documentation":"1;\n# $Id: Atomic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Atomic\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Atomic - Implementation of a Atomic Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Atomic;\n\n    my $location = Bio::Location::Atomic->new(-start => 1, -end => 100,\n\t\t\t\t\t     -strand => 1 );\n\n    if( $location->strand == -1 ) {\n\tprintf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n\tprintf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage simple location\ninformation on a Sequence.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Atomic;\nuse strict;\n\nuse Bio::Location::WidestCoordPolicy;\n\nuse base qw(Bio::Root::Root Bio::LocationI);\n\nour $coord_policy = Bio::Location::WidestCoordPolicy->new();\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = {};\n    # This is for the case when we've done something like this\n    # get a 2 features from somewhere (like Bio::Tools::GFF)\n    # Do\n    # my $location = $f1->location->union($f2->location);\n    # We get an error without the following code which \n    # explictly loads the Bio::Location::Simple class\n    eval {\n\t($class) = ref($class) if ref($class);\n\tBio::Root::Root->_load_module($class);\n      };\n    if ( $@ ) {\n\tBio::Root::Root->throw(\"$class cannot be found\\nException $@\");\n      }\n    bless $self,$class;\n\n    my ($v,$start,$end,$strand,$seqid) = $self->_rearrange([qw(VERBOSE\n\t\t\t\t\t\t\t       START\n\t\t\t\t\t\t\t       END\n\t\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t\t       SEQ_ID)],@args);\n    defined $v && $self->verbose($v);\n    defined $strand && $self->strand($strand);\n\n    defined $start  && $self->start($start);\n    defined $end    && $self->end($end);\n    if( defined $self->start && defined $self->end &&\n\t$self->start > $self->end && $self->strand != -1 ) {\n\t$self->warn(\"When building a location, start ($start) is expected to be less than end ($end), \".\n\t\t    \"however it was not. Switching start and end and setting strand to -1\");\n\n\t$self->strand(-1);\n\tmy $e = $self->end;\n\tmy $s = $self->start;\n\t$self->start($e);\n\t$self->end($s);\n    }\n    $seqid          && $self->seq_id($seqid);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n  $self->min_start($value) if( defined $value );\n  return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n\n\nsub end {\n  my ($self, $value) = @_;\n\n  $self->min_end($value) if( defined $value );\n  return $self->SUPER::end();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandidness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\nsub strand {\n  my $self = shift;\n\n  if ( @_ ) {\n       my $value = shift;\n       if ( defined($value) ) {\n\t   if ( $value eq '+' ) { $value = 1; }\n\t   elsif ( $value eq '-' ) { $value = -1; }\n\t   elsif ( $value eq '.' ) { $value = 0; }\n\t   elsif ( $value != -1 && $value != 1 && $value != 0 ) {\n\t       $self->throw(\"$value is not a valid strand info\");\n\t   }\n           $self->{'_strand'} = $value;\n       }\n  }\n  # do not pretend the strand has been set if in fact it wasn't\n  return $self->{'_strand'};\n  #return $self->{'_strand'} || 0;\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n    if( defined $seqid ) {\n\t$self->{'_seqid'} = $seqid;\n    }\n    return $self->{'_seqid'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $loc->length();\n Function: get the length in the coordinate space this location spans\n Example :\n Returns : an integer\n Args    : none\n\n\n\nsub length {\n   my ($self) = @_;\n   return abs($self->end() - $self->start()) + 1;\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting location of feature startpoint   \n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my ($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_start'} = $value;\n    }\n    return $self->{'_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint.\n\n            In this implementation this is exactly the same as min_start().\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,@args) = @_;\n    return $self->min_start(@args);\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^).\n\n            In this implementation this will always be 'EXACT'.\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my($self) = @_;\n    return 'EXACT';\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_end'} = $value;\n    }\n    return $self->{'_end'};\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending location of feature endpoint \n\n            In this implementation this is exactly the same as min_end().\n\n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\nsub max_end {\n    my($self,@args) = @_;\n    return $self->min_end(@args);\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position type (ie <,>, ^) \n\n            In this implementation this will always be 'EXACT'.\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub end_pos_type {\n    my($self) = @_;\n    return 'EXACT';\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none\n\n\nsub location_type {\n    my ($self) = @_;\n    return 'EXACT';\n}\n\n=head2 is_remote\n\n Title   : is_remote\n Usage   : $self->is_remote($newval)\n Function: Getset for is_remote value\n Returns : value of is_remote\n Args    : newvalue (optional)\n\n\n\nsub is_remote {\n   my $self = shift;\n   if( @_ ) {\n       my $value = shift;\n       $self->{'is_remote'} = $value;\n   }\n   return $self->{'is_remote'};\n\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects - for\n           Simple locations, the return value is just itself.\n Args    : \n\n\nsub each_Location {\n   my ($self) = @_;\n   return ($self);\n}\n\n=head2 to_FTstring\n\n  Title   : to_FTstring\n  Usage   : my $locstr = $location->to_FTstring()\n  Function: returns the FeatureTable string of this location\n  Returns : string\n  Args    : none\n\n\nsub to_FTstring { \n    my($self) = @_;\n    if( $self->start == $self->end ) {\n\treturn $self->start;\n    }\n    my $str = $self->start . \"..\" . $self->end;\n    if( $self->strand == -1 ) {\n\t$str = sprintf(\"complement(%s)\", $str);\n    }\n    return $str;\n}\n\n=head2 valid_Location\n\n Title   : valid_Location\n Usage   : if ($location->valid_location) {...};\n Function: boolean method to determine whether location is considered valid\n           (has minimum requirements for Simple implementation)\n Returns : Boolean value: true if location is valid, false otherwise\n Args    : none\n\n\nsub valid_Location {\n    my ($self) = @_;\n    return 1 if $self->{'_start'} && $self->{'_end'};\n    return 0;\n}\n\n=head2 coordinate_policy\n\n  Title   : coordinate_policy\n  Usage   : $policy = $location->coordinate_policy();\n            $location->coordinate_policy($mypolicy); # set may not be possible\n  Function: Get the coordinate computing policy employed by this object.\n\n            See L<Bio::Location::CoordinatePolicyI> for documentation\n            about the policy object and its use.\n\n            The interface *does not* require implementing classes to\n            accept setting of a different policy. The implementation\n            provided here does, however, allow to do so.\n\n            Implementors of this interface are expected to initialize\n            every new instance with a\n            L<Bio::Location::CoordinatePolicyI> object. The\n            implementation provided here will return a default policy\n            object if none has been set yet. To change this default\n            policy object call this method as a class method with an\n            appropriate argument. Note that in this case only\n            subsequently created Location objects will be affected.\n\n  Returns : A L<Bio::Location::CoordinatePolicyI> implementing object.\n  Args    : On set, a L<Bio::Location::CoordinatePolicyI> implementing object.\n\nSee L<Bio::Location::CoordinatePolicyI> for more information"},"detail":"($self,$policy)","kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"coordinate_policy","line":486,"kind":13},{"containerName":"coordinate_policy","name":"$policy","kind":13,"line":486},{"name":"$policy","containerName":"coordinate_policy","kind":13,"line":488},{"containerName":"coordinate_policy","name":"$policy","line":489,"kind":13},{"containerName":"coordinate_policy","name":"isa","line":489,"kind":12},{"kind":13,"line":490,"name":"$self","containerName":"coordinate_policy"},{"name":"throw","containerName":"coordinate_policy","line":490,"kind":12},{"containerName":"coordinate_policy","name":"$policy","line":490,"kind":13},{"containerName":"coordinate_policy","name":"$self","kind":13,"line":493},{"line":494,"kind":13,"name":"$self","containerName":"coordinate_policy"},{"containerName":"coordinate_policy","name":"$policy","kind":13,"line":494},{"containerName":"coordinate_policy","name":"$coord_policy","line":497,"kind":13},{"containerName":"coordinate_policy","name":"$policy","kind":13,"line":497},{"name":"$self","containerName":"coordinate_policy","kind":13,"line":500},{"kind":13,"line":500,"name":"$self","containerName":"coordinate_policy"},{"name":"$self","containerName":"coordinate_policy","line":501,"kind":13},{"kind":13,"line":501,"name":"$coord_policy","containerName":"coordinate_policy"}],"line":485,"name":"coordinate_policy","range":{"start":{"character":0,"line":485},"end":{"character":9999,"line":502}}},{"containerName":"main::","definition":"sub","detail":"($self,$start,$end,$relative_ori)","signature":{"parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"},{"label":"$relative_ori"}],"documentation":"1;\n# $Id: Atomic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Atomic\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Atomic - Implementation of a Atomic Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Atomic;\n\n    my $location = Bio::Location::Atomic->new(-start => 1, -end => 100,\n\t\t\t\t\t     -strand => 1 );\n\n    if( $location->strand == -1 ) {\n\tprintf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n\tprintf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage simple location\ninformation on a Sequence.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Atomic;\nuse strict;\n\nuse Bio::Location::WidestCoordPolicy;\n\nuse base qw(Bio::Root::Root Bio::LocationI);\n\nour $coord_policy = Bio::Location::WidestCoordPolicy->new();\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = {};\n    # This is for the case when we've done something like this\n    # get a 2 features from somewhere (like Bio::Tools::GFF)\n    # Do\n    # my $location = $f1->location->union($f2->location);\n    # We get an error without the following code which \n    # explictly loads the Bio::Location::Simple class\n    eval {\n\t($class) = ref($class) if ref($class);\n\tBio::Root::Root->_load_module($class);\n      };\n    if ( $@ ) {\n\tBio::Root::Root->throw(\"$class cannot be found\\nException $@\");\n      }\n    bless $self,$class;\n\n    my ($v,$start,$end,$strand,$seqid) = $self->_rearrange([qw(VERBOSE\n\t\t\t\t\t\t\t       START\n\t\t\t\t\t\t\t       END\n\t\t\t\t\t\t\t       STRAND\n\t\t\t\t\t\t\t       SEQ_ID)],@args);\n    defined $v && $self->verbose($v);\n    defined $strand && $self->strand($strand);\n\n    defined $start  && $self->start($start);\n    defined $end    && $self->end($end);\n    if( defined $self->start && defined $self->end &&\n\t$self->start > $self->end && $self->strand != -1 ) {\n\t$self->warn(\"When building a location, start ($start) is expected to be less than end ($end), \".\n\t\t    \"however it was not. Switching start and end and setting strand to -1\");\n\n\t$self->strand(-1);\n\tmy $e = $self->end;\n\tmy $s = $self->start;\n\t$self->start($e);\n\t$self->end($s);\n    }\n    $seqid          && $self->seq_id($seqid);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n  $self->min_start($value) if( defined $value );\n  return $self->SUPER::start();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n\n\nsub end {\n  my ($self, $value) = @_;\n\n  $self->min_end($value) if( defined $value );\n  return $self->SUPER::end();\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandidness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\nsub strand {\n  my $self = shift;\n\n  if ( @_ ) {\n       my $value = shift;\n       if ( defined($value) ) {\n\t   if ( $value eq '+' ) { $value = 1; }\n\t   elsif ( $value eq '-' ) { $value = -1; }\n\t   elsif ( $value eq '.' ) { $value = 0; }\n\t   elsif ( $value != -1 && $value != 1 && $value != 0 ) {\n\t       $self->throw(\"$value is not a valid strand info\");\n\t   }\n           $self->{'_strand'} = $value;\n       }\n  }\n  # do not pretend the strand has been set if in fact it wasn't\n  return $self->{'_strand'};\n  #return $self->{'_strand'} || 0;\n}\n\n=head2 flip_strand\n\n  Title   : flip_strand\n  Usage   : $location->flip_strand();\n  Function: Flip-flop a strand to the opposite\n  Returns : None\n  Args    : None\n\n\n\nsub flip_strand {\n    my $self= shift;\n    $self->strand($self->strand * -1);\n}\n\n\n=head2 seq_id\n\n  Title   : seq_id\n  Usage   : my $seqid = $location->seq_id();\n  Function: Get/Set seq_id that location refers to\n  Returns : seq_id (a string)\n  Args    : [optional] seq_id value to set\n\n\n\nsub seq_id {\n    my ($self, $seqid) = @_;\n    if( defined $seqid ) {\n\t$self->{'_seqid'} = $seqid;\n    }\n    return $self->{'_seqid'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $loc->length();\n Function: get the length in the coordinate space this location spans\n Example :\n Returns : an integer\n Args    : none\n\n\n\nsub length {\n   my ($self) = @_;\n   return abs($self->end() - $self->start()) + 1;\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting location of feature startpoint   \n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\nsub min_start {\n    my ($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_start'} = $value;\n    }\n    return $self->{'_start'};\n}\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint.\n\n            In this implementation this is exactly the same as min_start().\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\nsub max_start {\n    my ($self,@args) = @_;\n    return $self->min_start(@args);\n}\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^).\n\n            In this implementation this will always be 'EXACT'.\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub start_pos_type {\n    my($self) = @_;\n    return 'EXACT';\n}\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\nsub min_end {\n    my($self,$value) = @_;\n\n    if(defined($value)) {\n\t$self->{'_end'} = $value;\n    }\n    return $self->{'_end'};\n}\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending location of feature endpoint \n\n            In this implementation this is exactly the same as min_end().\n\n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\nsub max_end {\n    my($self,@args) = @_;\n    return $self->min_end(@args);\n}\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position type (ie <,>, ^) \n\n            In this implementation this will always be 'EXACT'.\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\nsub end_pos_type {\n    my($self) = @_;\n    return 'EXACT';\n}\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none\n\n\nsub location_type {\n    my ($self) = @_;\n    return 'EXACT';\n}\n\n=head2 is_remote\n\n Title   : is_remote\n Usage   : $self->is_remote($newval)\n Function: Getset for is_remote value\n Returns : value of is_remote\n Args    : newvalue (optional)\n\n\n\nsub is_remote {\n   my $self = shift;\n   if( @_ ) {\n       my $value = shift;\n       $self->{'is_remote'} = $value;\n   }\n   return $self->{'is_remote'};\n\n}\n\n=head2 each_Location\n\n Title   : each_Location\n Usage   : @locations = $locObject->each_Location($order);\n Function: Conserved function call across Location:: modules - will\n           return an array containing the component Location(s) in\n           that object, regardless if the calling object is itself a\n           single location or one containing sublocations.\n Returns : an array of Bio::LocationI implementing objects - for\n           Simple locations, the return value is just itself.\n Args    : \n\n\nsub each_Location {\n   my ($self) = @_;\n   return ($self);\n}\n\n=head2 to_FTstring\n\n  Title   : to_FTstring\n  Usage   : my $locstr = $location->to_FTstring()\n  Function: returns the FeatureTable string of this location\n  Returns : string\n  Args    : none\n\n\nsub to_FTstring { \n    my($self) = @_;\n    if( $self->start == $self->end ) {\n\treturn $self->start;\n    }\n    my $str = $self->start . \"..\" . $self->end;\n    if( $self->strand == -1 ) {\n\t$str = sprintf(\"complement(%s)\", $str);\n    }\n    return $str;\n}\n\n=head2 valid_Location\n\n Title   : valid_Location\n Usage   : if ($location->valid_location) {...};\n Function: boolean method to determine whether location is considered valid\n           (has minimum requirements for Simple implementation)\n Returns : Boolean value: true if location is valid, false otherwise\n Args    : none\n\n\nsub valid_Location {\n    my ($self) = @_;\n    return 1 if $self->{'_start'} && $self->{'_end'};\n    return 0;\n}\n\n=head2 coordinate_policy\n\n  Title   : coordinate_policy\n  Usage   : $policy = $location->coordinate_policy();\n            $location->coordinate_policy($mypolicy); # set may not be possible\n  Function: Get the coordinate computing policy employed by this object.\n\n            See L<Bio::Location::CoordinatePolicyI> for documentation\n            about the policy object and its use.\n\n            The interface *does not* require implementing classes to\n            accept setting of a different policy. The implementation\n            provided here does, however, allow to do so.\n\n            Implementors of this interface are expected to initialize\n            every new instance with a\n            L<Bio::Location::CoordinatePolicyI> object. The\n            implementation provided here will return a default policy\n            object if none has been set yet. To change this default\n            policy object call this method as a class method with an\n            appropriate argument. Note that in this case only\n            subsequently created Location objects will be affected.\n\n  Returns : A L<Bio::Location::CoordinatePolicyI> implementing object.\n  Args    : On set, a L<Bio::Location::CoordinatePolicyI> implementing object.\n\nSee L<Bio::Location::CoordinatePolicyI> for more information\n\n\n\nsub coordinate_policy {\n    my ($self, $policy) = @_;\n\n    if(defined($policy)) {\n\tif(! $policy->isa('Bio::Location::CoordinatePolicyI')) {\n\t    $self->throw(\"Object of class \".ref($policy).\" does not implement\".\n\t\t\t \" Bio::Location::CoordinatePolicyI\");\n\t}\n\tif(ref($self)) {\n\t    $self->{'_coordpolicy'} = $policy;\n\t} else {\n\t    # called as class method\n\t    $coord_policy = $policy;\n\t}\n    }\n    return (ref($self) && exists($self->{'_coordpolicy'}) ?\n\t    $self->{'_coordpolicy'} : $coord_policy);\n}\n\n=head2 trunc\n\n  Title   : trunc\n\tUsage   : $trunc_location = $location->trunc($start, $end, $relative_ori);\n\tFunction: To truncate a location and keep annotations and features\n\t          within the truncated segment intact.\n\n\t\t\t\t\t\tThis might do things differently where the truncation\n\t\t\t\t\t\tsplits the location in half.\n\tCAVEAT  : As yet, this is an untested and unannounced method. Use\n\t          with caution!\n\tReturns : A L<Bio::Location::Atomic> object.\n\tArgs    : The start and end position for the trunction, and the relative\n\t          orientation.","label":"trunc($self,$start,$end,$relative_ori)"},"kind":12,"line":521,"children":[{"kind":13,"line":522,"containerName":"trunc","definition":"my","name":"$self","localvar":"my"},{"containerName":"trunc","name":"$start","line":522,"kind":13},{"containerName":"trunc","name":"$end","line":522,"kind":13},{"name":"$relative_ori","containerName":"trunc","line":522,"kind":13},{"containerName":"trunc","name":"$newstart","definition":"my","localvar":"my","kind":13,"line":524},{"name":"$self","containerName":"trunc","line":524,"kind":13},{"containerName":"trunc","name":"start","line":524,"kind":12},{"line":524,"kind":13,"name":"$start","containerName":"trunc"},{"line":525,"kind":13,"localvar":"my","containerName":"trunc","name":"$newend","definition":"my"},{"kind":13,"line":525,"containerName":"trunc","name":"$self"},{"kind":12,"line":525,"containerName":"trunc","name":"end"},{"line":525,"kind":13,"name":"$start","containerName":"trunc"},{"line":526,"kind":13,"localvar":"my","containerName":"trunc","name":"$newstrand","definition":"my"},{"containerName":"trunc","name":"$relative_ori","line":526,"kind":13},{"kind":13,"line":526,"containerName":"trunc","name":"$self"},{"containerName":"trunc","name":"strand","line":526,"kind":12},{"localvar":"my","definition":"my","name":"$out","containerName":"trunc","line":528,"kind":13},{"kind":13,"line":529,"containerName":"trunc","name":"$newstart"},{"kind":13,"line":529,"name":"$newend","containerName":"trunc"},{"name":"$end","containerName":"trunc","kind":13,"line":529},{"line":529,"kind":13,"name":"$start","containerName":"trunc"},{"containerName":"trunc","name":"$out","kind":13,"line":530},{"kind":12,"line":530,"containerName":"trunc","name":"new"},{"line":531,"kind":13,"containerName":"trunc","name":"$out"},{"containerName":"trunc","name":"start","kind":12,"line":531},{"name":"$self","containerName":"trunc","kind":13,"line":531},{"kind":12,"line":531,"name":"start","containerName":"trunc"},{"name":"$out","containerName":"trunc","line":532,"kind":13},{"line":532,"kind":12,"containerName":"trunc","name":"end"},{"containerName":"trunc","name":"$self","line":532,"kind":13},{"containerName":"trunc","name":"end","kind":12,"line":532},{"containerName":"trunc","name":"$out","kind":13,"line":533},{"name":"strand","containerName":"trunc","line":533,"kind":12},{"kind":13,"line":533,"name":"$self","containerName":"trunc"},{"containerName":"trunc","name":"strand","line":533,"kind":12},{"kind":13,"line":534,"name":"$out","containerName":"trunc"},{"containerName":"trunc","name":"seq_id","line":534,"kind":12},{"name":"$self","containerName":"trunc","kind":13,"line":534},{"kind":12,"line":534,"containerName":"trunc","name":"seqid"},{"containerName":"trunc","name":"$out","kind":13,"line":535},{"containerName":"trunc","name":"is_remote","line":535,"kind":12},{"containerName":"trunc","name":"$out","line":537,"kind":13},{"line":537,"kind":12,"name":"new","containerName":"trunc"},{"name":"$out","containerName":"trunc","line":538,"kind":13},{"line":538,"kind":12,"containerName":"trunc","name":"start"},{"name":"$newstart","containerName":"trunc","line":538,"kind":13},{"line":539,"kind":13,"name":"$out","containerName":"trunc"},{"line":539,"kind":12,"name":"end","containerName":"trunc"},{"name":"$newend","containerName":"trunc","line":539,"kind":13},{"kind":13,"line":540,"containerName":"trunc","name":"$out"},{"name":"strand","containerName":"trunc","kind":12,"line":540},{"line":540,"kind":13,"name":"$newstrand","containerName":"trunc"},{"kind":13,"line":541,"name":"$out","containerName":"trunc"},{"kind":12,"line":541,"containerName":"trunc","name":"seq_id"},{"line":544,"kind":13,"containerName":"trunc","name":"$out"}],"name":"trunc","range":{"end":{"character":9999,"line":545},"start":{"line":521,"character":0}}},{"name":"Bio","containerName":"Location::Atomic","line":530,"kind":12},{"kind":12,"line":537,"containerName":"Location::Atomic","name":"Bio"}],"version":5}