{"version":5,"vars":[{"kind":2,"line":104,"name":"vars","containerName":""},{"name":"$GAP_SYMBOLS","containerName":null,"kind":13,"line":111},{"kind":13,"line":112,"name":"$FRAMESHIFT_SYMBOLS","containerName":null},{"name":"$OTHER_SYMBOLS","containerName":null,"line":113,"kind":13},{"name":"$RESIDUE_SYMBOLS","containerName":null,"kind":13,"line":114},{"kind":13,"line":115,"containerName":null,"name":"$MATCHPATTERN"},{"kind":13,"line":115,"containerName":null,"name":"$RESIDUE_SYMBOLS"},{"name":"$GAP_SYMBOLS","containerName":null,"kind":13,"line":115},{"line":115,"kind":13,"containerName":null,"name":"$FRAMESHIFT_SYMBOLS"},{"kind":13,"line":115,"name":"$OTHER_SYMBOLS","containerName":null},{"containerName":"","name":"base","kind":2,"line":117},{"range":{"end":{"line":143,"character":9999},"start":{"character":0,"line":119}},"name":"new","line":119,"children":[{"line":120,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"new"},{"line":120,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":121,"definition":"my","name":"$self","containerName":"new","localvar":"my"},{"containerName":"new","name":"$class","line":121,"kind":13},{"kind":13,"line":121,"name":"@args","containerName":"new"},{"localvar":"my","containerName":"new","name":"$start","definition":"my","line":123,"kind":13},{"kind":13,"line":123,"name":"$end","containerName":"new"},{"name":"$strand","containerName":"new","line":123,"kind":13},{"name":"$mapping","containerName":"new","kind":13,"line":123},{"kind":13,"line":123,"name":"$fs","containerName":"new"},{"name":"$nse","containerName":"new","kind":13,"line":123},{"line":124,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"_rearrange","line":124,"kind":12},{"containerName":"new","name":"@args","kind":13,"line":131},{"containerName":"new","name":"$mapping","line":133,"kind":13},{"kind":13,"line":134,"containerName":"new","name":"$self"},{"line":134,"kind":12,"name":"mapping","containerName":"new"},{"containerName":"new","name":"$mapping","kind":13,"line":134},{"kind":13,"line":135,"name":"$nse","containerName":"new"},{"kind":13,"line":136,"name":"$self","containerName":"new"},{"name":"force_nse","containerName":"new","kind":12,"line":136},{"line":136,"kind":13,"name":"$nse","containerName":"new"},{"line":137,"kind":13,"name":"$fs","containerName":"new"},{"line":137,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"frameshifts","kind":12,"line":137},{"line":137,"kind":13,"containerName":"new","name":"$fs"},{"name":"$start","containerName":"new","line":138,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":138},{"containerName":"new","name":"start","line":138,"kind":12},{"containerName":"new","name":"$start","kind":13,"line":138},{"containerName":"new","name":"$end","kind":13,"line":139},{"line":139,"kind":13,"containerName":"new","name":"$self"},{"line":139,"kind":12,"name":"end","containerName":"new"},{"kind":13,"line":139,"name":"$end","containerName":"new"},{"line":140,"kind":13,"containerName":"new","name":"$strand"},{"line":140,"kind":13,"containerName":"new","name":"$self"},{"name":"strand","containerName":"new","line":140,"kind":12},{"kind":13,"line":140,"name":"$strand","containerName":"new"},{"kind":13,"line":142,"containerName":"new","name":"$self"}],"kind":12,"detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"","label":"new($class,@args)"},"containerName":"main::","definition":"sub"},{"kind":12,"line":121,"containerName":"new","name":"SUPER"},{"kind":12,"line":156,"children":[{"kind":13,"line":157,"definition":"my","name":"$self","containerName":"start","localvar":"my"},{"line":159,"kind":13,"localvar":"my","name":"$value","definition":"my","containerName":"start"},{"containerName":"start","name":"$self","kind":13,"line":160},{"containerName":"start","name":"$value","line":160,"kind":13},{"containerName":"start","name":"$self","kind":13,"line":162},{"containerName":"start","name":"$self","line":162,"kind":13},{"containerName":"start","name":"$self","kind":13,"line":163},{"kind":12,"line":163,"containerName":"start","name":"seq"}],"containerName":"main::","name":"start","definition":"sub","range":{"start":{"line":156,"character":0},"end":{"line":165,"character":9999}}},{"containerName":"main::","definition":"sub","name":"end","range":{"end":{"line":211,"character":9999},"start":{"line":183,"character":0}},"kind":12,"line":183,"children":[{"line":184,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"end"},{"containerName":"end","definition":"my","name":"$value","localvar":"my","kind":13,"line":186},{"line":187,"kind":13,"localvar":"my","name":"$st","definition":"my","containerName":"end"},{"name":"$self","containerName":"end","line":187,"kind":13},{"containerName":"end","name":"start","kind":12,"line":187},{"name":"$self","containerName":"end","kind":13,"line":190},{"containerName":"end","name":"seq","line":190,"kind":12},{"kind":13,"line":190,"name":"$st","containerName":"end"},{"localvar":"my","definition":"my","name":"$len","containerName":"end","line":191,"kind":13},{"containerName":"end","name":"$self","kind":13,"line":191},{"kind":12,"line":191,"name":"_ungapped_len","containerName":"end"},{"localvar":"my","containerName":"end","definition":"my","name":"$calend","line":192,"kind":13},{"containerName":"end","name":"$st","kind":13,"line":192},{"containerName":"end","name":"$len","kind":13,"line":192},{"definition":"my","name":"$id","containerName":"end","localvar":"my","kind":13,"line":193},{"line":193,"kind":13,"name":"$self","containerName":"end"},{"line":193,"kind":12,"containerName":"end","name":"id"},{"kind":13,"line":194,"name":"$calend","containerName":"end"},{"name":"$value","containerName":"end","line":194,"kind":13},{"containerName":"end","name":"$self","kind":13,"line":195},{"kind":12,"line":195,"name":"warn","containerName":"end"},{"kind":13,"line":197,"name":"$self","containerName":"end"},{"kind":12,"line":197,"name":"seq","containerName":"end"},{"containerName":"end","name":"$value","kind":13,"line":198},{"kind":13,"line":198,"name":"$calend","containerName":"end"},{"containerName":"end","name":"$self","kind":13,"line":201},{"line":201,"kind":13,"containerName":"end","name":"$value"},{"line":204,"kind":13,"name":"$self","containerName":"end"},{"name":"$self","containerName":"end","line":205,"kind":13},{"name":"$len","definition":"my","containerName":"end","localvar":"my","kind":13,"line":206},{"containerName":"end","name":"$self","line":206,"kind":13},{"line":206,"kind":12,"containerName":"end","name":"_ungapped_len"},{"containerName":"end","name":"$len","kind":13,"line":207},{"containerName":"end","name":"$self","kind":13,"line":207},{"line":207,"kind":12,"name":"start","containerName":"end"}]},{"containerName":"main::","name":"_ungapped_len","definition":"sub","range":{"start":{"character":0,"line":215},"end":{"character":9999,"line":225}},"kind":12,"line":215,"children":[{"definition":"my","name":"$self","containerName":"_ungapped_len","localvar":"my","kind":13,"line":216},{"kind":13,"line":217,"definition":"my","name":"$string","containerName":"_ungapped_len","localvar":"my"},{"kind":13,"line":217,"name":"$self","containerName":"_ungapped_len"},{"name":"seq","containerName":"_ungapped_len","kind":12,"line":217},{"kind":13,"line":218,"containerName":"_ungapped_len","definition":"my","name":"$map_res","localvar":"my"},{"line":218,"kind":13,"name":"$map_coord","containerName":"_ungapped_len"},{"containerName":"_ungapped_len","name":"$self","line":218,"kind":13},{"name":"mapping","containerName":"_ungapped_len","line":218,"kind":12},{"line":219,"kind":13,"localvar":"my","containerName":"_ungapped_len","definition":"my","name":"$offset"},{"containerName":"_ungapped_len","definition":"my","name":"%data","localvar":"my","kind":13,"line":220},{"kind":13,"line":220,"name":"$self","containerName":"_ungapped_len"},{"name":"frameshifts","containerName":"_ungapped_len","kind":12,"line":220},{"containerName":"_ungapped_len","name":"$offset","kind":13,"line":221},{"line":221,"kind":13,"name":"%data","containerName":"_ungapped_len"},{"kind":13,"line":223,"containerName":"_ungapped_len","name":"$string"},{"containerName":"_ungapped_len","name":"$string","kind":13,"line":224},{"kind":13,"line":224,"name":"$map_res","containerName":"_ungapped_len"},{"containerName":"_ungapped_len","name":"$map_coord","line":224,"kind":13},{"kind":13,"line":224,"containerName":"_ungapped_len","name":"$offset"},{"name":"$map_coord","containerName":"_ungapped_len","line":224,"kind":13},{"line":224,"kind":13,"name":"$map_res","containerName":"_ungapped_len"}]},{"containerName":"length","name":"CORE","line":224,"kind":12},{"name":"strand","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":237},"end":{"line":244,"character":9999}},"kind":12,"children":[{"line":238,"kind":13,"localvar":"my","containerName":"strand","name":"$self","definition":"my"},{"localvar":"my","definition":"my","name":"$value","containerName":"strand","line":240,"kind":13},{"containerName":"strand","name":"$self","kind":13,"line":241},{"line":241,"kind":13,"name":"$value","containerName":"strand"},{"line":243,"kind":13,"name":"$self","containerName":"strand"}],"line":237},{"range":{"end":{"line":269,"character":9999},"start":{"line":259,"character":0}},"definition":"sub","name":"mapping","containerName":"main::","children":[{"line":260,"kind":13,"localvar":"my","containerName":"mapping","name":"$self","definition":"my"},{"localvar":"my","name":"@mapping","definition":"my","containerName":"mapping","line":262,"kind":13},{"name":"$self","containerName":"mapping","kind":13,"line":263},{"name":"throw","containerName":"mapping","line":263,"kind":12},{"name":"@mapping","containerName":"mapping","line":264,"kind":13},{"name":"@mapping","containerName":"mapping","kind":13,"line":265},{"name":"$mapping","containerName":"mapping","kind":13,"line":265},{"line":265,"kind":13,"name":"$mapping","containerName":"mapping"},{"name":"$self","containerName":"mapping","line":266,"kind":13},{"containerName":"mapping","name":"throw","line":266,"kind":12},{"line":268,"kind":13,"name":"$self","containerName":"mapping"},{"containerName":"mapping","name":"@mapping","line":268,"kind":13}],"line":259,"kind":12},{"name":"$self","containerName":null,"kind":13,"line":270},{"containerName":"main::","name":"throw","kind":12,"line":270},{"name":"%self","containerName":null,"kind":13,"line":270},{"containerName":null,"name":"%self","line":271,"kind":13},{"name":"frameshifts","definition":"sub","containerName":"main::","range":{"end":{"line":294,"character":9999},"start":{"line":285,"character":0}},"kind":12,"children":[{"line":286,"kind":13,"localvar":"my","containerName":"frameshifts","definition":"my","name":"$self"},{"containerName":"frameshifts","name":"$self","line":289,"kind":13},{"name":"$self","containerName":"frameshifts","kind":13,"line":292}],"line":285},{"name":"_frameshifts","kind":12,"line":289},{"name":"_frameshifts","kind":12,"line":292},{"containerName":null,"name":"%self","kind":13,"line":295},{"line":295,"kind":12,"name":"_frameshifts"},{"kind":13,"line":295,"containerName":null,"name":"%self"},{"name":"_frameshifts","kind":12,"line":295},{"line":296,"kind":13,"name":"%self","containerName":null},{"kind":12,"line":296,"name":"_frameshifts"},{"definition":"sub","containerName":"main::","signature":{"label":"get_nse($self,$char1,$char2)","parameters":[{"label":"$self"},{"label":"$char1"},{"label":"$char2"}],"documentation":"1;\n# $Id: LocatableSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocatableSeq - A Bio::PrimarySeq object with start/end points on it\nthat can be projected into a MSA or have coordinates relative to\nanother seq.\n\n=head1 SYNOPSIS\n\n    use Bio::LocatableSeq;\n    my $seq = Bio::LocatableSeq->new(-seq => \"CAGT-GGT\",\n                    -id  => \"seq1\",\n                    -start => 1,\n                    -end   => 7);\n\n    # a normal sequence object\n    $locseq->seq();\n    $locseq->id();\n\n    # has start,end points\n    $locseq->start();\n    $locseq->end();\n\n    # inherits off RangeI, so range operations possible\n\n=head1 DESCRIPTION\n\nThe LocatableSeq sequence object was developed mainly because the SimpleAlign\nobject requires this functionality, and in the rewrite of the Sequence object we\nhad to decide what to do with this.\n\nIt is, to be honest, not well integrated with the rest of bioperl. For example,\nthe trunc() function does not return a LocatableSeq object, as some might have\nthought. Also, the sequence is not a Bio::SeqI, so the location is simply\ninherited from Bio::RangeI and is not stored in a Bio::Location. \n\nThere are all sorts of nasty gotcha's about interactions between coordinate\nsystems when these sort of objects are used. Some mapping now occurs to deal\nwith HSP data, however it can probably be integrated in better and most methods\ndo not implement it correctly yet. Also, several PrimarySeqI methods (subseq(),\ntrunc(), etc.) do not behave as expected and must be used with care.\n\nDue to this, LocatableSeq functionality is to be refactored in a future BioPerl\nrelease. However, for alignment functionality it works adequately for the time\nbeing\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\npackage Bio::LocatableSeq;\nuse strict;\n\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse vars qw($GAP_SYMBOLS $OTHER_SYMBOLS $FRAMESHIFT_SYMBOLS $RESIDUE_SYMBOLS $MATCHPATTERN);\n\n# The following global variables contain symbols used to represent gaps,\n# frameshifts, residues, and other valid symbols. These are set at compile-time;\n# expect scoping errors when using 'local' and resetting $MATCHPATTERN (see\n# LocatableSeq.t)\n\n$GAP_SYMBOLS = '\\-\\.=~';\n$FRAMESHIFT_SYMBOLS = '\\\\\\/';\n$OTHER_SYMBOLS = '\\?';\n$RESIDUE_SYMBOLS = '0-9A-Za-z\\*';\n$MATCHPATTERN = $RESIDUE_SYMBOLS.$GAP_SYMBOLS.$FRAMESHIFT_SYMBOLS.$OTHER_SYMBOLS;\n\nuse base qw(Bio::PrimarySeq Bio::RangeI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$strand, $mapping, $fs, $nse) =\n    $self->_rearrange( [qw(START\n                        END\n                        STRAND\n                        MAPPING\n                        FRAMESHIFTS\n                        FORCE_NSE\n                        )],\n               @args);\n    \n    $mapping ||= [1,1];\n    $self->mapping($mapping);\n    $nse || 0;\n    $self->force_nse($nse);\n    defined $fs    && $self->frameshifts($fs);\n    defined $start && $self->start($start);\n    defined $end   && $self->end($end);\n    defined $strand && $self->strand($strand);\n\n    return $self; # success - we hope!\n}\n\n=head2 start\n\n Title   : start\n Usage   : $obj->start($newval)\n Function: Get/set the 1-based start position of this sequence in the original\n           sequence. '0' means before the original sequence starts.\n Returns : value of start\n Args    : newvalue (optional)\n\n\nsub start{\n    my $self = shift;\n    if( @_ ) {\n        my $value = shift;\n        $self->{'start'} = $value;\n    }\n    return $self->{'start'} if defined $self->{'start'};\n    return 1                if $self->seq;\n    return;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $obj->end($newval)\n Function: Get/set the 1-based end position of this sequence in the original\n           sequence. '0' means before the original sequence starts.\n Returns : value of end\n Args    : newvalue (optional)\n Note    : although this is a get/set, it checks passed values against the\n           calculated end point ( derived from the sequence and based on\n           $GAP_SYMBOLS and possible frameshifts() ).  If there is no match,\n           it will warn and set the proper value.  Probably best used for\n           debugging proper sequence calculations.\n\n\nsub end {\n    my $self = shift;\n    if( @_ ) {\n        my $value = shift;\n        my $st = $self->start;\n        # start of 0 usually means the sequence is all gaps but maps to\n        # other sequences in an alignment\n        if ($self->seq && $st != 0 ) {\n            my $len = $self->_ungapped_len;\n            my $calend = $st + $len - 1;\n            my $id = $self->id || 'unknown';\n            if ($calend != $value) {\n                $self->warn(\"In sequence $id residue count gives end value \".\n                \"$calend.  \\nOverriding value [$value] with value $calend for \".\n                \"Bio::LocatableSeq::end().\\n\".$self->seq);\n                $value = $calend;\n            }\n        }\n        $self->{'end'} = $value;\n    }\n\n    if (defined $self->{'end'}) {\n        return $self->{'end'}\n    } elsif ( my $len = $self->_ungapped_len) {\n        return $len + $self->start - 1;\n    } else {\n        return;\n    }\n}\n\n# changed 08.10.26 to return ungapped length, not the calculated end\n# of the sequence\nsub _ungapped_len {\n    my $self = shift;\n    return unless my $string = $self->seq;\n    my ($map_res, $map_coord) = $self->mapping;\n    my $offset = 0;\n    if (my %data = $self->frameshifts) {\n        map {$offset += $_} values %data;\n    }\n    $string =~ s{[$GAP_SYMBOLS$FRAMESHIFT_SYMBOLS]+}{}g;\n    return CORE::length($string)/($map_res/$map_coord) + $offset/($map_coord/$map_res);\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: return or set the strandedness\n Returns : the value of the strandedness (-1, 0 or 1)\n Args    : the value of the strandedness (-1, 0 or 1)\n\n\nsub strand{\n   my $self = shift;\n   if( @_ ) {\n        my $value = shift;\n        $self->{'strand'} = $value;\n    }\n    return $self->{'strand'};\n}\n\n=head2 mapping\n\n Title   : mapping\n Usage   : $obj->mapping($newval)\n Function: return or set the mapping indices (indicates # symbols/positions in\n           the source string mapping to # of coordinate positions)\n Returns : two-element array (# symbols => # coordinate pos)\n Args    : two elements (# symbols => # coordinate pos); this can also be\n           passed in as an array reference of the two elements (as might be\n           passed upon Bio::LocatableSeq instantiation, for instance).\n\n\nsub mapping {\n    my $self = shift;\n    if( @_ ) {\n        my @mapping = (ref($_[0]) eq 'ARRAY') ? @{$_[0]} : @_;\n        $self->throw(\"Must pass two values (# residues mapped to # positions)\")\n            if @mapping != 2;\n        if ((grep {$_ != 1 && $_ != 3} @mapping) || ($mapping[0] == 3 && $mapping[1] == 3)) {\n            $self->throw(\"Mapping values other than 1 or 3 are not currently supported\")\n        }\n        $self->{'_mapping'} = \\@mapping;\n    }\n    $self->throw('Mapping for LocatableSeq not set') if !exists $self->{'_mapping'};\n    return @{ $self->{'_mapping'} };\n}\n\n=head2 frameshifts\n\n Title   : frameshifts\n Usage   : $obj->frameshifts($newval)\n Function: get/set the frameshift hash, which contains sequence positions as\n           keys and the shift (-2, -1, 1, 2) as the value\n Returns : hash\n Args    : hash or hash reference\n\n\nsub frameshifts {\n    my $self = shift;\n    if( @_ ) {\n        if (ref $_[0] eq 'HASH') {\n            $self->{_frameshifts} = $_[0];\n        } else {\n            # assume this is a full list to be converted to a hash\n            $self->{_frameshifts} = \\%{@_} # coerce into hash ref\n        }\n    }\n    (defined $self->{_frameshifts} && ref $self->{_frameshifts} eq 'HASH') ?\n        return %{$self->{_frameshifts}} : return ();\n}\n\n=head2 get_nse\n\n Title   : get_nse\n Usage   :\n Function: read-only name of form id/start-end\n Example :\n Returns :\n Args    :"},"detail":"($self,$char1,$char2)","kind":12,"children":[{"line":311,"kind":13,"localvar":"my","containerName":"get_nse","definition":"my","name":"$self"},{"line":311,"kind":13,"containerName":"get_nse","name":"$char1"},{"line":311,"kind":13,"name":"$char2","containerName":"get_nse"},{"line":313,"kind":13,"name":"$char1","containerName":"get_nse"},{"name":"$char2","containerName":"get_nse","line":314,"kind":13},{"line":316,"kind":13,"localvar":"my","containerName":"get_nse","definition":"my","name":"$id"},{"kind":13,"line":316,"containerName":"get_nse","name":"$st"},{"name":"$end","containerName":"get_nse","line":316,"kind":13},{"line":316,"kind":13,"containerName":"get_nse","name":"$self"},{"line":316,"kind":12,"name":"id","containerName":"get_nse"},{"kind":13,"line":316,"name":"$self","containerName":"get_nse"},{"name":"start","containerName":"get_nse","line":316,"kind":12},{"line":316,"kind":13,"name":"$self","containerName":"get_nse"},{"name":"end","containerName":"get_nse","kind":12,"line":316},{"containerName":"get_nse","name":"$self","kind":13,"line":318},{"line":318,"kind":12,"name":"force_nse","containerName":"get_nse"},{"name":"$id","containerName":"get_nse","line":319,"kind":13},{"kind":13,"line":320,"name":"$st","containerName":"get_nse"},{"name":"$end","containerName":"get_nse","kind":13,"line":321},{"kind":13,"line":324,"name":"$self","containerName":"get_nse"},{"line":324,"kind":12,"containerName":"get_nse","name":"throw"},{"containerName":"get_nse","name":"$id","kind":13,"line":324},{"kind":13,"line":325,"containerName":"get_nse","name":"$self"},{"name":"throw","containerName":"get_nse","kind":12,"line":325},{"name":"$st","containerName":"get_nse","line":325,"kind":13},{"line":326,"kind":13,"name":"$self","containerName":"get_nse"},{"containerName":"get_nse","name":"throw","kind":12,"line":326},{"name":"$end","containerName":"get_nse","kind":13,"line":326},{"localvar":"my","containerName":"get_nse","name":"$v","definition":"my","line":329,"kind":13},{"kind":13,"line":329,"containerName":"get_nse","name":"$self"},{"line":329,"kind":12,"name":"version","containerName":"get_nse"},{"line":329,"kind":13,"containerName":"get_nse","name":"$self"},{"containerName":"get_nse","name":"version","line":329,"kind":12},{"name":"$id","containerName":"get_nse","kind":13,"line":330},{"name":"$v","containerName":"get_nse","kind":13,"line":330},{"containerName":"get_nse","name":"$char1","kind":13,"line":330},{"kind":13,"line":330,"containerName":"get_nse","name":"$st"},{"kind":13,"line":330,"name":"$char2","containerName":"get_nse"},{"line":330,"kind":13,"name":"$end","containerName":"get_nse"}],"line":310,"name":"get_nse","range":{"start":{"line":310,"character":0},"end":{"line":331,"character":9999}}},{"range":{"start":{"line":346,"character":0},"end":{"line":352,"character":9999}},"name":"force_nse","line":346,"children":[{"kind":13,"line":347,"containerName":"force_nse","name":"$self","definition":"my","localvar":"my"},{"line":347,"kind":13,"name":"$flag","containerName":"force_nse"},{"name":"$flag","containerName":"force_nse","kind":13,"line":348},{"name":"$flag","containerName":"force_nse","kind":13,"line":349},{"line":349,"kind":13,"name":"$self","containerName":"force_nse"},{"name":"$self","containerName":"force_nse","line":349,"kind":13},{"line":351,"kind":13,"containerName":"force_nse","name":"$self"}],"kind":12,"detail":"($self,$flag)","signature":{"label":"force_nse($self,$flag)","parameters":[{"label":"$self"},{"label":"$flag"}],"documentation":"1;\n# $Id: LocatableSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocatableSeq - A Bio::PrimarySeq object with start/end points on it\nthat can be projected into a MSA or have coordinates relative to\nanother seq.\n\n=head1 SYNOPSIS\n\n    use Bio::LocatableSeq;\n    my $seq = Bio::LocatableSeq->new(-seq => \"CAGT-GGT\",\n                    -id  => \"seq1\",\n                    -start => 1,\n                    -end   => 7);\n\n    # a normal sequence object\n    $locseq->seq();\n    $locseq->id();\n\n    # has start,end points\n    $locseq->start();\n    $locseq->end();\n\n    # inherits off RangeI, so range operations possible\n\n=head1 DESCRIPTION\n\nThe LocatableSeq sequence object was developed mainly because the SimpleAlign\nobject requires this functionality, and in the rewrite of the Sequence object we\nhad to decide what to do with this.\n\nIt is, to be honest, not well integrated with the rest of bioperl. For example,\nthe trunc() function does not return a LocatableSeq object, as some might have\nthought. Also, the sequence is not a Bio::SeqI, so the location is simply\ninherited from Bio::RangeI and is not stored in a Bio::Location. \n\nThere are all sorts of nasty gotcha's about interactions between coordinate\nsystems when these sort of objects are used. Some mapping now occurs to deal\nwith HSP data, however it can probably be integrated in better and most methods\ndo not implement it correctly yet. Also, several PrimarySeqI methods (subseq(),\ntrunc(), etc.) do not behave as expected and must be used with care.\n\nDue to this, LocatableSeq functionality is to be refactored in a future BioPerl\nrelease. However, for alignment functionality it works adequately for the time\nbeing\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\npackage Bio::LocatableSeq;\nuse strict;\n\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse vars qw($GAP_SYMBOLS $OTHER_SYMBOLS $FRAMESHIFT_SYMBOLS $RESIDUE_SYMBOLS $MATCHPATTERN);\n\n# The following global variables contain symbols used to represent gaps,\n# frameshifts, residues, and other valid symbols. These are set at compile-time;\n# expect scoping errors when using 'local' and resetting $MATCHPATTERN (see\n# LocatableSeq.t)\n\n$GAP_SYMBOLS = '\\-\\.=~';\n$FRAMESHIFT_SYMBOLS = '\\\\\\/';\n$OTHER_SYMBOLS = '\\?';\n$RESIDUE_SYMBOLS = '0-9A-Za-z\\*';\n$MATCHPATTERN = $RESIDUE_SYMBOLS.$GAP_SYMBOLS.$FRAMESHIFT_SYMBOLS.$OTHER_SYMBOLS;\n\nuse base qw(Bio::PrimarySeq Bio::RangeI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$strand, $mapping, $fs, $nse) =\n    $self->_rearrange( [qw(START\n                        END\n                        STRAND\n                        MAPPING\n                        FRAMESHIFTS\n                        FORCE_NSE\n                        )],\n               @args);\n    \n    $mapping ||= [1,1];\n    $self->mapping($mapping);\n    $nse || 0;\n    $self->force_nse($nse);\n    defined $fs    && $self->frameshifts($fs);\n    defined $start && $self->start($start);\n    defined $end   && $self->end($end);\n    defined $strand && $self->strand($strand);\n\n    return $self; # success - we hope!\n}\n\n=head2 start\n\n Title   : start\n Usage   : $obj->start($newval)\n Function: Get/set the 1-based start position of this sequence in the original\n           sequence. '0' means before the original sequence starts.\n Returns : value of start\n Args    : newvalue (optional)\n\n\nsub start{\n    my $self = shift;\n    if( @_ ) {\n        my $value = shift;\n        $self->{'start'} = $value;\n    }\n    return $self->{'start'} if defined $self->{'start'};\n    return 1                if $self->seq;\n    return;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $obj->end($newval)\n Function: Get/set the 1-based end position of this sequence in the original\n           sequence. '0' means before the original sequence starts.\n Returns : value of end\n Args    : newvalue (optional)\n Note    : although this is a get/set, it checks passed values against the\n           calculated end point ( derived from the sequence and based on\n           $GAP_SYMBOLS and possible frameshifts() ).  If there is no match,\n           it will warn and set the proper value.  Probably best used for\n           debugging proper sequence calculations.\n\n\nsub end {\n    my $self = shift;\n    if( @_ ) {\n        my $value = shift;\n        my $st = $self->start;\n        # start of 0 usually means the sequence is all gaps but maps to\n        # other sequences in an alignment\n        if ($self->seq && $st != 0 ) {\n            my $len = $self->_ungapped_len;\n            my $calend = $st + $len - 1;\n            my $id = $self->id || 'unknown';\n            if ($calend != $value) {\n                $self->warn(\"In sequence $id residue count gives end value \".\n                \"$calend.  \\nOverriding value [$value] with value $calend for \".\n                \"Bio::LocatableSeq::end().\\n\".$self->seq);\n                $value = $calend;\n            }\n        }\n        $self->{'end'} = $value;\n    }\n\n    if (defined $self->{'end'}) {\n        return $self->{'end'}\n    } elsif ( my $len = $self->_ungapped_len) {\n        return $len + $self->start - 1;\n    } else {\n        return;\n    }\n}\n\n# changed 08.10.26 to return ungapped length, not the calculated end\n# of the sequence\nsub _ungapped_len {\n    my $self = shift;\n    return unless my $string = $self->seq;\n    my ($map_res, $map_coord) = $self->mapping;\n    my $offset = 0;\n    if (my %data = $self->frameshifts) {\n        map {$offset += $_} values %data;\n    }\n    $string =~ s{[$GAP_SYMBOLS$FRAMESHIFT_SYMBOLS]+}{}g;\n    return CORE::length($string)/($map_res/$map_coord) + $offset/($map_coord/$map_res);\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: return or set the strandedness\n Returns : the value of the strandedness (-1, 0 or 1)\n Args    : the value of the strandedness (-1, 0 or 1)\n\n\nsub strand{\n   my $self = shift;\n   if( @_ ) {\n        my $value = shift;\n        $self->{'strand'} = $value;\n    }\n    return $self->{'strand'};\n}\n\n=head2 mapping\n\n Title   : mapping\n Usage   : $obj->mapping($newval)\n Function: return or set the mapping indices (indicates # symbols/positions in\n           the source string mapping to # of coordinate positions)\n Returns : two-element array (# symbols => # coordinate pos)\n Args    : two elements (# symbols => # coordinate pos); this can also be\n           passed in as an array reference of the two elements (as might be\n           passed upon Bio::LocatableSeq instantiation, for instance).\n\n\nsub mapping {\n    my $self = shift;\n    if( @_ ) {\n        my @mapping = (ref($_[0]) eq 'ARRAY') ? @{$_[0]} : @_;\n        $self->throw(\"Must pass two values (# residues mapped to # positions)\")\n            if @mapping != 2;\n        if ((grep {$_ != 1 && $_ != 3} @mapping) || ($mapping[0] == 3 && $mapping[1] == 3)) {\n            $self->throw(\"Mapping values other than 1 or 3 are not currently supported\")\n        }\n        $self->{'_mapping'} = \\@mapping;\n    }\n    $self->throw('Mapping for LocatableSeq not set') if !exists $self->{'_mapping'};\n    return @{ $self->{'_mapping'} };\n}\n\n=head2 frameshifts\n\n Title   : frameshifts\n Usage   : $obj->frameshifts($newval)\n Function: get/set the frameshift hash, which contains sequence positions as\n           keys and the shift (-2, -1, 1, 2) as the value\n Returns : hash\n Args    : hash or hash reference\n\n\nsub frameshifts {\n    my $self = shift;\n    if( @_ ) {\n        if (ref $_[0] eq 'HASH') {\n            $self->{_frameshifts} = $_[0];\n        } else {\n            # assume this is a full list to be converted to a hash\n            $self->{_frameshifts} = \\%{@_} # coerce into hash ref\n        }\n    }\n    (defined $self->{_frameshifts} && ref $self->{_frameshifts} eq 'HASH') ?\n        return %{$self->{_frameshifts}} : return ();\n}\n\n=head2 get_nse\n\n Title   : get_nse\n Usage   :\n Function: read-only name of form id/start-end\n Example :\n Returns :\n Args    :\n\n\nsub get_nse{\n   my ($self,$char1,$char2) = @_;\n\n   $char1 ||= \"/\";\n   $char2 ||= \"-\";\n   \n   my ($id, $st, $end)  = ($self->id(), $self->start(), $self->end());\n   \n   if ($self->force_nse) {\n        $id  ||= '';\n        $st  ||= 0;\n        $end ||= 0;\n   }\n   \n   $self->throw(\"Attribute id not set\") unless defined($id);\n   $self->throw(\"Attribute start not set\") unless defined($st);\n   $self->throw(\"Attribute end not set\") unless defined($end);\n   \n   #Stockholm Rfam includes version if present so it is optional\n   my $v = $self->version ? '.'.$self->version : ''; \n   return $id . $v. $char1 . $st . $char2 . $end ;\n}\n\n=head2 force_nse\n\n Title   : force_nse\n Usage   : $ls->force_nse()\n Function: Boolean which forces get_nse() to build an NSE, regardless\n           of whether id(), start(), or end() is set\n Returns : Boolean value\n Args    : (optional) Boolean (1 or 0)\n Note    : This will convert any passed value evaluating as TRUE/FALSE to 1/0\n           respectively"},"containerName":"main::","definition":"sub"},{"kind":12,"children":[{"localvar":"my","containerName":"num_gaps","definition":"my","name":"$self","line":373,"kind":13},{"kind":13,"line":373,"containerName":"num_gaps","name":"$char"},{"kind":13,"line":374,"name":"$seq","definition":"my","containerName":"num_gaps","localvar":"my"},{"name":"$count","containerName":"num_gaps","line":374,"kind":13},{"name":"$char","containerName":"num_gaps","kind":13,"line":377},{"line":377,"kind":13,"name":"$GAP_SYMBOLS","containerName":"num_gaps"},{"containerName":"num_gaps","name":"$self","kind":13,"line":379},{"name":"warn","containerName":"num_gaps","kind":12,"line":379},{"line":380,"kind":13,"containerName":"num_gaps","name":"$char"},{"kind":13,"line":382,"containerName":"num_gaps","name":"$seq"},{"line":382,"kind":13,"containerName":"num_gaps","name":"$self"},{"line":382,"kind":12,"containerName":"num_gaps","name":"seq"},{"line":383,"kind":13,"name":"$seq","containerName":"num_gaps"},{"name":"$seq","containerName":"num_gaps","line":385,"kind":13},{"name":"$seq","containerName":"num_gaps","line":386,"kind":13},{"name":"$seq","containerName":"num_gaps","line":387,"kind":13},{"name":"$count","containerName":"num_gaps","line":388,"kind":13},{"containerName":"num_gaps","name":"$count","kind":13,"line":391}],"line":372,"definition":"sub","containerName":"main::","signature":{"label":"num_gaps($self,$char)","parameters":[{"label":"$self"},{"label":"$char"}],"documentation":"1;\n# $Id: LocatableSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocatableSeq - A Bio::PrimarySeq object with start/end points on it\nthat can be projected into a MSA or have coordinates relative to\nanother seq.\n\n=head1 SYNOPSIS\n\n    use Bio::LocatableSeq;\n    my $seq = Bio::LocatableSeq->new(-seq => \"CAGT-GGT\",\n                    -id  => \"seq1\",\n                    -start => 1,\n                    -end   => 7);\n\n    # a normal sequence object\n    $locseq->seq();\n    $locseq->id();\n\n    # has start,end points\n    $locseq->start();\n    $locseq->end();\n\n    # inherits off RangeI, so range operations possible\n\n=head1 DESCRIPTION\n\nThe LocatableSeq sequence object was developed mainly because the SimpleAlign\nobject requires this functionality, and in the rewrite of the Sequence object we\nhad to decide what to do with this.\n\nIt is, to be honest, not well integrated with the rest of bioperl. For example,\nthe trunc() function does not return a LocatableSeq object, as some might have\nthought. Also, the sequence is not a Bio::SeqI, so the location is simply\ninherited from Bio::RangeI and is not stored in a Bio::Location. \n\nThere are all sorts of nasty gotcha's about interactions between coordinate\nsystems when these sort of objects are used. Some mapping now occurs to deal\nwith HSP data, however it can probably be integrated in better and most methods\ndo not implement it correctly yet. Also, several PrimarySeqI methods (subseq(),\ntrunc(), etc.) do not behave as expected and must be used with care.\n\nDue to this, LocatableSeq functionality is to be refactored in a future BioPerl\nrelease. However, for alignment functionality it works adequately for the time\nbeing\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\npackage Bio::LocatableSeq;\nuse strict;\n\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse vars qw($GAP_SYMBOLS $OTHER_SYMBOLS $FRAMESHIFT_SYMBOLS $RESIDUE_SYMBOLS $MATCHPATTERN);\n\n# The following global variables contain symbols used to represent gaps,\n# frameshifts, residues, and other valid symbols. These are set at compile-time;\n# expect scoping errors when using 'local' and resetting $MATCHPATTERN (see\n# LocatableSeq.t)\n\n$GAP_SYMBOLS = '\\-\\.=~';\n$FRAMESHIFT_SYMBOLS = '\\\\\\/';\n$OTHER_SYMBOLS = '\\?';\n$RESIDUE_SYMBOLS = '0-9A-Za-z\\*';\n$MATCHPATTERN = $RESIDUE_SYMBOLS.$GAP_SYMBOLS.$FRAMESHIFT_SYMBOLS.$OTHER_SYMBOLS;\n\nuse base qw(Bio::PrimarySeq Bio::RangeI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$strand, $mapping, $fs, $nse) =\n    $self->_rearrange( [qw(START\n                        END\n                        STRAND\n                        MAPPING\n                        FRAMESHIFTS\n                        FORCE_NSE\n                        )],\n               @args);\n    \n    $mapping ||= [1,1];\n    $self->mapping($mapping);\n    $nse || 0;\n    $self->force_nse($nse);\n    defined $fs    && $self->frameshifts($fs);\n    defined $start && $self->start($start);\n    defined $end   && $self->end($end);\n    defined $strand && $self->strand($strand);\n\n    return $self; # success - we hope!\n}\n\n=head2 start\n\n Title   : start\n Usage   : $obj->start($newval)\n Function: Get/set the 1-based start position of this sequence in the original\n           sequence. '0' means before the original sequence starts.\n Returns : value of start\n Args    : newvalue (optional)\n\n\nsub start{\n    my $self = shift;\n    if( @_ ) {\n        my $value = shift;\n        $self->{'start'} = $value;\n    }\n    return $self->{'start'} if defined $self->{'start'};\n    return 1                if $self->seq;\n    return;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $obj->end($newval)\n Function: Get/set the 1-based end position of this sequence in the original\n           sequence. '0' means before the original sequence starts.\n Returns : value of end\n Args    : newvalue (optional)\n Note    : although this is a get/set, it checks passed values against the\n           calculated end point ( derived from the sequence and based on\n           $GAP_SYMBOLS and possible frameshifts() ).  If there is no match,\n           it will warn and set the proper value.  Probably best used for\n           debugging proper sequence calculations.\n\n\nsub end {\n    my $self = shift;\n    if( @_ ) {\n        my $value = shift;\n        my $st = $self->start;\n        # start of 0 usually means the sequence is all gaps but maps to\n        # other sequences in an alignment\n        if ($self->seq && $st != 0 ) {\n            my $len = $self->_ungapped_len;\n            my $calend = $st + $len - 1;\n            my $id = $self->id || 'unknown';\n            if ($calend != $value) {\n                $self->warn(\"In sequence $id residue count gives end value \".\n                \"$calend.  \\nOverriding value [$value] with value $calend for \".\n                \"Bio::LocatableSeq::end().\\n\".$self->seq);\n                $value = $calend;\n            }\n        }\n        $self->{'end'} = $value;\n    }\n\n    if (defined $self->{'end'}) {\n        return $self->{'end'}\n    } elsif ( my $len = $self->_ungapped_len) {\n        return $len + $self->start - 1;\n    } else {\n        return;\n    }\n}\n\n# changed 08.10.26 to return ungapped length, not the calculated end\n# of the sequence\nsub _ungapped_len {\n    my $self = shift;\n    return unless my $string = $self->seq;\n    my ($map_res, $map_coord) = $self->mapping;\n    my $offset = 0;\n    if (my %data = $self->frameshifts) {\n        map {$offset += $_} values %data;\n    }\n    $string =~ s{[$GAP_SYMBOLS$FRAMESHIFT_SYMBOLS]+}{}g;\n    return CORE::length($string)/($map_res/$map_coord) + $offset/($map_coord/$map_res);\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: return or set the strandedness\n Returns : the value of the strandedness (-1, 0 or 1)\n Args    : the value of the strandedness (-1, 0 or 1)\n\n\nsub strand{\n   my $self = shift;\n   if( @_ ) {\n        my $value = shift;\n        $self->{'strand'} = $value;\n    }\n    return $self->{'strand'};\n}\n\n=head2 mapping\n\n Title   : mapping\n Usage   : $obj->mapping($newval)\n Function: return or set the mapping indices (indicates # symbols/positions in\n           the source string mapping to # of coordinate positions)\n Returns : two-element array (# symbols => # coordinate pos)\n Args    : two elements (# symbols => # coordinate pos); this can also be\n           passed in as an array reference of the two elements (as might be\n           passed upon Bio::LocatableSeq instantiation, for instance).\n\n\nsub mapping {\n    my $self = shift;\n    if( @_ ) {\n        my @mapping = (ref($_[0]) eq 'ARRAY') ? @{$_[0]} : @_;\n        $self->throw(\"Must pass two values (# residues mapped to # positions)\")\n            if @mapping != 2;\n        if ((grep {$_ != 1 && $_ != 3} @mapping) || ($mapping[0] == 3 && $mapping[1] == 3)) {\n            $self->throw(\"Mapping values other than 1 or 3 are not currently supported\")\n        }\n        $self->{'_mapping'} = \\@mapping;\n    }\n    $self->throw('Mapping for LocatableSeq not set') if !exists $self->{'_mapping'};\n    return @{ $self->{'_mapping'} };\n}\n\n=head2 frameshifts\n\n Title   : frameshifts\n Usage   : $obj->frameshifts($newval)\n Function: get/set the frameshift hash, which contains sequence positions as\n           keys and the shift (-2, -1, 1, 2) as the value\n Returns : hash\n Args    : hash or hash reference\n\n\nsub frameshifts {\n    my $self = shift;\n    if( @_ ) {\n        if (ref $_[0] eq 'HASH') {\n            $self->{_frameshifts} = $_[0];\n        } else {\n            # assume this is a full list to be converted to a hash\n            $self->{_frameshifts} = \\%{@_} # coerce into hash ref\n        }\n    }\n    (defined $self->{_frameshifts} && ref $self->{_frameshifts} eq 'HASH') ?\n        return %{$self->{_frameshifts}} : return ();\n}\n\n=head2 get_nse\n\n Title   : get_nse\n Usage   :\n Function: read-only name of form id/start-end\n Example :\n Returns :\n Args    :\n\n\nsub get_nse{\n   my ($self,$char1,$char2) = @_;\n\n   $char1 ||= \"/\";\n   $char2 ||= \"-\";\n   \n   my ($id, $st, $end)  = ($self->id(), $self->start(), $self->end());\n   \n   if ($self->force_nse) {\n        $id  ||= '';\n        $st  ||= 0;\n        $end ||= 0;\n   }\n   \n   $self->throw(\"Attribute id not set\") unless defined($id);\n   $self->throw(\"Attribute start not set\") unless defined($st);\n   $self->throw(\"Attribute end not set\") unless defined($end);\n   \n   #Stockholm Rfam includes version if present so it is optional\n   my $v = $self->version ? '.'.$self->version : ''; \n   return $id . $v. $char1 . $st . $char2 . $end ;\n}\n\n=head2 force_nse\n\n Title   : force_nse\n Usage   : $ls->force_nse()\n Function: Boolean which forces get_nse() to build an NSE, regardless\n           of whether id(), start(), or end() is set\n Returns : Boolean value\n Args    : (optional) Boolean (1 or 0)\n Note    : This will convert any passed value evaluating as TRUE/FALSE to 1/0\n           respectively\n\n\nsub force_nse {\n    my ($self, $flag) = @_;\n    if (defined $flag) {\n        $flag ? (return $self->{'_force_nse'} = 1) : (return $self->{'_force_nse'} = 0);\n    }\n    return $self->{'_force_nse'};\n}\n\n=head2 num_gaps\n\n Title   : num_gaps\n Usage   :$self->num_gaps('.')\n Function:Gets number of gaps in the sequence. The count excludes\n           leading or trailing gap characters.\n\n           Valid bioperl sequence characters are [A-Za-z\\-\\.\\*]. Of\n           these, '.' and '-' are counted as gap characters unless an\n           optional argument specifies one of them.\n\n Returns : number of internal gaps in the sequence.\n Args    : a gap character (optional)\n Status  : Stable\n Note    : replaces no_gaps"},"detail":"($self,$char)","name":"num_gaps","range":{"start":{"line":372,"character":0},"end":{"line":392,"character":9999}}},{"range":{"end":{"character":9999,"line":472},"start":{"character":0,"line":420}},"name":"column_from_residue_number","line":420,"children":[{"kind":13,"line":421,"containerName":"column_from_residue_number","definition":"my","name":"$self","localvar":"my"},{"name":"$resnumber","containerName":"column_from_residue_number","kind":13,"line":421},{"kind":13,"line":423,"name":"$self","containerName":"column_from_residue_number"},{"containerName":"column_from_residue_number","name":"throw","kind":12,"line":423},{"containerName":"column_from_residue_number","name":"$resnumber","line":424,"kind":13},{"kind":13,"line":424,"containerName":"column_from_residue_number","name":"$resnumber"},{"containerName":"column_from_residue_number","name":"$resnumber","kind":13,"line":426},{"containerName":"column_from_residue_number","name":"$self","kind":13,"line":426},{"containerName":"column_from_residue_number","name":"start","kind":12,"line":426},{"name":"$resnumber","containerName":"column_from_residue_number","line":426,"kind":13},{"kind":13,"line":426,"name":"$self","containerName":"column_from_residue_number"},{"containerName":"column_from_residue_number","name":"end","kind":12,"line":426},{"line":427,"kind":13,"localvar":"my","containerName":"column_from_residue_number","definition":"my","name":"@chunks"},{"name":"$column_incr","definition":"my","containerName":"column_from_residue_number","localvar":"my","kind":13,"line":428},{"kind":13,"line":429,"definition":"my","name":"$current_column","containerName":"column_from_residue_number","localvar":"my"},{"containerName":"column_from_residue_number","definition":"my","name":"$current_residue","localvar":"my","kind":13,"line":430},{"line":430,"kind":13,"containerName":"column_from_residue_number","name":"$self"},{"name":"start","containerName":"column_from_residue_number","kind":12,"line":430},{"localvar":"my","containerName":"column_from_residue_number","name":"$seq","definition":"my","line":431,"kind":13},{"kind":13,"line":431,"name":"$self","containerName":"column_from_residue_number"},{"name":"seq","containerName":"column_from_residue_number","line":431,"kind":12},{"containerName":"column_from_residue_number","name":"$strand","definition":"my","localvar":"my","kind":13,"line":432},{"line":432,"kind":13,"containerName":"column_from_residue_number","name":"$self"},{"name":"strand","containerName":"column_from_residue_number","kind":12,"line":432},{"containerName":"column_from_residue_number","name":"$strand","line":434,"kind":13},{"line":436,"kind":13,"containerName":"column_from_residue_number","name":"@chunks"},{"line":436,"kind":13,"containerName":"column_from_residue_number","name":"$seq"},{"kind":13,"line":437,"containerName":"column_from_residue_number","name":"$column_incr"},{"name":"$current_column","containerName":"column_from_residue_number","line":438,"kind":13},{"line":438,"kind":13,"name":"$seq","containerName":"column_from_residue_number"},{"kind":13,"line":442,"name":"@chunks","containerName":"column_from_residue_number"},{"name":"$seq","containerName":"column_from_residue_number","kind":13,"line":442},{"name":"$column_incr","containerName":"column_from_residue_number","kind":13,"line":443},{"name":"$current_column","containerName":"column_from_residue_number","line":444,"kind":13},{"line":447,"kind":13,"localvar":"my","definition":"my","name":"$chunk","containerName":"column_from_residue_number"},{"kind":13,"line":447,"name":"@chunks","containerName":"column_from_residue_number"},{"kind":13,"line":449,"name":"$chunk","containerName":"column_from_residue_number"},{"kind":13,"line":450,"name":"$current_column","containerName":"column_from_residue_number"},{"name":"$column_incr","containerName":"column_from_residue_number","kind":13,"line":450},{"line":450,"kind":13,"name":"$chunk","containerName":"column_from_residue_number"},{"name":"$current_residue","containerName":"column_from_residue_number","line":453,"kind":13},{"line":453,"kind":13,"name":"$chunk","containerName":"column_from_residue_number"},{"kind":13,"line":453,"name":"$resnumber","containerName":"column_from_residue_number"},{"line":454,"kind":13,"containerName":"column_from_residue_number","name":"$current_column"},{"kind":13,"line":454,"name":"$column_incr","containerName":"column_from_residue_number"},{"containerName":"column_from_residue_number","name":"$chunk","kind":13,"line":454},{"name":"$current_residue","containerName":"column_from_residue_number","kind":13,"line":455},{"containerName":"column_from_residue_number","name":"$chunk","kind":13,"line":455},{"containerName":"column_from_residue_number","name":"$strand","kind":13,"line":458},{"line":459,"kind":13,"name":"$current_column","containerName":"column_from_residue_number"},{"name":"$resnumber","containerName":"column_from_residue_number","line":459,"kind":13},{"containerName":"column_from_residue_number","name":"$current_residue","line":459,"kind":13},{"line":462,"kind":13,"containerName":"column_from_residue_number","name":"$current_column"},{"kind":13,"line":462,"containerName":"column_from_residue_number","name":"$resnumber"},{"kind":13,"line":462,"name":"$current_residue","containerName":"column_from_residue_number"},{"name":"$current_column","containerName":"column_from_residue_number","line":464,"kind":13},{"name":"$self","containerName":"column_from_residue_number","line":470,"kind":13},{"kind":12,"line":470,"containerName":"column_from_residue_number","name":"throw"}],"kind":12,"detail":"($self,$resnumber)","signature":{"label":"column_from_residue_number($self,$resnumber)","parameters":[{"label":"$self"},{"label":"$resnumber"}],"documentation":"1;\n# $Id: LocatableSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocatableSeq - A Bio::PrimarySeq object with start/end points on it\nthat can be projected into a MSA or have coordinates relative to\nanother seq.\n\n=head1 SYNOPSIS\n\n    use Bio::LocatableSeq;\n    my $seq = Bio::LocatableSeq->new(-seq => \"CAGT-GGT\",\n                    -id  => \"seq1\",\n                    -start => 1,\n                    -end   => 7);\n\n    # a normal sequence object\n    $locseq->seq();\n    $locseq->id();\n\n    # has start,end points\n    $locseq->start();\n    $locseq->end();\n\n    # inherits off RangeI, so range operations possible\n\n=head1 DESCRIPTION\n\nThe LocatableSeq sequence object was developed mainly because the SimpleAlign\nobject requires this functionality, and in the rewrite of the Sequence object we\nhad to decide what to do with this.\n\nIt is, to be honest, not well integrated with the rest of bioperl. For example,\nthe trunc() function does not return a LocatableSeq object, as some might have\nthought. Also, the sequence is not a Bio::SeqI, so the location is simply\ninherited from Bio::RangeI and is not stored in a Bio::Location. \n\nThere are all sorts of nasty gotcha's about interactions between coordinate\nsystems when these sort of objects are used. Some mapping now occurs to deal\nwith HSP data, however it can probably be integrated in better and most methods\ndo not implement it correctly yet. Also, several PrimarySeqI methods (subseq(),\ntrunc(), etc.) do not behave as expected and must be used with care.\n\nDue to this, LocatableSeq functionality is to be refactored in a future BioPerl\nrelease. However, for alignment functionality it works adequately for the time\nbeing\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\npackage Bio::LocatableSeq;\nuse strict;\n\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse vars qw($GAP_SYMBOLS $OTHER_SYMBOLS $FRAMESHIFT_SYMBOLS $RESIDUE_SYMBOLS $MATCHPATTERN);\n\n# The following global variables contain symbols used to represent gaps,\n# frameshifts, residues, and other valid symbols. These are set at compile-time;\n# expect scoping errors when using 'local' and resetting $MATCHPATTERN (see\n# LocatableSeq.t)\n\n$GAP_SYMBOLS = '\\-\\.=~';\n$FRAMESHIFT_SYMBOLS = '\\\\\\/';\n$OTHER_SYMBOLS = '\\?';\n$RESIDUE_SYMBOLS = '0-9A-Za-z\\*';\n$MATCHPATTERN = $RESIDUE_SYMBOLS.$GAP_SYMBOLS.$FRAMESHIFT_SYMBOLS.$OTHER_SYMBOLS;\n\nuse base qw(Bio::PrimarySeq Bio::RangeI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$strand, $mapping, $fs, $nse) =\n    $self->_rearrange( [qw(START\n                        END\n                        STRAND\n                        MAPPING\n                        FRAMESHIFTS\n                        FORCE_NSE\n                        )],\n               @args);\n    \n    $mapping ||= [1,1];\n    $self->mapping($mapping);\n    $nse || 0;\n    $self->force_nse($nse);\n    defined $fs    && $self->frameshifts($fs);\n    defined $start && $self->start($start);\n    defined $end   && $self->end($end);\n    defined $strand && $self->strand($strand);\n\n    return $self; # success - we hope!\n}\n\n=head2 start\n\n Title   : start\n Usage   : $obj->start($newval)\n Function: Get/set the 1-based start position of this sequence in the original\n           sequence. '0' means before the original sequence starts.\n Returns : value of start\n Args    : newvalue (optional)\n\n\nsub start{\n    my $self = shift;\n    if( @_ ) {\n        my $value = shift;\n        $self->{'start'} = $value;\n    }\n    return $self->{'start'} if defined $self->{'start'};\n    return 1                if $self->seq;\n    return;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $obj->end($newval)\n Function: Get/set the 1-based end position of this sequence in the original\n           sequence. '0' means before the original sequence starts.\n Returns : value of end\n Args    : newvalue (optional)\n Note    : although this is a get/set, it checks passed values against the\n           calculated end point ( derived from the sequence and based on\n           $GAP_SYMBOLS and possible frameshifts() ).  If there is no match,\n           it will warn and set the proper value.  Probably best used for\n           debugging proper sequence calculations.\n\n\nsub end {\n    my $self = shift;\n    if( @_ ) {\n        my $value = shift;\n        my $st = $self->start;\n        # start of 0 usually means the sequence is all gaps but maps to\n        # other sequences in an alignment\n        if ($self->seq && $st != 0 ) {\n            my $len = $self->_ungapped_len;\n            my $calend = $st + $len - 1;\n            my $id = $self->id || 'unknown';\n            if ($calend != $value) {\n                $self->warn(\"In sequence $id residue count gives end value \".\n                \"$calend.  \\nOverriding value [$value] with value $calend for \".\n                \"Bio::LocatableSeq::end().\\n\".$self->seq);\n                $value = $calend;\n            }\n        }\n        $self->{'end'} = $value;\n    }\n\n    if (defined $self->{'end'}) {\n        return $self->{'end'}\n    } elsif ( my $len = $self->_ungapped_len) {\n        return $len + $self->start - 1;\n    } else {\n        return;\n    }\n}\n\n# changed 08.10.26 to return ungapped length, not the calculated end\n# of the sequence\nsub _ungapped_len {\n    my $self = shift;\n    return unless my $string = $self->seq;\n    my ($map_res, $map_coord) = $self->mapping;\n    my $offset = 0;\n    if (my %data = $self->frameshifts) {\n        map {$offset += $_} values %data;\n    }\n    $string =~ s{[$GAP_SYMBOLS$FRAMESHIFT_SYMBOLS]+}{}g;\n    return CORE::length($string)/($map_res/$map_coord) + $offset/($map_coord/$map_res);\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: return or set the strandedness\n Returns : the value of the strandedness (-1, 0 or 1)\n Args    : the value of the strandedness (-1, 0 or 1)\n\n\nsub strand{\n   my $self = shift;\n   if( @_ ) {\n        my $value = shift;\n        $self->{'strand'} = $value;\n    }\n    return $self->{'strand'};\n}\n\n=head2 mapping\n\n Title   : mapping\n Usage   : $obj->mapping($newval)\n Function: return or set the mapping indices (indicates # symbols/positions in\n           the source string mapping to # of coordinate positions)\n Returns : two-element array (# symbols => # coordinate pos)\n Args    : two elements (# symbols => # coordinate pos); this can also be\n           passed in as an array reference of the two elements (as might be\n           passed upon Bio::LocatableSeq instantiation, for instance).\n\n\nsub mapping {\n    my $self = shift;\n    if( @_ ) {\n        my @mapping = (ref($_[0]) eq 'ARRAY') ? @{$_[0]} : @_;\n        $self->throw(\"Must pass two values (# residues mapped to # positions)\")\n            if @mapping != 2;\n        if ((grep {$_ != 1 && $_ != 3} @mapping) || ($mapping[0] == 3 && $mapping[1] == 3)) {\n            $self->throw(\"Mapping values other than 1 or 3 are not currently supported\")\n        }\n        $self->{'_mapping'} = \\@mapping;\n    }\n    $self->throw('Mapping for LocatableSeq not set') if !exists $self->{'_mapping'};\n    return @{ $self->{'_mapping'} };\n}\n\n=head2 frameshifts\n\n Title   : frameshifts\n Usage   : $obj->frameshifts($newval)\n Function: get/set the frameshift hash, which contains sequence positions as\n           keys and the shift (-2, -1, 1, 2) as the value\n Returns : hash\n Args    : hash or hash reference\n\n\nsub frameshifts {\n    my $self = shift;\n    if( @_ ) {\n        if (ref $_[0] eq 'HASH') {\n            $self->{_frameshifts} = $_[0];\n        } else {\n            # assume this is a full list to be converted to a hash\n            $self->{_frameshifts} = \\%{@_} # coerce into hash ref\n        }\n    }\n    (defined $self->{_frameshifts} && ref $self->{_frameshifts} eq 'HASH') ?\n        return %{$self->{_frameshifts}} : return ();\n}\n\n=head2 get_nse\n\n Title   : get_nse\n Usage   :\n Function: read-only name of form id/start-end\n Example :\n Returns :\n Args    :\n\n\nsub get_nse{\n   my ($self,$char1,$char2) = @_;\n\n   $char1 ||= \"/\";\n   $char2 ||= \"-\";\n   \n   my ($id, $st, $end)  = ($self->id(), $self->start(), $self->end());\n   \n   if ($self->force_nse) {\n        $id  ||= '';\n        $st  ||= 0;\n        $end ||= 0;\n   }\n   \n   $self->throw(\"Attribute id not set\") unless defined($id);\n   $self->throw(\"Attribute start not set\") unless defined($st);\n   $self->throw(\"Attribute end not set\") unless defined($end);\n   \n   #Stockholm Rfam includes version if present so it is optional\n   my $v = $self->version ? '.'.$self->version : ''; \n   return $id . $v. $char1 . $st . $char2 . $end ;\n}\n\n=head2 force_nse\n\n Title   : force_nse\n Usage   : $ls->force_nse()\n Function: Boolean which forces get_nse() to build an NSE, regardless\n           of whether id(), start(), or end() is set\n Returns : Boolean value\n Args    : (optional) Boolean (1 or 0)\n Note    : This will convert any passed value evaluating as TRUE/FALSE to 1/0\n           respectively\n\n\nsub force_nse {\n    my ($self, $flag) = @_;\n    if (defined $flag) {\n        $flag ? (return $self->{'_force_nse'} = 1) : (return $self->{'_force_nse'} = 0);\n    }\n    return $self->{'_force_nse'};\n}\n\n=head2 num_gaps\n\n Title   : num_gaps\n Usage   :$self->num_gaps('.')\n Function:Gets number of gaps in the sequence. The count excludes\n           leading or trailing gap characters.\n\n           Valid bioperl sequence characters are [A-Za-z\\-\\.\\*]. Of\n           these, '.' and '-' are counted as gap characters unless an\n           optional argument specifies one of them.\n\n Returns : number of internal gaps in the sequence.\n Args    : a gap character (optional)\n Status  : Stable\n Note    : replaces no_gaps\n\n\nsub num_gaps {\n    my ($self,$char) = @_;\n    my ($seq, $count) = (undef, 0);\n\n    # default gap characters\n    $char ||= $GAP_SYMBOLS;\n\n    $self->warn(\"I hope you know what you are doing setting gap to [$char]\")\n        unless $char =~ /[$GAP_SYMBOLS]/;\n\n    $seq = $self->seq;\n    return 0 unless $seq; # empty sequence does not have gaps\n\n    $seq =~ s/^([$char]+)//;\n    $seq =~ s/([$char]+)$//;\n    while ( $seq =~ /[$char]+/g ) {\n        $count++;\n    }\n\n    return $count;\n}\n\n\n=head2 column_from_residue_number\n\n Title   : column_from_residue_number\n Usage   : $col = $seq->column_from_residue_number($resnumber)\n Function:\n\n           This function gives the position in the alignment\n           (i.e. column number) of the given residue number in the\n           sequence. For example, for the sequence\n\n         Seq1/91-97 AC..DEF.GH\n\n           column_from_residue_number(94) returns 6.\n\n           An exception is thrown if the residue number would lie\n           outside the length of the aligment\n           (e.g. column_from_residue_number( \"Seq2\", 22 )\n\n Returns : A column number for the position of the\n           given residue in the given sequence (1 = first column)\n Args    : A residue number in the whole sequence (not just that\n           segment of it in the alignment)"},"containerName":"main::","definition":"sub"},{"name":"CORE","containerName":"length","kind":12,"line":438},{"line":450,"kind":12,"name":"CORE","containerName":"length"},{"containerName":"length","name":"CORE","kind":12,"line":453},{"kind":12,"line":454,"containerName":"length","name":"CORE"},{"name":"CORE","containerName":"length","kind":12,"line":455},{"children":[{"containerName":"location_from_column","name":"$self","definition":"my","localvar":"my","kind":13,"line":513},{"kind":13,"line":513,"name":"$column","containerName":"location_from_column"},{"line":515,"kind":13,"containerName":"location_from_column","name":"$self"},{"name":"throw","containerName":"location_from_column","line":515,"kind":12},{"line":516,"kind":13,"name":"$column","containerName":"location_from_column"},{"name":"$column","containerName":"location_from_column","kind":13,"line":516},{"line":517,"kind":13,"containerName":"location_from_column","name":"$self"},{"kind":12,"line":517,"name":"throw","containerName":"location_from_column"},{"containerName":"location_from_column","name":"$self","line":518,"kind":13},{"kind":12,"line":518,"name":"length","containerName":"location_from_column"},{"containerName":"location_from_column","name":"$column","line":519,"kind":13},{"line":519,"kind":13,"containerName":"location_from_column","name":"$self"},{"kind":12,"line":519,"containerName":"location_from_column","name":"length"},{"name":"$loc","definition":"my","containerName":"location_from_column","localvar":"my","kind":13,"line":521},{"line":522,"kind":13,"localvar":"my","containerName":"location_from_column","name":"$s","definition":"my"},{"kind":13,"line":522,"containerName":"location_from_column","name":"$self"},{"kind":12,"line":522,"name":"subseq","containerName":"location_from_column"},{"name":"$column","containerName":"location_from_column","line":522,"kind":13},{"line":523,"kind":13,"name":"$s","containerName":"location_from_column"},{"localvar":"my","definition":"my","name":"$pos","containerName":"location_from_column","line":525,"kind":13},{"name":"$s","containerName":"location_from_column","line":525,"kind":13},{"localvar":"my","name":"$start","definition":"my","containerName":"location_from_column","line":527,"kind":13},{"line":527,"kind":13,"containerName":"location_from_column","name":"$self"},{"containerName":"location_from_column","name":"start","kind":12,"line":527},{"containerName":"location_from_column","name":"$strand","definition":"my","localvar":"my","kind":13,"line":528},{"line":528,"kind":13,"containerName":"location_from_column","name":"$self"},{"kind":12,"line":528,"containerName":"location_from_column","name":"strand"},{"name":"$relative_pos","definition":"my","containerName":"location_from_column","localvar":"my","kind":13,"line":529},{"line":529,"kind":13,"name":"$strand","containerName":"location_from_column"},{"kind":13,"line":530,"containerName":"location_from_column","name":"$self"},{"name":"end","containerName":"location_from_column","kind":12,"line":530},{"containerName":"location_from_column","name":"$pos","kind":13,"line":530},{"name":"$pos","containerName":"location_from_column","line":531,"kind":13},{"name":"$start","containerName":"location_from_column","line":531,"kind":13},{"line":532,"kind":13,"name":"$self","containerName":"location_from_column"},{"kind":12,"line":532,"name":"subseq","containerName":"location_from_column"},{"containerName":"location_from_column","name":"$column","line":532,"kind":13},{"containerName":"location_from_column","name":"$column","kind":13,"line":532},{"kind":13,"line":533,"name":"$loc","containerName":"location_from_column"},{"kind":12,"line":534,"name":"new","containerName":"location_from_column"},{"containerName":"location_from_column","name":"$relative_pos","kind":13,"line":534},{"kind":13,"line":535,"name":"$relative_pos","containerName":"location_from_column"},{"line":538,"kind":13,"containerName":"location_from_column","name":"$pos"},{"containerName":"location_from_column","name":"$self","kind":13,"line":538},{"kind":12,"line":538,"containerName":"location_from_column","name":"start"},{"localvar":"my","name":"$start","definition":"my","containerName":"location_from_column","line":540,"kind":13},{"containerName":"location_from_column","name":"$end","kind":13,"line":540},{"kind":13,"line":540,"containerName":"location_from_column","name":"$relative_pos"},{"containerName":"location_from_column","name":"$relative_pos","kind":13,"line":540},{"kind":13,"line":540,"containerName":"location_from_column","name":"$strand"},{"containerName":"location_from_column","name":"$strand","line":541,"kind":13},{"name":"$start","containerName":"location_from_column","kind":13,"line":542},{"kind":13,"line":542,"containerName":"location_from_column","name":"$end"},{"name":"$end","containerName":"location_from_column","line":542,"kind":13},{"containerName":"location_from_column","name":"$start","line":542,"kind":13},{"containerName":"location_from_column","name":"$loc","line":544,"kind":13},{"containerName":"location_from_column","name":"new","kind":12,"line":545},{"line":545,"kind":13,"name":"$start","containerName":"location_from_column"},{"containerName":"location_from_column","name":"$end","kind":13,"line":546},{"containerName":"location_from_column","name":"$loc","line":551,"kind":13}],"line":512,"kind":12,"signature":{"documentation":"1;\n# $Id: LocatableSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocatableSeq - A Bio::PrimarySeq object with start/end points on it\nthat can be projected into a MSA or have coordinates relative to\nanother seq.\n\n=head1 SYNOPSIS\n\n    use Bio::LocatableSeq;\n    my $seq = Bio::LocatableSeq->new(-seq => \"CAGT-GGT\",\n                    -id  => \"seq1\",\n                    -start => 1,\n                    -end   => 7);\n\n    # a normal sequence object\n    $locseq->seq();\n    $locseq->id();\n\n    # has start,end points\n    $locseq->start();\n    $locseq->end();\n\n    # inherits off RangeI, so range operations possible\n\n=head1 DESCRIPTION\n\nThe LocatableSeq sequence object was developed mainly because the SimpleAlign\nobject requires this functionality, and in the rewrite of the Sequence object we\nhad to decide what to do with this.\n\nIt is, to be honest, not well integrated with the rest of bioperl. For example,\nthe trunc() function does not return a LocatableSeq object, as some might have\nthought. Also, the sequence is not a Bio::SeqI, so the location is simply\ninherited from Bio::RangeI and is not stored in a Bio::Location. \n\nThere are all sorts of nasty gotcha's about interactions between coordinate\nsystems when these sort of objects are used. Some mapping now occurs to deal\nwith HSP data, however it can probably be integrated in better and most methods\ndo not implement it correctly yet. Also, several PrimarySeqI methods (subseq(),\ntrunc(), etc.) do not behave as expected and must be used with care.\n\nDue to this, LocatableSeq functionality is to be refactored in a future BioPerl\nrelease. However, for alignment functionality it works adequately for the time\nbeing\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\npackage Bio::LocatableSeq;\nuse strict;\n\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse vars qw($GAP_SYMBOLS $OTHER_SYMBOLS $FRAMESHIFT_SYMBOLS $RESIDUE_SYMBOLS $MATCHPATTERN);\n\n# The following global variables contain symbols used to represent gaps,\n# frameshifts, residues, and other valid symbols. These are set at compile-time;\n# expect scoping errors when using 'local' and resetting $MATCHPATTERN (see\n# LocatableSeq.t)\n\n$GAP_SYMBOLS = '\\-\\.=~';\n$FRAMESHIFT_SYMBOLS = '\\\\\\/';\n$OTHER_SYMBOLS = '\\?';\n$RESIDUE_SYMBOLS = '0-9A-Za-z\\*';\n$MATCHPATTERN = $RESIDUE_SYMBOLS.$GAP_SYMBOLS.$FRAMESHIFT_SYMBOLS.$OTHER_SYMBOLS;\n\nuse base qw(Bio::PrimarySeq Bio::RangeI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$strand, $mapping, $fs, $nse) =\n    $self->_rearrange( [qw(START\n                        END\n                        STRAND\n                        MAPPING\n                        FRAMESHIFTS\n                        FORCE_NSE\n                        )],\n               @args);\n    \n    $mapping ||= [1,1];\n    $self->mapping($mapping);\n    $nse || 0;\n    $self->force_nse($nse);\n    defined $fs    && $self->frameshifts($fs);\n    defined $start && $self->start($start);\n    defined $end   && $self->end($end);\n    defined $strand && $self->strand($strand);\n\n    return $self; # success - we hope!\n}\n\n=head2 start\n\n Title   : start\n Usage   : $obj->start($newval)\n Function: Get/set the 1-based start position of this sequence in the original\n           sequence. '0' means before the original sequence starts.\n Returns : value of start\n Args    : newvalue (optional)\n\n\nsub start{\n    my $self = shift;\n    if( @_ ) {\n        my $value = shift;\n        $self->{'start'} = $value;\n    }\n    return $self->{'start'} if defined $self->{'start'};\n    return 1                if $self->seq;\n    return;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $obj->end($newval)\n Function: Get/set the 1-based end position of this sequence in the original\n           sequence. '0' means before the original sequence starts.\n Returns : value of end\n Args    : newvalue (optional)\n Note    : although this is a get/set, it checks passed values against the\n           calculated end point ( derived from the sequence and based on\n           $GAP_SYMBOLS and possible frameshifts() ).  If there is no match,\n           it will warn and set the proper value.  Probably best used for\n           debugging proper sequence calculations.\n\n\nsub end {\n    my $self = shift;\n    if( @_ ) {\n        my $value = shift;\n        my $st = $self->start;\n        # start of 0 usually means the sequence is all gaps but maps to\n        # other sequences in an alignment\n        if ($self->seq && $st != 0 ) {\n            my $len = $self->_ungapped_len;\n            my $calend = $st + $len - 1;\n            my $id = $self->id || 'unknown';\n            if ($calend != $value) {\n                $self->warn(\"In sequence $id residue count gives end value \".\n                \"$calend.  \\nOverriding value [$value] with value $calend for \".\n                \"Bio::LocatableSeq::end().\\n\".$self->seq);\n                $value = $calend;\n            }\n        }\n        $self->{'end'} = $value;\n    }\n\n    if (defined $self->{'end'}) {\n        return $self->{'end'}\n    } elsif ( my $len = $self->_ungapped_len) {\n        return $len + $self->start - 1;\n    } else {\n        return;\n    }\n}\n\n# changed 08.10.26 to return ungapped length, not the calculated end\n# of the sequence\nsub _ungapped_len {\n    my $self = shift;\n    return unless my $string = $self->seq;\n    my ($map_res, $map_coord) = $self->mapping;\n    my $offset = 0;\n    if (my %data = $self->frameshifts) {\n        map {$offset += $_} values %data;\n    }\n    $string =~ s{[$GAP_SYMBOLS$FRAMESHIFT_SYMBOLS]+}{}g;\n    return CORE::length($string)/($map_res/$map_coord) + $offset/($map_coord/$map_res);\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: return or set the strandedness\n Returns : the value of the strandedness (-1, 0 or 1)\n Args    : the value of the strandedness (-1, 0 or 1)\n\n\nsub strand{\n   my $self = shift;\n   if( @_ ) {\n        my $value = shift;\n        $self->{'strand'} = $value;\n    }\n    return $self->{'strand'};\n}\n\n=head2 mapping\n\n Title   : mapping\n Usage   : $obj->mapping($newval)\n Function: return or set the mapping indices (indicates # symbols/positions in\n           the source string mapping to # of coordinate positions)\n Returns : two-element array (# symbols => # coordinate pos)\n Args    : two elements (# symbols => # coordinate pos); this can also be\n           passed in as an array reference of the two elements (as might be\n           passed upon Bio::LocatableSeq instantiation, for instance).\n\n\nsub mapping {\n    my $self = shift;\n    if( @_ ) {\n        my @mapping = (ref($_[0]) eq 'ARRAY') ? @{$_[0]} : @_;\n        $self->throw(\"Must pass two values (# residues mapped to # positions)\")\n            if @mapping != 2;\n        if ((grep {$_ != 1 && $_ != 3} @mapping) || ($mapping[0] == 3 && $mapping[1] == 3)) {\n            $self->throw(\"Mapping values other than 1 or 3 are not currently supported\")\n        }\n        $self->{'_mapping'} = \\@mapping;\n    }\n    $self->throw('Mapping for LocatableSeq not set') if !exists $self->{'_mapping'};\n    return @{ $self->{'_mapping'} };\n}\n\n=head2 frameshifts\n\n Title   : frameshifts\n Usage   : $obj->frameshifts($newval)\n Function: get/set the frameshift hash, which contains sequence positions as\n           keys and the shift (-2, -1, 1, 2) as the value\n Returns : hash\n Args    : hash or hash reference\n\n\nsub frameshifts {\n    my $self = shift;\n    if( @_ ) {\n        if (ref $_[0] eq 'HASH') {\n            $self->{_frameshifts} = $_[0];\n        } else {\n            # assume this is a full list to be converted to a hash\n            $self->{_frameshifts} = \\%{@_} # coerce into hash ref\n        }\n    }\n    (defined $self->{_frameshifts} && ref $self->{_frameshifts} eq 'HASH') ?\n        return %{$self->{_frameshifts}} : return ();\n}\n\n=head2 get_nse\n\n Title   : get_nse\n Usage   :\n Function: read-only name of form id/start-end\n Example :\n Returns :\n Args    :\n\n\nsub get_nse{\n   my ($self,$char1,$char2) = @_;\n\n   $char1 ||= \"/\";\n   $char2 ||= \"-\";\n   \n   my ($id, $st, $end)  = ($self->id(), $self->start(), $self->end());\n   \n   if ($self->force_nse) {\n        $id  ||= '';\n        $st  ||= 0;\n        $end ||= 0;\n   }\n   \n   $self->throw(\"Attribute id not set\") unless defined($id);\n   $self->throw(\"Attribute start not set\") unless defined($st);\n   $self->throw(\"Attribute end not set\") unless defined($end);\n   \n   #Stockholm Rfam includes version if present so it is optional\n   my $v = $self->version ? '.'.$self->version : ''; \n   return $id . $v. $char1 . $st . $char2 . $end ;\n}\n\n=head2 force_nse\n\n Title   : force_nse\n Usage   : $ls->force_nse()\n Function: Boolean which forces get_nse() to build an NSE, regardless\n           of whether id(), start(), or end() is set\n Returns : Boolean value\n Args    : (optional) Boolean (1 or 0)\n Note    : This will convert any passed value evaluating as TRUE/FALSE to 1/0\n           respectively\n\n\nsub force_nse {\n    my ($self, $flag) = @_;\n    if (defined $flag) {\n        $flag ? (return $self->{'_force_nse'} = 1) : (return $self->{'_force_nse'} = 0);\n    }\n    return $self->{'_force_nse'};\n}\n\n=head2 num_gaps\n\n Title   : num_gaps\n Usage   :$self->num_gaps('.')\n Function:Gets number of gaps in the sequence. The count excludes\n           leading or trailing gap characters.\n\n           Valid bioperl sequence characters are [A-Za-z\\-\\.\\*]. Of\n           these, '.' and '-' are counted as gap characters unless an\n           optional argument specifies one of them.\n\n Returns : number of internal gaps in the sequence.\n Args    : a gap character (optional)\n Status  : Stable\n Note    : replaces no_gaps\n\n\nsub num_gaps {\n    my ($self,$char) = @_;\n    my ($seq, $count) = (undef, 0);\n\n    # default gap characters\n    $char ||= $GAP_SYMBOLS;\n\n    $self->warn(\"I hope you know what you are doing setting gap to [$char]\")\n        unless $char =~ /[$GAP_SYMBOLS]/;\n\n    $seq = $self->seq;\n    return 0 unless $seq; # empty sequence does not have gaps\n\n    $seq =~ s/^([$char]+)//;\n    $seq =~ s/([$char]+)$//;\n    while ( $seq =~ /[$char]+/g ) {\n        $count++;\n    }\n\n    return $count;\n}\n\n\n=head2 column_from_residue_number\n\n Title   : column_from_residue_number\n Usage   : $col = $seq->column_from_residue_number($resnumber)\n Function:\n\n           This function gives the position in the alignment\n           (i.e. column number) of the given residue number in the\n           sequence. For example, for the sequence\n\n         Seq1/91-97 AC..DEF.GH\n\n           column_from_residue_number(94) returns 6.\n\n           An exception is thrown if the residue number would lie\n           outside the length of the aligment\n           (e.g. column_from_residue_number( \"Seq2\", 22 )\n\n Returns : A column number for the position of the\n           given residue in the given sequence (1 = first column)\n Args    : A residue number in the whole sequence (not just that\n           segment of it in the alignment)\n\n\nsub column_from_residue_number {\n    my ($self, $resnumber) = @_;\n\n    $self->throw(\"Residue number has to be a positive integer, not [$resnumber]\")\n    unless $resnumber =~ /^\\d+$/ and $resnumber > 0;\n\n    if ($resnumber >= $self->start() and $resnumber <= $self->end()) {\n\tmy @chunks;\n\tmy $column_incr;\n\tmy $current_column;\n\tmy $current_residue = $self->start - 1;\n\tmy $seq = $self->seq;\n\tmy $strand = $self->strand || 0;\n\n\tif ($strand == -1) {\n#\t    @chunks = reverse $seq =~ m/[^\\.\\-]+|[\\.\\-]+/go;\n\t    @chunks = reverse $seq =~ m/[$RESIDUE_SYMBOLS]+|[$GAP_SYMBOLS]+/go;\n\t    $column_incr = -1;\n\t    $current_column = (CORE::length $seq) + 1;\n\t}\n\telse {\n#\t    @chunks = $seq =~ m/[^\\.\\-]+|[\\.\\-]+/go;\n\t    @chunks = $seq =~ m/[$RESIDUE_SYMBOLS]+|[$GAP_SYMBOLS]+/go;\n\t    $column_incr = 1;\n\t    $current_column = 0;\n\t}\n\n\twhile (my $chunk = shift @chunks) {\n#\t    if ($chunk =~ m|^[\\.\\-]|o) {\n\t    if ($chunk =~ m|^[$GAP_SYMBOLS]|o) {\n\t\t$current_column += $column_incr * CORE::length($chunk);\n\t    }\n\t    else {\n\t\tif ($current_residue + CORE::length($chunk) < $resnumber) {\n\t\t    $current_column += $column_incr * CORE::length($chunk);\n\t\t    $current_residue += CORE::length($chunk);\n\t\t}\n\t\telse {\n\t\t    if ($strand == -1) {\n\t\t\t$current_column -= $resnumber - $current_residue;\n\t\t    }\n\t\t    else {\n\t\t\t$current_column += $resnumber - $current_residue;\n\t\t    }\n\t\t    return $current_column;\n\t\t}\n\t    }\n\t}\n    }\n\n    $self->throw(\"Could not find residue number $resnumber\");\n\n}\n\n=head2 location_from_column\n\n Title   : location_from_column\n Usage   : $loc = $ali->location_from_column($column_number)\n Function:\n\n           This function gives the residue number for a given position\n           in the alignment (i.e. column number) of the given. Gaps\n           complicate this process and force the output to be a\n           L<Bio::Location::Simple> where values can be undefined. \n           For example, for the sequence:\n\n         Seq/91-96 .AC..DEF.G.\n\n           location_from_column( 3 ) position 92\n           location_from_column( 4 ) position 92^93\n           location_from_column( 9 ) position 95^96\n           location_from_column( 1 ) position undef\n\n           An exact position returns a Bio::Location::Simple object\n           where where location_type() returns 'EXACT', if a position\n           is between bases location_type() returns 'IN-BETWEEN'.\n           Column before the first residue returns undef. Note that if\n           the position is after the last residue in the alignment,\n           that there is no guarantee that the original sequence has\n           residues after that position.\n\n           An exception is thrown if the column number is not within\n           the sequence.\n\n Returns : Bio::Location::Simple or undef\n Args    : A column number\n Throws  : If column is not within the sequence\n\nSee L<Bio::Location::Simple> for more.","parameters":[{"label":"$self"},{"label":"$column"}],"label":"location_from_column($self,$column)"},"detail":"($self,$column)","definition":"sub","containerName":"main::","range":{"start":{"line":512,"character":0},"end":{"line":552,"character":9999}},"name":"location_from_column"},{"line":527,"kind":12,"name":"CORE","containerName":"length"},{"containerName":"Location::Simple","name":"Bio","line":533,"kind":12},{"containerName":"Location::Simple","name":"Bio","kind":12,"line":544},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: LocatableSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocatableSeq - A Bio::PrimarySeq object with start/end points on it\nthat can be projected into a MSA or have coordinates relative to\nanother seq.\n\n=head1 SYNOPSIS\n\n    use Bio::LocatableSeq;\n    my $seq = Bio::LocatableSeq->new(-seq => \"CAGT-GGT\",\n                    -id  => \"seq1\",\n                    -start => 1,\n                    -end   => 7);\n\n    # a normal sequence object\n    $locseq->seq();\n    $locseq->id();\n\n    # has start,end points\n    $locseq->start();\n    $locseq->end();\n\n    # inherits off RangeI, so range operations possible\n\n=head1 DESCRIPTION\n\nThe LocatableSeq sequence object was developed mainly because the SimpleAlign\nobject requires this functionality, and in the rewrite of the Sequence object we\nhad to decide what to do with this.\n\nIt is, to be honest, not well integrated with the rest of bioperl. For example,\nthe trunc() function does not return a LocatableSeq object, as some might have\nthought. Also, the sequence is not a Bio::SeqI, so the location is simply\ninherited from Bio::RangeI and is not stored in a Bio::Location. \n\nThere are all sorts of nasty gotcha's about interactions between coordinate\nsystems when these sort of objects are used. Some mapping now occurs to deal\nwith HSP data, however it can probably be integrated in better and most methods\ndo not implement it correctly yet. Also, several PrimarySeqI methods (subseq(),\ntrunc(), etc.) do not behave as expected and must be used with care.\n\nDue to this, LocatableSeq functionality is to be refactored in a future BioPerl\nrelease. However, for alignment functionality it works adequately for the time\nbeing\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\npackage Bio::LocatableSeq;\nuse strict;\n\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse vars qw($GAP_SYMBOLS $OTHER_SYMBOLS $FRAMESHIFT_SYMBOLS $RESIDUE_SYMBOLS $MATCHPATTERN);\n\n# The following global variables contain symbols used to represent gaps,\n# frameshifts, residues, and other valid symbols. These are set at compile-time;\n# expect scoping errors when using 'local' and resetting $MATCHPATTERN (see\n# LocatableSeq.t)\n\n$GAP_SYMBOLS = '\\-\\.=~';\n$FRAMESHIFT_SYMBOLS = '\\\\\\/';\n$OTHER_SYMBOLS = '\\?';\n$RESIDUE_SYMBOLS = '0-9A-Za-z\\*';\n$MATCHPATTERN = $RESIDUE_SYMBOLS.$GAP_SYMBOLS.$FRAMESHIFT_SYMBOLS.$OTHER_SYMBOLS;\n\nuse base qw(Bio::PrimarySeq Bio::RangeI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$strand, $mapping, $fs, $nse) =\n    $self->_rearrange( [qw(START\n                        END\n                        STRAND\n                        MAPPING\n                        FRAMESHIFTS\n                        FORCE_NSE\n                        )],\n               @args);\n    \n    $mapping ||= [1,1];\n    $self->mapping($mapping);\n    $nse || 0;\n    $self->force_nse($nse);\n    defined $fs    && $self->frameshifts($fs);\n    defined $start && $self->start($start);\n    defined $end   && $self->end($end);\n    defined $strand && $self->strand($strand);\n\n    return $self; # success - we hope!\n}\n\n=head2 start\n\n Title   : start\n Usage   : $obj->start($newval)\n Function: Get/set the 1-based start position of this sequence in the original\n           sequence. '0' means before the original sequence starts.\n Returns : value of start\n Args    : newvalue (optional)\n\n\nsub start{\n    my $self = shift;\n    if( @_ ) {\n        my $value = shift;\n        $self->{'start'} = $value;\n    }\n    return $self->{'start'} if defined $self->{'start'};\n    return 1                if $self->seq;\n    return;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $obj->end($newval)\n Function: Get/set the 1-based end position of this sequence in the original\n           sequence. '0' means before the original sequence starts.\n Returns : value of end\n Args    : newvalue (optional)\n Note    : although this is a get/set, it checks passed values against the\n           calculated end point ( derived from the sequence and based on\n           $GAP_SYMBOLS and possible frameshifts() ).  If there is no match,\n           it will warn and set the proper value.  Probably best used for\n           debugging proper sequence calculations.\n\n\nsub end {\n    my $self = shift;\n    if( @_ ) {\n        my $value = shift;\n        my $st = $self->start;\n        # start of 0 usually means the sequence is all gaps but maps to\n        # other sequences in an alignment\n        if ($self->seq && $st != 0 ) {\n            my $len = $self->_ungapped_len;\n            my $calend = $st + $len - 1;\n            my $id = $self->id || 'unknown';\n            if ($calend != $value) {\n                $self->warn(\"In sequence $id residue count gives end value \".\n                \"$calend.  \\nOverriding value [$value] with value $calend for \".\n                \"Bio::LocatableSeq::end().\\n\".$self->seq);\n                $value = $calend;\n            }\n        }\n        $self->{'end'} = $value;\n    }\n\n    if (defined $self->{'end'}) {\n        return $self->{'end'}\n    } elsif ( my $len = $self->_ungapped_len) {\n        return $len + $self->start - 1;\n    } else {\n        return;\n    }\n}\n\n# changed 08.10.26 to return ungapped length, not the calculated end\n# of the sequence\nsub _ungapped_len {\n    my $self = shift;\n    return unless my $string = $self->seq;\n    my ($map_res, $map_coord) = $self->mapping;\n    my $offset = 0;\n    if (my %data = $self->frameshifts) {\n        map {$offset += $_} values %data;\n    }\n    $string =~ s{[$GAP_SYMBOLS$FRAMESHIFT_SYMBOLS]+}{}g;\n    return CORE::length($string)/($map_res/$map_coord) + $offset/($map_coord/$map_res);\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: return or set the strandedness\n Returns : the value of the strandedness (-1, 0 or 1)\n Args    : the value of the strandedness (-1, 0 or 1)\n\n\nsub strand{\n   my $self = shift;\n   if( @_ ) {\n        my $value = shift;\n        $self->{'strand'} = $value;\n    }\n    return $self->{'strand'};\n}\n\n=head2 mapping\n\n Title   : mapping\n Usage   : $obj->mapping($newval)\n Function: return or set the mapping indices (indicates # symbols/positions in\n           the source string mapping to # of coordinate positions)\n Returns : two-element array (# symbols => # coordinate pos)\n Args    : two elements (# symbols => # coordinate pos); this can also be\n           passed in as an array reference of the two elements (as might be\n           passed upon Bio::LocatableSeq instantiation, for instance).\n\n\nsub mapping {\n    my $self = shift;\n    if( @_ ) {\n        my @mapping = (ref($_[0]) eq 'ARRAY') ? @{$_[0]} : @_;\n        $self->throw(\"Must pass two values (# residues mapped to # positions)\")\n            if @mapping != 2;\n        if ((grep {$_ != 1 && $_ != 3} @mapping) || ($mapping[0] == 3 && $mapping[1] == 3)) {\n            $self->throw(\"Mapping values other than 1 or 3 are not currently supported\")\n        }\n        $self->{'_mapping'} = \\@mapping;\n    }\n    $self->throw('Mapping for LocatableSeq not set') if !exists $self->{'_mapping'};\n    return @{ $self->{'_mapping'} };\n}\n\n=head2 frameshifts\n\n Title   : frameshifts\n Usage   : $obj->frameshifts($newval)\n Function: get/set the frameshift hash, which contains sequence positions as\n           keys and the shift (-2, -1, 1, 2) as the value\n Returns : hash\n Args    : hash or hash reference\n\n\nsub frameshifts {\n    my $self = shift;\n    if( @_ ) {\n        if (ref $_[0] eq 'HASH') {\n            $self->{_frameshifts} = $_[0];\n        } else {\n            # assume this is a full list to be converted to a hash\n            $self->{_frameshifts} = \\%{@_} # coerce into hash ref\n        }\n    }\n    (defined $self->{_frameshifts} && ref $self->{_frameshifts} eq 'HASH') ?\n        return %{$self->{_frameshifts}} : return ();\n}\n\n=head2 get_nse\n\n Title   : get_nse\n Usage   :\n Function: read-only name of form id/start-end\n Example :\n Returns :\n Args    :\n\n\nsub get_nse{\n   my ($self,$char1,$char2) = @_;\n\n   $char1 ||= \"/\";\n   $char2 ||= \"-\";\n   \n   my ($id, $st, $end)  = ($self->id(), $self->start(), $self->end());\n   \n   if ($self->force_nse) {\n        $id  ||= '';\n        $st  ||= 0;\n        $end ||= 0;\n   }\n   \n   $self->throw(\"Attribute id not set\") unless defined($id);\n   $self->throw(\"Attribute start not set\") unless defined($st);\n   $self->throw(\"Attribute end not set\") unless defined($end);\n   \n   #Stockholm Rfam includes version if present so it is optional\n   my $v = $self->version ? '.'.$self->version : ''; \n   return $id . $v. $char1 . $st . $char2 . $end ;\n}\n\n=head2 force_nse\n\n Title   : force_nse\n Usage   : $ls->force_nse()\n Function: Boolean which forces get_nse() to build an NSE, regardless\n           of whether id(), start(), or end() is set\n Returns : Boolean value\n Args    : (optional) Boolean (1 or 0)\n Note    : This will convert any passed value evaluating as TRUE/FALSE to 1/0\n           respectively\n\n\nsub force_nse {\n    my ($self, $flag) = @_;\n    if (defined $flag) {\n        $flag ? (return $self->{'_force_nse'} = 1) : (return $self->{'_force_nse'} = 0);\n    }\n    return $self->{'_force_nse'};\n}\n\n=head2 num_gaps\n\n Title   : num_gaps\n Usage   :$self->num_gaps('.')\n Function:Gets number of gaps in the sequence. The count excludes\n           leading or trailing gap characters.\n\n           Valid bioperl sequence characters are [A-Za-z\\-\\.\\*]. Of\n           these, '.' and '-' are counted as gap characters unless an\n           optional argument specifies one of them.\n\n Returns : number of internal gaps in the sequence.\n Args    : a gap character (optional)\n Status  : Stable\n Note    : replaces no_gaps\n\n\nsub num_gaps {\n    my ($self,$char) = @_;\n    my ($seq, $count) = (undef, 0);\n\n    # default gap characters\n    $char ||= $GAP_SYMBOLS;\n\n    $self->warn(\"I hope you know what you are doing setting gap to [$char]\")\n        unless $char =~ /[$GAP_SYMBOLS]/;\n\n    $seq = $self->seq;\n    return 0 unless $seq; # empty sequence does not have gaps\n\n    $seq =~ s/^([$char]+)//;\n    $seq =~ s/([$char]+)$//;\n    while ( $seq =~ /[$char]+/g ) {\n        $count++;\n    }\n\n    return $count;\n}\n\n\n=head2 column_from_residue_number\n\n Title   : column_from_residue_number\n Usage   : $col = $seq->column_from_residue_number($resnumber)\n Function:\n\n           This function gives the position in the alignment\n           (i.e. column number) of the given residue number in the\n           sequence. For example, for the sequence\n\n         Seq1/91-97 AC..DEF.GH\n\n           column_from_residue_number(94) returns 6.\n\n           An exception is thrown if the residue number would lie\n           outside the length of the aligment\n           (e.g. column_from_residue_number( \"Seq2\", 22 )\n\n Returns : A column number for the position of the\n           given residue in the given sequence (1 = first column)\n Args    : A residue number in the whole sequence (not just that\n           segment of it in the alignment)\n\n\nsub column_from_residue_number {\n    my ($self, $resnumber) = @_;\n\n    $self->throw(\"Residue number has to be a positive integer, not [$resnumber]\")\n    unless $resnumber =~ /^\\d+$/ and $resnumber > 0;\n\n    if ($resnumber >= $self->start() and $resnumber <= $self->end()) {\n\tmy @chunks;\n\tmy $column_incr;\n\tmy $current_column;\n\tmy $current_residue = $self->start - 1;\n\tmy $seq = $self->seq;\n\tmy $strand = $self->strand || 0;\n\n\tif ($strand == -1) {\n#\t    @chunks = reverse $seq =~ m/[^\\.\\-]+|[\\.\\-]+/go;\n\t    @chunks = reverse $seq =~ m/[$RESIDUE_SYMBOLS]+|[$GAP_SYMBOLS]+/go;\n\t    $column_incr = -1;\n\t    $current_column = (CORE::length $seq) + 1;\n\t}\n\telse {\n#\t    @chunks = $seq =~ m/[^\\.\\-]+|[\\.\\-]+/go;\n\t    @chunks = $seq =~ m/[$RESIDUE_SYMBOLS]+|[$GAP_SYMBOLS]+/go;\n\t    $column_incr = 1;\n\t    $current_column = 0;\n\t}\n\n\twhile (my $chunk = shift @chunks) {\n#\t    if ($chunk =~ m|^[\\.\\-]|o) {\n\t    if ($chunk =~ m|^[$GAP_SYMBOLS]|o) {\n\t\t$current_column += $column_incr * CORE::length($chunk);\n\t    }\n\t    else {\n\t\tif ($current_residue + CORE::length($chunk) < $resnumber) {\n\t\t    $current_column += $column_incr * CORE::length($chunk);\n\t\t    $current_residue += CORE::length($chunk);\n\t\t}\n\t\telse {\n\t\t    if ($strand == -1) {\n\t\t\t$current_column -= $resnumber - $current_residue;\n\t\t    }\n\t\t    else {\n\t\t\t$current_column += $resnumber - $current_residue;\n\t\t    }\n\t\t    return $current_column;\n\t\t}\n\t    }\n\t}\n    }\n\n    $self->throw(\"Could not find residue number $resnumber\");\n\n}\n\n=head2 location_from_column\n\n Title   : location_from_column\n Usage   : $loc = $ali->location_from_column($column_number)\n Function:\n\n           This function gives the residue number for a given position\n           in the alignment (i.e. column number) of the given. Gaps\n           complicate this process and force the output to be a\n           L<Bio::Location::Simple> where values can be undefined. \n           For example, for the sequence:\n\n         Seq/91-96 .AC..DEF.G.\n\n           location_from_column( 3 ) position 92\n           location_from_column( 4 ) position 92^93\n           location_from_column( 9 ) position 95^96\n           location_from_column( 1 ) position undef\n\n           An exact position returns a Bio::Location::Simple object\n           where where location_type() returns 'EXACT', if a position\n           is between bases location_type() returns 'IN-BETWEEN'.\n           Column before the first residue returns undef. Note that if\n           the position is after the last residue in the alignment,\n           that there is no guarantee that the original sequence has\n           residues after that position.\n\n           An exception is thrown if the column number is not within\n           the sequence.\n\n Returns : Bio::Location::Simple or undef\n Args    : A column number\n Throws  : If column is not within the sequence\n\nSee L<Bio::Location::Simple> for more.\n\n\nsub location_from_column {\n    my ($self, $column) = @_;\n\n    $self->throw(\"Column number has to be a positive integer, not [$column]\")\n    unless $column =~ /^\\d+$/ and $column > 0;\n    $self->throw(\"Column number [$column] is larger than\".\n         \" sequence length [\". $self->length. \"]\")\n    unless $column <= $self->length;\n\n    my ($loc);\n    my $s = $self->subseq(1,$column);\n    $s =~ s/[^a-zA-Z\\*]//g;\n\n    my $pos = CORE::length $s;\n\n    my $start = $self->start || 0 ;\n    my $strand = $self->strand() || 1;\n    my $relative_pos = ($strand == -1)\n        ? ($self->end - $pos + 1)\n    : ($pos + $start - 1);\n    if ($self->subseq($column, $column) =~ /[a-zA-Z\\*]/ ) {\n    $loc = Bio::Location::Simple->new\n        (-start  => $relative_pos,\n         -end    => $relative_pos,\n         -strand => 1,\n         );\n    } elsif ($pos == 0 and $self->start == 1) {\n    } else {\n      my ($start,$end) = ($relative_pos, $relative_pos + $strand);\n      if ($strand == -1) {\n    ($start,$end) = ($end,$start);\n      }\n    $loc = Bio::Location::Simple->new\n        (-start         => $start,\n         -end           => $end,\n         -strand        => 1,\n         -location_type => 'IN-BETWEEN'\n         );\n    }\n    return $loc;\n}\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::LocatableSeq object which\n           has the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n Returns : A new Bio::LocatableSeq object\n Args    : none","label":"revcom($self)"},"detail":"($self)","kind":12,"children":[{"localvar":"my","containerName":"revcom","name":"$self","definition":"my","line":569,"kind":13},{"containerName":"revcom","name":"$self","kind":13,"line":572},{"line":572,"kind":12,"name":"mapping","containerName":"revcom"},{"containerName":"revcom","name":"$self","line":573,"kind":13},{"line":573,"kind":12,"name":"warn","containerName":"revcom"},{"line":576,"kind":13,"localvar":"my","containerName":"revcom","definition":"my","name":"$new"},{"containerName":"revcom","name":"$self","line":576,"kind":13},{"kind":13,"line":577,"name":"$new","containerName":"revcom"},{"kind":12,"line":577,"containerName":"revcom","name":"strand"},{"kind":13,"line":577,"name":"$self","containerName":"revcom"},{"line":577,"kind":12,"name":"strand","containerName":"revcom"},{"kind":13,"line":577,"containerName":"revcom","name":"$self"},{"containerName":"revcom","name":"strand","kind":12,"line":577},{"kind":13,"line":578,"containerName":"revcom","name":"$new"},{"containerName":"revcom","name":"start","line":578,"kind":12},{"containerName":"revcom","name":"$self","kind":13,"line":578},{"kind":12,"line":578,"name":"start","containerName":"revcom"},{"line":578,"kind":13,"containerName":"revcom","name":"$self"},{"containerName":"revcom","name":"start","kind":12,"line":578},{"containerName":"revcom","name":"$new","line":579,"kind":13},{"containerName":"revcom","name":"end","line":579,"kind":12},{"containerName":"revcom","name":"$self","kind":13,"line":579},{"line":579,"kind":12,"containerName":"revcom","name":"end"},{"name":"$self","containerName":"revcom","kind":13,"line":579},{"name":"end","containerName":"revcom","kind":12,"line":579},{"containerName":"revcom","name":"$new","kind":13,"line":580}],"line":568,"name":"revcom","range":{"end":{"character":9999,"line":581},"start":{"line":568,"character":0}}},{"kind":12,"line":577,"name":"SUPER","containerName":"revcom"},{"signature":{"parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}],"documentation":"1;\n# $Id: LocatableSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocatableSeq - A Bio::PrimarySeq object with start/end points on it\nthat can be projected into a MSA or have coordinates relative to\nanother seq.\n\n=head1 SYNOPSIS\n\n    use Bio::LocatableSeq;\n    my $seq = Bio::LocatableSeq->new(-seq => \"CAGT-GGT\",\n                    -id  => \"seq1\",\n                    -start => 1,\n                    -end   => 7);\n\n    # a normal sequence object\n    $locseq->seq();\n    $locseq->id();\n\n    # has start,end points\n    $locseq->start();\n    $locseq->end();\n\n    # inherits off RangeI, so range operations possible\n\n=head1 DESCRIPTION\n\nThe LocatableSeq sequence object was developed mainly because the SimpleAlign\nobject requires this functionality, and in the rewrite of the Sequence object we\nhad to decide what to do with this.\n\nIt is, to be honest, not well integrated with the rest of bioperl. For example,\nthe trunc() function does not return a LocatableSeq object, as some might have\nthought. Also, the sequence is not a Bio::SeqI, so the location is simply\ninherited from Bio::RangeI and is not stored in a Bio::Location. \n\nThere are all sorts of nasty gotcha's about interactions between coordinate\nsystems when these sort of objects are used. Some mapping now occurs to deal\nwith HSP data, however it can probably be integrated in better and most methods\ndo not implement it correctly yet. Also, several PrimarySeqI methods (subseq(),\ntrunc(), etc.) do not behave as expected and must be used with care.\n\nDue to this, LocatableSeq functionality is to be refactored in a future BioPerl\nrelease. However, for alignment functionality it works adequately for the time\nbeing\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\npackage Bio::LocatableSeq;\nuse strict;\n\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse vars qw($GAP_SYMBOLS $OTHER_SYMBOLS $FRAMESHIFT_SYMBOLS $RESIDUE_SYMBOLS $MATCHPATTERN);\n\n# The following global variables contain symbols used to represent gaps,\n# frameshifts, residues, and other valid symbols. These are set at compile-time;\n# expect scoping errors when using 'local' and resetting $MATCHPATTERN (see\n# LocatableSeq.t)\n\n$GAP_SYMBOLS = '\\-\\.=~';\n$FRAMESHIFT_SYMBOLS = '\\\\\\/';\n$OTHER_SYMBOLS = '\\?';\n$RESIDUE_SYMBOLS = '0-9A-Za-z\\*';\n$MATCHPATTERN = $RESIDUE_SYMBOLS.$GAP_SYMBOLS.$FRAMESHIFT_SYMBOLS.$OTHER_SYMBOLS;\n\nuse base qw(Bio::PrimarySeq Bio::RangeI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$strand, $mapping, $fs, $nse) =\n    $self->_rearrange( [qw(START\n                        END\n                        STRAND\n                        MAPPING\n                        FRAMESHIFTS\n                        FORCE_NSE\n                        )],\n               @args);\n    \n    $mapping ||= [1,1];\n    $self->mapping($mapping);\n    $nse || 0;\n    $self->force_nse($nse);\n    defined $fs    && $self->frameshifts($fs);\n    defined $start && $self->start($start);\n    defined $end   && $self->end($end);\n    defined $strand && $self->strand($strand);\n\n    return $self; # success - we hope!\n}\n\n=head2 start\n\n Title   : start\n Usage   : $obj->start($newval)\n Function: Get/set the 1-based start position of this sequence in the original\n           sequence. '0' means before the original sequence starts.\n Returns : value of start\n Args    : newvalue (optional)\n\n\nsub start{\n    my $self = shift;\n    if( @_ ) {\n        my $value = shift;\n        $self->{'start'} = $value;\n    }\n    return $self->{'start'} if defined $self->{'start'};\n    return 1                if $self->seq;\n    return;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $obj->end($newval)\n Function: Get/set the 1-based end position of this sequence in the original\n           sequence. '0' means before the original sequence starts.\n Returns : value of end\n Args    : newvalue (optional)\n Note    : although this is a get/set, it checks passed values against the\n           calculated end point ( derived from the sequence and based on\n           $GAP_SYMBOLS and possible frameshifts() ).  If there is no match,\n           it will warn and set the proper value.  Probably best used for\n           debugging proper sequence calculations.\n\n\nsub end {\n    my $self = shift;\n    if( @_ ) {\n        my $value = shift;\n        my $st = $self->start;\n        # start of 0 usually means the sequence is all gaps but maps to\n        # other sequences in an alignment\n        if ($self->seq && $st != 0 ) {\n            my $len = $self->_ungapped_len;\n            my $calend = $st + $len - 1;\n            my $id = $self->id || 'unknown';\n            if ($calend != $value) {\n                $self->warn(\"In sequence $id residue count gives end value \".\n                \"$calend.  \\nOverriding value [$value] with value $calend for \".\n                \"Bio::LocatableSeq::end().\\n\".$self->seq);\n                $value = $calend;\n            }\n        }\n        $self->{'end'} = $value;\n    }\n\n    if (defined $self->{'end'}) {\n        return $self->{'end'}\n    } elsif ( my $len = $self->_ungapped_len) {\n        return $len + $self->start - 1;\n    } else {\n        return;\n    }\n}\n\n# changed 08.10.26 to return ungapped length, not the calculated end\n# of the sequence\nsub _ungapped_len {\n    my $self = shift;\n    return unless my $string = $self->seq;\n    my ($map_res, $map_coord) = $self->mapping;\n    my $offset = 0;\n    if (my %data = $self->frameshifts) {\n        map {$offset += $_} values %data;\n    }\n    $string =~ s{[$GAP_SYMBOLS$FRAMESHIFT_SYMBOLS]+}{}g;\n    return CORE::length($string)/($map_res/$map_coord) + $offset/($map_coord/$map_res);\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: return or set the strandedness\n Returns : the value of the strandedness (-1, 0 or 1)\n Args    : the value of the strandedness (-1, 0 or 1)\n\n\nsub strand{\n   my $self = shift;\n   if( @_ ) {\n        my $value = shift;\n        $self->{'strand'} = $value;\n    }\n    return $self->{'strand'};\n}\n\n=head2 mapping\n\n Title   : mapping\n Usage   : $obj->mapping($newval)\n Function: return or set the mapping indices (indicates # symbols/positions in\n           the source string mapping to # of coordinate positions)\n Returns : two-element array (# symbols => # coordinate pos)\n Args    : two elements (# symbols => # coordinate pos); this can also be\n           passed in as an array reference of the two elements (as might be\n           passed upon Bio::LocatableSeq instantiation, for instance).\n\n\nsub mapping {\n    my $self = shift;\n    if( @_ ) {\n        my @mapping = (ref($_[0]) eq 'ARRAY') ? @{$_[0]} : @_;\n        $self->throw(\"Must pass two values (# residues mapped to # positions)\")\n            if @mapping != 2;\n        if ((grep {$_ != 1 && $_ != 3} @mapping) || ($mapping[0] == 3 && $mapping[1] == 3)) {\n            $self->throw(\"Mapping values other than 1 or 3 are not currently supported\")\n        }\n        $self->{'_mapping'} = \\@mapping;\n    }\n    $self->throw('Mapping for LocatableSeq not set') if !exists $self->{'_mapping'};\n    return @{ $self->{'_mapping'} };\n}\n\n=head2 frameshifts\n\n Title   : frameshifts\n Usage   : $obj->frameshifts($newval)\n Function: get/set the frameshift hash, which contains sequence positions as\n           keys and the shift (-2, -1, 1, 2) as the value\n Returns : hash\n Args    : hash or hash reference\n\n\nsub frameshifts {\n    my $self = shift;\n    if( @_ ) {\n        if (ref $_[0] eq 'HASH') {\n            $self->{_frameshifts} = $_[0];\n        } else {\n            # assume this is a full list to be converted to a hash\n            $self->{_frameshifts} = \\%{@_} # coerce into hash ref\n        }\n    }\n    (defined $self->{_frameshifts} && ref $self->{_frameshifts} eq 'HASH') ?\n        return %{$self->{_frameshifts}} : return ();\n}\n\n=head2 get_nse\n\n Title   : get_nse\n Usage   :\n Function: read-only name of form id/start-end\n Example :\n Returns :\n Args    :\n\n\nsub get_nse{\n   my ($self,$char1,$char2) = @_;\n\n   $char1 ||= \"/\";\n   $char2 ||= \"-\";\n   \n   my ($id, $st, $end)  = ($self->id(), $self->start(), $self->end());\n   \n   if ($self->force_nse) {\n        $id  ||= '';\n        $st  ||= 0;\n        $end ||= 0;\n   }\n   \n   $self->throw(\"Attribute id not set\") unless defined($id);\n   $self->throw(\"Attribute start not set\") unless defined($st);\n   $self->throw(\"Attribute end not set\") unless defined($end);\n   \n   #Stockholm Rfam includes version if present so it is optional\n   my $v = $self->version ? '.'.$self->version : ''; \n   return $id . $v. $char1 . $st . $char2 . $end ;\n}\n\n=head2 force_nse\n\n Title   : force_nse\n Usage   : $ls->force_nse()\n Function: Boolean which forces get_nse() to build an NSE, regardless\n           of whether id(), start(), or end() is set\n Returns : Boolean value\n Args    : (optional) Boolean (1 or 0)\n Note    : This will convert any passed value evaluating as TRUE/FALSE to 1/0\n           respectively\n\n\nsub force_nse {\n    my ($self, $flag) = @_;\n    if (defined $flag) {\n        $flag ? (return $self->{'_force_nse'} = 1) : (return $self->{'_force_nse'} = 0);\n    }\n    return $self->{'_force_nse'};\n}\n\n=head2 num_gaps\n\n Title   : num_gaps\n Usage   :$self->num_gaps('.')\n Function:Gets number of gaps in the sequence. The count excludes\n           leading or trailing gap characters.\n\n           Valid bioperl sequence characters are [A-Za-z\\-\\.\\*]. Of\n           these, '.' and '-' are counted as gap characters unless an\n           optional argument specifies one of them.\n\n Returns : number of internal gaps in the sequence.\n Args    : a gap character (optional)\n Status  : Stable\n Note    : replaces no_gaps\n\n\nsub num_gaps {\n    my ($self,$char) = @_;\n    my ($seq, $count) = (undef, 0);\n\n    # default gap characters\n    $char ||= $GAP_SYMBOLS;\n\n    $self->warn(\"I hope you know what you are doing setting gap to [$char]\")\n        unless $char =~ /[$GAP_SYMBOLS]/;\n\n    $seq = $self->seq;\n    return 0 unless $seq; # empty sequence does not have gaps\n\n    $seq =~ s/^([$char]+)//;\n    $seq =~ s/([$char]+)$//;\n    while ( $seq =~ /[$char]+/g ) {\n        $count++;\n    }\n\n    return $count;\n}\n\n\n=head2 column_from_residue_number\n\n Title   : column_from_residue_number\n Usage   : $col = $seq->column_from_residue_number($resnumber)\n Function:\n\n           This function gives the position in the alignment\n           (i.e. column number) of the given residue number in the\n           sequence. For example, for the sequence\n\n         Seq1/91-97 AC..DEF.GH\n\n           column_from_residue_number(94) returns 6.\n\n           An exception is thrown if the residue number would lie\n           outside the length of the aligment\n           (e.g. column_from_residue_number( \"Seq2\", 22 )\n\n Returns : A column number for the position of the\n           given residue in the given sequence (1 = first column)\n Args    : A residue number in the whole sequence (not just that\n           segment of it in the alignment)\n\n\nsub column_from_residue_number {\n    my ($self, $resnumber) = @_;\n\n    $self->throw(\"Residue number has to be a positive integer, not [$resnumber]\")\n    unless $resnumber =~ /^\\d+$/ and $resnumber > 0;\n\n    if ($resnumber >= $self->start() and $resnumber <= $self->end()) {\n\tmy @chunks;\n\tmy $column_incr;\n\tmy $current_column;\n\tmy $current_residue = $self->start - 1;\n\tmy $seq = $self->seq;\n\tmy $strand = $self->strand || 0;\n\n\tif ($strand == -1) {\n#\t    @chunks = reverse $seq =~ m/[^\\.\\-]+|[\\.\\-]+/go;\n\t    @chunks = reverse $seq =~ m/[$RESIDUE_SYMBOLS]+|[$GAP_SYMBOLS]+/go;\n\t    $column_incr = -1;\n\t    $current_column = (CORE::length $seq) + 1;\n\t}\n\telse {\n#\t    @chunks = $seq =~ m/[^\\.\\-]+|[\\.\\-]+/go;\n\t    @chunks = $seq =~ m/[$RESIDUE_SYMBOLS]+|[$GAP_SYMBOLS]+/go;\n\t    $column_incr = 1;\n\t    $current_column = 0;\n\t}\n\n\twhile (my $chunk = shift @chunks) {\n#\t    if ($chunk =~ m|^[\\.\\-]|o) {\n\t    if ($chunk =~ m|^[$GAP_SYMBOLS]|o) {\n\t\t$current_column += $column_incr * CORE::length($chunk);\n\t    }\n\t    else {\n\t\tif ($current_residue + CORE::length($chunk) < $resnumber) {\n\t\t    $current_column += $column_incr * CORE::length($chunk);\n\t\t    $current_residue += CORE::length($chunk);\n\t\t}\n\t\telse {\n\t\t    if ($strand == -1) {\n\t\t\t$current_column -= $resnumber - $current_residue;\n\t\t    }\n\t\t    else {\n\t\t\t$current_column += $resnumber - $current_residue;\n\t\t    }\n\t\t    return $current_column;\n\t\t}\n\t    }\n\t}\n    }\n\n    $self->throw(\"Could not find residue number $resnumber\");\n\n}\n\n=head2 location_from_column\n\n Title   : location_from_column\n Usage   : $loc = $ali->location_from_column($column_number)\n Function:\n\n           This function gives the residue number for a given position\n           in the alignment (i.e. column number) of the given. Gaps\n           complicate this process and force the output to be a\n           L<Bio::Location::Simple> where values can be undefined. \n           For example, for the sequence:\n\n         Seq/91-96 .AC..DEF.G.\n\n           location_from_column( 3 ) position 92\n           location_from_column( 4 ) position 92^93\n           location_from_column( 9 ) position 95^96\n           location_from_column( 1 ) position undef\n\n           An exact position returns a Bio::Location::Simple object\n           where where location_type() returns 'EXACT', if a position\n           is between bases location_type() returns 'IN-BETWEEN'.\n           Column before the first residue returns undef. Note that if\n           the position is after the last residue in the alignment,\n           that there is no guarantee that the original sequence has\n           residues after that position.\n\n           An exception is thrown if the column number is not within\n           the sequence.\n\n Returns : Bio::Location::Simple or undef\n Args    : A column number\n Throws  : If column is not within the sequence\n\nSee L<Bio::Location::Simple> for more.\n\n\nsub location_from_column {\n    my ($self, $column) = @_;\n\n    $self->throw(\"Column number has to be a positive integer, not [$column]\")\n    unless $column =~ /^\\d+$/ and $column > 0;\n    $self->throw(\"Column number [$column] is larger than\".\n         \" sequence length [\". $self->length. \"]\")\n    unless $column <= $self->length;\n\n    my ($loc);\n    my $s = $self->subseq(1,$column);\n    $s =~ s/[^a-zA-Z\\*]//g;\n\n    my $pos = CORE::length $s;\n\n    my $start = $self->start || 0 ;\n    my $strand = $self->strand() || 1;\n    my $relative_pos = ($strand == -1)\n        ? ($self->end - $pos + 1)\n    : ($pos + $start - 1);\n    if ($self->subseq($column, $column) =~ /[a-zA-Z\\*]/ ) {\n    $loc = Bio::Location::Simple->new\n        (-start  => $relative_pos,\n         -end    => $relative_pos,\n         -strand => 1,\n         );\n    } elsif ($pos == 0 and $self->start == 1) {\n    } else {\n      my ($start,$end) = ($relative_pos, $relative_pos + $strand);\n      if ($strand == -1) {\n    ($start,$end) = ($end,$start);\n      }\n    $loc = Bio::Location::Simple->new\n        (-start         => $start,\n         -end           => $end,\n         -strand        => 1,\n         -location_type => 'IN-BETWEEN'\n         );\n    }\n    return $loc;\n}\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::LocatableSeq object which\n           has the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n Returns : A new Bio::LocatableSeq object\n Args    : none\n\n\nsub revcom {\n    my ($self) = @_;\n    # since we don't know whether sequences without 1 => 1 correlation can be\n    # revcom'd, kick back\n    if (grep {$_ != 1} $self->mapping) {\n        $self->warn('revcom() not supported for sequences with mapped values of > 1');\n        return;\n    }\n    my $new = $self->SUPER::revcom;\n    $new->strand($self->strand * -1) if $self->strand;\n    $new->start($self->start) if $self->start;\n    $new->end($self->end) if $self->end;\n    return $new;\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::PrimarySeqI implementing object\n Args    : Two integers denoting first and last columns of the\n           sequence to be included into sub-sequence.","label":"trunc($self,$start,$end)"},"detail":"($self,$start,$end)","definition":"sub","containerName":"main::","children":[{"containerName":"trunc","definition":"my","name":"$self","localvar":"my","kind":13,"line":598},{"name":"$start","containerName":"trunc","kind":13,"line":598},{"line":598,"kind":13,"containerName":"trunc","name":"$end"},{"line":599,"kind":13,"localvar":"my","definition":"my","name":"$new","containerName":"trunc"},{"containerName":"trunc","name":"$self","line":599,"kind":13},{"containerName":"trunc","name":"$start","line":599,"kind":13},{"name":"$end","containerName":"trunc","line":599,"kind":13},{"name":"$new","containerName":"trunc","line":600,"kind":13},{"name":"strand","containerName":"trunc","line":600,"kind":12},{"name":"$self","containerName":"trunc","kind":13,"line":600},{"kind":12,"line":600,"containerName":"trunc","name":"strand"},{"kind":13,"line":603,"name":"$start","containerName":"trunc"},{"name":"$end","containerName":"trunc","line":603,"kind":13},{"name":"$self","containerName":"trunc","line":603,"kind":13},{"containerName":"trunc","name":"strand","kind":12,"line":603},{"name":"$start","containerName":"trunc","line":605,"kind":13},{"containerName":"trunc","name":"$self","line":605,"kind":13},{"containerName":"trunc","name":"location_from_column","kind":12,"line":605},{"kind":13,"line":605,"name":"$start","containerName":"trunc"},{"kind":13,"line":606,"containerName":"trunc","name":"$start"},{"containerName":"trunc","name":"$start","kind":13,"line":606},{"containerName":"trunc","name":"$start","line":606,"kind":13},{"containerName":"trunc","name":"end","kind":12,"line":606},{"kind":13,"line":606,"name":"$start","containerName":"trunc"},{"containerName":"trunc","name":"$new","kind":13,"line":607},{"line":607,"kind":12,"name":"start","containerName":"trunc"},{"line":607,"kind":13,"name":"$start","containerName":"trunc"},{"name":"$start","containerName":"trunc","line":607,"kind":13},{"line":609,"kind":13,"name":"$new","containerName":"trunc"}],"line":597,"kind":12,"range":{"start":{"line":597,"character":0},"end":{"line":610,"character":9999}},"name":"trunc"},{"line":599,"kind":12,"name":"SUPER","containerName":"trunc"},{"name":"validate_seq","range":{"end":{"character":9999,"line":647},"start":{"character":0,"line":635}},"containerName":"main::","definition":"sub","detail":"($self,$seqstr)","signature":{"label":"validate_seq($self,$seqstr)","documentation":"1;\n# $Id: LocatableSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::LocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LocatableSeq - A Bio::PrimarySeq object with start/end points on it\nthat can be projected into a MSA or have coordinates relative to\nanother seq.\n\n=head1 SYNOPSIS\n\n    use Bio::LocatableSeq;\n    my $seq = Bio::LocatableSeq->new(-seq => \"CAGT-GGT\",\n                    -id  => \"seq1\",\n                    -start => 1,\n                    -end   => 7);\n\n    # a normal sequence object\n    $locseq->seq();\n    $locseq->id();\n\n    # has start,end points\n    $locseq->start();\n    $locseq->end();\n\n    # inherits off RangeI, so range operations possible\n\n=head1 DESCRIPTION\n\nThe LocatableSeq sequence object was developed mainly because the SimpleAlign\nobject requires this functionality, and in the rewrite of the Sequence object we\nhad to decide what to do with this.\n\nIt is, to be honest, not well integrated with the rest of bioperl. For example,\nthe trunc() function does not return a LocatableSeq object, as some might have\nthought. Also, the sequence is not a Bio::SeqI, so the location is simply\ninherited from Bio::RangeI and is not stored in a Bio::Location. \n\nThere are all sorts of nasty gotcha's about interactions between coordinate\nsystems when these sort of objects are used. Some mapping now occurs to deal\nwith HSP data, however it can probably be integrated in better and most methods\ndo not implement it correctly yet. Also, several PrimarySeqI methods (subseq(),\ntrunc(), etc.) do not behave as expected and must be used with care.\n\nDue to this, LocatableSeq functionality is to be refactored in a future BioPerl\nrelease. However, for alignment functionality it works adequately for the time\nbeing\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\npackage Bio::LocatableSeq;\nuse strict;\n\nuse Bio::Location::Simple;\nuse Bio::Location::Fuzzy;\nuse vars qw($GAP_SYMBOLS $OTHER_SYMBOLS $FRAMESHIFT_SYMBOLS $RESIDUE_SYMBOLS $MATCHPATTERN);\n\n# The following global variables contain symbols used to represent gaps,\n# frameshifts, residues, and other valid symbols. These are set at compile-time;\n# expect scoping errors when using 'local' and resetting $MATCHPATTERN (see\n# LocatableSeq.t)\n\n$GAP_SYMBOLS = '\\-\\.=~';\n$FRAMESHIFT_SYMBOLS = '\\\\\\/';\n$OTHER_SYMBOLS = '\\?';\n$RESIDUE_SYMBOLS = '0-9A-Za-z\\*';\n$MATCHPATTERN = $RESIDUE_SYMBOLS.$GAP_SYMBOLS.$FRAMESHIFT_SYMBOLS.$OTHER_SYMBOLS;\n\nuse base qw(Bio::PrimarySeq Bio::RangeI);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$strand, $mapping, $fs, $nse) =\n    $self->_rearrange( [qw(START\n                        END\n                        STRAND\n                        MAPPING\n                        FRAMESHIFTS\n                        FORCE_NSE\n                        )],\n               @args);\n    \n    $mapping ||= [1,1];\n    $self->mapping($mapping);\n    $nse || 0;\n    $self->force_nse($nse);\n    defined $fs    && $self->frameshifts($fs);\n    defined $start && $self->start($start);\n    defined $end   && $self->end($end);\n    defined $strand && $self->strand($strand);\n\n    return $self; # success - we hope!\n}\n\n=head2 start\n\n Title   : start\n Usage   : $obj->start($newval)\n Function: Get/set the 1-based start position of this sequence in the original\n           sequence. '0' means before the original sequence starts.\n Returns : value of start\n Args    : newvalue (optional)\n\n\nsub start{\n    my $self = shift;\n    if( @_ ) {\n        my $value = shift;\n        $self->{'start'} = $value;\n    }\n    return $self->{'start'} if defined $self->{'start'};\n    return 1                if $self->seq;\n    return;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $obj->end($newval)\n Function: Get/set the 1-based end position of this sequence in the original\n           sequence. '0' means before the original sequence starts.\n Returns : value of end\n Args    : newvalue (optional)\n Note    : although this is a get/set, it checks passed values against the\n           calculated end point ( derived from the sequence and based on\n           $GAP_SYMBOLS and possible frameshifts() ).  If there is no match,\n           it will warn and set the proper value.  Probably best used for\n           debugging proper sequence calculations.\n\n\nsub end {\n    my $self = shift;\n    if( @_ ) {\n        my $value = shift;\n        my $st = $self->start;\n        # start of 0 usually means the sequence is all gaps but maps to\n        # other sequences in an alignment\n        if ($self->seq && $st != 0 ) {\n            my $len = $self->_ungapped_len;\n            my $calend = $st + $len - 1;\n            my $id = $self->id || 'unknown';\n            if ($calend != $value) {\n                $self->warn(\"In sequence $id residue count gives end value \".\n                \"$calend.  \\nOverriding value [$value] with value $calend for \".\n                \"Bio::LocatableSeq::end().\\n\".$self->seq);\n                $value = $calend;\n            }\n        }\n        $self->{'end'} = $value;\n    }\n\n    if (defined $self->{'end'}) {\n        return $self->{'end'}\n    } elsif ( my $len = $self->_ungapped_len) {\n        return $len + $self->start - 1;\n    } else {\n        return;\n    }\n}\n\n# changed 08.10.26 to return ungapped length, not the calculated end\n# of the sequence\nsub _ungapped_len {\n    my $self = shift;\n    return unless my $string = $self->seq;\n    my ($map_res, $map_coord) = $self->mapping;\n    my $offset = 0;\n    if (my %data = $self->frameshifts) {\n        map {$offset += $_} values %data;\n    }\n    $string =~ s{[$GAP_SYMBOLS$FRAMESHIFT_SYMBOLS]+}{}g;\n    return CORE::length($string)/($map_res/$map_coord) + $offset/($map_coord/$map_res);\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand($newval)\n Function: return or set the strandedness\n Returns : the value of the strandedness (-1, 0 or 1)\n Args    : the value of the strandedness (-1, 0 or 1)\n\n\nsub strand{\n   my $self = shift;\n   if( @_ ) {\n        my $value = shift;\n        $self->{'strand'} = $value;\n    }\n    return $self->{'strand'};\n}\n\n=head2 mapping\n\n Title   : mapping\n Usage   : $obj->mapping($newval)\n Function: return or set the mapping indices (indicates # symbols/positions in\n           the source string mapping to # of coordinate positions)\n Returns : two-element array (# symbols => # coordinate pos)\n Args    : two elements (# symbols => # coordinate pos); this can also be\n           passed in as an array reference of the two elements (as might be\n           passed upon Bio::LocatableSeq instantiation, for instance).\n\n\nsub mapping {\n    my $self = shift;\n    if( @_ ) {\n        my @mapping = (ref($_[0]) eq 'ARRAY') ? @{$_[0]} : @_;\n        $self->throw(\"Must pass two values (# residues mapped to # positions)\")\n            if @mapping != 2;\n        if ((grep {$_ != 1 && $_ != 3} @mapping) || ($mapping[0] == 3 && $mapping[1] == 3)) {\n            $self->throw(\"Mapping values other than 1 or 3 are not currently supported\")\n        }\n        $self->{'_mapping'} = \\@mapping;\n    }\n    $self->throw('Mapping for LocatableSeq not set') if !exists $self->{'_mapping'};\n    return @{ $self->{'_mapping'} };\n}\n\n=head2 frameshifts\n\n Title   : frameshifts\n Usage   : $obj->frameshifts($newval)\n Function: get/set the frameshift hash, which contains sequence positions as\n           keys and the shift (-2, -1, 1, 2) as the value\n Returns : hash\n Args    : hash or hash reference\n\n\nsub frameshifts {\n    my $self = shift;\n    if( @_ ) {\n        if (ref $_[0] eq 'HASH') {\n            $self->{_frameshifts} = $_[0];\n        } else {\n            # assume this is a full list to be converted to a hash\n            $self->{_frameshifts} = \\%{@_} # coerce into hash ref\n        }\n    }\n    (defined $self->{_frameshifts} && ref $self->{_frameshifts} eq 'HASH') ?\n        return %{$self->{_frameshifts}} : return ();\n}\n\n=head2 get_nse\n\n Title   : get_nse\n Usage   :\n Function: read-only name of form id/start-end\n Example :\n Returns :\n Args    :\n\n\nsub get_nse{\n   my ($self,$char1,$char2) = @_;\n\n   $char1 ||= \"/\";\n   $char2 ||= \"-\";\n   \n   my ($id, $st, $end)  = ($self->id(), $self->start(), $self->end());\n   \n   if ($self->force_nse) {\n        $id  ||= '';\n        $st  ||= 0;\n        $end ||= 0;\n   }\n   \n   $self->throw(\"Attribute id not set\") unless defined($id);\n   $self->throw(\"Attribute start not set\") unless defined($st);\n   $self->throw(\"Attribute end not set\") unless defined($end);\n   \n   #Stockholm Rfam includes version if present so it is optional\n   my $v = $self->version ? '.'.$self->version : ''; \n   return $id . $v. $char1 . $st . $char2 . $end ;\n}\n\n=head2 force_nse\n\n Title   : force_nse\n Usage   : $ls->force_nse()\n Function: Boolean which forces get_nse() to build an NSE, regardless\n           of whether id(), start(), or end() is set\n Returns : Boolean value\n Args    : (optional) Boolean (1 or 0)\n Note    : This will convert any passed value evaluating as TRUE/FALSE to 1/0\n           respectively\n\n\nsub force_nse {\n    my ($self, $flag) = @_;\n    if (defined $flag) {\n        $flag ? (return $self->{'_force_nse'} = 1) : (return $self->{'_force_nse'} = 0);\n    }\n    return $self->{'_force_nse'};\n}\n\n=head2 num_gaps\n\n Title   : num_gaps\n Usage   :$self->num_gaps('.')\n Function:Gets number of gaps in the sequence. The count excludes\n           leading or trailing gap characters.\n\n           Valid bioperl sequence characters are [A-Za-z\\-\\.\\*]. Of\n           these, '.' and '-' are counted as gap characters unless an\n           optional argument specifies one of them.\n\n Returns : number of internal gaps in the sequence.\n Args    : a gap character (optional)\n Status  : Stable\n Note    : replaces no_gaps\n\n\nsub num_gaps {\n    my ($self,$char) = @_;\n    my ($seq, $count) = (undef, 0);\n\n    # default gap characters\n    $char ||= $GAP_SYMBOLS;\n\n    $self->warn(\"I hope you know what you are doing setting gap to [$char]\")\n        unless $char =~ /[$GAP_SYMBOLS]/;\n\n    $seq = $self->seq;\n    return 0 unless $seq; # empty sequence does not have gaps\n\n    $seq =~ s/^([$char]+)//;\n    $seq =~ s/([$char]+)$//;\n    while ( $seq =~ /[$char]+/g ) {\n        $count++;\n    }\n\n    return $count;\n}\n\n\n=head2 column_from_residue_number\n\n Title   : column_from_residue_number\n Usage   : $col = $seq->column_from_residue_number($resnumber)\n Function:\n\n           This function gives the position in the alignment\n           (i.e. column number) of the given residue number in the\n           sequence. For example, for the sequence\n\n         Seq1/91-97 AC..DEF.GH\n\n           column_from_residue_number(94) returns 6.\n\n           An exception is thrown if the residue number would lie\n           outside the length of the aligment\n           (e.g. column_from_residue_number( \"Seq2\", 22 )\n\n Returns : A column number for the position of the\n           given residue in the given sequence (1 = first column)\n Args    : A residue number in the whole sequence (not just that\n           segment of it in the alignment)\n\n\nsub column_from_residue_number {\n    my ($self, $resnumber) = @_;\n\n    $self->throw(\"Residue number has to be a positive integer, not [$resnumber]\")\n    unless $resnumber =~ /^\\d+$/ and $resnumber > 0;\n\n    if ($resnumber >= $self->start() and $resnumber <= $self->end()) {\n\tmy @chunks;\n\tmy $column_incr;\n\tmy $current_column;\n\tmy $current_residue = $self->start - 1;\n\tmy $seq = $self->seq;\n\tmy $strand = $self->strand || 0;\n\n\tif ($strand == -1) {\n#\t    @chunks = reverse $seq =~ m/[^\\.\\-]+|[\\.\\-]+/go;\n\t    @chunks = reverse $seq =~ m/[$RESIDUE_SYMBOLS]+|[$GAP_SYMBOLS]+/go;\n\t    $column_incr = -1;\n\t    $current_column = (CORE::length $seq) + 1;\n\t}\n\telse {\n#\t    @chunks = $seq =~ m/[^\\.\\-]+|[\\.\\-]+/go;\n\t    @chunks = $seq =~ m/[$RESIDUE_SYMBOLS]+|[$GAP_SYMBOLS]+/go;\n\t    $column_incr = 1;\n\t    $current_column = 0;\n\t}\n\n\twhile (my $chunk = shift @chunks) {\n#\t    if ($chunk =~ m|^[\\.\\-]|o) {\n\t    if ($chunk =~ m|^[$GAP_SYMBOLS]|o) {\n\t\t$current_column += $column_incr * CORE::length($chunk);\n\t    }\n\t    else {\n\t\tif ($current_residue + CORE::length($chunk) < $resnumber) {\n\t\t    $current_column += $column_incr * CORE::length($chunk);\n\t\t    $current_residue += CORE::length($chunk);\n\t\t}\n\t\telse {\n\t\t    if ($strand == -1) {\n\t\t\t$current_column -= $resnumber - $current_residue;\n\t\t    }\n\t\t    else {\n\t\t\t$current_column += $resnumber - $current_residue;\n\t\t    }\n\t\t    return $current_column;\n\t\t}\n\t    }\n\t}\n    }\n\n    $self->throw(\"Could not find residue number $resnumber\");\n\n}\n\n=head2 location_from_column\n\n Title   : location_from_column\n Usage   : $loc = $ali->location_from_column($column_number)\n Function:\n\n           This function gives the residue number for a given position\n           in the alignment (i.e. column number) of the given. Gaps\n           complicate this process and force the output to be a\n           L<Bio::Location::Simple> where values can be undefined. \n           For example, for the sequence:\n\n         Seq/91-96 .AC..DEF.G.\n\n           location_from_column( 3 ) position 92\n           location_from_column( 4 ) position 92^93\n           location_from_column( 9 ) position 95^96\n           location_from_column( 1 ) position undef\n\n           An exact position returns a Bio::Location::Simple object\n           where where location_type() returns 'EXACT', if a position\n           is between bases location_type() returns 'IN-BETWEEN'.\n           Column before the first residue returns undef. Note that if\n           the position is after the last residue in the alignment,\n           that there is no guarantee that the original sequence has\n           residues after that position.\n\n           An exception is thrown if the column number is not within\n           the sequence.\n\n Returns : Bio::Location::Simple or undef\n Args    : A column number\n Throws  : If column is not within the sequence\n\nSee L<Bio::Location::Simple> for more.\n\n\nsub location_from_column {\n    my ($self, $column) = @_;\n\n    $self->throw(\"Column number has to be a positive integer, not [$column]\")\n    unless $column =~ /^\\d+$/ and $column > 0;\n    $self->throw(\"Column number [$column] is larger than\".\n         \" sequence length [\". $self->length. \"]\")\n    unless $column <= $self->length;\n\n    my ($loc);\n    my $s = $self->subseq(1,$column);\n    $s =~ s/[^a-zA-Z\\*]//g;\n\n    my $pos = CORE::length $s;\n\n    my $start = $self->start || 0 ;\n    my $strand = $self->strand() || 1;\n    my $relative_pos = ($strand == -1)\n        ? ($self->end - $pos + 1)\n    : ($pos + $start - 1);\n    if ($self->subseq($column, $column) =~ /[a-zA-Z\\*]/ ) {\n    $loc = Bio::Location::Simple->new\n        (-start  => $relative_pos,\n         -end    => $relative_pos,\n         -strand => 1,\n         );\n    } elsif ($pos == 0 and $self->start == 1) {\n    } else {\n      my ($start,$end) = ($relative_pos, $relative_pos + $strand);\n      if ($strand == -1) {\n    ($start,$end) = ($end,$start);\n      }\n    $loc = Bio::Location::Simple->new\n        (-start         => $start,\n         -end           => $end,\n         -strand        => 1,\n         -location_type => 'IN-BETWEEN'\n         );\n    }\n    return $loc;\n}\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::LocatableSeq object which\n           has the reversed complement of the sequence. For protein\n           sequences this throws an exception of \"Sequence is a\n           protein. Cannot revcom\"\n\n Returns : A new Bio::LocatableSeq object\n Args    : none\n\n\nsub revcom {\n    my ($self) = @_;\n    # since we don't know whether sequences without 1 => 1 correlation can be\n    # revcom'd, kick back\n    if (grep {$_ != 1} $self->mapping) {\n        $self->warn('revcom() not supported for sequences with mapped values of > 1');\n        return;\n    }\n    my $new = $self->SUPER::revcom;\n    $new->strand($self->strand * -1) if $self->strand;\n    $new->start($self->start) if $self->start;\n    $new->end($self->end) if $self->end;\n    return $new;\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::PrimarySeqI implementing object\n Args    : Two integers denoting first and last columns of the\n           sequence to be included into sub-sequence.\n\n\n\nsub trunc {\n    my ($self, $start, $end) = @_;\n    my $new = $self->SUPER::trunc($start, $end);\n    $new->strand($self->strand);\n\n    # end will be automatically calculated\n    $start = $end if $self->strand == -1;\n\n    $start = $self->location_from_column($start);\n    $start ? ($start = $start->end) : ($start = 1);\n    $new->start($start) if $start;\n\n    return $new;\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n            }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z), numbers [0-9] \n           and common symbols used for gaps, stop codons, unknown residues,\n           and frameshifts, including '-','.','*','?','=',and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.","parameters":[{"label":"$self"},{"label":"$seqstr"}]},"kind":12,"line":635,"children":[{"localvar":"my","containerName":"validate_seq","definition":"my","name":"$self","line":636,"kind":13},{"line":636,"kind":13,"containerName":"validate_seq","name":"$seqstr"},{"containerName":"validate_seq","name":"$seqstr","line":637,"kind":13},{"containerName":"validate_seq","name":"$seqstr","kind":13,"line":637},{"containerName":"validate_seq","name":"$self","kind":13,"line":637},{"line":637,"kind":12,"name":"seq","containerName":"validate_seq"},{"kind":13,"line":638,"name":"$seqstr","containerName":"validate_seq"},{"kind":13,"line":640,"name":"$seqstr","containerName":"validate_seq"},{"containerName":"validate_seq","name":"$seqstr","line":641,"kind":13},{"kind":13,"line":642,"name":"$self","containerName":"validate_seq"},{"line":642,"kind":12,"containerName":"validate_seq","name":"warn"},{"line":643,"kind":13,"containerName":"validate_seq","name":"$seqstr"}]},{"line":640,"kind":12,"name":"CORE","containerName":"length"},{"kind":12,"children":[{"line":669,"kind":13,"localvar":"my","containerName":"no_gaps","definition":"my","name":"$self"},{"name":"$self","containerName":"no_gaps","line":670,"kind":13},{"line":670,"kind":12,"name":"deprecated","containerName":"no_gaps"},{"containerName":"no_gaps","name":"$self","line":673,"kind":13},{"name":"num_gaps","containerName":"no_gaps","kind":12,"line":673}],"line":668,"definition":"sub","name":"no_gaps","containerName":"main::","range":{"end":{"line":674,"character":9999},"start":{"line":668,"character":0}}},{"range":{"start":{"character":0,"line":687},"end":{"character":9999,"line":693}},"name":"no_sequences","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"no_sequences","definition":"my","name":"$self","line":688,"kind":13},{"containerName":"no_sequences","name":"$self","line":689,"kind":13},{"containerName":"no_sequences","name":"deprecated","kind":12,"line":689},{"containerName":"no_sequences","name":"$self","kind":13,"line":692},{"kind":12,"line":692,"containerName":"no_sequences","name":"num_sequences"}],"line":687,"kind":12}]}