{"version":5,"vars":[{"kind":2,"line":46,"containerName":"","name":"base"},{"line":60,"children":[{"localvar":"my","definition":"my","name":"$thing","containerName":"new","line":61,"kind":13},{"line":61,"kind":13,"containerName":"new","name":"%args"},{"line":62,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"name":"$thing","containerName":"new","line":62,"kind":13},{"kind":13,"line":62,"name":"$thing","containerName":"new"},{"localvar":"my","definition":"my","name":"$obj","containerName":"new","line":63,"kind":13},{"line":63,"kind":13,"containerName":"new","name":"%transcript"},{"kind":13,"line":65,"definition":"my","name":"@exons","containerName":"new","localvar":"my"},{"name":"$args","containerName":"new","line":65,"kind":13}],"kind":12,"detail":"($thing,%args)","signature":{"label":"new($thing,%args)","documentation":"1;\n# $Id: Transcript.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Transcript - Transcript class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis stores informations about coding sequences (CDS).\nThe implementation is that a Transcript object accesses a collection of\nExon objects, inferring from them the nucleotide structure and sequence.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Transcript;\n\nuse strict;\n# use Carp qw(carp cluck);\nuse Bio::LiveSeq::Exon; # uses Exon to create new exon in case of deletion\nuse base qw(Bio::LiveSeq::SeqI);\n\n=head2 new\n\n  Title   : new\n  Usage   : $transcript = Bio::LiveSeq::Transcript->new(-exons => \\@obj_refs);\n\n  Function: generates a new Bio::LiveSeq::Transcript\n  Returns : reference to a new object of class Transcript\n  Errorcode -1\n  Args    : reference to an array of Exon object references","parameters":[{"label":"$thing"},{"label":"%args"}]},"containerName":"main::","definition":"sub","range":{"end":{"line":65,"character":9999},"start":{"character":0,"line":60}},"name":"new"},{"containerName":null,"name":"$obj","line":67,"kind":13},{"containerName":null,"name":"%transcript","line":67,"kind":13},{"containerName":null,"name":"$obj","kind":13,"line":68},{"name":"$obj","containerName":null,"line":68,"kind":13},{"containerName":null,"name":"$class","line":68,"kind":13},{"line":70,"kind":13,"name":"@exons","containerName":null},{"name":"$obj","containerName":null,"line":71,"kind":13},{"containerName":"main::","name":"warn","line":71,"kind":12},{"line":76,"kind":13,"localvar":"my","name":"$firstexon","definition":"my","containerName":null},{"line":76,"kind":13,"containerName":null,"name":"@exons"},{"containerName":null,"definition":"my","name":"$strand","localvar":"my","kind":13,"line":80},{"kind":13,"line":80,"containerName":null,"name":"$firstexon"},{"name":"strand","containerName":"main::","kind":12,"line":80},{"name":"$seq","definition":"my","containerName":null,"localvar":"my","kind":13,"line":81},{"name":"%firstexon","containerName":null,"kind":13,"line":81},{"line":82,"kind":13,"name":"$obj","containerName":null},{"line":82,"kind":12,"containerName":"main::","name":"alphabet"},{"line":84,"kind":12,"name":"_checkexons"},{"line":84,"kind":13,"name":"@exons","containerName":null},{"name":"$obj","containerName":null,"kind":13,"line":85},{"name":"warn","containerName":"main::","line":85,"kind":12},{"name":"%obj","containerName":null,"line":88,"kind":13},{"name":"$strand","containerName":null,"line":88,"kind":13},{"line":89,"kind":13,"name":"%obj","containerName":null},{"containerName":null,"name":"@exons","line":89,"kind":13},{"name":"%obj","containerName":null,"line":90,"kind":13},{"line":90,"kind":13,"containerName":null,"name":"$seq"},{"containerName":null,"definition":"my","name":"$exon","localvar":"my","kind":13,"line":93},{"line":94,"kind":13,"name":"$exon","containerName":null},{"name":"@exons","containerName":null,"line":94,"kind":13},{"containerName":null,"name":"%exon","kind":13,"line":95},{"name":"$obj","containerName":null,"kind":13,"line":95},{"kind":13,"line":97,"name":"$obj","containerName":null},{"range":{"start":{"character":0,"line":112},"end":{"line":115,"character":9999}},"containerName":"main::","definition":"sub","name":"all_Exons","line":112,"children":[{"line":113,"kind":13,"localvar":"my","containerName":"all_Exons","name":"$self","definition":"my"},{"localvar":"my","containerName":"all_Exons","definition":"my","name":"$exonsref","line":114,"kind":13},{"containerName":"all_Exons","name":"$self","line":114,"kind":13},{"kind":13,"line":115,"definition":"my","name":"@exons","containerName":"all_Exons","localvar":"my"},{"kind":13,"line":115,"name":"$exonsref","containerName":"all_Exons"}],"kind":12},{"kind":13,"line":116,"definition":"my","name":"@newexons","containerName":null,"localvar":"my"},{"kind":13,"line":117,"containerName":null,"definition":"my","name":"$exon","localvar":"my"},{"line":118,"kind":13,"name":"$exon","containerName":null},{"kind":13,"line":118,"containerName":null,"name":"@exons"},{"name":"$exon","containerName":null,"kind":13,"line":119},{"name":"obj_valid","containerName":"main::","kind":12,"line":119},{"line":120,"kind":13,"name":"$self","containerName":null},{"line":120,"kind":12,"containerName":"main::","name":"warn"},{"line":122,"kind":13,"containerName":null,"name":"@newexons"},{"kind":13,"line":122,"containerName":null,"name":"$exon"},{"name":"exons","kind":12,"line":125},{"kind":12,"line":125,"name":"newexons"},{"containerName":null,"name":"%self","line":127,"kind":13},{"line":127,"kind":13,"containerName":null,"name":"@newexons"},{"containerName":null,"name":"@newexons","kind":13,"line":129},{"kind":12,"line":150,"children":[{"containerName":"downstream_seq","definition":"my","name":"$self","localvar":"my","kind":13,"line":151},{"name":"$howmany","containerName":"downstream_seq","kind":13,"line":151},{"localvar":"my","containerName":"downstream_seq","definition":"my","name":"$str","line":152,"kind":13},{"name":"$howmany","containerName":"downstream_seq","kind":13,"line":153},{"name":"$howmany","containerName":"downstream_seq","line":154,"kind":13},{"containerName":"downstream_seq","name":"$self","kind":13,"line":155},{"name":"throw","containerName":"downstream_seq","line":155,"kind":12},{"line":158,"kind":13,"name":"$self","containerName":"downstream_seq"},{"name":"alphabet","containerName":"downstream_seq","kind":12,"line":158},{"containerName":"downstream_seq","name":"$self","kind":13,"line":161},{"line":161,"kind":12,"name":"gene","containerName":"downstream_seq"},{"containerName":"downstream_seq","name":"$str","line":162,"kind":13},{"name":"$self","containerName":"downstream_seq","line":162,"kind":13},{"name":"labelsubseq","containerName":"downstream_seq","kind":12,"line":162},{"kind":13,"line":162,"name":"$self","containerName":"downstream_seq"},{"line":162,"kind":12,"name":"end","containerName":"downstream_seq"},{"containerName":"downstream_seq","name":"$self","kind":13,"line":162},{"line":162,"kind":12,"name":"gene","containerName":"downstream_seq"},{"line":162,"kind":12,"containerName":"downstream_seq","name":"maxtranscript"},{"line":162,"kind":12,"name":"end","containerName":"downstream_seq"},{"name":"$str","containerName":"downstream_seq","kind":13,"line":163},{"containerName":"downstream_seq","name":"$str","line":163,"kind":13},{"kind":13,"line":164,"containerName":"downstream_seq","name":"$str"},{"containerName":"downstream_seq","name":"$str","kind":13,"line":165},{"containerName":"downstream_seq","name":"$howmany","kind":13,"line":167},{"line":170,"kind":13,"containerName":"downstream_seq","name":"$howmany"},{"kind":13,"line":174,"containerName":"downstream_seq","name":"@exons","definition":"my","localvar":"my"},{"kind":13,"line":174,"name":"$self","containerName":"downstream_seq"},{"containerName":"downstream_seq","name":"all_Exons","kind":12,"line":174},{"line":175,"kind":13,"localvar":"my","containerName":"downstream_seq","name":"$strand","definition":"my"},{"name":"$self","containerName":"downstream_seq","line":175,"kind":13},{"name":"strand","containerName":"downstream_seq","line":175,"kind":12},{"localvar":"my","containerName":"downstream_seq","definition":"my","name":"$lastexon","line":176,"kind":13},{"containerName":"downstream_seq","name":"$exons","kind":13,"line":176},{"line":177,"kind":13,"localvar":"my","containerName":"downstream_seq","definition":"my","name":"$lastexonlength"},{"containerName":"downstream_seq","name":"$lastexon","kind":13,"line":177},{"name":"length","containerName":"downstream_seq","line":177,"kind":12},{"kind":13,"line":180,"name":"$downstream_seq","definition":"my","containerName":"downstream_seq","localvar":"my"},{"line":182,"kind":13,"containerName":"downstream_seq","name":"$howmany"},{"name":"$downstream_seq","containerName":"downstream_seq","line":183,"kind":13},{"containerName":"downstream_seq","name":"$lastexon","kind":13,"line":183},{"kind":12,"line":183,"name":"labelsubseq","containerName":"downstream_seq"},{"kind":13,"line":183,"containerName":"downstream_seq","name":"$self"},{"line":183,"kind":12,"name":"end","containerName":"downstream_seq"},{"line":183,"kind":13,"containerName":"downstream_seq","name":"$howmany"},{"name":"$strand","containerName":"downstream_seq","line":185,"kind":13},{"containerName":"downstream_seq","name":"$downstream_seq","line":186,"kind":13},{"kind":13,"line":186,"name":"$lastexon","containerName":"downstream_seq"},{"kind":12,"line":186,"name":"labelsubseq","containerName":"downstream_seq"},{"kind":13,"line":186,"containerName":"downstream_seq","name":"$self"},{"containerName":"downstream_seq","name":"end","kind":12,"line":186},{"name":"$self","containerName":"downstream_seq","kind":13,"line":186},{"kind":12,"line":186,"name":"end","containerName":"downstream_seq"},{"containerName":"downstream_seq","name":"$downstream_seq","line":188,"kind":13},{"kind":13,"line":188,"containerName":"downstream_seq","name":"$lastexon"},{"name":"labelsubseq","containerName":"downstream_seq","kind":12,"line":188},{"kind":13,"line":188,"name":"$self","containerName":"downstream_seq"},{"line":188,"kind":12,"name":"end","containerName":"downstream_seq"},{"kind":13,"line":188,"containerName":"downstream_seq","name":"$self"},{"line":188,"kind":12,"containerName":"downstream_seq","name":"start"},{"kind":13,"line":191,"name":"$downstream_seq","containerName":"downstream_seq"}],"containerName":"main::","definition":"sub","detail":"($self,$howmany)","signature":{"label":"downstream_seq($self,$howmany)","parameters":[{"label":"$self"},{"label":"$howmany"}],"documentation":"1;\n# $Id: Transcript.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Transcript - Transcript class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis stores informations about coding sequences (CDS).\nThe implementation is that a Transcript object accesses a collection of\nExon objects, inferring from them the nucleotide structure and sequence.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Transcript;\n\nuse strict;\n# use Carp qw(carp cluck);\nuse Bio::LiveSeq::Exon; # uses Exon to create new exon in case of deletion\nuse base qw(Bio::LiveSeq::SeqI);\n\n=head2 new\n\n  Title   : new\n  Usage   : $transcript = Bio::LiveSeq::Transcript->new(-exons => \\@obj_refs);\n\n  Function: generates a new Bio::LiveSeq::Transcript\n  Returns : reference to a new object of class Transcript\n  Errorcode -1\n  Args    : reference to an array of Exon object references\n\n\nsub new {\n  my ($thing, %args) = @_;\n  my $class = ref($thing) || $thing;\n  my ($obj,%transcript);\n\n  my @exons=@{$args{-exons}};\n\n  $obj = \\%transcript;\n  $obj = bless $obj, $class;\n\n  unless (@exons) {\n    $obj->warn(\"$class not initialised because exons array empty\");\n    return(-1);\n  }\n\n  # now useless, after start and end methods have been overridden here\n  my $firstexon = $exons[0];\n  #my $lastexon = $exons[-1];\n  #my $start = $firstexon->start;\n  #my $end = $lastexon->end;\n  my $strand = $firstexon->strand;\n  my $seq = $firstexon->{'seq'};\n  $obj->alphabet('rna');\n\n  unless (_checkexons(\\@exons)) {\n    $obj->warn(\"$class not initialised because of problems in the exon structure\");\n    return(-1);\n  }\n  $obj->{'strand'}=$strand;\n  $obj->{'exons'}=\\@exons;\n  $obj->{'seq'}=$seq;\n\n  # set Transcript into each Exon\n  my $exon;\n  foreach $exon (@exons) {\n    $exon->{'transcript'}=$obj;\n  }\n  return $obj;\n}\n\n\n=head2 all_Exons\n\n Title   : all_Exons\n Usage   : $transcript_obj->all_Exons()\n Function: returns references to all Exon objects the Transcript is composed of\n Example : foreach $exon ($transcript->all_Exons()) { do_something }\n Returns : array of object references\n Args    : none\n\n\nsub all_Exons {\n  my $self=shift;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  my @newexons;\n  my $exon;\n  foreach $exon (@exons) {\n    unless ($exon->obj_valid) {\n      $self->warn(\"$exon no more valid, start or end label lost, skipping....\",1); # ignorable\n    } else {\n      push(@newexons,$exon);\n    }\n  }\n  if ($#exons != $#newexons) {\n    # update exons field\n    $self->{'exons'}=\\@newexons;\n  }\n  return (@newexons);\n}\n\n=head2 downstream_seq\n\n Title   : downstream_seq\n Usage   : $transcript_obj->downstream_seq()\n         : $transcript_obj->downstream_seq(64)\n Function: returns a string of nucleotides downstream of the end of the\n           CDS. If there is some information of the real mRNA, from features in\n           an attached Gene object, it will return up to those boundaries.\n           Otherwise it will return 1000 nucleotides.\n           If an argument is given it will override the default 1000 number\n           and return instead /that/ requested number of nucleotides.\n           But if a Gene object is attached, this argument will be ignored.\n Returns : string\n Args    : an optional integer number of nucleotides to be returned instead of\n           the default if no gene attached"},"name":"downstream_seq","range":{"start":{"line":150,"character":0},"end":{"line":192,"character":9999}}},{"line":164,"kind":12,"containerName":"length","name":"CORE"},{"range":{"end":{"character":9999,"line":253},"start":{"character":0,"line":205}},"name":"upstream_seq","children":[{"containerName":"upstream_seq","definition":"my","name":"$self","localvar":"my","kind":13,"line":206},{"kind":13,"line":206,"name":"$howmany","containerName":"upstream_seq"},{"name":"$howmany","containerName":"upstream_seq","kind":13,"line":207},{"line":208,"kind":13,"name":"$howmany","containerName":"upstream_seq"},{"kind":13,"line":209,"name":"$self","containerName":"upstream_seq"},{"name":"throw","containerName":"upstream_seq","line":209,"kind":12},{"containerName":"upstream_seq","name":"$self","line":212,"kind":13},{"line":212,"kind":12,"name":"alphabet","containerName":"upstream_seq"},{"name":"$self","containerName":"upstream_seq","line":213,"kind":13},{"name":"gene","containerName":"upstream_seq","line":213,"kind":12},{"line":214,"kind":13,"localvar":"my","name":"$str","definition":"my","containerName":"upstream_seq"},{"name":"$self","containerName":"upstream_seq","kind":13,"line":214},{"containerName":"upstream_seq","name":"labelsubseq","kind":12,"line":214},{"kind":13,"line":214,"containerName":"upstream_seq","name":"$self"},{"line":214,"kind":12,"containerName":"upstream_seq","name":"gene"},{"line":214,"kind":12,"containerName":"upstream_seq","name":"maxtranscript"},{"kind":12,"line":214,"containerName":"upstream_seq","name":"start"},{"line":214,"kind":13,"containerName":"upstream_seq","name":"$self"},{"containerName":"upstream_seq","name":"start","kind":12,"line":214},{"line":215,"kind":13,"containerName":"upstream_seq","name":"$str"},{"containerName":"upstream_seq","name":"$str","kind":13,"line":216},{"containerName":"upstream_seq","name":"$str","kind":13,"line":217},{"line":219,"kind":13,"containerName":"upstream_seq","name":"$howmany"},{"line":222,"kind":13,"name":"$howmany","containerName":"upstream_seq"},{"kind":13,"line":226,"containerName":"upstream_seq","name":"@exons","definition":"my","localvar":"my"},{"name":"$self","containerName":"upstream_seq","kind":13,"line":226},{"name":"all_Exons","containerName":"upstream_seq","line":226,"kind":12},{"definition":"my","name":"$firstexon","containerName":"upstream_seq","localvar":"my","kind":13,"line":227},{"line":227,"kind":13,"containerName":"upstream_seq","name":"$exons"},{"line":229,"kind":13,"localvar":"my","containerName":"upstream_seq","definition":"my","name":"$upstream_seq"},{"line":230,"kind":13,"localvar":"my","definition":"my","name":"$strand","containerName":"upstream_seq"},{"name":"$self","containerName":"upstream_seq","kind":13,"line":230},{"containerName":"upstream_seq","name":"strand","kind":12,"line":230},{"kind":13,"line":232,"name":"$howmany","containerName":"upstream_seq"},{"localvar":"my","name":"$labelbefore","definition":"my","containerName":"upstream_seq","line":233,"kind":13},{"kind":13,"line":233,"name":"$firstexon","containerName":"upstream_seq"},{"kind":12,"line":233,"name":"label","containerName":"upstream_seq"},{"name":"$howmany","containerName":"upstream_seq","kind":13,"line":233},{"line":233,"kind":13,"containerName":"upstream_seq","name":"$firstexon"},{"kind":12,"line":233,"name":"start","containerName":"upstream_seq"},{"kind":13,"line":234,"containerName":"upstream_seq","name":"$labelbefore"},{"name":"$strand","containerName":"upstream_seq","line":235,"kind":13},{"kind":13,"line":236,"name":"$labelbefore","containerName":"upstream_seq"},{"kind":13,"line":236,"name":"$self","containerName":"upstream_seq"},{"kind":12,"line":236,"containerName":"upstream_seq","name":"start"},{"containerName":"upstream_seq","name":"$labelbefore","line":238,"kind":13},{"containerName":"upstream_seq","name":"$self","line":238,"kind":13},{"containerName":"upstream_seq","name":"end","kind":12,"line":238},{"name":"$upstream_seq","containerName":"upstream_seq","kind":13,"line":241},{"name":"$firstexon","containerName":"upstream_seq","kind":13,"line":241},{"kind":12,"line":241,"name":"labelsubseq","containerName":"upstream_seq"},{"containerName":"upstream_seq","name":"$labelbefore","kind":13,"line":241},{"line":241,"kind":13,"name":"$firstexon","containerName":"upstream_seq"},{"kind":12,"line":241,"containerName":"upstream_seq","name":"start"},{"kind":13,"line":242,"containerName":"upstream_seq","name":"$upstream_seq"},{"kind":13,"line":244,"containerName":"upstream_seq","name":"$strand"},{"containerName":"upstream_seq","name":"$upstream_seq","kind":13,"line":245},{"line":245,"kind":13,"containerName":"upstream_seq","name":"$firstexon"},{"line":245,"kind":12,"containerName":"upstream_seq","name":"labelsubseq"},{"name":"$self","containerName":"upstream_seq","line":245,"kind":13},{"line":245,"kind":12,"containerName":"upstream_seq","name":"start"},{"line":245,"kind":13,"containerName":"upstream_seq","name":"$self"},{"kind":12,"line":245,"containerName":"upstream_seq","name":"start"},{"line":246,"kind":13,"name":"$upstream_seq","containerName":"upstream_seq"},{"line":248,"kind":13,"containerName":"upstream_seq","name":"$upstream_seq"},{"name":"$firstexon","containerName":"upstream_seq","line":248,"kind":13},{"kind":12,"line":248,"name":"labelsubseq","containerName":"upstream_seq"},{"containerName":"upstream_seq","name":"$self","line":248,"kind":13},{"line":248,"kind":12,"name":"end","containerName":"upstream_seq"},{"name":"$self","containerName":"upstream_seq","line":248,"kind":13},{"name":"start","containerName":"upstream_seq","line":248,"kind":12},{"kind":13,"line":249,"containerName":"upstream_seq","name":"$upstream_seq"},{"containerName":"upstream_seq","name":"$upstream_seq","line":252,"kind":13}],"line":205,"kind":12,"signature":{"documentation":"1;\n# $Id: Transcript.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Transcript - Transcript class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis stores informations about coding sequences (CDS).\nThe implementation is that a Transcript object accesses a collection of\nExon objects, inferring from them the nucleotide structure and sequence.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Transcript;\n\nuse strict;\n# use Carp qw(carp cluck);\nuse Bio::LiveSeq::Exon; # uses Exon to create new exon in case of deletion\nuse base qw(Bio::LiveSeq::SeqI);\n\n=head2 new\n\n  Title   : new\n  Usage   : $transcript = Bio::LiveSeq::Transcript->new(-exons => \\@obj_refs);\n\n  Function: generates a new Bio::LiveSeq::Transcript\n  Returns : reference to a new object of class Transcript\n  Errorcode -1\n  Args    : reference to an array of Exon object references\n\n\nsub new {\n  my ($thing, %args) = @_;\n  my $class = ref($thing) || $thing;\n  my ($obj,%transcript);\n\n  my @exons=@{$args{-exons}};\n\n  $obj = \\%transcript;\n  $obj = bless $obj, $class;\n\n  unless (@exons) {\n    $obj->warn(\"$class not initialised because exons array empty\");\n    return(-1);\n  }\n\n  # now useless, after start and end methods have been overridden here\n  my $firstexon = $exons[0];\n  #my $lastexon = $exons[-1];\n  #my $start = $firstexon->start;\n  #my $end = $lastexon->end;\n  my $strand = $firstexon->strand;\n  my $seq = $firstexon->{'seq'};\n  $obj->alphabet('rna');\n\n  unless (_checkexons(\\@exons)) {\n    $obj->warn(\"$class not initialised because of problems in the exon structure\");\n    return(-1);\n  }\n  $obj->{'strand'}=$strand;\n  $obj->{'exons'}=\\@exons;\n  $obj->{'seq'}=$seq;\n\n  # set Transcript into each Exon\n  my $exon;\n  foreach $exon (@exons) {\n    $exon->{'transcript'}=$obj;\n  }\n  return $obj;\n}\n\n\n=head2 all_Exons\n\n Title   : all_Exons\n Usage   : $transcript_obj->all_Exons()\n Function: returns references to all Exon objects the Transcript is composed of\n Example : foreach $exon ($transcript->all_Exons()) { do_something }\n Returns : array of object references\n Args    : none\n\n\nsub all_Exons {\n  my $self=shift;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  my @newexons;\n  my $exon;\n  foreach $exon (@exons) {\n    unless ($exon->obj_valid) {\n      $self->warn(\"$exon no more valid, start or end label lost, skipping....\",1); # ignorable\n    } else {\n      push(@newexons,$exon);\n    }\n  }\n  if ($#exons != $#newexons) {\n    # update exons field\n    $self->{'exons'}=\\@newexons;\n  }\n  return (@newexons);\n}\n\n=head2 downstream_seq\n\n Title   : downstream_seq\n Usage   : $transcript_obj->downstream_seq()\n         : $transcript_obj->downstream_seq(64)\n Function: returns a string of nucleotides downstream of the end of the\n           CDS. If there is some information of the real mRNA, from features in\n           an attached Gene object, it will return up to those boundaries.\n           Otherwise it will return 1000 nucleotides.\n           If an argument is given it will override the default 1000 number\n           and return instead /that/ requested number of nucleotides.\n           But if a Gene object is attached, this argument will be ignored.\n Returns : string\n Args    : an optional integer number of nucleotides to be returned instead of\n           the default if no gene attached\n\n\nsub downstream_seq {\n  my ($self,$howmany)=@_;\n  my $str;\n  if (defined ($howmany)) {\n    unless ($howmany > 0) {\n      $self->throw(\"No sense in asking less than 1 downstream nucleotides!\");\n    }\n  } else {\n    unless ($self->{'seq'}->alphabet eq 'rna') { # if rna retrieve until the end\n      #$str=$DNAobj->labelsubseq($self->end,undef,undef,\"unsecuremoderequested\");\n      #return(substr($str,1)); # delete first nucleotide that is the last of Transcript\n      if ($self->gene) { # if there is Gene object attached fetch relevant info\n\t$str=$self->{'seq'}->labelsubseq($self->end,undef,$self->gene->maxtranscript->end); # retrieve from end of this Transcript to end of the maxtranscript\n\t$str=substr($str,1); # delete first nucleotide that is the last of Transcript\n\tif (CORE::length($str) > 0) {\n\t  return($str);\n\t} else { # if there was no downstream through the gene's maxtranscript, go the usual way\n\t  $howmany = 1000;\n\t}\n      } else {\n\t$howmany = 1000;\n      }\n    }\n  }\n  my @exons=$self->all_Exons;\n  my $strand=$self->strand();\n  my $lastexon=$exons[-1];\n  my $lastexonlength=$lastexon->length;\n  # $howmany nucs after end of last exon\n  #my $downstream_seq=$lastexon->subseq($lastexonlength+1,undef,$howmany);\n  my $downstream_seq;\n\n  if ($howmany) {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,$howmany,undef,\"unsecuremoderequested\"),1);\n  } else {\n    if ($strand == 1) {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,undef,$self->{'seq'}->end,\"unsecuremoderequested\"),1);\n    } else {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,undef,$self->{'seq'}->start,\"unsecuremoderequested\"),1);\n    }\n  }\n  return $downstream_seq;\n}\n\n=head2 upstream_seq\n\n Title   : upstream_seq\n Usage   : $transcript_obj->upstream_seq()\n         : $transcript_obj->upstream_seq(64)\n Function: just like downstream_seq but returns nucleotides before the ATG\n Note    : the default, if no Gene information present and no nucleotides\n           number given, is to return up to 400 nucleotides.","parameters":[{"label":"$self"},{"label":"$howmany"}],"label":"upstream_seq($self,$howmany)"},"detail":"($self,$howmany)","definition":"sub","containerName":"main::"},{"definition":"sub","containerName":"main::","signature":{"label":"label($self,$position,$firstlabel)","documentation":" These get redefined here, overriding the SeqI one because they draw their\n information from the Exons a Transcript is built of\n optional argument: firstlabel. If not given, it checks coordinate_start\n                                This is useful when called by Translation\n                                also used by _delete","parameters":[{"label":"$self"},{"label":"$position"},{"label":"$firstlabel"}]},"detail":"($self,$position,$firstlabel)","kind":12,"children":[{"kind":13,"line":261,"containerName":"label","name":"$self","definition":"my","localvar":"my"},{"containerName":"label","name":"$position","line":261,"kind":13},{"name":"$firstlabel","containerName":"label","line":261,"kind":13},{"name":"$position","containerName":"label","line":262,"kind":13},{"kind":13,"line":263,"containerName":"label","name":"$self"},{"containerName":"label","name":"warn","line":263,"kind":12},{"line":266,"kind":13,"localvar":"my","name":"$start","definition":"my","containerName":"label"},{"containerName":"label","name":"$end","kind":13,"line":266},{"line":266,"kind":13,"name":"$strand","containerName":"label"},{"name":"$self","containerName":"label","kind":13,"line":266},{"kind":12,"line":266,"name":"start","containerName":"label"},{"name":"$self","containerName":"label","kind":13,"line":266},{"line":266,"kind":12,"containerName":"label","name":"end"},{"line":266,"kind":13,"containerName":"label","name":"$self"},{"name":"strand","containerName":"label","kind":12,"line":266},{"containerName":"label","name":"$label","definition":"my","localvar":"my","kind":13,"line":267},{"name":"@labels","containerName":"label","line":267,"kind":13},{"containerName":"label","name":"$length","line":267,"kind":13},{"kind":13,"line":267,"name":"$arraypos","containerName":"label"},{"line":268,"kind":13,"containerName":"label","name":"$firstlabel"},{"name":"$firstlabel","containerName":"label","line":269,"kind":13},{"name":"$self","containerName":"label","line":269,"kind":13},{"kind":12,"line":269,"name":"coordinate_start","containerName":"label"},{"containerName":"label","name":"$coord_pos","definition":"my","localvar":"my","kind":13,"line":271},{"line":271,"kind":13,"name":"$self","containerName":"label"},{"name":"_inside_position","containerName":"label","line":271,"kind":12},{"name":"$firstlabel","containerName":"label","line":271,"kind":13},{"line":272,"kind":13,"containerName":"label","name":"$length"},{"containerName":"label","name":"$self","line":272,"kind":13},{"name":"length","containerName":"label","line":272,"kind":12},{"kind":13,"line":274,"containerName":"label","name":"$position"},{"kind":13,"line":275,"name":"$position","containerName":"label"},{"containerName":"label","name":"$arraypos","kind":13,"line":277},{"containerName":"label","name":"$position","line":277,"kind":13},{"containerName":"label","name":"$coord_pos","kind":13,"line":277},{"kind":13,"line":279,"name":"$arraypos","containerName":"label"},{"name":"$label","containerName":"label","line":280,"kind":13},{"line":280,"kind":13,"containerName":"label","name":"$self"},{"line":280,"kind":12,"containerName":"label","name":"label"},{"containerName":"label","name":"$arraypos","line":280,"kind":13},{"kind":13,"line":280,"name":"$start","containerName":"label"},{"name":"$strand","containerName":"label","line":280,"kind":13},{"name":"$arraypos","containerName":"label","line":281,"kind":13},{"kind":13,"line":281,"containerName":"label","name":"$length"},{"kind":13,"line":282,"containerName":"label","name":"$label"},{"line":282,"kind":13,"name":"$self","containerName":"label"},{"name":"label","containerName":"label","line":282,"kind":12},{"name":"$arraypos","containerName":"label","line":282,"kind":13},{"kind":13,"line":282,"containerName":"label","name":"$length"},{"containerName":"label","name":"$end","kind":13,"line":282},{"line":282,"kind":13,"containerName":"label","name":"$strand"},{"line":284,"kind":13,"containerName":"label","name":"@labels"},{"name":"$self","containerName":"label","kind":13,"line":284},{"kind":12,"line":284,"name":"all_labels","containerName":"label"},{"line":285,"kind":13,"name":"$label","containerName":"label"},{"containerName":"label","name":"$labels","kind":13,"line":285},{"kind":13,"line":285,"name":"$arraypos","containerName":"label"}],"line":260,"name":"label","range":{"end":{"line":288,"character":9999},"start":{"line":260,"character":0}}},{"name":"position","range":{"start":{"line":295,"character":0},"end":{"line":332,"character":9999}},"definition":"sub","containerName":"main::","signature":{"documentation":" argument: label\n returns: position of label according to coord_start\n errorcode: 0 label not found\n optional argument: firstlabel. If not given, it checks coordinate_start\n                                This is useful when called by Translation","parameters":[{"label":"$self"},{"label":"$label"},{"label":"$firstlabel"}],"label":"position($self,$label,$firstlabel)"},"detail":"($self,$label,$firstlabel)","kind":12,"children":[{"kind":13,"line":296,"containerName":"position","name":"$self","definition":"my","localvar":"my"},{"line":296,"kind":13,"name":"$label","containerName":"position"},{"kind":13,"line":296,"name":"$firstlabel","containerName":"position"},{"containerName":"position","name":"$self","line":297,"kind":13},{"containerName":"position","name":"valid","kind":12,"line":297},{"containerName":"position","name":"$label","kind":13,"line":297},{"name":"$self","containerName":"position","kind":13,"line":298},{"kind":12,"line":298,"name":"warn","containerName":"position"},{"containerName":"position","name":"$firstlabel","line":301,"kind":13},{"line":302,"kind":13,"containerName":"position","name":"$firstlabel"},{"line":302,"kind":13,"containerName":"position","name":"$self"},{"name":"coordinate_start","containerName":"position","kind":12,"line":302},{"name":"$label","containerName":"position","kind":13,"line":304},{"kind":13,"line":304,"containerName":"position","name":"$firstlabel"},{"localvar":"my","definition":"my","name":"$start","containerName":"position","line":307,"kind":13},{"containerName":"position","name":"$end","kind":13,"line":307},{"containerName":"position","name":"$strand","kind":13,"line":307},{"kind":13,"line":307,"containerName":"position","name":"$self"},{"kind":12,"line":307,"name":"start","containerName":"position"},{"kind":13,"line":307,"name":"$self","containerName":"position"},{"containerName":"position","name":"end","line":307,"kind":12},{"line":307,"kind":13,"containerName":"position","name":"$self"},{"containerName":"position","name":"strand","line":307,"kind":12},{"containerName":"position","definition":"my","name":"$position","localvar":"my","kind":13,"line":308},{"containerName":"position","name":"$in_pos","line":308,"kind":13},{"line":308,"kind":13,"name":"$out_pos","containerName":"position"},{"containerName":"position","name":"$coord_pos","line":308,"kind":13},{"containerName":"position","name":"$length","definition":"my","localvar":"my","kind":13,"line":309},{"containerName":"position","name":"$self","line":309,"kind":13},{"name":"length","containerName":"position","kind":12,"line":309},{"name":"$coord_pos","containerName":"position","line":310,"kind":13},{"name":"$self","containerName":"position","line":310,"kind":13},{"containerName":"position","name":"_inside_position","kind":12,"line":310},{"name":"$firstlabel","containerName":"position","kind":13,"line":310},{"containerName":"position","name":"$self","kind":13,"line":311},{"containerName":"position","name":"valid","line":311,"kind":12},{"containerName":"position","name":"$label","kind":13,"line":311},{"containerName":"position","name":"$in_pos","line":312,"kind":13},{"name":"$self","containerName":"position","kind":13,"line":312},{"kind":12,"line":312,"containerName":"position","name":"_inside_position"},{"name":"$label","containerName":"position","kind":13,"line":312},{"line":313,"kind":13,"name":"$position","containerName":"position"},{"line":313,"kind":13,"name":"$in_pos","containerName":"position"},{"line":313,"kind":13,"containerName":"position","name":"$coord_pos"},{"containerName":"position","name":"$position","kind":13,"line":314},{"name":"$position","containerName":"position","line":315,"kind":13},{"containerName":"position","name":"$self","kind":13,"line":318},{"kind":12,"line":318,"name":"follows","containerName":"position"},{"name":"$end","containerName":"position","line":318,"kind":13},{"name":"$label","containerName":"position","line":318,"kind":13},{"line":319,"kind":13,"containerName":"position","name":"$out_pos"},{"kind":13,"line":319,"containerName":"position","name":"$self"},{"name":"position","containerName":"position","line":319,"kind":12},{"line":319,"kind":13,"containerName":"position","name":"$label"},{"containerName":"position","name":"$end","kind":13,"line":319},{"name":"$strand","containerName":"position","kind":13,"line":319},{"containerName":"position","name":"$position","kind":13,"line":321},{"name":"$out_pos","containerName":"position","line":321,"kind":13},{"containerName":"position","name":"$length","line":321,"kind":13},{"line":321,"kind":13,"name":"$coord_pos","containerName":"position"},{"containerName":"position","name":"$self","kind":13,"line":322},{"kind":12,"line":322,"name":"follows","containerName":"position"},{"line":322,"kind":13,"containerName":"position","name":"$label"},{"line":322,"kind":13,"containerName":"position","name":"$start"},{"containerName":"position","name":"$out_pos","kind":13,"line":324},{"name":"$self","containerName":"position","line":324,"kind":13},{"name":"position","containerName":"position","line":324,"kind":12},{"line":324,"kind":13,"containerName":"position","name":"$label"},{"kind":13,"line":324,"containerName":"position","name":"$start"},{"line":324,"kind":13,"name":"$strand","containerName":"position"},{"containerName":"position","name":"$position","kind":13,"line":325},{"line":325,"kind":13,"name":"$out_pos","containerName":"position"},{"name":"$coord_pos","containerName":"position","kind":13,"line":325},{"line":327,"kind":13,"containerName":"position","name":"$self"},{"name":"warn","containerName":"position","kind":12,"line":327},{"containerName":"position","name":"$position","kind":13,"line":331}],"line":295},{"name":"seq","definition":"sub","containerName":"main::","range":{"start":{"line":334,"character":0},"end":{"line":342,"character":9999}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"seq","localvar":"my","kind":13,"line":335},{"definition":"my","name":"$exon","containerName":"seq","localvar":"my","kind":13,"line":336},{"kind":13,"line":336,"containerName":"seq","name":"$str"},{"kind":13,"line":337,"definition":"my","name":"@exons","containerName":"seq","localvar":"my"},{"containerName":"seq","name":"$self","line":337,"kind":13},{"containerName":"seq","name":"all_Exons","line":337,"kind":12},{"name":"$exon","containerName":"seq","line":338,"kind":13},{"kind":13,"line":338,"name":"@exons","containerName":"seq"},{"line":339,"kind":13,"containerName":"seq","name":"$str"},{"kind":13,"line":339,"name":"$exon","containerName":"seq"},{"containerName":"seq","name":"seq","line":339,"kind":12},{"containerName":"seq","name":"$str","line":341,"kind":13}],"line":334},{"containerName":"main::","name":"length","definition":"sub","range":{"start":{"character":0,"line":344},"end":{"line":352,"character":9999}},"kind":12,"line":344,"children":[{"line":345,"kind":13,"localvar":"my","containerName":"length","name":"$self","definition":"my"},{"containerName":"length","name":"$exon","definition":"my","localvar":"my","kind":13,"line":346},{"kind":13,"line":346,"name":"$length","containerName":"length"},{"name":"@exons","definition":"my","containerName":"length","localvar":"my","kind":13,"line":347},{"kind":13,"line":347,"name":"$self","containerName":"length"},{"name":"all_Exons","containerName":"length","kind":12,"line":347},{"containerName":"length","name":"$exon","kind":13,"line":348},{"kind":13,"line":348,"name":"@exons","containerName":"length"},{"name":"$length","containerName":"length","kind":13,"line":349},{"containerName":"length","name":"$exon","kind":13,"line":349},{"line":349,"kind":12,"name":"length","containerName":"length"},{"containerName":"length","name":"$length","line":351,"kind":13}]},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"all_labels","line":355,"kind":13},{"kind":13,"line":356,"name":"$exon","definition":"my","containerName":"all_labels","localvar":"my"},{"line":356,"kind":13,"containerName":"all_labels","name":"@labels"},{"line":357,"kind":13,"localvar":"my","name":"@exons","definition":"my","containerName":"all_labels"},{"name":"$self","containerName":"all_labels","kind":13,"line":357},{"name":"all_Exons","containerName":"all_labels","line":357,"kind":12},{"kind":13,"line":358,"name":"$exon","containerName":"all_labels"},{"kind":13,"line":358,"containerName":"all_labels","name":"@exons"},{"containerName":"all_labels","name":"@labels","line":359,"kind":13},{"kind":13,"line":359,"name":"$exon","containerName":"all_labels"},{"kind":12,"line":359,"name":"all_labels","containerName":"all_labels"},{"name":"@labels","containerName":"all_labels","line":361,"kind":13}],"line":354,"name":"all_labels","definition":"sub","containerName":"main::","range":{"end":{"line":362,"character":9999},"start":{"line":354,"character":0}}},{"range":{"start":{"character":0,"line":373},"end":{"character":9999,"line":397}},"name":"old_labelsubseq","line":373,"children":[{"line":374,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"old_labelsubseq"},{"line":374,"kind":13,"name":"$start","containerName":"old_labelsubseq"},{"kind":13,"line":374,"name":"$length","containerName":"old_labelsubseq"},{"kind":13,"line":374,"name":"$end","containerName":"old_labelsubseq"},{"containerName":"old_labelsubseq","definition":"my","name":"$pos1","localvar":"my","kind":13,"line":375},{"name":"$pos2","containerName":"old_labelsubseq","line":375,"kind":13},{"line":376,"kind":13,"containerName":"old_labelsubseq","name":"$start"},{"name":"$self","containerName":"old_labelsubseq","line":377,"kind":13},{"line":377,"kind":12,"name":"valid","containerName":"old_labelsubseq"},{"line":377,"kind":13,"containerName":"old_labelsubseq","name":"$start"},{"containerName":"old_labelsubseq","name":"$self","kind":13,"line":378},{"name":"warn","containerName":"old_labelsubseq","kind":12,"line":378},{"kind":13,"line":380,"name":"$pos1","containerName":"old_labelsubseq"},{"containerName":"old_labelsubseq","name":"$self","kind":13,"line":380},{"kind":12,"line":380,"name":"position","containerName":"old_labelsubseq"},{"line":380,"kind":13,"name":"$start","containerName":"old_labelsubseq"},{"kind":13,"line":382,"containerName":"old_labelsubseq","name":"$end"},{"line":383,"kind":13,"name":"$end","containerName":"old_labelsubseq"},{"name":"$start","containerName":"old_labelsubseq","line":383,"kind":13},{"kind":13,"line":384,"containerName":"old_labelsubseq","name":"$length"},{"containerName":"old_labelsubseq","name":"$self","kind":13,"line":386},{"name":"valid","containerName":"old_labelsubseq","line":386,"kind":12},{"line":386,"kind":13,"name":"$end","containerName":"old_labelsubseq"},{"name":"$self","containerName":"old_labelsubseq","kind":13,"line":387},{"kind":12,"line":387,"name":"warn","containerName":"old_labelsubseq"},{"containerName":"old_labelsubseq","name":"$self","line":389,"kind":13},{"name":"follows","containerName":"old_labelsubseq","kind":12,"line":389},{"containerName":"old_labelsubseq","name":"$start","line":389,"kind":13},{"line":389,"kind":13,"containerName":"old_labelsubseq","name":"$end"},{"kind":13,"line":390,"name":"$self","containerName":"old_labelsubseq"},{"containerName":"old_labelsubseq","name":"warn","kind":12,"line":390},{"name":"$pos2","containerName":"old_labelsubseq","kind":13,"line":392},{"containerName":"old_labelsubseq","name":"$self","kind":13,"line":392},{"containerName":"old_labelsubseq","name":"position","line":392,"kind":12},{"name":"$end","containerName":"old_labelsubseq","kind":13,"line":392},{"name":"$length","containerName":"old_labelsubseq","kind":13,"line":393},{"line":396,"kind":13,"containerName":"old_labelsubseq","name":"$self"},{"kind":12,"line":396,"containerName":"old_labelsubseq","name":"subseq"},{"containerName":"old_labelsubseq","name":"$pos1","kind":13,"line":396},{"kind":13,"line":396,"name":"$pos2","containerName":"old_labelsubseq"},{"name":"$length","containerName":"old_labelsubseq","line":396,"kind":13}],"kind":12,"detail":"($self,$start,$length,$end)","signature":{"parameters":[{"label":"$self"},{"label":"$start"},{"label":"$length"},{"label":"$end"}],"documentation":" redefined here so that it will retrieve effective subseq without introns\n otherwise it would have retrieved an underlying DNA (possibly with introns)\n subsequence\n Drawback: this is really bulky, label->position and then a call to\n subseq that will do the opposite position-> label\n\n one day this can be rewritten as the main one so that the normal subseq\n will rely on this one and hence avoid this double (useless and lengthy)\n conversion between labels and positions","label":"old_labelsubseq($self,$start,$length,$end)"},"containerName":"main::","definition":"sub"},{"name":"labelsubseq","range":{"start":{"line":401,"character":0},"end":{"character":9999,"line":475}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$start"},{"label":"$length"},{"label":"$end"},{"label":"$unsecuremode"}],"documentation":" rewritten, eventually","label":"labelsubseq($self,$start,$length,$end,$unsecuremode)"},"detail":"($self,$start,$length,$end,$unsecuremode)","kind":12,"children":[{"containerName":"labelsubseq","name":"$self","definition":"my","localvar":"my","kind":13,"line":402},{"containerName":"labelsubseq","name":"$start","line":402,"kind":13},{"containerName":"labelsubseq","name":"$length","line":402,"kind":13},{"kind":13,"line":402,"name":"$end","containerName":"labelsubseq"},{"line":402,"kind":13,"name":"$unsecuremode","containerName":"labelsubseq"},{"containerName":"labelsubseq","name":"$unsecuremode","kind":13,"line":403},{"kind":13,"line":404,"containerName":"labelsubseq","name":"$unsecuremode"},{"kind":13,"line":406,"name":"$start","containerName":"labelsubseq"},{"kind":13,"line":407,"name":"$self","containerName":"labelsubseq"},{"containerName":"labelsubseq","name":"valid","kind":12,"line":407},{"kind":13,"line":407,"name":"$start","containerName":"labelsubseq"},{"kind":13,"line":408,"name":"$self","containerName":"labelsubseq"},{"line":408,"kind":12,"name":"warn","containerName":"labelsubseq"},{"kind":13,"line":411,"containerName":"labelsubseq","name":"$start"},{"line":411,"kind":13,"name":"$self","containerName":"labelsubseq"},{"name":"start","containerName":"labelsubseq","kind":12,"line":411},{"containerName":"labelsubseq","name":"$end","line":413,"kind":13},{"name":"$end","containerName":"labelsubseq","line":414,"kind":13},{"kind":13,"line":414,"containerName":"labelsubseq","name":"$start"},{"name":"$length","containerName":"labelsubseq","line":415,"kind":13},{"containerName":"labelsubseq","name":"$end","kind":13,"line":416},{"kind":13,"line":418,"name":"$length","containerName":"labelsubseq"},{"name":"$self","containerName":"labelsubseq","kind":13,"line":419},{"name":"valid","containerName":"labelsubseq","kind":12,"line":419},{"kind":13,"line":419,"name":"$end","containerName":"labelsubseq"},{"containerName":"labelsubseq","name":"$self","kind":13,"line":420},{"name":"warn","containerName":"labelsubseq","kind":12,"line":420},{"line":422,"kind":13,"containerName":"labelsubseq","name":"$self"},{"line":422,"kind":12,"name":"follows","containerName":"labelsubseq"},{"kind":13,"line":422,"containerName":"labelsubseq","name":"$start"},{"line":422,"kind":13,"containerName":"labelsubseq","name":"$end"},{"line":423,"kind":13,"containerName":"labelsubseq","name":"$self"},{"line":423,"kind":12,"containerName":"labelsubseq","name":"warn"},{"kind":13,"line":427,"containerName":"labelsubseq","name":"$end"},{"name":"$self","containerName":"labelsubseq","line":427,"kind":13},{"kind":12,"line":427,"containerName":"labelsubseq","name":"end"},{"line":430,"kind":13,"localvar":"my","name":"$seq","definition":"my","containerName":"labelsubseq"},{"containerName":"labelsubseq","name":"$exon","line":430,"kind":13},{"line":430,"kind":13,"containerName":"labelsubseq","name":"$startexon"},{"name":"$endexon","containerName":"labelsubseq","kind":13,"line":430},{"line":430,"kind":13,"localvar":"my","containerName":"labelsubseq","name":"@exonlabels","definition":"my"},{"localvar":"my","definition":"my","name":"@exons","containerName":"labelsubseq","line":431,"kind":13},{"name":"$self","containerName":"labelsubseq","line":431,"kind":13},{"kind":12,"line":431,"name":"all_Exons","containerName":"labelsubseq"},{"kind":13,"line":433,"containerName":"labelsubseq","name":"$exon"},{"containerName":"labelsubseq","name":"@exons","kind":13,"line":433},{"name":"$startexon","containerName":"labelsubseq","kind":13,"line":434},{"name":"$exon","containerName":"labelsubseq","line":434,"kind":13},{"line":434,"kind":12,"containerName":"labelsubseq","name":"valid"},{"containerName":"labelsubseq","name":"$start","line":434,"kind":13},{"containerName":"labelsubseq","name":"$startexon","kind":13,"line":435},{"name":"$exon","containerName":"labelsubseq","line":435,"kind":13},{"line":437,"kind":13,"containerName":"labelsubseq","name":"$exon"},{"name":"valid","containerName":"labelsubseq","kind":12,"line":437},{"line":437,"kind":13,"name":"$end","containerName":"labelsubseq"},{"name":"$endexon","containerName":"labelsubseq","line":438,"kind":13},{"name":"$exon","containerName":"labelsubseq","line":438,"kind":13},{"kind":13,"line":440,"name":"$seq","containerName":"labelsubseq"},{"containerName":"labelsubseq","name":"$startexon","line":440,"kind":13},{"containerName":"labelsubseq","name":"$endexon","line":441,"kind":13},{"containerName":"labelsubseq","name":"$endexon","kind":13,"line":441},{"line":441,"kind":13,"containerName":"labelsubseq","name":"$startexon"},{"name":"$length","containerName":"labelsubseq","line":442,"kind":13},{"containerName":"labelsubseq","name":"$seq","line":443,"kind":13},{"name":"$startexon","containerName":"labelsubseq","kind":13,"line":443},{"name":"labelsubseq","containerName":"labelsubseq","kind":12,"line":443},{"name":"$start","containerName":"labelsubseq","kind":13,"line":443},{"name":"$length","containerName":"labelsubseq","kind":13,"line":443},{"containerName":"labelsubseq","name":"$seq","kind":13,"line":448},{"containerName":"labelsubseq","name":"$startexon","line":448,"kind":13},{"name":"labelsubseq","containerName":"labelsubseq","line":448,"kind":12},{"containerName":"labelsubseq","name":"$start","kind":13,"line":448},{"name":"$end","containerName":"labelsubseq","kind":13,"line":448},{"name":"$seq","containerName":"labelsubseq","line":452,"kind":13},{"line":452,"kind":13,"containerName":"labelsubseq","name":"$startexon"},{"kind":12,"line":452,"name":"labelsubseq","containerName":"labelsubseq"},{"containerName":"labelsubseq","name":"$start","kind":13,"line":452},{"containerName":"labelsubseq","name":"$startexon","line":455,"kind":13},{"containerName":"labelsubseq","name":"$exon","kind":13,"line":455},{"line":455,"kind":13,"containerName":"labelsubseq","name":"$startexon"},{"kind":13,"line":456,"containerName":"labelsubseq","name":"$endexon"},{"kind":13,"line":457,"containerName":"labelsubseq","name":"$seq"},{"kind":13,"line":457,"name":"$endexon","containerName":"labelsubseq"},{"kind":12,"line":457,"name":"labelsubseq","containerName":"labelsubseq"},{"name":"$end","containerName":"labelsubseq","kind":13,"line":457},{"kind":13,"line":460,"name":"$startexon","containerName":"labelsubseq"},{"kind":13,"line":461,"containerName":"labelsubseq","name":"$seq"},{"line":461,"kind":13,"name":"$exon","containerName":"labelsubseq"},{"kind":12,"line":461,"containerName":"labelsubseq","name":"seq"},{"line":463,"kind":13,"name":"$length","containerName":"labelsubseq"},{"kind":13,"line":464,"containerName":"labelsubseq","name":"$seq"},{"kind":13,"line":464,"containerName":"labelsubseq","name":"$seq"},{"name":"$length","containerName":"labelsubseq","line":464,"kind":13},{"name":"$length","containerName":"labelsubseq","kind":13,"line":470},{"kind":13,"line":471,"name":"$seq","containerName":"labelsubseq"},{"line":471,"kind":13,"containerName":"labelsubseq","name":"$length"},{"name":"$seq","containerName":"labelsubseq","line":473,"kind":13}],"line":401},{"kind":12,"line":432,"name":"EXONCHECK"},{"line":446,"kind":12,"name":"EXONCHECK"},{"kind":12,"line":450,"name":"EXONCHECK"},{"line":458,"kind":12,"name":"EXONCHECK"},{"name":"CORE","containerName":"length","line":464,"kind":12},{"name":"EXONCHECK","kind":12,"line":465},{"name":"in_which_Exon","range":{"start":{"character":0,"line":481},"end":{"character":9999,"line":492}},"definition":"sub","containerName":"main::","signature":{"documentation":" argument: label\n returns: the objref and progressive number of the Exon containing that label\n errorcode: -1","parameters":[{"label":"$self"},{"label":"$label"}],"label":"in_which_Exon($self,$label)"},"detail":"($self,$label)","kind":12,"children":[{"localvar":"my","containerName":"in_which_Exon","name":"$self","definition":"my","line":482,"kind":13},{"name":"$label","containerName":"in_which_Exon","line":482,"kind":13},{"line":483,"kind":13,"localvar":"my","containerName":"in_which_Exon","definition":"my","name":"$count"},{"line":483,"kind":13,"name":"$exon","containerName":"in_which_Exon"},{"line":484,"kind":13,"localvar":"my","definition":"my","name":"@exons","containerName":"in_which_Exon"},{"kind":13,"line":484,"name":"$self","containerName":"in_which_Exon"},{"name":"all_Exons","containerName":"in_which_Exon","line":484,"kind":12},{"name":"$exon","containerName":"in_which_Exon","kind":13,"line":485},{"line":485,"kind":13,"name":"@exons","containerName":"in_which_Exon"},{"kind":13,"line":486,"containerName":"in_which_Exon","name":"$count"},{"line":487,"kind":13,"containerName":"in_which_Exon","name":"$exon"},{"line":487,"kind":12,"name":"valid","containerName":"in_which_Exon"},{"containerName":"in_which_Exon","name":"$label","kind":13,"line":487},{"name":"$exon","containerName":"in_which_Exon","kind":13,"line":488},{"kind":13,"line":488,"name":"$count","containerName":"in_which_Exon"}],"line":481},{"range":{"start":{"line":496,"character":0},"end":{"character":9999,"line":537}},"name":"subseq","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"subseq","line":497,"kind":13},{"kind":13,"line":497,"name":"$pos1","containerName":"subseq"},{"containerName":"subseq","name":"$pos2","line":497,"kind":13},{"line":497,"kind":13,"containerName":"subseq","name":"$length"},{"kind":13,"line":498,"definition":"my","name":"$str","containerName":"subseq","localvar":"my"},{"containerName":"subseq","name":"$startlabel","line":498,"kind":13},{"kind":13,"line":498,"name":"$endlabel","containerName":"subseq"},{"name":"$pos1","containerName":"subseq","line":499,"kind":13},{"kind":13,"line":500,"name":"$pos1","containerName":"subseq"},{"kind":13,"line":501,"containerName":"subseq","name":"$self"},{"name":"warn","containerName":"subseq","line":501,"kind":12},{"containerName":"subseq","name":"$pos2","kind":13,"line":503},{"line":503,"kind":13,"containerName":"subseq","name":"$pos1"},{"line":503,"kind":13,"name":"$pos2","containerName":"subseq"},{"line":504,"kind":13,"name":"$self","containerName":"subseq"},{"line":504,"kind":12,"name":"warn","containerName":"subseq"},{"name":"$startlabel","containerName":"subseq","kind":13,"line":506},{"name":"$self","containerName":"subseq","kind":13,"line":506},{"containerName":"subseq","name":"label","kind":12,"line":506},{"containerName":"subseq","name":"$pos1","line":506,"kind":13},{"kind":13,"line":507,"containerName":"subseq","name":"$self"},{"kind":12,"line":507,"name":"valid","containerName":"subseq"},{"containerName":"subseq","name":"$startlabel","line":507,"kind":13},{"containerName":"subseq","name":"$self","kind":13,"line":508},{"kind":12,"line":508,"name":"warn","containerName":"subseq"},{"containerName":"subseq","name":"$startlabel","kind":13,"line":510},{"kind":13,"line":511,"name":"$self","containerName":"subseq"},{"kind":12,"line":511,"containerName":"subseq","name":"warn"},{"kind":13,"line":514,"containerName":"subseq","name":"$startlabel"},{"containerName":"subseq","name":"$self","line":514,"kind":13},{"kind":12,"line":514,"name":"start","containerName":"subseq"},{"kind":13,"line":516,"name":"$pos2","containerName":"subseq"},{"containerName":"subseq","name":"$pos2","kind":13,"line":517},{"name":"$self","containerName":"subseq","line":518,"kind":13},{"name":"warn","containerName":"subseq","line":518,"kind":12},{"line":520,"kind":13,"containerName":"subseq","name":"$length"},{"kind":13,"line":521,"name":"$pos1","containerName":"subseq"},{"containerName":"subseq","name":"$pos1","kind":13,"line":521},{"name":"$pos2","containerName":"subseq","kind":13,"line":521},{"name":"$self","containerName":"subseq","kind":13,"line":522},{"kind":12,"line":522,"containerName":"subseq","name":"warn"},{"kind":13,"line":524,"name":"$endlabel","containerName":"subseq"},{"name":"$self","containerName":"subseq","line":524,"kind":13},{"line":524,"kind":12,"containerName":"subseq","name":"label"},{"containerName":"subseq","name":"$pos2","line":524,"kind":13},{"line":525,"kind":13,"containerName":"subseq","name":"$self"},{"name":"valid","containerName":"subseq","kind":12,"line":525},{"name":"$endlabel","containerName":"subseq","line":525,"kind":13},{"containerName":"subseq","name":"$self","line":526,"kind":13},{"kind":12,"line":526,"containerName":"subseq","name":"warn"},{"containerName":"subseq","name":"$endlabel","line":528,"kind":13},{"name":"$self","containerName":"subseq","kind":13,"line":529},{"line":529,"kind":12,"containerName":"subseq","name":"warn"},{"containerName":"subseq","name":"$length","line":532,"kind":13},{"kind":13,"line":533,"name":"$endlabel","containerName":"subseq"},{"name":"$self","containerName":"subseq","line":533,"kind":13},{"containerName":"subseq","name":"end","line":533,"kind":12},{"containerName":"subseq","name":"$self","line":536,"kind":13},{"line":536,"kind":12,"name":"labelsubseq","containerName":"subseq"},{"line":536,"kind":13,"containerName":"subseq","name":"$startlabel"},{"name":"$length","containerName":"subseq","kind":13,"line":536},{"line":536,"kind":13,"name":"$endlabel","containerName":"subseq"}],"line":496,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$pos1"},{"label":"$pos2"},{"label":"$length"}],"documentation":" recoded to exploit the new fast labelsubseq()\n valid only inside Transcript","label":"subseq($self,$pos1,$pos2,$length)"},"detail":"($self,$pos1,$pos2,$length)","definition":"sub","containerName":"main::"},{"children":[{"definition":"my","name":"$self","containerName":"old_subseq","localvar":"my","kind":13,"line":541},{"name":"$pos1","containerName":"old_subseq","kind":13,"line":541},{"name":"$pos2","containerName":"old_subseq","line":541,"kind":13},{"name":"$length","containerName":"old_subseq","kind":13,"line":541},{"localvar":"my","name":"$str","definition":"my","containerName":"old_subseq","line":542,"kind":13},{"kind":13,"line":542,"containerName":"old_subseq","name":"$startcount"},{"containerName":"old_subseq","name":"$endcount","kind":13,"line":542},{"line":542,"kind":13,"name":"$seq","containerName":"old_subseq"},{"kind":13,"line":542,"containerName":"old_subseq","name":"$seqlength"},{"containerName":"old_subseq","name":"$length","line":543,"kind":13},{"line":544,"kind":13,"containerName":"old_subseq","name":"$length"},{"containerName":"old_subseq","name":"$self","kind":13,"line":545},{"kind":12,"line":545,"name":"warn","containerName":"old_subseq"},{"kind":13,"line":549,"containerName":"old_subseq","name":"$firstlabel","definition":"my","localvar":"my"},{"name":"$self","containerName":"old_subseq","kind":13,"line":549},{"kind":12,"line":549,"name":"coordinate_start","containerName":"old_subseq"},{"containerName":"old_subseq","definition":"my","name":"$coord_pos","localvar":"my","kind":13,"line":550},{"name":"$self","containerName":"old_subseq","kind":13,"line":550},{"kind":12,"line":550,"name":"_inside_position","containerName":"old_subseq"},{"name":"$firstlabel","containerName":"old_subseq","line":550,"kind":13},{"kind":13,"line":551,"containerName":"old_subseq","name":"$seq"},{"line":551,"kind":13,"name":"$self","containerName":"old_subseq"},{"line":551,"kind":12,"name":"seq","containerName":"old_subseq"},{"name":"$seqlength","containerName":"old_subseq","kind":13,"line":552},{"kind":13,"line":552,"name":"$seq","containerName":"old_subseq"},{"name":"$pos1","containerName":"old_subseq","kind":13,"line":553},{"line":554,"kind":13,"containerName":"old_subseq","name":"$startcount"},{"kind":13,"line":554,"name":"$coord_pos","containerName":"old_subseq"},{"name":"$pos1","containerName":"old_subseq","line":556,"kind":13},{"name":"$self","containerName":"old_subseq","kind":13,"line":557},{"containerName":"old_subseq","name":"warn","kind":12,"line":557},{"name":"$pos1","containerName":"old_subseq","line":558,"kind":13},{"line":559,"kind":13,"name":"$pos1","containerName":"old_subseq"},{"name":"$pos2","containerName":"old_subseq","kind":13,"line":561},{"line":561,"kind":13,"name":"$pos1","containerName":"old_subseq"},{"name":"$pos2","containerName":"old_subseq","line":561,"kind":13},{"line":562,"kind":13,"containerName":"old_subseq","name":"$self"},{"containerName":"old_subseq","name":"warn","kind":12,"line":562},{"line":565,"kind":13,"name":"$startcount","containerName":"old_subseq"},{"line":565,"kind":13,"containerName":"old_subseq","name":"$pos1"},{"containerName":"old_subseq","name":"$coord_pos","kind":13,"line":565},{"containerName":"old_subseq","name":"$pos2","line":567,"kind":13},{"line":570,"kind":13,"containerName":"old_subseq","name":"$pos2"},{"kind":13,"line":571,"containerName":"old_subseq","name":"$self"},{"kind":12,"line":571,"containerName":"old_subseq","name":"warn"},{"kind":13,"line":572,"containerName":"old_subseq","name":"$pos2"},{"name":"$pos2","containerName":"old_subseq","line":573,"kind":13},{"name":"$pos1","containerName":"old_subseq","line":575,"kind":13},{"name":"$pos1","containerName":"old_subseq","line":575,"kind":13},{"kind":13,"line":575,"name":"$pos2","containerName":"old_subseq"},{"name":"$self","containerName":"old_subseq","kind":13,"line":576},{"kind":12,"line":576,"containerName":"old_subseq","name":"warn"},{"kind":13,"line":579,"name":"$endcount","containerName":"old_subseq"},{"line":579,"kind":13,"containerName":"old_subseq","name":"$pos2"},{"name":"$coord_pos","containerName":"old_subseq","line":579,"kind":13},{"name":"$endcount","containerName":"old_subseq","line":580,"kind":13},{"line":580,"kind":13,"containerName":"old_subseq","name":"$seqlength"},{"kind":13,"line":582,"name":"$self","containerName":"old_subseq"},{"kind":12,"line":582,"name":"warn","containerName":"old_subseq"},{"line":585,"kind":13,"name":"$length","containerName":"old_subseq"},{"kind":13,"line":585,"containerName":"old_subseq","name":"$endcount"},{"kind":13,"line":585,"containerName":"old_subseq","name":"$startcount"},{"kind":13,"line":588,"definition":"my","name":"$offset","containerName":"old_subseq","localvar":"my"},{"kind":13,"line":588,"containerName":"old_subseq","name":"$startcount"},{"name":"$offset","containerName":"old_subseq","line":589,"kind":13},{"kind":13,"line":590,"containerName":"old_subseq","name":"$self"},{"line":590,"kind":12,"name":"warn","containerName":"old_subseq"},{"containerName":"old_subseq","name":"$seq","line":591,"kind":13},{"name":"$length","containerName":"old_subseq","kind":13,"line":591},{"containerName":"old_subseq","name":"$offset","kind":13,"line":592},{"name":"$seqlength","containerName":"old_subseq","line":592,"kind":13},{"line":593,"kind":13,"name":"$self","containerName":"old_subseq"},{"name":"warn","containerName":"old_subseq","kind":12,"line":593},{"line":596,"kind":13,"name":"$str","containerName":"old_subseq"},{"containerName":"old_subseq","name":"$seq","kind":13,"line":596},{"line":596,"kind":13,"name":"$offset","containerName":"old_subseq"},{"line":596,"kind":13,"containerName":"old_subseq","name":"$length"},{"containerName":"old_subseq","name":"$str","line":597,"kind":13},{"line":597,"kind":13,"containerName":"old_subseq","name":"$length"},{"line":598,"kind":13,"name":"$self","containerName":"old_subseq"},{"containerName":"old_subseq","name":"warn","line":598,"kind":12},{"containerName":"old_subseq","name":"$self","kind":13,"line":599},{"containerName":"old_subseq","name":"verbose","line":599,"kind":12},{"line":601,"kind":13,"containerName":"old_subseq","name":"$str"}],"line":540,"kind":12,"signature":{"documentation":" works only inside the transcript, complains if asked outside","parameters":[{"label":"$self"},{"label":"$pos1"},{"label":"$pos2"},{"label":"$length"}],"label":"old_subseq($self,$pos1,$pos2,$length)"},"detail":"($self,$pos1,$pos2,$length)","definition":"sub","containerName":"main::","range":{"end":{"line":603,"character":9999},"start":{"character":0,"line":540}},"name":"old_subseq"},{"name":"CORE","containerName":"length","line":552,"kind":12},{"line":597,"kind":12,"name":"CORE","containerName":"length"},{"range":{"end":{"character":9999,"line":610},"start":{"character":0,"line":607}},"definition":"sub","name":"start","containerName":"main::","children":[{"line":608,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"start"},{"line":609,"kind":13,"localvar":"my","definition":"my","name":"$exonsref","containerName":"start"},{"containerName":"start","name":"$self","kind":13,"line":609},{"kind":13,"line":610,"name":"@exons","definition":"my","containerName":"start","localvar":"my"},{"name":"$exonsref","containerName":"start","line":610,"kind":13}],"line":607,"kind":12},{"kind":13,"line":611,"containerName":null,"name":"@exons"},{"line":611,"kind":12,"name":"start","containerName":"main::"},{"range":{"end":{"character":9999,"line":617},"start":{"line":614,"character":0}},"definition":"sub","name":"end","containerName":"main::","children":[{"containerName":"end","name":"$self","definition":"my","localvar":"my","kind":13,"line":615},{"kind":13,"line":616,"containerName":"end","name":"$exonsref","definition":"my","localvar":"my"},{"name":"$self","containerName":"end","line":616,"kind":13},{"line":617,"kind":13,"localvar":"my","containerName":"end","name":"@exons","definition":"my"},{"name":"$exonsref","containerName":"end","kind":13,"line":617}],"line":614,"kind":12},{"containerName":null,"name":"@exons","line":618,"kind":13},{"name":"end","containerName":"main::","line":618,"kind":12},{"range":{"start":{"line":628,"character":0},"end":{"character":9999,"line":640}},"name":"_inside_position","children":[{"line":629,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_inside_position"},{"containerName":"_inside_position","name":"$label","line":629,"kind":13},{"definition":"my","name":"$start","containerName":"_inside_position","localvar":"my","kind":13,"line":630},{"name":"$end","containerName":"_inside_position","line":630,"kind":13},{"name":"$strand","containerName":"_inside_position","line":630,"kind":13},{"line":630,"kind":13,"containerName":"_inside_position","name":"$self"},{"line":630,"kind":12,"name":"start","containerName":"_inside_position"},{"name":"$self","containerName":"_inside_position","line":630,"kind":13},{"line":630,"kind":12,"containerName":"_inside_position","name":"end"},{"name":"$self","containerName":"_inside_position","kind":13,"line":630},{"kind":12,"line":630,"containerName":"_inside_position","name":"strand"},{"line":631,"kind":13,"localvar":"my","name":"$position","definition":"my","containerName":"_inside_position"},{"line":631,"kind":13,"containerName":"_inside_position","name":"$checkme"},{"kind":13,"line":632,"containerName":"_inside_position","name":"@labels","definition":"my","localvar":"my"},{"line":632,"kind":13,"name":"$self","containerName":"_inside_position"},{"containerName":"_inside_position","name":"all_labels","line":632,"kind":12},{"name":"$checkme","containerName":"_inside_position","kind":13,"line":633},{"name":"@labels","containerName":"_inside_position","kind":13,"line":633},{"name":"$position","containerName":"_inside_position","line":634,"kind":13},{"name":"$label","containerName":"_inside_position","kind":13,"line":635},{"name":"$checkme","containerName":"_inside_position","line":635,"kind":13},{"kind":13,"line":636,"name":"$position","containerName":"_inside_position"}],"line":628,"kind":12,"signature":{"label":"_inside_position($self,$label)","parameters":[{"label":"$self"},{"label":"$label"}],"documentation":" internal methods begin here\n returns: position of label in transcript's all_labels\n          with STARTlabel == 1\n errorcode 0 -> label not found\n argument: label"},"detail":"($self,$label)","definition":"sub","containerName":"main::"},{"children":[{"definition":"my","name":"$exon","containerName":"_checkexons","localvar":"my","kind":13,"line":645},{"kind":13,"line":645,"containerName":"_checkexons","name":"$thisstart"},{"containerName":"_checkexons","definition":"my","name":"$self","localvar":"my","kind":13,"line":646},{"line":646,"kind":13,"name":"$exon","containerName":"_checkexons"},{"localvar":"my","containerName":"_checkexons","definition":"my","name":"$exonsref","line":647,"kind":13},{"containerName":"_checkexons","name":"@exons","definition":"my","localvar":"my","kind":13,"line":648},{"name":"$exonsref","containerName":"_checkexons","kind":13,"line":648}],"line":644,"kind":12,"range":{"start":{"line":644,"character":0},"end":{"character":9999,"line":648}},"definition":"sub","name":"_checkexons","containerName":"main::"},{"name":"$firstexon","definition":"my","containerName":null,"localvar":"my","kind":13,"line":650},{"containerName":null,"name":"@exons","kind":13,"line":650},{"line":652,"kind":13,"containerName":null,"name":"%firstexon"},{"name":"$self","containerName":null,"line":653,"kind":13},{"containerName":"main::","name":"warn","kind":12,"line":653},{"line":656,"kind":13,"localvar":"my","containerName":null,"name":"$strand","definition":"my"},{"kind":13,"line":656,"name":"$firstexon","containerName":null},{"name":"strand","containerName":"main::","kind":12,"line":656},{"line":658,"kind":13,"localvar":"my","containerName":null,"name":"$prevend","definition":"my"},{"name":"$firstexon","containerName":null,"kind":13,"line":658},{"kind":12,"line":658,"name":"end","containerName":"main::"},{"containerName":null,"name":"@exons","line":659,"kind":13},{"containerName":null,"name":"$exon","line":660,"kind":13},{"kind":13,"line":660,"containerName":null,"name":"@exons"},{"line":661,"kind":13,"name":"%exon","containerName":null},{"kind":13,"line":662,"name":"$self","containerName":null},{"line":662,"kind":12,"containerName":"main::","name":"warn"},{"containerName":null,"name":"$exon","line":665,"kind":13},{"line":665,"kind":12,"name":"strand","containerName":"main::"},{"name":"%strand","containerName":null,"line":665,"kind":13},{"kind":13,"line":666,"name":"$self","containerName":null},{"name":"warn","containerName":"main::","kind":12,"line":666},{"kind":13,"line":669,"name":"$thisstart","containerName":null},{"kind":13,"line":669,"name":"$exon","containerName":null},{"name":"start","containerName":"main::","line":669,"kind":12},{"kind":13,"line":670,"containerName":null,"name":"%exon"},{"kind":12,"line":670,"name":"follows","containerName":"main::"},{"name":"$prevend","containerName":null,"kind":13,"line":670},{"kind":13,"line":670,"name":"$thisstart","containerName":null},{"kind":13,"line":670,"containerName":null,"name":"%strand"},{"line":671,"kind":13,"name":"$self","containerName":null},{"name":"warn","containerName":"main::","kind":12,"line":671},{"name":"$prevend","containerName":null,"kind":13,"line":674},{"containerName":null,"name":"$exon","line":674,"kind":13},{"containerName":"main::","name":"end","line":674,"kind":12},{"kind":12,"line":690,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"get_Translation","line":691,"kind":13},{"kind":13,"line":692,"containerName":"get_Translation","name":"$self"}],"containerName":"main::","name":"get_Translation","definition":"sub","range":{"start":{"character":0,"line":690},"end":{"character":9999,"line":693}}},{"range":{"start":{"character":0,"line":699},"end":{"character":9999,"line":702}},"name":"_deletecheck","children":[{"kind":13,"line":700,"definition":"my","name":"$self","containerName":"_deletecheck","localvar":"my"},{"kind":13,"line":700,"name":"$startlabel","containerName":"_deletecheck"},{"kind":13,"line":700,"containerName":"_deletecheck","name":"$endlabel"},{"line":701,"kind":13,"localvar":"my","containerName":"_deletecheck","definition":"my","name":"$exonsref"},{"name":"$self","containerName":"_deletecheck","line":701,"kind":13},{"kind":13,"line":702,"containerName":"_deletecheck","name":"@exons","definition":"my","localvar":"my"},{"name":"$exonsref","containerName":"_deletecheck","kind":13,"line":702}],"line":699,"kind":12,"signature":{"label":"_deletecheck($self,$startlabel,$endlabel)","documentation":" this checks so that deletion spanning multiple exons is\n handled accordingly and correctly\n arguments: begin and end label of a deletion\n this is called BEFORE any deletion in the chain","parameters":[{"label":"$self"},{"label":"$startlabel"},{"label":"$endlabel"}]},"detail":"($self,$startlabel,$endlabel)","definition":"sub","containerName":"main::"},{"line":703,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$startexon"},{"line":703,"kind":13,"name":"$endexon","containerName":null},{"kind":13,"line":703,"name":"$exon","containerName":null},{"containerName":null,"name":"$startexon","kind":13,"line":704},{"kind":13,"line":704,"containerName":null,"name":"$endexon"},{"name":"$exon","containerName":null,"kind":13,"line":705},{"name":"@exons","containerName":null,"kind":13,"line":705},{"name":"$startexon","containerName":null,"kind":13,"line":706},{"line":706,"kind":13,"containerName":null,"name":"$exon"},{"containerName":"main::","name":"valid","line":706,"kind":12},{"containerName":null,"name":"%startlabel","line":706,"kind":13},{"name":"$startexon","containerName":null,"line":707,"kind":13},{"line":707,"kind":13,"containerName":null,"name":"$exon"},{"containerName":null,"name":"$endexon","line":709,"kind":13},{"containerName":null,"name":"$exon","line":709,"kind":13},{"name":"valid","containerName":"main::","kind":12,"line":709},{"containerName":null,"name":"%endlabel","kind":13,"line":709},{"containerName":null,"name":"$endexon","kind":13,"line":710},{"line":710,"kind":13,"containerName":null,"name":"$exon"},{"line":712,"kind":13,"containerName":null,"name":"$startexon"},{"containerName":null,"name":"%endexon","line":712,"kind":13},{"definition":"my","name":"$nextend","containerName":null,"localvar":"my","kind":13,"line":716},{"line":716,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":716,"containerName":"main::","name":"label"},{"name":"$endlabel","containerName":null,"kind":13,"line":716},{"line":717,"kind":13,"localvar":"my","definition":"my","name":"$prevstart","containerName":null},{"name":"$self","containerName":null,"kind":13,"line":717},{"kind":12,"line":717,"name":"label","containerName":"main::"},{"kind":13,"line":717,"containerName":null,"name":"$startlabel"},{"containerName":null,"name":"$startexon","kind":13,"line":719},{"kind":13,"line":719,"name":"%endexon","containerName":null},{"line":720,"kind":13,"name":"$startexon","containerName":null},{"containerName":"main::","name":"start","kind":12,"line":720},{"line":720,"kind":13,"name":"$startlabel","containerName":null},{"containerName":null,"name":"$startexon","line":720,"kind":13},{"containerName":"main::","name":"end","line":720,"kind":12},{"name":"%endlabel","containerName":null,"kind":13,"line":720},{"containerName":null,"name":"@newexons","definition":"my","localvar":"my","kind":13,"line":722},{"kind":13,"line":723,"name":"$exon","containerName":null},{"kind":13,"line":723,"name":"@exons","containerName":null},{"line":724,"kind":13,"containerName":null,"name":"$exon"},{"containerName":null,"name":"%startexon","kind":13,"line":724},{"line":725,"kind":13,"name":"@newexons","containerName":null},{"name":"$exon","containerName":null,"kind":13,"line":725},{"containerName":null,"name":"%self","line":728,"kind":13},{"line":728,"kind":13,"name":"@newexons","containerName":null},{"line":729,"kind":13,"name":"$startexon","containerName":null},{"kind":12,"line":729,"containerName":"main::","name":"start"},{"name":"%startlabel","containerName":null,"kind":13,"line":729},{"containerName":null,"name":"%startexon","kind":13,"line":730},{"name":"$nextend","containerName":null,"kind":13,"line":730},{"name":"$startexon","containerName":null,"line":731,"kind":13},{"kind":12,"line":731,"containerName":"main::","name":"end"},{"line":731,"kind":13,"name":"%endlabel","containerName":null},{"name":"%startexon","containerName":null,"kind":13,"line":732},{"line":732,"kind":13,"name":"%prevstart","containerName":null},{"kind":13,"line":737,"containerName":null,"definition":"my","name":"@newexons","localvar":"my"},{"localvar":"my","containerName":null,"definition":"my","name":"$exonobj","line":738,"kind":13},{"definition":"my","name":"$dna","containerName":null,"localvar":"my","kind":13,"line":739},{"name":"%self","containerName":null,"kind":13,"line":739},{"name":"$strand","definition":"my","containerName":null,"localvar":"my","kind":13,"line":740},{"containerName":null,"name":"$self","kind":13,"line":740},{"containerName":"main::","name":"strand","line":740,"kind":12},{"localvar":"my","name":"$notmiddle","definition":"my","containerName":null,"line":741,"kind":13},{"kind":13,"line":742,"containerName":null,"name":"$exon"},{"line":742,"kind":13,"containerName":null,"name":"@exons"},{"line":743,"kind":13,"containerName":null,"name":"$exon"},{"containerName":null,"name":"%startexon","kind":13,"line":743},{"line":744,"kind":13,"name":"$exonobj","containerName":null},{"name":"Bio","containerName":"LiveSeq::Exon","line":744,"kind":12},{"containerName":"main::","name":"new","kind":12,"line":744},{"name":"$dna","containerName":null,"kind":13,"line":744},{"containerName":null,"name":"$exon","kind":13,"line":744},{"name":"start","containerName":"main::","line":744,"kind":12},{"line":744,"kind":13,"containerName":null,"name":"$prevstart"},{"line":744,"kind":13,"name":"$strand","containerName":null},{"containerName":null,"name":"@newexons","kind":13,"line":745},{"name":"$exonobj","containerName":null,"line":745,"kind":13},{"kind":13,"line":746,"name":"$notmiddle","containerName":null},{"name":"$exon","containerName":null,"kind":13,"line":747},{"line":747,"kind":13,"name":"%endexon","containerName":null},{"kind":13,"line":748,"containerName":null,"name":"$exonobj"},{"line":748,"kind":12,"name":"Bio","containerName":"LiveSeq::Exon"},{"name":"new","containerName":"main::","kind":12,"line":748},{"name":"$dna","containerName":null,"kind":13,"line":748},{"containerName":null,"name":"$nextend","line":748,"kind":13},{"line":748,"kind":13,"containerName":null,"name":"$exon"},{"kind":12,"line":748,"name":"end","containerName":"main::"},{"line":748,"kind":13,"containerName":null,"name":"$strand"},{"line":749,"kind":13,"containerName":null,"name":"@newexons"},{"containerName":null,"name":"$exonobj","line":749,"kind":13},{"kind":13,"line":750,"name":"%notmiddle","containerName":null},{"kind":13,"line":752,"containerName":null,"name":"%notmiddle"},{"kind":13,"line":753,"name":"@newexons","containerName":null},{"containerName":null,"name":"$exon","line":753,"kind":13},{"kind":13,"line":757,"containerName":null,"name":"%self"},{"name":"@newexons","containerName":null,"line":757,"kind":13},{"range":{"end":{"line":783,"character":9999},"start":{"character":0,"line":773}},"name":"translation_table","signature":{"label":"translation_table($self,$value)","documentation":"1;\n# $Id: Transcript.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Transcript - Transcript class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis stores informations about coding sequences (CDS).\nThe implementation is that a Transcript object accesses a collection of\nExon objects, inferring from them the nucleotide structure and sequence.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Transcript;\n\nuse strict;\n# use Carp qw(carp cluck);\nuse Bio::LiveSeq::Exon; # uses Exon to create new exon in case of deletion\nuse base qw(Bio::LiveSeq::SeqI);\n\n=head2 new\n\n  Title   : new\n  Usage   : $transcript = Bio::LiveSeq::Transcript->new(-exons => \\@obj_refs);\n\n  Function: generates a new Bio::LiveSeq::Transcript\n  Returns : reference to a new object of class Transcript\n  Errorcode -1\n  Args    : reference to an array of Exon object references\n\n\nsub new {\n  my ($thing, %args) = @_;\n  my $class = ref($thing) || $thing;\n  my ($obj,%transcript);\n\n  my @exons=@{$args{-exons}};\n\n  $obj = \\%transcript;\n  $obj = bless $obj, $class;\n\n  unless (@exons) {\n    $obj->warn(\"$class not initialised because exons array empty\");\n    return(-1);\n  }\n\n  # now useless, after start and end methods have been overridden here\n  my $firstexon = $exons[0];\n  #my $lastexon = $exons[-1];\n  #my $start = $firstexon->start;\n  #my $end = $lastexon->end;\n  my $strand = $firstexon->strand;\n  my $seq = $firstexon->{'seq'};\n  $obj->alphabet('rna');\n\n  unless (_checkexons(\\@exons)) {\n    $obj->warn(\"$class not initialised because of problems in the exon structure\");\n    return(-1);\n  }\n  $obj->{'strand'}=$strand;\n  $obj->{'exons'}=\\@exons;\n  $obj->{'seq'}=$seq;\n\n  # set Transcript into each Exon\n  my $exon;\n  foreach $exon (@exons) {\n    $exon->{'transcript'}=$obj;\n  }\n  return $obj;\n}\n\n\n=head2 all_Exons\n\n Title   : all_Exons\n Usage   : $transcript_obj->all_Exons()\n Function: returns references to all Exon objects the Transcript is composed of\n Example : foreach $exon ($transcript->all_Exons()) { do_something }\n Returns : array of object references\n Args    : none\n\n\nsub all_Exons {\n  my $self=shift;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  my @newexons;\n  my $exon;\n  foreach $exon (@exons) {\n    unless ($exon->obj_valid) {\n      $self->warn(\"$exon no more valid, start or end label lost, skipping....\",1); # ignorable\n    } else {\n      push(@newexons,$exon);\n    }\n  }\n  if ($#exons != $#newexons) {\n    # update exons field\n    $self->{'exons'}=\\@newexons;\n  }\n  return (@newexons);\n}\n\n=head2 downstream_seq\n\n Title   : downstream_seq\n Usage   : $transcript_obj->downstream_seq()\n         : $transcript_obj->downstream_seq(64)\n Function: returns a string of nucleotides downstream of the end of the\n           CDS. If there is some information of the real mRNA, from features in\n           an attached Gene object, it will return up to those boundaries.\n           Otherwise it will return 1000 nucleotides.\n           If an argument is given it will override the default 1000 number\n           and return instead /that/ requested number of nucleotides.\n           But if a Gene object is attached, this argument will be ignored.\n Returns : string\n Args    : an optional integer number of nucleotides to be returned instead of\n           the default if no gene attached\n\n\nsub downstream_seq {\n  my ($self,$howmany)=@_;\n  my $str;\n  if (defined ($howmany)) {\n    unless ($howmany > 0) {\n      $self->throw(\"No sense in asking less than 1 downstream nucleotides!\");\n    }\n  } else {\n    unless ($self->{'seq'}->alphabet eq 'rna') { # if rna retrieve until the end\n      #$str=$DNAobj->labelsubseq($self->end,undef,undef,\"unsecuremoderequested\");\n      #return(substr($str,1)); # delete first nucleotide that is the last of Transcript\n      if ($self->gene) { # if there is Gene object attached fetch relevant info\n\t$str=$self->{'seq'}->labelsubseq($self->end,undef,$self->gene->maxtranscript->end); # retrieve from end of this Transcript to end of the maxtranscript\n\t$str=substr($str,1); # delete first nucleotide that is the last of Transcript\n\tif (CORE::length($str) > 0) {\n\t  return($str);\n\t} else { # if there was no downstream through the gene's maxtranscript, go the usual way\n\t  $howmany = 1000;\n\t}\n      } else {\n\t$howmany = 1000;\n      }\n    }\n  }\n  my @exons=$self->all_Exons;\n  my $strand=$self->strand();\n  my $lastexon=$exons[-1];\n  my $lastexonlength=$lastexon->length;\n  # $howmany nucs after end of last exon\n  #my $downstream_seq=$lastexon->subseq($lastexonlength+1,undef,$howmany);\n  my $downstream_seq;\n\n  if ($howmany) {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,$howmany,undef,\"unsecuremoderequested\"),1);\n  } else {\n    if ($strand == 1) {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,undef,$self->{'seq'}->end,\"unsecuremoderequested\"),1);\n    } else {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,undef,$self->{'seq'}->start,\"unsecuremoderequested\"),1);\n    }\n  }\n  return $downstream_seq;\n}\n\n=head2 upstream_seq\n\n Title   : upstream_seq\n Usage   : $transcript_obj->upstream_seq()\n         : $transcript_obj->upstream_seq(64)\n Function: just like downstream_seq but returns nucleotides before the ATG\n Note    : the default, if no Gene information present and no nucleotides\n           number given, is to return up to 400 nucleotides.\n\n\nsub upstream_seq {\n  my ($self,$howmany)=@_;\n  if (defined ($howmany)) {\n    unless ($howmany > 0) {\n      $self->throw(\"No sense in asking less than 1 upstream nucleotides!\");\n    }\n  } else {\n    unless ($self->{'seq'}->alphabet eq 'rna') { # if rna retrieve from the start\n      if ($self->gene) { # if there is Gene object attached fetch relevant info\n\tmy $str=$self->{'seq'}->labelsubseq($self->gene->maxtranscript->start,undef,$self->start); # retrieve from start of maxtranscript to start of this Transcript\n\tchop $str; # delete last nucleotide that is the A of starting ATG\n\tif (length($str) > 0) {\n\t  return($str);\n\t} else { # if there was no upstream through the gene's maxtranscript, go the usual way\n\t  $howmany = 400;\n\t}\n      } else {\n\t$howmany = 400;\n      }\n    }\n  }\n  my @exons=$self->all_Exons;\n  my $firstexon=$exons[0];\n  \n  my $upstream_seq;\n  my $strand=$self->strand();\n\n  if ($howmany) {# $howmany nucs before begin of first exon\n    my $labelbefore=$firstexon->label(-$howmany,$firstexon->start);\n    if ($labelbefore < 1) {\n      if ($strand == 1) {\n\t$labelbefore=$self->{'seq'}->start;\n      } else {\n\t$labelbefore=$self->{'seq'}->end;\n      }\n    }\n    $upstream_seq=$firstexon->labelsubseq($labelbefore,undef,$firstexon->start,\"unsecuremoderequested\");\n    chop $upstream_seq;\n  } else {\n    if ($strand == 1) {\n      $upstream_seq=$firstexon->labelsubseq($self->{'seq'}->start,undef,$self->start,\"unsecuremoderequested\");\n      chop $upstream_seq; # delete last nucleotide that is the A of starting ATG\n    } else {\n      $upstream_seq=$firstexon->labelsubseq($self->{'seq'}->end,undef,$self->start,\"unsecuremoderequested\");\n      chop $upstream_seq; # delete last nucleotide that is the A of starting ATG\n    }\n  }\n  return $upstream_seq;\n}\n\n# These get redefined here, overriding the SeqI one because they draw their\n# information from the Exons a Transcript is built of\n# optional argument: firstlabel. If not given, it checks coordinate_start\n#                                This is useful when called by Translation\n#                                also used by _delete\nsub label {\n  my ($self,$position,$firstlabel)=@_;\n  unless ($position) {  # if position = 0 complain ?\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  my ($label,@labels,$length,$arraypos);\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start; # this is inside Transcript obj\n  }\n  my $coord_pos=$self->_inside_position($firstlabel);\n  $length=$self->length;\n  #if ($strand == 1) {\n    if ($position < 1) {\n      $position++; # to account for missing of 0 position\n    }\n    $arraypos=$position+$coord_pos-2;\n    #print \"\\n=-=-=-=-DEBUG: arraypos $arraypos, pos $position, coordpos: $coord_pos\";\n    if ($arraypos < 0) {\n      $label=$self->{'seq'}->label($arraypos,$start,$strand); #?\n    } elsif ($arraypos >= $length) {\n      $label=$self->{'seq'}->label($arraypos-$length+2,$end,$strand); #?\n    } else { # inside the Transcript\n      @labels=$self->all_labels;\n      $label=$labels[$arraypos];\n    }\n  #}\n}\n\n# argument: label\n# returns: position of label according to coord_start\n# errorcode: 0 label not found\n# optional argument: firstlabel. If not given, it checks coordinate_start\n#                                This is useful when called by Translation\nsub position {\n  my ($self,$label,$firstlabel)=@_;\n  unless ($self->{'seq'}->valid($label)) {\n    $self->warn(\"label is not valid\");\n    return (0);\n  }\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start; # this is inside Transcript obj\n  }\n  if ($label == $firstlabel) {\n    return (1);\n  }\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  my ($position,$in_pos,$out_pos,$coord_pos);\n  my $length=$self->length;\n  $coord_pos=$self->_inside_position($firstlabel);\n  if ($self->valid($label)) { # if label is inside the Transcript\n    $in_pos=$self->_inside_position($label);\n    $position=$in_pos-$coord_pos+1;\n    if ($position <= 0) {\n      return ($position-1); # accounts for the missing of the 0 position\n    }\n  } else {\n    if ($self->follows($end,$label)) { # label after end of transcript\n      $out_pos=$self->{'seq'}->position($label,$end,$strand);\n      #print \"\\n+++++++++DEBUG label $label FOLLOWS end $end outpos $out_pos coordpos $coord_pos\";\n      $position=$out_pos+$length-$coord_pos;\n    } elsif ($self->follows($label,$start)) { # label before begin of transcript\n      #print \"\\n+++++++++DEBUG label $label BEFORE start $start outpos $out_pos coordpos $coord_pos\";\n      $out_pos=$self->{'seq'}->position($label,$start,$strand);\n      $position=$out_pos-$coord_pos+1;\n    } else { # label is in intron (not valid, not after, not before)!\n      $self->warn(\"Cannot give position of label pointing to intron according to CDS numbering!\",1);\n      return (0);\n    }\n  }\n  return ($position);\n}\n\nsub seq {\n  my $self=shift;\n  my ($exon,$str);\n  my @exons=$self->all_Exons();\n  foreach $exon (@exons) {\n    $str .= $exon->seq();\n  }\n  return $str;\n}\n\nsub length {\n  my $self=shift;\n  my ($exon,$length);\n  my @exons=$self->all_Exons();\n  foreach $exon (@exons) {\n    $length += $exon->length();\n  }\n  return $length;\n}\n\nsub all_labels {\n  my $self=shift;\n  my ($exon,@labels);\n  my @exons=$self->all_Exons();\n  foreach $exon (@exons) {\n    push (@labels,$exon->all_labels());\n  }\n  return @labels;\n}\n\n# redefined here so that it will retrieve effective subseq without introns\n# otherwise it would have retrieved an underlying DNA (possibly with introns)\n# subsequence\n# Drawback: this is really bulky, label->position and then a call to\n# subseq that will do the opposite position-> label\n#\n# one day this can be rewritten as the main one so that the normal subseq\n# will rely on this one and hence avoid this double (useless and lengthy)\n# conversion between labels and positions\nsub old_labelsubseq {\n  my ($self,$start,$length,$end)=@_;\n  my ($pos1,$pos2);\n  if ($start) {\n    unless ($self->valid($start)) {\n      $self->warn(\"Start label not valid\"); return (-1);\n    }\n    $pos1=$self->position($start);\n  }\n  if ($end) {\n    if ($end == $start) {\n      $length=1;\n    } else {\n      unless ($self->valid($end)) {\n\t$self->warn(\"End label not valid\"); return (-1);\n      }\n      unless ($self->follows($start,$end) == 1) {\n\t$self->warn(\"End label does not follow Start label!\"); return (-1);\n      }\n      $pos2=$self->position($end);\n      undef $length;\n    }\n  }\n  return ($self->subseq($pos1,$pos2,$length));\n}\n\n# rewritten, eventually\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode)=@_;\n  unless (defined $unsecuremode && \n\t  $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    if ($start) {\n      unless ($self->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    } else {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length; # end argument overrides length argument\n\tunless ($self->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n      }\n    } else {\n      $end=$self->end;\n    }\n  }\n  my ($seq,$exon,$startexon,$endexon); my @exonlabels;\n  my @exons=$self->all_Exons;\n  EXONCHECK:\n  foreach $exon (@exons) {\n    if ((!(defined($startexon)))&&($exon->valid($start))) { # checks only if not yet found\n      $startexon=$exon;\n    }\n    if ($exon->valid($end)) {\n      $endexon=$exon;\n    }\n    if ((!(defined($seq)) && (defined($startexon)))) { # initializes only once\n      if ((defined($endexon)) && ($endexon eq $startexon)) { # then perfect, we are finished\n\tif ($length) {\n\t  $seq = $startexon->labelsubseq($start,$length,undef,\"unsecuremoderequested\");\n\n\n\t  last EXONCHECK;\n\t} else {\n\t  $seq = $startexon->labelsubseq($start,undef,$end,\"unsecuremoderequested\");\n\t}\n\tlast EXONCHECK;\n      } else { # get up to the end of the exon\n\t$seq = $startexon->labelsubseq($start,undef,undef,\"unsecuremoderequested\");\n      }\n    }\n    if (($startexon)&&($exon ne $startexon)) {\n      if (defined($endexon)) { # we arrived to the last exon\n\t$seq .= $endexon->labelsubseq(undef,undef,$end,\"unsecuremoderequested\"); # get from the start of the exon\n\tlast EXONCHECK;\n\n      } elsif (defined($startexon)) { # we are in a whole-exon-in-the-middle case\n\t  $seq .= $exon->seq; # we add it completely to the seq\n      } # else, we still have to reach the start point, exon useless, we move on\n      if ($length) { # if length argument specified\n\tif (($seq && (CORE::length($seq) >= $length))) {\n\t  last EXONCHECK;\n\t}\n      }\n    }\n  }\n  if ($length) {\n    return (substr($seq,0,$length));\n  } else {\n    return ($seq);\n  }\n}\n\n\n# argument: label\n# returns: the objref and progressive number of the Exon containing that label\n# errorcode: -1\nsub in_which_Exon {\n  my ($self,$label)=@_;\n  my ($count,$exon);\n  my @exons=$self->all_Exons;\n  foreach $exon (@exons) {\n    $count++; # 1st exon is numbered \"1\"\n    if ($exon->valid($label)) {\n      return ($exon,$count)\n    }\n  }\n  return (-1); # if nothing found\n}\n\n# recoded to exploit the new fast labelsubseq()\n# valid only inside Transcript\nsub subseq {\n  my ($self,$pos1,$pos2,$length) = @_;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($pos1)) {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    if ((defined ($pos2))&&($pos1>$pos2)) {\n      $self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n    }\n    $startlabel=$self->label($pos1);\n    unless ($self->valid($startlabel)) {\n      $self->warn(\"Start label not valid\"); return (-1);\n    }\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  } else {\n    $startlabel=$self->start;\n  }\n  if (defined ($pos2)) {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    if ((defined ($pos1))&&($pos1>$pos2)) {\n      $self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n    }\n    $endlabel=$self->label($pos2);\n    unless ($self->valid($endlabel)) {\n      $self->warn(\"End label not valid\"); return (-1);\n    }\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  } else {\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  }\n  return ($self->labelsubseq($startlabel,$length,$endlabel,\"unsecuremoderequested\"));\n}\n\n# works only inside the transcript, complains if asked outside\nsub old_subseq {\n  my ($self,$pos1,$pos2,$length) = @_;\n  my ($str,$startcount,$endcount,$seq,$seqlength);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  my $firstlabel=$self->coordinate_start; # this is inside Transcript obj\n  my $coord_pos=$self->_inside_position($firstlabel); # TESTME old\n  $seq=$self->seq;\n  $seqlength=CORE::length($seq);\n  unless (defined ($pos1)) {\n    $startcount=1+$coord_pos-1; # i.e. coord_pos\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    } elsif ($pos1 < 0) {\n      $pos1++;\n    }\n    if ((defined ($pos2))&&($pos1>$pos2)) {\n      $self->warn(\"1st position ($pos1) cannot be > 2nd position ($pos2)!\");\n      return (-1);\n    }\n    $startcount=$pos1+$coord_pos-1;\n  }\n  unless (defined ($pos2)) {\n  ;\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    } elsif ($pos2 < 0) {\n      $pos2++;\n    }\n    if ((defined ($pos1))&&($pos1>$pos2)) {\n      $self->warn(\"1st position ($pos1) cannot be > 2nd position ($pos2)!\");\n      return (-1);\n    }\n    $endcount=$pos2+$coord_pos-1;\n    if ($endcount > $seqlength) {\n      #print \"\\n###DEBUG###: pos1 $pos1 pos2 $pos2 coordpos $coord_pos endcount $endcount seqln $seqlength\\n\";\n      $self->warn(\"Cannot access end position after the end of Transcript\");\n      return (-1);\n    }\n    $length=$endcount-$startcount+1;\n  }\n  #print \"\\n###DEBUG pos1 $pos1 pos2 $pos2 start $startcount end $endcount length $length coordpos $coord_pos\\n\";\n  my $offset=$startcount-1;\n  if ($offset < 0) {\n    $self->warn(\"Cannot access startposition before the beginning of Transcript, returning from start\",1); # ignorable\n    return (substr($seq,0,$length));\n  } elsif ($offset >= $seqlength) {\n    $self->warn(\"Cannot access startposition after the end of Transcript\");\n    return (-1);\n  } else {\n    $str=substr($seq,$offset,$length);\n    if (CORE::length($str) < $length) {\n      $self->warn(\"Attention, cannot return the length requested \".\n\t\t  \"for subseq\",1) if $self->verbose > 0; # ignorable\n    }\n    return $str;\n  }\n}\n\n# redefined so that it doesn't require other methods (after deletions) to\n# reset it.\nsub start {\n  my $self = shift;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  return ($exons[0]->start);\n}\n\nsub end {\n  my $self = shift;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  return ($exons[-1]->end);\n}\n\n\n# internal methods begin here\n\n# returns: position of label in transcript's all_labels\n#          with STARTlabel == 1\n# errorcode 0 -> label not found\n# argument: label\nsub _inside_position {\n  my ($self,$label)=@_;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  my ($position,$checkme);\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    $position++;\n    if ($label == $checkme) {\n      return ($position);\n    }\n  }\n  return (0);\n}\n\n# returns 1 OK or 0 ERROR\n# arguments: reference to array of Exon object references\nsub _checkexons {\n  my ($exon,$thisstart);\n  my $self=$exon;\n  my $exonsref=$_[0];\n  my @exons=@{$exonsref};\n\n  my $firstexon = $exons[0];\n\n  unless (ref($firstexon) eq \"Bio::LiveSeq::Exon\") {\n    $self->warn(\"Object not of class Exon\");\n    return (0);\n  }\n  my $strand = $firstexon->strand;\n\n  my $prevend = $firstexon->end;\n  shift @exons; # skip first one\n  foreach $exon (@exons) {\n    unless (ref($exon) eq \"Bio::LiveSeq::Exon\") { # object class check\n      $self->warn(\"Object not of class Exon\");\n      return (0);\n    }\n    if ($exon->strand != $strand) { # strand consistency check\n      $self->warn(\"Exons' strands not consistent when trying to create Transcript\");\n      return (0);\n    }\n    $thisstart = $exon->start;\n    unless ($exon->{'seq'}->follows($prevend,$thisstart,$strand)) {\n      $self->warn(\"Exons not in correct order when trying to create Transcript\");\n      return (0);\n    }\n    $prevend = $exon->end;\n  }\n  return (1);\n}\n\n=head2 get_Translation\n\n  Title   : valid\n  Usage   : $translation = $obj->get_Translation()\n  Function: retrieves the reference to the object of class Translation (if any)\n            attached to a LiveSeq object\n  Returns : object reference\n  Args    : none\n\n\nsub get_Translation {\n  my $self=shift;\n  return ($self->{'translation'}); # this is set when Translation->new is called\n}\n\n# this checks so that deletion spanning multiple exons is\n# handled accordingly and correctly\n# arguments: begin and end label of a deletion\n# this is called BEFORE any deletion in the chain\nsub _deletecheck {\n  my ($self,$startlabel,$endlabel)=@_;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  my ($startexon,$endexon,$exon);\n  $startexon=$endexon=0;\n  foreach $exon (@exons) {\n    if (($startexon == 0)&&($exon->valid($startlabel))) {\n      $startexon=$exon; # exon containing start of deletion\n    }\n    if (($endexon == 0)&&($exon->valid($endlabel))) {\n      $endexon=$exon; # exon containing end of deletion\n    }\n    if (($startexon)&&($endexon)) {\n      last; # don't check further\n    }\n  }\n  my $nextend=$self->label(2,$endlabel); # retrieve the next label\n  my $prevstart=$self->label(-1,$startlabel); # retrieve the prev label\n\n  if ($startexon eq $endexon) { # intra-exon deletion\n    if (($startexon->start eq $startlabel) && ($startexon->end eq $endlabel)) {\n      # let's delete the entire exon\n      my @newexons;\n      foreach $exon (@exons) {\n\tunless ($exon eq $startexon) {\n\t  push(@newexons,$exon);\n\t}\n      }\n      $self->{'exons'}=\\@newexons;\n    } elsif ($startexon->start eq $startlabel) { # special cases\n      $startexon->{'start'}=$nextend; # set a new start of exon\n    } elsif ($startexon->end eq $endlabel) {\n      $startexon->{'end'}=$prevstart; # set a new end of exon\n    } else {\n      return; # no problem\n    }\n  } else { # two new exons to be created, inter-exons deletion\n    my @newexons;\n    my $exonobj;\n    my $dna=$self->{'seq'};\n    my $strand=$self->strand;\n    my $notmiddle=1; # flag for skipping exons in the middle of deletion\n    foreach $exon (@exons) {\n      if ($exon eq $startexon) {\n\t$exonobj=Bio::LiveSeq::Exon->new('-seq'=>$dna,'-start'=>$exon->start,'-end'=>$prevstart,'-strand'=>$strand); # new partial exon\n\tpush(@newexons,$exonobj);\n\t$notmiddle=0; # now we enter totally deleted exons\n      } elsif ($exon eq $endexon) {\n\t$exonobj=Bio::LiveSeq::Exon->new('-seq'=>$dna,'-start'=>$nextend,'-end'=>$exon->end,'-strand'=>$strand); # new partial exon\n\tpush(@newexons,$exonobj);\n\t$notmiddle=1; # exiting totally deleted exons\n      } else {\n\tif ($notmiddle) { # if before or after exons with deletion\n\t  push(@newexons,$exon); \n\t}# else skip them\n      }\n    }\n    $self->{'exons'}=\\@newexons;\n  }\n}\n\n=head2 translation_table\n\n Title   : translation_table\n Usage   : $name = $obj->translation_table;\n         : $name = $obj->translation_table(11);\n Function: Returns or sets the translation_table used for translating the\n           transcript.\n           If it has never been set, it will return undef.\n Returns : an integer","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"translation_table","line":774,"kind":13},{"name":"$value","containerName":"translation_table","line":774,"kind":13},{"line":775,"kind":13,"name":"$value","containerName":"translation_table"},{"line":776,"kind":13,"name":"$self","containerName":"translation_table"},{"kind":13,"line":776,"name":"$value","containerName":"translation_table"},{"kind":13,"line":778,"name":"$self","containerName":"translation_table"},{"line":781,"kind":13,"name":"$self","containerName":"translation_table"}],"line":773,"kind":12},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$inputlabel"}],"documentation":"1;\n# $Id: Transcript.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Transcript - Transcript class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis stores informations about coding sequences (CDS).\nThe implementation is that a Transcript object accesses a collection of\nExon objects, inferring from them the nucleotide structure and sequence.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Transcript;\n\nuse strict;\n# use Carp qw(carp cluck);\nuse Bio::LiveSeq::Exon; # uses Exon to create new exon in case of deletion\nuse base qw(Bio::LiveSeq::SeqI);\n\n=head2 new\n\n  Title   : new\n  Usage   : $transcript = Bio::LiveSeq::Transcript->new(-exons => \\@obj_refs);\n\n  Function: generates a new Bio::LiveSeq::Transcript\n  Returns : reference to a new object of class Transcript\n  Errorcode -1\n  Args    : reference to an array of Exon object references\n\n\nsub new {\n  my ($thing, %args) = @_;\n  my $class = ref($thing) || $thing;\n  my ($obj,%transcript);\n\n  my @exons=@{$args{-exons}};\n\n  $obj = \\%transcript;\n  $obj = bless $obj, $class;\n\n  unless (@exons) {\n    $obj->warn(\"$class not initialised because exons array empty\");\n    return(-1);\n  }\n\n  # now useless, after start and end methods have been overridden here\n  my $firstexon = $exons[0];\n  #my $lastexon = $exons[-1];\n  #my $start = $firstexon->start;\n  #my $end = $lastexon->end;\n  my $strand = $firstexon->strand;\n  my $seq = $firstexon->{'seq'};\n  $obj->alphabet('rna');\n\n  unless (_checkexons(\\@exons)) {\n    $obj->warn(\"$class not initialised because of problems in the exon structure\");\n    return(-1);\n  }\n  $obj->{'strand'}=$strand;\n  $obj->{'exons'}=\\@exons;\n  $obj->{'seq'}=$seq;\n\n  # set Transcript into each Exon\n  my $exon;\n  foreach $exon (@exons) {\n    $exon->{'transcript'}=$obj;\n  }\n  return $obj;\n}\n\n\n=head2 all_Exons\n\n Title   : all_Exons\n Usage   : $transcript_obj->all_Exons()\n Function: returns references to all Exon objects the Transcript is composed of\n Example : foreach $exon ($transcript->all_Exons()) { do_something }\n Returns : array of object references\n Args    : none\n\n\nsub all_Exons {\n  my $self=shift;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  my @newexons;\n  my $exon;\n  foreach $exon (@exons) {\n    unless ($exon->obj_valid) {\n      $self->warn(\"$exon no more valid, start or end label lost, skipping....\",1); # ignorable\n    } else {\n      push(@newexons,$exon);\n    }\n  }\n  if ($#exons != $#newexons) {\n    # update exons field\n    $self->{'exons'}=\\@newexons;\n  }\n  return (@newexons);\n}\n\n=head2 downstream_seq\n\n Title   : downstream_seq\n Usage   : $transcript_obj->downstream_seq()\n         : $transcript_obj->downstream_seq(64)\n Function: returns a string of nucleotides downstream of the end of the\n           CDS. If there is some information of the real mRNA, from features in\n           an attached Gene object, it will return up to those boundaries.\n           Otherwise it will return 1000 nucleotides.\n           If an argument is given it will override the default 1000 number\n           and return instead /that/ requested number of nucleotides.\n           But if a Gene object is attached, this argument will be ignored.\n Returns : string\n Args    : an optional integer number of nucleotides to be returned instead of\n           the default if no gene attached\n\n\nsub downstream_seq {\n  my ($self,$howmany)=@_;\n  my $str;\n  if (defined ($howmany)) {\n    unless ($howmany > 0) {\n      $self->throw(\"No sense in asking less than 1 downstream nucleotides!\");\n    }\n  } else {\n    unless ($self->{'seq'}->alphabet eq 'rna') { # if rna retrieve until the end\n      #$str=$DNAobj->labelsubseq($self->end,undef,undef,\"unsecuremoderequested\");\n      #return(substr($str,1)); # delete first nucleotide that is the last of Transcript\n      if ($self->gene) { # if there is Gene object attached fetch relevant info\n\t$str=$self->{'seq'}->labelsubseq($self->end,undef,$self->gene->maxtranscript->end); # retrieve from end of this Transcript to end of the maxtranscript\n\t$str=substr($str,1); # delete first nucleotide that is the last of Transcript\n\tif (CORE::length($str) > 0) {\n\t  return($str);\n\t} else { # if there was no downstream through the gene's maxtranscript, go the usual way\n\t  $howmany = 1000;\n\t}\n      } else {\n\t$howmany = 1000;\n      }\n    }\n  }\n  my @exons=$self->all_Exons;\n  my $strand=$self->strand();\n  my $lastexon=$exons[-1];\n  my $lastexonlength=$lastexon->length;\n  # $howmany nucs after end of last exon\n  #my $downstream_seq=$lastexon->subseq($lastexonlength+1,undef,$howmany);\n  my $downstream_seq;\n\n  if ($howmany) {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,$howmany,undef,\"unsecuremoderequested\"),1);\n  } else {\n    if ($strand == 1) {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,undef,$self->{'seq'}->end,\"unsecuremoderequested\"),1);\n    } else {\n      $downstream_seq=substr($lastexon->labelsubseq($self->end,undef,$self->{'seq'}->start,\"unsecuremoderequested\"),1);\n    }\n  }\n  return $downstream_seq;\n}\n\n=head2 upstream_seq\n\n Title   : upstream_seq\n Usage   : $transcript_obj->upstream_seq()\n         : $transcript_obj->upstream_seq(64)\n Function: just like downstream_seq but returns nucleotides before the ATG\n Note    : the default, if no Gene information present and no nucleotides\n           number given, is to return up to 400 nucleotides.\n\n\nsub upstream_seq {\n  my ($self,$howmany)=@_;\n  if (defined ($howmany)) {\n    unless ($howmany > 0) {\n      $self->throw(\"No sense in asking less than 1 upstream nucleotides!\");\n    }\n  } else {\n    unless ($self->{'seq'}->alphabet eq 'rna') { # if rna retrieve from the start\n      if ($self->gene) { # if there is Gene object attached fetch relevant info\n\tmy $str=$self->{'seq'}->labelsubseq($self->gene->maxtranscript->start,undef,$self->start); # retrieve from start of maxtranscript to start of this Transcript\n\tchop $str; # delete last nucleotide that is the A of starting ATG\n\tif (length($str) > 0) {\n\t  return($str);\n\t} else { # if there was no upstream through the gene's maxtranscript, go the usual way\n\t  $howmany = 400;\n\t}\n      } else {\n\t$howmany = 400;\n      }\n    }\n  }\n  my @exons=$self->all_Exons;\n  my $firstexon=$exons[0];\n  \n  my $upstream_seq;\n  my $strand=$self->strand();\n\n  if ($howmany) {# $howmany nucs before begin of first exon\n    my $labelbefore=$firstexon->label(-$howmany,$firstexon->start);\n    if ($labelbefore < 1) {\n      if ($strand == 1) {\n\t$labelbefore=$self->{'seq'}->start;\n      } else {\n\t$labelbefore=$self->{'seq'}->end;\n      }\n    }\n    $upstream_seq=$firstexon->labelsubseq($labelbefore,undef,$firstexon->start,\"unsecuremoderequested\");\n    chop $upstream_seq;\n  } else {\n    if ($strand == 1) {\n      $upstream_seq=$firstexon->labelsubseq($self->{'seq'}->start,undef,$self->start,\"unsecuremoderequested\");\n      chop $upstream_seq; # delete last nucleotide that is the A of starting ATG\n    } else {\n      $upstream_seq=$firstexon->labelsubseq($self->{'seq'}->end,undef,$self->start,\"unsecuremoderequested\");\n      chop $upstream_seq; # delete last nucleotide that is the A of starting ATG\n    }\n  }\n  return $upstream_seq;\n}\n\n# These get redefined here, overriding the SeqI one because they draw their\n# information from the Exons a Transcript is built of\n# optional argument: firstlabel. If not given, it checks coordinate_start\n#                                This is useful when called by Translation\n#                                also used by _delete\nsub label {\n  my ($self,$position,$firstlabel)=@_;\n  unless ($position) {  # if position = 0 complain ?\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  my ($label,@labels,$length,$arraypos);\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start; # this is inside Transcript obj\n  }\n  my $coord_pos=$self->_inside_position($firstlabel);\n  $length=$self->length;\n  #if ($strand == 1) {\n    if ($position < 1) {\n      $position++; # to account for missing of 0 position\n    }\n    $arraypos=$position+$coord_pos-2;\n    #print \"\\n=-=-=-=-DEBUG: arraypos $arraypos, pos $position, coordpos: $coord_pos\";\n    if ($arraypos < 0) {\n      $label=$self->{'seq'}->label($arraypos,$start,$strand); #?\n    } elsif ($arraypos >= $length) {\n      $label=$self->{'seq'}->label($arraypos-$length+2,$end,$strand); #?\n    } else { # inside the Transcript\n      @labels=$self->all_labels;\n      $label=$labels[$arraypos];\n    }\n  #}\n}\n\n# argument: label\n# returns: position of label according to coord_start\n# errorcode: 0 label not found\n# optional argument: firstlabel. If not given, it checks coordinate_start\n#                                This is useful when called by Translation\nsub position {\n  my ($self,$label,$firstlabel)=@_;\n  unless ($self->{'seq'}->valid($label)) {\n    $self->warn(\"label is not valid\");\n    return (0);\n  }\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start; # this is inside Transcript obj\n  }\n  if ($label == $firstlabel) {\n    return (1);\n  }\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  my ($position,$in_pos,$out_pos,$coord_pos);\n  my $length=$self->length;\n  $coord_pos=$self->_inside_position($firstlabel);\n  if ($self->valid($label)) { # if label is inside the Transcript\n    $in_pos=$self->_inside_position($label);\n    $position=$in_pos-$coord_pos+1;\n    if ($position <= 0) {\n      return ($position-1); # accounts for the missing of the 0 position\n    }\n  } else {\n    if ($self->follows($end,$label)) { # label after end of transcript\n      $out_pos=$self->{'seq'}->position($label,$end,$strand);\n      #print \"\\n+++++++++DEBUG label $label FOLLOWS end $end outpos $out_pos coordpos $coord_pos\";\n      $position=$out_pos+$length-$coord_pos;\n    } elsif ($self->follows($label,$start)) { # label before begin of transcript\n      #print \"\\n+++++++++DEBUG label $label BEFORE start $start outpos $out_pos coordpos $coord_pos\";\n      $out_pos=$self->{'seq'}->position($label,$start,$strand);\n      $position=$out_pos-$coord_pos+1;\n    } else { # label is in intron (not valid, not after, not before)!\n      $self->warn(\"Cannot give position of label pointing to intron according to CDS numbering!\",1);\n      return (0);\n    }\n  }\n  return ($position);\n}\n\nsub seq {\n  my $self=shift;\n  my ($exon,$str);\n  my @exons=$self->all_Exons();\n  foreach $exon (@exons) {\n    $str .= $exon->seq();\n  }\n  return $str;\n}\n\nsub length {\n  my $self=shift;\n  my ($exon,$length);\n  my @exons=$self->all_Exons();\n  foreach $exon (@exons) {\n    $length += $exon->length();\n  }\n  return $length;\n}\n\nsub all_labels {\n  my $self=shift;\n  my ($exon,@labels);\n  my @exons=$self->all_Exons();\n  foreach $exon (@exons) {\n    push (@labels,$exon->all_labels());\n  }\n  return @labels;\n}\n\n# redefined here so that it will retrieve effective subseq without introns\n# otherwise it would have retrieved an underlying DNA (possibly with introns)\n# subsequence\n# Drawback: this is really bulky, label->position and then a call to\n# subseq that will do the opposite position-> label\n#\n# one day this can be rewritten as the main one so that the normal subseq\n# will rely on this one and hence avoid this double (useless and lengthy)\n# conversion between labels and positions\nsub old_labelsubseq {\n  my ($self,$start,$length,$end)=@_;\n  my ($pos1,$pos2);\n  if ($start) {\n    unless ($self->valid($start)) {\n      $self->warn(\"Start label not valid\"); return (-1);\n    }\n    $pos1=$self->position($start);\n  }\n  if ($end) {\n    if ($end == $start) {\n      $length=1;\n    } else {\n      unless ($self->valid($end)) {\n\t$self->warn(\"End label not valid\"); return (-1);\n      }\n      unless ($self->follows($start,$end) == 1) {\n\t$self->warn(\"End label does not follow Start label!\"); return (-1);\n      }\n      $pos2=$self->position($end);\n      undef $length;\n    }\n  }\n  return ($self->subseq($pos1,$pos2,$length));\n}\n\n# rewritten, eventually\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode)=@_;\n  unless (defined $unsecuremode && \n\t  $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    if ($start) {\n      unless ($self->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    } else {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length; # end argument overrides length argument\n\tunless ($self->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n      }\n    } else {\n      $end=$self->end;\n    }\n  }\n  my ($seq,$exon,$startexon,$endexon); my @exonlabels;\n  my @exons=$self->all_Exons;\n  EXONCHECK:\n  foreach $exon (@exons) {\n    if ((!(defined($startexon)))&&($exon->valid($start))) { # checks only if not yet found\n      $startexon=$exon;\n    }\n    if ($exon->valid($end)) {\n      $endexon=$exon;\n    }\n    if ((!(defined($seq)) && (defined($startexon)))) { # initializes only once\n      if ((defined($endexon)) && ($endexon eq $startexon)) { # then perfect, we are finished\n\tif ($length) {\n\t  $seq = $startexon->labelsubseq($start,$length,undef,\"unsecuremoderequested\");\n\n\n\t  last EXONCHECK;\n\t} else {\n\t  $seq = $startexon->labelsubseq($start,undef,$end,\"unsecuremoderequested\");\n\t}\n\tlast EXONCHECK;\n      } else { # get up to the end of the exon\n\t$seq = $startexon->labelsubseq($start,undef,undef,\"unsecuremoderequested\");\n      }\n    }\n    if (($startexon)&&($exon ne $startexon)) {\n      if (defined($endexon)) { # we arrived to the last exon\n\t$seq .= $endexon->labelsubseq(undef,undef,$end,\"unsecuremoderequested\"); # get from the start of the exon\n\tlast EXONCHECK;\n\n      } elsif (defined($startexon)) { # we are in a whole-exon-in-the-middle case\n\t  $seq .= $exon->seq; # we add it completely to the seq\n      } # else, we still have to reach the start point, exon useless, we move on\n      if ($length) { # if length argument specified\n\tif (($seq && (CORE::length($seq) >= $length))) {\n\t  last EXONCHECK;\n\t}\n      }\n    }\n  }\n  if ($length) {\n    return (substr($seq,0,$length));\n  } else {\n    return ($seq);\n  }\n}\n\n\n# argument: label\n# returns: the objref and progressive number of the Exon containing that label\n# errorcode: -1\nsub in_which_Exon {\n  my ($self,$label)=@_;\n  my ($count,$exon);\n  my @exons=$self->all_Exons;\n  foreach $exon (@exons) {\n    $count++; # 1st exon is numbered \"1\"\n    if ($exon->valid($label)) {\n      return ($exon,$count)\n    }\n  }\n  return (-1); # if nothing found\n}\n\n# recoded to exploit the new fast labelsubseq()\n# valid only inside Transcript\nsub subseq {\n  my ($self,$pos1,$pos2,$length) = @_;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($pos1)) {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    if ((defined ($pos2))&&($pos1>$pos2)) {\n      $self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n    }\n    $startlabel=$self->label($pos1);\n    unless ($self->valid($startlabel)) {\n      $self->warn(\"Start label not valid\"); return (-1);\n    }\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  } else {\n    $startlabel=$self->start;\n  }\n  if (defined ($pos2)) {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    if ((defined ($pos1))&&($pos1>$pos2)) {\n      $self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n    }\n    $endlabel=$self->label($pos2);\n    unless ($self->valid($endlabel)) {\n      $self->warn(\"End label not valid\"); return (-1);\n    }\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  } else {\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  }\n  return ($self->labelsubseq($startlabel,$length,$endlabel,\"unsecuremoderequested\"));\n}\n\n# works only inside the transcript, complains if asked outside\nsub old_subseq {\n  my ($self,$pos1,$pos2,$length) = @_;\n  my ($str,$startcount,$endcount,$seq,$seqlength);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  my $firstlabel=$self->coordinate_start; # this is inside Transcript obj\n  my $coord_pos=$self->_inside_position($firstlabel); # TESTME old\n  $seq=$self->seq;\n  $seqlength=CORE::length($seq);\n  unless (defined ($pos1)) {\n    $startcount=1+$coord_pos-1; # i.e. coord_pos\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    } elsif ($pos1 < 0) {\n      $pos1++;\n    }\n    if ((defined ($pos2))&&($pos1>$pos2)) {\n      $self->warn(\"1st position ($pos1) cannot be > 2nd position ($pos2)!\");\n      return (-1);\n    }\n    $startcount=$pos1+$coord_pos-1;\n  }\n  unless (defined ($pos2)) {\n  ;\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    } elsif ($pos2 < 0) {\n      $pos2++;\n    }\n    if ((defined ($pos1))&&($pos1>$pos2)) {\n      $self->warn(\"1st position ($pos1) cannot be > 2nd position ($pos2)!\");\n      return (-1);\n    }\n    $endcount=$pos2+$coord_pos-1;\n    if ($endcount > $seqlength) {\n      #print \"\\n###DEBUG###: pos1 $pos1 pos2 $pos2 coordpos $coord_pos endcount $endcount seqln $seqlength\\n\";\n      $self->warn(\"Cannot access end position after the end of Transcript\");\n      return (-1);\n    }\n    $length=$endcount-$startcount+1;\n  }\n  #print \"\\n###DEBUG pos1 $pos1 pos2 $pos2 start $startcount end $endcount length $length coordpos $coord_pos\\n\";\n  my $offset=$startcount-1;\n  if ($offset < 0) {\n    $self->warn(\"Cannot access startposition before the beginning of Transcript, returning from start\",1); # ignorable\n    return (substr($seq,0,$length));\n  } elsif ($offset >= $seqlength) {\n    $self->warn(\"Cannot access startposition after the end of Transcript\");\n    return (-1);\n  } else {\n    $str=substr($seq,$offset,$length);\n    if (CORE::length($str) < $length) {\n      $self->warn(\"Attention, cannot return the length requested \".\n\t\t  \"for subseq\",1) if $self->verbose > 0; # ignorable\n    }\n    return $str;\n  }\n}\n\n# redefined so that it doesn't require other methods (after deletions) to\n# reset it.\nsub start {\n  my $self = shift;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  return ($exons[0]->start);\n}\n\nsub end {\n  my $self = shift;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  return ($exons[-1]->end);\n}\n\n\n# internal methods begin here\n\n# returns: position of label in transcript's all_labels\n#          with STARTlabel == 1\n# errorcode 0 -> label not found\n# argument: label\nsub _inside_position {\n  my ($self,$label)=@_;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  my ($position,$checkme);\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    $position++;\n    if ($label == $checkme) {\n      return ($position);\n    }\n  }\n  return (0);\n}\n\n# returns 1 OK or 0 ERROR\n# arguments: reference to array of Exon object references\nsub _checkexons {\n  my ($exon,$thisstart);\n  my $self=$exon;\n  my $exonsref=$_[0];\n  my @exons=@{$exonsref};\n\n  my $firstexon = $exons[0];\n\n  unless (ref($firstexon) eq \"Bio::LiveSeq::Exon\") {\n    $self->warn(\"Object not of class Exon\");\n    return (0);\n  }\n  my $strand = $firstexon->strand;\n\n  my $prevend = $firstexon->end;\n  shift @exons; # skip first one\n  foreach $exon (@exons) {\n    unless (ref($exon) eq \"Bio::LiveSeq::Exon\") { # object class check\n      $self->warn(\"Object not of class Exon\");\n      return (0);\n    }\n    if ($exon->strand != $strand) { # strand consistency check\n      $self->warn(\"Exons' strands not consistent when trying to create Transcript\");\n      return (0);\n    }\n    $thisstart = $exon->start;\n    unless ($exon->{'seq'}->follows($prevend,$thisstart,$strand)) {\n      $self->warn(\"Exons not in correct order when trying to create Transcript\");\n      return (0);\n    }\n    $prevend = $exon->end;\n  }\n  return (1);\n}\n\n=head2 get_Translation\n\n  Title   : valid\n  Usage   : $translation = $obj->get_Translation()\n  Function: retrieves the reference to the object of class Translation (if any)\n            attached to a LiveSeq object\n  Returns : object reference\n  Args    : none\n\n\nsub get_Translation {\n  my $self=shift;\n  return ($self->{'translation'}); # this is set when Translation->new is called\n}\n\n# this checks so that deletion spanning multiple exons is\n# handled accordingly and correctly\n# arguments: begin and end label of a deletion\n# this is called BEFORE any deletion in the chain\nsub _deletecheck {\n  my ($self,$startlabel,$endlabel)=@_;\n  my $exonsref=$self->{'exons'};\n  my @exons=@{$exonsref};\n  my ($startexon,$endexon,$exon);\n  $startexon=$endexon=0;\n  foreach $exon (@exons) {\n    if (($startexon == 0)&&($exon->valid($startlabel))) {\n      $startexon=$exon; # exon containing start of deletion\n    }\n    if (($endexon == 0)&&($exon->valid($endlabel))) {\n      $endexon=$exon; # exon containing end of deletion\n    }\n    if (($startexon)&&($endexon)) {\n      last; # don't check further\n    }\n  }\n  my $nextend=$self->label(2,$endlabel); # retrieve the next label\n  my $prevstart=$self->label(-1,$startlabel); # retrieve the prev label\n\n  if ($startexon eq $endexon) { # intra-exon deletion\n    if (($startexon->start eq $startlabel) && ($startexon->end eq $endlabel)) {\n      # let's delete the entire exon\n      my @newexons;\n      foreach $exon (@exons) {\n\tunless ($exon eq $startexon) {\n\t  push(@newexons,$exon);\n\t}\n      }\n      $self->{'exons'}=\\@newexons;\n    } elsif ($startexon->start eq $startlabel) { # special cases\n      $startexon->{'start'}=$nextend; # set a new start of exon\n    } elsif ($startexon->end eq $endlabel) {\n      $startexon->{'end'}=$prevstart; # set a new end of exon\n    } else {\n      return; # no problem\n    }\n  } else { # two new exons to be created, inter-exons deletion\n    my @newexons;\n    my $exonobj;\n    my $dna=$self->{'seq'};\n    my $strand=$self->strand;\n    my $notmiddle=1; # flag for skipping exons in the middle of deletion\n    foreach $exon (@exons) {\n      if ($exon eq $startexon) {\n\t$exonobj=Bio::LiveSeq::Exon->new('-seq'=>$dna,'-start'=>$exon->start,'-end'=>$prevstart,'-strand'=>$strand); # new partial exon\n\tpush(@newexons,$exonobj);\n\t$notmiddle=0; # now we enter totally deleted exons\n      } elsif ($exon eq $endexon) {\n\t$exonobj=Bio::LiveSeq::Exon->new('-seq'=>$dna,'-start'=>$nextend,'-end'=>$exon->end,'-strand'=>$strand); # new partial exon\n\tpush(@newexons,$exonobj);\n\t$notmiddle=1; # exiting totally deleted exons\n      } else {\n\tif ($notmiddle) { # if before or after exons with deletion\n\t  push(@newexons,$exon); \n\t}# else skip them\n      }\n    }\n    $self->{'exons'}=\\@newexons;\n  }\n}\n\n=head2 translation_table\n\n Title   : translation_table\n Usage   : $name = $obj->translation_table;\n         : $name = $obj->translation_table(11);\n Function: Returns or sets the translation_table used for translating the\n           transcript.\n           If it has never been set, it will return undef.\n Returns : an integer\n\n\nsub translation_table {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'translation_table'} = $value;\n  }\n  unless (exists $self->{'translation_table'}) {\n    return;\n  } else {\n    return $self->{'translation_table'};\n  }\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $transcript->frame($label);\n Function: Returns the frame of a particular nucleotide.\n           Frame can be 0 1 or 2 and means the position in the codon triplet\n           of the particulat nucleotide. 0 is the first codon_position.\n           Codon_position (1 2 3) is simply frame+1.\n           If the label asked for is not inside the Transcript, -1 will be\n           returned.\n Args    : a label\n Returns : 0 1 or 2\n Errorcode -1\n\n args: label\n returns: frame of nucleotide (0 1 2)\n errorcode: -1","label":"frame($self,$inputlabel)"},"detail":"($self,$inputlabel)","kind":12,"children":[{"kind":13,"line":805,"containerName":"frame","name":"$self","definition":"my","localvar":"my"},{"line":805,"kind":13,"name":"$inputlabel","containerName":"frame"},{"definition":"my","name":"@labels","containerName":"frame","localvar":"my","kind":13,"line":806},{"line":806,"kind":13,"containerName":"frame","name":"$self"},{"name":"all_labels","containerName":"frame","kind":12,"line":806},{"localvar":"my","definition":"my","name":"$label","containerName":"frame","line":807,"kind":13},{"line":807,"kind":13,"containerName":"frame","name":"$frame"},{"kind":13,"line":807,"name":"$count","containerName":"frame"},{"kind":13,"line":808,"containerName":"frame","name":"$label"},{"kind":13,"line":808,"name":"@labels","containerName":"frame"},{"name":"$inputlabel","containerName":"frame","kind":13,"line":809},{"containerName":"frame","name":"$label","line":809,"kind":13},{"line":810,"kind":13,"containerName":"frame","name":"$count"},{"name":"$count","containerName":"frame","line":812,"kind":13}],"line":804,"name":"frame","range":{"start":{"character":0,"line":804},"end":{"character":9999,"line":815}}}]}