{"version":5,"vars":[{"line":94,"kind":2,"containerName":"","name":"base"},{"range":{"start":{"line":108,"character":0},"end":{"line":118,"character":9999}},"definition":"sub","name":"seq","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"seq","line":109,"kind":13},{"kind":13,"line":110,"definition":"my","name":"$start","containerName":"seq","localvar":"my"},{"containerName":"seq","name":"$end","kind":13,"line":110},{"line":110,"kind":13,"name":"$self","containerName":"seq"},{"kind":12,"line":110,"name":"start","containerName":"seq"},{"kind":13,"line":110,"name":"$self","containerName":"seq"},{"containerName":"seq","name":"end","line":110,"kind":12},{"name":"$self","containerName":"seq","kind":13,"line":111},{"containerName":"seq","name":"strand","kind":12,"line":111},{"line":112,"kind":13,"containerName":"seq","name":"$self"},{"kind":12,"line":112,"containerName":"seq","name":"down_chain2string"},{"containerName":"seq","name":"$start","line":112,"kind":13},{"name":"$end","containerName":"seq","line":112,"kind":13},{"line":114,"kind":13,"localvar":"my","containerName":"seq","name":"$str","definition":"my"},{"line":114,"kind":13,"name":"$self","containerName":"seq"},{"kind":12,"line":114,"containerName":"seq","name":"up_chain2string"},{"name":"$start","containerName":"seq","line":114,"kind":13},{"kind":13,"line":114,"containerName":"seq","name":"$end"},{"containerName":"seq","name":"$str","line":115,"kind":13},{"kind":13,"line":116,"name":"$str","containerName":"seq"}],"line":108,"kind":12},{"kind":12,"children":[{"line":131,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"all_labels"},{"kind":13,"line":132,"containerName":"all_labels","definition":"my","name":"$start","localvar":"my"},{"containerName":"all_labels","name":"$end","line":132,"kind":13},{"line":132,"kind":13,"name":"$self","containerName":"all_labels"},{"containerName":"all_labels","name":"start","line":132,"kind":12},{"name":"$self","containerName":"all_labels","line":132,"kind":13},{"line":132,"kind":12,"containerName":"all_labels","name":"end"},{"localvar":"my","containerName":"all_labels","definition":"my","name":"$labels","line":133,"kind":13},{"containerName":"all_labels","name":"$self","kind":13,"line":134},{"line":134,"kind":12,"name":"strand","containerName":"all_labels"},{"kind":13,"line":135,"name":"$labels","containerName":"all_labels"},{"line":135,"kind":13,"containerName":"all_labels","name":"$self"},{"name":"down_labels","containerName":"all_labels","line":135,"kind":12},{"name":"$start","containerName":"all_labels","kind":13,"line":135},{"containerName":"all_labels","name":"$end","kind":13,"line":135},{"line":137,"kind":13,"name":"$labels","containerName":"all_labels"},{"kind":13,"line":137,"containerName":"all_labels","name":"$self"},{"kind":12,"line":137,"containerName":"all_labels","name":"up_labels"},{"line":137,"kind":13,"name":"$start","containerName":"all_labels"},{"line":137,"kind":13,"name":"$end","containerName":"all_labels"},{"kind":13,"line":139,"containerName":"all_labels","name":"$labels"}],"line":130,"name":"all_labels","definition":"sub","containerName":"main::","range":{"start":{"line":130,"character":0},"end":{"character":9999,"line":139}}},{"name":"labelsubseq","range":{"start":{"character":0,"line":171},"end":{"line":218,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$start,$length,$end,$unsecuremode)","signature":{"label":"labelsubseq($self,$start,$length,$end,$unsecuremode)","documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$length"},{"label":"$end"},{"label":"$unsecuremode"}]},"kind":12,"line":171,"children":[{"containerName":"labelsubseq","definition":"my","name":"$self","localvar":"my","kind":13,"line":172},{"containerName":"labelsubseq","name":"$start","line":172,"kind":13},{"name":"$length","containerName":"labelsubseq","line":172,"kind":13},{"line":172,"kind":13,"name":"$end","containerName":"labelsubseq"},{"line":172,"kind":13,"name":"$unsecuremode","containerName":"labelsubseq"},{"line":173,"kind":13,"containerName":"labelsubseq","name":"$unsecuremode"},{"containerName":"labelsubseq","name":"$unsecuremode","kind":13,"line":173},{"kind":13,"line":175,"containerName":"labelsubseq","name":"$start"},{"kind":13,"line":176,"containerName":"labelsubseq","name":"$start"},{"line":176,"kind":13,"containerName":"labelsubseq","name":"$self"},{"line":176,"kind":12,"containerName":"labelsubseq","name":"start"},{"line":178,"kind":13,"name":"$end","containerName":"labelsubseq"},{"name":"$end","containerName":"labelsubseq","kind":13,"line":179},{"line":179,"kind":13,"containerName":"labelsubseq","name":"$start"},{"line":180,"kind":13,"name":"$length","containerName":"labelsubseq"},{"kind":13,"line":181,"containerName":"labelsubseq","name":"$end"},{"containerName":"labelsubseq","name":"$length","kind":13,"line":183},{"name":"$length","containerName":"labelsubseq","kind":13,"line":186},{"line":187,"kind":13,"containerName":"labelsubseq","name":"$end"},{"name":"$self","containerName":"labelsubseq","kind":13,"line":187},{"name":"end","containerName":"labelsubseq","kind":12,"line":187},{"name":"$start","containerName":"labelsubseq","line":191,"kind":13},{"line":192,"kind":13,"name":"$self","containerName":"labelsubseq"},{"line":192,"kind":12,"containerName":"labelsubseq","name":"valid"},{"containerName":"labelsubseq","name":"$start","line":192,"kind":13},{"containerName":"labelsubseq","name":"$self","kind":13,"line":193},{"line":193,"kind":12,"name":"warn","containerName":"labelsubseq"},{"containerName":"labelsubseq","name":"$end","line":196,"kind":13},{"name":"$end","containerName":"labelsubseq","line":197,"kind":13},{"kind":13,"line":197,"containerName":"labelsubseq","name":"$start"},{"line":198,"kind":13,"name":"$length","containerName":"labelsubseq"},{"name":"$end","containerName":"labelsubseq","line":199,"kind":13},{"line":201,"kind":13,"name":"$self","containerName":"labelsubseq"},{"name":"valid","containerName":"labelsubseq","line":201,"kind":12},{"line":201,"kind":13,"containerName":"labelsubseq","name":"$end"},{"name":"$self","containerName":"labelsubseq","kind":13,"line":202},{"name":"warn","containerName":"labelsubseq","kind":12,"line":202},{"containerName":"labelsubseq","name":"$self","line":204,"kind":13},{"containerName":"labelsubseq","name":"follows","kind":12,"line":204},{"name":"$start","containerName":"labelsubseq","kind":13,"line":204},{"containerName":"labelsubseq","name":"$end","line":204,"kind":13},{"name":"$self","containerName":"labelsubseq","line":205,"kind":13},{"kind":12,"line":205,"name":"warn","containerName":"labelsubseq"},{"name":"$length","containerName":"labelsubseq","kind":13,"line":207},{"name":"$self","containerName":"labelsubseq","line":211,"kind":13},{"kind":12,"line":211,"containerName":"labelsubseq","name":"strand"},{"line":212,"kind":13,"name":"$self","containerName":"labelsubseq"},{"line":212,"kind":12,"name":"down_chain2string","containerName":"labelsubseq"},{"line":212,"kind":13,"containerName":"labelsubseq","name":"$start"},{"kind":13,"line":212,"containerName":"labelsubseq","name":"$length"},{"kind":13,"line":212,"containerName":"labelsubseq","name":"$end"},{"containerName":"labelsubseq","definition":"my","name":"$str","localvar":"my","kind":13,"line":214},{"line":214,"kind":13,"containerName":"labelsubseq","name":"$self"},{"line":214,"kind":12,"name":"up_chain2string","containerName":"labelsubseq"},{"line":214,"kind":13,"name":"$start","containerName":"labelsubseq"},{"name":"$length","containerName":"labelsubseq","line":214,"kind":13},{"name":"$end","containerName":"labelsubseq","line":214,"kind":13},{"line":215,"kind":13,"containerName":"labelsubseq","name":"$str"},{"line":216,"kind":13,"containerName":"labelsubseq","name":"$str"}]},{"range":{"start":{"character":0,"line":261},"end":{"character":9999,"line":329}},"name":"subseq","signature":{"parameters":[{"label":"$self"},{"label":"$pos1"},{"label":"$pos2"},{"label":"$length"},{"label":"$strand"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n'\n check the fact about reverse strand!\n is it feasible? Is it correct? Should we do it? How about exons? Does it\n work when you ask subseq of an exon?\n eliminated now (Mon night)","label":"subseq($self,$pos1,$pos2,$length,$strand)"},"detail":"($self,$pos1,$pos2,$length,$strand)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"subseq","localvar":"my","kind":13,"line":263},{"kind":13,"line":263,"containerName":"subseq","name":"$pos1"},{"line":263,"kind":13,"containerName":"subseq","name":"$pos2"},{"containerName":"subseq","name":"$length","kind":13,"line":263},{"name":"$strand","containerName":"subseq","line":263,"kind":13},{"kind":13,"line":267,"name":"$strand","containerName":"subseq"},{"kind":13,"line":267,"name":"$self","containerName":"subseq"},{"line":267,"kind":12,"name":"strand","containerName":"subseq"},{"kind":13,"line":268,"containerName":"subseq","definition":"my","name":"$str","localvar":"my"},{"containerName":"subseq","name":"$startlabel","kind":13,"line":268},{"containerName":"subseq","name":"$endlabel","line":268,"kind":13},{"containerName":"subseq","name":"$length","kind":13,"line":269},{"line":270,"kind":13,"name":"$length","containerName":"subseq"},{"line":271,"kind":13,"containerName":"subseq","name":"$self"},{"kind":12,"line":271,"containerName":"subseq","name":"warn"},{"name":"$pos1","containerName":"subseq","kind":13,"line":275},{"line":277,"kind":13,"containerName":"subseq","name":"$startlabel"},{"kind":13,"line":277,"name":"$self","containerName":"subseq"},{"line":277,"kind":12,"containerName":"subseq","name":"start"},{"name":"$pos1","containerName":"subseq","kind":13,"line":279},{"kind":13,"line":280,"containerName":"subseq","name":"$self"},{"name":"warn","containerName":"subseq","kind":12,"line":280},{"name":"$pos2","containerName":"subseq","line":283,"kind":13},{"name":"$pos1","containerName":"subseq","kind":13,"line":283},{"name":"$pos2","containerName":"subseq","line":283,"kind":13},{"kind":13,"line":284,"containerName":"subseq","name":"$self"},{"containerName":"subseq","name":"warn","line":284,"kind":12},{"line":291,"kind":13,"containerName":"subseq","name":"$startlabel"},{"name":"$self","containerName":"subseq","line":291,"kind":13},{"line":291,"kind":12,"name":"label","containerName":"subseq"},{"kind":13,"line":291,"name":"$pos1","containerName":"subseq"},{"containerName":"subseq","name":"$startlabel","kind":13,"line":292},{"name":"$self","containerName":"subseq","line":293,"kind":13},{"kind":12,"line":293,"containerName":"subseq","name":"warn"},{"name":"$pos2","containerName":"subseq","kind":13,"line":296},{"line":298,"kind":13,"name":"$length","containerName":"subseq"},{"kind":13,"line":299,"name":"$endlabel","containerName":"subseq"},{"line":299,"kind":13,"name":"$self","containerName":"subseq"},{"containerName":"subseq","name":"end","line":299,"kind":12},{"containerName":"subseq","name":"$pos2","kind":13,"line":302},{"line":303,"kind":13,"name":"$self","containerName":"subseq"},{"containerName":"subseq","name":"warn","kind":12,"line":303},{"name":"$length","containerName":"subseq","line":305,"kind":13},{"kind":13,"line":307,"name":"$pos1","containerName":"subseq"},{"kind":13,"line":307,"containerName":"subseq","name":"$pos1"},{"containerName":"subseq","name":"$pos2","line":307,"kind":13},{"line":308,"kind":13,"name":"$self","containerName":"subseq"},{"name":"warn","containerName":"subseq","line":308,"kind":12},{"kind":13,"line":315,"containerName":"subseq","name":"$endlabel"},{"name":"$self","containerName":"subseq","line":315,"kind":13},{"kind":12,"line":315,"name":"label","containerName":"subseq"},{"line":315,"kind":13,"containerName":"subseq","name":"$pos2"},{"name":"$endlabel","containerName":"subseq","kind":13,"line":316},{"line":317,"kind":13,"containerName":"subseq","name":"$self"},{"name":"warn","containerName":"subseq","kind":12,"line":317},{"line":322,"kind":13,"name":"$strand","containerName":"subseq"},{"containerName":"subseq","name":"$str","line":323,"kind":13},{"kind":13,"line":323,"containerName":"subseq","name":"$self"},{"containerName":"subseq","name":"down_chain2string","line":323,"kind":12},{"line":323,"kind":13,"name":"$startlabel","containerName":"subseq"},{"line":323,"kind":13,"name":"$length","containerName":"subseq"},{"line":323,"kind":13,"containerName":"subseq","name":"$endlabel"},{"line":325,"kind":13,"name":"$str","containerName":"subseq"},{"name":"$self","containerName":"subseq","kind":13,"line":325},{"line":325,"kind":12,"name":"up_chain2string","containerName":"subseq"},{"kind":13,"line":325,"containerName":"subseq","name":"$startlabel"},{"line":325,"kind":13,"containerName":"subseq","name":"$length"},{"containerName":"subseq","name":"$endlabel","kind":13,"line":325},{"line":326,"kind":13,"containerName":"subseq","name":"$str"},{"name":"$str","containerName":"subseq","kind":13,"line":328}],"line":261,"kind":12},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"length","line":344,"kind":13},{"line":345,"kind":13,"localvar":"my","name":"$start","definition":"my","containerName":"length"},{"kind":13,"line":345,"name":"$end","containerName":"length"},{"kind":13,"line":345,"name":"$strand","containerName":"length"},{"line":345,"kind":13,"name":"$self","containerName":"length"},{"containerName":"length","name":"start","kind":12,"line":345},{"containerName":"length","name":"$self","line":345,"kind":13},{"containerName":"length","name":"end","kind":12,"line":345},{"line":345,"kind":13,"name":"$self","containerName":"length"},{"line":345,"kind":12,"containerName":"length","name":"strand"},{"line":346,"kind":13,"containerName":"length","name":"$strand"},{"line":347,"kind":13,"containerName":"length","name":"$self"},{"line":347,"kind":12,"name":"down_subchain_length","containerName":"length"},{"line":347,"kind":13,"containerName":"length","name":"$start"},{"name":"$end","containerName":"length","kind":13,"line":347},{"kind":13,"line":349,"name":"$self","containerName":"length"},{"kind":12,"line":349,"name":"up_subchain_length","containerName":"length"},{"line":349,"kind":13,"name":"$start","containerName":"length"},{"kind":13,"line":349,"name":"$end","containerName":"length"}],"line":343,"kind":12,"range":{"start":{"line":343,"character":0},"end":{"character":9999,"line":351}},"definition":"sub","name":"length","containerName":"main::"},{"name":"display_id","range":{"start":{"line":373,"character":0},"end":{"character":9999,"line":379}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}],"label":"display_id($self,$value)"},"kind":12,"line":373,"children":[{"kind":13,"line":374,"name":"$self","definition":"my","containerName":"display_id","localvar":"my"},{"line":374,"kind":13,"containerName":"display_id","name":"$value"},{"containerName":"display_id","name":"$value","kind":13,"line":375},{"line":376,"kind":13,"name":"$self","containerName":"display_id"},{"name":"$value","containerName":"display_id","line":376,"kind":13},{"containerName":"display_id","name":"$self","kind":13,"line":378}]},{"name":"accession_number","range":{"start":{"character":0,"line":398},"end":{"character":9999,"line":408}},"kind":12,"line":398,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"accession_number","line":399,"kind":13},{"name":"$value","containerName":"accession_number","line":399,"kind":13},{"name":"$value","containerName":"accession_number","line":400,"kind":13},{"kind":13,"line":401,"containerName":"accession_number","name":"$self"},{"containerName":"accession_number","name":"$value","line":401,"kind":13},{"name":"$self","containerName":"accession_number","kind":13,"line":403},{"line":406,"kind":13,"name":"$self","containerName":"accession_number"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"accession_number($self,$value)","documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}]}},{"kind":12,"line":428,"children":[{"name":"$self","definition":"my","containerName":"primary_id","localvar":"my","kind":13,"line":429},{"containerName":"primary_id","name":"$value","line":429,"kind":13},{"name":"$value","containerName":"primary_id","line":430,"kind":13},{"line":431,"kind":13,"containerName":"primary_id","name":"$self"},{"kind":13,"line":431,"name":"$value","containerName":"primary_id"},{"containerName":"primary_id","name":"$self","line":433,"kind":13},{"line":436,"kind":13,"name":"$self","containerName":"primary_id"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None","label":"primary_id($self,$value)"},"name":"primary_id","range":{"end":{"character":9999,"line":438},"start":{"character":0,"line":428}}},{"range":{"end":{"character":9999,"line":467},"start":{"character":0,"line":465}},"name":"change","definition":"sub","containerName":"main::","children":[],"line":465,"kind":12},{"name":"positionchange","line":466,"kind":12},{"range":{"end":{"character":9999,"line":488},"start":{"character":0,"line":476}},"name":"positionchange","detail":"($self,$newseq,$position,$length)","signature":{"parameters":[{"label":"$self"},{"label":"$newseq"},{"label":"$position"},{"label":"$length"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()","label":"positionchange($self,$newseq,$position,$length)"},"containerName":"main::","definition":"sub","line":476,"children":[{"containerName":"positionchange","name":"$self","definition":"my","localvar":"my","kind":13,"line":477},{"kind":13,"line":477,"name":"$newseq","containerName":"positionchange"},{"containerName":"positionchange","name":"$position","line":477,"kind":13},{"line":477,"kind":13,"name":"$length","containerName":"positionchange"},{"containerName":"positionchange","name":"$position","kind":13,"line":478},{"containerName":"positionchange","name":"$self","line":479,"kind":13},{"line":479,"kind":12,"containerName":"positionchange","name":"warn"},{"line":482,"kind":13,"localvar":"my","containerName":"positionchange","definition":"my","name":"$label"},{"line":482,"kind":13,"containerName":"positionchange","name":"$self"},{"containerName":"positionchange","name":"label","kind":12,"line":482},{"line":482,"kind":13,"containerName":"positionchange","name":"$position"},{"line":483,"kind":13,"containerName":"positionchange","name":"$label"},{"name":"$self","containerName":"positionchange","line":484,"kind":13},{"name":"warn","containerName":"positionchange","line":484,"kind":12},{"containerName":"positionchange","name":"$self","line":487,"kind":13},{"kind":12,"line":487,"name":"labelchange","containerName":"positionchange"},{"containerName":"positionchange","name":"$newseq","kind":13,"line":487},{"name":"$label","containerName":"positionchange","kind":13,"line":487},{"line":487,"kind":13,"containerName":"positionchange","name":"$length"}],"kind":12},{"signature":{"label":"labelchange($self,$newseq,$label,$length)","documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).","parameters":[{"label":"$self"},{"label":"$newseq"},{"label":"$label"},{"label":"$length"}]},"detail":"($self,$newseq,$label,$length)","definition":"sub","containerName":"main::","children":[{"containerName":"labelchange","name":"$self","definition":"my","localvar":"my","kind":13,"line":506},{"kind":13,"line":506,"containerName":"labelchange","name":"$newseq"},{"name":"$label","containerName":"labelchange","line":506,"kind":13},{"line":506,"kind":13,"name":"$length","containerName":"labelchange"},{"name":"$self","containerName":"labelchange","kind":13,"line":507},{"containerName":"labelchange","name":"valid","line":507,"kind":12},{"name":"$label","containerName":"labelchange","line":507,"kind":13},{"kind":13,"line":508,"containerName":"labelchange","name":"$self"},{"kind":12,"line":508,"name":"valid","containerName":"labelchange"},{"containerName":"labelchange","name":"$label","kind":13,"line":508},{"line":511,"kind":13,"name":"$self","containerName":"labelchange"},{"kind":12,"line":511,"name":"labelchange","containerName":"labelchange"},{"containerName":"labelchange","name":"$self","kind":13,"line":513},{"name":"warn","containerName":"labelchange","line":513,"kind":12},{"name":"$newseq","containerName":"labelchange","line":517,"kind":13},{"containerName":"labelchange","name":"$length","kind":13,"line":518},{"containerName":"labelchange","name":"$length","line":519,"kind":13},{"line":520,"kind":13,"containerName":"labelchange","name":"$self"},{"line":520,"kind":12,"containerName":"labelchange","name":"warn"},{"containerName":"labelchange","name":"$self","line":524,"kind":13},{"kind":12,"line":524,"containerName":"labelchange","name":"warn"},{"line":527,"kind":13,"containerName":"labelchange","name":"$self"},{"containerName":"labelchange","name":"_delete","line":527,"kind":12},{"line":527,"kind":13,"name":"$label","containerName":"labelchange"},{"line":527,"kind":13,"containerName":"labelchange","name":"$length"},{"kind":13,"line":529,"containerName":"labelchange","name":"$newseqlength","definition":"my","localvar":"my"},{"line":529,"kind":13,"containerName":"labelchange","name":"$newseq"},{"kind":13,"line":530,"containerName":"labelchange","name":"$length"},{"line":531,"kind":13,"name":"$length","containerName":"labelchange"},{"name":"$self","containerName":"labelchange","kind":13,"line":532},{"name":"warn","containerName":"labelchange","line":532,"kind":12},{"kind":13,"line":536,"containerName":"labelchange","name":"$length"},{"line":536,"kind":13,"containerName":"labelchange","name":"$newseqlength"},{"containerName":"labelchange","name":"$length","kind":13,"line":538},{"kind":13,"line":539,"definition":"my","name":"$insertbegin","containerName":"labelchange","localvar":"my"},{"line":539,"kind":13,"containerName":"labelchange","name":"$insertend"},{"name":"$self","containerName":"labelchange","line":539,"kind":13},{"line":539,"kind":12,"containerName":"labelchange","name":"_praeinsert"},{"containerName":"labelchange","name":"$label","kind":13,"line":539},{"name":"$newseq","containerName":"labelchange","line":539,"kind":13},{"kind":13,"line":540,"containerName":"labelchange","name":"$insertbegin"},{"containerName":"labelchange","name":"$newseqlength","kind":13,"line":546},{"kind":13,"line":546,"name":"$length","containerName":"labelchange"},{"kind":13,"line":547,"name":"$self","containerName":"labelchange"},{"containerName":"labelchange","name":"_mutate","kind":12,"line":547},{"line":547,"kind":13,"name":"$label","containerName":"labelchange"},{"kind":13,"line":547,"name":"$newseq","containerName":"labelchange"},{"containerName":"labelchange","name":"$length","line":547,"kind":13},{"localvar":"my","containerName":"labelchange","definition":"my","name":"$strand","line":550,"kind":13},{"line":550,"kind":13,"containerName":"labelchange","name":"$self"},{"kind":12,"line":550,"name":"strand","containerName":"labelchange"},{"localvar":"my","containerName":"labelchange","definition":"my","name":"$afterendlabel","line":551,"kind":13},{"line":551,"kind":13,"name":"$self","containerName":"labelchange"},{"line":551,"kind":12,"name":"label","containerName":"labelchange"},{"kind":13,"line":551,"containerName":"labelchange","name":"$length"},{"line":551,"kind":13,"containerName":"labelchange","name":"$label"},{"name":"$strand","containerName":"labelchange","kind":13,"line":551},{"line":552,"kind":13,"containerName":"labelchange","name":"$afterendlabel"},{"line":553,"kind":13,"name":"$self","containerName":"labelchange"},{"line":553,"kind":12,"name":"warn","containerName":"labelchange"},{"kind":13,"line":556,"name":"$deleted","definition":"my","containerName":"labelchange","localvar":"my"},{"containerName":"labelchange","name":"$self","line":556,"kind":13},{"line":556,"kind":12,"containerName":"labelchange","name":"_delete"},{"line":556,"kind":13,"name":"$label","containerName":"labelchange"},{"kind":13,"line":556,"containerName":"labelchange","name":"$length"},{"kind":13,"line":557,"name":"$deleted","containerName":"labelchange"},{"kind":13,"line":560,"containerName":"labelchange","definition":"my","name":"$insertbegin","localvar":"my"},{"kind":13,"line":560,"containerName":"labelchange","name":"$insertend"},{"containerName":"labelchange","name":"$self","kind":13,"line":560},{"name":"_praeinsert","containerName":"labelchange","kind":12,"line":560},{"name":"$afterendlabel","containerName":"labelchange","line":560,"kind":13},{"kind":13,"line":560,"name":"$newseq","containerName":"labelchange"},{"kind":13,"line":561,"name":"$insertbegin","containerName":"labelchange"}],"line":505,"kind":12,"range":{"end":{"character":9999,"line":567},"start":{"character":0,"line":505}},"name":"labelchange"},{"line":529,"kind":12,"name":"CORE","containerName":"length"},{"definition":"sub","containerName":"main::","signature":{"label":"_praeinsert($self,$label,$newseq)","parameters":[{"label":"$self"},{"label":"$label"},{"label":"$newseq"}],"documentation":" internal methods for change()\n arguments: label for beginning of deletion, new sequence to insert\n returns: labels of beginning and end of the inserted sequence\n errorcode: -1"},"detail":"($self,$label,$newseq)","kind":12,"children":[{"kind":13,"line":575,"name":"$self","definition":"my","containerName":"_praeinsert","localvar":"my"},{"line":575,"kind":13,"containerName":"_praeinsert","name":"$label"},{"kind":13,"line":575,"name":"$newseq","containerName":"_praeinsert"},{"line":576,"kind":13,"localvar":"my","containerName":"_praeinsert","name":"$insertbegin","definition":"my"},{"containerName":"_praeinsert","name":"$insertend","kind":13,"line":576},{"containerName":"_praeinsert","definition":"my","name":"$strand","localvar":"my","kind":13,"line":577},{"name":"$self","containerName":"_praeinsert","kind":13,"line":577},{"line":577,"kind":12,"containerName":"_praeinsert","name":"strand"},{"kind":13,"line":578,"name":"$strand","containerName":"_praeinsert"},{"line":579,"kind":13,"containerName":"_praeinsert","name":"$insertbegin"},{"kind":13,"line":579,"containerName":"_praeinsert","name":"$insertend"},{"name":"$self","containerName":"_praeinsert","kind":13,"line":579},{"containerName":"_praeinsert","name":"praeinsert_string","line":579,"kind":12},{"line":579,"kind":13,"name":"$newseq","containerName":"_praeinsert"},{"name":"$label","containerName":"_praeinsert","line":579,"kind":13},{"line":581,"kind":13,"containerName":"_praeinsert","name":"$newseq"},{"containerName":"_praeinsert","name":"$newseq","kind":13,"line":581},{"kind":13,"line":582,"containerName":"_praeinsert","name":"$newseq"},{"containerName":"_praeinsert","name":"$insertend","kind":13,"line":583},{"name":"$insertbegin","containerName":"_praeinsert","line":583,"kind":13},{"containerName":"_praeinsert","name":"$self","line":583,"kind":13},{"line":583,"kind":12,"containerName":"_praeinsert","name":"postinsert_string"},{"line":583,"kind":13,"name":"$newseq","containerName":"_praeinsert"},{"kind":13,"line":583,"name":"$label","containerName":"_praeinsert"},{"kind":13,"line":585,"containerName":"_praeinsert","name":"$insertbegin"},{"containerName":"_praeinsert","name":"$insertend","kind":13,"line":585},{"name":"$self","containerName":"_praeinsert","kind":13,"line":586},{"kind":12,"line":586,"containerName":"_praeinsert","name":"warn"},{"line":589,"kind":13,"name":"$insertbegin","containerName":"_praeinsert"},{"containerName":"_praeinsert","name":"$insertend","line":589,"kind":13}],"line":574,"name":"_praeinsert","range":{"end":{"line":591,"character":9999},"start":{"character":0,"line":574}}},{"detail":"($self,$label,$length)","signature":{"documentation":" arguments: label for beginning of deletion, length of deletion\n returns: string of deleted bases\n errorcode: -1","parameters":[{"label":"$self"},{"label":"$label"},{"label":"$length"}],"label":"_delete($self,$label,$length)"},"containerName":"main::","definition":"sub","line":596,"children":[{"line":597,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_delete"},{"line":597,"kind":13,"name":"$label","containerName":"_delete"},{"name":"$length","containerName":"_delete","kind":13,"line":597},{"line":598,"kind":13,"localvar":"my","definition":"my","name":"$strand","containerName":"_delete"},{"containerName":"_delete","name":"$self","kind":13,"line":598},{"kind":12,"line":598,"containerName":"_delete","name":"strand"},{"line":599,"kind":13,"localvar":"my","definition":"my","name":"$endlabel","containerName":"_delete"},{"containerName":"_delete","name":"$self","line":599,"kind":13},{"kind":12,"line":599,"name":"label","containerName":"_delete"},{"line":599,"kind":13,"containerName":"_delete","name":"$length"},{"kind":13,"line":599,"containerName":"_delete","name":"$label"},{"kind":13,"line":599,"name":"$strand","containerName":"_delete"},{"containerName":"_delete","name":"$endlabel","line":600,"kind":13},{"line":601,"kind":13,"containerName":"_delete","name":"$self"},{"containerName":"_delete","name":"warn","line":601,"kind":12},{"name":"$self","containerName":"_delete","kind":13,"line":605},{"line":605,"kind":12,"name":"_deletecheck","containerName":"_delete"},{"containerName":"_delete","name":"$label","line":605,"kind":13},{"containerName":"_delete","name":"$endlabel","kind":13,"line":605},{"kind":13,"line":606,"containerName":"_delete","definition":"my","name":"$deletedseq","localvar":"my"},{"containerName":"_delete","name":"$strand","kind":13,"line":607},{"containerName":"_delete","name":"$deletedseq","kind":13,"line":608},{"containerName":"_delete","name":"$self","kind":13,"line":608},{"containerName":"_delete","name":"splice_chain","line":608,"kind":12},{"kind":13,"line":608,"containerName":"_delete","name":"$label"},{"kind":13,"line":608,"name":"$endlabel","containerName":"_delete"},{"containerName":"_delete","name":"$deletedseq","line":610,"kind":13},{"kind":13,"line":610,"name":"$self","containerName":"_delete"},{"kind":12,"line":610,"name":"splice_chain","containerName":"_delete"},{"line":610,"kind":13,"containerName":"_delete","name":"$endlabel"},{"kind":13,"line":610,"name":"$label","containerName":"_delete"},{"name":"$deletedseq","containerName":"_delete","kind":13,"line":611},{"kind":13,"line":611,"containerName":"_delete","name":"$deletedseq"},{"containerName":"_delete","name":"$deletedseq","kind":13,"line":613},{"containerName":"_delete","name":"$deletedseq","kind":13,"line":615}],"kind":12,"range":{"end":{"line":616,"character":9999},"start":{"line":596,"character":0}},"name":"_delete"},{"range":{"end":{"line":620,"character":9999},"start":{"character":0,"line":619}},"containerName":"main::","name":"_deletecheck","definition":"sub","line":619,"children":[],"kind":12},{"range":{"start":{"line":625,"character":0},"end":{"line":678,"character":9999}},"name":"_mutate","line":625,"children":[{"localvar":"my","containerName":"_mutate","definition":"my","name":"$self","line":626,"kind":13},{"name":"$label","containerName":"_mutate","line":626,"kind":13},{"kind":13,"line":626,"name":"$newseq","containerName":"_mutate"},{"line":626,"kind":13,"containerName":"_mutate","name":"$length"},{"name":"$i","definition":"my","containerName":"_mutate","localvar":"my","kind":13,"line":627},{"name":"$base","containerName":"_mutate","line":627,"kind":13},{"name":"$nextlabel","containerName":"_mutate","line":627,"kind":13},{"kind":13,"line":628,"containerName":"_mutate","name":"@labels","definition":"my","localvar":"my"},{"localvar":"my","containerName":"_mutate","name":"$strand","definition":"my","line":629,"kind":13},{"name":"$self","containerName":"_mutate","line":629,"kind":13},{"line":629,"kind":12,"name":"strand","containerName":"_mutate"},{"line":630,"kind":13,"containerName":"_mutate","name":"$length"},{"name":"@labels","containerName":"_mutate","line":631,"kind":13},{"line":631,"kind":13,"name":"$label","containerName":"_mutate"},{"line":633,"kind":13,"localvar":"my","definition":"my","name":"$endlabel","containerName":"_mutate"},{"kind":13,"line":633,"containerName":"_mutate","name":"$self"},{"containerName":"_mutate","name":"label","line":633,"kind":12},{"name":"$length","containerName":"_mutate","line":633,"kind":13},{"containerName":"_mutate","name":"$label","line":633,"kind":13},{"containerName":"_mutate","name":"$strand","line":633,"kind":13},{"line":634,"kind":13,"containerName":"_mutate","name":"$endlabel"},{"kind":13,"line":635,"containerName":"_mutate","name":"$self"},{"line":635,"kind":12,"name":"warn","containerName":"_mutate"},{"containerName":"_mutate","name":"$length","line":638,"kind":13},{"line":639,"kind":13,"name":"@labels","containerName":"_mutate"},{"line":639,"kind":13,"containerName":"_mutate","name":"$label"},{"line":639,"kind":13,"containerName":"_mutate","name":"$endlabel"},{"containerName":"_mutate","name":"@labels","line":655,"kind":13},{"name":"$label","containerName":"_mutate","line":655,"kind":13},{"line":656,"kind":13,"containerName":"_mutate","name":"$label"},{"name":"$endlabel","containerName":"_mutate","kind":13,"line":656},{"line":657,"kind":13,"name":"$nextlabel","containerName":"_mutate"},{"kind":13,"line":657,"name":"$self","containerName":"_mutate"},{"kind":12,"line":657,"containerName":"_mutate","name":"label"},{"kind":13,"line":657,"containerName":"_mutate","name":"$label"},{"line":657,"kind":13,"containerName":"_mutate","name":"$strand"},{"name":"@labels","containerName":"_mutate","line":658,"kind":13},{"line":658,"kind":13,"name":"$nextlabel","containerName":"_mutate"},{"name":"$label","containerName":"_mutate","kind":13,"line":659},{"containerName":"_mutate","name":"$nextlabel","line":659,"kind":13},{"kind":13,"line":663,"name":"$strand","containerName":"_mutate"},{"containerName":"_mutate","name":"$newseq","line":664,"kind":13},{"kind":13,"line":666,"definition":"my","name":"$errorcheck","containerName":"_mutate","localvar":"my"},{"line":667,"kind":13,"containerName":"_mutate","name":"$i"},{"containerName":"_mutate","name":"$base","kind":13,"line":668},{"kind":13,"line":668,"name":"$newseq","containerName":"_mutate"},{"containerName":"_mutate","name":"$errorcheck","line":669,"kind":13},{"name":"$self","containerName":"_mutate","kind":13,"line":669},{"line":669,"kind":12,"name":"set_value_at_label","containerName":"_mutate"},{"line":669,"kind":13,"containerName":"_mutate","name":"$base"},{"containerName":"_mutate","name":"$labels","kind":13,"line":669},{"line":669,"kind":13,"name":"$i","containerName":"_mutate"},{"containerName":"_mutate","name":"$i","kind":13,"line":670},{"line":672,"kind":13,"name":"$errorcheck","containerName":"_mutate"},{"line":672,"kind":13,"name":"$length","containerName":"_mutate"},{"name":"$self","containerName":"_mutate","line":673,"kind":13},{"name":"warn","containerName":"_mutate","line":673,"kind":12}],"kind":12,"detail":"($self,$label,$newseq,$length)","signature":{"label":"_mutate($self,$label,$newseq,$length)","parameters":[{"label":"$self"},{"label":"$label"},{"label":"$newseq"},{"label":"$length"}],"documentation":" arguments: label for beginning of mutation, newsequence, number of mutations\n returns: 1 all OK\n errorcode: -1"},"containerName":"main::","definition":"sub"},{"range":{"end":{"character":9999,"line":702},"start":{"character":0,"line":692}},"name":"valid","children":[{"name":"$self","definition":"my","containerName":"valid","localvar":"my","kind":13,"line":693},{"kind":13,"line":693,"containerName":"valid","name":"$label"},{"kind":13,"line":694,"definition":"my","name":"$checkme","containerName":"valid","localvar":"my"},{"kind":13,"line":695,"containerName":"valid","definition":"my","name":"@labels","localvar":"my"},{"name":"$self","containerName":"valid","line":695,"kind":13},{"containerName":"valid","name":"all_labels","line":695,"kind":12},{"containerName":"valid","name":"$checkme","kind":13,"line":696},{"containerName":"valid","name":"@labels","line":696,"kind":13},{"name":"$label","containerName":"valid","kind":13,"line":697},{"name":"$checkme","containerName":"valid","kind":13,"line":697}],"line":692,"kind":12,"signature":{"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n argument: label\n returns: 1 YES 0 NO","parameters":[{"label":"$self"},{"label":"$label"}],"label":"valid($self,$label)"},"detail":"($self,$label)","definition":"sub","containerName":"main::"},{"range":{"start":{"line":715,"character":0},"end":{"character":9999,"line":718}},"name":"start","detail":"($self)","signature":{"label":"start($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none"},"containerName":"main::","definition":"sub","line":715,"children":[{"kind":13,"line":716,"definition":"my","name":"$self","containerName":"start","localvar":"my"},{"name":"$self","containerName":"start","kind":13,"line":717}],"kind":12},{"children":[{"line":731,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"end"},{"kind":13,"line":732,"containerName":"end","name":"$self"}],"line":730,"kind":12,"signature":{"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none","parameters":[{"label":"$self"}],"label":"end($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":733},"start":{"character":0,"line":730}},"name":"end"},{"name":"strand","range":{"end":{"line":756,"character":9999},"start":{"character":0,"line":746}},"kind":12,"children":[{"localvar":"my","containerName":"strand","definition":"my","name":"$self","line":747,"kind":13},{"kind":13,"line":747,"name":"$strand","containerName":"strand"},{"line":748,"kind":13,"containerName":"strand","name":"$strand"},{"containerName":"strand","name":"$strand","line":749,"kind":13},{"containerName":"strand","name":"$strand","kind":13,"line":749},{"kind":13,"line":750,"containerName":"strand","name":"$self"},{"name":"warn","containerName":"strand","line":750,"kind":12},{"name":"$self","containerName":"strand","line":752,"kind":13},{"kind":13,"line":752,"name":"$strand","containerName":"strand"},{"containerName":"strand","name":"$self","kind":13,"line":755}],"line":746,"definition":"sub","containerName":"main::","signature":{"label":"strand($self,$strand)","parameters":[{"label":"$self"},{"label":"$strand"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1"},"detail":"($self,$strand)"},{"detail":"($self,$value)","signature":{"label":"alphabet($self,$value)","documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","line":771,"children":[{"localvar":"my","definition":"my","name":"%valid_type","containerName":"alphabet","line":772,"kind":13},{"kind":13,"line":773,"name":"$self","definition":"my","containerName":"alphabet","localvar":"my"},{"kind":13,"line":773,"name":"$value","containerName":"alphabet"},{"line":774,"kind":13,"name":"$value","containerName":"alphabet"},{"containerName":"alphabet","name":"$value","line":775,"kind":13},{"line":775,"kind":13,"name":"$value","containerName":"alphabet"},{"containerName":"alphabet","name":"$value","kind":13,"line":776},{"containerName":"alphabet","name":"$value","kind":13,"line":776},{"line":777,"kind":13,"containerName":"alphabet","name":"$valid_type"},{"containerName":"alphabet","name":"$value","kind":13,"line":777},{"containerName":"alphabet","name":"$self","kind":13,"line":778},{"containerName":"alphabet","name":"warn","line":778,"kind":12},{"kind":13,"line":780,"name":"$self","containerName":"alphabet"},{"name":"$value","containerName":"alphabet","line":780,"kind":13},{"name":"$self","containerName":"alphabet","line":782,"kind":13}],"kind":12,"range":{"end":{"line":783,"character":9999},"start":{"character":0,"line":771}},"name":"alphabet"},{"name":"coordinate_start","range":{"start":{"line":802,"character":0},"end":{"character":9999,"line":817}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none\n\n\n\nsub alphabet {\n  my %valid_type = map {$_, 1} qw( dna rna protein );\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $value = 'dna' if $value =~ /dna/i;\n    $value = 'rna' if $value =~ /rna/i;\n    unless ( $valid_type{$value} ) {\n      $self->warn(\"Molecular type '$value' is not a valid type\");\n    }\n    $self->{'alphabet'} = $value;\n  }\n  return $self->{'alphabet'};\n}\n\n=head2 coordinate_start\n\n  Title   : coordinate_start\n  Usage   : $coordstartlabel=$obj->coordinate_start()\n          : $coordstartlabel=$obj->coordinate_start($label)\n  Function: returns and optionally sets the first label of the coordinate\n            system used\n            For some objects only labels inside the object or in frame (for\n            Translation objects) will be allowed to get set as coordinate start\n\n  Returns : label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : an optional reference $label that is position 1","parameters":[{"label":"$self"},{"label":"$label"}],"label":"coordinate_start($self,$label)"},"detail":"($self,$label)","kind":12,"children":[{"localvar":"my","containerName":"coordinate_start","definition":"my","name":"$self","line":803,"kind":13},{"name":"$label","containerName":"coordinate_start","kind":13,"line":803},{"kind":13,"line":804,"containerName":"coordinate_start","name":"$label"},{"name":"$self","containerName":"coordinate_start","line":805,"kind":13},{"kind":12,"line":805,"containerName":"coordinate_start","name":"valid"},{"name":"$label","containerName":"coordinate_start","kind":13,"line":805},{"containerName":"coordinate_start","name":"$self","line":806,"kind":13},{"containerName":"coordinate_start","name":"$label","kind":13,"line":806},{"name":"$self","containerName":"coordinate_start","kind":13,"line":808},{"line":808,"kind":12,"name":"warn","containerName":"coordinate_start"},{"line":811,"kind":13,"localvar":"my","containerName":"coordinate_start","name":"$coord_start","definition":"my"},{"name":"$self","containerName":"coordinate_start","kind":13,"line":811},{"line":812,"kind":13,"containerName":"coordinate_start","name":"$coord_start"},{"kind":13,"line":813,"name":"$coord_start","containerName":"coordinate_start"},{"name":"$self","containerName":"coordinate_start","line":815,"kind":13},{"containerName":"coordinate_start","name":"start","line":815,"kind":12}],"line":802},{"name":"label","range":{"start":{"line":841,"character":0},"end":{"character":9999,"line":868}},"kind":12,"children":[{"line":842,"kind":13,"localvar":"my","containerName":"label","name":"$self","definition":"my"},{"line":842,"kind":13,"name":"$position","containerName":"label"},{"containerName":"label","name":"$firstlabel","line":842,"kind":13},{"line":842,"kind":13,"name":"$strand","containerName":"label"},{"name":"$label","definition":"my","containerName":"label","localvar":"my","kind":13,"line":843},{"line":844,"kind":13,"name":"$firstlabel","containerName":"label"},{"line":845,"kind":13,"containerName":"label","name":"$firstlabel"},{"line":845,"kind":13,"name":"$self","containerName":"label"},{"name":"coordinate_start","containerName":"label","line":845,"kind":12},{"containerName":"label","name":"$position","line":847,"kind":13},{"name":"$self","containerName":"label","line":848,"kind":13},{"line":848,"kind":12,"containerName":"label","name":"warn"},{"line":851,"kind":13,"name":"$strand","containerName":"label"},{"name":"$strand","containerName":"label","kind":13,"line":852},{"containerName":"label","name":"$self","kind":13,"line":852},{"kind":12,"line":852,"name":"strand","containerName":"label"},{"name":"$strand","containerName":"label","kind":13,"line":854},{"name":"$position","containerName":"label","kind":13,"line":855},{"line":856,"kind":13,"containerName":"label","name":"$label"},{"name":"$self","containerName":"label","line":856,"kind":13},{"containerName":"label","name":"down_get_label_at_pos","line":856,"kind":12},{"containerName":"label","name":"$position","kind":13,"line":856},{"line":856,"kind":13,"containerName":"label","name":"$firstlabel"},{"containerName":"label","name":"$label","kind":13,"line":858},{"name":"$self","containerName":"label","line":858,"kind":13},{"line":858,"kind":12,"name":"up_get_label_at_pos","containerName":"label"},{"name":"$position","containerName":"label","kind":13,"line":858},{"containerName":"label","name":"$firstlabel","line":858,"kind":13},{"line":861,"kind":13,"name":"$position","containerName":"label"},{"name":"$label","containerName":"label","kind":13,"line":862},{"containerName":"label","name":"$self","kind":13,"line":862},{"name":"up_get_label_at_pos","containerName":"label","line":862,"kind":12},{"kind":13,"line":862,"containerName":"label","name":"$position"},{"containerName":"label","name":"$firstlabel","line":862,"kind":13},{"kind":13,"line":864,"name":"$label","containerName":"label"},{"containerName":"label","name":"$self","line":864,"kind":13},{"containerName":"label","name":"down_get_label_at_pos","kind":12,"line":864},{"kind":13,"line":864,"name":"$position","containerName":"label"},{"line":864,"kind":13,"containerName":"label","name":"$firstlabel"},{"line":867,"kind":13,"containerName":"label","name":"$label"}],"line":841,"definition":"sub","containerName":"main::","signature":{"label":"label($self,$position,$firstlabel,$strand)","parameters":[{"label":"$self"},{"label":"$position"},{"label":"$firstlabel"},{"label":"$strand"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none\n\n\n\nsub alphabet {\n  my %valid_type = map {$_, 1} qw( dna rna protein );\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $value = 'dna' if $value =~ /dna/i;\n    $value = 'rna' if $value =~ /rna/i;\n    unless ( $valid_type{$value} ) {\n      $self->warn(\"Molecular type '$value' is not a valid type\");\n    }\n    $self->{'alphabet'} = $value;\n  }\n  return $self->{'alphabet'};\n}\n\n=head2 coordinate_start\n\n  Title   : coordinate_start\n  Usage   : $coordstartlabel=$obj->coordinate_start()\n          : $coordstartlabel=$obj->coordinate_start($label)\n  Function: returns and optionally sets the first label of the coordinate\n            system used\n            For some objects only labels inside the object or in frame (for\n            Translation objects) will be allowed to get set as coordinate start\n\n  Returns : label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : an optional reference $label that is position 1\n\n\n\nsub coordinate_start {\n  my ($self,$label) = @_;\n  if ($label) {\n    if ($self->valid($label)) {\n      $self->{'coordinate_start'} = $label;\n    } else {\n      $self->warn(\"The label you are trying to set as coordinate_start is not valid for this object\");\n    }\n  }\n  my $coord_start = $self->{'coordinate_start'};\n  if ($coord_start) { \n    return $coord_start;\n  } else {\n    return $self->start();\n  }\n}\n\n=head2 label\n\n  Title   : label\n  Usage   : $seq->label($position)\n          : $seq->label($position,$firstlabel)\n  Examples: $nextlabel=$seq->label(2,$label) -> retrieves the following label\n          : $prevlabel=$seq->label(-1,$label) -> retrieves the preceding label\n\n  Function: returns the label of the nucleotide at $position from current\n            coordinate start\n  Returns : a label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : a position, \n            an optional reference $firstlabel that is to be used as position 1\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method"},"detail":"($self,$position,$firstlabel,$strand)"},{"name":"position","range":{"start":{"character":0,"line":889},"end":{"line":918,"character":9999}},"kind":12,"line":889,"children":[{"containerName":"position","definition":"my","name":"$self","localvar":"my","kind":13,"line":890},{"line":890,"kind":13,"containerName":"position","name":"$label"},{"kind":13,"line":890,"containerName":"position","name":"$firstlabel"},{"line":890,"kind":13,"name":"$strand","containerName":"position"},{"kind":13,"line":891,"name":"$strand","containerName":"position"},{"line":892,"kind":13,"containerName":"position","name":"$strand"},{"containerName":"position","name":"$self","kind":13,"line":892},{"containerName":"position","name":"strand","kind":12,"line":892},{"line":894,"kind":13,"name":"$firstlabel","containerName":"position"},{"name":"$firstlabel","containerName":"position","kind":13,"line":895},{"containerName":"position","name":"$self","line":895,"kind":13},{"kind":12,"line":895,"containerName":"position","name":"coordinate_start"},{"kind":13,"line":897,"containerName":"position","name":"$self"},{"containerName":"position","name":"valid","kind":12,"line":897},{"kind":13,"line":897,"name":"$label","containerName":"position"},{"kind":13,"line":898,"name":"$self","containerName":"position"},{"containerName":"position","name":"warn","line":898,"kind":12},{"line":901,"kind":13,"name":"$firstlabel","containerName":"position"},{"line":901,"kind":13,"name":"$label","containerName":"position"},{"kind":13,"line":904,"definition":"my","name":"$coordpos","containerName":"position","localvar":"my"},{"kind":13,"line":904,"containerName":"position","name":"$position0"},{"containerName":"position","name":"$position","kind":13,"line":904},{"kind":13,"line":905,"containerName":"position","name":"$position0"},{"kind":13,"line":905,"containerName":"position","name":"$self"},{"kind":12,"line":905,"name":"down_get_pos_of_label","containerName":"position"},{"name":"$label","containerName":"position","line":905,"kind":13},{"kind":13,"line":906,"name":"$coordpos","containerName":"position"},{"line":906,"kind":13,"name":"$self","containerName":"position"},{"containerName":"position","name":"down_get_pos_of_label","kind":12,"line":906},{"containerName":"position","name":"$firstlabel","line":906,"kind":13},{"line":907,"kind":13,"name":"$position","containerName":"position"},{"line":907,"kind":13,"name":"$position0","containerName":"position"},{"kind":13,"line":907,"name":"$coordpos","containerName":"position"},{"line":908,"kind":13,"containerName":"position","name":"$position"},{"name":"$position","containerName":"position","kind":13,"line":909},{"name":"$strand","containerName":"position","kind":13,"line":911},{"name":"$position","containerName":"position","kind":13,"line":913},{"containerName":"position","name":"$position","kind":13,"line":916}],"containerName":"main::","definition":"sub","detail":"($self,$label,$firstlabel,$strand)","signature":{"label":"position($self,$label,$firstlabel,$strand)","documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none\n\n\n\nsub alphabet {\n  my %valid_type = map {$_, 1} qw( dna rna protein );\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $value = 'dna' if $value =~ /dna/i;\n    $value = 'rna' if $value =~ /rna/i;\n    unless ( $valid_type{$value} ) {\n      $self->warn(\"Molecular type '$value' is not a valid type\");\n    }\n    $self->{'alphabet'} = $value;\n  }\n  return $self->{'alphabet'};\n}\n\n=head2 coordinate_start\n\n  Title   : coordinate_start\n  Usage   : $coordstartlabel=$obj->coordinate_start()\n          : $coordstartlabel=$obj->coordinate_start($label)\n  Function: returns and optionally sets the first label of the coordinate\n            system used\n            For some objects only labels inside the object or in frame (for\n            Translation objects) will be allowed to get set as coordinate start\n\n  Returns : label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : an optional reference $label that is position 1\n\n\n\nsub coordinate_start {\n  my ($self,$label) = @_;\n  if ($label) {\n    if ($self->valid($label)) {\n      $self->{'coordinate_start'} = $label;\n    } else {\n      $self->warn(\"The label you are trying to set as coordinate_start is not valid for this object\");\n    }\n  }\n  my $coord_start = $self->{'coordinate_start'};\n  if ($coord_start) { \n    return $coord_start;\n  } else {\n    return $self->start();\n  }\n}\n\n=head2 label\n\n  Title   : label\n  Usage   : $seq->label($position)\n          : $seq->label($position,$firstlabel)\n  Examples: $nextlabel=$seq->label(2,$label) -> retrieves the following label\n          : $prevlabel=$seq->label(-1,$label) -> retrieves the preceding label\n\n  Function: returns the label of the nucleotide at $position from current\n            coordinate start\n  Returns : a label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : a position, \n            an optional reference $firstlabel that is to be used as position 1\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub label {\n  my ($self,$position,$firstlabel,$strand)=@_;\n  my $label;\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($position) {  # if position = 0 complain ?\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    if ($position > 0) {\n      $label=$self->{'seq'}->down_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->up_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  } else {\n    if ($position > 0) {\n      $label=$self->{'seq'}->up_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->down_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  }\n  return $label;\n}\n\n\n=head2 position\n\n  Title   : position\n  Usage   : $seq->position($label)\n          : $seq->position($label,$firstlabel)\n  Function: returns the position of nucleotide at $label\n  Returns : the position of the label from current coordinate start\n  Errorcode 0\n  Args    : a label pointing to a certain nucleotide (e.g. start of exon)\n            an optional \"firstlabel\" as reference to count from\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method","parameters":[{"label":"$self"},{"label":"$label"},{"label":"$firstlabel"},{"label":"$strand"}]}},{"detail":"($self,$firstlabel,$secondlabel,$strand)","signature":{"label":"follows($self,$firstlabel,$secondlabel,$strand)","parameters":[{"label":"$self"},{"label":"$firstlabel"},{"label":"$secondlabel"},{"label":"$strand"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none\n\n\n\nsub alphabet {\n  my %valid_type = map {$_, 1} qw( dna rna protein );\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $value = 'dna' if $value =~ /dna/i;\n    $value = 'rna' if $value =~ /rna/i;\n    unless ( $valid_type{$value} ) {\n      $self->warn(\"Molecular type '$value' is not a valid type\");\n    }\n    $self->{'alphabet'} = $value;\n  }\n  return $self->{'alphabet'};\n}\n\n=head2 coordinate_start\n\n  Title   : coordinate_start\n  Usage   : $coordstartlabel=$obj->coordinate_start()\n          : $coordstartlabel=$obj->coordinate_start($label)\n  Function: returns and optionally sets the first label of the coordinate\n            system used\n            For some objects only labels inside the object or in frame (for\n            Translation objects) will be allowed to get set as coordinate start\n\n  Returns : label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : an optional reference $label that is position 1\n\n\n\nsub coordinate_start {\n  my ($self,$label) = @_;\n  if ($label) {\n    if ($self->valid($label)) {\n      $self->{'coordinate_start'} = $label;\n    } else {\n      $self->warn(\"The label you are trying to set as coordinate_start is not valid for this object\");\n    }\n  }\n  my $coord_start = $self->{'coordinate_start'};\n  if ($coord_start) { \n    return $coord_start;\n  } else {\n    return $self->start();\n  }\n}\n\n=head2 label\n\n  Title   : label\n  Usage   : $seq->label($position)\n          : $seq->label($position,$firstlabel)\n  Examples: $nextlabel=$seq->label(2,$label) -> retrieves the following label\n          : $prevlabel=$seq->label(-1,$label) -> retrieves the preceding label\n\n  Function: returns the label of the nucleotide at $position from current\n            coordinate start\n  Returns : a label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : a position, \n            an optional reference $firstlabel that is to be used as position 1\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub label {\n  my ($self,$position,$firstlabel,$strand)=@_;\n  my $label;\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($position) {  # if position = 0 complain ?\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    if ($position > 0) {\n      $label=$self->{'seq'}->down_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->up_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  } else {\n    if ($position > 0) {\n      $label=$self->{'seq'}->up_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->down_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  }\n  return $label;\n}\n\n\n=head2 position\n\n  Title   : position\n  Usage   : $seq->position($label)\n          : $seq->position($label,$firstlabel)\n  Function: returns the position of nucleotide at $label\n  Returns : the position of the label from current coordinate start\n  Errorcode 0\n  Args    : a label pointing to a certain nucleotide (e.g. start of exon)\n            an optional \"firstlabel\" as reference to count from\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub position {\n  my ($self,$label,$firstlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($self->valid($label)) {\n    $self->warn(\"label not valid\");\n    return (0);\n  }\n  if ($firstlabel == $label) {\n    return (1);\n  }\n  my ($coordpos,$position0,$position);\n  $position0=$self->{'seq'}->down_get_pos_of_label($label);\n  $coordpos=$self->{'seq'}->down_get_pos_of_label($firstlabel);\n  $position=$position0-$coordpos+1;\n  if ($position <= 0) {\n    $position--;\n  }\n  if ($strand == -1) {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",1-$position;\n    return (1-$position);\n  } else {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",$position;\n    return ($position);\n  }\n}\n\n=head2 follows\n\n  Title   : follows\n  Usage   : $seq->follows($firstlabel,$secondlabel)\n          : $seq->follows($firstlabel,$secondlabel,$strand)\n  Function: checks if SECONDlabel follows FIRSTlabel, undependent of the strand\n            i.e. it checks downstream for forward strand and\n            upstream for reverse strand\n  Returns : 1 or 0\n  Errorcode -1\n  Args    : two labels\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n'\n wraparound to is_downstream and is_upstream that chooses the correct one\n depending on the strand"},"containerName":"main::","definition":"sub","line":941,"children":[{"line":942,"kind":13,"localvar":"my","containerName":"follows","name":"$self","definition":"my"},{"name":"$firstlabel","containerName":"follows","line":942,"kind":13},{"name":"$secondlabel","containerName":"follows","line":942,"kind":13},{"line":942,"kind":13,"name":"$strand","containerName":"follows"},{"kind":13,"line":943,"name":"$strand","containerName":"follows"},{"name":"$strand","containerName":"follows","line":944,"kind":13},{"line":944,"kind":13,"name":"$self","containerName":"follows"},{"kind":12,"line":944,"name":"strand","containerName":"follows"},{"name":"$strand","containerName":"follows","line":946,"kind":13},{"line":947,"kind":13,"name":"$self","containerName":"follows"},{"containerName":"follows","name":"is_downstream","kind":12,"line":947},{"line":947,"kind":13,"name":"$firstlabel","containerName":"follows"},{"name":"$secondlabel","containerName":"follows","line":947,"kind":13},{"name":"$self","containerName":"follows","line":949,"kind":13},{"kind":12,"line":949,"name":"is_upstream","containerName":"follows"},{"kind":13,"line":949,"name":"$firstlabel","containerName":"follows"},{"name":"$secondlabel","containerName":"follows","kind":13,"line":949}],"kind":12,"range":{"start":{"line":941,"character":0},"end":{"line":951,"character":9999}},"name":"follows"},{"definition":"sub","containerName":"main::","signature":{"label":"gene($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none\n\n\n\nsub alphabet {\n  my %valid_type = map {$_, 1} qw( dna rna protein );\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $value = 'dna' if $value =~ /dna/i;\n    $value = 'rna' if $value =~ /rna/i;\n    unless ( $valid_type{$value} ) {\n      $self->warn(\"Molecular type '$value' is not a valid type\");\n    }\n    $self->{'alphabet'} = $value;\n  }\n  return $self->{'alphabet'};\n}\n\n=head2 coordinate_start\n\n  Title   : coordinate_start\n  Usage   : $coordstartlabel=$obj->coordinate_start()\n          : $coordstartlabel=$obj->coordinate_start($label)\n  Function: returns and optionally sets the first label of the coordinate\n            system used\n            For some objects only labels inside the object or in frame (for\n            Translation objects) will be allowed to get set as coordinate start\n\n  Returns : label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : an optional reference $label that is position 1\n\n\n\nsub coordinate_start {\n  my ($self,$label) = @_;\n  if ($label) {\n    if ($self->valid($label)) {\n      $self->{'coordinate_start'} = $label;\n    } else {\n      $self->warn(\"The label you are trying to set as coordinate_start is not valid for this object\");\n    }\n  }\n  my $coord_start = $self->{'coordinate_start'};\n  if ($coord_start) { \n    return $coord_start;\n  } else {\n    return $self->start();\n  }\n}\n\n=head2 label\n\n  Title   : label\n  Usage   : $seq->label($position)\n          : $seq->label($position,$firstlabel)\n  Examples: $nextlabel=$seq->label(2,$label) -> retrieves the following label\n          : $prevlabel=$seq->label(-1,$label) -> retrieves the preceding label\n\n  Function: returns the label of the nucleotide at $position from current\n            coordinate start\n  Returns : a label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : a position, \n            an optional reference $firstlabel that is to be used as position 1\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub label {\n  my ($self,$position,$firstlabel,$strand)=@_;\n  my $label;\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($position) {  # if position = 0 complain ?\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    if ($position > 0) {\n      $label=$self->{'seq'}->down_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->up_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  } else {\n    if ($position > 0) {\n      $label=$self->{'seq'}->up_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->down_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  }\n  return $label;\n}\n\n\n=head2 position\n\n  Title   : position\n  Usage   : $seq->position($label)\n          : $seq->position($label,$firstlabel)\n  Function: returns the position of nucleotide at $label\n  Returns : the position of the label from current coordinate start\n  Errorcode 0\n  Args    : a label pointing to a certain nucleotide (e.g. start of exon)\n            an optional \"firstlabel\" as reference to count from\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub position {\n  my ($self,$label,$firstlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($self->valid($label)) {\n    $self->warn(\"label not valid\");\n    return (0);\n  }\n  if ($firstlabel == $label) {\n    return (1);\n  }\n  my ($coordpos,$position0,$position);\n  $position0=$self->{'seq'}->down_get_pos_of_label($label);\n  $coordpos=$self->{'seq'}->down_get_pos_of_label($firstlabel);\n  $position=$position0-$coordpos+1;\n  if ($position <= 0) {\n    $position--;\n  }\n  if ($strand == -1) {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",1-$position;\n    return (1-$position);\n  } else {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",$position;\n    return ($position);\n  }\n}\n\n=head2 follows\n\n  Title   : follows\n  Usage   : $seq->follows($firstlabel,$secondlabel)\n          : $seq->follows($firstlabel,$secondlabel,$strand)\n  Function: checks if SECONDlabel follows FIRSTlabel, undependent of the strand\n            i.e. it checks downstream for forward strand and\n            upstream for reverse strand\n  Returns : 1 or 0\n  Errorcode -1\n  Args    : two labels\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n#'\n# wraparound to is_downstream and is_upstream that chooses the correct one\n# depending on the strand\nsub follows {\n  my ($self,$firstlabel,$secondlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    return ($self->{'seq'}->is_downstream($firstlabel,$secondlabel));\n  } else {\n    return ($self->{'seq'}->is_upstream($firstlabel,$secondlabel));\n  }\n}\n#\n#=head2 translate\n#\n# Title   : translate\n# Usage   : $protein_seq = $obj->translate\n# Function: Provides the translation of the DNA sequence\n#\t    using full IUPAC ambiguities in DNA/RNA and amino acid codes.\n#\n#\t    The resulting translation is identical to EMBL/TREMBL database \n#\t    translations.\n#\n# Returns : a string\n# Args    : character for terminator (optional) defaults to '*'\n#\t    character for unknown amino acid (optional) defaults to 'X'\n#\t    frame (optional) valid values 0, 1, 3, defaults to 0\n#\t    codon table id (optional) defaults to 1\n#\n#=cut\n#\n#sub translate {\n#  my ($self) = shift;\n#  return ($self->translate_string($self->seq,@_));\n#}\n#\n#=head2 translate_string\n#\n# Title   : translate_string\n# Usage   : $protein_seq = $obj->translate_string(\"attcgtgttgatcgatta\");\n# Function: Like translate, but can be used to translate subsequences after\n#\t    having retrieved them as string.\n# Args    : 1st argument is a string. Optional following arguments: like in\n#\t    the translate method\n#\n#=cut\n#\n#\n#sub translate_string {\n#  my($self) = shift;\n#  my($seq) = shift;\n#  my($stop, $unknown, $frame, $tableid) = @_;\n#  my($i, $len, $output) = (0,0,'');\n#  my($codon)   = \"\";\n#  my $aa;\n#\n#\n#  ## User can pass in symbol for stop and unknown codons\n#  unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n#  unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n#  unless(defined($frame) and $frame ne '') { $frame = 0; }\n#\n#  ## the codon table ID \n#  if ($self->translation_table) {\n#    $tableid = $self->translation_table;\n#  }\n#  unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n#\n#  ##Error if monomer is \"Amino\"\n#  $self->warn(\"Can't translate an amino acid sequence.\") \n#      if (defined $self->alphabet && $self->alphabet eq 'protein');\n#\n#  ##Error if frame is not 0, 1 or 2\n#  $self->warn(\"Valid values for frame are 0, 1, 2, not [$frame].\")\n#      unless ($frame == 0 or $frame == 1 or $frame == 2);\n#\n#  #thows a warning if ID is invalid \n#  my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n#\n#  # deal with frame offset.\n#  if( $frame ) {\n#      $seq = substr ($seq,$frame);\n#  }\n#\n#  for $codon ( grep { CORE::length == 3 } split(/(.{3})/, $seq) ) {\n#      my $aa = $codonTable->translate($codon);\n#      if ($aa eq '*') {\n#\t    $output .= $stop;\n#      }\n#      elsif ($aa eq 'X') {\n#\t    $output .= $unknown;\n#      }\n#      else { \n#\t   $output .= $aa ;\n#      }   \n#  }\n#  #if( substr($output,-1,1) eq $stop ) {\n#  #    chop $output;\n#  #}\n#\n#  return ($output);\n#}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene=$obj->gene;\n Function: Gets or sets the reference to the LiveSeq::Gene object.\n           Objects that are features of a LiveSeq Gene will have this\n           attribute set automatically.\n\n Returns : reference to an object of class Gene\n Note    : if Gene object is not set, this method will return 0;\n Args    : none or reference to object of class Bio::LiveSeq::Gene"},"detail":"($self,$value)","kind":12,"children":[{"line":1058,"kind":13,"localvar":"my","containerName":"gene","name":"$self","definition":"my"},{"line":1058,"kind":13,"name":"$value","containerName":"gene"},{"kind":13,"line":1059,"name":"$value","containerName":"gene"},{"kind":13,"line":1060,"containerName":"gene","name":"$self"},{"line":1060,"kind":13,"containerName":"gene","name":"$value"},{"containerName":"gene","name":"$self","kind":13,"line":1062},{"containerName":"gene","name":"$self","line":1065,"kind":13}],"line":1057,"name":"gene","range":{"start":{"character":0,"line":1057},"end":{"line":1067,"character":9999}}},{"children":[{"kind":13,"line":1081,"containerName":"obj_valid","definition":"my","name":"$self","localvar":"my"},{"containerName":"obj_valid","name":"$self","kind":13,"line":1082},{"name":"valid","containerName":"obj_valid","kind":12,"line":1082},{"name":"$self","containerName":"obj_valid","kind":13,"line":1082},{"containerName":"obj_valid","name":"start","kind":12,"line":1082},{"containerName":"obj_valid","name":"$self","kind":13,"line":1082},{"kind":12,"line":1082,"name":"valid","containerName":"obj_valid"},{"line":1082,"kind":13,"name":"$self","containerName":"obj_valid"},{"line":1082,"kind":12,"containerName":"obj_valid","name":"end"}],"line":1080,"kind":12,"range":{"end":{"character":9999,"line":1086},"start":{"character":0,"line":1080}},"name":"obj_valid","definition":"sub","containerName":"main::"},{"name":"name","range":{"end":{"character":9999,"line":1110},"start":{"line":1100,"character":0}},"kind":12,"line":1100,"children":[{"line":1101,"kind":13,"localvar":"my","containerName":"name","definition":"my","name":"$self"},{"line":1101,"kind":13,"name":"$value","containerName":"name"},{"line":1102,"kind":13,"containerName":"name","name":"$value"},{"kind":13,"line":1103,"containerName":"name","name":"$self"},{"line":1103,"kind":13,"name":"$value","containerName":"name"},{"line":1105,"kind":13,"name":"$self","containerName":"name"},{"containerName":"name","name":"$self","line":1108,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none\n\n\n\nsub alphabet {\n  my %valid_type = map {$_, 1} qw( dna rna protein );\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $value = 'dna' if $value =~ /dna/i;\n    $value = 'rna' if $value =~ /rna/i;\n    unless ( $valid_type{$value} ) {\n      $self->warn(\"Molecular type '$value' is not a valid type\");\n    }\n    $self->{'alphabet'} = $value;\n  }\n  return $self->{'alphabet'};\n}\n\n=head2 coordinate_start\n\n  Title   : coordinate_start\n  Usage   : $coordstartlabel=$obj->coordinate_start()\n          : $coordstartlabel=$obj->coordinate_start($label)\n  Function: returns and optionally sets the first label of the coordinate\n            system used\n            For some objects only labels inside the object or in frame (for\n            Translation objects) will be allowed to get set as coordinate start\n\n  Returns : label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : an optional reference $label that is position 1\n\n\n\nsub coordinate_start {\n  my ($self,$label) = @_;\n  if ($label) {\n    if ($self->valid($label)) {\n      $self->{'coordinate_start'} = $label;\n    } else {\n      $self->warn(\"The label you are trying to set as coordinate_start is not valid for this object\");\n    }\n  }\n  my $coord_start = $self->{'coordinate_start'};\n  if ($coord_start) { \n    return $coord_start;\n  } else {\n    return $self->start();\n  }\n}\n\n=head2 label\n\n  Title   : label\n  Usage   : $seq->label($position)\n          : $seq->label($position,$firstlabel)\n  Examples: $nextlabel=$seq->label(2,$label) -> retrieves the following label\n          : $prevlabel=$seq->label(-1,$label) -> retrieves the preceding label\n\n  Function: returns the label of the nucleotide at $position from current\n            coordinate start\n  Returns : a label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : a position, \n            an optional reference $firstlabel that is to be used as position 1\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub label {\n  my ($self,$position,$firstlabel,$strand)=@_;\n  my $label;\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($position) {  # if position = 0 complain ?\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    if ($position > 0) {\n      $label=$self->{'seq'}->down_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->up_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  } else {\n    if ($position > 0) {\n      $label=$self->{'seq'}->up_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->down_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  }\n  return $label;\n}\n\n\n=head2 position\n\n  Title   : position\n  Usage   : $seq->position($label)\n          : $seq->position($label,$firstlabel)\n  Function: returns the position of nucleotide at $label\n  Returns : the position of the label from current coordinate start\n  Errorcode 0\n  Args    : a label pointing to a certain nucleotide (e.g. start of exon)\n            an optional \"firstlabel\" as reference to count from\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub position {\n  my ($self,$label,$firstlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($self->valid($label)) {\n    $self->warn(\"label not valid\");\n    return (0);\n  }\n  if ($firstlabel == $label) {\n    return (1);\n  }\n  my ($coordpos,$position0,$position);\n  $position0=$self->{'seq'}->down_get_pos_of_label($label);\n  $coordpos=$self->{'seq'}->down_get_pos_of_label($firstlabel);\n  $position=$position0-$coordpos+1;\n  if ($position <= 0) {\n    $position--;\n  }\n  if ($strand == -1) {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",1-$position;\n    return (1-$position);\n  } else {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",$position;\n    return ($position);\n  }\n}\n\n=head2 follows\n\n  Title   : follows\n  Usage   : $seq->follows($firstlabel,$secondlabel)\n          : $seq->follows($firstlabel,$secondlabel,$strand)\n  Function: checks if SECONDlabel follows FIRSTlabel, undependent of the strand\n            i.e. it checks downstream for forward strand and\n            upstream for reverse strand\n  Returns : 1 or 0\n  Errorcode -1\n  Args    : two labels\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n#'\n# wraparound to is_downstream and is_upstream that chooses the correct one\n# depending on the strand\nsub follows {\n  my ($self,$firstlabel,$secondlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    return ($self->{'seq'}->is_downstream($firstlabel,$secondlabel));\n  } else {\n    return ($self->{'seq'}->is_upstream($firstlabel,$secondlabel));\n  }\n}\n#\n#=head2 translate\n#\n# Title   : translate\n# Usage   : $protein_seq = $obj->translate\n# Function: Provides the translation of the DNA sequence\n#\t    using full IUPAC ambiguities in DNA/RNA and amino acid codes.\n#\n#\t    The resulting translation is identical to EMBL/TREMBL database \n#\t    translations.\n#\n# Returns : a string\n# Args    : character for terminator (optional) defaults to '*'\n#\t    character for unknown amino acid (optional) defaults to 'X'\n#\t    frame (optional) valid values 0, 1, 3, defaults to 0\n#\t    codon table id (optional) defaults to 1\n#\n#=cut\n#\n#sub translate {\n#  my ($self) = shift;\n#  return ($self->translate_string($self->seq,@_));\n#}\n#\n#=head2 translate_string\n#\n# Title   : translate_string\n# Usage   : $protein_seq = $obj->translate_string(\"attcgtgttgatcgatta\");\n# Function: Like translate, but can be used to translate subsequences after\n#\t    having retrieved them as string.\n# Args    : 1st argument is a string. Optional following arguments: like in\n#\t    the translate method\n#\n#=cut\n#\n#\n#sub translate_string {\n#  my($self) = shift;\n#  my($seq) = shift;\n#  my($stop, $unknown, $frame, $tableid) = @_;\n#  my($i, $len, $output) = (0,0,'');\n#  my($codon)   = \"\";\n#  my $aa;\n#\n#\n#  ## User can pass in symbol for stop and unknown codons\n#  unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n#  unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n#  unless(defined($frame) and $frame ne '') { $frame = 0; }\n#\n#  ## the codon table ID \n#  if ($self->translation_table) {\n#    $tableid = $self->translation_table;\n#  }\n#  unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n#\n#  ##Error if monomer is \"Amino\"\n#  $self->warn(\"Can't translate an amino acid sequence.\") \n#      if (defined $self->alphabet && $self->alphabet eq 'protein');\n#\n#  ##Error if frame is not 0, 1 or 2\n#  $self->warn(\"Valid values for frame are 0, 1, 2, not [$frame].\")\n#      unless ($frame == 0 or $frame == 1 or $frame == 2);\n#\n#  #thows a warning if ID is invalid \n#  my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n#\n#  # deal with frame offset.\n#  if( $frame ) {\n#      $seq = substr ($seq,$frame);\n#  }\n#\n#  for $codon ( grep { CORE::length == 3 } split(/(.{3})/, $seq) ) {\n#      my $aa = $codonTable->translate($codon);\n#      if ($aa eq '*') {\n#\t    $output .= $stop;\n#      }\n#      elsif ($aa eq 'X') {\n#\t    $output .= $unknown;\n#      }\n#      else { \n#\t   $output .= $aa ;\n#      }   \n#  }\n#  #if( substr($output,-1,1) eq $stop ) {\n#  #    chop $output;\n#  #}\n#\n#  return ($output);\n#}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene=$obj->gene;\n Function: Gets or sets the reference to the LiveSeq::Gene object.\n           Objects that are features of a LiveSeq Gene will have this\n           attribute set automatically.\n\n Returns : reference to an object of class Gene\n Note    : if Gene object is not set, this method will return 0;\n Args    : none or reference to object of class Bio::LiveSeq::Gene\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene'} = $value;\n  }\n  unless (exists $self->{'gene'}) {\n    return (0);\n  } else {\n    return $self->{'gene'};\n  }\n}\n\n=head2 obj_valid\n\n Title   : obj_valid\n Usage   : if ($obj->obj_valid) {do something;}\n Function: Checks if start and end labels are still valid for the ojbect,\n           i.e. tests if the LiveSeq object is still valid\n Returns : boolean\n Args    : none\n\n\nsub obj_valid {\n  my $self=shift;\n  unless (($self->{'seq'}->valid($self->start()))&&($self->{'seq'}->valid($self->end()))) {\n    return (0);\n  }\n  return (1);\n}\n\n=head2 name\n\n Title   : name\n Usage   : $name = $obj->name;\n         : $name = $obj->name(\"ABCD\");\n Function: Returns or sets the name of the object.\n           If there is no name, it will return \"unknown\";\n Returns : A string\n Args    : None","label":"name($self,$value)"}},{"kind":12,"line":1124,"children":[{"line":1125,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"desc"},{"kind":13,"line":1125,"containerName":"desc","name":"$value"},{"kind":13,"line":1126,"name":"$value","containerName":"desc"},{"containerName":"desc","name":"$self","line":1127,"kind":13},{"containerName":"desc","name":"$value","line":1127,"kind":13},{"kind":13,"line":1129,"name":"$self","containerName":"desc"},{"name":"$self","containerName":"desc","line":1132,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none\n\n\n\nsub alphabet {\n  my %valid_type = map {$_, 1} qw( dna rna protein );\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $value = 'dna' if $value =~ /dna/i;\n    $value = 'rna' if $value =~ /rna/i;\n    unless ( $valid_type{$value} ) {\n      $self->warn(\"Molecular type '$value' is not a valid type\");\n    }\n    $self->{'alphabet'} = $value;\n  }\n  return $self->{'alphabet'};\n}\n\n=head2 coordinate_start\n\n  Title   : coordinate_start\n  Usage   : $coordstartlabel=$obj->coordinate_start()\n          : $coordstartlabel=$obj->coordinate_start($label)\n  Function: returns and optionally sets the first label of the coordinate\n            system used\n            For some objects only labels inside the object or in frame (for\n            Translation objects) will be allowed to get set as coordinate start\n\n  Returns : label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : an optional reference $label that is position 1\n\n\n\nsub coordinate_start {\n  my ($self,$label) = @_;\n  if ($label) {\n    if ($self->valid($label)) {\n      $self->{'coordinate_start'} = $label;\n    } else {\n      $self->warn(\"The label you are trying to set as coordinate_start is not valid for this object\");\n    }\n  }\n  my $coord_start = $self->{'coordinate_start'};\n  if ($coord_start) { \n    return $coord_start;\n  } else {\n    return $self->start();\n  }\n}\n\n=head2 label\n\n  Title   : label\n  Usage   : $seq->label($position)\n          : $seq->label($position,$firstlabel)\n  Examples: $nextlabel=$seq->label(2,$label) -> retrieves the following label\n          : $prevlabel=$seq->label(-1,$label) -> retrieves the preceding label\n\n  Function: returns the label of the nucleotide at $position from current\n            coordinate start\n  Returns : a label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : a position, \n            an optional reference $firstlabel that is to be used as position 1\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub label {\n  my ($self,$position,$firstlabel,$strand)=@_;\n  my $label;\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($position) {  # if position = 0 complain ?\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    if ($position > 0) {\n      $label=$self->{'seq'}->down_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->up_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  } else {\n    if ($position > 0) {\n      $label=$self->{'seq'}->up_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->down_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  }\n  return $label;\n}\n\n\n=head2 position\n\n  Title   : position\n  Usage   : $seq->position($label)\n          : $seq->position($label,$firstlabel)\n  Function: returns the position of nucleotide at $label\n  Returns : the position of the label from current coordinate start\n  Errorcode 0\n  Args    : a label pointing to a certain nucleotide (e.g. start of exon)\n            an optional \"firstlabel\" as reference to count from\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub position {\n  my ($self,$label,$firstlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($self->valid($label)) {\n    $self->warn(\"label not valid\");\n    return (0);\n  }\n  if ($firstlabel == $label) {\n    return (1);\n  }\n  my ($coordpos,$position0,$position);\n  $position0=$self->{'seq'}->down_get_pos_of_label($label);\n  $coordpos=$self->{'seq'}->down_get_pos_of_label($firstlabel);\n  $position=$position0-$coordpos+1;\n  if ($position <= 0) {\n    $position--;\n  }\n  if ($strand == -1) {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",1-$position;\n    return (1-$position);\n  } else {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",$position;\n    return ($position);\n  }\n}\n\n=head2 follows\n\n  Title   : follows\n  Usage   : $seq->follows($firstlabel,$secondlabel)\n          : $seq->follows($firstlabel,$secondlabel,$strand)\n  Function: checks if SECONDlabel follows FIRSTlabel, undependent of the strand\n            i.e. it checks downstream for forward strand and\n            upstream for reverse strand\n  Returns : 1 or 0\n  Errorcode -1\n  Args    : two labels\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n#'\n# wraparound to is_downstream and is_upstream that chooses the correct one\n# depending on the strand\nsub follows {\n  my ($self,$firstlabel,$secondlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    return ($self->{'seq'}->is_downstream($firstlabel,$secondlabel));\n  } else {\n    return ($self->{'seq'}->is_upstream($firstlabel,$secondlabel));\n  }\n}\n#\n#=head2 translate\n#\n# Title   : translate\n# Usage   : $protein_seq = $obj->translate\n# Function: Provides the translation of the DNA sequence\n#\t    using full IUPAC ambiguities in DNA/RNA and amino acid codes.\n#\n#\t    The resulting translation is identical to EMBL/TREMBL database \n#\t    translations.\n#\n# Returns : a string\n# Args    : character for terminator (optional) defaults to '*'\n#\t    character for unknown amino acid (optional) defaults to 'X'\n#\t    frame (optional) valid values 0, 1, 3, defaults to 0\n#\t    codon table id (optional) defaults to 1\n#\n#=cut\n#\n#sub translate {\n#  my ($self) = shift;\n#  return ($self->translate_string($self->seq,@_));\n#}\n#\n#=head2 translate_string\n#\n# Title   : translate_string\n# Usage   : $protein_seq = $obj->translate_string(\"attcgtgttgatcgatta\");\n# Function: Like translate, but can be used to translate subsequences after\n#\t    having retrieved them as string.\n# Args    : 1st argument is a string. Optional following arguments: like in\n#\t    the translate method\n#\n#=cut\n#\n#\n#sub translate_string {\n#  my($self) = shift;\n#  my($seq) = shift;\n#  my($stop, $unknown, $frame, $tableid) = @_;\n#  my($i, $len, $output) = (0,0,'');\n#  my($codon)   = \"\";\n#  my $aa;\n#\n#\n#  ## User can pass in symbol for stop and unknown codons\n#  unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n#  unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n#  unless(defined($frame) and $frame ne '') { $frame = 0; }\n#\n#  ## the codon table ID \n#  if ($self->translation_table) {\n#    $tableid = $self->translation_table;\n#  }\n#  unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n#\n#  ##Error if monomer is \"Amino\"\n#  $self->warn(\"Can't translate an amino acid sequence.\") \n#      if (defined $self->alphabet && $self->alphabet eq 'protein');\n#\n#  ##Error if frame is not 0, 1 or 2\n#  $self->warn(\"Valid values for frame are 0, 1, 2, not [$frame].\")\n#      unless ($frame == 0 or $frame == 1 or $frame == 2);\n#\n#  #thows a warning if ID is invalid \n#  my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n#\n#  # deal with frame offset.\n#  if( $frame ) {\n#      $seq = substr ($seq,$frame);\n#  }\n#\n#  for $codon ( grep { CORE::length == 3 } split(/(.{3})/, $seq) ) {\n#      my $aa = $codonTable->translate($codon);\n#      if ($aa eq '*') {\n#\t    $output .= $stop;\n#      }\n#      elsif ($aa eq 'X') {\n#\t    $output .= $unknown;\n#      }\n#      else { \n#\t   $output .= $aa ;\n#      }   \n#  }\n#  #if( substr($output,-1,1) eq $stop ) {\n#  #    chop $output;\n#  #}\n#\n#  return ($output);\n#}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene=$obj->gene;\n Function: Gets or sets the reference to the LiveSeq::Gene object.\n           Objects that are features of a LiveSeq Gene will have this\n           attribute set automatically.\n\n Returns : reference to an object of class Gene\n Note    : if Gene object is not set, this method will return 0;\n Args    : none or reference to object of class Bio::LiveSeq::Gene\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene'} = $value;\n  }\n  unless (exists $self->{'gene'}) {\n    return (0);\n  } else {\n    return $self->{'gene'};\n  }\n}\n\n=head2 obj_valid\n\n Title   : obj_valid\n Usage   : if ($obj->obj_valid) {do something;}\n Function: Checks if start and end labels are still valid for the ojbect,\n           i.e. tests if the LiveSeq object is still valid\n Returns : boolean\n Args    : none\n\n\nsub obj_valid {\n  my $self=shift;\n  unless (($self->{'seq'}->valid($self->start()))&&($self->{'seq'}->valid($self->end()))) {\n    return (0);\n  }\n  return (1);\n}\n\n=head2 name\n\n Title   : name\n Usage   : $name = $obj->name;\n         : $name = $obj->name(\"ABCD\");\n Function: Returns or sets the name of the object.\n           If there is no name, it will return \"unknown\";\n Returns : A string\n Args    : None\n\n\nsub name {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'name'} = $value;\n  }\n  unless (exists $self->{'name'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'name'};\n  }\n}\n\n=head2 desc\n\n Title   : desc\n Usage   : $desc = $obj->desc;\n         : $desc = $obj->desc(\"ABCD\");\n Function: Returns or sets the description of the object.\n           If there is no description, it will return \"unknown\";\n Returns : A string\n Args    : None","label":"desc($self,$value)"},"name":"desc","range":{"end":{"character":9999,"line":1134},"start":{"character":0,"line":1124}}},{"name":"source","range":{"end":{"character":9999,"line":1158},"start":{"line":1148,"character":0}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: SeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::SeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::SeqI - Abstract sequence interface class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis class implements BioPerl PrimarySeqI interface for Live Seq objects.\n\nOne of the main difference in LiveSequence compared to traditional\n\"string\" sequences is that coordinate systems are flexible. Typically\ngene nucleotide numbering starts from 1 at the first character of the\ninitiator codon (A in ATG). This means that negative positions are\npossible and common!\n\nSecondly, the sequence manipulation methods do not return a new\nsequence object but change the current object. The current status can\nbe written out to BioPerl sequence objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\nSome note on the terminology/notation of method names:\n label: a unique pointer to a single nucleotide\n position: the position of a nucleotide according to a particular coordinate\n           system (e.g. counting downstream from a particular label taken as\n           number 1)\n base: the one letter code for a nucleotide (i.e.: \"a\" \"t\" \"c\" \"g\")\n\n       a base is the \"value\" that an \"element\" of a \"chain\" can assume\n         (see documentation on the Chain datastructure if interested)\n\n\n#'\n# Let the code begin...\n\npackage Bio::LiveSeq::SeqI;\nuse strict;\nuse Bio::Tools::CodonTable; # for the translate() function\n\nuse base qw(Bio::Root::Root Bio::LiveSeq::ChainI Bio::PrimarySeqI);\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the complete sequence of an object as a string of letters.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard),\n Returns : a string\n\n\n\nsub seq {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,undef,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,undef,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 all_labels\n\n Title   : all_labels\n Usage   : @labels = $obj->all_labels()\n Function: all the labels of every nucleotide an object is composed of\n Returns : an array of labels\n Args    : none\n\n\nsub all_labels {\n  my $self = shift;\n  my ($start,$end) = ($self->start(),$self->end());\n  my $labels;\n  if ($self->strand() == 1) {\n    $labels=$self->{'seq'}->down_labels($start,$end);\n  } else {\n    $labels=$self->{'seq'}->up_labels($start,$end);\n  }\n  return (@{$labels});\n}\n\n=head2 labelsubseq\n\n  Title   : labelsubseq\n  Usage   : $dna->labelsubseq();\n          : $dna->labelsubseq($startlabel);\n          : $dna->labelsubseq($startlabel,$length);\n          : $dna->labelsubseq($startlabel,undef,$endlabel);\n  e.g.    : $dna->labelsubseq(4,undef,8);\n  Function: prints the sequence as string. The difference between labelsubseq\n            and normal subseq is that it uses /labels/ as arguments, instead\n            than positions. This allows for faster and more efficient lookup,\n            skipping the (usually) lengthy conversion of positions into labels.\n            This is expecially useful for manipulating with high power\n            LiveSeq objects, knowing the labels and exploiting their\n            usefulness.\n  Returns : a string\n  Errorcode -1\n  Args    : without arguments it returns the entire sequence\n            with a startlabel it returns the sequence downstream that label\n            if a length is specified, it returns only that number of bases\n            if an endlabel is specified, it overrides the length argument\n             and prints instead up to that label (included)\n  Defaults: $startlabel defaults to the beginning of the entire sequence\n            $endlabel defaults to the end of the entire sequence\n\n\n# NOTE: unsecuremode is to be used /ONLY/ if sure of the start and end labels, expecially that they follow each other in the correct order!!!!\n\nsub labelsubseq {\n  my ($self,$start,$length,$end,$unsecuremode) = @_;\n  if (defined $unsecuremode && $unsecuremode eq \"unsecuremoderequested\") \n  { # to skip security checks (faster)\n    unless ($start) {\n      $start=$self->start;\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tundef $length;\n      }\n    } else {\n      unless ($length) {\n\t$end=$self->end;\n      }\n    }\n  } else {\n    if ($start) {\n      unless ($self->{'seq'}->valid($start)) {\n\t$self->warn(\"Start label not valid\"); return (-1);\n      }\n    }\n    if ($end) {\n      if ($end == $start) {\n\t$length=1;\n\tundef $end;\n      } else {\n\tunless ($self->{'seq'}->valid($end)) {\n\t  $self->warn(\"End label not valid\"); return (-1);\n\t}\n\tunless ($self->follows($start,$end) == 1) {\n\t  $self->warn(\"End label does not follow Start label!\"); return (-1);\n\t}\n\tundef $length;\n      }\n    }\n  }\n  if ($self->strand() == 1) {\n    return $self->{'seq'}->down_chain2string($start,$length,$end);\n  } else { # reverse strand\n    my $str = $self->{'seq'}->up_chain2string($start,$length,$end);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n    return $str;\n  }\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n         : $substring = $obj->subseq(10,undef,4);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n\n           Start cannot be larger than end but can be equal.\n\n           Allows for negative numbers $obj->subseq(-10,-1). By\n           definition, there is no 0!\n                       -5  -1 1   5\n                gctagcgcccaac atggctcgctg\n\n           This allows to retrieve sequences upstream from given position.\n\n           The precedence is from left to right: if END is given LENGTH is\n           ignored.\n\n Examples: $obj->subseq(-10,undef,10) returns 10 elements before position 1\n           $obj->subseq(4,8) returns elements from the 4th to the 8th, inclusive\n\n Returns : a string\n Errorcode: -1\n Args    : start,  integer, defaults to start of the sequence\n           end,    integer, '' or undef, defaults to end of the sequence\n           length, integer, '' or undef\n           an optional strand (1 or -1) 4th argument \n            if strand argument is not given, it will default to the object\n            argment. This argument is useful when a call is issued from a child\n            of a parent object containing the subseq method\n\n\n#'\n# check the fact about reverse strand!\n# is it feasible? Is it correct? Should we do it? How about exons? Does it\n# work when you ask subseq of an exon?\n# eliminated now (Mon night)\nsub subseq {\n  ##my ($self,$pos1,$pos2,$length,$strand) = @_;\n  my ($self,$pos1,$pos2,$length,$strand) = @_;\n  ##unless (defined ($strand)) { # if optional [strand] argument not given\n  ##  $strand=$self->strand;\n  ##}\n  $strand=$self->strand;\n  my ($str,$startlabel,$endlabel);\n  if (defined ($length)) {\n    if ($length < 1) {\n      $self->warn(\"No sense asking for a subseq of length < 1\");\n      return (-1);\n    }\n  }\n  unless (defined ($pos1)) {\n    #print \"\\n##### DEBUG pos1 not defined\\n\";\n    $startlabel=$self->start;\n  } else {\n    if ($pos1 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos2))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos2))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!)\"; return (-1);\n    ##  }\n    ##}\n    $startlabel=$self->label($pos1);\n    if ($startlabel < 1) {\n      $self->warn(\"position $pos1 not valid as start of subseq!\"); return (-1);\n    }\n  }\n  unless (defined ($pos2)) {\n    #print \"\\n##### pos2 not defined\\n\";\n    unless (defined ($length)) {\n      $endlabel=$self->end;\n    }\n  } else {\n    if ($pos2 == 0) {  # if position = 0 complain\n      $self->warn(\"Position cannot be 0!\"); return (-1);\n    }\n    undef $length;\n    ##if ($strand == 1) { # CHECK THIS!\n      if ((defined ($pos1))&&($pos1>$pos2)) {\n\t$self->warn(\"1st position($pos1) cannot be > 2nd position($pos2)!\"); return (-1);\n      }\n    ##} else { # CHECK THIS!\n    ##  if ((defined ($pos1))&&($pos1<$pos2)) {\n##\t$self->warn(\"1st position($pos1) cannot be < 2nd position($pos2) on reverse strand!\"); return (-1);\n    ##  }\n    ##}\n    $endlabel=$self->label($pos2);\n    if ($endlabel < 1) {\n      $self->warn(\"position $pos2 not valid as end of subseq!\"); return (-1);\n    }\n  }\n  #print \"\\n    ####DEBUG: start $startlabel end $endlabel length $length strand $strand\\n\";\n\n  if ($strand == 1) {\n    $str = $self->{'seq'}->down_chain2string($startlabel,$length,$endlabel);\n  } else { # reverse strand\n    $str = $self->{'seq'}->up_chain2string($startlabel,$length,$endlabel);\n    $str =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/;\n  }\n  return $str;\n}\n\n=head2 length\n\n  Title   : length\n  Usage   : $seq->length();\n  Function: returns the number of nucleotides (or the number of aminoacids)\n            in the entire sequence\n  Returns : an integer\n  Errorcode -1\n  Args    : none\n\n\nsub length {\n  my $self=shift;\n  my ($start,$end,$strand)=($self->start(),$self->end(),$self->strand());\n  if ($strand == 1) {\n    return $self->{'seq'}->down_subchain_length($start,$end);\n  } else {\n    return $self->{'seq'}->up_subchain_length($start,$end);\n  }\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, alias the common name of the object\n\n           The semantics of this is that it is the most likely string\n           to be used as an identifier of the sequence, and likely to\n           have \"human\" readability.  The id is equivalent to the ID\n           field of the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id\n           to embed other information.\n\n See also: accession_number\n Returns : a string\n Args    : none\n\n\nsub display_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'display_id'} = $value;\n  }\n  return $self->{'display_id'};\n}\n\n\n=head2 accession_number\n\n Title   : accession_number\n Usage   : $unique_biological_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number.\n           Notice that primary_id() provides the unique id for the\n           implemetation, allowing multiple objects to have the same accession\n           number in a particular implementation.\n\n           For objects with no accession_number this method returns \"unknown\".\n Returns : a string\n Args    : none\n\n\nsub accession_number {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'accession_number'} = $value;\n  }\n  unless (exists $self->{'accession_number'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'accession_number'};\n  }\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_implementation_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their own\n           object ids in a way the implementation can control. Clients can\n           expect one id to map to one object.\n\n           For sequences with no primary_id, this method returns\n           a stringified memory location.\n\n Returns : A string\n Args    : None\n\n\n\nsub primary_id {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'primary_id'} = $value;\n  }\n  unless (exists $self->{'primary_id'}) {\n    return \"$self\";\n  } else {\n    return $self->{'primary_id'};\n  }\n}\n\n=head2 change\n\n Title   : change\n Usage   : $substring = $obj->change('AA', 10);\n Function: changes, modifies, mutates the LiveSequence\n Examples:\n        $obj->change('',   10);      delete nucleotide #10     \n        $obj->change('',   10, 2);   delete two nucleotides starting from #10\n        $obj->change('G',  10);      change nuc #10 to 'G'\n        $obj->change('GA', 10, 4);   replace #10 and 3 following with 'GA'\n        $obj->change('GA', 10, 2));  is same as $obj->change('GA',  10);\n        $obj->change('GA', 10, 0 );  insert 'GA' before nucleotide at #10\n        $obj->change('GA', 10, 1);   GA inserted before #10, #10 deleted\n        $obj->change('GATC', 10, 2); GATC inserted before #10, #10&#11 deleted\n        $obj->change('GATC', 10, 6); GATC inserted before #10, #10-#15 deleted\n\n\n Returns : a string of deleted bases (if any) or 1 (everything OK)\n Errorcode: -1\n Args    : seq,    string, or '' ('' = undef = 0 = deletion)\n           start,  integer\n           length, integer (optional)\n\n\nsub change {\n  &positionchange;\n}\n\n=head2 positionchange\n\n Title   : positionchange\n Function: Exactly like change. I.e. change() defaults to positionchange()\n\n\nsub positionchange {\n  my ($self,$newseq,$position,$length)=@_;\n  unless ($position) {\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  my $label=$self->label($position);\n  unless ($label > 0) { # label not found or error\n    $self->warn(\"No valid label found at that position!\");\n    return (-1);\n  }\n  return ($self->labelchange($newseq,$label,$length));\n}\n\n=head2 labelchange\n\n Title   : labelchange\n Function: Exactly like change but uses a /label/ instead than a position\n           as second argument. This allows for multiple changes in a LiveSeq\n           without the burden of recomputing positions. I.e. for a multiple\n           change in two different points of the LiveSeq, the approach would\n           be the following: fetch the correct labels out of the two different\n           positions (method: label($position)) and then use the labelchange()\n           method to modify the sequence using those labels instead than\n           relying on the positions (that would have modified after the\n           first change).\n\n\nsub labelchange {\n  my ($self,$newseq,$label,$length)=@_;\n  unless ($self->valid($label)) {\n    if ($self->{'seq'}->valid($label)) {\n       #$self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change for the object asked but it's ok for DNAlevel change, reverting to that\");\n      shift @_;\n      return($self->{'seq'}->labelchange(@_));\n    } else {\n      $self->warn(\"Label \\'$label\\' not valid for executing a LiveSeq change\");\n      return (-1);\n    }\n  }\n  unless ($newseq) { # it means this is a simple deletion\n    if (defined($length)) {\n      unless ($length >= 0) {\n\t$self->warn(\"No sense having length < 0 in a deletion\");\n\treturn (-1);\n      }\n    } else {\n      $self->warn(\"Length not defined for deletion!\");\n      return (-1);\n    }\n    return $self->_delete($label,$length);\n  }\n  my $newseqlength=CORE::length($newseq);\n  if (defined($length)) {\n    unless ($length >= 0) {\n      $self->warn(\"No sense having length < 0 in a change()\");\n      return (-1);\n    }\n  } else {\n    $length=$newseqlength; # defaults to pointmutation(s)\n  }\n  if ($length == 0) { # it means this is a simple insertion, length def&==0\n    my ($insertbegin,$insertend)=$self->_praeinsert($label,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n  if ($newseqlength == $length) { # it means this is simple pointmutation(s)\n    return $self->_mutate($label,$newseq,$length);\n  }\n  # if we arrived here then change is complex mixture\n  my $strand=$self->strand();\n  my $afterendlabel=$self->label($length+1,$label,$strand); # get the label at $length+1 positions after $label\n  unless ($afterendlabel > 0) { # label not found or error\n    $self->warn(\"No valid afterendlabel found for executing the complex mutation!\");\n    return (-1);\n  }\n  my $deleted=$self->_delete($label,$length); # first delete length nucs\n  if ($deleted == -1) { # if errors\n    return (-1);\n  } else { # then insert the newsequence\n    my ($insertbegin,$insertend)=$self->_praeinsert($afterendlabel,$newseq);\n    if ($insertbegin == -1) {\n      return (-1);\n    } else {\n      return (1);\n    }\n  }\n}\n\n# internal methods for change()\n\n# arguments: label for beginning of deletion, new sequence to insert\n# returns: labels of beginning and end of the inserted sequence\n# errorcode: -1\nsub _praeinsert {\n  my ($self,$label,$newseq)=@_;\n  my ($insertbegin,$insertend);\n  my $strand=$self->strand();\n  if ($strand == 1) {\n    ($insertbegin,$insertend)=($self->{'seq'}->praeinsert_string($newseq,$label));\n  } else { # since it's reverse strand and we insert in forward direction....\n    $newseq=reverse($newseq);\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n    ($insertend,$insertbegin)=($self->{'seq'}->postinsert_string($newseq,$label));\n  }\n  if (($insertbegin==0)||($insertend==0)) {\n    $self->warn(\"Some error occurred while inserting!\");\n    return (-1);\n  } else {\n    return ($insertbegin,$insertend);\n  }\n}\n\n# arguments: label for beginning of deletion, length of deletion\n# returns: string of deleted bases\n# errorcode: -1\nsub _delete {\n  my ($self,$label,$length)=@_;\n  my $strand=$self->strand();\n  my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n  unless ($endlabel > 0) { # label not found or error\n    $self->warn(\"No valid endlabel found for executing the deletion!\");\n    return (-1);\n  }\n  # this is important in Transcript to fix exon structure\n  $self->_deletecheck($label,$endlabel);\n  my $deletedseq;\n  if ($strand == 1) {\n    $deletedseq=$self->{'seq'}->splice_chain($label,undef,$endlabel);\n  } else {\n    $deletedseq=$self->{'seq'}->splice_chain($endlabel,undef,$label);\n    $deletedseq=reverse($deletedseq); # because we are on reverse strand and we cut anyway\n                         # in forward direction\n    $deletedseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  return ($deletedseq);\n}\n\n# empty function, overridden in Transcript, not useful here\nsub _deletecheck {\n}\n\n# arguments: label for beginning of mutation, newsequence, number of mutations\n# returns: 1 all OK\n# errorcode: -1\nsub _mutate {\n  my ($self,$label,$newseq,$length)=@_; # length is equal to length(newseq)\n  my ($i,$base,$nextlabel);\n  my @labels; # array of labels\n  my $strand=$self->strand();\n  if ($length == 1) { # special cases first\n    @labels=($label);\n  } else {\n    my $endlabel=$self->label($length,$label,$strand); # get the label at $length positions after $label\n    unless ($endlabel > 0) { # label not found or error\n      $self->warn(\"No valid endlabel found for executing the mutation!\");\n      return (-1);\n    }\n    if ($length == 2) { # another special case\n      @labels=($label,$endlabel);\n    } else { # more than 3 bases changed\n      # this wouldn't work for Transcript\n      #my $labelsarrayref;\n      #if ($strand == 1) {\n\t#$labelsarrayref=$self->{'seq'}->down_labels($label,$endlabel);\n      #} else {\n\t#$labelsarrayref=$self->{'seq'}->up_labels($label,$endlabel);\n      #}\n      #@labels=@{$labelsarrayref};\n      #if ($length != scalar(@labels)) { # not enough labels returned\n\t#$self->warn(\"Not enough valid labels found for executing the mutation!\");\n\t#return (-1);\n      #}\n\n      # this should be more general\n      @labels=($label); # put the first one\n      while ($label != $endlabel) {\n\t$nextlabel=$self->label(2,$label,$strand); # retrieve the next label\n\tpush (@labels,$nextlabel);\n\t$label=$nextlabel; # move on reference\n      }\n    }\n  }\n  if ($strand == -1) { # only for reverse strand\n    $newseq =~ tr/acgtrymkswhbvdnxACGTRYMKSWHBVDNX/tgcayrkmswdvbhnxTGCAYRKMSWDVBHNX/; # since it's reverse strand we get the complementary bases\n  }\n  my $errorcheck; # if not equal to $length after summing for all changes, error did occurr\n  $i = 0;\n  foreach $base (split(//,$newseq)) {\n    $errorcheck += $self->{'seq'}->set_value_at_label($base,$labels[$i]);\n    $i++;\n  }\n  if ($errorcheck != $length) {\n    $self->warn(\"Some error occurred while mutating!\");\n    return (-1);\n  } else {\n    return (1);\n  }\n}\n\n=head2 valid\n\n  Title   : valid\n  Usage   : $boolean = $obj->valid($label)\n  Function: tests if a label exists inside the object\n  Returns : boolean\n  Args    : label\n\n\n# argument: label\n# returns: 1 YES 0 NO\nsub valid {\n  my ($self,$label)=@_;\n  my $checkme;\n  my @labels=$self->all_labels;\n  foreach $checkme (@labels) {\n    if ($label == $checkme) {\n      return (1); # found\n    }\n  }\n  return (0); # not found\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $startlabel=$obj->start()\n  Function: returns the label of the first nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub start {\n  my ($self) = @_;\n  return $self->{'start'}; # common for all classes BUT DNA (which redefines it) and Transcript (that takes the information from the Exons)\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $endlabel=$obj->end()\n  Function: returns the label of the last nucleotide of the object (exon, CDS)\n  Returns : label\n  Args    : none\n\n\nsub end {\n  my ($self) = @_;\n  return $self->{'end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand=$obj->strand()\n            $obj->strand($strand)\n  Function: gets or sets strand information, being 1 or -1 (forward or reverse)\n  Returns : -1 or 1\n  Args    : none OR -1 or 1\n\n\nsub strand {\n  my ($self,$strand) = @_;\n  if ($strand) {\n    if (($strand != 1)&&($strand != -1)) {\n      $self->warn(\"strand information not changed because strand identifier not valid\");\n    } else {\n      $self->{'strand'} = $strand;\n    }\n  }\n  return $self->{'strand'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of sequence being one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'.\n Args    : none\n\n\n\nsub alphabet {\n  my %valid_type = map {$_, 1} qw( dna rna protein );\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $value = 'dna' if $value =~ /dna/i;\n    $value = 'rna' if $value =~ /rna/i;\n    unless ( $valid_type{$value} ) {\n      $self->warn(\"Molecular type '$value' is not a valid type\");\n    }\n    $self->{'alphabet'} = $value;\n  }\n  return $self->{'alphabet'};\n}\n\n=head2 coordinate_start\n\n  Title   : coordinate_start\n  Usage   : $coordstartlabel=$obj->coordinate_start()\n          : $coordstartlabel=$obj->coordinate_start($label)\n  Function: returns and optionally sets the first label of the coordinate\n            system used\n            For some objects only labels inside the object or in frame (for\n            Translation objects) will be allowed to get set as coordinate start\n\n  Returns : label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : an optional reference $label that is position 1\n\n\n\nsub coordinate_start {\n  my ($self,$label) = @_;\n  if ($label) {\n    if ($self->valid($label)) {\n      $self->{'coordinate_start'} = $label;\n    } else {\n      $self->warn(\"The label you are trying to set as coordinate_start is not valid for this object\");\n    }\n  }\n  my $coord_start = $self->{'coordinate_start'};\n  if ($coord_start) { \n    return $coord_start;\n  } else {\n    return $self->start();\n  }\n}\n\n=head2 label\n\n  Title   : label\n  Usage   : $seq->label($position)\n          : $seq->label($position,$firstlabel)\n  Examples: $nextlabel=$seq->label(2,$label) -> retrieves the following label\n          : $prevlabel=$seq->label(-1,$label) -> retrieves the preceding label\n\n  Function: returns the label of the nucleotide at $position from current\n            coordinate start\n  Returns : a label. It returns 0 if label not found.\n  Errorcode -1 \n  Args    : a position, \n            an optional reference $firstlabel that is to be used as position 1\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub label {\n  my ($self,$position,$firstlabel,$strand)=@_;\n  my $label;\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($position) {  # if position = 0 complain ?\n    $self->warn(\"Position not given or position 0\");\n    return (-1);\n  }\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    if ($position > 0) {\n      $label=$self->{'seq'}->down_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->up_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  } else {\n    if ($position > 0) {\n      $label=$self->{'seq'}->up_get_label_at_pos($position,$firstlabel)\n    } else { # if < 0\n      $label=$self->{'seq'}->down_get_label_at_pos(1 - $position,$firstlabel)\n    }\n  }\n  return $label;\n}\n\n\n=head2 position\n\n  Title   : position\n  Usage   : $seq->position($label)\n          : $seq->position($label,$firstlabel)\n  Function: returns the position of nucleotide at $label\n  Returns : the position of the label from current coordinate start\n  Errorcode 0\n  Args    : a label pointing to a certain nucleotide (e.g. start of exon)\n            an optional \"firstlabel\" as reference to count from\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n\nsub position {\n  my ($self,$label,$firstlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  unless (defined ($firstlabel)) {\n    $firstlabel=$self->coordinate_start;\n  }\n  unless ($self->valid($label)) {\n    $self->warn(\"label not valid\");\n    return (0);\n  }\n  if ($firstlabel == $label) {\n    return (1);\n  }\n  my ($coordpos,$position0,$position);\n  $position0=$self->{'seq'}->down_get_pos_of_label($label);\n  $coordpos=$self->{'seq'}->down_get_pos_of_label($firstlabel);\n  $position=$position0-$coordpos+1;\n  if ($position <= 0) {\n    $position--;\n  }\n  if ($strand == -1) {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",1-$position;\n    return (1-$position);\n  } else {\n    #print \"\\n----------DEBUGSEQPOS label $label firstlabel $firstlabel strand $strand: position=\",$position;\n    return ($position);\n  }\n}\n\n=head2 follows\n\n  Title   : follows\n  Usage   : $seq->follows($firstlabel,$secondlabel)\n          : $seq->follows($firstlabel,$secondlabel,$strand)\n  Function: checks if SECONDlabel follows FIRSTlabel, undependent of the strand\n            i.e. it checks downstream for forward strand and\n            upstream for reverse strand\n  Returns : 1 or 0\n  Errorcode -1\n  Args    : two labels\n            an optional strand (1 or -1) argument \n             if strand argument is not given, it will default to the object\n             argument. This argument is useful when a call is issued from a child\n             of a parent object containing the subseq method\n\n\n#'\n# wraparound to is_downstream and is_upstream that chooses the correct one\n# depending on the strand\nsub follows {\n  my ($self,$firstlabel,$secondlabel,$strand)=@_;\n  unless (defined ($strand)) { # if optional [strand] argument not given\n    $strand=$self->strand;\n  }\n  if ($strand == 1) {\n    return ($self->{'seq'}->is_downstream($firstlabel,$secondlabel));\n  } else {\n    return ($self->{'seq'}->is_upstream($firstlabel,$secondlabel));\n  }\n}\n#\n#=head2 translate\n#\n# Title   : translate\n# Usage   : $protein_seq = $obj->translate\n# Function: Provides the translation of the DNA sequence\n#\t    using full IUPAC ambiguities in DNA/RNA and amino acid codes.\n#\n#\t    The resulting translation is identical to EMBL/TREMBL database \n#\t    translations.\n#\n# Returns : a string\n# Args    : character for terminator (optional) defaults to '*'\n#\t    character for unknown amino acid (optional) defaults to 'X'\n#\t    frame (optional) valid values 0, 1, 3, defaults to 0\n#\t    codon table id (optional) defaults to 1\n#\n#=cut\n#\n#sub translate {\n#  my ($self) = shift;\n#  return ($self->translate_string($self->seq,@_));\n#}\n#\n#=head2 translate_string\n#\n# Title   : translate_string\n# Usage   : $protein_seq = $obj->translate_string(\"attcgtgttgatcgatta\");\n# Function: Like translate, but can be used to translate subsequences after\n#\t    having retrieved them as string.\n# Args    : 1st argument is a string. Optional following arguments: like in\n#\t    the translate method\n#\n#=cut\n#\n#\n#sub translate_string {\n#  my($self) = shift;\n#  my($seq) = shift;\n#  my($stop, $unknown, $frame, $tableid) = @_;\n#  my($i, $len, $output) = (0,0,'');\n#  my($codon)   = \"\";\n#  my $aa;\n#\n#\n#  ## User can pass in symbol for stop and unknown codons\n#  unless(defined($stop) and $stop ne '')    { $stop = \"*\"; }\n#  unless(defined($unknown) and $unknown ne '') { $unknown = \"X\"; }\n#  unless(defined($frame) and $frame ne '') { $frame = 0; }\n#\n#  ## the codon table ID \n#  if ($self->translation_table) {\n#    $tableid = $self->translation_table;\n#  }\n#  unless(defined($tableid) and $tableid ne '')    { $tableid = 1; }\n#\n#  ##Error if monomer is \"Amino\"\n#  $self->warn(\"Can't translate an amino acid sequence.\") \n#      if (defined $self->alphabet && $self->alphabet eq 'protein');\n#\n#  ##Error if frame is not 0, 1 or 2\n#  $self->warn(\"Valid values for frame are 0, 1, 2, not [$frame].\")\n#      unless ($frame == 0 or $frame == 1 or $frame == 2);\n#\n#  #thows a warning if ID is invalid \n#  my $codonTable = Bio::Tools::CodonTable->new( -id => $tableid);\n#\n#  # deal with frame offset.\n#  if( $frame ) {\n#      $seq = substr ($seq,$frame);\n#  }\n#\n#  for $codon ( grep { CORE::length == 3 } split(/(.{3})/, $seq) ) {\n#      my $aa = $codonTable->translate($codon);\n#      if ($aa eq '*') {\n#\t    $output .= $stop;\n#      }\n#      elsif ($aa eq 'X') {\n#\t    $output .= $unknown;\n#      }\n#      else { \n#\t   $output .= $aa ;\n#      }   \n#  }\n#  #if( substr($output,-1,1) eq $stop ) {\n#  #    chop $output;\n#  #}\n#\n#  return ($output);\n#}\n\n=head2 gene\n\n Title   : gene\n Usage   : my $gene=$obj->gene;\n Function: Gets or sets the reference to the LiveSeq::Gene object.\n           Objects that are features of a LiveSeq Gene will have this\n           attribute set automatically.\n\n Returns : reference to an object of class Gene\n Note    : if Gene object is not set, this method will return 0;\n Args    : none or reference to object of class Bio::LiveSeq::Gene\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene'} = $value;\n  }\n  unless (exists $self->{'gene'}) {\n    return (0);\n  } else {\n    return $self->{'gene'};\n  }\n}\n\n=head2 obj_valid\n\n Title   : obj_valid\n Usage   : if ($obj->obj_valid) {do something;}\n Function: Checks if start and end labels are still valid for the ojbect,\n           i.e. tests if the LiveSeq object is still valid\n Returns : boolean\n Args    : none\n\n\nsub obj_valid {\n  my $self=shift;\n  unless (($self->{'seq'}->valid($self->start()))&&($self->{'seq'}->valid($self->end()))) {\n    return (0);\n  }\n  return (1);\n}\n\n=head2 name\n\n Title   : name\n Usage   : $name = $obj->name;\n         : $name = $obj->name(\"ABCD\");\n Function: Returns or sets the name of the object.\n           If there is no name, it will return \"unknown\";\n Returns : A string\n Args    : None\n\n\nsub name {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'name'} = $value;\n  }\n  unless (exists $self->{'name'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'name'};\n  }\n}\n\n=head2 desc\n\n Title   : desc\n Usage   : $desc = $obj->desc;\n         : $desc = $obj->desc(\"ABCD\");\n Function: Returns or sets the description of the object.\n           If there is no description, it will return \"unknown\";\n Returns : A string\n Args    : None\n\n\nsub desc {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'desc'} = $value;\n  }\n  unless (exists $self->{'desc'}) {\n    return \"unknown\";\n  } else {\n    return $self->{'desc'};\n  }\n}\n\n=head2 source\n\n Title   : source\n Usage   : $name = $obj->source;\n         : $name = $obj->source(\"Homo sapiens\");\n Function: Returns or sets the organism that is source of the object.\n           If there is no source, it will return \"unknown\";\n Returns : A string\n Args    : None","parameters":[{"label":"$self"},{"label":"$value"}],"label":"source($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"source","localvar":"my","kind":13,"line":1149},{"containerName":"source","name":"$value","line":1149,"kind":13},{"name":"$value","containerName":"source","line":1150,"kind":13},{"containerName":"source","name":"$self","line":1151,"kind":13},{"line":1151,"kind":13,"containerName":"source","name":"$value"},{"name":"$self","containerName":"source","kind":13,"line":1153},{"line":1156,"kind":13,"containerName":"source","name":"$self"}],"line":1148},{"name":"delete_Obj","definition":"sub","containerName":"main::","range":{"end":{"line":1162,"character":9999},"start":{"line":1160,"character":0}},"kind":12,"children":[{"line":1161,"kind":13,"localvar":"my","containerName":"delete_Obj","name":"$self","definition":"my"},{"line":1162,"kind":13,"localvar":"my","containerName":"delete_Obj","name":"@values","definition":"my"},{"containerName":"delete_Obj","name":"$self","kind":13,"line":1162}],"line":1160},{"localvar":"my","definition":"my","name":"@keys","containerName":null,"line":1163,"kind":13},{"line":1163,"kind":13,"name":"$self","containerName":null},{"name":"$key","definition":"my","containerName":null,"localvar":"my","kind":13,"line":1165},{"containerName":null,"name":"@keys","kind":13,"line":1165},{"line":1166,"kind":13,"name":"%self","containerName":null},{"containerName":null,"name":"$key","line":1166,"kind":13},{"containerName":null,"name":"$value","definition":"my","localvar":"my","kind":13,"line":1168},{"name":"@values","containerName":null,"kind":13,"line":1168},{"line":1169,"kind":13,"containerName":null,"name":"%value"},{"kind":13,"line":1172,"containerName":null,"name":"$value"},{"name":"delete_Obj","containerName":"main::","kind":12,"line":1172},{"name":"%value","containerName":null,"kind":13,"line":1174},{"localvar":"my","containerName":null,"definition":"my","name":"@array","line":1175,"kind":13},{"kind":13,"line":1175,"name":"$value","containerName":null},{"containerName":null,"name":"$element","definition":"my","localvar":"my","kind":13,"line":1176},{"name":"$element","containerName":null,"kind":13,"line":1177},{"line":1177,"kind":13,"containerName":null,"name":"@array"},{"line":1179,"kind":13,"containerName":null,"name":"$element"},{"containerName":"main::","name":"delete_Obj","line":1179,"kind":12},{"line":1182,"kind":13,"name":"%value","containerName":null},{"kind":13,"line":1183,"containerName":null,"definition":"my","name":"%hash","localvar":"my"},{"containerName":null,"name":"$value","line":1183,"kind":13},{"kind":13,"line":1184,"containerName":null,"definition":"my","name":"$element","localvar":"my"},{"containerName":null,"name":"$element","kind":13,"line":1185},{"name":"%hash","containerName":null,"kind":13,"line":1185},{"kind":13,"line":1187,"containerName":null,"name":"$element"},{"line":1187,"kind":12,"name":"delete_Obj","containerName":"main::"}]}