{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":97},{"detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"","label":"new($class,@args)"},"containerName":"main::","definition":"sub","line":99,"children":[{"localvar":"my","definition":"my","name":"$class","containerName":"new","line":100,"kind":13},{"containerName":"new","name":"@args","line":100,"kind":13},{"name":"$self","definition":"my","containerName":"new","localvar":"my","kind":13,"line":101},{"line":102,"kind":13,"containerName":"new","name":"$self"},{"line":103,"kind":13,"containerName":"new","name":"$self"},{"kind":13,"line":103,"name":"$class","containerName":"new"},{"name":"$gene","definition":"my","containerName":"new","localvar":"my","kind":13,"line":105},{"line":105,"kind":13,"name":"$numbering","containerName":"new"},{"line":106,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":106,"name":"_rearrange","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":109},{"line":111,"kind":13,"containerName":"new","name":"$self"},{"name":"$gene","containerName":"new","line":113,"kind":13},{"kind":13,"line":113,"name":"$self","containerName":"new"},{"containerName":"new","name":"gene","line":113,"kind":12},{"line":113,"kind":13,"name":"$gene","containerName":"new"},{"name":"$numbering","containerName":"new","line":114,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":114},{"containerName":"new","name":"numbering","line":114,"kind":12},{"line":114,"kind":13,"name":"$numbering","containerName":"new"},{"kind":13,"line":117,"name":"$self","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":118}],"kind":12,"range":{"end":{"character":9999,"line":119},"start":{"line":99,"character":0}},"name":"new"},{"name":"gene","range":{"end":{"line":155,"character":9999},"start":{"character":0,"line":139}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.","label":"gene($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"containerName":"gene","definition":"my","name":"$self","localvar":"my","kind":13,"line":140},{"kind":13,"line":140,"name":"$value","containerName":"gene"},{"name":"$value","containerName":"gene","kind":13,"line":141},{"line":142,"kind":13,"containerName":"gene","name":"$value"},{"line":142,"kind":12,"containerName":"gene","name":"isa"},{"kind":13,"line":143,"name":"$self","containerName":"gene"},{"containerName":"gene","name":"throw","line":143,"kind":12},{"name":"$self","containerName":"gene","line":147,"kind":13},{"kind":13,"line":147,"containerName":"gene","name":"$value"},{"containerName":"gene","name":"$self","kind":13,"line":150},{"containerName":"gene","name":"$self","kind":13,"line":153}],"line":139},{"range":{"start":{"character":0,"line":174},"end":{"line":188,"character":9999}},"name":"numbering","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)","label":"numbering($self,$value)"},"containerName":"main::","definition":"sub","line":174,"children":[{"localvar":"my","containerName":"numbering","name":"$self","definition":"my","line":175,"kind":13},{"line":175,"kind":13,"name":"$value","containerName":"numbering"},{"name":"$value","containerName":"numbering","kind":13,"line":176},{"name":"$value","containerName":"numbering","line":177,"kind":13},{"line":177,"kind":13,"name":"$value","containerName":"numbering"},{"line":177,"kind":13,"containerName":"numbering","name":"$value"},{"line":178,"kind":13,"name":"$self","containerName":"numbering"},{"kind":13,"line":178,"name":"$value","containerName":"numbering"},{"containerName":"numbering","name":"$self","kind":13,"line":180},{"containerName":"numbering","name":"$self","kind":13,"line":183},{"name":"$self","containerName":"numbering","line":186,"kind":13}],"kind":12},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"add_Mutation","line":204,"kind":13},{"line":204,"kind":13,"name":"$value","containerName":"add_Mutation"},{"line":205,"kind":13,"name":"$value","containerName":"add_Mutation"},{"kind":12,"line":205,"name":"isa","containerName":"add_Mutation"},{"name":"$com","definition":"my","containerName":"add_Mutation","localvar":"my","kind":13,"line":206},{"name":"$value","containerName":"add_Mutation","kind":13,"line":206},{"name":"$self","containerName":"add_Mutation","line":207,"kind":13},{"name":"throw","containerName":"add_Mutation","line":207,"kind":12},{"containerName":"add_Mutation","name":"$value","kind":13,"line":210},{"containerName":"add_Mutation","name":"pos","kind":12,"line":210},{"containerName":"add_Mutation","name":"$self","line":211,"kind":13},{"containerName":"add_Mutation","name":"warn","line":211,"kind":12},{"line":214,"kind":13,"name":"$value","containerName":"add_Mutation"},{"containerName":"add_Mutation","name":"seq","kind":12,"line":214},{"name":"$value","containerName":"add_Mutation","line":214,"kind":13},{"containerName":"add_Mutation","name":"len","line":214,"kind":12},{"name":"$self","containerName":"add_Mutation","line":215,"kind":13},{"line":215,"kind":12,"name":"warn","containerName":"add_Mutation"},{"line":218,"kind":13,"name":"$self","containerName":"add_Mutation"}],"line":203,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.","label":"add_Mutation($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":218},"start":{"character":0,"line":203}},"name":"add_Mutation"},{"line":218,"kind":13,"containerName":null,"name":"$value"},{"range":{"start":{"line":234,"character":0},"end":{"line":236,"character":9999}},"name":"each_Mutation","children":[{"containerName":"each_Mutation","name":"$self","definition":"my","localvar":"my","kind":13,"line":235},{"line":236,"kind":13,"name":"$self","containerName":"each_Mutation"}],"line":234,"kind":12,"signature":{"label":"each_Mutation($self)","documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::"},{"range":{"start":{"line":256,"character":0},"end":{"line":272,"character":9999}},"name":"mutation","children":[{"name":"$self","definition":"my","containerName":"mutation","localvar":"my","kind":13,"line":257},{"containerName":"mutation","name":"$value","kind":13,"line":257},{"line":258,"kind":13,"containerName":"mutation","name":"$value"},{"kind":13,"line":259,"name":"$value","containerName":"mutation"},{"name":"isa","containerName":"mutation","kind":12,"line":259},{"kind":13,"line":260,"name":"$self","containerName":"mutation"},{"containerName":"mutation","name":"throw","kind":12,"line":260},{"containerName":"mutation","name":"$self","kind":13,"line":264},{"name":"$value","containerName":"mutation","kind":13,"line":264},{"name":"$self","containerName":"mutation","kind":13,"line":267},{"kind":13,"line":270,"containerName":"mutation","name":"$self"}],"line":256,"kind":12,"signature":{"label":"mutation($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef","label":"DNA($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"kind":13,"line":291,"name":"$self","definition":"my","containerName":"DNA","localvar":"my"},{"name":"$value","containerName":"DNA","kind":13,"line":291},{"kind":13,"line":292,"containerName":"DNA","name":"$value"},{"kind":13,"line":293,"containerName":"DNA","name":"$value"},{"name":"isa","containerName":"DNA","line":293,"kind":12},{"line":293,"kind":13,"containerName":"DNA","name":"$value"},{"name":"isa","containerName":"DNA","kind":12,"line":293},{"line":294,"kind":13,"containerName":"DNA","name":"$self"},{"line":294,"kind":12,"containerName":"DNA","name":"throw"},{"containerName":"DNA","name":"$self","line":298,"kind":13},{"kind":13,"line":298,"name":"$value","containerName":"DNA"},{"name":"$self","containerName":"DNA","kind":13,"line":301},{"line":304,"kind":13,"containerName":"DNA","name":"$self"}],"line":290,"name":"DNA","range":{"end":{"character":9999,"line":306},"start":{"character":0,"line":290}}},{"range":{"end":{"line":342,"character":9999},"start":{"character":0,"line":326}},"name":"RNA","line":326,"children":[{"containerName":"RNA","definition":"my","name":"$self","localvar":"my","kind":13,"line":327},{"containerName":"RNA","name":"$value","kind":13,"line":327},{"line":328,"kind":13,"name":"$value","containerName":"RNA"},{"line":329,"kind":13,"containerName":"RNA","name":"$value"},{"line":329,"kind":12,"containerName":"RNA","name":"isa"},{"kind":13,"line":330,"name":"$self","containerName":"RNA"},{"name":"throw","containerName":"RNA","line":330,"kind":12},{"kind":13,"line":334,"containerName":"RNA","name":"$self"},{"containerName":"RNA","name":"$value","line":334,"kind":13},{"kind":13,"line":337,"name":"$self","containerName":"RNA"},{"containerName":"RNA","name":"$self","line":340,"kind":13}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef","parameters":[{"label":"$self"},{"label":"$value"}],"label":"RNA($self,$value)"},"containerName":"main::","definition":"sub"},{"kind":12,"children":[{"containerName":"dnamut","definition":"my","name":"$self","localvar":"my","kind":13,"line":364},{"kind":13,"line":364,"containerName":"dnamut","name":"$value"},{"line":365,"kind":13,"name":"$value","containerName":"dnamut"},{"kind":13,"line":366,"name":"$value","containerName":"dnamut"},{"line":366,"kind":12,"name":"isa","containerName":"dnamut"},{"line":367,"kind":13,"name":"$self","containerName":"dnamut"},{"kind":12,"line":367,"name":"throw","containerName":"dnamut"},{"kind":13,"line":371,"containerName":"dnamut","name":"$self"},{"containerName":"dnamut","name":"$value","line":371,"kind":13},{"name":"$self","containerName":"dnamut","kind":13,"line":374},{"line":377,"kind":13,"name":"$self","containerName":"dnamut"}],"line":363,"definition":"sub","containerName":"main::","signature":{"label":"dnamut($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information."},"detail":"($self,$value)","name":"dnamut","range":{"end":{"line":379,"character":9999},"start":{"character":0,"line":363}}},{"name":"rnachange","range":{"start":{"line":400,"character":0},"end":{"character":9999,"line":416}},"kind":12,"line":400,"children":[{"containerName":"rnachange","definition":"my","name":"$self","localvar":"my","kind":13,"line":401},{"line":401,"kind":13,"containerName":"rnachange","name":"$value"},{"containerName":"rnachange","name":"$value","kind":13,"line":402},{"containerName":"rnachange","name":"$value","line":403,"kind":13},{"kind":12,"line":403,"name":"isa","containerName":"rnachange"},{"containerName":"rnachange","name":"$self","kind":13,"line":404},{"name":"throw","containerName":"rnachange","kind":12,"line":404},{"name":"$self","containerName":"rnachange","kind":13,"line":408},{"containerName":"rnachange","name":"$value","line":408,"kind":13},{"containerName":"rnachange","name":"$self","kind":13,"line":411},{"containerName":"rnachange","name":"$self","line":414,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"rnachange($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information."}},{"name":"aachange","range":{"start":{"line":437,"character":0},"end":{"character":9999,"line":453}},"kind":12,"line":437,"children":[{"line":438,"kind":13,"localvar":"my","containerName":"aachange","definition":"my","name":"$self"},{"name":"$value","containerName":"aachange","kind":13,"line":438},{"line":439,"kind":13,"containerName":"aachange","name":"$value"},{"kind":13,"line":440,"containerName":"aachange","name":"$value"},{"kind":12,"line":440,"containerName":"aachange","name":"isa"},{"containerName":"aachange","name":"$self","kind":13,"line":441},{"line":441,"kind":12,"name":"throw","containerName":"aachange"},{"name":"$self","containerName":"aachange","line":445,"kind":13},{"line":445,"kind":13,"name":"$value","containerName":"aachange"},{"line":448,"kind":13,"name":"$self","containerName":"aachange"},{"kind":13,"line":451,"containerName":"aachange","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"aachange($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information."}},{"range":{"start":{"character":0,"line":474},"end":{"character":9999,"line":484}},"name":"exons","children":[{"localvar":"my","containerName":"exons","name":"$self","definition":"my","line":475,"kind":13},{"name":"$value","containerName":"exons","line":475,"kind":13},{"name":"$value","containerName":"exons","kind":13,"line":476},{"containerName":"exons","name":"$self","kind":13,"line":477},{"line":477,"kind":13,"containerName":"exons","name":"$value"},{"kind":13,"line":479,"containerName":"exons","name":"$self"},{"kind":13,"line":482,"name":"$self","containerName":"exons"}],"line":474,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information.\n\n\n\nsub aachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::AAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::AAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'aachange'} = $value;\n      }\n  }\n  unless (exists $self->{'aachange'}) {\n      return;\n  } else {\n      return $self->{'aachange'};\n  }\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $mutobj = $obj->exons;\n         : $mutobj = $obj->exons($objref);\n Function:\n\n           Returns or sets the reference to a current array of Exons.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an array of Bio::LiveSeq::Exon objects or undef\n\nSee L<Bio::LiveSeq::Exon> for more information.","label":"exons($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"signature":{"label":"change_gene_with_alignment($self,$aln)","documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information.\n\n\n\nsub aachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::AAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::AAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'aachange'} = $value;\n      }\n  }\n  unless (exists $self->{'aachange'}) {\n      return;\n  } else {\n      return $self->{'aachange'};\n  }\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $mutobj = $obj->exons;\n         : $mutobj = $obj->exons($objref);\n Function:\n\n           Returns or sets the reference to a current array of Exons.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an array of Bio::LiveSeq::Exon objects or undef\n\nSee L<Bio::LiveSeq::Exon> for more information.\n\n\n\nsub exons {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'exons'} = $value;\n  }\n  unless (exists $self->{'exons'}) {\n      return;\n  } else {\n      return $self->{'exons'};\n  }\n}\n\n=head2 change_gene_with_alignment\n\n Title   : change_gene_with_alignment\n Usage   : $results=$mutate->change_gene_with_alignment($aln);\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes in the alignment. The alignment has\n           to be pairwise and have one sequence named 'QUERY', the\n           other one is assumed to be a part of the sequence from\n           $gene.\n\n           This method offers a shortcut to change_gene and\n           automates the creation of Bio::LiveSeq::Mutation objects.\n           Use it with almost identical sequnces, e.g. to locate a SNP.\n\n Args    : Bio::SimpleAlign object representing a short local alignment\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\nSee L<Bio::LiveSeq::Mutation>, L<Bio::SimpleAlign>, and\nL<Bio::Variation::SeqDiff>  for more information.","parameters":[{"label":"$self"},{"label":"$aln"}]},"detail":"($self,$aln)","definition":"sub","containerName":"main::","children":[{"containerName":"change_gene_with_alignment","definition":"my","name":"$self","localvar":"my","kind":13,"line":512},{"name":"$aln","containerName":"change_gene_with_alignment","kind":13,"line":512},{"containerName":"change_gene_with_alignment","name":"$self","line":518,"kind":13},{"containerName":"change_gene_with_alignment","name":"throw","line":518,"kind":12},{"name":"$aln","containerName":"change_gene_with_alignment","line":519,"kind":13},{"name":"isa","containerName":"change_gene_with_alignment","kind":12,"line":519},{"line":520,"kind":13,"name":"$self","containerName":"change_gene_with_alignment"},{"kind":12,"line":520,"containerName":"change_gene_with_alignment","name":"throw"},{"line":521,"kind":13,"name":"$aln","containerName":"change_gene_with_alignment"},{"kind":12,"line":521,"containerName":"change_gene_with_alignment","name":"no_sequences"},{"localvar":"my","name":"$queryseq_pos","definition":"my","containerName":"change_gene_with_alignment","line":524,"kind":13},{"localvar":"my","name":"$refseq_pos","definition":"my","containerName":"change_gene_with_alignment","line":525,"kind":13},{"name":"$aln","containerName":"change_gene_with_alignment","line":526,"kind":13},{"name":"get_seq_by_pos","containerName":"change_gene_with_alignment","line":526,"kind":12},{"kind":12,"line":526,"containerName":"change_gene_with_alignment","name":"id"},{"name":"$aln","containerName":"change_gene_with_alignment","kind":13,"line":528},{"kind":12,"line":528,"name":"get_seq_by_pos","containerName":"change_gene_with_alignment"},{"containerName":"change_gene_with_alignment","name":"id","line":528,"kind":12},{"kind":13,"line":529,"name":"$queryseq_pos","containerName":"change_gene_with_alignment"},{"line":530,"kind":13,"containerName":"change_gene_with_alignment","name":"$refseq_pos"},{"containerName":"change_gene_with_alignment","name":"$start","definition":"my","localvar":"my","kind":13,"line":534},{"containerName":"change_gene_with_alignment","name":"$aln","kind":13,"line":534},{"name":"column_from_residue_number","containerName":"change_gene_with_alignment","line":534,"kind":12},{"localvar":"my","name":"$end","definition":"my","containerName":"change_gene_with_alignment","line":535,"kind":13},{"line":535,"kind":13,"name":"$aln","containerName":"change_gene_with_alignment"},{"name":"column_from_residue_number","containerName":"change_gene_with_alignment","kind":12,"line":535},{"line":536,"kind":13,"containerName":"change_gene_with_alignment","name":"$aln"},{"kind":12,"line":536,"containerName":"change_gene_with_alignment","name":"get_seq_by_pos"},{"kind":13,"line":536,"containerName":"change_gene_with_alignment","name":"$queryseq_pos"},{"containerName":"change_gene_with_alignment","name":"end","line":536,"kind":12},{"line":538,"kind":13,"localvar":"my","definition":"my","name":"$aln2","containerName":"change_gene_with_alignment"},{"line":538,"kind":13,"containerName":"change_gene_with_alignment","name":"$aln"},{"containerName":"change_gene_with_alignment","name":"slice","kind":12,"line":538},{"kind":13,"line":538,"name":"$start","containerName":"change_gene_with_alignment"},{"kind":13,"line":538,"name":"$end","containerName":"change_gene_with_alignment"},{"localvar":"my","definition":"my","name":"$cs","containerName":"change_gene_with_alignment","line":544,"kind":13},{"name":"$aln2","containerName":"change_gene_with_alignment","line":544,"kind":13},{"line":544,"kind":12,"containerName":"change_gene_with_alignment","name":"consensus_string"},{"localvar":"my","containerName":"change_gene_with_alignment","name":"$queryseq","definition":"my","line":545,"kind":13},{"line":545,"kind":13,"name":"$aln2","containerName":"change_gene_with_alignment"},{"line":545,"kind":12,"containerName":"change_gene_with_alignment","name":"get_seq_by_pos"},{"line":545,"kind":13,"name":"$queryseq_pos","containerName":"change_gene_with_alignment"},{"line":546,"kind":13,"localvar":"my","containerName":"change_gene_with_alignment","definition":"my","name":"$refseq"},{"line":546,"kind":13,"name":"$aln2","containerName":"change_gene_with_alignment"},{"name":"get_seq_by_pos","containerName":"change_gene_with_alignment","kind":12,"line":546},{"line":546,"kind":13,"name":"$refseq_pos","containerName":"change_gene_with_alignment"},{"kind":13,"line":548,"name":"$cs","containerName":"change_gene_with_alignment"},{"localvar":"my","containerName":"change_gene_with_alignment","definition":"my","name":"$pos","line":550,"kind":13},{"line":550,"kind":13,"containerName":"change_gene_with_alignment","name":"$cs"},{"localvar":"my","definition":"my","name":"$mutation","containerName":"change_gene_with_alignment","line":551,"kind":13},{"containerName":"change_gene_with_alignment","name":"$self","kind":13,"line":551},{"line":552,"kind":13,"name":"$refseq","containerName":"change_gene_with_alignment"},{"kind":13,"line":553,"name":"$queryseq","containerName":"change_gene_with_alignment"},{"line":554,"kind":13,"containerName":"change_gene_with_alignment","name":"$pos"},{"kind":13,"line":558,"containerName":"change_gene_with_alignment","name":"$pos"},{"line":558,"kind":13,"containerName":"change_gene_with_alignment","name":"$refseq"},{"name":"start","containerName":"change_gene_with_alignment","kind":12,"line":558},{"line":559,"kind":13,"containerName":"change_gene_with_alignment","name":"$mutation"},{"name":"pos","containerName":"change_gene_with_alignment","line":559,"kind":12},{"kind":13,"line":559,"name":"$pos","containerName":"change_gene_with_alignment"},{"line":561,"kind":13,"containerName":"change_gene_with_alignment","name":"$self"},{"name":"add_Mutation","containerName":"change_gene_with_alignment","line":561,"kind":12},{"containerName":"change_gene_with_alignment","name":"$mutation","line":561,"kind":13},{"kind":13,"line":563,"name":"$self","containerName":"change_gene_with_alignment"},{"name":"change_gene","containerName":"change_gene_with_alignment","kind":12,"line":563}],"line":511,"kind":12,"range":{"end":{"line":564,"character":9999},"start":{"character":0,"line":511}},"name":"change_gene_with_alignment"},{"line":527,"kind":12,"name":"carp"},{"name":"create_mutation","line":551,"kind":12},{"line":555,"kind":12,"name":"CORE","containerName":"length"},{"name":"create_mutation","range":{"start":{"character":0,"line":590},"end":{"character":9999,"line":632}},"kind":12,"line":590,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"create_mutation","line":591,"kind":13},{"line":591,"kind":13,"name":"$refseq","containerName":"create_mutation"},{"kind":13,"line":591,"containerName":"create_mutation","name":"$queryseq"},{"kind":13,"line":591,"name":"$pos","containerName":"create_mutation"},{"kind":13,"line":591,"name":"$len","containerName":"create_mutation"},{"containerName":"create_mutation","name":"$self","line":593,"kind":13},{"name":"throw","containerName":"create_mutation","kind":12,"line":593},{"containerName":"create_mutation","name":"$refseq","line":594,"kind":13},{"name":"isa","containerName":"create_mutation","kind":12,"line":594},{"name":"$self","containerName":"create_mutation","kind":13,"line":595},{"line":595,"kind":12,"containerName":"create_mutation","name":"throw"},{"containerName":"create_mutation","name":"$queryseq","line":596,"kind":13},{"kind":12,"line":596,"name":"isa","containerName":"create_mutation"},{"line":597,"kind":13,"name":"$self","containerName":"create_mutation"},{"containerName":"create_mutation","name":"throw","line":597,"kind":12},{"containerName":"create_mutation","name":"$pos","kind":13,"line":598},{"containerName":"create_mutation","name":"$self","line":599,"kind":13},{"name":"throw","containerName":"create_mutation","kind":12,"line":599},{"containerName":"create_mutation","name":"$len","kind":13,"line":600},{"localvar":"my","containerName":"create_mutation","name":"$mutation","definition":"my","line":602,"kind":13},{"localvar":"my","name":"$refstring","definition":"my","containerName":"create_mutation","line":603,"kind":13},{"containerName":"create_mutation","name":"$refseq","kind":13,"line":603},{"kind":12,"line":603,"name":"subseq","containerName":"create_mutation"},{"containerName":"create_mutation","name":"$pos","line":603,"kind":13},{"containerName":"create_mutation","name":"$pos","line":603,"kind":13},{"line":603,"kind":13,"name":"$len","containerName":"create_mutation"},{"line":604,"kind":13,"localvar":"my","containerName":"create_mutation","name":"$varstring","definition":"my"},{"line":604,"kind":13,"containerName":"create_mutation","name":"$queryseq"},{"containerName":"create_mutation","name":"subseq","kind":12,"line":604},{"kind":13,"line":604,"containerName":"create_mutation","name":"$pos"},{"name":"$pos","containerName":"create_mutation","kind":13,"line":604},{"name":"$len","containerName":"create_mutation","kind":13,"line":604},{"containerName":"create_mutation","name":"$len","line":606,"kind":13},{"containerName":"create_mutation","name":"$refstring","line":606,"kind":13},{"name":"$varstring","containerName":"create_mutation","line":607,"kind":13},{"kind":13,"line":608,"name":"$mutation","containerName":"create_mutation"},{"containerName":"create_mutation","name":"new","kind":12,"line":608},{"name":"$varstring","containerName":"create_mutation","kind":13,"line":608},{"name":"$pos","containerName":"create_mutation","kind":13,"line":609},{"kind":13,"line":612,"containerName":"create_mutation","name":"$refstring"},{"containerName":"create_mutation","name":"$varstring","kind":13,"line":613},{"kind":13,"line":614,"name":"$mutation","containerName":"create_mutation"},{"kind":12,"line":614,"name":"new","containerName":"create_mutation"},{"containerName":"create_mutation","name":"$pos","line":614,"kind":13},{"kind":13,"line":616,"containerName":"create_mutation","name":"$len"},{"name":"$refstring","containerName":"create_mutation","line":618,"kind":13},{"line":619,"kind":13,"containerName":"create_mutation","name":"$varstring"},{"name":"$mutation","containerName":"create_mutation","line":620,"kind":13},{"kind":12,"line":620,"name":"new","containerName":"create_mutation"},{"line":620,"kind":13,"name":"$varstring","containerName":"create_mutation"},{"containerName":"create_mutation","name":"$pos","kind":13,"line":621},{"line":625,"kind":13,"containerName":"create_mutation","name":"$mutation"},{"line":625,"kind":12,"name":"new","containerName":"create_mutation"},{"line":625,"kind":13,"name":"$varstring","containerName":"create_mutation"},{"name":"$pos","containerName":"create_mutation","line":626,"kind":13},{"containerName":"create_mutation","name":"$len","line":628,"kind":13},{"containerName":"create_mutation","name":"$mutation","line":631,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$refseq,$queryseq,$pos,$len)","signature":{"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information.\n\n\n\nsub aachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::AAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::AAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'aachange'} = $value;\n      }\n  }\n  unless (exists $self->{'aachange'}) {\n      return;\n  } else {\n      return $self->{'aachange'};\n  }\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $mutobj = $obj->exons;\n         : $mutobj = $obj->exons($objref);\n Function:\n\n           Returns or sets the reference to a current array of Exons.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an array of Bio::LiveSeq::Exon objects or undef\n\nSee L<Bio::LiveSeq::Exon> for more information.\n\n\n\nsub exons {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'exons'} = $value;\n  }\n  unless (exists $self->{'exons'}) {\n      return;\n  } else {\n      return $self->{'exons'};\n  }\n}\n\n=head2 change_gene_with_alignment\n\n Title   : change_gene_with_alignment\n Usage   : $results=$mutate->change_gene_with_alignment($aln);\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes in the alignment. The alignment has\n           to be pairwise and have one sequence named 'QUERY', the\n           other one is assumed to be a part of the sequence from\n           $gene.\n\n           This method offers a shortcut to change_gene and\n           automates the creation of Bio::LiveSeq::Mutation objects.\n           Use it with almost identical sequnces, e.g. to locate a SNP.\n\n Args    : Bio::SimpleAlign object representing a short local alignment\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\nSee L<Bio::LiveSeq::Mutation>, L<Bio::SimpleAlign>, and\nL<Bio::Variation::SeqDiff>  for more information.\n\n\nsub change_gene_with_alignment {\n    my ($self, $aln) = @_;\n\n    #\n    # Sanity checks\n    #\n\n    $self->throw(\"Argument is not a Bio::SimpleAlign object but a [$aln]\")\n\tunless $aln->isa('Bio::SimpleAlign');\n    $self->throw(\"'Pairwise alignments only, please\") \n\tif $aln->no_sequences != 2;\n\n    # find out the order the two sequences are given\n    my $queryseq_pos = 1; #default\n    my $refseq_pos = 2;\n    unless ($aln->get_seq_by_pos(1)->id eq 'QUERY') {\n\tcarp('Query sequence has to be named QUERY') \n\t    if $aln->get_seq_by_pos(2)->id ne 'QUERY';\n\t$queryseq_pos = 2; # alternative\n\t$refseq_pos = 1;\n    }\n\n    # trim the alignment\n    my $start =  $aln->column_from_residue_number('QUERY', 1);\n    my $end =  $aln->column_from_residue_number('QUERY', \n\t\t\t\t\t\t$aln->get_seq_by_pos($queryseq_pos)->end );\n    \n    my $aln2 = $aln->slice($start, $end);\n\n    #\n    # extracting mutations\n    #\n\n    my $cs = $aln2->consensus_string(51);\n    my $queryseq = $aln2->get_seq_by_pos($queryseq_pos);\n    my $refseq = $aln2->get_seq_by_pos($refseq_pos);\n\n    while ( $cs =~ /(\\?+)/g) {\n\t# pos in local coordinates\n\tmy $pos = pos($cs) - length($1) + 1;\n\tmy $mutation = create_mutation($self, \n\t\t\t\t       $refseq, \n\t\t\t\t       $queryseq, \n\t\t\t\t       $pos, \n\t\t\t\t       CORE::length($1)\n\t\t\t\t       );\n\t# reset pos to refseq coordinates\n\t$pos +=  $refseq->start - 1;\n\t$mutation->pos($pos);\n\n        $self->add_Mutation($mutation);\n    }\n    return $self->change_gene();\n}\n\n=head2 create_mutation\n\n Title   : create_mutation\n Usage   : \n Function:\n\n           Formats sequence differences from two sequences into\n           Bio::LiveSeq::Mutation objects which can be applied to a\n           gene.\n\n           To keep it generic, sequence arguments need not to be\n           Bio::LocatableSeq. Coordinate change to parent sequence\n           numbering needs to be done by the calling code.\n\n           Called from change_gene_with_alignment\n\n Args    : Bio::PrimarySeqI inheriting object for the reference sequence\n           Bio::PrimarySeqI inheriting object for the query sequence\n           integer for the start position of the local sequence difference\n           integer for the length of the sequence difference\n Returns : Bio::LiveSeq::Mutation object ","parameters":[{"label":"$self"},{"label":"$refseq"},{"label":"$queryseq"},{"label":"$pos"},{"label":"$len"}],"label":"create_mutation($self,$refseq,$queryseq,$pos,$len)"}},{"name":"Bio","containerName":"LiveSeq::Mutation","kind":12,"line":608},{"kind":12,"line":614,"containerName":"LiveSeq::Mutation","name":"Bio"},{"containerName":"LiveSeq::Mutation","name":"Bio","line":620,"kind":12},{"kind":12,"line":625,"containerName":"LiveSeq::Mutation","name":"Bio"},{"range":{"start":{"character":0,"line":679},"end":{"character":9999,"line":692}},"name":"change_gene","line":679,"children":[{"containerName":"change_gene","definition":"my","name":"$self","localvar":"my","kind":13,"line":680},{"kind":13,"line":685,"containerName":"change_gene","name":"$self"},{"containerName":"change_gene","name":"gene","kind":12,"line":685},{"line":686,"kind":13,"name":"$self","containerName":"change_gene"},{"containerName":"change_gene","name":"warn","line":686,"kind":12},{"containerName":"change_gene","name":"@transcripts","definition":"my","localvar":"my","kind":13,"line":692},{"line":692,"kind":13,"name":"$self","containerName":"change_gene"},{"containerName":"change_gene","name":"gene","kind":12,"line":692},{"line":692,"kind":12,"name":"get_Transcripts","containerName":"change_gene"}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information.\n\n\n\nsub aachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::AAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::AAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'aachange'} = $value;\n      }\n  }\n  unless (exists $self->{'aachange'}) {\n      return;\n  } else {\n      return $self->{'aachange'};\n  }\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $mutobj = $obj->exons;\n         : $mutobj = $obj->exons($objref);\n Function:\n\n           Returns or sets the reference to a current array of Exons.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an array of Bio::LiveSeq::Exon objects or undef\n\nSee L<Bio::LiveSeq::Exon> for more information.\n\n\n\nsub exons {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'exons'} = $value;\n  }\n  unless (exists $self->{'exons'}) {\n      return;\n  } else {\n      return $self->{'exons'};\n  }\n}\n\n=head2 change_gene_with_alignment\n\n Title   : change_gene_with_alignment\n Usage   : $results=$mutate->change_gene_with_alignment($aln);\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes in the alignment. The alignment has\n           to be pairwise and have one sequence named 'QUERY', the\n           other one is assumed to be a part of the sequence from\n           $gene.\n\n           This method offers a shortcut to change_gene and\n           automates the creation of Bio::LiveSeq::Mutation objects.\n           Use it with almost identical sequnces, e.g. to locate a SNP.\n\n Args    : Bio::SimpleAlign object representing a short local alignment\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\nSee L<Bio::LiveSeq::Mutation>, L<Bio::SimpleAlign>, and\nL<Bio::Variation::SeqDiff>  for more information.\n\n\nsub change_gene_with_alignment {\n    my ($self, $aln) = @_;\n\n    #\n    # Sanity checks\n    #\n\n    $self->throw(\"Argument is not a Bio::SimpleAlign object but a [$aln]\")\n\tunless $aln->isa('Bio::SimpleAlign');\n    $self->throw(\"'Pairwise alignments only, please\") \n\tif $aln->no_sequences != 2;\n\n    # find out the order the two sequences are given\n    my $queryseq_pos = 1; #default\n    my $refseq_pos = 2;\n    unless ($aln->get_seq_by_pos(1)->id eq 'QUERY') {\n\tcarp('Query sequence has to be named QUERY') \n\t    if $aln->get_seq_by_pos(2)->id ne 'QUERY';\n\t$queryseq_pos = 2; # alternative\n\t$refseq_pos = 1;\n    }\n\n    # trim the alignment\n    my $start =  $aln->column_from_residue_number('QUERY', 1);\n    my $end =  $aln->column_from_residue_number('QUERY', \n\t\t\t\t\t\t$aln->get_seq_by_pos($queryseq_pos)->end );\n    \n    my $aln2 = $aln->slice($start, $end);\n\n    #\n    # extracting mutations\n    #\n\n    my $cs = $aln2->consensus_string(51);\n    my $queryseq = $aln2->get_seq_by_pos($queryseq_pos);\n    my $refseq = $aln2->get_seq_by_pos($refseq_pos);\n\n    while ( $cs =~ /(\\?+)/g) {\n\t# pos in local coordinates\n\tmy $pos = pos($cs) - length($1) + 1;\n\tmy $mutation = create_mutation($self, \n\t\t\t\t       $refseq, \n\t\t\t\t       $queryseq, \n\t\t\t\t       $pos, \n\t\t\t\t       CORE::length($1)\n\t\t\t\t       );\n\t# reset pos to refseq coordinates\n\t$pos +=  $refseq->start - 1;\n\t$mutation->pos($pos);\n\n        $self->add_Mutation($mutation);\n    }\n    return $self->change_gene();\n}\n\n=head2 create_mutation\n\n Title   : create_mutation\n Usage   : \n Function:\n\n           Formats sequence differences from two sequences into\n           Bio::LiveSeq::Mutation objects which can be applied to a\n           gene.\n\n           To keep it generic, sequence arguments need not to be\n           Bio::LocatableSeq. Coordinate change to parent sequence\n           numbering needs to be done by the calling code.\n\n           Called from change_gene_with_alignment\n\n Args    : Bio::PrimarySeqI inheriting object for the reference sequence\n           Bio::PrimarySeqI inheriting object for the query sequence\n           integer for the start position of the local sequence difference\n           integer for the length of the sequence difference\n Returns : Bio::LiveSeq::Mutation object \n\n\nsub create_mutation {\n    my ($self, $refseq, $queryseq, $pos, $len) = @_;\n    \n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$refseq]\") \n\tunless $refseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$queryseq]\") \n\tunless $queryseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Position is not a positive integer but [$pos]\") \n\tunless $pos =~ /^\\+?\\d+$/;\n    $self->throw(\"Length is not a positive integer but [$len]\") \n\tunless $len =~ /^\\+?\\d+$/;\n\n    my $mutation;\n    my $refstring = $refseq->subseq($pos, $pos + $len - 1);\n    my $varstring = $queryseq->subseq($pos, $pos + $len - 1);\n    \n    if ($len == 1 and $refstring =~ /[^\\.\\-\\*\\?]/ and \n\t$varstring  =~ /[^\\.\\-\\*\\?]/ ) { #point\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring =~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  !~ /^[^\\.\\-\\*\\?]+$/ ) { # deletion\n\t$mutation = Bio::LiveSeq::Mutation->new(-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring !~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  =~ /^[^\\.\\-\\*\\?]+$/ ) { # insertion\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => 0\n\t\t\t\t\t\t);\n    } else { # complex\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    \n    return $mutation;\n}\n\n=head2 change_gene\n\n Title   : change_gene\n Usage   : my $mutate = Bio::LiveSeq::Mutator->new(-gene => $gene,\n\t\t\t\t\t\t   numbering => \"coding\"\n\t\t\t\t\t\t   );\n           # $mut is Bio::LiveSeq::Mutation object\n           $mutate->add_Mutation($mut);\n           my $results=$mutate->change_gene();\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes performed according to the\n           instructions present in Mutation(s).  The -numbering\n           argument decides what molecule is being changed and what\n           numbering scheme being used:\n\n            -numbering => \"entry\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the sequence\n\n            -numbering => \"coding\"\n\n               determines the RNA level, using the numbering from the\n               beginning of the 1st transcript\n\n               Alternative transcripts can be used by specifying\n               \"coding 2\" or \"coding 3\" ...\n\n            -numbering => \"gene\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the 1st transcript and inluding introns.\n               The meaning equals 'coding' if the reference molecule\n               is cDNA.\n\n Args    : Bio::LiveSeq::Gene object\n           Bio::LiveSeq::Mutation object(s)\n           string specifying a numbering scheme (defaults to 'coding')\n Returns : Bio::Variation::SeqDiff object or 0 on error","label":"change_gene($self)"},"containerName":"main::","definition":"sub"},{"line":693,"kind":13,"localvar":"my","definition":"my","name":"$refseq","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":696},{"name":"numbering","containerName":"main::","line":696,"kind":12},{"line":696,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":696,"containerName":"main::","name":"gene"},{"kind":12,"line":696,"name":"get_DNA","containerName":"main::"},{"kind":12,"line":696,"name":"alphabet","containerName":"main::"},{"containerName":null,"name":"$self","kind":13,"line":696},{"kind":12,"line":696,"name":"numbering","containerName":"main::"},{"kind":13,"line":698,"containerName":null,"name":"$self"},{"name":"numbering","containerName":"main::","kind":12,"line":698},{"line":699,"kind":13,"name":"$self","containerName":null},{"line":699,"kind":12,"name":"numbering","containerName":"main::"},{"definition":"my","name":"$transnumber","containerName":null,"localvar":"my","kind":13,"line":700},{"line":701,"kind":13,"name":"$transnumber","containerName":null},{"name":"$transnumber","containerName":null,"kind":13,"line":702},{"name":"$transnumber","containerName":null,"line":702,"kind":13},{"containerName":null,"name":"$transnumber","line":702,"kind":13},{"kind":12,"line":702,"name":"transcripts"},{"kind":13,"line":703,"name":"$refseq","containerName":null},{"containerName":null,"name":"@transcripts","line":703,"kind":13},{"kind":13,"line":703,"containerName":null,"name":"%transnumber"},{"kind":13,"line":705,"name":"$transnumber","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":705},{"line":705,"kind":12,"name":"warn","containerName":"main::"},{"kind":13,"line":705,"name":"$transnumber","containerName":null},{"kind":13,"line":707,"name":"$refseq","containerName":null},{"name":"@transcripts","containerName":null,"kind":13,"line":707},{"kind":13,"line":710,"containerName":null,"name":"$refseq"},{"containerName":null,"name":"@transcripts","line":710,"kind":13},{"kind":13,"line":715,"containerName":null,"name":"$seqDiff","definition":"my","localvar":"my"},{"line":715,"kind":12,"containerName":"Variation::SeqDiff","name":"Bio"},{"name":"new","containerName":"main::","kind":12,"line":715},{"kind":13,"line":715,"containerName":null,"name":"$self"},{"containerName":"main::","name":"verbose","line":715,"kind":12},{"containerName":null,"name":"$seqDiff","kind":13,"line":716},{"line":716,"kind":12,"containerName":"main::","name":"alphabet"},{"containerName":null,"name":"$self","line":716,"kind":13},{"kind":12,"line":716,"name":"gene","containerName":"main::"},{"kind":12,"line":716,"name":"get_DNA","containerName":"main::"},{"name":"alphabet","containerName":"main::","line":716,"kind":12},{"line":717,"kind":13,"containerName":null,"name":"$seqDiff"},{"containerName":"main::","name":"numbering","kind":12,"line":717},{"containerName":null,"name":"$self","line":717,"kind":13},{"name":"numbering","containerName":"main::","kind":12,"line":717},{"kind":13,"line":718,"containerName":null,"name":"$DNAobj","definition":"my","localvar":"my"},{"line":718,"kind":13,"name":"$RNAobj","containerName":null},{"name":"$refseq","containerName":null,"line":719,"kind":13},{"containerName":"main::","name":"isa","line":719,"kind":12},{"containerName":null,"name":"$self","line":720,"kind":13},{"containerName":"main::","name":"RNA","kind":12,"line":720},{"containerName":null,"name":"$refseq","kind":13,"line":720},{"name":"$self","containerName":null,"line":721,"kind":13},{"kind":12,"line":721,"name":"DNA","containerName":"main::"},{"kind":13,"line":721,"containerName":null,"name":"%refseq"},{"name":"$seqDiff","containerName":null,"kind":13,"line":722},{"name":"rna_ori","containerName":"main::","kind":12,"line":722},{"kind":13,"line":722,"name":"$refseq","containerName":null},{"name":"seq","containerName":"main::","kind":12,"line":722},{"containerName":null,"name":"$seqDiff","kind":13,"line":723},{"containerName":"main::","name":"aa_ori","line":723,"kind":12},{"line":723,"kind":13,"name":"$refseq","containerName":null},{"name":"get_Translation","containerName":"main::","kind":12,"line":723},{"name":"seq","containerName":"main::","line":723,"kind":12},{"containerName":null,"name":"$self","kind":13,"line":725},{"containerName":"main::","name":"DNA","line":725,"kind":12},{"name":"$refseq","containerName":null,"kind":13,"line":725},{"name":"$self","containerName":null,"line":726,"kind":13},{"name":"RNA","containerName":"main::","line":726,"kind":12},{"name":"@transcripts","containerName":null,"kind":13,"line":726},{"name":"$seqDiff","containerName":null,"line":727,"kind":13},{"containerName":"main::","name":"rna_ori","line":727,"kind":12},{"containerName":null,"name":"$self","line":727,"kind":13},{"containerName":"main::","name":"RNA","line":727,"kind":12},{"containerName":"main::","name":"seq","line":727,"kind":12},{"containerName":null,"name":"$seqDiff","line":728,"kind":13},{"line":728,"kind":12,"name":"aa_ori","containerName":"main::"},{"name":"$self","containerName":null,"line":728,"kind":13},{"line":728,"kind":12,"name":"RNA","containerName":"main::"},{"containerName":"main::","name":"get_Translation","line":728,"kind":12},{"line":728,"kind":12,"name":"seq","containerName":"main::"},{"line":730,"kind":13,"name":"$seqDiff","containerName":null},{"kind":12,"line":730,"containerName":"main::","name":"dna_ori"},{"name":"$self","containerName":null,"kind":13,"line":730},{"name":"DNA","containerName":"main::","line":730,"kind":12},{"kind":12,"line":730,"containerName":"main::","name":"seq"},{"name":"$seqDiff","containerName":null,"kind":13,"line":732},{"line":732,"kind":12,"name":"id","containerName":"main::"},{"containerName":null,"name":"$self","kind":13,"line":732},{"containerName":"main::","name":"DNA","line":732,"kind":12},{"name":"accession_number","containerName":"main::","line":732,"kind":12},{"kind":13,"line":736,"containerName":null,"name":"$atg_label","definition":"my","localvar":"my"},{"name":"$self","containerName":null,"line":736,"kind":13},{"name":"RNA","containerName":"main::","kind":12,"line":736},{"line":736,"kind":12,"name":"start","containerName":"main::"},{"line":737,"kind":13,"localvar":"my","containerName":null,"name":"$atg_offset","definition":"my"},{"containerName":null,"name":"$self","kind":13,"line":737},{"name":"DNA","containerName":"main::","kind":12,"line":737},{"line":737,"kind":12,"name":"position","containerName":"main::"},{"kind":13,"line":737,"containerName":null,"name":"$atg_label"},{"containerName":null,"name":"$self","line":737,"kind":13},{"containerName":"main::","name":"DNA","kind":12,"line":737},{"line":737,"kind":12,"name":"start","containerName":"main::"},{"name":"$seqDiff","containerName":null,"line":738,"kind":13},{"name":"offset","containerName":"main::","kind":12,"line":738},{"name":"$atg_offset","containerName":null,"kind":13,"line":738},{"containerName":null,"name":"$self","line":739,"kind":13},{"kind":12,"line":739,"containerName":"main::","name":"DNA"},{"containerName":"main::","name":"coordinate_start","kind":12,"line":739},{"containerName":null,"name":"$atg_label","line":739,"kind":13},{"definition":"my","name":"@exons","containerName":null,"localvar":"my","kind":13,"line":741},{"line":741,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"RNA","kind":12,"line":741},{"containerName":"main::","name":"all_Exons","kind":12,"line":741},{"containerName":null,"name":"$seqDiff","kind":13,"line":742},{"line":742,"kind":12,"name":"cds_end","containerName":"main::"},{"kind":13,"line":742,"containerName":null,"name":"@exons"},{"name":"exons","kind":12,"line":742},{"line":742,"kind":12,"name":"end","containerName":"main::"},{"containerName":null,"name":"$self","kind":13,"line":747},{"kind":12,"line":747,"containerName":"main::","name":"warn"},{"containerName":null,"name":"$self","line":748,"kind":13},{"kind":12,"line":748,"name":"_mutationpos2label","containerName":"main::"},{"kind":13,"line":748,"name":"$refseq","containerName":null},{"containerName":null,"name":"$seqDiff","line":748,"kind":13},{"kind":13,"line":757,"containerName":null,"definition":"my","name":"$k","localvar":"my"},{"kind":13,"line":758,"containerName":null,"name":"$mutation","definition":"my","localvar":"my"},{"containerName":null,"name":"$self","kind":13,"line":758},{"name":"each_Mutation","containerName":"main::","kind":12,"line":758},{"containerName":null,"name":"$mutation","kind":13,"line":759},{"containerName":"main::","name":"label","line":759,"kind":12},{"line":760,"kind":13,"containerName":null,"name":"$self"},{"name":"mutation","containerName":"main::","kind":12,"line":760},{"line":760,"kind":13,"containerName":null,"name":"$mutation"},{"name":"$mutation","containerName":null,"kind":13,"line":762},{"name":"issue","containerName":"main::","kind":12,"line":762},{"kind":13,"line":762,"name":"$k","containerName":null},{"name":"$self","containerName":null,"line":766,"kind":13},{"name":"numbering","containerName":"main::","kind":12,"line":766},{"name":"$mutation","containerName":null,"line":767,"kind":13},{"name":"transpos","containerName":"main::","line":767,"kind":12},{"containerName":null,"name":"$mutation","line":767,"kind":13},{"containerName":"main::","name":"pos","line":767,"kind":12},{"line":770,"kind":13,"containerName":null,"name":"$mutation"},{"kind":12,"line":770,"name":"transpos","containerName":"main::"},{"name":"$self","containerName":null,"line":770,"kind":13},{"name":"RNA","containerName":"main::","line":770,"kind":12},{"name":"position","containerName":"main::","kind":12,"line":770},{"line":770,"kind":13,"containerName":null,"name":"$mutation"},{"kind":12,"line":770,"name":"label","containerName":"main::"},{"line":770,"kind":13,"name":"$atg_label","containerName":null},{"line":775,"kind":13,"containerName":null,"name":"$mutation"},{"kind":12,"line":775,"containerName":"main::","name":"prelabel"},{"kind":13,"line":775,"name":"$self","containerName":null},{"line":775,"kind":12,"containerName":"main::","name":"DNA"},{"kind":12,"line":775,"name":"label","containerName":"main::"},{"line":775,"kind":13,"name":"$mutation","containerName":null},{"containerName":"main::","name":"label","kind":12,"line":775},{"kind":13,"line":776,"name":"$mutation","containerName":null},{"name":"len","containerName":"main::","line":776,"kind":12},{"name":"$mutation","containerName":null,"line":777,"kind":13},{"name":"postlabel","containerName":"main::","line":777,"kind":12},{"line":777,"kind":13,"containerName":null,"name":"$mutation"},{"containerName":"main::","name":"label","line":777,"kind":12},{"line":778,"kind":13,"name":"$mutation","containerName":null},{"line":778,"kind":12,"containerName":"main::","name":"lastlabel"},{"name":"$mutation","containerName":null,"kind":13,"line":778},{"name":"label","containerName":"main::","line":778,"kind":12},{"containerName":null,"name":"$mutation","kind":13,"line":779},{"line":779,"kind":12,"name":"len","containerName":"main::"},{"kind":13,"line":780,"name":"$mutation","containerName":null},{"kind":12,"line":780,"name":"lastlabel","containerName":"main::"},{"kind":13,"line":780,"containerName":null,"name":"$mutation"},{"name":"label","containerName":"main::","kind":12,"line":780},{"kind":13,"line":781,"name":"$mutation","containerName":null},{"containerName":"main::","name":"postlabel","line":781,"kind":12},{"containerName":null,"name":"$self","line":781,"kind":13},{"line":781,"kind":12,"containerName":"main::","name":"DNA"},{"line":781,"kind":12,"containerName":"main::","name":"label"},{"name":"$mutation","containerName":null,"kind":13,"line":781},{"line":781,"kind":12,"containerName":"main::","name":"lastlabel"},{"line":783,"kind":13,"name":"$mutation","containerName":null},{"kind":12,"line":783,"name":"lastlabel","containerName":"main::"},{"line":783,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"DNA","line":783,"kind":12},{"kind":12,"line":783,"name":"label","containerName":"main::"},{"line":783,"kind":13,"containerName":null,"name":"$mutation"},{"containerName":"main::","name":"len","line":783,"kind":12},{"kind":13,"line":783,"name":"$mutation","containerName":null},{"line":783,"kind":12,"name":"label","containerName":"main::"},{"name":"$mutation","containerName":null,"line":784,"kind":13},{"kind":12,"line":784,"containerName":"main::","name":"postlabel"},{"containerName":null,"name":"$self","kind":13,"line":784},{"containerName":"main::","name":"DNA","kind":12,"line":784},{"containerName":"main::","name":"label","kind":12,"line":784},{"line":784,"kind":13,"name":"$mutation","containerName":null},{"line":784,"kind":12,"name":"lastlabel","containerName":"main::"},{"line":786,"kind":13,"localvar":"my","name":"$dnamut","definition":"my","containerName":null},{"kind":13,"line":786,"containerName":null,"name":"$self"},{"line":786,"kind":12,"containerName":"main::","name":"_set_DNAMutation"},{"kind":13,"line":786,"name":"$seqDiff","containerName":null},{"name":"$self","containerName":null,"kind":13,"line":790},{"name":"_rnaAffected","containerName":"main::","line":790,"kind":12},{"kind":13,"line":791,"name":"$self","containerName":null},{"containerName":"main::","name":"_set_effects","kind":12,"line":791},{"name":"$seqDiff","containerName":null,"line":791,"kind":13},{"containerName":null,"name":"$dnamut","kind":13,"line":791},{"line":793,"kind":13,"containerName":null,"name":"$seqDiff"},{"containerName":"main::","name":"offset","kind":12,"line":793},{"name":"$dnamut","containerName":null,"kind":13,"line":793},{"name":"region","containerName":"main::","kind":12,"line":793},{"name":"$self","containerName":null,"line":794,"kind":13},{"line":794,"kind":12,"containerName":"main::","name":"_untranslated"},{"containerName":null,"name":"$seqDiff","line":794,"kind":13},{"containerName":null,"name":"%dnamut","line":794,"kind":13},{"kind":13,"line":801,"name":"$refseq","containerName":null},{"name":"labelchange","containerName":"main::","line":801,"kind":12},{"containerName":null,"name":"$mutation","line":801,"kind":13},{"containerName":"main::","name":"seq","line":801,"kind":12},{"line":801,"kind":13,"name":"$mutation","containerName":null},{"line":801,"kind":12,"containerName":"main::","name":"label"},{"line":801,"kind":13,"name":"$mutation","containerName":null},{"containerName":"main::","name":"len","kind":12,"line":801},{"kind":13,"line":804,"name":"$self","containerName":null},{"name":"_post_mutation","containerName":"main::","line":804,"kind":12},{"line":804,"kind":13,"containerName":null,"name":"$seqDiff"},{"name":"$self","containerName":null,"kind":13,"line":806},{"containerName":"main::","name":"dnamut","line":806,"kind":12},{"name":"$self","containerName":null,"line":807,"kind":13},{"kind":12,"line":807,"name":"rnachange","containerName":"main::"},{"name":"$self","containerName":null,"kind":13,"line":808},{"line":808,"kind":12,"containerName":"main::","name":"aachange"},{"name":"$self","containerName":null,"line":809,"kind":13},{"name":"exons","containerName":"main::","kind":12,"line":809},{"kind":13,"line":812,"containerName":null,"name":"$seqDiff"},{"line":812,"kind":12,"name":"dna_mut","containerName":"main::"},{"name":"$self","containerName":null,"line":812,"kind":13},{"kind":12,"line":812,"containerName":"main::","name":"DNA"},{"kind":12,"line":812,"name":"seq","containerName":"main::"},{"name":"$seqDiff","containerName":null,"kind":13,"line":813},{"name":"rna_mut","containerName":"main::","line":813,"kind":12},{"containerName":null,"name":"$self","kind":13,"line":813},{"kind":12,"line":813,"name":"RNA","containerName":"main::"},{"kind":12,"line":813,"name":"seq","containerName":"main::"},{"name":"$refseq","containerName":null,"kind":13,"line":814},{"line":814,"kind":12,"containerName":"main::","name":"isa"},{"containerName":null,"name":"$seqDiff","kind":13,"line":815},{"containerName":"main::","name":"aa_mut","kind":12,"line":815},{"kind":13,"line":815,"name":"$refseq","containerName":null},{"name":"get_Translation","containerName":"main::","kind":12,"line":815},{"name":"seq","containerName":"main::","line":815,"kind":12},{"kind":13,"line":817,"containerName":null,"name":"$seqDiff"},{"kind":12,"line":817,"name":"aa_mut","containerName":"main::"},{"name":"$self","containerName":null,"line":817,"kind":13},{"name":"RNA","containerName":"main::","kind":12,"line":817},{"name":"get_Translation","containerName":"main::","kind":12,"line":817},{"line":817,"kind":12,"containerName":"main::","name":"seq"},{"line":826,"kind":13,"containerName":null,"name":"$seqDiff"},{"name":"_mutationpos2label","range":{"start":{"line":840,"character":0},"end":{"line":843,"character":9999}},"kind":12,"line":840,"children":[{"line":841,"kind":13,"localvar":"my","containerName":"_mutationpos2label","definition":"my","name":"$self"},{"name":"$refseq","containerName":"_mutationpos2label","kind":13,"line":841},{"containerName":"_mutationpos2label","name":"$SeqDiff","kind":13,"line":841},{"containerName":"_mutationpos2label","definition":"my","name":"$count","localvar":"my","kind":13,"line":842},{"localvar":"my","definition":"my","name":"@bb","containerName":"_mutationpos2label","line":843,"kind":13},{"containerName":"_mutationpos2label","name":"$self","kind":13,"line":843}],"containerName":"main::","definition":"sub","detail":"($self,$refseq,$SeqDiff)","signature":{"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information.\n\n\n\nsub aachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::AAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::AAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'aachange'} = $value;\n      }\n  }\n  unless (exists $self->{'aachange'}) {\n      return;\n  } else {\n      return $self->{'aachange'};\n  }\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $mutobj = $obj->exons;\n         : $mutobj = $obj->exons($objref);\n Function:\n\n           Returns or sets the reference to a current array of Exons.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an array of Bio::LiveSeq::Exon objects or undef\n\nSee L<Bio::LiveSeq::Exon> for more information.\n\n\n\nsub exons {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'exons'} = $value;\n  }\n  unless (exists $self->{'exons'}) {\n      return;\n  } else {\n      return $self->{'exons'};\n  }\n}\n\n=head2 change_gene_with_alignment\n\n Title   : change_gene_with_alignment\n Usage   : $results=$mutate->change_gene_with_alignment($aln);\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes in the alignment. The alignment has\n           to be pairwise and have one sequence named 'QUERY', the\n           other one is assumed to be a part of the sequence from\n           $gene.\n\n           This method offers a shortcut to change_gene and\n           automates the creation of Bio::LiveSeq::Mutation objects.\n           Use it with almost identical sequnces, e.g. to locate a SNP.\n\n Args    : Bio::SimpleAlign object representing a short local alignment\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\nSee L<Bio::LiveSeq::Mutation>, L<Bio::SimpleAlign>, and\nL<Bio::Variation::SeqDiff>  for more information.\n\n\nsub change_gene_with_alignment {\n    my ($self, $aln) = @_;\n\n    #\n    # Sanity checks\n    #\n\n    $self->throw(\"Argument is not a Bio::SimpleAlign object but a [$aln]\")\n\tunless $aln->isa('Bio::SimpleAlign');\n    $self->throw(\"'Pairwise alignments only, please\") \n\tif $aln->no_sequences != 2;\n\n    # find out the order the two sequences are given\n    my $queryseq_pos = 1; #default\n    my $refseq_pos = 2;\n    unless ($aln->get_seq_by_pos(1)->id eq 'QUERY') {\n\tcarp('Query sequence has to be named QUERY') \n\t    if $aln->get_seq_by_pos(2)->id ne 'QUERY';\n\t$queryseq_pos = 2; # alternative\n\t$refseq_pos = 1;\n    }\n\n    # trim the alignment\n    my $start =  $aln->column_from_residue_number('QUERY', 1);\n    my $end =  $aln->column_from_residue_number('QUERY', \n\t\t\t\t\t\t$aln->get_seq_by_pos($queryseq_pos)->end );\n    \n    my $aln2 = $aln->slice($start, $end);\n\n    #\n    # extracting mutations\n    #\n\n    my $cs = $aln2->consensus_string(51);\n    my $queryseq = $aln2->get_seq_by_pos($queryseq_pos);\n    my $refseq = $aln2->get_seq_by_pos($refseq_pos);\n\n    while ( $cs =~ /(\\?+)/g) {\n\t# pos in local coordinates\n\tmy $pos = pos($cs) - length($1) + 1;\n\tmy $mutation = create_mutation($self, \n\t\t\t\t       $refseq, \n\t\t\t\t       $queryseq, \n\t\t\t\t       $pos, \n\t\t\t\t       CORE::length($1)\n\t\t\t\t       );\n\t# reset pos to refseq coordinates\n\t$pos +=  $refseq->start - 1;\n\t$mutation->pos($pos);\n\n        $self->add_Mutation($mutation);\n    }\n    return $self->change_gene();\n}\n\n=head2 create_mutation\n\n Title   : create_mutation\n Usage   : \n Function:\n\n           Formats sequence differences from two sequences into\n           Bio::LiveSeq::Mutation objects which can be applied to a\n           gene.\n\n           To keep it generic, sequence arguments need not to be\n           Bio::LocatableSeq. Coordinate change to parent sequence\n           numbering needs to be done by the calling code.\n\n           Called from change_gene_with_alignment\n\n Args    : Bio::PrimarySeqI inheriting object for the reference sequence\n           Bio::PrimarySeqI inheriting object for the query sequence\n           integer for the start position of the local sequence difference\n           integer for the length of the sequence difference\n Returns : Bio::LiveSeq::Mutation object \n\n\nsub create_mutation {\n    my ($self, $refseq, $queryseq, $pos, $len) = @_;\n    \n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$refseq]\") \n\tunless $refseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$queryseq]\") \n\tunless $queryseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Position is not a positive integer but [$pos]\") \n\tunless $pos =~ /^\\+?\\d+$/;\n    $self->throw(\"Length is not a positive integer but [$len]\") \n\tunless $len =~ /^\\+?\\d+$/;\n\n    my $mutation;\n    my $refstring = $refseq->subseq($pos, $pos + $len - 1);\n    my $varstring = $queryseq->subseq($pos, $pos + $len - 1);\n    \n    if ($len == 1 and $refstring =~ /[^\\.\\-\\*\\?]/ and \n\t$varstring  =~ /[^\\.\\-\\*\\?]/ ) { #point\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring =~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  !~ /^[^\\.\\-\\*\\?]+$/ ) { # deletion\n\t$mutation = Bio::LiveSeq::Mutation->new(-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring !~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  =~ /^[^\\.\\-\\*\\?]+$/ ) { # insertion\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => 0\n\t\t\t\t\t\t);\n    } else { # complex\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    \n    return $mutation;\n}\n\n=head2 change_gene\n\n Title   : change_gene\n Usage   : my $mutate = Bio::LiveSeq::Mutator->new(-gene => $gene,\n\t\t\t\t\t\t   numbering => \"coding\"\n\t\t\t\t\t\t   );\n           # $mut is Bio::LiveSeq::Mutation object\n           $mutate->add_Mutation($mut);\n           my $results=$mutate->change_gene();\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes performed according to the\n           instructions present in Mutation(s).  The -numbering\n           argument decides what molecule is being changed and what\n           numbering scheme being used:\n\n            -numbering => \"entry\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the sequence\n\n            -numbering => \"coding\"\n\n               determines the RNA level, using the numbering from the\n               beginning of the 1st transcript\n\n               Alternative transcripts can be used by specifying\n               \"coding 2\" or \"coding 3\" ...\n\n            -numbering => \"gene\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the 1st transcript and inluding introns.\n               The meaning equals 'coding' if the reference molecule\n               is cDNA.\n\n Args    : Bio::LiveSeq::Gene object\n           Bio::LiveSeq::Mutation object(s)\n           string specifying a numbering scheme (defaults to 'coding')\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\n\nsub change_gene {\n    my ($self) = @_;\n\n    #\n    # Sanity check\n    #\n    unless ($self->gene) {\n\t$self->warn(\"Input object Bio::LiveSeq::Gene is not given\");\n\treturn 0;\n    }\n    #\n    # Setting the reference sequence based on -numbering\n    #\n    my @transcripts=@{$self->gene->get_Transcripts};\n    my $refseq; # will hold Bio::LiveSeq:Transcript object or Bio::LiveSeq::DNA\n\n    # 'gene' eq 'coding' if reference sequence is cDNA\n    $self->numbering ('coding') if $self->gene->get_DNA->alphabet eq 'rna' and $self->numbering eq 'gene';\n\n    if ($self->numbering =~ /(coding)( )?(\\d+)?/ ) {\n\t$self->numbering($1);\n\tmy $transnumber = $3;\n\t$transnumber-- if $3; # 1 -> 0, 2 -> 1\n\tif ($transnumber && $transnumber >= 0 && $transnumber <= $#transcripts) {\n\t    $refseq=$transcripts[$transnumber];\n\t} else {\n\t    $transnumber && $self->warn(\"The alternative transcript number \". $transnumber+1 .\n\t    \"- does not exist. Reverting to the 1st transcript\\n\");\n\t    $refseq=$transcripts[0];\n\t}\n    } else {\n\t$refseq=$transcripts[0]->{'seq'};\n    }\n    #\n    # Recording the state: SeqDiff object creation  ?? transcript no.??\n    #\n    my $seqDiff = Bio::Variation::SeqDiff->new(-verbose => $self->verbose);\n    $seqDiff->alphabet($self->gene->get_DNA->alphabet);\n    $seqDiff->numbering($self->numbering);\n    my ($DNAobj, $RNAobj);\n    if ($refseq->isa(\"Bio::LiveSeq::Transcript\")) {\n\t$self->RNA($refseq);\n\t$self->DNA($refseq->{'seq'});\n\t$seqDiff->rna_ori($refseq->seq );\n\t$seqDiff->aa_ori($refseq->get_Translation->seq);\n    } else {\n\t$self->DNA($refseq);\n\t$self->RNA($transcripts[0]);\n\t$seqDiff->rna_ori($self->RNA->seq);\n\t$seqDiff->aa_ori($self->RNA->get_Translation->seq);\n    }\n    $seqDiff->dna_ori($self->DNA->seq);\n    # put the accession number into the SeqDiff object ID\n    $seqDiff->id($self->DNA->accession_number);\n\n    # the atg_offset takes in account that DNA object could be a subset of the\n    # whole entry (via the light_weight loader)\n    my $atg_label=$self->RNA->start;\n    my $atg_offset=$self->DNA->position($atg_label)+($self->DNA->start)-1;\n    $seqDiff->offset($atg_offset - 1);\n    $self->DNA->coordinate_start($atg_label);\n\n    my @exons = $self->RNA->all_Exons;\n    $seqDiff->cds_end($exons[$#exons]->end);\n\n    #\n    # Converting mutation positions to labels\n    #\n    $self->warn(\"no mutations\"), return 0 \n\tunless $self->_mutationpos2label($refseq, $seqDiff);\n\n    # need to add more than one rna & aa\n    #foreach $transcript (@transcripts) {\n    #  $seqDiff{\"ori_transcript_${i}_seq\"}=$transcript->seq;\n    #  $seqDiff{\"ori_translation_${i}_seq\"}=$transcript->get_Translation->seq;\n    #}\n\n    # do changes\n    my $k;\n    foreach my $mutation ($self->each_Mutation) {\n\tnext unless $mutation->label > 0;\n\t$self->mutation($mutation);\n\n\t$mutation->issue(++$k);\n\t#\n\t# current position on the transcript\n\t#\n\tif ($self->numbering =~ /coding/) {\n\t    $mutation->transpos($mutation->pos); # transpos given by user\n\t} else {\n\t    #transpos of label / It will be 0 if mutating an intron, negative if upstream of ATG\n\t    $mutation->transpos($self->RNA->position($mutation->label,$atg_label));\n\t}\n\t#\n\t# Calculate adjacent labels based on the position on the current sequence\n\t#\n\t$mutation->prelabel($self->DNA->label(-1, $mutation->label)); # 1 before label\n\tif ($mutation->len == 0) {\n\t    $mutation->postlabel($mutation->label);\n\t    $mutation->lastlabel($mutation->label);\n\t} elsif ($mutation->len == 1) {\n\t    $mutation->lastlabel($mutation->label); # last nucleotide affected\n\t    $mutation->postlabel($self->DNA->label(2,$mutation->lastlabel)); # $len after label\n\t} else {\n\t    $mutation->lastlabel($self->DNA->label($mutation->len,$mutation->label));\n\t    $mutation->postlabel($self->DNA->label(2,$mutation->lastlabel));\n\t}\n\tmy $dnamut = $self->_set_DNAMutation($seqDiff);\n\t#\n\t#\n\t#\n\tif ($self->_rnaAffected) {\n\t    $self->_set_effects($seqDiff, $dnamut);\n\t}\n\telsif ($seqDiff->offset != 0 and $dnamut->region ne 'intron') {\n\t    $self->_untranslated ($seqDiff, $dnamut);\n\t} else {\n\t    #$self->warn(\"Mutation starts outside coding region, RNAChange object not created\");\n\t}\n\n\t#########################################################################\n\t# Mutations are done here!                                              #\n\t$refseq->labelchange($mutation->seq, $mutation->label, $mutation->len); #\n\t#########################################################################\n\n\t$self->_post_mutation ($seqDiff);\n\n\t$self->dnamut(undef);\n\t$self->rnachange(undef);\n\t$self->aachange(undef);\n\t$self->exons(undef);\n    }\n    # record the final state of all three sequences\n    $seqDiff->dna_mut($self->DNA->seq);\n    $seqDiff->rna_mut($self->RNA->seq);\n    if ($refseq->isa(\"Bio::LiveSeq::Transcript\")) {\n\t$seqDiff->aa_mut($refseq->get_Translation->seq);\n    } else {\n\t$seqDiff->aa_mut($self->RNA->get_Translation->seq);\n    }\n\n    #$seqDiff{mut_dna_seq}=$gene->get_DNA->seq;\n    #my $i=1;\n    #foreach $transcript (@transcripts) {\n    #  $seqDiff{\"mut_transcript_${i}_seq\"}=$transcript->seq;\n    #  $seqDiff{\"mut_translation_${i}_seq\"}=$transcript->get_Translation->seq;\n    #}\n    return $seqDiff;\n}\n\n=head2 _mutationpos2label\n\n Title   : _mutationpos2label\n Usage   :\n Function: converts mutation positions into labels\n Example :\n Returns : number of valid mutations\n Args    : LiveSeq sequence object","parameters":[{"label":"$self"},{"label":"$refseq"},{"label":"$SeqDiff"}],"label":"_mutationpos2label($self,$refseq,$SeqDiff)"}},{"line":844,"kind":13,"localvar":"my","name":"$cc","definition":"my","containerName":null},{"kind":13,"line":844,"containerName":null,"name":"@bb"},{"kind":13,"line":845,"name":"$mut","definition":"my","containerName":null,"localvar":"my"},{"line":845,"kind":13,"name":"%self","containerName":null},{"kind":13,"line":855,"containerName":null,"name":"$self"},{"line":855,"kind":12,"name":"numbering","containerName":"main::"},{"containerName":null,"definition":"my","name":"$tmp","localvar":"my","kind":13,"line":856},{"containerName":null,"name":"$mut","line":856,"kind":13},{"containerName":"main::","name":"pos","kind":12,"line":856},{"kind":13,"line":857,"containerName":null,"name":"$tmp"},{"line":857,"kind":13,"containerName":null,"name":"$SeqDiff"},{"line":857,"kind":12,"name":"offset","containerName":"main::"},{"name":"$tmp","containerName":null,"line":858,"kind":13},{"kind":13,"line":858,"name":"$tmp","containerName":null},{"name":"$mut","containerName":null,"line":859,"kind":13},{"containerName":"main::","name":"pos","kind":12,"line":859},{"kind":13,"line":859,"containerName":null,"name":"$tmp"},{"localvar":"my","name":"$label","definition":"my","containerName":null,"line":862,"kind":13},{"name":"$refseq","containerName":null,"line":862,"kind":13},{"kind":12,"line":862,"containerName":"main::","name":"label"},{"line":862,"kind":13,"name":"$mut","containerName":null},{"name":"pos","containerName":"main::","line":862,"kind":12},{"line":863,"kind":13,"name":"$mut","containerName":null},{"containerName":"main::","name":"label","kind":12,"line":863},{"containerName":null,"name":"$label","line":863,"kind":13},{"kind":13,"line":863,"containerName":null,"name":"$count"},{"kind":13,"line":863,"containerName":null,"name":"$label"},{"name":"$count","containerName":null,"line":866,"kind":13},{"definition":"sub","containerName":"main::","signature":{"label":"_set_DNAMutation($self,$seqDiff)","parameters":[{"label":"$self"},{"label":"$seqDiff"}],"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information.\n\n\n\nsub aachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::AAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::AAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'aachange'} = $value;\n      }\n  }\n  unless (exists $self->{'aachange'}) {\n      return;\n  } else {\n      return $self->{'aachange'};\n  }\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $mutobj = $obj->exons;\n         : $mutobj = $obj->exons($objref);\n Function:\n\n           Returns or sets the reference to a current array of Exons.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an array of Bio::LiveSeq::Exon objects or undef\n\nSee L<Bio::LiveSeq::Exon> for more information.\n\n\n\nsub exons {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'exons'} = $value;\n  }\n  unless (exists $self->{'exons'}) {\n      return;\n  } else {\n      return $self->{'exons'};\n  }\n}\n\n=head2 change_gene_with_alignment\n\n Title   : change_gene_with_alignment\n Usage   : $results=$mutate->change_gene_with_alignment($aln);\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes in the alignment. The alignment has\n           to be pairwise and have one sequence named 'QUERY', the\n           other one is assumed to be a part of the sequence from\n           $gene.\n\n           This method offers a shortcut to change_gene and\n           automates the creation of Bio::LiveSeq::Mutation objects.\n           Use it with almost identical sequnces, e.g. to locate a SNP.\n\n Args    : Bio::SimpleAlign object representing a short local alignment\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\nSee L<Bio::LiveSeq::Mutation>, L<Bio::SimpleAlign>, and\nL<Bio::Variation::SeqDiff>  for more information.\n\n\nsub change_gene_with_alignment {\n    my ($self, $aln) = @_;\n\n    #\n    # Sanity checks\n    #\n\n    $self->throw(\"Argument is not a Bio::SimpleAlign object but a [$aln]\")\n\tunless $aln->isa('Bio::SimpleAlign');\n    $self->throw(\"'Pairwise alignments only, please\") \n\tif $aln->no_sequences != 2;\n\n    # find out the order the two sequences are given\n    my $queryseq_pos = 1; #default\n    my $refseq_pos = 2;\n    unless ($aln->get_seq_by_pos(1)->id eq 'QUERY') {\n\tcarp('Query sequence has to be named QUERY') \n\t    if $aln->get_seq_by_pos(2)->id ne 'QUERY';\n\t$queryseq_pos = 2; # alternative\n\t$refseq_pos = 1;\n    }\n\n    # trim the alignment\n    my $start =  $aln->column_from_residue_number('QUERY', 1);\n    my $end =  $aln->column_from_residue_number('QUERY', \n\t\t\t\t\t\t$aln->get_seq_by_pos($queryseq_pos)->end );\n    \n    my $aln2 = $aln->slice($start, $end);\n\n    #\n    # extracting mutations\n    #\n\n    my $cs = $aln2->consensus_string(51);\n    my $queryseq = $aln2->get_seq_by_pos($queryseq_pos);\n    my $refseq = $aln2->get_seq_by_pos($refseq_pos);\n\n    while ( $cs =~ /(\\?+)/g) {\n\t# pos in local coordinates\n\tmy $pos = pos($cs) - length($1) + 1;\n\tmy $mutation = create_mutation($self, \n\t\t\t\t       $refseq, \n\t\t\t\t       $queryseq, \n\t\t\t\t       $pos, \n\t\t\t\t       CORE::length($1)\n\t\t\t\t       );\n\t# reset pos to refseq coordinates\n\t$pos +=  $refseq->start - 1;\n\t$mutation->pos($pos);\n\n        $self->add_Mutation($mutation);\n    }\n    return $self->change_gene();\n}\n\n=head2 create_mutation\n\n Title   : create_mutation\n Usage   : \n Function:\n\n           Formats sequence differences from two sequences into\n           Bio::LiveSeq::Mutation objects which can be applied to a\n           gene.\n\n           To keep it generic, sequence arguments need not to be\n           Bio::LocatableSeq. Coordinate change to parent sequence\n           numbering needs to be done by the calling code.\n\n           Called from change_gene_with_alignment\n\n Args    : Bio::PrimarySeqI inheriting object for the reference sequence\n           Bio::PrimarySeqI inheriting object for the query sequence\n           integer for the start position of the local sequence difference\n           integer for the length of the sequence difference\n Returns : Bio::LiveSeq::Mutation object \n\n\nsub create_mutation {\n    my ($self, $refseq, $queryseq, $pos, $len) = @_;\n    \n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$refseq]\") \n\tunless $refseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$queryseq]\") \n\tunless $queryseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Position is not a positive integer but [$pos]\") \n\tunless $pos =~ /^\\+?\\d+$/;\n    $self->throw(\"Length is not a positive integer but [$len]\") \n\tunless $len =~ /^\\+?\\d+$/;\n\n    my $mutation;\n    my $refstring = $refseq->subseq($pos, $pos + $len - 1);\n    my $varstring = $queryseq->subseq($pos, $pos + $len - 1);\n    \n    if ($len == 1 and $refstring =~ /[^\\.\\-\\*\\?]/ and \n\t$varstring  =~ /[^\\.\\-\\*\\?]/ ) { #point\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring =~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  !~ /^[^\\.\\-\\*\\?]+$/ ) { # deletion\n\t$mutation = Bio::LiveSeq::Mutation->new(-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring !~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  =~ /^[^\\.\\-\\*\\?]+$/ ) { # insertion\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => 0\n\t\t\t\t\t\t);\n    } else { # complex\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    \n    return $mutation;\n}\n\n=head2 change_gene\n\n Title   : change_gene\n Usage   : my $mutate = Bio::LiveSeq::Mutator->new(-gene => $gene,\n\t\t\t\t\t\t   numbering => \"coding\"\n\t\t\t\t\t\t   );\n           # $mut is Bio::LiveSeq::Mutation object\n           $mutate->add_Mutation($mut);\n           my $results=$mutate->change_gene();\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes performed according to the\n           instructions present in Mutation(s).  The -numbering\n           argument decides what molecule is being changed and what\n           numbering scheme being used:\n\n            -numbering => \"entry\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the sequence\n\n            -numbering => \"coding\"\n\n               determines the RNA level, using the numbering from the\n               beginning of the 1st transcript\n\n               Alternative transcripts can be used by specifying\n               \"coding 2\" or \"coding 3\" ...\n\n            -numbering => \"gene\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the 1st transcript and inluding introns.\n               The meaning equals 'coding' if the reference molecule\n               is cDNA.\n\n Args    : Bio::LiveSeq::Gene object\n           Bio::LiveSeq::Mutation object(s)\n           string specifying a numbering scheme (defaults to 'coding')\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\n\nsub change_gene {\n    my ($self) = @_;\n\n    #\n    # Sanity check\n    #\n    unless ($self->gene) {\n\t$self->warn(\"Input object Bio::LiveSeq::Gene is not given\");\n\treturn 0;\n    }\n    #\n    # Setting the reference sequence based on -numbering\n    #\n    my @transcripts=@{$self->gene->get_Transcripts};\n    my $refseq; # will hold Bio::LiveSeq:Transcript object or Bio::LiveSeq::DNA\n\n    # 'gene' eq 'coding' if reference sequence is cDNA\n    $self->numbering ('coding') if $self->gene->get_DNA->alphabet eq 'rna' and $self->numbering eq 'gene';\n\n    if ($self->numbering =~ /(coding)( )?(\\d+)?/ ) {\n\t$self->numbering($1);\n\tmy $transnumber = $3;\n\t$transnumber-- if $3; # 1 -> 0, 2 -> 1\n\tif ($transnumber && $transnumber >= 0 && $transnumber <= $#transcripts) {\n\t    $refseq=$transcripts[$transnumber];\n\t} else {\n\t    $transnumber && $self->warn(\"The alternative transcript number \". $transnumber+1 .\n\t    \"- does not exist. Reverting to the 1st transcript\\n\");\n\t    $refseq=$transcripts[0];\n\t}\n    } else {\n\t$refseq=$transcripts[0]->{'seq'};\n    }\n    #\n    # Recording the state: SeqDiff object creation  ?? transcript no.??\n    #\n    my $seqDiff = Bio::Variation::SeqDiff->new(-verbose => $self->verbose);\n    $seqDiff->alphabet($self->gene->get_DNA->alphabet);\n    $seqDiff->numbering($self->numbering);\n    my ($DNAobj, $RNAobj);\n    if ($refseq->isa(\"Bio::LiveSeq::Transcript\")) {\n\t$self->RNA($refseq);\n\t$self->DNA($refseq->{'seq'});\n\t$seqDiff->rna_ori($refseq->seq );\n\t$seqDiff->aa_ori($refseq->get_Translation->seq);\n    } else {\n\t$self->DNA($refseq);\n\t$self->RNA($transcripts[0]);\n\t$seqDiff->rna_ori($self->RNA->seq);\n\t$seqDiff->aa_ori($self->RNA->get_Translation->seq);\n    }\n    $seqDiff->dna_ori($self->DNA->seq);\n    # put the accession number into the SeqDiff object ID\n    $seqDiff->id($self->DNA->accession_number);\n\n    # the atg_offset takes in account that DNA object could be a subset of the\n    # whole entry (via the light_weight loader)\n    my $atg_label=$self->RNA->start;\n    my $atg_offset=$self->DNA->position($atg_label)+($self->DNA->start)-1;\n    $seqDiff->offset($atg_offset - 1);\n    $self->DNA->coordinate_start($atg_label);\n\n    my @exons = $self->RNA->all_Exons;\n    $seqDiff->cds_end($exons[$#exons]->end);\n\n    #\n    # Converting mutation positions to labels\n    #\n    $self->warn(\"no mutations\"), return 0 \n\tunless $self->_mutationpos2label($refseq, $seqDiff);\n\n    # need to add more than one rna & aa\n    #foreach $transcript (@transcripts) {\n    #  $seqDiff{\"ori_transcript_${i}_seq\"}=$transcript->seq;\n    #  $seqDiff{\"ori_translation_${i}_seq\"}=$transcript->get_Translation->seq;\n    #}\n\n    # do changes\n    my $k;\n    foreach my $mutation ($self->each_Mutation) {\n\tnext unless $mutation->label > 0;\n\t$self->mutation($mutation);\n\n\t$mutation->issue(++$k);\n\t#\n\t# current position on the transcript\n\t#\n\tif ($self->numbering =~ /coding/) {\n\t    $mutation->transpos($mutation->pos); # transpos given by user\n\t} else {\n\t    #transpos of label / It will be 0 if mutating an intron, negative if upstream of ATG\n\t    $mutation->transpos($self->RNA->position($mutation->label,$atg_label));\n\t}\n\t#\n\t# Calculate adjacent labels based on the position on the current sequence\n\t#\n\t$mutation->prelabel($self->DNA->label(-1, $mutation->label)); # 1 before label\n\tif ($mutation->len == 0) {\n\t    $mutation->postlabel($mutation->label);\n\t    $mutation->lastlabel($mutation->label);\n\t} elsif ($mutation->len == 1) {\n\t    $mutation->lastlabel($mutation->label); # last nucleotide affected\n\t    $mutation->postlabel($self->DNA->label(2,$mutation->lastlabel)); # $len after label\n\t} else {\n\t    $mutation->lastlabel($self->DNA->label($mutation->len,$mutation->label));\n\t    $mutation->postlabel($self->DNA->label(2,$mutation->lastlabel));\n\t}\n\tmy $dnamut = $self->_set_DNAMutation($seqDiff);\n\t#\n\t#\n\t#\n\tif ($self->_rnaAffected) {\n\t    $self->_set_effects($seqDiff, $dnamut);\n\t}\n\telsif ($seqDiff->offset != 0 and $dnamut->region ne 'intron') {\n\t    $self->_untranslated ($seqDiff, $dnamut);\n\t} else {\n\t    #$self->warn(\"Mutation starts outside coding region, RNAChange object not created\");\n\t}\n\n\t#########################################################################\n\t# Mutations are done here!                                              #\n\t$refseq->labelchange($mutation->seq, $mutation->label, $mutation->len); #\n\t#########################################################################\n\n\t$self->_post_mutation ($seqDiff);\n\n\t$self->dnamut(undef);\n\t$self->rnachange(undef);\n\t$self->aachange(undef);\n\t$self->exons(undef);\n    }\n    # record the final state of all three sequences\n    $seqDiff->dna_mut($self->DNA->seq);\n    $seqDiff->rna_mut($self->RNA->seq);\n    if ($refseq->isa(\"Bio::LiveSeq::Transcript\")) {\n\t$seqDiff->aa_mut($refseq->get_Translation->seq);\n    } else {\n\t$seqDiff->aa_mut($self->RNA->get_Translation->seq);\n    }\n\n    #$seqDiff{mut_dna_seq}=$gene->get_DNA->seq;\n    #my $i=1;\n    #foreach $transcript (@transcripts) {\n    #  $seqDiff{\"mut_transcript_${i}_seq\"}=$transcript->seq;\n    #  $seqDiff{\"mut_translation_${i}_seq\"}=$transcript->get_Translation->seq;\n    #}\n    return $seqDiff;\n}\n\n=head2 _mutationpos2label\n\n Title   : _mutationpos2label\n Usage   :\n Function: converts mutation positions into labels\n Example :\n Returns : number of valid mutations\n Args    : LiveSeq sequence object\n\n\nsub _mutationpos2label {\n    my ($self, $refseq, $SeqDiff) = @_;\n    my $count;\n    my @bb = @{$self->{'mutations'}};\n    my $cc = scalar @bb;\n    foreach my $mut (@{$self->{'mutations'}}) {\n#\t if ($self->numbering eq 'gene' and $mut->pos < 1) {\n#\t     my $tmp = $mut->pos;\n#\t     print STDERR \"pos: \", \"$tmp\\n\";\n#\t     $tmp++ if $tmp < 1;\n#\t     $tmp += $SeqDiff->offset;\n#\t     print STDERR \"pos2: \", \"$tmp\\n\";\n#\t     $mut->pos($tmp);\n#\t }\n#\telsif ($self->numbering eq 'entry') {\n\tif ($self->numbering eq 'entry') {\n\t    my $tmp = $mut->pos;\n\t    $tmp -= $SeqDiff->offset;\n\t    $tmp-- if $tmp < 1;\n\t    $mut->pos($tmp);\n\t}\n\n\tmy $label = $refseq->label($mut->pos); # get the label for the position\n\t$mut->label($label), $count++ if $label > 0 ;\n\t#print STDERR \"x\", $mut->pos,'|' ,$mut->label, \"\\n\";\n    }\n    return $count;\n}\n\n#\n# Calculate labels around mutated nucleotide\n#\n\n=head2 _set_DNAMutation\n\n Title   : _set_DNAMutation\n Usage   :\n Function:\n\n           Stores DNA level mutation attributes before mutation into\n           Bio::Variation::DNAMutation object.  Links it to SeqDiff\n           object.\n\n Example :\n Returns : Bio::Variation::DNAMutation object\n Args    : Bio::Variation::SeqDiff object\n\nSee L<Bio::Variation::DNAMutation> and L<Bio::Variation::SeqDiff>."},"detail":"($self,$seqDiff)","kind":12,"children":[{"line":892,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_set_DNAMutation"},{"kind":13,"line":892,"containerName":"_set_DNAMutation","name":"$seqDiff"},{"containerName":"_set_DNAMutation","definition":"my","name":"$dnamut_start","localvar":"my","kind":13,"line":894},{"name":"$self","containerName":"_set_DNAMutation","line":894,"kind":13},{"line":894,"kind":12,"name":"mutation","containerName":"_set_DNAMutation"},{"kind":12,"line":894,"name":"label","containerName":"_set_DNAMutation"},{"containerName":"_set_DNAMutation","name":"$seqDiff","line":894,"kind":13},{"containerName":"_set_DNAMutation","name":"offset","kind":12,"line":894},{"name":"$dnamut_start","containerName":"_set_DNAMutation","line":896,"kind":13},{"containerName":"_set_DNAMutation","name":"$dnamut_start","kind":13,"line":896},{"containerName":"_set_DNAMutation","definition":"my","name":"$dnamut_end","localvar":"my","kind":13,"line":897},{"kind":13,"line":898,"containerName":"_set_DNAMutation","name":"$self"},{"kind":12,"line":898,"name":"mutation","containerName":"_set_DNAMutation"},{"kind":12,"line":898,"name":"len","containerName":"_set_DNAMutation"},{"kind":13,"line":898,"name":"$self","containerName":"_set_DNAMutation"},{"kind":12,"line":898,"containerName":"_set_DNAMutation","name":"mutation"},{"name":"len","containerName":"_set_DNAMutation","line":898,"kind":12},{"line":899,"kind":13,"name":"$dnamut_end","containerName":"_set_DNAMutation"},{"kind":13,"line":899,"name":"$dnamut_start","containerName":"_set_DNAMutation"},{"kind":13,"line":900,"name":"$dnamut_end","containerName":"_set_DNAMutation"},{"containerName":"_set_DNAMutation","name":"$dnamut_start","kind":13,"line":900},{"kind":13,"line":900,"containerName":"_set_DNAMutation","name":"$self"},{"name":"mutation","containerName":"_set_DNAMutation","line":900,"kind":12},{"name":"len","containerName":"_set_DNAMutation","line":900,"kind":12},{"line":902,"kind":13,"localvar":"my","containerName":"_set_DNAMutation","name":"$dnamut","definition":"my"},{"containerName":"_set_DNAMutation","name":"new","kind":12,"line":902},{"kind":13,"line":902,"name":"$dnamut_start","containerName":"_set_DNAMutation"},{"name":"$dnamut_end","containerName":"_set_DNAMutation","kind":13,"line":903},{"containerName":"_set_DNAMutation","name":"$dnamut","line":905,"kind":13},{"line":905,"kind":12,"containerName":"_set_DNAMutation","name":"mut_number"},{"name":"$self","containerName":"_set_DNAMutation","kind":13,"line":905},{"line":905,"kind":12,"name":"mutation","containerName":"_set_DNAMutation"},{"kind":12,"line":905,"name":"issue","containerName":"_set_DNAMutation"},{"kind":13,"line":906,"name":"$dnamut","containerName":"_set_DNAMutation"},{"name":"isMutation","containerName":"_set_DNAMutation","kind":12,"line":906},{"line":907,"kind":13,"localvar":"my","definition":"my","name":"$da_m","containerName":"_set_DNAMutation"},{"containerName":"_set_DNAMutation","name":"new","kind":12,"line":907},{"kind":13,"line":908,"containerName":"_set_DNAMutation","name":"$da_m"},{"containerName":"_set_DNAMutation","name":"seq","line":908,"kind":12},{"containerName":"_set_DNAMutation","name":"$self","kind":13,"line":908},{"kind":12,"line":908,"name":"mutation","containerName":"_set_DNAMutation"},{"line":908,"kind":12,"name":"seq","containerName":"_set_DNAMutation"},{"name":"$self","containerName":"_set_DNAMutation","kind":13,"line":908},{"name":"mutation","containerName":"_set_DNAMutation","kind":12,"line":908},{"line":908,"kind":12,"containerName":"_set_DNAMutation","name":"seq"},{"containerName":"_set_DNAMutation","name":"$dnamut","kind":13,"line":909},{"line":909,"kind":12,"containerName":"_set_DNAMutation","name":"allele_mut"},{"line":909,"kind":13,"containerName":"_set_DNAMutation","name":"$da_m"},{"containerName":"_set_DNAMutation","name":"$dnamut","line":910,"kind":13},{"name":"add_Allele","containerName":"_set_DNAMutation","kind":12,"line":910},{"line":910,"kind":13,"containerName":"_set_DNAMutation","name":"$da_m"},{"kind":13,"line":912,"definition":"my","name":"$allele_ori","containerName":"_set_DNAMutation","localvar":"my"},{"line":912,"kind":13,"name":"$self","containerName":"_set_DNAMutation"},{"line":912,"kind":12,"containerName":"_set_DNAMutation","name":"DNA"},{"name":"labelsubseq","containerName":"_set_DNAMutation","kind":12,"line":912},{"containerName":"_set_DNAMutation","name":"$self","kind":13,"line":912},{"kind":12,"line":912,"name":"mutation","containerName":"_set_DNAMutation"},{"name":"prelabel","containerName":"_set_DNAMutation","line":912,"kind":12},{"kind":13,"line":914,"containerName":"_set_DNAMutation","name":"$self"},{"kind":12,"line":914,"name":"mutation","containerName":"_set_DNAMutation"},{"kind":12,"line":914,"name":"postlabel","containerName":"_set_DNAMutation"},{"name":"$allele_ori","containerName":"_set_DNAMutation","line":915,"kind":13},{"containerName":"_set_DNAMutation","name":"$allele_ori","line":916,"kind":13},{"kind":13,"line":916,"name":"$allele_ori","containerName":"_set_DNAMutation"},{"definition":"my","name":"$da_o","containerName":"_set_DNAMutation","localvar":"my","kind":13,"line":917},{"line":917,"kind":12,"name":"new","containerName":"_set_DNAMutation"},{"name":"$da_o","containerName":"_set_DNAMutation","kind":13,"line":918},{"name":"seq","containerName":"_set_DNAMutation","line":918,"kind":12},{"containerName":"_set_DNAMutation","name":"$allele_ori","line":918,"kind":13},{"line":918,"kind":13,"name":"$allele_ori","containerName":"_set_DNAMutation"},{"line":919,"kind":13,"containerName":"_set_DNAMutation","name":"$dnamut"},{"name":"allele_ori","containerName":"_set_DNAMutation","line":919,"kind":12},{"name":"$da_o","containerName":"_set_DNAMutation","line":919,"kind":13},{"kind":13,"line":920,"containerName":"_set_DNAMutation","name":"$self"},{"kind":12,"line":920,"name":"mutation","containerName":"_set_DNAMutation"},{"name":"len","containerName":"_set_DNAMutation","line":920,"kind":12},{"containerName":"_set_DNAMutation","name":"$dnamut","line":921,"kind":13},{"kind":12,"line":921,"name":"length","containerName":"_set_DNAMutation"},{"name":"$self","containerName":"_set_DNAMutation","line":921,"kind":13},{"name":"mutation","containerName":"_set_DNAMutation","line":921,"kind":12},{"line":921,"kind":12,"name":"len","containerName":"_set_DNAMutation"},{"name":"$dnamut","containerName":"_set_DNAMutation","kind":13,"line":921},{"kind":12,"line":921,"containerName":"_set_DNAMutation","name":"length"},{"line":921,"kind":13,"containerName":"_set_DNAMutation","name":"$allele_ori"},{"name":"$seqDiff","containerName":"_set_DNAMutation","kind":13,"line":923},{"kind":12,"line":923,"containerName":"_set_DNAMutation","name":"add_Variant"},{"line":923,"kind":13,"containerName":"_set_DNAMutation","name":"$dnamut"},{"containerName":"_set_DNAMutation","name":"$self","kind":13,"line":924},{"line":924,"kind":12,"name":"dnamut","containerName":"_set_DNAMutation"},{"containerName":"_set_DNAMutation","name":"$dnamut","line":924,"kind":13},{"containerName":"_set_DNAMutation","name":"$dnamut","kind":13,"line":925},{"line":925,"kind":12,"containerName":"_set_DNAMutation","name":"mut_number"},{"containerName":"_set_DNAMutation","name":"$self","kind":13,"line":925},{"kind":12,"line":925,"name":"mutation","containerName":"_set_DNAMutation"},{"kind":12,"line":925,"name":"issue","containerName":"_set_DNAMutation"},{"name":"$seqDiff","containerName":"_set_DNAMutation","kind":13,"line":927},{"line":927,"kind":12,"name":"numbering","containerName":"_set_DNAMutation"},{"line":927,"kind":13,"containerName":"_set_DNAMutation","name":"$seqDiff"},{"line":927,"kind":12,"name":"numbering","containerName":"_set_DNAMutation"},{"line":928,"kind":13,"name":"$dnamut","containerName":"_set_DNAMutation"},{"kind":12,"line":928,"name":"proof","containerName":"_set_DNAMutation"},{"name":"$dnamut","containerName":"_set_DNAMutation","line":930,"kind":13},{"containerName":"_set_DNAMutation","name":"proof","line":930,"kind":12},{"line":933,"kind":13,"localvar":"my","containerName":"_set_DNAMutation","definition":"my","name":"$flanklen"},{"kind":13,"line":933,"name":"$self","containerName":"_set_DNAMutation"},{"name":"$uplabel","definition":"my","containerName":"_set_DNAMutation","localvar":"my","kind":13,"line":935},{"kind":13,"line":935,"containerName":"_set_DNAMutation","name":"$self"},{"kind":12,"line":935,"containerName":"_set_DNAMutation","name":"DNA"},{"name":"label","containerName":"_set_DNAMutation","kind":12,"line":935},{"containerName":"_set_DNAMutation","name":"$flanklen","line":935,"kind":13},{"name":"$self","containerName":"_set_DNAMutation","kind":13,"line":935},{"containerName":"_set_DNAMutation","name":"mutation","line":935,"kind":12},{"kind":12,"line":935,"name":"prelabel","containerName":"_set_DNAMutation"},{"localvar":"my","name":"$upstreamseq","definition":"my","containerName":"_set_DNAMutation","line":937,"kind":13},{"name":"$uplabel","containerName":"_set_DNAMutation","kind":13,"line":938},{"containerName":"_set_DNAMutation","name":"$upstreamseq","kind":13,"line":939},{"name":"$self","containerName":"_set_DNAMutation","kind":13,"line":940},{"kind":12,"line":940,"name":"DNA","containerName":"_set_DNAMutation"},{"line":940,"kind":12,"name":"labelsubseq","containerName":"_set_DNAMutation"},{"kind":13,"line":940,"name":"$uplabel","containerName":"_set_DNAMutation"},{"name":"$self","containerName":"_set_DNAMutation","line":940,"kind":13},{"kind":12,"line":940,"name":"mutation","containerName":"_set_DNAMutation"},{"line":940,"kind":12,"containerName":"_set_DNAMutation","name":"prelabel"},{"kind":13,"line":942,"containerName":"_set_DNAMutation","name":"$upstreamseq"},{"line":943,"kind":13,"name":"$self","containerName":"_set_DNAMutation"},{"containerName":"_set_DNAMutation","name":"DNA","line":943,"kind":12},{"containerName":"_set_DNAMutation","name":"labelsubseq","kind":12,"line":943},{"kind":13,"line":943,"containerName":"_set_DNAMutation","name":"$self"},{"line":943,"kind":12,"name":"DNA","containerName":"_set_DNAMutation"},{"line":943,"kind":12,"name":"start","containerName":"_set_DNAMutation"},{"containerName":"_set_DNAMutation","name":"$self","kind":13,"line":943},{"name":"mutation","containerName":"_set_DNAMutation","line":943,"kind":12},{"line":943,"kind":12,"containerName":"_set_DNAMutation","name":"prelabel"},{"containerName":"_set_DNAMutation","name":"$dnamut","line":945,"kind":13},{"kind":12,"line":945,"containerName":"_set_DNAMutation","name":"upStreamSeq"},{"line":945,"kind":13,"containerName":"_set_DNAMutation","name":"$upstreamseq"},{"name":"$dnstreamseq","definition":"my","containerName":"_set_DNAMutation","localvar":"my","kind":13,"line":946},{"line":946,"kind":13,"containerName":"_set_DNAMutation","name":"$self"},{"containerName":"_set_DNAMutation","name":"DNA","kind":12,"line":946},{"line":946,"kind":12,"name":"labelsubseq","containerName":"_set_DNAMutation"},{"containerName":"_set_DNAMutation","name":"$self","line":946,"kind":13},{"containerName":"_set_DNAMutation","name":"mutation","line":946,"kind":12},{"name":"postlabel","containerName":"_set_DNAMutation","kind":12,"line":946},{"line":946,"kind":13,"name":"$flanklen","containerName":"_set_DNAMutation"},{"line":947,"kind":13,"containerName":"_set_DNAMutation","name":"$dnamut"},{"line":947,"kind":12,"name":"dnStreamSeq","containerName":"_set_DNAMutation"},{"name":"$dnstreamseq","containerName":"_set_DNAMutation","line":947,"kind":13},{"kind":13,"line":948,"containerName":"_set_DNAMutation","name":"$dnamut"}],"line":891,"name":"_set_DNAMutation","range":{"end":{"line":949,"character":9999},"start":{"line":891,"character":0}}},{"containerName":"Variation::DNAMutation","name":"Bio","line":902,"kind":12},{"containerName":"Variation::Allele","name":"Bio","line":907,"kind":12},{"kind":12,"line":917,"containerName":"Variation::Allele","name":"Bio"},{"kind":12,"line":921,"name":"CORE","containerName":"length"},{"name":"_rnaAffected","range":{"start":{"character":0,"line":959},"end":{"character":9999,"line":1119}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"## Check if mutation propagates to RNA (and AA) level\n side effect: sets intron/exon information\n returns a boolean value","label":"_rnaAffected($self)"},"detail":"($self)","kind":12,"children":[{"kind":13,"line":960,"name":"$self","definition":"my","containerName":"_rnaAffected","localvar":"my"},{"kind":13,"line":961,"definition":"my","name":"@exons","containerName":"_rnaAffected","localvar":"my"},{"line":961,"kind":13,"name":"$self","containerName":"_rnaAffected"},{"line":961,"kind":12,"name":"RNA","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"all_Exons","kind":12,"line":961},{"containerName":"_rnaAffected","definition":"my","name":"$RNAstart","localvar":"my","kind":13,"line":962},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":962},{"name":"RNA","containerName":"_rnaAffected","kind":12,"line":962},{"line":962,"kind":12,"containerName":"_rnaAffected","name":"start"},{"line":963,"kind":13,"localvar":"my","containerName":"_rnaAffected","definition":"my","name":"$RNAend"},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":963},{"line":963,"kind":12,"name":"RNA","containerName":"_rnaAffected"},{"name":"end","containerName":"_rnaAffected","line":963,"kind":12},{"localvar":"my","containerName":"_rnaAffected","name":"$firstexon","definition":"my","line":964,"kind":13},{"line":964,"kind":13,"name":"$before","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"$after","line":964,"kind":13},{"line":964,"kind":13,"name":"$i","containerName":"_rnaAffected"},{"name":"$rnaAffected","definition":"my","containerName":"_rnaAffected","localvar":"my","kind":13,"line":965},{"localvar":"my","definition":"my","name":"$DNAend","containerName":"_rnaAffected","line":968,"kind":13},{"kind":13,"line":968,"containerName":"_rnaAffected","name":"$self"},{"kind":12,"line":968,"name":"RNA","containerName":"_rnaAffected"},{"kind":12,"line":968,"containerName":"_rnaAffected","name":"end"},{"kind":13,"line":969,"name":"$self","containerName":"_rnaAffected"},{"kind":12,"line":969,"containerName":"_rnaAffected","name":"mutation"},{"line":969,"kind":12,"containerName":"_rnaAffected","name":"prelabel"},{"line":969,"kind":13,"containerName":"_rnaAffected","name":"$DNAend"},{"line":969,"kind":13,"containerName":"_rnaAffected","name":"$self"},{"containerName":"_rnaAffected","name":"mutation","kind":12,"line":969},{"line":969,"kind":12,"name":"postlabel","containerName":"_rnaAffected"},{"name":"$DNAend","containerName":"_rnaAffected","line":969,"kind":13},{"kind":13,"line":973,"containerName":"_rnaAffected","name":"$self"},{"kind":12,"line":973,"containerName":"_rnaAffected","name":"warn"},{"containerName":"_rnaAffected","name":"$self","kind":13,"line":974},{"name":"mutation","containerName":"_rnaAffected","kind":12,"line":974},{"name":"postlabel","containerName":"_rnaAffected","kind":12,"line":974},{"name":"$RNAstart","containerName":"_rnaAffected","line":974,"kind":13},{"line":974,"kind":13,"name":"$self","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"mutation","line":974,"kind":12},{"name":"postlabel","containerName":"_rnaAffected","line":974,"kind":12},{"kind":13,"line":974,"containerName":"_rnaAffected","name":"$RNAstart"},{"name":"$self","containerName":"_rnaAffected","line":975,"kind":13},{"name":"warn","containerName":"_rnaAffected","line":975,"kind":12},{"kind":13,"line":977,"containerName":"_rnaAffected","name":"$RNAend"},{"line":977,"kind":13,"containerName":"_rnaAffected","name":"$self"},{"name":"mutation","containerName":"_rnaAffected","kind":12,"line":977},{"name":"prelabel","containerName":"_rnaAffected","kind":12,"line":977},{"kind":13,"line":977,"name":"$RNAend","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"$self","line":977,"kind":13},{"line":977,"kind":12,"name":"mutation","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"prelabel","kind":12,"line":977},{"line":978,"kind":13,"name":"$self","containerName":"_rnaAffected"},{"name":"warn","containerName":"_rnaAffected","kind":12,"line":978},{"containerName":"_rnaAffected","name":"@exons","kind":13,"line":980},{"name":"$rnaAffected","containerName":"_rnaAffected","line":982,"kind":13},{"kind":13,"line":985,"containerName":"_rnaAffected","name":"$firstexon"},{"line":985,"kind":13,"containerName":"_rnaAffected","name":"@exons"},{"containerName":"_rnaAffected","name":"$before","line":986,"kind":13},{"containerName":"_rnaAffected","name":"$firstexon","line":986,"kind":13},{"line":986,"kind":12,"containerName":"_rnaAffected","name":"end"},{"containerName":"_rnaAffected","name":"$i","kind":13,"line":988},{"name":"$after","containerName":"_rnaAffected","kind":13,"line":989},{"line":989,"kind":13,"containerName":"_rnaAffected","name":"$exons"},{"kind":13,"line":989,"containerName":"_rnaAffected","name":"$i"},{"name":"start","containerName":"_rnaAffected","kind":12,"line":989},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":990},{"kind":12,"line":990,"containerName":"_rnaAffected","name":"mutation"},{"name":"prelabel","containerName":"_rnaAffected","kind":12,"line":990},{"line":990,"kind":13,"name":"$before","containerName":"_rnaAffected"},{"name":"$after","containerName":"_rnaAffected","line":991,"kind":13},{"kind":13,"line":991,"name":"$self","containerName":"_rnaAffected"},{"name":"mutation","containerName":"_rnaAffected","kind":12,"line":991},{"line":991,"kind":12,"name":"prelabel","containerName":"_rnaAffected"},{"kind":13,"line":992,"name":"$after","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"$self","kind":13,"line":992},{"line":992,"kind":12,"containerName":"_rnaAffected","name":"mutation"},{"kind":12,"line":992,"name":"prelabel","containerName":"_rnaAffected"},{"name":"$after","containerName":"_rnaAffected","line":993,"kind":13},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":993},{"name":"mutation","containerName":"_rnaAffected","kind":12,"line":993},{"containerName":"_rnaAffected","name":"postlabel","line":993,"kind":12},{"name":"$rnaAffected","containerName":"_rnaAffected","line":995,"kind":13},{"kind":13,"line":998,"name":"$before","containerName":"_rnaAffected"},{"kind":13,"line":998,"containerName":"_rnaAffected","name":"$exons"},{"containerName":"_rnaAffected","name":"$i","kind":13,"line":998},{"line":998,"kind":12,"containerName":"_rnaAffected","name":"end"},{"localvar":"my","containerName":"_rnaAffected","name":"$strand","definition":"my","line":1003,"kind":13},{"kind":13,"line":1003,"name":"$exons","containerName":"_rnaAffected"},{"line":1003,"kind":12,"containerName":"_rnaAffected","name":"strand"},{"name":"$strand","containerName":"_rnaAffected","kind":13,"line":1004},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":1004},{"kind":12,"line":1004,"containerName":"_rnaAffected","name":"mutation"},{"kind":12,"line":1004,"containerName":"_rnaAffected","name":"postlabel"},{"containerName":"_rnaAffected","name":"$RNAstart","line":1004,"kind":13},{"kind":13,"line":1005,"name":"$strand","containerName":"_rnaAffected"},{"line":1005,"kind":13,"containerName":"_rnaAffected","name":"$self"},{"containerName":"_rnaAffected","name":"mutation","line":1005,"kind":12},{"containerName":"_rnaAffected","name":"postlabel","kind":12,"line":1005},{"name":"$RNAstart","containerName":"_rnaAffected","kind":13,"line":1005},{"line":1007,"kind":13,"name":"$rnaAffected","containerName":"_rnaAffected"},{"kind":13,"line":1009,"name":"$strand","containerName":"_rnaAffected"},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":1009},{"containerName":"_rnaAffected","name":"mutation","line":1009,"kind":12},{"kind":12,"line":1009,"containerName":"_rnaAffected","name":"prelabel"},{"name":"$RNAend","containerName":"_rnaAffected","kind":13,"line":1009},{"kind":13,"line":1010,"containerName":"_rnaAffected","name":"$strand"},{"line":1010,"kind":13,"name":"$self","containerName":"_rnaAffected"},{"line":1010,"kind":12,"containerName":"_rnaAffected","name":"mutation"},{"containerName":"_rnaAffected","name":"prelabel","kind":12,"line":1010},{"name":"$RNAend","containerName":"_rnaAffected","line":1010,"kind":13},{"line":1012,"kind":13,"name":"$rnaAffected","containerName":"_rnaAffected"},{"kind":13,"line":1013,"containerName":"_rnaAffected","definition":"my","name":"$dist","localvar":"my"},{"containerName":"_rnaAffected","name":"$strand","line":1014,"kind":13},{"name":"$dist","containerName":"_rnaAffected","kind":13,"line":1015},{"line":1015,"kind":13,"name":"$self","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"mutation","kind":12,"line":1015},{"containerName":"_rnaAffected","name":"prelabel","kind":12,"line":1015},{"line":1015,"kind":13,"containerName":"_rnaAffected","name":"$RNAend"},{"containerName":"_rnaAffected","name":"$dist","line":1017,"kind":13},{"name":"$RNAend","containerName":"_rnaAffected","line":1017,"kind":13},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":1017},{"kind":12,"line":1017,"containerName":"_rnaAffected","name":"mutation"},{"name":"prelabel","containerName":"_rnaAffected","kind":12,"line":1017},{"containerName":"_rnaAffected","name":"$self","line":1019,"kind":13},{"containerName":"_rnaAffected","name":"dnamut","kind":12,"line":1019},{"containerName":"_rnaAffected","name":"region_dist","kind":12,"line":1019},{"containerName":"_rnaAffected","name":"$dist","line":1019,"kind":13},{"containerName":"_rnaAffected","name":"@exons","kind":13,"line":1021},{"name":"$rnaAffected","containerName":"_rnaAffected","kind":13,"line":1023},{"kind":13,"line":1026,"containerName":"_rnaAffected","name":"$firstexon"},{"line":1026,"kind":13,"name":"@exons","containerName":"_rnaAffected"},{"line":1027,"kind":13,"containerName":"_rnaAffected","name":"$before"},{"name":"$firstexon","containerName":"_rnaAffected","kind":13,"line":1027},{"containerName":"_rnaAffected","name":"end","line":1027,"kind":12},{"kind":13,"line":1028,"containerName":"_rnaAffected","name":"$strand"},{"containerName":"_rnaAffected","name":"$self","line":1028,"kind":13},{"kind":12,"line":1028,"containerName":"_rnaAffected","name":"mutation"},{"line":1028,"kind":12,"containerName":"_rnaAffected","name":"prelabel"},{"kind":13,"line":1028,"containerName":"_rnaAffected","name":"$before"},{"kind":13,"line":1029,"name":"$strand","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"$self","line":1029,"kind":13},{"name":"mutation","containerName":"_rnaAffected","kind":12,"line":1029},{"containerName":"_rnaAffected","name":"prelabel","kind":12,"line":1029},{"line":1029,"kind":13,"name":"$before","containerName":"_rnaAffected"},{"name":"$rnaAffected","containerName":"_rnaAffected","line":1031,"kind":13},{"name":"$afterdist","definition":"my","containerName":"_rnaAffected","localvar":"my","kind":13,"line":1034},{"containerName":"_rnaAffected","name":"$self","line":1034,"kind":13},{"name":"mutation","containerName":"_rnaAffected","kind":12,"line":1034},{"line":1034,"kind":12,"name":"prelabel","containerName":"_rnaAffected"},{"name":"$firstexon","containerName":"_rnaAffected","kind":13,"line":1034},{"containerName":"_rnaAffected","name":"start","line":1034,"kind":12},{"definition":"my","name":"$beforedist","containerName":"_rnaAffected","localvar":"my","kind":13,"line":1035},{"kind":13,"line":1035,"name":"$firstexon","containerName":"_rnaAffected"},{"line":1035,"kind":12,"name":"end","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"$self","line":1035,"kind":13},{"line":1035,"kind":12,"name":"mutation","containerName":"_rnaAffected"},{"line":1035,"kind":12,"name":"postlabel","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"$exonvalue","definition":"my","localvar":"my","kind":13,"line":1036},{"containerName":"_rnaAffected","name":"$i","line":1036,"kind":13},{"containerName":"_rnaAffected","name":"$self","line":1037,"kind":13},{"line":1037,"kind":12,"containerName":"_rnaAffected","name":"dnamut"},{"name":"region","containerName":"_rnaAffected","line":1037,"kind":12},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":1038},{"containerName":"_rnaAffected","name":"dnamut","line":1038,"kind":12},{"kind":12,"line":1038,"containerName":"_rnaAffected","name":"region_value"},{"containerName":"_rnaAffected","name":"$exonvalue","kind":13,"line":1038},{"line":1039,"kind":13,"containerName":"_rnaAffected","name":"$afterdist"},{"kind":13,"line":1039,"name":"$beforedist","containerName":"_rnaAffected"},{"name":"$afterdist","containerName":"_rnaAffected","line":1040,"kind":13},{"name":"$afterdist","containerName":"_rnaAffected","kind":13,"line":1041},{"line":1042,"kind":13,"containerName":"_rnaAffected","name":"$self"},{"containerName":"_rnaAffected","name":"dnamut","kind":12,"line":1042},{"name":"region_dist","containerName":"_rnaAffected","kind":12,"line":1042},{"kind":13,"line":1042,"containerName":"_rnaAffected","name":"$afterdist"},{"containerName":"_rnaAffected","name":"$self","kind":13,"line":1045},{"line":1045,"kind":12,"name":"dnamut","containerName":"_rnaAffected"},{"name":"region_dist","containerName":"_rnaAffected","line":1045,"kind":12},{"kind":13,"line":1045,"name":"$beforedist","containerName":"_rnaAffected"},{"line":1050,"kind":13,"name":"$i","containerName":"_rnaAffected"},{"kind":13,"line":1051,"name":"$after","containerName":"_rnaAffected"},{"kind":13,"line":1051,"name":"$exons","containerName":"_rnaAffected"},{"kind":13,"line":1051,"containerName":"_rnaAffected","name":"$i"},{"kind":12,"line":1051,"containerName":"_rnaAffected","name":"start"},{"name":"$strand","containerName":"_rnaAffected","kind":13,"line":1053},{"name":"$self","containerName":"_rnaAffected","line":1054,"kind":13},{"name":"mutation","containerName":"_rnaAffected","kind":12,"line":1054},{"containerName":"_rnaAffected","name":"prelabel","kind":12,"line":1054},{"line":1054,"kind":13,"containerName":"_rnaAffected","name":"$before"},{"line":1055,"kind":13,"containerName":"_rnaAffected","name":"$self"},{"kind":12,"line":1055,"containerName":"_rnaAffected","name":"mutation"},{"kind":12,"line":1055,"containerName":"_rnaAffected","name":"postlabel"},{"line":1055,"kind":13,"containerName":"_rnaAffected","name":"$after"},{"name":"$strand","containerName":"_rnaAffected","kind":13,"line":1057},{"containerName":"_rnaAffected","name":"$self","line":1058,"kind":13},{"containerName":"_rnaAffected","name":"mutation","line":1058,"kind":12},{"name":"prelabel","containerName":"_rnaAffected","line":1058,"kind":12},{"line":1058,"kind":13,"name":"$before","containerName":"_rnaAffected"},{"kind":13,"line":1059,"containerName":"_rnaAffected","name":"$self"},{"containerName":"_rnaAffected","name":"mutation","line":1059,"kind":12},{"kind":12,"line":1059,"containerName":"_rnaAffected","name":"postlabel"},{"kind":13,"line":1059,"name":"$after","containerName":"_rnaAffected"},{"line":1060,"kind":13,"containerName":"_rnaAffected","name":"$self"},{"line":1060,"kind":12,"containerName":"_rnaAffected","name":"dnamut"},{"kind":12,"line":1060,"containerName":"_rnaAffected","name":"region"},{"line":1062,"kind":13,"localvar":"my","containerName":"_rnaAffected","name":"$afterdist","definition":"my"},{"kind":13,"line":1062,"name":"$self","containerName":"_rnaAffected"},{"name":"mutation","containerName":"_rnaAffected","kind":12,"line":1062},{"line":1062,"kind":12,"containerName":"_rnaAffected","name":"prelabel"},{"line":1062,"kind":13,"containerName":"_rnaAffected","name":"$before"},{"localvar":"my","name":"$beforedist","definition":"my","containerName":"_rnaAffected","line":1063,"kind":13},{"line":1063,"kind":13,"name":"$after","containerName":"_rnaAffected"},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":1063},{"line":1063,"kind":12,"name":"mutation","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"postlabel","line":1063,"kind":12},{"localvar":"my","containerName":"_rnaAffected","definition":"my","name":"$intronvalue","line":1064,"kind":13},{"line":1064,"kind":13,"containerName":"_rnaAffected","name":"$i"},{"line":1065,"kind":13,"name":"$afterdist","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"$beforedist","kind":13,"line":1065},{"containerName":"_rnaAffected","name":"$afterdist","kind":13,"line":1066},{"line":1067,"kind":13,"containerName":"_rnaAffected","name":"$self"},{"line":1067,"kind":12,"containerName":"_rnaAffected","name":"dnamut"},{"containerName":"_rnaAffected","name":"region_value","kind":12,"line":1067},{"line":1067,"kind":13,"containerName":"_rnaAffected","name":"$intronvalue"},{"kind":13,"line":1068,"name":"$self","containerName":"_rnaAffected"},{"line":1068,"kind":12,"name":"dnamut","containerName":"_rnaAffected"},{"name":"region_dist","containerName":"_rnaAffected","kind":12,"line":1068},{"name":"$afterdist","containerName":"_rnaAffected","line":1068,"kind":13},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":1071},{"name":"dnamut","containerName":"_rnaAffected","line":1071,"kind":12},{"containerName":"_rnaAffected","name":"region_value","kind":12,"line":1071},{"kind":13,"line":1071,"name":"$intronvalue","containerName":"_rnaAffected"},{"kind":13,"line":1072,"name":"$self","containerName":"_rnaAffected"},{"kind":12,"line":1072,"containerName":"_rnaAffected","name":"dnamut"},{"name":"region_dist","containerName":"_rnaAffected","kind":12,"line":1072},{"kind":13,"line":1072,"containerName":"_rnaAffected","name":"$beforedist"},{"kind":13,"line":1075,"name":"$self","containerName":"_rnaAffected"},{"name":"rnachange","containerName":"_rnaAffected","line":1075,"kind":12},{"containerName":"_rnaAffected","name":"$strand","line":1080,"kind":13},{"kind":13,"line":1081,"name":"$exons","containerName":"_rnaAffected"},{"name":"$i","containerName":"_rnaAffected","line":1081,"kind":13},{"containerName":"_rnaAffected","name":"start","line":1081,"kind":12},{"line":1081,"kind":13,"name":"$self","containerName":"_rnaAffected"},{"line":1081,"kind":12,"containerName":"_rnaAffected","name":"mutation"},{"name":"prelabel","containerName":"_rnaAffected","kind":12,"line":1081},{"name":"$exons","containerName":"_rnaAffected","kind":13,"line":1082},{"line":1082,"kind":13,"containerName":"_rnaAffected","name":"$i"},{"kind":12,"line":1082,"containerName":"_rnaAffected","name":"end"},{"kind":13,"line":1082,"name":"$self","containerName":"_rnaAffected"},{"kind":12,"line":1082,"name":"mutation","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"prelabel","kind":12,"line":1082},{"line":1083,"kind":13,"name":"$strand","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"$exons","kind":13,"line":1084},{"name":"$i","containerName":"_rnaAffected","line":1084,"kind":13},{"containerName":"_rnaAffected","name":"start","line":1084,"kind":12},{"kind":13,"line":1084,"containerName":"_rnaAffected","name":"$self"},{"line":1084,"kind":12,"containerName":"_rnaAffected","name":"mutation"},{"kind":12,"line":1084,"containerName":"_rnaAffected","name":"postlabel"},{"kind":13,"line":1085,"containerName":"_rnaAffected","name":"$exons"},{"kind":13,"line":1085,"name":"$i","containerName":"_rnaAffected"},{"kind":12,"line":1085,"name":"end","containerName":"_rnaAffected"},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":1085},{"containerName":"_rnaAffected","name":"mutation","line":1085,"kind":12},{"kind":12,"line":1085,"name":"postlabel","containerName":"_rnaAffected"},{"name":"$strand","containerName":"_rnaAffected","kind":13,"line":1086},{"name":"$exons","containerName":"_rnaAffected","line":1087,"kind":13},{"containerName":"_rnaAffected","name":"$i","kind":13,"line":1087},{"containerName":"_rnaAffected","name":"start","line":1087,"kind":12},{"line":1087,"kind":13,"containerName":"_rnaAffected","name":"$self"},{"kind":12,"line":1087,"name":"mutation","containerName":"_rnaAffected"},{"name":"prelabel","containerName":"_rnaAffected","line":1087,"kind":12},{"name":"$exons","containerName":"_rnaAffected","kind":13,"line":1088},{"line":1088,"kind":13,"name":"$i","containerName":"_rnaAffected"},{"kind":12,"line":1088,"containerName":"_rnaAffected","name":"end"},{"kind":13,"line":1088,"name":"$self","containerName":"_rnaAffected"},{"kind":12,"line":1088,"name":"mutation","containerName":"_rnaAffected"},{"line":1088,"kind":12,"name":"prelabel","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"$strand","kind":13,"line":1089},{"kind":13,"line":1090,"containerName":"_rnaAffected","name":"$exons"},{"line":1090,"kind":13,"containerName":"_rnaAffected","name":"$i"},{"containerName":"_rnaAffected","name":"start","line":1090,"kind":12},{"line":1090,"kind":13,"name":"$self","containerName":"_rnaAffected"},{"kind":12,"line":1090,"name":"mutation","containerName":"_rnaAffected"},{"kind":12,"line":1090,"containerName":"_rnaAffected","name":"postlabel"},{"name":"$exons","containerName":"_rnaAffected","line":1091,"kind":13},{"line":1091,"kind":13,"name":"$i","containerName":"_rnaAffected"},{"line":1091,"kind":12,"name":"end","containerName":"_rnaAffected"},{"kind":13,"line":1091,"name":"$self","containerName":"_rnaAffected"},{"line":1091,"kind":12,"name":"mutation","containerName":"_rnaAffected"},{"kind":12,"line":1091,"name":"postlabel","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"$rnaAffected","line":1092,"kind":13},{"line":1094,"kind":13,"localvar":"my","definition":"my","name":"$afterdist","containerName":"_rnaAffected"},{"name":"$self","containerName":"_rnaAffected","line":1094,"kind":13},{"containerName":"_rnaAffected","name":"mutation","kind":12,"line":1094},{"kind":12,"line":1094,"name":"prelabel","containerName":"_rnaAffected"},{"kind":13,"line":1094,"containerName":"_rnaAffected","name":"$exons"},{"name":"$i","containerName":"_rnaAffected","line":1094,"kind":13},{"containerName":"_rnaAffected","name":"start","line":1094,"kind":12},{"line":1095,"kind":13,"localvar":"my","definition":"my","name":"$beforedist","containerName":"_rnaAffected"},{"kind":13,"line":1095,"containerName":"_rnaAffected","name":"$exons"},{"kind":13,"line":1095,"containerName":"_rnaAffected","name":"$i"},{"containerName":"_rnaAffected","name":"end","line":1095,"kind":12},{"line":1095,"kind":13,"name":"$self","containerName":"_rnaAffected"},{"line":1095,"kind":12,"name":"mutation","containerName":"_rnaAffected"},{"kind":12,"line":1095,"name":"postlabel","containerName":"_rnaAffected"},{"definition":"my","name":"$exonvalue","containerName":"_rnaAffected","localvar":"my","kind":13,"line":1096},{"containerName":"_rnaAffected","name":"$i","kind":13,"line":1096},{"line":1097,"kind":13,"name":"$self","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"dnamut","kind":12,"line":1097},{"kind":12,"line":1097,"name":"region","containerName":"_rnaAffected"},{"name":"$afterdist","containerName":"_rnaAffected","line":1098,"kind":13},{"kind":13,"line":1098,"containerName":"_rnaAffected","name":"$beforedist"},{"kind":13,"line":1099,"name":"$afterdist","containerName":"_rnaAffected"},{"name":"$self","containerName":"_rnaAffected","line":1100,"kind":13},{"containerName":"_rnaAffected","name":"dnamut","line":1100,"kind":12},{"line":1100,"kind":12,"name":"region_value","containerName":"_rnaAffected"},{"line":1100,"kind":13,"name":"$exonvalue","containerName":"_rnaAffected"},{"line":1101,"kind":13,"containerName":"_rnaAffected","name":"$self"},{"kind":12,"line":1101,"name":"dnamut","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"region_dist","kind":12,"line":1101},{"containerName":"_rnaAffected","name":"$afterdist","line":1101,"kind":13},{"name":"$self","containerName":"_rnaAffected","kind":13,"line":1105},{"name":"dnamut","containerName":"_rnaAffected","line":1105,"kind":12},{"containerName":"_rnaAffected","name":"region_value","kind":12,"line":1105},{"kind":13,"line":1105,"name":"$exonvalue","containerName":"_rnaAffected"},{"containerName":"_rnaAffected","name":"$self","kind":13,"line":1106},{"name":"dnamut","containerName":"_rnaAffected","line":1106,"kind":12},{"name":"region_dist","containerName":"_rnaAffected","line":1106,"kind":12},{"name":"$beforedist","containerName":"_rnaAffected","kind":13,"line":1106},{"name":"$before","containerName":"_rnaAffected","kind":13,"line":1111},{"name":"$exons","containerName":"_rnaAffected","kind":13,"line":1111},{"name":"$i","containerName":"_rnaAffected","line":1111,"kind":13},{"name":"end","containerName":"_rnaAffected","kind":12,"line":1111},{"containerName":"_rnaAffected","name":"$rnaAffected","kind":13,"line":1118}],"line":959},{"line":974,"kind":12,"name":"follows"},{"kind":12,"line":977,"name":"follows"},{"name":"exons","line":988,"kind":12},{"line":990,"kind":12,"name":"follows"},{"kind":12,"line":992,"name":"follows"},{"kind":12,"line":993,"name":"follows"},{"kind":12,"line":1050,"name":"exons"},{"kind":12,"children":[{"localvar":"my","containerName":"_set_effects","name":"$self","definition":"my","line":1147,"kind":13},{"name":"$seqDiff","containerName":"_set_effects","kind":13,"line":1147},{"line":1147,"kind":13,"name":"$dnamut","containerName":"_set_effects"},{"kind":13,"line":1148,"containerName":"_set_effects","definition":"my","name":"$rnapos_end","localvar":"my"},{"kind":13,"line":1148,"containerName":"_set_effects","name":"$upstreamseq"},{"kind":13,"line":1148,"name":"$dnstreamseq","containerName":"_set_effects"},{"localvar":"my","definition":"my","name":"$flanklen","containerName":"_set_effects","line":1149,"kind":13},{"kind":13,"line":1149,"name":"$self","containerName":"_set_effects"},{"kind":13,"line":1151,"containerName":"_set_effects","name":"$self"},{"name":"mutation","containerName":"_set_effects","kind":12,"line":1151},{"containerName":"_set_effects","name":"len","kind":12,"line":1151},{"containerName":"_set_effects","name":"$rnapos_end","line":1152,"kind":13},{"line":1152,"kind":13,"name":"$self","containerName":"_set_effects"},{"kind":12,"line":1152,"name":"mutation","containerName":"_set_effects"},{"kind":12,"line":1152,"containerName":"_set_effects","name":"transpos"},{"line":1153,"kind":13,"containerName":"_set_effects","name":"$rnapos_end"},{"line":1153,"kind":13,"name":"$self","containerName":"_set_effects"},{"kind":12,"line":1153,"containerName":"_set_effects","name":"mutation"},{"line":1153,"kind":12,"name":"transpos","containerName":"_set_effects"},{"kind":13,"line":1153,"containerName":"_set_effects","name":"$self"},{"line":1153,"kind":12,"name":"mutation","containerName":"_set_effects"},{"name":"len","containerName":"_set_effects","line":1153,"kind":12},{"localvar":"my","name":"$rnachange","definition":"my","containerName":"_set_effects","line":1154,"kind":13},{"name":"new","containerName":"_set_effects","line":1154,"kind":12},{"line":1154,"kind":13,"name":"$self","containerName":"_set_effects"},{"line":1154,"kind":12,"containerName":"_set_effects","name":"mutation"},{"line":1154,"kind":12,"containerName":"_set_effects","name":"transpos"},{"name":"$rnapos_end","containerName":"_set_effects","line":1156,"kind":13},{"name":"$rnachange","containerName":"_set_effects","line":1157,"kind":13},{"kind":12,"line":1157,"containerName":"_set_effects","name":"isMutation"},{"name":"$seqDiff","containerName":"_set_effects","kind":13,"line":1160},{"line":1160,"kind":12,"name":"numbering","containerName":"_set_effects"},{"kind":13,"line":1161,"name":"$rnachange","containerName":"_set_effects"},{"line":1161,"kind":12,"containerName":"_set_effects","name":"proof"},{"line":1163,"kind":13,"name":"$rnachange","containerName":"_set_effects"},{"line":1163,"kind":12,"name":"proof","containerName":"_set_effects"},{"line":1166,"kind":13,"name":"$seqDiff","containerName":"_set_effects"},{"kind":12,"line":1166,"name":"add_Variant","containerName":"_set_effects"},{"line":1166,"kind":13,"containerName":"_set_effects","name":"$rnachange"},{"line":1167,"kind":13,"name":"$self","containerName":"_set_effects"},{"kind":12,"line":1167,"containerName":"_set_effects","name":"rnachange"},{"containerName":"_set_effects","name":"$rnachange","kind":13,"line":1167},{"containerName":"_set_effects","name":"$rnachange","line":1168,"kind":13},{"line":1168,"kind":12,"containerName":"_set_effects","name":"DNAMutation"},{"line":1168,"kind":13,"containerName":"_set_effects","name":"$dnamut"},{"line":1169,"kind":13,"containerName":"_set_effects","name":"$dnamut"},{"kind":12,"line":1169,"name":"RNAChange","containerName":"_set_effects"},{"line":1169,"kind":13,"name":"$rnachange","containerName":"_set_effects"},{"kind":13,"line":1170,"containerName":"_set_effects","name":"$rnachange"},{"containerName":"_set_effects","name":"mut_number","kind":12,"line":1170},{"kind":13,"line":1170,"name":"$self","containerName":"_set_effects"},{"containerName":"_set_effects","name":"mutation","kind":12,"line":1170},{"name":"issue","containerName":"_set_effects","line":1170,"kind":12},{"line":1173,"kind":13,"containerName":"_set_effects","name":"$rnachange"},{"containerName":"_set_effects","name":"codon_pos","kind":12,"line":1173},{"containerName":"_set_effects","name":"$self","kind":13,"line":1173},{"containerName":"_set_effects","name":"RNA","kind":12,"line":1173},{"line":1173,"kind":12,"containerName":"_set_effects","name":"frame"},{"kind":13,"line":1173,"containerName":"_set_effects","name":"$self"},{"line":1173,"kind":12,"name":"mutation","containerName":"_set_effects"},{"containerName":"_set_effects","name":"label","kind":12,"line":1173},{"kind":13,"line":1175,"containerName":"_set_effects","name":"@exons","definition":"my","localvar":"my"},{"line":1175,"kind":13,"name":"$self","containerName":"_set_effects"},{"containerName":"_set_effects","name":"RNA","line":1175,"kind":12},{"name":"all_Exons","containerName":"_set_effects","line":1175,"kind":12},{"name":"$self","containerName":"_set_effects","line":1176,"kind":13},{"name":"exons","containerName":"_set_effects","kind":12,"line":1176},{"kind":13,"line":1176,"containerName":"_set_effects","name":"@exons"},{"containerName":"_set_effects","name":"$RNAprelabel","definition":"my","localvar":"my","kind":13,"line":1181},{"line":1181,"kind":13,"name":"$self","containerName":"_set_effects"},{"name":"RNA","containerName":"_set_effects","kind":12,"line":1181},{"containerName":"_set_effects","name":"label","line":1181,"kind":12},{"kind":13,"line":1181,"containerName":"_set_effects","name":"$self"},{"name":"mutation","containerName":"_set_effects","line":1181,"kind":12},{"kind":12,"line":1181,"name":"label","containerName":"_set_effects"},{"kind":13,"line":1183,"containerName":"_set_effects","definition":"my","name":"$uplabel","localvar":"my"},{"containerName":"_set_effects","name":"$self","kind":13,"line":1183},{"line":1183,"kind":12,"containerName":"_set_effects","name":"RNA"},{"kind":12,"line":1183,"containerName":"_set_effects","name":"label"},{"line":1183,"kind":13,"name":"$flanklen","containerName":"_set_effects"},{"line":1183,"kind":13,"name":"$RNAprelabel","containerName":"_set_effects"},{"name":"$self","containerName":"_set_effects","kind":13,"line":1184},{"name":"RNA","containerName":"_set_effects","line":1184,"kind":12},{"line":1184,"kind":12,"name":"valid","containerName":"_set_effects"},{"containerName":"_set_effects","name":"$uplabel","kind":13,"line":1184},{"kind":13,"line":1185,"name":"$upstreamseq","containerName":"_set_effects"},{"line":1185,"kind":13,"name":"$self","containerName":"_set_effects"},{"containerName":"_set_effects","name":"RNA","kind":12,"line":1185},{"line":1185,"kind":12,"containerName":"_set_effects","name":"labelsubseq"},{"line":1185,"kind":13,"containerName":"_set_effects","name":"$uplabel"},{"line":1185,"kind":13,"name":"$RNAprelabel","containerName":"_set_effects"},{"line":1187,"kind":13,"containerName":"_set_effects","name":"$upstreamseq"},{"containerName":"_set_effects","name":"$self","line":1187,"kind":13},{"line":1187,"kind":12,"containerName":"_set_effects","name":"RNA"},{"containerName":"_set_effects","name":"labelsubseq","kind":12,"line":1187},{"kind":13,"line":1187,"containerName":"_set_effects","name":"$self"},{"kind":12,"line":1187,"containerName":"_set_effects","name":"RNA"},{"kind":12,"line":1187,"name":"start","containerName":"_set_effects"},{"name":"$RNAprelabel","containerName":"_set_effects","kind":13,"line":1187},{"name":"$self","containerName":"_set_effects","kind":13,"line":1188},{"name":"RNA","containerName":"_set_effects","line":1188,"kind":12},{"name":"valid","containerName":"_set_effects","kind":12,"line":1188},{"containerName":"_set_effects","name":"$RNAprelabel","line":1188,"kind":13},{"localvar":"my","containerName":"_set_effects","definition":"my","name":"$lacking","line":1189,"kind":13},{"line":1189,"kind":13,"containerName":"_set_effects","name":"$flanklen-length"},{"name":"$upstreamseq","containerName":"_set_effects","line":1189,"kind":13},{"kind":13,"line":1190,"containerName":"_set_effects","definition":"my","name":"$upstream_atg","localvar":"my"},{"containerName":"_set_effects","name":"$exons","line":1190,"kind":13},{"line":1190,"kind":12,"containerName":"_set_effects","name":"subseq"},{"kind":13,"line":1190,"name":"$lacking","containerName":"_set_effects"},{"name":"$upstreamseq","containerName":"_set_effects","kind":13,"line":1191},{"name":"$upstream_atg","containerName":"_set_effects","kind":13,"line":1191},{"line":1191,"kind":13,"name":"$upstreamseq","containerName":"_set_effects"},{"containerName":"_set_effects","name":"$rnachange","kind":13,"line":1194},{"kind":12,"line":1194,"name":"upStreamSeq","containerName":"_set_effects"},{"name":"$upstreamseq","containerName":"_set_effects","line":1194,"kind":13},{"localvar":"my","containerName":"_set_effects","name":"$RNApostlabel","definition":"my","line":1199,"kind":13},{"containerName":"_set_effects","name":"$self","line":1200,"kind":13},{"name":"mutation","containerName":"_set_effects","line":1200,"kind":12},{"name":"len","containerName":"_set_effects","line":1200,"kind":12},{"kind":13,"line":1201,"containerName":"_set_effects","name":"$RNApostlabel"},{"name":"$self","containerName":"_set_effects","kind":13,"line":1201},{"line":1201,"kind":12,"name":"mutation","containerName":"_set_effects"},{"name":"label","containerName":"_set_effects","line":1201,"kind":12},{"kind":13,"line":1203,"name":"$mutlen","definition":"my","containerName":"_set_effects","localvar":"my"},{"containerName":"_set_effects","name":"$self","kind":13,"line":1203},{"kind":12,"line":1203,"containerName":"_set_effects","name":"mutation"},{"name":"len","containerName":"_set_effects","line":1203,"kind":12},{"containerName":"_set_effects","name":"$RNApostlabel","line":1204,"kind":13},{"line":1204,"kind":13,"containerName":"_set_effects","name":"$self"},{"line":1204,"kind":12,"containerName":"_set_effects","name":"RNA"},{"name":"label","containerName":"_set_effects","kind":12,"line":1204},{"containerName":"_set_effects","name":"$mutlen","line":1204,"kind":13},{"kind":13,"line":1204,"name":"$self","containerName":"_set_effects"},{"line":1204,"kind":12,"name":"mutation","containerName":"_set_effects"},{"kind":12,"line":1204,"containerName":"_set_effects","name":"label"},{"name":"$dnstreamseq","containerName":"_set_effects","kind":13,"line":1206},{"line":1206,"kind":13,"containerName":"_set_effects","name":"$self"},{"name":"RNA","containerName":"_set_effects","line":1206,"kind":12},{"name":"labelsubseq","containerName":"_set_effects","line":1206,"kind":12},{"kind":13,"line":1206,"name":"$RNApostlabel","containerName":"_set_effects"},{"line":1206,"kind":13,"name":"$flanklen","containerName":"_set_effects"},{"name":"$dnstreamseq","containerName":"_set_effects","kind":13,"line":1207},{"line":1208,"kind":13,"localvar":"my","name":"$lastexon","definition":"my","containerName":"_set_effects"},{"containerName":"_set_effects","name":"$exons","line":1208,"kind":13},{"line":1209,"kind":13,"localvar":"my","name":"$lastexonlength","definition":"my","containerName":"_set_effects"},{"kind":13,"line":1209,"containerName":"_set_effects","name":"$lastexon"},{"containerName":"_set_effects","name":"length","kind":12,"line":1209},{"kind":13,"line":1210,"name":"$dnstreamseq","containerName":"_set_effects"},{"containerName":"_set_effects","name":"$self","kind":13,"line":1210},{"containerName":"_set_effects","name":"RNA","kind":12,"line":1210},{"name":"labelsubseq","containerName":"_set_effects","line":1210,"kind":12},{"kind":13,"line":1210,"name":"$RNApostlabel","containerName":"_set_effects"},{"kind":13,"line":1211,"containerName":"_set_effects","name":"$lacking","definition":"my","localvar":"my"},{"kind":13,"line":1211,"name":"$flanklen-length","containerName":"_set_effects"},{"line":1211,"kind":13,"containerName":"_set_effects","name":"$dnstreamseq"},{"line":1212,"kind":13,"localvar":"my","name":"$downstream_stop","definition":"my","containerName":"_set_effects"},{"containerName":"_set_effects","name":"$lastexon","line":1212,"kind":13},{"containerName":"_set_effects","name":"subseq","line":1212,"kind":12},{"containerName":"_set_effects","name":"$lastexonlength","kind":13,"line":1212},{"containerName":"_set_effects","name":"$lacking","kind":13,"line":1212},{"kind":13,"line":1213,"containerName":"_set_effects","name":"$dnstreamseq"},{"containerName":"_set_effects","name":"$downstream_stop","kind":13,"line":1213},{"containerName":"_set_effects","name":"$rnachange","line":1215,"kind":13},{"kind":12,"line":1215,"name":"dnStreamSeq","containerName":"_set_effects"},{"name":"$dnstreamseq","containerName":"_set_effects","line":1215,"kind":13},{"kind":13,"line":1218,"containerName":"_set_effects","definition":"my","name":"$AAobj","localvar":"my"},{"kind":13,"line":1218,"name":"$self","containerName":"_set_effects"},{"kind":12,"line":1218,"name":"RNA","containerName":"_set_effects"},{"line":1218,"kind":12,"containerName":"_set_effects","name":"get_Translation"},{"name":"$aachange","definition":"my","containerName":"_set_effects","localvar":"my","kind":13,"line":1220},{"line":1220,"kind":12,"name":"new","containerName":"_set_effects"},{"name":"$RNAprelabel","containerName":"_set_effects","line":1221,"kind":13},{"name":"$aachange","containerName":"_set_effects","kind":13,"line":1222},{"containerName":"_set_effects","name":"isMutation","kind":12,"line":1222},{"name":"$aachange","containerName":"_set_effects","kind":13,"line":1223},{"containerName":"_set_effects","name":"proof","line":1223,"kind":12},{"name":"$seqDiff","containerName":"_set_effects","kind":13,"line":1225},{"kind":12,"line":1225,"containerName":"_set_effects","name":"add_Variant"},{"containerName":"_set_effects","name":"$aachange","kind":13,"line":1225},{"containerName":"_set_effects","name":"$self","kind":13,"line":1226},{"kind":12,"line":1226,"name":"aachange","containerName":"_set_effects"},{"containerName":"_set_effects","name":"$aachange","kind":13,"line":1226},{"kind":13,"line":1227,"containerName":"_set_effects","name":"$rnachange"},{"line":1227,"kind":12,"containerName":"_set_effects","name":"AAChange"},{"kind":13,"line":1227,"name":"$aachange","containerName":"_set_effects"},{"kind":13,"line":1228,"name":"$aachange","containerName":"_set_effects"},{"line":1228,"kind":12,"containerName":"_set_effects","name":"RNAChange"},{"name":"$rnachange","containerName":"_set_effects","line":1228,"kind":13},{"containerName":"_set_effects","name":"$aachange","kind":13,"line":1230},{"kind":12,"line":1230,"name":"mut_number","containerName":"_set_effects"},{"name":"$self","containerName":"_set_effects","line":1230,"kind":13},{"kind":12,"line":1230,"containerName":"_set_effects","name":"mutation"},{"name":"issue","containerName":"_set_effects","kind":12,"line":1230},{"definition":"my","name":"$ra_o","containerName":"_set_effects","localvar":"my","kind":13,"line":1233},{"name":"new","containerName":"_set_effects","line":1233,"kind":12},{"name":"$ra_o","containerName":"_set_effects","kind":13,"line":1234},{"name":"seq","containerName":"_set_effects","line":1234,"kind":12},{"kind":13,"line":1234,"name":"$dnamut","containerName":"_set_effects"},{"containerName":"_set_effects","name":"allele_ori","kind":12,"line":1234},{"line":1234,"kind":12,"containerName":"_set_effects","name":"seq"},{"line":1234,"kind":13,"name":"$dnamut","containerName":"_set_effects"},{"containerName":"_set_effects","name":"allele_ori","line":1234,"kind":12},{"line":1234,"kind":12,"name":"seq","containerName":"_set_effects"},{"kind":13,"line":1235,"containerName":"_set_effects","name":"$rnachange"},{"line":1235,"kind":12,"name":"allele_ori","containerName":"_set_effects"},{"containerName":"_set_effects","name":"$ra_o","line":1235,"kind":13},{"kind":13,"line":1237,"containerName":"_set_effects","name":"$rnachange"},{"containerName":"_set_effects","name":"length","kind":12,"line":1237},{"kind":13,"line":1237,"name":"$rnachange","containerName":"_set_effects"},{"containerName":"_set_effects","name":"allele_ori","line":1237,"kind":12},{"containerName":"_set_effects","name":"seq","line":1237,"kind":12},{"kind":13,"line":1239,"containerName":"_set_effects","definition":"my","name":"$ra_m","localvar":"my"},{"line":1239,"kind":12,"containerName":"_set_effects","name":"new"},{"name":"$ra_m","containerName":"_set_effects","line":1240,"kind":13},{"name":"seq","containerName":"_set_effects","kind":12,"line":1240},{"containerName":"_set_effects","name":"$self","kind":13,"line":1240},{"containerName":"_set_effects","name":"mutation","line":1240,"kind":12},{"containerName":"_set_effects","name":"seq","line":1240,"kind":12},{"name":"$self","containerName":"_set_effects","line":1240,"kind":13},{"kind":12,"line":1240,"containerName":"_set_effects","name":"mutation"},{"containerName":"_set_effects","name":"seq","kind":12,"line":1240},{"kind":13,"line":1241,"name":"$rnachange","containerName":"_set_effects"},{"kind":12,"line":1241,"containerName":"_set_effects","name":"allele_mut"},{"line":1241,"kind":13,"containerName":"_set_effects","name":"$ra_m"},{"kind":13,"line":1242,"name":"$rnachange","containerName":"_set_effects"},{"kind":12,"line":1242,"containerName":"_set_effects","name":"add_Allele"},{"name":"$ra_m","containerName":"_set_effects","kind":13,"line":1242},{"kind":13,"line":1245,"containerName":"_set_effects","name":"$rnachange"},{"line":1245,"kind":12,"containerName":"_set_effects","name":"end"},{"line":1245,"kind":13,"name":"$rnachange","containerName":"_set_effects"},{"kind":12,"line":1245,"name":"start","containerName":"_set_effects"},{"containerName":"_set_effects","name":"$rnachange","line":1245,"kind":13},{"line":1245,"kind":12,"name":"length","containerName":"_set_effects"},{"kind":13,"line":1248,"containerName":"_set_effects","definition":"my","name":"$aa_allele_ori","localvar":"my"},{"kind":13,"line":1248,"name":"$AAobj","containerName":"_set_effects"},{"kind":12,"line":1248,"name":"labelsubseq","containerName":"_set_effects"},{"name":"$self","containerName":"_set_effects","kind":13,"line":1248},{"containerName":"_set_effects","name":"mutation","kind":12,"line":1248},{"kind":12,"line":1248,"name":"label","containerName":"_set_effects"},{"line":1249,"kind":13,"name":"$self","containerName":"_set_effects"},{"containerName":"_set_effects","name":"mutation","kind":12,"line":1249},{"line":1249,"kind":12,"name":"lastlabel","containerName":"_set_effects"},{"containerName":"_set_effects","definition":"my","name":"$aa_o","localvar":"my","kind":13,"line":1251},{"name":"new","containerName":"_set_effects","kind":12,"line":1251},{"containerName":"_set_effects","name":"$aa_o","line":1252,"kind":13},{"name":"seq","containerName":"_set_effects","line":1252,"kind":12},{"line":1252,"kind":13,"containerName":"_set_effects","name":"$aa_allele_ori"},{"line":1252,"kind":13,"containerName":"_set_effects","name":"$aa_allele_ori"},{"containerName":"_set_effects","name":"$aachange","kind":13,"line":1253},{"containerName":"_set_effects","name":"allele_ori","line":1253,"kind":12},{"kind":13,"line":1253,"name":"$aa_o","containerName":"_set_effects"},{"containerName":"_set_effects","name":"$aa_length_ori","definition":"my","localvar":"my","kind":13,"line":1256},{"line":1256,"kind":13,"containerName":"_set_effects","name":"$aa_allele_ori"},{"line":1257,"kind":13,"containerName":"_set_effects","name":"$aachange"},{"containerName":"_set_effects","name":"length","line":1257,"kind":12},{"line":1257,"kind":13,"name":"$aa_length_ori","containerName":"_set_effects"},{"name":"$aachange","containerName":"_set_effects","line":1258,"kind":13},{"kind":12,"line":1258,"containerName":"_set_effects","name":"end"},{"kind":13,"line":1258,"containerName":"_set_effects","name":"$aachange"},{"kind":12,"line":1258,"name":"start","containerName":"_set_effects"},{"containerName":"_set_effects","name":"$aa_length_ori","line":1258,"kind":13}],"line":1146,"definition":"sub","containerName":"main::","signature":{"label":"_set_effects($self,$seqDiff,$dnamut)","documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information.\n\n\n\nsub aachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::AAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::AAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'aachange'} = $value;\n      }\n  }\n  unless (exists $self->{'aachange'}) {\n      return;\n  } else {\n      return $self->{'aachange'};\n  }\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $mutobj = $obj->exons;\n         : $mutobj = $obj->exons($objref);\n Function:\n\n           Returns or sets the reference to a current array of Exons.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an array of Bio::LiveSeq::Exon objects or undef\n\nSee L<Bio::LiveSeq::Exon> for more information.\n\n\n\nsub exons {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'exons'} = $value;\n  }\n  unless (exists $self->{'exons'}) {\n      return;\n  } else {\n      return $self->{'exons'};\n  }\n}\n\n=head2 change_gene_with_alignment\n\n Title   : change_gene_with_alignment\n Usage   : $results=$mutate->change_gene_with_alignment($aln);\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes in the alignment. The alignment has\n           to be pairwise and have one sequence named 'QUERY', the\n           other one is assumed to be a part of the sequence from\n           $gene.\n\n           This method offers a shortcut to change_gene and\n           automates the creation of Bio::LiveSeq::Mutation objects.\n           Use it with almost identical sequnces, e.g. to locate a SNP.\n\n Args    : Bio::SimpleAlign object representing a short local alignment\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\nSee L<Bio::LiveSeq::Mutation>, L<Bio::SimpleAlign>, and\nL<Bio::Variation::SeqDiff>  for more information.\n\n\nsub change_gene_with_alignment {\n    my ($self, $aln) = @_;\n\n    #\n    # Sanity checks\n    #\n\n    $self->throw(\"Argument is not a Bio::SimpleAlign object but a [$aln]\")\n\tunless $aln->isa('Bio::SimpleAlign');\n    $self->throw(\"'Pairwise alignments only, please\") \n\tif $aln->no_sequences != 2;\n\n    # find out the order the two sequences are given\n    my $queryseq_pos = 1; #default\n    my $refseq_pos = 2;\n    unless ($aln->get_seq_by_pos(1)->id eq 'QUERY') {\n\tcarp('Query sequence has to be named QUERY') \n\t    if $aln->get_seq_by_pos(2)->id ne 'QUERY';\n\t$queryseq_pos = 2; # alternative\n\t$refseq_pos = 1;\n    }\n\n    # trim the alignment\n    my $start =  $aln->column_from_residue_number('QUERY', 1);\n    my $end =  $aln->column_from_residue_number('QUERY', \n\t\t\t\t\t\t$aln->get_seq_by_pos($queryseq_pos)->end );\n    \n    my $aln2 = $aln->slice($start, $end);\n\n    #\n    # extracting mutations\n    #\n\n    my $cs = $aln2->consensus_string(51);\n    my $queryseq = $aln2->get_seq_by_pos($queryseq_pos);\n    my $refseq = $aln2->get_seq_by_pos($refseq_pos);\n\n    while ( $cs =~ /(\\?+)/g) {\n\t# pos in local coordinates\n\tmy $pos = pos($cs) - length($1) + 1;\n\tmy $mutation = create_mutation($self, \n\t\t\t\t       $refseq, \n\t\t\t\t       $queryseq, \n\t\t\t\t       $pos, \n\t\t\t\t       CORE::length($1)\n\t\t\t\t       );\n\t# reset pos to refseq coordinates\n\t$pos +=  $refseq->start - 1;\n\t$mutation->pos($pos);\n\n        $self->add_Mutation($mutation);\n    }\n    return $self->change_gene();\n}\n\n=head2 create_mutation\n\n Title   : create_mutation\n Usage   : \n Function:\n\n           Formats sequence differences from two sequences into\n           Bio::LiveSeq::Mutation objects which can be applied to a\n           gene.\n\n           To keep it generic, sequence arguments need not to be\n           Bio::LocatableSeq. Coordinate change to parent sequence\n           numbering needs to be done by the calling code.\n\n           Called from change_gene_with_alignment\n\n Args    : Bio::PrimarySeqI inheriting object for the reference sequence\n           Bio::PrimarySeqI inheriting object for the query sequence\n           integer for the start position of the local sequence difference\n           integer for the length of the sequence difference\n Returns : Bio::LiveSeq::Mutation object \n\n\nsub create_mutation {\n    my ($self, $refseq, $queryseq, $pos, $len) = @_;\n    \n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$refseq]\") \n\tunless $refseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$queryseq]\") \n\tunless $queryseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Position is not a positive integer but [$pos]\") \n\tunless $pos =~ /^\\+?\\d+$/;\n    $self->throw(\"Length is not a positive integer but [$len]\") \n\tunless $len =~ /^\\+?\\d+$/;\n\n    my $mutation;\n    my $refstring = $refseq->subseq($pos, $pos + $len - 1);\n    my $varstring = $queryseq->subseq($pos, $pos + $len - 1);\n    \n    if ($len == 1 and $refstring =~ /[^\\.\\-\\*\\?]/ and \n\t$varstring  =~ /[^\\.\\-\\*\\?]/ ) { #point\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring =~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  !~ /^[^\\.\\-\\*\\?]+$/ ) { # deletion\n\t$mutation = Bio::LiveSeq::Mutation->new(-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring !~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  =~ /^[^\\.\\-\\*\\?]+$/ ) { # insertion\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => 0\n\t\t\t\t\t\t);\n    } else { # complex\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    \n    return $mutation;\n}\n\n=head2 change_gene\n\n Title   : change_gene\n Usage   : my $mutate = Bio::LiveSeq::Mutator->new(-gene => $gene,\n\t\t\t\t\t\t   numbering => \"coding\"\n\t\t\t\t\t\t   );\n           # $mut is Bio::LiveSeq::Mutation object\n           $mutate->add_Mutation($mut);\n           my $results=$mutate->change_gene();\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes performed according to the\n           instructions present in Mutation(s).  The -numbering\n           argument decides what molecule is being changed and what\n           numbering scheme being used:\n\n            -numbering => \"entry\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the sequence\n\n            -numbering => \"coding\"\n\n               determines the RNA level, using the numbering from the\n               beginning of the 1st transcript\n\n               Alternative transcripts can be used by specifying\n               \"coding 2\" or \"coding 3\" ...\n\n            -numbering => \"gene\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the 1st transcript and inluding introns.\n               The meaning equals 'coding' if the reference molecule\n               is cDNA.\n\n Args    : Bio::LiveSeq::Gene object\n           Bio::LiveSeq::Mutation object(s)\n           string specifying a numbering scheme (defaults to 'coding')\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\n\nsub change_gene {\n    my ($self) = @_;\n\n    #\n    # Sanity check\n    #\n    unless ($self->gene) {\n\t$self->warn(\"Input object Bio::LiveSeq::Gene is not given\");\n\treturn 0;\n    }\n    #\n    # Setting the reference sequence based on -numbering\n    #\n    my @transcripts=@{$self->gene->get_Transcripts};\n    my $refseq; # will hold Bio::LiveSeq:Transcript object or Bio::LiveSeq::DNA\n\n    # 'gene' eq 'coding' if reference sequence is cDNA\n    $self->numbering ('coding') if $self->gene->get_DNA->alphabet eq 'rna' and $self->numbering eq 'gene';\n\n    if ($self->numbering =~ /(coding)( )?(\\d+)?/ ) {\n\t$self->numbering($1);\n\tmy $transnumber = $3;\n\t$transnumber-- if $3; # 1 -> 0, 2 -> 1\n\tif ($transnumber && $transnumber >= 0 && $transnumber <= $#transcripts) {\n\t    $refseq=$transcripts[$transnumber];\n\t} else {\n\t    $transnumber && $self->warn(\"The alternative transcript number \". $transnumber+1 .\n\t    \"- does not exist. Reverting to the 1st transcript\\n\");\n\t    $refseq=$transcripts[0];\n\t}\n    } else {\n\t$refseq=$transcripts[0]->{'seq'};\n    }\n    #\n    # Recording the state: SeqDiff object creation  ?? transcript no.??\n    #\n    my $seqDiff = Bio::Variation::SeqDiff->new(-verbose => $self->verbose);\n    $seqDiff->alphabet($self->gene->get_DNA->alphabet);\n    $seqDiff->numbering($self->numbering);\n    my ($DNAobj, $RNAobj);\n    if ($refseq->isa(\"Bio::LiveSeq::Transcript\")) {\n\t$self->RNA($refseq);\n\t$self->DNA($refseq->{'seq'});\n\t$seqDiff->rna_ori($refseq->seq );\n\t$seqDiff->aa_ori($refseq->get_Translation->seq);\n    } else {\n\t$self->DNA($refseq);\n\t$self->RNA($transcripts[0]);\n\t$seqDiff->rna_ori($self->RNA->seq);\n\t$seqDiff->aa_ori($self->RNA->get_Translation->seq);\n    }\n    $seqDiff->dna_ori($self->DNA->seq);\n    # put the accession number into the SeqDiff object ID\n    $seqDiff->id($self->DNA->accession_number);\n\n    # the atg_offset takes in account that DNA object could be a subset of the\n    # whole entry (via the light_weight loader)\n    my $atg_label=$self->RNA->start;\n    my $atg_offset=$self->DNA->position($atg_label)+($self->DNA->start)-1;\n    $seqDiff->offset($atg_offset - 1);\n    $self->DNA->coordinate_start($atg_label);\n\n    my @exons = $self->RNA->all_Exons;\n    $seqDiff->cds_end($exons[$#exons]->end);\n\n    #\n    # Converting mutation positions to labels\n    #\n    $self->warn(\"no mutations\"), return 0 \n\tunless $self->_mutationpos2label($refseq, $seqDiff);\n\n    # need to add more than one rna & aa\n    #foreach $transcript (@transcripts) {\n    #  $seqDiff{\"ori_transcript_${i}_seq\"}=$transcript->seq;\n    #  $seqDiff{\"ori_translation_${i}_seq\"}=$transcript->get_Translation->seq;\n    #}\n\n    # do changes\n    my $k;\n    foreach my $mutation ($self->each_Mutation) {\n\tnext unless $mutation->label > 0;\n\t$self->mutation($mutation);\n\n\t$mutation->issue(++$k);\n\t#\n\t# current position on the transcript\n\t#\n\tif ($self->numbering =~ /coding/) {\n\t    $mutation->transpos($mutation->pos); # transpos given by user\n\t} else {\n\t    #transpos of label / It will be 0 if mutating an intron, negative if upstream of ATG\n\t    $mutation->transpos($self->RNA->position($mutation->label,$atg_label));\n\t}\n\t#\n\t# Calculate adjacent labels based on the position on the current sequence\n\t#\n\t$mutation->prelabel($self->DNA->label(-1, $mutation->label)); # 1 before label\n\tif ($mutation->len == 0) {\n\t    $mutation->postlabel($mutation->label);\n\t    $mutation->lastlabel($mutation->label);\n\t} elsif ($mutation->len == 1) {\n\t    $mutation->lastlabel($mutation->label); # last nucleotide affected\n\t    $mutation->postlabel($self->DNA->label(2,$mutation->lastlabel)); # $len after label\n\t} else {\n\t    $mutation->lastlabel($self->DNA->label($mutation->len,$mutation->label));\n\t    $mutation->postlabel($self->DNA->label(2,$mutation->lastlabel));\n\t}\n\tmy $dnamut = $self->_set_DNAMutation($seqDiff);\n\t#\n\t#\n\t#\n\tif ($self->_rnaAffected) {\n\t    $self->_set_effects($seqDiff, $dnamut);\n\t}\n\telsif ($seqDiff->offset != 0 and $dnamut->region ne 'intron') {\n\t    $self->_untranslated ($seqDiff, $dnamut);\n\t} else {\n\t    #$self->warn(\"Mutation starts outside coding region, RNAChange object not created\");\n\t}\n\n\t#########################################################################\n\t# Mutations are done here!                                              #\n\t$refseq->labelchange($mutation->seq, $mutation->label, $mutation->len); #\n\t#########################################################################\n\n\t$self->_post_mutation ($seqDiff);\n\n\t$self->dnamut(undef);\n\t$self->rnachange(undef);\n\t$self->aachange(undef);\n\t$self->exons(undef);\n    }\n    # record the final state of all three sequences\n    $seqDiff->dna_mut($self->DNA->seq);\n    $seqDiff->rna_mut($self->RNA->seq);\n    if ($refseq->isa(\"Bio::LiveSeq::Transcript\")) {\n\t$seqDiff->aa_mut($refseq->get_Translation->seq);\n    } else {\n\t$seqDiff->aa_mut($self->RNA->get_Translation->seq);\n    }\n\n    #$seqDiff{mut_dna_seq}=$gene->get_DNA->seq;\n    #my $i=1;\n    #foreach $transcript (@transcripts) {\n    #  $seqDiff{\"mut_transcript_${i}_seq\"}=$transcript->seq;\n    #  $seqDiff{\"mut_translation_${i}_seq\"}=$transcript->get_Translation->seq;\n    #}\n    return $seqDiff;\n}\n\n=head2 _mutationpos2label\n\n Title   : _mutationpos2label\n Usage   :\n Function: converts mutation positions into labels\n Example :\n Returns : number of valid mutations\n Args    : LiveSeq sequence object\n\n\nsub _mutationpos2label {\n    my ($self, $refseq, $SeqDiff) = @_;\n    my $count;\n    my @bb = @{$self->{'mutations'}};\n    my $cc = scalar @bb;\n    foreach my $mut (@{$self->{'mutations'}}) {\n#\t if ($self->numbering eq 'gene' and $mut->pos < 1) {\n#\t     my $tmp = $mut->pos;\n#\t     print STDERR \"pos: \", \"$tmp\\n\";\n#\t     $tmp++ if $tmp < 1;\n#\t     $tmp += $SeqDiff->offset;\n#\t     print STDERR \"pos2: \", \"$tmp\\n\";\n#\t     $mut->pos($tmp);\n#\t }\n#\telsif ($self->numbering eq 'entry') {\n\tif ($self->numbering eq 'entry') {\n\t    my $tmp = $mut->pos;\n\t    $tmp -= $SeqDiff->offset;\n\t    $tmp-- if $tmp < 1;\n\t    $mut->pos($tmp);\n\t}\n\n\tmy $label = $refseq->label($mut->pos); # get the label for the position\n\t$mut->label($label), $count++ if $label > 0 ;\n\t#print STDERR \"x\", $mut->pos,'|' ,$mut->label, \"\\n\";\n    }\n    return $count;\n}\n\n#\n# Calculate labels around mutated nucleotide\n#\n\n=head2 _set_DNAMutation\n\n Title   : _set_DNAMutation\n Usage   :\n Function:\n\n           Stores DNA level mutation attributes before mutation into\n           Bio::Variation::DNAMutation object.  Links it to SeqDiff\n           object.\n\n Example :\n Returns : Bio::Variation::DNAMutation object\n Args    : Bio::Variation::SeqDiff object\n\nSee L<Bio::Variation::DNAMutation> and L<Bio::Variation::SeqDiff>.\n\n\nsub _set_DNAMutation {\n    my ($self, $seqDiff) = @_;\n\n    my $dnamut_start = $self->mutation->label - $seqDiff->offset;\n    # if negative DNA positions (before ATG)\n    $dnamut_start-- if $dnamut_start <= 0;\n    my $dnamut_end;\n    ($self->mutation->len == 0 or $self->mutation->len == 1) ?\n\t($dnamut_end = $dnamut_start) :\n\t($dnamut_end = $dnamut_start+$self->mutation->len);\n    #print \"start:$dnamut_start, end:$dnamut_end\\n\";\n    my $dnamut = Bio::Variation::DNAMutation->new(-start => $dnamut_start,\n\t\t\t\t\t\t  -end => $dnamut_end,\n\t\t\t\t\t\t  );\n    $dnamut->mut_number($self->mutation->issue);\n    $dnamut->isMutation(1);\n    my $da_m = Bio::Variation::Allele->new;\n    $da_m->seq($self->mutation->seq) if $self->mutation->seq;\n    $dnamut->allele_mut($da_m);\n    $dnamut->add_Allele($da_m);\n    # allele_ori\n    my $allele_ori = $self->DNA->labelsubseq($self->mutation->prelabel,\n\t\t\t\t\t     undef,\n\t\t\t\t\t     $self->mutation->postlabel); # get seq\n    chop $allele_ori; # chop the postlabel nucleotide\n    $allele_ori=substr($allele_ori,1); # away the prelabel nucleotide\n    my $da_o = Bio::Variation::Allele->new;\n    $da_o->seq($allele_ori) if $allele_ori;\n    $dnamut->allele_ori($da_o);\n    ($self->mutation->len == 0) ?\n\t($dnamut->length($self->mutation->len)) : ($dnamut->length(CORE::length $allele_ori));\n    #print \" --------------- $dnamut_start -$len-  $dnamut_end -\\n\";\n    $seqDiff->add_Variant($dnamut);\n    $self->dnamut($dnamut);\n    $dnamut->mut_number($self->mutation->issue);\n    # setting proof\n    if ($seqDiff->numbering eq \"entry\" or $seqDiff->numbering eq \"gene\") {\n\t $dnamut->proof('experimental');\n    } else {\n\t $dnamut->proof('computed');\n    }\n    # how many nucleotides to store upstream and downstream of the change\n    my $flanklen = $self->{'flanklen'};\n    #print  `date`, \" flanking sequences start\\n\";\n    my $uplabel = $self->DNA->label(1-$flanklen,$self->mutation->prelabel); # this could be unavailable!\n\n    my $upstreamseq;\n    if ($uplabel > 0) {\n\t $upstreamseq =\n\t     $self->DNA->labelsubseq($uplabel, undef, $self->mutation->prelabel);\n    } else { # from start (less than $flanklen nucleotides)\n\t $upstreamseq =\n\t     $self->DNA->labelsubseq($self->DNA->start, undef, $self->mutation->prelabel);\n    }\n    $dnamut->upStreamSeq($upstreamseq);\n    my $dnstreamseq = $self->DNA->labelsubseq($self->mutation->postlabel, $flanklen);\n    $dnamut->dnStreamSeq($dnstreamseq); # $flanklen or less nucleotides\n    return $dnamut;\n}\n\n\n#\n### Check if mutation propagates to RNA (and AA) level\n#  \n# side effect: sets intron/exon information\n# returns a boolean value\n#\n\nsub _rnaAffected {\n    my ($self) = @_;\n    my @exons=$self->RNA->all_Exons;\n    my $RNAstart=$self->RNA->start;\n    my $RNAend=$self->RNA->end;\n    my ($firstexon,$before,$after,$i);\n    my ($rnaAffected) = 0;\n\n    # check for inserted labels (that require follows instead of <,>)\n    my $DNAend=$self->RNA->{'seq'}->end;\n    if ($self->mutation->prelabel > $DNAend or $self->mutation->postlabel > $DNAend) {\n\t #this means one of the two labels is an inserted one\n\t #(coming from a previous mutation. This would falsify all <,>\n\t #checks, so the follow() has to be used\n\t $self->warn(\"Attention, workaround not fully tested yet! Expect unpredictable results.\\n\");\n\t if (($self->mutation->postlabel==$RNAstart) or (follows($self->mutation->postlabel,$RNAstart))) {\n\t     $self->warn(\"RNA not affected because change occurs before RNAstart\");\n\t }\n\t elsif (($RNAend==$self->mutation->prelabel) or (follows($RNAend,$self->mutation->prelabel))) {\n\t     $self->warn(\"RNA not affected because change occurs after RNAend\");\n\t }\n\t elsif (scalar @exons == 1) {\n\t     #no introns, just one exon\n\t     $rnaAffected = 1; # then RNA is affected!\n\t } else {\n\t     # otherwise check for change occurring inside an intron\n\t     $firstexon=shift(@exons);\n\t     $before=$firstexon->end;\n\t\n\t     foreach $i (0..$#exons) {\n\t\t $after=$exons[$i]->start;\n\t\t if (follows($self->mutation->prelabel,$before) or\n\t\t\t($after==$self->mutation->prelabel) or\n\t\t\tfollows($after,$self->mutation->prelabel) or\n\t\t\tfollows($after,$self->mutation->postlabel)) {\n\n\t\t     $rnaAffected = 1;\n\t\t     # $i is number of exon and can be used for proximity check\n\t\t }\n\t\t $before=$exons[$i]->end;\n\t     }\n\t\n\t }\n    } else {\n\tmy $strand = $exons[0]->strand;\n\tif (($strand == 1 and $self->mutation->postlabel <= $RNAstart) or\n\t    ($strand != 1 and $self->mutation->postlabel >= $RNAstart)) {\n\t    #$self->warn(\"RNA not affected because change occurs before RNAstart\");\n\t    $rnaAffected = 0;\n\t}\n\telsif (($strand == 1 and $self->mutation->prelabel >= $RNAend) or\n\t\t($strand != 1 and $self->mutation->prelabel <= $RNAend)) {\n\t     #$self->warn(\"RNA not affected because change occurs after RNAend\");\n\t     $rnaAffected = 0;\n\t     my $dist;\n\t     if ($strand == 1){\n\t\t $dist = $self->mutation->prelabel - $RNAend;\n\t     } else {\n\t\t $dist = $RNAend - $self->mutation->prelabel;\n\t     }\n\t     $self->dnamut->region_dist($dist);\n\t }\n\t elsif (scalar @exons == 1) {\n\t     #if just one exon -> no introns, \n\t     $rnaAffected = 1; # then RNA is affected!\n\t } else {\t\n\t     # otherwise check for mutation occurring inside an intron\n\t     $firstexon=shift(@exons);\n\t     $before=$firstexon->end;\n\t     if ( ($strand == 1 and $self->mutation->prelabel < $before) or \n\t\t  ($strand == -1 and $self->mutation->prelabel > $before) \n\t\t  ) {\n\t\t $rnaAffected = 1 ;\n\n\t\t #print \"Exon 1 : \", $firstexon->start, \" - \", $firstexon->end, \"<br>\\n\";\n\t\t my $afterdist = $self->mutation->prelabel - $firstexon->start;\n\t\t my $beforedist =  $firstexon->end - $self->mutation->postlabel;\n\t\t my $exonvalue = $i + 1;\n\t\t $self->dnamut->region('exon');\n\t\t $self->dnamut->region_value($exonvalue);\n\t\t if ($afterdist < $beforedist) {\n\t\t     $afterdist++; \t\t  \n\t\t     $afterdist++;\n\t\t     $self->dnamut->region_dist($afterdist);\n\t\t     #print \"splice site $afterdist nt upstream!<br>\";\n\t\t } else {\n\t\t     $self->dnamut->region_dist($beforedist);\n\t\t     #print \"splice site $beforedist nt downstream!<br>\";\n\t\t }\n\t     } else {\n\t\t #print \"first exon  : \", $firstexon->start, \" - \", $firstexon->end, \"<br>\\n\";\n\t\t foreach $i (0..$#exons) {\n\t\t     $after=$exons[$i]->start;\n\t\t     #proximity test for intronic mutations\n\t\t     if ( ($strand == 1 and \n\t\t\t   $self->mutation->prelabel >=  $before and \n\t\t\t   $self->mutation->postlabel <= $after) \n\t\t\t  or\n\t\t\t  ($strand == -1 and \n\t\t\t   $self->mutation->prelabel <=  $before and \n\t\t\t   $self->mutation->postlabel >= $after)  ) {\n\t\t\t $self->dnamut->region('intron');\n\t\t\t #$self->dnamut->region_value($i);\n\t\t\t my $afterdist = $self->mutation->prelabel - $before;\n\t\t\t my $beforedist =  $after - $self->mutation->postlabel;\n\t\t\t my $intronvalue = $i + 1;\n\t\t\t if ($afterdist < $beforedist) {\n\t\t\t     $afterdist++;\n\t\t\t     $self->dnamut->region_value($intronvalue);\n\t\t\t     $self->dnamut->region_dist($afterdist);\n\t\t\t     #print \"splice site $afterdist nt upstream!<br>\";\n\t\t\t } else {\n\t\t\t     $self->dnamut->region_value($intronvalue);\n\t\t\t     $self->dnamut->region_dist($beforedist * -1);\n\t\t\t     #print \"splice site $beforedist nt downstream!<br>\";\n\t\t\t }\n\t\t\t $self->rnachange(undef);\n\t\t\t last;\n\t\t     } \n\t\t     #proximity test for exon mutations\n\t\t     #proximity test for exon mutations\n\t\t     elsif ( ( $strand == 1 and \n\t\t\t       $exons[$i]->start < $self->mutation->prelabel and \n\t\t\t       $exons[$i]->end > $self->mutation->prelabel) or \n\t\t\t     ( $strand == 1 and \n\t\t\t       $exons[$i]->start < $self->mutation->postlabel and \n\t\t\t       $exons[$i]->end > $self->mutation->postlabel) or \n\t\t\t     ( $strand == -1 and \n\t\t\t       $exons[$i]->start > $self->mutation->prelabel and \n\t\t\t       $exons[$i]->end < $self->mutation->prelabel) or\n\t\t\t     ( $strand == -1 and \n\t\t\t       $exons[$i]->start > $self->mutation->postlabel and \n\t\t\t       $exons[$i]->end < $self->mutation->postlabel) ) {\n\t\t\t $rnaAffected = 1;\n\n\t\t\t my $afterdist = $self->mutation->prelabel - $exons[$i]->start;\n\t\t\t my $beforedist =  $exons[$i]->end - $self->mutation->postlabel;\n\t\t\t my $exonvalue = $i + 1;\n\t\t\t $self->dnamut->region('exon');\n\t\t\t if ($afterdist < $beforedist) {\n\t\t\t     $afterdist++;\n\t\t\t     $self->dnamut->region_value($exonvalue+1);\n\t\t\t     $self->dnamut->region_dist($afterdist);\n\t\t\t     #print \"splice site $afterdist nt upstream!<br>\";\n\t\t\t } else {\n\t\t\t     #$beforedist;\n\t\t\t     $self->dnamut->region_value($exonvalue+1);\n\t\t\t     $self->dnamut->region_dist($beforedist * -1);\n\t\t\t     #print \"splice site $beforedist nt downstream!<br>\";\n\t\t\t }\n\t\t\t last;\n\t\t     }\n\t\t     $before=$exons[$i]->end;\n\t\t }\n\t     }\n\t }\n     }\n    #$self->warn(\"RNA not affected because change occurs inside an intron\");\n    #return(0); # if still not returned, then not affected, return 0\n    return $rnaAffected;\n}\n\n#\n# ### Creation of RNA and AA variation objects\n#\n\n=head2 _set_effects\n\n Title   : _set_effects\n Usage   :\n Function:\n\n           Stores RNA and AA level mutation attributes before mutation\n           into Bio::Variation::RNAChange and\n           Bio::Variation::AAChange objects.  Links them to\n           SeqDiff object.\n\n Example :\n Returns :\n Args    : Bio::Variation::SeqDiff object\n           Bio::Variation::DNAMutation object\n\nSee L<Bio::Variation::RNAChange>, L<Bio::Variation::RNAChange>,\nL<Bio::Variation::SeqDiff>, and L<Bio::Variation::DNAMutation>.","parameters":[{"label":"$self"},{"label":"$seqDiff"},{"label":"$dnamut"}]},"detail":"($self,$seqDiff,$dnamut)","name":"_set_effects","range":{"start":{"line":1146,"character":0},"end":{"line":1259,"character":9999}}},{"name":"Bio","containerName":"Variation::RNAChange","kind":12,"line":1154},{"line":1220,"kind":12,"containerName":"Variation::AAChange","name":"Bio"},{"kind":12,"line":1233,"name":"Bio","containerName":"Variation::Allele"},{"line":1237,"kind":12,"containerName":"length","name":"CORE"},{"containerName":"Variation::Allele","name":"Bio","kind":12,"line":1239},{"name":"Bio","containerName":"Variation::Allele","kind":12,"line":1251},{"kind":12,"line":1281,"children":[{"localvar":"my","containerName":"_untranslated","name":"$self","definition":"my","line":1282,"kind":13},{"kind":13,"line":1282,"containerName":"_untranslated","name":"$seqDiff"},{"kind":13,"line":1282,"containerName":"_untranslated","name":"$dnamut"},{"line":1283,"kind":13,"localvar":"my","containerName":"_untranslated","name":"$rnapos_end","definition":"my"},{"name":"$self","containerName":"_untranslated","kind":13,"line":1284},{"line":1284,"kind":12,"containerName":"_untranslated","name":"mutation"},{"name":"len","containerName":"_untranslated","line":1284,"kind":12},{"line":1285,"kind":13,"name":"$rnapos_end","containerName":"_untranslated"},{"name":"$self","containerName":"_untranslated","line":1285,"kind":13},{"name":"mutation","containerName":"_untranslated","line":1285,"kind":12},{"containerName":"_untranslated","name":"transpos","line":1285,"kind":12},{"line":1286,"kind":13,"name":"$rnapos_end","containerName":"_untranslated"},{"name":"$self","containerName":"_untranslated","kind":13,"line":1286},{"name":"mutation","containerName":"_untranslated","line":1286,"kind":12},{"kind":12,"line":1286,"containerName":"_untranslated","name":"transpos"},{"containerName":"_untranslated","name":"$self","line":1286,"kind":13},{"name":"mutation","containerName":"_untranslated","kind":12,"line":1286},{"name":"len","containerName":"_untranslated","kind":12,"line":1286},{"line":1287,"kind":13,"localvar":"my","containerName":"_untranslated","definition":"my","name":"$rnachange"},{"name":"new","containerName":"_untranslated","kind":12,"line":1287},{"containerName":"_untranslated","name":"$self","line":1287,"kind":13},{"line":1287,"kind":12,"containerName":"_untranslated","name":"mutation"},{"line":1287,"kind":12,"name":"transpos","containerName":"_untranslated"},{"containerName":"_untranslated","name":"$rnapos_end","line":1289,"kind":13},{"containerName":"_untranslated","name":"$rnachange","line":1292,"kind":13},{"line":1292,"kind":12,"containerName":"_untranslated","name":"isMutation"},{"name":"$ra_o","definition":"my","containerName":"_untranslated","localvar":"my","kind":13,"line":1293},{"line":1293,"kind":12,"containerName":"_untranslated","name":"new"},{"kind":13,"line":1294,"name":"$ra_o","containerName":"_untranslated"},{"name":"seq","containerName":"_untranslated","kind":12,"line":1294},{"name":"$dnamut","containerName":"_untranslated","kind":13,"line":1294},{"line":1294,"kind":12,"name":"allele_ori","containerName":"_untranslated"},{"name":"seq","containerName":"_untranslated","kind":12,"line":1294},{"containerName":"_untranslated","name":"$dnamut","kind":13,"line":1294},{"line":1294,"kind":12,"containerName":"_untranslated","name":"allele_ori"},{"line":1294,"kind":12,"containerName":"_untranslated","name":"seq"},{"name":"$rnachange","containerName":"_untranslated","line":1295,"kind":13},{"name":"allele_ori","containerName":"_untranslated","line":1295,"kind":12},{"name":"$ra_o","containerName":"_untranslated","kind":13,"line":1295},{"line":1296,"kind":13,"localvar":"my","definition":"my","name":"$ra_m","containerName":"_untranslated"},{"line":1296,"kind":12,"name":"new","containerName":"_untranslated"},{"containerName":"_untranslated","name":"$ra_m","line":1297,"kind":13},{"name":"seq","containerName":"_untranslated","kind":12,"line":1297},{"line":1297,"kind":13,"name":"$dnamut","containerName":"_untranslated"},{"containerName":"_untranslated","name":"allele_mut","line":1297,"kind":12},{"name":"seq","containerName":"_untranslated","kind":12,"line":1297},{"line":1297,"kind":13,"name":"$dnamut","containerName":"_untranslated"},{"containerName":"_untranslated","name":"allele_mut","line":1297,"kind":12},{"name":"seq","containerName":"_untranslated","line":1297,"kind":12},{"line":1298,"kind":13,"containerName":"_untranslated","name":"$rnachange"},{"containerName":"_untranslated","name":"allele_mut","kind":12,"line":1298},{"containerName":"_untranslated","name":"$ra_m","line":1298,"kind":13},{"containerName":"_untranslated","name":"$rnachange","line":1299,"kind":13},{"line":1299,"kind":12,"name":"add_Allele","containerName":"_untranslated"},{"name":"$ra_m","containerName":"_untranslated","kind":13,"line":1299},{"name":"$rnachange","containerName":"_untranslated","line":1300,"kind":13},{"name":"upStreamSeq","containerName":"_untranslated","kind":12,"line":1300},{"name":"$dnamut","containerName":"_untranslated","line":1300,"kind":13},{"line":1300,"kind":12,"containerName":"_untranslated","name":"upStreamSeq"},{"name":"$rnachange","containerName":"_untranslated","line":1301,"kind":13},{"kind":12,"line":1301,"name":"dnStreamSeq","containerName":"_untranslated"},{"name":"$dnamut","containerName":"_untranslated","line":1301,"kind":13},{"containerName":"_untranslated","name":"dnStreamSeq","line":1301,"kind":12},{"containerName":"_untranslated","name":"$rnachange","line":1302,"kind":13},{"line":1302,"kind":12,"containerName":"_untranslated","name":"length"},{"containerName":"_untranslated","name":"$dnamut","line":1302,"kind":13},{"name":"length","containerName":"_untranslated","kind":12,"line":1302},{"containerName":"_untranslated","name":"$rnachange","line":1303,"kind":13},{"kind":12,"line":1303,"name":"mut_number","containerName":"_untranslated"},{"name":"$dnamut","containerName":"_untranslated","line":1303,"kind":13},{"kind":12,"line":1303,"name":"mut_number","containerName":"_untranslated"},{"line":1305,"kind":13,"name":"$seqDiff","containerName":"_untranslated"},{"name":"numbering","containerName":"_untranslated","line":1305,"kind":12},{"kind":13,"line":1306,"name":"$rnachange","containerName":"_untranslated"},{"name":"proof","containerName":"_untranslated","line":1306,"kind":12},{"kind":13,"line":1308,"containerName":"_untranslated","name":"$rnachange"},{"kind":12,"line":1308,"containerName":"_untranslated","name":"proof"},{"kind":13,"line":1311,"name":"$dist","definition":"my","containerName":"_untranslated","localvar":"my"},{"line":1312,"kind":13,"name":"$rnachange","containerName":"_untranslated"},{"kind":12,"line":1312,"containerName":"_untranslated","name":"end"},{"name":"$rnachange","containerName":"_untranslated","kind":13,"line":1313},{"line":1313,"kind":12,"containerName":"_untranslated","name":"region"},{"kind":13,"line":1314,"name":"$dnamut","containerName":"_untranslated"},{"containerName":"_untranslated","name":"region","line":1314,"kind":12},{"containerName":"_untranslated","definition":"my","name":"$dist","localvar":"my","kind":13,"line":1315},{"kind":13,"line":1315,"containerName":"_untranslated","name":"$dnamut"},{"kind":12,"line":1315,"name":"end","containerName":"_untranslated"},{"name":"$dnamut","containerName":"_untranslated","line":1316,"kind":13},{"name":"region_dist","containerName":"_untranslated","line":1316,"kind":12},{"name":"$dist","containerName":"_untranslated","kind":13,"line":1316},{"containerName":"_untranslated","name":"$dist","line":1317,"kind":13},{"kind":13,"line":1317,"name":"$seqDiff","containerName":"_untranslated"},{"name":"offset","containerName":"_untranslated","kind":12,"line":1317},{"containerName":"_untranslated","name":"$self","kind":13,"line":1317},{"containerName":"_untranslated","name":"gene","line":1317,"kind":12},{"kind":12,"line":1317,"name":"maxtranscript","containerName":"_untranslated"},{"line":1317,"kind":12,"containerName":"_untranslated","name":"start"},{"containerName":"_untranslated","name":"$dist","kind":13,"line":1317},{"kind":13,"line":1318,"name":"$rnachange","containerName":"_untranslated"},{"kind":12,"line":1318,"name":"region_dist","containerName":"_untranslated"},{"kind":13,"line":1318,"containerName":"_untranslated","name":"$dist"},{"containerName":"_untranslated","name":"$dist","kind":13,"line":1319},{"containerName":"_untranslated","name":"$rnachange","line":1321,"kind":13},{"line":1321,"kind":12,"containerName":"_untranslated","name":"region"},{"line":1322,"kind":13,"name":"$dnamut","containerName":"_untranslated"},{"line":1322,"kind":12,"containerName":"_untranslated","name":"region"},{"line":1323,"kind":13,"localvar":"my","containerName":"_untranslated","definition":"my","name":"$dist"},{"containerName":"_untranslated","name":"$dnamut","line":1323,"kind":13},{"containerName":"_untranslated","name":"start","line":1323,"kind":12},{"kind":13,"line":1323,"containerName":"_untranslated","name":"$seqDiff"},{"kind":12,"line":1323,"containerName":"_untranslated","name":"cds_end"},{"kind":13,"line":1323,"containerName":"_untranslated","name":"$seqDiff"},{"name":"offset","containerName":"_untranslated","kind":12,"line":1323},{"line":1324,"kind":13,"name":"$dnamut","containerName":"_untranslated"},{"line":1324,"kind":12,"name":"region_dist","containerName":"_untranslated"},{"name":"$dist","containerName":"_untranslated","line":1324,"kind":13},{"kind":13,"line":1325,"name":"$dist","containerName":"_untranslated"},{"containerName":"_untranslated","name":"$seqDiff","line":1325,"kind":13},{"kind":12,"line":1325,"containerName":"_untranslated","name":"cds_end"},{"line":1325,"kind":13,"name":"$self","containerName":"_untranslated"},{"kind":12,"line":1325,"containerName":"_untranslated","name":"gene"},{"line":1325,"kind":12,"name":"maxtranscript","containerName":"_untranslated"},{"name":"end","containerName":"_untranslated","kind":12,"line":1325},{"line":1325,"kind":13,"name":"$dist","containerName":"_untranslated"},{"containerName":"_untranslated","name":"$rnachange","line":1326,"kind":13},{"containerName":"_untranslated","name":"region_dist","kind":12,"line":1326},{"line":1326,"kind":13,"containerName":"_untranslated","name":"$dist"},{"containerName":"_untranslated","name":"$dist","kind":13,"line":1327},{"name":"$seqDiff","containerName":"_untranslated","kind":13,"line":1329},{"name":"add_Variant","containerName":"_untranslated","line":1329,"kind":12},{"name":"$rnachange","containerName":"_untranslated","line":1329,"kind":13},{"kind":13,"line":1330,"containerName":"_untranslated","name":"$self"},{"line":1330,"kind":12,"name":"rnachange","containerName":"_untranslated"},{"line":1330,"kind":13,"name":"$rnachange","containerName":"_untranslated"},{"line":1331,"kind":13,"containerName":"_untranslated","name":"$rnachange"},{"line":1331,"kind":12,"containerName":"_untranslated","name":"DNAMutation"},{"line":1331,"kind":13,"containerName":"_untranslated","name":"$dnamut"},{"name":"$dnamut","containerName":"_untranslated","kind":13,"line":1332},{"containerName":"_untranslated","name":"RNAChange","line":1332,"kind":12},{"kind":13,"line":1332,"containerName":"_untranslated","name":"$rnachange"}],"containerName":"main::","definition":"sub","detail":"($self,$seqDiff,$dnamut)","signature":{"documentation":"1;\n# $Id: Mutator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Mutator\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Mutator - Package mutating LiveSequences\n\n=head1 SYNOPSIS\n\n  # $gene is a Bio::LiveSeq::Gene object\n  my $mutate = Bio::LiveSeq::Mutator->new('-gene' => $gene,\n  \t\t\t\t\t  '-numbering' => \"coding\"\n  \t\t\t\t\t   );\n  # $mut is a Bio::LiveSeq::Mutation object\n  $mutate->add_Mutation($mut);\n  # $results is a Bio::Variation::SeqDiff object\n  my $results=$mutate->change_gene();\n  if ($results) {\n      my $out = Bio::Variation::IO->new( '-format' => 'flat');\n      $out->write($results);\n  }\n\n=head1 DESCRIPTION\n\nThis class mutates Bio::LiveSeq::Gene objects and returns a\nBio::Variation::SeqDiff object. Mutations are described as\nBio::LiveSeq::Mutation objects. See L<Bio::LiveSeq::Gene>,\nL<Bio::Variation::SeqDiff>, and L<Bio::LiveSeq::Mutation> for details.\n\n=head1 FEEDBACK\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho & Joseph A.L. Insana\n\n  Email:  heikki-at-bioperl-dot-org\n          insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\n  The rest of the documentation details each of the object\n  methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Mutator;\nuse strict;\n\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\nuse Bio::LiveSeq::Mutation;\n\n#use integer;\n# Object preamble - inheritance\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self;\n    $self = {};\n    bless $self, $class;\n\n    my ($gene, $numbering) =\n\t    $self->_rearrange([qw(GENE\n\t\t\t\t  NUMBERING\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->{ 'mutations' } = [];\n\n    $gene && $self->gene($gene);\n    $numbering && $self->numbering($numbering);\n\n    #class constant;\n    $self->{'flanklen'} = 25;\n    return $self; # success - we hope!\n}\n\n=head2 gene\n\n Title   : gene\n Usage   : $mutobj = $obj->gene;\n         : $mutobj = $obj->gene($objref);\n Function:\n\n           Returns or sets the link-reference to a\n           Bio::LiveSeq::Gene object. If no value has ben set, it\n           will return undef\n\n Returns : an object reference  or undef\n Args    : a Bio::LiveSeq::Gene\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\nsub gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Gene object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'gene'} = $value;\n      }\n  }\n  unless (exists $self->{'gene'}) {\n      return;\n  } else {\n      return $self->{'gene'};\n  }\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering();\n Function:\n\n            Sets and returns coordinate system used in positioning the\n            mutations. See L<change_gene> for details.\n\n Example :\n Returns : string\n Args    : string (coding [transcript number] | gene | entry)\n\n\n\nsub numbering {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif ($value =~ /(coding)( )?(\\d+)?/ or $value eq 'entry' or $value eq 'gene') {\n\t    $self->{'numbering'} = $value;\n\t} else { # defaulting to 'coding'\n\t    $self->{'numbering'} = 'coding';\n\t}\n    }\n    unless (exists $self->{'numbering'}) {\n\treturn 'coding';\n    } else {\n\treturn $self->{'numbering'};\n    }\n}\n\n=head2 add_Mutation\n\n Title   : add_Mutation\n Usage   : $self->add_Mutation($ref)\n Function: adds a Bio::LiveSeq::Mutation object\n Example :\n Returns :\n Args    : a Bio::LiveSeq::Mutation\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub add_Mutation{\n    my ($self,$value) = @_;\n    if( $value->isa('Bio::Liveseq::Mutation') ) {\n\tmy $com = ref $value;\n\t$self->throw(\"Is not a Mutation object but a [$com]\" );\n\treturn;\n    }\n    if (! $value->pos) {\n\t$self->warn(\"No value for mutation position in the sequence!\");\n\treturn;\n    }\n    if (! $value->seq && ! $value->len) {\n\t$self->warn(\"Either mutated sequence or length of the deletion must be given!\");\n\treturn;\n    }\n    push(@{$self->{'mutations'}},$value);\n}\n\n=head2 each_Mutation\n\n Title   : each_Mutation\n Usage   : foreach $ref ( $a->each_Mutation )\n Function: gets an array of Bio::LiveSeq::Mutation objects\n Example :\n Returns : array of Mutations\n Args    :\n\nSee L<Bio::LiveSeq::Mutation> for more information.\n\n\nsub each_Mutation{\n   my ($self) = @_;\n   return @{$self->{'mutations'}};\n}\n\n\n=head2 mutation\n\n Title   : mutation\n Usage   : $mutobj = $obj->mutation;\n         : $mutobj = $obj->mutation($objref);\n Function:\n\n           Returns or sets the link-reference to the current mutation\n           object.  If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub mutation {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Mutation') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::Mutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'mutation'} = $value;\n      }\n  }\n  unless (exists $self->{'mutation'}) {\n      return;\n  } else {\n      return $self->{'mutation'};\n  }\n}\n\n=head2 DNA\n\n Title   : DNA\n Usage   : $mutobj = $obj->DNA;\n         : $mutobj = $obj->DNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If there is no link, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference or undef\n\n\nsub DNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::DNA') and ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::DNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'DNA'} = $value;\n      }\n  }\n  unless (exists $self->{'DNA'}) {\n      return;\n  } else {\n      return $self->{'DNA'};\n  }\n}\n\n\n=head2 RNA\n\n Title   : RNA\n Usage   : $mutobj = $obj->RNA;\n         : $mutobj = $obj->RNA($objref);\n Function:\n\n           Returns or sets the reference to the LiveSeq object holding\n           the reference sequence. If the value is not set, it will return\n           undef.\n           Internal method.\n\n Returns : an object reference  or undef\n\n\n\nsub RNA {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Transcript') ) {\n\t  $self->throw(\"Is not a Bio::LiveSeq::RNA/Transcript object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNA'} = $value;\n      }\n  }\n  unless (exists $self->{'RNA'}) {\n      return;\n  } else {\n      return $self->{'RNA'};\n  }\n}\n\n\n=head2 dnamut\n\n Title   : dnamut\n Usage   : $mutobj = $obj->dnamut;\n         : $mutobj = $obj->dnamut($objref);\n Function:\n\n           Returns or sets the reference to the current DNAMutation object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::DNAMutation object or undef\n\nSee L<Bio::Variation::DNAMutation> for more information.\n\n\n\nsub dnamut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::DNAMutation') ) {\n\t  $self->throw(\"Is not a Bio::Variation::DNAMutation object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'dnamut'} = $value;\n      }\n  }\n  unless (exists $self->{'dnamut'}) {\n      return;\n  } else {\n      return $self->{'dnamut'};\n  }\n}\n\n\n=head2 rnachange\n\n Title   : rnachange\n Usage   : $mutobj = $obj->rnachange;\n         : $mutobj = $obj->rnachange($objref);\n Function:\n\n           Returns or sets the reference to the current RNAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::RNAChange object or undef\n\nSee L<Bio::Variation::RNAChange> for more information.\n\n\n\nsub rnachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'rnachange'} = $value;\n      }\n  }\n  unless (exists $self->{'rnachange'}) {\n      return;\n  } else {\n      return $self->{'rnachange'};\n  }\n}\n\n\n=head2 aachange\n\n Title   : aachange\n Usage   : $mutobj = $obj->aachange;\n         : $mutobj = $obj->aachange($objref);\n Function:\n\n           Returns or sets the reference to the current AAChange object.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : a Bio::Variation::AAChange object or undef\n\nSee L<Bio::Variation::AAChange> for more information.\n\n\n\nsub aachange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::AAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::AAChange object but a [$value]\");\n\t  return;\n      }\n      else {\n\t  $self->{'aachange'} = $value;\n      }\n  }\n  unless (exists $self->{'aachange'}) {\n      return;\n  } else {\n      return $self->{'aachange'};\n  }\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $mutobj = $obj->exons;\n         : $mutobj = $obj->exons($objref);\n Function:\n\n           Returns or sets the reference to a current array of Exons.\n           If the value is not set, it will return undef.\n           Internal method.\n\n Returns : an array of Bio::LiveSeq::Exon objects or undef\n\nSee L<Bio::LiveSeq::Exon> for more information.\n\n\n\nsub exons {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'exons'} = $value;\n  }\n  unless (exists $self->{'exons'}) {\n      return;\n  } else {\n      return $self->{'exons'};\n  }\n}\n\n=head2 change_gene_with_alignment\n\n Title   : change_gene_with_alignment\n Usage   : $results=$mutate->change_gene_with_alignment($aln);\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes in the alignment. The alignment has\n           to be pairwise and have one sequence named 'QUERY', the\n           other one is assumed to be a part of the sequence from\n           $gene.\n\n           This method offers a shortcut to change_gene and\n           automates the creation of Bio::LiveSeq::Mutation objects.\n           Use it with almost identical sequnces, e.g. to locate a SNP.\n\n Args    : Bio::SimpleAlign object representing a short local alignment\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\nSee L<Bio::LiveSeq::Mutation>, L<Bio::SimpleAlign>, and\nL<Bio::Variation::SeqDiff>  for more information.\n\n\nsub change_gene_with_alignment {\n    my ($self, $aln) = @_;\n\n    #\n    # Sanity checks\n    #\n\n    $self->throw(\"Argument is not a Bio::SimpleAlign object but a [$aln]\")\n\tunless $aln->isa('Bio::SimpleAlign');\n    $self->throw(\"'Pairwise alignments only, please\") \n\tif $aln->no_sequences != 2;\n\n    # find out the order the two sequences are given\n    my $queryseq_pos = 1; #default\n    my $refseq_pos = 2;\n    unless ($aln->get_seq_by_pos(1)->id eq 'QUERY') {\n\tcarp('Query sequence has to be named QUERY') \n\t    if $aln->get_seq_by_pos(2)->id ne 'QUERY';\n\t$queryseq_pos = 2; # alternative\n\t$refseq_pos = 1;\n    }\n\n    # trim the alignment\n    my $start =  $aln->column_from_residue_number('QUERY', 1);\n    my $end =  $aln->column_from_residue_number('QUERY', \n\t\t\t\t\t\t$aln->get_seq_by_pos($queryseq_pos)->end );\n    \n    my $aln2 = $aln->slice($start, $end);\n\n    #\n    # extracting mutations\n    #\n\n    my $cs = $aln2->consensus_string(51);\n    my $queryseq = $aln2->get_seq_by_pos($queryseq_pos);\n    my $refseq = $aln2->get_seq_by_pos($refseq_pos);\n\n    while ( $cs =~ /(\\?+)/g) {\n\t# pos in local coordinates\n\tmy $pos = pos($cs) - length($1) + 1;\n\tmy $mutation = create_mutation($self, \n\t\t\t\t       $refseq, \n\t\t\t\t       $queryseq, \n\t\t\t\t       $pos, \n\t\t\t\t       CORE::length($1)\n\t\t\t\t       );\n\t# reset pos to refseq coordinates\n\t$pos +=  $refseq->start - 1;\n\t$mutation->pos($pos);\n\n        $self->add_Mutation($mutation);\n    }\n    return $self->change_gene();\n}\n\n=head2 create_mutation\n\n Title   : create_mutation\n Usage   : \n Function:\n\n           Formats sequence differences from two sequences into\n           Bio::LiveSeq::Mutation objects which can be applied to a\n           gene.\n\n           To keep it generic, sequence arguments need not to be\n           Bio::LocatableSeq. Coordinate change to parent sequence\n           numbering needs to be done by the calling code.\n\n           Called from change_gene_with_alignment\n\n Args    : Bio::PrimarySeqI inheriting object for the reference sequence\n           Bio::PrimarySeqI inheriting object for the query sequence\n           integer for the start position of the local sequence difference\n           integer for the length of the sequence difference\n Returns : Bio::LiveSeq::Mutation object \n\n\nsub create_mutation {\n    my ($self, $refseq, $queryseq, $pos, $len) = @_;\n    \n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$refseq]\") \n\tunless $refseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Is not a Bio::PrimarySeqI object but a [$queryseq]\") \n\tunless $queryseq->isa('Bio::PrimarySeqI');\n    $self->throw(\"Position is not a positive integer but [$pos]\") \n\tunless $pos =~ /^\\+?\\d+$/;\n    $self->throw(\"Length is not a positive integer but [$len]\") \n\tunless $len =~ /^\\+?\\d+$/;\n\n    my $mutation;\n    my $refstring = $refseq->subseq($pos, $pos + $len - 1);\n    my $varstring = $queryseq->subseq($pos, $pos + $len - 1);\n    \n    if ($len == 1 and $refstring =~ /[^\\.\\-\\*\\?]/ and \n\t$varstring  =~ /[^\\.\\-\\*\\?]/ ) { #point\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring =~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  !~ /^[^\\.\\-\\*\\?]+$/ ) { # deletion\n\t$mutation = Bio::LiveSeq::Mutation->new(-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    elsif ( $refstring !~ /^[^\\.\\-\\*\\?]+$/ and \n\t    $varstring  =~ /^[^\\.\\-\\*\\?]+$/ ) { # insertion\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => 0\n\t\t\t\t\t\t);\n    } else { # complex\n\t$mutation = Bio::LiveSeq::Mutation->new(-seq => $varstring,\n\t\t\t\t\t\t-pos => $pos,\n\t\t\t\t\t\t-len => $len\n\t\t\t\t\t\t);\n    }\n    \n    return $mutation;\n}\n\n=head2 change_gene\n\n Title   : change_gene\n Usage   : my $mutate = Bio::LiveSeq::Mutator->new(-gene => $gene,\n\t\t\t\t\t\t   numbering => \"coding\"\n\t\t\t\t\t\t   );\n           # $mut is Bio::LiveSeq::Mutation object\n           $mutate->add_Mutation($mut);\n           my $results=$mutate->change_gene();\n\n Function:\n\n           Returns a Bio::Variation::SeqDiff object containing the\n           results of the changes performed according to the\n           instructions present in Mutation(s).  The -numbering\n           argument decides what molecule is being changed and what\n           numbering scheme being used:\n\n            -numbering => \"entry\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the sequence\n\n            -numbering => \"coding\"\n\n               determines the RNA level, using the numbering from the\n               beginning of the 1st transcript\n\n               Alternative transcripts can be used by specifying\n               \"coding 2\" or \"coding 3\" ...\n\n            -numbering => \"gene\"\n\n               determines the DNA level, using the numbering from the\n               beginning of the 1st transcript and inluding introns.\n               The meaning equals 'coding' if the reference molecule\n               is cDNA.\n\n Args    : Bio::LiveSeq::Gene object\n           Bio::LiveSeq::Mutation object(s)\n           string specifying a numbering scheme (defaults to 'coding')\n Returns : Bio::Variation::SeqDiff object or 0 on error\n\n\nsub change_gene {\n    my ($self) = @_;\n\n    #\n    # Sanity check\n    #\n    unless ($self->gene) {\n\t$self->warn(\"Input object Bio::LiveSeq::Gene is not given\");\n\treturn 0;\n    }\n    #\n    # Setting the reference sequence based on -numbering\n    #\n    my @transcripts=@{$self->gene->get_Transcripts};\n    my $refseq; # will hold Bio::LiveSeq:Transcript object or Bio::LiveSeq::DNA\n\n    # 'gene' eq 'coding' if reference sequence is cDNA\n    $self->numbering ('coding') if $self->gene->get_DNA->alphabet eq 'rna' and $self->numbering eq 'gene';\n\n    if ($self->numbering =~ /(coding)( )?(\\d+)?/ ) {\n\t$self->numbering($1);\n\tmy $transnumber = $3;\n\t$transnumber-- if $3; # 1 -> 0, 2 -> 1\n\tif ($transnumber && $transnumber >= 0 && $transnumber <= $#transcripts) {\n\t    $refseq=$transcripts[$transnumber];\n\t} else {\n\t    $transnumber && $self->warn(\"The alternative transcript number \". $transnumber+1 .\n\t    \"- does not exist. Reverting to the 1st transcript\\n\");\n\t    $refseq=$transcripts[0];\n\t}\n    } else {\n\t$refseq=$transcripts[0]->{'seq'};\n    }\n    #\n    # Recording the state: SeqDiff object creation  ?? transcript no.??\n    #\n    my $seqDiff = Bio::Variation::SeqDiff->new(-verbose => $self->verbose);\n    $seqDiff->alphabet($self->gene->get_DNA->alphabet);\n    $seqDiff->numbering($self->numbering);\n    my ($DNAobj, $RNAobj);\n    if ($refseq->isa(\"Bio::LiveSeq::Transcript\")) {\n\t$self->RNA($refseq);\n\t$self->DNA($refseq->{'seq'});\n\t$seqDiff->rna_ori($refseq->seq );\n\t$seqDiff->aa_ori($refseq->get_Translation->seq);\n    } else {\n\t$self->DNA($refseq);\n\t$self->RNA($transcripts[0]);\n\t$seqDiff->rna_ori($self->RNA->seq);\n\t$seqDiff->aa_ori($self->RNA->get_Translation->seq);\n    }\n    $seqDiff->dna_ori($self->DNA->seq);\n    # put the accession number into the SeqDiff object ID\n    $seqDiff->id($self->DNA->accession_number);\n\n    # the atg_offset takes in account that DNA object could be a subset of the\n    # whole entry (via the light_weight loader)\n    my $atg_label=$self->RNA->start;\n    my $atg_offset=$self->DNA->position($atg_label)+($self->DNA->start)-1;\n    $seqDiff->offset($atg_offset - 1);\n    $self->DNA->coordinate_start($atg_label);\n\n    my @exons = $self->RNA->all_Exons;\n    $seqDiff->cds_end($exons[$#exons]->end);\n\n    #\n    # Converting mutation positions to labels\n    #\n    $self->warn(\"no mutations\"), return 0 \n\tunless $self->_mutationpos2label($refseq, $seqDiff);\n\n    # need to add more than one rna & aa\n    #foreach $transcript (@transcripts) {\n    #  $seqDiff{\"ori_transcript_${i}_seq\"}=$transcript->seq;\n    #  $seqDiff{\"ori_translation_${i}_seq\"}=$transcript->get_Translation->seq;\n    #}\n\n    # do changes\n    my $k;\n    foreach my $mutation ($self->each_Mutation) {\n\tnext unless $mutation->label > 0;\n\t$self->mutation($mutation);\n\n\t$mutation->issue(++$k);\n\t#\n\t# current position on the transcript\n\t#\n\tif ($self->numbering =~ /coding/) {\n\t    $mutation->transpos($mutation->pos); # transpos given by user\n\t} else {\n\t    #transpos of label / It will be 0 if mutating an intron, negative if upstream of ATG\n\t    $mutation->transpos($self->RNA->position($mutation->label,$atg_label));\n\t}\n\t#\n\t# Calculate adjacent labels based on the position on the current sequence\n\t#\n\t$mutation->prelabel($self->DNA->label(-1, $mutation->label)); # 1 before label\n\tif ($mutation->len == 0) {\n\t    $mutation->postlabel($mutation->label);\n\t    $mutation->lastlabel($mutation->label);\n\t} elsif ($mutation->len == 1) {\n\t    $mutation->lastlabel($mutation->label); # last nucleotide affected\n\t    $mutation->postlabel($self->DNA->label(2,$mutation->lastlabel)); # $len after label\n\t} else {\n\t    $mutation->lastlabel($self->DNA->label($mutation->len,$mutation->label));\n\t    $mutation->postlabel($self->DNA->label(2,$mutation->lastlabel));\n\t}\n\tmy $dnamut = $self->_set_DNAMutation($seqDiff);\n\t#\n\t#\n\t#\n\tif ($self->_rnaAffected) {\n\t    $self->_set_effects($seqDiff, $dnamut);\n\t}\n\telsif ($seqDiff->offset != 0 and $dnamut->region ne 'intron') {\n\t    $self->_untranslated ($seqDiff, $dnamut);\n\t} else {\n\t    #$self->warn(\"Mutation starts outside coding region, RNAChange object not created\");\n\t}\n\n\t#########################################################################\n\t# Mutations are done here!                                              #\n\t$refseq->labelchange($mutation->seq, $mutation->label, $mutation->len); #\n\t#########################################################################\n\n\t$self->_post_mutation ($seqDiff);\n\n\t$self->dnamut(undef);\n\t$self->rnachange(undef);\n\t$self->aachange(undef);\n\t$self->exons(undef);\n    }\n    # record the final state of all three sequences\n    $seqDiff->dna_mut($self->DNA->seq);\n    $seqDiff->rna_mut($self->RNA->seq);\n    if ($refseq->isa(\"Bio::LiveSeq::Transcript\")) {\n\t$seqDiff->aa_mut($refseq->get_Translation->seq);\n    } else {\n\t$seqDiff->aa_mut($self->RNA->get_Translation->seq);\n    }\n\n    #$seqDiff{mut_dna_seq}=$gene->get_DNA->seq;\n    #my $i=1;\n    #foreach $transcript (@transcripts) {\n    #  $seqDiff{\"mut_transcript_${i}_seq\"}=$transcript->seq;\n    #  $seqDiff{\"mut_translation_${i}_seq\"}=$transcript->get_Translation->seq;\n    #}\n    return $seqDiff;\n}\n\n=head2 _mutationpos2label\n\n Title   : _mutationpos2label\n Usage   :\n Function: converts mutation positions into labels\n Example :\n Returns : number of valid mutations\n Args    : LiveSeq sequence object\n\n\nsub _mutationpos2label {\n    my ($self, $refseq, $SeqDiff) = @_;\n    my $count;\n    my @bb = @{$self->{'mutations'}};\n    my $cc = scalar @bb;\n    foreach my $mut (@{$self->{'mutations'}}) {\n#\t if ($self->numbering eq 'gene' and $mut->pos < 1) {\n#\t     my $tmp = $mut->pos;\n#\t     print STDERR \"pos: \", \"$tmp\\n\";\n#\t     $tmp++ if $tmp < 1;\n#\t     $tmp += $SeqDiff->offset;\n#\t     print STDERR \"pos2: \", \"$tmp\\n\";\n#\t     $mut->pos($tmp);\n#\t }\n#\telsif ($self->numbering eq 'entry') {\n\tif ($self->numbering eq 'entry') {\n\t    my $tmp = $mut->pos;\n\t    $tmp -= $SeqDiff->offset;\n\t    $tmp-- if $tmp < 1;\n\t    $mut->pos($tmp);\n\t}\n\n\tmy $label = $refseq->label($mut->pos); # get the label for the position\n\t$mut->label($label), $count++ if $label > 0 ;\n\t#print STDERR \"x\", $mut->pos,'|' ,$mut->label, \"\\n\";\n    }\n    return $count;\n}\n\n#\n# Calculate labels around mutated nucleotide\n#\n\n=head2 _set_DNAMutation\n\n Title   : _set_DNAMutation\n Usage   :\n Function:\n\n           Stores DNA level mutation attributes before mutation into\n           Bio::Variation::DNAMutation object.  Links it to SeqDiff\n           object.\n\n Example :\n Returns : Bio::Variation::DNAMutation object\n Args    : Bio::Variation::SeqDiff object\n\nSee L<Bio::Variation::DNAMutation> and L<Bio::Variation::SeqDiff>.\n\n\nsub _set_DNAMutation {\n    my ($self, $seqDiff) = @_;\n\n    my $dnamut_start = $self->mutation->label - $seqDiff->offset;\n    # if negative DNA positions (before ATG)\n    $dnamut_start-- if $dnamut_start <= 0;\n    my $dnamut_end;\n    ($self->mutation->len == 0 or $self->mutation->len == 1) ?\n\t($dnamut_end = $dnamut_start) :\n\t($dnamut_end = $dnamut_start+$self->mutation->len);\n    #print \"start:$dnamut_start, end:$dnamut_end\\n\";\n    my $dnamut = Bio::Variation::DNAMutation->new(-start => $dnamut_start,\n\t\t\t\t\t\t  -end => $dnamut_end,\n\t\t\t\t\t\t  );\n    $dnamut->mut_number($self->mutation->issue);\n    $dnamut->isMutation(1);\n    my $da_m = Bio::Variation::Allele->new;\n    $da_m->seq($self->mutation->seq) if $self->mutation->seq;\n    $dnamut->allele_mut($da_m);\n    $dnamut->add_Allele($da_m);\n    # allele_ori\n    my $allele_ori = $self->DNA->labelsubseq($self->mutation->prelabel,\n\t\t\t\t\t     undef,\n\t\t\t\t\t     $self->mutation->postlabel); # get seq\n    chop $allele_ori; # chop the postlabel nucleotide\n    $allele_ori=substr($allele_ori,1); # away the prelabel nucleotide\n    my $da_o = Bio::Variation::Allele->new;\n    $da_o->seq($allele_ori) if $allele_ori;\n    $dnamut->allele_ori($da_o);\n    ($self->mutation->len == 0) ?\n\t($dnamut->length($self->mutation->len)) : ($dnamut->length(CORE::length $allele_ori));\n    #print \" --------------- $dnamut_start -$len-  $dnamut_end -\\n\";\n    $seqDiff->add_Variant($dnamut);\n    $self->dnamut($dnamut);\n    $dnamut->mut_number($self->mutation->issue);\n    # setting proof\n    if ($seqDiff->numbering eq \"entry\" or $seqDiff->numbering eq \"gene\") {\n\t $dnamut->proof('experimental');\n    } else {\n\t $dnamut->proof('computed');\n    }\n    # how many nucleotides to store upstream and downstream of the change\n    my $flanklen = $self->{'flanklen'};\n    #print  `date`, \" flanking sequences start\\n\";\n    my $uplabel = $self->DNA->label(1-$flanklen,$self->mutation->prelabel); # this could be unavailable!\n\n    my $upstreamseq;\n    if ($uplabel > 0) {\n\t $upstreamseq =\n\t     $self->DNA->labelsubseq($uplabel, undef, $self->mutation->prelabel);\n    } else { # from start (less than $flanklen nucleotides)\n\t $upstreamseq =\n\t     $self->DNA->labelsubseq($self->DNA->start, undef, $self->mutation->prelabel);\n    }\n    $dnamut->upStreamSeq($upstreamseq);\n    my $dnstreamseq = $self->DNA->labelsubseq($self->mutation->postlabel, $flanklen);\n    $dnamut->dnStreamSeq($dnstreamseq); # $flanklen or less nucleotides\n    return $dnamut;\n}\n\n\n#\n### Check if mutation propagates to RNA (and AA) level\n#  \n# side effect: sets intron/exon information\n# returns a boolean value\n#\n\nsub _rnaAffected {\n    my ($self) = @_;\n    my @exons=$self->RNA->all_Exons;\n    my $RNAstart=$self->RNA->start;\n    my $RNAend=$self->RNA->end;\n    my ($firstexon,$before,$after,$i);\n    my ($rnaAffected) = 0;\n\n    # check for inserted labels (that require follows instead of <,>)\n    my $DNAend=$self->RNA->{'seq'}->end;\n    if ($self->mutation->prelabel > $DNAend or $self->mutation->postlabel > $DNAend) {\n\t #this means one of the two labels is an inserted one\n\t #(coming from a previous mutation. This would falsify all <,>\n\t #checks, so the follow() has to be used\n\t $self->warn(\"Attention, workaround not fully tested yet! Expect unpredictable results.\\n\");\n\t if (($self->mutation->postlabel==$RNAstart) or (follows($self->mutation->postlabel,$RNAstart))) {\n\t     $self->warn(\"RNA not affected because change occurs before RNAstart\");\n\t }\n\t elsif (($RNAend==$self->mutation->prelabel) or (follows($RNAend,$self->mutation->prelabel))) {\n\t     $self->warn(\"RNA not affected because change occurs after RNAend\");\n\t }\n\t elsif (scalar @exons == 1) {\n\t     #no introns, just one exon\n\t     $rnaAffected = 1; # then RNA is affected!\n\t } else {\n\t     # otherwise check for change occurring inside an intron\n\t     $firstexon=shift(@exons);\n\t     $before=$firstexon->end;\n\t\n\t     foreach $i (0..$#exons) {\n\t\t $after=$exons[$i]->start;\n\t\t if (follows($self->mutation->prelabel,$before) or\n\t\t\t($after==$self->mutation->prelabel) or\n\t\t\tfollows($after,$self->mutation->prelabel) or\n\t\t\tfollows($after,$self->mutation->postlabel)) {\n\n\t\t     $rnaAffected = 1;\n\t\t     # $i is number of exon and can be used for proximity check\n\t\t }\n\t\t $before=$exons[$i]->end;\n\t     }\n\t\n\t }\n    } else {\n\tmy $strand = $exons[0]->strand;\n\tif (($strand == 1 and $self->mutation->postlabel <= $RNAstart) or\n\t    ($strand != 1 and $self->mutation->postlabel >= $RNAstart)) {\n\t    #$self->warn(\"RNA not affected because change occurs before RNAstart\");\n\t    $rnaAffected = 0;\n\t}\n\telsif (($strand == 1 and $self->mutation->prelabel >= $RNAend) or\n\t\t($strand != 1 and $self->mutation->prelabel <= $RNAend)) {\n\t     #$self->warn(\"RNA not affected because change occurs after RNAend\");\n\t     $rnaAffected = 0;\n\t     my $dist;\n\t     if ($strand == 1){\n\t\t $dist = $self->mutation->prelabel - $RNAend;\n\t     } else {\n\t\t $dist = $RNAend - $self->mutation->prelabel;\n\t     }\n\t     $self->dnamut->region_dist($dist);\n\t }\n\t elsif (scalar @exons == 1) {\n\t     #if just one exon -> no introns, \n\t     $rnaAffected = 1; # then RNA is affected!\n\t } else {\t\n\t     # otherwise check for mutation occurring inside an intron\n\t     $firstexon=shift(@exons);\n\t     $before=$firstexon->end;\n\t     if ( ($strand == 1 and $self->mutation->prelabel < $before) or \n\t\t  ($strand == -1 and $self->mutation->prelabel > $before) \n\t\t  ) {\n\t\t $rnaAffected = 1 ;\n\n\t\t #print \"Exon 1 : \", $firstexon->start, \" - \", $firstexon->end, \"<br>\\n\";\n\t\t my $afterdist = $self->mutation->prelabel - $firstexon->start;\n\t\t my $beforedist =  $firstexon->end - $self->mutation->postlabel;\n\t\t my $exonvalue = $i + 1;\n\t\t $self->dnamut->region('exon');\n\t\t $self->dnamut->region_value($exonvalue);\n\t\t if ($afterdist < $beforedist) {\n\t\t     $afterdist++; \t\t  \n\t\t     $afterdist++;\n\t\t     $self->dnamut->region_dist($afterdist);\n\t\t     #print \"splice site $afterdist nt upstream!<br>\";\n\t\t } else {\n\t\t     $self->dnamut->region_dist($beforedist);\n\t\t     #print \"splice site $beforedist nt downstream!<br>\";\n\t\t }\n\t     } else {\n\t\t #print \"first exon  : \", $firstexon->start, \" - \", $firstexon->end, \"<br>\\n\";\n\t\t foreach $i (0..$#exons) {\n\t\t     $after=$exons[$i]->start;\n\t\t     #proximity test for intronic mutations\n\t\t     if ( ($strand == 1 and \n\t\t\t   $self->mutation->prelabel >=  $before and \n\t\t\t   $self->mutation->postlabel <= $after) \n\t\t\t  or\n\t\t\t  ($strand == -1 and \n\t\t\t   $self->mutation->prelabel <=  $before and \n\t\t\t   $self->mutation->postlabel >= $after)  ) {\n\t\t\t $self->dnamut->region('intron');\n\t\t\t #$self->dnamut->region_value($i);\n\t\t\t my $afterdist = $self->mutation->prelabel - $before;\n\t\t\t my $beforedist =  $after - $self->mutation->postlabel;\n\t\t\t my $intronvalue = $i + 1;\n\t\t\t if ($afterdist < $beforedist) {\n\t\t\t     $afterdist++;\n\t\t\t     $self->dnamut->region_value($intronvalue);\n\t\t\t     $self->dnamut->region_dist($afterdist);\n\t\t\t     #print \"splice site $afterdist nt upstream!<br>\";\n\t\t\t } else {\n\t\t\t     $self->dnamut->region_value($intronvalue);\n\t\t\t     $self->dnamut->region_dist($beforedist * -1);\n\t\t\t     #print \"splice site $beforedist nt downstream!<br>\";\n\t\t\t }\n\t\t\t $self->rnachange(undef);\n\t\t\t last;\n\t\t     } \n\t\t     #proximity test for exon mutations\n\t\t     #proximity test for exon mutations\n\t\t     elsif ( ( $strand == 1 and \n\t\t\t       $exons[$i]->start < $self->mutation->prelabel and \n\t\t\t       $exons[$i]->end > $self->mutation->prelabel) or \n\t\t\t     ( $strand == 1 and \n\t\t\t       $exons[$i]->start < $self->mutation->postlabel and \n\t\t\t       $exons[$i]->end > $self->mutation->postlabel) or \n\t\t\t     ( $strand == -1 and \n\t\t\t       $exons[$i]->start > $self->mutation->prelabel and \n\t\t\t       $exons[$i]->end < $self->mutation->prelabel) or\n\t\t\t     ( $strand == -1 and \n\t\t\t       $exons[$i]->start > $self->mutation->postlabel and \n\t\t\t       $exons[$i]->end < $self->mutation->postlabel) ) {\n\t\t\t $rnaAffected = 1;\n\n\t\t\t my $afterdist = $self->mutation->prelabel - $exons[$i]->start;\n\t\t\t my $beforedist =  $exons[$i]->end - $self->mutation->postlabel;\n\t\t\t my $exonvalue = $i + 1;\n\t\t\t $self->dnamut->region('exon');\n\t\t\t if ($afterdist < $beforedist) {\n\t\t\t     $afterdist++;\n\t\t\t     $self->dnamut->region_value($exonvalue+1);\n\t\t\t     $self->dnamut->region_dist($afterdist);\n\t\t\t     #print \"splice site $afterdist nt upstream!<br>\";\n\t\t\t } else {\n\t\t\t     #$beforedist;\n\t\t\t     $self->dnamut->region_value($exonvalue+1);\n\t\t\t     $self->dnamut->region_dist($beforedist * -1);\n\t\t\t     #print \"splice site $beforedist nt downstream!<br>\";\n\t\t\t }\n\t\t\t last;\n\t\t     }\n\t\t     $before=$exons[$i]->end;\n\t\t }\n\t     }\n\t }\n     }\n    #$self->warn(\"RNA not affected because change occurs inside an intron\");\n    #return(0); # if still not returned, then not affected, return 0\n    return $rnaAffected;\n}\n\n#\n# ### Creation of RNA and AA variation objects\n#\n\n=head2 _set_effects\n\n Title   : _set_effects\n Usage   :\n Function:\n\n           Stores RNA and AA level mutation attributes before mutation\n           into Bio::Variation::RNAChange and\n           Bio::Variation::AAChange objects.  Links them to\n           SeqDiff object.\n\n Example :\n Returns :\n Args    : Bio::Variation::SeqDiff object\n           Bio::Variation::DNAMutation object\n\nSee L<Bio::Variation::RNAChange>, L<Bio::Variation::RNAChange>,\nL<Bio::Variation::SeqDiff>, and L<Bio::Variation::DNAMutation>.\n\n\nsub _set_effects {\n    my ($self, $seqDiff, $dnamut) = @_;\n    my ($rnapos_end, $upstreamseq, $dnstreamseq);\n    my $flanklen = $self->{'flanklen'};\n\n    ($self->mutation->len == 0) ?\n\t($rnapos_end = $self->mutation->transpos) :\n\t($rnapos_end = $self->mutation->transpos + $self->mutation->len -1);\n    my $rnachange = Bio::Variation::RNAChange->new(-start => $self->mutation->transpos,\n\t\t\t\t\t\t    -end =>  $rnapos_end\n\t\t\t\t\t\t    );\n    $rnachange->isMutation(1);\n\n    # setting proof\n    if ($seqDiff->numbering eq \"coding\") {\n\t $rnachange->proof('experimental');\n    } else {\n\t $rnachange->proof('computed');\n    }\n\n    $seqDiff->add_Variant($rnachange);\n    $self->rnachange($rnachange);\n    $rnachange->DNAMutation($dnamut);\n    $dnamut->RNAChange($rnachange);\n    $rnachange->mut_number($self->mutation->issue);\n\n    # setting the codon_position of the \"start\" nucleotide of the change\n    $rnachange->codon_pos(($self->RNA->frame($self->mutation->label))+1); # codon_pos=frame+1\n\n    my @exons=$self->RNA->all_Exons;\n    $self->exons(\\@exons);\n    #print  `date`, \" before flank, after exons. RNAObj query\\n\";\n    # if cannot retrieve from Transcript, Transcript::upstream_seq will be used\n    # before \"fac7 g 65\" bug discovered\n    # $uplabel=$self->RNA->label(1-$flanklen,$prelabel);\n    my $RNAprelabel=$self->RNA->label(-1,$self->mutation->label); # to fix fac7g65 bug\n    # for the fix, all prelabel used in the next block have been changed to RNAprelabel\n    my $uplabel=$self->RNA->label(1-$flanklen,$RNAprelabel);\n    if ($self->RNA->valid($uplabel)) {\n\t $upstreamseq = $self->RNA->labelsubseq($uplabel, undef, $RNAprelabel);\n    } else {\n\t$upstreamseq = $self->RNA->labelsubseq($self->RNA->start, undef, $RNAprelabel)\n\t    if $self->RNA->valid($RNAprelabel);\n\tmy $lacking=$flanklen-length($upstreamseq); # how many missing\n\tmy $upstream_atg=$exons[0]->subseq(-$lacking,-1);\n\t$upstreamseq=$upstream_atg . $upstreamseq;\n    }\n\n    $rnachange->upStreamSeq($upstreamseq);\n\n    # won't work OK if postlabel NOT in Transcript\n    # now added RNApostlabel but this has to be /fully tested/\n    # for the fix, all postlabel used in the next block have been changed to RNApostlabel\n    my $RNApostlabel; # to fix fac7g64 bug\n    if ($self->mutation->len == 0) {\n      $RNApostlabel=$self->mutation->label;\n    } else {\n      my $mutlen = 1 + $self->mutation->len;\n      $RNApostlabel=$self->RNA->label($mutlen,$self->mutation->label);\n    }\n    $dnstreamseq=$self->RNA->labelsubseq($RNApostlabel, $flanklen);\n    if ($dnstreamseq eq '-1') { # if out of transcript was requested\n\t my $lastexon=$exons[-1];\n\t my $lastexonlength=$lastexon->length;\n\t $dnstreamseq=$self->RNA->labelsubseq($RNApostlabel); # retrieves till RNAend\n\t my $lacking=$flanklen-length($dnstreamseq); # how many missing\n\t my $downstream_stop=$lastexon->subseq($lastexonlength+1,undef,$lacking);\n\t $dnstreamseq .= $downstream_stop;\n    } else {\n\t $rnachange->dnStreamSeq($dnstreamseq);\n    }\n    # AAChange creation\n    my $AAobj=$self->RNA->get_Translation;\n    # storage of prelabel here, to be used in create_mut_objs_after\n    my $aachange = Bio::Variation::AAChange->new(-start => $RNAprelabel\n\t\t\t\t\t\t  );\n    $aachange->isMutation(1);\n    $aachange->proof('computed');\n\n    $seqDiff->add_Variant($aachange);\n    $self->aachange($aachange);\n    $rnachange->AAChange($aachange);\n    $aachange->RNAChange($rnachange);\n\n    $aachange->mut_number($self->mutation->issue);\n#    $before_mutation{aachange}=$aachange;\n\n    my $ra_o = Bio::Variation::Allele->new;\n    $ra_o->seq($dnamut->allele_ori->seq) if $dnamut->allele_ori->seq;\n    $rnachange->allele_ori($ra_o);\n\n    $rnachange->length(CORE::length $rnachange->allele_ori->seq);\n\n    my $ra_m = Bio::Variation::Allele->new;\n    $ra_m->seq($self->mutation->seq) if $self->mutation->seq;\n    $rnachange->allele_mut($ra_m);\n    $rnachange->add_Allele($ra_m);\n\n    #$rnachange->allele_mut($seq);\n    $rnachange->end($rnachange->start) if $rnachange->length == 0;\n\n    # this holds the aminoacid sequence that will be affected by the mutation\n    my $aa_allele_ori=$AAobj->labelsubseq($self->mutation->label,undef, \n\t\t\t\t\t  $self->mutation->lastlabel);\n\n    my $aa_o = Bio::Variation::Allele->new;\n    $aa_o->seq($aa_allele_ori) if $aa_allele_ori;\n    $aachange->allele_ori($aa_o);\n    #$aachange->allele_ori($aa_allele_ori);\n\n    my $aa_length_ori = length($aa_allele_ori);\n    $aachange->length($aa_length_ori); #print \"==========$aa_length_ori\\n\";\n    $aachange->end($aachange->start + $aa_length_ori - 1 );\n}\n\n=head2 _untranslated\n\n Title   : _untranslated\n Usage   :\n Function:\n\n           Stores RNA change attributes before mutation\n           into Bio::Variation::RNAChange object.  Links it to\n           SeqDiff object.\n\n Example :\n Returns :\n Args    : Bio::Variation::SeqDiff object\n           Bio::Variation::DNAMutation object\n\nSee L<Bio::Variation::RNAChange>, L<Bio::Variation::SeqDiff> and\nL<Bio::Variation::DNAMutation> for details.","parameters":[{"label":"$self"},{"label":"$seqDiff"},{"label":"$dnamut"}],"label":"_untranslated($self,$seqDiff,$dnamut)"},"name":"_untranslated","range":{"start":{"character":0,"line":1281},"end":{"character":9999,"line":1333}}},{"name":"Bio","containerName":"Variation::RNAChange","kind":12,"line":1287},{"containerName":"Variation::Allele","name":"Bio","line":1293,"kind":12},{"name":"Bio","containerName":"Variation::Allele","line":1296,"kind":12},{"kind":12,"children":[{"kind":13,"line":1339,"containerName":"_post_mutation","definition":"my","name":"$self","localvar":"my"},{"containerName":"_post_mutation","name":"$seqDiff","kind":13,"line":1339},{"kind":13,"line":1341,"containerName":"_post_mutation","name":"$self"},{"kind":12,"line":1341,"name":"rnachange","containerName":"_post_mutation"},{"name":"$self","containerName":"_post_mutation","kind":13,"line":1341},{"name":"rnachange","containerName":"_post_mutation","line":1341,"kind":12},{"line":1341,"kind":12,"containerName":"_post_mutation","name":"region"},{"localvar":"my","definition":"my","name":"$aachange","containerName":"_post_mutation","line":1345,"kind":13},{"name":"$self","containerName":"_post_mutation","kind":13,"line":1345},{"kind":12,"line":1345,"name":"aachange","containerName":"_post_mutation"},{"containerName":"_post_mutation","name":"$AAobj","definition":"my","localvar":"my","kind":13,"line":1346},{"name":"$aa_start_prelabel","containerName":"_post_mutation","kind":13,"line":1346},{"kind":13,"line":1346,"name":"$aa_start","containerName":"_post_mutation"},{"containerName":"_post_mutation","name":"$mut_translation","kind":13,"line":1346},{"name":"$AAobj","containerName":"_post_mutation","kind":13,"line":1347},{"containerName":"_post_mutation","name":"$self","kind":13,"line":1347},{"kind":12,"line":1347,"name":"RNA","containerName":"_post_mutation"},{"line":1347,"kind":12,"name":"get_Translation","containerName":"_post_mutation"},{"containerName":"_post_mutation","name":"$aa_start_prelabel","line":1348,"kind":13},{"kind":13,"line":1348,"containerName":"_post_mutation","name":"$aachange"},{"kind":12,"line":1348,"name":"start","containerName":"_post_mutation"},{"containerName":"_post_mutation","name":"$aa_start","kind":13,"line":1349},{"kind":13,"line":1349,"name":"$AAobj","containerName":"_post_mutation"},{"line":1349,"kind":12,"containerName":"_post_mutation","name":"position"},{"containerName":"_post_mutation","name":"$self","kind":13,"line":1349},{"kind":12,"line":1349,"containerName":"_post_mutation","name":"RNA"},{"name":"label","containerName":"_post_mutation","kind":12,"line":1349},{"line":1349,"kind":13,"containerName":"_post_mutation","name":"$aa_start_prelabel"},{"line":1350,"kind":13,"name":"$aachange","containerName":"_post_mutation"},{"line":1350,"kind":12,"containerName":"_post_mutation","name":"start"},{"line":1350,"kind":13,"containerName":"_post_mutation","name":"$aa_start"},{"kind":13,"line":1351,"name":"$mut_translation","containerName":"_post_mutation"},{"containerName":"_post_mutation","name":"$AAobj","line":1351,"kind":13},{"name":"seq","containerName":"_post_mutation","line":1351,"kind":12},{"containerName":"_post_mutation","definition":"my","name":"$aa_m","localvar":"my","kind":13,"line":1354},{"name":"new","containerName":"_post_mutation","kind":12,"line":1354},{"containerName":"_post_mutation","name":"$aa_m","line":1355,"kind":13},{"line":1355,"kind":12,"name":"seq","containerName":"_post_mutation"},{"line":1355,"kind":13,"name":"$mut_translation","containerName":"_post_mutation"},{"line":1355,"kind":13,"containerName":"_post_mutation","name":"$aa_start"},{"kind":13,"line":1355,"name":"$mut_translation","containerName":"_post_mutation"},{"name":"$aa_start","containerName":"_post_mutation","kind":13,"line":1355},{"name":"$aachange","containerName":"_post_mutation","kind":13,"line":1356},{"line":1356,"kind":12,"name":"allele_mut","containerName":"_post_mutation"},{"name":"$aa_m","containerName":"_post_mutation","kind":13,"line":1356},{"line":1357,"kind":13,"name":"$aachange","containerName":"_post_mutation"},{"containerName":"_post_mutation","name":"add_Allele","line":1357,"kind":12},{"name":"$aa_m","containerName":"_post_mutation","kind":13,"line":1357},{"line":1360,"kind":13,"localvar":"my","containerName":"_post_mutation","definition":"my","name":"$rlenori"},{"kind":13,"line":1360,"name":"$rlenmut","containerName":"_post_mutation"},{"line":1361,"kind":13,"name":"$rlenori","containerName":"_post_mutation"},{"line":1361,"kind":13,"name":"$aachange","containerName":"_post_mutation"},{"line":1361,"kind":12,"name":"RNAChange","containerName":"_post_mutation"},{"line":1361,"kind":12,"name":"allele_ori","containerName":"_post_mutation"},{"line":1361,"kind":12,"name":"seq","containerName":"_post_mutation"},{"line":1362,"kind":13,"name":"$rlenmut","containerName":"_post_mutation"},{"line":1362,"kind":13,"name":"$aachange","containerName":"_post_mutation"},{"kind":12,"line":1362,"name":"RNAChange","containerName":"_post_mutation"},{"containerName":"_post_mutation","name":"allele_mut","line":1362,"kind":12},{"containerName":"_post_mutation","name":"seq","kind":12,"line":1362},{"kind":13,"line":1365,"containerName":"_post_mutation","name":"$rlenori"},{"kind":13,"line":1365,"name":"$rlenmut","containerName":"_post_mutation"},{"line":1365,"kind":13,"name":"$aachange","containerName":"_post_mutation"},{"line":1365,"kind":12,"containerName":"_post_mutation","name":"allele_ori"},{"line":1365,"kind":12,"name":"seq","containerName":"_post_mutation"},{"localvar":"my","name":"$alleleseq","definition":"my","containerName":"_post_mutation","line":1366,"kind":13},{"containerName":"_post_mutation","name":"$aachange","kind":13,"line":1367},{"containerName":"_post_mutation","name":"allele_mut","line":1367,"kind":12},{"line":1367,"kind":12,"containerName":"_post_mutation","name":"seq"},{"kind":13,"line":1368,"name":"$alleleseq","containerName":"_post_mutation"},{"name":"$aachange","containerName":"_post_mutation","line":1368,"kind":13},{"kind":12,"line":1368,"containerName":"_post_mutation","name":"allele_mut"},{"line":1368,"kind":12,"containerName":"_post_mutation","name":"seq"},{"line":1369,"kind":13,"containerName":"_post_mutation","name":"$aachange"},{"kind":12,"line":1369,"containerName":"_post_mutation","name":"allele_mut"},{"containerName":"_post_mutation","name":"seq","line":1369,"kind":12},{"kind":13,"line":1369,"containerName":"_post_mutation","name":"$alleleseq"},{"line":1371,"kind":13,"containerName":"_post_mutation","name":"$aachange"},{"line":1371,"kind":12,"containerName":"_post_mutation","name":"end"},{"kind":13,"line":1371,"name":"$aachange","containerName":"_post_mutation"},{"kind":12,"line":1371,"name":"start","containerName":"_post_mutation"},{"name":"$aachange","containerName":"_post_mutation","kind":13,"line":1372},{"kind":12,"line":1372,"containerName":"_post_mutation","name":"length"},{"kind":13,"line":1374,"name":"$rlenori","containerName":"_post_mutation"},{"kind":13,"line":1374,"name":"$rlenmut","containerName":"_post_mutation"},{"containerName":"_post_mutation","name":"$aachange","kind":13,"line":1375},{"containerName":"_post_mutation","name":"allele_ori","line":1375,"kind":12},{"kind":12,"line":1375,"containerName":"_post_mutation","name":"seq"},{"containerName":"_post_mutation","name":"$aachange","line":1376,"kind":13},{"containerName":"_post_mutation","name":"allele_mut","line":1376,"kind":12},{"line":1376,"kind":12,"containerName":"_post_mutation","name":"seq"},{"line":1376,"kind":13,"containerName":"_post_mutation","name":"$aachange"},{"name":"allele_mut","containerName":"_post_mutation","kind":12,"line":1376},{"line":1376,"kind":12,"containerName":"_post_mutation","name":"seq"},{"name":"$aachange","containerName":"_post_mutation","line":1378,"kind":13},{"kind":12,"line":1378,"containerName":"_post_mutation","name":"allele_ori"},{"line":1378,"kind":12,"containerName":"_post_mutation","name":"seq"},{"kind":13,"line":1381,"name":"$rlenori","containerName":"_post_mutation"},{"containerName":"_post_mutation","name":"$rlenmut","kind":13,"line":1381},{"name":"%3","containerName":"_post_mutation","kind":13,"line":1381},{"containerName":"_post_mutation","name":"$aachange","kind":13,"line":1382},{"containerName":"_post_mutation","name":"RNAChange","line":1382,"kind":12},{"line":1382,"kind":12,"containerName":"_post_mutation","name":"allele_mut"},{"containerName":"_post_mutation","name":"seq","line":1382,"kind":12},{"kind":13,"line":1383,"name":"$aachange","containerName":"_post_mutation"},{"name":"RNAChange","containerName":"_post_mutation","line":1383,"kind":12},{"name":"allele_ori","containerName":"_post_mutation","kind":12,"line":1383},{"containerName":"_post_mutation","name":"seq","line":1383,"kind":12},{"line":1385,"kind":13,"localvar":"my","containerName":"_post_mutation","name":"$rna_len","definition":"my"},{"name":"$aachange","containerName":"_post_mutation","line":1385,"kind":13},{"name":"RNAChange","containerName":"_post_mutation","kind":12,"line":1385},{"kind":12,"line":1385,"containerName":"_post_mutation","name":"allele_mut"},{"containerName":"_post_mutation","name":"seq","kind":12,"line":1385},{"localvar":"my","containerName":"_post_mutation","name":"$len","definition":"my","line":1386,"kind":13},{"containerName":"_post_mutation","name":"$rna_len","kind":13,"line":1386},{"line":1387,"kind":13,"containerName":"_post_mutation","name":"$len"},{"containerName":"_post_mutation","name":"$rna_len","line":1387,"kind":13},{"name":"%3","containerName":"_post_mutation","kind":13,"line":1387},{"name":"$aachange","containerName":"_post_mutation","line":1388,"kind":13},{"name":"allele_mut","containerName":"_post_mutation","kind":12,"line":1388},{"name":"seq","containerName":"_post_mutation","kind":12,"line":1388},{"line":1388,"kind":13,"containerName":"_post_mutation","name":"$aachange"},{"kind":12,"line":1388,"containerName":"_post_mutation","name":"allele_mut"},{"name":"seq","containerName":"_post_mutation","kind":12,"line":1388},{"line":1388,"kind":13,"containerName":"_post_mutation","name":"$len"},{"containerName":"_post_mutation","name":"$aachange","kind":13,"line":1390},{"containerName":"_post_mutation","name":"RNAChange","line":1390,"kind":12},{"name":"codon_pos","containerName":"_post_mutation","kind":12,"line":1390},{"containerName":"_post_mutation","name":"$aachange","kind":13,"line":1392},{"kind":12,"line":1392,"containerName":"_post_mutation","name":"RNAChange"},{"kind":12,"line":1392,"name":"allele_mut","containerName":"_post_mutation"},{"kind":12,"line":1392,"containerName":"_post_mutation","name":"seq"},{"containerName":"_post_mutation","name":"$aachange","line":1393,"kind":13},{"line":1393,"kind":12,"containerName":"_post_mutation","name":"allele_mut"},{"kind":12,"line":1393,"containerName":"_post_mutation","name":"seq"},{"name":"$aachange","containerName":"_post_mutation","kind":13,"line":1394},{"name":"end","containerName":"_post_mutation","kind":12,"line":1394},{"containerName":"_post_mutation","name":"$aachange","line":1394,"kind":13},{"name":"start","containerName":"_post_mutation","kind":12,"line":1394},{"containerName":"_post_mutation","name":"$aachange","kind":13,"line":1394},{"line":1394,"kind":12,"name":"length","containerName":"_post_mutation"},{"kind":13,"line":1397,"containerName":"_post_mutation","name":"$aachange"},{"line":1397,"kind":12,"name":"RNAChange","containerName":"_post_mutation"},{"name":"allele_ori","containerName":"_post_mutation","line":1397,"kind":12},{"containerName":"_post_mutation","name":"seq","kind":12,"line":1397},{"containerName":"_post_mutation","name":"$aachange","kind":13,"line":1398},{"line":1398,"kind":12,"containerName":"_post_mutation","name":"allele_mut"},{"name":"seq","containerName":"_post_mutation","line":1398,"kind":12},{"kind":13,"line":1398,"containerName":"_post_mutation","name":"$aachange"},{"containerName":"_post_mutation","name":"allele_mut","kind":12,"line":1398},{"name":"seq","containerName":"_post_mutation","line":1398,"kind":12},{"kind":13,"line":1399,"containerName":"_post_mutation","name":"$aachange"},{"containerName":"_post_mutation","name":"RNAChange","line":1399,"kind":12},{"containerName":"_post_mutation","name":"allele_mut","kind":12,"line":1399},{"containerName":"_post_mutation","name":"seq","line":1399,"kind":12},{"name":"$aachange","containerName":"_post_mutation","kind":13,"line":1400},{"containerName":"_post_mutation","name":"allele_ori","line":1400,"kind":12},{"kind":12,"line":1400,"name":"seq","containerName":"_post_mutation"},{"kind":13,"line":1401,"name":"$aachange","containerName":"_post_mutation"},{"line":1401,"kind":12,"name":"end","containerName":"_post_mutation"},{"containerName":"_post_mutation","name":"$aachange","line":1401,"kind":13},{"line":1401,"kind":12,"name":"start","containerName":"_post_mutation"},{"kind":13,"line":1401,"containerName":"_post_mutation","name":"$aachange"},{"name":"length","containerName":"_post_mutation","kind":12,"line":1401},{"name":"$aachange","containerName":"_post_mutation","line":1402,"kind":13},{"name":"length","containerName":"_post_mutation","kind":12,"line":1402},{"line":1407,"kind":13,"name":"$aachange","containerName":"_post_mutation"},{"kind":12,"line":1407,"containerName":"_post_mutation","name":"RNAChange"},{"name":"allele_mut","containerName":"_post_mutation","line":1407,"kind":12},{"name":"seq","containerName":"_post_mutation","kind":12,"line":1407},{"containerName":"_post_mutation","name":"$aachange","line":1408,"kind":13},{"kind":12,"line":1408,"name":"allele_mut","containerName":"_post_mutation"},{"kind":12,"line":1408,"containerName":"_post_mutation","name":"seq"},{"line":1408,"kind":13,"containerName":"_post_mutation","name":"$aachange"},{"kind":12,"line":1408,"name":"allele_mut","containerName":"_post_mutation"},{"containerName":"_post_mutation","name":"seq","line":1408,"kind":12},{"name":"$aachange","containerName":"_post_mutation","kind":13,"line":1411},{"name":"RNAChange","containerName":"_post_mutation","kind":12,"line":1411},{"name":"allele_ori","containerName":"_post_mutation","line":1411,"kind":12},{"name":"seq","containerName":"_post_mutation","line":1411,"kind":12},{"line":1412,"kind":13,"name":"$aachange","containerName":"_post_mutation"},{"kind":12,"line":1412,"name":"allele_mut","containerName":"_post_mutation"},{"kind":12,"line":1412,"containerName":"_post_mutation","name":"seq"},{"containerName":"_post_mutation","name":"$aachange","kind":13,"line":1412},{"name":"allele_mut","containerName":"_post_mutation","kind":12,"line":1412},{"line":1412,"kind":12,"name":"seq","containerName":"_post_mutation"},{"name":"$aachange","containerName":"_post_mutation","kind":13,"line":1413},{"line":1413,"kind":12,"containerName":"_post_mutation","name":"RNAChange"},{"containerName":"_post_mutation","name":"allele_mut","line":1413,"kind":12},{"line":1413,"kind":12,"containerName":"_post_mutation","name":"seq"},{"name":"$aachange","containerName":"_post_mutation","line":1420,"kind":13},{"name":"length","containerName":"_post_mutation","kind":12,"line":1420},{"kind":13,"line":1420,"name":"$aachange","containerName":"_post_mutation"},{"line":1420,"kind":12,"name":"allele_ori","containerName":"_post_mutation"},{"name":"seq","containerName":"_post_mutation","line":1420,"kind":12},{"localvar":"my","containerName":"_post_mutation","definition":"my","name":"$aaend","line":1421,"kind":13},{"kind":13,"line":1421,"name":"$aachange","containerName":"_post_mutation"},{"containerName":"_post_mutation","name":"start","line":1421,"kind":12},{"line":1421,"kind":13,"containerName":"_post_mutation","name":"$aachange"},{"name":"length","containerName":"_post_mutation","kind":12,"line":1421},{"line":1422,"kind":13,"containerName":"_post_mutation","name":"$aachange"},{"line":1422,"kind":12,"containerName":"_post_mutation","name":"end"},{"name":"$aachange","containerName":"_post_mutation","line":1422,"kind":13},{"kind":12,"line":1422,"name":"start","containerName":"_post_mutation"},{"localvar":"my","definition":"my","name":"@beforeexons","containerName":"_post_mutation","line":1426,"kind":13},{"line":1426,"kind":13,"name":"$self","containerName":"_post_mutation"},{"kind":12,"line":1426,"name":"exons","containerName":"_post_mutation"},{"localvar":"my","containerName":"_post_mutation","definition":"my","name":"@afterexons","line":1427,"kind":13},{"containerName":"_post_mutation","name":"$self","kind":13,"line":1427},{"name":"RNA","containerName":"_post_mutation","line":1427,"kind":12},{"name":"all_Exons","containerName":"_post_mutation","kind":12,"line":1427},{"localvar":"my","definition":"my","name":"$i","containerName":"_post_mutation","line":1428,"kind":13},{"line":1429,"kind":13,"name":"@beforeexons","containerName":"_post_mutation"},{"containerName":"_post_mutation","name":"@afterexons","line":1429,"kind":13},{"localvar":"my","containerName":"_post_mutation","name":"$mut_number","definition":"my","line":1430,"kind":13},{"kind":13,"line":1430,"name":"$self","containerName":"_post_mutation"},{"name":"mutation","containerName":"_post_mutation","kind":12,"line":1430},{"name":"issue","containerName":"_post_mutation","kind":12,"line":1430},{"containerName":"_post_mutation","name":"$self","kind":13,"line":1431},{"kind":12,"line":1431,"name":"warn","containerName":"_post_mutation"},{"containerName":"_post_mutation","name":"$self","kind":13,"line":1432},{"kind":12,"line":1432,"containerName":"_post_mutation","name":"rnachange"},{"line":1432,"kind":12,"name":"exons_modified","containerName":"_post_mutation"},{"name":"$i","containerName":"_post_mutation","kind":13,"line":1435},{"containerName":"_post_mutation","name":"$beforeexons","kind":13,"line":1436},{"kind":13,"line":1436,"name":"$i","containerName":"_post_mutation"},{"name":"$afterexons","containerName":"_post_mutation","line":1436,"kind":13},{"kind":13,"line":1436,"containerName":"_post_mutation","name":"$i"},{"containerName":"_post_mutation","name":"$mut_number","definition":"my","localvar":"my","kind":13,"line":1437},{"name":"$self","containerName":"_post_mutation","kind":13,"line":1437},{"containerName":"_post_mutation","name":"mutation","line":1437,"kind":12},{"kind":12,"line":1437,"name":"issue","containerName":"_post_mutation"},{"kind":13,"line":1438,"name":"$self","containerName":"_post_mutation"},{"kind":12,"line":1438,"containerName":"_post_mutation","name":"warn"},{"name":"$self","containerName":"_post_mutation","line":1439,"kind":13},{"kind":12,"line":1439,"name":"rnachange","containerName":"_post_mutation"},{"line":1439,"kind":12,"name":"exons_modified","containerName":"_post_mutation"}],"line":1338,"definition":"sub","containerName":"main::","signature":{"label":"_post_mutation($self,$seqDiff)","documentation":" args: reference to label changearray, reference to position changearray\n Function: take care of the creation of mutation objects, with\n information AFTER the change takes place","parameters":[{"label":"$self"},{"label":"$seqDiff"}]},"detail":"($self,$seqDiff)","name":"_post_mutation","range":{"start":{"character":0,"line":1338},"end":{"line":1444,"character":9999}}},{"line":1354,"kind":12,"name":"Bio","containerName":"Variation::Allele"},{"name":"CORE","containerName":"length","line":1361,"kind":12},{"line":1362,"kind":12,"containerName":"length","name":"CORE"},{"line":1420,"kind":12,"name":"CORE","containerName":"length"},{"kind":12,"line":1434,"name":"EXONCHECK"},{"name":"beforeexons","line":1435,"kind":12},{"name":"EXONCHECK","line":1440,"kind":12}]}