{"vars":[{"name":"Carp","containerName":"","kind":2,"line":77},{"detail":"($thing,%args)","signature":{"parameters":[{"label":"$thing"},{"label":"%args"}],"documentation":"1;\n# $Id: ChainI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::ChainI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::ChainI - Double linked chain data structure\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis class generates and manipulates generic double linked list, chain,\nthat can be used to manage biological sequences.\n\nThe advantages over strings or plain arrays is the ease of tracking\nchanges (mutations) in the elements (sequence). The other side of the\ncoin is that these structures need consideraly more memory, but that\nis cheap and constantly inceasing resource in computers.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::ChainI;\n\nuse Carp qw(croak);\nuse strict; # this will be moved before when strict enforced in Chain.pm\n\nuse Bio::LiveSeq::Chain; # package where all the subroutines are defined\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $chain = Bio::LiveSeq::ChainI->new(-string => \"thequickbrownfoxjumpsoverthelazydog\",\n\t\t\t\t\t     -offset => 3 );\n         OR $chain = Bio::LiveSeq::ChainI->new(-array => \\@array,\n\t\t\t\t\t     -offset => 3 );\n  Function: generates a new Bio::LiveSeq:ChainI\n  Returns : a new Chain\n  Args    : string\n         OR arrayreference\n        AND optional offset to create element labels","label":"new($thing,%args)"},"containerName":"main::","definition":"sub","line":98,"children":[{"kind":13,"line":99,"name":"$thing","definition":"my","containerName":"new","localvar":"my"},{"name":"%args","containerName":"new","kind":13,"line":99},{"line":100,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"containerName":"new","name":"$thing","line":100,"kind":13},{"name":"$thing","containerName":"new","kind":13,"line":100},{"line":101,"kind":13,"localvar":"my","definition":"my","name":"$obj","containerName":"new"},{"kind":13,"line":103,"containerName":"new","name":"$args"},{"line":104,"kind":13,"containerName":"new","name":"$obj"},{"line":104,"kind":13,"name":"$thing","containerName":"new"},{"containerName":"new","name":"string2chain","kind":12,"line":104},{"kind":13,"line":104,"containerName":"new","name":"$args"},{"containerName":"new","name":"$args","line":104,"kind":13},{"line":105,"kind":13,"name":"$args","containerName":"new"},{"name":"$obj","containerName":"new","line":106,"kind":13},{"kind":13,"line":106,"containerName":"new","name":"$thing"},{"kind":12,"line":106,"name":"array2chain","containerName":"new"},{"line":106,"kind":13,"name":"$args","containerName":"new"},{"containerName":"new","name":"$args","kind":13,"line":106},{"containerName":"new","name":"$obj","line":111,"kind":13},{"kind":13,"line":111,"containerName":"new","name":"$obj"},{"kind":13,"line":111,"containerName":"new","name":"$class"},{"containerName":"new","name":"$obj","kind":13,"line":112}],"kind":12,"range":{"start":{"line":98,"character":0},"end":{"line":113,"character":9999}},"name":"new"},{"kind":2,"line":99,"containerName":"strict::Bio::LiveSeq","name":"Chain"},{"name":"croak","kind":12,"line":108},{"range":{"end":{"character":9999,"line":119},"start":{"character":0,"line":116}},"containerName":"main::","definition":"sub","name":"string2chain","line":116,"children":[],"kind":12},{"name":"Bio","containerName":"LiveSeq::Chain::string2chain","line":118,"kind":12},{"containerName":"main::","name":"array2chain","definition":"sub","range":{"end":{"line":123,"character":9999},"start":{"line":120,"character":0}},"kind":12,"line":120,"children":[]},{"name":"Bio","containerName":"LiveSeq::Chain::array2chain","kind":12,"line":122},{"kind":12,"children":[],"line":125,"name":"chain2string","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":125},"end":{"line":127,"character":9999}}},{"name":"croak","kind":12,"line":126},{"kind":12,"children":[],"line":128,"definition":"sub","name":"down_chain2string","containerName":"main::","range":{"start":{"line":128,"character":0},"end":{"line":130,"character":9999}}},{"kind":12,"line":129,"name":"Bio","containerName":"LiveSeq::Chain::down_chain2string"},{"line":131,"children":[],"kind":12,"range":{"end":{"line":133,"character":9999},"start":{"line":131,"character":0}},"containerName":"main::","definition":"sub","name":"up_chain2string"},{"line":132,"kind":12,"name":"Bio","containerName":"LiveSeq::Chain::up_chain2string"},{"children":[],"line":134,"kind":12,"range":{"start":{"character":0,"line":134},"end":{"line":136,"character":9999}},"name":"chain2string_verbose","definition":"sub","containerName":"main::"},{"line":135,"kind":12,"name":"croak"},{"kind":12,"children":[],"line":137,"definition":"sub","name":"down_chain2string_verbose","containerName":"main::","range":{"end":{"line":139,"character":9999},"start":{"line":137,"character":0}}},{"containerName":"LiveSeq::Chain::down_chain2string_verbose","name":"Bio","kind":12,"line":138},{"range":{"end":{"character":9999,"line":142},"start":{"line":140,"character":0}},"containerName":"main::","definition":"sub","name":"up_chain2string_verbose","line":140,"children":[],"kind":12},{"kind":12,"line":141,"containerName":"LiveSeq::Chain::up_chain2string_verbose","name":"Bio"},{"range":{"start":{"line":143,"character":0},"end":{"line":145,"character":9999}},"containerName":"main::","definition":"sub","name":"invert_chain","line":143,"children":[],"kind":12},{"containerName":"LiveSeq::Chain::invert_chain","name":"Bio","kind":12,"line":144},{"definition":"sub","name":"mutate_element","containerName":"main::","range":{"start":{"character":0,"line":146},"end":{"line":148,"character":9999}},"kind":12,"children":[],"line":146},{"name":"croak","kind":12,"line":147},{"range":{"start":{"character":0,"line":151},"end":{"line":153,"character":9999}},"containerName":"main::","definition":"sub","name":"down_labels","line":151,"children":[],"kind":12},{"line":152,"kind":12,"containerName":"LiveSeq::Chain::down_labels","name":"Bio"},{"kind":12,"line":154,"children":[],"containerName":"main::","name":"up_labels","definition":"sub","range":{"end":{"character":9999,"line":156},"start":{"line":154,"character":0}}},{"kind":12,"line":155,"name":"Bio","containerName":"LiveSeq::Chain::up_labels"},{"kind":12,"line":158,"children":[],"containerName":"main::","definition":"sub","name":"start","range":{"start":{"line":158,"character":0},"end":{"line":160,"character":9999}}},{"kind":12,"line":159,"name":"Bio","containerName":"LiveSeq::Chain::start"},{"containerName":"main::","definition":"sub","name":"end","range":{"end":{"character":9999,"line":163},"start":{"character":0,"line":161}},"kind":12,"line":161,"children":[]},{"line":162,"kind":12,"name":"Bio","containerName":"LiveSeq::Chain::end"},{"kind":12,"line":164,"children":[],"containerName":"main::","definition":"sub","name":"label_exists","range":{"end":{"line":166,"character":9999},"start":{"character":0,"line":164}}},{"containerName":"LiveSeq::Chain::label_exists","name":"Bio","line":165,"kind":12},{"definition":"sub","name":"get_value_at_pos","containerName":"main::","range":{"start":{"line":168,"character":0},"end":{"character":9999,"line":170}},"kind":12,"children":[],"line":168},{"name":"croak","kind":12,"line":169},{"line":171,"children":[],"kind":12,"range":{"end":{"line":173,"character":9999},"start":{"character":0,"line":171}},"containerName":"main::","name":"down_get_value_at_pos","definition":"sub"},{"kind":12,"line":172,"containerName":"LiveSeq::Chain::down_get_value_at_pos","name":"Bio"},{"children":[],"line":174,"kind":12,"range":{"start":{"character":0,"line":174},"end":{"line":176,"character":9999}},"definition":"sub","name":"up_get_value_at_pos","containerName":"main::"},{"line":175,"kind":12,"name":"Bio","containerName":"LiveSeq::Chain::up_get_value_at_pos"},{"children":[],"line":177,"kind":12,"range":{"end":{"line":179,"character":9999},"start":{"character":0,"line":177}},"name":"set_value_at_pos","definition":"sub","containerName":"main::"},{"line":178,"kind":12,"name":"croak"},{"kind":12,"line":180,"children":[],"containerName":"main::","name":"down_set_value_at_pos","definition":"sub","range":{"start":{"character":0,"line":180},"end":{"line":182,"character":9999}}},{"line":181,"kind":12,"containerName":"LiveSeq::Chain::down_set_value_at_pos","name":"Bio"},{"children":[],"line":183,"kind":12,"range":{"end":{"character":9999,"line":185},"start":{"character":0,"line":183}},"definition":"sub","name":"up_set_value_at_pos","containerName":"main::"},{"name":"Bio","containerName":"LiveSeq::Chain::up_set_value_at_pos","line":184,"kind":12},{"line":186,"children":[],"kind":12,"range":{"start":{"line":186,"character":0},"end":{"line":188,"character":9999}},"containerName":"main::","name":"get_value_at_label","definition":"sub"},{"kind":12,"line":187,"containerName":"LiveSeq::Chain::get_value_at_label","name":"Bio"},{"kind":12,"children":[],"line":189,"definition":"sub","name":"set_value_at_label","containerName":"main::","range":{"end":{"line":191,"character":9999},"start":{"character":0,"line":189}}},{"kind":12,"line":190,"containerName":"LiveSeq::Chain::set_value_at_label","name":"Bio"},{"children":[],"line":192,"kind":12,"range":{"start":{"character":0,"line":192},"end":{"line":194,"character":9999}},"name":"get_label_at_pos","definition":"sub","containerName":"main::"},{"kind":12,"line":193,"name":"croak"},{"children":[],"line":195,"kind":12,"range":{"end":{"line":197,"character":9999},"start":{"character":0,"line":195}},"definition":"sub","name":"up_get_label_at_pos","containerName":"main::"},{"kind":12,"line":196,"containerName":"LiveSeq::Chain::up_get_label_at_pos","name":"Bio"},{"range":{"end":{"character":9999,"line":200},"start":{"character":0,"line":198}},"containerName":"main::","name":"down_get_label_at_pos","definition":"sub","line":198,"children":[],"kind":12},{"containerName":"LiveSeq::Chain::down_get_label_at_pos","name":"Bio","kind":12,"line":199},{"children":[],"line":201,"kind":12,"range":{"start":{"line":201,"character":0},"end":{"line":203,"character":9999}},"name":"get_pos_of_label","definition":"sub","containerName":"main::"},{"name":"croak","line":202,"kind":12},{"containerName":"main::","definition":"sub","name":"up_get_pos_of_label","range":{"start":{"character":0,"line":204},"end":{"character":9999,"line":206}},"kind":12,"line":204,"children":[]},{"name":"Bio","containerName":"LiveSeq::Chain::up_get_pos_of_label","kind":12,"line":205},{"name":"down_get_pos_of_label","definition":"sub","containerName":"main::","range":{"start":{"line":207,"character":0},"end":{"character":9999,"line":209}},"kind":12,"children":[],"line":207},{"kind":12,"line":208,"name":"Bio","containerName":"LiveSeq::Chain::down_get_pos_of_label"},{"range":{"start":{"line":212,"character":0},"end":{"character":9999,"line":214}},"containerName":"main::","name":"preinsert_string","definition":"sub","line":212,"children":[],"kind":12},{"name":"Bio","containerName":"LiveSeq::Chain::praeinsert_string","line":213,"kind":12},{"range":{"end":{"character":9999,"line":217},"start":{"character":0,"line":215}},"containerName":"main::","name":"preinsert_array","definition":"sub","line":215,"children":[],"kind":12},{"line":216,"kind":12,"containerName":"LiveSeq::Chain::praeinsert_array","name":"Bio"},{"range":{"end":{"line":220,"character":9999},"start":{"line":218,"character":0}},"containerName":"main::","definition":"sub","name":"praeinsert_string","line":218,"children":[],"kind":12},{"kind":12,"line":219,"name":"Bio","containerName":"LiveSeq::Chain::praeinsert_string"},{"containerName":"main::","definition":"sub","name":"postinsert_string","range":{"start":{"character":0,"line":221},"end":{"character":9999,"line":223}},"kind":12,"line":221,"children":[]},{"kind":12,"line":222,"containerName":"LiveSeq::Chain::postinsert_string","name":"Bio"},{"containerName":"main::","name":"praeinsert_array","definition":"sub","range":{"end":{"line":226,"character":9999},"start":{"line":224,"character":0}},"kind":12,"line":224,"children":[]},{"line":225,"kind":12,"containerName":"LiveSeq::Chain::praeinsert_array","name":"Bio"},{"name":"postinsert_array","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":227},"end":{"line":229,"character":9999}},"kind":12,"children":[],"line":227},{"kind":12,"line":228,"containerName":"LiveSeq::Chain::postinsert_array","name":"Bio"},{"range":{"end":{"line":232,"character":9999},"start":{"line":230,"character":0}},"definition":"sub","name":"down_element","containerName":"main::","children":[],"line":230,"kind":12},{"containerName":"LiveSeq::Chain::down_element","name":"Bio","kind":12,"line":231},{"kind":12,"children":[],"line":233,"definition":"sub","name":"up_element","containerName":"main::","range":{"start":{"line":233,"character":0},"end":{"line":235,"character":9999}}},{"kind":12,"line":234,"name":"Bio","containerName":"LiveSeq::Chain::up_element"},{"containerName":"main::","name":"is_downstream","definition":"sub","range":{"start":{"character":0,"line":236},"end":{"line":238,"character":9999}},"kind":12,"line":236,"children":[]},{"line":237,"kind":12,"name":"Bio","containerName":"LiveSeq::Chain::is_downstream"},{"range":{"start":{"line":239,"character":0},"end":{"line":241,"character":9999}},"containerName":"main::","definition":"sub","name":"is_upstream","line":239,"children":[],"kind":12},{"name":"Bio","containerName":"LiveSeq::Chain::is_upstream","kind":12,"line":240},{"definition":"sub","name":"check_chain","containerName":"main::","range":{"end":{"character":9999,"line":244},"start":{"line":242,"character":0}},"kind":12,"children":[],"line":242},{"line":243,"kind":12,"containerName":"LiveSeq::Chain::check_chain","name":"Bio"},{"containerName":"main::","definition":"sub","name":"chain_length","range":{"start":{"line":245,"character":0},"end":{"line":247,"character":9999}},"kind":12,"line":245,"children":[]},{"kind":12,"line":246,"containerName":"LiveSeq::Chain::chain_length","name":"Bio"},{"kind":12,"line":248,"children":[],"containerName":"main::","definition":"sub","name":"splice_chain","range":{"end":{"line":250,"character":9999},"start":{"character":0,"line":248}}},{"line":249,"kind":12,"containerName":"LiveSeq::Chain::splice_chain","name":"Bio"},{"definition":"sub","name":"pos_of_element","containerName":"main::","range":{"start":{"character":0,"line":251},"end":{"line":253,"character":9999}},"kind":12,"children":[],"line":251},{"name":"croak","kind":12,"line":252},{"name":"up_pos_of_element","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":257},"start":{"line":254,"character":0}},"kind":12,"children":[],"line":254},{"line":255,"kind":12,"name":"croak"},{"name":"Bio","containerName":"LiveSeq::Chain::up_pos_of_element","kind":12,"line":256},{"kind":12,"line":258,"children":[],"containerName":"main::","definition":"sub","name":"down_pos_of_element","range":{"end":{"line":261,"character":9999},"start":{"line":258,"character":0}}},{"name":"croak","line":259,"kind":12},{"kind":12,"line":260,"name":"Bio","containerName":"LiveSeq::Chain::down_pos_of_element"},{"range":{"start":{"character":0,"line":262},"end":{"character":9999,"line":264}},"containerName":"main::","definition":"sub","name":"subchain_length","line":262,"children":[],"kind":12},{"line":263,"kind":12,"name":"croak"},{"line":265,"children":[],"kind":12,"range":{"end":{"line":267,"character":9999},"start":{"character":0,"line":265}},"containerName":"main::","definition":"sub","name":"down_subchain_length"},{"name":"Bio","containerName":"LiveSeq::Chain::down_subchain_length","kind":12,"line":266},{"definition":"sub","name":"up_subchain_length","containerName":"main::","range":{"start":{"line":268,"character":0},"end":{"character":9999,"line":270}},"kind":12,"children":[],"line":268},{"containerName":"LiveSeq::Chain::up_subchain_length","name":"Bio","line":269,"kind":12},{"range":{"start":{"character":0,"line":273},"end":{"line":275,"character":9999}},"containerName":"main::","name":"elements","definition":"sub","line":273,"children":[],"kind":12},{"containerName":"LiveSeq::Chain::down_elements","name":"Bio","kind":12,"line":274},{"kind":12,"children":[],"line":276,"definition":"sub","name":"up_elements","containerName":"main::","range":{"end":{"line":278,"character":9999},"start":{"character":0,"line":276}}},{"line":277,"kind":12,"name":"Bio","containerName":"LiveSeq::Chain::up_elements"},{"containerName":"main::","name":"down_elements","definition":"sub","range":{"end":{"line":281,"character":9999},"start":{"character":0,"line":279}},"kind":12,"line":279,"children":[]},{"name":"Bio","containerName":"LiveSeq::Chain::down_elements","line":280,"kind":12}],"version":5}