{"version":5,"vars":[{"kind":2,"line":119,"name":"base","containerName":""},{"children":[],"line":121,"kind":12,"range":{"end":{"character":9999,"line":123},"start":{"line":121,"character":0}},"definition":"sub","name":"_type_stamp","containerName":"main::"},{"children":[],"line":125,"kind":12,"range":{"end":{"line":127,"character":9999},"start":{"character":0,"line":125}},"definition":"sub","name":"_version","containerName":"main::"},{"range":{"start":{"line":142,"character":0},"end":{"line":171,"character":9999}},"name":"_index_file","detail":"($self,$file,$i)","signature":{"label":"_index_file($self,$file,$i)","documentation":"__END__\n#\n# $Id: GenBank.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Abstract\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::GenBank - Interface for indexing one or more GenBank\nfiles (i.e. flat file GenBank format).\n\n=head1 SYNOPSIS\n\n    # Complete code for making an index for one or more GenBank files\n    use strict;\n    use Bio::Index::GenBank;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::GenBank->new(-filename => $Index_File_Name, \n\t\t\t\t                           -write_flag => 'WRITE');\n    $inx->make_index(@ARGV);\n\n    # Print out sequences present in the index in gcg format\n    use Bio::Index::GenBank;\n    use Bio::SeqIO;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::GenBank->new(-filename => $Index_File_Name);\n    my $seqio = Bio::SeqIO->new(-format => 'gcg');\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns Bio::Seq object\n        $seqio->write_seq($seq);\n    }\n\n    # alternatively\n    my ($locus, $acc);\n    my $seq1 = $inx->get_Seq_by_id($locus);\n    my $seq2 = $inx->get_Seq_by_acc($acc);\n\n=head1 DESCRIPTION\n\nBy default the index that is created uses the LOCUS, ACCESSION, and\nVERSION identifiers as keys. Inherits functions for managing dbm \nfiles from Bio::Index::Abstract.pm, and provides the basic \nfunctionality for indexing GenBank files, and retrieving the \nsequence from them. For best results 'use strict'.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /clone=\"(\\S+)\"/;\n      $1;\n   }\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail - birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n# Let's begin the code...\n\npackage Bio::Index::GenBank;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\nsub _type_stamp {\n    return '__GenBank_FLAT__'; # What kind of index are we?\n}\n\nsub _version {\n    return 0.1;\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file($file_name, $i)\n  Function: Specialized function to index GenBank format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : ","parameters":[{"label":"$self"},{"label":"$file"},{"label":"$i"}]},"containerName":"main::","definition":"sub","line":142,"children":[{"localvar":"my","containerName":"_index_file","name":"$self","definition":"my","line":143,"kind":13},{"kind":13,"line":144,"name":"$file","containerName":"_index_file"},{"name":"$i","containerName":"_index_file","line":145,"kind":13},{"name":"$begin","definition":"my","containerName":"_index_file","localvar":"my","kind":13,"line":148},{"localvar":"my","containerName":"_index_file","definition":"my","name":"$id_parser","line":150,"kind":13},{"name":"$self","containerName":"_index_file","kind":13,"line":150},{"name":"id_parser","containerName":"_index_file","kind":12,"line":150},{"line":152,"kind":13,"localvar":"my","definition":"my","name":"$GENBANK","containerName":"_index_file"},{"name":"$file","containerName":"_index_file","kind":13,"line":152},{"kind":13,"line":153,"containerName":"_index_file","name":"$self"},{"line":153,"kind":12,"containerName":"_index_file","name":"throw"},{"name":"%done_ids","definition":"my","containerName":"_index_file","localvar":"my","kind":13,"line":155},{"line":156,"kind":13,"name":"$GENBANK","containerName":"_index_file"},{"containerName":"_index_file","name":"$begin","kind":13,"line":158},{"line":158,"kind":13,"containerName":"_index_file","name":"$GENBANK"},{"localvar":"my","containerName":"_index_file","name":"$id","definition":"my","line":160,"kind":13},{"containerName":"_index_file","name":"$done_ids","kind":13,"line":161},{"line":161,"kind":13,"name":"$id","containerName":"_index_file"},{"name":"$self","containerName":"_index_file","kind":13,"line":162},{"name":"add_record","containerName":"_index_file","line":162,"kind":12},{"kind":13,"line":162,"containerName":"_index_file","name":"$id"},{"kind":13,"line":162,"containerName":"_index_file","name":"$i"},{"name":"$begin","containerName":"_index_file","line":162,"kind":13},{"kind":13,"line":162,"containerName":"_index_file","name":"$id"},{"containerName":"_index_file","name":"$done_ids","line":163,"kind":13},{"containerName":"_index_file","name":"$id","line":163,"kind":13},{"kind":13,"line":166,"containerName":"_index_file","name":"%done_ids"},{"name":"$GENBANK","containerName":"_index_file","line":169,"kind":13}],"kind":12},{"kind":12,"line":160,"name":"id_parser"},{"kind":12,"line":188,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"id_parser","line":189,"kind":13},{"name":"$code","containerName":"id_parser","kind":13,"line":189},{"kind":13,"line":191,"containerName":"id_parser","name":"$code"},{"containerName":"id_parser","name":"$self","line":192,"kind":13},{"kind":13,"line":192,"containerName":"id_parser","name":"$code"},{"line":194,"kind":13,"name":"$self","containerName":"id_parser"}],"containerName":"main::","definition":"sub","detail":"($self,$code)","signature":{"label":"id_parser($self,$code)","parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"__END__\n#\n# $Id: GenBank.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Abstract\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::GenBank - Interface for indexing one or more GenBank\nfiles (i.e. flat file GenBank format).\n\n=head1 SYNOPSIS\n\n    # Complete code for making an index for one or more GenBank files\n    use strict;\n    use Bio::Index::GenBank;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::GenBank->new(-filename => $Index_File_Name, \n\t\t\t\t                           -write_flag => 'WRITE');\n    $inx->make_index(@ARGV);\n\n    # Print out sequences present in the index in gcg format\n    use Bio::Index::GenBank;\n    use Bio::SeqIO;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::GenBank->new(-filename => $Index_File_Name);\n    my $seqio = Bio::SeqIO->new(-format => 'gcg');\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns Bio::Seq object\n        $seqio->write_seq($seq);\n    }\n\n    # alternatively\n    my ($locus, $acc);\n    my $seq1 = $inx->get_Seq_by_id($locus);\n    my $seq2 = $inx->get_Seq_by_acc($acc);\n\n=head1 DESCRIPTION\n\nBy default the index that is created uses the LOCUS, ACCESSION, and\nVERSION identifiers as keys. Inherits functions for managing dbm \nfiles from Bio::Index::Abstract.pm, and provides the basic \nfunctionality for indexing GenBank files, and retrieving the \nsequence from them. For best results 'use strict'.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /clone=\"(\\S+)\"/;\n      $1;\n   }\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail - birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n# Let's begin the code...\n\npackage Bio::Index::GenBank;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\nsub _type_stamp {\n    return '__GenBank_FLAT__'; # What kind of index are we?\n}\n\nsub _version {\n    return 0.1;\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file($file_name, $i)\n  Function: Specialized function to index GenBank format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n    my( $self,\n\t$file,\t\t\t# File name\n\t$i\t\t\t# Index-number of file being indexed\n\t) = @_;\n\n    my $begin = 0;\n\n    my $id_parser = $self->id_parser;\n\n    open my $GENBANK, '<', $file or \n\t$self->throw(\"Can't open file for read : $file\");\n\n    my %done_ids;\n    while (<$GENBANK>) {\n        if (/^LOCUS/) {\n            $begin = tell($GENBANK) - length($_);\n        }\n        for my $id (&$id_parser($_)) {\n            next if exists $done_ids{$id};\n            $self->add_record($id, $i, $begin) if $id;\n            $done_ids{$id} = 1;\n        }\n        if (m{//}) {\n            %done_ids = ();\n        }\n    }\n    close $GENBANK;\n    return 1;\n}\n\n=head2 id_parser\n\n  Title   : id_parser\n  Usage   : $index->id_parser( CODE )\n  Function: Stores or returns the code used by record_id to\n            parse the ID for record from a string.\n            Returns \\&default_id_parser (see below) if not\n            set. An entry will be added to\n            the index for each string in the list returned.\n  Example : $index->id_parser( \\&my_id_parser )\n  Returns : reference to CODE if called without arguments\n  Args    : CODE"},"name":"id_parser","range":{"start":{"character":0,"line":188},"end":{"line":195,"character":9999}}},{"line":194,"kind":12,"name":"default_id_parser"},{"name":"default_id_parser","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":209},"end":{"character":9999,"line":226}},"kind":12,"children":[{"line":210,"kind":13,"localvar":"my","name":"$line","definition":"my","containerName":"default_id_parser"},{"kind":13,"line":211,"definition":"my","name":"%accs","containerName":"default_id_parser","localvar":"my"},{"line":212,"kind":13,"name":"$line","containerName":"default_id_parser"},{"containerName":"default_id_parser","name":"$accs","line":213,"kind":13},{"containerName":"default_id_parser","name":"$line","kind":13,"line":214},{"kind":13,"line":215,"definition":"my","name":"$acc","containerName":"default_id_parser","localvar":"my"},{"line":216,"kind":13,"name":"$accs","containerName":"default_id_parser"},{"containerName":"default_id_parser","name":"$acc","kind":13,"line":216},{"containerName":"default_id_parser","name":"$x","definition":"my","localvar":"my","kind":13,"line":219},{"localvar":"my","name":"$acc","definition":"my","containerName":"default_id_parser","line":220,"kind":13},{"name":"$acc","containerName":"default_id_parser","line":221,"kind":13},{"kind":13,"line":222,"containerName":"default_id_parser","name":"$accs"},{"name":"$acc","containerName":"default_id_parser","line":222,"kind":13},{"kind":13,"line":225,"containerName":"default_id_parser","name":"%accs"}],"line":209},{"name":"_file_format","range":{"start":{"line":239,"character":0},"end":{"line":242,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"_file_format($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"__END__\n#\n# $Id: GenBank.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Abstract\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::GenBank - Interface for indexing one or more GenBank\nfiles (i.e. flat file GenBank format).\n\n=head1 SYNOPSIS\n\n    # Complete code for making an index for one or more GenBank files\n    use strict;\n    use Bio::Index::GenBank;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::GenBank->new(-filename => $Index_File_Name, \n\t\t\t\t                           -write_flag => 'WRITE');\n    $inx->make_index(@ARGV);\n\n    # Print out sequences present in the index in gcg format\n    use Bio::Index::GenBank;\n    use Bio::SeqIO;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::GenBank->new(-filename => $Index_File_Name);\n    my $seqio = Bio::SeqIO->new(-format => 'gcg');\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns Bio::Seq object\n        $seqio->write_seq($seq);\n    }\n\n    # alternatively\n    my ($locus, $acc);\n    my $seq1 = $inx->get_Seq_by_id($locus);\n    my $seq2 = $inx->get_Seq_by_acc($acc);\n\n=head1 DESCRIPTION\n\nBy default the index that is created uses the LOCUS, ACCESSION, and\nVERSION identifiers as keys. Inherits functions for managing dbm \nfiles from Bio::Index::Abstract.pm, and provides the basic \nfunctionality for indexing GenBank files, and retrieving the \nsequence from them. For best results 'use strict'.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /clone=\"(\\S+)\"/;\n      $1;\n   }\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail - birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n# Let's begin the code...\n\npackage Bio::Index::GenBank;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\nsub _type_stamp {\n    return '__GenBank_FLAT__'; # What kind of index are we?\n}\n\nsub _version {\n    return 0.1;\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file($file_name, $i)\n  Function: Specialized function to index GenBank format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n    my( $self,\n\t$file,\t\t\t# File name\n\t$i\t\t\t# Index-number of file being indexed\n\t) = @_;\n\n    my $begin = 0;\n\n    my $id_parser = $self->id_parser;\n\n    open my $GENBANK, '<', $file or \n\t$self->throw(\"Can't open file for read : $file\");\n\n    my %done_ids;\n    while (<$GENBANK>) {\n        if (/^LOCUS/) {\n            $begin = tell($GENBANK) - length($_);\n        }\n        for my $id (&$id_parser($_)) {\n            next if exists $done_ids{$id};\n            $self->add_record($id, $i, $begin) if $id;\n            $done_ids{$id} = 1;\n        }\n        if (m{//}) {\n            %done_ids = ();\n        }\n    }\n    close $GENBANK;\n    return 1;\n}\n\n=head2 id_parser\n\n  Title   : id_parser\n  Usage   : $index->id_parser( CODE )\n  Function: Stores or returns the code used by record_id to\n            parse the ID for record from a string.\n            Returns \\&default_id_parser (see below) if not\n            set. An entry will be added to\n            the index for each string in the list returned.\n  Example : $index->id_parser( \\&my_id_parser )\n  Returns : reference to CODE if called without arguments\n  Args    : CODE\n\n\nsub id_parser {\n    my ($self,$code) = @_;\n\n    if ($code) {\n\t$self->{'_id_parser'} = $code;\n    }\n    return $self->{'_id_parser'} || \\&default_id_parser;\n}\n\n=head2 default_id_parser\n\n  Title   : default_id_parser\n  Usage   : $id = default_id_parser($line)\n  Function: The default parser for GenBank.pm\n  Returns : Array of specified ids\n  Args    : a line string\n\n\n#'\n\nsub default_id_parser {\n    my $line = shift;\n    my %accs;\n    if ( $line =~ /^LOCUS\\s+(\\S+)/ ) {\n\t$accs{$1}++;\n    } elsif ( $line =~ /^ACCESSION\\s+(.*)/ ) {\n\tfor my $acc ( split(/\\s+/,$1) ) {\n\t    $accs{$acc}++;\n\t}\n    } elsif ( /^VERSION\\s+(.*)/) {\t\n\tmy $x = $1;\n\tfor my $acc ( split(/\\s+/,$1) ) {\n\t    $acc=~ s/GI\\://;\n\t    $accs{$acc}++;\n\t}\n    }\n    keys %accs;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : Internal function for indexing system\n Function: Provides file format for this database\n Example :\n Returns : \n Args    :"},"detail":"($self,@args)","kind":12,"children":[{"kind":13,"line":240,"name":"$self","definition":"my","containerName":"_file_format","localvar":"my"},{"line":240,"kind":13,"name":"@args","containerName":"_file_format"}],"line":239}]}