{"vars":[{"containerName":"","name":"base","kind":2,"line":112},{"containerName":"main::","definition":"sub","name":"_version","range":{"start":{"line":114,"character":0},"end":{"line":115,"character":9999}},"kind":12,"line":114,"children":[]},{"range":{"end":{"line":147,"character":9999},"start":{"line":141,"character":0}},"name":"new","children":[{"kind":13,"line":143,"containerName":"new","name":"$class","definition":"my","localvar":"my"},{"kind":13,"line":143,"containerName":"new","name":"@args"},{"kind":13,"line":145,"containerName":"new","definition":"my","name":"$self","localvar":"my"},{"containerName":"new","name":"$class","line":145,"kind":13},{"line":145,"kind":13,"name":"@args","containerName":"new"}],"line":141,"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Blast - Indexes Blast reports and supports retrieval \nbased on query accession(s)\n\n=head1 SYNOPSIS\n\n  use strict;\n  use Bio::Index::Blast;\n\n  my ($indexfile,$file1,$file2,$query);\n  my $index = Bio::Index::Blast->new(-filename => $indexfile,\n\t\t\t\t                         -write_flag => 1);\n  $index->make_index($file1,$file2);\n\n  my $fh = $index->get_stream($query);\n\n  my $blast_report = Bio::SearchIO->new(-noclose => 1,\n                                        -format  => 'blast',\n                                        -fh      => $fh);\n  my $result = $blast_report->next_result;\n  print $result->algorithm, \"\\n\";\n  my $hit = $result->next_hit;\n  print $hit->description, \"\\n\";\n  my $hsp = $hit->next_hsp;\n  print $hsp->bits, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index on a blast file (or files)\nand provide quick access to the blast report for that accession.\n\nThis also allows for ID parsing using a callback:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\nThe indexer is capable of indexing based on multiple IDs passed back from the\ncallback; this is assuming of course all IDs are unique.\n\nNote: for best results 'use strict'.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::Blast;\nuse strict;\n\nuse IO::String;\nuse Bio::SearchIO;\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version {\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE.","label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::"},{"line":143,"kind":12,"name":"Bio","containerName":"Root::Version::VERSION"},{"containerName":"new","name":"SUPER","line":145,"kind":12},{"name":"fetch_report","range":{"start":{"line":164,"character":0},"end":{"line":171,"character":9999}},"kind":12,"line":164,"children":[{"line":165,"kind":13,"localvar":"my","containerName":"fetch_report","name":"$self","definition":"my"},{"name":"$id","containerName":"fetch_report","kind":13,"line":165},{"localvar":"my","containerName":"fetch_report","name":"$fh","definition":"my","line":166,"kind":13},{"kind":13,"line":166,"containerName":"fetch_report","name":"$self"},{"containerName":"fetch_report","name":"get_stream","line":166,"kind":12},{"containerName":"fetch_report","name":"$id","line":166,"kind":13},{"containerName":"fetch_report","definition":"my","name":"$report","localvar":"my","kind":13,"line":167},{"kind":12,"line":167,"name":"new","containerName":"fetch_report"},{"line":169,"kind":13,"containerName":"fetch_report","name":"$fh"},{"line":170,"kind":13,"name":"$report","containerName":"fetch_report"},{"kind":12,"line":170,"name":"next_result","containerName":"fetch_report"}],"containerName":"main::","definition":"sub","detail":"($self,$id)","signature":{"parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n# $Id: Blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Blast - Indexes Blast reports and supports retrieval \nbased on query accession(s)\n\n=head1 SYNOPSIS\n\n  use strict;\n  use Bio::Index::Blast;\n\n  my ($indexfile,$file1,$file2,$query);\n  my $index = Bio::Index::Blast->new(-filename => $indexfile,\n\t\t\t\t                         -write_flag => 1);\n  $index->make_index($file1,$file2);\n\n  my $fh = $index->get_stream($query);\n\n  my $blast_report = Bio::SearchIO->new(-noclose => 1,\n                                        -format  => 'blast',\n                                        -fh      => $fh);\n  my $result = $blast_report->next_result;\n  print $result->algorithm, \"\\n\";\n  my $hit = $result->next_hit;\n  print $hit->description, \"\\n\";\n  my $hsp = $hit->next_hsp;\n  print $hsp->bits, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index on a blast file (or files)\nand provide quick access to the blast report for that accession.\n\nThis also allows for ID parsing using a callback:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\nThe indexer is capable of indexing based on multiple IDs passed back from the\ncallback; this is assuming of course all IDs are unique.\n\nNote: for best results 'use strict'.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::Blast;\nuse strict;\n\nuse IO::String;\nuse Bio::SearchIO;\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version {\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE.\n\n\nsub new {\n\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n}\n\n=head2 Bio::Index::Blast implemented methods\n\n\n=head2 fetch_report\n\n Title   : fetch_report\n Usage   : my $blastreport = $idx->fetch_report($id);\n Function: Returns a Bio::SearchIO report object \n           for a specific blast report\n Returns : Bio::SearchIO\n Args    : valid id","label":"fetch_report($self,$id)"}},{"name":"Bio","containerName":"SearchIO","kind":12,"line":167},{"range":{"start":{"line":191,"character":0},"end":{"character":9999,"line":229}},"name":"_index_file","line":191,"children":[{"definition":"my","name":"$self","containerName":"_index_file","localvar":"my","kind":13,"line":192},{"kind":13,"line":193,"containerName":"_index_file","name":"$file"},{"containerName":"_index_file","name":"$i","line":194,"kind":13},{"line":197,"kind":13,"localvar":"my","definition":"my","name":"$begin","containerName":"_index_file"},{"containerName":"_index_file","name":"$BLAST","definition":"my","localvar":"my","kind":13,"line":201},{"containerName":"_index_file","name":"$file","line":201,"kind":13},{"containerName":"_index_file","name":"$self","kind":13,"line":201},{"name":"throw","containerName":"_index_file","kind":12,"line":201},{"line":203,"kind":13,"localvar":"my","containerName":"_index_file","definition":"my","name":"@data"},{"kind":13,"line":203,"name":"@records","containerName":"_index_file"},{"kind":13,"line":204,"name":"$indexpoint","definition":"my","containerName":"_index_file","localvar":"my"},{"localvar":"my","name":"$lastline","definition":"my","containerName":"_index_file","line":205,"kind":13},{"kind":13,"line":206,"containerName":"_index_file","definition":"my","name":"$prefix","localvar":"my"},{"containerName":"_index_file","name":"$BLAST","kind":13,"line":209},{"line":216,"kind":13,"name":"$prefix","containerName":"_index_file"},{"containerName":"_index_file","name":"$indexpoint","line":217,"kind":13},{"line":217,"kind":13,"name":"$BLAST","containerName":"_index_file"},{"kind":13,"line":221,"name":"$indexpoint","containerName":"_index_file"},{"kind":13,"line":221,"name":"$BLAST","containerName":"_index_file"},{"containerName":"_index_file","name":"$prefix","kind":13,"line":221},{"localvar":"my","containerName":"_index_file","name":"$id","definition":"my","line":223,"kind":13},{"containerName":"_index_file","name":"$self","line":223,"kind":13},{"containerName":"_index_file","name":"id_parser","line":223,"kind":12},{"containerName":"_index_file","name":"$self","kind":13,"line":224},{"containerName":"_index_file","name":"debug","kind":12,"line":224},{"name":"$self","containerName":"_index_file","kind":13,"line":225},{"containerName":"_index_file","name":"add_record","kind":12,"line":225},{"kind":13,"line":225,"containerName":"_index_file","name":"$id"},{"name":"$i","containerName":"_index_file","kind":13,"line":225},{"name":"$indexpoint","containerName":"_index_file","line":225,"kind":13}],"kind":12,"detail":"($self,$file,$i)","signature":{"parameters":[{"label":"$self"},{"label":"$file"},{"label":"$i"}],"documentation":"1;\n# $Id: Blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Blast - Indexes Blast reports and supports retrieval \nbased on query accession(s)\n\n=head1 SYNOPSIS\n\n  use strict;\n  use Bio::Index::Blast;\n\n  my ($indexfile,$file1,$file2,$query);\n  my $index = Bio::Index::Blast->new(-filename => $indexfile,\n\t\t\t\t                         -write_flag => 1);\n  $index->make_index($file1,$file2);\n\n  my $fh = $index->get_stream($query);\n\n  my $blast_report = Bio::SearchIO->new(-noclose => 1,\n                                        -format  => 'blast',\n                                        -fh      => $fh);\n  my $result = $blast_report->next_result;\n  print $result->algorithm, \"\\n\";\n  my $hit = $result->next_hit;\n  print $hit->description, \"\\n\";\n  my $hsp = $hit->next_hsp;\n  print $hsp->bits, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index on a blast file (or files)\nand provide quick access to the blast report for that accession.\n\nThis also allows for ID parsing using a callback:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\nThe indexer is capable of indexing based on multiple IDs passed back from the\ncallback; this is assuming of course all IDs are unique.\n\nNote: for best results 'use strict'.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::Blast;\nuse strict;\n\nuse IO::String;\nuse Bio::SearchIO;\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version {\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE.\n\n\nsub new {\n\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n}\n\n=head2 Bio::Index::Blast implemented methods\n\n\n=head2 fetch_report\n\n Title   : fetch_report\n Usage   : my $blastreport = $idx->fetch_report($id);\n Function: Returns a Bio::SearchIO report object \n           for a specific blast report\n Returns : Bio::SearchIO\n Args    : valid id\n\n\nsub fetch_report{\n\tmy ($self,$id) = @_;\n\tmy $fh = $self->get_stream($id);\n\tmy $report = Bio::SearchIO->new(-noclose => 1,\n\t\t\t\t\t\t\t\t\t\t\t -format => 'blast',\n\t\t\t\t\t\t\t\t\t\t\t -fh => $fh);\n\treturn $report->next_result;\n}\n\n\n=head2 Require methods from Bio::Index::Abstract\n\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index BLAST report file(s).\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : ","label":"_index_file($self,$file,$i)"},"containerName":"main::","definition":"sub"},{"name":"id_parser","range":{"end":{"line":259,"character":9999},"start":{"character":0,"line":252}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"id_parser","localvar":"my","kind":13,"line":253},{"kind":13,"line":253,"name":"$code","containerName":"id_parser"},{"line":255,"kind":13,"containerName":"id_parser","name":"$code"},{"kind":13,"line":256,"containerName":"id_parser","name":"$self"},{"kind":13,"line":256,"containerName":"id_parser","name":"$code"},{"containerName":"id_parser","name":"$self","kind":13,"line":258}],"line":252,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Blast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Blast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Blast - Indexes Blast reports and supports retrieval \nbased on query accession(s)\n\n=head1 SYNOPSIS\n\n  use strict;\n  use Bio::Index::Blast;\n\n  my ($indexfile,$file1,$file2,$query);\n  my $index = Bio::Index::Blast->new(-filename => $indexfile,\n\t\t\t\t                         -write_flag => 1);\n  $index->make_index($file1,$file2);\n\n  my $fh = $index->get_stream($query);\n\n  my $blast_report = Bio::SearchIO->new(-noclose => 1,\n                                        -format  => 'blast',\n                                        -fh      => $fh);\n  my $result = $blast_report->next_result;\n  print $result->algorithm, \"\\n\";\n  my $hit = $result->next_hit;\n  print $hit->description, \"\\n\";\n  my $hsp = $hit->next_hsp;\n  print $hsp->bits, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index on a blast file (or files)\nand provide quick access to the blast report for that accession.\n\nThis also allows for ID parsing using a callback:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\nThe indexer is capable of indexing based on multiple IDs passed back from the\ncallback; this is assuming of course all IDs are unique.\n\nNote: for best results 'use strict'.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::Blast;\nuse strict;\n\nuse IO::String;\nuse Bio::SearchIO;\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version {\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE.\n\n\nsub new {\n\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n}\n\n=head2 Bio::Index::Blast implemented methods\n\n\n=head2 fetch_report\n\n Title   : fetch_report\n Usage   : my $blastreport = $idx->fetch_report($id);\n Function: Returns a Bio::SearchIO report object \n           for a specific blast report\n Returns : Bio::SearchIO\n Args    : valid id\n\n\nsub fetch_report{\n\tmy ($self,$id) = @_;\n\tmy $fh = $self->get_stream($id);\n\tmy $report = Bio::SearchIO->new(-noclose => 1,\n\t\t\t\t\t\t\t\t\t\t\t -format => 'blast',\n\t\t\t\t\t\t\t\t\t\t\t -fh => $fh);\n\treturn $report->next_result;\n}\n\n\n=head2 Require methods from Bio::Index::Abstract\n\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index BLAST report file(s).\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n\tmy( $self,\n\t\t $file, # File name\n\t\t $i,    # Index-number of file being indexed\n\t  ) = @_;\n\n\tmy( $begin,  # Offset from start of file of the start\n\t\t          # of the last found record.\n\t  );\n\n\topen(my $BLAST, '<', $file) or $self->throw(\"cannot open file $file\\n\");\n\n\tmy (@data, @records);\n\tmy $indexpoint = 0;\n\tmy $lastline = 0;\n\tmy $prefix = '';\n\n\t# fencepost problem: we basically just find the top and the query\n\twhile( <$BLAST> ) {\n\t\t\n\t\t# in recent RPS-BLAST output the only delimiter between result\n\t\t# sections is '^Query=' - in other BLAST outputs you\n\t\t# can use '^(RPS-|T?)BLAST(P?|N?|X?)'\n\n\t\tif ( /^(RPS-|T?)BLAST(P?|N?|X?)/ ) {\n\t\t\t$prefix = $1;\n\t\t\t$indexpoint = tell($BLAST) - length $_;\n\t\t}\n\t\tif ( /^Query=\\s*([^\\n]+)$/ ) {\n\n\t\t\t$indexpoint = tell($BLAST) - length $_ if ( $prefix eq 'RPS-' );\n\n\t\t\tforeach my $id ($self->id_parser()->($1)) {\n\t\t\t\t$self->debug(\"id is $id, begin is $indexpoint\\n\");\n\t\t\t\t$self->add_record($id, $i, $indexpoint);\n\t\t\t}\n\t\t}\n\t}\n}\n\n# shamelessly stolen from Bio::Index::Fasta\n\n=head2 id_parser\n\n  Title   : id_parser\n  Usage   : $index->id_parser( CODE )\n  Function: Stores or returns the code used by record_id to\n            parse the ID for record from a string.  Useful\n            for (for instance) specifying a different\n            parser for different flavours of blast dbs. \n            Returns \\&default_id_parser (see below) if not\n            set. If you supply your own id_parser\n            subroutine, then it should expect a fasta\n            description line.  An entry will be added to\n            the index for each string in the list returned.\n  Example : $index->id_parser( \\&my_id_parser )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE","parameters":[{"label":"$self"},{"label":"$code"}],"label":"id_parser($self,$code)"},"detail":"($self,$code)"},{"name":"default_id_parser","kind":12,"line":258},{"range":{"end":{"line":279,"character":9999},"start":{"character":0,"line":273}},"definition":"sub","name":"default_id_parser","containerName":"main::","children":[],"line":273,"kind":12}],"version":5}