{"version":5,"vars":[{"name":"pod","kind":12,"line":1},{"line":118,"kind":2,"name":"base","containerName":""},{"name":"%NAME_OF","definition":"our","containerName":"main::","line":122,"kind":13},{"kind":2,"line":122,"name":"Generic","containerName":"Bio::SeqFeature"},{"containerName":"main::","name":"$NUM_COL","definition":"our","kind":13,"line":133},{"detail":"($self,%arg)","signature":{"label":"_initialize($self,%arg)","documentation":"=head1 NAME\n\nBio::FeatureIO::ptt - read/write features in PTT format\n\n=head1 SYNOPSIS\n\n # read features \n my $fin = Bio::FeatureIO->new(-file=>'genes.ptt', -format=>'ptt');\n my @cds;\n while (my $f = $fin->next_feature) {\n   push @cds, $f if $f->strand > 0;\n }\n\n # write features (NOT IMPLEMENTED)\n my $fout = Bio::FeatureIO->new(-fh=>\\*STDOUT, -format=>'ptt');\n for my $f (@cds) {\n   $fout->write_feature($f);\n }\n\n=head1 DESCRIPTION\n\nThe PTT file format is a table of protein features. \nIt is used mainly by NCBI who produce PTT files for \nall their published genomes found in L<ftp://ftp.ncbi.nih.gov/genomes/>.\nIt has the following format:\n\n=over 4\n\n* Line 1\n\nDescription of sequence to which the features belong\n eg. \"Leptospira interrogans chromosome II, complete sequence - 0..358943\"\n\nIt is usually equivalent to the DEFINITION line of a Genbank file,\nwith the length of the sequence appended. It is unclear why \"0\" is \nused as a starting range, it should be \"1\".\n\n* Line 2\n\nNumber of feature lines in the table\n eg. \"367 proteins\"\n\n* Line 3\n\nColumn headers, tab separated\n eg. \"Location  Strand  Length  PID Gene  Synonym Code  COG Product\"\n\n Location : \"begin..end\" span of feature\n Strand   : \"+\" or \"-\"\n Length   : number of amino acids excluding the stop codon\n PID      : analogous to Genbank /db_xref=\"GI:xxxxxxxxx\"\n Gene     : analogous to Genbank /gene=\"xxxx\"\n Synonym  : analogous to Genbank /locus_tag=\"xxxx\"\n Synonym  : analogous to Genbank /locus_tag=\"xxxx\"\n COG      : CDD COG code with COG letter categories appended\n Product  : analogous to Genbank /product=\"xxxx\"\n\n* Line 4 onwards\n\nFeature lines, nine columns, tab separated, \"-\" used for empty fields\n eg. \"2491..3423  + 310 24217063  metF  LB002 - COG0685E  5,10-methylenetetrahydrofolate reductase\"\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Torsten Seemann\n\nEmail torsten.seemann AT infotech.monash.edu.au\n\n=head1 CONTRIBUTORS\n\nBased on bed.pm and gff.pm by Allen Day.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::ptt;\n\nuse strict;\nuse base qw(Bio::FeatureIO);\nuse Bio::SeqFeature::Generic;\n\n# map tab-separated column number to field name\nour %NAME_OF = (\n  0 => 'Location',\n  1 => 'Strand',\n  2 => 'Length', \n  3 => 'PID', \n  4 => 'Gene',  \n  5 => 'Synonym',\n  6 => 'Code',  \n  7 => 'COG', \n  8 => 'Product',\n);\nour $NUM_COL = 9;\n\n=head2 _initialize\n\n Title   : _initialize\n Function: Reading? parses the header of the input\n           Writing? ","parameters":[{"label":"$self"},{"label":"%arg"}]},"containerName":"main::","definition":"sub","line":143,"children":[{"kind":13,"line":144,"name":"$self","definition":"my","containerName":"_initialize","localvar":"my"},{"containerName":"_initialize","name":"%arg","line":144,"kind":13},{"kind":13,"line":146,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"%arg","kind":13,"line":146},{"containerName":"_initialize","name":"$self","kind":13,"line":148},{"containerName":"_initialize","name":"mode","line":148,"kind":12},{"localvar":"my","definition":"my","name":"$desc","containerName":"_initialize","line":150,"kind":13},{"line":150,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":12,"line":150,"name":"_readline","containerName":"_initialize"},{"name":"$desc","containerName":"_initialize","line":151,"kind":13},{"line":152,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":12,"line":152,"containerName":"_initialize","name":"description"},{"containerName":"_initialize","name":"$desc","kind":13,"line":152},{"line":154,"kind":13,"localvar":"my","definition":"my","name":"$line","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","kind":13,"line":154},{"containerName":"_initialize","name":"_readline","kind":12,"line":154},{"containerName":"_initialize","name":"$line","kind":13,"line":155},{"containerName":"_initialize","name":"$self","line":155,"kind":13},{"kind":12,"line":155,"containerName":"_initialize","name":"throw"},{"kind":13,"line":156,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"protein_count","line":156,"kind":12},{"kind":13,"line":158,"name":"$self","containerName":"_initialize"},{"kind":12,"line":158,"containerName":"_initialize","name":"_readline"}],"kind":12,"range":{"end":{"line":160,"character":9999},"start":{"line":143,"character":0}},"name":"_initialize"},{"name":"SUPER","containerName":"_initialize","kind":12,"line":146},{"containerName":"main::","name":"next_feature","definition":"sub","range":{"start":{"line":173,"character":0},"end":{"line":190,"character":9999}},"kind":12,"line":173,"children":[{"line":174,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"next_feature"},{"name":"$self","containerName":"next_feature","line":175,"kind":13},{"kind":12,"line":175,"name":"mode","containerName":"next_feature"},{"name":"$line","definition":"my","containerName":"next_feature","localvar":"my","kind":13,"line":177},{"containerName":"next_feature","name":"$self","line":177,"kind":13},{"containerName":"next_feature","name":"_readline","line":177,"kind":12},{"containerName":"next_feature","name":"$line","kind":13,"line":178},{"line":179,"kind":13,"localvar":"my","containerName":"next_feature","definition":"my","name":"@col"},{"line":179,"kind":13,"name":"$line","containerName":"next_feature"},{"containerName":"next_feature","name":"@col","kind":13,"line":180},{"line":180,"kind":13,"containerName":"next_feature","name":"$NUM_COL"},{"line":180,"kind":13,"name":"$self","containerName":"next_feature"},{"kind":12,"line":180,"name":"throw","containerName":"next_feature"},{"kind":13,"line":182,"name":"$col","containerName":"next_feature"},{"line":182,"kind":13,"name":"$self","containerName":"next_feature"},{"line":182,"kind":12,"containerName":"next_feature","name":"throw"},{"kind":13,"line":183,"definition":"my","name":"$feat","containerName":"next_feature","localvar":"my"},{"containerName":"next_feature","name":"new","line":183,"kind":12},{"containerName":"next_feature","name":"$col","kind":13,"line":184},{"line":184,"kind":13,"containerName":"next_feature","name":"$self"},{"name":"throw","containerName":"next_feature","kind":12,"line":184},{"containerName":"next_feature","name":"$feat","kind":13,"line":185},{"line":185,"kind":12,"containerName":"next_feature","name":"strand"},{"name":"$i","definition":"my","containerName":"next_feature","localvar":"my","kind":13,"line":186},{"line":186,"kind":13,"containerName":"next_feature","name":"$NUM_COL"},{"kind":13,"line":187,"name":"$feat","containerName":"next_feature"},{"containerName":"next_feature","name":"add_tag_value","kind":12,"line":187},{"containerName":"next_feature","name":"$NAME_OF","kind":13,"line":187},{"name":"$i","containerName":"next_feature","kind":13,"line":187},{"containerName":"next_feature","name":"$col","line":187,"kind":13},{"kind":13,"line":187,"containerName":"next_feature","name":"$i"},{"line":187,"kind":13,"containerName":"next_feature","name":"$col"},{"line":187,"kind":13,"name":"$i","containerName":"next_feature"},{"name":"$feat","containerName":"next_feature","kind":13,"line":189}]},{"kind":12,"line":183,"containerName":"SeqFeature::Generic","name":"Bio"},{"kind":12,"line":203,"children":[{"line":204,"kind":12,"containerName":"write_feature","name":"throw_not_implemented"}],"containerName":"main::","definition":"sub","name":"write_feature","range":{"end":{"character":9999,"line":205},"start":{"line":203,"character":0}}},{"name":"description","definition":"sub","containerName":"main::","range":{"end":{"line":222,"character":9999},"start":{"line":218,"character":0}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"description","localvar":"my","kind":13,"line":219},{"containerName":"description","name":"$self","line":220,"kind":13},{"name":"$self","containerName":"description","line":221,"kind":13}],"line":218},{"kind":12,"children":[{"kind":13,"line":236,"name":"$self","definition":"my","containerName":"protein_count","localvar":"my"},{"name":"$self","containerName":"protein_count","kind":13,"line":237},{"line":238,"kind":13,"name":"$self","containerName":"protein_count"}],"line":235,"name":"protein_count","definition":"sub","containerName":"main::","range":{"end":{"line":239,"character":9999},"start":{"line":235,"character":0}}}]}