{"vars":[{"containerName":"","name":"base","line":67,"kind":2},{"name":"vars","containerName":"","line":68,"kind":2},{"range":{"start":{"character":0,"line":82},"end":{"line":87,"character":9999}},"name":"new","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: FeatureGroup.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Expression::FeatureGroup\n#\n# Copyright Allen Day <allenday@ucla.edu>, Stanley Nelson <snelson@ucla.edu>\n# Human Genetics, UCLA Medical School, University of California, Los Angeles\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Expression::FeatureGroup - a set of DNA/RNA features.  ISA\nBio::Expression::FeatureI\n\n=head1 SYNOPSIS\n\n#\n\n=head1 DESCRIPTION\n\nA set of DNA/RNA features.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nAllen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Expression::FeatureGroup;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Expression::FeatureI);\nuse vars qw($DEBUG);\n\n=head2 new\n\n Title   : new\n Usage   : $featuregroup = Bio::Expression::FeatureGroup->new(%args);\n Function: create a new featuregroup object\n Returns : a Bio::Expression::FeatureGroup object\n Args    : an optional hash of parameters to be used in initialization:\n           -id    --  the featuregroup ID\n           -type  --  the featuregroup type","label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":83},{"name":"@args","containerName":"new","kind":13,"line":83},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":84},{"name":"$class","containerName":"new","kind":13,"line":84},{"containerName":"new","name":"$self","line":85,"kind":13},{"containerName":"new","name":"_initialize","kind":12,"line":85},{"name":"@args","containerName":"new","line":85,"kind":13},{"name":"$self","containerName":"new","line":86,"kind":13}],"line":82,"kind":12},{"range":{"start":{"line":99,"character":0},"end":{"line":108,"character":9999}},"name":"_initialize","children":[{"kind":13,"line":100,"containerName":"_initialize","definition":"my","name":"$self","localvar":"my"},{"line":100,"kind":13,"containerName":"_initialize","name":"@args"},{"localvar":"my","name":"%param","definition":"my","containerName":"_initialize","line":101,"kind":13},{"kind":13,"line":101,"name":"@args","containerName":"_initialize"},{"name":"$self","containerName":"_initialize","line":103,"kind":13},{"line":103,"kind":12,"name":"type","containerName":"_initialize"},{"containerName":"_initialize","name":"$param","line":103,"kind":13},{"kind":13,"line":104,"name":"$self","containerName":"_initialize"},{"kind":12,"line":104,"name":"id","containerName":"_initialize"},{"kind":13,"line":104,"containerName":"_initialize","name":"$param"},{"line":106,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"@args","line":106,"kind":13},{"name":"$DEBUG","containerName":"_initialize","kind":13,"line":107},{"name":"$DEBUG","containerName":"_initialize","line":107,"kind":13},{"containerName":"_initialize","name":"$self","line":107,"kind":13},{"kind":12,"line":107,"containerName":"_initialize","name":"verbose"}],"line":99,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: FeatureGroup.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Expression::FeatureGroup\n#\n# Copyright Allen Day <allenday@ucla.edu>, Stanley Nelson <snelson@ucla.edu>\n# Human Genetics, UCLA Medical School, University of California, Los Angeles\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Expression::FeatureGroup - a set of DNA/RNA features.  ISA\nBio::Expression::FeatureI\n\n=head1 SYNOPSIS\n\n#\n\n=head1 DESCRIPTION\n\nA set of DNA/RNA features.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nAllen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Expression::FeatureGroup;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Expression::FeatureI);\nuse vars qw($DEBUG);\n\n=head2 new\n\n Title   : new\n Usage   : $featuregroup = Bio::Expression::FeatureGroup->new(%args);\n Function: create a new featuregroup object\n Returns : a Bio::Expression::FeatureGroup object\n Args    : an optional hash of parameters to be used in initialization:\n           -id    --  the featuregroup ID\n           -type  --  the featuregroup type\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = bless {}, $class;\n  $self->_initialize(@args);\n  return $self;\n}\n\n=head2 _initialize\n\n Title   : _initialize\n Usage   : $featuregroup->_initialize(@args);\n Function: initialize the featuregroup object\n Returns : nothing\n Args    : @args","label":"_initialize($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"line":106,"kind":12,"containerName":"_initialize","name":"SUPER"},{"range":{"end":{"line":126,"character":9999},"start":{"line":122,"character":0}},"containerName":"main::","definition":"sub","name":"type","line":122,"children":[{"line":123,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"type"},{"name":"$self","containerName":"type","kind":13,"line":124},{"line":125,"kind":13,"containerName":"type","name":"$self"}],"kind":12},{"name":"type","kind":12,"line":124},{"line":125,"kind":12,"name":"type"},{"line":138,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"id","line":139,"kind":13},{"line":140,"kind":13,"containerName":"id","name":"$self"},{"line":141,"kind":13,"containerName":"id","name":"$self"}],"kind":12,"range":{"start":{"line":138,"character":0},"end":{"line":142,"character":9999}},"containerName":"main::","definition":"sub","name":"id"},{"name":"id","line":140,"kind":12},{"line":141,"kind":12,"name":"id"},{"kind":12,"children":[{"kind":13,"line":157,"name":"$self","definition":"my","containerName":"standard_deviation","localvar":"my"},{"name":"$self","containerName":"standard_deviation","kind":13,"line":158},{"containerName":"standard_deviation","name":"$self","line":159,"kind":13}],"line":156,"name":"standard_deviation","definition":"sub","containerName":"main::","range":{"start":{"line":156,"character":0},"end":{"line":160,"character":9999}}},{"name":"standard_deviation","line":158,"kind":12},{"line":159,"kind":12,"name":"standard_deviation"},{"children":[{"kind":13,"line":174,"containerName":"quantitation","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"quantitation","kind":13,"line":175},{"line":176,"kind":13,"containerName":"quantitation","name":"$self"}],"line":173,"kind":12,"range":{"start":{"line":173,"character":0},"end":{"character":9999,"line":177}},"name":"quantitation","definition":"sub","containerName":"main::"},{"name":"quantitation","kind":12,"line":175},{"kind":12,"line":176,"name":"quantitation"},{"range":{"end":{"character":9999,"line":193},"start":{"character":0,"line":189}},"containerName":"main::","name":"quantitation_units","definition":"sub","line":189,"children":[{"containerName":"quantitation_units","name":"$self","definition":"my","localvar":"my","kind":13,"line":190},{"kind":13,"line":191,"name":"$self","containerName":"quantitation_units"},{"name":"$self","containerName":"quantitation_units","line":192,"kind":13}],"kind":12},{"line":191,"kind":12,"name":"quantitation_units"},{"name":"quantitation_units","kind":12,"line":192},{"line":205,"children":[{"containerName":"presence","definition":"my","name":"$self","localvar":"my","kind":13,"line":206},{"kind":13,"line":207,"containerName":"presence","name":"$self"},{"line":208,"kind":13,"containerName":"presence","name":"$self"}],"kind":12,"range":{"start":{"line":205,"character":0},"end":{"line":209,"character":9999}},"containerName":"main::","definition":"sub","name":"presence"},{"kind":12,"line":207,"name":"presence"},{"name":"presence","line":208,"kind":12},{"range":{"end":{"line":226,"character":9999},"start":{"line":221,"character":0}},"name":"add_feature","signature":{"documentation":"1;\n# $Id: FeatureGroup.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Expression::FeatureGroup\n#\n# Copyright Allen Day <allenday@ucla.edu>, Stanley Nelson <snelson@ucla.edu>\n# Human Genetics, UCLA Medical School, University of California, Los Angeles\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Expression::FeatureGroup - a set of DNA/RNA features.  ISA\nBio::Expression::FeatureI\n\n=head1 SYNOPSIS\n\n#\n\n=head1 DESCRIPTION\n\nA set of DNA/RNA features.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nAllen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Expression::FeatureGroup;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Expression::FeatureI);\nuse vars qw($DEBUG);\n\n=head2 new\n\n Title   : new\n Usage   : $featuregroup = Bio::Expression::FeatureGroup->new(%args);\n Function: create a new featuregroup object\n Returns : a Bio::Expression::FeatureGroup object\n Args    : an optional hash of parameters to be used in initialization:\n           -id    --  the featuregroup ID\n           -type  --  the featuregroup type\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = bless {}, $class;\n  $self->_initialize(@args);\n  return $self;\n}\n\n=head2 _initialize\n\n Title   : _initialize\n Usage   : $featuregroup->_initialize(@args);\n Function: initialize the featuregroup object\n Returns : nothing\n Args    : @args\n\n\nsub _initialize{\n  my ($self,@args) = @_;\n  my %param = @args;\n\n  $self->type($param{-type});\n  $self->id($param{-id}    );\n\n  $self->SUPER::_initialize(@args);\n  $DEBUG = 1 if( ! defined $DEBUG && $self->verbose > 0);\n}\n\n=head2 type\n\n Title   : type\n Usage   : $featuregroup->type($optional_arg);\n Function: get/set the type of the featuregroup\n Comments: this is probably going to be a string like\n           \"quality control\", \"mismatch blah blah\", etc.\n Returns : the featuregroup type\n Args    : a new value for the featuregroup type\n\n\nsub type {\n  my $self = shift;\n  $self->{type} = shift if @_;\n  return $self->{type};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $featuregroup->id($optional_arg);\n Function: get/set the id of the featuregroup\n Returns : the featuregroup id\n Args    : a new value for the featuregroup id\n\n\nsub id {\n  my $self = shift;\n  $self->{id} = shift if @_;\n  return $self->{id};\n}\n\n\n=head2 standard_deviation\n\n Title   : standard_deviation\n Usage   : $featuregroup->standard_deviation($optional_arg);\n Function: get/set the standard deviation of the featuregroup value\n Returns : the featuregroup standard deviation\n Args    : a new value for the featuregroup standard deviation\n Notes   : this method does no calculation, it merely holds a value\n\n\nsub standard_deviation {\n  my $self = shift;\n  $self->{standard_deviation} = shift if @_;\n  return $self->{standard_deviation};\n}\n\n=head2 quantitation\n\n Title   : quantitation\n Usage   : $featuregroup->quantitation($optional_arg);\n Function: get/set the quantitation of the featuregroup\n Returns : the featuregroup's quantitated value\n Args    : a new value for the featuregroup's quantitated value\n Notes   : this method does no calculation, it merely holds a value\n\n\nsub quantitation {\n  my $self = shift;\n  $self->{quantitation} = shift if @_;\n  return $self->{quantitation};\n}\n\n=head2 quantitation_units\n\n Title   : quantitation_units\n Usage   : $featuregroup->quantitation_units($optional_arg);\n Function: get/set the quantitation units of the featuregroup\n Returns : the featuregroup's quantitated value units\n Args    : a new value for the featuregroup's quantitated value units\n\n\nsub quantitation_units {\n  my $self = shift;\n  $self->{quantitation_units} = shift if @_;\n  return $self->{quantitation_units};\n}\n\n=head2 presence\n\n Title   : presence\n Usage   : $featuregroup->presence($optional_arg);\n Function: get/set the presence call of the featuregroup\n Returns : the featuregroup's presence call\n Args    : a new value for the featuregroup's presence call\n\n\nsub presence {\n  my $self = shift;\n  $self->{presence} = shift if @_;\n  return $self->{presence};\n}\n\n=head2 add_feature\n\n Title   : add_feature\n Usage   : $feature_copy = $featuregroup->add_feature($feature);\n Function: add a feature to the featuregroup\n Returns : see this_feature()\n Args    : a Bio::Expression::FeatureI compliant object","parameters":[{"label":"$self"},{"label":"@args"}],"label":"add_feature($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"add_feature","line":222,"kind":13},{"kind":13,"line":222,"name":"@args","containerName":"add_feature"},{"localvar":"my","name":"$feature","definition":"my","containerName":"add_feature","line":223,"kind":13},{"kind":13,"line":223,"containerName":"add_feature","name":"@args"},{"line":224,"kind":13,"name":"$self","containerName":"add_feature"},{"kind":12,"line":224,"containerName":"add_feature","name":"throw"},{"containerName":"add_feature","name":"$feature","line":224,"kind":13},{"name":"isa","containerName":"add_feature","kind":12,"line":224},{"name":"$self","containerName":"add_feature","line":225,"kind":13},{"line":225,"kind":13,"containerName":"add_feature","name":"$feature"}],"line":221,"kind":12},{"name":"features","line":225,"kind":12},{"line":228,"kind":13,"name":"%self","containerName":null},{"kind":12,"line":228,"name":"features"},{"name":"%self","containerName":null,"line":228,"kind":13},{"name":"features","kind":12,"line":228},{"containerName":"main::","definition":"sub","name":"this_feature","range":{"end":{"character":9999,"line":244},"start":{"character":0,"line":241}},"kind":12,"line":241,"children":[{"definition":"my","name":"$self","containerName":"this_feature","localvar":"my","kind":13,"line":242},{"containerName":"this_feature","name":"$self","kind":13,"line":243},{"kind":13,"line":243,"containerName":"this_feature","name":"$self"}]},{"name":"features","kind":12,"line":243},{"name":"features","kind":12,"line":243},{"definition":"sub","name":"each_feature","containerName":"main::","range":{"end":{"line":259,"character":9999},"start":{"character":0,"line":257}},"kind":12,"children":[{"kind":13,"line":258,"containerName":"each_feature","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"each_feature","line":259,"kind":13}],"line":257},{"name":"features","line":259,"kind":12},{"containerName":null,"name":"%self","kind":13,"line":259},{"kind":12,"line":259,"name":"features"},{"name":"each_feature_quantitation","definition":"sub","containerName":"main::","range":{"end":{"line":278,"character":9999},"start":{"character":0,"line":273}},"kind":12,"children":[{"line":274,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"each_feature_quantitation"},{"kind":13,"line":275,"definition":"my","name":"@values","containerName":"each_feature_quantitation","localvar":"my"},{"kind":13,"line":276,"name":"@values","containerName":"each_feature_quantitation"},{"name":"value","containerName":"each_feature_quantitation","kind":12,"line":276},{"name":"$self","containerName":"each_feature_quantitation","kind":13,"line":276},{"name":"each_feature","containerName":"each_feature_quantitation","kind":12,"line":276},{"line":277,"kind":13,"containerName":"each_feature_quantitation","name":"@values"}],"line":273},{"range":{"start":{"character":0,"line":290},"end":{"character":9999,"line":294}},"containerName":"main::","definition":"sub","name":"is_qc","line":290,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"is_qc","line":291,"kind":13},{"kind":13,"line":292,"name":"$self","containerName":"is_qc"},{"containerName":"is_qc","name":"$self","kind":13,"line":293}],"kind":12},{"line":292,"kind":12,"name":"is_qc"},{"kind":12,"line":293,"name":"is_qc"}],"version":5}