{"version":5,"vars":[{"line":97,"kind":2,"name":"base","containerName":""},{"kind":12,"children":[{"kind":13,"line":119,"containerName":"from_align","name":"$self","definition":"my","localvar":"my"},{"line":119,"kind":13,"containerName":"from_align","name":"$aln"},{"containerName":"from_align","name":"$ref","kind":13,"line":119},{"line":121,"kind":13,"name":"$aln","containerName":"from_align"},{"kind":12,"line":121,"name":"isa","containerName":"from_align"},{"kind":13,"line":122,"name":"$self","containerName":"from_align"},{"containerName":"from_align","name":"throw","kind":12,"line":122},{"containerName":"from_align","name":"$aln","line":122,"kind":13},{"line":125,"kind":13,"name":"$ref","containerName":"from_align"},{"definition":"my","name":"$collection","containerName":"from_align","localvar":"my","kind":13,"line":127},{"kind":12,"line":127,"name":"new","containerName":"from_align"},{"name":"$aln","containerName":"from_align","line":132,"kind":13},{"containerName":"from_align","name":"map_chars","line":132,"kind":12},{"kind":13,"line":133,"containerName":"from_align","name":"$cs","definition":"my","localvar":"my"},{"containerName":"from_align","name":"$aln","line":133,"kind":13},{"line":133,"kind":12,"containerName":"from_align","name":"gap_line"},{"name":"$seq1","definition":"my","containerName":"from_align","localvar":"my","kind":13,"line":134},{"containerName":"from_align","name":"$aln","line":134,"kind":13},{"kind":12,"line":134,"containerName":"from_align","name":"get_seq_by_pos"},{"line":135,"kind":13,"localvar":"my","containerName":"from_align","definition":"my","name":"$seq2"},{"kind":13,"line":135,"containerName":"from_align","name":"$aln"},{"name":"get_seq_by_pos","containerName":"from_align","line":135,"kind":12},{"line":136,"kind":13,"name":"$cs","containerName":"from_align"},{"localvar":"my","containerName":"from_align","definition":"my","name":"$lenmatch","line":138,"kind":13},{"kind":13,"line":139,"containerName":"from_align","name":"$start","definition":"my","localvar":"my"},{"name":"$cs","containerName":"from_align","kind":13,"line":139},{"containerName":"from_align","name":"$lenmatch","line":139,"kind":13},{"kind":13,"line":140,"containerName":"from_align","definition":"my","name":"$end","localvar":"my"},{"line":140,"kind":13,"name":"$start","containerName":"from_align"},{"containerName":"from_align","name":"$lenmatch","line":140,"kind":13},{"localvar":"my","containerName":"from_align","definition":"my","name":"$match1","line":141,"kind":13},{"line":142,"kind":12,"name":"new","containerName":"from_align"},{"containerName":"from_align","name":"$seq1","kind":13,"line":142},{"containerName":"from_align","name":"id","kind":12,"line":142},{"line":143,"kind":13,"name":"$seq1","containerName":"from_align"},{"line":143,"kind":12,"name":"location_from_column","containerName":"from_align"},{"name":"$start","containerName":"from_align","kind":13,"line":143},{"kind":12,"line":143,"name":"start","containerName":"from_align"},{"name":"$seq1","containerName":"from_align","kind":13,"line":144},{"name":"location_from_column","containerName":"from_align","line":144,"kind":12},{"kind":13,"line":144,"containerName":"from_align","name":"$end"},{"name":"start","containerName":"from_align","line":144,"kind":12},{"containerName":"from_align","name":"$seq1","kind":13,"line":145},{"kind":12,"line":145,"name":"strand","containerName":"from_align"},{"containerName":"from_align","definition":"my","name":"$match2","localvar":"my","kind":13,"line":147},{"name":"new","containerName":"from_align","line":148,"kind":12},{"line":148,"kind":13,"containerName":"from_align","name":"$seq2"},{"name":"id","containerName":"from_align","kind":12,"line":148},{"kind":13,"line":149,"name":"$seq2","containerName":"from_align"},{"containerName":"from_align","name":"location_from_column","line":149,"kind":12},{"kind":13,"line":149,"name":"$start","containerName":"from_align"},{"line":149,"kind":12,"name":"start","containerName":"from_align"},{"line":150,"kind":13,"containerName":"from_align","name":"$seq2"},{"kind":12,"line":150,"containerName":"from_align","name":"location_from_column"},{"line":150,"kind":13,"containerName":"from_align","name":"$end"},{"line":150,"kind":12,"containerName":"from_align","name":"start"},{"line":151,"kind":13,"name":"$seq2","containerName":"from_align"},{"containerName":"from_align","name":"strand","line":151,"kind":12},{"localvar":"my","containerName":"from_align","name":"$pair","definition":"my","line":153,"kind":13},{"kind":12,"line":154,"containerName":"from_align","name":"new"},{"kind":13,"line":154,"containerName":"from_align","name":"$match1"},{"kind":13,"line":156,"name":"$match2","containerName":"from_align"},{"kind":13,"line":157,"name":"$pair","containerName":"from_align"},{"line":157,"kind":12,"name":"test","containerName":"from_align"},{"kind":13,"line":158,"containerName":"from_align","name":"$self"},{"line":158,"kind":12,"name":"warn","containerName":"from_align"},{"name":"$match1","containerName":"from_align","line":160,"kind":13},{"kind":12,"line":160,"containerName":"from_align","name":"to_FTstring"},{"line":161,"kind":13,"containerName":"from_align","name":"$match1"},{"containerName":"from_align","name":"length","line":161,"kind":12},{"kind":13,"line":162,"name":"$match2","containerName":"from_align"},{"kind":12,"line":162,"containerName":"from_align","name":"to_FTstring"},{"line":163,"kind":13,"name":"$match2","containerName":"from_align"},{"name":"length","containerName":"from_align","kind":12,"line":163},{"name":"$collection","containerName":"from_align","line":165,"kind":13},{"containerName":"from_align","name":"add_mapper","line":165,"kind":12},{"line":165,"kind":13,"name":"$pair","containerName":"from_align"},{"kind":13,"line":167,"containerName":"from_align","name":"$collection"},{"kind":12,"line":167,"containerName":"from_align","name":"each_mapper"},{"containerName":"from_align","name":"$collection","kind":13,"line":167},{"name":"mapper_count","containerName":"from_align","kind":12,"line":167},{"line":168,"kind":13,"name":"$collection","containerName":"from_align"}],"line":118,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$aln"},{"label":"$ref"}],"documentation":"1;\n# $Id: Utils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Coordinate::Utils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Utils - Additional methods to create Bio::Coordinate objects\n\n=head1 SYNOPSIS\n\n    use Bio::Coordinate::Utils;\n    # get a Bio::Align::AlignI compliant object, $aln, somehow\n    # it could be a Bio::SimpleAlign\n\n    $mapper = Bio::Coordinate::Utils->from_align($aln, 1);\n\n    # Build a set of mappers which will map, for each sequence,\n    # that sequence position in the alignment (exon position to alignment \n    # position) \n    my @mappers = Bio::Coordinate::Utils->from_seq_to_alignmentpos($aln);\n\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on or create\nBio::Coordinate::MapperI- compliant objects. . These methods are not\npart of the Bio::Coordinate::MapperI interface and should in general\nnot be essential to the primary function of sequence objects. If you\nare thinking of adding essential functions, it might be better to\ncreate your own sequence class.  See L<Bio::PrimarySeqI>,\nL<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\nJason Stajich jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Coordinate::Utils;\n\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::Collection;\n\nuse strict;\n\nuse base qw(Bio::Root::Root);\n# new inherited from Root\n\n=head2 from_align\n\n Title   : from_align\n Usage   : $mapper = Bio::Coordinate::Utils->from_align($aln, 1);\n Function:\n           Create a mapper out of an alignment.\n           The mapper will return a value only when both ends of\n           the input range find a match.\n\n           Note: This implementation works only on pairwise alignments\n           and is not yet well tested!\n\n Returns : A Bio::Coordinate::MapperI\n Args    : Bio::Align::AlignI object\n           Id for the reference sequence, optional","label":"from_align($self,$aln,$ref)"},"detail":"($self,$aln,$ref)","name":"from_align","range":{"end":{"line":170,"character":9999},"start":{"line":118,"character":0}}},{"line":127,"kind":12,"containerName":"Coordinate::Collection","name":"Bio"},{"containerName":"Location::Simple","name":"Bio","kind":12,"line":141},{"line":147,"kind":12,"name":"Bio","containerName":"Location::Simple"},{"name":"Bio","containerName":"Coordinate::Pair","kind":12,"line":153},{"range":{"start":{"character":0,"line":188},"end":{"character":9999,"line":240}},"name":"from_seq_to_alignmentpos","signature":{"parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"1;\n# $Id: Utils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Coordinate::Utils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Utils - Additional methods to create Bio::Coordinate objects\n\n=head1 SYNOPSIS\n\n    use Bio::Coordinate::Utils;\n    # get a Bio::Align::AlignI compliant object, $aln, somehow\n    # it could be a Bio::SimpleAlign\n\n    $mapper = Bio::Coordinate::Utils->from_align($aln, 1);\n\n    # Build a set of mappers which will map, for each sequence,\n    # that sequence position in the alignment (exon position to alignment \n    # position) \n    my @mappers = Bio::Coordinate::Utils->from_seq_to_alignmentpos($aln);\n\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on or create\nBio::Coordinate::MapperI- compliant objects. . These methods are not\npart of the Bio::Coordinate::MapperI interface and should in general\nnot be essential to the primary function of sequence objects. If you\nare thinking of adding essential functions, it might be better to\ncreate your own sequence class.  See L<Bio::PrimarySeqI>,\nL<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\nJason Stajich jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Coordinate::Utils;\n\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::Collection;\n\nuse strict;\n\nuse base qw(Bio::Root::Root);\n# new inherited from Root\n\n=head2 from_align\n\n Title   : from_align\n Usage   : $mapper = Bio::Coordinate::Utils->from_align($aln, 1);\n Function:\n           Create a mapper out of an alignment.\n           The mapper will return a value only when both ends of\n           the input range find a match.\n\n           Note: This implementation works only on pairwise alignments\n           and is not yet well tested!\n\n Returns : A Bio::Coordinate::MapperI\n Args    : Bio::Align::AlignI object\n           Id for the reference sequence, optional\n\n\nsub from_align {\n   my ($self, $aln, $ref ) = @_;\n\n   $aln->isa('Bio::Align::AlignI') ||\n       $self->throw('Not a Bio::Align::AlignI object but ['. ref($aln). ']');\n\n   # default reference sequence to the first sequence\n   $ref ||= 1;\n   \n   my $collection = Bio::Coordinate::Collection->new(-return_match=>1);\n\n   # this works only for pairs, so split the MSA\n   # take the ref\n   #foreach remaining seq in aln, do:\n   $aln->map_chars('\\.','-');\n   my $cs = $aln->gap_line;\n   my $seq1 = $aln->get_seq_by_pos(1);\n   my $seq2 = $aln->get_seq_by_pos(2);   \n   while ( $cs =~ /([^\\-]+)/g) {\n       # alignment coordinates\n       my $lenmatch = length($1);\n       my $start = pos($cs) - $lenmatch +1;\n       my $end   = $start + $lenmatch -1;\n       my $match1 = Bio::Location::Simple->new\n\t   (-seq_id => $seq1->id,\n\t    -start  => $seq1->location_from_column($start)->start,\n\t    -end    => $seq1->location_from_column($end)->start,\n\t    -strand => $seq1->strand );\n\n       my $match2 = Bio::Location::Simple->new\n\t   (-seq_id => $seq2->id,\n\t    -start  => $seq2->location_from_column($start)->start,\n\t    -end    => $seq2->location_from_column($end)->start,\n\t    -strand => $seq2->strand );       \n       \n       my $pair = Bio::Coordinate::Pair->new\n\t   (-in  => $match1,\n\t    -out => $match2\n\t    );\n       unless( $pair->test ) {\n\t   $self->warn(join(\"\",\n\t\t\t    \"pair align did not pass test ($start..$end):\\n\",\n\t\t\t    \"\\tm1=\",$match1->to_FTstring(), \" len=\",\n\t\t\t    $match1->length, \n\t\t\t    \" m2=\", $match2->to_FTstring(),\" len=\", \n\t\t\t    $match2->length,\"\\n\"));\n       }\n       $collection->add_mapper($pair);\n   }\n   return ($collection->each_mapper)[0] if $collection->mapper_count == 1;\n   return $collection;\n\n}\n\n=head2 from_seq_to_alignmentpos\n\n Title   : from_seq_to_alignmentpos\n Usage   : $mapper = Bio::Coordinate::Utils->from_seq_to_alignmentpos($aln, 1);\n Function:\n           Create a mapper out of an alignment.\n           The mapper will map the position of a sequence into that position\n           in the alignment.\n\n           Will work on alignments of >= 2 sequences \n Returns : An array of Bio::Coordinate::MapperI\n Args    : Bio::Align::AlignI object","label":"from_seq_to_alignmentpos($self,$aln)"},"detail":"($self,$aln)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"from_seq_to_alignmentpos","localvar":"my","kind":13,"line":189},{"line":189,"kind":13,"name":"$aln","containerName":"from_seq_to_alignmentpos"},{"containerName":"from_seq_to_alignmentpos","name":"$aln","line":191,"kind":13},{"name":"isa","containerName":"from_seq_to_alignmentpos","kind":12,"line":191},{"name":"$self","containerName":"from_seq_to_alignmentpos","line":192,"kind":13},{"kind":12,"line":192,"name":"throw","containerName":"from_seq_to_alignmentpos"},{"name":"$aln","containerName":"from_seq_to_alignmentpos","kind":13,"line":192},{"localvar":"my","containerName":"from_seq_to_alignmentpos","definition":"my","name":"@mappers","line":195,"kind":13},{"name":"$aln","containerName":"from_seq_to_alignmentpos","line":196,"kind":13},{"containerName":"from_seq_to_alignmentpos","name":"map_chars","line":196,"kind":12},{"localvar":"my","containerName":"from_seq_to_alignmentpos","definition":"my","name":"$seq","line":197,"kind":13},{"containerName":"from_seq_to_alignmentpos","name":"$aln","kind":13,"line":197},{"name":"each_seq","containerName":"from_seq_to_alignmentpos","line":197,"kind":12},{"kind":13,"line":198,"containerName":"from_seq_to_alignmentpos","definition":"my","name":"$collection","localvar":"my"},{"name":"new","containerName":"from_seq_to_alignmentpos","line":198,"kind":12},{"localvar":"my","containerName":"from_seq_to_alignmentpos","name":"$cs","definition":"my","line":199,"kind":13},{"kind":13,"line":199,"containerName":"from_seq_to_alignmentpos","name":"$seq"},{"name":"seq","containerName":"from_seq_to_alignmentpos","line":199,"kind":12},{"kind":13,"line":201,"name":"$cs","containerName":"from_seq_to_alignmentpos"},{"localvar":"my","name":"$lenmatch","definition":"my","containerName":"from_seq_to_alignmentpos","line":203,"kind":13},{"line":204,"kind":13,"localvar":"my","containerName":"from_seq_to_alignmentpos","name":"$start","definition":"my"},{"kind":13,"line":204,"containerName":"from_seq_to_alignmentpos","name":"$cs"},{"kind":13,"line":204,"name":"$lenmatch","containerName":"from_seq_to_alignmentpos"},{"name":"$end","definition":"my","containerName":"from_seq_to_alignmentpos","localvar":"my","kind":13,"line":205},{"name":"$start","containerName":"from_seq_to_alignmentpos","kind":13,"line":205},{"line":205,"kind":13,"name":"$lenmatch","containerName":"from_seq_to_alignmentpos"},{"line":207,"kind":13,"localvar":"my","definition":"my","name":"$match1","containerName":"from_seq_to_alignmentpos"},{"name":"new","containerName":"from_seq_to_alignmentpos","line":208,"kind":12},{"name":"$seq","containerName":"from_seq_to_alignmentpos","line":208,"kind":13},{"containerName":"from_seq_to_alignmentpos","name":"id","kind":12,"line":208},{"containerName":"from_seq_to_alignmentpos","name":"$seq","line":209,"kind":13},{"name":"location_from_column","containerName":"from_seq_to_alignmentpos","kind":12,"line":209},{"containerName":"from_seq_to_alignmentpos","name":"$start","line":209,"kind":13},{"line":209,"kind":12,"containerName":"from_seq_to_alignmentpos","name":"start"},{"name":"$seq","containerName":"from_seq_to_alignmentpos","line":210,"kind":13},{"line":210,"kind":12,"containerName":"from_seq_to_alignmentpos","name":"location_from_column"},{"kind":13,"line":210,"containerName":"from_seq_to_alignmentpos","name":"$end"},{"kind":12,"line":210,"name":"start","containerName":"from_seq_to_alignmentpos"},{"name":"$seq","containerName":"from_seq_to_alignmentpos","line":211,"kind":13},{"containerName":"from_seq_to_alignmentpos","name":"strand","kind":12,"line":211},{"localvar":"my","containerName":"from_seq_to_alignmentpos","definition":"my","name":"$match2","line":213,"kind":13},{"containerName":"from_seq_to_alignmentpos","name":"new","kind":12,"line":214},{"kind":13,"line":215,"containerName":"from_seq_to_alignmentpos","name":"$start"},{"line":216,"kind":13,"containerName":"from_seq_to_alignmentpos","name":"$end"},{"localvar":"my","containerName":"from_seq_to_alignmentpos","name":"$pair","definition":"my","line":219,"kind":13},{"kind":12,"line":220,"name":"new","containerName":"from_seq_to_alignmentpos"},{"kind":13,"line":220,"containerName":"from_seq_to_alignmentpos","name":"$match1"},{"name":"$match2","containerName":"from_seq_to_alignmentpos","line":222,"kind":13},{"kind":13,"line":223,"name":"$pair","containerName":"from_seq_to_alignmentpos"},{"containerName":"from_seq_to_alignmentpos","name":"test","line":223,"kind":12},{"name":"$self","containerName":"from_seq_to_alignmentpos","kind":13,"line":224},{"containerName":"from_seq_to_alignmentpos","name":"warn","line":224,"kind":12},{"containerName":"from_seq_to_alignmentpos","name":"$match1","line":226,"kind":13},{"line":226,"kind":12,"name":"to_FTstring","containerName":"from_seq_to_alignmentpos"},{"containerName":"from_seq_to_alignmentpos","name":"$match1","kind":13,"line":227},{"containerName":"from_seq_to_alignmentpos","name":"length","kind":12,"line":227},{"kind":13,"line":228,"name":"$match2","containerName":"from_seq_to_alignmentpos"},{"name":"to_FTstring","containerName":"from_seq_to_alignmentpos","kind":12,"line":228},{"containerName":"from_seq_to_alignmentpos","name":"$match2","line":229,"kind":13},{"kind":12,"line":229,"containerName":"from_seq_to_alignmentpos","name":"length"},{"line":231,"kind":13,"containerName":"from_seq_to_alignmentpos","name":"$collection"},{"containerName":"from_seq_to_alignmentpos","name":"add_mapper","kind":12,"line":231},{"kind":13,"line":231,"name":"$pair","containerName":"from_seq_to_alignmentpos"},{"line":233,"kind":13,"name":"$collection","containerName":"from_seq_to_alignmentpos"},{"name":"mapper_count","containerName":"from_seq_to_alignmentpos","kind":12,"line":233},{"name":"@mappers","containerName":"from_seq_to_alignmentpos","kind":13,"line":234},{"line":234,"kind":13,"containerName":"from_seq_to_alignmentpos","name":"$collection"},{"name":"each_mapper","containerName":"from_seq_to_alignmentpos","line":234,"kind":12},{"name":"@mappers","containerName":"from_seq_to_alignmentpos","line":236,"kind":13},{"containerName":"from_seq_to_alignmentpos","name":"$collection","kind":13,"line":236},{"line":239,"kind":13,"name":"@mappers","containerName":"from_seq_to_alignmentpos"}],"line":188,"kind":12},{"containerName":"Coordinate::Collection","name":"Bio","line":198,"kind":12},{"containerName":"Location::Simple","name":"Bio","kind":12,"line":207},{"kind":12,"line":213,"containerName":"Location::Simple","name":"Bio"},{"containerName":"Coordinate::Pair","name":"Bio","line":219,"kind":12}]}