{"vars":[{"name":"base","containerName":"","line":111,"kind":2},{"name":"new","range":{"start":{"character":0,"line":114},"end":{"character":9999,"line":127}},"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)","kind":12,"children":[{"line":115,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":115},{"localvar":"my","name":"$self","definition":"my","containerName":"new","line":116,"kind":13},{"name":"$class","containerName":"new","kind":13,"line":116},{"kind":13,"line":116,"containerName":"new","name":"@args"},{"kind":13,"line":118,"containerName":"new","definition":"my","name":"$in","localvar":"my"},{"containerName":"new","name":"$out","line":118,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":119},{"containerName":"new","name":"_rearrange","line":119,"kind":12},{"name":"@args","containerName":"new","kind":13,"line":122},{"line":124,"kind":13,"name":"$in","containerName":"new"},{"name":"$self","containerName":"new","line":124,"kind":13},{"kind":12,"line":124,"containerName":"new","name":"in"},{"containerName":"new","name":"$in","line":124,"kind":13},{"line":125,"kind":13,"containerName":"new","name":"$out"},{"kind":13,"line":125,"name":"$self","containerName":"new"},{"kind":12,"line":125,"name":"out","containerName":"new"},{"kind":13,"line":125,"name":"$out","containerName":"new"},{"name":"$self","containerName":"new","line":126,"kind":13}],"line":114},{"containerName":"new","name":"SUPER","line":116,"kind":12},{"definition":"sub","containerName":"main::","signature":{"label":"in($self,$value)","documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Pair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::Pair;\n\n  my $match1 = Bio::Location::Simple->new \n      (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  my $match2 = Bio::Location::Simple->new\n      (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n  my $pair = Bio::Coordinate::Pair->new(-in => $match1,\n  \t\t\t\t\t-out => $match2\n                                        );\n  # location to match\n  $pos = Bio::Location::Simple->new \n      (-start => 25, -end => 25, -strand=> -1 );\n\n  # results are in a Bio::Coordinate::Result\n  # they can be Matches and Gaps; are  Bio::LocationIs\n  $res = $pair->map($pos);\n  $res->isa('Bio::Coordinate::Result');\n  $res->each_match == 1;\n  $res->each_gap == 0;\n  $res->each_Location == 1;\n  $res->match->start == 5;\n  $res->match->end == 5;\n  $res->match->strand == -1;\n  $res->match->seq_id eq 'peptide';\n\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThe map() method returns Bio::Coordinate::Results with\nBio::Coordinate::Result::Gaps. The calling code have to deal (process\nor ignore) them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Pair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Match;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($in, $out) =\n\t$self->_rearrange([qw(IN\n                              OUT\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional), Bio::LocationI","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","kind":12,"children":[{"line":141,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"in"},{"line":141,"kind":13,"name":"$value","containerName":"in"},{"name":"$value","containerName":"in","kind":13,"line":142},{"containerName":"in","name":"$self","line":143,"kind":13},{"name":"throw","containerName":"in","kind":12,"line":143},{"line":144,"kind":13,"name":"$value","containerName":"in"},{"containerName":"in","name":"isa","kind":12,"line":144},{"containerName":"in","name":"$self","kind":13,"line":145},{"name":"$value","containerName":"in","line":145,"kind":13},{"kind":13,"line":147,"containerName":"in","name":"$self"}],"line":140,"name":"in","range":{"start":{"line":140,"character":0},"end":{"line":148,"character":9999}}},{"name":"out","range":{"end":{"line":170,"character":9999},"start":{"line":162,"character":0}},"kind":12,"children":[{"kind":13,"line":163,"definition":"my","name":"$self","containerName":"out","localvar":"my"},{"containerName":"out","name":"$value","kind":13,"line":163},{"line":164,"kind":13,"name":"$value","containerName":"out"},{"line":165,"kind":13,"containerName":"out","name":"$self"},{"containerName":"out","name":"throw","kind":12,"line":165},{"kind":13,"line":166,"name":"$value","containerName":"out"},{"containerName":"out","name":"isa","kind":12,"line":166},{"containerName":"out","name":"$self","kind":13,"line":167},{"containerName":"out","name":"$value","kind":13,"line":167},{"name":"$self","containerName":"out","kind":13,"line":169}],"line":162,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Pair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::Pair;\n\n  my $match1 = Bio::Location::Simple->new \n      (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  my $match2 = Bio::Location::Simple->new\n      (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n  my $pair = Bio::Coordinate::Pair->new(-in => $match1,\n  \t\t\t\t\t-out => $match2\n                                        );\n  # location to match\n  $pos = Bio::Location::Simple->new \n      (-start => 25, -end => 25, -strand=> -1 );\n\n  # results are in a Bio::Coordinate::Result\n  # they can be Matches and Gaps; are  Bio::LocationIs\n  $res = $pair->map($pos);\n  $res->isa('Bio::Coordinate::Result');\n  $res->each_match == 1;\n  $res->each_gap == 0;\n  $res->each_Location == 1;\n  $res->match->start == 5;\n  $res->match->end == 5;\n  $res->match->strand == -1;\n  $res->match->seq_id eq 'peptide';\n\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThe map() method returns Bio::Coordinate::Results with\nBio::Coordinate::Result::Gaps. The calling code have to deal (process\nor ignore) them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Pair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Match;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($in, $out) =\n\t$self->_rearrange([qw(IN\n                              OUT\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional), Bio::LocationI\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_in'} = $value;\n   }\n   return $self->{'_in'};\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional), Bio::LocationI","parameters":[{"label":"$self"},{"label":"$value"}],"label":"out($self,$value)"},"detail":"($self,$value)"},{"name":"swap","range":{"end":{"character":9999,"line":188},"start":{"character":0,"line":184}},"kind":12,"children":[{"kind":13,"line":185,"definition":"my","name":"$self","containerName":"swap","localvar":"my"},{"name":"$self","containerName":"swap","line":186,"kind":13},{"name":"$self","containerName":"swap","kind":13,"line":186},{"name":"$self","containerName":"swap","kind":13,"line":186},{"line":186,"kind":13,"containerName":"swap","name":"$self"}],"line":184,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Pair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::Pair;\n\n  my $match1 = Bio::Location::Simple->new \n      (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  my $match2 = Bio::Location::Simple->new\n      (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n  my $pair = Bio::Coordinate::Pair->new(-in => $match1,\n  \t\t\t\t\t-out => $match2\n                                        );\n  # location to match\n  $pos = Bio::Location::Simple->new \n      (-start => 25, -end => 25, -strand=> -1 );\n\n  # results are in a Bio::Coordinate::Result\n  # they can be Matches and Gaps; are  Bio::LocationIs\n  $res = $pair->map($pos);\n  $res->isa('Bio::Coordinate::Result');\n  $res->each_match == 1;\n  $res->each_gap == 0;\n  $res->each_Location == 1;\n  $res->match->start == 5;\n  $res->match->end == 5;\n  $res->match->strand == -1;\n  $res->match->seq_id eq 'peptide';\n\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThe map() method returns Bio::Coordinate::Results with\nBio::Coordinate::Result::Gaps. The calling code have to deal (process\nor ignore) them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Pair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Match;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($in, $out) =\n\t$self->_rearrange([qw(IN\n                              OUT\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional), Bio::LocationI\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_in'} = $value;\n   }\n   return $self->{'_in'};\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional), Bio::LocationI\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid output coordinate Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_out'} = $value;\n   }\n   return $self->{'_out'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of mapping; input <-> output\n Example :\n Returns : 1\n Args    : ","label":"swap($self)"},"detail":"($self)"},{"range":{"start":{"line":201,"character":0},"end":{"line":209,"character":9999}},"name":"strand","line":201,"children":[{"localvar":"my","containerName":"strand","name":"$self","definition":"my","line":202,"kind":13},{"name":"$self","containerName":"strand","kind":13,"line":203},{"name":"warn","containerName":"strand","line":203,"kind":12},{"line":204,"kind":13,"name":"$self","containerName":"strand"},{"kind":12,"line":204,"containerName":"strand","name":"out"},{"containerName":"strand","name":"$self","kind":13,"line":205},{"name":"warn","containerName":"strand","kind":12,"line":205},{"name":"$self","containerName":"strand","line":206,"kind":13},{"line":206,"kind":12,"name":"in","containerName":"strand"},{"containerName":"strand","name":"$self","kind":13,"line":208},{"containerName":"strand","name":"in","kind":12,"line":208},{"line":208,"kind":12,"containerName":"strand","name":"strand"},{"name":"$self","containerName":"strand","line":208,"kind":13},{"kind":12,"line":208,"name":"out","containerName":"strand"},{"name":"strand","containerName":"strand","kind":12,"line":208}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Pair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::Pair;\n\n  my $match1 = Bio::Location::Simple->new \n      (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  my $match2 = Bio::Location::Simple->new\n      (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n  my $pair = Bio::Coordinate::Pair->new(-in => $match1,\n  \t\t\t\t\t-out => $match2\n                                        );\n  # location to match\n  $pos = Bio::Location::Simple->new \n      (-start => 25, -end => 25, -strand=> -1 );\n\n  # results are in a Bio::Coordinate::Result\n  # they can be Matches and Gaps; are  Bio::LocationIs\n  $res = $pair->map($pos);\n  $res->isa('Bio::Coordinate::Result');\n  $res->each_match == 1;\n  $res->each_gap == 0;\n  $res->each_Location == 1;\n  $res->match->start == 5;\n  $res->match->end == 5;\n  $res->match->strand == -1;\n  $res->match->seq_id eq 'peptide';\n\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThe map() method returns Bio::Coordinate::Results with\nBio::Coordinate::Result::Gaps. The calling code have to deal (process\nor ignore) them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Pair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Match;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($in, $out) =\n\t$self->_rearrange([qw(IN\n                              OUT\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional), Bio::LocationI\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_in'} = $value;\n   }\n   return $self->{'_in'};\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional), Bio::LocationI\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid output coordinate Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_out'} = $value;\n   }\n   return $self->{'_out'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of mapping; input <-> output\n Example :\n Returns : 1\n Args    : \n\n\nsub swap {\n   my ($self) = @_;\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   return 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand;\n Function: Get strand value for the pair\n Example :\n Returns : ( 1 | 0 | -1 )\n Args    :","label":"strand($self)"},"containerName":"main::","definition":"sub"},{"kind":12,"line":222,"children":[{"localvar":"my","containerName":"test","name":"$self","definition":"my","line":223,"kind":13},{"name":"$self","containerName":"test","line":224,"kind":13},{"kind":12,"line":224,"name":"warn","containerName":"test"},{"kind":13,"line":225,"containerName":"test","name":"$self"},{"kind":12,"line":225,"name":"out","containerName":"test"},{"line":226,"kind":13,"name":"$self","containerName":"test"},{"kind":12,"line":226,"name":"warn","containerName":"test"},{"name":"$self","containerName":"test","kind":13,"line":227},{"name":"in","containerName":"test","kind":12,"line":227},{"containerName":"test","name":"$self","kind":13,"line":228},{"name":"in","containerName":"test","kind":12,"line":228},{"kind":12,"line":228,"name":"end","containerName":"test"},{"line":228,"kind":13,"name":"$self","containerName":"test"},{"line":228,"kind":12,"name":"in","containerName":"test"},{"line":228,"kind":12,"containerName":"test","name":"start"},{"kind":13,"line":228,"name":"$self","containerName":"test"},{"name":"out","containerName":"test","line":228,"kind":12},{"kind":12,"line":228,"containerName":"test","name":"end"},{"kind":13,"line":228,"name":"$self","containerName":"test"},{"name":"out","containerName":"test","kind":12,"line":228},{"name":"start","containerName":"test","line":228,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Pair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::Pair;\n\n  my $match1 = Bio::Location::Simple->new \n      (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  my $match2 = Bio::Location::Simple->new\n      (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n  my $pair = Bio::Coordinate::Pair->new(-in => $match1,\n  \t\t\t\t\t-out => $match2\n                                        );\n  # location to match\n  $pos = Bio::Location::Simple->new \n      (-start => 25, -end => 25, -strand=> -1 );\n\n  # results are in a Bio::Coordinate::Result\n  # they can be Matches and Gaps; are  Bio::LocationIs\n  $res = $pair->map($pos);\n  $res->isa('Bio::Coordinate::Result');\n  $res->each_match == 1;\n  $res->each_gap == 0;\n  $res->each_Location == 1;\n  $res->match->start == 5;\n  $res->match->end == 5;\n  $res->match->strand == -1;\n  $res->match->seq_id eq 'peptide';\n\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThe map() method returns Bio::Coordinate::Results with\nBio::Coordinate::Result::Gaps. The calling code have to deal (process\nor ignore) them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Pair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Match;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($in, $out) =\n\t$self->_rearrange([qw(IN\n                              OUT\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional), Bio::LocationI\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_in'} = $value;\n   }\n   return $self->{'_in'};\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional), Bio::LocationI\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid output coordinate Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_out'} = $value;\n   }\n   return $self->{'_out'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of mapping; input <-> output\n Example :\n Returns : 1\n Args    : \n\n\nsub swap {\n   my ($self) = @_;\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   return 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand;\n Function: Get strand value for the pair\n Example :\n Returns : ( 1 | 0 | -1 )\n Args    :\n\n\nsub strand {\n   my ($self) = @_;\n   $self->warn(\"Outgoing coordinates are not defined\")\n       unless $self->out;\n   $self->warn(\"Incoming coordinates are not defined\")\n       unless $self->in;\n\n   return ($self->in->strand || 0) * ($self->out->strand || 0);\n}\n\n=head2 test\n\n Title   : test\n Usage   : $obj->test;\n Function: test that both components are of the same length\n Example :\n Returns : ( 1 | undef )\n Args    :","label":"test($self)"},"name":"test","range":{"start":{"character":0,"line":222},"end":{"line":229,"character":9999}}},{"signature":{"documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Pair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::Pair;\n\n  my $match1 = Bio::Location::Simple->new \n      (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  my $match2 = Bio::Location::Simple->new\n      (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n  my $pair = Bio::Coordinate::Pair->new(-in => $match1,\n  \t\t\t\t\t-out => $match2\n                                        );\n  # location to match\n  $pos = Bio::Location::Simple->new \n      (-start => 25, -end => 25, -strand=> -1 );\n\n  # results are in a Bio::Coordinate::Result\n  # they can be Matches and Gaps; are  Bio::LocationIs\n  $res = $pair->map($pos);\n  $res->isa('Bio::Coordinate::Result');\n  $res->each_match == 1;\n  $res->each_gap == 0;\n  $res->each_Location == 1;\n  $res->match->start == 5;\n  $res->match->end == 5;\n  $res->match->strand == -1;\n  $res->match->seq_id eq 'peptide';\n\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThe map() method returns Bio::Coordinate::Results with\nBio::Coordinate::Result::Gaps. The calling code have to deal (process\nor ignore) them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Pair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Match;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($in, $out) =\n\t$self->_rearrange([qw(IN\n                              OUT\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional), Bio::LocationI\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_in'} = $value;\n   }\n   return $self->{'_in'};\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional), Bio::LocationI\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid output coordinate Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_out'} = $value;\n   }\n   return $self->{'_out'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of mapping; input <-> output\n Example :\n Returns : 1\n Args    : \n\n\nsub swap {\n   my ($self) = @_;\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   return 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand;\n Function: Get strand value for the pair\n Example :\n Returns : ( 1 | 0 | -1 )\n Args    :\n\n\nsub strand {\n   my ($self) = @_;\n   $self->warn(\"Outgoing coordinates are not defined\")\n       unless $self->out;\n   $self->warn(\"Incoming coordinates are not defined\")\n       unless $self->in;\n\n   return ($self->in->strand || 0) * ($self->out->strand || 0);\n}\n\n=head2 test\n\n Title   : test\n Usage   : $obj->test;\n Function: test that both components are of the same length\n Example :\n Returns : ( 1 | undef )\n Args    :\n\n\nsub test {\n   my ($self) = @_;\n   $self->warn(\"Outgoing coordinates are not defined\")\n       unless $self->out;\n   $self->warn(\"Incoming coordinates are not defined\")\n       unless $self->in;\n   return ($self->in->end - $self->in->start) == ($self->out->end - $self->out->start);\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map($pos);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new Bio::LocationI in the output coordinate system or undef\n Args    : Bio::LocationI object","parameters":[{"label":"$self"},{"label":"$value"}],"label":"map($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"map","definition":"my","name":"$self","line":245,"kind":13},{"name":"$value","containerName":"map","kind":13,"line":245},{"line":247,"kind":13,"name":"$self","containerName":"map"},{"kind":12,"line":247,"name":"throw","containerName":"map"},{"name":"$value","containerName":"map","kind":13,"line":248},{"containerName":"map","name":"$self","kind":13,"line":249},{"name":"throw","containerName":"map","kind":12,"line":249},{"name":"$value","containerName":"map","kind":13,"line":250},{"line":250,"kind":12,"containerName":"map","name":"isa"},{"name":"$self","containerName":"map","kind":13,"line":251},{"containerName":"map","name":"throw","line":251,"kind":12},{"containerName":"map","name":"$self","kind":13,"line":252},{"name":"in","containerName":"map","kind":12,"line":252},{"name":"$self","containerName":"map","kind":13,"line":253},{"name":"throw","containerName":"map","kind":12,"line":253},{"containerName":"map","name":"$self","kind":13,"line":254},{"kind":12,"line":254,"containerName":"map","name":"out"},{"kind":13,"line":257,"containerName":"map","name":"$value"},{"kind":12,"line":257,"name":"isa","containerName":"map"},{"line":259,"kind":13,"localvar":"my","definition":"my","name":"$result","containerName":"map"},{"containerName":"map","name":"new","line":259,"kind":12},{"containerName":"map","name":"$loc","definition":"my","localvar":"my","kind":13,"line":260},{"line":260,"kind":13,"containerName":"map","name":"$value"},{"name":"sub_Location","containerName":"map","line":260,"kind":12},{"line":261,"kind":13,"localvar":"my","definition":"my","name":"$res","containerName":"map"},{"name":"$self","containerName":"map","line":261,"kind":13},{"containerName":"map","name":"_map","line":261,"kind":12},{"name":"$loc","containerName":"map","line":261,"kind":13},{"containerName":"map","name":"$result","kind":13,"line":262},{"name":"add_sub_Location","containerName":"map","line":262,"kind":12},{"line":262,"kind":13,"name":"$res","containerName":"map"},{"line":262,"kind":12,"containerName":"map","name":"each_Location"},{"line":264,"kind":13,"name":"$result","containerName":"map"},{"containerName":"map","name":"$self","line":266,"kind":13},{"kind":12,"line":266,"name":"_map","containerName":"map"},{"line":266,"kind":13,"containerName":"map","name":"$value"}],"line":244,"kind":12,"range":{"start":{"character":0,"line":244},"end":{"character":9999,"line":268}},"name":"map"},{"name":"Bio","containerName":"Coordinate::Result","kind":12,"line":259},{"range":{"end":{"character":9999,"line":438},"start":{"character":0,"line":284}},"name":"_map","signature":{"label":"_map($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Pair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::Pair;\n\n  my $match1 = Bio::Location::Simple->new \n      (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  my $match2 = Bio::Location::Simple->new\n      (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n  my $pair = Bio::Coordinate::Pair->new(-in => $match1,\n  \t\t\t\t\t-out => $match2\n                                        );\n  # location to match\n  $pos = Bio::Location::Simple->new \n      (-start => 25, -end => 25, -strand=> -1 );\n\n  # results are in a Bio::Coordinate::Result\n  # they can be Matches and Gaps; are  Bio::LocationIs\n  $res = $pair->map($pos);\n  $res->isa('Bio::Coordinate::Result');\n  $res->each_match == 1;\n  $res->each_gap == 0;\n  $res->each_Location == 1;\n  $res->match->start == 5;\n  $res->match->end == 5;\n  $res->match->strand == -1;\n  $res->match->seq_id eq 'peptide';\n\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThe map() method returns Bio::Coordinate::Results with\nBio::Coordinate::Result::Gaps. The calling code have to deal (process\nor ignore) them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Pair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Match;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($in, $out) =\n\t$self->_rearrange([qw(IN\n                              OUT\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional), Bio::LocationI\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_in'} = $value;\n   }\n   return $self->{'_in'};\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional), Bio::LocationI\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid output coordinate Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_out'} = $value;\n   }\n   return $self->{'_out'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of mapping; input <-> output\n Example :\n Returns : 1\n Args    : \n\n\nsub swap {\n   my ($self) = @_;\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   return 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand;\n Function: Get strand value for the pair\n Example :\n Returns : ( 1 | 0 | -1 )\n Args    :\n\n\nsub strand {\n   my ($self) = @_;\n   $self->warn(\"Outgoing coordinates are not defined\")\n       unless $self->out;\n   $self->warn(\"Incoming coordinates are not defined\")\n       unless $self->in;\n\n   return ($self->in->strand || 0) * ($self->out->strand || 0);\n}\n\n=head2 test\n\n Title   : test\n Usage   : $obj->test;\n Function: test that both components are of the same length\n Example :\n Returns : ( 1 | undef )\n Args    :\n\n\nsub test {\n   my ($self) = @_;\n   $self->warn(\"Outgoing coordinates are not defined\")\n       unless $self->out;\n   $self->warn(\"Incoming coordinates are not defined\")\n       unless $self->in;\n   return ($self->in->end - $self->in->start) == ($self->out->end - $self->out->start);\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map($pos);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new Bio::LocationI in the output coordinate system or undef\n Args    : Bio::LocationI object\n\n\nsub map {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a value.\")\n       unless defined $value;\n   $self->throw(\"I need a Bio::Location, not [$value]\")\n       unless $value->isa('Bio::LocationI');\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->in;\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->out;\n\n\n   if ($value->isa(\"Bio::Location::SplitLocationI\")) {\n\n       my $result = Bio::Coordinate::Result->new();\n       foreach my $loc ( $value->sub_Location(1) ) {\n           my $res = $self->_map($loc);\n           map { $result->add_sub_Location($_) } $res->each_Location;\n       }\n       return $result;\n   } else {\n       return $self->_map($value);\n   }\n}\n\n\n=head2 _map\n\n Title   : _map\n Usage   : $newpos = $obj->_map($simpleloc);\n Function: Internal method that does the actual mapping. Called\n           multiple times by map() if the location to be mapped is a\n           split location\n Example :\n Returns : new location in the output coordinate system or undef\n Args    : Bio::Location::Simple"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"line":285,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_map"},{"line":285,"kind":13,"name":"$value","containerName":"_map"},{"name":"$result","definition":"my","containerName":"_map","localvar":"my","kind":13,"line":287},{"containerName":"_map","name":"new","kind":12,"line":287},{"localvar":"my","name":"$offset","definition":"my","containerName":"_map","line":289,"kind":13},{"containerName":"_map","name":"$self","kind":13,"line":289},{"name":"in","containerName":"_map","line":289,"kind":12},{"name":"start","containerName":"_map","line":289,"kind":12},{"containerName":"_map","name":"$self","kind":13,"line":289},{"name":"out","containerName":"_map","kind":12,"line":289},{"line":289,"kind":12,"containerName":"_map","name":"start"},{"containerName":"_map","definition":"my","name":"$start","localvar":"my","kind":13,"line":290},{"kind":13,"line":290,"name":"$value","containerName":"_map"},{"line":290,"kind":12,"containerName":"_map","name":"start"},{"name":"$offset","containerName":"_map","line":290,"kind":13},{"line":291,"kind":13,"localvar":"my","containerName":"_map","definition":"my","name":"$end"},{"line":291,"kind":13,"name":"$value","containerName":"_map"},{"containerName":"_map","name":"end","kind":12,"line":291},{"name":"$offset","containerName":"_map","kind":13,"line":291},{"kind":13,"line":293,"definition":"my","name":"$match","containerName":"_map","localvar":"my"},{"kind":12,"line":293,"name":"new","containerName":"_map"},{"name":"$match","containerName":"_map","line":294,"kind":13},{"line":294,"kind":12,"containerName":"_map","name":"location_type"},{"line":294,"kind":13,"containerName":"_map","name":"$value"},{"containerName":"_map","name":"location_type","kind":12,"line":294},{"containerName":"_map","name":"$match","line":295,"kind":13},{"containerName":"_map","name":"strand","kind":12,"line":295},{"name":"$self","containerName":"_map","kind":13,"line":295},{"line":295,"kind":12,"name":"strand","containerName":"_map"},{"containerName":"_map","name":"$start","line":300,"kind":13},{"containerName":"_map","name":"$self","kind":13,"line":300},{"name":"out","containerName":"_map","line":300,"kind":12},{"kind":12,"line":300,"containerName":"_map","name":"start"},{"line":300,"kind":13,"name":"$end","containerName":"_map"},{"containerName":"_map","name":"$self","kind":13,"line":300},{"line":300,"kind":12,"name":"out","containerName":"_map"},{"kind":12,"line":300,"containerName":"_map","name":"end"},{"line":302,"kind":13,"name":"$match","containerName":"_map"},{"kind":12,"line":302,"containerName":"_map","name":"seq_id"},{"name":"$self","containerName":"_map","line":302,"kind":13},{"line":302,"kind":12,"name":"out","containerName":"_map"},{"containerName":"_map","name":"seq_id","kind":12,"line":302},{"containerName":"_map","name":"$result","kind":13,"line":303},{"name":"seq_id","containerName":"_map","kind":12,"line":303},{"containerName":"_map","name":"$self","kind":13,"line":303},{"name":"out","containerName":"_map","line":303,"kind":12},{"containerName":"_map","name":"seq_id","kind":12,"line":303},{"name":"$self","containerName":"_map","line":305,"kind":13},{"containerName":"_map","name":"strand","kind":12,"line":305},{"name":"$match","containerName":"_map","kind":13,"line":306},{"name":"start","containerName":"_map","line":306,"kind":12},{"kind":13,"line":306,"name":"$start","containerName":"_map"},{"containerName":"_map","name":"$match","line":307,"kind":13},{"kind":12,"line":307,"containerName":"_map","name":"end"},{"kind":13,"line":307,"name":"$end","containerName":"_map"},{"line":309,"kind":13,"name":"$match","containerName":"_map"},{"kind":12,"line":309,"name":"start","containerName":"_map"},{"name":"$self","containerName":"_map","kind":13,"line":309},{"line":309,"kind":12,"containerName":"_map","name":"out"},{"name":"end","containerName":"_map","kind":12,"line":309},{"line":309,"kind":13,"name":"$end","containerName":"_map"},{"line":309,"kind":13,"containerName":"_map","name":"$self"},{"containerName":"_map","name":"out","kind":12,"line":309},{"containerName":"_map","name":"start","kind":12,"line":309},{"kind":13,"line":310,"containerName":"_map","name":"$match"},{"name":"end","containerName":"_map","kind":12,"line":310},{"name":"$self","containerName":"_map","kind":13,"line":310},{"name":"out","containerName":"_map","line":310,"kind":12},{"kind":12,"line":310,"containerName":"_map","name":"end"},{"containerName":"_map","name":"$start","kind":13,"line":310},{"line":310,"kind":13,"containerName":"_map","name":"$self"},{"containerName":"_map","name":"out","kind":12,"line":310},{"containerName":"_map","name":"start","kind":12,"line":310},{"containerName":"_map","name":"$value","kind":13,"line":312},{"kind":12,"line":312,"containerName":"_map","name":"strand"},{"line":313,"kind":13,"containerName":"_map","name":"$match"},{"name":"strand","containerName":"_map","line":313,"kind":12},{"line":313,"kind":13,"containerName":"_map","name":"$match"},{"containerName":"_map","name":"strand","line":313,"kind":12},{"name":"$value","containerName":"_map","kind":13,"line":313},{"name":"strand","containerName":"_map","kind":12,"line":313},{"line":314,"kind":13,"containerName":"_map","name":"$result"},{"line":314,"kind":12,"containerName":"_map","name":"strand"},{"containerName":"_map","name":"$match","line":314,"kind":13},{"name":"strand","containerName":"_map","kind":12,"line":314},{"kind":13,"line":316,"name":"$match","containerName":"_map"},{"name":"$result","containerName":"_map","line":317,"kind":13},{"containerName":"_map","name":"add_sub_Location","kind":12,"line":317},{"line":317,"kind":13,"containerName":"_map","name":"$match"},{"line":322,"kind":13,"containerName":"_map","name":"$end"},{"line":322,"kind":13,"name":"$self","containerName":"_map"},{"containerName":"_map","name":"out","line":322,"kind":12},{"kind":12,"line":322,"name":"start","containerName":"_map"},{"containerName":"_map","name":"$start","line":322,"kind":13},{"line":322,"kind":13,"containerName":"_map","name":"$self"},{"name":"out","containerName":"_map","kind":12,"line":322},{"line":322,"kind":12,"name":"end","containerName":"_map"},{"kind":13,"line":324,"name":"$value","containerName":"_map"},{"line":324,"kind":12,"containerName":"_map","name":"location_type"},{"name":"$end","containerName":"_map","line":325,"kind":13},{"kind":13,"line":325,"containerName":"_map","name":"$self"},{"line":325,"kind":12,"containerName":"_map","name":"out"},{"containerName":"_map","name":"start","kind":12,"line":325},{"containerName":"_map","name":"$start","line":325,"kind":13},{"kind":13,"line":325,"containerName":"_map","name":"$self"},{"containerName":"_map","name":"out","line":325,"kind":12},{"containerName":"_map","name":"end","line":325,"kind":12},{"containerName":"_map","name":"$match","line":327,"kind":13},{"name":"seq_id","containerName":"_map","line":327,"kind":12},{"line":327,"kind":13,"containerName":"_map","name":"$self"},{"kind":12,"line":327,"containerName":"_map","name":"in"},{"kind":12,"line":327,"name":"seq_id","containerName":"_map"},{"containerName":"_map","name":"$result","kind":13,"line":328},{"name":"seq_id","containerName":"_map","line":328,"kind":12},{"name":"$self","containerName":"_map","line":328,"kind":13},{"kind":12,"line":328,"name":"in","containerName":"_map"},{"name":"seq_id","containerName":"_map","line":328,"kind":12},{"containerName":"_map","name":"$match","kind":13,"line":329},{"line":329,"kind":12,"containerName":"_map","name":"start"},{"line":329,"kind":13,"name":"$value","containerName":"_map"},{"name":"start","containerName":"_map","kind":12,"line":329},{"kind":13,"line":330,"containerName":"_map","name":"$match"},{"containerName":"_map","name":"end","kind":12,"line":330},{"kind":13,"line":330,"containerName":"_map","name":"$value"},{"line":330,"kind":12,"containerName":"_map","name":"end"},{"containerName":"_map","name":"$match","kind":13,"line":331},{"kind":12,"line":331,"name":"strand","containerName":"_map"},{"kind":13,"line":331,"containerName":"_map","name":"$value"},{"kind":12,"line":331,"name":"strand","containerName":"_map"},{"line":333,"kind":13,"name":"$match","containerName":"_map"},{"kind":13,"line":334,"name":"$result","containerName":"_map"},{"name":"add_sub_Location","containerName":"_map","line":334,"kind":12},{"kind":13,"line":334,"name":"$match","containerName":"_map"},{"name":"$start","containerName":"_map","line":339,"kind":13},{"name":"$self","containerName":"_map","kind":13,"line":339},{"kind":12,"line":339,"name":"out","containerName":"_map"},{"kind":12,"line":339,"name":"start","containerName":"_map"},{"line":339,"kind":13,"name":"$end","containerName":"_map"},{"kind":13,"line":339,"name":"$self","containerName":"_map"},{"kind":12,"line":339,"name":"out","containerName":"_map"},{"kind":12,"line":339,"containerName":"_map","name":"end"},{"line":341,"kind":13,"name":"$result","containerName":"_map"},{"line":341,"kind":12,"name":"seq_id","containerName":"_map"},{"kind":13,"line":341,"containerName":"_map","name":"$self"},{"containerName":"_map","name":"out","line":341,"kind":12},{"kind":12,"line":341,"name":"seq_id","containerName":"_map"},{"kind":13,"line":342,"containerName":"_map","name":"$value"},{"containerName":"_map","name":"strand","line":342,"kind":12},{"name":"$match","containerName":"_map","line":343,"kind":13},{"line":343,"kind":12,"containerName":"_map","name":"strand"},{"line":343,"kind":13,"containerName":"_map","name":"$match"},{"line":343,"kind":12,"containerName":"_map","name":"strand"},{"line":343,"kind":13,"containerName":"_map","name":"$value"},{"kind":12,"line":343,"containerName":"_map","name":"strand"},{"containerName":"_map","name":"$result","line":344,"kind":13},{"line":344,"kind":12,"containerName":"_map","name":"strand"},{"name":"$match","containerName":"_map","line":344,"kind":13},{"kind":12,"line":344,"name":"strand","containerName":"_map"},{"line":346,"kind":13,"localvar":"my","definition":"my","name":"$gap","containerName":"_map"},{"name":"new","containerName":"_map","line":346,"kind":12},{"kind":13,"line":347,"containerName":"_map","name":"$gap"},{"containerName":"_map","name":"start","kind":12,"line":347},{"containerName":"_map","name":"$value","kind":13,"line":347},{"containerName":"_map","name":"start","line":347,"kind":12},{"name":"$gap","containerName":"_map","kind":13,"line":348},{"kind":12,"line":348,"name":"end","containerName":"_map"},{"kind":13,"line":348,"containerName":"_map","name":"$self"},{"containerName":"_map","name":"in","kind":12,"line":348},{"containerName":"_map","name":"start","kind":12,"line":348},{"kind":13,"line":349,"containerName":"_map","name":"$gap"},{"line":349,"kind":12,"name":"strand","containerName":"_map"},{"line":349,"kind":13,"containerName":"_map","name":"$value"},{"containerName":"_map","name":"strand","kind":12,"line":349},{"kind":13,"line":350,"name":"$gap","containerName":"_map"},{"name":"seq_id","containerName":"_map","kind":12,"line":350},{"containerName":"_map","name":"$self","kind":13,"line":350},{"name":"in","containerName":"_map","line":350,"kind":12},{"line":350,"kind":12,"containerName":"_map","name":"seq_id"},{"containerName":"_map","name":"$gap","line":352,"kind":13},{"line":353,"kind":13,"containerName":"_map","name":"$result"},{"kind":12,"line":353,"containerName":"_map","name":"add_sub_Location"},{"line":353,"kind":13,"containerName":"_map","name":"$gap"},{"name":"$match","containerName":"_map","kind":13,"line":356},{"name":"seq_id","containerName":"_map","kind":12,"line":356},{"name":"$self","containerName":"_map","line":356,"kind":13},{"name":"out","containerName":"_map","line":356,"kind":12},{"kind":12,"line":356,"name":"seq_id","containerName":"_map"},{"line":358,"kind":13,"containerName":"_map","name":"$self"},{"name":"strand","containerName":"_map","line":358,"kind":12},{"name":"$match","containerName":"_map","line":359,"kind":13},{"kind":12,"line":359,"name":"start","containerName":"_map"},{"line":359,"kind":13,"name":"$self","containerName":"_map"},{"containerName":"_map","name":"out","line":359,"kind":12},{"containerName":"_map","name":"start","line":359,"kind":12},{"kind":13,"line":360,"containerName":"_map","name":"$match"},{"kind":12,"line":360,"containerName":"_map","name":"end"},{"containerName":"_map","name":"$end","line":360,"kind":13},{"name":"$match","containerName":"_map","kind":13,"line":362},{"containerName":"_map","name":"start","kind":12,"line":362},{"kind":13,"line":362,"containerName":"_map","name":"$self"},{"line":362,"kind":12,"containerName":"_map","name":"out"},{"name":"end","containerName":"_map","kind":12,"line":362},{"name":"$end","containerName":"_map","kind":13,"line":362},{"containerName":"_map","name":"$self","line":362,"kind":13},{"containerName":"_map","name":"out","kind":12,"line":362},{"kind":12,"line":362,"name":"start","containerName":"_map"},{"name":"$match","containerName":"_map","kind":13,"line":363},{"line":363,"kind":12,"containerName":"_map","name":"end"},{"name":"$self","containerName":"_map","line":363,"kind":13},{"kind":12,"line":363,"name":"out","containerName":"_map"},{"name":"end","containerName":"_map","kind":12,"line":363},{"containerName":"_map","name":"$match","line":365,"kind":13},{"name":"$result","containerName":"_map","line":366,"kind":13},{"line":366,"kind":12,"name":"add_sub_Location","containerName":"_map"},{"kind":13,"line":366,"name":"$match","containerName":"_map"},{"kind":13,"line":371,"name":"$start","containerName":"_map"},{"line":371,"kind":13,"containerName":"_map","name":"$self"},{"containerName":"_map","name":"out","line":371,"kind":12},{"line":371,"kind":12,"name":"start","containerName":"_map"},{"containerName":"_map","name":"$end","line":371,"kind":13},{"kind":13,"line":371,"containerName":"_map","name":"$self"},{"containerName":"_map","name":"out","line":371,"kind":12},{"containerName":"_map","name":"end","kind":12,"line":371},{"line":373,"kind":13,"containerName":"_map","name":"$match"},{"line":373,"kind":12,"name":"seq_id","containerName":"_map"},{"line":373,"kind":13,"containerName":"_map","name":"$self"},{"name":"out","containerName":"_map","kind":12,"line":373},{"line":373,"kind":12,"containerName":"_map","name":"seq_id"},{"name":"$result","containerName":"_map","kind":13,"line":374},{"containerName":"_map","name":"seq_id","kind":12,"line":374},{"containerName":"_map","name":"$self","kind":13,"line":374},{"line":374,"kind":12,"containerName":"_map","name":"out"},{"name":"seq_id","containerName":"_map","kind":12,"line":374},{"name":"$value","containerName":"_map","kind":13,"line":375},{"containerName":"_map","name":"strand","kind":12,"line":375},{"name":"$match","containerName":"_map","kind":13,"line":376},{"name":"strand","containerName":"_map","line":376,"kind":12},{"containerName":"_map","name":"$match","line":376,"kind":13},{"kind":12,"line":376,"name":"strand","containerName":"_map"},{"containerName":"_map","name":"$value","kind":13,"line":376},{"containerName":"_map","name":"strand","kind":12,"line":376},{"containerName":"_map","name":"$result","kind":13,"line":377},{"containerName":"_map","name":"strand","kind":12,"line":377},{"containerName":"_map","name":"$match","kind":13,"line":377},{"containerName":"_map","name":"strand","line":377,"kind":12},{"line":379,"kind":13,"name":"$self","containerName":"_map"},{"name":"strand","containerName":"_map","kind":12,"line":379},{"containerName":"_map","name":"$match","kind":13,"line":380},{"line":380,"kind":12,"containerName":"_map","name":"start"},{"line":380,"kind":13,"containerName":"_map","name":"$start"},{"kind":13,"line":381,"name":"$match","containerName":"_map"},{"line":381,"kind":12,"name":"end","containerName":"_map"},{"line":381,"kind":13,"containerName":"_map","name":"$self"},{"containerName":"_map","name":"out","line":381,"kind":12},{"line":381,"kind":12,"containerName":"_map","name":"end"},{"containerName":"_map","name":"$match","kind":13,"line":383},{"containerName":"_map","name":"start","kind":12,"line":383},{"containerName":"_map","name":"$self","kind":13,"line":383},{"kind":12,"line":383,"name":"out","containerName":"_map"},{"line":383,"kind":12,"containerName":"_map","name":"start"},{"name":"$match","containerName":"_map","kind":13,"line":384},{"name":"end","containerName":"_map","line":384,"kind":12},{"name":"$self","containerName":"_map","kind":13,"line":384},{"name":"out","containerName":"_map","kind":12,"line":384},{"name":"end","containerName":"_map","line":384,"kind":12},{"kind":13,"line":384,"containerName":"_map","name":"$start"},{"name":"$self","containerName":"_map","line":384,"kind":13},{"containerName":"_map","name":"out","line":384,"kind":12},{"kind":12,"line":384,"containerName":"_map","name":"start"},{"line":386,"kind":13,"containerName":"_map","name":"$match"},{"name":"$result","containerName":"_map","kind":13,"line":387},{"containerName":"_map","name":"add_sub_Location","kind":12,"line":387},{"name":"$match","containerName":"_map","kind":13,"line":387},{"kind":13,"line":389,"containerName":"_map","definition":"my","name":"$gap","localvar":"my"},{"name":"new","containerName":"_map","line":389,"kind":12},{"kind":13,"line":390,"containerName":"_map","name":"$gap"},{"kind":12,"line":390,"containerName":"_map","name":"start"},{"name":"$self","containerName":"_map","line":390,"kind":13},{"kind":12,"line":390,"containerName":"_map","name":"in"},{"name":"end","containerName":"_map","line":390,"kind":12},{"kind":13,"line":391,"name":"$gap","containerName":"_map"},{"kind":12,"line":391,"name":"end","containerName":"_map"},{"line":391,"kind":13,"containerName":"_map","name":"$value"},{"line":391,"kind":12,"containerName":"_map","name":"end"},{"line":392,"kind":13,"containerName":"_map","name":"$gap"},{"line":392,"kind":12,"containerName":"_map","name":"strand"},{"kind":13,"line":392,"name":"$value","containerName":"_map"},{"line":392,"kind":12,"name":"strand","containerName":"_map"},{"containerName":"_map","name":"$gap","line":393,"kind":13},{"line":393,"kind":12,"name":"seq_id","containerName":"_map"},{"name":"$self","containerName":"_map","line":393,"kind":13},{"kind":12,"line":393,"name":"in","containerName":"_map"},{"containerName":"_map","name":"seq_id","kind":12,"line":393},{"containerName":"_map","name":"$gap","line":394,"kind":13},{"name":"$result","containerName":"_map","kind":13,"line":395},{"kind":12,"line":395,"name":"add_sub_Location","containerName":"_map"},{"line":395,"kind":13,"containerName":"_map","name":"$gap"},{"kind":13,"line":401,"name":"$start","containerName":"_map"},{"line":401,"kind":13,"name":"$self","containerName":"_map"},{"line":401,"kind":12,"name":"out","containerName":"_map"},{"containerName":"_map","name":"start","line":401,"kind":12},{"kind":13,"line":401,"name":"$end","containerName":"_map"},{"name":"$self","containerName":"_map","line":401,"kind":13},{"kind":12,"line":401,"name":"out","containerName":"_map"},{"name":"end","containerName":"_map","kind":12,"line":401},{"containerName":"_map","name":"$result","line":403,"kind":13},{"name":"seq_id","containerName":"_map","line":403,"kind":12},{"containerName":"_map","name":"$self","kind":13,"line":403},{"kind":12,"line":403,"name":"out","containerName":"_map"},{"kind":12,"line":403,"name":"seq_id","containerName":"_map"},{"containerName":"_map","name":"$value","line":404,"kind":13},{"name":"strand","containerName":"_map","kind":12,"line":404},{"kind":13,"line":405,"containerName":"_map","name":"$match"},{"name":"strand","containerName":"_map","kind":12,"line":405},{"line":405,"kind":13,"containerName":"_map","name":"$match"},{"kind":12,"line":405,"containerName":"_map","name":"strand"},{"containerName":"_map","name":"$value","kind":13,"line":405},{"line":405,"kind":12,"containerName":"_map","name":"strand"},{"line":406,"kind":13,"containerName":"_map","name":"$result"},{"name":"strand","containerName":"_map","kind":12,"line":406},{"name":"$match","containerName":"_map","line":406,"kind":13},{"kind":12,"line":406,"containerName":"_map","name":"strand"},{"name":"$gap1","definition":"my","containerName":"_map","localvar":"my","kind":13,"line":409},{"name":"new","containerName":"_map","line":409,"kind":12},{"name":"$gap1","containerName":"_map","kind":13,"line":410},{"containerName":"_map","name":"start","line":410,"kind":12},{"line":410,"kind":13,"containerName":"_map","name":"$value"},{"containerName":"_map","name":"start","line":410,"kind":12},{"line":411,"kind":13,"name":"$gap1","containerName":"_map"},{"line":411,"kind":12,"containerName":"_map","name":"end"},{"name":"$self","containerName":"_map","kind":13,"line":411},{"line":411,"kind":12,"name":"in","containerName":"_map"},{"kind":12,"line":411,"containerName":"_map","name":"start"},{"kind":13,"line":412,"name":"$gap1","containerName":"_map"},{"line":412,"kind":12,"containerName":"_map","name":"strand"},{"name":"$value","containerName":"_map","line":412,"kind":13},{"line":412,"kind":12,"containerName":"_map","name":"strand"},{"name":"$gap1","containerName":"_map","kind":13,"line":413},{"name":"seq_id","containerName":"_map","line":413,"kind":12},{"name":"$self","containerName":"_map","line":413,"kind":13},{"kind":12,"line":413,"containerName":"_map","name":"in"},{"line":413,"kind":12,"containerName":"_map","name":"seq_id"},{"name":"$gap1","containerName":"_map","kind":13,"line":414},{"line":415,"kind":13,"containerName":"_map","name":"$result"},{"containerName":"_map","name":"add_sub_Location","kind":12,"line":415},{"containerName":"_map","name":"$gap1","line":415,"kind":13},{"containerName":"_map","name":"$match","kind":13,"line":418},{"containerName":"_map","name":"seq_id","line":418,"kind":12},{"containerName":"_map","name":"$self","kind":13,"line":418},{"name":"out","containerName":"_map","line":418,"kind":12},{"containerName":"_map","name":"seq_id","kind":12,"line":418},{"name":"$match","containerName":"_map","line":420,"kind":13},{"line":420,"kind":12,"name":"start","containerName":"_map"},{"name":"$self","containerName":"_map","kind":13,"line":420},{"line":420,"kind":12,"name":"out","containerName":"_map"},{"line":420,"kind":12,"name":"start","containerName":"_map"},{"line":421,"kind":13,"name":"$match","containerName":"_map"},{"kind":12,"line":421,"containerName":"_map","name":"end"},{"containerName":"_map","name":"$self","kind":13,"line":421},{"name":"out","containerName":"_map","line":421,"kind":12},{"kind":12,"line":421,"name":"end","containerName":"_map"},{"kind":13,"line":422,"containerName":"_map","name":"$match"},{"kind":13,"line":423,"name":"$result","containerName":"_map"},{"containerName":"_map","name":"add_sub_Location","line":423,"kind":12},{"containerName":"_map","name":"$match","line":423,"kind":13},{"line":426,"kind":13,"localvar":"my","containerName":"_map","definition":"my","name":"$gap2"},{"name":"new","containerName":"_map","kind":12,"line":426},{"line":427,"kind":13,"containerName":"_map","name":"$gap2"},{"name":"start","containerName":"_map","kind":12,"line":427},{"line":427,"kind":13,"name":"$self","containerName":"_map"},{"line":427,"kind":12,"name":"in","containerName":"_map"},{"kind":12,"line":427,"name":"end","containerName":"_map"},{"line":428,"kind":13,"name":"$gap2","containerName":"_map"},{"name":"end","containerName":"_map","kind":12,"line":428},{"name":"$value","containerName":"_map","line":428,"kind":13},{"line":428,"kind":12,"containerName":"_map","name":"end"},{"containerName":"_map","name":"$gap2","line":429,"kind":13},{"containerName":"_map","name":"strand","line":429,"kind":12},{"kind":13,"line":429,"name":"$value","containerName":"_map"},{"containerName":"_map","name":"strand","kind":12,"line":429},{"kind":13,"line":430,"name":"$gap2","containerName":"_map"},{"name":"seq_id","containerName":"_map","kind":12,"line":430},{"line":430,"kind":13,"name":"$self","containerName":"_map"},{"kind":12,"line":430,"containerName":"_map","name":"in"},{"kind":12,"line":430,"name":"seq_id","containerName":"_map"},{"containerName":"_map","name":"$gap2","kind":13,"line":431},{"name":"$result","containerName":"_map","kind":13,"line":432},{"name":"add_sub_Location","containerName":"_map","kind":12,"line":432},{"name":"$gap2","containerName":"_map","line":432,"kind":13},{"containerName":"_map","name":"$self","line":435,"kind":13},{"kind":12,"line":435,"name":"throw","containerName":"_map"},{"containerName":"_map","name":"$result","line":437,"kind":13}],"line":284,"kind":12},{"name":"Bio","containerName":"Coordinate::Result","kind":12,"line":287},{"name":"Bio","containerName":"Location::Simple","line":293,"kind":12},{"name":"Bio","containerName":"Location::Simple","line":346,"kind":12},{"containerName":"Location::Simple","name":"Bio","line":389,"kind":12},{"line":409,"kind":12,"name":"Bio","containerName":"Location::Simple"},{"name":"Bio","containerName":"Location::Simple","line":426,"kind":12}],"version":5}