{"version":5,"vars":[{"kind":2,"line":113,"containerName":"","name":"vars"},{"line":117,"kind":2,"containerName":"","name":"base"},{"line":120,"kind":13,"name":"@AA","containerName":null},{"containerName":null,"name":"%STRICTAA","kind":13,"line":121},{"line":121,"kind":13,"containerName":null,"name":"@AA"},{"range":{"start":{"line":139,"character":0},"end":{"character":9999,"line":178}},"name":"new","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Table.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::Table\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::Table - for access to the Codon usage Database\nat http://www.kazusa.or.jp/codon.\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::Table;\n  use Bio::DB::CUTG;\n  use Bio::CodonUsage::IO;\n  use Bio::Tools::SeqStats;\n\n  # Get  a codon usage table from web database\n  my $cdtable = Bio::DB::CUTG->new(-sp => 'Mus musculus',\n                                   -gc => 1);\n\n  # Or from local file\n  my $io      = Bio::CodonUsage::IO->new(-file => \"file\");\n  my $cdtable = $io->next_data();\n\n  # Or create your own from a Bio::PrimarySeq compliant object,\n  # $codonstats is a ref to a hash of codon name /count key-value pairs\n  my $codonstats = Bio::Tools::SeqStats->count_codons($Seq_objct);\n\n  # '-data' must be specified, '-species' and 'genetic_code' are optional\n  my $CUT = Bio::CodonUsage::Table->new(-data    => $codonstats,\n                                        -species => 'Hsapiens_kinase');\n\n  print \"leu frequency is \", $cdtable->aa_frequency('LEU'), \"\\n\";\n  print \"freq of ATG is \", $cdtable->codon_rel_frequency('ttc'), \"\\n\";\n  print \"abs freq of ATG is \", $cdtable->codon_abs_frequency('ATG'), \"\\n\";\n  print \"number of ATG codons is \", $cdtable->codon_count('ATG'), \"\\n\";\n  print \"GC content at position 1 is \", $cdtable->get_coding_gc('1'), \"\\n\";\n  print \"total CDSs for Mus musculus  is \", $cdtable->cds_count(), \"\\n\";\n\n=head1 DESCRIPTION\n\n\nThis class provides methods for accessing codon usage table data.\n\nAll of the methods at present are simple look-ups of the table or are\nderived from simple calculations from the table. Future methods could\ninclude measuring the codon usage of a sequence , for example, or\nprovide methods for examining codon usage in alignments.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::IO>,\nL<Bio::DB::CUTG>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::CodonUsage::Table;\nuse strict;\nuse vars qw(%STRICTAA @AA);\nuse Bio::SeqUtils;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n @AA = qw(A C D E F G H I K L M N P Q R S T V W Y *);\n map {$STRICTAA{$_} = undef} @AA;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $cut = Bio::CodonUsage::Table->new(-data => $cut_hash_ref,\n                                                 -species => 'H.sapiens_kinase'\n                                                 -genetic_code =>1);\n Returns : a reference to a new  Bio::CodonUsage::Table object\n Args    : none or a reference to a hash of codon counts. This constructor is\n           designed to be compatible with the output of\n           Bio::Tools::SeqUtils::count_codons()\n           Species and genetic code parameters can be entered here or via the \n           species() and genetic_code() methods separately."},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":140},{"line":140,"kind":13,"name":"@args","containerName":"new"},{"name":"$self","definition":"my","containerName":"new","localvar":"my","kind":13,"line":141},{"line":141,"kind":13,"name":"$class","containerName":"new"},{"containerName":"new","name":"@args","line":141,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":142},{"line":143,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":143,"containerName":"new","name":"_rearrange"},{"kind":13,"line":143,"name":"@args","containerName":"new"},{"kind":13,"line":144,"name":"@args","containerName":"new"},{"containerName":"new","definition":"my","name":"$arg","localvar":"my","kind":13,"line":145},{"name":"@args","containerName":"new","kind":13,"line":145},{"containerName":"new","name":"$self","kind":13,"line":146},{"line":146,"kind":12,"name":"throw","containerName":"new"},{"kind":13,"line":146,"containerName":"new","name":"$arg"},{"name":"$arg","containerName":"new","kind":13,"line":146},{"line":148,"kind":13,"localvar":"my","containerName":"new","name":"$is_codon_hash","definition":"my"},{"localvar":"my","containerName":"new","name":"$is_Aa_hash","definition":"my","line":149,"kind":13},{"containerName":"new","name":"$k","definition":"my","localvar":"my","kind":13,"line":150},{"kind":13,"line":150,"containerName":"new","name":"$arg"},{"kind":13,"line":152,"containerName":"new","name":"$k"},{"kind":13,"line":153,"name":"$STRICTAA","containerName":"new"},{"name":"$k","containerName":"new","kind":13,"line":153},{"line":154,"kind":13,"containerName":"new","name":"$is_Aa_hash"},{"kind":13,"line":156,"name":"$k","containerName":"new"},{"line":157,"kind":13,"name":"$is_codon_hash","containerName":"new"},{"name":"$is_codon_hash","containerName":"new","kind":13,"line":160},{"line":160,"kind":13,"containerName":"new","name":"$is_Aa_hash"},{"line":161,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"throw","line":161,"kind":12},{"kind":13,"line":163,"containerName":"new","name":"$is_Aa_hash"},{"containerName":"new","name":"$self","line":164,"kind":13},{"name":"_init_from_aa","containerName":"new","line":164,"kind":12},{"name":"$arg","containerName":"new","kind":13,"line":164},{"line":166,"kind":13,"name":"$is_codon_hash","containerName":"new"},{"containerName":"new","name":"$self","line":167,"kind":13},{"containerName":"new","name":"_init_from_cod","kind":12,"line":167},{"name":"$arg","containerName":"new","kind":13,"line":167},{"name":"@args","containerName":"new","kind":13,"line":169},{"localvar":"my","definition":"my","name":"$key","containerName":"new","line":170,"kind":13},{"kind":13,"line":170,"containerName":"new","name":"@args"},{"containerName":"new","name":"$key","line":171,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":173},{"containerName":"new","name":"$key","line":173,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":173},{"kind":13,"line":177,"name":"$self","containerName":"new"}],"line":139,"kind":12},{"kind":12,"line":141,"name":"SUPER","containerName":"new"},{"containerName":"main::","definition":"sub","name":"all_aa_frequencies","range":{"end":{"line":199,"character":9999},"start":{"character":0,"line":191}},"kind":12,"line":191,"children":[{"definition":"my","name":"$self","containerName":"all_aa_frequencies","localvar":"my","kind":13,"line":192},{"localvar":"my","containerName":"all_aa_frequencies","name":"%aa_freqs","definition":"my","line":193,"kind":13},{"localvar":"my","definition":"my","name":"$aa","containerName":"all_aa_frequencies","line":194,"kind":13},{"containerName":"all_aa_frequencies","name":"%STRICTAA","line":194,"kind":13},{"localvar":"my","containerName":"all_aa_frequencies","definition":"my","name":"$freq","line":195,"kind":13},{"name":"$self","containerName":"all_aa_frequencies","kind":13,"line":195},{"containerName":"all_aa_frequencies","name":"aa_frequency","kind":12,"line":195},{"containerName":"all_aa_frequencies","name":"$aa","line":195,"kind":13},{"name":"$aa_freqs","containerName":"all_aa_frequencies","kind":13,"line":196},{"name":"$aa","containerName":"all_aa_frequencies","kind":13,"line":196},{"name":"$freq","containerName":"all_aa_frequencies","kind":13,"line":196},{"name":"%aa_freqs","containerName":"all_aa_frequencies","kind":13,"line":198}]},{"children":[{"line":213,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"codon_abs_frequency"},{"kind":13,"line":213,"name":"$a","containerName":"codon_abs_frequency"},{"line":214,"kind":13,"localvar":"my","containerName":"codon_abs_frequency","name":"$cod","definition":"my"},{"kind":13,"line":214,"containerName":"codon_abs_frequency","name":"$a"},{"name":"$self","containerName":"codon_abs_frequency","kind":13,"line":215},{"containerName":"codon_abs_frequency","name":"_check_codon","kind":12,"line":215},{"name":"$cod","containerName":"codon_abs_frequency","line":215,"kind":13},{"localvar":"my","containerName":"codon_abs_frequency","name":"$ctable","definition":"my","line":216,"kind":13},{"kind":12,"line":216,"name":"new","containerName":"codon_abs_frequency"},{"name":"$ctable","containerName":"codon_abs_frequency","kind":13,"line":217},{"kind":12,"line":217,"name":"id","containerName":"codon_abs_frequency"},{"line":217,"kind":13,"containerName":"codon_abs_frequency","name":"$self"},{"containerName":"codon_abs_frequency","name":"genetic_code","line":217,"kind":12},{"definition":"my","name":"$aa","containerName":"codon_abs_frequency","localvar":"my","kind":13,"line":218},{"line":218,"kind":13,"name":"$Bio","containerName":"codon_abs_frequency"},{"containerName":"codon_abs_frequency","name":"$ctable","line":218,"kind":13},{"kind":12,"line":218,"name":"translate","containerName":"codon_abs_frequency"},{"kind":13,"line":218,"name":"$cod","containerName":"codon_abs_frequency"},{"containerName":"codon_abs_frequency","name":"$self","kind":13,"line":220},{"name":"$aa","containerName":"codon_abs_frequency","line":220,"kind":13},{"name":"$cod","containerName":"codon_abs_frequency","kind":13,"line":220}],"line":212,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$a"}],"documentation":"1;\n# $Id: Table.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::Table\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::Table - for access to the Codon usage Database\nat http://www.kazusa.or.jp/codon.\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::Table;\n  use Bio::DB::CUTG;\n  use Bio::CodonUsage::IO;\n  use Bio::Tools::SeqStats;\n\n  # Get  a codon usage table from web database\n  my $cdtable = Bio::DB::CUTG->new(-sp => 'Mus musculus',\n                                   -gc => 1);\n\n  # Or from local file\n  my $io      = Bio::CodonUsage::IO->new(-file => \"file\");\n  my $cdtable = $io->next_data();\n\n  # Or create your own from a Bio::PrimarySeq compliant object,\n  # $codonstats is a ref to a hash of codon name /count key-value pairs\n  my $codonstats = Bio::Tools::SeqStats->count_codons($Seq_objct);\n\n  # '-data' must be specified, '-species' and 'genetic_code' are optional\n  my $CUT = Bio::CodonUsage::Table->new(-data    => $codonstats,\n                                        -species => 'Hsapiens_kinase');\n\n  print \"leu frequency is \", $cdtable->aa_frequency('LEU'), \"\\n\";\n  print \"freq of ATG is \", $cdtable->codon_rel_frequency('ttc'), \"\\n\";\n  print \"abs freq of ATG is \", $cdtable->codon_abs_frequency('ATG'), \"\\n\";\n  print \"number of ATG codons is \", $cdtable->codon_count('ATG'), \"\\n\";\n  print \"GC content at position 1 is \", $cdtable->get_coding_gc('1'), \"\\n\";\n  print \"total CDSs for Mus musculus  is \", $cdtable->cds_count(), \"\\n\";\n\n=head1 DESCRIPTION\n\n\nThis class provides methods for accessing codon usage table data.\n\nAll of the methods at present are simple look-ups of the table or are\nderived from simple calculations from the table. Future methods could\ninclude measuring the codon usage of a sequence , for example, or\nprovide methods for examining codon usage in alignments.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::IO>,\nL<Bio::DB::CUTG>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::CodonUsage::Table;\nuse strict;\nuse vars qw(%STRICTAA @AA);\nuse Bio::SeqUtils;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n @AA = qw(A C D E F G H I K L M N P Q R S T V W Y *);\n map {$STRICTAA{$_} = undef} @AA;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $cut = Bio::CodonUsage::Table->new(-data => $cut_hash_ref,\n                                                 -species => 'H.sapiens_kinase'\n                                                 -genetic_code =>1);\n Returns : a reference to a new  Bio::CodonUsage::Table object\n Args    : none or a reference to a hash of codon counts. This constructor is\n           designed to be compatible with the output of\n           Bio::Tools::SeqUtils::count_codons()\n           Species and genetic code parameters can be entered here or via the \n           species() and genetic_code() methods separately.\n\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self= $class->SUPER::new(@args);\n\tif (@args) {\n\t\t$self->_rearrange([qw(DATA)], @args);\n\t\tshift @args; # get rid of key\n\t\tmy $arg = shift @args;\n\t\t$self->throw(\"need a hash reference, not a [\" . ref($arg). \"] reference\") if ref($arg) ne 'HASH';\n\t\t### flags to detect argument type, can be either to start with  ##\n\t\tmy $is_codon_hash = 1;\n\t\tmy $is_Aa_hash = 1;\n\t\tfor my $k (keys %$arg) {\n\t\t\t## convert to UC\n\t\t\t$k =~ s/(\\w+)/\\U$1/;\n\t\t\tif (!exists($STRICTAA{$k}) ){\n\t\t\t\t$is_Aa_hash = 0;\n\t\t\t\t}\n\t\t\telsif ($k =~ /[^ATCGatcg]/) {\n\t\t\t\t$is_codon_hash = 0;\n\t\t\t\t}\n\t\t}\n\t\tif (!$is_codon_hash && !$is_Aa_hash) {\n\t\t\t$self->throw(\" invalid key values in CUT hash - must be unique aa or nucleotide identifiers\");\n\t\t\t}\n\t\telsif ($is_Aa_hash) {\n\t\t\t$self->_init_from_aa($arg);\n\t\t\t}\n\t\telsif($is_codon_hash) {\n\t\t\t$self->_init_from_cod($arg);\n\t\t\t}\n\t\twhile (@args) {\n\t\t\tmy $key = shift @args;\n\t\t\t$key =~ s/\\-(\\w+)/\\L$1/;\n\t\t\t\n\t\t\t$self->$key(shift @args);\n\t\t\t}\n\t}\n\t\t\n\treturn $self;\n}\n\n=head2 all_aa_frequencies\n\n Title   : all_aa_frequencies\n Usage   : my $freq = $cdtable->all_aa_frequencies();\n Returns : a reference to a hash where each key is an amino acid\n           and each value is its frequency in all proteins in that\n           species.\n Args    : none\n\n\nsub all_aa_frequencies {\n\tmy $self = shift;\n\tmy %aa_freqs =();\n\tfor my $aa (keys %STRICTAA) {\n\t\tmy $freq = $self->aa_frequency($aa);\n\t\t$aa_freqs{$aa} = $freq;\n\t\t}\n\treturn \\%aa_freqs;\n}\n\n=head2 codon_abs_frequency\n\n Title   : codon_abs_frequency\n Usage   : my $freq = $cdtable->codon_abs_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of all codons in the organism. \n Returns : a percentage frequency\n Args    : a non-ambiguous codon string","label":"codon_abs_frequency($self,$a)"},"detail":"($self,$a)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":212},"end":{"character":9999,"line":223}},"name":"codon_abs_frequency"},{"containerName":"Tools::CodonTable","name":"Bio","line":216,"kind":12},{"name":"SeqUtils","containerName":"THREECODE","kind":12,"line":218},{"name":"codon_rel_frequency","range":{"start":{"line":238,"character":0},"end":{"line":250,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$a)","signature":{"parameters":[{"label":"$self"},{"label":"$a"}],"documentation":"1;\n# $Id: Table.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::Table\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::Table - for access to the Codon usage Database\nat http://www.kazusa.or.jp/codon.\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::Table;\n  use Bio::DB::CUTG;\n  use Bio::CodonUsage::IO;\n  use Bio::Tools::SeqStats;\n\n  # Get  a codon usage table from web database\n  my $cdtable = Bio::DB::CUTG->new(-sp => 'Mus musculus',\n                                   -gc => 1);\n\n  # Or from local file\n  my $io      = Bio::CodonUsage::IO->new(-file => \"file\");\n  my $cdtable = $io->next_data();\n\n  # Or create your own from a Bio::PrimarySeq compliant object,\n  # $codonstats is a ref to a hash of codon name /count key-value pairs\n  my $codonstats = Bio::Tools::SeqStats->count_codons($Seq_objct);\n\n  # '-data' must be specified, '-species' and 'genetic_code' are optional\n  my $CUT = Bio::CodonUsage::Table->new(-data    => $codonstats,\n                                        -species => 'Hsapiens_kinase');\n\n  print \"leu frequency is \", $cdtable->aa_frequency('LEU'), \"\\n\";\n  print \"freq of ATG is \", $cdtable->codon_rel_frequency('ttc'), \"\\n\";\n  print \"abs freq of ATG is \", $cdtable->codon_abs_frequency('ATG'), \"\\n\";\n  print \"number of ATG codons is \", $cdtable->codon_count('ATG'), \"\\n\";\n  print \"GC content at position 1 is \", $cdtable->get_coding_gc('1'), \"\\n\";\n  print \"total CDSs for Mus musculus  is \", $cdtable->cds_count(), \"\\n\";\n\n=head1 DESCRIPTION\n\n\nThis class provides methods for accessing codon usage table data.\n\nAll of the methods at present are simple look-ups of the table or are\nderived from simple calculations from the table. Future methods could\ninclude measuring the codon usage of a sequence , for example, or\nprovide methods for examining codon usage in alignments.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::IO>,\nL<Bio::DB::CUTG>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::CodonUsage::Table;\nuse strict;\nuse vars qw(%STRICTAA @AA);\nuse Bio::SeqUtils;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n @AA = qw(A C D E F G H I K L M N P Q R S T V W Y *);\n map {$STRICTAA{$_} = undef} @AA;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $cut = Bio::CodonUsage::Table->new(-data => $cut_hash_ref,\n                                                 -species => 'H.sapiens_kinase'\n                                                 -genetic_code =>1);\n Returns : a reference to a new  Bio::CodonUsage::Table object\n Args    : none or a reference to a hash of codon counts. This constructor is\n           designed to be compatible with the output of\n           Bio::Tools::SeqUtils::count_codons()\n           Species and genetic code parameters can be entered here or via the \n           species() and genetic_code() methods separately.\n\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self= $class->SUPER::new(@args);\n\tif (@args) {\n\t\t$self->_rearrange([qw(DATA)], @args);\n\t\tshift @args; # get rid of key\n\t\tmy $arg = shift @args;\n\t\t$self->throw(\"need a hash reference, not a [\" . ref($arg). \"] reference\") if ref($arg) ne 'HASH';\n\t\t### flags to detect argument type, can be either to start with  ##\n\t\tmy $is_codon_hash = 1;\n\t\tmy $is_Aa_hash = 1;\n\t\tfor my $k (keys %$arg) {\n\t\t\t## convert to UC\n\t\t\t$k =~ s/(\\w+)/\\U$1/;\n\t\t\tif (!exists($STRICTAA{$k}) ){\n\t\t\t\t$is_Aa_hash = 0;\n\t\t\t\t}\n\t\t\telsif ($k =~ /[^ATCGatcg]/) {\n\t\t\t\t$is_codon_hash = 0;\n\t\t\t\t}\n\t\t}\n\t\tif (!$is_codon_hash && !$is_Aa_hash) {\n\t\t\t$self->throw(\" invalid key values in CUT hash - must be unique aa or nucleotide identifiers\");\n\t\t\t}\n\t\telsif ($is_Aa_hash) {\n\t\t\t$self->_init_from_aa($arg);\n\t\t\t}\n\t\telsif($is_codon_hash) {\n\t\t\t$self->_init_from_cod($arg);\n\t\t\t}\n\t\twhile (@args) {\n\t\t\tmy $key = shift @args;\n\t\t\t$key =~ s/\\-(\\w+)/\\L$1/;\n\t\t\t\n\t\t\t$self->$key(shift @args);\n\t\t\t}\n\t}\n\t\t\n\treturn $self;\n}\n\n=head2 all_aa_frequencies\n\n Title   : all_aa_frequencies\n Usage   : my $freq = $cdtable->all_aa_frequencies();\n Returns : a reference to a hash where each key is an amino acid\n           and each value is its frequency in all proteins in that\n           species.\n Args    : none\n\n\nsub all_aa_frequencies {\n\tmy $self = shift;\n\tmy %aa_freqs =();\n\tfor my $aa (keys %STRICTAA) {\n\t\tmy $freq = $self->aa_frequency($aa);\n\t\t$aa_freqs{$aa} = $freq;\n\t\t}\n\treturn \\%aa_freqs;\n}\n\n=head2 codon_abs_frequency\n\n Title   : codon_abs_frequency\n Usage   : my $freq = $cdtable->codon_abs_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of all codons in the organism. \n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\nsub codon_abs_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod))  {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code() );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\n\t\treturn $self->{'_table'}{$aa}{$cod}{'per1000'}/10 ;\n\t\t}\n\telse {return 0;}\n}\n\n=head2 codon_rel_frequency\n\n Title   : codon_rel_frequency\n Usage   : my $freq = $cdtable->codon_rel_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of codons coding for the same amino acid. E.g., ATG and TGG\n           would return 100 as those codons are unique.\n Returns : a percentage frequency\n Args    : a non-ambiguous codon string","label":"codon_rel_frequency($self,$a)"},"kind":12,"line":238,"children":[{"containerName":"codon_rel_frequency","definition":"my","name":"$self","localvar":"my","kind":13,"line":239},{"name":"$a","containerName":"codon_rel_frequency","line":239,"kind":13},{"kind":13,"line":240,"name":"$cod","definition":"my","containerName":"codon_rel_frequency","localvar":"my"},{"line":240,"kind":13,"name":"$a","containerName":"codon_rel_frequency"},{"kind":13,"line":241,"containerName":"codon_rel_frequency","name":"$self"},{"kind":12,"line":241,"containerName":"codon_rel_frequency","name":"_check_codon"},{"containerName":"codon_rel_frequency","name":"$cod","kind":13,"line":241},{"definition":"my","name":"$ctable","containerName":"codon_rel_frequency","localvar":"my","kind":13,"line":242},{"line":242,"kind":12,"containerName":"codon_rel_frequency","name":"new"},{"line":243,"kind":13,"name":"$ctable","containerName":"codon_rel_frequency"},{"containerName":"codon_rel_frequency","name":"id","line":243,"kind":12},{"line":243,"kind":13,"containerName":"codon_rel_frequency","name":"$self"},{"line":243,"kind":12,"containerName":"codon_rel_frequency","name":"genetic_code"},{"line":244,"kind":13,"localvar":"my","containerName":"codon_rel_frequency","definition":"my","name":"$aa"},{"containerName":"codon_rel_frequency","name":"$Bio","line":244,"kind":13},{"name":"$ctable","containerName":"codon_rel_frequency","line":244,"kind":13},{"name":"translate","containerName":"codon_rel_frequency","kind":12,"line":244},{"name":"$cod","containerName":"codon_rel_frequency","kind":13,"line":244},{"containerName":"codon_rel_frequency","name":"$self","kind":13,"line":245},{"containerName":"codon_rel_frequency","name":"$aa","line":245,"kind":13},{"kind":13,"line":245,"containerName":"codon_rel_frequency","name":"$cod"}]},{"kind":12,"line":242,"containerName":"Tools::CodonTable","name":"Bio"},{"line":244,"kind":12,"name":"SeqUtils","containerName":"THREECODE"},{"name":"probable_codons","range":{"start":{"line":265,"character":0},"end":{"character":9999,"line":280}},"kind":12,"line":265,"children":[{"kind":13,"line":266,"containerName":"probable_codons","definition":"my","name":"$self","localvar":"my"},{"line":266,"kind":13,"containerName":"probable_codons","name":"$threshold"},{"kind":13,"line":267,"name":"$threshold","containerName":"probable_codons"},{"containerName":"probable_codons","name":"$threshold","kind":13,"line":267},{"containerName":"probable_codons","name":"$threshold","kind":13,"line":267},{"kind":13,"line":268,"containerName":"probable_codons","name":"$self"},{"kind":12,"line":268,"containerName":"probable_codons","name":"throw"},{"definition":"my","name":"%return_hash","containerName":"probable_codons","localvar":"my","kind":13,"line":270},{"kind":13,"line":271,"name":"$a","definition":"my","containerName":"probable_codons","localvar":"my"},{"containerName":"probable_codons","name":"%STRICTAA","kind":13,"line":271},{"name":"@common_codons","definition":"my","containerName":"probable_codons","localvar":"my","kind":13,"line":272},{"localvar":"my","name":"$aa","definition":"my","containerName":"probable_codons","line":273,"kind":13},{"line":273,"kind":13,"containerName":"probable_codons","name":"$Bio"},{"kind":13,"line":273,"name":"$a","containerName":"probable_codons"},{"definition":"my","name":"$codon","containerName":"probable_codons","localvar":"my","kind":13,"line":274},{"containerName":"probable_codons","name":"$self","line":274,"kind":13},{"name":"$aa","containerName":"probable_codons","line":274,"kind":13},{"line":275,"kind":13,"containerName":"probable_codons","name":"$self"},{"name":"$aa","containerName":"probable_codons","kind":13,"line":275},{"line":275,"kind":13,"name":"$codon","containerName":"probable_codons"},{"kind":13,"line":275,"name":"$threshold","containerName":"probable_codons"},{"containerName":"probable_codons","name":"@common_codons","kind":13,"line":276},{"name":"$codon","containerName":"probable_codons","line":276,"kind":13},{"containerName":"probable_codons","name":"$return_hash","kind":13,"line":279},{"line":279,"kind":13,"containerName":"probable_codons","name":"$a"},{"name":"@common_codons","containerName":"probable_codons","kind":13,"line":279}],"containerName":"main::","definition":"sub","detail":"($self,$threshold)","signature":{"documentation":"1;\n# $Id: Table.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::Table\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::Table - for access to the Codon usage Database\nat http://www.kazusa.or.jp/codon.\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::Table;\n  use Bio::DB::CUTG;\n  use Bio::CodonUsage::IO;\n  use Bio::Tools::SeqStats;\n\n  # Get  a codon usage table from web database\n  my $cdtable = Bio::DB::CUTG->new(-sp => 'Mus musculus',\n                                   -gc => 1);\n\n  # Or from local file\n  my $io      = Bio::CodonUsage::IO->new(-file => \"file\");\n  my $cdtable = $io->next_data();\n\n  # Or create your own from a Bio::PrimarySeq compliant object,\n  # $codonstats is a ref to a hash of codon name /count key-value pairs\n  my $codonstats = Bio::Tools::SeqStats->count_codons($Seq_objct);\n\n  # '-data' must be specified, '-species' and 'genetic_code' are optional\n  my $CUT = Bio::CodonUsage::Table->new(-data    => $codonstats,\n                                        -species => 'Hsapiens_kinase');\n\n  print \"leu frequency is \", $cdtable->aa_frequency('LEU'), \"\\n\";\n  print \"freq of ATG is \", $cdtable->codon_rel_frequency('ttc'), \"\\n\";\n  print \"abs freq of ATG is \", $cdtable->codon_abs_frequency('ATG'), \"\\n\";\n  print \"number of ATG codons is \", $cdtable->codon_count('ATG'), \"\\n\";\n  print \"GC content at position 1 is \", $cdtable->get_coding_gc('1'), \"\\n\";\n  print \"total CDSs for Mus musculus  is \", $cdtable->cds_count(), \"\\n\";\n\n=head1 DESCRIPTION\n\n\nThis class provides methods for accessing codon usage table data.\n\nAll of the methods at present are simple look-ups of the table or are\nderived from simple calculations from the table. Future methods could\ninclude measuring the codon usage of a sequence , for example, or\nprovide methods for examining codon usage in alignments.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::IO>,\nL<Bio::DB::CUTG>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::CodonUsage::Table;\nuse strict;\nuse vars qw(%STRICTAA @AA);\nuse Bio::SeqUtils;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n @AA = qw(A C D E F G H I K L M N P Q R S T V W Y *);\n map {$STRICTAA{$_} = undef} @AA;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $cut = Bio::CodonUsage::Table->new(-data => $cut_hash_ref,\n                                                 -species => 'H.sapiens_kinase'\n                                                 -genetic_code =>1);\n Returns : a reference to a new  Bio::CodonUsage::Table object\n Args    : none or a reference to a hash of codon counts. This constructor is\n           designed to be compatible with the output of\n           Bio::Tools::SeqUtils::count_codons()\n           Species and genetic code parameters can be entered here or via the \n           species() and genetic_code() methods separately.\n\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self= $class->SUPER::new(@args);\n\tif (@args) {\n\t\t$self->_rearrange([qw(DATA)], @args);\n\t\tshift @args; # get rid of key\n\t\tmy $arg = shift @args;\n\t\t$self->throw(\"need a hash reference, not a [\" . ref($arg). \"] reference\") if ref($arg) ne 'HASH';\n\t\t### flags to detect argument type, can be either to start with  ##\n\t\tmy $is_codon_hash = 1;\n\t\tmy $is_Aa_hash = 1;\n\t\tfor my $k (keys %$arg) {\n\t\t\t## convert to UC\n\t\t\t$k =~ s/(\\w+)/\\U$1/;\n\t\t\tif (!exists($STRICTAA{$k}) ){\n\t\t\t\t$is_Aa_hash = 0;\n\t\t\t\t}\n\t\t\telsif ($k =~ /[^ATCGatcg]/) {\n\t\t\t\t$is_codon_hash = 0;\n\t\t\t\t}\n\t\t}\n\t\tif (!$is_codon_hash && !$is_Aa_hash) {\n\t\t\t$self->throw(\" invalid key values in CUT hash - must be unique aa or nucleotide identifiers\");\n\t\t\t}\n\t\telsif ($is_Aa_hash) {\n\t\t\t$self->_init_from_aa($arg);\n\t\t\t}\n\t\telsif($is_codon_hash) {\n\t\t\t$self->_init_from_cod($arg);\n\t\t\t}\n\t\twhile (@args) {\n\t\t\tmy $key = shift @args;\n\t\t\t$key =~ s/\\-(\\w+)/\\L$1/;\n\t\t\t\n\t\t\t$self->$key(shift @args);\n\t\t\t}\n\t}\n\t\t\n\treturn $self;\n}\n\n=head2 all_aa_frequencies\n\n Title   : all_aa_frequencies\n Usage   : my $freq = $cdtable->all_aa_frequencies();\n Returns : a reference to a hash where each key is an amino acid\n           and each value is its frequency in all proteins in that\n           species.\n Args    : none\n\n\nsub all_aa_frequencies {\n\tmy $self = shift;\n\tmy %aa_freqs =();\n\tfor my $aa (keys %STRICTAA) {\n\t\tmy $freq = $self->aa_frequency($aa);\n\t\t$aa_freqs{$aa} = $freq;\n\t\t}\n\treturn \\%aa_freqs;\n}\n\n=head2 codon_abs_frequency\n\n Title   : codon_abs_frequency\n Usage   : my $freq = $cdtable->codon_abs_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of all codons in the organism. \n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\nsub codon_abs_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod))  {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code() );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\n\t\treturn $self->{'_table'}{$aa}{$cod}{'per1000'}/10 ;\n\t\t}\n\telse {return 0;}\n}\n\n=head2 codon_rel_frequency\n\n Title   : codon_rel_frequency\n Usage   : my $freq = $cdtable->codon_rel_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of codons coding for the same amino acid. E.g., ATG and TGG\n           would return 100 as those codons are unique.\n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\n\nsub codon_rel_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod)) {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code () );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\treturn $self->{'_table'}{$aa}{$cod}{'rel_freq'};\n\t}\n\telse {\n\t\treturn 0;\n\t\t}\n}\n\n=head2 probable_codons\n\n Title    : probable_codons\n Usage    : my $prob_codons = $cd_table->probable_codons(10);\n Purpose  : to obtain a list of codons for the amino acid above a given\n            threshold % relative frequency\n Returns  : A reference to a hash where keys are 1 letter amino acid  codes\n            and values are references to arrays of codons whose frequency\n            is above the threshold.\n Arguments: a minimum threshold frequency","parameters":[{"label":"$self"},{"label":"$threshold"}],"label":"probable_codons($self,$threshold)"}},{"kind":12,"line":274,"name":"SeqUtils","containerName":"THREECODE"},{"containerName":null,"name":"%return_hash","kind":13,"line":282},{"line":282,"kind":13,"name":"%return_hash","containerName":null},{"containerName":null,"name":"$self","line":283,"kind":13},{"name":"warn","containerName":"main::","kind":12,"line":283},{"kind":13,"line":286,"containerName":null,"name":"%return_hash"},{"kind":12,"children":[{"line":302,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"most_common_codons"},{"containerName":"most_common_codons","definition":"my","name":"%return_hash","localvar":"my","kind":13,"line":304},{"line":306,"kind":13,"localvar":"my","name":"$a","definition":"my","containerName":"most_common_codons"},{"kind":13,"line":306,"containerName":"most_common_codons","name":"%STRICTAA"},{"containerName":"most_common_codons","name":"$common_codon","definition":"my","localvar":"my","kind":13,"line":308},{"kind":13,"line":309,"containerName":"most_common_codons","definition":"my","name":"$rel_freq","localvar":"my"},{"line":310,"kind":13,"localvar":"my","containerName":"most_common_codons","definition":"my","name":"$aa"},{"name":"$Bio","containerName":"most_common_codons","line":310,"kind":13},{"name":"$a","containerName":"most_common_codons","kind":13,"line":310},{"name":"$self","containerName":"most_common_codons","kind":13,"line":312},{"containerName":"most_common_codons","name":"$aa","line":312,"kind":13},{"line":313,"kind":13,"containerName":"most_common_codons","name":"$self"},{"name":"warn","containerName":"most_common_codons","line":313,"kind":12},{"line":317,"kind":13,"localvar":"my","definition":"my","name":"$codon","containerName":"most_common_codons"},{"name":"$self","containerName":"most_common_codons","line":317,"kind":13},{"name":"$aa","containerName":"most_common_codons","line":317,"kind":13},{"line":318,"kind":13,"name":"$self","containerName":"most_common_codons"},{"kind":13,"line":318,"containerName":"most_common_codons","name":"$aa"},{"containerName":"most_common_codons","name":"$codon","kind":13,"line":318},{"line":318,"kind":13,"containerName":"most_common_codons","name":"$rel_freq"},{"name":"$common_codon","containerName":"most_common_codons","kind":13,"line":319},{"name":"$codon","containerName":"most_common_codons","kind":13,"line":319},{"name":"$rel_freq","containerName":"most_common_codons","line":320,"kind":13},{"line":320,"kind":13,"name":"$self","containerName":"most_common_codons"},{"line":320,"kind":13,"name":"$aa","containerName":"most_common_codons"},{"name":"$codon","containerName":"most_common_codons","kind":13,"line":320},{"name":"$return_hash","containerName":"most_common_codons","line":323,"kind":13},{"name":"$a","containerName":"most_common_codons","line":323,"kind":13},{"containerName":"most_common_codons","name":"$common_codon","kind":13,"line":323}],"line":301,"name":"most_common_codons","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":301},"end":{"character":9999,"line":324}}},{"containerName":"THREECODE","name":"SeqUtils","kind":12,"line":312},{"kind":13,"line":326,"containerName":null,"name":"%return_hash"},{"kind":12,"line":340,"children":[{"localvar":"my","containerName":"codon_count","name":"$self","definition":"my","line":341,"kind":13},{"line":343,"kind":13,"localvar":"my","name":"$a","definition":"my","containerName":"codon_count"},{"kind":13,"line":344,"name":"$cod","definition":"my","containerName":"codon_count","localvar":"my"},{"containerName":"codon_count","name":"$a","kind":13,"line":344},{"containerName":"codon_count","name":"$self","kind":13,"line":345},{"line":345,"kind":12,"containerName":"codon_count","name":"_check_codon"},{"name":"$cod","containerName":"codon_count","kind":13,"line":345},{"localvar":"my","containerName":"codon_count","definition":"my","name":"$ctable","line":346,"kind":13},{"line":346,"kind":12,"name":"new","containerName":"codon_count"},{"line":347,"kind":13,"containerName":"codon_count","name":"$ctable"},{"name":"id","containerName":"codon_count","line":347,"kind":12},{"containerName":"codon_count","name":"$self","kind":13,"line":347},{"line":347,"kind":12,"name":"genetic_code","containerName":"codon_count"},{"line":348,"kind":13,"localvar":"my","definition":"my","name":"$aa","containerName":"codon_count"},{"containerName":"codon_count","name":"$Bio","kind":13,"line":348},{"containerName":"codon_count","name":"$ctable","kind":13,"line":348},{"containerName":"codon_count","name":"translate","kind":12,"line":348},{"containerName":"codon_count","name":"$cod","kind":13,"line":348},{"line":349,"kind":13,"name":"$self","containerName":"codon_count"},{"name":"$aa","containerName":"codon_count","line":349,"kind":13},{"name":"$cod","containerName":"codon_count","line":349,"kind":13},{"containerName":"codon_count","name":"$self","line":354,"kind":13},{"containerName":"codon_count","name":"warn","kind":12,"line":354}],"containerName":"main::","name":"codon_count","definition":"sub","range":{"start":{"line":340,"character":0},"end":{"line":358,"character":9999}}},{"kind":12,"line":346,"containerName":"Tools::CodonTable","name":"Bio"},{"containerName":"THREECODE","name":"SeqUtils","line":348,"kind":12},{"line":372,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_coding_gc","line":373,"kind":13},{"containerName":"get_coding_gc","name":"$self","line":375,"kind":13},{"line":375,"kind":12,"name":"warn","containerName":"get_coding_gc"},{"localvar":"my","containerName":"get_coding_gc","definition":"my","name":"$n","line":379,"kind":13},{"name":"$self","containerName":"get_coding_gc","kind":13,"line":381},{"name":"$n","containerName":"get_coding_gc","kind":13,"line":381},{"line":382,"kind":13,"name":"$self","containerName":"get_coding_gc"},{"line":382,"kind":13,"containerName":"get_coding_gc","name":"$n"},{"containerName":"get_coding_gc","name":"$self","line":385,"kind":13},{"line":386,"kind":13,"containerName":"get_coding_gc","name":"$self"},{"containerName":"get_coding_gc","name":"warn","line":386,"kind":12},{"containerName":"get_coding_gc","name":"$self","line":387,"kind":13},{"name":"$self","containerName":"get_coding_gc","kind":13,"line":391},{"line":391,"kind":12,"name":"warn","containerName":"get_coding_gc"}],"kind":12,"range":{"end":{"line":397,"character":9999},"start":{"character":0,"line":372}},"containerName":"main::","definition":"sub","name":"get_coding_gc"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$key"},{"label":"$value"}],"documentation":"1;\n# $Id: Table.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::Table\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::Table - for access to the Codon usage Database\nat http://www.kazusa.or.jp/codon.\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::Table;\n  use Bio::DB::CUTG;\n  use Bio::CodonUsage::IO;\n  use Bio::Tools::SeqStats;\n\n  # Get  a codon usage table from web database\n  my $cdtable = Bio::DB::CUTG->new(-sp => 'Mus musculus',\n                                   -gc => 1);\n\n  # Or from local file\n  my $io      = Bio::CodonUsage::IO->new(-file => \"file\");\n  my $cdtable = $io->next_data();\n\n  # Or create your own from a Bio::PrimarySeq compliant object,\n  # $codonstats is a ref to a hash of codon name /count key-value pairs\n  my $codonstats = Bio::Tools::SeqStats->count_codons($Seq_objct);\n\n  # '-data' must be specified, '-species' and 'genetic_code' are optional\n  my $CUT = Bio::CodonUsage::Table->new(-data    => $codonstats,\n                                        -species => 'Hsapiens_kinase');\n\n  print \"leu frequency is \", $cdtable->aa_frequency('LEU'), \"\\n\";\n  print \"freq of ATG is \", $cdtable->codon_rel_frequency('ttc'), \"\\n\";\n  print \"abs freq of ATG is \", $cdtable->codon_abs_frequency('ATG'), \"\\n\";\n  print \"number of ATG codons is \", $cdtable->codon_count('ATG'), \"\\n\";\n  print \"GC content at position 1 is \", $cdtable->get_coding_gc('1'), \"\\n\";\n  print \"total CDSs for Mus musculus  is \", $cdtable->cds_count(), \"\\n\";\n\n=head1 DESCRIPTION\n\n\nThis class provides methods for accessing codon usage table data.\n\nAll of the methods at present are simple look-ups of the table or are\nderived from simple calculations from the table. Future methods could\ninclude measuring the codon usage of a sequence , for example, or\nprovide methods for examining codon usage in alignments.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::IO>,\nL<Bio::DB::CUTG>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::CodonUsage::Table;\nuse strict;\nuse vars qw(%STRICTAA @AA);\nuse Bio::SeqUtils;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n @AA = qw(A C D E F G H I K L M N P Q R S T V W Y *);\n map {$STRICTAA{$_} = undef} @AA;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $cut = Bio::CodonUsage::Table->new(-data => $cut_hash_ref,\n                                                 -species => 'H.sapiens_kinase'\n                                                 -genetic_code =>1);\n Returns : a reference to a new  Bio::CodonUsage::Table object\n Args    : none or a reference to a hash of codon counts. This constructor is\n           designed to be compatible with the output of\n           Bio::Tools::SeqUtils::count_codons()\n           Species and genetic code parameters can be entered here or via the \n           species() and genetic_code() methods separately.\n\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self= $class->SUPER::new(@args);\n\tif (@args) {\n\t\t$self->_rearrange([qw(DATA)], @args);\n\t\tshift @args; # get rid of key\n\t\tmy $arg = shift @args;\n\t\t$self->throw(\"need a hash reference, not a [\" . ref($arg). \"] reference\") if ref($arg) ne 'HASH';\n\t\t### flags to detect argument type, can be either to start with  ##\n\t\tmy $is_codon_hash = 1;\n\t\tmy $is_Aa_hash = 1;\n\t\tfor my $k (keys %$arg) {\n\t\t\t## convert to UC\n\t\t\t$k =~ s/(\\w+)/\\U$1/;\n\t\t\tif (!exists($STRICTAA{$k}) ){\n\t\t\t\t$is_Aa_hash = 0;\n\t\t\t\t}\n\t\t\telsif ($k =~ /[^ATCGatcg]/) {\n\t\t\t\t$is_codon_hash = 0;\n\t\t\t\t}\n\t\t}\n\t\tif (!$is_codon_hash && !$is_Aa_hash) {\n\t\t\t$self->throw(\" invalid key values in CUT hash - must be unique aa or nucleotide identifiers\");\n\t\t\t}\n\t\telsif ($is_Aa_hash) {\n\t\t\t$self->_init_from_aa($arg);\n\t\t\t}\n\t\telsif($is_codon_hash) {\n\t\t\t$self->_init_from_cod($arg);\n\t\t\t}\n\t\twhile (@args) {\n\t\t\tmy $key = shift @args;\n\t\t\t$key =~ s/\\-(\\w+)/\\L$1/;\n\t\t\t\n\t\t\t$self->$key(shift @args);\n\t\t\t}\n\t}\n\t\t\n\treturn $self;\n}\n\n=head2 all_aa_frequencies\n\n Title   : all_aa_frequencies\n Usage   : my $freq = $cdtable->all_aa_frequencies();\n Returns : a reference to a hash where each key is an amino acid\n           and each value is its frequency in all proteins in that\n           species.\n Args    : none\n\n\nsub all_aa_frequencies {\n\tmy $self = shift;\n\tmy %aa_freqs =();\n\tfor my $aa (keys %STRICTAA) {\n\t\tmy $freq = $self->aa_frequency($aa);\n\t\t$aa_freqs{$aa} = $freq;\n\t\t}\n\treturn \\%aa_freqs;\n}\n\n=head2 codon_abs_frequency\n\n Title   : codon_abs_frequency\n Usage   : my $freq = $cdtable->codon_abs_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of all codons in the organism. \n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\nsub codon_abs_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod))  {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code() );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\n\t\treturn $self->{'_table'}{$aa}{$cod}{'per1000'}/10 ;\n\t\t}\n\telse {return 0;}\n}\n\n=head2 codon_rel_frequency\n\n Title   : codon_rel_frequency\n Usage   : my $freq = $cdtable->codon_rel_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of codons coding for the same amino acid. E.g., ATG and TGG\n           would return 100 as those codons are unique.\n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\n\nsub codon_rel_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod)) {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code () );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\treturn $self->{'_table'}{$aa}{$cod}{'rel_freq'};\n\t}\n\telse {\n\t\treturn 0;\n\t\t}\n}\n\n=head2 probable_codons\n\n Title    : probable_codons\n Usage    : my $prob_codons = $cd_table->probable_codons(10);\n Purpose  : to obtain a list of codons for the amino acid above a given\n            threshold % relative frequency\n Returns  : A reference to a hash where keys are 1 letter amino acid  codes\n            and values are references to arrays of codons whose frequency\n            is above the threshold.\n Arguments: a minimum threshold frequency\n\n\nsub probable_codons {\n\tmy ($self, $threshold) = @_;\n\tif (!$threshold || $threshold < 0 || $threshold > 100) {\n\t\t$self->throw(\" I need a threshold percentage \");\n\t\t}\n\tmy %return_hash;\n\tfor my $a(keys %STRICTAA) {\n\t\tmy @common_codons;\n\t\tmy $aa =$Bio::SeqUtils::THREECODE{$a};\n\t\tfor my $codon (keys %{ $self->{'_table'}{$aa}}) {\n\t\t\tif ($self->{'_table'}{$aa}{$codon}{'rel_freq'} > $threshold/100){\n\t\t\t\tpush @common_codons, $codon;\n\t\t\t}\n\t\t}\n\t\t$return_hash{$a} = \\@common_codons;\n\t}\n    ## check to make sure that all codons are populated ##\n\tif (grep{scalar @{$return_hash{$_}} == 0} keys %return_hash) {\n\t\t$self->warn(\"Threshold is too high, some amino acids do not\" .\n\t\t\t\t\t\" have any codon above the threshold!\");\n\t\t}\n    return \\%return_hash;\n}\n\t\t\n\n=head2 most_common_codons\n\n Title    : most_common_codons\n Usage    : my $common_codons = $cd_table->most_common_codons();\n Purpose  : To obtain the most common codon for a given amino acid\n Returns  : A reference to a hash where keys are 1 letter amino acid codes\n            and the values are the single most common codons for those amino acids\n Arguments: None\n\n\nsub most_common_codons {\n\tmy $self = shift;\n\n\tmy %return_hash;\n\n\tfor my $a ( keys %STRICTAA ) {\n\n\t\tmy $common_codon = '';\n\t\tmy $rel_freq = 0;\n\t\tmy $aa = $Bio::SeqUtils::THREECODE{$a};\n\n\t\tif ( ! defined $self->{'_table'}{$aa} ) {\n\t\t\t$self->warn(\"Amino acid $aa ($a) does not have any codons!\");\n\t\t\tnext;\n\t\t}\n\n\t\tfor my $codon ( keys %{ $self->{'_table'}{$aa}} ) {\n\t\t\tif ($self->{'_table'}{$aa}{$codon}{'rel_freq'} > $rel_freq ){\n\t\t\t\t$common_codon = $codon;\n\t\t\t\t$rel_freq = $self->{'_table'}{$aa}{$codon}{'rel_freq'};\n\t\t\t}\n\t\t}\n\t\t$return_hash{$a} = $common_codon;\n\t}\n   \n\treturn \\%return_hash;\n}\n\n=head2 codon_count\n\n Title   : codon_count\n Usage   : my $count = $cdtable->codon_count('CTG');\n Purpose : To obtain the absolute number of the codons in the\n           organism. \n Returns : an integer\n Args    : a non-ambiguous codon string\n\n\nsub codon_count {\n\tmy $self = shift;\n\tif (@_) {\n\t\tmy $a = shift;\n\t\tmy $cod = uc $a;\n\t\tif ($self->_check_codon($cod)) {\n\t\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t\t$ctable->id($self->genetic_code());\n\t\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\t\treturn $self->{'_table'}{$aa}{$cod}{'abs_count'};\n\t\t\t}\n\t\telse {return 0;}\n\t}\n\telse {\n\t\t$self->warn(\" need to give a codon sequence as a parameter \");\n\t\treturn 0;\n\t\t}\n\t\n}\n\n=head2 get_coding_gc\n\n Title   : get_coding_gc\n Usage   : my $count = $cdtable->get_coding_gc(1);\n Purpose : To return the percentage GC composition for the organism at\n           codon positions 1,2 or 3, or an average for all coding sequence\n          ('all').\n Returns : a number (%-age GC content) or 0 if these fields are undefined\n Args    : 1,2,3 or 'all'.\n\n\nsub get_coding_gc {\n\tmy $self  = shift;\n\tif (! @_) {\n\t\t$self->warn(\" no parameters supplied must be  a codon position (1,2,3) or 'all'\");\n\t\treturn 0;\n\t\t\t}\n\telse{\n\t\tmy $n = shift;\n\t\t##return request if valid ##\n\t\tif ( exists($self->{'_coding_gc'}{$n} ) ) {\n\t\t\treturn sprintf(\"%.2f\", $self->{'_coding_gc'}{$n});\n\t\t\t}\n\t\t##else return 'all' value if exists\n\t\telsif (exists($self->{'_coding_gc'}{'all'} )) {\n\t\t\t$self->warn(\"coding gc doesn't have value for [$n], returning gc content for all CDSs\");\n\t\t\treturn sprintf(\"%.2f\", $self->{'_coding_gc'}{'all'});\n\t\t\t}\n\t\t### else return 0, \n\t\telse {\n\t\t\t$self->warn(\"coding gc values aren't defined, returning 0\");\n\t\t\treturn 0;\n\t\t}\n\n\t}#end of outer else\n\t\t\n}\n\n=head2 set_coding_gc\n\n Title   : set_coding_gc\n Usage   : my $count = $cdtable->set_coding_gc(-1=>55.78);\n Purpose : To set the percentage GC composition for the organism at\n           codon positions 1,2 or 3, or an average for all coding sequence\n           ('all').  \n Returns : void\n Args    : a hash where the key must be 1,2,3 or 'all' and the value the %age GC\n           at that codon position..","label":"set_coding_gc($self,$key,$value)"},"detail":"($self,$key,$value)","kind":12,"children":[{"definition":"my","name":"$self","containerName":"set_coding_gc","localvar":"my","kind":13,"line":413},{"kind":13,"line":413,"name":"$key","containerName":"set_coding_gc"},{"line":413,"kind":13,"containerName":"set_coding_gc","name":"$value"},{"definition":"my","name":"@allowed","containerName":"set_coding_gc","localvar":"my","kind":13,"line":414},{"containerName":"set_coding_gc","name":"$key","kind":13,"line":415},{"containerName":"set_coding_gc","name":"$key","kind":13,"line":416},{"line":416,"kind":13,"name":"@allowed","containerName":"set_coding_gc"},{"line":417,"kind":13,"containerName":"set_coding_gc","name":"$self"},{"name":"warn","containerName":"set_coding_gc","kind":12,"line":417},{"name":"@allowed","containerName":"set_coding_gc","kind":13,"line":417},{"kind":13,"line":420,"containerName":"set_coding_gc","name":"$self"},{"line":420,"kind":13,"containerName":"set_coding_gc","name":"$key"},{"kind":13,"line":420,"containerName":"set_coding_gc","name":"$value"}],"line":412,"name":"set_coding_gc","range":{"start":{"line":412,"character":0},"end":{"character":9999,"line":423}}},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"species","line":436,"kind":13},{"containerName":"species","name":"$self","kind":13,"line":438},{"kind":13,"line":440,"name":"$self","containerName":"species"}],"line":435,"definition":"sub","name":"species","containerName":"main::","range":{"start":{"line":435,"character":0},"end":{"character":9999,"line":441}}},{"line":453,"children":[{"containerName":"genetic_code","name":"$self","definition":"my","localvar":"my","kind":13,"line":454},{"line":456,"kind":13,"localvar":"my","containerName":"genetic_code","definition":"my","name":"$val"},{"containerName":"genetic_code","name":"$val","kind":13,"line":457},{"kind":13,"line":457,"name":"$val","containerName":"genetic_code"},{"containerName":"genetic_code","name":"$val","line":457,"kind":13},{"containerName":"genetic_code","name":"$val","line":458,"kind":13},{"kind":13,"line":458,"name":"$val","containerName":"genetic_code"},{"name":"$self","containerName":"genetic_code","line":459,"kind":13},{"kind":12,"line":459,"name":"warn","containerName":"genetic_code"},{"kind":13,"line":460,"name":"$self","containerName":"genetic_code"},{"containerName":"genetic_code","name":"$self","kind":13,"line":463},{"line":466,"kind":13,"containerName":"genetic_code","name":"$self"}],"kind":12,"range":{"start":{"line":453,"character":0},"end":{"character":9999,"line":467}},"containerName":"main::","name":"genetic_code","definition":"sub"},{"kind":12,"line":480,"children":[{"kind":13,"line":481,"containerName":"cds_count","definition":"my","name":"$self","localvar":"my"},{"line":483,"kind":13,"localvar":"my","containerName":"cds_count","name":"$val","definition":"my"},{"line":484,"kind":13,"containerName":"cds_count","name":"$val"},{"containerName":"cds_count","name":"$self","line":485,"kind":13},{"containerName":"cds_count","name":"warn","kind":12,"line":485},{"containerName":"cds_count","name":"$self","kind":13,"line":486},{"containerName":"cds_count","name":"$self","line":489,"kind":13},{"name":"$val","containerName":"cds_count","kind":13,"line":489},{"name":"$self","containerName":"cds_count","kind":13,"line":492},{"name":"warn","containerName":"cds_count","line":492,"kind":12},{"kind":13,"line":493,"containerName":"cds_count","name":"$self"},{"name":"$self","containerName":"cds_count","kind":13,"line":495}],"containerName":"main::","definition":"sub","name":"cds_count","range":{"end":{"line":496,"character":9999},"start":{"character":0,"line":480}}},{"range":{"end":{"line":526,"character":9999},"start":{"character":0,"line":510}},"name":"aa_frequency","signature":{"documentation":"1;\n# $Id: Table.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::Table\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::Table - for access to the Codon usage Database\nat http://www.kazusa.or.jp/codon.\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::Table;\n  use Bio::DB::CUTG;\n  use Bio::CodonUsage::IO;\n  use Bio::Tools::SeqStats;\n\n  # Get  a codon usage table from web database\n  my $cdtable = Bio::DB::CUTG->new(-sp => 'Mus musculus',\n                                   -gc => 1);\n\n  # Or from local file\n  my $io      = Bio::CodonUsage::IO->new(-file => \"file\");\n  my $cdtable = $io->next_data();\n\n  # Or create your own from a Bio::PrimarySeq compliant object,\n  # $codonstats is a ref to a hash of codon name /count key-value pairs\n  my $codonstats = Bio::Tools::SeqStats->count_codons($Seq_objct);\n\n  # '-data' must be specified, '-species' and 'genetic_code' are optional\n  my $CUT = Bio::CodonUsage::Table->new(-data    => $codonstats,\n                                        -species => 'Hsapiens_kinase');\n\n  print \"leu frequency is \", $cdtable->aa_frequency('LEU'), \"\\n\";\n  print \"freq of ATG is \", $cdtable->codon_rel_frequency('ttc'), \"\\n\";\n  print \"abs freq of ATG is \", $cdtable->codon_abs_frequency('ATG'), \"\\n\";\n  print \"number of ATG codons is \", $cdtable->codon_count('ATG'), \"\\n\";\n  print \"GC content at position 1 is \", $cdtable->get_coding_gc('1'), \"\\n\";\n  print \"total CDSs for Mus musculus  is \", $cdtable->cds_count(), \"\\n\";\n\n=head1 DESCRIPTION\n\n\nThis class provides methods for accessing codon usage table data.\n\nAll of the methods at present are simple look-ups of the table or are\nderived from simple calculations from the table. Future methods could\ninclude measuring the codon usage of a sequence , for example, or\nprovide methods for examining codon usage in alignments.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::IO>,\nL<Bio::DB::CUTG>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::CodonUsage::Table;\nuse strict;\nuse vars qw(%STRICTAA @AA);\nuse Bio::SeqUtils;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n @AA = qw(A C D E F G H I K L M N P Q R S T V W Y *);\n map {$STRICTAA{$_} = undef} @AA;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $cut = Bio::CodonUsage::Table->new(-data => $cut_hash_ref,\n                                                 -species => 'H.sapiens_kinase'\n                                                 -genetic_code =>1);\n Returns : a reference to a new  Bio::CodonUsage::Table object\n Args    : none or a reference to a hash of codon counts. This constructor is\n           designed to be compatible with the output of\n           Bio::Tools::SeqUtils::count_codons()\n           Species and genetic code parameters can be entered here or via the \n           species() and genetic_code() methods separately.\n\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self= $class->SUPER::new(@args);\n\tif (@args) {\n\t\t$self->_rearrange([qw(DATA)], @args);\n\t\tshift @args; # get rid of key\n\t\tmy $arg = shift @args;\n\t\t$self->throw(\"need a hash reference, not a [\" . ref($arg). \"] reference\") if ref($arg) ne 'HASH';\n\t\t### flags to detect argument type, can be either to start with  ##\n\t\tmy $is_codon_hash = 1;\n\t\tmy $is_Aa_hash = 1;\n\t\tfor my $k (keys %$arg) {\n\t\t\t## convert to UC\n\t\t\t$k =~ s/(\\w+)/\\U$1/;\n\t\t\tif (!exists($STRICTAA{$k}) ){\n\t\t\t\t$is_Aa_hash = 0;\n\t\t\t\t}\n\t\t\telsif ($k =~ /[^ATCGatcg]/) {\n\t\t\t\t$is_codon_hash = 0;\n\t\t\t\t}\n\t\t}\n\t\tif (!$is_codon_hash && !$is_Aa_hash) {\n\t\t\t$self->throw(\" invalid key values in CUT hash - must be unique aa or nucleotide identifiers\");\n\t\t\t}\n\t\telsif ($is_Aa_hash) {\n\t\t\t$self->_init_from_aa($arg);\n\t\t\t}\n\t\telsif($is_codon_hash) {\n\t\t\t$self->_init_from_cod($arg);\n\t\t\t}\n\t\twhile (@args) {\n\t\t\tmy $key = shift @args;\n\t\t\t$key =~ s/\\-(\\w+)/\\L$1/;\n\t\t\t\n\t\t\t$self->$key(shift @args);\n\t\t\t}\n\t}\n\t\t\n\treturn $self;\n}\n\n=head2 all_aa_frequencies\n\n Title   : all_aa_frequencies\n Usage   : my $freq = $cdtable->all_aa_frequencies();\n Returns : a reference to a hash where each key is an amino acid\n           and each value is its frequency in all proteins in that\n           species.\n Args    : none\n\n\nsub all_aa_frequencies {\n\tmy $self = shift;\n\tmy %aa_freqs =();\n\tfor my $aa (keys %STRICTAA) {\n\t\tmy $freq = $self->aa_frequency($aa);\n\t\t$aa_freqs{$aa} = $freq;\n\t\t}\n\treturn \\%aa_freqs;\n}\n\n=head2 codon_abs_frequency\n\n Title   : codon_abs_frequency\n Usage   : my $freq = $cdtable->codon_abs_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of all codons in the organism. \n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\nsub codon_abs_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod))  {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code() );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\n\t\treturn $self->{'_table'}{$aa}{$cod}{'per1000'}/10 ;\n\t\t}\n\telse {return 0;}\n}\n\n=head2 codon_rel_frequency\n\n Title   : codon_rel_frequency\n Usage   : my $freq = $cdtable->codon_rel_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of codons coding for the same amino acid. E.g., ATG and TGG\n           would return 100 as those codons are unique.\n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\n\nsub codon_rel_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod)) {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code () );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\treturn $self->{'_table'}{$aa}{$cod}{'rel_freq'};\n\t}\n\telse {\n\t\treturn 0;\n\t\t}\n}\n\n=head2 probable_codons\n\n Title    : probable_codons\n Usage    : my $prob_codons = $cd_table->probable_codons(10);\n Purpose  : to obtain a list of codons for the amino acid above a given\n            threshold % relative frequency\n Returns  : A reference to a hash where keys are 1 letter amino acid  codes\n            and values are references to arrays of codons whose frequency\n            is above the threshold.\n Arguments: a minimum threshold frequency\n\n\nsub probable_codons {\n\tmy ($self, $threshold) = @_;\n\tif (!$threshold || $threshold < 0 || $threshold > 100) {\n\t\t$self->throw(\" I need a threshold percentage \");\n\t\t}\n\tmy %return_hash;\n\tfor my $a(keys %STRICTAA) {\n\t\tmy @common_codons;\n\t\tmy $aa =$Bio::SeqUtils::THREECODE{$a};\n\t\tfor my $codon (keys %{ $self->{'_table'}{$aa}}) {\n\t\t\tif ($self->{'_table'}{$aa}{$codon}{'rel_freq'} > $threshold/100){\n\t\t\t\tpush @common_codons, $codon;\n\t\t\t}\n\t\t}\n\t\t$return_hash{$a} = \\@common_codons;\n\t}\n    ## check to make sure that all codons are populated ##\n\tif (grep{scalar @{$return_hash{$_}} == 0} keys %return_hash) {\n\t\t$self->warn(\"Threshold is too high, some amino acids do not\" .\n\t\t\t\t\t\" have any codon above the threshold!\");\n\t\t}\n    return \\%return_hash;\n}\n\t\t\n\n=head2 most_common_codons\n\n Title    : most_common_codons\n Usage    : my $common_codons = $cd_table->most_common_codons();\n Purpose  : To obtain the most common codon for a given amino acid\n Returns  : A reference to a hash where keys are 1 letter amino acid codes\n            and the values are the single most common codons for those amino acids\n Arguments: None\n\n\nsub most_common_codons {\n\tmy $self = shift;\n\n\tmy %return_hash;\n\n\tfor my $a ( keys %STRICTAA ) {\n\n\t\tmy $common_codon = '';\n\t\tmy $rel_freq = 0;\n\t\tmy $aa = $Bio::SeqUtils::THREECODE{$a};\n\n\t\tif ( ! defined $self->{'_table'}{$aa} ) {\n\t\t\t$self->warn(\"Amino acid $aa ($a) does not have any codons!\");\n\t\t\tnext;\n\t\t}\n\n\t\tfor my $codon ( keys %{ $self->{'_table'}{$aa}} ) {\n\t\t\tif ($self->{'_table'}{$aa}{$codon}{'rel_freq'} > $rel_freq ){\n\t\t\t\t$common_codon = $codon;\n\t\t\t\t$rel_freq = $self->{'_table'}{$aa}{$codon}{'rel_freq'};\n\t\t\t}\n\t\t}\n\t\t$return_hash{$a} = $common_codon;\n\t}\n   \n\treturn \\%return_hash;\n}\n\n=head2 codon_count\n\n Title   : codon_count\n Usage   : my $count = $cdtable->codon_count('CTG');\n Purpose : To obtain the absolute number of the codons in the\n           organism. \n Returns : an integer\n Args    : a non-ambiguous codon string\n\n\nsub codon_count {\n\tmy $self = shift;\n\tif (@_) {\n\t\tmy $a = shift;\n\t\tmy $cod = uc $a;\n\t\tif ($self->_check_codon($cod)) {\n\t\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t\t$ctable->id($self->genetic_code());\n\t\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\t\treturn $self->{'_table'}{$aa}{$cod}{'abs_count'};\n\t\t\t}\n\t\telse {return 0;}\n\t}\n\telse {\n\t\t$self->warn(\" need to give a codon sequence as a parameter \");\n\t\treturn 0;\n\t\t}\n\t\n}\n\n=head2 get_coding_gc\n\n Title   : get_coding_gc\n Usage   : my $count = $cdtable->get_coding_gc(1);\n Purpose : To return the percentage GC composition for the organism at\n           codon positions 1,2 or 3, or an average for all coding sequence\n          ('all').\n Returns : a number (%-age GC content) or 0 if these fields are undefined\n Args    : 1,2,3 or 'all'.\n\n\nsub get_coding_gc {\n\tmy $self  = shift;\n\tif (! @_) {\n\t\t$self->warn(\" no parameters supplied must be  a codon position (1,2,3) or 'all'\");\n\t\treturn 0;\n\t\t\t}\n\telse{\n\t\tmy $n = shift;\n\t\t##return request if valid ##\n\t\tif ( exists($self->{'_coding_gc'}{$n} ) ) {\n\t\t\treturn sprintf(\"%.2f\", $self->{'_coding_gc'}{$n});\n\t\t\t}\n\t\t##else return 'all' value if exists\n\t\telsif (exists($self->{'_coding_gc'}{'all'} )) {\n\t\t\t$self->warn(\"coding gc doesn't have value for [$n], returning gc content for all CDSs\");\n\t\t\treturn sprintf(\"%.2f\", $self->{'_coding_gc'}{'all'});\n\t\t\t}\n\t\t### else return 0, \n\t\telse {\n\t\t\t$self->warn(\"coding gc values aren't defined, returning 0\");\n\t\t\treturn 0;\n\t\t}\n\n\t}#end of outer else\n\t\t\n}\n\n=head2 set_coding_gc\n\n Title   : set_coding_gc\n Usage   : my $count = $cdtable->set_coding_gc(-1=>55.78);\n Purpose : To set the percentage GC composition for the organism at\n           codon positions 1,2 or 3, or an average for all coding sequence\n           ('all').  \n Returns : void\n Args    : a hash where the key must be 1,2,3 or 'all' and the value the %age GC\n           at that codon position..\n\n\nsub set_coding_gc {\n\tmy ($self, $key, $value) = @_;\n\tmy @allowed = qw(1 2 3 all);\n\t$key =~ s/\\-//;\n\tif (!grep {$key eq $_} @allowed ) {\n\t\t$self->warn (\"invalid key! - must be one of [ \". (join \" \", @allowed) . \"]\");\n\t\treturn;\n\t\t}\n\t$self->{'_coding_gc'}{$key} = $value;\n\t\n\n}\n\n=head2 species\n\n Title     : species\n Usage     : my $sp = $cut->species();\n Purpose   : Get/setter for species name of codon table\n Returns   : Void or species name string\n Args      : None or species name string\n\n\nsub species {\n\tmy $self = shift;\n\tif (@_ ){\n\t\t$self->{'_species'} = shift;\n\t\t}\n\treturn $self->{'_species'} || \"unknown\";\n}\n\n=head2 genetic_code\n\n Title     : genetic_code\n Usage     : my $sp = $cut->genetic_code();\n Purpose   : Get/setter for genetic_code name of codon table\n Returns   : Void or genetic_code id, 1 by default\n Args      : None or genetic_code id, 1 by default if invalid argument.\n\n\nsub genetic_code {\n\tmy $self = shift;\n\tif (@_ ){\n\t\tmy $val = shift;\n\t\tif ($val < 0 || $val >16 || $val =~ /[^\\d]/ \n\t\t\t\t|| $val ==7 || $val ==8) {\n\t\t\t$self->warn (\"invalid genetic code - must be 1-16 but not 7 or 8,setting to default [1]\");\n\t\t\t$self->{'_genetic_code'} = 1;\n\t\t\t}\n\t\telse {\n\t\t\t$self->{'_genetic_code'} = shift;\n\t\t\t}\n\t\t}\n\treturn $self->{'_genetic_code'} || 1;\n}\n\n=head2 cds_count\n\n Title   : cds_count\n Usage   : my $count = $cdtable->cds_count();\n Purpose : To retrieve the total number of CDSs used to generate the Codon Table\n           for that organism. \n Returns : an integer\n Args    : none (if retrieving the value) or an integer( if setting ). \n\n\nsub cds_count {\n\tmy $self= shift;\n\tif (@_) {\n\t\tmy $val = shift;\n\t\tif ($val < 0) {\n\t\t\t$self->warn(\"can't have negative count initializing to 1\");\n\t\t\t$self->{'_cds_count'} = 0.00;\n\t\t\t}\n\t\telse{\n\t\t\t$self->{'_cds_count'} = $val;\n\t\t}\n\t}\n\t$self->warn(\"cds_count value is undefined, returning 0\") \n\t\tif !exists($self->{'_cds_count'});\n\n\treturn $self->{'_cds_count'} || 0.00;\n\t}\n\n=head2 aa_frequency\n\n Title   : aa_frequency\n Usage   : my $freq = $cdtable->aa_frequency('Leu');\n Purpose : To retrieve the frequency of an amino acid in the organism\n Returns : a percentage\n Args    : a 1 letter or 3 letter string representing the amino acid","parameters":[{"label":"$self"},{"label":"$a"}],"label":"aa_frequency($self,$a)"},"detail":"($self,$a)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"aa_frequency","localvar":"my","kind":13,"line":511},{"kind":13,"line":511,"containerName":"aa_frequency","name":"$a"},{"localvar":"my","definition":"my","name":"$aa","containerName":"aa_frequency","line":515,"kind":13},{"kind":13,"line":515,"containerName":"aa_frequency","name":"$a"},{"name":"$aa","containerName":"aa_frequency","line":516,"kind":13},{"containerName":"aa_frequency","name":"$STRICTAA","line":517,"kind":13},{"containerName":"aa_frequency","name":"$aa","kind":13,"line":517},{"line":517,"kind":13,"containerName":"aa_frequency","name":"$Bio"},{"kind":13,"line":517,"name":"$aa","containerName":"aa_frequency"},{"containerName":"aa_frequency","name":"$self","kind":13,"line":518},{"kind":12,"line":518,"name":"warn","containerName":"aa_frequency"},{"kind":13,"line":522,"definition":"my","name":"$aa3","containerName":"aa_frequency","localvar":"my"},{"kind":13,"line":522,"name":"$Bio","containerName":"aa_frequency"},{"kind":13,"line":522,"containerName":"aa_frequency","name":"$aa"},{"containerName":"aa_frequency","name":"$aa","kind":13,"line":522},{"line":525,"kind":13,"localvar":"my","definition":"my","name":"$freq","containerName":"aa_frequency"},{"line":526,"kind":13,"name":"$freq","containerName":"aa_frequency"},{"containerName":"aa_frequency","name":"$self","line":526,"kind":13},{"kind":13,"line":526,"containerName":"aa_frequency","name":"$aa3"},{"line":526,"kind":13,"name":"$self","containerName":"aa_frequency"},{"containerName":"aa_frequency","name":"$aa3","line":526,"kind":13}],"line":510,"kind":12},{"containerName":"ONECODE","name":"SeqUtils","line":517,"kind":12},{"name":"SeqUtils","containerName":"THREECODE","line":522,"kind":12},{"kind":13,"line":527,"containerName":null,"name":"$freq"},{"detail":"($self,$a)","signature":{"documentation":"1;\n# $Id: Table.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::Table\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::Table - for access to the Codon usage Database\nat http://www.kazusa.or.jp/codon.\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::Table;\n  use Bio::DB::CUTG;\n  use Bio::CodonUsage::IO;\n  use Bio::Tools::SeqStats;\n\n  # Get  a codon usage table from web database\n  my $cdtable = Bio::DB::CUTG->new(-sp => 'Mus musculus',\n                                   -gc => 1);\n\n  # Or from local file\n  my $io      = Bio::CodonUsage::IO->new(-file => \"file\");\n  my $cdtable = $io->next_data();\n\n  # Or create your own from a Bio::PrimarySeq compliant object,\n  # $codonstats is a ref to a hash of codon name /count key-value pairs\n  my $codonstats = Bio::Tools::SeqStats->count_codons($Seq_objct);\n\n  # '-data' must be specified, '-species' and 'genetic_code' are optional\n  my $CUT = Bio::CodonUsage::Table->new(-data    => $codonstats,\n                                        -species => 'Hsapiens_kinase');\n\n  print \"leu frequency is \", $cdtable->aa_frequency('LEU'), \"\\n\";\n  print \"freq of ATG is \", $cdtable->codon_rel_frequency('ttc'), \"\\n\";\n  print \"abs freq of ATG is \", $cdtable->codon_abs_frequency('ATG'), \"\\n\";\n  print \"number of ATG codons is \", $cdtable->codon_count('ATG'), \"\\n\";\n  print \"GC content at position 1 is \", $cdtable->get_coding_gc('1'), \"\\n\";\n  print \"total CDSs for Mus musculus  is \", $cdtable->cds_count(), \"\\n\";\n\n=head1 DESCRIPTION\n\n\nThis class provides methods for accessing codon usage table data.\n\nAll of the methods at present are simple look-ups of the table or are\nderived from simple calculations from the table. Future methods could\ninclude measuring the codon usage of a sequence , for example, or\nprovide methods for examining codon usage in alignments.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::IO>,\nL<Bio::DB::CUTG>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::CodonUsage::Table;\nuse strict;\nuse vars qw(%STRICTAA @AA);\nuse Bio::SeqUtils;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n @AA = qw(A C D E F G H I K L M N P Q R S T V W Y *);\n map {$STRICTAA{$_} = undef} @AA;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $cut = Bio::CodonUsage::Table->new(-data => $cut_hash_ref,\n                                                 -species => 'H.sapiens_kinase'\n                                                 -genetic_code =>1);\n Returns : a reference to a new  Bio::CodonUsage::Table object\n Args    : none or a reference to a hash of codon counts. This constructor is\n           designed to be compatible with the output of\n           Bio::Tools::SeqUtils::count_codons()\n           Species and genetic code parameters can be entered here or via the \n           species() and genetic_code() methods separately.\n\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self= $class->SUPER::new(@args);\n\tif (@args) {\n\t\t$self->_rearrange([qw(DATA)], @args);\n\t\tshift @args; # get rid of key\n\t\tmy $arg = shift @args;\n\t\t$self->throw(\"need a hash reference, not a [\" . ref($arg). \"] reference\") if ref($arg) ne 'HASH';\n\t\t### flags to detect argument type, can be either to start with  ##\n\t\tmy $is_codon_hash = 1;\n\t\tmy $is_Aa_hash = 1;\n\t\tfor my $k (keys %$arg) {\n\t\t\t## convert to UC\n\t\t\t$k =~ s/(\\w+)/\\U$1/;\n\t\t\tif (!exists($STRICTAA{$k}) ){\n\t\t\t\t$is_Aa_hash = 0;\n\t\t\t\t}\n\t\t\telsif ($k =~ /[^ATCGatcg]/) {\n\t\t\t\t$is_codon_hash = 0;\n\t\t\t\t}\n\t\t}\n\t\tif (!$is_codon_hash && !$is_Aa_hash) {\n\t\t\t$self->throw(\" invalid key values in CUT hash - must be unique aa or nucleotide identifiers\");\n\t\t\t}\n\t\telsif ($is_Aa_hash) {\n\t\t\t$self->_init_from_aa($arg);\n\t\t\t}\n\t\telsif($is_codon_hash) {\n\t\t\t$self->_init_from_cod($arg);\n\t\t\t}\n\t\twhile (@args) {\n\t\t\tmy $key = shift @args;\n\t\t\t$key =~ s/\\-(\\w+)/\\L$1/;\n\t\t\t\n\t\t\t$self->$key(shift @args);\n\t\t\t}\n\t}\n\t\t\n\treturn $self;\n}\n\n=head2 all_aa_frequencies\n\n Title   : all_aa_frequencies\n Usage   : my $freq = $cdtable->all_aa_frequencies();\n Returns : a reference to a hash where each key is an amino acid\n           and each value is its frequency in all proteins in that\n           species.\n Args    : none\n\n\nsub all_aa_frequencies {\n\tmy $self = shift;\n\tmy %aa_freqs =();\n\tfor my $aa (keys %STRICTAA) {\n\t\tmy $freq = $self->aa_frequency($aa);\n\t\t$aa_freqs{$aa} = $freq;\n\t\t}\n\treturn \\%aa_freqs;\n}\n\n=head2 codon_abs_frequency\n\n Title   : codon_abs_frequency\n Usage   : my $freq = $cdtable->codon_abs_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of all codons in the organism. \n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\nsub codon_abs_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod))  {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code() );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\n\t\treturn $self->{'_table'}{$aa}{$cod}{'per1000'}/10 ;\n\t\t}\n\telse {return 0;}\n}\n\n=head2 codon_rel_frequency\n\n Title   : codon_rel_frequency\n Usage   : my $freq = $cdtable->codon_rel_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of codons coding for the same amino acid. E.g., ATG and TGG\n           would return 100 as those codons are unique.\n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\n\nsub codon_rel_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod)) {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code () );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\treturn $self->{'_table'}{$aa}{$cod}{'rel_freq'};\n\t}\n\telse {\n\t\treturn 0;\n\t\t}\n}\n\n=head2 probable_codons\n\n Title    : probable_codons\n Usage    : my $prob_codons = $cd_table->probable_codons(10);\n Purpose  : to obtain a list of codons for the amino acid above a given\n            threshold % relative frequency\n Returns  : A reference to a hash where keys are 1 letter amino acid  codes\n            and values are references to arrays of codons whose frequency\n            is above the threshold.\n Arguments: a minimum threshold frequency\n\n\nsub probable_codons {\n\tmy ($self, $threshold) = @_;\n\tif (!$threshold || $threshold < 0 || $threshold > 100) {\n\t\t$self->throw(\" I need a threshold percentage \");\n\t\t}\n\tmy %return_hash;\n\tfor my $a(keys %STRICTAA) {\n\t\tmy @common_codons;\n\t\tmy $aa =$Bio::SeqUtils::THREECODE{$a};\n\t\tfor my $codon (keys %{ $self->{'_table'}{$aa}}) {\n\t\t\tif ($self->{'_table'}{$aa}{$codon}{'rel_freq'} > $threshold/100){\n\t\t\t\tpush @common_codons, $codon;\n\t\t\t}\n\t\t}\n\t\t$return_hash{$a} = \\@common_codons;\n\t}\n    ## check to make sure that all codons are populated ##\n\tif (grep{scalar @{$return_hash{$_}} == 0} keys %return_hash) {\n\t\t$self->warn(\"Threshold is too high, some amino acids do not\" .\n\t\t\t\t\t\" have any codon above the threshold!\");\n\t\t}\n    return \\%return_hash;\n}\n\t\t\n\n=head2 most_common_codons\n\n Title    : most_common_codons\n Usage    : my $common_codons = $cd_table->most_common_codons();\n Purpose  : To obtain the most common codon for a given amino acid\n Returns  : A reference to a hash where keys are 1 letter amino acid codes\n            and the values are the single most common codons for those amino acids\n Arguments: None\n\n\nsub most_common_codons {\n\tmy $self = shift;\n\n\tmy %return_hash;\n\n\tfor my $a ( keys %STRICTAA ) {\n\n\t\tmy $common_codon = '';\n\t\tmy $rel_freq = 0;\n\t\tmy $aa = $Bio::SeqUtils::THREECODE{$a};\n\n\t\tif ( ! defined $self->{'_table'}{$aa} ) {\n\t\t\t$self->warn(\"Amino acid $aa ($a) does not have any codons!\");\n\t\t\tnext;\n\t\t}\n\n\t\tfor my $codon ( keys %{ $self->{'_table'}{$aa}} ) {\n\t\t\tif ($self->{'_table'}{$aa}{$codon}{'rel_freq'} > $rel_freq ){\n\t\t\t\t$common_codon = $codon;\n\t\t\t\t$rel_freq = $self->{'_table'}{$aa}{$codon}{'rel_freq'};\n\t\t\t}\n\t\t}\n\t\t$return_hash{$a} = $common_codon;\n\t}\n   \n\treturn \\%return_hash;\n}\n\n=head2 codon_count\n\n Title   : codon_count\n Usage   : my $count = $cdtable->codon_count('CTG');\n Purpose : To obtain the absolute number of the codons in the\n           organism. \n Returns : an integer\n Args    : a non-ambiguous codon string\n\n\nsub codon_count {\n\tmy $self = shift;\n\tif (@_) {\n\t\tmy $a = shift;\n\t\tmy $cod = uc $a;\n\t\tif ($self->_check_codon($cod)) {\n\t\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t\t$ctable->id($self->genetic_code());\n\t\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\t\treturn $self->{'_table'}{$aa}{$cod}{'abs_count'};\n\t\t\t}\n\t\telse {return 0;}\n\t}\n\telse {\n\t\t$self->warn(\" need to give a codon sequence as a parameter \");\n\t\treturn 0;\n\t\t}\n\t\n}\n\n=head2 get_coding_gc\n\n Title   : get_coding_gc\n Usage   : my $count = $cdtable->get_coding_gc(1);\n Purpose : To return the percentage GC composition for the organism at\n           codon positions 1,2 or 3, or an average for all coding sequence\n          ('all').\n Returns : a number (%-age GC content) or 0 if these fields are undefined\n Args    : 1,2,3 or 'all'.\n\n\nsub get_coding_gc {\n\tmy $self  = shift;\n\tif (! @_) {\n\t\t$self->warn(\" no parameters supplied must be  a codon position (1,2,3) or 'all'\");\n\t\treturn 0;\n\t\t\t}\n\telse{\n\t\tmy $n = shift;\n\t\t##return request if valid ##\n\t\tif ( exists($self->{'_coding_gc'}{$n} ) ) {\n\t\t\treturn sprintf(\"%.2f\", $self->{'_coding_gc'}{$n});\n\t\t\t}\n\t\t##else return 'all' value if exists\n\t\telsif (exists($self->{'_coding_gc'}{'all'} )) {\n\t\t\t$self->warn(\"coding gc doesn't have value for [$n], returning gc content for all CDSs\");\n\t\t\treturn sprintf(\"%.2f\", $self->{'_coding_gc'}{'all'});\n\t\t\t}\n\t\t### else return 0, \n\t\telse {\n\t\t\t$self->warn(\"coding gc values aren't defined, returning 0\");\n\t\t\treturn 0;\n\t\t}\n\n\t}#end of outer else\n\t\t\n}\n\n=head2 set_coding_gc\n\n Title   : set_coding_gc\n Usage   : my $count = $cdtable->set_coding_gc(-1=>55.78);\n Purpose : To set the percentage GC composition for the organism at\n           codon positions 1,2 or 3, or an average for all coding sequence\n           ('all').  \n Returns : void\n Args    : a hash where the key must be 1,2,3 or 'all' and the value the %age GC\n           at that codon position..\n\n\nsub set_coding_gc {\n\tmy ($self, $key, $value) = @_;\n\tmy @allowed = qw(1 2 3 all);\n\t$key =~ s/\\-//;\n\tif (!grep {$key eq $_} @allowed ) {\n\t\t$self->warn (\"invalid key! - must be one of [ \". (join \" \", @allowed) . \"]\");\n\t\treturn;\n\t\t}\n\t$self->{'_coding_gc'}{$key} = $value;\n\t\n\n}\n\n=head2 species\n\n Title     : species\n Usage     : my $sp = $cut->species();\n Purpose   : Get/setter for species name of codon table\n Returns   : Void or species name string\n Args      : None or species name string\n\n\nsub species {\n\tmy $self = shift;\n\tif (@_ ){\n\t\t$self->{'_species'} = shift;\n\t\t}\n\treturn $self->{'_species'} || \"unknown\";\n}\n\n=head2 genetic_code\n\n Title     : genetic_code\n Usage     : my $sp = $cut->genetic_code();\n Purpose   : Get/setter for genetic_code name of codon table\n Returns   : Void or genetic_code id, 1 by default\n Args      : None or genetic_code id, 1 by default if invalid argument.\n\n\nsub genetic_code {\n\tmy $self = shift;\n\tif (@_ ){\n\t\tmy $val = shift;\n\t\tif ($val < 0 || $val >16 || $val =~ /[^\\d]/ \n\t\t\t\t|| $val ==7 || $val ==8) {\n\t\t\t$self->warn (\"invalid genetic code - must be 1-16 but not 7 or 8,setting to default [1]\");\n\t\t\t$self->{'_genetic_code'} = 1;\n\t\t\t}\n\t\telse {\n\t\t\t$self->{'_genetic_code'} = shift;\n\t\t\t}\n\t\t}\n\treturn $self->{'_genetic_code'} || 1;\n}\n\n=head2 cds_count\n\n Title   : cds_count\n Usage   : my $count = $cdtable->cds_count();\n Purpose : To retrieve the total number of CDSs used to generate the Codon Table\n           for that organism. \n Returns : an integer\n Args    : none (if retrieving the value) or an integer( if setting ). \n\n\nsub cds_count {\n\tmy $self= shift;\n\tif (@_) {\n\t\tmy $val = shift;\n\t\tif ($val < 0) {\n\t\t\t$self->warn(\"can't have negative count initializing to 1\");\n\t\t\t$self->{'_cds_count'} = 0.00;\n\t\t\t}\n\t\telse{\n\t\t\t$self->{'_cds_count'} = $val;\n\t\t}\n\t}\n\t$self->warn(\"cds_count value is undefined, returning 0\") \n\t\tif !exists($self->{'_cds_count'});\n\n\treturn $self->{'_cds_count'} || 0.00;\n\t}\n\n=head2 aa_frequency\n\n Title   : aa_frequency\n Usage   : my $freq = $cdtable->aa_frequency('Leu');\n Purpose : To retrieve the frequency of an amino acid in the organism\n Returns : a percentage\n Args    : a 1 letter or 3 letter string representing the amino acid\n\n\n\t\n\nsub aa_frequency {\n\tmy ($self, $a) = @_;\n\t## process args ##\n\n\t## deal with cases ##\n\tmy $aa = lc $a;\t\n\t$aa =~ s/^(\\w)/\\U$1/;\n\tif (!exists($STRICTAA{$aa}) && !exists($Bio::SeqUtils::ONECODE{$aa}) ) {\n\t\t$self->warn(\"Invalid amino acid! must be a unique 1 letter or 3 letter identifier\");\n\t\treturn;\n\t\t}\n\t#translate to 3 letter code for Ctable #\n\tmy $aa3 = $Bio::SeqUtils::THREECODE{$aa} || $aa;\n\n\t## return % of all amino acids in organism ## \n\tmy $freq = 0;\n\tmap {$freq += $self->{'_table'}{$aa3}{$_}{'per1000'} } keys %{$self->{'_table'}{$aa3}};\n\treturn sprintf(\"%.2f\", $freq/10);\n}\n\n=head2 common_codon\n\n Title   : common_codon\n Usage   : my $freq = $cdtable->common_codon('Leu');\n Purpose : To retrieve the frequency of the most common codon of that aa\n Returns : a percentage\n Args    : a 1 letter or 3 letter string representing the amino acid","parameters":[{"label":"$self"},{"label":"$a"}],"label":"common_codon($self,$a)"},"containerName":"main::","definition":"sub","line":540,"children":[{"containerName":"common_codon","name":"$self","definition":"my","localvar":"my","kind":13,"line":542},{"name":"$a","containerName":"common_codon","kind":13,"line":542},{"kind":13,"line":543,"containerName":"common_codon","name":"$aa","definition":"my","localvar":"my"},{"name":"$a","containerName":"common_codon","line":543,"kind":13},{"containerName":"common_codon","name":"$aa","line":544,"kind":13},{"line":546,"kind":13,"containerName":"common_codon","name":"$self"},{"name":"_check_aa","containerName":"common_codon","line":546,"kind":12},{"line":546,"kind":13,"name":"$aa","containerName":"common_codon"},{"localvar":"my","containerName":"common_codon","name":"$aa3","definition":"my","line":547,"kind":13},{"kind":13,"line":547,"name":"$Bio","containerName":"common_codon"},{"line":547,"kind":13,"name":"$aa","containerName":"common_codon"},{"name":"$aa3","containerName":"common_codon","line":548,"kind":13},{"kind":13,"line":548,"name":"$aa","containerName":"common_codon"},{"containerName":"common_codon","definition":"my","name":"$max","localvar":"my","kind":13,"line":549},{"kind":13,"line":550,"containerName":"common_codon","definition":"my","name":"$cod","localvar":"my"},{"containerName":"common_codon","name":"$self","kind":13,"line":550},{"containerName":"common_codon","name":"$aa3","line":550,"kind":13},{"name":"$max","containerName":"common_codon","line":551,"kind":13},{"kind":13,"line":551,"containerName":"common_codon","name":"$self"},{"name":"$aa3","containerName":"common_codon","line":551,"kind":13},{"line":551,"kind":13,"name":"$cod","containerName":"common_codon"},{"name":"$max","containerName":"common_codon","kind":13,"line":551},{"kind":13,"line":552,"containerName":"common_codon","name":"$self"},{"line":552,"kind":13,"containerName":"common_codon","name":"$aa3"},{"containerName":"common_codon","name":"$cod","line":552,"kind":13},{"name":"$max","containerName":"common_codon","kind":13,"line":552},{"containerName":"common_codon","name":"$max","line":554,"kind":13}],"kind":12,"range":{"start":{"line":540,"character":0},"end":{"line":555,"character":9999}},"name":"common_codon"},{"kind":12,"line":548,"containerName":"THREECODE","name":"SeqUtils"},{"kind":12,"line":568,"children":[{"line":569,"kind":13,"localvar":"my","containerName":"rare_codon","definition":"my","name":"$self"},{"line":569,"kind":13,"name":"$a","containerName":"rare_codon"},{"localvar":"my","definition":"my","name":"$aa","containerName":"rare_codon","line":570,"kind":13},{"containerName":"rare_codon","name":"$a","line":570,"kind":13},{"kind":13,"line":571,"name":"$aa","containerName":"rare_codon"},{"name":"$self","containerName":"rare_codon","line":572,"kind":13},{"containerName":"rare_codon","name":"_check_aa","line":572,"kind":12},{"line":572,"kind":13,"name":"$aa","containerName":"rare_codon"},{"containerName":"rare_codon","definition":"my","name":"$aa3","localvar":"my","kind":13,"line":573},{"containerName":"rare_codon","name":"$Bio","kind":13,"line":573},{"name":"$aa","containerName":"rare_codon","kind":13,"line":573},{"name":"$aa3","containerName":"rare_codon","line":574,"kind":13},{"line":574,"kind":13,"containerName":"rare_codon","name":"$aa"},{"localvar":"my","containerName":"rare_codon","name":"$min","definition":"my","line":575,"kind":13},{"line":576,"kind":13,"localvar":"my","definition":"my","name":"$cod","containerName":"rare_codon"},{"containerName":"rare_codon","name":"$self","line":576,"kind":13},{"name":"$aa3","containerName":"rare_codon","kind":13,"line":576},{"line":577,"kind":13,"containerName":"rare_codon","name":"$min"},{"name":"$self","containerName":"rare_codon","line":577,"kind":13},{"containerName":"rare_codon","name":"$aa3","kind":13,"line":577},{"containerName":"rare_codon","name":"$cod","line":577,"kind":13},{"name":"$min","containerName":"rare_codon","kind":13,"line":577},{"line":578,"kind":13,"name":"$self","containerName":"rare_codon"},{"containerName":"rare_codon","name":"$aa3","line":578,"kind":13},{"kind":13,"line":578,"containerName":"rare_codon","name":"$cod"},{"containerName":"rare_codon","name":"$min","line":578,"kind":13},{"kind":13,"line":580,"containerName":"rare_codon","name":"$min"}],"containerName":"main::","definition":"sub","detail":"($self,$a)","signature":{"documentation":"1;\n# $Id: Table.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::Table\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::Table - for access to the Codon usage Database\nat http://www.kazusa.or.jp/codon.\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::Table;\n  use Bio::DB::CUTG;\n  use Bio::CodonUsage::IO;\n  use Bio::Tools::SeqStats;\n\n  # Get  a codon usage table from web database\n  my $cdtable = Bio::DB::CUTG->new(-sp => 'Mus musculus',\n                                   -gc => 1);\n\n  # Or from local file\n  my $io      = Bio::CodonUsage::IO->new(-file => \"file\");\n  my $cdtable = $io->next_data();\n\n  # Or create your own from a Bio::PrimarySeq compliant object,\n  # $codonstats is a ref to a hash of codon name /count key-value pairs\n  my $codonstats = Bio::Tools::SeqStats->count_codons($Seq_objct);\n\n  # '-data' must be specified, '-species' and 'genetic_code' are optional\n  my $CUT = Bio::CodonUsage::Table->new(-data    => $codonstats,\n                                        -species => 'Hsapiens_kinase');\n\n  print \"leu frequency is \", $cdtable->aa_frequency('LEU'), \"\\n\";\n  print \"freq of ATG is \", $cdtable->codon_rel_frequency('ttc'), \"\\n\";\n  print \"abs freq of ATG is \", $cdtable->codon_abs_frequency('ATG'), \"\\n\";\n  print \"number of ATG codons is \", $cdtable->codon_count('ATG'), \"\\n\";\n  print \"GC content at position 1 is \", $cdtable->get_coding_gc('1'), \"\\n\";\n  print \"total CDSs for Mus musculus  is \", $cdtable->cds_count(), \"\\n\";\n\n=head1 DESCRIPTION\n\n\nThis class provides methods for accessing codon usage table data.\n\nAll of the methods at present are simple look-ups of the table or are\nderived from simple calculations from the table. Future methods could\ninclude measuring the codon usage of a sequence , for example, or\nprovide methods for examining codon usage in alignments.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::IO>,\nL<Bio::DB::CUTG>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::CodonUsage::Table;\nuse strict;\nuse vars qw(%STRICTAA @AA);\nuse Bio::SeqUtils;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n @AA = qw(A C D E F G H I K L M N P Q R S T V W Y *);\n map {$STRICTAA{$_} = undef} @AA;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $cut = Bio::CodonUsage::Table->new(-data => $cut_hash_ref,\n                                                 -species => 'H.sapiens_kinase'\n                                                 -genetic_code =>1);\n Returns : a reference to a new  Bio::CodonUsage::Table object\n Args    : none or a reference to a hash of codon counts. This constructor is\n           designed to be compatible with the output of\n           Bio::Tools::SeqUtils::count_codons()\n           Species and genetic code parameters can be entered here or via the \n           species() and genetic_code() methods separately.\n\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self= $class->SUPER::new(@args);\n\tif (@args) {\n\t\t$self->_rearrange([qw(DATA)], @args);\n\t\tshift @args; # get rid of key\n\t\tmy $arg = shift @args;\n\t\t$self->throw(\"need a hash reference, not a [\" . ref($arg). \"] reference\") if ref($arg) ne 'HASH';\n\t\t### flags to detect argument type, can be either to start with  ##\n\t\tmy $is_codon_hash = 1;\n\t\tmy $is_Aa_hash = 1;\n\t\tfor my $k (keys %$arg) {\n\t\t\t## convert to UC\n\t\t\t$k =~ s/(\\w+)/\\U$1/;\n\t\t\tif (!exists($STRICTAA{$k}) ){\n\t\t\t\t$is_Aa_hash = 0;\n\t\t\t\t}\n\t\t\telsif ($k =~ /[^ATCGatcg]/) {\n\t\t\t\t$is_codon_hash = 0;\n\t\t\t\t}\n\t\t}\n\t\tif (!$is_codon_hash && !$is_Aa_hash) {\n\t\t\t$self->throw(\" invalid key values in CUT hash - must be unique aa or nucleotide identifiers\");\n\t\t\t}\n\t\telsif ($is_Aa_hash) {\n\t\t\t$self->_init_from_aa($arg);\n\t\t\t}\n\t\telsif($is_codon_hash) {\n\t\t\t$self->_init_from_cod($arg);\n\t\t\t}\n\t\twhile (@args) {\n\t\t\tmy $key = shift @args;\n\t\t\t$key =~ s/\\-(\\w+)/\\L$1/;\n\t\t\t\n\t\t\t$self->$key(shift @args);\n\t\t\t}\n\t}\n\t\t\n\treturn $self;\n}\n\n=head2 all_aa_frequencies\n\n Title   : all_aa_frequencies\n Usage   : my $freq = $cdtable->all_aa_frequencies();\n Returns : a reference to a hash where each key is an amino acid\n           and each value is its frequency in all proteins in that\n           species.\n Args    : none\n\n\nsub all_aa_frequencies {\n\tmy $self = shift;\n\tmy %aa_freqs =();\n\tfor my $aa (keys %STRICTAA) {\n\t\tmy $freq = $self->aa_frequency($aa);\n\t\t$aa_freqs{$aa} = $freq;\n\t\t}\n\treturn \\%aa_freqs;\n}\n\n=head2 codon_abs_frequency\n\n Title   : codon_abs_frequency\n Usage   : my $freq = $cdtable->codon_abs_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of all codons in the organism. \n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\nsub codon_abs_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod))  {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code() );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\n\t\treturn $self->{'_table'}{$aa}{$cod}{'per1000'}/10 ;\n\t\t}\n\telse {return 0;}\n}\n\n=head2 codon_rel_frequency\n\n Title   : codon_rel_frequency\n Usage   : my $freq = $cdtable->codon_rel_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of codons coding for the same amino acid. E.g., ATG and TGG\n           would return 100 as those codons are unique.\n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\n\nsub codon_rel_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod)) {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code () );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\treturn $self->{'_table'}{$aa}{$cod}{'rel_freq'};\n\t}\n\telse {\n\t\treturn 0;\n\t\t}\n}\n\n=head2 probable_codons\n\n Title    : probable_codons\n Usage    : my $prob_codons = $cd_table->probable_codons(10);\n Purpose  : to obtain a list of codons for the amino acid above a given\n            threshold % relative frequency\n Returns  : A reference to a hash where keys are 1 letter amino acid  codes\n            and values are references to arrays of codons whose frequency\n            is above the threshold.\n Arguments: a minimum threshold frequency\n\n\nsub probable_codons {\n\tmy ($self, $threshold) = @_;\n\tif (!$threshold || $threshold < 0 || $threshold > 100) {\n\t\t$self->throw(\" I need a threshold percentage \");\n\t\t}\n\tmy %return_hash;\n\tfor my $a(keys %STRICTAA) {\n\t\tmy @common_codons;\n\t\tmy $aa =$Bio::SeqUtils::THREECODE{$a};\n\t\tfor my $codon (keys %{ $self->{'_table'}{$aa}}) {\n\t\t\tif ($self->{'_table'}{$aa}{$codon}{'rel_freq'} > $threshold/100){\n\t\t\t\tpush @common_codons, $codon;\n\t\t\t}\n\t\t}\n\t\t$return_hash{$a} = \\@common_codons;\n\t}\n    ## check to make sure that all codons are populated ##\n\tif (grep{scalar @{$return_hash{$_}} == 0} keys %return_hash) {\n\t\t$self->warn(\"Threshold is too high, some amino acids do not\" .\n\t\t\t\t\t\" have any codon above the threshold!\");\n\t\t}\n    return \\%return_hash;\n}\n\t\t\n\n=head2 most_common_codons\n\n Title    : most_common_codons\n Usage    : my $common_codons = $cd_table->most_common_codons();\n Purpose  : To obtain the most common codon for a given amino acid\n Returns  : A reference to a hash where keys are 1 letter amino acid codes\n            and the values are the single most common codons for those amino acids\n Arguments: None\n\n\nsub most_common_codons {\n\tmy $self = shift;\n\n\tmy %return_hash;\n\n\tfor my $a ( keys %STRICTAA ) {\n\n\t\tmy $common_codon = '';\n\t\tmy $rel_freq = 0;\n\t\tmy $aa = $Bio::SeqUtils::THREECODE{$a};\n\n\t\tif ( ! defined $self->{'_table'}{$aa} ) {\n\t\t\t$self->warn(\"Amino acid $aa ($a) does not have any codons!\");\n\t\t\tnext;\n\t\t}\n\n\t\tfor my $codon ( keys %{ $self->{'_table'}{$aa}} ) {\n\t\t\tif ($self->{'_table'}{$aa}{$codon}{'rel_freq'} > $rel_freq ){\n\t\t\t\t$common_codon = $codon;\n\t\t\t\t$rel_freq = $self->{'_table'}{$aa}{$codon}{'rel_freq'};\n\t\t\t}\n\t\t}\n\t\t$return_hash{$a} = $common_codon;\n\t}\n   \n\treturn \\%return_hash;\n}\n\n=head2 codon_count\n\n Title   : codon_count\n Usage   : my $count = $cdtable->codon_count('CTG');\n Purpose : To obtain the absolute number of the codons in the\n           organism. \n Returns : an integer\n Args    : a non-ambiguous codon string\n\n\nsub codon_count {\n\tmy $self = shift;\n\tif (@_) {\n\t\tmy $a = shift;\n\t\tmy $cod = uc $a;\n\t\tif ($self->_check_codon($cod)) {\n\t\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t\t$ctable->id($self->genetic_code());\n\t\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\t\treturn $self->{'_table'}{$aa}{$cod}{'abs_count'};\n\t\t\t}\n\t\telse {return 0;}\n\t}\n\telse {\n\t\t$self->warn(\" need to give a codon sequence as a parameter \");\n\t\treturn 0;\n\t\t}\n\t\n}\n\n=head2 get_coding_gc\n\n Title   : get_coding_gc\n Usage   : my $count = $cdtable->get_coding_gc(1);\n Purpose : To return the percentage GC composition for the organism at\n           codon positions 1,2 or 3, or an average for all coding sequence\n          ('all').\n Returns : a number (%-age GC content) or 0 if these fields are undefined\n Args    : 1,2,3 or 'all'.\n\n\nsub get_coding_gc {\n\tmy $self  = shift;\n\tif (! @_) {\n\t\t$self->warn(\" no parameters supplied must be  a codon position (1,2,3) or 'all'\");\n\t\treturn 0;\n\t\t\t}\n\telse{\n\t\tmy $n = shift;\n\t\t##return request if valid ##\n\t\tif ( exists($self->{'_coding_gc'}{$n} ) ) {\n\t\t\treturn sprintf(\"%.2f\", $self->{'_coding_gc'}{$n});\n\t\t\t}\n\t\t##else return 'all' value if exists\n\t\telsif (exists($self->{'_coding_gc'}{'all'} )) {\n\t\t\t$self->warn(\"coding gc doesn't have value for [$n], returning gc content for all CDSs\");\n\t\t\treturn sprintf(\"%.2f\", $self->{'_coding_gc'}{'all'});\n\t\t\t}\n\t\t### else return 0, \n\t\telse {\n\t\t\t$self->warn(\"coding gc values aren't defined, returning 0\");\n\t\t\treturn 0;\n\t\t}\n\n\t}#end of outer else\n\t\t\n}\n\n=head2 set_coding_gc\n\n Title   : set_coding_gc\n Usage   : my $count = $cdtable->set_coding_gc(-1=>55.78);\n Purpose : To set the percentage GC composition for the organism at\n           codon positions 1,2 or 3, or an average for all coding sequence\n           ('all').  \n Returns : void\n Args    : a hash where the key must be 1,2,3 or 'all' and the value the %age GC\n           at that codon position..\n\n\nsub set_coding_gc {\n\tmy ($self, $key, $value) = @_;\n\tmy @allowed = qw(1 2 3 all);\n\t$key =~ s/\\-//;\n\tif (!grep {$key eq $_} @allowed ) {\n\t\t$self->warn (\"invalid key! - must be one of [ \". (join \" \", @allowed) . \"]\");\n\t\treturn;\n\t\t}\n\t$self->{'_coding_gc'}{$key} = $value;\n\t\n\n}\n\n=head2 species\n\n Title     : species\n Usage     : my $sp = $cut->species();\n Purpose   : Get/setter for species name of codon table\n Returns   : Void or species name string\n Args      : None or species name string\n\n\nsub species {\n\tmy $self = shift;\n\tif (@_ ){\n\t\t$self->{'_species'} = shift;\n\t\t}\n\treturn $self->{'_species'} || \"unknown\";\n}\n\n=head2 genetic_code\n\n Title     : genetic_code\n Usage     : my $sp = $cut->genetic_code();\n Purpose   : Get/setter for genetic_code name of codon table\n Returns   : Void or genetic_code id, 1 by default\n Args      : None or genetic_code id, 1 by default if invalid argument.\n\n\nsub genetic_code {\n\tmy $self = shift;\n\tif (@_ ){\n\t\tmy $val = shift;\n\t\tif ($val < 0 || $val >16 || $val =~ /[^\\d]/ \n\t\t\t\t|| $val ==7 || $val ==8) {\n\t\t\t$self->warn (\"invalid genetic code - must be 1-16 but not 7 or 8,setting to default [1]\");\n\t\t\t$self->{'_genetic_code'} = 1;\n\t\t\t}\n\t\telse {\n\t\t\t$self->{'_genetic_code'} = shift;\n\t\t\t}\n\t\t}\n\treturn $self->{'_genetic_code'} || 1;\n}\n\n=head2 cds_count\n\n Title   : cds_count\n Usage   : my $count = $cdtable->cds_count();\n Purpose : To retrieve the total number of CDSs used to generate the Codon Table\n           for that organism. \n Returns : an integer\n Args    : none (if retrieving the value) or an integer( if setting ). \n\n\nsub cds_count {\n\tmy $self= shift;\n\tif (@_) {\n\t\tmy $val = shift;\n\t\tif ($val < 0) {\n\t\t\t$self->warn(\"can't have negative count initializing to 1\");\n\t\t\t$self->{'_cds_count'} = 0.00;\n\t\t\t}\n\t\telse{\n\t\t\t$self->{'_cds_count'} = $val;\n\t\t}\n\t}\n\t$self->warn(\"cds_count value is undefined, returning 0\") \n\t\tif !exists($self->{'_cds_count'});\n\n\treturn $self->{'_cds_count'} || 0.00;\n\t}\n\n=head2 aa_frequency\n\n Title   : aa_frequency\n Usage   : my $freq = $cdtable->aa_frequency('Leu');\n Purpose : To retrieve the frequency of an amino acid in the organism\n Returns : a percentage\n Args    : a 1 letter or 3 letter string representing the amino acid\n\n\n\t\n\nsub aa_frequency {\n\tmy ($self, $a) = @_;\n\t## process args ##\n\n\t## deal with cases ##\n\tmy $aa = lc $a;\t\n\t$aa =~ s/^(\\w)/\\U$1/;\n\tif (!exists($STRICTAA{$aa}) && !exists($Bio::SeqUtils::ONECODE{$aa}) ) {\n\t\t$self->warn(\"Invalid amino acid! must be a unique 1 letter or 3 letter identifier\");\n\t\treturn;\n\t\t}\n\t#translate to 3 letter code for Ctable #\n\tmy $aa3 = $Bio::SeqUtils::THREECODE{$aa} || $aa;\n\n\t## return % of all amino acids in organism ## \n\tmy $freq = 0;\n\tmap {$freq += $self->{'_table'}{$aa3}{$_}{'per1000'} } keys %{$self->{'_table'}{$aa3}};\n\treturn sprintf(\"%.2f\", $freq/10);\n}\n\n=head2 common_codon\n\n Title   : common_codon\n Usage   : my $freq = $cdtable->common_codon('Leu');\n Purpose : To retrieve the frequency of the most common codon of that aa\n Returns : a percentage\n Args    : a 1 letter or 3 letter string representing the amino acid\n\n\nsub common_codon{\n\n\tmy ($self, $a) = @_;\n\tmy $aa = lc $a;\t\n\t$aa =~ s/^(\\w)/\\U$1/;\n\n\tif ($self->_check_aa($aa))\t{\n\t\tmy $aa3 = $Bio::SeqUtils::THREECODE{$aa} ;\n\t\t$aa3 ||= $aa;\n\t\tmy $max = 0;\n\t\tfor my $cod (keys %{$self->{'_table'}{$aa3}}) {\n\t\t\t$max = ($self->{'_table'}{$aa3}{$cod}{'rel_freq'} > $max) ?\n\t\t\t\t\t$self->{'_table'}{$aa3}{$cod}{'rel_freq'}:$max;\n\t\t\t}\n\t\treturn $max;\n\t\t}else {return 0;}\n}\n\n=head2 rare_codon\n\n Title   : rare_codon\n Usage   : my $freq = $cdtable->rare_codon('Leu');\n Purpose : To retrieve the frequency of the least common codon of that aa\n Returns : a percentage\n Args    : a 1 letter or 3 letter string representing the amino acid","parameters":[{"label":"$self"},{"label":"$a"}],"label":"rare_codon($self,$a)"},"name":"rare_codon","range":{"end":{"line":581,"character":9999},"start":{"character":0,"line":568}}},{"name":"SeqUtils","containerName":"THREECODE","line":574,"kind":12},{"range":{"start":{"line":588,"character":0},"end":{"character":9999,"line":594}},"name":"_check_aa","children":[{"kind":13,"line":589,"name":"$self","definition":"my","containerName":"_check_aa","localvar":"my"},{"containerName":"_check_aa","name":"$aa","kind":13,"line":589},{"containerName":"_check_aa","name":"$STRICTAA","line":590,"kind":13},{"name":"$aa","containerName":"_check_aa","line":590,"kind":13},{"containerName":"_check_aa","name":"$Bio","line":590,"kind":13},{"kind":13,"line":590,"name":"$aa","containerName":"_check_aa"},{"line":591,"kind":13,"containerName":"_check_aa","name":"$self"},{"line":591,"kind":12,"name":"warn","containerName":"_check_aa"}],"line":588,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$aa"}],"documentation":"# internal sub that checks a codon is correct format","label":"_check_aa($self,$aa)"},"detail":"($self,$aa)","definition":"sub","containerName":"main::"},{"name":"SeqUtils","containerName":"ONECODE","kind":12,"line":590},{"signature":{"parameters":[{"label":"$self"},{"label":"$cod"}],"documentation":"","label":"_check_codon($self,$cod)"},"detail":"($self,$cod)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":600,"name":"$self","definition":"my","containerName":"_check_codon","localvar":"my"},{"containerName":"_check_codon","name":"$cod","kind":13,"line":600},{"line":601,"kind":13,"containerName":"_check_codon","name":"$cod"},{"name":"$cod","containerName":"_check_codon","kind":13,"line":601},{"containerName":"_check_codon","name":"$self","line":602,"kind":13},{"line":602,"kind":12,"name":"warn","containerName":"_check_codon"}],"line":599,"kind":12,"range":{"start":{"line":599,"character":0},"end":{"line":606,"character":9999}},"name":"_check_codon"},{"name":"_init_from_cod","range":{"end":{"line":618,"character":9999},"start":{"line":607,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"_init_from_cod($self,$ref)","documentation":"","parameters":[{"label":"$self"},{"label":"$ref"}]},"detail":"($self,$ref)","kind":12,"children":[{"localvar":"my","containerName":"_init_from_cod","name":"$self","definition":"my","line":610,"kind":13},{"name":"$ref","containerName":"_init_from_cod","kind":13,"line":610},{"localvar":"my","containerName":"_init_from_cod","definition":"my","name":"$ct","line":611,"kind":13},{"line":611,"kind":12,"containerName":"_init_from_cod","name":"new"},{"name":"%aa_hash","definition":"my","containerName":"_init_from_cod","localvar":"my","kind":13,"line":612},{"kind":13,"line":613,"containerName":"_init_from_cod","name":"$codon","definition":"my","localvar":"my"},{"kind":13,"line":614,"containerName":"_init_from_cod","definition":"my","name":"$aa","localvar":"my"},{"containerName":"_init_from_cod","name":"$ct","line":614,"kind":13},{"kind":12,"line":614,"containerName":"_init_from_cod","name":"translate"},{"name":"$codon","containerName":"_init_from_cod","kind":13,"line":614},{"containerName":"_init_from_cod","name":"$aa_hash","line":615,"kind":13},{"line":615,"kind":13,"name":"$aa","containerName":"_init_from_cod"},{"line":615,"kind":13,"containerName":"_init_from_cod","name":"$codon"},{"containerName":"_init_from_cod","name":"$ref","kind":13,"line":615},{"line":615,"kind":13,"name":"$codon","containerName":"_init_from_cod"},{"line":617,"kind":13,"containerName":"_init_from_cod","name":"$self"},{"line":617,"kind":12,"containerName":"_init_from_cod","name":"_init_from_aa"},{"line":617,"kind":13,"containerName":"_init_from_cod","name":"%aa_hash"}],"line":607},{"containerName":"Tools::CodonTable","name":"Bio","kind":12,"line":611},{"containerName":"main::","definition":"sub","detail":"($self,$ref)","signature":{"parameters":[{"label":"$self"},{"label":"$ref"}],"documentation":"","label":"_init_from_aa($self,$ref)"},"kind":12,"line":621,"children":[{"containerName":"_init_from_aa","definition":"my","name":"$self","localvar":"my","kind":13,"line":622},{"kind":13,"line":622,"name":"$ref","containerName":"_init_from_aa"},{"line":624,"kind":13,"localvar":"my","containerName":"_init_from_aa","definition":"my","name":"$total_codons"},{"containerName":"_init_from_aa","definition":"my","name":"%threeletter","localvar":"my","kind":13,"line":625},{"name":"$threeletter","containerName":"_init_from_aa","kind":13,"line":626},{"containerName":"_init_from_aa","name":"$Bio","line":626,"kind":13},{"containerName":"_init_from_aa","name":"$ref","line":626,"kind":13},{"name":"$ref","containerName":"_init_from_aa","kind":13,"line":627},{"containerName":"_init_from_aa","name":"%threeletter","line":627,"kind":13},{"kind":13,"line":628,"containerName":"_init_from_aa","name":"$aa","definition":"my","localvar":"my"},{"line":629,"kind":13,"localvar":"my","definition":"my","name":"$cod","containerName":"_init_from_aa"},{"kind":13,"line":629,"containerName":"_init_from_aa","name":"$ref"},{"containerName":"_init_from_aa","name":"$aa","kind":13,"line":629},{"kind":13,"line":630,"name":"$self","containerName":"_init_from_aa"},{"name":"$aa","containerName":"_init_from_aa","line":630,"kind":13},{"line":630,"kind":13,"containerName":"_init_from_aa","name":"$cod"},{"line":630,"kind":13,"name":"$ref","containerName":"_init_from_aa"},{"line":630,"kind":13,"containerName":"_init_from_aa","name":"$aa"},{"kind":13,"line":630,"containerName":"_init_from_aa","name":"$cod"},{"line":631,"kind":13,"containerName":"_init_from_aa","name":"$total_codons"},{"containerName":"_init_from_aa","name":"$ref","kind":13,"line":631},{"kind":13,"line":631,"containerName":"_init_from_aa","name":"$aa"},{"line":631,"kind":13,"containerName":"_init_from_aa","name":"$cod"}],"name":"_init_from_aa","range":{"end":{"character":9999,"line":633},"start":{"line":621,"character":0}}},{"name":"SeqUtils","containerName":"THREECODE","kind":12,"line":626},{"line":636,"kind":13,"localvar":"my","name":"%aa","definition":"my","containerName":null},{"line":637,"kind":13,"localvar":"my","definition":"my","name":"$cod","containerName":null},{"line":637,"kind":13,"name":"%ref","containerName":null},{"name":"%aa","containerName":null,"kind":13,"line":637},{"kind":13,"line":638,"containerName":null,"name":"%self"},{"name":"%aa","containerName":null,"kind":13,"line":638},{"line":638,"kind":13,"containerName":null,"name":"%cod"},{"name":"%ref","containerName":null,"kind":13,"line":639},{"containerName":null,"name":"%aa","kind":13,"line":639},{"kind":13,"line":639,"containerName":null,"name":"$cod"},{"name":"$total_codons","containerName":null,"kind":13,"line":639},{"kind":13,"line":643,"definition":"my","name":"%aa","containerName":null,"localvar":"my"},{"line":644,"kind":13,"localvar":"my","definition":"my","name":"%aa_freq","containerName":null},{"containerName":null,"name":"$aa_freq","line":645,"kind":13},{"line":645,"kind":13,"name":"%ref","containerName":null},{"containerName":null,"name":"%aa","line":645,"kind":13},{"name":"%ref","containerName":null,"kind":13,"line":646},{"kind":13,"line":646,"containerName":null,"name":"$aa"},{"kind":13,"line":647,"containerName":null,"definition":"my","name":"$cod","localvar":"my"},{"containerName":null,"name":"%ref","line":647,"kind":13},{"name":"%aa","containerName":null,"line":647,"kind":13},{"name":"%self","containerName":null,"line":648,"kind":13},{"name":"%aa","containerName":null,"kind":13,"line":648},{"kind":13,"line":648,"containerName":null,"name":"%cod"},{"name":"%ref","containerName":null,"line":649,"kind":13},{"line":649,"kind":13,"containerName":null,"name":"%aa"},{"containerName":null,"name":"$cod","kind":13,"line":649},{"kind":13,"line":649,"name":"$aa_freq","containerName":null},{"localvar":"my","definition":"my","name":"%GC","containerName":null,"line":655,"kind":13},{"kind":13,"line":656,"containerName":null,"name":"%aa","definition":"my","localvar":"my"},{"name":"$cod","definition":"my","containerName":null,"localvar":"my","kind":13,"line":657},{"containerName":null,"name":"%ref","line":657,"kind":13},{"containerName":null,"name":"%aa","line":657,"kind":13},{"localvar":"my","containerName":null,"name":"%index","definition":"my","line":658,"kind":13},{"containerName":null,"name":"$cod","kind":13,"line":659},{"kind":13,"line":659,"name":"%index","containerName":null},{"line":660,"kind":13,"containerName":null,"name":"%GC"},{"line":660,"kind":13,"containerName":null,"name":"$index"},{"kind":13,"line":660,"name":"%ref","containerName":null},{"name":"%aa","containerName":null,"kind":13,"line":660},{"line":660,"kind":13,"name":"$cod","containerName":null},{"line":665,"kind":13,"localvar":"my","definition":"my","name":"%tot","containerName":null},{"name":"$tot","containerName":null,"kind":13,"line":666},{"kind":13,"line":666,"name":"%GC","containerName":null},{"kind":13,"line":667,"containerName":null,"name":"$self"},{"line":667,"kind":12,"containerName":"main::","name":"set_coding_gc"},{"line":667,"kind":13,"name":"$tot","containerName":null},{"line":667,"kind":13,"containerName":null,"name":"%total_codons"},{"kind":13,"line":668,"containerName":null,"name":"$self"},{"kind":12,"line":668,"containerName":"main::","name":"set_coding_gc"},{"name":"%GC","containerName":null,"kind":13,"line":668},{"containerName":null,"name":"$total_codons","kind":13,"line":668},{"name":"$self","containerName":null,"kind":13,"line":671},{"containerName":"main::","name":"_gb_db","definition":"sub","range":{"end":{"character":9999,"line":677},"start":{"character":0,"line":674}},"kind":12,"line":674,"children":[{"kind":13,"line":675,"containerName":"_gb_db","name":"$self","definition":"my","localvar":"my"},{"line":676,"kind":13,"name":"$self","containerName":"_gb_db"}]}]}