{"version":5,"vars":[{"line":91,"kind":2,"name":"base","containerName":""},{"name":"new","range":{"end":{"character":9999,"line":106},"start":{"character":0,"line":103}},"kind":12,"line":103,"children":[{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":104},{"line":104,"kind":13,"name":"@args","containerName":"new"},{"line":105,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$self"},{"name":"$class","containerName":"new","kind":13,"line":105},{"name":"@args","containerName":"new","line":105,"kind":13}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"__END__\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::IO - for reading and writing codon usage tables to file\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::IO;\n\n  ## read in a codon usage file\n  my $io = Bio::CodonUsage::IO->new(-file => \"in\");\n  my $cut = $io->next_data();\n\n  ## write it out again\n  my $out = Bio::CodonUsage::IO->new(-file => \">out\");\n  $out->write_data($cut);\n\n=head1 DESCRIPTION\n\nThis class provides standard IO methods for reading and writing text files\nof codon usage tables. These tables can initially be retrieved using\nBio::DB::CUTG. At present only this format is supported for read/write. \n\nReading a CUTG will return a Bio::CodonUsage::Table object. \n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::Table>,\nL<Bio::CodonUsage::IO>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin\n\npackage Bio::CodonUsage::IO;\nuse Bio::CodonUsage::Table;\n\nuse base qw(Bio::Root::IO);\n\n=head2  new\n\n Title  : new\n Usage  : my $io = Bio::CodonUsage::IO->new(-file => \"CUTfile\");\n Purpose: To  read/write a Bio:CodonUsage::Table object  \n Returns: A  Bio:CodonUsage::IO object\n Args   : a file or file handle "}},{"kind":12,"line":105,"name":"SUPER","containerName":"new"},{"name":"next_data","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":119},"end":{"line":123,"character":9999}},"kind":12,"children":[{"containerName":"next_data","definition":"my","name":"$self","localvar":"my","kind":13,"line":120},{"localvar":"my","containerName":"next_data","name":"$cut","definition":"my","line":121,"kind":13},{"kind":13,"line":121,"name":"$self","containerName":"next_data"},{"line":121,"kind":12,"containerName":"next_data","name":"_parse"},{"kind":13,"line":122,"name":"$cut","containerName":"next_data"}],"line":119},{"kind":12,"line":136,"children":[{"localvar":"my","containerName":"write_data","definition":"my","name":"$self","line":137,"kind":13},{"name":"$cut","containerName":"write_data","kind":13,"line":137},{"kind":13,"line":138,"name":"$cut","containerName":"write_data"},{"containerName":"write_data","name":"$cut","kind":13,"line":138},{"kind":12,"line":138,"name":"isa","containerName":"write_data"},{"containerName":"write_data","name":"$self","line":139,"kind":13},{"containerName":"write_data","name":"throw","kind":12,"line":139},{"localvar":"my","definition":"my","name":"$outstring","containerName":"write_data","line":141,"kind":13},{"line":143,"kind":13,"localvar":"my","name":"$sp_string","definition":"my","containerName":"write_data"},{"kind":13,"line":143,"containerName":"write_data","name":"$cut"},{"name":"species","containerName":"write_data","line":143,"kind":12},{"containerName":"write_data","name":"$cut","kind":13,"line":143},{"containerName":"write_data","name":"_gb_db","kind":12,"line":143},{"line":144,"kind":13,"name":"$cut","containerName":"write_data"},{"name":"cds_count","containerName":"write_data","kind":12,"line":144},{"name":"$outstring","containerName":"write_data","line":145,"kind":13},{"name":"$sp_string","containerName":"write_data","kind":13,"line":145},{"kind":13,"line":146,"containerName":"write_data","definition":"my","name":"$colhead","localvar":"my"},{"line":148,"kind":13,"name":"$outstring","containerName":"write_data"},{"kind":13,"line":148,"containerName":"write_data","name":"$colhead"},{"line":151,"kind":13,"localvar":"my","containerName":"write_data","name":"$ctable","definition":"my"},{"kind":12,"line":151,"name":"new","containerName":"write_data"},{"name":"$f","definition":"my","containerName":"write_data","localvar":"my","kind":13,"line":153},{"localvar":"my","containerName":"write_data","definition":"my","name":"$s","line":154,"kind":13},{"line":155,"kind":13,"localvar":"my","definition":"my","name":"$t","containerName":"write_data"},{"containerName":"write_data","name":"$cod","kind":13,"line":156},{"line":156,"kind":13,"containerName":"write_data","name":"$f"},{"line":156,"kind":13,"name":"$s","containerName":"write_data"},{"containerName":"write_data","name":"$t","line":156,"kind":13},{"containerName":"write_data","name":"$aa","definition":"my","localvar":"my","kind":13,"line":157},{"name":"$Bio","containerName":"write_data","kind":13,"line":157},{"line":157,"kind":13,"name":"$ctable","containerName":"write_data"},{"containerName":"write_data","name":"translate","kind":12,"line":157},{"containerName":"write_data","name":"$cod","line":157,"kind":13},{"kind":13,"line":158,"containerName":"write_data","name":"$codstr","definition":"my","localvar":"my"},{"containerName":"write_data","name":"$aa","kind":13,"line":160},{"kind":13,"line":160,"containerName":"write_data","name":"$cod"},{"localvar":"my","name":"$tt","definition":"my","containerName":"write_data","line":160,"kind":13},{"name":"$cut","containerName":"write_data","line":160,"kind":13},{"kind":12,"line":160,"containerName":"write_data","name":"codon_count"},{"kind":13,"line":160,"containerName":"write_data","name":"$cod"},{"localvar":"my","name":"$ll","definition":"my","containerName":"write_data","line":161,"kind":13},{"kind":13,"line":161,"name":"$cut","containerName":"write_data"},{"containerName":"write_data","name":"$aa","kind":13,"line":161},{"kind":13,"line":161,"name":"$cod","containerName":"write_data"},{"localvar":"my","containerName":"write_data","definition":"my","name":"$ss","line":162,"kind":13},{"name":"$cut","containerName":"write_data","line":162,"kind":13},{"containerName":"write_data","name":"codon_rel_frequency","kind":12,"line":162},{"containerName":"write_data","name":"$cod","kind":13,"line":162},{"name":"$outstring","containerName":"write_data","kind":13,"line":163},{"containerName":"write_data","name":"$codstr","kind":13,"line":163},{"containerName":"write_data","name":"$outstring","kind":13,"line":165},{"containerName":"write_data","name":"$outstring","line":168,"kind":13},{"name":"$outstring","containerName":"write_data","kind":13,"line":171},{"name":"$cut","containerName":"write_data","line":171,"kind":13},{"line":171,"kind":12,"containerName":"write_data","name":"get_coding_gc"},{"containerName":"write_data","name":"$outstring","line":172,"kind":13},{"kind":13,"line":172,"name":"$cut","containerName":"write_data"},{"kind":12,"line":172,"containerName":"write_data","name":"get_coding_gc"},{"name":"$outstring","containerName":"write_data","line":173,"kind":13},{"containerName":"write_data","name":"$cut","kind":13,"line":173},{"kind":12,"line":173,"name":"get_coding_gc","containerName":"write_data"},{"kind":13,"line":174,"containerName":"write_data","name":"$outstring"},{"kind":13,"line":174,"containerName":"write_data","name":"$cut"},{"kind":12,"line":174,"name":"get_coding_gc","containerName":"write_data"},{"name":"$outstring","containerName":"write_data","line":175,"kind":13},{"containerName":"write_data","name":"$cut","kind":13,"line":175},{"name":"genetic_code","containerName":"write_data","line":175,"kind":12},{"name":"$self","containerName":"write_data","kind":13,"line":177},{"name":"_print","containerName":"write_data","line":177,"kind":12},{"name":"$outstring","containerName":"write_data","kind":13,"line":177},{"containerName":"write_data","name":"$self","kind":13,"line":178},{"kind":12,"line":178,"containerName":"write_data","name":"flush"}],"containerName":"main::","definition":"sub","detail":"($self,$cut)","signature":{"parameters":[{"label":"$self"},{"label":"$cut"}],"documentation":"__END__\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::IO - for reading and writing codon usage tables to file\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::IO;\n\n  ## read in a codon usage file\n  my $io = Bio::CodonUsage::IO->new(-file => \"in\");\n  my $cut = $io->next_data();\n\n  ## write it out again\n  my $out = Bio::CodonUsage::IO->new(-file => \">out\");\n  $out->write_data($cut);\n\n=head1 DESCRIPTION\n\nThis class provides standard IO methods for reading and writing text files\nof codon usage tables. These tables can initially be retrieved using\nBio::DB::CUTG. At present only this format is supported for read/write. \n\nReading a CUTG will return a Bio::CodonUsage::Table object. \n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::Table>,\nL<Bio::CodonUsage::IO>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin\n\npackage Bio::CodonUsage::IO;\nuse Bio::CodonUsage::Table;\n\nuse base qw(Bio::Root::IO);\n\n=head2  new\n\n Title  : new\n Usage  : my $io = Bio::CodonUsage::IO->new(-file => \"CUTfile\");\n Purpose: To  read/write a Bio:CodonUsage::Table object  \n Returns: A  Bio:CodonUsage::IO object\n Args   : a file or file handle \n\n\nsub new  {\n\tmy ($class , @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n}\n\n\n=head2  next_data\n\n Title  : next_data\n Usage  : my $cut = $io->next_data();\n Purpose: To  obtain a Bio:CodonUsage::Table object \n Returns: A  Bio:CodonUsage::Table object\n Args   : none\n\n\nsub next_data {\n\tmy $self = shift;\n\tmy $cut = $self->_parse;\n\treturn $cut;\n}\n\n=head2  write_data\n\n Title  : write_data\n Usage  : $io->write_data($cut);\n Purpose: To  write a CUT to file\n Returns: void\n Args   : a Bio::CodonUsage::Table object reference ","label":"write_data($self,$cut)"},"name":"write_data","range":{"end":{"line":180,"character":9999},"start":{"character":0,"line":136}}},{"kind":12,"line":138,"name":"Bio","containerName":"CodonUsage::Table"},{"kind":12,"line":151,"name":"Bio","containerName":"Tools::CodonTable"},{"kind":12,"line":157,"name":"SeqUtils","containerName":"THREECODE"},{"name":"_parse","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":227},"start":{"character":0,"line":182}},"kind":12,"children":[{"containerName":"_parse","definition":"my","name":"$self","localvar":"my","kind":13,"line":183},{"line":184,"kind":13,"localvar":"my","containerName":"_parse","name":"$cdtableobj","definition":"my"},{"name":"new","containerName":"_parse","line":184,"kind":12},{"kind":13,"line":185,"containerName":"_parse","name":"$line","definition":"my","localvar":"my"},{"name":"$self","containerName":"_parse","line":185,"kind":13},{"name":"_readline","containerName":"_parse","kind":12,"line":185},{"kind":13,"line":186,"containerName":"_parse","name":"$line"},{"kind":13,"line":187,"containerName":"_parse","name":"$line"},{"containerName":"_parse","name":"$line","line":190,"kind":13},{"containerName":"_parse","name":"$cdtableobj","kind":13,"line":191},{"kind":12,"line":191,"containerName":"_parse","name":"species"},{"kind":13,"line":192,"containerName":"_parse","name":"$cdtableobj"},{"containerName":"_parse","name":"$cdtableobj","kind":13,"line":193},{"line":193,"kind":12,"name":"cds_count","containerName":"_parse"},{"line":197,"kind":13,"containerName":"_parse","name":"$line"},{"name":"$cdtableobj","containerName":"_parse","kind":13,"line":200},{"line":209,"kind":13,"containerName":"_parse","name":"$line"},{"kind":13,"line":210,"name":"$cdtableobj","containerName":"_parse"},{"name":"$line","containerName":"_parse","kind":13,"line":212},{"kind":13,"line":213,"name":"$cdtableobj","containerName":"_parse"},{"kind":13,"line":215,"containerName":"_parse","name":"$line"},{"kind":13,"line":216,"name":"$cdtableobj","containerName":"_parse"},{"kind":13,"line":218,"containerName":"_parse","name":"$line"},{"name":"$cdtableobj","containerName":"_parse","line":219,"kind":13},{"name":"$line","containerName":"_parse","kind":13,"line":222},{"line":223,"kind":13,"name":"$cdtableobj","containerName":"_parse"},{"name":"$cdtableobj","containerName":"_parse","line":227,"kind":13}],"line":182},{"name":"Bio","containerName":"CodonUsage::Table","line":184,"kind":12},{"containerName":null,"name":"$cdtableobj","line":228,"kind":13},{"containerName":"main::","name":"warn","kind":12,"line":228},{"name":"$cdtableobj","containerName":null,"kind":13,"line":230}]}