{"version":5,"vars":[{"containerName":"","name":"base","line":228,"kind":2},{"line":230,"kind":13,"localvar":"my","definition":"my","name":"$entry","containerName":null},{"signature":{"documentation":"","parameters":[{"label":"$caller"},{"label":"@args"}],"label":"new($caller,@args)"},"detail":"($caller,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":233,"containerName":"new","definition":"my","name":"$caller","localvar":"my"},{"name":"@args","containerName":"new","kind":13,"line":233},{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":234,"kind":13},{"name":"$caller","containerName":"new","kind":13,"line":234},{"containerName":"new","name":"$caller","line":234,"kind":13},{"name":"$class","containerName":"new","line":239,"kind":13},{"line":240,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"name":"$class","containerName":"new","line":240,"kind":13},{"line":240,"kind":13,"containerName":"new","name":"@args"},{"line":241,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":241,"containerName":"new","name":"_initialize"},{"name":"@args","containerName":"new","kind":13,"line":241},{"name":"$self","containerName":"new","kind":13,"line":242},{"line":249,"kind":13,"localvar":"my","containerName":"new","name":"%param","definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":249},{"containerName":"new","name":"@param","kind":13,"line":250},{"line":250,"kind":13,"name":"%param","containerName":"new"},{"kind":13,"line":250,"name":"%param","containerName":"new"},{"localvar":"my","definition":"my","name":"$format","containerName":"new","line":251,"kind":13},{"line":251,"kind":13,"name":"$param","containerName":"new"},{"kind":13,"line":252,"containerName":"new","name":"$class"},{"containerName":"new","name":"_guess_format","kind":12,"line":252},{"containerName":"new","name":"$param","line":252,"kind":13},{"kind":13,"line":252,"name":"$ARGV","containerName":"new"},{"kind":13,"line":254,"name":"$format","containerName":"new"},{"containerName":"new","name":"$format","line":257,"kind":13},{"line":261,"kind":12,"name":"new","containerName":"new"},{"kind":13,"line":261,"name":"@args","containerName":"new"}],"line":232,"kind":12,"range":{"end":{"line":263,"character":9999},"start":{"line":232,"character":0}},"name":"new"},{"containerName":"new","name":"SUPER","kind":12,"line":240},{"name":"_load_format_module","line":257,"kind":12},{"name":"newFh","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":269},"start":{"line":265,"character":0}},"kind":12,"children":[{"line":266,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"newFh"},{"name":"$self","definition":"my","containerName":"newFh","localvar":"my","kind":13,"line":267},{"kind":13,"line":267,"containerName":"newFh","name":"$class"},{"containerName":"newFh","name":"new","line":267,"kind":12},{"kind":13,"line":268,"containerName":"newFh","name":"$self"},{"kind":12,"line":268,"containerName":"newFh","name":"fh"}],"line":265},{"name":"fh","definition":"sub","containerName":"main::","range":{"start":{"line":272,"character":0},"end":{"character":9999,"line":278}},"kind":12,"children":[{"kind":13,"line":273,"containerName":"fh","name":"$self","definition":"my","localvar":"my"},{"containerName":"fh","name":"$class","definition":"my","localvar":"my","kind":13,"line":274},{"name":"$self","containerName":"fh","line":274,"kind":13},{"containerName":"fh","name":"$self","kind":13,"line":274},{"localvar":"my","name":"$s","definition":"my","containerName":"fh","line":275,"kind":13},{"name":"$class","containerName":"fh","line":276,"kind":13},{"containerName":"fh","name":"$self","kind":13,"line":276},{"kind":13,"line":277,"name":"$s","containerName":"fh"}],"line":272},{"containerName":"gensym","name":"Symbol","line":276,"kind":12},{"children":[{"kind":13,"line":283,"containerName":"_initialize","name":"$self","definition":"my","localvar":"my"},{"line":283,"kind":13,"containerName":"_initialize","name":"@args"},{"name":"$self","containerName":"_initialize","kind":13,"line":285},{"line":285,"kind":12,"containerName":"_initialize","name":"_initialize_io"},{"containerName":"_initialize","name":"@args","kind":13,"line":285}],"line":282,"kind":12,"signature":{"documentation":" _initialize is chained for all Bio::Biblio::IO classes","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"end":{"line":286,"character":9999},"start":{"character":0,"line":282}},"name":"_initialize"},{"range":{"end":{"line":302,"character":9999},"start":{"character":0,"line":299}},"name":"next_bibref","definition":"sub","containerName":"main::","children":[{"line":300,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"next_bibref"},{"containerName":"next_bibref","name":"$self","line":301,"kind":13},{"kind":12,"line":301,"containerName":"next_bibref","name":"throw"}],"line":299,"kind":12},{"range":{"start":{"line":322,"character":0},"end":{"line":343,"character":9999}},"name":"_load_format_module","signature":{"label":"_load_format_module($format)","documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Biblio::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Martin Senger <senger@ebi.ac.uk>\n# For copyright and disclaimer see below.\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Biblio::IO - Handling the bibliographic references\n\n=head1 SYNOPSIS\n\n    use Bio::Biblio::IO;\n\n    # getting citations from a file\n    $in = Bio::Biblio::IO->new ('-file' => 'myfile.xml' ,\n                                '-format' => 'medlinexml');\n  # --- OR ---\n\n    # getting citations from a string\n    $in = Bio::Biblio::IO->new ('-data' => '<MedlineCitation>...</MedlineCitation>' ,\n                                '-format' => 'medlinexml');\n  #--- OR ---\n\n    # getting citations from a string if IO::String is installed\n    use IO::String;\n    $in = Bio::Biblio::IO->new ('-fh' => IO::String->new ($citation),\n                                '-format' => 'medlinexml');\n\n    $in = Bio::Biblio::IO->new(-fh => $io_handle , '-format' => 'medlinexml');\n\n  #--- OR ---\n\n    # getting citations from any IO handler\n    $in = Bio::Biblio::IO->new('-fh' => $io_handle ,\n                               '-format' => 'medlinexml');\n\n\n    # now, having $in, we can read all citations\n    while ( my $citation = $in->next_bibref() ) {\n        &do_something_with_citation ($citation);\n    }\n\n  #--- OR ---\n\n    # again reading all citation but now a callback defined in your\n    # code is used (note that the reading starts already when new()\n    # is called)\n    $io = Bio::Biblio::IO->new('-format'   => 'medlinexml',\n                               '-file'     => $testfile,\n                               '-callback' => \\&callback);\n    sub callback {\n        my $citation = shift;\n        print $citation->{'_identifier'} . \"\\n\";\n    }\n\n  #Now, to actually get a citation in an XML format,\n  #use I<Bio::Biblio> module which returns an XML string:\n\n    use Bio::Biblio;\n    use Bio::Biblio::IO;\n    my $xml = Bio::Biblio->new->get_by_id ('12368254');\n    my $reader = Bio::Biblio::IO->new ('-data' => $xml,\n                                       '-format' => 'medlinexml');\n\n    while (my $citation = $reader->next_bibref()) {\n       #... do something here with $citation\n       }\n\n  #And, finally, the resulting citation can be received in different\n  #output formats:\n\n    $io = Bio::Biblio::IO->new('-format' => 'medlinexml',\n                               '-result' => 'raw');\n  #--- OR ---\n\n    $io = Bio::Biblio::IO->new('-format' => 'medlinexml',\n                               '-result' => 'medline2ref');\n\n  #--- OR ---\n\n    $io = Bio::Biblio::IO->new('-format' => 'pubmedxml',\n                               '-result' => 'pubmed2ref');\n\n=head1 DESCRIPTION\n\nBio::Biblio::IO is a handler module for accessing bibliographic\ncitations. The citations can be in different formats - assuming that\nthere is a corresponding module knowing that format in Bio::Biblio::IO\ndirectory (e.g. Bio::Biblio::IO::medlinexml). The format (and the\nmodule name) is given by the argument I<-format>.\n\nOnce an instance of C<Bio::Biblio::IO> class is available, the\ncitations can be read by calling repeatedly method I<next_bibref>:\n\n    while (my $citation = $reader->next_bibref()) {\n       ... do something here with $citation\n       }\n\nHowever, this may imply that all citations were already read into the\nmemory. If you expect a huge amount of citations to be read, you may\nchoose a I<callback> option. Your subroutine is specified in the\nC<new()> method and is called everytime a new citation is available\n(see an example above in SYNOPSIS).\n\nThe citations returned by I<next_bibref> or given to your callback\nroutine can be of different formats depending on the argument\nI<-result>. One result type is I<raw> and it is represented by a\nsimple, not blessed hash table:\n\n    $io = Bio::Biblio::IO->new('-result' => 'raw');\n\nWhat other result formats are available depends on the module who\nreads the citations in the first place. At the moment, the following\nones are available:\n\n    $io = Bio::Biblio::IO->new('-result' => 'medline2ref');\n\nThis is a default result format for reading citations by the\nI<medlinexml> module. The C<medlinexml> module is again the default\none. Which means that you can almost omit arguments (you still need to\nsay where the citations come from):\n\n    $io = Bio::Biblio::IO->new('-file' => 'data/medline_data.xml');\n\nAnother result format available is for PUBMED citations (which is a\nsuper-set of the MEDLINE citations having few more tags):\n\n    $io = Bio::Biblio::IO->new('-format' => 'pubmedxml',\n                               '-result' => 'pubmed2ref',\n                               '-data'   => $citation);\n\nOr, because C<pubmed2ref> is a default one for PUBMED citations, you can say just:\n\n    $io = Bio::Biblio::IO->new('-format' => 'pubmedxml',\n                               '-data'   => $citation);\n\nBoth C<medline2ref> and C<pubmed2ref> results are objects defined in\nthe directory C<Bio::Biblio>.\n\n=head1 SEE ALSO\n\n=over 4\n\n* *\n\nAn example script I<examples/biblio.pl>. It has many options and its\nown help.  The relevant options to this IO module are I<-f>\n(specifying what file to read) and I<-O> (specifying what result\nformat to achieve).\n\n* *\n\nOpenBQS home page: http://www.ebi.ac.uk/~senger/openbqs\n\n* *\n\nComments to the Perl client: http://www.ebi.ac.uk/~senger/openbqs/Client_perl.html\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nMartin Senger (senger@ebi.ac.uk)\n\n=head1 COPYRIGHT\n\nCopyright (c) 2002 European Bioinformatics Institute. All Rights Reserved.\n\nThis module is free software; you can redistribute it and/or modify\nit under the same terms as Perl itself.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Biblio::IO;\n\nuse strict;\n\nuse Symbol;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nmy $entry = 0;\n\nsub new {\n    my ($caller, @args) = @_;\n    my $class = ref ($caller) || $caller;\n\n    # if $caller is an object, or if it is an underlying\n    # 'real-work-doing' class (e.g. Bio::Biblio::IO::medlinexml) then\n    # we want to call SUPER to create and bless an object\n    if( $class =~ /Bio::Biblio::IO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new (@args);\n\t$self->_initialize (@args);\n\treturn $self;\n\n    # this is called only the first time when somebody calls: 'new\n    # Bio::Biblio::IO (...)', and it actually loads a 'real-work-doing'\n    # module and call this new() method again (unless the loaded\n    # module has its own new() method)\n    } else {\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} ||\n\t    $class->_guess_format( $param{-file} || $ARGV[0] ) ||\n\t\t'medlinexml';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# load module with the real implementation - as defined in $format\n\treturn unless (&_load_format_module ($format));\n\n\t# this will call this same method new() - but rather its\n\t# upper (object) branche\n\treturn \"Bio::Biblio::IO::$format\"->new(@args);\n    }\n}\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n# _initialize is chained for all Bio::Biblio::IO classes\n\nsub _initialize {\n    my ($self, @args) = @_;\n    # initialize the IO part\n    $self->_initialize_io (@args);\n}\n\n=head2 next_bibref\n\n Usage   : $citation = stream->next_bibref\n Function: Reads the next citation object from the stream and returns it.\n Returns : a Bio::Biblio::Ref citation object, or something else\n           (depending on the '-result' argument given in the 'new()'\n\t    method).\n Args    : none\n\n\nsub next_bibref {\n   my ($self) = shift;\n   $self->throw (\"Sorry, you cannot read from a generic Bio::Biblio::IO object.\");\n}\n\n# -----------------------------------------------------------------------------\n\n=head2 _load_format_module\n\n Usage   : $class->_load_format_module ($format)\n Returns : 1 on success, undef on failure\n Args    : 'format' should contain the last part of the\n           name of a module who does the real implementation\n\nIt does (in run-time) a similar thing as\n\n   require Bio::Biblio::IO::$format\n\nIt throws an exception if it fails to find and load the module\n(for example, because of the compilation errors in the module).","parameters":[{"label":"$format"}]},"detail":"($format)","definition":"sub","containerName":"main::","children":[{"containerName":"_load_format_module","name":"$format","definition":"my","localvar":"my","kind":13,"line":323},{"localvar":"my","name":"$module","definition":"my","containerName":"_load_format_module","line":324,"kind":13},{"kind":13,"line":324,"containerName":"_load_format_module","name":"$load"},{"line":324,"kind":13,"containerName":"_load_format_module","name":"$m"},{"name":"$module","containerName":"_load_format_module","line":326,"kind":13},{"kind":13,"line":327,"containerName":"_load_format_module","name":"$load"},{"line":329,"kind":13,"containerName":"_load_format_module","name":"$main"},{"name":"$module","containerName":"_load_format_module","line":329,"kind":13},{"containerName":"_load_format_module","name":"$load","line":331,"kind":13},{"name":"throw","containerName":"_load_format_module","kind":12,"line":334}],"line":322,"kind":12},{"name":"Bio","containerName":"Root::Root","line":334,"kind":12},{"children":[{"definition":"my","name":"$class","containerName":"_guess_format","localvar":"my","kind":13,"line":357}],"line":356,"kind":12,"range":{"end":{"character":9999,"line":361},"start":{"character":0,"line":356}},"name":"_guess_format","definition":"sub","containerName":"main::"},{"containerName":"main::","definition":"sub","name":"DESTROY","range":{"end":{"line":367,"character":9999},"start":{"line":363,"character":0}},"kind":12,"line":363,"children":[{"line":364,"kind":13,"localvar":"my","containerName":"DESTROY","name":"$self","definition":"my"},{"containerName":"DESTROY","name":"$self","line":366,"kind":13},{"kind":12,"line":366,"name":"close","containerName":"DESTROY"}]},{"signature":{"label":"TIEHANDLE($class,$val)","documentation":"","parameters":[{"label":"$class"},{"label":"$val"}]},"detail":"($class,$val)","definition":"sub","containerName":"main::","children":[{"containerName":"TIEHANDLE","name":"$class","definition":"my","localvar":"my","kind":13,"line":370},{"kind":13,"line":370,"containerName":"TIEHANDLE","name":"$val"},{"name":"$val","containerName":"TIEHANDLE","kind":13,"line":371},{"line":371,"kind":13,"containerName":"TIEHANDLE","name":"$class"}],"line":369,"kind":12,"range":{"end":{"character":9999,"line":372},"start":{"character":0,"line":369}},"name":"TIEHANDLE"},{"name":"READLINE","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":380},"start":{"line":374,"character":0}},"kind":12,"children":[{"line":375,"kind":13,"localvar":"my","containerName":"READLINE","name":"$self","definition":"my"},{"line":376,"kind":13,"containerName":"READLINE","name":"$self"},{"containerName":"READLINE","name":"next_bibref","line":376,"kind":12},{"localvar":"my","containerName":"READLINE","name":"@list","definition":"my","line":377,"kind":13},{"line":377,"kind":13,"containerName":"READLINE","name":"$obj"},{"name":"@list","containerName":"READLINE","kind":13,"line":378},{"line":378,"kind":13,"containerName":"READLINE","name":"$obj"},{"kind":13,"line":378,"name":"$obj","containerName":"READLINE"},{"containerName":"READLINE","name":"$self","line":378,"kind":13},{"line":378,"kind":12,"containerName":"READLINE","name":"next_bibref"},{"line":379,"kind":13,"name":"@list","containerName":"READLINE"}],"line":374}]}