{"vars":[{"kind":12,"children":[{"line":228,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$class"},{"kind":13,"line":228,"name":"@args","containerName":"new"},{"line":229,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"containerName":"new","name":"$class","kind":13,"line":229},{"containerName":"new","name":"@args","kind":13,"line":229},{"localvar":"my","containerName":"new","name":"$id","definition":"my","line":230,"kind":13},{"kind":13,"line":230,"name":"$nof_seq","containerName":"new"},{"kind":13,"line":230,"name":"$nof_rep","containerName":"new"},{"name":"$max_size","containerName":"new","line":230,"kind":13},{"line":230,"kind":13,"name":"$nof_overlaps","containerName":"new"},{"line":230,"kind":13,"name":"$min_overlap","containerName":"new"},{"line":231,"kind":13,"containerName":"new","name":"$min_identity"},{"containerName":"new","name":"$avg_overlap","line":231,"kind":13},{"name":"$avg_identity","containerName":"new","kind":13,"line":231},{"name":"$avg_seq_len","containerName":"new","kind":13,"line":231},{"line":231,"kind":13,"name":"$spectrum","containerName":"new"},{"line":232,"kind":13,"containerName":"new","name":"$assembly"},{"kind":13,"line":232,"name":"$eff_asm_params","containerName":"new"},{"line":232,"kind":13,"name":"$dissolve","containerName":"new"},{"name":"$cross","containerName":"new","line":232,"kind":13},{"line":232,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":232,"containerName":"new","name":"_rearrange"},{"kind":13,"line":235,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","kind":13,"line":238},{"line":239,"kind":13,"name":"$self","containerName":"new"},{"kind":13,"line":240,"name":"$self","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":241},{"line":242,"kind":13,"name":"$self","containerName":"new"},{"kind":13,"line":243,"name":"$self","containerName":"new"},{"name":"$self","containerName":"new","line":244,"kind":13},{"line":245,"kind":13,"name":"$self","containerName":"new"},{"name":"$self","containerName":"new","line":246,"kind":13},{"kind":13,"line":247,"containerName":"new","name":"$self"},{"line":248,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"$self","line":249,"kind":13},{"line":250,"kind":13,"containerName":"new","name":"$self"},{"name":"$self","containerName":"new","kind":13,"line":253},{"kind":13,"line":253,"containerName":"new","name":"$id"},{"containerName":"new","name":"$id","line":253,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":254},{"line":254,"kind":13,"containerName":"new","name":"$nof_seq"},{"name":"$nof_seq","containerName":"new","kind":13,"line":254},{"kind":13,"line":255,"name":"$self","containerName":"new"},{"containerName":"new","name":"$nof_rep","line":255,"kind":13},{"kind":13,"line":255,"name":"$nof_rep","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":256},{"kind":13,"line":256,"name":"$max_size","containerName":"new"},{"name":"$max_size","containerName":"new","line":256,"kind":13},{"line":257,"kind":13,"containerName":"new","name":"$self"},{"name":"$nof_overlaps","containerName":"new","line":257,"kind":13},{"kind":13,"line":257,"name":"$nof_overlaps","containerName":"new"},{"line":258,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"$min_overlap","line":258,"kind":13},{"line":258,"kind":13,"containerName":"new","name":"$min_overlap"},{"name":"$self","containerName":"new","kind":13,"line":259},{"containerName":"new","name":"$avg_overlap","kind":13,"line":259},{"name":"$avg_overlap","containerName":"new","line":259,"kind":13},{"containerName":"new","name":"$self","line":260,"kind":13},{"name":"$min_identity","containerName":"new","line":260,"kind":13},{"containerName":"new","name":"$min_identity","line":260,"kind":13},{"name":"$self","containerName":"new","line":261,"kind":13},{"containerName":"new","name":"$avg_identity","line":261,"kind":13},{"containerName":"new","name":"$avg_identity","kind":13,"line":261},{"containerName":"new","name":"$self","kind":13,"line":262},{"line":262,"kind":13,"name":"$avg_seq_len","containerName":"new"},{"kind":13,"line":262,"name":"$avg_seq_len","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":263},{"line":263,"kind":13,"containerName":"new","name":"$eff_asm_params"},{"line":263,"kind":13,"containerName":"new","name":"$eff_asm_params"},{"name":"$self","containerName":"new","kind":13,"line":266},{"name":"_import_spectrum","containerName":"new","kind":12,"line":266},{"kind":13,"line":266,"containerName":"new","name":"$spectrum"},{"line":266,"kind":13,"name":"$spectrum","containerName":"new"},{"containerName":"new","name":"$self","line":267,"kind":13},{"line":267,"kind":12,"containerName":"new","name":"_import_assembly"},{"name":"$assembly","containerName":"new","line":267,"kind":13},{"containerName":"new","name":"$assembly","kind":13,"line":267},{"containerName":"new","name":"$dissolve","kind":13,"line":268},{"definition":"my","name":"$mixed_csp","containerName":"new","localvar":"my","kind":13,"line":269},{"containerName":"new","name":"$header","line":269,"kind":13},{"kind":13,"line":269,"name":"$dissolve","containerName":"new"},{"line":269,"kind":13,"containerName":"new","name":"$dissolve"},{"name":"$self","containerName":"new","kind":13,"line":270},{"name":"_import_dissolved_csp","containerName":"new","kind":12,"line":270},{"line":270,"kind":13,"containerName":"new","name":"$mixed_csp"},{"name":"$header","containerName":"new","kind":13,"line":270},{"containerName":"new","name":"$self","kind":13,"line":272},{"containerName":"new","name":"_import_cross_csp","kind":12,"line":272},{"line":272,"kind":13,"containerName":"new","name":"$cross"},{"name":"$cross","containerName":"new","line":272,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":274}],"line":227,"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","name":"new","range":{"start":{"character":0,"line":227},"end":{"character":9999,"line":275}}},{"name":"base","containerName":"","kind":2,"line":228},{"containerName":"new","name":"SUPER","line":229,"kind":12},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]","label":"id($self,$id)"},"detail":"($self,$id)","kind":12,"children":[{"kind":13,"line":289,"name":"$self","definition":"my","containerName":"id","localvar":"my"},{"line":289,"kind":13,"name":"$id","containerName":"id"},{"name":"$id","containerName":"id","kind":13,"line":290},{"containerName":"id","name":"$self","kind":13,"line":291},{"line":291,"kind":13,"containerName":"id","name":"$id"},{"containerName":"id","name":"$id","line":293,"kind":13},{"containerName":"id","name":"$self","kind":13,"line":293},{"kind":13,"line":294,"name":"$id","containerName":"id"}],"line":288,"name":"id","range":{"end":{"line":295,"character":9999},"start":{"character":0,"line":288}}},{"name":"nof_seq","range":{"start":{"line":308,"character":0},"end":{"line":317,"character":9999}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$nof_seq"}],"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]","label":"nof_seq($self,$nof_seq)"},"detail":"($self,$nof_seq)","kind":12,"children":[{"line":309,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"nof_seq"},{"containerName":"nof_seq","name":"$nof_seq","line":309,"kind":13},{"containerName":"nof_seq","name":"$nof_seq","kind":13,"line":310},{"line":311,"kind":13,"name":"$self","containerName":"nof_seq"},{"kind":12,"line":311,"containerName":"nof_seq","name":"throw"},{"line":312,"kind":13,"containerName":"nof_seq","name":"$nof_seq"},{"containerName":"nof_seq","name":"$self","line":313,"kind":13},{"containerName":"nof_seq","name":"$nof_seq","kind":13,"line":313},{"kind":13,"line":315,"containerName":"nof_seq","name":"$nof_seq"},{"containerName":"nof_seq","name":"$self","line":315,"kind":13},{"kind":13,"line":316,"containerName":"nof_seq","name":"$nof_seq"}],"line":308},{"name":"nof_rep","range":{"start":{"line":331,"character":0},"end":{"character":9999,"line":340}},"kind":12,"line":331,"children":[{"line":332,"kind":13,"localvar":"my","containerName":"nof_rep","name":"$self","definition":"my"},{"line":332,"kind":13,"name":"$nof_rep","containerName":"nof_rep"},{"containerName":"nof_rep","name":"$nof_rep","line":333,"kind":13},{"line":334,"kind":13,"containerName":"nof_rep","name":"$self"},{"containerName":"nof_rep","name":"throw","kind":12,"line":334},{"containerName":"nof_rep","name":"$nof_rep","kind":13,"line":335},{"name":"$self","containerName":"nof_rep","kind":13,"line":336},{"containerName":"nof_rep","name":"$nof_rep","kind":13,"line":336},{"containerName":"nof_rep","name":"$nof_rep","kind":13,"line":338},{"kind":13,"line":338,"containerName":"nof_rep","name":"$self"},{"name":"$nof_rep","containerName":"nof_rep","line":339,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$nof_rep)","signature":{"label":"nof_rep($self,$nof_rep)","parameters":[{"label":"$self"},{"label":"$nof_rep"}],"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]"}},{"detail":"($self,$max_size)","signature":{"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]","parameters":[{"label":"$self"},{"label":"$max_size"}],"label":"max_size($self,$max_size)"},"containerName":"main::","definition":"sub","line":353,"children":[{"kind":13,"line":354,"name":"$self","definition":"my","containerName":"max_size","localvar":"my"},{"kind":13,"line":354,"containerName":"max_size","name":"$max_size"},{"name":"$max_size","containerName":"max_size","line":355,"kind":13},{"name":"$self","containerName":"max_size","kind":13,"line":356},{"name":"throw","containerName":"max_size","line":356,"kind":12},{"containerName":"max_size","name":"$max_size","line":357,"kind":13},{"kind":13,"line":358,"name":"$self","containerName":"max_size"},{"containerName":"max_size","name":"$max_size","line":358,"kind":13},{"line":360,"kind":13,"name":"$max_size","containerName":"max_size"},{"containerName":"max_size","name":"$self","kind":13,"line":360},{"kind":13,"line":361,"name":"$max_size","containerName":"max_size"}],"kind":12,"range":{"start":{"character":0,"line":353},"end":{"character":9999,"line":362}},"name":"max_size"},{"name":"nof_overlaps","range":{"end":{"line":384,"character":9999},"start":{"character":0,"line":375}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"nof_overlaps","line":376,"kind":13},{"line":376,"kind":13,"name":"$nof_overlaps","containerName":"nof_overlaps"},{"containerName":"nof_overlaps","name":"$nof_overlaps","line":377,"kind":13},{"name":"$self","containerName":"nof_overlaps","kind":13,"line":378},{"containerName":"nof_overlaps","name":"throw","line":378,"kind":12},{"containerName":"nof_overlaps","name":"$nof_overlaps","line":379,"kind":13},{"containerName":"nof_overlaps","name":"$self","kind":13,"line":380},{"kind":13,"line":380,"containerName":"nof_overlaps","name":"$nof_overlaps"},{"containerName":"nof_overlaps","name":"$nof_overlaps","line":382,"kind":13},{"kind":13,"line":382,"name":"$self","containerName":"nof_overlaps"},{"name":"$nof_overlaps","containerName":"nof_overlaps","kind":13,"line":383}],"line":375,"definition":"sub","containerName":"main::","signature":{"label":"nof_overlaps($self,$nof_overlaps)","parameters":[{"label":"$self"},{"label":"$nof_overlaps"}],"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]"},"detail":"($self,$nof_overlaps)"},{"signature":{"label":"min_overlap($self,$min_overlap)","documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]","parameters":[{"label":"$self"},{"label":"$min_overlap"}]},"detail":"($self,$min_overlap)","definition":"sub","containerName":"main::","children":[{"line":398,"kind":13,"localvar":"my","containerName":"min_overlap","name":"$self","definition":"my"},{"name":"$min_overlap","containerName":"min_overlap","line":398,"kind":13},{"containerName":"min_overlap","name":"$min_overlap","line":399,"kind":13},{"line":400,"kind":13,"name":"$self","containerName":"min_overlap"},{"containerName":"min_overlap","name":"throw","line":400,"kind":12},{"containerName":"min_overlap","name":"$min_overlap","kind":13,"line":401},{"containerName":"min_overlap","name":"$self","kind":13,"line":402},{"kind":13,"line":402,"containerName":"min_overlap","name":"$min_overlap"},{"line":404,"kind":13,"containerName":"min_overlap","name":"$min_overlap"},{"containerName":"min_overlap","name":"$self","kind":13,"line":404},{"line":405,"kind":13,"containerName":"min_overlap","name":"$min_overlap"}],"line":397,"kind":12,"range":{"start":{"line":397,"character":0},"end":{"character":9999,"line":406}},"name":"min_overlap"},{"name":"avg_overlap","range":{"start":{"line":419,"character":0},"end":{"line":428,"character":9999}},"kind":12,"children":[{"kind":13,"line":420,"containerName":"avg_overlap","definition":"my","name":"$self","localvar":"my"},{"name":"$avg_overlap","containerName":"avg_overlap","kind":13,"line":420},{"name":"$avg_overlap","containerName":"avg_overlap","line":421,"kind":13},{"kind":13,"line":422,"containerName":"avg_overlap","name":"$self"},{"kind":12,"line":422,"name":"throw","containerName":"avg_overlap"},{"line":423,"kind":13,"name":"$avg_overlap","containerName":"avg_overlap"},{"kind":13,"line":424,"name":"$self","containerName":"avg_overlap"},{"containerName":"avg_overlap","name":"$avg_overlap","kind":13,"line":424},{"name":"$avg_overlap","containerName":"avg_overlap","kind":13,"line":426},{"name":"$self","containerName":"avg_overlap","line":426,"kind":13},{"kind":13,"line":427,"containerName":"avg_overlap","name":"$avg_overlap"}],"line":419,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$avg_overlap"}],"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]","label":"avg_overlap($self,$avg_overlap)"},"detail":"($self,$avg_overlap)"},{"name":"min_identity","range":{"end":{"line":450,"character":9999},"start":{"character":0,"line":441}},"kind":12,"line":441,"children":[{"containerName":"min_identity","definition":"my","name":"$self","localvar":"my","kind":13,"line":442},{"line":442,"kind":13,"containerName":"min_identity","name":"$min_identity"},{"name":"$min_identity","containerName":"min_identity","line":443,"kind":13},{"line":444,"kind":13,"name":"$self","containerName":"min_identity"},{"kind":12,"line":444,"name":"throw","containerName":"min_identity"},{"containerName":"min_identity","name":"$min_identity","kind":13,"line":445},{"name":"$self","containerName":"min_identity","kind":13,"line":446},{"name":"$min_identity","containerName":"min_identity","line":446,"kind":13},{"containerName":"min_identity","name":"$min_identity","kind":13,"line":448},{"name":"$self","containerName":"min_identity","line":448,"kind":13},{"name":"$min_identity","containerName":"min_identity","kind":13,"line":449}],"containerName":"main::","definition":"sub","detail":"($self,$min_identity)","signature":{"label":"min_identity($self,$min_identity)","parameters":[{"label":"$self"},{"label":"$min_identity"}],"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]"}},{"detail":"($self,$avg_identity)","signature":{"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]","parameters":[{"label":"$self"},{"label":"$avg_identity"}],"label":"avg_identity($self,$avg_identity)"},"containerName":"main::","definition":"sub","line":463,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"avg_identity","line":464,"kind":13},{"line":464,"kind":13,"name":"$avg_identity","containerName":"avg_identity"},{"kind":13,"line":465,"containerName":"avg_identity","name":"$avg_identity"},{"kind":13,"line":466,"containerName":"avg_identity","name":"$self"},{"line":466,"kind":12,"name":"throw","containerName":"avg_identity"},{"kind":13,"line":467,"containerName":"avg_identity","name":"$avg_identity"},{"kind":13,"line":468,"name":"$self","containerName":"avg_identity"},{"containerName":"avg_identity","name":"$avg_identity","line":468,"kind":13},{"name":"$avg_identity","containerName":"avg_identity","kind":13,"line":470},{"containerName":"avg_identity","name":"$self","kind":13,"line":470},{"containerName":"avg_identity","name":"$avg_identity","kind":13,"line":471}],"kind":12,"range":{"end":{"line":472,"character":9999},"start":{"line":463,"character":0}},"name":"avg_identity"},{"line":485,"children":[{"kind":13,"line":486,"containerName":"avg_seq_len","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":486,"containerName":"avg_seq_len","name":"$avg_seq_len"},{"name":"$avg_seq_len","containerName":"avg_seq_len","line":487,"kind":13},{"containerName":"avg_seq_len","name":"$self","line":488,"kind":13},{"kind":12,"line":488,"name":"throw","containerName":"avg_seq_len"},{"kind":13,"line":489,"containerName":"avg_seq_len","name":"$avg_seq_len"},{"name":"$self","containerName":"avg_seq_len","line":490,"kind":13},{"kind":13,"line":490,"name":"$avg_seq_len","containerName":"avg_seq_len"},{"kind":13,"line":492,"containerName":"avg_seq_len","name":"$avg_seq_len"},{"containerName":"avg_seq_len","name":"$self","line":492,"kind":13},{"containerName":"avg_seq_len","name":"$avg_seq_len","kind":13,"line":493}],"kind":12,"detail":"($self,$avg_seq_len)","signature":{"label":"avg_seq_len($self,$avg_seq_len)","documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]","parameters":[{"label":"$self"},{"label":"$avg_seq_len"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":485},"end":{"character":9999,"line":494}},"name":"avg_seq_len"},{"range":{"start":{"line":512,"character":0},"end":{"line":521,"character":9999}},"name":"eff_asm_params","signature":{"label":"eff_asm_params($self,$eff_asm_params)","documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]","parameters":[{"label":"$self"},{"label":"$eff_asm_params"}]},"detail":"($self,$eff_asm_params)","definition":"sub","containerName":"main::","children":[{"line":513,"kind":13,"localvar":"my","containerName":"eff_asm_params","definition":"my","name":"$self"},{"name":"$eff_asm_params","containerName":"eff_asm_params","line":513,"kind":13},{"kind":13,"line":514,"containerName":"eff_asm_params","name":"$eff_asm_params"},{"line":515,"kind":13,"containerName":"eff_asm_params","name":"$self"},{"name":"throw","containerName":"eff_asm_params","kind":12,"line":515},{"name":"$eff_asm_params","containerName":"eff_asm_params","line":516,"kind":13},{"name":"$eff_asm_params","containerName":"eff_asm_params","line":516,"kind":13},{"containerName":"eff_asm_params","name":"$self","line":517,"kind":13},{"line":517,"kind":13,"containerName":"eff_asm_params","name":"$eff_asm_params"},{"line":519,"kind":13,"name":"$eff_asm_params","containerName":"eff_asm_params"},{"containerName":"eff_asm_params","name":"$self","kind":13,"line":519},{"kind":13,"line":520,"name":"$eff_asm_params","containerName":"eff_asm_params"}],"line":512,"kind":12},{"kind":12,"children":[{"localvar":"my","containerName":"spectrum","definition":"my","name":"$self","line":540,"kind":13},{"line":540,"kind":13,"name":"$spectrum","containerName":"spectrum"},{"name":"$spectrum","containerName":"spectrum","line":541,"kind":13},{"line":542,"kind":13,"containerName":"spectrum","name":"$self"},{"line":542,"kind":12,"name":"_import_spectrum","containerName":"spectrum"},{"line":542,"kind":13,"containerName":"spectrum","name":"$spectrum"},{"containerName":"spectrum","name":"$spectrum","line":544,"kind":13},{"name":"$self","containerName":"spectrum","line":544,"kind":13},{"line":545,"kind":13,"name":"$spectrum","containerName":"spectrum"}],"line":539,"definition":"sub","containerName":"main::","signature":{"label":"spectrum($self,$spectrum)","documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]","parameters":[{"label":"$self"},{"label":"$spectrum"}]},"detail":"($self,$spectrum)","name":"spectrum","range":{"end":{"line":546,"character":9999},"start":{"line":539,"character":0}}},{"name":"assembly","range":{"end":{"character":9999,"line":566},"start":{"line":561,"character":0}},"kind":12,"line":561,"children":[{"containerName":"assembly","definition":"my","name":"$self","localvar":"my","kind":13,"line":562},{"name":"$assembly","containerName":"assembly","line":562,"kind":13},{"containerName":"assembly","name":"$assembly","line":563,"kind":13},{"containerName":"assembly","name":"$self","kind":13,"line":564},{"name":"_import_assembly","containerName":"assembly","kind":12,"line":564},{"kind":13,"line":564,"containerName":"assembly","name":"$assembly"},{"localvar":"my","name":"@asm_list","definition":"my","containerName":"assembly","line":566,"kind":13},{"name":"$self","containerName":"assembly","kind":13,"line":566}],"containerName":"main::","definition":"sub","detail":"($self,$assembly)","signature":{"label":"assembly($self,$assembly)","parameters":[{"label":"$self"},{"label":"$assembly"}],"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold"}},{"line":566,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":567,"containerName":null,"name":"@asm_list"},{"line":582,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"drop_assembly","line":583,"kind":13},{"line":584,"kind":13,"name":"$self","containerName":"drop_assembly"}],"kind":12,"detail":"($self)","signature":{"label":"drop_assembly($self)","documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":582},"end":{"character":9999,"line":586}},"name":"drop_assembly"},{"name":"dissolve","range":{"end":{"character":9999,"line":610},"start":{"line":606,"character":0}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"dissolve","line":607,"kind":13},{"name":"$mixed_csp","containerName":"dissolve","line":607,"kind":13},{"kind":13,"line":607,"name":"$seq_header","containerName":"dissolve"},{"name":"$self","containerName":"dissolve","line":608,"kind":13},{"name":"_import_dissolved_csp","containerName":"dissolve","line":608,"kind":12},{"containerName":"dissolve","name":"$mixed_csp","kind":13,"line":608},{"line":608,"kind":13,"containerName":"dissolve","name":"$seq_header"}],"line":606,"definition":"sub","containerName":"main::","signature":{"label":"dissolve($self,$mixed_csp,$seq_header)","parameters":[{"label":"$self"},{"label":"$mixed_csp"},{"label":"$seq_header"}],"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none\n\n\nsub drop_assembly {\n  my ($self) = @_;\n  $self->{'_assembly'} = [];\n  return 1;\n}\n\n=head2 dissolve\n\n  Title   : dissolve\n  Usage   : $dissolved_csp->dissolve($mixed_csp, $seq_header);\n  Function: Dissolve a mixed contig spectrum for the set of sequences that\n            contain the specified header, i.e. determine the contribution of\n            these sequences to the mixed contig spectrum based on the assembly.\n            The mixed contig spectrum object must have been created based on one\n            (or several) assembly object(s). Additionally, min_overlap and\n            min_identity must have been set (either manually using min_overlap\n            or automatically by switching on the eff_asm_params option).\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n            sequence header string"},"detail":"($self,$mixed_csp,$seq_header)"},{"detail":"($self,$mixed_csp)","signature":{"label":"cross($self,$mixed_csp)","parameters":[{"label":"$self"},{"label":"$mixed_csp"}],"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none\n\n\nsub drop_assembly {\n  my ($self) = @_;\n  $self->{'_assembly'} = [];\n  return 1;\n}\n\n=head2 dissolve\n\n  Title   : dissolve\n  Usage   : $dissolved_csp->dissolve($mixed_csp, $seq_header);\n  Function: Dissolve a mixed contig spectrum for the set of sequences that\n            contain the specified header, i.e. determine the contribution of\n            these sequences to the mixed contig spectrum based on the assembly.\n            The mixed contig spectrum object must have been created based on one\n            (or several) assembly object(s). Additionally, min_overlap and\n            min_identity must have been set (either manually using min_overlap\n            or automatically by switching on the eff_asm_params option).\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n            sequence header string\n\n\n\nsub dissolve {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  $self->_import_dissolved_csp($mixed_csp, $seq_header);\n  return 1;\n}\n\n\n=head2 cross\n\n  Title   : cross\n  Usage   : $cross_csp->cross($mixed_csp);\n  Function: Calculate a cross contig_spectrum based on a mixed contig_spectrum.\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference"},"containerName":"main::","definition":"sub","line":623,"children":[{"localvar":"my","containerName":"cross","name":"$self","definition":"my","line":624,"kind":13},{"containerName":"cross","name":"$mixed_csp","line":624,"kind":13},{"line":625,"kind":13,"name":"$self","containerName":"cross"},{"line":625,"kind":12,"containerName":"cross","name":"_import_cross_csp"},{"kind":13,"line":625,"name":"$mixed_csp","containerName":"cross"}],"kind":12,"range":{"start":{"line":623,"character":0},"end":{"line":627,"character":9999}},"name":"cross"},{"kind":12,"line":642,"children":[{"kind":13,"line":643,"name":"$self","definition":"my","containerName":"to_string","localvar":"my"},{"name":"$element_separator","containerName":"to_string","line":643,"kind":13},{"name":"$self","containerName":"to_string","kind":13,"line":644},{"kind":13,"line":645,"containerName":"to_string","name":"$element_separator"},{"kind":13,"line":646,"containerName":"to_string","name":"$element_separator"},{"name":"$element_separator","containerName":"to_string","line":647,"kind":13},{"line":648,"kind":13,"containerName":"to_string","name":"$element_separator"},{"name":"$element_separator","containerName":"to_string","line":649,"kind":13},{"containerName":"to_string","name":"$element_separator","line":650,"kind":13},{"line":651,"kind":13,"name":"$element_separator","containerName":"to_string"},{"kind":13,"line":653,"containerName":"to_string","name":"$self"},{"line":653,"kind":12,"containerName":"to_string","name":"throw"},{"kind":13,"line":655,"definition":"my","name":"$str","containerName":"to_string","localvar":"my"},{"line":656,"kind":13,"localvar":"my","containerName":"to_string","name":"$q","definition":"my"},{"kind":13,"line":656,"containerName":"to_string","name":"$q"},{"name":"$self","containerName":"to_string","line":656,"kind":13},{"kind":13,"line":656,"name":"$q","containerName":"to_string"},{"kind":13,"line":657,"definition":"my","name":"$val","containerName":"to_string","localvar":"my"},{"containerName":"to_string","name":"$self","line":658,"kind":13},{"name":"$q","containerName":"to_string","line":658,"kind":13},{"kind":13,"line":659,"containerName":"to_string","name":"$val"},{"line":659,"kind":13,"containerName":"to_string","name":"$self"},{"name":"$q","containerName":"to_string","kind":13,"line":659},{"containerName":"to_string","name":"$str","kind":13,"line":661},{"line":661,"kind":13,"name":"$val","containerName":"to_string"},{"kind":13,"line":661,"name":"$element_separator","containerName":"to_string"},{"kind":13,"line":663,"containerName":"to_string","name":"$str"},{"line":664,"kind":13,"name":"$str","containerName":"to_string"}],"containerName":"main::","definition":"sub","detail":"($self,$element_separator)","signature":{"label":"to_string($self,$element_separator)","documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none\n\n\nsub drop_assembly {\n  my ($self) = @_;\n  $self->{'_assembly'} = [];\n  return 1;\n}\n\n=head2 dissolve\n\n  Title   : dissolve\n  Usage   : $dissolved_csp->dissolve($mixed_csp, $seq_header);\n  Function: Dissolve a mixed contig spectrum for the set of sequences that\n            contain the specified header, i.e. determine the contribution of\n            these sequences to the mixed contig spectrum based on the assembly.\n            The mixed contig spectrum object must have been created based on one\n            (or several) assembly object(s). Additionally, min_overlap and\n            min_identity must have been set (either manually using min_overlap\n            or automatically by switching on the eff_asm_params option).\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n            sequence header string\n\n\n\nsub dissolve {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  $self->_import_dissolved_csp($mixed_csp, $seq_header);\n  return 1;\n}\n\n\n=head2 cross\n\n  Title   : cross\n  Usage   : $cross_csp->cross($mixed_csp);\n  Function: Calculate a cross contig_spectrum based on a mixed contig_spectrum.\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n\n\nsub cross {\n  my ($self, $mixed_csp) = @_;\n  $self->_import_cross_csp($mixed_csp);\n  return 1;\n}\n\n=head2 to_string\n\n  Title   : to_string\n  Usage   : my $csp_string = $csp->to_string;\n  Function: Convert the contig spectrum into a string (easy to print!!).\n  Returns : string\n  Args    : element separator (integer) [optional]\n              1 -> space-separated\n              2 -> tab-separated\n              3 -> newline-separated","parameters":[{"label":"$self"},{"label":"$element_separator"}]},"name":"to_string","range":{"end":{"line":665,"character":9999},"start":{"line":642,"character":0}}},{"line":679,"children":[{"definition":"my","name":"$self","containerName":"add","localvar":"my","kind":13,"line":680},{"containerName":"add","name":"$csp","kind":13,"line":680},{"containerName":"add","name":"$csp","kind":13,"line":682},{"name":"$csp","containerName":"add","kind":13,"line":682},{"line":682,"kind":12,"name":"isa","containerName":"add"},{"containerName":"add","name":"$self","kind":13,"line":683},{"name":"throw","containerName":"add","line":683,"kind":12},{"containerName":"add","name":"$csp","kind":13,"line":684},{"kind":13,"line":687,"containerName":"add","name":"$self"},{"name":"$csp","containerName":"add","line":689,"kind":13},{"containerName":"add","name":"$self","line":690,"kind":13},{"line":690,"kind":12,"containerName":"add","name":"warn"},{"line":691,"kind":13,"containerName":"add","name":"$self"},{"containerName":"add","name":"$csp","line":693,"kind":13},{"containerName":"add","name":"$csp","kind":13,"line":694},{"line":694,"kind":13,"name":"$self","containerName":"add"},{"name":"$self","containerName":"add","kind":13,"line":695},{"name":"warn","containerName":"add","line":695,"kind":12},{"name":"$self","containerName":"add","kind":13,"line":697},{"name":"$csp","containerName":"add","kind":13,"line":698},{"kind":13,"line":702,"name":"$tot_num_overlaps","definition":"my","containerName":"add","localvar":"my"},{"line":702,"kind":13,"containerName":"add","name":"$csp"},{"kind":13,"line":702,"name":"$self","containerName":"add"},{"name":"$self","containerName":"add","kind":13,"line":703},{"name":"$csp","containerName":"add","line":703,"kind":13},{"kind":13,"line":704,"name":"$csp","containerName":"add"},{"name":"$self","containerName":"add","line":704,"kind":13},{"kind":13,"line":705,"containerName":"add","name":"$csp"},{"line":705,"kind":13,"name":"$self","containerName":"add"},{"kind":13,"line":706,"containerName":"add","name":"$self"},{"line":706,"kind":13,"name":"$csp","containerName":"add"},{"line":707,"kind":13,"name":"$csp","containerName":"add"},{"line":707,"kind":13,"containerName":"add","name":"$self"},{"containerName":"add","name":"$csp","kind":13,"line":708},{"kind":13,"line":708,"name":"$self","containerName":"add"},{"containerName":"add","name":"$tot_num_overlaps","line":709,"kind":13},{"containerName":"add","name":"$self","line":710,"kind":13},{"containerName":"add","name":"$csp","kind":13,"line":711},{"kind":13,"line":711,"containerName":"add","name":"$csp"},{"line":712,"kind":13,"containerName":"add","name":"$self"},{"containerName":"add","name":"$self","kind":13,"line":712},{"kind":13,"line":713,"containerName":"add","name":"$tot_num_overlaps"},{"kind":13,"line":714,"containerName":"add","name":"$self"},{"kind":13,"line":715,"name":"$csp","containerName":"add"},{"containerName":"add","name":"$csp","line":715,"kind":13},{"kind":13,"line":716,"name":"$self","containerName":"add"},{"name":"$self","containerName":"add","line":716,"kind":13},{"kind":13,"line":717,"containerName":"add","name":"$tot_num_overlaps"},{"containerName":"add","name":"$self","kind":13,"line":719},{"line":719,"kind":13,"name":"$tot_num_overlaps","containerName":"add"},{"line":722,"kind":13,"localvar":"my","containerName":"add","definition":"my","name":"$tot_nof_seq"},{"line":722,"kind":13,"containerName":"add","name":"$csp"},{"kind":13,"line":722,"name":"$self","containerName":"add"},{"containerName":"add","name":"$tot_nof_seq","line":723,"kind":13},{"name":"$self","containerName":"add","line":724,"kind":13},{"name":"$csp","containerName":"add","kind":13,"line":724},{"kind":13,"line":724,"name":"$csp","containerName":"add"},{"kind":13,"line":725,"name":"$self","containerName":"add"},{"kind":13,"line":725,"name":"$self","containerName":"add"},{"containerName":"add","name":"$tot_nof_seq","kind":13,"line":725},{"containerName":"add","name":"$self","line":728,"kind":13},{"containerName":"add","name":"_import_spectrum","line":728,"kind":12},{"kind":13,"line":728,"name":"$csp","containerName":"add"},{"kind":13,"line":730,"name":"$self","containerName":"add"},{"kind":13,"line":731,"name":"$self","containerName":"add"},{"kind":13,"line":731,"name":"$csp","containerName":"add"},{"name":"$self","containerName":"add","kind":13,"line":733}],"kind":12,"detail":"($self,$csp)","signature":{"parameters":[{"label":"$self"},{"label":"$csp"}],"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none\n\n\nsub drop_assembly {\n  my ($self) = @_;\n  $self->{'_assembly'} = [];\n  return 1;\n}\n\n=head2 dissolve\n\n  Title   : dissolve\n  Usage   : $dissolved_csp->dissolve($mixed_csp, $seq_header);\n  Function: Dissolve a mixed contig spectrum for the set of sequences that\n            contain the specified header, i.e. determine the contribution of\n            these sequences to the mixed contig spectrum based on the assembly.\n            The mixed contig spectrum object must have been created based on one\n            (or several) assembly object(s). Additionally, min_overlap and\n            min_identity must have been set (either manually using min_overlap\n            or automatically by switching on the eff_asm_params option).\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n            sequence header string\n\n\n\nsub dissolve {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  $self->_import_dissolved_csp($mixed_csp, $seq_header);\n  return 1;\n}\n\n\n=head2 cross\n\n  Title   : cross\n  Usage   : $cross_csp->cross($mixed_csp);\n  Function: Calculate a cross contig_spectrum based on a mixed contig_spectrum.\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n\n\nsub cross {\n  my ($self, $mixed_csp) = @_;\n  $self->_import_cross_csp($mixed_csp);\n  return 1;\n}\n\n=head2 to_string\n\n  Title   : to_string\n  Usage   : my $csp_string = $csp->to_string;\n  Function: Convert the contig spectrum into a string (easy to print!!).\n  Returns : string\n  Args    : element separator (integer) [optional]\n              1 -> space-separated\n              2 -> tab-separated\n              3 -> newline-separated\n\n\nsub to_string {\n  my ($self, $element_separator) = @_;\n  return 0 if $self->{'_max_size'} == 0;\n  $element_separator ||= 1;\n  if ($element_separator == 1) {\n    $element_separator = ' ';\n  } elsif ($element_separator == 2) {\n    $element_separator = \"\\t\";\n  } elsif ($element_separator == 3) {\n    $element_separator = \"\\n\";\n  } else {\n    $self->throw(\"Unknown separator type '$element_separator'\\n\");\n  }\n  my $str = '';\n  for (my $q = 1 ; $q <= $self->{'_max_size'} ; $q++) {\n    my $val = 0;\n    if (exists $self->{'_spectrum'}{$q}) {\n      $val = $self->{'_spectrum'}{$q};\n    }\n    $str .= $val.$element_separator;\n  }\n  $str =~ s/\\s$//;\n  return $str;\n}\n\n\n=head2 add\n\n  Title   : add\n  Usage   : $csp->add($additional_csp);\n  Function: Add a contig spectrum to an existing one: sums the spectra, update\n            the number of sequences, number of repetitions, ...\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum object","label":"add($self,$csp)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":679},"end":{"line":733,"character":9999}},"name":"add"},{"containerName":null,"name":"%csp","line":733,"kind":13},{"kind":13,"line":734,"containerName":null,"name":"%csp"},{"range":{"start":{"character":0,"line":751},"end":{"line":784,"character":9999}},"name":"average","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"average","line":752,"kind":13},{"kind":13,"line":752,"name":"$list","containerName":"average"},{"line":754,"kind":13,"name":"$list","containerName":"average"},{"kind":13,"line":754,"name":"$list","containerName":"average"},{"name":"$self","containerName":"average","line":755,"kind":13},{"containerName":"average","name":"throw","line":755,"kind":12},{"kind":13,"line":755,"containerName":"average","name":"$list"},{"localvar":"my","containerName":"average","definition":"my","name":"$avg","line":758,"kind":13},{"kind":12,"line":758,"name":"new","containerName":"average"},{"name":"$avg","containerName":"average","kind":13,"line":759},{"definition":"my","name":"$tot_nof_rep","containerName":"average","localvar":"my","kind":13,"line":762},{"localvar":"my","name":"$csp","definition":"my","containerName":"average","line":763,"kind":13},{"name":"$list","containerName":"average","line":763,"kind":13},{"line":765,"kind":13,"containerName":"average","name":"$csp"},{"line":765,"kind":12,"name":"isa","containerName":"average"},{"kind":13,"line":766,"containerName":"average","name":"$csp"},{"kind":12,"line":766,"name":"throw","containerName":"average"},{"kind":13,"line":767,"name":"$csp","containerName":"average"},{"line":770,"kind":13,"name":"$avg","containerName":"average"},{"line":770,"kind":12,"name":"add","containerName":"average"},{"name":"$csp","containerName":"average","kind":13,"line":770},{"line":774,"kind":13,"localvar":"my","definition":"my","name":"$q","containerName":"average"},{"name":"$q","containerName":"average","line":774,"kind":13},{"containerName":"average","name":"$avg","line":774,"kind":13},{"containerName":"average","name":"$q","line":774,"kind":13},{"containerName":"average","name":"$avg","line":775,"kind":13},{"line":775,"kind":13,"name":"$q","containerName":"average"},{"kind":13,"line":775,"name":"$avg","containerName":"average"},{"kind":13,"line":776,"name":"$avg","containerName":"average"},{"kind":13,"line":776,"containerName":"average","name":"$q"},{"containerName":"average","name":"$avg","line":779,"kind":13},{"name":"$avg","containerName":"average","kind":13,"line":779},{"name":"$avg","containerName":"average","line":781,"kind":13},{"kind":13,"line":781,"containerName":"average","name":"$avg"},{"name":"$avg","containerName":"average","line":783,"kind":13}],"line":751,"kind":12,"signature":{"label":"average($self,$list)","documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none\n\n\nsub drop_assembly {\n  my ($self) = @_;\n  $self->{'_assembly'} = [];\n  return 1;\n}\n\n=head2 dissolve\n\n  Title   : dissolve\n  Usage   : $dissolved_csp->dissolve($mixed_csp, $seq_header);\n  Function: Dissolve a mixed contig spectrum for the set of sequences that\n            contain the specified header, i.e. determine the contribution of\n            these sequences to the mixed contig spectrum based on the assembly.\n            The mixed contig spectrum object must have been created based on one\n            (or several) assembly object(s). Additionally, min_overlap and\n            min_identity must have been set (either manually using min_overlap\n            or automatically by switching on the eff_asm_params option).\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n            sequence header string\n\n\n\nsub dissolve {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  $self->_import_dissolved_csp($mixed_csp, $seq_header);\n  return 1;\n}\n\n\n=head2 cross\n\n  Title   : cross\n  Usage   : $cross_csp->cross($mixed_csp);\n  Function: Calculate a cross contig_spectrum based on a mixed contig_spectrum.\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n\n\nsub cross {\n  my ($self, $mixed_csp) = @_;\n  $self->_import_cross_csp($mixed_csp);\n  return 1;\n}\n\n=head2 to_string\n\n  Title   : to_string\n  Usage   : my $csp_string = $csp->to_string;\n  Function: Convert the contig spectrum into a string (easy to print!!).\n  Returns : string\n  Args    : element separator (integer) [optional]\n              1 -> space-separated\n              2 -> tab-separated\n              3 -> newline-separated\n\n\nsub to_string {\n  my ($self, $element_separator) = @_;\n  return 0 if $self->{'_max_size'} == 0;\n  $element_separator ||= 1;\n  if ($element_separator == 1) {\n    $element_separator = ' ';\n  } elsif ($element_separator == 2) {\n    $element_separator = \"\\t\";\n  } elsif ($element_separator == 3) {\n    $element_separator = \"\\n\";\n  } else {\n    $self->throw(\"Unknown separator type '$element_separator'\\n\");\n  }\n  my $str = '';\n  for (my $q = 1 ; $q <= $self->{'_max_size'} ; $q++) {\n    my $val = 0;\n    if (exists $self->{'_spectrum'}{$q}) {\n      $val = $self->{'_spectrum'}{$q};\n    }\n    $str .= $val.$element_separator;\n  }\n  $str =~ s/\\s$//;\n  return $str;\n}\n\n\n=head2 add\n\n  Title   : add\n  Usage   : $csp->add($additional_csp);\n  Function: Add a contig spectrum to an existing one: sums the spectra, update\n            the number of sequences, number of repetitions, ...\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum object\n\n\nsub add {\n  my ($self, $csp) = @_;\n  # Sanity check\n  if( !ref $csp || ! $csp->isa('Bio::Assembly::Tools::ContigSpectrum') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n  }\n  # Update overlap statistics\n  if ( $self->{'_eff_asm_params'} > 0 ) {\n    # Warnings\n    if ( $csp->{'_eff_asm_params'} == 0 ) {\n      $self->warn(\"The parent contig spectrum needs effective assembly \".\n        \"parameters (eff_asm_params = \".$self->{'_eff_asm_params'}.\") but the \".\n        \"child contig spectrum doesn't have them (eff_asm_params = \".\n        $csp->{'_eff_asm_params'}.\"). Skipping them...\");\n    } elsif ( $csp->{'_eff_asm_params'} != $self->{'_eff_asm_params'} ) {\n      $self->warn(\"The parent contig spectrum needs a different method for \".\n        \"detecting the effective assembly parameters (eff_asm_params = \".\n        $self->{'_eff_asm_params'}.\") than the one specified for the child \".\n        \"contig spectrum (eff_asm_params = \".$csp->{'_eff_asm_params'}.\"). \".\n        \"Ignoring the differences...\");\n    }\n    # Update existing stats\n    my $tot_num_overlaps = $csp->{'_nof_overlaps'} + $self->{'_nof_overlaps'};\n    $self->{'_min_overlap'} = $csp->{'_min_overlap'} if\n      defined $csp->{'_min_overlap'} && ( ! defined $self->{'_min_overlap'} ||\n      $csp->{'_min_overlap'} < $self->{'_min_overlap'} );\n    $self->{'_min_identity'} = $csp->{'_min_identity'} if\n      defined $csp->{'_min_identity'} && ( ! defined $self->{'_min_identity'} ||\n      $csp->{'_min_identity'} < $self->{'_min_identity'} );\n    if ($tot_num_overlaps != 0) {\n      $self->{'_avg_overlap'} =\n        ($csp->{'_avg_overlap'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_overlap'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n      $self->{'_avg_identity'} =\n        ($csp->{'_avg_identity'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_identity'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n    }\n    $self->{'_nof_overlaps'} = $tot_num_overlaps;\n  }\n  # Update sequence statistics\n  my $tot_nof_seq = $csp->{'_nof_seq'} + $self->{'_nof_seq'};\n  if (not $tot_nof_seq == 0) {\n    $self->{'_avg_seq_len'} = ($csp->{'_avg_seq_len'} * $csp->{'_nof_seq'} +\n      $self->{'_avg_seq_len'} * $self->{'_nof_seq'}) / $tot_nof_seq;\n  }\n  # Update spectrum (and nof_seq, max_size, and increment nof_rep by 1)\n  $self->_import_spectrum($csp->{'_spectrum'});\n  # Update nof_rep\n  $self->{'_nof_rep'}--;\n  $self->{'_nof_rep'} += $csp->{'_nof_rep'};\n  # Update list of assembly objects used\n  push @{$self->{'_assembly'}}, @{$csp->{'_assembly'}}\n    if defined $csp->{'_assembly'};\n  return 1;\n}\n\n\n=head2 average\n\n  Title   : average\n  Usage   : my $avg_csp = $csp->average([$csp1, $csp2, $csp3]);\n  Function: Average one contig spectrum or the sum of several contig spectra by\n            the number of repetitions\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Tools::ContigSpectrum array reference\n            eff_asm_params","parameters":[{"label":"$self"},{"label":"$list"}]},"detail":"($self,$list)","definition":"sub","containerName":"main::"},{"containerName":"Assembly::Tools::ContigSpectrum","name":"Bio","line":758,"kind":12},{"name":"score","range":{"end":{"character":9999,"line":833},"start":{"line":807,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$nof_seqs)","signature":{"parameters":[{"label":"$self"},{"label":"$nof_seqs"}],"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none\n\n\nsub drop_assembly {\n  my ($self) = @_;\n  $self->{'_assembly'} = [];\n  return 1;\n}\n\n=head2 dissolve\n\n  Title   : dissolve\n  Usage   : $dissolved_csp->dissolve($mixed_csp, $seq_header);\n  Function: Dissolve a mixed contig spectrum for the set of sequences that\n            contain the specified header, i.e. determine the contribution of\n            these sequences to the mixed contig spectrum based on the assembly.\n            The mixed contig spectrum object must have been created based on one\n            (or several) assembly object(s). Additionally, min_overlap and\n            min_identity must have been set (either manually using min_overlap\n            or automatically by switching on the eff_asm_params option).\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n            sequence header string\n\n\n\nsub dissolve {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  $self->_import_dissolved_csp($mixed_csp, $seq_header);\n  return 1;\n}\n\n\n=head2 cross\n\n  Title   : cross\n  Usage   : $cross_csp->cross($mixed_csp);\n  Function: Calculate a cross contig_spectrum based on a mixed contig_spectrum.\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n\n\nsub cross {\n  my ($self, $mixed_csp) = @_;\n  $self->_import_cross_csp($mixed_csp);\n  return 1;\n}\n\n=head2 to_string\n\n  Title   : to_string\n  Usage   : my $csp_string = $csp->to_string;\n  Function: Convert the contig spectrum into a string (easy to print!!).\n  Returns : string\n  Args    : element separator (integer) [optional]\n              1 -> space-separated\n              2 -> tab-separated\n              3 -> newline-separated\n\n\nsub to_string {\n  my ($self, $element_separator) = @_;\n  return 0 if $self->{'_max_size'} == 0;\n  $element_separator ||= 1;\n  if ($element_separator == 1) {\n    $element_separator = ' ';\n  } elsif ($element_separator == 2) {\n    $element_separator = \"\\t\";\n  } elsif ($element_separator == 3) {\n    $element_separator = \"\\n\";\n  } else {\n    $self->throw(\"Unknown separator type '$element_separator'\\n\");\n  }\n  my $str = '';\n  for (my $q = 1 ; $q <= $self->{'_max_size'} ; $q++) {\n    my $val = 0;\n    if (exists $self->{'_spectrum'}{$q}) {\n      $val = $self->{'_spectrum'}{$q};\n    }\n    $str .= $val.$element_separator;\n  }\n  $str =~ s/\\s$//;\n  return $str;\n}\n\n\n=head2 add\n\n  Title   : add\n  Usage   : $csp->add($additional_csp);\n  Function: Add a contig spectrum to an existing one: sums the spectra, update\n            the number of sequences, number of repetitions, ...\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum object\n\n\nsub add {\n  my ($self, $csp) = @_;\n  # Sanity check\n  if( !ref $csp || ! $csp->isa('Bio::Assembly::Tools::ContigSpectrum') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n  }\n  # Update overlap statistics\n  if ( $self->{'_eff_asm_params'} > 0 ) {\n    # Warnings\n    if ( $csp->{'_eff_asm_params'} == 0 ) {\n      $self->warn(\"The parent contig spectrum needs effective assembly \".\n        \"parameters (eff_asm_params = \".$self->{'_eff_asm_params'}.\") but the \".\n        \"child contig spectrum doesn't have them (eff_asm_params = \".\n        $csp->{'_eff_asm_params'}.\"). Skipping them...\");\n    } elsif ( $csp->{'_eff_asm_params'} != $self->{'_eff_asm_params'} ) {\n      $self->warn(\"The parent contig spectrum needs a different method for \".\n        \"detecting the effective assembly parameters (eff_asm_params = \".\n        $self->{'_eff_asm_params'}.\") than the one specified for the child \".\n        \"contig spectrum (eff_asm_params = \".$csp->{'_eff_asm_params'}.\"). \".\n        \"Ignoring the differences...\");\n    }\n    # Update existing stats\n    my $tot_num_overlaps = $csp->{'_nof_overlaps'} + $self->{'_nof_overlaps'};\n    $self->{'_min_overlap'} = $csp->{'_min_overlap'} if\n      defined $csp->{'_min_overlap'} && ( ! defined $self->{'_min_overlap'} ||\n      $csp->{'_min_overlap'} < $self->{'_min_overlap'} );\n    $self->{'_min_identity'} = $csp->{'_min_identity'} if\n      defined $csp->{'_min_identity'} && ( ! defined $self->{'_min_identity'} ||\n      $csp->{'_min_identity'} < $self->{'_min_identity'} );\n    if ($tot_num_overlaps != 0) {\n      $self->{'_avg_overlap'} =\n        ($csp->{'_avg_overlap'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_overlap'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n      $self->{'_avg_identity'} =\n        ($csp->{'_avg_identity'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_identity'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n    }\n    $self->{'_nof_overlaps'} = $tot_num_overlaps;\n  }\n  # Update sequence statistics\n  my $tot_nof_seq = $csp->{'_nof_seq'} + $self->{'_nof_seq'};\n  if (not $tot_nof_seq == 0) {\n    $self->{'_avg_seq_len'} = ($csp->{'_avg_seq_len'} * $csp->{'_nof_seq'} +\n      $self->{'_avg_seq_len'} * $self->{'_nof_seq'}) / $tot_nof_seq;\n  }\n  # Update spectrum (and nof_seq, max_size, and increment nof_rep by 1)\n  $self->_import_spectrum($csp->{'_spectrum'});\n  # Update nof_rep\n  $self->{'_nof_rep'}--;\n  $self->{'_nof_rep'} += $csp->{'_nof_rep'};\n  # Update list of assembly objects used\n  push @{$self->{'_assembly'}}, @{$csp->{'_assembly'}}\n    if defined $csp->{'_assembly'};\n  return 1;\n}\n\n\n=head2 average\n\n  Title   : average\n  Usage   : my $avg_csp = $csp->average([$csp1, $csp2, $csp3]);\n  Function: Average one contig spectrum or the sum of several contig spectra by\n            the number of repetitions\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Tools::ContigSpectrum array reference\n            eff_asm_params\n\n\nsub average {\n  my ($self, $list) = @_;\n  # Sanity check\n  if ( ! ref $list || ! ref $list eq 'ARRAY') {\n    $self->throw(\"Average takes an array reference but got [\".ref($list).\"]\");\n  }\n  # New average contig spectrum object\n  my $avg = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg->{'_eff_asm_params'} = 1;\n  \n  # Cycle through contig spectra\n  my $tot_nof_rep = 0;\n  for my $csp (@$list) {\n    # Sanity check\n    if (not $csp->isa('Bio::Assembly::Tools::ContigSpectrum')) {\n      $csp->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n    }\n    # Import contig spectrum\n    $avg->add($csp);\n  }\n  \n  # Average sum of contig spectra by number of repetitions\n  for (my $q = 1 ; $q <= $avg->{'_max_size'} ; $q++) {\n    $avg->{'_spectrum'}{$q} /= $avg->{'_nof_rep'}\n      if (defined $avg->{'_spectrum'}{$q});\n  }\n  # Average number of sequences\n  $avg->{'_nof_seq'} /= $avg->{'_nof_rep'};\n  # Average number of overlaps\n  $avg->{'_nof_overlaps'} /= $avg->{'_nof_rep'};\n  \n  return $avg;\n}\n\n\n=head2 score\n\n  Title   : score\n  Usage   : my $score = $csp->score();\n  Function: Score a contig spectrum (or cross-contig spectrum) such that the\n             higher the number of contigs (or cross-contigs) and the larger their \n             size, the higher the score.\n             Let n   : total number of sequences\n                 c_q : number of contigs of size q\n                 q   : number of sequence in a contig\n             We define: score = n/(n-1) * (X - 1/n)\n                  where X = sum ( c_q * q^2 ) / n**2\n             The score ranges from 0 (singlets only) to 1 (a single large contig)\n             It is possible to specify a value for the number of sequences to\n              assume in the contig spectrum.\n  Returns : contig score\n  Args    : number of total sequences to assume [optional]","label":"score($self,$nof_seqs)"},"kind":12,"line":807,"children":[{"line":808,"kind":13,"localvar":"my","containerName":"score","name":"$self","definition":"my"},{"line":808,"kind":13,"containerName":"score","name":"$nof_seqs"},{"localvar":"my","name":"$score","definition":"my","containerName":"score","line":810,"kind":13},{"line":811,"kind":13,"localvar":"my","name":"$n","definition":"my","containerName":"score"},{"name":"$self","containerName":"score","line":811,"kind":13},{"containerName":"score","name":"nof_seq","line":811,"kind":12},{"containerName":"score","name":"$n","kind":13,"line":812},{"containerName":"score","name":"$q_max","definition":"my","localvar":"my","kind":13,"line":814},{"line":814,"kind":13,"containerName":"score","name":"$self"},{"containerName":"score","name":"max_size","kind":12,"line":814},{"line":815,"kind":13,"localvar":"my","name":"$spec","definition":"my","containerName":"score"},{"line":815,"kind":13,"name":"$self","containerName":"score"},{"containerName":"score","name":"spectrum","kind":12,"line":815},{"name":"$nof_seqs","containerName":"score","line":817,"kind":13},{"kind":13,"line":818,"name":"$spec","containerName":"score"},{"line":818,"kind":13,"name":"$nof_seqs","containerName":"score"},{"line":818,"kind":13,"name":"$n","containerName":"score"},{"name":"$n","containerName":"score","line":819,"kind":13},{"line":819,"kind":13,"containerName":"score","name":"$nof_seqs"},{"line":822,"kind":13,"localvar":"my","name":"$q","definition":"my","containerName":"score"},{"name":"$q_max","containerName":"score","line":822,"kind":13},{"kind":13,"line":823,"containerName":"score","name":"$spec"},{"line":823,"kind":13,"containerName":"score","name":"$q"},{"line":824,"kind":13,"localvar":"my","containerName":"score","name":"$c_q","definition":"my"},{"line":824,"kind":13,"name":"$spec","containerName":"score"},{"containerName":"score","name":"$q","kind":13,"line":824},{"kind":13,"line":825,"containerName":"score","name":"$score"},{"name":"$c_q","containerName":"score","line":825,"kind":13},{"containerName":"score","name":"$q","kind":13,"line":825},{"name":"$score","containerName":"score","kind":13,"line":828},{"line":828,"kind":13,"name":"$n","containerName":"score"},{"kind":13,"line":831,"name":"$score","containerName":"score"},{"kind":13,"line":831,"containerName":"score","name":"$n"},{"name":"$n","containerName":"score","kind":13,"line":831},{"name":"$score","containerName":"score","line":831,"kind":13},{"name":"$n","containerName":"score","line":831,"kind":13},{"containerName":"score","name":"$score","kind":13,"line":832}]},{"range":{"start":{"line":853,"character":0},"end":{"line":895,"character":9999}},"name":"_naive_assembler","children":[{"line":854,"kind":13,"localvar":"my","containerName":"_naive_assembler","definition":"my","name":"$self"},{"containerName":"_naive_assembler","name":"$contig","kind":13,"line":854},{"line":854,"kind":13,"name":"$seqlist","containerName":"_naive_assembler"},{"name":"$min_overlap","containerName":"_naive_assembler","line":854,"kind":13},{"kind":13,"line":854,"containerName":"_naive_assembler","name":"$min_identity"},{"containerName":"_naive_assembler","name":"$seqlist","line":856,"kind":13},{"line":856,"kind":13,"containerName":"_naive_assembler","name":"$seqlist"},{"kind":13,"line":857,"containerName":"_naive_assembler","name":"$self"},{"line":857,"kind":12,"name":"throw","containerName":"_naive_assembler"},{"containerName":"_naive_assembler","name":"$seqlist","kind":13,"line":857},{"kind":13,"line":859,"containerName":"_naive_assembler","name":"$max","definition":"my","localvar":"my"},{"name":"$seqlist","containerName":"_naive_assembler","kind":13,"line":859},{"kind":13,"line":860,"name":"$self","containerName":"_naive_assembler"},{"kind":12,"line":860,"name":"throw","containerName":"_naive_assembler"},{"line":861,"kind":13,"name":"$max","containerName":"_naive_assembler"},{"kind":13,"line":863,"definition":"my","name":"%spectrum","containerName":"_naive_assembler","localvar":"my"},{"containerName":"_naive_assembler","definition":"my","name":"%overlap_map","localvar":"my","kind":13,"line":864},{"line":865,"kind":13,"localvar":"my","definition":"my","name":"%has_overlap","containerName":"_naive_assembler"},{"kind":13,"line":867,"name":"$i","definition":"my","containerName":"_naive_assembler","localvar":"my"},{"containerName":"_naive_assembler","name":"$i","line":867,"kind":13},{"kind":13,"line":867,"name":"$max","containerName":"_naive_assembler"},{"containerName":"_naive_assembler","name":"$i","kind":13,"line":867},{"definition":"my","name":"$qseqid","containerName":"_naive_assembler","localvar":"my","kind":13,"line":869},{"kind":13,"line":869,"name":"$i","containerName":"_naive_assembler"},{"line":870,"kind":13,"localvar":"my","containerName":"_naive_assembler","name":"$qseq","definition":"my"},{"kind":13,"line":870,"containerName":"_naive_assembler","name":"$contig"},{"name":"get_seq_by_name","containerName":"_naive_assembler","line":870,"kind":12},{"line":870,"kind":13,"containerName":"_naive_assembler","name":"$qseqid"},{"containerName":"_naive_assembler","name":"$is_singlet","definition":"my","localvar":"my","kind":13,"line":871},{"kind":13,"line":872,"containerName":"_naive_assembler","definition":"my","name":"$j","localvar":"my"},{"name":"$i","containerName":"_naive_assembler","line":872,"kind":13},{"kind":13,"line":872,"containerName":"_naive_assembler","name":"$j"},{"name":"$max","containerName":"_naive_assembler","line":872,"kind":13},{"kind":13,"line":872,"name":"$j","containerName":"_naive_assembler"},{"kind":13,"line":874,"definition":"my","name":"$tseqid","containerName":"_naive_assembler","localvar":"my"},{"name":"$j","containerName":"_naive_assembler","line":874,"kind":13},{"localvar":"my","name":"$tseq","definition":"my","containerName":"_naive_assembler","line":875,"kind":13},{"containerName":"_naive_assembler","name":"$contig","kind":13,"line":875},{"kind":12,"line":875,"containerName":"_naive_assembler","name":"get_seq_by_name"},{"name":"$tseqid","containerName":"_naive_assembler","line":875,"kind":13},{"containerName":"_naive_assembler","definition":"my","name":"$aln","localvar":"my","kind":13,"line":877},{"line":877,"kind":13,"name":"$overlap","containerName":"_naive_assembler"},{"containerName":"_naive_assembler","name":"$identity","line":877,"kind":13},{"containerName":"_naive_assembler","name":"$self","line":878,"kind":13},{"containerName":"_naive_assembler","name":"_overlap_alignment","line":878,"kind":12},{"kind":13,"line":878,"containerName":"_naive_assembler","name":"$contig"},{"name":"$qseq","containerName":"_naive_assembler","line":878,"kind":13},{"kind":13,"line":878,"name":"$tseq","containerName":"_naive_assembler"},{"kind":13,"line":878,"containerName":"_naive_assembler","name":"$min_overlap"},{"line":879,"kind":13,"containerName":"_naive_assembler","name":"$min_identity"},{"kind":13,"line":881,"name":"$aln","containerName":"_naive_assembler"},{"line":883,"kind":13,"containerName":"_naive_assembler","name":"$is_singlet"},{"line":884,"kind":13,"containerName":"_naive_assembler","name":"$overlap_map"},{"kind":13,"line":884,"containerName":"_naive_assembler","name":"$qseqid"},{"line":884,"kind":13,"containerName":"_naive_assembler","name":"$tseqid"},{"containerName":"_naive_assembler","name":"$has_overlap","kind":13,"line":885},{"containerName":"_naive_assembler","name":"$tseqid","kind":13,"line":885},{"line":886,"kind":13,"name":"$has_overlap","containerName":"_naive_assembler"},{"name":"$qseqid","containerName":"_naive_assembler","kind":13,"line":886},{"containerName":"_naive_assembler","name":"$has_overlap","kind":13,"line":889},{"line":889,"kind":13,"containerName":"_naive_assembler","name":"$qseqid"},{"containerName":"_naive_assembler","name":"$is_singlet","kind":13,"line":890},{"name":"$is_singlet","containerName":"_naive_assembler","kind":13,"line":892},{"name":"$spectrum","containerName":"_naive_assembler","kind":13,"line":893}],"line":853,"kind":12,"signature":{"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none\n\n\nsub drop_assembly {\n  my ($self) = @_;\n  $self->{'_assembly'} = [];\n  return 1;\n}\n\n=head2 dissolve\n\n  Title   : dissolve\n  Usage   : $dissolved_csp->dissolve($mixed_csp, $seq_header);\n  Function: Dissolve a mixed contig spectrum for the set of sequences that\n            contain the specified header, i.e. determine the contribution of\n            these sequences to the mixed contig spectrum based on the assembly.\n            The mixed contig spectrum object must have been created based on one\n            (or several) assembly object(s). Additionally, min_overlap and\n            min_identity must have been set (either manually using min_overlap\n            or automatically by switching on the eff_asm_params option).\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n            sequence header string\n\n\n\nsub dissolve {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  $self->_import_dissolved_csp($mixed_csp, $seq_header);\n  return 1;\n}\n\n\n=head2 cross\n\n  Title   : cross\n  Usage   : $cross_csp->cross($mixed_csp);\n  Function: Calculate a cross contig_spectrum based on a mixed contig_spectrum.\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n\n\nsub cross {\n  my ($self, $mixed_csp) = @_;\n  $self->_import_cross_csp($mixed_csp);\n  return 1;\n}\n\n=head2 to_string\n\n  Title   : to_string\n  Usage   : my $csp_string = $csp->to_string;\n  Function: Convert the contig spectrum into a string (easy to print!!).\n  Returns : string\n  Args    : element separator (integer) [optional]\n              1 -> space-separated\n              2 -> tab-separated\n              3 -> newline-separated\n\n\nsub to_string {\n  my ($self, $element_separator) = @_;\n  return 0 if $self->{'_max_size'} == 0;\n  $element_separator ||= 1;\n  if ($element_separator == 1) {\n    $element_separator = ' ';\n  } elsif ($element_separator == 2) {\n    $element_separator = \"\\t\";\n  } elsif ($element_separator == 3) {\n    $element_separator = \"\\n\";\n  } else {\n    $self->throw(\"Unknown separator type '$element_separator'\\n\");\n  }\n  my $str = '';\n  for (my $q = 1 ; $q <= $self->{'_max_size'} ; $q++) {\n    my $val = 0;\n    if (exists $self->{'_spectrum'}{$q}) {\n      $val = $self->{'_spectrum'}{$q};\n    }\n    $str .= $val.$element_separator;\n  }\n  $str =~ s/\\s$//;\n  return $str;\n}\n\n\n=head2 add\n\n  Title   : add\n  Usage   : $csp->add($additional_csp);\n  Function: Add a contig spectrum to an existing one: sums the spectra, update\n            the number of sequences, number of repetitions, ...\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum object\n\n\nsub add {\n  my ($self, $csp) = @_;\n  # Sanity check\n  if( !ref $csp || ! $csp->isa('Bio::Assembly::Tools::ContigSpectrum') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n  }\n  # Update overlap statistics\n  if ( $self->{'_eff_asm_params'} > 0 ) {\n    # Warnings\n    if ( $csp->{'_eff_asm_params'} == 0 ) {\n      $self->warn(\"The parent contig spectrum needs effective assembly \".\n        \"parameters (eff_asm_params = \".$self->{'_eff_asm_params'}.\") but the \".\n        \"child contig spectrum doesn't have them (eff_asm_params = \".\n        $csp->{'_eff_asm_params'}.\"). Skipping them...\");\n    } elsif ( $csp->{'_eff_asm_params'} != $self->{'_eff_asm_params'} ) {\n      $self->warn(\"The parent contig spectrum needs a different method for \".\n        \"detecting the effective assembly parameters (eff_asm_params = \".\n        $self->{'_eff_asm_params'}.\") than the one specified for the child \".\n        \"contig spectrum (eff_asm_params = \".$csp->{'_eff_asm_params'}.\"). \".\n        \"Ignoring the differences...\");\n    }\n    # Update existing stats\n    my $tot_num_overlaps = $csp->{'_nof_overlaps'} + $self->{'_nof_overlaps'};\n    $self->{'_min_overlap'} = $csp->{'_min_overlap'} if\n      defined $csp->{'_min_overlap'} && ( ! defined $self->{'_min_overlap'} ||\n      $csp->{'_min_overlap'} < $self->{'_min_overlap'} );\n    $self->{'_min_identity'} = $csp->{'_min_identity'} if\n      defined $csp->{'_min_identity'} && ( ! defined $self->{'_min_identity'} ||\n      $csp->{'_min_identity'} < $self->{'_min_identity'} );\n    if ($tot_num_overlaps != 0) {\n      $self->{'_avg_overlap'} =\n        ($csp->{'_avg_overlap'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_overlap'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n      $self->{'_avg_identity'} =\n        ($csp->{'_avg_identity'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_identity'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n    }\n    $self->{'_nof_overlaps'} = $tot_num_overlaps;\n  }\n  # Update sequence statistics\n  my $tot_nof_seq = $csp->{'_nof_seq'} + $self->{'_nof_seq'};\n  if (not $tot_nof_seq == 0) {\n    $self->{'_avg_seq_len'} = ($csp->{'_avg_seq_len'} * $csp->{'_nof_seq'} +\n      $self->{'_avg_seq_len'} * $self->{'_nof_seq'}) / $tot_nof_seq;\n  }\n  # Update spectrum (and nof_seq, max_size, and increment nof_rep by 1)\n  $self->_import_spectrum($csp->{'_spectrum'});\n  # Update nof_rep\n  $self->{'_nof_rep'}--;\n  $self->{'_nof_rep'} += $csp->{'_nof_rep'};\n  # Update list of assembly objects used\n  push @{$self->{'_assembly'}}, @{$csp->{'_assembly'}}\n    if defined $csp->{'_assembly'};\n  return 1;\n}\n\n\n=head2 average\n\n  Title   : average\n  Usage   : my $avg_csp = $csp->average([$csp1, $csp2, $csp3]);\n  Function: Average one contig spectrum or the sum of several contig spectra by\n            the number of repetitions\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Tools::ContigSpectrum array reference\n            eff_asm_params\n\n\nsub average {\n  my ($self, $list) = @_;\n  # Sanity check\n  if ( ! ref $list || ! ref $list eq 'ARRAY') {\n    $self->throw(\"Average takes an array reference but got [\".ref($list).\"]\");\n  }\n  # New average contig spectrum object\n  my $avg = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg->{'_eff_asm_params'} = 1;\n  \n  # Cycle through contig spectra\n  my $tot_nof_rep = 0;\n  for my $csp (@$list) {\n    # Sanity check\n    if (not $csp->isa('Bio::Assembly::Tools::ContigSpectrum')) {\n      $csp->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n    }\n    # Import contig spectrum\n    $avg->add($csp);\n  }\n  \n  # Average sum of contig spectra by number of repetitions\n  for (my $q = 1 ; $q <= $avg->{'_max_size'} ; $q++) {\n    $avg->{'_spectrum'}{$q} /= $avg->{'_nof_rep'}\n      if (defined $avg->{'_spectrum'}{$q});\n  }\n  # Average number of sequences\n  $avg->{'_nof_seq'} /= $avg->{'_nof_rep'};\n  # Average number of overlaps\n  $avg->{'_nof_overlaps'} /= $avg->{'_nof_rep'};\n  \n  return $avg;\n}\n\n\n=head2 score\n\n  Title   : score\n  Usage   : my $score = $csp->score();\n  Function: Score a contig spectrum (or cross-contig spectrum) such that the\n             higher the number of contigs (or cross-contigs) and the larger their \n             size, the higher the score.\n             Let n   : total number of sequences\n                 c_q : number of contigs of size q\n                 q   : number of sequence in a contig\n             We define: score = n/(n-1) * (X - 1/n)\n                  where X = sum ( c_q * q^2 ) / n**2\n             The score ranges from 0 (singlets only) to 1 (a single large contig)\n             It is possible to specify a value for the number of sequences to\n              assume in the contig spectrum.\n  Returns : contig score\n  Args    : number of total sequences to assume [optional]\n\n\nsub score {\n  my ($self, $nof_seqs) = @_;\n  # Main\n  my $score = 0;\n  my $n = $self->nof_seq;\n  if ( $n > 0 ) {\n    # Contig spectrum info\n    my $q_max = $self->max_size;\n    my $spec  = $self->spectrum;\n    # Adjust number of 1-contigs\n    if ( $nof_seqs ) {\n      $spec->{'1'} += $nof_seqs - $n;\n      $n = $nof_seqs;\n    }\n    # Calculate X\n    for my $q ( 1 .. $q_max ) {\n      if ( $spec->{$q} ) {\n        my $c_q = $spec->{$q};\n        $score += $c_q * $q ** 2;\n      }\n    }\n    $score /= $n ** 2; \n  }\n  # Rescale X to obtain the score\n  $score = $n/($n-1) * ($score - 1/$n);\n  return $score;\n}\n\n\n=head2 _naive_assembler\n\n  Title   : _naive_assembler\n  Usage   : \n  Function: Determines the contig spectrum (hash representation) of a subset of\n            sequences from a mixed contig spectrum by \"reassembling\" the\n            specified sequences only based on their position in the contig. This\n            naive assembly only verifies that the minimum overlap length and\n            percentage identity are respected. There is no actual alignment done\n  Returns : contig spectrum hash reference\n  Args    : Bio::Assembly::Contig\n            sequence ID array reference\n            minimum overlap length (integer) [optional]\n            minimum percentage identity (integer) [optional]","parameters":[{"label":"$self"},{"label":"$contig"},{"label":"$seqlist"},{"label":"$min_overlap"},{"label":"$min_identity"}],"label":"_naive_assembler($self,$contig,$seqlist,$min_overlap,$min_identity)"},"detail":"($self,$contig,$seqlist,$min_overlap,$min_identity)","definition":"sub","containerName":"main::"},{"kind":12,"line":869,"name":"seqlist"},{"name":"seqlist","line":874,"kind":12},{"line":897,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$last_is_singlet"},{"name":"%has_overlap","containerName":null,"kind":13,"line":898},{"kind":12,"line":898,"name":"seqlist"},{"kind":13,"line":898,"name":"%max","containerName":null},{"containerName":null,"name":"$last_is_singlet","line":899,"kind":13},{"kind":13,"line":901,"name":"%last_is_singlet","containerName":null},{"kind":13,"line":902,"containerName":null,"name":"%spectrum"},{"kind":13,"line":905,"name":"$seqid","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":905,"containerName":null,"name":"%seqlist"},{"containerName":null,"name":"%overlap_map","line":907,"kind":13},{"name":"$seqid","containerName":null,"kind":13,"line":907},{"kind":13,"line":908,"name":"@overlist","definition":"my","containerName":null,"localvar":"my"},{"line":908,"kind":13,"name":"%overlap_map","containerName":null},{"line":908,"kind":13,"containerName":null,"name":"$seqid"},{"line":909,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$j"},{"containerName":null,"name":"$j","line":909,"kind":13},{"containerName":null,"name":"@overlist","kind":13,"line":909},{"kind":13,"line":909,"name":"%j","containerName":null},{"line":910,"kind":13,"localvar":"my","name":"$otherseqid","definition":"my","containerName":null},{"kind":13,"line":910,"containerName":null,"name":"@overlist"},{"kind":13,"line":910,"containerName":null,"name":"$j"},{"line":911,"kind":13,"name":"%overlap_map","containerName":null},{"containerName":null,"name":"%otherseqid","kind":13,"line":911},{"line":912,"kind":13,"containerName":null,"name":"@overlist"},{"containerName":null,"name":"%overlap_map","kind":13,"line":912},{"line":912,"kind":13,"containerName":null,"name":"$otherseqid"},{"name":"%overlap_map","containerName":null,"line":913,"kind":13},{"line":913,"kind":13,"containerName":null,"name":"$otherseqid"},{"line":917,"kind":13,"containerName":null,"name":"@overlist"},{"kind":13,"line":917,"name":"@overlist","containerName":null},{"containerName":null,"definition":"my","name":"$j","localvar":"my","kind":13,"line":918},{"containerName":null,"name":"$j","kind":13,"line":918},{"kind":13,"line":918,"name":"@overlist","containerName":null},{"name":"%j","containerName":null,"line":918,"kind":13},{"name":"@overlist","containerName":null,"line":919,"kind":13},{"kind":13,"line":919,"name":"$j","containerName":null},{"name":"@overlist","containerName":null,"kind":13,"line":919},{"kind":13,"line":919,"name":"%j","containerName":null},{"name":"@overlist","containerName":null,"kind":13,"line":920},{"containerName":null,"name":"$j","kind":13,"line":920},{"containerName":null,"name":"$j","line":921,"kind":13},{"localvar":"my","containerName":null,"definition":"my","name":"$qsize","line":925,"kind":13},{"containerName":null,"name":"@overlist","kind":13,"line":925},{"kind":13,"line":926,"containerName":null,"name":"%spectrum"},{"kind":13,"line":926,"name":"%qsize","containerName":null},{"containerName":null,"name":"%spectrum","kind":13,"line":927},{"containerName":null,"name":"%qsize","line":927,"kind":13},{"name":"%spectrum","containerName":null,"kind":13,"line":929},{"name":"$qsize","containerName":null,"kind":13,"line":929},{"name":"%spectrum","containerName":null,"line":932,"kind":13},{"kind":12,"line":947,"children":[{"line":950,"kind":13,"localvar":"my","containerName":"_new_from_assembly","definition":"my","name":"$self"},{"containerName":"_new_from_assembly","name":"$assemblyobj","kind":13,"line":950},{"localvar":"my","name":"$csp","definition":"my","containerName":"_new_from_assembly","line":951,"kind":13},{"containerName":"_new_from_assembly","name":"new","kind":12,"line":951},{"containerName":"_new_from_assembly","name":"$csp","line":953,"kind":13},{"name":"$assemblyobj","containerName":"_new_from_assembly","line":953,"kind":13},{"name":"id","containerName":"_new_from_assembly","kind":12,"line":953},{"containerName":"_new_from_assembly","name":"$csp","line":956,"kind":13},{"kind":13,"line":956,"containerName":"_new_from_assembly","name":"$self"},{"name":"$csp","containerName":"_new_from_assembly","kind":13,"line":957},{"line":958,"kind":13,"localvar":"my","definition":"my","name":"$nover","containerName":"_new_from_assembly"},{"containerName":"_new_from_assembly","name":"$minl","line":958,"kind":13},{"containerName":"_new_from_assembly","name":"$avgl","kind":13,"line":958},{"kind":13,"line":958,"name":"$minid","containerName":"_new_from_assembly"},{"containerName":"_new_from_assembly","name":"$avgid","kind":13,"line":958},{"kind":13,"line":959,"containerName":"_new_from_assembly","name":"$csp"},{"containerName":"_new_from_assembly","name":"_get_overlap_stats","kind":12,"line":959},{"name":"$assemblyobj","containerName":"_new_from_assembly","kind":13,"line":959},{"line":960,"kind":13,"name":"$csp","containerName":"_new_from_assembly"},{"kind":13,"line":960,"containerName":"_new_from_assembly","name":"$minl"},{"line":961,"kind":13,"name":"$csp","containerName":"_new_from_assembly"},{"name":"$minid","containerName":"_new_from_assembly","kind":13,"line":961},{"line":962,"kind":13,"name":"$csp","containerName":"_new_from_assembly"},{"kind":13,"line":962,"name":"$avgl","containerName":"_new_from_assembly"},{"kind":13,"line":963,"name":"$csp","containerName":"_new_from_assembly"},{"kind":13,"line":963,"containerName":"_new_from_assembly","name":"$avgid"},{"kind":13,"line":964,"name":"$csp","containerName":"_new_from_assembly"},{"kind":13,"line":964,"name":"$nover","containerName":"_new_from_assembly"},{"kind":13,"line":967,"containerName":"_new_from_assembly","definition":"my","name":"$nseq","localvar":"my"},{"line":967,"kind":13,"containerName":"_new_from_assembly","name":"$avgseql"},{"containerName":"_new_from_assembly","name":"$self","line":967,"kind":13},{"line":967,"kind":12,"containerName":"_new_from_assembly","name":"_get_seq_stats"},{"kind":13,"line":967,"containerName":"_new_from_assembly","name":"$assemblyobj"},{"line":968,"kind":13,"name":"$csp","containerName":"_new_from_assembly"},{"containerName":"_new_from_assembly","name":"$avgseql","line":968,"kind":13},{"line":969,"kind":13,"containerName":"_new_from_assembly","name":"$csp"},{"name":"$nseq","containerName":"_new_from_assembly","kind":13,"line":969},{"line":971,"kind":13,"localvar":"my","definition":"my","name":"$contigobj","containerName":"_new_from_assembly"},{"kind":13,"line":971,"name":"$assemblyobj","containerName":"_new_from_assembly"},{"containerName":"_new_from_assembly","name":"all_contigs","line":971,"kind":12},{"line":972,"kind":13,"localvar":"my","name":"$size","definition":"my","containerName":"_new_from_assembly"},{"kind":13,"line":972,"name":"$contigobj","containerName":"_new_from_assembly"},{"line":972,"kind":12,"containerName":"_new_from_assembly","name":"num_sequences"},{"name":"$csp","containerName":"_new_from_assembly","kind":13,"line":973},{"line":973,"kind":13,"containerName":"_new_from_assembly","name":"$size"},{"kind":13,"line":974,"containerName":"_new_from_assembly","name":"$csp"},{"containerName":"_new_from_assembly","name":"$size","kind":13,"line":974},{"containerName":"_new_from_assembly","name":"$csp","line":976,"kind":13},{"containerName":"_new_from_assembly","name":"$size","kind":13,"line":976},{"name":"$csp","containerName":"_new_from_assembly","line":978,"kind":13},{"line":978,"kind":13,"containerName":"_new_from_assembly","name":"$size"},{"kind":13,"line":978,"containerName":"_new_from_assembly","name":"$size"},{"kind":13,"line":978,"containerName":"_new_from_assembly","name":"$csp"},{"kind":13,"line":980,"name":"$nof_singlets","definition":"my","containerName":"_new_from_assembly","localvar":"my"},{"kind":13,"line":980,"name":"$assemblyobj","containerName":"_new_from_assembly"},{"kind":12,"line":980,"containerName":"_new_from_assembly","name":"get_nof_singlets"},{"kind":13,"line":981,"containerName":"_new_from_assembly","name":"$nof_singlets"},{"containerName":"_new_from_assembly","name":"$csp","line":982,"kind":13},{"line":982,"kind":13,"name":"$nof_singlets","containerName":"_new_from_assembly"},{"name":"$csp","containerName":"_new_from_assembly","kind":13,"line":983},{"line":983,"kind":13,"containerName":"_new_from_assembly","name":"$nof_singlets"},{"line":983,"kind":13,"name":"$csp","containerName":"_new_from_assembly"},{"line":986,"kind":13,"name":"$csp","containerName":"_new_from_assembly"}],"containerName":"main::","definition":"sub","detail":"($self,$assemblyobj)","signature":{"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none\n\n\nsub drop_assembly {\n  my ($self) = @_;\n  $self->{'_assembly'} = [];\n  return 1;\n}\n\n=head2 dissolve\n\n  Title   : dissolve\n  Usage   : $dissolved_csp->dissolve($mixed_csp, $seq_header);\n  Function: Dissolve a mixed contig spectrum for the set of sequences that\n            contain the specified header, i.e. determine the contribution of\n            these sequences to the mixed contig spectrum based on the assembly.\n            The mixed contig spectrum object must have been created based on one\n            (or several) assembly object(s). Additionally, min_overlap and\n            min_identity must have been set (either manually using min_overlap\n            or automatically by switching on the eff_asm_params option).\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n            sequence header string\n\n\n\nsub dissolve {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  $self->_import_dissolved_csp($mixed_csp, $seq_header);\n  return 1;\n}\n\n\n=head2 cross\n\n  Title   : cross\n  Usage   : $cross_csp->cross($mixed_csp);\n  Function: Calculate a cross contig_spectrum based on a mixed contig_spectrum.\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n\n\nsub cross {\n  my ($self, $mixed_csp) = @_;\n  $self->_import_cross_csp($mixed_csp);\n  return 1;\n}\n\n=head2 to_string\n\n  Title   : to_string\n  Usage   : my $csp_string = $csp->to_string;\n  Function: Convert the contig spectrum into a string (easy to print!!).\n  Returns : string\n  Args    : element separator (integer) [optional]\n              1 -> space-separated\n              2 -> tab-separated\n              3 -> newline-separated\n\n\nsub to_string {\n  my ($self, $element_separator) = @_;\n  return 0 if $self->{'_max_size'} == 0;\n  $element_separator ||= 1;\n  if ($element_separator == 1) {\n    $element_separator = ' ';\n  } elsif ($element_separator == 2) {\n    $element_separator = \"\\t\";\n  } elsif ($element_separator == 3) {\n    $element_separator = \"\\n\";\n  } else {\n    $self->throw(\"Unknown separator type '$element_separator'\\n\");\n  }\n  my $str = '';\n  for (my $q = 1 ; $q <= $self->{'_max_size'} ; $q++) {\n    my $val = 0;\n    if (exists $self->{'_spectrum'}{$q}) {\n      $val = $self->{'_spectrum'}{$q};\n    }\n    $str .= $val.$element_separator;\n  }\n  $str =~ s/\\s$//;\n  return $str;\n}\n\n\n=head2 add\n\n  Title   : add\n  Usage   : $csp->add($additional_csp);\n  Function: Add a contig spectrum to an existing one: sums the spectra, update\n            the number of sequences, number of repetitions, ...\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum object\n\n\nsub add {\n  my ($self, $csp) = @_;\n  # Sanity check\n  if( !ref $csp || ! $csp->isa('Bio::Assembly::Tools::ContigSpectrum') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n  }\n  # Update overlap statistics\n  if ( $self->{'_eff_asm_params'} > 0 ) {\n    # Warnings\n    if ( $csp->{'_eff_asm_params'} == 0 ) {\n      $self->warn(\"The parent contig spectrum needs effective assembly \".\n        \"parameters (eff_asm_params = \".$self->{'_eff_asm_params'}.\") but the \".\n        \"child contig spectrum doesn't have them (eff_asm_params = \".\n        $csp->{'_eff_asm_params'}.\"). Skipping them...\");\n    } elsif ( $csp->{'_eff_asm_params'} != $self->{'_eff_asm_params'} ) {\n      $self->warn(\"The parent contig spectrum needs a different method for \".\n        \"detecting the effective assembly parameters (eff_asm_params = \".\n        $self->{'_eff_asm_params'}.\") than the one specified for the child \".\n        \"contig spectrum (eff_asm_params = \".$csp->{'_eff_asm_params'}.\"). \".\n        \"Ignoring the differences...\");\n    }\n    # Update existing stats\n    my $tot_num_overlaps = $csp->{'_nof_overlaps'} + $self->{'_nof_overlaps'};\n    $self->{'_min_overlap'} = $csp->{'_min_overlap'} if\n      defined $csp->{'_min_overlap'} && ( ! defined $self->{'_min_overlap'} ||\n      $csp->{'_min_overlap'} < $self->{'_min_overlap'} );\n    $self->{'_min_identity'} = $csp->{'_min_identity'} if\n      defined $csp->{'_min_identity'} && ( ! defined $self->{'_min_identity'} ||\n      $csp->{'_min_identity'} < $self->{'_min_identity'} );\n    if ($tot_num_overlaps != 0) {\n      $self->{'_avg_overlap'} =\n        ($csp->{'_avg_overlap'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_overlap'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n      $self->{'_avg_identity'} =\n        ($csp->{'_avg_identity'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_identity'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n    }\n    $self->{'_nof_overlaps'} = $tot_num_overlaps;\n  }\n  # Update sequence statistics\n  my $tot_nof_seq = $csp->{'_nof_seq'} + $self->{'_nof_seq'};\n  if (not $tot_nof_seq == 0) {\n    $self->{'_avg_seq_len'} = ($csp->{'_avg_seq_len'} * $csp->{'_nof_seq'} +\n      $self->{'_avg_seq_len'} * $self->{'_nof_seq'}) / $tot_nof_seq;\n  }\n  # Update spectrum (and nof_seq, max_size, and increment nof_rep by 1)\n  $self->_import_spectrum($csp->{'_spectrum'});\n  # Update nof_rep\n  $self->{'_nof_rep'}--;\n  $self->{'_nof_rep'} += $csp->{'_nof_rep'};\n  # Update list of assembly objects used\n  push @{$self->{'_assembly'}}, @{$csp->{'_assembly'}}\n    if defined $csp->{'_assembly'};\n  return 1;\n}\n\n\n=head2 average\n\n  Title   : average\n  Usage   : my $avg_csp = $csp->average([$csp1, $csp2, $csp3]);\n  Function: Average one contig spectrum or the sum of several contig spectra by\n            the number of repetitions\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Tools::ContigSpectrum array reference\n            eff_asm_params\n\n\nsub average {\n  my ($self, $list) = @_;\n  # Sanity check\n  if ( ! ref $list || ! ref $list eq 'ARRAY') {\n    $self->throw(\"Average takes an array reference but got [\".ref($list).\"]\");\n  }\n  # New average contig spectrum object\n  my $avg = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg->{'_eff_asm_params'} = 1;\n  \n  # Cycle through contig spectra\n  my $tot_nof_rep = 0;\n  for my $csp (@$list) {\n    # Sanity check\n    if (not $csp->isa('Bio::Assembly::Tools::ContigSpectrum')) {\n      $csp->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n    }\n    # Import contig spectrum\n    $avg->add($csp);\n  }\n  \n  # Average sum of contig spectra by number of repetitions\n  for (my $q = 1 ; $q <= $avg->{'_max_size'} ; $q++) {\n    $avg->{'_spectrum'}{$q} /= $avg->{'_nof_rep'}\n      if (defined $avg->{'_spectrum'}{$q});\n  }\n  # Average number of sequences\n  $avg->{'_nof_seq'} /= $avg->{'_nof_rep'};\n  # Average number of overlaps\n  $avg->{'_nof_overlaps'} /= $avg->{'_nof_rep'};\n  \n  return $avg;\n}\n\n\n=head2 score\n\n  Title   : score\n  Usage   : my $score = $csp->score();\n  Function: Score a contig spectrum (or cross-contig spectrum) such that the\n             higher the number of contigs (or cross-contigs) and the larger their \n             size, the higher the score.\n             Let n   : total number of sequences\n                 c_q : number of contigs of size q\n                 q   : number of sequence in a contig\n             We define: score = n/(n-1) * (X - 1/n)\n                  where X = sum ( c_q * q^2 ) / n**2\n             The score ranges from 0 (singlets only) to 1 (a single large contig)\n             It is possible to specify a value for the number of sequences to\n              assume in the contig spectrum.\n  Returns : contig score\n  Args    : number of total sequences to assume [optional]\n\n\nsub score {\n  my ($self, $nof_seqs) = @_;\n  # Main\n  my $score = 0;\n  my $n = $self->nof_seq;\n  if ( $n > 0 ) {\n    # Contig spectrum info\n    my $q_max = $self->max_size;\n    my $spec  = $self->spectrum;\n    # Adjust number of 1-contigs\n    if ( $nof_seqs ) {\n      $spec->{'1'} += $nof_seqs - $n;\n      $n = $nof_seqs;\n    }\n    # Calculate X\n    for my $q ( 1 .. $q_max ) {\n      if ( $spec->{$q} ) {\n        my $c_q = $spec->{$q};\n        $score += $c_q * $q ** 2;\n      }\n    }\n    $score /= $n ** 2; \n  }\n  # Rescale X to obtain the score\n  $score = $n/($n-1) * ($score - 1/$n);\n  return $score;\n}\n\n\n=head2 _naive_assembler\n\n  Title   : _naive_assembler\n  Usage   : \n  Function: Determines the contig spectrum (hash representation) of a subset of\n            sequences from a mixed contig spectrum by \"reassembling\" the\n            specified sequences only based on their position in the contig. This\n            naive assembly only verifies that the minimum overlap length and\n            percentage identity are respected. There is no actual alignment done\n  Returns : contig spectrum hash reference\n  Args    : Bio::Assembly::Contig\n            sequence ID array reference\n            minimum overlap length (integer) [optional]\n            minimum percentage identity (integer) [optional]\n\n\nsub _naive_assembler {\n  my ($self, $contig, $seqlist, $min_overlap, $min_identity) = @_;\n  # Sanity checks\n  if ( ! ref $seqlist || ! ref($seqlist) eq 'ARRAY') {\n    $self->throw('Expecting an array reference. Got ['.ref($seqlist).\"] \\n\");\n  }\n  my $max = scalar @$seqlist;\n  $self->throw(\"Expecting at least 2 sequences as input for _naive_assembler\")\n    if ($max < 2);\n  # Assembly\n  my %spectrum = (1 => 0);\n  my %overlap_map;\n  my %has_overlap;\n  # Map what sequences overlap with what sequences\n  for (my $i = 0 ; $i < $max-1 ; $i++) {\n    # query sequence\n    my $qseqid = $$seqlist[$i];\n    my $qseq   = $contig->get_seq_by_name($qseqid);\n    my $is_singlet = 1;\n    for (my $j = $i+1 ; $j < $max ; $j++) {\n      # target sequence\n      my $tseqid = $$seqlist[$j];\n      my $tseq = $contig->get_seq_by_name($tseqid);\n      # try to align sequences\n      my ($aln, $overlap, $identity)\n        = $self->_overlap_alignment($contig, $qseq, $tseq, $min_overlap,\n        $min_identity);\n      # if there is no valid overlap, go to next sequence\n      next if ! defined $aln;\n      # the overlap is valid\n      $is_singlet = 0;\n      push @{$overlap_map{$qseqid}}, $tseqid;\n      $has_overlap{$tseqid} = 1;\n      $has_overlap{$qseqid} = 1;\n    }\n    # check if sequence is in previously seen overlap\n    if (exists $has_overlap{$qseqid}) {\n      $is_singlet = 0;\n    }\n    if ($is_singlet == 1) {\n      $spectrum{1}++;\n    }\n  }\n  # take care of last sequence\n  my $last_is_singlet = 1;\n  if (exists $has_overlap{$$seqlist[$max-1]}) {\n    $last_is_singlet = 0;\n  }\n  if ($last_is_singlet == 1) {\n    $spectrum{1}++;\n  }\n  # Parse overlap map\n  for my $seqid (@$seqlist) {\n    # list of sequences that should go in the contig\n    next if not exists $overlap_map{$seqid};\n    my @overlist = @{$overlap_map{$seqid}};\n    for (my $j = 0 ; $j < scalar(@overlist) ; $j++) {\n      my $otherseqid = $overlist[$j];\n      if (exists $overlap_map{$otherseqid}) {\n        push @overlist, @{$overlap_map{$otherseqid}};\n        delete $overlap_map{$otherseqid};\n      }\n    }\n    # remove duplicates from list\n    @overlist = sort @overlist;\n    for (my $j = 0 ; $j < scalar(@overlist)-1 ; $j++) {\n      if ( $overlist[$j] eq $overlist[$j+1] ) {\n        splice @overlist, $j, 1;\n        $j--;\n      }\n    }\n    # update spectrum with size of contig\n    my $qsize = scalar(@overlist) + 1;\n    if (defined $spectrum{$qsize}) {\n      $spectrum{$qsize}++;\n    } else {\n      $spectrum{$qsize} = 1;\n    }\n  }\n  return \\%spectrum;\n}\n\n\n=head2 _new_from_assembly\n\n  Title   : _new_from_assembly\n  Usage   : \n  Function: Creates a new contig spectrum object based solely on the result of \n            an assembly\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Scaffold","parameters":[{"label":"$self"},{"label":"$assemblyobj"}],"label":"_new_from_assembly($self,$assemblyobj)"},"name":"_new_from_assembly","range":{"start":{"line":947,"character":0},"end":{"character":9999,"line":986}}},{"kind":12,"line":951,"containerName":"Assembly::Tools::ContigSpectrum","name":"Bio"},{"line":986,"kind":13,"name":"$assemblyobj","containerName":null},{"containerName":null,"name":"%csp","kind":13,"line":988},{"kind":13,"line":989,"name":"$csp","containerName":null},{"line":1005,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_new_dissolved_csp","line":1006,"kind":13},{"line":1006,"kind":13,"containerName":"_new_dissolved_csp","name":"$mixed_csp"},{"name":"$seq_header","containerName":"_new_dissolved_csp","line":1006,"kind":13},{"name":"$mixed_csp","containerName":"_new_dissolved_csp","kind":13,"line":1011},{"name":"$self","containerName":"_new_dissolved_csp","kind":13,"line":1012},{"containerName":"_new_dissolved_csp","name":"$mixed_csp","kind":13,"line":1013},{"kind":13,"line":1014,"containerName":"_new_dissolved_csp","name":"$self"},{"line":1014,"kind":12,"containerName":"_new_dissolved_csp","name":"throw"},{"containerName":"_new_dissolved_csp","name":"$self","line":1017,"kind":13},{"containerName":"_new_dissolved_csp","name":"$mixed_csp","line":1018,"kind":13},{"kind":13,"line":1019,"containerName":"_new_dissolved_csp","name":"$self"},{"containerName":"_new_dissolved_csp","name":"throw","kind":12,"line":1019},{"line":1025,"kind":13,"containerName":"_new_dissolved_csp","name":"$mixed_csp"},{"line":1026,"kind":13,"name":"$mixed_csp","containerName":"_new_dissolved_csp"}],"kind":12,"detail":"($self,$mixed_csp,$seq_header)","signature":{"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none\n\n\nsub drop_assembly {\n  my ($self) = @_;\n  $self->{'_assembly'} = [];\n  return 1;\n}\n\n=head2 dissolve\n\n  Title   : dissolve\n  Usage   : $dissolved_csp->dissolve($mixed_csp, $seq_header);\n  Function: Dissolve a mixed contig spectrum for the set of sequences that\n            contain the specified header, i.e. determine the contribution of\n            these sequences to the mixed contig spectrum based on the assembly.\n            The mixed contig spectrum object must have been created based on one\n            (or several) assembly object(s). Additionally, min_overlap and\n            min_identity must have been set (either manually using min_overlap\n            or automatically by switching on the eff_asm_params option).\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n            sequence header string\n\n\n\nsub dissolve {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  $self->_import_dissolved_csp($mixed_csp, $seq_header);\n  return 1;\n}\n\n\n=head2 cross\n\n  Title   : cross\n  Usage   : $cross_csp->cross($mixed_csp);\n  Function: Calculate a cross contig_spectrum based on a mixed contig_spectrum.\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n\n\nsub cross {\n  my ($self, $mixed_csp) = @_;\n  $self->_import_cross_csp($mixed_csp);\n  return 1;\n}\n\n=head2 to_string\n\n  Title   : to_string\n  Usage   : my $csp_string = $csp->to_string;\n  Function: Convert the contig spectrum into a string (easy to print!!).\n  Returns : string\n  Args    : element separator (integer) [optional]\n              1 -> space-separated\n              2 -> tab-separated\n              3 -> newline-separated\n\n\nsub to_string {\n  my ($self, $element_separator) = @_;\n  return 0 if $self->{'_max_size'} == 0;\n  $element_separator ||= 1;\n  if ($element_separator == 1) {\n    $element_separator = ' ';\n  } elsif ($element_separator == 2) {\n    $element_separator = \"\\t\";\n  } elsif ($element_separator == 3) {\n    $element_separator = \"\\n\";\n  } else {\n    $self->throw(\"Unknown separator type '$element_separator'\\n\");\n  }\n  my $str = '';\n  for (my $q = 1 ; $q <= $self->{'_max_size'} ; $q++) {\n    my $val = 0;\n    if (exists $self->{'_spectrum'}{$q}) {\n      $val = $self->{'_spectrum'}{$q};\n    }\n    $str .= $val.$element_separator;\n  }\n  $str =~ s/\\s$//;\n  return $str;\n}\n\n\n=head2 add\n\n  Title   : add\n  Usage   : $csp->add($additional_csp);\n  Function: Add a contig spectrum to an existing one: sums the spectra, update\n            the number of sequences, number of repetitions, ...\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum object\n\n\nsub add {\n  my ($self, $csp) = @_;\n  # Sanity check\n  if( !ref $csp || ! $csp->isa('Bio::Assembly::Tools::ContigSpectrum') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n  }\n  # Update overlap statistics\n  if ( $self->{'_eff_asm_params'} > 0 ) {\n    # Warnings\n    if ( $csp->{'_eff_asm_params'} == 0 ) {\n      $self->warn(\"The parent contig spectrum needs effective assembly \".\n        \"parameters (eff_asm_params = \".$self->{'_eff_asm_params'}.\") but the \".\n        \"child contig spectrum doesn't have them (eff_asm_params = \".\n        $csp->{'_eff_asm_params'}.\"). Skipping them...\");\n    } elsif ( $csp->{'_eff_asm_params'} != $self->{'_eff_asm_params'} ) {\n      $self->warn(\"The parent contig spectrum needs a different method for \".\n        \"detecting the effective assembly parameters (eff_asm_params = \".\n        $self->{'_eff_asm_params'}.\") than the one specified for the child \".\n        \"contig spectrum (eff_asm_params = \".$csp->{'_eff_asm_params'}.\"). \".\n        \"Ignoring the differences...\");\n    }\n    # Update existing stats\n    my $tot_num_overlaps = $csp->{'_nof_overlaps'} + $self->{'_nof_overlaps'};\n    $self->{'_min_overlap'} = $csp->{'_min_overlap'} if\n      defined $csp->{'_min_overlap'} && ( ! defined $self->{'_min_overlap'} ||\n      $csp->{'_min_overlap'} < $self->{'_min_overlap'} );\n    $self->{'_min_identity'} = $csp->{'_min_identity'} if\n      defined $csp->{'_min_identity'} && ( ! defined $self->{'_min_identity'} ||\n      $csp->{'_min_identity'} < $self->{'_min_identity'} );\n    if ($tot_num_overlaps != 0) {\n      $self->{'_avg_overlap'} =\n        ($csp->{'_avg_overlap'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_overlap'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n      $self->{'_avg_identity'} =\n        ($csp->{'_avg_identity'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_identity'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n    }\n    $self->{'_nof_overlaps'} = $tot_num_overlaps;\n  }\n  # Update sequence statistics\n  my $tot_nof_seq = $csp->{'_nof_seq'} + $self->{'_nof_seq'};\n  if (not $tot_nof_seq == 0) {\n    $self->{'_avg_seq_len'} = ($csp->{'_avg_seq_len'} * $csp->{'_nof_seq'} +\n      $self->{'_avg_seq_len'} * $self->{'_nof_seq'}) / $tot_nof_seq;\n  }\n  # Update spectrum (and nof_seq, max_size, and increment nof_rep by 1)\n  $self->_import_spectrum($csp->{'_spectrum'});\n  # Update nof_rep\n  $self->{'_nof_rep'}--;\n  $self->{'_nof_rep'} += $csp->{'_nof_rep'};\n  # Update list of assembly objects used\n  push @{$self->{'_assembly'}}, @{$csp->{'_assembly'}}\n    if defined $csp->{'_assembly'};\n  return 1;\n}\n\n\n=head2 average\n\n  Title   : average\n  Usage   : my $avg_csp = $csp->average([$csp1, $csp2, $csp3]);\n  Function: Average one contig spectrum or the sum of several contig spectra by\n            the number of repetitions\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Tools::ContigSpectrum array reference\n            eff_asm_params\n\n\nsub average {\n  my ($self, $list) = @_;\n  # Sanity check\n  if ( ! ref $list || ! ref $list eq 'ARRAY') {\n    $self->throw(\"Average takes an array reference but got [\".ref($list).\"]\");\n  }\n  # New average contig spectrum object\n  my $avg = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg->{'_eff_asm_params'} = 1;\n  \n  # Cycle through contig spectra\n  my $tot_nof_rep = 0;\n  for my $csp (@$list) {\n    # Sanity check\n    if (not $csp->isa('Bio::Assembly::Tools::ContigSpectrum')) {\n      $csp->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n    }\n    # Import contig spectrum\n    $avg->add($csp);\n  }\n  \n  # Average sum of contig spectra by number of repetitions\n  for (my $q = 1 ; $q <= $avg->{'_max_size'} ; $q++) {\n    $avg->{'_spectrum'}{$q} /= $avg->{'_nof_rep'}\n      if (defined $avg->{'_spectrum'}{$q});\n  }\n  # Average number of sequences\n  $avg->{'_nof_seq'} /= $avg->{'_nof_rep'};\n  # Average number of overlaps\n  $avg->{'_nof_overlaps'} /= $avg->{'_nof_rep'};\n  \n  return $avg;\n}\n\n\n=head2 score\n\n  Title   : score\n  Usage   : my $score = $csp->score();\n  Function: Score a contig spectrum (or cross-contig spectrum) such that the\n             higher the number of contigs (or cross-contigs) and the larger their \n             size, the higher the score.\n             Let n   : total number of sequences\n                 c_q : number of contigs of size q\n                 q   : number of sequence in a contig\n             We define: score = n/(n-1) * (X - 1/n)\n                  where X = sum ( c_q * q^2 ) / n**2\n             The score ranges from 0 (singlets only) to 1 (a single large contig)\n             It is possible to specify a value for the number of sequences to\n              assume in the contig spectrum.\n  Returns : contig score\n  Args    : number of total sequences to assume [optional]\n\n\nsub score {\n  my ($self, $nof_seqs) = @_;\n  # Main\n  my $score = 0;\n  my $n = $self->nof_seq;\n  if ( $n > 0 ) {\n    # Contig spectrum info\n    my $q_max = $self->max_size;\n    my $spec  = $self->spectrum;\n    # Adjust number of 1-contigs\n    if ( $nof_seqs ) {\n      $spec->{'1'} += $nof_seqs - $n;\n      $n = $nof_seqs;\n    }\n    # Calculate X\n    for my $q ( 1 .. $q_max ) {\n      if ( $spec->{$q} ) {\n        my $c_q = $spec->{$q};\n        $score += $c_q * $q ** 2;\n      }\n    }\n    $score /= $n ** 2; \n  }\n  # Rescale X to obtain the score\n  $score = $n/($n-1) * ($score - 1/$n);\n  return $score;\n}\n\n\n=head2 _naive_assembler\n\n  Title   : _naive_assembler\n  Usage   : \n  Function: Determines the contig spectrum (hash representation) of a subset of\n            sequences from a mixed contig spectrum by \"reassembling\" the\n            specified sequences only based on their position in the contig. This\n            naive assembly only verifies that the minimum overlap length and\n            percentage identity are respected. There is no actual alignment done\n  Returns : contig spectrum hash reference\n  Args    : Bio::Assembly::Contig\n            sequence ID array reference\n            minimum overlap length (integer) [optional]\n            minimum percentage identity (integer) [optional]\n\n\nsub _naive_assembler {\n  my ($self, $contig, $seqlist, $min_overlap, $min_identity) = @_;\n  # Sanity checks\n  if ( ! ref $seqlist || ! ref($seqlist) eq 'ARRAY') {\n    $self->throw('Expecting an array reference. Got ['.ref($seqlist).\"] \\n\");\n  }\n  my $max = scalar @$seqlist;\n  $self->throw(\"Expecting at least 2 sequences as input for _naive_assembler\")\n    if ($max < 2);\n  # Assembly\n  my %spectrum = (1 => 0);\n  my %overlap_map;\n  my %has_overlap;\n  # Map what sequences overlap with what sequences\n  for (my $i = 0 ; $i < $max-1 ; $i++) {\n    # query sequence\n    my $qseqid = $$seqlist[$i];\n    my $qseq   = $contig->get_seq_by_name($qseqid);\n    my $is_singlet = 1;\n    for (my $j = $i+1 ; $j < $max ; $j++) {\n      # target sequence\n      my $tseqid = $$seqlist[$j];\n      my $tseq = $contig->get_seq_by_name($tseqid);\n      # try to align sequences\n      my ($aln, $overlap, $identity)\n        = $self->_overlap_alignment($contig, $qseq, $tseq, $min_overlap,\n        $min_identity);\n      # if there is no valid overlap, go to next sequence\n      next if ! defined $aln;\n      # the overlap is valid\n      $is_singlet = 0;\n      push @{$overlap_map{$qseqid}}, $tseqid;\n      $has_overlap{$tseqid} = 1;\n      $has_overlap{$qseqid} = 1;\n    }\n    # check if sequence is in previously seen overlap\n    if (exists $has_overlap{$qseqid}) {\n      $is_singlet = 0;\n    }\n    if ($is_singlet == 1) {\n      $spectrum{1}++;\n    }\n  }\n  # take care of last sequence\n  my $last_is_singlet = 1;\n  if (exists $has_overlap{$$seqlist[$max-1]}) {\n    $last_is_singlet = 0;\n  }\n  if ($last_is_singlet == 1) {\n    $spectrum{1}++;\n  }\n  # Parse overlap map\n  for my $seqid (@$seqlist) {\n    # list of sequences that should go in the contig\n    next if not exists $overlap_map{$seqid};\n    my @overlist = @{$overlap_map{$seqid}};\n    for (my $j = 0 ; $j < scalar(@overlist) ; $j++) {\n      my $otherseqid = $overlist[$j];\n      if (exists $overlap_map{$otherseqid}) {\n        push @overlist, @{$overlap_map{$otherseqid}};\n        delete $overlap_map{$otherseqid};\n      }\n    }\n    # remove duplicates from list\n    @overlist = sort @overlist;\n    for (my $j = 0 ; $j < scalar(@overlist)-1 ; $j++) {\n      if ( $overlist[$j] eq $overlist[$j+1] ) {\n        splice @overlist, $j, 1;\n        $j--;\n      }\n    }\n    # update spectrum with size of contig\n    my $qsize = scalar(@overlist) + 1;\n    if (defined $spectrum{$qsize}) {\n      $spectrum{$qsize}++;\n    } else {\n      $spectrum{$qsize} = 1;\n    }\n  }\n  return \\%spectrum;\n}\n\n\n=head2 _new_from_assembly\n\n  Title   : _new_from_assembly\n  Usage   : \n  Function: Creates a new contig spectrum object based solely on the result of \n            an assembly\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Scaffold\n\n\nsub _new_from_assembly {\n  # Create new contig spectrum object based purely on what we can get from the\n  # assembly object\n  my ($self, $assemblyobj) = @_;\n  my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n  # 1: Set id\n  $csp->{'_id'} = $assemblyobj->id;\n  # 2: Set overlap statistics: nof_overlaps, min_overlap, avg_overlap,\n  #  min_identity and avg_identity\n  $csp->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  if ($csp->{'_eff_asm_params'} > 0) {\n     my ($nover, $minl, $avgl, $minid, $avgid)\n       = $csp->_get_overlap_stats($assemblyobj);\n     $csp->{'_min_overlap'}  = $minl;\n     $csp->{'_min_identity'} = $minid;\n     $csp->{'_avg_overlap'}  = $avgl;\n     $csp->{'_avg_identity'} = $avgid;\n     $csp->{'_nof_overlaps'} = $nover;\n  }\n  # 3: Set sequence statistics: nof_seq and avg_seq_len\n  my ($nseq, $avgseql) = $self->_get_seq_stats($assemblyobj);\n  $csp->{'_avg_seq_len'} = $avgseql;\n  $csp->{'_nof_seq'}     = $nseq;\n  # 4: Set the spectrum: spectrum and max_size\n  for my $contigobj ($assemblyobj->all_contigs) {\n    my $size = $contigobj->num_sequences;\n    if (defined $csp->{'_spectrum'}{$size}) {\n      $csp->{'_spectrum'}{$size}++;\n    } else {\n      $csp->{'_spectrum'}{$size} = 1;\n    }\n    $csp->{'_max_size'} = $size if $size > $csp->{'_max_size'};\n  }\n  my $nof_singlets = $assemblyobj->get_nof_singlets();\n  if (defined $nof_singlets) {\n    $csp->{'_spectrum'}{1} += $nof_singlets;\n    $csp->{'_max_size'} = 1 if $nof_singlets >= 1 && $csp->{'_max_size'} < 1;\n  }\n  # 5: Set list of assembly objects used\n  push @{$csp->{'_assembly'}}, $assemblyobj;\n  # 6: Set number of repetitions\n  $csp->{'_nof_rep'} = 1;\n  return $csp;\n}\n\n\n\n=head2 _new_dissolved_csp\n\n  Title   : \n  Usage   : create a dissolved contig spectrum object\n  Function: \n  Returns : \n  Args    : ","parameters":[{"label":"$self"},{"label":"$mixed_csp"},{"label":"$seq_header"}],"label":"_new_dissolved_csp($self,$mixed_csp,$seq_header)"},"containerName":"main::","definition":"sub","range":{"end":{"line":1026,"character":9999},"start":{"character":0,"line":1005}},"name":"_new_dissolved_csp"},{"name":"$self","containerName":null,"kind":13,"line":1027},{"containerName":"main::","name":"throw","kind":12,"line":1027},{"localvar":"my","containerName":null,"definition":"my","name":"$dissolved","line":1032,"kind":13},{"line":1032,"kind":12,"name":"Bio","containerName":"Assembly::Tools::ContigSpectrum"},{"name":"new","containerName":"main::","kind":12,"line":1032},{"name":"%self","containerName":null,"line":1035,"kind":13},{"containerName":null,"name":"%dissolved","kind":13,"line":1036},{"name":"%self","containerName":null,"line":1036,"kind":13},{"line":1038,"kind":13,"containerName":null,"name":"%dissolved"},{"kind":13,"line":1038,"containerName":null,"name":"%mixed_csp"},{"line":1040,"kind":13,"name":"%self","containerName":null},{"containerName":null,"name":"%self","line":1040,"kind":13},{"kind":13,"line":1041,"containerName":null,"name":"%dissolved"},{"name":"%dissolved","containerName":null,"kind":13,"line":1041},{"name":"%self","containerName":null,"line":1042,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":1042},{"name":"%dissolved","containerName":null,"line":1044,"kind":13},{"containerName":null,"name":"%dissolved","line":1044,"kind":13},{"line":1045,"kind":13,"name":"%mixed_csp","containerName":null},{"name":"%mixed_csp","containerName":null,"kind":13,"line":1045},{"kind":13,"line":1049,"containerName":null,"definition":"my","name":"$assembly","localvar":"my"},{"line":1049,"kind":13,"name":"%mixed_csp","containerName":null},{"localvar":"my","name":"%asm_spectrum","definition":"my","containerName":null,"line":1051,"kind":13},{"line":1052,"kind":13,"localvar":"my","name":"%good_seqs","definition":"my","containerName":null},{"kind":13,"line":1054,"name":"$contig","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":1054,"containerName":null,"name":"$assembly"},{"name":"all_contigs","containerName":"main::","kind":12,"line":1054},{"kind":13,"line":1056,"name":"@contig_seqs","definition":"my","containerName":null,"localvar":"my"},{"line":1057,"kind":13,"localvar":"my","name":"$seq","definition":"my","containerName":null},{"line":1057,"kind":13,"name":"$contig","containerName":null},{"name":"each_seq","containerName":"main::","kind":12,"line":1057},{"containerName":null,"definition":"my","name":"$seq_id","localvar":"my","kind":13,"line":1058},{"containerName":null,"name":"$seq","line":1058,"kind":13},{"containerName":"main::","name":"id","line":1058,"kind":12},{"containerName":null,"name":"$seq_id","kind":13,"line":1060},{"containerName":null,"name":"@contig_seqs","kind":13,"line":1062},{"name":"$seq_id","containerName":null,"kind":13,"line":1062},{"containerName":null,"name":"%good_seqs","line":1063,"kind":13},{"containerName":null,"name":"$seq_id","kind":13,"line":1063},{"line":1066,"kind":13,"localvar":"my","definition":"my","name":"$size","containerName":null},{"kind":13,"line":1066,"name":"@contig_seqs","containerName":null},{"containerName":null,"name":"%size","line":1067,"kind":13},{"name":"%size","containerName":null,"line":1069,"kind":13},{"line":1070,"kind":13,"containerName":null,"name":"%asm_spectrum"},{"kind":13,"line":1071,"containerName":null,"name":"%size"},{"line":1073,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$contig_spectrum"},{"name":"$dissolved","containerName":null,"line":1073,"kind":13},{"containerName":"main::","name":"_naive_assembler","kind":12,"line":1073},{"containerName":null,"name":"$contig","line":1074,"kind":13},{"line":1074,"kind":13,"containerName":null,"name":"@contig_seqs"},{"line":1074,"kind":13,"name":"%dissolved","containerName":null},{"line":1075,"kind":13,"containerName":null,"name":"%dissolved"},{"kind":13,"line":1077,"containerName":null,"name":"$qsize","definition":"my","localvar":"my"},{"kind":13,"line":1077,"containerName":null,"name":"%contig_spectrum"},{"containerName":null,"name":"%asm_spectrum","line":1078,"kind":13},{"kind":13,"line":1078,"containerName":null,"name":"$qsize"},{"name":"contig_spectrum","line":1078,"kind":12},{"kind":13,"line":1078,"name":"%qsize","containerName":null},{"kind":13,"line":1081,"containerName":null,"name":"$self"},{"kind":12,"line":1081,"name":"throw","containerName":"main::"},{"containerName":null,"name":"$singlet","definition":"my","localvar":"my","kind":13,"line":1085},{"name":"$assembly","containerName":null,"kind":13,"line":1085},{"line":1085,"kind":12,"name":"all_singlets","containerName":"main::"},{"kind":13,"line":1086,"name":"$seq_id","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":1086,"name":"$singlet","containerName":null},{"line":1086,"kind":12,"containerName":"main::","name":"seqref"},{"name":"id","containerName":"main::","line":1086,"kind":12},{"line":1088,"kind":13,"containerName":null,"name":"$seq_id"},{"line":1090,"kind":13,"containerName":null,"name":"%good_seqs"},{"name":"$seq_id","containerName":null,"line":1090,"kind":13},{"kind":13,"line":1092,"containerName":null,"name":"%asm_spectrum"},{"kind":13,"line":1095,"containerName":null,"name":"$dissolved"},{"line":1095,"kind":12,"containerName":"main::","name":"_import_spectrum"},{"name":"%asm_spectrum","containerName":null,"kind":13,"line":1095},{"name":"%dissolved","containerName":null,"line":1097,"kind":13},{"name":"%dissolved","containerName":null,"line":1098,"kind":13},{"kind":13,"line":1098,"name":"%mixed_csp","containerName":null},{"localvar":"my","definition":"my","name":"$nseq","containerName":null,"line":1101,"kind":13},{"name":"$avgseql","containerName":null,"kind":13,"line":1101},{"containerName":null,"name":"$dissolved","kind":13,"line":1101},{"name":"_get_seq_stats","containerName":"main::","kind":12,"line":1101},{"kind":13,"line":1101,"name":"$assembly","containerName":null},{"kind":13,"line":1101,"containerName":null,"name":"%good_seqs"},{"kind":13,"line":1102,"name":"%dissolved","containerName":null},{"kind":13,"line":1102,"name":"$avgseql","containerName":null},{"containerName":null,"name":"%dissolved","kind":13,"line":1103},{"containerName":null,"name":"$nseq","line":1103,"kind":13},{"kind":13,"line":1106,"containerName":null,"name":"%dissolved"},{"localvar":"my","name":"$nover","definition":"my","containerName":null,"line":1107,"kind":13},{"line":1107,"kind":13,"name":"$minl","containerName":null},{"name":"$avgl","containerName":null,"kind":13,"line":1107},{"name":"$minid","containerName":null,"kind":13,"line":1107},{"name":"$avgid","containerName":null,"kind":13,"line":1107},{"line":1108,"kind":13,"containerName":null,"name":"$dissolved"},{"line":1108,"kind":12,"containerName":"main::","name":"_get_overlap_stats"},{"line":1108,"kind":13,"name":"$assembly","containerName":null},{"name":"%good_seqs","containerName":null,"line":1108,"kind":13},{"line":1109,"kind":13,"containerName":null,"name":"%dissolved"},{"name":"$minl","containerName":null,"line":1109,"kind":13},{"name":"%dissolved","containerName":null,"line":1110,"kind":13},{"line":1110,"kind":13,"containerName":null,"name":"$minid"},{"name":"%dissolved","containerName":null,"line":1111,"kind":13},{"kind":13,"line":1111,"name":"$avgl","containerName":null},{"name":"%dissolved","containerName":null,"kind":13,"line":1112},{"kind":13,"line":1112,"name":"$avgid","containerName":null},{"kind":13,"line":1113,"name":"%dissolved","containerName":null},{"kind":13,"line":1113,"name":"$nover","containerName":null},{"containerName":null,"name":"$dissolved","line":1117,"kind":13},{"children":[{"line":1133,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_new_cross_csp"},{"line":1133,"kind":13,"containerName":"_new_cross_csp","name":"$mixed_csp"},{"kind":13,"line":1136,"name":"$mixed_csp","containerName":"_new_cross_csp"},{"line":1137,"kind":13,"containerName":"_new_cross_csp","name":"$mixed_csp"}],"line":1132,"kind":12,"signature":{"label":"_new_cross_csp($self,$mixed_csp)","documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none\n\n\nsub drop_assembly {\n  my ($self) = @_;\n  $self->{'_assembly'} = [];\n  return 1;\n}\n\n=head2 dissolve\n\n  Title   : dissolve\n  Usage   : $dissolved_csp->dissolve($mixed_csp, $seq_header);\n  Function: Dissolve a mixed contig spectrum for the set of sequences that\n            contain the specified header, i.e. determine the contribution of\n            these sequences to the mixed contig spectrum based on the assembly.\n            The mixed contig spectrum object must have been created based on one\n            (or several) assembly object(s). Additionally, min_overlap and\n            min_identity must have been set (either manually using min_overlap\n            or automatically by switching on the eff_asm_params option).\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n            sequence header string\n\n\n\nsub dissolve {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  $self->_import_dissolved_csp($mixed_csp, $seq_header);\n  return 1;\n}\n\n\n=head2 cross\n\n  Title   : cross\n  Usage   : $cross_csp->cross($mixed_csp);\n  Function: Calculate a cross contig_spectrum based on a mixed contig_spectrum.\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n\n\nsub cross {\n  my ($self, $mixed_csp) = @_;\n  $self->_import_cross_csp($mixed_csp);\n  return 1;\n}\n\n=head2 to_string\n\n  Title   : to_string\n  Usage   : my $csp_string = $csp->to_string;\n  Function: Convert the contig spectrum into a string (easy to print!!).\n  Returns : string\n  Args    : element separator (integer) [optional]\n              1 -> space-separated\n              2 -> tab-separated\n              3 -> newline-separated\n\n\nsub to_string {\n  my ($self, $element_separator) = @_;\n  return 0 if $self->{'_max_size'} == 0;\n  $element_separator ||= 1;\n  if ($element_separator == 1) {\n    $element_separator = ' ';\n  } elsif ($element_separator == 2) {\n    $element_separator = \"\\t\";\n  } elsif ($element_separator == 3) {\n    $element_separator = \"\\n\";\n  } else {\n    $self->throw(\"Unknown separator type '$element_separator'\\n\");\n  }\n  my $str = '';\n  for (my $q = 1 ; $q <= $self->{'_max_size'} ; $q++) {\n    my $val = 0;\n    if (exists $self->{'_spectrum'}{$q}) {\n      $val = $self->{'_spectrum'}{$q};\n    }\n    $str .= $val.$element_separator;\n  }\n  $str =~ s/\\s$//;\n  return $str;\n}\n\n\n=head2 add\n\n  Title   : add\n  Usage   : $csp->add($additional_csp);\n  Function: Add a contig spectrum to an existing one: sums the spectra, update\n            the number of sequences, number of repetitions, ...\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum object\n\n\nsub add {\n  my ($self, $csp) = @_;\n  # Sanity check\n  if( !ref $csp || ! $csp->isa('Bio::Assembly::Tools::ContigSpectrum') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n  }\n  # Update overlap statistics\n  if ( $self->{'_eff_asm_params'} > 0 ) {\n    # Warnings\n    if ( $csp->{'_eff_asm_params'} == 0 ) {\n      $self->warn(\"The parent contig spectrum needs effective assembly \".\n        \"parameters (eff_asm_params = \".$self->{'_eff_asm_params'}.\") but the \".\n        \"child contig spectrum doesn't have them (eff_asm_params = \".\n        $csp->{'_eff_asm_params'}.\"). Skipping them...\");\n    } elsif ( $csp->{'_eff_asm_params'} != $self->{'_eff_asm_params'} ) {\n      $self->warn(\"The parent contig spectrum needs a different method for \".\n        \"detecting the effective assembly parameters (eff_asm_params = \".\n        $self->{'_eff_asm_params'}.\") than the one specified for the child \".\n        \"contig spectrum (eff_asm_params = \".$csp->{'_eff_asm_params'}.\"). \".\n        \"Ignoring the differences...\");\n    }\n    # Update existing stats\n    my $tot_num_overlaps = $csp->{'_nof_overlaps'} + $self->{'_nof_overlaps'};\n    $self->{'_min_overlap'} = $csp->{'_min_overlap'} if\n      defined $csp->{'_min_overlap'} && ( ! defined $self->{'_min_overlap'} ||\n      $csp->{'_min_overlap'} < $self->{'_min_overlap'} );\n    $self->{'_min_identity'} = $csp->{'_min_identity'} if\n      defined $csp->{'_min_identity'} && ( ! defined $self->{'_min_identity'} ||\n      $csp->{'_min_identity'} < $self->{'_min_identity'} );\n    if ($tot_num_overlaps != 0) {\n      $self->{'_avg_overlap'} =\n        ($csp->{'_avg_overlap'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_overlap'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n      $self->{'_avg_identity'} =\n        ($csp->{'_avg_identity'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_identity'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n    }\n    $self->{'_nof_overlaps'} = $tot_num_overlaps;\n  }\n  # Update sequence statistics\n  my $tot_nof_seq = $csp->{'_nof_seq'} + $self->{'_nof_seq'};\n  if (not $tot_nof_seq == 0) {\n    $self->{'_avg_seq_len'} = ($csp->{'_avg_seq_len'} * $csp->{'_nof_seq'} +\n      $self->{'_avg_seq_len'} * $self->{'_nof_seq'}) / $tot_nof_seq;\n  }\n  # Update spectrum (and nof_seq, max_size, and increment nof_rep by 1)\n  $self->_import_spectrum($csp->{'_spectrum'});\n  # Update nof_rep\n  $self->{'_nof_rep'}--;\n  $self->{'_nof_rep'} += $csp->{'_nof_rep'};\n  # Update list of assembly objects used\n  push @{$self->{'_assembly'}}, @{$csp->{'_assembly'}}\n    if defined $csp->{'_assembly'};\n  return 1;\n}\n\n\n=head2 average\n\n  Title   : average\n  Usage   : my $avg_csp = $csp->average([$csp1, $csp2, $csp3]);\n  Function: Average one contig spectrum or the sum of several contig spectra by\n            the number of repetitions\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Tools::ContigSpectrum array reference\n            eff_asm_params\n\n\nsub average {\n  my ($self, $list) = @_;\n  # Sanity check\n  if ( ! ref $list || ! ref $list eq 'ARRAY') {\n    $self->throw(\"Average takes an array reference but got [\".ref($list).\"]\");\n  }\n  # New average contig spectrum object\n  my $avg = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg->{'_eff_asm_params'} = 1;\n  \n  # Cycle through contig spectra\n  my $tot_nof_rep = 0;\n  for my $csp (@$list) {\n    # Sanity check\n    if (not $csp->isa('Bio::Assembly::Tools::ContigSpectrum')) {\n      $csp->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n    }\n    # Import contig spectrum\n    $avg->add($csp);\n  }\n  \n  # Average sum of contig spectra by number of repetitions\n  for (my $q = 1 ; $q <= $avg->{'_max_size'} ; $q++) {\n    $avg->{'_spectrum'}{$q} /= $avg->{'_nof_rep'}\n      if (defined $avg->{'_spectrum'}{$q});\n  }\n  # Average number of sequences\n  $avg->{'_nof_seq'} /= $avg->{'_nof_rep'};\n  # Average number of overlaps\n  $avg->{'_nof_overlaps'} /= $avg->{'_nof_rep'};\n  \n  return $avg;\n}\n\n\n=head2 score\n\n  Title   : score\n  Usage   : my $score = $csp->score();\n  Function: Score a contig spectrum (or cross-contig spectrum) such that the\n             higher the number of contigs (or cross-contigs) and the larger their \n             size, the higher the score.\n             Let n   : total number of sequences\n                 c_q : number of contigs of size q\n                 q   : number of sequence in a contig\n             We define: score = n/(n-1) * (X - 1/n)\n                  where X = sum ( c_q * q^2 ) / n**2\n             The score ranges from 0 (singlets only) to 1 (a single large contig)\n             It is possible to specify a value for the number of sequences to\n              assume in the contig spectrum.\n  Returns : contig score\n  Args    : number of total sequences to assume [optional]\n\n\nsub score {\n  my ($self, $nof_seqs) = @_;\n  # Main\n  my $score = 0;\n  my $n = $self->nof_seq;\n  if ( $n > 0 ) {\n    # Contig spectrum info\n    my $q_max = $self->max_size;\n    my $spec  = $self->spectrum;\n    # Adjust number of 1-contigs\n    if ( $nof_seqs ) {\n      $spec->{'1'} += $nof_seqs - $n;\n      $n = $nof_seqs;\n    }\n    # Calculate X\n    for my $q ( 1 .. $q_max ) {\n      if ( $spec->{$q} ) {\n        my $c_q = $spec->{$q};\n        $score += $c_q * $q ** 2;\n      }\n    }\n    $score /= $n ** 2; \n  }\n  # Rescale X to obtain the score\n  $score = $n/($n-1) * ($score - 1/$n);\n  return $score;\n}\n\n\n=head2 _naive_assembler\n\n  Title   : _naive_assembler\n  Usage   : \n  Function: Determines the contig spectrum (hash representation) of a subset of\n            sequences from a mixed contig spectrum by \"reassembling\" the\n            specified sequences only based on their position in the contig. This\n            naive assembly only verifies that the minimum overlap length and\n            percentage identity are respected. There is no actual alignment done\n  Returns : contig spectrum hash reference\n  Args    : Bio::Assembly::Contig\n            sequence ID array reference\n            minimum overlap length (integer) [optional]\n            minimum percentage identity (integer) [optional]\n\n\nsub _naive_assembler {\n  my ($self, $contig, $seqlist, $min_overlap, $min_identity) = @_;\n  # Sanity checks\n  if ( ! ref $seqlist || ! ref($seqlist) eq 'ARRAY') {\n    $self->throw('Expecting an array reference. Got ['.ref($seqlist).\"] \\n\");\n  }\n  my $max = scalar @$seqlist;\n  $self->throw(\"Expecting at least 2 sequences as input for _naive_assembler\")\n    if ($max < 2);\n  # Assembly\n  my %spectrum = (1 => 0);\n  my %overlap_map;\n  my %has_overlap;\n  # Map what sequences overlap with what sequences\n  for (my $i = 0 ; $i < $max-1 ; $i++) {\n    # query sequence\n    my $qseqid = $$seqlist[$i];\n    my $qseq   = $contig->get_seq_by_name($qseqid);\n    my $is_singlet = 1;\n    for (my $j = $i+1 ; $j < $max ; $j++) {\n      # target sequence\n      my $tseqid = $$seqlist[$j];\n      my $tseq = $contig->get_seq_by_name($tseqid);\n      # try to align sequences\n      my ($aln, $overlap, $identity)\n        = $self->_overlap_alignment($contig, $qseq, $tseq, $min_overlap,\n        $min_identity);\n      # if there is no valid overlap, go to next sequence\n      next if ! defined $aln;\n      # the overlap is valid\n      $is_singlet = 0;\n      push @{$overlap_map{$qseqid}}, $tseqid;\n      $has_overlap{$tseqid} = 1;\n      $has_overlap{$qseqid} = 1;\n    }\n    # check if sequence is in previously seen overlap\n    if (exists $has_overlap{$qseqid}) {\n      $is_singlet = 0;\n    }\n    if ($is_singlet == 1) {\n      $spectrum{1}++;\n    }\n  }\n  # take care of last sequence\n  my $last_is_singlet = 1;\n  if (exists $has_overlap{$$seqlist[$max-1]}) {\n    $last_is_singlet = 0;\n  }\n  if ($last_is_singlet == 1) {\n    $spectrum{1}++;\n  }\n  # Parse overlap map\n  for my $seqid (@$seqlist) {\n    # list of sequences that should go in the contig\n    next if not exists $overlap_map{$seqid};\n    my @overlist = @{$overlap_map{$seqid}};\n    for (my $j = 0 ; $j < scalar(@overlist) ; $j++) {\n      my $otherseqid = $overlist[$j];\n      if (exists $overlap_map{$otherseqid}) {\n        push @overlist, @{$overlap_map{$otherseqid}};\n        delete $overlap_map{$otherseqid};\n      }\n    }\n    # remove duplicates from list\n    @overlist = sort @overlist;\n    for (my $j = 0 ; $j < scalar(@overlist)-1 ; $j++) {\n      if ( $overlist[$j] eq $overlist[$j+1] ) {\n        splice @overlist, $j, 1;\n        $j--;\n      }\n    }\n    # update spectrum with size of contig\n    my $qsize = scalar(@overlist) + 1;\n    if (defined $spectrum{$qsize}) {\n      $spectrum{$qsize}++;\n    } else {\n      $spectrum{$qsize} = 1;\n    }\n  }\n  return \\%spectrum;\n}\n\n\n=head2 _new_from_assembly\n\n  Title   : _new_from_assembly\n  Usage   : \n  Function: Creates a new contig spectrum object based solely on the result of \n            an assembly\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Scaffold\n\n\nsub _new_from_assembly {\n  # Create new contig spectrum object based purely on what we can get from the\n  # assembly object\n  my ($self, $assemblyobj) = @_;\n  my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n  # 1: Set id\n  $csp->{'_id'} = $assemblyobj->id;\n  # 2: Set overlap statistics: nof_overlaps, min_overlap, avg_overlap,\n  #  min_identity and avg_identity\n  $csp->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  if ($csp->{'_eff_asm_params'} > 0) {\n     my ($nover, $minl, $avgl, $minid, $avgid)\n       = $csp->_get_overlap_stats($assemblyobj);\n     $csp->{'_min_overlap'}  = $minl;\n     $csp->{'_min_identity'} = $minid;\n     $csp->{'_avg_overlap'}  = $avgl;\n     $csp->{'_avg_identity'} = $avgid;\n     $csp->{'_nof_overlaps'} = $nover;\n  }\n  # 3: Set sequence statistics: nof_seq and avg_seq_len\n  my ($nseq, $avgseql) = $self->_get_seq_stats($assemblyobj);\n  $csp->{'_avg_seq_len'} = $avgseql;\n  $csp->{'_nof_seq'}     = $nseq;\n  # 4: Set the spectrum: spectrum and max_size\n  for my $contigobj ($assemblyobj->all_contigs) {\n    my $size = $contigobj->num_sequences;\n    if (defined $csp->{'_spectrum'}{$size}) {\n      $csp->{'_spectrum'}{$size}++;\n    } else {\n      $csp->{'_spectrum'}{$size} = 1;\n    }\n    $csp->{'_max_size'} = $size if $size > $csp->{'_max_size'};\n  }\n  my $nof_singlets = $assemblyobj->get_nof_singlets();\n  if (defined $nof_singlets) {\n    $csp->{'_spectrum'}{1} += $nof_singlets;\n    $csp->{'_max_size'} = 1 if $nof_singlets >= 1 && $csp->{'_max_size'} < 1;\n  }\n  # 5: Set list of assembly objects used\n  push @{$csp->{'_assembly'}}, $assemblyobj;\n  # 6: Set number of repetitions\n  $csp->{'_nof_rep'} = 1;\n  return $csp;\n}\n\n\n\n=head2 _new_dissolved_csp\n\n  Title   : \n  Usage   : create a dissolved contig spectrum object\n  Function: \n  Returns : \n  Args    : \n\n\n\nsub _new_dissolved_csp {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  # Sanity checks on the mixed contig spectrum\n\n  # min_overlap and min_identity must be specified if there are some overlaps\n  # in the mixed contig\n  unless ($mixed_csp->{'_nof_overlaps'} == 0) {\n    unless ( defined $self->{'_min_overlap'} || \n      defined $mixed_csp->{'_min_overlap'} ) {\n      $self->throw(\"min_overlap must be defined in the dissolved contig spectrum\".\n        \" or mixed contig spectrum to dissolve a contig\");\n    }\n    unless ( defined $self->{'_min_identity'} ||\n      defined $mixed_csp->{'_min_identity'} ) {\n      $self->throw(\"min_identity must be defined in the dissolved contig spectrum\".\n        \" or mixed contig spectrum\");\n    }\n  }\n  \n  # there must be at least one assembly in mixed contig spectrum\n  if (!defined $mixed_csp->{'_assembly'} ||\n      scalar @{$mixed_csp->{'_assembly'}} < 1) {\n    $self->throw(\"The mixed contig spectrum must be based on at least one\n    assembly\");\n  }\n\n  # New dissolved contig spectrum object\n  my $dissolved = Bio::Assembly::Tools::ContigSpectrum->new();\n  \n  # take parent attributes if existent or mixed attributes otherwise\n  if ($self->{'_eff_asm_params'}) {\n    $dissolved->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  } else {\n    $dissolved->{'_eff_asm_params'} = $mixed_csp->{'_eff_asm_params'};\n  }\n  if ($self->{'_min_overlap'} && $self->{'_min_identity'}) {\n    ( $dissolved->{'_min_overlap'}, $dissolved->{'_min_identity'} ) = \n      ( $self->{'_min_overlap'}, $self->{'_min_identity'} );\n  } else {\n    ( $dissolved->{'_min_overlap'}, $dissolved->{'_min_identity'} ) = \n      ( $mixed_csp->{'_min_overlap'}, $mixed_csp->{'_min_identity'} );\n  }\n  \n  # Dissolve each assembly\n  for my $assembly (@{$mixed_csp->{'_assembly'}}) {\n    # Dissolve this assembly for the given sequences\n    my %asm_spectrum = (1 => 0);\n    my %good_seqs;\n    # For each contig\n    for my $contig ($assembly->all_contigs) {\n      # Get good sequences\n      my @contig_seqs;\n      for my $seq ($contig->each_seq) {\n        my $seq_id = $seq->id;\n        # get sequence origin\n        next unless $seq_id =~ m/^$seq_header\\|/;\n        # add it to hash\n        push @contig_seqs, $seq_id;\n        $good_seqs{$seq_id} = 1;\n      }\n      # Update spectrum\n      my $size = scalar @contig_seqs;\n      if ($size == 0) {\n        next;\n      } elsif ($size == 1) {\n        $asm_spectrum{1}++;\n      } elsif ($size > 1) {\n        # Reassemble good sequences\n        my $contig_spectrum = $dissolved->_naive_assembler(\n          $contig, \\@contig_seqs, $dissolved->{'_min_overlap'},\n          $dissolved->{'_min_identity'});\n        # update spectrum\n        for my $qsize (keys %$contig_spectrum) {\n          $asm_spectrum{$qsize} += $$contig_spectrum{$qsize};\n        }\n      } else {\n        $self->throw(\"The size is not valid... how could that happen?\");\n      }\n    }\n    # For each singlet\n    for my $singlet ($assembly->all_singlets) {\n      my $seq_id = $singlet->seqref->id;\n      # get sequence origin\n      next unless $seq_id =~ m/^$seq_header\\|/;\n      # add it to hash\n      $good_seqs{$seq_id} = 1;\n      # update spectrum\n      $asm_spectrum{1}++;\n    }\n    # Update spectrum\n    $dissolved->_import_spectrum(\\%asm_spectrum);\n    # Update nof_rep\n    $dissolved->{'_nof_rep'}--;\n    $dissolved->{'_nof_rep'} += $mixed_csp->{'_nof_rep'};\n\n    # Get sequence stats\n    my ($nseq, $avgseql) = $dissolved->_get_seq_stats($assembly, \\%good_seqs);\n    $dissolved->{'_avg_seq_len'} = $avgseql;\n    $dissolved->{'_nof_seq'}     = $nseq;\n  \n    # Get eff_asm_param for these sequences\n    if ($dissolved->{'_eff_asm_params'} > 0) {\n      my ($nover, $minl, $avgl, $minid, $avgid)\n        = $dissolved->_get_overlap_stats($assembly, \\%good_seqs);\n      $dissolved->{'_min_overlap'}  = $minl;\n      $dissolved->{'_min_identity'} = $minid;\n      $dissolved->{'_avg_overlap'}  = $avgl;\n      $dissolved->{'_avg_identity'} = $avgid;\n      $dissolved->{'_nof_overlaps'} = $nover;\n    }\n\n  }\n  return $dissolved;\n}\n\n\n=head2 _new_cross_csp\n\n  Title   : \n  Usage   : \n  Function: create a cross contig spectrum object\n  Returns : \n  Args    : ","parameters":[{"label":"$self"},{"label":"$mixed_csp"}]},"detail":"($self,$mixed_csp)","definition":"sub","containerName":"main::","range":{"start":{"line":1132,"character":0},"end":{"character":9999,"line":1137}},"name":"_new_cross_csp"},{"line":1138,"kind":13,"containerName":null,"name":"$self"},{"name":"throw","containerName":"main::","kind":12,"line":1138},{"containerName":null,"name":"$cross","definition":"my","localvar":"my","kind":13,"line":1143},{"name":"Bio","containerName":"Assembly::Tools::ContigSpectrum","kind":12,"line":1143},{"name":"new","containerName":"main::","kind":12,"line":1143},{"line":1144,"kind":13,"localvar":"my","name":"%spectrum","definition":"my","containerName":null},{"kind":13,"line":1147,"name":"%self","containerName":null},{"kind":13,"line":1148,"name":"%cross","containerName":null},{"name":"%self","containerName":null,"kind":13,"line":1148},{"kind":13,"line":1150,"name":"%cross","containerName":null},{"kind":13,"line":1150,"containerName":null,"name":"%mixed_csp"},{"containerName":null,"name":"%self","line":1152,"kind":13},{"kind":13,"line":1152,"containerName":null,"name":"%self"},{"line":1153,"kind":13,"containerName":null,"name":"%cross"},{"line":1153,"kind":13,"name":"%cross","containerName":null},{"kind":13,"line":1154,"containerName":null,"name":"%self"},{"containerName":null,"name":"%self","kind":13,"line":1154},{"containerName":null,"name":"%cross","line":1156,"kind":13},{"kind":13,"line":1156,"containerName":null,"name":"%cross"},{"kind":13,"line":1157,"name":"%mixed_csp","containerName":null},{"containerName":null,"name":"%mixed_csp","kind":13,"line":1157},{"localvar":"my","containerName":null,"definition":"my","name":"$assembly","line":1161,"kind":13},{"line":1161,"kind":13,"name":"%mixed_csp","containerName":null},{"line":1163,"kind":13,"localvar":"my","containerName":null,"name":"%good_seqs","definition":"my"},{"line":1164,"kind":13,"localvar":"my","name":"$contig","definition":"my","containerName":null},{"containerName":null,"name":"$assembly","line":1164,"kind":13},{"containerName":"main::","name":"all_contigs","line":1164,"kind":12},{"line":1166,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@seq_origins"},{"line":1167,"kind":13,"localvar":"my","name":"@seq_ids","definition":"my","containerName":null},{"kind":13,"line":1168,"containerName":null,"definition":"my","name":"$seq","localvar":"my"},{"kind":13,"line":1168,"name":"$contig","containerName":null},{"name":"each_seq","containerName":"main::","kind":12,"line":1168},{"line":1170,"kind":13,"localvar":"my","name":"$seq_id","definition":"my","containerName":null},{"line":1170,"kind":13,"name":"$seq","containerName":null},{"containerName":"main::","name":"id","line":1170,"kind":12},{"line":1171,"kind":13,"name":"$seq_id","containerName":null},{"line":1172,"kind":13,"localvar":"my","definition":"my","name":"$seq_header","containerName":null},{"name":"$self","containerName":null,"line":1173,"kind":13},{"name":"warn","containerName":"main::","kind":12,"line":1173},{"line":1174,"kind":13,"containerName":null,"name":"$seq_header"},{"containerName":null,"name":"$seq_header","kind":13,"line":1175},{"name":"@seq_origins","containerName":null,"line":1176,"kind":13},{"line":1176,"kind":13,"name":"$seq_header","containerName":null},{"name":"@seq_ids","containerName":null,"kind":13,"line":1177},{"name":"$seq_id","containerName":null,"line":1177,"kind":13},{"localvar":"my","containerName":null,"name":"$qsize","definition":"my","line":1179,"kind":13},{"line":1179,"kind":13,"name":"@seq_ids","containerName":null},{"name":"@origins","definition":"my","containerName":null,"localvar":"my","kind":13,"line":1180},{"containerName":null,"name":"$a","kind":13,"line":1180},{"name":"$b","containerName":null,"kind":13,"line":1180},{"line":1180,"kind":13,"name":"@seq_origins","containerName":null},{"line":1181,"kind":13,"localvar":"my","name":"$size","definition":"my","containerName":null},{"line":1181,"kind":13,"containerName":null,"name":"@origins"},{"line":1182,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":null},{"containerName":null,"name":"$i","line":1182,"kind":13},{"name":"$size","containerName":null,"kind":13,"line":1182},{"line":1182,"kind":13,"containerName":null,"name":"%i"},{"name":"@origins","containerName":null,"line":1183,"kind":13},{"line":1183,"kind":13,"containerName":null,"name":"$i"},{"containerName":null,"name":"@origins","kind":13,"line":1183},{"kind":13,"line":1183,"containerName":null,"name":"%i"},{"line":1184,"kind":13,"containerName":null,"name":"@origins"},{"containerName":null,"name":"$i","line":1184,"kind":13},{"containerName":null,"name":"$i","kind":13,"line":1185},{"line":1186,"kind":13,"containerName":null,"name":"$size"},{"kind":13,"line":1190,"containerName":null,"name":"%size"},{"localvar":"my","containerName":null,"name":"$seq_id","definition":"my","line":1192,"kind":13},{"containerName":null,"name":"@seq_ids","kind":13,"line":1192},{"kind":13,"line":1193,"name":"%good_seqs","containerName":null},{"kind":13,"line":1193,"name":"$seq_id","containerName":null},{"containerName":null,"name":"%spectrum","kind":13,"line":1196},{"line":1196,"kind":13,"name":"%qsize","containerName":null},{"name":"%spectrum","containerName":null,"kind":13,"line":1197},{"containerName":null,"name":"%qsize","line":1197,"kind":13},{"name":"%spectrum","containerName":null,"kind":13,"line":1199},{"line":1199,"kind":13,"containerName":null,"name":"$qsize"},{"name":"%size","containerName":null,"line":1203,"kind":13},{"kind":13,"line":1204,"definition":"my","name":"$origin","containerName":null,"localvar":"my"},{"containerName":null,"name":"@origins","kind":13,"line":1204},{"localvar":"my","containerName":null,"definition":"my","name":"@ids","line":1206,"kind":13},{"containerName":null,"name":"$i","definition":"my","localvar":"my","kind":13,"line":1207},{"kind":13,"line":1207,"name":"$i","containerName":null},{"kind":13,"line":1207,"containerName":null,"name":"$qsize"},{"name":"%i","containerName":null,"kind":13,"line":1207},{"kind":13,"line":1208,"containerName":null,"definition":"my","name":"$seq_origin","localvar":"my"},{"line":1208,"kind":13,"name":"@seq_origins","containerName":null},{"kind":13,"line":1208,"containerName":null,"name":"$i"},{"localvar":"my","definition":"my","name":"$seq_id","containerName":null,"line":1209,"kind":13},{"kind":13,"line":1209,"name":"@seq_ids","containerName":null},{"name":"$i","containerName":null,"kind":13,"line":1209},{"line":1210,"kind":13,"containerName":null,"name":"@ids"},{"containerName":null,"name":"$seq_id","line":1210,"kind":13},{"line":1210,"kind":13,"name":"$seq_origin","containerName":null},{"name":"$origin","containerName":null,"kind":13,"line":1210},{"kind":13,"line":1212,"name":"@ids","containerName":null},{"kind":13,"line":1213,"containerName":null,"name":"%spectrum"},{"name":"@ids","containerName":null,"kind":13,"line":1214},{"kind":13,"line":1215,"containerName":null,"name":"$contig_spectrum","definition":"my","localvar":"my"},{"containerName":null,"name":"$cross","kind":13,"line":1215},{"line":1215,"kind":12,"containerName":"main::","name":"_naive_assembler"},{"line":1216,"kind":13,"name":"$contig","containerName":null},{"line":1216,"kind":13,"containerName":null,"name":"@ids"},{"line":1216,"kind":13,"name":"%cross","containerName":null},{"line":1217,"kind":13,"name":"%cross","containerName":null},{"name":"%spectrum","containerName":null,"kind":13,"line":1218},{"kind":12,"line":1218,"name":"contig_spectrum"},{"name":"$self","containerName":null,"line":1220,"kind":13},{"containerName":"main::","name":"throw","kind":12,"line":1220},{"line":1226,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$nseq"},{"containerName":null,"name":"$avgseql","line":1226,"kind":13},{"name":"$cross","containerName":null,"kind":13,"line":1226},{"kind":12,"line":1226,"containerName":"main::","name":"_get_seq_stats"},{"name":"$assembly","containerName":null,"kind":13,"line":1226},{"containerName":null,"name":"%good_seqs","line":1226,"kind":13},{"line":1227,"kind":13,"containerName":null,"name":"%cross"},{"containerName":null,"name":"$avgseql","line":1227,"kind":13},{"kind":13,"line":1228,"containerName":null,"name":"%cross"},{"kind":13,"line":1228,"containerName":null,"name":"$nseq"},{"containerName":null,"name":"%cross","line":1230,"kind":13},{"name":"$nover","definition":"my","containerName":null,"localvar":"my","kind":13,"line":1231},{"kind":13,"line":1231,"name":"$minl","containerName":null},{"name":"$avgl","containerName":null,"line":1231,"kind":13},{"name":"$minid","containerName":null,"line":1231,"kind":13},{"line":1231,"kind":13,"containerName":null,"name":"$avgid"},{"kind":13,"line":1232,"name":"$cross","containerName":null},{"containerName":"main::","name":"_get_overlap_stats","kind":12,"line":1232},{"containerName":null,"name":"$assembly","line":1232,"kind":13},{"name":"%good_seqs","containerName":null,"kind":13,"line":1232},{"name":"%cross","containerName":null,"kind":13,"line":1233},{"name":"$minl","containerName":null,"line":1233,"kind":13},{"kind":13,"line":1234,"containerName":null,"name":"%cross"},{"line":1234,"kind":13,"containerName":null,"name":"$minid"},{"name":"%cross","containerName":null,"kind":13,"line":1235},{"kind":13,"line":1235,"containerName":null,"name":"$avgl"},{"kind":13,"line":1236,"containerName":null,"name":"%cross"},{"name":"$avgid","containerName":null,"line":1236,"kind":13},{"line":1237,"kind":13,"containerName":null,"name":"%cross"},{"kind":13,"line":1237,"name":"$nover","containerName":null},{"name":"$cross","containerName":null,"line":1241,"kind":13},{"name":"_import_spectrum","containerName":"main::","line":1241,"kind":12},{"kind":13,"line":1241,"containerName":null,"name":"%spectrum"},{"line":1243,"kind":13,"containerName":null,"name":"%cross"},{"kind":13,"line":1244,"containerName":null,"name":"%cross"},{"name":"%mixed_csp","containerName":null,"line":1244,"kind":13},{"containerName":null,"name":"$cross","line":1246,"kind":13},{"name":"_import_assembly","range":{"start":{"character":0,"line":1259},"end":{"character":9999,"line":1271}},"definition":"sub","containerName":"main::","signature":{"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none\n\n\nsub drop_assembly {\n  my ($self) = @_;\n  $self->{'_assembly'} = [];\n  return 1;\n}\n\n=head2 dissolve\n\n  Title   : dissolve\n  Usage   : $dissolved_csp->dissolve($mixed_csp, $seq_header);\n  Function: Dissolve a mixed contig spectrum for the set of sequences that\n            contain the specified header, i.e. determine the contribution of\n            these sequences to the mixed contig spectrum based on the assembly.\n            The mixed contig spectrum object must have been created based on one\n            (or several) assembly object(s). Additionally, min_overlap and\n            min_identity must have been set (either manually using min_overlap\n            or automatically by switching on the eff_asm_params option).\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n            sequence header string\n\n\n\nsub dissolve {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  $self->_import_dissolved_csp($mixed_csp, $seq_header);\n  return 1;\n}\n\n\n=head2 cross\n\n  Title   : cross\n  Usage   : $cross_csp->cross($mixed_csp);\n  Function: Calculate a cross contig_spectrum based on a mixed contig_spectrum.\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n\n\nsub cross {\n  my ($self, $mixed_csp) = @_;\n  $self->_import_cross_csp($mixed_csp);\n  return 1;\n}\n\n=head2 to_string\n\n  Title   : to_string\n  Usage   : my $csp_string = $csp->to_string;\n  Function: Convert the contig spectrum into a string (easy to print!!).\n  Returns : string\n  Args    : element separator (integer) [optional]\n              1 -> space-separated\n              2 -> tab-separated\n              3 -> newline-separated\n\n\nsub to_string {\n  my ($self, $element_separator) = @_;\n  return 0 if $self->{'_max_size'} == 0;\n  $element_separator ||= 1;\n  if ($element_separator == 1) {\n    $element_separator = ' ';\n  } elsif ($element_separator == 2) {\n    $element_separator = \"\\t\";\n  } elsif ($element_separator == 3) {\n    $element_separator = \"\\n\";\n  } else {\n    $self->throw(\"Unknown separator type '$element_separator'\\n\");\n  }\n  my $str = '';\n  for (my $q = 1 ; $q <= $self->{'_max_size'} ; $q++) {\n    my $val = 0;\n    if (exists $self->{'_spectrum'}{$q}) {\n      $val = $self->{'_spectrum'}{$q};\n    }\n    $str .= $val.$element_separator;\n  }\n  $str =~ s/\\s$//;\n  return $str;\n}\n\n\n=head2 add\n\n  Title   : add\n  Usage   : $csp->add($additional_csp);\n  Function: Add a contig spectrum to an existing one: sums the spectra, update\n            the number of sequences, number of repetitions, ...\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum object\n\n\nsub add {\n  my ($self, $csp) = @_;\n  # Sanity check\n  if( !ref $csp || ! $csp->isa('Bio::Assembly::Tools::ContigSpectrum') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n  }\n  # Update overlap statistics\n  if ( $self->{'_eff_asm_params'} > 0 ) {\n    # Warnings\n    if ( $csp->{'_eff_asm_params'} == 0 ) {\n      $self->warn(\"The parent contig spectrum needs effective assembly \".\n        \"parameters (eff_asm_params = \".$self->{'_eff_asm_params'}.\") but the \".\n        \"child contig spectrum doesn't have them (eff_asm_params = \".\n        $csp->{'_eff_asm_params'}.\"). Skipping them...\");\n    } elsif ( $csp->{'_eff_asm_params'} != $self->{'_eff_asm_params'} ) {\n      $self->warn(\"The parent contig spectrum needs a different method for \".\n        \"detecting the effective assembly parameters (eff_asm_params = \".\n        $self->{'_eff_asm_params'}.\") than the one specified for the child \".\n        \"contig spectrum (eff_asm_params = \".$csp->{'_eff_asm_params'}.\"). \".\n        \"Ignoring the differences...\");\n    }\n    # Update existing stats\n    my $tot_num_overlaps = $csp->{'_nof_overlaps'} + $self->{'_nof_overlaps'};\n    $self->{'_min_overlap'} = $csp->{'_min_overlap'} if\n      defined $csp->{'_min_overlap'} && ( ! defined $self->{'_min_overlap'} ||\n      $csp->{'_min_overlap'} < $self->{'_min_overlap'} );\n    $self->{'_min_identity'} = $csp->{'_min_identity'} if\n      defined $csp->{'_min_identity'} && ( ! defined $self->{'_min_identity'} ||\n      $csp->{'_min_identity'} < $self->{'_min_identity'} );\n    if ($tot_num_overlaps != 0) {\n      $self->{'_avg_overlap'} =\n        ($csp->{'_avg_overlap'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_overlap'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n      $self->{'_avg_identity'} =\n        ($csp->{'_avg_identity'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_identity'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n    }\n    $self->{'_nof_overlaps'} = $tot_num_overlaps;\n  }\n  # Update sequence statistics\n  my $tot_nof_seq = $csp->{'_nof_seq'} + $self->{'_nof_seq'};\n  if (not $tot_nof_seq == 0) {\n    $self->{'_avg_seq_len'} = ($csp->{'_avg_seq_len'} * $csp->{'_nof_seq'} +\n      $self->{'_avg_seq_len'} * $self->{'_nof_seq'}) / $tot_nof_seq;\n  }\n  # Update spectrum (and nof_seq, max_size, and increment nof_rep by 1)\n  $self->_import_spectrum($csp->{'_spectrum'});\n  # Update nof_rep\n  $self->{'_nof_rep'}--;\n  $self->{'_nof_rep'} += $csp->{'_nof_rep'};\n  # Update list of assembly objects used\n  push @{$self->{'_assembly'}}, @{$csp->{'_assembly'}}\n    if defined $csp->{'_assembly'};\n  return 1;\n}\n\n\n=head2 average\n\n  Title   : average\n  Usage   : my $avg_csp = $csp->average([$csp1, $csp2, $csp3]);\n  Function: Average one contig spectrum or the sum of several contig spectra by\n            the number of repetitions\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Tools::ContigSpectrum array reference\n            eff_asm_params\n\n\nsub average {\n  my ($self, $list) = @_;\n  # Sanity check\n  if ( ! ref $list || ! ref $list eq 'ARRAY') {\n    $self->throw(\"Average takes an array reference but got [\".ref($list).\"]\");\n  }\n  # New average contig spectrum object\n  my $avg = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg->{'_eff_asm_params'} = 1;\n  \n  # Cycle through contig spectra\n  my $tot_nof_rep = 0;\n  for my $csp (@$list) {\n    # Sanity check\n    if (not $csp->isa('Bio::Assembly::Tools::ContigSpectrum')) {\n      $csp->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n    }\n    # Import contig spectrum\n    $avg->add($csp);\n  }\n  \n  # Average sum of contig spectra by number of repetitions\n  for (my $q = 1 ; $q <= $avg->{'_max_size'} ; $q++) {\n    $avg->{'_spectrum'}{$q} /= $avg->{'_nof_rep'}\n      if (defined $avg->{'_spectrum'}{$q});\n  }\n  # Average number of sequences\n  $avg->{'_nof_seq'} /= $avg->{'_nof_rep'};\n  # Average number of overlaps\n  $avg->{'_nof_overlaps'} /= $avg->{'_nof_rep'};\n  \n  return $avg;\n}\n\n\n=head2 score\n\n  Title   : score\n  Usage   : my $score = $csp->score();\n  Function: Score a contig spectrum (or cross-contig spectrum) such that the\n             higher the number of contigs (or cross-contigs) and the larger their \n             size, the higher the score.\n             Let n   : total number of sequences\n                 c_q : number of contigs of size q\n                 q   : number of sequence in a contig\n             We define: score = n/(n-1) * (X - 1/n)\n                  where X = sum ( c_q * q^2 ) / n**2\n             The score ranges from 0 (singlets only) to 1 (a single large contig)\n             It is possible to specify a value for the number of sequences to\n              assume in the contig spectrum.\n  Returns : contig score\n  Args    : number of total sequences to assume [optional]\n\n\nsub score {\n  my ($self, $nof_seqs) = @_;\n  # Main\n  my $score = 0;\n  my $n = $self->nof_seq;\n  if ( $n > 0 ) {\n    # Contig spectrum info\n    my $q_max = $self->max_size;\n    my $spec  = $self->spectrum;\n    # Adjust number of 1-contigs\n    if ( $nof_seqs ) {\n      $spec->{'1'} += $nof_seqs - $n;\n      $n = $nof_seqs;\n    }\n    # Calculate X\n    for my $q ( 1 .. $q_max ) {\n      if ( $spec->{$q} ) {\n        my $c_q = $spec->{$q};\n        $score += $c_q * $q ** 2;\n      }\n    }\n    $score /= $n ** 2; \n  }\n  # Rescale X to obtain the score\n  $score = $n/($n-1) * ($score - 1/$n);\n  return $score;\n}\n\n\n=head2 _naive_assembler\n\n  Title   : _naive_assembler\n  Usage   : \n  Function: Determines the contig spectrum (hash representation) of a subset of\n            sequences from a mixed contig spectrum by \"reassembling\" the\n            specified sequences only based on their position in the contig. This\n            naive assembly only verifies that the minimum overlap length and\n            percentage identity are respected. There is no actual alignment done\n  Returns : contig spectrum hash reference\n  Args    : Bio::Assembly::Contig\n            sequence ID array reference\n            minimum overlap length (integer) [optional]\n            minimum percentage identity (integer) [optional]\n\n\nsub _naive_assembler {\n  my ($self, $contig, $seqlist, $min_overlap, $min_identity) = @_;\n  # Sanity checks\n  if ( ! ref $seqlist || ! ref($seqlist) eq 'ARRAY') {\n    $self->throw('Expecting an array reference. Got ['.ref($seqlist).\"] \\n\");\n  }\n  my $max = scalar @$seqlist;\n  $self->throw(\"Expecting at least 2 sequences as input for _naive_assembler\")\n    if ($max < 2);\n  # Assembly\n  my %spectrum = (1 => 0);\n  my %overlap_map;\n  my %has_overlap;\n  # Map what sequences overlap with what sequences\n  for (my $i = 0 ; $i < $max-1 ; $i++) {\n    # query sequence\n    my $qseqid = $$seqlist[$i];\n    my $qseq   = $contig->get_seq_by_name($qseqid);\n    my $is_singlet = 1;\n    for (my $j = $i+1 ; $j < $max ; $j++) {\n      # target sequence\n      my $tseqid = $$seqlist[$j];\n      my $tseq = $contig->get_seq_by_name($tseqid);\n      # try to align sequences\n      my ($aln, $overlap, $identity)\n        = $self->_overlap_alignment($contig, $qseq, $tseq, $min_overlap,\n        $min_identity);\n      # if there is no valid overlap, go to next sequence\n      next if ! defined $aln;\n      # the overlap is valid\n      $is_singlet = 0;\n      push @{$overlap_map{$qseqid}}, $tseqid;\n      $has_overlap{$tseqid} = 1;\n      $has_overlap{$qseqid} = 1;\n    }\n    # check if sequence is in previously seen overlap\n    if (exists $has_overlap{$qseqid}) {\n      $is_singlet = 0;\n    }\n    if ($is_singlet == 1) {\n      $spectrum{1}++;\n    }\n  }\n  # take care of last sequence\n  my $last_is_singlet = 1;\n  if (exists $has_overlap{$$seqlist[$max-1]}) {\n    $last_is_singlet = 0;\n  }\n  if ($last_is_singlet == 1) {\n    $spectrum{1}++;\n  }\n  # Parse overlap map\n  for my $seqid (@$seqlist) {\n    # list of sequences that should go in the contig\n    next if not exists $overlap_map{$seqid};\n    my @overlist = @{$overlap_map{$seqid}};\n    for (my $j = 0 ; $j < scalar(@overlist) ; $j++) {\n      my $otherseqid = $overlist[$j];\n      if (exists $overlap_map{$otherseqid}) {\n        push @overlist, @{$overlap_map{$otherseqid}};\n        delete $overlap_map{$otherseqid};\n      }\n    }\n    # remove duplicates from list\n    @overlist = sort @overlist;\n    for (my $j = 0 ; $j < scalar(@overlist)-1 ; $j++) {\n      if ( $overlist[$j] eq $overlist[$j+1] ) {\n        splice @overlist, $j, 1;\n        $j--;\n      }\n    }\n    # update spectrum with size of contig\n    my $qsize = scalar(@overlist) + 1;\n    if (defined $spectrum{$qsize}) {\n      $spectrum{$qsize}++;\n    } else {\n      $spectrum{$qsize} = 1;\n    }\n  }\n  return \\%spectrum;\n}\n\n\n=head2 _new_from_assembly\n\n  Title   : _new_from_assembly\n  Usage   : \n  Function: Creates a new contig spectrum object based solely on the result of \n            an assembly\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Scaffold\n\n\nsub _new_from_assembly {\n  # Create new contig spectrum object based purely on what we can get from the\n  # assembly object\n  my ($self, $assemblyobj) = @_;\n  my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n  # 1: Set id\n  $csp->{'_id'} = $assemblyobj->id;\n  # 2: Set overlap statistics: nof_overlaps, min_overlap, avg_overlap,\n  #  min_identity and avg_identity\n  $csp->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  if ($csp->{'_eff_asm_params'} > 0) {\n     my ($nover, $minl, $avgl, $minid, $avgid)\n       = $csp->_get_overlap_stats($assemblyobj);\n     $csp->{'_min_overlap'}  = $minl;\n     $csp->{'_min_identity'} = $minid;\n     $csp->{'_avg_overlap'}  = $avgl;\n     $csp->{'_avg_identity'} = $avgid;\n     $csp->{'_nof_overlaps'} = $nover;\n  }\n  # 3: Set sequence statistics: nof_seq and avg_seq_len\n  my ($nseq, $avgseql) = $self->_get_seq_stats($assemblyobj);\n  $csp->{'_avg_seq_len'} = $avgseql;\n  $csp->{'_nof_seq'}     = $nseq;\n  # 4: Set the spectrum: spectrum and max_size\n  for my $contigobj ($assemblyobj->all_contigs) {\n    my $size = $contigobj->num_sequences;\n    if (defined $csp->{'_spectrum'}{$size}) {\n      $csp->{'_spectrum'}{$size}++;\n    } else {\n      $csp->{'_spectrum'}{$size} = 1;\n    }\n    $csp->{'_max_size'} = $size if $size > $csp->{'_max_size'};\n  }\n  my $nof_singlets = $assemblyobj->get_nof_singlets();\n  if (defined $nof_singlets) {\n    $csp->{'_spectrum'}{1} += $nof_singlets;\n    $csp->{'_max_size'} = 1 if $nof_singlets >= 1 && $csp->{'_max_size'} < 1;\n  }\n  # 5: Set list of assembly objects used\n  push @{$csp->{'_assembly'}}, $assemblyobj;\n  # 6: Set number of repetitions\n  $csp->{'_nof_rep'} = 1;\n  return $csp;\n}\n\n\n\n=head2 _new_dissolved_csp\n\n  Title   : \n  Usage   : create a dissolved contig spectrum object\n  Function: \n  Returns : \n  Args    : \n\n\n\nsub _new_dissolved_csp {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  # Sanity checks on the mixed contig spectrum\n\n  # min_overlap and min_identity must be specified if there are some overlaps\n  # in the mixed contig\n  unless ($mixed_csp->{'_nof_overlaps'} == 0) {\n    unless ( defined $self->{'_min_overlap'} || \n      defined $mixed_csp->{'_min_overlap'} ) {\n      $self->throw(\"min_overlap must be defined in the dissolved contig spectrum\".\n        \" or mixed contig spectrum to dissolve a contig\");\n    }\n    unless ( defined $self->{'_min_identity'} ||\n      defined $mixed_csp->{'_min_identity'} ) {\n      $self->throw(\"min_identity must be defined in the dissolved contig spectrum\".\n        \" or mixed contig spectrum\");\n    }\n  }\n  \n  # there must be at least one assembly in mixed contig spectrum\n  if (!defined $mixed_csp->{'_assembly'} ||\n      scalar @{$mixed_csp->{'_assembly'}} < 1) {\n    $self->throw(\"The mixed contig spectrum must be based on at least one\n    assembly\");\n  }\n\n  # New dissolved contig spectrum object\n  my $dissolved = Bio::Assembly::Tools::ContigSpectrum->new();\n  \n  # take parent attributes if existent or mixed attributes otherwise\n  if ($self->{'_eff_asm_params'}) {\n    $dissolved->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  } else {\n    $dissolved->{'_eff_asm_params'} = $mixed_csp->{'_eff_asm_params'};\n  }\n  if ($self->{'_min_overlap'} && $self->{'_min_identity'}) {\n    ( $dissolved->{'_min_overlap'}, $dissolved->{'_min_identity'} ) = \n      ( $self->{'_min_overlap'}, $self->{'_min_identity'} );\n  } else {\n    ( $dissolved->{'_min_overlap'}, $dissolved->{'_min_identity'} ) = \n      ( $mixed_csp->{'_min_overlap'}, $mixed_csp->{'_min_identity'} );\n  }\n  \n  # Dissolve each assembly\n  for my $assembly (@{$mixed_csp->{'_assembly'}}) {\n    # Dissolve this assembly for the given sequences\n    my %asm_spectrum = (1 => 0);\n    my %good_seqs;\n    # For each contig\n    for my $contig ($assembly->all_contigs) {\n      # Get good sequences\n      my @contig_seqs;\n      for my $seq ($contig->each_seq) {\n        my $seq_id = $seq->id;\n        # get sequence origin\n        next unless $seq_id =~ m/^$seq_header\\|/;\n        # add it to hash\n        push @contig_seqs, $seq_id;\n        $good_seqs{$seq_id} = 1;\n      }\n      # Update spectrum\n      my $size = scalar @contig_seqs;\n      if ($size == 0) {\n        next;\n      } elsif ($size == 1) {\n        $asm_spectrum{1}++;\n      } elsif ($size > 1) {\n        # Reassemble good sequences\n        my $contig_spectrum = $dissolved->_naive_assembler(\n          $contig, \\@contig_seqs, $dissolved->{'_min_overlap'},\n          $dissolved->{'_min_identity'});\n        # update spectrum\n        for my $qsize (keys %$contig_spectrum) {\n          $asm_spectrum{$qsize} += $$contig_spectrum{$qsize};\n        }\n      } else {\n        $self->throw(\"The size is not valid... how could that happen?\");\n      }\n    }\n    # For each singlet\n    for my $singlet ($assembly->all_singlets) {\n      my $seq_id = $singlet->seqref->id;\n      # get sequence origin\n      next unless $seq_id =~ m/^$seq_header\\|/;\n      # add it to hash\n      $good_seqs{$seq_id} = 1;\n      # update spectrum\n      $asm_spectrum{1}++;\n    }\n    # Update spectrum\n    $dissolved->_import_spectrum(\\%asm_spectrum);\n    # Update nof_rep\n    $dissolved->{'_nof_rep'}--;\n    $dissolved->{'_nof_rep'} += $mixed_csp->{'_nof_rep'};\n\n    # Get sequence stats\n    my ($nseq, $avgseql) = $dissolved->_get_seq_stats($assembly, \\%good_seqs);\n    $dissolved->{'_avg_seq_len'} = $avgseql;\n    $dissolved->{'_nof_seq'}     = $nseq;\n  \n    # Get eff_asm_param for these sequences\n    if ($dissolved->{'_eff_asm_params'} > 0) {\n      my ($nover, $minl, $avgl, $minid, $avgid)\n        = $dissolved->_get_overlap_stats($assembly, \\%good_seqs);\n      $dissolved->{'_min_overlap'}  = $minl;\n      $dissolved->{'_min_identity'} = $minid;\n      $dissolved->{'_avg_overlap'}  = $avgl;\n      $dissolved->{'_avg_identity'} = $avgid;\n      $dissolved->{'_nof_overlaps'} = $nover;\n    }\n\n  }\n  return $dissolved;\n}\n\n\n=head2 _new_cross_csp\n\n  Title   : \n  Usage   : \n  Function: create a cross contig spectrum object\n  Returns : \n  Args    : \n\n\n\nsub _new_cross_csp {\n  my ($self, $mixed_csp) = @_;\n  # Sanity check on the mixed contig spectrum\n  # There must be at least one assembly\n  if (!defined $mixed_csp->{'_assembly'} ||\n      scalar @{$mixed_csp->{'_assembly'}} < 1) {\n    $self->throw(\"The mixed contig spectrum must be based on at least one \".\n    \"assembly.\");\n  }\n  \n  # New dissolved contig spectrum object\n  my $cross = Bio::Assembly::Tools::ContigSpectrum->new();\n  my %spectrum = (1 => 0);\n  \n  # Take parent or mixed attributes\n  if ($self->{'_eff_asm_params'}) {\n    $cross->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  } else {\n    $cross->{'_eff_asm_params'} = $mixed_csp->{'_eff_asm_params'};\n  }\n  if ($self->{'_min_overlap'} && $self->{'_min_identity'}) {\n    ( $cross->{'_min_overlap'}, $cross->{'_min_identity'} ) = \n      ( $self->{'_min_overlap'}, $self->{'_min_identity'} );\n  } else {\n    ( $cross->{'_min_overlap'}, $cross->{'_min_identity'} ) = \n      ( $mixed_csp->{'_min_overlap'}, $mixed_csp->{'_min_identity'} );\n  }\n  \n  # Get cross contig spectrum for each assembly\n  for my $assembly (@{$mixed_csp->{'_assembly'}}) {\n    # Go through contigs and skip the pure ones\n    my %good_seqs;\n    for my $contig ($assembly->all_contigs) {\n      # Get origins\n      my @seq_origins;\n      my @seq_ids;\n      for my $seq ($contig->each_seq) {\n        # current sequence origin\n        my $seq_id = $seq->id;\n        $seq_id =~ m/^(.+)\\|/;\n        my $seq_header = $1;\n        $self->warn(\"Sequence $seq_id does not seem to have a header. Skipping\".\n          \" it...\") if not defined $seq_header;\n        $seq_header ||= '';\n        push @seq_origins, $seq_header;\n        push @seq_ids, $seq_id;\n      }\n      my $qsize = scalar(@seq_ids);\n      my @origins = sort { $a cmp $b } @seq_origins;\n      my $size = scalar(@origins);\n      for (my $i = 1 ; $i < $size ; $i++) {\n        if ($origins[$i] eq $origins[$i-1]) {\n          splice @origins, $i, 1;\n          $i--;\n          $size--;\n        }\n      }\n      # Update cross-contig number in spectrum\n      if ($size > 1) { # cross-contig detected\n        # update good sequences\n        for my $seq_id (@seq_ids) {\n          $good_seqs{$seq_id} = 1;\n        }\n        # update number of cross q-contigs in spectrum\n        if (defined $spectrum{$qsize}) {\n          $spectrum{$qsize}++;\n        } else {\n          $spectrum{$qsize} = 1;\n        }\n      }\n      # Update number of cross 1-contigs\n      if ($size > 1) { # cross-contig detected\n        for my $origin (@origins) {\n          # sequences to use\n          my @ids;\n          for (my $i = 0 ; $i < $qsize ; $i++) {\n            my $seq_origin = $seq_origins[$i];\n            my $seq_id = $seq_ids[$i];\n            push @ids, $seq_id if $seq_origin eq $origin;\n          }\n          if (scalar @ids == 1) {\n            $spectrum{1}++;\n          } elsif (scalar @ids > 1) {\n            my $contig_spectrum = $cross->_naive_assembler(\n              $contig, \\@ids, $cross->{'_min_overlap'},\n              $cross->{'_min_identity'});\n            $spectrum{1} += $$contig_spectrum{1};\n          } else {\n            $self->throw(\"The size is <= 0. How could such a thing happen?\");\n          }\n        }\n      }\n    }\n    # Get sequence stats\n    my ($nseq, $avgseql) = $cross->_get_seq_stats($assembly, \\%good_seqs);\n    $cross->{'_avg_seq_len'} = $avgseql;\n    $cross->{'_nof_seq'}     = $nseq;\n    # Get eff_asm_param for these sequences\n    if ($cross->{'_eff_asm_params'} > 0) {\n      my ($nover, $minl, $avgl, $minid, $avgid)\n        = $cross->_get_overlap_stats($assembly, \\%good_seqs);\n      $cross->{'_min_overlap'}  = $minl;\n      $cross->{'_min_identity'} = $minid;\n      $cross->{'_avg_overlap'}  = $avgl;\n      $cross->{'_avg_identity'} = $avgid;\n      $cross->{'_nof_overlaps'} = $nover;\n    }\n  }\n  \n  $cross->_import_spectrum(\\%spectrum);\n  # Update nof_rep\n  $cross->{'_nof_rep'}--;\n  $cross->{'_nof_rep'} += $mixed_csp->{'_nof_rep'};\n  \n  return $cross;\n}\n\n=head2 _import_assembly\n\n  Title   : _import_assembly\n  Usage   : $csp->_import_assembly($assemblyobj);\n  Function: Update a contig spectrum object based on an assembly object\n  Returns : 1 for success, 0 for error\n  Args    : Bio::Assembly::Scaffold assembly object","parameters":[{"label":"$self"},{"label":"$assemblyobj"}],"label":"_import_assembly($self,$assemblyobj)"},"detail":"($self,$assemblyobj)","kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_import_assembly","line":1260,"kind":13},{"kind":13,"line":1260,"containerName":"_import_assembly","name":"$assemblyobj"},{"kind":13,"line":1262,"name":"$assemblyobj","containerName":"_import_assembly"},{"kind":13,"line":1262,"name":"$assemblyobj","containerName":"_import_assembly"},{"containerName":"_import_assembly","name":"isa","kind":12,"line":1262},{"kind":13,"line":1263,"containerName":"_import_assembly","name":"$self"},{"name":"throw","containerName":"_import_assembly","line":1263,"kind":12},{"line":1264,"kind":13,"name":"$assemblyobj","containerName":"_import_assembly"},{"kind":13,"line":1267,"definition":"my","name":"$csp","containerName":"_import_assembly","localvar":"my"},{"line":1267,"kind":13,"containerName":"_import_assembly","name":"$self"},{"kind":12,"line":1267,"name":"_new_from_assembly","containerName":"_import_assembly"},{"containerName":"_import_assembly","name":"$assemblyobj","line":1267,"kind":13},{"kind":13,"line":1269,"name":"$self","containerName":"_import_assembly"},{"containerName":"_import_assembly","name":"add","kind":12,"line":1269},{"name":"$csp","containerName":"_import_assembly","line":1269,"kind":13}],"line":1259},{"children":[{"kind":13,"line":1287,"definition":"my","name":"$self","containerName":"_import_spectrum","localvar":"my"},{"line":1287,"kind":13,"name":"$spectrum","containerName":"_import_spectrum"},{"name":"$spectrum","containerName":"_import_spectrum","kind":13,"line":1289},{"line":1289,"kind":13,"name":"$spectrum","containerName":"_import_spectrum"},{"kind":13,"line":1290,"containerName":"_import_spectrum","name":"$self"},{"line":1290,"kind":12,"containerName":"_import_spectrum","name":"throw"},{"kind":13,"line":1291,"containerName":"_import_spectrum","name":"$spectrum"},{"containerName":"_import_spectrum","definition":"my","name":"$size","localvar":"my","kind":13,"line":1295},{"containerName":"_import_spectrum","name":"$self","kind":13,"line":1297},{"containerName":"_import_spectrum","name":"$size","kind":13,"line":1297},{"kind":13,"line":1298,"containerName":"_import_spectrum","name":"$self"},{"kind":13,"line":1298,"name":"$size","containerName":"_import_spectrum"},{"line":1298,"kind":13,"name":"$size","containerName":"_import_spectrum"},{"kind":13,"line":1300,"containerName":"_import_spectrum","name":"$self"},{"containerName":"_import_spectrum","name":"$size","kind":13,"line":1300},{"name":"$size","containerName":"_import_spectrum","kind":13,"line":1300},{"name":"$self","containerName":"_import_spectrum","line":1303,"kind":13},{"line":1303,"kind":13,"name":"$size","containerName":"_import_spectrum"},{"containerName":"_import_spectrum","name":"$size","line":1303,"kind":13},{"kind":13,"line":1305,"name":"$self","containerName":"_import_spectrum"},{"name":"$size","containerName":"_import_spectrum","line":1305,"kind":13},{"line":1305,"kind":13,"containerName":"_import_spectrum","name":"$size"},{"name":"$self","containerName":"_import_spectrum","kind":13,"line":1305},{"kind":13,"line":1309,"name":"$self","containerName":"_import_spectrum"},{"containerName":"_import_spectrum","name":"$self","kind":13,"line":1309}],"line":1286,"kind":12,"signature":{"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none\n\n\nsub drop_assembly {\n  my ($self) = @_;\n  $self->{'_assembly'} = [];\n  return 1;\n}\n\n=head2 dissolve\n\n  Title   : dissolve\n  Usage   : $dissolved_csp->dissolve($mixed_csp, $seq_header);\n  Function: Dissolve a mixed contig spectrum for the set of sequences that\n            contain the specified header, i.e. determine the contribution of\n            these sequences to the mixed contig spectrum based on the assembly.\n            The mixed contig spectrum object must have been created based on one\n            (or several) assembly object(s). Additionally, min_overlap and\n            min_identity must have been set (either manually using min_overlap\n            or automatically by switching on the eff_asm_params option).\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n            sequence header string\n\n\n\nsub dissolve {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  $self->_import_dissolved_csp($mixed_csp, $seq_header);\n  return 1;\n}\n\n\n=head2 cross\n\n  Title   : cross\n  Usage   : $cross_csp->cross($mixed_csp);\n  Function: Calculate a cross contig_spectrum based on a mixed contig_spectrum.\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n\n\nsub cross {\n  my ($self, $mixed_csp) = @_;\n  $self->_import_cross_csp($mixed_csp);\n  return 1;\n}\n\n=head2 to_string\n\n  Title   : to_string\n  Usage   : my $csp_string = $csp->to_string;\n  Function: Convert the contig spectrum into a string (easy to print!!).\n  Returns : string\n  Args    : element separator (integer) [optional]\n              1 -> space-separated\n              2 -> tab-separated\n              3 -> newline-separated\n\n\nsub to_string {\n  my ($self, $element_separator) = @_;\n  return 0 if $self->{'_max_size'} == 0;\n  $element_separator ||= 1;\n  if ($element_separator == 1) {\n    $element_separator = ' ';\n  } elsif ($element_separator == 2) {\n    $element_separator = \"\\t\";\n  } elsif ($element_separator == 3) {\n    $element_separator = \"\\n\";\n  } else {\n    $self->throw(\"Unknown separator type '$element_separator'\\n\");\n  }\n  my $str = '';\n  for (my $q = 1 ; $q <= $self->{'_max_size'} ; $q++) {\n    my $val = 0;\n    if (exists $self->{'_spectrum'}{$q}) {\n      $val = $self->{'_spectrum'}{$q};\n    }\n    $str .= $val.$element_separator;\n  }\n  $str =~ s/\\s$//;\n  return $str;\n}\n\n\n=head2 add\n\n  Title   : add\n  Usage   : $csp->add($additional_csp);\n  Function: Add a contig spectrum to an existing one: sums the spectra, update\n            the number of sequences, number of repetitions, ...\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum object\n\n\nsub add {\n  my ($self, $csp) = @_;\n  # Sanity check\n  if( !ref $csp || ! $csp->isa('Bio::Assembly::Tools::ContigSpectrum') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n  }\n  # Update overlap statistics\n  if ( $self->{'_eff_asm_params'} > 0 ) {\n    # Warnings\n    if ( $csp->{'_eff_asm_params'} == 0 ) {\n      $self->warn(\"The parent contig spectrum needs effective assembly \".\n        \"parameters (eff_asm_params = \".$self->{'_eff_asm_params'}.\") but the \".\n        \"child contig spectrum doesn't have them (eff_asm_params = \".\n        $csp->{'_eff_asm_params'}.\"). Skipping them...\");\n    } elsif ( $csp->{'_eff_asm_params'} != $self->{'_eff_asm_params'} ) {\n      $self->warn(\"The parent contig spectrum needs a different method for \".\n        \"detecting the effective assembly parameters (eff_asm_params = \".\n        $self->{'_eff_asm_params'}.\") than the one specified for the child \".\n        \"contig spectrum (eff_asm_params = \".$csp->{'_eff_asm_params'}.\"). \".\n        \"Ignoring the differences...\");\n    }\n    # Update existing stats\n    my $tot_num_overlaps = $csp->{'_nof_overlaps'} + $self->{'_nof_overlaps'};\n    $self->{'_min_overlap'} = $csp->{'_min_overlap'} if\n      defined $csp->{'_min_overlap'} && ( ! defined $self->{'_min_overlap'} ||\n      $csp->{'_min_overlap'} < $self->{'_min_overlap'} );\n    $self->{'_min_identity'} = $csp->{'_min_identity'} if\n      defined $csp->{'_min_identity'} && ( ! defined $self->{'_min_identity'} ||\n      $csp->{'_min_identity'} < $self->{'_min_identity'} );\n    if ($tot_num_overlaps != 0) {\n      $self->{'_avg_overlap'} =\n        ($csp->{'_avg_overlap'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_overlap'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n      $self->{'_avg_identity'} =\n        ($csp->{'_avg_identity'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_identity'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n    }\n    $self->{'_nof_overlaps'} = $tot_num_overlaps;\n  }\n  # Update sequence statistics\n  my $tot_nof_seq = $csp->{'_nof_seq'} + $self->{'_nof_seq'};\n  if (not $tot_nof_seq == 0) {\n    $self->{'_avg_seq_len'} = ($csp->{'_avg_seq_len'} * $csp->{'_nof_seq'} +\n      $self->{'_avg_seq_len'} * $self->{'_nof_seq'}) / $tot_nof_seq;\n  }\n  # Update spectrum (and nof_seq, max_size, and increment nof_rep by 1)\n  $self->_import_spectrum($csp->{'_spectrum'});\n  # Update nof_rep\n  $self->{'_nof_rep'}--;\n  $self->{'_nof_rep'} += $csp->{'_nof_rep'};\n  # Update list of assembly objects used\n  push @{$self->{'_assembly'}}, @{$csp->{'_assembly'}}\n    if defined $csp->{'_assembly'};\n  return 1;\n}\n\n\n=head2 average\n\n  Title   : average\n  Usage   : my $avg_csp = $csp->average([$csp1, $csp2, $csp3]);\n  Function: Average one contig spectrum or the sum of several contig spectra by\n            the number of repetitions\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Tools::ContigSpectrum array reference\n            eff_asm_params\n\n\nsub average {\n  my ($self, $list) = @_;\n  # Sanity check\n  if ( ! ref $list || ! ref $list eq 'ARRAY') {\n    $self->throw(\"Average takes an array reference but got [\".ref($list).\"]\");\n  }\n  # New average contig spectrum object\n  my $avg = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg->{'_eff_asm_params'} = 1;\n  \n  # Cycle through contig spectra\n  my $tot_nof_rep = 0;\n  for my $csp (@$list) {\n    # Sanity check\n    if (not $csp->isa('Bio::Assembly::Tools::ContigSpectrum')) {\n      $csp->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n    }\n    # Import contig spectrum\n    $avg->add($csp);\n  }\n  \n  # Average sum of contig spectra by number of repetitions\n  for (my $q = 1 ; $q <= $avg->{'_max_size'} ; $q++) {\n    $avg->{'_spectrum'}{$q} /= $avg->{'_nof_rep'}\n      if (defined $avg->{'_spectrum'}{$q});\n  }\n  # Average number of sequences\n  $avg->{'_nof_seq'} /= $avg->{'_nof_rep'};\n  # Average number of overlaps\n  $avg->{'_nof_overlaps'} /= $avg->{'_nof_rep'};\n  \n  return $avg;\n}\n\n\n=head2 score\n\n  Title   : score\n  Usage   : my $score = $csp->score();\n  Function: Score a contig spectrum (or cross-contig spectrum) such that the\n             higher the number of contigs (or cross-contigs) and the larger their \n             size, the higher the score.\n             Let n   : total number of sequences\n                 c_q : number of contigs of size q\n                 q   : number of sequence in a contig\n             We define: score = n/(n-1) * (X - 1/n)\n                  where X = sum ( c_q * q^2 ) / n**2\n             The score ranges from 0 (singlets only) to 1 (a single large contig)\n             It is possible to specify a value for the number of sequences to\n              assume in the contig spectrum.\n  Returns : contig score\n  Args    : number of total sequences to assume [optional]\n\n\nsub score {\n  my ($self, $nof_seqs) = @_;\n  # Main\n  my $score = 0;\n  my $n = $self->nof_seq;\n  if ( $n > 0 ) {\n    # Contig spectrum info\n    my $q_max = $self->max_size;\n    my $spec  = $self->spectrum;\n    # Adjust number of 1-contigs\n    if ( $nof_seqs ) {\n      $spec->{'1'} += $nof_seqs - $n;\n      $n = $nof_seqs;\n    }\n    # Calculate X\n    for my $q ( 1 .. $q_max ) {\n      if ( $spec->{$q} ) {\n        my $c_q = $spec->{$q};\n        $score += $c_q * $q ** 2;\n      }\n    }\n    $score /= $n ** 2; \n  }\n  # Rescale X to obtain the score\n  $score = $n/($n-1) * ($score - 1/$n);\n  return $score;\n}\n\n\n=head2 _naive_assembler\n\n  Title   : _naive_assembler\n  Usage   : \n  Function: Determines the contig spectrum (hash representation) of a subset of\n            sequences from a mixed contig spectrum by \"reassembling\" the\n            specified sequences only based on their position in the contig. This\n            naive assembly only verifies that the minimum overlap length and\n            percentage identity are respected. There is no actual alignment done\n  Returns : contig spectrum hash reference\n  Args    : Bio::Assembly::Contig\n            sequence ID array reference\n            minimum overlap length (integer) [optional]\n            minimum percentage identity (integer) [optional]\n\n\nsub _naive_assembler {\n  my ($self, $contig, $seqlist, $min_overlap, $min_identity) = @_;\n  # Sanity checks\n  if ( ! ref $seqlist || ! ref($seqlist) eq 'ARRAY') {\n    $self->throw('Expecting an array reference. Got ['.ref($seqlist).\"] \\n\");\n  }\n  my $max = scalar @$seqlist;\n  $self->throw(\"Expecting at least 2 sequences as input for _naive_assembler\")\n    if ($max < 2);\n  # Assembly\n  my %spectrum = (1 => 0);\n  my %overlap_map;\n  my %has_overlap;\n  # Map what sequences overlap with what sequences\n  for (my $i = 0 ; $i < $max-1 ; $i++) {\n    # query sequence\n    my $qseqid = $$seqlist[$i];\n    my $qseq   = $contig->get_seq_by_name($qseqid);\n    my $is_singlet = 1;\n    for (my $j = $i+1 ; $j < $max ; $j++) {\n      # target sequence\n      my $tseqid = $$seqlist[$j];\n      my $tseq = $contig->get_seq_by_name($tseqid);\n      # try to align sequences\n      my ($aln, $overlap, $identity)\n        = $self->_overlap_alignment($contig, $qseq, $tseq, $min_overlap,\n        $min_identity);\n      # if there is no valid overlap, go to next sequence\n      next if ! defined $aln;\n      # the overlap is valid\n      $is_singlet = 0;\n      push @{$overlap_map{$qseqid}}, $tseqid;\n      $has_overlap{$tseqid} = 1;\n      $has_overlap{$qseqid} = 1;\n    }\n    # check if sequence is in previously seen overlap\n    if (exists $has_overlap{$qseqid}) {\n      $is_singlet = 0;\n    }\n    if ($is_singlet == 1) {\n      $spectrum{1}++;\n    }\n  }\n  # take care of last sequence\n  my $last_is_singlet = 1;\n  if (exists $has_overlap{$$seqlist[$max-1]}) {\n    $last_is_singlet = 0;\n  }\n  if ($last_is_singlet == 1) {\n    $spectrum{1}++;\n  }\n  # Parse overlap map\n  for my $seqid (@$seqlist) {\n    # list of sequences that should go in the contig\n    next if not exists $overlap_map{$seqid};\n    my @overlist = @{$overlap_map{$seqid}};\n    for (my $j = 0 ; $j < scalar(@overlist) ; $j++) {\n      my $otherseqid = $overlist[$j];\n      if (exists $overlap_map{$otherseqid}) {\n        push @overlist, @{$overlap_map{$otherseqid}};\n        delete $overlap_map{$otherseqid};\n      }\n    }\n    # remove duplicates from list\n    @overlist = sort @overlist;\n    for (my $j = 0 ; $j < scalar(@overlist)-1 ; $j++) {\n      if ( $overlist[$j] eq $overlist[$j+1] ) {\n        splice @overlist, $j, 1;\n        $j--;\n      }\n    }\n    # update spectrum with size of contig\n    my $qsize = scalar(@overlist) + 1;\n    if (defined $spectrum{$qsize}) {\n      $spectrum{$qsize}++;\n    } else {\n      $spectrum{$qsize} = 1;\n    }\n  }\n  return \\%spectrum;\n}\n\n\n=head2 _new_from_assembly\n\n  Title   : _new_from_assembly\n  Usage   : \n  Function: Creates a new contig spectrum object based solely on the result of \n            an assembly\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Scaffold\n\n\nsub _new_from_assembly {\n  # Create new contig spectrum object based purely on what we can get from the\n  # assembly object\n  my ($self, $assemblyobj) = @_;\n  my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n  # 1: Set id\n  $csp->{'_id'} = $assemblyobj->id;\n  # 2: Set overlap statistics: nof_overlaps, min_overlap, avg_overlap,\n  #  min_identity and avg_identity\n  $csp->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  if ($csp->{'_eff_asm_params'} > 0) {\n     my ($nover, $minl, $avgl, $minid, $avgid)\n       = $csp->_get_overlap_stats($assemblyobj);\n     $csp->{'_min_overlap'}  = $minl;\n     $csp->{'_min_identity'} = $minid;\n     $csp->{'_avg_overlap'}  = $avgl;\n     $csp->{'_avg_identity'} = $avgid;\n     $csp->{'_nof_overlaps'} = $nover;\n  }\n  # 3: Set sequence statistics: nof_seq and avg_seq_len\n  my ($nseq, $avgseql) = $self->_get_seq_stats($assemblyobj);\n  $csp->{'_avg_seq_len'} = $avgseql;\n  $csp->{'_nof_seq'}     = $nseq;\n  # 4: Set the spectrum: spectrum and max_size\n  for my $contigobj ($assemblyobj->all_contigs) {\n    my $size = $contigobj->num_sequences;\n    if (defined $csp->{'_spectrum'}{$size}) {\n      $csp->{'_spectrum'}{$size}++;\n    } else {\n      $csp->{'_spectrum'}{$size} = 1;\n    }\n    $csp->{'_max_size'} = $size if $size > $csp->{'_max_size'};\n  }\n  my $nof_singlets = $assemblyobj->get_nof_singlets();\n  if (defined $nof_singlets) {\n    $csp->{'_spectrum'}{1} += $nof_singlets;\n    $csp->{'_max_size'} = 1 if $nof_singlets >= 1 && $csp->{'_max_size'} < 1;\n  }\n  # 5: Set list of assembly objects used\n  push @{$csp->{'_assembly'}}, $assemblyobj;\n  # 6: Set number of repetitions\n  $csp->{'_nof_rep'} = 1;\n  return $csp;\n}\n\n\n\n=head2 _new_dissolved_csp\n\n  Title   : \n  Usage   : create a dissolved contig spectrum object\n  Function: \n  Returns : \n  Args    : \n\n\n\nsub _new_dissolved_csp {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  # Sanity checks on the mixed contig spectrum\n\n  # min_overlap and min_identity must be specified if there are some overlaps\n  # in the mixed contig\n  unless ($mixed_csp->{'_nof_overlaps'} == 0) {\n    unless ( defined $self->{'_min_overlap'} || \n      defined $mixed_csp->{'_min_overlap'} ) {\n      $self->throw(\"min_overlap must be defined in the dissolved contig spectrum\".\n        \" or mixed contig spectrum to dissolve a contig\");\n    }\n    unless ( defined $self->{'_min_identity'} ||\n      defined $mixed_csp->{'_min_identity'} ) {\n      $self->throw(\"min_identity must be defined in the dissolved contig spectrum\".\n        \" or mixed contig spectrum\");\n    }\n  }\n  \n  # there must be at least one assembly in mixed contig spectrum\n  if (!defined $mixed_csp->{'_assembly'} ||\n      scalar @{$mixed_csp->{'_assembly'}} < 1) {\n    $self->throw(\"The mixed contig spectrum must be based on at least one\n    assembly\");\n  }\n\n  # New dissolved contig spectrum object\n  my $dissolved = Bio::Assembly::Tools::ContigSpectrum->new();\n  \n  # take parent attributes if existent or mixed attributes otherwise\n  if ($self->{'_eff_asm_params'}) {\n    $dissolved->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  } else {\n    $dissolved->{'_eff_asm_params'} = $mixed_csp->{'_eff_asm_params'};\n  }\n  if ($self->{'_min_overlap'} && $self->{'_min_identity'}) {\n    ( $dissolved->{'_min_overlap'}, $dissolved->{'_min_identity'} ) = \n      ( $self->{'_min_overlap'}, $self->{'_min_identity'} );\n  } else {\n    ( $dissolved->{'_min_overlap'}, $dissolved->{'_min_identity'} ) = \n      ( $mixed_csp->{'_min_overlap'}, $mixed_csp->{'_min_identity'} );\n  }\n  \n  # Dissolve each assembly\n  for my $assembly (@{$mixed_csp->{'_assembly'}}) {\n    # Dissolve this assembly for the given sequences\n    my %asm_spectrum = (1 => 0);\n    my %good_seqs;\n    # For each contig\n    for my $contig ($assembly->all_contigs) {\n      # Get good sequences\n      my @contig_seqs;\n      for my $seq ($contig->each_seq) {\n        my $seq_id = $seq->id;\n        # get sequence origin\n        next unless $seq_id =~ m/^$seq_header\\|/;\n        # add it to hash\n        push @contig_seqs, $seq_id;\n        $good_seqs{$seq_id} = 1;\n      }\n      # Update spectrum\n      my $size = scalar @contig_seqs;\n      if ($size == 0) {\n        next;\n      } elsif ($size == 1) {\n        $asm_spectrum{1}++;\n      } elsif ($size > 1) {\n        # Reassemble good sequences\n        my $contig_spectrum = $dissolved->_naive_assembler(\n          $contig, \\@contig_seqs, $dissolved->{'_min_overlap'},\n          $dissolved->{'_min_identity'});\n        # update spectrum\n        for my $qsize (keys %$contig_spectrum) {\n          $asm_spectrum{$qsize} += $$contig_spectrum{$qsize};\n        }\n      } else {\n        $self->throw(\"The size is not valid... how could that happen?\");\n      }\n    }\n    # For each singlet\n    for my $singlet ($assembly->all_singlets) {\n      my $seq_id = $singlet->seqref->id;\n      # get sequence origin\n      next unless $seq_id =~ m/^$seq_header\\|/;\n      # add it to hash\n      $good_seqs{$seq_id} = 1;\n      # update spectrum\n      $asm_spectrum{1}++;\n    }\n    # Update spectrum\n    $dissolved->_import_spectrum(\\%asm_spectrum);\n    # Update nof_rep\n    $dissolved->{'_nof_rep'}--;\n    $dissolved->{'_nof_rep'} += $mixed_csp->{'_nof_rep'};\n\n    # Get sequence stats\n    my ($nseq, $avgseql) = $dissolved->_get_seq_stats($assembly, \\%good_seqs);\n    $dissolved->{'_avg_seq_len'} = $avgseql;\n    $dissolved->{'_nof_seq'}     = $nseq;\n  \n    # Get eff_asm_param for these sequences\n    if ($dissolved->{'_eff_asm_params'} > 0) {\n      my ($nover, $minl, $avgl, $minid, $avgid)\n        = $dissolved->_get_overlap_stats($assembly, \\%good_seqs);\n      $dissolved->{'_min_overlap'}  = $minl;\n      $dissolved->{'_min_identity'} = $minid;\n      $dissolved->{'_avg_overlap'}  = $avgl;\n      $dissolved->{'_avg_identity'} = $avgid;\n      $dissolved->{'_nof_overlaps'} = $nover;\n    }\n\n  }\n  return $dissolved;\n}\n\n\n=head2 _new_cross_csp\n\n  Title   : \n  Usage   : \n  Function: create a cross contig spectrum object\n  Returns : \n  Args    : \n\n\n\nsub _new_cross_csp {\n  my ($self, $mixed_csp) = @_;\n  # Sanity check on the mixed contig spectrum\n  # There must be at least one assembly\n  if (!defined $mixed_csp->{'_assembly'} ||\n      scalar @{$mixed_csp->{'_assembly'}} < 1) {\n    $self->throw(\"The mixed contig spectrum must be based on at least one \".\n    \"assembly.\");\n  }\n  \n  # New dissolved contig spectrum object\n  my $cross = Bio::Assembly::Tools::ContigSpectrum->new();\n  my %spectrum = (1 => 0);\n  \n  # Take parent or mixed attributes\n  if ($self->{'_eff_asm_params'}) {\n    $cross->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  } else {\n    $cross->{'_eff_asm_params'} = $mixed_csp->{'_eff_asm_params'};\n  }\n  if ($self->{'_min_overlap'} && $self->{'_min_identity'}) {\n    ( $cross->{'_min_overlap'}, $cross->{'_min_identity'} ) = \n      ( $self->{'_min_overlap'}, $self->{'_min_identity'} );\n  } else {\n    ( $cross->{'_min_overlap'}, $cross->{'_min_identity'} ) = \n      ( $mixed_csp->{'_min_overlap'}, $mixed_csp->{'_min_identity'} );\n  }\n  \n  # Get cross contig spectrum for each assembly\n  for my $assembly (@{$mixed_csp->{'_assembly'}}) {\n    # Go through contigs and skip the pure ones\n    my %good_seqs;\n    for my $contig ($assembly->all_contigs) {\n      # Get origins\n      my @seq_origins;\n      my @seq_ids;\n      for my $seq ($contig->each_seq) {\n        # current sequence origin\n        my $seq_id = $seq->id;\n        $seq_id =~ m/^(.+)\\|/;\n        my $seq_header = $1;\n        $self->warn(\"Sequence $seq_id does not seem to have a header. Skipping\".\n          \" it...\") if not defined $seq_header;\n        $seq_header ||= '';\n        push @seq_origins, $seq_header;\n        push @seq_ids, $seq_id;\n      }\n      my $qsize = scalar(@seq_ids);\n      my @origins = sort { $a cmp $b } @seq_origins;\n      my $size = scalar(@origins);\n      for (my $i = 1 ; $i < $size ; $i++) {\n        if ($origins[$i] eq $origins[$i-1]) {\n          splice @origins, $i, 1;\n          $i--;\n          $size--;\n        }\n      }\n      # Update cross-contig number in spectrum\n      if ($size > 1) { # cross-contig detected\n        # update good sequences\n        for my $seq_id (@seq_ids) {\n          $good_seqs{$seq_id} = 1;\n        }\n        # update number of cross q-contigs in spectrum\n        if (defined $spectrum{$qsize}) {\n          $spectrum{$qsize}++;\n        } else {\n          $spectrum{$qsize} = 1;\n        }\n      }\n      # Update number of cross 1-contigs\n      if ($size > 1) { # cross-contig detected\n        for my $origin (@origins) {\n          # sequences to use\n          my @ids;\n          for (my $i = 0 ; $i < $qsize ; $i++) {\n            my $seq_origin = $seq_origins[$i];\n            my $seq_id = $seq_ids[$i];\n            push @ids, $seq_id if $seq_origin eq $origin;\n          }\n          if (scalar @ids == 1) {\n            $spectrum{1}++;\n          } elsif (scalar @ids > 1) {\n            my $contig_spectrum = $cross->_naive_assembler(\n              $contig, \\@ids, $cross->{'_min_overlap'},\n              $cross->{'_min_identity'});\n            $spectrum{1} += $$contig_spectrum{1};\n          } else {\n            $self->throw(\"The size is <= 0. How could such a thing happen?\");\n          }\n        }\n      }\n    }\n    # Get sequence stats\n    my ($nseq, $avgseql) = $cross->_get_seq_stats($assembly, \\%good_seqs);\n    $cross->{'_avg_seq_len'} = $avgseql;\n    $cross->{'_nof_seq'}     = $nseq;\n    # Get eff_asm_param for these sequences\n    if ($cross->{'_eff_asm_params'} > 0) {\n      my ($nover, $minl, $avgl, $minid, $avgid)\n        = $cross->_get_overlap_stats($assembly, \\%good_seqs);\n      $cross->{'_min_overlap'}  = $minl;\n      $cross->{'_min_identity'} = $minid;\n      $cross->{'_avg_overlap'}  = $avgl;\n      $cross->{'_avg_identity'} = $avgid;\n      $cross->{'_nof_overlaps'} = $nover;\n    }\n  }\n  \n  $cross->_import_spectrum(\\%spectrum);\n  # Update nof_rep\n  $cross->{'_nof_rep'}--;\n  $cross->{'_nof_rep'} += $mixed_csp->{'_nof_rep'};\n  \n  return $cross;\n}\n\n=head2 _import_assembly\n\n  Title   : _import_assembly\n  Usage   : $csp->_import_assembly($assemblyobj);\n  Function: Update a contig spectrum object based on an assembly object\n  Returns : 1 for success, 0 for error\n  Args    : Bio::Assembly::Scaffold assembly object\n\n\nsub _import_assembly {\n  my ($self, $assemblyobj) = @_;\n  # Sanity check\n  if( !ref $assemblyobj || ! $assemblyobj->isa('Bio::Assembly::ScaffoldI') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::ScaffoldI assembly \".\n        \"object [\".ref($assemblyobj).\"]\");\n  }\n  # Create new object from assembly\n  my $csp = $self->_new_from_assembly($assemblyobj);\n  # Update current contig spectrum object with new one\n  $self->add($csp);\n  return 1;\n}\n\n\n=head2 _import_spectrum\n\n  Title   : _import_spectrum\n  Usage   : $csp->_import_spectrum({ 1 => 90 , 2 => 3 , 4 => 1 })\n  Function: update a contig spectrum object based on a contig spectrum\n            represented as a hash (key: contig size, value: number of contigs of\n            this size)\n  Returns : 1 for success, 0 for error\n  Args    : contig spectrum as a hash reference","parameters":[{"label":"$self"},{"label":"$spectrum"}],"label":"_import_spectrum($self,$spectrum)"},"detail":"($self,$spectrum)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":1286},"end":{"line":1309,"character":9999}},"name":"_import_spectrum"},{"containerName":null,"name":"%self","kind":13,"line":1310},{"containerName":null,"name":"%self","line":1310,"kind":13},{"name":"%self","containerName":null,"line":1313,"kind":13},{"range":{"start":{"line":1329,"character":0},"end":{"character":9999,"line":1341}},"name":"_import_dissolved_csp","children":[{"kind":13,"line":1330,"name":"$self","definition":"my","containerName":"_import_dissolved_csp","localvar":"my"},{"containerName":"_import_dissolved_csp","name":"$mixed_csp","line":1330,"kind":13},{"kind":13,"line":1330,"name":"$seq_header","containerName":"_import_dissolved_csp"},{"containerName":"_import_dissolved_csp","name":"$mixed_csp","kind":13,"line":1332},{"line":1332,"kind":13,"name":"$seq_header","containerName":"_import_dissolved_csp"},{"line":1333,"kind":13,"containerName":"_import_dissolved_csp","name":"$self"},{"kind":12,"line":1333,"containerName":"_import_dissolved_csp","name":"throw"},{"line":1337,"kind":13,"localvar":"my","name":"$dissolved_csp","definition":"my","containerName":"_import_dissolved_csp"},{"name":"$self","containerName":"_import_dissolved_csp","kind":13,"line":1337},{"kind":12,"line":1337,"containerName":"_import_dissolved_csp","name":"_new_dissolved_csp"},{"name":"$mixed_csp","containerName":"_import_dissolved_csp","kind":13,"line":1337},{"line":1337,"kind":13,"containerName":"_import_dissolved_csp","name":"$seq_header"},{"name":"$self","containerName":"_import_dissolved_csp","line":1339,"kind":13},{"line":1339,"kind":12,"containerName":"_import_dissolved_csp","name":"add"},{"containerName":"_import_dissolved_csp","name":"$dissolved_csp","line":1339,"kind":13}],"line":1329,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$mixed_csp"},{"label":"$seq_header"}],"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none\n\n\nsub drop_assembly {\n  my ($self) = @_;\n  $self->{'_assembly'} = [];\n  return 1;\n}\n\n=head2 dissolve\n\n  Title   : dissolve\n  Usage   : $dissolved_csp->dissolve($mixed_csp, $seq_header);\n  Function: Dissolve a mixed contig spectrum for the set of sequences that\n            contain the specified header, i.e. determine the contribution of\n            these sequences to the mixed contig spectrum based on the assembly.\n            The mixed contig spectrum object must have been created based on one\n            (or several) assembly object(s). Additionally, min_overlap and\n            min_identity must have been set (either manually using min_overlap\n            or automatically by switching on the eff_asm_params option).\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n            sequence header string\n\n\n\nsub dissolve {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  $self->_import_dissolved_csp($mixed_csp, $seq_header);\n  return 1;\n}\n\n\n=head2 cross\n\n  Title   : cross\n  Usage   : $cross_csp->cross($mixed_csp);\n  Function: Calculate a cross contig_spectrum based on a mixed contig_spectrum.\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n\n\nsub cross {\n  my ($self, $mixed_csp) = @_;\n  $self->_import_cross_csp($mixed_csp);\n  return 1;\n}\n\n=head2 to_string\n\n  Title   : to_string\n  Usage   : my $csp_string = $csp->to_string;\n  Function: Convert the contig spectrum into a string (easy to print!!).\n  Returns : string\n  Args    : element separator (integer) [optional]\n              1 -> space-separated\n              2 -> tab-separated\n              3 -> newline-separated\n\n\nsub to_string {\n  my ($self, $element_separator) = @_;\n  return 0 if $self->{'_max_size'} == 0;\n  $element_separator ||= 1;\n  if ($element_separator == 1) {\n    $element_separator = ' ';\n  } elsif ($element_separator == 2) {\n    $element_separator = \"\\t\";\n  } elsif ($element_separator == 3) {\n    $element_separator = \"\\n\";\n  } else {\n    $self->throw(\"Unknown separator type '$element_separator'\\n\");\n  }\n  my $str = '';\n  for (my $q = 1 ; $q <= $self->{'_max_size'} ; $q++) {\n    my $val = 0;\n    if (exists $self->{'_spectrum'}{$q}) {\n      $val = $self->{'_spectrum'}{$q};\n    }\n    $str .= $val.$element_separator;\n  }\n  $str =~ s/\\s$//;\n  return $str;\n}\n\n\n=head2 add\n\n  Title   : add\n  Usage   : $csp->add($additional_csp);\n  Function: Add a contig spectrum to an existing one: sums the spectra, update\n            the number of sequences, number of repetitions, ...\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum object\n\n\nsub add {\n  my ($self, $csp) = @_;\n  # Sanity check\n  if( !ref $csp || ! $csp->isa('Bio::Assembly::Tools::ContigSpectrum') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n  }\n  # Update overlap statistics\n  if ( $self->{'_eff_asm_params'} > 0 ) {\n    # Warnings\n    if ( $csp->{'_eff_asm_params'} == 0 ) {\n      $self->warn(\"The parent contig spectrum needs effective assembly \".\n        \"parameters (eff_asm_params = \".$self->{'_eff_asm_params'}.\") but the \".\n        \"child contig spectrum doesn't have them (eff_asm_params = \".\n        $csp->{'_eff_asm_params'}.\"). Skipping them...\");\n    } elsif ( $csp->{'_eff_asm_params'} != $self->{'_eff_asm_params'} ) {\n      $self->warn(\"The parent contig spectrum needs a different method for \".\n        \"detecting the effective assembly parameters (eff_asm_params = \".\n        $self->{'_eff_asm_params'}.\") than the one specified for the child \".\n        \"contig spectrum (eff_asm_params = \".$csp->{'_eff_asm_params'}.\"). \".\n        \"Ignoring the differences...\");\n    }\n    # Update existing stats\n    my $tot_num_overlaps = $csp->{'_nof_overlaps'} + $self->{'_nof_overlaps'};\n    $self->{'_min_overlap'} = $csp->{'_min_overlap'} if\n      defined $csp->{'_min_overlap'} && ( ! defined $self->{'_min_overlap'} ||\n      $csp->{'_min_overlap'} < $self->{'_min_overlap'} );\n    $self->{'_min_identity'} = $csp->{'_min_identity'} if\n      defined $csp->{'_min_identity'} && ( ! defined $self->{'_min_identity'} ||\n      $csp->{'_min_identity'} < $self->{'_min_identity'} );\n    if ($tot_num_overlaps != 0) {\n      $self->{'_avg_overlap'} =\n        ($csp->{'_avg_overlap'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_overlap'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n      $self->{'_avg_identity'} =\n        ($csp->{'_avg_identity'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_identity'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n    }\n    $self->{'_nof_overlaps'} = $tot_num_overlaps;\n  }\n  # Update sequence statistics\n  my $tot_nof_seq = $csp->{'_nof_seq'} + $self->{'_nof_seq'};\n  if (not $tot_nof_seq == 0) {\n    $self->{'_avg_seq_len'} = ($csp->{'_avg_seq_len'} * $csp->{'_nof_seq'} +\n      $self->{'_avg_seq_len'} * $self->{'_nof_seq'}) / $tot_nof_seq;\n  }\n  # Update spectrum (and nof_seq, max_size, and increment nof_rep by 1)\n  $self->_import_spectrum($csp->{'_spectrum'});\n  # Update nof_rep\n  $self->{'_nof_rep'}--;\n  $self->{'_nof_rep'} += $csp->{'_nof_rep'};\n  # Update list of assembly objects used\n  push @{$self->{'_assembly'}}, @{$csp->{'_assembly'}}\n    if defined $csp->{'_assembly'};\n  return 1;\n}\n\n\n=head2 average\n\n  Title   : average\n  Usage   : my $avg_csp = $csp->average([$csp1, $csp2, $csp3]);\n  Function: Average one contig spectrum or the sum of several contig spectra by\n            the number of repetitions\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Tools::ContigSpectrum array reference\n            eff_asm_params\n\n\nsub average {\n  my ($self, $list) = @_;\n  # Sanity check\n  if ( ! ref $list || ! ref $list eq 'ARRAY') {\n    $self->throw(\"Average takes an array reference but got [\".ref($list).\"]\");\n  }\n  # New average contig spectrum object\n  my $avg = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg->{'_eff_asm_params'} = 1;\n  \n  # Cycle through contig spectra\n  my $tot_nof_rep = 0;\n  for my $csp (@$list) {\n    # Sanity check\n    if (not $csp->isa('Bio::Assembly::Tools::ContigSpectrum')) {\n      $csp->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n    }\n    # Import contig spectrum\n    $avg->add($csp);\n  }\n  \n  # Average sum of contig spectra by number of repetitions\n  for (my $q = 1 ; $q <= $avg->{'_max_size'} ; $q++) {\n    $avg->{'_spectrum'}{$q} /= $avg->{'_nof_rep'}\n      if (defined $avg->{'_spectrum'}{$q});\n  }\n  # Average number of sequences\n  $avg->{'_nof_seq'} /= $avg->{'_nof_rep'};\n  # Average number of overlaps\n  $avg->{'_nof_overlaps'} /= $avg->{'_nof_rep'};\n  \n  return $avg;\n}\n\n\n=head2 score\n\n  Title   : score\n  Usage   : my $score = $csp->score();\n  Function: Score a contig spectrum (or cross-contig spectrum) such that the\n             higher the number of contigs (or cross-contigs) and the larger their \n             size, the higher the score.\n             Let n   : total number of sequences\n                 c_q : number of contigs of size q\n                 q   : number of sequence in a contig\n             We define: score = n/(n-1) * (X - 1/n)\n                  where X = sum ( c_q * q^2 ) / n**2\n             The score ranges from 0 (singlets only) to 1 (a single large contig)\n             It is possible to specify a value for the number of sequences to\n              assume in the contig spectrum.\n  Returns : contig score\n  Args    : number of total sequences to assume [optional]\n\n\nsub score {\n  my ($self, $nof_seqs) = @_;\n  # Main\n  my $score = 0;\n  my $n = $self->nof_seq;\n  if ( $n > 0 ) {\n    # Contig spectrum info\n    my $q_max = $self->max_size;\n    my $spec  = $self->spectrum;\n    # Adjust number of 1-contigs\n    if ( $nof_seqs ) {\n      $spec->{'1'} += $nof_seqs - $n;\n      $n = $nof_seqs;\n    }\n    # Calculate X\n    for my $q ( 1 .. $q_max ) {\n      if ( $spec->{$q} ) {\n        my $c_q = $spec->{$q};\n        $score += $c_q * $q ** 2;\n      }\n    }\n    $score /= $n ** 2; \n  }\n  # Rescale X to obtain the score\n  $score = $n/($n-1) * ($score - 1/$n);\n  return $score;\n}\n\n\n=head2 _naive_assembler\n\n  Title   : _naive_assembler\n  Usage   : \n  Function: Determines the contig spectrum (hash representation) of a subset of\n            sequences from a mixed contig spectrum by \"reassembling\" the\n            specified sequences only based on their position in the contig. This\n            naive assembly only verifies that the minimum overlap length and\n            percentage identity are respected. There is no actual alignment done\n  Returns : contig spectrum hash reference\n  Args    : Bio::Assembly::Contig\n            sequence ID array reference\n            minimum overlap length (integer) [optional]\n            minimum percentage identity (integer) [optional]\n\n\nsub _naive_assembler {\n  my ($self, $contig, $seqlist, $min_overlap, $min_identity) = @_;\n  # Sanity checks\n  if ( ! ref $seqlist || ! ref($seqlist) eq 'ARRAY') {\n    $self->throw('Expecting an array reference. Got ['.ref($seqlist).\"] \\n\");\n  }\n  my $max = scalar @$seqlist;\n  $self->throw(\"Expecting at least 2 sequences as input for _naive_assembler\")\n    if ($max < 2);\n  # Assembly\n  my %spectrum = (1 => 0);\n  my %overlap_map;\n  my %has_overlap;\n  # Map what sequences overlap with what sequences\n  for (my $i = 0 ; $i < $max-1 ; $i++) {\n    # query sequence\n    my $qseqid = $$seqlist[$i];\n    my $qseq   = $contig->get_seq_by_name($qseqid);\n    my $is_singlet = 1;\n    for (my $j = $i+1 ; $j < $max ; $j++) {\n      # target sequence\n      my $tseqid = $$seqlist[$j];\n      my $tseq = $contig->get_seq_by_name($tseqid);\n      # try to align sequences\n      my ($aln, $overlap, $identity)\n        = $self->_overlap_alignment($contig, $qseq, $tseq, $min_overlap,\n        $min_identity);\n      # if there is no valid overlap, go to next sequence\n      next if ! defined $aln;\n      # the overlap is valid\n      $is_singlet = 0;\n      push @{$overlap_map{$qseqid}}, $tseqid;\n      $has_overlap{$tseqid} = 1;\n      $has_overlap{$qseqid} = 1;\n    }\n    # check if sequence is in previously seen overlap\n    if (exists $has_overlap{$qseqid}) {\n      $is_singlet = 0;\n    }\n    if ($is_singlet == 1) {\n      $spectrum{1}++;\n    }\n  }\n  # take care of last sequence\n  my $last_is_singlet = 1;\n  if (exists $has_overlap{$$seqlist[$max-1]}) {\n    $last_is_singlet = 0;\n  }\n  if ($last_is_singlet == 1) {\n    $spectrum{1}++;\n  }\n  # Parse overlap map\n  for my $seqid (@$seqlist) {\n    # list of sequences that should go in the contig\n    next if not exists $overlap_map{$seqid};\n    my @overlist = @{$overlap_map{$seqid}};\n    for (my $j = 0 ; $j < scalar(@overlist) ; $j++) {\n      my $otherseqid = $overlist[$j];\n      if (exists $overlap_map{$otherseqid}) {\n        push @overlist, @{$overlap_map{$otherseqid}};\n        delete $overlap_map{$otherseqid};\n      }\n    }\n    # remove duplicates from list\n    @overlist = sort @overlist;\n    for (my $j = 0 ; $j < scalar(@overlist)-1 ; $j++) {\n      if ( $overlist[$j] eq $overlist[$j+1] ) {\n        splice @overlist, $j, 1;\n        $j--;\n      }\n    }\n    # update spectrum with size of contig\n    my $qsize = scalar(@overlist) + 1;\n    if (defined $spectrum{$qsize}) {\n      $spectrum{$qsize}++;\n    } else {\n      $spectrum{$qsize} = 1;\n    }\n  }\n  return \\%spectrum;\n}\n\n\n=head2 _new_from_assembly\n\n  Title   : _new_from_assembly\n  Usage   : \n  Function: Creates a new contig spectrum object based solely on the result of \n            an assembly\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Scaffold\n\n\nsub _new_from_assembly {\n  # Create new contig spectrum object based purely on what we can get from the\n  # assembly object\n  my ($self, $assemblyobj) = @_;\n  my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n  # 1: Set id\n  $csp->{'_id'} = $assemblyobj->id;\n  # 2: Set overlap statistics: nof_overlaps, min_overlap, avg_overlap,\n  #  min_identity and avg_identity\n  $csp->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  if ($csp->{'_eff_asm_params'} > 0) {\n     my ($nover, $minl, $avgl, $minid, $avgid)\n       = $csp->_get_overlap_stats($assemblyobj);\n     $csp->{'_min_overlap'}  = $minl;\n     $csp->{'_min_identity'} = $minid;\n     $csp->{'_avg_overlap'}  = $avgl;\n     $csp->{'_avg_identity'} = $avgid;\n     $csp->{'_nof_overlaps'} = $nover;\n  }\n  # 3: Set sequence statistics: nof_seq and avg_seq_len\n  my ($nseq, $avgseql) = $self->_get_seq_stats($assemblyobj);\n  $csp->{'_avg_seq_len'} = $avgseql;\n  $csp->{'_nof_seq'}     = $nseq;\n  # 4: Set the spectrum: spectrum and max_size\n  for my $contigobj ($assemblyobj->all_contigs) {\n    my $size = $contigobj->num_sequences;\n    if (defined $csp->{'_spectrum'}{$size}) {\n      $csp->{'_spectrum'}{$size}++;\n    } else {\n      $csp->{'_spectrum'}{$size} = 1;\n    }\n    $csp->{'_max_size'} = $size if $size > $csp->{'_max_size'};\n  }\n  my $nof_singlets = $assemblyobj->get_nof_singlets();\n  if (defined $nof_singlets) {\n    $csp->{'_spectrum'}{1} += $nof_singlets;\n    $csp->{'_max_size'} = 1 if $nof_singlets >= 1 && $csp->{'_max_size'} < 1;\n  }\n  # 5: Set list of assembly objects used\n  push @{$csp->{'_assembly'}}, $assemblyobj;\n  # 6: Set number of repetitions\n  $csp->{'_nof_rep'} = 1;\n  return $csp;\n}\n\n\n\n=head2 _new_dissolved_csp\n\n  Title   : \n  Usage   : create a dissolved contig spectrum object\n  Function: \n  Returns : \n  Args    : \n\n\n\nsub _new_dissolved_csp {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  # Sanity checks on the mixed contig spectrum\n\n  # min_overlap and min_identity must be specified if there are some overlaps\n  # in the mixed contig\n  unless ($mixed_csp->{'_nof_overlaps'} == 0) {\n    unless ( defined $self->{'_min_overlap'} || \n      defined $mixed_csp->{'_min_overlap'} ) {\n      $self->throw(\"min_overlap must be defined in the dissolved contig spectrum\".\n        \" or mixed contig spectrum to dissolve a contig\");\n    }\n    unless ( defined $self->{'_min_identity'} ||\n      defined $mixed_csp->{'_min_identity'} ) {\n      $self->throw(\"min_identity must be defined in the dissolved contig spectrum\".\n        \" or mixed contig spectrum\");\n    }\n  }\n  \n  # there must be at least one assembly in mixed contig spectrum\n  if (!defined $mixed_csp->{'_assembly'} ||\n      scalar @{$mixed_csp->{'_assembly'}} < 1) {\n    $self->throw(\"The mixed contig spectrum must be based on at least one\n    assembly\");\n  }\n\n  # New dissolved contig spectrum object\n  my $dissolved = Bio::Assembly::Tools::ContigSpectrum->new();\n  \n  # take parent attributes if existent or mixed attributes otherwise\n  if ($self->{'_eff_asm_params'}) {\n    $dissolved->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  } else {\n    $dissolved->{'_eff_asm_params'} = $mixed_csp->{'_eff_asm_params'};\n  }\n  if ($self->{'_min_overlap'} && $self->{'_min_identity'}) {\n    ( $dissolved->{'_min_overlap'}, $dissolved->{'_min_identity'} ) = \n      ( $self->{'_min_overlap'}, $self->{'_min_identity'} );\n  } else {\n    ( $dissolved->{'_min_overlap'}, $dissolved->{'_min_identity'} ) = \n      ( $mixed_csp->{'_min_overlap'}, $mixed_csp->{'_min_identity'} );\n  }\n  \n  # Dissolve each assembly\n  for my $assembly (@{$mixed_csp->{'_assembly'}}) {\n    # Dissolve this assembly for the given sequences\n    my %asm_spectrum = (1 => 0);\n    my %good_seqs;\n    # For each contig\n    for my $contig ($assembly->all_contigs) {\n      # Get good sequences\n      my @contig_seqs;\n      for my $seq ($contig->each_seq) {\n        my $seq_id = $seq->id;\n        # get sequence origin\n        next unless $seq_id =~ m/^$seq_header\\|/;\n        # add it to hash\n        push @contig_seqs, $seq_id;\n        $good_seqs{$seq_id} = 1;\n      }\n      # Update spectrum\n      my $size = scalar @contig_seqs;\n      if ($size == 0) {\n        next;\n      } elsif ($size == 1) {\n        $asm_spectrum{1}++;\n      } elsif ($size > 1) {\n        # Reassemble good sequences\n        my $contig_spectrum = $dissolved->_naive_assembler(\n          $contig, \\@contig_seqs, $dissolved->{'_min_overlap'},\n          $dissolved->{'_min_identity'});\n        # update spectrum\n        for my $qsize (keys %$contig_spectrum) {\n          $asm_spectrum{$qsize} += $$contig_spectrum{$qsize};\n        }\n      } else {\n        $self->throw(\"The size is not valid... how could that happen?\");\n      }\n    }\n    # For each singlet\n    for my $singlet ($assembly->all_singlets) {\n      my $seq_id = $singlet->seqref->id;\n      # get sequence origin\n      next unless $seq_id =~ m/^$seq_header\\|/;\n      # add it to hash\n      $good_seqs{$seq_id} = 1;\n      # update spectrum\n      $asm_spectrum{1}++;\n    }\n    # Update spectrum\n    $dissolved->_import_spectrum(\\%asm_spectrum);\n    # Update nof_rep\n    $dissolved->{'_nof_rep'}--;\n    $dissolved->{'_nof_rep'} += $mixed_csp->{'_nof_rep'};\n\n    # Get sequence stats\n    my ($nseq, $avgseql) = $dissolved->_get_seq_stats($assembly, \\%good_seqs);\n    $dissolved->{'_avg_seq_len'} = $avgseql;\n    $dissolved->{'_nof_seq'}     = $nseq;\n  \n    # Get eff_asm_param for these sequences\n    if ($dissolved->{'_eff_asm_params'} > 0) {\n      my ($nover, $minl, $avgl, $minid, $avgid)\n        = $dissolved->_get_overlap_stats($assembly, \\%good_seqs);\n      $dissolved->{'_min_overlap'}  = $minl;\n      $dissolved->{'_min_identity'} = $minid;\n      $dissolved->{'_avg_overlap'}  = $avgl;\n      $dissolved->{'_avg_identity'} = $avgid;\n      $dissolved->{'_nof_overlaps'} = $nover;\n    }\n\n  }\n  return $dissolved;\n}\n\n\n=head2 _new_cross_csp\n\n  Title   : \n  Usage   : \n  Function: create a cross contig spectrum object\n  Returns : \n  Args    : \n\n\n\nsub _new_cross_csp {\n  my ($self, $mixed_csp) = @_;\n  # Sanity check on the mixed contig spectrum\n  # There must be at least one assembly\n  if (!defined $mixed_csp->{'_assembly'} ||\n      scalar @{$mixed_csp->{'_assembly'}} < 1) {\n    $self->throw(\"The mixed contig spectrum must be based on at least one \".\n    \"assembly.\");\n  }\n  \n  # New dissolved contig spectrum object\n  my $cross = Bio::Assembly::Tools::ContigSpectrum->new();\n  my %spectrum = (1 => 0);\n  \n  # Take parent or mixed attributes\n  if ($self->{'_eff_asm_params'}) {\n    $cross->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  } else {\n    $cross->{'_eff_asm_params'} = $mixed_csp->{'_eff_asm_params'};\n  }\n  if ($self->{'_min_overlap'} && $self->{'_min_identity'}) {\n    ( $cross->{'_min_overlap'}, $cross->{'_min_identity'} ) = \n      ( $self->{'_min_overlap'}, $self->{'_min_identity'} );\n  } else {\n    ( $cross->{'_min_overlap'}, $cross->{'_min_identity'} ) = \n      ( $mixed_csp->{'_min_overlap'}, $mixed_csp->{'_min_identity'} );\n  }\n  \n  # Get cross contig spectrum for each assembly\n  for my $assembly (@{$mixed_csp->{'_assembly'}}) {\n    # Go through contigs and skip the pure ones\n    my %good_seqs;\n    for my $contig ($assembly->all_contigs) {\n      # Get origins\n      my @seq_origins;\n      my @seq_ids;\n      for my $seq ($contig->each_seq) {\n        # current sequence origin\n        my $seq_id = $seq->id;\n        $seq_id =~ m/^(.+)\\|/;\n        my $seq_header = $1;\n        $self->warn(\"Sequence $seq_id does not seem to have a header. Skipping\".\n          \" it...\") if not defined $seq_header;\n        $seq_header ||= '';\n        push @seq_origins, $seq_header;\n        push @seq_ids, $seq_id;\n      }\n      my $qsize = scalar(@seq_ids);\n      my @origins = sort { $a cmp $b } @seq_origins;\n      my $size = scalar(@origins);\n      for (my $i = 1 ; $i < $size ; $i++) {\n        if ($origins[$i] eq $origins[$i-1]) {\n          splice @origins, $i, 1;\n          $i--;\n          $size--;\n        }\n      }\n      # Update cross-contig number in spectrum\n      if ($size > 1) { # cross-contig detected\n        # update good sequences\n        for my $seq_id (@seq_ids) {\n          $good_seqs{$seq_id} = 1;\n        }\n        # update number of cross q-contigs in spectrum\n        if (defined $spectrum{$qsize}) {\n          $spectrum{$qsize}++;\n        } else {\n          $spectrum{$qsize} = 1;\n        }\n      }\n      # Update number of cross 1-contigs\n      if ($size > 1) { # cross-contig detected\n        for my $origin (@origins) {\n          # sequences to use\n          my @ids;\n          for (my $i = 0 ; $i < $qsize ; $i++) {\n            my $seq_origin = $seq_origins[$i];\n            my $seq_id = $seq_ids[$i];\n            push @ids, $seq_id if $seq_origin eq $origin;\n          }\n          if (scalar @ids == 1) {\n            $spectrum{1}++;\n          } elsif (scalar @ids > 1) {\n            my $contig_spectrum = $cross->_naive_assembler(\n              $contig, \\@ids, $cross->{'_min_overlap'},\n              $cross->{'_min_identity'});\n            $spectrum{1} += $$contig_spectrum{1};\n          } else {\n            $self->throw(\"The size is <= 0. How could such a thing happen?\");\n          }\n        }\n      }\n    }\n    # Get sequence stats\n    my ($nseq, $avgseql) = $cross->_get_seq_stats($assembly, \\%good_seqs);\n    $cross->{'_avg_seq_len'} = $avgseql;\n    $cross->{'_nof_seq'}     = $nseq;\n    # Get eff_asm_param for these sequences\n    if ($cross->{'_eff_asm_params'} > 0) {\n      my ($nover, $minl, $avgl, $minid, $avgid)\n        = $cross->_get_overlap_stats($assembly, \\%good_seqs);\n      $cross->{'_min_overlap'}  = $minl;\n      $cross->{'_min_identity'} = $minid;\n      $cross->{'_avg_overlap'}  = $avgl;\n      $cross->{'_avg_identity'} = $avgid;\n      $cross->{'_nof_overlaps'} = $nover;\n    }\n  }\n  \n  $cross->_import_spectrum(\\%spectrum);\n  # Update nof_rep\n  $cross->{'_nof_rep'}--;\n  $cross->{'_nof_rep'} += $mixed_csp->{'_nof_rep'};\n  \n  return $cross;\n}\n\n=head2 _import_assembly\n\n  Title   : _import_assembly\n  Usage   : $csp->_import_assembly($assemblyobj);\n  Function: Update a contig spectrum object based on an assembly object\n  Returns : 1 for success, 0 for error\n  Args    : Bio::Assembly::Scaffold assembly object\n\n\nsub _import_assembly {\n  my ($self, $assemblyobj) = @_;\n  # Sanity check\n  if( !ref $assemblyobj || ! $assemblyobj->isa('Bio::Assembly::ScaffoldI') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::ScaffoldI assembly \".\n        \"object [\".ref($assemblyobj).\"]\");\n  }\n  # Create new object from assembly\n  my $csp = $self->_new_from_assembly($assemblyobj);\n  # Update current contig spectrum object with new one\n  $self->add($csp);\n  return 1;\n}\n\n\n=head2 _import_spectrum\n\n  Title   : _import_spectrum\n  Usage   : $csp->_import_spectrum({ 1 => 90 , 2 => 3 , 4 => 1 })\n  Function: update a contig spectrum object based on a contig spectrum\n            represented as a hash (key: contig size, value: number of contigs of\n            this size)\n  Returns : 1 for success, 0 for error\n  Args    : contig spectrum as a hash reference\n\n\nsub _import_spectrum {\n  my ($self, $spectrum) = @_;\n  # Sanity check\n  if( ! ref $spectrum || ! ref $spectrum eq 'HASH') {\n    $self->throw(\"Spectrum should be a hash reference, but it is [\".\n      ref($spectrum).\"]\");\n  }\n  \n  # Update the spectrum (+ nof_rep, max_size and nof_seq)\n  for my $size (keys %$spectrum) {\n    # Get the number of contigs of different size\n    if (defined $self->{'_spectrum'}{$size}) {\n      $self->{'_spectrum'}{$size} += $$spectrum{$size};\n    } else {\n      $self->{'_spectrum'}{$size} = $$spectrum{$size};\n    }\n    # Update nof_seq\n    $self->{'_nof_seq'} += $size * $$spectrum{$size};\n    # Update max_size\n    $self->{'_max_size'} = $size if $size > $self->{'_max_size'};\n  }\n  \n  # If the contig spectrum has only zero 1-contigs, max_size is zero\n  $self->{'_max_size'} = 0 if scalar keys %{$self->{'_spectrum'}} == 1 &&\n    defined $self->{'_spectrum'}{'1'} && $self->{'_spectrum'}{'1'} == 0;\n  \n  # Update nof_rep\n  $self->{'_nof_rep'}++;\n  return 1;\n}\n\n=head2 _import_dissolved_csp\n\n  Title   : _import_dissolved_csp\n  Usage   : $csp->_import_dissolved_csp($mixed_csp, $seq_header);\n  Function: Update a contig spectrum object by dissolving a mixed contig\n            spectrum based on the header of the sequences\n  Returns : 1 for success, 0 for error\n  Args    : Bio::Assembly::Tools::ContigSpectrum\n            sequence header string","label":"_import_dissolved_csp($self,$mixed_csp,$seq_header)"},"detail":"($self,$mixed_csp,$seq_header)","definition":"sub","containerName":"main::"},{"detail":"($self,$mixed_csp)","signature":{"parameters":[{"label":"$self"},{"label":"$mixed_csp"}],"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none\n\n\nsub drop_assembly {\n  my ($self) = @_;\n  $self->{'_assembly'} = [];\n  return 1;\n}\n\n=head2 dissolve\n\n  Title   : dissolve\n  Usage   : $dissolved_csp->dissolve($mixed_csp, $seq_header);\n  Function: Dissolve a mixed contig spectrum for the set of sequences that\n            contain the specified header, i.e. determine the contribution of\n            these sequences to the mixed contig spectrum based on the assembly.\n            The mixed contig spectrum object must have been created based on one\n            (or several) assembly object(s). Additionally, min_overlap and\n            min_identity must have been set (either manually using min_overlap\n            or automatically by switching on the eff_asm_params option).\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n            sequence header string\n\n\n\nsub dissolve {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  $self->_import_dissolved_csp($mixed_csp, $seq_header);\n  return 1;\n}\n\n\n=head2 cross\n\n  Title   : cross\n  Usage   : $cross_csp->cross($mixed_csp);\n  Function: Calculate a cross contig_spectrum based on a mixed contig_spectrum.\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n\n\nsub cross {\n  my ($self, $mixed_csp) = @_;\n  $self->_import_cross_csp($mixed_csp);\n  return 1;\n}\n\n=head2 to_string\n\n  Title   : to_string\n  Usage   : my $csp_string = $csp->to_string;\n  Function: Convert the contig spectrum into a string (easy to print!!).\n  Returns : string\n  Args    : element separator (integer) [optional]\n              1 -> space-separated\n              2 -> tab-separated\n              3 -> newline-separated\n\n\nsub to_string {\n  my ($self, $element_separator) = @_;\n  return 0 if $self->{'_max_size'} == 0;\n  $element_separator ||= 1;\n  if ($element_separator == 1) {\n    $element_separator = ' ';\n  } elsif ($element_separator == 2) {\n    $element_separator = \"\\t\";\n  } elsif ($element_separator == 3) {\n    $element_separator = \"\\n\";\n  } else {\n    $self->throw(\"Unknown separator type '$element_separator'\\n\");\n  }\n  my $str = '';\n  for (my $q = 1 ; $q <= $self->{'_max_size'} ; $q++) {\n    my $val = 0;\n    if (exists $self->{'_spectrum'}{$q}) {\n      $val = $self->{'_spectrum'}{$q};\n    }\n    $str .= $val.$element_separator;\n  }\n  $str =~ s/\\s$//;\n  return $str;\n}\n\n\n=head2 add\n\n  Title   : add\n  Usage   : $csp->add($additional_csp);\n  Function: Add a contig spectrum to an existing one: sums the spectra, update\n            the number of sequences, number of repetitions, ...\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum object\n\n\nsub add {\n  my ($self, $csp) = @_;\n  # Sanity check\n  if( !ref $csp || ! $csp->isa('Bio::Assembly::Tools::ContigSpectrum') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n  }\n  # Update overlap statistics\n  if ( $self->{'_eff_asm_params'} > 0 ) {\n    # Warnings\n    if ( $csp->{'_eff_asm_params'} == 0 ) {\n      $self->warn(\"The parent contig spectrum needs effective assembly \".\n        \"parameters (eff_asm_params = \".$self->{'_eff_asm_params'}.\") but the \".\n        \"child contig spectrum doesn't have them (eff_asm_params = \".\n        $csp->{'_eff_asm_params'}.\"). Skipping them...\");\n    } elsif ( $csp->{'_eff_asm_params'} != $self->{'_eff_asm_params'} ) {\n      $self->warn(\"The parent contig spectrum needs a different method for \".\n        \"detecting the effective assembly parameters (eff_asm_params = \".\n        $self->{'_eff_asm_params'}.\") than the one specified for the child \".\n        \"contig spectrum (eff_asm_params = \".$csp->{'_eff_asm_params'}.\"). \".\n        \"Ignoring the differences...\");\n    }\n    # Update existing stats\n    my $tot_num_overlaps = $csp->{'_nof_overlaps'} + $self->{'_nof_overlaps'};\n    $self->{'_min_overlap'} = $csp->{'_min_overlap'} if\n      defined $csp->{'_min_overlap'} && ( ! defined $self->{'_min_overlap'} ||\n      $csp->{'_min_overlap'} < $self->{'_min_overlap'} );\n    $self->{'_min_identity'} = $csp->{'_min_identity'} if\n      defined $csp->{'_min_identity'} && ( ! defined $self->{'_min_identity'} ||\n      $csp->{'_min_identity'} < $self->{'_min_identity'} );\n    if ($tot_num_overlaps != 0) {\n      $self->{'_avg_overlap'} =\n        ($csp->{'_avg_overlap'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_overlap'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n      $self->{'_avg_identity'} =\n        ($csp->{'_avg_identity'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_identity'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n    }\n    $self->{'_nof_overlaps'} = $tot_num_overlaps;\n  }\n  # Update sequence statistics\n  my $tot_nof_seq = $csp->{'_nof_seq'} + $self->{'_nof_seq'};\n  if (not $tot_nof_seq == 0) {\n    $self->{'_avg_seq_len'} = ($csp->{'_avg_seq_len'} * $csp->{'_nof_seq'} +\n      $self->{'_avg_seq_len'} * $self->{'_nof_seq'}) / $tot_nof_seq;\n  }\n  # Update spectrum (and nof_seq, max_size, and increment nof_rep by 1)\n  $self->_import_spectrum($csp->{'_spectrum'});\n  # Update nof_rep\n  $self->{'_nof_rep'}--;\n  $self->{'_nof_rep'} += $csp->{'_nof_rep'};\n  # Update list of assembly objects used\n  push @{$self->{'_assembly'}}, @{$csp->{'_assembly'}}\n    if defined $csp->{'_assembly'};\n  return 1;\n}\n\n\n=head2 average\n\n  Title   : average\n  Usage   : my $avg_csp = $csp->average([$csp1, $csp2, $csp3]);\n  Function: Average one contig spectrum or the sum of several contig spectra by\n            the number of repetitions\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Tools::ContigSpectrum array reference\n            eff_asm_params\n\n\nsub average {\n  my ($self, $list) = @_;\n  # Sanity check\n  if ( ! ref $list || ! ref $list eq 'ARRAY') {\n    $self->throw(\"Average takes an array reference but got [\".ref($list).\"]\");\n  }\n  # New average contig spectrum object\n  my $avg = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg->{'_eff_asm_params'} = 1;\n  \n  # Cycle through contig spectra\n  my $tot_nof_rep = 0;\n  for my $csp (@$list) {\n    # Sanity check\n    if (not $csp->isa('Bio::Assembly::Tools::ContigSpectrum')) {\n      $csp->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n    }\n    # Import contig spectrum\n    $avg->add($csp);\n  }\n  \n  # Average sum of contig spectra by number of repetitions\n  for (my $q = 1 ; $q <= $avg->{'_max_size'} ; $q++) {\n    $avg->{'_spectrum'}{$q} /= $avg->{'_nof_rep'}\n      if (defined $avg->{'_spectrum'}{$q});\n  }\n  # Average number of sequences\n  $avg->{'_nof_seq'} /= $avg->{'_nof_rep'};\n  # Average number of overlaps\n  $avg->{'_nof_overlaps'} /= $avg->{'_nof_rep'};\n  \n  return $avg;\n}\n\n\n=head2 score\n\n  Title   : score\n  Usage   : my $score = $csp->score();\n  Function: Score a contig spectrum (or cross-contig spectrum) such that the\n             higher the number of contigs (or cross-contigs) and the larger their \n             size, the higher the score.\n             Let n   : total number of sequences\n                 c_q : number of contigs of size q\n                 q   : number of sequence in a contig\n             We define: score = n/(n-1) * (X - 1/n)\n                  where X = sum ( c_q * q^2 ) / n**2\n             The score ranges from 0 (singlets only) to 1 (a single large contig)\n             It is possible to specify a value for the number of sequences to\n              assume in the contig spectrum.\n  Returns : contig score\n  Args    : number of total sequences to assume [optional]\n\n\nsub score {\n  my ($self, $nof_seqs) = @_;\n  # Main\n  my $score = 0;\n  my $n = $self->nof_seq;\n  if ( $n > 0 ) {\n    # Contig spectrum info\n    my $q_max = $self->max_size;\n    my $spec  = $self->spectrum;\n    # Adjust number of 1-contigs\n    if ( $nof_seqs ) {\n      $spec->{'1'} += $nof_seqs - $n;\n      $n = $nof_seqs;\n    }\n    # Calculate X\n    for my $q ( 1 .. $q_max ) {\n      if ( $spec->{$q} ) {\n        my $c_q = $spec->{$q};\n        $score += $c_q * $q ** 2;\n      }\n    }\n    $score /= $n ** 2; \n  }\n  # Rescale X to obtain the score\n  $score = $n/($n-1) * ($score - 1/$n);\n  return $score;\n}\n\n\n=head2 _naive_assembler\n\n  Title   : _naive_assembler\n  Usage   : \n  Function: Determines the contig spectrum (hash representation) of a subset of\n            sequences from a mixed contig spectrum by \"reassembling\" the\n            specified sequences only based on their position in the contig. This\n            naive assembly only verifies that the minimum overlap length and\n            percentage identity are respected. There is no actual alignment done\n  Returns : contig spectrum hash reference\n  Args    : Bio::Assembly::Contig\n            sequence ID array reference\n            minimum overlap length (integer) [optional]\n            minimum percentage identity (integer) [optional]\n\n\nsub _naive_assembler {\n  my ($self, $contig, $seqlist, $min_overlap, $min_identity) = @_;\n  # Sanity checks\n  if ( ! ref $seqlist || ! ref($seqlist) eq 'ARRAY') {\n    $self->throw('Expecting an array reference. Got ['.ref($seqlist).\"] \\n\");\n  }\n  my $max = scalar @$seqlist;\n  $self->throw(\"Expecting at least 2 sequences as input for _naive_assembler\")\n    if ($max < 2);\n  # Assembly\n  my %spectrum = (1 => 0);\n  my %overlap_map;\n  my %has_overlap;\n  # Map what sequences overlap with what sequences\n  for (my $i = 0 ; $i < $max-1 ; $i++) {\n    # query sequence\n    my $qseqid = $$seqlist[$i];\n    my $qseq   = $contig->get_seq_by_name($qseqid);\n    my $is_singlet = 1;\n    for (my $j = $i+1 ; $j < $max ; $j++) {\n      # target sequence\n      my $tseqid = $$seqlist[$j];\n      my $tseq = $contig->get_seq_by_name($tseqid);\n      # try to align sequences\n      my ($aln, $overlap, $identity)\n        = $self->_overlap_alignment($contig, $qseq, $tseq, $min_overlap,\n        $min_identity);\n      # if there is no valid overlap, go to next sequence\n      next if ! defined $aln;\n      # the overlap is valid\n      $is_singlet = 0;\n      push @{$overlap_map{$qseqid}}, $tseqid;\n      $has_overlap{$tseqid} = 1;\n      $has_overlap{$qseqid} = 1;\n    }\n    # check if sequence is in previously seen overlap\n    if (exists $has_overlap{$qseqid}) {\n      $is_singlet = 0;\n    }\n    if ($is_singlet == 1) {\n      $spectrum{1}++;\n    }\n  }\n  # take care of last sequence\n  my $last_is_singlet = 1;\n  if (exists $has_overlap{$$seqlist[$max-1]}) {\n    $last_is_singlet = 0;\n  }\n  if ($last_is_singlet == 1) {\n    $spectrum{1}++;\n  }\n  # Parse overlap map\n  for my $seqid (@$seqlist) {\n    # list of sequences that should go in the contig\n    next if not exists $overlap_map{$seqid};\n    my @overlist = @{$overlap_map{$seqid}};\n    for (my $j = 0 ; $j < scalar(@overlist) ; $j++) {\n      my $otherseqid = $overlist[$j];\n      if (exists $overlap_map{$otherseqid}) {\n        push @overlist, @{$overlap_map{$otherseqid}};\n        delete $overlap_map{$otherseqid};\n      }\n    }\n    # remove duplicates from list\n    @overlist = sort @overlist;\n    for (my $j = 0 ; $j < scalar(@overlist)-1 ; $j++) {\n      if ( $overlist[$j] eq $overlist[$j+1] ) {\n        splice @overlist, $j, 1;\n        $j--;\n      }\n    }\n    # update spectrum with size of contig\n    my $qsize = scalar(@overlist) + 1;\n    if (defined $spectrum{$qsize}) {\n      $spectrum{$qsize}++;\n    } else {\n      $spectrum{$qsize} = 1;\n    }\n  }\n  return \\%spectrum;\n}\n\n\n=head2 _new_from_assembly\n\n  Title   : _new_from_assembly\n  Usage   : \n  Function: Creates a new contig spectrum object based solely on the result of \n            an assembly\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Scaffold\n\n\nsub _new_from_assembly {\n  # Create new contig spectrum object based purely on what we can get from the\n  # assembly object\n  my ($self, $assemblyobj) = @_;\n  my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n  # 1: Set id\n  $csp->{'_id'} = $assemblyobj->id;\n  # 2: Set overlap statistics: nof_overlaps, min_overlap, avg_overlap,\n  #  min_identity and avg_identity\n  $csp->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  if ($csp->{'_eff_asm_params'} > 0) {\n     my ($nover, $minl, $avgl, $minid, $avgid)\n       = $csp->_get_overlap_stats($assemblyobj);\n     $csp->{'_min_overlap'}  = $minl;\n     $csp->{'_min_identity'} = $minid;\n     $csp->{'_avg_overlap'}  = $avgl;\n     $csp->{'_avg_identity'} = $avgid;\n     $csp->{'_nof_overlaps'} = $nover;\n  }\n  # 3: Set sequence statistics: nof_seq and avg_seq_len\n  my ($nseq, $avgseql) = $self->_get_seq_stats($assemblyobj);\n  $csp->{'_avg_seq_len'} = $avgseql;\n  $csp->{'_nof_seq'}     = $nseq;\n  # 4: Set the spectrum: spectrum and max_size\n  for my $contigobj ($assemblyobj->all_contigs) {\n    my $size = $contigobj->num_sequences;\n    if (defined $csp->{'_spectrum'}{$size}) {\n      $csp->{'_spectrum'}{$size}++;\n    } else {\n      $csp->{'_spectrum'}{$size} = 1;\n    }\n    $csp->{'_max_size'} = $size if $size > $csp->{'_max_size'};\n  }\n  my $nof_singlets = $assemblyobj->get_nof_singlets();\n  if (defined $nof_singlets) {\n    $csp->{'_spectrum'}{1} += $nof_singlets;\n    $csp->{'_max_size'} = 1 if $nof_singlets >= 1 && $csp->{'_max_size'} < 1;\n  }\n  # 5: Set list of assembly objects used\n  push @{$csp->{'_assembly'}}, $assemblyobj;\n  # 6: Set number of repetitions\n  $csp->{'_nof_rep'} = 1;\n  return $csp;\n}\n\n\n\n=head2 _new_dissolved_csp\n\n  Title   : \n  Usage   : create a dissolved contig spectrum object\n  Function: \n  Returns : \n  Args    : \n\n\n\nsub _new_dissolved_csp {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  # Sanity checks on the mixed contig spectrum\n\n  # min_overlap and min_identity must be specified if there are some overlaps\n  # in the mixed contig\n  unless ($mixed_csp->{'_nof_overlaps'} == 0) {\n    unless ( defined $self->{'_min_overlap'} || \n      defined $mixed_csp->{'_min_overlap'} ) {\n      $self->throw(\"min_overlap must be defined in the dissolved contig spectrum\".\n        \" or mixed contig spectrum to dissolve a contig\");\n    }\n    unless ( defined $self->{'_min_identity'} ||\n      defined $mixed_csp->{'_min_identity'} ) {\n      $self->throw(\"min_identity must be defined in the dissolved contig spectrum\".\n        \" or mixed contig spectrum\");\n    }\n  }\n  \n  # there must be at least one assembly in mixed contig spectrum\n  if (!defined $mixed_csp->{'_assembly'} ||\n      scalar @{$mixed_csp->{'_assembly'}} < 1) {\n    $self->throw(\"The mixed contig spectrum must be based on at least one\n    assembly\");\n  }\n\n  # New dissolved contig spectrum object\n  my $dissolved = Bio::Assembly::Tools::ContigSpectrum->new();\n  \n  # take parent attributes if existent or mixed attributes otherwise\n  if ($self->{'_eff_asm_params'}) {\n    $dissolved->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  } else {\n    $dissolved->{'_eff_asm_params'} = $mixed_csp->{'_eff_asm_params'};\n  }\n  if ($self->{'_min_overlap'} && $self->{'_min_identity'}) {\n    ( $dissolved->{'_min_overlap'}, $dissolved->{'_min_identity'} ) = \n      ( $self->{'_min_overlap'}, $self->{'_min_identity'} );\n  } else {\n    ( $dissolved->{'_min_overlap'}, $dissolved->{'_min_identity'} ) = \n      ( $mixed_csp->{'_min_overlap'}, $mixed_csp->{'_min_identity'} );\n  }\n  \n  # Dissolve each assembly\n  for my $assembly (@{$mixed_csp->{'_assembly'}}) {\n    # Dissolve this assembly for the given sequences\n    my %asm_spectrum = (1 => 0);\n    my %good_seqs;\n    # For each contig\n    for my $contig ($assembly->all_contigs) {\n      # Get good sequences\n      my @contig_seqs;\n      for my $seq ($contig->each_seq) {\n        my $seq_id = $seq->id;\n        # get sequence origin\n        next unless $seq_id =~ m/^$seq_header\\|/;\n        # add it to hash\n        push @contig_seqs, $seq_id;\n        $good_seqs{$seq_id} = 1;\n      }\n      # Update spectrum\n      my $size = scalar @contig_seqs;\n      if ($size == 0) {\n        next;\n      } elsif ($size == 1) {\n        $asm_spectrum{1}++;\n      } elsif ($size > 1) {\n        # Reassemble good sequences\n        my $contig_spectrum = $dissolved->_naive_assembler(\n          $contig, \\@contig_seqs, $dissolved->{'_min_overlap'},\n          $dissolved->{'_min_identity'});\n        # update spectrum\n        for my $qsize (keys %$contig_spectrum) {\n          $asm_spectrum{$qsize} += $$contig_spectrum{$qsize};\n        }\n      } else {\n        $self->throw(\"The size is not valid... how could that happen?\");\n      }\n    }\n    # For each singlet\n    for my $singlet ($assembly->all_singlets) {\n      my $seq_id = $singlet->seqref->id;\n      # get sequence origin\n      next unless $seq_id =~ m/^$seq_header\\|/;\n      # add it to hash\n      $good_seqs{$seq_id} = 1;\n      # update spectrum\n      $asm_spectrum{1}++;\n    }\n    # Update spectrum\n    $dissolved->_import_spectrum(\\%asm_spectrum);\n    # Update nof_rep\n    $dissolved->{'_nof_rep'}--;\n    $dissolved->{'_nof_rep'} += $mixed_csp->{'_nof_rep'};\n\n    # Get sequence stats\n    my ($nseq, $avgseql) = $dissolved->_get_seq_stats($assembly, \\%good_seqs);\n    $dissolved->{'_avg_seq_len'} = $avgseql;\n    $dissolved->{'_nof_seq'}     = $nseq;\n  \n    # Get eff_asm_param for these sequences\n    if ($dissolved->{'_eff_asm_params'} > 0) {\n      my ($nover, $minl, $avgl, $minid, $avgid)\n        = $dissolved->_get_overlap_stats($assembly, \\%good_seqs);\n      $dissolved->{'_min_overlap'}  = $minl;\n      $dissolved->{'_min_identity'} = $minid;\n      $dissolved->{'_avg_overlap'}  = $avgl;\n      $dissolved->{'_avg_identity'} = $avgid;\n      $dissolved->{'_nof_overlaps'} = $nover;\n    }\n\n  }\n  return $dissolved;\n}\n\n\n=head2 _new_cross_csp\n\n  Title   : \n  Usage   : \n  Function: create a cross contig spectrum object\n  Returns : \n  Args    : \n\n\n\nsub _new_cross_csp {\n  my ($self, $mixed_csp) = @_;\n  # Sanity check on the mixed contig spectrum\n  # There must be at least one assembly\n  if (!defined $mixed_csp->{'_assembly'} ||\n      scalar @{$mixed_csp->{'_assembly'}} < 1) {\n    $self->throw(\"The mixed contig spectrum must be based on at least one \".\n    \"assembly.\");\n  }\n  \n  # New dissolved contig spectrum object\n  my $cross = Bio::Assembly::Tools::ContigSpectrum->new();\n  my %spectrum = (1 => 0);\n  \n  # Take parent or mixed attributes\n  if ($self->{'_eff_asm_params'}) {\n    $cross->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  } else {\n    $cross->{'_eff_asm_params'} = $mixed_csp->{'_eff_asm_params'};\n  }\n  if ($self->{'_min_overlap'} && $self->{'_min_identity'}) {\n    ( $cross->{'_min_overlap'}, $cross->{'_min_identity'} ) = \n      ( $self->{'_min_overlap'}, $self->{'_min_identity'} );\n  } else {\n    ( $cross->{'_min_overlap'}, $cross->{'_min_identity'} ) = \n      ( $mixed_csp->{'_min_overlap'}, $mixed_csp->{'_min_identity'} );\n  }\n  \n  # Get cross contig spectrum for each assembly\n  for my $assembly (@{$mixed_csp->{'_assembly'}}) {\n    # Go through contigs and skip the pure ones\n    my %good_seqs;\n    for my $contig ($assembly->all_contigs) {\n      # Get origins\n      my @seq_origins;\n      my @seq_ids;\n      for my $seq ($contig->each_seq) {\n        # current sequence origin\n        my $seq_id = $seq->id;\n        $seq_id =~ m/^(.+)\\|/;\n        my $seq_header = $1;\n        $self->warn(\"Sequence $seq_id does not seem to have a header. Skipping\".\n          \" it...\") if not defined $seq_header;\n        $seq_header ||= '';\n        push @seq_origins, $seq_header;\n        push @seq_ids, $seq_id;\n      }\n      my $qsize = scalar(@seq_ids);\n      my @origins = sort { $a cmp $b } @seq_origins;\n      my $size = scalar(@origins);\n      for (my $i = 1 ; $i < $size ; $i++) {\n        if ($origins[$i] eq $origins[$i-1]) {\n          splice @origins, $i, 1;\n          $i--;\n          $size--;\n        }\n      }\n      # Update cross-contig number in spectrum\n      if ($size > 1) { # cross-contig detected\n        # update good sequences\n        for my $seq_id (@seq_ids) {\n          $good_seqs{$seq_id} = 1;\n        }\n        # update number of cross q-contigs in spectrum\n        if (defined $spectrum{$qsize}) {\n          $spectrum{$qsize}++;\n        } else {\n          $spectrum{$qsize} = 1;\n        }\n      }\n      # Update number of cross 1-contigs\n      if ($size > 1) { # cross-contig detected\n        for my $origin (@origins) {\n          # sequences to use\n          my @ids;\n          for (my $i = 0 ; $i < $qsize ; $i++) {\n            my $seq_origin = $seq_origins[$i];\n            my $seq_id = $seq_ids[$i];\n            push @ids, $seq_id if $seq_origin eq $origin;\n          }\n          if (scalar @ids == 1) {\n            $spectrum{1}++;\n          } elsif (scalar @ids > 1) {\n            my $contig_spectrum = $cross->_naive_assembler(\n              $contig, \\@ids, $cross->{'_min_overlap'},\n              $cross->{'_min_identity'});\n            $spectrum{1} += $$contig_spectrum{1};\n          } else {\n            $self->throw(\"The size is <= 0. How could such a thing happen?\");\n          }\n        }\n      }\n    }\n    # Get sequence stats\n    my ($nseq, $avgseql) = $cross->_get_seq_stats($assembly, \\%good_seqs);\n    $cross->{'_avg_seq_len'} = $avgseql;\n    $cross->{'_nof_seq'}     = $nseq;\n    # Get eff_asm_param for these sequences\n    if ($cross->{'_eff_asm_params'} > 0) {\n      my ($nover, $minl, $avgl, $minid, $avgid)\n        = $cross->_get_overlap_stats($assembly, \\%good_seqs);\n      $cross->{'_min_overlap'}  = $minl;\n      $cross->{'_min_identity'} = $minid;\n      $cross->{'_avg_overlap'}  = $avgl;\n      $cross->{'_avg_identity'} = $avgid;\n      $cross->{'_nof_overlaps'} = $nover;\n    }\n  }\n  \n  $cross->_import_spectrum(\\%spectrum);\n  # Update nof_rep\n  $cross->{'_nof_rep'}--;\n  $cross->{'_nof_rep'} += $mixed_csp->{'_nof_rep'};\n  \n  return $cross;\n}\n\n=head2 _import_assembly\n\n  Title   : _import_assembly\n  Usage   : $csp->_import_assembly($assemblyobj);\n  Function: Update a contig spectrum object based on an assembly object\n  Returns : 1 for success, 0 for error\n  Args    : Bio::Assembly::Scaffold assembly object\n\n\nsub _import_assembly {\n  my ($self, $assemblyobj) = @_;\n  # Sanity check\n  if( !ref $assemblyobj || ! $assemblyobj->isa('Bio::Assembly::ScaffoldI') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::ScaffoldI assembly \".\n        \"object [\".ref($assemblyobj).\"]\");\n  }\n  # Create new object from assembly\n  my $csp = $self->_new_from_assembly($assemblyobj);\n  # Update current contig spectrum object with new one\n  $self->add($csp);\n  return 1;\n}\n\n\n=head2 _import_spectrum\n\n  Title   : _import_spectrum\n  Usage   : $csp->_import_spectrum({ 1 => 90 , 2 => 3 , 4 => 1 })\n  Function: update a contig spectrum object based on a contig spectrum\n            represented as a hash (key: contig size, value: number of contigs of\n            this size)\n  Returns : 1 for success, 0 for error\n  Args    : contig spectrum as a hash reference\n\n\nsub _import_spectrum {\n  my ($self, $spectrum) = @_;\n  # Sanity check\n  if( ! ref $spectrum || ! ref $spectrum eq 'HASH') {\n    $self->throw(\"Spectrum should be a hash reference, but it is [\".\n      ref($spectrum).\"]\");\n  }\n  \n  # Update the spectrum (+ nof_rep, max_size and nof_seq)\n  for my $size (keys %$spectrum) {\n    # Get the number of contigs of different size\n    if (defined $self->{'_spectrum'}{$size}) {\n      $self->{'_spectrum'}{$size} += $$spectrum{$size};\n    } else {\n      $self->{'_spectrum'}{$size} = $$spectrum{$size};\n    }\n    # Update nof_seq\n    $self->{'_nof_seq'} += $size * $$spectrum{$size};\n    # Update max_size\n    $self->{'_max_size'} = $size if $size > $self->{'_max_size'};\n  }\n  \n  # If the contig spectrum has only zero 1-contigs, max_size is zero\n  $self->{'_max_size'} = 0 if scalar keys %{$self->{'_spectrum'}} == 1 &&\n    defined $self->{'_spectrum'}{'1'} && $self->{'_spectrum'}{'1'} == 0;\n  \n  # Update nof_rep\n  $self->{'_nof_rep'}++;\n  return 1;\n}\n\n=head2 _import_dissolved_csp\n\n  Title   : _import_dissolved_csp\n  Usage   : $csp->_import_dissolved_csp($mixed_csp, $seq_header);\n  Function: Update a contig spectrum object by dissolving a mixed contig\n            spectrum based on the header of the sequences\n  Returns : 1 for success, 0 for error\n  Args    : Bio::Assembly::Tools::ContigSpectrum\n            sequence header string\n\n\nsub _import_dissolved_csp {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  # Sanity check\n  if (not defined $mixed_csp || not defined $seq_header) {\n    $self->throw(\"Expecting a contig spectrum reference and sequence header as\".\n    \" arguments\");\n  }\n  # Create new object from assembly\n  my $dissolved_csp = $self->_new_dissolved_csp($mixed_csp, $seq_header);\n  # Update current contig spectrum object with new one\n  $self->add($dissolved_csp);\n  return 1;\n}\n\n\n=head2 _import_cross_csp\n\n  Title   : _import_cross_csp\n  Usage   : $csp->_import_cross_csp($mixed_csp);\n  Function: Update a contig spectrum object by calculating the cross contig\n            spectrum based on a mixed contig spectrum\n  Returns : 1 for success, 0 for error\n  Args    : Bio::Assembly::Tools::ContigSpectrum","label":"_import_cross_csp($self,$mixed_csp)"},"containerName":"main::","definition":"sub","line":1355,"children":[{"line":1356,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_import_cross_csp"},{"line":1356,"kind":13,"name":"$mixed_csp","containerName":"_import_cross_csp"},{"containerName":"_import_cross_csp","name":"$mixed_csp","kind":13,"line":1358},{"line":1359,"kind":13,"containerName":"_import_cross_csp","name":"$self"},{"containerName":"_import_cross_csp","name":"throw","kind":12,"line":1359},{"containerName":"_import_cross_csp","name":"$cross_csp","definition":"my","localvar":"my","kind":13,"line":1363},{"kind":13,"line":1363,"containerName":"_import_cross_csp","name":"$self"},{"containerName":"_import_cross_csp","name":"_new_cross_csp","line":1363,"kind":12},{"name":"$mixed_csp","containerName":"_import_cross_csp","kind":13,"line":1363},{"line":1366,"kind":13,"name":"$self","containerName":"_import_cross_csp"},{"line":1366,"kind":12,"name":"add","containerName":"_import_cross_csp"},{"line":1366,"kind":13,"containerName":"_import_cross_csp","name":"$cross_csp"}],"kind":12,"range":{"end":{"character":9999,"line":1369},"start":{"line":1355,"character":0}},"name":"_import_cross_csp"},{"children":[{"containerName":"_get_seq_stats","definition":"my","name":"$self","localvar":"my","kind":13,"line":1386},{"name":"$assemblyobj","containerName":"_get_seq_stats","line":1386,"kind":13},{"containerName":"_get_seq_stats","name":"$seq_hash","line":1386,"kind":13},{"line":1389,"kind":13,"containerName":"_get_seq_stats","name":"$self"},{"kind":12,"line":1389,"containerName":"_get_seq_stats","name":"throw"},{"name":"$assemblyobj","containerName":"_get_seq_stats","kind":13,"line":1390},{"containerName":"_get_seq_stats","name":"$assemblyobj","line":1390,"kind":13},{"line":1390,"kind":12,"containerName":"_get_seq_stats","name":"isa"},{"containerName":"_get_seq_stats","name":"$self","line":1391,"kind":13},{"containerName":"_get_seq_stats","name":"throw","line":1391,"kind":12},{"name":"$seq_hash","containerName":"_get_seq_stats","line":1391,"kind":13},{"containerName":"_get_seq_stats","name":"$seq_hash","line":1392,"kind":13},{"name":"$seq_hash","containerName":"_get_seq_stats","line":1392,"kind":13},{"name":"$avg_seq_len","definition":"my","containerName":"_get_seq_stats","localvar":"my","kind":13,"line":1394},{"containerName":"_get_seq_stats","name":"$nof_seq","definition":"my","localvar":"my","kind":13,"line":1395},{"kind":13,"line":1396,"definition":"my","name":"$contigobj","containerName":"_get_seq_stats","localvar":"my"},{"containerName":"_get_seq_stats","name":"$assemblyobj","line":1396,"kind":13},{"kind":12,"line":1396,"name":"all_contigs","containerName":"_get_seq_stats"},{"containerName":"_get_seq_stats","definition":"my","name":"$seqobj","localvar":"my","kind":13,"line":1397},{"line":1397,"kind":13,"containerName":"_get_seq_stats","name":"$contigobj"},{"containerName":"_get_seq_stats","name":"each_seq","kind":12,"line":1397},{"kind":13,"line":1398,"containerName":"_get_seq_stats","name":"$seq_id","definition":"my","localvar":"my"},{"kind":13,"line":1398,"containerName":"_get_seq_stats","name":"$seqobj"},{"containerName":"_get_seq_stats","name":"id","kind":12,"line":1398},{"line":1399,"kind":13,"containerName":"_get_seq_stats","name":"$seq_hash"},{"name":"$seq_id","containerName":"_get_seq_stats","kind":13,"line":1399},{"kind":13,"line":1400,"containerName":"_get_seq_stats","name":"$nof_seq"},{"definition":"my","name":"$seq_string","containerName":"_get_seq_stats","localvar":"my","kind":13,"line":1401},{"kind":13,"line":1401,"name":"$seqobj","containerName":"_get_seq_stats"},{"line":1401,"kind":12,"containerName":"_get_seq_stats","name":"seq"},{"name":"$seq_string","containerName":"_get_seq_stats","kind":13,"line":1402},{"name":"$avg_seq_len","containerName":"_get_seq_stats","kind":13,"line":1403},{"containerName":"_get_seq_stats","name":"$seq_string","kind":13,"line":1403},{"containerName":"_get_seq_stats","name":"$singletobj","definition":"my","localvar":"my","kind":13,"line":1406},{"containerName":"_get_seq_stats","name":"$assemblyobj","line":1406,"kind":13},{"line":1406,"kind":12,"containerName":"_get_seq_stats","name":"all_singlets"},{"line":1407,"kind":13,"localvar":"my","definition":"my","name":"$seq_id","containerName":"_get_seq_stats"},{"kind":13,"line":1407,"containerName":"_get_seq_stats","name":"$singletobj"},{"containerName":"_get_seq_stats","name":"seqref","kind":12,"line":1407},{"kind":12,"line":1407,"containerName":"_get_seq_stats","name":"id"},{"kind":13,"line":1408,"containerName":"_get_seq_stats","name":"$seq_hash"},{"containerName":"_get_seq_stats","name":"$seq_id","kind":13,"line":1408},{"containerName":"_get_seq_stats","name":"$nof_seq","line":1409,"kind":13},{"kind":13,"line":1410,"containerName":"_get_seq_stats","name":"$seq_string","definition":"my","localvar":"my"},{"line":1410,"kind":13,"name":"$singletobj","containerName":"_get_seq_stats"},{"containerName":"_get_seq_stats","name":"seqref","line":1410,"kind":12},{"kind":12,"line":1410,"name":"seq","containerName":"_get_seq_stats"},{"line":1411,"kind":13,"containerName":"_get_seq_stats","name":"$seq_string"},{"name":"$avg_seq_len","containerName":"_get_seq_stats","kind":13,"line":1412},{"name":"$seq_string","containerName":"_get_seq_stats","kind":13,"line":1412},{"line":1414,"kind":13,"name":"$avg_seq_len","containerName":"_get_seq_stats"},{"containerName":"_get_seq_stats","name":"$nof_seq","line":1414,"kind":13},{"containerName":"_get_seq_stats","name":"$nof_seq","kind":13,"line":1414},{"containerName":"_get_seq_stats","name":"$nof_seq","line":1415,"kind":13},{"containerName":"_get_seq_stats","name":"$avg_seq_len","kind":13,"line":1415}],"line":1385,"kind":12,"signature":{"label":"_get_seq_stats($self,$assemblyobj,$seq_hash)","parameters":[{"label":"$self"},{"label":"$assemblyobj"},{"label":"$seq_hash"}],"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none\n\n\nsub drop_assembly {\n  my ($self) = @_;\n  $self->{'_assembly'} = [];\n  return 1;\n}\n\n=head2 dissolve\n\n  Title   : dissolve\n  Usage   : $dissolved_csp->dissolve($mixed_csp, $seq_header);\n  Function: Dissolve a mixed contig spectrum for the set of sequences that\n            contain the specified header, i.e. determine the contribution of\n            these sequences to the mixed contig spectrum based on the assembly.\n            The mixed contig spectrum object must have been created based on one\n            (or several) assembly object(s). Additionally, min_overlap and\n            min_identity must have been set (either manually using min_overlap\n            or automatically by switching on the eff_asm_params option).\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n            sequence header string\n\n\n\nsub dissolve {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  $self->_import_dissolved_csp($mixed_csp, $seq_header);\n  return 1;\n}\n\n\n=head2 cross\n\n  Title   : cross\n  Usage   : $cross_csp->cross($mixed_csp);\n  Function: Calculate a cross contig_spectrum based on a mixed contig_spectrum.\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n\n\nsub cross {\n  my ($self, $mixed_csp) = @_;\n  $self->_import_cross_csp($mixed_csp);\n  return 1;\n}\n\n=head2 to_string\n\n  Title   : to_string\n  Usage   : my $csp_string = $csp->to_string;\n  Function: Convert the contig spectrum into a string (easy to print!!).\n  Returns : string\n  Args    : element separator (integer) [optional]\n              1 -> space-separated\n              2 -> tab-separated\n              3 -> newline-separated\n\n\nsub to_string {\n  my ($self, $element_separator) = @_;\n  return 0 if $self->{'_max_size'} == 0;\n  $element_separator ||= 1;\n  if ($element_separator == 1) {\n    $element_separator = ' ';\n  } elsif ($element_separator == 2) {\n    $element_separator = \"\\t\";\n  } elsif ($element_separator == 3) {\n    $element_separator = \"\\n\";\n  } else {\n    $self->throw(\"Unknown separator type '$element_separator'\\n\");\n  }\n  my $str = '';\n  for (my $q = 1 ; $q <= $self->{'_max_size'} ; $q++) {\n    my $val = 0;\n    if (exists $self->{'_spectrum'}{$q}) {\n      $val = $self->{'_spectrum'}{$q};\n    }\n    $str .= $val.$element_separator;\n  }\n  $str =~ s/\\s$//;\n  return $str;\n}\n\n\n=head2 add\n\n  Title   : add\n  Usage   : $csp->add($additional_csp);\n  Function: Add a contig spectrum to an existing one: sums the spectra, update\n            the number of sequences, number of repetitions, ...\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum object\n\n\nsub add {\n  my ($self, $csp) = @_;\n  # Sanity check\n  if( !ref $csp || ! $csp->isa('Bio::Assembly::Tools::ContigSpectrum') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n  }\n  # Update overlap statistics\n  if ( $self->{'_eff_asm_params'} > 0 ) {\n    # Warnings\n    if ( $csp->{'_eff_asm_params'} == 0 ) {\n      $self->warn(\"The parent contig spectrum needs effective assembly \".\n        \"parameters (eff_asm_params = \".$self->{'_eff_asm_params'}.\") but the \".\n        \"child contig spectrum doesn't have them (eff_asm_params = \".\n        $csp->{'_eff_asm_params'}.\"). Skipping them...\");\n    } elsif ( $csp->{'_eff_asm_params'} != $self->{'_eff_asm_params'} ) {\n      $self->warn(\"The parent contig spectrum needs a different method for \".\n        \"detecting the effective assembly parameters (eff_asm_params = \".\n        $self->{'_eff_asm_params'}.\") than the one specified for the child \".\n        \"contig spectrum (eff_asm_params = \".$csp->{'_eff_asm_params'}.\"). \".\n        \"Ignoring the differences...\");\n    }\n    # Update existing stats\n    my $tot_num_overlaps = $csp->{'_nof_overlaps'} + $self->{'_nof_overlaps'};\n    $self->{'_min_overlap'} = $csp->{'_min_overlap'} if\n      defined $csp->{'_min_overlap'} && ( ! defined $self->{'_min_overlap'} ||\n      $csp->{'_min_overlap'} < $self->{'_min_overlap'} );\n    $self->{'_min_identity'} = $csp->{'_min_identity'} if\n      defined $csp->{'_min_identity'} && ( ! defined $self->{'_min_identity'} ||\n      $csp->{'_min_identity'} < $self->{'_min_identity'} );\n    if ($tot_num_overlaps != 0) {\n      $self->{'_avg_overlap'} =\n        ($csp->{'_avg_overlap'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_overlap'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n      $self->{'_avg_identity'} =\n        ($csp->{'_avg_identity'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_identity'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n    }\n    $self->{'_nof_overlaps'} = $tot_num_overlaps;\n  }\n  # Update sequence statistics\n  my $tot_nof_seq = $csp->{'_nof_seq'} + $self->{'_nof_seq'};\n  if (not $tot_nof_seq == 0) {\n    $self->{'_avg_seq_len'} = ($csp->{'_avg_seq_len'} * $csp->{'_nof_seq'} +\n      $self->{'_avg_seq_len'} * $self->{'_nof_seq'}) / $tot_nof_seq;\n  }\n  # Update spectrum (and nof_seq, max_size, and increment nof_rep by 1)\n  $self->_import_spectrum($csp->{'_spectrum'});\n  # Update nof_rep\n  $self->{'_nof_rep'}--;\n  $self->{'_nof_rep'} += $csp->{'_nof_rep'};\n  # Update list of assembly objects used\n  push @{$self->{'_assembly'}}, @{$csp->{'_assembly'}}\n    if defined $csp->{'_assembly'};\n  return 1;\n}\n\n\n=head2 average\n\n  Title   : average\n  Usage   : my $avg_csp = $csp->average([$csp1, $csp2, $csp3]);\n  Function: Average one contig spectrum or the sum of several contig spectra by\n            the number of repetitions\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Tools::ContigSpectrum array reference\n            eff_asm_params\n\n\nsub average {\n  my ($self, $list) = @_;\n  # Sanity check\n  if ( ! ref $list || ! ref $list eq 'ARRAY') {\n    $self->throw(\"Average takes an array reference but got [\".ref($list).\"]\");\n  }\n  # New average contig spectrum object\n  my $avg = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg->{'_eff_asm_params'} = 1;\n  \n  # Cycle through contig spectra\n  my $tot_nof_rep = 0;\n  for my $csp (@$list) {\n    # Sanity check\n    if (not $csp->isa('Bio::Assembly::Tools::ContigSpectrum')) {\n      $csp->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n    }\n    # Import contig spectrum\n    $avg->add($csp);\n  }\n  \n  # Average sum of contig spectra by number of repetitions\n  for (my $q = 1 ; $q <= $avg->{'_max_size'} ; $q++) {\n    $avg->{'_spectrum'}{$q} /= $avg->{'_nof_rep'}\n      if (defined $avg->{'_spectrum'}{$q});\n  }\n  # Average number of sequences\n  $avg->{'_nof_seq'} /= $avg->{'_nof_rep'};\n  # Average number of overlaps\n  $avg->{'_nof_overlaps'} /= $avg->{'_nof_rep'};\n  \n  return $avg;\n}\n\n\n=head2 score\n\n  Title   : score\n  Usage   : my $score = $csp->score();\n  Function: Score a contig spectrum (or cross-contig spectrum) such that the\n             higher the number of contigs (or cross-contigs) and the larger their \n             size, the higher the score.\n             Let n   : total number of sequences\n                 c_q : number of contigs of size q\n                 q   : number of sequence in a contig\n             We define: score = n/(n-1) * (X - 1/n)\n                  where X = sum ( c_q * q^2 ) / n**2\n             The score ranges from 0 (singlets only) to 1 (a single large contig)\n             It is possible to specify a value for the number of sequences to\n              assume in the contig spectrum.\n  Returns : contig score\n  Args    : number of total sequences to assume [optional]\n\n\nsub score {\n  my ($self, $nof_seqs) = @_;\n  # Main\n  my $score = 0;\n  my $n = $self->nof_seq;\n  if ( $n > 0 ) {\n    # Contig spectrum info\n    my $q_max = $self->max_size;\n    my $spec  = $self->spectrum;\n    # Adjust number of 1-contigs\n    if ( $nof_seqs ) {\n      $spec->{'1'} += $nof_seqs - $n;\n      $n = $nof_seqs;\n    }\n    # Calculate X\n    for my $q ( 1 .. $q_max ) {\n      if ( $spec->{$q} ) {\n        my $c_q = $spec->{$q};\n        $score += $c_q * $q ** 2;\n      }\n    }\n    $score /= $n ** 2; \n  }\n  # Rescale X to obtain the score\n  $score = $n/($n-1) * ($score - 1/$n);\n  return $score;\n}\n\n\n=head2 _naive_assembler\n\n  Title   : _naive_assembler\n  Usage   : \n  Function: Determines the contig spectrum (hash representation) of a subset of\n            sequences from a mixed contig spectrum by \"reassembling\" the\n            specified sequences only based on their position in the contig. This\n            naive assembly only verifies that the minimum overlap length and\n            percentage identity are respected. There is no actual alignment done\n  Returns : contig spectrum hash reference\n  Args    : Bio::Assembly::Contig\n            sequence ID array reference\n            minimum overlap length (integer) [optional]\n            minimum percentage identity (integer) [optional]\n\n\nsub _naive_assembler {\n  my ($self, $contig, $seqlist, $min_overlap, $min_identity) = @_;\n  # Sanity checks\n  if ( ! ref $seqlist || ! ref($seqlist) eq 'ARRAY') {\n    $self->throw('Expecting an array reference. Got ['.ref($seqlist).\"] \\n\");\n  }\n  my $max = scalar @$seqlist;\n  $self->throw(\"Expecting at least 2 sequences as input for _naive_assembler\")\n    if ($max < 2);\n  # Assembly\n  my %spectrum = (1 => 0);\n  my %overlap_map;\n  my %has_overlap;\n  # Map what sequences overlap with what sequences\n  for (my $i = 0 ; $i < $max-1 ; $i++) {\n    # query sequence\n    my $qseqid = $$seqlist[$i];\n    my $qseq   = $contig->get_seq_by_name($qseqid);\n    my $is_singlet = 1;\n    for (my $j = $i+1 ; $j < $max ; $j++) {\n      # target sequence\n      my $tseqid = $$seqlist[$j];\n      my $tseq = $contig->get_seq_by_name($tseqid);\n      # try to align sequences\n      my ($aln, $overlap, $identity)\n        = $self->_overlap_alignment($contig, $qseq, $tseq, $min_overlap,\n        $min_identity);\n      # if there is no valid overlap, go to next sequence\n      next if ! defined $aln;\n      # the overlap is valid\n      $is_singlet = 0;\n      push @{$overlap_map{$qseqid}}, $tseqid;\n      $has_overlap{$tseqid} = 1;\n      $has_overlap{$qseqid} = 1;\n    }\n    # check if sequence is in previously seen overlap\n    if (exists $has_overlap{$qseqid}) {\n      $is_singlet = 0;\n    }\n    if ($is_singlet == 1) {\n      $spectrum{1}++;\n    }\n  }\n  # take care of last sequence\n  my $last_is_singlet = 1;\n  if (exists $has_overlap{$$seqlist[$max-1]}) {\n    $last_is_singlet = 0;\n  }\n  if ($last_is_singlet == 1) {\n    $spectrum{1}++;\n  }\n  # Parse overlap map\n  for my $seqid (@$seqlist) {\n    # list of sequences that should go in the contig\n    next if not exists $overlap_map{$seqid};\n    my @overlist = @{$overlap_map{$seqid}};\n    for (my $j = 0 ; $j < scalar(@overlist) ; $j++) {\n      my $otherseqid = $overlist[$j];\n      if (exists $overlap_map{$otherseqid}) {\n        push @overlist, @{$overlap_map{$otherseqid}};\n        delete $overlap_map{$otherseqid};\n      }\n    }\n    # remove duplicates from list\n    @overlist = sort @overlist;\n    for (my $j = 0 ; $j < scalar(@overlist)-1 ; $j++) {\n      if ( $overlist[$j] eq $overlist[$j+1] ) {\n        splice @overlist, $j, 1;\n        $j--;\n      }\n    }\n    # update spectrum with size of contig\n    my $qsize = scalar(@overlist) + 1;\n    if (defined $spectrum{$qsize}) {\n      $spectrum{$qsize}++;\n    } else {\n      $spectrum{$qsize} = 1;\n    }\n  }\n  return \\%spectrum;\n}\n\n\n=head2 _new_from_assembly\n\n  Title   : _new_from_assembly\n  Usage   : \n  Function: Creates a new contig spectrum object based solely on the result of \n            an assembly\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Scaffold\n\n\nsub _new_from_assembly {\n  # Create new contig spectrum object based purely on what we can get from the\n  # assembly object\n  my ($self, $assemblyobj) = @_;\n  my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n  # 1: Set id\n  $csp->{'_id'} = $assemblyobj->id;\n  # 2: Set overlap statistics: nof_overlaps, min_overlap, avg_overlap,\n  #  min_identity and avg_identity\n  $csp->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  if ($csp->{'_eff_asm_params'} > 0) {\n     my ($nover, $minl, $avgl, $minid, $avgid)\n       = $csp->_get_overlap_stats($assemblyobj);\n     $csp->{'_min_overlap'}  = $minl;\n     $csp->{'_min_identity'} = $minid;\n     $csp->{'_avg_overlap'}  = $avgl;\n     $csp->{'_avg_identity'} = $avgid;\n     $csp->{'_nof_overlaps'} = $nover;\n  }\n  # 3: Set sequence statistics: nof_seq and avg_seq_len\n  my ($nseq, $avgseql) = $self->_get_seq_stats($assemblyobj);\n  $csp->{'_avg_seq_len'} = $avgseql;\n  $csp->{'_nof_seq'}     = $nseq;\n  # 4: Set the spectrum: spectrum and max_size\n  for my $contigobj ($assemblyobj->all_contigs) {\n    my $size = $contigobj->num_sequences;\n    if (defined $csp->{'_spectrum'}{$size}) {\n      $csp->{'_spectrum'}{$size}++;\n    } else {\n      $csp->{'_spectrum'}{$size} = 1;\n    }\n    $csp->{'_max_size'} = $size if $size > $csp->{'_max_size'};\n  }\n  my $nof_singlets = $assemblyobj->get_nof_singlets();\n  if (defined $nof_singlets) {\n    $csp->{'_spectrum'}{1} += $nof_singlets;\n    $csp->{'_max_size'} = 1 if $nof_singlets >= 1 && $csp->{'_max_size'} < 1;\n  }\n  # 5: Set list of assembly objects used\n  push @{$csp->{'_assembly'}}, $assemblyobj;\n  # 6: Set number of repetitions\n  $csp->{'_nof_rep'} = 1;\n  return $csp;\n}\n\n\n\n=head2 _new_dissolved_csp\n\n  Title   : \n  Usage   : create a dissolved contig spectrum object\n  Function: \n  Returns : \n  Args    : \n\n\n\nsub _new_dissolved_csp {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  # Sanity checks on the mixed contig spectrum\n\n  # min_overlap and min_identity must be specified if there are some overlaps\n  # in the mixed contig\n  unless ($mixed_csp->{'_nof_overlaps'} == 0) {\n    unless ( defined $self->{'_min_overlap'} || \n      defined $mixed_csp->{'_min_overlap'} ) {\n      $self->throw(\"min_overlap must be defined in the dissolved contig spectrum\".\n        \" or mixed contig spectrum to dissolve a contig\");\n    }\n    unless ( defined $self->{'_min_identity'} ||\n      defined $mixed_csp->{'_min_identity'} ) {\n      $self->throw(\"min_identity must be defined in the dissolved contig spectrum\".\n        \" or mixed contig spectrum\");\n    }\n  }\n  \n  # there must be at least one assembly in mixed contig spectrum\n  if (!defined $mixed_csp->{'_assembly'} ||\n      scalar @{$mixed_csp->{'_assembly'}} < 1) {\n    $self->throw(\"The mixed contig spectrum must be based on at least one\n    assembly\");\n  }\n\n  # New dissolved contig spectrum object\n  my $dissolved = Bio::Assembly::Tools::ContigSpectrum->new();\n  \n  # take parent attributes if existent or mixed attributes otherwise\n  if ($self->{'_eff_asm_params'}) {\n    $dissolved->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  } else {\n    $dissolved->{'_eff_asm_params'} = $mixed_csp->{'_eff_asm_params'};\n  }\n  if ($self->{'_min_overlap'} && $self->{'_min_identity'}) {\n    ( $dissolved->{'_min_overlap'}, $dissolved->{'_min_identity'} ) = \n      ( $self->{'_min_overlap'}, $self->{'_min_identity'} );\n  } else {\n    ( $dissolved->{'_min_overlap'}, $dissolved->{'_min_identity'} ) = \n      ( $mixed_csp->{'_min_overlap'}, $mixed_csp->{'_min_identity'} );\n  }\n  \n  # Dissolve each assembly\n  for my $assembly (@{$mixed_csp->{'_assembly'}}) {\n    # Dissolve this assembly for the given sequences\n    my %asm_spectrum = (1 => 0);\n    my %good_seqs;\n    # For each contig\n    for my $contig ($assembly->all_contigs) {\n      # Get good sequences\n      my @contig_seqs;\n      for my $seq ($contig->each_seq) {\n        my $seq_id = $seq->id;\n        # get sequence origin\n        next unless $seq_id =~ m/^$seq_header\\|/;\n        # add it to hash\n        push @contig_seqs, $seq_id;\n        $good_seqs{$seq_id} = 1;\n      }\n      # Update spectrum\n      my $size = scalar @contig_seqs;\n      if ($size == 0) {\n        next;\n      } elsif ($size == 1) {\n        $asm_spectrum{1}++;\n      } elsif ($size > 1) {\n        # Reassemble good sequences\n        my $contig_spectrum = $dissolved->_naive_assembler(\n          $contig, \\@contig_seqs, $dissolved->{'_min_overlap'},\n          $dissolved->{'_min_identity'});\n        # update spectrum\n        for my $qsize (keys %$contig_spectrum) {\n          $asm_spectrum{$qsize} += $$contig_spectrum{$qsize};\n        }\n      } else {\n        $self->throw(\"The size is not valid... how could that happen?\");\n      }\n    }\n    # For each singlet\n    for my $singlet ($assembly->all_singlets) {\n      my $seq_id = $singlet->seqref->id;\n      # get sequence origin\n      next unless $seq_id =~ m/^$seq_header\\|/;\n      # add it to hash\n      $good_seqs{$seq_id} = 1;\n      # update spectrum\n      $asm_spectrum{1}++;\n    }\n    # Update spectrum\n    $dissolved->_import_spectrum(\\%asm_spectrum);\n    # Update nof_rep\n    $dissolved->{'_nof_rep'}--;\n    $dissolved->{'_nof_rep'} += $mixed_csp->{'_nof_rep'};\n\n    # Get sequence stats\n    my ($nseq, $avgseql) = $dissolved->_get_seq_stats($assembly, \\%good_seqs);\n    $dissolved->{'_avg_seq_len'} = $avgseql;\n    $dissolved->{'_nof_seq'}     = $nseq;\n  \n    # Get eff_asm_param for these sequences\n    if ($dissolved->{'_eff_asm_params'} > 0) {\n      my ($nover, $minl, $avgl, $minid, $avgid)\n        = $dissolved->_get_overlap_stats($assembly, \\%good_seqs);\n      $dissolved->{'_min_overlap'}  = $minl;\n      $dissolved->{'_min_identity'} = $minid;\n      $dissolved->{'_avg_overlap'}  = $avgl;\n      $dissolved->{'_avg_identity'} = $avgid;\n      $dissolved->{'_nof_overlaps'} = $nover;\n    }\n\n  }\n  return $dissolved;\n}\n\n\n=head2 _new_cross_csp\n\n  Title   : \n  Usage   : \n  Function: create a cross contig spectrum object\n  Returns : \n  Args    : \n\n\n\nsub _new_cross_csp {\n  my ($self, $mixed_csp) = @_;\n  # Sanity check on the mixed contig spectrum\n  # There must be at least one assembly\n  if (!defined $mixed_csp->{'_assembly'} ||\n      scalar @{$mixed_csp->{'_assembly'}} < 1) {\n    $self->throw(\"The mixed contig spectrum must be based on at least one \".\n    \"assembly.\");\n  }\n  \n  # New dissolved contig spectrum object\n  my $cross = Bio::Assembly::Tools::ContigSpectrum->new();\n  my %spectrum = (1 => 0);\n  \n  # Take parent or mixed attributes\n  if ($self->{'_eff_asm_params'}) {\n    $cross->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  } else {\n    $cross->{'_eff_asm_params'} = $mixed_csp->{'_eff_asm_params'};\n  }\n  if ($self->{'_min_overlap'} && $self->{'_min_identity'}) {\n    ( $cross->{'_min_overlap'}, $cross->{'_min_identity'} ) = \n      ( $self->{'_min_overlap'}, $self->{'_min_identity'} );\n  } else {\n    ( $cross->{'_min_overlap'}, $cross->{'_min_identity'} ) = \n      ( $mixed_csp->{'_min_overlap'}, $mixed_csp->{'_min_identity'} );\n  }\n  \n  # Get cross contig spectrum for each assembly\n  for my $assembly (@{$mixed_csp->{'_assembly'}}) {\n    # Go through contigs and skip the pure ones\n    my %good_seqs;\n    for my $contig ($assembly->all_contigs) {\n      # Get origins\n      my @seq_origins;\n      my @seq_ids;\n      for my $seq ($contig->each_seq) {\n        # current sequence origin\n        my $seq_id = $seq->id;\n        $seq_id =~ m/^(.+)\\|/;\n        my $seq_header = $1;\n        $self->warn(\"Sequence $seq_id does not seem to have a header. Skipping\".\n          \" it...\") if not defined $seq_header;\n        $seq_header ||= '';\n        push @seq_origins, $seq_header;\n        push @seq_ids, $seq_id;\n      }\n      my $qsize = scalar(@seq_ids);\n      my @origins = sort { $a cmp $b } @seq_origins;\n      my $size = scalar(@origins);\n      for (my $i = 1 ; $i < $size ; $i++) {\n        if ($origins[$i] eq $origins[$i-1]) {\n          splice @origins, $i, 1;\n          $i--;\n          $size--;\n        }\n      }\n      # Update cross-contig number in spectrum\n      if ($size > 1) { # cross-contig detected\n        # update good sequences\n        for my $seq_id (@seq_ids) {\n          $good_seqs{$seq_id} = 1;\n        }\n        # update number of cross q-contigs in spectrum\n        if (defined $spectrum{$qsize}) {\n          $spectrum{$qsize}++;\n        } else {\n          $spectrum{$qsize} = 1;\n        }\n      }\n      # Update number of cross 1-contigs\n      if ($size > 1) { # cross-contig detected\n        for my $origin (@origins) {\n          # sequences to use\n          my @ids;\n          for (my $i = 0 ; $i < $qsize ; $i++) {\n            my $seq_origin = $seq_origins[$i];\n            my $seq_id = $seq_ids[$i];\n            push @ids, $seq_id if $seq_origin eq $origin;\n          }\n          if (scalar @ids == 1) {\n            $spectrum{1}++;\n          } elsif (scalar @ids > 1) {\n            my $contig_spectrum = $cross->_naive_assembler(\n              $contig, \\@ids, $cross->{'_min_overlap'},\n              $cross->{'_min_identity'});\n            $spectrum{1} += $$contig_spectrum{1};\n          } else {\n            $self->throw(\"The size is <= 0. How could such a thing happen?\");\n          }\n        }\n      }\n    }\n    # Get sequence stats\n    my ($nseq, $avgseql) = $cross->_get_seq_stats($assembly, \\%good_seqs);\n    $cross->{'_avg_seq_len'} = $avgseql;\n    $cross->{'_nof_seq'}     = $nseq;\n    # Get eff_asm_param for these sequences\n    if ($cross->{'_eff_asm_params'} > 0) {\n      my ($nover, $minl, $avgl, $minid, $avgid)\n        = $cross->_get_overlap_stats($assembly, \\%good_seqs);\n      $cross->{'_min_overlap'}  = $minl;\n      $cross->{'_min_identity'} = $minid;\n      $cross->{'_avg_overlap'}  = $avgl;\n      $cross->{'_avg_identity'} = $avgid;\n      $cross->{'_nof_overlaps'} = $nover;\n    }\n  }\n  \n  $cross->_import_spectrum(\\%spectrum);\n  # Update nof_rep\n  $cross->{'_nof_rep'}--;\n  $cross->{'_nof_rep'} += $mixed_csp->{'_nof_rep'};\n  \n  return $cross;\n}\n\n=head2 _import_assembly\n\n  Title   : _import_assembly\n  Usage   : $csp->_import_assembly($assemblyobj);\n  Function: Update a contig spectrum object based on an assembly object\n  Returns : 1 for success, 0 for error\n  Args    : Bio::Assembly::Scaffold assembly object\n\n\nsub _import_assembly {\n  my ($self, $assemblyobj) = @_;\n  # Sanity check\n  if( !ref $assemblyobj || ! $assemblyobj->isa('Bio::Assembly::ScaffoldI') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::ScaffoldI assembly \".\n        \"object [\".ref($assemblyobj).\"]\");\n  }\n  # Create new object from assembly\n  my $csp = $self->_new_from_assembly($assemblyobj);\n  # Update current contig spectrum object with new one\n  $self->add($csp);\n  return 1;\n}\n\n\n=head2 _import_spectrum\n\n  Title   : _import_spectrum\n  Usage   : $csp->_import_spectrum({ 1 => 90 , 2 => 3 , 4 => 1 })\n  Function: update a contig spectrum object based on a contig spectrum\n            represented as a hash (key: contig size, value: number of contigs of\n            this size)\n  Returns : 1 for success, 0 for error\n  Args    : contig spectrum as a hash reference\n\n\nsub _import_spectrum {\n  my ($self, $spectrum) = @_;\n  # Sanity check\n  if( ! ref $spectrum || ! ref $spectrum eq 'HASH') {\n    $self->throw(\"Spectrum should be a hash reference, but it is [\".\n      ref($spectrum).\"]\");\n  }\n  \n  # Update the spectrum (+ nof_rep, max_size and nof_seq)\n  for my $size (keys %$spectrum) {\n    # Get the number of contigs of different size\n    if (defined $self->{'_spectrum'}{$size}) {\n      $self->{'_spectrum'}{$size} += $$spectrum{$size};\n    } else {\n      $self->{'_spectrum'}{$size} = $$spectrum{$size};\n    }\n    # Update nof_seq\n    $self->{'_nof_seq'} += $size * $$spectrum{$size};\n    # Update max_size\n    $self->{'_max_size'} = $size if $size > $self->{'_max_size'};\n  }\n  \n  # If the contig spectrum has only zero 1-contigs, max_size is zero\n  $self->{'_max_size'} = 0 if scalar keys %{$self->{'_spectrum'}} == 1 &&\n    defined $self->{'_spectrum'}{'1'} && $self->{'_spectrum'}{'1'} == 0;\n  \n  # Update nof_rep\n  $self->{'_nof_rep'}++;\n  return 1;\n}\n\n=head2 _import_dissolved_csp\n\n  Title   : _import_dissolved_csp\n  Usage   : $csp->_import_dissolved_csp($mixed_csp, $seq_header);\n  Function: Update a contig spectrum object by dissolving a mixed contig\n            spectrum based on the header of the sequences\n  Returns : 1 for success, 0 for error\n  Args    : Bio::Assembly::Tools::ContigSpectrum\n            sequence header string\n\n\nsub _import_dissolved_csp {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  # Sanity check\n  if (not defined $mixed_csp || not defined $seq_header) {\n    $self->throw(\"Expecting a contig spectrum reference and sequence header as\".\n    \" arguments\");\n  }\n  # Create new object from assembly\n  my $dissolved_csp = $self->_new_dissolved_csp($mixed_csp, $seq_header);\n  # Update current contig spectrum object with new one\n  $self->add($dissolved_csp);\n  return 1;\n}\n\n\n=head2 _import_cross_csp\n\n  Title   : _import_cross_csp\n  Usage   : $csp->_import_cross_csp($mixed_csp);\n  Function: Update a contig spectrum object by calculating the cross contig\n            spectrum based on a mixed contig spectrum\n  Returns : 1 for success, 0 for error\n  Args    : Bio::Assembly::Tools::ContigSpectrum\n\n\nsub _import_cross_csp {\n  my ($self, $mixed_csp) = @_;\n  # Sanity check\n  if (not defined $mixed_csp) {\n    $self->throw(\"Expecting a contig spectrum reference as argument\");\n  }\n\n  # Create new object from assembly\n  my $cross_csp = $self->_new_cross_csp($mixed_csp);\n\n  # Update current contig spectrum object with new one\n  $self->add($cross_csp);\n\n  return 1;\n}\n\n\n=head2 _get_seq_stats\n\n  Title   : _get_seq_stats\n  Usage   : my $seqlength = $csp->_get_seq_stats($assemblyobj);\n  Function: Get sequence statistics from an assembly:\n              number of sequences, average sequence length\n  Returns : number of sequences (integer)\n            average sequence length (decimal)\n  Args    : assembly object reference\n            hash reference with the IDs of the sequences to consider [optional]"},"detail":"($self,$assemblyobj,$seq_hash)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":1385},"end":{"line":1416,"character":9999}},"name":"_get_seq_stats"},{"name":"seq_hash","line":1399,"kind":12},{"line":1408,"kind":12,"name":"seq_hash"},{"name":"_get_overlap_stats","range":{"start":{"character":0,"line":1435},"end":{"character":9999,"line":1517}},"kind":12,"children":[{"line":1436,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_get_overlap_stats"},{"line":1436,"kind":13,"name":"$assembly_obj","containerName":"_get_overlap_stats"},{"line":1436,"kind":13,"containerName":"_get_overlap_stats","name":"$seq_hash"},{"kind":13,"line":1439,"name":"$self","containerName":"_get_overlap_stats"},{"kind":12,"line":1439,"name":"throw","containerName":"_get_overlap_stats"},{"name":"$assembly_obj","containerName":"_get_overlap_stats","kind":13,"line":1440},{"line":1440,"kind":13,"containerName":"_get_overlap_stats","name":"$assembly_obj"},{"kind":12,"line":1440,"containerName":"_get_overlap_stats","name":"isa"},{"containerName":"_get_overlap_stats","name":"$self","kind":13,"line":1441},{"containerName":"_get_overlap_stats","name":"throw","line":1441,"kind":12},{"kind":13,"line":1441,"name":"$seq_hash","containerName":"_get_overlap_stats"},{"line":1442,"kind":13,"containerName":"_get_overlap_stats","name":"$seq_hash"},{"line":1442,"kind":13,"name":"$seq_hash","containerName":"_get_overlap_stats"},{"kind":13,"line":1444,"definition":"my","name":"$matchdef","containerName":"_get_overlap_stats","localvar":"my"},{"containerName":"_get_overlap_stats","name":"$self","line":1444,"kind":13},{"containerName":"_get_overlap_stats","definition":"my","name":"$min_length","localvar":"my","kind":13,"line":1445},{"containerName":"_get_overlap_stats","name":"$avg_length","kind":13,"line":1445},{"kind":13,"line":1445,"containerName":"_get_overlap_stats","name":"$min_identity"},{"containerName":"_get_overlap_stats","name":"$avg_identity","line":1445,"kind":13},{"containerName":"_get_overlap_stats","name":"$nof_overlaps","kind":13,"line":1445},{"containerName":"_get_overlap_stats","definition":"my","name":"$contig_obj","localvar":"my","kind":13,"line":1449},{"line":1449,"kind":13,"containerName":"_get_overlap_stats","name":"$assembly_obj"},{"containerName":"_get_overlap_stats","name":"all_contigs","kind":12,"line":1449},{"localvar":"my","containerName":"_get_overlap_stats","definition":"my","name":"$nof_seq","line":1450,"kind":13},{"name":"@all_seq_objs","definition":"my","containerName":"_get_overlap_stats","localvar":"my","kind":13,"line":1453},{"containerName":"_get_overlap_stats","name":"$contig_obj","line":1453,"kind":13},{"name":"each_seq","containerName":"_get_overlap_stats","line":1453,"kind":12},{"line":1455,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":"_get_overlap_stats"},{"line":1455,"kind":13,"containerName":"_get_overlap_stats","name":"$i"},{"containerName":"_get_overlap_stats","name":"@all_seq_objs","line":1455,"kind":13},{"line":1455,"kind":13,"containerName":"_get_overlap_stats","name":"$i"},{"localvar":"my","name":"$seq_obj","definition":"my","containerName":"_get_overlap_stats","line":1456,"kind":13},{"kind":13,"line":1456,"name":"$all_seq_objs","containerName":"_get_overlap_stats"},{"line":1456,"kind":13,"name":"$i","containerName":"_get_overlap_stats"},{"localvar":"my","containerName":"_get_overlap_stats","definition":"my","name":"$seq_id","line":1457,"kind":13},{"name":"$seq_obj","containerName":"_get_overlap_stats","line":1457,"kind":13},{"name":"id","containerName":"_get_overlap_stats","kind":12,"line":1457},{"name":"$seq_hash","containerName":"_get_overlap_stats","line":1460,"kind":13},{"kind":13,"line":1460,"containerName":"_get_overlap_stats","name":"$seq_id"},{"containerName":"_get_overlap_stats","name":"$nof_seq","kind":13,"line":1461},{"name":"$nof_seq","containerName":"_get_overlap_stats","kind":13,"line":1464},{"localvar":"my","name":"$stats","definition":"my","containerName":"_get_overlap_stats","line":1467,"kind":13},{"kind":12,"line":1467,"containerName":"_get_overlap_stats","name":"new"},{"line":1468,"kind":13,"localvar":"my","definition":"my","name":"$target_obj","containerName":"_get_overlap_stats"},{"line":1469,"kind":13,"localvar":"my","name":"$target_id","definition":"my","containerName":"_get_overlap_stats"},{"definition":"my","name":"$best_score","containerName":"_get_overlap_stats","localvar":"my","kind":13,"line":1470},{"localvar":"my","definition":"my","name":"$best_length","containerName":"_get_overlap_stats","line":1471,"kind":13},{"containerName":"_get_overlap_stats","name":"$best_identity","definition":"my","localvar":"my","kind":13,"line":1472},{"kind":13,"line":1474,"definition":"my","name":"$j","containerName":"_get_overlap_stats","localvar":"my"},{"name":"$i","containerName":"_get_overlap_stats","line":1474,"kind":13},{"line":1474,"kind":13,"containerName":"_get_overlap_stats","name":"$j"},{"containerName":"_get_overlap_stats","name":"$j","line":1474,"kind":13},{"kind":13,"line":1475,"containerName":"_get_overlap_stats","definition":"my","name":"$tmp_target_obj","localvar":"my"},{"name":"$all_seq_objs","containerName":"_get_overlap_stats","line":1475,"kind":13},{"name":"$j","containerName":"_get_overlap_stats","kind":13,"line":1475},{"localvar":"my","definition":"my","name":"$tmp_target_id","containerName":"_get_overlap_stats","line":1476,"kind":13},{"name":"$tmp_target_obj","containerName":"_get_overlap_stats","kind":13,"line":1476},{"line":1476,"kind":12,"name":"id","containerName":"_get_overlap_stats"},{"kind":13,"line":1479,"containerName":"_get_overlap_stats","name":"$seq_hash"},{"containerName":"_get_overlap_stats","name":"$tmp_target_id","line":1479,"kind":13},{"line":1482,"kind":13,"localvar":"my","containerName":"_get_overlap_stats","definition":"my","name":"$aln_obj"},{"containerName":"_get_overlap_stats","name":"$tmp_length","kind":13,"line":1482},{"containerName":"_get_overlap_stats","name":"$tmp_identity","line":1482,"kind":13},{"name":"$self","containerName":"_get_overlap_stats","kind":13,"line":1483},{"containerName":"_get_overlap_stats","name":"_overlap_alignment","kind":12,"line":1483},{"kind":13,"line":1483,"name":"$contig_obj","containerName":"_get_overlap_stats"},{"line":1483,"kind":13,"name":"$seq_obj","containerName":"_get_overlap_stats"},{"containerName":"_get_overlap_stats","name":"$tmp_target_obj","line":1483,"kind":13},{"containerName":"_get_overlap_stats","name":"$aln_obj","kind":13,"line":1484},{"localvar":"my","name":"$tmp_score","definition":"my","containerName":"_get_overlap_stats","line":1485,"kind":13},{"containerName":"_get_overlap_stats","name":"$stats","kind":13,"line":1485},{"line":1485,"kind":12,"name":"score_nuc","containerName":"_get_overlap_stats"},{"line":1485,"kind":13,"name":"$aln_obj","containerName":"_get_overlap_stats"},{"containerName":"_get_overlap_stats","name":"$best_score","kind":13,"line":1488},{"kind":13,"line":1488,"containerName":"_get_overlap_stats","name":"$best_score"},{"name":"$tmp_score","containerName":"_get_overlap_stats","line":1488,"kind":13},{"line":1489,"kind":13,"containerName":"_get_overlap_stats","name":"$best_score"},{"line":1489,"kind":13,"name":"$tmp_score","containerName":"_get_overlap_stats"},{"containerName":"_get_overlap_stats","name":"$best_length","kind":13,"line":1490},{"name":"$tmp_length","containerName":"_get_overlap_stats","kind":13,"line":1490},{"name":"$best_identity","containerName":"_get_overlap_stats","kind":13,"line":1491},{"line":1491,"kind":13,"containerName":"_get_overlap_stats","name":"$tmp_identity"},{"name":"$target_obj","containerName":"_get_overlap_stats","line":1492,"kind":13},{"name":"$tmp_target_obj","containerName":"_get_overlap_stats","line":1492,"kind":13},{"line":1493,"kind":13,"containerName":"_get_overlap_stats","name":"$target_id"},{"kind":13,"line":1493,"name":"$tmp_target_id","containerName":"_get_overlap_stats"},{"line":1498,"kind":13,"name":"$best_score","containerName":"_get_overlap_stats"},{"containerName":"_get_overlap_stats","name":"$avg_length","kind":13,"line":1499},{"containerName":"_get_overlap_stats","name":"$best_length","kind":13,"line":1499},{"name":"$avg_identity","containerName":"_get_overlap_stats","line":1500,"kind":13},{"kind":13,"line":1500,"containerName":"_get_overlap_stats","name":"$best_identity"},{"kind":13,"line":1501,"containerName":"_get_overlap_stats","name":"$min_length"},{"kind":13,"line":1501,"name":"$best_length","containerName":"_get_overlap_stats"},{"kind":13,"line":1501,"name":"$min_length","containerName":"_get_overlap_stats"},{"kind":13,"line":1502,"containerName":"_get_overlap_stats","name":"$best_length"},{"containerName":"_get_overlap_stats","name":"$min_length","line":1502,"kind":13},{"name":"$min_identity","containerName":"_get_overlap_stats","kind":13,"line":1503},{"line":1503,"kind":13,"containerName":"_get_overlap_stats","name":"$best_identity"},{"name":"$min_identity","containerName":"_get_overlap_stats","kind":13,"line":1503},{"kind":13,"line":1504,"name":"$best_identity","containerName":"_get_overlap_stats"},{"containerName":"_get_overlap_stats","name":"$min_identity","line":1504,"kind":13},{"name":"$nof_overlaps","containerName":"_get_overlap_stats","kind":13,"line":1505},{"kind":13,"line":1511,"containerName":"_get_overlap_stats","name":"$nof_overlaps"},{"name":"$avg_length","containerName":"_get_overlap_stats","kind":13,"line":1512},{"kind":13,"line":1512,"containerName":"_get_overlap_stats","name":"$nof_overlaps"},{"name":"$avg_identity","containerName":"_get_overlap_stats","line":1513,"kind":13},{"name":"$nof_overlaps","containerName":"_get_overlap_stats","line":1513,"kind":13},{"name":"$nof_overlaps","containerName":"_get_overlap_stats","line":1516,"kind":13},{"name":"$min_length","containerName":"_get_overlap_stats","kind":13,"line":1516},{"line":1516,"kind":13,"containerName":"_get_overlap_stats","name":"$avg_length"},{"name":"$min_identity","containerName":"_get_overlap_stats","kind":13,"line":1516},{"kind":13,"line":1516,"name":"$avg_identity","containerName":"_get_overlap_stats"}],"line":1435,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$assembly_obj"},{"label":"$seq_hash"}],"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none\n\n\nsub drop_assembly {\n  my ($self) = @_;\n  $self->{'_assembly'} = [];\n  return 1;\n}\n\n=head2 dissolve\n\n  Title   : dissolve\n  Usage   : $dissolved_csp->dissolve($mixed_csp, $seq_header);\n  Function: Dissolve a mixed contig spectrum for the set of sequences that\n            contain the specified header, i.e. determine the contribution of\n            these sequences to the mixed contig spectrum based on the assembly.\n            The mixed contig spectrum object must have been created based on one\n            (or several) assembly object(s). Additionally, min_overlap and\n            min_identity must have been set (either manually using min_overlap\n            or automatically by switching on the eff_asm_params option).\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n            sequence header string\n\n\n\nsub dissolve {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  $self->_import_dissolved_csp($mixed_csp, $seq_header);\n  return 1;\n}\n\n\n=head2 cross\n\n  Title   : cross\n  Usage   : $cross_csp->cross($mixed_csp);\n  Function: Calculate a cross contig_spectrum based on a mixed contig_spectrum.\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n\n\nsub cross {\n  my ($self, $mixed_csp) = @_;\n  $self->_import_cross_csp($mixed_csp);\n  return 1;\n}\n\n=head2 to_string\n\n  Title   : to_string\n  Usage   : my $csp_string = $csp->to_string;\n  Function: Convert the contig spectrum into a string (easy to print!!).\n  Returns : string\n  Args    : element separator (integer) [optional]\n              1 -> space-separated\n              2 -> tab-separated\n              3 -> newline-separated\n\n\nsub to_string {\n  my ($self, $element_separator) = @_;\n  return 0 if $self->{'_max_size'} == 0;\n  $element_separator ||= 1;\n  if ($element_separator == 1) {\n    $element_separator = ' ';\n  } elsif ($element_separator == 2) {\n    $element_separator = \"\\t\";\n  } elsif ($element_separator == 3) {\n    $element_separator = \"\\n\";\n  } else {\n    $self->throw(\"Unknown separator type '$element_separator'\\n\");\n  }\n  my $str = '';\n  for (my $q = 1 ; $q <= $self->{'_max_size'} ; $q++) {\n    my $val = 0;\n    if (exists $self->{'_spectrum'}{$q}) {\n      $val = $self->{'_spectrum'}{$q};\n    }\n    $str .= $val.$element_separator;\n  }\n  $str =~ s/\\s$//;\n  return $str;\n}\n\n\n=head2 add\n\n  Title   : add\n  Usage   : $csp->add($additional_csp);\n  Function: Add a contig spectrum to an existing one: sums the spectra, update\n            the number of sequences, number of repetitions, ...\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum object\n\n\nsub add {\n  my ($self, $csp) = @_;\n  # Sanity check\n  if( !ref $csp || ! $csp->isa('Bio::Assembly::Tools::ContigSpectrum') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n  }\n  # Update overlap statistics\n  if ( $self->{'_eff_asm_params'} > 0 ) {\n    # Warnings\n    if ( $csp->{'_eff_asm_params'} == 0 ) {\n      $self->warn(\"The parent contig spectrum needs effective assembly \".\n        \"parameters (eff_asm_params = \".$self->{'_eff_asm_params'}.\") but the \".\n        \"child contig spectrum doesn't have them (eff_asm_params = \".\n        $csp->{'_eff_asm_params'}.\"). Skipping them...\");\n    } elsif ( $csp->{'_eff_asm_params'} != $self->{'_eff_asm_params'} ) {\n      $self->warn(\"The parent contig spectrum needs a different method for \".\n        \"detecting the effective assembly parameters (eff_asm_params = \".\n        $self->{'_eff_asm_params'}.\") than the one specified for the child \".\n        \"contig spectrum (eff_asm_params = \".$csp->{'_eff_asm_params'}.\"). \".\n        \"Ignoring the differences...\");\n    }\n    # Update existing stats\n    my $tot_num_overlaps = $csp->{'_nof_overlaps'} + $self->{'_nof_overlaps'};\n    $self->{'_min_overlap'} = $csp->{'_min_overlap'} if\n      defined $csp->{'_min_overlap'} && ( ! defined $self->{'_min_overlap'} ||\n      $csp->{'_min_overlap'} < $self->{'_min_overlap'} );\n    $self->{'_min_identity'} = $csp->{'_min_identity'} if\n      defined $csp->{'_min_identity'} && ( ! defined $self->{'_min_identity'} ||\n      $csp->{'_min_identity'} < $self->{'_min_identity'} );\n    if ($tot_num_overlaps != 0) {\n      $self->{'_avg_overlap'} =\n        ($csp->{'_avg_overlap'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_overlap'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n      $self->{'_avg_identity'} =\n        ($csp->{'_avg_identity'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_identity'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n    }\n    $self->{'_nof_overlaps'} = $tot_num_overlaps;\n  }\n  # Update sequence statistics\n  my $tot_nof_seq = $csp->{'_nof_seq'} + $self->{'_nof_seq'};\n  if (not $tot_nof_seq == 0) {\n    $self->{'_avg_seq_len'} = ($csp->{'_avg_seq_len'} * $csp->{'_nof_seq'} +\n      $self->{'_avg_seq_len'} * $self->{'_nof_seq'}) / $tot_nof_seq;\n  }\n  # Update spectrum (and nof_seq, max_size, and increment nof_rep by 1)\n  $self->_import_spectrum($csp->{'_spectrum'});\n  # Update nof_rep\n  $self->{'_nof_rep'}--;\n  $self->{'_nof_rep'} += $csp->{'_nof_rep'};\n  # Update list of assembly objects used\n  push @{$self->{'_assembly'}}, @{$csp->{'_assembly'}}\n    if defined $csp->{'_assembly'};\n  return 1;\n}\n\n\n=head2 average\n\n  Title   : average\n  Usage   : my $avg_csp = $csp->average([$csp1, $csp2, $csp3]);\n  Function: Average one contig spectrum or the sum of several contig spectra by\n            the number of repetitions\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Tools::ContigSpectrum array reference\n            eff_asm_params\n\n\nsub average {\n  my ($self, $list) = @_;\n  # Sanity check\n  if ( ! ref $list || ! ref $list eq 'ARRAY') {\n    $self->throw(\"Average takes an array reference but got [\".ref($list).\"]\");\n  }\n  # New average contig spectrum object\n  my $avg = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg->{'_eff_asm_params'} = 1;\n  \n  # Cycle through contig spectra\n  my $tot_nof_rep = 0;\n  for my $csp (@$list) {\n    # Sanity check\n    if (not $csp->isa('Bio::Assembly::Tools::ContigSpectrum')) {\n      $csp->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n    }\n    # Import contig spectrum\n    $avg->add($csp);\n  }\n  \n  # Average sum of contig spectra by number of repetitions\n  for (my $q = 1 ; $q <= $avg->{'_max_size'} ; $q++) {\n    $avg->{'_spectrum'}{$q} /= $avg->{'_nof_rep'}\n      if (defined $avg->{'_spectrum'}{$q});\n  }\n  # Average number of sequences\n  $avg->{'_nof_seq'} /= $avg->{'_nof_rep'};\n  # Average number of overlaps\n  $avg->{'_nof_overlaps'} /= $avg->{'_nof_rep'};\n  \n  return $avg;\n}\n\n\n=head2 score\n\n  Title   : score\n  Usage   : my $score = $csp->score();\n  Function: Score a contig spectrum (or cross-contig spectrum) such that the\n             higher the number of contigs (or cross-contigs) and the larger their \n             size, the higher the score.\n             Let n   : total number of sequences\n                 c_q : number of contigs of size q\n                 q   : number of sequence in a contig\n             We define: score = n/(n-1) * (X - 1/n)\n                  where X = sum ( c_q * q^2 ) / n**2\n             The score ranges from 0 (singlets only) to 1 (a single large contig)\n             It is possible to specify a value for the number of sequences to\n              assume in the contig spectrum.\n  Returns : contig score\n  Args    : number of total sequences to assume [optional]\n\n\nsub score {\n  my ($self, $nof_seqs) = @_;\n  # Main\n  my $score = 0;\n  my $n = $self->nof_seq;\n  if ( $n > 0 ) {\n    # Contig spectrum info\n    my $q_max = $self->max_size;\n    my $spec  = $self->spectrum;\n    # Adjust number of 1-contigs\n    if ( $nof_seqs ) {\n      $spec->{'1'} += $nof_seqs - $n;\n      $n = $nof_seqs;\n    }\n    # Calculate X\n    for my $q ( 1 .. $q_max ) {\n      if ( $spec->{$q} ) {\n        my $c_q = $spec->{$q};\n        $score += $c_q * $q ** 2;\n      }\n    }\n    $score /= $n ** 2; \n  }\n  # Rescale X to obtain the score\n  $score = $n/($n-1) * ($score - 1/$n);\n  return $score;\n}\n\n\n=head2 _naive_assembler\n\n  Title   : _naive_assembler\n  Usage   : \n  Function: Determines the contig spectrum (hash representation) of a subset of\n            sequences from a mixed contig spectrum by \"reassembling\" the\n            specified sequences only based on their position in the contig. This\n            naive assembly only verifies that the minimum overlap length and\n            percentage identity are respected. There is no actual alignment done\n  Returns : contig spectrum hash reference\n  Args    : Bio::Assembly::Contig\n            sequence ID array reference\n            minimum overlap length (integer) [optional]\n            minimum percentage identity (integer) [optional]\n\n\nsub _naive_assembler {\n  my ($self, $contig, $seqlist, $min_overlap, $min_identity) = @_;\n  # Sanity checks\n  if ( ! ref $seqlist || ! ref($seqlist) eq 'ARRAY') {\n    $self->throw('Expecting an array reference. Got ['.ref($seqlist).\"] \\n\");\n  }\n  my $max = scalar @$seqlist;\n  $self->throw(\"Expecting at least 2 sequences as input for _naive_assembler\")\n    if ($max < 2);\n  # Assembly\n  my %spectrum = (1 => 0);\n  my %overlap_map;\n  my %has_overlap;\n  # Map what sequences overlap with what sequences\n  for (my $i = 0 ; $i < $max-1 ; $i++) {\n    # query sequence\n    my $qseqid = $$seqlist[$i];\n    my $qseq   = $contig->get_seq_by_name($qseqid);\n    my $is_singlet = 1;\n    for (my $j = $i+1 ; $j < $max ; $j++) {\n      # target sequence\n      my $tseqid = $$seqlist[$j];\n      my $tseq = $contig->get_seq_by_name($tseqid);\n      # try to align sequences\n      my ($aln, $overlap, $identity)\n        = $self->_overlap_alignment($contig, $qseq, $tseq, $min_overlap,\n        $min_identity);\n      # if there is no valid overlap, go to next sequence\n      next if ! defined $aln;\n      # the overlap is valid\n      $is_singlet = 0;\n      push @{$overlap_map{$qseqid}}, $tseqid;\n      $has_overlap{$tseqid} = 1;\n      $has_overlap{$qseqid} = 1;\n    }\n    # check if sequence is in previously seen overlap\n    if (exists $has_overlap{$qseqid}) {\n      $is_singlet = 0;\n    }\n    if ($is_singlet == 1) {\n      $spectrum{1}++;\n    }\n  }\n  # take care of last sequence\n  my $last_is_singlet = 1;\n  if (exists $has_overlap{$$seqlist[$max-1]}) {\n    $last_is_singlet = 0;\n  }\n  if ($last_is_singlet == 1) {\n    $spectrum{1}++;\n  }\n  # Parse overlap map\n  for my $seqid (@$seqlist) {\n    # list of sequences that should go in the contig\n    next if not exists $overlap_map{$seqid};\n    my @overlist = @{$overlap_map{$seqid}};\n    for (my $j = 0 ; $j < scalar(@overlist) ; $j++) {\n      my $otherseqid = $overlist[$j];\n      if (exists $overlap_map{$otherseqid}) {\n        push @overlist, @{$overlap_map{$otherseqid}};\n        delete $overlap_map{$otherseqid};\n      }\n    }\n    # remove duplicates from list\n    @overlist = sort @overlist;\n    for (my $j = 0 ; $j < scalar(@overlist)-1 ; $j++) {\n      if ( $overlist[$j] eq $overlist[$j+1] ) {\n        splice @overlist, $j, 1;\n        $j--;\n      }\n    }\n    # update spectrum with size of contig\n    my $qsize = scalar(@overlist) + 1;\n    if (defined $spectrum{$qsize}) {\n      $spectrum{$qsize}++;\n    } else {\n      $spectrum{$qsize} = 1;\n    }\n  }\n  return \\%spectrum;\n}\n\n\n=head2 _new_from_assembly\n\n  Title   : _new_from_assembly\n  Usage   : \n  Function: Creates a new contig spectrum object based solely on the result of \n            an assembly\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Scaffold\n\n\nsub _new_from_assembly {\n  # Create new contig spectrum object based purely on what we can get from the\n  # assembly object\n  my ($self, $assemblyobj) = @_;\n  my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n  # 1: Set id\n  $csp->{'_id'} = $assemblyobj->id;\n  # 2: Set overlap statistics: nof_overlaps, min_overlap, avg_overlap,\n  #  min_identity and avg_identity\n  $csp->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  if ($csp->{'_eff_asm_params'} > 0) {\n     my ($nover, $minl, $avgl, $minid, $avgid)\n       = $csp->_get_overlap_stats($assemblyobj);\n     $csp->{'_min_overlap'}  = $minl;\n     $csp->{'_min_identity'} = $minid;\n     $csp->{'_avg_overlap'}  = $avgl;\n     $csp->{'_avg_identity'} = $avgid;\n     $csp->{'_nof_overlaps'} = $nover;\n  }\n  # 3: Set sequence statistics: nof_seq and avg_seq_len\n  my ($nseq, $avgseql) = $self->_get_seq_stats($assemblyobj);\n  $csp->{'_avg_seq_len'} = $avgseql;\n  $csp->{'_nof_seq'}     = $nseq;\n  # 4: Set the spectrum: spectrum and max_size\n  for my $contigobj ($assemblyobj->all_contigs) {\n    my $size = $contigobj->num_sequences;\n    if (defined $csp->{'_spectrum'}{$size}) {\n      $csp->{'_spectrum'}{$size}++;\n    } else {\n      $csp->{'_spectrum'}{$size} = 1;\n    }\n    $csp->{'_max_size'} = $size if $size > $csp->{'_max_size'};\n  }\n  my $nof_singlets = $assemblyobj->get_nof_singlets();\n  if (defined $nof_singlets) {\n    $csp->{'_spectrum'}{1} += $nof_singlets;\n    $csp->{'_max_size'} = 1 if $nof_singlets >= 1 && $csp->{'_max_size'} < 1;\n  }\n  # 5: Set list of assembly objects used\n  push @{$csp->{'_assembly'}}, $assemblyobj;\n  # 6: Set number of repetitions\n  $csp->{'_nof_rep'} = 1;\n  return $csp;\n}\n\n\n\n=head2 _new_dissolved_csp\n\n  Title   : \n  Usage   : create a dissolved contig spectrum object\n  Function: \n  Returns : \n  Args    : \n\n\n\nsub _new_dissolved_csp {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  # Sanity checks on the mixed contig spectrum\n\n  # min_overlap and min_identity must be specified if there are some overlaps\n  # in the mixed contig\n  unless ($mixed_csp->{'_nof_overlaps'} == 0) {\n    unless ( defined $self->{'_min_overlap'} || \n      defined $mixed_csp->{'_min_overlap'} ) {\n      $self->throw(\"min_overlap must be defined in the dissolved contig spectrum\".\n        \" or mixed contig spectrum to dissolve a contig\");\n    }\n    unless ( defined $self->{'_min_identity'} ||\n      defined $mixed_csp->{'_min_identity'} ) {\n      $self->throw(\"min_identity must be defined in the dissolved contig spectrum\".\n        \" or mixed contig spectrum\");\n    }\n  }\n  \n  # there must be at least one assembly in mixed contig spectrum\n  if (!defined $mixed_csp->{'_assembly'} ||\n      scalar @{$mixed_csp->{'_assembly'}} < 1) {\n    $self->throw(\"The mixed contig spectrum must be based on at least one\n    assembly\");\n  }\n\n  # New dissolved contig spectrum object\n  my $dissolved = Bio::Assembly::Tools::ContigSpectrum->new();\n  \n  # take parent attributes if existent or mixed attributes otherwise\n  if ($self->{'_eff_asm_params'}) {\n    $dissolved->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  } else {\n    $dissolved->{'_eff_asm_params'} = $mixed_csp->{'_eff_asm_params'};\n  }\n  if ($self->{'_min_overlap'} && $self->{'_min_identity'}) {\n    ( $dissolved->{'_min_overlap'}, $dissolved->{'_min_identity'} ) = \n      ( $self->{'_min_overlap'}, $self->{'_min_identity'} );\n  } else {\n    ( $dissolved->{'_min_overlap'}, $dissolved->{'_min_identity'} ) = \n      ( $mixed_csp->{'_min_overlap'}, $mixed_csp->{'_min_identity'} );\n  }\n  \n  # Dissolve each assembly\n  for my $assembly (@{$mixed_csp->{'_assembly'}}) {\n    # Dissolve this assembly for the given sequences\n    my %asm_spectrum = (1 => 0);\n    my %good_seqs;\n    # For each contig\n    for my $contig ($assembly->all_contigs) {\n      # Get good sequences\n      my @contig_seqs;\n      for my $seq ($contig->each_seq) {\n        my $seq_id = $seq->id;\n        # get sequence origin\n        next unless $seq_id =~ m/^$seq_header\\|/;\n        # add it to hash\n        push @contig_seqs, $seq_id;\n        $good_seqs{$seq_id} = 1;\n      }\n      # Update spectrum\n      my $size = scalar @contig_seqs;\n      if ($size == 0) {\n        next;\n      } elsif ($size == 1) {\n        $asm_spectrum{1}++;\n      } elsif ($size > 1) {\n        # Reassemble good sequences\n        my $contig_spectrum = $dissolved->_naive_assembler(\n          $contig, \\@contig_seqs, $dissolved->{'_min_overlap'},\n          $dissolved->{'_min_identity'});\n        # update spectrum\n        for my $qsize (keys %$contig_spectrum) {\n          $asm_spectrum{$qsize} += $$contig_spectrum{$qsize};\n        }\n      } else {\n        $self->throw(\"The size is not valid... how could that happen?\");\n      }\n    }\n    # For each singlet\n    for my $singlet ($assembly->all_singlets) {\n      my $seq_id = $singlet->seqref->id;\n      # get sequence origin\n      next unless $seq_id =~ m/^$seq_header\\|/;\n      # add it to hash\n      $good_seqs{$seq_id} = 1;\n      # update spectrum\n      $asm_spectrum{1}++;\n    }\n    # Update spectrum\n    $dissolved->_import_spectrum(\\%asm_spectrum);\n    # Update nof_rep\n    $dissolved->{'_nof_rep'}--;\n    $dissolved->{'_nof_rep'} += $mixed_csp->{'_nof_rep'};\n\n    # Get sequence stats\n    my ($nseq, $avgseql) = $dissolved->_get_seq_stats($assembly, \\%good_seqs);\n    $dissolved->{'_avg_seq_len'} = $avgseql;\n    $dissolved->{'_nof_seq'}     = $nseq;\n  \n    # Get eff_asm_param for these sequences\n    if ($dissolved->{'_eff_asm_params'} > 0) {\n      my ($nover, $minl, $avgl, $minid, $avgid)\n        = $dissolved->_get_overlap_stats($assembly, \\%good_seqs);\n      $dissolved->{'_min_overlap'}  = $minl;\n      $dissolved->{'_min_identity'} = $minid;\n      $dissolved->{'_avg_overlap'}  = $avgl;\n      $dissolved->{'_avg_identity'} = $avgid;\n      $dissolved->{'_nof_overlaps'} = $nover;\n    }\n\n  }\n  return $dissolved;\n}\n\n\n=head2 _new_cross_csp\n\n  Title   : \n  Usage   : \n  Function: create a cross contig spectrum object\n  Returns : \n  Args    : \n\n\n\nsub _new_cross_csp {\n  my ($self, $mixed_csp) = @_;\n  # Sanity check on the mixed contig spectrum\n  # There must be at least one assembly\n  if (!defined $mixed_csp->{'_assembly'} ||\n      scalar @{$mixed_csp->{'_assembly'}} < 1) {\n    $self->throw(\"The mixed contig spectrum must be based on at least one \".\n    \"assembly.\");\n  }\n  \n  # New dissolved contig spectrum object\n  my $cross = Bio::Assembly::Tools::ContigSpectrum->new();\n  my %spectrum = (1 => 0);\n  \n  # Take parent or mixed attributes\n  if ($self->{'_eff_asm_params'}) {\n    $cross->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  } else {\n    $cross->{'_eff_asm_params'} = $mixed_csp->{'_eff_asm_params'};\n  }\n  if ($self->{'_min_overlap'} && $self->{'_min_identity'}) {\n    ( $cross->{'_min_overlap'}, $cross->{'_min_identity'} ) = \n      ( $self->{'_min_overlap'}, $self->{'_min_identity'} );\n  } else {\n    ( $cross->{'_min_overlap'}, $cross->{'_min_identity'} ) = \n      ( $mixed_csp->{'_min_overlap'}, $mixed_csp->{'_min_identity'} );\n  }\n  \n  # Get cross contig spectrum for each assembly\n  for my $assembly (@{$mixed_csp->{'_assembly'}}) {\n    # Go through contigs and skip the pure ones\n    my %good_seqs;\n    for my $contig ($assembly->all_contigs) {\n      # Get origins\n      my @seq_origins;\n      my @seq_ids;\n      for my $seq ($contig->each_seq) {\n        # current sequence origin\n        my $seq_id = $seq->id;\n        $seq_id =~ m/^(.+)\\|/;\n        my $seq_header = $1;\n        $self->warn(\"Sequence $seq_id does not seem to have a header. Skipping\".\n          \" it...\") if not defined $seq_header;\n        $seq_header ||= '';\n        push @seq_origins, $seq_header;\n        push @seq_ids, $seq_id;\n      }\n      my $qsize = scalar(@seq_ids);\n      my @origins = sort { $a cmp $b } @seq_origins;\n      my $size = scalar(@origins);\n      for (my $i = 1 ; $i < $size ; $i++) {\n        if ($origins[$i] eq $origins[$i-1]) {\n          splice @origins, $i, 1;\n          $i--;\n          $size--;\n        }\n      }\n      # Update cross-contig number in spectrum\n      if ($size > 1) { # cross-contig detected\n        # update good sequences\n        for my $seq_id (@seq_ids) {\n          $good_seqs{$seq_id} = 1;\n        }\n        # update number of cross q-contigs in spectrum\n        if (defined $spectrum{$qsize}) {\n          $spectrum{$qsize}++;\n        } else {\n          $spectrum{$qsize} = 1;\n        }\n      }\n      # Update number of cross 1-contigs\n      if ($size > 1) { # cross-contig detected\n        for my $origin (@origins) {\n          # sequences to use\n          my @ids;\n          for (my $i = 0 ; $i < $qsize ; $i++) {\n            my $seq_origin = $seq_origins[$i];\n            my $seq_id = $seq_ids[$i];\n            push @ids, $seq_id if $seq_origin eq $origin;\n          }\n          if (scalar @ids == 1) {\n            $spectrum{1}++;\n          } elsif (scalar @ids > 1) {\n            my $contig_spectrum = $cross->_naive_assembler(\n              $contig, \\@ids, $cross->{'_min_overlap'},\n              $cross->{'_min_identity'});\n            $spectrum{1} += $$contig_spectrum{1};\n          } else {\n            $self->throw(\"The size is <= 0. How could such a thing happen?\");\n          }\n        }\n      }\n    }\n    # Get sequence stats\n    my ($nseq, $avgseql) = $cross->_get_seq_stats($assembly, \\%good_seqs);\n    $cross->{'_avg_seq_len'} = $avgseql;\n    $cross->{'_nof_seq'}     = $nseq;\n    # Get eff_asm_param for these sequences\n    if ($cross->{'_eff_asm_params'} > 0) {\n      my ($nover, $minl, $avgl, $minid, $avgid)\n        = $cross->_get_overlap_stats($assembly, \\%good_seqs);\n      $cross->{'_min_overlap'}  = $minl;\n      $cross->{'_min_identity'} = $minid;\n      $cross->{'_avg_overlap'}  = $avgl;\n      $cross->{'_avg_identity'} = $avgid;\n      $cross->{'_nof_overlaps'} = $nover;\n    }\n  }\n  \n  $cross->_import_spectrum(\\%spectrum);\n  # Update nof_rep\n  $cross->{'_nof_rep'}--;\n  $cross->{'_nof_rep'} += $mixed_csp->{'_nof_rep'};\n  \n  return $cross;\n}\n\n=head2 _import_assembly\n\n  Title   : _import_assembly\n  Usage   : $csp->_import_assembly($assemblyobj);\n  Function: Update a contig spectrum object based on an assembly object\n  Returns : 1 for success, 0 for error\n  Args    : Bio::Assembly::Scaffold assembly object\n\n\nsub _import_assembly {\n  my ($self, $assemblyobj) = @_;\n  # Sanity check\n  if( !ref $assemblyobj || ! $assemblyobj->isa('Bio::Assembly::ScaffoldI') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::ScaffoldI assembly \".\n        \"object [\".ref($assemblyobj).\"]\");\n  }\n  # Create new object from assembly\n  my $csp = $self->_new_from_assembly($assemblyobj);\n  # Update current contig spectrum object with new one\n  $self->add($csp);\n  return 1;\n}\n\n\n=head2 _import_spectrum\n\n  Title   : _import_spectrum\n  Usage   : $csp->_import_spectrum({ 1 => 90 , 2 => 3 , 4 => 1 })\n  Function: update a contig spectrum object based on a contig spectrum\n            represented as a hash (key: contig size, value: number of contigs of\n            this size)\n  Returns : 1 for success, 0 for error\n  Args    : contig spectrum as a hash reference\n\n\nsub _import_spectrum {\n  my ($self, $spectrum) = @_;\n  # Sanity check\n  if( ! ref $spectrum || ! ref $spectrum eq 'HASH') {\n    $self->throw(\"Spectrum should be a hash reference, but it is [\".\n      ref($spectrum).\"]\");\n  }\n  \n  # Update the spectrum (+ nof_rep, max_size and nof_seq)\n  for my $size (keys %$spectrum) {\n    # Get the number of contigs of different size\n    if (defined $self->{'_spectrum'}{$size}) {\n      $self->{'_spectrum'}{$size} += $$spectrum{$size};\n    } else {\n      $self->{'_spectrum'}{$size} = $$spectrum{$size};\n    }\n    # Update nof_seq\n    $self->{'_nof_seq'} += $size * $$spectrum{$size};\n    # Update max_size\n    $self->{'_max_size'} = $size if $size > $self->{'_max_size'};\n  }\n  \n  # If the contig spectrum has only zero 1-contigs, max_size is zero\n  $self->{'_max_size'} = 0 if scalar keys %{$self->{'_spectrum'}} == 1 &&\n    defined $self->{'_spectrum'}{'1'} && $self->{'_spectrum'}{'1'} == 0;\n  \n  # Update nof_rep\n  $self->{'_nof_rep'}++;\n  return 1;\n}\n\n=head2 _import_dissolved_csp\n\n  Title   : _import_dissolved_csp\n  Usage   : $csp->_import_dissolved_csp($mixed_csp, $seq_header);\n  Function: Update a contig spectrum object by dissolving a mixed contig\n            spectrum based on the header of the sequences\n  Returns : 1 for success, 0 for error\n  Args    : Bio::Assembly::Tools::ContigSpectrum\n            sequence header string\n\n\nsub _import_dissolved_csp {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  # Sanity check\n  if (not defined $mixed_csp || not defined $seq_header) {\n    $self->throw(\"Expecting a contig spectrum reference and sequence header as\".\n    \" arguments\");\n  }\n  # Create new object from assembly\n  my $dissolved_csp = $self->_new_dissolved_csp($mixed_csp, $seq_header);\n  # Update current contig spectrum object with new one\n  $self->add($dissolved_csp);\n  return 1;\n}\n\n\n=head2 _import_cross_csp\n\n  Title   : _import_cross_csp\n  Usage   : $csp->_import_cross_csp($mixed_csp);\n  Function: Update a contig spectrum object by calculating the cross contig\n            spectrum based on a mixed contig spectrum\n  Returns : 1 for success, 0 for error\n  Args    : Bio::Assembly::Tools::ContigSpectrum\n\n\nsub _import_cross_csp {\n  my ($self, $mixed_csp) = @_;\n  # Sanity check\n  if (not defined $mixed_csp) {\n    $self->throw(\"Expecting a contig spectrum reference as argument\");\n  }\n\n  # Create new object from assembly\n  my $cross_csp = $self->_new_cross_csp($mixed_csp);\n\n  # Update current contig spectrum object with new one\n  $self->add($cross_csp);\n\n  return 1;\n}\n\n\n=head2 _get_seq_stats\n\n  Title   : _get_seq_stats\n  Usage   : my $seqlength = $csp->_get_seq_stats($assemblyobj);\n  Function: Get sequence statistics from an assembly:\n              number of sequences, average sequence length\n  Returns : number of sequences (integer)\n            average sequence length (decimal)\n  Args    : assembly object reference\n            hash reference with the IDs of the sequences to consider [optional]\n\n\nsub _get_seq_stats {\n  my ($self, $assemblyobj, $seq_hash) = @_;\n\n  # sanity check\n  $self->throw(\"Must provide a Bio::Assembly::Scaffold object\")\n    if (!defined $assemblyobj || !$assemblyobj->isa(\"Bio::Assembly::ScaffoldI\"));\n  $self->throw(\"Expecting a hash reference. Got [\".ref($seq_hash).\"]\")\n    if (defined $seq_hash && ! ref($seq_hash) eq 'HASH');\n\n  my $avg_seq_len = 0;\n  my $nof_seq = 0;\n  for my $contigobj ($assemblyobj->all_contigs) {\n    for my $seqobj ($contigobj->each_seq) {\n      my $seq_id = $seqobj->id;\n      next if defined $seq_hash && !defined $$seq_hash{$seq_id};\n      $nof_seq++;\n      my $seq_string = $seqobj->seq;\n      $seq_string =~ s/-//g;\n      $avg_seq_len += length($seq_string);\n    }\n  }\n  for my $singletobj ($assemblyobj->all_singlets) {\n    my $seq_id = $singletobj->seqref->id;\n    next if defined $seq_hash && !defined $$seq_hash{$seq_id};\n    $nof_seq++;\n    my $seq_string = $singletobj->seqref->seq;\n    $seq_string =~ s/-//g;\n    $avg_seq_len += length($seq_string);\n  }\n  $avg_seq_len /= $nof_seq unless $nof_seq == 0;\n  return $nof_seq, $avg_seq_len;\n}\n\n\n=head2 _get_overlap_stats\n\n  Title   : _get_overlap_stats\n  Usage   : my ($minlength, $min_identity, $avglength, $avgidentity)\n              = $csp->_get_overlap_stats($assemblyobj);\n  Function: Get statistics about pairwise overlaps in contigs of an assembly\n  Returns : number of overlaps\n            minimum overlap length\n            average overlap length\n            minimum identity percent\n            average identity percent\n  Args    : assembly object reference\n            hash reference with the IDs of the sequences to consider [optional]","label":"_get_overlap_stats($self,$assembly_obj,$seq_hash)"},"detail":"($self,$assembly_obj,$seq_hash)"},{"name":"seq_hash","line":1460,"kind":12},{"containerName":"Align::PairwiseStatistics","name":"Bio","line":1467,"kind":12},{"name":"seq_hash","kind":12,"line":1479},{"name":"_overlap_alignment","range":{"start":{"line":1539,"character":0},"end":{"line":1602,"character":9999}},"kind":12,"children":[{"kind":13,"line":1540,"name":"$self","definition":"my","containerName":"_overlap_alignment","localvar":"my"},{"name":"$contig","containerName":"_overlap_alignment","kind":13,"line":1540},{"line":1540,"kind":13,"containerName":"_overlap_alignment","name":"$qseq"},{"name":"$tseq","containerName":"_overlap_alignment","line":1540,"kind":13},{"containerName":"_overlap_alignment","name":"$min_overlap","line":1540,"kind":13},{"containerName":"_overlap_alignment","name":"$min_identity","kind":13,"line":1540},{"line":1542,"kind":13,"localvar":"my","containerName":"_overlap_alignment","name":"$qpos","definition":"my"},{"kind":13,"line":1542,"containerName":"_overlap_alignment","name":"$contig"},{"kind":12,"line":1542,"name":"get_seq_coord","containerName":"_overlap_alignment"},{"name":"$qseq","containerName":"_overlap_alignment","kind":13,"line":1542},{"localvar":"my","containerName":"_overlap_alignment","name":"$qstart","definition":"my","line":1543,"kind":13},{"name":"$qpos","containerName":"_overlap_alignment","line":1543,"kind":13},{"kind":12,"line":1543,"name":"start","containerName":"_overlap_alignment"},{"kind":13,"line":1544,"containerName":"_overlap_alignment","definition":"my","name":"$qend","localvar":"my"},{"containerName":"_overlap_alignment","name":"$qpos","kind":13,"line":1544},{"containerName":"_overlap_alignment","name":"end","line":1544,"kind":12},{"localvar":"my","containerName":"_overlap_alignment","definition":"my","name":"$tpos","line":1546,"kind":13},{"kind":13,"line":1546,"name":"$contig","containerName":"_overlap_alignment"},{"kind":12,"line":1546,"name":"get_seq_coord","containerName":"_overlap_alignment"},{"containerName":"_overlap_alignment","name":"$tseq","line":1546,"kind":13},{"containerName":"_overlap_alignment","name":"$tstart","definition":"my","localvar":"my","kind":13,"line":1547},{"name":"$tpos","containerName":"_overlap_alignment","kind":13,"line":1547},{"containerName":"_overlap_alignment","name":"start","kind":12,"line":1547},{"line":1548,"kind":13,"localvar":"my","containerName":"_overlap_alignment","name":"$tend","definition":"my"},{"name":"$tpos","containerName":"_overlap_alignment","kind":13,"line":1548},{"name":"end","containerName":"_overlap_alignment","line":1548,"kind":12},{"name":"$qstart","containerName":"_overlap_alignment","kind":13,"line":1550},{"line":1550,"kind":13,"name":"$tend","containerName":"_overlap_alignment"},{"containerName":"_overlap_alignment","name":"$qend","line":1550,"kind":13},{"kind":13,"line":1550,"containerName":"_overlap_alignment","name":"$tstart"},{"kind":13,"line":1552,"containerName":"_overlap_alignment","name":"$left","definition":"my","localvar":"my"},{"name":"$qstart","containerName":"_overlap_alignment","line":1552,"kind":13},{"line":1553,"kind":13,"name":"$left","containerName":"_overlap_alignment"},{"containerName":"_overlap_alignment","name":"$tstart","kind":13,"line":1553},{"line":1553,"kind":13,"name":"$qstart","containerName":"_overlap_alignment"},{"line":1553,"kind":13,"containerName":"_overlap_alignment","name":"$tstart"},{"localvar":"my","containerName":"_overlap_alignment","name":"$right","definition":"my","line":1554,"kind":13},{"line":1554,"kind":13,"containerName":"_overlap_alignment","name":"$qend"},{"line":1555,"kind":13,"name":"$right","containerName":"_overlap_alignment"},{"containerName":"_overlap_alignment","name":"$tend","kind":13,"line":1555},{"name":"$qend","containerName":"_overlap_alignment","line":1555,"kind":13},{"line":1555,"kind":13,"name":"$tend","containerName":"_overlap_alignment"},{"definition":"my","name":"$overlap","containerName":"_overlap_alignment","localvar":"my","kind":13,"line":1556},{"name":"$right","containerName":"_overlap_alignment","kind":13,"line":1556},{"name":"$left","containerName":"_overlap_alignment","line":1556,"kind":13},{"kind":13,"line":1557,"containerName":"_overlap_alignment","name":"$min_overlap"},{"line":1557,"kind":13,"containerName":"_overlap_alignment","name":"$overlap"},{"containerName":"_overlap_alignment","name":"$min_overlap","line":1557,"kind":13},{"line":1559,"kind":13,"localvar":"my","definition":"my","name":"$qleft","containerName":"_overlap_alignment"},{"kind":13,"line":1559,"name":"$contig","containerName":"_overlap_alignment"},{"name":"change_coord","containerName":"_overlap_alignment","kind":12,"line":1559},{"name":"$qseq","containerName":"_overlap_alignment","line":1559,"kind":13},{"kind":12,"line":1559,"name":"id","containerName":"_overlap_alignment"},{"kind":13,"line":1560,"containerName":"_overlap_alignment","name":"$left"},{"kind":13,"line":1561,"name":"$qright","definition":"my","containerName":"_overlap_alignment","localvar":"my"},{"line":1561,"kind":13,"containerName":"_overlap_alignment","name":"$qleft"},{"containerName":"_overlap_alignment","name":"$overlap","line":1561,"kind":13},{"kind":13,"line":1562,"definition":"my","name":"$qstring","containerName":"_overlap_alignment","localvar":"my"},{"kind":13,"line":1562,"containerName":"_overlap_alignment","name":"$qseq"},{"name":"seq","containerName":"_overlap_alignment","kind":12,"line":1562},{"name":"$qstring","containerName":"_overlap_alignment","line":1563,"kind":13},{"name":"$qstring","containerName":"_overlap_alignment","kind":13,"line":1563},{"line":1563,"kind":13,"containerName":"_overlap_alignment","name":"$qleft"},{"containerName":"_overlap_alignment","name":"$overlap","kind":13,"line":1563},{"containerName":"_overlap_alignment","name":"$tleft","definition":"my","localvar":"my","kind":13,"line":1564},{"name":"$contig","containerName":"_overlap_alignment","kind":13,"line":1564},{"name":"change_coord","containerName":"_overlap_alignment","line":1564,"kind":12},{"kind":13,"line":1564,"containerName":"_overlap_alignment","name":"$tseq"},{"name":"id","containerName":"_overlap_alignment","kind":12,"line":1564},{"kind":13,"line":1565,"name":"$left","containerName":"_overlap_alignment"},{"kind":13,"line":1566,"containerName":"_overlap_alignment","definition":"my","name":"$tright","localvar":"my"},{"kind":13,"line":1566,"name":"$tleft","containerName":"_overlap_alignment"},{"name":"$overlap","containerName":"_overlap_alignment","kind":13,"line":1566},{"localvar":"my","name":"$tstring","definition":"my","containerName":"_overlap_alignment","line":1567,"kind":13},{"kind":13,"line":1567,"containerName":"_overlap_alignment","name":"$tseq"},{"name":"seq","containerName":"_overlap_alignment","line":1567,"kind":12},{"kind":13,"line":1568,"containerName":"_overlap_alignment","name":"$tstring"},{"line":1568,"kind":13,"name":"$tstring","containerName":"_overlap_alignment"},{"kind":13,"line":1568,"containerName":"_overlap_alignment","name":"$tleft"},{"containerName":"_overlap_alignment","name":"$overlap","kind":13,"line":1568},{"containerName":"_overlap_alignment","definition":"my","name":"$pos","localvar":"my","kind":13,"line":1570},{"line":1570,"kind":13,"containerName":"_overlap_alignment","name":"$pos"},{"name":"$overlap","containerName":"_overlap_alignment","kind":13,"line":1570},{"line":1570,"kind":13,"containerName":"_overlap_alignment","name":"$pos"},{"kind":13,"line":1571,"definition":"my","name":"$qnt","containerName":"_overlap_alignment","localvar":"my"},{"line":1571,"kind":13,"name":"$qstring","containerName":"_overlap_alignment"},{"name":"$pos","containerName":"_overlap_alignment","kind":13,"line":1571},{"line":1572,"kind":13,"localvar":"my","containerName":"_overlap_alignment","definition":"my","name":"$tnt"},{"containerName":"_overlap_alignment","name":"$tstring","kind":13,"line":1572},{"name":"$pos","containerName":"_overlap_alignment","kind":13,"line":1572},{"containerName":"_overlap_alignment","name":"$qnt","line":1573,"kind":13},{"line":1573,"kind":13,"name":"$tnt","containerName":"_overlap_alignment"},{"kind":13,"line":1574,"name":"$qstring","containerName":"_overlap_alignment"},{"name":"$pos","containerName":"_overlap_alignment","line":1574,"kind":13},{"containerName":"_overlap_alignment","name":"$tstring","kind":13,"line":1575},{"kind":13,"line":1575,"containerName":"_overlap_alignment","name":"$pos"},{"kind":13,"line":1576,"name":"$pos","containerName":"_overlap_alignment"},{"kind":13,"line":1577,"name":"$overlap","containerName":"_overlap_alignment"},{"line":1580,"kind":13,"name":"$min_overlap","containerName":"_overlap_alignment"},{"containerName":"_overlap_alignment","name":"$overlap","line":1580,"kind":13},{"kind":13,"line":1580,"name":"$min_overlap","containerName":"_overlap_alignment"},{"localvar":"my","containerName":"_overlap_alignment","name":"$aln","definition":"my","line":1582,"kind":13},{"line":1582,"kind":12,"name":"new","containerName":"_overlap_alignment"},{"line":1583,"kind":13,"localvar":"my","name":"$qalseq","definition":"my","containerName":"_overlap_alignment"},{"kind":12,"line":1583,"containerName":"_overlap_alignment","name":"new"},{"line":1585,"kind":13,"containerName":"_overlap_alignment","name":"$qstring"},{"name":"$aln","containerName":"_overlap_alignment","line":1589,"kind":13},{"line":1589,"kind":12,"containerName":"_overlap_alignment","name":"add_seq"},{"containerName":"_overlap_alignment","name":"$qalseq","kind":13,"line":1589},{"containerName":"_overlap_alignment","definition":"my","name":"$talseq","localvar":"my","kind":13,"line":1590},{"line":1590,"kind":12,"containerName":"_overlap_alignment","name":"new"},{"line":1592,"kind":13,"containerName":"_overlap_alignment","name":"$tstring"},{"name":"$aln","containerName":"_overlap_alignment","line":1596,"kind":13},{"name":"add_seq","containerName":"_overlap_alignment","kind":12,"line":1596},{"line":1596,"kind":13,"name":"$talseq","containerName":"_overlap_alignment"},{"kind":13,"line":1598,"containerName":"_overlap_alignment","definition":"my","name":"$identity","localvar":"my"},{"kind":13,"line":1598,"name":"$aln","containerName":"_overlap_alignment"},{"containerName":"_overlap_alignment","name":"overall_percentage_identity","kind":12,"line":1598},{"containerName":"_overlap_alignment","name":"$min_identity","kind":13,"line":1599},{"line":1599,"kind":13,"containerName":"_overlap_alignment","name":"$identity"},{"line":1599,"kind":13,"containerName":"_overlap_alignment","name":"$min_identity"},{"line":1601,"kind":13,"containerName":"_overlap_alignment","name":"$aln"},{"containerName":"_overlap_alignment","name":"$overlap","line":1601,"kind":13},{"kind":13,"line":1601,"name":"$identity","containerName":"_overlap_alignment"}],"line":1539,"definition":"sub","containerName":"main::","signature":{"label":"_overlap_alignment($self,$contig,$qseq,$tseq,$min_overlap,$min_identity)","parameters":[{"label":"$self"},{"label":"$contig"},{"label":"$qseq"},{"label":"$tseq"},{"label":"$min_overlap"},{"label":"$min_identity"}],"documentation":"__END__\n#\n# BioPerl module for Bio::Assembly::Tools::ContigSpectrum\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Tools::ContigSpectrum - create and manipulate contig spectra\n\n=head1 SYNOPSIS\n\n  # Simple contig spectrum creation\n  my $csp1 = Bio::Assembly::Tools::ContigSpectrum->new(\n    -id       => 'csp1',\n    -spectrum => { 1 => 10,\n                   2 => 2,\n                   3 => 1 } );\n\n  # ...or another way to create a simple contig spectrum\n  my $csp2 = Bio::Assembly::Tools::ContigSpectrum->new;\n  $csp2->id('csp2');\n  $csp2->spectrum({ 1 => 20, 2 => 1, 4 => 1 });\n\n  # Get some information\n  print \"This is contig spectrum \".$csp->id.\"\\n\";\n  print \"It contains \".$csp->nof_seq.\" sequences\\n\";\n  print \"The largest contig has \".$csp->max_size.\" sequences\\n\";\n  print \"The spectrum is: \".$csp->to_string($csp->spectrum).\"\\n\";\n\n  # Let's add the contig spectra\n  my $summed_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $summed_csp->add($csp1);\n  $summed_csp->add($csp2);\n  print \"The summed contig spectrum is \".$summed_csp->to_string.\"\\n\";\n\n  # Make an average\n  my $avg_csp = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg_csp = $avg_csp->average([$csp1, $csp2]);\n  print \"The average contig spectrum is \".$avg_csp->to_string.\"\\n\";\n\n  # Get a contig spectrum from an assembly\n  my $from_assembly = Bio::Assembly::Tools::ContigSpectrum->new(\n    -assembly       => $assembly_object,\n    -eff_asm_params => 1);\n  print \"The contig spectrum from assembly is \".$from_assembly->to_string.\"\\n\";\n\n  # Report advanced information (possible because eff_asm_params = 1)\n  print \"Average sequence length: \".$from_assembly->avg_seq_length.\" bp\\n\";\n  print \"Minimum overlap length: \".$from_assembly->min_overlap.\" bp\\n\";\n  print \"Average overlap length: \".$from_assembly->avg_overlap.\" bp\\n\";\n  print \"Minimum overlap match: \".$from_assembly->min_identity.\" %\\n\";\n  print \"Average overlap match: \".$from_assembly->avg_identity.\" %\\n\";\n\n  # Assuming the assembly object contains sequences from several different\n  # metagenomes, we have a mixed contig spectrum from which a cross contig\n  # spectrum and dissolved contig spectra can be obtained\n  my $mixed_csp = $from_assembly;\n\n  # Calculate a dissolved contig spectrum\n  my $meta1_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome1'] );\n  my $meta2_dissolved = Bio::Assembly::Tools::ContigSpectrum->new(\n    -dissolve => [$mixed_csp, 'metagenome2'] );\n  print \"The dissolved contig spectra are:\\n\".\n    $meta1_dissolved->to_string.\"\\n\".\n    $meta2_dissolved->to_string.\"\\n\";\n\n  # Determine a cross contig spectrum\n  my $cross_csp = Bio::Assembly::Tools::ContigSpectrum->new(\n    -cross => $mixed_csp );\n  print \"The cross contig spectrum is \".$cross_csp->to_string.\"\\n\";\n\n  # Score a contig spectrum (the more abundant the contigs and the larger their\n  # size, the larger the score)\n\n\n=head1 DESCRIPTION\n\nThe Bio::Assembly::Tools::ContigSpectrum Perl module enables to\nmanually create contig spectra, import them from assemblies,\nmanipulate them, transform between different types of contig spectra\nand output them.\n\nBio::Assembly::Tools::ContigSpectrum is a module to create, manipulate\nand output contig spectra, assembly-derived data used in metagenomics\n(community genomics) for diversity estimation.\n\n=head2 Background\n\nA contig spectrum is the count of the number of contigs of different\nsize in an assembly. For example, the contig spectrum [100 5 1 0 0\n...] means that there were 100 singlets (1-contigs), 5 contigs of 2\nsequences (2-contigs), 1 contig of 3 sequences (3-contig) and no\nlarger contigs.\n\nAn assembly can be produced from a mixture of sequences from different\nmetagenomes. The contig obtained from this assembly is a mixed contig\nspectrum. The contribution of each metagenome in this mixed contig\nspectrum can be obtained by determining a dissolved contig spectrum.\n\nFinally, based on a mixed contig spectrum, a cross contig spectrum can\nbe determined. In a cross contig spectrum, only contigs containing\nsequences from different metagenomes are kept; \"pure\" contigs are\nexcluded. Additionally, the total number of singletons (1-contigs)\nfrom each region that assembles with any fragments from other regions\nis the number of 1-contigs in the cross contig spectrum.\n\n=head2 Implementation\n\nThe simplest representation of a contig spectrum is as a hash\nrepresentation where the key is the contig size (number of sequences\nmaking up the contig) and the value the number of contigs of this\nsize.\n\nIn fact, it is useful to have more information associated with the\ncontig spectrum, hence the Bio::Assembly::Tools::ContigSpectrum module\nimplements an object containing a contig spectrum hash and additional\ninformation. The get/set methods to access them are:\n\n    id              contig spectrum ID\n    nof_seq         number of sequences\n    nof_rep         number of repetitions (assemblies) used\n    max_size        size of (number of sequences in) the largest contig\n    nof_overlaps    number of overlaps\n    min_overlap     minimum overlap length for building a contig\n    min_identity    minimum sequence identity over the overlap length\n    avg_overlap     average overlap length\n    avg_identity    average overlap identity\n    avg_seq_length  average sequence length\n    eff_asm_params  effective assembly parameters\n    spectrum        hash representation of a contig spectrum\n\n  Operations on the contig spectra:\n\n    to_string       create a string representation of the spectrum\n    spectrum        import a hash contig spectrum\n    assembly        determine a contig spectrum from an assembly\n    dissolve        calculate a dissolved contig spectrum (based on assembly)\n    cross           produce a cross contig spectrum (based on assembly)\n    add             add a contig spectrum to an existing one\n    average         make an average of several contig spectra\n\nWhen using operations that rely on knowing \"where\" (from what\nmetagenomes) a sequence came from (i.e. when creating a dissolved or\ncross contig spectrum), make sure that the sequences used for the\nassembly have a name header, e.g.  E<gt>metagenome1|seq1,\nE<gt>metagenome2|seq1, ...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent_dot_angly_at_gmail_dot_com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::Tools::ContigSpectrum;\n\nuse strict;\n\nuse Bio::Root::Root;\nuse Bio::Assembly::Scaffold;\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\nuse Bio::Align::PairwiseStatistics;\n\nuse base 'Bio::Root::Root';\n\n\n=head2 new\n\n  Title   : new\n  Usage   : my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -id => 'some_name',\n              -spectrum =>  { 1 => 90 , 2 => 3 , 4 => 1 },\n            );\n              or\n            my $csp = Bio::Assembly::Tools::ContigSpectrum->new(\n              -assembly =>  $assembly_obj\n            );\n  Function: create a new contig spectrum object\n  Returns : reference to a contig spectrum object\n  Args    : none\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ( $id, $nof_seq, $nof_rep, $max_size, $nof_overlaps, $min_overlap,\n    $min_identity, $avg_overlap, $avg_identity, $avg_seq_len, $spectrum,\n    $assembly, $eff_asm_params, $dissolve, $cross) = $self->_rearrange( [qw(ID\n    NOF_SEQ NOF_REP MAX_SIZE NOF_OVERLAPS MIN_OVERLAP MIN_IDENTITY AVG_OVERLAP\n    AVG_IDENTITY AVG_SEQ_LEN SPECTRUM ASSEMBLY EFF_ASM_PARAMS DISSOLVE CROSS)],\n    @args );\n\n  # First set up some defauts\n  $self->{'_id'}             = 'NoName';\n  $self->{'_nof_seq'}        = 0;\n  $self->{'_nof_rep'}        = 0;\n  $self->{'_max_size'}       = 0;\n  $self->{'_nof_overlaps'}   = 0;\n  $self->{'_min_overlap'}    = undef;\n  $self->{'_min_identity'}   = undef;\n  $self->{'_avg_overlap'}    = 0;\n  $self->{'_avg_identity'}   = 0;\n  $self->{'_avg_seq_len'}    = 0;\n  $self->{'_eff_asm_params'} = 0;\n  $self->{'_spectrum'}       = {1 => 0};  # contig spectrum hash representation\n  $self->{'_assembly'}       = []; # list of assembly objects used\n\n  # Then, according to user desires, override defaults\n  $self->{'_id'}             = $id             if (defined $id);\n  $self->{'_nof_seq'}        = $nof_seq        if (defined $nof_seq);\n  $self->{'_nof_rep'}        = $nof_rep        if (defined $nof_rep);\n  $self->{'_max_size'}       = $max_size       if (defined $max_size);\n  $self->{'_nof_overlaps'}   = $nof_overlaps   if (defined $nof_overlaps);\n  $self->{'_min_overlap'}    = $min_overlap    if (defined $min_overlap);\n  $self->{'_avg_overlap'}    = $avg_overlap    if (defined $avg_overlap);\n  $self->{'_min_identity'}   = $min_identity   if (defined $min_identity);\n  $self->{'_avg_identity'}   = $avg_identity   if (defined $avg_identity);\n  $self->{'_avg_seq_len'}    = $avg_seq_len    if (defined $avg_seq_len);\n  $self->{'_eff_asm_params'} = $eff_asm_params if (defined $eff_asm_params);\n\n  # Finally get stuff that can be gotten in an automated way\n  $self->_import_spectrum($spectrum) if defined($spectrum);\n  $self->_import_assembly($assembly) if defined($assembly);\n  if (defined($dissolve)) {\n    my ($mixed_csp, $header) = (@$dissolve[0], @$dissolve[1]);\n    $self->_import_dissolved_csp($mixed_csp, $header);\n  }\n  $self->_import_cross_csp($cross)   if defined($cross);\n\n  return $self;\n}\n\n\n=head2 id\n\n  Title   : id\n  Usage   : $csp->id\n  Function: get/set contig spectrum id\n  Returns : string\n  Args    : string [optional]\n\n\nsub id {\n  my ($self, $id) = @_;\n  if (defined $id) {\n    $self->{'_id'} = $id;\n  }\n  $id = $self->{'_id'};\n  return $id;\n}\n\n\n=head2 nof_seq\n\n  Title   : nof_seq\n  Usage   : $csp->nof_seq\n  Function: get/set the number of sequences making up the contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_seq {\n  my ($self, $nof_seq) = @_;\n  if (defined $nof_seq) {\n    $self->throw(\"The number of sequences must be strictly positive. Got \".\n      \"'$nof_seq'\") if $nof_seq < 1;\n    $self->{'_nof_seq'} = $nof_seq;\n  }\n  $nof_seq = $self->{'_nof_seq'};\n  return $nof_seq;\n}\n\n\n=head2 nof_rep\n\n  Title   : nof_rep\n  Usage   : $csp->nof_rep\n  Function: Get/Set the number of repetitions (assemblies) used to create the \n            contig spectrum\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_rep {\n  my ($self, $nof_rep) = @_;\n  if (defined $nof_rep) {\n    $self->throw(\"The number of repetitions must be strictly positive. Got \".\n      \"'$nof_rep'\") if $nof_rep < 1;\n    $self->{'_nof_rep'} = $nof_rep;\n  }\n  $nof_rep = $self->{'_nof_rep'};\n  return $nof_rep;\n}\n\n\n=head2 max_size\n\n  Title   : max_size\n  Usage   : $csp->max_size\n  Function: get/set the size of (number of sequences in) the largest contig\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub max_size {\n  my ($self, $max_size) = @_;\n  if (defined $max_size) {\n    $self->throw(\"The contig maximum size must be strictly positive. Got \".\n      \"'$max_size'\") if $max_size < 1;\n    $self->{'_max_size'} = $max_size;\n  }\n  $max_size = $self->{'_max_size'};\n  return $max_size;\n}\n\n\n=head2 nof_overlaps\n\n  Title   : nof_overlaps\n  Usage   : $csp->nof_overlaps\n  Function: Get/Set the number of overlaps in the assembly.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub nof_overlaps {\n  my ($self, $nof_overlaps) = @_;\n  if (defined $nof_overlaps) {\n    $self->throw(\"The number of overlaps must be strictly positive. Got \".\n      \"'$nof_overlaps'\") if $nof_overlaps < 1;\n    $self->{'_nof_overlaps'} = $nof_overlaps;\n  }\n  $nof_overlaps = $self->{'_nof_overlaps'};\n  return $nof_overlaps;\n}\n\n\n=head2 min_overlap\n\n  Title   : min_overlap\n  Usage   : $csp->min_overlap\n  Function: get/set the assembly minimum overlap length\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub min_overlap {\n  my ($self, $min_overlap) = @_;\n  if (defined $min_overlap) {\n    $self->throw(\"The minimum of overlap length must be strictly positive. Got\".\n      \" '$min_overlap'\") if $min_overlap < 1;\n    $self->{'_min_overlap'} = $min_overlap;\n  }\n  $min_overlap = $self->{'_min_overlap'};\n  return $min_overlap;\n}\n\n\n=head2 avg_overlap\n\n  Title   : avg_overlap\n  Usage   : $csp->avg_overlap\n  Function: get/set the assembly average overlap length\n  Returns : decimal\n  Args    : decimal [optional]\n\n\nsub avg_overlap {\n  my ($self, $avg_overlap) = @_;\n  if (defined $avg_overlap) {\n    $self->throw(\"The average overlap length must be strictly positive. Got \".\n      \"'$avg_overlap'\") if $avg_overlap < 1;\n    $self->{'_avg_overlap'} = $avg_overlap;\n  }\n  $avg_overlap = $self->{'_avg_overlap'};\n  return $avg_overlap;\n}\n\n\n=head2 min_identity\n\n  Title   : min_identity\n  Usage   : $csp->min_identity\n  Function: get/set the assembly minimum overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub min_identity {\n  my ($self, $min_identity) = @_;\n  if (defined $min_identity) {\n    $self->throw(\"The minimum overlap percent identity must be strictly \".\n      \"positive. Got '$min_identity'\") if $min_identity < 1;\n    $self->{'_min_identity'} = $min_identity;\n  }\n  $min_identity = $self->{'_min_identity'};\n  return $min_identity;\n}\n\n\n=head2 avg_identity\n\n  Title   : avg_identity\n  Usage   : $csp->avg_identity\n  Function: get/set the assembly average overlap identity percent\n  Returns : 0 < decimal < 100\n  Args    : 0 < decimal < 100 [optional]\n\n\nsub avg_identity {\n  my ($self, $avg_identity) = @_;\n  if (defined $avg_identity) {\n    $self->throw(\"The average overlap percent identity must be strictly \".\n      \"positive. Got '$avg_identity'\") if $avg_identity < 1;\n    $self->{'_avg_identity'} = $avg_identity;\n  }\n  $avg_identity = $self->{'_avg_identity'};\n  return $avg_identity;\n}\n\n\n=head2 avg_seq_len\n\n  Title   : avg_seq_len\n  Usage   : $csp->avg_seq_len\n  Function: get/set the assembly average sequence length\n  Returns : avg_seq_len\n  Args    : real [optional]\n\n\nsub avg_seq_len {\n  my ($self, $avg_seq_len) = @_;\n  if (defined $avg_seq_len) {\n    $self->throw(\"The average sequence length must be strictly positive. Got \".\n      \"'$avg_seq_len'\") if $avg_seq_len < 1;\n    $self->{'_avg_seq_len'} = $avg_seq_len;\n  }\n  $avg_seq_len = $self->{'_avg_seq_len'};\n  return $avg_seq_len;\n}\n\n\n=head2 eff_asm_params\n\n  Title   : eff_asm_params\n  Usage   : $csp->eff_asm_params(1)\n  Function: Get/set the effective assembly parameters option. It defines if the\n            effective assembly parameters should be determined when a contig\n            spectrum based or derived from an assembly is calulated. The\n            effective assembly parameters include avg_seq_length, nof_overlaps,\n            min_overlap, avg_overlap, min_identity and avg_identity.\n            1 = get them, 0 = don't.\n  Returns : integer\n  Args    : integer [optional]\n\n\nsub eff_asm_params {\n  my ($self, $eff_asm_params) = @_;\n  if (defined $eff_asm_params) {\n    $self->throw(\"eff_asm_params can only take values 0 or 1. Input value was \".\n      \"'$eff_asm_params'\") unless $eff_asm_params == 0 || $eff_asm_params == 1;\n    $self->{'_eff_asm_params'} = $eff_asm_params;\n  }\n  $eff_asm_params = $self->{'_eff_asm_params'};\n  return $eff_asm_params;\n}\n\n\n=head2 spectrum\n\n  Title   : spectrum\n  Usage   : my $spectrum = $csp->spectrum({1=>10, 2=>2, 3=>1});\n  Function: Get the current contig spectrum represented as a hash / Update a\n            contig spectrum object based on a contig spectrum represented as a\n            hash\n            The hash representation of a contig spectrum is as following:\n              key   -> contig size (in number of sequences)\n              value -> number of contigs of this size\n  Returns : contig spectrum as a hash reference\n  Args    : contig spectrum as a hash reference [optional]\n\n\nsub spectrum {\n  my ($self, $spectrum) = @_;\n  if (defined $spectrum) {\n    $self->_import_spectrum($spectrum);\n  }\n  $spectrum = $self->{'_spectrum'};\n  return $spectrum;\n}\n\n\n=head2 assembly\n\n  Title   : assembly\n  Usage   : my @asm_list = $csp->assembly();\n  Function: Get a reference to the list of assembly object reference used to\n            make the contig spectrum object / Update the contig spectrum object\n            based on an assembly object.\n  Returns : array of Bio::Assembly::Scaffold\n  Args    : Bio::Assembly::Scaffold\n\n\nsub assembly {\n  my ($self, $assembly) = @_;\n  if (defined $assembly) {\n    $self->_import_assembly($assembly);\n  }\n  my @asm_list = @{$self->{'_assembly'}} if defined $self->{'_assembly'};\n  return \\@asm_list;\n}\n\n=head2 drop_assembly\n\n  Title   : drop_assembly\n  Usage   : $csp->drop_assembly();\n  Function: Remove all assembly objects associated with a contig spectrum.\n            Assembly objects can be big. This method allows to free some memory\n            when assembly information is not needed anymore.\n  Returns : 1 for success, 0 for failure\n  Args    : none\n\n\nsub drop_assembly {\n  my ($self) = @_;\n  $self->{'_assembly'} = [];\n  return 1;\n}\n\n=head2 dissolve\n\n  Title   : dissolve\n  Usage   : $dissolved_csp->dissolve($mixed_csp, $seq_header);\n  Function: Dissolve a mixed contig spectrum for the set of sequences that\n            contain the specified header, i.e. determine the contribution of\n            these sequences to the mixed contig spectrum based on the assembly.\n            The mixed contig spectrum object must have been created based on one\n            (or several) assembly object(s). Additionally, min_overlap and\n            min_identity must have been set (either manually using min_overlap\n            or automatically by switching on the eff_asm_params option).\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n            sequence header string\n\n\n\nsub dissolve {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  $self->_import_dissolved_csp($mixed_csp, $seq_header);\n  return 1;\n}\n\n\n=head2 cross\n\n  Title   : cross\n  Usage   : $cross_csp->cross($mixed_csp);\n  Function: Calculate a cross contig_spectrum based on a mixed contig_spectrum.\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum reference\n\n\nsub cross {\n  my ($self, $mixed_csp) = @_;\n  $self->_import_cross_csp($mixed_csp);\n  return 1;\n}\n\n=head2 to_string\n\n  Title   : to_string\n  Usage   : my $csp_string = $csp->to_string;\n  Function: Convert the contig spectrum into a string (easy to print!!).\n  Returns : string\n  Args    : element separator (integer) [optional]\n              1 -> space-separated\n              2 -> tab-separated\n              3 -> newline-separated\n\n\nsub to_string {\n  my ($self, $element_separator) = @_;\n  return 0 if $self->{'_max_size'} == 0;\n  $element_separator ||= 1;\n  if ($element_separator == 1) {\n    $element_separator = ' ';\n  } elsif ($element_separator == 2) {\n    $element_separator = \"\\t\";\n  } elsif ($element_separator == 3) {\n    $element_separator = \"\\n\";\n  } else {\n    $self->throw(\"Unknown separator type '$element_separator'\\n\");\n  }\n  my $str = '';\n  for (my $q = 1 ; $q <= $self->{'_max_size'} ; $q++) {\n    my $val = 0;\n    if (exists $self->{'_spectrum'}{$q}) {\n      $val = $self->{'_spectrum'}{$q};\n    }\n    $str .= $val.$element_separator;\n  }\n  $str =~ s/\\s$//;\n  return $str;\n}\n\n\n=head2 add\n\n  Title   : add\n  Usage   : $csp->add($additional_csp);\n  Function: Add a contig spectrum to an existing one: sums the spectra, update\n            the number of sequences, number of repetitions, ...\n  Returns : 1 for success, 0 for failure\n  Args    : Bio::Assembly::Tools::ContigSpectrum object\n\n\nsub add {\n  my ($self, $csp) = @_;\n  # Sanity check\n  if( !ref $csp || ! $csp->isa('Bio::Assembly::Tools::ContigSpectrum') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n  }\n  # Update overlap statistics\n  if ( $self->{'_eff_asm_params'} > 0 ) {\n    # Warnings\n    if ( $csp->{'_eff_asm_params'} == 0 ) {\n      $self->warn(\"The parent contig spectrum needs effective assembly \".\n        \"parameters (eff_asm_params = \".$self->{'_eff_asm_params'}.\") but the \".\n        \"child contig spectrum doesn't have them (eff_asm_params = \".\n        $csp->{'_eff_asm_params'}.\"). Skipping them...\");\n    } elsif ( $csp->{'_eff_asm_params'} != $self->{'_eff_asm_params'} ) {\n      $self->warn(\"The parent contig spectrum needs a different method for \".\n        \"detecting the effective assembly parameters (eff_asm_params = \".\n        $self->{'_eff_asm_params'}.\") than the one specified for the child \".\n        \"contig spectrum (eff_asm_params = \".$csp->{'_eff_asm_params'}.\"). \".\n        \"Ignoring the differences...\");\n    }\n    # Update existing stats\n    my $tot_num_overlaps = $csp->{'_nof_overlaps'} + $self->{'_nof_overlaps'};\n    $self->{'_min_overlap'} = $csp->{'_min_overlap'} if\n      defined $csp->{'_min_overlap'} && ( ! defined $self->{'_min_overlap'} ||\n      $csp->{'_min_overlap'} < $self->{'_min_overlap'} );\n    $self->{'_min_identity'} = $csp->{'_min_identity'} if\n      defined $csp->{'_min_identity'} && ( ! defined $self->{'_min_identity'} ||\n      $csp->{'_min_identity'} < $self->{'_min_identity'} );\n    if ($tot_num_overlaps != 0) {\n      $self->{'_avg_overlap'} =\n        ($csp->{'_avg_overlap'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_overlap'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n      $self->{'_avg_identity'} =\n        ($csp->{'_avg_identity'} * $csp->{'_nof_overlaps'}\n        + $self->{'_avg_identity'} * $self->{'_nof_overlaps'})\n        / $tot_num_overlaps;\n    }\n    $self->{'_nof_overlaps'} = $tot_num_overlaps;\n  }\n  # Update sequence statistics\n  my $tot_nof_seq = $csp->{'_nof_seq'} + $self->{'_nof_seq'};\n  if (not $tot_nof_seq == 0) {\n    $self->{'_avg_seq_len'} = ($csp->{'_avg_seq_len'} * $csp->{'_nof_seq'} +\n      $self->{'_avg_seq_len'} * $self->{'_nof_seq'}) / $tot_nof_seq;\n  }\n  # Update spectrum (and nof_seq, max_size, and increment nof_rep by 1)\n  $self->_import_spectrum($csp->{'_spectrum'});\n  # Update nof_rep\n  $self->{'_nof_rep'}--;\n  $self->{'_nof_rep'} += $csp->{'_nof_rep'};\n  # Update list of assembly objects used\n  push @{$self->{'_assembly'}}, @{$csp->{'_assembly'}}\n    if defined $csp->{'_assembly'};\n  return 1;\n}\n\n\n=head2 average\n\n  Title   : average\n  Usage   : my $avg_csp = $csp->average([$csp1, $csp2, $csp3]);\n  Function: Average one contig spectrum or the sum of several contig spectra by\n            the number of repetitions\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Tools::ContigSpectrum array reference\n            eff_asm_params\n\n\nsub average {\n  my ($self, $list) = @_;\n  # Sanity check\n  if ( ! ref $list || ! ref $list eq 'ARRAY') {\n    $self->throw(\"Average takes an array reference but got [\".ref($list).\"]\");\n  }\n  # New average contig spectrum object\n  my $avg = Bio::Assembly::Tools::ContigSpectrum->new;\n  $avg->{'_eff_asm_params'} = 1;\n  \n  # Cycle through contig spectra\n  my $tot_nof_rep = 0;\n  for my $csp (@$list) {\n    # Sanity check\n    if (not $csp->isa('Bio::Assembly::Tools::ContigSpectrum')) {\n      $csp->throw(\"Unable to process non Bio::Assembly::Tools::ContigSpectrum \".\n        \"object [\".ref($csp).\"]\");\n    }\n    # Import contig spectrum\n    $avg->add($csp);\n  }\n  \n  # Average sum of contig spectra by number of repetitions\n  for (my $q = 1 ; $q <= $avg->{'_max_size'} ; $q++) {\n    $avg->{'_spectrum'}{$q} /= $avg->{'_nof_rep'}\n      if (defined $avg->{'_spectrum'}{$q});\n  }\n  # Average number of sequences\n  $avg->{'_nof_seq'} /= $avg->{'_nof_rep'};\n  # Average number of overlaps\n  $avg->{'_nof_overlaps'} /= $avg->{'_nof_rep'};\n  \n  return $avg;\n}\n\n\n=head2 score\n\n  Title   : score\n  Usage   : my $score = $csp->score();\n  Function: Score a contig spectrum (or cross-contig spectrum) such that the\n             higher the number of contigs (or cross-contigs) and the larger their \n             size, the higher the score.\n             Let n   : total number of sequences\n                 c_q : number of contigs of size q\n                 q   : number of sequence in a contig\n             We define: score = n/(n-1) * (X - 1/n)\n                  where X = sum ( c_q * q^2 ) / n**2\n             The score ranges from 0 (singlets only) to 1 (a single large contig)\n             It is possible to specify a value for the number of sequences to\n              assume in the contig spectrum.\n  Returns : contig score\n  Args    : number of total sequences to assume [optional]\n\n\nsub score {\n  my ($self, $nof_seqs) = @_;\n  # Main\n  my $score = 0;\n  my $n = $self->nof_seq;\n  if ( $n > 0 ) {\n    # Contig spectrum info\n    my $q_max = $self->max_size;\n    my $spec  = $self->spectrum;\n    # Adjust number of 1-contigs\n    if ( $nof_seqs ) {\n      $spec->{'1'} += $nof_seqs - $n;\n      $n = $nof_seqs;\n    }\n    # Calculate X\n    for my $q ( 1 .. $q_max ) {\n      if ( $spec->{$q} ) {\n        my $c_q = $spec->{$q};\n        $score += $c_q * $q ** 2;\n      }\n    }\n    $score /= $n ** 2; \n  }\n  # Rescale X to obtain the score\n  $score = $n/($n-1) * ($score - 1/$n);\n  return $score;\n}\n\n\n=head2 _naive_assembler\n\n  Title   : _naive_assembler\n  Usage   : \n  Function: Determines the contig spectrum (hash representation) of a subset of\n            sequences from a mixed contig spectrum by \"reassembling\" the\n            specified sequences only based on their position in the contig. This\n            naive assembly only verifies that the minimum overlap length and\n            percentage identity are respected. There is no actual alignment done\n  Returns : contig spectrum hash reference\n  Args    : Bio::Assembly::Contig\n            sequence ID array reference\n            minimum overlap length (integer) [optional]\n            minimum percentage identity (integer) [optional]\n\n\nsub _naive_assembler {\n  my ($self, $contig, $seqlist, $min_overlap, $min_identity) = @_;\n  # Sanity checks\n  if ( ! ref $seqlist || ! ref($seqlist) eq 'ARRAY') {\n    $self->throw('Expecting an array reference. Got ['.ref($seqlist).\"] \\n\");\n  }\n  my $max = scalar @$seqlist;\n  $self->throw(\"Expecting at least 2 sequences as input for _naive_assembler\")\n    if ($max < 2);\n  # Assembly\n  my %spectrum = (1 => 0);\n  my %overlap_map;\n  my %has_overlap;\n  # Map what sequences overlap with what sequences\n  for (my $i = 0 ; $i < $max-1 ; $i++) {\n    # query sequence\n    my $qseqid = $$seqlist[$i];\n    my $qseq   = $contig->get_seq_by_name($qseqid);\n    my $is_singlet = 1;\n    for (my $j = $i+1 ; $j < $max ; $j++) {\n      # target sequence\n      my $tseqid = $$seqlist[$j];\n      my $tseq = $contig->get_seq_by_name($tseqid);\n      # try to align sequences\n      my ($aln, $overlap, $identity)\n        = $self->_overlap_alignment($contig, $qseq, $tseq, $min_overlap,\n        $min_identity);\n      # if there is no valid overlap, go to next sequence\n      next if ! defined $aln;\n      # the overlap is valid\n      $is_singlet = 0;\n      push @{$overlap_map{$qseqid}}, $tseqid;\n      $has_overlap{$tseqid} = 1;\n      $has_overlap{$qseqid} = 1;\n    }\n    # check if sequence is in previously seen overlap\n    if (exists $has_overlap{$qseqid}) {\n      $is_singlet = 0;\n    }\n    if ($is_singlet == 1) {\n      $spectrum{1}++;\n    }\n  }\n  # take care of last sequence\n  my $last_is_singlet = 1;\n  if (exists $has_overlap{$$seqlist[$max-1]}) {\n    $last_is_singlet = 0;\n  }\n  if ($last_is_singlet == 1) {\n    $spectrum{1}++;\n  }\n  # Parse overlap map\n  for my $seqid (@$seqlist) {\n    # list of sequences that should go in the contig\n    next if not exists $overlap_map{$seqid};\n    my @overlist = @{$overlap_map{$seqid}};\n    for (my $j = 0 ; $j < scalar(@overlist) ; $j++) {\n      my $otherseqid = $overlist[$j];\n      if (exists $overlap_map{$otherseqid}) {\n        push @overlist, @{$overlap_map{$otherseqid}};\n        delete $overlap_map{$otherseqid};\n      }\n    }\n    # remove duplicates from list\n    @overlist = sort @overlist;\n    for (my $j = 0 ; $j < scalar(@overlist)-1 ; $j++) {\n      if ( $overlist[$j] eq $overlist[$j+1] ) {\n        splice @overlist, $j, 1;\n        $j--;\n      }\n    }\n    # update spectrum with size of contig\n    my $qsize = scalar(@overlist) + 1;\n    if (defined $spectrum{$qsize}) {\n      $spectrum{$qsize}++;\n    } else {\n      $spectrum{$qsize} = 1;\n    }\n  }\n  return \\%spectrum;\n}\n\n\n=head2 _new_from_assembly\n\n  Title   : _new_from_assembly\n  Usage   : \n  Function: Creates a new contig spectrum object based solely on the result of \n            an assembly\n  Returns : Bio::Assembly::Tools::ContigSpectrum\n  Args    : Bio::Assembly::Scaffold\n\n\nsub _new_from_assembly {\n  # Create new contig spectrum object based purely on what we can get from the\n  # assembly object\n  my ($self, $assemblyobj) = @_;\n  my $csp = Bio::Assembly::Tools::ContigSpectrum->new();\n  # 1: Set id\n  $csp->{'_id'} = $assemblyobj->id;\n  # 2: Set overlap statistics: nof_overlaps, min_overlap, avg_overlap,\n  #  min_identity and avg_identity\n  $csp->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  if ($csp->{'_eff_asm_params'} > 0) {\n     my ($nover, $minl, $avgl, $minid, $avgid)\n       = $csp->_get_overlap_stats($assemblyobj);\n     $csp->{'_min_overlap'}  = $minl;\n     $csp->{'_min_identity'} = $minid;\n     $csp->{'_avg_overlap'}  = $avgl;\n     $csp->{'_avg_identity'} = $avgid;\n     $csp->{'_nof_overlaps'} = $nover;\n  }\n  # 3: Set sequence statistics: nof_seq and avg_seq_len\n  my ($nseq, $avgseql) = $self->_get_seq_stats($assemblyobj);\n  $csp->{'_avg_seq_len'} = $avgseql;\n  $csp->{'_nof_seq'}     = $nseq;\n  # 4: Set the spectrum: spectrum and max_size\n  for my $contigobj ($assemblyobj->all_contigs) {\n    my $size = $contigobj->num_sequences;\n    if (defined $csp->{'_spectrum'}{$size}) {\n      $csp->{'_spectrum'}{$size}++;\n    } else {\n      $csp->{'_spectrum'}{$size} = 1;\n    }\n    $csp->{'_max_size'} = $size if $size > $csp->{'_max_size'};\n  }\n  my $nof_singlets = $assemblyobj->get_nof_singlets();\n  if (defined $nof_singlets) {\n    $csp->{'_spectrum'}{1} += $nof_singlets;\n    $csp->{'_max_size'} = 1 if $nof_singlets >= 1 && $csp->{'_max_size'} < 1;\n  }\n  # 5: Set list of assembly objects used\n  push @{$csp->{'_assembly'}}, $assemblyobj;\n  # 6: Set number of repetitions\n  $csp->{'_nof_rep'} = 1;\n  return $csp;\n}\n\n\n\n=head2 _new_dissolved_csp\n\n  Title   : \n  Usage   : create a dissolved contig spectrum object\n  Function: \n  Returns : \n  Args    : \n\n\n\nsub _new_dissolved_csp {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  # Sanity checks on the mixed contig spectrum\n\n  # min_overlap and min_identity must be specified if there are some overlaps\n  # in the mixed contig\n  unless ($mixed_csp->{'_nof_overlaps'} == 0) {\n    unless ( defined $self->{'_min_overlap'} || \n      defined $mixed_csp->{'_min_overlap'} ) {\n      $self->throw(\"min_overlap must be defined in the dissolved contig spectrum\".\n        \" or mixed contig spectrum to dissolve a contig\");\n    }\n    unless ( defined $self->{'_min_identity'} ||\n      defined $mixed_csp->{'_min_identity'} ) {\n      $self->throw(\"min_identity must be defined in the dissolved contig spectrum\".\n        \" or mixed contig spectrum\");\n    }\n  }\n  \n  # there must be at least one assembly in mixed contig spectrum\n  if (!defined $mixed_csp->{'_assembly'} ||\n      scalar @{$mixed_csp->{'_assembly'}} < 1) {\n    $self->throw(\"The mixed contig spectrum must be based on at least one\n    assembly\");\n  }\n\n  # New dissolved contig spectrum object\n  my $dissolved = Bio::Assembly::Tools::ContigSpectrum->new();\n  \n  # take parent attributes if existent or mixed attributes otherwise\n  if ($self->{'_eff_asm_params'}) {\n    $dissolved->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  } else {\n    $dissolved->{'_eff_asm_params'} = $mixed_csp->{'_eff_asm_params'};\n  }\n  if ($self->{'_min_overlap'} && $self->{'_min_identity'}) {\n    ( $dissolved->{'_min_overlap'}, $dissolved->{'_min_identity'} ) = \n      ( $self->{'_min_overlap'}, $self->{'_min_identity'} );\n  } else {\n    ( $dissolved->{'_min_overlap'}, $dissolved->{'_min_identity'} ) = \n      ( $mixed_csp->{'_min_overlap'}, $mixed_csp->{'_min_identity'} );\n  }\n  \n  # Dissolve each assembly\n  for my $assembly (@{$mixed_csp->{'_assembly'}}) {\n    # Dissolve this assembly for the given sequences\n    my %asm_spectrum = (1 => 0);\n    my %good_seqs;\n    # For each contig\n    for my $contig ($assembly->all_contigs) {\n      # Get good sequences\n      my @contig_seqs;\n      for my $seq ($contig->each_seq) {\n        my $seq_id = $seq->id;\n        # get sequence origin\n        next unless $seq_id =~ m/^$seq_header\\|/;\n        # add it to hash\n        push @contig_seqs, $seq_id;\n        $good_seqs{$seq_id} = 1;\n      }\n      # Update spectrum\n      my $size = scalar @contig_seqs;\n      if ($size == 0) {\n        next;\n      } elsif ($size == 1) {\n        $asm_spectrum{1}++;\n      } elsif ($size > 1) {\n        # Reassemble good sequences\n        my $contig_spectrum = $dissolved->_naive_assembler(\n          $contig, \\@contig_seqs, $dissolved->{'_min_overlap'},\n          $dissolved->{'_min_identity'});\n        # update spectrum\n        for my $qsize (keys %$contig_spectrum) {\n          $asm_spectrum{$qsize} += $$contig_spectrum{$qsize};\n        }\n      } else {\n        $self->throw(\"The size is not valid... how could that happen?\");\n      }\n    }\n    # For each singlet\n    for my $singlet ($assembly->all_singlets) {\n      my $seq_id = $singlet->seqref->id;\n      # get sequence origin\n      next unless $seq_id =~ m/^$seq_header\\|/;\n      # add it to hash\n      $good_seqs{$seq_id} = 1;\n      # update spectrum\n      $asm_spectrum{1}++;\n    }\n    # Update spectrum\n    $dissolved->_import_spectrum(\\%asm_spectrum);\n    # Update nof_rep\n    $dissolved->{'_nof_rep'}--;\n    $dissolved->{'_nof_rep'} += $mixed_csp->{'_nof_rep'};\n\n    # Get sequence stats\n    my ($nseq, $avgseql) = $dissolved->_get_seq_stats($assembly, \\%good_seqs);\n    $dissolved->{'_avg_seq_len'} = $avgseql;\n    $dissolved->{'_nof_seq'}     = $nseq;\n  \n    # Get eff_asm_param for these sequences\n    if ($dissolved->{'_eff_asm_params'} > 0) {\n      my ($nover, $minl, $avgl, $minid, $avgid)\n        = $dissolved->_get_overlap_stats($assembly, \\%good_seqs);\n      $dissolved->{'_min_overlap'}  = $minl;\n      $dissolved->{'_min_identity'} = $minid;\n      $dissolved->{'_avg_overlap'}  = $avgl;\n      $dissolved->{'_avg_identity'} = $avgid;\n      $dissolved->{'_nof_overlaps'} = $nover;\n    }\n\n  }\n  return $dissolved;\n}\n\n\n=head2 _new_cross_csp\n\n  Title   : \n  Usage   : \n  Function: create a cross contig spectrum object\n  Returns : \n  Args    : \n\n\n\nsub _new_cross_csp {\n  my ($self, $mixed_csp) = @_;\n  # Sanity check on the mixed contig spectrum\n  # There must be at least one assembly\n  if (!defined $mixed_csp->{'_assembly'} ||\n      scalar @{$mixed_csp->{'_assembly'}} < 1) {\n    $self->throw(\"The mixed contig spectrum must be based on at least one \".\n    \"assembly.\");\n  }\n  \n  # New dissolved contig spectrum object\n  my $cross = Bio::Assembly::Tools::ContigSpectrum->new();\n  my %spectrum = (1 => 0);\n  \n  # Take parent or mixed attributes\n  if ($self->{'_eff_asm_params'}) {\n    $cross->{'_eff_asm_params'} = $self->{'_eff_asm_params'};\n  } else {\n    $cross->{'_eff_asm_params'} = $mixed_csp->{'_eff_asm_params'};\n  }\n  if ($self->{'_min_overlap'} && $self->{'_min_identity'}) {\n    ( $cross->{'_min_overlap'}, $cross->{'_min_identity'} ) = \n      ( $self->{'_min_overlap'}, $self->{'_min_identity'} );\n  } else {\n    ( $cross->{'_min_overlap'}, $cross->{'_min_identity'} ) = \n      ( $mixed_csp->{'_min_overlap'}, $mixed_csp->{'_min_identity'} );\n  }\n  \n  # Get cross contig spectrum for each assembly\n  for my $assembly (@{$mixed_csp->{'_assembly'}}) {\n    # Go through contigs and skip the pure ones\n    my %good_seqs;\n    for my $contig ($assembly->all_contigs) {\n      # Get origins\n      my @seq_origins;\n      my @seq_ids;\n      for my $seq ($contig->each_seq) {\n        # current sequence origin\n        my $seq_id = $seq->id;\n        $seq_id =~ m/^(.+)\\|/;\n        my $seq_header = $1;\n        $self->warn(\"Sequence $seq_id does not seem to have a header. Skipping\".\n          \" it...\") if not defined $seq_header;\n        $seq_header ||= '';\n        push @seq_origins, $seq_header;\n        push @seq_ids, $seq_id;\n      }\n      my $qsize = scalar(@seq_ids);\n      my @origins = sort { $a cmp $b } @seq_origins;\n      my $size = scalar(@origins);\n      for (my $i = 1 ; $i < $size ; $i++) {\n        if ($origins[$i] eq $origins[$i-1]) {\n          splice @origins, $i, 1;\n          $i--;\n          $size--;\n        }\n      }\n      # Update cross-contig number in spectrum\n      if ($size > 1) { # cross-contig detected\n        # update good sequences\n        for my $seq_id (@seq_ids) {\n          $good_seqs{$seq_id} = 1;\n        }\n        # update number of cross q-contigs in spectrum\n        if (defined $spectrum{$qsize}) {\n          $spectrum{$qsize}++;\n        } else {\n          $spectrum{$qsize} = 1;\n        }\n      }\n      # Update number of cross 1-contigs\n      if ($size > 1) { # cross-contig detected\n        for my $origin (@origins) {\n          # sequences to use\n          my @ids;\n          for (my $i = 0 ; $i < $qsize ; $i++) {\n            my $seq_origin = $seq_origins[$i];\n            my $seq_id = $seq_ids[$i];\n            push @ids, $seq_id if $seq_origin eq $origin;\n          }\n          if (scalar @ids == 1) {\n            $spectrum{1}++;\n          } elsif (scalar @ids > 1) {\n            my $contig_spectrum = $cross->_naive_assembler(\n              $contig, \\@ids, $cross->{'_min_overlap'},\n              $cross->{'_min_identity'});\n            $spectrum{1} += $$contig_spectrum{1};\n          } else {\n            $self->throw(\"The size is <= 0. How could such a thing happen?\");\n          }\n        }\n      }\n    }\n    # Get sequence stats\n    my ($nseq, $avgseql) = $cross->_get_seq_stats($assembly, \\%good_seqs);\n    $cross->{'_avg_seq_len'} = $avgseql;\n    $cross->{'_nof_seq'}     = $nseq;\n    # Get eff_asm_param for these sequences\n    if ($cross->{'_eff_asm_params'} > 0) {\n      my ($nover, $minl, $avgl, $minid, $avgid)\n        = $cross->_get_overlap_stats($assembly, \\%good_seqs);\n      $cross->{'_min_overlap'}  = $minl;\n      $cross->{'_min_identity'} = $minid;\n      $cross->{'_avg_overlap'}  = $avgl;\n      $cross->{'_avg_identity'} = $avgid;\n      $cross->{'_nof_overlaps'} = $nover;\n    }\n  }\n  \n  $cross->_import_spectrum(\\%spectrum);\n  # Update nof_rep\n  $cross->{'_nof_rep'}--;\n  $cross->{'_nof_rep'} += $mixed_csp->{'_nof_rep'};\n  \n  return $cross;\n}\n\n=head2 _import_assembly\n\n  Title   : _import_assembly\n  Usage   : $csp->_import_assembly($assemblyobj);\n  Function: Update a contig spectrum object based on an assembly object\n  Returns : 1 for success, 0 for error\n  Args    : Bio::Assembly::Scaffold assembly object\n\n\nsub _import_assembly {\n  my ($self, $assemblyobj) = @_;\n  # Sanity check\n  if( !ref $assemblyobj || ! $assemblyobj->isa('Bio::Assembly::ScaffoldI') ) {\n        $self->throw(\"Unable to process non Bio::Assembly::ScaffoldI assembly \".\n        \"object [\".ref($assemblyobj).\"]\");\n  }\n  # Create new object from assembly\n  my $csp = $self->_new_from_assembly($assemblyobj);\n  # Update current contig spectrum object with new one\n  $self->add($csp);\n  return 1;\n}\n\n\n=head2 _import_spectrum\n\n  Title   : _import_spectrum\n  Usage   : $csp->_import_spectrum({ 1 => 90 , 2 => 3 , 4 => 1 })\n  Function: update a contig spectrum object based on a contig spectrum\n            represented as a hash (key: contig size, value: number of contigs of\n            this size)\n  Returns : 1 for success, 0 for error\n  Args    : contig spectrum as a hash reference\n\n\nsub _import_spectrum {\n  my ($self, $spectrum) = @_;\n  # Sanity check\n  if( ! ref $spectrum || ! ref $spectrum eq 'HASH') {\n    $self->throw(\"Spectrum should be a hash reference, but it is [\".\n      ref($spectrum).\"]\");\n  }\n  \n  # Update the spectrum (+ nof_rep, max_size and nof_seq)\n  for my $size (keys %$spectrum) {\n    # Get the number of contigs of different size\n    if (defined $self->{'_spectrum'}{$size}) {\n      $self->{'_spectrum'}{$size} += $$spectrum{$size};\n    } else {\n      $self->{'_spectrum'}{$size} = $$spectrum{$size};\n    }\n    # Update nof_seq\n    $self->{'_nof_seq'} += $size * $$spectrum{$size};\n    # Update max_size\n    $self->{'_max_size'} = $size if $size > $self->{'_max_size'};\n  }\n  \n  # If the contig spectrum has only zero 1-contigs, max_size is zero\n  $self->{'_max_size'} = 0 if scalar keys %{$self->{'_spectrum'}} == 1 &&\n    defined $self->{'_spectrum'}{'1'} && $self->{'_spectrum'}{'1'} == 0;\n  \n  # Update nof_rep\n  $self->{'_nof_rep'}++;\n  return 1;\n}\n\n=head2 _import_dissolved_csp\n\n  Title   : _import_dissolved_csp\n  Usage   : $csp->_import_dissolved_csp($mixed_csp, $seq_header);\n  Function: Update a contig spectrum object by dissolving a mixed contig\n            spectrum based on the header of the sequences\n  Returns : 1 for success, 0 for error\n  Args    : Bio::Assembly::Tools::ContigSpectrum\n            sequence header string\n\n\nsub _import_dissolved_csp {\n  my ($self, $mixed_csp, $seq_header) = @_;\n  # Sanity check\n  if (not defined $mixed_csp || not defined $seq_header) {\n    $self->throw(\"Expecting a contig spectrum reference and sequence header as\".\n    \" arguments\");\n  }\n  # Create new object from assembly\n  my $dissolved_csp = $self->_new_dissolved_csp($mixed_csp, $seq_header);\n  # Update current contig spectrum object with new one\n  $self->add($dissolved_csp);\n  return 1;\n}\n\n\n=head2 _import_cross_csp\n\n  Title   : _import_cross_csp\n  Usage   : $csp->_import_cross_csp($mixed_csp);\n  Function: Update a contig spectrum object by calculating the cross contig\n            spectrum based on a mixed contig spectrum\n  Returns : 1 for success, 0 for error\n  Args    : Bio::Assembly::Tools::ContigSpectrum\n\n\nsub _import_cross_csp {\n  my ($self, $mixed_csp) = @_;\n  # Sanity check\n  if (not defined $mixed_csp) {\n    $self->throw(\"Expecting a contig spectrum reference as argument\");\n  }\n\n  # Create new object from assembly\n  my $cross_csp = $self->_new_cross_csp($mixed_csp);\n\n  # Update current contig spectrum object with new one\n  $self->add($cross_csp);\n\n  return 1;\n}\n\n\n=head2 _get_seq_stats\n\n  Title   : _get_seq_stats\n  Usage   : my $seqlength = $csp->_get_seq_stats($assemblyobj);\n  Function: Get sequence statistics from an assembly:\n              number of sequences, average sequence length\n  Returns : number of sequences (integer)\n            average sequence length (decimal)\n  Args    : assembly object reference\n            hash reference with the IDs of the sequences to consider [optional]\n\n\nsub _get_seq_stats {\n  my ($self, $assemblyobj, $seq_hash) = @_;\n\n  # sanity check\n  $self->throw(\"Must provide a Bio::Assembly::Scaffold object\")\n    if (!defined $assemblyobj || !$assemblyobj->isa(\"Bio::Assembly::ScaffoldI\"));\n  $self->throw(\"Expecting a hash reference. Got [\".ref($seq_hash).\"]\")\n    if (defined $seq_hash && ! ref($seq_hash) eq 'HASH');\n\n  my $avg_seq_len = 0;\n  my $nof_seq = 0;\n  for my $contigobj ($assemblyobj->all_contigs) {\n    for my $seqobj ($contigobj->each_seq) {\n      my $seq_id = $seqobj->id;\n      next if defined $seq_hash && !defined $$seq_hash{$seq_id};\n      $nof_seq++;\n      my $seq_string = $seqobj->seq;\n      $seq_string =~ s/-//g;\n      $avg_seq_len += length($seq_string);\n    }\n  }\n  for my $singletobj ($assemblyobj->all_singlets) {\n    my $seq_id = $singletobj->seqref->id;\n    next if defined $seq_hash && !defined $$seq_hash{$seq_id};\n    $nof_seq++;\n    my $seq_string = $singletobj->seqref->seq;\n    $seq_string =~ s/-//g;\n    $avg_seq_len += length($seq_string);\n  }\n  $avg_seq_len /= $nof_seq unless $nof_seq == 0;\n  return $nof_seq, $avg_seq_len;\n}\n\n\n=head2 _get_overlap_stats\n\n  Title   : _get_overlap_stats\n  Usage   : my ($minlength, $min_identity, $avglength, $avgidentity)\n              = $csp->_get_overlap_stats($assemblyobj);\n  Function: Get statistics about pairwise overlaps in contigs of an assembly\n  Returns : number of overlaps\n            minimum overlap length\n            average overlap length\n            minimum identity percent\n            average identity percent\n  Args    : assembly object reference\n            hash reference with the IDs of the sequences to consider [optional]\n\n\nsub _get_overlap_stats {\n  my ($self, $assembly_obj, $seq_hash) = @_;\n\n  # sanity check\n  $self->throw(\"Must provide a Bio::Assembly::ScaffoldI object\")\n    if (!defined $assembly_obj || !$assembly_obj->isa(\"Bio::Assembly::ScaffoldI\"));\n  $self->throw(\"Expecting a hash reference. Got [\".ref($seq_hash).\"]\")\n    if (defined $seq_hash && ! ref($seq_hash) eq 'HASH');\n  \n  my $matchdef = $self->{'_eff_asm_params'};\n  my ($min_length, $avg_length, $min_identity, $avg_identity, $nof_overlaps)\n    = (undef, 0, undef, 0, 0);\n  \n  # Look at all the contigs (and I really mean no singlets!)\n  for my $contig_obj ($assembly_obj->all_contigs) {\n    my $nof_seq = 0;\n\n    # Look at best overlap possible with previous sequences in contig\n    my @all_seq_objs = $contig_obj->each_seq;\n    # sequences should be ordered by starting position\n    for (my $i = 0 ; $i < scalar(@all_seq_objs) ; $i++) {\n      my $seq_obj    = $all_seq_objs[$i];\n      my $seq_id    = $seq_obj->id;\n      \n      # skip this sequence if not in list of wanted sequences\n      next if defined $seq_hash && !defined $$seq_hash{$seq_id};\n      $nof_seq++;\n      \n      # skip the first sequence (no other sequence to compare against)\n      next if $nof_seq <= 1;\n      \n      # what is the best previous sequence to align to?\n      my $stats = Bio::Align::PairwiseStatistics->new;\n      my $target_obj;\n      my $target_id;\n      my $best_score;\n      my $best_length;\n      my $best_identity;\n      \n      for (my $j = $i-1 ; $j >= 0 ; $j--) {\n        my $tmp_target_obj = $all_seq_objs[$j];\n        my $tmp_target_id = $tmp_target_obj->id;\n        \n        # skip this sequence if not in list of wanted sequences\n        next if defined $seq_hash && !defined $$seq_hash{$tmp_target_id};\n        \n        # find overlap with that sequence\n        my ($aln_obj, $tmp_length, $tmp_identity)\n          = $self->_overlap_alignment($contig_obj, $seq_obj, $tmp_target_obj);\n        next if ! defined $aln_obj; # there was no sequence overlap\n        my $tmp_score = $stats->score_nuc($aln_obj);\n        \n        # update score and best sequence for overlap\n        if (!defined $best_score || $best_score < $tmp_score) {\n          $best_score    = $tmp_score;\n          $best_length   = $tmp_length;\n          $best_identity = $tmp_identity;\n          $target_obj    = $tmp_target_obj;\n          $target_id     = $tmp_target_id;\n        }\n      }\n      \n      # Update our overlap statistics\n      if (defined $best_score) {\n        $avg_length += $best_length;\n        $avg_identity += $best_identity;\n        $min_length = $best_length if ! defined $min_length ||\n          $best_length < $min_length;\n        $min_identity = $best_identity if ! defined $min_identity ||\n          $best_identity < $min_identity;\n        $nof_overlaps++;\n      }\n    }\n  }\n  \n  # averaging\n  unless ($nof_overlaps == 0) {\n    $avg_length /= $nof_overlaps;\n    $avg_identity /= $nof_overlaps;\n  }\n  \n  return $nof_overlaps, $min_length, $avg_length, $min_identity, $avg_identity;\n}\n\n\n=head2 _overlap_alignment\n\n  Title   : _overlap_alignment\n  Usage   : \n  Function: Produce an alignment of the overlapping section of two sequences of\n            a contig. Minimum overlap length and percentage identity can be\n            specified. Return undef if the sequences do not overlap or do not\n            meet the minimum overlap criteria. \n  Return  : Bio::SimpleAlign object reference\n            alignment overlap length\n            alignment overlap identity\n  Args    : Bio::Assembly::Contig object reference\n            Bio::LocatableSeq contig sequence 1\n            Bio::LocatableSeq contig sequence 2\n            minium overlap length [optional]\n            minimum overlap percentage identity [optional]"},"detail":"($self,$contig,$qseq,$tseq,$min_overlap,$min_identity)"},{"containerName":"SimpleAlign","name":"Bio","line":1582,"kind":12},{"name":"Bio","containerName":"LocatableSeq","kind":12,"line":1583},{"containerName":"LocatableSeq","name":"Bio","kind":12,"line":1590}],"version":5}