{"vars":[{"kind":2,"line":90,"name":"base","containerName":""},{"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Singlet.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Singlet\n# \n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics1 at dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Singlet - Perl module to hold and manipulate\n                     singlets from sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new( -file   => 'test.ace.1',\n                                   -format => 'phrap'      );\n\n    $assembly = $aio->next_assembly;\n    foreach $singlet ($assembly->all_singlets) {\n      # do something\n    }\n\n    # OR, if you want to build the singlet yourself,\n\n    use Bio::Assembly::Singlet;\n    $singlet = Bio::Assembly::Singlet->new( -seqref => $seq );\n\n=head1 DESCRIPTION\n\nA singlet is a sequence that phrap was unable to align to any other sequences.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad S. Matsalla\n\nbioinformatics1 at dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Singlet;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\nuse base qw(Bio::Assembly::Contig Bio::Root::Root Bio::Align::AlignI);\n\n=head2 new\n\n    Title   : new\n    Usage   : $singlet = $io->new( -seqref => $seq )\n    Function: Create a new singlet object\n    Returns : A Bio::Assembly::Singlet object\n    Args    : -seqref => Bio::Seq-compliant sequence object for the singlet"},"kind":12,"line":102,"children":[{"line":103,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"line":103,"kind":13,"containerName":"new","name":"@args"},{"name":"$self","definition":"my","containerName":"new","localvar":"my","kind":13,"line":104},{"name":"$class","containerName":"new","kind":13,"line":104},{"kind":13,"line":104,"containerName":"new","name":"@args"},{"line":105,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$seqref"},{"kind":13,"line":105,"name":"$self","containerName":"new"},{"name":"_rearrange","containerName":"new","kind":12,"line":105},{"name":"@args","containerName":"new","line":105,"kind":13},{"containerName":"new","name":"$self","line":106,"kind":13},{"name":"$seqref","containerName":"new","line":107,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":108},{"line":108,"kind":12,"name":"seqref","containerName":"new"},{"containerName":"new","name":"$seqref","line":108,"kind":13},{"kind":13,"line":110,"containerName":"new","name":"$self"}],"name":"new","range":{"end":{"character":9999,"line":111},"start":{"line":102,"character":0}}},{"line":104,"kind":12,"name":"SUPER","containerName":"new"},{"name":"seqref","range":{"start":{"line":123,"character":0},"end":{"line":127,"character":9999}},"kind":12,"line":123,"children":[{"localvar":"my","containerName":"seqref","name":"$self","definition":"my","line":124,"kind":13},{"name":"$seq","containerName":"seqref","line":124,"kind":13},{"kind":13,"line":125,"containerName":"seqref","name":"$seq"},{"line":125,"kind":13,"name":"$self","containerName":"seqref"},{"line":125,"kind":12,"containerName":"seqref","name":"_seq_to_singlet"},{"name":"$seq","containerName":"seqref","line":125,"kind":13},{"line":126,"kind":13,"containerName":"seqref","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,$seq)","signature":{"documentation":"1;\n# $Id: Singlet.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Singlet\n# \n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics1 at dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Singlet - Perl module to hold and manipulate\n                     singlets from sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new( -file   => 'test.ace.1',\n                                   -format => 'phrap'      );\n\n    $assembly = $aio->next_assembly;\n    foreach $singlet ($assembly->all_singlets) {\n      # do something\n    }\n\n    # OR, if you want to build the singlet yourself,\n\n    use Bio::Assembly::Singlet;\n    $singlet = Bio::Assembly::Singlet->new( -seqref => $seq );\n\n=head1 DESCRIPTION\n\nA singlet is a sequence that phrap was unable to align to any other sequences.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad S. Matsalla\n\nbioinformatics1 at dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Singlet;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\nuse base qw(Bio::Assembly::Contig Bio::Root::Root Bio::Align::AlignI);\n\n=head2 new\n\n    Title   : new\n    Usage   : $singlet = $io->new( -seqref => $seq )\n    Function: Create a new singlet object\n    Returns : A Bio::Assembly::Singlet object\n    Args    : -seqref => Bio::Seq-compliant sequence object for the singlet\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($seqref) = $self->_rearrange([qw(SEQREF)], @args);\n    $self->{'_seqref'} = undef;\n    if (defined $seqref) {\n        $self->seqref($seqref);   \n    }\n    return $self;\n}\n\n=head2 seqref\n\n    Title   : seqref\n    Usage   : $seqref = $singlet->seqref($seq);\n    Function: Get/set the sequence to which this singlet refers\n    Returns : A Bio::Seq-compliant object\n    Args    : A Bio::Seq-compliant object","parameters":[{"label":"$self"},{"label":"$seq"}],"label":"seqref($self,$seq)"}},{"range":{"start":{"line":139,"character":0},"end":{"line":166,"character":9999}},"name":"_seq_to_singlet","signature":{"label":"_seq_to_singlet($self,$seq)","documentation":"1;\n# $Id: Singlet.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Singlet\n# \n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla <bioinformatics1 at dieselwurks.com>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Singlet - Perl module to hold and manipulate\n                     singlets from sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new( -file   => 'test.ace.1',\n                                   -format => 'phrap'      );\n\n    $assembly = $aio->next_assembly;\n    foreach $singlet ($assembly->all_singlets) {\n      # do something\n    }\n\n    # OR, if you want to build the singlet yourself,\n\n    use Bio::Assembly::Singlet;\n    $singlet = Bio::Assembly::Singlet->new( -seqref => $seq );\n\n=head1 DESCRIPTION\n\nA singlet is a sequence that phrap was unable to align to any other sequences.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad S. Matsalla\n\nbioinformatics1 at dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Singlet;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\nuse base qw(Bio::Assembly::Contig Bio::Root::Root Bio::Align::AlignI);\n\n=head2 new\n\n    Title   : new\n    Usage   : $singlet = $io->new( -seqref => $seq )\n    Function: Create a new singlet object\n    Returns : A Bio::Assembly::Singlet object\n    Args    : -seqref => Bio::Seq-compliant sequence object for the singlet\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($seqref) = $self->_rearrange([qw(SEQREF)], @args);\n    $self->{'_seqref'} = undef;\n    if (defined $seqref) {\n        $self->seqref($seqref);   \n    }\n    return $self;\n}\n\n=head2 seqref\n\n    Title   : seqref\n    Usage   : $seqref = $singlet->seqref($seq);\n    Function: Get/set the sequence to which this singlet refers\n    Returns : A Bio::Seq-compliant object\n    Args    : A Bio::Seq-compliant object\n\n\nsub seqref {\n    my ($self,$seq) = @_;\n    if (defined $seq) { $self->_seq_to_singlet($seq) };\n    return $self->{'_seqref'};\n}\n\n=head2 _seq_to_singlet\n\n    Title   : _seq_to_singlet\n    Usage   : $singlet->seqref($seq)\n    Function: Transform a sequence into a singlet\n    Returns : A Bio::Assembly::Singlet object\n    Args    : A Bio::Seq-compliant object","parameters":[{"label":"$self"},{"label":"$seq"}]},"detail":"($self,$seq)","definition":"sub","containerName":"main::","children":[{"line":140,"kind":13,"localvar":"my","containerName":"_seq_to_singlet","name":"$self","definition":"my"},{"containerName":"_seq_to_singlet","name":"$seq","kind":13,"line":140},{"name":"$self","containerName":"_seq_to_singlet","line":142,"kind":13},{"kind":12,"line":142,"containerName":"_seq_to_singlet","name":"throw"},{"line":142,"kind":13,"containerName":"_seq_to_singlet","name":"$seq"},{"line":143,"kind":13,"name":"$seq","containerName":"_seq_to_singlet"},{"containerName":"_seq_to_singlet","name":"$seq","line":143,"kind":13},{"name":"isa","containerName":"_seq_to_singlet","kind":12,"line":143},{"containerName":"_seq_to_singlet","name":"$seq","line":143,"kind":13},{"containerName":"_seq_to_singlet","name":"isa","kind":12,"line":143},{"name":"$self","containerName":"_seq_to_singlet","line":145,"kind":13},{"line":145,"kind":12,"containerName":"_seq_to_singlet","name":"throw"},{"line":146,"kind":13,"name":"$self","containerName":"_seq_to_singlet"},{"line":148,"kind":13,"localvar":"my","containerName":"_seq_to_singlet","name":"$seq_id","definition":"my"},{"line":148,"kind":13,"name":"$seq","containerName":"_seq_to_singlet"},{"line":148,"kind":12,"name":"id","containerName":"_seq_to_singlet"},{"kind":13,"line":149,"definition":"my","name":"$lseq","containerName":"_seq_to_singlet","localvar":"my"},{"containerName":"_seq_to_singlet","name":"new","kind":12,"line":149},{"kind":13,"line":150,"name":"$seq","containerName":"_seq_to_singlet"},{"name":"seq","containerName":"_seq_to_singlet","line":150,"kind":12},{"kind":13,"line":152,"name":"$seq","containerName":"_seq_to_singlet"},{"line":152,"kind":12,"name":"length","containerName":"_seq_to_singlet"},{"kind":13,"line":155,"containerName":"_seq_to_singlet","name":"$seq_id"},{"line":157,"kind":13,"name":"$self","containerName":"_seq_to_singlet"},{"name":"add_seq","containerName":"_seq_to_singlet","line":157,"kind":12},{"containerName":"_seq_to_singlet","name":"$lseq","kind":13,"line":157},{"containerName":"_seq_to_singlet","name":"$self","kind":13,"line":159},{"name":"id","containerName":"_seq_to_singlet","line":159,"kind":12},{"containerName":"_seq_to_singlet","name":"$seq_id","line":159,"kind":13},{"name":"$self","containerName":"_seq_to_singlet","kind":13,"line":160},{"containerName":"_seq_to_singlet","name":"$seq","line":160,"kind":13},{"name":"$self","containerName":"_seq_to_singlet","line":161,"kind":13},{"containerName":"_seq_to_singlet","name":"set_consensus_sequence","line":161,"kind":12},{"kind":13,"line":161,"containerName":"_seq_to_singlet","name":"$lseq"},{"line":162,"kind":13,"name":"$seq","containerName":"_seq_to_singlet"},{"name":"isa","containerName":"_seq_to_singlet","line":162,"kind":12},{"containerName":"_seq_to_singlet","name":"$self","kind":13,"line":163},{"kind":12,"line":163,"containerName":"_seq_to_singlet","name":"set_consensus_quality"},{"name":"$seq","containerName":"_seq_to_singlet","kind":13,"line":163}],"line":139,"kind":12},{"line":149,"kind":12,"name":"Bio","containerName":"LocatableSeq"}],"version":5}