{"vars":[{"kind":2,"line":238,"name":"base","containerName":""},{"kind":13,"line":240,"containerName":null,"definition":"my","name":"$progname","localvar":"my"},{"name":"next_assembly","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":252},"end":{"line":391,"character":9999}},"kind":12,"children":[{"kind":13,"line":253,"containerName":"next_assembly","definition":"my","name":"$self","localvar":"my"},{"line":256,"kind":13,"localvar":"my","name":"$scaffoldobj","definition":"my","containerName":"next_assembly"},{"containerName":"next_assembly","name":"new","kind":12,"line":256},{"containerName":"next_assembly","name":"$progname","kind":13,"line":256},{"localvar":"my","containerName":"next_assembly","definition":"my","name":"$contigobj","line":259,"kind":13},{"localvar":"my","definition":"my","name":"$iscontig","containerName":"next_assembly","line":260,"kind":13},{"localvar":"my","containerName":"next_assembly","name":"%contiginfo","definition":"my","line":261,"kind":13},{"kind":13,"line":262,"name":"$isread","definition":"my","containerName":"next_assembly","localvar":"my"},{"line":263,"kind":13,"localvar":"my","containerName":"next_assembly","name":"%readinfo","definition":"my"},{"kind":13,"line":266,"name":"$self","containerName":"next_assembly"},{"line":266,"kind":12,"containerName":"next_assembly","name":"_readline"},{"line":270,"kind":13,"containerName":"next_assembly","name":"$iscontig"},{"containerName":"next_assembly","name":"$isread","kind":13,"line":271},{"name":"$contiginfo","containerName":"next_assembly","kind":13,"line":273},{"localvar":"my","containerName":"next_assembly","definition":"my","name":"$readobj","line":275,"kind":13},{"line":275,"kind":13,"containerName":"next_assembly","name":"$self"},{"containerName":"next_assembly","name":"_store_read","line":275,"kind":12},{"containerName":"next_assembly","name":"%readinfo","kind":13,"line":275},{"containerName":"next_assembly","name":"$contigobj","line":275,"kind":13},{"containerName":"next_assembly","name":"$contiginfo","kind":13,"line":276},{"kind":13,"line":278,"containerName":"next_assembly","name":"$singletobj","definition":"my","localvar":"my"},{"line":278,"kind":13,"containerName":"next_assembly","name":"$self"},{"name":"_store_singlet","containerName":"next_assembly","line":278,"kind":12},{"name":"%readinfo","containerName":"next_assembly","line":278,"kind":13},{"line":278,"kind":13,"containerName":"next_assembly","name":"%contiginfo"},{"containerName":"next_assembly","name":"$scaffoldobj","line":279,"kind":13},{"containerName":"next_assembly","name":"$self","line":282,"kind":13},{"containerName":"next_assembly","name":"throw","line":282,"kind":12},{"line":285,"kind":13,"containerName":"next_assembly","name":"%readinfo"},{"containerName":"next_assembly","name":"$contigobj","line":287,"kind":13},{"kind":13,"line":288,"containerName":"next_assembly","name":"%contiginfo"},{"containerName":"next_assembly","name":"$iscontig","kind":13,"line":290},{"kind":13,"line":292,"name":"$iscontig","containerName":"next_assembly"},{"kind":13,"line":293,"containerName":"next_assembly","name":"$isread"},{"kind":13,"line":295,"name":"$contigobj","containerName":"next_assembly"},{"line":295,"kind":13,"containerName":"next_assembly","name":"$self"},{"line":295,"kind":12,"containerName":"next_assembly","name":"_store_contig"},{"name":"%contiginfo","containerName":"next_assembly","kind":13,"line":295},{"name":"$contigobj","containerName":"next_assembly","kind":13,"line":295},{"line":296,"kind":13,"name":"$scaffoldobj","containerName":"next_assembly"},{"name":"$contiginfo","containerName":"next_assembly","line":296,"kind":13},{"kind":13,"line":297,"containerName":"next_assembly","name":"$isread"},{"containerName":"next_assembly","name":"$iscontig","line":300,"kind":13},{"name":"$isread","containerName":"next_assembly","line":301,"kind":13},{"containerName":"next_assembly","name":"$contiginfo","kind":13,"line":303},{"line":305,"kind":13,"localvar":"my","definition":"my","name":"$readobj","containerName":"next_assembly"},{"containerName":"next_assembly","name":"$self","kind":13,"line":305},{"line":305,"kind":12,"name":"_store_read","containerName":"next_assembly"},{"kind":13,"line":305,"name":"%readinfo","containerName":"next_assembly"},{"line":305,"kind":13,"name":"$contigobj","containerName":"next_assembly"},{"name":"$contiginfo","containerName":"next_assembly","line":306,"kind":13},{"localvar":"my","name":"$singletobj","definition":"my","containerName":"next_assembly","line":308,"kind":13},{"line":308,"kind":13,"name":"$self","containerName":"next_assembly"},{"name":"_store_singlet","containerName":"next_assembly","line":308,"kind":12},{"kind":13,"line":308,"name":"%readinfo","containerName":"next_assembly"},{"containerName":"next_assembly","name":"%contiginfo","kind":13,"line":309},{"name":"$scaffoldobj","containerName":"next_assembly","line":309,"kind":13},{"kind":13,"line":312,"name":"$self","containerName":"next_assembly"},{"line":312,"kind":12,"containerName":"next_assembly","name":"throw"},{"kind":13,"line":315,"name":"%readinfo","containerName":"next_assembly"},{"kind":13,"line":318,"containerName":"next_assembly","name":"$self"},{"containerName":"next_assembly","name":"throw","kind":12,"line":318},{"name":"$iscontig","containerName":"next_assembly","line":321,"kind":13},{"kind":13,"line":323,"containerName":"next_assembly","name":"$contiginfo"},{"line":324,"kind":13,"name":"$contiginfo","containerName":"next_assembly"},{"name":"$contiginfo","containerName":"next_assembly","kind":13,"line":325},{"name":"$contiginfo","containerName":"next_assembly","line":326,"kind":13},{"name":"$contiginfo","containerName":"next_assembly","line":327,"kind":13},{"kind":13,"line":328,"containerName":"next_assembly","name":"$contiginfo"},{"containerName":"next_assembly","name":"$contiginfo","line":329,"kind":13},{"containerName":"next_assembly","name":"$contiginfo","line":330,"kind":13},{"containerName":"next_assembly","name":"$contiginfo","line":331,"kind":13},{"containerName":"next_assembly","name":"$contiginfo","line":332,"kind":13},{"kind":13,"line":333,"name":"$contiginfo","containerName":"next_assembly"},{"containerName":"next_assembly","name":"$contiginfo","kind":13,"line":334},{"name":"$contiginfo","containerName":"next_assembly","kind":13,"line":335},{"name":"$contiginfo","containerName":"next_assembly","line":336,"kind":13},{"name":"$contiginfo","containerName":"next_assembly","line":337,"kind":13},{"kind":13,"line":338,"containerName":"next_assembly","name":"$contiginfo"},{"containerName":"next_assembly","name":"$contiginfo","line":339,"kind":13},{"containerName":"next_assembly","name":"$contiginfo","line":340,"kind":13},{"name":"$contiginfo","containerName":"next_assembly","kind":13,"line":341},{"kind":13,"line":343,"name":"$self","containerName":"next_assembly"},{"kind":12,"line":343,"name":"throw","containerName":"next_assembly"},{"containerName":"next_assembly","name":"$isread","line":346,"kind":13},{"kind":13,"line":348,"containerName":"next_assembly","name":"$readinfo"},{"line":349,"kind":13,"name":"$readinfo","containerName":"next_assembly"},{"name":"$readinfo","containerName":"next_assembly","line":350,"kind":13},{"name":"$readinfo","containerName":"next_assembly","kind":13,"line":351},{"containerName":"next_assembly","name":"$readinfo","line":352,"kind":13},{"kind":13,"line":353,"containerName":"next_assembly","name":"$readinfo"},{"name":"$readinfo","containerName":"next_assembly","kind":13,"line":354},{"kind":13,"line":355,"name":"$readinfo","containerName":"next_assembly"},{"kind":13,"line":356,"containerName":"next_assembly","name":"$readinfo"},{"name":"$readinfo","containerName":"next_assembly","kind":13,"line":357},{"kind":13,"line":359,"name":"$self","containerName":"next_assembly"},{"kind":12,"line":359,"containerName":"next_assembly","name":"throw"},{"containerName":"next_assembly","name":"$self","kind":13,"line":364},{"kind":12,"line":364,"name":"throw","containerName":"next_assembly"},{"name":"$contiginfo","containerName":"next_assembly","line":369,"kind":13},{"name":"$contiginfo","containerName":"next_assembly","kind":13,"line":370},{"localvar":"my","containerName":"next_assembly","name":"$readobj","definition":"my","line":372,"kind":13},{"name":"$self","containerName":"next_assembly","line":372,"kind":13},{"line":372,"kind":12,"containerName":"next_assembly","name":"_store_read"},{"containerName":"next_assembly","name":"%readinfo","line":372,"kind":13},{"line":372,"kind":13,"name":"$contigobj","containerName":"next_assembly"},{"name":"$contiginfo","containerName":"next_assembly","kind":13,"line":373},{"name":"$singletobj","definition":"my","containerName":"next_assembly","localvar":"my","kind":13,"line":375},{"name":"$self","containerName":"next_assembly","line":375,"kind":13},{"line":375,"kind":12,"name":"_store_singlet","containerName":"next_assembly"},{"name":"%readinfo","containerName":"next_assembly","line":375,"kind":13},{"kind":13,"line":375,"name":"%contiginfo","containerName":"next_assembly"},{"name":"$scaffoldobj","containerName":"next_assembly","kind":13,"line":376},{"containerName":"next_assembly","name":"$self","line":379,"kind":13},{"name":"throw","containerName":"next_assembly","line":379,"kind":12},{"containerName":"next_assembly","name":"%readinfo","line":383,"kind":13},{"containerName":"next_assembly","name":"$contigobj","line":385,"kind":13},{"name":"%contiginfo","containerName":"next_assembly","line":386,"kind":13},{"containerName":"next_assembly","name":"$scaffoldobj","kind":13,"line":388},{"line":388,"kind":12,"name":"update_seq_list","containerName":"next_assembly"},{"line":390,"kind":13,"containerName":"next_assembly","name":"$scaffoldobj"}],"line":252},{"containerName":"Assembly::Scaffold","name":"Bio","kind":12,"line":256},{"detail":"($self,$qual)","signature":{"documentation":"__END__\n# $Id: tigr.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO::tigr\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO::tigr - Driver to read and write assembly files in the TIGR\nAssembler v2 default format.\n\n=head1 SYNOPSIS\n\n    # Building an input stream\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $asmio = Bio::Assembly::IO->new( -file   => 'SGC0-424.tasm',\n                                        -format => 'tigr' );\n    my $scaffold = $asmio->next_assembly;\n\n    # Do some things on contigs...\n\n    # Assembly writing methods\n    my $outasm = Bio::Assembly::IO->new( -file   => \">SGC0-modified.tasm\",\n                                         -format => 'tigr' );\n    $outasm->write_assembly( -scaffold => $assembly,\n                             -singlets => 1 );\n\n=head1 DESCRIPTION\n\nThis package loads and writes assembly information in/from files in the default\nTIGR Assembler v2 format. The files are lassie-formatted and often have the\n.tasm extension. This module was written to be used as a driver module for\nBio::Assembly::IO input/output.\n\n=head2 Implementation\n\nAssemblies are loaded into Bio::Assembly::Scaffold objects composed of\nBio::Assembly::Contig and Bio::Assembly::Singlet objects. Since aligned reads\nand contig gapped consensus can be obtained in the tasm files, only\naligned/gapped sequences are added to the different BioPerl objects.\n\nAdditional assembly information is stored as features. Contig objects have\nSeqFeature information associated with the primary_tag:\n\n    _main_contig_feature:$contig_id -> misc contig information\n    _quality_clipping:$read_id      -> quality clipping position\n\nRead objects have sub_seqFeature information associated with the\nprimary_tag:\n\n    _main_read_feature:$read_id     -> misc read information\n\nSinglets are considered by TIGR Assembler as contigs of one sequence and are\nrepresented here with features having these primary_tag: \n\n    _main_contig_feature:$contig_id\n    _quality_clipping:$read_primary_id\n    _main_read_feature:$read_primary_id\n    _aligned_coord:$read_primary_id\n\n=head1 THE TIGR TASM LASSIEFORMAT\n\n=head2 Description\n\nIn the TIGR tasm lassie format, contigs are separated by a line containing a single\npipe character \"|\", whereas the reads in a contig are separated by a blank line.\nSinglets can be present in the file and are represented as a contig\ncomposed of a single sequence.\n\nOther than the two above-mentioned separators, each line has an attribute name,\nfollowed a tab and then an attribute value.\n\nThe tasm format is used by more TIGR applications than just TIGR Assembler.\nSome of the attributes are not used by TIGR Assembler or have constant values.\nThey are indicated by an asterisk *\n\nContigs have the following attributes:\n\n    asmbl_id   -> contig ID\n    sequence   -> contig ungapped consensus sequence (ambiguities are lowercase)\n    lsequence  -> gapped consensus sequence (lowercase ambiguities)\n    quality    -> gapped consensus quality score (in hexadecimal)\n    seq_id     -> *\n    com_name   -> *\n    type       -> *\n    method     -> always 'asmg' *\n    ed_status  -> *\n    redundancy -> fold coverage of the contig consensus\n    perc_N     -> percent of ambiguities in the contig consensus\n    seq#       -> number of sequences in the contig\n    full_cds   -> *\n    cds_start  -> start of coding sequence *\n    cds_end    -> end of coding sequence *\n    ed_pn      -> name of editor (always 'GRA') *\n    ed_date    -> date and time of edition\n    comment    -> some comments *\n    frameshift -> *\n\nEach read has the following attributes:\n\n    seq_name  -> read name\n    asm_lend  -> position of first base on contig ungapped consensus sequence\n    asm_rend  -> position of last base on contig ungapped consensus sequence\n    seq_lend  -> start of quality-trimmed sequence (aligned read coordinates)\n    seq_rend  -> end of quality-trimmed sequence (aligned read coordinates)\n    best      -> always '0' *\n    comment   -> some comments *\n    db        -> database name associated with the sequence (e.g. >my_db|seq1234)\n    offset    -> offset of the sequence (gapped consensus coordinates)\n    lsequence -> aligned read sequence (ambiguities are uppercase)\n\nWhen asm_rend E<lt> asm_lend, the sequence was on the complementary DNA strand but\nits reverse complement is shown in the aligned sequence of the assembly file,\nnot the original read.\n\nAmbiguities are reflected in the contig consensus sequence as\nlowercase IUPAC characters: a c g t u m r w s y k x n . In the read\nsequences, however, ambiguities are uppercase: M R W S Y K X N\n\n=head2 Example\n\nExample of a contig containing three sequences:\n\n    sequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCGCAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    quality\t0x0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0505050505050505050E0505160505050505050505050505050505050505050505050505050505050303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0404040404040404041604040404040404040404040404040404040404040404040404040404040404040404040404040404040E0404040404040404040B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B\n    asmbl_id\t93\n    seq_id\t\n    com_name\t\n    type\t\n    method\tasmg\n    ed_status\t\n    redundancy\t1.11\n    perc_N\t0.20\n    seq#\t3\n    full_cds\t\n    cds_start\t\n    cds_end\t\n    ed_pn\tGRA\n    ed_date\t08/16/07 17:10:12\n    comment\t\n    frameshift\t\n\n    seq_name\tSDSU_RFPERU_010_C09.x01.phd.1\n    asm_lend\t1\n    asm_rend\t4423\n    seq_lend\t1\n    seq_rend\t442\n    best\t0\n    comment\t\n    db\t\n    offset\t0\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAGCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGG\n\n    seq_name\tSDSU_RFPERU_002_H12.x01.phd.1\n    asm_lend\t339\n    asm_rend\t940\n    seq_lend\t1\n    seq_rend\t602\n    best\t0\n    comment\t\n    db\t\n    offset\t338\n    lsequence\tCGAGATTCGCCACCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCCGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATA-GCGTGGCGC\n\n    seq_name\tSDSU_RFPERU_009_E07.x01.phd.1\n    asm_lend\t880\n    asm_rend\t1520\n    seq_lend\t641\n    seq_rend\t1\n    best\t0\n    comment\t\n    db\t\n    offset\t8803\n    lsequence\tCGCACGGTCTGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAAGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    |\n\n...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent dot angly at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::IO::tigr;\n\nuse strict;\nuse Bio::Seq::Quality;\nuse Bio::LocatableSeq;\nuse Bio::Assembly::IO;\nuse Bio::Assembly::Scaffold;\nuse Bio::Assembly::Contig;\nuse Bio::Assembly::Singlet;\n\nuse base qw(Bio::Assembly::IO);\n\nmy $progname = 'TIGR Assembler';\n\n=head2 next_assembly\n\n Title   : next_assembly\n Usage   : my $scaffold = $asmio->next_assembly()\n Function: return the next assembly in the tasm-formatted stream\n Returns : Bio::Assembly::Scaffold object\n Args    : none\n\n\nsub next_assembly {\n    my $self = shift; # object reference\n    \n    # Create a new scaffold to hold the contigs\n    my $scaffoldobj = Bio::Assembly::Scaffold->new(-source => $progname);\n    \n    # Contig and read related\n    my $contigobj;\n    my $iscontig = 1;\n    my %contiginfo;\n    my $isread = 0;\n    my %readinfo;\n    \n    # Loop over all assembly file lines\n    while ($_ = $self->_readline) {\n        chomp;\n        if ( /^\\|/ ) {  # a line with a single pipe |\n            # The end of a read from a contig, the start of a new contig\n            $iscontig = 1;\n            $isread   = 0;\n            # Store read info\n            if ($contiginfo{'seqnum'} > 1) {\n                # This is a read in a contig\n                my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n            } elsif ($contiginfo{'seqnum'} == 1) {\n                # This is a singlet\n                my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                    $scaffoldobj);\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n            # Clear read info\n            undef %readinfo;\n            # Clear contig info\n            undef $contigobj;\n            undef %contiginfo;\n        } elsif ( /^$/ ) {  # a blank line\n            if ($iscontig) {\n                # The end of a contig, the start of a read in that contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store contig info\n                $contigobj = $self->_store_contig( \\%contiginfo, $contigobj,\n                    $scaffoldobj ) if $contiginfo{'seqnum'} > 1;\n            } elsif ($isread) {\n                # The end of read in a contig, the start of a new one in\n                # the same contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store read info\n                if ($contiginfo{'seqnum'} > 1) {\n                    # This is a read in a contig\n                    my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n                } elsif ($contiginfo{'seqnum'} == 1) {\n                    # This is a singlet\n                    my $singletobj = $self->_store_singlet(\\%readinfo,\n                        \\%contiginfo, $scaffoldobj);\n                } else {\n                  # That should not happen\n                  $self->throw(\"Unhandled exception\");\n                }\n                # Clear read info\n                undef %readinfo;\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n        } else {\n            if ($iscontig) {\n                # Parse contig\n                if    (/^sequence\\t(.*)/)     {$contiginfo{'sequence'}   = $1; next}\n                elsif (/^lsequence\\t(.*)/)    {$contiginfo{'lsequence'}  = $1; next}\n                elsif (/^quality\\t(.*)/)      {$contiginfo{'quality'}    = $1; next}\n                elsif (/^asmbl_id\\t(.*)/)     {$contiginfo{'asmbl_id'}   = $1; next}\n                elsif (/^seq_id\\t(.*)/)       {$contiginfo{'seq_id'}     = $1; next}\n                elsif (/^com_name\\t(.*)/)     {$contiginfo{'com_name'}   = $1; next}\n                elsif (/^type\\t(.*)/)         {$contiginfo{'type'}       = $1; next}\n                elsif (/^method\\t(.*)/)       {$contiginfo{'method'}     = $1; next}\n                elsif (/^ed_status\\t(.*)/)    {$contiginfo{'ed_status'}  = $1; next}\n                elsif (/^redundancy\\t(.*)/)   {$contiginfo{'redundancy'} = $1; next}\n                elsif (/^perc_N\\t(.*)/)       {$contiginfo{'perc_N'}     = $1; next}\n                elsif (/^seq\\#\\t(.*)/)        {$contiginfo{'seqnum'}     = $1; next}\n                elsif (/^full_cds\\t(.*)/)     {$contiginfo{'full_cds'}   = $1; next}\n                elsif (/^cds_start\\t(.*)/)    {$contiginfo{'cds_start'}  = $1; next}\n                elsif (/^cds_end\\t(.*)/)      {$contiginfo{'cds_end'}    = $1; next}\n                elsif (/^ed_pn\\t(.*)/)        {$contiginfo{'ed_pn'}      = $1; next}\n                elsif (/^ed_date\\t(.*\\s.*)/)  {$contiginfo{'ed_date'}    = $1; next}\n                elsif (/^comment\\t(.*)/)      {$contiginfo{'comment'}    = $1; next}\n                elsif (/^frameshift\\t(.*)/)   {$contiginfo{'frameshift'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } elsif ($isread) {\n                # Parse read info\n                if    (/^seq_name\\t(.*)/)  {$readinfo{'seq_name'}  = $1; next}\n                elsif (/^asm_lend\\t(.*)/)  {$readinfo{'asm_lend'}  = $1; next}\n                elsif (/^asm_rend\\t(.*)/)  {$readinfo{'asm_rend'}  = $1; next}\n                elsif (/^seq_lend\\t(.*)/)  {$readinfo{'seq_lend'}  = $1; next}\n                elsif (/^seq_rend\\t(.*)/)  {$readinfo{'seq_rend'}  = $1; next}\n                elsif (/^best\\t(.*)/)      {$readinfo{'best'}      = $1; next}\n                elsif (/^comment\\t(.*)/)   {$readinfo{'comment'}   = $1; next}\n                elsif (/^db\\t(.*)/)        {$readinfo{'db'}        = $1; next}\n                elsif (/^offset\\t(.*)/)    {$readinfo{'offset'}    = $1; next}\n                elsif (/^lsequence\\t(.*)/) {$readinfo{'lsequence'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } else {\n                # That shouldn't happen\n                $self->throw(\"Unhandled exception\");                \n            }\n        }\n    }\n    # Store read info for last read\n    if (defined $contiginfo{'seqnum'}) {\n        if ($contiginfo{'seqnum'} > 1) {\n            # This is a read in a contig\n            my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n        } elsif ($contiginfo{'seqnum'} == 1) {\n            # This is a singlet\n            my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                $scaffoldobj);\n        } else {\n            # That should not happen\n            $self->throw(\"Unhandled exception\");\n        }\n    }\n    # Clear read info for last read\n    undef %readinfo;\n    # Clear contig info for last contig\n    undef $contigobj;\n    undef %contiginfo;\n    \n    $scaffoldobj->update_seq_list();\n    \n    return $scaffoldobj;\n}\n\n=head2 _qual_hex2dec\n\n    Title   : _qual_hex2dec\n    Usage   : my dec_quality = $self->_qual_hex2dec($hex_quality);\n    Function: convert an hexadecimal quality score into a decimal quality score \n    Returns : string\n    Args    : string","parameters":[{"label":"$self"},{"label":"$qual"}],"label":"_qual_hex2dec($self,$qual)"},"containerName":"main::","definition":"sub","line":403,"children":[{"line":404,"kind":13,"localvar":"my","containerName":"_qual_hex2dec","definition":"my","name":"$self"},{"line":404,"kind":13,"name":"$qual","containerName":"_qual_hex2dec"},{"kind":13,"line":405,"name":"$qual","containerName":"_qual_hex2dec"},{"kind":13,"line":406,"name":"$qual","containerName":"_qual_hex2dec"},{"containerName":"_qual_hex2dec","name":"$qual","line":407,"kind":13}],"kind":12,"range":{"end":{"line":408,"character":9999},"start":{"line":403,"character":0}},"name":"_qual_hex2dec"},{"range":{"start":{"character":0,"line":420},"end":{"character":9999,"line":425}},"name":"_qual_dec2hex","line":420,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_qual_dec2hex","line":421,"kind":13},{"containerName":"_qual_dec2hex","name":"$qual","kind":13,"line":421},{"name":"$qual","containerName":"_qual_dec2hex","line":422,"kind":13},{"containerName":"_qual_dec2hex","name":"$qual","line":423,"kind":13},{"containerName":"_qual_dec2hex","name":"$qual","kind":13,"line":423},{"name":"$qual","containerName":"_qual_dec2hex","line":424,"kind":13}],"kind":12,"detail":"($self,$qual)","signature":{"parameters":[{"label":"$self"},{"label":"$qual"}],"documentation":"__END__\n# $Id: tigr.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO::tigr\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO::tigr - Driver to read and write assembly files in the TIGR\nAssembler v2 default format.\n\n=head1 SYNOPSIS\n\n    # Building an input stream\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $asmio = Bio::Assembly::IO->new( -file   => 'SGC0-424.tasm',\n                                        -format => 'tigr' );\n    my $scaffold = $asmio->next_assembly;\n\n    # Do some things on contigs...\n\n    # Assembly writing methods\n    my $outasm = Bio::Assembly::IO->new( -file   => \">SGC0-modified.tasm\",\n                                         -format => 'tigr' );\n    $outasm->write_assembly( -scaffold => $assembly,\n                             -singlets => 1 );\n\n=head1 DESCRIPTION\n\nThis package loads and writes assembly information in/from files in the default\nTIGR Assembler v2 format. The files are lassie-formatted and often have the\n.tasm extension. This module was written to be used as a driver module for\nBio::Assembly::IO input/output.\n\n=head2 Implementation\n\nAssemblies are loaded into Bio::Assembly::Scaffold objects composed of\nBio::Assembly::Contig and Bio::Assembly::Singlet objects. Since aligned reads\nand contig gapped consensus can be obtained in the tasm files, only\naligned/gapped sequences are added to the different BioPerl objects.\n\nAdditional assembly information is stored as features. Contig objects have\nSeqFeature information associated with the primary_tag:\n\n    _main_contig_feature:$contig_id -> misc contig information\n    _quality_clipping:$read_id      -> quality clipping position\n\nRead objects have sub_seqFeature information associated with the\nprimary_tag:\n\n    _main_read_feature:$read_id     -> misc read information\n\nSinglets are considered by TIGR Assembler as contigs of one sequence and are\nrepresented here with features having these primary_tag: \n\n    _main_contig_feature:$contig_id\n    _quality_clipping:$read_primary_id\n    _main_read_feature:$read_primary_id\n    _aligned_coord:$read_primary_id\n\n=head1 THE TIGR TASM LASSIEFORMAT\n\n=head2 Description\n\nIn the TIGR tasm lassie format, contigs are separated by a line containing a single\npipe character \"|\", whereas the reads in a contig are separated by a blank line.\nSinglets can be present in the file and are represented as a contig\ncomposed of a single sequence.\n\nOther than the two above-mentioned separators, each line has an attribute name,\nfollowed a tab and then an attribute value.\n\nThe tasm format is used by more TIGR applications than just TIGR Assembler.\nSome of the attributes are not used by TIGR Assembler or have constant values.\nThey are indicated by an asterisk *\n\nContigs have the following attributes:\n\n    asmbl_id   -> contig ID\n    sequence   -> contig ungapped consensus sequence (ambiguities are lowercase)\n    lsequence  -> gapped consensus sequence (lowercase ambiguities)\n    quality    -> gapped consensus quality score (in hexadecimal)\n    seq_id     -> *\n    com_name   -> *\n    type       -> *\n    method     -> always 'asmg' *\n    ed_status  -> *\n    redundancy -> fold coverage of the contig consensus\n    perc_N     -> percent of ambiguities in the contig consensus\n    seq#       -> number of sequences in the contig\n    full_cds   -> *\n    cds_start  -> start of coding sequence *\n    cds_end    -> end of coding sequence *\n    ed_pn      -> name of editor (always 'GRA') *\n    ed_date    -> date and time of edition\n    comment    -> some comments *\n    frameshift -> *\n\nEach read has the following attributes:\n\n    seq_name  -> read name\n    asm_lend  -> position of first base on contig ungapped consensus sequence\n    asm_rend  -> position of last base on contig ungapped consensus sequence\n    seq_lend  -> start of quality-trimmed sequence (aligned read coordinates)\n    seq_rend  -> end of quality-trimmed sequence (aligned read coordinates)\n    best      -> always '0' *\n    comment   -> some comments *\n    db        -> database name associated with the sequence (e.g. >my_db|seq1234)\n    offset    -> offset of the sequence (gapped consensus coordinates)\n    lsequence -> aligned read sequence (ambiguities are uppercase)\n\nWhen asm_rend E<lt> asm_lend, the sequence was on the complementary DNA strand but\nits reverse complement is shown in the aligned sequence of the assembly file,\nnot the original read.\n\nAmbiguities are reflected in the contig consensus sequence as\nlowercase IUPAC characters: a c g t u m r w s y k x n . In the read\nsequences, however, ambiguities are uppercase: M R W S Y K X N\n\n=head2 Example\n\nExample of a contig containing three sequences:\n\n    sequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCGCAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    quality\t0x0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0505050505050505050E0505160505050505050505050505050505050505050505050505050505050303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0404040404040404041604040404040404040404040404040404040404040404040404040404040404040404040404040404040E0404040404040404040B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B\n    asmbl_id\t93\n    seq_id\t\n    com_name\t\n    type\t\n    method\tasmg\n    ed_status\t\n    redundancy\t1.11\n    perc_N\t0.20\n    seq#\t3\n    full_cds\t\n    cds_start\t\n    cds_end\t\n    ed_pn\tGRA\n    ed_date\t08/16/07 17:10:12\n    comment\t\n    frameshift\t\n\n    seq_name\tSDSU_RFPERU_010_C09.x01.phd.1\n    asm_lend\t1\n    asm_rend\t4423\n    seq_lend\t1\n    seq_rend\t442\n    best\t0\n    comment\t\n    db\t\n    offset\t0\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAGCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGG\n\n    seq_name\tSDSU_RFPERU_002_H12.x01.phd.1\n    asm_lend\t339\n    asm_rend\t940\n    seq_lend\t1\n    seq_rend\t602\n    best\t0\n    comment\t\n    db\t\n    offset\t338\n    lsequence\tCGAGATTCGCCACCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCCGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATA-GCGTGGCGC\n\n    seq_name\tSDSU_RFPERU_009_E07.x01.phd.1\n    asm_lend\t880\n    asm_rend\t1520\n    seq_lend\t641\n    seq_rend\t1\n    best\t0\n    comment\t\n    db\t\n    offset\t8803\n    lsequence\tCGCACGGTCTGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAAGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    |\n\n...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent dot angly at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::IO::tigr;\n\nuse strict;\nuse Bio::Seq::Quality;\nuse Bio::LocatableSeq;\nuse Bio::Assembly::IO;\nuse Bio::Assembly::Scaffold;\nuse Bio::Assembly::Contig;\nuse Bio::Assembly::Singlet;\n\nuse base qw(Bio::Assembly::IO);\n\nmy $progname = 'TIGR Assembler';\n\n=head2 next_assembly\n\n Title   : next_assembly\n Usage   : my $scaffold = $asmio->next_assembly()\n Function: return the next assembly in the tasm-formatted stream\n Returns : Bio::Assembly::Scaffold object\n Args    : none\n\n\nsub next_assembly {\n    my $self = shift; # object reference\n    \n    # Create a new scaffold to hold the contigs\n    my $scaffoldobj = Bio::Assembly::Scaffold->new(-source => $progname);\n    \n    # Contig and read related\n    my $contigobj;\n    my $iscontig = 1;\n    my %contiginfo;\n    my $isread = 0;\n    my %readinfo;\n    \n    # Loop over all assembly file lines\n    while ($_ = $self->_readline) {\n        chomp;\n        if ( /^\\|/ ) {  # a line with a single pipe |\n            # The end of a read from a contig, the start of a new contig\n            $iscontig = 1;\n            $isread   = 0;\n            # Store read info\n            if ($contiginfo{'seqnum'} > 1) {\n                # This is a read in a contig\n                my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n            } elsif ($contiginfo{'seqnum'} == 1) {\n                # This is a singlet\n                my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                    $scaffoldobj);\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n            # Clear read info\n            undef %readinfo;\n            # Clear contig info\n            undef $contigobj;\n            undef %contiginfo;\n        } elsif ( /^$/ ) {  # a blank line\n            if ($iscontig) {\n                # The end of a contig, the start of a read in that contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store contig info\n                $contigobj = $self->_store_contig( \\%contiginfo, $contigobj,\n                    $scaffoldobj ) if $contiginfo{'seqnum'} > 1;\n            } elsif ($isread) {\n                # The end of read in a contig, the start of a new one in\n                # the same contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store read info\n                if ($contiginfo{'seqnum'} > 1) {\n                    # This is a read in a contig\n                    my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n                } elsif ($contiginfo{'seqnum'} == 1) {\n                    # This is a singlet\n                    my $singletobj = $self->_store_singlet(\\%readinfo,\n                        \\%contiginfo, $scaffoldobj);\n                } else {\n                  # That should not happen\n                  $self->throw(\"Unhandled exception\");\n                }\n                # Clear read info\n                undef %readinfo;\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n        } else {\n            if ($iscontig) {\n                # Parse contig\n                if    (/^sequence\\t(.*)/)     {$contiginfo{'sequence'}   = $1; next}\n                elsif (/^lsequence\\t(.*)/)    {$contiginfo{'lsequence'}  = $1; next}\n                elsif (/^quality\\t(.*)/)      {$contiginfo{'quality'}    = $1; next}\n                elsif (/^asmbl_id\\t(.*)/)     {$contiginfo{'asmbl_id'}   = $1; next}\n                elsif (/^seq_id\\t(.*)/)       {$contiginfo{'seq_id'}     = $1; next}\n                elsif (/^com_name\\t(.*)/)     {$contiginfo{'com_name'}   = $1; next}\n                elsif (/^type\\t(.*)/)         {$contiginfo{'type'}       = $1; next}\n                elsif (/^method\\t(.*)/)       {$contiginfo{'method'}     = $1; next}\n                elsif (/^ed_status\\t(.*)/)    {$contiginfo{'ed_status'}  = $1; next}\n                elsif (/^redundancy\\t(.*)/)   {$contiginfo{'redundancy'} = $1; next}\n                elsif (/^perc_N\\t(.*)/)       {$contiginfo{'perc_N'}     = $1; next}\n                elsif (/^seq\\#\\t(.*)/)        {$contiginfo{'seqnum'}     = $1; next}\n                elsif (/^full_cds\\t(.*)/)     {$contiginfo{'full_cds'}   = $1; next}\n                elsif (/^cds_start\\t(.*)/)    {$contiginfo{'cds_start'}  = $1; next}\n                elsif (/^cds_end\\t(.*)/)      {$contiginfo{'cds_end'}    = $1; next}\n                elsif (/^ed_pn\\t(.*)/)        {$contiginfo{'ed_pn'}      = $1; next}\n                elsif (/^ed_date\\t(.*\\s.*)/)  {$contiginfo{'ed_date'}    = $1; next}\n                elsif (/^comment\\t(.*)/)      {$contiginfo{'comment'}    = $1; next}\n                elsif (/^frameshift\\t(.*)/)   {$contiginfo{'frameshift'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } elsif ($isread) {\n                # Parse read info\n                if    (/^seq_name\\t(.*)/)  {$readinfo{'seq_name'}  = $1; next}\n                elsif (/^asm_lend\\t(.*)/)  {$readinfo{'asm_lend'}  = $1; next}\n                elsif (/^asm_rend\\t(.*)/)  {$readinfo{'asm_rend'}  = $1; next}\n                elsif (/^seq_lend\\t(.*)/)  {$readinfo{'seq_lend'}  = $1; next}\n                elsif (/^seq_rend\\t(.*)/)  {$readinfo{'seq_rend'}  = $1; next}\n                elsif (/^best\\t(.*)/)      {$readinfo{'best'}      = $1; next}\n                elsif (/^comment\\t(.*)/)   {$readinfo{'comment'}   = $1; next}\n                elsif (/^db\\t(.*)/)        {$readinfo{'db'}        = $1; next}\n                elsif (/^offset\\t(.*)/)    {$readinfo{'offset'}    = $1; next}\n                elsif (/^lsequence\\t(.*)/) {$readinfo{'lsequence'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } else {\n                # That shouldn't happen\n                $self->throw(\"Unhandled exception\");                \n            }\n        }\n    }\n    # Store read info for last read\n    if (defined $contiginfo{'seqnum'}) {\n        if ($contiginfo{'seqnum'} > 1) {\n            # This is a read in a contig\n            my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n        } elsif ($contiginfo{'seqnum'} == 1) {\n            # This is a singlet\n            my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                $scaffoldobj);\n        } else {\n            # That should not happen\n            $self->throw(\"Unhandled exception\");\n        }\n    }\n    # Clear read info for last read\n    undef %readinfo;\n    # Clear contig info for last contig\n    undef $contigobj;\n    undef %contiginfo;\n    \n    $scaffoldobj->update_seq_list();\n    \n    return $scaffoldobj;\n}\n\n=head2 _qual_hex2dec\n\n    Title   : _qual_hex2dec\n    Usage   : my dec_quality = $self->_qual_hex2dec($hex_quality);\n    Function: convert an hexadecimal quality score into a decimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_hex2dec {\n    my ($self, $qual) = @_;\n    $qual =~ s/^0x(.*)$/$1/;\n    $qual =~ s/(..)/hex($1).' '/eg;\n    return $qual;\n}\n\n=head2 _qual_dec2hex\n\n    Title   : _qual_dec2hex\n    Usage   : my hex_quality = $self->_qual_dec2hex($dec_quality);\n    Function: convert a decimal quality score into an hexadecimal quality score \n    Returns : string\n    Args    : string","label":"_qual_dec2hex($self,$qual)"},"containerName":"main::","definition":"sub"},{"line":439,"children":[{"line":440,"kind":13,"localvar":"my","containerName":"_store_contig","definition":"my","name":"$self"},{"line":440,"kind":13,"name":"$contiginfo","containerName":"_store_contig"},{"line":440,"kind":13,"name":"$contigobj","containerName":"_store_contig"},{"containerName":"_store_contig","name":"$scaffoldobj","kind":13,"line":440},{"line":443,"kind":13,"name":"$contigobj","containerName":"_store_contig"},{"containerName":"_store_contig","name":"new","line":443,"kind":12},{"containerName":"_store_contig","name":"$progname","kind":13,"line":445},{"kind":13,"line":448,"containerName":"_store_contig","name":"$scaffoldobj"},{"kind":12,"line":448,"containerName":"_store_contig","name":"add_contig"},{"containerName":"_store_contig","name":"$contigobj","kind":13,"line":448},{"name":"$consensus","definition":"my","containerName":"_store_contig","localvar":"my","kind":13,"line":452},{"kind":12,"line":452,"name":"new","containerName":"_store_contig"},{"kind":13,"line":457,"name":"$contigobj","containerName":"_store_contig"},{"kind":12,"line":457,"containerName":"_store_contig","name":"set_consensus_sequence"},{"containerName":"_store_contig","name":"$consensus","kind":13,"line":457},{"line":460,"kind":13,"name":"$self","containerName":"_store_contig"},{"line":460,"kind":12,"containerName":"_store_contig","name":"_qual_hex2dec"},{"kind":13,"line":461,"definition":"my","name":"$qual","containerName":"_store_contig","localvar":"my"},{"kind":12,"line":461,"containerName":"_store_contig","name":"new"},{"line":465,"kind":13,"name":"$contigobj","containerName":"_store_contig"},{"kind":12,"line":465,"name":"set_consensus_quality","containerName":"_store_contig"},{"kind":13,"line":465,"containerName":"_store_contig","name":"$qual"},{"localvar":"my","containerName":"_store_contig","definition":"my","name":"$contigtags","line":468,"kind":13},{"kind":12,"line":468,"name":"new","containerName":"_store_contig"},{"containerName":"_store_contig","name":"$contigobj","kind":13,"line":471},{"kind":12,"line":471,"containerName":"_store_contig","name":"get_consensus_length"},{"kind":13,"line":486,"name":"$contigobj","containerName":"_store_contig"},{"name":"add_features","containerName":"_store_contig","line":486,"kind":12},{"name":"$contigtags","containerName":"_store_contig","line":486,"kind":13},{"line":488,"kind":13,"name":"$contigobj","containerName":"_store_contig"}],"kind":12,"detail":"($self,$contiginfo,$contigobj,$scaffoldobj)","signature":{"label":"_store_contig($self,$contiginfo,$contigobj,$scaffoldobj)","documentation":"__END__\n# $Id: tigr.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO::tigr\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO::tigr - Driver to read and write assembly files in the TIGR\nAssembler v2 default format.\n\n=head1 SYNOPSIS\n\n    # Building an input stream\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $asmio = Bio::Assembly::IO->new( -file   => 'SGC0-424.tasm',\n                                        -format => 'tigr' );\n    my $scaffold = $asmio->next_assembly;\n\n    # Do some things on contigs...\n\n    # Assembly writing methods\n    my $outasm = Bio::Assembly::IO->new( -file   => \">SGC0-modified.tasm\",\n                                         -format => 'tigr' );\n    $outasm->write_assembly( -scaffold => $assembly,\n                             -singlets => 1 );\n\n=head1 DESCRIPTION\n\nThis package loads and writes assembly information in/from files in the default\nTIGR Assembler v2 format. The files are lassie-formatted and often have the\n.tasm extension. This module was written to be used as a driver module for\nBio::Assembly::IO input/output.\n\n=head2 Implementation\n\nAssemblies are loaded into Bio::Assembly::Scaffold objects composed of\nBio::Assembly::Contig and Bio::Assembly::Singlet objects. Since aligned reads\nand contig gapped consensus can be obtained in the tasm files, only\naligned/gapped sequences are added to the different BioPerl objects.\n\nAdditional assembly information is stored as features. Contig objects have\nSeqFeature information associated with the primary_tag:\n\n    _main_contig_feature:$contig_id -> misc contig information\n    _quality_clipping:$read_id      -> quality clipping position\n\nRead objects have sub_seqFeature information associated with the\nprimary_tag:\n\n    _main_read_feature:$read_id     -> misc read information\n\nSinglets are considered by TIGR Assembler as contigs of one sequence and are\nrepresented here with features having these primary_tag: \n\n    _main_contig_feature:$contig_id\n    _quality_clipping:$read_primary_id\n    _main_read_feature:$read_primary_id\n    _aligned_coord:$read_primary_id\n\n=head1 THE TIGR TASM LASSIEFORMAT\n\n=head2 Description\n\nIn the TIGR tasm lassie format, contigs are separated by a line containing a single\npipe character \"|\", whereas the reads in a contig are separated by a blank line.\nSinglets can be present in the file and are represented as a contig\ncomposed of a single sequence.\n\nOther than the two above-mentioned separators, each line has an attribute name,\nfollowed a tab and then an attribute value.\n\nThe tasm format is used by more TIGR applications than just TIGR Assembler.\nSome of the attributes are not used by TIGR Assembler or have constant values.\nThey are indicated by an asterisk *\n\nContigs have the following attributes:\n\n    asmbl_id   -> contig ID\n    sequence   -> contig ungapped consensus sequence (ambiguities are lowercase)\n    lsequence  -> gapped consensus sequence (lowercase ambiguities)\n    quality    -> gapped consensus quality score (in hexadecimal)\n    seq_id     -> *\n    com_name   -> *\n    type       -> *\n    method     -> always 'asmg' *\n    ed_status  -> *\n    redundancy -> fold coverage of the contig consensus\n    perc_N     -> percent of ambiguities in the contig consensus\n    seq#       -> number of sequences in the contig\n    full_cds   -> *\n    cds_start  -> start of coding sequence *\n    cds_end    -> end of coding sequence *\n    ed_pn      -> name of editor (always 'GRA') *\n    ed_date    -> date and time of edition\n    comment    -> some comments *\n    frameshift -> *\n\nEach read has the following attributes:\n\n    seq_name  -> read name\n    asm_lend  -> position of first base on contig ungapped consensus sequence\n    asm_rend  -> position of last base on contig ungapped consensus sequence\n    seq_lend  -> start of quality-trimmed sequence (aligned read coordinates)\n    seq_rend  -> end of quality-trimmed sequence (aligned read coordinates)\n    best      -> always '0' *\n    comment   -> some comments *\n    db        -> database name associated with the sequence (e.g. >my_db|seq1234)\n    offset    -> offset of the sequence (gapped consensus coordinates)\n    lsequence -> aligned read sequence (ambiguities are uppercase)\n\nWhen asm_rend E<lt> asm_lend, the sequence was on the complementary DNA strand but\nits reverse complement is shown in the aligned sequence of the assembly file,\nnot the original read.\n\nAmbiguities are reflected in the contig consensus sequence as\nlowercase IUPAC characters: a c g t u m r w s y k x n . In the read\nsequences, however, ambiguities are uppercase: M R W S Y K X N\n\n=head2 Example\n\nExample of a contig containing three sequences:\n\n    sequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCGCAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    quality\t0x0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0505050505050505050E0505160505050505050505050505050505050505050505050505050505050303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0404040404040404041604040404040404040404040404040404040404040404040404040404040404040404040404040404040E0404040404040404040B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B\n    asmbl_id\t93\n    seq_id\t\n    com_name\t\n    type\t\n    method\tasmg\n    ed_status\t\n    redundancy\t1.11\n    perc_N\t0.20\n    seq#\t3\n    full_cds\t\n    cds_start\t\n    cds_end\t\n    ed_pn\tGRA\n    ed_date\t08/16/07 17:10:12\n    comment\t\n    frameshift\t\n\n    seq_name\tSDSU_RFPERU_010_C09.x01.phd.1\n    asm_lend\t1\n    asm_rend\t4423\n    seq_lend\t1\n    seq_rend\t442\n    best\t0\n    comment\t\n    db\t\n    offset\t0\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAGCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGG\n\n    seq_name\tSDSU_RFPERU_002_H12.x01.phd.1\n    asm_lend\t339\n    asm_rend\t940\n    seq_lend\t1\n    seq_rend\t602\n    best\t0\n    comment\t\n    db\t\n    offset\t338\n    lsequence\tCGAGATTCGCCACCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCCGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATA-GCGTGGCGC\n\n    seq_name\tSDSU_RFPERU_009_E07.x01.phd.1\n    asm_lend\t880\n    asm_rend\t1520\n    seq_lend\t641\n    seq_rend\t1\n    best\t0\n    comment\t\n    db\t\n    offset\t8803\n    lsequence\tCGCACGGTCTGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAAGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    |\n\n...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent dot angly at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::IO::tigr;\n\nuse strict;\nuse Bio::Seq::Quality;\nuse Bio::LocatableSeq;\nuse Bio::Assembly::IO;\nuse Bio::Assembly::Scaffold;\nuse Bio::Assembly::Contig;\nuse Bio::Assembly::Singlet;\n\nuse base qw(Bio::Assembly::IO);\n\nmy $progname = 'TIGR Assembler';\n\n=head2 next_assembly\n\n Title   : next_assembly\n Usage   : my $scaffold = $asmio->next_assembly()\n Function: return the next assembly in the tasm-formatted stream\n Returns : Bio::Assembly::Scaffold object\n Args    : none\n\n\nsub next_assembly {\n    my $self = shift; # object reference\n    \n    # Create a new scaffold to hold the contigs\n    my $scaffoldobj = Bio::Assembly::Scaffold->new(-source => $progname);\n    \n    # Contig and read related\n    my $contigobj;\n    my $iscontig = 1;\n    my %contiginfo;\n    my $isread = 0;\n    my %readinfo;\n    \n    # Loop over all assembly file lines\n    while ($_ = $self->_readline) {\n        chomp;\n        if ( /^\\|/ ) {  # a line with a single pipe |\n            # The end of a read from a contig, the start of a new contig\n            $iscontig = 1;\n            $isread   = 0;\n            # Store read info\n            if ($contiginfo{'seqnum'} > 1) {\n                # This is a read in a contig\n                my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n            } elsif ($contiginfo{'seqnum'} == 1) {\n                # This is a singlet\n                my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                    $scaffoldobj);\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n            # Clear read info\n            undef %readinfo;\n            # Clear contig info\n            undef $contigobj;\n            undef %contiginfo;\n        } elsif ( /^$/ ) {  # a blank line\n            if ($iscontig) {\n                # The end of a contig, the start of a read in that contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store contig info\n                $contigobj = $self->_store_contig( \\%contiginfo, $contigobj,\n                    $scaffoldobj ) if $contiginfo{'seqnum'} > 1;\n            } elsif ($isread) {\n                # The end of read in a contig, the start of a new one in\n                # the same contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store read info\n                if ($contiginfo{'seqnum'} > 1) {\n                    # This is a read in a contig\n                    my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n                } elsif ($contiginfo{'seqnum'} == 1) {\n                    # This is a singlet\n                    my $singletobj = $self->_store_singlet(\\%readinfo,\n                        \\%contiginfo, $scaffoldobj);\n                } else {\n                  # That should not happen\n                  $self->throw(\"Unhandled exception\");\n                }\n                # Clear read info\n                undef %readinfo;\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n        } else {\n            if ($iscontig) {\n                # Parse contig\n                if    (/^sequence\\t(.*)/)     {$contiginfo{'sequence'}   = $1; next}\n                elsif (/^lsequence\\t(.*)/)    {$contiginfo{'lsequence'}  = $1; next}\n                elsif (/^quality\\t(.*)/)      {$contiginfo{'quality'}    = $1; next}\n                elsif (/^asmbl_id\\t(.*)/)     {$contiginfo{'asmbl_id'}   = $1; next}\n                elsif (/^seq_id\\t(.*)/)       {$contiginfo{'seq_id'}     = $1; next}\n                elsif (/^com_name\\t(.*)/)     {$contiginfo{'com_name'}   = $1; next}\n                elsif (/^type\\t(.*)/)         {$contiginfo{'type'}       = $1; next}\n                elsif (/^method\\t(.*)/)       {$contiginfo{'method'}     = $1; next}\n                elsif (/^ed_status\\t(.*)/)    {$contiginfo{'ed_status'}  = $1; next}\n                elsif (/^redundancy\\t(.*)/)   {$contiginfo{'redundancy'} = $1; next}\n                elsif (/^perc_N\\t(.*)/)       {$contiginfo{'perc_N'}     = $1; next}\n                elsif (/^seq\\#\\t(.*)/)        {$contiginfo{'seqnum'}     = $1; next}\n                elsif (/^full_cds\\t(.*)/)     {$contiginfo{'full_cds'}   = $1; next}\n                elsif (/^cds_start\\t(.*)/)    {$contiginfo{'cds_start'}  = $1; next}\n                elsif (/^cds_end\\t(.*)/)      {$contiginfo{'cds_end'}    = $1; next}\n                elsif (/^ed_pn\\t(.*)/)        {$contiginfo{'ed_pn'}      = $1; next}\n                elsif (/^ed_date\\t(.*\\s.*)/)  {$contiginfo{'ed_date'}    = $1; next}\n                elsif (/^comment\\t(.*)/)      {$contiginfo{'comment'}    = $1; next}\n                elsif (/^frameshift\\t(.*)/)   {$contiginfo{'frameshift'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } elsif ($isread) {\n                # Parse read info\n                if    (/^seq_name\\t(.*)/)  {$readinfo{'seq_name'}  = $1; next}\n                elsif (/^asm_lend\\t(.*)/)  {$readinfo{'asm_lend'}  = $1; next}\n                elsif (/^asm_rend\\t(.*)/)  {$readinfo{'asm_rend'}  = $1; next}\n                elsif (/^seq_lend\\t(.*)/)  {$readinfo{'seq_lend'}  = $1; next}\n                elsif (/^seq_rend\\t(.*)/)  {$readinfo{'seq_rend'}  = $1; next}\n                elsif (/^best\\t(.*)/)      {$readinfo{'best'}      = $1; next}\n                elsif (/^comment\\t(.*)/)   {$readinfo{'comment'}   = $1; next}\n                elsif (/^db\\t(.*)/)        {$readinfo{'db'}        = $1; next}\n                elsif (/^offset\\t(.*)/)    {$readinfo{'offset'}    = $1; next}\n                elsif (/^lsequence\\t(.*)/) {$readinfo{'lsequence'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } else {\n                # That shouldn't happen\n                $self->throw(\"Unhandled exception\");                \n            }\n        }\n    }\n    # Store read info for last read\n    if (defined $contiginfo{'seqnum'}) {\n        if ($contiginfo{'seqnum'} > 1) {\n            # This is a read in a contig\n            my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n        } elsif ($contiginfo{'seqnum'} == 1) {\n            # This is a singlet\n            my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                $scaffoldobj);\n        } else {\n            # That should not happen\n            $self->throw(\"Unhandled exception\");\n        }\n    }\n    # Clear read info for last read\n    undef %readinfo;\n    # Clear contig info for last contig\n    undef $contigobj;\n    undef %contiginfo;\n    \n    $scaffoldobj->update_seq_list();\n    \n    return $scaffoldobj;\n}\n\n=head2 _qual_hex2dec\n\n    Title   : _qual_hex2dec\n    Usage   : my dec_quality = $self->_qual_hex2dec($hex_quality);\n    Function: convert an hexadecimal quality score into a decimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_hex2dec {\n    my ($self, $qual) = @_;\n    $qual =~ s/^0x(.*)$/$1/;\n    $qual =~ s/(..)/hex($1).' '/eg;\n    return $qual;\n}\n\n=head2 _qual_dec2hex\n\n    Title   : _qual_dec2hex\n    Usage   : my hex_quality = $self->_qual_dec2hex($dec_quality);\n    Function: convert a decimal quality score into an hexadecimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_dec2hex {\n    my ($self, $qual) = @_;\n    $qual =~ s/(\\d+)\\s*/sprintf('%02X', $1)/eg;\n    $qual = '0x'.$qual;\n    return $qual;\n}\n\n=head2 _store_contig\n\n    Title   : _store_contig\n    Usage   : my $contigobj; $contigobj = $self->_store_contig(\n              \\%contiginfo, $contigobj, $scaffoldobj);\n    Function: store information of a contig belonging to a scaffold in the\n              appropriate object\n    Returns : Bio::Assembly::Contig object\n    Args    : hash, Bio::Assembly::Contig, Bio::Assembly::Scaffold","parameters":[{"label":"$self"},{"label":"$contiginfo"},{"label":"$contigobj"},{"label":"$scaffoldobj"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":439},"end":{"line":489,"character":9999}},"name":"_store_contig"},{"kind":12,"line":443,"name":"Bio","containerName":"Assembly::Contig"},{"name":"contiginfo","kind":12,"line":444},{"name":"Bio","containerName":"LocatableSeq","line":452,"kind":12},{"kind":12,"line":453,"name":"contiginfo"},{"kind":12,"line":454,"name":"contiginfo"},{"name":"contiginfo","kind":12,"line":460},{"name":"contiginfo","line":460,"kind":12},{"name":"Bio","containerName":"Seq::Quality","kind":12,"line":461},{"line":462,"kind":12,"name":"contiginfo"},{"name":"contiginfo","line":463,"kind":12},{"name":"Bio","containerName":"SeqFeature::Generic","line":468,"kind":12},{"name":"contiginfo","line":473,"kind":12},{"line":474,"kind":12,"name":"contiginfo"},{"kind":12,"line":475,"name":"contiginfo"},{"name":"contiginfo","line":476,"kind":12},{"name":"contiginfo","line":477,"kind":12},{"line":478,"kind":12,"name":"contiginfo"},{"kind":12,"line":479,"name":"contiginfo"},{"kind":12,"line":480,"name":"contiginfo"},{"name":"contiginfo","kind":12,"line":481},{"kind":12,"line":482,"name":"contiginfo"},{"line":483,"kind":12,"name":"contiginfo"},{"name":"contiginfo","kind":12,"line":484},{"name":"_store_read","range":{"end":{"character":9999,"line":555},"start":{"line":501,"character":0}},"kind":12,"line":501,"children":[{"kind":13,"line":502,"containerName":"_store_read","name":"$self","definition":"my","localvar":"my"},{"containerName":"_store_read","name":"$readinfo","line":502,"kind":13},{"line":502,"kind":13,"name":"$contigobj","containerName":"_store_read"},{"line":507,"kind":13,"localvar":"my","containerName":"_store_read","name":"$readobj","definition":"my"},{"line":507,"kind":12,"containerName":"_store_read","name":"new"},{"kind":13,"line":510,"containerName":"_store_read","name":"$self"},{"line":510,"kind":12,"containerName":"_store_read","name":"_merge_seq_name_and_db"},{"line":511,"kind":13,"containerName":"_store_read","name":"$self"},{"line":511,"kind":12,"name":"_merge_seq_name_and_db","containerName":"_store_read"},{"line":521,"kind":13,"localvar":"my","definition":"my","name":"$alncoord","containerName":"_store_read"},{"line":521,"kind":12,"containerName":"_store_read","name":"new"},{"kind":13,"line":522,"name":"$readobj","containerName":"_store_read"},{"name":"id","containerName":"_store_read","line":522,"kind":12},{"name":"$contigobj","containerName":"_store_read","kind":13,"line":526},{"name":"id","containerName":"_store_read","kind":12,"line":526},{"containerName":"_store_read","name":"$contigobj","kind":13,"line":528},{"kind":12,"line":528,"containerName":"_store_read","name":"set_seq_coord"},{"line":528,"kind":13,"containerName":"_store_read","name":"$alncoord"},{"name":"$readobj","containerName":"_store_read","kind":13,"line":528},{"name":"$contigobj","containerName":"_store_read","line":532,"kind":13},{"containerName":"_store_read","name":"change_coord","line":532,"kind":12},{"name":"$readobj","containerName":"_store_read","kind":13,"line":532},{"containerName":"_store_read","name":"id","line":532,"kind":12},{"kind":13,"line":533,"name":"$contigobj","containerName":"_store_read"},{"containerName":"_store_read","name":"change_coord","line":533,"kind":12},{"line":533,"kind":13,"containerName":"_store_read","name":"$readobj"},{"name":"id","containerName":"_store_read","line":533,"kind":12},{"containerName":"_store_read","definition":"my","name":"$clipcoord","localvar":"my","kind":13,"line":534},{"kind":12,"line":534,"containerName":"_store_read","name":"new"},{"line":535,"kind":13,"name":"$readobj","containerName":"_store_read"},{"containerName":"_store_read","name":"id","kind":12,"line":535},{"name":"$clipcoord","containerName":"_store_read","kind":13,"line":540},{"line":540,"kind":12,"containerName":"_store_read","name":"attach_seq"},{"name":"$readobj","containerName":"_store_read","kind":13,"line":540},{"kind":13,"line":541,"name":"$contigobj","containerName":"_store_read"},{"name":"add_features","containerName":"_store_read","kind":12,"line":541},{"line":541,"kind":13,"containerName":"_store_read","name":"$clipcoord"},{"containerName":"_store_read","name":"$readtags","definition":"my","localvar":"my","kind":13,"line":544},{"containerName":"_store_read","name":"new","kind":12,"line":544},{"kind":13,"line":545,"name":"$readobj","containerName":"_store_read"},{"line":545,"kind":12,"containerName":"_store_read","name":"id"},{"containerName":"_store_read","name":"$alncoord","line":552,"kind":13},{"name":"add_sub_SeqFeature","containerName":"_store_read","line":552,"kind":12},{"name":"$readtags","containerName":"_store_read","kind":13,"line":552},{"name":"$readobj","containerName":"_store_read","line":554,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$readinfo,$contigobj)","signature":{"label":"_store_read($self,$readinfo,$contigobj)","parameters":[{"label":"$self"},{"label":"$readinfo"},{"label":"$contigobj"}],"documentation":"__END__\n# $Id: tigr.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO::tigr\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO::tigr - Driver to read and write assembly files in the TIGR\nAssembler v2 default format.\n\n=head1 SYNOPSIS\n\n    # Building an input stream\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $asmio = Bio::Assembly::IO->new( -file   => 'SGC0-424.tasm',\n                                        -format => 'tigr' );\n    my $scaffold = $asmio->next_assembly;\n\n    # Do some things on contigs...\n\n    # Assembly writing methods\n    my $outasm = Bio::Assembly::IO->new( -file   => \">SGC0-modified.tasm\",\n                                         -format => 'tigr' );\n    $outasm->write_assembly( -scaffold => $assembly,\n                             -singlets => 1 );\n\n=head1 DESCRIPTION\n\nThis package loads and writes assembly information in/from files in the default\nTIGR Assembler v2 format. The files are lassie-formatted and often have the\n.tasm extension. This module was written to be used as a driver module for\nBio::Assembly::IO input/output.\n\n=head2 Implementation\n\nAssemblies are loaded into Bio::Assembly::Scaffold objects composed of\nBio::Assembly::Contig and Bio::Assembly::Singlet objects. Since aligned reads\nand contig gapped consensus can be obtained in the tasm files, only\naligned/gapped sequences are added to the different BioPerl objects.\n\nAdditional assembly information is stored as features. Contig objects have\nSeqFeature information associated with the primary_tag:\n\n    _main_contig_feature:$contig_id -> misc contig information\n    _quality_clipping:$read_id      -> quality clipping position\n\nRead objects have sub_seqFeature information associated with the\nprimary_tag:\n\n    _main_read_feature:$read_id     -> misc read information\n\nSinglets are considered by TIGR Assembler as contigs of one sequence and are\nrepresented here with features having these primary_tag: \n\n    _main_contig_feature:$contig_id\n    _quality_clipping:$read_primary_id\n    _main_read_feature:$read_primary_id\n    _aligned_coord:$read_primary_id\n\n=head1 THE TIGR TASM LASSIEFORMAT\n\n=head2 Description\n\nIn the TIGR tasm lassie format, contigs are separated by a line containing a single\npipe character \"|\", whereas the reads in a contig are separated by a blank line.\nSinglets can be present in the file and are represented as a contig\ncomposed of a single sequence.\n\nOther than the two above-mentioned separators, each line has an attribute name,\nfollowed a tab and then an attribute value.\n\nThe tasm format is used by more TIGR applications than just TIGR Assembler.\nSome of the attributes are not used by TIGR Assembler or have constant values.\nThey are indicated by an asterisk *\n\nContigs have the following attributes:\n\n    asmbl_id   -> contig ID\n    sequence   -> contig ungapped consensus sequence (ambiguities are lowercase)\n    lsequence  -> gapped consensus sequence (lowercase ambiguities)\n    quality    -> gapped consensus quality score (in hexadecimal)\n    seq_id     -> *\n    com_name   -> *\n    type       -> *\n    method     -> always 'asmg' *\n    ed_status  -> *\n    redundancy -> fold coverage of the contig consensus\n    perc_N     -> percent of ambiguities in the contig consensus\n    seq#       -> number of sequences in the contig\n    full_cds   -> *\n    cds_start  -> start of coding sequence *\n    cds_end    -> end of coding sequence *\n    ed_pn      -> name of editor (always 'GRA') *\n    ed_date    -> date and time of edition\n    comment    -> some comments *\n    frameshift -> *\n\nEach read has the following attributes:\n\n    seq_name  -> read name\n    asm_lend  -> position of first base on contig ungapped consensus sequence\n    asm_rend  -> position of last base on contig ungapped consensus sequence\n    seq_lend  -> start of quality-trimmed sequence (aligned read coordinates)\n    seq_rend  -> end of quality-trimmed sequence (aligned read coordinates)\n    best      -> always '0' *\n    comment   -> some comments *\n    db        -> database name associated with the sequence (e.g. >my_db|seq1234)\n    offset    -> offset of the sequence (gapped consensus coordinates)\n    lsequence -> aligned read sequence (ambiguities are uppercase)\n\nWhen asm_rend E<lt> asm_lend, the sequence was on the complementary DNA strand but\nits reverse complement is shown in the aligned sequence of the assembly file,\nnot the original read.\n\nAmbiguities are reflected in the contig consensus sequence as\nlowercase IUPAC characters: a c g t u m r w s y k x n . In the read\nsequences, however, ambiguities are uppercase: M R W S Y K X N\n\n=head2 Example\n\nExample of a contig containing three sequences:\n\n    sequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCGCAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    quality\t0x0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0505050505050505050E0505160505050505050505050505050505050505050505050505050505050303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0404040404040404041604040404040404040404040404040404040404040404040404040404040404040404040404040404040E0404040404040404040B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B\n    asmbl_id\t93\n    seq_id\t\n    com_name\t\n    type\t\n    method\tasmg\n    ed_status\t\n    redundancy\t1.11\n    perc_N\t0.20\n    seq#\t3\n    full_cds\t\n    cds_start\t\n    cds_end\t\n    ed_pn\tGRA\n    ed_date\t08/16/07 17:10:12\n    comment\t\n    frameshift\t\n\n    seq_name\tSDSU_RFPERU_010_C09.x01.phd.1\n    asm_lend\t1\n    asm_rend\t4423\n    seq_lend\t1\n    seq_rend\t442\n    best\t0\n    comment\t\n    db\t\n    offset\t0\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAGCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGG\n\n    seq_name\tSDSU_RFPERU_002_H12.x01.phd.1\n    asm_lend\t339\n    asm_rend\t940\n    seq_lend\t1\n    seq_rend\t602\n    best\t0\n    comment\t\n    db\t\n    offset\t338\n    lsequence\tCGAGATTCGCCACCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCCGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATA-GCGTGGCGC\n\n    seq_name\tSDSU_RFPERU_009_E07.x01.phd.1\n    asm_lend\t880\n    asm_rend\t1520\n    seq_lend\t641\n    seq_rend\t1\n    best\t0\n    comment\t\n    db\t\n    offset\t8803\n    lsequence\tCGCACGGTCTGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAAGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    |\n\n...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent dot angly at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::IO::tigr;\n\nuse strict;\nuse Bio::Seq::Quality;\nuse Bio::LocatableSeq;\nuse Bio::Assembly::IO;\nuse Bio::Assembly::Scaffold;\nuse Bio::Assembly::Contig;\nuse Bio::Assembly::Singlet;\n\nuse base qw(Bio::Assembly::IO);\n\nmy $progname = 'TIGR Assembler';\n\n=head2 next_assembly\n\n Title   : next_assembly\n Usage   : my $scaffold = $asmio->next_assembly()\n Function: return the next assembly in the tasm-formatted stream\n Returns : Bio::Assembly::Scaffold object\n Args    : none\n\n\nsub next_assembly {\n    my $self = shift; # object reference\n    \n    # Create a new scaffold to hold the contigs\n    my $scaffoldobj = Bio::Assembly::Scaffold->new(-source => $progname);\n    \n    # Contig and read related\n    my $contigobj;\n    my $iscontig = 1;\n    my %contiginfo;\n    my $isread = 0;\n    my %readinfo;\n    \n    # Loop over all assembly file lines\n    while ($_ = $self->_readline) {\n        chomp;\n        if ( /^\\|/ ) {  # a line with a single pipe |\n            # The end of a read from a contig, the start of a new contig\n            $iscontig = 1;\n            $isread   = 0;\n            # Store read info\n            if ($contiginfo{'seqnum'} > 1) {\n                # This is a read in a contig\n                my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n            } elsif ($contiginfo{'seqnum'} == 1) {\n                # This is a singlet\n                my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                    $scaffoldobj);\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n            # Clear read info\n            undef %readinfo;\n            # Clear contig info\n            undef $contigobj;\n            undef %contiginfo;\n        } elsif ( /^$/ ) {  # a blank line\n            if ($iscontig) {\n                # The end of a contig, the start of a read in that contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store contig info\n                $contigobj = $self->_store_contig( \\%contiginfo, $contigobj,\n                    $scaffoldobj ) if $contiginfo{'seqnum'} > 1;\n            } elsif ($isread) {\n                # The end of read in a contig, the start of a new one in\n                # the same contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store read info\n                if ($contiginfo{'seqnum'} > 1) {\n                    # This is a read in a contig\n                    my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n                } elsif ($contiginfo{'seqnum'} == 1) {\n                    # This is a singlet\n                    my $singletobj = $self->_store_singlet(\\%readinfo,\n                        \\%contiginfo, $scaffoldobj);\n                } else {\n                  # That should not happen\n                  $self->throw(\"Unhandled exception\");\n                }\n                # Clear read info\n                undef %readinfo;\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n        } else {\n            if ($iscontig) {\n                # Parse contig\n                if    (/^sequence\\t(.*)/)     {$contiginfo{'sequence'}   = $1; next}\n                elsif (/^lsequence\\t(.*)/)    {$contiginfo{'lsequence'}  = $1; next}\n                elsif (/^quality\\t(.*)/)      {$contiginfo{'quality'}    = $1; next}\n                elsif (/^asmbl_id\\t(.*)/)     {$contiginfo{'asmbl_id'}   = $1; next}\n                elsif (/^seq_id\\t(.*)/)       {$contiginfo{'seq_id'}     = $1; next}\n                elsif (/^com_name\\t(.*)/)     {$contiginfo{'com_name'}   = $1; next}\n                elsif (/^type\\t(.*)/)         {$contiginfo{'type'}       = $1; next}\n                elsif (/^method\\t(.*)/)       {$contiginfo{'method'}     = $1; next}\n                elsif (/^ed_status\\t(.*)/)    {$contiginfo{'ed_status'}  = $1; next}\n                elsif (/^redundancy\\t(.*)/)   {$contiginfo{'redundancy'} = $1; next}\n                elsif (/^perc_N\\t(.*)/)       {$contiginfo{'perc_N'}     = $1; next}\n                elsif (/^seq\\#\\t(.*)/)        {$contiginfo{'seqnum'}     = $1; next}\n                elsif (/^full_cds\\t(.*)/)     {$contiginfo{'full_cds'}   = $1; next}\n                elsif (/^cds_start\\t(.*)/)    {$contiginfo{'cds_start'}  = $1; next}\n                elsif (/^cds_end\\t(.*)/)      {$contiginfo{'cds_end'}    = $1; next}\n                elsif (/^ed_pn\\t(.*)/)        {$contiginfo{'ed_pn'}      = $1; next}\n                elsif (/^ed_date\\t(.*\\s.*)/)  {$contiginfo{'ed_date'}    = $1; next}\n                elsif (/^comment\\t(.*)/)      {$contiginfo{'comment'}    = $1; next}\n                elsif (/^frameshift\\t(.*)/)   {$contiginfo{'frameshift'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } elsif ($isread) {\n                # Parse read info\n                if    (/^seq_name\\t(.*)/)  {$readinfo{'seq_name'}  = $1; next}\n                elsif (/^asm_lend\\t(.*)/)  {$readinfo{'asm_lend'}  = $1; next}\n                elsif (/^asm_rend\\t(.*)/)  {$readinfo{'asm_rend'}  = $1; next}\n                elsif (/^seq_lend\\t(.*)/)  {$readinfo{'seq_lend'}  = $1; next}\n                elsif (/^seq_rend\\t(.*)/)  {$readinfo{'seq_rend'}  = $1; next}\n                elsif (/^best\\t(.*)/)      {$readinfo{'best'}      = $1; next}\n                elsif (/^comment\\t(.*)/)   {$readinfo{'comment'}   = $1; next}\n                elsif (/^db\\t(.*)/)        {$readinfo{'db'}        = $1; next}\n                elsif (/^offset\\t(.*)/)    {$readinfo{'offset'}    = $1; next}\n                elsif (/^lsequence\\t(.*)/) {$readinfo{'lsequence'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } else {\n                # That shouldn't happen\n                $self->throw(\"Unhandled exception\");                \n            }\n        }\n    }\n    # Store read info for last read\n    if (defined $contiginfo{'seqnum'}) {\n        if ($contiginfo{'seqnum'} > 1) {\n            # This is a read in a contig\n            my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n        } elsif ($contiginfo{'seqnum'} == 1) {\n            # This is a singlet\n            my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                $scaffoldobj);\n        } else {\n            # That should not happen\n            $self->throw(\"Unhandled exception\");\n        }\n    }\n    # Clear read info for last read\n    undef %readinfo;\n    # Clear contig info for last contig\n    undef $contigobj;\n    undef %contiginfo;\n    \n    $scaffoldobj->update_seq_list();\n    \n    return $scaffoldobj;\n}\n\n=head2 _qual_hex2dec\n\n    Title   : _qual_hex2dec\n    Usage   : my dec_quality = $self->_qual_hex2dec($hex_quality);\n    Function: convert an hexadecimal quality score into a decimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_hex2dec {\n    my ($self, $qual) = @_;\n    $qual =~ s/^0x(.*)$/$1/;\n    $qual =~ s/(..)/hex($1).' '/eg;\n    return $qual;\n}\n\n=head2 _qual_dec2hex\n\n    Title   : _qual_dec2hex\n    Usage   : my hex_quality = $self->_qual_dec2hex($dec_quality);\n    Function: convert a decimal quality score into an hexadecimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_dec2hex {\n    my ($self, $qual) = @_;\n    $qual =~ s/(\\d+)\\s*/sprintf('%02X', $1)/eg;\n    $qual = '0x'.$qual;\n    return $qual;\n}\n\n=head2 _store_contig\n\n    Title   : _store_contig\n    Usage   : my $contigobj; $contigobj = $self->_store_contig(\n              \\%contiginfo, $contigobj, $scaffoldobj);\n    Function: store information of a contig belonging to a scaffold in the\n              appropriate object\n    Returns : Bio::Assembly::Contig object\n    Args    : hash, Bio::Assembly::Contig, Bio::Assembly::Scaffold\n\n\nsub _store_contig {\n    my ($self, $contiginfo, $contigobj, $scaffoldobj) = @_;\n\n    # Create a contig and attach it to scaffold\n    $contigobj = Bio::Assembly::Contig->new(\n        -id     => $$contiginfo{'asmbl_id'},\n        -source => $progname,\n        -strand => 1\n    );\n    $scaffoldobj->add_contig($contigobj);\n\n    # Create a gapped consensus sequence and attach it to contig\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $consensus = Bio::LocatableSeq->new(\n        -id    => $$contiginfo{'asmbl_id'},\n        -seq   => $$contiginfo{'lsequence'},\n        -start => 1,\n    );\n    $contigobj->set_consensus_sequence($consensus);\n\n    # Create an gapped consensus quality score and attach it to contig\n    $$contiginfo{'quality'} = $self->_qual_hex2dec($$contiginfo{'quality'});\n    my $qual = Bio::Seq::Quality->new(\n        -id   => $$contiginfo{'asmbl_id'},\n        -qual => $$contiginfo{'quality'}\n    );\n    $contigobj->set_consensus_quality($qual);\n\n    # Add other misc contig information as features of the contig\n    my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$$contiginfo{'asmbl_id'}\",\n        -start       => 1,\n        -end         => $contigobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n    );\n    $contigobj->add_features([ $contigtags ], 1);\n\n    return $contigobj;\n}\n\n=head2 _store_read\n\n    Title   : _store_read\n    Usage   : my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n    Function: store information of a read belonging to a contig in the appropriate object\n    Returns : Bio::LocatableSeq\n    Args    : hash, Bio::Assembly::Contig"}},{"name":"readinfo","kind":12,"line":506},{"kind":12,"line":506,"name":"readinfo"},{"name":"readinfo","kind":12,"line":506},{"containerName":"LocatableSeq","name":"Bio","line":507,"kind":12},{"line":510,"kind":12,"name":"readinfo"},{"name":"readinfo","kind":12,"line":510},{"name":"readinfo","kind":12,"line":511},{"name":"readinfo","kind":12,"line":511},{"name":"readinfo","line":512,"kind":12},{"name":"readinfo","line":514,"kind":12},{"name":"readinfo","line":519,"kind":12},{"name":"readinfo","kind":12,"line":519},{"line":520,"kind":12,"name":"readinfo"},{"name":"readinfo","kind":12,"line":520},{"kind":12,"line":520,"name":"readinfo"},{"line":521,"kind":12,"containerName":"SeqFeature::Generic","name":"Bio"},{"kind":12,"line":523,"name":"readinfo"},{"line":524,"kind":12,"name":"readinfo"},{"kind":12,"line":525,"name":"readinfo"},{"name":"readinfo","kind":12,"line":532},{"kind":12,"line":532,"name":"readinfo"},{"name":"readinfo","line":533,"kind":12},{"name":"readinfo","kind":12,"line":533},{"name":"Bio","containerName":"SeqFeature::Generic","line":534,"kind":12},{"line":536,"kind":12,"name":"readinfo"},{"line":537,"kind":12,"name":"readinfo"},{"name":"readinfo","line":538,"kind":12},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":544},{"name":"readinfo","line":546,"kind":12},{"name":"readinfo","line":547,"kind":12},{"name":"readinfo","kind":12,"line":548},{"kind":12,"line":549,"name":"readinfo"},{"name":"readinfo","kind":12,"line":550},{"containerName":"main::","definition":"sub","detail":"($self,$readinfo,$contiginfo,$scaffoldobj)","signature":{"label":"_store_singlet($self,$readinfo,$contiginfo,$scaffoldobj)","documentation":"__END__\n# $Id: tigr.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO::tigr\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO::tigr - Driver to read and write assembly files in the TIGR\nAssembler v2 default format.\n\n=head1 SYNOPSIS\n\n    # Building an input stream\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $asmio = Bio::Assembly::IO->new( -file   => 'SGC0-424.tasm',\n                                        -format => 'tigr' );\n    my $scaffold = $asmio->next_assembly;\n\n    # Do some things on contigs...\n\n    # Assembly writing methods\n    my $outasm = Bio::Assembly::IO->new( -file   => \">SGC0-modified.tasm\",\n                                         -format => 'tigr' );\n    $outasm->write_assembly( -scaffold => $assembly,\n                             -singlets => 1 );\n\n=head1 DESCRIPTION\n\nThis package loads and writes assembly information in/from files in the default\nTIGR Assembler v2 format. The files are lassie-formatted and often have the\n.tasm extension. This module was written to be used as a driver module for\nBio::Assembly::IO input/output.\n\n=head2 Implementation\n\nAssemblies are loaded into Bio::Assembly::Scaffold objects composed of\nBio::Assembly::Contig and Bio::Assembly::Singlet objects. Since aligned reads\nand contig gapped consensus can be obtained in the tasm files, only\naligned/gapped sequences are added to the different BioPerl objects.\n\nAdditional assembly information is stored as features. Contig objects have\nSeqFeature information associated with the primary_tag:\n\n    _main_contig_feature:$contig_id -> misc contig information\n    _quality_clipping:$read_id      -> quality clipping position\n\nRead objects have sub_seqFeature information associated with the\nprimary_tag:\n\n    _main_read_feature:$read_id     -> misc read information\n\nSinglets are considered by TIGR Assembler as contigs of one sequence and are\nrepresented here with features having these primary_tag: \n\n    _main_contig_feature:$contig_id\n    _quality_clipping:$read_primary_id\n    _main_read_feature:$read_primary_id\n    _aligned_coord:$read_primary_id\n\n=head1 THE TIGR TASM LASSIEFORMAT\n\n=head2 Description\n\nIn the TIGR tasm lassie format, contigs are separated by a line containing a single\npipe character \"|\", whereas the reads in a contig are separated by a blank line.\nSinglets can be present in the file and are represented as a contig\ncomposed of a single sequence.\n\nOther than the two above-mentioned separators, each line has an attribute name,\nfollowed a tab and then an attribute value.\n\nThe tasm format is used by more TIGR applications than just TIGR Assembler.\nSome of the attributes are not used by TIGR Assembler or have constant values.\nThey are indicated by an asterisk *\n\nContigs have the following attributes:\n\n    asmbl_id   -> contig ID\n    sequence   -> contig ungapped consensus sequence (ambiguities are lowercase)\n    lsequence  -> gapped consensus sequence (lowercase ambiguities)\n    quality    -> gapped consensus quality score (in hexadecimal)\n    seq_id     -> *\n    com_name   -> *\n    type       -> *\n    method     -> always 'asmg' *\n    ed_status  -> *\n    redundancy -> fold coverage of the contig consensus\n    perc_N     -> percent of ambiguities in the contig consensus\n    seq#       -> number of sequences in the contig\n    full_cds   -> *\n    cds_start  -> start of coding sequence *\n    cds_end    -> end of coding sequence *\n    ed_pn      -> name of editor (always 'GRA') *\n    ed_date    -> date and time of edition\n    comment    -> some comments *\n    frameshift -> *\n\nEach read has the following attributes:\n\n    seq_name  -> read name\n    asm_lend  -> position of first base on contig ungapped consensus sequence\n    asm_rend  -> position of last base on contig ungapped consensus sequence\n    seq_lend  -> start of quality-trimmed sequence (aligned read coordinates)\n    seq_rend  -> end of quality-trimmed sequence (aligned read coordinates)\n    best      -> always '0' *\n    comment   -> some comments *\n    db        -> database name associated with the sequence (e.g. >my_db|seq1234)\n    offset    -> offset of the sequence (gapped consensus coordinates)\n    lsequence -> aligned read sequence (ambiguities are uppercase)\n\nWhen asm_rend E<lt> asm_lend, the sequence was on the complementary DNA strand but\nits reverse complement is shown in the aligned sequence of the assembly file,\nnot the original read.\n\nAmbiguities are reflected in the contig consensus sequence as\nlowercase IUPAC characters: a c g t u m r w s y k x n . In the read\nsequences, however, ambiguities are uppercase: M R W S Y K X N\n\n=head2 Example\n\nExample of a contig containing three sequences:\n\n    sequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCGCAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    quality\t0x0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0505050505050505050E0505160505050505050505050505050505050505050505050505050505050303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0404040404040404041604040404040404040404040404040404040404040404040404040404040404040404040404040404040E0404040404040404040B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B\n    asmbl_id\t93\n    seq_id\t\n    com_name\t\n    type\t\n    method\tasmg\n    ed_status\t\n    redundancy\t1.11\n    perc_N\t0.20\n    seq#\t3\n    full_cds\t\n    cds_start\t\n    cds_end\t\n    ed_pn\tGRA\n    ed_date\t08/16/07 17:10:12\n    comment\t\n    frameshift\t\n\n    seq_name\tSDSU_RFPERU_010_C09.x01.phd.1\n    asm_lend\t1\n    asm_rend\t4423\n    seq_lend\t1\n    seq_rend\t442\n    best\t0\n    comment\t\n    db\t\n    offset\t0\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAGCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGG\n\n    seq_name\tSDSU_RFPERU_002_H12.x01.phd.1\n    asm_lend\t339\n    asm_rend\t940\n    seq_lend\t1\n    seq_rend\t602\n    best\t0\n    comment\t\n    db\t\n    offset\t338\n    lsequence\tCGAGATTCGCCACCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCCGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATA-GCGTGGCGC\n\n    seq_name\tSDSU_RFPERU_009_E07.x01.phd.1\n    asm_lend\t880\n    asm_rend\t1520\n    seq_lend\t641\n    seq_rend\t1\n    best\t0\n    comment\t\n    db\t\n    offset\t8803\n    lsequence\tCGCACGGTCTGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAAGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    |\n\n...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent dot angly at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::IO::tigr;\n\nuse strict;\nuse Bio::Seq::Quality;\nuse Bio::LocatableSeq;\nuse Bio::Assembly::IO;\nuse Bio::Assembly::Scaffold;\nuse Bio::Assembly::Contig;\nuse Bio::Assembly::Singlet;\n\nuse base qw(Bio::Assembly::IO);\n\nmy $progname = 'TIGR Assembler';\n\n=head2 next_assembly\n\n Title   : next_assembly\n Usage   : my $scaffold = $asmio->next_assembly()\n Function: return the next assembly in the tasm-formatted stream\n Returns : Bio::Assembly::Scaffold object\n Args    : none\n\n\nsub next_assembly {\n    my $self = shift; # object reference\n    \n    # Create a new scaffold to hold the contigs\n    my $scaffoldobj = Bio::Assembly::Scaffold->new(-source => $progname);\n    \n    # Contig and read related\n    my $contigobj;\n    my $iscontig = 1;\n    my %contiginfo;\n    my $isread = 0;\n    my %readinfo;\n    \n    # Loop over all assembly file lines\n    while ($_ = $self->_readline) {\n        chomp;\n        if ( /^\\|/ ) {  # a line with a single pipe |\n            # The end of a read from a contig, the start of a new contig\n            $iscontig = 1;\n            $isread   = 0;\n            # Store read info\n            if ($contiginfo{'seqnum'} > 1) {\n                # This is a read in a contig\n                my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n            } elsif ($contiginfo{'seqnum'} == 1) {\n                # This is a singlet\n                my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                    $scaffoldobj);\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n            # Clear read info\n            undef %readinfo;\n            # Clear contig info\n            undef $contigobj;\n            undef %contiginfo;\n        } elsif ( /^$/ ) {  # a blank line\n            if ($iscontig) {\n                # The end of a contig, the start of a read in that contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store contig info\n                $contigobj = $self->_store_contig( \\%contiginfo, $contigobj,\n                    $scaffoldobj ) if $contiginfo{'seqnum'} > 1;\n            } elsif ($isread) {\n                # The end of read in a contig, the start of a new one in\n                # the same contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store read info\n                if ($contiginfo{'seqnum'} > 1) {\n                    # This is a read in a contig\n                    my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n                } elsif ($contiginfo{'seqnum'} == 1) {\n                    # This is a singlet\n                    my $singletobj = $self->_store_singlet(\\%readinfo,\n                        \\%contiginfo, $scaffoldobj);\n                } else {\n                  # That should not happen\n                  $self->throw(\"Unhandled exception\");\n                }\n                # Clear read info\n                undef %readinfo;\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n        } else {\n            if ($iscontig) {\n                # Parse contig\n                if    (/^sequence\\t(.*)/)     {$contiginfo{'sequence'}   = $1; next}\n                elsif (/^lsequence\\t(.*)/)    {$contiginfo{'lsequence'}  = $1; next}\n                elsif (/^quality\\t(.*)/)      {$contiginfo{'quality'}    = $1; next}\n                elsif (/^asmbl_id\\t(.*)/)     {$contiginfo{'asmbl_id'}   = $1; next}\n                elsif (/^seq_id\\t(.*)/)       {$contiginfo{'seq_id'}     = $1; next}\n                elsif (/^com_name\\t(.*)/)     {$contiginfo{'com_name'}   = $1; next}\n                elsif (/^type\\t(.*)/)         {$contiginfo{'type'}       = $1; next}\n                elsif (/^method\\t(.*)/)       {$contiginfo{'method'}     = $1; next}\n                elsif (/^ed_status\\t(.*)/)    {$contiginfo{'ed_status'}  = $1; next}\n                elsif (/^redundancy\\t(.*)/)   {$contiginfo{'redundancy'} = $1; next}\n                elsif (/^perc_N\\t(.*)/)       {$contiginfo{'perc_N'}     = $1; next}\n                elsif (/^seq\\#\\t(.*)/)        {$contiginfo{'seqnum'}     = $1; next}\n                elsif (/^full_cds\\t(.*)/)     {$contiginfo{'full_cds'}   = $1; next}\n                elsif (/^cds_start\\t(.*)/)    {$contiginfo{'cds_start'}  = $1; next}\n                elsif (/^cds_end\\t(.*)/)      {$contiginfo{'cds_end'}    = $1; next}\n                elsif (/^ed_pn\\t(.*)/)        {$contiginfo{'ed_pn'}      = $1; next}\n                elsif (/^ed_date\\t(.*\\s.*)/)  {$contiginfo{'ed_date'}    = $1; next}\n                elsif (/^comment\\t(.*)/)      {$contiginfo{'comment'}    = $1; next}\n                elsif (/^frameshift\\t(.*)/)   {$contiginfo{'frameshift'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } elsif ($isread) {\n                # Parse read info\n                if    (/^seq_name\\t(.*)/)  {$readinfo{'seq_name'}  = $1; next}\n                elsif (/^asm_lend\\t(.*)/)  {$readinfo{'asm_lend'}  = $1; next}\n                elsif (/^asm_rend\\t(.*)/)  {$readinfo{'asm_rend'}  = $1; next}\n                elsif (/^seq_lend\\t(.*)/)  {$readinfo{'seq_lend'}  = $1; next}\n                elsif (/^seq_rend\\t(.*)/)  {$readinfo{'seq_rend'}  = $1; next}\n                elsif (/^best\\t(.*)/)      {$readinfo{'best'}      = $1; next}\n                elsif (/^comment\\t(.*)/)   {$readinfo{'comment'}   = $1; next}\n                elsif (/^db\\t(.*)/)        {$readinfo{'db'}        = $1; next}\n                elsif (/^offset\\t(.*)/)    {$readinfo{'offset'}    = $1; next}\n                elsif (/^lsequence\\t(.*)/) {$readinfo{'lsequence'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } else {\n                # That shouldn't happen\n                $self->throw(\"Unhandled exception\");                \n            }\n        }\n    }\n    # Store read info for last read\n    if (defined $contiginfo{'seqnum'}) {\n        if ($contiginfo{'seqnum'} > 1) {\n            # This is a read in a contig\n            my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n        } elsif ($contiginfo{'seqnum'} == 1) {\n            # This is a singlet\n            my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                $scaffoldobj);\n        } else {\n            # That should not happen\n            $self->throw(\"Unhandled exception\");\n        }\n    }\n    # Clear read info for last read\n    undef %readinfo;\n    # Clear contig info for last contig\n    undef $contigobj;\n    undef %contiginfo;\n    \n    $scaffoldobj->update_seq_list();\n    \n    return $scaffoldobj;\n}\n\n=head2 _qual_hex2dec\n\n    Title   : _qual_hex2dec\n    Usage   : my dec_quality = $self->_qual_hex2dec($hex_quality);\n    Function: convert an hexadecimal quality score into a decimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_hex2dec {\n    my ($self, $qual) = @_;\n    $qual =~ s/^0x(.*)$/$1/;\n    $qual =~ s/(..)/hex($1).' '/eg;\n    return $qual;\n}\n\n=head2 _qual_dec2hex\n\n    Title   : _qual_dec2hex\n    Usage   : my hex_quality = $self->_qual_dec2hex($dec_quality);\n    Function: convert a decimal quality score into an hexadecimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_dec2hex {\n    my ($self, $qual) = @_;\n    $qual =~ s/(\\d+)\\s*/sprintf('%02X', $1)/eg;\n    $qual = '0x'.$qual;\n    return $qual;\n}\n\n=head2 _store_contig\n\n    Title   : _store_contig\n    Usage   : my $contigobj; $contigobj = $self->_store_contig(\n              \\%contiginfo, $contigobj, $scaffoldobj);\n    Function: store information of a contig belonging to a scaffold in the\n              appropriate object\n    Returns : Bio::Assembly::Contig object\n    Args    : hash, Bio::Assembly::Contig, Bio::Assembly::Scaffold\n\n\nsub _store_contig {\n    my ($self, $contiginfo, $contigobj, $scaffoldobj) = @_;\n\n    # Create a contig and attach it to scaffold\n    $contigobj = Bio::Assembly::Contig->new(\n        -id     => $$contiginfo{'asmbl_id'},\n        -source => $progname,\n        -strand => 1\n    );\n    $scaffoldobj->add_contig($contigobj);\n\n    # Create a gapped consensus sequence and attach it to contig\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $consensus = Bio::LocatableSeq->new(\n        -id    => $$contiginfo{'asmbl_id'},\n        -seq   => $$contiginfo{'lsequence'},\n        -start => 1,\n    );\n    $contigobj->set_consensus_sequence($consensus);\n\n    # Create an gapped consensus quality score and attach it to contig\n    $$contiginfo{'quality'} = $self->_qual_hex2dec($$contiginfo{'quality'});\n    my $qual = Bio::Seq::Quality->new(\n        -id   => $$contiginfo{'asmbl_id'},\n        -qual => $$contiginfo{'quality'}\n    );\n    $contigobj->set_consensus_quality($qual);\n\n    # Add other misc contig information as features of the contig\n    my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$$contiginfo{'asmbl_id'}\",\n        -start       => 1,\n        -end         => $contigobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n    );\n    $contigobj->add_features([ $contigtags ], 1);\n\n    return $contigobj;\n}\n\n=head2 _store_read\n\n    Title   : _store_read\n    Usage   : my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n    Function: store information of a read belonging to a contig in the appropriate object\n    Returns : Bio::LocatableSeq\n    Args    : hash, Bio::Assembly::Contig\n\n\nsub _store_read {\n   my ($self, $readinfo, $contigobj) = @_;\n\n   # Create an aligned read object\n   #$$readinfo{'llength'} = length($$readinfo{'lsequence'});\n   $$readinfo{'strand'}  = ($$readinfo{'seq_rend'} > $$readinfo{'seq_lend'} ? 1 : -1);\n   my $readobj = Bio::LocatableSeq->new(\n       # the ids of sequence objects are supposed to include the db name in it, i.e. \"big_db|seq1234\"\n       # that's how sequence ids coming from the fasta parser are at least\n       -display_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -primary_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -seq        => $$readinfo{'lsequence'},      \n       -start      => 1,\n       -strand     => $$readinfo{'strand'},\n       -alphabet   => 'dna'\n   );\n\n   # Add read location and sequence to contig (in 'gapped consensus' coordinates)\n   $$readinfo{'aln_start'} = $$readinfo{'offset'} + 1; # seq offset is in gapped coordinates\n   $$readinfo{'aln_end'} = $$readinfo{'aln_start'} + length($$readinfo{'lsequence'}) - 1; # lsequence is aligned seq\n   my $alncoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => $readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigobj->id() }\n   );\n   $contigobj->set_seq_coord($alncoord, $readobj);\n\n   # Add quality clipping read information in contig features\n   # (from 'aligned read' to 'gapped consensus' coordinates)\n   $$readinfo{'clip_start'} = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_lend'});\n   $$readinfo{'clip_end'}   = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_rend'});\n   my $clipcoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_quality_clipping:'.$readobj->id,\n       -start       => $$readinfo{'clip_start'},\n       -end         => $$readinfo{'clip_end'},\n       -strand      => $$readinfo{'strand'}\n   );\n   $clipcoord->attach_seq($readobj);\n   $contigobj->add_features([ $clipcoord ], 0);\n   \n   # Add other misc read information as subsequence feature\n   my $readtags = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_main_read_feature:'.$readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'best'    => $$readinfo{'best'},\n                         'comment' => $$readinfo{'comment'} }\n   );\n   $alncoord->add_sub_SeqFeature($readtags);\n\n   return $readobj;\n}\n\n=head2 _store_singlet\n\n    Title   : _store_singlet\n    Usage   : my $singletobj = $self->_store_read(\\%readinfo, \\%contiginfo,\n                  $scaffoldobj);\n    Function: store information of a singlet belonging to a scaffold in the appropriate object\n    Returns : Bio::Assembly::Singlet\n    Args    : hash, hash, Bio::Assembly::Scaffold","parameters":[{"label":"$self"},{"label":"$readinfo"},{"label":"$contiginfo"},{"label":"$scaffoldobj"}]},"kind":12,"line":568,"children":[{"definition":"my","name":"$self","containerName":"_store_singlet","localvar":"my","kind":13,"line":569},{"kind":13,"line":569,"name":"$readinfo","containerName":"_store_singlet"},{"kind":13,"line":569,"containerName":"_store_singlet","name":"$contiginfo"},{"line":569,"kind":13,"name":"$scaffoldobj","containerName":"_store_singlet"},{"localvar":"my","containerName":"_store_singlet","name":"$contigid","definition":"my","line":573,"kind":13},{"line":574,"kind":13,"localvar":"my","containerName":"_store_singlet","definition":"my","name":"$readid"},{"containerName":"_store_singlet","name":"$self","line":574,"kind":13},{"line":574,"kind":12,"containerName":"_store_singlet","name":"_merge_seq_name_and_db"},{"localvar":"my","definition":"my","name":"$seqobj","containerName":"_store_singlet","line":578,"kind":13},{"kind":12,"line":578,"containerName":"_store_singlet","name":"new"},{"kind":13,"line":579,"name":"$contigid","containerName":"_store_singlet"},{"line":580,"kind":13,"containerName":"_store_singlet","name":"$readid"},{"name":"$self","containerName":"_store_singlet","line":585,"kind":13},{"line":585,"kind":12,"containerName":"_store_singlet","name":"_qual_hex2dec"},{"kind":13,"line":589,"containerName":"_store_singlet","name":"$singletobj","definition":"my","localvar":"my"},{"containerName":"_store_singlet","name":"new","kind":12,"line":589},{"containerName":"_store_singlet","name":"$seqobj","line":589,"kind":13},{"kind":13,"line":590,"name":"$scaffoldobj","containerName":"_store_singlet"},{"kind":12,"line":590,"containerName":"_store_singlet","name":"add_singlet"},{"line":590,"kind":13,"name":"$singletobj","containerName":"_store_singlet"},{"localvar":"my","definition":"my","name":"$contigtags","containerName":"_store_singlet","line":593,"kind":13},{"containerName":"_store_singlet","name":"new","kind":12,"line":593},{"kind":13,"line":596,"containerName":"_store_singlet","name":"$singletobj"},{"line":596,"kind":12,"containerName":"_store_singlet","name":"get_consensus_length"},{"line":611,"kind":13,"containerName":"_store_singlet","name":"$singletobj"},{"containerName":"_store_singlet","name":"add_features","kind":12,"line":611},{"containerName":"_store_singlet","name":"$contigtags","kind":13,"line":611},{"line":617,"kind":13,"localvar":"my","containerName":"_store_singlet","name":"$alncoord","definition":"my"},{"name":"new","containerName":"_store_singlet","kind":12,"line":617},{"name":"$contigid","containerName":"_store_singlet","line":622,"kind":13},{"kind":13,"line":624,"containerName":"_store_singlet","name":"$alncoord"},{"kind":12,"line":624,"name":"attach_seq","containerName":"_store_singlet"},{"line":624,"kind":13,"name":"$singletobj","containerName":"_store_singlet"},{"kind":12,"line":624,"name":"seqref","containerName":"_store_singlet"},{"kind":13,"line":625,"containerName":"_store_singlet","name":"$singletobj"},{"containerName":"_store_singlet","name":"add_features","line":625,"kind":12},{"containerName":"_store_singlet","name":"$alncoord","kind":13,"line":625},{"line":631,"kind":13,"localvar":"my","definition":"my","name":"$clipcoord","containerName":"_store_singlet"},{"line":631,"kind":12,"name":"new","containerName":"_store_singlet"},{"containerName":"_store_singlet","name":"$contigid","kind":13,"line":636},{"kind":13,"line":638,"name":"$clipcoord","containerName":"_store_singlet"},{"kind":12,"line":638,"name":"attach_seq","containerName":"_store_singlet"},{"kind":13,"line":638,"containerName":"_store_singlet","name":"$singletobj"},{"line":638,"kind":12,"name":"seqref","containerName":"_store_singlet"},{"containerName":"_store_singlet","name":"$singletobj","line":639,"kind":13},{"containerName":"_store_singlet","name":"add_features","line":639,"kind":12},{"kind":13,"line":639,"containerName":"_store_singlet","name":"$clipcoord"},{"kind":13,"line":642,"name":"$readtags","definition":"my","containerName":"_store_singlet","localvar":"my"},{"line":642,"kind":12,"containerName":"_store_singlet","name":"new"},{"name":"$alncoord","containerName":"_store_singlet","line":650,"kind":13},{"kind":12,"line":650,"containerName":"_store_singlet","name":"add_sub_SeqFeature"},{"name":"$readtags","containerName":"_store_singlet","kind":13,"line":650},{"containerName":"_store_singlet","name":"$singletobj","line":652,"kind":13}],"name":"_store_singlet","range":{"start":{"line":568,"character":0},"end":{"line":653,"character":9999}}},{"name":"contiginfo","line":573,"kind":12},{"kind":12,"line":574,"name":"readinfo"},{"kind":12,"line":574,"name":"readinfo"},{"kind":12,"line":578,"containerName":"Seq::Quality","name":"Bio"},{"kind":12,"line":581,"name":"contiginfo"},{"name":"readinfo","kind":12,"line":583},{"line":585,"kind":12,"name":"contiginfo"},{"kind":12,"line":589,"name":"Bio","containerName":"Assembly::Singlet"},{"containerName":"SeqFeature::Generic","name":"Bio","kind":12,"line":593},{"name":"contiginfo","line":598,"kind":12},{"line":599,"kind":12,"name":"contiginfo"},{"name":"contiginfo","line":600,"kind":12},{"kind":12,"line":601,"name":"contiginfo"},{"name":"contiginfo","line":602,"kind":12},{"name":"contiginfo","kind":12,"line":603},{"kind":12,"line":604,"name":"contiginfo"},{"name":"contiginfo","kind":12,"line":605},{"name":"contiginfo","line":606,"kind":12},{"name":"contiginfo","line":607,"kind":12},{"line":608,"kind":12,"name":"contiginfo"},{"kind":12,"line":609,"name":"contiginfo"},{"kind":12,"line":614,"name":"readinfo"},{"name":"readinfo","kind":12,"line":614},{"line":615,"kind":12,"name":"readinfo"},{"line":615,"kind":12,"name":"readinfo"},{"kind":12,"line":615,"name":"readinfo"},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":617},{"line":619,"kind":12,"name":"readinfo"},{"name":"readinfo","kind":12,"line":620},{"kind":12,"line":621,"name":"readinfo"},{"line":629,"kind":12,"name":"readinfo"},{"line":629,"kind":12,"name":"readinfo"},{"name":"readinfo","line":630,"kind":12},{"kind":12,"line":630,"name":"readinfo"},{"line":631,"kind":12,"containerName":"SeqFeature::Generic","name":"Bio"},{"name":"readinfo","line":633,"kind":12},{"name":"readinfo","line":634,"kind":12},{"kind":12,"line":635,"name":"readinfo"},{"containerName":"SeqFeature::Generic","name":"Bio","kind":12,"line":642},{"name":"readinfo","kind":12,"line":644},{"kind":12,"line":645,"name":"readinfo"},{"line":646,"kind":12,"name":"readinfo"},{"kind":12,"line":647,"name":"readinfo"},{"line":648,"kind":12,"name":"readinfo"},{"detail":"($self,@args)","signature":{"documentation":"__END__\n# $Id: tigr.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO::tigr\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO::tigr - Driver to read and write assembly files in the TIGR\nAssembler v2 default format.\n\n=head1 SYNOPSIS\n\n    # Building an input stream\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $asmio = Bio::Assembly::IO->new( -file   => 'SGC0-424.tasm',\n                                        -format => 'tigr' );\n    my $scaffold = $asmio->next_assembly;\n\n    # Do some things on contigs...\n\n    # Assembly writing methods\n    my $outasm = Bio::Assembly::IO->new( -file   => \">SGC0-modified.tasm\",\n                                         -format => 'tigr' );\n    $outasm->write_assembly( -scaffold => $assembly,\n                             -singlets => 1 );\n\n=head1 DESCRIPTION\n\nThis package loads and writes assembly information in/from files in the default\nTIGR Assembler v2 format. The files are lassie-formatted and often have the\n.tasm extension. This module was written to be used as a driver module for\nBio::Assembly::IO input/output.\n\n=head2 Implementation\n\nAssemblies are loaded into Bio::Assembly::Scaffold objects composed of\nBio::Assembly::Contig and Bio::Assembly::Singlet objects. Since aligned reads\nand contig gapped consensus can be obtained in the tasm files, only\naligned/gapped sequences are added to the different BioPerl objects.\n\nAdditional assembly information is stored as features. Contig objects have\nSeqFeature information associated with the primary_tag:\n\n    _main_contig_feature:$contig_id -> misc contig information\n    _quality_clipping:$read_id      -> quality clipping position\n\nRead objects have sub_seqFeature information associated with the\nprimary_tag:\n\n    _main_read_feature:$read_id     -> misc read information\n\nSinglets are considered by TIGR Assembler as contigs of one sequence and are\nrepresented here with features having these primary_tag: \n\n    _main_contig_feature:$contig_id\n    _quality_clipping:$read_primary_id\n    _main_read_feature:$read_primary_id\n    _aligned_coord:$read_primary_id\n\n=head1 THE TIGR TASM LASSIEFORMAT\n\n=head2 Description\n\nIn the TIGR tasm lassie format, contigs are separated by a line containing a single\npipe character \"|\", whereas the reads in a contig are separated by a blank line.\nSinglets can be present in the file and are represented as a contig\ncomposed of a single sequence.\n\nOther than the two above-mentioned separators, each line has an attribute name,\nfollowed a tab and then an attribute value.\n\nThe tasm format is used by more TIGR applications than just TIGR Assembler.\nSome of the attributes are not used by TIGR Assembler or have constant values.\nThey are indicated by an asterisk *\n\nContigs have the following attributes:\n\n    asmbl_id   -> contig ID\n    sequence   -> contig ungapped consensus sequence (ambiguities are lowercase)\n    lsequence  -> gapped consensus sequence (lowercase ambiguities)\n    quality    -> gapped consensus quality score (in hexadecimal)\n    seq_id     -> *\n    com_name   -> *\n    type       -> *\n    method     -> always 'asmg' *\n    ed_status  -> *\n    redundancy -> fold coverage of the contig consensus\n    perc_N     -> percent of ambiguities in the contig consensus\n    seq#       -> number of sequences in the contig\n    full_cds   -> *\n    cds_start  -> start of coding sequence *\n    cds_end    -> end of coding sequence *\n    ed_pn      -> name of editor (always 'GRA') *\n    ed_date    -> date and time of edition\n    comment    -> some comments *\n    frameshift -> *\n\nEach read has the following attributes:\n\n    seq_name  -> read name\n    asm_lend  -> position of first base on contig ungapped consensus sequence\n    asm_rend  -> position of last base on contig ungapped consensus sequence\n    seq_lend  -> start of quality-trimmed sequence (aligned read coordinates)\n    seq_rend  -> end of quality-trimmed sequence (aligned read coordinates)\n    best      -> always '0' *\n    comment   -> some comments *\n    db        -> database name associated with the sequence (e.g. >my_db|seq1234)\n    offset    -> offset of the sequence (gapped consensus coordinates)\n    lsequence -> aligned read sequence (ambiguities are uppercase)\n\nWhen asm_rend E<lt> asm_lend, the sequence was on the complementary DNA strand but\nits reverse complement is shown in the aligned sequence of the assembly file,\nnot the original read.\n\nAmbiguities are reflected in the contig consensus sequence as\nlowercase IUPAC characters: a c g t u m r w s y k x n . In the read\nsequences, however, ambiguities are uppercase: M R W S Y K X N\n\n=head2 Example\n\nExample of a contig containing three sequences:\n\n    sequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCGCAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    quality\t0x0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0505050505050505050E0505160505050505050505050505050505050505050505050505050505050303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0404040404040404041604040404040404040404040404040404040404040404040404040404040404040404040404040404040E0404040404040404040B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B\n    asmbl_id\t93\n    seq_id\t\n    com_name\t\n    type\t\n    method\tasmg\n    ed_status\t\n    redundancy\t1.11\n    perc_N\t0.20\n    seq#\t3\n    full_cds\t\n    cds_start\t\n    cds_end\t\n    ed_pn\tGRA\n    ed_date\t08/16/07 17:10:12\n    comment\t\n    frameshift\t\n\n    seq_name\tSDSU_RFPERU_010_C09.x01.phd.1\n    asm_lend\t1\n    asm_rend\t4423\n    seq_lend\t1\n    seq_rend\t442\n    best\t0\n    comment\t\n    db\t\n    offset\t0\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAGCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGG\n\n    seq_name\tSDSU_RFPERU_002_H12.x01.phd.1\n    asm_lend\t339\n    asm_rend\t940\n    seq_lend\t1\n    seq_rend\t602\n    best\t0\n    comment\t\n    db\t\n    offset\t338\n    lsequence\tCGAGATTCGCCACCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCCGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATA-GCGTGGCGC\n\n    seq_name\tSDSU_RFPERU_009_E07.x01.phd.1\n    asm_lend\t880\n    asm_rend\t1520\n    seq_lend\t641\n    seq_rend\t1\n    best\t0\n    comment\t\n    db\t\n    offset\t8803\n    lsequence\tCGCACGGTCTGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAAGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    |\n\n...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent dot angly at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::IO::tigr;\n\nuse strict;\nuse Bio::Seq::Quality;\nuse Bio::LocatableSeq;\nuse Bio::Assembly::IO;\nuse Bio::Assembly::Scaffold;\nuse Bio::Assembly::Contig;\nuse Bio::Assembly::Singlet;\n\nuse base qw(Bio::Assembly::IO);\n\nmy $progname = 'TIGR Assembler';\n\n=head2 next_assembly\n\n Title   : next_assembly\n Usage   : my $scaffold = $asmio->next_assembly()\n Function: return the next assembly in the tasm-formatted stream\n Returns : Bio::Assembly::Scaffold object\n Args    : none\n\n\nsub next_assembly {\n    my $self = shift; # object reference\n    \n    # Create a new scaffold to hold the contigs\n    my $scaffoldobj = Bio::Assembly::Scaffold->new(-source => $progname);\n    \n    # Contig and read related\n    my $contigobj;\n    my $iscontig = 1;\n    my %contiginfo;\n    my $isread = 0;\n    my %readinfo;\n    \n    # Loop over all assembly file lines\n    while ($_ = $self->_readline) {\n        chomp;\n        if ( /^\\|/ ) {  # a line with a single pipe |\n            # The end of a read from a contig, the start of a new contig\n            $iscontig = 1;\n            $isread   = 0;\n            # Store read info\n            if ($contiginfo{'seqnum'} > 1) {\n                # This is a read in a contig\n                my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n            } elsif ($contiginfo{'seqnum'} == 1) {\n                # This is a singlet\n                my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                    $scaffoldobj);\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n            # Clear read info\n            undef %readinfo;\n            # Clear contig info\n            undef $contigobj;\n            undef %contiginfo;\n        } elsif ( /^$/ ) {  # a blank line\n            if ($iscontig) {\n                # The end of a contig, the start of a read in that contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store contig info\n                $contigobj = $self->_store_contig( \\%contiginfo, $contigobj,\n                    $scaffoldobj ) if $contiginfo{'seqnum'} > 1;\n            } elsif ($isread) {\n                # The end of read in a contig, the start of a new one in\n                # the same contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store read info\n                if ($contiginfo{'seqnum'} > 1) {\n                    # This is a read in a contig\n                    my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n                } elsif ($contiginfo{'seqnum'} == 1) {\n                    # This is a singlet\n                    my $singletobj = $self->_store_singlet(\\%readinfo,\n                        \\%contiginfo, $scaffoldobj);\n                } else {\n                  # That should not happen\n                  $self->throw(\"Unhandled exception\");\n                }\n                # Clear read info\n                undef %readinfo;\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n        } else {\n            if ($iscontig) {\n                # Parse contig\n                if    (/^sequence\\t(.*)/)     {$contiginfo{'sequence'}   = $1; next}\n                elsif (/^lsequence\\t(.*)/)    {$contiginfo{'lsequence'}  = $1; next}\n                elsif (/^quality\\t(.*)/)      {$contiginfo{'quality'}    = $1; next}\n                elsif (/^asmbl_id\\t(.*)/)     {$contiginfo{'asmbl_id'}   = $1; next}\n                elsif (/^seq_id\\t(.*)/)       {$contiginfo{'seq_id'}     = $1; next}\n                elsif (/^com_name\\t(.*)/)     {$contiginfo{'com_name'}   = $1; next}\n                elsif (/^type\\t(.*)/)         {$contiginfo{'type'}       = $1; next}\n                elsif (/^method\\t(.*)/)       {$contiginfo{'method'}     = $1; next}\n                elsif (/^ed_status\\t(.*)/)    {$contiginfo{'ed_status'}  = $1; next}\n                elsif (/^redundancy\\t(.*)/)   {$contiginfo{'redundancy'} = $1; next}\n                elsif (/^perc_N\\t(.*)/)       {$contiginfo{'perc_N'}     = $1; next}\n                elsif (/^seq\\#\\t(.*)/)        {$contiginfo{'seqnum'}     = $1; next}\n                elsif (/^full_cds\\t(.*)/)     {$contiginfo{'full_cds'}   = $1; next}\n                elsif (/^cds_start\\t(.*)/)    {$contiginfo{'cds_start'}  = $1; next}\n                elsif (/^cds_end\\t(.*)/)      {$contiginfo{'cds_end'}    = $1; next}\n                elsif (/^ed_pn\\t(.*)/)        {$contiginfo{'ed_pn'}      = $1; next}\n                elsif (/^ed_date\\t(.*\\s.*)/)  {$contiginfo{'ed_date'}    = $1; next}\n                elsif (/^comment\\t(.*)/)      {$contiginfo{'comment'}    = $1; next}\n                elsif (/^frameshift\\t(.*)/)   {$contiginfo{'frameshift'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } elsif ($isread) {\n                # Parse read info\n                if    (/^seq_name\\t(.*)/)  {$readinfo{'seq_name'}  = $1; next}\n                elsif (/^asm_lend\\t(.*)/)  {$readinfo{'asm_lend'}  = $1; next}\n                elsif (/^asm_rend\\t(.*)/)  {$readinfo{'asm_rend'}  = $1; next}\n                elsif (/^seq_lend\\t(.*)/)  {$readinfo{'seq_lend'}  = $1; next}\n                elsif (/^seq_rend\\t(.*)/)  {$readinfo{'seq_rend'}  = $1; next}\n                elsif (/^best\\t(.*)/)      {$readinfo{'best'}      = $1; next}\n                elsif (/^comment\\t(.*)/)   {$readinfo{'comment'}   = $1; next}\n                elsif (/^db\\t(.*)/)        {$readinfo{'db'}        = $1; next}\n                elsif (/^offset\\t(.*)/)    {$readinfo{'offset'}    = $1; next}\n                elsif (/^lsequence\\t(.*)/) {$readinfo{'lsequence'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } else {\n                # That shouldn't happen\n                $self->throw(\"Unhandled exception\");                \n            }\n        }\n    }\n    # Store read info for last read\n    if (defined $contiginfo{'seqnum'}) {\n        if ($contiginfo{'seqnum'} > 1) {\n            # This is a read in a contig\n            my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n        } elsif ($contiginfo{'seqnum'} == 1) {\n            # This is a singlet\n            my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                $scaffoldobj);\n        } else {\n            # That should not happen\n            $self->throw(\"Unhandled exception\");\n        }\n    }\n    # Clear read info for last read\n    undef %readinfo;\n    # Clear contig info for last contig\n    undef $contigobj;\n    undef %contiginfo;\n    \n    $scaffoldobj->update_seq_list();\n    \n    return $scaffoldobj;\n}\n\n=head2 _qual_hex2dec\n\n    Title   : _qual_hex2dec\n    Usage   : my dec_quality = $self->_qual_hex2dec($hex_quality);\n    Function: convert an hexadecimal quality score into a decimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_hex2dec {\n    my ($self, $qual) = @_;\n    $qual =~ s/^0x(.*)$/$1/;\n    $qual =~ s/(..)/hex($1).' '/eg;\n    return $qual;\n}\n\n=head2 _qual_dec2hex\n\n    Title   : _qual_dec2hex\n    Usage   : my hex_quality = $self->_qual_dec2hex($dec_quality);\n    Function: convert a decimal quality score into an hexadecimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_dec2hex {\n    my ($self, $qual) = @_;\n    $qual =~ s/(\\d+)\\s*/sprintf('%02X', $1)/eg;\n    $qual = '0x'.$qual;\n    return $qual;\n}\n\n=head2 _store_contig\n\n    Title   : _store_contig\n    Usage   : my $contigobj; $contigobj = $self->_store_contig(\n              \\%contiginfo, $contigobj, $scaffoldobj);\n    Function: store information of a contig belonging to a scaffold in the\n              appropriate object\n    Returns : Bio::Assembly::Contig object\n    Args    : hash, Bio::Assembly::Contig, Bio::Assembly::Scaffold\n\n\nsub _store_contig {\n    my ($self, $contiginfo, $contigobj, $scaffoldobj) = @_;\n\n    # Create a contig and attach it to scaffold\n    $contigobj = Bio::Assembly::Contig->new(\n        -id     => $$contiginfo{'asmbl_id'},\n        -source => $progname,\n        -strand => 1\n    );\n    $scaffoldobj->add_contig($contigobj);\n\n    # Create a gapped consensus sequence and attach it to contig\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $consensus = Bio::LocatableSeq->new(\n        -id    => $$contiginfo{'asmbl_id'},\n        -seq   => $$contiginfo{'lsequence'},\n        -start => 1,\n    );\n    $contigobj->set_consensus_sequence($consensus);\n\n    # Create an gapped consensus quality score and attach it to contig\n    $$contiginfo{'quality'} = $self->_qual_hex2dec($$contiginfo{'quality'});\n    my $qual = Bio::Seq::Quality->new(\n        -id   => $$contiginfo{'asmbl_id'},\n        -qual => $$contiginfo{'quality'}\n    );\n    $contigobj->set_consensus_quality($qual);\n\n    # Add other misc contig information as features of the contig\n    my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$$contiginfo{'asmbl_id'}\",\n        -start       => 1,\n        -end         => $contigobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n    );\n    $contigobj->add_features([ $contigtags ], 1);\n\n    return $contigobj;\n}\n\n=head2 _store_read\n\n    Title   : _store_read\n    Usage   : my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n    Function: store information of a read belonging to a contig in the appropriate object\n    Returns : Bio::LocatableSeq\n    Args    : hash, Bio::Assembly::Contig\n\n\nsub _store_read {\n   my ($self, $readinfo, $contigobj) = @_;\n\n   # Create an aligned read object\n   #$$readinfo{'llength'} = length($$readinfo{'lsequence'});\n   $$readinfo{'strand'}  = ($$readinfo{'seq_rend'} > $$readinfo{'seq_lend'} ? 1 : -1);\n   my $readobj = Bio::LocatableSeq->new(\n       # the ids of sequence objects are supposed to include the db name in it, i.e. \"big_db|seq1234\"\n       # that's how sequence ids coming from the fasta parser are at least\n       -display_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -primary_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -seq        => $$readinfo{'lsequence'},      \n       -start      => 1,\n       -strand     => $$readinfo{'strand'},\n       -alphabet   => 'dna'\n   );\n\n   # Add read location and sequence to contig (in 'gapped consensus' coordinates)\n   $$readinfo{'aln_start'} = $$readinfo{'offset'} + 1; # seq offset is in gapped coordinates\n   $$readinfo{'aln_end'} = $$readinfo{'aln_start'} + length($$readinfo{'lsequence'}) - 1; # lsequence is aligned seq\n   my $alncoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => $readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigobj->id() }\n   );\n   $contigobj->set_seq_coord($alncoord, $readobj);\n\n   # Add quality clipping read information in contig features\n   # (from 'aligned read' to 'gapped consensus' coordinates)\n   $$readinfo{'clip_start'} = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_lend'});\n   $$readinfo{'clip_end'}   = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_rend'});\n   my $clipcoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_quality_clipping:'.$readobj->id,\n       -start       => $$readinfo{'clip_start'},\n       -end         => $$readinfo{'clip_end'},\n       -strand      => $$readinfo{'strand'}\n   );\n   $clipcoord->attach_seq($readobj);\n   $contigobj->add_features([ $clipcoord ], 0);\n   \n   # Add other misc read information as subsequence feature\n   my $readtags = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_main_read_feature:'.$readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'best'    => $$readinfo{'best'},\n                         'comment' => $$readinfo{'comment'} }\n   );\n   $alncoord->add_sub_SeqFeature($readtags);\n\n   return $readobj;\n}\n\n=head2 _store_singlet\n\n    Title   : _store_singlet\n    Usage   : my $singletobj = $self->_store_read(\\%readinfo, \\%contiginfo,\n                  $scaffoldobj);\n    Function: store information of a singlet belonging to a scaffold in the appropriate object\n    Returns : Bio::Assembly::Singlet\n    Args    : hash, hash, Bio::Assembly::Scaffold\n\n\nsub _store_singlet {\n    my ($self, $readinfo, $contiginfo, $scaffoldobj) = @_;\n    # Singlets in TIGR_Assembler are represented as a contig of one sequence\n    # We try to simulate this duality by playing around with the Singlet object\n    \n    my $contigid = $$contiginfo{'asmbl_id'};\n    my $readid   = $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'});\n    \n    # Create a sequence object\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $seqobj = Bio::Seq::Quality->new(\n       -primary_id => $contigid, # unique id in assembly (contig name)\n       -display_id => $readid,\n       -seq        => $$contiginfo{'lsequence'}, # do not use $$readinfo as ambiguities are uppercase\n       -start      => 1,\n       -strand     => $$readinfo{'strand'},\n       -alphabet   => 'dna',\n       -qual => $self->_qual_hex2dec($$contiginfo{'quality'})    \n   );\n\n   # Create singlet from sequence and add it to scaffold\n   my $singletobj = Bio::Assembly::Singlet->new( -seqref => $seqobj );\n   $scaffoldobj->add_singlet($singletobj);\n\n   # Add other misc contig information as features of the singlet\n   my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$contigid\",\n        -start       => 1,\n        -end         => $singletobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n   );\n   $singletobj->add_features([ $contigtags ], 1);\n\n   # Add read location and sequence to singlet features (in 'gapped consensus' coordinates)\n   $$readinfo{'aln_start'} = $$readinfo{'offset'} + 1; # seq offset is in gapped coordinates\n   $$readinfo{'aln_end'} = $$readinfo{'aln_start'} + length($$readinfo{'lsequence'}) - 1; # lsequence is aligned seq\n\n   my $alncoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_aligned_coord:$readid\",\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigid }\n   );\n   $alncoord->attach_seq($singletobj->seqref);\n   $singletobj->add_features([ $alncoord ], 0);\n\n   # Add quality clipping read information in singlet features\n   # (from 'aligned read' to 'gapped consensus' coordinates)\n   $$readinfo{'clip_start'} = $$readinfo{'seq_lend'};\n   $$readinfo{'clip_end'}   = $$readinfo{'seq_rend'};\n   my $clipcoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_quality_clipping:$readid\",\n       -start       => $$readinfo{'clip_start'},\n       -end         => $$readinfo{'clip_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigid }\n   );\n   $clipcoord->attach_seq($singletobj->seqref);\n   $singletobj->add_features([ $clipcoord ], 0);\n   \n   # Add other misc read information as subsequence feature\n   my $readtags = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_main_read_feature:$readid\",\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'best'    => $$readinfo{'best'},\n                         'comment' => $$readinfo{'comment'} }\n   );\n   $alncoord->add_sub_SeqFeature($readtags);\n      \n   return $singletobj;\n}\n\n=head2 write_assembly\n\n    Title   : write_assembly\n    Usage   : $ass_io->write_assembly($assembly)\n    Function: Write the assembly object in TIGR Assembler compatible tasm lassie  \n              format\n    Returns : 1 on success, 0 for error\n    Args    : A Bio::Assembly::Scaffold object","parameters":[{"label":"$self"},{"label":"@args"}],"label":"write_assembly($self,@args)"},"containerName":"main::","definition":"sub","line":666,"children":[{"line":667,"kind":13,"localvar":"my","containerName":"write_assembly","name":"$self","definition":"my"},{"line":667,"kind":13,"name":"@args","containerName":"write_assembly"},{"line":668,"kind":13,"localvar":"my","definition":"my","name":"$scaffoldobj","containerName":"write_assembly"},{"line":668,"kind":13,"name":"$singlets","containerName":"write_assembly"},{"kind":13,"line":668,"name":"$self","containerName":"write_assembly"},{"kind":12,"line":668,"containerName":"write_assembly","name":"_rearrange"},{"kind":13,"line":668,"name":"@args","containerName":"write_assembly"},{"name":"$scaffoldobj","containerName":"write_assembly","line":671,"kind":13},{"containerName":"write_assembly","name":"$scaffoldobj","kind":13,"line":671},{"kind":12,"line":671,"containerName":"write_assembly","name":"isa"},{"name":"$self","containerName":"write_assembly","kind":13,"line":672},{"name":"warn","containerName":"write_assembly","line":672,"kind":12},{"kind":13,"line":678,"name":"@cont_ids","definition":"my","containerName":"write_assembly","localvar":"my"},{"kind":13,"line":678,"containerName":"write_assembly","name":"$scaffoldobj"},{"kind":12,"line":678,"name":"get_contig_ids","containerName":"write_assembly"},{"kind":13,"line":679,"containerName":"write_assembly","definition":"my","name":"@sing_ids","localvar":"my"},{"line":679,"kind":13,"name":"$scaffoldobj","containerName":"write_assembly"},{"containerName":"write_assembly","name":"get_singlet_ids","line":679,"kind":12},{"line":680,"kind":13,"localvar":"my","containerName":"write_assembly","name":"%did","definition":"my"},{"line":681,"kind":13,"localvar":"my","definition":"my","name":"$decimal_format","containerName":"write_assembly"},{"localvar":"my","name":"$i","definition":"my","containerName":"write_assembly","line":682,"kind":13},{"line":682,"kind":13,"containerName":"write_assembly","name":"$i"},{"name":"@sing_ids","containerName":"write_assembly","line":682,"kind":13},{"kind":13,"line":682,"name":"$i","containerName":"write_assembly"},{"kind":13,"line":684,"definition":"my","name":"$display_id","containerName":"write_assembly","localvar":"my"},{"containerName":"write_assembly","name":"$sing_ids","kind":13,"line":684},{"line":684,"kind":13,"containerName":"write_assembly","name":"$i"},{"kind":13,"line":686,"name":"$primary_id","definition":"my","containerName":"write_assembly","localvar":"my"},{"kind":13,"line":686,"name":"$scaffoldobj","containerName":"write_assembly"},{"line":686,"kind":12,"containerName":"write_assembly","name":"get_singlet_by_id"},{"kind":13,"line":686,"name":"$display_id","containerName":"write_assembly"},{"line":686,"kind":12,"containerName":"write_assembly","name":"seqref"},{"line":686,"kind":12,"name":"primary_id","containerName":"write_assembly"},{"name":"$sing_ids","containerName":"write_assembly","line":687,"kind":13},{"kind":13,"line":687,"name":"$i","containerName":"write_assembly"},{"containerName":"write_assembly","name":"$primary_id","line":687,"kind":13},{"name":"$did","containerName":"write_assembly","kind":13,"line":688},{"line":688,"kind":13,"name":"$primary_id","containerName":"write_assembly"},{"kind":13,"line":688,"name":"$display_id","containerName":"write_assembly"},{"definition":"my","name":"@ids","containerName":"write_assembly","localvar":"my","kind":13,"line":690},{"kind":13,"line":690,"name":"@cont_ids","containerName":"write_assembly"},{"kind":13,"line":690,"containerName":"write_assembly","name":"@sing_ids"},{"line":691,"kind":13,"containerName":"write_assembly","name":"@ids"},{"kind":13,"line":691,"name":"$a","containerName":"write_assembly"},{"line":691,"kind":13,"containerName":"write_assembly","name":"$b"},{"line":691,"kind":13,"containerName":"write_assembly","name":"@ids"},{"line":692,"kind":13,"localvar":"my","containerName":"write_assembly","definition":"my","name":"$numobj"},{"kind":13,"line":692,"name":"@ids","containerName":"write_assembly"},{"line":695,"kind":13,"localvar":"my","definition":"my","name":"$i","containerName":"write_assembly"},{"name":"$i","containerName":"write_assembly","line":695,"kind":13},{"name":"$numobj","containerName":"write_assembly","kind":13,"line":695},{"line":695,"kind":13,"name":"$i","containerName":"write_assembly"},{"line":697,"kind":13,"localvar":"my","containerName":"write_assembly","definition":"my","name":"$objid"},{"kind":13,"line":697,"name":"$ids","containerName":"write_assembly"},{"name":"$i","containerName":"write_assembly","kind":13,"line":697},{"containerName":"write_assembly","name":"$did","line":699,"kind":13},{"line":699,"kind":13,"containerName":"write_assembly","name":"$objid"},{"containerName":"write_assembly","name":"$singlets","kind":13,"line":701},{"line":703,"kind":13,"localvar":"my","containerName":"write_assembly","name":"$contigid","definition":"my"},{"kind":13,"line":703,"containerName":"write_assembly","name":"$objid"},{"line":704,"kind":13,"localvar":"my","name":"$readid","definition":"my","containerName":"write_assembly"},{"kind":13,"line":704,"containerName":"write_assembly","name":"$did"},{"line":704,"kind":13,"name":"$objid","containerName":"write_assembly"},{"localvar":"my","name":"$singletobj","definition":"my","containerName":"write_assembly","line":705,"kind":13},{"kind":13,"line":705,"name":"$scaffoldobj","containerName":"write_assembly"},{"name":"get_singlet_by_id","containerName":"write_assembly","line":705,"kind":12},{"line":705,"kind":13,"name":"$readid","containerName":"write_assembly"},{"line":708,"kind":13,"localvar":"my","containerName":"write_assembly","name":"$contanno","definition":"my"},{"name":"primary_tag","containerName":"write_assembly","kind":12,"line":709},{"kind":13,"line":710,"containerName":"write_assembly","name":"$singletobj"},{"line":710,"kind":12,"name":"get_features_collection","containerName":"write_assembly"},{"containerName":"write_assembly","name":"get_all_features","kind":12,"line":711},{"localvar":"my","definition":"my","name":"%contiginfo","containerName":"write_assembly","line":712,"kind":13},{"line":713,"kind":13,"name":"$contiginfo","containerName":"write_assembly"},{"name":"$singletobj","containerName":"write_assembly","line":713,"kind":13},{"line":713,"kind":12,"containerName":"write_assembly","name":"seqref"},{"line":713,"kind":12,"name":"seq","containerName":"write_assembly"},{"name":"$contiginfo","containerName":"write_assembly","kind":13,"line":714},{"kind":13,"line":714,"name":"$contiginfo","containerName":"write_assembly"},{"kind":13,"line":715,"containerName":"write_assembly","name":"$contiginfo"},{"containerName":"write_assembly","name":"$self","line":715,"kind":13},{"line":715,"kind":12,"name":"_qual_dec2hex","containerName":"write_assembly"},{"containerName":"write_assembly","name":"$singletobj","kind":13,"line":716},{"kind":12,"line":716,"containerName":"write_assembly","name":"seqref"},{"line":716,"kind":12,"containerName":"write_assembly","name":"qual"},{"name":"$contiginfo","containerName":"write_assembly","line":717,"kind":13},{"containerName":"write_assembly","name":"$contigid","kind":13,"line":717},{"name":"$contiginfo","containerName":"write_assembly","line":718,"kind":13},{"containerName":"write_assembly","name":"$contanno","kind":13,"line":718},{"kind":12,"line":718,"name":"get_tag_values","containerName":"write_assembly"},{"name":"$contiginfo","containerName":"write_assembly","kind":13,"line":719},{"containerName":"write_assembly","name":"$contanno","kind":13,"line":719},{"line":719,"kind":12,"name":"get_tag_values","containerName":"write_assembly"},{"name":"$contiginfo","containerName":"write_assembly","line":720,"kind":13},{"containerName":"write_assembly","name":"$contanno","line":720,"kind":13},{"kind":12,"line":720,"containerName":"write_assembly","name":"get_tag_values"},{"name":"$contiginfo","containerName":"write_assembly","line":721,"kind":13},{"name":"$contanno","containerName":"write_assembly","line":721,"kind":13},{"containerName":"write_assembly","name":"get_tag_values","line":721,"kind":12},{"kind":13,"line":722,"containerName":"write_assembly","name":"$contiginfo"},{"kind":13,"line":722,"name":"$contanno","containerName":"write_assembly"},{"kind":12,"line":722,"containerName":"write_assembly","name":"get_tag_values"},{"containerName":"write_assembly","name":"$contiginfo","kind":13,"line":723},{"line":723,"kind":13,"name":"$decimal_format","containerName":"write_assembly"},{"containerName":"write_assembly","name":"$contiginfo","line":724,"kind":13},{"kind":13,"line":725,"name":"$decimal_format","containerName":"write_assembly"},{"containerName":"write_assembly","name":"$self","line":725,"kind":13},{"kind":12,"line":725,"containerName":"write_assembly","name":"_perc_N"},{"containerName":"write_assembly","name":"$contiginfo","line":725,"kind":13},{"name":"$contiginfo","containerName":"write_assembly","kind":13,"line":726},{"kind":13,"line":727,"containerName":"write_assembly","name":"$contiginfo"},{"containerName":"write_assembly","name":"$contanno","line":727,"kind":13},{"containerName":"write_assembly","name":"get_tag_values","kind":12,"line":727},{"containerName":"write_assembly","name":"$contiginfo","line":728,"kind":13},{"line":728,"kind":13,"containerName":"write_assembly","name":"$contanno"},{"containerName":"write_assembly","name":"get_tag_values","kind":12,"line":728},{"name":"$contiginfo","containerName":"write_assembly","line":729,"kind":13},{"kind":13,"line":729,"name":"$contanno","containerName":"write_assembly"},{"name":"get_tag_values","containerName":"write_assembly","line":729,"kind":12},{"containerName":"write_assembly","name":"$contiginfo","line":730,"kind":13},{"containerName":"write_assembly","name":"$contanno","kind":13,"line":730},{"containerName":"write_assembly","name":"get_tag_values","line":730,"kind":12},{"kind":13,"line":731,"name":"$contiginfo","containerName":"write_assembly"},{"line":731,"kind":13,"name":"$self","containerName":"write_assembly"},{"line":731,"kind":12,"containerName":"write_assembly","name":"_date_time"},{"containerName":"write_assembly","name":"$contiginfo","line":732,"kind":13},{"containerName":"write_assembly","name":"$contanno","line":732,"kind":13},{"line":732,"kind":12,"containerName":"write_assembly","name":"get_tag_values"},{"name":"$contiginfo","containerName":"write_assembly","kind":13,"line":733},{"name":"$contanno","containerName":"write_assembly","kind":13,"line":733},{"line":733,"kind":12,"name":"get_tag_values","containerName":"write_assembly"},{"name":"$contiginfo","containerName":"write_assembly","kind":13,"line":736},{"name":"$contiginfo","containerName":"write_assembly","line":736,"kind":13},{"containerName":"write_assembly","name":"$contiginfo","line":737,"kind":13},{"containerName":"write_assembly","name":"$contiginfo","kind":13,"line":737},{"name":"$contiginfo","containerName":"write_assembly","kind":13,"line":738},{"kind":13,"line":738,"name":"$contiginfo","containerName":"write_assembly"},{"containerName":"write_assembly","name":"$contiginfo","kind":13,"line":739},{"containerName":"write_assembly","name":"$contiginfo","kind":13,"line":739},{"containerName":"write_assembly","name":"$contiginfo","line":740,"kind":13},{"name":"$contiginfo","containerName":"write_assembly","line":740,"kind":13},{"line":741,"kind":13,"name":"$contiginfo","containerName":"write_assembly"},{"name":"$contiginfo","containerName":"write_assembly","kind":13,"line":741},{"line":742,"kind":13,"name":"$contiginfo","containerName":"write_assembly"},{"line":742,"kind":13,"containerName":"write_assembly","name":"$contiginfo"},{"kind":13,"line":743,"name":"$contiginfo","containerName":"write_assembly"},{"name":"$contiginfo","containerName":"write_assembly","line":743,"kind":13},{"line":744,"kind":13,"containerName":"write_assembly","name":"$contiginfo"},{"containerName":"write_assembly","name":"$contiginfo","kind":13,"line":744},{"name":"$contiginfo","containerName":"write_assembly","line":745,"kind":13},{"kind":13,"line":745,"name":"$contiginfo","containerName":"write_assembly"},{"containerName":"write_assembly","name":"$contiginfo","kind":13,"line":746},{"containerName":"write_assembly","name":"$contiginfo","kind":13,"line":746},{"line":749,"kind":13,"name":"$self","containerName":"write_assembly"},{"kind":12,"line":749,"name":"_print","containerName":"write_assembly"},{"line":773,"kind":13,"localvar":"my","name":"$seq_name","definition":"my","containerName":"write_assembly"},{"kind":13,"line":773,"containerName":"write_assembly","name":"$db"},{"name":"$self","containerName":"write_assembly","line":773,"kind":13},{"name":"_split_seq_name_and_db","containerName":"write_assembly","line":773,"kind":12},{"containerName":"write_assembly","name":"$readid","kind":13,"line":773},{"kind":13,"line":774,"containerName":"write_assembly","name":"$clipcoord","definition":"my","localvar":"my"},{"name":"primary_tag","containerName":"write_assembly","kind":12,"line":775},{"line":776,"kind":13,"name":"$singletobj","containerName":"write_assembly"},{"line":776,"kind":12,"name":"get_features_collection","containerName":"write_assembly"},{"name":"get_all_features","containerName":"write_assembly","kind":12,"line":777},{"line":778,"kind":13,"localvar":"my","name":"$alncoord","definition":"my","containerName":"write_assembly"},{"line":779,"kind":12,"containerName":"write_assembly","name":"primary_tag"},{"containerName":"write_assembly","name":"$singletobj","kind":13,"line":780},{"kind":12,"line":780,"name":"get_features_collection","containerName":"write_assembly"},{"kind":12,"line":781,"name":"get_all_features","containerName":"write_assembly"},{"kind":13,"line":782,"containerName":"write_assembly","name":"$readanno","definition":"my","localvar":"my"},{"containerName":"write_assembly","name":"primary_tag","kind":12,"line":783},{"containerName":"write_assembly","name":"$singletobj","line":784,"kind":13},{"containerName":"write_assembly","name":"get_seq_coord","kind":12,"line":784},{"line":784,"kind":13,"name":"$singletobj","containerName":"write_assembly"},{"line":784,"kind":12,"containerName":"write_assembly","name":"seqref"},{"name":"get_SeqFeatures","containerName":"write_assembly","line":785,"kind":12},{"kind":13,"line":786,"definition":"my","name":"%readinfo","containerName":"write_assembly","localvar":"my"},{"kind":13,"line":787,"name":"$readinfo","containerName":"write_assembly"},{"kind":13,"line":787,"name":"$seq_name","containerName":"write_assembly"},{"containerName":"write_assembly","name":"$readinfo","line":788,"kind":13},{"name":"$alncoord","containerName":"write_assembly","line":788,"kind":13},{"line":788,"kind":12,"containerName":"write_assembly","name":"location"},{"kind":12,"line":788,"name":"start","containerName":"write_assembly"},{"name":"$readinfo","containerName":"write_assembly","kind":13,"line":789},{"name":"$alncoord","containerName":"write_assembly","kind":13,"line":789},{"name":"location","containerName":"write_assembly","line":789,"kind":12},{"kind":12,"line":789,"name":"end","containerName":"write_assembly"},{"line":790,"kind":13,"name":"$readinfo","containerName":"write_assembly"},{"name":"$clipcoord","containerName":"write_assembly","kind":13,"line":790},{"line":790,"kind":12,"name":"location","containerName":"write_assembly"},{"containerName":"write_assembly","name":"start","line":790,"kind":12},{"containerName":"write_assembly","name":"$readinfo","line":791,"kind":13},{"containerName":"write_assembly","name":"$clipcoord","line":791,"kind":13},{"name":"location","containerName":"write_assembly","kind":12,"line":791},{"containerName":"write_assembly","name":"end","kind":12,"line":791},{"kind":13,"line":792,"name":"$readinfo","containerName":"write_assembly"},{"name":"$readanno","containerName":"write_assembly","kind":13,"line":792},{"containerName":"write_assembly","name":"get_tag_values","kind":12,"line":792},{"containerName":"write_assembly","name":"$readinfo","line":793,"kind":13},{"containerName":"write_assembly","name":"$readanno","line":793,"kind":13},{"name":"get_tag_values","containerName":"write_assembly","kind":12,"line":793},{"line":794,"kind":13,"name":"$readinfo","containerName":"write_assembly"},{"name":"$db","containerName":"write_assembly","kind":13,"line":794},{"name":"$readinfo","containerName":"write_assembly","kind":13,"line":795},{"kind":13,"line":797,"containerName":"write_assembly","name":"$readinfo"},{"name":"$contiginfo","containerName":"write_assembly","line":797,"kind":13},{"kind":13,"line":800,"containerName":"write_assembly","name":"$readinfo"},{"name":"$readinfo","containerName":"write_assembly","kind":13,"line":800},{"containerName":"write_assembly","name":"$readinfo","line":801,"kind":13},{"kind":13,"line":801,"containerName":"write_assembly","name":"$readinfo"},{"line":804,"kind":13,"containerName":"write_assembly","name":"$self"},{"containerName":"write_assembly","name":"_print","line":804,"kind":12},{"name":"$i","containerName":"write_assembly","kind":13,"line":816},{"containerName":"write_assembly","name":"$numobj","line":816,"kind":13},{"containerName":"write_assembly","name":"$self","kind":13,"line":817},{"line":817,"kind":12,"name":"_print","containerName":"write_assembly"},{"kind":13,"line":821,"containerName":"write_assembly","definition":"my","name":"$contigid","localvar":"my"},{"name":"$objid","containerName":"write_assembly","kind":13,"line":821},{"localvar":"my","containerName":"write_assembly","name":"$contigobj","definition":"my","line":822,"kind":13},{"kind":13,"line":822,"containerName":"write_assembly","name":"$scaffoldobj"},{"containerName":"write_assembly","name":"get_contig_by_id","kind":12,"line":822},{"kind":13,"line":822,"name":"$contigid","containerName":"write_assembly"},{"name":"$contigobj","containerName":"write_assembly","line":825,"kind":13},{"line":825,"kind":12,"containerName":"write_assembly","name":"num_sequences"},{"containerName":"write_assembly","name":"$singlets","kind":13,"line":825},{"localvar":"my","name":"$contanno","definition":"my","containerName":"write_assembly","line":828,"kind":13},{"line":829,"kind":12,"name":"primary_tag","containerName":"write_assembly"},{"line":830,"kind":13,"containerName":"write_assembly","name":"$contigobj"},{"containerName":"write_assembly","name":"get_features_collection","line":830,"kind":12},{"containerName":"write_assembly","name":"get_all_features","kind":12,"line":831},{"line":832,"kind":13,"localvar":"my","containerName":"write_assembly","name":"%contiginfo","definition":"my"},{"containerName":"write_assembly","name":"$contiginfo","line":833,"kind":13},{"containerName":"write_assembly","name":"$self","kind":13,"line":833},{"kind":12,"line":833,"containerName":"write_assembly","name":"_ungap"},{"line":834,"kind":13,"containerName":"write_assembly","name":"$contigobj"},{"line":834,"kind":12,"containerName":"write_assembly","name":"get_consensus_sequence"},{"containerName":"write_assembly","name":"seq","line":834,"kind":12},{"name":"$contiginfo","containerName":"write_assembly","line":835,"kind":13},{"containerName":"write_assembly","name":"$contigobj","kind":13,"line":835},{"line":835,"kind":12,"containerName":"write_assembly","name":"get_consensus_sequence"},{"kind":12,"line":835,"containerName":"write_assembly","name":"seq"},{"kind":13,"line":836,"containerName":"write_assembly","name":"$contiginfo"},{"containerName":"write_assembly","name":"$self","line":836,"kind":13},{"line":836,"kind":12,"containerName":"write_assembly","name":"_qual_dec2hex"},{"kind":13,"line":837,"name":"$contigobj","containerName":"write_assembly"},{"containerName":"write_assembly","name":"get_consensus_quality","line":837,"kind":12},{"line":837,"kind":12,"containerName":"write_assembly","name":"qual"},{"kind":13,"line":838,"containerName":"write_assembly","name":"$contiginfo"},{"kind":13,"line":838,"containerName":"write_assembly","name":"$contigid"},{"name":"$contiginfo","containerName":"write_assembly","kind":13,"line":839},{"containerName":"write_assembly","name":"$contanno","kind":13,"line":839},{"line":839,"kind":12,"containerName":"write_assembly","name":"get_tag_values"},{"line":840,"kind":13,"name":"$contiginfo","containerName":"write_assembly"},{"name":"$contanno","containerName":"write_assembly","line":840,"kind":13},{"kind":12,"line":840,"containerName":"write_assembly","name":"get_tag_values"},{"kind":13,"line":841,"containerName":"write_assembly","name":"$contiginfo"},{"line":841,"kind":13,"containerName":"write_assembly","name":"$contanno"},{"kind":12,"line":841,"containerName":"write_assembly","name":"get_tag_values"},{"line":842,"kind":13,"containerName":"write_assembly","name":"$contiginfo"},{"line":842,"kind":13,"name":"$contanno","containerName":"write_assembly"},{"name":"get_tag_values","containerName":"write_assembly","line":842,"kind":12},{"name":"$contiginfo","containerName":"write_assembly","line":843,"kind":13},{"kind":13,"line":843,"name":"$contanno","containerName":"write_assembly"},{"kind":12,"line":843,"name":"get_tag_values","containerName":"write_assembly"},{"line":844,"kind":13,"containerName":"write_assembly","name":"$contiginfo"},{"name":"$decimal_format","containerName":"write_assembly","kind":13,"line":845},{"name":"$self","containerName":"write_assembly","line":845,"kind":13},{"kind":12,"line":845,"name":"_redundancy","containerName":"write_assembly"},{"kind":13,"line":845,"containerName":"write_assembly","name":"$contigobj"},{"containerName":"write_assembly","name":"$contiginfo","kind":13,"line":846},{"kind":13,"line":847,"containerName":"write_assembly","name":"$decimal_format"},{"kind":13,"line":847,"name":"$self","containerName":"write_assembly"},{"line":847,"kind":12,"containerName":"write_assembly","name":"_perc_N"},{"name":"$contiginfo","containerName":"write_assembly","line":847,"kind":13},{"line":848,"kind":13,"containerName":"write_assembly","name":"$contiginfo"},{"name":"$contigobj","containerName":"write_assembly","line":848,"kind":13},{"containerName":"write_assembly","name":"num_sequences","line":848,"kind":12},{"containerName":"write_assembly","name":"$contiginfo","kind":13,"line":849},{"containerName":"write_assembly","name":"$contanno","line":849,"kind":13},{"line":849,"kind":12,"name":"get_tag_values","containerName":"write_assembly"},{"kind":13,"line":850,"name":"$contiginfo","containerName":"write_assembly"},{"name":"$contanno","containerName":"write_assembly","kind":13,"line":850},{"kind":12,"line":850,"name":"get_tag_values","containerName":"write_assembly"},{"containerName":"write_assembly","name":"$contiginfo","kind":13,"line":851},{"containerName":"write_assembly","name":"$contanno","line":851,"kind":13},{"line":851,"kind":12,"containerName":"write_assembly","name":"get_tag_values"},{"kind":13,"line":852,"containerName":"write_assembly","name":"$contiginfo"},{"line":852,"kind":13,"name":"$contanno","containerName":"write_assembly"},{"kind":12,"line":852,"name":"get_tag_values","containerName":"write_assembly"},{"containerName":"write_assembly","name":"$contiginfo","kind":13,"line":853},{"containerName":"write_assembly","name":"$self","kind":13,"line":853},{"kind":12,"line":853,"containerName":"write_assembly","name":"_date_time"},{"line":854,"kind":13,"containerName":"write_assembly","name":"$contiginfo"},{"containerName":"write_assembly","name":"$contanno","line":854,"kind":13},{"kind":12,"line":854,"containerName":"write_assembly","name":"get_tag_values"},{"containerName":"write_assembly","name":"$contiginfo","line":855,"kind":13},{"name":"$contanno","containerName":"write_assembly","kind":13,"line":855},{"line":855,"kind":12,"name":"get_tag_values","containerName":"write_assembly"},{"containerName":"write_assembly","name":"$contiginfo","line":858,"kind":13},{"line":858,"kind":13,"name":"$contiginfo","containerName":"write_assembly"},{"name":"$contiginfo","containerName":"write_assembly","line":859,"kind":13},{"line":859,"kind":13,"containerName":"write_assembly","name":"$contiginfo"},{"containerName":"write_assembly","name":"$contiginfo","kind":13,"line":860},{"containerName":"write_assembly","name":"$contiginfo","line":860,"kind":13},{"containerName":"write_assembly","name":"$contiginfo","kind":13,"line":861},{"containerName":"write_assembly","name":"$contiginfo","line":861,"kind":13},{"line":862,"kind":13,"containerName":"write_assembly","name":"$contiginfo"},{"containerName":"write_assembly","name":"$contiginfo","line":862,"kind":13},{"line":863,"kind":13,"name":"$contiginfo","containerName":"write_assembly"},{"containerName":"write_assembly","name":"$contiginfo","kind":13,"line":863},{"name":"$contiginfo","containerName":"write_assembly","kind":13,"line":864},{"containerName":"write_assembly","name":"$contiginfo","kind":13,"line":864},{"containerName":"write_assembly","name":"$contiginfo","line":865,"kind":13},{"name":"$contiginfo","containerName":"write_assembly","kind":13,"line":865},{"line":866,"kind":13,"containerName":"write_assembly","name":"$contiginfo"},{"line":866,"kind":13,"name":"$contiginfo","containerName":"write_assembly"},{"line":867,"kind":13,"containerName":"write_assembly","name":"$contiginfo"},{"name":"$contiginfo","containerName":"write_assembly","kind":13,"line":867},{"kind":13,"line":868,"containerName":"write_assembly","name":"$contiginfo"},{"line":868,"kind":13,"containerName":"write_assembly","name":"$contiginfo"},{"name":"$self","containerName":"write_assembly","kind":13,"line":871},{"name":"_print","containerName":"write_assembly","kind":12,"line":871},{"kind":13,"line":893,"containerName":"write_assembly","name":"$seqno","definition":"my","localvar":"my"},{"localvar":"my","containerName":"write_assembly","definition":"my","name":"$readobj","line":894,"kind":13},{"kind":13,"line":894,"containerName":"write_assembly","name":"$contigobj"},{"kind":12,"line":894,"name":"each_seq","containerName":"write_assembly"},{"containerName":"write_assembly","name":"$seqno","line":895,"kind":13},{"kind":13,"line":898,"definition":"my","name":"$seq_name","containerName":"write_assembly","localvar":"my"},{"kind":13,"line":898,"containerName":"write_assembly","name":"$db"},{"line":898,"kind":13,"name":"$self","containerName":"write_assembly"},{"name":"_split_seq_name_and_db","containerName":"write_assembly","kind":12,"line":898},{"name":"$readobj","containerName":"write_assembly","kind":13,"line":898},{"line":898,"kind":12,"containerName":"write_assembly","name":"id"},{"localvar":"my","definition":"my","name":"$asm_lend","containerName":"write_assembly","line":899,"kind":13},{"line":899,"kind":13,"containerName":"write_assembly","name":"$asm_rend"},{"line":899,"kind":13,"name":"$seq_lend","containerName":"write_assembly"},{"containerName":"write_assembly","name":"$seq_rend","kind":13,"line":899},{"line":899,"kind":13,"containerName":"write_assembly","name":"$offset"},{"kind":13,"line":900,"name":"$self","containerName":"write_assembly"},{"name":"_coord","containerName":"write_assembly","line":900,"kind":12},{"name":"$readobj","containerName":"write_assembly","kind":13,"line":900},{"containerName":"write_assembly","name":"$contigobj","line":900,"kind":13},{"line":901,"kind":13,"localvar":"my","containerName":"write_assembly","name":"$readanno","definition":"my"},{"line":902,"kind":12,"name":"primary_tag","containerName":"write_assembly"},{"kind":13,"line":902,"name":"$readobj","containerName":"write_assembly"},{"name":"primary_id","containerName":"write_assembly","line":902,"kind":12},{"kind":13,"line":903,"containerName":"write_assembly","name":"$contigobj"},{"kind":12,"line":903,"containerName":"write_assembly","name":"get_seq_coord"},{"kind":13,"line":903,"containerName":"write_assembly","name":"$readobj"},{"name":"get_SeqFeatures","containerName":"write_assembly","kind":12,"line":904},{"localvar":"my","name":"%readinfo","definition":"my","containerName":"write_assembly","line":905,"kind":13},{"name":"$readinfo","containerName":"write_assembly","line":906,"kind":13},{"name":"$seq_name","containerName":"write_assembly","line":906,"kind":13},{"name":"$readinfo","containerName":"write_assembly","line":907,"kind":13},{"containerName":"write_assembly","name":"$asm_lend","kind":13,"line":907},{"line":908,"kind":13,"containerName":"write_assembly","name":"$readinfo"},{"kind":13,"line":908,"containerName":"write_assembly","name":"$asm_rend"},{"name":"$readinfo","containerName":"write_assembly","line":909,"kind":13},{"containerName":"write_assembly","name":"$seq_lend","kind":13,"line":909},{"line":910,"kind":13,"name":"$readinfo","containerName":"write_assembly"},{"line":910,"kind":13,"name":"$seq_rend","containerName":"write_assembly"},{"kind":13,"line":911,"containerName":"write_assembly","name":"$readinfo"},{"kind":13,"line":911,"name":"$readanno","containerName":"write_assembly"},{"line":911,"kind":12,"containerName":"write_assembly","name":"get_tag_values"},{"line":912,"kind":13,"containerName":"write_assembly","name":"$readinfo"},{"name":"$readanno","containerName":"write_assembly","kind":13,"line":912},{"containerName":"write_assembly","name":"get_tag_values","kind":12,"line":912},{"containerName":"write_assembly","name":"$readinfo","kind":13,"line":913},{"line":913,"kind":13,"containerName":"write_assembly","name":"$db"},{"line":914,"kind":13,"containerName":"write_assembly","name":"$readinfo"},{"name":"$offset","containerName":"write_assembly","kind":13,"line":914},{"name":"$readinfo","containerName":"write_assembly","line":915,"kind":13},{"line":915,"kind":13,"name":"$readobj","containerName":"write_assembly"},{"kind":12,"line":915,"containerName":"write_assembly","name":"seq"},{"containerName":"write_assembly","name":"$readinfo","line":918,"kind":13},{"line":918,"kind":13,"name":"$readinfo","containerName":"write_assembly"},{"containerName":"write_assembly","name":"$readinfo","kind":13,"line":919},{"containerName":"write_assembly","name":"$readinfo","kind":13,"line":919},{"line":922,"kind":13,"containerName":"write_assembly","name":"$self"},{"kind":12,"line":922,"containerName":"write_assembly","name":"_print"},{"line":934,"kind":13,"name":"$seqno","containerName":"write_assembly"},{"kind":13,"line":934,"name":"$contiginfo","containerName":"write_assembly"},{"line":935,"kind":13,"containerName":"write_assembly","name":"$self"},{"kind":12,"line":935,"containerName":"write_assembly","name":"_print"},{"line":936,"kind":13,"containerName":"write_assembly","name":"$seqno"},{"name":"$contiginfo","containerName":"write_assembly","kind":13,"line":936},{"name":"$i","containerName":"write_assembly","line":936,"kind":13},{"name":"$numobj","containerName":"write_assembly","line":936,"kind":13},{"name":"$self","containerName":"write_assembly","kind":13,"line":937},{"kind":12,"line":937,"name":"_print","containerName":"write_assembly"}],"kind":12,"range":{"start":{"line":666,"character":0},"end":{"line":940,"character":9999}},"name":"write_assembly"},{"range":{"start":{"line":959,"character":0},"end":{"character":9999,"line":971}},"name":"_perc_N","children":[{"kind":13,"line":960,"containerName":"_perc_N","definition":"my","name":"$self","localvar":"my"},{"line":960,"kind":13,"name":"$seq_string","containerName":"_perc_N"},{"line":961,"kind":13,"containerName":"_perc_N","name":"$self"},{"line":961,"kind":12,"name":"throw","containerName":"_perc_N"},{"containerName":"_perc_N","name":"$seq_string","line":961,"kind":13},{"localvar":"my","containerName":"_perc_N","name":"$perc_N","definition":"my","line":962,"kind":13},{"localvar":"my","name":"$base","definition":"my","containerName":"_perc_N","line":963,"kind":13},{"containerName":"_perc_N","name":"$seq_string","line":963,"kind":13},{"name":"$base","containerName":"_perc_N","kind":13,"line":965},{"kind":13,"line":965,"name":"$base","containerName":"_perc_N"},{"line":966,"kind":13,"containerName":"_perc_N","name":"$perc_N"},{"kind":13,"line":969,"containerName":"_perc_N","name":"$perc_N"},{"containerName":"_perc_N","name":"$perc_N","line":969,"kind":13},{"name":"$seq_string","containerName":"_perc_N","line":969,"kind":13},{"kind":13,"line":970,"containerName":"_perc_N","name":"$perc_N"}],"line":959,"kind":12,"signature":{"documentation":"__END__\n# $Id: tigr.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO::tigr\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO::tigr - Driver to read and write assembly files in the TIGR\nAssembler v2 default format.\n\n=head1 SYNOPSIS\n\n    # Building an input stream\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $asmio = Bio::Assembly::IO->new( -file   => 'SGC0-424.tasm',\n                                        -format => 'tigr' );\n    my $scaffold = $asmio->next_assembly;\n\n    # Do some things on contigs...\n\n    # Assembly writing methods\n    my $outasm = Bio::Assembly::IO->new( -file   => \">SGC0-modified.tasm\",\n                                         -format => 'tigr' );\n    $outasm->write_assembly( -scaffold => $assembly,\n                             -singlets => 1 );\n\n=head1 DESCRIPTION\n\nThis package loads and writes assembly information in/from files in the default\nTIGR Assembler v2 format. The files are lassie-formatted and often have the\n.tasm extension. This module was written to be used as a driver module for\nBio::Assembly::IO input/output.\n\n=head2 Implementation\n\nAssemblies are loaded into Bio::Assembly::Scaffold objects composed of\nBio::Assembly::Contig and Bio::Assembly::Singlet objects. Since aligned reads\nand contig gapped consensus can be obtained in the tasm files, only\naligned/gapped sequences are added to the different BioPerl objects.\n\nAdditional assembly information is stored as features. Contig objects have\nSeqFeature information associated with the primary_tag:\n\n    _main_contig_feature:$contig_id -> misc contig information\n    _quality_clipping:$read_id      -> quality clipping position\n\nRead objects have sub_seqFeature information associated with the\nprimary_tag:\n\n    _main_read_feature:$read_id     -> misc read information\n\nSinglets are considered by TIGR Assembler as contigs of one sequence and are\nrepresented here with features having these primary_tag: \n\n    _main_contig_feature:$contig_id\n    _quality_clipping:$read_primary_id\n    _main_read_feature:$read_primary_id\n    _aligned_coord:$read_primary_id\n\n=head1 THE TIGR TASM LASSIEFORMAT\n\n=head2 Description\n\nIn the TIGR tasm lassie format, contigs are separated by a line containing a single\npipe character \"|\", whereas the reads in a contig are separated by a blank line.\nSinglets can be present in the file and are represented as a contig\ncomposed of a single sequence.\n\nOther than the two above-mentioned separators, each line has an attribute name,\nfollowed a tab and then an attribute value.\n\nThe tasm format is used by more TIGR applications than just TIGR Assembler.\nSome of the attributes are not used by TIGR Assembler or have constant values.\nThey are indicated by an asterisk *\n\nContigs have the following attributes:\n\n    asmbl_id   -> contig ID\n    sequence   -> contig ungapped consensus sequence (ambiguities are lowercase)\n    lsequence  -> gapped consensus sequence (lowercase ambiguities)\n    quality    -> gapped consensus quality score (in hexadecimal)\n    seq_id     -> *\n    com_name   -> *\n    type       -> *\n    method     -> always 'asmg' *\n    ed_status  -> *\n    redundancy -> fold coverage of the contig consensus\n    perc_N     -> percent of ambiguities in the contig consensus\n    seq#       -> number of sequences in the contig\n    full_cds   -> *\n    cds_start  -> start of coding sequence *\n    cds_end    -> end of coding sequence *\n    ed_pn      -> name of editor (always 'GRA') *\n    ed_date    -> date and time of edition\n    comment    -> some comments *\n    frameshift -> *\n\nEach read has the following attributes:\n\n    seq_name  -> read name\n    asm_lend  -> position of first base on contig ungapped consensus sequence\n    asm_rend  -> position of last base on contig ungapped consensus sequence\n    seq_lend  -> start of quality-trimmed sequence (aligned read coordinates)\n    seq_rend  -> end of quality-trimmed sequence (aligned read coordinates)\n    best      -> always '0' *\n    comment   -> some comments *\n    db        -> database name associated with the sequence (e.g. >my_db|seq1234)\n    offset    -> offset of the sequence (gapped consensus coordinates)\n    lsequence -> aligned read sequence (ambiguities are uppercase)\n\nWhen asm_rend E<lt> asm_lend, the sequence was on the complementary DNA strand but\nits reverse complement is shown in the aligned sequence of the assembly file,\nnot the original read.\n\nAmbiguities are reflected in the contig consensus sequence as\nlowercase IUPAC characters: a c g t u m r w s y k x n . In the read\nsequences, however, ambiguities are uppercase: M R W S Y K X N\n\n=head2 Example\n\nExample of a contig containing three sequences:\n\n    sequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCGCAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    quality\t0x0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0505050505050505050E0505160505050505050505050505050505050505050505050505050505050303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0404040404040404041604040404040404040404040404040404040404040404040404040404040404040404040404040404040E0404040404040404040B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B\n    asmbl_id\t93\n    seq_id\t\n    com_name\t\n    type\t\n    method\tasmg\n    ed_status\t\n    redundancy\t1.11\n    perc_N\t0.20\n    seq#\t3\n    full_cds\t\n    cds_start\t\n    cds_end\t\n    ed_pn\tGRA\n    ed_date\t08/16/07 17:10:12\n    comment\t\n    frameshift\t\n\n    seq_name\tSDSU_RFPERU_010_C09.x01.phd.1\n    asm_lend\t1\n    asm_rend\t4423\n    seq_lend\t1\n    seq_rend\t442\n    best\t0\n    comment\t\n    db\t\n    offset\t0\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAGCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGG\n\n    seq_name\tSDSU_RFPERU_002_H12.x01.phd.1\n    asm_lend\t339\n    asm_rend\t940\n    seq_lend\t1\n    seq_rend\t602\n    best\t0\n    comment\t\n    db\t\n    offset\t338\n    lsequence\tCGAGATTCGCCACCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCCGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATA-GCGTGGCGC\n\n    seq_name\tSDSU_RFPERU_009_E07.x01.phd.1\n    asm_lend\t880\n    asm_rend\t1520\n    seq_lend\t641\n    seq_rend\t1\n    best\t0\n    comment\t\n    db\t\n    offset\t8803\n    lsequence\tCGCACGGTCTGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAAGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    |\n\n...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent dot angly at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::IO::tigr;\n\nuse strict;\nuse Bio::Seq::Quality;\nuse Bio::LocatableSeq;\nuse Bio::Assembly::IO;\nuse Bio::Assembly::Scaffold;\nuse Bio::Assembly::Contig;\nuse Bio::Assembly::Singlet;\n\nuse base qw(Bio::Assembly::IO);\n\nmy $progname = 'TIGR Assembler';\n\n=head2 next_assembly\n\n Title   : next_assembly\n Usage   : my $scaffold = $asmio->next_assembly()\n Function: return the next assembly in the tasm-formatted stream\n Returns : Bio::Assembly::Scaffold object\n Args    : none\n\n\nsub next_assembly {\n    my $self = shift; # object reference\n    \n    # Create a new scaffold to hold the contigs\n    my $scaffoldobj = Bio::Assembly::Scaffold->new(-source => $progname);\n    \n    # Contig and read related\n    my $contigobj;\n    my $iscontig = 1;\n    my %contiginfo;\n    my $isread = 0;\n    my %readinfo;\n    \n    # Loop over all assembly file lines\n    while ($_ = $self->_readline) {\n        chomp;\n        if ( /^\\|/ ) {  # a line with a single pipe |\n            # The end of a read from a contig, the start of a new contig\n            $iscontig = 1;\n            $isread   = 0;\n            # Store read info\n            if ($contiginfo{'seqnum'} > 1) {\n                # This is a read in a contig\n                my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n            } elsif ($contiginfo{'seqnum'} == 1) {\n                # This is a singlet\n                my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                    $scaffoldobj);\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n            # Clear read info\n            undef %readinfo;\n            # Clear contig info\n            undef $contigobj;\n            undef %contiginfo;\n        } elsif ( /^$/ ) {  # a blank line\n            if ($iscontig) {\n                # The end of a contig, the start of a read in that contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store contig info\n                $contigobj = $self->_store_contig( \\%contiginfo, $contigobj,\n                    $scaffoldobj ) if $contiginfo{'seqnum'} > 1;\n            } elsif ($isread) {\n                # The end of read in a contig, the start of a new one in\n                # the same contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store read info\n                if ($contiginfo{'seqnum'} > 1) {\n                    # This is a read in a contig\n                    my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n                } elsif ($contiginfo{'seqnum'} == 1) {\n                    # This is a singlet\n                    my $singletobj = $self->_store_singlet(\\%readinfo,\n                        \\%contiginfo, $scaffoldobj);\n                } else {\n                  # That should not happen\n                  $self->throw(\"Unhandled exception\");\n                }\n                # Clear read info\n                undef %readinfo;\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n        } else {\n            if ($iscontig) {\n                # Parse contig\n                if    (/^sequence\\t(.*)/)     {$contiginfo{'sequence'}   = $1; next}\n                elsif (/^lsequence\\t(.*)/)    {$contiginfo{'lsequence'}  = $1; next}\n                elsif (/^quality\\t(.*)/)      {$contiginfo{'quality'}    = $1; next}\n                elsif (/^asmbl_id\\t(.*)/)     {$contiginfo{'asmbl_id'}   = $1; next}\n                elsif (/^seq_id\\t(.*)/)       {$contiginfo{'seq_id'}     = $1; next}\n                elsif (/^com_name\\t(.*)/)     {$contiginfo{'com_name'}   = $1; next}\n                elsif (/^type\\t(.*)/)         {$contiginfo{'type'}       = $1; next}\n                elsif (/^method\\t(.*)/)       {$contiginfo{'method'}     = $1; next}\n                elsif (/^ed_status\\t(.*)/)    {$contiginfo{'ed_status'}  = $1; next}\n                elsif (/^redundancy\\t(.*)/)   {$contiginfo{'redundancy'} = $1; next}\n                elsif (/^perc_N\\t(.*)/)       {$contiginfo{'perc_N'}     = $1; next}\n                elsif (/^seq\\#\\t(.*)/)        {$contiginfo{'seqnum'}     = $1; next}\n                elsif (/^full_cds\\t(.*)/)     {$contiginfo{'full_cds'}   = $1; next}\n                elsif (/^cds_start\\t(.*)/)    {$contiginfo{'cds_start'}  = $1; next}\n                elsif (/^cds_end\\t(.*)/)      {$contiginfo{'cds_end'}    = $1; next}\n                elsif (/^ed_pn\\t(.*)/)        {$contiginfo{'ed_pn'}      = $1; next}\n                elsif (/^ed_date\\t(.*\\s.*)/)  {$contiginfo{'ed_date'}    = $1; next}\n                elsif (/^comment\\t(.*)/)      {$contiginfo{'comment'}    = $1; next}\n                elsif (/^frameshift\\t(.*)/)   {$contiginfo{'frameshift'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } elsif ($isread) {\n                # Parse read info\n                if    (/^seq_name\\t(.*)/)  {$readinfo{'seq_name'}  = $1; next}\n                elsif (/^asm_lend\\t(.*)/)  {$readinfo{'asm_lend'}  = $1; next}\n                elsif (/^asm_rend\\t(.*)/)  {$readinfo{'asm_rend'}  = $1; next}\n                elsif (/^seq_lend\\t(.*)/)  {$readinfo{'seq_lend'}  = $1; next}\n                elsif (/^seq_rend\\t(.*)/)  {$readinfo{'seq_rend'}  = $1; next}\n                elsif (/^best\\t(.*)/)      {$readinfo{'best'}      = $1; next}\n                elsif (/^comment\\t(.*)/)   {$readinfo{'comment'}   = $1; next}\n                elsif (/^db\\t(.*)/)        {$readinfo{'db'}        = $1; next}\n                elsif (/^offset\\t(.*)/)    {$readinfo{'offset'}    = $1; next}\n                elsif (/^lsequence\\t(.*)/) {$readinfo{'lsequence'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } else {\n                # That shouldn't happen\n                $self->throw(\"Unhandled exception\");                \n            }\n        }\n    }\n    # Store read info for last read\n    if (defined $contiginfo{'seqnum'}) {\n        if ($contiginfo{'seqnum'} > 1) {\n            # This is a read in a contig\n            my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n        } elsif ($contiginfo{'seqnum'} == 1) {\n            # This is a singlet\n            my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                $scaffoldobj);\n        } else {\n            # That should not happen\n            $self->throw(\"Unhandled exception\");\n        }\n    }\n    # Clear read info for last read\n    undef %readinfo;\n    # Clear contig info for last contig\n    undef $contigobj;\n    undef %contiginfo;\n    \n    $scaffoldobj->update_seq_list();\n    \n    return $scaffoldobj;\n}\n\n=head2 _qual_hex2dec\n\n    Title   : _qual_hex2dec\n    Usage   : my dec_quality = $self->_qual_hex2dec($hex_quality);\n    Function: convert an hexadecimal quality score into a decimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_hex2dec {\n    my ($self, $qual) = @_;\n    $qual =~ s/^0x(.*)$/$1/;\n    $qual =~ s/(..)/hex($1).' '/eg;\n    return $qual;\n}\n\n=head2 _qual_dec2hex\n\n    Title   : _qual_dec2hex\n    Usage   : my hex_quality = $self->_qual_dec2hex($dec_quality);\n    Function: convert a decimal quality score into an hexadecimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_dec2hex {\n    my ($self, $qual) = @_;\n    $qual =~ s/(\\d+)\\s*/sprintf('%02X', $1)/eg;\n    $qual = '0x'.$qual;\n    return $qual;\n}\n\n=head2 _store_contig\n\n    Title   : _store_contig\n    Usage   : my $contigobj; $contigobj = $self->_store_contig(\n              \\%contiginfo, $contigobj, $scaffoldobj);\n    Function: store information of a contig belonging to a scaffold in the\n              appropriate object\n    Returns : Bio::Assembly::Contig object\n    Args    : hash, Bio::Assembly::Contig, Bio::Assembly::Scaffold\n\n\nsub _store_contig {\n    my ($self, $contiginfo, $contigobj, $scaffoldobj) = @_;\n\n    # Create a contig and attach it to scaffold\n    $contigobj = Bio::Assembly::Contig->new(\n        -id     => $$contiginfo{'asmbl_id'},\n        -source => $progname,\n        -strand => 1\n    );\n    $scaffoldobj->add_contig($contigobj);\n\n    # Create a gapped consensus sequence and attach it to contig\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $consensus = Bio::LocatableSeq->new(\n        -id    => $$contiginfo{'asmbl_id'},\n        -seq   => $$contiginfo{'lsequence'},\n        -start => 1,\n    );\n    $contigobj->set_consensus_sequence($consensus);\n\n    # Create an gapped consensus quality score and attach it to contig\n    $$contiginfo{'quality'} = $self->_qual_hex2dec($$contiginfo{'quality'});\n    my $qual = Bio::Seq::Quality->new(\n        -id   => $$contiginfo{'asmbl_id'},\n        -qual => $$contiginfo{'quality'}\n    );\n    $contigobj->set_consensus_quality($qual);\n\n    # Add other misc contig information as features of the contig\n    my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$$contiginfo{'asmbl_id'}\",\n        -start       => 1,\n        -end         => $contigobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n    );\n    $contigobj->add_features([ $contigtags ], 1);\n\n    return $contigobj;\n}\n\n=head2 _store_read\n\n    Title   : _store_read\n    Usage   : my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n    Function: store information of a read belonging to a contig in the appropriate object\n    Returns : Bio::LocatableSeq\n    Args    : hash, Bio::Assembly::Contig\n\n\nsub _store_read {\n   my ($self, $readinfo, $contigobj) = @_;\n\n   # Create an aligned read object\n   #$$readinfo{'llength'} = length($$readinfo{'lsequence'});\n   $$readinfo{'strand'}  = ($$readinfo{'seq_rend'} > $$readinfo{'seq_lend'} ? 1 : -1);\n   my $readobj = Bio::LocatableSeq->new(\n       # the ids of sequence objects are supposed to include the db name in it, i.e. \"big_db|seq1234\"\n       # that's how sequence ids coming from the fasta parser are at least\n       -display_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -primary_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -seq        => $$readinfo{'lsequence'},      \n       -start      => 1,\n       -strand     => $$readinfo{'strand'},\n       -alphabet   => 'dna'\n   );\n\n   # Add read location and sequence to contig (in 'gapped consensus' coordinates)\n   $$readinfo{'aln_start'} = $$readinfo{'offset'} + 1; # seq offset is in gapped coordinates\n   $$readinfo{'aln_end'} = $$readinfo{'aln_start'} + length($$readinfo{'lsequence'}) - 1; # lsequence is aligned seq\n   my $alncoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => $readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigobj->id() }\n   );\n   $contigobj->set_seq_coord($alncoord, $readobj);\n\n   # Add quality clipping read information in contig features\n   # (from 'aligned read' to 'gapped consensus' coordinates)\n   $$readinfo{'clip_start'} = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_lend'});\n   $$readinfo{'clip_end'}   = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_rend'});\n   my $clipcoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_quality_clipping:'.$readobj->id,\n       -start       => $$readinfo{'clip_start'},\n       -end         => $$readinfo{'clip_end'},\n       -strand      => $$readinfo{'strand'}\n   );\n   $clipcoord->attach_seq($readobj);\n   $contigobj->add_features([ $clipcoord ], 0);\n   \n   # Add other misc read information as subsequence feature\n   my $readtags = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_main_read_feature:'.$readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'best'    => $$readinfo{'best'},\n                         'comment' => $$readinfo{'comment'} }\n   );\n   $alncoord->add_sub_SeqFeature($readtags);\n\n   return $readobj;\n}\n\n=head2 _store_singlet\n\n    Title   : _store_singlet\n    Usage   : my $singletobj = $self->_store_read(\\%readinfo, \\%contiginfo,\n                  $scaffoldobj);\n    Function: store information of a singlet belonging to a scaffold in the appropriate object\n    Returns : Bio::Assembly::Singlet\n    Args    : hash, hash, Bio::Assembly::Scaffold\n\n\nsub _store_singlet {\n    my ($self, $readinfo, $contiginfo, $scaffoldobj) = @_;\n    # Singlets in TIGR_Assembler are represented as a contig of one sequence\n    # We try to simulate this duality by playing around with the Singlet object\n    \n    my $contigid = $$contiginfo{'asmbl_id'};\n    my $readid   = $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'});\n    \n    # Create a sequence object\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $seqobj = Bio::Seq::Quality->new(\n       -primary_id => $contigid, # unique id in assembly (contig name)\n       -display_id => $readid,\n       -seq        => $$contiginfo{'lsequence'}, # do not use $$readinfo as ambiguities are uppercase\n       -start      => 1,\n       -strand     => $$readinfo{'strand'},\n       -alphabet   => 'dna',\n       -qual => $self->_qual_hex2dec($$contiginfo{'quality'})    \n   );\n\n   # Create singlet from sequence and add it to scaffold\n   my $singletobj = Bio::Assembly::Singlet->new( -seqref => $seqobj );\n   $scaffoldobj->add_singlet($singletobj);\n\n   # Add other misc contig information as features of the singlet\n   my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$contigid\",\n        -start       => 1,\n        -end         => $singletobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n   );\n   $singletobj->add_features([ $contigtags ], 1);\n\n   # Add read location and sequence to singlet features (in 'gapped consensus' coordinates)\n   $$readinfo{'aln_start'} = $$readinfo{'offset'} + 1; # seq offset is in gapped coordinates\n   $$readinfo{'aln_end'} = $$readinfo{'aln_start'} + length($$readinfo{'lsequence'}) - 1; # lsequence is aligned seq\n\n   my $alncoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_aligned_coord:$readid\",\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigid }\n   );\n   $alncoord->attach_seq($singletobj->seqref);\n   $singletobj->add_features([ $alncoord ], 0);\n\n   # Add quality clipping read information in singlet features\n   # (from 'aligned read' to 'gapped consensus' coordinates)\n   $$readinfo{'clip_start'} = $$readinfo{'seq_lend'};\n   $$readinfo{'clip_end'}   = $$readinfo{'seq_rend'};\n   my $clipcoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_quality_clipping:$readid\",\n       -start       => $$readinfo{'clip_start'},\n       -end         => $$readinfo{'clip_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigid }\n   );\n   $clipcoord->attach_seq($singletobj->seqref);\n   $singletobj->add_features([ $clipcoord ], 0);\n   \n   # Add other misc read information as subsequence feature\n   my $readtags = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_main_read_feature:$readid\",\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'best'    => $$readinfo{'best'},\n                         'comment' => $$readinfo{'comment'} }\n   );\n   $alncoord->add_sub_SeqFeature($readtags);\n      \n   return $singletobj;\n}\n\n=head2 write_assembly\n\n    Title   : write_assembly\n    Usage   : $ass_io->write_assembly($assembly)\n    Function: Write the assembly object in TIGR Assembler compatible tasm lassie  \n              format\n    Returns : 1 on success, 0 for error\n    Args    : A Bio::Assembly::Scaffold object\n\n\nsub write_assembly {\n    my ($self,@args) = @_;    \n    my ($scaffoldobj, $singlets) = $self->_rearrange([qw(SCAFFOLD SINGLETS)], @args);\n    \n    # Sanity check\n    if ( !$scaffoldobj || !$scaffoldobj->isa('Bio::Assembly::Scaffold') ) {\n        $self->warn(\"Must provide a Bio::Align::AlignI object when calling\n            write_assembly\");\n        next;\n    }\n\n    # Get list of objects - contigs and singlets\n    my @cont_ids = $scaffoldobj->get_contig_ids;\n    my @sing_ids = $scaffoldobj->get_singlet_ids;\n    my %did;\n    my $decimal_format = '%.2f';\n    for (my $i = 0; $i < scalar @sing_ids ; $i++) {\n      # singlet display id (string)\n      my $display_id = $sing_ids[$i];\n      # singlet primary id (unique, numerical)\n      my $primary_id = $scaffoldobj->get_singlet_by_id($display_id)->seqref->primary_id;\n      $sing_ids[$i] = $primary_id;\n      $did{$primary_id} = $display_id;\n    }\n    my @ids = (@cont_ids, @sing_ids);\n    @ids = sort { $a <=> $b } @ids; # list with contig ids and singlet primary id\n    my $numobj = scalar @ids;\n\n    # Output all contigs and singlets (sorted by increasing id number)\n    for (my $i = 0 ; $i < $numobj ; $i++) {\n        \n        my $objid = $ids[$i];\n        \n        if (defined $did{$objid}) { \n            # This is a singlet\n            next unless ($singlets);\n\n            my $contigid = $objid;\n            my $readid   = $did{$objid};            \n            my $singletobj = $scaffoldobj->get_singlet_by_id($readid);\n            \n            # Get contig information\n            my $contanno = (grep\n                { $_->primary_tag eq \"_main_contig_feature:$contigid\" }\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my %contiginfo;\n            $contiginfo{'sequence'}   = $singletobj->seqref->seq;\n            $contiginfo{'lsequence'}  = $contiginfo{'sequence'};\n            $contiginfo{'quality'}    = $self->_qual_dec2hex(\n                join ' ', @{$singletobj->seqref->qual});\n            $contiginfo{'asmbl_id'}   = $contigid;\n            $contiginfo{'seq_id'}     = ($contanno->get_tag_values('seq_id'))[0];   \n            $contiginfo{'com_name'}   = ($contanno->get_tag_values('com_name'))[0];\n            $contiginfo{'type'}       = ($contanno->get_tag_values('type'))[0];\n            $contiginfo{'method'}     = ($contanno->get_tag_values('method'))[0];\n            $contiginfo{'ed_status'}  = ($contanno->get_tag_values('ed_status'))[0];\n            $contiginfo{'redundancy'} = sprintf($decimal_format, 1);\n            $contiginfo{'perc_N'}     = sprintf(\n                $decimal_format, $self->_perc_N($contiginfo{'sequence'}));\n            $contiginfo{'seqnum'}     = 1;\n            $contiginfo{'full_cds'}   = ($contanno->get_tag_values('full_cds'))[0];\n            $contiginfo{'cds_start'}  = ($contanno->get_tag_values('cds_start'))[0];\n            $contiginfo{'cds_end'}    = ($contanno->get_tag_values('cds_end'))[0];\n            $contiginfo{'ed_pn'}      = ($contanno->get_tag_values('ed_pn'))[0];\n            $contiginfo{'ed_date'}    = $self->_date_time;\n            $contiginfo{'comment'}    = ($contanno->get_tag_values('comment'))[0];\n            $contiginfo{'frameshift'} = ($contanno->get_tag_values('frameshift'))[0];\n\n            # Check that no tag value is undef\n            $contiginfo{'seq_id'}     = '' unless defined $contiginfo{'seq_id'};\n            $contiginfo{'com_name'}   = '' unless defined $contiginfo{'com_name'};\n            $contiginfo{'type'}       = '' unless defined $contiginfo{'type'};\n            $contiginfo{'method'}     = '' unless defined $contiginfo{'method'};\n            $contiginfo{'ed_status'}  = '' unless defined $contiginfo{'ed_status'};\n            $contiginfo{'full_cds'}   = '' unless defined $contiginfo{'full_cds'};\n            $contiginfo{'cds_start'}  = '' unless defined $contiginfo{'cds_start'};\n            $contiginfo{'cds_end'}    = '' unless defined $contiginfo{'cds_end'};\n            $contiginfo{'ed_pn'}      = '' unless defined $contiginfo{'ed_pn'};\n            $contiginfo{'comment'}    = '' unless defined $contiginfo{'comment'};\n            $contiginfo{'frameshift'} = '' unless defined $contiginfo{'frameshift'};\n            \n            # Print contig information\n            $self->_print(\n                \"sequence\\t$contiginfo{'sequence'}\\n\".\n                \"lsequence\\t$contiginfo{'lsequence'}\\n\".\n                \"quality\\t$contiginfo{'quality'}\\n\".\n                \"asmbl_id\\t$contiginfo{'asmbl_id'}\\n\".\n                \"seq_id\\t$contiginfo{'seq_id'}\\n\".\n                \"com_name\\t$contiginfo{'com_name'}\\n\".\n                \"type\\t$contiginfo{'type'}\\n\".\n                \"method\\t$contiginfo{'method'}\\n\".\n                \"ed_status\\t$contiginfo{'ed_status'}\\n\".\n                \"redundancy\\t$contiginfo{'redundancy'}\\n\".\n                \"perc_N\\t$contiginfo{'perc_N'}\\n\".\n                \"seq#\\t$contiginfo{'seqnum'}\\n\".\n                \"full_cds\\t$contiginfo{'full_cds'}\\n\".\n                \"cds_start\\t$contiginfo{'cds_start'}\\n\".\n                \"cds_end\\t$contiginfo{'cds_end'}\\n\".\n                \"ed_pn\\t$contiginfo{'ed_pn'}\\n\".\n                \"ed_date\\t$contiginfo{'ed_date'}\\n\".\n                \"comment\\t$contiginfo{'comment'}\\n\".\n                \"frameshift\\t$contiginfo{'frameshift'}\\n\".\n                \"\\n\"\n            );\n                        \n            # Get read information\n            my ($seq_name, $db) = $self->_split_seq_name_and_db($readid);\n            my $clipcoord = (grep\n                { $_->primary_tag eq \"_quality_clipping:$readid\"}\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my $alncoord  = (grep\n                { $_->primary_tag eq \"_aligned_coord:$readid\"}\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my $readanno = (grep\n                { $_->primary_tag eq \"_main_read_feature:$readid\" }\n                $singletobj->get_seq_coord($singletobj->seqref)->get_SeqFeatures\n            )[0];\n            my %readinfo;\n            $readinfo{'seq_name'}  = $seq_name;\n            $readinfo{'asm_lend'}  = $alncoord->location->start;\n            $readinfo{'asm_rend'}  = $alncoord->location->end;\n            $readinfo{'seq_lend'}  = $clipcoord->location->start;\n            $readinfo{'seq_rend'}  = $clipcoord->location->end;\n            $readinfo{'best'}      = ($readanno->get_tag_values('best'))[0];\n            $readinfo{'comment'}   = ($readanno->get_tag_values('comment'))[0];\n            $readinfo{'db'}        = $db;         \n            $readinfo{'offset'}    = 0;\n            # ambiguities in read sequence are uppercase\n            $readinfo{'lsequence'} = uc($contiginfo{'lsequence'});\n            \n            # Check that no tag value is undef\n            $readinfo{'best'}    = '' unless defined $readinfo{'best'};\n            $readinfo{'comment'} = '' unless defined $readinfo{'comment'};\n\n            # Print read information\n            $self->_print(\n                \"seq_name\\t$readinfo{'seq_name'}\\n\".\n                \"asm_lend\\t$readinfo{'asm_lend'}\\n\".\n                \"asm_rend\\t$readinfo{'asm_rend'}\\n\".\n                \"seq_lend\\t$readinfo{'seq_lend'}\\n\".\n                \"seq_rend\\t$readinfo{'seq_rend'}\\n\".\n                \"best\\t$readinfo{'best'}\\n\".\n                \"comment\\t$readinfo{'comment'}\\n\".\n                \"db\\t$readinfo{'db'}\\n\".\n                \"offset\\t$readinfo{'offset'}\\n\".\n                \"lsequence\\t$readinfo{'lsequence'}\\n\"\n            );\n            if ($i+1 < $numobj) {\n                $self->_print(\"|\\n\");\n            }\n        } else {\n            # This is a contig\n            my $contigid = $objid;\n            my $contigobj = $scaffoldobj->get_contig_by_id($contigid);\n\n            # Skip contigs of 1 sequence (singlets) if needed\n            next if ($contigobj->num_sequences == 1) && (!$singlets);\n            \n            # Get contig information\n            my $contanno = (grep\n                { $_->primary_tag eq \"_main_contig_feature:$contigid\" }\n                $contigobj->get_features_collection->get_all_features\n            )[0];\n            my %contiginfo;\n            $contiginfo{'sequence'}   = $self->_ungap(\n                $contigobj->get_consensus_sequence->seq);\n            $contiginfo{'lsequence'}  = $contigobj->get_consensus_sequence->seq;\n            $contiginfo{'quality'}    = $self->_qual_dec2hex(\n                join ' ', @{$contigobj->get_consensus_quality->qual});\n            $contiginfo{'asmbl_id'}   = $contigid;\n            $contiginfo{'seq_id'}     = ($contanno->get_tag_values('seq_id'))[0];\n            $contiginfo{'com_name'}   = ($contanno->get_tag_values('com_name'))[0];\n            $contiginfo{'type'}       = ($contanno->get_tag_values('type'))[0];\n            $contiginfo{'method'}     = ($contanno->get_tag_values('method'))[0];\n            $contiginfo{'ed_status'}  = ($contanno->get_tag_values('ed_status'))[0];\n            $contiginfo{'redundancy'} = sprintf(\n                $decimal_format, $self->_redundancy($contigobj));\n            $contiginfo{'perc_N'}     = sprintf(\n                $decimal_format, $self->_perc_N($contiginfo{'sequence'}));\n            $contiginfo{'seqnum'}     = $contigobj->num_sequences;\n            $contiginfo{'full_cds'}   = ($contanno->get_tag_values('full_cds'))[0];\n            $contiginfo{'cds_start'}  = ($contanno->get_tag_values('cds_start'))[0];\n            $contiginfo{'cds_end'}    = ($contanno->get_tag_values('cds_end'))[0];\n            $contiginfo{'ed_pn'}      = ($contanno->get_tag_values('ed_pn'))[0];\n            $contiginfo{'ed_date'}    = $self->_date_time;\n            $contiginfo{'comment'}    = ($contanno->get_tag_values('comment'))[0];\n            $contiginfo{'frameshift'} = ($contanno->get_tag_values('frameshift'))[0];\n            \n            # Check that no tag value is undef\n            $contiginfo{'seq_id'}     = '' unless defined $contiginfo{'seq_id'};\n            $contiginfo{'com_name'}   = '' unless defined $contiginfo{'com_name'};\n            $contiginfo{'type'}       = '' unless defined $contiginfo{'type'};\n            $contiginfo{'method'}     = '' unless defined $contiginfo{'method'};\n            $contiginfo{'ed_status'}  = '' unless defined $contiginfo{'ed_status'};\n            $contiginfo{'full_cds'}   = '' unless defined $contiginfo{'full_cds'};\n            $contiginfo{'cds_start'}  = '' unless defined $contiginfo{'cds_start'};\n            $contiginfo{'cds_end'}    = '' unless defined $contiginfo{'cds_end'};\n            $contiginfo{'ed_pn'}      = '' unless defined $contiginfo{'ed_pn'};\n            $contiginfo{'comment'}    = '' unless defined $contiginfo{'comment'};\n            $contiginfo{'frameshift'} = '' unless defined $contiginfo{'frameshift'};\n                       \n            # Print contig information\n            $self->_print(\n                \"sequence\\t$contiginfo{'sequence'}\\n\".\n                \"lsequence\\t$contiginfo{'lsequence'}\\n\".\n                \"quality\\t$contiginfo{'quality'}\\n\".\n                \"asmbl_id\\t$contiginfo{'asmbl_id'}\\n\".\n                \"seq_id\\t$contiginfo{'seq_id'}\\n\".\n                \"com_name\\t$contiginfo{'com_name'}\\n\".\n                \"type\\t$contiginfo{'type'}\\n\".\n                \"method\\t$contiginfo{'method'}\\n\".\n                \"ed_status\\t$contiginfo{'ed_status'}\\n\".\n                \"redundancy\\t$contiginfo{'redundancy'}\\n\".\n                \"perc_N\\t$contiginfo{'perc_N'}\\n\".\n                \"seq#\\t$contiginfo{'seqnum'}\\n\".\n                \"full_cds\\t$contiginfo{'full_cds'}\\n\".\n                \"cds_start\\t$contiginfo{'cds_start'}\\n\".\n                \"cds_end\\t$contiginfo{'cds_end'}\\n\".\n                \"ed_pn\\t$contiginfo{'ed_pn'}\\n\".\n                \"ed_date\\t$contiginfo{'ed_date'}\\n\".\n                \"comment\\t$contiginfo{'comment'}\\n\".\n                \"frameshift\\t$contiginfo{'frameshift'}\\n\".\n                \"\\n\"\n            );\n            my $seqno = 0;\n            for my $readobj ( $contigobj->each_seq() ) {\n                $seqno++;\n                \n                # Get read information\n                my ($seq_name, $db) = $self->_split_seq_name_and_db($readobj->id);\n                my ($asm_lend, $asm_rend, $seq_lend, $seq_rend, $offset)\n                    = $self->_coord($readobj, $contigobj);\n                my $readanno = ( grep \n                    { $_->primary_tag eq '_main_read_feature:'.$readobj->primary_id }\n                    $contigobj->get_seq_coord($readobj)->get_SeqFeatures\n                )[0];\n                my %readinfo;                \n                $readinfo{'seq_name'}  = $seq_name;\n                $readinfo{'asm_lend'}  = $asm_lend;\n                $readinfo{'asm_rend'}  = $asm_rend;\n                $readinfo{'seq_lend'}  = $seq_lend;\n                $readinfo{'seq_rend'}  = $seq_rend;                \n                $readinfo{'best'}      = ($readanno->get_tag_values('best'))[0];\n                $readinfo{'comment'}   = ($readanno->get_tag_values('comment'))[0];\n                $readinfo{'db'}        = $db;\n                $readinfo{'offset'}    = $offset;   \n                $readinfo{'lsequence'} = $readobj->seq(); \n                         \n                # Check that no tag value is undef\n                $readinfo{'best'}    = '' unless defined $readinfo{'best'};\n                $readinfo{'comment'} = '' unless defined $readinfo{'comment'};\n    \n                # Print read information\n                $self->_print(\n                    \"seq_name\\t$readinfo{'seq_name'}\\n\".\n                    \"asm_lend\\t$readinfo{'asm_lend'}\\n\".\n                    \"asm_rend\\t$readinfo{'asm_rend'}\\n\".\n                    \"seq_lend\\t$readinfo{'seq_lend'}\\n\".\n                    \"seq_rend\\t$readinfo{'seq_rend'}\\n\".\n                    \"best\\t$readinfo{'best'}\\n\".\n                    \"comment\\t$readinfo{'comment'}\\n\".\n                    \"db\\t$readinfo{'db'}\\n\".\n                    \"offset\\t$readinfo{'offset'}\\n\".\n                    \"lsequence\\t$readinfo{'lsequence'}\\n\"\n                );\n                if ($seqno < $contiginfo{'seqnum'}) {\n                    $self->_print(\"\\n\");\n                } elsif (($seqno == $contiginfo{'seqnum'}) && ($i+1 < $numobj)) {\n                    $self->_print(\"|\\n\");\n                }\n            }\n        }\n    }\n    return 1;\n}\n\n=head2 _perc_N\n\n    Title   : _perc_N\n    Usage   : my $perc_N = $ass_io->_perc_N($sequence_string)\n    Function: Calculate the percent of ambiguities in a sequence.\n              M R W S Y K X N are regarded as ambiguites in an aligned read\n              sequence by TIGR Assembler. In the case of a gapped contig\n              consensus sequence, all lowercase symbols are ambiguities, i.e.:\n              a c g t u m r w s y k x n.\n    Returns : decimal number\n    Args    : string","parameters":[{"label":"$self"},{"label":"$seq_string"}],"label":"_perc_N($self,$seq_string)"},"detail":"($self,$seq_string)","definition":"sub","containerName":"main::"},{"kind":12,"children":[{"kind":13,"line":988,"definition":"my","name":"$self","containerName":"_redundancy","localvar":"my"},{"kind":13,"line":988,"name":"$contigobj","containerName":"_redundancy"},{"name":"$redundancy","definition":"my","containerName":"_redundancy","localvar":"my","kind":13,"line":989},{"kind":13,"line":992,"definition":"my","name":"$read_tot","containerName":"_redundancy","localvar":"my"},{"name":"$readobj","definition":"my","containerName":"_redundancy","localvar":"my","kind":13,"line":993},{"containerName":"_redundancy","name":"$contigobj","line":993,"kind":13},{"line":993,"kind":12,"containerName":"_redundancy","name":"each_seq"},{"kind":13,"line":994,"definition":"my","name":"$read_length","containerName":"_redundancy","localvar":"my"},{"name":"$readobj","containerName":"_redundancy","line":994,"kind":13},{"name":"seq","containerName":"_redundancy","line":994,"kind":12},{"name":"$read_tot","containerName":"_redundancy","line":995,"kind":13},{"kind":13,"line":995,"name":"$read_length","containerName":"_redundancy"},{"kind":13,"line":997,"containerName":"_redundancy","name":"$redundancy"},{"containerName":"_redundancy","name":"$read_tot","kind":13,"line":997},{"localvar":"my","containerName":"_redundancy","definition":"my","name":"$consensus_sequence","line":1000,"kind":13},{"line":1000,"kind":13,"containerName":"_redundancy","name":"$contigobj"},{"kind":12,"line":1000,"containerName":"_redundancy","name":"get_consensus_sequence"},{"kind":12,"line":1000,"name":"seq","containerName":"_redundancy"},{"line":1001,"kind":13,"localvar":"my","containerName":"_redundancy","definition":"my","name":"@consensus_gaps"},{"kind":13,"line":1002,"containerName":"_redundancy","name":"$contigobj"},{"kind":12,"line":1002,"containerName":"_redundancy","name":"_register_gaps"},{"containerName":"_redundancy","name":"$consensus_sequence","kind":13,"line":1002},{"name":"@consensus_gaps","containerName":"_redundancy","line":1002,"kind":13},{"kind":13,"line":1003,"containerName":"_redundancy","definition":"my","name":"$respected_gaps","localvar":"my"},{"kind":13,"line":1003,"containerName":"_redundancy","name":"@consensus_gaps"},{"containerName":"_redundancy","name":"$respected_gaps","kind":13,"line":1004},{"kind":13,"line":1005,"name":"@cons_arr","definition":"my","containerName":"_redundancy","localvar":"my"},{"containerName":"_redundancy","name":"$consensus_sequence","line":1005,"kind":13},{"kind":13,"line":1006,"containerName":"_redundancy","name":"$gap_pos_cons","definition":"my","localvar":"my"},{"containerName":"_redundancy","name":"@consensus_gaps","kind":13,"line":1006},{"localvar":"my","definition":"my","name":"$readobj","containerName":"_redundancy","line":1007,"kind":13},{"kind":13,"line":1007,"containerName":"_redundancy","name":"$contigobj"},{"line":1007,"kind":12,"name":"each_seq","containerName":"_redundancy"},{"containerName":"_redundancy","definition":"my","name":"$readid","localvar":"my","kind":13,"line":1008},{"containerName":"_redundancy","name":"$readobj","kind":13,"line":1008},{"containerName":"_redundancy","name":"id","line":1008,"kind":12},{"name":"$read_start","definition":"my","containerName":"_redundancy","localvar":"my","kind":13,"line":1009},{"containerName":"_redundancy","name":"$contigobj","kind":13,"line":1009},{"name":"change_coord","containerName":"_redundancy","line":1009,"kind":12},{"kind":13,"line":1010,"name":"$readobj","containerName":"_redundancy"},{"name":"start","containerName":"_redundancy","line":1010,"kind":12},{"containerName":"_redundancy","definition":"my","name":"$read_end","localvar":"my","kind":13,"line":1011},{"containerName":"_redundancy","name":"$contigobj","line":1011,"kind":13},{"line":1011,"kind":12,"containerName":"_redundancy","name":"change_coord"},{"line":1012,"kind":13,"name":"$readobj","containerName":"_redundancy"},{"kind":12,"line":1012,"containerName":"_redundancy","name":"end"},{"name":"$gap_pos_cons","containerName":"_redundancy","kind":13,"line":1014},{"kind":13,"line":1014,"containerName":"_redundancy","name":"$read_start"},{"containerName":"_redundancy","name":"$gap_pos_cons","kind":13,"line":1015},{"name":"$read_end","containerName":"_redundancy","kind":13,"line":1015},{"kind":13,"line":1017,"name":"@read_arr","definition":"my","containerName":"_redundancy","localvar":"my"},{"line":1017,"kind":13,"containerName":"_redundancy","name":"$readobj"},{"name":"seq","containerName":"_redundancy","line":1017,"kind":12},{"kind":13,"line":1018,"definition":"my","name":"$gap_pos_read","containerName":"_redundancy","localvar":"my"},{"kind":13,"line":1018,"containerName":"_redundancy","name":"$contigobj"},{"name":"change_coord","containerName":"_redundancy","line":1018,"kind":12},{"containerName":"_redundancy","name":"$gap_pos_cons","line":1019,"kind":13},{"line":1020,"kind":13,"containerName":"_redundancy","name":"$read_arr"},{"line":1020,"kind":13,"containerName":"_redundancy","name":"$gap_pos_read"},{"name":"$cons_arr","containerName":"_redundancy","kind":13,"line":1020},{"containerName":"_redundancy","name":"$gap_pos_cons","line":1020,"kind":13},{"name":"$respected_gaps","containerName":"_redundancy","line":1021,"kind":13},{"line":1026,"kind":13,"containerName":"_redundancy","name":"$redundancy"},{"name":"$respected_gaps","containerName":"_redundancy","line":1026,"kind":13},{"containerName":"_redundancy","name":"$contig_length","definition":"my","localvar":"my","kind":13,"line":1029},{"containerName":"_redundancy","name":"$self","line":1029,"kind":13},{"name":"_ungap","containerName":"_redundancy","kind":12,"line":1029},{"kind":13,"line":1029,"name":"$contigobj","containerName":"_redundancy"},{"name":"get_consensus_sequence","containerName":"_redundancy","kind":12,"line":1029},{"name":"seq","containerName":"_redundancy","line":1029,"kind":12},{"containerName":"_redundancy","name":"$redundancy","kind":13,"line":1030},{"name":"$contig_length","containerName":"_redundancy","line":1030,"kind":13},{"name":"$redundancy","containerName":"_redundancy","kind":13,"line":1032}],"line":984,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$contigobj"}],"documentation":"__END__\n# $Id: tigr.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO::tigr\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO::tigr - Driver to read and write assembly files in the TIGR\nAssembler v2 default format.\n\n=head1 SYNOPSIS\n\n    # Building an input stream\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $asmio = Bio::Assembly::IO->new( -file   => 'SGC0-424.tasm',\n                                        -format => 'tigr' );\n    my $scaffold = $asmio->next_assembly;\n\n    # Do some things on contigs...\n\n    # Assembly writing methods\n    my $outasm = Bio::Assembly::IO->new( -file   => \">SGC0-modified.tasm\",\n                                         -format => 'tigr' );\n    $outasm->write_assembly( -scaffold => $assembly,\n                             -singlets => 1 );\n\n=head1 DESCRIPTION\n\nThis package loads and writes assembly information in/from files in the default\nTIGR Assembler v2 format. The files are lassie-formatted and often have the\n.tasm extension. This module was written to be used as a driver module for\nBio::Assembly::IO input/output.\n\n=head2 Implementation\n\nAssemblies are loaded into Bio::Assembly::Scaffold objects composed of\nBio::Assembly::Contig and Bio::Assembly::Singlet objects. Since aligned reads\nand contig gapped consensus can be obtained in the tasm files, only\naligned/gapped sequences are added to the different BioPerl objects.\n\nAdditional assembly information is stored as features. Contig objects have\nSeqFeature information associated with the primary_tag:\n\n    _main_contig_feature:$contig_id -> misc contig information\n    _quality_clipping:$read_id      -> quality clipping position\n\nRead objects have sub_seqFeature information associated with the\nprimary_tag:\n\n    _main_read_feature:$read_id     -> misc read information\n\nSinglets are considered by TIGR Assembler as contigs of one sequence and are\nrepresented here with features having these primary_tag: \n\n    _main_contig_feature:$contig_id\n    _quality_clipping:$read_primary_id\n    _main_read_feature:$read_primary_id\n    _aligned_coord:$read_primary_id\n\n=head1 THE TIGR TASM LASSIEFORMAT\n\n=head2 Description\n\nIn the TIGR tasm lassie format, contigs are separated by a line containing a single\npipe character \"|\", whereas the reads in a contig are separated by a blank line.\nSinglets can be present in the file and are represented as a contig\ncomposed of a single sequence.\n\nOther than the two above-mentioned separators, each line has an attribute name,\nfollowed a tab and then an attribute value.\n\nThe tasm format is used by more TIGR applications than just TIGR Assembler.\nSome of the attributes are not used by TIGR Assembler or have constant values.\nThey are indicated by an asterisk *\n\nContigs have the following attributes:\n\n    asmbl_id   -> contig ID\n    sequence   -> contig ungapped consensus sequence (ambiguities are lowercase)\n    lsequence  -> gapped consensus sequence (lowercase ambiguities)\n    quality    -> gapped consensus quality score (in hexadecimal)\n    seq_id     -> *\n    com_name   -> *\n    type       -> *\n    method     -> always 'asmg' *\n    ed_status  -> *\n    redundancy -> fold coverage of the contig consensus\n    perc_N     -> percent of ambiguities in the contig consensus\n    seq#       -> number of sequences in the contig\n    full_cds   -> *\n    cds_start  -> start of coding sequence *\n    cds_end    -> end of coding sequence *\n    ed_pn      -> name of editor (always 'GRA') *\n    ed_date    -> date and time of edition\n    comment    -> some comments *\n    frameshift -> *\n\nEach read has the following attributes:\n\n    seq_name  -> read name\n    asm_lend  -> position of first base on contig ungapped consensus sequence\n    asm_rend  -> position of last base on contig ungapped consensus sequence\n    seq_lend  -> start of quality-trimmed sequence (aligned read coordinates)\n    seq_rend  -> end of quality-trimmed sequence (aligned read coordinates)\n    best      -> always '0' *\n    comment   -> some comments *\n    db        -> database name associated with the sequence (e.g. >my_db|seq1234)\n    offset    -> offset of the sequence (gapped consensus coordinates)\n    lsequence -> aligned read sequence (ambiguities are uppercase)\n\nWhen asm_rend E<lt> asm_lend, the sequence was on the complementary DNA strand but\nits reverse complement is shown in the aligned sequence of the assembly file,\nnot the original read.\n\nAmbiguities are reflected in the contig consensus sequence as\nlowercase IUPAC characters: a c g t u m r w s y k x n . In the read\nsequences, however, ambiguities are uppercase: M R W S Y K X N\n\n=head2 Example\n\nExample of a contig containing three sequences:\n\n    sequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCGCAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    quality\t0x0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0505050505050505050E0505160505050505050505050505050505050505050505050505050505050303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0404040404040404041604040404040404040404040404040404040404040404040404040404040404040404040404040404040E0404040404040404040B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B\n    asmbl_id\t93\n    seq_id\t\n    com_name\t\n    type\t\n    method\tasmg\n    ed_status\t\n    redundancy\t1.11\n    perc_N\t0.20\n    seq#\t3\n    full_cds\t\n    cds_start\t\n    cds_end\t\n    ed_pn\tGRA\n    ed_date\t08/16/07 17:10:12\n    comment\t\n    frameshift\t\n\n    seq_name\tSDSU_RFPERU_010_C09.x01.phd.1\n    asm_lend\t1\n    asm_rend\t4423\n    seq_lend\t1\n    seq_rend\t442\n    best\t0\n    comment\t\n    db\t\n    offset\t0\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAGCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGG\n\n    seq_name\tSDSU_RFPERU_002_H12.x01.phd.1\n    asm_lend\t339\n    asm_rend\t940\n    seq_lend\t1\n    seq_rend\t602\n    best\t0\n    comment\t\n    db\t\n    offset\t338\n    lsequence\tCGAGATTCGCCACCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCCGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATA-GCGTGGCGC\n\n    seq_name\tSDSU_RFPERU_009_E07.x01.phd.1\n    asm_lend\t880\n    asm_rend\t1520\n    seq_lend\t641\n    seq_rend\t1\n    best\t0\n    comment\t\n    db\t\n    offset\t8803\n    lsequence\tCGCACGGTCTGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAAGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    |\n\n...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent dot angly at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::IO::tigr;\n\nuse strict;\nuse Bio::Seq::Quality;\nuse Bio::LocatableSeq;\nuse Bio::Assembly::IO;\nuse Bio::Assembly::Scaffold;\nuse Bio::Assembly::Contig;\nuse Bio::Assembly::Singlet;\n\nuse base qw(Bio::Assembly::IO);\n\nmy $progname = 'TIGR Assembler';\n\n=head2 next_assembly\n\n Title   : next_assembly\n Usage   : my $scaffold = $asmio->next_assembly()\n Function: return the next assembly in the tasm-formatted stream\n Returns : Bio::Assembly::Scaffold object\n Args    : none\n\n\nsub next_assembly {\n    my $self = shift; # object reference\n    \n    # Create a new scaffold to hold the contigs\n    my $scaffoldobj = Bio::Assembly::Scaffold->new(-source => $progname);\n    \n    # Contig and read related\n    my $contigobj;\n    my $iscontig = 1;\n    my %contiginfo;\n    my $isread = 0;\n    my %readinfo;\n    \n    # Loop over all assembly file lines\n    while ($_ = $self->_readline) {\n        chomp;\n        if ( /^\\|/ ) {  # a line with a single pipe |\n            # The end of a read from a contig, the start of a new contig\n            $iscontig = 1;\n            $isread   = 0;\n            # Store read info\n            if ($contiginfo{'seqnum'} > 1) {\n                # This is a read in a contig\n                my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n            } elsif ($contiginfo{'seqnum'} == 1) {\n                # This is a singlet\n                my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                    $scaffoldobj);\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n            # Clear read info\n            undef %readinfo;\n            # Clear contig info\n            undef $contigobj;\n            undef %contiginfo;\n        } elsif ( /^$/ ) {  # a blank line\n            if ($iscontig) {\n                # The end of a contig, the start of a read in that contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store contig info\n                $contigobj = $self->_store_contig( \\%contiginfo, $contigobj,\n                    $scaffoldobj ) if $contiginfo{'seqnum'} > 1;\n            } elsif ($isread) {\n                # The end of read in a contig, the start of a new one in\n                # the same contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store read info\n                if ($contiginfo{'seqnum'} > 1) {\n                    # This is a read in a contig\n                    my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n                } elsif ($contiginfo{'seqnum'} == 1) {\n                    # This is a singlet\n                    my $singletobj = $self->_store_singlet(\\%readinfo,\n                        \\%contiginfo, $scaffoldobj);\n                } else {\n                  # That should not happen\n                  $self->throw(\"Unhandled exception\");\n                }\n                # Clear read info\n                undef %readinfo;\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n        } else {\n            if ($iscontig) {\n                # Parse contig\n                if    (/^sequence\\t(.*)/)     {$contiginfo{'sequence'}   = $1; next}\n                elsif (/^lsequence\\t(.*)/)    {$contiginfo{'lsequence'}  = $1; next}\n                elsif (/^quality\\t(.*)/)      {$contiginfo{'quality'}    = $1; next}\n                elsif (/^asmbl_id\\t(.*)/)     {$contiginfo{'asmbl_id'}   = $1; next}\n                elsif (/^seq_id\\t(.*)/)       {$contiginfo{'seq_id'}     = $1; next}\n                elsif (/^com_name\\t(.*)/)     {$contiginfo{'com_name'}   = $1; next}\n                elsif (/^type\\t(.*)/)         {$contiginfo{'type'}       = $1; next}\n                elsif (/^method\\t(.*)/)       {$contiginfo{'method'}     = $1; next}\n                elsif (/^ed_status\\t(.*)/)    {$contiginfo{'ed_status'}  = $1; next}\n                elsif (/^redundancy\\t(.*)/)   {$contiginfo{'redundancy'} = $1; next}\n                elsif (/^perc_N\\t(.*)/)       {$contiginfo{'perc_N'}     = $1; next}\n                elsif (/^seq\\#\\t(.*)/)        {$contiginfo{'seqnum'}     = $1; next}\n                elsif (/^full_cds\\t(.*)/)     {$contiginfo{'full_cds'}   = $1; next}\n                elsif (/^cds_start\\t(.*)/)    {$contiginfo{'cds_start'}  = $1; next}\n                elsif (/^cds_end\\t(.*)/)      {$contiginfo{'cds_end'}    = $1; next}\n                elsif (/^ed_pn\\t(.*)/)        {$contiginfo{'ed_pn'}      = $1; next}\n                elsif (/^ed_date\\t(.*\\s.*)/)  {$contiginfo{'ed_date'}    = $1; next}\n                elsif (/^comment\\t(.*)/)      {$contiginfo{'comment'}    = $1; next}\n                elsif (/^frameshift\\t(.*)/)   {$contiginfo{'frameshift'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } elsif ($isread) {\n                # Parse read info\n                if    (/^seq_name\\t(.*)/)  {$readinfo{'seq_name'}  = $1; next}\n                elsif (/^asm_lend\\t(.*)/)  {$readinfo{'asm_lend'}  = $1; next}\n                elsif (/^asm_rend\\t(.*)/)  {$readinfo{'asm_rend'}  = $1; next}\n                elsif (/^seq_lend\\t(.*)/)  {$readinfo{'seq_lend'}  = $1; next}\n                elsif (/^seq_rend\\t(.*)/)  {$readinfo{'seq_rend'}  = $1; next}\n                elsif (/^best\\t(.*)/)      {$readinfo{'best'}      = $1; next}\n                elsif (/^comment\\t(.*)/)   {$readinfo{'comment'}   = $1; next}\n                elsif (/^db\\t(.*)/)        {$readinfo{'db'}        = $1; next}\n                elsif (/^offset\\t(.*)/)    {$readinfo{'offset'}    = $1; next}\n                elsif (/^lsequence\\t(.*)/) {$readinfo{'lsequence'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } else {\n                # That shouldn't happen\n                $self->throw(\"Unhandled exception\");                \n            }\n        }\n    }\n    # Store read info for last read\n    if (defined $contiginfo{'seqnum'}) {\n        if ($contiginfo{'seqnum'} > 1) {\n            # This is a read in a contig\n            my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n        } elsif ($contiginfo{'seqnum'} == 1) {\n            # This is a singlet\n            my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                $scaffoldobj);\n        } else {\n            # That should not happen\n            $self->throw(\"Unhandled exception\");\n        }\n    }\n    # Clear read info for last read\n    undef %readinfo;\n    # Clear contig info for last contig\n    undef $contigobj;\n    undef %contiginfo;\n    \n    $scaffoldobj->update_seq_list();\n    \n    return $scaffoldobj;\n}\n\n=head2 _qual_hex2dec\n\n    Title   : _qual_hex2dec\n    Usage   : my dec_quality = $self->_qual_hex2dec($hex_quality);\n    Function: convert an hexadecimal quality score into a decimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_hex2dec {\n    my ($self, $qual) = @_;\n    $qual =~ s/^0x(.*)$/$1/;\n    $qual =~ s/(..)/hex($1).' '/eg;\n    return $qual;\n}\n\n=head2 _qual_dec2hex\n\n    Title   : _qual_dec2hex\n    Usage   : my hex_quality = $self->_qual_dec2hex($dec_quality);\n    Function: convert a decimal quality score into an hexadecimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_dec2hex {\n    my ($self, $qual) = @_;\n    $qual =~ s/(\\d+)\\s*/sprintf('%02X', $1)/eg;\n    $qual = '0x'.$qual;\n    return $qual;\n}\n\n=head2 _store_contig\n\n    Title   : _store_contig\n    Usage   : my $contigobj; $contigobj = $self->_store_contig(\n              \\%contiginfo, $contigobj, $scaffoldobj);\n    Function: store information of a contig belonging to a scaffold in the\n              appropriate object\n    Returns : Bio::Assembly::Contig object\n    Args    : hash, Bio::Assembly::Contig, Bio::Assembly::Scaffold\n\n\nsub _store_contig {\n    my ($self, $contiginfo, $contigobj, $scaffoldobj) = @_;\n\n    # Create a contig and attach it to scaffold\n    $contigobj = Bio::Assembly::Contig->new(\n        -id     => $$contiginfo{'asmbl_id'},\n        -source => $progname,\n        -strand => 1\n    );\n    $scaffoldobj->add_contig($contigobj);\n\n    # Create a gapped consensus sequence and attach it to contig\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $consensus = Bio::LocatableSeq->new(\n        -id    => $$contiginfo{'asmbl_id'},\n        -seq   => $$contiginfo{'lsequence'},\n        -start => 1,\n    );\n    $contigobj->set_consensus_sequence($consensus);\n\n    # Create an gapped consensus quality score and attach it to contig\n    $$contiginfo{'quality'} = $self->_qual_hex2dec($$contiginfo{'quality'});\n    my $qual = Bio::Seq::Quality->new(\n        -id   => $$contiginfo{'asmbl_id'},\n        -qual => $$contiginfo{'quality'}\n    );\n    $contigobj->set_consensus_quality($qual);\n\n    # Add other misc contig information as features of the contig\n    my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$$contiginfo{'asmbl_id'}\",\n        -start       => 1,\n        -end         => $contigobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n    );\n    $contigobj->add_features([ $contigtags ], 1);\n\n    return $contigobj;\n}\n\n=head2 _store_read\n\n    Title   : _store_read\n    Usage   : my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n    Function: store information of a read belonging to a contig in the appropriate object\n    Returns : Bio::LocatableSeq\n    Args    : hash, Bio::Assembly::Contig\n\n\nsub _store_read {\n   my ($self, $readinfo, $contigobj) = @_;\n\n   # Create an aligned read object\n   #$$readinfo{'llength'} = length($$readinfo{'lsequence'});\n   $$readinfo{'strand'}  = ($$readinfo{'seq_rend'} > $$readinfo{'seq_lend'} ? 1 : -1);\n   my $readobj = Bio::LocatableSeq->new(\n       # the ids of sequence objects are supposed to include the db name in it, i.e. \"big_db|seq1234\"\n       # that's how sequence ids coming from the fasta parser are at least\n       -display_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -primary_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -seq        => $$readinfo{'lsequence'},      \n       -start      => 1,\n       -strand     => $$readinfo{'strand'},\n       -alphabet   => 'dna'\n   );\n\n   # Add read location and sequence to contig (in 'gapped consensus' coordinates)\n   $$readinfo{'aln_start'} = $$readinfo{'offset'} + 1; # seq offset is in gapped coordinates\n   $$readinfo{'aln_end'} = $$readinfo{'aln_start'} + length($$readinfo{'lsequence'}) - 1; # lsequence is aligned seq\n   my $alncoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => $readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigobj->id() }\n   );\n   $contigobj->set_seq_coord($alncoord, $readobj);\n\n   # Add quality clipping read information in contig features\n   # (from 'aligned read' to 'gapped consensus' coordinates)\n   $$readinfo{'clip_start'} = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_lend'});\n   $$readinfo{'clip_end'}   = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_rend'});\n   my $clipcoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_quality_clipping:'.$readobj->id,\n       -start       => $$readinfo{'clip_start'},\n       -end         => $$readinfo{'clip_end'},\n       -strand      => $$readinfo{'strand'}\n   );\n   $clipcoord->attach_seq($readobj);\n   $contigobj->add_features([ $clipcoord ], 0);\n   \n   # Add other misc read information as subsequence feature\n   my $readtags = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_main_read_feature:'.$readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'best'    => $$readinfo{'best'},\n                         'comment' => $$readinfo{'comment'} }\n   );\n   $alncoord->add_sub_SeqFeature($readtags);\n\n   return $readobj;\n}\n\n=head2 _store_singlet\n\n    Title   : _store_singlet\n    Usage   : my $singletobj = $self->_store_read(\\%readinfo, \\%contiginfo,\n                  $scaffoldobj);\n    Function: store information of a singlet belonging to a scaffold in the appropriate object\n    Returns : Bio::Assembly::Singlet\n    Args    : hash, hash, Bio::Assembly::Scaffold\n\n\nsub _store_singlet {\n    my ($self, $readinfo, $contiginfo, $scaffoldobj) = @_;\n    # Singlets in TIGR_Assembler are represented as a contig of one sequence\n    # We try to simulate this duality by playing around with the Singlet object\n    \n    my $contigid = $$contiginfo{'asmbl_id'};\n    my $readid   = $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'});\n    \n    # Create a sequence object\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $seqobj = Bio::Seq::Quality->new(\n       -primary_id => $contigid, # unique id in assembly (contig name)\n       -display_id => $readid,\n       -seq        => $$contiginfo{'lsequence'}, # do not use $$readinfo as ambiguities are uppercase\n       -start      => 1,\n       -strand     => $$readinfo{'strand'},\n       -alphabet   => 'dna',\n       -qual => $self->_qual_hex2dec($$contiginfo{'quality'})    \n   );\n\n   # Create singlet from sequence and add it to scaffold\n   my $singletobj = Bio::Assembly::Singlet->new( -seqref => $seqobj );\n   $scaffoldobj->add_singlet($singletobj);\n\n   # Add other misc contig information as features of the singlet\n   my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$contigid\",\n        -start       => 1,\n        -end         => $singletobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n   );\n   $singletobj->add_features([ $contigtags ], 1);\n\n   # Add read location and sequence to singlet features (in 'gapped consensus' coordinates)\n   $$readinfo{'aln_start'} = $$readinfo{'offset'} + 1; # seq offset is in gapped coordinates\n   $$readinfo{'aln_end'} = $$readinfo{'aln_start'} + length($$readinfo{'lsequence'}) - 1; # lsequence is aligned seq\n\n   my $alncoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_aligned_coord:$readid\",\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigid }\n   );\n   $alncoord->attach_seq($singletobj->seqref);\n   $singletobj->add_features([ $alncoord ], 0);\n\n   # Add quality clipping read information in singlet features\n   # (from 'aligned read' to 'gapped consensus' coordinates)\n   $$readinfo{'clip_start'} = $$readinfo{'seq_lend'};\n   $$readinfo{'clip_end'}   = $$readinfo{'seq_rend'};\n   my $clipcoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_quality_clipping:$readid\",\n       -start       => $$readinfo{'clip_start'},\n       -end         => $$readinfo{'clip_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigid }\n   );\n   $clipcoord->attach_seq($singletobj->seqref);\n   $singletobj->add_features([ $clipcoord ], 0);\n   \n   # Add other misc read information as subsequence feature\n   my $readtags = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_main_read_feature:$readid\",\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'best'    => $$readinfo{'best'},\n                         'comment' => $$readinfo{'comment'} }\n   );\n   $alncoord->add_sub_SeqFeature($readtags);\n      \n   return $singletobj;\n}\n\n=head2 write_assembly\n\n    Title   : write_assembly\n    Usage   : $ass_io->write_assembly($assembly)\n    Function: Write the assembly object in TIGR Assembler compatible tasm lassie  \n              format\n    Returns : 1 on success, 0 for error\n    Args    : A Bio::Assembly::Scaffold object\n\n\nsub write_assembly {\n    my ($self,@args) = @_;    \n    my ($scaffoldobj, $singlets) = $self->_rearrange([qw(SCAFFOLD SINGLETS)], @args);\n    \n    # Sanity check\n    if ( !$scaffoldobj || !$scaffoldobj->isa('Bio::Assembly::Scaffold') ) {\n        $self->warn(\"Must provide a Bio::Align::AlignI object when calling\n            write_assembly\");\n        next;\n    }\n\n    # Get list of objects - contigs and singlets\n    my @cont_ids = $scaffoldobj->get_contig_ids;\n    my @sing_ids = $scaffoldobj->get_singlet_ids;\n    my %did;\n    my $decimal_format = '%.2f';\n    for (my $i = 0; $i < scalar @sing_ids ; $i++) {\n      # singlet display id (string)\n      my $display_id = $sing_ids[$i];\n      # singlet primary id (unique, numerical)\n      my $primary_id = $scaffoldobj->get_singlet_by_id($display_id)->seqref->primary_id;\n      $sing_ids[$i] = $primary_id;\n      $did{$primary_id} = $display_id;\n    }\n    my @ids = (@cont_ids, @sing_ids);\n    @ids = sort { $a <=> $b } @ids; # list with contig ids and singlet primary id\n    my $numobj = scalar @ids;\n\n    # Output all contigs and singlets (sorted by increasing id number)\n    for (my $i = 0 ; $i < $numobj ; $i++) {\n        \n        my $objid = $ids[$i];\n        \n        if (defined $did{$objid}) { \n            # This is a singlet\n            next unless ($singlets);\n\n            my $contigid = $objid;\n            my $readid   = $did{$objid};            \n            my $singletobj = $scaffoldobj->get_singlet_by_id($readid);\n            \n            # Get contig information\n            my $contanno = (grep\n                { $_->primary_tag eq \"_main_contig_feature:$contigid\" }\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my %contiginfo;\n            $contiginfo{'sequence'}   = $singletobj->seqref->seq;\n            $contiginfo{'lsequence'}  = $contiginfo{'sequence'};\n            $contiginfo{'quality'}    = $self->_qual_dec2hex(\n                join ' ', @{$singletobj->seqref->qual});\n            $contiginfo{'asmbl_id'}   = $contigid;\n            $contiginfo{'seq_id'}     = ($contanno->get_tag_values('seq_id'))[0];   \n            $contiginfo{'com_name'}   = ($contanno->get_tag_values('com_name'))[0];\n            $contiginfo{'type'}       = ($contanno->get_tag_values('type'))[0];\n            $contiginfo{'method'}     = ($contanno->get_tag_values('method'))[0];\n            $contiginfo{'ed_status'}  = ($contanno->get_tag_values('ed_status'))[0];\n            $contiginfo{'redundancy'} = sprintf($decimal_format, 1);\n            $contiginfo{'perc_N'}     = sprintf(\n                $decimal_format, $self->_perc_N($contiginfo{'sequence'}));\n            $contiginfo{'seqnum'}     = 1;\n            $contiginfo{'full_cds'}   = ($contanno->get_tag_values('full_cds'))[0];\n            $contiginfo{'cds_start'}  = ($contanno->get_tag_values('cds_start'))[0];\n            $contiginfo{'cds_end'}    = ($contanno->get_tag_values('cds_end'))[0];\n            $contiginfo{'ed_pn'}      = ($contanno->get_tag_values('ed_pn'))[0];\n            $contiginfo{'ed_date'}    = $self->_date_time;\n            $contiginfo{'comment'}    = ($contanno->get_tag_values('comment'))[0];\n            $contiginfo{'frameshift'} = ($contanno->get_tag_values('frameshift'))[0];\n\n            # Check that no tag value is undef\n            $contiginfo{'seq_id'}     = '' unless defined $contiginfo{'seq_id'};\n            $contiginfo{'com_name'}   = '' unless defined $contiginfo{'com_name'};\n            $contiginfo{'type'}       = '' unless defined $contiginfo{'type'};\n            $contiginfo{'method'}     = '' unless defined $contiginfo{'method'};\n            $contiginfo{'ed_status'}  = '' unless defined $contiginfo{'ed_status'};\n            $contiginfo{'full_cds'}   = '' unless defined $contiginfo{'full_cds'};\n            $contiginfo{'cds_start'}  = '' unless defined $contiginfo{'cds_start'};\n            $contiginfo{'cds_end'}    = '' unless defined $contiginfo{'cds_end'};\n            $contiginfo{'ed_pn'}      = '' unless defined $contiginfo{'ed_pn'};\n            $contiginfo{'comment'}    = '' unless defined $contiginfo{'comment'};\n            $contiginfo{'frameshift'} = '' unless defined $contiginfo{'frameshift'};\n            \n            # Print contig information\n            $self->_print(\n                \"sequence\\t$contiginfo{'sequence'}\\n\".\n                \"lsequence\\t$contiginfo{'lsequence'}\\n\".\n                \"quality\\t$contiginfo{'quality'}\\n\".\n                \"asmbl_id\\t$contiginfo{'asmbl_id'}\\n\".\n                \"seq_id\\t$contiginfo{'seq_id'}\\n\".\n                \"com_name\\t$contiginfo{'com_name'}\\n\".\n                \"type\\t$contiginfo{'type'}\\n\".\n                \"method\\t$contiginfo{'method'}\\n\".\n                \"ed_status\\t$contiginfo{'ed_status'}\\n\".\n                \"redundancy\\t$contiginfo{'redundancy'}\\n\".\n                \"perc_N\\t$contiginfo{'perc_N'}\\n\".\n                \"seq#\\t$contiginfo{'seqnum'}\\n\".\n                \"full_cds\\t$contiginfo{'full_cds'}\\n\".\n                \"cds_start\\t$contiginfo{'cds_start'}\\n\".\n                \"cds_end\\t$contiginfo{'cds_end'}\\n\".\n                \"ed_pn\\t$contiginfo{'ed_pn'}\\n\".\n                \"ed_date\\t$contiginfo{'ed_date'}\\n\".\n                \"comment\\t$contiginfo{'comment'}\\n\".\n                \"frameshift\\t$contiginfo{'frameshift'}\\n\".\n                \"\\n\"\n            );\n                        \n            # Get read information\n            my ($seq_name, $db) = $self->_split_seq_name_and_db($readid);\n            my $clipcoord = (grep\n                { $_->primary_tag eq \"_quality_clipping:$readid\"}\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my $alncoord  = (grep\n                { $_->primary_tag eq \"_aligned_coord:$readid\"}\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my $readanno = (grep\n                { $_->primary_tag eq \"_main_read_feature:$readid\" }\n                $singletobj->get_seq_coord($singletobj->seqref)->get_SeqFeatures\n            )[0];\n            my %readinfo;\n            $readinfo{'seq_name'}  = $seq_name;\n            $readinfo{'asm_lend'}  = $alncoord->location->start;\n            $readinfo{'asm_rend'}  = $alncoord->location->end;\n            $readinfo{'seq_lend'}  = $clipcoord->location->start;\n            $readinfo{'seq_rend'}  = $clipcoord->location->end;\n            $readinfo{'best'}      = ($readanno->get_tag_values('best'))[0];\n            $readinfo{'comment'}   = ($readanno->get_tag_values('comment'))[0];\n            $readinfo{'db'}        = $db;         \n            $readinfo{'offset'}    = 0;\n            # ambiguities in read sequence are uppercase\n            $readinfo{'lsequence'} = uc($contiginfo{'lsequence'});\n            \n            # Check that no tag value is undef\n            $readinfo{'best'}    = '' unless defined $readinfo{'best'};\n            $readinfo{'comment'} = '' unless defined $readinfo{'comment'};\n\n            # Print read information\n            $self->_print(\n                \"seq_name\\t$readinfo{'seq_name'}\\n\".\n                \"asm_lend\\t$readinfo{'asm_lend'}\\n\".\n                \"asm_rend\\t$readinfo{'asm_rend'}\\n\".\n                \"seq_lend\\t$readinfo{'seq_lend'}\\n\".\n                \"seq_rend\\t$readinfo{'seq_rend'}\\n\".\n                \"best\\t$readinfo{'best'}\\n\".\n                \"comment\\t$readinfo{'comment'}\\n\".\n                \"db\\t$readinfo{'db'}\\n\".\n                \"offset\\t$readinfo{'offset'}\\n\".\n                \"lsequence\\t$readinfo{'lsequence'}\\n\"\n            );\n            if ($i+1 < $numobj) {\n                $self->_print(\"|\\n\");\n            }\n        } else {\n            # This is a contig\n            my $contigid = $objid;\n            my $contigobj = $scaffoldobj->get_contig_by_id($contigid);\n\n            # Skip contigs of 1 sequence (singlets) if needed\n            next if ($contigobj->num_sequences == 1) && (!$singlets);\n            \n            # Get contig information\n            my $contanno = (grep\n                { $_->primary_tag eq \"_main_contig_feature:$contigid\" }\n                $contigobj->get_features_collection->get_all_features\n            )[0];\n            my %contiginfo;\n            $contiginfo{'sequence'}   = $self->_ungap(\n                $contigobj->get_consensus_sequence->seq);\n            $contiginfo{'lsequence'}  = $contigobj->get_consensus_sequence->seq;\n            $contiginfo{'quality'}    = $self->_qual_dec2hex(\n                join ' ', @{$contigobj->get_consensus_quality->qual});\n            $contiginfo{'asmbl_id'}   = $contigid;\n            $contiginfo{'seq_id'}     = ($contanno->get_tag_values('seq_id'))[0];\n            $contiginfo{'com_name'}   = ($contanno->get_tag_values('com_name'))[0];\n            $contiginfo{'type'}       = ($contanno->get_tag_values('type'))[0];\n            $contiginfo{'method'}     = ($contanno->get_tag_values('method'))[0];\n            $contiginfo{'ed_status'}  = ($contanno->get_tag_values('ed_status'))[0];\n            $contiginfo{'redundancy'} = sprintf(\n                $decimal_format, $self->_redundancy($contigobj));\n            $contiginfo{'perc_N'}     = sprintf(\n                $decimal_format, $self->_perc_N($contiginfo{'sequence'}));\n            $contiginfo{'seqnum'}     = $contigobj->num_sequences;\n            $contiginfo{'full_cds'}   = ($contanno->get_tag_values('full_cds'))[0];\n            $contiginfo{'cds_start'}  = ($contanno->get_tag_values('cds_start'))[0];\n            $contiginfo{'cds_end'}    = ($contanno->get_tag_values('cds_end'))[0];\n            $contiginfo{'ed_pn'}      = ($contanno->get_tag_values('ed_pn'))[0];\n            $contiginfo{'ed_date'}    = $self->_date_time;\n            $contiginfo{'comment'}    = ($contanno->get_tag_values('comment'))[0];\n            $contiginfo{'frameshift'} = ($contanno->get_tag_values('frameshift'))[0];\n            \n            # Check that no tag value is undef\n            $contiginfo{'seq_id'}     = '' unless defined $contiginfo{'seq_id'};\n            $contiginfo{'com_name'}   = '' unless defined $contiginfo{'com_name'};\n            $contiginfo{'type'}       = '' unless defined $contiginfo{'type'};\n            $contiginfo{'method'}     = '' unless defined $contiginfo{'method'};\n            $contiginfo{'ed_status'}  = '' unless defined $contiginfo{'ed_status'};\n            $contiginfo{'full_cds'}   = '' unless defined $contiginfo{'full_cds'};\n            $contiginfo{'cds_start'}  = '' unless defined $contiginfo{'cds_start'};\n            $contiginfo{'cds_end'}    = '' unless defined $contiginfo{'cds_end'};\n            $contiginfo{'ed_pn'}      = '' unless defined $contiginfo{'ed_pn'};\n            $contiginfo{'comment'}    = '' unless defined $contiginfo{'comment'};\n            $contiginfo{'frameshift'} = '' unless defined $contiginfo{'frameshift'};\n                       \n            # Print contig information\n            $self->_print(\n                \"sequence\\t$contiginfo{'sequence'}\\n\".\n                \"lsequence\\t$contiginfo{'lsequence'}\\n\".\n                \"quality\\t$contiginfo{'quality'}\\n\".\n                \"asmbl_id\\t$contiginfo{'asmbl_id'}\\n\".\n                \"seq_id\\t$contiginfo{'seq_id'}\\n\".\n                \"com_name\\t$contiginfo{'com_name'}\\n\".\n                \"type\\t$contiginfo{'type'}\\n\".\n                \"method\\t$contiginfo{'method'}\\n\".\n                \"ed_status\\t$contiginfo{'ed_status'}\\n\".\n                \"redundancy\\t$contiginfo{'redundancy'}\\n\".\n                \"perc_N\\t$contiginfo{'perc_N'}\\n\".\n                \"seq#\\t$contiginfo{'seqnum'}\\n\".\n                \"full_cds\\t$contiginfo{'full_cds'}\\n\".\n                \"cds_start\\t$contiginfo{'cds_start'}\\n\".\n                \"cds_end\\t$contiginfo{'cds_end'}\\n\".\n                \"ed_pn\\t$contiginfo{'ed_pn'}\\n\".\n                \"ed_date\\t$contiginfo{'ed_date'}\\n\".\n                \"comment\\t$contiginfo{'comment'}\\n\".\n                \"frameshift\\t$contiginfo{'frameshift'}\\n\".\n                \"\\n\"\n            );\n            my $seqno = 0;\n            for my $readobj ( $contigobj->each_seq() ) {\n                $seqno++;\n                \n                # Get read information\n                my ($seq_name, $db) = $self->_split_seq_name_and_db($readobj->id);\n                my ($asm_lend, $asm_rend, $seq_lend, $seq_rend, $offset)\n                    = $self->_coord($readobj, $contigobj);\n                my $readanno = ( grep \n                    { $_->primary_tag eq '_main_read_feature:'.$readobj->primary_id }\n                    $contigobj->get_seq_coord($readobj)->get_SeqFeatures\n                )[0];\n                my %readinfo;                \n                $readinfo{'seq_name'}  = $seq_name;\n                $readinfo{'asm_lend'}  = $asm_lend;\n                $readinfo{'asm_rend'}  = $asm_rend;\n                $readinfo{'seq_lend'}  = $seq_lend;\n                $readinfo{'seq_rend'}  = $seq_rend;                \n                $readinfo{'best'}      = ($readanno->get_tag_values('best'))[0];\n                $readinfo{'comment'}   = ($readanno->get_tag_values('comment'))[0];\n                $readinfo{'db'}        = $db;\n                $readinfo{'offset'}    = $offset;   \n                $readinfo{'lsequence'} = $readobj->seq(); \n                         \n                # Check that no tag value is undef\n                $readinfo{'best'}    = '' unless defined $readinfo{'best'};\n                $readinfo{'comment'} = '' unless defined $readinfo{'comment'};\n    \n                # Print read information\n                $self->_print(\n                    \"seq_name\\t$readinfo{'seq_name'}\\n\".\n                    \"asm_lend\\t$readinfo{'asm_lend'}\\n\".\n                    \"asm_rend\\t$readinfo{'asm_rend'}\\n\".\n                    \"seq_lend\\t$readinfo{'seq_lend'}\\n\".\n                    \"seq_rend\\t$readinfo{'seq_rend'}\\n\".\n                    \"best\\t$readinfo{'best'}\\n\".\n                    \"comment\\t$readinfo{'comment'}\\n\".\n                    \"db\\t$readinfo{'db'}\\n\".\n                    \"offset\\t$readinfo{'offset'}\\n\".\n                    \"lsequence\\t$readinfo{'lsequence'}\\n\"\n                );\n                if ($seqno < $contiginfo{'seqnum'}) {\n                    $self->_print(\"\\n\");\n                } elsif (($seqno == $contiginfo{'seqnum'}) && ($i+1 < $numobj)) {\n                    $self->_print(\"|\\n\");\n                }\n            }\n        }\n    }\n    return 1;\n}\n\n=head2 _perc_N\n\n    Title   : _perc_N\n    Usage   : my $perc_N = $ass_io->_perc_N($sequence_string)\n    Function: Calculate the percent of ambiguities in a sequence.\n              M R W S Y K X N are regarded as ambiguites in an aligned read\n              sequence by TIGR Assembler. In the case of a gapped contig\n              consensus sequence, all lowercase symbols are ambiguities, i.e.:\n              a c g t u m r w s y k x n.\n    Returns : decimal number\n    Args    : string\n\n\nsub _perc_N {\n    my ($self, $seq_string) = @_;\n    $self->throw(\"Cannot accept an empty sequence\") if length($seq_string) == 0;\n    my $perc_N = 0;\n    for my $base ( split //, $seq_string ) {\n        # individual base matches an ambiguity?\n        if (( $base =~ m/[x|n|m|r|w|s|y|k]/i ) || ( $base =~ m/[a|c|g|t|u]/ ) ) {\n            $perc_N++;\n        }\n    }\n    $perc_N = $perc_N * 100 / length $seq_string;\n    return $perc_N;\n}\n\n=head2 _redundancy\n\n    Title   : _redundancy\n    Usage   : my $ref = $ass_io->_redundancy($contigobj)\n    Function: Calculate the fold coverage (redundancy) of a contig consensus\n              (average number of read base pairs covering the consensus)\n    Returns : decimal number\n    Args    : Bio::Assembly::Contig","label":"_redundancy($self,$contigobj)"},"detail":"($self,$contigobj)","name":"_redundancy","range":{"end":{"line":1033,"character":9999},"start":{"character":0,"line":984}}},{"kind":12,"children":[{"containerName":"_ungap","definition":"my","name":"$self","localvar":"my","kind":13,"line":1046},{"containerName":"_ungap","name":"$seq_string","line":1046,"kind":13},{"kind":13,"line":1047,"name":"$seq_string","containerName":"_ungap"},{"name":"$seq_string","containerName":"_ungap","kind":13,"line":1048}],"line":1045,"definition":"sub","containerName":"main::","signature":{"documentation":"__END__\n# $Id: tigr.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO::tigr\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO::tigr - Driver to read and write assembly files in the TIGR\nAssembler v2 default format.\n\n=head1 SYNOPSIS\n\n    # Building an input stream\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $asmio = Bio::Assembly::IO->new( -file   => 'SGC0-424.tasm',\n                                        -format => 'tigr' );\n    my $scaffold = $asmio->next_assembly;\n\n    # Do some things on contigs...\n\n    # Assembly writing methods\n    my $outasm = Bio::Assembly::IO->new( -file   => \">SGC0-modified.tasm\",\n                                         -format => 'tigr' );\n    $outasm->write_assembly( -scaffold => $assembly,\n                             -singlets => 1 );\n\n=head1 DESCRIPTION\n\nThis package loads and writes assembly information in/from files in the default\nTIGR Assembler v2 format. The files are lassie-formatted and often have the\n.tasm extension. This module was written to be used as a driver module for\nBio::Assembly::IO input/output.\n\n=head2 Implementation\n\nAssemblies are loaded into Bio::Assembly::Scaffold objects composed of\nBio::Assembly::Contig and Bio::Assembly::Singlet objects. Since aligned reads\nand contig gapped consensus can be obtained in the tasm files, only\naligned/gapped sequences are added to the different BioPerl objects.\n\nAdditional assembly information is stored as features. Contig objects have\nSeqFeature information associated with the primary_tag:\n\n    _main_contig_feature:$contig_id -> misc contig information\n    _quality_clipping:$read_id      -> quality clipping position\n\nRead objects have sub_seqFeature information associated with the\nprimary_tag:\n\n    _main_read_feature:$read_id     -> misc read information\n\nSinglets are considered by TIGR Assembler as contigs of one sequence and are\nrepresented here with features having these primary_tag: \n\n    _main_contig_feature:$contig_id\n    _quality_clipping:$read_primary_id\n    _main_read_feature:$read_primary_id\n    _aligned_coord:$read_primary_id\n\n=head1 THE TIGR TASM LASSIEFORMAT\n\n=head2 Description\n\nIn the TIGR tasm lassie format, contigs are separated by a line containing a single\npipe character \"|\", whereas the reads in a contig are separated by a blank line.\nSinglets can be present in the file and are represented as a contig\ncomposed of a single sequence.\n\nOther than the two above-mentioned separators, each line has an attribute name,\nfollowed a tab and then an attribute value.\n\nThe tasm format is used by more TIGR applications than just TIGR Assembler.\nSome of the attributes are not used by TIGR Assembler or have constant values.\nThey are indicated by an asterisk *\n\nContigs have the following attributes:\n\n    asmbl_id   -> contig ID\n    sequence   -> contig ungapped consensus sequence (ambiguities are lowercase)\n    lsequence  -> gapped consensus sequence (lowercase ambiguities)\n    quality    -> gapped consensus quality score (in hexadecimal)\n    seq_id     -> *\n    com_name   -> *\n    type       -> *\n    method     -> always 'asmg' *\n    ed_status  -> *\n    redundancy -> fold coverage of the contig consensus\n    perc_N     -> percent of ambiguities in the contig consensus\n    seq#       -> number of sequences in the contig\n    full_cds   -> *\n    cds_start  -> start of coding sequence *\n    cds_end    -> end of coding sequence *\n    ed_pn      -> name of editor (always 'GRA') *\n    ed_date    -> date and time of edition\n    comment    -> some comments *\n    frameshift -> *\n\nEach read has the following attributes:\n\n    seq_name  -> read name\n    asm_lend  -> position of first base on contig ungapped consensus sequence\n    asm_rend  -> position of last base on contig ungapped consensus sequence\n    seq_lend  -> start of quality-trimmed sequence (aligned read coordinates)\n    seq_rend  -> end of quality-trimmed sequence (aligned read coordinates)\n    best      -> always '0' *\n    comment   -> some comments *\n    db        -> database name associated with the sequence (e.g. >my_db|seq1234)\n    offset    -> offset of the sequence (gapped consensus coordinates)\n    lsequence -> aligned read sequence (ambiguities are uppercase)\n\nWhen asm_rend E<lt> asm_lend, the sequence was on the complementary DNA strand but\nits reverse complement is shown in the aligned sequence of the assembly file,\nnot the original read.\n\nAmbiguities are reflected in the contig consensus sequence as\nlowercase IUPAC characters: a c g t u m r w s y k x n . In the read\nsequences, however, ambiguities are uppercase: M R W S Y K X N\n\n=head2 Example\n\nExample of a contig containing three sequences:\n\n    sequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCGCAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    quality\t0x0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0505050505050505050E0505160505050505050505050505050505050505050505050505050505050303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0404040404040404041604040404040404040404040404040404040404040404040404040404040404040404040404040404040E0404040404040404040B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B\n    asmbl_id\t93\n    seq_id\t\n    com_name\t\n    type\t\n    method\tasmg\n    ed_status\t\n    redundancy\t1.11\n    perc_N\t0.20\n    seq#\t3\n    full_cds\t\n    cds_start\t\n    cds_end\t\n    ed_pn\tGRA\n    ed_date\t08/16/07 17:10:12\n    comment\t\n    frameshift\t\n\n    seq_name\tSDSU_RFPERU_010_C09.x01.phd.1\n    asm_lend\t1\n    asm_rend\t4423\n    seq_lend\t1\n    seq_rend\t442\n    best\t0\n    comment\t\n    db\t\n    offset\t0\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAGCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGG\n\n    seq_name\tSDSU_RFPERU_002_H12.x01.phd.1\n    asm_lend\t339\n    asm_rend\t940\n    seq_lend\t1\n    seq_rend\t602\n    best\t0\n    comment\t\n    db\t\n    offset\t338\n    lsequence\tCGAGATTCGCCACCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCCGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATA-GCGTGGCGC\n\n    seq_name\tSDSU_RFPERU_009_E07.x01.phd.1\n    asm_lend\t880\n    asm_rend\t1520\n    seq_lend\t641\n    seq_rend\t1\n    best\t0\n    comment\t\n    db\t\n    offset\t8803\n    lsequence\tCGCACGGTCTGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAAGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    |\n\n...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent dot angly at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::IO::tigr;\n\nuse strict;\nuse Bio::Seq::Quality;\nuse Bio::LocatableSeq;\nuse Bio::Assembly::IO;\nuse Bio::Assembly::Scaffold;\nuse Bio::Assembly::Contig;\nuse Bio::Assembly::Singlet;\n\nuse base qw(Bio::Assembly::IO);\n\nmy $progname = 'TIGR Assembler';\n\n=head2 next_assembly\n\n Title   : next_assembly\n Usage   : my $scaffold = $asmio->next_assembly()\n Function: return the next assembly in the tasm-formatted stream\n Returns : Bio::Assembly::Scaffold object\n Args    : none\n\n\nsub next_assembly {\n    my $self = shift; # object reference\n    \n    # Create a new scaffold to hold the contigs\n    my $scaffoldobj = Bio::Assembly::Scaffold->new(-source => $progname);\n    \n    # Contig and read related\n    my $contigobj;\n    my $iscontig = 1;\n    my %contiginfo;\n    my $isread = 0;\n    my %readinfo;\n    \n    # Loop over all assembly file lines\n    while ($_ = $self->_readline) {\n        chomp;\n        if ( /^\\|/ ) {  # a line with a single pipe |\n            # The end of a read from a contig, the start of a new contig\n            $iscontig = 1;\n            $isread   = 0;\n            # Store read info\n            if ($contiginfo{'seqnum'} > 1) {\n                # This is a read in a contig\n                my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n            } elsif ($contiginfo{'seqnum'} == 1) {\n                # This is a singlet\n                my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                    $scaffoldobj);\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n            # Clear read info\n            undef %readinfo;\n            # Clear contig info\n            undef $contigobj;\n            undef %contiginfo;\n        } elsif ( /^$/ ) {  # a blank line\n            if ($iscontig) {\n                # The end of a contig, the start of a read in that contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store contig info\n                $contigobj = $self->_store_contig( \\%contiginfo, $contigobj,\n                    $scaffoldobj ) if $contiginfo{'seqnum'} > 1;\n            } elsif ($isread) {\n                # The end of read in a contig, the start of a new one in\n                # the same contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store read info\n                if ($contiginfo{'seqnum'} > 1) {\n                    # This is a read in a contig\n                    my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n                } elsif ($contiginfo{'seqnum'} == 1) {\n                    # This is a singlet\n                    my $singletobj = $self->_store_singlet(\\%readinfo,\n                        \\%contiginfo, $scaffoldobj);\n                } else {\n                  # That should not happen\n                  $self->throw(\"Unhandled exception\");\n                }\n                # Clear read info\n                undef %readinfo;\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n        } else {\n            if ($iscontig) {\n                # Parse contig\n                if    (/^sequence\\t(.*)/)     {$contiginfo{'sequence'}   = $1; next}\n                elsif (/^lsequence\\t(.*)/)    {$contiginfo{'lsequence'}  = $1; next}\n                elsif (/^quality\\t(.*)/)      {$contiginfo{'quality'}    = $1; next}\n                elsif (/^asmbl_id\\t(.*)/)     {$contiginfo{'asmbl_id'}   = $1; next}\n                elsif (/^seq_id\\t(.*)/)       {$contiginfo{'seq_id'}     = $1; next}\n                elsif (/^com_name\\t(.*)/)     {$contiginfo{'com_name'}   = $1; next}\n                elsif (/^type\\t(.*)/)         {$contiginfo{'type'}       = $1; next}\n                elsif (/^method\\t(.*)/)       {$contiginfo{'method'}     = $1; next}\n                elsif (/^ed_status\\t(.*)/)    {$contiginfo{'ed_status'}  = $1; next}\n                elsif (/^redundancy\\t(.*)/)   {$contiginfo{'redundancy'} = $1; next}\n                elsif (/^perc_N\\t(.*)/)       {$contiginfo{'perc_N'}     = $1; next}\n                elsif (/^seq\\#\\t(.*)/)        {$contiginfo{'seqnum'}     = $1; next}\n                elsif (/^full_cds\\t(.*)/)     {$contiginfo{'full_cds'}   = $1; next}\n                elsif (/^cds_start\\t(.*)/)    {$contiginfo{'cds_start'}  = $1; next}\n                elsif (/^cds_end\\t(.*)/)      {$contiginfo{'cds_end'}    = $1; next}\n                elsif (/^ed_pn\\t(.*)/)        {$contiginfo{'ed_pn'}      = $1; next}\n                elsif (/^ed_date\\t(.*\\s.*)/)  {$contiginfo{'ed_date'}    = $1; next}\n                elsif (/^comment\\t(.*)/)      {$contiginfo{'comment'}    = $1; next}\n                elsif (/^frameshift\\t(.*)/)   {$contiginfo{'frameshift'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } elsif ($isread) {\n                # Parse read info\n                if    (/^seq_name\\t(.*)/)  {$readinfo{'seq_name'}  = $1; next}\n                elsif (/^asm_lend\\t(.*)/)  {$readinfo{'asm_lend'}  = $1; next}\n                elsif (/^asm_rend\\t(.*)/)  {$readinfo{'asm_rend'}  = $1; next}\n                elsif (/^seq_lend\\t(.*)/)  {$readinfo{'seq_lend'}  = $1; next}\n                elsif (/^seq_rend\\t(.*)/)  {$readinfo{'seq_rend'}  = $1; next}\n                elsif (/^best\\t(.*)/)      {$readinfo{'best'}      = $1; next}\n                elsif (/^comment\\t(.*)/)   {$readinfo{'comment'}   = $1; next}\n                elsif (/^db\\t(.*)/)        {$readinfo{'db'}        = $1; next}\n                elsif (/^offset\\t(.*)/)    {$readinfo{'offset'}    = $1; next}\n                elsif (/^lsequence\\t(.*)/) {$readinfo{'lsequence'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } else {\n                # That shouldn't happen\n                $self->throw(\"Unhandled exception\");                \n            }\n        }\n    }\n    # Store read info for last read\n    if (defined $contiginfo{'seqnum'}) {\n        if ($contiginfo{'seqnum'} > 1) {\n            # This is a read in a contig\n            my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n        } elsif ($contiginfo{'seqnum'} == 1) {\n            # This is a singlet\n            my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                $scaffoldobj);\n        } else {\n            # That should not happen\n            $self->throw(\"Unhandled exception\");\n        }\n    }\n    # Clear read info for last read\n    undef %readinfo;\n    # Clear contig info for last contig\n    undef $contigobj;\n    undef %contiginfo;\n    \n    $scaffoldobj->update_seq_list();\n    \n    return $scaffoldobj;\n}\n\n=head2 _qual_hex2dec\n\n    Title   : _qual_hex2dec\n    Usage   : my dec_quality = $self->_qual_hex2dec($hex_quality);\n    Function: convert an hexadecimal quality score into a decimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_hex2dec {\n    my ($self, $qual) = @_;\n    $qual =~ s/^0x(.*)$/$1/;\n    $qual =~ s/(..)/hex($1).' '/eg;\n    return $qual;\n}\n\n=head2 _qual_dec2hex\n\n    Title   : _qual_dec2hex\n    Usage   : my hex_quality = $self->_qual_dec2hex($dec_quality);\n    Function: convert a decimal quality score into an hexadecimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_dec2hex {\n    my ($self, $qual) = @_;\n    $qual =~ s/(\\d+)\\s*/sprintf('%02X', $1)/eg;\n    $qual = '0x'.$qual;\n    return $qual;\n}\n\n=head2 _store_contig\n\n    Title   : _store_contig\n    Usage   : my $contigobj; $contigobj = $self->_store_contig(\n              \\%contiginfo, $contigobj, $scaffoldobj);\n    Function: store information of a contig belonging to a scaffold in the\n              appropriate object\n    Returns : Bio::Assembly::Contig object\n    Args    : hash, Bio::Assembly::Contig, Bio::Assembly::Scaffold\n\n\nsub _store_contig {\n    my ($self, $contiginfo, $contigobj, $scaffoldobj) = @_;\n\n    # Create a contig and attach it to scaffold\n    $contigobj = Bio::Assembly::Contig->new(\n        -id     => $$contiginfo{'asmbl_id'},\n        -source => $progname,\n        -strand => 1\n    );\n    $scaffoldobj->add_contig($contigobj);\n\n    # Create a gapped consensus sequence and attach it to contig\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $consensus = Bio::LocatableSeq->new(\n        -id    => $$contiginfo{'asmbl_id'},\n        -seq   => $$contiginfo{'lsequence'},\n        -start => 1,\n    );\n    $contigobj->set_consensus_sequence($consensus);\n\n    # Create an gapped consensus quality score and attach it to contig\n    $$contiginfo{'quality'} = $self->_qual_hex2dec($$contiginfo{'quality'});\n    my $qual = Bio::Seq::Quality->new(\n        -id   => $$contiginfo{'asmbl_id'},\n        -qual => $$contiginfo{'quality'}\n    );\n    $contigobj->set_consensus_quality($qual);\n\n    # Add other misc contig information as features of the contig\n    my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$$contiginfo{'asmbl_id'}\",\n        -start       => 1,\n        -end         => $contigobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n    );\n    $contigobj->add_features([ $contigtags ], 1);\n\n    return $contigobj;\n}\n\n=head2 _store_read\n\n    Title   : _store_read\n    Usage   : my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n    Function: store information of a read belonging to a contig in the appropriate object\n    Returns : Bio::LocatableSeq\n    Args    : hash, Bio::Assembly::Contig\n\n\nsub _store_read {\n   my ($self, $readinfo, $contigobj) = @_;\n\n   # Create an aligned read object\n   #$$readinfo{'llength'} = length($$readinfo{'lsequence'});\n   $$readinfo{'strand'}  = ($$readinfo{'seq_rend'} > $$readinfo{'seq_lend'} ? 1 : -1);\n   my $readobj = Bio::LocatableSeq->new(\n       # the ids of sequence objects are supposed to include the db name in it, i.e. \"big_db|seq1234\"\n       # that's how sequence ids coming from the fasta parser are at least\n       -display_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -primary_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -seq        => $$readinfo{'lsequence'},      \n       -start      => 1,\n       -strand     => $$readinfo{'strand'},\n       -alphabet   => 'dna'\n   );\n\n   # Add read location and sequence to contig (in 'gapped consensus' coordinates)\n   $$readinfo{'aln_start'} = $$readinfo{'offset'} + 1; # seq offset is in gapped coordinates\n   $$readinfo{'aln_end'} = $$readinfo{'aln_start'} + length($$readinfo{'lsequence'}) - 1; # lsequence is aligned seq\n   my $alncoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => $readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigobj->id() }\n   );\n   $contigobj->set_seq_coord($alncoord, $readobj);\n\n   # Add quality clipping read information in contig features\n   # (from 'aligned read' to 'gapped consensus' coordinates)\n   $$readinfo{'clip_start'} = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_lend'});\n   $$readinfo{'clip_end'}   = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_rend'});\n   my $clipcoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_quality_clipping:'.$readobj->id,\n       -start       => $$readinfo{'clip_start'},\n       -end         => $$readinfo{'clip_end'},\n       -strand      => $$readinfo{'strand'}\n   );\n   $clipcoord->attach_seq($readobj);\n   $contigobj->add_features([ $clipcoord ], 0);\n   \n   # Add other misc read information as subsequence feature\n   my $readtags = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_main_read_feature:'.$readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'best'    => $$readinfo{'best'},\n                         'comment' => $$readinfo{'comment'} }\n   );\n   $alncoord->add_sub_SeqFeature($readtags);\n\n   return $readobj;\n}\n\n=head2 _store_singlet\n\n    Title   : _store_singlet\n    Usage   : my $singletobj = $self->_store_read(\\%readinfo, \\%contiginfo,\n                  $scaffoldobj);\n    Function: store information of a singlet belonging to a scaffold in the appropriate object\n    Returns : Bio::Assembly::Singlet\n    Args    : hash, hash, Bio::Assembly::Scaffold\n\n\nsub _store_singlet {\n    my ($self, $readinfo, $contiginfo, $scaffoldobj) = @_;\n    # Singlets in TIGR_Assembler are represented as a contig of one sequence\n    # We try to simulate this duality by playing around with the Singlet object\n    \n    my $contigid = $$contiginfo{'asmbl_id'};\n    my $readid   = $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'});\n    \n    # Create a sequence object\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $seqobj = Bio::Seq::Quality->new(\n       -primary_id => $contigid, # unique id in assembly (contig name)\n       -display_id => $readid,\n       -seq        => $$contiginfo{'lsequence'}, # do not use $$readinfo as ambiguities are uppercase\n       -start      => 1,\n       -strand     => $$readinfo{'strand'},\n       -alphabet   => 'dna',\n       -qual => $self->_qual_hex2dec($$contiginfo{'quality'})    \n   );\n\n   # Create singlet from sequence and add it to scaffold\n   my $singletobj = Bio::Assembly::Singlet->new( -seqref => $seqobj );\n   $scaffoldobj->add_singlet($singletobj);\n\n   # Add other misc contig information as features of the singlet\n   my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$contigid\",\n        -start       => 1,\n        -end         => $singletobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n   );\n   $singletobj->add_features([ $contigtags ], 1);\n\n   # Add read location and sequence to singlet features (in 'gapped consensus' coordinates)\n   $$readinfo{'aln_start'} = $$readinfo{'offset'} + 1; # seq offset is in gapped coordinates\n   $$readinfo{'aln_end'} = $$readinfo{'aln_start'} + length($$readinfo{'lsequence'}) - 1; # lsequence is aligned seq\n\n   my $alncoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_aligned_coord:$readid\",\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigid }\n   );\n   $alncoord->attach_seq($singletobj->seqref);\n   $singletobj->add_features([ $alncoord ], 0);\n\n   # Add quality clipping read information in singlet features\n   # (from 'aligned read' to 'gapped consensus' coordinates)\n   $$readinfo{'clip_start'} = $$readinfo{'seq_lend'};\n   $$readinfo{'clip_end'}   = $$readinfo{'seq_rend'};\n   my $clipcoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_quality_clipping:$readid\",\n       -start       => $$readinfo{'clip_start'},\n       -end         => $$readinfo{'clip_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigid }\n   );\n   $clipcoord->attach_seq($singletobj->seqref);\n   $singletobj->add_features([ $clipcoord ], 0);\n   \n   # Add other misc read information as subsequence feature\n   my $readtags = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_main_read_feature:$readid\",\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'best'    => $$readinfo{'best'},\n                         'comment' => $$readinfo{'comment'} }\n   );\n   $alncoord->add_sub_SeqFeature($readtags);\n      \n   return $singletobj;\n}\n\n=head2 write_assembly\n\n    Title   : write_assembly\n    Usage   : $ass_io->write_assembly($assembly)\n    Function: Write the assembly object in TIGR Assembler compatible tasm lassie  \n              format\n    Returns : 1 on success, 0 for error\n    Args    : A Bio::Assembly::Scaffold object\n\n\nsub write_assembly {\n    my ($self,@args) = @_;    \n    my ($scaffoldobj, $singlets) = $self->_rearrange([qw(SCAFFOLD SINGLETS)], @args);\n    \n    # Sanity check\n    if ( !$scaffoldobj || !$scaffoldobj->isa('Bio::Assembly::Scaffold') ) {\n        $self->warn(\"Must provide a Bio::Align::AlignI object when calling\n            write_assembly\");\n        next;\n    }\n\n    # Get list of objects - contigs and singlets\n    my @cont_ids = $scaffoldobj->get_contig_ids;\n    my @sing_ids = $scaffoldobj->get_singlet_ids;\n    my %did;\n    my $decimal_format = '%.2f';\n    for (my $i = 0; $i < scalar @sing_ids ; $i++) {\n      # singlet display id (string)\n      my $display_id = $sing_ids[$i];\n      # singlet primary id (unique, numerical)\n      my $primary_id = $scaffoldobj->get_singlet_by_id($display_id)->seqref->primary_id;\n      $sing_ids[$i] = $primary_id;\n      $did{$primary_id} = $display_id;\n    }\n    my @ids = (@cont_ids, @sing_ids);\n    @ids = sort { $a <=> $b } @ids; # list with contig ids and singlet primary id\n    my $numobj = scalar @ids;\n\n    # Output all contigs and singlets (sorted by increasing id number)\n    for (my $i = 0 ; $i < $numobj ; $i++) {\n        \n        my $objid = $ids[$i];\n        \n        if (defined $did{$objid}) { \n            # This is a singlet\n            next unless ($singlets);\n\n            my $contigid = $objid;\n            my $readid   = $did{$objid};            \n            my $singletobj = $scaffoldobj->get_singlet_by_id($readid);\n            \n            # Get contig information\n            my $contanno = (grep\n                { $_->primary_tag eq \"_main_contig_feature:$contigid\" }\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my %contiginfo;\n            $contiginfo{'sequence'}   = $singletobj->seqref->seq;\n            $contiginfo{'lsequence'}  = $contiginfo{'sequence'};\n            $contiginfo{'quality'}    = $self->_qual_dec2hex(\n                join ' ', @{$singletobj->seqref->qual});\n            $contiginfo{'asmbl_id'}   = $contigid;\n            $contiginfo{'seq_id'}     = ($contanno->get_tag_values('seq_id'))[0];   \n            $contiginfo{'com_name'}   = ($contanno->get_tag_values('com_name'))[0];\n            $contiginfo{'type'}       = ($contanno->get_tag_values('type'))[0];\n            $contiginfo{'method'}     = ($contanno->get_tag_values('method'))[0];\n            $contiginfo{'ed_status'}  = ($contanno->get_tag_values('ed_status'))[0];\n            $contiginfo{'redundancy'} = sprintf($decimal_format, 1);\n            $contiginfo{'perc_N'}     = sprintf(\n                $decimal_format, $self->_perc_N($contiginfo{'sequence'}));\n            $contiginfo{'seqnum'}     = 1;\n            $contiginfo{'full_cds'}   = ($contanno->get_tag_values('full_cds'))[0];\n            $contiginfo{'cds_start'}  = ($contanno->get_tag_values('cds_start'))[0];\n            $contiginfo{'cds_end'}    = ($contanno->get_tag_values('cds_end'))[0];\n            $contiginfo{'ed_pn'}      = ($contanno->get_tag_values('ed_pn'))[0];\n            $contiginfo{'ed_date'}    = $self->_date_time;\n            $contiginfo{'comment'}    = ($contanno->get_tag_values('comment'))[0];\n            $contiginfo{'frameshift'} = ($contanno->get_tag_values('frameshift'))[0];\n\n            # Check that no tag value is undef\n            $contiginfo{'seq_id'}     = '' unless defined $contiginfo{'seq_id'};\n            $contiginfo{'com_name'}   = '' unless defined $contiginfo{'com_name'};\n            $contiginfo{'type'}       = '' unless defined $contiginfo{'type'};\n            $contiginfo{'method'}     = '' unless defined $contiginfo{'method'};\n            $contiginfo{'ed_status'}  = '' unless defined $contiginfo{'ed_status'};\n            $contiginfo{'full_cds'}   = '' unless defined $contiginfo{'full_cds'};\n            $contiginfo{'cds_start'}  = '' unless defined $contiginfo{'cds_start'};\n            $contiginfo{'cds_end'}    = '' unless defined $contiginfo{'cds_end'};\n            $contiginfo{'ed_pn'}      = '' unless defined $contiginfo{'ed_pn'};\n            $contiginfo{'comment'}    = '' unless defined $contiginfo{'comment'};\n            $contiginfo{'frameshift'} = '' unless defined $contiginfo{'frameshift'};\n            \n            # Print contig information\n            $self->_print(\n                \"sequence\\t$contiginfo{'sequence'}\\n\".\n                \"lsequence\\t$contiginfo{'lsequence'}\\n\".\n                \"quality\\t$contiginfo{'quality'}\\n\".\n                \"asmbl_id\\t$contiginfo{'asmbl_id'}\\n\".\n                \"seq_id\\t$contiginfo{'seq_id'}\\n\".\n                \"com_name\\t$contiginfo{'com_name'}\\n\".\n                \"type\\t$contiginfo{'type'}\\n\".\n                \"method\\t$contiginfo{'method'}\\n\".\n                \"ed_status\\t$contiginfo{'ed_status'}\\n\".\n                \"redundancy\\t$contiginfo{'redundancy'}\\n\".\n                \"perc_N\\t$contiginfo{'perc_N'}\\n\".\n                \"seq#\\t$contiginfo{'seqnum'}\\n\".\n                \"full_cds\\t$contiginfo{'full_cds'}\\n\".\n                \"cds_start\\t$contiginfo{'cds_start'}\\n\".\n                \"cds_end\\t$contiginfo{'cds_end'}\\n\".\n                \"ed_pn\\t$contiginfo{'ed_pn'}\\n\".\n                \"ed_date\\t$contiginfo{'ed_date'}\\n\".\n                \"comment\\t$contiginfo{'comment'}\\n\".\n                \"frameshift\\t$contiginfo{'frameshift'}\\n\".\n                \"\\n\"\n            );\n                        \n            # Get read information\n            my ($seq_name, $db) = $self->_split_seq_name_and_db($readid);\n            my $clipcoord = (grep\n                { $_->primary_tag eq \"_quality_clipping:$readid\"}\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my $alncoord  = (grep\n                { $_->primary_tag eq \"_aligned_coord:$readid\"}\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my $readanno = (grep\n                { $_->primary_tag eq \"_main_read_feature:$readid\" }\n                $singletobj->get_seq_coord($singletobj->seqref)->get_SeqFeatures\n            )[0];\n            my %readinfo;\n            $readinfo{'seq_name'}  = $seq_name;\n            $readinfo{'asm_lend'}  = $alncoord->location->start;\n            $readinfo{'asm_rend'}  = $alncoord->location->end;\n            $readinfo{'seq_lend'}  = $clipcoord->location->start;\n            $readinfo{'seq_rend'}  = $clipcoord->location->end;\n            $readinfo{'best'}      = ($readanno->get_tag_values('best'))[0];\n            $readinfo{'comment'}   = ($readanno->get_tag_values('comment'))[0];\n            $readinfo{'db'}        = $db;         \n            $readinfo{'offset'}    = 0;\n            # ambiguities in read sequence are uppercase\n            $readinfo{'lsequence'} = uc($contiginfo{'lsequence'});\n            \n            # Check that no tag value is undef\n            $readinfo{'best'}    = '' unless defined $readinfo{'best'};\n            $readinfo{'comment'} = '' unless defined $readinfo{'comment'};\n\n            # Print read information\n            $self->_print(\n                \"seq_name\\t$readinfo{'seq_name'}\\n\".\n                \"asm_lend\\t$readinfo{'asm_lend'}\\n\".\n                \"asm_rend\\t$readinfo{'asm_rend'}\\n\".\n                \"seq_lend\\t$readinfo{'seq_lend'}\\n\".\n                \"seq_rend\\t$readinfo{'seq_rend'}\\n\".\n                \"best\\t$readinfo{'best'}\\n\".\n                \"comment\\t$readinfo{'comment'}\\n\".\n                \"db\\t$readinfo{'db'}\\n\".\n                \"offset\\t$readinfo{'offset'}\\n\".\n                \"lsequence\\t$readinfo{'lsequence'}\\n\"\n            );\n            if ($i+1 < $numobj) {\n                $self->_print(\"|\\n\");\n            }\n        } else {\n            # This is a contig\n            my $contigid = $objid;\n            my $contigobj = $scaffoldobj->get_contig_by_id($contigid);\n\n            # Skip contigs of 1 sequence (singlets) if needed\n            next if ($contigobj->num_sequences == 1) && (!$singlets);\n            \n            # Get contig information\n            my $contanno = (grep\n                { $_->primary_tag eq \"_main_contig_feature:$contigid\" }\n                $contigobj->get_features_collection->get_all_features\n            )[0];\n            my %contiginfo;\n            $contiginfo{'sequence'}   = $self->_ungap(\n                $contigobj->get_consensus_sequence->seq);\n            $contiginfo{'lsequence'}  = $contigobj->get_consensus_sequence->seq;\n            $contiginfo{'quality'}    = $self->_qual_dec2hex(\n                join ' ', @{$contigobj->get_consensus_quality->qual});\n            $contiginfo{'asmbl_id'}   = $contigid;\n            $contiginfo{'seq_id'}     = ($contanno->get_tag_values('seq_id'))[0];\n            $contiginfo{'com_name'}   = ($contanno->get_tag_values('com_name'))[0];\n            $contiginfo{'type'}       = ($contanno->get_tag_values('type'))[0];\n            $contiginfo{'method'}     = ($contanno->get_tag_values('method'))[0];\n            $contiginfo{'ed_status'}  = ($contanno->get_tag_values('ed_status'))[0];\n            $contiginfo{'redundancy'} = sprintf(\n                $decimal_format, $self->_redundancy($contigobj));\n            $contiginfo{'perc_N'}     = sprintf(\n                $decimal_format, $self->_perc_N($contiginfo{'sequence'}));\n            $contiginfo{'seqnum'}     = $contigobj->num_sequences;\n            $contiginfo{'full_cds'}   = ($contanno->get_tag_values('full_cds'))[0];\n            $contiginfo{'cds_start'}  = ($contanno->get_tag_values('cds_start'))[0];\n            $contiginfo{'cds_end'}    = ($contanno->get_tag_values('cds_end'))[0];\n            $contiginfo{'ed_pn'}      = ($contanno->get_tag_values('ed_pn'))[0];\n            $contiginfo{'ed_date'}    = $self->_date_time;\n            $contiginfo{'comment'}    = ($contanno->get_tag_values('comment'))[0];\n            $contiginfo{'frameshift'} = ($contanno->get_tag_values('frameshift'))[0];\n            \n            # Check that no tag value is undef\n            $contiginfo{'seq_id'}     = '' unless defined $contiginfo{'seq_id'};\n            $contiginfo{'com_name'}   = '' unless defined $contiginfo{'com_name'};\n            $contiginfo{'type'}       = '' unless defined $contiginfo{'type'};\n            $contiginfo{'method'}     = '' unless defined $contiginfo{'method'};\n            $contiginfo{'ed_status'}  = '' unless defined $contiginfo{'ed_status'};\n            $contiginfo{'full_cds'}   = '' unless defined $contiginfo{'full_cds'};\n            $contiginfo{'cds_start'}  = '' unless defined $contiginfo{'cds_start'};\n            $contiginfo{'cds_end'}    = '' unless defined $contiginfo{'cds_end'};\n            $contiginfo{'ed_pn'}      = '' unless defined $contiginfo{'ed_pn'};\n            $contiginfo{'comment'}    = '' unless defined $contiginfo{'comment'};\n            $contiginfo{'frameshift'} = '' unless defined $contiginfo{'frameshift'};\n                       \n            # Print contig information\n            $self->_print(\n                \"sequence\\t$contiginfo{'sequence'}\\n\".\n                \"lsequence\\t$contiginfo{'lsequence'}\\n\".\n                \"quality\\t$contiginfo{'quality'}\\n\".\n                \"asmbl_id\\t$contiginfo{'asmbl_id'}\\n\".\n                \"seq_id\\t$contiginfo{'seq_id'}\\n\".\n                \"com_name\\t$contiginfo{'com_name'}\\n\".\n                \"type\\t$contiginfo{'type'}\\n\".\n                \"method\\t$contiginfo{'method'}\\n\".\n                \"ed_status\\t$contiginfo{'ed_status'}\\n\".\n                \"redundancy\\t$contiginfo{'redundancy'}\\n\".\n                \"perc_N\\t$contiginfo{'perc_N'}\\n\".\n                \"seq#\\t$contiginfo{'seqnum'}\\n\".\n                \"full_cds\\t$contiginfo{'full_cds'}\\n\".\n                \"cds_start\\t$contiginfo{'cds_start'}\\n\".\n                \"cds_end\\t$contiginfo{'cds_end'}\\n\".\n                \"ed_pn\\t$contiginfo{'ed_pn'}\\n\".\n                \"ed_date\\t$contiginfo{'ed_date'}\\n\".\n                \"comment\\t$contiginfo{'comment'}\\n\".\n                \"frameshift\\t$contiginfo{'frameshift'}\\n\".\n                \"\\n\"\n            );\n            my $seqno = 0;\n            for my $readobj ( $contigobj->each_seq() ) {\n                $seqno++;\n                \n                # Get read information\n                my ($seq_name, $db) = $self->_split_seq_name_and_db($readobj->id);\n                my ($asm_lend, $asm_rend, $seq_lend, $seq_rend, $offset)\n                    = $self->_coord($readobj, $contigobj);\n                my $readanno = ( grep \n                    { $_->primary_tag eq '_main_read_feature:'.$readobj->primary_id }\n                    $contigobj->get_seq_coord($readobj)->get_SeqFeatures\n                )[0];\n                my %readinfo;                \n                $readinfo{'seq_name'}  = $seq_name;\n                $readinfo{'asm_lend'}  = $asm_lend;\n                $readinfo{'asm_rend'}  = $asm_rend;\n                $readinfo{'seq_lend'}  = $seq_lend;\n                $readinfo{'seq_rend'}  = $seq_rend;                \n                $readinfo{'best'}      = ($readanno->get_tag_values('best'))[0];\n                $readinfo{'comment'}   = ($readanno->get_tag_values('comment'))[0];\n                $readinfo{'db'}        = $db;\n                $readinfo{'offset'}    = $offset;   \n                $readinfo{'lsequence'} = $readobj->seq(); \n                         \n                # Check that no tag value is undef\n                $readinfo{'best'}    = '' unless defined $readinfo{'best'};\n                $readinfo{'comment'} = '' unless defined $readinfo{'comment'};\n    \n                # Print read information\n                $self->_print(\n                    \"seq_name\\t$readinfo{'seq_name'}\\n\".\n                    \"asm_lend\\t$readinfo{'asm_lend'}\\n\".\n                    \"asm_rend\\t$readinfo{'asm_rend'}\\n\".\n                    \"seq_lend\\t$readinfo{'seq_lend'}\\n\".\n                    \"seq_rend\\t$readinfo{'seq_rend'}\\n\".\n                    \"best\\t$readinfo{'best'}\\n\".\n                    \"comment\\t$readinfo{'comment'}\\n\".\n                    \"db\\t$readinfo{'db'}\\n\".\n                    \"offset\\t$readinfo{'offset'}\\n\".\n                    \"lsequence\\t$readinfo{'lsequence'}\\n\"\n                );\n                if ($seqno < $contiginfo{'seqnum'}) {\n                    $self->_print(\"\\n\");\n                } elsif (($seqno == $contiginfo{'seqnum'}) && ($i+1 < $numobj)) {\n                    $self->_print(\"|\\n\");\n                }\n            }\n        }\n    }\n    return 1;\n}\n\n=head2 _perc_N\n\n    Title   : _perc_N\n    Usage   : my $perc_N = $ass_io->_perc_N($sequence_string)\n    Function: Calculate the percent of ambiguities in a sequence.\n              M R W S Y K X N are regarded as ambiguites in an aligned read\n              sequence by TIGR Assembler. In the case of a gapped contig\n              consensus sequence, all lowercase symbols are ambiguities, i.e.:\n              a c g t u m r w s y k x n.\n    Returns : decimal number\n    Args    : string\n\n\nsub _perc_N {\n    my ($self, $seq_string) = @_;\n    $self->throw(\"Cannot accept an empty sequence\") if length($seq_string) == 0;\n    my $perc_N = 0;\n    for my $base ( split //, $seq_string ) {\n        # individual base matches an ambiguity?\n        if (( $base =~ m/[x|n|m|r|w|s|y|k]/i ) || ( $base =~ m/[a|c|g|t|u]/ ) ) {\n            $perc_N++;\n        }\n    }\n    $perc_N = $perc_N * 100 / length $seq_string;\n    return $perc_N;\n}\n\n=head2 _redundancy\n\n    Title   : _redundancy\n    Usage   : my $ref = $ass_io->_redundancy($contigobj)\n    Function: Calculate the fold coverage (redundancy) of a contig consensus\n              (average number of read base pairs covering the consensus)\n    Returns : decimal number\n    Args    : Bio::Assembly::Contig\n\n\nsub _redundancy {\n    # redundancy = (sum of all aligned read lengths - ( number of gaps in gapped\n    # consensus + number of gaps in aligned reads that are also in the consensus ) )\n    # / length of ungapped consensus\n    my ($self, $contigobj) = @_;\n    my $redundancy = 0;\n    \n    # sum of all aligned read lengths\n    my $read_tot = 0;\n    for my $readobj ( $contigobj->each_seq ) {\n        my $read_length = length($readobj->seq);\n        $read_tot += $read_length;\n    }\n    $redundancy += $read_tot;\n    \n    # - respected gaps\n    my $consensus_sequence = $contigobj->get_consensus_sequence->seq;\n    my @consensus_gaps = ();\n    $contigobj->_register_gaps($consensus_sequence, \\@consensus_gaps);\n    my $respected_gaps = scalar(@consensus_gaps);\n    if ($respected_gaps > 0) {\n        my @cons_arr = split //, $consensus_sequence;\n        for my $gap_pos_cons ( @consensus_gaps ) {\n            for my $readobj ( $contigobj->each_seq ) {\n                my $readid = $readobj->id;\n                my $read_start = $contigobj->change_coord(\n                    \"aligned $readid\", 'gapped consensus', $readobj->start);\n                my $read_end   = $contigobj->change_coord(\n                    \"aligned $readid\", 'gapped consensus', $readobj->end  );\n                # skip this if consensus gap position not within in the read boundaries\n                next if ( ($gap_pos_cons < $read_start)\n                    || ($gap_pos_cons > $read_end) );\n                # does the read position have read have a gap?\n                my @read_arr = split //, $readobj->seq;                \n                my $gap_pos_read = $contigobj->change_coord(\n                    'gapped consensus', \"aligned $readid\", $gap_pos_cons);\n                if ($read_arr[$gap_pos_read-1] eq $cons_arr[$gap_pos_cons-1]) {\n                    $respected_gaps++;\n                }\n            }\n        }\n    }\n    $redundancy -= $respected_gaps;\n    \n    # / length of ungapped consensus\n    my $contig_length = length($self->_ungap($contigobj->get_consensus_sequence->seq));\n    $redundancy /= $contig_length;\n    \n    return $redundancy;\n}\n\n=head2 _ungap\n\n    Title   : _ungap\n    Usage   : my $ungapped = $ass_io->_ungap($gapped)\n    Function: Remove the gaps from a sequence. Gaps are - in TIGR Assembler\n    Returns : string\n    Args    : string","parameters":[{"label":"$self"},{"label":"$seq_string"}],"label":"_ungap($self,$seq_string)"},"detail":"($self,$seq_string)","name":"_ungap","range":{"start":{"line":1045,"character":0},"end":{"line":1049,"character":9999}}},{"detail":"($self)","signature":{"documentation":"__END__\n# $Id: tigr.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO::tigr\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO::tigr - Driver to read and write assembly files in the TIGR\nAssembler v2 default format.\n\n=head1 SYNOPSIS\n\n    # Building an input stream\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $asmio = Bio::Assembly::IO->new( -file   => 'SGC0-424.tasm',\n                                        -format => 'tigr' );\n    my $scaffold = $asmio->next_assembly;\n\n    # Do some things on contigs...\n\n    # Assembly writing methods\n    my $outasm = Bio::Assembly::IO->new( -file   => \">SGC0-modified.tasm\",\n                                         -format => 'tigr' );\n    $outasm->write_assembly( -scaffold => $assembly,\n                             -singlets => 1 );\n\n=head1 DESCRIPTION\n\nThis package loads and writes assembly information in/from files in the default\nTIGR Assembler v2 format. The files are lassie-formatted and often have the\n.tasm extension. This module was written to be used as a driver module for\nBio::Assembly::IO input/output.\n\n=head2 Implementation\n\nAssemblies are loaded into Bio::Assembly::Scaffold objects composed of\nBio::Assembly::Contig and Bio::Assembly::Singlet objects. Since aligned reads\nand contig gapped consensus can be obtained in the tasm files, only\naligned/gapped sequences are added to the different BioPerl objects.\n\nAdditional assembly information is stored as features. Contig objects have\nSeqFeature information associated with the primary_tag:\n\n    _main_contig_feature:$contig_id -> misc contig information\n    _quality_clipping:$read_id      -> quality clipping position\n\nRead objects have sub_seqFeature information associated with the\nprimary_tag:\n\n    _main_read_feature:$read_id     -> misc read information\n\nSinglets are considered by TIGR Assembler as contigs of one sequence and are\nrepresented here with features having these primary_tag: \n\n    _main_contig_feature:$contig_id\n    _quality_clipping:$read_primary_id\n    _main_read_feature:$read_primary_id\n    _aligned_coord:$read_primary_id\n\n=head1 THE TIGR TASM LASSIEFORMAT\n\n=head2 Description\n\nIn the TIGR tasm lassie format, contigs are separated by a line containing a single\npipe character \"|\", whereas the reads in a contig are separated by a blank line.\nSinglets can be present in the file and are represented as a contig\ncomposed of a single sequence.\n\nOther than the two above-mentioned separators, each line has an attribute name,\nfollowed a tab and then an attribute value.\n\nThe tasm format is used by more TIGR applications than just TIGR Assembler.\nSome of the attributes are not used by TIGR Assembler or have constant values.\nThey are indicated by an asterisk *\n\nContigs have the following attributes:\n\n    asmbl_id   -> contig ID\n    sequence   -> contig ungapped consensus sequence (ambiguities are lowercase)\n    lsequence  -> gapped consensus sequence (lowercase ambiguities)\n    quality    -> gapped consensus quality score (in hexadecimal)\n    seq_id     -> *\n    com_name   -> *\n    type       -> *\n    method     -> always 'asmg' *\n    ed_status  -> *\n    redundancy -> fold coverage of the contig consensus\n    perc_N     -> percent of ambiguities in the contig consensus\n    seq#       -> number of sequences in the contig\n    full_cds   -> *\n    cds_start  -> start of coding sequence *\n    cds_end    -> end of coding sequence *\n    ed_pn      -> name of editor (always 'GRA') *\n    ed_date    -> date and time of edition\n    comment    -> some comments *\n    frameshift -> *\n\nEach read has the following attributes:\n\n    seq_name  -> read name\n    asm_lend  -> position of first base on contig ungapped consensus sequence\n    asm_rend  -> position of last base on contig ungapped consensus sequence\n    seq_lend  -> start of quality-trimmed sequence (aligned read coordinates)\n    seq_rend  -> end of quality-trimmed sequence (aligned read coordinates)\n    best      -> always '0' *\n    comment   -> some comments *\n    db        -> database name associated with the sequence (e.g. >my_db|seq1234)\n    offset    -> offset of the sequence (gapped consensus coordinates)\n    lsequence -> aligned read sequence (ambiguities are uppercase)\n\nWhen asm_rend E<lt> asm_lend, the sequence was on the complementary DNA strand but\nits reverse complement is shown in the aligned sequence of the assembly file,\nnot the original read.\n\nAmbiguities are reflected in the contig consensus sequence as\nlowercase IUPAC characters: a c g t u m r w s y k x n . In the read\nsequences, however, ambiguities are uppercase: M R W S Y K X N\n\n=head2 Example\n\nExample of a contig containing three sequences:\n\n    sequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCGCAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    quality\t0x0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0505050505050505050E0505160505050505050505050505050505050505050505050505050505050303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0404040404040404041604040404040404040404040404040404040404040404040404040404040404040404040404040404040E0404040404040404040B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B\n    asmbl_id\t93\n    seq_id\t\n    com_name\t\n    type\t\n    method\tasmg\n    ed_status\t\n    redundancy\t1.11\n    perc_N\t0.20\n    seq#\t3\n    full_cds\t\n    cds_start\t\n    cds_end\t\n    ed_pn\tGRA\n    ed_date\t08/16/07 17:10:12\n    comment\t\n    frameshift\t\n\n    seq_name\tSDSU_RFPERU_010_C09.x01.phd.1\n    asm_lend\t1\n    asm_rend\t4423\n    seq_lend\t1\n    seq_rend\t442\n    best\t0\n    comment\t\n    db\t\n    offset\t0\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAGCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGG\n\n    seq_name\tSDSU_RFPERU_002_H12.x01.phd.1\n    asm_lend\t339\n    asm_rend\t940\n    seq_lend\t1\n    seq_rend\t602\n    best\t0\n    comment\t\n    db\t\n    offset\t338\n    lsequence\tCGAGATTCGCCACCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCCGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATA-GCGTGGCGC\n\n    seq_name\tSDSU_RFPERU_009_E07.x01.phd.1\n    asm_lend\t880\n    asm_rend\t1520\n    seq_lend\t641\n    seq_rend\t1\n    best\t0\n    comment\t\n    db\t\n    offset\t8803\n    lsequence\tCGCACGGTCTGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAAGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    |\n\n...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent dot angly at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::IO::tigr;\n\nuse strict;\nuse Bio::Seq::Quality;\nuse Bio::LocatableSeq;\nuse Bio::Assembly::IO;\nuse Bio::Assembly::Scaffold;\nuse Bio::Assembly::Contig;\nuse Bio::Assembly::Singlet;\n\nuse base qw(Bio::Assembly::IO);\n\nmy $progname = 'TIGR Assembler';\n\n=head2 next_assembly\n\n Title   : next_assembly\n Usage   : my $scaffold = $asmio->next_assembly()\n Function: return the next assembly in the tasm-formatted stream\n Returns : Bio::Assembly::Scaffold object\n Args    : none\n\n\nsub next_assembly {\n    my $self = shift; # object reference\n    \n    # Create a new scaffold to hold the contigs\n    my $scaffoldobj = Bio::Assembly::Scaffold->new(-source => $progname);\n    \n    # Contig and read related\n    my $contigobj;\n    my $iscontig = 1;\n    my %contiginfo;\n    my $isread = 0;\n    my %readinfo;\n    \n    # Loop over all assembly file lines\n    while ($_ = $self->_readline) {\n        chomp;\n        if ( /^\\|/ ) {  # a line with a single pipe |\n            # The end of a read from a contig, the start of a new contig\n            $iscontig = 1;\n            $isread   = 0;\n            # Store read info\n            if ($contiginfo{'seqnum'} > 1) {\n                # This is a read in a contig\n                my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n            } elsif ($contiginfo{'seqnum'} == 1) {\n                # This is a singlet\n                my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                    $scaffoldobj);\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n            # Clear read info\n            undef %readinfo;\n            # Clear contig info\n            undef $contigobj;\n            undef %contiginfo;\n        } elsif ( /^$/ ) {  # a blank line\n            if ($iscontig) {\n                # The end of a contig, the start of a read in that contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store contig info\n                $contigobj = $self->_store_contig( \\%contiginfo, $contigobj,\n                    $scaffoldobj ) if $contiginfo{'seqnum'} > 1;\n            } elsif ($isread) {\n                # The end of read in a contig, the start of a new one in\n                # the same contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store read info\n                if ($contiginfo{'seqnum'} > 1) {\n                    # This is a read in a contig\n                    my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n                } elsif ($contiginfo{'seqnum'} == 1) {\n                    # This is a singlet\n                    my $singletobj = $self->_store_singlet(\\%readinfo,\n                        \\%contiginfo, $scaffoldobj);\n                } else {\n                  # That should not happen\n                  $self->throw(\"Unhandled exception\");\n                }\n                # Clear read info\n                undef %readinfo;\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n        } else {\n            if ($iscontig) {\n                # Parse contig\n                if    (/^sequence\\t(.*)/)     {$contiginfo{'sequence'}   = $1; next}\n                elsif (/^lsequence\\t(.*)/)    {$contiginfo{'lsequence'}  = $1; next}\n                elsif (/^quality\\t(.*)/)      {$contiginfo{'quality'}    = $1; next}\n                elsif (/^asmbl_id\\t(.*)/)     {$contiginfo{'asmbl_id'}   = $1; next}\n                elsif (/^seq_id\\t(.*)/)       {$contiginfo{'seq_id'}     = $1; next}\n                elsif (/^com_name\\t(.*)/)     {$contiginfo{'com_name'}   = $1; next}\n                elsif (/^type\\t(.*)/)         {$contiginfo{'type'}       = $1; next}\n                elsif (/^method\\t(.*)/)       {$contiginfo{'method'}     = $1; next}\n                elsif (/^ed_status\\t(.*)/)    {$contiginfo{'ed_status'}  = $1; next}\n                elsif (/^redundancy\\t(.*)/)   {$contiginfo{'redundancy'} = $1; next}\n                elsif (/^perc_N\\t(.*)/)       {$contiginfo{'perc_N'}     = $1; next}\n                elsif (/^seq\\#\\t(.*)/)        {$contiginfo{'seqnum'}     = $1; next}\n                elsif (/^full_cds\\t(.*)/)     {$contiginfo{'full_cds'}   = $1; next}\n                elsif (/^cds_start\\t(.*)/)    {$contiginfo{'cds_start'}  = $1; next}\n                elsif (/^cds_end\\t(.*)/)      {$contiginfo{'cds_end'}    = $1; next}\n                elsif (/^ed_pn\\t(.*)/)        {$contiginfo{'ed_pn'}      = $1; next}\n                elsif (/^ed_date\\t(.*\\s.*)/)  {$contiginfo{'ed_date'}    = $1; next}\n                elsif (/^comment\\t(.*)/)      {$contiginfo{'comment'}    = $1; next}\n                elsif (/^frameshift\\t(.*)/)   {$contiginfo{'frameshift'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } elsif ($isread) {\n                # Parse read info\n                if    (/^seq_name\\t(.*)/)  {$readinfo{'seq_name'}  = $1; next}\n                elsif (/^asm_lend\\t(.*)/)  {$readinfo{'asm_lend'}  = $1; next}\n                elsif (/^asm_rend\\t(.*)/)  {$readinfo{'asm_rend'}  = $1; next}\n                elsif (/^seq_lend\\t(.*)/)  {$readinfo{'seq_lend'}  = $1; next}\n                elsif (/^seq_rend\\t(.*)/)  {$readinfo{'seq_rend'}  = $1; next}\n                elsif (/^best\\t(.*)/)      {$readinfo{'best'}      = $1; next}\n                elsif (/^comment\\t(.*)/)   {$readinfo{'comment'}   = $1; next}\n                elsif (/^db\\t(.*)/)        {$readinfo{'db'}        = $1; next}\n                elsif (/^offset\\t(.*)/)    {$readinfo{'offset'}    = $1; next}\n                elsif (/^lsequence\\t(.*)/) {$readinfo{'lsequence'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } else {\n                # That shouldn't happen\n                $self->throw(\"Unhandled exception\");                \n            }\n        }\n    }\n    # Store read info for last read\n    if (defined $contiginfo{'seqnum'}) {\n        if ($contiginfo{'seqnum'} > 1) {\n            # This is a read in a contig\n            my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n        } elsif ($contiginfo{'seqnum'} == 1) {\n            # This is a singlet\n            my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                $scaffoldobj);\n        } else {\n            # That should not happen\n            $self->throw(\"Unhandled exception\");\n        }\n    }\n    # Clear read info for last read\n    undef %readinfo;\n    # Clear contig info for last contig\n    undef $contigobj;\n    undef %contiginfo;\n    \n    $scaffoldobj->update_seq_list();\n    \n    return $scaffoldobj;\n}\n\n=head2 _qual_hex2dec\n\n    Title   : _qual_hex2dec\n    Usage   : my dec_quality = $self->_qual_hex2dec($hex_quality);\n    Function: convert an hexadecimal quality score into a decimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_hex2dec {\n    my ($self, $qual) = @_;\n    $qual =~ s/^0x(.*)$/$1/;\n    $qual =~ s/(..)/hex($1).' '/eg;\n    return $qual;\n}\n\n=head2 _qual_dec2hex\n\n    Title   : _qual_dec2hex\n    Usage   : my hex_quality = $self->_qual_dec2hex($dec_quality);\n    Function: convert a decimal quality score into an hexadecimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_dec2hex {\n    my ($self, $qual) = @_;\n    $qual =~ s/(\\d+)\\s*/sprintf('%02X', $1)/eg;\n    $qual = '0x'.$qual;\n    return $qual;\n}\n\n=head2 _store_contig\n\n    Title   : _store_contig\n    Usage   : my $contigobj; $contigobj = $self->_store_contig(\n              \\%contiginfo, $contigobj, $scaffoldobj);\n    Function: store information of a contig belonging to a scaffold in the\n              appropriate object\n    Returns : Bio::Assembly::Contig object\n    Args    : hash, Bio::Assembly::Contig, Bio::Assembly::Scaffold\n\n\nsub _store_contig {\n    my ($self, $contiginfo, $contigobj, $scaffoldobj) = @_;\n\n    # Create a contig and attach it to scaffold\n    $contigobj = Bio::Assembly::Contig->new(\n        -id     => $$contiginfo{'asmbl_id'},\n        -source => $progname,\n        -strand => 1\n    );\n    $scaffoldobj->add_contig($contigobj);\n\n    # Create a gapped consensus sequence and attach it to contig\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $consensus = Bio::LocatableSeq->new(\n        -id    => $$contiginfo{'asmbl_id'},\n        -seq   => $$contiginfo{'lsequence'},\n        -start => 1,\n    );\n    $contigobj->set_consensus_sequence($consensus);\n\n    # Create an gapped consensus quality score and attach it to contig\n    $$contiginfo{'quality'} = $self->_qual_hex2dec($$contiginfo{'quality'});\n    my $qual = Bio::Seq::Quality->new(\n        -id   => $$contiginfo{'asmbl_id'},\n        -qual => $$contiginfo{'quality'}\n    );\n    $contigobj->set_consensus_quality($qual);\n\n    # Add other misc contig information as features of the contig\n    my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$$contiginfo{'asmbl_id'}\",\n        -start       => 1,\n        -end         => $contigobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n    );\n    $contigobj->add_features([ $contigtags ], 1);\n\n    return $contigobj;\n}\n\n=head2 _store_read\n\n    Title   : _store_read\n    Usage   : my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n    Function: store information of a read belonging to a contig in the appropriate object\n    Returns : Bio::LocatableSeq\n    Args    : hash, Bio::Assembly::Contig\n\n\nsub _store_read {\n   my ($self, $readinfo, $contigobj) = @_;\n\n   # Create an aligned read object\n   #$$readinfo{'llength'} = length($$readinfo{'lsequence'});\n   $$readinfo{'strand'}  = ($$readinfo{'seq_rend'} > $$readinfo{'seq_lend'} ? 1 : -1);\n   my $readobj = Bio::LocatableSeq->new(\n       # the ids of sequence objects are supposed to include the db name in it, i.e. \"big_db|seq1234\"\n       # that's how sequence ids coming from the fasta parser are at least\n       -display_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -primary_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -seq        => $$readinfo{'lsequence'},      \n       -start      => 1,\n       -strand     => $$readinfo{'strand'},\n       -alphabet   => 'dna'\n   );\n\n   # Add read location and sequence to contig (in 'gapped consensus' coordinates)\n   $$readinfo{'aln_start'} = $$readinfo{'offset'} + 1; # seq offset is in gapped coordinates\n   $$readinfo{'aln_end'} = $$readinfo{'aln_start'} + length($$readinfo{'lsequence'}) - 1; # lsequence is aligned seq\n   my $alncoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => $readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigobj->id() }\n   );\n   $contigobj->set_seq_coord($alncoord, $readobj);\n\n   # Add quality clipping read information in contig features\n   # (from 'aligned read' to 'gapped consensus' coordinates)\n   $$readinfo{'clip_start'} = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_lend'});\n   $$readinfo{'clip_end'}   = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_rend'});\n   my $clipcoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_quality_clipping:'.$readobj->id,\n       -start       => $$readinfo{'clip_start'},\n       -end         => $$readinfo{'clip_end'},\n       -strand      => $$readinfo{'strand'}\n   );\n   $clipcoord->attach_seq($readobj);\n   $contigobj->add_features([ $clipcoord ], 0);\n   \n   # Add other misc read information as subsequence feature\n   my $readtags = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_main_read_feature:'.$readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'best'    => $$readinfo{'best'},\n                         'comment' => $$readinfo{'comment'} }\n   );\n   $alncoord->add_sub_SeqFeature($readtags);\n\n   return $readobj;\n}\n\n=head2 _store_singlet\n\n    Title   : _store_singlet\n    Usage   : my $singletobj = $self->_store_read(\\%readinfo, \\%contiginfo,\n                  $scaffoldobj);\n    Function: store information of a singlet belonging to a scaffold in the appropriate object\n    Returns : Bio::Assembly::Singlet\n    Args    : hash, hash, Bio::Assembly::Scaffold\n\n\nsub _store_singlet {\n    my ($self, $readinfo, $contiginfo, $scaffoldobj) = @_;\n    # Singlets in TIGR_Assembler are represented as a contig of one sequence\n    # We try to simulate this duality by playing around with the Singlet object\n    \n    my $contigid = $$contiginfo{'asmbl_id'};\n    my $readid   = $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'});\n    \n    # Create a sequence object\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $seqobj = Bio::Seq::Quality->new(\n       -primary_id => $contigid, # unique id in assembly (contig name)\n       -display_id => $readid,\n       -seq        => $$contiginfo{'lsequence'}, # do not use $$readinfo as ambiguities are uppercase\n       -start      => 1,\n       -strand     => $$readinfo{'strand'},\n       -alphabet   => 'dna',\n       -qual => $self->_qual_hex2dec($$contiginfo{'quality'})    \n   );\n\n   # Create singlet from sequence and add it to scaffold\n   my $singletobj = Bio::Assembly::Singlet->new( -seqref => $seqobj );\n   $scaffoldobj->add_singlet($singletobj);\n\n   # Add other misc contig information as features of the singlet\n   my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$contigid\",\n        -start       => 1,\n        -end         => $singletobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n   );\n   $singletobj->add_features([ $contigtags ], 1);\n\n   # Add read location and sequence to singlet features (in 'gapped consensus' coordinates)\n   $$readinfo{'aln_start'} = $$readinfo{'offset'} + 1; # seq offset is in gapped coordinates\n   $$readinfo{'aln_end'} = $$readinfo{'aln_start'} + length($$readinfo{'lsequence'}) - 1; # lsequence is aligned seq\n\n   my $alncoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_aligned_coord:$readid\",\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigid }\n   );\n   $alncoord->attach_seq($singletobj->seqref);\n   $singletobj->add_features([ $alncoord ], 0);\n\n   # Add quality clipping read information in singlet features\n   # (from 'aligned read' to 'gapped consensus' coordinates)\n   $$readinfo{'clip_start'} = $$readinfo{'seq_lend'};\n   $$readinfo{'clip_end'}   = $$readinfo{'seq_rend'};\n   my $clipcoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_quality_clipping:$readid\",\n       -start       => $$readinfo{'clip_start'},\n       -end         => $$readinfo{'clip_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigid }\n   );\n   $clipcoord->attach_seq($singletobj->seqref);\n   $singletobj->add_features([ $clipcoord ], 0);\n   \n   # Add other misc read information as subsequence feature\n   my $readtags = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_main_read_feature:$readid\",\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'best'    => $$readinfo{'best'},\n                         'comment' => $$readinfo{'comment'} }\n   );\n   $alncoord->add_sub_SeqFeature($readtags);\n      \n   return $singletobj;\n}\n\n=head2 write_assembly\n\n    Title   : write_assembly\n    Usage   : $ass_io->write_assembly($assembly)\n    Function: Write the assembly object in TIGR Assembler compatible tasm lassie  \n              format\n    Returns : 1 on success, 0 for error\n    Args    : A Bio::Assembly::Scaffold object\n\n\nsub write_assembly {\n    my ($self,@args) = @_;    \n    my ($scaffoldobj, $singlets) = $self->_rearrange([qw(SCAFFOLD SINGLETS)], @args);\n    \n    # Sanity check\n    if ( !$scaffoldobj || !$scaffoldobj->isa('Bio::Assembly::Scaffold') ) {\n        $self->warn(\"Must provide a Bio::Align::AlignI object when calling\n            write_assembly\");\n        next;\n    }\n\n    # Get list of objects - contigs and singlets\n    my @cont_ids = $scaffoldobj->get_contig_ids;\n    my @sing_ids = $scaffoldobj->get_singlet_ids;\n    my %did;\n    my $decimal_format = '%.2f';\n    for (my $i = 0; $i < scalar @sing_ids ; $i++) {\n      # singlet display id (string)\n      my $display_id = $sing_ids[$i];\n      # singlet primary id (unique, numerical)\n      my $primary_id = $scaffoldobj->get_singlet_by_id($display_id)->seqref->primary_id;\n      $sing_ids[$i] = $primary_id;\n      $did{$primary_id} = $display_id;\n    }\n    my @ids = (@cont_ids, @sing_ids);\n    @ids = sort { $a <=> $b } @ids; # list with contig ids and singlet primary id\n    my $numobj = scalar @ids;\n\n    # Output all contigs and singlets (sorted by increasing id number)\n    for (my $i = 0 ; $i < $numobj ; $i++) {\n        \n        my $objid = $ids[$i];\n        \n        if (defined $did{$objid}) { \n            # This is a singlet\n            next unless ($singlets);\n\n            my $contigid = $objid;\n            my $readid   = $did{$objid};            \n            my $singletobj = $scaffoldobj->get_singlet_by_id($readid);\n            \n            # Get contig information\n            my $contanno = (grep\n                { $_->primary_tag eq \"_main_contig_feature:$contigid\" }\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my %contiginfo;\n            $contiginfo{'sequence'}   = $singletobj->seqref->seq;\n            $contiginfo{'lsequence'}  = $contiginfo{'sequence'};\n            $contiginfo{'quality'}    = $self->_qual_dec2hex(\n                join ' ', @{$singletobj->seqref->qual});\n            $contiginfo{'asmbl_id'}   = $contigid;\n            $contiginfo{'seq_id'}     = ($contanno->get_tag_values('seq_id'))[0];   \n            $contiginfo{'com_name'}   = ($contanno->get_tag_values('com_name'))[0];\n            $contiginfo{'type'}       = ($contanno->get_tag_values('type'))[0];\n            $contiginfo{'method'}     = ($contanno->get_tag_values('method'))[0];\n            $contiginfo{'ed_status'}  = ($contanno->get_tag_values('ed_status'))[0];\n            $contiginfo{'redundancy'} = sprintf($decimal_format, 1);\n            $contiginfo{'perc_N'}     = sprintf(\n                $decimal_format, $self->_perc_N($contiginfo{'sequence'}));\n            $contiginfo{'seqnum'}     = 1;\n            $contiginfo{'full_cds'}   = ($contanno->get_tag_values('full_cds'))[0];\n            $contiginfo{'cds_start'}  = ($contanno->get_tag_values('cds_start'))[0];\n            $contiginfo{'cds_end'}    = ($contanno->get_tag_values('cds_end'))[0];\n            $contiginfo{'ed_pn'}      = ($contanno->get_tag_values('ed_pn'))[0];\n            $contiginfo{'ed_date'}    = $self->_date_time;\n            $contiginfo{'comment'}    = ($contanno->get_tag_values('comment'))[0];\n            $contiginfo{'frameshift'} = ($contanno->get_tag_values('frameshift'))[0];\n\n            # Check that no tag value is undef\n            $contiginfo{'seq_id'}     = '' unless defined $contiginfo{'seq_id'};\n            $contiginfo{'com_name'}   = '' unless defined $contiginfo{'com_name'};\n            $contiginfo{'type'}       = '' unless defined $contiginfo{'type'};\n            $contiginfo{'method'}     = '' unless defined $contiginfo{'method'};\n            $contiginfo{'ed_status'}  = '' unless defined $contiginfo{'ed_status'};\n            $contiginfo{'full_cds'}   = '' unless defined $contiginfo{'full_cds'};\n            $contiginfo{'cds_start'}  = '' unless defined $contiginfo{'cds_start'};\n            $contiginfo{'cds_end'}    = '' unless defined $contiginfo{'cds_end'};\n            $contiginfo{'ed_pn'}      = '' unless defined $contiginfo{'ed_pn'};\n            $contiginfo{'comment'}    = '' unless defined $contiginfo{'comment'};\n            $contiginfo{'frameshift'} = '' unless defined $contiginfo{'frameshift'};\n            \n            # Print contig information\n            $self->_print(\n                \"sequence\\t$contiginfo{'sequence'}\\n\".\n                \"lsequence\\t$contiginfo{'lsequence'}\\n\".\n                \"quality\\t$contiginfo{'quality'}\\n\".\n                \"asmbl_id\\t$contiginfo{'asmbl_id'}\\n\".\n                \"seq_id\\t$contiginfo{'seq_id'}\\n\".\n                \"com_name\\t$contiginfo{'com_name'}\\n\".\n                \"type\\t$contiginfo{'type'}\\n\".\n                \"method\\t$contiginfo{'method'}\\n\".\n                \"ed_status\\t$contiginfo{'ed_status'}\\n\".\n                \"redundancy\\t$contiginfo{'redundancy'}\\n\".\n                \"perc_N\\t$contiginfo{'perc_N'}\\n\".\n                \"seq#\\t$contiginfo{'seqnum'}\\n\".\n                \"full_cds\\t$contiginfo{'full_cds'}\\n\".\n                \"cds_start\\t$contiginfo{'cds_start'}\\n\".\n                \"cds_end\\t$contiginfo{'cds_end'}\\n\".\n                \"ed_pn\\t$contiginfo{'ed_pn'}\\n\".\n                \"ed_date\\t$contiginfo{'ed_date'}\\n\".\n                \"comment\\t$contiginfo{'comment'}\\n\".\n                \"frameshift\\t$contiginfo{'frameshift'}\\n\".\n                \"\\n\"\n            );\n                        \n            # Get read information\n            my ($seq_name, $db) = $self->_split_seq_name_and_db($readid);\n            my $clipcoord = (grep\n                { $_->primary_tag eq \"_quality_clipping:$readid\"}\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my $alncoord  = (grep\n                { $_->primary_tag eq \"_aligned_coord:$readid\"}\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my $readanno = (grep\n                { $_->primary_tag eq \"_main_read_feature:$readid\" }\n                $singletobj->get_seq_coord($singletobj->seqref)->get_SeqFeatures\n            )[0];\n            my %readinfo;\n            $readinfo{'seq_name'}  = $seq_name;\n            $readinfo{'asm_lend'}  = $alncoord->location->start;\n            $readinfo{'asm_rend'}  = $alncoord->location->end;\n            $readinfo{'seq_lend'}  = $clipcoord->location->start;\n            $readinfo{'seq_rend'}  = $clipcoord->location->end;\n            $readinfo{'best'}      = ($readanno->get_tag_values('best'))[0];\n            $readinfo{'comment'}   = ($readanno->get_tag_values('comment'))[0];\n            $readinfo{'db'}        = $db;         \n            $readinfo{'offset'}    = 0;\n            # ambiguities in read sequence are uppercase\n            $readinfo{'lsequence'} = uc($contiginfo{'lsequence'});\n            \n            # Check that no tag value is undef\n            $readinfo{'best'}    = '' unless defined $readinfo{'best'};\n            $readinfo{'comment'} = '' unless defined $readinfo{'comment'};\n\n            # Print read information\n            $self->_print(\n                \"seq_name\\t$readinfo{'seq_name'}\\n\".\n                \"asm_lend\\t$readinfo{'asm_lend'}\\n\".\n                \"asm_rend\\t$readinfo{'asm_rend'}\\n\".\n                \"seq_lend\\t$readinfo{'seq_lend'}\\n\".\n                \"seq_rend\\t$readinfo{'seq_rend'}\\n\".\n                \"best\\t$readinfo{'best'}\\n\".\n                \"comment\\t$readinfo{'comment'}\\n\".\n                \"db\\t$readinfo{'db'}\\n\".\n                \"offset\\t$readinfo{'offset'}\\n\".\n                \"lsequence\\t$readinfo{'lsequence'}\\n\"\n            );\n            if ($i+1 < $numobj) {\n                $self->_print(\"|\\n\");\n            }\n        } else {\n            # This is a contig\n            my $contigid = $objid;\n            my $contigobj = $scaffoldobj->get_contig_by_id($contigid);\n\n            # Skip contigs of 1 sequence (singlets) if needed\n            next if ($contigobj->num_sequences == 1) && (!$singlets);\n            \n            # Get contig information\n            my $contanno = (grep\n                { $_->primary_tag eq \"_main_contig_feature:$contigid\" }\n                $contigobj->get_features_collection->get_all_features\n            )[0];\n            my %contiginfo;\n            $contiginfo{'sequence'}   = $self->_ungap(\n                $contigobj->get_consensus_sequence->seq);\n            $contiginfo{'lsequence'}  = $contigobj->get_consensus_sequence->seq;\n            $contiginfo{'quality'}    = $self->_qual_dec2hex(\n                join ' ', @{$contigobj->get_consensus_quality->qual});\n            $contiginfo{'asmbl_id'}   = $contigid;\n            $contiginfo{'seq_id'}     = ($contanno->get_tag_values('seq_id'))[0];\n            $contiginfo{'com_name'}   = ($contanno->get_tag_values('com_name'))[0];\n            $contiginfo{'type'}       = ($contanno->get_tag_values('type'))[0];\n            $contiginfo{'method'}     = ($contanno->get_tag_values('method'))[0];\n            $contiginfo{'ed_status'}  = ($contanno->get_tag_values('ed_status'))[0];\n            $contiginfo{'redundancy'} = sprintf(\n                $decimal_format, $self->_redundancy($contigobj));\n            $contiginfo{'perc_N'}     = sprintf(\n                $decimal_format, $self->_perc_N($contiginfo{'sequence'}));\n            $contiginfo{'seqnum'}     = $contigobj->num_sequences;\n            $contiginfo{'full_cds'}   = ($contanno->get_tag_values('full_cds'))[0];\n            $contiginfo{'cds_start'}  = ($contanno->get_tag_values('cds_start'))[0];\n            $contiginfo{'cds_end'}    = ($contanno->get_tag_values('cds_end'))[0];\n            $contiginfo{'ed_pn'}      = ($contanno->get_tag_values('ed_pn'))[0];\n            $contiginfo{'ed_date'}    = $self->_date_time;\n            $contiginfo{'comment'}    = ($contanno->get_tag_values('comment'))[0];\n            $contiginfo{'frameshift'} = ($contanno->get_tag_values('frameshift'))[0];\n            \n            # Check that no tag value is undef\n            $contiginfo{'seq_id'}     = '' unless defined $contiginfo{'seq_id'};\n            $contiginfo{'com_name'}   = '' unless defined $contiginfo{'com_name'};\n            $contiginfo{'type'}       = '' unless defined $contiginfo{'type'};\n            $contiginfo{'method'}     = '' unless defined $contiginfo{'method'};\n            $contiginfo{'ed_status'}  = '' unless defined $contiginfo{'ed_status'};\n            $contiginfo{'full_cds'}   = '' unless defined $contiginfo{'full_cds'};\n            $contiginfo{'cds_start'}  = '' unless defined $contiginfo{'cds_start'};\n            $contiginfo{'cds_end'}    = '' unless defined $contiginfo{'cds_end'};\n            $contiginfo{'ed_pn'}      = '' unless defined $contiginfo{'ed_pn'};\n            $contiginfo{'comment'}    = '' unless defined $contiginfo{'comment'};\n            $contiginfo{'frameshift'} = '' unless defined $contiginfo{'frameshift'};\n                       \n            # Print contig information\n            $self->_print(\n                \"sequence\\t$contiginfo{'sequence'}\\n\".\n                \"lsequence\\t$contiginfo{'lsequence'}\\n\".\n                \"quality\\t$contiginfo{'quality'}\\n\".\n                \"asmbl_id\\t$contiginfo{'asmbl_id'}\\n\".\n                \"seq_id\\t$contiginfo{'seq_id'}\\n\".\n                \"com_name\\t$contiginfo{'com_name'}\\n\".\n                \"type\\t$contiginfo{'type'}\\n\".\n                \"method\\t$contiginfo{'method'}\\n\".\n                \"ed_status\\t$contiginfo{'ed_status'}\\n\".\n                \"redundancy\\t$contiginfo{'redundancy'}\\n\".\n                \"perc_N\\t$contiginfo{'perc_N'}\\n\".\n                \"seq#\\t$contiginfo{'seqnum'}\\n\".\n                \"full_cds\\t$contiginfo{'full_cds'}\\n\".\n                \"cds_start\\t$contiginfo{'cds_start'}\\n\".\n                \"cds_end\\t$contiginfo{'cds_end'}\\n\".\n                \"ed_pn\\t$contiginfo{'ed_pn'}\\n\".\n                \"ed_date\\t$contiginfo{'ed_date'}\\n\".\n                \"comment\\t$contiginfo{'comment'}\\n\".\n                \"frameshift\\t$contiginfo{'frameshift'}\\n\".\n                \"\\n\"\n            );\n            my $seqno = 0;\n            for my $readobj ( $contigobj->each_seq() ) {\n                $seqno++;\n                \n                # Get read information\n                my ($seq_name, $db) = $self->_split_seq_name_and_db($readobj->id);\n                my ($asm_lend, $asm_rend, $seq_lend, $seq_rend, $offset)\n                    = $self->_coord($readobj, $contigobj);\n                my $readanno = ( grep \n                    { $_->primary_tag eq '_main_read_feature:'.$readobj->primary_id }\n                    $contigobj->get_seq_coord($readobj)->get_SeqFeatures\n                )[0];\n                my %readinfo;                \n                $readinfo{'seq_name'}  = $seq_name;\n                $readinfo{'asm_lend'}  = $asm_lend;\n                $readinfo{'asm_rend'}  = $asm_rend;\n                $readinfo{'seq_lend'}  = $seq_lend;\n                $readinfo{'seq_rend'}  = $seq_rend;                \n                $readinfo{'best'}      = ($readanno->get_tag_values('best'))[0];\n                $readinfo{'comment'}   = ($readanno->get_tag_values('comment'))[0];\n                $readinfo{'db'}        = $db;\n                $readinfo{'offset'}    = $offset;   \n                $readinfo{'lsequence'} = $readobj->seq(); \n                         \n                # Check that no tag value is undef\n                $readinfo{'best'}    = '' unless defined $readinfo{'best'};\n                $readinfo{'comment'} = '' unless defined $readinfo{'comment'};\n    \n                # Print read information\n                $self->_print(\n                    \"seq_name\\t$readinfo{'seq_name'}\\n\".\n                    \"asm_lend\\t$readinfo{'asm_lend'}\\n\".\n                    \"asm_rend\\t$readinfo{'asm_rend'}\\n\".\n                    \"seq_lend\\t$readinfo{'seq_lend'}\\n\".\n                    \"seq_rend\\t$readinfo{'seq_rend'}\\n\".\n                    \"best\\t$readinfo{'best'}\\n\".\n                    \"comment\\t$readinfo{'comment'}\\n\".\n                    \"db\\t$readinfo{'db'}\\n\".\n                    \"offset\\t$readinfo{'offset'}\\n\".\n                    \"lsequence\\t$readinfo{'lsequence'}\\n\"\n                );\n                if ($seqno < $contiginfo{'seqnum'}) {\n                    $self->_print(\"\\n\");\n                } elsif (($seqno == $contiginfo{'seqnum'}) && ($i+1 < $numobj)) {\n                    $self->_print(\"|\\n\");\n                }\n            }\n        }\n    }\n    return 1;\n}\n\n=head2 _perc_N\n\n    Title   : _perc_N\n    Usage   : my $perc_N = $ass_io->_perc_N($sequence_string)\n    Function: Calculate the percent of ambiguities in a sequence.\n              M R W S Y K X N are regarded as ambiguites in an aligned read\n              sequence by TIGR Assembler. In the case of a gapped contig\n              consensus sequence, all lowercase symbols are ambiguities, i.e.:\n              a c g t u m r w s y k x n.\n    Returns : decimal number\n    Args    : string\n\n\nsub _perc_N {\n    my ($self, $seq_string) = @_;\n    $self->throw(\"Cannot accept an empty sequence\") if length($seq_string) == 0;\n    my $perc_N = 0;\n    for my $base ( split //, $seq_string ) {\n        # individual base matches an ambiguity?\n        if (( $base =~ m/[x|n|m|r|w|s|y|k]/i ) || ( $base =~ m/[a|c|g|t|u]/ ) ) {\n            $perc_N++;\n        }\n    }\n    $perc_N = $perc_N * 100 / length $seq_string;\n    return $perc_N;\n}\n\n=head2 _redundancy\n\n    Title   : _redundancy\n    Usage   : my $ref = $ass_io->_redundancy($contigobj)\n    Function: Calculate the fold coverage (redundancy) of a contig consensus\n              (average number of read base pairs covering the consensus)\n    Returns : decimal number\n    Args    : Bio::Assembly::Contig\n\n\nsub _redundancy {\n    # redundancy = (sum of all aligned read lengths - ( number of gaps in gapped\n    # consensus + number of gaps in aligned reads that are also in the consensus ) )\n    # / length of ungapped consensus\n    my ($self, $contigobj) = @_;\n    my $redundancy = 0;\n    \n    # sum of all aligned read lengths\n    my $read_tot = 0;\n    for my $readobj ( $contigobj->each_seq ) {\n        my $read_length = length($readobj->seq);\n        $read_tot += $read_length;\n    }\n    $redundancy += $read_tot;\n    \n    # - respected gaps\n    my $consensus_sequence = $contigobj->get_consensus_sequence->seq;\n    my @consensus_gaps = ();\n    $contigobj->_register_gaps($consensus_sequence, \\@consensus_gaps);\n    my $respected_gaps = scalar(@consensus_gaps);\n    if ($respected_gaps > 0) {\n        my @cons_arr = split //, $consensus_sequence;\n        for my $gap_pos_cons ( @consensus_gaps ) {\n            for my $readobj ( $contigobj->each_seq ) {\n                my $readid = $readobj->id;\n                my $read_start = $contigobj->change_coord(\n                    \"aligned $readid\", 'gapped consensus', $readobj->start);\n                my $read_end   = $contigobj->change_coord(\n                    \"aligned $readid\", 'gapped consensus', $readobj->end  );\n                # skip this if consensus gap position not within in the read boundaries\n                next if ( ($gap_pos_cons < $read_start)\n                    || ($gap_pos_cons > $read_end) );\n                # does the read position have read have a gap?\n                my @read_arr = split //, $readobj->seq;                \n                my $gap_pos_read = $contigobj->change_coord(\n                    'gapped consensus', \"aligned $readid\", $gap_pos_cons);\n                if ($read_arr[$gap_pos_read-1] eq $cons_arr[$gap_pos_cons-1]) {\n                    $respected_gaps++;\n                }\n            }\n        }\n    }\n    $redundancy -= $respected_gaps;\n    \n    # / length of ungapped consensus\n    my $contig_length = length($self->_ungap($contigobj->get_consensus_sequence->seq));\n    $redundancy /= $contig_length;\n    \n    return $redundancy;\n}\n\n=head2 _ungap\n\n    Title   : _ungap\n    Usage   : my $ungapped = $ass_io->_ungap($gapped)\n    Function: Remove the gaps from a sequence. Gaps are - in TIGR Assembler\n    Returns : string\n    Args    : string\n\n\nsub _ungap {\n    my ($self, $seq_string) = @_;\n    $seq_string =~ s/-//g;\n    return $seq_string;\n}\n\n=head2 _date_time\n\n    Title   : _date_time\n    Usage   : my $timepoint = $ass_io->date_time\n    Function: Get date and time (MM//DD/YY HH:MM:SS)\n    Returns : string\n    Args    : none","parameters":[{"label":"$self"}],"label":"_date_time($self)"},"containerName":"main::","definition":"sub","line":1061,"children":[{"line":1062,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_date_time"},{"line":1063,"kind":13,"localvar":"my","name":"$sec","definition":"my","containerName":"_date_time"},{"line":1063,"kind":13,"containerName":"_date_time","name":"$min"},{"containerName":"_date_time","name":"$hour","kind":13,"line":1063},{"name":"$mday","containerName":"_date_time","line":1063,"kind":13},{"line":1063,"kind":13,"name":"$mon","containerName":"_date_time"},{"name":"$year","containerName":"_date_time","line":1063,"kind":13},{"name":"$wday","containerName":"_date_time","kind":13,"line":1063},{"line":1063,"kind":13,"name":"$yday","containerName":"_date_time"},{"line":1063,"kind":13,"name":"$isdst","containerName":"_date_time"},{"line":1064,"kind":13,"localvar":"my","definition":"my","name":"$formatted_date_time","containerName":"_date_time"},{"name":"$mon","containerName":"_date_time","kind":13,"line":1065},{"containerName":"_date_time","name":"$mday","line":1066,"kind":13},{"name":"$year","containerName":"_date_time","line":1067,"kind":13},{"containerName":"_date_time","name":"$hour","kind":13,"line":1069},{"containerName":"_date_time","name":"$min","line":1070,"kind":13},{"line":1071,"kind":13,"containerName":"_date_time","name":"$sec"},{"containerName":"_date_time","name":"$formatted_date_time","line":1073,"kind":13}],"kind":12,"range":{"end":{"line":1074,"character":9999},"start":{"character":0,"line":1061}},"name":"_date_time"},{"signature":{"label":"_split_seq_name_and_db($self,$id)","parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"__END__\n# $Id: tigr.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO::tigr\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO::tigr - Driver to read and write assembly files in the TIGR\nAssembler v2 default format.\n\n=head1 SYNOPSIS\n\n    # Building an input stream\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $asmio = Bio::Assembly::IO->new( -file   => 'SGC0-424.tasm',\n                                        -format => 'tigr' );\n    my $scaffold = $asmio->next_assembly;\n\n    # Do some things on contigs...\n\n    # Assembly writing methods\n    my $outasm = Bio::Assembly::IO->new( -file   => \">SGC0-modified.tasm\",\n                                         -format => 'tigr' );\n    $outasm->write_assembly( -scaffold => $assembly,\n                             -singlets => 1 );\n\n=head1 DESCRIPTION\n\nThis package loads and writes assembly information in/from files in the default\nTIGR Assembler v2 format. The files are lassie-formatted and often have the\n.tasm extension. This module was written to be used as a driver module for\nBio::Assembly::IO input/output.\n\n=head2 Implementation\n\nAssemblies are loaded into Bio::Assembly::Scaffold objects composed of\nBio::Assembly::Contig and Bio::Assembly::Singlet objects. Since aligned reads\nand contig gapped consensus can be obtained in the tasm files, only\naligned/gapped sequences are added to the different BioPerl objects.\n\nAdditional assembly information is stored as features. Contig objects have\nSeqFeature information associated with the primary_tag:\n\n    _main_contig_feature:$contig_id -> misc contig information\n    _quality_clipping:$read_id      -> quality clipping position\n\nRead objects have sub_seqFeature information associated with the\nprimary_tag:\n\n    _main_read_feature:$read_id     -> misc read information\n\nSinglets are considered by TIGR Assembler as contigs of one sequence and are\nrepresented here with features having these primary_tag: \n\n    _main_contig_feature:$contig_id\n    _quality_clipping:$read_primary_id\n    _main_read_feature:$read_primary_id\n    _aligned_coord:$read_primary_id\n\n=head1 THE TIGR TASM LASSIEFORMAT\n\n=head2 Description\n\nIn the TIGR tasm lassie format, contigs are separated by a line containing a single\npipe character \"|\", whereas the reads in a contig are separated by a blank line.\nSinglets can be present in the file and are represented as a contig\ncomposed of a single sequence.\n\nOther than the two above-mentioned separators, each line has an attribute name,\nfollowed a tab and then an attribute value.\n\nThe tasm format is used by more TIGR applications than just TIGR Assembler.\nSome of the attributes are not used by TIGR Assembler or have constant values.\nThey are indicated by an asterisk *\n\nContigs have the following attributes:\n\n    asmbl_id   -> contig ID\n    sequence   -> contig ungapped consensus sequence (ambiguities are lowercase)\n    lsequence  -> gapped consensus sequence (lowercase ambiguities)\n    quality    -> gapped consensus quality score (in hexadecimal)\n    seq_id     -> *\n    com_name   -> *\n    type       -> *\n    method     -> always 'asmg' *\n    ed_status  -> *\n    redundancy -> fold coverage of the contig consensus\n    perc_N     -> percent of ambiguities in the contig consensus\n    seq#       -> number of sequences in the contig\n    full_cds   -> *\n    cds_start  -> start of coding sequence *\n    cds_end    -> end of coding sequence *\n    ed_pn      -> name of editor (always 'GRA') *\n    ed_date    -> date and time of edition\n    comment    -> some comments *\n    frameshift -> *\n\nEach read has the following attributes:\n\n    seq_name  -> read name\n    asm_lend  -> position of first base on contig ungapped consensus sequence\n    asm_rend  -> position of last base on contig ungapped consensus sequence\n    seq_lend  -> start of quality-trimmed sequence (aligned read coordinates)\n    seq_rend  -> end of quality-trimmed sequence (aligned read coordinates)\n    best      -> always '0' *\n    comment   -> some comments *\n    db        -> database name associated with the sequence (e.g. >my_db|seq1234)\n    offset    -> offset of the sequence (gapped consensus coordinates)\n    lsequence -> aligned read sequence (ambiguities are uppercase)\n\nWhen asm_rend E<lt> asm_lend, the sequence was on the complementary DNA strand but\nits reverse complement is shown in the aligned sequence of the assembly file,\nnot the original read.\n\nAmbiguities are reflected in the contig consensus sequence as\nlowercase IUPAC characters: a c g t u m r w s y k x n . In the read\nsequences, however, ambiguities are uppercase: M R W S Y K X N\n\n=head2 Example\n\nExample of a contig containing three sequences:\n\n    sequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCGCAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    quality\t0x0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0505050505050505050E0505160505050505050505050505050505050505050505050505050505050303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0404040404040404041604040404040404040404040404040404040404040404040404040404040404040404040404040404040E0404040404040404040B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B\n    asmbl_id\t93\n    seq_id\t\n    com_name\t\n    type\t\n    method\tasmg\n    ed_status\t\n    redundancy\t1.11\n    perc_N\t0.20\n    seq#\t3\n    full_cds\t\n    cds_start\t\n    cds_end\t\n    ed_pn\tGRA\n    ed_date\t08/16/07 17:10:12\n    comment\t\n    frameshift\t\n\n    seq_name\tSDSU_RFPERU_010_C09.x01.phd.1\n    asm_lend\t1\n    asm_rend\t4423\n    seq_lend\t1\n    seq_rend\t442\n    best\t0\n    comment\t\n    db\t\n    offset\t0\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAGCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGG\n\n    seq_name\tSDSU_RFPERU_002_H12.x01.phd.1\n    asm_lend\t339\n    asm_rend\t940\n    seq_lend\t1\n    seq_rend\t602\n    best\t0\n    comment\t\n    db\t\n    offset\t338\n    lsequence\tCGAGATTCGCCACCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCCGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATA-GCGTGGCGC\n\n    seq_name\tSDSU_RFPERU_009_E07.x01.phd.1\n    asm_lend\t880\n    asm_rend\t1520\n    seq_lend\t641\n    seq_rend\t1\n    best\t0\n    comment\t\n    db\t\n    offset\t8803\n    lsequence\tCGCACGGTCTGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAAGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    |\n\n...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent dot angly at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::IO::tigr;\n\nuse strict;\nuse Bio::Seq::Quality;\nuse Bio::LocatableSeq;\nuse Bio::Assembly::IO;\nuse Bio::Assembly::Scaffold;\nuse Bio::Assembly::Contig;\nuse Bio::Assembly::Singlet;\n\nuse base qw(Bio::Assembly::IO);\n\nmy $progname = 'TIGR Assembler';\n\n=head2 next_assembly\n\n Title   : next_assembly\n Usage   : my $scaffold = $asmio->next_assembly()\n Function: return the next assembly in the tasm-formatted stream\n Returns : Bio::Assembly::Scaffold object\n Args    : none\n\n\nsub next_assembly {\n    my $self = shift; # object reference\n    \n    # Create a new scaffold to hold the contigs\n    my $scaffoldobj = Bio::Assembly::Scaffold->new(-source => $progname);\n    \n    # Contig and read related\n    my $contigobj;\n    my $iscontig = 1;\n    my %contiginfo;\n    my $isread = 0;\n    my %readinfo;\n    \n    # Loop over all assembly file lines\n    while ($_ = $self->_readline) {\n        chomp;\n        if ( /^\\|/ ) {  # a line with a single pipe |\n            # The end of a read from a contig, the start of a new contig\n            $iscontig = 1;\n            $isread   = 0;\n            # Store read info\n            if ($contiginfo{'seqnum'} > 1) {\n                # This is a read in a contig\n                my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n            } elsif ($contiginfo{'seqnum'} == 1) {\n                # This is a singlet\n                my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                    $scaffoldobj);\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n            # Clear read info\n            undef %readinfo;\n            # Clear contig info\n            undef $contigobj;\n            undef %contiginfo;\n        } elsif ( /^$/ ) {  # a blank line\n            if ($iscontig) {\n                # The end of a contig, the start of a read in that contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store contig info\n                $contigobj = $self->_store_contig( \\%contiginfo, $contigobj,\n                    $scaffoldobj ) if $contiginfo{'seqnum'} > 1;\n            } elsif ($isread) {\n                # The end of read in a contig, the start of a new one in\n                # the same contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store read info\n                if ($contiginfo{'seqnum'} > 1) {\n                    # This is a read in a contig\n                    my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n                } elsif ($contiginfo{'seqnum'} == 1) {\n                    # This is a singlet\n                    my $singletobj = $self->_store_singlet(\\%readinfo,\n                        \\%contiginfo, $scaffoldobj);\n                } else {\n                  # That should not happen\n                  $self->throw(\"Unhandled exception\");\n                }\n                # Clear read info\n                undef %readinfo;\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n        } else {\n            if ($iscontig) {\n                # Parse contig\n                if    (/^sequence\\t(.*)/)     {$contiginfo{'sequence'}   = $1; next}\n                elsif (/^lsequence\\t(.*)/)    {$contiginfo{'lsequence'}  = $1; next}\n                elsif (/^quality\\t(.*)/)      {$contiginfo{'quality'}    = $1; next}\n                elsif (/^asmbl_id\\t(.*)/)     {$contiginfo{'asmbl_id'}   = $1; next}\n                elsif (/^seq_id\\t(.*)/)       {$contiginfo{'seq_id'}     = $1; next}\n                elsif (/^com_name\\t(.*)/)     {$contiginfo{'com_name'}   = $1; next}\n                elsif (/^type\\t(.*)/)         {$contiginfo{'type'}       = $1; next}\n                elsif (/^method\\t(.*)/)       {$contiginfo{'method'}     = $1; next}\n                elsif (/^ed_status\\t(.*)/)    {$contiginfo{'ed_status'}  = $1; next}\n                elsif (/^redundancy\\t(.*)/)   {$contiginfo{'redundancy'} = $1; next}\n                elsif (/^perc_N\\t(.*)/)       {$contiginfo{'perc_N'}     = $1; next}\n                elsif (/^seq\\#\\t(.*)/)        {$contiginfo{'seqnum'}     = $1; next}\n                elsif (/^full_cds\\t(.*)/)     {$contiginfo{'full_cds'}   = $1; next}\n                elsif (/^cds_start\\t(.*)/)    {$contiginfo{'cds_start'}  = $1; next}\n                elsif (/^cds_end\\t(.*)/)      {$contiginfo{'cds_end'}    = $1; next}\n                elsif (/^ed_pn\\t(.*)/)        {$contiginfo{'ed_pn'}      = $1; next}\n                elsif (/^ed_date\\t(.*\\s.*)/)  {$contiginfo{'ed_date'}    = $1; next}\n                elsif (/^comment\\t(.*)/)      {$contiginfo{'comment'}    = $1; next}\n                elsif (/^frameshift\\t(.*)/)   {$contiginfo{'frameshift'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } elsif ($isread) {\n                # Parse read info\n                if    (/^seq_name\\t(.*)/)  {$readinfo{'seq_name'}  = $1; next}\n                elsif (/^asm_lend\\t(.*)/)  {$readinfo{'asm_lend'}  = $1; next}\n                elsif (/^asm_rend\\t(.*)/)  {$readinfo{'asm_rend'}  = $1; next}\n                elsif (/^seq_lend\\t(.*)/)  {$readinfo{'seq_lend'}  = $1; next}\n                elsif (/^seq_rend\\t(.*)/)  {$readinfo{'seq_rend'}  = $1; next}\n                elsif (/^best\\t(.*)/)      {$readinfo{'best'}      = $1; next}\n                elsif (/^comment\\t(.*)/)   {$readinfo{'comment'}   = $1; next}\n                elsif (/^db\\t(.*)/)        {$readinfo{'db'}        = $1; next}\n                elsif (/^offset\\t(.*)/)    {$readinfo{'offset'}    = $1; next}\n                elsif (/^lsequence\\t(.*)/) {$readinfo{'lsequence'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } else {\n                # That shouldn't happen\n                $self->throw(\"Unhandled exception\");                \n            }\n        }\n    }\n    # Store read info for last read\n    if (defined $contiginfo{'seqnum'}) {\n        if ($contiginfo{'seqnum'} > 1) {\n            # This is a read in a contig\n            my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n        } elsif ($contiginfo{'seqnum'} == 1) {\n            # This is a singlet\n            my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                $scaffoldobj);\n        } else {\n            # That should not happen\n            $self->throw(\"Unhandled exception\");\n        }\n    }\n    # Clear read info for last read\n    undef %readinfo;\n    # Clear contig info for last contig\n    undef $contigobj;\n    undef %contiginfo;\n    \n    $scaffoldobj->update_seq_list();\n    \n    return $scaffoldobj;\n}\n\n=head2 _qual_hex2dec\n\n    Title   : _qual_hex2dec\n    Usage   : my dec_quality = $self->_qual_hex2dec($hex_quality);\n    Function: convert an hexadecimal quality score into a decimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_hex2dec {\n    my ($self, $qual) = @_;\n    $qual =~ s/^0x(.*)$/$1/;\n    $qual =~ s/(..)/hex($1).' '/eg;\n    return $qual;\n}\n\n=head2 _qual_dec2hex\n\n    Title   : _qual_dec2hex\n    Usage   : my hex_quality = $self->_qual_dec2hex($dec_quality);\n    Function: convert a decimal quality score into an hexadecimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_dec2hex {\n    my ($self, $qual) = @_;\n    $qual =~ s/(\\d+)\\s*/sprintf('%02X', $1)/eg;\n    $qual = '0x'.$qual;\n    return $qual;\n}\n\n=head2 _store_contig\n\n    Title   : _store_contig\n    Usage   : my $contigobj; $contigobj = $self->_store_contig(\n              \\%contiginfo, $contigobj, $scaffoldobj);\n    Function: store information of a contig belonging to a scaffold in the\n              appropriate object\n    Returns : Bio::Assembly::Contig object\n    Args    : hash, Bio::Assembly::Contig, Bio::Assembly::Scaffold\n\n\nsub _store_contig {\n    my ($self, $contiginfo, $contigobj, $scaffoldobj) = @_;\n\n    # Create a contig and attach it to scaffold\n    $contigobj = Bio::Assembly::Contig->new(\n        -id     => $$contiginfo{'asmbl_id'},\n        -source => $progname,\n        -strand => 1\n    );\n    $scaffoldobj->add_contig($contigobj);\n\n    # Create a gapped consensus sequence and attach it to contig\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $consensus = Bio::LocatableSeq->new(\n        -id    => $$contiginfo{'asmbl_id'},\n        -seq   => $$contiginfo{'lsequence'},\n        -start => 1,\n    );\n    $contigobj->set_consensus_sequence($consensus);\n\n    # Create an gapped consensus quality score and attach it to contig\n    $$contiginfo{'quality'} = $self->_qual_hex2dec($$contiginfo{'quality'});\n    my $qual = Bio::Seq::Quality->new(\n        -id   => $$contiginfo{'asmbl_id'},\n        -qual => $$contiginfo{'quality'}\n    );\n    $contigobj->set_consensus_quality($qual);\n\n    # Add other misc contig information as features of the contig\n    my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$$contiginfo{'asmbl_id'}\",\n        -start       => 1,\n        -end         => $contigobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n    );\n    $contigobj->add_features([ $contigtags ], 1);\n\n    return $contigobj;\n}\n\n=head2 _store_read\n\n    Title   : _store_read\n    Usage   : my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n    Function: store information of a read belonging to a contig in the appropriate object\n    Returns : Bio::LocatableSeq\n    Args    : hash, Bio::Assembly::Contig\n\n\nsub _store_read {\n   my ($self, $readinfo, $contigobj) = @_;\n\n   # Create an aligned read object\n   #$$readinfo{'llength'} = length($$readinfo{'lsequence'});\n   $$readinfo{'strand'}  = ($$readinfo{'seq_rend'} > $$readinfo{'seq_lend'} ? 1 : -1);\n   my $readobj = Bio::LocatableSeq->new(\n       # the ids of sequence objects are supposed to include the db name in it, i.e. \"big_db|seq1234\"\n       # that's how sequence ids coming from the fasta parser are at least\n       -display_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -primary_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -seq        => $$readinfo{'lsequence'},      \n       -start      => 1,\n       -strand     => $$readinfo{'strand'},\n       -alphabet   => 'dna'\n   );\n\n   # Add read location and sequence to contig (in 'gapped consensus' coordinates)\n   $$readinfo{'aln_start'} = $$readinfo{'offset'} + 1; # seq offset is in gapped coordinates\n   $$readinfo{'aln_end'} = $$readinfo{'aln_start'} + length($$readinfo{'lsequence'}) - 1; # lsequence is aligned seq\n   my $alncoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => $readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigobj->id() }\n   );\n   $contigobj->set_seq_coord($alncoord, $readobj);\n\n   # Add quality clipping read information in contig features\n   # (from 'aligned read' to 'gapped consensus' coordinates)\n   $$readinfo{'clip_start'} = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_lend'});\n   $$readinfo{'clip_end'}   = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_rend'});\n   my $clipcoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_quality_clipping:'.$readobj->id,\n       -start       => $$readinfo{'clip_start'},\n       -end         => $$readinfo{'clip_end'},\n       -strand      => $$readinfo{'strand'}\n   );\n   $clipcoord->attach_seq($readobj);\n   $contigobj->add_features([ $clipcoord ], 0);\n   \n   # Add other misc read information as subsequence feature\n   my $readtags = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_main_read_feature:'.$readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'best'    => $$readinfo{'best'},\n                         'comment' => $$readinfo{'comment'} }\n   );\n   $alncoord->add_sub_SeqFeature($readtags);\n\n   return $readobj;\n}\n\n=head2 _store_singlet\n\n    Title   : _store_singlet\n    Usage   : my $singletobj = $self->_store_read(\\%readinfo, \\%contiginfo,\n                  $scaffoldobj);\n    Function: store information of a singlet belonging to a scaffold in the appropriate object\n    Returns : Bio::Assembly::Singlet\n    Args    : hash, hash, Bio::Assembly::Scaffold\n\n\nsub _store_singlet {\n    my ($self, $readinfo, $contiginfo, $scaffoldobj) = @_;\n    # Singlets in TIGR_Assembler are represented as a contig of one sequence\n    # We try to simulate this duality by playing around with the Singlet object\n    \n    my $contigid = $$contiginfo{'asmbl_id'};\n    my $readid   = $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'});\n    \n    # Create a sequence object\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $seqobj = Bio::Seq::Quality->new(\n       -primary_id => $contigid, # unique id in assembly (contig name)\n       -display_id => $readid,\n       -seq        => $$contiginfo{'lsequence'}, # do not use $$readinfo as ambiguities are uppercase\n       -start      => 1,\n       -strand     => $$readinfo{'strand'},\n       -alphabet   => 'dna',\n       -qual => $self->_qual_hex2dec($$contiginfo{'quality'})    \n   );\n\n   # Create singlet from sequence and add it to scaffold\n   my $singletobj = Bio::Assembly::Singlet->new( -seqref => $seqobj );\n   $scaffoldobj->add_singlet($singletobj);\n\n   # Add other misc contig information as features of the singlet\n   my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$contigid\",\n        -start       => 1,\n        -end         => $singletobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n   );\n   $singletobj->add_features([ $contigtags ], 1);\n\n   # Add read location and sequence to singlet features (in 'gapped consensus' coordinates)\n   $$readinfo{'aln_start'} = $$readinfo{'offset'} + 1; # seq offset is in gapped coordinates\n   $$readinfo{'aln_end'} = $$readinfo{'aln_start'} + length($$readinfo{'lsequence'}) - 1; # lsequence is aligned seq\n\n   my $alncoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_aligned_coord:$readid\",\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigid }\n   );\n   $alncoord->attach_seq($singletobj->seqref);\n   $singletobj->add_features([ $alncoord ], 0);\n\n   # Add quality clipping read information in singlet features\n   # (from 'aligned read' to 'gapped consensus' coordinates)\n   $$readinfo{'clip_start'} = $$readinfo{'seq_lend'};\n   $$readinfo{'clip_end'}   = $$readinfo{'seq_rend'};\n   my $clipcoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_quality_clipping:$readid\",\n       -start       => $$readinfo{'clip_start'},\n       -end         => $$readinfo{'clip_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigid }\n   );\n   $clipcoord->attach_seq($singletobj->seqref);\n   $singletobj->add_features([ $clipcoord ], 0);\n   \n   # Add other misc read information as subsequence feature\n   my $readtags = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_main_read_feature:$readid\",\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'best'    => $$readinfo{'best'},\n                         'comment' => $$readinfo{'comment'} }\n   );\n   $alncoord->add_sub_SeqFeature($readtags);\n      \n   return $singletobj;\n}\n\n=head2 write_assembly\n\n    Title   : write_assembly\n    Usage   : $ass_io->write_assembly($assembly)\n    Function: Write the assembly object in TIGR Assembler compatible tasm lassie  \n              format\n    Returns : 1 on success, 0 for error\n    Args    : A Bio::Assembly::Scaffold object\n\n\nsub write_assembly {\n    my ($self,@args) = @_;    \n    my ($scaffoldobj, $singlets) = $self->_rearrange([qw(SCAFFOLD SINGLETS)], @args);\n    \n    # Sanity check\n    if ( !$scaffoldobj || !$scaffoldobj->isa('Bio::Assembly::Scaffold') ) {\n        $self->warn(\"Must provide a Bio::Align::AlignI object when calling\n            write_assembly\");\n        next;\n    }\n\n    # Get list of objects - contigs and singlets\n    my @cont_ids = $scaffoldobj->get_contig_ids;\n    my @sing_ids = $scaffoldobj->get_singlet_ids;\n    my %did;\n    my $decimal_format = '%.2f';\n    for (my $i = 0; $i < scalar @sing_ids ; $i++) {\n      # singlet display id (string)\n      my $display_id = $sing_ids[$i];\n      # singlet primary id (unique, numerical)\n      my $primary_id = $scaffoldobj->get_singlet_by_id($display_id)->seqref->primary_id;\n      $sing_ids[$i] = $primary_id;\n      $did{$primary_id} = $display_id;\n    }\n    my @ids = (@cont_ids, @sing_ids);\n    @ids = sort { $a <=> $b } @ids; # list with contig ids and singlet primary id\n    my $numobj = scalar @ids;\n\n    # Output all contigs and singlets (sorted by increasing id number)\n    for (my $i = 0 ; $i < $numobj ; $i++) {\n        \n        my $objid = $ids[$i];\n        \n        if (defined $did{$objid}) { \n            # This is a singlet\n            next unless ($singlets);\n\n            my $contigid = $objid;\n            my $readid   = $did{$objid};            \n            my $singletobj = $scaffoldobj->get_singlet_by_id($readid);\n            \n            # Get contig information\n            my $contanno = (grep\n                { $_->primary_tag eq \"_main_contig_feature:$contigid\" }\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my %contiginfo;\n            $contiginfo{'sequence'}   = $singletobj->seqref->seq;\n            $contiginfo{'lsequence'}  = $contiginfo{'sequence'};\n            $contiginfo{'quality'}    = $self->_qual_dec2hex(\n                join ' ', @{$singletobj->seqref->qual});\n            $contiginfo{'asmbl_id'}   = $contigid;\n            $contiginfo{'seq_id'}     = ($contanno->get_tag_values('seq_id'))[0];   \n            $contiginfo{'com_name'}   = ($contanno->get_tag_values('com_name'))[0];\n            $contiginfo{'type'}       = ($contanno->get_tag_values('type'))[0];\n            $contiginfo{'method'}     = ($contanno->get_tag_values('method'))[0];\n            $contiginfo{'ed_status'}  = ($contanno->get_tag_values('ed_status'))[0];\n            $contiginfo{'redundancy'} = sprintf($decimal_format, 1);\n            $contiginfo{'perc_N'}     = sprintf(\n                $decimal_format, $self->_perc_N($contiginfo{'sequence'}));\n            $contiginfo{'seqnum'}     = 1;\n            $contiginfo{'full_cds'}   = ($contanno->get_tag_values('full_cds'))[0];\n            $contiginfo{'cds_start'}  = ($contanno->get_tag_values('cds_start'))[0];\n            $contiginfo{'cds_end'}    = ($contanno->get_tag_values('cds_end'))[0];\n            $contiginfo{'ed_pn'}      = ($contanno->get_tag_values('ed_pn'))[0];\n            $contiginfo{'ed_date'}    = $self->_date_time;\n            $contiginfo{'comment'}    = ($contanno->get_tag_values('comment'))[0];\n            $contiginfo{'frameshift'} = ($contanno->get_tag_values('frameshift'))[0];\n\n            # Check that no tag value is undef\n            $contiginfo{'seq_id'}     = '' unless defined $contiginfo{'seq_id'};\n            $contiginfo{'com_name'}   = '' unless defined $contiginfo{'com_name'};\n            $contiginfo{'type'}       = '' unless defined $contiginfo{'type'};\n            $contiginfo{'method'}     = '' unless defined $contiginfo{'method'};\n            $contiginfo{'ed_status'}  = '' unless defined $contiginfo{'ed_status'};\n            $contiginfo{'full_cds'}   = '' unless defined $contiginfo{'full_cds'};\n            $contiginfo{'cds_start'}  = '' unless defined $contiginfo{'cds_start'};\n            $contiginfo{'cds_end'}    = '' unless defined $contiginfo{'cds_end'};\n            $contiginfo{'ed_pn'}      = '' unless defined $contiginfo{'ed_pn'};\n            $contiginfo{'comment'}    = '' unless defined $contiginfo{'comment'};\n            $contiginfo{'frameshift'} = '' unless defined $contiginfo{'frameshift'};\n            \n            # Print contig information\n            $self->_print(\n                \"sequence\\t$contiginfo{'sequence'}\\n\".\n                \"lsequence\\t$contiginfo{'lsequence'}\\n\".\n                \"quality\\t$contiginfo{'quality'}\\n\".\n                \"asmbl_id\\t$contiginfo{'asmbl_id'}\\n\".\n                \"seq_id\\t$contiginfo{'seq_id'}\\n\".\n                \"com_name\\t$contiginfo{'com_name'}\\n\".\n                \"type\\t$contiginfo{'type'}\\n\".\n                \"method\\t$contiginfo{'method'}\\n\".\n                \"ed_status\\t$contiginfo{'ed_status'}\\n\".\n                \"redundancy\\t$contiginfo{'redundancy'}\\n\".\n                \"perc_N\\t$contiginfo{'perc_N'}\\n\".\n                \"seq#\\t$contiginfo{'seqnum'}\\n\".\n                \"full_cds\\t$contiginfo{'full_cds'}\\n\".\n                \"cds_start\\t$contiginfo{'cds_start'}\\n\".\n                \"cds_end\\t$contiginfo{'cds_end'}\\n\".\n                \"ed_pn\\t$contiginfo{'ed_pn'}\\n\".\n                \"ed_date\\t$contiginfo{'ed_date'}\\n\".\n                \"comment\\t$contiginfo{'comment'}\\n\".\n                \"frameshift\\t$contiginfo{'frameshift'}\\n\".\n                \"\\n\"\n            );\n                        \n            # Get read information\n            my ($seq_name, $db) = $self->_split_seq_name_and_db($readid);\n            my $clipcoord = (grep\n                { $_->primary_tag eq \"_quality_clipping:$readid\"}\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my $alncoord  = (grep\n                { $_->primary_tag eq \"_aligned_coord:$readid\"}\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my $readanno = (grep\n                { $_->primary_tag eq \"_main_read_feature:$readid\" }\n                $singletobj->get_seq_coord($singletobj->seqref)->get_SeqFeatures\n            )[0];\n            my %readinfo;\n            $readinfo{'seq_name'}  = $seq_name;\n            $readinfo{'asm_lend'}  = $alncoord->location->start;\n            $readinfo{'asm_rend'}  = $alncoord->location->end;\n            $readinfo{'seq_lend'}  = $clipcoord->location->start;\n            $readinfo{'seq_rend'}  = $clipcoord->location->end;\n            $readinfo{'best'}      = ($readanno->get_tag_values('best'))[0];\n            $readinfo{'comment'}   = ($readanno->get_tag_values('comment'))[0];\n            $readinfo{'db'}        = $db;         \n            $readinfo{'offset'}    = 0;\n            # ambiguities in read sequence are uppercase\n            $readinfo{'lsequence'} = uc($contiginfo{'lsequence'});\n            \n            # Check that no tag value is undef\n            $readinfo{'best'}    = '' unless defined $readinfo{'best'};\n            $readinfo{'comment'} = '' unless defined $readinfo{'comment'};\n\n            # Print read information\n            $self->_print(\n                \"seq_name\\t$readinfo{'seq_name'}\\n\".\n                \"asm_lend\\t$readinfo{'asm_lend'}\\n\".\n                \"asm_rend\\t$readinfo{'asm_rend'}\\n\".\n                \"seq_lend\\t$readinfo{'seq_lend'}\\n\".\n                \"seq_rend\\t$readinfo{'seq_rend'}\\n\".\n                \"best\\t$readinfo{'best'}\\n\".\n                \"comment\\t$readinfo{'comment'}\\n\".\n                \"db\\t$readinfo{'db'}\\n\".\n                \"offset\\t$readinfo{'offset'}\\n\".\n                \"lsequence\\t$readinfo{'lsequence'}\\n\"\n            );\n            if ($i+1 < $numobj) {\n                $self->_print(\"|\\n\");\n            }\n        } else {\n            # This is a contig\n            my $contigid = $objid;\n            my $contigobj = $scaffoldobj->get_contig_by_id($contigid);\n\n            # Skip contigs of 1 sequence (singlets) if needed\n            next if ($contigobj->num_sequences == 1) && (!$singlets);\n            \n            # Get contig information\n            my $contanno = (grep\n                { $_->primary_tag eq \"_main_contig_feature:$contigid\" }\n                $contigobj->get_features_collection->get_all_features\n            )[0];\n            my %contiginfo;\n            $contiginfo{'sequence'}   = $self->_ungap(\n                $contigobj->get_consensus_sequence->seq);\n            $contiginfo{'lsequence'}  = $contigobj->get_consensus_sequence->seq;\n            $contiginfo{'quality'}    = $self->_qual_dec2hex(\n                join ' ', @{$contigobj->get_consensus_quality->qual});\n            $contiginfo{'asmbl_id'}   = $contigid;\n            $contiginfo{'seq_id'}     = ($contanno->get_tag_values('seq_id'))[0];\n            $contiginfo{'com_name'}   = ($contanno->get_tag_values('com_name'))[0];\n            $contiginfo{'type'}       = ($contanno->get_tag_values('type'))[0];\n            $contiginfo{'method'}     = ($contanno->get_tag_values('method'))[0];\n            $contiginfo{'ed_status'}  = ($contanno->get_tag_values('ed_status'))[0];\n            $contiginfo{'redundancy'} = sprintf(\n                $decimal_format, $self->_redundancy($contigobj));\n            $contiginfo{'perc_N'}     = sprintf(\n                $decimal_format, $self->_perc_N($contiginfo{'sequence'}));\n            $contiginfo{'seqnum'}     = $contigobj->num_sequences;\n            $contiginfo{'full_cds'}   = ($contanno->get_tag_values('full_cds'))[0];\n            $contiginfo{'cds_start'}  = ($contanno->get_tag_values('cds_start'))[0];\n            $contiginfo{'cds_end'}    = ($contanno->get_tag_values('cds_end'))[0];\n            $contiginfo{'ed_pn'}      = ($contanno->get_tag_values('ed_pn'))[0];\n            $contiginfo{'ed_date'}    = $self->_date_time;\n            $contiginfo{'comment'}    = ($contanno->get_tag_values('comment'))[0];\n            $contiginfo{'frameshift'} = ($contanno->get_tag_values('frameshift'))[0];\n            \n            # Check that no tag value is undef\n            $contiginfo{'seq_id'}     = '' unless defined $contiginfo{'seq_id'};\n            $contiginfo{'com_name'}   = '' unless defined $contiginfo{'com_name'};\n            $contiginfo{'type'}       = '' unless defined $contiginfo{'type'};\n            $contiginfo{'method'}     = '' unless defined $contiginfo{'method'};\n            $contiginfo{'ed_status'}  = '' unless defined $contiginfo{'ed_status'};\n            $contiginfo{'full_cds'}   = '' unless defined $contiginfo{'full_cds'};\n            $contiginfo{'cds_start'}  = '' unless defined $contiginfo{'cds_start'};\n            $contiginfo{'cds_end'}    = '' unless defined $contiginfo{'cds_end'};\n            $contiginfo{'ed_pn'}      = '' unless defined $contiginfo{'ed_pn'};\n            $contiginfo{'comment'}    = '' unless defined $contiginfo{'comment'};\n            $contiginfo{'frameshift'} = '' unless defined $contiginfo{'frameshift'};\n                       \n            # Print contig information\n            $self->_print(\n                \"sequence\\t$contiginfo{'sequence'}\\n\".\n                \"lsequence\\t$contiginfo{'lsequence'}\\n\".\n                \"quality\\t$contiginfo{'quality'}\\n\".\n                \"asmbl_id\\t$contiginfo{'asmbl_id'}\\n\".\n                \"seq_id\\t$contiginfo{'seq_id'}\\n\".\n                \"com_name\\t$contiginfo{'com_name'}\\n\".\n                \"type\\t$contiginfo{'type'}\\n\".\n                \"method\\t$contiginfo{'method'}\\n\".\n                \"ed_status\\t$contiginfo{'ed_status'}\\n\".\n                \"redundancy\\t$contiginfo{'redundancy'}\\n\".\n                \"perc_N\\t$contiginfo{'perc_N'}\\n\".\n                \"seq#\\t$contiginfo{'seqnum'}\\n\".\n                \"full_cds\\t$contiginfo{'full_cds'}\\n\".\n                \"cds_start\\t$contiginfo{'cds_start'}\\n\".\n                \"cds_end\\t$contiginfo{'cds_end'}\\n\".\n                \"ed_pn\\t$contiginfo{'ed_pn'}\\n\".\n                \"ed_date\\t$contiginfo{'ed_date'}\\n\".\n                \"comment\\t$contiginfo{'comment'}\\n\".\n                \"frameshift\\t$contiginfo{'frameshift'}\\n\".\n                \"\\n\"\n            );\n            my $seqno = 0;\n            for my $readobj ( $contigobj->each_seq() ) {\n                $seqno++;\n                \n                # Get read information\n                my ($seq_name, $db) = $self->_split_seq_name_and_db($readobj->id);\n                my ($asm_lend, $asm_rend, $seq_lend, $seq_rend, $offset)\n                    = $self->_coord($readobj, $contigobj);\n                my $readanno = ( grep \n                    { $_->primary_tag eq '_main_read_feature:'.$readobj->primary_id }\n                    $contigobj->get_seq_coord($readobj)->get_SeqFeatures\n                )[0];\n                my %readinfo;                \n                $readinfo{'seq_name'}  = $seq_name;\n                $readinfo{'asm_lend'}  = $asm_lend;\n                $readinfo{'asm_rend'}  = $asm_rend;\n                $readinfo{'seq_lend'}  = $seq_lend;\n                $readinfo{'seq_rend'}  = $seq_rend;                \n                $readinfo{'best'}      = ($readanno->get_tag_values('best'))[0];\n                $readinfo{'comment'}   = ($readanno->get_tag_values('comment'))[0];\n                $readinfo{'db'}        = $db;\n                $readinfo{'offset'}    = $offset;   \n                $readinfo{'lsequence'} = $readobj->seq(); \n                         \n                # Check that no tag value is undef\n                $readinfo{'best'}    = '' unless defined $readinfo{'best'};\n                $readinfo{'comment'} = '' unless defined $readinfo{'comment'};\n    \n                # Print read information\n                $self->_print(\n                    \"seq_name\\t$readinfo{'seq_name'}\\n\".\n                    \"asm_lend\\t$readinfo{'asm_lend'}\\n\".\n                    \"asm_rend\\t$readinfo{'asm_rend'}\\n\".\n                    \"seq_lend\\t$readinfo{'seq_lend'}\\n\".\n                    \"seq_rend\\t$readinfo{'seq_rend'}\\n\".\n                    \"best\\t$readinfo{'best'}\\n\".\n                    \"comment\\t$readinfo{'comment'}\\n\".\n                    \"db\\t$readinfo{'db'}\\n\".\n                    \"offset\\t$readinfo{'offset'}\\n\".\n                    \"lsequence\\t$readinfo{'lsequence'}\\n\"\n                );\n                if ($seqno < $contiginfo{'seqnum'}) {\n                    $self->_print(\"\\n\");\n                } elsif (($seqno == $contiginfo{'seqnum'}) && ($i+1 < $numobj)) {\n                    $self->_print(\"|\\n\");\n                }\n            }\n        }\n    }\n    return 1;\n}\n\n=head2 _perc_N\n\n    Title   : _perc_N\n    Usage   : my $perc_N = $ass_io->_perc_N($sequence_string)\n    Function: Calculate the percent of ambiguities in a sequence.\n              M R W S Y K X N are regarded as ambiguites in an aligned read\n              sequence by TIGR Assembler. In the case of a gapped contig\n              consensus sequence, all lowercase symbols are ambiguities, i.e.:\n              a c g t u m r w s y k x n.\n    Returns : decimal number\n    Args    : string\n\n\nsub _perc_N {\n    my ($self, $seq_string) = @_;\n    $self->throw(\"Cannot accept an empty sequence\") if length($seq_string) == 0;\n    my $perc_N = 0;\n    for my $base ( split //, $seq_string ) {\n        # individual base matches an ambiguity?\n        if (( $base =~ m/[x|n|m|r|w|s|y|k]/i ) || ( $base =~ m/[a|c|g|t|u]/ ) ) {\n            $perc_N++;\n        }\n    }\n    $perc_N = $perc_N * 100 / length $seq_string;\n    return $perc_N;\n}\n\n=head2 _redundancy\n\n    Title   : _redundancy\n    Usage   : my $ref = $ass_io->_redundancy($contigobj)\n    Function: Calculate the fold coverage (redundancy) of a contig consensus\n              (average number of read base pairs covering the consensus)\n    Returns : decimal number\n    Args    : Bio::Assembly::Contig\n\n\nsub _redundancy {\n    # redundancy = (sum of all aligned read lengths - ( number of gaps in gapped\n    # consensus + number of gaps in aligned reads that are also in the consensus ) )\n    # / length of ungapped consensus\n    my ($self, $contigobj) = @_;\n    my $redundancy = 0;\n    \n    # sum of all aligned read lengths\n    my $read_tot = 0;\n    for my $readobj ( $contigobj->each_seq ) {\n        my $read_length = length($readobj->seq);\n        $read_tot += $read_length;\n    }\n    $redundancy += $read_tot;\n    \n    # - respected gaps\n    my $consensus_sequence = $contigobj->get_consensus_sequence->seq;\n    my @consensus_gaps = ();\n    $contigobj->_register_gaps($consensus_sequence, \\@consensus_gaps);\n    my $respected_gaps = scalar(@consensus_gaps);\n    if ($respected_gaps > 0) {\n        my @cons_arr = split //, $consensus_sequence;\n        for my $gap_pos_cons ( @consensus_gaps ) {\n            for my $readobj ( $contigobj->each_seq ) {\n                my $readid = $readobj->id;\n                my $read_start = $contigobj->change_coord(\n                    \"aligned $readid\", 'gapped consensus', $readobj->start);\n                my $read_end   = $contigobj->change_coord(\n                    \"aligned $readid\", 'gapped consensus', $readobj->end  );\n                # skip this if consensus gap position not within in the read boundaries\n                next if ( ($gap_pos_cons < $read_start)\n                    || ($gap_pos_cons > $read_end) );\n                # does the read position have read have a gap?\n                my @read_arr = split //, $readobj->seq;                \n                my $gap_pos_read = $contigobj->change_coord(\n                    'gapped consensus', \"aligned $readid\", $gap_pos_cons);\n                if ($read_arr[$gap_pos_read-1] eq $cons_arr[$gap_pos_cons-1]) {\n                    $respected_gaps++;\n                }\n            }\n        }\n    }\n    $redundancy -= $respected_gaps;\n    \n    # / length of ungapped consensus\n    my $contig_length = length($self->_ungap($contigobj->get_consensus_sequence->seq));\n    $redundancy /= $contig_length;\n    \n    return $redundancy;\n}\n\n=head2 _ungap\n\n    Title   : _ungap\n    Usage   : my $ungapped = $ass_io->_ungap($gapped)\n    Function: Remove the gaps from a sequence. Gaps are - in TIGR Assembler\n    Returns : string\n    Args    : string\n\n\nsub _ungap {\n    my ($self, $seq_string) = @_;\n    $seq_string =~ s/-//g;\n    return $seq_string;\n}\n\n=head2 _date_time\n\n    Title   : _date_time\n    Usage   : my $timepoint = $ass_io->date_time\n    Function: Get date and time (MM//DD/YY HH:MM:SS)\n    Returns : string\n    Args    : none\n\n\nsub _date_time {\n    my ($self) = @_;\n    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);\n    my $formatted_date_time = \n        sprintf('%02d', $mon+1).'/'.\n        sprintf('%02d', $mday).'/'.\n        sprintf('%02d', $year % 100).\n        ' '.\n        sprintf('%02d', $hour).':'.\n        sprintf('%02d', $min).':'.\n        sprintf('%02d',$sec)\n    ;\n    return $formatted_date_time;\n}\n\n=head2 _split_seq_name_and_db\n\n    Title   : _split_seq_name_and_db\n    Usage   : my ($seqname, $db) = $ass_io->_split_seq_name_and_db($id)\n    Function: Extract seq_name and db from sequence id\n    Returns : seq_name, db\n    Args    : id"},"detail":"($self,$id)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":1087,"containerName":"_split_seq_name_and_db","name":"$self","definition":"my","localvar":"my"},{"name":"$id","containerName":"_split_seq_name_and_db","kind":13,"line":1087},{"localvar":"my","containerName":"_split_seq_name_and_db","definition":"my","name":"$seq_name","line":1088,"kind":13},{"localvar":"my","containerName":"_split_seq_name_and_db","name":"$db","definition":"my","line":1089,"kind":13},{"name":"$id","containerName":"_split_seq_name_and_db","line":1090,"kind":13},{"containerName":"_split_seq_name_and_db","name":"$db","kind":13,"line":1091},{"containerName":"_split_seq_name_and_db","name":"$seq_name","kind":13,"line":1092},{"containerName":"_split_seq_name_and_db","name":"$seq_name","kind":13,"line":1094},{"line":1094,"kind":13,"name":"$id","containerName":"_split_seq_name_and_db"},{"name":"$seq_name","containerName":"_split_seq_name_and_db","kind":13,"line":1096},{"name":"$db","containerName":"_split_seq_name_and_db","kind":13,"line":1096}],"line":1086,"kind":12,"range":{"end":{"character":9999,"line":1097},"start":{"line":1086,"character":0}},"name":"_split_seq_name_and_db"},{"range":{"start":{"character":0,"line":1109},"end":{"character":9999,"line":1118}},"name":"_merge_seq_name_and_db","detail":"($self,$seq_name,$db)","signature":{"label":"_merge_seq_name_and_db($self,$seq_name,$db)","documentation":"__END__\n# $Id: tigr.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO::tigr\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO::tigr - Driver to read and write assembly files in the TIGR\nAssembler v2 default format.\n\n=head1 SYNOPSIS\n\n    # Building an input stream\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $asmio = Bio::Assembly::IO->new( -file   => 'SGC0-424.tasm',\n                                        -format => 'tigr' );\n    my $scaffold = $asmio->next_assembly;\n\n    # Do some things on contigs...\n\n    # Assembly writing methods\n    my $outasm = Bio::Assembly::IO->new( -file   => \">SGC0-modified.tasm\",\n                                         -format => 'tigr' );\n    $outasm->write_assembly( -scaffold => $assembly,\n                             -singlets => 1 );\n\n=head1 DESCRIPTION\n\nThis package loads and writes assembly information in/from files in the default\nTIGR Assembler v2 format. The files are lassie-formatted and often have the\n.tasm extension. This module was written to be used as a driver module for\nBio::Assembly::IO input/output.\n\n=head2 Implementation\n\nAssemblies are loaded into Bio::Assembly::Scaffold objects composed of\nBio::Assembly::Contig and Bio::Assembly::Singlet objects. Since aligned reads\nand contig gapped consensus can be obtained in the tasm files, only\naligned/gapped sequences are added to the different BioPerl objects.\n\nAdditional assembly information is stored as features. Contig objects have\nSeqFeature information associated with the primary_tag:\n\n    _main_contig_feature:$contig_id -> misc contig information\n    _quality_clipping:$read_id      -> quality clipping position\n\nRead objects have sub_seqFeature information associated with the\nprimary_tag:\n\n    _main_read_feature:$read_id     -> misc read information\n\nSinglets are considered by TIGR Assembler as contigs of one sequence and are\nrepresented here with features having these primary_tag: \n\n    _main_contig_feature:$contig_id\n    _quality_clipping:$read_primary_id\n    _main_read_feature:$read_primary_id\n    _aligned_coord:$read_primary_id\n\n=head1 THE TIGR TASM LASSIEFORMAT\n\n=head2 Description\n\nIn the TIGR tasm lassie format, contigs are separated by a line containing a single\npipe character \"|\", whereas the reads in a contig are separated by a blank line.\nSinglets can be present in the file and are represented as a contig\ncomposed of a single sequence.\n\nOther than the two above-mentioned separators, each line has an attribute name,\nfollowed a tab and then an attribute value.\n\nThe tasm format is used by more TIGR applications than just TIGR Assembler.\nSome of the attributes are not used by TIGR Assembler or have constant values.\nThey are indicated by an asterisk *\n\nContigs have the following attributes:\n\n    asmbl_id   -> contig ID\n    sequence   -> contig ungapped consensus sequence (ambiguities are lowercase)\n    lsequence  -> gapped consensus sequence (lowercase ambiguities)\n    quality    -> gapped consensus quality score (in hexadecimal)\n    seq_id     -> *\n    com_name   -> *\n    type       -> *\n    method     -> always 'asmg' *\n    ed_status  -> *\n    redundancy -> fold coverage of the contig consensus\n    perc_N     -> percent of ambiguities in the contig consensus\n    seq#       -> number of sequences in the contig\n    full_cds   -> *\n    cds_start  -> start of coding sequence *\n    cds_end    -> end of coding sequence *\n    ed_pn      -> name of editor (always 'GRA') *\n    ed_date    -> date and time of edition\n    comment    -> some comments *\n    frameshift -> *\n\nEach read has the following attributes:\n\n    seq_name  -> read name\n    asm_lend  -> position of first base on contig ungapped consensus sequence\n    asm_rend  -> position of last base on contig ungapped consensus sequence\n    seq_lend  -> start of quality-trimmed sequence (aligned read coordinates)\n    seq_rend  -> end of quality-trimmed sequence (aligned read coordinates)\n    best      -> always '0' *\n    comment   -> some comments *\n    db        -> database name associated with the sequence (e.g. >my_db|seq1234)\n    offset    -> offset of the sequence (gapped consensus coordinates)\n    lsequence -> aligned read sequence (ambiguities are uppercase)\n\nWhen asm_rend E<lt> asm_lend, the sequence was on the complementary DNA strand but\nits reverse complement is shown in the aligned sequence of the assembly file,\nnot the original read.\n\nAmbiguities are reflected in the contig consensus sequence as\nlowercase IUPAC characters: a c g t u m r w s y k x n . In the read\nsequences, however, ambiguities are uppercase: M R W S Y K X N\n\n=head2 Example\n\nExample of a contig containing three sequences:\n\n    sequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCGCAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    quality\t0x0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0505050505050505050E0505160505050505050505050505050505050505050505050505050505050303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0404040404040404041604040404040404040404040404040404040404040404040404040404040404040404040404040404040E0404040404040404040B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B\n    asmbl_id\t93\n    seq_id\t\n    com_name\t\n    type\t\n    method\tasmg\n    ed_status\t\n    redundancy\t1.11\n    perc_N\t0.20\n    seq#\t3\n    full_cds\t\n    cds_start\t\n    cds_end\t\n    ed_pn\tGRA\n    ed_date\t08/16/07 17:10:12\n    comment\t\n    frameshift\t\n\n    seq_name\tSDSU_RFPERU_010_C09.x01.phd.1\n    asm_lend\t1\n    asm_rend\t4423\n    seq_lend\t1\n    seq_rend\t442\n    best\t0\n    comment\t\n    db\t\n    offset\t0\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAGCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGG\n\n    seq_name\tSDSU_RFPERU_002_H12.x01.phd.1\n    asm_lend\t339\n    asm_rend\t940\n    seq_lend\t1\n    seq_rend\t602\n    best\t0\n    comment\t\n    db\t\n    offset\t338\n    lsequence\tCGAGATTCGCCACCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCCGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATA-GCGTGGCGC\n\n    seq_name\tSDSU_RFPERU_009_E07.x01.phd.1\n    asm_lend\t880\n    asm_rend\t1520\n    seq_lend\t641\n    seq_rend\t1\n    best\t0\n    comment\t\n    db\t\n    offset\t8803\n    lsequence\tCGCACGGTCTGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAAGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    |\n\n...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent dot angly at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::IO::tigr;\n\nuse strict;\nuse Bio::Seq::Quality;\nuse Bio::LocatableSeq;\nuse Bio::Assembly::IO;\nuse Bio::Assembly::Scaffold;\nuse Bio::Assembly::Contig;\nuse Bio::Assembly::Singlet;\n\nuse base qw(Bio::Assembly::IO);\n\nmy $progname = 'TIGR Assembler';\n\n=head2 next_assembly\n\n Title   : next_assembly\n Usage   : my $scaffold = $asmio->next_assembly()\n Function: return the next assembly in the tasm-formatted stream\n Returns : Bio::Assembly::Scaffold object\n Args    : none\n\n\nsub next_assembly {\n    my $self = shift; # object reference\n    \n    # Create a new scaffold to hold the contigs\n    my $scaffoldobj = Bio::Assembly::Scaffold->new(-source => $progname);\n    \n    # Contig and read related\n    my $contigobj;\n    my $iscontig = 1;\n    my %contiginfo;\n    my $isread = 0;\n    my %readinfo;\n    \n    # Loop over all assembly file lines\n    while ($_ = $self->_readline) {\n        chomp;\n        if ( /^\\|/ ) {  # a line with a single pipe |\n            # The end of a read from a contig, the start of a new contig\n            $iscontig = 1;\n            $isread   = 0;\n            # Store read info\n            if ($contiginfo{'seqnum'} > 1) {\n                # This is a read in a contig\n                my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n            } elsif ($contiginfo{'seqnum'} == 1) {\n                # This is a singlet\n                my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                    $scaffoldobj);\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n            # Clear read info\n            undef %readinfo;\n            # Clear contig info\n            undef $contigobj;\n            undef %contiginfo;\n        } elsif ( /^$/ ) {  # a blank line\n            if ($iscontig) {\n                # The end of a contig, the start of a read in that contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store contig info\n                $contigobj = $self->_store_contig( \\%contiginfo, $contigobj,\n                    $scaffoldobj ) if $contiginfo{'seqnum'} > 1;\n            } elsif ($isread) {\n                # The end of read in a contig, the start of a new one in\n                # the same contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store read info\n                if ($contiginfo{'seqnum'} > 1) {\n                    # This is a read in a contig\n                    my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n                } elsif ($contiginfo{'seqnum'} == 1) {\n                    # This is a singlet\n                    my $singletobj = $self->_store_singlet(\\%readinfo,\n                        \\%contiginfo, $scaffoldobj);\n                } else {\n                  # That should not happen\n                  $self->throw(\"Unhandled exception\");\n                }\n                # Clear read info\n                undef %readinfo;\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n        } else {\n            if ($iscontig) {\n                # Parse contig\n                if    (/^sequence\\t(.*)/)     {$contiginfo{'sequence'}   = $1; next}\n                elsif (/^lsequence\\t(.*)/)    {$contiginfo{'lsequence'}  = $1; next}\n                elsif (/^quality\\t(.*)/)      {$contiginfo{'quality'}    = $1; next}\n                elsif (/^asmbl_id\\t(.*)/)     {$contiginfo{'asmbl_id'}   = $1; next}\n                elsif (/^seq_id\\t(.*)/)       {$contiginfo{'seq_id'}     = $1; next}\n                elsif (/^com_name\\t(.*)/)     {$contiginfo{'com_name'}   = $1; next}\n                elsif (/^type\\t(.*)/)         {$contiginfo{'type'}       = $1; next}\n                elsif (/^method\\t(.*)/)       {$contiginfo{'method'}     = $1; next}\n                elsif (/^ed_status\\t(.*)/)    {$contiginfo{'ed_status'}  = $1; next}\n                elsif (/^redundancy\\t(.*)/)   {$contiginfo{'redundancy'} = $1; next}\n                elsif (/^perc_N\\t(.*)/)       {$contiginfo{'perc_N'}     = $1; next}\n                elsif (/^seq\\#\\t(.*)/)        {$contiginfo{'seqnum'}     = $1; next}\n                elsif (/^full_cds\\t(.*)/)     {$contiginfo{'full_cds'}   = $1; next}\n                elsif (/^cds_start\\t(.*)/)    {$contiginfo{'cds_start'}  = $1; next}\n                elsif (/^cds_end\\t(.*)/)      {$contiginfo{'cds_end'}    = $1; next}\n                elsif (/^ed_pn\\t(.*)/)        {$contiginfo{'ed_pn'}      = $1; next}\n                elsif (/^ed_date\\t(.*\\s.*)/)  {$contiginfo{'ed_date'}    = $1; next}\n                elsif (/^comment\\t(.*)/)      {$contiginfo{'comment'}    = $1; next}\n                elsif (/^frameshift\\t(.*)/)   {$contiginfo{'frameshift'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } elsif ($isread) {\n                # Parse read info\n                if    (/^seq_name\\t(.*)/)  {$readinfo{'seq_name'}  = $1; next}\n                elsif (/^asm_lend\\t(.*)/)  {$readinfo{'asm_lend'}  = $1; next}\n                elsif (/^asm_rend\\t(.*)/)  {$readinfo{'asm_rend'}  = $1; next}\n                elsif (/^seq_lend\\t(.*)/)  {$readinfo{'seq_lend'}  = $1; next}\n                elsif (/^seq_rend\\t(.*)/)  {$readinfo{'seq_rend'}  = $1; next}\n                elsif (/^best\\t(.*)/)      {$readinfo{'best'}      = $1; next}\n                elsif (/^comment\\t(.*)/)   {$readinfo{'comment'}   = $1; next}\n                elsif (/^db\\t(.*)/)        {$readinfo{'db'}        = $1; next}\n                elsif (/^offset\\t(.*)/)    {$readinfo{'offset'}    = $1; next}\n                elsif (/^lsequence\\t(.*)/) {$readinfo{'lsequence'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } else {\n                # That shouldn't happen\n                $self->throw(\"Unhandled exception\");                \n            }\n        }\n    }\n    # Store read info for last read\n    if (defined $contiginfo{'seqnum'}) {\n        if ($contiginfo{'seqnum'} > 1) {\n            # This is a read in a contig\n            my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n        } elsif ($contiginfo{'seqnum'} == 1) {\n            # This is a singlet\n            my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                $scaffoldobj);\n        } else {\n            # That should not happen\n            $self->throw(\"Unhandled exception\");\n        }\n    }\n    # Clear read info for last read\n    undef %readinfo;\n    # Clear contig info for last contig\n    undef $contigobj;\n    undef %contiginfo;\n    \n    $scaffoldobj->update_seq_list();\n    \n    return $scaffoldobj;\n}\n\n=head2 _qual_hex2dec\n\n    Title   : _qual_hex2dec\n    Usage   : my dec_quality = $self->_qual_hex2dec($hex_quality);\n    Function: convert an hexadecimal quality score into a decimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_hex2dec {\n    my ($self, $qual) = @_;\n    $qual =~ s/^0x(.*)$/$1/;\n    $qual =~ s/(..)/hex($1).' '/eg;\n    return $qual;\n}\n\n=head2 _qual_dec2hex\n\n    Title   : _qual_dec2hex\n    Usage   : my hex_quality = $self->_qual_dec2hex($dec_quality);\n    Function: convert a decimal quality score into an hexadecimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_dec2hex {\n    my ($self, $qual) = @_;\n    $qual =~ s/(\\d+)\\s*/sprintf('%02X', $1)/eg;\n    $qual = '0x'.$qual;\n    return $qual;\n}\n\n=head2 _store_contig\n\n    Title   : _store_contig\n    Usage   : my $contigobj; $contigobj = $self->_store_contig(\n              \\%contiginfo, $contigobj, $scaffoldobj);\n    Function: store information of a contig belonging to a scaffold in the\n              appropriate object\n    Returns : Bio::Assembly::Contig object\n    Args    : hash, Bio::Assembly::Contig, Bio::Assembly::Scaffold\n\n\nsub _store_contig {\n    my ($self, $contiginfo, $contigobj, $scaffoldobj) = @_;\n\n    # Create a contig and attach it to scaffold\n    $contigobj = Bio::Assembly::Contig->new(\n        -id     => $$contiginfo{'asmbl_id'},\n        -source => $progname,\n        -strand => 1\n    );\n    $scaffoldobj->add_contig($contigobj);\n\n    # Create a gapped consensus sequence and attach it to contig\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $consensus = Bio::LocatableSeq->new(\n        -id    => $$contiginfo{'asmbl_id'},\n        -seq   => $$contiginfo{'lsequence'},\n        -start => 1,\n    );\n    $contigobj->set_consensus_sequence($consensus);\n\n    # Create an gapped consensus quality score and attach it to contig\n    $$contiginfo{'quality'} = $self->_qual_hex2dec($$contiginfo{'quality'});\n    my $qual = Bio::Seq::Quality->new(\n        -id   => $$contiginfo{'asmbl_id'},\n        -qual => $$contiginfo{'quality'}\n    );\n    $contigobj->set_consensus_quality($qual);\n\n    # Add other misc contig information as features of the contig\n    my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$$contiginfo{'asmbl_id'}\",\n        -start       => 1,\n        -end         => $contigobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n    );\n    $contigobj->add_features([ $contigtags ], 1);\n\n    return $contigobj;\n}\n\n=head2 _store_read\n\n    Title   : _store_read\n    Usage   : my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n    Function: store information of a read belonging to a contig in the appropriate object\n    Returns : Bio::LocatableSeq\n    Args    : hash, Bio::Assembly::Contig\n\n\nsub _store_read {\n   my ($self, $readinfo, $contigobj) = @_;\n\n   # Create an aligned read object\n   #$$readinfo{'llength'} = length($$readinfo{'lsequence'});\n   $$readinfo{'strand'}  = ($$readinfo{'seq_rend'} > $$readinfo{'seq_lend'} ? 1 : -1);\n   my $readobj = Bio::LocatableSeq->new(\n       # the ids of sequence objects are supposed to include the db name in it, i.e. \"big_db|seq1234\"\n       # that's how sequence ids coming from the fasta parser are at least\n       -display_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -primary_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -seq        => $$readinfo{'lsequence'},      \n       -start      => 1,\n       -strand     => $$readinfo{'strand'},\n       -alphabet   => 'dna'\n   );\n\n   # Add read location and sequence to contig (in 'gapped consensus' coordinates)\n   $$readinfo{'aln_start'} = $$readinfo{'offset'} + 1; # seq offset is in gapped coordinates\n   $$readinfo{'aln_end'} = $$readinfo{'aln_start'} + length($$readinfo{'lsequence'}) - 1; # lsequence is aligned seq\n   my $alncoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => $readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigobj->id() }\n   );\n   $contigobj->set_seq_coord($alncoord, $readobj);\n\n   # Add quality clipping read information in contig features\n   # (from 'aligned read' to 'gapped consensus' coordinates)\n   $$readinfo{'clip_start'} = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_lend'});\n   $$readinfo{'clip_end'}   = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_rend'});\n   my $clipcoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_quality_clipping:'.$readobj->id,\n       -start       => $$readinfo{'clip_start'},\n       -end         => $$readinfo{'clip_end'},\n       -strand      => $$readinfo{'strand'}\n   );\n   $clipcoord->attach_seq($readobj);\n   $contigobj->add_features([ $clipcoord ], 0);\n   \n   # Add other misc read information as subsequence feature\n   my $readtags = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_main_read_feature:'.$readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'best'    => $$readinfo{'best'},\n                         'comment' => $$readinfo{'comment'} }\n   );\n   $alncoord->add_sub_SeqFeature($readtags);\n\n   return $readobj;\n}\n\n=head2 _store_singlet\n\n    Title   : _store_singlet\n    Usage   : my $singletobj = $self->_store_read(\\%readinfo, \\%contiginfo,\n                  $scaffoldobj);\n    Function: store information of a singlet belonging to a scaffold in the appropriate object\n    Returns : Bio::Assembly::Singlet\n    Args    : hash, hash, Bio::Assembly::Scaffold\n\n\nsub _store_singlet {\n    my ($self, $readinfo, $contiginfo, $scaffoldobj) = @_;\n    # Singlets in TIGR_Assembler are represented as a contig of one sequence\n    # We try to simulate this duality by playing around with the Singlet object\n    \n    my $contigid = $$contiginfo{'asmbl_id'};\n    my $readid   = $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'});\n    \n    # Create a sequence object\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $seqobj = Bio::Seq::Quality->new(\n       -primary_id => $contigid, # unique id in assembly (contig name)\n       -display_id => $readid,\n       -seq        => $$contiginfo{'lsequence'}, # do not use $$readinfo as ambiguities are uppercase\n       -start      => 1,\n       -strand     => $$readinfo{'strand'},\n       -alphabet   => 'dna',\n       -qual => $self->_qual_hex2dec($$contiginfo{'quality'})    \n   );\n\n   # Create singlet from sequence and add it to scaffold\n   my $singletobj = Bio::Assembly::Singlet->new( -seqref => $seqobj );\n   $scaffoldobj->add_singlet($singletobj);\n\n   # Add other misc contig information as features of the singlet\n   my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$contigid\",\n        -start       => 1,\n        -end         => $singletobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n   );\n   $singletobj->add_features([ $contigtags ], 1);\n\n   # Add read location and sequence to singlet features (in 'gapped consensus' coordinates)\n   $$readinfo{'aln_start'} = $$readinfo{'offset'} + 1; # seq offset is in gapped coordinates\n   $$readinfo{'aln_end'} = $$readinfo{'aln_start'} + length($$readinfo{'lsequence'}) - 1; # lsequence is aligned seq\n\n   my $alncoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_aligned_coord:$readid\",\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigid }\n   );\n   $alncoord->attach_seq($singletobj->seqref);\n   $singletobj->add_features([ $alncoord ], 0);\n\n   # Add quality clipping read information in singlet features\n   # (from 'aligned read' to 'gapped consensus' coordinates)\n   $$readinfo{'clip_start'} = $$readinfo{'seq_lend'};\n   $$readinfo{'clip_end'}   = $$readinfo{'seq_rend'};\n   my $clipcoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_quality_clipping:$readid\",\n       -start       => $$readinfo{'clip_start'},\n       -end         => $$readinfo{'clip_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigid }\n   );\n   $clipcoord->attach_seq($singletobj->seqref);\n   $singletobj->add_features([ $clipcoord ], 0);\n   \n   # Add other misc read information as subsequence feature\n   my $readtags = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_main_read_feature:$readid\",\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'best'    => $$readinfo{'best'},\n                         'comment' => $$readinfo{'comment'} }\n   );\n   $alncoord->add_sub_SeqFeature($readtags);\n      \n   return $singletobj;\n}\n\n=head2 write_assembly\n\n    Title   : write_assembly\n    Usage   : $ass_io->write_assembly($assembly)\n    Function: Write the assembly object in TIGR Assembler compatible tasm lassie  \n              format\n    Returns : 1 on success, 0 for error\n    Args    : A Bio::Assembly::Scaffold object\n\n\nsub write_assembly {\n    my ($self,@args) = @_;    \n    my ($scaffoldobj, $singlets) = $self->_rearrange([qw(SCAFFOLD SINGLETS)], @args);\n    \n    # Sanity check\n    if ( !$scaffoldobj || !$scaffoldobj->isa('Bio::Assembly::Scaffold') ) {\n        $self->warn(\"Must provide a Bio::Align::AlignI object when calling\n            write_assembly\");\n        next;\n    }\n\n    # Get list of objects - contigs and singlets\n    my @cont_ids = $scaffoldobj->get_contig_ids;\n    my @sing_ids = $scaffoldobj->get_singlet_ids;\n    my %did;\n    my $decimal_format = '%.2f';\n    for (my $i = 0; $i < scalar @sing_ids ; $i++) {\n      # singlet display id (string)\n      my $display_id = $sing_ids[$i];\n      # singlet primary id (unique, numerical)\n      my $primary_id = $scaffoldobj->get_singlet_by_id($display_id)->seqref->primary_id;\n      $sing_ids[$i] = $primary_id;\n      $did{$primary_id} = $display_id;\n    }\n    my @ids = (@cont_ids, @sing_ids);\n    @ids = sort { $a <=> $b } @ids; # list with contig ids and singlet primary id\n    my $numobj = scalar @ids;\n\n    # Output all contigs and singlets (sorted by increasing id number)\n    for (my $i = 0 ; $i < $numobj ; $i++) {\n        \n        my $objid = $ids[$i];\n        \n        if (defined $did{$objid}) { \n            # This is a singlet\n            next unless ($singlets);\n\n            my $contigid = $objid;\n            my $readid   = $did{$objid};            \n            my $singletobj = $scaffoldobj->get_singlet_by_id($readid);\n            \n            # Get contig information\n            my $contanno = (grep\n                { $_->primary_tag eq \"_main_contig_feature:$contigid\" }\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my %contiginfo;\n            $contiginfo{'sequence'}   = $singletobj->seqref->seq;\n            $contiginfo{'lsequence'}  = $contiginfo{'sequence'};\n            $contiginfo{'quality'}    = $self->_qual_dec2hex(\n                join ' ', @{$singletobj->seqref->qual});\n            $contiginfo{'asmbl_id'}   = $contigid;\n            $contiginfo{'seq_id'}     = ($contanno->get_tag_values('seq_id'))[0];   \n            $contiginfo{'com_name'}   = ($contanno->get_tag_values('com_name'))[0];\n            $contiginfo{'type'}       = ($contanno->get_tag_values('type'))[0];\n            $contiginfo{'method'}     = ($contanno->get_tag_values('method'))[0];\n            $contiginfo{'ed_status'}  = ($contanno->get_tag_values('ed_status'))[0];\n            $contiginfo{'redundancy'} = sprintf($decimal_format, 1);\n            $contiginfo{'perc_N'}     = sprintf(\n                $decimal_format, $self->_perc_N($contiginfo{'sequence'}));\n            $contiginfo{'seqnum'}     = 1;\n            $contiginfo{'full_cds'}   = ($contanno->get_tag_values('full_cds'))[0];\n            $contiginfo{'cds_start'}  = ($contanno->get_tag_values('cds_start'))[0];\n            $contiginfo{'cds_end'}    = ($contanno->get_tag_values('cds_end'))[0];\n            $contiginfo{'ed_pn'}      = ($contanno->get_tag_values('ed_pn'))[0];\n            $contiginfo{'ed_date'}    = $self->_date_time;\n            $contiginfo{'comment'}    = ($contanno->get_tag_values('comment'))[0];\n            $contiginfo{'frameshift'} = ($contanno->get_tag_values('frameshift'))[0];\n\n            # Check that no tag value is undef\n            $contiginfo{'seq_id'}     = '' unless defined $contiginfo{'seq_id'};\n            $contiginfo{'com_name'}   = '' unless defined $contiginfo{'com_name'};\n            $contiginfo{'type'}       = '' unless defined $contiginfo{'type'};\n            $contiginfo{'method'}     = '' unless defined $contiginfo{'method'};\n            $contiginfo{'ed_status'}  = '' unless defined $contiginfo{'ed_status'};\n            $contiginfo{'full_cds'}   = '' unless defined $contiginfo{'full_cds'};\n            $contiginfo{'cds_start'}  = '' unless defined $contiginfo{'cds_start'};\n            $contiginfo{'cds_end'}    = '' unless defined $contiginfo{'cds_end'};\n            $contiginfo{'ed_pn'}      = '' unless defined $contiginfo{'ed_pn'};\n            $contiginfo{'comment'}    = '' unless defined $contiginfo{'comment'};\n            $contiginfo{'frameshift'} = '' unless defined $contiginfo{'frameshift'};\n            \n            # Print contig information\n            $self->_print(\n                \"sequence\\t$contiginfo{'sequence'}\\n\".\n                \"lsequence\\t$contiginfo{'lsequence'}\\n\".\n                \"quality\\t$contiginfo{'quality'}\\n\".\n                \"asmbl_id\\t$contiginfo{'asmbl_id'}\\n\".\n                \"seq_id\\t$contiginfo{'seq_id'}\\n\".\n                \"com_name\\t$contiginfo{'com_name'}\\n\".\n                \"type\\t$contiginfo{'type'}\\n\".\n                \"method\\t$contiginfo{'method'}\\n\".\n                \"ed_status\\t$contiginfo{'ed_status'}\\n\".\n                \"redundancy\\t$contiginfo{'redundancy'}\\n\".\n                \"perc_N\\t$contiginfo{'perc_N'}\\n\".\n                \"seq#\\t$contiginfo{'seqnum'}\\n\".\n                \"full_cds\\t$contiginfo{'full_cds'}\\n\".\n                \"cds_start\\t$contiginfo{'cds_start'}\\n\".\n                \"cds_end\\t$contiginfo{'cds_end'}\\n\".\n                \"ed_pn\\t$contiginfo{'ed_pn'}\\n\".\n                \"ed_date\\t$contiginfo{'ed_date'}\\n\".\n                \"comment\\t$contiginfo{'comment'}\\n\".\n                \"frameshift\\t$contiginfo{'frameshift'}\\n\".\n                \"\\n\"\n            );\n                        \n            # Get read information\n            my ($seq_name, $db) = $self->_split_seq_name_and_db($readid);\n            my $clipcoord = (grep\n                { $_->primary_tag eq \"_quality_clipping:$readid\"}\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my $alncoord  = (grep\n                { $_->primary_tag eq \"_aligned_coord:$readid\"}\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my $readanno = (grep\n                { $_->primary_tag eq \"_main_read_feature:$readid\" }\n                $singletobj->get_seq_coord($singletobj->seqref)->get_SeqFeatures\n            )[0];\n            my %readinfo;\n            $readinfo{'seq_name'}  = $seq_name;\n            $readinfo{'asm_lend'}  = $alncoord->location->start;\n            $readinfo{'asm_rend'}  = $alncoord->location->end;\n            $readinfo{'seq_lend'}  = $clipcoord->location->start;\n            $readinfo{'seq_rend'}  = $clipcoord->location->end;\n            $readinfo{'best'}      = ($readanno->get_tag_values('best'))[0];\n            $readinfo{'comment'}   = ($readanno->get_tag_values('comment'))[0];\n            $readinfo{'db'}        = $db;         \n            $readinfo{'offset'}    = 0;\n            # ambiguities in read sequence are uppercase\n            $readinfo{'lsequence'} = uc($contiginfo{'lsequence'});\n            \n            # Check that no tag value is undef\n            $readinfo{'best'}    = '' unless defined $readinfo{'best'};\n            $readinfo{'comment'} = '' unless defined $readinfo{'comment'};\n\n            # Print read information\n            $self->_print(\n                \"seq_name\\t$readinfo{'seq_name'}\\n\".\n                \"asm_lend\\t$readinfo{'asm_lend'}\\n\".\n                \"asm_rend\\t$readinfo{'asm_rend'}\\n\".\n                \"seq_lend\\t$readinfo{'seq_lend'}\\n\".\n                \"seq_rend\\t$readinfo{'seq_rend'}\\n\".\n                \"best\\t$readinfo{'best'}\\n\".\n                \"comment\\t$readinfo{'comment'}\\n\".\n                \"db\\t$readinfo{'db'}\\n\".\n                \"offset\\t$readinfo{'offset'}\\n\".\n                \"lsequence\\t$readinfo{'lsequence'}\\n\"\n            );\n            if ($i+1 < $numobj) {\n                $self->_print(\"|\\n\");\n            }\n        } else {\n            # This is a contig\n            my $contigid = $objid;\n            my $contigobj = $scaffoldobj->get_contig_by_id($contigid);\n\n            # Skip contigs of 1 sequence (singlets) if needed\n            next if ($contigobj->num_sequences == 1) && (!$singlets);\n            \n            # Get contig information\n            my $contanno = (grep\n                { $_->primary_tag eq \"_main_contig_feature:$contigid\" }\n                $contigobj->get_features_collection->get_all_features\n            )[0];\n            my %contiginfo;\n            $contiginfo{'sequence'}   = $self->_ungap(\n                $contigobj->get_consensus_sequence->seq);\n            $contiginfo{'lsequence'}  = $contigobj->get_consensus_sequence->seq;\n            $contiginfo{'quality'}    = $self->_qual_dec2hex(\n                join ' ', @{$contigobj->get_consensus_quality->qual});\n            $contiginfo{'asmbl_id'}   = $contigid;\n            $contiginfo{'seq_id'}     = ($contanno->get_tag_values('seq_id'))[0];\n            $contiginfo{'com_name'}   = ($contanno->get_tag_values('com_name'))[0];\n            $contiginfo{'type'}       = ($contanno->get_tag_values('type'))[0];\n            $contiginfo{'method'}     = ($contanno->get_tag_values('method'))[0];\n            $contiginfo{'ed_status'}  = ($contanno->get_tag_values('ed_status'))[0];\n            $contiginfo{'redundancy'} = sprintf(\n                $decimal_format, $self->_redundancy($contigobj));\n            $contiginfo{'perc_N'}     = sprintf(\n                $decimal_format, $self->_perc_N($contiginfo{'sequence'}));\n            $contiginfo{'seqnum'}     = $contigobj->num_sequences;\n            $contiginfo{'full_cds'}   = ($contanno->get_tag_values('full_cds'))[0];\n            $contiginfo{'cds_start'}  = ($contanno->get_tag_values('cds_start'))[0];\n            $contiginfo{'cds_end'}    = ($contanno->get_tag_values('cds_end'))[0];\n            $contiginfo{'ed_pn'}      = ($contanno->get_tag_values('ed_pn'))[0];\n            $contiginfo{'ed_date'}    = $self->_date_time;\n            $contiginfo{'comment'}    = ($contanno->get_tag_values('comment'))[0];\n            $contiginfo{'frameshift'} = ($contanno->get_tag_values('frameshift'))[0];\n            \n            # Check that no tag value is undef\n            $contiginfo{'seq_id'}     = '' unless defined $contiginfo{'seq_id'};\n            $contiginfo{'com_name'}   = '' unless defined $contiginfo{'com_name'};\n            $contiginfo{'type'}       = '' unless defined $contiginfo{'type'};\n            $contiginfo{'method'}     = '' unless defined $contiginfo{'method'};\n            $contiginfo{'ed_status'}  = '' unless defined $contiginfo{'ed_status'};\n            $contiginfo{'full_cds'}   = '' unless defined $contiginfo{'full_cds'};\n            $contiginfo{'cds_start'}  = '' unless defined $contiginfo{'cds_start'};\n            $contiginfo{'cds_end'}    = '' unless defined $contiginfo{'cds_end'};\n            $contiginfo{'ed_pn'}      = '' unless defined $contiginfo{'ed_pn'};\n            $contiginfo{'comment'}    = '' unless defined $contiginfo{'comment'};\n            $contiginfo{'frameshift'} = '' unless defined $contiginfo{'frameshift'};\n                       \n            # Print contig information\n            $self->_print(\n                \"sequence\\t$contiginfo{'sequence'}\\n\".\n                \"lsequence\\t$contiginfo{'lsequence'}\\n\".\n                \"quality\\t$contiginfo{'quality'}\\n\".\n                \"asmbl_id\\t$contiginfo{'asmbl_id'}\\n\".\n                \"seq_id\\t$contiginfo{'seq_id'}\\n\".\n                \"com_name\\t$contiginfo{'com_name'}\\n\".\n                \"type\\t$contiginfo{'type'}\\n\".\n                \"method\\t$contiginfo{'method'}\\n\".\n                \"ed_status\\t$contiginfo{'ed_status'}\\n\".\n                \"redundancy\\t$contiginfo{'redundancy'}\\n\".\n                \"perc_N\\t$contiginfo{'perc_N'}\\n\".\n                \"seq#\\t$contiginfo{'seqnum'}\\n\".\n                \"full_cds\\t$contiginfo{'full_cds'}\\n\".\n                \"cds_start\\t$contiginfo{'cds_start'}\\n\".\n                \"cds_end\\t$contiginfo{'cds_end'}\\n\".\n                \"ed_pn\\t$contiginfo{'ed_pn'}\\n\".\n                \"ed_date\\t$contiginfo{'ed_date'}\\n\".\n                \"comment\\t$contiginfo{'comment'}\\n\".\n                \"frameshift\\t$contiginfo{'frameshift'}\\n\".\n                \"\\n\"\n            );\n            my $seqno = 0;\n            for my $readobj ( $contigobj->each_seq() ) {\n                $seqno++;\n                \n                # Get read information\n                my ($seq_name, $db) = $self->_split_seq_name_and_db($readobj->id);\n                my ($asm_lend, $asm_rend, $seq_lend, $seq_rend, $offset)\n                    = $self->_coord($readobj, $contigobj);\n                my $readanno = ( grep \n                    { $_->primary_tag eq '_main_read_feature:'.$readobj->primary_id }\n                    $contigobj->get_seq_coord($readobj)->get_SeqFeatures\n                )[0];\n                my %readinfo;                \n                $readinfo{'seq_name'}  = $seq_name;\n                $readinfo{'asm_lend'}  = $asm_lend;\n                $readinfo{'asm_rend'}  = $asm_rend;\n                $readinfo{'seq_lend'}  = $seq_lend;\n                $readinfo{'seq_rend'}  = $seq_rend;                \n                $readinfo{'best'}      = ($readanno->get_tag_values('best'))[0];\n                $readinfo{'comment'}   = ($readanno->get_tag_values('comment'))[0];\n                $readinfo{'db'}        = $db;\n                $readinfo{'offset'}    = $offset;   \n                $readinfo{'lsequence'} = $readobj->seq(); \n                         \n                # Check that no tag value is undef\n                $readinfo{'best'}    = '' unless defined $readinfo{'best'};\n                $readinfo{'comment'} = '' unless defined $readinfo{'comment'};\n    \n                # Print read information\n                $self->_print(\n                    \"seq_name\\t$readinfo{'seq_name'}\\n\".\n                    \"asm_lend\\t$readinfo{'asm_lend'}\\n\".\n                    \"asm_rend\\t$readinfo{'asm_rend'}\\n\".\n                    \"seq_lend\\t$readinfo{'seq_lend'}\\n\".\n                    \"seq_rend\\t$readinfo{'seq_rend'}\\n\".\n                    \"best\\t$readinfo{'best'}\\n\".\n                    \"comment\\t$readinfo{'comment'}\\n\".\n                    \"db\\t$readinfo{'db'}\\n\".\n                    \"offset\\t$readinfo{'offset'}\\n\".\n                    \"lsequence\\t$readinfo{'lsequence'}\\n\"\n                );\n                if ($seqno < $contiginfo{'seqnum'}) {\n                    $self->_print(\"\\n\");\n                } elsif (($seqno == $contiginfo{'seqnum'}) && ($i+1 < $numobj)) {\n                    $self->_print(\"|\\n\");\n                }\n            }\n        }\n    }\n    return 1;\n}\n\n=head2 _perc_N\n\n    Title   : _perc_N\n    Usage   : my $perc_N = $ass_io->_perc_N($sequence_string)\n    Function: Calculate the percent of ambiguities in a sequence.\n              M R W S Y K X N are regarded as ambiguites in an aligned read\n              sequence by TIGR Assembler. In the case of a gapped contig\n              consensus sequence, all lowercase symbols are ambiguities, i.e.:\n              a c g t u m r w s y k x n.\n    Returns : decimal number\n    Args    : string\n\n\nsub _perc_N {\n    my ($self, $seq_string) = @_;\n    $self->throw(\"Cannot accept an empty sequence\") if length($seq_string) == 0;\n    my $perc_N = 0;\n    for my $base ( split //, $seq_string ) {\n        # individual base matches an ambiguity?\n        if (( $base =~ m/[x|n|m|r|w|s|y|k]/i ) || ( $base =~ m/[a|c|g|t|u]/ ) ) {\n            $perc_N++;\n        }\n    }\n    $perc_N = $perc_N * 100 / length $seq_string;\n    return $perc_N;\n}\n\n=head2 _redundancy\n\n    Title   : _redundancy\n    Usage   : my $ref = $ass_io->_redundancy($contigobj)\n    Function: Calculate the fold coverage (redundancy) of a contig consensus\n              (average number of read base pairs covering the consensus)\n    Returns : decimal number\n    Args    : Bio::Assembly::Contig\n\n\nsub _redundancy {\n    # redundancy = (sum of all aligned read lengths - ( number of gaps in gapped\n    # consensus + number of gaps in aligned reads that are also in the consensus ) )\n    # / length of ungapped consensus\n    my ($self, $contigobj) = @_;\n    my $redundancy = 0;\n    \n    # sum of all aligned read lengths\n    my $read_tot = 0;\n    for my $readobj ( $contigobj->each_seq ) {\n        my $read_length = length($readobj->seq);\n        $read_tot += $read_length;\n    }\n    $redundancy += $read_tot;\n    \n    # - respected gaps\n    my $consensus_sequence = $contigobj->get_consensus_sequence->seq;\n    my @consensus_gaps = ();\n    $contigobj->_register_gaps($consensus_sequence, \\@consensus_gaps);\n    my $respected_gaps = scalar(@consensus_gaps);\n    if ($respected_gaps > 0) {\n        my @cons_arr = split //, $consensus_sequence;\n        for my $gap_pos_cons ( @consensus_gaps ) {\n            for my $readobj ( $contigobj->each_seq ) {\n                my $readid = $readobj->id;\n                my $read_start = $contigobj->change_coord(\n                    \"aligned $readid\", 'gapped consensus', $readobj->start);\n                my $read_end   = $contigobj->change_coord(\n                    \"aligned $readid\", 'gapped consensus', $readobj->end  );\n                # skip this if consensus gap position not within in the read boundaries\n                next if ( ($gap_pos_cons < $read_start)\n                    || ($gap_pos_cons > $read_end) );\n                # does the read position have read have a gap?\n                my @read_arr = split //, $readobj->seq;                \n                my $gap_pos_read = $contigobj->change_coord(\n                    'gapped consensus', \"aligned $readid\", $gap_pos_cons);\n                if ($read_arr[$gap_pos_read-1] eq $cons_arr[$gap_pos_cons-1]) {\n                    $respected_gaps++;\n                }\n            }\n        }\n    }\n    $redundancy -= $respected_gaps;\n    \n    # / length of ungapped consensus\n    my $contig_length = length($self->_ungap($contigobj->get_consensus_sequence->seq));\n    $redundancy /= $contig_length;\n    \n    return $redundancy;\n}\n\n=head2 _ungap\n\n    Title   : _ungap\n    Usage   : my $ungapped = $ass_io->_ungap($gapped)\n    Function: Remove the gaps from a sequence. Gaps are - in TIGR Assembler\n    Returns : string\n    Args    : string\n\n\nsub _ungap {\n    my ($self, $seq_string) = @_;\n    $seq_string =~ s/-//g;\n    return $seq_string;\n}\n\n=head2 _date_time\n\n    Title   : _date_time\n    Usage   : my $timepoint = $ass_io->date_time\n    Function: Get date and time (MM//DD/YY HH:MM:SS)\n    Returns : string\n    Args    : none\n\n\nsub _date_time {\n    my ($self) = @_;\n    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);\n    my $formatted_date_time = \n        sprintf('%02d', $mon+1).'/'.\n        sprintf('%02d', $mday).'/'.\n        sprintf('%02d', $year % 100).\n        ' '.\n        sprintf('%02d', $hour).':'.\n        sprintf('%02d', $min).':'.\n        sprintf('%02d',$sec)\n    ;\n    return $formatted_date_time;\n}\n\n=head2 _split_seq_name_and_db\n\n    Title   : _split_seq_name_and_db\n    Usage   : my ($seqname, $db) = $ass_io->_split_seq_name_and_db($id)\n    Function: Extract seq_name and db from sequence id\n    Returns : seq_name, db\n    Args    : id\n\n\nsub _split_seq_name_and_db {\n    my ($self, $id) = @_;\n    my $seq_name = '';\n    my $db       = '';\n    if ($id =~ m/(\\S+)\\|(\\S+)/) {\n        $db       = $1;\n        $seq_name = $2;\n    } else {\n        $seq_name = $id;\n    }\n    return ($seq_name, $db);\n}\n\n=head2 _merge_seq_name_and_db\n\n    Title   : _merge_seq_name_and_db\n    Usage   : my $id = $ass_io->_merge_seq_name_and_db($seq_name, $db)\n    Function: Construct id from seq_name and db\n    Returns : id\n    Args    : seq_name, db","parameters":[{"label":"$self"},{"label":"$seq_name"},{"label":"$db"}]},"containerName":"main::","definition":"sub","line":1109,"children":[{"kind":13,"line":1110,"name":"$self","definition":"my","containerName":"_merge_seq_name_and_db","localvar":"my"},{"line":1110,"kind":13,"containerName":"_merge_seq_name_and_db","name":"$seq_name"},{"containerName":"_merge_seq_name_and_db","name":"$db","kind":13,"line":1110},{"kind":13,"line":1111,"definition":"my","name":"$id","containerName":"_merge_seq_name_and_db","localvar":"my"},{"kind":13,"line":1112,"name":"$db","containerName":"_merge_seq_name_and_db"},{"name":"$id","containerName":"_merge_seq_name_and_db","line":1113,"kind":13},{"containerName":"_merge_seq_name_and_db","name":"$db","kind":13,"line":1113},{"line":1113,"kind":13,"name":"$seq_name","containerName":"_merge_seq_name_and_db"},{"name":"$id","containerName":"_merge_seq_name_and_db","kind":13,"line":1115},{"kind":13,"line":1115,"containerName":"_merge_seq_name_and_db","name":"$seq_name"},{"kind":13,"line":1117,"name":"$id","containerName":"_merge_seq_name_and_db"}],"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,$readobj,$contigobj)","signature":{"documentation":"__END__\n# $Id: tigr.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO::tigr\n#\n# Copyright by Florent Angly\n#\n# You may distribute this module under the same terms as Perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO::tigr - Driver to read and write assembly files in the TIGR\nAssembler v2 default format.\n\n=head1 SYNOPSIS\n\n    # Building an input stream\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $asmio = Bio::Assembly::IO->new( -file   => 'SGC0-424.tasm',\n                                        -format => 'tigr' );\n    my $scaffold = $asmio->next_assembly;\n\n    # Do some things on contigs...\n\n    # Assembly writing methods\n    my $outasm = Bio::Assembly::IO->new( -file   => \">SGC0-modified.tasm\",\n                                         -format => 'tigr' );\n    $outasm->write_assembly( -scaffold => $assembly,\n                             -singlets => 1 );\n\n=head1 DESCRIPTION\n\nThis package loads and writes assembly information in/from files in the default\nTIGR Assembler v2 format. The files are lassie-formatted and often have the\n.tasm extension. This module was written to be used as a driver module for\nBio::Assembly::IO input/output.\n\n=head2 Implementation\n\nAssemblies are loaded into Bio::Assembly::Scaffold objects composed of\nBio::Assembly::Contig and Bio::Assembly::Singlet objects. Since aligned reads\nand contig gapped consensus can be obtained in the tasm files, only\naligned/gapped sequences are added to the different BioPerl objects.\n\nAdditional assembly information is stored as features. Contig objects have\nSeqFeature information associated with the primary_tag:\n\n    _main_contig_feature:$contig_id -> misc contig information\n    _quality_clipping:$read_id      -> quality clipping position\n\nRead objects have sub_seqFeature information associated with the\nprimary_tag:\n\n    _main_read_feature:$read_id     -> misc read information\n\nSinglets are considered by TIGR Assembler as contigs of one sequence and are\nrepresented here with features having these primary_tag: \n\n    _main_contig_feature:$contig_id\n    _quality_clipping:$read_primary_id\n    _main_read_feature:$read_primary_id\n    _aligned_coord:$read_primary_id\n\n=head1 THE TIGR TASM LASSIEFORMAT\n\n=head2 Description\n\nIn the TIGR tasm lassie format, contigs are separated by a line containing a single\npipe character \"|\", whereas the reads in a contig are separated by a blank line.\nSinglets can be present in the file and are represented as a contig\ncomposed of a single sequence.\n\nOther than the two above-mentioned separators, each line has an attribute name,\nfollowed a tab and then an attribute value.\n\nThe tasm format is used by more TIGR applications than just TIGR Assembler.\nSome of the attributes are not used by TIGR Assembler or have constant values.\nThey are indicated by an asterisk *\n\nContigs have the following attributes:\n\n    asmbl_id   -> contig ID\n    sequence   -> contig ungapped consensus sequence (ambiguities are lowercase)\n    lsequence  -> gapped consensus sequence (lowercase ambiguities)\n    quality    -> gapped consensus quality score (in hexadecimal)\n    seq_id     -> *\n    com_name   -> *\n    type       -> *\n    method     -> always 'asmg' *\n    ed_status  -> *\n    redundancy -> fold coverage of the contig consensus\n    perc_N     -> percent of ambiguities in the contig consensus\n    seq#       -> number of sequences in the contig\n    full_cds   -> *\n    cds_start  -> start of coding sequence *\n    cds_end    -> end of coding sequence *\n    ed_pn      -> name of editor (always 'GRA') *\n    ed_date    -> date and time of edition\n    comment    -> some comments *\n    frameshift -> *\n\nEach read has the following attributes:\n\n    seq_name  -> read name\n    asm_lend  -> position of first base on contig ungapped consensus sequence\n    asm_rend  -> position of last base on contig ungapped consensus sequence\n    seq_lend  -> start of quality-trimmed sequence (aligned read coordinates)\n    seq_rend  -> end of quality-trimmed sequence (aligned read coordinates)\n    best      -> always '0' *\n    comment   -> some comments *\n    db        -> database name associated with the sequence (e.g. >my_db|seq1234)\n    offset    -> offset of the sequence (gapped consensus coordinates)\n    lsequence -> aligned read sequence (ambiguities are uppercase)\n\nWhen asm_rend E<lt> asm_lend, the sequence was on the complementary DNA strand but\nits reverse complement is shown in the aligned sequence of the assembly file,\nnot the original read.\n\nAmbiguities are reflected in the contig consensus sequence as\nlowercase IUPAC characters: a c g t u m r w s y k x n . In the read\nsequences, however, ambiguities are uppercase: M R W S Y K X N\n\n=head2 Example\n\nExample of a contig containing three sequences:\n\n    sequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCGCAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAsCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCyGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAaGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    quality\t0x0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0505050505050505050E0505160505050505050505050505050505050505050505050505050505050303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0404040404040404041604040404040404040404040404040404040404040404040404040404040404040404040404040404040E0404040404040404040B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B\n    asmbl_id\t93\n    seq_id\t\n    com_name\t\n    type\t\n    method\tasmg\n    ed_status\t\n    redundancy\t1.11\n    perc_N\t0.20\n    seq#\t3\n    full_cds\t\n    cds_start\t\n    cds_end\t\n    ed_pn\tGRA\n    ed_date\t08/16/07 17:10:12\n    comment\t\n    frameshift\t\n\n    seq_name\tSDSU_RFPERU_010_C09.x01.phd.1\n    asm_lend\t1\n    asm_rend\t4423\n    seq_lend\t1\n    seq_rend\t442\n    best\t0\n    comment\t\n    db\t\n    offset\t0\n    lsequence\tCGATGCTGTACGGCTGTTGCGACAGATTGCGCTGGGTCGATACCGCGTTGGTGATCGGCTTGTTCAGCGGGCTCTGGTTCGGCGACAGCGCGGCGATCTTGGCGGCTGCGAAGGTTGCCGGCGCAATCATGCGCTGCTGACCGTTGACCTGGTCCTGCCAGTACACCCAGTCGCCCACCATGACCTTCAGCGCGTAGCTGTCACAGCCGGCTGTGGTCAGCGCAGTGGCGACGGTGGTGTAGGAGGCGCCAGCAACACCTTGGGTGATCATGTAGCAGCCTTCTGACAGGCCGTAGGTCAGCATGGTCGGCCACTGGGTACCAGTCAGTCGGGTCAACCGAGATTCG-CAGCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGG\n\n    seq_name\tSDSU_RFPERU_002_H12.x01.phd.1\n    asm_lend\t339\n    asm_rend\t940\n    seq_lend\t1\n    seq_rend\t602\n    best\t0\n    comment\t\n    db\t\n    offset\t338\n    lsequence\tCGAGATTCGCCACCTGAGCGCCACTGCCGCGCAGAGCGTACATGCCCTTGCGGGTCGCGCCGGTAACACCATCCACGCCGATCAGAACTGCGTCGGTGATGGTGGTGTTACCCGAGGTGCCAGTGGTGAAGGCGACGGTCTGGGTGCTGGCCACAGGCGCCAGAGTGGTCGCGCCAACGGTGGCGATGACCAGTTGCGATGGGCCACGGATACCTGACTGCCCGTTGTTCACGGCGCTGACGATGTTCTGCCACAGCGCCAGGCCAGAGCCGGTGATGTTGTCGAACACTTCGGGCGCAACGCCAGGGAGCGAGACGGTCAGCTTCCAGCTCGAAGCAGCGGAGCCAGTAGCCAGGGCGGCGCTGAGCGAGTTGCCGAGCGTGCCGGTGTAGAACGCGGTCAGCGTGGCGCCGGTGGCGGCGGCAGTGTCCTTCAGCGCACTGGTCGCGGCGGTGTCGGTGCCGTCAGTGACGCGCACGGCGCGGATGTTCGAGGCGCCGCCCTGGATTGATACCGCCAGCGCGGTGCACAGGTCGTACTTGCGCACGGTCCGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATA-GCGTGGCGC\n\n    seq_name\tSDSU_RFPERU_009_E07.x01.phd.1\n    asm_lend\t880\n    asm_rend\t1520\n    seq_lend\t641\n    seq_rend\t1\n    best\t0\n    comment\t\n    db\t\n    offset\t8803\n    lsequence\tCGCACGGTCTGAGTGCCGAACTTCTGCGATGCGTCACCTGGCGAGCCGATAAGCGTGGCGCTGTTCACCGGCCCCCAGTCAGCAATGCCGACGATGCCGAGAATGTCAGTCGGGACGCCATTGATGTAGCGGGTCTTGGGCGCCACTATTTGTATGTACAAATCTGGCGCAGATAAAGCCGCCGTATTCAAATAACCAGCAGGATAGATAGGCATCACGCCTCCAGAATGAAAAAGGCCACCGATTAGGTGGCCTTTGTTGTGTTCGGCTGGCTGTTAGAGCAGCAGCCCGTTTTCCCGCGCAAACGCGAATGGGTCCTTGTCATGCTTCCTGCAATTGCAGGTAGGACAAAGAATTTGCAGGTTGGATTTGTCGTTCGATCCGCCCTTTGCAAGCGGGAACACGTGGTCAACGTGATACCCATCCCTTATGGATATAGTGCACATGGCGCATTTCCAGCGCTGAGCAGCCAGCAAAAATTTTATGTCGTCGCCGGTGTGTGAGCCGACAGCATTTTTCTTGCGAGCCTTGTATGTCCGCGAGAGTGAACGAACTTGCTCCTTGTTGGCTGTCTTCCAGAGCTTTTGAGTAAGCGCACAGAGATCCTTGTTTCTTGATCTCCACTCTCTGGTTGCGGAAAT\n    |\n\n...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the BioPerl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via email\nor the web:\n\n  bioperl-bugs@bio.perl.org\n  http://bugzilla.bioperl.org/\n\n=head1 AUTHOR - Florent E Angly\n\nEmail florent dot angly at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\npackage Bio::Assembly::IO::tigr;\n\nuse strict;\nuse Bio::Seq::Quality;\nuse Bio::LocatableSeq;\nuse Bio::Assembly::IO;\nuse Bio::Assembly::Scaffold;\nuse Bio::Assembly::Contig;\nuse Bio::Assembly::Singlet;\n\nuse base qw(Bio::Assembly::IO);\n\nmy $progname = 'TIGR Assembler';\n\n=head2 next_assembly\n\n Title   : next_assembly\n Usage   : my $scaffold = $asmio->next_assembly()\n Function: return the next assembly in the tasm-formatted stream\n Returns : Bio::Assembly::Scaffold object\n Args    : none\n\n\nsub next_assembly {\n    my $self = shift; # object reference\n    \n    # Create a new scaffold to hold the contigs\n    my $scaffoldobj = Bio::Assembly::Scaffold->new(-source => $progname);\n    \n    # Contig and read related\n    my $contigobj;\n    my $iscontig = 1;\n    my %contiginfo;\n    my $isread = 0;\n    my %readinfo;\n    \n    # Loop over all assembly file lines\n    while ($_ = $self->_readline) {\n        chomp;\n        if ( /^\\|/ ) {  # a line with a single pipe |\n            # The end of a read from a contig, the start of a new contig\n            $iscontig = 1;\n            $isread   = 0;\n            # Store read info\n            if ($contiginfo{'seqnum'} > 1) {\n                # This is a read in a contig\n                my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n            } elsif ($contiginfo{'seqnum'} == 1) {\n                # This is a singlet\n                my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                    $scaffoldobj);\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n            # Clear read info\n            undef %readinfo;\n            # Clear contig info\n            undef $contigobj;\n            undef %contiginfo;\n        } elsif ( /^$/ ) {  # a blank line\n            if ($iscontig) {\n                # The end of a contig, the start of a read in that contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store contig info\n                $contigobj = $self->_store_contig( \\%contiginfo, $contigobj,\n                    $scaffoldobj ) if $contiginfo{'seqnum'} > 1;\n            } elsif ($isread) {\n                # The end of read in a contig, the start of a new one in\n                # the same contig\n                $iscontig = 0;\n                $isread   = 1;\n                # Store read info\n                if ($contiginfo{'seqnum'} > 1) {\n                    # This is a read in a contig\n                    my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n                } elsif ($contiginfo{'seqnum'} == 1) {\n                    # This is a singlet\n                    my $singletobj = $self->_store_singlet(\\%readinfo,\n                        \\%contiginfo, $scaffoldobj);\n                } else {\n                  # That should not happen\n                  $self->throw(\"Unhandled exception\");\n                }\n                # Clear read info\n                undef %readinfo;\n            } else {\n                # That should not happen\n                $self->throw(\"Unhandled exception\");\n            }\n        } else {\n            if ($iscontig) {\n                # Parse contig\n                if    (/^sequence\\t(.*)/)     {$contiginfo{'sequence'}   = $1; next}\n                elsif (/^lsequence\\t(.*)/)    {$contiginfo{'lsequence'}  = $1; next}\n                elsif (/^quality\\t(.*)/)      {$contiginfo{'quality'}    = $1; next}\n                elsif (/^asmbl_id\\t(.*)/)     {$contiginfo{'asmbl_id'}   = $1; next}\n                elsif (/^seq_id\\t(.*)/)       {$contiginfo{'seq_id'}     = $1; next}\n                elsif (/^com_name\\t(.*)/)     {$contiginfo{'com_name'}   = $1; next}\n                elsif (/^type\\t(.*)/)         {$contiginfo{'type'}       = $1; next}\n                elsif (/^method\\t(.*)/)       {$contiginfo{'method'}     = $1; next}\n                elsif (/^ed_status\\t(.*)/)    {$contiginfo{'ed_status'}  = $1; next}\n                elsif (/^redundancy\\t(.*)/)   {$contiginfo{'redundancy'} = $1; next}\n                elsif (/^perc_N\\t(.*)/)       {$contiginfo{'perc_N'}     = $1; next}\n                elsif (/^seq\\#\\t(.*)/)        {$contiginfo{'seqnum'}     = $1; next}\n                elsif (/^full_cds\\t(.*)/)     {$contiginfo{'full_cds'}   = $1; next}\n                elsif (/^cds_start\\t(.*)/)    {$contiginfo{'cds_start'}  = $1; next}\n                elsif (/^cds_end\\t(.*)/)      {$contiginfo{'cds_end'}    = $1; next}\n                elsif (/^ed_pn\\t(.*)/)        {$contiginfo{'ed_pn'}      = $1; next}\n                elsif (/^ed_date\\t(.*\\s.*)/)  {$contiginfo{'ed_date'}    = $1; next}\n                elsif (/^comment\\t(.*)/)      {$contiginfo{'comment'}    = $1; next}\n                elsif (/^frameshift\\t(.*)/)   {$contiginfo{'frameshift'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } elsif ($isread) {\n                # Parse read info\n                if    (/^seq_name\\t(.*)/)  {$readinfo{'seq_name'}  = $1; next}\n                elsif (/^asm_lend\\t(.*)/)  {$readinfo{'asm_lend'}  = $1; next}\n                elsif (/^asm_rend\\t(.*)/)  {$readinfo{'asm_rend'}  = $1; next}\n                elsif (/^seq_lend\\t(.*)/)  {$readinfo{'seq_lend'}  = $1; next}\n                elsif (/^seq_rend\\t(.*)/)  {$readinfo{'seq_rend'}  = $1; next}\n                elsif (/^best\\t(.*)/)      {$readinfo{'best'}      = $1; next}\n                elsif (/^comment\\t(.*)/)   {$readinfo{'comment'}   = $1; next}\n                elsif (/^db\\t(.*)/)        {$readinfo{'db'}        = $1; next}\n                elsif (/^offset\\t(.*)/)    {$readinfo{'offset'}    = $1; next}\n                elsif (/^lsequence\\t(.*)/) {$readinfo{'lsequence'} = $1; next}\n                else {\n                    $self->throw(\"Format unknown at line $.:\\n$_\\nIs your file\".\n                        \" really a TIGR Assembler tasm-formatted file?\");\n                }\n            } else {\n                # That shouldn't happen\n                $self->throw(\"Unhandled exception\");                \n            }\n        }\n    }\n    # Store read info for last read\n    if (defined $contiginfo{'seqnum'}) {\n        if ($contiginfo{'seqnum'} > 1) {\n            # This is a read in a contig\n            my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n        } elsif ($contiginfo{'seqnum'} == 1) {\n            # This is a singlet\n            my $singletobj = $self->_store_singlet(\\%readinfo, \\%contiginfo,\n                $scaffoldobj);\n        } else {\n            # That should not happen\n            $self->throw(\"Unhandled exception\");\n        }\n    }\n    # Clear read info for last read\n    undef %readinfo;\n    # Clear contig info for last contig\n    undef $contigobj;\n    undef %contiginfo;\n    \n    $scaffoldobj->update_seq_list();\n    \n    return $scaffoldobj;\n}\n\n=head2 _qual_hex2dec\n\n    Title   : _qual_hex2dec\n    Usage   : my dec_quality = $self->_qual_hex2dec($hex_quality);\n    Function: convert an hexadecimal quality score into a decimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_hex2dec {\n    my ($self, $qual) = @_;\n    $qual =~ s/^0x(.*)$/$1/;\n    $qual =~ s/(..)/hex($1).' '/eg;\n    return $qual;\n}\n\n=head2 _qual_dec2hex\n\n    Title   : _qual_dec2hex\n    Usage   : my hex_quality = $self->_qual_dec2hex($dec_quality);\n    Function: convert a decimal quality score into an hexadecimal quality score \n    Returns : string\n    Args    : string\n\n\nsub _qual_dec2hex {\n    my ($self, $qual) = @_;\n    $qual =~ s/(\\d+)\\s*/sprintf('%02X', $1)/eg;\n    $qual = '0x'.$qual;\n    return $qual;\n}\n\n=head2 _store_contig\n\n    Title   : _store_contig\n    Usage   : my $contigobj; $contigobj = $self->_store_contig(\n              \\%contiginfo, $contigobj, $scaffoldobj);\n    Function: store information of a contig belonging to a scaffold in the\n              appropriate object\n    Returns : Bio::Assembly::Contig object\n    Args    : hash, Bio::Assembly::Contig, Bio::Assembly::Scaffold\n\n\nsub _store_contig {\n    my ($self, $contiginfo, $contigobj, $scaffoldobj) = @_;\n\n    # Create a contig and attach it to scaffold\n    $contigobj = Bio::Assembly::Contig->new(\n        -id     => $$contiginfo{'asmbl_id'},\n        -source => $progname,\n        -strand => 1\n    );\n    $scaffoldobj->add_contig($contigobj);\n\n    # Create a gapped consensus sequence and attach it to contig\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $consensus = Bio::LocatableSeq->new(\n        -id    => $$contiginfo{'asmbl_id'},\n        -seq   => $$contiginfo{'lsequence'},\n        -start => 1,\n    );\n    $contigobj->set_consensus_sequence($consensus);\n\n    # Create an gapped consensus quality score and attach it to contig\n    $$contiginfo{'quality'} = $self->_qual_hex2dec($$contiginfo{'quality'});\n    my $qual = Bio::Seq::Quality->new(\n        -id   => $$contiginfo{'asmbl_id'},\n        -qual => $$contiginfo{'quality'}\n    );\n    $contigobj->set_consensus_quality($qual);\n\n    # Add other misc contig information as features of the contig\n    my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$$contiginfo{'asmbl_id'}\",\n        -start       => 1,\n        -end         => $contigobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n    );\n    $contigobj->add_features([ $contigtags ], 1);\n\n    return $contigobj;\n}\n\n=head2 _store_read\n\n    Title   : _store_read\n    Usage   : my $readobj = $self->_store_read(\\%readinfo, $contigobj);\n    Function: store information of a read belonging to a contig in the appropriate object\n    Returns : Bio::LocatableSeq\n    Args    : hash, Bio::Assembly::Contig\n\n\nsub _store_read {\n   my ($self, $readinfo, $contigobj) = @_;\n\n   # Create an aligned read object\n   #$$readinfo{'llength'} = length($$readinfo{'lsequence'});\n   $$readinfo{'strand'}  = ($$readinfo{'seq_rend'} > $$readinfo{'seq_lend'} ? 1 : -1);\n   my $readobj = Bio::LocatableSeq->new(\n       # the ids of sequence objects are supposed to include the db name in it, i.e. \"big_db|seq1234\"\n       # that's how sequence ids coming from the fasta parser are at least\n       -display_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -primary_id => $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'}),\n       -seq        => $$readinfo{'lsequence'},      \n       -start      => 1,\n       -strand     => $$readinfo{'strand'},\n       -alphabet   => 'dna'\n   );\n\n   # Add read location and sequence to contig (in 'gapped consensus' coordinates)\n   $$readinfo{'aln_start'} = $$readinfo{'offset'} + 1; # seq offset is in gapped coordinates\n   $$readinfo{'aln_end'} = $$readinfo{'aln_start'} + length($$readinfo{'lsequence'}) - 1; # lsequence is aligned seq\n   my $alncoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => $readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigobj->id() }\n   );\n   $contigobj->set_seq_coord($alncoord, $readobj);\n\n   # Add quality clipping read information in contig features\n   # (from 'aligned read' to 'gapped consensus' coordinates)\n   $$readinfo{'clip_start'} = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_lend'});\n   $$readinfo{'clip_end'}   = $contigobj->change_coord('aligned '.$readobj->id, 'gapped consensus', $$readinfo{'seq_rend'});\n   my $clipcoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_quality_clipping:'.$readobj->id,\n       -start       => $$readinfo{'clip_start'},\n       -end         => $$readinfo{'clip_end'},\n       -strand      => $$readinfo{'strand'}\n   );\n   $clipcoord->attach_seq($readobj);\n   $contigobj->add_features([ $clipcoord ], 0);\n   \n   # Add other misc read information as subsequence feature\n   my $readtags = Bio::SeqFeature::Generic->new(\n       -primary_tag => '_main_read_feature:'.$readobj->id,\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'best'    => $$readinfo{'best'},\n                         'comment' => $$readinfo{'comment'} }\n   );\n   $alncoord->add_sub_SeqFeature($readtags);\n\n   return $readobj;\n}\n\n=head2 _store_singlet\n\n    Title   : _store_singlet\n    Usage   : my $singletobj = $self->_store_read(\\%readinfo, \\%contiginfo,\n                  $scaffoldobj);\n    Function: store information of a singlet belonging to a scaffold in the appropriate object\n    Returns : Bio::Assembly::Singlet\n    Args    : hash, hash, Bio::Assembly::Scaffold\n\n\nsub _store_singlet {\n    my ($self, $readinfo, $contiginfo, $scaffoldobj) = @_;\n    # Singlets in TIGR_Assembler are represented as a contig of one sequence\n    # We try to simulate this duality by playing around with the Singlet object\n    \n    my $contigid = $$contiginfo{'asmbl_id'};\n    my $readid   = $self->_merge_seq_name_and_db($$readinfo{'seq_name'}, $$readinfo{'db'});\n    \n    # Create a sequence object\n    #$$contiginfo{'llength'} = length($$contiginfo{'lsequence'});\n    my $seqobj = Bio::Seq::Quality->new(\n       -primary_id => $contigid, # unique id in assembly (contig name)\n       -display_id => $readid,\n       -seq        => $$contiginfo{'lsequence'}, # do not use $$readinfo as ambiguities are uppercase\n       -start      => 1,\n       -strand     => $$readinfo{'strand'},\n       -alphabet   => 'dna',\n       -qual => $self->_qual_hex2dec($$contiginfo{'quality'})    \n   );\n\n   # Create singlet from sequence and add it to scaffold\n   my $singletobj = Bio::Assembly::Singlet->new( -seqref => $seqobj );\n   $scaffoldobj->add_singlet($singletobj);\n\n   # Add other misc contig information as features of the singlet\n   my $contigtags = Bio::SeqFeature::Generic->new(\n        -primary_tag => \"_main_contig_feature:$contigid\",\n        -start       => 1,\n        -end         => $singletobj->get_consensus_length(),\n        -strand      => 1,\n        -tag         => { 'seq_id'     => $$contiginfo{'seq_id'},\n                          'com_name'   => $$contiginfo{'com_name'},\n                          'type'       => $$contiginfo{'type'},\n                          'method'     => $$contiginfo{'method'},\n                          'ed_status'  => $$contiginfo{'ed_status'},\n                          'full_cds'   => $$contiginfo{'full_cds'},\n                          'cds_start'  => $$contiginfo{'cds_start'},\n                          'cds_end'    => $$contiginfo{'cds_end'},\n                          'ed_pn'      => $$contiginfo{'ed_pn'},\n                          'ed_date'    => $$contiginfo{'ed_date'},\n                          'comment'    => $$contiginfo{'comment'},\n                          'frameshift' => $$contiginfo{'frameshift'} }\n   );\n   $singletobj->add_features([ $contigtags ], 1);\n\n   # Add read location and sequence to singlet features (in 'gapped consensus' coordinates)\n   $$readinfo{'aln_start'} = $$readinfo{'offset'} + 1; # seq offset is in gapped coordinates\n   $$readinfo{'aln_end'} = $$readinfo{'aln_start'} + length($$readinfo{'lsequence'}) - 1; # lsequence is aligned seq\n\n   my $alncoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_aligned_coord:$readid\",\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigid }\n   );\n   $alncoord->attach_seq($singletobj->seqref);\n   $singletobj->add_features([ $alncoord ], 0);\n\n   # Add quality clipping read information in singlet features\n   # (from 'aligned read' to 'gapped consensus' coordinates)\n   $$readinfo{'clip_start'} = $$readinfo{'seq_lend'};\n   $$readinfo{'clip_end'}   = $$readinfo{'seq_rend'};\n   my $clipcoord = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_quality_clipping:$readid\",\n       -start       => $$readinfo{'clip_start'},\n       -end         => $$readinfo{'clip_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'contig' => $contigid }\n   );\n   $clipcoord->attach_seq($singletobj->seqref);\n   $singletobj->add_features([ $clipcoord ], 0);\n   \n   # Add other misc read information as subsequence feature\n   my $readtags = Bio::SeqFeature::Generic->new(\n       -primary_tag => \"_main_read_feature:$readid\",\n       -start       => $$readinfo{'aln_start'},\n       -end         => $$readinfo{'aln_end'},\n       -strand      => $$readinfo{'strand'},\n       -tag         => { 'best'    => $$readinfo{'best'},\n                         'comment' => $$readinfo{'comment'} }\n   );\n   $alncoord->add_sub_SeqFeature($readtags);\n      \n   return $singletobj;\n}\n\n=head2 write_assembly\n\n    Title   : write_assembly\n    Usage   : $ass_io->write_assembly($assembly)\n    Function: Write the assembly object in TIGR Assembler compatible tasm lassie  \n              format\n    Returns : 1 on success, 0 for error\n    Args    : A Bio::Assembly::Scaffold object\n\n\nsub write_assembly {\n    my ($self,@args) = @_;    \n    my ($scaffoldobj, $singlets) = $self->_rearrange([qw(SCAFFOLD SINGLETS)], @args);\n    \n    # Sanity check\n    if ( !$scaffoldobj || !$scaffoldobj->isa('Bio::Assembly::Scaffold') ) {\n        $self->warn(\"Must provide a Bio::Align::AlignI object when calling\n            write_assembly\");\n        next;\n    }\n\n    # Get list of objects - contigs and singlets\n    my @cont_ids = $scaffoldobj->get_contig_ids;\n    my @sing_ids = $scaffoldobj->get_singlet_ids;\n    my %did;\n    my $decimal_format = '%.2f';\n    for (my $i = 0; $i < scalar @sing_ids ; $i++) {\n      # singlet display id (string)\n      my $display_id = $sing_ids[$i];\n      # singlet primary id (unique, numerical)\n      my $primary_id = $scaffoldobj->get_singlet_by_id($display_id)->seqref->primary_id;\n      $sing_ids[$i] = $primary_id;\n      $did{$primary_id} = $display_id;\n    }\n    my @ids = (@cont_ids, @sing_ids);\n    @ids = sort { $a <=> $b } @ids; # list with contig ids and singlet primary id\n    my $numobj = scalar @ids;\n\n    # Output all contigs and singlets (sorted by increasing id number)\n    for (my $i = 0 ; $i < $numobj ; $i++) {\n        \n        my $objid = $ids[$i];\n        \n        if (defined $did{$objid}) { \n            # This is a singlet\n            next unless ($singlets);\n\n            my $contigid = $objid;\n            my $readid   = $did{$objid};            \n            my $singletobj = $scaffoldobj->get_singlet_by_id($readid);\n            \n            # Get contig information\n            my $contanno = (grep\n                { $_->primary_tag eq \"_main_contig_feature:$contigid\" }\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my %contiginfo;\n            $contiginfo{'sequence'}   = $singletobj->seqref->seq;\n            $contiginfo{'lsequence'}  = $contiginfo{'sequence'};\n            $contiginfo{'quality'}    = $self->_qual_dec2hex(\n                join ' ', @{$singletobj->seqref->qual});\n            $contiginfo{'asmbl_id'}   = $contigid;\n            $contiginfo{'seq_id'}     = ($contanno->get_tag_values('seq_id'))[0];   \n            $contiginfo{'com_name'}   = ($contanno->get_tag_values('com_name'))[0];\n            $contiginfo{'type'}       = ($contanno->get_tag_values('type'))[0];\n            $contiginfo{'method'}     = ($contanno->get_tag_values('method'))[0];\n            $contiginfo{'ed_status'}  = ($contanno->get_tag_values('ed_status'))[0];\n            $contiginfo{'redundancy'} = sprintf($decimal_format, 1);\n            $contiginfo{'perc_N'}     = sprintf(\n                $decimal_format, $self->_perc_N($contiginfo{'sequence'}));\n            $contiginfo{'seqnum'}     = 1;\n            $contiginfo{'full_cds'}   = ($contanno->get_tag_values('full_cds'))[0];\n            $contiginfo{'cds_start'}  = ($contanno->get_tag_values('cds_start'))[0];\n            $contiginfo{'cds_end'}    = ($contanno->get_tag_values('cds_end'))[0];\n            $contiginfo{'ed_pn'}      = ($contanno->get_tag_values('ed_pn'))[0];\n            $contiginfo{'ed_date'}    = $self->_date_time;\n            $contiginfo{'comment'}    = ($contanno->get_tag_values('comment'))[0];\n            $contiginfo{'frameshift'} = ($contanno->get_tag_values('frameshift'))[0];\n\n            # Check that no tag value is undef\n            $contiginfo{'seq_id'}     = '' unless defined $contiginfo{'seq_id'};\n            $contiginfo{'com_name'}   = '' unless defined $contiginfo{'com_name'};\n            $contiginfo{'type'}       = '' unless defined $contiginfo{'type'};\n            $contiginfo{'method'}     = '' unless defined $contiginfo{'method'};\n            $contiginfo{'ed_status'}  = '' unless defined $contiginfo{'ed_status'};\n            $contiginfo{'full_cds'}   = '' unless defined $contiginfo{'full_cds'};\n            $contiginfo{'cds_start'}  = '' unless defined $contiginfo{'cds_start'};\n            $contiginfo{'cds_end'}    = '' unless defined $contiginfo{'cds_end'};\n            $contiginfo{'ed_pn'}      = '' unless defined $contiginfo{'ed_pn'};\n            $contiginfo{'comment'}    = '' unless defined $contiginfo{'comment'};\n            $contiginfo{'frameshift'} = '' unless defined $contiginfo{'frameshift'};\n            \n            # Print contig information\n            $self->_print(\n                \"sequence\\t$contiginfo{'sequence'}\\n\".\n                \"lsequence\\t$contiginfo{'lsequence'}\\n\".\n                \"quality\\t$contiginfo{'quality'}\\n\".\n                \"asmbl_id\\t$contiginfo{'asmbl_id'}\\n\".\n                \"seq_id\\t$contiginfo{'seq_id'}\\n\".\n                \"com_name\\t$contiginfo{'com_name'}\\n\".\n                \"type\\t$contiginfo{'type'}\\n\".\n                \"method\\t$contiginfo{'method'}\\n\".\n                \"ed_status\\t$contiginfo{'ed_status'}\\n\".\n                \"redundancy\\t$contiginfo{'redundancy'}\\n\".\n                \"perc_N\\t$contiginfo{'perc_N'}\\n\".\n                \"seq#\\t$contiginfo{'seqnum'}\\n\".\n                \"full_cds\\t$contiginfo{'full_cds'}\\n\".\n                \"cds_start\\t$contiginfo{'cds_start'}\\n\".\n                \"cds_end\\t$contiginfo{'cds_end'}\\n\".\n                \"ed_pn\\t$contiginfo{'ed_pn'}\\n\".\n                \"ed_date\\t$contiginfo{'ed_date'}\\n\".\n                \"comment\\t$contiginfo{'comment'}\\n\".\n                \"frameshift\\t$contiginfo{'frameshift'}\\n\".\n                \"\\n\"\n            );\n                        \n            # Get read information\n            my ($seq_name, $db) = $self->_split_seq_name_and_db($readid);\n            my $clipcoord = (grep\n                { $_->primary_tag eq \"_quality_clipping:$readid\"}\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my $alncoord  = (grep\n                { $_->primary_tag eq \"_aligned_coord:$readid\"}\n                $singletobj->get_features_collection->get_all_features\n            )[0];\n            my $readanno = (grep\n                { $_->primary_tag eq \"_main_read_feature:$readid\" }\n                $singletobj->get_seq_coord($singletobj->seqref)->get_SeqFeatures\n            )[0];\n            my %readinfo;\n            $readinfo{'seq_name'}  = $seq_name;\n            $readinfo{'asm_lend'}  = $alncoord->location->start;\n            $readinfo{'asm_rend'}  = $alncoord->location->end;\n            $readinfo{'seq_lend'}  = $clipcoord->location->start;\n            $readinfo{'seq_rend'}  = $clipcoord->location->end;\n            $readinfo{'best'}      = ($readanno->get_tag_values('best'))[0];\n            $readinfo{'comment'}   = ($readanno->get_tag_values('comment'))[0];\n            $readinfo{'db'}        = $db;         \n            $readinfo{'offset'}    = 0;\n            # ambiguities in read sequence are uppercase\n            $readinfo{'lsequence'} = uc($contiginfo{'lsequence'});\n            \n            # Check that no tag value is undef\n            $readinfo{'best'}    = '' unless defined $readinfo{'best'};\n            $readinfo{'comment'} = '' unless defined $readinfo{'comment'};\n\n            # Print read information\n            $self->_print(\n                \"seq_name\\t$readinfo{'seq_name'}\\n\".\n                \"asm_lend\\t$readinfo{'asm_lend'}\\n\".\n                \"asm_rend\\t$readinfo{'asm_rend'}\\n\".\n                \"seq_lend\\t$readinfo{'seq_lend'}\\n\".\n                \"seq_rend\\t$readinfo{'seq_rend'}\\n\".\n                \"best\\t$readinfo{'best'}\\n\".\n                \"comment\\t$readinfo{'comment'}\\n\".\n                \"db\\t$readinfo{'db'}\\n\".\n                \"offset\\t$readinfo{'offset'}\\n\".\n                \"lsequence\\t$readinfo{'lsequence'}\\n\"\n            );\n            if ($i+1 < $numobj) {\n                $self->_print(\"|\\n\");\n            }\n        } else {\n            # This is a contig\n            my $contigid = $objid;\n            my $contigobj = $scaffoldobj->get_contig_by_id($contigid);\n\n            # Skip contigs of 1 sequence (singlets) if needed\n            next if ($contigobj->num_sequences == 1) && (!$singlets);\n            \n            # Get contig information\n            my $contanno = (grep\n                { $_->primary_tag eq \"_main_contig_feature:$contigid\" }\n                $contigobj->get_features_collection->get_all_features\n            )[0];\n            my %contiginfo;\n            $contiginfo{'sequence'}   = $self->_ungap(\n                $contigobj->get_consensus_sequence->seq);\n            $contiginfo{'lsequence'}  = $contigobj->get_consensus_sequence->seq;\n            $contiginfo{'quality'}    = $self->_qual_dec2hex(\n                join ' ', @{$contigobj->get_consensus_quality->qual});\n            $contiginfo{'asmbl_id'}   = $contigid;\n            $contiginfo{'seq_id'}     = ($contanno->get_tag_values('seq_id'))[0];\n            $contiginfo{'com_name'}   = ($contanno->get_tag_values('com_name'))[0];\n            $contiginfo{'type'}       = ($contanno->get_tag_values('type'))[0];\n            $contiginfo{'method'}     = ($contanno->get_tag_values('method'))[0];\n            $contiginfo{'ed_status'}  = ($contanno->get_tag_values('ed_status'))[0];\n            $contiginfo{'redundancy'} = sprintf(\n                $decimal_format, $self->_redundancy($contigobj));\n            $contiginfo{'perc_N'}     = sprintf(\n                $decimal_format, $self->_perc_N($contiginfo{'sequence'}));\n            $contiginfo{'seqnum'}     = $contigobj->num_sequences;\n            $contiginfo{'full_cds'}   = ($contanno->get_tag_values('full_cds'))[0];\n            $contiginfo{'cds_start'}  = ($contanno->get_tag_values('cds_start'))[0];\n            $contiginfo{'cds_end'}    = ($contanno->get_tag_values('cds_end'))[0];\n            $contiginfo{'ed_pn'}      = ($contanno->get_tag_values('ed_pn'))[0];\n            $contiginfo{'ed_date'}    = $self->_date_time;\n            $contiginfo{'comment'}    = ($contanno->get_tag_values('comment'))[0];\n            $contiginfo{'frameshift'} = ($contanno->get_tag_values('frameshift'))[0];\n            \n            # Check that no tag value is undef\n            $contiginfo{'seq_id'}     = '' unless defined $contiginfo{'seq_id'};\n            $contiginfo{'com_name'}   = '' unless defined $contiginfo{'com_name'};\n            $contiginfo{'type'}       = '' unless defined $contiginfo{'type'};\n            $contiginfo{'method'}     = '' unless defined $contiginfo{'method'};\n            $contiginfo{'ed_status'}  = '' unless defined $contiginfo{'ed_status'};\n            $contiginfo{'full_cds'}   = '' unless defined $contiginfo{'full_cds'};\n            $contiginfo{'cds_start'}  = '' unless defined $contiginfo{'cds_start'};\n            $contiginfo{'cds_end'}    = '' unless defined $contiginfo{'cds_end'};\n            $contiginfo{'ed_pn'}      = '' unless defined $contiginfo{'ed_pn'};\n            $contiginfo{'comment'}    = '' unless defined $contiginfo{'comment'};\n            $contiginfo{'frameshift'} = '' unless defined $contiginfo{'frameshift'};\n                       \n            # Print contig information\n            $self->_print(\n                \"sequence\\t$contiginfo{'sequence'}\\n\".\n                \"lsequence\\t$contiginfo{'lsequence'}\\n\".\n                \"quality\\t$contiginfo{'quality'}\\n\".\n                \"asmbl_id\\t$contiginfo{'asmbl_id'}\\n\".\n                \"seq_id\\t$contiginfo{'seq_id'}\\n\".\n                \"com_name\\t$contiginfo{'com_name'}\\n\".\n                \"type\\t$contiginfo{'type'}\\n\".\n                \"method\\t$contiginfo{'method'}\\n\".\n                \"ed_status\\t$contiginfo{'ed_status'}\\n\".\n                \"redundancy\\t$contiginfo{'redundancy'}\\n\".\n                \"perc_N\\t$contiginfo{'perc_N'}\\n\".\n                \"seq#\\t$contiginfo{'seqnum'}\\n\".\n                \"full_cds\\t$contiginfo{'full_cds'}\\n\".\n                \"cds_start\\t$contiginfo{'cds_start'}\\n\".\n                \"cds_end\\t$contiginfo{'cds_end'}\\n\".\n                \"ed_pn\\t$contiginfo{'ed_pn'}\\n\".\n                \"ed_date\\t$contiginfo{'ed_date'}\\n\".\n                \"comment\\t$contiginfo{'comment'}\\n\".\n                \"frameshift\\t$contiginfo{'frameshift'}\\n\".\n                \"\\n\"\n            );\n            my $seqno = 0;\n            for my $readobj ( $contigobj->each_seq() ) {\n                $seqno++;\n                \n                # Get read information\n                my ($seq_name, $db) = $self->_split_seq_name_and_db($readobj->id);\n                my ($asm_lend, $asm_rend, $seq_lend, $seq_rend, $offset)\n                    = $self->_coord($readobj, $contigobj);\n                my $readanno = ( grep \n                    { $_->primary_tag eq '_main_read_feature:'.$readobj->primary_id }\n                    $contigobj->get_seq_coord($readobj)->get_SeqFeatures\n                )[0];\n                my %readinfo;                \n                $readinfo{'seq_name'}  = $seq_name;\n                $readinfo{'asm_lend'}  = $asm_lend;\n                $readinfo{'asm_rend'}  = $asm_rend;\n                $readinfo{'seq_lend'}  = $seq_lend;\n                $readinfo{'seq_rend'}  = $seq_rend;                \n                $readinfo{'best'}      = ($readanno->get_tag_values('best'))[0];\n                $readinfo{'comment'}   = ($readanno->get_tag_values('comment'))[0];\n                $readinfo{'db'}        = $db;\n                $readinfo{'offset'}    = $offset;   \n                $readinfo{'lsequence'} = $readobj->seq(); \n                         \n                # Check that no tag value is undef\n                $readinfo{'best'}    = '' unless defined $readinfo{'best'};\n                $readinfo{'comment'} = '' unless defined $readinfo{'comment'};\n    \n                # Print read information\n                $self->_print(\n                    \"seq_name\\t$readinfo{'seq_name'}\\n\".\n                    \"asm_lend\\t$readinfo{'asm_lend'}\\n\".\n                    \"asm_rend\\t$readinfo{'asm_rend'}\\n\".\n                    \"seq_lend\\t$readinfo{'seq_lend'}\\n\".\n                    \"seq_rend\\t$readinfo{'seq_rend'}\\n\".\n                    \"best\\t$readinfo{'best'}\\n\".\n                    \"comment\\t$readinfo{'comment'}\\n\".\n                    \"db\\t$readinfo{'db'}\\n\".\n                    \"offset\\t$readinfo{'offset'}\\n\".\n                    \"lsequence\\t$readinfo{'lsequence'}\\n\"\n                );\n                if ($seqno < $contiginfo{'seqnum'}) {\n                    $self->_print(\"\\n\");\n                } elsif (($seqno == $contiginfo{'seqnum'}) && ($i+1 < $numobj)) {\n                    $self->_print(\"|\\n\");\n                }\n            }\n        }\n    }\n    return 1;\n}\n\n=head2 _perc_N\n\n    Title   : _perc_N\n    Usage   : my $perc_N = $ass_io->_perc_N($sequence_string)\n    Function: Calculate the percent of ambiguities in a sequence.\n              M R W S Y K X N are regarded as ambiguites in an aligned read\n              sequence by TIGR Assembler. In the case of a gapped contig\n              consensus sequence, all lowercase symbols are ambiguities, i.e.:\n              a c g t u m r w s y k x n.\n    Returns : decimal number\n    Args    : string\n\n\nsub _perc_N {\n    my ($self, $seq_string) = @_;\n    $self->throw(\"Cannot accept an empty sequence\") if length($seq_string) == 0;\n    my $perc_N = 0;\n    for my $base ( split //, $seq_string ) {\n        # individual base matches an ambiguity?\n        if (( $base =~ m/[x|n|m|r|w|s|y|k]/i ) || ( $base =~ m/[a|c|g|t|u]/ ) ) {\n            $perc_N++;\n        }\n    }\n    $perc_N = $perc_N * 100 / length $seq_string;\n    return $perc_N;\n}\n\n=head2 _redundancy\n\n    Title   : _redundancy\n    Usage   : my $ref = $ass_io->_redundancy($contigobj)\n    Function: Calculate the fold coverage (redundancy) of a contig consensus\n              (average number of read base pairs covering the consensus)\n    Returns : decimal number\n    Args    : Bio::Assembly::Contig\n\n\nsub _redundancy {\n    # redundancy = (sum of all aligned read lengths - ( number of gaps in gapped\n    # consensus + number of gaps in aligned reads that are also in the consensus ) )\n    # / length of ungapped consensus\n    my ($self, $contigobj) = @_;\n    my $redundancy = 0;\n    \n    # sum of all aligned read lengths\n    my $read_tot = 0;\n    for my $readobj ( $contigobj->each_seq ) {\n        my $read_length = length($readobj->seq);\n        $read_tot += $read_length;\n    }\n    $redundancy += $read_tot;\n    \n    # - respected gaps\n    my $consensus_sequence = $contigobj->get_consensus_sequence->seq;\n    my @consensus_gaps = ();\n    $contigobj->_register_gaps($consensus_sequence, \\@consensus_gaps);\n    my $respected_gaps = scalar(@consensus_gaps);\n    if ($respected_gaps > 0) {\n        my @cons_arr = split //, $consensus_sequence;\n        for my $gap_pos_cons ( @consensus_gaps ) {\n            for my $readobj ( $contigobj->each_seq ) {\n                my $readid = $readobj->id;\n                my $read_start = $contigobj->change_coord(\n                    \"aligned $readid\", 'gapped consensus', $readobj->start);\n                my $read_end   = $contigobj->change_coord(\n                    \"aligned $readid\", 'gapped consensus', $readobj->end  );\n                # skip this if consensus gap position not within in the read boundaries\n                next if ( ($gap_pos_cons < $read_start)\n                    || ($gap_pos_cons > $read_end) );\n                # does the read position have read have a gap?\n                my @read_arr = split //, $readobj->seq;                \n                my $gap_pos_read = $contigobj->change_coord(\n                    'gapped consensus', \"aligned $readid\", $gap_pos_cons);\n                if ($read_arr[$gap_pos_read-1] eq $cons_arr[$gap_pos_cons-1]) {\n                    $respected_gaps++;\n                }\n            }\n        }\n    }\n    $redundancy -= $respected_gaps;\n    \n    # / length of ungapped consensus\n    my $contig_length = length($self->_ungap($contigobj->get_consensus_sequence->seq));\n    $redundancy /= $contig_length;\n    \n    return $redundancy;\n}\n\n=head2 _ungap\n\n    Title   : _ungap\n    Usage   : my $ungapped = $ass_io->_ungap($gapped)\n    Function: Remove the gaps from a sequence. Gaps are - in TIGR Assembler\n    Returns : string\n    Args    : string\n\n\nsub _ungap {\n    my ($self, $seq_string) = @_;\n    $seq_string =~ s/-//g;\n    return $seq_string;\n}\n\n=head2 _date_time\n\n    Title   : _date_time\n    Usage   : my $timepoint = $ass_io->date_time\n    Function: Get date and time (MM//DD/YY HH:MM:SS)\n    Returns : string\n    Args    : none\n\n\nsub _date_time {\n    my ($self) = @_;\n    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);\n    my $formatted_date_time = \n        sprintf('%02d', $mon+1).'/'.\n        sprintf('%02d', $mday).'/'.\n        sprintf('%02d', $year % 100).\n        ' '.\n        sprintf('%02d', $hour).':'.\n        sprintf('%02d', $min).':'.\n        sprintf('%02d',$sec)\n    ;\n    return $formatted_date_time;\n}\n\n=head2 _split_seq_name_and_db\n\n    Title   : _split_seq_name_and_db\n    Usage   : my ($seqname, $db) = $ass_io->_split_seq_name_and_db($id)\n    Function: Extract seq_name and db from sequence id\n    Returns : seq_name, db\n    Args    : id\n\n\nsub _split_seq_name_and_db {\n    my ($self, $id) = @_;\n    my $seq_name = '';\n    my $db       = '';\n    if ($id =~ m/(\\S+)\\|(\\S+)/) {\n        $db       = $1;\n        $seq_name = $2;\n    } else {\n        $seq_name = $id;\n    }\n    return ($seq_name, $db);\n}\n\n=head2 _merge_seq_name_and_db\n\n    Title   : _merge_seq_name_and_db\n    Usage   : my $id = $ass_io->_merge_seq_name_and_db($seq_name, $db)\n    Function: Construct id from seq_name and db\n    Returns : id\n    Args    : seq_name, db\n\n\nsub _merge_seq_name_and_db {\n    my ($self, $seq_name, $db) = @_;\n    my $id = '';\n    if ($db) {\n        $id = $db.'|'.$seq_name;\n    } else {\n        $id = $seq_name;\n    }\n    return $id;\n}\n\n=head2 _coord\n\n    Title   : _coord\n    Usage   : my $id = $ass_io->__coord($readobj, $contigobj)\n    Function: Get different coordinates for the read\n    Returns : number, number, number, number, number\n    Args    : Bio::Assembly::Seq, Bio::Assembly::Contig","parameters":[{"label":"$self"},{"label":"$readobj"},{"label":"$contigobj"}],"label":"_coord($self,$readobj,$contigobj)"},"kind":12,"line":1130,"children":[{"kind":13,"line":1131,"name":"$self","definition":"my","containerName":"_coord","localvar":"my"},{"line":1131,"kind":13,"name":"$readobj","containerName":"_coord"},{"name":"$contigobj","containerName":"_coord","kind":13,"line":1131},{"localvar":"my","name":"$asm_lend","definition":"my","containerName":"_coord","line":1132,"kind":13},{"line":1132,"kind":13,"containerName":"_coord","name":"$asm_rend"},{"containerName":"_coord","name":"$seq_lend","line":1132,"kind":13},{"line":1132,"kind":13,"containerName":"_coord","name":"$seq_rend"},{"kind":13,"line":1132,"name":"$offset","containerName":"_coord"},{"line":1136,"kind":13,"localvar":"my","name":"$aln_lend","definition":"my","containerName":"_coord"},{"name":"$contigobj","containerName":"_coord","line":1136,"kind":13},{"line":1136,"kind":12,"name":"get_seq_coord","containerName":"_coord"},{"kind":13,"line":1136,"containerName":"_coord","name":"$readobj"},{"name":"location","containerName":"_coord","line":1136,"kind":12},{"line":1136,"kind":12,"containerName":"_coord","name":"start"},{"localvar":"my","containerName":"_coord","definition":"my","name":"$aln_rend","line":1137,"kind":13},{"kind":13,"line":1137,"containerName":"_coord","name":"$contigobj"},{"line":1137,"kind":12,"name":"get_seq_coord","containerName":"_coord"},{"kind":13,"line":1137,"name":"$readobj","containerName":"_coord"},{"containerName":"_coord","name":"location","line":1137,"kind":12},{"containerName":"_coord","name":"end","line":1137,"kind":12},{"containerName":"_coord","name":"$asm_lend","kind":13,"line":1138},{"line":1138,"kind":13,"name":"$contigobj","containerName":"_coord"},{"name":"change_coord","containerName":"_coord","kind":12,"line":1138},{"containerName":"_coord","name":"$aln_lend","kind":13,"line":1139},{"containerName":"_coord","name":"$asm_rend","line":1140,"kind":13},{"line":1140,"kind":13,"name":"$contigobj","containerName":"_coord"},{"kind":12,"line":1140,"containerName":"_coord","name":"change_coord"},{"containerName":"_coord","name":"$aln_rend","kind":13,"line":1141},{"containerName":"_coord","name":"$readclip","definition":"my","localvar":"my","kind":13,"line":1145},{"name":"primary_tag","containerName":"_coord","kind":12,"line":1146},{"name":"$readobj","containerName":"_coord","line":1146,"kind":13},{"containerName":"_coord","name":"primary_id","kind":12,"line":1146},{"containerName":"_coord","name":"$contigobj","kind":13,"line":1147},{"line":1147,"kind":12,"containerName":"_coord","name":"get_features_collection"},{"kind":12,"line":1148,"containerName":"_coord","name":"get_all_features"},{"line":1149,"kind":13,"localvar":"my","definition":"my","name":"$clip_lend","containerName":"_coord"},{"containerName":"_coord","name":"$readclip","kind":13,"line":1149},{"kind":12,"line":1149,"name":"location","containerName":"_coord"},{"kind":12,"line":1149,"containerName":"_coord","name":"start"},{"localvar":"my","name":"$clip_rend","definition":"my","containerName":"_coord","line":1150,"kind":13},{"containerName":"_coord","name":"$readclip","kind":13,"line":1150},{"containerName":"_coord","name":"location","line":1150,"kind":12},{"kind":12,"line":1150,"containerName":"_coord","name":"end"},{"kind":13,"line":1151,"containerName":"_coord","name":"$seq_lend"},{"containerName":"_coord","name":"$contigobj","line":1151,"kind":13},{"kind":12,"line":1151,"name":"change_coord","containerName":"_coord"},{"name":"$readobj","containerName":"_coord","line":1152,"kind":13},{"containerName":"_coord","name":"id","line":1152,"kind":12},{"containerName":"_coord","name":"$clip_lend","line":1152,"kind":13},{"kind":13,"line":1153,"name":"$seq_rend","containerName":"_coord"},{"line":1153,"kind":13,"containerName":"_coord","name":"$contigobj"},{"line":1153,"kind":12,"containerName":"_coord","name":"change_coord"},{"name":"$readobj","containerName":"_coord","line":1154,"kind":13},{"line":1154,"kind":12,"containerName":"_coord","name":"id"},{"kind":13,"line":1154,"name":"$clip_rend","containerName":"_coord"},{"containerName":"_coord","name":"$offset","line":1157,"kind":13},{"containerName":"_coord","name":"$aln_lend","line":1157,"kind":13},{"line":1159,"kind":13,"name":"$asm_lend","containerName":"_coord"},{"line":1159,"kind":13,"containerName":"_coord","name":"$asm_rend"},{"name":"$seq_lend","containerName":"_coord","line":1159,"kind":13},{"line":1159,"kind":13,"name":"$seq_rend","containerName":"_coord"},{"line":1159,"kind":13,"name":"$offset","containerName":"_coord"}],"name":"_coord","range":{"end":{"line":1160,"character":9999},"start":{"line":1130,"character":0}}}],"version":5}