{"version":5,"vars":[{"line":85,"kind":2,"name":"base","containerName":""},{"name":"new","range":{"start":{"character":0,"line":100},"end":{"line":111,"character":9999}},"kind":12,"children":[{"line":101,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"new"},{"kind":13,"line":101,"name":"@args","containerName":"new"},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":102,"kind":13},{"line":102,"kind":13,"name":"$class","containerName":"new"},{"kind":13,"line":102,"containerName":"new","name":"@args"},{"kind":13,"line":104,"definition":"my","name":"$contigOBJ","containerName":"new","localvar":"my"},{"containerName":"new","name":"$self","line":104,"kind":13},{"containerName":"new","name":"_rearrange","line":104,"kind":12},{"kind":13,"line":104,"containerName":"new","name":"@args"},{"kind":13,"line":105,"name":"$contigOBJ","containerName":"new"},{"containerName":"new","name":"isa","line":105,"kind":12},{"containerName":"new","name":"$self","kind":13,"line":106},{"name":"throw","containerName":"new","kind":12,"line":106},{"line":109,"kind":13,"containerName":"new","name":"$self"},{"name":"$contigOBJ","containerName":"new","line":109,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":110}],"line":100,"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"__END__\n# $Id: ContigAnalysis.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::ContigAnalysis\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::ContigAnalysis - \n    Perform analysis on sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::ContigAnalysis;\n\n    # Assembly loading methods\n    my $ca = Bio::Assembly::ContigAnalysis->new( -contig=>$contigOBJ );\n\n    my @lcq = $ca->low_consensus_quality;\n    my @hqd = $ca->high_quality_discrepancies;\n    my @ss  = $ca->single_strand_regions;\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, when\nthe sequences in a pair may be aligned. It may also include a\nconsensus sequence. Bio::Assembly::ContigAnalysis is a module\nholding a collection of methods to analyze contig objects. It was\ndeveloped around the Bio::Assembly::Contig implementation of contigs and\ncan not work with another contig interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nEmail: rfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::ContigAnalysis;\n\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::ContigAnalysis->new(-contig=>$contigOBJ);\n Function  : Creates a new contig analysis object\n Returns   : Bio::Assembly::ContigAnalysis\n Args      :\n             -contig : a Bio::Assembly::Contig object"},"detail":"($class,@args)"},{"kind":12,"line":102,"containerName":"new","name":"SUPER"},{"kind":12,"children":[{"localvar":"my","containerName":"high_quality_discrepancies","name":"$self","definition":"my","line":145,"kind":13},{"containerName":"high_quality_discrepancies","name":"@args","kind":13,"line":145},{"line":147,"kind":13,"localvar":"my","definition":"my","name":"$threshold","containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","name":"$ignore","line":147,"kind":13},{"name":"$start","containerName":"high_quality_discrepancies","kind":13,"line":147},{"name":"$end","containerName":"high_quality_discrepancies","kind":13,"line":147},{"name":"$type","containerName":"high_quality_discrepancies","kind":13,"line":147},{"kind":13,"line":148,"containerName":"high_quality_discrepancies","name":"$self"},{"containerName":"high_quality_discrepancies","name":"_rearrange","line":148,"kind":12},{"kind":13,"line":148,"containerName":"high_quality_discrepancies","name":"@args"},{"name":"$threshold","containerName":"high_quality_discrepancies","line":151,"kind":13},{"containerName":"high_quality_discrepancies","name":"$threshold","line":151,"kind":13},{"kind":13,"line":152,"name":"$ignore","containerName":"high_quality_discrepancies"},{"line":152,"kind":13,"name":"$ignore","containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","name":"$type","line":153,"kind":13},{"name":"$type","containerName":"high_quality_discrepancies","line":153,"kind":13},{"name":"$start","containerName":"high_quality_discrepancies","kind":13,"line":156},{"name":"$type","containerName":"high_quality_discrepancies","line":156,"kind":13},{"kind":13,"line":157,"name":"$start","containerName":"high_quality_discrepancies"},{"line":157,"kind":13,"containerName":"high_quality_discrepancies","name":"$self"},{"containerName":"high_quality_discrepancies","name":"change_coord","line":157,"kind":12},{"kind":13,"line":157,"name":"$type","containerName":"high_quality_discrepancies"},{"line":157,"kind":13,"name":"$start","containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","name":"$start","kind":13,"line":158},{"kind":13,"line":159,"containerName":"high_quality_discrepancies","name":"$start"},{"containerName":"high_quality_discrepancies","name":"$end","line":161,"kind":13},{"line":161,"kind":13,"name":"$type","containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","name":"$end","line":162,"kind":13},{"kind":13,"line":162,"containerName":"high_quality_discrepancies","name":"$self"},{"line":162,"kind":12,"containerName":"high_quality_discrepancies","name":"change_coord"},{"kind":13,"line":162,"name":"$type","containerName":"high_quality_discrepancies"},{"name":"$end","containerName":"high_quality_discrepancies","kind":13,"line":162},{"kind":13,"line":163,"name":"$end","containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","name":"$end","line":164,"kind":13},{"kind":13,"line":164,"containerName":"high_quality_discrepancies","name":"$self"},{"name":"get_consensus_length","containerName":"high_quality_discrepancies","line":164,"kind":12},{"line":169,"kind":13,"localvar":"my","containerName":"high_quality_discrepancies","name":"@seqIDs","definition":"my"},{"containerName":"high_quality_discrepancies","name":"$self","kind":13,"line":169},{"line":169,"kind":12,"name":"get_seq_ids","containerName":"high_quality_discrepancies"},{"line":169,"kind":13,"containerName":"high_quality_discrepancies","name":"$start"},{"kind":13,"line":170,"name":"$end","containerName":"high_quality_discrepancies"},{"line":171,"kind":13,"containerName":"high_quality_discrepancies","name":"$type"},{"line":172,"kind":13,"localvar":"my","containerName":"high_quality_discrepancies","name":"$consensus","definition":"my"},{"name":"$self","containerName":"high_quality_discrepancies","kind":13,"line":172},{"kind":12,"line":172,"name":"get_consensus_sequence","containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","name":"seq","line":172,"kind":12},{"kind":13,"line":174,"containerName":"high_quality_discrepancies","name":"@HQD","definition":"my","localvar":"my"},{"line":175,"kind":13,"localvar":"my","definition":"my","name":"$seqID","containerName":"high_quality_discrepancies"},{"line":175,"kind":13,"name":"@seqIDs","containerName":"high_quality_discrepancies"},{"kind":13,"line":177,"containerName":"high_quality_discrepancies","name":"$seq","definition":"my","localvar":"my"},{"line":177,"kind":13,"name":"$self","containerName":"high_quality_discrepancies"},{"line":177,"kind":12,"name":"get_seq_by_name","containerName":"high_quality_discrepancies"},{"line":177,"kind":13,"containerName":"high_quality_discrepancies","name":"$seqID"},{"localvar":"my","containerName":"high_quality_discrepancies","definition":"my","name":"$qual","line":178,"kind":13},{"kind":13,"line":178,"containerName":"high_quality_discrepancies","name":"$self"},{"kind":12,"line":178,"containerName":"high_quality_discrepancies","name":"get_qual_by_name"},{"containerName":"high_quality_discrepancies","name":"$seqID","kind":13,"line":178},{"name":"$qual","containerName":"high_quality_discrepancies","kind":13,"line":179},{"line":180,"kind":13,"containerName":"high_quality_discrepancies","name":"$self"},{"containerName":"high_quality_discrepancies","name":"warn","kind":12,"line":180},{"kind":13,"line":183,"name":"$sequence","definition":"my","containerName":"high_quality_discrepancies","localvar":"my"},{"line":183,"kind":13,"name":"$seq","containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","name":"seq","line":183,"kind":12},{"localvar":"my","definition":"my","name":"@quality","containerName":"high_quality_discrepancies","line":184,"kind":13},{"kind":13,"line":184,"name":"$qual","containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","name":"qual","line":184,"kind":12},{"localvar":"my","containerName":"high_quality_discrepancies","name":"$seq_ix","definition":"my","line":187,"kind":13},{"name":"$coord","definition":"my","containerName":"high_quality_discrepancies","localvar":"my","kind":13,"line":188},{"line":188,"kind":13,"containerName":"high_quality_discrepancies","name":"$self"},{"name":"get_seq_feat_by_tag","containerName":"high_quality_discrepancies","line":188,"kind":12},{"name":"$seq","containerName":"high_quality_discrepancies","line":188,"kind":13},{"line":189,"kind":13,"name":"$coord","containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","name":"$self","line":190,"kind":13},{"containerName":"high_quality_discrepancies","name":"warn","kind":12,"line":190},{"kind":13,"line":193,"name":"$astart","definition":"my","containerName":"high_quality_discrepancies","localvar":"my"},{"line":193,"kind":13,"containerName":"high_quality_discrepancies","name":"$aend"},{"containerName":"high_quality_discrepancies","name":"$coord","kind":13,"line":193},{"kind":12,"line":193,"name":"start","containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","name":"$coord","kind":13,"line":193},{"name":"end","containerName":"high_quality_discrepancies","kind":12,"line":193},{"name":"$astart","containerName":"high_quality_discrepancies","kind":13,"line":194},{"line":194,"kind":13,"name":"$astart","containerName":"high_quality_discrepancies"},{"kind":13,"line":194,"containerName":"high_quality_discrepancies","name":"$ignore"},{"line":195,"kind":13,"name":"$aend","containerName":"high_quality_discrepancies"},{"kind":13,"line":195,"containerName":"high_quality_discrepancies","name":"$aend"},{"kind":13,"line":195,"containerName":"high_quality_discrepancies","name":"$ignore"},{"localvar":"my","containerName":"high_quality_discrepancies","name":"$d_start","definition":"my","line":197,"kind":13},{"line":197,"kind":13,"containerName":"high_quality_discrepancies","name":"$d_end"},{"kind":13,"line":197,"containerName":"high_quality_discrepancies","name":"$i"},{"name":"$i","containerName":"high_quality_discrepancies","line":198,"kind":13},{"containerName":"high_quality_discrepancies","name":"$astart","line":198,"kind":13},{"kind":13,"line":198,"containerName":"high_quality_discrepancies","name":"$i"},{"name":"$aend","containerName":"high_quality_discrepancies","kind":13,"line":198},{"containerName":"high_quality_discrepancies","name":"$i","line":198,"kind":13},{"line":200,"kind":13,"containerName":"high_quality_discrepancies","name":"$seq_ix"},{"containerName":"high_quality_discrepancies","name":"$self","line":200,"kind":13},{"kind":12,"line":200,"name":"change_coord","containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","name":"$i","line":200,"kind":13},{"name":"$i","containerName":"high_quality_discrepancies","line":201,"kind":13},{"name":"$start","containerName":"high_quality_discrepancies","line":201,"kind":13},{"kind":13,"line":201,"containerName":"high_quality_discrepancies","name":"$i"},{"line":201,"kind":13,"containerName":"high_quality_discrepancies","name":"$end"},{"kind":13,"line":203,"containerName":"high_quality_discrepancies","name":"$r_base","definition":"my","localvar":"my"},{"line":203,"kind":13,"name":"$sequence","containerName":"high_quality_discrepancies"},{"line":203,"kind":13,"containerName":"high_quality_discrepancies","name":"$seq_ix"},{"line":204,"kind":13,"localvar":"my","containerName":"high_quality_discrepancies","name":"$c_base","definition":"my"},{"kind":13,"line":204,"name":"$consensus","containerName":"high_quality_discrepancies"},{"name":"$i","containerName":"high_quality_discrepancies","kind":13,"line":204},{"kind":13,"line":207,"name":"$d_start","containerName":"high_quality_discrepancies"},{"name":"$r_base","containerName":"high_quality_discrepancies","kind":13,"line":208},{"name":"$c_base","containerName":"high_quality_discrepancies","kind":13,"line":208},{"line":209,"kind":13,"containerName":"high_quality_discrepancies","name":"$quality"},{"line":209,"kind":13,"containerName":"high_quality_discrepancies","name":"$seq_ix"},{"line":209,"kind":13,"name":"$threshold","containerName":"high_quality_discrepancies"},{"kind":13,"line":210,"containerName":"high_quality_discrepancies","name":"$d_start"},{"containerName":"high_quality_discrepancies","name":"$self","kind":13,"line":210},{"line":210,"kind":12,"name":"change_coord","containerName":"high_quality_discrepancies"},{"kind":13,"line":210,"containerName":"high_quality_discrepancies","name":"$i"},{"line":216,"kind":13,"name":"$d_start","containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","name":"$quality","line":217,"kind":13},{"containerName":"high_quality_discrepancies","name":"$seq_ix","line":217,"kind":13},{"line":217,"kind":13,"containerName":"high_quality_discrepancies","name":"$threshold"},{"line":218,"kind":13,"containerName":"high_quality_discrepancies","name":"$r_base"},{"kind":13,"line":218,"name":"$c_base","containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","name":"$d_end","line":219,"kind":13},{"line":219,"kind":13,"name":"$self","containerName":"high_quality_discrepancies"},{"line":219,"kind":12,"containerName":"high_quality_discrepancies","name":"change_coord"},{"line":219,"kind":13,"name":"$i","containerName":"high_quality_discrepancies"},{"name":"@HQD","containerName":"high_quality_discrepancies","kind":13,"line":221},{"containerName":"high_quality_discrepancies","name":"new","kind":12,"line":221},{"kind":13,"line":222,"containerName":"high_quality_discrepancies","name":"$d_start"},{"line":223,"kind":13,"containerName":"high_quality_discrepancies","name":"$d_end"},{"name":"$seq","containerName":"high_quality_discrepancies","line":224,"kind":13},{"containerName":"high_quality_discrepancies","name":"strand","kind":12,"line":224},{"containerName":"high_quality_discrepancies","name":"$d_start","kind":13,"line":225},{"containerName":"high_quality_discrepancies","name":"$d_start","line":231,"kind":13},{"name":"$d_end","containerName":"high_quality_discrepancies","kind":13,"line":232},{"name":"$self","containerName":"high_quality_discrepancies","kind":13,"line":232},{"line":232,"kind":12,"name":"change_coord","containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","name":"$i","line":232,"kind":13},{"line":233,"kind":13,"name":"@HQD","containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","name":"new","kind":12,"line":233},{"name":"$d_start","containerName":"high_quality_discrepancies","kind":13,"line":234},{"line":235,"kind":13,"containerName":"high_quality_discrepancies","name":"$d_end"},{"line":236,"kind":13,"containerName":"high_quality_discrepancies","name":"$seq"},{"line":236,"kind":12,"containerName":"high_quality_discrepancies","name":"strand"}],"line":144,"name":"high_quality_discrepancies","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":238},"start":{"line":144,"character":0}}},{"name":"Bio","containerName":"SeqFeature::Generic","line":221,"kind":12},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":233},{"containerName":null,"name":"@HQD","line":240,"kind":13},{"containerName":"main::","definition":"sub","name":"low_consensus_quality","range":{"start":{"line":258,"character":0},"end":{"character":9999,"line":268}},"kind":12,"line":258,"children":[{"kind":13,"line":259,"containerName":"low_consensus_quality","definition":"my","name":"$self","localvar":"my"},{"containerName":"low_consensus_quality","name":"@args","line":259,"kind":13},{"line":261,"kind":13,"localvar":"my","definition":"my","name":"$threshold","containerName":"low_consensus_quality"},{"name":"$start","containerName":"low_consensus_quality","kind":13,"line":261},{"name":"$end","containerName":"low_consensus_quality","kind":13,"line":261},{"name":"$type","containerName":"low_consensus_quality","line":261,"kind":13},{"name":"$self","containerName":"low_consensus_quality","kind":13,"line":262},{"line":262,"kind":12,"name":"_rearrange","containerName":"low_consensus_quality"},{"kind":13,"line":262,"containerName":"low_consensus_quality","name":"@args"},{"kind":13,"line":265,"containerName":"low_consensus_quality","name":"$threshold"},{"name":"$threshold","containerName":"low_consensus_quality","line":265,"kind":13},{"containerName":"low_consensus_quality","definition":"my","name":"@quality","localvar":"my","kind":13,"line":268},{"containerName":"low_consensus_quality","name":"$self","kind":13,"line":268},{"containerName":"low_consensus_quality","name":"get_consensus_quality","kind":12,"line":268},{"kind":12,"line":268,"name":"qual","containerName":"low_consensus_quality"}]},{"line":271,"kind":13,"name":"$start","containerName":null},{"kind":13,"line":271,"containerName":null,"name":"$start"},{"name":"$start","containerName":null,"kind":13,"line":272},{"name":"$type","containerName":null,"kind":13,"line":272},{"containerName":null,"name":"%type","line":272,"kind":13},{"name":"$start","containerName":null,"kind":13,"line":273},{"name":"%self","containerName":null,"line":273,"kind":13},{"name":"change_coord","containerName":"main::","kind":12,"line":273},{"containerName":null,"name":"$type","line":273,"kind":13},{"name":"$start","containerName":null,"kind":13,"line":273},{"kind":13,"line":274,"name":"$end","containerName":null},{"kind":13,"line":274,"name":"%self","containerName":null},{"name":"change_coord","containerName":"main::","line":274,"kind":12},{"name":"$type","containerName":null,"kind":13,"line":274},{"line":274,"kind":13,"containerName":null,"name":"$end"},{"name":"$end","containerName":null,"line":274,"kind":13},{"line":276,"kind":13,"containerName":null,"name":"$end"},{"name":"%self","containerName":null,"line":276,"kind":13},{"line":276,"kind":12,"name":"get_consensus_length","containerName":"main::"},{"name":"$end","containerName":null,"kind":13,"line":276},{"definition":"my","name":"$lcq_start","containerName":null,"localvar":"my","kind":13,"line":280},{"containerName":null,"definition":"my","name":"$i","localvar":"my","kind":13,"line":281},{"containerName":null,"name":"@LCQ","kind":13,"line":281},{"kind":13,"line":282,"name":"$i","containerName":null},{"kind":13,"line":282,"name":"$start","containerName":null},{"containerName":null,"name":"$i","line":282,"kind":13},{"kind":13,"line":282,"name":"$end","containerName":null},{"containerName":null,"name":"%i","line":282,"kind":13},{"containerName":null,"name":"$lcq_start","kind":13,"line":284},{"containerName":null,"name":"@quality","kind":13,"line":284},{"line":284,"kind":13,"containerName":null,"name":"$i"},{"line":284,"kind":13,"containerName":null,"name":"$threshold"},{"name":"@quality","containerName":null,"kind":13,"line":284},{"line":284,"kind":13,"containerName":null,"name":"%i"},{"kind":13,"line":285,"name":"$lcq_start","containerName":null},{"name":"$i","containerName":null,"kind":13,"line":285},{"containerName":null,"name":"$lcq_start","kind":13,"line":286},{"name":"@quality","containerName":null,"line":286,"kind":13},{"kind":13,"line":286,"name":"$i","containerName":null},{"kind":13,"line":286,"containerName":null,"name":"%threshold"},{"name":"$lcq_start","containerName":null,"kind":13,"line":287},{"line":287,"kind":13,"name":"%self","containerName":null},{"containerName":"main::","name":"change_coord","kind":12,"line":287},{"kind":13,"line":287,"name":"$lcq_start","containerName":null},{"kind":13,"line":288,"containerName":null,"name":"$lcq_end","definition":"my","localvar":"my"},{"containerName":null,"name":"%self","kind":13,"line":288},{"name":"change_coord","containerName":"main::","kind":12,"line":288},{"line":288,"kind":13,"name":"$i","containerName":null},{"kind":13,"line":289,"containerName":null,"name":"@LCQ"},{"kind":12,"line":289,"containerName":"SeqFeature::Generic","name":"Bio"},{"line":289,"kind":12,"name":"new","containerName":"main::"},{"name":"$lcq_start","containerName":null,"kind":13,"line":289},{"line":290,"kind":13,"containerName":null,"name":"$lcq_end"},{"containerName":null,"name":"$lcq_start","line":292,"kind":13},{"name":"%lcq_start","containerName":null,"kind":13,"line":296},{"containerName":null,"name":"$lcq_start","kind":13,"line":297},{"name":"%self","containerName":null,"line":297,"kind":13},{"line":297,"kind":12,"name":"change_coord","containerName":"main::"},{"name":"$lcq_start","containerName":null,"kind":13,"line":297},{"kind":13,"line":298,"definition":"my","name":"$lcq_end","containerName":null,"localvar":"my"},{"containerName":null,"name":"%self","kind":13,"line":298},{"line":298,"kind":12,"name":"change_coord","containerName":"main::"},{"containerName":null,"name":"$i","kind":13,"line":298},{"line":299,"kind":13,"containerName":null,"name":"@LCQ"},{"line":299,"kind":12,"name":"Bio","containerName":"SeqFeature::Generic"},{"name":"new","containerName":"main::","kind":12,"line":299},{"name":"$lcq_start","containerName":null,"line":299,"kind":13},{"containerName":null,"name":"$lcq_end","kind":13,"line":300},{"kind":13,"line":304,"containerName":null,"name":"@LCQ"},{"containerName":"main::","name":"not_confirmed_on_both_strands","definition":"sub","range":{"end":{"line":402,"character":9999},"start":{"line":327,"character":0}},"kind":12,"line":327,"children":[{"line":328,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"not_confirmed_on_both_strands"},{"name":"@args","containerName":"not_confirmed_on_both_strands","line":328,"kind":13},{"localvar":"my","containerName":"not_confirmed_on_both_strands","definition":"my","name":"$start","line":330,"kind":13},{"name":"$end","containerName":"not_confirmed_on_both_strands","line":330,"kind":13},{"containerName":"not_confirmed_on_both_strands","name":"$type","kind":13,"line":330},{"kind":13,"line":331,"containerName":"not_confirmed_on_both_strands","name":"$self"},{"kind":12,"line":331,"containerName":"not_confirmed_on_both_strands","name":"_rearrange"},{"name":"@args","containerName":"not_confirmed_on_both_strands","line":331,"kind":13},{"line":334,"kind":13,"name":"$start","containerName":"not_confirmed_on_both_strands"},{"line":334,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$start"},{"containerName":"not_confirmed_on_both_strands","name":"$type","kind":13,"line":335},{"name":"$type","containerName":"not_confirmed_on_both_strands","line":335,"kind":13},{"kind":13,"line":336,"containerName":"not_confirmed_on_both_strands","name":"$start"},{"line":336,"kind":13,"name":"$self","containerName":"not_confirmed_on_both_strands"},{"containerName":"not_confirmed_on_both_strands","name":"change_coord","line":336,"kind":12},{"containerName":"not_confirmed_on_both_strands","name":"$type","line":336,"kind":13},{"name":"$start","containerName":"not_confirmed_on_both_strands","kind":13,"line":336},{"kind":13,"line":337,"containerName":"not_confirmed_on_both_strands","name":"$end"},{"kind":13,"line":337,"containerName":"not_confirmed_on_both_strands","name":"$self"},{"name":"change_coord","containerName":"not_confirmed_on_both_strands","line":337,"kind":12},{"containerName":"not_confirmed_on_both_strands","name":"$type","line":337,"kind":13},{"containerName":"not_confirmed_on_both_strands","name":"$end","kind":13,"line":337},{"name":"$end","containerName":"not_confirmed_on_both_strands","line":337,"kind":13},{"containerName":"not_confirmed_on_both_strands","name":"$end","kind":13,"line":339},{"line":339,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$self"},{"kind":12,"line":339,"name":"get_consensus_length","containerName":"not_confirmed_on_both_strands"},{"name":"$end","containerName":"not_confirmed_on_both_strands","kind":13,"line":339},{"line":342,"kind":13,"localvar":"my","containerName":"not_confirmed_on_both_strands","name":"%confirmed","definition":"my"},{"name":"$i","definition":"my","containerName":"not_confirmed_on_both_strands","localvar":"my","kind":13,"line":343},{"definition":"my","name":"$consensus","containerName":"not_confirmed_on_both_strands","localvar":"my","kind":13,"line":344},{"containerName":"not_confirmed_on_both_strands","name":"$self","kind":13,"line":344},{"line":344,"kind":12,"name":"get_consensus_sequence","containerName":"not_confirmed_on_both_strands"},{"name":"seq","containerName":"not_confirmed_on_both_strands","line":344,"kind":12},{"line":345,"kind":13,"localvar":"my","definition":"my","name":"$seqID","containerName":"not_confirmed_on_both_strands"},{"name":"$self","containerName":"not_confirmed_on_both_strands","line":345,"kind":13},{"line":345,"kind":12,"containerName":"not_confirmed_on_both_strands","name":"get_seq_ids"},{"kind":13,"line":347,"name":"$seq","definition":"my","containerName":"not_confirmed_on_both_strands","localvar":"my"},{"kind":13,"line":347,"name":"$self","containerName":"not_confirmed_on_both_strands"},{"kind":12,"line":347,"name":"get_seq_by_name","containerName":"not_confirmed_on_both_strands"},{"line":347,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$seqID"},{"line":348,"kind":13,"localvar":"my","definition":"my","name":"$sequence","containerName":"not_confirmed_on_both_strands"},{"name":"$seq","containerName":"not_confirmed_on_both_strands","line":348,"kind":13},{"name":"seq","containerName":"not_confirmed_on_both_strands","line":348,"kind":12},{"definition":"my","name":"$contig_ix","containerName":"not_confirmed_on_both_strands","localvar":"my","kind":13,"line":351},{"definition":"my","name":"$coord","containerName":"not_confirmed_on_both_strands","localvar":"my","kind":13,"line":352},{"containerName":"not_confirmed_on_both_strands","name":"$self","kind":13,"line":352},{"containerName":"not_confirmed_on_both_strands","name":"get_seq_feat_by_tag","line":352,"kind":12},{"line":352,"kind":13,"name":"$seq","containerName":"not_confirmed_on_both_strands"},{"containerName":"not_confirmed_on_both_strands","name":"$astart","definition":"my","localvar":"my","kind":13,"line":353},{"line":353,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$aend"},{"containerName":"not_confirmed_on_both_strands","name":"$orientation","kind":13,"line":353},{"kind":13,"line":353,"containerName":"not_confirmed_on_both_strands","name":"$coord"},{"line":353,"kind":12,"name":"start","containerName":"not_confirmed_on_both_strands"},{"line":353,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$coord"},{"containerName":"not_confirmed_on_both_strands","name":"end","line":353,"kind":12},{"containerName":"not_confirmed_on_both_strands","name":"$coord","line":353,"kind":13},{"kind":12,"line":353,"name":"strand","containerName":"not_confirmed_on_both_strands"},{"line":354,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$astart"},{"kind":13,"line":354,"containerName":"not_confirmed_on_both_strands","name":"$self"},{"line":354,"kind":12,"name":"change_coord","containerName":"not_confirmed_on_both_strands"},{"kind":13,"line":354,"name":"$astart","containerName":"not_confirmed_on_both_strands"},{"containerName":"not_confirmed_on_both_strands","name":"$aend","kind":13,"line":355},{"line":355,"kind":13,"name":"$self","containerName":"not_confirmed_on_both_strands"},{"line":355,"kind":12,"containerName":"not_confirmed_on_both_strands","name":"change_coord"},{"kind":13,"line":355,"name":"$aend","containerName":"not_confirmed_on_both_strands"},{"name":"$i","containerName":"not_confirmed_on_both_strands","line":356,"kind":13},{"containerName":"not_confirmed_on_both_strands","name":"$astart","line":356,"kind":13},{"containerName":"not_confirmed_on_both_strands","name":"$i","line":356,"kind":13},{"containerName":"not_confirmed_on_both_strands","name":"$aend","line":356,"kind":13},{"containerName":"not_confirmed_on_both_strands","name":"$i","kind":13,"line":356},{"kind":13,"line":358,"name":"$contig_ix","containerName":"not_confirmed_on_both_strands"},{"name":"$self","containerName":"not_confirmed_on_both_strands","kind":13,"line":358},{"name":"change_coord","containerName":"not_confirmed_on_both_strands","kind":12,"line":358},{"line":358,"kind":13,"name":"$i","containerName":"not_confirmed_on_both_strands"},{"name":"$contig_ix","containerName":"not_confirmed_on_both_strands","line":359,"kind":13},{"line":359,"kind":13,"name":"$start","containerName":"not_confirmed_on_both_strands"},{"line":359,"kind":13,"name":"$contig_ix","containerName":"not_confirmed_on_both_strands"},{"name":"$end","containerName":"not_confirmed_on_both_strands","kind":13,"line":359},{"definition":"my","name":"$r_base","containerName":"not_confirmed_on_both_strands","localvar":"my","kind":13,"line":360},{"name":"$sequence","containerName":"not_confirmed_on_both_strands","kind":13,"line":360},{"line":360,"kind":13,"name":"$i","containerName":"not_confirmed_on_both_strands"},{"line":361,"kind":13,"localvar":"my","containerName":"not_confirmed_on_both_strands","name":"$c_base","definition":"my"},{"containerName":"not_confirmed_on_both_strands","name":"$consensus","kind":13,"line":361},{"name":"$contig_ix","containerName":"not_confirmed_on_both_strands","line":361,"kind":13},{"kind":13,"line":362,"containerName":"not_confirmed_on_both_strands","name":"$c_base"},{"name":"$confirmed","containerName":"not_confirmed_on_both_strands","line":363,"kind":13},{"name":"$orientation","containerName":"not_confirmed_on_both_strands","kind":13,"line":363},{"kind":13,"line":363,"name":"$contig_ix","containerName":"not_confirmed_on_both_strands"},{"kind":13,"line":364,"name":"$r_base","containerName":"not_confirmed_on_both_strands"},{"name":"$c_base","containerName":"not_confirmed_on_both_strands","kind":13,"line":364},{"line":365,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$confirmed"},{"kind":13,"line":365,"name":"$orientation","containerName":"not_confirmed_on_both_strands"},{"line":365,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$contig_ix"},{"kind":13,"line":371,"definition":"my","name":"$orientation","containerName":"not_confirmed_on_both_strands","localvar":"my"},{"localvar":"my","containerName":"not_confirmed_on_both_strands","definition":"my","name":"@NCBS","line":372,"kind":13},{"kind":13,"line":373,"name":"$orientation","containerName":"not_confirmed_on_both_strands"},{"containerName":"not_confirmed_on_both_strands","name":"%confirmed","kind":13,"line":373},{"containerName":"not_confirmed_on_both_strands","definition":"my","name":"$ncbs_start","localvar":"my","kind":13,"line":374},{"kind":13,"line":374,"containerName":"not_confirmed_on_both_strands","name":"$ncbs_end"},{"containerName":"not_confirmed_on_both_strands","name":"$i","line":376,"kind":13},{"containerName":"not_confirmed_on_both_strands","name":"$start","kind":13,"line":376},{"containerName":"not_confirmed_on_both_strands","name":"$i","kind":13,"line":376},{"containerName":"not_confirmed_on_both_strands","name":"$end","line":376,"kind":13},{"line":376,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$i"},{"containerName":"not_confirmed_on_both_strands","name":"$ncbs_start","kind":13,"line":377},{"containerName":"not_confirmed_on_both_strands","name":"$confirmed","line":378,"kind":13},{"kind":13,"line":378,"name":"$orientation","containerName":"not_confirmed_on_both_strands"},{"kind":13,"line":378,"containerName":"not_confirmed_on_both_strands","name":"$i"},{"line":378,"kind":13,"name":"$confirmed","containerName":"not_confirmed_on_both_strands"},{"line":378,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$orientation"},{"kind":13,"line":378,"containerName":"not_confirmed_on_both_strands","name":"$i"},{"name":"$ncbs_start","containerName":"not_confirmed_on_both_strands","kind":13,"line":379},{"name":"$self","containerName":"not_confirmed_on_both_strands","line":379,"kind":13},{"kind":12,"line":379,"name":"change_coord","containerName":"not_confirmed_on_both_strands"},{"name":"$i","containerName":"not_confirmed_on_both_strands","line":379,"kind":13},{"line":380,"kind":13,"name":"$ncbs_start","containerName":"not_confirmed_on_both_strands"},{"containerName":"not_confirmed_on_both_strands","name":"$confirmed","line":381,"kind":13},{"kind":13,"line":381,"containerName":"not_confirmed_on_both_strands","name":"$orientation"},{"kind":13,"line":381,"name":"$i","containerName":"not_confirmed_on_both_strands"},{"name":"$confirmed","containerName":"not_confirmed_on_both_strands","line":382,"kind":13},{"containerName":"not_confirmed_on_both_strands","name":"$orientation","kind":13,"line":382},{"kind":13,"line":382,"containerName":"not_confirmed_on_both_strands","name":"$i"},{"kind":13,"line":383,"name":"$ncbs_end","containerName":"not_confirmed_on_both_strands"},{"containerName":"not_confirmed_on_both_strands","name":"$self","kind":13,"line":383},{"line":383,"kind":12,"name":"change_coord","containerName":"not_confirmed_on_both_strands"},{"name":"$i","containerName":"not_confirmed_on_both_strands","line":383,"kind":13},{"name":"@NCBS","containerName":"not_confirmed_on_both_strands","line":384,"kind":13},{"line":384,"kind":12,"containerName":"not_confirmed_on_both_strands","name":"new"},{"name":"$ncbs_start","containerName":"not_confirmed_on_both_strands","kind":13,"line":384},{"line":385,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$ncbs_end"},{"kind":13,"line":386,"containerName":"not_confirmed_on_both_strands","name":"$orientation"},{"line":388,"kind":13,"name":"$ncbs_start","containerName":"not_confirmed_on_both_strands"},{"name":"$ncbs_start","containerName":"not_confirmed_on_both_strands","line":392,"kind":13},{"containerName":"not_confirmed_on_both_strands","name":"$ncbs_end","line":393,"kind":13},{"kind":13,"line":393,"name":"$self","containerName":"not_confirmed_on_both_strands"},{"line":393,"kind":12,"name":"change_coord","containerName":"not_confirmed_on_both_strands"},{"containerName":"not_confirmed_on_both_strands","name":"$end","kind":13,"line":393},{"name":"@NCBS","containerName":"not_confirmed_on_both_strands","kind":13,"line":394},{"kind":12,"line":394,"containerName":"not_confirmed_on_both_strands","name":"new"},{"kind":13,"line":394,"name":"$ncbs_start","containerName":"not_confirmed_on_both_strands"},{"name":"$ncbs_end","containerName":"not_confirmed_on_both_strands","kind":13,"line":395},{"name":"$orientation","containerName":"not_confirmed_on_both_strands","line":396,"kind":13},{"containerName":"not_confirmed_on_both_strands","name":"@NCBS","line":401,"kind":13}]},{"name":"Bio","containerName":"SeqFeature::Generic","line":384,"kind":12},{"containerName":"SeqFeature::Generic","name":"Bio","kind":12,"line":394},{"kind":12,"line":424,"children":[{"line":425,"kind":13,"localvar":"my","containerName":"single_strand","definition":"my","name":"$self"},{"name":"@args","containerName":"single_strand","line":425,"kind":13},{"line":427,"kind":13,"localvar":"my","definition":"my","name":"$start","containerName":"single_strand"},{"name":"$end","containerName":"single_strand","line":427,"kind":13},{"containerName":"single_strand","name":"$type","line":427,"kind":13},{"line":428,"kind":13,"containerName":"single_strand","name":"$self"},{"name":"_rearrange","containerName":"single_strand","line":428,"kind":12},{"containerName":"single_strand","name":"@args","kind":13,"line":428},{"name":"$type","containerName":"single_strand","line":431,"kind":13},{"kind":13,"line":431,"name":"$type","containerName":"single_strand"},{"name":"$start","containerName":"single_strand","line":432,"kind":13},{"kind":13,"line":432,"containerName":"single_strand","name":"$start"},{"containerName":"single_strand","name":"$type","kind":13,"line":433},{"line":433,"kind":13,"name":"$type","containerName":"single_strand"},{"line":434,"kind":13,"name":"$start","containerName":"single_strand"},{"line":434,"kind":13,"name":"$self","containerName":"single_strand"},{"containerName":"single_strand","name":"change_coord","kind":12,"line":434},{"kind":13,"line":434,"containerName":"single_strand","name":"$type"},{"containerName":"single_strand","name":"$start","kind":13,"line":434},{"kind":13,"line":435,"name":"$end","containerName":"single_strand"},{"containerName":"single_strand","name":"$self","line":435,"kind":13},{"name":"change_coord","containerName":"single_strand","kind":12,"line":435},{"containerName":"single_strand","name":"$type","kind":13,"line":435},{"line":435,"kind":13,"name":"$end","containerName":"single_strand"},{"kind":13,"line":435,"containerName":"single_strand","name":"$end"},{"kind":13,"line":437,"containerName":"single_strand","name":"$end"},{"kind":13,"line":437,"containerName":"single_strand","name":"$self"},{"name":"get_consensus_length","containerName":"single_strand","kind":12,"line":437},{"containerName":"single_strand","name":"$end","line":437,"kind":13},{"localvar":"my","containerName":"single_strand","name":"$sfc","definition":"my","line":440,"kind":13},{"containerName":"single_strand","name":"$self","line":440,"kind":13},{"containerName":"single_strand","name":"get_features_collection","line":440,"kind":12},{"localvar":"my","containerName":"single_strand","name":"@forward","definition":"my","line":441,"kind":13},{"name":"primary_tag","containerName":"single_strand","line":441,"kind":12},{"name":"$sfc","containerName":"single_strand","line":442,"kind":13},{"line":442,"kind":12,"containerName":"single_strand","name":"features_in_range"},{"kind":13,"line":442,"name":"$start","containerName":"single_strand"},{"line":443,"kind":13,"name":"$end","containerName":"single_strand"},{"kind":13,"line":447,"containerName":"single_strand","definition":"my","name":"@reverse","localvar":"my"},{"containerName":"single_strand","name":"primary_tag","kind":12,"line":447},{"name":"$sfc","containerName":"single_strand","kind":13,"line":448},{"name":"features_in_range","containerName":"single_strand","line":448,"kind":12},{"kind":13,"line":448,"containerName":"single_strand","name":"$start"},{"containerName":"single_strand","name":"$end","kind":13,"line":449},{"containerName":"single_strand","name":"@forward","kind":13,"line":454},{"kind":13,"line":454,"name":"$self","containerName":"single_strand"},{"containerName":"single_strand","name":"_merge_overlapping_features","kind":12,"line":454},{"name":"@forward","containerName":"single_strand","kind":13,"line":454},{"line":455,"kind":13,"name":"@reverse","containerName":"single_strand"},{"kind":13,"line":455,"containerName":"single_strand","name":"$self"},{"kind":12,"line":455,"containerName":"single_strand","name":"_merge_overlapping_features"},{"line":455,"kind":13,"containerName":"single_strand","name":"@reverse"},{"containerName":"single_strand","name":"$length","definition":"my","localvar":"my","kind":13,"line":458},{"containerName":"single_strand","name":"$self","kind":13,"line":458},{"kind":12,"line":458,"containerName":"single_strand","name":"get_consensus_length"},{"kind":13,"line":459,"name":"$length","containerName":"single_strand"},{"containerName":"single_strand","name":"$self","line":459,"kind":13},{"kind":12,"line":459,"containerName":"single_strand","name":"change_coord"},{"line":459,"kind":13,"name":"$length","containerName":"single_strand"},{"kind":13,"line":460,"containerName":"single_strand","name":"@forward"},{"kind":13,"line":460,"name":"$self","containerName":"single_strand"},{"line":460,"kind":12,"name":"_complementary_features_list","containerName":"single_strand"},{"containerName":"single_strand","name":"$length","kind":13,"line":460},{"kind":13,"line":460,"containerName":"single_strand","name":"@forward"},{"kind":13,"line":461,"name":"@reverse","containerName":"single_strand"},{"line":461,"kind":13,"containerName":"single_strand","name":"$self"},{"name":"_complementary_features_list","containerName":"single_strand","line":461,"kind":12},{"line":461,"kind":13,"name":"$length","containerName":"single_strand"},{"line":461,"kind":13,"containerName":"single_strand","name":"@reverse"},{"kind":13,"line":463,"containerName":"single_strand","name":"@SS","definition":"my","localvar":"my"},{"line":464,"kind":13,"localvar":"my","containerName":"single_strand","name":"$feat","definition":"my"},{"name":"@forward","containerName":"single_strand","kind":13,"line":464},{"name":"@reverse","containerName":"single_strand","kind":13,"line":464},{"name":"$feat","containerName":"single_strand","line":465,"kind":13},{"line":465,"kind":12,"containerName":"single_strand","name":"primary_tag"},{"containerName":"single_strand","name":"@SS","line":466,"kind":13},{"kind":13,"line":466,"name":"$feat","containerName":"single_strand"},{"kind":13,"line":469,"containerName":"single_strand","name":"@SS"}],"containerName":"main::","definition":"sub","name":"single_strand","range":{"start":{"character":0,"line":424},"end":{"line":470,"character":9999}}},{"range":{"start":{"line":485,"character":0},"end":{"line":489,"character":9999}},"name":"_merge_overlapping_features","signature":{"parameters":[{"label":"$self"},{"label":"@feat"}],"documentation":"__END__\n# $Id: ContigAnalysis.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::ContigAnalysis\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::ContigAnalysis - \n    Perform analysis on sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::ContigAnalysis;\n\n    # Assembly loading methods\n    my $ca = Bio::Assembly::ContigAnalysis->new( -contig=>$contigOBJ );\n\n    my @lcq = $ca->low_consensus_quality;\n    my @hqd = $ca->high_quality_discrepancies;\n    my @ss  = $ca->single_strand_regions;\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, when\nthe sequences in a pair may be aligned. It may also include a\nconsensus sequence. Bio::Assembly::ContigAnalysis is a module\nholding a collection of methods to analyze contig objects. It was\ndeveloped around the Bio::Assembly::Contig implementation of contigs and\ncan not work with another contig interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nEmail: rfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::ContigAnalysis;\n\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::ContigAnalysis->new(-contig=>$contigOBJ);\n Function  : Creates a new contig analysis object\n Returns   : Bio::Assembly::ContigAnalysis\n Args      :\n             -contig : a Bio::Assembly::Contig object\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($contigOBJ) = $self->_rearrange([qw(CONTIG)],@args);\n    unless ($contigOBJ->isa(\"Bio::Assembly::Contig\")) {\n\t$self->throw(\"ContigAnal works only on Bio::Assembly::Contig objects\\n\");\n    }\n\n    $self->{'_objref'} = $contigOBJ;\n    return $self;\n}\n\n=head1 Analysis methods\n\n=head2 high_quality_discrepancies\n\n Title     : high_quality_discrepancies\n Usage     : my $sfc = $ContigAnal->high_quality_discrepancies();\n Function  : \n\n             Locates all high quality discrepancies among aligned\n             sequences and the consensus sequence.\n\n             Note: see Bio::Assembly::Contig POD documentation,\n             section \"Coordinate System\", for a definition of\n             available types. Default coordinate system type is\n             \"gapped consensus\", i.e. consensus sequence (with gaps)\n             coordinates. If limits are not specified, the entire\n             alignment is analyzed.\n\n Returns   : Bio::SeqFeature::Collection\n Args      : optional arguments are\n             -threshold : cutoff value for low quality (minimum high quality)\n                          Default: 40\n             -ignore    : number of bases that will not be analysed at\n                          both ends of contig aligned elements\n                          Default: 5\n             -start     : start of interval that will be analyzed\n             -end       : start of interval that will be analyzed\n             -type      : coordinate system type for interval\n\n\nsub high_quality_discrepancies {\n    my ($self,@args) = shift; # Package reference\n\n    my ($threshold,$ignore,$start,$end,$type) = \n\t$self->_rearrange([qw(THRESHOLD IGNORE START END TYPE)],@args);\n\n    # Defining default threhold and HQD_ignore\n    $threshold  = 40 unless (defined($threshold));\n    $ignore = 5  unless (defined($ignore));\n    $type = 'gapped consensus' unless (defined($type));\n\n    # Changing input coordinates system (if needed)\n    if (defined $start && $type ne 'gapped consensus') {\n\t$start = $self->{'_objref'}->change_coord($type,'gapped consensus',$start);\n    } elsif (!defined $start) {\n\t$start = 1;\n    }\n    if (defined $end && $type ne 'gapped consensus') {\n\t$end = $self->{'_objref'}->change_coord($type,'gapped consensus',$end);\n    } elsif (!defined $end) {\n\t$end = $self->{'_objref'}->get_consensus_length();\n    }\n\n    # Scanning each read sequence and the contig sequence and\n    # adding discrepancies to Bio::SeqFeature::Collection\n    my @seqIDs = $self->{'_objref'}->get_seq_ids(-start=>$start,\n\t\t\t\t\t\t -end=>$end,\n\t\t\t\t\t\t -type=>$type);\n    my $consensus = $self->{'_objref'}->get_consensus_sequence()->seq;\n\n    my @HQD = ();\n    foreach my $seqID (@seqIDs) {\n\t# Setting aligned read sub-sequence limits and loading data\n\tmy $seq  = $self->{'_objref'}->get_seq_by_name($seqID);\n\tmy $qual = $self->{'_objref'}->get_qual_by_name($seqID);\n\tunless (defined $qual) {\n\t    $self->warn(\"Can't correctly evaluate HQD without aligned sequence qualities for $seqID\");\n\t    next;\n\t}\n\tmy $sequence = $seq->seq;\n\tmy @quality  = @{ $qual->qual };\n\n\t# Scanning the aligned region of each read\n\tmy $seq_ix = 0;\n\tmy $coord = $self->{'_objref'}->get_seq_feat_by_tag($seq,\"_align_clipping:$seqID\");\n    if (!$coord) {\n        $self->warn(\"Read $seqID has no alignment coordinates; considered low quality.\\nSkipping...\");\n        next;\n    }\n\tmy ($astart,$aend) = ($coord->start,$coord->end);\n\t$astart = $astart + $ignore; # Redefining limits to evaluate HQDs (jump $ignore at start)\n\t$aend   = $aend   - $ignore; # Redefining limits to evaluate HQDs (stop $ignore before end)\n\n\tmy ($d_start,$d_end,$i);\n\tfor ($i=$astart-1; $i<=$aend-1; $i++) {\n\t    # Changing coordinate $i+1 from 'gapped consensus' mode to \"aligned $seqID\" (coordinate $seq_ix)\n\t    $seq_ix = $self->{'_objref'}->change_coord('gapped consensus',\"aligned $seqID\",$i+1);\n\t    next unless (($i >= $start) && ($i <= $end));\n\n\t    my $r_base = uc(substr($sequence,$seq_ix-1,1));\n\t    my $c_base = uc(substr($consensus,$i,1));\n\n\t    # Discrepant region start: store $d_start and $type\n\t    (!defined($d_start) &&\n\t     ($r_base ne $c_base) &&\n\t     ($quality[$seq_ix-1] >= $threshold)) && do {\n\t\t $d_start = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i+1);\n\t\t #print $seqID,\" \",$r_base,\" \",$i+1,\" \",$c_base,\" \",$contig_ix-1,\" \",$quality[$i],\" $type\\n\";\n\t\t next;\n\t     };\n\n\t    # Quality change or end of discrepant region: store limits and undef $d_start\n\t    if (defined($d_start) &&\n\t\t(($quality[$seq_ix-1] < $threshold) ||\n\t\t (uc($r_base) eq uc($c_base)))) {\n\t\t$d_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\t\t#print $seqID,\" \",$r_base,\" \",$i+1,\" \",$c_base,\" \",$contig_ix-1,\" \",$quality[$i],\" $type\\n\";\n\t\tpush(@HQD, Bio::SeqFeature::Generic->new(-primary=>\"high_quality_discrepancy:$seqID\",\n\t\t\t\t\t\t\t -start=>$d_start,\n\t\t\t\t\t\t\t -end=>$d_end,\n\t\t\t\t\t\t\t -strand=>$seq->strand()) );\n\t\t$d_start = undef;\n\t\tnext;\n\t    }\n\t} # for ($i=$astart-1; $i<=$aend-1; $i++)\n\n\t# Loading discrepancies located at sub-sequence end, if any.\n\tif (defined($d_start)) {\n\t    $d_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\t    push(@HQD, Bio::SeqFeature::Generic->new(-primary=>\"high_quality_discrepancy:$seqID\",\n\t\t\t\t\t\t     -start=>$d_start,\n\t\t\t\t\t\t     -end=>$d_end,\n\t\t\t\t\t\t     -strand=>$seq->strand()) );\n\t}\n    } # foreach my $seqID (@seqIDs)\n\n    return @HQD;\n}\n\n=head2 low_consensus_quality\n\n Title     : low_consensus_quality\n Usage     : my $sfc = $ContigAnal->low_consensus_quality();\n Function  : Locates all low quality regions in the consensus\n Returns   : an array of Bio::SeqFeature::Generic objects\n Args      : optional arguments are\n             -threshold : cutoff value for low quality (minimum high quality)\n                          Default: 25\n             -start     : start of interval that will be analyzed\n             -end       : start of interval that will be analyzed\n             -type      : coordinate system type for interval\n\n\nsub low_consensus_quality {\n    my ($self,@args) = shift; # Packege reference\n\n    my ($threshold,$start,$end,$type) = \n\t$self->_rearrange([qw(THRESHOLD START END TYPE)],@args);\n\n    # Setting default value for threshold\n    $threshold = 25 unless (defined($threshold));\n\n    # Loading qualities\n    my @quality = @{ $self->{'_objref'}->get_consensus_quality()->qual };\n\n    # Changing coordinates to gap mode noaln (consed: consensus without alignments)\n    $start = 1 unless (defined($start));\n    if (defined $start && defined $type && ($type ne 'gapped consensus')) {\n\t$start = $self->{'objref'}->change_coord($type,'gapped consensus',$start);\n\t$end   = $self->{'objref'}->change_coord($type,'gapped consensus',$end) if (defined($end));\n    }\n    $end = $self->{'_objref'}->get_consensus_length unless (defined $end);\n\n    # Scanning @quality vector and storing intervals limits with base qualities less then\n    # the threshold value\n    my ($lcq_start);\n    my ($i,@LCQ);\n    for ($i=$start-1; $i<=$end-1; $i++) {\n#\tprint $quality[$i],\"\\t\",$i,\"\\n\";\n\tif (!defined($lcq_start) && (($quality[$i] <= $threshold) || ($quality[$i] == 98))) {\n\t    $lcq_start = $i+1;\n\t} elsif (defined($lcq_start) && ($quality[$i] > $threshold)) {\n\t    $lcq_start  = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$lcq_start);\n\t    my $lcq_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\t    push(@LCQ, Bio::SeqFeature::Generic->new(-start=>$lcq_start,\n\t\t\t\t\t\t     -end=>$lcq_end,\n\t\t\t\t\t\t     -primary=>'low_consensus_quality') );\n\t    $lcq_start = undef;\n\t}\n    }\n\n    if (defined $lcq_start) {\n\t$lcq_start  = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$lcq_start);\n\tmy $lcq_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\tpush(@LCQ, Bio::SeqFeature::Generic->new(-start=>$lcq_start,\n\t\t\t\t\t\t -end=>$lcq_end,\n\t\t\t\t\t\t -primary=>'low_consensus_quality') );\n    }\n\n    return @LCQ;\n}\n\n=head2 not_confirmed_on_both_strands\n\n Title     : low_quality_consensus\n Usage     : my $sfc = $ContigAnal->low_quality_consensus();\n Function  : \n\n             Locates all regions whose consensus bases were not\n             confirmed by bases from sequences aligned in both\n             orientations, i.e., in such regions, no bases in aligned\n             sequences of either +1 or -1 strand agree with the\n             consensus bases.\n\n Returns   : an array of Bio::SeqFeature::Generic objects\n Args      : optional arguments are\n             -start : start of interval that will be analyzed\n             -end   : start of interval that will be analyzed\n             -type  : coordinate system type for interval\n\n\nsub not_confirmed_on_both_strands {\n    my ($self,@args) = shift; # Package reference\n\n    my ($start,$end,$type) = \n\t$self->_rearrange([qw(START END TYPE)],@args);\n\n    # Changing coordinates to default system 'align' (contig sequence with alignments)\n    $start = 1 unless (defined($start));\n    if (defined($type) && ($type ne 'gapped consensus')) {\n\t$start = $self->{'_objref'}->change_coord($type,'gapped consensus',$start);\n\t$end   = $self->{'_objref'}->change_coord($type,'gapped consensus',$end) if (defined($end));\n    }\n    $end = $self->{'_objref'}->get_consensus_length unless (defined($end));\n\n    # Scanning alignment\n    my %confirmed = (); # If ($confirmed{$orientation}[$i] > 0) then $i is confirmed in $orientation strand\n    my ($i);\n    my $consensus = $self->{'_objref'}->get_consensus_sequence()->seq;\n    foreach my $seqID ($self->{'_objref'}->get_seq_ids) {\n\t# Setting aligned read sub-sequence limits and loading data\n\tmy $seq = $self->{'_objref'}->get_seq_by_name($seqID);\n\tmy $sequence = $seq->seq;\n\n\t# Scanning the aligned regions of each read and registering confirmed sites\n\tmy $contig_ix = 0;\n\tmy $coord = $self->{'_objref'}->get_seq_feat_by_tag($seq,\"_align_clipping:$seqID\");\n\tmy ($astart,$aend,$orientation) = ($coord->start,$coord->end,$coord->strand);\n\t$astart = $self->{'_objref'}->change_coord('gapped consensus',\"aligned $seqID\",$astart);\n\t$aend   = $self->{'_objref'}->change_coord('gapped consensus',\"aligned $seqID\",$aend);\n\tfor ($i=$astart-1; $i<=$aend-1; $i++) {\n\t    # $i+1 in 'align' mode is $contig_ix\n\t    $contig_ix = $self->{'_objref'}->change_coord(\"aligned $seqID\",'gapped consensus',$i+1);\n\t    next unless (($contig_ix >= $start) && ($contig_ix <= $end));\n\t    my $r_base = uc(substr($sequence,$i,1));\n\t    my $c_base = uc(substr($consensus,$contig_ix-1,1));\n\t    if ($c_base eq '-') {\n\t\t$confirmed{$orientation}[$contig_ix] = -1;\n\t    } elsif (uc($r_base) eq uc($c_base)) { # Non discrepant region found\n\t\t$confirmed{$orientation}[$contig_ix]++;\n\t    }\n\t} # for ($i=$astart-1; $i<=$aend-1; $i++)\n    } # foreach $seqID (@reads)\n\n    # Locating non-confirmed aligned regions for each orientation in $confirmed registry\n    my ($orientation);\n    my @NCBS = ();\n    foreach $orientation (keys %confirmed) {\n\tmy ($ncbs_start,$ncbs_end);\n\n\tfor ($i=$start; $i<=$end; $i++) {\n\t    if (!defined($ncbs_start) &&\n\t\t(!defined($confirmed{$orientation}[$i]) || ($confirmed{$orientation}[$i] == 0))) {\n\t\t$ncbs_start = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\t    } elsif (defined($ncbs_start) &&\n\t\t     defined($confirmed{$orientation}[$i]) &&\n\t\t     ($confirmed{$orientation}[$i] > 0)) {\n\t\t$ncbs_end   = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i-1);\n\t\tpush(@NCBS, Bio::SeqFeature::Generic->new(-start=>$ncbs_start,\n\t\t\t\t\t\t\t  -end=>$ncbs_end,\n\t\t\t\t\t\t\t  -strand=>$orientation,\n\t\t\t\t\t\t\t  -primary=>\"not_confirmed_on_both_strands\") );\n\t\t$ncbs_start = undef;\n\t    }\n\t}\n\n\tif (defined($ncbs_start)) { # NCBS at the end of contig\n\t    $ncbs_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$end);\n\t    push(@NCBS, Bio::SeqFeature::Generic->new(-start=>$ncbs_start,\n\t\t\t\t\t\t      -end=>$ncbs_end,\n\t\t\t\t\t\t      -strand=>$orientation,\n\t\t\t\t\t\t      -primary=>'not_confirmed_on_both_strands') );\n\t}\n    }\n\n    return @NCBS;\n}\n\n=head2 single_strand\n\n Title     : single_strand\n Usage     : my $sfc = $ContigAnal->single_strand();\n Function  : \n\n             Locates all regions covered by aligned sequences only in\n             one of the two strands, i.e., regions for which aligned\n             sequence's strand() method returns +1 or -1 for all\n             sequences.\n\n Returns   : an array of Bio::SeqFeature::Generic objects\n Args      : optional arguments are\n             -start : start of interval that will be analyzed\n             -end   : start of interval that will be analyzed\n             -type  : coordinate system type for interval\n\n\n#'\nsub single_strand {\n    my ($self,@args) = shift; # Package reference\n\n    my ($start,$end,$type) = \n\t$self->_rearrange([qw(START END TYPE)],@args);\n\n    # Changing coordinates to gap mode align (consed: consensus sequence with alignments)\n    $type  = 'gapped consensus' unless(defined($type));\n    $start = 1 unless (defined($start));\n    if (defined($type) && $type ne 'gapped consensus') {\n\t$start = $self->{'objref'}->change_coord($type,'gapped consensus',$start);\n\t$end   = $self->{'objref'}->change_coord($type,'gapped consensus',$end) if (defined($end));\n    }\n    ($end) = $self->{'_objref'}->get_consensus_length unless (defined($end));\n\n    # Loading complete list of coordinates for aligned sequences\n    my $sfc = $self->{'_objref'}->get_features_collection();\n    my @forward = grep { $_->primary_tag =~ /^_aligned_coord:/ } \n    $sfc->features_in_range(-start=>$start,\n\t\t\t    -end=>$end,\n\t\t\t    -contain=>0,\n\t\t\t    -strand=>1,\n\t\t\t    -strandmatch=>'strong');\n    my @reverse = grep { $_->primary_tag =~ /^_aligned_coord:/ } \n    $sfc->features_in_range(-start=>$start,\n\t\t\t    -end=>$end,\n\t\t\t    -contain=>0,\n\t\t\t    -strand=>-1,\n\t\t\t    -strandmatch=>'strong');\n    # Merging overlapping features\n    @forward = $self->_merge_overlapping_features(@forward);\n    @reverse = $self->_merge_overlapping_features(@reverse);\n\n    # Finding single stranded regions\n    my ($length) = $self->{'_objref'}->get_consensus_length;\n    $length  = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$length);\n    @forward = $self->_complementary_features_list(1,$length,@forward);\n    @reverse = $self->_complementary_features_list(1,$length,@reverse);\n\n    my @SS = ();\n    foreach my $feat (@forward, @reverse) {\n\t$feat->primary_tag('single_strand_region');\n\tpush(@SS,$feat);\n    }\n\n    return @SS;\n}\n\n=head1 Internal Methods\n\n=head2 _merge_overlapping_features\n\n Title     : _merge_overlapping_features\n Usage     : my @feat = $ContigAnal->_merge_overlapping_features(@features);\n Function  : Merge all overlapping features into features\n             that hold original features as sub-features\n Returns   : array of Bio::SeqFeature::Generic objects\n Args      : array of Bio::SeqFeature::Generic objects","label":"_merge_overlapping_features($self,@feat)"},"detail":"($self,@feat)","definition":"sub","containerName":"main::","children":[{"containerName":"_merge_overlapping_features","definition":"my","name":"$self","localvar":"my","kind":13,"line":486},{"kind":13,"line":486,"name":"@feat","containerName":"_merge_overlapping_features"},{"containerName":"_merge_overlapping_features","name":"$self","kind":13,"line":488},{"kind":12,"line":488,"name":"throw_not_implemented","containerName":"_merge_overlapping_features"}],"line":485,"kind":12},{"range":{"start":{"character":0,"line":505},"end":{"line":509,"character":9999}},"name":"_complementary_features_list","signature":{"parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"},{"label":"@feat"}],"documentation":"__END__\n# $Id: ContigAnalysis.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::ContigAnalysis\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::ContigAnalysis - \n    Perform analysis on sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::ContigAnalysis;\n\n    # Assembly loading methods\n    my $ca = Bio::Assembly::ContigAnalysis->new( -contig=>$contigOBJ );\n\n    my @lcq = $ca->low_consensus_quality;\n    my @hqd = $ca->high_quality_discrepancies;\n    my @ss  = $ca->single_strand_regions;\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, when\nthe sequences in a pair may be aligned. It may also include a\nconsensus sequence. Bio::Assembly::ContigAnalysis is a module\nholding a collection of methods to analyze contig objects. It was\ndeveloped around the Bio::Assembly::Contig implementation of contigs and\ncan not work with another contig interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nEmail: rfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::ContigAnalysis;\n\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::ContigAnalysis->new(-contig=>$contigOBJ);\n Function  : Creates a new contig analysis object\n Returns   : Bio::Assembly::ContigAnalysis\n Args      :\n             -contig : a Bio::Assembly::Contig object\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($contigOBJ) = $self->_rearrange([qw(CONTIG)],@args);\n    unless ($contigOBJ->isa(\"Bio::Assembly::Contig\")) {\n\t$self->throw(\"ContigAnal works only on Bio::Assembly::Contig objects\\n\");\n    }\n\n    $self->{'_objref'} = $contigOBJ;\n    return $self;\n}\n\n=head1 Analysis methods\n\n=head2 high_quality_discrepancies\n\n Title     : high_quality_discrepancies\n Usage     : my $sfc = $ContigAnal->high_quality_discrepancies();\n Function  : \n\n             Locates all high quality discrepancies among aligned\n             sequences and the consensus sequence.\n\n             Note: see Bio::Assembly::Contig POD documentation,\n             section \"Coordinate System\", for a definition of\n             available types. Default coordinate system type is\n             \"gapped consensus\", i.e. consensus sequence (with gaps)\n             coordinates. If limits are not specified, the entire\n             alignment is analyzed.\n\n Returns   : Bio::SeqFeature::Collection\n Args      : optional arguments are\n             -threshold : cutoff value for low quality (minimum high quality)\n                          Default: 40\n             -ignore    : number of bases that will not be analysed at\n                          both ends of contig aligned elements\n                          Default: 5\n             -start     : start of interval that will be analyzed\n             -end       : start of interval that will be analyzed\n             -type      : coordinate system type for interval\n\n\nsub high_quality_discrepancies {\n    my ($self,@args) = shift; # Package reference\n\n    my ($threshold,$ignore,$start,$end,$type) = \n\t$self->_rearrange([qw(THRESHOLD IGNORE START END TYPE)],@args);\n\n    # Defining default threhold and HQD_ignore\n    $threshold  = 40 unless (defined($threshold));\n    $ignore = 5  unless (defined($ignore));\n    $type = 'gapped consensus' unless (defined($type));\n\n    # Changing input coordinates system (if needed)\n    if (defined $start && $type ne 'gapped consensus') {\n\t$start = $self->{'_objref'}->change_coord($type,'gapped consensus',$start);\n    } elsif (!defined $start) {\n\t$start = 1;\n    }\n    if (defined $end && $type ne 'gapped consensus') {\n\t$end = $self->{'_objref'}->change_coord($type,'gapped consensus',$end);\n    } elsif (!defined $end) {\n\t$end = $self->{'_objref'}->get_consensus_length();\n    }\n\n    # Scanning each read sequence and the contig sequence and\n    # adding discrepancies to Bio::SeqFeature::Collection\n    my @seqIDs = $self->{'_objref'}->get_seq_ids(-start=>$start,\n\t\t\t\t\t\t -end=>$end,\n\t\t\t\t\t\t -type=>$type);\n    my $consensus = $self->{'_objref'}->get_consensus_sequence()->seq;\n\n    my @HQD = ();\n    foreach my $seqID (@seqIDs) {\n\t# Setting aligned read sub-sequence limits and loading data\n\tmy $seq  = $self->{'_objref'}->get_seq_by_name($seqID);\n\tmy $qual = $self->{'_objref'}->get_qual_by_name($seqID);\n\tunless (defined $qual) {\n\t    $self->warn(\"Can't correctly evaluate HQD without aligned sequence qualities for $seqID\");\n\t    next;\n\t}\n\tmy $sequence = $seq->seq;\n\tmy @quality  = @{ $qual->qual };\n\n\t# Scanning the aligned region of each read\n\tmy $seq_ix = 0;\n\tmy $coord = $self->{'_objref'}->get_seq_feat_by_tag($seq,\"_align_clipping:$seqID\");\n    if (!$coord) {\n        $self->warn(\"Read $seqID has no alignment coordinates; considered low quality.\\nSkipping...\");\n        next;\n    }\n\tmy ($astart,$aend) = ($coord->start,$coord->end);\n\t$astart = $astart + $ignore; # Redefining limits to evaluate HQDs (jump $ignore at start)\n\t$aend   = $aend   - $ignore; # Redefining limits to evaluate HQDs (stop $ignore before end)\n\n\tmy ($d_start,$d_end,$i);\n\tfor ($i=$astart-1; $i<=$aend-1; $i++) {\n\t    # Changing coordinate $i+1 from 'gapped consensus' mode to \"aligned $seqID\" (coordinate $seq_ix)\n\t    $seq_ix = $self->{'_objref'}->change_coord('gapped consensus',\"aligned $seqID\",$i+1);\n\t    next unless (($i >= $start) && ($i <= $end));\n\n\t    my $r_base = uc(substr($sequence,$seq_ix-1,1));\n\t    my $c_base = uc(substr($consensus,$i,1));\n\n\t    # Discrepant region start: store $d_start and $type\n\t    (!defined($d_start) &&\n\t     ($r_base ne $c_base) &&\n\t     ($quality[$seq_ix-1] >= $threshold)) && do {\n\t\t $d_start = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i+1);\n\t\t #print $seqID,\" \",$r_base,\" \",$i+1,\" \",$c_base,\" \",$contig_ix-1,\" \",$quality[$i],\" $type\\n\";\n\t\t next;\n\t     };\n\n\t    # Quality change or end of discrepant region: store limits and undef $d_start\n\t    if (defined($d_start) &&\n\t\t(($quality[$seq_ix-1] < $threshold) ||\n\t\t (uc($r_base) eq uc($c_base)))) {\n\t\t$d_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\t\t#print $seqID,\" \",$r_base,\" \",$i+1,\" \",$c_base,\" \",$contig_ix-1,\" \",$quality[$i],\" $type\\n\";\n\t\tpush(@HQD, Bio::SeqFeature::Generic->new(-primary=>\"high_quality_discrepancy:$seqID\",\n\t\t\t\t\t\t\t -start=>$d_start,\n\t\t\t\t\t\t\t -end=>$d_end,\n\t\t\t\t\t\t\t -strand=>$seq->strand()) );\n\t\t$d_start = undef;\n\t\tnext;\n\t    }\n\t} # for ($i=$astart-1; $i<=$aend-1; $i++)\n\n\t# Loading discrepancies located at sub-sequence end, if any.\n\tif (defined($d_start)) {\n\t    $d_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\t    push(@HQD, Bio::SeqFeature::Generic->new(-primary=>\"high_quality_discrepancy:$seqID\",\n\t\t\t\t\t\t     -start=>$d_start,\n\t\t\t\t\t\t     -end=>$d_end,\n\t\t\t\t\t\t     -strand=>$seq->strand()) );\n\t}\n    } # foreach my $seqID (@seqIDs)\n\n    return @HQD;\n}\n\n=head2 low_consensus_quality\n\n Title     : low_consensus_quality\n Usage     : my $sfc = $ContigAnal->low_consensus_quality();\n Function  : Locates all low quality regions in the consensus\n Returns   : an array of Bio::SeqFeature::Generic objects\n Args      : optional arguments are\n             -threshold : cutoff value for low quality (minimum high quality)\n                          Default: 25\n             -start     : start of interval that will be analyzed\n             -end       : start of interval that will be analyzed\n             -type      : coordinate system type for interval\n\n\nsub low_consensus_quality {\n    my ($self,@args) = shift; # Packege reference\n\n    my ($threshold,$start,$end,$type) = \n\t$self->_rearrange([qw(THRESHOLD START END TYPE)],@args);\n\n    # Setting default value for threshold\n    $threshold = 25 unless (defined($threshold));\n\n    # Loading qualities\n    my @quality = @{ $self->{'_objref'}->get_consensus_quality()->qual };\n\n    # Changing coordinates to gap mode noaln (consed: consensus without alignments)\n    $start = 1 unless (defined($start));\n    if (defined $start && defined $type && ($type ne 'gapped consensus')) {\n\t$start = $self->{'objref'}->change_coord($type,'gapped consensus',$start);\n\t$end   = $self->{'objref'}->change_coord($type,'gapped consensus',$end) if (defined($end));\n    }\n    $end = $self->{'_objref'}->get_consensus_length unless (defined $end);\n\n    # Scanning @quality vector and storing intervals limits with base qualities less then\n    # the threshold value\n    my ($lcq_start);\n    my ($i,@LCQ);\n    for ($i=$start-1; $i<=$end-1; $i++) {\n#\tprint $quality[$i],\"\\t\",$i,\"\\n\";\n\tif (!defined($lcq_start) && (($quality[$i] <= $threshold) || ($quality[$i] == 98))) {\n\t    $lcq_start = $i+1;\n\t} elsif (defined($lcq_start) && ($quality[$i] > $threshold)) {\n\t    $lcq_start  = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$lcq_start);\n\t    my $lcq_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\t    push(@LCQ, Bio::SeqFeature::Generic->new(-start=>$lcq_start,\n\t\t\t\t\t\t     -end=>$lcq_end,\n\t\t\t\t\t\t     -primary=>'low_consensus_quality') );\n\t    $lcq_start = undef;\n\t}\n    }\n\n    if (defined $lcq_start) {\n\t$lcq_start  = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$lcq_start);\n\tmy $lcq_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\tpush(@LCQ, Bio::SeqFeature::Generic->new(-start=>$lcq_start,\n\t\t\t\t\t\t -end=>$lcq_end,\n\t\t\t\t\t\t -primary=>'low_consensus_quality') );\n    }\n\n    return @LCQ;\n}\n\n=head2 not_confirmed_on_both_strands\n\n Title     : low_quality_consensus\n Usage     : my $sfc = $ContigAnal->low_quality_consensus();\n Function  : \n\n             Locates all regions whose consensus bases were not\n             confirmed by bases from sequences aligned in both\n             orientations, i.e., in such regions, no bases in aligned\n             sequences of either +1 or -1 strand agree with the\n             consensus bases.\n\n Returns   : an array of Bio::SeqFeature::Generic objects\n Args      : optional arguments are\n             -start : start of interval that will be analyzed\n             -end   : start of interval that will be analyzed\n             -type  : coordinate system type for interval\n\n\nsub not_confirmed_on_both_strands {\n    my ($self,@args) = shift; # Package reference\n\n    my ($start,$end,$type) = \n\t$self->_rearrange([qw(START END TYPE)],@args);\n\n    # Changing coordinates to default system 'align' (contig sequence with alignments)\n    $start = 1 unless (defined($start));\n    if (defined($type) && ($type ne 'gapped consensus')) {\n\t$start = $self->{'_objref'}->change_coord($type,'gapped consensus',$start);\n\t$end   = $self->{'_objref'}->change_coord($type,'gapped consensus',$end) if (defined($end));\n    }\n    $end = $self->{'_objref'}->get_consensus_length unless (defined($end));\n\n    # Scanning alignment\n    my %confirmed = (); # If ($confirmed{$orientation}[$i] > 0) then $i is confirmed in $orientation strand\n    my ($i);\n    my $consensus = $self->{'_objref'}->get_consensus_sequence()->seq;\n    foreach my $seqID ($self->{'_objref'}->get_seq_ids) {\n\t# Setting aligned read sub-sequence limits and loading data\n\tmy $seq = $self->{'_objref'}->get_seq_by_name($seqID);\n\tmy $sequence = $seq->seq;\n\n\t# Scanning the aligned regions of each read and registering confirmed sites\n\tmy $contig_ix = 0;\n\tmy $coord = $self->{'_objref'}->get_seq_feat_by_tag($seq,\"_align_clipping:$seqID\");\n\tmy ($astart,$aend,$orientation) = ($coord->start,$coord->end,$coord->strand);\n\t$astart = $self->{'_objref'}->change_coord('gapped consensus',\"aligned $seqID\",$astart);\n\t$aend   = $self->{'_objref'}->change_coord('gapped consensus',\"aligned $seqID\",$aend);\n\tfor ($i=$astart-1; $i<=$aend-1; $i++) {\n\t    # $i+1 in 'align' mode is $contig_ix\n\t    $contig_ix = $self->{'_objref'}->change_coord(\"aligned $seqID\",'gapped consensus',$i+1);\n\t    next unless (($contig_ix >= $start) && ($contig_ix <= $end));\n\t    my $r_base = uc(substr($sequence,$i,1));\n\t    my $c_base = uc(substr($consensus,$contig_ix-1,1));\n\t    if ($c_base eq '-') {\n\t\t$confirmed{$orientation}[$contig_ix] = -1;\n\t    } elsif (uc($r_base) eq uc($c_base)) { # Non discrepant region found\n\t\t$confirmed{$orientation}[$contig_ix]++;\n\t    }\n\t} # for ($i=$astart-1; $i<=$aend-1; $i++)\n    } # foreach $seqID (@reads)\n\n    # Locating non-confirmed aligned regions for each orientation in $confirmed registry\n    my ($orientation);\n    my @NCBS = ();\n    foreach $orientation (keys %confirmed) {\n\tmy ($ncbs_start,$ncbs_end);\n\n\tfor ($i=$start; $i<=$end; $i++) {\n\t    if (!defined($ncbs_start) &&\n\t\t(!defined($confirmed{$orientation}[$i]) || ($confirmed{$orientation}[$i] == 0))) {\n\t\t$ncbs_start = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\t    } elsif (defined($ncbs_start) &&\n\t\t     defined($confirmed{$orientation}[$i]) &&\n\t\t     ($confirmed{$orientation}[$i] > 0)) {\n\t\t$ncbs_end   = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i-1);\n\t\tpush(@NCBS, Bio::SeqFeature::Generic->new(-start=>$ncbs_start,\n\t\t\t\t\t\t\t  -end=>$ncbs_end,\n\t\t\t\t\t\t\t  -strand=>$orientation,\n\t\t\t\t\t\t\t  -primary=>\"not_confirmed_on_both_strands\") );\n\t\t$ncbs_start = undef;\n\t    }\n\t}\n\n\tif (defined($ncbs_start)) { # NCBS at the end of contig\n\t    $ncbs_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$end);\n\t    push(@NCBS, Bio::SeqFeature::Generic->new(-start=>$ncbs_start,\n\t\t\t\t\t\t      -end=>$ncbs_end,\n\t\t\t\t\t\t      -strand=>$orientation,\n\t\t\t\t\t\t      -primary=>'not_confirmed_on_both_strands') );\n\t}\n    }\n\n    return @NCBS;\n}\n\n=head2 single_strand\n\n Title     : single_strand\n Usage     : my $sfc = $ContigAnal->single_strand();\n Function  : \n\n             Locates all regions covered by aligned sequences only in\n             one of the two strands, i.e., regions for which aligned\n             sequence's strand() method returns +1 or -1 for all\n             sequences.\n\n Returns   : an array of Bio::SeqFeature::Generic objects\n Args      : optional arguments are\n             -start : start of interval that will be analyzed\n             -end   : start of interval that will be analyzed\n             -type  : coordinate system type for interval\n\n\n#'\nsub single_strand {\n    my ($self,@args) = shift; # Package reference\n\n    my ($start,$end,$type) = \n\t$self->_rearrange([qw(START END TYPE)],@args);\n\n    # Changing coordinates to gap mode align (consed: consensus sequence with alignments)\n    $type  = 'gapped consensus' unless(defined($type));\n    $start = 1 unless (defined($start));\n    if (defined($type) && $type ne 'gapped consensus') {\n\t$start = $self->{'objref'}->change_coord($type,'gapped consensus',$start);\n\t$end   = $self->{'objref'}->change_coord($type,'gapped consensus',$end) if (defined($end));\n    }\n    ($end) = $self->{'_objref'}->get_consensus_length unless (defined($end));\n\n    # Loading complete list of coordinates for aligned sequences\n    my $sfc = $self->{'_objref'}->get_features_collection();\n    my @forward = grep { $_->primary_tag =~ /^_aligned_coord:/ } \n    $sfc->features_in_range(-start=>$start,\n\t\t\t    -end=>$end,\n\t\t\t    -contain=>0,\n\t\t\t    -strand=>1,\n\t\t\t    -strandmatch=>'strong');\n    my @reverse = grep { $_->primary_tag =~ /^_aligned_coord:/ } \n    $sfc->features_in_range(-start=>$start,\n\t\t\t    -end=>$end,\n\t\t\t    -contain=>0,\n\t\t\t    -strand=>-1,\n\t\t\t    -strandmatch=>'strong');\n    # Merging overlapping features\n    @forward = $self->_merge_overlapping_features(@forward);\n    @reverse = $self->_merge_overlapping_features(@reverse);\n\n    # Finding single stranded regions\n    my ($length) = $self->{'_objref'}->get_consensus_length;\n    $length  = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$length);\n    @forward = $self->_complementary_features_list(1,$length,@forward);\n    @reverse = $self->_complementary_features_list(1,$length,@reverse);\n\n    my @SS = ();\n    foreach my $feat (@forward, @reverse) {\n\t$feat->primary_tag('single_strand_region');\n\tpush(@SS,$feat);\n    }\n\n    return @SS;\n}\n\n=head1 Internal Methods\n\n=head2 _merge_overlapping_features\n\n Title     : _merge_overlapping_features\n Usage     : my @feat = $ContigAnal->_merge_overlapping_features(@features);\n Function  : Merge all overlapping features into features\n             that hold original features as sub-features\n Returns   : array of Bio::SeqFeature::Generic objects\n Args      : array of Bio::SeqFeature::Generic objects\n\n\nsub _merge_overlapping_features {\n    my ($self,@feat) = @_;\n\n    $self->throw_not_implemented();\n}\n\n=head2 _complementary_features_list\n\n Title     : _complementary_features_list\n Usage     : @feat = $ContigAnal->_complementary_features_list($start,$end,@features);\n Function  : Build a list of features for regions\n             not covered by features in @features array\n Returns   : array of Bio::SeqFeature::Generic objects\n Args      : \n             $start    : [integer] start of first output feature\n             $end      : [integer] end of last output feature\n             @features : array of Bio::SeqFeature::Generic objects","label":"_complementary_features_list($self,$start,$end,@feat)"},"detail":"($self,$start,$end,@feat)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":506,"name":"$self","definition":"my","containerName":"_complementary_features_list","localvar":"my"},{"name":"$start","containerName":"_complementary_features_list","line":506,"kind":13},{"containerName":"_complementary_features_list","name":"$end","line":506,"kind":13},{"name":"@feat","containerName":"_complementary_features_list","kind":13,"line":506},{"line":508,"kind":13,"containerName":"_complementary_features_list","name":"$self"},{"name":"throw_not_implemented","containerName":"_complementary_features_list","kind":12,"line":508}],"line":505,"kind":12}]}