{"version":5,"vars":[{"name":"base","containerName":"","line":89,"kind":2},{"range":{"end":{"character":9999,"line":113},"start":{"line":102,"character":0}},"name":"new","line":102,"children":[{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":103},{"kind":13,"line":103,"name":"@args","containerName":"new"},{"kind":13,"line":105,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":105,"containerName":"new","name":"$class"},{"containerName":"new","name":"@args","kind":13,"line":105},{"localvar":"my","name":"$value","definition":"my","containerName":"new","line":107,"kind":13},{"name":"$tag","containerName":"new","kind":13,"line":107},{"kind":13,"line":107,"name":"$self","containerName":"new"},{"line":107,"kind":12,"containerName":"new","name":"_rearrange"},{"containerName":"new","name":"@args","kind":13,"line":107},{"name":"$self","containerName":"new","kind":13,"line":108},{"containerName":"new","name":"$value","kind":13,"line":109},{"name":"$self","containerName":"new","line":109,"kind":13},{"name":"value","containerName":"new","kind":12,"line":109},{"name":"$value","containerName":"new","kind":13,"line":109},{"line":110,"kind":13,"name":"$tag","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":110},{"kind":12,"line":110,"name":"tagname","containerName":"new"},{"containerName":"new","name":"$tag","line":110,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":112}],"kind":12,"detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: StructuredValue.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::StructuredValue\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::StructuredValue - A scalar with embedded structured\ninformation\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::StructuredValue;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n   my $sv = Bio::Annotation::StructuredValue->new(-value => 'someval');\n   $col->add_Annotation('tagname', $sv);\n\n=head1 DESCRIPTION\n\nScalar value annotation object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nor the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::StructuredValue;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Annotation::SimpleValue);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::StructuredValue->new();\n Function: Instantiate a new StructuredValue object\n Returns : Bio::Annotation::StructuredValue object\n Args    : -value => $value to initialize the object data field [optional]\n           -tagname => $tag to initialize the tagname [optional]","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","definition":"sub"},{"kind":12,"line":105,"name":"SUPER","containerName":"new"},{"range":{"end":{"line":135,"character":9999},"start":{"character":0,"line":131}},"name":"as_text","line":131,"children":[{"line":132,"kind":13,"localvar":"my","containerName":"as_text","name":"$self","definition":"my"},{"name":"$self","containerName":"as_text","kind":13,"line":134},{"line":134,"kind":12,"containerName":"as_text","name":"value"}],"kind":12,"detail":"($self)","signature":{"label":"as_text($self)","documentation":"1;\n# $Id: StructuredValue.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::StructuredValue\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::StructuredValue - A scalar with embedded structured\ninformation\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::StructuredValue;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n   my $sv = Bio::Annotation::StructuredValue->new(-value => 'someval');\n   $col->add_Annotation('tagname', $sv);\n\n=head1 DESCRIPTION\n\nScalar value annotation object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nor the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::StructuredValue;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Annotation::SimpleValue);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::StructuredValue->new();\n Function: Instantiate a new StructuredValue object\n Returns : Bio::Annotation::StructuredValue object\n Args    : -value => $value to initialize the object data field [optional]\n           -tagname => $tag to initialize the tagname [optional]\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   \n   my ($value,$tag) = $self->_rearrange([qw(VALUE TAGNAME)], @args);\n   $self->{'values'} = [];\n   defined $value  && $self->value($value);\n   defined $tag    && $self->tagname($tag);\n\n   return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: return the string \"Value: $v\" where $v is the value\n Returns : string\n Args    : none","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub"},{"localvar":"my","definition":"my","name":"%DEFAULT_CB","containerName":null,"line":154,"kind":13},{"containerName":"main::","name":"value","line":154,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,$cb)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$cb"}],"label":"display_text($self,$cb)"},"kind":12,"line":156,"children":[{"containerName":"display_text","definition":"my","name":"$self","localvar":"my","kind":13,"line":157},{"name":"$cb","containerName":"display_text","line":157,"kind":13},{"name":"$cb","containerName":"display_text","line":158,"kind":13},{"kind":13,"line":158,"name":"$DEFAULT_CB","containerName":"display_text"},{"containerName":"display_text","name":"$self","line":159,"kind":13},{"name":"throw","containerName":"display_text","kind":12,"line":159},{"containerName":"display_text","name":"$cb","line":159,"kind":13},{"line":160,"kind":13,"containerName":"display_text","name":"$cb"},{"kind":13,"line":160,"containerName":"display_text","name":"$self"}],"name":"display_text","range":{"end":{"character":9999,"line":161},"start":{"character":0,"line":156}}},{"range":{"start":{"character":0,"line":177},"end":{"character":9999,"line":182}},"name":"hash_tree","signature":{"label":"hash_tree($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: StructuredValue.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::StructuredValue\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::StructuredValue - A scalar with embedded structured\ninformation\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::StructuredValue;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n   my $sv = Bio::Annotation::StructuredValue->new(-value => 'someval');\n   $col->add_Annotation('tagname', $sv);\n\n=head1 DESCRIPTION\n\nScalar value annotation object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nor the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::StructuredValue;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Annotation::SimpleValue);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::StructuredValue->new();\n Function: Instantiate a new StructuredValue object\n Returns : Bio::Annotation::StructuredValue object\n Args    : -value => $value to initialize the object data field [optional]\n           -tagname => $tag to initialize the tagname [optional]\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   \n   my ($value,$tag) = $self->_rearrange([qw(VALUE TAGNAME)], @args);\n   $self->{'values'} = [];\n   defined $value  && $self->value($value);\n   defined $tag    && $self->tagname($tag);\n\n   return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: return the string \"Value: $v\" where $v is the value\n Returns : string\n Args    : none\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return \"Value: \".$self->value;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->value || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   : my $hashtree = $value->hash_tree\n Function: For supporting the AnnotationI interface just returns the value\n           as a hashref with the key 'value' pointing to the value\n Returns : hashrf\n Args    : none"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"hash_tree","name":"$self","definition":"my","line":178,"kind":13},{"kind":13,"line":180,"containerName":"hash_tree","name":"$h","definition":"my","localvar":"my"},{"name":"$h","containerName":"hash_tree","kind":13,"line":181},{"name":"$self","containerName":"hash_tree","kind":13,"line":181},{"line":181,"kind":12,"containerName":"hash_tree","name":"value"}],"line":177,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: StructuredValue.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::StructuredValue\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::StructuredValue - A scalar with embedded structured\ninformation\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::StructuredValue;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n   my $sv = Bio::Annotation::StructuredValue->new(-value => 'someval');\n   $col->add_Annotation('tagname', $sv);\n\n=head1 DESCRIPTION\n\nScalar value annotation object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nor the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::StructuredValue;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Annotation::SimpleValue);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::StructuredValue->new();\n Function: Instantiate a new StructuredValue object\n Returns : Bio::Annotation::StructuredValue object\n Args    : -value => $value to initialize the object data field [optional]\n           -tagname => $tag to initialize the tagname [optional]\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   \n   my ($value,$tag) = $self->_rearrange([qw(VALUE TAGNAME)], @args);\n   $self->{'values'} = [];\n   defined $value  && $self->value($value);\n   defined $tag    && $self->tagname($tag);\n\n   return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: return the string \"Value: $v\" where $v is the value\n Returns : string\n Args    : none\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return \"Value: \".$self->value;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->value || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   : my $hashtree = $value->hash_tree\n Function: For supporting the AnnotationI interface just returns the value\n           as a hashref with the key 'value' pointing to the value\n Returns : hashrf\n Args    : none\n\n\n\nsub hash_tree{\n   my ($self) = @_;\n\n   my $h = {};\n   $h->{'value'} = $self->value;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to AnnotationCollection when adding this object.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"tagname($self,$value)"},"kind":12,"line":199,"children":[{"localvar":"my","containerName":"tagname","definition":"my","name":"$self","line":200,"kind":13},{"line":200,"kind":13,"containerName":"tagname","name":"$value"},{"kind":13,"line":201,"containerName":"tagname","name":"$value"},{"containerName":"tagname","name":"$self","kind":13,"line":202},{"kind":13,"line":202,"containerName":"tagname","name":"$value"},{"kind":13,"line":204,"name":"$self","containerName":"tagname"}],"name":"tagname","range":{"end":{"line":205,"character":9999},"start":{"character":0,"line":199}}},{"name":"value","range":{"end":{"line":257,"character":9999},"start":{"character":0,"line":243}},"containerName":"main::","definition":"sub","detail":"($self,$value,@args)","signature":{"documentation":"1;\n# $Id: StructuredValue.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::StructuredValue\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::StructuredValue - A scalar with embedded structured\ninformation\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::StructuredValue;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n   my $sv = Bio::Annotation::StructuredValue->new(-value => 'someval');\n   $col->add_Annotation('tagname', $sv);\n\n=head1 DESCRIPTION\n\nScalar value annotation object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nor the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::StructuredValue;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Annotation::SimpleValue);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::StructuredValue->new();\n Function: Instantiate a new StructuredValue object\n Returns : Bio::Annotation::StructuredValue object\n Args    : -value => $value to initialize the object data field [optional]\n           -tagname => $tag to initialize the tagname [optional]\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   \n   my ($value,$tag) = $self->_rearrange([qw(VALUE TAGNAME)], @args);\n   $self->{'values'} = [];\n   defined $value  && $self->value($value);\n   defined $tag    && $self->tagname($tag);\n\n   return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: return the string \"Value: $v\" where $v is the value\n Returns : string\n Args    : none\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return \"Value: \".$self->value;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->value || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   : my $hashtree = $value->hash_tree\n Function: For supporting the AnnotationI interface just returns the value\n           as a hashref with the key 'value' pointing to the value\n Returns : hashrf\n Args    : none\n\n\n\nsub hash_tree{\n   my ($self) = @_;\n\n   my $h = {};\n   $h->{'value'} = $self->value;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to AnnotationCollection when adding this object.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'tagname'} = $value;\n    }\n    return $self->{'tagname'};\n}\n\n\n=head1 Specific accessors for StructuredValue\n\n\n=head2 value\n\n Title   : value\n Usage   : $obj->value($newval)\n Function: Get/set the value for this annotation.\n\n           Set mode is here only to retain compatibility with\n           SimpleValue. It is equivalent to calling\n           add_value([0], $newval).\n\n           In get mode, this implementation allows to pass additional\n           parameters that control how the structured annotation\n           components will be joined together to form a\n           string. Recognized are presently\n               -joins     a reference to an array of join strings, the\n                          elements at index i applying to joining\n                          annotations at dimension i. The last element\n                          will be re-used for dimensions higher than i.\n                          Defaults to ['; '].\n               -brackets  a reference to an array of two strings\n                          denoting the opening and closing brackets for\n                          the elements of one dimension, if there is\n                          more than one element in the dimension.\n                          Defaults to ['(',')'].\n\n Returns : value of value\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"},{"label":"@args"}],"label":"value($self,$value,@args)"},"kind":12,"line":243,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"value","line":244,"kind":13},{"line":244,"kind":13,"name":"$value","containerName":"value"},{"line":244,"kind":13,"containerName":"value","name":"@args"},{"name":"$self","containerName":"value","kind":13,"line":247},{"name":"add_value","containerName":"value","line":247,"kind":12},{"containerName":"value","name":"$value","kind":13,"line":247},{"containerName":"value","name":"$value","kind":13,"line":247},{"kind":13,"line":247,"name":"@args","containerName":"value"},{"line":250,"kind":13,"containerName":"value","name":"@args"},{"name":"$value","containerName":"value","kind":13,"line":250},{"kind":13,"line":251,"name":"$joins","definition":"my","containerName":"value","localvar":"my"},{"line":251,"kind":13,"containerName":"value","name":"$brackets"},{"kind":13,"line":252,"name":"$self","containerName":"value"},{"containerName":"value","name":"_rearrange","kind":12,"line":252},{"name":"@args","containerName":"value","line":252,"kind":13},{"containerName":"value","name":"$joins","line":253,"kind":13},{"kind":13,"line":253,"name":"$joins","containerName":"value"},{"containerName":"value","name":"$brackets","line":254,"kind":13},{"name":"$brackets","containerName":"value","line":254,"kind":13},{"definition":"my","name":"$txt","containerName":"value","localvar":"my","kind":13,"line":255},{"containerName":"value","name":"$self","kind":13,"line":255},{"kind":13,"line":255,"name":"$joins","containerName":"value"},{"name":"$brackets","containerName":"value","kind":13,"line":255},{"containerName":"value","name":"$self","kind":13,"line":257}]},{"line":255,"kind":12,"name":"_to_text"},{"containerName":null,"name":"@brackets","line":258,"kind":13},{"kind":13,"line":258,"containerName":null,"name":"@brackets"},{"localvar":"my","name":"$re","definition":"my","containerName":null,"line":259,"kind":13},{"name":"@brackets","containerName":null,"line":259,"kind":13},{"line":260,"kind":13,"containerName":null,"name":"@brackets"},{"containerName":null,"name":"@brackets","line":260,"kind":13},{"name":"$txt","containerName":null,"kind":13,"line":261},{"containerName":null,"name":"$txt","line":263,"kind":13},{"range":{"end":{"line":283,"character":9999},"start":{"line":266,"character":0}},"name":"_to_text","line":266,"children":[{"line":267,"kind":13,"localvar":"my","definition":"my","name":"$arr","containerName":"_to_text"},{"kind":13,"line":267,"name":"$joins","containerName":"_to_text"},{"kind":13,"line":267,"containerName":"_to_text","name":"$brackets"},{"kind":13,"line":267,"name":"$rec_n","containerName":"_to_text"},{"line":269,"kind":13,"containerName":"_to_text","name":"$rec_n"},{"kind":13,"line":269,"name":"$rec_n","containerName":"_to_text"},{"kind":13,"line":270,"name":"$i","definition":"my","containerName":"_to_text","localvar":"my"},{"containerName":"_to_text","name":"$rec_n","line":270,"kind":13},{"kind":13,"line":270,"name":"$joins","containerName":"_to_text"},{"name":"$joins","containerName":"_to_text","line":270,"kind":13},{"containerName":"_to_text","name":"$rec_n","kind":13,"line":270},{"localvar":"my","definition":"my","name":"$txt","containerName":"_to_text","line":271,"kind":13},{"name":"$joins","containerName":"_to_text","line":271,"kind":13},{"line":271,"kind":13,"name":"$i","containerName":"_to_text"},{"kind":13,"line":275,"containerName":"_to_text","name":"$joins"},{"kind":13,"line":275,"name":"$brackets","containerName":"_to_text"},{"containerName":"_to_text","name":"$rec_n","line":275,"kind":13},{"kind":12,"line":276,"containerName":"_to_text","name":"value"},{"containerName":"_to_text","name":"$arr","line":278,"kind":13},{"containerName":"_to_text","name":"$rec_n","line":279,"kind":13},{"line":279,"kind":13,"name":"$arr","containerName":"_to_text"},{"name":"$txt","containerName":"_to_text","kind":13,"line":280},{"name":"$brackets","containerName":"_to_text","kind":13,"line":280},{"name":"$txt","containerName":"_to_text","line":280,"kind":13},{"containerName":"_to_text","name":"$brackets","line":280,"kind":13},{"kind":13,"line":282,"name":"$txt","containerName":"_to_text"}],"kind":12,"detail":"($arr,$joins,$brackets,$rec_n)","signature":{"documentation":"","parameters":[{"label":"$arr"},{"label":"$joins"},{"label":"$brackets"},{"label":"$rec_n"}],"label":"_to_text($arr,$joins,$brackets,$rec_n)"},"containerName":"main::","definition":"sub"},{"range":{"end":{"character":9999,"line":302},"start":{"line":299,"character":0}},"name":"get_values","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_values","line":300,"kind":13},{"kind":13,"line":302,"name":"$self","containerName":"get_values"}],"line":299,"kind":12},{"detail":"($self)","signature":{"documentation":"1;\n# $Id: StructuredValue.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::StructuredValue\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::StructuredValue - A scalar with embedded structured\ninformation\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::StructuredValue;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n   my $sv = Bio::Annotation::StructuredValue->new(-value => 'someval');\n   $col->add_Annotation('tagname', $sv);\n\n=head1 DESCRIPTION\n\nScalar value annotation object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nor the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::StructuredValue;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Annotation::SimpleValue);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::StructuredValue->new();\n Function: Instantiate a new StructuredValue object\n Returns : Bio::Annotation::StructuredValue object\n Args    : -value => $value to initialize the object data field [optional]\n           -tagname => $tag to initialize the tagname [optional]\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   \n   my ($value,$tag) = $self->_rearrange([qw(VALUE TAGNAME)], @args);\n   $self->{'values'} = [];\n   defined $value  && $self->value($value);\n   defined $tag    && $self->tagname($tag);\n\n   return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: return the string \"Value: $v\" where $v is the value\n Returns : string\n Args    : none\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return \"Value: \".$self->value;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->value || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   : my $hashtree = $value->hash_tree\n Function: For supporting the AnnotationI interface just returns the value\n           as a hashref with the key 'value' pointing to the value\n Returns : hashrf\n Args    : none\n\n\n\nsub hash_tree{\n   my ($self) = @_;\n\n   my $h = {};\n   $h->{'value'} = $self->value;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to AnnotationCollection when adding this object.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'tagname'} = $value;\n    }\n    return $self->{'tagname'};\n}\n\n\n=head1 Specific accessors for StructuredValue\n\n\n=head2 value\n\n Title   : value\n Usage   : $obj->value($newval)\n Function: Get/set the value for this annotation.\n\n           Set mode is here only to retain compatibility with\n           SimpleValue. It is equivalent to calling\n           add_value([0], $newval).\n\n           In get mode, this implementation allows to pass additional\n           parameters that control how the structured annotation\n           components will be joined together to form a\n           string. Recognized are presently\n               -joins     a reference to an array of join strings, the\n                          elements at index i applying to joining\n                          annotations at dimension i. The last element\n                          will be re-used for dimensions higher than i.\n                          Defaults to ['; '].\n               -brackets  a reference to an array of two strings\n                          denoting the opening and closing brackets for\n                          the elements of one dimension, if there is\n                          more than one element in the dimension.\n                          Defaults to ['(',')'].\n\n Returns : value of value\n Args    : newvalue (optional)\n\n\n\nsub value{\n    my ($self,$value,@args) = @_;\n\n    # set mode?\n    return $self->add_value([0], $value) if defined($value) && (@args == 0);\n    # no, get mode\n    # determine joins and brackets\n    unshift(@args, $value);\n    my ($joins, $brackets) =\n\t$self->_rearrange([qw(JOINS BRACKETS)], @args);\n    $joins = ['; '] unless $joins;\n    $brackets = ['(', ')'] unless $brackets;\n    my $txt = &_to_text($self->{'values'}, $joins, $brackets);\n    # if there's only brackets at the start and end, remove them\n    if((@{$self->{'values'}} == 1) &&\n       (length($brackets->[0]) == 1) && (length($brackets->[1]) == 1)) {\n\tmy $re = '\\\\'.$brackets->[0].\n\t    '([^\\\\'.$brackets->[1].']*)\\\\'.$brackets->[1];\n\t$txt =~ s/^$re$/$1/;\n    }\n    return $txt;\n}\n\nsub _to_text{\n    my ($arr, $joins, $brackets, $rec_n) = @_;\n\n    $rec_n = 0 unless defined($rec_n);\n    my $i = $rec_n >= @$joins ? @$joins-1 : $rec_n;\n    my $txt = join($joins->[$i],\n\t\t   map {\n\t\t       ref($_) ?\n\t\t\t   (ref($_) eq \"ARRAY\" ?\n\t\t\t        &_to_text($_, $joins, $brackets, $rec_n+1) :\n\t\t\t        $_->value()) :\n\t\t\t   $_;\n\t\t   } @$arr);\n    if($rec_n && (@$arr > 1)) {\n\t$txt = $brackets->[0] . $txt . $brackets->[1];\n    }\n    return $txt;\n}\n\n=head2 get_values\n\n Title   : get_values\n Usage   :\n Function: Get the top-level array of values. Each of the elements will\n           recursively be a reference to an array or a scalar, depending\n           on the depth of this structured value annotation.\n Example :\n Returns : an array\n Args    : none\n\n\n\nsub get_values{\n    my $self = shift;\n\n    return @{$self->{'values'}};\n}\n\n=head2 get_all_values\n\n Title   : get_all_values\n Usage   :\n Function: Flattens all values in this structured annotation and\n           returns them as an array.\n Example :\n Returns : the (flat) array of values\n Args    : none","parameters":[{"label":"$self"}],"label":"get_all_values($self)"},"containerName":"main::","definition":"sub","line":318,"children":[{"containerName":"get_all_values","name":"$self","definition":"my","localvar":"my","kind":13,"line":319},{"kind":13,"line":321,"definition":"my","name":"$txt","containerName":"get_all_values","localvar":"my"},{"line":321,"kind":13,"name":"$self","containerName":"get_all_values"},{"name":"value","containerName":"get_all_values","line":321,"kind":12},{"line":322,"kind":13,"name":"$txt","containerName":"get_all_values"}],"kind":12,"range":{"start":{"character":0,"line":318},"end":{"line":323,"character":9999}},"name":"get_all_values"},{"children":[{"localvar":"my","containerName":"add_value","definition":"my","name":"$self","line":354,"kind":13},{"kind":13,"line":354,"name":"$index","containerName":"add_value"},{"containerName":"add_value","name":"@values","kind":13,"line":354},{"line":356,"kind":13,"localvar":"my","containerName":"add_value","definition":"my","name":"$tree"},{"line":356,"kind":13,"name":"$self","containerName":"add_value"},{"kind":13,"line":357,"containerName":"add_value","definition":"my","name":"$lastidx","localvar":"my"},{"localvar":"my","containerName":"add_value","name":"$i","definition":"my","line":358,"kind":13},{"containerName":"add_value","name":"$i","line":359,"kind":13},{"localvar":"my","name":"$subtree","definition":"my","containerName":"add_value","line":360,"kind":13},{"kind":13,"line":361,"name":"$tree","containerName":"add_value"},{"kind":13,"line":361,"containerName":"add_value","name":"$subtree"},{"name":"$tree","containerName":"add_value","kind":13,"line":362},{"line":362,"kind":13,"name":"$subtree","containerName":"add_value"},{"name":"$tree","containerName":"add_value","kind":13,"line":363},{"name":"$i","containerName":"add_value","line":363,"kind":13},{"name":"$tree","containerName":"add_value","kind":13,"line":363},{"containerName":"add_value","name":"$i","kind":13,"line":363},{"name":"$tree","containerName":"add_value","kind":13,"line":364},{"line":364,"kind":13,"containerName":"add_value","name":"$i"},{"name":"$tree","containerName":"add_value","line":364,"kind":13},{"kind":13,"line":364,"name":"$i","containerName":"add_value"},{"containerName":"add_value","name":"$tree","line":365,"kind":13},{"containerName":"add_value","name":"$tree","kind":13,"line":365},{"name":"$i","containerName":"add_value","line":365,"kind":13},{"containerName":"add_value","name":"$self","line":367,"kind":13},{"kind":12,"line":367,"containerName":"add_value","name":"throw"},{"containerName":"add_value","name":"$lastidx","line":370,"kind":13},{"name":"$tree","containerName":"add_value","line":371,"kind":13},{"line":371,"kind":13,"containerName":"add_value","name":"@values"},{"name":"@values","containerName":"add_value","kind":13,"line":372},{"line":373,"kind":13,"containerName":"add_value","name":"$tree"},{"name":"$lastidx","containerName":"add_value","kind":13,"line":373},{"containerName":"add_value","name":"@values","line":373,"kind":13},{"kind":13,"line":375,"name":"$tree","containerName":"add_value"},{"containerName":"add_value","name":"$lastidx","kind":13,"line":375},{"name":"@values","containerName":"add_value","line":375,"kind":13}],"line":353,"kind":12,"signature":{"label":"add_value($self,$index,@values)","documentation":"1;\n# $Id: StructuredValue.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::StructuredValue\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::StructuredValue - A scalar with embedded structured\ninformation\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::StructuredValue;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n   my $sv = Bio::Annotation::StructuredValue->new(-value => 'someval');\n   $col->add_Annotation('tagname', $sv);\n\n=head1 DESCRIPTION\n\nScalar value annotation object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nor the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::StructuredValue;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Annotation::SimpleValue);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::StructuredValue->new();\n Function: Instantiate a new StructuredValue object\n Returns : Bio::Annotation::StructuredValue object\n Args    : -value => $value to initialize the object data field [optional]\n           -tagname => $tag to initialize the tagname [optional]\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   \n   my ($value,$tag) = $self->_rearrange([qw(VALUE TAGNAME)], @args);\n   $self->{'values'} = [];\n   defined $value  && $self->value($value);\n   defined $tag    && $self->tagname($tag);\n\n   return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: return the string \"Value: $v\" where $v is the value\n Returns : string\n Args    : none\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return \"Value: \".$self->value;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->value || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   : my $hashtree = $value->hash_tree\n Function: For supporting the AnnotationI interface just returns the value\n           as a hashref with the key 'value' pointing to the value\n Returns : hashrf\n Args    : none\n\n\n\nsub hash_tree{\n   my ($self) = @_;\n\n   my $h = {};\n   $h->{'value'} = $self->value;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to AnnotationCollection when adding this object.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'tagname'} = $value;\n    }\n    return $self->{'tagname'};\n}\n\n\n=head1 Specific accessors for StructuredValue\n\n\n=head2 value\n\n Title   : value\n Usage   : $obj->value($newval)\n Function: Get/set the value for this annotation.\n\n           Set mode is here only to retain compatibility with\n           SimpleValue. It is equivalent to calling\n           add_value([0], $newval).\n\n           In get mode, this implementation allows to pass additional\n           parameters that control how the structured annotation\n           components will be joined together to form a\n           string. Recognized are presently\n               -joins     a reference to an array of join strings, the\n                          elements at index i applying to joining\n                          annotations at dimension i. The last element\n                          will be re-used for dimensions higher than i.\n                          Defaults to ['; '].\n               -brackets  a reference to an array of two strings\n                          denoting the opening and closing brackets for\n                          the elements of one dimension, if there is\n                          more than one element in the dimension.\n                          Defaults to ['(',')'].\n\n Returns : value of value\n Args    : newvalue (optional)\n\n\n\nsub value{\n    my ($self,$value,@args) = @_;\n\n    # set mode?\n    return $self->add_value([0], $value) if defined($value) && (@args == 0);\n    # no, get mode\n    # determine joins and brackets\n    unshift(@args, $value);\n    my ($joins, $brackets) =\n\t$self->_rearrange([qw(JOINS BRACKETS)], @args);\n    $joins = ['; '] unless $joins;\n    $brackets = ['(', ')'] unless $brackets;\n    my $txt = &_to_text($self->{'values'}, $joins, $brackets);\n    # if there's only brackets at the start and end, remove them\n    if((@{$self->{'values'}} == 1) &&\n       (length($brackets->[0]) == 1) && (length($brackets->[1]) == 1)) {\n\tmy $re = '\\\\'.$brackets->[0].\n\t    '([^\\\\'.$brackets->[1].']*)\\\\'.$brackets->[1];\n\t$txt =~ s/^$re$/$1/;\n    }\n    return $txt;\n}\n\nsub _to_text{\n    my ($arr, $joins, $brackets, $rec_n) = @_;\n\n    $rec_n = 0 unless defined($rec_n);\n    my $i = $rec_n >= @$joins ? @$joins-1 : $rec_n;\n    my $txt = join($joins->[$i],\n\t\t   map {\n\t\t       ref($_) ?\n\t\t\t   (ref($_) eq \"ARRAY\" ?\n\t\t\t        &_to_text($_, $joins, $brackets, $rec_n+1) :\n\t\t\t        $_->value()) :\n\t\t\t   $_;\n\t\t   } @$arr);\n    if($rec_n && (@$arr > 1)) {\n\t$txt = $brackets->[0] . $txt . $brackets->[1];\n    }\n    return $txt;\n}\n\n=head2 get_values\n\n Title   : get_values\n Usage   :\n Function: Get the top-level array of values. Each of the elements will\n           recursively be a reference to an array or a scalar, depending\n           on the depth of this structured value annotation.\n Example :\n Returns : an array\n Args    : none\n\n\n\nsub get_values{\n    my $self = shift;\n\n    return @{$self->{'values'}};\n}\n\n=head2 get_all_values\n\n Title   : get_all_values\n Usage   :\n Function: Flattens all values in this structured annotation and\n           returns them as an array.\n Example :\n Returns : the (flat) array of values\n Args    : none\n\n\n\nsub get_all_values{\n    my ($self) = @_;\n    # we code lazy here and just take advantage of value()\n    my $txt = $self->value(-joins => ['@!@'], -brackets => ['','']);\n    return split(/\\@!\\@/, $txt);\n}\n\n=head2 add_value\n\n Title   : add_value\n Usage   :\n Function: Adds the given value to the structured annotation at the\n           given index.\n\n           The index is multi-dimensional, with the first dimension\n           applying to the first level, and so forth. If a particular\n           dimension or a particular index does not exist yet, it will\n           be created. If it does exist and adding the value would\n           mean replacing a scalar with an array reference, we throw\n           an exception to prevent unintended damage. An index of -1\n           at any dimension means append.\n\n           If an array of values is to be added, it will create an\n           additional dimension at the index specified, unless the\n           last index value is -1, in which case they will all be\n           appended to the last dimension.\n\n Example :\n Returns : none\n Args    : the index at which to add (a reference to an array)\n           the value(s) to add","parameters":[{"label":"$self"},{"label":"$index"},{"label":"@values"}]},"detail":"($self,$index,@values)","definition":"sub","containerName":"main::","range":{"start":{"line":353,"character":0},"end":{"line":378,"character":9999}},"name":"add_value"}]}